const express = require("express");
const cors = require('cors');
const bodyParser = require('body-parser');
const app = express();
const qrcode = require('qrcode-terminal');
const { Client, MessageMedia, LocalAuth } = require('whatsapp-web.js');
// const ipAddress = '127.0.0.1';
// const port = 3001;

app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());
app.use(cors());

let receivedMessages = []; // Arreglo para almacenar los mensajes recibidos

// Endpoint para obtener los mensajes recibidos
app.get('/messages', (req, res) => {
    res.json({ messages: receivedMessages });
});

// Endpoint para enviar mensajes
app.get('/', async function (req, res) {

    const data = req.query.data ? JSON.parse(req.query.data) : undefined;
    if (!data) {
        return res.status(400).json({ error: 'Invalid or missing data parameter' });
    }
    const phone = req.query.type.indexOf("group") === -1 ? data.phone + "@c.us" : data.phone;
    const message = req.query.type.indexOf("group") === -1 ? data.body : data.body;
    const caption = req.query.type.indexOf("group") === -1 ? data.caption : "";

    try {

        if (req.query.type.indexOf("group") === -1) {

            const isRegistered = await client.isRegisteredUser(phone);
            if (!isRegistered) {
                console.log(phone + " => PHONE NOT FOUND");
                return res.status(400).json(phone + " => PHONE NOT FOUND");
            }
        }

        let response = "";

        if (req.query.type == "media") {

            // Get media from URL
            let imageData = await MessageMedia.fromUrl(message);

            console.log(`=== NEW MEDIA MESSAGE ===`)
            console.log(`--- IMG: ${message} send to: ${phone} --- AT: ${new Date()}`);
            response = await client.sendMessage(phone, imageData, { caption: caption })

        } else if (req.query.type == "text") {

            console.log(`=== NEW TEXT MESSAGE ===`)
            console.log(`--- TEXT MSG: ${message} send to: ${phone} --- AT: ${new Date()}`);
            response = await client.sendMessage(phone, message);

        } else if (req.query.type == "groupText") {

            console.log(phone)
            response = await client.sendMessage(phone, message);

        } else {
            console.log("No media specified");
            return res.status(400).json({ error: 'No media specified' });
        }

        return res.json({ message: 'Message sent successfully', response });

    } catch (error) {
        console.error('Error sending the message:', error);
        return res.status(500).json({ error: 'Error sending the message' });
    }

});

// Inicializar el cliente de WhatsApp
// const client = new Client({ authStrategy: new LocalAuth(), puppeteer: { product: "chrome", headless: "new", executablePath: "/usr/bin/chromium-browser", args: ['--no-sandbox'] } });
const client = new Client({ puppeteer: { headless: true } });

client.on('qr', qr => {
    qrcode.generate(qr, { small: true });
});

client.on('ready', () => {
    console.log('Client is ready!');
});

client.on('authenticated', () => {
    console.log('authenticated!');
});

client.on('auth_failure', () => {
    console.log('auth_failure!');
});

client.on('message_create', message => {

    console.log('Message received:', message.body);

    receivedMessages = []; // Clear the array

    // Guardar los mensajes entrantes
    receivedMessages.push({
        id: message.id._serialized,
        from: message.from,
        body: message.body,
        timestamp: message.timestamp,
    });

    console.log(receivedMessages)

    // Ejemplo de respuesta a un comando específico
    if (message.body === '!ping') {
        message.reply('pong');
    }
});

// Manejo de errores
app.use((err, req, res, next) => {
    console.error('Error:', err);
    res.status(500).json({ error: 'Internal server error' });
});

app.listen(3001, () => {
    client.initialize();
    console.log(`Server running on http://localhost:3001`);
});