<?php
// This file was auto-generated from sdk-root/src/data/arc-zonal-shift/2022-10-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the API Reference Guide for zonal shift and zonal autoshift in Amazon Route 53 Application Recovery Controller (Route 53 ARC).</p> <p>You can start a zonal shift to move traffic for a load balancer resource away from an Availability Zone to help your application recover quickly from an impairment in an Availability Zone. For example, you can recover your application from a developer\'s bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone.</p> <p>You can also configure zonal autoshift for supported load balancer resources. Zonal autoshift is a capability in Route 53 ARC where you authorize Amazon Web Services to shift away application resource traffic from an Availability Zone during events, on your behalf, to help reduce your time to recovery. Amazon Web Services starts an autoshift when internal telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.</p> <p>To help make sure that zonal autoshift is safe for your application, you must also configure practice runs when you enable zonal autoshift for a resource. Practice runs start weekly zonal shifts for a resource, to shift traffic for the resource away from an Availability Zone. Practice runs help you to make sure, on a regular basis, that you have enough capacity in all the Availability Zones in an Amazon Web Services Region for your application to continue to operate normally when traffic for a resource is shifted away from one Availability Zone.</p> <important> <p>Before you configure practice runs or enable zonal autoshift, we strongly recommend that you prescale your application resource capacity in all Availability Zones in the Region where your application resources are deployed. You should not rely on scaling on demand when an autoshift or practice run starts. Zonal autoshift, including practice runs, works independently, and does not wait for auto scaling actions to complete. Relying on auto scaling, instead of pre-scaling, can result in loss of availability.</p> <p>If you use auto scaling to handle regular cycles of traffic, we strongly recommend that you configure the minimum capacity of your auto scaling to continue operating normally with the loss of an Availability Zone. </p> </important> <p>Be aware that Route 53 ARC does not inspect the health of individual resources. Amazon Web Services only starts an autoshift when Amazon Web Services telemetry detects that there is an Availability Zone impairment that could potentially impact customers. In some cases, resources might be shifted away that are not experiencing impact.</p> <p>For more information about using zonal shift and zonal autoshift, see the <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html">Amazon Route 53 Application Recovery Controller Developer Guide</a>.</p>', 'operations' => [ 'CancelZonalShift' => '<p>Cancel a zonal shift in Amazon Route 53 Application Recovery Controller. To cancel the zonal shift, specify the zonal shift ID.</p> <p>A zonal shift can be one that you\'ve started for a resource in your Amazon Web Services account in an Amazon Web Services Region, or it can be a zonal shift started by a practice run with zonal autoshift. </p>', 'CreatePracticeRunConfiguration' => '<p>A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch alarms that you create to use with practice runs. The alarms that you specify are an <i>outcome alarm</i>, to monitor application health during practice runs and, optionally, a <i>blocking alarm</i>, to block practice runs from starting.</p> <p>When a resource has a practice run configuration, Route 53 ARC starts zonal shifts for the resource weekly, to shift traffic for practice runs. Practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations when you configure zonal autoshift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'DeletePracticeRunConfiguration' => '<p>Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal autoshift to be enabled.</p>', 'GetAutoshiftObserverNotificationStatus' => '<p>Returns the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.</p> <p>If the status is <code>ENABLED</code>, Route 53 ARC includes all autoshift events when you use the EventBridge pattern <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, Route 53 ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification"> Notifications for practice runs and autoshifts</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'GetManagedResource' => '<p>Get information about a resource that\'s been registered for zonal shifts with Amazon Route 53 Application Recovery Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed resources in Route 53 ARC. You can start zonal shifts and configure zonal autoshift for managed resources.</p> <p>At this time, you can only start a zonal shift or configure zonal autoshift for Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'ListAutoshifts' => '<p>Returns a list of autoshifts for an Amazon Web Services Region. By default, the call returns only <code>ACTIVE</code> autoshifts. Optionally, you can specify the <code>status</code> parameter to return <code>COMPLETED</code> autoshifts. </p>', 'ListManagedResources' => '<p>Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Route 53 Application Recovery Controller, and information about them. The information includes the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones that each resource is deployed in, and the resource name.</p>', 'ListZonalShifts' => '<p>Lists all active and completed zonal shifts in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region. <code>ListZonalShifts</code> returns customer-initiated zonal shifts, as well as practice run zonal shifts that Route 53 ARC started on your behalf for zonal autoshift.</p> <p>The <code>ListZonalShifts</code> operation does not list autoshifts. For more information about listing autoshifts, see <a href="https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html">"&gt;ListAutoshifts</a>.</p>', 'StartZonalShift' => '<p>You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer\'s bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a zonal shift in Route 53 ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services Region. Resources are automatically registered with Route 53 ARC by Amazon Web Services services.</p> <p>At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p> <p>When you start a zonal shift, traffic for the resource is no longer routed to the Availability Zone. The zonal shift is created immediately in Route 53 ARC. However, it can take a short time, typically up to a few minutes, for existing, in-progress connections in the Availability Zone to complete.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html">Zonal shift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'UpdateAutoshiftObserverNotificationStatus' => '<p>Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.</p> <p>If the status is <code>ENABLED</code>, Route 53 ARC includes all autoshift events when you use the EventBridge pattern <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, Route 53 ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification"> Notifications for practice runs and autoshifts</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'UpdatePracticeRunConfiguration' => '<p>Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.</p>', 'UpdateZonalAutoshiftConfiguration' => '<p>The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status. When a resource has a practice run configuation, Route 53 ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.</p> <p>You can update the zonal autoshift autoshift status to enable or disable zonal autoshift. When zonal autoshift is <code>ENABLED</code>, you authorize Amazon Web Services to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away for the required weekly practice runs.</p>', 'UpdateZonalShift' => '<p>Update an active zonal shift in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account. You can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AppliedStatus' => [ 'base' => NULL, 'refs' => [ 'ZonalShiftInResource$appliedStatus' => '<p>The <code>appliedStatus</code> field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The <code>appliedStatus</code> field for a shift that is in progress for a resource can have one of two values: <code>APPLIED</code> or <code>NOT_APPLIED</code>. The zonal shift or autoshift that is currently in effect for the resource has an <code>appliedStatus</code> set to <code>APPLIED</code>.</p> <p>The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts &gt; autoshifts &gt; practice run zonal shifts.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html">How zonal autoshift and practice runs work</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', ], ], 'AppliedWeights' => [ 'base' => NULL, 'refs' => [ 'GetManagedResourceResponse$appliedWeights' => '<p>A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.</p>', 'ManagedResourceSummary$appliedWeights' => '<p>A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.</p>', ], ], 'AutoshiftAppliedStatus' => [ 'base' => NULL, 'refs' => [ 'AutoshiftInResource$appliedStatus' => '<p>The <code>appliedStatus</code> field specifies which application traffic shift is in effect for a resource when there is more than one active traffic shift. There can be more than one application traffic shift in progress at the same time - that is, practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The <code>appliedStatus</code> field for a shift that is in progress for a resource can have one of two values: <code>APPLIED</code> or <code>NOT_APPLIED</code>. The zonal shift or autoshift that is currently in effect for the resource has an <code>appliedStatus</code> set to <code>APPLIED</code>.</p> <p>The overall principle for precedence is that zonal shifts that you start as a customer take precedence autoshifts, which take precedence over practice runs. That is, customer-initiated zonal shifts &gt; autoshifts &gt; practice run zonal shifts.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html">How zonal autoshift and practice runs work</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', ], ], 'AutoshiftExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'AutoshiftSummary$status' => '<p>The status for an autoshift. </p>', 'ListAutoshiftsRequest$status' => '<p>The status of the autoshift.</p>', ], ], 'AutoshiftInResource' => [ 'base' => '<p>A complex structure that lists an autoshift that is currently active for a managed resource and information about the autoshift.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html">How zonal autoshift and practice runs work</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'refs' => [ 'AutoshiftsInResource$member' => NULL, ], ], 'AutoshiftObserverNotificationStatus' => [ 'base' => NULL, 'refs' => [ 'GetAutoshiftObserverNotificationStatusResponse$status' => '<p>The status of autoshift observer notification. If the status is <code>ENABLED</code>, Route 53 ARC includes all autoshift events when you use the Amazon EventBridge pattern <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, Route 53 ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift. </p>', 'UpdateAutoshiftObserverNotificationStatusRequest$status' => '<p>The status to set for autoshift observer notification. If the status is <code>ENABLED</code>, Route 53 ARC includes all autoshift events when you use the Amazon EventBridge pattern <code>Autoshift In Progress</code>. When the status is <code>DISABLED</code>, Route 53 ARC includes only autoshift events for autoshifts when one or more of your resources is included in the autoshift. </p>', 'UpdateAutoshiftObserverNotificationStatusResponse$status' => '<p>The status for autoshift observer notification.</p>', ], ], 'AutoshiftSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAutoshiftsResponse$items' => '<p>The items in the response list.</p>', ], ], 'AutoshiftSummary' => [ 'base' => '<p>Information about an autoshift. Amazon Web Services starts an autoshift to temporarily move traffic for a resource away from an Availability Zone in an Amazon Web Services Region when Amazon Web Services determines that there\'s an issue in the Availability Zone that could potentially affect customers. You can configure zonal autoshift in Route 53 ARC for managed resources in your Amazon Web Services account in a Region. Supported Amazon Web Services resources are automatically registered with Route 53 ARC.</p> <p>Autoshifts are temporary. When the Availability Zone recovers, Amazon Web Services ends the autoshift, and traffic for the resource is no longer directed to the other Availability Zones in the Region.</p> <p>You can stop an autoshift for a resource by disabling zonal autoshift.</p>', 'refs' => [ 'AutoshiftSummaries$member' => NULL, ], ], 'AutoshiftsInResource' => [ 'base' => NULL, 'refs' => [ 'GetManagedResourceResponse$autoshifts' => '<p>An array of the autoshifts that are active for the resource.</p>', 'ManagedResourceSummary$autoshifts' => '<p>An array of the autoshifts that have been completed for a resource.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'AppliedWeights$key' => NULL, 'AutoshiftInResource$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for a resource, when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.</p>', 'AutoshiftSummary$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is shifted away from for a resource when Amazon Web Services starts an autoshift. Until the autoshift ends, traffic for the resource is instead directed to other Availability Zones in the Amazon Web Services Region. An autoshift can end for a resource, for example, when Amazon Web Services ends the autoshift for the Availability Zone or when you disable zonal autoshift for the resource.</p>', 'AvailabilityZones$member' => NULL, 'StartZonalShiftRequest$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.</p>', 'ZonalShift$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.</p>', 'ZonalShiftInResource$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.</p>', 'ZonalShiftSummary$awayFrom' => '<p>The Availability Zone (for example, <code>use1-az1</code>) that traffic is moved away from for a resource when you start a zonal shift. Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in the Amazon Web Services Region.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'ManagedResourceSummary$availabilityZones' => '<p>The Availability Zones that a resource is deployed in.</p>', ], ], 'BlockedDate' => [ 'base' => NULL, 'refs' => [ 'BlockedDates$member' => NULL, ], ], 'BlockedDates' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationRequest$blockedDates' => '<p>Optionally, you can block Route 53 ARC from starting practice runs for a resource on specific calendar dates.</p> <p>The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.</p> <p>For example, if you have an application update scheduled to launch on May 1, 2024, and you don\'t want practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.</p>', 'PracticeRunConfiguration$blockedDates' => '<p>An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for a resource.</p> <p>Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces. </p>', 'UpdatePracticeRunConfigurationRequest$blockedDates' => '<p>Add, change, or remove blocked dates for a practice run in zonal autoshift.</p> <p>Optionally, you can block practice runs for specific calendar dates. The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Separate multiple blocked dates with spaces.</p> <p>For example, if you have an application update scheduled to launch on May 1, 2024, and you don\'t want practice runs to shift traffic away at that time, you could set a blocked date for <code>2024-05-01</code>.</p>', ], ], 'BlockedWindow' => [ 'base' => NULL, 'refs' => [ 'BlockedWindows$member' => NULL, ], ], 'BlockedWindows' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationRequest$blockedWindows' => '<p>Optionally, you can block Route 53 ARC from starting practice runs for specific windows of days and times. </p> <p>The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.</p> <p>For example, say you run business report summaries three days a week. For this scenario, you might set the following recurring days and times as blocked windows, for example: <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.</p>', 'PracticeRunConfiguration$blockedWindows' => '<p>An array of one or more windows of days and times that you can block Route 53 ARC from starting practice runs for a resource.</p> <p>Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.</p>', 'UpdatePracticeRunConfigurationRequest$blockedWindows' => '<p>Add, change, or remove windows of days and times for when you can, optionally, block Route 53 ARC from starting a practice run for a resource.</p> <p>The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you specify dates, that dates and times for practice runs are in UTC. Also, be aware of potential time adjustments that might be required for daylight saving time differences. Separate multiple blocked windows with spaces.</p> <p>For example, say you run business report summaries three days a week. For this scenario, you might set the following recurring days and times as blocked windows, for example: <code>MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30</code>.</p>', ], ], 'CancelZonalShiftRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$reason' => '<p>The reason for the conflict exception.</p>', ], ], 'ControlCondition' => [ 'base' => '<p>A control condition is an alarm that you specify for a practice run. When you configure practice runs with zonal autoshift for a resource, you specify Amazon CloudWatch alarms, which you create in CloudWatch to use with the practice run. The alarms that you specify are an <i>outcome alarm</i>, to monitor application health during practice runs and, optionally, a <i>blocking alarm</i>, to block practice runs from starting or to interrupt a practice run in progress.</p> <p>Control condition alarms do not apply for autoshifts.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html"> Considerations when you configure zonal autoshift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'refs' => [ 'ControlConditions$member' => NULL, ], ], 'ControlConditionType' => [ 'base' => NULL, 'refs' => [ 'ControlCondition$type' => '<p>The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is <code>CLOUDWATCH</code>.</p>', ], ], 'ControlConditions' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationRequest$blockingAlarms' => '<p>An Amazon CloudWatch alarm that you can specify for zonal autoshift practice runs. This alarm blocks Route 53 ARC from starting practice run zonal shifts, and ends a practice run that\'s in progress, when the alarm is in an <code>ALARM</code> state. </p>', 'CreatePracticeRunConfigurationRequest$outcomeAlarms' => '<p>The <i>outcome alarm</i> for practice runs is a required Amazon CloudWatch alarm that you specify that ends a practice run when the alarm is in an <code>ALARM</code> state.</p> <p>Configure the alarm to monitor the health of your application when traffic is shifted away from an Availability Zone during each weekly practice run. You should configure the alarm to go into an <code>ALARM</code> state if your application is impacted by the zonal shift, and you want to stop the zonal shift, to let traffic for the resource return to the Availability Zone.</p>', 'PracticeRunConfiguration$blockingAlarms' => '<p>The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks practice runs when the alarm is in an <code>ALARM</code> state.</p>', 'PracticeRunConfiguration$outcomeAlarms' => '<p>The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the alarm is in an <code>ALARM</code> state.</p>', 'UpdatePracticeRunConfigurationRequest$blockingAlarms' => '<p>Add, change, or remove the Amazon CloudWatch alarm that you optionally specify as the blocking alarm for practice runs.</p>', 'UpdatePracticeRunConfigurationRequest$outcomeAlarms' => '<p>Specify a new the Amazon CloudWatch alarm as the outcome alarm for practice runs.</p>', ], ], 'CreatePracticeRunConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePracticeRunConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePracticeRunConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePracticeRunConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExpiresIn' => [ 'base' => NULL, 'refs' => [ 'StartZonalShiftRequest$expiresIn' => '<p>The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).</p> <p>If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you\'re ready to restore traffic to the Availability Zone.</p> <p>To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:</p> <ul> <li> <p> <b>A lowercase letter m:</b> To specify that the value is in minutes.</p> </li> <li> <p> <b>A lowercase letter h:</b> To specify that the value is in hours.</p> </li> </ul> <p>For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal shift expires in 120 minutes (2 hours).</p>', 'UpdateZonalShiftRequest$expiresIn' => '<p>The length of time that you want a zonal shift to be active, which Route 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary. You can set a zonal shift to be active initially for up to three days (72 hours).</p> <p>If you want to still keep traffic away from an Availability Zone, you can update the zonal shift and set a new expiration. You can also cancel a zonal shift, before it expires, for example, if you\'re ready to restore traffic to the Availability Zone.</p> <p>To set a length of time for a zonal shift to be active, specify a whole number, and then one of the following, with no space:</p> <ul> <li> <p> <b>A lowercase letter m:</b> To specify that the value is in minutes.</p> </li> <li> <p> <b>A lowercase letter h:</b> To specify that the value is in hours.</p> </li> </ul> <p>For example: <code>20h</code> means the zonal shift expires in 20 hours. <code>120m</code> means the zonal shift expires in 120 minutes (2 hours).</p>', ], ], 'ExpiryTime' => [ 'base' => NULL, 'refs' => [ 'AutoshiftSummary$endTime' => '<p>The time (in UTC) when the autoshift ended.</p>', 'ZonalShift$expiryTime' => '<p>The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time. </p> <p>When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you\'re ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.</p>', 'ZonalShiftInResource$expiryTime' => '<p>The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time. </p> <p>When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you\'re ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.</p>', 'ZonalShiftSummary$expiryTime' => '<p>The expiry time (expiration time) for a customer-initiated zonal shift. A zonal shift is temporary and must be set to expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours). However, you can update a zonal shift to set a new expiration at any time. </p> <p>When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts to an expiry time (expiration time). You can cancel a zonal shift when you\'re ready to restore traffic to the Availability Zone, or just wait for it to expire. Or you can update the zonal shift to specify another length of time to expire in.</p>', ], ], 'GetAutoshiftObserverNotificationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutoshiftObserverNotificationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>There was an internal server error.</p>', 'refs' => [], ], 'ListAutoshiftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoshiftsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListZonalShiftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListZonalShiftsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedResourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListManagedResourcesResponse$items' => '<p>The items in the response list.</p>', ], ], 'ManagedResourceSummary' => [ 'base' => '<p>A complex structure for a managed resource in an Amazon Web Services account with information about zonal shifts and autoshifts.</p> <p>A managed resource is a load balancer that has been registered with Route 53 ARC by Elastic Load Balancing. You can start a zonal shift in Route 53 ARC for a managed resource to temporarily move traffic for the resource away from an Availability Zone in an Amazon Web Services Region. You can also configure zonal autoshift for a managed resource.</p> <note> <p>At this time, managed resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p> </note>', 'refs' => [ 'ManagedResourceSummaries$member' => NULL, ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAutoshiftsRequest$maxResults' => '<p>The number of objects that you want to return with this call.</p>', 'ListManagedResourcesRequest$maxResults' => '<p>The number of objects that you want to return with this call.</p>', 'ListZonalShiftsRequest$maxResults' => '<p>The number of objects that you want to return with this call.</p>', ], ], 'PracticeRunConfiguration' => [ 'base' => '<p>A practice run configuration for a resource includes the Amazon CloudWatch alarms that you\'ve specified for a practice run, as well as any blocked dates or blocked windows for the practice run. When a resource has a practice run configuration, Route 53 ARC shifts traffic for the resource weekly for practice runs.</p> <p>Practice runs are required for zonal autoshift. The zonal shifts that Route 53 ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.</p> <p>You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.</p>', 'refs' => [ 'CreatePracticeRunConfigurationResponse$practiceRunConfiguration' => '<p>A practice run configuration for a resource. Configurations include the outcome alarm that you specify for practice runs, and, optionally, a blocking alarm and blocking dates and windows.</p>', 'GetManagedResourceResponse$practiceRunConfiguration' => '<p>The practice run configuration for zonal autoshift that\'s associated with the resource.</p>', 'UpdatePracticeRunConfigurationResponse$practiceRunConfiguration' => '<p>The practice run configuration that was updated.</p>', ], ], 'PracticeRunOutcome' => [ 'base' => NULL, 'refs' => [ 'ZonalShiftInResource$practiceRunOutcome' => '<p>The outcome, or end state, returned for a practice run. The following values can be returned:</p> <ul> <li> <p> <b>PENDING:</b> Outcome value when a practice run is in progress.</p> </li> <li> <p> <b>SUCCEEDED:</b> Outcome value when the outcome alarm specified for the practice run configuration does not go into an <code>ALARM</code> state during the practice run, and the practice run was not interrupted before it completed the expected 30 minute zonal shift.</p> </li> <li> <p> <b>INTERRUPTED:</b> Outcome value when the practice run was stopped before the expected 30 minute zonal shift duration, or there was another problem with the practice run that created an inconclusive outcome.</p> </li> <li> <p> <b>FAILED:</b> Outcome value when the outcome alarm specified for the practice run configuration goes into an <code>ALARM</code> state during the practice run, and the practice run was not interrupted before it completed.</p> </li> </ul> <p>For more information about practice run outcomes, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html"> Considerations when you configure zonal autoshift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'ZonalShiftSummary$practiceRunOutcome' => '<p>The outcome, or end state, of a practice run. The following values can be returned:</p> <ul> <li> <p> <b>PENDING:</b> Outcome value when the practice run is in progress.</p> </li> <li> <p> <b>SUCCEEDED:</b> Outcome value when the outcome alarm specified for the practice run configuration does not go into an <code>ALARM</code> state during the practice run, and the practice run was not interrupted before it completed.</p> </li> <li> <p> <b>INTERRUPTED:</b> Outcome value when the practice run did not run for the expected 30 minutes or there was another problem with the practice run that created an inconclusive outcome.</p> </li> <li> <p> <b>FAILED:</b> Outcome value when the outcome alarm specified for the practice run configuration goes into an <code>ALARM</code> state during the practice run, and the practice run was not interrupted before it completed.</p> </li> </ul> <p>For more information about practice run outcomes, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html"> Considerations when you configure zonal autoshift</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ControlCondition$alarmIdentifier' => '<p>The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.</p>', 'CreatePracticeRunConfigurationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the resource that you configured the practice run for.</p>', 'DeletePracticeRunConfigurationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the resource that you deleted the practice run for.</p>', 'GetManagedResourceResponse$arn' => '<p>The Amazon Resource Name (ARN) for the resource.</p>', 'ManagedResourceSummary$arn' => '<p>The Amazon Resource Name (ARN) for the managed resource.</p>', 'UpdatePracticeRunConfigurationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the resource that you updated the practice run for.</p>', ], ], 'ResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationRequest$resourceIdentifier' => '<p>The identifier of the resource that Amazon Web Services shifts traffic for with a practice run zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'DeletePracticeRunConfigurationRequest$resourceIdentifier' => '<p>The identifier for the resource that you want to delete the practice run configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.</p>', 'GetManagedResourceRequest$resourceIdentifier' => '<p>The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'ListZonalShiftsRequest$resourceIdentifier' => '<p>The identifier for the resource that you want to list zonal shifts for. The identifier is the Amazon Resource Name (ARN) for the resource.</p>', 'StartZonalShiftRequest$resourceIdentifier' => '<p>The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'UpdatePracticeRunConfigurationRequest$resourceIdentifier' => '<p>The identifier for the resource that you want to update the practice run configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.</p>', 'UpdateZonalAutoshiftConfigurationRequest$resourceIdentifier' => '<p>The identifier for the resource that you want to update the zonal autoshift configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.</p>', 'UpdateZonalAutoshiftConfigurationResponse$resourceIdentifier' => '<p>The identifier for the resource that you updated the zonal autoshift configuration for. The identifier is the Amazon Resource Name (ARN) for the resource.</p>', 'ZonalShift$resourceIdentifier' => '<p>The identifier for the resource that Amazon Web Services shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'ZonalShiftInResource$resourceIdentifier' => '<p>The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', 'ZonalShiftSummary$resourceIdentifier' => '<p>The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for the resource.</p> <p>At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationResponse$name' => '<p>The name of the resource that you configured the practice run for. </p>', 'DeletePracticeRunConfigurationResponse$name' => '<p>The name of the resource that you deleted the practice run for. </p>', 'GetManagedResourceResponse$name' => '<p>The name of the resource.</p>', 'ManagedResourceSummary$name' => '<p>The name of the managed resource.</p>', 'UpdatePracticeRunConfigurationResponse$name' => '<p>The name of the resource that you updated the practice run for. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The input requested a resource that was not found.</p>', 'refs' => [], ], 'StartTime' => [ 'base' => NULL, 'refs' => [ 'AutoshiftInResource$startTime' => '<p>The time (UTC) when the autoshift started.</p>', 'AutoshiftSummary$startTime' => '<p>The time (in UTC) when the autoshift started.</p>', 'ZonalShift$startTime' => '<p>The time (UTC) when the zonal shift starts.</p>', 'ZonalShiftInResource$startTime' => '<p>The time (UTC) when the zonal shift starts.</p>', 'ZonalShiftSummary$startTime' => '<p>The time (UTC) when the zonal shift starts.</p>', ], ], 'StartZonalShiftRequest' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$zonalShiftId' => '<p>The zonal shift ID associated with the conflict exception.</p>', 'InternalServerException$message' => NULL, 'ListAutoshiftsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListAutoshiftsResponse$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListManagedResourcesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListManagedResourcesResponse$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListZonalShiftsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListZonalShiftsResponse$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ResourceNotFoundException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'UpdateAutoshiftObserverNotificationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAutoshiftObserverNotificationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePracticeRunConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePracticeRunConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateZonalAutoshiftConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateZonalAutoshiftConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateZonalShiftRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation exception.</p>', ], ], 'Weight' => [ 'base' => NULL, 'refs' => [ 'AppliedWeights$value' => NULL, ], ], 'ZonalAutoshiftStatus' => [ 'base' => NULL, 'refs' => [ 'CreatePracticeRunConfigurationResponse$zonalAutoshiftStatus' => '<p>The status for zonal autoshift for a resource. When you specify <code>ENABLED</code> for the autoshift status, Amazon Web Services shifts traffic away from shifts away application resource traffic from an Availability Zone, on your behalf, when internal telemetry indicates that there is an Availability Zone impairment that could potentially impact customers.</p> <p>When you enable zonal autoshift, you must also configure practice runs for the resource.</p>', 'DeletePracticeRunConfigurationResponse$zonalAutoshiftStatus' => '<p>The status of zonal autoshift for the resource.</p>', 'GetManagedResourceResponse$zonalAutoshiftStatus' => '<p>The status for zonal autoshift for a resource. When the autoshift status is <code>ENABLED</code>, Amazon Web Services shifts traffic for a resource away from an Availability Zone, on your behalf, when Amazon Web Services determines that there\'s an issue in the Availability Zone that could potentially affect customers.</p>', 'ManagedResourceSummary$practiceRunStatus' => '<p>This status tracks whether a practice run configuration exists for a resource. When you configure a practice run for a resource so that a practice run configuration exists, Route 53 ARC sets this value to <code>ENABLED</code>. If a you have not configured a practice run for the resource, or delete a practice run configuration, Route 53 ARC sets the value to <code>DISABLED</code>.</p> <p>Route 53 ARC updates this status; you can\'t set a practice run status to <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'ManagedResourceSummary$zonalAutoshiftStatus' => '<p>The status of autoshift for a resource. When you configure zonal autoshift for a resource, you can set the value of the status to <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'UpdatePracticeRunConfigurationResponse$zonalAutoshiftStatus' => '<p>The zonal autoshift status for the resource that you updated the practice run for.</p>', 'UpdateZonalAutoshiftConfigurationRequest$zonalAutoshiftStatus' => '<p>The zonal autoshift status for the resource that you want to update the zonal autoshift configuration for. Choose <code>ENABLED</code> to authorize Amazon Web Services to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.</p>', 'UpdateZonalAutoshiftConfigurationResponse$zonalAutoshiftStatus' => '<p>The updated zonal autoshift status for the resource.</p>', ], ], 'ZonalShift' => [ 'base' => NULL, 'refs' => [], ], 'ZonalShiftComment' => [ 'base' => NULL, 'refs' => [ 'StartZonalShiftRequest$comment' => '<p>A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.</p>', 'UpdateZonalShiftRequest$comment' => '<p>A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.</p>', 'ZonalShift$comment' => '<p>A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. A new comment overwrites any existing comment string.</p>', 'ZonalShiftInResource$comment' => '<p>A comment that you enter for a customer-initiated zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.</p>', 'ZonalShiftSummary$comment' => '<p>A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is maintained. That is, a new comment overwrites any existing comment string.</p>', ], ], 'ZonalShiftId' => [ 'base' => NULL, 'refs' => [ 'CancelZonalShiftRequest$zonalShiftId' => '<p>The internally-generated identifier of a zonal shift.</p>', 'UpdateZonalShiftRequest$zonalShiftId' => '<p>The identifier of a zonal shift.</p>', 'ZonalShift$zonalShiftId' => '<p>The identifier of a zonal shift.</p>', 'ZonalShiftInResource$zonalShiftId' => '<p>The identifier of a zonal shift.</p>', 'ZonalShiftSummary$zonalShiftId' => '<p>The identifier of a zonal shift.</p>', ], ], 'ZonalShiftInResource' => [ 'base' => '<p>A complex structure that lists the zonal shifts for a managed resource and their statuses for the resource.</p>', 'refs' => [ 'ZonalShiftsInResource$member' => NULL, ], ], 'ZonalShiftStatus' => [ 'base' => NULL, 'refs' => [ 'ListZonalShiftsRequest$status' => '<p>A status for a zonal shift.</p> <p>The <code>Status</code> for a zonal shift can have one of the following values:</p> <ul> <li> <p> <b>ACTIVE</b>: The zonal shift has been started and active.</p> </li> <li> <p> <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).</p> </li> <li> <p> <b>CANCELED</b>: The zonal shift was canceled.</p> </li> </ul>', 'ZonalShift$status' => '<p>A status for a zonal shift.</p> <p>The <code>Status</code> for a zonal shift can have one of the following values:</p> <ul> <li> <p> <b>ACTIVE:</b> The zonal shift has been started and active.</p> </li> <li> <p> <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).</p> </li> <li> <p> <b>CANCELED:</b> The zonal shift was canceled.</p> </li> </ul>', 'ZonalShiftSummary$status' => '<p>A status for a zonal shift.</p> <p>The <code>Status</code> for a zonal shift can have one of the following values:</p> <ul> <li> <p> <b>ACTIVE:</b> The zonal shift has been started and active.</p> </li> <li> <p> <b>EXPIRED:</b> The zonal shift has expired (the expiry time was exceeded).</p> </li> <li> <p> <b>CANCELED:</b> The zonal shift was canceled.</p> </li> </ul>', ], ], 'ZonalShiftSummaries' => [ 'base' => NULL, 'refs' => [ 'ListZonalShiftsResponse$items' => '<p>The items in the response list.</p>', ], ], 'ZonalShiftSummary' => [ 'base' => '<p>Lists information about zonal shifts in Amazon Route 53 Application Recovery Controller, including zonal shifts that you start yourself and zonal shifts that Route 53 ARC starts on your behalf for practice runs with zonal autoshift.</p> <p>Zonal shifts are temporary, including customer-initiated zonal shifts and the zonal autoshift practice run zonal shifts that Route 53 ARC starts weekly, on your behalf. A zonal shift that a customer starts can be active for up to three days (72 hours). A practice run zonal shift has a 30 minute duration.</p>', 'refs' => [ 'ZonalShiftSummaries$member' => NULL, ], ], 'ZonalShiftsInResource' => [ 'base' => NULL, 'refs' => [ 'GetManagedResourceResponse$zonalShifts' => '<p>The zonal shifts that are currently active for a resource. </p>', 'ManagedResourceSummary$zonalShifts' => '<p>An array of the zonal shifts for a resource.</p>', ], ], ],];
