<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agent-runtime/2023-07-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Contains APIs related to model invocation and querying of knowledge bases.</p>', 'operations' => [ 'DeleteAgentMemory' => '<p>Deletes memory from the specified memory identifier.</p>', 'GetAgentMemory' => '<p>Gets the sessions stored in the memory of the agent.</p>', 'InvokeAgent' => '<note> <p>The CLI doesn\'t support streaming operations in Amazon Bedrock, including <code>InvokeAgent</code>.</p> </note> <p>Sends a prompt for the agent to process and respond to. Note the following fields for the request:</p> <ul> <li> <p>To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.</p> </li> <li> <p>To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you follow the agent\'s reasoning process that led it to the information it processed, the actions it took, and the final result it yielded. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.</p> </li> <li> <p>End a conversation by setting <code>endSession</code> to <code>true</code>.</p> </li> <li> <p>In the <code>sessionState</code> object, you can include attributes for the session or prompt or, if you configured an action group to return control, results from invocation of the action group.</p> </li> </ul> <p>The response is returned in the <code>bytes</code> field of the <code>chunk</code> object.</p> <ul> <li> <p>The <code>attribution</code> object contains citations for parts of the response.</p> </li> <li> <p>If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent\'s steps and reasoning process that led it to the response.</p> </li> <li> <p>If the action predicted was configured to return control, the response returns parameters for the action, elicited from the user, in the <code>returnControl</code> field.</p> </li> <li> <p>Errors are also surfaced in the response.</p> </li> </ul>', 'InvokeFlow' => '<p>Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If there\'s an error, the error is returned. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p> <note> <p>The CLI doesn\'t support streaming operations in Amazon Bedrock, including <code>InvokeFlow</code>.</p> </note>', 'Retrieve' => '<p>Queries a knowledge base and retrieves information from it.</p>', 'RetrieveAndGenerate' => '<p>Queries a knowledge base and generates responses based on the retrieved results. The response only cites sources that are relevant to the query.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request is denied because of missing access permissions. Check your permissions and retry your request.</p>', 'refs' => [ 'FlowResponseStream$accessDeniedException' => '<p>The request is denied because of missing access permissions. Check your permissions and retry your request.</p>', 'ResponseStream$accessDeniedException' => '<p>The request is denied because of missing access permissions. Check your permissions and retry your request.</p>', ], ], 'ActionGroupInvocationInput' => [ 'base' => '<p>Contains information about the action group being invoked. For more information about the possible structures, see the InvocationInput tab in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-orchestration.html">OrchestrationTrace</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'InvocationInput$actionGroupInvocationInput' => '<p>Contains information about the action group to be invoked.</p>', ], ], 'ActionGroupInvocationOutput' => [ 'base' => '<p>Contains the JSON-formatted string returned by the API invoked by the action group.</p>', 'refs' => [ 'Observation$actionGroupInvocationOutput' => '<p>Contains the JSON-formatted string returned by the API invoked by the action group.</p>', ], ], 'ActionGroupName' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$actionGroupName' => '<p>The name of the action group.</p>', ], ], 'ActionGroupOutputString' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationOutput$text' => '<p>The JSON-formatted string returned by the API invoked by the action group.</p>', ], ], 'ActionInvocationType' => [ 'base' => NULL, 'refs' => [ 'ApiInvocationInput$actionInvocationType' => '<p>Contains information about the API operation to invoke.</p>', 'FunctionInvocationInput$actionInvocationType' => '<p>Contains information about the function to invoke,</p>', ], ], 'AdditionalModelRequestFields' => [ 'base' => NULL, 'refs' => [ 'ExternalSourcesGenerationConfiguration$additionalModelRequestFields' => '<p> Additional model parameters and their corresponding values not included in the textInferenceConfig structure for an external source. Takes in custom model parameters specific to the language model being used. </p>', 'GenerationConfiguration$additionalModelRequestFields' => '<p> Additional model parameters and corresponding values not included in the textInferenceConfig structure for a knowledge base. This allows users to provide custom model parameters specific to the language model being used. </p>', ], ], 'AdditionalModelRequestFieldsKey' => [ 'base' => NULL, 'refs' => [ 'AdditionalModelRequestFields$key' => NULL, ], ], 'AdditionalModelRequestFieldsValue' => [ 'base' => NULL, 'refs' => [ 'AdditionalModelRequestFields$value' => NULL, ], ], 'AgentAliasId' => [ 'base' => NULL, 'refs' => [ 'DeleteAgentMemoryRequest$agentAliasId' => '<p>The unique identifier of an alias of an agent.</p>', 'GetAgentMemoryRequest$agentAliasId' => '<p>The unique identifier of an alias of an agent.</p>', 'InvokeAgentRequest$agentAliasId' => '<p>The alias of the agent to use.</p>', 'TracePart$agentAliasId' => '<p>The unique identifier of the alias of the agent.</p>', ], ], 'AgentId' => [ 'base' => NULL, 'refs' => [ 'DeleteAgentMemoryRequest$agentId' => '<p>The unique identifier of the agent to which the alias belongs.</p>', 'GetAgentMemoryRequest$agentId' => '<p>The unique identifier of the agent to which the alias belongs.</p>', 'InvokeAgentRequest$agentId' => '<p>The unique identifier of the agent to use.</p>', 'TracePart$agentId' => '<p>The unique identifier of the agent.</p>', ], ], 'AgentVersion' => [ 'base' => NULL, 'refs' => [ 'TracePart$agentVersion' => '<p>The version of the agent.</p>', ], ], 'ApiContentMap' => [ 'base' => NULL, 'refs' => [ 'ApiRequestBody$content' => '<p>The content of the request body. The key of the object in this field is a media type defining the format of the request body.</p>', ], ], 'ApiInvocationInput' => [ 'base' => '<p>Contains information about the API operation that the agent predicts should be called.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControl</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'InvocationInputMember$apiInvocationInput' => '<p>Contains information about the API operation that the agent predicts should be called.</p>', ], ], 'ApiParameter' => [ 'base' => '<p>Information about a parameter to provide to the API request.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'ApiParameters$member' => NULL, ], ], 'ApiParameters' => [ 'base' => NULL, 'refs' => [ 'ApiInvocationInput$parameters' => '<p>The parameters to provide for the API request, as the agent elicited from the user.</p>', ], ], 'ApiPath' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$apiPath' => '<p>The path to the API to call, based off the action group.</p>', 'ApiInvocationInput$apiPath' => '<p>The path to the API operation.</p>', 'ApiResult$apiPath' => '<p>The path to the API operation.</p>', ], ], 'ApiRequestBody' => [ 'base' => '<p>The request body to provide for the API request, as the agent elicited from the user.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'ApiInvocationInput$requestBody' => '<p>The request body to provide for the API request, as the agent elicited from the user.</p>', ], ], 'ApiResult' => [ 'base' => '<p>Contains information about the API operation that was called from the action group and the response body that was returned.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControlInvocationResults</code> of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax">InvokeAgent request</a> </p> </li> </ul>', 'refs' => [ 'InvocationResultMember$apiResult' => '<p>The result from the API response from the action group invocation.</p>', ], ], 'Attribution' => [ 'base' => '<p>Contains citations for a part of an agent response.</p>', 'refs' => [ 'PayloadPart$attribution' => '<p>Contains citations for a part of an agent response.</p>', ], ], 'BadGatewayException' => [ 'base' => '<p>There was an issue with a dependency due to a server issue. Retry your request.</p>', 'refs' => [ 'FlowResponseStream$badGatewayException' => '<p>There was an issue with a dependency due to a server issue. Retry your request.</p>', 'ResponseStream$badGatewayException' => '<p>There was an issue with a dependency due to a server issue. Retry your request.</p>', ], ], 'BedrockModelArn' => [ 'base' => NULL, 'refs' => [ 'ExternalSourcesRetrieveAndGenerateConfiguration$modelArn' => '<p>The modelArn used with the external source wrapper object in the retrieveAndGenerate function.</p>', 'KnowledgeBaseRetrieveAndGenerateConfiguration$modelArn' => '<p>The ARN of the foundation model used to generate a response.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CodeInterpreterInvocationOutput$executionTimeout' => '<p>Indicates if the execution of the code timed out.</p>', 'InvokeAgentRequest$enableTrace' => '<p>Specifies whether to turn on the trace or not to track the agent\'s reasoning process. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.</p>', 'InvokeAgentRequest$endSession' => '<p>Specifies whether to end the session with the agent or not.</p>', 'PreProcessingParsedResponse$isValid' => '<p>Whether the user input is valid or not. If <code>false</code>, the agent doesn\'t proceed to orchestration.</p>', ], ], 'ByteContentBlob' => [ 'base' => NULL, 'refs' => [ 'ByteContentDoc$data' => '<p>The byte value of the file to upload, encoded as a Base-64 string.</p>', 'ByteContentFile$data' => '<p>The raw bytes of the file to attach. The maximum size of all files that is attached is 10MB. You can attach a maximum of 5 files. </p>', ], ], 'ByteContentDoc' => [ 'base' => '<p>This property contains the document to chat with, along with its attributes.</p>', 'refs' => [ 'ExternalSource$byteContent' => '<p>The identifier, contentType, and data of the external source wrapper object.</p>', ], ], 'ByteContentFile' => [ 'base' => '<p>The property contains the file to chat with, along with its attributes.</p>', 'refs' => [ 'FileSource$byteContent' => '<p>The data and the text of the attached files.</p>', ], ], 'Citation' => [ 'base' => '<p>An object containing a segment of the generated response that is based on a source in the knowledge base, alongside information about the source.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>citations</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>citations</code> field</p> </li> </ul>', 'refs' => [ 'Citations$member' => NULL, ], ], 'Citations' => [ 'base' => NULL, 'refs' => [ 'Attribution$citations' => '<p>A list of citations and related information for a part of an agent response.</p>', 'RetrieveAndGenerateResponse$citations' => '<p>A list of segments of the generated response that are based on sources in the knowledge base, alongside information about the sources.</p>', ], ], 'CodeInterpreterInvocationInput' => [ 'base' => '<p>Contains information about the code interpreter being invoked.</p>', 'refs' => [ 'InvocationInput$codeInterpreterInvocationInput' => '<p>Contains information about the code interpreter to be invoked.</p>', ], ], 'CodeInterpreterInvocationOutput' => [ 'base' => '<p>Contains the JSON-formatted string returned by the API invoked by the code interpreter.</p>', 'refs' => [ 'Observation$codeInterpreterInvocationOutput' => '<p>Contains the JSON-formatted string returned by the API invoked by the code interpreter.</p>', ], ], 'ConfirmationState' => [ 'base' => NULL, 'refs' => [ 'ApiResult$confirmationState' => '<p>Controls the API operations or functions to invoke based on the user confirmation.</p>', 'FunctionResult$confirmationState' => '<p>Contains the user confirmation information about the function that was called.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict performing an operation. Resolve the conflict and retry your request.</p>', 'refs' => [ 'FlowResponseStream$conflictException' => '<p>There was a conflict performing an operation. Resolve the conflict and retry your request.</p>', 'ResponseStream$conflictException' => '<p>There was a conflict performing an operation. Resolve the conflict and retry your request.</p>', ], ], 'ContentBody' => [ 'base' => '<p>Contains the body of the API response.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControlInvocationResults</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax">InvokeAgent request</a> </p> </li> </ul>', 'refs' => [ 'ResponseBody$value' => NULL, ], ], 'ContentMap' => [ 'base' => NULL, 'refs' => [ 'RequestBody$content' => '<p>The content in the request body.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'ByteContentDoc$contentType' => '<p>The MIME type of the document contained in the wrapper object.</p>', ], ], 'CreationMode' => [ 'base' => NULL, 'refs' => [ 'ModelInvocationInput$parserMode' => '<p>Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the <code>promptType</code>.</p>', 'ModelInvocationInput$promptCreationMode' => '<p>Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the <code>basePromptTemplate</code> that was set in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.</p>', ], ], 'DateTimestamp' => [ 'base' => '<p>Time Stamp.</p>', 'refs' => [ 'MemorySessionSummary$sessionExpiryTime' => '<p>The time when the memory duration for the session is set to end.</p>', 'MemorySessionSummary$sessionStartTime' => '<p>The start time for this session.</p>', ], ], 'DeleteAgentMemoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentMemoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DependencyFailedException' => [ 'base' => '<p>There was an issue with a dependency. Check the resource configurations and retry the request.</p>', 'refs' => [ 'FlowResponseStream$dependencyFailedException' => '<p>There was an issue with a dependency. Check the resource configurations and retry the request.</p>', 'ResponseStream$dependencyFailedException' => '<p>There was an issue with a dependency. Check the resource configurations and retry the request.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'FlowInputContent$document' => '<p>The input to send to the prompt flow input node.</p>', 'FlowOutputContent$document' => '<p>The content in the output.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseRetrievalResult$score' => '<p>The level of relevance of the result to the query.</p>', ], ], 'ExecutionType' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$executionType' => '<p>How fulfillment of the action is handled. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/action-handle.html">Handling fulfillment of the action</a>.</p>', ], ], 'ExternalSource' => [ 'base' => '<p>The unique external source of the content contained in the wrapper object.</p>', 'refs' => [ 'ExternalSources$member' => NULL, ], ], 'ExternalSourceType' => [ 'base' => NULL, 'refs' => [ 'ExternalSource$sourceType' => '<p>The source type of the external source wrapper object.</p>', ], ], 'ExternalSources' => [ 'base' => NULL, 'refs' => [ 'ExternalSourcesRetrieveAndGenerateConfiguration$sources' => '<p>The document used with the external source wrapper object in the retrieveAndGenerate function.</p>', ], ], 'ExternalSourcesGenerationConfiguration' => [ 'base' => '<p>Contains the generation configuration of the external source wrapper object.</p>', 'refs' => [ 'ExternalSourcesRetrieveAndGenerateConfiguration$generationConfiguration' => '<p>The prompt used with the external source wrapper object with the retrieveAndGenerate function.</p>', ], ], 'ExternalSourcesRetrieveAndGenerateConfiguration' => [ 'base' => '<p>The configurations of the external source wrapper object in the retrieveAndGenerate function.</p>', 'refs' => [ 'RetrieveAndGenerateConfiguration$externalSourcesConfiguration' => '<p>The configuration used with the external source wrapper object in the retrieveAndGenerate function.</p>', ], ], 'FailureReasonString' => [ 'base' => NULL, 'refs' => [ 'FailureTrace$failureReason' => '<p>The reason the interaction failed.</p>', ], ], 'FailureTrace' => [ 'base' => '<p>Contains information about the failure of the interaction.</p>', 'refs' => [ 'Trace$failureTrace' => '<p>Contains information about the failure of the interaction.</p>', ], ], 'FileBody' => [ 'base' => NULL, 'refs' => [ 'OutputFile$bytes' => '<p>The byte count of files that contains response from code interpreter.</p>', ], ], 'FilePart' => [ 'base' => '<p>Contains intermediate response for code interpreter if any files have been generated.</p>', 'refs' => [ 'ResponseStream$files' => '<p>Contains intermediate response for code interpreter if any files have been generated.</p>', ], ], 'FileSource' => [ 'base' => '<p>The source file of the content contained in the wrapper object.</p>', 'refs' => [ 'InputFile$source' => '<p>Specifies where the files are located.</p>', ], ], 'FileSourceType' => [ 'base' => NULL, 'refs' => [ 'FileSource$sourceType' => '<p>The source type of the files to attach.</p>', ], ], 'FileUseCase' => [ 'base' => NULL, 'refs' => [ 'InputFile$useCase' => '<p>Specifies how the source files will be used by the code interpreter.</p>', ], ], 'Files' => [ 'base' => NULL, 'refs' => [ 'CodeInterpreterInvocationInput$files' => '<p>Files that are uploaded for code interpreter to use.</p>', 'CodeInterpreterInvocationOutput$files' => '<p>Contains output files, if generated by code execution.</p>', ], ], 'FilterAttribute' => [ 'base' => '<p>Specifies the name that the metadata attribute must match and the value to which to compare the value of the metadata attribute. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> </p> </li> </ul>', 'refs' => [ 'RetrievalFilter$equals' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value matches the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>animal</code> attribute whose value is <code>cat</code>:</p> <p> <code>"equals": { "key": "animal", "value": "cat" }</code> </p>', 'RetrievalFilter$greaterThan' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is greater than the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>year</code> attribute whose value is greater than <code>1989</code>:</p> <p> <code>"greaterThan": { "key": "year", "value": 1989 }</code> </p>', 'RetrievalFilter$greaterThanOrEquals' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is greater than or equal to the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>year</code> attribute whose value is greater than or equal to <code>1989</code>:</p> <p> <code>"greaterThanOrEquals": { "key": "year", "value": 1989 }</code> </p>', 'RetrievalFilter$in' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is in the list specified in the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>animal</code> attribute that is either <code>cat</code> or <code>dog</code>:</p> <p> <code>"in": { "key": "animal", "value": ["cat", "dog"] }</code> </p>', 'RetrievalFilter$lessThan' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is less than the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>year</code> attribute whose value is less than to <code>1989</code>.</p> <p> <code>"lessThan": { "key": "year", "value": 1989 }</code> </p>', 'RetrievalFilter$lessThanOrEquals' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is less than or equal to the <code>value</code> in this object.</p> <p>The following example would return data sources with an <code>year</code> attribute whose value is less than or equal to <code>1989</code>.</p> <p> <code>"lessThanOrEquals": { "key": "year", "value": 1989 }</code> </p>', 'RetrievalFilter$listContains' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is a list that contains the <code>value</code> as one of its members.</p> <p>The following example would return data sources with an <code>animals</code> attribute that is a list containing a <code>cat</code> member (for example <code>["dog", "cat"]</code>).</p> <p> <code>"listContains": { "key": "animals", "value": "cat" }</code> </p>', 'RetrievalFilter$notEquals' => '<p>Knowledge base data sources that contain a metadata attribute whose name matches the <code>key</code> and whose value doesn\'t match the <code>value</code> in this object are returned.</p> <p>The following example would return data sources that don\'t contain an <code>animal</code> attribute whose value is <code>cat</code>.</p> <p> <code>"notEquals": { "key": "animal", "value": "cat" }</code> </p>', 'RetrievalFilter$notIn' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value isn\'t in the list specified in the <code>value</code> in this object.</p> <p>The following example would return data sources whose <code>animal</code> attribute is neither <code>cat</code> nor <code>dog</code>.</p> <p> <code>"notIn": { "key": "animal", "value": ["cat", "dog"] }</code> </p>', 'RetrievalFilter$startsWith' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value starts with the <code>value</code> in this object. This filter is currently only supported for Amazon OpenSearch Serverless vector stores.</p> <p>The following example would return data sources with an <code>animal</code> attribute starts with <code>ca</code> (for example, <code>cat</code> or <code>camel</code>).</p> <p> <code>"startsWith": { "key": "animal", "value": "ca" }</code> </p>', 'RetrievalFilter$stringContains' => '<p>Knowledge base data sources are returned if they contain a metadata attribute whose name matches the <code>key</code> and whose value is one of the following:</p> <ul> <li> <p>A string that contains the <code>value</code> as a substring. The following example would return data sources with an <code>animal</code> attribute that contains the substring <code>at</code> (for example <code>cat</code>).</p> <p> <code>"stringContains": { "key": "animal", "value": "at" }</code> </p> </li> <li> <p>A list with a member that contains the <code>value</code> as a substring. The following example would return data sources with an <code>animals</code> attribute that is a list containing a member that contains the substring <code>at</code> (for example <code>["dog", "cat"]</code>).</p> <p> <code>"stringContains": { "key": "animals", "value": "at" }</code> </p> </li> </ul>', ], ], 'FilterKey' => [ 'base' => NULL, 'refs' => [ 'FilterAttribute$key' => '<p>The name that the metadata attribute must match.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterAttribute$value' => '<p>The value to whcih to compare the value of the metadata attribute.</p>', ], ], 'FinalResponse' => [ 'base' => '<p>Contains details about the response to the user.</p>', 'refs' => [ 'Observation$finalResponse' => '<p>Contains details about the response to the user.</p>', ], ], 'FinalResponseString' => [ 'base' => NULL, 'refs' => [ 'FinalResponse$text' => '<p>The text in the response to the user.</p>', ], ], 'FlowAliasIdentifier' => [ 'base' => NULL, 'refs' => [ 'InvokeFlowRequest$flowAliasIdentifier' => '<p>The unique identifier of the flow alias.</p>', ], ], 'FlowCompletionEvent' => [ 'base' => '<p>Contains information about why a flow completed.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_ResponseSyntax">InvokeFlow response</a> </p> </li> </ul>', 'refs' => [ 'FlowResponseStream$flowCompletionEvent' => '<p>Contains information about why the flow completed.</p>', ], ], 'FlowCompletionReason' => [ 'base' => NULL, 'refs' => [ 'FlowCompletionEvent$completionReason' => '<p>The reason that the flow completed.</p>', ], ], 'FlowIdentifier' => [ 'base' => NULL, 'refs' => [ 'InvokeFlowRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', ], ], 'FlowInput' => [ 'base' => '<p>Contains information about an input into the prompt flow and where to send it.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_RequestSyntax">InvokeFlow request</a> </p> </li> </ul>', 'refs' => [ 'FlowInputs$member' => NULL, ], ], 'FlowInputContent' => [ 'base' => '<p>Contains information about an input into the flow.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_RequestSyntax">InvokeFlow request</a> </p> </li> </ul>', 'refs' => [ 'FlowInput$content' => '<p>Contains information about an input into the prompt flow.</p>', ], ], 'FlowInputs' => [ 'base' => NULL, 'refs' => [ 'InvokeFlowRequest$inputs' => '<p>A list of objects, each containing information about an input into the flow.</p>', ], ], 'FlowOutputContent' => [ 'base' => '<p>Contains information about the content in an output from prompt flow invocation.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_RequestSyntax">InvokeFlow request</a> </p> </li> </ul>', 'refs' => [ 'FlowOutputEvent$content' => '<p>The content in the output.</p>', ], ], 'FlowOutputEvent' => [ 'base' => '<p>Contains information about an output from prompt flow invoction.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_ResponseSyntax">InvokeFlow response</a> </p> </li> </ul>', 'refs' => [ 'FlowResponseStream$flowOutputEvent' => '<p>Contains information about an output from flow invocation.</p>', ], ], 'FlowResponseStream' => [ 'base' => '<p>The output of the flow.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_ResponseSyntax">InvokeFlow response</a> </p> </li> </ul>', 'refs' => [ 'InvokeFlowResponse$responseStream' => '<p>The output of the flow, returned as a stream. If there\'s an error, the error is returned.</p>', ], ], 'Function' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$function' => '<p>The function in the action group to call.</p>', ], ], 'FunctionInvocationInput' => [ 'base' => '<p>Contains information about the function that the agent predicts should be called.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControl</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'InvocationInputMember$functionInvocationInput' => '<p>Contains information about the function that the agent predicts should be called.</p>', ], ], 'FunctionParameter' => [ 'base' => '<p>Contains information about a parameter of the function.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControl</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'FunctionParameters$member' => NULL, ], ], 'FunctionParameters' => [ 'base' => NULL, 'refs' => [ 'FunctionInvocationInput$parameters' => '<p>A list of parameters of the function.</p>', ], ], 'FunctionResult' => [ 'base' => '<p>Contains information about the function that was called from the action group and the response that was returned.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControlInvocationResults</code> of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax">InvokeAgent request</a> </p> </li> </ul>', 'refs' => [ 'InvocationResultMember$functionResult' => '<p>The result from the function from the action group invocation.</p>', ], ], 'GeneratedResponsePart' => [ 'base' => '<p>Contains metadata about a part of the generated response that is accompanied by a citation.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>generatedResponsePart</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>generatedResponsePart</code> field</p> </li> </ul>', 'refs' => [ 'Citation$generatedResponsePart' => '<p>Contains the generated response and metadata </p>', ], ], 'GenerationConfiguration' => [ 'base' => '<p>Contains configurations for response generation based on the knowledge base query results.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> </p> </li> </ul>', 'refs' => [ 'KnowledgeBaseRetrieveAndGenerateConfiguration$generationConfiguration' => '<p>Contains configurations for response generation based on the knowledge base query results.</p>', ], ], 'GetAgentMemoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentMemoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GuadrailAction' => [ 'base' => NULL, 'refs' => [ 'RetrieveAndGenerateResponse$guardrailAction' => '<p>Specifies if there is a guardrail intervention in the response.</p>', ], ], 'GuardrailAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailTrace$action' => '<p>The trace action details used with the Guardrail.</p>', ], ], 'GuardrailAssessment' => [ 'base' => '<p>Assessment details of the content analyzed by Guardrails.</p>', 'refs' => [ 'GuardrailAssessmentList$member' => NULL, ], ], 'GuardrailAssessmentList' => [ 'base' => NULL, 'refs' => [ 'GuardrailTrace$inputAssessments' => '<p>The details of the input assessments used in the Guardrail Trace.</p>', 'GuardrailTrace$outputAssessments' => '<p>The details of the output assessments used in the Guardrail Trace.</p>', ], ], 'GuardrailConfiguration' => [ 'base' => '<p>The configuration details for the guardrail.</p>', 'refs' => [ 'ExternalSourcesGenerationConfiguration$guardrailConfiguration' => '<p>The configuration details for the guardrail.</p>', 'GenerationConfiguration$guardrailConfiguration' => '<p>The configuration details for the guardrail.</p>', ], ], 'GuardrailConfigurationGuardrailIdString' => [ 'base' => NULL, 'refs' => [ 'GuardrailConfiguration$guardrailId' => '<p>The unique identifier for the guardrail.</p>', ], ], 'GuardrailConfigurationGuardrailVersionString' => [ 'base' => NULL, 'refs' => [ 'GuardrailConfiguration$guardrailVersion' => '<p>The version of the guardrail.</p>', ], ], 'GuardrailContentFilter' => [ 'base' => '<p>Details of the content filter used in the Guardrail.</p>', 'refs' => [ 'GuardrailContentFilterList$member' => NULL, ], ], 'GuardrailContentFilterConfidence' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$confidence' => '<p>The confidence level regarding the content detected in the filter by the Guardrail.</p>', ], ], 'GuardrailContentFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentPolicyAssessment$filters' => '<p>The filter details of the policy assessment used in the Guardrails filter.</p>', ], ], 'GuardrailContentFilterType' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$type' => '<p>The type of content detected in the filter by the Guardrail.</p>', ], ], 'GuardrailContentPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$action' => '<p>The action placed on the content by the Guardrail filter.</p>', ], ], 'GuardrailContentPolicyAssessment' => [ 'base' => '<p>The details of the policy assessment in the Guardrails filter.</p>', 'refs' => [ 'GuardrailAssessment$contentPolicy' => '<p>Content policy details of the Guardrail.</p>', ], ], 'GuardrailCustomWord' => [ 'base' => '<p>The custom word details for the filter in the Guardrail.</p>', 'refs' => [ 'GuardrailCustomWordList$member' => NULL, ], ], 'GuardrailCustomWordList' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyAssessment$customWords' => '<p>The custom word details for words defined in the Guardrail filter.</p>', ], ], 'GuardrailManagedWord' => [ 'base' => '<p>The managed word details for the filter in the Guardrail.</p>', 'refs' => [ 'GuardrailManagedWordList$member' => NULL, ], ], 'GuardrailManagedWordList' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyAssessment$managedWordLists' => '<p>The managed word lists for words defined in the Guardrail filter.</p>', ], ], 'GuardrailManagedWordType' => [ 'base' => NULL, 'refs' => [ 'GuardrailManagedWord$type' => '<p>The type details for the managed word filter in the Guardrail.</p>', ], ], 'GuardrailPiiEntityFilter' => [ 'base' => '<p>The Guardrail filter to identify and remove personally identifiable information (PII).</p>', 'refs' => [ 'GuardrailPiiEntityFilterList$member' => NULL, ], ], 'GuardrailPiiEntityFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyAssessment$piiEntities' => '<p>The details of the PII entities used in the sensitive policy assessment for the Guardrail.</p>', ], ], 'GuardrailPiiEntityType' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntityFilter$type' => '<p>The type of PII the Guardrail filter has identified and removed.</p>', ], ], 'GuardrailRegexFilter' => [ 'base' => '<p>The details for the regex filter used in the Guardrail.</p>', 'refs' => [ 'GuardrailRegexFilterList$member' => NULL, ], ], 'GuardrailRegexFilterList' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyAssessment$regexes' => '<p>The details of the regexes used in the sensitive policy assessment for the Guardrail.</p>', ], ], 'GuardrailSensitiveInformationPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntityFilter$action' => '<p>The action of the Guardrail filter to identify and remove PII.</p>', 'GuardrailRegexFilter$action' => '<p>The action details for the regex filter used in the Guardrail.</p>', ], ], 'GuardrailSensitiveInformationPolicyAssessment' => [ 'base' => '<p>The details of the sensitive policy assessment used in the Guardrail.</p>', 'refs' => [ 'GuardrailAssessment$sensitiveInformationPolicy' => '<p>Sensitive Information policy details of Guardrail.</p>', ], ], 'GuardrailTopic' => [ 'base' => '<p>The details for a specific topic defined in the Guardrail.</p>', 'refs' => [ 'GuardrailTopicList$member' => NULL, ], ], 'GuardrailTopicList' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopicPolicyAssessment$topics' => '<p>The topic details of the policy assessment used in the Guardrail.</p>', ], ], 'GuardrailTopicPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$action' => '<p>The action details on a specific topic in the Guardrail.</p>', ], ], 'GuardrailTopicPolicyAssessment' => [ 'base' => '<p>The details of the policy assessment used in the Guardrail.</p>', 'refs' => [ 'GuardrailAssessment$topicPolicy' => '<p>Topic policy details of the Guardrail.</p>', ], ], 'GuardrailTopicType' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$type' => '<p>The type details on a specific topic in the Guardrail.</p>', ], ], 'GuardrailTrace' => [ 'base' => '<p>The trace details used in the Guardrail.</p>', 'refs' => [ 'Trace$guardrailTrace' => '<p>The trace details for a trace defined in the Guardrail filter.</p>', ], ], 'GuardrailWordPolicyAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailCustomWord$action' => '<p>The action details for the custom word filter in the Guardrail.</p>', 'GuardrailManagedWord$action' => '<p>The action details for the managed word filter in the Guardrail.</p>', ], ], 'GuardrailWordPolicyAssessment' => [ 'base' => '<p>The assessment details for words defined in the Guardrail filter.</p>', 'refs' => [ 'GuardrailAssessment$wordPolicy' => '<p>Word policy details of the Guardrail.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'ByteContentDoc$identifier' => '<p>The file name of the document contained in the wrapper object.</p>', ], ], 'InferenceConfig' => [ 'base' => '<p> The configuration for inference settings when generating responses using RetrieveAndGenerate. </p>', 'refs' => [ 'ExternalSourcesGenerationConfiguration$inferenceConfig' => '<p> Configuration settings for inference when using RetrieveAndGenerate to generate responses while using an external source.</p>', 'GenerationConfiguration$inferenceConfig' => '<p> Configuration settings for inference when using RetrieveAndGenerate to generate responses while using a knowledge base as a source. </p>', ], ], 'InferenceConfiguration' => [ 'base' => '<p>Specifications about the inference parameters that were provided alongside the prompt. These are specified in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>', 'refs' => [ 'ModelInvocationInput$inferenceConfiguration' => '<p>Specifications about the inference parameters that were provided alongside the prompt. These are specified in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>', ], ], 'InputFile' => [ 'base' => '<p>Contains details of the source files.</p>', 'refs' => [ 'InputFiles$member' => NULL, ], ], 'InputFiles' => [ 'base' => NULL, 'refs' => [ 'SessionState$files' => '<p>Contains information about the files used by code interpreter.</p>', ], ], 'InputText' => [ 'base' => NULL, 'refs' => [ 'InvokeAgentRequest$inputText' => '<p>The prompt text to send the agent.</p> <note> <p>If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the <code>inputText</code> field will be ignored.</p> </note>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ApiResult$httpStatusCode' => '<p>http status code from API execution response (for example: 200, 400, 500).</p>', 'Usage$inputTokens' => '<p>Contains information about the input tokens from the foundation model usage.</p>', 'Usage$outputTokens' => '<p>Contains information about the output tokens from the foundation model usage.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [ 'FlowResponseStream$internalServerException' => '<p>An internal server error occurred. Retry your request.</p>', 'ResponseStream$internalServerException' => '<p>An internal server error occurred. Retry your request.</p>', ], ], 'InvocationInput' => [ 'base' => '<p>Contains information pertaining to the action group or knowledge base that is being invoked.</p>', 'refs' => [ 'OrchestrationTrace$invocationInput' => '<p>Contains information pertaining to the action group or knowledge base that is being invoked.</p>', ], ], 'InvocationInputMember' => [ 'base' => '<p>Contains details about the API operation or function that the agent predicts should be called. </p> <p>This data type is used in the following API operations:</p> <ul> <li> <p>In the <code>returnControl</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'InvocationInputs$member' => NULL, ], ], 'InvocationInputs' => [ 'base' => NULL, 'refs' => [ 'ReturnControlPayload$invocationInputs' => '<p>A list of objects that contain information about the parameters and inputs that need to be sent into the API operation or function, based on what the agent determines from its session with the user.</p>', ], ], 'InvocationResultMember' => [ 'base' => '<p>A result from the invocation of an action. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent developer</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax">InvokeAgent request</a> </p> </li> </ul>', 'refs' => [ 'ReturnControlInvocationResults$member' => NULL, ], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'InvocationInput$invocationType' => '<p>Specifies whether the agent is invoking an action group or a knowledge base.</p>', ], ], 'InvokeAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvokeFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'RetrieveAndGenerateSessionConfiguration$kmsKeyArn' => '<p>The ARN of the KMS key encrypting the session.</p>', ], ], 'KnowledgeBaseConfiguration' => [ 'base' => '<p>Configurations to apply to a knowledge base attached to the agent during query. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html#session-state-kb">Knowledge base retrieval configurations</a>.</p>', 'refs' => [ 'KnowledgeBaseConfigurations$member' => NULL, ], ], 'KnowledgeBaseConfigurations' => [ 'base' => NULL, 'refs' => [ 'SessionState$knowledgeBaseConfigurations' => '<p>An array of configurations, each of which applies to a knowledge base attached to the agent.</p>', ], ], 'KnowledgeBaseId' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseConfiguration$knowledgeBaseId' => '<p>The unique identifier for a knowledge base attached to the agent.</p>', 'KnowledgeBaseRetrieveAndGenerateConfiguration$knowledgeBaseId' => '<p>The unique identifier of the knowledge base that is queried and the foundation model used for generation.</p>', 'RetrieveRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to query.</p>', ], ], 'KnowledgeBaseLookupInput' => [ 'base' => '<p>Contains details about the knowledge base to look up and the query to be made.</p>', 'refs' => [ 'InvocationInput$knowledgeBaseLookupInput' => '<p>Contains details about the knowledge base to look up and the query to be made.</p>', ], ], 'KnowledgeBaseLookupInputString' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseLookupInput$text' => '<p>The query made to the knowledge base.</p>', ], ], 'KnowledgeBaseLookupOutput' => [ 'base' => '<p>Contains details about the results from looking up the knowledge base.</p>', 'refs' => [ 'Observation$knowledgeBaseLookupOutput' => '<p>Contains details about the results from looking up the knowledge base.</p>', ], ], 'KnowledgeBaseQuery' => [ 'base' => '<p>Contains the query made to the knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve request</a> – in the <code>retrievalQuery</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveRequest$retrievalQuery' => '<p>Contains the query to send the knowledge base.</p>', ], ], 'KnowledgeBaseQueryTextString' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseQuery$text' => '<p>The text of the query made to the knowledge base.</p>', ], ], 'KnowledgeBaseRetrievalConfiguration' => [ 'base' => '<p>Contains configurations for knowledge base query. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve request</a> – in the <code>retrievalConfiguration</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>retrievalConfiguration</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseConfiguration$retrievalConfiguration' => '<p>The configurations to apply to the knowledge base during query. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p>', 'KnowledgeBaseRetrieveAndGenerateConfiguration$retrievalConfiguration' => '<p>Contains configurations for how to retrieve and return the knowledge base query.</p>', 'RetrieveRequest$retrievalConfiguration' => '<p>Contains configurations for the knowledge base query and retrieval process. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p>', ], ], 'KnowledgeBaseRetrievalResult' => [ 'base' => '<p>Details about a result from querying the knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax">Retrieve response</a> – in the <code>retrievalResults</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseRetrievalResults$member' => NULL, ], ], 'KnowledgeBaseRetrievalResults' => [ 'base' => NULL, 'refs' => [ 'RetrieveResponse$retrievalResults' => '<p>A list of results from querying the knowledge base.</p>', ], ], 'KnowledgeBaseRetrieveAndGenerateConfiguration' => [ 'base' => '<p>Contains details about the resource being queried.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve request</a> – in the <code>knowledgeBaseConfiguration</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>knowledgeBaseConfiguration</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveAndGenerateConfiguration$knowledgeBaseConfiguration' => '<p>Contains details about the resource being queried.</p>', ], ], 'KnowledgeBaseVectorSearchConfiguration' => [ 'base' => '<p>Configurations for how to perform the search query and return results. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve request</a> – in the <code>vectorSearchConfiguration</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>vectorSearchConfiguration</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseRetrievalConfiguration$vectorSearchConfiguration' => '<p>Contains details about how the results from the vector search should be returned. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p>', ], ], 'KnowledgeBaseVectorSearchConfigurationNumberOfResultsInteger' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseVectorSearchConfiguration$numberOfResults' => '<p>The number of source chunks to retrieve.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'ModelInvocationInput$overrideLambda' => '<p>The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence.</p>', ], ], 'MaxResults' => [ 'base' => '<p>Max Results.</p>', 'refs' => [ 'GetAgentMemoryRequest$maxItems' => '<p>The maximum number of items to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', ], ], 'MaxTokens' => [ 'base' => NULL, 'refs' => [ 'TextInferenceConfig$maxTokens' => '<p>The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of 65536. The limit values described here are arbitary values, for actual values consult the limits defined by your specific model.</p>', ], ], 'MaximumLength' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$maximumLength' => '<p>The maximum number of tokens allowed in the generated response.</p>', ], ], 'Memories' => [ 'base' => NULL, 'refs' => [ 'GetAgentMemoryResponse$memoryContents' => '<p>Contains details of the sessions stored in the memory</p>', ], ], 'Memory' => [ 'base' => '<p>Contains sessions summaries.</p>', 'refs' => [ 'Memories$member' => NULL, ], ], 'MemoryId' => [ 'base' => NULL, 'refs' => [ 'DeleteAgentMemoryRequest$memoryId' => '<p>The unique identifier of the memory.</p>', 'GetAgentMemoryRequest$memoryId' => '<p>The unique identifier of the memory. </p>', 'InvokeAgentRequest$memoryId' => '<p>The unique identifier of the agent memory.</p>', 'InvokeAgentResponse$memoryId' => '<p>The unique identifier of the agent memory.</p>', 'MemorySessionSummary$memoryId' => '<p>The unique identifier of the memory where the session summary is stored.</p>', ], ], 'MemorySessionSummary' => [ 'base' => '<p>Contains details of a session summary.</p>', 'refs' => [ 'Memory$sessionSummary' => '<p>Contains summary of a session.</p>', ], ], 'MemoryType' => [ 'base' => NULL, 'refs' => [ 'GetAgentMemoryRequest$memoryType' => '<p>The type of memory.</p>', ], ], 'Metadata' => [ 'base' => '<p>Provides details of the foundation model.</p>', 'refs' => [ 'OrchestrationModelInvocationOutput$metadata' => '<p>Contains information about the foundation model output.</p>', ], ], 'MimeType' => [ 'base' => NULL, 'refs' => [ 'ByteContentFile$mediaType' => '<p>The MIME type of data contained in the file used for chat.</p>', 'InvokeAgentResponse$contentType' => '<p>The MIME type of the input data in the request. The default value is <code>application/json</code>.</p>', 'OutputFile$type' => '<p>The type of file that contains response from the code interpreter.</p>', ], ], 'ModelInvocationInput' => [ 'base' => '<p>The input for the pre-processing step.</p> <ul> <li> <p>The <code>type</code> matches the agent step.</p> </li> <li> <p>The <code>text</code> contains the prompt.</p> </li> <li> <p>The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated.</p> </li> </ul>', 'refs' => [ 'OrchestrationTrace$modelInvocationInput' => '<p>The input for the orchestration step.</p> <ul> <li> <p>The <code>type</code> is <code>ORCHESTRATION</code>.</p> </li> <li> <p>The <code>text</code> contains the prompt.</p> </li> <li> <p>The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated.</p> </li> </ul>', 'PostProcessingTrace$modelInvocationInput' => '<p>The input for the post-processing step.</p> <ul> <li> <p>The <code>type</code> is <code>POST_PROCESSING</code>.</p> </li> <li> <p>The <code>text</code> contains the prompt.</p> </li> <li> <p>The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated.</p> </li> </ul>', 'PreProcessingTrace$modelInvocationInput' => '<p>The input for the pre-processing step.</p> <ul> <li> <p>The <code>type</code> is <code>PRE_PROCESSING</code>.</p> </li> <li> <p>The <code>text</code> contains the prompt.</p> </li> <li> <p>The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> object that was set when the agent was created or updated.</p> </li> </ul>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetAgentMemoryRequest$nextToken' => '<p>If the total number of results is greater than the maxItems value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'GetAgentMemoryResponse$nextToken' => '<p>If the total number of results is greater than the maxItems value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'RetrieveRequest$nextToken' => '<p>If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of results.</p>', 'RetrieveResponse$nextToken' => '<p>If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of results.</p>', ], ], 'NodeName' => [ 'base' => NULL, 'refs' => [ 'FlowInput$nodeName' => '<p>The name of the flow input node that begins the prompt flow.</p>', 'FlowOutputEvent$nodeName' => '<p>The name of the flow output node that the output is from.</p>', ], ], 'NodeOutputName' => [ 'base' => NULL, 'refs' => [ 'FlowInput$nodeOutputName' => '<p>The name of the output from the flow input node that begins the prompt flow.</p>', ], ], 'NodeType' => [ 'base' => NULL, 'refs' => [ 'FlowOutputEvent$nodeType' => '<p>The type of the node that the output is from.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'BadGatewayException$message' => NULL, 'BadGatewayException$resourceName' => '<p>The name of the dependency that caused the issue, such as Amazon Bedrock, Lambda, or STS.</p>', 'ConflictException$message' => NULL, 'DependencyFailedException$message' => NULL, 'DependencyFailedException$resourceName' => '<p>The name of the dependency that caused the issue, such as Amazon Bedrock, Lambda, or STS.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Observation' => [ 'base' => '<p>Contains the result or output of an action group or knowledge base, or the response to the user.</p>', 'refs' => [ 'OrchestrationTrace$observation' => '<p>Details about the observation (the output of the action group Lambda or knowledge base) made by the agent.</p>', ], ], 'OrchestrationConfiguration' => [ 'base' => '<p>Settings for how the model processes the prompt prior to retrieval and generation.</p>', 'refs' => [ 'KnowledgeBaseRetrieveAndGenerateConfiguration$orchestrationConfiguration' => '<p>Settings for how the model processes the prompt prior to retrieval and generation.</p>', ], ], 'OrchestrationModelInvocationOutput' => [ 'base' => '<p>The foundation model output from the orchestration step.</p>', 'refs' => [ 'OrchestrationTrace$modelInvocationOutput' => '<p>Contains information pertaining to the output from the foundation model that is being invoked.</p>', ], ], 'OrchestrationTrace' => [ 'base' => '<p>Details about the orchestration step, in which the agent determines the order in which actions are executed and which knowledge bases are retrieved.</p>', 'refs' => [ 'Trace$orchestrationTrace' => '<p>Details about the orchestration step, in which the agent determines the order in which actions are executed and which knowledge bases are retrieved.</p>', ], ], 'OutputFile' => [ 'base' => '<p>Contains details of the response from code interpreter.</p>', 'refs' => [ 'OutputFiles$member' => NULL, ], ], 'OutputFiles' => [ 'base' => NULL, 'refs' => [ 'FilePart$files' => '<p>Files containing intermediate response for the user.</p>', ], ], 'OutputString' => [ 'base' => NULL, 'refs' => [ 'PostProcessingParsedResponse$text' => '<p>The text returned by the parser.</p>', ], ], 'Parameter' => [ 'base' => '<p>A parameter for the API request or function.</p>', 'refs' => [ 'ParameterList$member' => NULL, 'Parameters$member' => NULL, ], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'PropertyParameters$properties' => '<p>A list of parameters in the request body.</p>', ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$parameters' => '<p>The parameters in the Lambda input event.</p>', 'ContentMap$value' => NULL, ], ], 'PartBody' => [ 'base' => NULL, 'refs' => [ 'PayloadPart$bytes' => '<p>A part of the agent response in bytes.</p>', ], ], 'PayloadPart' => [ 'base' => '<p>Contains a part of an agent response and citations for it.</p>', 'refs' => [ 'ResponseStream$chunk' => '<p>Contains a part of an agent response and citations for it.</p>', ], ], 'PostProcessingModelInvocationOutput' => [ 'base' => '<p>The foundation model output from the post-processing step.</p>', 'refs' => [ 'PostProcessingTrace$modelInvocationOutput' => '<p>The foundation model output from the post-processing step.</p>', ], ], 'PostProcessingParsedResponse' => [ 'base' => '<p>Details about the response from the Lambda parsing of the output from the post-processing step.</p>', 'refs' => [ 'PostProcessingModelInvocationOutput$parsedResponse' => '<p>Details about the response from the Lambda parsing of the output of the post-processing step.</p>', ], ], 'PostProcessingTrace' => [ 'base' => '<p>Details about the post-processing step, in which the agent shapes the response.</p>', 'refs' => [ 'Trace$postProcessingTrace' => '<p>Details about the post-processing step, in which the agent shapes the response..</p>', ], ], 'PreProcessingModelInvocationOutput' => [ 'base' => '<p>The foundation model output from the pre-processing step.</p>', 'refs' => [ 'PreProcessingTrace$modelInvocationOutput' => '<p>The foundation model output from the pre-processing step.</p>', ], ], 'PreProcessingParsedResponse' => [ 'base' => '<p>Details about the response from the Lambda parsing of the output from the pre-processing step.</p>', 'refs' => [ 'PreProcessingModelInvocationOutput$parsedResponse' => '<p>Details about the response from the Lambda parsing of the output of the pre-processing step.</p>', ], ], 'PreProcessingTrace' => [ 'base' => '<p>Details about the pre-processing step, in which the agent contextualizes and categorizes user inputs.</p>', 'refs' => [ 'Trace$preProcessingTrace' => '<p>Details about the pre-processing step, in which the agent contextualizes and categorizes user inputs.</p>', ], ], 'PromptSessionAttributesMap' => [ 'base' => NULL, 'refs' => [ 'SessionState$promptSessionAttributes' => '<p>Contains attributes that persist across a prompt and the values of those attributes. These attributes replace the $prompt_session_attributes$ placeholder variable in the orchestration prompt template. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template placeholder variables</a>.</p>', ], ], 'PromptTemplate' => [ 'base' => '<p>Contains the template for the prompt that\'s sent to the model for response generation. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt">Knowledge base prompt templates</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>filter</code> field</p> </li> </ul>', 'refs' => [ 'ExternalSourcesGenerationConfiguration$promptTemplate' => '<p>Contain the textPromptTemplate string for the external source wrapper object.</p>', 'GenerationConfiguration$promptTemplate' => '<p>Contains the template for the prompt that\'s sent to the model for response generation.</p>', ], ], 'PromptText' => [ 'base' => NULL, 'refs' => [ 'ModelInvocationInput$text' => '<p>The text that prompted the agent at this step.</p>', ], ], 'PromptType' => [ 'base' => NULL, 'refs' => [ 'ModelInvocationInput$type' => '<p>The step in the agent sequence.</p>', ], ], 'PropertyParameters' => [ 'base' => '<p>Contains the parameters in the request body.</p>', 'refs' => [ 'ApiContentMap$value' => NULL, ], ], 'QueryTransformationConfiguration' => [ 'base' => '<p>To split up the prompt and retrieve multiple sources, set the transformation type to <code>QUERY_DECOMPOSITION</code>.</p>', 'refs' => [ 'OrchestrationConfiguration$queryTransformationConfiguration' => '<p>To split up the prompt and retrieve multiple sources, set the transformation type to <code>QUERY_DECOMPOSITION</code>.</p>', ], ], 'QueryTransformationType' => [ 'base' => NULL, 'refs' => [ 'QueryTransformationConfiguration$type' => '<p>The type of transformation to apply to the prompt.</p>', ], ], 'RAGStopSequences' => [ 'base' => NULL, 'refs' => [ 'TextInferenceConfig$stopSequences' => '<p>A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values, for actual values consult the limits defined by your specific model.</p>', ], ], 'RAGStopSequencesMemberString' => [ 'base' => NULL, 'refs' => [ 'RAGStopSequences$member' => NULL, ], ], 'Rationale' => [ 'base' => '<p>Contains the reasoning, based on the input, that the agent uses to justify carrying out an action group or getting information from a knowledge base.</p>', 'refs' => [ 'OrchestrationTrace$rationale' => '<p>Details about the reasoning, based on the input, that the agent uses to justify carrying out an action group or getting information from a knowledge base.</p>', ], ], 'RationaleString' => [ 'base' => NULL, 'refs' => [ 'PreProcessingParsedResponse$rationale' => '<p>The text returned by the parsing of the pre-processing step, explaining the steps that the agent plans to take in orchestration, if the user input is valid.</p>', 'Rationale$text' => '<p>The reasoning or thought process of the agent, based on the input.</p>', ], ], 'RawResponse' => [ 'base' => '<p>Contains the raw output from the foundation model.</p>', 'refs' => [ 'OrchestrationModelInvocationOutput$rawResponse' => '<p>Contains details of the raw response from the foundation model output.</p>', ], ], 'RepromptResponse' => [ 'base' => '<p>Contains details about the agent\'s response to reprompt the input.</p>', 'refs' => [ 'Observation$repromptResponse' => '<p>Contains details about the response to reprompt the input.</p>', ], ], 'RequestBody' => [ 'base' => '<p>The parameters in the API request body.</p>', 'refs' => [ 'ActionGroupInvocationInput$requestBody' => '<p>The parameters in the request body for the Lambda input event.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and try your request again.</p>', 'refs' => [ 'FlowResponseStream$resourceNotFoundException' => '<p>The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and try your request again.</p>', 'ResponseStream$resourceNotFoundException' => '<p>The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and try your request again.</p>', ], ], 'ResponseBody' => [ 'base' => NULL, 'refs' => [ 'ApiResult$responseBody' => '<p>The response body from the API operation. The key of the object is the content type (currently, only <code>TEXT</code> is supported). The response may be returned directly or from the Lambda function.</p>', 'FunctionResult$responseBody' => '<p>The response from the function call using the parameters. The key of the object is the content type (currently, only <code>TEXT</code> is supported). The response may be returned directly or from the Lambda function.</p>', ], ], 'ResponseState' => [ 'base' => NULL, 'refs' => [ 'ApiResult$responseState' => '<p>Controls the final response state returned to end user when API/Function execution failed. When this state is FAILURE, the request would fail with dependency failure exception. When this state is REPROMPT, the API/function response will be sent to model for re-prompt</p>', 'FunctionResult$responseState' => '<p>Controls the final response state returned to end user when API/Function execution failed. When this state is FAILURE, the request would fail with dependency failure exception. When this state is REPROMPT, the API/function response will be sent to model for re-prompt</p>', ], ], 'ResponseStream' => [ 'base' => '<p>The response from invoking the agent and associated citations and trace information.</p>', 'refs' => [ 'InvokeAgentResponse$completion' => '<p>The agent\'s response to the user prompt.</p>', ], ], 'RetrievalFilter' => [ 'base' => '<p>Specifies the filters to use on the metadata attributes in the knowledge base data sources before returning results. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>. See the examples below to see how to use these filters.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax">Retrieve request</a> – in the <code>filter</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>filter</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseVectorSearchConfiguration$filter' => '<p>Specifies the filters to use on the metadata in the knowledge base data sources before returning results. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p>', 'RetrievalFilterList$member' => NULL, ], ], 'RetrievalFilterList' => [ 'base' => NULL, 'refs' => [ 'RetrievalFilter$andAll' => '<p>Knowledge base data sources are returned if their metadata attributes fulfill all the filter conditions inside this list.</p>', 'RetrievalFilter$orAll' => '<p>Knowledge base data sources are returned if their metadata attributes fulfill at least one of the filter conditions inside this list.</p>', ], ], 'RetrievalResultConfluenceLocation' => [ 'base' => '<p>The Confluence data source location.</p>', 'refs' => [ 'RetrievalResultLocation$confluenceLocation' => '<p>The Confluence data source location.</p>', ], ], 'RetrievalResultContent' => [ 'base' => '<p>Contains the cited text from the data source.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax">Retrieve response</a> – in the <code>content</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>content</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>content</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseRetrievalResult$content' => '<p>Contains a chunk of text from a data source in the knowledge base.</p>', 'RetrievedReference$content' => '<p>Contains the cited text from the data source.</p>', ], ], 'RetrievalResultLocation' => [ 'base' => '<p>Contains information about the data source location.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax">Retrieve response</a> – in the <code>location</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>location</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>locatino</code> field</p> </li> </ul>', 'refs' => [ 'KnowledgeBaseRetrievalResult$location' => '<p>Contains information about the location of the data source.</p>', 'RetrievedReference$location' => '<p>Contains information about the location of the data source.</p>', ], ], 'RetrievalResultLocationType' => [ 'base' => NULL, 'refs' => [ 'RetrievalResultLocation$type' => '<p>The type of data source location.</p>', ], ], 'RetrievalResultMetadata' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseRetrievalResult$metadata' => '<p>Contains metadata attributes and their values for the file in the data source. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata">Metadata and filtering</a>.</p>', 'RetrievedReference$metadata' => '<p>Contains metadata attributes and their values for the file in the data source. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata">Metadata and filtering</a>.</p>', ], ], 'RetrievalResultMetadataKey' => [ 'base' => NULL, 'refs' => [ 'RetrievalResultMetadata$key' => NULL, ], ], 'RetrievalResultMetadataValue' => [ 'base' => NULL, 'refs' => [ 'RetrievalResultMetadata$value' => NULL, ], ], 'RetrievalResultS3Location' => [ 'base' => '<p>The S3 data source location.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax">Retrieve response</a> – in the <code>s3Location</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>s3Location</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>s3Location</code> field</p> </li> </ul>', 'refs' => [ 'RetrievalResultLocation$s3Location' => '<p>The S3 data source location.</p>', ], ], 'RetrievalResultSalesforceLocation' => [ 'base' => '<p>The Salesforce data source location.</p>', 'refs' => [ 'RetrievalResultLocation$salesforceLocation' => '<p>The Salesforce data source location.</p>', ], ], 'RetrievalResultSharePointLocation' => [ 'base' => '<p>The SharePoint data source location.</p>', 'refs' => [ 'RetrievalResultLocation$sharePointLocation' => '<p>The SharePoint data source location.</p>', ], ], 'RetrievalResultWebLocation' => [ 'base' => '<p>The web URL/URLs data source location.</p>', 'refs' => [ 'RetrievalResultLocation$webLocation' => '<p>The web URL/URLs data source location.</p>', ], ], 'RetrieveAndGenerateConfiguration' => [ 'base' => '<p>Contains details about the resource being queried.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>retrieveAndGenerateConfiguration</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveAndGenerateRequest$retrieveAndGenerateConfiguration' => '<p>Contains configurations for the knowledge base query and retrieval process. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.</p>', ], ], 'RetrieveAndGenerateInput' => [ 'base' => '<p>Contains the query made to the knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>input</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveAndGenerateRequest$input' => '<p>Contains the query to be made to the knowledge base.</p>', ], ], 'RetrieveAndGenerateInputTextString' => [ 'base' => NULL, 'refs' => [ 'RetrieveAndGenerateInput$text' => '<p>The query made to the knowledge base.</p>', ], ], 'RetrieveAndGenerateOutput' => [ 'base' => '<p>Contains the response generated from querying the knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>output</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveAndGenerateResponse$output' => '<p>Contains the response generated from querying the knowledge base.</p>', ], ], 'RetrieveAndGenerateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveAndGenerateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveAndGenerateSessionConfiguration' => [ 'base' => '<p>Contains configuration about the session with the knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax">RetrieveAndGenerate request</a> – in the <code>sessionConfiguration</code> field</p> </li> </ul>', 'refs' => [ 'RetrieveAndGenerateRequest$sessionConfiguration' => '<p>Contains details about the session with the knowledge base.</p>', ], ], 'RetrieveAndGenerateType' => [ 'base' => NULL, 'refs' => [ 'RetrieveAndGenerateConfiguration$type' => '<p>The type of resource that is queried by the request.</p>', ], ], 'RetrieveRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetrievedReference' => [ 'base' => '<p>Contains metadata about a source cited for the generated response.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>retrievedReferences</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>retrievedReferences</code> field</p> </li> </ul>', 'refs' => [ 'RetrievedReferences$member' => NULL, ], ], 'RetrievedReferences' => [ 'base' => NULL, 'refs' => [ 'Citation$retrievedReferences' => '<p>Contains metadata about the sources cited for the generated response.</p>', 'KnowledgeBaseLookupOutput$retrievedReferences' => '<p>Contains metadata about the sources cited for the generated response.</p>', ], ], 'ReturnControlInvocationResults' => [ 'base' => NULL, 'refs' => [ 'SessionState$returnControlInvocationResults' => '<p>Contains information about the results from the action group invocation. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent developer</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.</p> <note> <p>If you include this field, the <code>inputText</code> field will be ignored.</p> </note>', ], ], 'ReturnControlPayload' => [ 'base' => '<p>Contains information to return from the action group that the agent has predicted to invoke.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> </p> </li> </ul>', 'refs' => [ 'ResponseStream$returnControl' => '<p>Contains the parameters and information that the agent elicited from the customer to carry out an action. This information is returned to the system and can be used in your own setup for fulfilling the action.</p>', ], ], 'S3ObjectDoc' => [ 'base' => '<p>The unique wrapper object of the document from the S3 location.</p>', 'refs' => [ 'ExternalSource$s3Location' => '<p>The S3 location of the external source wrapper object.</p>', ], ], 'S3ObjectFile' => [ 'base' => '<p>Contains details of the s3 object where the source file is located.</p>', 'refs' => [ 'FileSource$s3Location' => '<p>The s3 location of the files to attach.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'S3ObjectDoc$uri' => '<p>The file location of the S3 wrapper object.</p>', 'S3ObjectFile$uri' => '<p>The uri of the s3 object.</p>', ], ], 'SearchType' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseVectorSearchConfiguration$overrideSearchType' => '<p>By default, Amazon Bedrock decides a search strategy for you. If you\'re using an Amazon OpenSearch Serverless vector store that contains a filterable text field, you can specify whether to query the knowledge base with a <code>HYBRID</code> search using both vector embeddings and raw text, or <code>SEMANTIC</code> search using only vector embeddings. For other vector store configurations, only <code>SEMANTIC</code> search is available. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge base</a>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', 'refs' => [ 'FlowResponseStream$serviceQuotaExceededException' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', 'ResponseStream$serviceQuotaExceededException' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', ], ], 'SessionAttributesMap' => [ 'base' => NULL, 'refs' => [ 'SessionState$sessionAttributes' => '<p>Contains attributes that persist across a session and the values of those attributes.</p>', ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'InvokeAgentRequest$sessionId' => '<p>The unique identifier of the session. Use the same value across requests to continue the same conversation.</p>', 'InvokeAgentResponse$sessionId' => '<p>The unique identifier of the session with the agent.</p>', 'MemorySessionSummary$sessionId' => '<p>The identifier for this session.</p>', 'RetrieveAndGenerateRequest$sessionId' => '<p>The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous interactions. You can\'t explicitly set the <code>sessionId</code> yourself.</p>', 'RetrieveAndGenerateResponse$sessionId' => '<p>The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous interactions. You can\'t explicitly set the <code>sessionId</code> yourself.</p>', 'TracePart$sessionId' => '<p>The unique identifier of the session with the agent.</p>', ], ], 'SessionState' => [ 'base' => '<p>Contains parameters that specify various attributes that persist across a session or prompt. You can define session state attributes as key-value pairs when writing a <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html">Lambda function</a> for an action group or pass them when making an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request. Use session state attributes to control and provide conversational context for your agent and to help customize your agent\'s behavior. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.</p>', 'refs' => [ 'InvokeAgentRequest$sessionState' => '<p>Contains parameters that specify various attributes of the session. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.</p> <note> <p>If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the <code>inputText</code> field will be ignored.</p> </note>', ], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'RepromptResponse$source' => '<p>Specifies what output is prompting the agent to reprompt the input.</p>', ], ], 'Span' => [ 'base' => '<p>Contains information about where the text with a citation begins and ends in the generated output.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>span</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>span</code> field</p> </li> </ul>', 'refs' => [ 'TextResponsePart$span' => '<p>Contains information about where the text with a citation begins and ends in the generated output.</p>', ], ], 'SpanEndInteger' => [ 'base' => NULL, 'refs' => [ 'Span$end' => '<p>Where the text with a citation ends in the generated output.</p>', ], ], 'SpanStartInteger' => [ 'base' => NULL, 'refs' => [ 'Span$start' => '<p>Where the text with a citation starts in the generated output.</p>', ], ], 'StopSequences' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$stopSequences' => '<p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$invocationId' => '<p>The unique identifier of the invocation. Only returned if the <code>executionType</code> is <code>RETURN_CONTROL</code>.</p>', 'ApiContentMap$key' => NULL, 'ApiInvocationInput$actionGroup' => '<p>The action group that the API operation belongs to.</p>', 'ApiInvocationInput$httpMethod' => '<p>The HTTP method of the API operation.</p>', 'ApiParameter$name' => '<p>The name of the parameter.</p>', 'ApiParameter$type' => '<p>The data type for the parameter.</p>', 'ApiParameter$value' => '<p>The value of the parameter.</p>', 'ApiResult$actionGroup' => '<p>The action group that the API operation belongs to.</p>', 'ApiResult$httpMethod' => '<p>The HTTP method for the API operation.</p>', 'CodeInterpreterInvocationInput$code' => '<p>The code for the code interpreter to use.</p>', 'CodeInterpreterInvocationOutput$executionError' => '<p>Contains the error returned from code execution.</p>', 'CodeInterpreterInvocationOutput$executionOutput' => '<p>Contains the successful output returned from code execution</p>', 'ContentBody$body' => '<p>The body of the API response.</p>', 'ContentMap$key' => NULL, 'Files$member' => NULL, 'FunctionInvocationInput$actionGroup' => '<p>The action group that the function belongs to.</p>', 'FunctionInvocationInput$function' => '<p>The name of the function.</p>', 'FunctionParameter$name' => '<p>The name of the parameter.</p>', 'FunctionParameter$type' => '<p>The data type of the parameter.</p>', 'FunctionParameter$value' => '<p>The value of the parameter.</p>', 'FunctionResult$actionGroup' => '<p>The action group that the function belongs to.</p>', 'FunctionResult$function' => '<p>The name of the function that was called.</p>', 'GuardrailCustomWord$match' => '<p>The match details for the custom word filter in the Guardrail.</p>', 'GuardrailManagedWord$match' => '<p>The match details for the managed word filter in the Guardrail.</p>', 'GuardrailPiiEntityFilter$match' => '<p>The match to settings in the Guardrail filter to identify and remove PII.</p>', 'GuardrailRegexFilter$match' => '<p>The match details for the regex filter used in the Guardrail.</p>', 'GuardrailRegexFilter$name' => '<p>The name details for the regex filter used in the Guardrail.</p>', 'GuardrailRegexFilter$regex' => '<p>The regex details for the regex filter used in the Guardrail.</p>', 'GuardrailTopic$name' => '<p>The name details on a specific topic in the Guardrail.</p>', 'InputFile$name' => '<p>The name of the source file.</p>', 'OutputFile$name' => '<p>The name of the file containing response from code interpreter.</p>', 'Parameter$name' => '<p>The name of the parameter.</p>', 'Parameter$type' => '<p>The type of the parameter.</p>', 'Parameter$value' => '<p>The value of the parameter.</p>', 'PromptSessionAttributesMap$key' => NULL, 'PromptSessionAttributesMap$value' => NULL, 'RawResponse$content' => '<p>The foundation model\'s raw output content.</p>', 'RepromptResponse$text' => '<p>The text reprompting the input.</p>', 'ResponseBody$key' => NULL, 'RetrievalResultConfluenceLocation$url' => '<p>The Confluence host URL for the data source location.</p>', 'RetrievalResultContent$text' => '<p>The cited text from the data source.</p>', 'RetrievalResultS3Location$uri' => '<p>The S3 URI for the data source location.</p>', 'RetrievalResultSalesforceLocation$url' => '<p>The Salesforce host URL for the data source location.</p>', 'RetrievalResultSharePointLocation$url' => '<p>The SharePoint site URL for the data source location.</p>', 'RetrievalResultWebLocation$url' => '<p>The web URL/URLs for the data source location.</p>', 'RetrieveAndGenerateOutput$text' => '<p>The response generated from querying the knowledge base.</p>', 'ReturnControlPayload$invocationId' => '<p>The identifier of the action group invocation.</p>', 'SessionAttributesMap$key' => NULL, 'SessionAttributesMap$value' => NULL, 'SessionState$invocationId' => '<p>The identifier of the invocation of an action. This value must match the <code>invocationId</code> returned in the <code>InvokeAgent</code> response for the action whose results are provided in the <code>returnControlInvocationResults</code> field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent developer</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.</p>', 'StopSequences$member' => NULL, 'TextResponsePart$text' => '<p>The part of the generated text that contains a citation.</p>', ], ], 'SummaryText' => [ 'base' => NULL, 'refs' => [ 'MemorySessionSummary$summaryText' => '<p>The summarized text for this session.</p>', ], ], 'Temperature' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$temperature' => '<p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>', 'TextInferenceConfig$temperature' => '<p> Controls the random-ness of text generated by the language model, influencing how much the model sticks to the most predictable next words versus exploring more surprising options. A lower temperature value (e.g. 0.2 or 0.3) makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or 0.9) makes the outputs more creative or unpredictable. </p>', ], ], 'TextInferenceConfig' => [ 'base' => '<p>Configuration settings for text generation using a language model via the RetrieveAndGenerate operation. Includes parameters like temperature, top-p, maximum token count, and stop sequences. </p> <note> <p>The valid range of <code>maxTokens</code> depends on the accepted values for your chosen model\'s inference parameters. To see the inference parameters for your model, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models.</a> </p> </note>', 'refs' => [ 'InferenceConfig$textInferenceConfig' => '<p> Configuration settings specific to text generation while generating responses using RetrieveAndGenerate. </p>', ], ], 'TextPromptTemplate' => [ 'base' => NULL, 'refs' => [ 'PromptTemplate$textPromptTemplate' => '<p>The template for the prompt that\'s sent to the model for response generation. You can include prompt placeholders, which become replaced before the prompt is sent to the model to provide instructions and context to the model. In addition, you can include XML tags to delineate meaningful sections of the prompt template.</p> <p>For more information, see the following resources:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt">Knowledge base prompt templates</a> </p> </li> <li> <p> <a href="https://docs.anthropic.com/claude/docs/use-xml-tags">Use XML tags with Anthropic Claude models</a> </p> </li> </ul>', ], ], 'TextResponsePart' => [ 'base' => '<p>Contains the part of the generated text that contains a citation, alongside where it begins and ends.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax">RetrieveAndGenerate response</a> – in the <code>textResponsePart</code> field</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax">InvokeAgent response</a> – in the <code>textResponsePart</code> field</p> </li> </ul>', 'refs' => [ 'GeneratedResponsePart$textResponsePart' => '<p>Contains metadata about a textual part of the generated response that is accompanied by a citation.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'refs' => [ 'FlowResponseStream$throttlingException' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'ResponseStream$throttlingException' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', ], ], 'TopK' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$topK' => '<p>While generating a response, the model determines the probability of the following token at each point of generation. The value that you set for <code>topK</code> is the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model selects the next token from among the top 50 most likely choices.</p>', ], ], 'TopP' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$topP' => '<p>While generating a response, the model determines the probability of the following token at each point of generation. The value that you set for <code>Top P</code> determines the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topP</code> to 0.8, the model only selects the next token from the top 80% of the probability distribution of next tokens.</p>', 'TextInferenceConfig$topP' => '<p> A probability distribution threshold which controls what the model considers for the set of possible next tokens. The model will only consider the top p% of the probability distribution when generating the next token. </p>', ], ], 'Trace' => [ 'base' => '<p>Contains one part of the agent\'s reasoning process and results from calling API actions and querying knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the customer. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace enablement</a>.</p>', 'refs' => [ 'TracePart$trace' => '<p>Contains one part of the agent\'s reasoning process and results from calling API actions and querying knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the customer. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace enablement</a>.</p>', ], ], 'TraceId' => [ 'base' => NULL, 'refs' => [ 'FailureTrace$traceId' => '<p>The unique identifier of the trace.</p>', 'GuardrailTrace$traceId' => '<p>The details of the trace Id used in the Guardrail Trace.</p>', 'InvocationInput$traceId' => '<p>The unique identifier of the trace.</p>', 'ModelInvocationInput$traceId' => '<p>The unique identifier of the trace.</p>', 'Observation$traceId' => '<p>The unique identifier of the trace.</p>', 'OrchestrationModelInvocationOutput$traceId' => '<p>The unique identifier of the trace.</p>', 'PostProcessingModelInvocationOutput$traceId' => '<p>The unique identifier of the trace.</p>', 'PreProcessingModelInvocationOutput$traceId' => '<p>The unique identifier of the trace.</p>', 'Rationale$traceId' => '<p>The unique identifier of the trace step.</p>', ], ], 'TraceKnowledgeBaseId' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseLookupInput$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to look up.</p>', ], ], 'TracePart' => [ 'base' => '<p>Contains information about the agent and session, alongside the agent\'s reasoning process and results from calling API actions and querying knowledge bases and metadata about the trace. You can use the trace to understand how the agent arrived at the response it provided the customer. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace enablement</a>.</p>', 'refs' => [ 'ResponseStream$trace' => '<p>Contains information about the agent and session, alongside the agent\'s reasoning process and results from calling actions and querying knowledge bases and metadata about the trace. You can use the trace to understand how the agent arrived at the response it provided the customer. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Trace events</a>.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'Observation$type' => '<p>Specifies what kind of information the agent returns in the observation. The following values are possible.</p> <ul> <li> <p> <code>ACTION_GROUP</code> – The agent returns the result of an action group.</p> </li> <li> <p> <code>KNOWLEDGE_BASE</code> – The agent returns information from a knowledge base.</p> </li> <li> <p> <code>FINISH</code> – The agent returns a final response to the user with no follow-up.</p> </li> <li> <p> <code>ASK_USER</code> – The agent asks the user a question.</p> </li> <li> <p> <code>REPROMPT</code> – The agent prompts the user again for the same information.</p> </li> </ul>', ], ], 'Usage' => [ 'base' => '<p>Contains information of the usage of the foundation model.</p>', 'refs' => [ 'Metadata$usage' => '<p>Contains details of the foundation model usage.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'refs' => [ 'FlowResponseStream$validationException' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'ResponseStream$validationException' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', ], ], 'Verb' => [ 'base' => NULL, 'refs' => [ 'ActionGroupInvocationInput$verb' => '<p>The API method being used, based off the action group.</p>', ], ], ],];
