<?php
// This file was auto-generated from sdk-root/src/data/chatbot/2017-10-11/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The <i>AWS Chatbot API Reference</i> provides descriptions, API request parameters, and the XML response for each of the AWS Chatbot API actions.</p> <p>AWS Chatbot APIs are currently available in the following Regions:</p> <ul> <li> <p>US East (Ohio) - <code>us-east-2</code> </p> </li> <li> <p>US West (Oregon) - <code>us-west-2</code> </p> </li> <li> <p>Asia Pacific (Singapore) - <code>ap-southeast-1</code> </p> </li> <li> <p>Europe (Ireland) - <code>eu-west-1</code> </p> </li> </ul> <p>The AWS Chatbot console can only be used in US East (Ohio). Your configuration data however, is stored in each of the relevant available Regions.</p> <note> <p>Your AWS CloudTrail events are logged in whatever Region you call from, not US East (N. Virginia) by default.</p> </note>', 'operations' => [ 'CreateChimeWebhookConfiguration' => '<p>Creates an AWS Chatbot configuration for Amazon Chime.</p>', 'CreateMicrosoftTeamsChannelConfiguration' => '<p>Creates an AWS Chatbot configuration for Microsoft Teams.</p>', 'CreateSlackChannelConfiguration' => '<p>Creates an AWS Chatbot confugration for Slack.</p>', 'DeleteChimeWebhookConfiguration' => '<p>Deletes a Amazon Chime webhook configuration for AWS Chatbot.</p>', 'DeleteMicrosoftTeamsChannelConfiguration' => '<p>Deletes a Microsoft Teams channel configuration for AWS Chatbot</p>', 'DeleteMicrosoftTeamsConfiguredTeam' => '<p>Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams team. Note that the Microsoft Teams team must have no channels configured to remove it. </p>', 'DeleteMicrosoftTeamsUserIdentity' => '<p>Identifes a user level permission for a channel configuration.</p>', 'DeleteSlackChannelConfiguration' => '<p>Deletes a Slack channel configuration for AWS Chatbot</p>', 'DeleteSlackUserIdentity' => '<p>Deletes a user level permission for a Slack channel configuration.</p>', 'DeleteSlackWorkspaceAuthorization' => '<p>Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires all configured channels in the workspace to be deleted. </p>', 'DescribeChimeWebhookConfigurations' => '<p>Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn</p>', 'DescribeSlackChannelConfigurations' => '<p>Lists Slack channel configurations optionally filtered by ChatConfigurationArn</p>', 'DescribeSlackUserIdentities' => '<p>Lists all Slack user identities with a mapped role.</p>', 'DescribeSlackWorkspaces' => '<p>List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.</p>', 'GetAccountPreferences' => '<p>Returns AWS Chatbot account preferences.</p>', 'GetMicrosoftTeamsChannelConfiguration' => '<p>Returns a Microsoft Teams channel configuration in an AWS account.</p>', 'ListMicrosoftTeamsChannelConfigurations' => '<p>Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.</p>', 'ListMicrosoftTeamsConfiguredTeams' => '<p>Lists all authorized Microsoft Teams for an AWS Account</p>', 'ListMicrosoftTeamsUserIdentities' => '<p>A list all Microsoft Teams user identities with a mapped role.</p>', 'ListTagsForResource' => '<p>Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.</p>', 'TagResource' => '<p>Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p>', 'UntagResource' => '<p>Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p>', 'UpdateAccountPreferences' => '<p>Updates AWS Chatbot account preferences.</p>', 'UpdateChimeWebhookConfiguration' => '<p>Updates a Amazon Chime webhook configuration.</p>', 'UpdateMicrosoftTeamsChannelConfiguration' => '<p>Updates an Microsoft Teams channel configuration.</p>', 'UpdateSlackChannelConfiguration' => '<p>Updates a Slack channel configuration.</p>', ], 'shapes' => [ 'AccountPreferences' => [ 'base' => '<p>Preferences related to AWS Chatbot usage in the calling AWS account.</p>', 'refs' => [ 'GetAccountPreferencesResult$AccountPreferences' => '<p>The preferences related to AWS Chatbot usage in the calling AWS account.</p>', 'UpdateAccountPreferencesResult$AccountPreferences' => '<p>Preferences related to AWS Chatbot usage in the calling AWS account.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN you specified to list the tags of.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the configuration.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is an identifier for a specific AWS resource, such as a server, user, or role.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'CreateChimeWebhookConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'CreateSlackChannelConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'CreateTeamsChannelConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'SlackChannelConfiguration$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'SlackUserIdentity$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'SnsTopicArnList$member' => NULL, 'TeamsChannelConfiguration$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'TeamsUserIdentity$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'UpdateChimeWebhookConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'UpdateSlackChannelConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'UpdateTeamsChannelConfigurationRequest$IamRoleArn' => '<p>A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', ], ], 'AwsUserIdentity' => [ 'base' => NULL, 'refs' => [ 'SlackUserIdentity$AwsUserIdentity' => '<p>The AWS user identity ARN used to associate a Slack user ID with an IAM Role.</p>', 'TeamsUserIdentity$AwsUserIdentity' => '<p>The AWS user identity ARN used to associate a Microsoft Teams user Identity with an IAM Role.</p>', ], ], 'BooleanAccountPreference' => [ 'base' => NULL, 'refs' => [ 'AccountPreferences$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'AccountPreferences$TrainingDataCollectionEnabled' => '<p>Turns on training data collection.</p> <p>This helps improve the AWS Chatbot experience by allowing AWS Chatbot to store and use your customer information, such as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot generated responses, and interaction data. This data helps us to continuously improve and develop Artificial Intelligence (AI) technologies. Your data is not shared with any third parties and is protected using sophisticated controls to prevent unauthorized access and misuse. AWS Chatbot does not store or use interactions in chat channels with Amazon Q for training AI technologies for AWS Chatbot. </p>', 'CreateSlackChannelConfigurationRequest$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'CreateTeamsChannelConfigurationRequest$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'SlackChannelConfiguration$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'TeamsChannelConfiguration$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'UpdateAccountPreferencesRequest$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'UpdateAccountPreferencesRequest$TrainingDataCollectionEnabled' => '<p>Turns on training data collection.</p> <p>This helps improve the AWS Chatbot experience by allowing AWS Chatbot to store and use your customer information, such as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot generated responses, and interaction data. This data helps us to continuously improve and develop Artificial Intelligence (AI) technologies. Your data is not shared with any third parties and is protected using sophisticated controls to prevent unauthorized access and misuse. AWS Chatbot does not store or use interactions in chat channels with Amazon Q for training AI technologies for AWS Chatbot. </p>', 'UpdateSlackChannelConfigurationRequest$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', 'UpdateTeamsChannelConfigurationRequest$UserAuthorizationRequired' => '<p>Enables use of a user role requirement in your chat configuration.</p>', ], ], 'ChatConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration.</p>', 'DeleteChimeWebhookConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the ChimeWebhookConfiguration to delete.</p>', 'DeleteMicrosoftTeamsUserIdentityRequest$ChatConfigurationArn' => '<p>The ARN of the MicrosoftTeamsChannelConfiguration associated with the user identity to delete.</p>', 'DeleteSlackChannelConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the SlackChannelConfiguration to delete.</p>', 'DeleteSlackUserIdentityRequest$ChatConfigurationArn' => '<p>The ARN of the SlackChannelConfiguration associated with the user identity to delete.</p>', 'DeleteTeamsChannelConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration associated with the user identity to delete.</p>', 'DescribeChimeWebhookConfigurationsRequest$ChatConfigurationArn' => '<p>An optional Amazon Resource Number (ARN) of a ChimeWebhookConfiguration to describe.</p>', 'DescribeSlackChannelConfigurationsRequest$ChatConfigurationArn' => '<p>An optional Amazon Resource Number (ARN) of a SlackChannelConfiguration to describe.</p>', 'DescribeSlackUserIdentitiesRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the SlackChannelConfiguration associated with the user identities to describe.</p>', 'GetTeamsChannelConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the MicrosoftTeamsChannelConfiguration to retrieve.</p>', 'ListMicrosoftTeamsUserIdentitiesRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the MicrosoftTeamsChannelConfiguration associated with the user identities to list.</p>', 'SlackChannelConfiguration$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the SlackChannelConfiguration.</p>', 'SlackUserIdentity$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the SlackChannelConfiguration associated with the user identity to delete.</p>', 'TeamsChannelConfiguration$ChatConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration associated with the user identity to delete.</p>', 'TeamsUserIdentity$ChatConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration associated with the user identity to delete.</p>', 'UpdateChimeWebhookConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration to update.</p>', 'UpdateSlackChannelConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the SlackChannelConfiguration to update.</p>', 'UpdateTeamsChannelConfigurationRequest$ChatConfigurationArn' => '<p>The Amazon Resource Number (ARN) of the TeamsChannelConfiguration to update.</p>', ], ], 'ChimeWebhookConfiguration' => [ 'base' => '<p>An AWS Chatbot configuration for Amazon Chime.</p>', 'refs' => [ 'ChimeWebhookConfigurationList$member' => NULL, 'CreateChimeWebhookConfigurationResult$WebhookConfiguration' => '<p>An Amazon Chime webhook configuration.</p>', 'UpdateChimeWebhookConfigurationResult$WebhookConfiguration' => '<p>A Amazon Chime webhook configuration.</p>', ], ], 'ChimeWebhookConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeChimeWebhookConfigurationsResult$WebhookConfigurations' => '<p>A list of Amazon Chime webhooks associated with the account.</p>', ], ], 'ChimeWebhookDescription' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$WebhookDescription' => '<p>A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'CreateChimeWebhookConfigurationRequest$WebhookDescription' => '<p>A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'UpdateChimeWebhookConfigurationRequest$WebhookDescription' => '<p>A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', ], ], 'ChimeWebhookUrl' => [ 'base' => NULL, 'refs' => [ 'CreateChimeWebhookConfigurationRequest$WebhookUrl' => '<p>The URL for the Amazon Chime webhook.</p>', 'UpdateChimeWebhookConfigurationRequest$WebhookUrl' => '<p>The URL for the Amazon Chime webhook.</p>', ], ], 'ConfigurationName' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$ConfigurationName' => '<p>The name of the configuration.</p>', 'CreateChimeWebhookConfigurationRequest$ConfigurationName' => '<p>The name of the configuration.</p>', 'CreateSlackChannelConfigurationRequest$ConfigurationName' => '<p>The name of the configuration.</p>', 'CreateTeamsChannelConfigurationRequest$ConfigurationName' => '<p>The name of the configuration.</p>', 'SlackChannelConfiguration$ConfigurationName' => '<p>The name of the configuration.</p>', 'TeamsChannelConfiguration$ConfigurationName' => '<p>The name of the configuration.</p>', ], ], 'ConfiguredTeam' => [ 'base' => '<p>A Microsoft Teams team that is authorized with AWS Chatbot.</p>', 'refs' => [ 'ConfiguredTeamsList$member' => NULL, ], ], 'ConfiguredTeamsList' => [ 'base' => NULL, 'refs' => [ 'ListMicrosoftTeamsConfiguredTeamsResult$ConfiguredTeams' => '<p>A list of teams in Microsoft Teams that are configured with AWS Chatbot.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was an issue processing your request.</p>', 'refs' => [], ], 'CreateChimeWebhookConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'CreateChimeWebhookConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChimeWebhookConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlackChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'CreateSlackChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlackChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTeamsChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'CreateTeamsChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTeamsChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CustomerCwLogLevel' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'CreateChimeWebhookConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'CreateSlackChannelConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'CreateTeamsChannelConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'SlackChannelConfiguration$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'TeamsChannelConfiguration$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'UpdateChimeWebhookConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'UpdateSlackChannelConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', 'UpdateTeamsChannelConfigurationRequest$LoggingLevel' => '<p>Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.</p>', ], ], 'DeleteChimeWebhookConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteChimeWebhookConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChimeWebhookConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMicrosoftTeamsUserIdentityException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteMicrosoftTeamsUserIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMicrosoftTeamsUserIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteSlackChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackUserIdentityException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteSlackUserIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackUserIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackWorkspaceAuthorizationFault' => [ 'base' => '<p>There was an issue deleting your Slack workspace.</p>', 'refs' => [], ], 'DeleteSlackWorkspaceAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlackWorkspaceAuthorizationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTeamsChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteTeamsChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTeamsChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTeamsConfiguredTeamException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DeleteTeamsConfiguredTeamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTeamsConfiguredTeamResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChimeWebhookConfigurationsException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DescribeChimeWebhookConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChimeWebhookConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackChannelConfigurationsException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DescribeSlackChannelConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackChannelConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackUserIdentitiesException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DescribeSlackUserIdentitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackUserIdentitiesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackWorkspacesException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'DescribeSlackWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlackWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'CreateChimeWebhookConfigurationException$Message' => NULL, 'CreateSlackChannelConfigurationException$Message' => NULL, 'CreateTeamsChannelConfigurationException$Message' => NULL, 'DeleteChimeWebhookConfigurationException$Message' => NULL, 'DeleteMicrosoftTeamsUserIdentityException$Message' => NULL, 'DeleteSlackChannelConfigurationException$Message' => NULL, 'DeleteSlackUserIdentityException$Message' => NULL, 'DeleteSlackWorkspaceAuthorizationFault$Message' => NULL, 'DeleteTeamsChannelConfigurationException$Message' => NULL, 'DeleteTeamsConfiguredTeamException$Message' => NULL, 'DescribeChimeWebhookConfigurationsException$Message' => NULL, 'DescribeSlackChannelConfigurationsException$Message' => NULL, 'DescribeSlackUserIdentitiesException$Message' => NULL, 'DescribeSlackWorkspacesException$Message' => NULL, 'GetAccountPreferencesException$Message' => NULL, 'GetTeamsChannelConfigurationException$Message' => NULL, 'InternalServiceError$Message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidRequestException$message' => NULL, 'LimitExceededException$message' => NULL, 'ListMicrosoftTeamsConfiguredTeamsException$Message' => NULL, 'ListMicrosoftTeamsUserIdentitiesException$Message' => NULL, 'ListTeamsChannelConfigurationsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceUnavailableException$message' => NULL, 'TooManyTagsException$message' => NULL, 'UpdateAccountPreferencesException$Message' => NULL, 'UpdateChimeWebhookConfigurationException$Message' => NULL, 'UpdateSlackChannelConfigurationException$Message' => NULL, 'UpdateTeamsChannelConfigurationException$Message' => NULL, ], ], 'GetAccountPreferencesException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'GetAccountPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountPreferencesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetTeamsChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'GetTeamsChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTeamsChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'GuardrailPolicyArn' => [ 'base' => NULL, 'refs' => [ 'GuardrailPolicyArnList$member' => NULL, ], ], 'GuardrailPolicyArnList' => [ 'base' => NULL, 'refs' => [ 'CreateSlackChannelConfigurationRequest$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', 'CreateTeamsChannelConfigurationRequest$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', 'SlackChannelConfiguration$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', 'TeamsChannelConfiguration$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', 'UpdateSlackChannelConfigurationRequest$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', 'UpdateTeamsChannelConfigurationRequest$GuardrailPolicyArns' => '<p>The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed <code>AdministratorAccess</code> policy is applied by default if this is not set. </p>', ], ], 'InternalServiceError' => [ 'base' => '<p>Unexpected error during processing of request.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Your request input doesn\'t meet the constraints required by AWS Chatbot.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Your request input doesn\'t meet the constraints required by AWS Chatbot.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>You have exceeded a service limit for AWS Chatbot.</p>', 'refs' => [], ], 'ListMicrosoftTeamsConfiguredTeamsException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'ListMicrosoftTeamsConfiguredTeamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMicrosoftTeamsConfiguredTeamsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListMicrosoftTeamsUserIdentitiesException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'ListMicrosoftTeamsUserIdentitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMicrosoftTeamsUserIdentitiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTeamsChannelConfigurationsException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'ListTeamsChannelConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTeamsChannelConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeChimeWebhookConfigurationsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'DescribeSlackChannelConfigurationsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'DescribeSlackUserIdentitiesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'DescribeSlackWorkspacesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'ListMicrosoftTeamsConfiguredTeamsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListMicrosoftTeamsUserIdentitiesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'ListTeamsChannelConfigurationsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeChimeWebhookConfigurationsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeChimeWebhookConfigurationsResult$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackChannelConfigurationsRequest$NextToken' => '<p> An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackChannelConfigurationsResult$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackUserIdentitiesRequest$NextToken' => '<p> An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackUserIdentitiesResult$NextToken' => '<p> An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackWorkspacesRequest$NextToken' => '<p> An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'DescribeSlackWorkspacesResult$NextToken' => '<p> An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'ListMicrosoftTeamsConfiguredTeamsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.</p>', 'ListMicrosoftTeamsConfiguredTeamsResult$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.</p>', 'ListMicrosoftTeamsUserIdentitiesRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'ListMicrosoftTeamsUserIdentitiesResult$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'ListTeamsChannelConfigurationsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.</p>', 'ListTeamsChannelConfigurationsResult$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>We were unable to find the resource for your request</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'SlackChannelConfiguration' => [ 'base' => '<p>An AWS Chatbot configuration for Slack.</p>', 'refs' => [ 'CreateSlackChannelConfigurationResult$ChannelConfiguration' => '<p>The configuration for a Slack channel configured with AWS Chatbot.</p>', 'SlackChannelConfigurationList$member' => NULL, 'UpdateSlackChannelConfigurationResult$ChannelConfiguration' => '<p>The configuration for a Slack channel configured with AWS Chatbot.</p>', ], ], 'SlackChannelConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeSlackChannelConfigurationsResult$SlackChannelConfigurations' => '<p>A list of Slack channel configurations.</p>', ], ], 'SlackChannelDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateSlackChannelConfigurationRequest$SlackChannelName' => '<p>The name of the Slack channel.</p>', 'SlackChannelConfiguration$SlackChannelName' => '<p>The name of the Slack channel.</p>', 'UpdateSlackChannelConfigurationRequest$SlackChannelName' => '<p>The name of the Slack channel.</p>', ], ], 'SlackChannelId' => [ 'base' => NULL, 'refs' => [ 'CreateSlackChannelConfigurationRequest$SlackChannelId' => '<p>The ID of the Slack channel.</p> <p>To get this ID, open Slack, right click on the channel name in the left pane, then choose Copy Link. The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ. </p>', 'SlackChannelConfiguration$SlackChannelId' => '<p>The ID of the Slack channel.</p> <p>To get this ID, open Slack, right click on the channel name in the left pane, then choose Copy Link. The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ. </p>', 'UpdateSlackChannelConfigurationRequest$SlackChannelId' => '<p>The ID of the Slack channel.</p> <p>To get this ID, open Slack, right click on the channel name in the left pane, then choose Copy Link. The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ. </p>', ], ], 'SlackTeamId' => [ 'base' => NULL, 'refs' => [ 'CreateSlackChannelConfigurationRequest$SlackTeamId' => '<p>The ID of the Slack workspace authorized with AWS Chatbot.</p>', 'DeleteSlackUserIdentityRequest$SlackTeamId' => '<p>The ID of the Slack workspace authorized with AWS Chatbot.</p>', 'DeleteSlackWorkspaceAuthorizationRequest$SlackTeamId' => '<p>The ID of the Slack workspace authorized with AWS Chatbot.</p>', 'SlackChannelConfiguration$SlackTeamId' => '<p>The ID of the Slack workspace authorized with Amazon Chime.</p>', 'SlackUserIdentity$SlackTeamId' => '<p>The ID of the Slack workspace authorized with AWS Chatbot.</p>', 'SlackWorkspace$SlackTeamId' => '<p>The ID of the Slack workspace authorized with AWS Chatbot.</p>', ], ], 'SlackTeamName' => [ 'base' => NULL, 'refs' => [ 'SlackChannelConfiguration$SlackTeamName' => '<p>Name of the Slack workspace.</p>', 'SlackWorkspace$SlackTeamName' => '<p>The name of the Slack workspace.</p>', ], ], 'SlackUserId' => [ 'base' => NULL, 'refs' => [ 'DeleteSlackUserIdentityRequest$SlackUserId' => '<p>The ID of the user in Slack</p>', 'SlackUserIdentity$SlackUserId' => '<p>The ID of the user in Slack</p>', ], ], 'SlackUserIdentitiesList' => [ 'base' => NULL, 'refs' => [ 'DescribeSlackUserIdentitiesResult$SlackUserIdentities' => '<p>A list of Slack User Identities.</p>', ], ], 'SlackUserIdentity' => [ 'base' => '<p>Identifes a user level permission for a channel configuration. </p>', 'refs' => [ 'SlackUserIdentitiesList$member' => NULL, ], ], 'SlackWorkspace' => [ 'base' => '<p>A Slack workspace. </p>', 'refs' => [ 'SlackWorkspacesList$member' => NULL, ], ], 'SlackWorkspacesList' => [ 'base' => NULL, 'refs' => [ 'DescribeSlackWorkspacesResult$SlackWorkspaces' => '<p>A list of Slack workspaces registered with AWS Chatbot.</p>', ], ], 'SnsTopicArnList' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'CreateChimeWebhookConfigurationRequest$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'CreateSlackChannelConfigurationRequest$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'CreateTeamsChannelConfigurationRequest$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'SlackChannelConfiguration$SnsTopicArns' => '<p>The ARNs of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'TeamsChannelConfiguration$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'UpdateChimeWebhookConfigurationRequest$SnsTopicArns' => '<p>The ARNs of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'UpdateSlackChannelConfigurationRequest$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', 'UpdateTeamsChannelConfigurationRequest$SnsTopicArns' => '<p>The Amazon Resource Names (ARNs) of the SNS topics that deliver notifications to AWS Chatbot.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p> <important> <p>Do not include confidential or sensitive information in this field. </p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'refs' => [ 'TagList$member' => NULL, 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$TagKey' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for resources by type. This metadata can be attached to resources for any purpose.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and searching for items. Tags are metadata that you define.</p>', 'TagResourceRequest$Tags' => '<p>A list of tags to apply to the configuration.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$TagValue' => '<p>The value of the tag.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'ChimeWebhookConfiguration$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', 'CreateChimeWebhookConfigurationRequest$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', 'CreateSlackChannelConfigurationRequest$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', 'CreateTeamsChannelConfigurationRequest$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', 'SlackChannelConfiguration$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', 'TeamsChannelConfiguration$Tags' => '<p>A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.</p>', ], ], 'TeamChannelConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'ListTeamsChannelConfigurationsResult$TeamChannelConfigurations' => '<p>A list of AWS Chatbot channel configurations for Microsoft Teams.</p>', ], ], 'TeamName' => [ 'base' => NULL, 'refs' => [ 'CreateTeamsChannelConfigurationRequest$TeamName' => '<p>The name of the Microsoft Teams Team.</p>', 'TeamsChannelConfiguration$TeamName' => '<p>The name of the Microsoft Teams Team.</p>', ], ], 'TeamsChannelConfiguration' => [ 'base' => '<p>An AWS Chatbot configuration for Microsoft Teams.</p>', 'refs' => [ 'CreateTeamsChannelConfigurationResult$ChannelConfiguration' => '<p>The configuration for a Microsoft Teams channel configured with AWS Chatbot.</p>', 'GetTeamsChannelConfigurationResult$ChannelConfiguration' => '<p>The configuration for a Microsoft Teams channel configured with AWS Chatbot.</p>', 'TeamChannelConfigurationsList$member' => NULL, 'UpdateTeamsChannelConfigurationResult$ChannelConfiguration' => '<p>The configuration for a Microsoft Teams channel configured with AWS Chatbot.</p>', ], ], 'TeamsChannelId' => [ 'base' => NULL, 'refs' => [ 'CreateTeamsChannelConfigurationRequest$ChannelId' => '<p>The ID of the Microsoft Teams channel.</p>', 'TeamsChannelConfiguration$ChannelId' => '<p>The ID of the Microsoft Teams channel.</p>', 'TeamsUserIdentity$TeamsChannelId' => '<p>The ID of the Microsoft Teams channel.</p>', 'UpdateTeamsChannelConfigurationRequest$ChannelId' => '<p>The ID of the Microsoft Teams channel.</p>', ], ], 'TeamsChannelName' => [ 'base' => NULL, 'refs' => [ 'CreateTeamsChannelConfigurationRequest$ChannelName' => '<p>The name of the Microsoft Teams channel.</p>', 'TeamsChannelConfiguration$ChannelName' => '<p>The name of the Microsoft Teams channel.</p>', 'UpdateTeamsChannelConfigurationRequest$ChannelName' => '<p>The name of the Microsoft Teams channel.</p>', ], ], 'TeamsUserIdentitiesList' => [ 'base' => NULL, 'refs' => [ 'ListMicrosoftTeamsUserIdentitiesResult$TeamsUserIdentities' => '<p>User level permissions associated to a channel configuration.</p>', ], ], 'TeamsUserIdentity' => [ 'base' => '<p>Identifes a user level permission for a channel configuration.</p>', 'refs' => [ 'TeamsUserIdentitiesList$member' => NULL, ], ], 'TooManyTagsException' => [ 'base' => '<p>The supplied list of tags contains too many tags.</p>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTeam$TenantId' => '<p>The ID of the Microsoft Teams tenant.</p>', 'ConfiguredTeam$TeamId' => '<p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'ConfiguredTeam$TeamName' => '<p>The name of the Microsoft Teams Team.</p>', 'CreateTeamsChannelConfigurationRequest$TeamId' => '<p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'CreateTeamsChannelConfigurationRequest$TenantId' => '<p>The ID of the Microsoft Teams tenant.</p>', 'DeleteMicrosoftTeamsUserIdentityRequest$UserId' => '<p>The Microsoft Teams user ID.</p>', 'DeleteTeamsConfiguredTeamRequest$TeamId' => '<p>The ID of the Microsoft Teams team authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'ListTeamsChannelConfigurationsRequest$TeamId' => '<p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'TeamsChannelConfiguration$TeamId' => '<p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'TeamsChannelConfiguration$TenantId' => '<p>The ID of the Microsoft Teams tenant.</p>', 'TeamsUserIdentity$TeamId' => '<p> The ID of the Microsoft Teams authorized with AWS Chatbot.</p> <p>To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>. </p>', 'TeamsUserIdentity$UserId' => '<p>The Microsoft Teams user ID.</p>', 'TeamsUserIdentity$TeamsTenantId' => '<p>The ID of the Microsoft Teams tenant.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountPreferencesException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'UpdateAccountPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountPreferencesResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChimeWebhookConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'UpdateChimeWebhookConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChimeWebhookConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlackChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'UpdateSlackChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlackChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTeamsChannelConfigurationException' => [ 'base' => '<p>We can’t process your request right now because of a server issue. Try again later.</p>', 'refs' => [], ], 'UpdateTeamsChannelConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTeamsChannelConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], ],];
