<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-identity/2021-04-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK Identity APIs in this section allow software developers to create and manage unique instances of their messaging applications. These APIs provide the overarching framework for creating and sending messages. For more information about the identity APIs, refer to <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Identity.html">Amazon Chime SDK identity</a>.</p>', 'operations' => [ 'CreateAppInstance' => '<p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p> <p>identity</p>', 'CreateAppInstanceAdmin' => '<p>Promotes an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> to an <code>AppInstanceAdmin</code>. The promoted entity can perform the following actions. </p> <ul> <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li> <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li> </ul> <p>Only an <code>AppInstanceUser</code> and <code>AppInstanceBot</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>', 'CreateAppInstanceBot' => '<p>Creates a bot under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>Configuration</code> and <code>Name</code> for that bot.</p>', 'CreateAppInstanceUser' => '<p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>', 'DeleteAppInstance' => '<p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>', 'DeleteAppInstanceAdmin' => '<p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code> or <code>AppInstanceBot</code>. This action does not delete the user.</p>', 'DeleteAppInstanceBot' => '<p>Deletes an <code>AppInstanceBot</code>.</p>', 'DeleteAppInstanceUser' => '<p>Deletes an <code>AppInstanceUser</code>.</p>', 'DeregisterAppInstanceUserEndpoint' => '<p>Deregisters an <code>AppInstanceUserEndpoint</code>.</p>', 'DescribeAppInstance' => '<p>Returns the full details of an <code>AppInstance</code>.</p>', 'DescribeAppInstanceAdmin' => '<p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceBot' => '<p>The <code>AppInstanceBot\'s</code> information.</p>', 'DescribeAppInstanceUser' => '<p>Returns the full details of an <code>AppInstanceUser</code>.</p>', 'DescribeAppInstanceUserEndpoint' => '<p>Returns the full details of an <code>AppInstanceUserEndpoint</code>.</p>', 'GetAppInstanceRetentionSettings' => '<p>Gets the retention settings for an <code>AppInstance</code>.</p>', 'ListAppInstanceAdmins' => '<p>Returns a list of the administrators in the <code>AppInstance</code>.</p>', 'ListAppInstanceBots' => '<p>Lists all <code>AppInstanceBots</code> created under a single <code>AppInstance</code>.</p>', 'ListAppInstanceUserEndpoints' => '<p>Lists all the <code>AppInstanceUserEndpoints</code> created under a single <code>AppInstanceUser</code>.</p>', 'ListAppInstanceUsers' => '<p>List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.</p>', 'ListAppInstances' => '<p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to an Amazon Chime SDK identity resource.</p>', 'PutAppInstanceRetentionSettings' => '<p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>', 'PutAppInstanceUserExpirationSettings' => '<p>Sets the number of days before the <code>AppInstanceUser</code> is automatically deleted.</p> <note> <p>A background process deletes expired <code>AppInstanceUsers</code> within 6 hours of expiration. Actual deletion times may vary.</p> <p>Expired <code>AppInstanceUsers</code> that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.</p> </note>', 'RegisterAppInstanceUserEndpoint' => '<p>Registers an endpoint under an Amazon Chime <code>AppInstanceUser</code>. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>', 'TagResource' => '<p>Applies the specified tags to the specified Amazon Chime SDK identity resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified Amazon Chime SDK identity resource.</p>', 'UpdateAppInstance' => '<p>Updates <code>AppInstance</code> metadata.</p>', 'UpdateAppInstanceBot' => '<p>Updates the name and metadata of an <code>AppInstanceBot</code>.</p>', 'UpdateAppInstanceUser' => '<p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>', 'UpdateAppInstanceUserEndpoint' => '<p>Updates the details of an <code>AppInstanceUserEndpoint</code>. You can update the name and <code>AllowMessage</code> values.</p>', ], 'shapes' => [ 'AllowMessages' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserEndpoint$AllowMessages' => '<p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>', 'AppInstanceUserEndpointSummary$AllowMessages' => '<p>BBoolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>', 'RegisterAppInstanceUserEndpointRequest$AllowMessages' => '<p>Boolean that controls whether the AppInstanceUserEndpoint is opted in to receive messages. <code>ALL</code> indicates the endpoint receives all messages. <code>NONE</code> indicates the endpoint receives no messages.</p>', 'UpdateAppInstanceUserEndpointRequest$AllowMessages' => '<p>Boolean that controls whether the <code>AppInstanceUserEndpoint</code> is opted in to receive messages. <code>ALL</code> indicates the endpoint will receive all messages. <code>NONE</code> indicates the endpoint will receive no messages.</p>', ], ], 'AppInstance' => [ 'base' => '<p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>', 'refs' => [ 'DescribeAppInstanceResponse$AppInstance' => '<p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdmin' => [ 'base' => '<p>The name and ARN of the admin for the <code>AppInstance</code>.</p>', 'refs' => [ 'DescribeAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdminList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsResponse$AppInstanceAdmins' => '<p>The information for each administrator.</p>', ], ], 'AppInstanceAdminSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>', 'refs' => [ 'AppInstanceAdminList$member' => NULL, ], ], 'AppInstanceBot' => [ 'base' => '<p>An Amazon Lex V2 chat bot created under an <code>AppInstance</code>.</p>', 'refs' => [ 'DescribeAppInstanceBotResponse$AppInstanceBot' => '<p>The detials of the <code>AppInstanceBot</code>.</p>', ], ], 'AppInstanceBotList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceBotsResponse$AppInstanceBots' => '<p>The information for each requested <code>AppInstanceBot</code>.</p>', ], ], 'AppInstanceBotSummary' => [ 'base' => '<p>High-level information about an AppInstanceBot.</p>', 'refs' => [ 'AppInstanceBotList$member' => NULL, ], ], 'AppInstanceList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstancesResponse$AppInstances' => '<p>The information for each <code>AppInstance</code>.</p>', ], ], 'AppInstanceRetentionSettings' => [ 'base' => '<p>The details of the data-retention settings for an <code>AppInstance</code>.</p>', 'refs' => [ 'GetAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The retention settings for the <code>AppInstance</code>.</p>', 'PutAppInstanceRetentionSettingsRequest$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', 'PutAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', ], ], 'AppInstanceSummary' => [ 'base' => '<p>Summary of the data for an <code>AppInstance</code>.</p>', 'refs' => [ 'AppInstanceList$member' => NULL, ], ], 'AppInstanceUser' => [ 'base' => '<p>The details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'DescribeAppInstanceUserResponse$AppInstanceUser' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserEndpoint' => [ 'base' => '<p>An endpoint under an Amazon Chime <code>AppInstanceUser</code> that receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>', 'refs' => [ 'DescribeAppInstanceUserEndpointResponse$AppInstanceUserEndpoint' => '<p>The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceUserEndpointSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceUserEndpoint</code>.</p>', 'refs' => [ 'AppInstanceUserEndpointSummaryList$member' => NULL, ], ], 'AppInstanceUserEndpointSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceUserEndpointsResponse$AppInstanceUserEndpoints' => '<p>The information for each requested <code>AppInstanceUserEndpoint</code>.</p>', ], ], 'AppInstanceUserEndpointType' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserEndpoint$Type' => '<p>The type of the <code>AppInstanceUserEndpoint</code>.</p>', 'AppInstanceUserEndpointSummary$Type' => '<p>The type of the <code>AppInstanceUserEndpoint</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$Type' => '<p>The type of the <code>AppInstanceUserEndpoint</code>. Supported types:</p> <ul> <li> <p> <code>APNS</code>: The mobile notification service for an Apple device.</p> </li> <li> <p> <code>APNS_SANDBOX</code>: The sandbox environment of the mobile notification service for an Apple device.</p> </li> <li> <p> <code>GCM</code>: The mobile notification service for an Android device.</p> </li> </ul> <p>Populate the <code>ResourceArn</code> value of each type as <code>PinpointAppArn</code>.</p>', ], ], 'AppInstanceUserList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceUsersResponse$AppInstanceUsers' => '<p>The information for each requested <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'AppInstanceUserList$member' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'ChannelRetentionSettings' => [ 'base' => '<p>The details of the retention settings for a channel.</p>', 'refs' => [ 'AppInstanceRetentionSettings$ChannelRetentionSettings' => '<p>The length of time in days to retain the messages in a channel.</p>', ], ], 'ChimeArn' => [ 'base' => NULL, 'refs' => [ 'AppInstance$AppInstanceArn' => '<p>The ARN of the messaging instance.</p>', 'AppInstanceAdmin$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>', 'AppInstanceBot$AppInstanceBotArn' => '<p>The ARN of the AppInstanceBot.</p>', 'AppInstanceBotSummary$AppInstanceBotArn' => '<p>The ARN of the AppInstanceBot.</p>', 'AppInstanceSummary$AppInstanceArn' => '<p>The <code>AppInstance</code> ARN.</p>', 'AppInstanceUser$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserEndpoint$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserEndpoint$ResourceArn' => '<p>The ARN of the resource to which the endpoint belongs.</p>', 'AppInstanceUserEndpointSummary$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the administrator of the current <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminResponse$AppInstanceArn' => '<p>The ARN of the of the admin for the <code>AppInstance</code>.</p>', 'CreateAppInstanceBotRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> request.</p>', 'CreateAppInstanceBotResponse$AppInstanceBotArn' => '<p>The ARN of the <code>AppinstanceBot</code>.</p>', 'CreateAppInstanceResponse$AppInstanceArn' => '<p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> request.</p>', 'CreateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The user\'s ARN.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstance</code>\'s administrator.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceBotRequest$AppInstanceBotArn' => '<p>The ARN of the <code>AppInstanceBot</code> being deleted.</p>', 'DeleteAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user request being deleted.</p>', 'DeregisterAppInstanceUserEndpointRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceBotRequest$AppInstanceBotArn' => '<p>The ARN of the <code>AppInstanceBot</code>.</p>', 'DescribeAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'GetAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'Identity$Arn' => '<p>The ARN in an Identity.</p>', 'ListAppInstanceAdminsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceAdminsResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceBotsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceBotsResponse$AppInstanceArn' => '<p>The ARN of the AppInstance.</p>', 'ListAppInstanceUsersRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceUsersResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'PutAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'PutAppInstanceUserExpirationSettingsRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'PutAppInstanceUserExpirationSettingsResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$ResourceArn' => '<p>The ARN of the resource to which the endpoint belongs.</p>', 'RegisterAppInstanceUserEndpointResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UpdateAppInstanceBotRequest$AppInstanceBotArn' => '<p>The ARN of the <code>AppInstanceBot</code>.</p>', 'UpdateAppInstanceBotResponse$AppInstanceBotArn' => '<p>The ARN of the <code>AppInstanceBot</code>.</p>', 'UpdateAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceUserEndpointRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateAppInstanceUserEndpointResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceBotRequest$ClientRequestToken' => '<p>The unique ID for the client making the request. Use different tokens for different <code>AppInstanceBots</code>.</p>', 'CreateAppInstanceRequest$ClientRequestToken' => '<p>The unique ID of the request. Use different tokens to create different <code>AppInstances</code>.</p>', 'CreateAppInstanceUserRequest$ClientRequestToken' => '<p>The unique ID of the request. Use different tokens to request additional <code>AppInstances</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$ClientRequestToken' => '<p>The unique ID assigned to the request. Use different tokens to register other endpoints.</p>', ], ], 'Configuration' => [ 'base' => '<p>A structure that contains configuration data.</p>', 'refs' => [ 'AppInstanceBot$Configuration' => '<p>The data processing instructions for an AppInstanceBot.</p>', 'CreateAppInstanceBotRequest$Configuration' => '<p>Configuration information about the Amazon Lex V2 V2 bot.</p>', 'UpdateAppInstanceBotRequest$Configuration' => '<p>The configuration for the bot update.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'CreateAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterAppInstanceUserEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'EndpointAttributes' => [ 'base' => '<p>The attributes of an <code>Endpoint</code>.</p>', 'refs' => [ 'AppInstanceUserEndpoint$EndpointAttributes' => '<p>The attributes of an <code>Endpoint</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$EndpointAttributes' => '<p>The attributes of an <code>Endpoint</code>.</p>', ], ], 'EndpointState' => [ 'base' => '<p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p> <ul> <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li> <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can\'t receive message. When INACTIVE, the corresponding reason will be conveyed through EndpointStatusReason.</p> </li> <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li> <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li> </ul>', 'refs' => [ 'AppInstanceUserEndpoint$EndpointState' => '<p>A read-only field that represents the state of an <code>AppInstanceUserEndpoint</code>. Supported values:</p> <ul> <li> <p> <code>ACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is active and able to receive messages. When <code>ACTIVE</code>, the <code>EndpointStatusReason</code> remains empty.</p> </li> <li> <p> <code>INACTIVE</code>: The <code>AppInstanceUserEndpoint</code> is inactive and can\'t receive message. When <code>INACTIVE</code>, the corresponding reason will be conveyed through <code>EndpointStatusReason</code>.</p> </li> <li> <p> <code>INVALID_DEVICE_TOKEN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to invalid device token</p> </li> <li> <p> <code>INVALID_PINPOINT_ARN</code> indicates that an <code>AppInstanceUserEndpoint</code> is <code>INACTIVE</code> due to an invalid pinpoint ARN that was input through the <code>ResourceArn</code> field.</p> </li> </ul>', 'AppInstanceUserEndpointSummary$EndpointState' => '<p>A read-only field that represent the state of an <code>AppInstanceUserEndpoint</code>.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'EndpointState$Status' => '<p>Enum that indicates the Status of an <code>AppInstanceUserEndpoint</code>.</p>', ], ], 'EndpointStatusReason' => [ 'base' => NULL, 'refs' => [ 'EndpointState$StatusReason' => '<p>The reason for the <code>EndpointStatus</code>.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Code' => NULL, 'ConflictException$Code' => NULL, 'ForbiddenException$Code' => NULL, 'NotFoundException$Code' => NULL, 'ResourceLimitExceededException$Code' => NULL, 'ServiceFailureException$Code' => NULL, 'ServiceUnavailableException$Code' => NULL, 'ThrottledClientException$Code' => NULL, 'UnauthorizedClientException$Code' => NULL, ], ], 'ExpirationCriterion' => [ 'base' => NULL, 'refs' => [ 'ExpirationSettings$ExpirationCriterion' => '<p>Specifies the conditions under which an <code>AppInstanceUser</code> will expire.</p>', ], ], 'ExpirationDays' => [ 'base' => NULL, 'refs' => [ 'ExpirationSettings$ExpirationDays' => '<p>The period in days after which an <code>AppInstanceUser</code> will be automatically deleted.</p>', ], ], 'ExpirationSettings' => [ 'base' => '<p>Determines the interval after which an <code>AppInstanceUser</code> is automatically deleted.</p>', 'refs' => [ 'AppInstanceUser$ExpirationSettings' => '<p>The interval after which an <code>AppInstanceUser</code> is automatically deleted.</p>', 'CreateAppInstanceUserRequest$ExpirationSettings' => '<p>Settings that control the interval after which the <code>AppInstanceUser</code> is automatically deleted.</p>', 'PutAppInstanceUserExpirationSettingsRequest$ExpirationSettings' => '<p>Settings that control the interval after which an <code>AppInstanceUser</code> is automatically deleted.</p>', 'PutAppInstanceUserExpirationSettingsResponse$ExpirationSettings' => '<p>Settings that control the interval after which an <code>AppInstanceUser</code> is automatically deleted.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'GetAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identity' => [ 'base' => '<p>The details of a user or bot.</p>', 'refs' => [ 'AppInstanceAdmin$Admin' => '<p>The <code>AppInstanceAdmin</code> data.</p>', 'AppInstanceAdminSummary$Admin' => '<p>The details of the <code>AppInstanceAdmin</code>.</p>', 'CreateAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The ARN and name of the administrator, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>', ], ], 'InvokedBy' => [ 'base' => '<p>Specifies the type of message that triggers a bot.</p>', 'refs' => [ 'LexConfiguration$InvokedBy' => '<p>Specifies the type of message that triggers a bot.</p>', ], ], 'LexBotAliasArn' => [ 'base' => NULL, 'refs' => [ 'LexConfiguration$LexBotAliasArn' => '<p>The ARN of the Amazon Lex V2 bot\'s alias. The ARN uses this format: <code>arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS</code> </p>', ], ], 'LexConfiguration' => [ 'base' => '<p>The configuration for an Amazon Lex V2 bot.</p>', 'refs' => [ 'Configuration$Lex' => '<p>The configuration for an Amazon Lex V2 bot.</p>', ], ], 'LexIntentName' => [ 'base' => NULL, 'refs' => [ 'LexConfiguration$WelcomeIntent' => '<p>The name of the welcome intent configured in the Amazon Lex V2 bot.</p>', ], ], 'ListAppInstanceAdminsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceAdminsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUserEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUserEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$MaxResults' => '<p>The maximum number of administrators that you want to return.</p>', 'ListAppInstanceBotsRequest$MaxResults' => '<p>The maximum number of requests to return.</p>', 'ListAppInstanceUserEndpointsRequest$MaxResults' => '<p>The maximum number of endpoints that you want to return.</p>', 'ListAppInstanceUsersRequest$MaxResults' => '<p>The maximum number of requests that you want returned.</p>', 'ListAppInstancesRequest$MaxResults' => '<p>The maximum number of <code>AppInstance</code>s that you want to return.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Metadata' => '<p>The metadata of an <code>AppInstance</code>.</p>', 'AppInstanceBot$Metadata' => '<p>The metadata for an AppInstanceBot.</p>', 'AppInstanceBotSummary$Metadata' => '<p>The metadata of the AppInstanceBot.</p>', 'AppInstanceSummary$Metadata' => '<p>The metadata of the <code>AppInstance</code>.</p>', 'AppInstanceUser$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceBotRequest$Metadata' => '<p>The request metadata. Limited to a 1KB string in UTF-8.</p>', 'CreateAppInstanceRequest$Metadata' => '<p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>', 'CreateAppInstanceUserRequest$Metadata' => '<p>The request\'s metadata. Limited to a 1KB string in UTF-8.</p>', 'UpdateAppInstanceBotRequest$Metadata' => '<p>The metadata of the <code>AppInstanceBot</code>.</p>', 'UpdateAppInstanceRequest$Metadata' => '<p>The metadata that you want to change.</p>', 'UpdateAppInstanceUserRequest$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceAdminsResponse$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceBotsRequest$NextToken' => '<p>The token passed by previous API calls until all requested bots are returned.</p>', 'ListAppInstanceBotsResponse$NextToken' => '<p>The token passed by previous API calls until all requested bots are returned.</p>', 'ListAppInstanceUserEndpointsRequest$NextToken' => '<p>The token passed by previous API calls until all requested endpoints are returned.</p>', 'ListAppInstanceUserEndpointsResponse$NextToken' => '<p>The token passed by previous API calls until all requested endpoints are returned.</p>', 'ListAppInstanceUsersRequest$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstanceUsersResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstancesRequest$NextToken' => '<p>The token passed by previous API requests until you reach the maximum number of <code>AppInstances</code>.</p>', 'ListAppInstancesResponse$NextToken' => '<p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>', ], ], 'NonEmptyResourceName' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Name' => '<p>The name of an <code>AppInstance</code>.</p>', 'AppInstanceSummary$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'CreateAppInstanceRequest$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceRequest$Name' => '<p>The name that you want to change.</p>', ], ], 'NonEmptySensitiveString1600' => [ 'base' => NULL, 'refs' => [ 'EndpointAttributes$DeviceToken' => '<p>The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.</p>', 'EndpointAttributes$VoipDeviceToken' => '<p>The VOIP device token for the APNS and APNS_SANDBOX endpoint types.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the resources in the request does not exist in the system.</p>', 'refs' => [], ], 'PutAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceUserExpirationSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceUserExpirationSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisterAppInstanceUserEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterAppInstanceUserEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AppInstanceBot$Name' => '<p>The name of the AppInstanceBot.</p>', 'AppInstanceBotSummary$Name' => '<p>The name of the AppInstanceBox.</p>', 'CreateAppInstanceBotRequest$Name' => '<p>The user\'s name.</p>', 'Identity$Name' => '<p>The name in an Identity.</p>', 'UpdateAppInstanceBotRequest$Name' => '<p>The name of the <code>AppInstanceBot</code>.</p>', ], ], 'RespondsTo' => [ 'base' => NULL, 'refs' => [ 'LexConfiguration$RespondsTo' => '<important> <p> <b>Deprecated</b>. Use <code>InvokedBy</code> instead.</p> </important> <p>Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not supported.</p>', ], ], 'RetentionDays' => [ 'base' => NULL, 'refs' => [ 'ChannelRetentionSettings$RetentionDays' => '<p>The time in days to retain the messages in a channel.</p>', ], ], 'SensitiveChimeArn' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceUserEndpointsRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', ], ], 'SensitiveString1600' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserEndpoint$Name' => '<p>The name of the <code>AppInstanceUserEndpoint</code>.</p>', 'AppInstanceUserEndpointSummary$Name' => '<p>The name of the <code>AppInstanceUserEndpoint</code>.</p>', 'RegisterAppInstanceUserEndpointRequest$Name' => '<p>The name of the <code>AppInstanceUserEndpoint</code>.</p>', 'UpdateAppInstanceUserEndpointRequest$Name' => '<p>The name of the <code>AppInstanceUserEndpoint</code>.</p>', ], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'StandardMessages' => [ 'base' => NULL, 'refs' => [ 'InvokedBy$StandardMessages' => '<p>Sets standard messages as the bot trigger. For standard messages:</p> <ul> <li> <p> <code>ALL</code>: The bot processes all standard messages.</p> </li> <li> <p> <code>AUTO</code>: The bot responds to ALL messages when the channel has one other non-hidden member, and responds to MENTIONS when the channel has more than one other non-hidden member.</p> </li> <li> <p> <code>MENTIONS</code>: The bot processes all standard messages that have a message attribute with <code>CHIME.mentions</code> and a value of the bot ARN.</p> </li> <li> <p> <code>NONE</code>: The bot processes no standard messages.</p> </li> </ul>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'ConflictException$Message' => NULL, 'ForbiddenException$Message' => NULL, 'LexConfiguration$LocaleId' => '<p>Identifies the Amazon Lex V2 bot\'s language and locale. The string must match one of the supported locales in Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> in the <i>Amazon Lex V2 Developer Guide</i>.</p>', 'NotFoundException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceFailureException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottledClientException$Message' => NULL, 'UnauthorizedClientException$Message' => NULL, ], ], 'String1600' => [ 'base' => NULL, 'refs' => [ 'DescribeAppInstanceUserEndpointRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', ], ], 'String64' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserEndpoint$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'AppInstanceUserEndpointSummary$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'DeregisterAppInstanceUserEndpointRequest$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'DescribeAppInstanceUserEndpointRequest$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'RegisterAppInstanceUserEndpointResponse$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'UpdateAppInstanceUserEndpointRequest$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', 'UpdateAppInstanceUserEndpointResponse$EndpointId' => '<p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag object containing a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key in a tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceBotRequest$Tags' => '<p>The tags assigned to the <code>AppInstanceBot</code>.</p>', 'CreateAppInstanceRequest$Tags' => '<p>Tags assigned to the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$Tags' => '<p>Tags assigned to the <code>AppInstanceUser</code>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tag key-value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value in a tag.</p>', ], ], 'TargetedMessages' => [ 'base' => NULL, 'refs' => [ 'InvokedBy$TargetedMessages' => '<p>Sets targeted messages as the bot trigger. For targeted messages:</p> <ul> <li> <p> <code>ALL</code>: The bot processes all <code>TargetedMessages</code> sent to it. The bot then responds with a targeted message back to the sender. </p> </li> <li> <p> <code>NONE</code>: The bot processes no targeted messages.</p> </li> </ul>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The client exceeded its request rate limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppInstance$CreatedTimestamp' => '<p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>', 'AppInstance$LastUpdatedTimestamp' => '<p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>', 'AppInstanceAdmin$CreatedTimestamp' => '<p>The time at which an administrator was created.</p>', 'AppInstanceBot$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceBot</code> was created.</p>', 'AppInstanceBot$LastUpdatedTimestamp' => '<p>The time at which the <code>AppInstanceBot</code> was last updated.</p>', 'AppInstanceUser$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was created.</p>', 'AppInstanceUser$LastUpdatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was last updated.</p>', 'AppInstanceUserEndpoint$CreatedTimestamp' => '<p>The time at which an <code>AppInstanceUserEndpoint</code> was created.</p>', 'AppInstanceUserEndpoint$LastUpdatedTimestamp' => '<p>The time at which an <code>AppInstanceUserEndpoint</code> was last updated.</p>', 'GetAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>', 'PutAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The time at which the API deletes data.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client is not currently authorized to make the request.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceUserRequest$AppInstanceUserId' => '<p>The user ID of the <code>AppInstance</code>.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUser$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Name' => '<p>The name of an <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceUserRequest$Name' => '<p>The user\'s name.</p>', 'UpdateAppInstanceUserRequest$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], ],];
