<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-meetings/2021-07-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK meetings APIs in this section allow software developers to create Amazon Chime SDK meetings, set the Amazon Web Services Regions for meetings, create and manage users, and send and receive meeting notifications. For more information about the meeting APIs, see <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Meetings.html">Amazon Chime SDK meetings</a>.</p>', 'operations' => [ 'BatchCreateAttendee' => '<p>Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'BatchUpdateAttendeeCapabilitiesExcept' => '<p>Updates <code>AttendeeCapabilities</code> except the capabilities listed in an <code>ExcludedAttendeeIds</code> table.</p> <note> <p>You use the capabilities with a set of values that control what the capabilities can do, such as <code>SendReceive</code> data. For more information about those values, see .</p> </note> <p>When using capabilities, be aware of these corner cases:</p> <ul> <li> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>You can\'t set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don\'t set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not receive.</p> </li> <li> <p>When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.</p> </li> <li> <p>When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.</p> </li> </ul>', 'CreateAttendee' => '<p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'CreateMeeting' => '<p>Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'CreateMeetingWithAttendees' => '<p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i>. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'DeleteAttendee' => '<p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'DeleteMeeting' => '<p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'GetAttendee' => '<p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'GetMeeting' => '<p>Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'ListAttendees' => '<p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'ListTagsForResource' => '<p>Returns a list of the tags available for the specified resource.</p>', 'StartMeetingTranscription' => '<p>Starts transcription for the specified <code>meetingId</code>. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/meeting-transcription.html"> Using Amazon Chime SDK live transcription </a> in the <i>Amazon Chime SDK Developer Guide</i>.</p> <p>If you specify an invalid configuration, a <code>TranscriptFailed</code> event will be sent with the contents of the <code>BadRequestException</code> generated by Amazon Transcribe. For more information on each parameter and which combinations are valid, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html">StartStreamTranscription</a> API in the <i>Amazon Transcribe Developer Guide</i>.</p> <note> <p>By default, Amazon Transcribe may use and store audio content processed by the service to develop and improve Amazon Web Services AI/ML services as further described in section 50 of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>. Using Amazon Transcribe may be subject to federal and state laws or regulations regarding the recording or interception of electronic communications. It is your and your end users’ responsibility to comply with all applicable laws regarding the recording, including properly notifying all participants in a recorded session or communication that the session or communication is being recorded, and obtaining all necessary consents. You can opt out from Amazon Web Services using audio content to develop and improve AWS AI/ML services by configuring an AI services opt out policy using Amazon Web Services Organizations.</p> </note>', 'StopMeetingTranscription' => '<p>Stops transcription for the specified <code>meetingId</code>. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/meeting-transcription.html"> Using Amazon Chime SDK live transcription </a> in the <i>Amazon Chime SDK Developer Guide</i>.</p> <important> <p>By default, Amazon Transcribe may use and store audio content processed by the service to develop and improve Amazon Web Services AI/ML services as further described in section 50 of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a>. Using Amazon Transcribe may be subject to federal and state laws or regulations regarding the recording or interception of electronic communications. It is your and your end users’ responsibility to comply with all applicable laws regarding the recording, including properly notifying all participants in a recorded session or communication that the session or communication is being recorded, and obtaining all necessary consents. You can opt out from Amazon Web Services using audio content to develop and improve Amazon Web Services AI/ML services by configuring an AI services opt out policy using Amazon Web Services Organizations.</p> </important>', 'TagResource' => '<p>The resource that supports tags.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resources. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from a resource that were already removed. Note the following:</p> <ul> <li> <p>To remove tags from a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for removing tags. For more information, see the documentation for the service whose resource you want to untag.</p> </li> <li> <p>You can only tag resources that are located in the specified Amazon Web Services Region for the calling Amazon Web Services account.</p> </li> </ul> <p> <b>Minimum permissions</b> </p> <p>In addition to the <code>tag:UntagResources</code> permission required by this operation, you must also have the remove tags permission defined by the service that created the resource. For example, to remove the tags from an Amazon EC2 instance using the <code>UntagResources</code> operation, you must have both of the following permissions:</p> <p> <code>tag:UntagResource</code> </p> <p> <code>ChimeSDKMeetings:DeleteTags</code> </p>', 'UpdateAttendeeCapabilities' => '<p>The capabilities that you want to update.</p> <note> <p>You use the capabilities with a set of values that control what the capabilities can do, such as <code>SendReceive</code> data. For more information about those values, see .</p> </note> <p>When using capabilities, be aware of these corner cases:</p> <ul> <li> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>You can\'t set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don\'t set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not receive.</p> </li> <li> <p>When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.</p> </li> <li> <p>When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.</p> </li> </ul>', ], 'shapes' => [ 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'Meeting$MeetingArn' => '<p>The ARN of the meeting.</p>', 'ResourceNotFoundException$ResourceName' => '<p>The name of the resource that couldn\'t be found.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'TooManyTagsException$ResourceName' => '<p>The name of the resource that received too many tags.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the resource that you\'re removing tags from.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'NotificationsConfiguration$LambdaFunctionArn' => '<p>The ARN of the Amazon Web Services Lambda function in the notifications configuration.</p>', 'NotificationsConfiguration$SnsTopicArn' => '<p>The ARN of the SNS topic.</p>', 'NotificationsConfiguration$SqsQueueArn' => '<p>The ARN of the SQS queue.</p>', ], ], 'Attendee' => [ 'base' => '<p>An Amazon Chime SDK meeting attendee. Includes a unique <code>AttendeeId</code> and <code>JoinToken</code>. The <code>JoinToken</code> allows a client to authenticate and join as the specified attendee. The <code>JoinToken</code> expires when the meeting ends, or when <a>DeleteAttendee</a> is called. After that, the attendee is unable to join the meeting. </p> <p>We recommend securely transferring each <code>JoinToken</code> from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.</p>', 'refs' => [ 'AttendeeList$member' => NULL, 'CreateAttendeeResponse$Attendee' => '<p>The attendee information, including attendee ID and join token.</p>', 'GetAttendeeResponse$Attendee' => '<p>The Amazon Chime SDK attendee information.</p>', 'UpdateAttendeeCapabilitiesResponse$Attendee' => '<p>The updated attendee data.</p>', ], ], 'AttendeeCapabilities' => [ 'base' => '<p>The media capabilities of an attendee: audio, video, or content.</p> <note> <p>You use the capabilities with a set of values that control what the capabilities can do, such as <code>SendReceive</code> data. For more information, refer to and .</p> </note> <p>When using capabilities, be aware of these corner cases:</p> <ul> <li> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>You can\'t set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don\'t set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not receive.</p> </li> <li> <p>When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and an attendee unmutes their microphone, audio flows from the attendee to the other meeting participants.</p> </li> <li> <p>When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and the attendee turns on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.</p> </li> </ul>', 'refs' => [ 'Attendee$Capabilities' => '<p>The capabilities assigned to an attendee: audio, video, or content.</p> <note> <p>You use the capabilities with a set of values that control what the capabilities can do, such as <code>SendReceive</code> data. For more information about those values, see .</p> </note> <p>When using capabilities, be aware of these corner cases:</p> <ul> <li> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>You can\'t set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don\'t set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not receive.</p> </li> <li> <p>When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.</p> </li> <li> <p>When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.</p> </li> </ul>', 'BatchUpdateAttendeeCapabilitiesExceptRequest$Capabilities' => '<p>The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to update.</p>', 'CreateAttendeeRequest$Capabilities' => '<p>The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to grant an attendee. If you don\'t specify capabilities, all users have send and receive capabilities on all media channels by default.</p> <note> <p>You use the capabilities with a set of values that control what the capabilities can do, such as <code>SendReceive</code> data. For more information about those values, see .</p> </note> <p>When using capabilities, be aware of these corner cases:</p> <ul> <li> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </li> <li> <p>You can\'t set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don\'t set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not receive.</p> </li> <li> <p>When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will flow from the attendee to the other meeting participants.</p> </li> <li> <p>When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video or content streams, remote attendees can receive those streams, but only after media renegotiation between the client and the Amazon Chime back-end server.</p> </li> </ul>', 'CreateAttendeeRequestItem$Capabilities' => '<p>A list of one or more capabilities.</p>', 'UpdateAttendeeCapabilitiesRequest$Capabilities' => '<p>The capabilities that you want to update.</p>', ], ], 'AttendeeFeatures' => [ 'base' => '<p>Lists the maximum number of attendees allowed into the meeting.</p> <note> <p>If you specify <code>FHD</code> for <code>MeetingFeatures:Video:MaxResolution</code>, or if you specify <code>UHD</code> for <code>MeetingFeatures:Content:MaxResolution</code>, the maximum number of attendees changes from the default of <code>250</code> to <code>25</code>.</p> </note>', 'refs' => [ 'MeetingFeaturesConfiguration$Attendee' => '<p>The configuration settings for the attendee features available to a meeting.</p>', ], ], 'AttendeeIdItem' => [ 'base' => '<p>A structure that contains one or more attendee IDs.</p>', 'refs' => [ 'AttendeeIdsList$member' => NULL, ], ], 'AttendeeIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateAttendeeCapabilitiesExceptRequest$ExcludedAttendeeIds' => '<p>The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.</p>', ], ], 'AttendeeList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeResponse$Attendees' => '<p>The attendee information, including attendees\' IDs and join tokens.</p>', 'CreateMeetingWithAttendeesResponse$Attendees' => '<p>The attendee information, including attendees\' IDs and join tokens.</p>', 'ListAttendeesResponse$Attendees' => '<p>The Amazon Chime SDK attendee information.</p>', ], ], 'AttendeeMax' => [ 'base' => NULL, 'refs' => [ 'AttendeeFeatures$MaxCount' => '<p>The maximum number of attendees allowed into the meeting.</p>', ], ], 'AudioFeatures' => [ 'base' => '<p>An optional category of meeting features that contains audio-specific configurations, such as operating parameters for Amazon Voice Focus. </p>', 'refs' => [ 'MeetingFeaturesConfiguration$Audio' => '<p>The configuration settings for the audio features available to a meeting.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'BatchCreateAttendeeErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeResponse$Errors' => '<p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>', 'CreateMeetingWithAttendeesResponse$Errors' => '<p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>', ], ], 'BatchCreateAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateAttendeeCapabilitiesExceptRequest' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$EnablePartialResultsStabilization' => '<p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy.</p>', 'EngineTranscribeSettings$IdentifyLanguage' => '<p>Enables automatic language identification for your transcription.</p> <p>If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a list of language codes that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p> <p>You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon Transcribe identify the language faster.</p> <p>You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.</p> <p>Language identification can\'t be combined with custom language models or redaction.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different meetings.</p>', 'CreateMeetingWithAttendeesRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different meetings.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Multiple instances of the same request have been made simultaneously.</p>', 'refs' => [], ], 'ContentFeatures' => [ 'base' => '<p>Lists the content (screen share) features for the meeting. Applies to all attendees.</p> <note> <p>If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.</p> </note>', 'refs' => [ 'MeetingFeaturesConfiguration$Content' => '<p>The configuration settings for the content features available to a meeting.</p>', ], ], 'ContentResolution' => [ 'base' => NULL, 'refs' => [ 'ContentFeatures$MaxResolution' => '<p>The maximum resolution for the meeting content.</p> <note> <p>Defaults to <code>FHD</code>. To use <code>UHD</code>, you must also provide a <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.</p> </note>', ], ], 'CreateAttendeeError' => [ 'base' => '<p>The list of errors returned when errors are encountered during the BatchCreateAttendee and CreateAttendee actions. This includes external user IDs, error codes, and error messages.</p>', 'refs' => [ 'BatchCreateAttendeeErrorList$member' => NULL, ], ], 'CreateAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAttendeeRequestItem' => [ 'base' => '<p>The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.</p>', 'refs' => [ 'CreateAttendeeRequestItemList$member' => NULL, 'CreateMeetingWithAttendeesRequestItemList$member' => NULL, ], ], 'CreateAttendeeRequestItemList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeRequest$Attendees' => '<p>The attendee information, including attendees\' IDs and join tokens.</p>', ], ], 'CreateAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingWithAttendeesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingWithAttendeesRequestItemList' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingWithAttendeesRequest$Attendees' => '<p>The attendee information, including attendees\' IDs and join tokens.</p>', ], ], 'CreateMeetingWithAttendeesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'EngineTranscribeMedicalSettings' => [ 'base' => '<p>Settings specific to the Amazon Transcribe Medical engine.</p>', 'refs' => [ 'TranscriptionConfiguration$EngineTranscribeMedicalSettings' => '<p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>', ], ], 'EngineTranscribeSettings' => [ 'base' => '<p>Settings specific for Amazon Transcribe as the live transcription engine. </p> <p>If you specify an invalid combination of parameters, a <code>TranscriptFailed</code> event will be sent with the contents of the <code>BadRequestException</code> generated by Amazon Transcribe. For more information on each parameter and which combinations are valid, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html">StartStreamTranscription</a> API in the <i>Amazon Transcribe Developer Guide</i>.</p>', 'refs' => [ 'TranscriptionConfiguration$EngineTranscribeSettings' => '<p>The transcription configuration settings passed to Amazon Transcribe.</p>', ], ], 'ExternalMeetingId' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$ExternalMeetingId' => '<p>The external meeting ID.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', 'CreateMeetingWithAttendeesRequest$ExternalMeetingId' => '<p>The external meeting ID.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', 'Meeting$ExternalMeetingId' => '<p>The external meeting ID.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', ], ], 'ExternalUserId' => [ 'base' => NULL, 'refs' => [ 'Attendee$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', 'CreateAttendeeError$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', 'CreateAttendeeRequest$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix.</p>', 'CreateAttendeeRequestItem$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p> <p>Pattern: <code>[-_&amp;@+=,(){}\\[\\]\\/«».:|\'"#a-zA-Z0-9À-ÿ\\s]*</code> </p> <p>Values that begin with <code>aws:</code> are reserved. You can\'t configure a value that uses this prefix. Case insensitive.</p>', 'CreateMeetingRequest$MeetingHostId' => '<p>Reserved.</p>', 'CreateMeetingWithAttendeesRequest$MeetingHostId' => '<p>Reserved.</p>', 'Meeting$MeetingHostId' => '<p>Reserved.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'GetAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMeetingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GuidString' => [ 'base' => NULL, 'refs' => [ 'Attendee$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'AttendeeIdItem$AttendeeId' => '<p>A list of one or more attendee IDs.</p>', 'BatchCreateAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK ID of the meeting to which you\'re adding attendees.</p>', 'BatchUpdateAttendeeCapabilitiesExceptRequest$MeetingId' => '<p>The ID of the meeting associated with the update request.</p>', 'CreateAttendeeRequest$MeetingId' => '<p>The unique ID of the meeting.</p>', 'DeleteAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'DeleteAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'DeleteMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'GetAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'GetAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'GetMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'ListAttendeesRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'Meeting$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'StartMeetingTranscriptionRequest$MeetingId' => '<p>The unique ID of the meeting being transcribed.</p>', 'StopMeetingTranscriptionRequest$MeetingId' => '<p>The unique ID of the meeting for which you stop transcription.</p>', 'UpdateAttendeeCapabilitiesRequest$MeetingId' => '<p>The ID of the meeting associated with the update request.</p>', 'UpdateAttendeeCapabilitiesRequest$AttendeeId' => '<p>The ID of the attendee associated with the update request.</p>', ], ], 'JoinTokenString' => [ 'base' => NULL, 'refs' => [ 'Attendee$JoinToken' => '<p>The join token used by the Amazon Chime SDK attendee.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ListAttendeesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttendeesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MediaCapabilities' => [ 'base' => NULL, 'refs' => [ 'AttendeeCapabilities$Audio' => '<p>The audio capability assigned to an attendee.</p>', 'AttendeeCapabilities$Video' => '<p>The video capability assigned to an attendee.</p>', 'AttendeeCapabilities$Content' => '<p>The content capability assigned to an attendee.</p>', ], ], 'MediaPlacement' => [ 'base' => '<p>A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.</p>', 'refs' => [ 'Meeting$MediaPlacement' => '<p>The media placement for the meeting.</p>', ], ], 'MediaRegion' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$MediaRegion' => '<p>The Region in which to create the meeting.</p> <p> Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>. </p> <p>Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.</p>', 'CreateMeetingWithAttendeesRequest$MediaRegion' => '<p>The Region in which to create the meeting.</p> <p> Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>. </p> <p>Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.</p>', 'Meeting$MediaRegion' => '<p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p> <p>Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>, <code>us-gov-west-1</code>.</p>', ], ], 'Meeting' => [ 'base' => '<p>A meeting created using the Amazon Chime SDK.</p>', 'refs' => [ 'CreateMeetingResponse$Meeting' => '<p>The meeting information, including the meeting ID and <code>MediaPlacement</code>.</p>', 'CreateMeetingWithAttendeesResponse$Meeting' => '<p>The meeting information, including the meeting ID and <code>MediaPlacement</code>.</p>', 'GetMeetingResponse$Meeting' => '<p>The Amazon Chime SDK meeting information.</p>', ], ], 'MeetingFeatureStatus' => [ 'base' => NULL, 'refs' => [ 'AudioFeatures$EchoReduction' => '<p>Makes echo reduction available to clients who connect to the meeting.</p>', ], ], 'MeetingFeaturesConfiguration' => [ 'base' => '<p>The configuration settings of the features available to a meeting.</p>', 'refs' => [ 'CreateMeetingRequest$MeetingFeatures' => '<p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>', 'CreateMeetingWithAttendeesRequest$MeetingFeatures' => '<p>Lists the audio and video features enabled for a meeting, such as echo reduction.</p>', 'Meeting$MeetingFeatures' => '<p>The features available to a meeting, such as echo reduction.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the resources in the request does not exist in the system.</p>', 'refs' => [], ], 'NotificationsConfiguration' => [ 'base' => '<p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>', 'refs' => [ 'CreateMeetingRequest$NotificationsConfiguration' => '<p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>', 'CreateMeetingWithAttendeesRequest$NotificationsConfiguration' => '<p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>', ], ], 'PrimaryMeetingId' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$PrimaryMeetingId' => '<p>When specified, replicates the media from the primary meeting to the new meeting.</p>', 'CreateMeetingWithAttendeesRequest$PrimaryMeetingId' => '<p>When specified, replicates the media from the primary meeting to the new meeting.</p>', 'Meeting$PrimaryMeetingId' => '<p>When specified, replicates the media from the primary meeting to this meeting.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource that you want to tag couldn\'t be found.</p>', 'refs' => [], ], 'ResultMax' => [ 'base' => NULL, 'refs' => [ 'ListAttendeesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ServiceUnavailableException$RetryAfterSeconds' => '<p>The number of seconds the caller should wait before retrying.</p>', ], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'StartMeetingTranscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMeetingTranscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Code' => NULL, 'BadRequestException$Message' => NULL, 'BadRequestException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', 'ConflictException$Code' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$RequestId' => '<p>The ID of the request involved in the conflict.</p>', 'CreateAttendeeError$ErrorCode' => '<p>The error code.</p>', 'CreateAttendeeError$ErrorMessage' => '<p>The error message.</p>', 'EngineTranscribeMedicalSettings$VocabularyName' => '<p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>', 'EngineTranscribeSettings$VocabularyFilterName' => '<p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive. </p> <p>If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.</p> <p>If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>', 'EngineTranscribeSettings$VocabularyName' => '<p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p> <p>If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.</p> <p>If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>', 'ForbiddenException$Code' => NULL, 'ForbiddenException$Message' => NULL, 'ForbiddenException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', 'LimitExceededException$Code' => NULL, 'LimitExceededException$Message' => NULL, 'LimitExceededException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', 'ListAttendeesRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListAttendeesResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'MediaPlacement$AudioHostUrl' => '<p>The audio host URL.</p>', 'MediaPlacement$AudioFallbackUrl' => '<p>The audio fallback URL.</p>', 'MediaPlacement$SignalingUrl' => '<p>The signaling URL.</p>', 'MediaPlacement$TurnControlUrl' => '<p>The turn control URL.</p> <important> <p> <b>This parameter is deprecated and no longer used by the Amazon Chime SDK.</b> </p> </important>', 'MediaPlacement$ScreenDataUrl' => '<p>The screen data URL.</p> <important> <p> <b>This parameter is deprecated and no longer used by the Amazon Chime SDK.</b> </p> </important>', 'MediaPlacement$ScreenViewingUrl' => '<p>The screen viewing URL.</p> <important> <p> <b>This parameter is deprecated and no longer used by the Amazon Chime SDK.</b> </p> </important>', 'MediaPlacement$ScreenSharingUrl' => '<p>The screen sharing URL.</p> <important> <p> <b>This parameter is deprecated and no longer used by the Amazon Chime SDK.</b> </p> </important>', 'MediaPlacement$EventIngestionUrl' => '<p>The event ingestion URL.</p>', 'NotFoundException$Code' => NULL, 'NotFoundException$Message' => NULL, 'NotFoundException$RequestId' => '<p>The request ID associated with the call responsible for the exception.</p>', 'ResourceNotFoundException$Code' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$RequestId' => '<p>The ID of the resource that couldn\'t be found.</p>', 'ServiceFailureException$Code' => NULL, 'ServiceFailureException$Message' => NULL, 'ServiceFailureException$RequestId' => '<p>The ID of the failed request.</p>', 'ServiceUnavailableException$Code' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ServiceUnavailableException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', 'ThrottlingException$Code' => NULL, 'ThrottlingException$Message' => NULL, 'ThrottlingException$RequestId' => '<p>The ID of the request that exceeded the throttling limit.</p>', 'TooManyTagsException$Code' => NULL, 'TooManyTagsException$Message' => NULL, 'TooManyTagsException$RequestId' => '<p>The ID of the request that contains too many tags.</p>', 'UnauthorizedException$Code' => NULL, 'UnauthorizedException$Message' => NULL, 'UnauthorizedException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', 'UnprocessableEntityException$Code' => NULL, 'UnprocessableEntityException$Message' => NULL, 'UnprocessableEntityException$RequestId' => '<p>The request id associated with the call responsible for the exception.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair that you define.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys being removed from the resources.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$Tags' => '<p>Applies one or more tags to an Amazon Chime SDK meeting. Note the following:</p> <ul> <li> <p>Not all resources have tags. For a list of services with resources that support tagging using this operation, see <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">Services that support the Resource Groups Tagging API</a>. If the resource doesn\'t yet support this operation, the resource\'s service might support tagging using its own API operations. For more information, refer to the documentation for that service.</p> </li> <li> <p>Each resource can have up to 50 tags. For other limits, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and Usage Conventions</a> in the <i>AWS General Reference</i>.</p> </li> <li> <p>You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web Services account.</p> </li> <li> <p>To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for adding tags. For more information, see the documentation for each service.</p> </li> </ul> <important> <p>Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.</p> </important> <p> <b>Minimum permissions</b> </p> <p>In addition to the <code>tag:TagResources</code> permission required by this operation, you must also have the tagging permission defined by the service that created the resource. For example, to tag a <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both of the following permissions:</p> <p> <code>tag:TagResources</code> </p> <p> <code>ChimeSDKMeetings:CreateTags</code> </p> <note> <p>Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3 bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum permissions don\'t work, check the documentation for that service\'s tagging APIs for more information.</p> </note>', 'CreateMeetingWithAttendeesRequest$Tags' => '<p>The tags in the request.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags requested for the specified resource.</p>', 'TagResourceRequest$Tags' => '<p>Lists the requested tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'TenantId' => [ 'base' => NULL, 'refs' => [ 'TenantIdList$member' => NULL, ], ], 'TenantIdList' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$TenantIds' => '<p>A consistent and opaque identifier, created and maintained by the builder to represent a segment of their users.</p>', 'CreateMeetingWithAttendeesRequest$TenantIds' => '<p>A consistent and opaque identifier, created and maintained by the builder to represent a segment of their users.</p>', 'Meeting$TenantIds' => '<p>Array of strings.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The number of customer requests exceeds the request rate limit.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>Too many tags were added to the specified resource.</p>', 'refs' => [], ], 'TranscribeContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$ContentIdentificationType' => '<p>Labels all personally identifiable information (PII) identified in your transcript. If you don\'t include <code>PiiEntityTypes</code>, all PII is identified.</p> <note> <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.</p> </note>', ], ], 'TranscribeContentRedactionType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$ContentRedactionType' => '<p>Content redaction is performed at the segment level. If you don\'t include <code>PiiEntityTypes</code>, all PII is redacted.</p> <note> <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code>.</p> </note>', ], ], 'TranscribeLanguageCode' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$LanguageCode' => '<p>Specify the language code that represents the language spoken.</p> <p>If you\'re unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>', 'EngineTranscribeSettings$PreferredLanguage' => '<p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p> <p>You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.</p>', ], ], 'TranscribeLanguageModelName' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$LanguageModelName' => '<p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p> <p>The language of the specified language model must match the language code. If the languages don\'t match, the custom language model isn\'t applied. There are no errors or warnings associated with a language mismatch.</p> <p>If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon Transcribe in each Region.</p>', ], ], 'TranscribeLanguageOptions' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$LanguageOptions' => '<p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you\'re unsure what languages are present, do not include this parameter.</p> <p>Including language options can improve the accuracy of language identification.</p> <p>If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.</p> <important> <p>You can only include one language dialect per language. For example, you cannot include <code>en-US</code> and <code>en-AU</code>.</p> </important>', ], ], 'TranscribeMedicalContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$ContentIdentificationType' => '<p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>', ], ], 'TranscribeMedicalLanguageCode' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$LanguageCode' => '<p>The language code specified for the Amazon Transcribe Medical engine.</p>', ], ], 'TranscribeMedicalRegion' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Region' => '<p>The Amazon Web Services Region passed to Amazon Transcribe Medical. If you don\'t specify a Region, Amazon Chime uses the meeting\'s Region. </p>', ], ], 'TranscribeMedicalSpecialty' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Specialty' => '<p>The specialty specified for the Amazon Transcribe Medical engine.</p>', ], ], 'TranscribeMedicalType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Type' => '<p>The type of transcription.</p>', ], ], 'TranscribePartialResultsStability' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$PartialResultsStability' => '<p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p> <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>', ], ], 'TranscribePiiEntityTypes' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$PiiEntityTypes' => '<p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you\'d like, or you can select <code>ALL</code>.</p> <p>Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code> <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.</p> <p>Note that if you include <code>PiiEntityTypes</code>, you must also include <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p> <p>If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not include PiiEntityTypes, all PII is redacted or identified.</p>', ], ], 'TranscribeRegion' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$Region' => '<p>The Amazon Web Services Region in which to use Amazon Transcribe.</p> <p>If you don\'t specify a Region, then the <a href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html">MediaRegion</a> of the meeting is used. However, if Amazon Transcribe is not available in the <code>MediaRegion</code>, then a <code>TranscriptFailed</code> event is sent.</p> <p>Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', ], ], 'TranscribeVocabularyFilterMethod' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$VocabularyFilterMethod' => '<p>Specify how you want your vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p>', ], ], 'TranscribeVocabularyNamesOrFilterNamesString' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$VocabularyNames' => '<p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p> <p>If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each Region.</p> <p>If you don\'t include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>', 'EngineTranscribeSettings$VocabularyFilterNames' => '<p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p> <p>If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in each Region.</p> <p> If you\'re <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>', ], ], 'TranscriptionConfiguration' => [ 'base' => '<p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>', 'refs' => [ 'StartMeetingTranscriptionRequest$TranscriptionConfiguration' => '<p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The user isn\'t authorized to request a resource.</p>', 'refs' => [], ], 'UnprocessableEntityException' => [ 'base' => '<p>The request was well-formed but was unable to be followed due to semantic errors.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAttendeeCapabilitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAttendeeCapabilitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'VideoFeatures' => [ 'base' => '<p>The video features set for the meeting. Applies to all attendees.</p> <note> <p>If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.</p> </note>', 'refs' => [ 'MeetingFeaturesConfiguration$Video' => '<p>The configuration settings for the video features available to a meeting.</p>', ], ], 'VideoResolution' => [ 'base' => NULL, 'refs' => [ 'VideoFeatures$MaxResolution' => '<p>The maximum video resolution for the meeting. Applies to all attendees.</p> <note> <p>Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.</p> </note>', ], ], ],];
