<?php
// This file was auto-generated from sdk-root/src/data/cleanroomsml/2023-09-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the <i>Amazon Web Services Clean Rooms ML API Reference</i>.</p> <p>Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in their data without the need to share their data with each other. The first party brings the training data to Clean Rooms so that they can create and configure an audience model (lookalike model) and associate it with a collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike segment) that resembles the training data.</p> <p>To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the <a href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html">Clean Rooms User Guide</a>.</p> <p>To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.</p>', 'operations' => [ 'CreateAudienceModel' => '<p>Defines the information necessary to create an audience model. An audience model is a machine learning model that Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.</p>', 'CreateConfiguredAudienceModel' => '<p>Defines the information necessary to create a configured audience model.</p>', 'CreateTrainingDataset' => '<p>Defines the information necessary to create a training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation.</p>', 'DeleteAudienceGenerationJob' => '<p>Deletes the specified audience generation job, and removes all data associated with the job.</p>', 'DeleteAudienceModel' => '<p>Specifies an audience model that you want to delete. You can\'t delete an audience model if there are any configured audience models that depend on the audience model.</p>', 'DeleteConfiguredAudienceModel' => '<p>Deletes the specified configured audience model. You can\'t delete a configured audience model if there are any lookalike models that use the configured audience model. If you delete a configured audience model, it will be removed from any collaborations that it is associated to.</p>', 'DeleteConfiguredAudienceModelPolicy' => '<p>Deletes the specified configured audience model policy.</p>', 'DeleteTrainingDataset' => '<p>Specifies a training dataset that you want to delete. You can\'t delete a training dataset if there are any audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action deletes the metadata.</p>', 'GetAudienceGenerationJob' => '<p>Returns information about an audience generation job.</p>', 'GetAudienceModel' => '<p>Returns information about an audience model</p>', 'GetConfiguredAudienceModel' => '<p>Returns information about a specified configured audience model.</p>', 'GetConfiguredAudienceModelPolicy' => '<p>Returns information about a configured audience model policy.</p>', 'GetTrainingDataset' => '<p>Returns information about a training dataset.</p>', 'ListAudienceExportJobs' => '<p>Returns a list of the audience export jobs.</p>', 'ListAudienceGenerationJobs' => '<p>Returns a list of audience generation jobs.</p>', 'ListAudienceModels' => '<p>Returns a list of audience models.</p>', 'ListConfiguredAudienceModels' => '<p>Returns a list of the configured audience models.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for a provided resource.</p>', 'ListTrainingDatasets' => '<p>Returns a list of training datasets.</p>', 'PutConfiguredAudienceModelPolicy' => '<p>Create or update the resource policy for a configured audience model.</p>', 'StartAudienceExportJob' => '<p>Export an audience of a specified size after you have generated an audience.</p>', 'StartAudienceGenerationJob' => '<p>Information necessary to start the audience generation job.</p>', 'TagResource' => '<p>Adds metadata tags to a specified resource.</p>', 'UntagResource' => '<p>Removes metadata tags from a specified resource.</p>', 'UpdateConfiguredAudienceModel' => '<p>Provides the information necessary to update a configured audience model. Updates that impact audience generation jobs take effect when a new job starts, but do not impact currently running jobs.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AudienceGenerationJobSummary$startedBy' => '<p>The AWS Account that submitted the job.</p>', 'GetAudienceGenerationJobResponse$startedBy' => '<p>The AWS account that started this audience generation job.</p>', 'GlueDataSource$catalogId' => '<p>The Glue catalog that contains the training data.</p>', ], ], 'AnalysisTemplateArn' => [ 'base' => NULL, 'refs' => [ 'ProtectedQuerySQLParameters$analysisTemplateArn' => '<p>The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.</p>', ], ], 'AudienceDestination' => [ 'base' => '<p>Defines the Amazon S3 bucket where the configured audience is stored.</p>', 'refs' => [ 'ConfiguredAudienceModelOutputConfig$destination' => NULL, ], ], 'AudienceExportJobList' => [ 'base' => NULL, 'refs' => [ 'ListAudienceExportJobsResponse$audienceExportJobs' => '<p>The audience export jobs that match the request.</p>', ], ], 'AudienceExportJobStatus' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$status' => '<p>The status of the audience export job.</p>', ], ], 'AudienceExportJobSummary' => [ 'base' => '<p>Provides information about the audience export job.</p>', 'refs' => [ 'AudienceExportJobList$member' => NULL, ], ], 'AudienceGenerationJobArn' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job that was exported.</p>', 'AudienceGenerationJobSummary$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job.</p>', 'DeleteAudienceGenerationJobRequest$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job that you want to delete.</p>', 'GetAudienceGenerationJobRequest$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job that you are interested in.</p>', 'GetAudienceGenerationJobResponse$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job.</p>', 'ListAudienceExportJobsRequest$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job that you are interested in.</p>', 'StartAudienceExportJobRequest$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job that you want to export.</p>', 'StartAudienceGenerationJobResponse$audienceGenerationJobArn' => '<p>The Amazon Resource Name (ARN) of the audience generation job.</p>', ], ], 'AudienceGenerationJobDataSource' => [ 'base' => '<p>Defines the Amazon S3 bucket where the seed audience for the generating audience is stored.</p>', 'refs' => [ 'GetAudienceGenerationJobResponse$seedAudience' => '<p>The seed audience that was used for this audience generation job. This field will be null if the account calling the API is the account that started this audience generation job. </p>', 'StartAudienceGenerationJobRequest$seedAudience' => '<p>The seed audience that is used to generate the audience.</p>', ], ], 'AudienceGenerationJobList' => [ 'base' => NULL, 'refs' => [ 'ListAudienceGenerationJobsResponse$audienceGenerationJobs' => '<p>The audience generation jobs that match the request.</p>', ], ], 'AudienceGenerationJobStatus' => [ 'base' => NULL, 'refs' => [ 'AudienceGenerationJobSummary$status' => '<p>The status of the audience generation job.</p>', 'GetAudienceGenerationJobResponse$status' => '<p>The status of the audience generation job.</p>', ], ], 'AudienceGenerationJobSummary' => [ 'base' => '<p>Provides information about the configured audience generation job.</p>', 'refs' => [ 'AudienceGenerationJobList$member' => NULL, ], ], 'AudienceModelArn' => [ 'base' => NULL, 'refs' => [ 'AudienceModelSummary$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model.</p>', 'ConfiguredAudienceModelSummary$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience model.</p>', 'CreateAudienceModelResponse$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model.</p>', 'CreateConfiguredAudienceModelRequest$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.</p>', 'DeleteAudienceModelRequest$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model that you want to delete.</p>', 'GetAudienceModelRequest$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model that you are interested in.</p>', 'GetAudienceModelResponse$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model.</p>', 'GetConfiguredAudienceModelResponse$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the audience model used for this configured audience model.</p>', 'UpdateConfiguredAudienceModelRequest$audienceModelArn' => '<p>The Amazon Resource Name (ARN) of the new audience model that you want to use.</p>', ], ], 'AudienceModelList' => [ 'base' => NULL, 'refs' => [ 'ListAudienceModelsResponse$audienceModels' => '<p>The audience models that match the request.</p>', ], ], 'AudienceModelStatus' => [ 'base' => NULL, 'refs' => [ 'AudienceModelSummary$status' => '<p>The status of the audience model.</p>', 'GetAudienceModelResponse$status' => '<p>The status of the audience model.</p>', ], ], 'AudienceModelSummary' => [ 'base' => '<p>Information about the audience model.</p>', 'refs' => [ 'AudienceModelList$member' => NULL, ], ], 'AudienceQualityMetrics' => [ 'base' => '<p>Metrics that describe the quality of the generated audience.</p>', 'refs' => [ 'GetAudienceGenerationJobResponse$metrics' => '<p>The relevance scores for different audience sizes and the recall score of the generated audience. </p>', ], ], 'AudienceSize' => [ 'base' => '<p>The size of the generated audience. Must match one of the sizes in the configured audience model.</p>', 'refs' => [ 'AudienceExportJobSummary$audienceSize' => NULL, 'RelevanceMetric$audienceSize' => NULL, 'StartAudienceExportJobRequest$audienceSize' => NULL, ], ], 'AudienceSizeBins' => [ 'base' => NULL, 'refs' => [ 'AudienceSizeConfig$audienceSizeBins' => '<p>An array of the different audience output sizes.</p>', ], ], 'AudienceSizeConfig' => [ 'base' => '<p>Returns the relevance scores at these audience sizes when used in the <a>GetAudienceGenerationJob</a> for a specified audience generation job and configured audience model.</p> <p>Specifies the list of allowed <code>audienceSize</code> values when used in the <a>StartAudienceExportJob</a> for an audience generation job. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.</p>', 'refs' => [ 'CreateConfiguredAudienceModelRequest$audienceSizeConfig' => '<p>Configure the list of output sizes of audiences that can be created using this configured audience model. A request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.</p>', 'GetConfiguredAudienceModelResponse$audienceSizeConfig' => '<p>The list of output sizes of audiences that can be created using this configured audience model. A request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.</p>', 'UpdateConfiguredAudienceModelRequest$audienceSizeConfig' => '<p>The new audience size configuration.</p>', ], ], 'AudienceSizeType' => [ 'base' => NULL, 'refs' => [ 'AudienceSize$type' => '<p>Whether the audience size is defined in absolute terms or as a percentage. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.</p>', 'AudienceSizeConfig$audienceSizeType' => '<p>Whether the audience output sizes are defined as an absolute number or a percentage.</p>', ], ], 'AudienceSizeValue' => [ 'base' => NULL, 'refs' => [ 'AudienceSize$value' => '<p>Specify an audience size value.</p>', 'AudienceSizeBins$member' => NULL, ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'GetAudienceGenerationJobResponse$includeSeedInOutput' => '<p>Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes seed users from the output audience. If you specify <code>TRUE</code>, the seed users will appear first in the output. Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the recipient of the audience will know that the first <code>minimumSeedSize</code> count of users are from the seed.</p>', 'StartAudienceGenerationJobRequest$includeSeedInOutput' => '<p>Whether the seed audience is included in the audience generation output.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'ColumnSchema$columnName' => '<p>The name of a column.</p>', ], ], 'ColumnSchema' => [ 'base' => '<p>Metadata for a column.</p>', 'refs' => [ 'DatasetInputConfigSchemaList$member' => NULL, ], ], 'ColumnType' => [ 'base' => NULL, 'refs' => [ 'ColumnTypeList$member' => NULL, ], ], 'ColumnTypeList' => [ 'base' => NULL, 'refs' => [ 'ColumnSchema$columnTypes' => '<p>The data type of column.</p>', ], ], 'ConfiguredAudienceModelArn' => [ 'base' => NULL, 'refs' => [ 'AudienceGenerationJobSummary$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that was used for this audience generation job.</p>', 'ConfiguredAudienceModelSummary$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that you are interested in.</p>', 'CreateConfiguredAudienceModelResponse$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model.</p>', 'DeleteConfiguredAudienceModelPolicyRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model policy that you want to delete.</p>', 'DeleteConfiguredAudienceModelRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that you want to delete.</p>', 'GetAudienceGenerationJobResponse$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.</p>', 'GetConfiguredAudienceModelPolicyRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that you are interested in.</p>', 'GetConfiguredAudienceModelPolicyResponse$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model.</p>', 'GetConfiguredAudienceModelRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that you are interested in.</p>', 'GetConfiguredAudienceModelResponse$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model.</p>', 'ListAudienceGenerationJobsRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that was used for the audience generation jobs that you are interested in.</p>', 'PutConfiguredAudienceModelPolicyRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that the resource policy will govern.</p>', 'StartAudienceGenerationJobRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that is used for this audience generation job.</p>', 'UpdateConfiguredAudienceModelRequest$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that you want to update.</p>', 'UpdateConfiguredAudienceModelResponse$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that was updated.</p>', ], ], 'ConfiguredAudienceModelList' => [ 'base' => NULL, 'refs' => [ 'ListConfiguredAudienceModelsResponse$configuredAudienceModels' => '<p>The configured audience models.</p>', ], ], 'ConfiguredAudienceModelOutputConfig' => [ 'base' => '<p>Configuration information necessary for the configure audience model output.</p>', 'refs' => [ 'ConfiguredAudienceModelSummary$outputConfig' => '<p>The output configuration of the configured audience model.</p>', 'CreateConfiguredAudienceModelRequest$outputConfig' => '<p>Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model. Each audience will have a unique location. The IAM Role must have <code>s3:PutObject</code> permission on the destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must also have the required KMS permissions.</p>', 'GetConfiguredAudienceModelResponse$outputConfig' => '<p>The output configuration of the configured audience model</p>', 'UpdateConfiguredAudienceModelRequest$outputConfig' => '<p>The new output configuration.</p>', ], ], 'ConfiguredAudienceModelStatus' => [ 'base' => NULL, 'refs' => [ 'ConfiguredAudienceModelSummary$status' => '<p>The status of the configured audience model.</p>', 'GetConfiguredAudienceModelResponse$status' => '<p>The status of the configured audience model.</p>', ], ], 'ConfiguredAudienceModelSummary' => [ 'base' => '<p>Information about the configured audience model.</p>', 'refs' => [ 'ConfiguredAudienceModelList$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>You can\'t complete this action because another resource depends on this resource.</p>', 'refs' => [], ], 'CreateAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAudienceModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredAudienceModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingDatasetRequestTrainingDataList' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingDatasetRequest$trainingData' => '<p>An array of information that lists the Dataset objects, which specifies the dataset type and details on its location and schema. You must provide a role that has read access to these tables.</p>', ], ], 'CreateTrainingDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSource' => [ 'base' => '<p>Defines information about the Glue data source that contains the training data.</p>', 'refs' => [ 'DatasetInputConfig$dataSource' => '<p>A DataSource object that specifies the Glue data source for the training data.</p>', ], ], 'Dataset' => [ 'base' => '<p>Defines where the training dataset is located, what type of data it contains, and how to access the data.</p>', 'refs' => [ 'CreateTrainingDatasetRequestTrainingDataList$member' => NULL, 'DatasetList$member' => NULL, ], ], 'DatasetInputConfig' => [ 'base' => '<p>Defines the Glue data source and schema mapping information.</p>', 'refs' => [ 'Dataset$inputConfig' => '<p>A DatasetInputConfig object that defines the data source and schema mapping.</p>', ], ], 'DatasetInputConfigSchemaList' => [ 'base' => NULL, 'refs' => [ 'DatasetInputConfig$schema' => '<p>The schema information for the training data.</p>', ], ], 'DatasetList' => [ 'base' => NULL, 'refs' => [ 'GetTrainingDatasetResponse$trainingData' => '<p>Metadata about the requested training data. </p>', ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'Dataset$type' => '<p>What type of information is found in the dataset.</p>', ], ], 'DeleteAudienceGenerationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredAudienceModelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrainingDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AudienceQualityMetrics$recallMetric' => '<p>The recall score of the generated audience. Recall is the percentage of the most similar users (by default, the most similar 20%) from a sample of the training data that are included in the seed audience by the audience generation job. Values range from 0-1, larger values indicate a better audience. A recall value approximately equal to the maximum bin size indicates that the audience model is equivalent to random selection. </p>', 'RelevanceMetric$score' => '<p>The relevance score of the generated audience.</p>', ], ], 'GetAudienceGenerationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAudienceGenerationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAudienceModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrainingDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrainingDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlueDataSource' => [ 'base' => '<p>Defines the Glue data source that contains the training data.</p>', 'refs' => [ 'DataSource$glueDataSource' => '<p>A GlueDataSource object that defines the catalog ID, database name, and table name for the training data.</p>', ], ], 'GlueDatabaseName' => [ 'base' => NULL, 'refs' => [ 'GlueDataSource$databaseName' => '<p>The Glue database that contains the training data.</p>', ], ], 'GlueTableName' => [ 'base' => NULL, 'refs' => [ 'GlueDataSource$tableName' => '<p>The Glue table that contains the training data.</p>', ], ], 'Hash' => [ 'base' => NULL, 'refs' => [ 'GetConfiguredAudienceModelPolicyResponse$policyHash' => '<p>A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the policy.</p>', 'PutConfiguredAudienceModelPolicyRequest$previousPolicyHash' => '<p>A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the policy.</p>', 'PutConfiguredAudienceModelPolicyResponse$policyHash' => '<p>A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the policy.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'AudienceGenerationJobDataSource$roleArn' => '<p>The ARN of the IAM role that can read the Amazon S3 bucket where the seed audience is stored.</p>', 'ConfiguredAudienceModelOutputConfig$roleArn' => '<p>The ARN of the IAM role that can write the Amazon S3 bucket.</p>', 'CreateTrainingDatasetRequest$roleArn' => '<p>The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the <code>dataSource</code> field of each dataset.</p> <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn\'t in your account, you get an <code>AccessDeniedException</code> error.</p>', 'GetTrainingDatasetResponse$roleArn' => '<p>The IAM role used to read the training data.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateAudienceModelRequest$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the trained ML model and the associated data.</p>', 'GetAudienceModelResponse$kmsKeyArn' => '<p>The KMS key ARN used for the audience model.</p>', ], ], 'ListAudienceExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAudienceExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAudienceGenerationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAudienceGenerationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAudienceModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAudienceModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredAudienceModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredAudienceModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAudienceExportJobsRequest$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListAudienceGenerationJobsRequest$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListAudienceModelsRequest$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListConfiguredAudienceModelsRequest$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListTrainingDatasetsRequest$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', ], ], 'MetricsList' => [ 'base' => NULL, 'refs' => [ 'CreateConfiguredAudienceModelRequest$sharedAudienceMetrics' => '<p>Whether audience metrics are shared.</p>', 'GetConfiguredAudienceModelResponse$sharedAudienceMetrics' => '<p>Whether audience metrics are shared.</p>', 'UpdateConfiguredAudienceModelRequest$sharedAudienceMetrics' => '<p>The new value for whether to share audience metrics.</p>', ], ], 'MinMatchingSeedSize' => [ 'base' => NULL, 'refs' => [ 'CreateConfiguredAudienceModelRequest$minMatchingSeedSize' => '<p>The minimum number of users from the seed audience that must match with users in the training data of the audience model. The default value is 500.</p>', 'GetConfiguredAudienceModelResponse$minMatchingSeedSize' => '<p>The minimum number of users from the seed audience that must match with users in the training data of the audience model.</p>', 'UpdateConfiguredAudienceModelRequest$minMatchingSeedSize' => '<p>The minimum number of users from the seed audience that must match with users in the training data of the audience model.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$name' => '<p>The name of the audience export job.</p>', 'AudienceGenerationJobSummary$name' => '<p>The name of the audience generation job.</p>', 'AudienceModelSummary$name' => '<p>The name of the audience model.</p>', 'ConfiguredAudienceModelSummary$name' => '<p>The name of the configured audience model.</p>', 'CreateAudienceModelRequest$name' => '<p>The name of the audience model resource.</p>', 'CreateConfiguredAudienceModelRequest$name' => '<p>The name of the configured audience model.</p>', 'CreateTrainingDatasetRequest$name' => '<p>The name of the training dataset. This name must be unique in your account and region.</p>', 'GetAudienceGenerationJobResponse$name' => '<p>The name of the audience generation job.</p>', 'GetAudienceModelResponse$name' => '<p>The name of the audience model.</p>', 'GetConfiguredAudienceModelResponse$name' => '<p>The name of the configured audience model.</p>', 'GetTrainingDatasetResponse$name' => '<p>The name of the training dataset.</p>', 'StartAudienceExportJobRequest$name' => '<p>The name of the audience export job.</p>', 'StartAudienceGenerationJobRequest$name' => '<p>The name of the audience generation job.</p>', 'TrainingDatasetSummary$name' => '<p>The name of the training dataset.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAudienceExportJobsRequest$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAudienceExportJobsResponse$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAudienceGenerationJobsRequest$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAudienceGenerationJobsResponse$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAudienceModelsRequest$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAudienceModelsResponse$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredAudienceModelsRequest$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredAudienceModelsResponse$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListTrainingDatasetsRequest$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListTrainingDatasetsResponse$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'ParameterMap$key' => NULL, ], ], 'ParameterMap' => [ 'base' => NULL, 'refs' => [ 'ProtectedQuerySQLParameters$parameters' => '<p>The protected query SQL parameters.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterMap$value' => NULL, ], ], 'PolicyExistenceCondition' => [ 'base' => NULL, 'refs' => [ 'PutConfiguredAudienceModelPolicyRequest$policyExistenceCondition' => '<p>Use this to prevent unexpected concurrent modification of the policy.</p>', ], ], 'ProtectedQuerySQLParameters' => [ 'base' => '<p>The parameters for the SQL type Protected Query.</p>', 'refs' => [ 'AudienceGenerationJobDataSource$sqlParameters' => '<p>The protected SQL query parameters.</p>', ], ], 'ProtectedQuerySQLParametersQueryStringString' => [ 'base' => NULL, 'refs' => [ 'ProtectedQuerySQLParameters$queryString' => '<p>The query string to be submitted.</p>', ], ], 'PutConfiguredAudienceModelPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutConfiguredAudienceModelPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RelevanceMetric' => [ 'base' => '<p>The relevance score of a generated audience.</p>', 'refs' => [ 'RelevanceMetrics$member' => NULL, ], ], 'RelevanceMetrics' => [ 'base' => NULL, 'refs' => [ 'AudienceQualityMetrics$relevanceMetrics' => '<p>The relevance scores of the generated audience.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$description' => '<p>The description of the audience export job.</p>', 'AudienceGenerationJobSummary$description' => '<p>The description of the audience generation job.</p>', 'AudienceModelSummary$description' => '<p>The description of the audience model.</p>', 'ConfiguredAudienceModelSummary$description' => '<p>The description of the configured audience model.</p>', 'CreateAudienceModelRequest$description' => '<p>The description of the audience model.</p>', 'CreateConfiguredAudienceModelRequest$description' => '<p>The description of the configured audience model.</p>', 'CreateTrainingDatasetRequest$description' => '<p>The description of the training dataset.</p>', 'GetAudienceGenerationJobResponse$description' => '<p>The description of the audience generation job.</p>', 'GetAudienceModelResponse$description' => '<p>The description of the audience model.</p>', 'GetConfiguredAudienceModelResponse$description' => '<p>The description of the configured audience model.</p>', 'GetTrainingDatasetResponse$description' => '<p>The description of the training dataset.</p>', 'StartAudienceExportJobRequest$description' => '<p>The description of the audience export job.</p>', 'StartAudienceGenerationJobRequest$description' => '<p>The description of the audience generation job.</p>', 'TrainingDatasetSummary$description' => '<p>The description of the training dataset.</p>', 'UpdateConfiguredAudienceModelRequest$description' => '<p>The new description of the configured audience model.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource you are requesting does not exist.</p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => NULL, 'refs' => [ 'GetConfiguredAudienceModelPolicyResponse$configuredAudienceModelPolicy' => '<p>The configured audience model policy. This is a JSON IAM resource policy.</p>', 'PutConfiguredAudienceModelPolicyRequest$configuredAudienceModelPolicy' => '<p>The IAM resource policy.</p>', 'PutConfiguredAudienceModelPolicyResponse$configuredAudienceModelPolicy' => '<p>The IAM resource policy.</p>', ], ], 'S3ConfigMap' => [ 'base' => '<p>Provides information about an Amazon S3 bucket and path.</p>', 'refs' => [ 'AudienceDestination$s3Destination' => '<p>The Amazon S3 bucket and path for the configured audience.</p>', 'AudienceGenerationJobDataSource$dataSource' => '<p>Defines the Amazon S3 bucket where the seed audience for the generating audience is stored. A valid data source is a JSON line file in the following format:</p> <p> <code>{"user_id": "111111"}</code> </p> <p> <code>{"user_id": "222222"}</code> </p> <p> <code>...</code> </p>', ], ], 'S3Path' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$outputLocation' => '<p>The Amazon S3 bucket where the audience export is stored.</p>', 'S3ConfigMap$s3Uri' => '<p>The Amazon S3 location URI.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota.</p>', 'refs' => [], ], 'SharedAudienceMetrics' => [ 'base' => NULL, 'refs' => [ 'MetricsList$member' => NULL, ], ], 'StartAudienceExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAudienceGenerationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAudienceGenerationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusDetails' => [ 'base' => '<p>Details about the status of a resource.</p>', 'refs' => [ 'AudienceExportJobSummary$statusDetails' => NULL, 'GetAudienceGenerationJobResponse$statusDetails' => '<p>Details about the status of the audience generation job.</p>', 'GetAudienceModelResponse$statusDetails' => '<p>Details about the status of the audience model.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'GetAudienceGenerationJobResponse$protectedQueryIdentifier' => '<p>The unique identifier of the protected query for this audience generation job.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'StatusDetails$statusCode' => '<p>The status code that was returned. The status code is intended for programmatic error handling. Clean Rooms ML will not change the status code for existing error conditions.</p>', 'StatusDetails$message' => '<p>The error message that was returned. The message is intended for human consumption and can change at any time. Use the <code>statusCode</code> for programmatic error handling.</p>', 'ValidationException$message' => NULL, ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'AudienceExportJobSummary$createTime' => '<p>The time at which the audience export job was created.</p>', 'AudienceExportJobSummary$updateTime' => '<p>The most recent time at which the audience export job was updated.</p>', 'AudienceGenerationJobSummary$createTime' => '<p>The time at which the audience generation job was created.</p>', 'AudienceGenerationJobSummary$updateTime' => '<p>The most recent time at which the audience generation job was updated.</p>', 'AudienceModelSummary$createTime' => '<p>The time at which the audience model was created.</p>', 'AudienceModelSummary$updateTime' => '<p>The most recent time at which the audience model was updated.</p>', 'ConfiguredAudienceModelSummary$createTime' => '<p>The time at which the configured audience model was created.</p>', 'ConfiguredAudienceModelSummary$updateTime' => '<p>The most recent time at which the configured audience model was updated.</p>', 'CreateAudienceModelRequest$trainingDataStartTime' => '<p>The start date and time of the training window.</p>', 'CreateAudienceModelRequest$trainingDataEndTime' => '<p>The end date and time of the training window.</p>', 'GetAudienceGenerationJobResponse$createTime' => '<p>The time at which the audience generation job was created.</p>', 'GetAudienceGenerationJobResponse$updateTime' => '<p>The most recent time at which the audience generation job was updated.</p>', 'GetAudienceModelResponse$createTime' => '<p>The time at which the audience model was created.</p>', 'GetAudienceModelResponse$updateTime' => '<p>The most recent time at which the audience model was updated.</p>', 'GetAudienceModelResponse$trainingDataStartTime' => '<p>The start date specified for the training window.</p>', 'GetAudienceModelResponse$trainingDataEndTime' => '<p>The end date specified for the training window.</p>', 'GetConfiguredAudienceModelResponse$createTime' => '<p>The time at which the configured audience model was created.</p>', 'GetConfiguredAudienceModelResponse$updateTime' => '<p>The most recent time at which the configured audience model was updated.</p>', 'GetTrainingDatasetResponse$createTime' => '<p>The time at which the training dataset was created.</p>', 'GetTrainingDatasetResponse$updateTime' => '<p>The most recent time at which the training dataset was updated.</p>', 'TrainingDatasetSummary$createTime' => '<p>The time at which the training dataset was created.</p>', 'TrainingDatasetSummary$updateTime' => '<p>The most recent time at which the training dataset was updated.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The key values of tags that you want to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAudienceModelRequest$tags' => '<p>The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.</p> </li> </ul>', 'CreateConfiguredAudienceModelRequest$tags' => '<p>The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.</p> </li> </ul>', 'CreateTrainingDatasetRequest$tags' => '<p>The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.</p> </li> </ul>', 'GetAudienceGenerationJobResponse$tags' => '<p>The tags that are associated to this audience generation job.</p>', 'GetAudienceModelResponse$tags' => '<p>The tags that are assigned to the audience model.</p>', 'GetConfiguredAudienceModelResponse$tags' => '<p>The tags that are associated to this configured audience model.</p>', 'GetTrainingDatasetResponse$tags' => '<p>The tags that are assigned to this training dataset.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags that are associated with the resource.</p>', 'StartAudienceGenerationJobRequest$tags' => '<p>The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.</p> </li> </ul>', 'TagResourceRequest$tags' => '<p>The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.</p> </li> </ul>', ], ], 'TagOnCreatePolicy' => [ 'base' => NULL, 'refs' => [ 'CreateConfiguredAudienceModelRequest$childResourceTagOnCreatePolicy' => '<p>Configure how the service tags audience generation jobs created using this configured audience model. If you specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the tags of the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience generation job inherits the tags from the configured audience model, by default. Tags in the <a>StartAudienceGenerationJob</a> will override the default.</p> <p>When the client is in a different account than the configured audience model, the tags from the client are never applied to a resource in the caller\'s account.</p>', 'GetConfiguredAudienceModelResponse$childResourceTagOnCreatePolicy' => '<p>Provides the <code>childResourceTagOnCreatePolicy</code> that was used for this configured audience model.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TaggableArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you are interested in.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to assign tags.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>', ], ], 'TrainingDatasetArn' => [ 'base' => NULL, 'refs' => [ 'AudienceModelSummary$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset that was used for the audience model.</p>', 'CreateAudienceModelRequest$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset for this audience model.</p>', 'CreateTrainingDatasetResponse$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset resource.</p>', 'DeleteTrainingDatasetRequest$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset that you want to delete.</p>', 'GetAudienceModelResponse$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.</p>', 'GetTrainingDatasetRequest$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset that you are interested in.</p>', 'GetTrainingDatasetResponse$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset.</p>', 'TrainingDatasetSummary$trainingDatasetArn' => '<p>The Amazon Resource Name (ARN) of the training dataset.</p>', ], ], 'TrainingDatasetList' => [ 'base' => NULL, 'refs' => [ 'ListTrainingDatasetsResponse$trainingDatasets' => '<p>The training datasets that match the request.</p>', ], ], 'TrainingDatasetStatus' => [ 'base' => NULL, 'refs' => [ 'GetTrainingDatasetResponse$status' => '<p>The status of the training dataset.</p>', 'TrainingDatasetSummary$status' => '<p>The status of the training dataset.</p>', ], ], 'TrainingDatasetSummary' => [ 'base' => '<p>Provides information about the training dataset.</p>', 'refs' => [ 'TrainingDatasetList$member' => NULL, ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'AudienceGenerationJobSummary$collaborationId' => '<p>The identifier of the collaboration that contains this audience generation job.</p>', 'GetAudienceGenerationJobResponse$collaborationId' => '<p>The identifier of the collaboration that this audience generation job is associated with.</p>', 'ListAudienceGenerationJobsRequest$collaborationId' => '<p>The identifier of the collaboration that contains the audience generation jobs that you are interested in.</p>', 'StartAudienceGenerationJobRequest$collaborationId' => '<p>The identifier of the collaboration that contains the audience generation job.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredAudienceModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredAudienceModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request parameters for this request are incorrect.</p>', 'refs' => [], ], ],];
