<?php
// This file was auto-generated from sdk-root/src/data/cloudtrail/2013-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>CloudTrail</fullname> <p>This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common errors for CloudTrail.</p> <p>CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements returned by the service.</p> <note> <p>As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools to Build on Amazon Web Services</a>.</p> </note> <p>See the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html">CloudTrail User Guide</a> for information about the data that is included with each Amazon Web Services API call listed in the log files.</p>', 'operations' => [ 'AddTags' => '<p>Adds one or more tags to a trail, event data store, or channel, up to a limit of 50. Overwrites an existing tag\'s value when a new value is specified for an existing tag key. Tag key names must be unique; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home Region).</p>', 'CancelQuery' => '<p>Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>. The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query status might show as <code>CANCELLED</code> even if the operation is not yet finished.</p>', 'CreateChannel' => '<p>Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel, a CloudTrail Lake event data store can log events from the partner or source that you specify.</p>', 'CreateEventDataStore' => '<p>Creates a new event data store.</p>', 'CreateTrail' => '<p>Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. </p>', 'DeleteChannel' => '<p>Deletes a channel.</p>', 'DeleteEventDataStore' => '<p>Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN. After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code> state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code> must be set to <code>False</code> on the event data store and the <code>FederationStatus</code> must be <code>DISABLED</code>. You cannot delete an event data store if <code>TerminationProtectionEnabled</code> is <code>True</code> or the <code>FederationStatus</code> is <code>ENABLED</code>.</p> <p>After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>, <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not incur costs.</p>', 'DeleteResourcePolicy' => '<p> Deletes the resource-based policy attached to the CloudTrail channel. </p>', 'DeleteTrail' => '<p>Deletes a trail. This operation must be called from the Region in which the trail was created. <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.</p>', 'DeregisterOrganizationDelegatedAdmin' => '<p>Removes CloudTrail delegated administrator permissions from a member account in an organization.</p>', 'DescribeQuery' => '<p>Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and the delivery status.</p> <p>You must specify either a <code>QueryID</code> or a <code>QueryAlias</code>. Specifying the <code>QueryAlias</code> parameter returns information about the last query run for the alias.</p>', 'DescribeTrails' => '<p>Retrieves settings for one or more trails associated with the current Region for your account.</p>', 'DisableFederation' => '<p> Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you can no longer query your event data in Amazon Athena.</p> <p>No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail Lake.</p>', 'EnableFederation' => '<p> Enables Lake query federation on the specified event data store. Federating an event data store lets you view the metadata associated with the event data store in the Glue <a href="https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro">Data Catalog</a> and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.</p> <p>When you enable Lake query federation, CloudTrail creates a managed database named <code>aws:cloudtrail</code> (if the database doesn\'t already exist) and a managed federated table in the Glue Data Catalog. The event data store ID is used for the table name. CloudTrail registers the role ARN and event data store in <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html">Lake Formation</a>, the service responsible for allowing fine-grained access control of the federated resources in the Glue Data Catalog.</p> <p>For more information about Lake query federation, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Federate an event data store</a>.</p>', 'GetChannel' => '<p> Returns information about a specific channel. </p>', 'GetEventDataStore' => '<p>Returns information about an event data store specified as either an ARN or the ID portion of the ARN.</p>', 'GetEventSelectors' => '<p>Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:</p> <ul> <li> <p>If your event selector includes read-only events, write-only events, or all events. This applies to both management events and data events.</p> </li> <li> <p>If your event selector includes management events.</p> </li> <li> <p>If your event selector includes data events, the resources on which you are logging data events.</p> </li> </ul> <p>For more information about logging management and data events, see the following topics in the <i>CloudTrail User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Logging management events</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> </p> </li> </ul>', 'GetImport' => '<p> Returns information about a specific import. </p>', 'GetInsightSelectors' => '<p>Describes the settings for the Insights event selectors that you configured for your trail or event data store. <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail or event data store, and if it is, which Insights types are enabled. If you run <code>GetInsightSelectors</code> on a trail or event data store that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code> </p> <p>Specify either the <code>EventDataStore</code> parameter to get Insights event selectors for an event data store, or the <code>TrailName</code> parameter to the get Insights event selectors for a trail. You cannot specify these parameters together.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html">Logging CloudTrail Insights events</a> in the <i>CloudTrail User Guide</i>.</p>', 'GetQueryResults' => '<p>Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the <code>StartQuery</code> operation.</p>', 'GetResourcePolicy' => '<p> Retrieves the JSON text of the resource-based policy document attached to the CloudTrail channel. </p>', 'GetTrail' => '<p>Returns settings information for a specified trail.</p>', 'GetTrailStatus' => '<p>Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single Region. To return trail status from all Regions, you must call the operation on each Region.</p>', 'ListChannels' => '<p> Lists the channels in the current account, and their source names. </p>', 'ListEventDataStores' => '<p>Returns information about all event data stores in the account, in the current Region.</p>', 'ListImportFailures' => '<p> Returns a list of failures for the specified import. </p>', 'ListImports' => '<p> Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or <code>Destination</code>. </p>', 'ListInsightsMetricData' => '<p>Returns Insights metrics data for trails that have enabled Insights. The request must include the <code>EventSource</code>, <code>EventName</code>, and <code>InsightType</code> parameters.</p> <p>If the <code>InsightType</code> is set to <code>ApiErrorRateInsight</code>, the request must also include the <code>ErrorCode</code> parameter.</p> <p>The following are the available time periods for <code>ListInsightsMetricData</code>. Each cutoff is inclusive.</p> <ul> <li> <p>Data points with a period of 60 seconds (1-minute) are available for 15 days.</p> </li> <li> <p>Data points with a period of 300 seconds (5-minute) are available for 63 days.</p> </li> <li> <p>Data points with a period of 3600 seconds (1 hour) are available for 90 days.</p> </li> </ul> <p>Access to the <code>ListInsightsMetricData</code> API operation is linked to the <code>cloudtrail:LookupEvents</code> action. To use this operation, you must have permissions to perform the <code>cloudtrail:LookupEvents</code> action.</p>', 'ListPublicKeys' => '<p>Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.</p> <note> <p>CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region for its corresponding public key.</p> </note>', 'ListQueries' => '<p>Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>', 'ListTags' => '<p>Lists the tags for the specified trails, event data stores, or channels in the current Region.</p>', 'ListTrails' => '<p>Lists trails that are in the current account.</p>', 'LookupEvents' => '<p>Looks up <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events">management events</a> or <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events">CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a Region within the last 90 days.</p> <note> <p> <code>LookupEvents</code> returns recent Insights events for trails that enable Insights. To view Insights events for an event data store, you can run queries on your Insights event data store, and you can also view the Lake dashboard for Insights.</p> </note> <p>Lookup supports the following attributes for management events:</p> <ul> <li> <p>Amazon Web Services access key</p> </li> <li> <p>Event ID</p> </li> <li> <p>Event name</p> </li> <li> <p>Event source</p> </li> <li> <p>Read only</p> </li> <li> <p>Resource name</p> </li> <li> <p>Resource type</p> </li> <li> <p>User name</p> </li> </ul> <p>Lookup supports the following attributes for Insights events:</p> <ul> <li> <p>Event ID</p> </li> <li> <p>Event name</p> </li> <li> <p>Event source</p> </li> </ul> <p>All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.</p> <important> <p>The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a throttling error occurs.</p> </important>', 'PutEventSelectors' => '<p>Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. If you want your trail to log Insights events, be sure the event selector enables logging of the Insights event types you want configured for your trail. For more information about logging Insights events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html">Logging Insights events</a> in the <i>CloudTrail User Guide</i>. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.</p> <p>When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn\'t match any event selector, the trail doesn\'t log the event.</p> <p>Example</p> <ol> <li> <p>You create an event selector for a trail and specify that you want write-only events.</p> </li> <li> <p>The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.</p> </li> <li> <p>CloudTrail evaluates whether the events match your event selectors.</p> </li> <li> <p>The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.</p> </li> <li> <p>The <code>GetConsoleOutput</code> is a read-only event that doesn\'t match your event selector. The trail doesn\'t log the event. </p> </li> </ol> <p>The <code>PutEventSelectors</code> operation must be called from the Region in which the trail was created; otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.</p> <p>You can configure up to five event selectors for each trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Logging management events</a>, <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a>, and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p> <p>You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> in the <i>CloudTrail User Guide</i>.</p>', 'PutInsightSelectors' => '<p>Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail or event data store. You also use <code>PutInsightSelectors</code> to turn off Insights event logging, by passing an empty list of Insights types. The valid Insights event types are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p> <p>To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source event data store (<code>EventDataStore</code>) and the destination event data store (<code>InsightsDestination</code>). The source event data store logs management events and enables Insights. The destination event data store logs Insights events based upon the management event activity of the source event data store. The source and destination event data stores must belong to the same Amazon Web Services account.</p> <p>To log Insights events for a trail, you must specify the name (<code>TrailName</code>) of the CloudTrail trail for which you want to change or add Insights selectors.</p> <p>To log CloudTrail Insights events on API call volume, the trail or event data store must log <code>write</code> management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log <code>read</code> or <code>write</code> management events. You can call <code>GetEventSelectors</code> on a trail to check whether the trail logs management events. You can call <code>GetEventDataStore</code> on an event data store to check whether the event data store logs management events.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html">Logging CloudTrail Insights events</a> in the <i>CloudTrail User Guide</i>.</p>', 'PutResourcePolicy' => '<p> Attaches a resource-based permission policy to a CloudTrail channel that is used for an integration with an event source outside of Amazon Web Services. For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html">CloudTrail resource-based policy examples</a> in the <i>CloudTrail User Guide</i>. </p>', 'RegisterOrganizationDelegatedAdmin' => '<p>Registers an organization’s member account as the CloudTrail <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html">delegated administrator</a>.</p>', 'RemoveTags' => '<p>Removes the specified tags from a trail, event data store, or channel.</p>', 'RestoreEventDataStore' => '<p>Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.</p>', 'StartEventDataStoreIngestion' => '<p>Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To start ingestion, the event data store <code>Status</code> must be <code>STOPPED_INGESTION</code> and the <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, or <code>ConfigurationItem</code>.</p>', 'StartImport' => '<p> Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default, CloudTrail only imports events contained in the S3 bucket\'s <code>CloudTrail</code> prefix and the prefixes inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If you want to import CloudTrail events contained in another prefix, you must include the prefix in the <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations">Considerations for copying trail events</a> in the <i>CloudTrail User Guide</i>. </p> <p> When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required. Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more information about disabling ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of objects and disabling ACLs for your bucket</a>. </p> <p> When you retry an import, the <code>ImportID</code> parameter is required. </p> <note> <p> If the destination event data store is for an organization, you must use the management account to import trail events. You cannot use the delegated administrator account for the organization. </p> </note>', 'StartLogging' => '<p>Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all Regions, this operation must be called from the Region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.</p>', 'StartQuery' => '<p>Starts a CloudTrail Lake query. Use the <code>QueryStatement</code> parameter to provide your SQL query, enclosed in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query results to an S3 bucket.</p> <p> <code>StartQuery</code> requires you specify either the <code>QueryStatement</code> parameter, or a <code>QueryAlias</code> and any <code>QueryParameters</code>. In the current release, the <code>QueryAlias</code> and <code>QueryParameters</code> parameters are used only for the queries that populate the CloudTrail Lake dashboards.</p>', 'StopEventDataStoreIngestion' => '<p>Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To stop ingestion, the event data store <code>Status</code> must be <code>ENABLED</code> and the <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, or <code>ConfigurationItem</code>.</p>', 'StopImport' => '<p> Stops a specified import. </p>', 'StopLogging' => '<p>Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the Region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.</p>', 'UpdateChannel' => '<p>Updates a channel specified by a required channel ARN or UUID.</p>', 'UpdateEventDataStore' => '<p>Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 7 and 3653 if the <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, or between 7 and 2557 if <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>. By default, <code>TerminationProtection</code> is enabled.</p> <p>For event data stores for CloudTrail events, <code>AdvancedEventSelectors</code> includes or excludes management or data events in your event data store. For more information about <code>AdvancedEventSelectors</code>, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelectors</a>.</p> <p> For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or non-Amazon Web Services events, <code>AdvancedEventSelectors</code> includes events of that type in your event data store.</p>', 'UpdateTrail' => '<p>Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. <code>UpdateTrail</code> must be called from the Region in which the trail was created; otherwise, an <code>InvalidHomeRegionException</code> is thrown.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> You do not have sufficient access to perform this action. </p>', 'refs' => [], ], 'AccountHasOngoingImportException' => [ 'base' => '<p> This exception is thrown when you start a new import and a previous import is still in progress. </p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'DeregisterOrganizationDelegatedAdminRequest$DelegatedAdminAccountId' => '<p>A delegated administrator account ID. This is a member account in an organization that is currently designated as a delegated administrator.</p>', 'RegisterOrganizationDelegatedAdminRequest$MemberAccountId' => '<p>An organization member account ID that you want to designate as a delegated administrator.</p>', ], ], 'AccountNotFoundException' => [ 'base' => '<p>This exception is thrown when the specified account is not found or not part of an organization.</p>', 'refs' => [], ], 'AccountNotRegisteredException' => [ 'base' => '<p>This exception is thrown when the specified account is not registered as the CloudTrail delegated administrator.</p>', 'refs' => [], ], 'AccountRegisteredException' => [ 'base' => '<p>This exception is thrown when the account is already registered as the CloudTrail delegated administrator.</p>', 'refs' => [], ], 'AddTagsRequest' => [ 'base' => '<p>Specifies the tags to add to a trail, event data store, or channel.</p>', 'refs' => [], ], 'AddTagsResponse' => [ 'base' => '<p>Returns the objects or data if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'AdvancedEventSelector' => [ 'base' => '<p>Advanced event selectors let you create fine-grained selectors for CloudTrail management and data events. They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Logging management events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> in the <i>CloudTrail User Guide</i>.</p> <p>You cannot apply both event selectors and advanced event selectors to a trail.</p> <p> <b>Supported CloudTrail event record fields for management events</b> </p> <ul> <li> <p> <code>eventCategory</code> (required)</p> </li> <li> <p> <code>eventSource</code> </p> </li> <li> <p> <code>readOnly</code> </p> </li> </ul> <p> <b>Supported CloudTrail event record fields for data events</b> </p> <ul> <li> <p> <code>eventCategory</code> (required)</p> </li> <li> <p> <code>resources.type</code> (required)</p> </li> <li> <p> <code>readOnly</code> </p> </li> <li> <p> <code>eventName</code> </p> </li> <li> <p> <code>resources.ARN</code> </p> </li> </ul> <note> <p>For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the only supported field is <code>eventCategory</code>. </p> </note>', 'refs' => [ 'AdvancedEventSelectors$member' => NULL, ], ], 'AdvancedEventSelectors' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$AdvancedEventSelectors' => '<p>The advanced event selectors to use to select the events for the data store. You can configure up to five advanced event selectors for each event data store.</p> <p> For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.</p> <p>For more information about how to use advanced event selectors to include Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for Config configuration items</a> in the CloudTrail User Guide.</p> <p>For more information about how to use advanced event selectors to include events outside of Amazon Web Services events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.</p>', 'CreateEventDataStoreResponse$AdvancedEventSelectors' => '<p>The advanced event selectors that were used to select the events for the data store.</p>', 'EventDataStore$AdvancedEventSelectors' => '<p>The advanced event selectors that were used to select events for the data store.</p>', 'GetEventDataStoreResponse$AdvancedEventSelectors' => '<p>The advanced event selectors used to select events for the data store.</p>', 'GetEventSelectorsResponse$AdvancedEventSelectors' => '<p> The advanced event selectors that are configured for the trail. </p>', 'PutEventSelectorsRequest$AdvancedEventSelectors' => '<p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> in the <i>CloudTrail User Guide</i>. </p>', 'PutEventSelectorsResponse$AdvancedEventSelectors' => '<p>Specifies the advanced event selectors configured for your trail.</p>', 'RestoreEventDataStoreResponse$AdvancedEventSelectors' => '<p>The advanced event selectors that were used to select events.</p>', 'SourceConfig$AdvancedEventSelectors' => '<p> The advanced event selectors that are configured for the channel.</p>', 'UpdateEventDataStoreRequest$AdvancedEventSelectors' => '<p>The advanced event selectors used to select events for the event data store. You can configure up to five advanced event selectors for each event data store.</p>', 'UpdateEventDataStoreResponse$AdvancedEventSelectors' => '<p>The advanced event selectors that are applied to the event data store.</p>', ], ], 'AdvancedFieldSelector' => [ 'base' => '<p>A single selector statement in an advanced event selector.</p>', 'refs' => [ 'AdvancedFieldSelectors$member' => NULL, ], ], 'AdvancedFieldSelectors' => [ 'base' => NULL, 'refs' => [ 'AdvancedEventSelector$FieldSelectors' => '<p>Contains all selector statements in an advanced event selector.</p>', ], ], 'BillingMode' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$BillingMode' => '<p>The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.</p> <p>The following are the possible values:</p> <ul> <li> <p> <code>EXTENDABLE_RETENTION_PRICING</code> - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.</p> </li> <li> <p> <code>FIXED_RETENTION_PRICING</code> - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.</p> </li> </ul> <p>The default value is <code>EXTENDABLE_RETENTION_PRICING</code>.</p> <p>For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html">Managing CloudTrail Lake costs</a>.</p>', 'CreateEventDataStoreResponse$BillingMode' => '<p>The billing mode for the event data store.</p>', 'GetEventDataStoreResponse$BillingMode' => '<p>The billing mode for the event data store.</p>', 'RestoreEventDataStoreResponse$BillingMode' => '<p>The billing mode for the event data store.</p>', 'UpdateEventDataStoreRequest$BillingMode' => '<note> <p>You can\'t change the billing mode from <code>EXTENDABLE_RETENTION_PRICING</code> to <code>FIXED_RETENTION_PRICING</code>. If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code> and you want to use <code>FIXED_RETENTION_PRICING</code> instead, you\'ll need to stop ingestion on the event data store and create a new event data store that uses <code>FIXED_RETENTION_PRICING</code>.</p> </note> <p>The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.</p> <p>The following are the possible values:</p> <ul> <li> <p> <code>EXTENDABLE_RETENTION_PRICING</code> - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.</p> </li> <li> <p> <code>FIXED_RETENTION_PRICING</code> - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.</p> </li> </ul> <p>For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html">Managing CloudTrail Lake costs</a>.</p>', 'UpdateEventDataStoreResponse$BillingMode' => '<p>The billing mode for the event data store.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$MultiRegionEnabled' => '<p>Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.</p>', 'CreateEventDataStoreRequest$OrganizationEnabled' => '<p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>', 'CreateEventDataStoreRequest$StartIngestion' => '<p>Specifies whether the event data store should start ingesting live events. The default is true.</p>', 'CreateEventDataStoreResponse$MultiRegionEnabled' => '<p>Indicates whether the event data store collects events from all Regions, or only from the Region in which it was created.</p>', 'CreateEventDataStoreResponse$OrganizationEnabled' => '<p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>', 'CreateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'CreateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail is created in the current Region or in all Regions. The default is false, which creates a trail only in the Region where you are signed in. As a best practice, consider creating trails that log events in all Regions.</p>', 'CreateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note> <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p> </note>', 'CreateTrailRequest$IsOrganizationTrail' => '<p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account or delegated administrator account for an organization in Organizations.</p>', 'CreateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'CreateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one Region or in all Regions.</p>', 'CreateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', 'CreateTrailResponse$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', 'DescribeTrailsRequest$includeShadowTrails' => '<p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a Region of a trail that was created in a different Region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and Region replication trails will not be returned. The default is true.</p>', 'EventDataStore$MultiRegionEnabled' => '<p>Indicates whether the event data store includes events from all Regions, or only from the Region in which it was created.</p>', 'EventDataStore$OrganizationEnabled' => '<p>Indicates that an event data store is collecting logged events for an organization.</p>', 'EventSelector$IncludeManagementEvents' => '<p>Specify if you want your event selector to include management events for your trail.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Management Events</a> in the <i>CloudTrail User Guide</i>.</p> <p>By default, the value is <code>true</code>.</p> <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>', 'GetEventDataStoreResponse$MultiRegionEnabled' => '<p>Indicates whether the event data store includes events from all Regions, or only from the Region in which it was created.</p>', 'GetEventDataStoreResponse$OrganizationEnabled' => '<p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>', 'GetTrailStatusResponse$IsLogging' => '<p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>', 'RestoreEventDataStoreResponse$MultiRegionEnabled' => '<p>Indicates whether the event data store is collecting events from all Regions, or only from the Region in which the event data store was created.</p>', 'RestoreEventDataStoreResponse$OrganizationEnabled' => '<p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>', 'SourceConfig$ApplyToAllRegions' => '<p> Specifies whether the channel applies to a single Region or to all Regions.</p>', 'Trail$IncludeGlobalServiceEvents' => '<p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>', 'Trail$IsMultiRegionTrail' => '<p>Specifies whether the trail exists only in one Region or exists in all Regions.</p>', 'Trail$LogFileValidationEnabled' => '<p>Specifies whether log file validation is enabled.</p>', 'Trail$HasCustomEventSelectors' => '<p>Specifies if the trail has custom event selectors.</p>', 'Trail$HasInsightSelectors' => '<p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>', 'Trail$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', 'UpdateEventDataStoreRequest$MultiRegionEnabled' => '<p>Specifies whether an event data store collects events from all Regions, or only from the Region in which it was created.</p>', 'UpdateEventDataStoreRequest$OrganizationEnabled' => '<p>Specifies whether an event data store collects events logged for an organization in Organizations.</p> <note> <p>Only the management account for the organization can convert an organization event data store to a non-organization event data store, or convert a non-organization event data store to an organization event data store.</p> </note>', 'UpdateEventDataStoreResponse$MultiRegionEnabled' => '<p>Indicates whether the event data store includes events from all Regions, or only from the Region in which it was created.</p>', 'UpdateEventDataStoreResponse$OrganizationEnabled' => '<p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>', 'UpdateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'UpdateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail applies only to the current Region or to all Regions. The default is false. If the trail exists only in the current Region and this value is set to true, shadow trails (replications of the trail) will be created in the other Regions. If the trail exists in all Regions and this value is set to false, the trail will remain in the Region where it was created, and its shadow trails in other Regions will be deleted. As a best practice, consider using trails that log events in all Regions.</p>', 'UpdateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file validation is enabled. The default is false.</p> <note> <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p> </note>', 'UpdateTrailRequest$IsOrganizationTrail' => '<p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p> <note> <p>Only the management account for the organization can convert an organization trail to a non-organization trail, or convert a non-organization trail to an organization trail.</p> </note>', 'UpdateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'UpdateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one Region or in all Regions.</p>', 'UpdateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', 'UpdateTrailResponse$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', ], ], 'ByteBuffer' => [ 'base' => NULL, 'refs' => [ 'PublicKey$Value' => '<p>The DER encoded public key value in PKCS#1 format.</p>', ], ], 'CancelQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CannotDelegateManagementAccountException' => [ 'base' => '<p>This exception is thrown when the management account of an organization is registered as the CloudTrail delegated administrator.</p>', 'refs' => [], ], 'Channel' => [ 'base' => '<p>Contains information about a returned CloudTrail channel.</p>', 'refs' => [ 'Channels$member' => NULL, ], ], 'ChannelARNInvalidException' => [ 'base' => '<p>This exception is thrown when the specified value of <code>ChannelARN</code> is not valid.</p>', 'refs' => [], ], 'ChannelAlreadyExistsException' => [ 'base' => '<p> This exception is thrown when the provided channel already exists. </p>', 'refs' => [], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'Channel$ChannelArn' => '<p>The Amazon Resource Name (ARN) of a channel.</p>', 'CreateChannelResponse$ChannelArn' => '<p>The Amazon Resource Name (ARN) of the new channel.</p>', 'DeleteChannelRequest$Channel' => '<p>The ARN or the <code>UUID</code> value of the channel that you want to delete.</p>', 'GetChannelRequest$Channel' => '<p>The ARN or <code>UUID</code> of a channel.</p>', 'GetChannelResponse$ChannelArn' => '<p>The ARN of an channel returned by a <code>GetChannel</code> request.</p>', 'UpdateChannelRequest$Channel' => '<p>The ARN or ID (the ARN suffix) of the channel that you want to update.</p>', 'UpdateChannelResponse$ChannelArn' => '<p>The ARN of the channel that was updated.</p>', ], ], 'ChannelExistsForEDSException' => [ 'base' => '<p>This exception is thrown when the specified event data store cannot yet be deleted because it is in use by a channel.</p>', 'refs' => [], ], 'ChannelMaxLimitExceededException' => [ 'base' => '<p> This exception is thrown when the maximum number of channels limit is exceeded. </p>', 'refs' => [], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$Name' => '<p> The name of the CloudTrail channel. For service-linked channels, the name is <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents the name of the Amazon Web Services service that created the channel and <code>custom-suffix</code> represents the suffix created by the Amazon Web Services service. </p>', 'CreateChannelRequest$Name' => '<p>The name of the channel.</p>', 'CreateChannelResponse$Name' => '<p>The name of the new channel.</p>', 'GetChannelResponse$Name' => '<p> The name of the CloudTrail channel. For service-linked channels, the name is <code>aws-service-channel/service-name/custom-suffix</code> where <code>service-name</code> represents the name of the Amazon Web Services service that created the channel and <code>custom-suffix</code> represents the suffix generated by the Amazon Web Services service. </p>', 'UpdateChannelRequest$Name' => '<p> Changes the name of the channel. </p>', 'UpdateChannelResponse$Name' => '<p>The name of the channel that was updated.</p>', ], ], 'ChannelNotFoundException' => [ 'base' => '<p>This exception is thrown when CloudTrail cannot find the specified channel.</p>', 'refs' => [], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Channels' => '<p> The list of channels in the account. </p>', ], ], 'CloudTrailARNInvalidException' => [ 'base' => '<p>This exception is thrown when an operation is called with an ARN that is not valid.</p> <p>The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>The following is the format of an event data store ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p> <p>The following is the format of a channel ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code> </p>', 'refs' => [], ], 'CloudTrailAccessNotEnabledException' => [ 'base' => '<p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access">How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.</p>', 'refs' => [], ], 'CloudTrailInvalidClientTokenIdException' => [ 'base' => '<p>This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</p>', 'refs' => [], ], 'CloudWatchLogsDeliveryUnavailableException' => [ 'base' => '<p>Cannot set a CloudWatch Logs delivery for this Region.</p>', 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p> You are trying to update a resource when another request is in progress. Allow sufficient wait time for the previous request to complete, then retry your request. </p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a resource before CloudTrail has time to fully load the resource, or because another operation is modifying the resource. If this exception occurs, wait a few minutes, and then try the operation again.</p>', 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDataStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDataStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrailRequest' => [ 'base' => '<p>Specifies the settings for each trail.</p>', 'refs' => [], ], 'CreateTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DataResource' => [ 'base' => '<p>Data events provide information about the resource operations performed on or within a resource itself. These are also known as data plane operations. You can specify up to 250 data resources for a trail.</p> <p>Configure the <code>DataResource</code> to specify the resource type and resource ARNs for which you want to log data events.</p> <p>You can specify the following resource types in your event selectors for your trail:</p> <ul> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::S3::Object</code> </p> </li> </ul> <note> <p>The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors for the trail.</p> <p>If you are using advanced event selectors, the maximum total number of values for all conditions, across all advanced event selectors for the trail, is 500.</p> </note> <p>The following example demonstrates how logging works when you configure logging of all data events for an S3 bucket named <code>bucket-1</code>. In this example, the CloudTrail user specified an empty prefix, and the option to log both <code>Read</code> and <code>Write</code> data events.</p> <ol> <li> <p>A user uploads an image file to <code>bucket-1</code>.</p> </li> <li> <p>The <code>PutObject</code> API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.</p> </li> <li> <p>A user uploads an object to an Amazon S3 bucket named <code>arn:aws:s3:::bucket-2</code>.</p> </li> <li> <p>The <code>PutObject</code> API operation occurred for an object in an S3 bucket that the CloudTrail user didn\'t specify for the trail. The trail doesn’t log the event.</p> </li> </ol> <p>The following example demonstrates how logging works when you configure logging of Lambda data events for a Lambda function named <i>MyLambdaFunction</i>, but not for all Lambda functions.</p> <ol> <li> <p>A user runs a script that includes a call to the <i>MyLambdaFunction</i> function and the <i>MyOtherLambdaFunction</i> function.</p> </li> <li> <p>The <code>Invoke</code> API operation on <i>MyLambdaFunction</i> is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for <i>MyLambdaFunction</i>, any invocations of that function are logged. The trail processes and logs the event.</p> </li> <li> <p>The <code>Invoke</code> API operation on <i>MyOtherLambdaFunction</i> is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the <code>Invoke</code> operation for <i>MyOtherLambdaFunction</i> does not match the function specified for the trail. The trail doesn’t log the event. </p> </li> </ol>', 'refs' => [ 'DataResources$member' => NULL, ], ], 'DataResourceValues' => [ 'base' => NULL, 'refs' => [ 'DataResource$Values' => '<p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified resource type.</p> <ul> <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3</code>.</p> <note> <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p> </note> </li> <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li> <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li> <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note> <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p> </note> </li> <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note> <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p> </note> </li> <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li> </ul>', ], ], 'DataResources' => [ 'base' => NULL, 'refs' => [ 'EventSelector$DataResources' => '<p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreResponse$CreatedTimestamp' => '<p>The timestamp that shows when the event data store was created.</p>', 'CreateEventDataStoreResponse$UpdatedTimestamp' => '<p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>', 'Event$EventTime' => '<p>The date and time of the event returned.</p>', 'EventDataStore$CreatedTimestamp' => '<p>The timestamp of the event data store\'s creation.</p>', 'EventDataStore$UpdatedTimestamp' => '<p>The timestamp showing when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>', 'GetEventDataStoreResponse$CreatedTimestamp' => '<p>The timestamp of the event data store\'s creation.</p>', 'GetEventDataStoreResponse$UpdatedTimestamp' => '<p>Shows the time that an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>', 'GetImportResponse$StartEventTime' => '<p> Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'GetImportResponse$EndEventTime' => '<p> Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'GetImportResponse$CreatedTimestamp' => '<p> The timestamp of the import\'s creation. </p>', 'GetImportResponse$UpdatedTimestamp' => '<p> The timestamp of when the import was updated. </p>', 'GetTrailStatusResponse$LatestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered log files to an account\'s Amazon S3 bucket.</p>', 'GetTrailStatusResponse$LatestNotificationTime' => '<p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account\'s Amazon S3 bucket.</p>', 'GetTrailStatusResponse$StartLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>', 'GetTrailStatusResponse$StopLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryTime' => '<p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered a digest file to an account\'s Amazon S3 bucket.</p>', 'ImportFailureListItem$LastUpdatedTime' => '<p> When the import was last updated. </p>', 'ImportsListItem$CreatedTimestamp' => '<p> The timestamp of the import\'s creation. </p>', 'ImportsListItem$UpdatedTimestamp' => '<p> The timestamp of the import\'s last update. </p>', 'IngestionStatus$LatestIngestionSuccessTime' => '<p>The time stamp of the most recent successful ingestion of events for the channel.</p>', 'IngestionStatus$LatestIngestionAttemptTime' => '<p>The time stamp of the most recent attempt to ingest events on the channel.</p>', 'ListInsightsMetricDataRequest$StartTime' => '<p>Specifies, in UTC, the start time for time-series data. The value specified is inclusive; results include data points with the specified time stamp.</p> <p>The default is 90 days before the time of request.</p>', 'ListInsightsMetricDataRequest$EndTime' => '<p>Specifies, in UTC, the end time for time-series data. The value specified is exclusive; results include data points up to the specified time stamp.</p> <p>The default is the time of request.</p>', 'ListPublicKeysRequest$StartTime' => '<p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>', 'ListPublicKeysRequest$EndTime' => '<p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>', 'ListQueriesRequest$StartTime' => '<p>Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>', 'ListQueriesRequest$EndTime' => '<p>Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>', 'LookupEventsRequest$StartTime' => '<p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>', 'LookupEventsRequest$EndTime' => '<p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>', 'PublicKey$ValidityStartTime' => '<p>The starting time of validity of the public key.</p>', 'PublicKey$ValidityEndTime' => '<p>The ending time of validity of the public key.</p>', 'Query$CreationTime' => '<p>The creation time of a query.</p>', 'QueryStatisticsForDescribeQuery$CreationTime' => '<p>The creation time of the query.</p>', 'RestoreEventDataStoreResponse$CreatedTimestamp' => '<p>The timestamp of an event data store\'s creation.</p>', 'RestoreEventDataStoreResponse$UpdatedTimestamp' => '<p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>', 'StartImportRequest$StartEventTime' => '<p> Use with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. When you specify a time range, CloudTrail checks the prefix and log file names to verify the names contain a date between the specified <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events. </p>', 'StartImportRequest$EndEventTime' => '<p> Use with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. When you specify a time range, CloudTrail checks the prefix and log file names to verify the names contain a date between the specified <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events. </p>', 'StartImportResponse$StartEventTime' => '<p> Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'StartImportResponse$EndEventTime' => '<p> Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'StartImportResponse$CreatedTimestamp' => '<p> The timestamp for the import\'s creation. </p>', 'StartImportResponse$UpdatedTimestamp' => '<p> The timestamp of the import\'s last update, if applicable. </p>', 'StopImportResponse$CreatedTimestamp' => '<p> The timestamp of the import\'s creation. </p>', 'StopImportResponse$UpdatedTimestamp' => '<p> The timestamp of the import\'s last update. </p>', 'StopImportResponse$StartEventTime' => '<p> Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'StopImportResponse$EndEventTime' => '<p> Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events to only those events logged within a specified time period. </p>', 'Timestamps$member' => NULL, 'UpdateEventDataStoreResponse$CreatedTimestamp' => '<p>The timestamp that shows when an event data store was first created.</p>', 'UpdateEventDataStoreResponse$UpdatedTimestamp' => '<p>The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>', ], ], 'DelegatedAdminAccountLimitExceededException' => [ 'base' => '<p>This exception is thrown when the maximum number of CloudTrail delegated administrators is reached.</p>', 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDataStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDataStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrailRequest' => [ 'base' => '<p>The request that specifies the name of a trail to delete.</p>', 'refs' => [], ], 'DeleteTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DeliveryS3Uri' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryResponse$DeliveryS3Uri' => '<p>The URI for the S3 bucket where CloudTrail delivered query results, if applicable.</p>', 'StartQueryRequest$DeliveryS3Uri' => '<p> The URI for the S3 bucket where CloudTrail delivers the query results. </p>', ], ], 'DeliveryStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryResponse$DeliveryStatus' => '<p>The delivery status.</p>', ], ], 'DeregisterOrganizationDelegatedAdminRequest' => [ 'base' => '<p>Removes CloudTrail delegated administrator permissions from a specified member account in an organization that is currently designated as a delegated administrator.</p>', 'refs' => [], ], 'DeregisterOrganizationDelegatedAdminResponse' => [ 'base' => '<p>Returns the following response if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DescribeQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrailsRequest' => [ 'base' => '<p>Returns information about the trail.</p>', 'refs' => [], ], 'DescribeTrailsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'Destination' => [ 'base' => '<p>Contains information about the destination receiving events.</p>', 'refs' => [ 'Destinations$member' => NULL, ], ], 'DestinationType' => [ 'base' => NULL, 'refs' => [ 'Destination$Type' => '<p>The type of destination for events arriving from a channel. For channels used for a CloudTrail Lake integration, the value is <code>EVENT_DATA_STORE</code>. For service-linked channels, the value is <code>AWS_SERVICE</code>. </p>', ], ], 'Destinations' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$Destinations' => '<p>One or more event data stores to which events arriving through a channel will be logged.</p>', 'CreateChannelResponse$Destinations' => '<p>The event data stores that log the events arriving through the channel.</p>', 'GetChannelResponse$Destinations' => '<p>The destinations for the channel. For channels created for integrations, the destinations are the event data stores that log events arriving through the channel. For service-linked channels, the destination is the Amazon Web Services service that created the service-linked channel to receive events.</p>', 'UpdateChannelRequest$Destinations' => '<p>The ARNs of event data stores that you want to log events arriving through the channel.</p>', 'UpdateChannelResponse$Destinations' => '<p>The event data stores that log events arriving through the channel.</p>', ], ], 'DisableFederationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableFederationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'InsightsMetricValues$member' => NULL, ], ], 'EnableFederationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableFederationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$ErrorCode' => '<p>Conditionally required if the <code>InsightType</code> parameter is set to <code>ApiErrorRateInsight</code>.</p> <p>If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve data for. For example, <code>AccessDenied</code>.</p>', 'ListInsightsMetricDataResponse$ErrorCode' => '<p>Only returned if <code>InsightType</code> parameter was set to <code>ApiErrorRateInsight</code>.</p> <p>If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve data for. For example, <code>AccessDenied</code>.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryResponse$ErrorMessage' => '<p>The error message returned if a query failed.</p>', 'GetQueryResultsResponse$ErrorMessage' => '<p>The error message returned if a query failed.</p>', 'IngestionStatus$LatestIngestionErrorCode' => '<p>The error code for the most recent failure to ingest events.</p>', ], ], 'Event' => [ 'base' => '<p>Contains information about an event that was returned by a lookup request. The result includes a representation of a CloudTrail event.</p>', 'refs' => [ 'EventsList$member' => NULL, ], ], 'EventCategory' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$EventCategory' => '<p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>', ], ], 'EventDataStore' => [ 'base' => '<p>A storage lake of event data against which you can run complex SQL-based queries. An event data store can include events that you have logged on your account. To select events for an event data store, use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-concepts.html#adv-event-selectors">advanced event selectors</a>.</p>', 'refs' => [ 'EventDataStores$member' => NULL, ], ], 'EventDataStoreARNInvalidException' => [ 'base' => '<p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>', 'refs' => [], ], 'EventDataStoreAlreadyExistsException' => [ 'base' => '<p>An event data store with that name already exists.</p>', 'refs' => [], ], 'EventDataStoreArn' => [ 'base' => NULL, 'refs' => [ 'CancelQueryRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.</p>', 'CreateEventDataStoreResponse$EventDataStoreArn' => '<p>The ARN of the event data store.</p>', 'DeleteEventDataStoreRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of the event data store to delete.</p>', 'DescribeQueryRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.</p>', 'DisableFederationRequest$EventDataStore' => '<p> The ARN (or ID suffix of the ARN) of the event data store for which you want to disable Lake query federation. </p>', 'DisableFederationResponse$EventDataStoreArn' => '<p> The ARN of the event data store for which you disabled Lake query federation. </p>', 'EnableFederationRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the event data store for which you want to enable Lake query federation.</p>', 'EnableFederationResponse$EventDataStoreArn' => '<p> The ARN of the event data store for which you enabled Lake query federation. </p>', 'EventDataStore$EventDataStoreArn' => '<p>The ARN of the event data store.</p>', 'GetEventDataStoreRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the event data store about which you want information.</p>', 'GetEventDataStoreResponse$EventDataStoreArn' => '<p>The event data store Amazon Resource Number (ARN).</p>', 'GetInsightSelectorsRequest$EventDataStore' => '<p> Specifies the ARN (or ID suffix of the ARN) of the event data store for which you want to get Insights selectors. </p> <p>You cannot use this parameter with the <code>TrailName</code> parameter.</p>', 'GetInsightSelectorsResponse$EventDataStoreArn' => '<p> The ARN of the source event data store that enabled Insights events. </p>', 'GetInsightSelectorsResponse$InsightsDestination' => '<p> The ARN of the destination event data store that logs Insights events. </p>', 'GetQueryResultsRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the event data store against which the query was run.</p>', 'ImportDestinations$member' => NULL, 'ListImportsRequest$Destination' => '<p> The ARN of the destination event data store. </p>', 'ListQueriesRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.</p>', 'PutInsightSelectorsRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add Insights selectors. To enable Insights on an event data store, you must provide both the <code>EventDataStore</code> and <code>InsightsDestination</code> parameters.</p> <p>You cannot use this parameter with the <code>TrailName</code> parameter.</p>', 'PutInsightSelectorsRequest$InsightsDestination' => '<p> The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To enable Insights on an event data store, you must provide both the <code>EventDataStore</code> and <code>InsightsDestination</code> parameters. </p> <p>You cannot use this parameter with the <code>TrailName</code> parameter.</p>', 'PutInsightSelectorsResponse$EventDataStoreArn' => '<p>The Amazon Resource Name (ARN) of the source event data store for which you want to change or add Insights selectors.</p>', 'PutInsightSelectorsResponse$InsightsDestination' => '<p> The ARN of the destination event data store that logs Insights events. </p>', 'RestoreEventDataStoreRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of the event data store that you want to restore.</p>', 'RestoreEventDataStoreResponse$EventDataStoreArn' => '<p>The event data store ARN.</p>', 'StartEventDataStoreIngestionRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the event data store for which you want to start ingestion.</p>', 'StopEventDataStoreIngestionRequest$EventDataStore' => '<p>The ARN (or ID suffix of the ARN) of the event data store for which you want to stop ingestion.</p>', 'UpdateEventDataStoreRequest$EventDataStore' => '<p>The ARN (or the ID suffix of the ARN) of the event data store that you want to update.</p>', 'UpdateEventDataStoreResponse$EventDataStoreArn' => '<p>The ARN of the event data store.</p>', ], ], 'EventDataStoreFederationEnabledException' => [ 'base' => '<p> You cannot delete the event data store because Lake query federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation to disable Lake query federation on the event data store. </p>', 'refs' => [], ], 'EventDataStoreHasOngoingImportException' => [ 'base' => '<p> This exception is thrown when you try to update or delete an event data store that currently has an import in progress. </p>', 'refs' => [], ], 'EventDataStoreKmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <important> <p>Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.</p> </important> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p> <code>alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p> </li> <li> <p> <code>12345678-1234-1234-1234-123456789012</code> </p> </li> </ul>', 'CreateEventDataStoreResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'GetEventDataStoreResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'RestoreEventDataStoreResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'UpdateEventDataStoreRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <important> <p>Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.</p> </important> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p> <code>alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p> </li> <li> <p> <code>12345678-1234-1234-1234-123456789012</code> </p> </li> </ul>', 'UpdateEventDataStoreResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', ], ], 'EventDataStoreMaxLimitExceededException' => [ 'base' => '<p>Your account has used the maximum number of event data stores.</p>', 'refs' => [], ], 'EventDataStoreName' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$Name' => '<p>The name of the event data store.</p>', 'CreateEventDataStoreResponse$Name' => '<p>The name of the event data store.</p>', 'EventDataStore$Name' => '<p>The name of the event data store.</p>', 'GetEventDataStoreResponse$Name' => '<p>The name of the event data store.</p>', 'RestoreEventDataStoreResponse$Name' => '<p>The name of the event data store.</p>', 'UpdateEventDataStoreRequest$Name' => '<p>The event data store name.</p>', 'UpdateEventDataStoreResponse$Name' => '<p>The name of the event data store.</p>', ], ], 'EventDataStoreNotFoundException' => [ 'base' => '<p>The specified event data store was not found.</p>', 'refs' => [], ], 'EventDataStoreStatus' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreResponse$Status' => '<p>The status of event data store creation.</p>', 'EventDataStore$Status' => '<p>The status of an event data store.</p>', 'GetEventDataStoreResponse$Status' => '<p>The status of an event data store.</p>', 'RestoreEventDataStoreResponse$Status' => '<p>The status of the event data store.</p>', 'UpdateEventDataStoreResponse$Status' => '<p>The status of an event data store.</p>', ], ], 'EventDataStoreTerminationProtectedException' => [ 'base' => '<p>The event data store cannot be deleted because termination protection is enabled for it.</p>', 'refs' => [], ], 'EventDataStores' => [ 'base' => NULL, 'refs' => [ 'ListEventDataStoresResponse$EventDataStores' => '<p>Contains information about event data stores in the account, in the current Region.</p>', ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$EventName' => '<p>The name of the event, typically the Amazon Web Services API on which unusual levels of activity were recorded.</p>', 'ListInsightsMetricDataResponse$EventName' => '<p>The name of the event, typically the Amazon Web Services API on which unusual levels of activity were recorded.</p>', ], ], 'EventSelector' => [ 'base' => '<p>Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn\'t match any event selector, the trail doesn\'t log the event.</p> <p>You can configure up to five event selectors for a trail.</p> <p>You cannot apply both event selectors and advanced event selectors to a trail.</p>', 'refs' => [ 'EventSelectors$member' => NULL, ], ], 'EventSelectors' => [ 'base' => NULL, 'refs' => [ 'GetEventSelectorsResponse$EventSelectors' => '<p>The event selectors that are configured for the trail.</p>', 'PutEventSelectorsRequest$EventSelectors' => '<p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>', 'PutEventSelectorsResponse$EventSelectors' => '<p>Specifies the event selectors configured for your trail.</p>', ], ], 'EventSource' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$EventSource' => '<p>The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or <code>s3.amazonaws.com</code>.</p>', 'ListInsightsMetricDataResponse$EventSource' => '<p>The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or <code>s3.amazonaws.com</code>.</p>', ], ], 'EventsList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsResponse$Events' => '<p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>', ], ], 'ExcludeManagementEventSources' => [ 'base' => NULL, 'refs' => [ 'EventSelector$ExcludeManagementEventSources' => '<p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in Regions that support the event source.</p>', ], ], 'FederationRoleArn' => [ 'base' => NULL, 'refs' => [ 'EnableFederationRequest$FederationRoleArn' => '<p> The ARN of the federation role to use for the event data store. Amazon Web Services services like Lake Formation use this federation role to access data for the federated event data store. The federation role must exist in your account and provide the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role">required minimum permissions</a>. </p>', 'EnableFederationResponse$FederationRoleArn' => '<p> The ARN of the federation role. </p>', 'GetEventDataStoreResponse$FederationRoleArn' => '<p> If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store. </p>', 'UpdateEventDataStoreResponse$FederationRoleArn' => '<p> If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store. </p>', ], ], 'FederationStatus' => [ 'base' => NULL, 'refs' => [ 'DisableFederationResponse$FederationStatus' => '<p> The federation status. </p>', 'EnableFederationResponse$FederationStatus' => '<p> The federation status. </p>', 'GetEventDataStoreResponse$FederationStatus' => '<p> Indicates the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> status. The status is <code>ENABLED</code> if Lake query federation is enabled, or <code>DISABLED</code> if Lake query federation is disabled. You cannot delete an event data store if the <code>FederationStatus</code> is <code>ENABLED</code>. </p>', 'UpdateEventDataStoreResponse$FederationStatus' => '<p> Indicates the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> status. The status is <code>ENABLED</code> if Lake query federation is enabled, or <code>DISABLED</code> if Lake query federation is disabled. You cannot delete an event data store if the <code>FederationStatus</code> is <code>ENABLED</code>. </p>', ], ], 'GetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventDataStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventDataStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailStatusRequest' => [ 'base' => '<p>The name of a trail about which you want the current status.</p>', 'refs' => [], ], 'GetTrailStatusResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'ImportDestinations' => [ 'base' => NULL, 'refs' => [ 'GetImportResponse$Destinations' => '<p> The ARN of the destination event data store. </p>', 'ImportsListItem$Destinations' => '<p> The ARN of the destination event data store. </p>', 'StartImportRequest$Destinations' => '<p> The ARN of the destination event data store. Use this parameter for a new import. </p>', 'StartImportResponse$Destinations' => '<p> The ARN of the destination event data store. </p>', 'StopImportResponse$Destinations' => '<p> The ARN of the destination event data store. </p>', ], ], 'ImportFailureList' => [ 'base' => NULL, 'refs' => [ 'ListImportFailuresResponse$Failures' => '<p> Contains information about the import failures. </p>', ], ], 'ImportFailureListItem' => [ 'base' => '<p> Provides information about an import failure. </p>', 'refs' => [ 'ImportFailureList$member' => NULL, ], ], 'ImportFailureStatus' => [ 'base' => NULL, 'refs' => [ 'ImportFailureListItem$Status' => '<p> The status of the import. </p>', ], ], 'ImportNotFoundException' => [ 'base' => '<p> The specified import was not found. </p>', 'refs' => [], ], 'ImportSource' => [ 'base' => '<p> The import source. </p>', 'refs' => [ 'GetImportResponse$ImportSource' => '<p> The source S3 bucket. </p>', 'StartImportRequest$ImportSource' => '<p> The source S3 bucket for the import. Use this parameter for a new import. </p>', 'StartImportResponse$ImportSource' => '<p> The source S3 bucket for the import. </p>', 'StopImportResponse$ImportSource' => '<p> The source S3 bucket for the import. </p>', ], ], 'ImportStatistics' => [ 'base' => '<p> Provides statistics for the specified <code>ImportID</code>. CloudTrail does not update import statistics in real-time. Returned values for parameters such as <code>EventsCompleted</code> may be lower than the actual value, because CloudTrail updates statistics incrementally over the course of the import. </p>', 'refs' => [ 'GetImportResponse$ImportStatistics' => '<p> Provides statistics for the import. CloudTrail does not update import statistics in real-time. Returned values for parameters such as <code>EventsCompleted</code> may be lower than the actual value, because CloudTrail updates statistics incrementally over the course of the import. </p>', 'StopImportResponse$ImportStatistics' => '<p> Returns information on the stopped import. </p>', ], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'GetImportResponse$ImportStatus' => '<p> The status of the import. </p>', 'ImportsListItem$ImportStatus' => '<p> The status of the import. </p>', 'ListImportsRequest$ImportStatus' => '<p> The status of the import. </p>', 'StartImportResponse$ImportStatus' => '<p> Shows the status of the import after a <code>StartImport</code> request. An import finishes with a status of <code>COMPLETED</code> if there were no failures, or <code>FAILED</code> if there were failures. </p>', 'StopImportResponse$ImportStatus' => '<p> The status of the import. </p>', ], ], 'ImportsList' => [ 'base' => NULL, 'refs' => [ 'ListImportsResponse$Imports' => '<p> The list of returned imports. </p>', ], ], 'ImportsListItem' => [ 'base' => '<p> Contains information about an import that was returned by a lookup request. </p>', 'refs' => [ 'ImportsList$member' => NULL, ], ], 'InactiveEventDataStoreException' => [ 'base' => '<p>The event data store is inactive.</p>', 'refs' => [], ], 'InactiveQueryException' => [ 'base' => '<p>The specified query cannot be canceled because it is in the <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</p>', 'refs' => [], ], 'IngestionStatus' => [ 'base' => '<p>A table showing information about the most recent successful and failed attempts to ingest events.</p>', 'refs' => [ 'GetChannelResponse$IngestionStatus' => '<p>A table showing information about the most recent successful and failed attempts to ingest events.</p>', ], ], 'InsightNotEnabledException' => [ 'base' => '<p>If you run <code>GetInsightSelectors</code> on a trail or event data store that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</p>', 'refs' => [], ], 'InsightSelector' => [ 'base' => '<p>A JSON string that contains a list of Insights types that are logged on a trail or event data store.</p>', 'refs' => [ 'InsightSelectors$member' => NULL, ], ], 'InsightSelectors' => [ 'base' => NULL, 'refs' => [ 'GetInsightSelectorsResponse$InsightSelectors' => '<p>A JSON string that contains the Insight types you want to log on a trail or event data store. <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as Insights types.</p>', 'PutInsightSelectorsRequest$InsightSelectors' => '<p>A JSON string that contains the Insights types you want to log on a trail or event data store. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.</p> <p>The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.</p> <p>The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.</p>', 'PutInsightSelectorsResponse$InsightSelectors' => '<p>A JSON string that contains the Insights event types that you want to log on a trail or event data store. The valid Insights types are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p>', ], ], 'InsightType' => [ 'base' => NULL, 'refs' => [ 'InsightSelector$InsightType' => '<p>The type of Insights events to log on a trail or event data store. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.</p> <p>The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.</p> <p>The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.</p>', 'ListInsightsMetricDataRequest$InsightType' => '<p>The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume. The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.</p>', 'ListInsightsMetricDataResponse$InsightType' => '<p>The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume. The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.</p>', ], ], 'InsightsMetricDataType' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$DataType' => '<p>Type of datapoints to return. Valid values are <code>NonZeroData</code> and <code>FillWithZeros</code>. The default is <code>NonZeroData</code>.</p>', ], ], 'InsightsMetricMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$MaxResults' => '<p>The maximum number of datapoints to return. Valid values are integers from 1 to 21600. The default value is 21600.</p>', ], ], 'InsightsMetricNextToken' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$NextToken' => '<p>Returned if all datapoints can\'t be returned in a single call. For example, due to reaching <code>MaxResults</code>.</p> <p>Add this parameter to the request to continue retrieving results starting from the last evaluated point.</p>', 'ListInsightsMetricDataResponse$NextToken' => '<p>Only returned if the full results could not be returned in a single query. You can set the <code>NextToken</code> parameter in the next request to this value to continue retrieval.</p>', ], ], 'InsightsMetricPeriod' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataRequest$Period' => '<p>Granularity of data to retrieve, in seconds. Valid values are <code>60</code>, <code>300</code>, and <code>3600</code>. If you specify any other value, you will get an error. The default is 3600 seconds.</p>', ], ], 'InsightsMetricValues' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataResponse$Values' => '<p>List of values representing the API call rate or error rate at each timestamp. The number of values is equal to the number of timestamps.</p>', ], ], 'InsufficientDependencyServiceAccessPermissionException' => [ 'base' => '<p>This exception is thrown when the IAM identity that is used to create the organization resource lacks one or more required permissions for creating an organization resource in a required service.</p>', 'refs' => [], ], 'InsufficientEncryptionPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the S3 bucket or KMS key does not have sufficient permissions for the operation.</p>', 'refs' => [], ], 'InsufficientS3BucketPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>', 'refs' => [], ], 'InsufficientSnsTopicPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the Amazon SNS topic is not sufficient.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'QueryStatistics$ResultsCount' => '<p>The number of results returned.</p>', 'QueryStatistics$TotalResultsCount' => '<p>The total number of results returned by a query.</p>', 'QueryStatisticsForDescribeQuery$ExecutionTimeInMillis' => '<p>The query\'s run time, in milliseconds.</p>', ], ], 'InvalidCloudWatchLogsLogGroupArnException' => [ 'base' => '<p>This exception is thrown when the provided CloudWatch Logs log group is not valid.</p>', 'refs' => [], ], 'InvalidCloudWatchLogsRoleArnException' => [ 'base' => '<p>This exception is thrown when the provided role is not valid.</p>', 'refs' => [], ], 'InvalidDateRangeException' => [ 'base' => '<p>A date range for the query was specified that is not valid. Be sure that the start time is chronologically before the end time. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>', 'refs' => [], ], 'InvalidEventCategoryException' => [ 'base' => '<p>Occurs if an event category that is not valid is specified as a value of <code>EventCategory</code>.</p>', 'refs' => [], ], 'InvalidEventDataStoreCategoryException' => [ 'base' => '<p>This exception is thrown when event categories of specified event data stores are not valid.</p>', 'refs' => [], ], 'InvalidEventDataStoreStatusException' => [ 'base' => '<p>The event data store is not in a status that supports the operation.</p>', 'refs' => [], ], 'InvalidEventSelectorsException' => [ 'base' => '<p>This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors, advanced event selectors, or data resources that is not valid. The combination of event selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources can be distributed across event selectors, but the overall total cannot exceed 250.</p> <p>You can:</p> <ul> <li> <p>Specify a valid number of event selectors (1 to 5) for a trail.</p> </li> <li> <p>Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of data resources does not exceed 250 across all event selectors for a trail.</p> </li> <li> <p>Specify up to 500 values for all conditions in all advanced event selectors for a trail.</p> </li> <li> <p>Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value of <code>read-only</code> is not valid.</p> </li> </ul>', 'refs' => [], ], 'InvalidHomeRegionException' => [ 'base' => '<p>This exception is thrown when an operation is called on a trail from a Region other than the Region in which the trail was created.</p>', 'refs' => [], ], 'InvalidImportSourceException' => [ 'base' => '<p> This exception is thrown when the provided source S3 bucket is not valid for import. </p>', 'refs' => [], ], 'InvalidInsightSelectorsException' => [ 'base' => '<p>For <code>PutInsightSelectors</code>, this exception is thrown when the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source event data store specified by the <code>EventDataStore</code> parameter must log management events.</p> <p>For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data store and the updated advanced event selectors are not compatible with the configured <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of <code>ApiErrorRateInsight</code>, the source event data store must log management events.</p>', 'refs' => [], ], 'InvalidKmsKeyIdException' => [ 'base' => '<p>This exception is thrown when the KMS key ARN is not valid.</p>', 'refs' => [], ], 'InvalidLookupAttributesException' => [ 'base' => '<p>Occurs when a lookup attribute is specified that is not valid.</p>', 'refs' => [], ], 'InvalidMaxResultsException' => [ 'base' => '<p>This exception is thrown if the limit specified is not valid.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>This exception is thrown when the combination of parameters provided is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>The request includes a parameter that is not valid.</p>', 'refs' => [], ], 'InvalidQueryStatementException' => [ 'base' => '<p>The query that was submitted has validation errors, or uses incorrect syntax or unsupported keywords. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>', 'refs' => [], ], 'InvalidQueryStatusException' => [ 'base' => '<p>The query status is not valid for the operation.</p>', 'refs' => [], ], 'InvalidS3BucketNameException' => [ 'base' => '<p>This exception is thrown when the provided S3 bucket name is not valid.</p>', 'refs' => [], ], 'InvalidS3PrefixException' => [ 'base' => '<p>This exception is thrown when the provided S3 prefix is not valid.</p>', 'refs' => [], ], 'InvalidSnsTopicNameException' => [ 'base' => '<p>This exception is thrown when the provided SNS topic name is not valid.</p>', 'refs' => [], ], 'InvalidSourceException' => [ 'base' => '<p>This exception is thrown when the specified value of <code>Source</code> is not valid.</p>', 'refs' => [], ], 'InvalidTagParameterException' => [ 'base' => '<p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>Occurs if the timestamp values are not valid. Either the start time occurs after the end time, or the time range is outside the range of possible values.</p>', 'refs' => [], ], 'InvalidTokenException' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [], ], 'InvalidTrailNameException' => [ 'base' => '<p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul>', 'refs' => [], ], 'KmsException' => [ 'base' => '<p>This exception is thrown when there is an issue with the specified KMS key and the trail or event data store can\'t be updated.</p>', 'refs' => [], ], 'KmsKeyDisabledException' => [ 'base' => '<p>This exception is no longer in use.</p>', 'refs' => [], ], 'KmsKeyNotFoundException' => [ 'base' => '<p>This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not in the same Region.</p>', 'refs' => [], ], 'ListChannelsMaxResultsCount' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$MaxResults' => '<p> The maximum number of CloudTrail channels to display on a single page. </p>', ], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventDataStoresMaxResultsCount' => [ 'base' => NULL, 'refs' => [ 'ListEventDataStoresRequest$MaxResults' => '<p>The maximum number of event data stores to display on a single page.</p>', ], ], 'ListEventDataStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventDataStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportFailuresMaxResultsCount' => [ 'base' => NULL, 'refs' => [ 'ListImportFailuresRequest$MaxResults' => '<p> The maximum number of failures to display on a single page. </p>', ], ], 'ListImportFailuresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportFailuresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsMaxResultsCount' => [ 'base' => NULL, 'refs' => [ 'ListImportsRequest$MaxResults' => '<p> The maximum number of imports to display on a single page. </p>', ], ], 'ListImportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPublicKeysRequest' => [ 'base' => '<p>Requests the public keys for a specified time range.</p>', 'refs' => [], ], 'ListPublicKeysResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'ListQueriesMaxResultsCount' => [ 'base' => NULL, 'refs' => [ 'ListQueriesRequest$MaxResults' => '<p>The maximum number of queries to show on a page.</p>', ], ], 'ListQueriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Specifies a list of tags to return.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'ListTrailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'Destination$Location' => '<p> For channels used for a CloudTrail Lake integration, the location is the ARN of an event data store that receives events from a channel. For service-linked channels, the location is the name of the Amazon Web Services service.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ImportStatistics$PrefixesFound' => '<p> The number of S3 prefixes found for the import. </p>', 'ImportStatistics$PrefixesCompleted' => '<p> The number of S3 prefixes that completed import. </p>', 'ImportStatistics$FilesCompleted' => '<p>The number of log files that completed import.</p>', 'ImportStatistics$EventsCompleted' => '<p> The number of trail events imported into the event data store. </p>', 'ImportStatistics$FailedEntries' => '<p> The number of failed entries. </p>', 'QueryStatistics$BytesScanned' => '<p>The total bytes that the query scanned in the event data store. This value matches the number of bytes for which your account is billed for the query, unless the query is still running.</p>', 'QueryStatisticsForDescribeQuery$EventsMatched' => '<p>The number of events that matched a query.</p>', 'QueryStatisticsForDescribeQuery$EventsScanned' => '<p>The number of events that the query scanned in the event data store.</p>', 'QueryStatisticsForDescribeQuery$BytesScanned' => '<p>The total bytes that the query scanned in the event data store. This value matches the number of bytes for which your account is billed for the query, unless the query is still running.</p>', ], ], 'LookupAttribute' => [ 'base' => '<p>Specifies an attribute and value that filter the events returned.</p>', 'refs' => [ 'LookupAttributesList$member' => NULL, ], ], 'LookupAttributeKey' => [ 'base' => NULL, 'refs' => [ 'LookupAttribute$AttributeKey' => '<p>Specifies an attribute on which to filter the events returned.</p>', ], ], 'LookupAttributeValue' => [ 'base' => NULL, 'refs' => [ 'LookupAttribute$AttributeValue' => '<p>Specifies a value for the specified <code>AttributeKey</code>.</p> <p>The maximum length for the <code>AttributeValue</code> is 2000 characters. The following characters (\'<code>_</code>\', \'<code> </code>\', \'<code>,</code>\', \'<code>\\\\n</code>\') count as two characters towards the 2000 character limit.</p>', ], ], 'LookupAttributesList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$LookupAttributes' => '<p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>', ], ], 'LookupEventsRequest' => [ 'base' => '<p>Contains a request for LookupEvents.</p>', 'refs' => [], ], 'LookupEventsResponse' => [ 'base' => '<p>Contains a response to a LookupEvents action.</p>', 'refs' => [], ], 'MaxConcurrentQueriesException' => [ 'base' => '<p>You are already running the maximum number of concurrent queries. The maximum number of concurrent queries is 10. Wait a minute for some queries to finish, and then run the query again.</p>', 'refs' => [], ], 'MaxQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsRequest$MaxQueryResults' => '<p>The maximum number of query results to display on a single page.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$MaxResults' => '<p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>', ], ], 'MaximumNumberOfTrailsExceededException' => [ 'base' => '<p>This exception is thrown when the maximum number of trails is reached.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'LookupEventsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', ], ], 'NoManagementAccountSLRExistsException' => [ 'base' => '<p> This exception is thrown when the management account does not have a service-linked role. </p>', 'refs' => [], ], 'NotOrganizationManagementAccountException' => [ 'base' => '<p> This exception is thrown when the account making the request is not the organization\'s management account. </p>', 'refs' => [], ], 'NotOrganizationMasterAccountException' => [ 'base' => '<p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail or event data store is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a> or <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html">Organization event data stores</a>.</p>', 'refs' => [], ], 'OperationNotPermittedException' => [ 'base' => '<p>This exception is thrown when the requested operation is not permitted.</p>', 'refs' => [], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'AdvancedFieldSelector$Equals' => '<p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>', 'AdvancedFieldSelector$StartsWith' => '<p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>', 'AdvancedFieldSelector$EndsWith' => '<p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>', 'AdvancedFieldSelector$NotEquals' => '<p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>', 'AdvancedFieldSelector$NotStartsWith' => '<p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>', 'AdvancedFieldSelector$NotEndsWith' => '<p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>', ], ], 'OperatorValue' => [ 'base' => NULL, 'refs' => [ 'Operator$member' => NULL, ], ], 'OrganizationNotInAllFeaturesModeException' => [ 'base' => '<p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail or event data store.</p>', 'refs' => [], ], 'OrganizationsNotInUseException' => [ 'base' => '<p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>', 'refs' => [], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsRequest$NextToken' => '<p>A token you can use to get the next page of query results.</p>', 'GetQueryResultsResponse$NextToken' => '<p>A token you can use to get the next page of query results.</p>', 'ListChannelsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'ListChannelsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call.</p>', 'ListEventDataStoresRequest$NextToken' => '<p>A token you can use to get the next page of event data store results.</p>', 'ListEventDataStoresResponse$NextToken' => '<p>A token you can use to get the next page of results.</p>', 'ListImportFailuresRequest$NextToken' => '<p> A token you can use to get the next page of import failures. </p>', 'ListImportFailuresResponse$NextToken' => '<p> A token you can use to get the next page of results. </p>', 'ListImportsRequest$NextToken' => '<p> A token you can use to get the next page of import results. </p>', 'ListImportsResponse$NextToken' => '<p> A token you can use to get the next page of import results. </p>', 'ListQueriesRequest$NextToken' => '<p>A token you can use to get the next page of results.</p>', 'ListQueriesResponse$NextToken' => '<p>A token you can use to get the next page of results.</p>', ], ], 'PartitionKey' => [ 'base' => '<p>Contains information about a partition key for an event data store.</p>', 'refs' => [ 'PartitionKeyList$member' => NULL, ], ], 'PartitionKeyList' => [ 'base' => NULL, 'refs' => [ 'GetEventDataStoreResponse$PartitionKeys' => '<p>The partition keys for the event data store. To improve query performance and efficiency, CloudTrail Lake organizes event data into partitions based on values derived from partition keys.</p>', ], ], 'PartitionKeyName' => [ 'base' => NULL, 'refs' => [ 'PartitionKey$Name' => '<p>The name of the partition key.</p>', ], ], 'PartitionKeyType' => [ 'base' => NULL, 'refs' => [ 'PartitionKey$Type' => '<p>The data type of the partition key. For example, <code>bigint</code> or <code>string</code>.</p>', ], ], 'PublicKey' => [ 'base' => '<p>Contains information about a returned public key.</p>', 'refs' => [ 'PublicKeyList$member' => NULL, ], ], 'PublicKeyList' => [ 'base' => NULL, 'refs' => [ 'ListPublicKeysResponse$PublicKeyList' => '<p>Contains an array of PublicKey objects.</p> <note> <p>The returned public keys may have validity time ranges that overlap.</p> </note>', ], ], 'PutEventSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Queries' => [ 'base' => NULL, 'refs' => [ 'ListQueriesResponse$Queries' => '<p>Lists matching query results, and shows query ID, status, and creation time of each query.</p>', ], ], 'Query' => [ 'base' => '<p>A SQL string of criteria about events that you want to collect in an event data store.</p>', 'refs' => [ 'Queries$member' => NULL, ], ], 'QueryAlias' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryRequest$QueryAlias' => '<p> The alias that identifies a query template. </p>', 'StartQueryRequest$QueryAlias' => '<p> The alias that identifies a query template. </p>', ], ], 'QueryIdNotFoundException' => [ 'base' => '<p>The query ID does not exist or does not map to a query.</p>', 'refs' => [], ], 'QueryParameter' => [ 'base' => NULL, 'refs' => [ 'QueryParameters$member' => NULL, ], ], 'QueryParameters' => [ 'base' => NULL, 'refs' => [ 'StartQueryRequest$QueryParameters' => '<p> The query parameters for the specified <code>QueryAlias</code>. </p>', ], ], 'QueryResultColumn' => [ 'base' => NULL, 'refs' => [ 'QueryResultRow$member' => NULL, ], ], 'QueryResultKey' => [ 'base' => NULL, 'refs' => [ 'QueryResultColumn$key' => NULL, ], ], 'QueryResultRow' => [ 'base' => NULL, 'refs' => [ 'QueryResultRows$member' => NULL, ], ], 'QueryResultRows' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsResponse$QueryResultRows' => '<p>Contains the individual event results of the query.</p>', ], ], 'QueryResultValue' => [ 'base' => NULL, 'refs' => [ 'QueryResultColumn$value' => NULL, ], ], 'QueryStatement' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryResponse$QueryString' => '<p>The SQL code of a query.</p>', 'StartQueryRequest$QueryStatement' => '<p>The SQL code of your query.</p>', ], ], 'QueryStatistics' => [ 'base' => '<p>Metadata about a query, such as the number of results.</p>', 'refs' => [ 'GetQueryResultsResponse$QueryStatistics' => '<p>Shows the count of query results.</p>', ], ], 'QueryStatisticsForDescribeQuery' => [ 'base' => '<p>Gets metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query\'s creation time.</p>', 'refs' => [ 'DescribeQueryResponse$QueryStatistics' => '<p>Metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query\'s creation time.</p>', ], ], 'QueryStatus' => [ 'base' => NULL, 'refs' => [ 'CancelQueryResponse$QueryStatus' => '<p>Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either <code>RUNNING</code> or <code>CANCELLED</code>.</p>', 'DescribeQueryResponse$QueryStatus' => '<p>The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> </p>', 'GetQueryResultsResponse$QueryStatus' => '<p>The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>', 'ListQueriesRequest$QueryStatus' => '<p>The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>', 'Query$QueryStatus' => '<p>The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>', ], ], 'ReadWriteType' => [ 'base' => NULL, 'refs' => [ 'EventSelector$ReadWriteType' => '<p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p> <p> By default, the value is <code>All</code>.</p>', ], ], 'RegisterOrganizationDelegatedAdminRequest' => [ 'base' => '<p>Specifies an organization member account ID as a CloudTrail delegated administrator.</p>', 'refs' => [], ], 'RegisterOrganizationDelegatedAdminResponse' => [ 'base' => '<p>Returns the following response if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'RemoveTagsRequest' => [ 'base' => '<p>Specifies the tags to remove from a trail, event data store, or channel.</p>', 'refs' => [], ], 'RemoveTagsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'Resource' => [ 'base' => '<p>Specifies the type and name of a resource referenced by an event.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceARNNotValidException' => [ 'base' => '<p> This exception is thrown when the provided resource does not exist, or the ARN format of the resource is not valid. The following is the valid format for a resource ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>. </p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the CloudTrail channel you\'re deleting the resource-based policy from. The following is the format of a resource ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>. </p>', 'GetResourcePolicyRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the CloudTrail channel attached to the resource-based policy. The following is the format of a resource ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>. </p>', 'GetResourcePolicyResponse$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the CloudTrail channel attached to resource-based policy. </p>', 'PutResourcePolicyRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the CloudTrail channel attached to the resource-based policy. The following is the format of a resource ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>. </p>', 'PutResourcePolicyResponse$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the CloudTrail channel attached to the resource-based policy. </p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$ResourceIdList' => '<p>Specifies a list of trail, event data store, or channel ARNs whose tags will be listed. The list has a limit of 20 ARNs.</p> <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p> <p>Example channel ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code> </p>', ], ], 'ResourceList' => [ 'base' => '<p>A list of resources referenced by the event returned.</p>', 'refs' => [ 'Event$Resources' => '<p>A list of resources referenced by the event returned.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the specified resource is not found.</p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$ResourcePolicy' => '<p> A JSON-formatted string that contains the resource-based policy attached to the CloudTrail channel. </p>', 'PutResourcePolicyRequest$ResourcePolicy' => '<p> A JSON-formatted string for an Amazon Web Services resource-based policy. </p> <p>The following are requirements for the resource policy:</p> <ul> <li> <p> Contains only one action: cloudtrail-data:PutAuditEvents </p> </li> <li> <p> Contains at least one statement. The policy can have a maximum of 20 statements. </p> </li> <li> <p> Each statement contains at least one principal. A statement can have a maximum of 50 principals. </p> </li> </ul>', 'PutResourcePolicyResponse$ResourcePolicy' => '<p> The JSON-formatted string of the Amazon Web Services resource-based policy attached to the CloudTrail channel. </p>', ], ], 'ResourcePolicyNotFoundException' => [ 'base' => '<p> This exception is thrown when the specified resource policy is not found. </p>', 'refs' => [], ], 'ResourcePolicyNotValidException' => [ 'base' => '<p> This exception is thrown when the resouce-based policy has syntax errors, or contains a principal that is not valid. </p> <p>The following are requirements for the resource policy:</p> <ul> <li> <p> Contains only one action: cloudtrail-data:PutAuditEvents </p> </li> <li> <p> Contains at least one statement. The policy can have a maximum of 20 statements. </p> </li> <li> <p> Each statement contains at least one principal. A statement can have a maximum of 50 principals. </p> </li> </ul>', 'refs' => [], ], 'ResourceTag' => [ 'base' => '<p>A resource tag.</p>', 'refs' => [ 'ResourceTagList$member' => NULL, ], ], 'ResourceTagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsResponse$ResourceTagList' => '<p>A list of resource tags.</p>', ], ], 'ResourceTypeNotSupportedException' => [ 'base' => '<p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>', 'refs' => [], ], 'RestoreEventDataStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreEventDataStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetentionPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$RetentionPeriod' => '<p>The retention period of the event data store, in days. If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, you can set a retention period of up to 3653 days, the equivalent of 10 years. If <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>, you can set a retention period of up to 2557 days, the equivalent of seven years.</p> <p>CloudTrail Lake determines whether to retain an event by checking if the <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.</p> <note> <p>If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.</p> </note>', 'CreateEventDataStoreResponse$RetentionPeriod' => '<p>The retention period of an event data store, in days.</p>', 'EventDataStore$RetentionPeriod' => '<p>The retention period, in days.</p>', 'GetEventDataStoreResponse$RetentionPeriod' => '<p>The retention period of the event data store, in days.</p>', 'RestoreEventDataStoreResponse$RetentionPeriod' => '<p>The retention period, in days.</p>', 'UpdateEventDataStoreRequest$RetentionPeriod' => '<p>The retention period of the event data store, in days. If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, you can set a retention period of up to 3653 days, the equivalent of 10 years. If <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>, you can set a retention period of up to 2557 days, the equivalent of seven years.</p> <p>CloudTrail Lake determines whether to retain an event by checking if the <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.</p> <note> <p>If you decrease the retention period of an event data store, CloudTrail will remove any events with an <code>eventTime</code> older than the new retention period. For example, if the previous retention period was 365 days and you decrease it to 100 days, CloudTrail will remove events with an <code>eventTime</code> older than 100 days.</p> </note>', 'UpdateEventDataStoreResponse$RetentionPeriod' => '<p>The retention period, in days.</p>', ], ], 'S3BucketDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified S3 bucket does not exist.</p>', 'refs' => [], ], 'S3ImportSource' => [ 'base' => '<p> The settings for the source S3 bucket. </p>', 'refs' => [ 'ImportSource$S3' => '<p> The source S3 bucket. </p>', ], ], 'SelectorField' => [ 'base' => NULL, 'refs' => [ 'AdvancedFieldSelector$Field' => '<p> A field in a CloudTrail event record on which to filter events to be logged. For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the field is used only for selecting events as filtering is not supported.</p> <p>For CloudTrail management events, supported fields include <code>readOnly</code>, <code>eventCategory</code>, and <code>eventSource</code>.</p> <p>For CloudTrail data events, supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>.</p> <p> For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the only supported field is <code>eventCategory</code>. </p> <ul> <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</p> </li> <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set to <code>NotEquals</code> <code>kms.amazonaws.com</code> or <code>NotEquals</code> <code>rdsdata.amazonaws.com</code>.</p> </li> <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li> <li> <p> <b> <code>eventCategory</code> </b> - This is required and must be set to <code>Equals</code>. </p> <ul> <li> <p> For CloudTrail management events, the value must be <code>Management</code>. </p> </li> <li> <p> For CloudTrail data events, the value must be <code>Data</code>. </p> </li> </ul> <p>The following are used only for event data stores:</p> <ul> <li> <p> For CloudTrail Insights events, the value must be <code>Insight</code>. </p> </li> <li> <p> For Config configuration items, the value must be <code>ConfigurationItem</code>. </p> </li> <li> <p> For Audit Manager evidence, the value must be <code>Evidence</code>. </p> </li> <li> <p> For non-Amazon Web Services events, the value must be <code>ActivityAuditLog</code>. </p> </li> </ul> </li> <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p> <ul> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::S3::Object</code> </p> </li> <li> <p> <code>AWS::AppConfig::Configuration</code> </p> </li> <li> <p> <code>AWS::B2BI::Transformer</code> </p> </li> <li> <p> <code>AWS::Bedrock::AgentAlias</code> </p> </li> <li> <p> <code>AWS::Bedrock::KnowledgeBase</code> </p> </li> <li> <p> <code>AWS::Cassandra::Table</code> </p> </li> <li> <p> <code>AWS::CloudFront::KeyValueStore</code> </p> </li> <li> <p> <code>AWS::CloudTrail::Channel</code> </p> </li> <li> <p> <code>AWS::CodeWhisperer::Customization</code> </p> </li> <li> <p> <code>AWS::CodeWhisperer::Profile</code> </p> </li> <li> <p> <code>AWS::Cognito::IdentityPool</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li> <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li> <li> <p> <code>AWS::EMRWAL::Workspace</code> </p> </li> <li> <p> <code>AWS::FinSpace::Environment</code> </p> </li> <li> <p> <code>AWS::Glue::Table</code> </p> </li> <li> <p> <code>AWS::GreengrassV2::ComponentVersion</code> </p> </li> <li> <p> <code>AWS::GreengrassV2::Deployment</code> </p> </li> <li> <p> <code>AWS::GuardDuty::Detector</code> </p> </li> <li> <p> <code>AWS::IoT::Certificate</code> </p> </li> <li> <p> <code>AWS::IoT::Thing</code> </p> </li> <li> <p> <code>AWS::IoTSiteWise::Asset</code> </p> </li> <li> <p> <code>AWS::IoTSiteWise::TimeSeries</code> </p> </li> <li> <p> <code>AWS::IoTTwinMaker::Entity</code> </p> </li> <li> <p> <code>AWS::IoTTwinMaker::Workspace</code> </p> </li> <li> <p> <code>AWS::KendraRanking::ExecutionPlan</code> </p> </li> <li> <p> <code>AWS::KinesisVideo::Stream</code> </p> </li> <li> <p> <code>AWS::ManagedBlockchain::Network</code> </p> </li> <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li> <li> <p> <code>AWS::MedicalImaging::Datastore</code> </p> </li> <li> <p> <code>AWS::NeptuneGraph::Graph</code> </p> </li> <li> <p> <code>AWS::PCAConnectorAD::Connector</code> </p> </li> <li> <p> <code>AWS::QApps:QApp</code> </p> </li> <li> <p> <code>AWS::QBusiness::Application</code> </p> </li> <li> <p> <code>AWS::QBusiness::DataSource</code> </p> </li> <li> <p> <code>AWS::QBusiness::Index</code> </p> </li> <li> <p> <code>AWS::QBusiness::WebExperience</code> </p> </li> <li> <p> <code>AWS::RDS::DBCluster</code> </p> </li> <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li> <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li> <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li> <li> <p> <code>AWS::SageMaker::Endpoint</code> </p> </li> <li> <p> <code>AWS::SageMaker::ExperimentTrialComponent</code> </p> </li> <li> <p> <code>AWS::SageMaker::FeatureGroup</code> </p> </li> <li> <p> <code>AWS::ServiceDiscovery::Namespace </code> </p> </li> <li> <p> <code>AWS::ServiceDiscovery::Service</code> </p> </li> <li> <p> <code>AWS::SCN::Instance</code> </p> </li> <li> <p> <code>AWS::SNS::PlatformEndpoint</code> </p> </li> <li> <p> <code>AWS::SNS::Topic</code> </p> </li> <li> <p> <code>AWS::SQS::Queue</code> </p> </li> <li> <p> <code>AWS::SSM::ManagedNode</code> </p> </li> <li> <p> <code>AWS::SSMMessages::ControlChannel</code> </p> </li> <li> <p> <code>AWS::SWF::Domain</code> </p> </li> <li> <p> <code>AWS::ThinClient::Device</code> </p> </li> <li> <p> <code>AWS::ThinClient::Environment</code> </p> </li> <li> <p> <code>AWS::Timestream::Database</code> </p> </li> <li> <p> <code>AWS::Timestream::Table</code> </p> </li> <li> <p> <code>AWS::VerifiedPermissions::PolicyStore</code> </p> </li> <li> <p> <code>AWS::XRay::Trace</code> </p> </li> </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li> <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you\'ve speciﬁed in the template as the value of resources.type.</p> <note> <p>You can\'t use the <code>resources.ARN</code> field to filter resource types that do not have ARNs.</p> </note> <p>The <code>resources.ARN</code> field can be set one of the following.</p> <p>If resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code> </p> </li> <li> <p> <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::AppConfig::Configuration</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:appconfig:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_ID&gt;/environment/&lt;environment_ID&gt;/configuration/&lt;configuration_profile_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::B2BI::Transformer</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:b2bi:&lt;region&gt;:&lt;account_ID&gt;:transformer/&lt;transformer_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Bedrock::AgentAlias</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:bedrock:&lt;region&gt;:&lt;account_ID&gt;:agent-alias/&lt;agent_ID&gt;/&lt;alias_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Bedrock::KnowledgeBase</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:bedrock:&lt;region&gt;:&lt;account_ID&gt;:knowledge-base/&lt;knowledge_base_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Cassandra::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:cassandra:&lt;region&gt;:&lt;account_ID&gt;:/keyspace/&lt;keyspace_name&gt;/table/&lt;table_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::CloudFront::KeyValueStore</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:cloudfront:&lt;region&gt;:&lt;account_ID&gt;:key-value-store/&lt;KVS_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::CloudTrail::Channel</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:cloudtrail:&lt;region&gt;:&lt;account_ID&gt;:channel/&lt;channel_UUID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::CodeWhisperer::Customization</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:customization/&lt;customization_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::CodeWhisperer::Profile</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:profile/&lt;profile_ID&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Cognito::IdentityPool</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:cognito-identity:&lt;region&gt;:&lt;account_ID&gt;:identitypool/&lt;identity_pool_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::EMRWAL::Workspace</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:emrwal:&lt;region&gt;:&lt;account_ID&gt;:workspace/&lt;workspace_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::GreengrassV2::ComponentVersion</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:greengrass:&lt;region&gt;:&lt;account_ID&gt;:components/&lt;component_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::GreengrassV2::Deployment</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:greengrass:&lt;region&gt;:&lt;account_ID&gt;:deployments/&lt;deployment_ID</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::GuardDuty::Detector</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:guardduty:&lt;region&gt;:&lt;account_ID&gt;:detector/&lt;detector_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoT::Certificate</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iot:&lt;region&gt;:&lt;account_ID&gt;:cert/&lt;certificate_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoT::Thing</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iot:&lt;region&gt;:&lt;account_ID&gt;:thing/&lt;thing_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoTSiteWise::Asset</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iotsitewise:&lt;region&gt;:&lt;account_ID&gt;:asset/&lt;asset_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoTSiteWise::TimeSeries</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iotsitewise:&lt;region&gt;:&lt;account_ID&gt;:timeseries/&lt;timeseries_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoTTwinMaker::Entity</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iottwinmaker:&lt;region&gt;:&lt;account_ID&gt;:workspace/&lt;workspace_ID&gt;/entity/&lt;entity_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::IoTTwinMaker::Workspace</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:iottwinmaker:&lt;region&gt;:&lt;account_ID&gt;:workspace/&lt;workspace_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::KendraRanking::ExecutionPlan</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:kendra-ranking:&lt;region&gt;:&lt;account_ID&gt;:rescore-execution-plan/&lt;rescore_execution_plan_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::KinesisVideo::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:kinesisvideo:&lt;region&gt;:&lt;account_ID&gt;:stream/&lt;stream_name&gt;/&lt;creation_time&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Network</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:managedblockchain:::networks/&lt;network_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::MedicalImaging::Datastore</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:medical-imaging:&lt;region&gt;:&lt;account_ID&gt;:datastore/&lt;data_store_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::NeptuneGraph::Graph</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:neptune-graph:&lt;region&gt;:&lt;account_ID&gt;:graph/&lt;graph_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::PCAConnectorAD::Connector</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:pca-connector-ad:&lt;region&gt;:&lt;account_ID&gt;:connector/&lt;connector_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::QApps:QApp</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:qapps:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_UUID&gt;/qapp/&lt;qapp_UUID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::QBusiness::Application</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:qbusiness:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::QBusiness::DataSource</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:qbusiness:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_ID&gt;/index/&lt;index_ID&gt;/data-source/&lt;datasource_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::QBusiness::Index</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:qbusiness:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_ID&gt;/index/&lt;index_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::QBusiness::WebExperience</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:qbusiness:&lt;region&gt;:&lt;account_ID&gt;:application/&lt;application_ID&gt;/web-experience/&lt;web_experience_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::RDS::DBCluster</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:rds:&lt;region&gt;:&lt;account_ID&gt;:cluster/&lt;cluster_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code> </p> </li> <li> <p> <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SageMaker::Endpoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:endpoint/&lt;endpoint_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SCN::Instance</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:scn:&lt;region&gt;:&lt;account_ID&gt;:instance/&lt;instance_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ServiceDiscovery::Namespace</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:servicediscovery:&lt;region&gt;:&lt;account_ID&gt;:namespace/&lt;namespace_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ServiceDiscovery::Service</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:servicediscovery:&lt;region&gt;:&lt;account_ID&gt;:service/&lt;service_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SNS::PlatformEndpoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sns:&lt;region&gt;:&lt;account_ID&gt;:endpoint/&lt;endpoint_type&gt;/&lt;endpoint_name&gt;/&lt;endpoint_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SNS::Topic</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sns:&lt;region&gt;:&lt;account_ID&gt;:&lt;topic_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SQS::Queue</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:sqs:&lt;region&gt;:&lt;account_ID&gt;:&lt;queue_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SSM::ManagedNode</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:ssm:&lt;region&gt;:&lt;account_ID&gt;:managed-instance/&lt;instance_ID&gt;</code> </p> </li> <li> <p> <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;:&lt;account_ID&gt;:instance/&lt;instance_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SSMMessages::ControlChannel</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:ssmmessages:&lt;region&gt;:&lt;account_ID&gt;:control-channel/&lt;channel_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::SWF::Domain</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:swf:&lt;region&gt;:&lt;account_ID&gt;:domain/&lt;domain_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ThinClient::Device</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:thinclient:&lt;region&gt;:&lt;account_ID&gt;:device/&lt;device_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ThinClient::Environment</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:thinclient:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::Timestream::Database</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:timestream:&lt;region&gt;:&lt;account_ID&gt;:database/&lt;database_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::Timestream::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:timestream:&lt;region&gt;:&lt;account_ID&gt;:database/&lt;database_name&gt;/table/&lt;table_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::VerifiedPermissions::PolicyStore</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:verifiedpermissions:&lt;region&gt;:&lt;account_ID&gt;:policy-store/&lt;policy_store_UUID&gt;</code> </p> </li> </ul> </li> </ul>', ], ], 'SelectorName' => [ 'base' => NULL, 'refs' => [ 'AdvancedEventSelector$Name' => '<p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>', ], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$Source' => '<p>The name of the partner or external event source. You cannot change this name after you create the channel. A maximum of one channel is allowed per source.</p> <p> A source can be either <code>Custom</code> for all valid non-Amazon Web Services events, or the name of a partner event source. For information about the source names for available partners, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store-integration.html#cloudtrail-lake-partner-information">Additional information about integration partners</a> in the CloudTrail User Guide. </p>', 'CreateChannelResponse$Source' => '<p>The partner or external event source name.</p>', 'GetChannelResponse$Source' => '<p>The source for the CloudTrail channel.</p>', 'UpdateChannelResponse$Source' => '<p>The event source of the channel that was updated.</p>', ], ], 'SourceConfig' => [ 'base' => '<p> Contains configuration information about the channel. </p>', 'refs' => [ 'GetChannelResponse$SourceConfig' => '<p> Provides information about the advanced event selectors configured for the channel, and whether the channel applies to all Regions or a single Region. </p>', ], ], 'StartEventDataStoreIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartEventDataStoreIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartLoggingRequest' => [ 'base' => '<p>The request to CloudTrail to start logging Amazon Web Services API calls for an account.</p>', 'refs' => [], ], 'StartLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'StartQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopEventDataStoreIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEventDataStoreIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopLoggingRequest' => [ 'base' => '<p>Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.</p>', 'refs' => [], ], 'StopLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail, event data store, or channel to which one or more tags will be added.</p> <p>The format of a trail ARN is: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>The format of an event data store ARN is: <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p> <p>The format of a channel ARN is: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code> </p>', 'CreateTrailRequest$Name' => '<p>Specifies the name of the trail. The name must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul>', 'CreateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. For information about bucket naming rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html">Bucket naming rules</a> in the <i>Amazon Simple Storage Service User Guide</i>. </p>', 'CreateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'CreateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'CreateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. You must use a log group that exists in your account.</p> <p>Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>', 'CreateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group. You must use a role that exists in your account.</p>', 'CreateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p> <code>alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code> </p> </li> <li> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p> </li> <li> <p> <code>12345678-1234-1234-1234-123456789012</code> </p> </li> </ul>', 'CreateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'CreateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'CreateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your CloudTrail Log Files</a>.</p>', 'CreateTrailResponse$SnsTopicName' => '<p>This field is no longer in use. Use <code>SnsTopicARN</code>.</p>', 'CreateTrailResponse$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'CreateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'CreateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>', 'CreateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'CreateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'DataResource$Type' => '<p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p> <ul> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::S3::Object</code> </p> </li> </ul> <p>Additional resource types are available through <i>advanced</i> event selectors. For more information about these additional resource types, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html">AdvancedFieldSelector</a>.</p>', 'DataResourceValues$member' => NULL, 'DeleteTrailRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Event$EventId' => '<p>The CloudTrail ID of the event returned.</p>', 'Event$EventName' => '<p>The name of the event returned.</p>', 'Event$ReadOnly' => '<p>Information about whether the event is a write event or a read event. </p>', 'Event$AccessKeyId' => '<p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>', 'Event$EventSource' => '<p>The Amazon Web Services service to which the request was made.</p>', 'Event$Username' => '<p>A user name or role name of the requester that called the API in the event returned.</p>', 'Event$CloudTrailEvent' => '<p>A JSON string that contains a representation of the event returned.</p>', 'ExcludeManagementEventSources$member' => NULL, 'GetEventSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the format:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'GetEventSelectorsResponse$TrailARN' => '<p>The specified trail ARN that has the event selectors.</p>', 'GetInsightSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the format:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>You cannot use this parameter with the <code>EventDataStore</code> parameter.</p>', 'GetInsightSelectorsResponse$TrailARN' => '<p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>', 'GetTrailRequest$Name' => '<p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>', 'GetTrailStatusRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another Region), you must specify its ARN. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'GetTrailStatusResponse$LatestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note> <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, fix the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create-s3-bucket-policy-for-cloudtrail.html">bucket policy</a> so that CloudTrail can write to the bucket; or create a new bucket and call <code>UpdateTrail</code> to specify the new bucket.</p> </note>', 'GetTrailStatusResponse$LatestNotificationError' => '<p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryError' => '<p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note> <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, fix the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create-s3-bucket-policy-for-cloudtrail.html">bucket policy</a> so that CloudTrail can write to the bucket; or create a new bucket and call <code>UpdateTrail</code> to specify the new bucket.</p> </note>', 'GetTrailStatusResponse$LatestDeliveryAttemptTime' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptTime' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptSucceeded' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestDeliveryAttemptSucceeded' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$TimeLoggingStarted' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$TimeLoggingStopped' => '<p>This field is no longer in use.</p>', 'ImportFailureListItem$Location' => '<p> The location of the failure in the S3 bucket. </p>', 'ImportFailureListItem$ErrorType' => '<p> The type of import error. </p>', 'ImportFailureListItem$ErrorMessage' => '<p> Provides the reason the import failed. </p>', 'ListPublicKeysRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListPublicKeysResponse$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsResponse$NextToken' => '<p>Reserved for future use.</p>', 'ListTrailsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'ListTrailsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'PublicKey$Fingerprint' => '<p>The fingerprint of the public key.</p>', 'PutEventSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the following format.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'PutEventSelectorsResponse$TrailARN' => '<p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'PutInsightSelectorsRequest$TrailName' => '<p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p> <p>You cannot use this parameter with the <code>EventDataStore</code> and <code>InsightsDestination</code> parameters.</p>', 'PutInsightSelectorsResponse$TrailARN' => '<p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>', 'RemoveTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail, event data store, or channel from which tags should be removed.</p> <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p> <p>Example channel ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code> </p>', 'Resource$ResourceType' => '<p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>', 'Resource$ResourceName' => '<p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>', 'ResourceIdList$member' => NULL, 'ResourceTag$ResourceId' => '<p>Specifies the ARN of the resource.</p>', 'S3ImportSource$S3LocationUri' => '<p> The URI for the source S3 bucket. </p>', 'S3ImportSource$S3BucketRegion' => '<p> The Region associated with the source S3 bucket. </p>', 'S3ImportSource$S3BucketAccessRoleArn' => '<p> The IAM ARN role used to access the source S3 bucket. </p>', 'StartLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'StopLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Trail$Name' => '<p>Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.</p>', 'Trail$S3BucketName' => '<p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html">Amazon S3 Bucket naming rules</a>.</p>', 'Trail$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'Trail$SnsTopicName' => '<p>This field is no longer in use. Use <code>SnsTopicARN</code>.</p>', 'Trail$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'Trail$HomeRegion' => '<p>The Region in which the trail was created.</p>', 'Trail$TrailARN' => '<p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Trail$CloudWatchLogsLogGroupArn' => '<p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>', 'Trail$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'Trail$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'TrailInfo$TrailARN' => '<p>The ARN of a trail.</p>', 'TrailInfo$Name' => '<p>The name of a trail.</p>', 'TrailInfo$HomeRegion' => '<p>The Amazon Web Services Region in which a trail was created.</p>', 'TrailNameList$member' => NULL, 'UpdateTrailRequest$Name' => '<p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'UpdateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html">Amazon S3 Bucket naming rules</a>.</p>', 'UpdateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'UpdateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'UpdateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. You must use a log group that exists in your account.</p> <p>Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>', 'UpdateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group. You must use a role that exists in your account.</p>', 'UpdateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p>alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'UpdateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'UpdateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'UpdateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your IAM Log Files</a>.</p>', 'UpdateTrailResponse$SnsTopicName' => '<p>This field is no longer in use. Use <code>SnsTopicARN</code>.</p>', 'UpdateTrailResponse$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'UpdateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'UpdateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>', 'UpdateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'UpdateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', ], ], 'Tag' => [ 'base' => '<p>A custom key-value pair associated with a resource such as a CloudTrail trail, event data store, or channel.</p>', 'refs' => [ 'TagsList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>', ], ], 'TagsLimitExceededException' => [ 'base' => '<p>The number of tags per trail, event data store, or channel has exceeded the permitted amount. Currently, the limit is 50.</p>', 'refs' => [], ], 'TagsList' => [ 'base' => '<p>A list of tags.</p>', 'refs' => [ 'AddTagsRequest$TagsList' => '<p>Contains a list of tags, up to a limit of 50</p>', 'CreateChannelRequest$Tags' => NULL, 'CreateChannelResponse$Tags' => NULL, 'CreateEventDataStoreRequest$TagsList' => NULL, 'CreateEventDataStoreResponse$TagsList' => NULL, 'CreateTrailRequest$TagsList' => NULL, 'RemoveTagsRequest$TagsList' => '<p>Specifies a list of tags to be removed.</p>', 'ResourceTag$TagsList' => '<p>A list of tags.</p>', ], ], 'TerminationProtectionEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateEventDataStoreRequest$TerminationProtectionEnabled' => '<p>Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.</p>', 'CreateEventDataStoreResponse$TerminationProtectionEnabled' => '<p>Indicates whether termination protection is enabled for the event data store.</p>', 'EventDataStore$TerminationProtectionEnabled' => '<p>Indicates whether the event data store is protected from termination.</p>', 'GetEventDataStoreResponse$TerminationProtectionEnabled' => '<p>Indicates that termination protection is enabled.</p>', 'RestoreEventDataStoreResponse$TerminationProtectionEnabled' => '<p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>', 'UpdateEventDataStoreRequest$TerminationProtectionEnabled' => '<p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>', 'UpdateEventDataStoreResponse$TerminationProtectionEnabled' => '<p>Indicates whether termination protection is enabled for the event data store.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p> This exception is thrown when the request rate exceeds the limit. </p>', 'refs' => [], ], 'Timestamps' => [ 'base' => NULL, 'refs' => [ 'ListInsightsMetricDataResponse$Timestamps' => '<p>List of timestamps at intervals corresponding to the specified time period.</p>', ], ], 'Trail' => [ 'base' => '<p>The settings for a trail.</p>', 'refs' => [ 'GetTrailResponse$Trail' => NULL, 'TrailList$member' => NULL, ], ], 'TrailAlreadyExistsException' => [ 'base' => '<p>This exception is thrown when the specified trail already exists.</p>', 'refs' => [], ], 'TrailInfo' => [ 'base' => '<p>Information about a CloudTrail trail, including the trail\'s name, home Region, and Amazon Resource Name (ARN).</p>', 'refs' => [ 'Trails$member' => NULL, ], ], 'TrailList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsResponse$trailList' => '<p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail\'s configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail\'s log files are encrypted with KMS customer managed keys.</p>', ], ], 'TrailNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsRequest$trailNameList' => '<p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>If an empty list is specified, information for the trail in the current Region is returned.</p> <ul> <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current Region is returned.</p> </li> <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current Region and any associated shadow trails in other Regions is returned.</p> </li> </ul> <note> <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current Region and current account. To return information about a trail in another Region, you must specify its trail ARN.</p> </note>', ], ], 'TrailNotFoundException' => [ 'base' => '<p>This exception is thrown when the trail with the given name is not found.</p>', 'refs' => [], ], 'TrailNotProvidedException' => [ 'base' => '<p>This exception is no longer in use.</p>', 'refs' => [], ], 'Trails' => [ 'base' => NULL, 'refs' => [ 'ListTrailsResponse$Trails' => '<p>Returns the name, ARN, and home Region of trails in the current account.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CancelQueryRequest$QueryId' => '<p>The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a <code>StartQuery</code> operation.</p>', 'CancelQueryResponse$QueryId' => '<p>The ID of the canceled query.</p>', 'DescribeQueryRequest$QueryId' => '<p>The query ID.</p>', 'DescribeQueryResponse$QueryId' => '<p>The ID of the query.</p>', 'GetImportRequest$ImportId' => '<p> The ID for the import. </p>', 'GetImportResponse$ImportId' => '<p> The ID of the import. </p>', 'GetQueryResultsRequest$QueryId' => '<p>The ID of the query for which you want to get results.</p>', 'ImportsListItem$ImportId' => '<p> The ID of the import. </p>', 'IngestionStatus$LatestIngestionSuccessEventID' => '<p>The event ID of the most recent successful ingestion of events.</p>', 'IngestionStatus$LatestIngestionAttemptEventID' => '<p>The event ID of the most recent attempt to ingest events.</p>', 'ListImportFailuresRequest$ImportId' => '<p> The ID of the import. </p>', 'Query$QueryId' => '<p>The ID of a query.</p>', 'StartImportRequest$ImportId' => '<p> The ID of the import. Use this parameter when you are retrying an import. </p>', 'StartImportResponse$ImportId' => '<p> The ID of the import. </p>', 'StartQueryResponse$QueryId' => '<p>The ID of the started query.</p>', 'StopImportRequest$ImportId' => '<p> The ID of the import. </p>', 'StopImportResponse$ImportId' => '<p> The ID for the import. </p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>This exception is thrown when the requested operation is not supported.</p>', 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDataStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDataStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrailRequest' => [ 'base' => '<p>Specifies settings to update for the trail.</p>', 'refs' => [], ], 'UpdateTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], ],];
