<?php
// This file was auto-generated from sdk-root/src/data/codedeploy/2014-10-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances, on-premises instances running in your own facility, serverless Lambda functions, or applications in an Amazon ECS service.</p> <p>You can deploy a nearly unlimited variety of application content, such as an updated Lambda function, updated applications in an Amazon ECS service, code, web and configuration files, executables, packages, scripts, multimedia files, and so on. CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing code before you can use CodeDeploy.</p> <p>CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application deployment, and handles the complexity of updating your applications, without many of the risks associated with error-prone manual deployments.</p> <p> <b>CodeDeploy Components</b> </p> <p>Use the information in this guide to help you work with the following CodeDeploy components:</p> <ul> <li> <p> <b>Application</b>: A name that uniquely identifies the application you want to deploy. CodeDeploy uses this name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and deployment group are referenced during a deployment.</p> </li> <li> <p> <b>Deployment group</b>: A set of individual instances, CodeDeploy Lambda deployment configuration settings, or an Amazon ECS service and network details. A Lambda deployment group specifies how to route traffic to a new version of a Lambda function. An Amazon ECS deployment group specifies the service created in Amazon ECS to deploy, a load balancer, and a listener to reroute production traffic to an updated containerized application. An Amazon EC2/On-premises deployment group contains individually tagged instances, Amazon EC2 instances in Amazon EC2 Auto Scaling groups, or both. All deployment groups can specify optional trigger, alarm, and rollback settings.</p> </li> <li> <p> <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by CodeDeploy during a deployment.</p> </li> <li> <p> <b>Deployment</b>: The process and the components used when updating a Lambda function, a containerized application in an Amazon ECS service, or of installing content on one or more instances. </p> </li> <li> <p> <b>Application revisions</b>: For an Lambda deployment, this is an AppSpec file that specifies the Lambda function to be updated and one or more functions to validate deployment lifecycle events. For an Amazon ECS deployment, this is an AppSpec file that specifies the Amazon ECS task definition, container, and port where production traffic is rerouted. For an EC2/On-premises deployment, this is an archive file that contains source content—source code, webpages, executable files, and deployment scripts—along with an AppSpec file. Revisions are stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.</p> </li> </ul> <p>This guide also contains information to help you get details about the instances in your deployments, to make on-premises instances available for CodeDeploy deployments, to get details about a Lambda function deployment, and to get details about Amazon ECS service deployments.</p> <p> <b>CodeDeploy Information Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User Guide</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/">CodeDeploy API Reference Guide</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">CLI Reference for CodeDeploy</a> </p> </li> <li> <p> <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">CodeDeploy Developer Forum</a> </p> </li> </ul>', 'operations' => [ 'AddTagsToOnPremisesInstances' => '<p>Adds tags to on-premises instances.</p>', 'BatchGetApplicationRevisions' => '<p>Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.</p>', 'BatchGetApplications' => '<p>Gets information about one or more applications. The maximum number of applications that can be returned is 100.</p>', 'BatchGetDeploymentGroups' => '<p>Gets information about one or more deployment groups.</p>', 'BatchGetDeploymentInstances' => '<note> <p> This method works, but is deprecated. Use <code>BatchGetDeploymentTargets</code> instead. </p> </note> <p> Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and Lambda compute platforms. The newer <code>BatchGetDeploymentTargets</code> works with all compute platforms. The maximum number of instances that can be returned is 25.</p>', 'BatchGetDeploymentTargets' => '<p> Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated <code>BatchGetDeploymentInstances</code>. The maximum number of targets that can be returned is 25.</p> <p> The type of targets returned depends on the deployment\'s compute platform or deployment method: </p> <ul> <li> <p> <b>EC2/On-premises</b>: Information about Amazon EC2 instance targets. </p> </li> <li> <p> <b>Lambda</b>: Information about Lambda functions targets. </p> </li> <li> <p> <b>Amazon ECS</b>: Information about Amazon ECS service targets. </p> </li> <li> <p> <b>CloudFormation</b>: Information about targets of blue/green deployments initiated by a CloudFormation stack update.</p> </li> </ul>', 'BatchGetDeployments' => '<p>Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.</p>', 'BatchGetOnPremisesInstances' => '<p>Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.</p>', 'ContinueDeployment' => '<p>For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.) </p>', 'CreateApplication' => '<p>Creates an application.</p>', 'CreateDeployment' => '<p>Deploys an application revision through the specified deployment group.</p>', 'CreateDeploymentConfig' => '<p> Creates a deployment configuration. </p>', 'CreateDeploymentGroup' => '<p>Creates a deployment group to which application revisions are deployed.</p>', 'DeleteApplication' => '<p>Deletes an application.</p>', 'DeleteDeploymentConfig' => '<p>Deletes a deployment configuration.</p> <note> <p>A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.</p> </note>', 'DeleteDeploymentGroup' => '<p>Deletes a deployment group.</p>', 'DeleteGitHubAccountToken' => '<p>Deletes a GitHub account connection.</p>', 'DeleteResourcesByExternalId' => '<p>Deletes resources linked to an external ID. This action only applies if you have configured blue/green deployments through CloudFormation. </p> <note> <p>It is not necessary to call this action directly. CloudFormation calls it on your behalf when it needs to delete stack resources. This action is offered publicly in case you need to delete resources to comply with General Data Protection Regulation (GDPR) requirements.</p> </note>', 'DeregisterOnPremisesInstance' => '<p>Deregisters an on-premises instance.</p>', 'GetApplication' => '<p>Gets information about an application.</p>', 'GetApplicationRevision' => '<p>Gets information about an application revision.</p>', 'GetDeployment' => '<p>Gets information about a deployment.</p> <note> <p> The <code>content</code> property of the <code>appSpecContent</code> object in the returned revision is always null. Use <code>GetApplicationRevision</code> and the <code>sha256</code> property of the returned <code>appSpecContent</code> object to get the content of the deployment’s AppSpec file. </p> </note>', 'GetDeploymentConfig' => '<p>Gets information about a deployment configuration.</p>', 'GetDeploymentGroup' => '<p>Gets information about a deployment group.</p>', 'GetDeploymentInstance' => '<p>Gets information about an instance as part of a deployment.</p>', 'GetDeploymentTarget' => '<p> Returns information about a deployment target. </p>', 'GetOnPremisesInstance' => '<p> Gets information about an on-premises instance. </p>', 'ListApplicationRevisions' => '<p>Lists information about revisions for an application.</p>', 'ListApplications' => '<p>Lists the applications registered with the user or Amazon Web Services account.</p>', 'ListDeploymentConfigs' => '<p>Lists the deployment configurations with the user or Amazon Web Services account.</p>', 'ListDeploymentGroups' => '<p>Lists the deployment groups for an application registered with the Amazon Web Services user or Amazon Web Services account.</p>', 'ListDeploymentInstances' => '<note> <p> The newer <code>BatchGetDeploymentTargets</code> should be used instead because it works with all compute types. <code>ListDeploymentInstances</code> throws an exception if it is used with a compute platform other than EC2/On-premises or Lambda. </p> </note> <p> Lists the instance for a deployment associated with the user or Amazon Web Services account. </p>', 'ListDeploymentTargets' => '<p> Returns an array of target IDs that are associated a deployment. </p>', 'ListDeployments' => '<p>Lists the deployments in a deployment group for an application registered with the user or Amazon Web Services account.</p>', 'ListGitHubAccountTokenNames' => '<p>Lists the names of stored connections to GitHub accounts.</p>', 'ListOnPremisesInstances' => '<p>Gets a list of names for one or more on-premises instances.</p> <p>Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.</p>', 'ListTagsForResource' => '<p> Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources. </p>', 'PutLifecycleEventHookExecutionStatus' => '<p> Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are <code>BeforeAllowTraffic</code> and <code>AfterAllowTraffic</code>. For Amazon ECS deployments, the available lifecycle hooks are <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>AfterAllowTestTraffic</code>, <code>BeforeAllowTraffic</code>, and <code>AfterAllowTraffic</code>. Lambda validation functions return <code>Succeeded</code> or <code>Failed</code>. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda">AppSpec \'hooks\' Section for an Lambda Deployment </a> and <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs">AppSpec \'hooks\' Section for an Amazon ECS Deployment</a>.</p>', 'RegisterApplicationRevision' => '<p>Registers with CodeDeploy a revision for the specified application.</p>', 'RegisterOnPremisesInstance' => '<p>Registers an on-premises instance.</p> <note> <p>Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.</p> </note>', 'RemoveTagsFromOnPremisesInstances' => '<p>Removes one or more tags from one or more on-premises instances.</p>', 'SkipWaitTimeForInstanceTermination' => '<p>In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.</p>', 'StopDeployment' => '<p>Attempts to stop an ongoing deployment.</p>', 'TagResource' => '<p> Associates the list of tags in the input <code>Tags</code> parameter with the resource identified by the <code>ResourceArn</code> input parameter. </p>', 'UntagResource' => '<p> Disassociates a resource from a list of tags. The resource is identified by the <code>ResourceArn</code> input parameter. The tags are identified by the list of keys in the <code>TagKeys</code> input parameter. </p>', 'UpdateApplication' => '<p>Changes the name of an application.</p>', 'UpdateDeploymentGroup' => '<p>Changes information about a deployment group.</p>', ], 'shapes' => [ 'AddTagsToOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of, and adds tags to, an on-premises instance operation.</p>', 'refs' => [], ], 'AdditionalDeploymentStatusInfo' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$additionalDeploymentStatusInfo' => '<p>Provides information about the results of a deployment, such as whether instances in the original environment in a blue/green deployment were not terminated.</p>', ], ], 'Alarm' => [ 'base' => '<p>Information about an alarm.</p>', 'refs' => [ 'AlarmList$member' => NULL, ], ], 'AlarmConfiguration' => [ 'base' => '<p>Information about alarms associated with a deployment or deployment group.</p>', 'refs' => [ 'CreateDeploymentGroupInput$alarmConfiguration' => '<p>Information to add about Amazon CloudWatch alarms when the deployment group is created.</p>', 'CreateDeploymentInput$overrideAlarmConfiguration' => '<p>Allows you to specify information about alarms associated with a deployment. The alarm configuration that you specify here will override the alarm configuration at the deployment group level. Consider overriding the alarm configuration if you have set up alarms at the deployment group level that are causing deployment failures. In this case, you would call <code>CreateDeployment</code> to create a new deployment that uses a previous application revision that is known to work, and set its alarm configuration to turn off alarm polling. Turning off alarm polling ensures that the new deployment proceeds without being blocked by the alarm that was generated by the previous, failed, deployment.</p> <note> <p>If you specify an <code>overrideAlarmConfiguration</code>, you need the <code>UpdateDeploymentGroup</code> IAM permission when calling <code>CreateDeployment</code>.</p> </note>', 'DeploymentGroupInfo$alarmConfiguration' => '<p>A list of alarms associated with the deployment group.</p>', 'DeploymentInfo$overrideAlarmConfiguration' => NULL, 'UpdateDeploymentGroupInput$alarmConfiguration' => '<p>Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.</p>', ], ], 'AlarmList' => [ 'base' => NULL, 'refs' => [ 'AlarmConfiguration$alarms' => '<p>A list of alarms configured for the deployment or deployment group. A maximum of 10 alarms can be added.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'Alarm$name' => '<p>The name of the alarm. Maximum length is 255 characters. Each alarm name can be used only once in a list of alarms.</p>', ], ], 'AlarmsLimitExceededException' => [ 'base' => '<p>The maximum number of alarms for a deployment group (10) was exceeded.</p>', 'refs' => [], ], 'AppSpecContent' => [ 'base' => '<p> A revision for an Lambda or Amazon ECS deployment that is a YAML-formatted or JSON-formatted string. For Lambda and Amazon ECS deployments, the revision is the same as the AppSpec file. This method replaces the deprecated <code>RawString</code> data type. </p>', 'refs' => [ 'RevisionLocation$appSpecContent' => '<p> The content of an AppSpec file for an Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML and stored as a RawString. </p>', ], ], 'ApplicationAlreadyExistsException' => [ 'base' => '<p>An application with the specified name with the user or Amazon Web Services account already exists.</p>', 'refs' => [], ], 'ApplicationDoesNotExistException' => [ 'base' => '<p>The application does not exist with the user or Amazon Web Services account.</p>', 'refs' => [], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$applicationId' => '<p>The application ID.</p>', 'CreateApplicationOutput$applicationId' => '<p>A unique application ID.</p>', ], ], 'ApplicationInfo' => [ 'base' => '<p>Information about an application.</p>', 'refs' => [ 'ApplicationsInfoList$member' => NULL, 'GetApplicationOutput$application' => '<p>Information about the application.</p>', ], ], 'ApplicationLimitExceededException' => [ 'base' => '<p>More applications were attempted to be created than are allowed.</p>', 'refs' => [], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$applicationName' => '<p>The application name.</p>', 'ApplicationsList$member' => NULL, 'BatchGetApplicationRevisionsInput$applicationName' => '<p>The name of an CodeDeploy application about which to get revision information.</p>', 'BatchGetApplicationRevisionsOutput$applicationName' => '<p>The name of the application that corresponds to the revisions.</p>', 'BatchGetDeploymentGroupsInput$applicationName' => '<p>The name of an CodeDeploy application associated with the applicable user or Amazon Web Services account.</p>', 'CreateApplicationInput$applicationName' => '<p>The name of the application. This name must be unique with the applicable user or Amazon Web Services account.</p>', 'CreateDeploymentGroupInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'CreateDeploymentInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'DeleteApplicationInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'DeleteDeploymentGroupInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'DeploymentGroupInfo$applicationName' => '<p>The application name.</p>', 'DeploymentInfo$applicationName' => '<p>The application name.</p>', 'GetApplicationInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'GetApplicationRevisionInput$applicationName' => '<p>The name of the application that corresponds to the revision.</p>', 'GetApplicationRevisionOutput$applicationName' => '<p>The name of the application that corresponds to the revision.</p>', 'GetDeploymentGroupInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'ListApplicationRevisionsInput$applicationName' => '<p> The name of an CodeDeploy application associated with the user or Amazon Web Services account. </p>', 'ListDeploymentGroupsInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'ListDeploymentGroupsOutput$applicationName' => '<p>The application name.</p>', 'ListDeploymentsInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p> <note> <p>If <code>applicationName</code> is specified, then <code>deploymentGroupName</code> must be specified. If it is not specified, then <code>deploymentGroupName</code> must not be specified. </p> </note>', 'RegisterApplicationRevisionInput$applicationName' => '<p>The name of an CodeDeploy application associated with the user or Amazon Web Services account.</p>', 'UpdateApplicationInput$applicationName' => '<p>The current name of the application you want to change.</p>', 'UpdateApplicationInput$newApplicationName' => '<p>The new name to give the application.</p>', 'UpdateDeploymentGroupInput$applicationName' => '<p>The application name that corresponds to the deployment group to update.</p>', ], ], 'ApplicationNameRequiredException' => [ 'base' => '<p>The minimum number of required application names was not specified.</p>', 'refs' => [], ], 'ApplicationRevisionSortBy' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$sortBy' => '<p>The column name to use to sort the list results:</p> <ul> <li> <p> <code>registerTime</code>: Sort by the time the revisions were registered with CodeDeploy.</p> </li> <li> <p> <code>firstUsedTime</code>: Sort by the time the revisions were first used in a deployment.</p> </li> <li> <p> <code>lastUsedTime</code>: Sort by the time the revisions were last used in a deployment.</p> </li> </ul> <p> If not specified or set to null, the results are returned in an arbitrary order. </p>', ], ], 'ApplicationsInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationsOutput$applicationsInfo' => '<p>Information about the applications.</p>', ], ], 'ApplicationsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationsInput$applicationNames' => '<p>A list of application names separated by spaces. The maximum number of application names you can specify is 100.</p>', 'ListApplicationsOutput$applications' => '<p>A list of application names.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceArn' => '<p> The ARN of a CodeDeploy resource. <code>ListTagsForResource</code> returns all the tags associated with the resource that is identified by the <code>ResourceArn</code>. </p>', 'TagResourceInput$ResourceArn' => '<p> The ARN of a resource, such as a CodeDeploy application or deployment group. </p>', 'UntagResourceInput$ResourceArn' => '<p> The Amazon Resource Name (ARN) that specifies from which resource to disassociate the tags with the keys in the <code>TagKeys</code> input parameter. </p>', ], ], 'ArnNotSupportedException' => [ 'base' => '<p> The specified ARN is not supported. For example, it might be an ARN for a resource that is not expected. </p>', 'refs' => [], ], 'AutoRollbackConfiguration' => [ 'base' => '<p>Information about a configuration for automatically rolling back to a previous version of an application revision when a deployment is not completed successfully.</p>', 'refs' => [ 'CreateDeploymentGroupInput$autoRollbackConfiguration' => '<p>Configuration information for an automatic rollback that is added when a deployment group is created.</p>', 'CreateDeploymentInput$autoRollbackConfiguration' => '<p>Configuration information for an automatic rollback that is added when a deployment is created.</p>', 'DeploymentGroupInfo$autoRollbackConfiguration' => '<p>Information about the automatic rollback configuration associated with the deployment group.</p>', 'DeploymentInfo$autoRollbackConfiguration' => '<p>Information about the automatic rollback configuration associated with the deployment.</p>', 'UpdateDeploymentGroupInput$autoRollbackConfiguration' => '<p>Information for an automatic rollback configuration that is added or changed when a deployment group is updated.</p>', ], ], 'AutoRollbackEvent' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackEventsList$member' => NULL, ], ], 'AutoRollbackEventsList' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackConfiguration$events' => '<p>The event type or types that trigger a rollback.</p>', ], ], 'AutoScalingGroup' => [ 'base' => '<p>Information about an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupList$member' => NULL, ], ], 'AutoScalingGroupHook' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$hook' => '<p>The name of the launch hook that CodeDeploy installed into the Auto Scaling group.</p> <p>For more information about the launch hook, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors">How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.</p>', 'AutoScalingGroup$terminationHook' => '<p>The name of the termination hook that CodeDeploy installed into the Auto Scaling group.</p> <p>For more information about the termination hook, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable">Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User Guide</i>.</p>', ], ], 'AutoScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'DeleteDeploymentGroupOutput$hooksNotCleanedUp' => '<p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group. If the output contains data, CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances in the Auto Scaling group.</p>', 'DeploymentGroupInfo$autoScalingGroups' => '<p>A list of associated Auto Scaling groups.</p>', 'UpdateDeploymentGroupOutput$hooksNotCleanedUp' => '<p>If the output contains no data, and the corresponding deployment group contained at least one Auto Scaling group, CodeDeploy successfully removed all corresponding Auto Scaling lifecycle event hooks from the Amazon Web Services account. If the output contains data, CodeDeploy could not remove some Auto Scaling lifecycle event hooks from the Amazon Web Services account.</p>', ], ], 'AutoScalingGroupName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$name' => '<p>The Auto Scaling group name.</p>', 'AutoScalingGroupNameList$member' => NULL, ], ], 'AutoScalingGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$autoScalingGroups' => '<p>A list of associated Amazon EC2 Auto Scaling groups.</p>', 'TargetInstances$autoScalingGroups' => '<p>The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.</p>', 'UpdateDeploymentGroupInput$autoScalingGroups' => '<p>The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.</p> <ul> <li> <p>To keep the Auto Scaling groups, enter their names or do not specify this parameter. </p> </li> <li> <p>To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat">Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error "Heartbeat Timeout"</a> in the <i>CodeDeploy User Guide</i>.</p> </li> </ul>', ], ], 'BatchGetApplicationRevisionsInput' => [ 'base' => '<p>Represents the input of a <code>BatchGetApplicationRevisions</code> operation.</p>', 'refs' => [], ], 'BatchGetApplicationRevisionsOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetApplicationRevisions</code> operation.</p>', 'refs' => [], ], 'BatchGetApplicationsInput' => [ 'base' => '<p>Represents the input of a <code>BatchGetApplications</code> operation.</p>', 'refs' => [], ], 'BatchGetApplicationsOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetApplications</code> operation.</p>', 'refs' => [], ], 'BatchGetDeploymentGroupsInput' => [ 'base' => '<p>Represents the input of a <code>BatchGetDeploymentGroups</code> operation.</p>', 'refs' => [], ], 'BatchGetDeploymentGroupsOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetDeploymentGroups</code> operation.</p>', 'refs' => [], ], 'BatchGetDeploymentInstancesInput' => [ 'base' => '<p> Represents the input of a <code>BatchGetDeploymentInstances</code> operation. </p>', 'refs' => [], ], 'BatchGetDeploymentInstancesOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetDeploymentInstances</code> operation.</p>', 'refs' => [], ], 'BatchGetDeploymentTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDeploymentTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDeploymentsInput' => [ 'base' => '<p> Represents the input of a <code>BatchGetDeployments</code> operation. </p>', 'refs' => [], ], 'BatchGetDeploymentsOutput' => [ 'base' => '<p> Represents the output of a <code>BatchGetDeployments</code> operation. </p>', 'refs' => [], ], 'BatchGetOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a <code>BatchGetOnPremisesInstances</code> operation.</p>', 'refs' => [], ], 'BatchGetOnPremisesInstancesOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetOnPremisesInstances</code> operation.</p>', 'refs' => [], ], 'BatchLimitExceededException' => [ 'base' => '<p>The maximum number of names or IDs allowed for this request (100) was exceeded.</p>', 'refs' => [], ], 'BlueGreenDeploymentConfiguration' => [ 'base' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'refs' => [ 'CreateDeploymentGroupInput$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'DeploymentGroupInfo$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', 'DeploymentInfo$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for this deployment.</p>', 'UpdateDeploymentGroupInput$blueGreenDeploymentConfiguration' => '<p>Information about blue/green deployment options for a deployment group.</p>', ], ], 'BlueInstanceTerminationOption' => [ 'base' => '<p>Information about whether instances in the original environment are terminated when a blue/green deployment is successful. <code>BlueInstanceTerminationOption</code> does not apply to Lambda deployments. </p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$terminateBlueInstancesOnDeploymentSuccess' => '<p>Information about whether to terminate instances in the original fleet during a blue/green deployment.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlarmConfiguration$enabled' => '<p>Indicates whether the alarm configuration is enabled.</p>', 'AlarmConfiguration$ignorePollAlarmFailure' => '<p>Indicates whether a deployment should continue if information about the current state of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.</p> <ul> <li> <p> <code>true</code>: The deployment proceeds even if alarm status information can\'t be retrieved from Amazon CloudWatch.</p> </li> <li> <p> <code>false</code>: The deployment stops if alarm status information can\'t be retrieved from Amazon CloudWatch.</p> </li> </ul>', 'ApplicationInfo$linkedToGitHub' => '<p>True if the user has authenticated with GitHub for the specified application. Otherwise, false.</p>', 'AutoRollbackConfiguration$enabled' => '<p>Indicates whether a defined automatic rollback configuration is currently enabled.</p>', 'CreateDeploymentInput$ignoreApplicationStopFailures' => '<p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p> <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p> <p> During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p> <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>', 'CreateDeploymentInput$updateOutdatedInstancesOnly' => '<p> Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. </p>', 'DeploymentGroupInfo$terminationHookEnabled' => '<p>Indicates whether the deployment group was configured to have CodeDeploy install a termination hook into an Auto Scaling group.</p> <p>For more information about the termination hook, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors">How Amazon EC2 Auto Scaling works with CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.</p>', 'DeploymentInfo$ignoreApplicationStopFailures' => '<p> If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code> fails, the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with <code>ApplicationStop</code>. </p> <p> If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted. </p> <p> During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail. </p> <p> If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should be ignored. </p>', 'DeploymentInfo$updateOutdatedInstancesOnly' => '<p>Indicates whether only instances that are not running the latest application revision are to be deployed to.</p>', 'DeploymentInfo$instanceTerminationWaitTimeStarted' => '<p>Indicates whether the wait period set for the termination of instances in the original environment has started. Status is \'false\' if the KEEP_ALIVE option is specified. Otherwise, \'true\' as soon as the termination wait period starts.</p>', ], ], 'BucketNameFilterRequiredException' => [ 'base' => '<p>A bucket name is required, but was not provided.</p>', 'refs' => [], ], 'BundleType' => [ 'base' => NULL, 'refs' => [ 'S3Location$bundleType' => '<p>The file type of the application revision. Must be one of the following:</p> <ul> <li> <p> <code>tar</code>: A tar archive file.</p> </li> <li> <p> <code>tgz</code>: A compressed tar archive file.</p> </li> <li> <p> <code>zip</code>: A zip archive file.</p> </li> <li> <p> <code>YAML</code>: A YAML-formatted file.</p> </li> <li> <p> <code>JSON</code>: A JSON-formatted file.</p> </li> </ul>', ], ], 'CloudFormationResourceType' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$resourceType' => '<p>The resource type for the CloudFormation blue/green deployment.</p>', ], ], 'CloudFormationTarget' => [ 'base' => '<p> Information about the target to be updated by an CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.</p>', 'refs' => [ 'DeploymentTarget$cloudFormationTarget' => NULL, ], ], 'CommitId' => [ 'base' => NULL, 'refs' => [ 'GitHubLocation$commitId' => '<p>The SHA1 commit ID of the GitHub commit that represents the bundled artifacts for the application revision.</p>', ], ], 'ComputePlatform' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$computePlatform' => '<p>The destination platform type for deployment of the application (<code>Lambda</code> or <code>Server</code>).</p>', 'CreateApplicationInput$computePlatform' => '<p> The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>', 'CreateDeploymentConfigInput$computePlatform' => '<p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>', 'DeploymentConfigInfo$computePlatform' => '<p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>', 'DeploymentGroupInfo$computePlatform' => '<p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>', 'DeploymentInfo$computePlatform' => '<p>The destination platform type for the deployment (<code>Lambda</code>, <code>Server</code>, or <code>ECS</code>).</p>', ], ], 'ContinueDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationInput' => [ 'base' => '<p>Represents the input of a <code>CreateApplication</code> operation.</p>', 'refs' => [], ], 'CreateApplicationOutput' => [ 'base' => '<p>Represents the output of a <code>CreateApplication</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a <code>CreateDeploymentConfig</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentConfigOutput' => [ 'base' => '<p>Represents the output of a <code>CreateDeploymentConfig</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a <code>CreateDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a <code>CreateDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentInput' => [ 'base' => '<p>Represents the input of a <code>CreateDeployment</code> operation.</p>', 'refs' => [], ], 'CreateDeploymentOutput' => [ 'base' => '<p> Represents the output of a <code>CreateDeployment</code> operation. </p>', 'refs' => [], ], 'DeleteApplicationInput' => [ 'base' => '<p>Represents the input of a <code>DeleteApplication</code> operation.</p>', 'refs' => [], ], 'DeleteDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a <code>DeleteDeploymentConfig</code> operation.</p>', 'refs' => [], ], 'DeleteDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a <code>DeleteDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'DeleteDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a <code>DeleteDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'DeleteGitHubAccountTokenInput' => [ 'base' => '<p>Represents the input of a <code>DeleteGitHubAccount</code> operation.</p>', 'refs' => [], ], 'DeleteGitHubAccountTokenOutput' => [ 'base' => '<p>Represents the output of a <code>DeleteGitHubAccountToken</code> operation.</p>', 'refs' => [], ], 'DeleteResourcesByExternalIdInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcesByExternalIdOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentAlreadyCompletedException' => [ 'base' => '<p>The deployment is already complete.</p>', 'refs' => [], ], 'DeploymentAlreadyStartedException' => [ 'base' => '<p> A deployment to a target was attempted while another deployment was in progress. </p>', 'refs' => [], ], 'DeploymentConfigAlreadyExistsException' => [ 'base' => '<p>A deployment configuration with the specified name with the user or Amazon Web Services account already exists.</p>', 'refs' => [], ], 'DeploymentConfigDoesNotExistException' => [ 'base' => '<p>The deployment configuration does not exist with the user or Amazon Web Services account.</p>', 'refs' => [], ], 'DeploymentConfigId' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentConfigOutput$deploymentConfigId' => '<p>A unique deployment configuration ID.</p>', 'DeploymentConfigInfo$deploymentConfigId' => '<p>The deployment configuration ID.</p>', ], ], 'DeploymentConfigInUseException' => [ 'base' => '<p>The deployment configuration is still in use.</p>', 'refs' => [], ], 'DeploymentConfigInfo' => [ 'base' => '<p>Information about a deployment configuration.</p>', 'refs' => [ 'GetDeploymentConfigOutput$deploymentConfigInfo' => '<p>Information about the deployment configuration.</p>', ], ], 'DeploymentConfigLimitExceededException' => [ 'base' => '<p>The deployment configurations limit was exceeded.</p>', 'refs' => [], ], 'DeploymentConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentConfigInput$deploymentConfigName' => '<p>The name of the deployment configuration to create.</p>', 'CreateDeploymentGroupInput$deploymentConfigName' => '<p>If specified, the deployment configuration name can be either one of the predefined configurations provided with CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.</p> <p> <code>CodeDeployDefault.OneAtATime</code> is the default deployment configuration. It is used if a configuration isn\'t specified for the deployment or deployment group.</p> <p>For more information about the predefined deployment configurations in CodeDeploy, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html">Working with Deployment Configurations in CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.</p>', 'CreateDeploymentInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the user or Amazon Web Services account.</p> <p>If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.</p>', 'DeleteDeploymentConfigInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the user or Amazon Web Services account.</p>', 'DeploymentConfigInfo$deploymentConfigName' => '<p>The deployment configuration name.</p>', 'DeploymentConfigsList$member' => NULL, 'DeploymentGroupInfo$deploymentConfigName' => '<p>The deployment configuration name.</p>', 'DeploymentInfo$deploymentConfigName' => '<p> The deployment configuration name. </p>', 'GetDeploymentConfigInput$deploymentConfigName' => '<p>The name of a deployment configuration associated with the user or Amazon Web Services account.</p>', 'UpdateDeploymentGroupInput$deploymentConfigName' => '<p>The replacement deployment configuration name to use, if you want to change it.</p>', ], ], 'DeploymentConfigNameRequiredException' => [ 'base' => '<p>The deployment configuration name was not specified.</p>', 'refs' => [], ], 'DeploymentConfigsList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentConfigsOutput$deploymentConfigsList' => '<p>A list of deployment configurations, including built-in configurations such as <code>CodeDeployDefault.OneAtATime</code>.</p>', ], ], 'DeploymentCreator' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$creator' => '<p>The means by which the deployment was created:</p> <ul> <li> <p> <code>user</code>: A user created the deployment.</p> </li> <li> <p> <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p> </li> <li> <p> <code>codeDeployRollback</code>: A rollback process created the deployment.</p> </li> <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update process created the deployment when it detected outdated Amazon EC2 instances.</p> </li> </ul>', ], ], 'DeploymentDoesNotExistException' => [ 'base' => '<p>The deployment with the user or Amazon Web Services account does not exist.</p>', 'refs' => [], ], 'DeploymentGroupAlreadyExistsException' => [ 'base' => '<p>A deployment group with the specified name with the user or Amazon Web Services account already exists.</p>', 'refs' => [], ], 'DeploymentGroupDoesNotExistException' => [ 'base' => '<p>The named deployment group with the user or Amazon Web Services account does not exist.</p>', 'refs' => [], ], 'DeploymentGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupOutput$deploymentGroupId' => '<p>A unique deployment group ID.</p>', 'DeploymentGroupInfo$deploymentGroupId' => '<p>The deployment group ID.</p>', ], ], 'DeploymentGroupInfo' => [ 'base' => '<p>Information about a deployment group.</p>', 'refs' => [ 'DeploymentGroupInfoList$member' => NULL, 'GetDeploymentGroupOutput$deploymentGroupInfo' => '<p>Information about the deployment group.</p>', ], ], 'DeploymentGroupInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentGroupsOutput$deploymentGroupsInfo' => '<p>Information about the deployment groups.</p>', ], ], 'DeploymentGroupLimitExceededException' => [ 'base' => '<p> The deployment groups limit was exceeded.</p>', 'refs' => [], ], 'DeploymentGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$deploymentGroupName' => '<p>The name of a new deployment group for the specified application.</p>', 'CreateDeploymentInput$deploymentGroupName' => '<p>The name of the deployment group.</p>', 'DeleteDeploymentGroupInput$deploymentGroupName' => '<p>The name of a deployment group for the specified application.</p>', 'DeploymentGroupInfo$deploymentGroupName' => '<p>The deployment group name.</p>', 'DeploymentGroupsList$member' => NULL, 'DeploymentInfo$deploymentGroupName' => '<p> The deployment group name. </p>', 'GetDeploymentGroupInput$deploymentGroupName' => '<p>The name of a deployment group for the specified application.</p>', 'ListDeploymentsInput$deploymentGroupName' => '<p>The name of a deployment group for the specified application.</p> <note> <p>If <code>deploymentGroupName</code> is specified, then <code>applicationName</code> must be specified. If it is not specified, then <code>applicationName</code> must not be specified. </p> </note>', 'UpdateDeploymentGroupInput$currentDeploymentGroupName' => '<p>The current name of the deployment group.</p>', 'UpdateDeploymentGroupInput$newDeploymentGroupName' => '<p>The new name of the deployment group, if you want to change it.</p>', ], ], 'DeploymentGroupNameRequiredException' => [ 'base' => '<p>The deployment group name was not specified.</p>', 'refs' => [], ], 'DeploymentGroupsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentGroupsInput$deploymentGroupNames' => '<p>The names of the deployment groups.</p>', 'GenericRevisionInfo$deploymentGroups' => '<p>The deployment groups for which this is the current target revision.</p>', 'ListDeploymentGroupsOutput$deploymentGroups' => '<p>A list of deployment group names.</p>', ], ], 'DeploymentId' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'BatchGetDeploymentTargetsInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'CloudFormationTarget$deploymentId' => '<p>The unique ID of an CloudFormation blue/green deployment.</p>', 'ContinueDeploymentInput$deploymentId' => '<p> The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. </p>', 'CreateDeploymentOutput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'DeploymentInfo$deploymentId' => '<p> The unique ID of a deployment. </p>', 'DeploymentsList$member' => NULL, 'ECSTarget$deploymentId' => '<p> The unique ID of a deployment. </p>', 'GetDeploymentInput$deploymentId' => '<p> The unique ID of a deployment associated with the user or Amazon Web Services account. </p>', 'GetDeploymentInstanceInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'GetDeploymentTargetInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'InstanceSummary$deploymentId' => '<p> The unique ID of a deployment. </p>', 'InstanceTarget$deploymentId' => '<p> The unique ID of a deployment. </p>', 'LambdaTarget$deploymentId' => '<p> The unique ID of a deployment. </p>', 'LastDeploymentInfo$deploymentId' => '<p> The unique ID of a deployment. </p>', 'ListDeploymentInstancesInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'ListDeploymentTargetsInput$deploymentId' => '<p> The unique ID of a deployment. </p>', 'PutLifecycleEventHookExecutionStatusInput$deploymentId' => '<p> The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. </p>', 'RelatedDeployments$autoUpdateOutdatedInstancesRootDeploymentId' => '<p>The deployment ID of the root deployment that triggered this deployment.</p>', 'RollbackInfo$rollbackDeploymentId' => '<p>The ID of the deployment rollback.</p>', 'RollbackInfo$rollbackTriggeringDeploymentId' => '<p>The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or was stopped.</p>', 'SkipWaitTimeForInstanceTerminationInput$deploymentId' => '<p> The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. </p>', 'StopDeploymentInput$deploymentId' => '<p> The unique ID of a deployment. </p>', ], ], 'DeploymentIdRequiredException' => [ 'base' => '<p>At least one deployment ID must be specified.</p>', 'refs' => [], ], 'DeploymentInfo' => [ 'base' => '<p>Information about a deployment.</p>', 'refs' => [ 'DeploymentsInfoList$member' => NULL, 'GetDeploymentOutput$deploymentInfo' => '<p>Information about the deployment.</p>', ], ], 'DeploymentIsNotInReadyStateException' => [ 'base' => '<p>The deployment does not have a status of Ready and can\'t continue yet.</p>', 'refs' => [], ], 'DeploymentLimitExceededException' => [ 'base' => '<p>The number of allowed deployments was exceeded.</p>', 'refs' => [], ], 'DeploymentNotStartedException' => [ 'base' => '<p>The specified deployment has not started.</p>', 'refs' => [], ], 'DeploymentOption' => [ 'base' => NULL, 'refs' => [ 'DeploymentStyle$deploymentOption' => '<p>Indicates whether to route deployment traffic behind a load balancer.</p>', ], ], 'DeploymentOverview' => [ 'base' => '<p>Information about the deployment status of the instances in the deployment.</p>', 'refs' => [ 'DeploymentInfo$deploymentOverview' => '<p>A summary of the deployment status of the instances in the deployment.</p>', ], ], 'DeploymentReadyAction' => [ 'base' => NULL, 'refs' => [ 'DeploymentReadyOption$actionOnTimeout' => '<p>Information about when to reroute traffic from an original environment to a replacement environment in a blue/green deployment.</p> <ul> <li> <p>CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately after the new application revision is installed on the instances in the replacement environment.</p> </li> <li> <p>STOP_DEPLOYMENT: Do not register new instances with a load balancer unless traffic rerouting is started using <a>ContinueDeployment</a>. If traffic rerouting is not started before the end of the specified wait period, the deployment status is changed to Stopped.</p> </li> </ul>', ], ], 'DeploymentReadyOption' => [ 'base' => '<p>Information about how traffic is rerouted to instances in a replacement environment in a blue/green deployment.</p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$deploymentReadyOption' => '<p>Information about the action to take when newly provisioned instances are ready to receive traffic in a blue/green deployment.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$status' => '<p>The current state of the deployment as a whole.</p>', 'DeploymentStatusList$member' => NULL, 'LastDeploymentInfo$status' => '<p>The status of the most recent deployment.</p>', ], ], 'DeploymentStatusList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsInput$includeOnlyStatuses' => '<p>A subset of deployments to list by status:</p> <ul> <li> <p> <code>Created</code>: Include created deployments in the resulting list.</p> </li> <li> <p> <code>Queued</code>: Include queued deployments in the resulting list.</p> </li> <li> <p> <code>In Progress</code>: Include in-progress deployments in the resulting list.</p> </li> <li> <p> <code>Succeeded</code>: Include successful deployments in the resulting list.</p> </li> <li> <p> <code>Failed</code>: Include failed deployments in the resulting list.</p> </li> <li> <p> <code>Stopped</code>: Include stopped deployments in the resulting list.</p> </li> </ul>', ], ], 'DeploymentStatusMessageList' => [ 'base' => NULL, 'refs' => [ 'DeploymentInfo$deploymentStatusMessages' => '<p>Messages that contain information about the status of a deployment.</p>', ], ], 'DeploymentStyle' => [ 'base' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'refs' => [ 'CreateDeploymentGroupInput$deploymentStyle' => '<p>Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer.</p>', 'DeploymentGroupInfo$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'DeploymentInfo$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', 'UpdateDeploymentGroupInput$deploymentStyle' => '<p>Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.</p>', ], ], 'DeploymentTarget' => [ 'base' => '<p> Information about the deployment target. </p>', 'refs' => [ 'DeploymentTargetList$member' => NULL, 'GetDeploymentTargetOutput$deploymentTarget' => '<p> A deployment target that contains information about a deployment such as its status, lifecycle events, and when it was last updated. It also contains metadata about the deployment target. The deployment target metadata depends on the deployment target\'s type (<code>instanceTarget</code>, <code>lambdaTarget</code>, or <code>ecsTarget</code>). </p>', ], ], 'DeploymentTargetDoesNotExistException' => [ 'base' => '<p> The provided target ID does not belong to the attempted deployment. </p>', 'refs' => [], ], 'DeploymentTargetIdRequiredException' => [ 'base' => '<p> A deployment target ID was not provided. </p>', 'refs' => [], ], 'DeploymentTargetList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentTargetsOutput$deploymentTargets' => '<p> A list of target objects for a deployment. Each target object contains details about the target, such as its status and lifecycle events. The type of the target objects depends on the deployment\' compute platform. </p> <ul> <li> <p> <b>EC2/On-premises</b>: Each target object is an Amazon EC2 or on-premises instance. </p> </li> <li> <p> <b>Lambda</b>: The target object is a specific version of an Lambda function. </p> </li> <li> <p> <b>Amazon ECS</b>: The target object is an Amazon ECS service. </p> </li> <li> <p> <b>CloudFormation</b>: The target object is an CloudFormation blue/green deployment. </p> </li> </ul>', ], ], 'DeploymentTargetListSizeExceededException' => [ 'base' => '<p> The maximum number of targets that can be associated with an Amazon ECS or Lambda deployment was exceeded. The target list of both types of deployments must have exactly one item. This exception does not apply to EC2/On-premises deployments. </p>', 'refs' => [], ], 'DeploymentTargetType' => [ 'base' => NULL, 'refs' => [ 'DeploymentTarget$deploymentTargetType' => '<p>The deployment type that is specific to the deployment\'s compute platform or deployments initiated by a CloudFormation stack update.</p>', ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'DeploymentStyle$deploymentType' => '<p>Indicates whether to run an in-place deployment or a blue/green deployment.</p>', ], ], 'DeploymentWaitType' => [ 'base' => NULL, 'refs' => [ 'ContinueDeploymentInput$deploymentWaitType' => '<p> The status of the deployment\'s waiting period. <code>READY_WAIT</code> indicates that the deployment is ready to start shifting traffic. <code>TERMINATION_WAIT</code> indicates that the traffic is shifted, but the original target is not terminated. </p>', ], ], 'DeploymentsInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentsOutput$deploymentsInfo' => '<p> Information about the deployments. </p>', ], ], 'DeploymentsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentsInput$deploymentIds' => '<p> A list of deployment IDs, separated by spaces. The maximum number of deployment IDs you can specify is 25.</p>', 'ListDeploymentsOutput$deployments' => '<p>A list of deployment IDs.</p>', 'RelatedDeployments$autoUpdateOutdatedInstancesDeploymentIds' => '<p>The deployment IDs of \'auto-update outdated instances\' deployments triggered by this deployment.</p>', ], ], 'DeregisterOnPremisesInstanceInput' => [ 'base' => '<p>Represents the input of a <code>DeregisterOnPremisesInstance</code> operation.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentInput$description' => '<p>A comment about the deployment.</p>', 'DeploymentInfo$description' => '<p>A comment about the deployment.</p>', 'GenericRevisionInfo$description' => '<p>A comment about the revision.</p>', 'RegisterApplicationRevisionInput$description' => '<p>A comment about the revision.</p>', 'RollbackInfo$rollbackMessage' => '<p>Information that describes the status of a deployment rollback (for example, whether the deployment can\'t be rolled back, is in progress, failed, or succeeded). </p>', ], ], 'DescriptionTooLongException' => [ 'base' => '<p>The description is too long.</p>', 'refs' => [], ], 'Diagnostics' => [ 'base' => '<p>Diagnostic information about executable scripts that are part of a deployment.</p>', 'refs' => [ 'LifecycleEvent$diagnostics' => '<p>Diagnostic information about the deployment lifecycle event.</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'BlueInstanceTerminationOption$terminationWaitTimeInMinutes' => '<p>For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.</p> <p> For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set. </p> <p> The maximum setting is 2880 minutes (2 days). </p>', 'DeploymentReadyOption$waitTimeInMinutes' => '<p>The number of minutes to wait before the status of a blue/green deployment is changed to Stopped if rerouting is not started manually. Applies only to the <code>STOP_DEPLOYMENT</code> option for <code>actionOnTimeout</code>.</p>', ], ], 'EC2TagFilter' => [ 'base' => '<p>Information about an EC2 tag filter.</p>', 'refs' => [ 'EC2TagFilterList$member' => NULL, ], ], 'EC2TagFilterList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$ec2TagFilters' => '<p>The Amazon EC2 tags on which to filter. The deployment group includes Amazon EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet.</p>', 'DeploymentGroupInfo$ec2TagFilters' => '<p>The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags.</p>', 'EC2TagSetList$member' => NULL, 'TargetInstances$tagFilters' => '<p>The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a blue/green deployment. Cannot be used in the same call as <code>ec2TagSet</code>.</p>', 'UpdateDeploymentGroupInput$ec2TagFilters' => '<p>The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>', ], ], 'EC2TagFilterType' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Type' => '<p>The tag filter type:</p> <ul> <li> <p> <code>KEY_ONLY</code>: Key only.</p> </li> <li> <p> <code>VALUE_ONLY</code>: Value only.</p> </li> <li> <p> <code>KEY_AND_VALUE</code>: Key and value.</p> </li> </ul>', ], ], 'EC2TagSet' => [ 'base' => '<p>Information about groups of Amazon EC2 instance tags.</p>', 'refs' => [ 'CreateDeploymentGroupInput$ec2TagSet' => '<p>Information about groups of tags applied to Amazon EC2 instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups. Cannot be used in the same call as <code>ec2TagFilters</code>.</p>', 'DeploymentGroupInfo$ec2TagSet' => '<p>Information about groups of tags applied to an Amazon EC2 instance. The deployment group includes only Amazon EC2 instances identified by all of the tag groups. Cannot be used in the same call as ec2TagFilters.</p>', 'TargetInstances$ec2TagSet' => '<p>Information about the groups of Amazon EC2 instance tags that an instance must be identified by in order for it to be included in the replacement environment for a blue/green deployment. Cannot be used in the same call as <code>tagFilters</code>.</p>', 'UpdateDeploymentGroupInput$ec2TagSet' => '<p>Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups.</p>', ], ], 'EC2TagSetList' => [ 'base' => NULL, 'refs' => [ 'EC2TagSet$ec2TagSetList' => '<p>A list that contains other lists of Amazon EC2 instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>', ], ], 'ECSClusterName' => [ 'base' => NULL, 'refs' => [ 'ECSService$clusterName' => '<p> The name of the cluster that the Amazon ECS service is associated with. </p>', ], ], 'ECSService' => [ 'base' => '<p> Contains the service and cluster names used to identify an Amazon ECS deployment\'s target. </p>', 'refs' => [ 'ECSServiceList$member' => NULL, ], ], 'ECSServiceList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$ecsServices' => '<p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. </p>', 'DeploymentGroupInfo$ecsServices' => '<p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. </p>', 'UpdateDeploymentGroupInput$ecsServices' => '<p> The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. </p>', ], ], 'ECSServiceMappingLimitExceededException' => [ 'base' => '<p> The Amazon ECS service is associated with more than one deployment groups. An Amazon ECS service can be associated with only one deployment group. </p>', 'refs' => [], ], 'ECSServiceName' => [ 'base' => NULL, 'refs' => [ 'ECSService$serviceName' => '<p> The name of the target Amazon ECS service. </p>', ], ], 'ECSTarget' => [ 'base' => '<p> Information about the target of an Amazon ECS deployment. </p>', 'refs' => [ 'DeploymentTarget$ecsTarget' => '<p> Information about the target for a deployment that uses the Amazon ECS compute platform. </p>', ], ], 'ECSTaskSet' => [ 'base' => '<p> Information about a set of Amazon ECS tasks in an CodeDeploy deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic. An CodeDeploy application that uses the Amazon ECS compute platform deploys a containerized application in an Amazon ECS service as a task set. </p>', 'refs' => [ 'ECSTaskSetList$member' => NULL, ], ], 'ECSTaskSetCount' => [ 'base' => NULL, 'refs' => [ 'ECSTaskSet$desiredCount' => '<p> The number of tasks in a task set. During a deployment that uses the Amazon ECS compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this value to determine how many tasks to create. After the updated task set is created, CodeDeploy shifts traffic to the new task set. </p>', 'ECSTaskSet$pendingCount' => '<p> The number of tasks in the task set that are in the <code>PENDING</code> status during an Amazon ECS deployment. A task in the <code>PENDING</code> state is preparing to enter the <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when it launches for the first time, or when it is restarted after being in the <code>STOPPED</code> state. </p>', 'ECSTaskSet$runningCount' => '<p> The number of tasks in the task set that are in the <code>RUNNING</code> status during an Amazon ECS deployment. A task in the <code>RUNNING</code> state is running and ready for use. </p>', ], ], 'ECSTaskSetIdentifier' => [ 'base' => NULL, 'refs' => [ 'ECSTaskSet$identifer' => '<p> A unique ID of an <code>ECSTaskSet</code>. </p>', ], ], 'ECSTaskSetList' => [ 'base' => NULL, 'refs' => [ 'ECSTarget$taskSetsInfo' => '<p> The <code>ECSTaskSet</code> objects associated with the ECS target. </p>', ], ], 'ECSTaskSetStatus' => [ 'base' => NULL, 'refs' => [ 'ECSTaskSet$status' => '<p> The status of the task set. There are three valid task set statuses: </p> <ul> <li> <p> <code>PRIMARY</code>: Indicates the task set is serving production traffic. </p> </li> <li> <p> <code>ACTIVE</code>: Indicates the task set is not serving production traffic. </p> </li> <li> <p> <code>DRAINING</code>: Indicates the tasks in the task set are being stopped and their corresponding targets are being deregistered from their target group. </p> </li> </ul>', ], ], 'ELBInfo' => [ 'base' => '<p>Information about a Classic Load Balancer in Elastic Load Balancing to use in a deployment. Instances are registered directly with a load balancer, and traffic is routed to the load balancer.</p>', 'refs' => [ 'ELBInfoList$member' => NULL, ], ], 'ELBInfoList' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerInfo$elbInfoList' => '<p>An array that contains information about the load balancers to use for load balancing in a deployment. If you\'re using Classic Load Balancers, specify those load balancers in this array. </p> <note> <p>You can add up to 10 load balancers to the array.</p> </note> <note> <p>If you\'re using Application Load Balancers or Network Load Balancers, use the <code>targetGroupInfoList</code> array instead of this one.</p> </note>', ], ], 'ELBName' => [ 'base' => NULL, 'refs' => [ 'ELBInfo$name' => '<p>For blue/green deployments, the name of the Classic Load Balancer that is used to route traffic from original instances to replacement instances in a blue/green deployment. For in-place deployments, the name of the Classic Load Balancer that instances are deregistered from so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete.</p>', ], ], 'ETag' => [ 'base' => NULL, 'refs' => [ 'S3Location$eTag' => '<p>The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p> <p>If the ETag is not specified as an input parameter, ETag validation of the object is skipped.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorInformation$code' => '<p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html">Error Codes for CodeDeploy</a> in the <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide">CodeDeploy User Guide</a>.</p> <p>The error code:</p> <ul> <li> <p>APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.</p> </li> <li> <p>DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.</p> </li> <li> <p>HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.</p> </li> <li> <p>HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.</p> </li> <li> <p>IAM_ROLE_MISSING: The service role cannot be accessed.</p> </li> <li> <p>IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.</p> </li> <li> <p>INTERNAL_ERROR: There was an internal error.</p> </li> <li> <p>NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.</p> </li> <li> <p>NO_INSTANCES: No instances were specified, or no instances can be found.</p> </li> <li> <p>OVER_MAX_INSTANCES: The maximum number of instances was exceeded.</p> </li> <li> <p>THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more Amazon Web Services services.</p> </li> <li> <p>TIMEOUT: The deployment has timed out.</p> </li> <li> <p>REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.</p> </li> </ul>', ], ], 'ErrorInformation' => [ 'base' => '<p>Information about a deployment error.</p>', 'refs' => [ 'DeploymentInfo$errorInformation' => '<p>Information about any error associated with this deployment.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsOutput$errorMessage' => '<p>Information about errors that might have occurred during the API call.</p>', 'BatchGetDeploymentGroupsOutput$errorMessage' => '<p>Information about errors that might have occurred during the API call.</p>', 'BatchGetDeploymentInstancesOutput$errorMessage' => '<p>Information about errors that might have occurred during the API call.</p>', 'DeploymentStatusMessageList$member' => NULL, 'ErrorInformation$message' => '<p>An accompanying error message.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcesByExternalIdInput$externalId' => '<p>The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources.</p>', 'DeploymentInfo$externalId' => '<p>The unique ID for an external resource (for example, a CloudFormation stack ID) that is linked to this deployment.</p>', 'ListDeploymentsInput$externalId' => '<p>The unique ID of an external resource for returning deployments linked to the external resource.</p>', ], ], 'FileExistsBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentInput$fileExistsBehavior' => '<p>Information about how CodeDeploy handles files that already exist in a deployment target location but weren\'t part of the previous successful deployment.</p> <p>The <code>fileExistsBehavior</code> parameter takes any of the following values:</p> <ul> <li> <p>DISALLOW: The deployment fails. This is also the default behavior if no option is specified.</p> </li> <li> <p>OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li> <li> <p>RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li> </ul>', 'DeploymentInfo$fileExistsBehavior' => '<p>Information about how CodeDeploy handles files that already exist in a deployment target location but weren\'t part of the previous successful deployment.</p> <ul> <li> <p> <code>DISALLOW</code>: The deployment fails. This is also the default behavior if no option is specified.</p> </li> <li> <p> <code>OVERWRITE</code>: The version of the file from the application revision currently being deployed replaces the version already on the instance.</p> </li> <li> <p> <code>RETAIN</code>: The version of the file already on the instance is kept and used as part of the new deployment.</p> </li> </ul>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'TargetFilters$value' => NULL, ], ], 'GenericRevisionInfo' => [ 'base' => '<p>Information about an application revision.</p>', 'refs' => [ 'GetApplicationRevisionOutput$revisionInfo' => '<p>General information about the revision.</p>', 'RevisionInfo$genericRevisionInfo' => '<p>Information about an application revision, including usage details and associated deployment groups.</p>', ], ], 'GetApplicationInput' => [ 'base' => '<p>Represents the input of a <code>GetApplication</code> operation.</p>', 'refs' => [], ], 'GetApplicationOutput' => [ 'base' => '<p>Represents the output of a <code>GetApplication</code> operation.</p>', 'refs' => [], ], 'GetApplicationRevisionInput' => [ 'base' => '<p>Represents the input of a <code>GetApplicationRevision</code> operation.</p>', 'refs' => [], ], 'GetApplicationRevisionOutput' => [ 'base' => '<p>Represents the output of a <code>GetApplicationRevision</code> operation.</p>', 'refs' => [], ], 'GetDeploymentConfigInput' => [ 'base' => '<p>Represents the input of a <code>GetDeploymentConfig</code> operation.</p>', 'refs' => [], ], 'GetDeploymentConfigOutput' => [ 'base' => '<p>Represents the output of a <code>GetDeploymentConfig</code> operation.</p>', 'refs' => [], ], 'GetDeploymentGroupInput' => [ 'base' => '<p>Represents the input of a <code>GetDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'GetDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of a <code>GetDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'GetDeploymentInput' => [ 'base' => '<p>Represents the input of a <code>GetDeployment</code> operation.</p>', 'refs' => [], ], 'GetDeploymentInstanceInput' => [ 'base' => '<p> Represents the input of a <code>GetDeploymentInstance</code> operation. </p>', 'refs' => [], ], 'GetDeploymentInstanceOutput' => [ 'base' => '<p> Represents the output of a <code>GetDeploymentInstance</code> operation. </p>', 'refs' => [], ], 'GetDeploymentOutput' => [ 'base' => '<p>Represents the output of a <code>GetDeployment</code> operation.</p>', 'refs' => [], ], 'GetDeploymentTargetInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentTargetOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOnPremisesInstanceInput' => [ 'base' => '<p> Represents the input of a <code>GetOnPremisesInstance</code> operation. </p>', 'refs' => [], ], 'GetOnPremisesInstanceOutput' => [ 'base' => '<p> Represents the output of a <code>GetOnPremisesInstance</code> operation. </p>', 'refs' => [], ], 'GitHubAccountTokenDoesNotExistException' => [ 'base' => '<p>No GitHub account connection exists with the named specified in the call.</p>', 'refs' => [], ], 'GitHubAccountTokenName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$gitHubAccountName' => '<p>The name for a connection to a GitHub account.</p>', 'DeleteGitHubAccountTokenInput$tokenName' => '<p>The name of the GitHub account connection to delete.</p>', 'DeleteGitHubAccountTokenOutput$tokenName' => '<p>The name of the GitHub account connection that was deleted.</p>', 'GitHubAccountTokenNameList$member' => NULL, ], ], 'GitHubAccountTokenNameList' => [ 'base' => NULL, 'refs' => [ 'ListGitHubAccountTokenNamesOutput$tokenNameList' => '<p>A list of names of connections to GitHub accounts.</p>', ], ], 'GitHubAccountTokenNameRequiredException' => [ 'base' => '<p>The call is missing a required GitHub account connection name.</p>', 'refs' => [], ], 'GitHubLocation' => [ 'base' => '<p>Information about the location of application artifacts stored in GitHub.</p>', 'refs' => [ 'RevisionLocation$gitHubLocation' => '<p>Information about the location of application artifacts stored in GitHub.</p>', ], ], 'GreenFleetProvisioningAction' => [ 'base' => NULL, 'refs' => [ 'GreenFleetProvisioningOption$action' => '<p>The method used to add instances to a replacement environment.</p> <ul> <li> <p> <code>DISCOVER_EXISTING</code>: Use instances that already exist or will be created manually.</p> </li> <li> <p> <code>COPY_AUTO_SCALING_GROUP</code>: Use settings from a specified Auto Scaling group to define and create instances in a new Auto Scaling group.</p> </li> </ul>', ], ], 'GreenFleetProvisioningOption' => [ 'base' => '<p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>', 'refs' => [ 'BlueGreenDeploymentConfiguration$greenFleetProvisioningOption' => '<p>Information about how instances are provisioned for a replacement environment in a blue/green deployment.</p>', ], ], 'IamArnRequiredException' => [ 'base' => '<p>No IAM ARN was included in the request. You must use an IAM session ARN or user ARN in the request.</p>', 'refs' => [], ], 'IamSessionArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$iamSessionArn' => '<p>The ARN of the IAM session associated with the on-premises instance.</p>', 'RegisterOnPremisesInstanceInput$iamSessionArn' => '<p>The ARN of the IAM session to associate with the on-premises instance.</p>', ], ], 'IamSessionArnAlreadyRegisteredException' => [ 'base' => '<p>The request included an IAM session ARN that has already been used to register a different instance.</p>', 'refs' => [], ], 'IamUserArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$iamUserArn' => '<p>The user ARN associated with the on-premises instance.</p>', 'RegisterOnPremisesInstanceInput$iamUserArn' => '<p>The ARN of the user to associate with the on-premises instance.</p>', ], ], 'IamUserArnAlreadyRegisteredException' => [ 'base' => '<p>The specified user ARN is already registered with an on-premises instance.</p>', 'refs' => [], ], 'IamUserArnRequiredException' => [ 'base' => '<p>An user ARN was not specified.</p>', 'refs' => [], ], 'InstanceAction' => [ 'base' => NULL, 'refs' => [ 'BlueInstanceTerminationOption$action' => '<p>The action to take on instances in the original environment after a successful blue/green deployment.</p> <ul> <li> <p> <code>TERMINATE</code>: Instances are terminated after a specified wait time.</p> </li> <li> <p> <code>KEEP_ALIVE</code>: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.</p> </li> </ul>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'InstanceInfo$instanceArn' => '<p>The ARN of the on-premises instance.</p>', ], ], 'InstanceCount' => [ 'base' => NULL, 'refs' => [ 'DeploymentOverview$Pending' => '<p>The number of instances in the deployment in a pending state.</p>', 'DeploymentOverview$InProgress' => '<p>The number of instances in which the deployment is in progress.</p>', 'DeploymentOverview$Succeeded' => '<p>The number of instances in the deployment to which revisions have been successfully deployed.</p>', 'DeploymentOverview$Failed' => '<p>The number of instances in the deployment in a failed state.</p>', 'DeploymentOverview$Skipped' => '<p>The number of instances in the deployment in a skipped state.</p>', 'DeploymentOverview$Ready' => '<p>The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.</p>', ], ], 'InstanceDoesNotExistException' => [ 'base' => '<p>The specified instance does not exist in the deployment group.</p>', 'refs' => [], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'GetDeploymentInstanceInput$instanceId' => '<p> The unique ID of an instance in the deployment group. </p>', 'InstanceSummary$instanceId' => '<p>The instance ID.</p>', 'InstancesList$member' => NULL, ], ], 'InstanceIdRequiredException' => [ 'base' => '<p>The instance ID was not specified.</p>', 'refs' => [], ], 'InstanceInfo' => [ 'base' => '<p>Information about an on-premises instance.</p>', 'refs' => [ 'GetOnPremisesInstanceOutput$instanceInfo' => '<p> Information about the on-premises instance. </p>', 'InstanceInfoList$member' => NULL, ], ], 'InstanceInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetOnPremisesInstancesOutput$instanceInfos' => '<p>Information about the on-premises instances.</p>', ], ], 'InstanceLimitExceededException' => [ 'base' => '<p>The maximum number of allowed on-premises instances in a single call was exceeded.</p>', 'refs' => [], ], 'InstanceName' => [ 'base' => NULL, 'refs' => [ 'DeregisterOnPremisesInstanceInput$instanceName' => '<p>The name of the on-premises instance to deregister.</p>', 'GetOnPremisesInstanceInput$instanceName' => '<p> The name of the on-premises instance about which to get information. </p>', 'InstanceInfo$instanceName' => '<p>The name of the on-premises instance.</p>', 'InstanceNameList$member' => NULL, 'RegisterOnPremisesInstanceInput$instanceName' => '<p>The name of the on-premises instance to register.</p>', ], ], 'InstanceNameAlreadyRegisteredException' => [ 'base' => '<p>The specified on-premises instance name is already registered.</p>', 'refs' => [], ], 'InstanceNameList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances to which to add tags.</p>', 'BatchGetOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.</p>', 'ListOnPremisesInstancesOutput$instanceNames' => '<p>The list of matching on-premises instance names.</p>', 'RemoveTagsFromOnPremisesInstancesInput$instanceNames' => '<p>The names of the on-premises instances from which to remove tags.</p>', ], ], 'InstanceNameRequiredException' => [ 'base' => '<p>An on-premises instance name was not specified.</p>', 'refs' => [], ], 'InstanceNotRegisteredException' => [ 'base' => '<p>The specified on-premises instance is not registered.</p>', 'refs' => [], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusList$member' => NULL, 'InstanceSummary$status' => '<p>The deployment status for this instance:</p> <ul> <li> <p> <code>Pending</code>: The deployment is pending for this instance.</p> </li> <li> <p> <code>In Progress</code>: The deployment is in progress for this instance.</p> </li> <li> <p> <code>Succeeded</code>: The deployment has succeeded for this instance.</p> </li> <li> <p> <code>Failed</code>: The deployment has failed for this instance.</p> </li> <li> <p> <code>Skipped</code>: The deployment has been skipped for this instance.</p> </li> <li> <p> <code>Unknown</code>: The deployment status is unknown for this instance.</p> </li> </ul>', ], ], 'InstanceStatusList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentInstancesInput$instanceStatusFilter' => '<p>A subset of instances to list by status:</p> <ul> <li> <p> <code>Pending</code>: Include those instances with pending deployments.</p> </li> <li> <p> <code>InProgress</code>: Include those instances where deployments are still in progress.</p> </li> <li> <p> <code>Succeeded</code>: Include those instances with successful deployments.</p> </li> <li> <p> <code>Failed</code>: Include those instances with failed deployments.</p> </li> <li> <p> <code>Skipped</code>: Include those instances with skipped deployments.</p> </li> <li> <p> <code>Unknown</code>: Include those instances with deployments in an unknown state.</p> </li> </ul>', ], ], 'InstanceSummary' => [ 'base' => '<p>Information about an instance in a deployment.</p>', 'refs' => [ 'GetDeploymentInstanceOutput$instanceSummary' => '<p> Information about the instance. </p>', 'InstanceSummaryList$member' => NULL, ], ], 'InstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesOutput$instancesSummary' => '<p>Information about the instance.</p>', ], ], 'InstanceTarget' => [ 'base' => '<p> A target Amazon EC2 or on-premises instance during a deployment that uses the EC2/On-premises compute platform. </p>', 'refs' => [ 'DeploymentTarget$instanceTarget' => '<p> Information about the target for a deployment that uses the EC2/On-premises compute platform. </p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceSummary$instanceType' => '<p>Information about which environment an instance belongs to in a blue/green deployment.</p> <ul> <li> <p>BLUE: The instance is part of the original environment.</p> </li> <li> <p>GREEN: The instance is part of the replacement environment.</p> </li> </ul>', 'InstanceTypeList$member' => NULL, ], ], 'InstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentInstancesInput$instanceTypeFilter' => '<p>The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.</p>', ], ], 'InstancesList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentInstancesInput$instanceIds' => '<p>The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.</p>', 'ListDeploymentInstancesOutput$instancesList' => '<p>A list of instance IDs.</p>', ], ], 'InvalidAlarmConfigException' => [ 'base' => '<p>The format of the alarm configuration is invalid. Possible causes include:</p> <ul> <li> <p>The alarm list is null.</p> </li> <li> <p>The alarm object is null.</p> </li> <li> <p>The alarm name is empty or null or exceeds the limit of 255 characters.</p> </li> <li> <p>Two alarms with the same name have been specified.</p> </li> <li> <p>The alarm configuration is enabled, but the alarm list is empty.</p> </li> </ul>', 'refs' => [], ], 'InvalidApplicationNameException' => [ 'base' => '<p>The application name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p> The specified ARN is not in a valid format. </p>', 'refs' => [], ], 'InvalidAutoRollbackConfigException' => [ 'base' => '<p>The automatic rollback configuration was specified in an invalid format. For example, automatic rollback is enabled, but an invalid triggering event type or no event types were listed.</p>', 'refs' => [], ], 'InvalidAutoScalingGroupException' => [ 'base' => '<p>The Auto Scaling group was specified in an invalid format or does not exist.</p>', 'refs' => [], ], 'InvalidBlueGreenDeploymentConfigurationException' => [ 'base' => '<p>The configuration for the blue/green deployment group was provided in an invalid format. For information about deployment configuration format, see <a>CreateDeploymentConfig</a>.</p>', 'refs' => [], ], 'InvalidBucketNameFilterException' => [ 'base' => '<p>The bucket name either doesn\'t exist or was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidComputePlatformException' => [ 'base' => '<p>The computePlatform is invalid. The computePlatform should be <code>Lambda</code>, <code>Server</code>, or <code>ECS</code>.</p>', 'refs' => [], ], 'InvalidDeployedStateFilterException' => [ 'base' => '<p>The deployed state filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentConfigNameException' => [ 'base' => '<p>The deployment configuration name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentGroupNameException' => [ 'base' => '<p>The deployment group name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentIdException' => [ 'base' => '<p>At least one of the deployment IDs was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidDeploymentInstanceTypeException' => [ 'base' => '<p>An instance type was specified for an in-place deployment. Instance types are supported for blue/green deployments only.</p>', 'refs' => [], ], 'InvalidDeploymentStatusException' => [ 'base' => '<p>The specified deployment status doesn\'t exist or cannot be determined.</p>', 'refs' => [], ], 'InvalidDeploymentStyleException' => [ 'base' => '<p>An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN." Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."</p>', 'refs' => [], ], 'InvalidDeploymentTargetIdException' => [ 'base' => '<p> The target ID provided was not valid. </p>', 'refs' => [], ], 'InvalidDeploymentWaitTypeException' => [ 'base' => '<p> The wait type is invalid. </p>', 'refs' => [], ], 'InvalidEC2TagCombinationException' => [ 'base' => '<p>A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only one of these data types can be used in a single call.</p>', 'refs' => [], ], 'InvalidEC2TagException' => [ 'base' => '<p>The tag was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidECSServiceException' => [ 'base' => '<p> The Amazon ECS service identifier is not valid. </p>', 'refs' => [], ], 'InvalidExternalIdException' => [ 'base' => '<p>The external ID was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidFileExistsBehaviorException' => [ 'base' => '<p>An invalid fileExistsBehavior option was specified to determine how CodeDeploy handles files or directories that already exist in a deployment target location, but weren\'t part of the previous successful deployment. Valid values include "DISALLOW," "OVERWRITE," and "RETAIN."</p>', 'refs' => [], ], 'InvalidGitHubAccountTokenException' => [ 'base' => '<p>The GitHub token is not valid.</p>', 'refs' => [], ], 'InvalidGitHubAccountTokenNameException' => [ 'base' => '<p>The format of the specified GitHub account connection name is invalid.</p>', 'refs' => [], ], 'InvalidIamSessionArnException' => [ 'base' => '<p>The IAM session ARN was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidIamUserArnException' => [ 'base' => '<p>The user ARN was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidIgnoreApplicationStopFailuresValueException' => [ 'base' => '<p>The IgnoreApplicationStopFailures value is invalid. For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidInstanceIdException' => [ 'base' => '<p> </p>', 'refs' => [], ], 'InvalidInstanceNameException' => [ 'base' => '<p>The on-premises instance name was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidInstanceStatusException' => [ 'base' => '<p>The specified instance status does not exist.</p>', 'refs' => [], ], 'InvalidInstanceTypeException' => [ 'base' => '<p>An invalid instance type was specified for instances in a blue/green deployment. Valid values include "Blue" for an original environment and "Green" for a replacement environment.</p>', 'refs' => [], ], 'InvalidKeyPrefixFilterException' => [ 'base' => '<p>The specified key prefix filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidLifecycleEventHookExecutionIdException' => [ 'base' => '<p>A lifecycle event hook is invalid. Review the <code>hooks</code> section in your AppSpec file to ensure the lifecycle events and <code>hooks</code> functions are valid.</p>', 'refs' => [], ], 'InvalidLifecycleEventHookExecutionStatusException' => [ 'base' => '<p>The result of a Lambda validation function that verifies a lifecycle event is invalid. It should return <code>Succeeded</code> or <code>Failed</code>.</p>', 'refs' => [], ], 'InvalidLoadBalancerInfoException' => [ 'base' => '<p>An invalid load balancer name, or no load balancer name, was specified.</p>', 'refs' => [], ], 'InvalidMinimumHealthyHostValueException' => [ 'base' => '<p>The minimum healthy instance value was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The next token was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidOnPremisesTagCombinationException' => [ 'base' => '<p>A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet, but only one of these data types can be used in a single call.</p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>An invalid operation was detected.</p>', 'refs' => [], ], 'InvalidRegistrationStatusException' => [ 'base' => '<p>The registration status was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidRevisionException' => [ 'base' => '<p>The revision was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidRoleException' => [ 'base' => '<p>The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the specified service role does not grant the appropriate permissions to Amazon EC2 Auto Scaling.</p>', 'refs' => [], ], 'InvalidSortByException' => [ 'base' => '<p>The column name to sort by is either not present or was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidSortOrderException' => [ 'base' => '<p>The sort order was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>The tag was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagFilterException' => [ 'base' => '<p>The tag filter was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagsToAddException' => [ 'base' => '<p> The specified tags are not valid. </p>', 'refs' => [], ], 'InvalidTargetException' => [ 'base' => '<p> A target is not valid. </p>', 'refs' => [], ], 'InvalidTargetFilterNameException' => [ 'base' => '<p> The target filter name is invalid. </p>', 'refs' => [], ], 'InvalidTargetGroupPairException' => [ 'base' => '<p> A target group pair associated with this deployment is not valid. </p>', 'refs' => [], ], 'InvalidTargetInstancesException' => [ 'base' => '<p>The target instance configuration is invalid. Possible causes include:</p> <ul> <li> <p>Configuration data for target instances was entered for an in-place deployment.</p> </li> <li> <p>The limit of 10 tags for a tag type was exceeded.</p> </li> <li> <p>The combined length of the tag names exceeded the limit. </p> </li> <li> <p>A specified tag is not currently applied to any instances.</p> </li> </ul>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>The specified time range was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTrafficRoutingConfigurationException' => [ 'base' => '<p> The configuration that specifies how traffic is routed during a deployment is invalid.</p>', 'refs' => [], ], 'InvalidTriggerConfigException' => [ 'base' => '<p>The trigger was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidUpdateOutdatedInstancesOnlyValueException' => [ 'base' => '<p>The UpdateOutdatedInstancesOnly value is invalid. For Lambda deployments, <code>false</code> is expected. For EC2/On-premises deployments, <code>true</code> or <code>false</code> is expected.</p>', 'refs' => [], ], 'InvalidZonalDeploymentConfigurationException' => [ 'base' => '<p>The <code>ZonalConfig</code> object is not valid.</p>', 'refs' => [], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Key' => '<p>The tag filter key.</p>', 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagFilter$Key' => '<p>The on-premises instance tag filter key.</p>', 'TagKeyList$member' => NULL, ], ], 'LambdaFunctionAlias' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionInfo$functionAlias' => '<p> The alias of a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Lambda Function Aliases</a> in the <i>Lambda Developer Guide</i>.</p>', ], ], 'LambdaFunctionInfo' => [ 'base' => '<p> Information about a Lambda function specified in a deployment. </p>', 'refs' => [ 'LambdaTarget$lambdaFunctionInfo' => '<p> A <code>LambdaFunctionInfo</code> object that describes a target Lambda function. </p>', ], ], 'LambdaFunctionName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionInfo$functionName' => '<p> The name of a Lambda function. </p>', ], ], 'LambdaTarget' => [ 'base' => '<p> Information about the target Lambda function during an Lambda deployment. </p>', 'refs' => [ 'DeploymentTarget$lambdaTarget' => '<p> Information about the target for a deployment that uses the Lambda compute platform. </p>', ], ], 'LastDeploymentInfo' => [ 'base' => '<p>Information about the most recent attempted or successful deployment to a deployment group.</p>', 'refs' => [ 'DeploymentGroupInfo$lastSuccessfulDeployment' => '<p>Information about the most recent successful deployment to the deployment group.</p>', 'DeploymentGroupInfo$lastAttemptedDeployment' => '<p>Information about the most recent attempted deployment to the deployment group.</p>', ], ], 'LifecycleErrorCode' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$errorCode' => '<p>The associated error code:</p> <ul> <li> <p>Success: The specified script ran.</p> </li> <li> <p>ScriptMissing: The specified script was not found in the specified location.</p> </li> <li> <p>ScriptNotExecutable: The specified script is not a recognized executable file type.</p> </li> <li> <p>ScriptTimedOut: The specified script did not finish running in the specified time period.</p> </li> <li> <p>ScriptFailed: The specified script failed to run as expected.</p> </li> <li> <p>UnknownError: The specified script did not run for an unknown reason.</p> </li> </ul>', ], ], 'LifecycleEvent' => [ 'base' => '<p>Information about a deployment lifecycle event.</p>', 'refs' => [ 'LifecycleEventList$member' => NULL, ], ], 'LifecycleEventAlreadyCompletedException' => [ 'base' => '<p>An attempt to return the status of an already completed lifecycle event occurred.</p>', 'refs' => [], ], 'LifecycleEventHookExecutionId' => [ 'base' => NULL, 'refs' => [ 'PutLifecycleEventHookExecutionStatusInput$lifecycleEventHookExecutionId' => '<p> The execution ID of a deployment\'s lifecycle hook. A deployment lifecycle hook is specified in the <code>hooks</code> section of the AppSpec file. </p>', 'PutLifecycleEventHookExecutionStatusOutput$lifecycleEventHookExecutionId' => '<p>The execution ID of the lifecycle event hook. A hook is specified in the <code>hooks</code> section of the deployment\'s AppSpec file.</p>', ], ], 'LifecycleEventList' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$lifecycleEvents' => '<p> The lifecycle events of the CloudFormation blue/green deployment to this target application. </p>', 'ECSTarget$lifecycleEvents' => '<p> The lifecycle events of the deployment to this target Amazon ECS application. </p>', 'InstanceSummary$lifecycleEvents' => '<p>A list of lifecycle events for this instance.</p>', 'InstanceTarget$lifecycleEvents' => '<p> The lifecycle events of the deployment to this target instance. </p>', 'LambdaTarget$lifecycleEvents' => '<p> The lifecycle events of the deployment to this target Lambda function. </p>', ], ], 'LifecycleEventName' => [ 'base' => NULL, 'refs' => [ 'LifecycleEvent$lifecycleEventName' => '<p>The deployment lifecycle event name, such as <code>ApplicationStop</code>, <code>BeforeInstall</code>, <code>AfterInstall</code>, <code>ApplicationStart</code>, or <code>ValidateService</code>.</p>', ], ], 'LifecycleEventStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleEvent$status' => '<p>The deployment lifecycle event status:</p> <ul> <li> <p>Pending: The deployment lifecycle event is pending.</p> </li> <li> <p>InProgress: The deployment lifecycle event is in progress.</p> </li> <li> <p>Succeeded: The deployment lifecycle event ran successfully.</p> </li> <li> <p>Failed: The deployment lifecycle event has failed.</p> </li> <li> <p>Skipped: The deployment lifecycle event has been skipped.</p> </li> <li> <p>Unknown: The deployment lifecycle event is unknown.</p> </li> </ul>', 'PutLifecycleEventHookExecutionStatusInput$status' => '<p>The result of a Lambda function that validates a deployment lifecycle event. The values listed in <b>Valid Values</b> are valid for lifecycle statuses in general; however, only <code>Succeeded</code> and <code>Failed</code> can be passed successfully in your API call.</p>', ], ], 'LifecycleHookLimitExceededException' => [ 'base' => '<p>The limit for lifecycle hooks was exceeded.</p>', 'refs' => [], ], 'LifecycleMessage' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$message' => '<p>The message associated with the error.</p>', ], ], 'ListApplicationRevisionsInput' => [ 'base' => '<p> Represents the input of a <code>ListApplicationRevisions</code> operation. </p>', 'refs' => [], ], 'ListApplicationRevisionsOutput' => [ 'base' => '<p>Represents the output of a <code>ListApplicationRevisions</code> operation.</p>', 'refs' => [], ], 'ListApplicationsInput' => [ 'base' => '<p>Represents the input of a <code>ListApplications</code> operation.</p>', 'refs' => [], ], 'ListApplicationsOutput' => [ 'base' => '<p>Represents the output of a ListApplications operation.</p>', 'refs' => [], ], 'ListDeploymentConfigsInput' => [ 'base' => '<p>Represents the input of a <code>ListDeploymentConfigs</code> operation.</p>', 'refs' => [], ], 'ListDeploymentConfigsOutput' => [ 'base' => '<p>Represents the output of a <code>ListDeploymentConfigs</code> operation.</p>', 'refs' => [], ], 'ListDeploymentGroupsInput' => [ 'base' => '<p>Represents the input of a <code>ListDeploymentGroups</code> operation.</p>', 'refs' => [], ], 'ListDeploymentGroupsOutput' => [ 'base' => '<p>Represents the output of a <code>ListDeploymentGroups</code> operation.</p>', 'refs' => [], ], 'ListDeploymentInstancesInput' => [ 'base' => '<p> Represents the input of a <code>ListDeploymentInstances</code> operation. </p>', 'refs' => [], ], 'ListDeploymentInstancesOutput' => [ 'base' => '<p>Represents the output of a <code>ListDeploymentInstances</code> operation.</p>', 'refs' => [], ], 'ListDeploymentTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsInput' => [ 'base' => '<p>Represents the input of a <code>ListDeployments</code> operation.</p>', 'refs' => [], ], 'ListDeploymentsOutput' => [ 'base' => '<p>Represents the output of a <code>ListDeployments</code> operation.</p>', 'refs' => [], ], 'ListGitHubAccountTokenNamesInput' => [ 'base' => '<p>Represents the input of a <code>ListGitHubAccountTokenNames</code> operation.</p>', 'refs' => [], ], 'ListGitHubAccountTokenNamesOutput' => [ 'base' => '<p>Represents the output of a <code>ListGitHubAccountTokenNames</code> operation.</p>', 'refs' => [], ], 'ListOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a <code>ListOnPremisesInstances</code> operation.</p>', 'refs' => [], ], 'ListOnPremisesInstancesOutput' => [ 'base' => '<p>Represents the output of the list on-premises instances operation.</p>', 'refs' => [], ], 'ListStateFilterAction' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$deployed' => '<p> Whether to list revisions based on whether the revision is the target revision of a deployment group: </p> <ul> <li> <p> <code>include</code>: List revisions that are target revisions of a deployment group.</p> </li> <li> <p> <code>exclude</code>: Do not list revisions that are target revisions of a deployment group.</p> </li> <li> <p> <code>ignore</code>: List all revisions.</p> </li> </ul>', ], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListenerArn' => [ 'base' => NULL, 'refs' => [ 'ListenerArnList$member' => NULL, ], ], 'ListenerArnList' => [ 'base' => NULL, 'refs' => [ 'TrafficRoute$listenerArns' => '<p> The Amazon Resource Name (ARN) of one listener. The listener identifies the route between a target group and a load balancer. This is an array of strings with a maximum size of one. </p>', ], ], 'LoadBalancerInfo' => [ 'base' => '<p>Information about the Elastic Load Balancing load balancer or target group used in a deployment.</p> <p>You can use load balancers and target groups in combination. For example, if you have two Classic Load Balancers, and five target groups tied to an Application Load Balancer, you can specify the two Classic Load Balancers in <code>elbInfoList</code>, and the five target groups in <code>targetGroupInfoList</code>.</p>', 'refs' => [ 'CreateDeploymentGroupInput$loadBalancerInfo' => '<p>Information about the load balancer used in a deployment.</p>', 'DeploymentGroupInfo$loadBalancerInfo' => '<p>Information about the load balancer to use in a deployment.</p>', 'DeploymentInfo$loadBalancerInfo' => '<p>Information about the load balancer used in the deployment.</p>', 'UpdateDeploymentGroupInput$loadBalancerInfo' => '<p>Information about the load balancer used in a deployment.</p>', ], ], 'LogTail' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$logTail' => '<p>The last portion of the diagnostic log.</p> <p>If available, CodeDeploy returns up to the last 4 KB of the diagnostic log.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'StopDeploymentOutput$statusMessage' => '<p>An accompanying status message.</p>', ], ], 'MinimumHealthyHosts' => [ 'base' => '<p>Information about the minimum number of healthy instances.</p>', 'refs' => [ 'CreateDeploymentConfigInput$minimumHealthyHosts' => '<p>The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.</p> <p>The type parameter takes either of the following values:</p> <ul> <li> <p>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</p> </li> <li> <p>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, CodeDeploy converts the percentage to the equivalent number of instances and rounds up fractional instances.</p> </li> </ul> <p>The value parameter takes an integer.</p> <p>For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.</p>', 'DeploymentConfigInfo$minimumHealthyHosts' => '<p>Information about the number or percentage of minimum healthy instances.</p>', ], ], 'MinimumHealthyHostsPerZone' => [ 'base' => '<p>Information about the minimum number of healthy instances per Availability Zone.</p>', 'refs' => [ 'ZonalConfig$minimumHealthyHostsPerZone' => '<p>The number or percentage of instances that must remain available per Availability Zone during a deployment. This option works in conjunction with the <code>MinimumHealthyHosts</code> option. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az">About the minimum number of healthy hosts per Availability Zone</a> in the <i>CodeDeploy User Guide</i>.</p> <p>If you don\'t specify the <code>minimumHealthyHostsPerZone</code> option, then CodeDeploy uses a default value of <code>0</code> percent.</p> <p>For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <i>CodeDeploy User Guide</i>.</p>', ], ], 'MinimumHealthyHostsPerZoneType' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHostsPerZone$type' => '<p>The <code>type</code> associated with the <code>MinimumHealthyHostsPerZone</code> option.</p>', ], ], 'MinimumHealthyHostsPerZoneValue' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHostsPerZone$value' => '<p>The <code>value</code> associated with the <code>MinimumHealthyHostsPerZone</code> option.</p>', ], ], 'MinimumHealthyHostsType' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHosts$type' => '<p>The minimum healthy instance type:</p> <ul> <li> <p> <code>HOST_COUNT</code>: The minimum number of healthy instances as an absolute value.</p> </li> <li> <p> <code>FLEET_PERCENT</code>: The minimum number of healthy instances as a percentage of the total number of instances in the deployment.</p> </li> </ul> <p>In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instances at a time. The deployment is successful if four or more instances are deployed to successfully. Otherwise, the deployment fails.</p> <note> <p>In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the <i>CodeDeploy User Guide</i>.</p>', ], ], 'MinimumHealthyHostsValue' => [ 'base' => NULL, 'refs' => [ 'MinimumHealthyHosts$value' => '<p>The minimum healthy instance value.</p>', ], ], 'MultipleIamArnsProvidedException' => [ 'base' => '<p>Both an user ARN and an IAM session ARN were included in the request. Use only one ARN type.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$nextToken' => '<p>An identifier returned from the previous <code>ListApplicationRevisions</code> call. It can be used to return the next set of applications in the list.</p>', 'ListApplicationRevisionsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list application revisions call to return the next set of application revisions in the list.</p>', 'ListApplicationsInput$nextToken' => '<p>An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list.</p>', 'ListApplicationsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list applications call to return the next set of applications in the list.</p>', 'ListDeploymentConfigsInput$nextToken' => '<p>An identifier returned from the previous <code>ListDeploymentConfigs</code> call. It can be used to return the next set of deployment configurations in the list. </p>', 'ListDeploymentConfigsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment configurations call to return the next set of deployment configurations in the list.</p>', 'ListDeploymentGroupsInput$nextToken' => '<p>An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list.</p>', 'ListDeploymentGroupsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment groups call to return the next set of deployment groups in the list.</p>', 'ListDeploymentInstancesInput$nextToken' => '<p>An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.</p>', 'ListDeploymentInstancesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployment instances call to return the next set of deployment instances in the list.</p>', 'ListDeploymentTargetsInput$nextToken' => '<p> A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return the next set of deployment targets in the list. </p>', 'ListDeploymentTargetsOutput$nextToken' => '<p> If a large amount of information is returned, a token identifier is also returned. It can be used in a subsequent <code>ListDeploymentTargets</code> call to return the next set of deployment targets in the list. </p>', 'ListDeploymentsInput$nextToken' => '<p>An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list.</p>', 'ListDeploymentsOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list deployments call to return the next set of deployments in the list.</p>', 'ListGitHubAccountTokenNamesInput$nextToken' => '<p>An identifier returned from the previous <code>ListGitHubAccountTokenNames</code> call. It can be used to return the next set of names in the list. </p>', 'ListGitHubAccountTokenNamesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent <code>ListGitHubAccountTokenNames</code> call to return the next set of names in the list. </p>', 'ListOnPremisesInstancesInput$nextToken' => '<p>An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list.</p>', 'ListOnPremisesInstancesOutput$nextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list on-premises instances call to return the next set of on-premises instances in the list.</p>', 'ListTagsForResourceInput$NextToken' => '<p>An identifier returned from the previous <code>ListTagsForResource</code> call. It can be used to return the next set of applications in the list.</p>', 'ListTagsForResourceOutput$NextToken' => '<p>If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list application revisions call to return the next set of application revisions in the list.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$terminationHookEnabled' => '<p>This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html">Integrating CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.</p> <p>Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination hook into your Auto Scaling group when you create a deployment group. When this hook is installed, CodeDeploy will perform termination deployments.</p> <p>For information about termination deployments, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable">Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User Guide</i>.</p> <p>For more information about Auto Scaling scale-in events, see the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in">Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'StopDeploymentInput$autoRollbackEnabled' => '<p> Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. </p>', 'UpdateDeploymentGroupInput$terminationHookEnabled' => '<p>This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html">Integrating CodeDeploy with Amazon EC2 Auto Scaling</a> in the <i>CodeDeploy User Guide</i>.</p> <p>Set <code>terminationHookEnabled</code> to <code>true</code> to have CodeDeploy install a termination hook into your Auto Scaling group when you update a deployment group. When this hook is installed, CodeDeploy will perform termination deployments.</p> <p>For information about termination deployments, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable">Enabling termination deployments during Auto Scaling scale-in events</a> in the <i>CodeDeploy User Guide</i>.</p> <p>For more information about Auto Scaling scale-in events, see the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in">Scale in</a> topic in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'OnPremisesTagSet' => [ 'base' => '<p>Information about groups of on-premises instance tags.</p>', 'refs' => [ 'CreateDeploymentGroupInput$onPremisesTagSet' => '<p>Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as <code>onPremisesInstanceTagFilters</code>.</p>', 'DeploymentGroupInfo$onPremisesTagSet' => '<p>Information about groups of tags applied to an on-premises instance. The deployment group includes only on-premises instances identified by all the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.</p>', 'UpdateDeploymentGroupInput$onPremisesTagSet' => '<p>Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.</p>', ], ], 'OnPremisesTagSetList' => [ 'base' => NULL, 'refs' => [ 'OnPremisesTagSet$onPremisesTagSetList' => '<p>A list that contains other lists of on-premises instance tag groups. For an instance to be included in the deployment group, it must be identified by all of the tag groups in the list.</p>', ], ], 'OperationNotSupportedException' => [ 'base' => '<p>The API used does not support the deployment.</p>', 'refs' => [], ], 'OutdatedInstancesStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$outdatedInstancesStrategy' => '<p>Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p> <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more \'auto-update outdated instances\' deployments to apply the deployed application revision to the new Amazon EC2 instances.</p> <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.</p>', 'DeploymentGroupInfo$outdatedInstancesStrategy' => '<p>Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p> <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more \'auto-update outdated instances\' deployments to apply the deployed application revision to the new Amazon EC2 instances.</p> <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.</p>', 'UpdateDeploymentGroupInput$outdatedInstancesStrategy' => '<p>Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.</p> <p>If this option is set to <code>UPDATE</code> or is unspecified, CodeDeploy initiates one or more \'auto-update outdated instances\' deployments to apply the deployed application revision to the new Amazon EC2 instances.</p> <p>If this option is set to <code>IGNORE</code>, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'TimeBasedCanary$canaryPercentage' => '<p>The percentage of traffic to shift in the first increment of a <code>TimeBasedCanary</code> deployment.</p>', 'TimeBasedLinear$linearPercentage' => '<p>The percentage of traffic that is shifted at the start of each increment of a <code>TimeBasedLinear</code> deployment.</p>', ], ], 'PutLifecycleEventHookExecutionStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecycleEventHookExecutionStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'RawString' => [ 'base' => '<p>A revision for an Lambda deployment that is a YAML-formatted or JSON-formatted string. For Lambda deployments, the revision is the same as the AppSpec file.</p>', 'refs' => [ 'RevisionLocation$string' => '<p>Information about the location of an Lambda deployment revision stored as a RawString.</p>', ], ], 'RawStringContent' => [ 'base' => NULL, 'refs' => [ 'AppSpecContent$content' => '<p> The YAML-formatted or JSON-formatted revision string. </p> <p> For an Lambda deployment, the content includes a Lambda function name, the alias for its original version, and the alias for its replacement version. The deployment shifts traffic from the original version of the Lambda function to the replacement version. </p> <p> For an Amazon ECS deployment, the content includes the task name, information about the load balancer that serves traffic to the container, and more. </p> <p> For both types of deployments, the content can specify Lambda functions that run at specified hooks, such as <code>BeforeInstall</code>, during a deployment. </p>', 'RawString$content' => '<p>The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to update and optional Lambda functions that validate deployment lifecycle events.</p>', ], ], 'RawStringSha256' => [ 'base' => NULL, 'refs' => [ 'AppSpecContent$sha256' => '<p> The SHA256 hash value of the revision content. </p>', 'RawString$sha256' => '<p>The SHA256 hash value of the revision content.</p>', ], ], 'RegisterApplicationRevisionInput' => [ 'base' => '<p>Represents the input of a RegisterApplicationRevision operation.</p>', 'refs' => [], ], 'RegisterOnPremisesInstanceInput' => [ 'base' => '<p>Represents the input of the register on-premises instance operation.</p>', 'refs' => [], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'ListOnPremisesInstancesInput$registrationStatus' => '<p>The registration status of the on-premises instances:</p> <ul> <li> <p> <code>Deregistered</code>: Include deregistered on-premises instances in the resulting list.</p> </li> <li> <p> <code>Registered</code>: Include registered on-premises instances in the resulting list.</p> </li> </ul>', ], ], 'RelatedDeployments' => [ 'base' => '<p>Information about deployments related to the specified deployment.</p>', 'refs' => [ 'DeploymentInfo$relatedDeployments' => NULL, ], ], 'RemoveTagsFromOnPremisesInstancesInput' => [ 'base' => '<p>Represents the input of a <code>RemoveTagsFromOnPremisesInstances</code> operation.</p>', 'refs' => [], ], 'Repository' => [ 'base' => NULL, 'refs' => [ 'GitHubLocation$repository' => '<p>The GitHub account and repository pair that stores a reference to the commit that represents the bundled artifacts for the application revision. </p> <p>Specified as account/repository.</p>', ], ], 'ResourceArnRequiredException' => [ 'base' => '<p> The ARN of a resource is required, but was not found. </p>', 'refs' => [], ], 'ResourceValidationException' => [ 'base' => '<p>The specified resource could not be validated.</p>', 'refs' => [], ], 'RevisionDoesNotExistException' => [ 'base' => '<p>The named revision does not exist with the user or Amazon Web Services account.</p>', 'refs' => [], ], 'RevisionInfo' => [ 'base' => '<p>Information about an application revision.</p>', 'refs' => [ 'RevisionInfoList$member' => NULL, ], ], 'RevisionInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsOutput$revisions' => '<p>Additional information about the revisions, including the type and location.</p>', ], ], 'RevisionLocation' => [ 'base' => '<p>Information about the location of an application revision.</p>', 'refs' => [ 'CreateDeploymentInput$revision' => '<p> The type and location of the revision to deploy. </p>', 'DeploymentGroupInfo$targetRevision' => '<p>Information about the deployment group\'s target revision, including type and location.</p>', 'DeploymentInfo$previousRevision' => '<p>Information about the application revision that was deployed to the deployment group before the most recent successful deployment.</p>', 'DeploymentInfo$revision' => '<p>Information about the location of stored application artifacts and the service from which to retrieve them.</p>', 'GetApplicationRevisionInput$revision' => '<p>Information about the application revision to get, including type and location.</p>', 'GetApplicationRevisionOutput$revision' => '<p>Additional information about the revision, including type and location.</p>', 'RegisterApplicationRevisionInput$revision' => '<p>Information about the application revision to register, including type and location.</p>', 'RevisionInfo$revisionLocation' => '<p>Information about the location and type of an application revision.</p>', 'RevisionLocationList$member' => NULL, ], ], 'RevisionLocationList' => [ 'base' => NULL, 'refs' => [ 'BatchGetApplicationRevisionsInput$revisions' => '<p>An array of <code>RevisionLocation</code> objects that specify information to get about the application revisions, including type and location. The maximum number of <code>RevisionLocation</code> objects you can specify is 25.</p>', 'ListApplicationRevisionsOutput$revisions' => '<p>A list of locations that contain the matching revisions.</p>', ], ], 'RevisionLocationType' => [ 'base' => NULL, 'refs' => [ 'RevisionLocation$revisionType' => '<p>The type of application revision:</p> <ul> <li> <p>S3: An application revision stored in Amazon S3.</p> </li> <li> <p>GitHub: An application revision stored in GitHub (EC2/On-premises deployments only).</p> </li> <li> <p>String: A YAML-formatted or JSON-formatted string (Lambda deployments only).</p> </li> <li> <p>AppSpecContent: An <code>AppSpecContent</code> object that contains the contents of an AppSpec file for an Lambda or Amazon ECS deployment. The content is formatted as JSON or YAML stored as a RawString.</p> </li> </ul>', ], ], 'RevisionRequiredException' => [ 'base' => '<p>The revision ID was not specified.</p>', 'refs' => [], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$serviceRoleArn' => '<p>A service role Amazon Resource Name (ARN) that allows CodeDeploy to act on the user\'s behalf when interacting with Amazon Web Services services.</p>', 'DeploymentGroupInfo$serviceRoleArn' => '<p>A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to make calls to Amazon Web Services services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html">Create a Service Role for CodeDeploy</a> in the <i>CodeDeploy User Guide</i>.</p>', 'UpdateDeploymentGroupInput$serviceRoleArn' => '<p>A replacement ARN for the service role, if you want to change it.</p>', ], ], 'RoleRequiredException' => [ 'base' => '<p>The role ID was not specified.</p>', 'refs' => [], ], 'RollbackInfo' => [ 'base' => '<p>Information about a deployment rollback.</p>', 'refs' => [ 'DeploymentInfo$rollbackInfo' => '<p>Information about a deployment rollback.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$s3Bucket' => '<p> An Amazon S3 bucket name to limit the search for revisions. </p> <p> If set to null, all of the user\'s buckets are searched. </p>', 'S3Location$bucket' => '<p>The name of the Amazon S3 bucket where the application revision is stored.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$s3KeyPrefix' => '<p> A key prefix for the set of Amazon S3 objects to limit the search for revisions. </p>', 'S3Location$key' => '<p>The name of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>', ], ], 'S3Location' => [ 'base' => '<p>Information about the location of application artifacts stored in Amazon S3.</p>', 'refs' => [ 'RevisionLocation$s3Location' => '<p>Information about the location of a revision stored in Amazon S3. </p>', ], ], 'ScriptName' => [ 'base' => NULL, 'refs' => [ 'Diagnostics$scriptName' => '<p>The name of the script.</p>', ], ], 'SkipWaitTimeForInstanceTerminationInput' => [ 'base' => NULL, 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListApplicationRevisionsInput$sortOrder' => '<p> The order in which to sort the list results: </p> <ul> <li> <p> <code>ascending</code>: ascending order.</p> </li> <li> <p> <code>descending</code>: descending order.</p> </li> </ul> <p>If not specified, the results are sorted in ascending order.</p> <p>If set to null, the results are sorted in an arbitrary order.</p>', ], ], 'StopDeploymentInput' => [ 'base' => '<p> Represents the input of a <code>StopDeployment</code> operation. </p>', 'refs' => [], ], 'StopDeploymentOutput' => [ 'base' => '<p> Represents the output of a <code>StopDeployment</code> operation. </p>', 'refs' => [], ], 'StopStatus' => [ 'base' => NULL, 'refs' => [ 'StopDeploymentOutput$status' => '<p>The status of the stop deployment operation:</p> <ul> <li> <p>Pending: The stop operation is pending.</p> </li> <li> <p>Succeeded: The stop operation was successful.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagFilter' => [ 'base' => '<p>Information about an on-premises instance tag filter.</p>', 'refs' => [ 'TagFilterList$member' => NULL, ], ], 'TagFilterList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$onPremisesInstanceTagFilters' => '<p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as <code>OnPremisesTagSet</code>.</p>', 'DeploymentGroupInfo$onPremisesInstanceTagFilters' => '<p>The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags.</p>', 'ListOnPremisesInstancesInput$tagFilters' => '<p>The on-premises instance tags that are used to restrict the on-premises instance names returned.</p>', 'OnPremisesTagSetList$member' => NULL, 'UpdateDeploymentGroupInput$onPremisesInstanceTagFilters' => '<p>The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.</p>', ], ], 'TagFilterType' => [ 'base' => NULL, 'refs' => [ 'TagFilter$Type' => '<p>The on-premises instance tag filter type:</p> <ul> <li> <p>KEY_ONLY: Key only.</p> </li> <li> <p>VALUE_ONLY: Value only.</p> </li> <li> <p>KEY_AND_VALUE: Key and value.</p> </li> </ul>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p> A list of keys of <code>Tag</code> objects. The <code>Tag</code> objects identified by the keys are disassociated from the resource specified by the <code>ResourceArn</code> input parameter. </p>', ], ], 'TagLimitExceededException' => [ 'base' => '<p>The maximum allowed number of tags was exceeded.</p>', 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToOnPremisesInstancesInput$tags' => '<p>The tag key-value pairs to add to the on-premises instances.</p> <p>Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.</p>', 'CreateApplicationInput$tags' => '<p> The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>', 'CreateDeploymentGroupInput$tags' => '<p> The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. </p>', 'InstanceInfo$tags' => '<p>The tags currently associated with the on-premises instance.</p>', 'ListTagsForResourceOutput$Tags' => '<p> A list of tags returned by <code>ListTagsForResource</code>. The tags are associated with the resource identified by the input <code>ResourceArn</code> parameter. </p>', 'RemoveTagsFromOnPremisesInstancesInput$tags' => '<p>The tag key-value pairs to remove from the on-premises instances.</p>', 'TagResourceInput$Tags' => '<p> A list of tags that <code>TagResource</code> associates with a resource. The resource is identified by the <code>ResourceArn</code> input parameter. </p>', ], ], 'TagRequiredException' => [ 'base' => '<p>A tag was not specified.</p>', 'refs' => [], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagSetListLimitExceededException' => [ 'base' => '<p>The number of tag groups included in the tag set list exceeded the maximum allowed limit of 3.</p>', 'refs' => [], ], 'TargetArn' => [ 'base' => NULL, 'refs' => [ 'ECSTarget$targetArn' => '<p> The Amazon Resource Name (ARN) of the target. </p>', 'InstanceTarget$targetArn' => '<p> The Amazon Resource Name (ARN) of the target. </p>', 'LambdaTarget$targetArn' => '<p> The Amazon Resource Name (ARN) of the target. </p>', ], ], 'TargetFilterName' => [ 'base' => NULL, 'refs' => [ 'TargetFilters$key' => NULL, ], ], 'TargetFilters' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentTargetsInput$targetFilters' => '<p> A key used to filter the returned targets. The two valid values are:</p> <ul> <li> <p> <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>, <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>, or <code>Unknown</code>. </p> </li> <li> <p> <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or <code>Green</code>. </p> </li> </ul>', ], ], 'TargetGroupInfo' => [ 'base' => '<p>Information about a target group in Elastic Load Balancing to use in a deployment. Instances are registered as targets in a target group, and traffic is routed to the target group.</p>', 'refs' => [ 'ECSTaskSet$targetGroup' => '<p> The target group associated with the task set. The target group is used by CodeDeploy to manage traffic to a task set. </p>', 'TargetGroupInfoList$member' => NULL, ], ], 'TargetGroupInfoList' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerInfo$targetGroupInfoList' => '<p>An array that contains information about the target groups to use for load balancing in a deployment. If you\'re using Application Load Balancers and Network Load Balancers, specify their associated target groups in this array.</p> <note> <p>You can add up to 10 target groups to the array.</p> </note> <note> <p>If you\'re using Classic Load Balancers, use the <code>elbInfoList</code> array instead of this one.</p> </note>', 'TargetGroupPairInfo$targetGroups' => '<p> One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete. </p>', ], ], 'TargetGroupName' => [ 'base' => NULL, 'refs' => [ 'TargetGroupInfo$name' => '<p>For blue/green deployments, the name of the target group that instances in the original environment are deregistered from, and instances in the replacement environment are registered with. For in-place deployments, the name of the target group that instances are deregistered from, so they are not serving traffic during a deployment, and then re-registered with after the deployment is complete. </p>', ], ], 'TargetGroupPairInfo' => [ 'base' => '<p> Information about two target groups and how traffic is routed during an Amazon ECS deployment. An optional test traffic route can be specified. </p>', 'refs' => [ 'TargetGroupPairInfoList$member' => NULL, ], ], 'TargetGroupPairInfoList' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerInfo$targetGroupPairInfoList' => '<p> The target group pair information. This is an array of <code>TargeGroupPairInfo</code> objects with a maximum size of one. </p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$targetId' => '<p> The unique ID of a deployment target that has a type of <code>CloudFormationTarget</code>. </p>', 'ECSTarget$targetId' => '<p> The unique ID of a deployment target that has a type of <code>ecsTarget</code>. </p>', 'GetDeploymentTargetInput$targetId' => '<p> The unique ID of a deployment target. </p>', 'InstanceTarget$targetId' => '<p> The unique ID of a deployment target that has a type of <code>instanceTarget</code>. </p>', 'LambdaTarget$targetId' => '<p> The unique ID of a deployment target that has a type of <code>lambdaTarget</code>. </p>', 'TargetIdList$member' => NULL, ], ], 'TargetIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDeploymentTargetsInput$targetIds' => '<p> The unique IDs of the deployment targets. The compute platform of the deployment determines the type of the targets and their formats. The maximum number of deployment target IDs you can specify is 25.</p> <ul> <li> <p> For deployments that use the EC2/On-premises compute platform, the target IDs are Amazon EC2 or on-premises instances IDs, and their target type is <code>instanceTarget</code>. </p> </li> <li> <p> For deployments that use the Lambda compute platform, the target IDs are the names of Lambda functions, and their target type is <code>instanceTarget</code>. </p> </li> <li> <p> For deployments that use the Amazon ECS compute platform, the target IDs are pairs of Amazon ECS clusters and services specified using the format <code>&lt;clustername&gt;:&lt;servicename&gt;</code>. Their target type is <code>ecsTarget</code>. </p> </li> <li> <p> For deployments that are deployed with CloudFormation, the target IDs are CloudFormation stack IDs. Their target type is <code>cloudFormationTarget</code>. </p> </li> </ul>', 'ListDeploymentTargetsOutput$targetIds' => '<p> The unique IDs of deployment targets. </p>', ], ], 'TargetInstances' => [ 'base' => '<p>Information about the instances to be used in the replacement environment in a blue/green deployment.</p>', 'refs' => [ 'CreateDeploymentInput$targetInstances' => '<p> Information about the instances that belong to the replacement environment in a blue/green deployment. </p>', 'DeploymentInfo$targetInstances' => '<p>Information about the instances that belong to the replacement environment in a blue/green deployment.</p>', ], ], 'TargetLabel' => [ 'base' => NULL, 'refs' => [ 'ECSTaskSet$taskSetLabel' => '<p> A label that identifies whether the ECS task set is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>', 'InstanceTarget$instanceLabel' => '<p> A label that identifies whether the instance is an original target (<code>BLUE</code>) or a replacement target (<code>GREEN</code>). </p>', ], ], 'TargetStatus' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$status' => '<p> The status of an CloudFormation blue/green deployment\'s target application. </p>', 'ECSTarget$status' => '<p> The status an Amazon ECS deployment\'s target ECS application. </p>', 'InstanceTarget$status' => '<p> The status an EC2/On-premises deployment\'s target instance. </p>', 'LambdaTarget$status' => '<p> The status an Lambda deployment\'s target Lambda function. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>An API function was called too frequently.</p>', 'refs' => [], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$lastUpdatedAt' => '<p> The date and time when the target application was updated by an CloudFormation blue/green deployment. </p>', 'ECSTarget$lastUpdatedAt' => '<p> The date and time when the target Amazon ECS application was updated by a deployment. </p>', 'InstanceTarget$lastUpdatedAt' => '<p> The date and time when the target instance was updated by a deployment. </p>', 'LambdaTarget$lastUpdatedAt' => '<p> The date and time when the target Lambda function was updated by a deployment. </p>', ], ], 'TimeBasedCanary' => [ 'base' => '<p>A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment\'s AppSpec file.</p>', 'refs' => [ 'TrafficRoutingConfig$timeBasedCanary' => '<p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment\'s AppSpec file.</p>', ], ], 'TimeBasedLinear' => [ 'base' => '<p>A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or ECS task sets are specified in the deployment\'s AppSpec file.</p>', 'refs' => [ 'TrafficRoutingConfig$timeBasedLinear' => '<p>A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment\'s AppSpec file.</p>', ], ], 'TimeRange' => [ 'base' => '<p>Information about a time range.</p>', 'refs' => [ 'ListDeploymentsInput$createTimeRange' => '<p>A time range (start and end) for returning a subset of the list of deployments.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$createTime' => '<p>The time at which the application was created.</p>', 'DeploymentConfigInfo$createTime' => '<p>The time at which the deployment configuration was created.</p>', 'DeploymentInfo$createTime' => '<p>A timestamp that indicates when the deployment was created.</p>', 'DeploymentInfo$startTime' => '<p>A timestamp that indicates when the deployment was deployed to the deployment group.</p> <p>In some cases, the reported value of the start time might be later than the complete time. This is due to differences in the clock settings of backend servers that participate in the deployment process.</p>', 'DeploymentInfo$completeTime' => '<p>A timestamp that indicates when the deployment was complete.</p>', 'GenericRevisionInfo$firstUsedTime' => '<p>When the revision was first used by CodeDeploy.</p>', 'GenericRevisionInfo$lastUsedTime' => '<p>When the revision was last used by CodeDeploy.</p>', 'GenericRevisionInfo$registerTime' => '<p>When the revision was registered with CodeDeploy.</p>', 'InstanceInfo$registerTime' => '<p>The time at which the on-premises instance was registered.</p>', 'InstanceInfo$deregisterTime' => '<p>If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.</p>', 'InstanceSummary$lastUpdatedAt' => '<p>A timestamp that indicates when the instance information was last updated.</p>', 'LastDeploymentInfo$endTime' => '<p>A timestamp that indicates when the most recent deployment to the deployment group was complete.</p>', 'LastDeploymentInfo$createTime' => '<p>A timestamp that indicates when the most recent deployment to the deployment group started.</p>', 'LifecycleEvent$startTime' => '<p>A timestamp that indicates when the deployment lifecycle event started.</p>', 'LifecycleEvent$endTime' => '<p>A timestamp that indicates when the deployment lifecycle event ended.</p>', 'TimeRange$start' => '<p>The start time of the time range.</p> <note> <p>Specify null to leave the start time open-ended.</p> </note>', 'TimeRange$end' => '<p>The end time of the time range.</p> <note> <p>Specify null to leave the end time open-ended.</p> </note>', ], ], 'TrafficRoute' => [ 'base' => '<p> Information about a listener. The listener contains the path used to route traffic that is received from the load balancer to a target group. </p>', 'refs' => [ 'TargetGroupPairInfo$prodTrafficRoute' => '<p> The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete. </p>', 'TargetGroupPairInfo$testTrafficRoute' => '<p> An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment. </p>', ], ], 'TrafficRoutingConfig' => [ 'base' => '<p>The configuration that specifies how traffic is shifted from one version of a Lambda function to another version during an Lambda deployment, or from one Amazon ECS task set to another during an Amazon ECS deployment.</p>', 'refs' => [ 'CreateDeploymentConfigInput$trafficRoutingConfig' => '<p>The configuration that specifies how the deployment traffic is routed.</p>', 'DeploymentConfigInfo$trafficRoutingConfig' => '<p>The configuration that specifies how the deployment traffic is routed. Used for deployments with a Lambda or Amazon ECS compute platform only.</p>', ], ], 'TrafficRoutingType' => [ 'base' => NULL, 'refs' => [ 'TrafficRoutingConfig$type' => '<p>The type of traffic shifting (<code>TimeBasedCanary</code> or <code>TimeBasedLinear</code>) used by a deployment configuration.</p>', ], ], 'TrafficWeight' => [ 'base' => NULL, 'refs' => [ 'CloudFormationTarget$targetVersionWeight' => '<p>The percentage of production traffic that the target version of an CloudFormation blue/green deployment receives.</p>', 'ECSTaskSet$trafficWeight' => '<p> The percentage of traffic served by this task set. </p>', 'LambdaFunctionInfo$targetVersionWeight' => '<p> The percentage of production traffic that the target version of a Lambda function receives. </p>', ], ], 'TriggerConfig' => [ 'base' => '<p>Information about notification triggers for the deployment group.</p>', 'refs' => [ 'TriggerConfigList$member' => NULL, ], ], 'TriggerConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentGroupInput$triggerConfigurations' => '<p>Information about triggers to create when the deployment group is created. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html">Create a Trigger for an CodeDeploy Event</a> in the <i>CodeDeploy User Guide</i>.</p>', 'DeploymentGroupInfo$triggerConfigurations' => '<p>Information about triggers associated with the deployment group.</p>', 'UpdateDeploymentGroupInput$triggerConfigurations' => '<p>Information about triggers to change when the deployment group is updated. For examples, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Edit a Trigger in a CodeDeploy Deployment Group</a> in the <i>CodeDeploy User Guide</i>.</p>', ], ], 'TriggerEventType' => [ 'base' => NULL, 'refs' => [ 'TriggerEventTypeList$member' => NULL, ], ], 'TriggerEventTypeList' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerEvents' => '<p>The event type or types for which notifications are triggered.</p>', ], ], 'TriggerName' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerName' => '<p>The name of the notification trigger.</p>', ], ], 'TriggerTargetArn' => [ 'base' => NULL, 'refs' => [ 'TriggerConfig$triggerTargetArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about deployment or instance events are sent.</p>', ], ], 'TriggerTargetsLimitExceededException' => [ 'base' => '<p>The maximum allowed number of triggers was exceeded.</p>', 'refs' => [], ], 'UnsupportedActionForDeploymentTypeException' => [ 'base' => '<p>A call was submitted that is not supported for the specified deployment type.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationInput' => [ 'base' => '<p>Represents the input of an <code>UpdateApplication</code> operation.</p>', 'refs' => [], ], 'UpdateDeploymentGroupInput' => [ 'base' => '<p>Represents the input of an <code>UpdateDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'UpdateDeploymentGroupOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateDeploymentGroup</code> operation.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'EC2TagFilter$Value' => '<p>The tag filter value.</p>', 'Tag$Value' => '<p>The tag\'s value.</p>', 'TagFilter$Value' => '<p>The on-premises instance tag filter value.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionInfo$currentVersion' => '<p> The version of a Lambda function that production traffic points to. </p>', 'LambdaFunctionInfo$targetVersion' => '<p> The version of a Lambda function that production traffic points to after the Lambda function is deployed. </p>', ], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'S3Location$version' => '<p>A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.</p> <p>If the version is not specified, the system uses the most recent version by default.</p>', ], ], 'WaitTimeInMins' => [ 'base' => NULL, 'refs' => [ 'TimeBasedCanary$canaryInterval' => '<p>The number of minutes between the first and second traffic shifts of a <code>TimeBasedCanary</code> deployment.</p>', 'TimeBasedLinear$linearInterval' => '<p>The number of minutes between each incremental traffic shift of a <code>TimeBasedLinear</code> deployment.</p>', ], ], 'WaitTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'ZonalConfig$firstZoneMonitorDurationInSeconds' => '<p>The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the <i>first</i> Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the second Availability Zone. You might set this option if you want to allow extra bake time for the first Availability Zone. If you don\'t specify a value for <code>firstZoneMonitorDurationInSeconds</code>, then CodeDeploy uses the <code>monitorDurationInSeconds</code> value for the first Availability Zone.</p> <p>For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <i>CodeDeploy User Guide</i>.</p>', 'ZonalConfig$monitorDurationInSeconds' => '<p>The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the next Availability Zone. Consider adding a monitor duration to give the deployment some time to prove itself (or \'bake\') in one Availability Zone before it is released in the next zone. If you don\'t specify a <code>monitorDurationInSeconds</code>, CodeDeploy starts deploying to the next Availability Zone immediately.</p> <p>For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <i>CodeDeploy User Guide</i>.</p>', ], ], 'ZonalConfig' => [ 'base' => '<p>Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones">Availability Zone</a> at a time, within an Amazon Web Services Region. By deploying to one Availability Zone at a time, you can expose your deployment to a progressively larger audience as confidence in the deployment\'s performance and viability grows. If you don\'t configure the <code>ZonalConfig</code> object, CodeDeploy deploys your application to a random selection of hosts across a Region.</p> <p>For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <i>CodeDeploy User Guide</i>.</p>', 'refs' => [ 'CreateDeploymentConfigInput$zonalConfig' => '<p>Configure the <code>ZonalConfig</code> object if you want CodeDeploy to deploy your application to one <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones">Availability Zone</a> at a time, within an Amazon Web Services Region.</p> <p>For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <i>CodeDeploy User Guide</i>.</p>', 'DeploymentConfigInfo$zonalConfig' => '<p>Information about a zonal configuration.</p>', ], ], ],];
