<?php
// This file was auto-generated from sdk-root/src/data/connectcases/2022-10-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>With Amazon Connect Cases, your agents can track and manage customer issues that require multiple interactions, follow-up tasks, and teams in your contact center. A case represents a customer issue. It records the issue, the steps and interactions taken to resolve the issue, and the outcome. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Amazon Connect Cases</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'operations' => [ 'BatchGetField' => '<p>Returns the description for the list of fields in the request parameters. </p>', 'BatchPutFieldOptions' => '<p>Creates and updates a set of field options for a single select field in a Cases domain.</p>', 'CreateCase' => '<note> <p>If you provide a value for <code>PerformedBy.UserArn</code> you must also have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html">connect:DescribeUser</a> permission on the User ARN resource that you provide</p> </note> <pre><code> &lt;p&gt;Creates a case in the specified Cases domain. Case system and custom fields are taken as an array id/value pairs with a declared data types.&lt;/p&gt; &lt;p&gt;The following fields are required when creating a case:&lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;customer_id&lt;/code&gt; - You must provide the full customer profile ARN in this format: &lt;code&gt;arn:aws:profile:your_AWS_Region:your_AWS_account ID:domains/your_profiles_domain_name/profiles/profile_ID&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;title&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code></pre>', 'CreateDomain' => '<p>Creates a domain, which is a container for all case data, such as cases, fields, templates and layouts. Each Amazon Connect instance can be associated with only one Cases domain.</p> <important> <p>This will not associate your connect instance to Cases domain. Instead, use the Amazon Connect <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html">CreateIntegrationAssociation</a> API. You need specific IAM permissions to successfully associate the Cases domain. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/required-permissions-iam-cases.html#onboard-cases-iam">Onboard to Cases</a>.</p> <pre><code> &lt;/important&gt; </code></pre>', 'CreateField' => '<p>Creates a field in the Cases domain. This field is used to define the case object model (that is, defines what data can be captured on cases) in a Cases domain. </p>', 'CreateLayout' => '<p>Creates a layout in the Cases domain. Layouts define the following configuration in the top section and More Info tab of the Cases user interface:</p> <ul> <li> <p>Fields to display to the users</p> </li> <li> <p>Field ordering</p> </li> </ul> <note> <p>Title and Status fields cannot be part of layouts since they are not configurable.</p> </note>', 'CreateRelatedItem' => '<p>Creates a related item (comments, tasks, and contacts) and associates it with a case.</p> <note> <ul> <li> <p>A Related Item is a resource that is associated with a case. It may or may not have an external identifier linking it to an external resource (for example, a <code>contactArn</code>). All Related Items have their own internal identifier, the <code>relatedItemArn</code>. Examples of related items include <code>comments</code> and <code>contacts</code>.</p> </li> <li> <p>If you provide a value for <code>performedBy.userArn</code> you must also have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html">DescribeUser</a> permission on the ARN of the user that you provide.</p> </li> </ul> <pre><code> &lt;/note&gt; </code></pre>', 'CreateTemplate' => '<p>Creates a template in the Cases domain. This template is used to define the case object model (that is, to define what data can be captured on cases) in a Cases domain. A template must have a unique name within a domain, and it must reference existing field IDs and layout IDs. Additionally, multiple fields with same IDs are not allowed within the same Template. A template can be either Active or Inactive, as indicated by its status. Inactive templates cannot be used to create cases.</p>', 'DeleteDomain' => '<p>Deletes a Cases domain.</p> <pre><code> &lt;note&gt; &lt;p&gt;After deleting your domain you must disassociate the deleted domain from your Amazon Connect instance with another API call before being able to use Cases again with this Amazon Connect instance. See &lt;a href=&quot;https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteIntegrationAssociation.html&quot;&gt;DeleteIntegrationAssociation&lt;/a&gt;.&lt;/p&gt; &lt;/note&gt; </code></pre>', 'DeleteField' => '<p>Deletes a field from a cases template. You can delete up to 100 fields per domain.</p> <p>After a field is deleted:</p> <ul> <li> <p>You can still retrieve the field by calling <code>BatchGetField</code>.</p> </li> <li> <p>You cannot update a deleted field by calling <code>UpdateField</code>; it throws a <code>ValidationException</code>.</p> </li> <li> <p>Deleted fields are not included in the <code>ListFields</code> response.</p> </li> <li> <p>Calling <code>CreateCase</code> with a deleted field throws a <code>ValidationException</code> denoting which field IDs in the request have been deleted.</p> </li> <li> <p>Calling <code>GetCase</code> with a deleted field ID returns the deleted field\'s value if one exists.</p> </li> <li> <p>Calling <code>UpdateCase</code> with a deleted field ID throws a <code>ValidationException</code> if the case does not already contain a value for the deleted field. Otherwise it succeeds, allowing you to update or remove (using <code>emptyValue: {}</code>) the field\'s value from the case.</p> </li> <li> <p> <code>GetTemplate</code> does not return field IDs for deleted fields.</p> </li> <li> <p> <code>GetLayout</code> does not return field IDs for deleted fields.</p> </li> <li> <p>Calling <code>SearchCases</code> with the deleted field ID as a filter returns any cases that have a value for the deleted field that matches the filter criteria.</p> </li> <li> <p>Calling <code>SearchCases</code> with a <code>searchTerm</code> value that matches a deleted field\'s value on a case returns the case in the response.</p> </li> <li> <p>Calling <code>BatchPutFieldOptions</code> with a deleted field ID throw a <code>ValidationException</code>.</p> </li> <li> <p>Calling <code>GetCaseEventConfiguration</code> does not return field IDs for deleted fields.</p> </li> </ul>', 'DeleteLayout' => '<p>Deletes a layout from a cases template. You can delete up to 100 layouts per domain.</p> <pre><code> &lt;p&gt;After a layout is deleted:&lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;You can still retrieve the layout by calling &lt;code&gt;GetLayout&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You cannot update a deleted layout by calling &lt;code&gt;UpdateLayout&lt;/code&gt;; it throws a &lt;code&gt;ValidationException&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;Deleted layouts are not included in the &lt;code&gt;ListLayouts&lt;/code&gt; response.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code></pre>', 'DeleteTemplate' => '<p>Deletes a cases template. You can delete up to 100 templates per domain.</p> <pre><code> &lt;p&gt;After a cases template is deleted:&lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt;You can still retrieve the template by calling &lt;code&gt;GetTemplate&lt;/code&gt;.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You cannot update the template. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;You cannot create a case by using the deleted template.&lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt;Deleted templates are not included in the &lt;code&gt;ListTemplates&lt;/code&gt; response.&lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code></pre>', 'GetCase' => '<p>Returns information about a specific case if it exists. </p>', 'GetCaseAuditEvents' => '<p>Returns the audit history about a specific case if it exists.</p>', 'GetCaseEventConfiguration' => '<p>Returns the case event publishing configuration.</p>', 'GetDomain' => '<p>Returns information about a specific domain if it exists. </p>', 'GetLayout' => '<p>Returns the details for the requested layout.</p>', 'GetTemplate' => '<p>Returns the details for the requested template. </p>', 'ListCasesForContact' => '<p>Lists cases for a given contact.</p>', 'ListDomains' => '<p>Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the domain.</p>', 'ListFieldOptions' => '<p>Lists all of the field options for a field identifier in the domain. </p>', 'ListFields' => '<p>Lists all fields in a Cases domain.</p>', 'ListLayouts' => '<p>Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.</p>', 'ListTagsForResource' => '<p>Lists tags for a resource.</p>', 'ListTemplates' => '<p>Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template. </p>', 'PutCaseEventConfiguration' => '<p>Adds case event publishing configuration. For a complete list of fields you can add to the event message, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/case-fields.html">Create case fields</a> in the <i>Amazon Connect Administrator Guide</i> </p>', 'SearchCases' => '<p>Searches for cases within their associated Cases domain. Search results are returned as a paginated list of abridged case documents.</p> <note> <p>For <code>customer_id</code> you must provide the full customer profile ARN in this format: <code> arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID</code>. </p> </note>', 'SearchRelatedItems' => '<p>Searches for related items that are associated with a case.</p> <note> <p>If no filters are provided, this returns all related items associated with a case.</p> </note>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UntagResource' => '<p>Untags a resource.</p>', 'UpdateCase' => '<note> <p>If you provide a value for <code>PerformedBy.UserArn</code> you must also have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html">connect:DescribeUser</a> permission on the User ARN resource that you provide</p> </note> <pre><code> &lt;p&gt;Updates the values of fields on a case. Fields to be updated are received as an array of id/value pairs identical to the &lt;code&gt;CreateCase&lt;/code&gt; input .&lt;/p&gt; &lt;p&gt;If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.&lt;/p&gt; </code></pre>', 'UpdateField' => '<p>Updates the properties of an existing field. </p>', 'UpdateLayout' => '<p>Updates the attributes of an existing layout.</p> <p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p> <p>A <code>ValidationException</code> is returned when you add non-existent <code>fieldIds</code> to a layout.</p> <note> <p>Title and Status fields cannot be part of layouts because they are not configurable.</p> </note>', 'UpdateTemplate' => '<p>Updates the attributes of an existing template. The template attributes that can be modified include <code>name</code>, <code>description</code>, <code>layoutConfiguration</code>, <code>requiredFields</code>, and <code>status</code>. At least one of these attributes must not be null. If a null value is provided for a given attribute, that attribute is ignored and its current value is preserved.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$arn' => '<p>The Amazon Resource Name (ARN)</p>', 'TagResourceRequest$arn' => '<p>The Amazon Resource Name (ARN)</p>', 'UntagResourceRequest$arn' => '<p>The Amazon Resource Name (ARN)</p>', ], ], 'AssociationTime' => [ 'base' => NULL, 'refs' => [ 'SearchRelatedItemsResponseItem$associationTime' => '<p>Time at which a related item was associated with a case.</p>', ], ], 'AuditEvent' => [ 'base' => '<p>Represents the content of a particular audit event.</p>', 'refs' => [ 'GetCaseAuditEventsResponseAuditEventsList$member' => NULL, ], ], 'AuditEventDateTime' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$performedTime' => '<p>Time at which an Audit History event took place.</p>', ], ], 'AuditEventField' => [ 'base' => '<p>Fields for audit event.</p>', 'refs' => [ 'AuditEventFieldList$member' => NULL, ], ], 'AuditEventFieldId' => [ 'base' => NULL, 'refs' => [ 'AuditEventField$eventFieldId' => '<p>Unique identifier of field in an Audit History entry.</p>', ], ], 'AuditEventFieldList' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$fields' => '<p>A list of Case Audit History event fields.</p>', ], ], 'AuditEventFieldValueUnion' => [ 'base' => '<p>Object to store union of Field values.</p>', 'refs' => [ 'AuditEventField$newValue' => '<p>Union of potential field value types.</p>', 'AuditEventField$oldValue' => '<p>Union of potential field value types.</p>', ], ], 'AuditEventFieldValueUnionStringValueString' => [ 'base' => NULL, 'refs' => [ 'AuditEventFieldValueUnion$stringValue' => '<p>Can be either null, or have a String value type. Only one value can be provided.</p>', ], ], 'AuditEventId' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$eventId' => '<p>Unique identifier of a case audit history event.</p>', ], ], 'AuditEventPerformedBy' => [ 'base' => '<p>Information of the user which performed the audit.</p>', 'refs' => [ 'AuditEvent$performedBy' => '<p>Information of the user which performed the audit.</p>', ], ], 'AuditEventType' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$type' => '<p>The Type of an audit history event.</p>', ], ], 'BasicLayout' => [ 'base' => '<p>Content specific to <code>BasicLayout</code> type. It configures fields in the top panel and More Info tab of agent application. </p>', 'refs' => [ 'LayoutContent$basic' => '<p>Content specific to <code>BasicLayout</code> type. It configures fields in the top panel and More Info tab of Cases user interface.</p>', ], ], 'BatchGetFieldIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFieldRequest$fields' => '<p>A list of unique field identifiers. </p>', ], ], 'BatchGetFieldRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFieldResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFieldResponseErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFieldResponse$errors' => '<p>A list of field errors. </p>', ], ], 'BatchGetFieldResponseFieldsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFieldResponse$fields' => '<p>A list of detailed field information. </p>', ], ], 'BatchPutFieldOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutFieldOptionsRequestOptionsList' => [ 'base' => NULL, 'refs' => [ 'BatchPutFieldOptionsRequest$options' => '<p>A list of <code>FieldOption</code> objects.</p>', ], ], 'BatchPutFieldOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutFieldOptionsResponseErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchPutFieldOptionsResponse$errors' => '<p>A list of field errors. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AuditEventFieldValueUnion$booleanValue' => '<p>Can be either null, or have a Boolean value type. Only one value can be provided.</p>', 'EventBridgeConfiguration$enabled' => '<p>Indicates whether the to broadcast case event data to the customer.</p>', 'FieldOption$active' => '<p>Describes whether the <code>FieldOption</code> is active (displayed) or inactive.</p>', 'FieldValueUnion$booleanValue' => '<p>Can be either null, or have a Boolean value type. Only one value can be provided.</p>', 'RelatedItemEventIncludedData$includeContent' => '<p>Details of what related item data is published through the case event stream.</p>', ], ], 'CaseArn' => [ 'base' => NULL, 'refs' => [ 'CreateCaseResponse$caseArn' => '<p>The Amazon Resource Name (ARN) of the case.</p>', ], ], 'CaseEventIncludedData' => [ 'base' => '<p>Details of what case data is published through the case event stream.</p>', 'refs' => [ 'EventIncludedData$caseData' => '<p>Details of what case data is published through the case event stream.</p>', ], ], 'CaseEventIncludedDataFieldsList' => [ 'base' => NULL, 'refs' => [ 'CaseEventIncludedData$fields' => '<p>List of field identifiers.</p>', ], ], 'CaseFilter' => [ 'base' => '<p>A filter for cases. Only one value can be provided.</p>', 'refs' => [ 'CaseFilter$not' => NULL, 'CaseFilterAndAllList$member' => NULL, 'CaseFilterOrAllList$member' => NULL, 'SearchCasesRequest$filter' => '<p>A list of filter objects.</p>', ], ], 'CaseFilterAndAllList' => [ 'base' => NULL, 'refs' => [ 'CaseFilter$andAll' => '<p>Provides "and all" filtering.</p>', ], ], 'CaseFilterOrAllList' => [ 'base' => NULL, 'refs' => [ 'CaseFilter$orAll' => '<p>Provides "or all" filtering.</p>', ], ], 'CaseId' => [ 'base' => NULL, 'refs' => [ 'CaseSummary$caseId' => '<p>A unique identifier of the case.</p>', 'CreateCaseResponse$caseId' => '<p>A unique identifier of the case.</p>', 'CreateRelatedItemRequest$caseId' => '<p>A unique identifier of the case.</p>', 'GetCaseAuditEventsRequest$caseId' => '<p>A unique identifier of the case.</p>', 'GetCaseRequest$caseId' => '<p>A unique identifier of the case.</p>', 'SearchCasesResponseItem$caseId' => '<p>A unique identifier of the case.</p>', 'SearchRelatedItemsRequest$caseId' => '<p>A unique identifier of the case.</p>', 'UpdateCaseRequest$caseId' => '<p>A unique identifier of the case.</p>', ], ], 'CaseSummary' => [ 'base' => '<p>Case summary information.</p>', 'refs' => [ 'ListCasesForContactResponseCasesList$member' => NULL, ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'ContactContent$channel' => '<p>A list of channels to filter on for related items of type <code>Contact</code>.</p>', 'ContactFilterChannelList$member' => NULL, ], ], 'CommentBody' => [ 'base' => NULL, 'refs' => [ 'CommentContent$body' => '<p>Text in the body of a <code>Comment</code> on a case.</p>', ], ], 'CommentBodyTextType' => [ 'base' => NULL, 'refs' => [ 'CommentContent$contentType' => '<p>Type of the text in the box of a <code>Comment</code> on a case.</p>', ], ], 'CommentContent' => [ 'base' => '<p>Represents the content of a <code>Comment</code> to be returned to agents.</p>', 'refs' => [ 'RelatedItemContent$comment' => '<p>Represents the content of a comment to be returned to agents.</p>', 'RelatedItemInputContent$comment' => '<p>Represents the content of a comment to be returned to agents.</p>', ], ], 'CommentFilter' => [ 'base' => '<p>A filter for related items of type <code>Comment</code>.</p>', 'refs' => [ 'RelatedItemTypeFilter$comment' => '<p>A filter for related items of type <code>Comment</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. See the accompanying error message for details.</p>', 'refs' => [], ], 'ConnectedToSystemTime' => [ 'base' => NULL, 'refs' => [ 'ContactContent$connectedToSystemTime' => '<p>The difference between the <code>InitiationTimestamp</code> and the <code>DisconnectTimestamp</code> of the contact.</p>', ], ], 'Contact' => [ 'base' => '<p>An object that represents an Amazon Connect contact object. </p>', 'refs' => [ 'RelatedItemInputContent$contact' => '<p>Object representing a contact in Amazon Connect as an API request field.</p>', ], ], 'ContactArn' => [ 'base' => NULL, 'refs' => [ 'Contact$contactArn' => '<p>A unique identifier of a contact in Amazon Connect.</p>', 'ContactContent$contactArn' => '<p>A unique identifier of a contact in Amazon Connect.</p>', 'ContactFilter$contactArn' => '<p>A unique identifier of a contact in Amazon Connect.</p>', 'ListCasesForContactRequest$contactArn' => '<p>A unique identifier of a contact in Amazon Connect.</p>', ], ], 'ContactContent' => [ 'base' => '<p>An object that represents a content of an Amazon Connect contact object.</p>', 'refs' => [ 'RelatedItemContent$contact' => '<p>Represents the content of a contact to be returned to agents.</p>', ], ], 'ContactFilter' => [ 'base' => '<p>A filter for related items of type <code>Contact</code>.</p>', 'refs' => [ 'RelatedItemTypeFilter$contact' => '<p>A filter for related items of type <code>Contact</code>.</p>', ], ], 'ContactFilterChannelList' => [ 'base' => NULL, 'refs' => [ 'ContactFilter$channel' => '<p>A list of channels to filter on for related items of type <code>Contact</code>.</p>', ], ], 'CreateCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCaseRequestClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateCaseRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', ], ], 'CreateCaseRequestFieldsList' => [ 'base' => NULL, 'refs' => [ 'CreateCaseRequest$fields' => '<p>An array of objects with field ID (matching ListFields/DescribeField) and value union data.</p>', ], ], 'CreateCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFieldRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFieldResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLayoutRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLayoutResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRelatedItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRelatedItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedTime' => [ 'base' => NULL, 'refs' => [ 'GetDomainResponse$createdTime' => '<p>The timestamp when the Cases domain was created.</p>', 'GetFieldResponse$createdTime' => '<p>Timestamp at which the resource was created.</p>', 'GetLayoutResponse$createdTime' => '<p>Timestamp at which the resource was created.</p>', 'GetTemplateResponse$createdTime' => '<p>Timestamp at which the resource was created.</p>', ], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFieldRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFieldResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLayoutRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLayoutResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'Deleted' => [ 'base' => NULL, 'refs' => [ 'GetFieldResponse$deleted' => '<p>Denotes whether or not the resource has been deleted.</p>', 'GetLayoutResponse$deleted' => '<p>Denotes whether or not the resource has been deleted.</p>', 'GetTemplateResponse$deleted' => '<p>Denotes whether or not the resource has been deleted.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$domainArn' => '<p>The Amazon Resource Name (ARN) for the Cases domain.</p>', 'DomainSummary$domainArn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', 'GetDomainResponse$domainArn' => '<p>The Amazon Resource Name (ARN) for the Cases domain.</p>', ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'BatchGetFieldRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'BatchPutFieldOptionsRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateCaseRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateDomainResponse$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateFieldRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateLayoutRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateRelatedItemRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'CreateTemplateRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'DeleteDomainRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'DeleteFieldRequest$domainId' => '<p>The unique identifier of the Cases domain.</p>', 'DeleteLayoutRequest$domainId' => '<p>The unique identifier of the Cases domain.</p>', 'DeleteTemplateRequest$domainId' => '<p>The unique identifier of the Cases domain.</p>', 'DomainSummary$domainId' => '<p>The unique identifier of the domain.</p>', 'GetCaseAuditEventsRequest$domainId' => '<p>The unique identifier of the Cases domain.</p>', 'GetCaseEventConfigurationRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'GetCaseRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'GetDomainRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'GetDomainResponse$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'GetLayoutRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'GetTemplateRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'ListCasesForContactRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'ListFieldOptionsRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'ListFieldsRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'ListLayoutsRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'ListTemplatesRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'PutCaseEventConfigurationRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'SearchCasesRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'SearchRelatedItemsRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'UpdateCaseRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'UpdateFieldRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'UpdateLayoutRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', 'UpdateTemplateRequest$domainId' => '<p>The unique identifier of the Cases domain. </p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$name' => '<p>The name for your Cases domain. It must be unique for your Amazon Web Services account.</p>', 'DomainSummary$name' => '<p>The name of the domain.</p>', 'GetDomainResponse$name' => '<p>The name of the Cases domain.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$domainStatus' => '<p>The status of the domain.</p>', 'GetDomainResponse$domainStatus' => '<p>The status of the Cases domain.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>Object for the summarized details of the domain.</p>', 'refs' => [ 'DomainSummaryList$member' => NULL, ], ], 'DomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$domains' => '<p>The Cases domain.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AuditEventFieldValueUnion$doubleValue' => '<p>Can be either null, or have a Double value type. Only one value can be provided.</p>', 'FieldValueUnion$doubleValue' => '<p>Can be either null, or have a Double number value type. Only one value can be provided.</p>', ], ], 'EmptyFieldValue' => [ 'base' => '<p>An empty value. You cannot set <code>EmptyFieldValue</code> on a field that is required on a case template.</p> <p>This structure will never have any data members. It signifies an empty value on a case field.</p>', 'refs' => [ 'AuditEventFieldValueUnion$emptyValue' => NULL, 'FieldValueUnion$emptyValue' => '<p>An empty value.</p>', ], ], 'EventBridgeConfiguration' => [ 'base' => '<p>Configuration to enable EventBridge case event delivery and determine what data is delivered.</p>', 'refs' => [ 'GetCaseEventConfigurationResponse$eventBridge' => '<p>Configuration to enable EventBridge case event delivery and determine what data is delivered.</p>', 'PutCaseEventConfigurationRequest$eventBridge' => '<p>Configuration to enable EventBridge case event delivery and determine what data is delivered.</p>', ], ], 'EventIncludedData' => [ 'base' => '<p>Details of what case and related item data is published through the case event stream.</p>', 'refs' => [ 'EventBridgeConfiguration$includedData' => '<p>Details of what case and related item data is published through the case event stream.</p>', ], ], 'FieldArn' => [ 'base' => NULL, 'refs' => [ 'CreateFieldResponse$fieldArn' => '<p>The Amazon Resource Name (ARN) of the field.</p>', 'FieldSummary$fieldArn' => '<p>The Amazon Resource Name (ARN) of the field.</p>', 'GetFieldResponse$fieldArn' => '<p>The Amazon Resource Name (ARN) of the field.</p>', ], ], 'FieldDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFieldRequest$description' => '<p>The description of the field.</p>', 'GetFieldResponse$description' => '<p>Description of the field.</p>', 'UpdateFieldRequest$description' => '<p>The description of a field.</p>', ], ], 'FieldError' => [ 'base' => '<p>Object for errors on fields.</p>', 'refs' => [ 'BatchGetFieldResponseErrorsList$member' => NULL, ], ], 'FieldFilter' => [ 'base' => '<p>A filter for fields. Only one value can be provided.</p>', 'refs' => [ 'CaseFilter$field' => '<p>A list of fields to filter on.</p>', ], ], 'FieldGroup' => [ 'base' => '<p>Object for a group of fields and associated properties.</p>', 'refs' => [ 'Section$fieldGroup' => '<p>Consists of a group of fields and associated properties.</p>', ], ], 'FieldGroupFieldsList' => [ 'base' => NULL, 'refs' => [ 'FieldGroup$fields' => '<p>Represents an ordered list containing field related information.</p>', ], ], 'FieldGroupNameString' => [ 'base' => NULL, 'refs' => [ 'FieldGroup$name' => '<p>Name of the field group.</p>', ], ], 'FieldId' => [ 'base' => NULL, 'refs' => [ 'BatchPutFieldOptionsRequest$fieldId' => '<p>The unique identifier of a field.</p>', 'CreateFieldResponse$fieldId' => '<p>The unique identifier of a field.</p>', 'DeleteFieldRequest$fieldId' => '<p>Unique identifier of the field.</p>', 'FieldError$id' => '<p>The field identifier that caused the error.</p>', 'FieldIdentifier$id' => '<p>Unique identifier of a field.</p>', 'FieldItem$id' => '<p>Unique identifier of a field.</p>', 'FieldSummary$fieldId' => '<p>The unique identifier of a field.</p>', 'FieldValue$id' => '<p>Unique identifier of a field.</p>', 'GetFieldResponse$fieldId' => '<p>Unique identifier of the field.</p>', 'ListFieldOptionsRequest$fieldId' => '<p>The unique identifier of a field.</p>', 'RequiredField$fieldId' => '<p>Unique identifier of a field.</p>', 'Sort$fieldId' => '<p>Unique identifier of a field.</p>', 'UpdateFieldRequest$fieldId' => '<p>The unique identifier of a field.</p>', ], ], 'FieldIdentifier' => [ 'base' => '<p>Object for unique identifier of a field.</p>', 'refs' => [ 'BatchGetFieldIdentifierList$member' => NULL, 'CaseEventIncludedDataFieldsList$member' => NULL, 'GetCaseRequestFieldsList$member' => NULL, 'SearchCasesRequestFieldsList$member' => NULL, ], ], 'FieldItem' => [ 'base' => '<p>Object for field related information.</p>', 'refs' => [ 'FieldGroupFieldsList$member' => NULL, ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'CreateFieldRequest$name' => '<p>The name of the field.</p>', 'FieldSummary$name' => '<p>Name of the field.</p>', 'GetFieldResponse$name' => '<p>Name of the field.</p>', 'UpdateFieldRequest$name' => '<p>The name of the field.</p>', ], ], 'FieldNamespace' => [ 'base' => NULL, 'refs' => [ 'FieldSummary$namespace' => '<p>The namespace of a field.</p>', 'GetFieldResponse$namespace' => '<p>Namespace of the field.</p>', ], ], 'FieldOption' => [ 'base' => '<p>Object for field Options information.</p>', 'refs' => [ 'BatchPutFieldOptionsRequestOptionsList$member' => NULL, 'FieldOptionsList$member' => NULL, ], ], 'FieldOptionError' => [ 'base' => '<p>Object for field Options errors.</p>', 'refs' => [ 'BatchPutFieldOptionsResponseErrorsList$member' => NULL, ], ], 'FieldOptionName' => [ 'base' => NULL, 'refs' => [ 'FieldOption$name' => '<p> <code>FieldOptionName</code> has max length 100 and disallows trailing spaces.</p>', ], ], 'FieldOptionValue' => [ 'base' => NULL, 'refs' => [ 'FieldOption$value' => '<p> <code>FieldOptionValue</code> has max length 100 and must be alphanumeric with hyphens and underscores.</p>', 'FieldOptionError$value' => '<p>The field option value that caused the error.</p>', ], ], 'FieldOptionsList' => [ 'base' => NULL, 'refs' => [ 'ListFieldOptionsResponse$options' => '<p>A list of <code>FieldOption</code> objects.</p>', ], ], 'FieldSummary' => [ 'base' => '<p>Object for the summarized details of the field.</p>', 'refs' => [ 'ListFieldsResponseFieldsList$member' => NULL, ], ], 'FieldType' => [ 'base' => NULL, 'refs' => [ 'CreateFieldRequest$type' => '<p>Defines the data type, some system constraints, and default display of the field.</p>', 'FieldSummary$type' => '<p>The type of a field.</p>', 'GetFieldResponse$type' => '<p>Type of the field.</p>', ], ], 'FieldValue' => [ 'base' => '<p>Object for case field values.</p>', 'refs' => [ 'CreateCaseRequestFieldsList$member' => NULL, 'FieldFilter$contains' => '<p>Object containing field identifier and value information.</p>', 'FieldFilter$equalTo' => '<p>Object containing field identifier and value information.</p>', 'FieldFilter$greaterThan' => '<p>Object containing field identifier and value information.</p>', 'FieldFilter$greaterThanOrEqualTo' => '<p>Object containing field identifier and value information.</p>', 'FieldFilter$lessThan' => '<p>Object containing field identifier and value information.</p>', 'FieldFilter$lessThanOrEqualTo' => '<p>Object containing field identifier and value information. </p>', 'GetCaseResponseFieldsList$member' => NULL, 'SearchCasesResponseItemFieldsList$member' => NULL, 'UpdateCaseRequestFieldsList$member' => NULL, ], ], 'FieldValueUnion' => [ 'base' => '<p>Object to store union of Field values.</p> <note> <p>The <code>Summary</code> system field accepts 1500 characters while all other fields accept 500 characters.</p> </note>', 'refs' => [ 'FieldValue$value' => '<p>Union of potential field value types.</p>', ], ], 'FieldValueUnionStringValueString' => [ 'base' => NULL, 'refs' => [ 'FieldValueUnion$stringValue' => '<p>String value type.</p>', ], ], 'FileArn' => [ 'base' => NULL, 'refs' => [ 'FileContent$fileArn' => '<p>The Amazon Resource Name (ARN) of a File in Amazon Connect.</p>', 'FileFilter$fileArn' => '<p>The Amazon Resource Name (ARN) of the file.</p>', ], ], 'FileContent' => [ 'base' => '<p>An object that represents a content of an Amazon Connect file object.</p>', 'refs' => [ 'RelatedItemContent$file' => '<p>Represents the content of a File to be returned to agents.</p>', 'RelatedItemInputContent$file' => '<p>A file of related items.</p>', ], ], 'FileFilter' => [ 'base' => '<p>A filter for related items of type <code>File</code>.</p>', 'refs' => [ 'RelatedItemTypeFilter$file' => '<p>A filter for related items of this type of <code>File</code>.</p>', ], ], 'GetCaseAuditEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseAuditEventsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'GetCaseAuditEventsRequest$maxResults' => '<p>The maximum number of audit events to return. The current maximum supported value is 25. This is also the default when no other value is provided.</p>', ], ], 'GetCaseAuditEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseAuditEventsResponseAuditEventsList' => [ 'base' => NULL, 'refs' => [ 'GetCaseAuditEventsResponse$auditEvents' => '<p>A list of case audits where each represents a particular edit of the case.</p>', ], ], 'GetCaseEventConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseEventConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseRequestFieldsList' => [ 'base' => NULL, 'refs' => [ 'GetCaseRequest$fields' => '<p>A list of unique field identifiers. </p>', ], ], 'GetCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCaseResponseFieldsList' => [ 'base' => NULL, 'refs' => [ 'GetCaseResponse$fields' => '<p>A list of detailed field information. </p>', ], ], 'GetDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldResponse' => [ 'base' => '<p>Object to store detailed field information.</p>', 'refs' => [ 'BatchGetFieldResponseFieldsList$member' => NULL, ], ], 'GetLayoutRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLayoutResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'IamPrincipalArn' => [ 'base' => NULL, 'refs' => [ 'AuditEventPerformedBy$iamPrincipalArn' => '<p>Unique identifier of an IAM role.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>Advice to clients on when the call can be safely retried.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>We couldn\'t process your request because of an issue with the server. Try again later.</p>', 'refs' => [], ], 'LastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'GetFieldResponse$lastModifiedTime' => '<p>Timestamp at which the resource was created or last modified.</p>', 'GetLayoutResponse$lastModifiedTime' => '<p>Timestamp at which the resource was created or last modified.</p>', 'GetTemplateResponse$lastModifiedTime' => '<p>Timestamp at which the resource was created or last modified.</p>', ], ], 'LayoutArn' => [ 'base' => NULL, 'refs' => [ 'CreateLayoutResponse$layoutArn' => '<p>The Amazon Resource Name (ARN) of the newly created layout.</p>', 'GetLayoutResponse$layoutArn' => '<p>The Amazon Resource Name (ARN) of the newly created layout.</p>', 'LayoutSummary$layoutArn' => '<p>The Amazon Resource Name (ARN) of the layout.</p>', ], ], 'LayoutConfiguration' => [ 'base' => '<p>Object to store configuration of layouts associated to the template.</p>', 'refs' => [ 'CreateTemplateRequest$layoutConfiguration' => '<p>Configuration of layouts associated to the template.</p>', 'GetTemplateResponse$layoutConfiguration' => '<p>Configuration of layouts associated to the template.</p>', 'UpdateTemplateRequest$layoutConfiguration' => '<p>Configuration of layouts associated to the template.</p>', ], ], 'LayoutContent' => [ 'base' => '<p>Object to store union of different versions of layout content.</p>', 'refs' => [ 'CreateLayoutRequest$content' => '<p>Information about which fields will be present in the layout, and information about the order of the fields.</p>', 'GetLayoutResponse$content' => '<p>Information about which fields will be present in the layout, the order of the fields, and read-only attribute of the field. </p>', 'UpdateLayoutRequest$content' => '<p>Information about which fields will be present in the layout, the order of the fields.</p>', ], ], 'LayoutId' => [ 'base' => NULL, 'refs' => [ 'CreateLayoutResponse$layoutId' => '<p>The unique identifier of the layout.</p>', 'DeleteLayoutRequest$layoutId' => '<p>The unique identifier of the layout.</p>', 'GetLayoutRequest$layoutId' => '<p>The unique identifier of the layout.</p>', 'GetLayoutResponse$layoutId' => '<p>The unique identifier of the layout.</p>', 'LayoutConfiguration$defaultLayout' => '<p> Unique identifier of a layout. </p>', 'LayoutSummary$layoutId' => '<p>The unique identifier for of the layout.</p>', 'UpdateLayoutRequest$layoutId' => '<p>The unique identifier of the layout.</p>', ], ], 'LayoutName' => [ 'base' => NULL, 'refs' => [ 'CreateLayoutRequest$name' => '<p>The name of the layout. It must be unique for the Cases domain.</p>', 'GetLayoutResponse$name' => '<p>The name of the layout. It must be unique.</p>', 'LayoutSummary$name' => '<p>The name of the layout.</p>', 'UpdateLayoutRequest$name' => '<p>The name of the layout. It must be unique per domain.</p>', ], ], 'LayoutSections' => [ 'base' => '<p>Ordered list containing different kinds of sections that can be added. A LayoutSections object can only contain one section.</p>', 'refs' => [ 'BasicLayout$moreInfo' => '<p>This represents sections in a tab of the page layout.</p>', 'BasicLayout$topPanel' => '<p>This represents sections in a panel of the page layout.</p>', ], ], 'LayoutSummary' => [ 'base' => '<p>Object for the summarized details of the layout.</p>', 'refs' => [ 'LayoutSummaryList$member' => NULL, ], ], 'LayoutSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLayoutsResponse$layouts' => '<p>The layouts for the domain.</p>', ], ], 'ListCasesForContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCasesForContactRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListCasesForContactRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'ListCasesForContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCasesForContactResponseCasesList' => [ 'base' => NULL, 'refs' => [ 'ListCasesForContactResponse$cases' => '<p>A list of Case summary information.</p>', ], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldsResponseFieldsList' => [ 'base' => NULL, 'refs' => [ 'ListFieldsResponse$fields' => '<p>List of detailed field information.</p>', ], ], 'ListLayoutsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLayoutsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponseTemplatesList' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesResponse$templates' => '<p>List of template summary objects.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFieldOptionsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListFieldsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListLayoutsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListTemplatesRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetCaseAuditEventsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetCaseAuditEventsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'GetCaseRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetCaseResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListCasesForContactRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListCasesForContactResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListDomainsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListDomainsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListFieldOptionsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListFieldOptionsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListFieldsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListFieldsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListLayoutsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListLayoutsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'ListTemplatesRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListTemplatesResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'SearchCasesRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchCasesResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', 'SearchRelatedItemsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchRelatedItemsResponse$nextToken' => '<p>The token for the next set of results. This is null if there are no more results to return.</p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'Sort$sortOrder' => '<p>A structured set of sort terms</p>', ], ], 'PutCaseEventConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutCaseEventConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RelatedItemArn' => [ 'base' => NULL, 'refs' => [ 'CreateRelatedItemResponse$relatedItemArn' => '<p>The Amazon Resource Name (ARN) of the related item.</p>', ], ], 'RelatedItemContent' => [ 'base' => '<p>Represents the content of a particular type of related item.</p>', 'refs' => [ 'SearchRelatedItemsResponseItem$content' => '<p>Represents the content of a particular type of related item.</p>', ], ], 'RelatedItemEventIncludedData' => [ 'base' => '<p>Details of what related item data is published through the case event stream.</p>', 'refs' => [ 'EventIncludedData$relatedItemData' => '<p>Details of what related item data is published through the case event stream.</p>', ], ], 'RelatedItemId' => [ 'base' => NULL, 'refs' => [ 'CreateRelatedItemResponse$relatedItemId' => '<p>The unique identifier of the related item.</p>', 'SearchRelatedItemsResponseItem$relatedItemId' => '<p>Unique identifier of a related item.</p>', ], ], 'RelatedItemInputContent' => [ 'base' => '<p>Represents the content of a related item to be created.</p>', 'refs' => [ 'CreateRelatedItemRequest$content' => '<p>The content of a related item to be created.</p>', ], ], 'RelatedItemType' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$relatedItemType' => '<p>The Type of the related item.</p>', 'CreateRelatedItemRequest$type' => '<p>The type of a related item.</p>', 'SearchRelatedItemsResponseItem$type' => '<p>Type of a related item.</p>', ], ], 'RelatedItemTypeFilter' => [ 'base' => '<p>The list of types of related items and their parameters to use for filtering.</p>', 'refs' => [ 'SearchRelatedItemsRequestFiltersList$member' => NULL, ], ], 'RequiredField' => [ 'base' => '<p>List of fields that must have a value provided to create a case.</p>', 'refs' => [ 'RequiredFieldList$member' => NULL, ], ], 'RequiredFieldList' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$requiredFields' => '<p>A list of fields that must contain a value for a case to be successfully created with this template.</p>', 'GetTemplateResponse$requiredFields' => '<p>A list of fields that must contain a value for a case to be successfully created with this template.</p>', 'UpdateTemplateRequest$requiredFields' => '<p>A list of fields that must contain a value for a case to be successfully created with this template.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>We couldn\'t find the requested resource. Check that your resources exists and were created in the same Amazon Web Services Region as your request, and try your request again.</p>', 'refs' => [], ], 'SearchCasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchCasesRequestFieldsList' => [ 'base' => NULL, 'refs' => [ 'SearchCasesRequest$fields' => '<p>The list of field identifiers to be returned as part of the response.</p>', ], ], 'SearchCasesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'SearchCasesRequest$maxResults' => '<p>The maximum number of cases to return. The current maximum supported value is 25. This is also the default value when no other value is provided.</p>', ], ], 'SearchCasesRequestSearchTermString' => [ 'base' => NULL, 'refs' => [ 'SearchCasesRequest$searchTerm' => '<p>A word or phrase used to perform a quick search.</p>', ], ], 'SearchCasesRequestSortsList' => [ 'base' => NULL, 'refs' => [ 'SearchCasesRequest$sorts' => '<p>A list of sorts where each sort specifies a field and their sort order to be applied to the results. </p>', ], ], 'SearchCasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchCasesResponseCasesList' => [ 'base' => NULL, 'refs' => [ 'SearchCasesResponse$cases' => '<p>A list of case documents where each case contains the properties <code>CaseId</code> and <code>Fields</code> where each field is a complex union structure. </p>', ], ], 'SearchCasesResponseItem' => [ 'base' => '<p>A list of items that represent cases.</p>', 'refs' => [ 'SearchCasesResponseCasesList$member' => NULL, ], ], 'SearchCasesResponseItemFieldsList' => [ 'base' => NULL, 'refs' => [ 'SearchCasesResponseItem$fields' => '<p>List of case field values.</p>', ], ], 'SearchRelatedItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchRelatedItemsRequestFiltersList' => [ 'base' => NULL, 'refs' => [ 'SearchRelatedItemsRequest$filters' => '<p>The list of types of related items and their parameters to use for filtering.</p>', ], ], 'SearchRelatedItemsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'SearchRelatedItemsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'SearchRelatedItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchRelatedItemsResponseItem' => [ 'base' => '<p>A list of items that represent RelatedItems.</p>', 'refs' => [ 'SearchRelatedItemsResponseRelatedItemsList$member' => NULL, ], ], 'SearchRelatedItemsResponseRelatedItemsList' => [ 'base' => NULL, 'refs' => [ 'SearchRelatedItemsResponse$relatedItems' => '<p>A list of items related to a case. </p>', ], ], 'Section' => [ 'base' => '<p>This represents a sections within a panel or tab of the page layout.</p>', 'refs' => [ 'SectionsList$member' => NULL, ], ], 'SectionsList' => [ 'base' => '<p>Ordered list containing different kinds of sections that can be added.</p>', 'refs' => [ 'LayoutSections$sections' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota has been exceeded. For a list of service quotas, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [], ], 'Sort' => [ 'base' => '<p>A structured set of sort terms.</p>', 'refs' => [ 'SearchCasesRequestSortsList$member' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AuditEventFieldValueUnion$userArnValue' => '<p>Can be either null, or have a String value type formatted as an ARN. Only one value can be provided.</p>', 'ConflictException$message' => NULL, 'FieldError$errorCode' => '<p>The error code from getting a field.</p>', 'FieldError$message' => '<p>The error message from getting a field.</p>', 'FieldOptionError$errorCode' => '<p>Error code from creating or updating field option.</p>', 'FieldOptionError$message' => '<p>Error message from creating or updating field option.</p>', 'FieldValueUnion$userArnValue' => '<p>Represents the user that performed the audit.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>Unique identifier of the resource affected.</p>', 'ResourceNotFoundException$resourceType' => '<p>Type of the resource affected.</p>', 'ServiceQuotaExceededException$message' => NULL, 'Tags$key' => NULL, 'Tags$value' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>List of tag keys.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'GetCaseResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'GetDomainResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'GetFieldResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'GetLayoutResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'GetTemplateResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'SearchCasesResponseItem$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'SearchRelatedItemsResponseItem$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', 'TagResourceRequest$tags' => '<p>A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control access for this resource.</p>', ], ], 'TemplateArn' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateResponse$templateArn' => '<p>The Amazon Resource Name (ARN) of the newly created template.</p>', 'GetTemplateResponse$templateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'TemplateSummary$templateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', ], ], 'TemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$description' => '<p>A brief description of the template.</p>', 'GetTemplateResponse$description' => '<p>A brief description of the template.</p>', 'UpdateTemplateRequest$description' => '<p>A brief description of the template.</p>', ], ], 'TemplateId' => [ 'base' => NULL, 'refs' => [ 'CaseSummary$templateId' => '<p>A unique identifier of a template.</p>', 'CreateCaseRequest$templateId' => '<p>A unique identifier of a template.</p>', 'CreateTemplateResponse$templateId' => '<p>A unique identifier of a template.</p>', 'DeleteTemplateRequest$templateId' => '<p>A unique identifier of a template.</p>', 'GetCaseResponse$templateId' => '<p>A unique identifier of a template.</p>', 'GetTemplateRequest$templateId' => '<p>A unique identifier of a template.</p>', 'GetTemplateResponse$templateId' => '<p>A unique identifier of a template.</p>', 'SearchCasesResponseItem$templateId' => '<p>A unique identifier of a template.</p>', 'TemplateSummary$templateId' => '<p>The unique identifier for the template.</p>', 'UpdateTemplateRequest$templateId' => '<p>A unique identifier for the template.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$name' => '<p>A name for the template. It must be unique per domain.</p>', 'GetTemplateResponse$name' => '<p>The name of the template.</p>', 'TemplateSummary$name' => '<p>The template name.</p>', 'UpdateTemplateRequest$name' => '<p>The name of the template. It must be unique per domain.</p>', ], ], 'TemplateStatus' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$status' => '<p>The status of the template.</p>', 'GetTemplateResponse$status' => '<p>The status of the template.</p>', 'TemplateStatusFilters$member' => NULL, 'TemplateSummary$status' => '<p>The status of the template.</p>', 'UpdateTemplateRequest$status' => '<p>The status of the template.</p>', ], ], 'TemplateStatusFilters' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesRequest$status' => '<p>A list of status values to filter on.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>Template summary information.</p>', 'refs' => [ 'ListTemplatesResponseTemplatesList$member' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The rate has been exceeded for this API. Please try again after a few minutes.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCaseRequestFieldsList' => [ 'base' => NULL, 'refs' => [ 'UpdateCaseRequest$fields' => '<p>An array of objects with <code>fieldId</code> (matching ListFields/DescribeField) and value union data, structured identical to <code>CreateCase</code>.</p>', ], ], 'UpdateCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFieldRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFieldResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLayoutRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLayoutResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserArn' => [ 'base' => NULL, 'refs' => [ 'UserUnion$userArn' => '<p>Represents the Amazon Connect ARN of the user.</p>', ], ], 'UserUnion' => [ 'base' => '<p>Represents the identity of the person who performed the action.</p>', 'refs' => [ 'AuditEventPerformedBy$user' => NULL, 'CreateCaseRequest$performedBy' => NULL, 'CreateRelatedItemRequest$performedBy' => '<p>Represents the creator of the related item.</p>', 'SearchRelatedItemsResponseItem$performedBy' => '<p>Represents the creator of the related item.</p>', 'UpdateCaseRequest$performedBy' => NULL, ], ], 'ValidationException' => [ 'base' => '<p>The request isn\'t valid. Check the syntax and try again.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'ValuesList$member' => NULL, ], ], 'ValuesList' => [ 'base' => NULL, 'refs' => [ 'ListFieldOptionsRequest$values' => '<p>A list of <code>FieldOption</code> values to filter on for <code>ListFieldOptions</code>.</p>', ], ], ],];
