<?php
// This file was auto-generated from sdk-root/src/data/controlcatalog/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon Web Services Control Catalog API reference. This guide is for developers who need detailed information about how to programmatically identify and filter the common controls and related metadata that are available to Amazon Web Services customers. This API reference provides descriptions, syntax, and usage examples for each of the actions and data types that are supported by Amazon Web Services Control Catalog. </p> <p>Use the following links to get started with the Amazon Web Services Control Catalog API:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_Operations.html">Actions</a>: An alphabetical list of all Control Catalog API operations.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_Types.html">Data types</a>: An alphabetical list of all Control Catalog data types.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/CommonParameters.html">Common parameters</a>: Parameters that all operations can use.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/CommonErrors.html">Common errors</a>: Client and server errors that all operations can return.</p> </li> </ul>', 'operations' => [ 'GetControl' => '<p>Returns details about a specific control, most notably a list of Amazon Web Services Regions where this control is supported. Input a value for the <i>ControlArn</i> parameter, in ARN form. <code>GetControl</code> accepts <i>controltower</i> or <i>controlcatalog</i> control ARNs as input. Returns a <i>controlcatalog</i> ARN format.</p> <p>In the API response, controls that have the value <code>GLOBAL</code> in the <code>Scope</code> field do not show the <code>DeployableRegions</code> field, because it does not apply. Controls that have the value <code>REGIONAL</code> in the <code>Scope</code> field return a value for the <code>DeployableRegions</code> field, as shown in the example.</p>', 'ListCommonControls' => '<p>Returns a paginated list of common controls from the Amazon Web Services Control Catalog.</p> <p>You can apply an optional filter to see common controls that have a specific objective. If you don’t provide a filter, the operation returns all common controls. </p>', 'ListControls' => '<p>Returns a paginated list of all available controls in the Amazon Web Services Control Catalog library. Allows you to discover available controls. The list of controls is given as structures of type <i>controlSummary</i>. The ARN is returned in the global <i>controlcatalog</i> format, as shown in the examples.</p>', 'ListDomains' => '<p>Returns a paginated list of domains from the Amazon Web Services Control Catalog.</p>', 'ListObjectives' => '<p>Returns a paginated list of objectives from the Amazon Web Services Control Catalog.</p> <p>You can apply an optional filter to see the objectives that belong to a specific domain. If you don’t provide a filter, the operation returns all objectives. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AssociatedDomainSummary' => [ 'base' => '<p>A summary of the domain that a common control or an objective belongs to.</p>', 'refs' => [ 'CommonControlSummary$Domain' => '<p>The domain that the common control belongs to.</p>', 'ObjectiveSummary$Domain' => '<p>The domain that the objective belongs to.</p>', ], ], 'AssociatedObjectiveSummary' => [ 'base' => '<p>A summary of the objective that a common control supports.</p>', 'refs' => [ 'CommonControlSummary$Objective' => '<p>The objective that the common control belongs to.</p>', ], ], 'CommonControlArn' => [ 'base' => NULL, 'refs' => [ 'CommonControlSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the common control.</p>', ], ], 'CommonControlFilter' => [ 'base' => '<p>An optional filter that narrows the results to a specific objective.</p>', 'refs' => [ 'ListCommonControlsRequest$CommonControlFilter' => '<p>An optional filter that narrows the results to a specific objective.</p> <p>This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the <code>CommonControlFilter</code> isn’t currently supported.</p>', ], ], 'CommonControlSummary' => [ 'base' => '<p>A summary of metadata for a common control.</p>', 'refs' => [ 'CommonControlSummaryList$member' => NULL, ], ], 'CommonControlSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsResponse$CommonControls' => '<p>The list of common controls that the <code>ListCommonControls</code> API returns.</p>', ], ], 'ControlArn' => [ 'base' => NULL, 'refs' => [ 'ControlSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the control.</p>', 'GetControlRequest$ControlArn' => '<p>The Amazon Resource Name (ARN) of the control. It has one of the following formats:</p> <p> <i>Global format</i> </p> <p> <code>arn:{PARTITION}:controlcatalog:::control/{CONTROL_CATALOG_OPAQUE_ID}</code> </p> <p> <i>Or Regional format</i> </p> <p> <code>arn:{PARTITION}:controltower:{REGION}::control/{CONTROL_TOWER_OPAQUE_ID}</code> </p> <p>Here is a more general pattern that covers Amazon Web Services Control Tower and Control Catalog ARNs:</p> <p> <code>^arn:(aws(?:[-a-z]*)?):(controlcatalog|controltower):[a-zA-Z0-9-]*::control/[0-9a-zA-Z_\\\\-]+$</code> </p>', 'GetControlResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the control.</p>', ], ], 'ControlBehavior' => [ 'base' => NULL, 'refs' => [ 'GetControlResponse$Behavior' => '<p>A term that identifies the control\'s functional behavior. One of <code>Preventive</code>, <code>Deteictive</code>, <code>Proactive</code> </p>', ], ], 'ControlScope' => [ 'base' => NULL, 'refs' => [ 'RegionConfiguration$Scope' => '<p>The coverage of the control, if deployed. Scope is an enumerated type, with value <code>Regional</code>, or <code>Global</code>. A control with Global scope is effective in all Amazon Web Services Regions, regardless of the Region from which it is enabled, or to which it is deployed. A control implemented by an SCP is usually Global in scope. A control with Regional scope has operations that are restricted specifically to the Region from which it is enabled and to which it is deployed. Controls implemented by Config rules and CloudFormation hooks usually are Regional in scope. Security Hub controls usually are Regional in scope.</p>', ], ], 'ControlSummary' => [ 'base' => '<p>Overview of information about a control.</p>', 'refs' => [ 'Controls$member' => NULL, ], ], 'Controls' => [ 'base' => NULL, 'refs' => [ 'ListControlsResponse$Controls' => '<p>Returns a list of controls, given as structures of type <i>controlSummary</i>.</p>', ], ], 'DeployableRegions' => [ 'base' => NULL, 'refs' => [ 'RegionConfiguration$DeployableRegions' => '<p>Regions in which the control is available to be deployed.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'AssociatedDomainSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the related domain.</p>', 'DomainResourceFilter$Arn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', 'DomainSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the domain.</p>', ], ], 'DomainResourceFilter' => [ 'base' => '<p>The domain resource that\'s being used as a filter.</p>', 'refs' => [ 'DomainResourceFilterList$member' => NULL, ], ], 'DomainResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'ObjectiveFilter$Domains' => '<p>The domain that\'s used as filter criteria.</p> <p>You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the <code>ObjectiveFilter</code> isn’t currently supported.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>A summary of metadata for a domain.</p>', 'refs' => [ 'DomainSummaryList$member' => NULL, ], ], 'DomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>The list of domains that the <code>ListDomains</code> API returns.</p>', ], ], 'GetControlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetControlResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>An internal service error occurred during the processing of your request. Try again later.</p>', 'refs' => [], ], 'ListCommonControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommonControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectivesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectivesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxListCommonControlsResults' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'MaxListControlsResults' => [ 'base' => NULL, 'refs' => [ 'ListControlsRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'MaxListDomainsResults' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'MaxListObjectivesResults' => [ 'base' => NULL, 'refs' => [ 'ListObjectivesRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'ObjectiveArn' => [ 'base' => NULL, 'refs' => [ 'AssociatedObjectiveSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the related objective.</p>', 'ObjectiveResourceFilter$Arn' => '<p>The Amazon Resource Name (ARN) of the objective.</p>', 'ObjectiveSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the objective.</p>', ], ], 'ObjectiveFilter' => [ 'base' => '<p>An optional filter that narrows the list of objectives to a specific domain.</p>', 'refs' => [ 'ListObjectivesRequest$ObjectiveFilter' => '<p>An optional filter that narrows the results to a specific domain.</p> <p>This filter allows you to specify one domain ARN at a time. Passing multiple ARNs in the <code>ObjectiveFilter</code> isn’t currently supported.</p>', ], ], 'ObjectiveResourceFilter' => [ 'base' => '<p>The objective resource that\'s being used as a filter.</p>', 'refs' => [ 'ObjectiveResourceFilterList$member' => NULL, ], ], 'ObjectiveResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'CommonControlFilter$Objectives' => '<p>The objective that\'s used as filter criteria.</p> <p>You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the <code>CommonControlFilter</code> isn’t currently supported.</p>', ], ], 'ObjectiveSummary' => [ 'base' => '<p>A summary of metadata for an objective.</p>', 'refs' => [ 'ObjectiveSummaryList$member' => NULL, ], ], 'ObjectiveSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListObjectivesResponse$Objectives' => '<p>The list of objectives that the <code>ListObjectives</code> API returns.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListCommonControlsResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListControlsRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListControlsResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListDomainsRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListDomainsResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListObjectivesRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListObjectivesResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', ], ], 'RegionCode' => [ 'base' => NULL, 'refs' => [ 'DeployableRegions$member' => NULL, ], ], 'RegionConfiguration' => [ 'base' => '<p>Returns information about the control, including the scope of the control, if enabled, and the Regions in which the control currently is available for deployment.</p> <p>If you are applying controls through an Amazon Web Services Control Tower landing zone environment, remember that the values returned in the <code>RegionConfiguration</code> API operation are not related to the governed Regions in your landing zone. For example, if you are governing Regions <code>A</code>,<code>B</code>,and <code>C</code> while the control is available in Regions <code>A</code>, <code>B</code>, C<code>,</code> and <code>D</code>, you\'d see a response with <code>DeployableRegions</code> of <code>A</code>, <code>B</code>, <code>C</code>, and <code>D</code> for a control with <code>REGIONAL</code> scope, even though you may not intend to deploy the control in Region <code>D</code>, because you do not govern it through your landing zone.</p>', 'refs' => [ 'GetControlResponse$RegionConfiguration' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource does not exist.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AssociatedDomainSummary$Name' => '<p>The name of the related domain.</p>', 'AssociatedObjectiveSummary$Name' => '<p>The name of the related objective.</p>', 'CommonControlSummary$Name' => '<p>The name of the common control.</p>', 'CommonControlSummary$Description' => '<p>The description of the common control.</p>', 'ControlSummary$Name' => '<p>The display name of the control.</p>', 'ControlSummary$Description' => '<p>A description of the control, as it may appear in the console. Describes the functionality of the control.</p>', 'DomainSummary$Name' => '<p>The name of the domain.</p>', 'DomainSummary$Description' => '<p>The description of the domain.</p>', 'GetControlResponse$Name' => '<p>The display name of the control.</p>', 'GetControlResponse$Description' => '<p>A description of what the control does.</p>', 'InternalServerException$Message' => NULL, 'ObjectiveSummary$Name' => '<p>The name of the objective.</p>', 'ObjectiveSummary$Description' => '<p>The description of the objective.</p>', 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CommonControlSummary$CreateTime' => '<p>The time when the common control was created.</p>', 'CommonControlSummary$LastUpdateTime' => '<p>The time when the common control was most recently updated.</p>', 'DomainSummary$CreateTime' => '<p>The time when the domain was created.</p>', 'DomainSummary$LastUpdateTime' => '<p>The time when the domain was most recently updated.</p>', 'ObjectiveSummary$CreateTime' => '<p>The time when the objective was created.</p>', 'ObjectiveSummary$LastUpdateTime' => '<p>The time when the objective was most recently updated.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request has invalid or missing parameters.</p>', 'refs' => [], ], ],];
