<?php
// This file was auto-generated from sdk-root/src/data/datasync/2018-11-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>DataSync</fullname> <p>DataSync is an online data movement and discovery service that simplifies data migration and helps you quickly, easily, and securely transfer your file or object data to, from, and between Amazon Web Services storage services.</p> <p>This API interface reference includes documentation for using DataSync programmatically. For complete information, see the <i> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/what-is-datasync.html">DataSync User Guide</a> </i>.</p>', 'operations' => [ 'AddStorageSystem' => '<p>Creates an Amazon Web Services resource for an on-premises storage system that you want DataSync Discovery to collect information about.</p>', 'CancelTaskExecution' => '<p>Stops an DataSync task execution that\'s in progress. The transfer of some files are abruptly interrupted. File contents that\'re transferred to the destination might be incomplete or inconsistent with the source files.</p> <p>However, if you start a new task execution using the same task and allow it to finish, file content on the destination will be complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully completes the transfer when you start the next task execution.</p>', 'CreateAgent' => '<p>Activates an DataSync agent that you\'ve deployed in your storage environment. The activation process associates the agent with your Amazon Web Services account.</p> <p>If you haven\'t deployed an agent yet, see the following topics to learn more:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/agent-requirements.html">Agent requirements</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-agent.html">Create an agent</a> </p> </li> </ul> <note> <p>If you\'re transferring between Amazon Web Services storage services, you don\'t need a DataSync agent. </p> </note>', 'CreateLocationAzureBlob' => '<p>Creates a transfer <i>location</i> for a Microsoft Azure Blob Storage container. DataSync can use this location as a transfer source or destination.</p> <p>Before you begin, make sure you know <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access">how DataSync accesses Azure Blob Storage</a> and works with <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">access tiers</a> and <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types">blob types</a>. You also need a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent">DataSync agent</a> that can connect to your container.</p>', 'CreateLocationEfs' => '<p>Creates a transfer <i>location</i> for an Amazon EFS file system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access">accesses Amazon EFS file systems</a>.</p>', 'CreateLocationFsxLustre' => '<p>Creates a transfer <i>location</i> for an Amazon FSx for Lustre file system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access">accesses FSx for Lustre file systems</a>.</p>', 'CreateLocationFsxOntap' => '<p>Creates a transfer <i>location</i> for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access">accesses FSx for ONTAP file systems</a>.</p>', 'CreateLocationFsxOpenZfs' => '<p>Creates a transfer <i>location</i> for an Amazon FSx for OpenZFS file system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access">accesses FSx for OpenZFS file systems</a>.</p> <note> <p>Request parameters related to <code>SMB</code> aren\'t supported with the <code>CreateLocationFsxOpenZfs</code> operation.</p> </note>', 'CreateLocationFsxWindows' => '<p>Creates a transfer <i>location</i> for an Amazon FSx for Windows File Server file system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access">accesses FSx for Windows File Server file systems</a>.</p>', 'CreateLocationHdfs' => '<p>Creates a transfer <i>location</i> for a Hadoop Distributed File System (HDFS). DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs">accesses HDFS clusters</a>.</p>', 'CreateLocationNfs' => '<p>Creates a transfer <i>location</i> for a Network File System (NFS) file server. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">accesses NFS file servers</a>.</p> <note> <p>If you\'re copying data to or from an Snowcone device, you can also use <code>CreateLocationNfs</code> to create your transfer location. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/nfs-on-snowcone.html">Configuring transfers with Snowcone</a>.</p> </note>', 'CreateLocationObjectStorage' => '<p>Creates a transfer <i>location</i> for an object storage system. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites">prerequisites</a> for DataSync to work with object storage systems.</p>', 'CreateLocationS3' => '<p>Creates a transfer <i>location</i> for an Amazon S3 bucket. DataSync can use this location as a source or destination for transferring data.</p> <important> <p>Before you begin, make sure that you read the following topics:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 locations</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests">Evaluating S3 request costs when using DataSync</a> </p> </li> </ul> </important> <p> For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html">Configuring transfers with Amazon S3</a>.</p>', 'CreateLocationSmb' => '<p>Creates a transfer <i>location</i> for a Server Message Block (SMB) file server. DataSync can use this location as a source or destination for transferring data.</p> <p>Before you begin, make sure that you understand how DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb">accesses SMB file servers</a>.</p>', 'CreateTask' => '<p>Configures a <i>task</i>, which defines where and how DataSync transfers your data.</p> <p>A task includes a source location, destination location, and transfer options (such as bandwidth limits, scheduling, and more).</p> <important> <p>If you\'re planning to transfer data to or from an Amazon S3 location, review <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests">how DataSync can affect your S3 request charges</a> and the <a href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.</p> </important>', 'DeleteAgent' => '<p>Removes an DataSync agent resource from your Amazon Web Services account.</p> <p>Keep in mind that this operation (which can\'t be undone) doesn\'t remove the agent\'s virtual machine (VM) or Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your storage environment or reuse it to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activate a new agent</a>.</p>', 'DeleteLocation' => '<p>Deletes a transfer location resource from DataSync. </p>', 'DeleteTask' => '<p>Deletes a transfer task resource from DataSync.</p>', 'DescribeAgent' => '<p>Returns information about an DataSync agent, such as its name, service endpoint type, and status.</p>', 'DescribeDiscoveryJob' => '<p>Returns information about a DataSync discovery job.</p>', 'DescribeLocationAzureBlob' => '<p>Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.</p>', 'DescribeLocationEfs' => '<p>Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.</p>', 'DescribeLocationFsxLustre' => '<p>Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.</p>', 'DescribeLocationFsxOntap' => '<p>Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is configured.</p> <note> <p>If your location uses SMB, the <code>DescribeLocationFsxOntap</code> operation doesn\'t actually return a <code>Password</code>.</p> </note>', 'DescribeLocationFsxOpenZfs' => '<p>Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.</p> <note> <p>Response elements related to <code>SMB</code> aren\'t supported with the <code>DescribeLocationFsxOpenZfs</code> operation.</p> </note>', 'DescribeLocationFsxWindows' => '<p>Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is configured.</p>', 'DescribeLocationHdfs' => '<p>Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is configured.</p>', 'DescribeLocationNfs' => '<p>Provides details about how an DataSync transfer location for a Network File System (NFS) file server is configured.</p>', 'DescribeLocationObjectStorage' => '<p>Provides details about how an DataSync transfer location for an object storage system is configured.</p>', 'DescribeLocationS3' => '<p>Provides details about how an DataSync transfer location for an S3 bucket is configured.</p>', 'DescribeLocationSmb' => '<p>Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is configured.</p>', 'DescribeStorageSystem' => '<p>Returns information about an on-premises storage system that you\'re using with DataSync Discovery.</p>', 'DescribeStorageSystemResourceMetrics' => '<p>Returns information, including performance data and capacity usage, which DataSync Discovery collects about a specific resource in your-premises storage system.</p>', 'DescribeStorageSystemResources' => '<p>Returns information that DataSync Discovery collects about resources in your on-premises storage system.</p>', 'DescribeTask' => '<p>Provides information about a <i>task</i>, which defines where and how DataSync transfers your data.</p>', 'DescribeTaskExecution' => '<p>Provides information about an execution of your DataSync task. You can use this operation to help monitor the progress of an ongoing transfer or check the results of the transfer.</p>', 'GenerateRecommendations' => '<p>Creates recommendations about where to migrate your data to in Amazon Web Services. Recommendations are generated based on information that DataSync Discovery collects about your on-premises storage system\'s resources. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">Recommendations provided by DataSync Discovery</a>.</p> <p>Once generated, you can view your recommendations by using the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html">DescribeStorageSystemResources</a> operation.</p>', 'ListAgents' => '<p>Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region specified in the request.</p> <p>With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of agents in a response, the response contains a marker that you can specify in your next request to fetch the next page of agents.</p> <p> <code>ListAgents</code> is eventually consistent. This means the result of running the operation might not reflect that you just created or deleted an agent. For example, if you create an agent with <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html">CreateAgent</a> and then immediately run <code>ListAgents</code>, that agent might not show up in the list right away. In situations like this, you can always confirm whether an agent has been created (or deleted) by using <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html">DescribeAgent</a>.</p>', 'ListDiscoveryJobs' => '<p>Provides a list of the existing discovery jobs in the Amazon Web Services Region and Amazon Web Services account where you\'re using DataSync Discovery.</p>', 'ListLocations' => '<p>Returns a list of source and destination locations.</p> <p>If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.</p>', 'ListStorageSystems' => '<p>Lists the on-premises storage systems that you\'re using with DataSync Discovery.</p>', 'ListTagsForResource' => '<p>Returns all the tags associated with an Amazon Web Services resource.</p>', 'ListTaskExecutions' => '<p>Returns a list of executions for an DataSync transfer task.</p>', 'ListTasks' => '<p>Returns a list of the DataSync tasks you created.</p>', 'RemoveStorageSystem' => '<p>Permanently removes a storage system resource from DataSync Discovery, including the associated discovery jobs, collected data, and recommendations.</p>', 'StartDiscoveryJob' => '<p>Runs a DataSync discovery job on your on-premises storage system. If you haven\'t added the storage system to DataSync Discovery yet, do this first by using the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html">AddStorageSystem</a> operation.</p>', 'StartTaskExecution' => '<p>Starts an DataSync transfer task. For each task, you can only run one task execution at a time.</p> <p>There are several phases to a task execution. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses">Task execution statuses</a>.</p> <important> <p>If you\'re planning to transfer data to or from an Amazon S3 location, review <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests">how DataSync can affect your S3 request charges</a> and the <a href="http://aws.amazon.com/datasync/pricing/">DataSync pricing page</a> before you begin.</p> </important>', 'StopDiscoveryJob' => '<p>Stops a running DataSync discovery job.</p> <p>You can stop a discovery job anytime. A job that\'s stopped before it\'s scheduled to end likely will provide you some information about your on-premises storage system resources. To get recommendations for a stopped job, you must use the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html">GenerateRecommendations</a> operation.</p>', 'TagResource' => '<p>Applies a <i>tag</i> to an Amazon Web Services resource. Tags are key-value pairs that can help you manage, filter, and search for your resources.</p> <p>These include DataSync resources, such as locations, tasks, and task executions.</p>', 'UntagResource' => '<p>Removes tags from an Amazon Web Services resource.</p>', 'UpdateAgent' => '<p>Updates the name of an DataSync agent.</p>', 'UpdateDiscoveryJob' => '<p>Edits a DataSync discovery job configuration.</p>', 'UpdateLocationAzureBlob' => '<p>Modifies some configurations of the Microsoft Azure Blob Storage transfer location that you\'re using with DataSync.</p>', 'UpdateLocationHdfs' => '<p>Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.</p>', 'UpdateLocationNfs' => '<p>Modifies some configurations of the Network File System (NFS) transfer location that you\'re using with DataSync.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html">Configuring transfers to or from an NFS file server</a>.</p>', 'UpdateLocationObjectStorage' => '<p>Updates some parameters of an existing DataSync location for an object storage system.</p>', 'UpdateLocationSmb' => '<p>Updates some of the parameters of a Server Message Block (SMB) file server location that you can use for DataSync transfers.</p>', 'UpdateStorageSystem' => '<p>Modifies some configurations of an on-premises storage system resource that you\'re using with DataSync Discovery.</p>', 'UpdateTask' => '<p>Updates the configuration of a <i>task</i>, which defines where and how DataSync transfers your data.</p>', 'UpdateTaskExecution' => '<p>Updates the configuration of a running DataSync task execution.</p> <note> <p>Currently, the only <code>Option</code> that you can modify with <code>UpdateTaskExecution</code> is <code> <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> </code>, which throttles bandwidth for a running or queued task execution.</p> </note>', ], 'shapes' => [ 'ActivationKey' => [ 'base' => NULL, 'refs' => [ 'CreateAgentRequest$ActivationKey' => '<p>Specifies your DataSync agent\'s activation key. If you don\'t have an activation key, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activate your agent</a>.</p>', ], ], 'AddStorageSystemRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddStorageSystemResponse' => [ 'base' => NULL, 'refs' => [], ], 'AgentArn' => [ 'base' => NULL, 'refs' => [ 'AgentArnList$member' => NULL, 'AgentListEntry$AgentArn' => '<p>The Amazon Resource Name (ARN) of a DataSync agent.</p>', 'CreateAgentResponse$AgentArn' => '<p>The ARN of the agent that you just activated. Use the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html">ListAgents</a> operation to return a list of agents in your Amazon Web Services account and Amazon Web Services Region.</p>', 'DeleteAgentRequest$AgentArn' => '<p>The Amazon Resource Name (ARN) of the agent to delete. Use the <code>ListAgents</code> operation to return a list of agents for your account and Amazon Web Services Region.</p>', 'DescribeAgentRequest$AgentArn' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that you want information about.</p>', 'DescribeAgentResponse$AgentArn' => '<p>The ARN of the agent.</p>', 'DiscoveryAgentArnList$member' => NULL, 'UpdateAgentRequest$AgentArn' => '<p>The Amazon Resource Name (ARN) of the agent to update.</p>', ], ], 'AgentArnList' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$AgentArns' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.</p> <p>You can specify more than one agent. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html">Using multiple agents for your transfer</a>.</p>', 'CreateLocationHdfsRequest$AgentArns' => '<p>The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.</p>', 'CreateLocationObjectStorageRequest$AgentArns' => '<p>Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can securely connect with your location.</p>', 'CreateLocationS3Request$AgentArns' => '<p>(Amazon S3 on Outposts only) Specifies the Amazon Resource Name (ARN) of the DataSync agent on your Outpost.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>', 'CreateLocationSmbRequest$AgentArns' => '<p>Specifies the DataSync agent (or agents) which you want to connect to your SMB file server. You specify an agent by using its Amazon Resource Name (ARN).</p>', 'DescribeLocationAzureBlobResponse$AgentArns' => '<p>The ARNs of the DataSync agents that can connect with your Azure Blob Storage container.</p>', 'DescribeLocationHdfsResponse$AgentArns' => '<p>The ARNs of the DataSync agents that can connect with your HDFS cluster.</p>', 'DescribeLocationObjectStorageResponse$AgentArns' => '<p>The ARNs of the DataSync agents that can connect with your object storage system.</p>', 'DescribeLocationS3Response$AgentArns' => '<p>The ARNs of the DataSync agents deployed on your Outpost when using working with Amazon S3 on Outposts.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent">Deploy your DataSync agent on Outposts</a>.</p>', 'DescribeLocationSmbResponse$AgentArns' => '<p>The ARNs of the DataSync agents that can connect with your SMB file server.</p>', 'OnPremConfig$AgentArns' => '<p>The Amazon Resource Names (ARNs) of the agents connecting to a transfer location.</p>', 'UpdateLocationAzureBlobRequest$AgentArns' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.</p> <p>You can specify more than one agent. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html">Using multiple agents for your transfer</a>.</p>', 'UpdateLocationHdfsRequest$AgentArns' => '<p>The ARNs of the agents that are used to connect to the HDFS cluster. </p>', 'UpdateLocationObjectStorageRequest$AgentArns' => '<p>Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can securely connect with your location.</p>', 'UpdateLocationSmbRequest$AgentArns' => '<p>Specifies the DataSync agent (or agents) which you want to connect to your SMB file server. You specify an agent by using its Amazon Resource Name (ARN).</p>', ], ], 'AgentList' => [ 'base' => NULL, 'refs' => [ 'ListAgentsResponse$Agents' => '<p>A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified in the request. The list is ordered by the agents\' Amazon Resource Names (ARNs).</p>', ], ], 'AgentListEntry' => [ 'base' => '<p>Represents a single entry in a list (or array) of DataSync agents when you call the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html">ListAgents</a> operation.</p>', 'refs' => [ 'AgentList$member' => NULL, ], ], 'AgentStatus' => [ 'base' => NULL, 'refs' => [ 'AgentListEntry$Status' => '<p>The status of an agent.</p> <ul> <li> <p>If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.</p> </li> <li> <p>If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or longer. This can happen for a few reasons. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline">What do I do if my agent is offline?</a> </p> </li> </ul>', 'DescribeAgentResponse$Status' => '<p>The status of the agent.</p> <ul> <li> <p>If the status is <code>ONLINE</code>, the agent is configured properly and ready to use.</p> </li> <li> <p>If the status is <code>OFFLINE</code>, the agent has been out of contact with DataSync for five minutes or longer. This can happen for a few reasons. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline">What do I do if my agent is offline?</a> </p> </li> </ul>', ], ], 'AgentVersion' => [ 'base' => NULL, 'refs' => [ 'Platform$Version' => '<p>The version of the DataSync agent.</p>', ], ], 'Atime' => [ 'base' => NULL, 'refs' => [ 'Options$Atime' => '<p>Specifies whether to preserve metadata indicating the last time a file was read or written to.</p> <note> <p>The behavior of <code>Atime</code> isn\'t fully standard across platforms, so DataSync can only do this on a best-effort basis.</p> </note> <ul> <li> <p> <code>BEST_EFFORT</code> (default) - DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the <code>PREPARING</code> phase of the task execution). This option is recommended.</p> </li> <li> <p> <code>NONE</code> - Ignores <code>Atime</code>.</p> </li> </ul> <note> <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>, <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be <code>NONE</code>. </p> </note>', ], ], 'AzureAccessTier' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$AccessTier' => '<p>Specifies the access tier that you want your objects or files transferred into. This only applies when using the location as a transfer destination. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">Access tiers</a>.</p>', 'DescribeLocationAzureBlobResponse$AccessTier' => '<p>The access tier that you want your objects or files transferred into. This only applies when using the location as a transfer destination. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">Access tiers</a>.</p>', 'UpdateLocationAzureBlobRequest$AccessTier' => '<p>Specifies the access tier that you want your objects or files transferred into. This only applies when using the location as a transfer destination. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">Access tiers</a>.</p>', ], ], 'AzureBlobAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$AuthenticationType' => '<p>Specifies the authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using a shared access signature (SAS).</p>', 'DescribeLocationAzureBlobResponse$AuthenticationType' => '<p>The authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using a shared access signature (SAS).</p>', 'UpdateLocationAzureBlobRequest$AuthenticationType' => '<p>Specifies the authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using a shared access signature (SAS).</p>', ], ], 'AzureBlobContainerUrl' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$ContainerUrl' => '<p>Specifies the URL of the Azure Blob Storage container involved in your transfer.</p>', ], ], 'AzureBlobSasConfiguration' => [ 'base' => '<p>The shared access signature (SAS) configuration that allows DataSync to access your Microsoft Azure Blob Storage.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-sas-tokens">SAS tokens</a> for accessing your Azure Blob Storage.</p>', 'refs' => [ 'CreateLocationAzureBlobRequest$SasConfiguration' => '<p>Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.</p>', 'UpdateLocationAzureBlobRequest$SasConfiguration' => '<p>Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.</p>', ], ], 'AzureBlobSasToken' => [ 'base' => NULL, 'refs' => [ 'AzureBlobSasConfiguration$Token' => '<p>Specifies a SAS token that provides permissions to access your Azure Blob Storage.</p> <p>The token is part of the SAS URI string that comes after the storage resource URI and a question mark. A token looks something like this:</p> <p> <code>sp=r&amp;st=2023-12-20T14:54:52Z&amp;se=2023-12-20T22:54:52Z&amp;spr=https&amp;sv=2021-06-08&amp;sr=c&amp;sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D</code> </p>', ], ], 'AzureBlobSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$Subdirectory' => '<p>Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, <code>/my/images</code>).</p>', 'UpdateLocationAzureBlobRequest$Subdirectory' => '<p>Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, <code>/my/images</code>).</p>', ], ], 'AzureBlobType' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobRequest$BlobType' => '<p>Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the <a href="https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs">Azure Blob Storage documentation</a>.</p>', 'DescribeLocationAzureBlobResponse$BlobType' => '<p>The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the <a href="https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs">Azure Blob Storage documentation</a>.</p>', 'UpdateLocationAzureBlobRequest$BlobType' => '<p>Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the <a href="https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs">Azure Blob Storage documentation</a>.</p>', ], ], 'BytesPerSecond' => [ 'base' => NULL, 'refs' => [ 'Options$BytesPerSecond' => '<p>Limits the bandwidth used by a DataSync task. For example, if you want DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (<code>=1024*1024</code>).</p>', ], ], 'CancelTaskExecutionRequest' => [ 'base' => '<p>CancelTaskExecutionRequest</p>', 'refs' => [], ], 'CancelTaskExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Capacity' => [ 'base' => '<p>The storage capacity of an on-premises storage system resource (for example, a volume).</p>', 'refs' => [ 'ResourceMetrics$Capacity' => '<p>The storage capacity of the on-premises storage system resource.</p>', ], ], 'CollectionDurationMinutes' => [ 'base' => NULL, 'refs' => [ 'DescribeDiscoveryJobResponse$CollectionDurationMinutes' => '<p>The number of minutes that the discovery job runs.</p>', 'StartDiscoveryJobRequest$CollectionDurationMinutes' => '<p>Specifies in minutes how long you want the discovery job to run.</p> <note> <p>For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow time to collect a sufficient number of data points and provide a realistic representation of storage performance and utilization.</p> </note>', 'UpdateDiscoveryJobRequest$CollectionDurationMinutes' => '<p>Specifies in minutes how long that you want the discovery job to run. (You can\'t set this parameter to less than the number of minutes that the job has already run for.)</p>', ], ], 'CreateAgentRequest' => [ 'base' => '<p>CreateAgentRequest</p>', 'refs' => [], ], 'CreateAgentResponse' => [ 'base' => '<p>CreateAgentResponse</p>', 'refs' => [], ], 'CreateLocationAzureBlobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationAzureBlobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationEfsRequest' => [ 'base' => '<p>CreateLocationEfsRequest</p>', 'refs' => [], ], 'CreateLocationEfsResponse' => [ 'base' => '<p>CreateLocationEfs</p>', 'refs' => [], ], 'CreateLocationFsxLustreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxLustreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxOntapRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxOntapResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxOpenZfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxOpenZfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxWindowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationFsxWindowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationHdfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationHdfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocationNfsRequest' => [ 'base' => '<p>CreateLocationNfsRequest</p>', 'refs' => [], ], 'CreateLocationNfsResponse' => [ 'base' => '<p>CreateLocationNfsResponse</p>', 'refs' => [], ], 'CreateLocationObjectStorageRequest' => [ 'base' => '<p>CreateLocationObjectStorageRequest</p>', 'refs' => [], ], 'CreateLocationObjectStorageResponse' => [ 'base' => '<p>CreateLocationObjectStorageResponse</p>', 'refs' => [], ], 'CreateLocationS3Request' => [ 'base' => '<p>CreateLocationS3Request</p>', 'refs' => [], ], 'CreateLocationS3Response' => [ 'base' => '<p>CreateLocationS3Response</p>', 'refs' => [], ], 'CreateLocationSmbRequest' => [ 'base' => '<p>CreateLocationSmbRequest</p>', 'refs' => [], ], 'CreateLocationSmbResponse' => [ 'base' => '<p>CreateLocationSmbResponse</p>', 'refs' => [], ], 'CreateTaskRequest' => [ 'base' => '<p>CreateTaskRequest</p>', 'refs' => [], ], 'CreateTaskResponse' => [ 'base' => '<p>CreateTaskResponse</p>', 'refs' => [], ], 'Credentials' => [ 'base' => '<p>The credentials that provide DataSync Discovery read access to your on-premises storage system\'s management interface.</p> <p>DataSync Discovery stores these credentials in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a>. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html">Accessing your on-premises storage system</a>.</p>', 'refs' => [ 'AddStorageSystemRequest$Credentials' => '<p>Specifies the user name and password for accessing your on-premises storage system\'s management interface.</p>', 'UpdateStorageSystemRequest$Credentials' => '<p>Specifies the user name and password for accessing your on-premises storage system\'s management interface.</p>', ], ], 'DeleteAgentRequest' => [ 'base' => '<p>DeleteAgentRequest</p>', 'refs' => [], ], 'DeleteAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocationRequest' => [ 'base' => '<p>DeleteLocation</p>', 'refs' => [], ], 'DeleteLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTaskRequest' => [ 'base' => '<p>DeleteTask</p>', 'refs' => [], ], 'DeleteTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentRequest' => [ 'base' => '<p>DescribeAgent</p>', 'refs' => [], ], 'DescribeAgentResponse' => [ 'base' => '<p>DescribeAgentResponse</p>', 'refs' => [], ], 'DescribeDiscoveryJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDiscoveryJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationAzureBlobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationAzureBlobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationEfsRequest' => [ 'base' => '<p>DescribeLocationEfsRequest</p>', 'refs' => [], ], 'DescribeLocationEfsResponse' => [ 'base' => '<p>DescribeLocationEfsResponse</p>', 'refs' => [], ], 'DescribeLocationFsxLustreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxLustreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxOntapRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxOntapResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxOpenZfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxOpenZfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxWindowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationFsxWindowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationHdfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationHdfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocationNfsRequest' => [ 'base' => '<p>DescribeLocationNfsRequest</p>', 'refs' => [], ], 'DescribeLocationNfsResponse' => [ 'base' => '<p>DescribeLocationNfsResponse</p>', 'refs' => [], ], 'DescribeLocationObjectStorageRequest' => [ 'base' => '<p>DescribeLocationObjectStorageRequest</p>', 'refs' => [], ], 'DescribeLocationObjectStorageResponse' => [ 'base' => '<p>DescribeLocationObjectStorageResponse</p>', 'refs' => [], ], 'DescribeLocationS3Request' => [ 'base' => '<p>DescribeLocationS3Request</p>', 'refs' => [], ], 'DescribeLocationS3Response' => [ 'base' => '<p>DescribeLocationS3Response</p>', 'refs' => [], ], 'DescribeLocationSmbRequest' => [ 'base' => '<p>DescribeLocationSmbRequest</p>', 'refs' => [], ], 'DescribeLocationSmbResponse' => [ 'base' => '<p>DescribeLocationSmbResponse</p>', 'refs' => [], ], 'DescribeStorageSystemRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageSystemResourceMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageSystemResourceMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageSystemResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageSystemResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageSystemResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTaskExecutionRequest' => [ 'base' => '<p>DescribeTaskExecutionRequest</p>', 'refs' => [], ], 'DescribeTaskExecutionResponse' => [ 'base' => '<p>DescribeTaskExecutionResponse</p>', 'refs' => [], ], 'DescribeTaskRequest' => [ 'base' => '<p>DescribeTaskRequest</p>', 'refs' => [], ], 'DescribeTaskResponse' => [ 'base' => '<p>DescribeTaskResponse</p>', 'refs' => [], ], 'DestinationNetworkInterfaceArns' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskResponse$DestinationNetworkInterfaceArns' => '<p>The ARNs of the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces">network interfaces</a> that DataSync created for your destination location.</p>', ], ], 'DiscoveryAgentArnList' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$AgentArns' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads from your on-premises storage system\'s management interface. You can only specify one ARN.</p>', 'DescribeStorageSystemResponse$AgentArns' => '<p>The ARN of the DataSync agent that connects to and reads from your on-premises storage system.</p>', 'UpdateStorageSystemRequest$AgentArns' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads your on-premises storage system. You can only specify one ARN.</p>', ], ], 'DiscoveryJobArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDiscoveryJobRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that you want information about.</p>', 'DescribeDiscoveryJobResponse$DiscoveryJobArn' => '<p>The ARN of the discovery job.</p>', 'DescribeStorageSystemResourceMetricsRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your on-premises storage system.</p>', 'DescribeStorageSystemResourcesRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that\'s collecting data from your on-premises storage system.</p>', 'DiscoveryJobListEntry$DiscoveryJobArn' => '<p>The Amazon Resource Name (ARN) of a discovery job.</p>', 'GenerateRecommendationsRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that collects information about your on-premises storage system.</p>', 'StartDiscoveryJobResponse$DiscoveryJobArn' => '<p>The ARN of the discovery job that you started.</p>', 'StopDiscoveryJobRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that you want to stop. </p>', 'UpdateDiscoveryJobRequest$DiscoveryJobArn' => '<p>Specifies the Amazon Resource Name (ARN) of the discovery job that you want to update.</p>', ], ], 'DiscoveryJobList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveryJobsResponse$DiscoveryJobs' => '<p>The discovery jobs that you\'ve run.</p>', ], ], 'DiscoveryJobListEntry' => [ 'base' => '<p>The details about a specific DataSync discovery job.</p>', 'refs' => [ 'DiscoveryJobList$member' => NULL, ], ], 'DiscoveryJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDiscoveryJobResponse$Status' => '<p>Indicates the status of a discovery job. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table">Discovery job statuses</a>.</p>', 'DiscoveryJobListEntry$Status' => '<p>The status of a discovery job. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table">Discovery job statuses</a>.</p>', ], ], 'DiscoveryMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourceMetricsRequest$MaxResults' => '<p>Specifies how many results that you want in the response.</p>', 'DescribeStorageSystemResourcesRequest$MaxResults' => '<p>Specifies the maximum number of storage system resources that you want to list in a response.</p>', 'ListDiscoveryJobsRequest$MaxResults' => '<p>Specifies how many results you want in the response.</p>', 'ListStorageSystemsRequest$MaxResults' => '<p>Specifies how many results you want in the response.</p>', ], ], 'DiscoveryNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourceMetricsRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response.</p>', 'DescribeStorageSystemResourceMetricsResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'DescribeStorageSystemResourcesRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response.</p>', 'DescribeStorageSystemResourcesResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListDiscoveryJobsRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListDiscoveryJobsResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListStorageSystemsRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response. </p>', 'ListStorageSystemsResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', ], ], 'DiscoveryResourceFilter' => [ 'base' => NULL, 'refs' => [ 'ResourceFilters$key' => NULL, ], ], 'DiscoveryResourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourceMetricsRequest$ResourceType' => '<p>Specifies the kind of storage system resource that you want information about.</p>', 'DescribeStorageSystemResourcesRequest$ResourceType' => '<p>Specifies what kind of storage system resources that you want information about.</p>', 'GenerateRecommendationsRequest$ResourceType' => '<p>Specifies the type of resource in your storage system that you want recommendations on.</p>', 'ResourceMetrics$ResourceType' => '<p>The type of on-premises storage system resource.</p>', ], ], 'DiscoveryServerConfiguration' => [ 'base' => '<p>The network settings that DataSync Discovery uses to connect with your on-premises storage system\'s management interface.</p>', 'refs' => [ 'AddStorageSystemRequest$ServerConfiguration' => '<p>Specifies the server name and network port required to connect with the management interface of your on-premises storage system.</p>', 'DescribeStorageSystemResponse$ServerConfiguration' => '<p>The server name and network port required to connect with your on-premises storage system\'s management interface.</p>', 'UpdateStorageSystemRequest$ServerConfiguration' => '<p>Specifies the server name and network port required to connect with your on-premises storage system\'s management interface.</p>', ], ], 'DiscoveryServerHostname' => [ 'base' => NULL, 'refs' => [ 'DiscoveryServerConfiguration$ServerHostname' => '<p>The domain name or IP address of your storage system\'s management interface.</p>', ], ], 'DiscoveryServerPort' => [ 'base' => NULL, 'refs' => [ 'DiscoveryServerConfiguration$ServerPort' => '<p>The network port for accessing the storage system\'s management interface.</p>', ], ], 'DiscoverySystemType' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$SystemType' => '<p>Specifies the type of on-premises storage system that you want DataSync Discovery to collect information about.</p> <note> <p>DataSync Discovery currently supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.</p> </note>', 'DescribeStorageSystemResponse$SystemType' => '<p>The type of on-premises storage system.</p> <note> <p>DataSync Discovery currently only supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later. </p> </note>', ], ], 'DiscoveryTime' => [ 'base' => NULL, 'refs' => [ 'DescribeDiscoveryJobResponse$JobStartTime' => '<p>The time when the discovery job started.</p>', 'DescribeDiscoveryJobResponse$JobEndTime' => '<p>The time when the discovery job ended.</p>', 'DescribeStorageSystemResourceMetricsRequest$StartTime' => '<p>Specifies a time within the total duration that the discovery job ran. To see information gathered during a certain time frame, use this parameter with <code>EndTime</code>.</p>', 'DescribeStorageSystemResourceMetricsRequest$EndTime' => '<p>Specifies a time within the total duration that the discovery job ran. To see information gathered during a certain time frame, use this parameter with <code>StartTime</code>.</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'TaskExecutionResultDetail$PrepareDuration' => '<p>The total time in milliseconds that DataSync spent in the PREPARING phase. </p>', 'TaskExecutionResultDetail$TotalDuration' => '<p>The total time in milliseconds that DataSync took to transfer the file from the source to the destination location.</p>', 'TaskExecutionResultDetail$TransferDuration' => '<p>The total time in milliseconds that DataSync spent in the TRANSFERRING phase.</p>', 'TaskExecutionResultDetail$VerifyDuration' => '<p>The total time in milliseconds that DataSync spent in the VERIFYING phase.</p>', ], ], 'Ec2Config' => [ 'base' => '<p>The subnet and security groups that DataSync uses to access your Amazon EFS file system.</p>', 'refs' => [ 'CreateLocationEfsRequest$Ec2Config' => '<p>Specifies the subnet and security groups DataSync uses to access your Amazon EFS file system.</p>', 'DescribeLocationEfsResponse$Ec2Config' => NULL, ], ], 'Ec2SecurityGroupArn' => [ 'base' => NULL, 'refs' => [ 'Ec2SecurityGroupArnList$member' => NULL, 'PLSecurityGroupArnList$member' => NULL, ], ], 'Ec2SecurityGroupArnList' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxLustreRequest$SecurityGroupArns' => '<p>The Amazon Resource Names (ARNs) of the security groups that are used to configure the FSx for Lustre file system.</p>', 'CreateLocationFsxOntapRequest$SecurityGroupArns' => '<p>Specifies the Amazon EC2 security groups that provide access to your file system\'s preferred subnet.</p> <p>The security groups must allow outbound traffic on the following ports (depending on the protocol you use):</p> <ul> <li> <p> <b>Network File System (NFS)</b>: TCP ports 111, 635, and 2049</p> </li> <li> <p> <b>Server Message Block (SMB)</b>: TCP port 445</p> </li> </ul> <p>Your file system\'s security groups must also allow inbound traffic on the same ports.</p>', 'CreateLocationFsxOpenZfsRequest$SecurityGroupArns' => '<p>The ARNs of the security groups that are used to configure the FSx for OpenZFS file system.</p>', 'CreateLocationFsxWindowsRequest$SecurityGroupArns' => '<p>Specifies the ARNs of the security groups that provide access to your file system\'s preferred subnet.</p> <note> <p>If you choose a security group that doesn\'t allow connections from within itself, do one of the following:</p> <ul> <li> <p>Configure the security group to allow it to communicate within itself.</p> </li> <li> <p>Choose a different security group that can communicate with the mount target\'s security group.</p> </li> </ul> </note>', 'DescribeLocationFsxLustreResponse$SecurityGroupArns' => '<p>The Amazon Resource Names (ARNs) of the security groups that are configured for the FSx for Lustre file system.</p>', 'DescribeLocationFsxOntapResponse$SecurityGroupArns' => '<p>The security groups that DataSync uses to access your FSx for ONTAP file system.</p>', 'DescribeLocationFsxOpenZfsResponse$SecurityGroupArns' => '<p>The ARNs of the security groups that are configured for the FSx for OpenZFS file system.</p>', 'DescribeLocationFsxWindowsResponse$SecurityGroupArns' => '<p>The ARNs of the security groups that are configured for the FSx for Windows File Server file system.</p>', 'Ec2Config$SecurityGroupArns' => '<p>Specifies the Amazon Resource Names (ARNs) of the security groups associated with an Amazon EFS file system\'s mount target.</p>', ], ], 'Ec2SubnetArn' => [ 'base' => NULL, 'refs' => [ 'Ec2Config$SubnetArn' => '<p>Specifies the ARN of a subnet where DataSync creates the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces">network interfaces</a> for managing traffic during your transfer.</p> <p>The subnet must be located:</p> <ul> <li> <p>In the same virtual private cloud (VPC) as the Amazon EFS file system.</p> </li> <li> <p>In the same Availability Zone as at least one mount target for the Amazon EFS file system.</p> </li> </ul> <note> <p>You don\'t need to specify a subnet that includes a file system mount target.</p> </note>', 'PLSubnetArnList$member' => NULL, ], ], 'EfsAccessPointArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationEfsRequest$AccessPointArn' => '<p>Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.</p>', 'DescribeLocationEfsResponse$AccessPointArn' => '<p>The ARN of the access point that DataSync uses to access the Amazon EFS file system.</p>', ], ], 'EfsFilesystemArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationEfsRequest$EfsFilesystemArn' => '<p>Specifies the ARN for the Amazon EFS file system.</p>', ], ], 'EfsInTransitEncryption' => [ 'base' => NULL, 'refs' => [ 'CreateLocationEfsRequest$InTransitEncryption' => '<p>Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it copies data to or from the Amazon EFS file system.</p> <p>If you specify an access point using <code>AccessPointArn</code> or an IAM role using <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.</p>', 'DescribeLocationEfsResponse$InTransitEncryption' => '<p>Describes whether DataSync uses Transport Layer Security (TLS) encryption when copying data to or from the Amazon EFS file system.</p>', ], ], 'EfsSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationEfsRequest$Subdirectory' => '<p>Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data (depending on if this is a source or destination location). By default, DataSync uses the root directory, but you can also include subdirectories.</p> <note> <p>You must specify a value with forward slashes (for example, <code>/path/to/folder</code>).</p> </note>', ], ], 'EnabledProtocols' => [ 'base' => NULL, 'refs' => [ 'NetAppONTAPSVM$EnabledProtocols' => '<p>The data transfer protocols (such as NFS) configured for the SVM.</p>', ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'PrivateLinkConfig$PrivateLinkEndpoint' => '<p>Specifies the VPC endpoint provided by <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">Amazon Web Services PrivateLink</a> that your agent connects to.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentResponse$EndpointType' => '<p>The type of <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html">service endpoint</a> that your agent is connected to.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResponse$ErrorMessage' => '<p>Describes the connectivity error that the DataSync agent is encountering with your on-premises storage system.</p>', ], ], 'FilterAttributeValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'CreateTaskRequest$Excludes' => '<p>Specifies exclude filters that define the files, objects, and folders in your source location that you don\'t want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', 'CreateTaskRequest$Includes' => '<p>Specifies include filters define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', 'DescribeTaskExecutionResponse$Excludes' => '<p>A list of filter rules that exclude specific data during your transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by DataSync</a>.</p>', 'DescribeTaskExecutionResponse$Includes' => '<p>A list of filter rules that include specific data during your transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Filtering data transferred by DataSync</a>.</p>', 'DescribeTaskResponse$Excludes' => '<p>The exclude filters that define the files, objects, and folders in your source location that you don\'t want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', 'DescribeTaskResponse$Includes' => '<p>The include filters that define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', 'StartTaskExecutionRequest$Includes' => '<p>Specifies a list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>', 'StartTaskExecutionRequest$Excludes' => '<p>Specifies a list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>. </p>', 'UpdateTaskRequest$Excludes' => '<p>Specifies exclude filters that define the files, objects, and folders in your source location that you don\'t want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', 'UpdateTaskRequest$Includes' => '<p>Specifies include filters define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a>.</p>', ], ], 'FilterMembers' => [ 'base' => NULL, 'refs' => [ 'ResourceFilters$value' => NULL, ], ], 'FilterRule' => [ 'base' => '<p>Specifies which files, folders, and objects to include or exclude when transferring files from source to destination.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterType' => [ 'base' => NULL, 'refs' => [ 'FilterRule$FilterType' => '<p>The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN rule type.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterRule$Value' => '<p>A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code> </p> <p> </p>', ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'LocationFilter$Values' => '<p>The values that you want to filter for. For example, you might want to display only Amazon S3 locations.</p>', 'TaskFilter$Values' => '<p>The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.</p>', ], ], 'FsxFilesystemArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxLustreRequest$FsxFilesystemArn' => '<p>The Amazon Resource Name (ARN) for the FSx for Lustre file system.</p>', 'CreateLocationFsxOpenZfsRequest$FsxFilesystemArn' => '<p>The Amazon Resource Name (ARN) of the FSx for OpenZFS file system.</p>', 'CreateLocationFsxWindowsRequest$FsxFilesystemArn' => '<p>Specifies the Amazon Resource Name (ARN) for the FSx for Windows File Server file system.</p>', 'DescribeLocationFsxOntapResponse$FsxFilesystemArn' => '<p>The ARN of the FSx for ONTAP file system.</p>', ], ], 'FsxLustreSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxLustreRequest$Subdirectory' => '<p>A subdirectory in the location\'s path. This subdirectory in the FSx for Lustre file system is used to read data from the FSx for Lustre source location or write data to the FSx for Lustre destination.</p>', ], ], 'FsxOntapSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxOntapRequest$Subdirectory' => '<p>Specifies a path to the file share in the SVM where you\'ll copy your data.</p> <p>You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares). For example, your mount path might be <code>/vol1</code>, <code>/vol1/tree1</code>, or <code>/share1</code>.</p> <note> <p>Don\'t specify a junction path in the SVM\'s root volume. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage virtual machines</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p> </note>', ], ], 'FsxOpenZfsSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxOpenZfsRequest$Subdirectory' => '<p>A subdirectory in the location\'s path that must begin with <code>/fsx</code>. DataSync uses this subdirectory to read or write data (depending on whether the file system is a source or destination location).</p>', ], ], 'FsxProtocol' => [ 'base' => '<p>Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.</p>', 'refs' => [ 'CreateLocationFsxOntapRequest$Protocol' => NULL, 'CreateLocationFsxOpenZfsRequest$Protocol' => '<p>The type of protocol that DataSync uses to access your file system.</p>', 'DescribeLocationFsxOntapResponse$Protocol' => NULL, 'DescribeLocationFsxOpenZfsResponse$Protocol' => '<p>The type of protocol that DataSync uses to access your file system.</p>', ], ], 'FsxProtocolNfs' => [ 'base' => '<p>Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your Amazon FSx for OpenZFS or Amazon FSx for NetApp ONTAP file system.</p>', 'refs' => [ 'FsxProtocol$NFS' => '<p>Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for OpenZFS file system or FSx for ONTAP file system\'s storage virtual machine (SVM).</p>', ], ], 'FsxProtocolSmb' => [ 'base' => '<p>Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your Amazon FSx for NetApp ONTAP file system. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access">Accessing FSx for ONTAP file systems</a>.</p>', 'refs' => [ 'FsxProtocol$SMB' => '<p>Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP file system\'s SVM.</p>', ], ], 'FsxWindowsSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxWindowsRequest$Subdirectory' => '<p>Specifies a mount path for your file system using forward slashes. This is where DataSync reads or writes data (depending on if this is a source or destination location).</p>', ], ], 'GenerateRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Gid' => [ 'base' => NULL, 'refs' => [ 'Options$Gid' => '<p>Specifies the POSIX group ID (GID) of the file\'s owners.</p> <ul> <li> <p> <code>INT_VALUE</code> (default) - Preserves the integer value of user ID (UID) and GID, which is recommended.</p> </li> <li> <p> <code>NONE</code> - Ignores UID and GID.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata copied by DataSync</a>.</p>', ], ], 'HdfsAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$AuthenticationType' => '<p>The type of authentication used to determine the identity of the user. </p>', 'DescribeLocationHdfsResponse$AuthenticationType' => '<p>The type of authentication used to determine the identity of the user. </p>', 'UpdateLocationHdfsRequest$AuthenticationType' => '<p>The type of authentication used to determine the identity of the user. </p>', ], ], 'HdfsBlockSize' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$BlockSize' => '<p>The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).</p>', 'DescribeLocationHdfsResponse$BlockSize' => '<p>The size of the data blocks to write into the HDFS cluster. </p>', 'UpdateLocationHdfsRequest$BlockSize' => '<p>The size of the data blocks to write into the HDFS cluster. </p>', ], ], 'HdfsDataTransferProtection' => [ 'base' => NULL, 'refs' => [ 'QopConfiguration$DataTransferProtection' => '<p>The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your <code>dfs.data.transfer.protection</code> setting in the <code>hdfs-site.xml</code> file on your Hadoop cluster.</p>', ], ], 'HdfsNameNode' => [ 'base' => '<p>The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages the file system\'s namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes.</p>', 'refs' => [ 'HdfsNameNodeList$member' => NULL, ], ], 'HdfsNameNodeList' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$NameNodes' => '<p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>', 'DescribeLocationHdfsResponse$NameNodes' => '<p>The NameNode that manages the HDFS namespace. </p>', 'UpdateLocationHdfsRequest$NameNodes' => '<p>The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.</p>', ], ], 'HdfsReplicationFactor' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$ReplicationFactor' => '<p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.</p>', 'DescribeLocationHdfsResponse$ReplicationFactor' => '<p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>', 'UpdateLocationHdfsRequest$ReplicationFactor' => '<p>The number of DataNodes to replicate the data to when writing to the HDFS cluster. </p>', ], ], 'HdfsRpcProtection' => [ 'base' => NULL, 'refs' => [ 'QopConfiguration$RpcProtection' => '<p>The RPC protection setting configured on the HDFS cluster. This setting corresponds to your <code>hadoop.rpc.protection</code> setting in your <code>core-site.xml</code> file on your Hadoop cluster.</p>', ], ], 'HdfsServerHostname' => [ 'base' => NULL, 'refs' => [ 'HdfsNameNode$Hostname' => '<p>The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that\'s installed on-premises uses this hostname to communicate with the NameNode in the network.</p>', ], ], 'HdfsServerPort' => [ 'base' => NULL, 'refs' => [ 'HdfsNameNode$Port' => '<p>The port that the NameNode uses to listen to client requests.</p>', ], ], 'HdfsSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$Subdirectory' => '<p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn\'t specified, it will default to <code>/</code>.</p>', 'UpdateLocationHdfsRequest$Subdirectory' => '<p>A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster.</p>', ], ], 'HdfsUser' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$SimpleUser' => '<p>The user name used to identify the client on the host operating system. </p> <note> <p>If <code>SIMPLE</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p> </note>', 'DescribeLocationHdfsResponse$SimpleUser' => '<p>The user name to identify the client on the host operating system. This parameter is used if the <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.</p>', 'UpdateLocationHdfsRequest$SimpleUser' => '<p>The user name used to identify the client on the host operating system.</p>', ], ], 'IOPS' => [ 'base' => '<p>The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', 'refs' => [ 'P95Metrics$IOPS' => '<p>The IOPS peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationEfsRequest$FileSystemAccessRoleArn' => '<p>Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.</p>', 'DescribeLocationEfsResponse$FileSystemAccessRoleArn' => '<p>The Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.</p>', 'ReportDestinationS3$BucketAccessRoleArn' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Allowing DataSync to upload a task report to an Amazon S3 bucket</a>.</p>', 'S3Config$BucketAccessRoleArn' => '<p>Specifies the ARN of the IAM role that DataSync uses to access your S3 bucket.</p>', 'S3ManifestConfig$BucketAccessRoleArn' => '<p>Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access">Providing DataSync access to your manifest</a>.</p>', ], ], 'InputTagList' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your on-premises storage system.</p>', 'CreateAgentRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least one tag for your agent.</p>', 'CreateLocationAzureBlobRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your transfer location.</p>', 'CreateLocationEfsRequest$Tags' => '<p>Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>', 'CreateLocationFsxLustreRequest$Tags' => '<p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>', 'CreateLocationFsxOntapRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.</p>', 'CreateLocationFsxOpenZfsRequest$Tags' => '<p>The key-value pair that represents a tag that you want to add to the resource. The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.</p>', 'CreateLocationFsxWindowsRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.</p>', 'CreateLocationHdfsRequest$Tags' => '<p>The key-value pair that represents the tag that you want to add to the location. The value can be an empty string. We recommend using tags to name your resources. </p>', 'CreateLocationNfsRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.</p>', 'CreateLocationObjectStorageRequest$Tags' => '<p>Specifies the key-value pair that represents a tag that you want to add to the resource. Tags can help you manage, filter, and search for your resources. We recommend creating a name tag for your location.</p>', 'CreateLocationS3Request$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your transfer location.</p>', 'CreateLocationSmbRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.</p>', 'CreateTaskRequest$Tags' => '<p>Specifies the tags that you want to apply to your task.</p> <p> <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.</p>', 'StartDiscoveryJobRequest$Tags' => '<p>Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.</p>', 'StartTaskExecutionRequest$Tags' => '<p>Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.</p> <p> <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.</p>', 'TagResourceRequest$Tags' => '<p>Specifies the tags that you want to apply to the resource.</p>', ], ], 'InternalException' => [ 'base' => '<p>This exception is thrown when an error occurs in the DataSync service.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>This exception is thrown when the client submits a malformed request.</p>', 'refs' => [], ], 'KerberosKeytabFile' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$KerberosKeytab' => '<p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file\'s address. If you\'re using the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note> <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required. </p> </note>', 'UpdateLocationHdfsRequest$KerberosKeytab' => '<p>The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. You can load the keytab from a file by providing the file\'s address. If you use the CLI, it performs base64 encoding for you. Otherwise, provide the base64-encoded text.</p>', ], ], 'KerberosKrb5ConfFile' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$KerberosKrb5Conf' => '<p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file\'s address. If you\'re using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text. </p> <note> <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p> </note>', 'UpdateLocationHdfsRequest$KerberosKrb5Conf' => '<p>The <code>krb5.conf</code> file that contains the Kerberos configuration information. You can load the <code>krb5.conf</code> file by providing the file\'s address. If you\'re using the CLI, it performs the base64 encoding for you. Otherwise, provide the base64-encoded text.</p>', ], ], 'KerberosPrincipal' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$KerberosPrincipal' => '<p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p> <note> <p>If <code>KERBEROS</code> is specified for <code>AuthenticationType</code>, this parameter is required.</p> </note>', 'DescribeLocationHdfsResponse$KerberosPrincipal' => '<p>The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.</p>', 'UpdateLocationHdfsRequest$KerberosPrincipal' => '<p>The Kerberos principal with access to the files and folders on the HDFS cluster. </p>', ], ], 'KmsKeyProviderUri' => [ 'base' => NULL, 'refs' => [ 'CreateLocationHdfsRequest$KmsKeyProviderUri' => '<p>The URI of the HDFS cluster\'s Key Management Server (KMS). </p>', 'DescribeLocationHdfsResponse$KmsKeyProviderUri' => '<p> The URI of the HDFS cluster\'s Key Management Server (KMS). </p>', 'UpdateLocationHdfsRequest$KmsKeyProviderUri' => '<p>The URI of the HDFS cluster\'s Key Management Server (KMS). </p>', ], ], 'Latency' => [ 'base' => '<p>The latency peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', 'refs' => [ 'P95Metrics$Latency' => '<p>The latency peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', ], ], 'ListAgentsRequest' => [ 'base' => '<p>ListAgentsRequest</p>', 'refs' => [], ], 'ListAgentsResponse' => [ 'base' => '<p>ListAgentsResponse</p>', 'refs' => [], ], 'ListDiscoveryJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveryJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLocationsRequest' => [ 'base' => '<p>ListLocationsRequest</p>', 'refs' => [], ], 'ListLocationsResponse' => [ 'base' => '<p>ListLocationsResponse</p>', 'refs' => [], ], 'ListStorageSystemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageSystemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>ListTagsForResourceRequest</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>ListTagsForResourceResponse</p>', 'refs' => [], ], 'ListTaskExecutionsRequest' => [ 'base' => '<p>ListTaskExecutions</p>', 'refs' => [], ], 'ListTaskExecutionsResponse' => [ 'base' => '<p>ListTaskExecutionsResponse</p>', 'refs' => [], ], 'ListTasksRequest' => [ 'base' => '<p>ListTasksRequest</p>', 'refs' => [], ], 'ListTasksResponse' => [ 'base' => '<p>ListTasksResponse</p>', 'refs' => [], ], 'LocationArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationAzureBlobResponse$LocationArn' => '<p>The ARN of the Azure Blob Storage transfer location that you created.</p>', 'CreateLocationEfsResponse$LocationArn' => '<p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that you create.</p>', 'CreateLocationFsxLustreResponse$LocationArn' => '<p>The Amazon Resource Name (ARN) of the FSx for Lustre file system location that\'s created. </p>', 'CreateLocationFsxOntapResponse$LocationArn' => '<p>Specifies the ARN of the FSx for ONTAP file system location that you create.</p>', 'CreateLocationFsxOpenZfsResponse$LocationArn' => '<p>The ARN of the FSx for OpenZFS file system location that you created.</p>', 'CreateLocationFsxWindowsResponse$LocationArn' => '<p>The ARN of the FSx for Windows File Server file system location you created.</p>', 'CreateLocationHdfsResponse$LocationArn' => '<p>The ARN of the source HDFS cluster location that\'s created. </p>', 'CreateLocationNfsResponse$LocationArn' => '<p>The ARN of the transfer location that you created for your NFS file server.</p>', 'CreateLocationObjectStorageResponse$LocationArn' => '<p>Specifies the ARN of the object storage system location that you create.</p>', 'CreateLocationS3Response$LocationArn' => '<p>The ARN of the S3 location that you created.</p>', 'CreateLocationSmbResponse$LocationArn' => '<p>The ARN of the SMB location that you created.</p>', 'CreateTaskRequest$SourceLocationArn' => '<p>Specifies the ARN of your transfer\'s source location.</p>', 'CreateTaskRequest$DestinationLocationArn' => '<p>Specifies the ARN of your transfer\'s destination location. </p>', 'DeleteLocationRequest$LocationArn' => '<p>The Amazon Resource Name (ARN) of the location to delete.</p>', 'DescribeLocationAzureBlobRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of your Azure Blob Storage transfer location.</p>', 'DescribeLocationAzureBlobResponse$LocationArn' => '<p>The ARN of your Azure Blob Storage transfer location.</p>', 'DescribeLocationEfsRequest$LocationArn' => '<p>The Amazon Resource Name (ARN) of the Amazon EFS file system location that you want information about.</p>', 'DescribeLocationEfsResponse$LocationArn' => '<p>The ARN of the Amazon EFS file system location.</p>', 'DescribeLocationFsxLustreRequest$LocationArn' => '<p>The Amazon Resource Name (ARN) of the FSx for Lustre location to describe. </p>', 'DescribeLocationFsxLustreResponse$LocationArn' => '<p>The Amazon Resource Name (ARN) of the FSx for Lustre location that was described.</p>', 'DescribeLocationFsxOntapRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP file system location that you want information about.</p>', 'DescribeLocationFsxOntapResponse$LocationArn' => '<p>The ARN of the FSx for ONTAP file system location.</p>', 'DescribeLocationFsxOpenZfsRequest$LocationArn' => '<p>The Amazon Resource Name (ARN) of the FSx for OpenZFS location to describe.</p>', 'DescribeLocationFsxOpenZfsResponse$LocationArn' => '<p>The ARN of the FSx for OpenZFS location that was described.</p>', 'DescribeLocationFsxWindowsRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the FSx for Windows File Server location.</p>', 'DescribeLocationFsxWindowsResponse$LocationArn' => '<p>The ARN of the FSx for Windows File Server location.</p>', 'DescribeLocationHdfsRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the HDFS location.</p>', 'DescribeLocationHdfsResponse$LocationArn' => '<p>The ARN of the HDFS location.</p>', 'DescribeLocationNfsRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the NFS location that you want information about.</p>', 'DescribeLocationNfsResponse$LocationArn' => '<p>The ARN of the NFS location.</p>', 'DescribeLocationObjectStorageRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the object storage system location.</p>', 'DescribeLocationObjectStorageResponse$LocationArn' => '<p>The ARN of the object storage system location.</p>', 'DescribeLocationS3Request$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon S3 location.</p>', 'DescribeLocationS3Response$LocationArn' => '<p>The ARN of the Amazon S3 location.</p>', 'DescribeLocationSmbRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the SMB location that you want information about.</p>', 'DescribeLocationSmbResponse$LocationArn' => '<p>The ARN of the SMB location.</p>', 'DescribeTaskResponse$SourceLocationArn' => '<p>The ARN of your transfer\'s source location.</p>', 'DescribeTaskResponse$DestinationLocationArn' => '<p>The ARN of your transfer\'s destination location.</p>', 'LocationListEntry$LocationArn' => '<p>The Amazon Resource Name (ARN) of the location. For Network File System (NFS) or Amazon EFS, the location is the export path. For Amazon S3, the location is the prefix path that you want to mount and use as the root of the location.</p>', 'UpdateLocationAzureBlobRequest$LocationArn' => '<p>Specifies the ARN of the Azure Blob Storage transfer location that you\'re updating.</p>', 'UpdateLocationHdfsRequest$LocationArn' => '<p>The Amazon Resource Name (ARN) of the source HDFS cluster location.</p>', 'UpdateLocationNfsRequest$LocationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.</p>', 'UpdateLocationObjectStorageRequest$LocationArn' => '<p>Specifies the ARN of the object storage system location that you\'re updating.</p>', 'UpdateLocationSmbRequest$LocationArn' => '<p>Specifies the ARN of the SMB location that you want to update.</p>', ], ], 'LocationFilter' => [ 'base' => '<p>Narrow down the list of resources returned by <code>ListLocations</code>. For example, to see all your Amazon S3 locations, create a filter using <code>"Name": "LocationType"</code>, <code>"Operator": "Equals"</code>, and <code>"Values": "S3"</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">filtering resources</a>.</p>', 'refs' => [ 'LocationFilters$member' => NULL, ], ], 'LocationFilterName' => [ 'base' => NULL, 'refs' => [ 'LocationFilter$Name' => '<p>The name of the filter being used. Each API call supports a list of filters that are available for it (for example, <code>LocationType</code> for <code>ListLocations</code>).</p>', ], ], 'LocationFilters' => [ 'base' => NULL, 'refs' => [ 'ListLocationsRequest$Filters' => '<p>You can use API filters to narrow down the list of resources returned by <code>ListLocations</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListLocations</code> with filter name <code>LocationType S3</code> and <code>Operator Equals</code>.</p>', ], ], 'LocationList' => [ 'base' => NULL, 'refs' => [ 'ListLocationsResponse$Locations' => '<p>An array that contains a list of locations.</p>', ], ], 'LocationListEntry' => [ 'base' => '<p>Represents a single entry in a list of locations. <code>LocationListEntry</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p>', 'refs' => [ 'LocationList$member' => NULL, ], ], 'LocationUri' => [ 'base' => NULL, 'refs' => [ 'DescribeLocationAzureBlobResponse$LocationUri' => '<p>The URL of the Azure Blob Storage container involved in your transfer.</p>', 'DescribeLocationEfsResponse$LocationUri' => '<p>The URL of the Amazon EFS file system location.</p>', 'DescribeLocationFsxLustreResponse$LocationUri' => '<p>The URI of the FSx for Lustre location that was described.</p>', 'DescribeLocationFsxOntapResponse$LocationUri' => '<p>The uniform resource identifier (URI) of the FSx for ONTAP file system location.</p>', 'DescribeLocationFsxOpenZfsResponse$LocationUri' => '<p>The uniform resource identifier (URI) of the FSx for OpenZFS location that was described.</p> <p>Example: <code>fsxz://us-west-2.fs-1234567890abcdef02/fsx/folderA/folder</code> </p>', 'DescribeLocationFsxWindowsResponse$LocationUri' => '<p>The uniform resource identifier (URI) of the FSx for Windows File Server location.</p>', 'DescribeLocationHdfsResponse$LocationUri' => '<p>The URI of the HDFS location.</p>', 'DescribeLocationNfsResponse$LocationUri' => '<p>The URI of the NFS location.</p>', 'DescribeLocationObjectStorageResponse$LocationUri' => '<p>The URI of the object storage system location.</p>', 'DescribeLocationS3Response$LocationUri' => '<p>The URL of the Amazon S3 location that was described.</p>', 'DescribeLocationSmbResponse$LocationUri' => '<p>The URI of the SMB location.</p>', 'LocationListEntry$LocationUri' => '<p>Represents a list of URIs of a location. <code>LocationUri</code> returns an array that contains a list of locations when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html">ListLocations</a> operation is called.</p> <p>Format: <code>TYPE://GLOBAL_ID/SUBDIR</code>.</p> <p>TYPE designates the type of location (for example, <code>nfs</code> or <code>s3</code>).</p> <p>GLOBAL_ID is the globally unique identifier of the resource that backs the location. An example for EFS is <code>us-east-2.fs-abcd1234</code>. An example for Amazon S3 is the bucket name, such as <code>myBucket</code>. An example for NFS is a valid IPv4 address or a hostname that is compliant with Domain Name Service (DNS).</p> <p>SUBDIR is a valid file system path, delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS, it\'s the export path to mount the location. For Amazon S3, it\'s the prefix path that you mount to and treat as the root of the location.</p> <p/>', ], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$CloudWatchLogGroupArn' => '<p>Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.</p>', 'CreateTaskRequest$CloudWatchLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.</p>', 'DescribeStorageSystemResponse$CloudWatchLogGroupArn' => '<p>The ARN of the Amazon CloudWatch log group that\'s used to monitor and log discovery job events.</p>', 'DescribeTaskResponse$CloudWatchLogGroupArn' => '<p>The Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html">Monitoring DataSync with Amazon CloudWatch</a>.</p>', 'UpdateStorageSystemRequest$CloudWatchLogGroupArn' => '<p>Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.</p>', 'UpdateTaskRequest$CloudWatchLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'Options$LogLevel' => '<p>Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs log group. To specify the log group, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.</p> <ul> <li> <p> <code>BASIC</code> - Publishes logs with only basic information (such as transfer errors).</p> </li> <li> <p> <code>TRANSFER</code> - Publishes logs for all files or objects that your DataSync task transfers and performs data-integrity checks on.</p> </li> <li> <p> <code>OFF</code> - No logs are published.</p> </li> </ul>', ], ], 'ManifestAction' => [ 'base' => NULL, 'refs' => [ 'ManifestConfig$Action' => '<p>Specifies what DataSync uses the manifest for.</p>', ], ], 'ManifestConfig' => [ 'base' => '<p>Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p>', 'refs' => [ 'CreateTaskRequest$ManifestConfig' => '<p>Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p> <p>When using this parameter, your caller identity (the role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p>', 'DescribeTaskExecutionResponse$ManifestConfig' => '<p>The configuration of the manifest that lists the files or objects to transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p>', 'DescribeTaskResponse$ManifestConfig' => '<p>The configuration of the manifest that lists the files or objects that you want DataSync to transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p>', 'StartTaskExecutionRequest$ManifestConfig' => '<p>Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p> <p>When using this parameter, your caller identity (the role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p> <p>To remove a manifest configuration, specify this parameter with an empty value.</p>', 'UpdateTaskRequest$ManifestConfig' => '<p>Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p> <p>When using this parameter, your caller identity (the IAM role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p> <p>To remove a manifest configuration, specify this parameter as empty.</p>', ], ], 'ManifestFormat' => [ 'base' => NULL, 'refs' => [ 'ManifestConfig$Format' => '<p>Specifies the file format of your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create">Creating a manifest</a>.</p>', ], ], 'MaxP95Performance' => [ 'base' => '<p>The performance data that DataSync Discovery collects about an on-premises storage system resource.</p>', 'refs' => [ 'NetAppONTAPCluster$MaxP95Performance' => '<p>The performance data that DataSync Discovery collects about the cluster.</p>', 'NetAppONTAPSVM$MaxP95Performance' => '<p>The performance data that DataSync Discovery collects about the SVM.</p>', 'NetAppONTAPVolume$MaxP95Performance' => '<p>The performance data that DataSync Discovery collects about the volume.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAgentsRequest$MaxResults' => '<p>Specifies the maximum number of DataSync agents to list in a response. By default, a response shows a maximum of 100 agents.</p>', 'ListLocationsRequest$MaxResults' => '<p>The maximum number of locations to return.</p>', 'ListTagsForResourceRequest$MaxResults' => '<p>Specifies how many results that you want in the response.</p>', 'ListTaskExecutionsRequest$MaxResults' => '<p>Specifies how many results you want in the response.</p>', 'ListTasksRequest$MaxResults' => '<p>The maximum number of tasks to return.</p>', ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourceMetricsResponse$Metrics' => '<p>The details that your discovery job collected about your storage system resource.</p>', ], ], 'Mtime' => [ 'base' => NULL, 'refs' => [ 'Options$Mtime' => '<p>Specifies whether to preserve metadata indicating the last time that a file was written to before the <code>PREPARING</code> phase of your task execution. This option is required when you need to run the a task more than once.</p> <ul> <li> <p> <code>PRESERVE</code> (default) - Preserves original <code>Mtime</code>, which is recommended.</p> </li> <li> <p> <code>NONE</code> - Ignores <code>Mtime</code>.</p> </li> </ul> <note> <p>If <code>Mtime</code> is set to <code>PRESERVE</code>, <code>Atime</code> must be set to <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>. </p> </note>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$Name' => '<p>Specifies a familiar name for your on-premises storage system.</p>', 'DescribeStorageSystemResponse$Name' => '<p>The name that you gave your on-premises storage system when adding it to DataSync Discovery.</p>', 'StorageSystemListEntry$Name' => '<p>The name of an on-premises storage system that you added to DataSync Discovery.</p>', 'UpdateStorageSystemRequest$Name' => '<p>Specifies a familiar name for your on-premises storage system.</p>', ], ], 'NetAppONTAPCluster' => [ 'base' => '<p>The information that DataSync Discovery collects about an on-premises storage system cluster.</p>', 'refs' => [ 'NetAppONTAPClusters$member' => NULL, ], ], 'NetAppONTAPClusters' => [ 'base' => NULL, 'refs' => [ 'ResourceDetails$NetAppONTAPClusters' => '<p>The information that DataSync Discovery collects about the cluster in your on-premises storage system.</p>', ], ], 'NetAppONTAPSVM' => [ 'base' => '<p>The information that DataSync Discovery collects about a storage virtual machine (SVM) in your on-premises storage system.</p>', 'refs' => [ 'NetAppONTAPSVMs$member' => NULL, ], ], 'NetAppONTAPSVMs' => [ 'base' => NULL, 'refs' => [ 'ResourceDetails$NetAppONTAPSVMs' => '<p>The information that DataSync Discovery collects about storage virtual machines (SVMs) in your on-premises storage system.</p>', ], ], 'NetAppONTAPVolume' => [ 'base' => '<p>The information that DataSync Discovery collects about a volume in your on-premises storage system.</p>', 'refs' => [ 'NetAppONTAPVolumes$member' => NULL, ], ], 'NetAppONTAPVolumes' => [ 'base' => NULL, 'refs' => [ 'ResourceDetails$NetAppONTAPVolumes' => '<p>The information that DataSync Discovery collects about volumes in your on-premises storage system.</p>', ], ], 'NetworkInterfaceArn' => [ 'base' => NULL, 'refs' => [ 'DestinationNetworkInterfaceArns$member' => NULL, 'SourceNetworkInterfaceArns$member' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAgentsRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListAgentsResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListLocationsRequest$NextToken' => '<p>An opaque string that indicates the position at which to begin the next list of locations.</p>', 'ListLocationsResponse$NextToken' => '<p>An opaque string that indicates the position at which to begin returning the next list of locations.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>Specifies an opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListTaskExecutionsRequest$NextToken' => '<p>Specifies an opaque string that indicates the position at which to begin the next list of results in the response.</p>', 'ListTaskExecutionsResponse$NextToken' => '<p>The opaque string that indicates the position to begin the next list of results in the response.</p>', 'ListTasksRequest$NextToken' => '<p>An opaque string that indicates the position at which to begin the next list of tasks.</p>', 'ListTasksResponse$NextToken' => '<p>An opaque string that indicates the position at which to begin returning the next list of tasks.</p>', ], ], 'NfsMountOptions' => [ 'base' => '<p>Specifies how DataSync can access a location using the NFS protocol.</p>', 'refs' => [ 'CreateLocationNfsRequest$MountOptions' => '<p>Specifies the options that DataSync can use to mount your NFS file server.</p>', 'DescribeLocationNfsResponse$MountOptions' => '<p>The mount options that DataSync uses to mount your NFS file server.</p>', 'FsxProtocolNfs$MountOptions' => NULL, 'UpdateLocationNfsRequest$MountOptions' => NULL, ], ], 'NfsSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationNfsRequest$Subdirectory' => '<p>Specifies the export path in your NFS file server that you want DataSync to mount.</p> <p>This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing NFS file servers</a>.</p>', 'UpdateLocationNfsRequest$Subdirectory' => '<p>Specifies the export path in your NFS file server that you want DataSync to mount.</p> <p>This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs">Accessing NFS file servers</a>.</p>', ], ], 'NfsVersion' => [ 'base' => NULL, 'refs' => [ 'NfsMountOptions$Version' => '<p>Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses to use the version specified, the task fails.</p> <p>You can specify the following options:</p> <ul> <li> <p> <code>AUTOMATIC</code> (default): DataSync chooses NFS version 4.1.</p> </li> <li> <p> <code>NFS3</code>: Stateless protocol version that allows for asynchronous writes on the server.</p> </li> <li> <p> <code>NFSv4_0</code>: Stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.</p> </li> <li> <p> <code>NFSv4_1</code>: Stateful protocol version that supports sessions, directory delegations, and parallel data processing. NFS version 4.1 also includes all features available in version 4.0.</p> </li> </ul> <note> <p>DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.</p> </note>', ], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'IOPS$Read' => '<p>Peak IOPS related to read operations.</p>', 'IOPS$Write' => '<p>Peak IOPS related to write operations.</p>', 'IOPS$Other' => '<p>Peak IOPS unrelated to read and write operations.</p>', 'IOPS$Total' => '<p>Peak total IOPS on your on-premises storage system resource.</p>', 'Latency$Read' => '<p>Peak latency for read operations.</p>', 'Latency$Write' => '<p>Peak latency for write operations.</p>', 'Latency$Other' => '<p>Peak latency for operations unrelated to read and write operations.</p>', 'MaxP95Performance$IopsRead' => '<p>Peak IOPS related to read operations.</p>', 'MaxP95Performance$IopsWrite' => '<p>Peak IOPS related to write operations.</p>', 'MaxP95Performance$IopsOther' => '<p>Peak IOPS unrelated to read and write operations.</p>', 'MaxP95Performance$IopsTotal' => '<p>Peak total IOPS on your on-premises storage system resource.</p>', 'MaxP95Performance$ThroughputRead' => '<p>Peak throughput related to read operations.</p>', 'MaxP95Performance$ThroughputWrite' => '<p>Peak throughput related to write operations.</p>', 'MaxP95Performance$ThroughputOther' => '<p>Peak throughput unrelated to read and write operations.</p>', 'MaxP95Performance$ThroughputTotal' => '<p>Peak total throughput on your on-premises storage system resource.</p>', 'MaxP95Performance$LatencyRead' => '<p>Peak latency for read operations.</p>', 'MaxP95Performance$LatencyWrite' => '<p>Peak latency for write operations.</p>', 'MaxP95Performance$LatencyOther' => '<p>Peak latency for operations unrelated to read and write operations.</p>', 'Throughput$Read' => '<p>Peak throughput related to read operations.</p>', 'Throughput$Write' => '<p>Peak throughput related to write operations.</p>', 'Throughput$Other' => '<p>Peak throughput unrelated to read and write operations.</p>', 'Throughput$Total' => '<p>Peak total throughput on your on-premises storage system resource.</p>', ], ], 'NonNegativeLong' => [ 'base' => NULL, 'refs' => [ 'Capacity$Used' => '<p>The amount of space that\'s being used in a storage system resource.</p>', 'Capacity$Provisioned' => '<p>The total amount of space available in a storage system resource.</p>', 'Capacity$LogicalUsed' => '<p>The amount of space that\'s being used in a storage system resource without accounting for compression or deduplication.</p>', 'Capacity$ClusterCloudStorageUsed' => '<p>The amount of space in the cluster that\'s in cloud storage (for example, if you\'re using data tiering).</p>', 'NetAppONTAPCluster$CifsShareCount' => '<p>The number of CIFS shares in the cluster.</p>', 'NetAppONTAPCluster$NfsExportedVolumes' => '<p>The number of NFS volumes in the cluster.</p>', 'NetAppONTAPCluster$ClusterBlockStorageSize' => '<p>The total storage space that\'s available in the cluster.</p>', 'NetAppONTAPCluster$ClusterBlockStorageUsed' => '<p>The storage space that\'s being used in a cluster.</p>', 'NetAppONTAPCluster$ClusterBlockStorageLogicalUsed' => '<p>The storage space that\'s being used in the cluster without accounting for compression or deduplication.</p>', 'NetAppONTAPCluster$LunCount' => '<p>The number of LUNs (logical unit numbers) in the cluster.</p>', 'NetAppONTAPCluster$ClusterCloudStorageUsed' => '<p>The amount of space in the cluster that\'s in cloud storage (for example, if you\'re using data tiering).</p>', 'NetAppONTAPSVM$CifsShareCount' => '<p>The number of CIFS shares in the SVM.</p>', 'NetAppONTAPSVM$TotalCapacityUsed' => '<p>The storage space that\'s being used in the SVM.</p>', 'NetAppONTAPSVM$TotalCapacityProvisioned' => '<p>The total storage space that\'s available in the SVM.</p>', 'NetAppONTAPSVM$TotalLogicalCapacityUsed' => '<p>The storage space that\'s being used in the SVM without accounting for compression or deduplication.</p>', 'NetAppONTAPSVM$NfsExportedVolumes' => '<p>The number of NFS volumes in the SVM.</p>', 'NetAppONTAPSVM$TotalSnapshotCapacityUsed' => '<p>The amount of storage in the SVM that\'s being used for snapshots.</p>', 'NetAppONTAPSVM$LunCount' => '<p>The number of LUNs (logical unit numbers) in the SVM.</p>', 'NetAppONTAPVolume$CifsShareCount' => '<p>The number of CIFS shares in the volume.</p>', 'NetAppONTAPVolume$CapacityUsed' => '<p>The storage space that\'s being used in the volume.</p>', 'NetAppONTAPVolume$CapacityProvisioned' => '<p>The total storage space that\'s available in the volume.</p>', 'NetAppONTAPVolume$LogicalCapacityUsed' => '<p>The storage space that\'s being used in the volume without accounting for compression or deduplication.</p>', 'NetAppONTAPVolume$SnapshotCapacityUsed' => '<p>The amount of storage in the volume that\'s being used for snapshots.</p>', 'NetAppONTAPVolume$LunCount' => '<p>The number of LUNs (logical unit numbers) in the volume.</p>', ], ], 'ObjectStorageAccessKey' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$AccessKey' => '<p>Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.</p>', 'DescribeLocationObjectStorageResponse$AccessKey' => '<p>The access key (for example, a user name) required to authenticate with the object storage system.</p>', 'UpdateLocationObjectStorageRequest$AccessKey' => '<p>Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.</p>', ], ], 'ObjectStorageBucketName' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$BucketName' => '<p>Specifies the name of the object storage bucket involved in the transfer.</p>', ], ], 'ObjectStorageCertificate' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$ServerCertificate' => '<p>Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA). You must specify a single <code>.pem</code> file with a full certificate chain (for example, <code>file:///home/user/.ssh/object_storage_certificates.pem</code>).</p> <p>The certificate chain might include:</p> <ul> <li> <p>The object storage system\'s certificate</p> </li> <li> <p>All intermediate certificates (if there are any)</p> </li> <li> <p>The root certificate of the signing CA</p> </li> </ul> <p>You can concatenate your certificates into a <code>.pem</code> file (which can be up to 32768 bytes before base64 encoding). The following example <code>cat</code> command creates an <code>object_storage_certificates.pem</code> file that includes three certificates:</p> <p> <code>cat object_server_certificate.pem intermediate_certificate.pem ca_root_certificate.pem &gt; object_storage_certificates.pem</code> </p> <p>To use this parameter, configure <code>ServerProtocol</code> to <code>HTTPS</code>.</p>', 'DescribeLocationObjectStorageResponse$ServerCertificate' => '<p>The certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA).</p>', 'UpdateLocationObjectStorageRequest$ServerCertificate' => '<p>Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA). You must specify a single <code>.pem</code> file with a full certificate chain (for example, <code>file:///home/user/.ssh/object_storage_certificates.pem</code>).</p> <p>The certificate chain might include:</p> <ul> <li> <p>The object storage system\'s certificate</p> </li> <li> <p>All intermediate certificates (if there are any)</p> </li> <li> <p>The root certificate of the signing CA</p> </li> </ul> <p>You can concatenate your certificates into a <code>.pem</code> file (which can be up to 32768 bytes before base64 encoding). The following example <code>cat</code> command creates an <code>object_storage_certificates.pem</code> file that includes three certificates:</p> <p> <code>cat object_server_certificate.pem intermediate_certificate.pem ca_root_certificate.pem &gt; object_storage_certificates.pem</code> </p> <p>To use this parameter, configure <code>ServerProtocol</code> to <code>HTTPS</code>.</p> <p>Updating this parameter doesn\'t interfere with tasks that you have in progress.</p>', ], ], 'ObjectStorageSecretKey' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$SecretKey' => '<p>Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.</p>', 'UpdateLocationObjectStorageRequest$SecretKey' => '<p>Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.</p>', ], ], 'ObjectStorageServerPort' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$ServerPort' => '<p>Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).</p>', 'DescribeLocationObjectStorageResponse$ServerPort' => '<p>The port that your object storage server accepts inbound network traffic on (for example, port 443).</p>', 'UpdateLocationObjectStorageRequest$ServerPort' => '<p>Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).</p>', ], ], 'ObjectStorageServerProtocol' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$ServerProtocol' => '<p>Specifies the protocol that your object storage server uses to communicate.</p>', 'DescribeLocationObjectStorageResponse$ServerProtocol' => '<p>The protocol that your object storage system uses to communicate.</p>', 'UpdateLocationObjectStorageRequest$ServerProtocol' => '<p>Specifies the protocol that your object storage server uses to communicate.</p>', ], ], 'ObjectTags' => [ 'base' => NULL, 'refs' => [ 'Options$ObjectTags' => '<p>Specifies whether you want DataSync to <code>PRESERVE</code> object tags (default behavior) when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.</p>', ], ], 'ObjectVersionIds' => [ 'base' => NULL, 'refs' => [ 'TaskReportConfig$ObjectVersionIds' => '<p>Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable versioning on your bucket</a>. Keep in mind that setting this to <code>INCLUDE</code> can increase the duration of your task execution.</p>', ], ], 'OnPremConfig' => [ 'base' => '<p>The DataSync agents that are connecting to a Network File System (NFS) location.</p>', 'refs' => [ 'CreateLocationNfsRequest$OnPremConfig' => '<p>Specifies the Amazon Resource Name (ARN) of the DataSync agent that want to connect to your NFS file server.</p> <p>You can specify more than one agent. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html">Using multiple agents for transfers</a>.</p>', 'DescribeLocationNfsResponse$OnPremConfig' => NULL, 'UpdateLocationNfsRequest$OnPremConfig' => NULL, ], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'LocationFilter$Operator' => '<p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>).</p>', 'TaskFilter$Operator' => '<p>The operator that is used to compare filter values (for example, <code>Equals</code> or <code>Contains</code>).</p>', ], ], 'Options' => [ 'base' => '<p>Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.</p> <p>Each option has a default value. Unless you need to, you don\'t have to configure any option before calling <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p> <p>You also can override your task options for each task execution. For example, you might want to adjust the <code>LogLevel</code> for an individual execution.</p>', 'refs' => [ 'CreateTaskRequest$Options' => '<p>Specifies your task\'s settings, such as preserving file metadata, verifying data integrity, among other options.</p>', 'DescribeTaskExecutionResponse$Options' => NULL, 'DescribeTaskResponse$Options' => '<p>The task\'s settings. For example, what file metadata gets preserved, how data integrity gets verified at the end of your transfer, bandwidth limits, among other options.</p>', 'StartTaskExecutionRequest$OverrideOptions' => NULL, 'UpdateTaskExecutionRequest$Options' => NULL, 'UpdateTaskRequest$Options' => NULL, ], ], 'OutputTagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>An array of tags applied to the specified resource.</p>', ], ], 'OverwriteMode' => [ 'base' => NULL, 'refs' => [ 'Options$OverwriteMode' => '<p>Specifies whether DataSync should modify or preserve data at the destination location.</p> <ul> <li> <p> <code>ALWAYS</code> (default) - DataSync modifies data in the destination location when source data (including metadata) has changed.</p> <p>If DataSync overwrites objects, you might incur additional charges for certain Amazon S3 storage classes (for example, for retrieval or early deletion). For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 transfers</a>.</p> </li> <li> <p> <code>NEVER</code> - DataSync doesn\'t overwrite data in the destination location even if the source data has changed. You can use this option to protect against overwriting changes made to files or objects in the destination.</p> </li> </ul>', ], ], 'P95Metrics' => [ 'base' => '<p>The types of performance data that DataSync Discovery collects about an on-premises storage system resource.</p>', 'refs' => [ 'ResourceMetrics$P95Metrics' => '<p>The types of performance data that DataSync Discovery collects about the on-premises storage system resource.</p>', ], ], 'PLSecurityGroupArnList' => [ 'base' => NULL, 'refs' => [ 'CreateAgentRequest$SecurityGroupArns' => '<p>Specifies the Amazon Resource Name (ARN) of the security group that protects your task\'s <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces">network interfaces</a> when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc">using a virtual private cloud (VPC) endpoint</a>. You can only specify one ARN.</p>', 'PrivateLinkConfig$SecurityGroupArns' => '<p>Specifies the Amazon Resource Names (ARN) of the security group that provides DataSync access to your VPC endpoint. You can only specify one ARN.</p>', ], ], 'PLSubnetArnList' => [ 'base' => NULL, 'refs' => [ 'CreateAgentRequest$SubnetArns' => '<p>Specifies the ARN of the subnet where you want to run your DataSync task when using a VPC endpoint. This is the subnet where DataSync creates and manages the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces">network interfaces</a> for your transfer. You can only specify one ARN.</p>', 'PrivateLinkConfig$SubnetArns' => '<p>Specifies the ARN of the subnet where your VPC endpoint is located. You can only specify one ARN.</p>', ], ], 'PhaseStatus' => [ 'base' => NULL, 'refs' => [ 'ReportResult$Status' => '<p>Indicates whether DataSync is still working on your report, created a report, or can\'t create a complete report.</p>', 'TaskExecutionResultDetail$PrepareStatus' => '<p>The status of the PREPARING phase.</p>', 'TaskExecutionResultDetail$TransferStatus' => '<p>The status of the TRANSFERRING phase.</p>', 'TaskExecutionResultDetail$VerifyStatus' => '<p>The status of the VERIFYING phase.</p>', ], ], 'Platform' => [ 'base' => '<p>The platform-related details about the DataSync agent, such as the version number.</p>', 'refs' => [ 'AgentListEntry$Platform' => '<p>The platform-related details about the agent, such as the version number.</p>', 'DescribeAgentResponse$Platform' => '<p>The platform-related details about the agent, such as the version number.</p>', ], ], 'PosixPermissions' => [ 'base' => NULL, 'refs' => [ 'Options$PosixPermissions' => '<p>Specifies which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata copied by DataSync</a>.</p> <ul> <li> <p> <code>PRESERVE</code> (default) - Preserves POSIX-style permissions, which is recommended.</p> </li> <li> <p> <code>NONE</code> - Ignores POSIX-style permissions. </p> </li> </ul> <note> <p>DataSync can preserve extant permissions of a source location.</p> </note>', ], ], 'PreserveDeletedFiles' => [ 'base' => NULL, 'refs' => [ 'Options$PreserveDeletedFiles' => '<p>Specifies whether files in the destination location that don\'t exist in the source should be preserved. This option can affect your Amazon S3 storage cost. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a>.</p> <ul> <li> <p> <code>PRESERVE</code> (default) - Ignores such destination files, which is recommended. </p> </li> <li> <p> <code>REMOVE</code> - Deletes destination files that aren’t present in the source.</p> </li> </ul> <note> <p>If you set this parameter to <code>REMOVE</code>, you can\'t set <code>TransferMode</code> to <code>ALL</code>. When you transfer all data, DataSync doesn\'t scan your destination location and doesn\'t know what to delete.</p> </note>', ], ], 'PreserveDevices' => [ 'base' => NULL, 'refs' => [ 'Options$PreserveDevices' => '<p>Specifies whether DataSync should preserve the metadata of block and character devices in the source location and recreate the files with that device name and metadata on the destination. DataSync copies only the name and metadata of such devices.</p> <note> <p>DataSync can\'t copy the actual contents of these devices because they\'re nonterminal and don\'t return an end-of-file (EOF) marker.</p> </note> <ul> <li> <p> <code>NONE</code> (default) - Ignores special devices (recommended).</p> </li> <li> <p> <code>PRESERVE</code> - Preserves character and block device metadata. This option currently isn\'t supported for Amazon EFS.</p> </li> </ul>', ], ], 'PrivateLinkConfig' => [ 'base' => '<p>Specifies how your DataSync agent connects to Amazon Web Services using a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc">virtual private cloud (VPC) service endpoint</a>. An agent that uses a VPC endpoint isn\'t accessible over the public internet.</p>', 'refs' => [ 'DescribeAgentResponse$PrivateLinkConfig' => '<p>The network configuration that the agent uses when connecting to a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc">VPC service endpoint</a>.</p>', ], ], 'PtolemyBoolean' => [ 'base' => NULL, 'refs' => [ 'NetAppONTAPVolume$NfsExported' => '<p>The number of NFS volumes in the volume.</p>', ], ], 'PtolemyPassword' => [ 'base' => NULL, 'refs' => [ 'Credentials$Password' => '<p>Specifies the password for your storage system\'s management interface.</p>', ], ], 'PtolemyString' => [ 'base' => NULL, 'refs' => [ 'EnabledProtocols$member' => NULL, 'FilterMembers$member' => NULL, 'NetAppONTAPCluster$ClusterName' => '<p>The name of the cluster.</p>', 'NetAppONTAPSVM$SvmName' => '<p>The name of the SVM</p>', 'NetAppONTAPVolume$VolumeName' => '<p>The name of the volume.</p>', 'NetAppONTAPVolume$SecurityStyle' => '<p>The volume\'s security style (such as Unix or NTFS).</p>', 'NetAppONTAPVolume$SvmName' => '<p>The name of the SVM associated with the volume.</p>', 'Recommendation$StorageType' => '<p>A recommended Amazon Web Services storage service that you can migrate data to based on information that DataSync Discovery collects about your on-premises storage system.</p>', 'Recommendation$EstimatedMonthlyStorageCost' => '<p>The estimated monthly cost of the recommended Amazon Web Services storage service.</p>', 'RecommendationsConfigMap$key' => NULL, 'RecommendationsConfigMap$value' => NULL, ], ], 'PtolemyUUID' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemRequest$ClientToken' => '<p>Specifies a client token to make sure requests with this API operation are idempotent. If you don\'t specify a client token, DataSync generates one for you automatically.</p>', 'NetAppONTAPCluster$ResourceId' => '<p>The universally unique identifier (UUID) of the cluster.</p>', 'NetAppONTAPSVM$ClusterUuid' => '<p>The universally unique identifier (UUID) of the cluster associated with the SVM.</p>', 'NetAppONTAPSVM$ResourceId' => '<p>The UUID of the SVM.</p>', 'NetAppONTAPVolume$ResourceId' => '<p>The universally unique identifier (UUID) of the volume.</p>', 'NetAppONTAPVolume$SvmUuid' => '<p>The UUID of the storage virtual machine (SVM) associated with the volume.</p>', 'StartDiscoveryJobRequest$ClientToken' => '<p>Specifies a client token to make sure requests with this API operation are idempotent. If you don\'t specify a client token, DataSync generates one for you automatically.</p>', ], ], 'PtolemyUsername' => [ 'base' => NULL, 'refs' => [ 'Credentials$Username' => '<p>Specifies the user name for your storage system\'s management interface.</p>', ], ], 'QopConfiguration' => [ 'base' => '<p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster.</p>', 'refs' => [ 'CreateLocationHdfsRequest$QopConfiguration' => '<p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If <code>QopConfiguration</code> isn\'t specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code>. If you set <code>RpcProtection</code> or <code>DataTransferProtection</code>, the other parameter assumes the same value. </p>', 'DescribeLocationHdfsResponse$QopConfiguration' => '<p>The Quality of Protection (QOP) configuration, which specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the HDFS cluster. </p>', 'UpdateLocationHdfsRequest$QopConfiguration' => '<p>The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer privacy settings configured on the Hadoop Distributed File System (HDFS) cluster. </p>', ], ], 'Recommendation' => [ 'base' => '<p>The details about an Amazon Web Services storage service that DataSync Discovery recommends for a resource in your on-premises storage system.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">Recommendations provided by DataSync Discovery</a>.</p>', 'refs' => [ 'Recommendations$member' => NULL, ], ], 'RecommendationStatus' => [ 'base' => NULL, 'refs' => [ 'NetAppONTAPCluster$RecommendationStatus' => '<p>Indicates whether DataSync Discovery recommendations for the cluster are ready to view, incomplete, or can\'t be determined.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table">Recommendation statuses</a>.</p>', 'NetAppONTAPSVM$RecommendationStatus' => '<p>Indicates whether DataSync Discovery recommendations for the SVM are ready to view, incomplete, or can\'t be determined.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table">Recommendation statuses</a>.</p>', 'NetAppONTAPVolume$RecommendationStatus' => '<p>Indicates whether DataSync Discovery recommendations for the volume are ready to view, incomplete, or can\'t be determined.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table">Recommendation statuses</a>.</p>', ], ], 'Recommendations' => [ 'base' => NULL, 'refs' => [ 'NetAppONTAPCluster$Recommendations' => '<p>The Amazon Web Services storage services that DataSync Discovery recommends for the cluster. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">Recommendations provided by DataSync Discovery</a>.</p>', 'NetAppONTAPSVM$Recommendations' => '<p>The Amazon Web Services storage services that DataSync Discovery recommends for the SVM. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">Recommendations provided by DataSync Discovery</a>.</p>', 'NetAppONTAPVolume$Recommendations' => '<p>The Amazon Web Services storage services that DataSync Discovery recommends for the volume. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">Recommendations provided by DataSync Discovery</a>.</p>', ], ], 'RecommendationsConfigMap' => [ 'base' => NULL, 'refs' => [ 'Recommendation$StorageConfiguration' => '<p>Information about how you can set up a recommended Amazon Web Services storage service.</p>', ], ], 'RemoveStorageSystemRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveStorageSystemResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReportDestination' => [ 'base' => '<p>Specifies where DataSync uploads your <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a>.</p>', 'refs' => [ 'TaskReportConfig$Destination' => '<p>Specifies the Amazon S3 bucket where DataSync uploads your task report. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access">Task reports</a>.</p>', ], ], 'ReportDestinationS3' => [ 'base' => '<p>Specifies the Amazon S3 bucket where DataSync uploads your <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a>.</p>', 'refs' => [ 'ReportDestination$S3' => '<p>Specifies the Amazon S3 bucket where DataSync uploads your task report.</p>', ], ], 'ReportLevel' => [ 'base' => NULL, 'refs' => [ 'ReportOverride$ReportLevel' => '<p>Specifies whether your task report includes errors only or successes and errors.</p> <p>For example, your report might mostly include only what didn\'t go well in your transfer (<code>ERRORS_ONLY</code>). At the same time, you want to verify that your <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">task filter</a> is working correctly. In this situation, you can get a list of what files DataSync successfully skipped and if something transferred that you didn\'t to transfer (<code>SUCCESSES_AND_ERRORS</code>).</p>', 'TaskReportConfig$ReportLevel' => '<p>Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn\'t.</p> <ul> <li> <p> <code>ERRORS_ONLY</code>: A report shows what DataSync was unable to transfer, skip, verify, and delete.</p> </li> <li> <p> <code>SUCCESSES_AND_ERRORS</code>: A report shows what DataSync was able and unable to transfer, skip, verify, and delete.</p> </li> </ul>', ], ], 'ReportOutputType' => [ 'base' => NULL, 'refs' => [ 'TaskReportConfig$OutputType' => '<p>Specifies the type of task report that you want:</p> <ul> <li> <p> <code>SUMMARY_ONLY</code>: Provides necessary details about your task, including the number of files, objects, and directories transferred and transfer duration.</p> </li> <li> <p> <code>STANDARD</code>: Provides complete details about your task, including a full list of files, objects, and directories that were transferred, skipped, verified, and more.</p> </li> </ul>', ], ], 'ReportOverride' => [ 'base' => '<p>Specifies the level of detail for a particular aspect of your DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a>.</p>', 'refs' => [ 'ReportOverrides$Transferred' => '<p>Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer.</p>', 'ReportOverrides$Verified' => '<p>Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer.</p>', 'ReportOverrides$Deleted' => '<p>Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a> to delete data in the destination that isn\'t in the source.</p>', 'ReportOverrides$Skipped' => '<p>Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer.</p>', ], ], 'ReportOverrides' => [ 'base' => '<p>The level of detail included in each aspect of your DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a>.</p>', 'refs' => [ 'TaskReportConfig$Overrides' => '<p>Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that DataSync attempted to delete in your destination location.</p>', ], ], 'ReportResult' => [ 'base' => '<p>Indicates whether DataSync created a complete <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your transfer.</p>', 'refs' => [ 'DescribeTaskExecutionResponse$ReportResult' => '<p>Indicates whether DataSync generated a complete <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">task report</a> for your transfer.</p>', ], ], 'ResourceDetails' => [ 'base' => '<p>Information provided by DataSync Discovery about the resources in your on-premises storage system.</p>', 'refs' => [ 'DescribeStorageSystemResourcesResponse$ResourceDetails' => '<p>The information collected about your storage system\'s resources. A response can also include Amazon Web Services storage service recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html">storage resource information</a> collected by and <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html">recommendations</a> provided by DataSync Discovery.</p>', ], ], 'ResourceFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourcesRequest$Filter' => '<p>Filters the storage system resources that you want returned. For example, this might be volumes associated with a specific storage virtual machine (SVM).</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourceMetricsRequest$ResourceId' => '<p>Specifies the universally unique identifier (UUID) of the storage system resource that you want information about.</p>', 'ResourceIds$member' => NULL, 'ResourceMetrics$ResourceId' => '<p>The universally unique identifier (UUID) of the on-premises storage system resource.</p>', ], ], 'ResourceIds' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResourcesRequest$ResourceIds' => '<p>Specifies the universally unique identifiers (UUIDs) of the storage system resources that you want information about. You can\'t use this parameter in combination with the <code>Filter</code> parameter.</p>', 'GenerateRecommendationsRequest$ResourceIds' => '<p>Specifies the universally unique identifiers (UUIDs) of the resources in your storage system that you want recommendations on.</p>', ], ], 'ResourceMetrics' => [ 'base' => '<p>Information, including performance data and capacity usage, provided by DataSync Discovery about a resource in your on-premises storage system.</p>', 'refs' => [ 'Metrics$member' => NULL, ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationS3Request$S3BucketArn' => '<p>Specifies the ARN of the S3 bucket that you want to use as a location. (When creating your DataSync task later, you specify whether this location is a transfer source or destination.) </p> <p>If your S3 bucket is located on an Outposts resource, you must specify an Amazon S3 access point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'ReportDestinationS3$S3BucketArn' => '<p>Specifies the ARN of the S3 bucket where DataSync uploads your report.</p>', 'S3ManifestConfig$S3BucketArn' => '<p>Specifies the Amazon Resource Name (ARN) of the S3 bucket where you\'re hosting your manifest.</p>', ], ], 'S3Config' => [ 'base' => '<p>Specifies the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that DataSync uses to access your S3 bucket.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access">Accessing S3 buckets</a>.</p>', 'refs' => [ 'CreateLocationS3Request$S3Config' => NULL, 'DescribeLocationS3Response$S3Config' => NULL, ], ], 'S3ManifestConfig' => [ 'base' => '<p>Specifies the S3 bucket where you\'re hosting the manifest that you want DataSync to use. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p>', 'refs' => [ 'SourceManifestConfig$S3' => '<p>Specifies the S3 bucket where you\'re hosting your manifest.</p>', ], ], 'S3ObjectVersionId' => [ 'base' => NULL, 'refs' => [ 'S3ManifestConfig$ManifestObjectVersionId' => '<p>Specifies the object version ID of the manifest that you want DataSync to use. If you don\'t set this, DataSync uses the latest version of the object.</p>', ], ], 'S3StorageClass' => [ 'base' => NULL, 'refs' => [ 'CreateLocationS3Request$S3StorageClass' => '<p>Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.</p> <p>For buckets in Amazon Web Services Regions, the storage class defaults to <code>STANDARD</code>. For buckets on Outposts, the storage class defaults to <code>OUTPOSTS</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 transfers</a>.</p>', 'DescribeLocationS3Response$S3StorageClass' => '<p>When Amazon S3 is a destination location, this is the storage class that you chose for your objects.</p> <p>Some storage classes have behaviors that can affect your Amazon S3 storage costs. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 transfers</a>.</p>', ], ], 'S3Subdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationObjectStorageRequest$Subdirectory' => '<p>Specifies the object prefix for your object storage server. If this is a source location, DataSync only copies objects with this prefix. If this is a destination location, DataSync writes all objects with this prefix. </p>', 'CreateLocationS3Request$Subdirectory' => '<p>Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the bucket is a source or destination location).</p> <note> <p>DataSync can\'t transfer objects with a prefix that begins with a slash (<code>/</code>) or includes <code>//</code>, <code>/./</code>, or <code>/../</code> patterns. For example:</p> <ul> <li> <p> <code>/photos</code> </p> </li> <li> <p> <code>photos//2006/January</code> </p> </li> <li> <p> <code>photos/./2006/February</code> </p> </li> <li> <p> <code>photos/../2006/March</code> </p> </li> </ul> </note>', 'ReportDestinationS3$Subdirectory' => '<p>Specifies a bucket prefix for your report.</p>', 'S3ManifestConfig$ManifestObjectPath' => '<p>Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example, <code>prefix/my-manifest.csv</code>).</p>', 'UpdateLocationObjectStorageRequest$Subdirectory' => '<p>Specifies the object prefix for your object storage server. If this is a source location, DataSync only copies objects with this prefix. If this is a destination location, DataSync writes all objects with this prefix.</p>', ], ], 'ScheduleDisabledBy' => [ 'base' => NULL, 'refs' => [ 'TaskScheduleDetails$DisabledBy' => '<p>Indicates how your task schedule was disabled.</p> <ul> <li> <p> <code>USER</code> - Your schedule was manually disabled by using the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation or DataSync console.</p> </li> <li> <p> <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed repeatedly with the same error.</p> </li> </ul>', ], ], 'ScheduleDisabledReason' => [ 'base' => NULL, 'refs' => [ 'TaskScheduleDetails$DisabledReason' => '<p>Provides a reason if the task schedule is disabled.</p> <p>If your schedule is disabled by <code>USER</code>, you see a <code>Manually disabled by user.</code> message.</p> <p>If your schedule is disabled by <code>SERVICE</code>, you see an error message to help you understand why the task keeps failing. For information on resolving DataSync errors, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html">Troubleshooting issues with DataSync transfers</a>.</p>', ], ], 'ScheduleExpressionCron' => [ 'base' => NULL, 'refs' => [ 'TaskSchedule$ScheduleExpression' => '<p>Specifies your task schedule by using a cron expression in UTC time. For information about cron expression syntax, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html"> <i>Amazon EventBridge User Guide</i> </a>.</p>', ], ], 'ScheduleStatus' => [ 'base' => NULL, 'refs' => [ 'TaskSchedule$Status' => '<p>Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an issue with your task or perform maintenance on your storage system.</p> <p>DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html">TaskScheduleDetails</a>.</p>', ], ], 'SecretsManagerArn' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResponse$SecretsManagerArn' => '<p>The ARN of the secret that stores your on-premises storage system\'s credentials. DataSync Discovery stores these credentials in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html#discovery-add-storage">Secrets Manager</a>.</p>', ], ], 'ServerHostname' => [ 'base' => NULL, 'refs' => [ 'CreateLocationNfsRequest$ServerHostname' => '<p>Specifies the Domain Name System (DNS) name or IP version 4 address of the NFS file server that your DataSync agent connects to.</p>', 'CreateLocationObjectStorageRequest$ServerHostname' => '<p>Specifies the domain name or IP address of the object storage server. A DataSync agent uses this hostname to mount the object storage server in a network.</p>', 'CreateLocationSmbRequest$ServerHostname' => '<p>Specifies the Domain Name Service (DNS) name or IP address of the SMB file server that your DataSync agent will mount.</p> <note> <p>You can\'t specify an IP version 6 (IPv6) address.</p> </note>', ], ], 'SmbDomain' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxWindowsRequest$Domain' => '<p>Specifies the name of the Microsoft Active Directory domain that the FSx for Windows File Server file system belongs to.</p> <p>If you have multiple Active Directory domains in your environment, configuring this parameter makes sure that DataSync connects to the right file system.</p>', 'CreateLocationSmbRequest$Domain' => '<p>Specifies the name of the Active Directory domain that your SMB file server belongs to. </p> <p>If you have multiple Active Directory domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.</p>', 'DescribeLocationFsxWindowsResponse$Domain' => '<p>The name of the Microsoft Active Directory domain that the FSx for Windows File Server file system belongs to.</p>', 'DescribeLocationSmbResponse$Domain' => '<p>The name of the Microsoft Active Directory domain that the SMB file server belongs to.</p>', 'FsxProtocolSmb$Domain' => '<p>Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage virtual machine (SVM) belongs to.</p> <p>If you have multiple domains in your environment, configuring this setting makes sure that DataSync connects to the right SVM.</p>', 'UpdateLocationSmbRequest$Domain' => '<p>Specifies the Windows domain name that your SMB file server belongs to. </p> <p>If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', ], ], 'SmbMountOptions' => [ 'base' => '<p>Specifies the version of the Server Message Block (SMB) protocol that DataSync uses to access an SMB file server.</p>', 'refs' => [ 'CreateLocationSmbRequest$MountOptions' => '<p>Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.</p>', 'DescribeLocationSmbResponse$MountOptions' => '<p>The protocol that DataSync use to access your SMB file.</p>', 'FsxProtocolSmb$MountOptions' => NULL, 'UpdateLocationSmbRequest$MountOptions' => NULL, ], ], 'SmbPassword' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxWindowsRequest$Password' => '<p>Specifies the password of the user with the permissions to mount and access the files, folders, and file metadata in your FSx for Windows File Server file system.</p>', 'CreateLocationSmbRequest$Password' => '<p>Specifies the password of the user who can mount your SMB file server and has permission to access the files and folders involved in your transfer.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', 'FsxProtocolSmb$Password' => '<p>Specifies the password of a user who has permission to access your SVM.</p>', 'UpdateLocationSmbRequest$Password' => '<p>Specifies the password of the user who can mount your SMB file server and has permission to access the files and folders involved in your transfer.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', ], ], 'SmbSecurityDescriptorCopyFlags' => [ 'base' => NULL, 'refs' => [ 'Options$SecurityDescriptorCopyFlags' => '<p>Specifies which components of the SMB security descriptor are copied from source to destination objects. </p> <p>This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations or between two FSx for Windows File Server locations. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">how DataSync handles metadata</a>.</p> <ul> <li> <p> <code>OWNER_DACL</code> (default) - For each copied object, DataSync copies the following metadata:</p> <ul> <li> <p>The object owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> <p>DataSync won\'t copy NTFS system access control lists (SACLs) with this option.</p> </li> </ul> </li> <li> <p> <code>OWNER_DACL_SACL</code> - For each copied object, DataSync copies the following metadata:</p> <ul> <li> <p>The object owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</p> </li> <li> <p>SACLs, which are used by administrators to log attempts to access a secured object.</p> <p>Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user with the right permissions, see required permissions for <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">SMB</a>, <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions">FSx for Windows File Server</a>, or <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb">FSx for ONTAP</a> (depending on the type of location in your transfer).</p> </li> </ul> </li> <li> <p> <code>NONE</code> - None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration. </p> </li> </ul>', ], ], 'SmbSubdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateLocationSmbRequest$Subdirectory' => '<p>Specifies the name of the share exported by your SMB file server where DataSync will read or write data. You can include a subdirectory in the share path (for example, <code>/path/to/subdirectory</code>). Make sure that other SMB clients in your network can also mount this path.</p> <p>To copy all data in the subdirectory, DataSync must be able to mount the SMB share and access all of its data. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', 'UpdateLocationSmbRequest$Subdirectory' => '<p>Specifies the name of the share exported by your SMB file server where DataSync will read or write data. You can include a subdirectory in the share path (for example, <code>/path/to/subdirectory</code>). Make sure that other SMB clients in your network can also mount this path.</p> <p>To copy all data in the specified subdirectory, DataSync must be able to mount the SMB share and access all of its data. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', ], ], 'SmbUser' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxWindowsRequest$User' => '<p>Specifies the user with the permissions to mount and access the files, folders, and file metadata in your FSx for Windows File Server file system.</p> <p>For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions">required permissions</a> for FSx for Windows File Server locations.</p>', 'CreateLocationSmbRequest$User' => '<p>Specifies the user that can mount and access the files, folders, and file metadata in your SMB file server.</p> <p>For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', 'DescribeLocationFsxWindowsResponse$User' => '<p>The user with the permissions to mount and access the FSx for Windows File Server file system.</p>', 'DescribeLocationSmbResponse$User' => '<p>The user that can mount and access the files, folders, and file metadata in your SMB file server.</p>', 'FsxProtocolSmb$User' => '<p>Specifies a user that can mount and access the files, folders, and metadata in your SVM.</p> <p>For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb">Using the SMB protocol</a>.</p>', 'UpdateLocationSmbRequest$User' => '<p>Specifies the user name that can mount your SMB file server and has permission to access the files and folders involved in your transfer.</p> <p>For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.</p>', ], ], 'SmbVersion' => [ 'base' => NULL, 'refs' => [ 'SmbMountOptions$Version' => '<p>By default, DataSync automatically chooses an SMB protocol version based on negotiation with your SMB file server. You also can configure DataSync to use a specific SMB version, but we recommend doing this only if DataSync has trouble negotiating with the SMB file server automatically.</p> <p>These are the following options for configuring the SMB version:</p> <ul> <li> <p> <code>AUTOMATIC</code> (default): DataSync and the SMB file server negotiate the highest version of SMB that they mutually support between 2.1 and 3.1.1.</p> <p>This is the recommended option. If you instead choose a specific version that your file server doesn\'t support, you may get an <code>Operation Not Supported</code> error.</p> </li> <li> <p> <code>SMB3</code>: Restricts the protocol negotiation to only SMB version 3.0.2.</p> </li> <li> <p> <code>SMB2</code>: Restricts the protocol negotiation to only SMB version 2.1.</p> </li> <li> <p> <code>SMB2_0</code>: Restricts the protocol negotiation to only SMB version 2.0.</p> </li> <li> <p> <code>SMB1</code>: Restricts the protocol negotiation to only SMB version 1.0.</p> <note> <p>The <code>SMB1</code> option isn\'t available when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html">creating an Amazon FSx for NetApp ONTAP location</a>.</p> </note> </li> </ul>', ], ], 'SourceManifestConfig' => [ 'base' => '<p>Specifies the manifest that you want DataSync to use and where it\'s hosted. For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a>.</p>', 'refs' => [ 'ManifestConfig$Source' => '<p>Specifies the manifest that you want DataSync to use and where it\'s hosted.</p> <note> <p>You must specify this parameter if you\'re configuring a new manifest on or after February 7, 2024.</p> <p>If you don\'t, you\'ll get a 400 status code and <code>ValidationException</code> error stating that you\'re missing the IAM role for DataSync to access the S3 bucket where you\'re hosting your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access">Providing DataSync access to your manifest</a>.</p> </note>', ], ], 'SourceNetworkInterfaceArns' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskResponse$SourceNetworkInterfaceArns' => '<p>The ARNs of the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces">network interfaces</a> that DataSync created for your source location.</p>', ], ], 'StartDiscoveryJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDiscoveryJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTaskExecutionRequest' => [ 'base' => '<p>StartTaskExecutionRequest</p>', 'refs' => [], ], 'StartTaskExecutionResponse' => [ 'base' => '<p>StartTaskExecutionResponse</p>', 'refs' => [], ], 'StopDiscoveryJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDiscoveryJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageSystemArn' => [ 'base' => NULL, 'refs' => [ 'AddStorageSystemResponse$StorageSystemArn' => '<p>The ARN of the on-premises storage system that you can use with DataSync Discovery.</p>', 'DescribeDiscoveryJobResponse$StorageSystemArn' => '<p>The ARN of the on-premises storage system you\'re running the discovery job on.</p>', 'DescribeStorageSystemRequest$StorageSystemArn' => '<p>Specifies the Amazon Resource Name (ARN) of an on-premises storage system that you\'re using with DataSync Discovery.</p>', 'DescribeStorageSystemResponse$StorageSystemArn' => '<p>The ARN of the on-premises storage system that the discovery job looked at.</p>', 'ListDiscoveryJobsRequest$StorageSystemArn' => '<p>Specifies the Amazon Resource Name (ARN) of an on-premises storage system. Use this parameter if you only want to list the discovery jobs that are associated with a specific storage system.</p>', 'RemoveStorageSystemRequest$StorageSystemArn' => '<p>Specifies the Amazon Resource Name (ARN) of the storage system that you want to permanently remove from DataSync Discovery.</p>', 'StartDiscoveryJobRequest$StorageSystemArn' => '<p>Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the discovery job on.</p>', 'StorageSystemListEntry$StorageSystemArn' => '<p>The Amazon Resource Names (ARN) of an on-premises storage system that you added to DataSync Discovery.</p>', 'UpdateStorageSystemRequest$StorageSystemArn' => '<p>Specifies the ARN of the on-premises storage system that you want reconfigure.</p>', ], ], 'StorageSystemConnectivityStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResponse$ConnectivityStatus' => '<p>Indicates whether your DataSync agent can connect to your on-premises storage system.</p>', ], ], 'StorageSystemList' => [ 'base' => NULL, 'refs' => [ 'ListStorageSystemsResponse$StorageSystems' => '<p>The Amazon Resource Names ARNs) of the on-premises storage systems that you\'re using with DataSync Discovery.</p>', ], ], 'StorageSystemListEntry' => [ 'base' => '<p>Information that identifies an on-premises storage system that you\'re using with DataSync Discovery.</p>', 'refs' => [ 'StorageSystemList$member' => NULL, ], ], 'StorageVirtualMachineArn' => [ 'base' => NULL, 'refs' => [ 'CreateLocationFsxOntapRequest$StorageVirtualMachineArn' => '<p>Specifies the ARN of the storage virtual machine (SVM) in your file system where you want to copy data to or from.</p>', 'DescribeLocationFsxOntapResponse$StorageVirtualMachineArn' => '<p>The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system where you\'re copying data to or from.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagListEntry$Key' => '<p>The key for an Amazon Web Services resource tag.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$Keys' => '<p>Specifies the keys in the tags that you want to remove.</p>', ], ], 'TagListEntry' => [ 'base' => '<p>A key-value pair representing a single tag that\'s been applied to an Amazon Web Services resource.</p>', 'refs' => [ 'InputTagList$member' => NULL, 'OutputTagList$member' => NULL, ], ], 'TagResourceRequest' => [ 'base' => '<p>TagResourceRequest</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'AgentListEntry$Name' => '<p>The name of an agent.</p>', 'CreateAgentRequest$AgentName' => '<p>Specifies a name for your agent. You can see this name in the DataSync console.</p>', 'CreateTaskRequest$Name' => '<p>Specifies the name of your task.</p>', 'DescribeAgentResponse$Name' => '<p>The name of the agent.</p>', 'DescribeTaskResponse$Name' => '<p>The name of your task.</p>', 'TagListEntry$Value' => '<p>The value for an Amazon Web Services resource tag.</p>', 'TaskListEntry$Name' => '<p>The name of the task.</p>', 'UpdateAgentRequest$Name' => '<p>The name that you want to use to configure the agent.</p>', 'UpdateTaskRequest$Name' => '<p>Specifies the name of your task.</p>', ], ], 'TaggableResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>Specifies the Amazon Resource Name (ARN) of the resource that you want tag information on.</p>', 'TagResourceRequest$ResourceArn' => '<p>Specifies the Amazon Resource Name (ARN) of the resource to apply the tag to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>Specifies the Amazon Resource Name (ARN) of the resource to remove the tags from.</p>', ], ], 'TaskArn' => [ 'base' => NULL, 'refs' => [ 'CreateTaskResponse$TaskArn' => '<p>The Amazon Resource Name (ARN) of the task.</p>', 'DeleteTaskRequest$TaskArn' => '<p>Specifies the Amazon Resource Name (ARN) of the task that you want to delete.</p>', 'DescribeTaskRequest$TaskArn' => '<p>Specifies the Amazon Resource Name (ARN) of the transfer task that you want information about.</p>', 'DescribeTaskResponse$TaskArn' => '<p>The ARN of your task.</p>', 'ListTaskExecutionsRequest$TaskArn' => '<p>Specifies the Amazon Resource Name (ARN) of the task that you want execution information about.</p>', 'StartTaskExecutionRequest$TaskArn' => '<p>Specifies the Amazon Resource Name (ARN) of the task that you want to start.</p>', 'TaskListEntry$TaskArn' => '<p>The Amazon Resource Name (ARN) of the task.</p>', 'UpdateTaskRequest$TaskArn' => '<p>Specifies the ARN of the task that you want to update.</p>', ], ], 'TaskExecutionArn' => [ 'base' => NULL, 'refs' => [ 'CancelTaskExecutionRequest$TaskExecutionArn' => '<p>The Amazon Resource Name (ARN) of the task execution to stop.</p>', 'DescribeTaskExecutionRequest$TaskExecutionArn' => '<p>Specifies the Amazon Resource Name (ARN) of the task execution that you want information about.</p>', 'DescribeTaskExecutionResponse$TaskExecutionArn' => '<p>The ARN of the task execution that you wanted information about. <code>TaskExecutionArn</code> is hierarchical and includes <code>TaskArn</code> for the task that was executed. </p> <p>For example, a <code>TaskExecution</code> value with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b</code> executed the task with the ARN <code>arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2</code>. </p>', 'DescribeTaskResponse$CurrentTaskExecutionArn' => '<p>The ARN of the most recent task execution.</p>', 'StartTaskExecutionResponse$TaskExecutionArn' => '<p>The ARN of the running task execution.</p>', 'TaskExecutionListEntry$TaskExecutionArn' => '<p>The Amazon Resource Name (ARN) of a task execution.</p>', 'UpdateTaskExecutionRequest$TaskExecutionArn' => '<p>Specifies the Amazon Resource Name (ARN) of the task execution that you\'re updating.</p>', ], ], 'TaskExecutionList' => [ 'base' => NULL, 'refs' => [ 'ListTaskExecutionsResponse$TaskExecutions' => '<p>A list of the task\'s executions.</p>', ], ], 'TaskExecutionListEntry' => [ 'base' => '<p>Represents a single entry in a list of DataSync task executions that\'s returned with the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html">ListTaskExecutions</a> operation.</p>', 'refs' => [ 'TaskExecutionList$member' => NULL, ], ], 'TaskExecutionResultDetail' => [ 'base' => '<p>Describes the detailed result of a <code>TaskExecution</code> operation. This result includes the time in milliseconds spent in each phase, the status of the task execution, and the errors encountered.</p>', 'refs' => [ 'DescribeTaskExecutionResponse$Result' => '<p>The result of the task execution.</p>', ], ], 'TaskExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskExecutionResponse$Status' => '<p>The status of the task execution. </p>', 'TaskExecutionListEntry$Status' => '<p>The status of a task execution. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/understand-task-statuses.html#understand-task-execution-statuses">Task execution statuses</a>.</p>', ], ], 'TaskFilter' => [ 'base' => '<p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html">filtering DataSync resources</a>.</p>', 'refs' => [ 'TaskFilters$member' => NULL, ], ], 'TaskFilterName' => [ 'base' => NULL, 'refs' => [ 'TaskFilter$Name' => '<p>The name of the filter being used. Each API call supports a list of filters that are available for it. For example, <code>LocationId</code> for <code>ListTasks</code>.</p>', ], ], 'TaskFilters' => [ 'base' => NULL, 'refs' => [ 'ListTasksRequest$Filters' => '<p>You can use API filters to narrow down the list of resources returned by <code>ListTasks</code>. For example, to retrieve all tasks on a specific source location, you can use <code>ListTasks</code> with filter name <code>LocationId</code> and <code>Operator Equals</code> with the ARN for the location.</p>', ], ], 'TaskList' => [ 'base' => NULL, 'refs' => [ 'ListTasksResponse$Tasks' => '<p>A list of all the tasks that are returned.</p>', ], ], 'TaskListEntry' => [ 'base' => '<p>Represents a single entry in a list of tasks. <code>TaskListEntry</code> returns an array that contains a list of tasks when the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTasks.html">ListTasks</a> operation is called. A task includes the source and destination file systems to sync and the options to use for the tasks.</p>', 'refs' => [ 'TaskList$member' => NULL, ], ], 'TaskQueueing' => [ 'base' => NULL, 'refs' => [ 'Options$TaskQueueing' => '<p>Specifies whether your transfer tasks should be put into a queue during certain scenarios when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#running-multiple-tasks">running multiple tasks</a>. This is <code>ENABLED</code> by default.</p>', ], ], 'TaskReportConfig' => [ 'base' => '<p>Specifies how you want to configure a task report, which provides detailed information about for your DataSync transfer.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Task reports</a>.</p>', 'refs' => [ 'CreateTaskRequest$TaskReportConfig' => '<p>Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a>.</p> <p>When using this parameter, your caller identity (the role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p>', 'DescribeTaskExecutionResponse$TaskReportConfig' => '<p>The configuration of your task report, which provides detailed information about for your DataSync transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Creating a task report</a>.</p>', 'DescribeTaskResponse$TaskReportConfig' => '<p>The configuration of your task report, which provides detailed information about your DataSync transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a>.</p>', 'StartTaskExecutionRequest$TaskReportConfig' => '<p>Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a>.</p> <p>When using this parameter, your caller identity (the role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p> <p>To remove a task report configuration, specify this parameter as empty.</p>', 'UpdateTaskRequest$TaskReportConfig' => '<p>Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a>.</p> <p>When using this parameter, your caller identity (the IAM role that you\'re using DataSync with) must have the <code>iam:PassRole</code> permission. The <a href="https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess">AWSDataSyncFullAccess</a> policy includes this permission.</p> <p>To remove a task report configuration, specify this parameter as empty.</p>', ], ], 'TaskSchedule' => [ 'base' => '<p>Configures your DataSync task to run on a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">schedule</a> (at a minimum interval of 1 hour).</p>', 'refs' => [ 'CreateTaskRequest$Schedule' => '<p>Specifies a schedule for when you want your task to run. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>', 'DescribeTaskResponse$Schedule' => '<p>The schedule for when you want your task to run. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>', 'UpdateTaskRequest$Schedule' => '<p>Specifies a schedule for when you want your task to run. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a>.</p>', ], ], 'TaskScheduleDetails' => [ 'base' => '<p>Provides information about your DataSync <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">task schedule</a>.</p>', 'refs' => [ 'DescribeTaskResponse$ScheduleDetails' => '<p>The details about your <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">task schedule</a>.</p>', ], ], 'TaskStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskResponse$Status' => '<p>The status of your task. For information about what each status means, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/understand-task-statuses.html#understand-task-creation-statuses">Task statuses</a>.</p>', 'TaskListEntry$Status' => '<p>The status of the task.</p>', ], ], 'Throughput' => [ 'base' => '<p>The throughput peaks for an on-premises storage system volume. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', 'refs' => [ 'P95Metrics$Throughput' => '<p>The throughput peaks for an on-premises storage system resource. Each data point represents the 95th percentile peak value during a 1-hour interval.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentResponse$LastConnectionTime' => '<p>The last time that the agent was communicating with the DataSync service.</p>', 'DescribeAgentResponse$CreationTime' => '<p>The time that the agent was <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">activated</a>.</p>', 'DescribeLocationAzureBlobResponse$CreationTime' => '<p>The time that your Azure Blob Storage transfer location was created.</p>', 'DescribeLocationEfsResponse$CreationTime' => '<p>The time that the location was created.</p>', 'DescribeLocationFsxLustreResponse$CreationTime' => '<p>The time that the FSx for Lustre location was created.</p>', 'DescribeLocationFsxOntapResponse$CreationTime' => '<p>The time that the location was created.</p>', 'DescribeLocationFsxOpenZfsResponse$CreationTime' => '<p>The time that the FSx for OpenZFS location was created.</p>', 'DescribeLocationFsxWindowsResponse$CreationTime' => '<p>The time that the FSx for Windows File Server location was created.</p>', 'DescribeLocationHdfsResponse$CreationTime' => '<p>The time that the HDFS location was created.</p>', 'DescribeLocationNfsResponse$CreationTime' => '<p>The time when the NFS location was created.</p>', 'DescribeLocationObjectStorageResponse$CreationTime' => '<p>The time that the location was created.</p>', 'DescribeLocationS3Response$CreationTime' => '<p>The time that the Amazon S3 location was created.</p>', 'DescribeLocationSmbResponse$CreationTime' => '<p>The time that the SMB location was created.</p>', 'DescribeTaskExecutionResponse$StartTime' => '<p>The time when the task execution started.</p>', 'DescribeTaskResponse$CreationTime' => '<p>The time that the task was created.</p>', 'TaskScheduleDetails$StatusUpdateTime' => '<p>Indicates the last time the status of your task schedule changed. For example, if DataSync automatically disables your schedule because of a repeated error, you can see when the schedule was disabled.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageSystemResponse$CreationTime' => '<p>The time when you added the on-premises storage system to DataSync Discovery.</p>', 'ResourceMetrics$Timestamp' => '<p>The time when DataSync Discovery collected this information from the resource.</p>', ], ], 'TransferMode' => [ 'base' => NULL, 'refs' => [ 'Options$TransferMode' => '<p>Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location or transfers all the content from the source (without comparing what\'s in the destination).</p> <ul> <li> <p> <code>CHANGED</code> (default) - DataSync copies only data or metadata that is new or different content from the source location to the destination location.</p> </li> <li> <p> <code>ALL</code> - DataSync copies everything in the source to the destination without comparing differences between the locations.</p> </li> </ul>', ], ], 'Uid' => [ 'base' => NULL, 'refs' => [ 'Options$Uid' => '<p>Specifies the POSIX user ID (UID) of the file\'s owner.</p> <ul> <li> <p> <code>INT_VALUE</code> (default) - Preserves the integer value of UID and group ID (GID), which is recommended.</p> </li> <li> <p> <code>NONE</code> - Ignores UID and GID. </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata copied by DataSync</a>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => '<p>UntagResourceRequest</p>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentRequest' => [ 'base' => '<p>UpdateAgentRequest</p>', 'refs' => [], ], 'UpdateAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDiscoveryJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDiscoveryJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationAzureBlobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationAzureBlobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationHdfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationHdfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationNfsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationNfsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationObjectStorageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationObjectStorageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationSmbRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLocationSmbResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageSystemRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageSystemResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskRequest' => [ 'base' => '<p>UpdateTaskResponse</p>', 'refs' => [], ], 'UpdateTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'VerifyMode' => [ 'base' => NULL, 'refs' => [ 'Options$VerifyMode' => '<p>Specifies how and when DataSync checks the integrity of your data during a transfer.</p> <ul> <li> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended) - DataSync calculates the checksum of transferred files and metadata at the source location. At the end of the transfer, DataSync then compares this checksum to the checksum calculated on those files at the destination.</p> <p>We recommend this option when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 locations</a>.</p> </li> <li> <p> <code>POINT_IN_TIME_CONSISTENT</code> (default) - At the end of the transfer, DataSync scans the entire source and destination to verify that both locations are fully synchronized.</p> <p>If you use a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">manifest</a>, DataSync only scans and verifies what\'s listed in the manifest.</p> <p>You can\'t use this option when transferring to S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 locations</a>.</p> </li> <li> <p> <code>NONE</code> - DataSync doesn\'t run additional verification at the end of the transfer. All data transmissions are still integrity-checked with checksum verification during the transfer.</p> </li> </ul>', ], ], 'VpcEndpointId' => [ 'base' => NULL, 'refs' => [ 'CreateAgentRequest$VpcEndpointId' => '<p>Specifies the ID of the VPC endpoint that you want your agent to connect to. For example, a VPC endpoint ID looks like <code>vpce-01234d5aff67890e1</code>.</p> <important> <p>The VPC endpoint you use must include the DataSync service name (for example, <code>com.amazonaws.us-east-2.datasync</code>).</p> </important>', 'PrivateLinkConfig$VpcEndpointId' => '<p>Specifies the ID of the VPC endpoint that your agent connects to.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskExecutionResponse$EstimatedFilesToTransfer' => '<p>The expected number of files, objects, and directories that DataSync will transfer over the network. This value is calculated during the task execution\'s <code>PREPARING</code> phase before the <code>TRANSFERRING</code> phase. The calculation is based on comparing the content of the source and destination locations and finding the difference that needs to be transferred. </p>', 'DescribeTaskExecutionResponse$EstimatedBytesToTransfer' => '<p>The estimated physical number of bytes that will transfer over the network.</p>', 'DescribeTaskExecutionResponse$FilesTransferred' => '<p>The actual number of files, objects, and directories that DataSync transferred over the network. This value is updated periodically during the task execution\'s <code>TRANSFERRING</code> phase when something is read from the source and sent over the network.</p> <p>If DataSync fails to transfer something, this value can be less than <code>EstimatedFilesToTransfer</code>. In some cases, this value can also be greater than <code>EstimatedFilesToTransfer</code>. This element is implementation-specific for some location types, so don\'t use it as an exact indication of what transferred or to monitor your task execution.</p>', 'DescribeTaskExecutionResponse$BytesWritten' => '<p>The number of logical bytes written to the destination location.</p>', 'DescribeTaskExecutionResponse$BytesTransferred' => '<p>The total number of bytes that are involved in the transfer. For the number of bytes sent over the network, see <code>BytesCompressed</code>. </p>', 'DescribeTaskExecutionResponse$BytesCompressed' => '<p>The physical number of bytes transferred over the network after compression was applied. In most cases, this number is less than <code>BytesTransferred</code> unless the data isn\'t compressible.</p>', 'DescribeTaskExecutionResponse$FilesDeleted' => '<p>The number of files, objects, and directories that DataSync deleted in your destination location. If you don\'t <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a> to delete data in the destination that isn\'t in the source, the value is always <code>0</code>.</p>', 'DescribeTaskExecutionResponse$FilesSkipped' => '<p>The number of files, objects, and directories that DataSync skipped during your transfer.</p>', 'DescribeTaskExecutionResponse$FilesVerified' => '<p>The number of files, objects, and directories that DataSync verified during your transfer.</p> <note> <p>When you configure your task to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html">verify only the data that\'s transferred</a>, DataSync doesn\'t verify directories in some situations or files that fail to transfer.</p> </note>', 'DescribeTaskExecutionResponse$EstimatedFilesToDelete' => '<p>The expected number of files, objects, and directories that DataSync will delete in your destination location. If you don\'t <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html">configure your task</a> to delete data in the destination that isn\'t in the source, the value is always <code>0</code>.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'DescribeTaskResponse$ErrorCode' => '<p>If there\'s an issue with your task, you can use the error code to help you troubleshoot the problem. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html">Troubleshooting issues with DataSync transfers</a>.</p>', 'DescribeTaskResponse$ErrorDetail' => '<p>If there\'s an issue with your task, you can use the error details to help you troubleshoot the problem. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html">Troubleshooting issues with DataSync transfers</a>.</p>', 'InternalException$message' => NULL, 'InternalException$errorCode' => NULL, 'InvalidRequestException$message' => NULL, 'InvalidRequestException$errorCode' => NULL, 'InvalidRequestException$datasyncErrorCode' => NULL, 'ReportResult$ErrorCode' => '<p>Indicates the code associated with the error if DataSync can\'t create a complete report.</p>', 'ReportResult$ErrorDetail' => '<p>Provides details about issues creating a report.</p>', 'TaskExecutionResultDetail$ErrorCode' => '<p>Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.</p>', 'TaskExecutionResultDetail$ErrorDetail' => '<p>Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues. </p>', ], ], ],];
