<?php
// This file was auto-generated from sdk-root/src/data/docdb-elastic/2022-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Amazon DocumentDB elastic clusters</fullname> <p>Amazon DocumentDB elastic-clusters support workloads with millions of reads/writes per second and petabytes of storage capacity. Amazon DocumentDB elastic clusters also simplify how developers interact with Amazon DocumentDB elastic-clusters by eliminating the need to choose, manage or upgrade instances.</p> <p>Amazon DocumentDB elastic-clusters were created to:</p> <ul> <li> <p>provide a solution for customers looking for a database that provides virtually limitless scale with rich query capabilities and MongoDB API compatibility.</p> </li> <li> <p>give customers higher connection limits, and to reduce downtime from patching.</p> </li> <li> <p>continue investing in a cloud-native, elastic, and class leading architecture for JSON workloads.</p> </li> </ul></p>', 'operations' => [ 'CopyClusterSnapshot' => '<p>Copies a snapshot of an elastic cluster.</p>', 'CreateCluster' => '<p>Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.</p>', 'CreateClusterSnapshot' => '<p>Creates a snapshot of an elastic cluster.</p>', 'DeleteCluster' => '<p>Delete an elastic cluster.</p>', 'DeleteClusterSnapshot' => '<p>Delete an elastic cluster snapshot.</p>', 'GetCluster' => '<p>Returns information about a specific elastic cluster.</p>', 'GetClusterSnapshot' => '<p>Returns information about a specific elastic cluster snapshot</p>', 'ListClusterSnapshots' => '<p>Returns information about snapshots for a specified elastic cluster.</p>', 'ListClusters' => '<p>Returns information about provisioned Amazon DocumentDB elastic clusters.</p>', 'ListTagsForResource' => '<p>Lists all tags on a elastic cluster resource</p>', 'RestoreClusterFromSnapshot' => '<p>Restores an elastic cluster from a snapshot.</p>', 'StartCluster' => '<p>Restarts the stopped elastic cluster that is specified by <code>clusterARN</code>.</p>', 'StopCluster' => '<p>Stops the running elastic cluster that is specified by <code>clusterArn</code>. The elastic cluster must be in the <i>available</i> state. </p>', 'TagResource' => '<p>Adds metadata tags to an elastic cluster resource</p>', 'UntagResource' => '<p>Removes metadata tags from an elastic cluster resource</p>', 'UpdateCluster' => '<p>Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and setting up a backup window and maintenance window</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>An exception that occurs when there are not sufficient permissions to perform an action.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN identifier of the elastic cluster resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN identifier of the elastic cluster resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN identifier of the elastic cluster resource.</p>', ], ], 'Auth' => [ 'base' => NULL, 'refs' => [ 'Cluster$authType' => '<p>The authentication type for the elastic cluster.</p>', 'CreateClusterInput$authType' => '<p>The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.</p>', 'UpdateClusterInput$authType' => '<p>The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CopyClusterSnapshotInput$copyTags' => '<p>Set to <code>true</code> to copy all tags from the source cluster snapshot to the target elastic cluster snapshot. The default is <code>false</code>.</p>', ], ], 'Cluster' => [ 'base' => '<p>Returns information about a specific elastic cluster.</p>', 'refs' => [ 'CreateClusterOutput$cluster' => '<p>The new elastic cluster that has been created.</p>', 'DeleteClusterOutput$cluster' => '<p>Returns information about the newly deleted elastic cluster.</p>', 'GetClusterOutput$cluster' => '<p>Returns information about a specific elastic cluster.</p>', 'RestoreClusterFromSnapshotOutput$cluster' => '<p>Returns information about a the restored elastic cluster.</p>', 'StartClusterOutput$cluster' => NULL, 'StopClusterOutput$cluster' => NULL, 'UpdateClusterOutput$cluster' => '<p>Returns information about the updated elastic cluster.</p>', ], ], 'ClusterInList' => [ 'base' => '<p>A list of Amazon DocumentDB elastic clusters.</p>', 'refs' => [ 'ClusterList$member' => NULL, ], ], 'ClusterList' => [ 'base' => NULL, 'refs' => [ 'ListClustersOutput$clusters' => '<p>A list of Amazon DocumentDB elastic clusters.</p>', ], ], 'ClusterSnapshot' => [ 'base' => '<p>Returns information about a specific elastic cluster snapshot.</p>', 'refs' => [ 'CopyClusterSnapshotOutput$snapshot' => NULL, 'CreateClusterSnapshotOutput$snapshot' => '<p>Returns information about the new elastic cluster snapshot.</p>', 'DeleteClusterSnapshotOutput$snapshot' => '<p>Returns information about the newly deleted elastic cluster snapshot.</p>', 'GetClusterSnapshotOutput$snapshot' => '<p>Returns information about a specific elastic cluster snapshot.</p>', ], ], 'ClusterSnapshotInList' => [ 'base' => '<p>A list of elastic cluster snapshots.</p>', 'refs' => [ 'ClusterSnapshotList$member' => NULL, ], ], 'ClusterSnapshotList' => [ 'base' => NULL, 'refs' => [ 'ListClusterSnapshotsOutput$snapshots' => '<p>A list of snapshots for a specified elastic cluster.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was an access conflict.</p>', 'refs' => [], ], 'CopyClusterSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'CopyClusterSnapshotInputTargetSnapshotNameString' => [ 'base' => NULL, 'refs' => [ 'CopyClusterSnapshotInput$targetSnapshotName' => '<p>The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>elastic-cluster-snapshot-5</code> </p>', ], ], 'CopyClusterSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterSnapshotInputSnapshotNameString' => [ 'base' => NULL, 'refs' => [ 'CreateClusterSnapshotInput$snapshotName' => '<p>The name of the new elastic cluster snapshot.</p>', ], ], 'CreateClusterSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'GetClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetClusterSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'GetClusterSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Cluster$backupRetentionPeriod' => '<p>The number of days for which automatic snapshots are retained.</p>', 'Cluster$shardCapacity' => '<p>The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.</p>', 'Cluster$shardCount' => '<p>The number of shards assigned to the elastic cluster. Maximum is 32.</p>', 'Cluster$shardInstanceCount' => '<p>The number of replica instances applying to all shards in the cluster. A <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.</p>', 'CreateClusterInput$backupRetentionPeriod' => '<p>The number of days for which automatic snapshots are retained.</p>', 'CreateClusterInput$shardCapacity' => '<p>The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.</p>', 'CreateClusterInput$shardCount' => '<p>The number of shards assigned to the elastic cluster. Maximum is 32.</p>', 'CreateClusterInput$shardInstanceCount' => '<p>The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.</p>', 'RestoreClusterFromSnapshotInput$shardCapacity' => '<p>The capacity of each shard in the new restored elastic cluster.</p>', 'RestoreClusterFromSnapshotInput$shardInstanceCount' => '<p>The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the operation.</p>', 'UpdateClusterInput$backupRetentionPeriod' => '<p>The number of days for which automatic snapshots are retained.</p>', 'UpdateClusterInput$shardCapacity' => '<p>The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.</p>', 'UpdateClusterInput$shardCount' => '<p>The number of shards assigned to the elastic cluster. Maximum is 32.</p>', 'UpdateClusterInput$shardInstanceCount' => '<p>The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>There was an internal server error.</p>', 'refs' => [], ], 'ListClusterSnapshotsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListClusterSnapshotsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListClusterSnapshotsInput$maxResults' => '<p>The maximum number of elastic cluster snapshot results to receive in the response.</p>', ], ], 'ListClusterSnapshotsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListClustersInput$maxResults' => '<p>The maximum number of elastic cluster snapshot results to receive in the response.</p>', ], ], 'ListClustersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'PaginationToken' => [ 'base' => '<p>Token or cursor used in paginated operations.</p> <p>When this value is provided as operation input, the service returns results from where the previous response left off. When this value is present in operation output, it indicates that there are more results to retrieve.</p> <p>This should be opaque to not expose implementation details and potentially versioned to allow evolution of pagination strategy.</p>', 'refs' => [ 'ListClusterSnapshotsInput$nextToken' => '<p>A pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond this token, up to the value specified by <code>max-results</code>.</p> <p>If there is no more data in the responce, the <code>nextToken</code> will not be returned.</p>', 'ListClusterSnapshotsOutput$nextToken' => '<p>A pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond this token, up to the value specified by <code>max-results</code>.</p> <p>If there is no more data in the responce, the <code>nextToken</code> will not be returned.</p>', 'ListClustersInput$nextToken' => '<p>A pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond this token, up to the value specified by <code>max-results</code>.</p> <p>If there is no more data in the responce, the <code>nextToken</code> will not be returned.</p>', 'ListClustersOutput$nextToken' => '<p>A pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond this token, up to the value specified by <code>max-results</code>.</p> <p>If there is no more data in the responce, the <code>nextToken</code> will not be returned.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateClusterInput$adminUserPassword' => '<p>The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any printable ASCII characters.</p> <p> <i>Constraints</i>:</p> <ul> <li> <p>Must contain from 8 to 100 characters.</p> </li> <li> <p>Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).</p> </li> </ul>', 'UpdateClusterInput$adminUserPassword' => '<p>The password associated with the elastic cluster administrator. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).</p> <p> <i>Constraints</i>: Must contain from 8 to 100 characters.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be located.</p>', 'refs' => [], ], 'RestoreClusterFromSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreClusterFromSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota for the action was exceeded.</p>', 'refs' => [], ], 'Shard' => [ 'base' => '<p>The name of the shard.</p>', 'refs' => [ 'ShardList$member' => NULL, ], ], 'ShardList' => [ 'base' => NULL, 'refs' => [ 'Cluster$shards' => '<p>The total number of shards in the cluster.</p>', ], ], 'SnapshotType' => [ 'base' => NULL, 'refs' => [ 'ClusterSnapshot$snapshotType' => '<p>The type of cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services account.</p> </li> </ul>', ], ], 'StartClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'StartClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'Cluster$status' => '<p>The status of the elastic cluster.</p>', 'ClusterInList$status' => '<p>The status of the elastic cluster.</p>', 'ClusterSnapshot$status' => '<p>The status of the elastic cluster snapshot.</p>', 'ClusterSnapshotInList$status' => '<p>The status of the elastic cluster snapshot.</p>', 'Shard$status' => '<p>The current status of the shard.</p>', ], ], 'StopClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'StopClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => '<p>An error message explaining why access was denied.</p>', 'Cluster$adminUserName' => '<p>The name of the elastic cluster administrator.</p>', 'Cluster$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'Cluster$clusterEndpoint' => '<p>The URL used to connect to the elastic cluster.</p>', 'Cluster$clusterName' => '<p>The name of the elastic cluster.</p>', 'Cluster$createTime' => '<p>The time when the elastic cluster was created in Universal Coordinated Time (UTC).</p>', 'Cluster$kmsKeyId' => '<p>The KMS key identifier to use to encrypt the elastic cluster.</p>', 'Cluster$preferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by <code>backupRetentionPeriod</code>.</p>', 'Cluster$preferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>', 'ClusterInList$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'ClusterInList$clusterName' => '<p>The name of the elastic cluster.</p>', 'ClusterSnapshot$adminUserName' => '<p>The name of the elastic cluster administrator.</p>', 'ClusterSnapshot$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'ClusterSnapshot$clusterCreationTime' => '<p>The time when the elastic cluster was created in Universal Coordinated Time (UTC).</p>', 'ClusterSnapshot$kmsKeyId' => '<p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region. </p>', 'ClusterSnapshot$snapshotArn' => '<p>The ARN identifier of the elastic cluster snapshot.</p>', 'ClusterSnapshot$snapshotCreationTime' => '<p>The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).</p>', 'ClusterSnapshot$snapshotName' => '<p>The name of the elastic cluster snapshot.</p>', 'ClusterSnapshotInList$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'ClusterSnapshotInList$snapshotArn' => '<p>The ARN identifier of the elastic cluster snapshot.</p>', 'ClusterSnapshotInList$snapshotCreationTime' => '<p>The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).</p>', 'ClusterSnapshotInList$snapshotName' => '<p>The name of the elastic cluster snapshot.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource where there was an access conflict.</p>', 'ConflictException$resourceType' => '<p>The type of the resource where there was an access conflict.</p>', 'CopyClusterSnapshotInput$kmsKeyId' => '<p>The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS key ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web Services KMS key alias for the Amazon Web Services KMS encryption key.</p> <p>If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web ServicesS KMS encryption key. If you don\'t specify a value for <code>KmsKeyId</code>, then the copy of the elastic cluster snapshot is encrypted with the same <code>AWS</code> KMS key as the source elastic cluster snapshot.</p> <p>To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set <code>KmsKeyId</code> to the Amazon Web Services KMS key ID that you want to use to encrypt the copy of the elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are specific to the Amazon Web Services region that they are created in, and you can\'t use encryption keys from one Amazon Web Services region in another Amazon Web Services region.</p> <p>If you copy an unencrypted elastic cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>', 'CopyClusterSnapshotInput$snapshotArn' => '<p>The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.</p>', 'CreateClusterInput$adminUserName' => '<p>The name of the Amazon DocumentDB elastic clusters administrator.</p> <p> <i>Constraints</i>:</p> <ul> <li> <p>Must be from 1 to 63 letters or numbers.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot be a reserved word.</p> </li> </ul>', 'CreateClusterInput$clientToken' => '<p>The client token for the elastic cluster.</p>', 'CreateClusterInput$clusterName' => '<p>The name of the new elastic cluster. This parameter is stored as a lowercase string.</p> <p> <i>Constraints</i>:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p> <i>Example</i>: <code>my-cluster</code> </p>', 'CreateClusterInput$kmsKeyId' => '<p>The KMS key identifier to use to encrypt the new elastic cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.</p> <p>If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.</p>', 'CreateClusterInput$preferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>backupRetentionPeriod</code>.</p>', 'CreateClusterInput$preferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p> <p> <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p> <i>Constraints</i>: Minimum 30-minute window.</p>', 'CreateClusterSnapshotInput$clusterArn' => '<p>The ARN identifier of the elastic cluster of which you want to create a snapshot.</p>', 'DeleteClusterInput$clusterArn' => '<p>The ARN identifier of the elastic cluster that is to be deleted.</p>', 'DeleteClusterSnapshotInput$snapshotArn' => '<p>The ARN identifier of the elastic cluster snapshot that is to be deleted.</p>', 'GetClusterInput$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'GetClusterSnapshotInput$snapshotArn' => '<p>The ARN identifier of the elastic cluster snapshot.</p>', 'InternalServerException$message' => NULL, 'ListClusterSnapshotsInput$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'ListClusterSnapshotsInput$snapshotType' => '<p>The type of cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services account.</p> </li> </ul>', 'ResourceNotFoundException$message' => '<p>An error message describing the failure.</p>', 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource that could not be located.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that could not be found.</p>', 'RestoreClusterFromSnapshotInput$clusterName' => '<p>The name of the elastic cluster.</p>', 'RestoreClusterFromSnapshotInput$kmsKeyId' => '<p>The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.</p> <p>If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.</p>', 'RestoreClusterFromSnapshotInput$snapshotArn' => '<p>The ARN identifier of the elastic cluster snapshot.</p>', 'ServiceQuotaExceededException$message' => NULL, 'Shard$createTime' => '<p>The time when the shard was created in Universal Coordinated Time (UTC).</p>', 'Shard$shardId' => '<p>The ID of the shard.</p>', 'StartClusterInput$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'StopClusterInput$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'StringList$member' => NULL, 'ThrottlingException$message' => NULL, 'UpdateClusterInput$clientToken' => '<p>The client token for the elastic cluster.</p>', 'UpdateClusterInput$clusterArn' => '<p>The ARN identifier of the elastic cluster.</p>', 'UpdateClusterInput$preferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>backupRetentionPeriod</code>.</p>', 'UpdateClusterInput$preferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p> <p> <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p> <i>Constraints</i>: Minimum 30-minute window.</p>', 'ValidationException$message' => '<p>An error message describing the validation exception.</p>', 'ValidationExceptionField$message' => '<p>An error message describing the validation exception in this field.</p>', 'ValidationExceptionField$name' => '<p>The name of the field where the validation exception occurred.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Cluster$subnetIds' => '<p>The Amazon EC2 subnet IDs for the elastic cluster.</p>', 'Cluster$vpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups associated with thie elastic cluster.</p>', 'ClusterSnapshot$subnetIds' => '<p>The Amazon EC2 subnet IDs for the elastic cluster.</p>', 'ClusterSnapshot$vpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with the elastic cluster.</p>', 'CreateClusterInput$subnetIds' => '<p>The Amazon EC2 subnet IDs for the new elastic cluster.</p>', 'CreateClusterInput$vpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with the new elastic cluster.</p>', 'RestoreClusterFromSnapshotInput$subnetIds' => '<p>The Amazon EC2 subnet IDs for the elastic cluster.</p>', 'RestoreClusterFromSnapshotInput$vpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with the elastic cluster.</p>', 'UpdateClusterInput$subnetIds' => '<p>The Amazon EC2 subnet IDs for the elastic cluster.</p>', 'UpdateClusterInput$vpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with the elastic cluster.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to be removed from the elastic cluster resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CopyClusterSnapshotInput$tags' => '<p>The tags to be assigned to the elastic cluster snapshot.</p>', 'CreateClusterInput$tags' => '<p>The tags to be assigned to the new elastic cluster.</p>', 'CreateClusterSnapshotInput$tags' => '<p>The tags to be assigned to the new elastic cluster snapshot.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tags for the specified elastic cluster resource.</p>', 'RestoreClusterFromSnapshotInput$tags' => '<p>A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of key-value pairs in which the key is the tag name and the value is the key value.</p>', 'TagResourceRequest$tags' => '<p>The tags that are assigned to the elastic cluster resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>ThrottlingException will be thrown when request was denied due to request throttling.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>A structure defining a validation exception.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>A specific field in which a given validation exception occurred.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of the fields in which the validation exception occurred.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason why the validation exception occurred (one of <code>unknownOperation</code>, <code>cannotParse</code>, <code>fieldValidationFailed</code>, or <code>other</code>).</p>', ], ], ],];
