<?php
// This file was auto-generated from sdk-root/src/data/docdb/2014-10-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon DocumentDB is a fast, reliable, and fully managed database service. Amazon DocumentDB makes it easy to set up, operate, and scale MongoDB-compatible databases in the cloud. With Amazon DocumentDB, you can run the same application code and use the same drivers and tools that you use with MongoDB.</p>', 'operations' => [ 'AddSourceIdentifierToSubscription' => '<p>Adds a source identifier to an existing event notification subscription.</p>', 'AddTagsToResource' => '<p>Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a <code>Condition</code> statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.</p>', 'ApplyPendingMaintenanceAction' => '<p>Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).</p>', 'CopyDBClusterParameterGroup' => '<p>Copies the specified cluster parameter group.</p>', 'CopyDBClusterSnapshot' => '<p>Copies a snapshot of a cluster.</p> <p>To copy a cluster snapshot from a shared manual cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You can only copy a shared DB cluster snapshot, whether encrypted or not, in the same Amazon Web Services Region.</p> <p>To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by <code>TargetDBClusterSnapshotIdentifier</code> while that cluster snapshot is in the <i>copying</i> status.</p>', 'CreateDBCluster' => '<p>Creates a new Amazon DocumentDB cluster.</p>', 'CreateDBClusterParameterGroup' => '<p>Creates a new cluster parameter group.</p> <p>Parameters in a cluster parameter group apply to all of the instances in a cluster.</p> <p>A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the <code>default.docdb3.6</code> cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html"> create a new parameter group</a> or <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html"> copy an existing parameter group</a>, modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html"> Modifying Amazon DocumentDB Cluster Parameter Groups</a>. </p>', 'CreateDBClusterSnapshot' => '<p>Creates a snapshot of a cluster. </p>', 'CreateDBInstance' => '<p>Creates a new instance.</p>', 'CreateDBSubnetGroup' => '<p>Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.</p>', 'CreateEventSubscription' => '<p>Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.</p> <p>You can specify the type of source (<code>SourceType</code>) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (<code>SourceIds</code>) that trigger the events, and you can provide a list of event categories (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify <code>SourceType = db-instance</code>, <code>SourceIds = mydbinstance1, mydbinstance2</code> and <code>EventCategories = Availability, Backup</code>.</p> <p>If you specify both the <code>SourceType</code> and <code>SourceIds</code> (such as <code>SourceType = db-instance</code> and <code>SourceIdentifier = myDBInstance1</code>), you are notified of all the <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not specify a <code>SourceIdentifier</code>, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the <code>SourceType</code> or the <code>SourceIdentifier</code>, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.</p>', 'CreateGlobalCluster' => '<p>Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.</p> <p/> <p>You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster. </p> <note> <p>This action only applies to Amazon DocumentDB clusters.</p> </note>', 'DeleteDBCluster' => '<p>Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can\'t be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.</p> <p/>', 'DeleteDBClusterParameterGroup' => '<p>Deletes a specified cluster parameter group. The cluster parameter group to be deleted can\'t be associated with any clusters.</p>', 'DeleteDBClusterSnapshot' => '<p>Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p> <note> <p>The cluster snapshot must be in the <code>available</code> state to be deleted.</p> </note>', 'DeleteDBInstance' => '<p>Deletes a previously provisioned instance.</p>', 'DeleteDBSubnetGroup' => '<p>Deletes a subnet group.</p> <note> <p>The specified database subnet group must not be associated with any DB instances.</p> </note>', 'DeleteEventSubscription' => '<p>Deletes an Amazon DocumentDB event notification subscription.</p>', 'DeleteGlobalCluster' => '<p>Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.</p> <note> <p>This action only applies to Amazon DocumentDB clusters.</p> </note>', 'DescribeCertificates' => '<p>Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.</p>', 'DescribeDBClusterParameterGroups' => '<p>Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the specified cluster parameter group. </p>', 'DescribeDBClusterParameters' => '<p>Returns the detailed parameter list for a particular cluster parameter group.</p>', 'DescribeDBClusterSnapshotAttributes' => '<p>Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.</p> <p>When you share snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.</p>', 'DescribeDBClusterSnapshots' => '<p>Returns information about cluster snapshots. This API operation supports pagination.</p>', 'DescribeDBClusters' => '<p>Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.</p>', 'DescribeDBEngineVersions' => '<p>Returns a list of the available engines.</p>', 'DescribeDBInstances' => '<p>Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.</p>', 'DescribeDBSubnetGroups' => '<p>Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.</p>', 'DescribeEngineDefaultClusterParameters' => '<p>Returns the default engine and system parameter information for the cluster database engine.</p>', 'DescribeEventCategories' => '<p>Displays a list of categories for all event source types, or, if specified, for a specified source type. </p>', 'DescribeEventSubscriptions' => '<p>Lists all the subscription descriptions for a customer account. The description for a subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.</p> <p>If you specify a <code>SubscriptionName</code>, lists the description for that subscription.</p>', 'DescribeEvents' => '<p>Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.</p>', 'DescribeGlobalClusters' => '<p>Returns information about Amazon DocumentDB global clusters. This API supports pagination.</p> <note> <p>This action only applies to Amazon DocumentDB clusters.</p> </note>', 'DescribeOrderableDBInstanceOptions' => '<p>Returns a list of orderable instance options for the specified engine.</p>', 'DescribePendingMaintenanceActions' => '<p>Returns a list of resources (for example, instances) that have at least one pending maintenance action.</p>', 'FailoverDBCluster' => '<p>Forces a failover for a cluster.</p> <p>A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).</p> <p>If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.</p>', 'FailoverGlobalCluster' => '<p>Promotes the specified secondary DB cluster to be the primary DB cluster in the global cluster when failing over a global cluster occurs.</p> <p>Use this operation to respond to an unplanned event, such as a regional disaster in the primary region. Failing over can result in a loss of write transaction data that wasn\'t replicated to the chosen secondary before the failover event occurred. However, the recovery process that promotes a DB instance on the chosen seconday DB cluster to be the primary writer DB instance guarantees that the data is in a transactionally consistent state.</p>', 'ListTagsForResource' => '<p>Lists all tags on an Amazon DocumentDB resource.</p>', 'ModifyDBCluster' => '<p>Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. </p>', 'ModifyDBClusterParameterGroup' => '<p> Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request. </p> <note> <p>Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.</p> </note> <important> <p>After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter.</p> </important>', 'ModifyDBClusterSnapshotAttribute' => '<p>Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.</p> <p>To share a manual cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the <code>AttributeName</code>, and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual cluster snapshot. Use the value <code>all</code> to make the manual cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don\'t want available to all Amazon Web Services accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can\'t use <code>all</code> as a value for that parameter in this case.</p>', 'ModifyDBInstance' => '<p>Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.</p>', 'ModifyDBSubnetGroup' => '<p>Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.</p>', 'ModifyEventSubscription' => '<p>Modifies an existing Amazon DocumentDB event notification subscription.</p>', 'ModifyGlobalCluster' => '<p>Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.</p> <note> <p>This action only applies to Amazon DocumentDB clusters.</p> </note>', 'RebootDBInstance' => '<p>You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect. </p> <p>Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to <i>rebooting</i>. </p>', 'RemoveFromGlobalCluster' => '<p>Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region. </p> <note> <p>This action only applies to Amazon DocumentDB clusters.</p> </note>', 'RemoveSourceIdentifierFromSubscription' => '<p>Removes a source identifier from an existing Amazon DocumentDB event notification subscription.</p>', 'RemoveTagsFromResource' => '<p>Removes metadata tags from an Amazon DocumentDB resource.</p>', 'ResetDBClusterParameterGroup' => '<p> Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters. </p> <p> When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance reboot.</p>', 'RestoreDBClusterFromSnapshot' => '<p>Creates a new cluster from a snapshot or cluster snapshot.</p> <p>If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.</p> <p>If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.</p>', 'RestoreDBClusterToPointInTime' => '<p>Restores a cluster to an arbitrary point in time. Users can restore to any point in time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group. </p>', 'StartDBCluster' => '<p>Restarts the stopped cluster that is specified by <code>DBClusterIdentifier</code>. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and Starting an Amazon DocumentDB Cluster</a>.</p>', 'StopDBCluster' => '<p>Stops the running cluster that is specified by <code>DBClusterIdentifier</code>. The cluster must be in the <i>available</i> state. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and Starting an Amazon DocumentDB Cluster</a>.</p>', 'SwitchoverGlobalCluster' => '<p>Switches over the specified secondary Amazon DocumentDB cluster to be the new primary Amazon DocumentDB cluster in the global database cluster.</p>', ], 'shapes' => [ 'AddSourceIdentifierToSubscriptionMessage' => [ 'base' => '<p>Represents the input to <a>AddSourceIdentifierToSubscription</a>. </p>', 'refs' => [], ], 'AddSourceIdentifierToSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceMessage' => [ 'base' => '<p>Represents the input to <a>AddTagsToResource</a>. </p>', 'refs' => [], ], 'ApplyMethod' => [ 'base' => NULL, 'refs' => [ 'Parameter$ApplyMethod' => '<p>Indicates when to apply parameter updates.</p>', ], ], 'ApplyPendingMaintenanceActionMessage' => [ 'base' => '<p>Represents the input to <a>ApplyPendingMaintenanceAction</a>. </p>', 'refs' => [], ], 'ApplyPendingMaintenanceActionResult' => [ 'base' => NULL, 'refs' => [], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttribute$AttributeValues' => '<p>The values for the manual cluster snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If a value of <code>all</code> is in the list, then the manual cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToAdd' => '<p>A list of cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon Web Services accounts to copy or restore a manual cluster snapshot, set this list to include one or more Amazon Web Services account IDs. To make the manual cluster snapshot restorable by any Amazon Web Services account, set it to <code>all</code>. Do not add the <code>all</code> value for any manual cluster snapshots that contain private information that you don\'t want to be available to all Amazon Web Services accounts.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToRemove' => '<p>A list of cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual cluster snapshot, set this list to include one or more Amazon Web Services account identifiers. To remove authorization for any Amazon Web Services account to copy or restore the cluster snapshot, set it to <code>all</code> . If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual cluster snapshot.</p>', ], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>The specified CIDR IP or Amazon EC2 security group isn\'t authorized for the specified security group.</p> <p>Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.</p>', 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p>Information about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'Subnet$SubnetAvailabilityZone' => '<p>Specifies the Availability Zone for the subnet.</p>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$AvailabilityZones' => '<p>A list of Availability Zones for an instance.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$AvailabilityZones' => '<p>A list of Amazon EC2 Availability Zones that instances in the cluster can be created in.</p>', 'DBCluster$AvailabilityZones' => '<p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster can be created in.</p>', 'DBClusterSnapshot$AvailabilityZones' => '<p>Provides the list of Amazon EC2 Availability Zones that instances in the cluster snapshot can be restored in.</p>', 'RestoreDBClusterFromSnapshotMessage$AvailabilityZones' => '<p>Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DBCluster$MultiAZ' => '<p>Specifies whether the cluster has instances in multiple Availability Zones.</p>', 'DBCluster$StorageEncrypted' => '<p>Specifies whether the cluster is encrypted.</p>', 'DBCluster$DeletionProtection' => '<p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>', 'DBClusterMember$IsClusterWriter' => '<p>A value that is <code>true</code> if the cluster member is the primary instance for the cluster and <code>false</code> otherwise.</p>', 'DBClusterSnapshot$StorageEncrypted' => '<p>Specifies whether the cluster snapshot is encrypted.</p>', 'DBEngineVersion$SupportsLogExportsToCloudwatchLogs' => '<p>A value that indicates whether the engine version supports exporting the log types specified by <code>ExportableLogTypes</code> to CloudWatch Logs.</p>', 'DBInstance$AutoMinorVersionUpgrade' => '<p>Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>', 'DBInstance$PubliclyAccessible' => '<p>Not supported. Amazon DocumentDB does not currently support public endpoints. The value of <code>PubliclyAccessible</code> is always <code>false</code>.</p>', 'DBInstance$StorageEncrypted' => '<p>Specifies whether or not the instance is encrypted.</p>', 'DBInstanceStatusInfo$Normal' => '<p>A Boolean value that is <code>true</code> if the instance is operating normally, or <code>false</code> if the instance is in an error state.</p>', 'DeleteDBClusterMessage$SkipFinalSnapshot' => '<p> Determines whether a final cluster snapshot is created before the cluster is deleted. If <code>true</code> is specified, no cluster snapshot is created. If <code>false</code> is specified, a cluster snapshot is created before the DB cluster is deleted. </p> <note> <p>If <code>SkipFinalSnapshot</code> is <code>false</code>, you must specify a <code>FinalDBSnapshotIdentifier</code> parameter.</p> </note> <p>Default: <code>false</code> </p>', 'DescribeDBClusterSnapshotsMessage$IncludeShared' => '<p>Set to <code>true</code> to include shared manual cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore, and otherwise <code>false</code>. The default is <code>false</code>.</p>', 'DescribeDBClusterSnapshotsMessage$IncludePublic' => '<p>Set to <code>true</code> to include manual cluster snapshots that are public and can be copied or restored by any Amazon Web Services account, and otherwise <code>false</code>. The default is <code>false</code>.</p>', 'DescribeDBEngineVersionsMessage$DefaultOnly' => '<p>Indicates that only the default version of the specified engine or engine and major version combination is returned.</p>', 'EventSubscription$Enabled' => '<p>A Boolean value indicating whether the subscription is enabled. A value of <code>true</code> indicates that the subscription is enabled.</p>', 'GlobalClusterMember$IsWriter' => '<p> Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated. </p>', 'ModifyDBClusterMessage$ApplyImmediately' => '<p>A value that specifies whether the changes in this request and any pending changes are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster. If this parameter is set to <code>false</code>, changes to the cluster are applied during the next maintenance window.</p> <p>The <code>ApplyImmediately</code> parameter affects only the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values. If you set this parameter value to <code>false</code>, the changes to the <code>NewDBClusterIdentifier</code> and <code>MasterUserPassword</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p>Default: <code>false</code> </p>', 'ModifyDBClusterMessage$AllowMajorVersionUpgrade' => '<p>A value that indicates whether major version upgrades are allowed.</p> <p>Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster\'s current version.</p>', 'ModifyDBInstanceMessage$ApplyImmediately' => '<p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the instance. </p> <p> If this parameter is set to <code>false</code>, changes to the instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.</p> <p>Default: <code>false</code> </p>', 'OrderableDBInstanceOption$Vpc' => '<p>Indicates whether an instance is in a virtual private cloud (VPC).</p>', 'Parameter$IsModifiable' => '<p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>', 'ResetDBClusterParameterGroupMessage$ResetAllParameters' => '<p>A value that is set to <code>true</code> to reset all parameters in the cluster parameter group to their default values, and <code>false</code> otherwise. You can\'t use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>', 'RestoreDBClusterToPointInTimeMessage$UseLatestRestorableTime' => '<p>A value that is set to <code>true</code> to restore the cluster to the latest restorable backup time, and <code>false</code> otherwise. </p> <p>Default: <code>false</code> </p> <p>Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is provided.</p>', 'UpgradeTarget$AutoUpgrade' => '<p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to <code>true</code>.</p>', 'UpgradeTarget$IsMajorVersionUpgrade' => '<p>A value that indicates whether a database engine is upgraded to a major version.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CopyDBClusterSnapshotMessage$CopyTags' => '<p>Set to <code>true</code> to copy all tags from the source cluster snapshot to the target cluster snapshot, and otherwise <code>false</code>. The default is <code>false</code>.</p>', 'CreateDBClusterMessage$StorageEncrypted' => '<p>Specifies whether the cluster is encrypted.</p>', 'CreateDBClusterMessage$DeletionProtection' => '<p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>', 'CreateDBInstanceMessage$AutoMinorVersionUpgrade' => '<p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p> <p>Default: <code>false</code> </p>', 'CreateDBInstanceMessage$CopyTagsToSnapshot' => '<p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>', 'CreateDBInstanceMessage$EnablePerformanceInsights' => '<p>A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon Performance Insights</a>.</p>', 'CreateEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it. </p>', 'CreateGlobalClusterMessage$DeletionProtection' => '<p>The deletion protection setting for the new global cluster. The global cluster can\'t be deleted when deletion protection is enabled. </p>', 'CreateGlobalClusterMessage$StorageEncrypted' => '<p>The storage encryption setting for the new global cluster. </p>', 'DBEngineVersion$SupportsCertificateRotationWithoutRestart' => '<p>Indicates whether the engine version supports rotating the server certificate without rebooting the DB instance.</p>', 'DBInstance$CopyTagsToSnapshot' => '<p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>', 'DBInstance$PerformanceInsightsEnabled' => '<p>Set to <code>true</code> if Amazon RDS Performance Insights is enabled for the DB instance, and otherwise <code>false</code>.</p>', 'DescribeDBEngineVersionsMessage$ListSupportedCharacterSets' => '<p>If this parameter is specified and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version. </p>', 'DescribeDBEngineVersionsMessage$ListSupportedTimezones' => '<p>If this parameter is specified and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version. </p>', 'DescribeOrderableDBInstanceOptionsMessage$Vpc' => '<p>The virtual private cloud (VPC) filter value. Specify this parameter to show only the available VPC or non-VPC offerings.</p>', 'FailoverGlobalClusterMessage$AllowDataLoss' => '<p>Specifies whether to allow data loss for this global cluster operation. Allowing data loss triggers a global failover operation.</p> <p>If you don\'t specify <code>AllowDataLoss</code>, the global cluster operation defaults to a switchover.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified together with the <code>Switchover</code> parameter.</p> </li> </ul>', 'FailoverGlobalClusterMessage$Switchover' => '<p>Specifies whether to switch over this global database cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified together with the <code>AllowDataLoss</code> parameter.</p> </li> </ul>', 'GlobalCluster$StorageEncrypted' => '<p>The storage encryption setting for the global cluster.</p>', 'GlobalCluster$DeletionProtection' => '<p>The deletion protection setting for the new global cluster.</p>', 'ModifyDBClusterMessage$DeletionProtection' => '<p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>', 'ModifyDBInstanceMessage$AutoMinorVersionUpgrade' => '<p>This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.</p>', 'ModifyDBInstanceMessage$CopyTagsToSnapshot' => '<p>A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>', 'ModifyDBInstanceMessage$EnablePerformanceInsights' => '<p>A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon Performance Insights</a>.</p>', 'ModifyDBInstanceMessage$CertificateRotationRestart' => '<p>Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.</p> <p>By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.</p> <important> <p>Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.</p> </important> <p>If you are using SSL/TLS to connect to the DB instance, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html"> Encrypting Data in Transit</a> in the <i>Amazon DocumentDB Developer Guide</i>.</p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <code>true</code> to activate the subscription. </p>', 'ModifyGlobalClusterMessage$DeletionProtection' => '<p>Indicates if the global cluster has deletion protection enabled. The global cluster can\'t be deleted when deletion protection is enabled. </p>', 'PendingModifiedValues$MultiAZ' => '<p>Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.</p>', 'RebootDBInstanceMessage$ForceFailover' => '<p> When <code>true</code>, the reboot is conducted through a Multi-AZ failover. </p> <p>Constraint: You can\'t specify <code>true</code> if the instance is not configured for Multi-AZ.</p>', 'RestoreDBClusterFromSnapshotMessage$DeletionProtection' => '<p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>', 'RestoreDBClusterToPointInTimeMessage$DeletionProtection' => '<p>Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code> protects clusters from being accidentally deleted.</p>', ], ], 'CACertificateIdentifiersList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedCACertificateIdentifiers' => '<p>A list of the supported CA certificate identifiers.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html"> Encrypting Data in Transit</a> in the <i>Amazon DocumentDB Developer Guide</i>.</p>', ], ], 'Certificate' => [ 'base' => '<p>A certificate authority (CA) certificate for an Amazon Web Services account.</p>', 'refs' => [ 'CertificateList$member' => NULL, ], ], 'CertificateDetails' => [ 'base' => '<p>Returns the details of the DB instance’s server certificate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html"> Encrypting Data in Transit</a> in the <i>Amazon DocumentDB Developer Guide</i>.</p>', 'refs' => [ 'DBInstance$CertificateDetails' => '<p>The details of the DB instance\'s server certificate.</p>', ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'CertificateMessage$Certificates' => '<p>A list of certificates for this Amazon Web Services account.</p>', ], ], 'CertificateMessage' => [ 'base' => NULL, 'refs' => [], ], 'CertificateNotFoundFault' => [ 'base' => '<p> <code>CertificateIdentifier</code> doesn\'t refer to an existing certificate. </p>', 'refs' => [], ], 'CloudwatchLogsExportConfiguration' => [ 'base' => '<p>The configuration setting for the log types to be enabled for export to Amazon CloudWatch Logs for a specific instance or cluster.</p> <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs are exported (or not exported) to CloudWatch Logs. The values within these arrays depend on the engine that is being used.</p>', 'refs' => [ 'ModifyDBClusterMessage$CloudwatchLogsExportConfiguration' => '<p>The configuration setting for the log types to be enabled for export to Amazon CloudWatch Logs for a specific instance or cluster. The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs are exported (or not exported) to CloudWatch Logs.</p>', ], ], 'CopyDBClusterParameterGroupMessage' => [ 'base' => '<p>Represents the input to <a>CopyDBClusterParameterGroup</a>. </p>', 'refs' => [], ], 'CopyDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterSnapshotMessage' => [ 'base' => '<p>Represents the input to <a>CopyDBClusterSnapshot</a>. </p>', 'refs' => [], ], 'CopyDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterMessage' => [ 'base' => '<p>Represents the input to <a>CreateDBCluster</a>. </p>', 'refs' => [], ], 'CreateDBClusterParameterGroupMessage' => [ 'base' => '<p>Represents the input of <a>CreateDBClusterParameterGroup</a>.</p>', 'refs' => [], ], 'CreateDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterSnapshotMessage' => [ 'base' => '<p>Represents the input of <a>CreateDBClusterSnapshot</a>.</p>', 'refs' => [], ], 'CreateDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceMessage' => [ 'base' => '<p>Represents the input to <a>CreateDBInstance</a>.</p>', 'refs' => [], ], 'CreateDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSubnetGroupMessage' => [ 'base' => '<p>Represents the input to <a>CreateDBSubnetGroup</a>.</p>', 'refs' => [], ], 'CreateDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => '<p>Represents the input to <a>CreateEventSubscription</a>.</p>', 'refs' => [], ], 'CreateEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalClusterMessage' => [ 'base' => '<p>Represents the input to <a>CreateGlobalCluster</a>.</p>', 'refs' => [], ], 'CreateGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DBCluster' => [ 'base' => '<p>Detailed information about a cluster. </p>', 'refs' => [ 'CreateDBClusterResult$DBCluster' => NULL, 'DBClusterList$member' => NULL, 'DeleteDBClusterResult$DBCluster' => NULL, 'FailoverDBClusterResult$DBCluster' => NULL, 'ModifyDBClusterResult$DBCluster' => NULL, 'RestoreDBClusterFromSnapshotResult$DBCluster' => NULL, 'RestoreDBClusterToPointInTimeResult$DBCluster' => NULL, 'StartDBClusterResult$DBCluster' => NULL, 'StopDBClusterResult$DBCluster' => NULL, ], ], 'DBClusterAlreadyExistsFault' => [ 'base' => '<p>You already have a cluster with the given identifier.</p>', 'refs' => [], ], 'DBClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'FailoverGlobalClusterMessage$TargetDbClusterIdentifier' => '<p>The identifier of the secondary Amazon DocumentDB cluster that you want to promote to the primary for the global cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can locate the cluster in its Amazon Web Services region.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing secondary cluster.</p> </li> <li> <p>Minimum length of 1. Maximum length of 255.</p> </li> </ul> <p>Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code> </p>', 'SwitchoverGlobalClusterMessage$TargetDbClusterIdentifier' => '<p>The identifier of the secondary Amazon DocumentDB cluster to promote to the new primary for the global database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Amazon DocumentDB can locate the cluster in its Amazon Web Services region.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing secondary cluster.</p> </li> <li> <p>Minimum length of 1. Maximum length of 255.</p> </li> </ul> <p>Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code> </p>', ], ], 'DBClusterList' => [ 'base' => NULL, 'refs' => [ 'DBClusterMessage$DBClusters' => '<p>A list of clusters.</p>', ], ], 'DBClusterMember' => [ 'base' => '<p>Contains information about an instance that is part of a cluster.</p>', 'refs' => [ 'DBClusterMemberList$member' => NULL, ], ], 'DBClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterMembers' => '<p>Provides the list of instances that make up the cluster.</p>', ], ], 'DBClusterMessage' => [ 'base' => '<p>Represents the output of <a>DescribeDBClusters</a>.</p>', 'refs' => [], ], 'DBClusterNotFoundFault' => [ 'base' => '<p> <code>DBClusterIdentifier</code> doesn\'t refer to an existing cluster. </p>', 'refs' => [], ], 'DBClusterParameterGroup' => [ 'base' => '<p>Detailed information about a cluster parameter group. </p>', 'refs' => [ 'CopyDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'CreateDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'DBClusterParameterGroupList$member' => NULL, ], ], 'DBClusterParameterGroupDetails' => [ 'base' => '<p>Represents the output of <a>DBClusterParameterGroup</a>.</p>', 'refs' => [], ], 'DBClusterParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupsMessage$DBClusterParameterGroups' => '<p>A list of cluster parameter groups.</p>', ], ], 'DBClusterParameterGroupNameMessage' => [ 'base' => '<p>Contains the name of a cluster parameter group.</p>', 'refs' => [], ], 'DBClusterParameterGroupNotFoundFault' => [ 'base' => '<p> <code>DBClusterParameterGroupName</code> doesn\'t refer to an existing cluster parameter group. </p>', 'refs' => [], ], 'DBClusterParameterGroupsMessage' => [ 'base' => '<p>Represents the output of <a>DBClusterParameterGroups</a>.</p>', 'refs' => [], ], 'DBClusterQuotaExceededFault' => [ 'base' => '<p>The cluster can\'t be created because you have reached the maximum allowed quota of clusters.</p>', 'refs' => [], ], 'DBClusterRole' => [ 'base' => '<p>Describes an Identity and Access Management (IAM) role that is associated with a cluster.</p>', 'refs' => [ 'DBClusterRoles$member' => NULL, ], ], 'DBClusterRoles' => [ 'base' => NULL, 'refs' => [ 'DBCluster$AssociatedRoles' => '<p>Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.</p>', ], ], 'DBClusterSnapshot' => [ 'base' => '<p>Detailed information about a cluster snapshot. </p>', 'refs' => [ 'CopyDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'CreateDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'DBClusterSnapshotList$member' => NULL, 'DeleteDBClusterSnapshotResult$DBClusterSnapshot' => NULL, ], ], 'DBClusterSnapshotAlreadyExistsFault' => [ 'base' => '<p>You already have a cluster snapshot with the given identifier.</p>', 'refs' => [], ], 'DBClusterSnapshotAttribute' => [ 'base' => '<p>Contains the name and values of a manual cluster snapshot attribute.</p> <p>Manual cluster snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual cluster snapshot.</p>', 'refs' => [ 'DBClusterSnapshotAttributeList$member' => NULL, ], ], 'DBClusterSnapshotAttributeList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttributesResult$DBClusterSnapshotAttributes' => '<p>The list of attributes and values for the cluster snapshot.</p>', ], ], 'DBClusterSnapshotAttributesResult' => [ 'base' => '<p>Detailed information about the attributes that are associated with a cluster snapshot.</p>', 'refs' => [ 'DescribeDBClusterSnapshotAttributesResult$DBClusterSnapshotAttributesResult' => NULL, 'ModifyDBClusterSnapshotAttributeResult$DBClusterSnapshotAttributesResult' => NULL, ], ], 'DBClusterSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotMessage$DBClusterSnapshots' => '<p>Provides a list of cluster snapshots.</p>', ], ], 'DBClusterSnapshotMessage' => [ 'base' => '<p>Represents the output of <a>DescribeDBClusterSnapshots</a>.</p>', 'refs' => [], ], 'DBClusterSnapshotNotFoundFault' => [ 'base' => '<p> <code>DBClusterSnapshotIdentifier</code> doesn\'t refer to an existing cluster snapshot. </p>', 'refs' => [], ], 'DBEngineVersion' => [ 'base' => '<p> Detailed information about an engine version. </p>', 'refs' => [ 'DBEngineVersionList$member' => NULL, ], ], 'DBEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersionMessage$DBEngineVersions' => '<p>Detailed information about one or more engine versions.</p>', ], ], 'DBEngineVersionMessage' => [ 'base' => '<p>Represents the output of <a>DescribeDBEngineVersions</a>.</p>', 'refs' => [], ], 'DBInstance' => [ 'base' => '<p>Detailed information about an instance. </p>', 'refs' => [ 'CreateDBInstanceResult$DBInstance' => NULL, 'DBInstanceList$member' => NULL, 'DeleteDBInstanceResult$DBInstance' => NULL, 'ModifyDBInstanceResult$DBInstance' => NULL, 'RebootDBInstanceResult$DBInstance' => NULL, ], ], 'DBInstanceAlreadyExistsFault' => [ 'base' => '<p>You already have a instance with the given identifier.</p>', 'refs' => [], ], 'DBInstanceList' => [ 'base' => NULL, 'refs' => [ 'DBInstanceMessage$DBInstances' => '<p>Detailed information about one or more instances. </p>', ], ], 'DBInstanceMessage' => [ 'base' => '<p>Represents the output of <a>DescribeDBInstances</a>.</p>', 'refs' => [], ], 'DBInstanceNotFoundFault' => [ 'base' => '<p> <code>DBInstanceIdentifier</code> doesn\'t refer to an existing instance. </p>', 'refs' => [], ], 'DBInstanceStatusInfo' => [ 'base' => '<p>Provides a list of status information for an instance.</p>', 'refs' => [ 'DBInstanceStatusInfoList$member' => NULL, ], ], 'DBInstanceStatusInfoList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$StatusInfos' => '<p>The status of a read replica. If the instance is not a read replica, this is blank.</p>', ], ], 'DBParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A parameter group with the same name already exists.</p>', 'refs' => [], ], 'DBParameterGroupNotFoundFault' => [ 'base' => '<p> <code>DBParameterGroupName</code> doesn\'t refer to an existing parameter group. </p>', 'refs' => [], ], 'DBParameterGroupQuotaExceededFault' => [ 'base' => '<p>This request would cause you to exceed the allowed number of parameter groups.</p>', 'refs' => [], ], 'DBSecurityGroupNotFoundFault' => [ 'base' => '<p> <code>DBSecurityGroupName</code> doesn\'t refer to an existing security group. </p>', 'refs' => [], ], 'DBSnapshotAlreadyExistsFault' => [ 'base' => '<p> <code>DBSnapshotIdentifier</code> is already being used by an existing snapshot. </p>', 'refs' => [], ], 'DBSnapshotNotFoundFault' => [ 'base' => '<p> <code>DBSnapshotIdentifier</code> doesn\'t refer to an existing snapshot. </p>', 'refs' => [], ], 'DBSubnetGroup' => [ 'base' => '<p>Detailed information about a subnet group. </p>', 'refs' => [ 'CreateDBSubnetGroupResult$DBSubnetGroup' => NULL, 'DBInstance$DBSubnetGroup' => '<p>Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.</p>', 'DBSubnetGroups$member' => NULL, 'ModifyDBSubnetGroupResult$DBSubnetGroup' => NULL, ], ], 'DBSubnetGroupAlreadyExistsFault' => [ 'base' => '<p> <code>DBSubnetGroupName</code> is already being used by an existing subnet group. </p>', 'refs' => [], ], 'DBSubnetGroupDoesNotCoverEnoughAZs' => [ 'base' => '<p>Subnets in the subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>', 'refs' => [], ], 'DBSubnetGroupMessage' => [ 'base' => '<p>Represents the output of <a>DescribeDBSubnetGroups</a>.</p>', 'refs' => [], ], 'DBSubnetGroupNotFoundFault' => [ 'base' => '<p> <code>DBSubnetGroupName</code> doesn\'t refer to an existing subnet group. </p>', 'refs' => [], ], 'DBSubnetGroupQuotaExceededFault' => [ 'base' => '<p>The request would cause you to exceed the allowed number of subnet groups.</p>', 'refs' => [], ], 'DBSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroupMessage$DBSubnetGroups' => '<p>Detailed information about one or more subnet groups.</p>', ], ], 'DBSubnetQuotaExceededFault' => [ 'base' => '<p>The request would cause you to exceed the allowed number of subnets in a subnet group.</p>', 'refs' => [], ], 'DBUpgradeDependencyFailureFault' => [ 'base' => '<p>The upgrade failed because a resource that the depends on can\'t be modified.</p>', 'refs' => [], ], 'DeleteDBClusterMessage' => [ 'base' => '<p>Represents the input to <a>DeleteDBCluster</a>.</p>', 'refs' => [], ], 'DeleteDBClusterParameterGroupMessage' => [ 'base' => '<p>Represents the input to <a>DeleteDBClusterParameterGroup</a>.</p>', 'refs' => [], ], 'DeleteDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterSnapshotMessage' => [ 'base' => '<p>Represents the input to <a>DeleteDBClusterSnapshot</a>.</p>', 'refs' => [], ], 'DeleteDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceMessage' => [ 'base' => '<p>Represents the input to <a>DeleteDBInstance</a>.</p>', 'refs' => [], ], 'DeleteDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSubnetGroupMessage' => [ 'base' => '<p>Represents the input to <a>DeleteDBSubnetGroup</a>.</p>', 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => '<p>Represents the input to <a>DeleteEventSubscription</a>.</p>', 'refs' => [], ], 'DeleteEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalClusterMessage' => [ 'base' => '<p>Represents the input to <a>DeleteGlobalCluster</a>.</p>', 'refs' => [], ], 'DeleteGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificatesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterParameterGroupsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBClusterParameterGroups</a>.</p>', 'refs' => [], ], 'DescribeDBClusterParametersMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBClusterParameters</a>.</p>', 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBClusterSnapshotAttributes</a>.</p>', 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterSnapshotsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBClusterSnapshots</a>.</p>', 'refs' => [], ], 'DescribeDBClustersMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBClusters</a>.</p>', 'refs' => [], ], 'DescribeDBEngineVersionsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBEngineVersions</a>.</p>', 'refs' => [], ], 'DescribeDBInstancesMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBInstances</a>.</p>', 'refs' => [], ], 'DescribeDBSubnetGroupsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeDBSubnetGroups</a>.</p>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersMessage' => [ 'base' => '<p>Represents the input to <a>DescribeEngineDefaultClusterParameters</a>.</p>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => '<p>Represents the input to <a>DescribeEventCategories</a>.</p>', 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeEventSubscriptions</a>.</p>', 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeEvents</a>.</p>', 'refs' => [], ], 'DescribeGlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrderableDBInstanceOptionsMessage' => [ 'base' => '<p>Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.</p>', 'refs' => [], ], 'DescribePendingMaintenanceActionsMessage' => [ 'base' => '<p>Represents the input to <a>DescribePendingMaintenanceActions</a>.</p>', 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>Network information for accessing a cluster or instance. Client programs must specify a valid endpoint to access these Amazon DocumentDB resources.</p>', 'refs' => [ 'DBInstance$Endpoint' => '<p>Specifies the connection endpoint.</p>', ], ], 'EngineDefaults' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeEngineDefaultClusterParameters</code> operation. </p>', 'refs' => [ 'DescribeEngineDefaultClusterParametersResult$EngineDefaults' => NULL, ], ], 'Event' => [ 'base' => '<p>Detailed information about an event.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a <code>SourceType</code> that you want to subscribe to. </p>', 'DescribeEventsMessage$EventCategories' => '<p>A list of event categories that trigger notifications for an event notification subscription.</p>', 'Event$EventCategories' => '<p>Specifies the category for the event.</p>', 'EventCategoriesMap$EventCategories' => '<p>The event categories for the specified source type.</p>', 'EventSubscription$EventCategoriesList' => '<p>A list of event categories for the Amazon DocumentDB event notification subscription.</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a <code>SourceType</code> that you want to subscribe to.</p>', ], ], 'EventCategoriesMap' => [ 'base' => '<p>An event source type, accompanied by one or more event category names.</p>', 'refs' => [ 'EventCategoriesMapList$member' => NULL, ], ], 'EventCategoriesMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMessage$EventCategoriesMapList' => '<p>A list of event category maps.</p>', ], ], 'EventCategoriesMessage' => [ 'base' => '<p>Represents the output of <a>DescribeEventCategories</a>.</p>', 'refs' => [], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p>Detailed information about one or more events. </p>', ], ], 'EventSubscription' => [ 'base' => '<p>Detailed information about an event to which you have subscribed.</p>', 'refs' => [ 'AddSourceIdentifierToSubscriptionResult$EventSubscription' => NULL, 'CreateEventSubscriptionResult$EventSubscription' => NULL, 'DeleteEventSubscriptionResult$EventSubscription' => NULL, 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResult$EventSubscription' => NULL, 'RemoveSourceIdentifierFromSubscriptionResult$EventSubscription' => NULL, ], ], 'EventSubscriptionQuotaExceededFault' => [ 'base' => '<p>You have reached the maximum number of event subscriptions. </p>', 'refs' => [], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'EventSubscriptionsMessage$EventSubscriptionsList' => '<p>A list of event subscriptions.</p>', ], ], 'EventSubscriptionsMessage' => [ 'base' => '<p>Represents the output of <a>DescribeEventSubscriptions</a>.</p>', 'refs' => [], ], 'EventsMessage' => [ 'base' => '<p>Represents the output of <a>DescribeEvents</a>.</p>', 'refs' => [], ], 'FailoverDBClusterMessage' => [ 'base' => '<p>Represents the input to <a>FailoverDBCluster</a>.</p>', 'refs' => [], ], 'FailoverDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => '<p>A named set of filter values, used to return a more specific list of results. You can use a filter to match a set of resources by specific criteria, such as IDs.</p> <p>Wildcards are not supported in filters.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificatesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterParameterGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterSnapshotsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClustersMessage$Filters' => '<p>A filter that specifies one or more clusters to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.</p> </li> </ul>', 'DescribeDBEngineVersionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBInstancesMessage$Filters' => '<p>A filter that specifies one or more instances to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.</p> </li> </ul>', 'DescribeDBSubnetGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEngineDefaultClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventCategoriesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventSubscriptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeGlobalClustersMessage$Filters' => '<p>A filter that specifies one or more global DB clusters to describe.</p> <p>Supported filters: <code>db-cluster-id</code> accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribePendingMaintenanceActionsMessage$Filters' => '<p>A filter that specifies one or more resources to return pending maintenance actions for.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only pending maintenance actions for the clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts instance identifiers and instance ARNs. The results list includes only pending maintenance actions for the DB instances identified by these ARNs.</p> </li> </ul>', 'ListTagsForResourceMessage$Filters' => '<p>This parameter is not currently supported.</p>', ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>One or more filter values. Filter values are case sensitive.</p>', ], ], 'GlobalCluster' => [ 'base' => '<p>A data type representing an Amazon DocumentDB global cluster.</p>', 'refs' => [ 'CreateGlobalClusterResult$GlobalCluster' => NULL, 'DeleteGlobalClusterResult$GlobalCluster' => NULL, 'FailoverGlobalClusterResult$GlobalCluster' => NULL, 'GlobalClusterList$member' => NULL, 'ModifyGlobalClusterResult$GlobalCluster' => NULL, 'RemoveFromGlobalClusterResult$GlobalCluster' => NULL, 'SwitchoverGlobalClusterResult$GlobalCluster' => NULL, ], ], 'GlobalClusterAlreadyExistsFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global cluster identifier (unique name) to create a new global cluster. </p>', 'refs' => [], ], 'GlobalClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the new global cluster.</p>', 'CreateGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the new global cluster.</p>', 'DeleteGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the global cluster being deleted.</p>', 'DescribeGlobalClustersMessage$GlobalClusterIdentifier' => '<p>The user-supplied cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn\'t case-sensitive.</p>', 'FailoverGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier of the Amazon DocumentDB global cluster to apply this operation. The identifier is the unique key assigned by the user when the cluster is created. In other words, it\'s the name of the global cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global cluster.</p> </li> <li> <p>Minimum length of 1. Maximum length of 255.</p> </li> </ul> <p>Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code> </p>', 'GlobalCluster$GlobalClusterIdentifier' => '<p>Contains a user-supplied global cluster identifier. This identifier is the unique key that identifies a global cluster. </p>', 'ModifyGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier for the global cluster being modified. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global cluster.</p> </li> </ul>', 'ModifyGlobalClusterMessage$NewGlobalClusterIdentifier' => '<p>The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> <p>The first character must be a letter</p> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'RemoveFromGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier to detach from the Amazon DocumentDB global cluster. </p>', 'SwitchoverGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier of the Amazon DocumentDB global database cluster to switch over. The identifier is the unique key assigned by the user when the cluster is created. In other words, it\'s the name of the global cluster. This parameter isn’t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global cluster (Amazon DocumentDB global database).</p> </li> <li> <p>Minimum length of 1. Maximum length of 255.</p> </li> </ul> <p>Pattern: <code>[A-Za-z][0-9A-Za-z-:._]*</code> </p>', ], ], 'GlobalClusterList' => [ 'base' => NULL, 'refs' => [ 'GlobalClustersMessage$GlobalClusters' => '<p/>', ], ], 'GlobalClusterMember' => [ 'base' => '<p>A data structure with information about any primary and secondary clusters associated with an Amazon DocumentDB global clusters. </p>', 'refs' => [ 'GlobalClusterMemberList$member' => NULL, ], ], 'GlobalClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'GlobalCluster$GlobalClusterMembers' => '<p>The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item. </p>', ], ], 'GlobalClusterNotFoundFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> doesn\'t refer to an existing global cluster.</p>', 'refs' => [], ], 'GlobalClusterQuotaExceededFault' => [ 'base' => '<p>The number of global clusters for this account is already at the maximum allowed.</p>', 'refs' => [], ], 'GlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'InstanceQuotaExceededFault' => [ 'base' => '<p>The request would cause you to exceed the allowed number of instances.</p>', 'refs' => [], ], 'InsufficientDBClusterCapacityFault' => [ 'base' => '<p>The cluster doesn\'t have enough capacity for the current operation.</p>', 'refs' => [], ], 'InsufficientDBInstanceCapacityFault' => [ 'base' => '<p>The specified instance class isn\'t available in the specified Availability Zone.</p>', 'refs' => [], ], 'InsufficientStorageClusterCapacityFault' => [ 'base' => '<p>There is not enough storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available. </p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshot$Port' => '<p>Specifies the port that the cluster was listening on at the time of the snapshot.</p>', 'DBClusterSnapshot$PercentProgress' => '<p>Specifies the percentage of the estimated data that has been transferred.</p>', 'DBInstance$BackupRetentionPeriod' => '<p>Specifies the number of days for which automatic snapshots are retained.</p>', 'Endpoint$Port' => '<p>Specifies the port that the database engine is listening on.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35.</p> </li> </ul>', 'CreateDBClusterMessage$Port' => '<p>The port number on which the instances in the cluster accept connections.</p>', 'CreateDBInstanceMessage$PromotionTier' => '<p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p> <p>Default: 1</p> <p>Valid values: 0-15</p>', 'DBCluster$BackupRetentionPeriod' => '<p>Specifies the number of days for which automatic snapshots are retained.</p>', 'DBCluster$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'DBClusterMember$PromotionTier' => '<p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance. </p>', 'DBInstance$PromotionTier' => '<p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p>', 'DescribeCertificatesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints:</p> <ul> <li> <p>Minimum: 20</p> </li> <li> <p>Maximum: 100</p> </li> </ul>', 'DescribeDBClusterParameterGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterSnapshotsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClustersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBEngineVersionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSubnetGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes to retrieve events for.</p> <p>Default: 60</p>', 'DescribeEventsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeGlobalClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. </p>', 'DescribeOrderableDBInstanceOptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribePendingMaintenanceActionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'ModifyDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35.</p> </li> </ul>', 'ModifyDBClusterMessage$Port' => '<p>The port number on which the cluster accepts connections.</p> <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p> <p>Default: The same port as the original cluster.</p>', 'ModifyDBInstanceMessage$PromotionTier' => '<p>A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.</p> <p>Default: 1</p> <p>Valid values: 0-15</p>', 'PendingModifiedValues$AllocatedStorage' => '<p> Contains the new <code>AllocatedStorage</code> size for then instance that will be applied or is currently being applied. </p>', 'PendingModifiedValues$Port' => '<p>Specifies the pending port for the instance.</p>', 'PendingModifiedValues$BackupRetentionPeriod' => '<p>Specifies the pending number of days for which automated backups are retained.</p>', 'PendingModifiedValues$Iops' => '<p>Specifies the new Provisioned IOPS value for the instance that will be applied or is currently being applied.</p>', 'RestoreDBClusterFromSnapshotMessage$Port' => '<p>The port number on which the new cluster accepts connections.</p> <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>.</p> <p>Default: The same port as the original cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$Port' => '<p>The port number on which the new cluster accepts connections.</p> <p>Constraints: Must be a value from <code>1150</code> to <code>65535</code>. </p> <p>Default: The default port for the engine.</p>', ], ], 'InvalidDBClusterSnapshotStateFault' => [ 'base' => '<p>The provided value isn\'t a valid cluster snapshot state.</p>', 'refs' => [], ], 'InvalidDBClusterStateFault' => [ 'base' => '<p>The cluster isn\'t in a valid state.</p>', 'refs' => [], ], 'InvalidDBInstanceStateFault' => [ 'base' => '<p> The specified instance isn\'t in the <i>available</i> state. </p>', 'refs' => [], ], 'InvalidDBParameterGroupStateFault' => [ 'base' => '<p>The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the parameter group, you can\'t delete it when the parameter group is in this state.</p>', 'refs' => [], ], 'InvalidDBSecurityGroupStateFault' => [ 'base' => '<p>The state of the security group doesn\'t allow deletion.</p>', 'refs' => [], ], 'InvalidDBSnapshotStateFault' => [ 'base' => '<p>The state of the snapshot doesn\'t allow deletion.</p>', 'refs' => [], ], 'InvalidDBSubnetGroupStateFault' => [ 'base' => '<p>The subnet group can\'t be deleted because it\'s in use.</p>', 'refs' => [], ], 'InvalidDBSubnetStateFault' => [ 'base' => '<p> The subnet isn\'t in the <i>available</i> state. </p>', 'refs' => [], ], 'InvalidEventSubscriptionStateFault' => [ 'base' => '<p>Someone else might be modifying a subscription. Wait a few seconds, and try again.</p>', 'refs' => [], ], 'InvalidGlobalClusterStateFault' => [ 'base' => '<p>The requested operation can\'t be performed while the cluster is in this state.</p>', 'refs' => [], ], 'InvalidRestoreFault' => [ 'base' => '<p>You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>The requested subnet is not valid, or multiple subnets were requested that are not all in a common virtual private cloud (VPC).</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>The subnet group doesn\'t cover all Availability Zones after it is created because of changes that were made.</p>', 'refs' => [], ], 'KMSKeyNotAccessibleFault' => [ 'base' => '<p>An error occurred when accessing an KMS key.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>The tag key (name) of the tag to be removed.</p>', ], ], 'ListTagsForResourceMessage' => [ 'base' => '<p>Represents the input to <a>ListTagsForResource</a>.</p>', 'refs' => [], ], 'LogTypeList' => [ 'base' => NULL, 'refs' => [ 'CloudwatchLogsExportConfiguration$EnableLogTypes' => '<p>The list of log types to enable.</p>', 'CloudwatchLogsExportConfiguration$DisableLogTypes' => '<p>The list of log types to disable.</p>', 'CreateDBClusterMessage$EnableCloudwatchLogsExports' => '<p>A list of log types that need to be enabled for exporting to Amazon CloudWatch Logs. You can enable audit logs or profiler logs. For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html"> Auditing Amazon DocumentDB Events</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html"> Profiling Amazon DocumentDB Operations</a>. </p>', 'DBCluster$EnabledCloudwatchLogsExports' => '<p>A list of log types that this cluster is configured to export to Amazon CloudWatch Logs.</p>', 'DBEngineVersion$ExportableLogTypes' => '<p>The types of logs that the database engine has available for export to Amazon CloudWatch Logs.</p>', 'DBInstance$EnabledCloudwatchLogsExports' => '<p>A list of log types that this instance is configured to export to CloudWatch Logs.</p>', 'PendingCloudwatchLogsExports$LogTypesToEnable' => '<p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren\'t exported to CloudWatch Logs.</p>', 'PendingCloudwatchLogsExports$LogTypesToDisable' => '<p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to Amazon CloudWatch Logs.</p>', 'RestoreDBClusterFromSnapshotMessage$EnableCloudwatchLogsExports' => '<p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>', 'RestoreDBClusterToPointInTimeMessage$EnableCloudwatchLogsExports' => '<p>A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.</p>', ], ], 'ModifyDBClusterMessage' => [ 'base' => '<p>Represents the input to <a>ModifyDBCluster</a>.</p>', 'refs' => [], ], 'ModifyDBClusterParameterGroupMessage' => [ 'base' => '<p>Represents the input to <a>ModifyDBClusterParameterGroup</a>.</p>', 'refs' => [], ], 'ModifyDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeMessage' => [ 'base' => '<p>Represents the input to <a>ModifyDBClusterSnapshotAttribute</a>.</p>', 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBInstanceMessage' => [ 'base' => '<p>Represents the input to <a>ModifyDBInstance</a>.</p>', 'refs' => [], ], 'ModifyDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSubnetGroupMessage' => [ 'base' => '<p>Represents the input to <a>ModifyDBSubnetGroup</a>.</p>', 'refs' => [], ], 'ModifyDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => '<p>Represents the input to <a>ModifyEventSubscription</a>.</p>', 'refs' => [], ], 'ModifyEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalClusterMessage' => [ 'base' => '<p>Represents the input to <a>ModifyGlobalCluster</a>.</p>', 'refs' => [], ], 'ModifyGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'OrderableDBInstanceOption' => [ 'base' => '<p>The options that are available for an instance.</p>', 'refs' => [ 'OrderableDBInstanceOptionsList$member' => NULL, ], ], 'OrderableDBInstanceOptionsList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOptionsMessage$OrderableDBInstanceOptions' => '<p>The options that are available for a particular orderable instance.</p>', ], ], 'OrderableDBInstanceOptionsMessage' => [ 'base' => '<p>Represents the output of <a>DescribeOrderableDBInstanceOptions</a>.</p>', 'refs' => [], ], 'Parameter' => [ 'base' => '<p>Detailed information about an individual parameter.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupDetails$Parameters' => '<p>Provides a list of parameters for the cluster parameter group.</p>', 'EngineDefaults$Parameters' => '<p>The parameters of a particular cluster parameter group family.</p>', 'ModifyDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameters in the cluster parameter group to modify.</p>', 'ResetDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameter names in the cluster parameter group to reset to the default values. You can\'t use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>', ], ], 'PendingCloudwatchLogsExports' => [ 'base' => '<p>A list of the log types whose configuration is still pending. These log types are in the process of being activated or deactivated.</p>', 'refs' => [ 'PendingModifiedValues$PendingCloudwatchLogsExports' => '<p>A list of the log types whose configuration is still pending. These log types are in the process of being activated or deactivated.</p>', ], ], 'PendingMaintenanceAction' => [ 'base' => '<p>Provides information about a pending maintenance action for a resource.</p>', 'refs' => [ 'PendingMaintenanceActionDetails$member' => NULL, ], ], 'PendingMaintenanceActionDetails' => [ 'base' => NULL, 'refs' => [ 'ResourcePendingMaintenanceActions$PendingMaintenanceActionDetails' => '<p>A list that provides details about the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActions' => [ 'base' => NULL, 'refs' => [ 'PendingMaintenanceActionsMessage$PendingMaintenanceActions' => '<p>The maintenance actions to be applied.</p>', ], ], 'PendingMaintenanceActionsMessage' => [ 'base' => '<p>Represents the output of <a>DescribePendingMaintenanceActions</a>.</p>', 'refs' => [], ], 'PendingModifiedValues' => [ 'base' => '<p> One or more modified settings for an instance. These modified settings have been requested, but haven\'t been applied yet.</p>', 'refs' => [ 'DBInstance$PendingModifiedValues' => '<p>Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.</p>', ], ], 'ReadReplicaIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$ReadReplicaIdentifiers' => '<p>Contains one or more identifiers of the secondary clusters that are associated with this cluster.</p>', ], ], 'ReadersArnList' => [ 'base' => NULL, 'refs' => [ 'GlobalClusterMember$Readers' => '<p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.</p>', ], ], 'RebootDBInstanceMessage' => [ 'base' => '<p>Represents the input to <a>RebootDBInstance</a>.</p>', 'refs' => [], ], 'RebootDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveFromGlobalClusterMessage' => [ 'base' => '<p>Represents the input to <a>RemoveFromGlobalCluster</a>.</p>', 'refs' => [], ], 'RemoveFromGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionMessage' => [ 'base' => '<p>Represents the input to <a>RemoveSourceIdentifierFromSubscription</a>.</p>', 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p>Represents the input to <a>RemoveTagsFromResource</a>.</p>', 'refs' => [], ], 'ResetDBClusterParameterGroupMessage' => [ 'base' => '<p>Represents the input to <a>ResetDBClusterParameterGroup</a>.</p>', 'refs' => [], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The specified resource ID was not found.</p>', 'refs' => [], ], 'ResourcePendingMaintenanceActions' => [ 'base' => '<p>Represents the output of <a>ApplyPendingMaintenanceAction</a>. </p>', 'refs' => [ 'ApplyPendingMaintenanceActionResult$ResourcePendingMaintenanceActions' => NULL, 'PendingMaintenanceActions$member' => NULL, ], ], 'RestoreDBClusterFromSnapshotMessage' => [ 'base' => '<p>Represents the input to <a>RestoreDBClusterFromSnapshot</a>.</p>', 'refs' => [], ], 'RestoreDBClusterFromSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterToPointInTimeMessage' => [ 'base' => '<p>Represents the input to <a>RestoreDBClusterToPointInTime</a>.</p>', 'refs' => [], ], 'RestoreDBClusterToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>Amazon SNS has responded that there is a problem with the specified topic. </p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>You do not have permission to publish to the SNS topic Amazon Resource Name (ARN). </p>', 'refs' => [], ], 'SNSTopicArnNotFoundFault' => [ 'base' => '<p>The SNS topic Amazon Resource Name (ARN) does not exist. </p>', 'refs' => [], ], 'SharedSnapshotQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with. </p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p>The request would cause you to exceed the allowed number of snapshots.</p>', 'refs' => [], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must be provided.</p> </li> <li> <p>If the source type is a security group, a <code>DBSecurityGroupName</code> must be provided.</p> </li> <li> <p>If the source type is a parameter group, a <code>DBParameterGroupName</code> must be provided.</p> </li> <li> <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must be provided.</p> </li> </ul>', 'EventSubscription$SourceIdsList' => '<p>A list of source IDs for the Amazon DocumentDB event notification subscription.</p>', ], ], 'SourceNotFoundFault' => [ 'base' => '<p>The requested source could not be found. </p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the source type for this event.</p>', ], ], 'StartDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageQuotaExceededFault' => [ 'base' => '<p>The request would cause you to exceed the allowed amount of storage available across all instances.</p>', 'refs' => [], ], 'StorageTypeNotSupportedFault' => [ 'base' => '<p>Storage of the specified <code>StorageType</code> can\'t be associated with the DB instance. </p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddSourceIdentifierToSubscriptionMessage$SubscriptionName' => '<p>The name of the Amazon DocumentDB event notification subscription that you want to add a source identifier to.</p>', 'AddSourceIdentifierToSubscriptionMessage$SourceIdentifier' => '<p>The identifier of the event source to be added:</p> <ul> <li> <p>If the source type is an instance, a <code>DBInstanceIdentifier</code> must be provided.</p> </li> <li> <p>If the source type is a security group, a <code>DBSecurityGroupName</code> must be provided.</p> </li> <li> <p>If the source type is a parameter group, a <code>DBParameterGroupName</code> must be provided.</p> </li> <li> <p>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must be provided.</p> </li> </ul>', 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon DocumentDB resource that the tags are added to. This value is an Amazon Resource Name .</p>', 'ApplyPendingMaintenanceActionMessage$ResourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to.</p>', 'ApplyPendingMaintenanceActionMessage$ApplyAction' => '<p>The pending maintenance action to apply to this resource.</p> <p>Valid values: <code>system-update</code>, <code>db-upgrade</code> </p>', 'ApplyPendingMaintenanceActionMessage$OptInType' => '<p>A value that specifies the type of opt-in request or undoes an opt-in request. An opt-in request of type <code>immediate</code> can\'t be undone.</p> <p>Valid values:</p> <ul> <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li> <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource. </p> </li> <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li> </ul>', 'AttributeValueList$member' => NULL, 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZones$member' => NULL, 'CACertificateIdentifiersList$member' => NULL, 'Certificate$CertificateIdentifier' => '<p>The unique key that identifies a certificate.</p> <p>Example: <code>rds-ca-2019</code> </p>', 'Certificate$CertificateType' => '<p>The type of the certificate.</p> <p>Example: <code>CA</code> </p>', 'Certificate$Thumbprint' => '<p>The thumbprint of the certificate.</p>', 'Certificate$CertificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate.</p> <p>Example: <code>arn:aws:rds:us-east-1::cert:rds-ca-2019</code> </p>', 'CertificateDetails$CAIdentifier' => '<p>The CA identifier of the CA certificate used for the DB instance\'s server certificate.</p>', 'CertificateMessage$Marker' => '<p>An optional pagination token provided if the number of records retrieved is greater than <code>MaxRecords</code>. If this parameter is specified, the marker specifies the next record in the list. Including the value of <code>Marker</code> in the next call to <code>DescribeCertificates</code> results in the next page of certificates.</p>', 'CopyDBClusterParameterGroupMessage$SourceDBClusterParameterGroupIdentifier' => '<p>The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid cluster parameter group.</p> </li> <li> <p>If the source cluster parameter group is in the same Amazon Web Services Region as the copy, specify a valid parameter group identifier; for example, <code>my-db-cluster-param-group</code>, or a valid ARN.</p> </li> <li> <p>If the source parameter group is in a different Amazon Web Services Region than the copy, specify a valid cluster parameter group ARN; for example, <code>arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group</code>.</p> </li> </ul>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupIdentifier' => '<p>The identifier for the copied cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens. </p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens. </p> </li> </ul> <p>Example: <code>my-cluster-param-group1</code> </p>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupDescription' => '<p>A description for the copied cluster parameter group.</p>', 'CopyDBClusterSnapshotMessage$SourceDBClusterSnapshotIdentifier' => '<p>The identifier of the cluster snapshot to copy. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the <i>available</i> state.</p> </li> <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid snapshot identifier.</p> </li> <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid cluster snapshot ARN.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot1</code> </p>', 'CopyDBClusterSnapshotMessage$TargetDBClusterSnapshotIdentifier' => '<p>The identifier of the new cluster snapshot to create from the source cluster snapshot. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens. </p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens. </p> </li> </ul> <p>Example: <code>my-cluster-snapshot2</code> </p>', 'CopyDBClusterSnapshotMessage$KmsKeyId' => '<p>The KMS key ID for an encrypted cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key. </p> <p>If you copy an encrypted cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS encryption key. If you don\'t specify a value for <code>KmsKeyId</code>, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.</p> <p>If you copy an encrypted cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p> <p>To copy an encrypted cluster snapshot to another Amazon Web Services Region, set <code>KmsKeyId</code> to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Amazon Web Services Region that they are created in, and you can\'t use encryption keys from one Amazon Web Services Region in another Amazon Web Services Region.</p> <p>If you copy an unencrypted cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>', 'CopyDBClusterSnapshotMessage$PreSignedUrl' => '<p>The URL that contains a Signature Version 4 signed request for the<code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source cluster snapshot to copy. You must use the <code>PreSignedUrl</code> parameter when copying a cluster snapshot from another Amazon Web Services Region.</p> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p> <p>The presigned URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the cluster snapshot to be copied. The presigned URL request must contain the following parameter values:</p> <ul> <li> <p> <code>SourceRegion</code> - The ID of the region that contains the snapshot to be copied.</p> </li> <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The identifier for the the encrypted cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted cluster snapshot from the us-east-1 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks something like the following: <code>arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot</code>.</p> </li> <li> <p> <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new cluster snapshot to be created. This parameter isn\'t case sensitive.</p> </li> </ul>', 'CreateDBClusterMessage$DBClusterIdentifier' => '<p>The cluster identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens. </p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens. </p> </li> </ul> <p>Example: <code>my-cluster</code> </p>', 'CreateDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group to associate with this cluster.</p>', 'CreateDBClusterMessage$DBSubnetGroupName' => '<p>A subnet group to associate with this cluster.</p> <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'CreateDBClusterMessage$Engine' => '<p>The name of the database engine to be used for this cluster.</p> <p>Valid values: <code>docdb</code> </p>', 'CreateDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to use. The <code>--engine-version</code> will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.</p>', 'CreateDBClusterMessage$MasterUsername' => '<p>The name of the master user for the cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be from 1 to 63 letters or numbers.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot be a reserved word for the chosen database engine. </p> </li> </ul>', 'CreateDBClusterMessage$MasterUserPassword' => '<p>The password for the master database user. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).</p> <p>Constraints: Must contain from 8 to 100 characters.</p>', 'CreateDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window. </p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBClusterMessage$KmsKeyId' => '<p>The KMS key identifier for an encrypted cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon Web Services account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>If an encryption key is not specified in <code>KmsKeyId</code>: </p> <ul> <li> <p>If the <code>StorageEncrypted</code> parameter is <code>true</code>, Amazon DocumentDB uses your default encryption key. </p> </li> </ul> <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Regions.</p>', 'CreateDBClusterMessage$PreSignedUrl' => '<p>Not currently supported. </p>', 'CreateDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p> <note> <p>When you create a DocumentDB DB cluster with the storage type set to <code>iopt1</code>, the storage type is returned in the response. The storage type isn\'t returned when you set it to <code>standard</code>.</p> </note>', 'CreateDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must not match the name of an existing <code>DBClusterParameterGroup</code>.</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'CreateDBClusterParameterGroupMessage$DBParameterGroupFamily' => '<p>The cluster parameter group family name.</p>', 'CreateDBClusterParameterGroupMessage$Description' => '<p>The description for the cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the cluster snapshot. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens. </p> </li> </ul> <p>Example: <code>my-cluster-snapshot1</code> </p>', 'CreateDBClusterSnapshotMessage$DBClusterIdentifier' => '<p>The identifier of the cluster to create a snapshot for. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBCluster</code>.</p> </li> </ul> <p>Example: <code>my-cluster</code> </p>', 'CreateDBInstanceMessage$DBInstanceIdentifier' => '<p>The instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'CreateDBInstanceMessage$DBInstanceClass' => '<p>The compute and memory capacity of the instance; for example, <code>db.r5.large</code>. </p>', 'CreateDBInstanceMessage$Engine' => '<p>The name of the database engine to be used for this instance.</p> <p>Valid value: <code>docdb</code> </p>', 'CreateDBInstanceMessage$AvailabilityZone' => '<p>The Amazon EC2 Availability Zone that the instance is created in. </p> <p>Default: A random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region.</p> <p>Example: <code>us-east-1d</code> </p>', 'CreateDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. </p> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBInstanceMessage$DBClusterIdentifier' => '<p>The identifier of the cluster that the instance will belong to.</p>', 'CreateDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p>The KMS key identifier for encryption of Performance Insights data.</p> <p>The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.</p>', 'CreateDBInstanceMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">Updating Your Amazon DocumentDB TLS Certificates</a> and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html"> Encrypting Data in Transit</a> in the <i>Amazon DocumentDB Developer Guide</i>.</p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the subnet group.</p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the subscription.</p> <p>Constraints: The name must be fewer than 255 characters.</p>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.</p>', 'CreateEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p> <p>Valid values: <code>db-instance</code>, <code>db-cluster</code>, <code>db-parameter-group</code>, <code>db-security-group</code>, <code>db-cluster-snapshot</code> </p>', 'CreateGlobalClusterMessage$SourceDBClusterIdentifier' => '<p>The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.</p>', 'CreateGlobalClusterMessage$Engine' => '<p>The name of the database engine to be used for this cluster.</p>', 'CreateGlobalClusterMessage$EngineVersion' => '<p>The engine version of the global cluster.</p>', 'CreateGlobalClusterMessage$DatabaseName' => '<p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.</p>', 'DBCluster$DBClusterIdentifier' => '<p>Contains a user-supplied cluster identifier. This identifier is the unique key that identifies a cluster.</p>', 'DBCluster$DBClusterParameterGroup' => '<p>Specifies the name of the cluster parameter group for the cluster.</p>', 'DBCluster$DBSubnetGroup' => '<p>Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.</p>', 'DBCluster$Status' => '<p>Specifies the current state of this cluster.</p>', 'DBCluster$PercentProgress' => '<p>Specifies the progress of the operation as a percentage.</p>', 'DBCluster$Endpoint' => '<p>Specifies the connection endpoint for the primary instance of the cluster.</p>', 'DBCluster$ReaderEndpoint' => '<p>The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster. </p> <p>If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.</p>', 'DBCluster$Engine' => '<p>Provides the name of the database engine to be used for this cluster.</p>', 'DBCluster$EngineVersion' => '<p>Indicates the database engine version.</p>', 'DBCluster$MasterUsername' => '<p>Contains the master user name for the cluster.</p>', 'DBCluster$PreferredBackupWindow' => '<p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>', 'DBCluster$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBCluster$ReplicationSourceIdentifier' => '<p>Contains the identifier of the source cluster if this cluster is a secondary cluster.</p>', 'DBCluster$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'DBCluster$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster.</p>', 'DBCluster$DbClusterResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the cluster. This identifier is found in CloudTrail log entries whenever the KMS key for the cluster is accessed.</p>', 'DBCluster$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for the cluster.</p>', 'DBCluster$CloneGroupId' => '<p>Identifies the clone group to which the DB cluster is associated.</p>', 'DBCluster$StorageType' => '<p>Storage type associated with your cluster</p> <p>Storage type associated with your cluster</p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p>', 'DBClusterMember$DBInstanceIdentifier' => '<p>Specifies the instance identifier for this member of the cluster.</p>', 'DBClusterMember$DBClusterParameterGroupStatus' => '<p>Specifies the status of the cluster parameter group for this member of the DB cluster.</p>', 'DBClusterMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupName' => '<p>Provides the name of the cluster parameter group.</p>', 'DBClusterParameterGroup$DBParameterGroupFamily' => '<p>Provides the name of the parameter group family that this cluster parameter group is compatible with.</p>', 'DBClusterParameterGroup$Description' => '<p>Provides the customer-specified description for this cluster parameter group.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupArn' => '<p>The Amazon Resource Name (ARN) for the cluster parameter group.</p>', 'DBClusterParameterGroupDetails$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterParameterGroupNameMessage$DBClusterParameterGroupName' => '<p>The name of a cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be from 1 to 255 letters or numbers.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'DBClusterParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterRole$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB cluster.</p>', 'DBClusterRole$Status' => '<p>Describes the state of association between the IAMrole and the cluster. The <code>Status</code> property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - The IAMrole ARN is being associated with the cluster.</p> </li> <li> <p> <code>INVALID</code> - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.</p> </li> </ul>', 'DBClusterSnapshot$DBClusterSnapshotIdentifier' => '<p>Specifies the identifier for the cluster snapshot.</p>', 'DBClusterSnapshot$DBClusterIdentifier' => '<p>Specifies the cluster identifier of the cluster that this cluster snapshot was created from.</p>', 'DBClusterSnapshot$Engine' => '<p>Specifies the name of the database engine.</p>', 'DBClusterSnapshot$Status' => '<p>Specifies the status of this cluster snapshot.</p>', 'DBClusterSnapshot$VpcId' => '<p>Provides the virtual private cloud (VPC) ID that is associated with the cluster snapshot.</p>', 'DBClusterSnapshot$MasterUsername' => '<p>Provides the master user name for the cluster snapshot.</p>', 'DBClusterSnapshot$EngineVersion' => '<p>Provides the version of the database engine for this cluster snapshot.</p>', 'DBClusterSnapshot$SnapshotType' => '<p>Provides the type of the cluster snapshot.</p>', 'DBClusterSnapshot$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted cluster snapshot.</p>', 'DBClusterSnapshot$DBClusterSnapshotArn' => '<p>The Amazon Resource Name (ARN) for the cluster snapshot.</p>', 'DBClusterSnapshot$SourceDBClusterSnapshotArn' => '<p>If the cluster snapshot was copied from a source cluster snapshot, the ARN for the source cluster snapshot; otherwise, a null value.</p>', 'DBClusterSnapshot$StorageType' => '<p>Storage type associated with your cluster snapshot </p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p>', 'DBClusterSnapshotAttribute$AttributeName' => '<p>The name of the manual cluster snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual cluster snapshot.</p>', 'DBClusterSnapshotAttributesResult$DBClusterSnapshotIdentifier' => '<p>The identifier of the cluster snapshot that the attributes apply to.</p>', 'DBClusterSnapshotMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBEngineVersion$Engine' => '<p>The name of the database engine.</p>', 'DBEngineVersion$EngineVersion' => '<p>The version number of the database engine.</p>', 'DBEngineVersion$DBParameterGroupFamily' => '<p>The name of the parameter group family for the database engine.</p>', 'DBEngineVersion$DBEngineDescription' => '<p>The description of the database engine.</p>', 'DBEngineVersion$DBEngineVersionDescription' => '<p>The description of the database engine version.</p>', 'DBEngineVersionMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBInstance$DBInstanceIdentifier' => '<p>Contains a user-provided database identifier. This identifier is the unique key that identifies an instance.</p>', 'DBInstance$DBInstanceClass' => '<p>Contains the name of the compute and memory capacity class of the instance.</p>', 'DBInstance$Engine' => '<p>Provides the name of the database engine to be used for this instance.</p>', 'DBInstance$DBInstanceStatus' => '<p>Specifies the current state of this database.</p>', 'DBInstance$PreferredBackupWindow' => '<p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>', 'DBInstance$AvailabilityZone' => '<p>Specifies the name of the Availability Zone that the instance is located in.</p>', 'DBInstance$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBInstance$EngineVersion' => '<p>Indicates the database engine version.</p>', 'DBInstance$DBClusterIdentifier' => '<p>Contains the name of the cluster that the instance is a member of if the instance is a member of a cluster.</p>', 'DBInstance$KmsKeyId' => '<p> If <code>StorageEncrypted</code> is <code>true</code>, the KMS key identifier for the encrypted instance. </p>', 'DBInstance$DbiResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is accessed.</p>', 'DBInstance$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p>', 'DBInstance$DBInstanceArn' => '<p>The Amazon Resource Name (ARN) for the instance.</p>', 'DBInstance$PerformanceInsightsKMSKeyId' => '<p>The KMS key identifier for encryption of Performance Insights data. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.</p>', 'DBInstanceMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBInstanceStatusInfo$StatusType' => '<p>This value is currently "<code>read replication</code>."</p>', 'DBInstanceStatusInfo$Status' => '<p>Status of the instance. For a <code>StatusType</code> of read replica, the values can be <code>replicating</code>, error, <code>stopped</code>, or <code>terminated</code>.</p>', 'DBInstanceStatusInfo$Message' => '<p>Details of the error if there is an error for the instance. If the instance is not in an error state, this value is blank.</p>', 'DBSubnetGroup$DBSubnetGroupName' => '<p>The name of the subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupDescription' => '<p>Provides the description of the subnet group.</p>', 'DBSubnetGroup$VpcId' => '<p>Provides the virtual private cloud (VPC) ID of the subnet group.</p>', 'DBSubnetGroup$SubnetGroupStatus' => '<p>Provides the status of the subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB subnet group.</p>', 'DBSubnetGroupMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DeleteDBClusterMessage$DBClusterIdentifier' => '<p>The cluster identifier for the cluster to be deleted. This parameter isn\'t case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing <code>DBClusterIdentifier</code>.</p> </li> </ul>', 'DeleteDBClusterMessage$FinalDBSnapshotIdentifier' => '<p> The cluster snapshot identifier of the new cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p> <note> <p> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to <code>true</code> results in an error. </p> </note> <p>Constraints:</p> <ul> <li> <p>Must be from 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DeleteDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing cluster parameter group.</p> </li> <li> <p>You can\'t delete a default cluster parameter group.</p> </li> <li> <p>Cannot be associated with any clusters.</p> </li> </ul>', 'DeleteDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the cluster snapshot to delete.</p> <p>Constraints: Must be the name of an existing cluster snapshot in the <code>available</code> state.</p>', 'DeleteDBInstanceMessage$DBInstanceIdentifier' => '<p>The instance identifier for the instance to be deleted. This parameter isn\'t case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing instance.</p> </li> </ul>', 'DeleteDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name of the database subnet group to delete.</p> <note> <p>You can\'t delete the default subnet group.</p> </note> <p>Constraints:</p> <p>Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the Amazon DocumentDB event notification subscription that you want to delete.</p>', 'DescribeCertificatesMessage$CertificateIdentifier' => '<p>The user-supplied certificate identifier. If this parameter is specified, information for only the specified certificate is returned. If this parameter is omitted, a list of up to <code>MaxRecords</code> certificates is returned. This parameter is not case sensitive.</p> <p>Constraints</p> <ul> <li> <p>Must match an existing <code>CertificateIdentifier</code>.</p> </li> </ul>', 'DescribeCertificatesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterParameterGroupsMessage$DBClusterParameterGroupName' => '<p>The name of a specific cluster parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p> </li> </ul>', 'DescribeDBClusterParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterParametersMessage$DBClusterParameterGroupName' => '<p>The name of a specific cluster parameter group to return parameter details for.</p> <p>Constraints:</p> <ul> <li> <p>If provided, must match the name of an existing <code>DBClusterParameterGroup</code>.</p> </li> </ul>', 'DescribeDBClusterParametersMessage$Source' => '<p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>. </p>', 'DescribeDBClusterParametersMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterSnapshotAttributesMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the cluster snapshot to describe the attributes for.</p>', 'DescribeDBClusterSnapshotsMessage$DBClusterIdentifier' => '<p>The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can\'t be used with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case sensitive. </p> <p>Constraints:</p> <ul> <li> <p>If provided, must match the identifier of an existing <code>DBCluster</code>.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$DBClusterSnapshotIdentifier' => '<p>A specific cluster snapshot identifier to describe. This parameter can\'t be used with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>If provided, must match the identifier of an existing <code>DBClusterSnapshot</code>.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$SnapshotType' => '<p>The type of cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> - Return all manual cluster snapshots that have been shared to your Amazon Web Services account.</p> </li> <li> <p> <code>public</code> - Return all cluster snapshots that have been marked as public.</p> </li> </ul> <p>If you don\'t specify a <code>SnapshotType</code> value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public cluster snapshots with these results by setting the<code>IncludePublic</code> parameter to <code>true</code>.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don\'t apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>public</code>.</p>', 'DescribeDBClusterSnapshotsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClustersMessage$DBClusterIdentifier' => '<p>The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn\'t case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If provided, must match an existing <code>DBClusterIdentifier</code>.</p> </li> </ul>', 'DescribeDBClustersMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBEngineVersionsMessage$Engine' => '<p>The database engine to return.</p>', 'DescribeDBEngineVersionsMessage$EngineVersion' => '<p>The database engine version to return.</p> <p>Example: <code>3.6.0</code> </p>', 'DescribeDBEngineVersionsMessage$DBParameterGroupFamily' => '<p>The name of a specific parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If provided, must match an existing <code>DBParameterGroupFamily</code>.</p> </li> </ul>', 'DescribeDBEngineVersionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBInstancesMessage$DBInstanceIdentifier' => '<p>The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn\'t case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If provided, must match the identifier of an existing <code>DBInstance</code>.</p> </li> </ul>', 'DescribeDBInstancesMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBSubnetGroupsMessage$DBSubnetGroupName' => '<p>The name of the subnet group to return details for.</p>', 'DescribeDBSubnetGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultClusterParametersMessage$DBParameterGroupFamily' => '<p>The name of the cluster parameter group family to return the engine parameter information for.</p>', 'DescribeEngineDefaultClusterParametersMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventCategoriesMessage$SourceType' => '<p>The type of source that is generating the events.</p> <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code> </p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the Amazon DocumentDB event notification subscription that you want to describe.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIdentifier</code> is provided, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is <code>DBInstance</code>, a <code>DBInstanceIdentifier</code> must be provided.</p> </li> <li> <p>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be provided.</p> </li> <li> <p>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be provided.</p> </li> <li> <p>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be provided.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DescribeEventsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeGlobalClustersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Engine' => '<p>The name of the engine to retrieve instance options for.</p>', 'DescribeOrderableDBInstanceOptionsMessage$EngineVersion' => '<p>The engine version filter value. Specify this parameter to show only the available offerings that match the specified engine version.</p>', 'DescribeOrderableDBInstanceOptionsMessage$DBInstanceClass' => '<p>The instance class filter value. Specify this parameter to show only the available offerings that match the specified instance class.</p>', 'DescribeOrderableDBInstanceOptionsMessage$LicenseModel' => '<p>The license model filter value. Specify this parameter to show only the available offerings that match the specified license model.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribePendingMaintenanceActionsMessage$ResourceIdentifier' => '<p>The ARN of a resource to return pending maintenance actions for.</p>', 'DescribePendingMaintenanceActionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Endpoint$Address' => '<p>Specifies the DNS address of the instance.</p>', 'Endpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'EngineDefaults$DBParameterGroupFamily' => '<p>The name of the cluster parameter group family to return the engine parameter information for.</p>', 'EngineDefaults$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Event$SourceIdentifier' => '<p>Provides the identifier for the source of the event.</p>', 'Event$Message' => '<p>Provides the text of this event.</p>', 'Event$SourceArn' => '<p>The Amazon Resource Name (ARN) for the event.</p>', 'EventCategoriesList$member' => NULL, 'EventCategoriesMap$SourceType' => '<p>The source type that the returned categories belong to.</p>', 'EventSubscription$CustomerAwsId' => '<p>The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The Amazon DocumentDB event notification subscription ID.</p>', 'EventSubscription$SnsTopicArn' => '<p>The topic ARN of the Amazon DocumentDB event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the Amazon DocumentDB event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: <code>creating</code>, <code>modifying</code>, <code>deleting</code>, <code>active</code>, <code>no-permission</code>, <code>topic-not-exist</code> </p> <p>The <code>no-permission</code> status indicates that Amazon DocumentDB no longer has permission to post to the SNS topic. The <code>topic-not-exist</code> status indicates that the topic was deleted after the subscription was created.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The time at which the Amazon DocumentDB event notification subscription was created.</p>', 'EventSubscription$SourceType' => '<p>The source type for the Amazon DocumentDB event notification subscription.</p>', 'EventSubscription$EventSubscriptionArn' => '<p>The Amazon Resource Name (ARN) for the event subscription.</p>', 'EventSubscriptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'EventsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'FailoverDBClusterMessage$DBClusterIdentifier' => '<p>A cluster identifier to force a failover for. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBCluster</code>.</p> </li> </ul>', 'FailoverDBClusterMessage$TargetDBInstanceIdentifier' => '<p>The name of the instance to promote to the primary instance.</p> <p>You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For example, <code>mydbcluster-replica1</code>.</p>', 'Filter$Name' => '<p>The name of the filter. Filter names are case sensitive.</p>', 'FilterValueList$member' => NULL, 'GlobalCluster$GlobalClusterResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in CloudTrail log entries whenever the KMS customer master key (CMK) for the cluster is accessed. </p>', 'GlobalCluster$GlobalClusterArn' => '<p>The Amazon Resource Name (ARN) for the global cluster.</p>', 'GlobalCluster$Status' => '<p>Specifies the current state of this global cluster.</p>', 'GlobalCluster$Engine' => '<p>The Amazon DocumentDB database engine used by the global cluster. </p>', 'GlobalCluster$EngineVersion' => '<p>Indicates the database engine version.</p>', 'GlobalCluster$DatabaseName' => '<p>The default database name within the new global cluster.</p>', 'GlobalClusterMember$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.</p>', 'GlobalClustersMessage$Marker' => '<p/>', 'KeyList$member' => NULL, 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon DocumentDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>', 'LogTypeList$member' => NULL, 'ModifyDBClusterMessage$DBClusterIdentifier' => '<p>The cluster identifier for the cluster that is being modified. This parameter is not case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBCluster</code>.</p> </li> </ul>', 'ModifyDBClusterMessage$NewDBClusterIdentifier' => '<p>The new cluster identifier for the cluster when renaming a cluster. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'ModifyDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group to use for the cluster.</p>', 'ModifyDBClusterMessage$MasterUserPassword' => '<p>The password for the master database user. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).</p> <p>Constraints: Must contain from 8 to 100 characters.</p>', 'ModifyDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. </p> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'ModifyDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p> <p>To list all of the available engine versions for Amazon DocumentDB use the following command:</p> <p> <code>aws docdb describe-db-engine-versions --engine docdb --query "DBEngineVersions[].EngineVersion"</code> </p>', 'ModifyDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p>', 'ModifyDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group to modify.</p>', 'ModifyDBClusterSnapshotAttributeMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the cluster snapshot to modify the attributes for.</p>', 'ModifyDBClusterSnapshotAttributeMessage$AttributeName' => '<p>The name of the cluster snapshot attribute to modify.</p> <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual cluster snapshot, set this value to <code>restore</code>.</p>', 'ModifyDBInstanceMessage$DBInstanceIdentifier' => '<p>The instance identifier. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBInstance</code>.</p> </li> </ul>', 'ModifyDBInstanceMessage$DBInstanceClass' => '<p>The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance classes are available in all Amazon Web Services Regions. </p> <p>If you modify the instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request. </p> <p>Default: Uses existing setting.</p>', 'ModifyDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn\'t result in an outage except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, changing this parameter causes a reboot of the instance. If you are moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure that pending changes are applied.</p> <p>Default: Uses existing setting.</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Must be at least 30 minutes.</p>', 'ModifyDBInstanceMessage$NewDBInstanceIdentifier' => '<p> The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'ModifyDBInstanceMessage$CACertificateIdentifier' => '<p>Indicates the certificate that needs to be associated with the instance.</p>', 'ModifyDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p>The KMS key identifier for encryption of Performance Insights data.</p> <p>The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.</p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the subnet group. This value is stored as a lowercase string. You can\'t modify the default subnet group. </p> <p>Constraints: Must match the name of an existing <code>DBSubnetGroup</code>. Must not be default.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the subnet group.</p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the Amazon DocumentDB event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to <code>db-instance</code>. If this value is not specified, all events are returned.</p> <p>Valid values: <code>db-instance</code>, <code>db-parameter-group</code>, <code>db-security-group</code> </p>', 'OrderableDBInstanceOption$Engine' => '<p>The engine type of an instance.</p>', 'OrderableDBInstanceOption$EngineVersion' => '<p>The engine version of an instance.</p>', 'OrderableDBInstanceOption$DBInstanceClass' => '<p>The instance class for an instance.</p>', 'OrderableDBInstanceOption$LicenseModel' => '<p>The license model for an instance.</p>', 'OrderableDBInstanceOption$StorageType' => '<p>The storage type to associate with the DB cluster</p>', 'OrderableDBInstanceOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Parameter$ParameterName' => '<p>Specifies the name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>Specifies the value of the parameter.</p>', 'Parameter$Description' => '<p>Provides a description of the parameter.</p>', 'Parameter$Source' => '<p>Indicates the source of the parameter value.</p>', 'Parameter$ApplyType' => '<p>Specifies the engine-specific parameters type.</p>', 'Parameter$DataType' => '<p>Specifies the valid data type for the parameter.</p>', 'Parameter$AllowedValues' => '<p>Specifies the valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest engine version to which the parameter can apply.</p>', 'PendingMaintenanceAction$Action' => '<p>The type of pending maintenance action that is available for the resource.</p>', 'PendingMaintenanceAction$OptInStatus' => '<p>Indicates the type of opt-in request that has been received for the resource.</p>', 'PendingMaintenanceAction$Description' => '<p>A description providing more detail about the maintenance action.</p>', 'PendingMaintenanceActionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'PendingModifiedValues$DBInstanceClass' => '<p> Contains the new <code>DBInstanceClass</code> for the instance that will be applied or is currently being applied. </p>', 'PendingModifiedValues$MasterUserPassword' => '<p>Contains the pending or currently in-progress change of the master credentials for the instance.</p>', 'PendingModifiedValues$EngineVersion' => '<p>Indicates the database engine version.</p>', 'PendingModifiedValues$LicenseModel' => '<p>The license model for the instance.</p> <p>Valid values: <code>license-included</code>, <code>bring-your-own-license</code>, <code>general-public-license</code> </p>', 'PendingModifiedValues$DBInstanceIdentifier' => '<p> Contains the new <code>DBInstanceIdentifier</code> for the instance that will be applied or is currently being applied. </p>', 'PendingModifiedValues$StorageType' => '<p>Specifies the storage type to be associated with the instance.</p>', 'PendingModifiedValues$CACertificateIdentifier' => '<p>Specifies the identifier of the certificate authority (CA) certificate for the DB instance.</p>', 'PendingModifiedValues$DBSubnetGroupName' => '<p>The new subnet group for the instance. </p>', 'ReadReplicaIdentifierList$member' => NULL, 'ReadersArnList$member' => NULL, 'RebootDBInstanceMessage$DBInstanceIdentifier' => '<p>The instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBInstance</code>.</p> </li> </ul>', 'RemoveFromGlobalClusterMessage$DbClusterIdentifier' => '<p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. </p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SubscriptionName' => '<p>The name of the Amazon DocumentDB event notification subscription that you want to remove a source identifier from.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SourceIdentifier' => '<p> The source identifier to be removed from the subscription, such as the instance identifier for an instance, or the name of a security group. </p>', 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon DocumentDB resource that the tags are removed from. This value is an Amazon Resource Name (ARN).</p>', 'ResetDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the cluster parameter group to reset.</p>', 'ResourcePendingMaintenanceActions$ResourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the resource that has pending maintenance actions.</p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterIdentifier' => '<p>The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn\'t case sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>', 'RestoreDBClusterFromSnapshotMessage$SnapshotIdentifier' => '<p>The identifier for the snapshot or cluster snapshot to restore from.</p> <p>You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing snapshot.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$Engine' => '<p>The database engine to use for the new cluster.</p> <p>Default: The same as source.</p> <p>Constraint: Must be compatible with the engine of the source.</p>', 'RestoreDBClusterFromSnapshotMessage$EngineVersion' => '<p>The version of the database engine to use for the new cluster.</p>', 'RestoreDBClusterFromSnapshotMessage$DBSubnetGroupName' => '<p>The name of the subnet group to use for the new cluster.</p> <p>Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'RestoreDBClusterFromSnapshotMessage$KmsKeyId' => '<p>The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.</p> </li> <li> <p>If the snapshot or the cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB cluster is not encrypted.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with this DB cluster.</p> <p> <i>Type:</i> String.       <i>Required:</i> No.</p> <p>If this argument is omitted, the default DB cluster parameter group is used. If supplied, must match the name of an existing default DB cluster parameter group. The string must consist of from 1 to 255 letters, numbers or hyphens. Its first character must be a letter, and it cannot end with a hyphen or contain two consecutive hyphens.</p>', 'RestoreDBClusterFromSnapshotMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterIdentifier' => '<p>The name of the new cluster to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'RestoreDBClusterToPointInTimeMessage$RestoreType' => '<p>The type of restore to be performed. You can specify one of the following values:</p> <ul> <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li> <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li> </ul> <p>Constraints: You can\'t specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.</p> <p>If you don\'t specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$SourceDBClusterIdentifier' => '<p>The identifier of the source cluster from which to restore.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing <code>DBCluster</code>.</p> </li> </ul>', 'RestoreDBClusterToPointInTimeMessage$DBSubnetGroupName' => '<p>The subnet group name to use for the new cluster.</p> <p>Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.</p> <p>Example: <code>mySubnetgroup</code> </p>', 'RestoreDBClusterToPointInTimeMessage$KmsKeyId' => '<p>The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.</p> </li> <li> <p>If the cluster is not encrypted, then the restored cluster is not encrypted.</p> </li> </ul> <p>If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then the restore request is rejected.</p>', 'RestoreDBClusterToPointInTimeMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the <i>Amazon DocumentDB Developer Guide</i>.</p> <p>Valid values for storage type - <code>standard | iopt1</code> </p> <p>Default value is <code>standard </code> </p>', 'SourceIdsList$member' => NULL, 'StartDBClusterMessage$DBClusterIdentifier' => '<p>The identifier of the cluster to restart. Example: <code>docdb-2019-05-28-15-24-52</code> </p>', 'StopDBClusterMessage$DBClusterIdentifier' => '<p>The identifier of the cluster to stop. Example: <code>docdb-2019-05-28-15-24-52</code> </p>', 'Subnet$SubnetIdentifier' => '<p>Specifies the identifier of the subnet.</p>', 'Subnet$SubnetStatus' => '<p>Specifies the status of the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'Tag$Key' => '<p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can\'t be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'Tag$Value' => '<p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can\'t be prefixed with "<code>aws:</code>" or "<code>rds:</code>". The string can contain only the set of Unicode letters, digits, white space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'UpgradeTarget$Engine' => '<p>The name of the upgrade target database engine.</p>', 'UpgradeTarget$EngineVersion' => '<p>The version number of the upgrade target database engine.</p>', 'UpgradeTarget$Description' => '<p>The version of the database engine that an instance can be upgraded to.</p>', 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'VpcSecurityGroupMembership$Status' => '<p>The status of the VPC security group.</p>', ], ], 'Subnet' => [ 'base' => '<p> Detailed information about a subnet. </p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p>The subnet is already in use in the Availability Zone.</p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateDBSubnetGroupMessage$SubnetIds' => '<p>The Amazon EC2 subnet IDs for the subnet group.</p>', 'ModifyDBSubnetGroupMessage$SubnetIds' => '<p>The Amazon EC2 subnet IDs for the subnet group.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroup$Subnets' => '<p>Detailed information about one or more subnets within a subnet group.</p>', ], ], 'SubscriptionAlreadyExistFault' => [ 'base' => '<p>The provided subscription name already exists. </p>', 'refs' => [], ], 'SubscriptionCategoryNotFoundFault' => [ 'base' => '<p>The provided category does not exist. </p>', 'refs' => [], ], 'SubscriptionNotFoundFault' => [ 'base' => '<p>The subscription name does not exist. </p>', 'refs' => [], ], 'SwitchoverGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'Certificate$ValidFrom' => '<p>The starting date-time from which the certificate is valid.</p> <p>Example: <code>2019-07-31T17:57:09Z</code> </p>', 'Certificate$ValidTill' => '<p>The date-time after which the certificate is no longer valid.</p> <p>Example: <code>2024-07-31T17:57:09Z</code> </p>', 'CertificateDetails$ValidTill' => '<p>The expiration date of the DB instance’s server certificate.</p>', 'DBCluster$EarliestRestorableTime' => '<p>The earliest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$ClusterCreateTime' => '<p>Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBClusterSnapshot$SnapshotCreateTime' => '<p>Provides the time when the snapshot was taken, in UTC.</p>', 'DBClusterSnapshot$ClusterCreateTime' => '<p>Specifies the time when the cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBInstance$InstanceCreateTime' => '<p>Provides the date and time that the instance was created.</p>', 'DBInstance$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>', 'DescribeEventsMessage$StartTime' => '<p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. </p> <p>Example: 2009-07-08T18:00Z</p>', 'DescribeEventsMessage$EndTime' => '<p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. </p> <p>Example: 2009-07-08T18:00Z</p>', 'Event$Date' => '<p>Specifies the date and time of the event.</p>', 'PendingMaintenanceAction$AutoAppliedAfterDate' => '<p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date. If this date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$ForcedApplyDate' => '<p>The date when the maintenance action is automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$CurrentApplyDate' => '<p>The effective date when the pending maintenance action is applied to the resource.</p>', 'RestoreDBClusterToPointInTimeMessage$RestoreToTime' => '<p>The date and time to restore the cluster to.</p> <p>Valid values: A time in Universal Coordinated Time (UTC) format.</p> <p>Constraints:</p> <ul> <li> <p>Must be before the latest restorable time for the instance.</p> </li> <li> <p>Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.</p> </li> <li> <p>Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.</p> </li> <li> <p>Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.</p> </li> </ul> <p>Example: <code>2015-03-07T23:45:00Z</code> </p>', ], ], 'Tag' => [ 'base' => '<p>Metadata assigned to an Amazon DocumentDB resource consisting of a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>The tags to be assigned to the Amazon DocumentDB resource.</p>', 'CopyDBClusterParameterGroupMessage$Tags' => '<p>The tags that are to be assigned to the parameter group.</p>', 'CopyDBClusterSnapshotMessage$Tags' => '<p>The tags to be assigned to the cluster snapshot.</p>', 'CreateDBClusterMessage$Tags' => '<p>The tags to be assigned to the cluster.</p>', 'CreateDBClusterParameterGroupMessage$Tags' => '<p>The tags to be assigned to the cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$Tags' => '<p>The tags to be assigned to the cluster snapshot.</p>', 'CreateDBInstanceMessage$Tags' => '<p>The tags to be assigned to the instance. You can assign up to 10 tags to an instance.</p>', 'CreateDBSubnetGroupMessage$Tags' => '<p>The tags to be assigned to the subnet group.</p>', 'CreateEventSubscriptionMessage$Tags' => '<p>The tags to be assigned to the event subscription.</p>', 'RestoreDBClusterFromSnapshotMessage$Tags' => '<p>The tags to be assigned to the restored cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$Tags' => '<p>The tags to be assigned to the restored cluster.</p>', 'TagListMessage$TagList' => '<p>A list of one or more tags.</p>', ], ], 'TagListMessage' => [ 'base' => '<p>Represents the output of <a>ListTagsForResource</a>.</p>', 'refs' => [], ], 'UpgradeTarget' => [ 'base' => '<p>The version of the database engine that an instance can be upgraded to.</p>', 'refs' => [ 'ValidUpgradeTargetList$member' => NULL, ], ], 'ValidUpgradeTargetList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$ValidUpgradeTarget' => '<p>A list of engine versions that this database engine version can be upgraded to.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this cluster. </p>', 'ModifyDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of virtual private cloud (VPC) security groups that the cluster will belong to.</p>', 'RestoreDBClusterFromSnapshotMessage$VpcSecurityGroupIds' => '<p>A list of virtual private cloud (VPC) security groups that the new cluster will belong to.</p>', 'RestoreDBClusterToPointInTimeMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the new cluster belongs to.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>Used as a response element for queries on virtual private cloud (VPC) security group membership.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$VpcSecurityGroups' => '<p>Provides a list of virtual private cloud (VPC) security groups that the cluster belongs to.</p>', 'DBInstance$VpcSecurityGroups' => '<p>Provides a list of VPC security group elements that the instance belongs to.</p>', ], ], ],];
