<?php
// This file was auto-generated from sdk-root/src/data/ec2/2016-11-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elastic Compute Cloud</fullname> <p>You can access the features of Amazon Elastic Compute Cloud (Amazon EC2) programmatically. For more information, see the <a href="https://docs.aws.amazon.com/ec2/latest/devguide">Amazon EC2 Developer Guide</a>.</p>', 'operations' => [ 'AcceptAddressTransfer' => '<p>Accepts an Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept">Accept a transferred Elastic IP address</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AcceptReservedInstancesExchangeQuote' => '<p>Accepts the Convertible Reserved Instance exchange quote described in the <a>GetReservedInstancesExchangeQuote</a> call.</p>', 'AcceptTransitGatewayMulticastDomainAssociations' => '<p>Accepts a request to associate subnets with a transit gateway multicast domain.</p>', 'AcceptTransitGatewayPeeringAttachment' => '<p>Accepts a transit gateway peering attachment request. The peering attachment must be in the <code>pendingAcceptance</code> state.</p>', 'AcceptTransitGatewayVpcAttachment' => '<p>Accepts a request to attach a VPC to a transit gateway.</p> <p>The VPC attachment must be in the <code>pendingAcceptance</code> state. Use <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.</p>', 'AcceptVpcEndpointConnections' => '<p>Accepts connection requests to your VPC endpoint service.</p>', 'AcceptVpcPeeringConnection' => '<p>Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.</p> <p>For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of the accepter VPC.</p>', 'AdvertiseByoipCidr' => '<p>Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).</p> <p>You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p> <p>We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through Amazon Web Services.</p> <p>It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of BGP propagation delays.</p> <p>To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.</p>', 'AllocateAddress' => '<p>Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account.</p> <p>You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic IP address that you released, specify it in this operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).</p>', 'AllocateHosts' => '<p>Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.</p>', 'AllocateIpamPoolCidr' => '<p>Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations.</p> <p>In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.</p> <note> <p>This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other allocations from the same pool.</p> </note>', 'ApplySecurityGroupsToClientVpnTargetNetwork' => '<p>Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.</p>', 'AssignIpv6Addresses' => '<p>Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet\'s IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type.</p> <p>You must specify either the IPv6 addresses or the IPv6 address count in the request. </p> <p>You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network interfaces</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'AssignPrivateIpAddresses' => '<p>Assigns one or more secondary private IP addresses to the specified network interface.</p> <p>You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet\'s CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For more information about Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved.</p> <p>Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the remapping is complete.</p> <p>You must specify either the IP addresses or the IP address count in the request.</p> <p>You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network interfaces</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'AssignPrivateNatGatewayAddress' => '<p>Assigns private IPv4 addresses to a private NAT gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with NAT gateways</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AssociateAddress' => '<p>Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account.</p> <p>If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account.</p> <p>[Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface. </p> <p>You cannot associate an Elastic IP address with an interface in a different network border group.</p> <important> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2 Pricing</a>.</p> </important>', 'AssociateClientVpnTargetNetwork' => '<p>Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.</p> <p>If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that\'s in a different VPC, you must first modify the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that\'s associated with it.</p>', 'AssociateDhcpOptions' => '<p>Associates a set of DHCP options (that you\'ve previously created) with the specified VPC, or associates no DHCP options with the VPC.</p> <p>After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don\'t need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AssociateEnclaveCertificateIamRole' => '<p>Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p> <p>When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.</p> <p>To enable the IAM role to access the Amazon S3 object, you must grant it permission to call <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>', 'AssociateIamInstanceProfile' => '<p>Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.</p>', 'AssociateInstanceEventWindow' => '<p>Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'AssociateIpamByoasn' => '<p>Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p> <p>After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>. You can advertise the CIDR with <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.</p>', 'AssociateIpamResourceDiscovery' => '<p>Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'AssociateNatGatewayAddress' => '<p>Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with NAT gateways</a> in the <i>Amazon VPC User Guide</i>.</p> <p>By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by requesting a quota adjustment. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address quotas</a> in the <i>Amazon VPC User Guide</i>.</p> <important> <p>When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it\'s not the same, the EIP will fail to associate. You can see the network border group for the subnet\'s AZ by viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the EIP address. For more information about network border groups and EIPs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP address</a> in the <i>Amazon VPC User Guide</i>. </p> </important>', 'AssociateRouteTable' => '<p>Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AssociateSubnetCidrBlock' => '<p>Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.</p>', 'AssociateTransitGatewayMulticastDomain' => '<p>Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.</p> <p>The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments</a> to see the state of the attachment.</p>', 'AssociateTransitGatewayPolicyTable' => '<p>Associates the specified transit gateway attachment with a transit gateway policy table.</p>', 'AssociateTransitGatewayRouteTable' => '<p>Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.</p>', 'AssociateTrunkInterface' => '<p>Associates a branch network interface with a trunk network interface.</p> <p>Before you create the association, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">CreateNetworkInterface</a> command and set the interface type to <code>trunk</code>. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.</p>', 'AssociateVpcCidrBlock' => '<p>Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).</p> <p>You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.</p> <p>For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and subnets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AttachClassicLinkVpc' => '<note> <p>This action is deprecated.</p> </note> <p>Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that\'s in the <code>running</code> state. An instance is automatically unlinked from a VPC when it\'s stopped - you can link it to the VPC again when you restart it.</p> <p>After you\'ve linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.</p> <p>Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.</p>', 'AttachInternetGateway' => '<p>Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AttachNetworkInterface' => '<p>Attaches a network interface to an instance.</p>', 'AttachVerifiedAccessTrustProvider' => '<p>Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services Verified Access instance.</p>', 'AttachVolume' => '<p>Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.</p> <p>Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p> <p>After you attach an EBS volume, you must make it available. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for use</a>.</p> <p>If a volume has an Amazon Web Services Marketplace product code:</p> <ul> <li> <p>The volume can be attached only to a stopped instance.</p> </li> <li> <p>Amazon Web Services Marketplace product codes are copied from the volume to the instance.</p> </li> <li> <p>You must be subscribed to the product.</p> </li> <li> <p>The instance type and operating system of the instance must support the product. For example, you can\'t detach a volume from a Windows instance and attach it to a Linux instance.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to an instance</a> in the <i>Amazon EBS User Guide</i>.</p>', 'AttachVpnGateway' => '<p>Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'AuthorizeClientVpnIngress' => '<p>Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in Amazon Web Services or on-premises networks.</p>', 'AuthorizeSecurityGroupEgress' => '<p>Adds the specified outbound (egress) rules to a security group.</p> <p>An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address ranges specified by a prefix list, or the instances that are associated with a source security group. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.</p> <p>You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type and code.</p> <p>Rule changes are propagated to instances associated with the security group as quickly as possible. However, a small delay might occur.</p> <p>For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For information about security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the <i>Amazon VPC User Guide</i>.</p>', 'AuthorizeSecurityGroupIngress' => '<p>Adds the specified inbound (ingress) rules to a security group.</p> <p>An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP address ranges that are specified by a prefix list, or the instances that are associated with a destination security group. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.</p> <p>You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6 type and code.</p> <p>Rule changes are propagated to instances associated with the security group as quickly as possible. However, a small delay might occur.</p> <p>For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information about security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the <i>Amazon VPC User Guide</i>.</p>', 'BundleInstance' => '<p>Bundles an Amazon instance store-backed Windows instance.</p> <p>During bundling, only the root device volume (C:\\) is bundled. Data on other instance store volumes is not preserved.</p> <note> <p>This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.</p> </note>', 'CancelBundleTask' => '<p>Cancels a bundling operation for an instance store-backed Windows instance.</p>', 'CancelCapacityReservation' => '<p>Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation\'s state to <code>cancelled</code>.</p> <p>Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.</p>', 'CancelCapacityReservationFleets' => '<p>Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following happens:</p> <ul> <li> <p>The Capacity Reservation Fleet\'s status changes to <code>cancelled</code>.</p> </li> <li> <p>The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations at the time of cancelling the Fleet continue to run in shared capacity.</p> </li> <li> <p>The Fleet stops creating new Capacity Reservations.</p> </li> </ul>', 'CancelConversionTask' => '<p>Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p>', 'CancelExportTask' => '<p>Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.</p>', 'CancelImageLaunchPermission' => '<p>Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CancelImportTask' => '<p>Cancels an in-process import virtual machine or import snapshot task.</p>', 'CancelReservedInstancesListing' => '<p>Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CancelSpotFleetRequests' => '<p>Cancels the specified Spot Fleet requests.</p> <p>After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.</p> <p>You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you terminate them manually.</p> <p class="title"> <b>Restrictions</b> </p> <ul> <li> <p>You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.</p> </li> </ul>', 'CancelSpotInstanceRequests' => '<p>Cancels one or more Spot Instance requests.</p> <important> <p>Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.</p> </important>', 'ConfirmProductInstance' => '<p>Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user\'s instance is eligible for support.</p>', 'CopyFpgaImage' => '<p>Copies the specified Amazon FPGA Image (AFI) to the current Region.</p>', 'CopyImage' => '<p>Initiates an AMI copy operation. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can\'t copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask</a>.</p> <p>When you copy an AMI from one Region to another, the destination Region is the current Region.</p> <p>When you copy an AMI from a Region to an Outpost, specify the ARN of the Outpost as the destination. Backing snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region or the key that you specify. Outposts do not support unencrypted snapshots.</p> <p>For information about the prerequisites when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CopySnapshot' => '<p>Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the same Region, from one Region to another, or from a Region to an Outpost. You can\'t copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p> <p>You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).</p> <p>When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default KMS key; however, you can specify a different KMS key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the snapshot.</p> <p>Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more information, <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.</p> <p>Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any purpose.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>', 'CreateCapacityReservation' => '<p>Creates a new Capacity Reservation with the specified attributes.</p> <p>Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes.</p> <p>Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateCapacityReservationBySplitting' => '<p> Create a new Capacity Reservation by splitting the available capacity of the source Capacity Reservation. The new Capacity Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity Reservation must be <code>active</code> and owned by your Amazon Web Services account. </p>', 'CreateCapacityReservationFleet' => '<p>Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity Reservation Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateCarrierGateway' => '<p>Creates a carrier gateway. For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.</p>', 'CreateClientVpnEndpoint' => '<p>Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.</p>', 'CreateClientVpnRoute' => '<p>Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.</p>', 'CreateCoipCidr' => '<p> Creates a range of customer-owned IP addresses. </p>', 'CreateCoipPool' => '<p> Creates a pool of customer-owned IP (CoIP) addresses. </p>', 'CreateCustomerGateway' => '<p>Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s external interface. The IP address must be static and can be behind a device performing network address translation (NAT).</p> <p>For devices that use Border Gateway Protocol (BGP), you can also provide the device\'s BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don\'t have an ASN already, you can use a private ASN. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p> <p>To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. An identical request returns information about the existing customer gateway; it doesn\'t create a new customer gateway.</p>', 'CreateDefaultSubnet' => '<p>Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Create a default subnet</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateDefaultVpc' => '<p>Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC User Guide</i>. You cannot specify the components of the default VPC yourself.</p> <p>If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC per Region.</p>', 'CreateDhcpOptions' => '<p>Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP options.</p> <p>The following are the individual DHCP options you can specify. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the <i>Amazon VPC User Guide</i>.</p> <ul> <li> <p> <code>domain-name</code> - If you\'re using AmazonProvidedDNS in <code>us-east-1</code>, specify <code>ec2.internal</code>. If you\'re using AmazonProvidedDNS in any other Region, specify <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete unqualified DNS hostnames.</p> <p>Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option set is associated with a VPC that has instances running operating systems that treat the value as a single domain, specify only one domain name.</p> </li> <li> <p> <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS server.</p> </li> <li> <p> <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4 addresses and four IPv6 addresses).</p> </li> <li> <p> <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.</p> </li> <li> <p> <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2. Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a href="https://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> </li> <li> <p> <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.</p> </li> </ul>', 'CreateEgressOnlyInternetGateway' => '<p>[IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.</p>', 'CreateFleet' => '<p>Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances. Instances are launched immediately if there is available capacity.</p> <p>A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateFlowLogs' => '<p>Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC. </p> <p>Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <i>Amazon VPC User Guide</i>.</p> <p>When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateFpgaImage' => '<p>Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).</p> <p>The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.</p> <p>An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the <a href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.</p>', 'CreateImage' => '<p>Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.</p> <p>If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateInstanceConnectEndpoint' => '<p>Creates an EC2 Instance Connect Endpoint.</p> <p>An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a public IPv4 address. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html">Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateInstanceEventWindow' => '<p>Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.</p> <p>You can define either a set of time ranges or a cron expression when creating the event window, but not both. All event window times are in UTC.</p> <p>You can create up to 200 event windows per Amazon Web Services Region.</p> <p>When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that the event window can be used, you must associate one or more targets with it by using the <a>AssociateInstanceEventWindow</a> API.</p> <important> <p>Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.</p> <p>Event windows are <i>not</i> applicable for:</p> <ul> <li> <p>Expedited scheduled events and network maintenance events. </p> </li> <li> <p>Unscheduled maintenance such as AutoRecovery and unplanned reboots.</p> </li> </ul> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateInstanceExportTask' => '<p>Exports a running or stopped instance to an Amazon S3 bucket.</p> <p>For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats, and known limitations for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'CreateInternetGateway' => '<p>Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using <a>AttachInternetGateway</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateIpam' => '<p>Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'CreateIpamExternalResourceVerificationToken' => '<p>Create a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP). </p>', 'CreateIpamPool' => '<p>Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'CreateIpamResourceDiscovery' => '<p>Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'CreateIpamScope' => '<p>Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a scope</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'CreateKeyPair' => '<p>Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error.</p> <p>The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using <a>ImportKeyPair</a>.</p> <p>You can have up to 5,000 key pairs per Amazon Web Services Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchTemplate' => '<p>Creates a launch template.</p> <p>A launch template contains the parameters to launch an instance. When you launch an instance using <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a launch template</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template">Create a launch template from an existing launch template</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateLaunchTemplateVersion' => '<p>Creates a new version of a launch template. You must specify an existing launch template, either by name or ID. You can determine whether the new version inherits parameters from a source version, and add or overwrite parameters as needed.</p> <p>Launch template versions are numbered in the order in which they are created. You can\'t specify, change, or replace the numbering of launch template versions.</p> <p>Launch templates are immutable; after you create a launch template, you can\'t modify it. Instead, you can create a new version of the launch template that includes the changes that you require.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Modify a launch template (manage launch template versions)</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateLocalGatewayRoute' => '<p>Creates a static route for the specified local gateway route table. You must specify one of the following targets: </p> <ul> <li> <p> <code>LocalGatewayVirtualInterfaceGroupId</code> </p> </li> <li> <p> <code>NetworkInterfaceId</code> </p> </li> </ul>', 'CreateLocalGatewayRouteTable' => '<p> Creates a local gateway route table. </p>', 'CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation' => '<p> Creates a local gateway route table virtual interface group association. </p>', 'CreateLocalGatewayRouteTableVpcAssociation' => '<p>Associates the specified VPC with the specified local gateway route table.</p>', 'CreateManagedPrefixList' => '<p>Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.</p>', 'CreateNatGateway' => '<p>Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway.</p> <p>With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that instances in a private subnet can connect to the internet.</p> <p>With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT gateways</a> in the <i>Amazon VPC User Guide</i>.</p> <important> <p>When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it\'s not the same, the NAT gateway will fail to launch. You can see the network border group for the subnet\'s AZ by viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the EIP address. For more information about network border groups and EIPs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP address</a> in the <i>Amazon VPC User Guide</i>. </p> </important>', 'CreateNetworkAcl' => '<p>Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateNetworkAclEntry' => '<p>Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.</p> <p>We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.</p> <p>After you add an entry, you can\'t modify it; you must either replace it, or create an entry and delete the old one.</p> <p>For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateNetworkInsightsAccessScope' => '<p>Creates a Network Access Scope.</p> <p>Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that their networks on Amazon Web Services conform to their network security and governance objectives. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web Services Network Access Analyzer Guide</a>.</p>', 'CreateNetworkInsightsPath' => '<p>Creates a path to analyze for reachability.</p> <p>Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual private cloud (VPC). For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.</p>', 'CreateNetworkInterface' => '<p>Creates a network interface in the specified subnet.</p> <p>The number of IP addresses you can assign to a network interface varies by instance type.</p> <p>For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateNetworkInterfacePermission' => '<p>Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account.</p> <p>You can grant permission to a single Amazon Web Services account only, and only one account at a time.</p>', 'CreatePlacementGroup' => '<p>Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group. </p> <p>A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances on distinct hardware. A <code>partition</code> placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreatePublicIpv4Pool' => '<p>Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html">DescribePublicIpv4Pools</a>.</p>', 'CreateReplaceRootVolumeTask' => '<p>Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the original root volume\'s launch state, that is restored to a specific snapshot taken from the original root volume, or that is restored from an AMI that has the same key characteristics as that of the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace a root volume</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateReservedInstancesListing' => '<p>Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the <a>DescribeReservedInstances</a> operation.</p> <note> <p>Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.</p> </note> <p>The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateRestoreImageTask' => '<p>Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask</a>.</p> <p>To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateRoute' => '<p>Creates a route in a route table within a VPC.</p> <p>You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list.</p> <p>When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:</p> <ul> <li> <p> <code>192.0.2.0/24</code> (goes to some target A)</p> </li> <li> <p> <code>192.0.2.0/28</code> (goes to some target B)</p> </li> </ul> <p>Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic.</p> <p>For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateRouteTable' => '<p>Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateSecurityGroup' => '<p>Creates a security group.</p> <p>A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>When you create a security group, you specify a friendly name of your choice. You can\'t have two security groups for the same VPC with the same name.</p> <p>You have a default security group for use in your VPC. If you don\'t specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.</p> <p>You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>, <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.</p> <p>For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.</p>', 'CreateSnapshot' => '<p>Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.</p> <p>You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.</p> <p>When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source volume are propagated to the snapshot.</p> <p>You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is <code>pending</code>.</p> <p>When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the instance before taking the snapshot.</p> <p>Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected.</p> <p>You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/what-is-ebs.html">Amazon EBS</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'CreateSnapshots' => '<p>Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance.</p> <p>You can include all of the volumes currently attached to the instance, or you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set.</p> <p>You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance, or in the Region for that Outpost.</p>', 'CreateSpotDatafeedSubscription' => '<p>Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateStoreImageTask' => '<p>Stores an AMI as a single object in an Amazon S3 bucket.</p> <p>To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateSubnet' => '<p>Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet, specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.</p> <p>A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet, you can\'t change its CIDR block.</p> <p>The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet\'s CIDR block. They\'re not available for your use.</p> <p>If you\'ve associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when you create it. </p> <p>If you add more than one subnet to a VPC, they\'re set up in a star topology with a logical router in the middle.</p> <p>When you stop an instance in a subnet, it retains its private IPv4 address. It\'s therefore possible to have a subnet with no running instances (they\'re all stopped), but no remaining IP addresses available.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'CreateSubnetCidrReservation' => '<p>Creates a subnet CIDR reservation. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a> in the <i>Amazon VPC User Guide</i> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assign prefixes to network interfaces</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateTags' => '<p>Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control users\' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateTrafficMirrorFilter' => '<p>Creates a Traffic Mirror filter.</p> <p>A Traffic Mirror filter is a set of rules that defines the traffic to mirror.</p> <p>By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.</p>', 'CreateTrafficMirrorFilterRule' => '<p>Creates a Traffic Mirror filter rule.</p> <p>A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.</p> <p>You need the Traffic Mirror filter ID when you create the rule.</p>', 'CreateTrafficMirrorSession' => '<p>Creates a Traffic Mirror session.</p> <p>A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP traffic.</p> <p>The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway. </p> <p>By default, no traffic is mirrored. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm">CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.</p>', 'CreateTrafficMirrorTarget' => '<p>Creates a target for your Traffic Mirror session.</p> <p>A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a transit gateway.</p> <p>A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.</p> <p>To use the target in a Traffic Mirror session, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm">CreateTrafficMirrorSession</a>.</p>', 'CreateTransitGateway' => '<p>Creates a transit gateway.</p> <p>You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the transit gateway.</p> <p>To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.</p> <p>To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.</p> <p>When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table and the default propagation route table. You can use <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table. You can use <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a> to associate a resource attachment with a transit gateway route table.</p>', 'CreateTransitGatewayConnect' => '<p>Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.</p> <p>A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.</p>', 'CreateTransitGatewayConnectPeer' => '<p>Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an appliance.</p> <p>The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.</p>', 'CreateTransitGatewayMulticastDomain' => '<p>Creates a multicast domain using the specified transit gateway.</p> <p>The transit gateway must be in the available state before you create a domain. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html">DescribeTransitGateways</a> to see the state of transit gateway.</p>', 'CreateTransitGatewayPeeringAttachment' => '<p>Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services account.</p> <p>After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment request.</p>', 'CreateTransitGatewayPolicyTable' => '<p>Creates a transit gateway policy table.</p>', 'CreateTransitGatewayPrefixListReference' => '<p>Creates a reference (route) to a prefix list in a specified transit gateway route table.</p>', 'CreateTransitGatewayRoute' => '<p>Creates a static route for the specified transit gateway route table.</p>', 'CreateTransitGatewayRouteTable' => '<p>Creates a route table for the specified transit gateway.</p>', 'CreateTransitGatewayRouteTableAnnouncement' => '<p>Advertises a new transit gateway route table.</p>', 'CreateTransitGatewayVpcAttachment' => '<p>Attaches the specified VPC to the specified transit gateway.</p> <p>If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default propagation route table.</p> <p>To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.</p>', 'CreateVerifiedAccessEndpoint' => '<p>An Amazon Web Services Verified Access endpoint is where you define your application along with an optional endpoint-level access policy.</p>', 'CreateVerifiedAccessGroup' => '<p>An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints who\'s associated applications have similar security requirements. Each instance within a Verified Access group shares an Verified Access policy. For example, you can group all Verified Access instances associated with "sales" applications together and use one common Verified Access policy.</p>', 'CreateVerifiedAccessInstance' => '<p>An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and grants access only when your security requirements are met.</p>', 'CreateVerifiedAccessTrustProvider' => '<p>A trust provider is a third-party entity that creates, maintains, and manages identity information for users and devices. When an application request is made, the identity information sent by the trust provider is evaluated by Verified Access before allowing or denying the application request.</p>', 'CreateVolume' => '<p>Creates an EBS volume that can be attached to an instance in the same Availability Zone.</p> <p>You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume.</p> <p>You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p> <p>You can tag your volumes during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a> in the <i>Amazon EBS User Guide</i>.</p>', 'CreateVpc' => '<p>Creates a VPC with the specified CIDR blocks. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and subnets</a> in the <i>Amazon VPC User Guide</i>.</p> <p>You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon\'s pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).</p> <p>By default, each instance that you launch in the VPC has the default DHCP options, which include only a default DNS server that we provide (AmazonProvidedDNS). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the <i>Amazon VPC User Guide</i>.</p> <p>You can specify the instance tenancy value for the VPC when you create it. You can\'t change this value for the VPC after you create it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateVpcEndpoint' => '<p>Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.</p>', 'CreateVpcEndpointConnectionNotification' => '<p>Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Creating an Amazon SNS topic</a> in the <i>Amazon SNS Developer Guide</i>.</p> <p>You can create a connection notification for interface endpoints only.</p>', 'CreateVpcEndpointServiceConfiguration' => '<p>Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles) can connect.</p> <p>Before you create an endpoint service, you must create one of the following for your service:</p> <ul> <li> <p>A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service consumers connect to your service using an interface endpoint.</p> </li> <li> <p>A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service consumers connect to your service using a Gateway Load Balancer endpoint.</p> </li> </ul> <p>If you set the private DNS name, you must prove that you own the private DNS domain name.</p> <p>For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink Guide</a>.</p>', 'CreateVpcPeeringConnection' => '<p>Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.</p> <note> <p>Limitations and rules apply to a VPC peering connection. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">VPC peering limitations</a> in the <i>VPC Peering Guide</i>.</p> </note> <p>The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering connection request expires after 7 days, after which it cannot be accepted or rejected.</p> <p>If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering connection has a status of <code>failed</code>.</p>', 'CreateVpnConnection' => '<p>Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is <code>ipsec.1</code>.</p> <p>The response includes information that you need to give to your network administrator to configure your customer gateway.</p> <important> <p>We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway device.</p> </important> <p>If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'CreateVpnConnectionRoute' => '<p>Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'CreateVpnGateway' => '<p>Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'DeleteCarrierGateway' => '<p>Deletes a carrier gateway.</p> <important> <p>If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route. For information about how to delete a route, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.</p> </important>', 'DeleteClientVpnEndpoint' => '<p>Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.</p>', 'DeleteClientVpnRoute' => '<p>Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.</p>', 'DeleteCoipCidr' => '<p> Deletes a range of customer-owned IP addresses. </p>', 'DeleteCoipPool' => '<p>Deletes a pool of customer-owned IP (CoIP) addresses. </p>', 'DeleteCustomerGateway' => '<p>Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.</p>', 'DeleteDhcpOptions' => '<p>Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.</p>', 'DeleteEgressOnlyInternetGateway' => '<p>Deletes an egress-only internet gateway.</p>', 'DeleteFleets' => '<p>Deletes the specified EC2 Fleets.</p> <p>After you delete an EC2 Fleet, it launches no new instances.</p> <p>You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate them manually.</p> <p>For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000 instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted <code>instant</code> fleet with running instances is not supported.</p> <p class="title"> <b>Restrictions</b> </p> <ul> <li> <p>You can delete up to 25 fleets of type <code>instant</code> in a single request.</p> </li> <li> <p>You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.</p> </li> <li> <p>You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as specified above.</p> </li> <li> <p>If you exceed the specified number of fleets to delete, no fleets are deleted.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DeleteFlowLogs' => '<p>Deletes one or more flow logs.</p>', 'DeleteFpgaImage' => '<p>Deletes the specified Amazon FPGA Image (AFI).</p>', 'DeleteInstanceConnectEndpoint' => '<p>Deletes the specified EC2 Instance Connect Endpoint.</p>', 'DeleteInstanceEventWindow' => '<p>Deletes the specified event window.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DeleteInternetGateway' => '<p>Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.</p>', 'DeleteIpam' => '<p>Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'DeleteIpamExternalResourceVerificationToken' => '<p>Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP). </p>', 'DeleteIpamPool' => '<p>Delete an IPAM pool.</p> <note> <p>You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html">DeprovisionIpamPoolCidr</a>.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a pool</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'DeleteIpamResourceDiscovery' => '<p>Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'DeleteIpamScope' => '<p>Delete the scope for an IPAM. You cannot delete the default scopes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a scope</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'DeleteKeyPair' => '<p>Deletes the specified key pair, by removing the public key from Amazon EC2.</p>', 'DeleteLaunchTemplate' => '<p>Deletes a launch template. Deleting a launch template deletes all of its versions.</p>', 'DeleteLaunchTemplateVersions' => '<p>Deletes one or more versions of a launch template.</p> <p>You can\'t delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using <a>DeleteLaunchTemplate</a>.</p> <p>You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version">Delete a launch template version</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DeleteLocalGatewayRoute' => '<p>Deletes the specified route from the specified local gateway route table.</p>', 'DeleteLocalGatewayRouteTable' => '<p> Deletes a local gateway route table. </p>', 'DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation' => '<p> Deletes a local gateway route table virtual interface group association. </p>', 'DeleteLocalGatewayRouteTableVpcAssociation' => '<p>Deletes the specified association between a VPC and local gateway route table.</p>', 'DeleteManagedPrefixList' => '<p>Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.</p>', 'DeleteNatGateway' => '<p>Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.</p>', 'DeleteNetworkAcl' => '<p>Deletes the specified network ACL. You can\'t delete the ACL if it\'s associated with any subnets. You can\'t delete the default network ACL.</p>', 'DeleteNetworkAclEntry' => '<p>Deletes the specified ingress or egress entry (rule) from the specified network ACL.</p>', 'DeleteNetworkInsightsAccessScope' => '<p>Deletes the specified Network Access Scope.</p>', 'DeleteNetworkInsightsAccessScopeAnalysis' => '<p>Deletes the specified Network Access Scope analysis.</p>', 'DeleteNetworkInsightsAnalysis' => '<p>Deletes the specified network insights analysis.</p>', 'DeleteNetworkInsightsPath' => '<p>Deletes the specified path.</p>', 'DeleteNetworkInterface' => '<p>Deletes the specified network interface. You must detach the network interface before you can delete it.</p>', 'DeleteNetworkInterfacePermission' => '<p>Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you\'re removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.</p>', 'DeletePlacementGroup' => '<p>Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DeletePublicIpv4Pool' => '<p>Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.</p>', 'DeleteQueuedReservedInstances' => '<p>Deletes the queued purchases for the specified Reserved Instances.</p>', 'DeleteRoute' => '<p>Deletes the specified route from the specified route table.</p>', 'DeleteRouteTable' => '<p>Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can\'t delete the main route table.</p>', 'DeleteSecurityGroup' => '<p>Deletes a security group.</p> <p>If you attempt to delete a security group that is associated with an instance or network interface or is referenced by another security group in the same VPC, the operation fails with <code>DependencyViolation</code>.</p>', 'DeleteSnapshot' => '<p>Deletes the specified snapshot.</p> <p>When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the volume.</p> <p>You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first de-register the AMI before you can delete the snapshot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DeleteSpotDatafeedSubscription' => '<p>Deletes the data feed for Spot Instances.</p>', 'DeleteSubnet' => '<p>Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.</p>', 'DeleteSubnetCidrReservation' => '<p>Deletes a subnet CIDR reservation.</p>', 'DeleteTags' => '<p>Deletes the specified set of tags from the specified set of resources.</p> <p>To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteTrafficMirrorFilter' => '<p>Deletes the specified Traffic Mirror filter.</p> <p>You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.</p>', 'DeleteTrafficMirrorFilterRule' => '<p>Deletes the specified Traffic Mirror rule.</p>', 'DeleteTrafficMirrorSession' => '<p>Deletes the specified Traffic Mirror session.</p>', 'DeleteTrafficMirrorTarget' => '<p>Deletes the specified Traffic Mirror target.</p> <p>You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.</p>', 'DeleteTransitGateway' => '<p>Deletes the specified transit gateway.</p>', 'DeleteTransitGatewayConnect' => '<p>Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.</p>', 'DeleteTransitGatewayConnectPeer' => '<p>Deletes the specified Connect peer.</p>', 'DeleteTransitGatewayMulticastDomain' => '<p>Deletes the specified transit gateway multicast domain.</p>', 'DeleteTransitGatewayPeeringAttachment' => '<p>Deletes a transit gateway peering attachment.</p>', 'DeleteTransitGatewayPolicyTable' => '<p>Deletes the specified transit gateway policy table.</p>', 'DeleteTransitGatewayPrefixListReference' => '<p>Deletes a reference (route) to a prefix list in a specified transit gateway route table.</p>', 'DeleteTransitGatewayRoute' => '<p>Deletes the specified route from the specified transit gateway route table.</p>', 'DeleteTransitGatewayRouteTable' => '<p>Deletes the specified transit gateway route table. If there are any route tables associated with the transit gateway route table, you must first run <a>DisassociateRouteTable</a> before you can delete the transit gateway route table. This removes any route tables associated with the transit gateway route table.</p>', 'DeleteTransitGatewayRouteTableAnnouncement' => '<p>Advertises to the transit gateway that a transit gateway route table is deleted.</p>', 'DeleteTransitGatewayVpcAttachment' => '<p>Deletes the specified VPC attachment.</p>', 'DeleteVerifiedAccessEndpoint' => '<p>Delete an Amazon Web Services Verified Access endpoint.</p>', 'DeleteVerifiedAccessGroup' => '<p>Delete an Amazon Web Services Verified Access group.</p>', 'DeleteVerifiedAccessInstance' => '<p>Delete an Amazon Web Services Verified Access instance.</p>', 'DeleteVerifiedAccessTrustProvider' => '<p>Delete an Amazon Web Services Verified Access trust provider.</p>', 'DeleteVolume' => '<p>Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an instance).</p> <p>The volume can remain in the <code>deleting</code> state for several minutes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DeleteVpc' => '<p>Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on. When you delete the VPC, it deletes the VPC\'s default security group, network ACL, and route table.</p>', 'DeleteVpcEndpointConnectionNotifications' => '<p>Deletes the specified VPC endpoint connection notifications.</p>', 'DeleteVpcEndpointServiceConfigurations' => '<p>Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint connections that are attached to the service.</p>', 'DeleteVpcEndpoints' => '<p>Deletes the specified VPC endpoints.</p> <p>When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.</p> <p>When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.</p> <p>When you delete an interface endpoint, we delete its endpoint network interfaces.</p>', 'DeleteVpcPeeringConnection' => '<p>Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it\'s in the <code>active</code> state. The owner of the requester VPC can delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering connection that\'s in the <code>failed</code> or <code>rejected</code> state.</p>', 'DeleteVpnConnection' => '<p>Deletes the specified VPN connection.</p> <p>If you\'re deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway device using the new configuration information returned with the new VPN connection ID.</p> <p>For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.</p>', 'DeleteVpnConnectionRoute' => '<p>Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p>', 'DeleteVpnGateway' => '<p>Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC. Note that you don\'t need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.</p>', 'DeprovisionByoipCidr' => '<p>Releases the specified address range that you provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.</p> <p>Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must not have any IP addresses allocated from its address range.</p>', 'DeprovisionIpamByoasn' => '<p>Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html">DisassociateIpamByoasn</a>. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p>', 'DeprovisionIpamPoolCidr' => '<p>Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'DeprovisionPublicIpv4PoolCidr' => '<p>Deprovision a CIDR from a public IPv4 pool.</p>', 'DeregisterImage' => '<p>Deregisters the specified AMI. After you deregister an AMI, it can\'t be used to launch new instances.</p> <p>If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for the specified retention period. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>When you deregister an AMI, it doesn\'t affect any instances that you\'ve already launched from the AMI. You\'ll continue to incur usage costs for those instances until you terminate them.</p> <p>When you deregister an Amazon EBS-backed AMI, it doesn\'t affect the snapshot that was created for the root volume of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn\'t affect the files that you uploaded to Amazon S3 when you created the AMI.</p>', 'DeregisterInstanceEventNotificationAttributes' => '<p>Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.</p>', 'DeregisterTransitGatewayMulticastGroupMembers' => '<p>Deregisters the specified members (network interfaces) from the transit gateway multicast group.</p>', 'DeregisterTransitGatewayMulticastGroupSources' => '<p>Deregisters the specified sources (network interfaces) from the transit gateway multicast group.</p>', 'DescribeAccountAttributes' => '<p>Describes attributes of your Amazon Web Services account. The following are the supported account attributes:</p> <ul> <li> <p> <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.</p> </li> <li> <p> <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your actual vCPU limit for running On-Demand Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits">On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.</p> </li> <li> <p> <code>supported-platforms</code>: This attribute is deprecated.</p> </li> <li> <p> <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.</p> </li> <li> <p> <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to a network interface.</p> </li> </ul> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeAddressTransfers' => '<p>Describes an Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <i>Amazon VPC User Guide</i>.</p> <p>When you transfer an Elastic IP address, there is a two-step handshake between the source and transfer Amazon Web Services accounts. When the source account starts the transfer, the transfer account has seven days to accept the Elastic IP address transfer. During those seven days, the source account can view the pending transfer by using this action. After seven days, the transfer expires and ownership of the Elastic IP address returns to the source account. Accepted transfers are visible to the source account for 14 days after the transfers have been accepted.</p>', 'DescribeAddresses' => '<p>Describes the specified Elastic IP addresses or all of your Elastic IP addresses.</p>', 'DescribeAddressesAttribute' => '<p>Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications</a>.</p>', 'DescribeAggregateIdFormat' => '<p>Describes the longer ID format settings for all resource types in a specific Region. This request is useful for performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character IDs).</p> <p>This request only returns information about resource types that support longer IDs.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>', 'DescribeAvailabilityZones' => '<p>Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an event impacting a zone, you can use this request to view the state and any provided messages for that zone.</p> <p>For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and zones</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeAwsNetworkPerformanceMetricSubscriptions' => '<p>Describes the current Infrastructure Performance metric subscriptions.</p>', 'DescribeBundleTasks' => '<p>Describes the specified bundle tasks or all of your bundle tasks.</p> <note> <p>Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image manifest name you provided to the bundle task.</p> </note> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeByoipCidrs' => '<p>Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.</p> <p>To describe the address pools that were created when you provisioned the address ranges, use <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.</p>', 'DescribeCapacityBlockOfferings' => '<p>Describes Capacity Block offerings available for purchase in the Amazon Web Services Region that you\'re currently using. With Capacity Blocks, you purchase a specific instance type for a period of time.</p>', 'DescribeCapacityReservationFleets' => '<p>Describes one or more Capacity Reservation Fleets.</p>', 'DescribeCapacityReservations' => '<p>Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you\'re currently using.</p>', 'DescribeCarrierGateways' => '<p>Describes one or more of your carrier gateways.</p>', 'DescribeClassicLinkInstances' => '<note> <p>This action is deprecated.</p> </note> <p>Describes your linked EC2-Classic instances. This request only returns information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information about other instances.</p>', 'DescribeClientVpnAuthorizationRules' => '<p>Describes the authorization rules for a specified Client VPN endpoint.</p>', 'DescribeClientVpnConnections' => '<p>Describes active client connections and connections that have been terminated within the last 60 minutes for the specified Client VPN endpoint.</p>', 'DescribeClientVpnEndpoints' => '<p>Describes one or more Client VPN endpoints in the account.</p>', 'DescribeClientVpnRoutes' => '<p>Describes the routes for the specified Client VPN endpoint.</p>', 'DescribeClientVpnTargetNetworks' => '<p>Describes the target networks associated with the specified Client VPN endpoint.</p>', 'DescribeCoipPools' => '<p>Describes the specified customer-owned address pools or all of your customer-owned address pools.</p>', 'DescribeConversionTasks' => '<p>Describes the specified conversion tasks or all your conversion tasks. For more information, see the <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'DescribeCustomerGateways' => '<p>Describes one or more of your VPN customer gateways.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'DescribeDhcpOptions' => '<p>Describes your DHCP option sets. The default is to describe all your DHCP option sets. Alternatively, you can specify specific DHCP option set IDs or filter the results to include only the DHCP option sets that match specific criteria.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DescribeEgressOnlyInternetGateways' => '<p>Describes your egress-only internet gateways. The default is to describe all your egress-only internet gateways. Alternatively, you can specify specific egress-only internet gateway IDs or filter the results to include only the egress-only internet gateways that match specific criteria.</p>', 'DescribeElasticGpus' => '<note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.</p> </note> <p>Describes the Elastic Graphics accelerator associated with your instances.</p>', 'DescribeExportImageTasks' => '<p>Describes the specified export image tasks or all of your export image tasks.</p>', 'DescribeExportTasks' => '<p>Describes the specified export instance tasks or all of your export instance tasks.</p>', 'DescribeFastLaunchImages' => '<p>Describe details for Windows AMIs that are configured for Windows fast launch.</p>', 'DescribeFastSnapshotRestores' => '<p>Describes the state of fast snapshot restores for your snapshots.</p>', 'DescribeFleetHistory' => '<p>Describes the events for the specified EC2 Fleet during the specified time.</p> <p>EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon EventBridge</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeFleetInstances' => '<p>Describes the running instances for the specified EC2 Fleet.</p> <note> <p>Currently, <code>DescribeFleetInstances</code> does not support fleets of type <code>instant</code>. Instead, use <code>DescribeFleets</code>, specifying the <code>instant</code> fleet ID in the request.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeFleets' => '<p>Describes the specified EC2 Fleet or all of your EC2 Fleets.</p> <important> <p>If a fleet is of type <code>instant</code>, you must specify the fleet ID in the request, otherwise the fleet does not appear in the response.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeFlowLogs' => '<p>Describes one or more flow logs.</p> <p>To view the published flow log records, you must view the log destination. For example, the CloudWatch Logs log group, the Amazon S3 bucket, or the Kinesis Data Firehose delivery stream.</p>', 'DescribeFpgaImageAttribute' => '<p>Describes the specified attribute of the specified Amazon FPGA Image (AFI).</p>', 'DescribeFpgaImages' => '<p>Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load permissions.</p>', 'DescribeHostReservationOfferings' => '<p>Describes the Dedicated Host reservations that are available to purchase.</p> <p>The results describe all of the Dedicated Host reservation offerings, including offerings that might not match the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more information about supported instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'DescribeHostReservations' => '<p>Describes reservations that are associated with Dedicated Hosts in your account.</p>', 'DescribeHosts' => '<p>Describes the specified Dedicated Hosts or all your Dedicated Hosts.</p> <p>The results describe only the Dedicated Hosts in the Region you\'re currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state <code>released</code>.</p>', 'DescribeIamInstanceProfileAssociations' => '<p>Describes your IAM instance profile associations.</p>', 'DescribeIdFormat' => '<p>Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>These settings apply to the IAM user who makes the request; they do not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all IAM users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'DescribeIdentityIdFormat' => '<p>Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>These settings apply to the principal specified in the request. They do not apply to the principal that makes the request.</p>', 'DescribeImageAttribute' => '<p>Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeImages' => '<p>Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.</p> <p>The images available to you include public images, private images that you own, and private images owned by other Amazon Web Services accounts for which you have explicit launch permissions.</p> <p>Recently deregistered images appear in the returned results for a short interval and then return empty results. After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will eventually return an error indicating that the AMI ID cannot be found.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeImportImageTasks' => '<p>Displays details about an import virtual machine or import snapshot tasks that are already created.</p>', 'DescribeImportSnapshotTasks' => '<p>Describes your import snapshot tasks.</p>', 'DescribeInstanceAttribute' => '<p>Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> | <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> | <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> | <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code> </p>', 'DescribeInstanceConnectEndpoints' => '<p>Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect Endpoints.</p>', 'DescribeInstanceCreditSpecifications' => '<p>Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are <code>standard</code> and <code>unlimited</code>.</p> <p>If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.</p> <p>If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance that is not a burstable performance instance, an error is returned.</p> <p>Recently terminated instances might appear in the returned results. This interval is usually less than one hour.</p> <p>If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected zone, the call works normally.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeInstanceEventNotificationAttributes' => '<p>Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.</p>', 'DescribeInstanceEventWindows' => '<p>Describes the specified event windows or all event windows.</p> <p>If you specify event window IDs, the output includes information for only the specified event windows. If you specify filters, the output includes information for only those event windows that meet the filter criteria. If you do not specify event windows IDs or filters, the output includes information for all event windows, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeInstanceStatus' => '<p>Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances.</p> <p>Instance status includes the following components:</p> <ul> <li> <p> <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status checks for your instances</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshoot instances with failed status checks</a> in the <i>Amazon EC2 User Guide</i>.</p> </li> <li> <p> <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled events for your instances</a> in the <i>Amazon EC2 User Guide</i>.</p> </li> <li> <p> <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon EC2 User Guide</i>.</p> </li> </ul> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeInstanceTopology' => '<p>Describes a tree-based hierarchy that represents the physical host placement of your EC2 instances within an Availability Zone or Local Zone. You can use this information to determine the relative proximity of your EC2 instances within the Amazon Web Services network to support your tightly coupled workloads.</p> <p class="title"> <b>Limitations</b> </p> <ul> <li> <p>Supported zones</p> <ul> <li> <p>Availability Zone</p> </li> <li> <p>Local Zone</p> </li> </ul> </li> <li> <p>Supported instance types</p> <ul> <li> <p> <code>hpc6a.48xlarge</code> | <code>hpc6id.32xlarge</code> | <code>hpc7a.12xlarge</code> | <code>hpc7a.24xlarge</code> | <code>hpc7a.48xlarge</code> | <code>hpc7a.96xlarge</code> | <code>hpc7g.4xlarge</code> | <code>hpc7g.8xlarge</code> | <code>hpc7g.16xlarge</code> </p> </li> <li> <p> <code>p3dn.24xlarge</code> | <code>p4d.24xlarge</code> | <code>p4de.24xlarge</code> | <code>p5.48xlarge</code> </p> </li> <li> <p> <code>trn1.2xlarge</code> | <code>trn1.32xlarge</code> | <code>trn1n.32xlarge</code> </p> </li> </ul> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-topology.html">Amazon EC2 instance topology</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeInstanceTypeOfferings' => '<p>Lists the instance types that are offered for the specified location. If no location is specified, the default is to list the instance types that are offered in the current Region.</p>', 'DescribeInstanceTypes' => '<p>Describes the specified instance types. By default, all instance types for the current Region are described. Alternatively, you can filter the results.</p>', 'DescribeInstances' => '<p>Describes the specified instances or all instances.</p> <p>If you specify instance IDs, the output includes information for only the specified instances. If you specify filters, the output includes information for only those instances that meet the filter criteria. If you do not specify instance IDs or filters, the output includes information for all instances, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully.</p> <p>If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in the output.</p> <p>Recently terminated instances might appear in the returned results. This interval is usually less than one hour.</p> <p>If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works normally.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeInternetGateways' => '<p>Describes your internet gateways. The default is to describe all your internet gateways. Alternatively, you can specify specific internet gateway IDs or filter the results to include only the internet gateways that match specific criteria.</p>', 'DescribeIpamByoasn' => '<p>Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP CIDRs with which they are associated. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p>', 'DescribeIpamExternalResourceVerificationTokens' => '<p>Describe verification tokens. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP). </p>', 'DescribeIpamPools' => '<p>Get information about your IPAM pools.</p>', 'DescribeIpamResourceDiscoveries' => '<p>Describes IPAM resource discoveries. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'DescribeIpamResourceDiscoveryAssociations' => '<p>Describes resource discovery association with an Amazon VPC IPAM. An associated resource discovery is a resource discovery that has been associated with an IPAM..</p>', 'DescribeIpamScopes' => '<p>Get information about your IPAM scopes.</p>', 'DescribeIpams' => '<p>Get information about your IPAM pools.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'DescribeIpv6Pools' => '<p>Describes your IPv6 address pools.</p>', 'DescribeKeyPairs' => '<p>Describes the specified key pairs or all of your key pairs.</p> <p>For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeLaunchTemplateVersions' => '<p>Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.</p>', 'DescribeLaunchTemplates' => '<p>Describes one or more launch templates.</p>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations' => '<p>Describes the associations between virtual interface groups and local gateway route tables.</p>', 'DescribeLocalGatewayRouteTableVpcAssociations' => '<p>Describes the specified associations between VPCs and local gateway route tables.</p>', 'DescribeLocalGatewayRouteTables' => '<p>Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.</p>', 'DescribeLocalGatewayVirtualInterfaceGroups' => '<p>Describes the specified local gateway virtual interface groups.</p>', 'DescribeLocalGatewayVirtualInterfaces' => '<p>Describes the specified local gateway virtual interfaces.</p>', 'DescribeLocalGateways' => '<p>Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter the results.</p>', 'DescribeLockedSnapshots' => '<p>Describes the lock status for a snapshot.</p>', 'DescribeMacHosts' => '<p>Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated Hosts.</p>', 'DescribeManagedPrefixLists' => '<p>Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.</p> <p>To view the entries for your prefix list, use <a>GetManagedPrefixListEntries</a>.</p>', 'DescribeMovingAddresses' => '<note> <p>This action is deprecated.</p> </note> <p>Describes your Elastic IP addresses that are being moved from or being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.</p>', 'DescribeNatGateways' => '<p>Describes your NAT gateways. The default is to describe all your NAT gateways. Alternatively, you can specify specific NAT gateway IDs or filter the results to include only the NAT gateways that match specific criteria.</p>', 'DescribeNetworkAcls' => '<p>Describes your network ACLs. The default is to describe all your network ACLs. Alternatively, you can specify specific network ACL IDs or filter the results to include only the network ACLs that match specific criteria.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DescribeNetworkInsightsAccessScopeAnalyses' => '<p>Describes the specified Network Access Scope analyses.</p>', 'DescribeNetworkInsightsAccessScopes' => '<p>Describes the specified Network Access Scopes.</p>', 'DescribeNetworkInsightsAnalyses' => '<p>Describes one or more of your network insights analyses.</p>', 'DescribeNetworkInsightsPaths' => '<p>Describes one or more of your paths.</p>', 'DescribeNetworkInterfaceAttribute' => '<p>Describes a network interface attribute. You can specify only one attribute at a time.</p>', 'DescribeNetworkInterfacePermissions' => '<p>Describes the permissions for your network interfaces. </p>', 'DescribeNetworkInterfaces' => '<p>Describes one or more of your network interfaces.</p> <p>If you have a large number of network interfaces, the operation fails unless you use pagination or one of the following filters: <code>group-id</code>, <code>mac-address</code>, <code>private-dns-name</code>, <code>private-ip-address</code>, <code>private-dns-name</code>, <code>subnet-id</code>, or <code>vpc-id</code>.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important>', 'DescribePlacementGroups' => '<p>Describes the specified placement groups or all of your placement groups.</p> <note> <p>To describe a specific placement group that is <i>shared</i> with your account, you must specify the ID of the placement group using the <code>GroupId</code> parameter. Specifying the name of a <i>shared</i> placement group using the <code>GroupNames</code> parameter will result in an error.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribePrefixLists' => '<p>Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service.</p> <p>We recommend that you use <a>DescribeManagedPrefixLists</a> instead.</p>', 'DescribePrincipalIdFormat' => '<p>Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference. </p> <p>By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden the default ID settings.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p>', 'DescribePublicIpv4Pools' => '<p>Describes the specified IPv4 address pools.</p>', 'DescribeRegions' => '<p>Describes the Regions that are enabled for your account, or all Regions.</p> <p>For a list of the Regions supported by Amazon EC2, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-endpoints.html">Amazon EC2 service endpoints</a>.</p> <p>For information about enabling and disabling Regions for your account, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html">Specify which Amazon Web Services Regions your account can use</a> in the <i>Amazon Web Services Account Management Reference Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeReplaceRootVolumeTasks' => '<p>Describes a root volume replacement task. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace a root volume</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeReservedInstances' => '<p>Describes one or more of the Reserved Instances that you purchased.</p> <p>For more information about Reserved Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeReservedInstancesListings' => '<p>Describes your account\'s Reserved Instance listings in the Reserved Instance Marketplace.</p> <p>The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.</p> <p>As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you\'re searching for with what\'s available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeReservedInstancesModifications' => '<p>Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modify Reserved Instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeReservedInstancesOfferings' => '<p>Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.</p> <p>If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeRouteTables' => '<p>Describes your route tables. The default is to describe all your route tables. Alternatively, you can specify specific route table IDs or filter the results to include only the route tables that match specific criteria.</p> <p>Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DescribeScheduledInstanceAvailability' => '<p>Finds available schedules that meet the specified criteria.</p> <p>You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p> <p>After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled Instances with that schedule.</p>', 'DescribeScheduledInstances' => '<p>Describes the specified Scheduled Instances or all your Scheduled Instances.</p>', 'DescribeSecurityGroupReferences' => '<p>Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you\'ve specified in this request.</p>', 'DescribeSecurityGroupRules' => '<p>Describes one or more of your security group rules.</p>', 'DescribeSecurityGroups' => '<p>Describes the specified security groups or all of your security groups.</p>', 'DescribeSnapshotAttribute' => '<p>Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.</p> <p>For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DescribeSnapshotTierStatus' => '<p>Describes the storage tier status of one or more Amazon EBS snapshots.</p>', 'DescribeSnapshots' => '<p>Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.</p> <p>The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume permissions.</p> <p>The create volume permissions fall into the following categories:</p> <ul> <li> <p> <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the <code>all</code> group. All Amazon Web Services accounts have create volume permissions for these snapshots.</p> </li> <li> <p> <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific Amazon Web Services account.</p> </li> <li> <p> <i>implicit</i>: An Amazon Web Services account has implicit create volume permissions for all snapshots it owns.</p> </li> </ul> <p>The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or Amazon Web Services accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have create volume permissions.</p> <p>If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it is not included in the returned results.</p> <p>If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the specified owners and for which you have access are returned. The results can include the Amazon Web Services account IDs of the specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you own.</p> <p>If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots), <code>self</code> for snapshots for which you own or have explicit permissions, or <code>all</code> for public snapshots.</p> <p>If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more manageable. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.</p> <p>For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the <i>Amazon EBS User Guide</i>.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important>', 'DescribeSpotDatafeedSubscription' => '<p>Describes the data feed for Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeSpotFleetInstances' => '<p>Describes the running instances for the specified Spot Fleet.</p>', 'DescribeSpotFleetRequestHistory' => '<p>Describes the events for the specified Spot Fleet request during the specified time.</p> <p>Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon EventBridge</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeSpotFleetRequests' => '<p>Describes your Spot Fleet requests.</p> <p>Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotInstanceRequests' => '<p>Describes the specified Spot Instance requests.</p> <p>You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response. If the status of the Spot Instance is <code>fulfilled</code>, the instance ID appears in the response and contains the identifier of the instance. Alternatively, you can use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances</a> with a filter to look for instances where the instance lifecycle is <code>spot</code>.</p> <p>We recommend that you set <code>MaxResults</code> to a value between 5 and 1000 to limit the number of items returned. This paginates the output, which makes the list more manageable and returns the items faster. If the list of items exceeds your <code>MaxResults</code> value, then that number of items is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSpotInstanceRequests</code> request to retrieve the remaining items.</p> <p>Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotPriceHistory' => '<p>Describes the Spot price history. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance pricing history</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>When you specify a start and end time, the operation returns the prices of the instance types within that time range. It also returns the last price change before the start time, which is the effective price as of the start time.</p>', 'DescribeStaleSecurityGroups' => '<p>Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in a peered VPC. Rules can also be stale if they reference a security group in a peer VPC for which the VPC peering connection has been deleted.</p>', 'DescribeStoreImageTasks' => '<p>Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don\'t specify the AMIs, you get a paginated list of store tasks from the last 31 days.</p> <p>For each AMI task, the response indicates if the task is <code>InProgress</code>, <code>Completed</code>, or <code>Failed</code>. For tasks <code>InProgress</code>, the response shows the estimated progress as a percentage.</p> <p>Tasks are listed in reverse chronological order. Currently, only tasks from the past 31 days can be viewed.</p> <p>To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DescribeSubnets' => '<p>Describes your subnets. The default is to describe all your subnets. Alternatively, you can specify specific subnet IDs or filter the results to include only the subnets that match specific criteria.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DescribeTags' => '<p>Describes the specified tags for your EC2 resources.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeTrafficMirrorFilterRules' => '<p>Describe traffic mirror filters that determine the traffic that is mirrored.</p>', 'DescribeTrafficMirrorFilters' => '<p>Describes one or more Traffic Mirror filters.</p>', 'DescribeTrafficMirrorSessions' => '<p>Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.</p>', 'DescribeTrafficMirrorTargets' => '<p>Information about one or more Traffic Mirror targets.</p>', 'DescribeTransitGatewayAttachments' => '<p>Describes one or more attachments between resources and transit gateways. By default, all attachments are described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.</p>', 'DescribeTransitGatewayConnectPeers' => '<p>Describes one or more Connect peers.</p>', 'DescribeTransitGatewayConnects' => '<p>Describes one or more Connect attachments.</p>', 'DescribeTransitGatewayMulticastDomains' => '<p>Describes one or more transit gateway multicast domains.</p>', 'DescribeTransitGatewayPeeringAttachments' => '<p>Describes your transit gateway peering attachments.</p>', 'DescribeTransitGatewayPolicyTables' => '<p>Describes one or more transit gateway route policy tables. </p>', 'DescribeTransitGatewayRouteTableAnnouncements' => '<p>Describes one or more transit gateway route table advertisements.</p>', 'DescribeTransitGatewayRouteTables' => '<p>Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.</p>', 'DescribeTransitGatewayVpcAttachments' => '<p>Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.</p>', 'DescribeTransitGateways' => '<p>Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.</p>', 'DescribeTrunkInterfaceAssociations' => '<p>Describes one or more network interface trunk associations.</p>', 'DescribeVerifiedAccessEndpoints' => '<p>Describes the specified Amazon Web Services Verified Access endpoints.</p>', 'DescribeVerifiedAccessGroups' => '<p>Describes the specified Verified Access groups.</p>', 'DescribeVerifiedAccessInstanceLoggingConfigurations' => '<p>Describes the specified Amazon Web Services Verified Access instances.</p>', 'DescribeVerifiedAccessInstances' => '<p>Describes the specified Amazon Web Services Verified Access instances.</p>', 'DescribeVerifiedAccessTrustProviders' => '<p>Describes the specified Amazon Web Services Verified Access trust providers.</p>', 'DescribeVolumeAttribute' => '<p>Describes the specified attribute of the specified volume. You can specify only one attribute at a time.</p> <p>For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DescribeVolumeStatus' => '<p>Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume\'s underlying host. If the volume\'s underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event.</p> <p>The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:</p> <p> <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>, <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the status is <code>insufficient-data</code>, then the checks might still be taking place on your volume at the time. We recommend that you retry the request. For more information about volume status, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-status.html">Monitor the status of your volumes</a> in the <i>Amazon EBS User Guide</i>.</p> <p> <i>Events</i>: Reflect the cause of a volume status and might require you to take action. For example, if your volume returns an <code>impaired</code> status, then the volume event might be <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the underlying host, has all I/O operations disabled, and might have inconsistent data.</p> <p> <i>Actions</i>: Reflect the actions you might have to take in response to an event. For example, if the status of the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.</p> <p>Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of accepting I/O.)</p> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeVolumes' => '<p>Describes the specified EBS volumes or all of your EBS volumes.</p> <p>If you are describing a long list of volumes, we recommend that you paginate the output to make the list more manageable. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon EBS User Guide</i>.</p> <important> <p>We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and timeouts.</p> </important> <note> <p>The order of the elements in the response, including those within nested structures, might vary. Applications should not assume the elements appear in a particular order.</p> </note>', 'DescribeVolumesModifications' => '<p>Describes the most recent volume modification request for the specified EBS volumes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-modifications.html"> Monitor the progress of volume modifications</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DescribeVpcAttribute' => '<p>Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.</p>', 'DescribeVpcClassicLink' => '<note> <p>This action is deprecated.</p> </note> <p>Describes the ClassicLink status of the specified VPCs.</p>', 'DescribeVpcClassicLinkDnsSupport' => '<note> <p>This action is deprecated.</p> </note> <p>Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance.</p>', 'DescribeVpcEndpointConnectionNotifications' => '<p>Describes the connection notifications for VPC endpoints and VPC endpoint services.</p>', 'DescribeVpcEndpointConnections' => '<p>Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.</p>', 'DescribeVpcEndpointServiceConfigurations' => '<p>Describes the VPC endpoint service configurations in your account (your services).</p>', 'DescribeVpcEndpointServicePermissions' => '<p>Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.</p>', 'DescribeVpcEndpointServices' => '<p>Describes available services to which you can create a VPC endpoint.</p> <p>When the service provider and the consumer have different accounts in multiple Availability Zones, and the consumer views the VPC endpoint service information, the response only includes the common Availability Zones. For example, when the service provider account uses <code>us-east-1a</code> and <code>us-east-1c</code> and the consumer uses <code>us-east-1a</code> and <code>us-east-1b</code>, the response includes the VPC endpoint services in the common Availability Zone, <code>us-east-1a</code>.</p>', 'DescribeVpcEndpoints' => '<p>Describes your VPC endpoints. The default is to describe all your VPC endpoints. Alternatively, you can specify specific VPC endpoint IDs or filter the results to include only the VPC endpoints that match specific criteria.</p>', 'DescribeVpcPeeringConnections' => '<p>Describes your VPC peering connections. The default is to describe all your VPC peering connections. Alternatively, you can specify specific VPC peering connection IDs or filter the results to include only the VPC peering connections that match specific criteria.</p>', 'DescribeVpcs' => '<p>Describes your VPCs. The default is to describe all your VPCs. Alternatively, you can specify specific VPC IDs or filter the results to include only the VPCs that match specific criteria.</p>', 'DescribeVpnConnections' => '<p>Describes one or more of your VPN connections.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'DescribeVpnGateways' => '<p>Describes one or more of your virtual private gateways.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'DetachClassicLinkVpc' => '<note> <p>This action is deprecated.</p> </note> <p>Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it\'s stopped.</p>', 'DetachInternetGateway' => '<p>Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.</p>', 'DetachNetworkInterface' => '<p>Detaches a network interface from an instance.</p>', 'DetachVerifiedAccessTrustProvider' => '<p>Detaches the specified Amazon Web Services Verified Access trust provider from the specified Amazon Web Services Verified Access instance.</p>', 'DetachVolume' => '<p>Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can\'t be detached while the instance is running. To detach the root volume, stop the instance first.</p> <p>When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the product code is no longer associated with the instance.</p> <p>You can\'t detach or force detach volumes that are attached to Amazon ECS or Fargate tasks. Attempting to do this results in the <code>UnsupportedOperationException</code> exception with the <code>Unable to detach volume attached to ECS tasks</code> error message.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-detaching-volume.html">Detach an Amazon EBS volume</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DetachVpnGateway' => '<p>Detaches a virtual private gateway from a VPC. You do this if you\'re planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described).</p> <p>You must wait for the attachment\'s state to switch to <code>detached</code> before you can delete the VPC or attach a different VPC to the virtual private gateway.</p>', 'DisableAddressTransfer' => '<p>Disables Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DisableAwsNetworkPerformanceMetricSubscription' => '<p>Disables Infrastructure Performance metric subscriptions.</p>', 'DisableEbsEncryptionByDefault' => '<p>Disables EBS encryption by default for your account in the current Region.</p> <p>After you disable encryption by default, you can still create encrypted volumes by enabling encryption when you create each volume.</p> <p>Disabling encryption by default does not change the encryption status of your existing volumes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'DisableFastLaunch' => '<p>Discontinue Windows fast launch for a Windows AMI, and clean up existing pre-provisioned snapshots. After you disable Windows fast launch, the AMI uses the standard launch process for each new instance. Amazon EC2 must remove all pre-provisioned snapshots before you can enable Windows fast launch again.</p> <note> <p>You can only change these settings for Windows AMIs that you own or that have been shared with you.</p> </note>', 'DisableFastSnapshotRestores' => '<p>Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.</p>', 'DisableImage' => '<p>Sets the AMI state to <code>disabled</code> and removes all launch permissions from the AMI. A disabled AMI can\'t be used for instance launches.</p> <p>A disabled AMI can\'t be shared. If an AMI was public or previously shared, it is made private. If an AMI was shared with an Amazon Web Services account, organization, or Organizational Unit, they lose access to the disabled AMI. </p> <p>A disabled AMI does not appear in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages</a> API calls by default.</p> <p>Only the AMI owner can disable an AMI.</p> <p>You can re-enable a disabled AMI using <a href="http://amazonaws.com/AWSEC2/latest/APIReference/API_EnableImage.html">EnableImage</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/disable-an-ami.html">Disable an AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisableImageBlockPublicAccess' => '<p>Disables <i>block public access for AMIs</i> at the account level in the specified Amazon Web Services Region. This removes the <i>block public access</i> restriction from your account. With the restriction removed, you can publicly share your AMIs in the specified Amazon Web Services Region.</p> <p>The API can take up to 10 minutes to configure this setting. During this time, if you run <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetImageBlockPublicAccessState.html">GetImageBlockPublicAccessState</a>, the response will be <code>block-new-sharing</code>. When the API has completed the configuration, the response will be <code>unblocked</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sharingamis-intro.html#block-public-access-to-amis">Block public access to your AMIs</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisableImageDeprecation' => '<p>Cancels the deprecation of the specified AMI.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisableImageDeregistrationProtection' => '<p>Disables deregistration protection for an AMI. When deregistration protection is disabled, the AMI can be deregistered.</p> <p>If you chose to include a 24-hour cooldown period when you enabled deregistration protection for the AMI, then, when you disable deregistration protection, you won’t immediately be able to deregister the AMI.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html#ami-deregistration-protection">Protect an AMI from deregistration</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisableIpamOrganizationAdminAccount' => '<p>Disable the IPAM account. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/enable-integ-ipam.html">Enable integration with Organizations</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'DisableSerialConsoleAccess' => '<p>Disables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisableSnapshotBlockPublicAccess' => '<p>Disables the <i>block public access for snapshots</i> setting at the account level for the specified Amazon Web Services Region. After you disable block public access for snapshots in a Region, users can publicly share snapshots in that Region.</p> <important> <p>Enabling block public access for snapshots in <i>block-all-sharing</i> mode does not change the permissions for snapshots that are already publicly shared. Instead, it prevents these snapshots from be publicly visible and publicly accessible. Therefore, the attributes for these snapshots still indicate that they are publicly shared, even though they are not publicly available.</p> <p>If you disable block public access , these snapshots will become publicly available again.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/block-public-access-snapshots.html"> Block public access for snapshots</a> in the <i>Amazon EBS User Guide</i> .</p> <p/>', 'DisableTransitGatewayRouteTablePropagation' => '<p>Disables the specified resource attachment from propagating routes to the specified propagation route table.</p>', 'DisableVgwRoutePropagation' => '<p>Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.</p>', 'DisableVpcClassicLink' => '<note> <p>This action is deprecated.</p> </note> <p>Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.</p>', 'DisableVpcClassicLinkDnsSupport' => '<note> <p>This action is deprecated.</p> </note> <p>Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it\'s linked.</p> <p>You must specify a VPC ID in the request.</p>', 'DisassociateAddress' => '<p>Disassociates an Elastic IP address from the instance or network interface it\'s associated with.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p>', 'DisassociateClientVpnTargetNetwork' => '<p>Disassociates a target network from the specified Client VPN endpoint. When you disassociate the last target network from a Client VPN, the following happens:</p> <ul> <li> <p>The route that was automatically added for the VPC is deleted</p> </li> <li> <p>All active client connections are terminated</p> </li> <li> <p>New client connections are disallowed</p> </li> <li> <p>The Client VPN endpoint\'s status changes to <code>pending-associate</code> </p> </li> </ul>', 'DisassociateEnclaveCertificateIamRole' => '<p>Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and encrypted private key from the Amazon S3 bucket. It also revokes the IAM role\'s permission to use the KMS key used to encrypt the private key. This effectively revokes the role\'s permission to use the certificate.</p>', 'DisassociateIamInstanceProfile' => '<p>Disassociates an IAM instance profile from a running or stopped instance.</p> <p>Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.</p>', 'DisassociateInstanceEventWindow' => '<p>Disassociates one or more targets from an event window.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DisassociateIpamByoasn' => '<p>Remove the association between your Autonomous System Number (ASN) and your BYOIP CIDR. You may want to use this action to disassociate an ASN from a CIDR or if you want to swap ASNs. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p>', 'DisassociateIpamResourceDiscovery' => '<p>Disassociates a resource discovery from an Amazon VPC IPAM. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'DisassociateNatGatewayAddress' => '<p>Disassociates secondary Elastic IP addresses (EIPs) from a public NAT gateway. You cannot disassociate your primary EIP. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-edit-secondary">Edit secondary IP address associations</a> in the <i>Amazon VPC User Guide</i>.</p> <p>While disassociating is in progress, you cannot associate/disassociate additional EIPs while the connections are being drained. You are, however, allowed to delete the NAT gateway.</p> <p>An EIP is released only at the end of MaxDrainDurationSeconds. It stays associated and supports the existing connections but does not support any new connections (new connections are distributed across the remaining associated EIPs). As the existing connections drain out, the EIPs (and the corresponding private IP addresses mapped to them) are released.</p>', 'DisassociateRouteTable' => '<p>Disassociates a subnet or gateway from a route table.</p> <p>After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the routes in the VPC\'s main route table. For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DisassociateSubnetCidrBlock' => '<p>Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. </p>', 'DisassociateTransitGatewayMulticastDomain' => '<p>Disassociates the specified subnets from the transit gateway multicast domain. </p>', 'DisassociateTransitGatewayPolicyTable' => '<p>Removes the association between an an attachment and a policy table.</p>', 'DisassociateTransitGatewayRouteTable' => '<p>Disassociates a resource attachment from a transit gateway route table.</p>', 'DisassociateTrunkInterface' => '<p>Removes an association between a branch network interface with a trunk network interface.</p>', 'DisassociateVpcCidrBlock' => '<p>Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You can get the association ID by using <a>DescribeVpcs</a>. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. </p> <p>You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).</p>', 'EnableAddressTransfer' => '<p>Enables Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <i>Amazon VPC User Guide</i>.</p>', 'EnableAwsNetworkPerformanceMetricSubscription' => '<p>Enables Infrastructure Performance subscriptions.</p>', 'EnableEbsEncryptionByDefault' => '<p>Enables EBS encryption by default for your account in the current Region.</p> <p>After you enable encryption by default, the EBS volumes that you create are always encrypted, either using the default KMS key or the KMS key that you specified when you created each volume. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p> <p>You can specify the default KMS key for encryption by default using <a>ModifyEbsDefaultKmsKeyId</a> or <a>ResetEbsDefaultKmsKeyId</a>.</p> <p>Enabling encryption by default has no effect on the encryption status of your existing volumes.</p> <p>After you enable encryption by default, you can no longer launch instances using instance types that do not support encryption. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances">Supported instance types</a>.</p>', 'EnableFastLaunch' => '<p>When you enable Windows fast launch for a Windows AMI, images are pre-provisioned, using snapshots to launch instances up to 65% faster. To create the optimized Windows image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required. Then it creates a set of reserved snapshots that are used for subsequent launches. The reserved snapshots are automatically replenished as they are used, depending on your settings for launch frequency.</p> <note> <p>You can only change these settings for Windows AMIs that you own or that have been shared with you.</p> </note>', 'EnableFastSnapshotRestores' => '<p>Enables fast snapshot restores for the specified snapshots in the specified Availability Zones.</p> <p>You get the full benefit of fast snapshot restores after they enter the <code>enabled</code> state. To get the current state of fast snapshot restores, use <a>DescribeFastSnapshotRestores</a>. To disable fast snapshot restores, use <a>DisableFastSnapshotRestores</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-fast-snapshot-restore.html">Amazon EBS fast snapshot restore</a> in the <i>Amazon EBS User Guide</i>.</p>', 'EnableImage' => '<p>Re-enables a disabled AMI. The re-enabled AMI is marked as <code>available</code> and can be used for instance launches, appears in describe operations, and can be shared. Amazon Web Services accounts, organizations, and Organizational Units that lost access to the AMI when it was disabled do not regain access automatically. Once the AMI is available, it can be shared with them again.</p> <p>Only the AMI owner can re-enable a disabled AMI.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/disable-an-ami.html">Disable an AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EnableImageBlockPublicAccess' => '<p>Enables <i>block public access for AMIs</i> at the account level in the specified Amazon Web Services Region. This prevents the public sharing of your AMIs. However, if you already have public AMIs, they will remain publicly available.</p> <p>The API can take up to 10 minutes to configure this setting. During this time, if you run <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetImageBlockPublicAccessState.html">GetImageBlockPublicAccessState</a>, the response will be <code>unblocked</code>. When the API has completed the configuration, the response will be <code>block-new-sharing</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sharingamis-intro.html#block-public-access-to-amis">Block public access to your AMIs</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EnableImageDeprecation' => '<p>Enables deprecation of the specified AMI at the specified date and time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EnableImageDeregistrationProtection' => '<p>Enables deregistration protection for an AMI. When deregistration protection is enabled, the AMI can\'t be deregistered.</p> <p>To allow the AMI to be deregistered, you must first disable deregistration protection using <a>DisableImageDeregistrationProtection</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html#ami-deregistration-protection">Protect an AMI from deregistration</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EnableIpamOrganizationAdminAccount' => '<p>Enable an Organizations member account as the IPAM admin account. You cannot select the Organizations management account as the IPAM admin account. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/enable-integ-ipam.html">Enable integration with Organizations</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'EnableReachabilityAnalyzerOrganizationSharing' => '<p>Establishes a trust relationship between Reachability Analyzer and Organizations. This operation must be performed by the management account for the organization.</p> <p>After you establish a trust relationship, a user in the management account or a delegated administrator account can run a cross-account analysis using resources from the member accounts.</p>', 'EnableSerialConsoleAccess' => '<p>Enables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EnableSnapshotBlockPublicAccess' => '<p>Enables or modifies the <i>block public access for snapshots</i> setting at the account level for the specified Amazon Web Services Region. After you enable block public access for snapshots in a Region, users can no longer request public sharing for snapshots in that Region. Snapshots that are already publicly shared are either treated as private or they remain publicly shared, depending on the <b>State</b> that you specify.</p> <important> <p>Enabling block public access for snapshots in <i>block all sharing</i> mode does not change the permissions for snapshots that are already publicly shared. Instead, it prevents these snapshots from be publicly visible and publicly accessible. Therefore, the attributes for these snapshots still indicate that they are publicly shared, even though they are not publicly available.</p> <p>If you later disable block public access or change the mode to <i>block new sharing</i>, these snapshots will become publicly available again.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/block-public-access-snapshots.html"> Block public access for snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>', 'EnableTransitGatewayRouteTablePropagation' => '<p>Enables the specified attachment to propagate routes to the specified propagation route table.</p>', 'EnableVgwRoutePropagation' => '<p>Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.</p>', 'EnableVolumeIO' => '<p>Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was potentially inconsistent.</p>', 'EnableVpcClassicLink' => '<note> <p>This action is deprecated.</p> </note> <p>Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing routes for address ranges within the <code>10.0.0.0/8</code> IP address range, excluding local routes for VPCs in the <code>10.0.0.0/16</code> and <code>10.1.0.0/16</code> IP address ranges.</p>', 'EnableVpcClassicLinkDnsSupport' => '<note> <p>This action is deprecated.</p> </note> <p>Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance.</p> <p>You must specify a VPC ID in the request.</p>', 'ExportClientVpnClientCertificateRevocationList' => '<p>Downloads the client certificate revocation list for the specified Client VPN endpoint.</p>', 'ExportClientVpnClientConfiguration' => '<p>Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN endpoint and certificate information clients need to establish a connection with the Client VPN endpoint.</p>', 'ExportImage' => '<p>Exports an Amazon Machine Image (AMI) to a VM file. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html">Exporting a VM directly from an Amazon Machine Image (AMI)</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ExportTransitGatewayRoutes' => '<p>Exports routes from the specified transit gateway route table to the specified S3 bucket. By default, all routes are exported. Alternatively, you can filter by CIDR range.</p> <p>The routes are saved to the specified bucket in a JSON file. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables">Export route tables to Amazon S3</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.</p>', 'GetAssociatedEnclaveCertificateIamRoles' => '<p>Returns the IAM roles that are associated with the specified ACM (ACM) certificate. It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key that\'s used to encrypt the private key.</p>', 'GetAssociatedIpv6PoolCidrs' => '<p>Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.</p>', 'GetAwsNetworkPerformanceData' => '<p>Gets network performance data.</p>', 'GetCapacityReservationUsage' => '<p>Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only the Capacity Reservation owner\'s usage.</p>', 'GetCoipPoolUsage' => '<p>Describes the allocations from the specified customer-owned address pool.</p>', 'GetConsoleOutput' => '<p>Gets the console output for the specified instance. For Linux instances, the instance console output displays the exact console output that would normally be displayed on a physical monitor attached to a computer. For Windows instances, the instance console output includes the last three system event log errors.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output">Instance console output</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetConsoleScreenshot' => '<p>Retrieve a JPG-format screenshot of a running instance to help with troubleshooting.</p> <p>The returned content is Base64-encoded.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/troubleshoot-unreachable-instance.html#instance-console-console-output">Instance console output</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetDefaultCreditSpecification' => '<p>Describes the default credit option for CPU usage of a burstable performance instance family.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetEbsDefaultKmsKeyId' => '<p>Describes the default KMS key for EBS encryption by default for your account in this Region. You can change the default KMS key for encryption by default using <a>ModifyEbsDefaultKmsKeyId</a> or <a>ResetEbsDefaultKmsKeyId</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'GetEbsEncryptionByDefault' => '<p>Describes whether EBS encryption by default is enabled for your account in the current Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'GetFlowLogsIntegrationTemplate' => '<p>Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data. Based on the information that you provide, we configure resources in the template to do the following:</p> <ul> <li> <p>Create a table in Athena that maps fields to a custom log format</p> </li> <li> <p>Create a Lambda function that updates the table with new partitions on a daily, weekly, or monthly basis</p> </li> <li> <p>Create a table partitioned between two timestamps in the past</p> </li> <li> <p>Create a set of named queries in Athena that you can use to get started quickly</p> </li> </ul> <note> <p> <code>GetFlowLogsIntegrationTemplate</code> does not support integration between Amazon Web Services Transit Gateway Flow Logs and Amazon Athena.</p> </note>', 'GetGroupsForCapacityReservation' => '<p>Lists the resource groups to which a Capacity Reservation has been added.</p>', 'GetHostReservationPurchasePreview' => '<p>Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation.</p> <p>This is a preview of the <a>PurchaseHostReservation</a> action and does not result in the offering being purchased.</p>', 'GetImageBlockPublicAccessState' => '<p>Gets the current state of <i>block public access for AMIs</i> at the account level in the specified Amazon Web Services Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sharingamis-intro.html#block-public-access-to-amis">Block public access to your AMIs</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetInstanceMetadataDefaults' => '<p>Gets the default instance metadata service (IMDS) settings that are set at the account level in the specified Amazon Web Services&#x2028; Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html#instance-metadata-options-order-of-precedence">Order of precedence for instance metadata options</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetInstanceTpmEkPub' => '<p>Gets the public endorsement key associated with the Nitro Trusted Platform Module (NitroTPM) for the specified instance.</p>', 'GetInstanceTypesFromInstanceRequirements' => '<p>Returns a list of instance types with the specified instance attributes. You can use the response to preview the instance types without launching instances. Note that the response does not consider capacity.</p> <p>When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html#spotfleet-get-instance-types-from-instance-requirements">Preview instance types with specified attributes</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <i>Amazon EC2 User Guide</i>, and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'GetInstanceUefiData' => '<p>A binary representation of the UEFI variable store. Only non-volatile variables are stored. This is a base64 encoded and zlib compressed binary value that must be properly encoded.</p> <p>When you use <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/register-image.html">register-image</a> to create an AMI, you can create an exact copy of your variable store by passing the UEFI data in the <code>UefiData</code> parameter. You can modify the UEFI data by using the <a href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. You can use the tool to convert the UEFI data into a human-readable format (JSON), which you can inspect and modify, and then convert back into the binary format to use with register-image.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetIpamAddressHistory' => '<p>Retrieve historical information about a CIDR within an IPAM scope. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/view-history-cidr-ipam.html">View the history of IP addresses</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'GetIpamDiscoveredAccounts' => '<p>Gets IPAM discovered accounts. A discovered account is an Amazon Web Services account that is monitored under a resource discovery. If you have integrated IPAM with Amazon Web Services Organizations, all accounts in the organization are discovered accounts. Only the IPAM account can get all discovered accounts in the organization.</p>', 'GetIpamDiscoveredPublicAddresses' => '<p>Gets the public IP addresses that have been discovered by IPAM.</p>', 'GetIpamDiscoveredResourceCidrs' => '<p>Returns the resource CIDRs that are monitored as part of a resource discovery. A discovered resource is a resource CIDR monitored under a resource discovery. The following resources can be discovered: VPCs, Public IPv4 pools, VPC subnets, and Elastic IP addresses. </p>', 'GetIpamPoolAllocations' => '<p>Get a list of all the CIDR allocations in an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations.</p> <note> <p>If you use this action after <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateIpamPoolCidr.html">AllocateIpamPoolCidr</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">ReleaseIpamPoolAllocation</a>, note that all EC2 API actions follow an <a href="https://docs.aws.amazon.com/ec2/latest/devguide/eventual-consistency.html">eventual consistency</a> model.</p> </note>', 'GetIpamPoolCidrs' => '<p>Get the CIDRs provisioned to an IPAM pool.</p>', 'GetIpamResourceCidrs' => '<p>Returns resource CIDRs managed by IPAM in a given scope. If an IPAM is associated with more than one resource discovery, the resource CIDRs across all of the resource discoveries is returned. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'GetLaunchTemplateData' => '<p>Retrieves the configuration data of the specified instance. You can use this data to create a launch template. </p> <p>This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following actions in your IAM policy: <code>DescribeSpotInstanceRequests</code>, <code>DescribeInstanceCreditSpecifications</code>, <code>DescribeVolumes</code>, and <code>DescribeInstanceAttribute</code>. Or, you can allow <code>describe*</code> depending on your instance requirements.</p>', 'GetManagedPrefixListAssociations' => '<p>Gets information about the resources that are associated with the specified managed prefix list.</p>', 'GetManagedPrefixListEntries' => '<p>Gets information about the entries for a specified managed prefix list.</p>', 'GetNetworkInsightsAccessScopeAnalysisFindings' => '<p>Gets the findings for the specified Network Access Scope analysis.</p>', 'GetNetworkInsightsAccessScopeContent' => '<p>Gets the content for the specified Network Access Scope.</p>', 'GetPasswordData' => '<p>Retrieves the encrypted administrator password for a running Windows instance.</p> <p>The Windows password is generated at boot by the <code>EC2Config</code> service or <code>EC2Launch</code> scripts (Windows Server 2016 and later). This usually only happens the first time an instance is launched. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UsingConfig_WinAMI.html">EC2Config</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2launch.html">EC2Launch</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For the <code>EC2Config</code> service, the password is not generated for rebundled AMIs unless <code>Ec2SetPassword</code> is enabled before bundling.</p> <p>The password is encrypted using the key pair that you specified when you launched the instance. You must provide the corresponding key pair file.</p> <p>When you launch an instance, password generation and encryption may take a few minutes. If you try to retrieve the password before it\'s available, the output returns an empty string. We recommend that you wait up to 15 minutes after launching an instance before trying to retrieve the generated password.</p>', 'GetReservedInstancesExchangeQuote' => '<p>Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response. Use <a>AcceptReservedInstancesExchangeQuote</a> to perform the exchange.</p>', 'GetSecurityGroupsForVpc' => '<p>Gets security groups that can be associated by the Amazon Web Services account making the request with network interfaces in the specified VPC.</p>', 'GetSerialConsoleAccessStatus' => '<p>Retrieves the access status of your account to the EC2 serial console of all instances. By default, access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetSnapshotBlockPublicAccessState' => '<p>Gets the current state of <i>block public access for snapshots</i> setting for the account and Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/block-public-access-snapshots.html"> Block public access for snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>', 'GetSpotPlacementScores' => '<p>Calculates the Spot placement score for a Region or Availability Zone based on the specified target capacity and compute requirements.</p> <p>You can specify your compute requirements either by using <code>InstanceRequirementsWithMetadata</code> and letting Amazon EC2 choose the optimal instance types to fulfill your Spot request, or you can specify the instance types by using <code>InstanceTypes</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetSubnetCidrReservations' => '<p>Gets information about the subnet CIDR reservations.</p>', 'GetTransitGatewayAttachmentPropagations' => '<p>Lists the route tables to which the specified resource attachment propagates routes.</p>', 'GetTransitGatewayMulticastDomainAssociations' => '<p>Gets information about the associations for the transit gateway multicast domain.</p>', 'GetTransitGatewayPolicyTableAssociations' => '<p>Gets a list of the transit gateway policy table associations.</p>', 'GetTransitGatewayPolicyTableEntries' => '<p>Returns a list of transit gateway policy table entries.</p>', 'GetTransitGatewayPrefixListReferences' => '<p>Gets information about the prefix list references in a specified transit gateway route table.</p>', 'GetTransitGatewayRouteTableAssociations' => '<p>Gets information about the associations for the specified transit gateway route table.</p>', 'GetTransitGatewayRouteTablePropagations' => '<p>Gets information about the route table propagations for the specified transit gateway route table.</p>', 'GetVerifiedAccessEndpointPolicy' => '<p>Get the Verified Access policy associated with the endpoint.</p>', 'GetVerifiedAccessGroupPolicy' => '<p>Shows the contents of the Verified Access policy associated with the group.</p>', 'GetVpnConnectionDeviceSampleConfiguration' => '<p>Download an Amazon Web Services-provided sample configuration file to be used with the customer gateway device specified for your Site-to-Site VPN connection.</p>', 'GetVpnConnectionDeviceTypes' => '<p>Obtain a list of customer gateway devices for which sample configuration files can be provided. The request has no additional parameters. You can also see the list of device types with sample configuration files available under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer gateway device</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'GetVpnTunnelReplacementStatus' => '<p>Get details of available tunnel endpoint maintenance.</p>', 'ImportClientVpnClientCertificateRevocationList' => '<p>Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.</p> <p>Uploading a client certificate revocation list resets existing client connections.</p>', 'ImportImage' => '<note> <p>To import your virtual machines (VMs) with a console-based experience, you can use the <i>Import virtual machine images to Amazon Web Services</i> template in the <a href="https://console.aws.amazon.com/migrationhub/orchestrator">Migration Hub Orchestrator console</a>. For more information, see the <a href="https://docs.aws.amazon.com/migrationhub-orchestrator/latest/userguide/import-vm-images.html"> <i>Migration Hub Orchestrator User Guide</i> </a>.</p> </note> <p>Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).</p> <important> <p>Amazon Web Services VM Import/Export strongly recommends specifying a value for either the <code>--license-type</code> or <code>--usage-operation</code> parameter when you create a new VM Import task. This ensures your operating system is licensed appropriately and your billing is optimized.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a VM as an image using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ImportInstance' => '<note> <p>We recommend that you use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html"> <code>ImportImage</code> </a> API. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a VM as an image using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p> </note> <p>Creates an import instance task using metadata from the specified disk image.</p> <p>This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#UsingVirtualMachinesinAmazonEC2">Importing a VM to Amazon EC2</a> in the <i>Amazon EC2 CLI Reference</i> PDF file.</p> <p>This API action supports only single-volume VMs. To import multi-volume VMs, use <a>ImportImage</a> instead.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ImportKeyPair' => '<p>Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool. Compare this with <a>CreateKeyPair</a>, in which Amazon Web Services creates the key pair and gives the keys to you (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key. The private key is never transferred between you and Amazon Web Services.</p> <p>For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportSnapshot' => '<p>Imports a disk into an EBS snapshot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-import-snapshot.html">Importing a disk as a snapshot using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ImportVolume' => '<p>Creates an import volume task using metadata from the specified disk image.</p> <p>This API action supports only single-volume VMs. To import multi-volume VMs, use <a>ImportImage</a> instead. To import a disk to a snapshot, use <a>ImportSnapshot</a> instead.</p> <p>This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#importing-your-volumes-into-amazon-ebs">Importing Disks to Amazon EBS</a> in the <i>Amazon EC2 CLI Reference</i> PDF file.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ListImagesInRecycleBin' => '<p>Lists one or more AMIs that are currently in the Recycle Bin. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ListSnapshotsInRecycleBin' => '<p>Lists one or more snapshots that are currently in the Recycle Bin.</p>', 'LockSnapshot' => '<p>Locks an Amazon EBS snapshot in either <i>governance</i> or <i>compliance</i> mode to protect it against accidental or malicious deletions for a specific duration. A locked snapshot can\'t be deleted.</p> <p>You can also use this action to modify the lock settings for a snapshot that is already locked. The allowed modifications depend on the lock mode and lock state:</p> <ul> <li> <p>If the snapshot is locked in governance mode, you can modify the lock mode and the lock duration or lock expiration date.</p> </li> <li> <p>If the snapshot is locked in compliance mode and it is in the cooling-off period, you can modify the lock mode and the lock duration or lock expiration date.</p> </li> <li> <p>If the snapshot is locked in compliance mode and the cooling-off period has lapsed, you can only increase the lock duration or extend the lock expiration date.</p> </li> </ul>', 'ModifyAddressAttribute' => '<p>Modifies an attribute of the specified Elastic IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications</a>.</p>', 'ModifyAvailabilityZoneGroup' => '<p>Changes the opt-in status of the specified zone group for your account.</p>', 'ModifyCapacityReservation' => '<p>Modifies a Capacity Reservation\'s capacity, instance eligibility, and the conditions under which it is to be released. You can\'t modify a Capacity Reservation\'s instance type, EBS optimization, platform, instance store settings, Availability Zone, or tenancy. If you need to modify any of these attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with the required attributes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-modify.html">Modify an active Capacity Reservation</a>.</p>', 'ModifyCapacityReservationFleet' => '<p>Modifies a Capacity Reservation Fleet.</p> <p>When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for all of the individual Capacity Reservations in the Fleet are updated accordingly.</p>', 'ModifyClientVpnEndpoint' => '<p>Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.</p>', 'ModifyDefaultCreditSpecification' => '<p>Modifies the default credit option for CPU usage of burstable performance instances. The default credit option is set at the account level per Amazon Web Services Region, and is specified per instance family. All new burstable performance instances in the account launch using the default credit option.</p> <p> <code>ModifyDefaultCreditSpecification</code> is an asynchronous operation, which works at an Amazon Web Services Region level and modifies the credit option for each Availability Zone. All zones in a Region are updated within five minutes. But if instances are launched during this operation, they might not get the new credit option until the zone is updated. To verify whether the update has occurred, you can call <code>GetDefaultCreditSpecification</code> and check <code>DefaultCreditSpecification</code> for updates.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyEbsDefaultKmsKeyId' => '<p>Changes the default KMS key for EBS encryption by default for your account in this Region.</p> <p>Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use <a>ResetEbsDefaultKmsKeyId</a>. Amazon EBS does not support asymmetric KMS keys.</p> <p>If you delete or disable the customer managed KMS key that you specified for use with encryption by default, your instances will fail to launch.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'ModifyFleet' => '<p>Modifies the specified EC2 Fleet.</p> <p>You can only modify an EC2 Fleet request of type <code>maintain</code>.</p> <p>While the EC2 Fleet is being modified, it is in the <code>modifying</code> state.</p> <p>To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation strategy is <code>lowest-price</code>, the EC2 Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is <code>diversified</code>, the EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is <code>capacity-optimized</code>, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p> <p>To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowest-price</code>, the EC2 Fleet terminates the instances with the highest price per unit. If the allocation strategy is <code>capacity-optimized</code>, the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is <code>diversified</code>, the EC2 Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually.</p> <p>If you are finished with your EC2 Fleet for now, but will use it again later, you can set the target capacity to 0.</p>', 'ModifyFpgaImageAttribute' => '<p>Modifies the specified attribute of the specified Amazon FPGA Image (AFI).</p>', 'ModifyHosts' => '<p>Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of <code>host</code> but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled.</p> <p>You can also use this API action to modify a Dedicated Host to support either multiple instance types in an instance family, or to support a specific instance type only.</p>', 'ModifyIdFormat' => '<p>Modifies the ID format for the specified resource on a per-Region basis. You can specify that resources should receive longer IDs (17-character IDs) when they are created.</p> <p>This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p> <p>This setting applies to the IAM user who makes the request; it does not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If you\'re using this action as the root user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for themselves. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyIdentityIdFormat' => '<p>Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs (17-character IDs) when they are created. </p> <p>This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>This setting applies to the principal specified in the request; it does not apply to the principal that makes the request. </p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyImageAttribute' => '<p>Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.</p> <p>To specify the attribute, you can use the <code>Attribute</code> parameter, or one of the following parameters: <code>Description</code>, <code>ImdsSupport</code>, or <code>LaunchPermission</code>.</p> <p>Images with an Amazon Web Services Marketplace product code cannot be made public.</p> <p>To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance and create an AMI from the instance.</p>', 'ModifyInstanceAttribute' => '<p>Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.</p> <p> <b>Note: </b>Using this action to change the security groups associated with an elastic network interface (ENI) attached to an instance can result in an error if the instance has more than one ENI. To change the security groups associated with an ENI attached to an instance that has multiple ENIs, we recommend that you use the <a>ModifyNetworkInterfaceAttribute</a> action.</p> <p>To modify some attributes, the instance must be stopped. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modify a stopped instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyInstanceCapacityReservationAttributes' => '<p>Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any <code>open</code> Capacity Reservation with matching attributes, or run On-Demand Instance capacity.</p>', 'ModifyInstanceCreditSpecification' => '<p>Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are <code>standard</code> and <code>unlimited</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyInstanceEventStartTime' => '<p>Modifies the start time for a scheduled Amazon EC2 instance event.</p>', 'ModifyInstanceEventWindow' => '<p>Modifies the specified event window.</p> <p>You can define either a set of time ranges or a cron expression when modifying the event window, but not both.</p> <p>To modify the targets associated with the event window, use the <a>AssociateInstanceEventWindow</a> and <a>DisassociateInstanceEventWindow</a> API.</p> <p>If Amazon Web Services has already scheduled an event, modifying an event window won\'t change the time of the scheduled event.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyInstanceMaintenanceOptions' => '<p>Modifies the recovery behavior of your instance to disable simplified automatic recovery or set the recovery behavior to default. The default configuration will not enable simplified automatic recovery for an unsupported instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery">Simplified automatic recovery</a>.</p>', 'ModifyInstanceMetadataDefaults' => '<p>Modifies the default instance metadata service (IMDS) settings at the account level in the specified Amazon Web Services&#x2028; Region.</p> <note> <p>To remove a parameter\'s account-level default setting, specify <code>no-preference</code>. If an account-level setting is cleared with <code>no-preference</code>, then the instance launch considers the other instance metadata settings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html#instance-metadata-options-order-of-precedence">Order of precedence for instance metadata options</a> in the <i>Amazon EC2 User Guide</i>.</p> </note>', 'ModifyInstanceMetadataOptions' => '<p>Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyInstancePlacement' => '<p>Modifies the placement attributes for a specified instance. You can do the following:</p> <ul> <li> <p>Modify the affinity between an instance and a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Host</a>. When affinity is set to <code>host</code> and the instance is not associated with a specific Dedicated Host, the next time the instance is started, it is automatically associated with the host on which it lands. If the instance is restarted or rebooted, this relationship persists.</p> </li> <li> <p>Change the Dedicated Host with which an instance is associated.</p> </li> <li> <p>Change the instance tenancy of an instance.</p> </li> <li> <p>Move an instance to or from a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">placement group</a>.</p> </li> </ul> <p>At least one attribute for affinity, host ID, tenancy, or placement group name must be specified in the request. Affinity and tenancy can be modified in the same request.</p> <p>To modify the host ID, tenancy, placement group, or partition for an instance, the instance must be in the <code>stopped</code> state.</p>', 'ModifyIpam' => '<p>Modify the configurations of an IPAM. </p>', 'ModifyIpamPool' => '<p>Modify the configurations of an IPAM pool.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/mod-pool-ipam.html">Modify a pool</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'ModifyIpamResourceCidr' => '<p>Modify a resource CIDR. You can use this action to transfer resource CIDRs between scopes and ignore resource CIDRs that you do not want to manage. If set to false, the resource will not be tracked for overlap, it cannot be auto-imported into a pool, and it will be removed from any pool it has an allocation in.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/move-resource-ipam.html">Move resource CIDRs between scopes</a> and <a href="https://docs.aws.amazon.com/vpc/latest/ipam/change-monitoring-state-ipam.html">Change the monitoring state of resource CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'ModifyIpamResourceDiscovery' => '<p>Modifies a resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.</p>', 'ModifyIpamScope' => '<p>Modify an IPAM scope.</p>', 'ModifyLaunchTemplate' => '<p>Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.</p>', 'ModifyLocalGatewayRoute' => '<p>Modifies the specified local gateway route.</p>', 'ModifyManagedPrefixList' => '<p>Modifies the specified managed prefix list.</p> <p>Adding or removing entries in a prefix list creates a new version of the prefix list. Changing the name of the prefix list does not affect the version.</p> <p>If you specify a current version number that does not match the true current version number, the request fails.</p>', 'ModifyNetworkInterfaceAttribute' => '<p>Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.</p>', 'ModifyPrivateDnsNameOptions' => '<p>Modifies the options for instance hostnames for the specified instance.</p>', 'ModifyReservedInstances' => '<p>Modifies the configuration of your Reserved Instances, such as the Availability Zone, instance count, or instance type. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modify Reserved Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifySecurityGroupRules' => '<p>Modifies the rules of a security group.</p>', 'ModifySnapshotAttribute' => '<p>Adds or removes permission settings for the specified snapshot. You may add or remove specified Amazon Web Services account IDs from a snapshot\'s list of create volume permissions, but you cannot do both in a single operation. If you need to both add and remove account IDs for a snapshot, you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.</p> <p>Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made public. Snapshots encrypted with your default KMS key cannot be shared with other accounts.</p> <p>For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-modifying-snapshot-permissions.html">Share a snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>', 'ModifySnapshotTier' => '<p>Archives an Amazon EBS snapshot. When you archive a snapshot, it is converted to a full snapshot that includes all of the blocks of data that were written to the volume at the time the snapshot was created, and moved from the standard tier to the archive tier. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshot-archive.html">Archive Amazon EBS snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>', 'ModifySpotFleetRequest' => '<p>Modifies the specified Spot Fleet request.</p> <p>You can only modify a Spot Fleet request of type <code>maintain</code>.</p> <p>While the Spot Fleet request is being modified, it is in the <code>modifying</code> state.</p> <p>To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the additional Spot Instances according to the allocation strategy for the Spot Fleet request. If the allocation strategy is <code>lowestPrice</code>, the Spot Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is <code>diversified</code>, the Spot Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is <code>capacityOptimized</code>, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p> <p>To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet cancels any open requests that exceed the new target capacity. You can request that the Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowestPrice</code>, the Spot Fleet terminates the instances with the highest price per unit. If the allocation strategy is <code>capacityOptimized</code>, the Spot Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is <code>diversified</code>, the Spot Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually.</p> <p>If you are finished with your Spot Fleet for now, but will use it again later, you can set the target capacity to 0.</p>', 'ModifySubnetAttribute' => '<p>Modifies a subnet attribute. You can only modify one attribute at a time.</p> <p>Use this action to modify subnets on Amazon Web Services Outposts.</p> <ul> <li> <p>To modify a subnet on an Outpost rack, set both <code>MapCustomerOwnedIpOnLaunch</code> and <code>CustomerOwnedIpv4Pool</code>. These two parameters act as a single attribute.</p> </li> <li> <p>To modify a subnet on an Outpost server, set either <code>EnableLniAtDeviceIndex</code> or <code>DisableLniAtDeviceIndex</code>.</p> </li> </ul> <p>For more information about Amazon Web Services Outposts, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/outposts/latest/userguide/how-servers-work.html">Outpost servers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/outposts/latest/userguide/how-racks-work.html">Outpost racks</a> </p> </li> </ul>', 'ModifyTrafficMirrorFilterNetworkServices' => '<p>Allows or restricts mirroring network services.</p> <p> By default, Amazon DNS network services are not eligible for Traffic Mirror. Use <code>AddNetworkServices</code> to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored. When you no longer want to mirror network services, use <code>RemoveNetworkServices</code> to remove the network services from the Traffic Mirror filter. </p>', 'ModifyTrafficMirrorFilterRule' => '<p>Modifies the specified Traffic Mirror rule.</p> <p> <code>DestinationCidrBlock</code> and <code>SourceCidrBlock</code> must both be an IPv4 range or an IPv6 range.</p>', 'ModifyTrafficMirrorSession' => '<p>Modifies a Traffic Mirror session.</p>', 'ModifyTransitGateway' => '<p>Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.</p>', 'ModifyTransitGatewayPrefixListReference' => '<p>Modifies a reference (route) to a prefix list in a specified transit gateway route table.</p>', 'ModifyTransitGatewayVpcAttachment' => '<p>Modifies the specified VPC attachment.</p>', 'ModifyVerifiedAccessEndpoint' => '<p>Modifies the configuration of the specified Amazon Web Services Verified Access endpoint.</p>', 'ModifyVerifiedAccessEndpointPolicy' => '<p>Modifies the specified Amazon Web Services Verified Access endpoint policy.</p>', 'ModifyVerifiedAccessGroup' => '<p>Modifies the specified Amazon Web Services Verified Access group configuration.</p>', 'ModifyVerifiedAccessGroupPolicy' => '<p>Modifies the specified Amazon Web Services Verified Access group policy.</p>', 'ModifyVerifiedAccessInstance' => '<p>Modifies the configuration of the specified Amazon Web Services Verified Access instance.</p>', 'ModifyVerifiedAccessInstanceLoggingConfiguration' => '<p>Modifies the logging configuration for the specified Amazon Web Services Verified Access instance.</p>', 'ModifyVerifiedAccessTrustProvider' => '<p>Modifies the configuration of the specified Amazon Web Services Verified Access trust provider.</p>', 'ModifyVolume' => '<p>You can modify several parameters of an existing EBS volume, including volume size, volume type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance type, you might be able to apply these changes without stopping the instance or detaching the volume from it. For more information about modifying EBS volumes, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-modify-volume.html">Amazon EBS Elastic Volumes</a> in the <i>Amazon EBS User Guide</i>.</p> <p>When you complete a resize operation on your volume, you need to extend the volume\'s file-system size to take advantage of the new storage capacity. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/recognize-expanded-volume-linux.html">Extend the file system</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-modifications.html">Monitor the progress of volume modifications</a> in the <i>Amazon EBS User Guide</i>.</p> <p>With previous-generation instance types, resizing an EBS volume might require detaching and reattaching the volume or stopping and restarting the instance.</p> <p>After modifying a volume, you must wait at least six hours and ensure that the volume is in the <code>in-use</code> or <code>available</code> state before you can modify the same volume. This is sometimes referred to as a cooldown period.</p>', 'ModifyVolumeAttribute' => '<p>Modifies a volume attribute.</p> <p>By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume.</p> <p>You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.</p>', 'ModifyVpcAttribute' => '<p>Modifies the specified attribute of the specified VPC.</p>', 'ModifyVpcEndpoint' => '<p>Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink Guide</a>.</p>', 'ModifyVpcEndpointConnectionNotification' => '<p>Modifies a connection notification for VPC endpoint or VPC endpoint service. You can change the SNS topic for the notification, or the events for which to be notified. </p>', 'ModifyVpcEndpointServiceConfiguration' => '<p>Modifies the attributes of your VPC endpoint service configuration. You can change the Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is required for requests to connect to your endpoint service through an interface VPC endpoint.</p> <p>If you set or modify the private DNS name, you must prove that you own the private DNS domain name.</p>', 'ModifyVpcEndpointServicePayerResponsibility' => '<p>Modifies the payer responsibility for your VPC endpoint service.</p>', 'ModifyVpcEndpointServicePermissions' => '<p>Modifies the permissions for your VPC endpoint service. You can add or remove permissions for service consumers (Amazon Web Services accounts, users, and IAM roles) to connect to your endpoint service.</p> <p>If you grant permissions to all principals, the service is public. Any users who know the name of a public service can send a request to attach an endpoint. If the service does not require manual approval, attachments are automatically approved.</p>', 'ModifyVpcPeeringConnectionOptions' => '<p>Modifies the VPC peering connection options on one side of a VPC peering connection.</p> <p>If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP addresses in the peer VPC. This option is not available if the peered VPCs are in different Amazon Web Services accounts or different Regions. For peered VPCs in different Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request to modify the peering connection options. For inter-region peering connections, you must use the Region for the requester VPC to modify the requester VPC peering options and the Region for the accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and the requester for a VPC peering connection, use the <a>DescribeVpcPeeringConnections</a> command.</p>', 'ModifyVpcTenancy' => '<p>Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a VPC to <code>default</code> only. You cannot change the instance tenancy attribute to <code>dedicated</code>.</p> <p>After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of <code>default</code>, unless you specify otherwise during launch. The tenancy of any existing instances in the VPC is not affected.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyVpnConnection' => '<p>Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:</p> <ul> <li> <p>An existing virtual private gateway to a new virtual private gateway</p> </li> <li> <p>An existing virtual private gateway to a transit gateway</p> </li> <li> <p>An existing transit gateway to a new transit gateway</p> </li> <li> <p>An existing transit gateway to a virtual private gateway</p> </li> </ul> <p>Before you perform the migration to the new gateway, you must configure the new gateway. Use <a>CreateVpnGateway</a> to create a virtual private gateway, or <a>CreateTransitGateway</a> to create a transit gateway.</p> <p>This step is required when you migrate from a virtual private gateway with static routes to a transit gateway. </p> <p>You must delete the static routes before you migrate to the new gateway.</p> <p>Keep a copy of the static route before you delete it. You will need to add back these routes to the transit gateway after the VPN connection migration is complete.</p> <p>After you migrate to the new gateway, you might need to modify your VPC route table. Use <a>CreateRoute</a> and <a>DeleteRoute</a> to make the changes described in <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing">Update VPC route tables</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p> <p>When the new gateway is a transit gateway, modify the transit gateway route table to allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection. Use <a>CreateTransitGatewayRoute</a> to add the routes.</p> <p> If you deleted VPN static routes, you must add the static routes to the transit gateway route table.</p> <p>After you perform this operation, the VPN endpoint\'s IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will be temporarily unavailable for a brief period while we provision the new endpoints.</p>', 'ModifyVpnConnectionOptions' => '<p>Modifies the connection options for your Site-to-Site VPN connection.</p> <p>When you modify the VPN connection options, the VPN endpoint IP addresses on the Amazon Web Services side do not change, and the tunnel options do not change. Your VPN connection will be temporarily unavailable for a brief period while the VPN connection is updated.</p>', 'ModifyVpnTunnelCertificate' => '<p>Modifies the VPN tunnel endpoint certificate.</p>', 'ModifyVpnTunnelOptions' => '<p>Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify multiple options for a tunnel in a single request, but you can only modify one tunnel at a time. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html">Site-to-Site VPN tunnel options for your Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>', 'MonitorInstances' => '<p>Enables detailed monitoring for a running instance. Otherwise, basic monitoring is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitor your instances using CloudWatch</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>To disable detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnmonitorInstances.html">UnmonitorInstances</a>.</p>', 'MoveAddressToVpc' => '<note> <p>This action is deprecated.</p> </note> <p>Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the <a>RestoreAddressToClassic</a> request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.</p>', 'MoveByoipCidrToIpam' => '<p>Move a BYOIPv4 CIDR to IPAM from a public IPv4 pool.</p> <p>If you already have a BYOIPv4 CIDR with Amazon Web Services, you can move the CIDR to IPAM from a public IPv4 pool. You cannot move an IPv6 CIDR to IPAM. If you are bringing a new IP address to Amazon Web Services for the first time, complete the steps in <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoip-ipam.html">Tutorial: BYOIP address CIDRs to IPAM</a>.</p>', 'MoveCapacityReservationInstances' => '<p>Move available capacity from a source Capacity Reservation to a destination Capacity Reservation. The source Capacity Reservation and the destination Capacity Reservation must be <code>active</code>, owned by your Amazon Web Services account, and share the following: </p> <ul> <li> <p>Instance type</p> </li> <li> <p>Platform</p> </li> <li> <p>Availability Zone</p> </li> <li> <p>Tenancy</p> </li> <li> <p>Placement group</p> </li> <li> <p>Capacity Reservation end time - <code>At specific time</code> or <code>Manually</code>.</p> </li> </ul>', 'ProvisionByoipCidr' => '<p>Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using <a>AdvertiseByoipCidr</a>.</p> <p>Amazon Web Services verifies that you own the address range and are authorized to advertise it. You must ensure that the address range is registered to you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring your own IP addresses (BYOIP)</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Provisioning an address range is an asynchronous operation, so the call returns immediately, but the address range is not ready to use until its status changes from <code>pending-provision</code> to <code>provisioned</code>. To monitor the status of an address range, use <a>DescribeByoipCidrs</a>. To allocate an Elastic IP address from your IPv4 address pool, use <a>AllocateAddress</a> with either the specific address from the address pool or the ID of the address pool.</p>', 'ProvisionIpamByoasn' => '<p>Provisions your Autonomous System Number (ASN) for use in your Amazon Web Services account. This action requires authorization context for Amazon to bring the ASN to an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p>', 'ProvisionIpamPoolCidr' => '<p>Provision a CIDR to an IPAM pool. You can use this action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/prov-cidr-ipam.html">Provision CIDRs to pools</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'ProvisionPublicIpv4PoolCidr' => '<p>Provision a CIDR to a public IPv4 pool.</p> <p>For more information about IPAM, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'PurchaseCapacityBlock' => '<p>Purchase the Capacity Block for use with your account. With Capacity Blocks you ensure GPU capacity is available for machine learning (ML) workloads. You must specify the ID of the Capacity Block offering you are purchasing.</p>', 'PurchaseHostReservation' => '<p>Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.</p>', 'PurchaseReservedInstancesOffering' => '<p>Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing.</p> <p>Use <a>DescribeReservedInstancesOfferings</a> to get a list of Reserved Instance offerings that match your specifications. After you\'ve purchased a Reserved Instance, you can check for your new Reserved Instance with <a>DescribeReservedInstances</a>.</p> <p>To queue a purchase for a future date and time, specify a purchase time. If you do not specify a purchase time, the default is the current time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'PurchaseScheduledInstances' => '<note> <p>You can no longer purchase Scheduled Instances.</p> </note> <p>Purchases the Scheduled Instances with the specified schedule.</p> <p>Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call <a>DescribeScheduledInstanceAvailability</a> to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call <a>RunScheduledInstances</a> during each scheduled time period.</p> <p>After you purchase a Scheduled Instance, you can\'t cancel, modify, or resell your purchase.</p>', 'RebootInstances' => '<p>Requests a reboot of the specified instances. This operation is asynchronous; it only queues a request to reboot the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot terminated instances are ignored.</p> <p>If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a hard reboot.</p> <p>For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Troubleshoot an unreachable instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RegisterImage' => '<p>Registers an AMI. When you\'re creating an instance-store backed AMI, registering the AMI is the final step in the creation process. For more information about creating AMIs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot">Create an AMI from a snapshot</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-instance-store.html">Create an instance-store backed AMI</a> in the <i>Amazon EC2 User Guide</i>.</p> <note> <p>For Amazon EBS-backed instances, <a>CreateImage</a> creates and registers the AMI in a single request, so you don\'t have to register the AMI yourself. We recommend that you always use <a>CreateImage</a> unless you have a specific reason to use RegisterImage.</p> </note> <p>If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.</p> <p> <b>Register a snapshot of a root device volume</b> </p> <p>You can use <code>RegisterImage</code> to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. You specify the snapshot using a block device mapping. You can\'t set the encryption state of the volume using the block device mapping. If the snapshot is encrypted, or encryption by default is enabled, the root volume of an instance launched from the AMI is encrypted.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot">Create an AMI from a snapshot</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Use encryption with Amazon EBS-backed AMIs</a> in the <i>Amazon EC2 User Guide</i>.</p> <p> <b>Amazon Web Services Marketplace product codes</b> </p> <p>If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new AMI.</p> <p>In most cases, AMIs for Windows, RedHat, SUSE, and SQL Server require correct licensing information to be present on the AMI. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI billing information</a> in the <i>Amazon EC2 User Guide</i>. When creating an AMI from a snapshot, the <code>RegisterImage</code> operation derives the correct billing information from the snapshot\'s metadata, but this requires the appropriate metadata to be present. To verify if the correct billing information was applied, check the <code>PlatformDetails</code> field on the new AMI. If the field is empty or doesn\'t match the expected operating system code (for example, Windows, RedHat, SUSE, or SQL), the AMI creation was unsuccessful, and you should discard the AMI and instead create the AMI from an instance using <a>CreateImage</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#how-to-create-ebs-ami">Create an AMI from an instance </a> in the <i>Amazon EC2 User Guide</i>.</p> <p>If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched from an AMI with a billing product code, make sure that the Reserved Instance has the matching billing product code. If you purchase a Reserved Instance without the matching billing product code, the Reserved Instance will not be applied to the On-Demand Instance. For information about how to obtain the platform details and billing information of an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI billing information</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RegisterInstanceEventNotificationAttributes' => '<p>Registers a set of tag keys to include in scheduled event notifications for your resources. </p> <p>To remove tags, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterInstanceEventNotificationAttributes.html">DeregisterInstanceEventNotificationAttributes</a>.</p>', 'RegisterTransitGatewayMulticastGroupMembers' => '<p>Registers members (network interfaces) with the transit gateway multicast group. A member is a network interface associated with a supported EC2 instance that receives multicast traffic. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html">Multicast on transit gateways</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.</p> <p>After you add the members, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups</a> to verify that the members were added to the transit gateway multicast group.</p>', 'RegisterTransitGatewayMulticastGroupSources' => '<p>Registers sources (network interfaces) with the specified transit gateway multicast group.</p> <p>A multicast source is a network interface attached to a supported instance that sends multicast traffic. For more information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html">Multicast on transit gateways</a> in the <i>Amazon Web Services Transit Gateways Guide</i>.</p> <p>After you add the source, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups</a> to verify that the source was added to the multicast group.</p>', 'RejectTransitGatewayMulticastDomainAssociations' => '<p>Rejects a request to associate cross-account subnets with a transit gateway multicast domain.</p>', 'RejectTransitGatewayPeeringAttachment' => '<p>Rejects a transit gateway peering attachment request.</p>', 'RejectTransitGatewayVpcAttachment' => '<p>Rejects a request to attach a VPC to a transit gateway.</p> <p>The VPC attachment must be in the <code>pendingAcceptance</code> state. Use <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use <a>AcceptTransitGatewayVpcAttachment</a> to accept a VPC attachment request.</p>', 'RejectVpcEndpointConnections' => '<p>Rejects VPC endpoint connection requests to your VPC endpoint service.</p>', 'RejectVpcPeeringConnection' => '<p>Rejects a VPC peering connection request. The VPC peering connection must be in the <code>pending-acceptance</code> state. Use the <a>DescribeVpcPeeringConnections</a> request to view your outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC peering connection request that you initiated, use <a>DeleteVpcPeeringConnection</a>.</p>', 'ReleaseAddress' => '<p>Releases the specified Elastic IP address.</p> <p>[Default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it\'s associated with. To disassociate an Elastic IP address without releasing it, use <a>DisassociateAddress</a>.</p> <p>[Nondefault VPC] You must use <a>DisassociateAddress</a> to disassociate the Elastic IP address before you can release it. Otherwise, Amazon EC2 returns an error (<code>InvalidIPAddress.InUse</code>).</p> <p>After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you\'ll get an <code>AuthFailure</code> error if the address is already allocated to another Amazon Web Services account.</p> <p>After you release an Elastic IP address, you might be able to recover it. For more information, see <a>AllocateAddress</a>.</p>', 'ReleaseHosts' => '<p>When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into <code>released</code> state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, for example, to modify the host. You must stop or terminate all instances on a host before it can be released.</p> <p>When Dedicated Hosts are released, it may take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated Hosts. Wait a few minutes and then try again.</p> <p>Released hosts still appear in a <a>DescribeHosts</a> response.</p>', 'ReleaseIpamPoolAllocation' => '<p>Release an allocation within an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations. You can only use this action to release manual allocations. To remove an allocation for a resource without deleting the resource, set its monitored state to false using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIpamResourceCidr.html">ModifyIpamResourceCidr</a>. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/release-alloc-ipam.html">Release an allocation</a> in the <i>Amazon VPC IPAM User Guide</i>. </p> <note> <p>All EC2 API actions follow an <a href="https://docs.aws.amazon.com/ec2/latest/devguide/eventual-consistency.html">eventual consistency</a> model.</p> </note>', 'ReplaceIamInstanceProfileAssociation' => '<p>Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM instance profile that\'s associated with an instance without having to disassociate the existing IAM instance profile first.</p> <p>Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.</p>', 'ReplaceNetworkAclAssociation' => '<p>Changes which network ACL a subnet is associated with. By default when you create a subnet, it\'s automatically associated with the default network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon VPC User Guide</i>.</p> <p>This is an idempotent operation.</p>', 'ReplaceNetworkAclEntry' => '<p>Replaces an entry (rule) in a network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon VPC User Guide</i>.</p>', 'ReplaceRoute' => '<p>Replaces an existing route within a route table in a VPC.</p> <p>You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list, or reset the local route to its default target.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p>', 'ReplaceRouteTableAssociation' => '<p>Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon VPC User Guide</i>.</p> <p>You can also use this operation to change which table is the main route table in the VPC. Specify the main route table\'s association ID and the route table ID of the new main route table.</p>', 'ReplaceTransitGatewayRoute' => '<p>Replaces the specified route in the specified transit gateway route table.</p>', 'ReplaceVpnTunnel' => '<p>Trigger replacement of specified VPN tunnel.</p>', 'ReportInstanceStatus' => '<p>Submits feedback about the status of an instance. The instance must be in the <code>running</code> state. If your experience with the instance differs from the instance status returned by <a>DescribeInstanceStatus</a>, use <a>ReportInstanceStatus</a> to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks.</p> <p>Use of this action does not change the value returned by <a>DescribeInstanceStatus</a>.</p>', 'RequestSpotFleet' => '<p>Creates a Spot Fleet request.</p> <p>The Spot Fleet request specifies the total target capacity and the On-Demand target capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity.</p> <p>You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p> <p>By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload.</p> <p>Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet.</p> <p>You can specify tags for the Spot Fleet request and instances launched by the fleet. You cannot tag other resource types in a Spot Fleet request because only the <code>spot-fleet-request</code> and <code>instance</code> resource types are supported.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet requests</a> in the <i>Amazon EC2 User Guide</i>.</p> <important> <p>We strongly discourage using the RequestSpotFleet API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use">Which is the best Spot request method to use?</a> in the <i>Amazon EC2 User Guide</i>.</p> </important>', 'RequestSpotInstances' => '<p>Creates a Spot Instance request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Work with Spot Instance</a> in the <i>Amazon EC2 User Guide</i>.</p> <important> <p>We strongly discourage using the RequestSpotInstances API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use">Which is the best Spot request method to use?</a> in the <i>Amazon EC2 User Guide</i>.</p> </important>', 'ResetAddressAttribute' => '<p>Resets the attribute of the specified IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications</a>.</p>', 'ResetEbsDefaultKmsKeyId' => '<p>Resets the default KMS key for EBS encryption for your account in this Region to the Amazon Web Services managed KMS key for EBS.</p> <p>After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a customer managed KMS key by specifying it when you create the volume. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'ResetFpgaImageAttribute' => '<p>Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset the load permission attribute.</p>', 'ResetImageAttribute' => '<p>Resets an attribute of an AMI to its default value.</p>', 'ResetInstanceAttribute' => '<p>Resets an attribute of an instance to its default value. To reset the <code>kernel</code> or <code>ramdisk</code>, the instance must be in a stopped state. To reset the <code>sourceDestCheck</code>, the instance can be either running or stopped.</p> <p>The <code>sourceDestCheck</code> attribute controls whether source/destination checking is enabled. The default value is <code>true</code>, which means checking is enabled. This value must be <code>false</code> for a NAT instance to perform NAT. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT instances</a> in the <i>Amazon VPC User Guide</i>.</p>', 'ResetNetworkInterfaceAttribute' => '<p>Resets a network interface attribute. You can specify only one attribute at a time.</p>', 'ResetSnapshotAttribute' => '<p>Resets permission settings for the specified snapshot.</p> <p>For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-modifying-snapshot-permissions.html">Share a snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>', 'RestoreAddressToClassic' => '<note> <p>This action is deprecated.</p> </note> <p>Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.</p>', 'RestoreImageFromRecycleBin' => '<p>Restores an AMI from the Recycle Bin. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RestoreManagedPrefixListVersion' => '<p>Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.</p>', 'RestoreSnapshotFromRecycleBin' => '<p>Restores a snapshot from the Recycle Bin. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/recycle-bin-working-with-snaps.html#recycle-bin-restore-snaps">Restore snapshots from the Recycle Bin</a> in the <i>Amazon EBS User Guide</i>.</p>', 'RestoreSnapshotTier' => '<p>Restores an archived Amazon EBS snapshot for use temporarily or permanently, or modifies the restore period or restore type for a snapshot that was previously temporarily restored.</p> <p>For more information see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/working-with-snapshot-archiving.html#restore-archived-snapshot"> Restore an archived snapshot</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/working-with-snapshot-archiving.html#modify-temp-restore-period"> modify the restore period or restore type for a temporarily restored snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>', 'RevokeClientVpnIngress' => '<p>Removes an ingress authorization rule from a Client VPN endpoint. </p>', 'RevokeSecurityGroupEgress' => '<p>Removes the specified outbound (egress) rules from the specified security group.</p> <p>You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule\'s values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule.</p> <p>For a default VPC, if the values you specify do not match the existing rule\'s values, no error is returned, and the output describes the security group rules that were not revoked.</p> <p>Amazon Web Services recommends that you describe the security group to verify that the rules were removed.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RevokeSecurityGroupIngress' => '<p>Removes the specified inbound (ingress) rules from a security group.</p> <p>You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule\'s values exactly. Each rule has a protocol, from and to ports, and source (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule.</p> <p>For a default VPC, if the values you specify do not match the existing rule\'s values, no error is returned, and the output describes the security group rules that were not revoked.</p> <p>For a non-default VPC, if the values you specify do not match the existing rule\'s values, an <code>InvalidPermission.NotFound</code> client error is returned, and no rules are revoked.</p> <p>Amazon Web Services recommends that you describe the security group to verify that the rules were removed.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RunInstances' => '<p>Launches the specified number of instances using an AMI for which you have permissions.</p> <p>You can specify a number of options, or leave the default options. The following rules apply:</p> <ul> <li> <p>If you don\'t specify a subnet ID, we choose a default subnet from your default VPC for you. If you don\'t have a default VPC, you must specify a subnet ID in the request.</p> </li> <li> <p>All instances have a network interface with a primary private IPv4 address. If you don\'t specify this address, we choose one from the IPv4 range of your subnet.</p> </li> <li> <p>Not all instance types support IPv6 addresses. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a>.</p> </li> <li> <p>If you don\'t specify a security group ID, we use the default security group for the VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security groups</a>.</p> </li> <li> <p>If any of the AMIs have a product code attached for which the user has not subscribed, the request fails.</p> </li> </ul> <p>You can create a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template</a>, which is a resource that contains the parameters to launch an instance. When you launch an instance using <a>RunInstances</a>, you can specify the launch template instead of specifying the launch parameters.</p> <p>To ensure faster instance launches, break up large requests into smaller batches. For example, create five separate launch requests for 100 instances each instead of one launch request for 500 instances.</p> <p> <code>RunInstances</code> is subject to both request rate limiting and resource rate limiting. For more information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-throttling.html">Request throttling</a>.</p> <p>An instance is ready for you to use when it\'s in the <code>running</code> state. You can check the state of your instance using <a>DescribeInstances</a>. You can tag instances and EBS volumes during launch, after launch, or both. For more information, see <a>CreateTags</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>.</p> <p>Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key pairs</a>.</p> <p>For troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What to do if an instance immediately terminates</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting connecting to your instance</a>.</p>', 'RunScheduledInstances' => '<p>Launches the specified Scheduled Instances.</p> <p>Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using <a>PurchaseScheduledInstances</a>.</p> <p>You must launch a Scheduled Instance during its scheduled time period. You can\'t stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes.</p>', 'SearchLocalGatewayRoutes' => '<p>Searches for routes in the specified local gateway route table.</p>', 'SearchTransitGatewayMulticastGroups' => '<p>Searches one or more transit gateway multicast groups and returns the group membership information.</p>', 'SearchTransitGatewayRoutes' => '<p>Searches for routes in the specified transit gateway route table.</p>', 'SendDiagnosticInterrupt' => '<p>Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a <i>kernel panic</i> (on Linux instances), or a <i>blue screen</i>/<i>stop error</i> (on Windows instances). For instances based on Intel and AMD processors, the interrupt is received as a <i>non-maskable interrupt</i> (NMI).</p> <p>In general, the operating system crashes and reboots when a kernel panic or stop error is triggered. The operating system can also be configured to perform diagnostic tasks, such as generating a memory dump file, loading a secondary kernel, or obtaining a call trace.</p> <p>Before sending a diagnostic interrupt to your instance, ensure that its operating system is configured to perform the required diagnostic tasks.</p> <p>For more information about configuring your operating system to generate a crash dump when a kernel panic or stop error occurs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html">Send a diagnostic interrupt (for advanced users)</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'StartInstances' => '<p>Starts an Amazon EBS-backed instance that you\'ve previously stopped.</p> <p>Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance is stopped, the compute resources are released and you are not billed for instance usage. However, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. You can restart your instance at any time. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage.</p> <p>Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM.</p> <p>Performing this operation on an instance that uses an instance store as its root device returns an error.</p> <p>If you attempt to start a T3 instance with <code>host</code> tenancy and the <code>unlimited</code> CPU credit option, the request fails. The <code>unlimited</code> CPU credit option is not supported on Dedicated Hosts. Before you start the instance, either change its CPU credit option to <code>standard</code>, or change its tenancy to <code>default</code> or <code>dedicated</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stop and start Amazon EC2 instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'StartNetworkInsightsAccessScopeAnalysis' => '<p>Starts analyzing the specified Network Access Scope.</p>', 'StartNetworkInsightsAnalysis' => '<p>Starts analyzing the specified path. If the path is reachable, the operation returns the shortest feasible path.</p>', 'StartVpcEndpointServicePrivateDnsVerification' => '<p>Initiates the verification process to prove that the service provider owns the private DNS name domain for the endpoint service.</p> <p>The service provider must successfully perform the verification before the consumer can use the name to access the service.</p> <p>Before the service provider runs this command, they must add a record to the DNS server.</p>', 'StopInstances' => '<p>Stops an Amazon EBS-backed instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stop and start Amazon EC2 instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>You can use the Stop action to hibernate an instance if the instance is <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enabling-hibernation.html">enabled for hibernation</a> and it meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2 instance</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>We don\'t charge usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage.</p> <p>You can\'t stop or hibernate instance store-backed instances. You can\'t use the Stop action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate Spot Instances when they are interrupted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-interruptions.html#hibernate-spot-instances">Hibernating interrupted Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>When you stop or hibernate an instance, we shut it down. You can restart your instance at any time. Before stopping or hibernating an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM, but hibernating an instance does preserve data stored in RAM. If an instance cannot hibernate successfully, a normal shutdown occurs.</p> <p>Stopping and hibernating an instance is different to rebooting or terminating it. For example, when you stop or hibernate an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, the root device and any other devices attached during the instance launch are automatically deleted. For more information about the differences between rebooting, stopping, hibernating, and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshoot stopping your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'TerminateClientVpnConnections' => '<p>Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.</p>', 'TerminateInstances' => '<p>Shuts down the specified instances. This operation is idempotent; if you terminate an instance more than once, each call succeeds. </p> <p>If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID), none of the instances are terminated.</p> <p>If you terminate multiple instances across multiple Availability Zones, and one or more of the specified instances are enabled for termination protection, the request fails with the following results:</p> <ul> <li> <p>The specified instances that are in the same Availability Zone as the protected instance are not terminated.</p> </li> <li> <p>The specified instances that are in different Availability Zones, where no other specified instances are protected, are successfully terminated.</p> </li> </ul> <p>For example, say you have the following instances:</p> <ul> <li> <p>Instance A: <code>us-east-1a</code>; Not protected</p> </li> <li> <p>Instance B: <code>us-east-1a</code>; Not protected</p> </li> <li> <p>Instance C: <code>us-east-1b</code>; Protected</p> </li> <li> <p>Instance D: <code>us-east-1b</code>; not protected</p> </li> </ul> <p>If you attempt to terminate all of these instances in the same request, the request reports failure with the following results:</p> <ul> <li> <p>Instance A and Instance B are successfully terminated because none of the specified instances in <code>us-east-1a</code> are enabled for termination protection.</p> </li> <li> <p>Instance C and Instance D fail to terminate because at least one of the specified instances in <code>us-east-1b</code> (Instance C) is enabled for termination protection.</p> </li> </ul> <p>Terminated instances remain visible after termination (for approximately one hour).</p> <p>By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached after instance launch continue running.</p> <p>You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances. What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, any attached EBS volumes with the <code>DeleteOnTermination</code> block device mapping parameter set to <code>true</code> are automatically deleted. For more information about the differences between stopping and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting terminating your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'UnassignIpv6Addresses' => '<p>Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.</p>', 'UnassignPrivateIpAddresses' => '<p>Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.</p>', 'UnassignPrivateNatGatewayAddress' => '<p>Unassigns secondary private IPv4 addresses from a private NAT gateway. You cannot unassign your primary private IP. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-edit-secondary">Edit secondary IP address associations</a> in the <i>Amazon VPC User Guide</i>.</p> <p>While unassigning is in progress, you cannot assign/unassign additional IP addresses while the connections are being drained. You are, however, allowed to delete the NAT gateway.</p> <p>A private IP address will only be released at the end of MaxDrainDurationSeconds. The private IP addresses stay associated and support the existing connections, but do not support any new connections (new connections are distributed across the remaining assigned private IP address). After the existing connections drain out, the private IP addresses are released.</p> <p/> <p/>', 'UnlockSnapshot' => '<p>Unlocks a snapshot that is locked in governance mode or that is locked in compliance mode but still in the cooling-off period. You can\'t unlock a snapshot that is locked in compliance mode after the cooling-off period has expired.</p>', 'UnmonitorInstances' => '<p>Disables detailed monitoring for a running instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring your instances and volumes</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgress' => '<p>Updates the description of an egress (outbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.</p>', 'UpdateSecurityGroupRuleDescriptionsIngress' => '<p>Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.</p>', 'WithdrawByoipCidr' => '<p>Stops advertising an address range that is provisioned as an address pool.</p> <p>You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p> <p>It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of BGP propagation delays.</p>', ], 'shapes' => [ 'AcceleratorCount' => [ 'base' => '<p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance.</p>', 'refs' => [ 'InstanceRequirements$AcceleratorCount' => '<p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance.</p> <p>To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'AcceleratorCountRequest' => [ 'base' => '<p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.</p>', 'refs' => [ 'InstanceRequirementsRequest$AcceleratorCount' => '<p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance.</p> <p>To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'AcceleratorManufacturer' => [ 'base' => NULL, 'refs' => [ 'AcceleratorManufacturerSet$member' => NULL, ], ], 'AcceleratorManufacturerSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorManufacturers' => '<p>Indicates whether instance types must have accelerators by specific manufacturers.</p> <ul> <li> <p>For instance types with Amazon Web Services devices, specify <code>amazon-web-services</code>.</p> </li> <li> <p>For instance types with AMD devices, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Habana devices, specify <code>habana</code>.</p> </li> <li> <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p> </li> <li> <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p> </li> </ul> <p>Default: Any manufacturer</p>', 'InstanceRequirementsRequest$AcceleratorManufacturers' => '<p>Indicates whether instance types must have accelerators by specific manufacturers.</p> <ul> <li> <p>For instance types with Amazon Web Services devices, specify <code>amazon-web-services</code>.</p> </li> <li> <p>For instance types with AMD devices, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Habana devices, specify <code>habana</code>.</p> </li> <li> <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p> </li> <li> <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p> </li> </ul> <p>Default: Any manufacturer</p>', ], ], 'AcceleratorName' => [ 'base' => NULL, 'refs' => [ 'AcceleratorNameSet$member' => NULL, ], ], 'AcceleratorNameSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorNames' => '<p>The accelerators that must be on the instance type.</p> <ul> <li> <p>For instance types with NVIDIA A10G GPUs, specify <code>a10g</code>.</p> </li> <li> <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p> </li> <li> <p>For instance types with NVIDIA H100 GPUs, specify <code>h100</code>.</p> </li> <li> <p>For instance types with Amazon Web Services Inferentia chips, specify <code>inferentia</code>.</p> </li> <li> <p>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code>.</p> </li> <li> <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p> </li> <li> <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p> </li> <li> <p>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code>.</p> </li> <li> <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p> </li> <li> <p>For instance types with NVIDIA T4G GPUs, specify <code>t4g</code>.</p> </li> <li> <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p> </li> <li> <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p> </li> </ul> <p>Default: Any accelerator</p>', 'InstanceRequirementsRequest$AcceleratorNames' => '<p>The accelerators that must be on the instance type.</p> <ul> <li> <p>For instance types with NVIDIA A10G GPUs, specify <code>a10g</code>.</p> </li> <li> <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p> </li> <li> <p>For instance types with NVIDIA H100 GPUs, specify <code>h100</code>.</p> </li> <li> <p>For instance types with Amazon Web Services Inferentia chips, specify <code>inferentia</code>.</p> </li> <li> <p>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code>.</p> </li> <li> <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p> </li> <li> <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p> </li> <li> <p>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code>.</p> </li> <li> <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p> </li> <li> <p>For instance types with NVIDIA T4G GPUs, specify <code>t4g</code>.</p> </li> <li> <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p> </li> <li> <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p> </li> </ul> <p>Default: Any accelerator</p>', ], ], 'AcceleratorTotalMemoryMiB' => [ 'base' => '<p>The minimum and maximum amount of total accelerator memory, in MiB.</p>', 'refs' => [ 'InstanceRequirements$AcceleratorTotalMemoryMiB' => '<p>The minimum and maximum amount of total accelerator memory, in MiB.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'AcceleratorTotalMemoryMiBRequest' => [ 'base' => '<p>The minimum and maximum amount of total accelerator memory, in MiB.</p>', 'refs' => [ 'InstanceRequirementsRequest$AcceleratorTotalMemoryMiB' => '<p>The minimum and maximum amount of total accelerator memory, in MiB.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'AcceleratorType' => [ 'base' => NULL, 'refs' => [ 'AcceleratorTypeSet$member' => NULL, ], ], 'AcceleratorTypeSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorTypes' => '<p>The accelerator types that must be on the instance type.</p> <ul> <li> <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p> </li> <li> <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p> </li> <li> <p>For instance types with inference accelerators, specify <code>inference</code>.</p> </li> </ul> <p>Default: Any accelerator type</p>', 'InstanceRequirementsRequest$AcceleratorTypes' => '<p>The accelerator types that must be on the instance type.</p> <ul> <li> <p>To include instance types with GPU hardware, specify <code>gpu</code>.</p> </li> <li> <p>To include instance types with FPGA hardware, specify <code>fpga</code>.</p> </li> <li> <p>To include instance types with inference hardware, specify <code>inference</code>.</p> </li> </ul> <p>Default: Any accelerator type</p>', ], ], 'AcceptAddressTransferRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptAddressTransferResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptReservedInstancesExchangeQuoteRequest' => [ 'base' => '<p>Contains the parameters for accepting the quote.</p>', 'refs' => [], ], 'AcceptReservedInstancesExchangeQuoteResult' => [ 'base' => '<p>The result of the exchange and whether it was <code>successful</code>.</p>', 'refs' => [], ], 'AcceptTransitGatewayMulticastDomainAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayMulticastDomainAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcEndpointConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcEndpointConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'AccessScopeAnalysisFinding' => [ 'base' => '<p>Describes a finding for a Network Access Scope.</p>', 'refs' => [ 'AccessScopeAnalysisFindingList$member' => NULL, ], ], 'AccessScopeAnalysisFindingList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkInsightsAccessScopeAnalysisFindingsResult$AnalysisFindings' => '<p>The findings associated with Network Access Scope Analysis.</p>', ], ], 'AccessScopePath' => [ 'base' => '<p>Describes a path.</p>', 'refs' => [ 'AccessScopePathList$member' => NULL, ], ], 'AccessScopePathList' => [ 'base' => NULL, 'refs' => [ 'NetworkInsightsAccessScopeContent$MatchPaths' => '<p>The paths to match.</p>', 'NetworkInsightsAccessScopeContent$ExcludePaths' => '<p>The paths to exclude.</p>', ], ], 'AccessScopePathListRequest' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInsightsAccessScopeRequest$MatchPaths' => '<p>The paths to match.</p>', 'CreateNetworkInsightsAccessScopeRequest$ExcludePaths' => '<p>The paths to exclude.</p>', ], ], 'AccessScopePathRequest' => [ 'base' => '<p>Describes a path.</p>', 'refs' => [ 'AccessScopePathListRequest$member' => NULL, ], ], 'AccountAttribute' => [ 'base' => '<p>Describes an account attribute.</p>', 'refs' => [ 'AccountAttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResult$AccountAttributes' => '<p>Information about the account attributes.</p>', ], ], 'AccountAttributeName' => [ 'base' => NULL, 'refs' => [ 'AccountAttributeNameStringList$member' => NULL, ], ], 'AccountAttributeNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$AttributeNames' => '<p>The account attribute names.</p>', ], ], 'AccountAttributeValue' => [ 'base' => '<p>Describes a value of an account attribute.</p>', 'refs' => [ 'AccountAttributeValueList$member' => NULL, ], ], 'AccountAttributeValueList' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$AttributeValues' => '<p>The values for the account attribute.</p>', ], ], 'ActiveInstance' => [ 'base' => '<p>Describes a running instance in a Spot Fleet.</p>', 'refs' => [ 'ActiveInstanceSet$member' => NULL, ], ], 'ActiveInstanceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetInstancesResult$ActiveInstances' => '<p>The running instances. This list is refreshed periodically and might be out of date.</p>', 'DescribeSpotFleetInstancesResponse$ActiveInstances' => '<p>The running instances. This list is refreshed periodically and might be out of date.</p>', ], ], 'ActivityStatus' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfig$ActivityStatus' => '<p>The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.</p>', ], ], 'AddIpamOperatingRegion' => [ 'base' => '<p>Add an operating Region to an IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p> <p>For more information about operating Regions, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'refs' => [ 'AddIpamOperatingRegionSet$member' => NULL, ], ], 'AddIpamOperatingRegionSet' => [ 'base' => NULL, 'refs' => [ 'CreateIpamRequest$OperatingRegions' => '<p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions. </p> <p>For more information about operating Regions, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>', 'CreateIpamResourceDiscoveryRequest$OperatingRegions' => '<p>Operating Regions for the IPAM resource discovery. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>', 'ModifyIpamRequest$AddOperatingRegions' => '<p>Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p> <p>For more information about operating Regions, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>', 'ModifyIpamResourceDiscoveryRequest$AddOperatingRegions' => '<p>Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>', ], ], 'AddPrefixListEntries' => [ 'base' => NULL, 'refs' => [ 'CreateManagedPrefixListRequest$Entries' => '<p>One or more entries for the prefix list.</p>', 'ModifyManagedPrefixListRequest$AddEntries' => '<p>One or more entries to add to the prefix list.</p>', ], ], 'AddPrefixListEntry' => [ 'base' => '<p>An entry for a prefix list.</p>', 'refs' => [ 'AddPrefixListEntries$member' => NULL, ], ], 'AddedPrincipal' => [ 'base' => '<p>Describes a principal.</p>', 'refs' => [ 'AddedPrincipalSet$member' => NULL, ], ], 'AddedPrincipalSet' => [ 'base' => NULL, 'refs' => [ 'ModifyVpcEndpointServicePermissionsResult$AddedPrincipals' => '<p>Information about the added principals.</p>', ], ], 'AdditionalDetail' => [ 'base' => '<p>Describes an additional detail for a path analysis. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/additional-detail-codes.html">Reachability Analyzer additional detail codes</a>.</p>', 'refs' => [ 'AdditionalDetailList$member' => NULL, ], ], 'AdditionalDetailList' => [ 'base' => NULL, 'refs' => [ 'PathComponent$AdditionalDetails' => '<p>The additional details.</p>', ], ], 'Address' => [ 'base' => '<p>Describes an Elastic IP address, or a carrier IP address.</p>', 'refs' => [ 'AddressList$member' => NULL, ], ], 'AddressAttribute' => [ 'base' => '<p>The attributes associated with an Elastic IP address.</p>', 'refs' => [ 'AddressSet$member' => NULL, 'ModifyAddressAttributeResult$Address' => '<p>Information about the Elastic IP address.</p>', 'ResetAddressAttributeResult$Address' => '<p>Information about the IP address.</p>', ], ], 'AddressAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesAttributeRequest$Attribute' => '<p>The attribute of the IP address.</p>', 'ResetAddressAttributeRequest$Attribute' => '<p>The attribute of the IP address.</p>', ], ], 'AddressFamily' => [ 'base' => NULL, 'refs' => [ 'CreateIpamPoolRequest$AddressFamily' => '<p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>', 'IpamPool$AddressFamily' => '<p>The address family of the pool.</p>', ], ], 'AddressList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesResult$Addresses' => '<p>Information about the Elastic IP addresses.</p>', ], ], 'AddressMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesAttributeRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'AddressSet' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesAttributeResult$Addresses' => '<p>Information about the IP addresses.</p>', ], ], 'AddressTransfer' => [ 'base' => '<p>Details on the Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP addresses</a> in the <i>Amazon VPC User Guide</i>.</p>', 'refs' => [ 'AcceptAddressTransferResult$AddressTransfer' => '<p>An Elastic IP address transfer.</p>', 'AddressTransferList$member' => NULL, 'DisableAddressTransferResult$AddressTransfer' => '<p>An Elastic IP address transfer.</p>', 'EnableAddressTransferResult$AddressTransfer' => '<p>An Elastic IP address transfer.</p>', ], ], 'AddressTransferList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressTransfersResult$AddressTransfers' => '<p>The Elastic IP address transfer.</p>', ], ], 'AddressTransferStatus' => [ 'base' => NULL, 'refs' => [ 'AddressTransfer$AddressTransferStatus' => '<p>The Elastic IP address transfer status.</p>', ], ], 'AdvertiseByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdvertiseByoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'Affinity' => [ 'base' => NULL, 'refs' => [ 'ModifyInstancePlacementRequest$Affinity' => '<p>The affinity setting for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-affinity">Host affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'AllocateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AllocateHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateHostsResult' => [ 'base' => '<p>Contains the output of AllocateHosts.</p>', 'refs' => [], ], 'AllocateIpamPoolCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateIpamPoolCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'AllocationId' => [ 'base' => NULL, 'refs' => [ 'AddressAttribute$AllocationId' => '<p>[EC2-VPC] The allocation ID.</p>', 'AllocationIdList$member' => NULL, 'AllocationIds$member' => NULL, 'AssociateAddressRequest$AllocationId' => '<p>The allocation ID. This is required.</p>', 'CreateNatGatewayRequest$AllocationId' => '<p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>', 'DisableAddressTransferRequest$AllocationId' => '<p>The allocation ID of an Elastic IP address.</p>', 'EnableAddressTransferRequest$AllocationId' => '<p>The allocation ID of an Elastic IP address.</p>', 'ModifyAddressAttributeRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID.</p>', 'ReleaseAddressRequest$AllocationId' => '<p>The allocation ID. This parameter is required.</p>', 'ResetAddressAttributeRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID.</p>', ], ], 'AllocationIdList' => [ 'base' => NULL, 'refs' => [ 'AssociateNatGatewayAddressRequest$AllocationIds' => '<p>The allocation IDs of EIPs that you want to associate with your NAT gateway.</p>', 'CreateNatGatewayRequest$SecondaryAllocationIds' => '<p>Secondary EIP allocation IDs. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <i>Amazon VPC User Guide</i>.</p>', 'DescribeAddressTransfersRequest$AllocationIds' => '<p>The allocation IDs of Elastic IP addresses.</p>', 'DescribeAddressesRequest$AllocationIds' => '<p>Information about the allocation IDs.</p>', ], ], 'AllocationIds' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesAttributeRequest$AllocationIds' => '<p>[EC2-VPC] The allocation IDs.</p>', ], ], 'AllocationState' => [ 'base' => NULL, 'refs' => [ 'Host$State' => '<p>The Dedicated Host\'s state.</p>', ], ], 'AllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$AllocationStrategy' => '<p>The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the Spot Fleet launch configuration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Allocation strategies for Spot Instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <dl> <dt>priceCapacityOptimized (recommended)</dt> <dd> <p>Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance of interruption in the near term. Spot Fleet then requests Spot Instances from the lowest priced of these pools.</p> </dd> <dt>capacityOptimized</dt> <dd> <p>Spot Fleet identifies the pools with the highest capacity availability for the number of instances that are launching. This means that we will request Spot Instances from the pools that we believe have the lowest chance of interruption in the near term. To give certain instance types a higher chance of launching first, use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can assign the same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements the priorities on a best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, the same priority is applied when fulfilling On-Demand capacity.</p> </dd> <dt>diversified</dt> <dd> <p>Spot Fleet requests instances from all of the Spot Instance pools that you specify.</p> </dd> <dt>lowestPrice (not recommended)</dt> <dd> <important> <p>We don\'t recommend the <code>lowestPrice</code> allocation strategy because it has the highest risk of interruption for your Spot Instances.</p> </important> <p>Spot Fleet requests instances from the lowest priced Spot Instance pool that has available capacity. If the lowest priced pool doesn\'t have available capacity, the Spot Instances come from the next lowest priced pool that has available capacity. If a pool runs out of capacity before fulfilling your desired capacity, Spot Fleet will continue to fulfill your request by drawing from the next lowest priced pool. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. Because this strategy only considers instance price and not capacity availability, it might lead to high interruption rates.</p> </dd> </dl> <p>Default: <code>lowestPrice</code> </p>', ], ], 'AllocationType' => [ 'base' => NULL, 'refs' => [ 'CapacityAllocation$AllocationType' => '<p>The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are running in the Capacity Reservation.</p>', ], ], 'AllowedInstanceType' => [ 'base' => NULL, 'refs' => [ 'AllowedInstanceTypeSet$member' => NULL, ], ], 'AllowedInstanceTypeSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AllowedInstanceTypes' => '<p>The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.</p> <p>You can use strings with one or more wild cards, represented by an asterisk (<code>*</code>), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code>, <code>c5*.*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>.</p> <p>For example, if you specify <code>c5*</code>,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code>, Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.</p> <note> <p>If you specify <code>AllowedInstanceTypes</code>, you can\'t specify <code>ExcludedInstanceTypes</code>.</p> </note> <p>Default: All instance types</p>', 'InstanceRequirementsRequest$AllowedInstanceTypes' => '<p>The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.</p> <p>You can use strings with one or more wild cards, represented by an asterisk (<code>*</code>), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code>, <code>c5*.*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>.</p> <p>For example, if you specify <code>c5*</code>,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code>, Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.</p> <note> <p>If you specify <code>AllowedInstanceTypes</code>, you can\'t specify <code>ExcludedInstanceTypes</code>.</p> </note> <p>Default: All instance types</p>', ], ], 'AllowedPrincipal' => [ 'base' => '<p>Describes a principal.</p>', 'refs' => [ 'AllowedPrincipalSet$member' => NULL, ], ], 'AllowedPrincipalSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointServicePermissionsResult$AllowedPrincipals' => '<p>Information about the allowed principals.</p>', ], ], 'AllowsMultipleInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'Host$AllowsMultipleInstanceTypes' => '<p>Indicates whether the Dedicated Host supports multiple instance types of the same instance family. If the value is <code>on</code>, the Dedicated Host supports multiple instance types in the instance family. If the value is <code>off</code>, the Dedicated Host supports a single instance type only.</p>', ], ], 'AlternatePathHint' => [ 'base' => '<p>Describes an potential intermediate component of a feasible path.</p>', 'refs' => [ 'AlternatePathHintList$member' => NULL, ], ], 'AlternatePathHintList' => [ 'base' => NULL, 'refs' => [ 'NetworkInsightsAnalysis$AlternatePathHints' => '<p>Potential intermediate components.</p>', ], ], 'AmdSevSnpSpecification' => [ 'base' => NULL, 'refs' => [ 'CpuOptions$AmdSevSnp' => '<p>Indicates whether the instance is enabled for AMD SEV-SNP. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.</p>', 'CpuOptionsRequest$AmdSevSnp' => '<p>Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.</p>', 'LaunchTemplateCpuOptions$AmdSevSnp' => '<p>Indicates whether the instance is enabled for AMD SEV-SNP. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.</p>', 'LaunchTemplateCpuOptionsRequest$AmdSevSnp' => '<p>Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.</p>', ], ], 'AnalysisAclRule' => [ 'base' => '<p>Describes a network access control (ACL) rule.</p>', 'refs' => [ 'Explanation$AclRule' => '<p>The network ACL rule.</p>', 'PathComponent$AclRule' => '<p>The network ACL rule.</p>', ], ], 'AnalysisComponent' => [ 'base' => '<p>Describes a path component.</p>', 'refs' => [ 'AdditionalDetail$Component' => '<p>The path component.</p>', 'AdditionalDetail$VpcEndpointService' => '<p>The VPC endpoint service.</p>', 'AnalysisComponentList$member' => NULL, 'AnalysisLoadBalancerTarget$Instance' => '<p>Information about the instance.</p>', 'Explanation$Acl' => '<p>The network ACL.</p>', 'Explanation$AttachedTo' => '<p>The resource to which the component is attached.</p>', 'Explanation$Component' => '<p>The component.</p>', 'Explanation$CustomerGateway' => '<p>The customer gateway.</p>', 'Explanation$Destination' => '<p>The destination.</p>', 'Explanation$DestinationVpc' => '<p>The destination VPC.</p>', 'Explanation$IngressRouteTable' => '<p>The route table.</p>', 'Explanation$InternetGateway' => '<p>The internet gateway.</p>', 'Explanation$LoadBalancerTargetGroup' => '<p>The target group.</p>', 'Explanation$ElasticLoadBalancerListener' => '<p>The load balancer listener.</p>', 'Explanation$NatGateway' => '<p>The NAT gateway.</p>', 'Explanation$NetworkInterface' => '<p>The network interface.</p>', 'Explanation$VpcPeeringConnection' => '<p>The VPC peering connection.</p>', 'Explanation$PrefixList' => '<p>The prefix list.</p>', 'Explanation$RouteTable' => '<p>The route table.</p>', 'Explanation$SecurityGroup' => '<p>The security group.</p>', 'Explanation$SourceVpc' => '<p>The source VPC.</p>', 'Explanation$Subnet' => '<p>The subnet.</p>', 'Explanation$SubnetRouteTable' => '<p>The route table for the subnet.</p>', 'Explanation$Vpc' => '<p>The component VPC.</p>', 'Explanation$VpcEndpoint' => '<p>The VPC endpoint.</p>', 'Explanation$VpnConnection' => '<p>The VPN connection.</p>', 'Explanation$VpnGateway' => '<p>The VPN gateway.</p>', 'Explanation$TransitGateway' => '<p>The transit gateway.</p>', 'Explanation$TransitGatewayRouteTable' => '<p>The transit gateway route table.</p>', 'Explanation$TransitGatewayAttachment' => '<p>The transit gateway attachment.</p>', 'PathComponent$AttachedTo' => '<p>The resource to which the path component is attached.</p>', 'PathComponent$Component' => '<p>The component.</p>', 'PathComponent$DestinationVpc' => '<p>The destination VPC.</p>', 'PathComponent$SourceVpc' => '<p>The source VPC.</p>', 'PathComponent$Subnet' => '<p>The subnet.</p>', 'PathComponent$Vpc' => '<p>The component VPC.</p>', 'PathComponent$TransitGateway' => '<p>The transit gateway.</p>', 'PathComponent$ElasticLoadBalancerListener' => '<p>The load balancer listener.</p>', ], ], 'AnalysisComponentList' => [ 'base' => NULL, 'refs' => [ 'AdditionalDetail$LoadBalancers' => '<p>The load balancers.</p>', 'Explanation$LoadBalancerTargetGroups' => '<p>The target groups.</p>', 'Explanation$SecurityGroups' => '<p>The security groups.</p>', ], ], 'AnalysisLoadBalancerListener' => [ 'base' => '<p>Describes a load balancer listener.</p>', 'refs' => [ 'Explanation$ClassicLoadBalancerListener' => '<p>The listener for a Classic Load Balancer.</p>', ], ], 'AnalysisLoadBalancerTarget' => [ 'base' => '<p>Describes a load balancer target.</p>', 'refs' => [ 'Explanation$LoadBalancerTarget' => '<p>The target.</p>', ], ], 'AnalysisPacketHeader' => [ 'base' => '<p>Describes a header. Reflects any changes made by a component as traffic passes through. The fields of an inbound header are null except for the first component of a path.</p>', 'refs' => [ 'PathComponent$OutboundHeader' => '<p>The outbound header.</p>', 'PathComponent$InboundHeader' => '<p>The inbound header.</p>', ], ], 'AnalysisRouteTableRoute' => [ 'base' => '<p>Describes a route table route.</p>', 'refs' => [ 'Explanation$RouteTableRoute' => '<p>The route table route.</p>', 'PathComponent$RouteTableRoute' => '<p>The route table route.</p>', ], ], 'AnalysisSecurityGroupRule' => [ 'base' => '<p>Describes a security group rule.</p>', 'refs' => [ 'Explanation$SecurityGroupRule' => '<p>The security group rule.</p>', 'PathComponent$SecurityGroupRule' => '<p>The security group rule.</p>', ], ], 'AnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'GetNetworkInsightsAccessScopeAnalysisFindingsResult$AnalysisStatus' => '<p>The status of Network Access Scope Analysis.</p>', 'NetworkInsightsAccessScopeAnalysis$Status' => '<p>The status.</p>', 'NetworkInsightsAnalysis$Status' => '<p>The status of the network insights analysis.</p>', ], ], 'ApplianceModeSupportValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequestOptions$ApplianceModeSupport' => '<p>Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is <code>disable</code>.</p>', 'ModifyTransitGatewayVpcAttachmentRequestOptions$ApplianceModeSupport' => '<p>Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is <code>disable</code>.</p>', 'TransitGatewayVpcAttachmentOptions$ApplianceModeSupport' => '<p>Indicates whether appliance mode support is enabled.</p>', ], ], 'ApplySecurityGroupsToClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'ApplySecurityGroupsToClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'ArchitectureType' => [ 'base' => NULL, 'refs' => [ 'ArchitectureTypeList$member' => NULL, 'ArchitectureTypeSet$member' => NULL, ], ], 'ArchitectureTypeList' => [ 'base' => NULL, 'refs' => [ 'ProcessorInfo$SupportedArchitectures' => '<p>The architectures supported by the instance type.</p>', ], ], 'ArchitectureTypeSet' => [ 'base' => NULL, 'refs' => [ 'GetInstanceTypesFromInstanceRequirementsRequest$ArchitectureTypes' => '<p>The processor architecture type.</p>', 'InstanceRequirementsWithMetadataRequest$ArchitectureTypes' => '<p>The architecture type.</p>', ], ], 'ArchitectureValues' => [ 'base' => NULL, 'refs' => [ 'Image$Architecture' => '<p>The architecture of the image.</p>', 'ImportInstanceLaunchSpecification$Architecture' => '<p>The architecture of the instance.</p>', 'Instance$Architecture' => '<p>The architecture of the image.</p>', 'RegisterImageRequest$Architecture' => '<p>The architecture of the AMI.</p> <p>Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture specified in the manifest file.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'NetworkInsightsAnalysis$FilterInArns' => '<p>The Amazon Resource Names (ARN) of the resources that the path must traverse.</p>', 'StartNetworkInsightsAnalysisRequest$FilterInArns' => '<p>The Amazon Resource Names (ARN) of the resources that the path must traverse.</p>', ], ], 'AsnAssociation' => [ 'base' => '<p>An Autonomous System Number (ASN) and BYOIP CIDR association.</p>', 'refs' => [ 'AsnAssociationSet$member' => NULL, 'AssociateIpamByoasnResult$AsnAssociation' => '<p>The ASN and BYOIP CIDR association.</p>', 'DisassociateIpamByoasnResult$AsnAssociation' => '<p>An ASN and BYOIP CIDR association.</p>', ], ], 'AsnAssociationSet' => [ 'base' => NULL, 'refs' => [ 'ByoipCidr$AsnAssociations' => '<p>The BYOIP CIDR associations with ASNs.</p>', ], ], 'AsnAssociationState' => [ 'base' => NULL, 'refs' => [ 'AsnAssociation$State' => '<p>The association\'s state.</p>', ], ], 'AsnAuthorizationContext' => [ 'base' => '<p>Provides authorization for Amazon to bring an Autonomous System Number (ASN) to a specific Amazon Web Services account using bring your own ASN (BYOASN). For details on the format of the message and signature, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in the <i>Amazon VPC IPAM guide</i>.</p>', 'refs' => [ 'ProvisionIpamByoasnRequest$AsnAuthorizationContext' => '<p>An ASN authorization context.</p>', ], ], 'AsnState' => [ 'base' => NULL, 'refs' => [ 'Byoasn$State' => '<p>The provisioning state of the BYOASN.</p>', ], ], 'AssetId' => [ 'base' => NULL, 'refs' => [ 'AssetIdList$member' => NULL, 'Host$AssetId' => '<p>The ID of the Outpost hardware asset on which the Dedicated Host is allocated.</p>', ], ], 'AssetIdList' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$AssetIds' => '<p>The IDs of the Outpost hardware assets on which to allocate the Dedicated Hosts. Targeting specific hardware assets on an Outpost can help to minimize latency between your workloads. This parameter is supported only if you specify <b>OutpostArn</b>. If you are allocating the Dedicated Hosts in a Region, omit this parameter.</p> <ul> <li> <p>If you specify this parameter, you can omit <b>Quantity</b>. In this case, Amazon EC2 allocates a Dedicated Host on each specified hardware asset.</p> </li> <li> <p>If you specify both <b>AssetIds</b> and <b>Quantity</b>, then the value for <b>Quantity</b> must be equal to the number of asset IDs specified.</p> </li> </ul>', ], ], 'AssignIpv6AddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssignIpv6AddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'AssignPrivateIpAddressesRequest' => [ 'base' => '<p>Contains the parameters for AssignPrivateIpAddresses.</p>', 'refs' => [], ], 'AssignPrivateIpAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'AssignPrivateNatGatewayAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssignPrivateNatGatewayAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AssignedPrivateIpAddress' => [ 'base' => '<p>Describes the private IP addresses assigned to a network interface.</p>', 'refs' => [ 'AssignedPrivateIpAddressList$member' => NULL, ], ], 'AssignedPrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'AssignPrivateIpAddressesResult$AssignedPrivateIpAddresses' => '<p>The private IP addresses assigned to the network interface.</p>', ], ], 'AssociateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEnclaveCertificateIamRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEnclaveCertificateIamRoleResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIamInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIamInstanceProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceEventWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceEventWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpamByoasnRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpamByoasnResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpamResourceDiscoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpamResourceDiscoveryResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateNatGatewayAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateNatGatewayAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayPolicyTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayPolicyTableResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrunkInterfaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrunkInterfaceResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateVpcCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateVpcCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedNetworkType' => [ 'base' => NULL, 'refs' => [ 'AssociatedTargetNetwork$NetworkType' => '<p>The target network type.</p>', ], ], 'AssociatedRole' => [ 'base' => '<p>Information about the associated IAM roles.</p>', 'refs' => [ 'AssociatedRolesList$member' => NULL, ], ], 'AssociatedRolesList' => [ 'base' => NULL, 'refs' => [ 'GetAssociatedEnclaveCertificateIamRolesResult$AssociatedRoles' => '<p>Information about the associated IAM roles.</p>', ], ], 'AssociatedTargetNetwork' => [ 'base' => '<p>Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.</p>', 'refs' => [ 'AssociatedTargetNetworkSet$member' => NULL, ], ], 'AssociatedTargetNetworkSet' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpoint$AssociatedTargetNetworks' => '<p>Information about the associated target networks. A target network is a subnet in a VPC.</p>', ], ], 'AssociationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeIamInstanceProfileAssociationsRequest$AssociationIds' => '<p>The IAM instance profile associations.</p>', ], ], 'AssociationStatus' => [ 'base' => '<p>Describes the state of a target network association.</p>', 'refs' => [ 'AssociateClientVpnTargetNetworkResult$Status' => '<p>The current state of the target network association.</p>', 'DisassociateClientVpnTargetNetworkResult$Status' => '<p>The current state of the target network association.</p>', 'TargetNetwork$Status' => '<p>The current state of the target network association.</p>', ], ], 'AssociationStatusCode' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Code' => '<p>The state of the target network association.</p>', ], ], 'AthenaIntegration' => [ 'base' => '<p>Describes integration options for Amazon Athena.</p>', 'refs' => [ 'AthenaIntegrationsSet$member' => NULL, ], ], 'AthenaIntegrationsSet' => [ 'base' => NULL, 'refs' => [ 'IntegrateServices$AthenaIntegrations' => '<p>Information about the integration with Amazon Athena.</p>', ], ], 'AttachClassicLinkVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachClassicLinkVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'AttachInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachNetworkInterfaceResult' => [ 'base' => '<p>Contains the output of AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachVerifiedAccessTrustProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachVerifiedAccessTrustProviderResult' => [ 'base' => NULL, 'refs' => [], ], 'AttachVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for AttachVpnGateway.</p>', 'refs' => [], ], 'AttachVpnGatewayResult' => [ 'base' => '<p>Contains the output of AttachVpnGateway.</p>', 'refs' => [], ], 'AttachmentEnaSrdSpecification' => [ 'base' => '<p>ENA Express uses Amazon Web Services Scalable Reliable Datagram (SRD) technology to increase the maximum bandwidth used per stream and minimize tail latency of network traffic between EC2 instances. With ENA Express, you can communicate between two EC2 instances in the same subnet within the same account, or in different accounts. Both sending and receiving instances must have ENA Express enabled.</p> <p>To improve the reliability of network packet delivery, ENA Express reorders network packets on the receiving end by default. However, some UDP-based applications are designed to handle network packets that are out of order to reduce the overhead for packet delivery at the network layer. When ENA Express is enabled, you can specify whether UDP network traffic uses it.</p>', 'refs' => [ 'NetworkInterfaceAttachment$EnaSrdSpecification' => '<p>Configures ENA Express for the network interface that this action attaches to the instance.</p>', ], ], 'AttachmentEnaSrdUdpSpecification' => [ 'base' => '<p>ENA Express is compatible with both TCP and UDP transport protocols. When it\'s enabled, TCP traffic automatically uses it. However, some UDP-based applications are designed to handle network packets that are out of order, without a need for retransmission, such as live video broadcasting or other near-real-time applications. For UDP traffic, you can specify whether to use ENA Express, based on your application environment needs.</p>', 'refs' => [ 'AttachmentEnaSrdSpecification$EnaSrdUdpSpecification' => '<p>Configures ENA Express for UDP network traffic.</p>', ], ], 'AttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDevice$Status' => '<p>The attachment state.</p>', 'InstanceNetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'InternetGatewayAttachment$State' => '<p>The current state of the attachment. For an internet gateway, the state is <code>available</code> when attached to a VPC; otherwise, this value is not returned.</p>', 'NetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'VpcAttachment$State' => '<p>The current state of the attachment.</p>', ], ], 'AttributeBooleanValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a Boolean value.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'DescribeVolumeAttributeResult$AutoEnableIO' => '<p>The state of <code>autoEnableIO</code> attribute.</p>', 'DescribeVpcAttributeResult$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.</p>', 'DescribeVpcAttributeResult$EnableDnsSupport' => '<p>Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does not.</p>', 'DescribeVpcAttributeResult$EnableNetworkAddressUsageMetrics' => '<p>Indicates whether Network Address Usage metrics are enabled for your VPC.</p>', 'InstanceAttribute$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance through the Amazon EC2 console, CLI, or API; otherwise, you can.</p>', 'InstanceAttribute$EnaSupport' => '<p>Indicates whether enhanced networking with ENA is enabled.</p>', 'InstanceAttribute$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O.</p>', 'InstanceAttribute$SourceDestCheck' => '<p>Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.</p>', 'InstanceAttribute$DisableApiStop' => '<p>To enable the instance for Amazon Web Services Stop Protection, set this parameter to <code>true</code>; otherwise, set it to <code>false</code>.</p>', 'ModifyInstanceAttributeRequest$SourceDestCheck' => '<p>Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.</p>', 'ModifyInstanceAttributeRequest$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot Instances.</p>', 'ModifyInstanceAttributeRequest$EbsOptimized' => '<p>Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'ModifyInstanceAttributeRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyInstanceAttributeRequest$DisableApiStop' => '<p>Indicates whether an instance is enabled for stop protection. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop protection for your instance</a>.</p> <p/>', 'ModifyNetworkInterfaceAttributeRequest$SourceDestCheck' => '<p>Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.</p>', 'ModifySubnetAttributeRequest$AssignIpv6AddressOnCreation' => '<p>Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be assigned an IPv6 address. This includes a network interface that\'s created when launching an instance into the subnet (the instance therefore receives an IPv6 address). </p> <p>If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives an IPv6 address if it\'s created using version <code>2016-11-15</code> or later of the Amazon EC2 API.</p>', 'ModifySubnetAttributeRequest$MapPublicIpOnLaunch' => '<p>Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified subnet should be assigned a public IPv4 address.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'ModifySubnetAttributeRequest$MapCustomerOwnedIpOnLaunch' => '<p>Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified subnet should be assigned a customer-owned IPv4 address.</p> <p>When this value is <code>true</code>, you must specify the customer-owned IP pool using <code>CustomerOwnedIpv4Pool</code>.</p>', 'ModifySubnetAttributeRequest$EnableDns64' => '<p>Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.</p> <note> <p>You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough">Configure DNS64 and NAT64</a> in the <i>Amazon VPC User Guide</i>.</p> </note>', 'ModifySubnetAttributeRequest$EnableResourceNameDnsARecordOnLaunch' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'ModifySubnetAttributeRequest$EnableResourceNameDnsAAAARecordOnLaunch' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'ModifySubnetAttributeRequest$DisableLniAtDeviceIndex' => '<p> Specify <code>true</code> to indicate that local network interfaces at the current position should be disabled. </p>', 'ModifyVolumeAttributeRequest$AutoEnableIO' => '<p>Indicates whether the volume should be auto-enabled for I/O operations.</p>', 'ModifyVpcAttributeRequest$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you\'ve enabled DNS support.</p>', 'ModifyVpcAttributeRequest$EnableDnsSupport' => '<p>Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is not enabled.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.</p>', 'ModifyVpcAttributeRequest$EnableNetworkAddressUsageMetrics' => '<p>Indicates whether Network Address Usage metrics are enabled for your VPC.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a String.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$Description' => '<p>The description of the network interface.</p>', 'DhcpConfigurationValueList$member' => NULL, 'ImageAttribute$Description' => '<p>A description for the AMI.</p>', 'ImageAttribute$KernelId' => '<p>The kernel ID.</p>', 'ImageAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'ImageAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'ImageAttribute$BootMode' => '<p>The boot mode.</p>', 'ImageAttribute$TpmSupport' => '<p>If the image is configured for NitroTPM support, the value is <code>v2.0</code>.</p>', 'ImageAttribute$UefiData' => '<p>Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a> command. You can inspect and modify the UEFI data by using the <a href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ImageAttribute$LastLaunchedTime' => '<p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported.</p> <note> <p> <code>lastLaunchedTime</code> data is available starting April 2017.</p> </note>', 'ImageAttribute$ImdsSupport' => '<p>If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration">Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ImageAttribute$DeregistrationProtection' => '<p>Indicates whether deregistration protection is enabled for the AMI.</p>', 'InstanceAttribute$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'InstanceAttribute$InstanceType' => '<p>The instance type.</p>', 'InstanceAttribute$KernelId' => '<p>The kernel ID.</p>', 'InstanceAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'InstanceAttribute$RootDeviceName' => '<p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>', 'InstanceAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'InstanceAttribute$UserData' => '<p>The user data.</p>', 'ModifyImageAttributeRequest$Description' => '<p>A new description for the AMI.</p>', 'ModifyImageAttributeRequest$ImdsSupport' => '<p>Set to <code>v2.0</code> to indicate that IMDSv2 is specified in the AMI. Instances launched from this AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration">Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p> <important> <p>Do not use this parameter unless your AMI software supports IMDSv2. After you set the value to <code>v2.0</code>, you can\'t undo it. The only way to “reset” your AMI is to create a new AMI from the underlying snapshot.</p> </important>', 'ModifyInstanceAttributeRequest$InstanceInitiatedShutdownBehavior' => '<p>Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'ModifyInstanceAttributeRequest$InstanceType' => '<p>Changes the instance type to the specified value. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>. If the instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.</p>', 'ModifyInstanceAttributeRequest$Kernel' => '<p>Changes the instance\'s kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$Ramdisk' => '<p>Changes the instance\'s RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$SriovNetSupport' => '<p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance.</p> <p>There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyNetworkInterfaceAttributeRequest$Description' => '<p>A description for the network interface.</p>', ], ], 'AuthorizationRule' => [ 'base' => '<p>Information about an authorization rule.</p>', 'refs' => [ 'AuthorizationRuleSet$member' => NULL, ], ], 'AuthorizationRuleSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnAuthorizationRulesResult$AuthorizationRules' => '<p>Information about the authorization rules.</p>', ], ], 'AuthorizeClientVpnIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeClientVpnIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupEgressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupEgressResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AutoAcceptSharedAssociationsValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayMulticastDomainRequestOptions$AutoAcceptSharedAssociations' => '<p>Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.</p>', 'TransitGatewayMulticastDomainOptions$AutoAcceptSharedAssociations' => '<p>Indicates whether to automatically cross-account subnet associations that are associated with the transit gateway multicast domain.</p>', ], ], 'AutoAcceptSharedAttachmentsValue' => [ 'base' => NULL, 'refs' => [ 'ModifyTransitGatewayOptions$AutoAcceptSharedAttachments' => '<p>Enable or disable automatic acceptance of attachment requests.</p>', 'TransitGatewayOptions$AutoAcceptSharedAttachments' => '<p>Indicates whether attachment requests are automatically accepted.</p>', 'TransitGatewayRequestOptions$AutoAcceptSharedAttachments' => '<p>Enable or disable automatic acceptance of attachment requests. Disabled by default.</p>', ], ], 'AutoPlacement' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$AutoPlacement' => '<p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>off</code> </p>', 'Host$AutoPlacement' => '<p>Whether auto-placement is on or off.</p>', 'ModifyHostsRequest$AutoPlacement' => '<p>Specify whether to enable or disable auto-placement.</p>', ], ], 'AutoRecoveryFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$AutoRecoverySupported' => '<p>Indicates whether Amazon CloudWatch action based recovery is supported.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Describes Availability Zones, Local Zones, and Wavelength Zones.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, ], ], 'AvailabilityZoneId' => [ 'base' => NULL, 'refs' => [ 'CreateCapacityReservationRequest$AvailabilityZoneId' => '<p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityZonesResult$AvailabilityZones' => '<p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>', ], ], 'AvailabilityZoneMessage' => [ 'base' => '<p>Describes a message about an Availability Zone, Local Zone, or Wavelength Zone.</p>', 'refs' => [ 'AvailabilityZoneMessageList$member' => NULL, ], ], 'AvailabilityZoneMessageList' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$Messages' => '<p>Any messages about the Availability Zone, Local Zone, or Wavelength Zone.</p>', ], ], 'AvailabilityZoneName' => [ 'base' => NULL, 'refs' => [ 'CreateCapacityReservationRequest$AvailabilityZone' => '<p>The Availability Zone in which to create the Capacity Reservation.</p>', 'CreateDefaultSubnetRequest$AvailabilityZone' => '<p>The Availability Zone in which to create the default subnet.</p>', 'CreateVolumeRequest$AvailabilityZone' => '<p>The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code>.</p>', ], ], 'AvailabilityZoneOptInStatus' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$OptInStatus' => '<p>For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p> <p>For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are <code>opted-in</code>, and <code>not-opted-in</code>.</p>', ], ], 'AvailabilityZoneState' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$State' => '<p>The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always <code>available</code>.</p>', ], ], 'AvailabilityZoneStringList' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresRequest$AvailabilityZones' => '<p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>', 'EnableFastSnapshotRestoresRequest$AvailabilityZones' => '<p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>', ], ], 'AvailableCapacity' => [ 'base' => '<p>The capacity information for instances that can be launched onto the Dedicated Host. </p>', 'refs' => [ 'Host$AvailableCapacity' => '<p>Information about the instances running on the Dedicated Host.</p>', ], ], 'AvailableInstanceCapacityList' => [ 'base' => NULL, 'refs' => [ 'AvailableCapacity$AvailableInstanceCapacity' => '<p>The number of instances that can be launched onto the Dedicated Host depending on the host\'s available capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of instances for each instance size that is supported on the host.</p>', ], ], 'BareMetal' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$BareMetal' => '<p>Indicates whether bare metal instance types must be included, excluded, or required.</p> <ul> <li> <p>To include bare metal instance types, specify <code>included</code>.</p> </li> <li> <p>To require only bare metal instance types, specify <code>required</code>.</p> </li> <li> <p>To exclude bare metal instance types, specify <code>excluded</code>.</p> </li> </ul> <p>Default: <code>excluded</code> </p>', 'InstanceRequirementsRequest$BareMetal' => '<p>Indicates whether bare metal instance types must be included, excluded, or required.</p> <ul> <li> <p>To include bare metal instance types, specify <code>included</code>.</p> </li> <li> <p>To require only bare metal instance types, specify <code>required</code>.</p> </li> <li> <p>To exclude bare metal instance types, specify <code>excluded</code>.</p> </li> </ul> <p>Default: <code>excluded</code> </p>', ], ], 'BareMetalFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$BareMetal' => '<p>Indicates whether the instance is a bare metal instance type.</p>', ], ], 'BaselineBandwidthInGbps' => [ 'base' => NULL, 'refs' => [ 'NetworkCardInfo$BaselineBandwidthInGbps' => '<p>The baseline network performance of the network card, in Gbps.</p>', ], ], 'BaselineBandwidthInMbps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineBandwidthInMbps' => '<p>The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p>', ], ], 'BaselineEbsBandwidthMbps' => [ 'base' => '<p>The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'InstanceRequirements$BaselineEbsBandwidthMbps' => '<p>The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'BaselineEbsBandwidthMbpsRequest' => [ 'base' => '<p>The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'InstanceRequirementsRequest$BaselineEbsBandwidthMbps' => '<p>The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: No minimum or maximum limits</p>', ], ], 'BaselineIops' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineIops' => '<p>The baseline input/output storage operations per seconds for an EBS-optimized instance type.</p>', ], ], 'BaselineThroughputInMBps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineThroughputInMBps' => '<p>The baseline throughput performance for an EBS-optimized instance type, in MB/s.</p>', ], ], 'BatchState' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsSuccessItem$CurrentSpotFleetRequestState' => '<p>The current state of the Spot Fleet request.</p>', 'CancelSpotFleetRequestsSuccessItem$PreviousSpotFleetRequestState' => '<p>The previous state of the Spot Fleet request.</p>', 'SpotFleetRequestConfig$SpotFleetRequestState' => '<p>The state of the Spot Fleet request.</p>', ], ], 'BgpStatus' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayAttachmentBgpConfiguration$BgpStatus' => '<p>The BGP status.</p>', ], ], 'BillingProductList' => [ 'base' => NULL, 'refs' => [ 'RegisterImageRequest$BillingProducts' => '<p>The billing product codes. Your account must be authorized to specify billing product codes.</p> <p>If your account is not authorized to specify billing product codes, you can publish AMIs that include billable software and list them on the Amazon Web Services Marketplace. You must first register as a seller on the Amazon Web Services Marketplace. For more information, see <a href="https://docs.aws.amazon.com/marketplace/latest/userguide/user-guide-for-sellers.html">Getting started as a seller</a> and <a href="https://docs.aws.amazon.com/marketplace/latest/userguide/ami-products.html">AMI-based products</a> in the <i>Amazon Web Services Marketplace Seller Guide</i>.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'BlobAttributeValue$Value' => NULL, 'ImportKeyPairRequest$PublicKeyMaterial' => '<p>The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.</p>', 'S3Storage$UploadPolicy' => '<p>An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.</p>', ], ], 'BlobAttributeValue' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceAttributeRequest$UserData' => '<p>Changes the instance\'s user data to the specified value. User data must be base64-encoded. Depending on the tool or SDK that you\'re using, the base64-encoding might be performed for you. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instancedata-add-user-data.html">Work with instance user data</a>.</p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping, which defines the EBS volumes and instance store volumes to attach to an instance at launch.</p>', 'refs' => [ 'BlockDeviceMappingList$member' => NULL, 'BlockDeviceMappingRequestList$member' => NULL, ], ], 'BlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'Image$BlockDeviceMappings' => '<p>Any block device mapping entries.</p>', 'ImageAttribute$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', 'LaunchSpecification$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', 'RequestSpotLaunchSpecification$BlockDeviceMappings' => '<p>The block device mapping entries. You can\'t specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>', 'SpotFleetLaunchSpecification$BlockDeviceMappings' => '<p>One or more block devices that are mapped to the Spot Instances. You can\'t specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>', ], ], 'BlockDeviceMappingRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$BlockDeviceMappings' => '<p>The block device mappings.</p> <p>When using the CreateImage action:</p> <ul> <li> <p>You can\'t change the volume size using the VolumeSize parameter. If you want a different volume size, you must first change the volume size of the source instance.</p> </li> <li> <p>You can\'t modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or snapshots that have a different encryption status (for example, where the source volume and snapshots are unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a> action.</p> </li> <li> <p>The only option that can be changed for existing mappings or snapshots is <code>DeleteOnTermination</code>.</p> </li> </ul>', 'RegisterImageRequest$BlockDeviceMappings' => '<p>The block device mapping entries.</p> <p>If you specify an Amazon EBS volume using the ID of an Amazon EBS snapshot, you can\'t specify the encryption state of the volume.</p> <p>If you create an AMI on an Outpost, then all backing snapshots must be on the same Outpost or in the Region of that Outpost. AMIs on an Outpost that include local snapshots can be used to launch instances on the same Outpost only. For more information, <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami">Amazon EBS local snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.</p>', 'RunInstancesRequest$BlockDeviceMappings' => '<p>The block device mapping, which defines the EBS volumes and instance store volumes to attach to the instance at launch. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device mappings</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AcceptAddressTransferRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptTransitGatewayMulticastDomainAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AdvertiseByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AllocateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AllocateIpamPoolCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AllocateIpamPoolCidrRequest$PreviewNextCidr' => '<p>A preview of the next available CIDR in a pool.</p>', 'AnalysisAclRule$Egress' => '<p>Indicates whether the rule is an outbound rule.</p>', 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssignPrivateIpAddressesRequest$AllowReassignment' => '<p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>', 'AssignPrivateNatGatewayAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateAddressRequest$AllowReassociation' => '<p>Reassociation is automatic, but you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>', 'AssociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateEnclaveCertificateIamRoleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateInstanceEventWindowRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateIpamByoasnRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateIpamResourceDiscoveryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateNatGatewayAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTransitGatewayPolicyTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTrunkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateVpcCidrBlockRequest$AmazonProvidedIpv6CidrBlock' => '<p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses or the size of the CIDR block.</p>', 'AttachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'AttachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVerifiedAccessTrustProviderRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachmentEnaSrdSpecification$EnaSrdEnabled' => '<p>Indicates whether ENA Express is enabled for the network interface.</p>', 'AttachmentEnaSrdUdpSpecification$EnaSrdUdpEnabled' => '<p>Indicates whether UDP traffic to and from the instance uses ENA Express. To specify this setting, you must first enable ENA Express.</p>', 'AttributeBooleanValue$Value' => '<p>The attribute value. The valid values are <code>true</code> or <code>false</code>.</p>', 'AuthorizationRule$AccessAll' => '<p>Indicates whether the authorization rule grants access to all clients.</p>', 'AuthorizeClientVpnIngressRequest$AuthorizeAllGroups' => '<p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>', 'AuthorizeClientVpnIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupEgressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'AuthorizeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupIngressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'BundleInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelBundleTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelCapacityReservationFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelCapacityReservationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CancelConversionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelImageLaunchPermissionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelImageLaunchPermissionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CancelImportTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$TerminateInstances' => '<p>Indicates whether to terminate the associated instances when the Spot Fleet request is canceled. The default is to terminate the instances.</p> <p>To let the instances continue to run after the Spot Fleet request is canceled, specify <code>no-terminate-instances</code>.</p>', 'CancelSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CapacityReservation$EbsOptimized' => '<p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>', 'CapacityReservation$EphemeralStorage' => '<p> <i>Deprecated.</i> </p>', 'ClassicLinkDnsSupport$ClassicLinkDnsSupported' => '<p>Indicates whether ClassicLink DNS support is enabled for the VPC.</p>', 'ClientConnectOptions$Enabled' => '<p>Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).</p>', 'ClientConnectResponseOptions$Enabled' => '<p>Indicates whether client connect options are enabled.</p>', 'ClientLoginBannerOptions$Enabled' => '<p>Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p> <p>Valid values: <code>true | false</code> </p> <p>Default value: <code>false</code> </p>', 'ClientLoginBannerResponseOptions$Enabled' => '<p>Current state of text banner feature.</p> <p>Valid values: <code>true | false</code> </p>', 'ClientVpnEndpoint$SplitTunnel' => '<p>Indicates whether split-tunnel is enabled in the Client VPN endpoint.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>', 'CloudWatchLogOptions$LogEnabled' => '<p>Status of VPN tunnel logging feature. Default value is <code>False</code>.</p> <p>Valid values: <code>True</code> | <code>False</code> </p>', 'CloudWatchLogOptionsSpecification$LogEnabled' => '<p>Enable or disable VPN tunnel logging feature. Default value is <code>False</code>.</p> <p>Valid values: <code>True</code> | <code>False</code> </p>', 'ConfirmProductInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ConfirmProductInstanceResult$Return' => '<p>The return value of the request. Returns <code>true</code> if the specified product code is owned by the requester and associated with the specified instance.</p>', 'ConnectionLogOptions$Enabled' => '<p>Indicates whether connection logging is enabled.</p>', 'ConnectionLogResponseOptions$Enabled' => '<p>Indicates whether client connection logging is enabled for the Client VPN endpoint.</p>', 'CopyFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopyImageRequest$Encrypted' => '<p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Use encryption with EBS-backed AMIs</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CopyImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopyImageRequest$CopyImageTags' => '<p>Indicates whether to include your user-defined AMI tags when copying the AMI.</p> <p>The following tags will not be copied:</p> <ul> <li> <p>System tags (prefixed with <code>aws:</code>)</p> </li> <li> <p>For public and shared AMIs, user-defined tags that are attached by other Amazon Web Services accounts</p> </li> </ul> <p>Default: Your user-defined AMI tags are not copied.</p>', 'CopySnapshotRequest$Encrypted' => '<p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p>', 'CopySnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCapacityReservationBySplittingRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCapacityReservationFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCapacityReservationRequest$EbsOptimized' => '<p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>', 'CreateCapacityReservationRequest$EphemeralStorage' => '<p> <i>Deprecated.</i> </p>', 'CreateCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCarrierGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateClientVpnEndpointRequest$SplitTunnel' => '<p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p> <p>By default, split-tunnel on a VPN endpoint is disabled.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>', 'CreateClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateClientVpnRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCoipPoolRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDefaultSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDefaultSubnetRequest$Ipv6Native' => '<p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>', 'CreateDefaultVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateEgressOnlyInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFleetRequest$TerminateInstancesWithExpiration' => '<p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>', 'CreateFleetRequest$ReplaceUnhealthyInstances' => '<p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CreateFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$NoReboot' => '<p>Indicates whether or not the instance should be automatically rebooted before creating the image. Specify one of the following values:</p> <ul> <li> <p> <code>true</code> - The instance is not rebooted before creating the image. This creates crash-consistent snapshots that include only the data that has been written to the volumes at the time the snapshots are created. Buffered data and data in memory that has not yet been written to the volumes is not included in the snapshots.</p> </li> <li> <p> <code>false</code> - The instance is rebooted before creating the image. This ensures that all buffered data and data in memory is written to the volumes before the snapshots are created.</p> </li> </ul> <p>Default: <code>false</code> </p>', 'CreateInstanceConnectEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateInstanceConnectEndpointRequest$PreserveClientIp' => '<p>Indicates whether the client IP address is preserved as the source. The following are the possible values.</p> <ul> <li> <p> <code>true</code> - Use the client IP address as the source.</p> </li> <li> <p> <code>false</code> - Use the network interface IP address as the source.</p> </li> </ul> <p>Default: <code>false</code> </p>', 'CreateInstanceEventWindowRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateIpamExternalResourceVerificationTokenRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateIpamPoolRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateIpamPoolRequest$AutoImport' => '<p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool\'s allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p> <p>A locale must be set on the pool for this feature to work.</p>', 'CreateIpamPoolRequest$PubliclyAdvertisable' => '<p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>', 'CreateIpamRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateIpamRequest$EnablePrivateGua' => '<p>Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by default.</p>', 'CreateIpamResourceDiscoveryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateIpamScopeRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLaunchTemplateVersionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLaunchTemplateVersionRequest$ResolveAlias' => '<p>If <code>true</code>, and if a Systems Manager parameter is specified for <code>ImageId</code>, the AMI ID is displayed in the response for <code>imageID</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#use-an-ssm-parameter-instead-of-an-ami-id">Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>false</code> </p>', 'CreateLocalGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLocalGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLocalGatewayRouteTableVpcAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNatGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$Egress' => '<p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>', 'CreateNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInsightsAccessScopeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInsightsPathRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfacePermissionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfaceRequest$EnablePrimaryIpv6' => '<p>If you’re creating a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to relies on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address associated with the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. If you have multiple IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.</p>', 'CreatePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreatePublicIpv4PoolRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateReplaceRootVolumeTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateReplaceRootVolumeTaskRequest$DeleteReplacedRootVolume' => '<p>Indicates whether to automatically delete the original root volume after the root volume replacement task completes. To delete the original root volume, specify <code>true</code>. If you choose to keep the original root volume after the replacement task completes, you must manually delete it when you no longer need it.</p>', 'CreateRestoreImageTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CreateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateStoreImageTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSubnetCidrReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSubnetRequest$Ipv6Native' => '<p>Indicates whether to create an IPv6 only subnet.</p>', 'CreateTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorFilterRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorTargetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayConnectPeerRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayConnectRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayPolicyTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayPrefixListReferenceRequest$Blackhole' => '<p>Indicates whether to drop traffic that matches this route.</p>', 'CreateTransitGatewayPrefixListReferenceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRouteRequest$Blackhole' => '<p>Indicates whether to drop traffic that matches this route.</p>', 'CreateTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRouteTableAnnouncementRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVerifiedAccessEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVerifiedAccessGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVerifiedAccessInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVerifiedAccessInstanceRequest$FIPSEnabled' => '<p>Enable or disable support for Federal Information Processing Standards (FIPS) on the instance.</p>', 'CreateVerifiedAccessTrustProviderRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$Encrypted' => '<p>Indicates whether the volume should be encrypted. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default">Encryption by default</a> in the <i>Amazon EBS User Guide</i>.</p> <p>Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances">Supported instance types</a>.</p>', 'CreateVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$MultiAttachEnabled' => '<p>Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built on the Nitro System</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.</p>', 'CreateVpcEndpointConnectionNotificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointRequest$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.</p> <p>To use a private hosted zone, you must set the following VPC attributes to <code>true</code>: <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC attributes.</p> <p>Default: <code>true</code> </p>', 'CreateVpcEndpointServiceConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointServiceConfigurationRequest$AcceptanceRequired' => '<p>Indicates whether requests from service consumers to create an endpoint to your service must be accepted manually.</p>', 'CreateVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcRequest$AmazonProvidedIpv6CidrBlock' => '<p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.</p>', 'CreateVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCarrierGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteClientVpnRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCoipPoolRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteEgressOnlyInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteEgressOnlyInternetGatewayResult$ReturnCode' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DeleteFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFleetsRequest$TerminateInstances' => '<p>Indicates whether to terminate the associated instances when the EC2 Fleet is deleted. The default is to terminate the instances.</p> <p>To let the instances continue to run after the EC2 Fleet is deleted, specify <code>no-terminate-instances</code>. Supported only for fleets of type <code>maintain</code> and <code>request</code>.</p> <p>For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted <code>instant</code> fleet with running instances is not supported.</p>', 'DeleteFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFpgaImageResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'DeleteInstanceConnectEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteInstanceEventWindowRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteInstanceEventWindowRequest$ForceDelete' => '<p>Specify <code>true</code> to force delete the event window. Use the force delete parameter if the event window is currently associated with targets.</p>', 'DeleteInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteIpamExternalResourceVerificationTokenRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteIpamPoolRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteIpamPoolRequest$Cascade' => '<p>Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.</p> <important> <p>You can only use this option to delete pools in the private scope or pools in the public scope with a source resource. A source resource is a resource used to provision CIDRs to a resource planning pool.</p> </important>', 'DeleteIpamRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteIpamRequest$Cascade' => '<p>Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes. You cannot delete the IPAM with this option if there is a pool in your public scope. If you use this option, IPAM does the following:</p> <ul> <li> <p>Deallocates any CIDRs allocated to VPC resources (such as VPCs) in pools in private scopes.</p> <note> <p>No VPC resources are deleted as a result of enabling this option. The CIDR associated with the resource will no longer be allocated from an IPAM pool, but the CIDR itself will remain unchanged.</p> </note> </li> <li> <p>Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private scopes.</p> </li> <li> <p>Deletes all IPAM pools in private scopes.</p> </li> <li> <p>Deletes all non-default private scopes in the IPAM.</p> </li> <li> <p>Deletes the default public and private scopes and the IPAM.</p> </li> </ul>', 'DeleteIpamResourceDiscoveryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteIpamScopeRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteKeyPairResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'DeleteLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLaunchTemplateVersionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteTableVpcAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNatGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$Egress' => '<p>Indicates whether the rule is an egress rule.</p>', 'DeleteNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInsightsAccessScopeAnalysisRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInsightsAccessScopeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInsightsAnalysisRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInsightsPathRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInterfacePermissionRequest$Force' => '<p>Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.</p>', 'DeleteNetworkInterfacePermissionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInterfacePermissionResult$Return' => '<p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>', 'DeleteNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeletePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeletePublicIpv4PoolRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeletePublicIpv4PoolResult$ReturnValue' => '<p>Information about the result of deleting the public IPv4 pool.</p>', 'DeleteQueuedReservedInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSubnetCidrReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorFilterRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorTargetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayConnectPeerRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayConnectRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayPolicyTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayPrefixListReferenceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRouteTableAnnouncementRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVerifiedAccessEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVerifiedAccessGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVerifiedAccessInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVerifiedAccessTrustProviderRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointConnectionNotificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointServiceConfigurationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DeleteVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeprovisionByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeprovisionIpamByoasnRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeprovisionIpamPoolCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeprovisionPublicIpv4PoolCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterInstanceTagAttributeRequest$IncludeAllTagsOfInstance' => '<p>Indicates whether to deregister all tag keys in the current Region. Specify <code>false</code> to deregister all tag keys.</p>', 'DeregisterTransitGatewayMulticastGroupMembersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterTransitGatewayMulticastGroupSourcesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAccountAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAddressTransfersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAddressesAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAggregateIdFormatRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAggregateIdFormatResult$UseLongIdsAggregated' => '<p>Indicates whether all resource types in the Region are configured to use longer IDs. This value is only <code>true</code> if all users are configured to use longer IDs for all resources types in the Region.</p>', 'DescribeAvailabilityZonesRequest$AllAvailabilityZones' => '<p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.</p> <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>', 'DescribeAvailabilityZonesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAwsNetworkPerformanceMetricSubscriptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeBundleTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeByoipCidrsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCapacityBlockOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCapacityReservationFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCapacityReservationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCarrierGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClassicLinkInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnAuthorizationRulesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnTargetNetworksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCoipPoolsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeConversionTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCustomerGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeEgressOnlyInternetGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeElasticGpusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeExportImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFastLaunchImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFpgaImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImagesRequest$IncludeDeprecated' => '<p>Specifies whether to include deprecated AMIs.</p> <p>Default: No deprecated AMIs are included in the response.</p> <note> <p>If you are the AMI owner, all deprecated AMIs appear in the response regardless of what you specify for this parameter.</p> </note>', 'DescribeImagesRequest$IncludeDisabled' => '<p>Specifies whether to include disabled AMIs.</p> <p>Default: No disabled AMIs are included in the response.</p>', 'DescribeImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportSnapshotTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceConnectEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceCreditSpecificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceEventWindowsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$IncludeAllInstances' => '<p>When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the health status for running instances only.</p> <p>Default: <code>false</code> </p>', 'DescribeInstanceTopologyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceTypeOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceTypesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInternetGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamByoasnRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamExternalResourceVerificationTokensRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamPoolsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamResourceDiscoveriesRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamResourceDiscoveryAssociationsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamScopesRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpamsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpv6PoolsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeKeyPairsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeKeyPairsRequest$IncludePublicKey' => '<p>If <code>true</code>, the public key material is included in the response.</p> <p>Default: <code>false</code> </p>', 'DescribeLaunchTemplateVersionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLaunchTemplateVersionsRequest$ResolveAlias' => '<p>If <code>true</code>, and if a Systems Manager parameter is specified for <code>ImageId</code>, the AMI ID is displayed in the response for <code>imageId</code>.</p> <p>If <code>false</code>, and if a Systems Manager parameter is specified for <code>ImageId</code>, the parameter is displayed in the response for <code>imageId</code>.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#use-an-ssm-parameter-instead-of-an-ami-id">Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>false</code> </p>', 'DescribeLaunchTemplatesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayVirtualInterfacesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLockedSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeManagedPrefixListsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeMovingAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNatGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkAclsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInsightsAccessScopeAnalysesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInsightsAccessScopesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInsightsAnalysesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInsightsPathsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfaceAttributeResult$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to a network interface. This option can be enabled for any network interface but will only apply to the primary network interface (eth0).</p>', 'DescribeNetworkInterfacesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePlacementGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePrefixListsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePrincipalIdFormatRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRegionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRegionsRequest$AllRegions' => '<p>Indicates whether to display all Regions, including Regions that are disabled for your account.</p>', 'DescribeReplaceRootVolumeTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeReservedInstancesOfferingsRequest$IncludeMarketplace' => '<p>Include Reserved Instance Marketplace offerings in the response.</p>', 'DescribeReservedInstancesOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeReservedInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstanceAvailabilityRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupReferencesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupRulesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotTierStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotPriceHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeStaleSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeStoreImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSubnetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorFilterRulesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorFiltersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorSessionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorTargetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayConnectPeersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayConnectsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayMulticastDomainsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayPeeringAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayPolicyTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayRouteTableAnnouncementsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayVpcAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrunkInterfaceAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVerifiedAccessEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVerifiedAccessGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVerifiedAccessInstanceLoggingConfigurationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVerifiedAccessInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVerifiedAccessTrustProvidersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumesModificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointConnectionNotificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServiceConfigurationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServicePermissionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServicesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcPeeringConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DestinationOptionsRequest$HiveCompatiblePartitions' => '<p>Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is <code>false</code>.</p>', 'DestinationOptionsRequest$PerHourPartition' => '<p>Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. The default is <code>false</code>.</p>', 'DestinationOptionsResponse$HiveCompatiblePartitions' => '<p>Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3.</p>', 'DestinationOptionsResponse$PerHourPartition' => '<p>Indicates whether to partition the flow log per hour.</p>', 'DetachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DetachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$Force' => '<p>Specifies whether to force a detachment.</p> <note> <ul> <li> <p>Use the <code>Force</code> parameter only as a last resort to detach a network interface from a failed instance. </p> </li> <li> <p>If you use the <code>Force</code> parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.</p> </li> <li> <p>If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata</a> might not get updated. This means that the attributes associated with the detached network interface might still be visible. The instance metadata will get updated when you stop and start the instance.</p> </li> </ul> </note>', 'DetachVerifiedAccessTrustProviderRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachVolumeRequest$Force' => '<p>Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file system. Use this option only as a last resort to detach a volume from a failed instance. The instance won\'t have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures.</p>', 'DetachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableAddressTransferRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableAwsNetworkPerformanceMetricSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableAwsNetworkPerformanceMetricSubscriptionResult$Output' => '<p>Indicates whether the unsubscribe action was successful.</p>', 'DisableEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>The updated status of encryption by default.</p>', 'DisableFastLaunchRequest$Force' => '<p>Forces the image settings to turn off Windows fast launch for your Windows AMI. This parameter overrides any errors that are encountered while cleaning up resources in your account.</p>', 'DisableFastLaunchRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableImageBlockPublicAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableImageDeprecationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableImageDeprecationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisableImageDeregistrationProtectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableImageResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisableIpamOrganizationAdminAccountRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableIpamOrganizationAdminAccountResult$Success' => '<p>The result of disabling the IPAM account.</p>', 'DisableSerialConsoleAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableSerialConsoleAccessResult$SerialConsoleAccessEnabled' => '<p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for your account. If <code>false</code>, access to the EC2 serial console of all instances is disabled for your account.</p>', 'DisableSnapshotBlockPublicAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableTransitGatewayRouteTablePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVgwRoutePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisassociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateEnclaveCertificateIamRoleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateEnclaveCertificateIamRoleResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisassociateInstanceEventWindowRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateIpamByoasnRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateIpamResourceDiscoveryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateNatGatewayAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTransitGatewayPolicyTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTrunkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTrunkInterfaceResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DnsOptions$PrivateDnsOnlyForInboundResolverEndpoint' => '<p>Indicates whether to enable private DNS only for inbound endpoints.</p>', 'DnsOptionsSpecification$PrivateDnsOnlyForInboundResolverEndpoint' => '<p>Indicates whether to enable private DNS only for inbound endpoints. This option is available only for services that support both gateway and interface endpoints. It routes traffic that originates from the VPC to the gateway endpoint and traffic that originates from on-premises to the interface endpoint.</p>', 'DnsServersOptionsModifyStructure$Enabled' => '<p>Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS servers.</p>', 'EbsBlockDevice$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'EbsBlockDevice$Encrypted' => '<p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html#encryption-parameters">Amazon EBS encryption</a> in the <i>Amazon EBS User Guide</i>.</p> <p>In no case can you remove encryption from an encrypted volume.</p> <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances">Supported instance types</a>.</p> <p>This parameter is not returned by <a>DescribeImageAttribute</a>.</p> <p>For <a>CreateImage</a> and <a>RegisterImage</a>, whether you can include this parameter, and the allowed values differ depending on the type of block device mapping you are creating.</p> <ul> <li> <p>If you are creating a block device mapping for a <b>new (empty) volume</b>, you can include this parameter, and specify either <code>true</code> for an encrypted volume, or <code>false</code> for an unencrypted volume. If you omit this parameter, it defaults to <code>false</code> (unencrypted).</p> </li> <li> <p>If you are creating a block device mapping from an <b>existing encrypted or unencrypted snapshot</b>, you must omit this parameter. If you include this parameter, the request will fail, regardless of the value that you specify.</p> </li> <li> <p>If you are creating a block device mapping from an <b>existing unencrypted volume</b>, you can include this parameter, but you must specify <code>false</code>. If you specify <code>true</code>, the request will fail. In this case, we recommend that you omit the parameter.</p> </li> <li> <p>If you are creating a block device mapping from an <b>existing encrypted volume</b>, you can include this parameter, and specify either <code>true</code> or <code>false</code>. However, if you specify <code>false</code>, the parameter is ignored and the block device mapping is always encrypted. In this case, we recommend that you omit the parameter.</p> </li> </ul>', 'EbsInstanceBlockDevice$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'EbsInstanceBlockDeviceSpecification$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'Ec2InstanceConnectEndpoint$PreserveClientIp' => '<p>Indicates whether your client\'s IP address is preserved as the source. The value is <code>true</code> or <code>false</code>.</p> <ul> <li> <p>If <code>true</code>, your client\'s IP address is used when you connect to a resource.</p> </li> <li> <p>If <code>false</code>, the elastic network interface IP address is used when you connect to a resource.</p> </li> </ul> <p>Default: <code>true</code> </p>', 'EnaSrdSpecification$EnaSrdEnabled' => '<p>Indicates whether ENA Express is enabled for the network interface.</p>', 'EnaSrdSpecificationRequest$EnaSrdEnabled' => '<p>Specifies whether ENA Express is enabled for the network interface when you launch an instance from your launch template.</p>', 'EnaSrdUdpSpecification$EnaSrdUdpEnabled' => '<p>Indicates whether UDP traffic to and from the instance uses ENA Express. To specify this setting, you must first enable ENA Express.</p>', 'EnaSrdUdpSpecificationRequest$EnaSrdUdpEnabled' => '<p>Indicates whether UDP traffic uses ENA Express for your instance. To ensure that UDP traffic can use ENA Express when you launch an instance, you must also set <b>EnaSrdEnabled</b> in the <b>EnaSrdSpecificationRequest</b> to <code>true</code> in your launch template.</p>', 'EnableAddressTransferRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableAwsNetworkPerformanceMetricSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableAwsNetworkPerformanceMetricSubscriptionResult$Output' => '<p>Indicates whether the subscribe action was successful.</p>', 'EnableEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>The updated status of encryption by default.</p>', 'EnableFastLaunchRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableImageBlockPublicAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableImageDeprecationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableImageDeprecationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnableImageDeregistrationProtectionRequest$WithCooldown' => '<p>If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is disabled.</p>', 'EnableImageDeregistrationProtectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableImageResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnableIpamOrganizationAdminAccountRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableIpamOrganizationAdminAccountResult$Success' => '<p>The result of enabling the IPAM account.</p>', 'EnableReachabilityAnalyzerOrganizationSharingRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableReachabilityAnalyzerOrganizationSharingResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'EnableSerialConsoleAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableSerialConsoleAccessResult$SerialConsoleAccessEnabled' => '<p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for your account. If <code>false</code>, access to the EC2 serial console of all instances is disabled for your account.</p>', 'EnableSnapshotBlockPublicAccessRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableTransitGatewayRouteTablePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVgwRoutePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVolumeIORequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnclaveOptions$Enabled' => '<p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>', 'EnclaveOptionsRequest$Enabled' => '<p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>', 'ExportClientVpnClientCertificateRevocationListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportClientVpnClientConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportTransitGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'FleetCapacityReservation$EbsOptimized' => '<p>Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.</p>', 'FleetData$TerminateInstancesWithExpiration' => '<p>Indicates whether running instances should be terminated when the EC2 Fleet expires. </p>', 'FleetData$ReplaceUnhealthyInstances' => '<p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'FpgaImage$Public' => '<p>Indicates whether the AFI is public.</p>', 'FpgaImage$DataRetentionSupport' => '<p>Indicates whether data retention support is enabled for the AFI.</p>', 'GetAssociatedEnclaveCertificateIamRolesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetAssociatedIpv6PoolCidrsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetAwsNetworkPerformanceDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetCapacityReservationUsageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetCoipPoolUsageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleOutputRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleOutputRequest$Latest' => '<p>When enabled, retrieves the latest console output for the instance.</p> <p>Default: disabled (<code>false</code>)</p>', 'GetConsoleScreenshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleScreenshotRequest$WakeUp' => '<p>When set to <code>true</code>, acts as keystroke input and wakes up an instance that\'s in standby or "sleep" mode.</p>', 'GetDefaultCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>Indicates whether encryption by default is enabled.</p>', 'GetFlowLogsIntegrationTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetGroupsForCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetImageBlockPublicAccessStateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetInstanceMetadataDefaultsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetInstanceTpmEkPubRequest$DryRun' => '<p>Specify this parameter to verify whether the request will succeed, without actually making the request. If the request will succeed, the response is <code>DryRunOperation</code>. Otherwise, the response is <code>UnauthorizedOperation</code>.</p>', 'GetInstanceTypesFromInstanceRequirementsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetInstanceUefiDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamAddressHistoryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamDiscoveredAccountsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamDiscoveredPublicAddressesRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamDiscoveredResourceCidrsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamPoolAllocationsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamPoolCidrsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetIpamResourceCidrsRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetLaunchTemplateDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetManagedPrefixListAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetManagedPrefixListEntriesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetNetworkInsightsAccessScopeAnalysisFindingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetNetworkInsightsAccessScopeContentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetPasswordDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteResult$IsValidExchange' => '<p>If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.</p>', 'GetSecurityGroupsForVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetSerialConsoleAccessStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetSerialConsoleAccessStatusResult$SerialConsoleAccessEnabled' => '<p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for your account. If <code>false</code>, access to the EC2 serial console of all instances is disabled for your account.</p>', 'GetSnapshotBlockPublicAccessStateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetSpotPlacementScoresRequest$SingleAvailabilityZone' => '<p>Specify <code>true</code> so that the response returns a list of scored Availability Zones. Otherwise, the response returns a list of scored Regions.</p> <p>A list of scored Availability Zones is useful if you want to launch all of your Spot capacity into a single Availability Zone.</p>', 'GetSpotPlacementScoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetSubnetCidrReservationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayAttachmentPropagationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayMulticastDomainAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayPolicyTableAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayPolicyTableEntriesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayPrefixListReferencesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayRouteTableAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayRouteTablePropagationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetVerifiedAccessEndpointPolicyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetVerifiedAccessEndpointPolicyResult$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'GetVerifiedAccessGroupPolicyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetVerifiedAccessGroupPolicyResult$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'GetVpnConnectionDeviceSampleConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetVpnConnectionDeviceTypesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetVpnTunnelReplacementStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'HibernationOptions$Configured' => '<p>If <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>', 'HibernationOptionsRequest$Configured' => '<p>Set to <code>true</code> to enable your instance for hibernation.</p> <p>For Spot Instances, if you set <code>Configured</code> to <code>true</code>, either omit the <code>InstanceInterruptionBehavior</code> parameter (for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotMarketOptions.html"> <code>SpotMarketOptions</code> </a>), or set it to <code>hibernate</code>. When <code>Configured</code> is true:</p> <ul> <li> <p>If you omit <code>InstanceInterruptionBehavior</code>, it defaults to <code>hibernate</code>.</p> </li> <li> <p>If you set <code>InstanceInterruptionBehavior</code> to a value other than <code>hibernate</code>, you\'ll get an error.</p> </li> </ul> <p>Default: <code>false</code> </p>', 'Host$MemberOfServiceLinkedResourceGroup' => '<p>Indicates whether the Dedicated Host is in a host resource group. If <b>memberOfServiceLinkedResourceGroup</b> is <code>true</code>, the host is in a host resource group; otherwise, it is not.</p>', 'IdFormat$UseLongIds' => '<p>Indicates whether longer IDs (17-character IDs) are enabled for the resource.</p>', 'Image$Public' => '<p>Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.</p>', 'Image$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'ImportClientVpnClientCertificateRevocationListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportClientVpnClientCertificateRevocationListResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ImportImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportImageRequest$Encrypted' => '<p>Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportImageResult$Encrypted' => '<p>Indicates whether the AMI is encrypted.</p>', 'ImportImageTask$Encrypted' => '<p>Indicates whether the image is encrypted.</p>', 'ImportInstanceLaunchSpecification$Monitoring' => '<p>Indicates whether monitoring is enabled.</p>', 'ImportInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportSnapshotRequest$Encrypted' => '<p>Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'Instance$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'Instance$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'Instance$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'InstanceAttachmentEnaSrdSpecification$EnaSrdEnabled' => '<p>Indicates whether ENA Express is enabled for the network interface.</p>', 'InstanceAttachmentEnaSrdUdpSpecification$EnaSrdUdpEnabled' => '<p>Indicates whether UDP traffic to and from the instance uses ENA Express. To specify this setting, you must first enable ENA Express.</p>', 'InstanceIpv6Address$IsPrimaryIpv6' => '<p>Determines if an IPv6 address associated with a network interface is the primary IPv6 address. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>', 'InstanceNetworkInterface$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'InstanceNetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'InstanceNetworkInterfaceSpecification$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'InstanceNetworkInterfaceSpecification$DeleteOnTermination' => '<p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>', 'InstanceNetworkInterfaceSpecification$AssociateCarrierIpAddress' => '<p>Indicates whether to assign a carrier IP address to the network interface.</p> <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP address</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.</p>', 'InstanceNetworkInterfaceSpecification$PrimaryIpv6' => '<p>The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. For more information about primary IPv6 addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>', 'InstancePrivateIpAddress$Primary' => '<p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>', 'InstanceRequirements$RequireHibernateSupport' => '<p>Indicates whether instance types must support hibernation for On-Demand Instances.</p> <p>This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a>.</p> <p>Default: <code>false</code> </p>', 'InstanceRequirementsRequest$RequireHibernateSupport' => '<p>Indicates whether instance types must support hibernation for On-Demand Instances.</p> <p>This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a>.</p> <p>Default: <code>false</code> </p>', 'InstanceSpecification$ExcludeBootVolume' => '<p>Excludes the root volume from being snapshotted.</p>', 'InstanceTagNotificationAttribute$IncludeAllTagsOfInstance' => '<p>Indicates wheter all tag keys in the current Region are registered to appear in scheduled event notifications. <code>true</code> indicates that all tag keys in the current Region are registered.</p>', 'Ipam$EnablePrivateGua' => '<p>Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by default.</p>', 'IpamPool$AutoImport' => '<p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool\'s allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p> <p>A locale must be set on the pool for this feature to work.</p>', 'IpamPool$PubliclyAdvertisable' => '<p>Determines if a pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>', 'IpamResourceDiscovery$IsDefault' => '<p>Defines if the resource discovery is the default. The default resource discovery is the resource discovery automatically created when you create an IPAM.</p>', 'IpamResourceDiscoveryAssociation$IsDefault' => '<p>Defines if the resource discovery is the default. When you create an IPAM, a default resource discovery is created for your IPAM and it\'s associated with your IPAM.</p>', 'IpamScope$IsDefault' => '<p>Defines if the scope is the default scope or not.</p>', 'LaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'LaunchTemplateEbsBlockDevice$Encrypted' => '<p>Indicates whether the EBS volume is encrypted.</p>', 'LaunchTemplateEbsBlockDevice$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'LaunchTemplateEbsBlockDeviceRequest$Encrypted' => '<p>Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you are creating a volume from a snapshot, you can\'t specify an encryption value.</p>', 'LaunchTemplateEbsBlockDeviceRequest$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'LaunchTemplateEnaSrdSpecification$EnaSrdEnabled' => '<p>Indicates whether ENA Express is enabled for the network interface.</p>', 'LaunchTemplateEnaSrdUdpSpecification$EnaSrdUdpEnabled' => '<p>Indicates whether UDP traffic to and from the instance uses ENA Express. To specify this setting, you must first enable ENA Express.</p>', 'LaunchTemplateEnclaveOptions$Enabled' => '<p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>', 'LaunchTemplateEnclaveOptionsRequest$Enabled' => '<p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>', 'LaunchTemplateHibernationOptions$Configured' => '<p>If this parameter is set to <code>true</code>, the instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>', 'LaunchTemplateHibernationOptionsRequest$Configured' => '<p>If you set this parameter to <code>true</code>, the instance is enabled for hibernation.</p> <p>Default: <code>false</code> </p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$AssociateCarrierIpAddress' => '<p>Indicates whether to associate a Carrier IP address with eth0 for a new network interface.</p> <p>Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$AssociatePublicIpAddress' => '<p>Indicates whether to associate a public IPv4 address with eth0 for a new network interface.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$PrimaryIpv6' => '<p>The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. For more information about primary IPv6 addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$AssociateCarrierIpAddress' => '<p>Associates a Carrier IP address with eth0 for a new network interface.</p> <p>Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <i>Wavelength Developer Guide</i>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$AssociatePublicIpAddress' => '<p>Associates a public IPv4 address with eth0 for a new network interface.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$PrimaryIpv6' => '<p>The primary IPv6 address of the network interface. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. For more information about primary IPv6 addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>', 'LaunchTemplatePrivateDnsNameOptions$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'LaunchTemplatePrivateDnsNameOptions$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'LaunchTemplatePrivateDnsNameOptionsRequest$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'LaunchTemplatePrivateDnsNameOptionsRequest$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'LaunchTemplateVersion$DefaultVersion' => '<p>Indicates whether the version is the default version.</p>', 'LaunchTemplatesMonitoring$Enabled' => '<p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', 'LaunchTemplatesMonitoringRequest$Enabled' => '<p>Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled.</p>', 'ListImagesInRecycleBinRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ListSnapshotsInRecycleBinRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'LockSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyAddressAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyAvailabilityZoneGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyAvailabilityZoneGroupResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyCapacityReservationFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyCapacityReservationFleetRequest$RemoveEndDate' => '<p>Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the end date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly cancel it using the <b>CancelCapacityReservationFleet</b> action.</p> <p>You can\'t specify <b>RemoveEndDate</b> and <b> EndDate</b> in the same request.</p>', 'ModifyCapacityReservationFleetResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyCapacityReservationRequest$Accept' => '<p>Reserved. Capacity Reservations you have created are accepted by default.</p>', 'ModifyCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyCapacityReservationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyClientVpnEndpointRequest$SplitTunnel' => '<p>Indicates whether the VPN is split-tunnel.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>', 'ModifyClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyClientVpnEndpointResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyDefaultCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyFleetResult$Return' => '<p>If the request succeeds, the response returns <code>true</code>. If the request fails, no response is returned, and instead an error message is returned.</p>', 'ModifyFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIdFormatRequest$UseLongIds' => '<p>Indicate whether the resource should use longer IDs (17-character IDs).</p>', 'ModifyIdentityIdFormatRequest$UseLongIds' => '<p>Indicates whether the resource should use longer IDs (17-character IDs)</p>', 'ModifyImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceCapacityReservationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceCapacityReservationAttributesResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyInstanceCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceEventStartTimeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceEventWindowRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceMaintenanceOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceMetadataDefaultsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceMetadataDefaultsResult$Return' => '<p>If the request succeeds, the response returns <code>true</code>. If the request fails, no response is returned, and instead an error message is returned.</p>', 'ModifyInstanceMetadataOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstancePlacementResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyIpamPoolRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIpamPoolRequest$AutoImport' => '<p>If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool\'s allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p> <p>A locale must be set on the pool for this feature to work.</p>', 'ModifyIpamPoolRequest$ClearAllocationDefaultNetmaskLength' => '<p>Clear the default netmask length allocation rule for this pool.</p>', 'ModifyIpamRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIpamRequest$EnablePrivateGua' => '<p>Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by default.</p>', 'ModifyIpamResourceCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIpamResourceCidrRequest$Monitored' => '<p>Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is discovered by IPAM and you can view details about the resource’s CIDR.</p>', 'ModifyIpamResourceDiscoveryRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIpamScopeRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyLocalGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyNetworkInterfaceAttributeRequest$EnablePrimaryIpv6' => '<p>If you’re modifying a network interface in a dual-stack or IPv6-only subnet, you have the option to assign a primary IPv6 IP address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have enabled to use a primary IPv6 address. Use this option if the instance that this ENI will be attached to relies on its IPv6 address not changing. Amazon Web Services will automatically assign an IPv6 address associated with the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. If you have multiple IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.</p>', 'ModifyNetworkInterfaceAttributeRequest$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to a network interface. This option can be enabled for any network interface but will only apply to the primary network interface (eth0).</p>', 'ModifyPrivateDnsNameOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyPrivateDnsNameOptionsRequest$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'ModifyPrivateDnsNameOptionsRequest$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'ModifyPrivateDnsNameOptionsResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifySecurityGroupRulesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySecurityGroupRulesResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'ModifySnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySnapshotTierRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySpotFleetRequestResponse$Return' => '<p>If the request succeeds, the response returns <code>true</code>. If the request fails, no response is returned, and instead an error message is returned.</p>', 'ModifyTrafficMirrorFilterNetworkServicesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTransitGatewayPrefixListReferenceRequest$Blackhole' => '<p>Indicates whether to drop traffic that matches this route.</p>', 'ModifyTransitGatewayPrefixListReferenceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTransitGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessEndpointPolicyRequest$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'ModifyVerifiedAccessEndpointPolicyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessEndpointPolicyResult$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'ModifyVerifiedAccessEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessGroupPolicyRequest$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'ModifyVerifiedAccessGroupPolicyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessGroupPolicyResult$PolicyEnabled' => '<p>The status of the Verified Access policy.</p>', 'ModifyVerifiedAccessGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessInstanceLoggingConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVerifiedAccessTrustProviderRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVolumeRequest$MultiAttachEnabled' => '<p>Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Nitro-based instances</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.</p>', 'ModifyVpcEndpointConnectionNotificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointConnectionNotificationResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointRequest$ResetPolicy' => '<p>(Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default policy allows full access to the service.</p>', 'ModifyVpcEndpointRequest$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.</p>', 'ModifyVpcEndpointResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$RemovePrivateDnsName' => '<p>(Interface endpoint configuration) Removes the private DNS name of the endpoint service.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$AcceptanceRequired' => '<p>Indicates whether requests to create an endpoint to your service must be accepted.</p>', 'ModifyVpcEndpointServiceConfigurationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointServicePayerResponsibilityRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointServicePayerResponsibilityResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointServicePermissionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointServicePermissionsResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcTenancyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcTenancyResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'ModifyVpnConnectionOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnTunnelCertificateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnTunnelOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnTunnelOptionsRequest$SkipTunnelReplacement' => '<p>Choose whether or not to trigger immediate tunnel replacement. This is only applicable when turning on or off <code>EnableTunnelLifecycleControl</code>.</p> <p>Valid values: <code>True</code> | <code>False</code> </p>', 'ModifyVpnTunnelOptionsSpecification$EnableTunnelLifecycleControl' => '<p>Turn on or off tunnel endpoint lifecycle control feature.</p>', 'MonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MoveAddressToVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MoveByoipCidrToIpamRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MoveCapacityReservationInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'NatGatewayAddress$IsPrimary' => '<p>Defines if the IP address is the primary address.</p>', 'NetworkAcl$IsDefault' => '<p>Indicates whether this is the default network ACL for the VPC.</p>', 'NetworkAclEntry$Egress' => '<p>Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).</p>', 'NetworkInsightsAnalysis$NetworkPathFound' => '<p>Indicates whether the destination is reachable from the source.</p>', 'NetworkInterface$RequesterManaged' => '<p>Indicates whether the network interface is being managed by Amazon Web Services.</p>', 'NetworkInterface$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'NetworkInterface$DenyAllIgwTraffic' => '<p>Indicates whether a network interface with an IPv6 address is unreachable from the public internet. If the value is <code>true</code>, inbound traffic from the internet is dropped and you cannot assign an elastic IP address to the network interface. The network interface is reachable from peered VPCs and resources connected through a transit gateway, including on-premises networks.</p>', 'NetworkInterface$Ipv6Native' => '<p>Indicates whether this is an IPv6 only network interface.</p>', 'NetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfaceAttachmentChanges$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfaceIpv6Address$IsPrimaryIpv6' => '<p>Determines if an IPv6 address associated with a network interface is the primary IPv6 address. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyNetworkInterfaceAttribute.html">ModifyNetworkInterfaceAttribute</a>.</p>', 'NetworkInterfacePrivateIpAddress$Primary' => '<p>Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.</p>', 'OnDemandOptions$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptions$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptionsRequest$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptionsRequest$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'PeeringConnectionOptions$AllowDnsResolutionFromRemoteVpc' => '<p>If true, the public DNS hostnames of instances in the specified VPC resolve to private IP addresses when queried from instances in the peer VPC.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Deprecated.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Deprecated.</p>', 'PeeringConnectionOptionsRequest$AllowDnsResolutionFromRemoteVpc' => '<p>If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Deprecated.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Deprecated.</p>', 'PriceSchedule$Active' => '<p>The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.</p> <p>A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.</p>', 'PrivateDnsNameOptionsOnLaunch$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'PrivateDnsNameOptionsOnLaunch$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostname with DNS AAAA records.</p>', 'PrivateDnsNameOptionsRequest$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'PrivateDnsNameOptionsRequest$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'PrivateDnsNameOptionsResponse$EnableResourceNameDnsARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>', 'PrivateDnsNameOptionsResponse$EnableResourceNameDnsAAAARecord' => '<p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>', 'PrivateIpAddressSpecification$Primary' => '<p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>', 'ProvisionByoipCidrRequest$PubliclyAdvertisable' => '<p>(IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p> <p>Default: true</p>', 'ProvisionByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ProvisionByoipCidrRequest$MultiRegion' => '<p>Reserved.</p>', 'ProvisionIpamByoasnRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ProvisionIpamPoolCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ProvisionPublicIpv4PoolCidrRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseCapacityBlockRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseReservedInstancesOfferingRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RebootInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.</p> <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>', 'RegisterInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterInstanceTagAttributeRequest$IncludeAllTagsOfInstance' => '<p>Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to register all tag keys.</p>', 'RegisterTransitGatewayMulticastGroupMembersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterTransitGatewayMulticastGroupSourcesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectTransitGatewayMulticastDomainAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ReleaseAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReleaseIpamPoolAllocationRequest$DryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReleaseIpamPoolAllocationResult$Success' => '<p>Indicates if the release was successful.</p>', 'ReplaceNetworkAclAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$Egress' => '<p>Indicates whether to replace the egress rule.</p> <p>Default: If no value is specified, we replace the ingress rule.</p>', 'ReplaceRootVolumeTask$DeleteReplacedRootVolume' => '<p>Indicates whether the original root volume is to be deleted after the root volume replacement task completes.</p>', 'ReplaceRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceRouteRequest$LocalTarget' => '<p>Specifies whether to reset the local route to its default target (<code>local</code>).</p>', 'ReplaceRouteTableAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceTransitGatewayRouteRequest$Blackhole' => '<p>Indicates whether traffic matching this route is to be dropped.</p>', 'ReplaceTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceVpnTunnelRequest$ApplyPendingMaintenance' => '<p>Trigger pending tunnel endpoint maintenance.</p>', 'ReplaceVpnTunnelRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceVpnTunnelResult$Return' => '<p>Confirmation of replace tunnel operation.</p>', 'ReportInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestLaunchTemplateData$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>', 'RequestLaunchTemplateData$DisableApiTermination' => '<p>If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.</p>', 'RequestLaunchTemplateData$DisableApiStop' => '<p>Indicates whether to enable the instance for stop protection. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop protection for your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RequestSpotFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'ReservationFleetInstanceSpecification$EbsOptimized' => '<p>Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using EBS-optimized instance types.</p>', 'ReservedInstancesOffering$Marketplace' => '<p>Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web Services. If it\'s a Reserved Instance Marketplace offering, this is <code>true</code>.</p>', 'ResetAddressAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetFpgaImageAttributeResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ResetImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResponseLaunchTemplateData$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. </p>', 'ResponseLaunchTemplateData$DisableApiTermination' => '<p>If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2 console, command line tool, or API.</p>', 'ResponseLaunchTemplateData$DisableApiStop' => '<p>Indicates whether the instance is enabled for stop protection. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop protection for your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RestoreAddressToClassicRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreImageFromRecycleBinRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreImageFromRecycleBinResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'RestoreManagedPrefixListVersionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreSnapshotFromRecycleBinRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreSnapshotFromRecycleBinResult$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'RestoreSnapshotTierRequest$PermanentRestore' => '<p>Indicates whether to permanently restore an archived snapshot. To permanently restore an archived snapshot, specify <code>true</code> and omit the <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.</p>', 'RestoreSnapshotTierRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreSnapshotTierResult$IsPermanentRestore' => '<p>Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent restore. <code>false</code> indicates a temporary restore.</p>', 'RevokeClientVpnIngressRequest$RevokeAllGroups' => '<p>Indicates whether access should be revoked for all clients.</p>', 'RevokeClientVpnIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupEgressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'RevokeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupIngressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'RouteTableAssociation$Main' => '<p>Indicates whether this is the main route table.</p>', 'RunInstancesMonitoringEnabled$Enabled' => '<p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', 'RunInstancesRequest$DisableApiTermination' => '<p>If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.</p> <p>Default: <code>false</code> </p>', 'RunInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RunInstancesRequest$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'RunInstancesRequest$DisableApiStop' => '<p>Indicates whether an instance is enabled for stop protection. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop protection</a>. </p>', 'RunInstancesRequest$EnablePrimaryIpv6' => '<p>If you’re launching an instance into a dual-stack or IPv6-only subnet, you can enable assigning a primary IPv6 address. A primary IPv6 address is an IPv6 GUA address associated with an ENI that you have enabled to use a primary IPv6 address. Use this option if an instance relies on its IPv6 address not changing. When you launch the instance, Amazon Web Services will automatically assign an IPv6 address associated with the ENI attached to your instance to be the primary IPv6 address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6 address until the instance is terminated or the network interface is detached. If you have multiple IPv6 addresses associated with an ENI attached to your instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI becomes the primary IPv6 address.</p>', 'RunScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ScheduledInstanceRecurrence$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month.</p>', 'ScheduledInstanceRecurrenceRequest$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month. You can\'t specify this value with a daily schedule.</p>', 'ScheduledInstancesEbs$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'ScheduledInstancesEbs$Encrypted' => '<p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>', 'ScheduledInstancesLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'ScheduledInstancesMonitoring$Enabled' => '<p>Indicates whether monitoring is enabled.</p>', 'ScheduledInstancesNetworkInterface$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'ScheduledInstancesNetworkInterface$DeleteOnTermination' => '<p>Indicates whether to delete the interface when the instance is terminated.</p>', 'ScheduledInstancesPrivateIpAddressConfig$Primary' => '<p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>', 'SearchLocalGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayMulticastGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayRoutesResult$AdditionalRoutesAvailable' => '<p>Indicates whether there are additional routes available.</p>', 'SecurityGroupRule$IsEgress' => '<p>Indicates whether the security group rule is an outbound rule.</p>', 'SendDiagnosticInterruptRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ServiceConfiguration$AcceptanceRequired' => '<p>Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>', 'ServiceConfiguration$ManagesVpcEndpoints' => '<p>Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.</p>', 'ServiceDetail$VpcEndpointPolicySupported' => '<p>Indicates whether the service supports endpoint policies.</p>', 'ServiceDetail$AcceptanceRequired' => '<p>Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.</p>', 'ServiceDetail$ManagesVpcEndpoints' => '<p>Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.</p>', 'Snapshot$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SnapshotInfo$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SnapshotTaskDetail$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SpotFleetLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetMonitoring$Enabled' => '<p>Enables monitoring for the instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetRequestConfigData$TerminateInstancesWithExpiration' => '<p>Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.</p>', 'SpotFleetRequestConfigData$ReplaceUnhealthyInstances' => '<p>Indicates whether Spot Fleet should replace unhealthy instances.</p>', 'SpotOptions$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptions$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all Spot Instances into a single Availability Zone.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptionsRequest$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptionsRequest$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all Spot Instances into a single Availability Zone.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', 'StartInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartNetworkInsightsAccessScopeAnalysisRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartNetworkInsightsAnalysisRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartVpcEndpointServicePrivateDnsVerificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartVpcEndpointServicePrivateDnsVerificationResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'StopInstancesRequest$Hibernate' => '<p>Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot hibernate successfully, a normal shutdown occurs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon EC2 User Guide</i>.</p> <p> Default: <code>false</code> </p>', 'StopInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StopInstancesRequest$Force' => '<p>Forces the instances to stop. The instances do not have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures. This option is not recommended for Windows instances.</p> <p>Default: <code>false</code> </p>', 'Subnet$DefaultForAz' => '<p>Indicates whether this is the default subnet for the Availability Zone.</p>', 'Subnet$MapPublicIpOnLaunch' => '<p>Indicates whether instances launched in this subnet receive a public IPv4 address.</p> <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>', 'Subnet$MapCustomerOwnedIpOnLaunch' => '<p>Indicates whether a network interface created in this subnet (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.</p>', 'Subnet$AssignIpv6AddressOnCreation' => '<p>Indicates whether a network interface created in this subnet (including a network interface created by <a>RunInstances</a>) receives an IPv6 address.</p>', 'Subnet$EnableDns64' => '<p>Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.</p>', 'Subnet$Ipv6Native' => '<p>Indicates whether this is an IPv6 only subnet.</p>', 'TerminateClientVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'TerminateInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'TransitGatewayMulticastGroup$GroupMember' => '<p>Indicates that the resource is a transit gateway multicast group member.</p>', 'TransitGatewayMulticastGroup$GroupSource' => '<p>Indicates that the resource is a transit gateway multicast group member.</p>', 'TransitGatewayPrefixListReference$Blackhole' => '<p>Indicates whether traffic that matches this route is dropped.</p>', 'TransitGatewayRouteTable$DefaultAssociationRouteTable' => '<p>Indicates whether this is the default association route table for the transit gateway.</p>', 'TransitGatewayRouteTable$DefaultPropagationRouteTable' => '<p>Indicates whether this is the default propagation route table for the transit gateway.</p>', 'TunnelOption$EnableTunnelLifecycleControl' => '<p>Status of tunnel endpoint lifecycle control feature.</p>', 'UnassignPrivateNatGatewayAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UnlockSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UnmonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'VerifiedAccessInstance$FipsEnabled' => '<p>Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.</p>', 'VerifiedAccessLogCloudWatchLogsDestination$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogCloudWatchLogsDestinationOptions$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogKinesisDataFirehoseDestination$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogKinesisDataFirehoseDestinationOptions$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogOptions$IncludeTrustContext' => '<p>Indicates whether to include trust data sent by trust providers in the logs.</p>', 'VerifiedAccessLogS3Destination$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogS3DestinationOptions$Enabled' => '<p>Indicates whether logging is enabled.</p>', 'VerifiedAccessLogs$IncludeTrustContext' => '<p>Indicates whether trust data is included in the logs.</p>', 'VerifiedAccessSseSpecificationRequest$CustomerManagedKeyEnabled' => '<p> Enable or disable the use of customer managed KMS keys for server side encryption. </p> <p>Valid values: <code>True</code> | <code>False</code> </p>', 'VerifiedAccessSseSpecificationResponse$CustomerManagedKeyEnabled' => '<p>Indicates whether customer managed KMS keys are in use for server side encryption.</p> <p>Valid values: <code>True</code> | <code>False</code> </p>', 'Volume$Encrypted' => '<p>Indicates whether the volume is encrypted.</p>', 'Volume$FastRestored' => '<note> <p>This parameter is not returned by CreateVolume.</p> </note> <p>Indicates whether the volume was created using fast snapshot restore.</p>', 'Volume$MultiAttachEnabled' => '<p>Indicates whether Amazon EBS Multi-Attach is enabled.</p>', 'VolumeAttachment$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'VolumeModification$TargetMultiAttachEnabled' => '<p>The target setting for Amazon EBS Multi-Attach.</p>', 'VolumeModification$OriginalMultiAttachEnabled' => '<p>The original setting for Amazon EBS Multi-Attach.</p>', 'Vpc$IsDefault' => '<p>Indicates whether the VPC is the default VPC.</p>', 'VpcClassicLink$ClassicLinkEnabled' => '<p>Indicates whether the VPC is enabled for ClassicLink.</p>', 'VpcEndpoint$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.</p>', 'VpcEndpoint$RequesterManaged' => '<p>Indicates whether the endpoint is being managed by its service.</p>', 'VpcPeeringConnectionOptionsDescription$AllowDnsResolutionFromRemoteVpc' => '<p>Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Deprecated.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Deprecated.</p>', 'VpnConnectionOptions$EnableAcceleration' => '<p>Indicates whether acceleration is enabled for the VPN connection.</p>', 'VpnConnectionOptions$StaticRoutesOnly' => '<p>Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don\'t support BGP.</p>', 'VpnConnectionOptionsSpecification$EnableAcceleration' => '<p>Indicate whether to enable acceleration for the VPN connection.</p> <p>Default: <code>false</code> </p>', 'VpnConnectionOptionsSpecification$StaticRoutesOnly' => '<p>Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to create a static route.</p> <p>Default: <code>false</code> </p>', 'VpnTunnelOptionsSpecification$EnableTunnelLifecycleControl' => '<p>Turn on or off tunnel endpoint lifecycle control feature.</p>', 'WithdrawByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', ], ], 'BootModeType' => [ 'base' => NULL, 'refs' => [ 'BootModeTypeList$member' => NULL, ], ], 'BootModeTypeList' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$SupportedBootModes' => '<p>The supported boot modes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'BootModeValues' => [ 'base' => NULL, 'refs' => [ 'Image$BootMode' => '<p>The boot mode of the image. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ImportImageRequest$BootMode' => '<p>The boot mode of the virtual machine.</p> <note> <p>The <code>uefi-preferred</code> boot mode isn\'t supported for importing images. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/prerequisites.html#vmimport-boot-modes">Boot modes</a> in the <i>VM Import/Export User Guide</i>.</p> </note>', 'ImportImageTask$BootMode' => '<p>The boot mode of the virtual machine.</p>', 'Instance$BootMode' => '<p>The boot mode that was specified by the AMI. If the value is <code>uefi-preferred</code>, the AMI supports both UEFI and Legacy BIOS. The <code>currentInstanceBootMode</code> parameter is the boot mode that is used to boot the instance at launch or start.</p> <note> <p>The operating system contained in the AMI must be configured to support the specified boot mode.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'RegisterImageRequest$BootMode' => '<p>The boot mode of the AMI. A value of <code>uefi-preferred</code> indicates that the AMI supports both UEFI and Legacy BIOS.</p> <note> <p>The operating system contained in the AMI must be configured to support the specified boot mode.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'BoxedDouble' => [ 'base' => NULL, 'refs' => [ 'IpamDiscoveredResourceCidr$IpUsage' => '<p>The percentage of IP address space in use. To convert the decimal to a percentage, multiply the decimal by 100. Note the following:</p> <ul> <li> <p>For resources that are VPCs, this is the percentage of IP address space in the VPC that\'s taken up by subnet CIDRs. </p> </li> <li> <p>For resources that are subnets, if the subnet has an IPv4 CIDR provisioned to it, this is the percentage of IPv4 address space in the subnet that\'s in use. If the subnet has an IPv6 CIDR provisioned to it, the percentage of IPv6 address space in use is not represented. The percentage of IPv6 address space in use cannot currently be calculated. </p> </li> <li> <p>For resources that are public IPv4 pools, this is the percentage of IP address space in the pool that\'s been allocated to Elastic IP addresses (EIPs). </p> </li> </ul>', 'IpamResourceCidr$IpUsage' => '<p>The percentage of IP address space in use. To convert the decimal to a percentage, multiply the decimal by 100. Note the following:</p> <ul> <li> <p>For resources that are VPCs, this is the percentage of IP address space in the VPC that\'s taken up by subnet CIDRs. </p> </li> <li> <p>For resources that are subnets, if the subnet has an IPv4 CIDR provisioned to it, this is the percentage of IPv4 address space in the subnet that\'s in use. If the subnet has an IPv6 CIDR provisioned to it, the percentage of IPv6 address space in use is not represented. The percentage of IPv6 address space in use cannot currently be calculated. </p> </li> <li> <p>For resources that are public IPv4 pools, this is the percentage of IP address space in the pool that\'s been allocated to Elastic IP addresses (EIPs). </p> </li> </ul>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataDefaultsResponse$HttpPutResponseHopLimit' => '<p>The maximum number of hops that the metadata token can travel.</p>', 'ModifyInstanceMetadataDefaultsRequest$HttpPutResponseHopLimit' => '<p>The maximum number of hops that the metadata token can travel. To indicate no preference, specify <code>-1</code>.</p> <p>Possible values: Integers from <code>1</code> to <code>64</code>, and <code>-1</code> to indicate no preference</p>', ], ], 'BundleId' => [ 'base' => NULL, 'refs' => [ 'BundleIdStringList$member' => NULL, 'CancelBundleTaskRequest$BundleId' => '<p>The ID of the bundle task.</p>', ], ], 'BundleIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksRequest$BundleIds' => '<p>The bundle task IDs.</p> <p>Default: Describes all your bundle tasks.</p>', ], ], 'BundleInstanceRequest' => [ 'base' => '<p>Contains the parameters for BundleInstance.</p>', 'refs' => [], ], 'BundleInstanceResult' => [ 'base' => '<p>Contains the output of BundleInstance.</p>', 'refs' => [], ], 'BundleTask' => [ 'base' => '<p>Describes a bundle task.</p>', 'refs' => [ 'BundleInstanceResult$BundleTask' => '<p>Information about the bundle task.</p>', 'BundleTaskList$member' => NULL, 'CancelBundleTaskResult$BundleTask' => '<p>Information about the bundle task.</p>', ], ], 'BundleTaskError' => [ 'base' => '<p>Describes an error for <a>BundleInstance</a>.</p>', 'refs' => [ 'BundleTask$BundleTaskError' => '<p>If the task fails, a description of the error.</p>', ], ], 'BundleTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksResult$BundleTasks' => '<p>Information about the bundle tasks.</p>', ], ], 'BundleTaskState' => [ 'base' => NULL, 'refs' => [ 'BundleTask$State' => '<p>The state of the task.</p>', ], ], 'BurstablePerformance' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$BurstablePerformance' => '<p>Indicates whether burstable performance T instance types are included, excluded, or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a>.</p> <ul> <li> <p>To include burstable performance instance types, specify <code>included</code>.</p> </li> <li> <p>To require only burstable performance instance types, specify <code>required</code>.</p> </li> <li> <p>To exclude burstable performance instance types, specify <code>excluded</code>.</p> </li> </ul> <p>Default: <code>excluded</code> </p>', 'InstanceRequirementsRequest$BurstablePerformance' => '<p>Indicates whether burstable performance T instance types are included, excluded, or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a>.</p> <ul> <li> <p>To include burstable performance instance types, specify <code>included</code>.</p> </li> <li> <p>To require only burstable performance instance types, specify <code>required</code>.</p> </li> <li> <p>To exclude burstable performance instance types, specify <code>excluded</code>.</p> </li> </ul> <p>Default: <code>excluded</code> </p>', ], ], 'BurstablePerformanceFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$BurstablePerformanceSupported' => '<p>Indicates whether the instance type is a burstable performance T instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a>.</p>', ], ], 'Byoasn' => [ 'base' => '<p>The Autonomous System Number (ASN) and BYOIP CIDR association.</p>', 'refs' => [ 'ByoasnSet$member' => NULL, 'DeprovisionIpamByoasnResult$Byoasn' => '<p>An ASN and BYOIP CIDR association.</p>', 'ProvisionIpamByoasnResult$Byoasn' => '<p>An ASN and BYOIP CIDR association.</p>', ], ], 'ByoasnSet' => [ 'base' => NULL, 'refs' => [ 'DescribeIpamByoasnResult$Byoasns' => '<p>ASN and BYOIP CIDR associations.</p>', ], ], 'ByoipCidr' => [ 'base' => '<p>Information about an address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).</p>', 'refs' => [ 'AdvertiseByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'ByoipCidrSet$member' => NULL, 'DeprovisionByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'MoveByoipCidrToIpamResult$ByoipCidr' => '<p>The BYOIP CIDR.</p>', 'ProvisionByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'WithdrawByoipCidrResult$ByoipCidr' => '<p>Information about the address pool.</p>', ], ], 'ByoipCidrSet' => [ 'base' => NULL, 'refs' => [ 'DescribeByoipCidrsResult$ByoipCidrs' => '<p>Information about your address ranges.</p>', ], ], 'ByoipCidrState' => [ 'base' => NULL, 'refs' => [ 'ByoipCidr$State' => '<p>The state of the address range.</p> <ul> <li> <p> <code>advertised</code>: The address range is being advertised to the internet by Amazon Web Services.</p> </li> <li> <p> <code>deprovisioned</code>: The address range is deprovisioned.</p> </li> <li> <p> <code>failed-deprovision</code>: The request to deprovision the address range was unsuccessful. Ensure that all EIPs from the range have been deallocated and try again.</p> </li> <li> <p> <code>failed-provision</code>: The request to provision the address range was unsuccessful.</p> </li> <li> <p> <code>pending-deprovision</code>: You’ve submitted a request to deprovision an address range and it\'s pending.</p> </li> <li> <p> <code>pending-provision</code>: You’ve submitted a request to provision an address range and it\'s pending.</p> </li> <li> <p> <code>provisioned</code>: The address range is provisioned and can be advertised. The range is not currently advertised.</p> </li> <li> <p> <code>provisioned-not-publicly-advertisable</code>: The address range is provisioned and cannot be advertised.</p> </li> </ul>', ], ], 'CancelBatchErrorCode' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsError$Code' => '<p>The error code.</p>', ], ], 'CancelBundleTaskRequest' => [ 'base' => '<p>Contains the parameters for CancelBundleTask.</p>', 'refs' => [], ], 'CancelBundleTaskResult' => [ 'base' => '<p>Contains the output of CancelBundleTask.</p>', 'refs' => [], ], 'CancelCapacityReservationFleetError' => [ 'base' => '<p>Describes a Capacity Reservation Fleet cancellation error.</p>', 'refs' => [ 'FailedCapacityReservationFleetCancellationResult$CancelCapacityReservationFleetError' => '<p>Information about the Capacity Reservation Fleet cancellation error.</p>', ], ], 'CancelCapacityReservationFleetErrorCode' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationFleetError$Code' => '<p>The error code.</p>', ], ], 'CancelCapacityReservationFleetErrorMessage' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationFleetError$Message' => '<p>The error message.</p>', ], ], 'CancelCapacityReservationFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityReservationFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelConversionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImageLaunchPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImageLaunchPermissionResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImportTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsError' => [ 'base' => '<p>Describes a Spot Fleet error.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorItem$Error' => '<p>The error.</p>', ], ], 'CancelSpotFleetRequestsErrorItem' => [ 'base' => '<p>Describes a Spot Fleet request that was not successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorSet$member' => NULL, ], ], 'CancelSpotFleetRequestsErrorSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$UnsuccessfulFleetRequests' => '<p>Information about the Spot Fleet requests that are not successfully canceled.</p>', ], ], 'CancelSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsSuccessItem' => [ 'base' => '<p>Describes a Spot Fleet request that was successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsSuccessSet$member' => NULL, ], ], 'CancelSpotFleetRequestsSuccessSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$SuccessfulFleetRequests' => '<p>Information about the Spot Fleet requests that are successfully canceled.</p>', ], ], 'CancelSpotInstanceRequestState' => [ 'base' => NULL, 'refs' => [ 'CancelledSpotInstanceRequest$State' => '<p>The state of the Spot Instance request.</p>', ], ], 'CancelSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelledSpotInstanceRequest' => [ 'base' => '<p>Describes a request to cancel a Spot Instance.</p>', 'refs' => [ 'CancelledSpotInstanceRequestList$member' => NULL, ], ], 'CancelledSpotInstanceRequestList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotInstanceRequestsResult$CancelledSpotInstanceRequests' => '<p>The Spot Instance requests.</p>', ], ], 'CapacityAllocation' => [ 'base' => '<p>Information about instance capacity usage for a Capacity Reservation.</p>', 'refs' => [ 'CapacityAllocations$member' => NULL, ], ], 'CapacityAllocations' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$CapacityAllocations' => '<p>Information about instance capacity usage.</p>', ], ], 'CapacityBlockOffering' => [ 'base' => '<p>The recommended Capacity Block that fits your search requirements.</p>', 'refs' => [ 'CapacityBlockOfferingSet$member' => NULL, ], ], 'CapacityBlockOfferingSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityBlockOfferingsResult$CapacityBlockOfferings' => '<p>The recommended Capacity Block offering for the dates specified.</p>', ], ], 'CapacityReservation' => [ 'base' => '<p>Describes a Capacity Reservation.</p>', 'refs' => [ 'CapacityReservationSet$member' => NULL, 'CreateCapacityReservationBySplittingResult$SourceCapacityReservation' => '<p> Information about the source Capacity Reservation. </p>', 'CreateCapacityReservationBySplittingResult$DestinationCapacityReservation' => '<p> Information about the destination Capacity Reservation. </p>', 'CreateCapacityReservationResult$CapacityReservation' => '<p>Information about the Capacity Reservation.</p>', 'MoveCapacityReservationInstancesResult$SourceCapacityReservation' => '<p> Information about the source Capacity Reservation. </p>', 'MoveCapacityReservationInstancesResult$DestinationCapacityReservation' => '<p> Information about the destination Capacity Reservation. </p>', 'PurchaseCapacityBlockResult$CapacityReservation' => '<p>The Capacity Reservation.</p>', ], ], 'CapacityReservationFleet' => [ 'base' => '<p>Information about a Capacity Reservation Fleet.</p>', 'refs' => [ 'CapacityReservationFleetSet$member' => NULL, ], ], 'CapacityReservationFleetCancellationState' => [ 'base' => '<p>Describes a Capacity Reservation Fleet that was successfully cancelled.</p>', 'refs' => [ 'CapacityReservationFleetCancellationStateSet$member' => NULL, ], ], 'CapacityReservationFleetCancellationStateSet' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationFleetsResult$SuccessfulFleetCancellations' => '<p>Information about the Capacity Reservation Fleets that were successfully cancelled.</p>', ], ], 'CapacityReservationFleetId' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationFleet$CapacityReservationFleetId' => '<p>The ID of the Capacity Reservation Fleet.</p>', 'CapacityReservationFleetCancellationState$CapacityReservationFleetId' => '<p>The ID of the Capacity Reservation Fleet that was successfully cancelled.</p>', 'CapacityReservationFleetIdSet$member' => NULL, 'CreateCapacityReservationFleetResult$CapacityReservationFleetId' => '<p>The ID of the Capacity Reservation Fleet.</p>', 'FailedCapacityReservationFleetCancellationResult$CapacityReservationFleetId' => '<p>The ID of the Capacity Reservation Fleet that could not be cancelled.</p>', 'ModifyCapacityReservationFleetRequest$CapacityReservationFleetId' => '<p>The ID of the Capacity Reservation Fleet to modify.</p>', ], ], 'CapacityReservationFleetIdSet' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationFleetsRequest$CapacityReservationFleetIds' => '<p>The IDs of the Capacity Reservation Fleets to cancel.</p>', 'DescribeCapacityReservationFleetsRequest$CapacityReservationFleetIds' => '<p>The IDs of the Capacity Reservation Fleets to describe.</p>', ], ], 'CapacityReservationFleetSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationFleetsResult$CapacityReservationFleets' => '<p>Information about the Capacity Reservation Fleets.</p>', ], ], 'CapacityReservationFleetState' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationFleet$State' => '<p>The state of the Capacity Reservation Fleet. Possible states include:</p> <ul> <li> <p> <code>submitted</code> - The Capacity Reservation Fleet request has been submitted and Amazon Elastic Compute Cloud is preparing to create the Capacity Reservations.</p> </li> <li> <p> <code>modifying</code> - The Capacity Reservation Fleet is being modified. The Fleet remains in this state until the modification is complete.</p> </li> <li> <p> <code>active</code> - The Capacity Reservation Fleet has fulfilled its total target capacity and it is attempting to maintain this capacity. The Fleet remains in this state until it is modified or deleted.</p> </li> <li> <p> <code>partially_fulfilled</code> - The Capacity Reservation Fleet has partially fulfilled its total target capacity. There is insufficient Amazon EC2 to fulfill the total target capacity. The Fleet is attempting to asynchronously fulfill its total target capacity.</p> </li> <li> <p> <code>expiring</code> - The Capacity Reservation Fleet has reach its end date and it is in the process of expiring. One or more of its Capacity reservations might still be active.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation Fleet has reach its end date. The Fleet and its Capacity Reservations are expired. The Fleet can\'t create new Capacity Reservations.</p> </li> <li> <p> <code>cancelling</code> - The Capacity Reservation Fleet is in the process of being cancelled. One or more of its Capacity reservations might still be active.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation Fleet has been manually cancelled. The Fleet and its Capacity Reservations are cancelled and the Fleet can\'t create new Capacity Reservations.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation Fleet failed to reserve capacity for the specified instance types.</p> </li> </ul>', 'CapacityReservationFleetCancellationState$CurrentFleetState' => '<p>The current state of the Capacity Reservation Fleet.</p>', 'CapacityReservationFleetCancellationState$PreviousFleetState' => '<p>The previous state of the Capacity Reservation Fleet.</p>', 'CreateCapacityReservationFleetResult$State' => '<p>The status of the Capacity Reservation Fleet.</p>', ], ], 'CapacityReservationGroup' => [ 'base' => '<p>Describes a resource group to which a Capacity Reservation has been added.</p>', 'refs' => [ 'CapacityReservationGroupSet$member' => NULL, ], ], 'CapacityReservationGroupSet' => [ 'base' => NULL, 'refs' => [ 'GetGroupsForCapacityReservationResult$CapacityReservationGroups' => '<p>Information about the resource groups to which the Capacity Reservation has been added.</p>', ], ], 'CapacityReservationId' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation to be cancelled.</p>', 'CapacityReservationIdSet$member' => NULL, 'CapacityReservationTarget$CapacityReservationId' => '<p>The ID of the Capacity Reservation in which to run the instance.</p>', 'CreateCapacityReservationBySplittingRequest$SourceCapacityReservationId' => '<p> The ID of the Capacity Reservation from which you want to split the available capacity. </p>', 'FleetCapacityReservation$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', 'GetCapacityReservationUsageRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', 'GetGroupsForCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation. If you specify a Capacity Reservation that is shared with you, the operation returns only Capacity Reservation groups that you own.</p>', 'ModifyCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', 'MoveCapacityReservationInstancesRequest$SourceCapacityReservationId' => '<p> The ID of the Capacity Reservation from which you want to move capacity. </p>', 'MoveCapacityReservationInstancesRequest$DestinationCapacityReservationId' => '<p> The ID of the Capacity Reservation that you want to move capacity into. </p>', ], ], 'CapacityReservationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsRequest$CapacityReservationIds' => '<p>The ID of the Capacity Reservation.</p>', ], ], 'CapacityReservationInstancePlatform' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$InstancePlatform' => '<p>The type of operating system for which the Capacity Reservation reserves capacity.</p>', 'CreateCapacityReservationRequest$InstancePlatform' => '<p>The type of operating system for which to reserve capacity.</p>', 'FleetCapacityReservation$InstancePlatform' => '<p>The type of operating system for which the Capacity Reservation reserves capacity.</p>', 'PurchaseCapacityBlockRequest$InstancePlatform' => '<p>The type of operating system for which to reserve capacity.</p>', 'ReservationFleetInstanceSpecification$InstancePlatform' => '<p>The type of operating system for which the Capacity Reservation Fleet reserves capacity.</p>', ], ], 'CapacityReservationOptions' => [ 'base' => '<p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'OnDemandOptions$CapacityReservationOptions' => '<p>The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CapacityReservationOptionsRequest' => [ 'base' => '<p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'OnDemandOptionsRequest$CapacityReservationOptions' => '<p>The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CapacityReservationPreference' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationSpecification$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li> </ul>', 'CapacityReservationSpecificationResponse$CapacityReservationPreference' => '<p>Describes the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', 'LaunchTemplateCapacityReservationSpecificationRequest$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', 'LaunchTemplateCapacityReservationSpecificationResponse$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', ], ], 'CapacityReservationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsResult$CapacityReservations' => '<p>Information about the Capacity Reservations.</p>', ], ], 'CapacityReservationSpecification' => [ 'base' => '<p>Describes an instance\'s Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.</p> <p>Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.</p>', 'refs' => [ 'ModifyInstanceCapacityReservationAttributesRequest$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option.</p>', 'RunInstancesRequest$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option. If you do not specify this parameter, the instance\'s Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>', ], ], 'CapacityReservationSpecificationResponse' => [ 'base' => '<p>Describes the instance\'s Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'Instance$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option.</p>', ], ], 'CapacityReservationState' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$State' => '<p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul>', 'GetCapacityReservationUsageResult$State' => '<p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul>', ], ], 'CapacityReservationTarget' => [ 'base' => '<p>Describes a target Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'CapacityReservationSpecification$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', 'LaunchTemplateCapacityReservationSpecificationRequest$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', ], ], 'CapacityReservationTargetResponse' => [ 'base' => '<p>Describes a target Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'CapacityReservationSpecificationResponse$CapacityReservationTarget' => '<p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>', 'LaunchTemplateCapacityReservationSpecificationResponse$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', ], ], 'CapacityReservationTenancy' => [ 'base' => NULL, 'refs' => [ 'CapacityBlockOffering$Tenancy' => '<p>The tenancy of the Capacity Block.</p>', 'CapacityReservation$Tenancy' => '<p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li> </ul>', 'CreateCapacityReservationRequest$Tenancy' => '<p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li> </ul>', ], ], 'CapacityReservationType' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$ReservationType' => '<p>The type of Capacity Reservation.</p>', ], ], 'CarrierGateway' => [ 'base' => '<p>Describes a carrier gateway.</p>', 'refs' => [ 'CarrierGatewaySet$member' => NULL, 'CreateCarrierGatewayResult$CarrierGateway' => '<p>Information about the carrier gateway.</p>', 'DeleteCarrierGatewayResult$CarrierGateway' => '<p>Information about the carrier gateway.</p>', ], ], 'CarrierGatewayId' => [ 'base' => NULL, 'refs' => [ 'CarrierGateway$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', 'CarrierGatewayIdSet$member' => NULL, 'CreateRouteRequest$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p> <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>', 'DeleteCarrierGatewayRequest$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', 'ReplaceRouteRequest$CarrierGatewayId' => '<p>[IPv4 traffic only] The ID of a carrier gateway.</p>', 'Route$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', ], ], 'CarrierGatewayIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysRequest$CarrierGatewayIds' => '<p>One or more carrier gateway IDs.</p>', ], ], 'CarrierGatewayMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'CarrierGatewaySet' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysResult$CarrierGateways' => '<p>Information about the carrier gateway.</p>', ], ], 'CarrierGatewayState' => [ 'base' => NULL, 'refs' => [ 'CarrierGateway$State' => '<p>The state of the carrier gateway.</p>', ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'CreateVerifiedAccessEndpointRequest$DomainCertificateArn' => '<p>The ARN of the public TLS/SSL certificate in Amazon Web Services Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.</p>', ], ], 'CertificateAuthentication' => [ 'base' => '<p>Information about the client certificate used for authentication.</p>', 'refs' => [ 'ClientVpnAuthentication$MutualAuthentication' => '<p>Information about the authentication certificates, if applicable.</p>', ], ], 'CertificateAuthenticationRequest' => [ 'base' => '<p>Information about the client certificate to be used for authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$MutualAuthentication' => '<p>Information about the authentication certificates to be used, if applicable. You must provide this information if <b>Type</b> is <code>certificate-authentication</code>.</p>', ], ], 'CertificateId' => [ 'base' => NULL, 'refs' => [ 'AssociateEnclaveCertificateIamRoleRequest$CertificateArn' => '<p>The ARN of the ACM certificate with which to associate the IAM role.</p>', 'DisassociateEnclaveCertificateIamRoleRequest$CertificateArn' => '<p>The ARN of the ACM certificate from which to disassociate the IAM role.</p>', 'GetAssociatedEnclaveCertificateIamRolesRequest$CertificateArn' => '<p>The ARN of the ACM certificate for which to view the associated IAM roles, encryption keys, and Amazon S3 object information.</p>', ], ], 'CidrAuthorizationContext' => [ 'base' => '<p>Provides authorization for Amazon to bring a specific IP address range to a specific Amazon Web Services account using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip">Configuring your BYOIP address range</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'ProvisionByoipCidrRequest$CidrAuthorizationContext' => '<p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP.</p>', ], ], 'CidrBlock' => [ 'base' => '<p>Describes an IPv4 CIDR block.</p>', 'refs' => [ 'CidrBlockSet$member' => NULL, ], ], 'CidrBlockSet' => [ 'base' => NULL, 'refs' => [ 'VpcPeeringConnectionVpcInfo$CidrBlockSet' => '<p>Information about the IPv4 CIDR blocks for the VPC.</p>', ], ], 'ClassicLinkDnsSupport' => [ 'base' => '<note> <p>Deprecated.</p> </note> <p>Describes the ClassicLink DNS support status of a VPC.</p>', 'refs' => [ 'ClassicLinkDnsSupportList$member' => NULL, ], ], 'ClassicLinkDnsSupportList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportResult$Vpcs' => '<p>Information about the ClassicLink DNS support status of the VPCs.</p>', ], ], 'ClassicLinkInstance' => [ 'base' => '<note> <p>Deprecated.</p> </note> <p>Describes a linked EC2-Classic instance.</p>', 'refs' => [ 'ClassicLinkInstanceList$member' => NULL, ], ], 'ClassicLinkInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesResult$Instances' => '<p>Information about one or more linked EC2-Classic instances.</p>', ], ], 'ClassicLoadBalancer' => [ 'base' => '<p>Describes a Classic Load Balancer.</p>', 'refs' => [ 'ClassicLoadBalancers$member' => NULL, ], ], 'ClassicLoadBalancers' => [ 'base' => NULL, 'refs' => [ 'ClassicLoadBalancersConfig$ClassicLoadBalancers' => '<p>One or more Classic Load Balancers.</p>', ], ], 'ClassicLoadBalancersConfig' => [ 'base' => '<p>Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with these Classic Load Balancers.</p>', 'refs' => [ 'LoadBalancersConfig$ClassicLoadBalancersConfig' => '<p>The Classic Load Balancers.</p>', ], ], 'ClientCertificateRevocationListStatus' => [ 'base' => '<p>Describes the state of a client certificate revocation list.</p>', 'refs' => [ 'ExportClientVpnClientCertificateRevocationListResult$Status' => '<p>The current state of the client certificate revocation list.</p>', ], ], 'ClientCertificateRevocationListStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientCertificateRevocationListStatus$Code' => '<p>The state of the client certificate revocation list.</p>', ], ], 'ClientConnectOptions' => [ 'base' => '<p>The options for managing connection authorization for new client connections.</p>', 'refs' => [ 'CreateClientVpnEndpointRequest$ClientConnectOptions' => '<p>The options for managing connection authorization for new client connections.</p>', 'ModifyClientVpnEndpointRequest$ClientConnectOptions' => '<p>The options for managing connection authorization for new client connections.</p>', ], ], 'ClientConnectResponseOptions' => [ 'base' => '<p>The options for managing connection authorization for new client connections.</p>', 'refs' => [ 'ClientVpnEndpoint$ClientConnectOptions' => '<p>The options for managing connection authorization for new client connections.</p>', ], ], 'ClientData' => [ 'base' => '<p>Describes the client-specific data.</p>', 'refs' => [ 'ImportImageRequest$ClientData' => '<p>The client-specific data.</p>', 'ImportSnapshotRequest$ClientData' => '<p>The client-specific data.</p>', ], ], 'ClientLoginBannerOptions' => [ 'base' => '<p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>', 'refs' => [ 'CreateClientVpnEndpointRequest$ClientLoginBannerOptions' => '<p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>', 'ModifyClientVpnEndpointRequest$ClientLoginBannerOptions' => '<p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>', ], ], 'ClientLoginBannerResponseOptions' => [ 'base' => '<p>Current state of options for customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>', 'refs' => [ 'ClientVpnEndpoint$ClientLoginBannerOptions' => '<p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>', ], ], 'ClientSecretType' => [ 'base' => NULL, 'refs' => [ 'CreateVerifiedAccessTrustProviderOidcOptions$ClientSecret' => '<p>The client secret.</p>', 'ModifyVerifiedAccessTrustProviderOidcOptions$ClientSecret' => '<p>The client secret.</p>', 'OidcOptions$ClientSecret' => '<p>The client secret.</p>', ], ], 'ClientVpnAuthentication' => [ 'base' => '<p>Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication</a> in the <i>Client VPN Administrator Guide</i>.</p>', 'refs' => [ 'ClientVpnAuthenticationList$member' => NULL, ], ], 'ClientVpnAuthenticationList' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpoint$AuthenticationOptions' => '<p>Information about the authentication method used by the Client VPN endpoint.</p>', ], ], 'ClientVpnAuthenticationRequest' => [ 'base' => '<p>Describes the authentication method to be used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the <i>Client VPN Administrator Guide</i>.</p>', 'refs' => [ 'ClientVpnAuthenticationRequestList$member' => NULL, ], ], 'ClientVpnAuthenticationRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateClientVpnEndpointRequest$AuthenticationOptions' => '<p>Information about the authentication method to be used to authenticate clients.</p>', ], ], 'ClientVpnAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'ClientVpnAuthentication$Type' => '<p>The authentication type used.</p>', 'ClientVpnAuthenticationRequest$Type' => '<p>The type of client authentication to be used.</p>', ], ], 'ClientVpnAuthorizationRuleStatus' => [ 'base' => '<p>Describes the state of an authorization rule.</p>', 'refs' => [ 'AuthorizationRule$Status' => '<p>The current state of the authorization rule.</p>', 'AuthorizeClientVpnIngressResult$Status' => '<p>The current state of the authorization rule.</p>', 'RevokeClientVpnIngressResult$Status' => '<p>The current state of the authorization rule.</p>', ], ], 'ClientVpnAuthorizationRuleStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnAuthorizationRuleStatus$Code' => '<p>The state of the authorization rule.</p>', ], ], 'ClientVpnConnection' => [ 'base' => '<p>Describes a client connection.</p>', 'refs' => [ 'ClientVpnConnectionSet$member' => NULL, ], ], 'ClientVpnConnectionSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnConnectionsResult$Connections' => '<p>Information about the active and terminated client connections.</p>', ], ], 'ClientVpnConnectionStatus' => [ 'base' => '<p>Describes the status of a client connection.</p>', 'refs' => [ 'ClientVpnConnection$Status' => '<p>The current state of the client connection.</p>', 'TerminateConnectionStatus$PreviousStatus' => '<p>The state of the client connection.</p>', 'TerminateConnectionStatus$CurrentStatus' => '<p>A message about the status of the client connection, if applicable.</p>', ], ], 'ClientVpnConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnConnectionStatus$Code' => '<p>The state of the client connection.</p>', ], ], 'ClientVpnEndpoint' => [ 'base' => '<p>Describes a Client VPN endpoint.</p>', 'refs' => [ 'EndpointSet$member' => NULL, ], ], 'ClientVpnEndpointAttributeStatus' => [ 'base' => '<p>Describes the status of the Client VPN endpoint attribute.</p>', 'refs' => [ 'ClientConnectResponseOptions$Status' => '<p>The status of any updates to the client connect options.</p>', ], ], 'ClientVpnEndpointAttributeStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpointAttributeStatus$Code' => '<p>The status code.</p>', ], ], 'ClientVpnEndpointId' => [ 'base' => NULL, 'refs' => [ 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'AssociateClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'AuthorizeClientVpnIngressRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ClientVpnEndpointIdList$member' => NULL, 'CreateClientVpnRouteRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which to add the route.</p>', 'DeleteClientVpnEndpointRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN to be deleted.</p>', 'DeleteClientVpnRouteRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint from which the route is to be deleted.</p>', 'DescribeClientVpnAuthorizationRulesRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnConnectionsRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnRoutesRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnTargetNetworksRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DisassociateClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint from which to disassociate the target network.</p>', 'ExportClientVpnClientCertificateRevocationListRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ExportClientVpnClientConfigurationRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ImportClientVpnClientCertificateRevocationListRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which the client certificate revocation list applies.</p>', 'ModifyClientVpnEndpointRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to modify.</p>', 'RevokeClientVpnIngressRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>', 'TerminateClientVpnConnectionsRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which the client is connected.</p>', ], ], 'ClientVpnEndpointIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsRequest$ClientVpnEndpointIds' => '<p>The ID of the Client VPN endpoint.</p>', ], ], 'ClientVpnEndpointStatus' => [ 'base' => '<p>Describes the state of a Client VPN endpoint.</p>', 'refs' => [ 'ClientVpnEndpoint$Status' => '<p>The current state of the Client VPN endpoint.</p>', 'CreateClientVpnEndpointResult$Status' => '<p>The current state of the Client VPN endpoint.</p>', 'DeleteClientVpnEndpointResult$Status' => '<p>The current state of the Client VPN endpoint.</p>', ], ], 'ClientVpnEndpointStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpointStatus$Code' => '<p>The state of the Client VPN endpoint. Possible states include:</p> <ul> <li> <p> <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been associated. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>available</code> - The Client VPN endpoint has been created and a target network has been associated. The Client VPN endpoint can accept connections.</p> </li> <li> <p> <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept connections.</p> </li> </ul>', ], ], 'ClientVpnRoute' => [ 'base' => '<p>Information about a Client VPN endpoint route.</p>', 'refs' => [ 'ClientVpnRouteSet$member' => NULL, ], ], 'ClientVpnRouteSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnRoutesResult$Routes' => '<p>Information about the Client VPN endpoint routes.</p>', ], ], 'ClientVpnRouteStatus' => [ 'base' => '<p>Describes the state of a Client VPN endpoint route.</p>', 'refs' => [ 'ClientVpnRoute$Status' => '<p>The current state of the route.</p>', 'CreateClientVpnRouteResult$Status' => '<p>The current state of the route.</p>', 'DeleteClientVpnRouteResult$Status' => '<p>The current state of the route.</p>', ], ], 'ClientVpnRouteStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnRouteStatus$Code' => '<p>The state of the Client VPN endpoint route.</p>', ], ], 'ClientVpnSecurityGroupIdSet' => [ 'base' => NULL, 'refs' => [ 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$SecurityGroupIds' => '<p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>', 'ApplySecurityGroupsToClientVpnTargetNetworkResult$SecurityGroupIds' => '<p>The IDs of the applied security groups.</p>', 'ClientVpnEndpoint$SecurityGroupIds' => '<p>The IDs of the security groups for the target network.</p>', 'CreateClientVpnEndpointRequest$SecurityGroupIds' => '<p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>', 'ModifyClientVpnEndpointRequest$SecurityGroupIds' => '<p>The IDs of one or more security groups to apply to the target network.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogOptionsSpecification$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.</p>', ], ], 'CloudWatchLogOptions' => [ 'base' => '<p>Options for sending VPN tunnel logs to CloudWatch.</p>', 'refs' => [ 'VpnTunnelLogOptions$CloudWatchLogOptions' => '<p>Options for sending VPN tunnel logs to CloudWatch.</p>', ], ], 'CloudWatchLogOptionsSpecification' => [ 'base' => '<p>Options for sending VPN tunnel logs to CloudWatch.</p>', 'refs' => [ 'VpnTunnelLogOptionsSpecification$CloudWatchLogOptions' => '<p>Options for sending VPN tunnel logs to CloudWatch.</p>', ], ], 'CoipAddressUsage' => [ 'base' => '<p>Describes address usage for a customer-owned address pool.</p>', 'refs' => [ 'CoipAddressUsageSet$member' => NULL, ], ], 'CoipAddressUsageSet' => [ 'base' => NULL, 'refs' => [ 'GetCoipPoolUsageResult$CoipAddressUsages' => '<p>Information about the address usage.</p>', ], ], 'CoipCidr' => [ 'base' => '<p> Information about a customer-owned IP address range. </p>', 'refs' => [ 'CreateCoipCidrResult$CoipCidr' => '<p> Information about a range of customer-owned IP addresses. </p>', 'DeleteCoipCidrResult$CoipCidr' => '<p> Information about a range of customer-owned IP addresses. </p>', ], ], 'CoipPool' => [ 'base' => '<p>Describes a customer-owned address pool.</p>', 'refs' => [ 'CoipPoolSet$member' => NULL, 'CreateCoipPoolResult$CoipPool' => '<p>Information about the CoIP address pool.</p>', 'DeleteCoipPoolResult$CoipPool' => '<p>Information about the CoIP address pool.</p>', ], ], 'CoipPoolId' => [ 'base' => NULL, 'refs' => [ 'LocalGatewayRoute$CoipPoolId' => '<p>The ID of the customer-owned address pool.</p>', 'ModifySubnetAttributeRequest$CustomerOwnedIpv4Pool' => '<p>The customer-owned IPv4 address pool associated with the subnet.</p> <p>You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.</p>', 'Subnet$CustomerOwnedIpv4Pool' => '<p>The customer-owned IPv4 address pool associated with the subnet.</p>', ], ], 'CoipPoolIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsRequest$PoolIds' => '<p>The IDs of the address pools.</p>', ], ], 'CoipPoolMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'GetCoipPoolUsageRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'CoipPoolSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsResult$CoipPools' => '<p>Information about the address pools.</p>', ], ], 'ComponentAccount' => [ 'base' => NULL, 'refs' => [ 'Explanation$ComponentAccount' => '<p>The Amazon Web Services account for the component.</p>', ], ], 'ComponentRegion' => [ 'base' => NULL, 'refs' => [ 'Explanation$ComponentRegion' => '<p>The Region for the component.</p>', ], ], 'ConfirmProductInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConfirmProductInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ConnectionLogOptions' => [ 'base' => '<p>Describes the client connection logging options for the Client VPN endpoint.</p>', 'refs' => [ 'CreateClientVpnEndpointRequest$ConnectionLogOptions' => '<p>Information about the client connection logging options.</p> <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p> <ul> <li> <p>Client connection requests</p> </li> <li> <p>Client connection results (successful and unsuccessful)</p> </li> <li> <p>Reasons for unsuccessful client connection requests</p> </li> <li> <p>Client connection termination time</p> </li> </ul>', 'ModifyClientVpnEndpointRequest$ConnectionLogOptions' => '<p>Information about the client connection logging options.</p> <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p> <ul> <li> <p>Client connection requests</p> </li> <li> <p>Client connection results (successful and unsuccessful)</p> </li> <li> <p>Reasons for unsuccessful client connection requests</p> </li> <li> <p>Client connection termination time</p> </li> </ul>', ], ], 'ConnectionLogResponseOptions' => [ 'base' => '<p>Information about the client connection logging options for a Client VPN endpoint.</p>', 'refs' => [ 'ClientVpnEndpoint$ConnectionLogOptions' => '<p>Information about the client connection logging options for the Client VPN endpoint.</p>', ], ], 'ConnectionNotification' => [ 'base' => '<p>Describes a connection notification for a VPC endpoint or VPC endpoint service.</p>', 'refs' => [ 'ConnectionNotificationSet$member' => NULL, 'CreateVpcEndpointConnectionNotificationResult$ConnectionNotification' => '<p>Information about the notification.</p>', ], ], 'ConnectionNotificationId' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotificationIdsList$member' => NULL, 'DescribeVpcEndpointConnectionNotificationsRequest$ConnectionNotificationId' => '<p>The ID of the notification.</p>', 'ModifyVpcEndpointConnectionNotificationRequest$ConnectionNotificationId' => '<p>The ID of the notification.</p>', ], ], 'ConnectionNotificationIdsList' => [ 'base' => NULL, 'refs' => [ 'DeleteVpcEndpointConnectionNotificationsRequest$ConnectionNotificationIds' => '<p>The IDs of the notifications.</p>', ], ], 'ConnectionNotificationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointConnectionNotificationsResult$ConnectionNotificationSet' => '<p>The notifications.</p>', ], ], 'ConnectionNotificationState' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotification$ConnectionNotificationState' => '<p>The state of the notification.</p>', ], ], 'ConnectionNotificationType' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotification$ConnectionNotificationType' => '<p>The type of notification.</p>', ], ], 'ConnectionTrackingConfiguration' => [ 'base' => '<p>A security group connection tracking configuration that enables you to set the idle timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'NetworkInterface$ConnectionTrackingConfiguration' => '<p>A security group connection tracking configuration that enables you to set the timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'ConnectionTrackingSpecification' => [ 'base' => '<p>A security group connection tracking specification that enables you to set the idle timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'LaunchTemplateInstanceNetworkInterfaceSpecification$ConnectionTrackingSpecification' => '<p>A security group connection tracking specification that enables you to set the timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'ConnectionTrackingSpecificationRequest' => [ 'base' => '<p>A security group connection tracking specification request that enables you to set the idle timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'CreateNetworkInterfaceRequest$ConnectionTrackingSpecification' => '<p>A connection tracking specification for the network interface.</p>', 'InstanceNetworkInterfaceSpecification$ConnectionTrackingSpecification' => '<p>A security group connection tracking specification that enables you to set the timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$ConnectionTrackingSpecification' => '<p>A security group connection tracking specification that enables you to set the timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Idle connection tracking timeout</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ModifyNetworkInterfaceAttributeRequest$ConnectionTrackingSpecification' => '<p>A connection tracking specification.</p>', ], ], 'ConnectionTrackingSpecificationResponse' => [ 'base' => '<p>A security group connection tracking specification response that enables you to set the idle timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'InstanceNetworkInterface$ConnectionTrackingConfiguration' => '<p>A security group connection tracking configuration that enables you to set the timeout for connection tracking on an Elastic network interface. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts">Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'ConnectivityType' => [ 'base' => NULL, 'refs' => [ 'CreateNatGatewayRequest$ConnectivityType' => '<p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>', 'NatGateway$ConnectivityType' => '<p>Indicates whether the NAT gateway supports public or private connectivity.</p>', ], ], 'ContainerFormat' => [ 'base' => NULL, 'refs' => [ 'ExportToS3Task$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', 'ExportToS3TaskSpecification$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', ], ], 'ConversionIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksRequest$ConversionTaskIds' => '<p>The conversion task IDs.</p>', ], ], 'ConversionTask' => [ 'base' => '<p>Describes a conversion task.</p>', 'refs' => [ 'DescribeConversionTaskList$member' => NULL, 'ImportInstanceResult$ConversionTask' => '<p>Information about the conversion task.</p>', 'ImportVolumeResult$ConversionTask' => '<p>Information about the conversion task.</p>', ], ], 'ConversionTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelConversionRequest$ConversionTaskId' => '<p>The ID of the conversion task.</p>', 'ConversionIdStringList$member' => NULL, ], ], 'ConversionTaskState' => [ 'base' => NULL, 'refs' => [ 'ConversionTask$State' => '<p>The state of the conversion task.</p>', ], ], 'CoolOffPeriodRequestHours' => [ 'base' => NULL, 'refs' => [ 'LockSnapshotRequest$CoolOffPeriod' => '<p>The cooling-off period during which you can unlock the snapshot or modify the lock settings after locking the snapshot in compliance mode, in hours. After the cooling-off period expires, you can\'t unlock or delete the snapshot, decrease the lock duration, or change the lock mode. You can increase the lock duration after the cooling-off period expires.</p> <p>The cooling-off period is optional when locking a snapshot in compliance mode. If you are locking the snapshot in governance mode, omit this parameter.</p> <p>To lock the snapshot in compliance mode immediately without a cooling-off period, omit this parameter.</p> <p>If you are extending the lock duration for a snapshot that is locked in compliance mode after the cooling-off period has expired, omit this parameter. If you specify a cooling-period in a such a request, the request fails.</p> <p>Allowed values: Min 1, max 72.</p>', ], ], 'CoolOffPeriodResponseHours' => [ 'base' => NULL, 'refs' => [ 'LockSnapshotResult$CoolOffPeriod' => '<p>The compliance mode cooling-off period, in hours.</p>', 'LockedSnapshotsInfo$CoolOffPeriod' => '<p>The compliance mode cooling-off period, in hours.</p>', ], ], 'CopyFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyImageRequest' => [ 'base' => '<p>Contains the parameters for CopyImage.</p>', 'refs' => [], ], 'CopyImageResult' => [ 'base' => '<p>Contains the output of CopyImage.</p>', 'refs' => [], ], 'CopySnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopySnapshotRequestPSU' => [ 'base' => NULL, 'refs' => [ 'CopySnapshotRequest$PresignedUrl' => '<p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p> <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon S3 API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>', ], ], 'CopySnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyTagsFromSource' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotsRequest$CopyTagsFromSource' => '<p>Copies the tags from the specified volume to corresponding snapshot.</p>', ], ], 'CoreCount' => [ 'base' => NULL, 'refs' => [ 'CoreCountList$member' => NULL, 'VCpuInfo$DefaultCores' => '<p>The default number of cores for the instance type.</p>', ], ], 'CoreCountList' => [ 'base' => NULL, 'refs' => [ 'VCpuInfo$ValidCores' => '<p>The valid number of cores that can be configured for the instance type.</p>', ], ], 'CoreNetworkArn' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$CoreNetworkArn' => '<p>The Amazon Resource Name (ARN) of the core network.</p>', 'ReplaceRouteRequest$CoreNetworkArn' => '<p>The Amazon Resource Name (ARN) of the core network.</p>', 'Route$CoreNetworkArn' => '<p>The Amazon Resource Name (ARN) of the core network.</p>', ], ], 'CpuManufacturer' => [ 'base' => NULL, 'refs' => [ 'CpuManufacturerSet$member' => NULL, ], ], 'CpuManufacturerName' => [ 'base' => NULL, 'refs' => [ 'ProcessorInfo$Manufacturer' => '<p>The manufacturer of the processor.</p>', ], ], 'CpuManufacturerSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$CpuManufacturers' => '<p>The CPU manufacturers to include.</p> <ul> <li> <p>For instance types with Intel CPUs, specify <code>intel</code>.</p> </li> <li> <p>For instance types with AMD CPUs, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Amazon Web Services CPUs, specify <code>amazon-web-services</code>.</p> </li> </ul> <note> <p>Don\'t confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.</p> </note> <p>Default: Any manufacturer</p>', 'InstanceRequirementsRequest$CpuManufacturers' => '<p>The CPU manufacturers to include.</p> <ul> <li> <p>For instance types with Intel CPUs, specify <code>intel</code>.</p> </li> <li> <p>For instance types with AMD CPUs, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Amazon Web Services CPUs, specify <code>amazon-web-services</code>.</p> </li> </ul> <note> <p>Don\'t confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.</p> </note> <p>Default: Any manufacturer</p>', ], ], 'CpuOptions' => [ 'base' => '<p>The CPU options for the instance.</p>', 'refs' => [ 'Instance$CpuOptions' => '<p>The CPU options for the instance.</p>', ], ], 'CpuOptionsRequest' => [ 'base' => '<p>The CPU options for the instance. Both the core count and threads per core must be specified in the request.</p>', 'refs' => [ 'RunInstancesRequest$CpuOptions' => '<p>The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'CreateCapacityReservationBySplittingRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationBySplittingResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCarrierGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCarrierGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCoipPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCoipPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateCustomerGatewayResult' => [ 'base' => '<p>Contains the output of CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateDefaultSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultSubnetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDhcpOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEgressOnlyInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEgressOnlyInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetError' => [ 'base' => '<p>Describes the instances that could not be launched by the fleet.</p>', 'refs' => [ 'CreateFleetErrorsSet$member' => NULL, ], ], 'CreateFleetErrorsSet' => [ 'base' => NULL, 'refs' => [ 'CreateFleetResult$Errors' => '<p>Information about the instances that could not be launched by the fleet. Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CreateFleetInstance' => [ 'base' => '<p>Describes the instances that were launched by the fleet.</p>', 'refs' => [ 'CreateFleetInstancesSet$member' => NULL, ], ], 'CreateFleetInstancesSet' => [ 'base' => NULL, 'refs' => [ 'CreateFleetResult$Instances' => '<p>Information about the instances that were launched by the fleet. Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceConnectEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceConnectEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceEventWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceEventWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceExportTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamExternalResourceVerificationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamExternalResourceVerificationTokenResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamResourceDiscoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamResourceDiscoveryResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpamScopeResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVpcAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedPrefixListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedPrefixListResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNatGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNatGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInsightsAccessScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInsightsAccessScopeResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInsightsPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInsightsPathResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInterfacePermissionRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkInterfacePermission.</p>', 'refs' => [], ], 'CreateNetworkInterfacePermissionResult' => [ 'base' => '<p>Contains the output of CreateNetworkInterfacePermission.</p>', 'refs' => [], ], 'CreateNetworkInterfaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInterfaceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlacementGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlacementGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePublicIpv4PoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePublicIpv4PoolResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplaceRootVolumeTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplaceRootVolumeTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateRestoreImageTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRestoreImageTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateStoreImageTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStoreImageTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetCidrReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetCidrReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayConnectPeerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayConnectPeerResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayConnectRequestOptions' => [ 'base' => '<p>The options for a Connect attachment.</p>', 'refs' => [ 'CreateTransitGatewayConnectRequest$Options' => '<p>The Connect attachment options.</p>', ], ], 'CreateTransitGatewayConnectResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayMulticastDomainRequestOptions' => [ 'base' => '<p>The options for the transit gateway multicast domain.</p>', 'refs' => [ 'CreateTransitGatewayMulticastDomainRequest$Options' => '<p>The options for the transit gateway multicast domain.</p>', ], ], 'CreateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPeeringAttachmentRequestOptions' => [ 'base' => '<p>Describes whether dynamic routing is enabled or disabled for the transit gateway peering request.</p>', 'refs' => [ 'CreateTransitGatewayPeeringAttachmentRequest$Options' => '<p>Requests a transit gateway peering attachment.</p>', ], ], 'CreateTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPolicyTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPolicyTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPrefixListReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPrefixListReferenceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableAnnouncementRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableAnnouncementResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayVpcAttachmentRequestOptions' => [ 'base' => '<p>Describes the options for a VPC attachment.</p>', 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequest$Options' => '<p>The VPC attachment options.</p>', ], ], 'CreateTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessEndpointEniOptions' => [ 'base' => '<p>Describes the network interface options when creating an Amazon Web Services Verified Access endpoint using the <code>network-interface</code> type.</p>', 'refs' => [ 'CreateVerifiedAccessEndpointRequest$NetworkInterfaceOptions' => '<p>The network interface details. This parameter is required if the endpoint type is <code>network-interface</code>.</p>', ], ], 'CreateVerifiedAccessEndpointLoadBalancerOptions' => [ 'base' => '<p>Describes the load balancer options when creating an Amazon Web Services Verified Access endpoint using the <code>load-balancer</code> type.</p>', 'refs' => [ 'CreateVerifiedAccessEndpointRequest$LoadBalancerOptions' => '<p>The load balancer details. This parameter is required if the endpoint type is <code>load-balancer</code>.</p>', ], ], 'CreateVerifiedAccessEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessEndpointSubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateVerifiedAccessEndpointLoadBalancerOptions$SubnetIds' => '<p>The IDs of the subnets.</p>', ], ], 'CreateVerifiedAccessGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessTrustProviderDeviceOptions' => [ 'base' => '<p>Describes the options when creating an Amazon Web Services Verified Access trust provider using the <code>device</code> type.</p>', 'refs' => [ 'CreateVerifiedAccessTrustProviderRequest$DeviceOptions' => '<p>The options for a device-based trust provider. This parameter is required when the provider type is <code>device</code>.</p>', ], ], 'CreateVerifiedAccessTrustProviderOidcOptions' => [ 'base' => '<p>Describes the options when creating an Amazon Web Services Verified Access trust provider using the <code>user</code> type.</p>', 'refs' => [ 'CreateVerifiedAccessTrustProviderRequest$OidcOptions' => '<p>The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required when the provider type is <code>user</code>.</p>', ], ], 'CreateVerifiedAccessTrustProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVerifiedAccessTrustProviderResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVolumePermission' => [ 'base' => '<p>Describes the user or group to be added or removed from the list of create volume permissions for a volume.</p>', 'refs' => [ 'CreateVolumePermissionList$member' => NULL, ], ], 'CreateVolumePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateVolumePermissionModifications$Add' => '<p>Adds the specified Amazon Web Services account ID or group to the list.</p>', 'CreateVolumePermissionModifications$Remove' => '<p>Removes the specified Amazon Web Services account ID or group from the list.</p>', 'DescribeSnapshotAttributeResult$CreateVolumePermissions' => '<p>The users and groups that have the permissions for creating volumes from the snapshot.</p>', ], ], 'CreateVolumePermissionModifications' => [ 'base' => '<p>Describes modifications to the list of create volume permissions for a volume.</p>', 'refs' => [ 'ModifySnapshotAttributeRequest$CreateVolumePermission' => '<p>A JSON representation of the snapshot attribute modification.</p>', ], ], 'CreateVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointConnectionNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointConnectionNotificationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointServiceConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointServiceConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionResult' => [ 'base' => '<p>Contains the output of CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnectionRoute.</p>', 'refs' => [], ], 'CreateVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnGateway.</p>', 'refs' => [], ], 'CreateVpnGatewayResult' => [ 'base' => '<p>Contains the output of CreateVpnGateway.</p>', 'refs' => [], ], 'CreditSpecification' => [ 'base' => '<p>Describes the credit option for CPU usage of a T instance.</p>', 'refs' => [ 'ResponseLaunchTemplateData$CreditSpecification' => '<p>The credit option for CPU usage of the instance.</p>', ], ], 'CreditSpecificationRequest' => [ 'base' => '<p>The credit option for CPU usage of a T instance.</p>', 'refs' => [ 'RequestLaunchTemplateData$CreditSpecification' => '<p>The credit option for CPU usage of the instance. Valid only for T instances.</p>', 'RunInstancesRequest$CreditSpecification' => '<p>The credit option for CPU usage of the burstable performance instance. Valid values are <code>standard</code> and <code>unlimited</code>. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html"> ModifyInstanceCreditSpecification</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p> <p>Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a/T4g instances)</p> <p>For T3 instances with <code>host</code> tenancy, only <code>standard</code> is supported.</p>', ], ], 'CurrencyCodeValues' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'HostOffering$CurrencyCode' => '<p>The currency of the offering.</p>', 'HostReservation$CurrencyCode' => '<p>The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceSchedule$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceScheduleSpecification$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'Purchase$CurrencyCode' => '<p>The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationRequest$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstanceLimitPrice$CurrencyCode' => '<p>The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstances$CurrencyCode' => '<p>The currency of the Reserved Instance. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstancesOffering$CurrencyCode' => '<p>The currency of the Reserved Instance offering you are purchasing. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', ], ], 'CurrentGenerationFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$CurrentGeneration' => '<p>Indicates whether the instance type is current generation.</p>', ], ], 'CustomerGateway' => [ 'base' => '<p>Describes a customer gateway.</p>', 'refs' => [ 'CreateCustomerGatewayResult$CustomerGateway' => '<p>Information about the customer gateway.</p>', 'CustomerGatewayList$member' => NULL, ], ], 'CustomerGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateVpnConnectionRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'CustomerGatewayIdStringList$member' => NULL, 'DeleteCustomerGatewayRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'GetVpnTunnelReplacementStatusResult$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'ModifyVpnConnectionRequest$CustomerGatewayId' => '<p>The ID of the customer gateway at your end of the VPN connection.</p>', ], ], 'CustomerGatewayIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysRequest$CustomerGatewayIds' => '<p>One or more customer gateway IDs.</p> <p>Default: Describes all your customer gateways.</p>', ], ], 'CustomerGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysResult$CustomerGateways' => '<p>Information about one or more customer gateways.</p>', ], ], 'DITMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DITOMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypeOfferingsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DataQueries' => [ 'base' => NULL, 'refs' => [ 'GetAwsNetworkPerformanceDataRequest$DataQueries' => '<p>A list of network performance data queries.</p>', ], ], 'DataQuery' => [ 'base' => '<p>A query used for retrieving network health data. </p>', 'refs' => [ 'DataQueries$member' => NULL, ], ], 'DataResponse' => [ 'base' => '<p>The response to a <code>DataQuery</code>.</p>', 'refs' => [ 'DataResponses$member' => NULL, ], ], 'DataResponses' => [ 'base' => NULL, 'refs' => [ 'GetAwsNetworkPerformanceDataResult$DataResponses' => '<p>The list of data responses.</p>', ], ], 'DatafeedSubscriptionState' => [ 'base' => NULL, 'refs' => [ 'SpotDatafeedSubscription$State' => '<p>The state of the Spot Instance data feed subscription.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'BundleTask$StartTime' => '<p>The time this task started.</p>', 'BundleTask$UpdateTime' => '<p>The time of the most recent update for the task.</p>', 'CapacityReservation$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p>', 'CapacityReservation$CreateDate' => '<p>The date and time at which the Capacity Reservation was created.</p>', 'ClientData$UploadEnd' => '<p>The time that the disk upload ends.</p>', 'ClientData$UploadStart' => '<p>The time that the disk upload starts.</p>', 'CreateCapacityReservationRequest$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p> <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p> <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>', 'CreateFleetRequest$ValidFrom' => '<p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>', 'CreateFleetRequest$ValidUntil' => '<p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>', 'DescribeFleetHistoryRequest$StartTime' => '<p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeFleetHistoryResult$LastEvaluatedTime' => '<p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more items, this value is not present.</p>', 'DescribeFleetHistoryResult$StartTime' => '<p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryRequest$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryResponse$LastEvaluatedTime' => '<p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more items, this value is not present.</p>', 'DescribeSpotFleetRequestHistoryResponse$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotPriceHistoryRequest$EndTime' => '<p>The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotPriceHistoryRequest$StartTime' => '<p>The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'EbsInstanceBlockDevice$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'ElasticInferenceAcceleratorAssociation$ElasticInferenceAcceleratorAssociationTime' => '<p> The time at which the elastic inference accelerator is associated with an instance. </p>', 'FleetData$CreateTime' => '<p>The creation date and time of the EC2 Fleet.</p>', 'FleetData$ValidFrom' => '<p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately. </p>', 'FleetData$ValidUntil' => '<p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance requests are placed or able to fulfill the request. The default end date is 7 days from the current date. </p>', 'FpgaImage$CreateTime' => '<p>The date and time the AFI was created.</p>', 'FpgaImage$UpdateTime' => '<p>The time of the most recent update to the AFI.</p>', 'GetConsoleOutputResult$Timestamp' => '<p>The time at which the output was last updated.</p>', 'GetPasswordDataResult$Timestamp' => '<p>The time the data was last updated.</p>', 'GetReservedInstancesExchangeQuoteResult$OutputReservedInstancesWillExpireAt' => '<p>The new end date of the reservation term.</p>', 'HistoryRecord$Timestamp' => '<p>The date and time of the event, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'HistoryRecordEntry$Timestamp' => '<p>The date and time of the event, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'Host$AllocationTime' => '<p>The time that the Dedicated Host was allocated.</p>', 'Host$ReleaseTime' => '<p>The time that the Dedicated Host was released.</p>', 'HostReservation$End' => '<p>The date and time that the reservation ends.</p>', 'HostReservation$Start' => '<p>The date and time that the reservation started.</p>', 'IamInstanceProfileAssociation$Timestamp' => '<p>The time the IAM instance profile was associated with the instance.</p>', 'IdFormat$Deadline' => '<p>The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet available for this resource type, this field is not returned.</p>', 'Instance$LaunchTime' => '<p>The time the instance was launched.</p>', 'InstanceNetworkInterfaceAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'InstanceStatusDetails$ImpairedSince' => '<p>The time when a status check failed. For an instance that was launched and impaired, this is the time when the instance was launched.</p>', 'InstanceStatusEvent$NotAfter' => '<p>The latest scheduled end time for the event.</p>', 'InstanceStatusEvent$NotBefore' => '<p>The earliest scheduled start time for the event.</p>', 'InstanceStatusEvent$NotBeforeDeadline' => '<p>The deadline for starting the event.</p>', 'LaunchTemplate$CreateTime' => '<p>The time launch template was created.</p>', 'LaunchTemplateSpotMarketOptions$ValidUntil' => '<p>The end date of the request. For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date and time is reached.</p>', 'LaunchTemplateSpotMarketOptionsRequest$ValidUntil' => '<p>The end date of the request, in UTC format (<i>YYYY-MM-DD</i>T<i>HH:MM:SS</i>Z). Supported only for persistent requests.</p> <ul> <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li> <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li> </ul> <p>Default: 7 days from the current date</p>', 'LaunchTemplateVersion$CreateTime' => '<p>The time the version was created.</p>', 'ModifyCapacityReservationRequest$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p> <p>The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p> <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>', 'ModifyInstanceEventStartTimeRequest$NotBefore' => '<p>The new date and time when the event will take place.</p>', 'NatGateway$CreateTime' => '<p>The date and time the NAT gateway was created.</p>', 'NatGateway$DeleteTime' => '<p>The date and time the NAT gateway was deleted, if applicable.</p>', 'NetworkInterfaceAttachment$AttachTime' => '<p>The timestamp indicating when the attachment initiated.</p>', 'ProvisionedBandwidth$ProvisionTime' => '<p>Reserved.</p>', 'ProvisionedBandwidth$RequestTime' => '<p>Reserved.</p>', 'PurchaseReservedInstancesOfferingRequest$PurchaseTime' => '<p>The time at which to purchase the Reserved Instance, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'ReportInstanceStatusRequest$EndTime' => '<p>The time at which the reported instance health state ended.</p>', 'ReportInstanceStatusRequest$StartTime' => '<p>The time at which the reported instance health state began.</p>', 'RequestSpotInstancesRequest$ValidFrom' => '<p>The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled.</p> <p>The specified start date and time cannot be equal to the current date and time. You must specify a start date and time that occurs after the current date and time.</p>', 'RequestSpotInstancesRequest$ValidUntil' => '<p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p> <ul> <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li> <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>ValidUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li> </ul>', 'ReservedInstances$End' => '<p>The time when the Reserved Instance expires.</p>', 'ReservedInstances$Start' => '<p>The date and time the Reserved Instance started.</p>', 'ReservedInstancesListing$CreateDate' => '<p>The time the listing was created.</p>', 'ReservedInstancesListing$UpdateDate' => '<p>The last modified timestamp of the listing.</p>', 'ReservedInstancesModification$CreateDate' => '<p>The time when the modification request was created.</p>', 'ReservedInstancesModification$EffectiveDate' => '<p>The time for the modification to become effective.</p>', 'ReservedInstancesModification$UpdateDate' => '<p>The time when the modification request was last updated.</p>', 'ScheduledInstance$CreateDate' => '<p>The date when the Scheduled Instance was purchased.</p>', 'ScheduledInstance$NextSlotStartTime' => '<p>The time for the next schedule to start.</p>', 'ScheduledInstance$PreviousSlotEndTime' => '<p>The time that the previous schedule ended or will end.</p>', 'ScheduledInstance$TermEndDate' => '<p>The end date for the Scheduled Instance.</p>', 'ScheduledInstance$TermStartDate' => '<p>The start date for the Scheduled Instance.</p>', 'ScheduledInstanceAvailability$FirstSlotStartTime' => '<p>The time period for the first schedule to start.</p>', 'SlotDateTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotDateTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal to the earliest date and at most three months in the future.</p>', 'SlotStartTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotStartTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start.</p>', 'Snapshot$StartTime' => '<p>The time stamp when the snapshot was initiated.</p>', 'SpotFleetRequestConfigData$ValidFrom' => '<p>The start date and time of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts fulfilling the request immediately.</p>', 'SpotFleetRequestConfigData$ValidUntil' => '<p>The end date and time of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you cancel it.</p>', 'SpotInstanceRequest$CreateTime' => '<p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotInstanceRequest$ValidFrom' => '<p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>', 'SpotInstanceRequest$ValidUntil' => '<p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p> <ul> <li> <p>For a persistent request, the request remains active until the <code>validUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li> <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li> </ul>', 'SpotInstanceStatus$UpdateTime' => '<p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotMarketOptions$ValidUntil' => '<p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent requests.</p> <ul> <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li> <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li> </ul>', 'SpotPrice$Timestamp' => '<p>The date and time the request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'TransitGateway$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayAttachment$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayConnect$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayConnectPeer$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayMulticastDomain$CreationTime' => '<p>The time the transit gateway multicast domain was created.</p>', 'TransitGatewayPeeringAttachment$CreationTime' => '<p>The time the transit gateway peering attachment was created.</p>', 'TransitGatewayPolicyTable$CreationTime' => '<p>The timestamp when the transit gateway policy table was created.</p>', 'TransitGatewayRouteTable$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayRouteTableAnnouncement$CreationTime' => '<p>The timestamp when the transit gateway route table announcement was created.</p>', 'TransitGatewayVpcAttachment$CreationTime' => '<p>The creation time.</p>', 'VgwTelemetry$LastStatusChange' => '<p>The date and time of the last change in status. This field is updated when changes in IKE (Phase 1), IPSec (Phase 2), or BGP status are detected.</p>', 'Volume$CreateTime' => '<p>The time stamp when volume creation was initiated.</p>', 'VolumeAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'VolumeModification$StartTime' => '<p>The modification start time.</p>', 'VolumeModification$EndTime' => '<p>The modification completion or failure time.</p>', 'VpcPeeringConnection$ExpirationTime' => '<p>The time that an unaccepted VPC peering connection will expire.</p>', ], ], 'DedicatedHostFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$DedicatedHostsSupported' => '<p>Indicates whether Dedicated Hosts are supported on the instance type.</p>', ], ], 'DedicatedHostId' => [ 'base' => NULL, 'refs' => [ 'DedicatedHostIdList$member' => NULL, 'LaunchTemplatePlacementRequest$HostId' => '<p>The ID of the Dedicated Host for the instance.</p>', 'MacHost$HostId' => '<p> The EC2 Mac Dedicated Host ID. </p>', 'ModifyInstancePlacementRequest$HostId' => '<p>The ID of the Dedicated Host with which to associate the instance.</p>', 'RequestHostIdList$member' => NULL, 'RequestHostIdSet$member' => NULL, ], ], 'DedicatedHostIdList' => [ 'base' => NULL, 'refs' => [ 'InstanceEventWindowAssociationRequest$DedicatedHostIds' => '<p>The IDs of the Dedicated Hosts to associate with the event window.</p>', 'InstanceEventWindowAssociationTarget$DedicatedHostIds' => '<p>The IDs of the Dedicated Hosts associated with the event window.</p>', 'InstanceEventWindowDisassociationRequest$DedicatedHostIds' => '<p>The IDs of the Dedicated Hosts to disassociate from the event window.</p>', ], ], 'DefaultInstanceMetadataEndpointState' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceMetadataDefaultsRequest$HttpEndpoint' => '<p>Enables or disables the IMDS endpoint on an instance. When disabled, the instance metadata can\'t be accessed.</p>', ], ], 'DefaultInstanceMetadataTagsState' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceMetadataDefaultsRequest$InstanceMetadataTags' => '<p>Enables or disables access to an instance\'s tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'DefaultNetworkCardIndex' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$DefaultNetworkCardIndex' => '<p>The index of the default network card, starting at 0.</p>', ], ], 'DefaultRouteTableAssociationValue' => [ 'base' => NULL, 'refs' => [ 'ModifyTransitGatewayOptions$DefaultRouteTableAssociation' => '<p>Enable or disable automatic association with the default association route table.</p>', 'TransitGatewayOptions$DefaultRouteTableAssociation' => '<p>Indicates whether resource attachments are automatically associated with the default association route table.</p>', 'TransitGatewayRequestOptions$DefaultRouteTableAssociation' => '<p>Enable or disable automatic association with the default association route table. Enabled by default.</p>', ], ], 'DefaultRouteTablePropagationValue' => [ 'base' => NULL, 'refs' => [ 'ModifyTransitGatewayOptions$DefaultRouteTablePropagation' => '<p>Enable or disable automatic propagation of routes to the default propagation route table.</p>', 'TransitGatewayOptions$DefaultRouteTablePropagation' => '<p>Indicates whether resource attachments automatically propagate routes to the default propagation route table.</p>', 'TransitGatewayRequestOptions$DefaultRouteTablePropagation' => '<p>Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.</p>', ], ], 'DefaultTargetCapacityType' => [ 'base' => NULL, 'refs' => [ 'TargetCapacitySpecification$DefaultTargetCapacityType' => '<p>The default target capacity type.</p>', 'TargetCapacitySpecificationRequest$DefaultTargetCapacityType' => '<p>The default target capacity type.</p>', ], ], 'DefaultingDhcpOptionsId' => [ 'base' => NULL, 'refs' => [ 'AssociateDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>', ], ], 'DeleteCarrierGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCarrierGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCoipPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCoipPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteCustomerGateway.</p>', 'refs' => [], ], 'DeleteDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEgressOnlyInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEgressOnlyInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetError' => [ 'base' => '<p>Describes an EC2 Fleet error.</p>', 'refs' => [ 'DeleteFleetErrorItem$Error' => '<p>The error.</p>', ], ], 'DeleteFleetErrorCode' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetError$Code' => '<p>The error code.</p>', ], ], 'DeleteFleetErrorItem' => [ 'base' => '<p>Describes an EC2 Fleet that was not successfully deleted.</p>', 'refs' => [ 'DeleteFleetErrorSet$member' => NULL, ], ], 'DeleteFleetErrorSet' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetsResult$UnsuccessfulFleetDeletions' => '<p>Information about the EC2 Fleets that are not successfully deleted.</p>', ], ], 'DeleteFleetSuccessItem' => [ 'base' => '<p>Describes an EC2 Fleet that was successfully deleted.</p>', 'refs' => [ 'DeleteFleetSuccessSet$member' => NULL, ], ], 'DeleteFleetSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetsResult$SuccessfulFleetDeletions' => '<p>Information about the EC2 Fleets that are successfully deleted.</p>', ], ], 'DeleteFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceConnectEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceConnectEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceEventWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceEventWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamExternalResourceVerificationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamExternalResourceVerificationTokenResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamResourceDiscoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamResourceDiscoveryResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpamScopeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateVersionsResponseErrorItem' => [ 'base' => '<p>Describes a launch template version that could not be deleted.</p>', 'refs' => [ 'DeleteLaunchTemplateVersionsResponseErrorSet$member' => NULL, ], ], 'DeleteLaunchTemplateVersionsResponseErrorSet' => [ 'base' => NULL, 'refs' => [ 'DeleteLaunchTemplateVersionsResult$UnsuccessfullyDeletedLaunchTemplateVersions' => '<p>Information about the launch template versions that could not be deleted.</p>', ], ], 'DeleteLaunchTemplateVersionsResponseSuccessItem' => [ 'base' => '<p>Describes a launch template version that was successfully deleted.</p>', 'refs' => [ 'DeleteLaunchTemplateVersionsResponseSuccessSet$member' => NULL, ], ], 'DeleteLaunchTemplateVersionsResponseSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DeleteLaunchTemplateVersionsResult$SuccessfullyDeletedLaunchTemplateVersions' => '<p>Information about the launch template versions that were successfully deleted.</p>', ], ], 'DeleteLaunchTemplateVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVpcAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedPrefixListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedPrefixListResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNatGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNatGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAclEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAccessScopeAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAccessScopeAnalysisResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAccessScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAccessScopeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsAnalysisResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInsightsPathResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInterfacePermissionRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkInterfacePermission.</p>', 'refs' => [], ], 'DeleteNetworkInterfacePermissionResult' => [ 'base' => '<p>Contains the output for DeleteNetworkInterfacePermission.</p>', 'refs' => [], ], 'DeleteNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkInterface.</p>', 'refs' => [], ], 'DeletePlacementGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicIpv4PoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicIpv4PoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedReservedInstancesError' => [ 'base' => '<p>Describes the error for a Reserved Instance whose queued purchase could not be deleted.</p>', 'refs' => [ 'FailedQueuedPurchaseDeletion$Error' => '<p>The error.</p>', ], ], 'DeleteQueuedReservedInstancesErrorCode' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesError$Code' => '<p>The error code.</p>', ], ], 'DeleteQueuedReservedInstancesIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesRequest$ReservedInstancesIds' => '<p>The IDs of the Reserved Instances.</p>', ], ], 'DeleteQueuedReservedInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedReservedInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DeleteSubnetCidrReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubnetCidrReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayConnectPeerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayConnectPeerResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayConnectResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPolicyTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPolicyTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPrefixListReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPrefixListReferenceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableAnnouncementRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableAnnouncementResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessTrustProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVerifiedAccessTrustProviderResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointConnectionNotificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointConnectionNotificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointServiceConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointServiceConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnection.</p>', 'refs' => [], ], 'DeleteVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnectionRoute.</p>', 'refs' => [], ], 'DeleteVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnGateway.</p>', 'refs' => [], ], 'DeprovisionByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionByoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionIpamByoasnRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionIpamByoasnResult' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionIpamPoolCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionIpamPoolCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionPublicIpv4PoolCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionPublicIpv4PoolCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionedAddressSet' => [ 'base' => NULL, 'refs' => [ 'DeprovisionPublicIpv4PoolCidrResult$DeprovisionedAddresses' => '<p>The deprovisioned CIDRs.</p>', ], ], 'DeregisterImageRequest' => [ 'base' => '<p>Contains the parameters for DeregisterImage.</p>', 'refs' => [], ], 'DeregisterInstanceEventNotificationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterInstanceEventNotificationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterInstanceTagAttributeRequest' => [ 'base' => '<p>Information about the tag keys to deregister for the current Region. You can either specify individual tag keys or deregister all tag keys in the current Region. You must specify either <code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>', 'refs' => [ 'DeregisterInstanceEventNotificationAttributesRequest$InstanceTagAttribute' => '<p>Information about the tag keys to deregister.</p>', ], ], 'DeregisterTransitGatewayMulticastGroupMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupMembersResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupSourcesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressTransfersMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressTransfersRequest$MaxResults' => '<p>The maximum number of address transfers to return in one page of results.</p>', ], ], 'DescribeAddressTransfersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressTransfersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailabilityZonesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailabilityZonesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAwsNetworkPerformanceMetricSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAwsNetworkPerformanceMetricSubscriptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeByoipCidrsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeByoipCidrsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeByoipCidrsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeByoipCidrsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityBlockOfferingsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityBlockOfferingsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeCapacityBlockOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityBlockOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationFleetsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationFleetsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeCapacityReservationFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeCapacityReservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCarrierGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCarrierGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClassicLinkInstancesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>', ], ], 'DescribeClassicLinkInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClassicLinkInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnAuthorizationRulesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnAuthorizationRulesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnAuthorizationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnAuthorizationRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnConnectionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnConnectionsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnEndpointMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnRoutesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnRoutesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnTargetNetworksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnTargetNetworksRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnTargetNetworksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnTargetNetworksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCoipPoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCoipPoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConversionTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksResult$ConversionTasks' => '<p>Information about the conversion tasks.</p>', ], ], 'DescribeConversionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConversionTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomerGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeCustomerGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeDhcpOptionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDhcpOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEgressOnlyInternetGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeEgressOnlyInternetGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEgressOnlyInternetGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticGpusMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.</p>', ], ], 'DescribeElasticGpusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticGpusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportImageTasksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'DescribeExportImageTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportImageTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastLaunchImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastLaunchImagesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFastLaunchImagesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeFastLaunchImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastLaunchImagesSuccessItem' => [ 'base' => '<p>Describe details about a Windows image with Windows fast launch enabled that meets the requested criteria. Criteria are defined by the <code>DescribeFastLaunchImages</code> action filters.</p>', 'refs' => [ 'DescribeFastLaunchImagesSuccessSet$member' => NULL, ], ], 'DescribeFastLaunchImagesSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFastLaunchImagesResult$FastLaunchImages' => '<p>A collection of details about the fast-launch enabled Windows images that meet the requested criteria.</p>', ], ], 'DescribeFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores for a snapshot.</p>', 'refs' => [ 'DescribeFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'DescribeFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoresResult$FastSnapshotRestores' => '<p>Information about the state of fast snapshot restores.</p>', ], ], 'DescribeFastSnapshotRestoresMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoresRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetError' => [ 'base' => '<p>Describes the instances that could not be launched by the fleet.</p>', 'refs' => [ 'DescribeFleetsErrorSet$member' => NULL, ], ], 'DescribeFleetHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetHistoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsErrorSet' => [ 'base' => NULL, 'refs' => [ 'FleetData$Errors' => '<p>Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'DescribeFleetsInstances' => [ 'base' => '<p>Describes the instances that were launched by the fleet.</p>', 'refs' => [ 'DescribeFleetsInstancesSet$member' => NULL, ], ], 'DescribeFleetsInstancesSet' => [ 'base' => NULL, 'refs' => [ 'FleetData$Instances' => '<p>Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'DescribeFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImageAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImageAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImagesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImagesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'DescribeFpgaImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'DescribeHostReservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIamInstanceProfileAssociationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeIamInstanceProfileAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeIamInstanceProfileAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIamInstanceProfileAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeImageAttribute.</p>', 'refs' => [], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportImageTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportImageTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportSnapshotTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportSnapshotTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceConnectEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceConnectEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceCreditSpecificationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceCreditSpecificationsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>You cannot specify this parameter and the instance IDs parameter in the same call.</p>', ], ], 'DescribeInstanceCreditSpecificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceCreditSpecificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceEventNotificationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceEventNotificationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceEventWindowsRequest' => [ 'base' => '<para>Describe instance event windows by InstanceEventWindow.</para>', 'refs' => [], ], 'DescribeInstanceEventWindowsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTopologyGroupNameSet' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTopologyRequest$GroupNames' => '<p>The name of the placement group that each instance is in.</p> <p>Constraints: Maximum 100 explicitly specified placement group names.</p>', ], ], 'DescribeInstanceTopologyInstanceIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTopologyRequest$InstanceIds' => '<p>The instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 100 explicitly specified instance IDs.</p>', ], ], 'DescribeInstanceTopologyMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTopologyRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>You can\'t specify this parameter and the instance IDs parameter in the same request.</p> <p>Default: <code>20</code> </p>', ], ], 'DescribeInstanceTopologyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTopologyResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypeOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypeOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInternetGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInternetGatewaysRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeInternetGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInternetGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamByoasnMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeIpamByoasnRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeIpamByoasnRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamByoasnResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamExternalResourceVerificationTokensRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamExternalResourceVerificationTokensResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamPoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamPoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamResourceDiscoveriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamResourceDiscoveriesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamResourceDiscoveryAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamResourceDiscoveryAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamScopesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamScopesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpamsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpv6PoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpv6PoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPairsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPairsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplateVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplatesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.</p>', ], ], 'DescribeLaunchTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplatesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVpcAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVpcAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfaceGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfaceGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfacesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLockedSnapshotsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeLockedSnapshotsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeLockedSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLockedSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMacHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMacHostsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMacHostsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'DescribeMacHostsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedPrefixListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedPrefixListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMovingAddressesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMovingAddressesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error is returned.</p> <p>Default: If no value is provided, the default is 1000.</p>', ], ], 'DescribeMovingAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMovingAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNatGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNatGatewaysRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeNatGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNatGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkAclsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkAclsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeNetworkAclsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkAclsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAccessScopeAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAccessScopeAnalysesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAccessScopesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAccessScopesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsAnalysesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsPathsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInsightsPathsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfaceAttributeResult' => [ 'base' => '<p>Contains the output of DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfacePermissionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacePermissionsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. If this parameter is not specified, up to 50 results are returned by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeNetworkInterfacePermissionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfacePermissions.</p>', 'refs' => [], ], 'DescribeNetworkInterfacePermissionsResult' => [ 'base' => '<p>Contains the output for DescribeNetworkInterfacePermissions.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. You cannot specify this parameter and the network interface IDs parameter in the same request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeNetworkInterfacesRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaces.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePlacementGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePlacementGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrefixListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrefixListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalIdFormatMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalIdFormatRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. </p>', ], ], 'DescribePrincipalIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublicIpv4PoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublicIpv4PoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplaceRootVolumeTasksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeReplaceRootVolumeTasksRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeReplaceRootVolumeTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplaceRootVolumeTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedInstancesListingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesListingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeReservedInstancesResult' => [ 'base' => '<p>Contains the output for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeRouteTablesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeRouteTablesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRouteTablesResult' => [ 'base' => '<p>Contains the output of DescribeRouteTables.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'DescribeScheduledInstanceAvailabilityRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeScheduledInstancesResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeSecurityGroupReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupReferencesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupRulesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupRulesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. This value can be between 5 and 1000. If this parameter is not specified, then all items are returned. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSecurityGroupRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. This value can be between 5 and 1000. If this parameter is not specified, then all items are returned. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSecurityGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotTierStatusMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotTierStatusRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSnapshotTierStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotTierStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetInstancesRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSpotFleetInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSpotFleetRequestHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryResult' => [ 'base' => '<p>Contains the output of DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeStaleSecurityGroupsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeStaleSecurityGroupsNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$NextToken' => '<p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>', ], ], 'DescribeStaleSecurityGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStaleSecurityGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStoreImageTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStoreImageTasksRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStoreImageTasksRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p> <p>You cannot specify this parameter and the <code>ImageIds</code> parameter in the same call.</p>', ], ], 'DescribeStoreImageTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSubnetsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeSubnetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFilterRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFilterRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFiltersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorSessionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayConnectPeersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayConnectPeersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayConnectsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayMulticastDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayMulticastDomainsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPeeringAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPeeringAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPolicyTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPolicyTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTableAnnouncementsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTableAnnouncementsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayVpcAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayVpcAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrunkInterfaceAssociationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeTrunkInterfaceAssociationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeTrunkInterfaceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrunkInterfaceAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessEndpointsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedAccessEndpointsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVerifiedAccessEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessGroupMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedAccessGroupsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVerifiedAccessGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedAccessInstanceLoggingConfigurationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVerifiedAccessInstanceLoggingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessInstanceLoggingConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessInstancesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedAccessInstancesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVerifiedAccessInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessTrustProvidersMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVerifiedAccessTrustProvidersRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVerifiedAccessTrustProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVerifiedAccessTrustProvidersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesModificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesModificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeVpcClassicLinkDnsSupportNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportRequest$NextToken' => '<p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>', 'DescribeVpcClassicLinkDnsSupportResult$NextToken' => '<p>The token to include in another request to get the next page of items. This value is <code>null</code> when there are no more items to return.</p>', ], ], 'DescribeVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionNotificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionNotificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServiceConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServiceConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringConnectionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcPeeringConnectionsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeVpcPeeringConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcsRequest$MaxResults' => '<p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>', ], ], 'DescribeVpcsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpnConnectionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnConnectionsResult' => [ 'base' => '<p>Contains the output of DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnGateways.</p>', 'refs' => [], ], 'DescribeVpnGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeVpnGateways.</p>', 'refs' => [], ], 'DestinationFileFormat' => [ 'base' => NULL, 'refs' => [ 'DestinationOptionsRequest$FileFormat' => '<p>The format for the flow log. The default is <code>plain-text</code>.</p>', 'DestinationOptionsResponse$FileFormat' => '<p>The format for the flow log.</p>', ], ], 'DestinationOptionsRequest' => [ 'base' => '<p>Describes the destination options for a flow log.</p>', 'refs' => [ 'CreateFlowLogsRequest$DestinationOptions' => '<p>The destination options.</p>', ], ], 'DestinationOptionsResponse' => [ 'base' => '<p>Describes the destination options for a flow log.</p>', 'refs' => [ 'FlowLog$DestinationOptions' => '<p>The destination options.</p>', ], ], 'DetachClassicLinkVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachClassicLinkVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'DetachInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DetachNetworkInterface.</p>', 'refs' => [], ], 'DetachVerifiedAccessTrustProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachVerifiedAccessTrustProviderResult' => [ 'base' => NULL, 'refs' => [], ], 'DetachVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DetachVpnGateway.</p>', 'refs' => [], ], 'DeviceOptions' => [ 'base' => '<p>Describes the options for an Amazon Web Services Verified Access device-identity based trust provider.</p>', 'refs' => [ 'VerifiedAccessTrustProvider$DeviceOptions' => '<p>The options for device-identity trust provider.</p>', ], ], 'DeviceTrustProviderType' => [ 'base' => NULL, 'refs' => [ 'CreateVerifiedAccessTrustProviderRequest$DeviceTrustProviderType' => '<p>The type of device-based trust provider. This parameter is required when the provider type is <code>device</code>.</p>', 'VerifiedAccessTrustProvider$DeviceTrustProviderType' => '<p>The type of device-based trust provider.</p>', 'VerifiedAccessTrustProviderCondensed$DeviceTrustProviderType' => '<p>The type of device-based trust provider.</p>', ], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'Image$RootDeviceType' => '<p>The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.</p>', 'Instance$RootDeviceType' => '<p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>', ], ], 'DhcpConfiguration' => [ 'base' => '<p>Describes a DHCP configuration option.</p>', 'refs' => [ 'DhcpConfigurationList$member' => NULL, ], ], 'DhcpConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DhcpOptions$DhcpConfigurations' => '<p>The DHCP options in the set.</p>', ], ], 'DhcpConfigurationValueList' => [ 'base' => NULL, 'refs' => [ 'DhcpConfiguration$Values' => '<p>The values for the DHCP option.</p>', ], ], 'DhcpOptions' => [ 'base' => '<p>The set of DHCP options.</p>', 'refs' => [ 'CreateDhcpOptionsResult$DhcpOptions' => '<p>A set of DHCP options.</p>', 'DhcpOptionsList$member' => NULL, ], ], 'DhcpOptionsId' => [ 'base' => NULL, 'refs' => [ 'DeleteDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set.</p>', 'DhcpOptionsIdStringList$member' => NULL, ], ], 'DhcpOptionsIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsRequest$DhcpOptionsIds' => '<p>The IDs of DHCP option sets.</p>', ], ], 'DhcpOptionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsResult$DhcpOptions' => '<p>Information about the DHCP options sets.</p>', ], ], 'DirectoryServiceAuthentication' => [ 'base' => '<p>Describes an Active Directory.</p>', 'refs' => [ 'ClientVpnAuthentication$ActiveDirectory' => '<p>Information about the Active Directory, if applicable.</p>', ], ], 'DirectoryServiceAuthenticationRequest' => [ 'base' => '<p>Describes the Active Directory to be used for client authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$ActiveDirectory' => '<p>Information about the Active Directory to be used, if applicable. You must provide this information if <b>Type</b> is <code>directory-service-authentication</code>.</p>', ], ], 'DisableAddressTransferRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableAddressTransferResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableAwsNetworkPerformanceMetricSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableAwsNetworkPerformanceMetricSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableEbsEncryptionByDefaultRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableEbsEncryptionByDefaultResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastLaunchResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastSnapshotRestoreErrorItem' => [ 'base' => '<p>Contains information about the errors that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreErrorSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreErrorSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresResult$Unsuccessful' => '<p>Information about the snapshots for which fast snapshot restores could not be disabled.</p>', ], ], 'DisableFastSnapshotRestoreStateError' => [ 'base' => '<p>Describes an error that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreStateErrorItem$Error' => '<p>The error.</p>', ], ], 'DisableFastSnapshotRestoreStateErrorItem' => [ 'base' => '<p>Contains information about an error that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreStateErrorSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreStateErrorSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoreErrorItem$FastSnapshotRestoreStateErrors' => '<p>The errors.</p>', ], ], 'DisableFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores that were successfully disabled.</p>', 'refs' => [ 'DisableFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresResult$Successful' => '<p>Information about the snapshots for which fast snapshot restores were successfully disabled.</p>', ], ], 'DisableFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageBlockPublicAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageBlockPublicAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageDeprecationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageDeprecationResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageDeregistrationProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageDeregistrationProtectionResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImageResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableIpamOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableIpamOrganizationAdminAccountResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableSerialConsoleAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableSerialConsoleAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableSnapshotBlockPublicAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableSnapshotBlockPublicAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableTransitGatewayRouteTablePropagationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableTransitGatewayRouteTablePropagationResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for DisableVgwRoutePropagation.</p>', 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateEnclaveCertificateIamRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateEnclaveCertificateIamRoleResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIamInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIamInstanceProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateInstanceEventWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateInstanceEventWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpamByoasnRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpamByoasnResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpamResourceDiscoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpamResourceDiscoveryResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNatGatewayAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateNatGatewayAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSubnetCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSubnetCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayPolicyTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayPolicyTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrunkInterfaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrunkInterfaceResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateVpcCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateVpcCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'DiskCount' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$Count' => '<p>The number of disks with this configuration.</p>', ], ], 'DiskImage' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImageList$member' => NULL, ], ], 'DiskImageDescription' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Image' => '<p>The image.</p>', 'ImportVolumeTaskDetails$Image' => '<p>The image.</p>', ], ], 'DiskImageDetail' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImage$Image' => '<p>Information about the disk image.</p>', 'ImportVolumeRequest$Image' => '<p>The disk image.</p>', ], ], 'DiskImageFormat' => [ 'base' => NULL, 'refs' => [ 'DiskImageDescription$Format' => '<p>The disk image format.</p>', 'DiskImageDetail$Format' => '<p>The disk image format.</p>', 'ExportImageRequest$DiskImageFormat' => '<p>The disk image format.</p>', 'ExportImageResult$DiskImageFormat' => '<p>The disk image format for the exported image.</p>', 'ExportToS3Task$DiskImageFormat' => '<p>The format for the exported image.</p>', 'ExportToS3TaskSpecification$DiskImageFormat' => '<p>The format for the exported image.</p>', ], ], 'DiskImageList' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceRequest$DiskImages' => '<p>The disk image.</p>', ], ], 'DiskImageVolumeDescription' => [ 'base' => '<p>Describes a disk image volume.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Volume' => '<p>The volume.</p>', 'ImportVolumeTaskDetails$Volume' => '<p>The volume.</p>', ], ], 'DiskInfo' => [ 'base' => '<p>Describes a disk.</p>', 'refs' => [ 'DiskInfoList$member' => NULL, ], ], 'DiskInfoList' => [ 'base' => NULL, 'refs' => [ 'InstanceStorageInfo$Disks' => '<p>Describes the disks that are available for the instance type.</p>', ], ], 'DiskSize' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$SizeInGB' => '<p>The size of the disk in GB.</p>', 'InstanceStorageInfo$TotalSizeInGB' => '<p>The total size of the disks, in GB.</p>', ], ], 'DiskType' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$Type' => '<p>The type of disk.</p>', ], ], 'DnsEntry' => [ 'base' => '<p>Describes a DNS entry.</p>', 'refs' => [ 'DnsEntrySet$member' => NULL, ], ], 'DnsEntrySet' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$DnsEntries' => '<p>(Interface endpoint) The DNS entries for the endpoint.</p>', 'VpcEndpointConnection$DnsEntries' => '<p>The DNS entries for the VPC endpoint.</p>', ], ], 'DnsNameState' => [ 'base' => NULL, 'refs' => [ 'PrivateDnsNameConfiguration$State' => '<p>The verification state of the VPC endpoint service.</p> <p>&gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.</p>', 'ServiceDetail$PrivateDnsNameVerificationState' => '<p>The verification state of the VPC endpoint service.</p> <p>Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.</p>', ], ], 'DnsOptions' => [ 'base' => '<p>Describes the DNS options for an endpoint.</p>', 'refs' => [ 'VpcEndpoint$DnsOptions' => '<p>The DNS options for the endpoint.</p>', ], ], 'DnsOptionsSpecification' => [ 'base' => '<p>Describes the DNS options for an endpoint.</p>', 'refs' => [ 'CreateVpcEndpointRequest$DnsOptions' => '<p>The DNS options for the endpoint.</p>', 'ModifyVpcEndpointRequest$DnsOptions' => '<p>The DNS options for the endpoint.</p>', ], ], 'DnsRecordIpType' => [ 'base' => NULL, 'refs' => [ 'DnsOptions$DnsRecordIpType' => '<p>The DNS records created for the endpoint.</p>', 'DnsOptionsSpecification$DnsRecordIpType' => '<p>The DNS records created for the endpoint.</p>', ], ], 'DnsServersOptionsModifyStructure' => [ 'base' => '<p>Information about the DNS server to be used.</p>', 'refs' => [ 'ModifyClientVpnEndpointRequest$DnsServers' => '<p>Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to two DNS servers.</p>', ], ], 'DnsSupportValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. The default is <code>enable</code>.</p>', 'ModifyTransitGatewayOptions$DnsSupport' => '<p>Enable or disable DNS support.</p>', 'ModifyTransitGatewayVpcAttachmentRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. The default is <code>enable</code>.</p>', 'TransitGatewayOptions$DnsSupport' => '<p>Indicates whether DNS support is enabled.</p>', 'TransitGatewayRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. Enabled by default.</p>', 'TransitGatewayVpcAttachmentOptions$DnsSupport' => '<p>Indicates whether DNS support is enabled.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'Address$Domain' => '<p>The network (<code>vpc</code>).</p>', 'AllocateAddressRequest$Domain' => '<p>The network (<code>vpc</code>).</p>', 'AllocateAddressResult$Domain' => '<p>The network (<code>vpc</code>).</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationFleet$TotalFulfilledCapacity' => '<p>The capacity units that have been fulfilled.</p>', 'ClientData$UploadSize' => '<p>The size of the uploaded disk image, in GiB.</p>', 'CreateCapacityReservationFleetResult$TotalFulfilledCapacity' => '<p>The requested capacity units that have been successfully reserved.</p>', 'FleetCapacityReservation$FulfilledCapacity' => '<p>The number of capacity units fulfilled by the Capacity Reservation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'FleetData$FulfilledCapacity' => '<p>The number of units fulfilled by this request compared to the set target capacity.</p>', 'FleetData$FulfilledOnDemandCapacity' => '<p>The number of units fulfilled by this request compared to the set target On-Demand capacity.</p>', 'FleetLaunchTemplateOverrides$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p> <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p> <note> <p>When specifying weights, the price used in the <code>lowest-price</code> and <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per <i>instance</i> hour.</p> </note>', 'FleetLaunchTemplateOverrides$Priority' => '<p>The priority for the launch template override. The highest priority is launched first.</p> <p>If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.</p> <p>If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.</p> <p>Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the override has the lowest priority. You can set the same priority for different launch template overrides.</p>', 'FleetLaunchTemplateOverridesRequest$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p> <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p> <note> <p>When specifying weights, the price used in the <code>lowest-price</code> and <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per <i>instance</i> hour.</p> </note>', 'FleetLaunchTemplateOverridesRequest$Priority' => '<p>The priority for the launch template override. The highest priority is launched first.</p> <p>If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.</p> <p>If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.</p> <p>Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.</p>', 'LaunchTemplateOverrides$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p> <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p> <note> <p>When specifying weights, the price used in the <code>lowestPrice</code> and <code>priceCapacityOptimized</code> allocation strategies is per <i>unit</i> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per <i>instance</i> hour.</p> </note>', 'LaunchTemplateOverrides$Priority' => '<p>The priority for the launch template override. The highest priority is launched first.</p> <p>If <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, Spot Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.</p> <p>If the Spot <code>AllocationStrategy</code> is set to <code>capacityOptimizedPrioritized</code>, Spot Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.</p> <p>Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.</p>', 'MemoryGiBPerVCpu$Min' => '<p>The minimum amount of memory per vCPU, in GiB. If this parameter is not specified, there is no minimum limit.</p>', 'MemoryGiBPerVCpu$Max' => '<p>The maximum amount of memory per vCPU, in GiB. If this parameter is not specified, there is no maximum limit.</p>', 'MemoryGiBPerVCpuRequest$Min' => '<p>The minimum amount of memory per vCPU, in GiB. To specify no minimum limit, omit this parameter.</p>', 'MemoryGiBPerVCpuRequest$Max' => '<p>The maximum amount of memory per vCPU, in GiB. To specify no maximum limit, omit this parameter.</p>', 'NetworkBandwidthGbps$Min' => '<p>The minimum amount of network bandwidth, in Gbps. If this parameter is not specified, there is no minimum limit.</p>', 'NetworkBandwidthGbps$Max' => '<p>The maximum amount of network bandwidth, in Gbps. If this parameter is not specified, there is no maximum limit.</p>', 'NetworkBandwidthGbpsRequest$Min' => '<p>The minimum amount of network bandwidth, in Gbps. To specify no minimum limit, omit this parameter.</p>', 'NetworkBandwidthGbpsRequest$Max' => '<p>The maximum amount of network bandwidth, in Gbps. To specify no maximum limit, omit this parameter.</p>', 'PriceSchedule$Price' => '<p>The fixed price for the term.</p>', 'PriceScheduleSpecification$Price' => '<p>The fixed price for the term.</p>', 'PricingDetail$Price' => '<p>The price per instance.</p>', 'RecurringCharge$Amount' => '<p>The amount of the recurring charge.</p>', 'ReservedInstanceLimitPrice$Amount' => '<p>Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount * price).</p>', 'SnapshotDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SnapshotTaskDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SpotFleetLaunchSpecification$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p> <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p> <note> <p>When specifying weights, the price used in the <code>lowestPrice</code> and <code>priceCapacityOptimized</code> allocation strategies is per <i>unit</i> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per <i>instance</i> hour.</p> </note>', 'SpotFleetRequestConfigData$FulfilledCapacity' => '<p>The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.</p>', 'SpotFleetRequestConfigData$OnDemandFulfilledCapacity' => '<p>The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.</p>', 'TotalLocalStorageGB$Min' => '<p>The minimum amount of total local storage, in GB. If this parameter is not specified, there is no minimum limit.</p>', 'TotalLocalStorageGB$Max' => '<p>The maximum amount of total local storage, in GB. If this parameter is not specified, there is no maximum limit.</p>', 'TotalLocalStorageGBRequest$Min' => '<p>The minimum amount of total local storage, in GB. To specify no minimum limit, omit this parameter.</p>', 'TotalLocalStorageGBRequest$Max' => '<p>The maximum amount of total local storage, in GB. To specify no maximum limit, omit this parameter.</p>', ], ], 'DoubleWithConstraints' => [ 'base' => NULL, 'refs' => [ 'FleetCapacityReservation$Weight' => '<p>The weight of the instance type in the Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight">Instance type weight</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ReservationFleetInstanceSpecification$Weight' => '<p>The number of capacity units provided by the specified instance type. This value, together with the total target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], ], 'DrainSeconds' => [ 'base' => NULL, 'refs' => [ 'DisassociateNatGatewayAddressRequest$MaxDrainDurationSeconds' => '<p>The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress. Default value is 350 seconds.</p>', 'UnassignPrivateNatGatewayAddressRequest$MaxDrainDurationSeconds' => '<p>The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress. Default value is 350 seconds.</p>', ], ], 'DynamicRoutingValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayPeeringAttachmentRequestOptions$DynamicRouting' => '<p>Indicates whether dynamic routing is enabled or disabled.</p>', 'TransitGatewayPeeringAttachmentOptions$DynamicRouting' => '<p>Describes whether dynamic routing is enabled or disabled for the transit gateway peering attachment.</p>', ], ], 'EbsBlockDevice' => [ 'base' => '<p>Describes a block device for an EBS volume.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsEncryptionSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$EncryptionSupport' => '<p>Indicates whether Amazon EBS encryption is supported.</p>', ], ], 'EbsInfo' => [ 'base' => '<p>Describes the Amazon EBS features supported by the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$EbsInfo' => '<p>Describes the Amazon EBS settings for the instance type.</p>', ], ], 'EbsInstanceBlockDevice' => [ 'base' => '<p>Describes a parameter used to set up an EBS volume in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsInstanceBlockDeviceSpecification' => [ 'base' => '<p>Describes information used to set up an EBS volume specified in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMappingSpecification$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsNvmeSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$NvmeSupport' => '<p>Indicates whether non-volatile memory express (NVMe) is supported.</p>', ], ], 'EbsOptimizedInfo' => [ 'base' => '<p>Describes the optimized EBS performance for supported instance types.</p>', 'refs' => [ 'EbsInfo$EbsOptimizedInfo' => '<p>Describes the optimized EBS performance for the instance type.</p>', ], ], 'EbsOptimizedSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$EbsOptimizedSupport' => '<p>Indicates whether the instance type is Amazon EBS-optimized. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in <i>Amazon EC2 User Guide</i>.</p>', ], ], 'EbsStatusDetails' => [ 'base' => '<p>Describes the attached EBS status check for an instance.</p>', 'refs' => [ 'EbsStatusDetailsList$member' => NULL, ], ], 'EbsStatusDetailsList' => [ 'base' => NULL, 'refs' => [ 'EbsStatusSummary$Details' => '<p>Details about the attached EBS status check for an instance.</p>', ], ], 'EbsStatusSummary' => [ 'base' => '<p>Provides a summary of the attached EBS volume status for an instance.</p>', 'refs' => [ 'InstanceStatus$AttachedEbsStatus' => '<p>Reports impaired functionality that stems from an attached Amazon EBS volume that is unreachable and unable to complete I/O operations.</p>', ], ], 'Ec2InstanceConnectEndpoint' => [ 'base' => '<p>The EC2 Instance Connect Endpoint.</p>', 'refs' => [ 'CreateInstanceConnectEndpointResult$InstanceConnectEndpoint' => '<p>Information about the EC2 Instance Connect Endpoint.</p>', 'DeleteInstanceConnectEndpointResult$InstanceConnectEndpoint' => '<p>Information about the EC2 Instance Connect Endpoint.</p>', 'InstanceConnectEndpointSet$member' => NULL, ], ], 'Ec2InstanceConnectEndpointState' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceConnectEndpoint$State' => '<p>The current state of the EC2 Instance Connect Endpoint.</p>', ], ], 'EfaInfo' => [ 'base' => '<p>Describes the Elastic Fabric Adapters for the instance type.</p>', 'refs' => [ 'NetworkInfo$EfaInfo' => '<p>Describes the Elastic Fabric Adapters for the instance type.</p>', ], ], 'EfaSupportedFlag' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EfaSupported' => '<p>Indicates whether Elastic Fabric Adapter (EFA) is supported.</p>', ], ], 'EgressOnlyInternetGateway' => [ 'base' => '<p>Describes an egress-only internet gateway.</p>', 'refs' => [ 'CreateEgressOnlyInternetGatewayResult$EgressOnlyInternetGateway' => '<p>Information about the egress-only internet gateway.</p>', 'EgressOnlyInternetGatewayList$member' => NULL, ], ], 'EgressOnlyInternetGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$EgressOnlyInternetGatewayId' => '<p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>', 'DeleteEgressOnlyInternetGatewayRequest$EgressOnlyInternetGatewayId' => '<p>The ID of the egress-only internet gateway.</p>', 'EgressOnlyInternetGateway$EgressOnlyInternetGatewayId' => '<p>The ID of the egress-only internet gateway.</p>', 'EgressOnlyInternetGatewayIdList$member' => NULL, 'ReplaceRouteRequest$EgressOnlyInternetGatewayId' => '<p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>', ], ], 'EgressOnlyInternetGatewayIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysRequest$EgressOnlyInternetGatewayIds' => '<p>The IDs of the egress-only internet gateways.</p>', ], ], 'EgressOnlyInternetGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysResult$EgressOnlyInternetGateways' => '<p>Information about the egress-only internet gateways.</p>', ], ], 'EipAllocationPublicIp' => [ 'base' => NULL, 'refs' => [ 'AssociateAddressRequest$PublicIp' => '<p>Deprecated.</p>', 'DisassociateAddressRequest$PublicIp' => '<p>Deprecated.</p>', ], ], 'EipAssociationIdList' => [ 'base' => NULL, 'refs' => [ 'DisassociateNatGatewayAddressRequest$AssociationIds' => '<p>The association IDs of EIPs that have been associated with the NAT gateway.</p>', ], ], 'EkPubKeyFormat' => [ 'base' => NULL, 'refs' => [ 'GetInstanceTpmEkPubRequest$KeyFormat' => '<p>The required public endorsement key format. Specify <code>der</code> for a DER-encoded public key that is compatible with OpenSSL. Specify <code>tpmt</code> for a TPM 2.0 format that is compatible with tpm2-tools. The returned key is base64 encoded.</p>', 'GetInstanceTpmEkPubResult$KeyFormat' => '<p>The public endorsement key format.</p>', ], ], 'EkPubKeyType' => [ 'base' => NULL, 'refs' => [ 'GetInstanceTpmEkPubRequest$KeyType' => '<p>The required public endorsement key type.</p>', 'GetInstanceTpmEkPubResult$KeyType' => '<p>The public endorsement key type.</p>', ], ], 'EkPubKeyValue' => [ 'base' => NULL, 'refs' => [ 'GetInstanceTpmEkPubResult$KeyValue' => '<p>The public endorsement key material.</p>', ], ], 'ElasticGpuAssociation' => [ 'base' => '<note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.</p> </note> <p>Describes the association between an instance and an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuAssociationList$member' => NULL, ], ], 'ElasticGpuAssociationList' => [ 'base' => NULL, 'refs' => [ 'Instance$ElasticGpuAssociations' => '<p>Deprecated.</p> <note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.</p> </note>', ], ], 'ElasticGpuHealth' => [ 'base' => '<note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.</p> </note> <p>Describes the status of an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpus$ElasticGpuHealth' => '<p>The status of the Elastic Graphics accelerator.</p>', ], ], 'ElasticGpuId' => [ 'base' => NULL, 'refs' => [ 'ElasticGpuAssociation$ElasticGpuId' => '<p>The ID of the Elastic Graphics accelerator.</p>', 'ElasticGpuIdSet$member' => NULL, ], ], 'ElasticGpuIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusRequest$ElasticGpuIds' => '<p>The Elastic Graphics accelerator IDs.</p>', ], ], 'ElasticGpuSet' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusResult$ElasticGpuSet' => '<p>Information about the Elastic Graphics accelerators.</p>', ], ], 'ElasticGpuSpecification' => [ 'base' => '<note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.</p> </note> <p>A specification for an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuSpecificationList$member' => NULL, 'ElasticGpuSpecifications$member' => NULL, ], ], 'ElasticGpuSpecificationList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$ElasticGpuSpecifications' => '<p>Deprecated.</p> <note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.</p> </note>', ], ], 'ElasticGpuSpecificationResponse' => [ 'base' => '<p>Deprecated.</p> <note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.</p> </note>', 'refs' => [ 'ElasticGpuSpecificationResponseList$member' => NULL, ], ], 'ElasticGpuSpecificationResponseList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$ElasticGpuSpecifications' => '<p>Deprecated.</p> <note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.</p> </note>', ], ], 'ElasticGpuSpecifications' => [ 'base' => NULL, 'refs' => [ 'RunInstancesRequest$ElasticGpuSpecification' => '<p>An elastic GPU to associate with the instance.</p> <note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024.</p> </note>', ], ], 'ElasticGpuState' => [ 'base' => NULL, 'refs' => [ 'ElasticGpus$ElasticGpuState' => '<p>The state of the Elastic Graphics accelerator.</p>', ], ], 'ElasticGpuStatus' => [ 'base' => NULL, 'refs' => [ 'ElasticGpuHealth$Status' => '<p>The health status.</p>', ], ], 'ElasticGpus' => [ 'base' => '<note> <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.</p> </note> <p>Describes an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuSet$member' => NULL, ], ], 'ElasticInferenceAccelerator' => [ 'base' => '<p> Describes an elastic inference accelerator. </p>', 'refs' => [ 'ElasticInferenceAccelerators$member' => NULL, ], ], 'ElasticInferenceAcceleratorAssociation' => [ 'base' => '<p> Describes the association between an instance and an elastic inference accelerator. </p>', 'refs' => [ 'ElasticInferenceAcceleratorAssociationList$member' => NULL, ], ], 'ElasticInferenceAcceleratorAssociationList' => [ 'base' => NULL, 'refs' => [ 'Instance$ElasticInferenceAcceleratorAssociations' => '<p>The elastic inference accelerator associated with the instance.</p>', ], ], 'ElasticInferenceAcceleratorCount' => [ 'base' => NULL, 'refs' => [ 'ElasticInferenceAccelerator$Count' => '<p> The number of elastic inference accelerators to attach to the instance. </p> <p>Default: 1</p>', ], ], 'ElasticInferenceAccelerators' => [ 'base' => NULL, 'refs' => [ 'RunInstancesRequest$ElasticInferenceAccelerators' => '<p>An elastic inference accelerator to associate with the instance.</p> <note> <p>Amazon Elastic Inference (EI) is no longer available to new customers. For more information, see <a href="http://aws.amazon.com/machine-learning/elastic-inference/faqs/">Amazon Elastic Inference FAQs</a>.</p> </note>', ], ], 'ElasticIpAssociationId' => [ 'base' => NULL, 'refs' => [ 'DisassociateAddressRequest$AssociationId' => '<p>The association ID. This parameter is required.</p>', 'EipAssociationIdList$member' => NULL, ], ], 'EnaSrdSpecification' => [ 'base' => '<p>ENA Express uses Amazon Web Services Scalable Reliable Datagram (SRD) technology to increase the maximum bandwidth used per stream and minimize tail latency of network traffic between EC2 instances. With ENA Express, you can communicate between two EC2 instances in the same subnet within the same account, or in different accounts. Both sending and receiving instances must have ENA Express enabled.</p> <p>To improve the reliability of network packet delivery, ENA Express reorders network packets on the receiving end by default. However, some UDP-based applications are designed to handle network packets that are out of order to reduce the overhead for packet delivery at the network layer. When ENA Express is enabled, you can specify whether UDP network traffic uses it.</p>', 'refs' => [ 'AttachNetworkInterfaceRequest$EnaSrdSpecification' => '<p>Configures ENA Express for the network interface that this action attaches to the instance.</p>', 'ModifyNetworkInterfaceAttributeRequest$EnaSrdSpecification' => '<p>Updates the ENA Express configuration for the network interface that’s attached to the instance.</p>', ], ], 'EnaSrdSpecificationRequest' => [ 'base' => '<p>Launch instances with ENA Express settings configured from your launch template.</p>', 'refs' => [ 'InstanceNetworkInterfaceSpecification$EnaSrdSpecification' => '<p>Specifies the ENA Express settings for the network interface that\'s attached to the instance.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$EnaSrdSpecification' => '<p>Configure ENA Express settings for your launch template.</p>', ], ], 'EnaSrdSupported' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EnaSrdSupported' => '<p>Indicates whether the instance type supports ENA Express. ENA Express uses Amazon Web Services Scalable Reliable Datagram (SRD) technology to increase the maximum bandwidth used per stream and minimize tail latency of network traffic between EC2 instances.</p>', ], ], 'EnaSrdUdpSpecification' => [ 'base' => '<p>ENA Express is compatible with both TCP and UDP transport protocols. When it\'s enabled, TCP traffic automatically uses it. However, some UDP-based applications are designed to handle network packets that are out of order, without a need for retransmission, such as live video broadcasting or other near-real-time applications. For UDP traffic, you can specify whether to use ENA Express, based on your application environment needs.</p>', 'refs' => [ 'EnaSrdSpecification$EnaSrdUdpSpecification' => '<p>Configures ENA Express for UDP network traffic.</p>', ], ], 'EnaSrdUdpSpecificationRequest' => [ 'base' => '<p>Configures ENA Express for UDP network traffic from your launch template.</p>', 'refs' => [ 'EnaSrdSpecificationRequest$EnaSrdUdpSpecification' => '<p>Contains ENA Express settings for UDP network traffic in your launch template.</p>', ], ], 'EnaSupport' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EnaSupport' => '<p>Indicates whether Elastic Network Adapter (ENA) is supported.</p>', ], ], 'EnableAddressTransferRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableAddressTransferResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableAwsNetworkPerformanceMetricSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableAwsNetworkPerformanceMetricSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableEbsEncryptionByDefaultRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableEbsEncryptionByDefaultResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastLaunchResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastSnapshotRestoreErrorItem' => [ 'base' => '<p>Contains information about the errors that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreErrorSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreErrorSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoresResult$Unsuccessful' => '<p>Information about the snapshots for which fast snapshot restores could not be enabled.</p>', ], ], 'EnableFastSnapshotRestoreStateError' => [ 'base' => '<p>Describes an error that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreStateErrorItem$Error' => '<p>The error.</p>', ], ], 'EnableFastSnapshotRestoreStateErrorItem' => [ 'base' => '<p>Contains information about an error that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreStateErrorSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreStateErrorSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoreErrorItem$FastSnapshotRestoreStateErrors' => '<p>The errors.</p>', ], ], 'EnableFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores that were successfully enabled.</p>', 'refs' => [ 'EnableFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoresResult$Successful' => '<p>Information about the snapshots for which fast snapshot restores were successfully enabled.</p>', ], ], 'EnableFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageBlockPublicAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageBlockPublicAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageDeprecationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageDeprecationResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageDeregistrationProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageDeregistrationProtectionResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImageResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableIpamOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableIpamOrganizationAdminAccountResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableReachabilityAnalyzerOrganizationSharingRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableReachabilityAnalyzerOrganizationSharingResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableSerialConsoleAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableSerialConsoleAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableSnapshotBlockPublicAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableSnapshotBlockPublicAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableTransitGatewayRouteTablePropagationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableTransitGatewayRouteTablePropagationResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for EnableVgwRoutePropagation.</p>', 'refs' => [], ], 'EnableVolumeIORequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'EnclaveOptions' => [ 'base' => '<p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>', 'refs' => [ 'Instance$EnclaveOptions' => '<p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>', 'InstanceAttribute$EnclaveOptions' => '<p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>; otherwise, set it to <code>false</code>.</p>', ], ], 'EnclaveOptionsRequest' => [ 'base' => '<p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>', 'refs' => [ 'RunInstancesRequest$EnclaveOptions' => '<p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p> <p>You can\'t enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.</p>', ], ], 'EncryptionInTransitSupported' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EncryptionInTransitSupported' => '<p>Indicates whether the instance type automatically encrypts in-transit traffic between instances.</p>', ], ], 'EndDateType' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul>', 'CreateCapacityReservationRequest$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li> </ul>', 'ModifyCapacityReservationRequest$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.</p> </li> </ul>', ], ], 'EndpointSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsResult$ClientVpnEndpoints' => '<p>Information about the Client VPN endpoints.</p>', ], ], 'EphemeralNvmeSupport' => [ 'base' => NULL, 'refs' => [ 'InstanceStorageInfo$NvmeSupport' => '<p>Indicates whether non-volatile memory express (NVMe) is supported.</p>', ], ], 'ErrorSet' => [ 'base' => NULL, 'refs' => [ 'ValidationWarning$Errors' => '<p>The error codes and error messages.</p>', ], ], 'EventCode' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusEvent$Code' => '<p>The event code.</p>', ], ], 'EventInformation' => [ 'base' => '<p>Describes an EC2 Fleet or Spot Fleet event.</p>', 'refs' => [ 'HistoryRecord$EventInformation' => '<p>Information about the event.</p>', 'HistoryRecordEntry$EventInformation' => '<p>Information about the event.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryRequest$EventType' => '<p>The type of events to describe. By default, all events are described.</p>', 'HistoryRecord$EventType' => '<p>The event type.</p> <ul> <li> <p> <code>error</code> - An error with the Spot Fleet request.</p> </li> <li> <p> <code>fleetRequestChange</code> - A change in the status or configuration of the Spot Fleet request.</p> </li> <li> <p> <code>instanceChange</code> - An instance was launched or terminated.</p> </li> <li> <p> <code>Information</code> - An informational event.</p> </li> </ul>', ], ], 'ExcessCapacityTerminationPolicy' => [ 'base' => NULL, 'refs' => [ 'ModifySpotFleetRequestRequest$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request is decreased below the current size of the Spot Fleet.</p> <p>Supported only for fleets of type <code>maintain</code>.</p>', 'SpotFleetRequestConfigData$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running instances should be terminated if you decrease the target capacity of the Spot Fleet request below the current size of the Spot Fleet.</p> <p>Supported only for fleets of type <code>maintain</code>.</p>', ], ], 'ExcludedInstanceType' => [ 'base' => NULL, 'refs' => [ 'ExcludedInstanceTypeSet$member' => NULL, ], ], 'ExcludedInstanceTypeSet' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$ExcludedInstanceTypes' => '<p>The instance types to exclude.</p> <p>You can use strings with one or more wild cards, represented by an asterisk (<code>*</code>), to exclude an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code>, <code>c5*.*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>.</p> <p>For example, if you specify <code>c5*</code>,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code>, Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.</p> <note> <p>If you specify <code>ExcludedInstanceTypes</code>, you can\'t specify <code>AllowedInstanceTypes</code>.</p> </note> <p>Default: No excluded instance types</p>', 'InstanceRequirementsRequest$ExcludedInstanceTypes' => '<p>The instance types to exclude.</p> <p>You can use strings with one or more wild cards, represented by an asterisk (<code>*</code>), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code>, <code>c5*.*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>.</p> <p>For example, if you specify <code>c5*</code>,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code>, Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.</p> <note> <p>If you specify <code>ExcludedInstanceTypes</code>, you can\'t specify <code>AllowedInstanceTypes</code>.</p> </note> <p>Default: No excluded instance types</p>', ], ], 'ExecutableByStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$ExecutableUsers' => '<p>Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p> <ul> <li> <p>If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that specific Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s organization or organizational unit (OU) are not returned.</p> </li> <li> <p>If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your account are returned. In addition, AMIs that are shared with the organization or OU of which you are member are also returned. </p> </li> <li> <p>If you specify <code>all</code>, all public AMIs are returned.</p> </li> </ul>', ], ], 'Explanation' => [ 'base' => '<p>Describes an explanation code for an unreachable path. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>', 'refs' => [ 'ExplanationList$member' => NULL, ], ], 'ExplanationList' => [ 'base' => NULL, 'refs' => [ 'NetworkInsightsAnalysis$Explanations' => '<p>The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>', 'PathComponent$Explanations' => '<p>The explanation codes.</p>', ], ], 'ExportClientVpnClientCertificateRevocationListRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientCertificateRevocationListResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportEnvironment' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceExportTaskRequest$TargetEnvironment' => '<p>The target virtualization environment.</p>', 'InstanceExportDetails$TargetEnvironment' => '<p>The target virtualization environment.</p>', ], ], 'ExportImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportImageResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportImageTask' => [ 'base' => '<p>Describes an export image task.</p>', 'refs' => [ 'ExportImageTaskList$member' => NULL, ], ], 'ExportImageTaskId' => [ 'base' => NULL, 'refs' => [ 'ExportImageTaskIdList$member' => NULL, ], ], 'ExportImageTaskIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksRequest$ExportImageTaskIds' => '<p>The IDs of the export image tasks.</p>', ], ], 'ExportImageTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksResult$ExportImageTasks' => '<p>Information about the export image tasks.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Describes an export instance task.</p>', 'refs' => [ 'CreateInstanceExportTaskResult$ExportTask' => '<p>Information about the export instance task.</p>', 'ExportTaskList$member' => NULL, ], ], 'ExportTaskId' => [ 'base' => NULL, 'refs' => [ 'ExportTaskIdStringList$member' => NULL, ], ], 'ExportTaskIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksRequest$ExportTaskIds' => '<p>The export task IDs.</p>', ], ], 'ExportTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksResult$ExportTasks' => '<p>Information about the export tasks.</p>', ], ], 'ExportTaskS3Location' => [ 'base' => '<p>Describes the destination for an export image task.</p>', 'refs' => [ 'ExportImageResult$S3ExportLocation' => '<p>Information about the destination Amazon S3 bucket.</p>', 'ExportImageTask$S3ExportLocation' => '<p>Information about the destination Amazon S3 bucket.</p>', ], ], 'ExportTaskS3LocationRequest' => [ 'base' => '<p>Describes the destination for an export image task.</p>', 'refs' => [ 'ExportImageRequest$S3ExportLocation' => '<p>The Amazon S3 bucket for the destination image. The destination bucket must exist.</p>', ], ], 'ExportTaskState' => [ 'base' => NULL, 'refs' => [ 'ExportTask$State' => '<p>The state of the export task.</p>', ], ], 'ExportToS3Task' => [ 'base' => '<p>Describes the format and location for the export task.</p>', 'refs' => [ 'ExportTask$ExportToS3Task' => '<p>Information about the export task.</p>', ], ], 'ExportToS3TaskSpecification' => [ 'base' => '<p>Describes an export instance task.</p>', 'refs' => [ 'CreateInstanceExportTaskRequest$ExportToS3Task' => '<p>The format and location for an export instance task.</p>', ], ], 'ExportTransitGatewayRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportTransitGatewayRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportVmTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelExportTaskRequest$ExportTaskId' => '<p>The ID of the export task. This is the ID returned by the <code>CreateInstanceExportTask</code> and <code>ExportImage</code> operations.</p>', ], ], 'FailedCapacityReservationFleetCancellationResult' => [ 'base' => '<p>Describes a Capacity Reservation Fleet that could not be cancelled.</p>', 'refs' => [ 'FailedCapacityReservationFleetCancellationResultSet$member' => NULL, ], ], 'FailedCapacityReservationFleetCancellationResultSet' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationFleetsResult$FailedFleetCancellations' => '<p>Information about the Capacity Reservation Fleets that could not be cancelled.</p>', ], ], 'FailedQueuedPurchaseDeletion' => [ 'base' => '<p>Describes a Reserved Instance whose queued purchase was not deleted.</p>', 'refs' => [ 'FailedQueuedPurchaseDeletionSet$member' => NULL, ], ], 'FailedQueuedPurchaseDeletionSet' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesResult$FailedQueuedPurchaseDeletions' => '<p>Information about the queued purchases that could not be deleted.</p>', ], ], 'FastLaunchImageIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeFastLaunchImagesRequest$ImageIds' => '<p>Specify one or more Windows AMI image IDs for the request.</p>', ], ], 'FastLaunchLaunchTemplateSpecificationRequest' => [ 'base' => '<p>Request to create a launch template for a Windows fast launch enabled AMI.</p> <note> <p>Note - You can specify either the <code>LaunchTemplateName</code> or the <code>LaunchTemplateId</code>, but not both.</p> </note>', 'refs' => [ 'EnableFastLaunchRequest$LaunchTemplate' => '<p>The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch template parameters can include either the name or ID of the launch template, but not both.</p>', ], ], 'FastLaunchLaunchTemplateSpecificationResponse' => [ 'base' => '<p>Identifies the launch template that the AMI uses for Windows fast launch.</p>', 'refs' => [ 'DescribeFastLaunchImagesSuccessItem$LaunchTemplate' => '<p>The launch template that the Windows fast launch enabled AMI uses when it launches Windows instances from pre-provisioned snapshots.</p>', 'DisableFastLaunchResult$LaunchTemplate' => '<p>The launch template that was used to launch Windows instances from pre-provisioned snapshots.</p>', 'EnableFastLaunchResult$LaunchTemplate' => '<p>The launch template that is used when launching Windows instances from pre-provisioned snapshots.</p>', ], ], 'FastLaunchResourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeFastLaunchImagesSuccessItem$ResourceType' => '<p>The resource type that Amazon EC2 uses for pre-provisioning the Windows AMI. Supported values include: <code>snapshot</code>.</p>', 'DisableFastLaunchResult$ResourceType' => '<p>The pre-provisioning resource type that must be cleaned after turning off Windows fast launch for the Windows AMI. Supported values include: <code>snapshot</code>.</p>', 'EnableFastLaunchResult$ResourceType' => '<p>The type of resource that was defined for pre-provisioning the AMI for Windows fast launch.</p>', ], ], 'FastLaunchSnapshotConfigurationRequest' => [ 'base' => '<p>Configuration settings for creating and managing pre-provisioned snapshots for a Windows fast launch enabled AMI.</p>', 'refs' => [ 'EnableFastLaunchRequest$SnapshotConfiguration' => '<p>Configuration settings for creating and managing the snapshots that are used for pre-provisioning the AMI for Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.</p>', ], ], 'FastLaunchSnapshotConfigurationResponse' => [ 'base' => '<p>Configuration settings for creating and managing pre-provisioned snapshots for a Windows fast launch enabled Windows AMI.</p>', 'refs' => [ 'DescribeFastLaunchImagesSuccessItem$SnapshotConfiguration' => '<p>A group of parameters that are used for pre-provisioning the associated Windows AMI using snapshots.</p>', 'DisableFastLaunchResult$SnapshotConfiguration' => '<p>Parameters that were used for Windows fast launch for the Windows AMI before Windows fast launch was disabled. This informs the clean-up process.</p>', 'EnableFastLaunchResult$SnapshotConfiguration' => '<p>Settings to create and manage the pre-provisioned snapshots that Amazon EC2 uses for faster launches from the Windows AMI. This property is returned when the associated <code>resourceType</code> is <code>snapshot</code>.</p>', ], ], 'FastLaunchStateCode' => [ 'base' => NULL, 'refs' => [ 'DescribeFastLaunchImagesSuccessItem$State' => '<p>The current state of Windows fast launch for the specified Windows AMI.</p>', 'DisableFastLaunchResult$State' => '<p>The current state of Windows fast launch for the specified Windows AMI.</p>', 'EnableFastLaunchResult$State' => '<p>The current state of Windows fast launch for the specified AMI.</p>', ], ], 'FastSnapshotRestoreStateCode' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores.</p>', 'DisableFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores for the snapshot.</p>', 'EnableFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores.</p>', ], ], 'FederatedAuthentication' => [ 'base' => '<p>Describes the IAM SAML identity providers used for federated authentication.</p>', 'refs' => [ 'ClientVpnAuthentication$FederatedAuthentication' => '<p>Information about the IAM SAML identity provider, if applicable.</p>', ], ], 'FederatedAuthenticationRequest' => [ 'base' => '<p>The IAM SAML identity provider used for federated authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$FederatedAuthentication' => '<p>Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if <b>Type</b> is <code>federated-authentication</code>.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p> <p>If you specify multiple filters, the filters are joined with an <code>AND</code>, and the request returns only results that match all of the specified filters.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>allocation-id</code> - The allocation ID for the address.</p> </li> <li> <p> <code>association-id</code> - The association ID for the address.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p> </li> <li> <p> <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where Amazon Web Services advertises IP addresses. </p> </li> <li> <p> <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if any.</p> </li> <li> <p> <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.</p> </li> <li> <p> <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.</p> </li> <li> <p> <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeAvailabilityZonesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1</code>).</p> </li> <li> <p> <code>message</code> - The Zone message.</p> </li> <li> <p> <code>opt-in-status</code> - The opt-in status (<code>opted-in</code> | <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p> </li> <li> <p> <code>parent-zone-id</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>parent-zone-name</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).</p> </li> <li> <p> <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (<code>available</code>).</p> </li> <li> <p> <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-type</code> - The type of zone (<code>availability-zone</code> | <code>local-zone</code> | <code>wavelength-zone</code>).</p> </li> </ul>', 'DescribeAwsNetworkPerformanceMetricSubscriptionsRequest$Filters' => '<p>One or more filters.</p>', 'DescribeBundleTasksRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>bundle-id</code> - The ID of the bundle task.</p> </li> <li> <p> <code>error-code</code> - If the task failed, the error code returned.</p> </li> <li> <p> <code>error-message</code> - If the task failed, the error message returned.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p> </li> <li> <p> <code>s3-prefix</code> - The beginning of the AMI name.</p> </li> <li> <p> <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p> </li> <li> <p> <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update for the task.</p> </li> </ul>', 'DescribeCapacityReservationFleetsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>state</code> - The state of the Fleet (<code>submitted</code> | <code>modifying</code> | <code>active</code> | <code>partially_fulfilled</code> | <code>expiring</code> | <code>expired</code> | <code>cancelling</code> | <code>cancelled</code> | <code>failed</code>).</p> </li> <li> <p> <code>instance-match-criteria</code> - The instance matching criteria for the Fleet. Only <code>open</code> is supported.</p> </li> <li> <p> <code>tenancy</code> - The tenancy of the Fleet (<code>default</code> | <code>dedicated</code>).</p> </li> <li> <p> <code>allocation-strategy</code> - The allocation strategy used by the Fleet. Only <code>prioritized</code> is supported.</p> </li> </ul>', 'DescribeCapacityReservationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.</p> </li> <li> <p> <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.</p> </li> <li> <p> <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li> </ul> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p> </li> <li> <p> <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul> </li> <li> <p> <code>start-date</code> - The date and time at which the Capacity Reservation was started.</p> </li> <li> <p> <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to expired when it reaches its end date and time.</p> </li> <li> <p> <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul> </li> <li> <p> <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</p> </li> </ul> </li> <li> <p> <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation was created.</p> </li> </ul>', 'DescribeCarrierGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p> </li> <li> <p> <code>state</code> - The state of the carrier gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner of the carrier gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p> </li> </ul>', 'DescribeClassicLinkInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>group-id</code> - The ID of a VPC security group that\'s associated with the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC to which the instance is linked.</p> </li> </ul>', 'DescribeClientVpnAuthorizationRulesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>description</code> - The description of the authorization rule.</p> </li> <li> <p> <code>destination-cidr</code> - The CIDR of the network to which the authorization rule applies.</p> </li> <li> <p> <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p> </li> </ul>', 'DescribeClientVpnConnectionsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>connection-id</code> - The ID of the connection.</p> </li> <li> <p> <code>username</code> - For Active Directory client authentication, the user name of the client who established the client connection.</p> </li> </ul>', 'DescribeClientVpnEndpointsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p> </li> <li> <p> <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).</p> </li> </ul>', 'DescribeClientVpnRoutesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>destination-cidr</code> - The CIDR of the route destination.</p> </li> <li> <p> <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p> </li> <li> <p> <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p> </li> </ul>', 'DescribeClientVpnTargetNetworksRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>association-id</code> - The ID of the association.</p> </li> <li> <p> <code>target-network-id</code> - The ID of the subnet specified as the target network.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p> </li> </ul>', 'DescribeCoipPoolsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>coip-pool.local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>coip-pool.pool-id</code> - The ID of the address pool.</p> </li> </ul>', 'DescribeCustomerGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>bgp-asn</code> - The customer gateway\'s Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of the customer gateway.</p> </li> <li> <p> <code>ip-address</code> - The IP address of the customer gateway device\'s external interface.</p> </li> <li> <p> <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeDhcpOptionsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>dhcp-options-id</code> - The ID of a DHCP options set.</p> </li> <li> <p> <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p> </li> <li> <p> <code>value</code> - The value for one of the options.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the DHCP options set.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeEgressOnlyInternetGatewaysRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeElasticGpusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.</p> </li> <li> <p> <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> | <code>IMPAIRED</code>).</p> </li> <li> <p> <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).</p> </li> <li> <p> <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.</p> </li> </ul>', 'DescribeExportImageTasksRequest$Filters' => '<p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>', 'DescribeExportTasksRequest$Filters' => '<p>the filters for the export tasks.</p>', 'DescribeFastLaunchImagesRequest$Filters' => '<p>Use the following filters to streamline results.</p> <ul> <li> <p> <code>resource-type</code> - The resource type for pre-provisioning.</p> </li> <li> <p> <code>owner-id</code> - The owner ID for the pre-provisioning resource.</p> </li> <li> <p> <code>state</code> - The current state of fast launching for the Windows AMI.</p> </li> </ul>', 'DescribeFastSnapshotRestoresRequest$Filters' => '<p>The filters. The possible values are:</p> <ul> <li> <p> <code>availability-zone</code>: The Availability Zone of the snapshot.</p> </li> <li> <p> <code>owner-id</code>: The ID of the Amazon Web Services account that enabled fast snapshot restore on the snapshot.</p> </li> <li> <p> <code>snapshot-id</code>: The ID of the snapshot.</p> </li> <li> <p> <code>state</code>: The state of fast snapshot restores for the snapshot (<code>enabling</code> | <code>optimizing</code> | <code>enabled</code> | <code>disabling</code> | <code>disabled</code>).</p> </li> </ul>', 'DescribeFleetInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-type</code> - The instance type.</p> </li> </ul>', 'DescribeFleetsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> | <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).</p> </li> <li> <p> <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> | <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> | <code>modifying</code>).</p> </li> <li> <p> <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).</p> </li> </ul>', 'DescribeFlowLogsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p> </li> <li> <p> <code>log-destination-type</code> - The type of destination for the flow log data (<code>cloud-watch-logs</code> | <code>s3</code> | <code>kinesis-data-firehose</code>).</p> </li> <li> <p> <code>flow-log-id</code> - The ID of the flow log.</p> </li> <li> <p> <code>log-group-name</code> - The name of the log group.</p> </li> <li> <p> <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p> </li> <li> <p> <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeFpgaImagesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>create-time</code> - The creation time of the AFI.</p> </li> <li> <p> <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).</p> </li> <li> <p> <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).</p> </li> <li> <p> <code>name</code> - The name of the AFI.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the AFI owner.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>shell-version</code> - The version of the Amazon Web Services Shell that was used to create the bitstream.</p> </li> <li> <p> <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update.</p> </li> </ul>', 'DescribeHostReservationOfferingsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> </ul>', 'DescribeHostReservationsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> <li> <p> <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> | <code>active</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeHostsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the host.</p> </li> <li> <p> <code>client-token</code> - The idempotency token that you provided when you allocated the host.</p> </li> <li> <p> <code>host-reservation-id</code> - The ID of the reservation assigned to this host.</p> </li> <li> <p> <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.</p> </li> <li> <p> <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> | <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> | <code>released-permanent-failure</code>).</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeIamInstanceProfileAssociationsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li> </ul>', 'DescribeImagesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code> | <code>x86_64_mac</code> | <code>arm64_mac</code>).</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.</p> </li> <li> <p> <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.</p> </li> <li> <p> <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> | <code>standard</code>).</p> </li> <li> <p> <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is encrypted.</p> </li> <li> <p> <code>creation-date</code> - The time when the image was created, in the ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.</p> </li> <li> <p> <code>description</code> - The description of the image (provided during image creation).</p> </li> <li> <p> <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).</p> </li> <li> <p> <code>image-id</code> - The ID of the image.</p> </li> <li> <p> <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).</p> </li> <li> <p> <code>is-public</code> - A Boolean that indicates whether the image is public.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>manifest-location</code> - The location of the image manifest.</p> </li> <li> <p> <code>name</code> - The name of the AMI (provided during image creation).</p> </li> <li> <p> <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li> <li> <p> <code>platform</code> - The platform. The only supported value is <code>windows</code>.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>source-instance-id</code> - The ID of the instance that the AMI was created from if the AMI was created using CreateImage. This filter is applicable only if the AMI was created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>.</p> </li> <li> <p> <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>).</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - The message for the state change.</p> </li> <li> <p> <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the Intel 82599 VF interface is enabled.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).</p> </li> </ul>', 'DescribeImportImageTasksRequest$Filters' => '<p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>', 'DescribeImportSnapshotTasksRequest$Filters' => '<p>The filters.</p>', 'DescribeInstanceConnectEndpointsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-connect-endpoint-id</code> - The ID of the EC2 Instance Connect Endpoint.</p> </li> <li> <p> <code>state</code> - The state of the EC2 Instance Connect Endpoint (<code>create-in-progress</code> | <code>create-complete</code> | <code>create-failed</code> | <code>delete-in-progress</code> | <code>delete-complete</code> | <code>delete-failed</code>).</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet in which the EC2 Instance Connect Endpoint was created.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific value, regardless of tag key.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the EC2 Instance Connect Endpoint was created.</p> </li> </ul>', 'DescribeInstanceCreditSpecificationsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> </ul>', 'DescribeInstanceEventWindowsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>dedicated-host-id</code> - The event windows associated with the specified Dedicated Host ID.</p> </li> <li> <p> <code>event-window-name</code> - The event windows associated with the specified names. </p> </li> <li> <p> <code>instance-id</code> - The event windows associated with the specified instance ID.</p> </li> <li> <p> <code>instance-tag</code> - The event windows associated with the specified tag and value.</p> </li> <li> <p> <code>instance-tag-key</code> - The event windows associated with the specified tag key, regardless of the value.</p> </li> <li> <p> <code>instance-tag-value</code> - The event windows associated with the specified tag value, regardless of the key.</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the event window. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>CMX</code>, specify <code>tag:Owner</code> for the filter name and <code>CMX</code> for the filter value. </p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific key, regardless of the tag value. </p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific value, regardless of the tag key. </p> </li> </ul>', 'DescribeInstanceStatusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> | <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> | <code>instance-stop</code>).</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.instance-event-id</code> - The ID of the event whose date and time you are modifying.</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before-deadline</code> - The deadline for starting the event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-status.reachability</code> - Filters on instance status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> <li> <p> <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> <li> <p> <code>attached-ebs-status.status</code> - The status of the attached EBS volume for the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> </ul>', 'DescribeInstanceTopologyRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The name of the Availability Zone (for example, <code>us-west-2a</code>) or Local Zone (for example, <code>us-west-2-lax-1b</code>) that the instance is in.</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>p4d.24xlarge</code>) or instance family (for example, <code>p4d*</code>). You can use the <code>*</code> wildcard to match zero or more characters, or the <code>?</code> wildcard to match zero or one character.</p> </li> <li> <p> <code>zone-id</code> - The ID of the Availability Zone (for example, <code>usw2-az2</code>) or Local Zone (for example, <code>usw2-lax1-az1</code>) that the instance is in.</p> </li> </ul>', 'DescribeInstanceTypeOfferingsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>instance-type</code> - The instance type. For a list of possible values, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Instance.html">Instance</a>.</p> </li> <li> <p> <code>location</code> - The location. For a list of possible identifiers, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and Zones</a>.</p> </li> </ul>', 'DescribeInstanceTypesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>auto-recovery-supported</code> - Indicates whether Amazon CloudWatch action based recovery is supported (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>bare-metal</code> - Indicates whether it is a bare metal instance type (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>burstable-performance-supported</code> - Indicates whether the instance type is a burstable performance T instance type (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type of an instance family (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps</code> - The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-iops</code> - The baseline input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-throughput-in-mbps</code> - The baseline throughput performance for an EBS-optimized instance type, in MB/s.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps</code> - The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-iops</code> - The maximum input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-throughput-in-mbps</code> - The maximum throughput performance for an EBS-optimized instance type, in MB/s.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized (<code>supported</code> | <code>unsupported</code> | <code>default</code>).</p> </li> <li> <p> <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported (<code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>ebs-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for EBS volumes (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor (<code>nitro</code> | <code>xen</code>).</p> </li> <li> <p> <code>instance-storage-info.disk.count</code> - The number of local disks.</p> </li> <li> <p> <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.</p> </li> <li> <p> <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks (<code>hdd</code> | <code>ssd</code>).</p> </li> <li> <p> <code>instance-storage-info.encryption-support</code> - Indicates whether data is encrypted at rest (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>instance-storage-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for instance store (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local instance storage, in GB.</p> </li> <li> <p> <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example <code>c5.2xlarge</code> or c5*).</p> </li> <li> <p> <code>memory-info.size-in-mib</code> - The memory size.</p> </li> <li> <p> <code>network-info.efa-info.maximum-efa-interfaces</code> - The maximum number of Elastic Fabric Adapters (EFAs) per instance.</p> </li> <li> <p> <code>network-info.efa-supported</code> - Indicates whether the instance type supports Elastic Fabric Adapter (EFA) (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or required (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>network-info.encryption-in-transit-supported</code> - Indicates whether the instance type automatically encrypts in-transit traffic between instances (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6 (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>network-info.maximum-network-cards</code> - The maximum number of network cards per instance.</p> </li> <li> <p> <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.</p> </li> <li> <p> <code>network-info.network-performance</code> - The network performance (for example, "25 Gigabit").</p> </li> <li> <p> <code>nitro-enclaves-support</code> - Indicates whether Nitro Enclaves is supported (<code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>nitro-tpm-support</code> - Indicates whether NitroTPM is supported (<code>supported</code> | <code>unsupported</code>).</p> </li> <li> <p> <code>nitro-tpm-info.supported-versions</code> - The supported NitroTPM version (<code>2.0</code>).</p> </li> <li> <p> <code>processor-info.supported-architecture</code> - The CPU architecture (<code>arm64</code> | <code>i386</code> | <code>x86_64</code>).</p> </li> <li> <p> <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.</p> </li> <li> <p> <code>processor-info.supported-features</code> - The supported CPU features (<code>amd-sev-snp</code>).</p> </li> <li> <p> <code>supported-boot-mode</code> - The boot mode (<code>legacy-bios</code> | <code>uefi</code>).</p> </li> <li> <p> <code>supported-root-device-type</code> - The root device type (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>supported-usage-class</code> - The usage class (<code>on-demand</code> | <code>spot</code>).</p> </li> <li> <p> <code>supported-virtualization-type</code> - The virtualization type (<code>hvm</code> | <code>paravirtual</code>).</p> </li> <li> <p> <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-threads-per-core</code> - The default number of threads per core for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.</p> </li> <li> <p> <code>vcpu-info.valid-cores</code> - The number of cores that can be configured for the instance type.</p> </li> <li> <p> <code>vcpu-info.valid-threads-per-core</code> - The number of threads per core that can be configured for the instance type. For example, "1" or "1,2".</p> </li> </ul>', 'DescribeInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for example, <code>2022-09-15T17:15:20.000Z</code>.</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.</p> </li> <li> <p> <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> | <code>uefi</code> | <code>uefi-preferred</code>).</p> </li> <li> <p> <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was launched.</p> </li> <li> <p> <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance\'s Capacity Reservation preference (<code>open</code> | <code>none</code>).</p> </li> <li> <p> <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The ID of the targeted Capacity Reservation.</p> </li> <li> <p> <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code> - The ARN of the targeted Capacity Reservation group.</p> </li> <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance.</p> </li> <li> <p> <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or start (<code>legacy-bios</code> | <code>uefi</code>).</p> </li> <li> <p> <code>dns-name</code> - The public DNS name of the instance.</p> </li> <li> <p> <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS I/O.</p> </li> <li> <p> <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced networking with ENA.</p> </li> <li> <p> <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p> </li> <li> <p> <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.</p> </li> <li> <p> <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p> </li> <li> <p> <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.</p> </li> <li> <p> <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an ID.</p> </li> <li> <p> <code>iam-instance-profile.name</code> - The instance profile associated with the instance. Specified as an name.</p> </li> <li> <p> <code>image-id</code> - The ID of the image used to launch the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).</p> </li> <li> <p> <code>instance.group-id</code> - The ID of the security group for the instance. </p> </li> <li> <p> <code>instance.group-name</code> - The name of the security group for the instance. </p> </li> <li> <p> <code>ip-address</code> - The public IPv4 address of the instance.</p> </li> <li> <p> <code>ipv6-address</code> - The IPv6 address of the instance.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair used when the instance was launched.</p> </li> <li> <p> <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch group (for example, 0, 1, 2, and so on). </p> </li> <li> <p> <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.</p> </li> <li> <p> <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance (<code>disabled</code> | <code>default</code>).</p> </li> <li> <p> <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your instance (<code>enabled</code> | <code>disabled</code>)</p> </li> <li> <p> <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop limit (integer, possible values <code>1</code> to <code>64</code>)</p> </li> <li> <p> <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> | <code>required</code>)</p> </li> <li> <p> <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the instance metadata (<code>enabled</code> | <code>disabled</code>)</p> </li> <li> <p> <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> | <code>applied</code>).</p> </li> <li> <p> <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.</p> </li> <li> <p> <code>network-interface.addresses.association.association-id</code> - The association ID.</p> </li> <li> <p> <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.</p> </li> <li> <p> <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.</p> </li> <li> <p> <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.</p> </li> <li> <p> <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP address (IPv4) with a network interface.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is the primary private IPv4 address.</p> </li> <li> <p> <code>network-interface.addresses.private-dns-name</code> - The private DNS name.</p> </li> <li> <p> <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li> <li> <p> <code>network-interface.association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li> <li> <p> <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.</p> </li> <li> <p> <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.</p> </li> <li> <p> <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.public-dns-name</code> - The public DNS name.</p> </li> <li> <p> <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li> <li> <p> <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>network-interface.attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.network-card-index</code> - The index of the network card.</p> </li> <li> <p> <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.</p> </li> <li> <p> <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network interface with an IPv6 address is unreachable from the public internet.</p> </li> <li> <p> <code>network-interface.description</code> - The description of the network interface.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the network interface.</p> </li> <li> <p> <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is the primary IPv6 address.</p> </li> <li> <p> <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only network interface.</p> </li> <li> <p> <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network interface.</p> </li> <li> <p> <code>network-interface.mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.outpost-arn</code> - The ARN of the Outpost.</p> </li> <li> <p> <code>network-interface.owner-id</code> - The ID of the owner of the network interface.</p> </li> <li> <p> <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.</p> </li> <li> <p> <code>network-interface.private-ip-address</code> - The private IPv4 address.</p> </li> <li> <p> <code>network-interface.public-dns-name</code> - The public DNS name.</p> </li> <li> <p> <code>network-interface.requester-id</code> - The requester ID for the network interface.</p> </li> <li> <p> <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by Amazon Web Services.</p> </li> <li> <p> <code>network-interface.status</code> - The status of the network interface (<code>available</code>) | <code>in-use</code>).</p> </li> <li> <p> <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.</p> </li> <li> <p> <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.</p> </li> <li> <p> <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.</p> </li> <li> <p> <code>placement-group-name</code> - The name of the placement group for the instance.</p> </li> <li> <p> <code>placement-partition-number</code> - The partition in which the instance is located.</p> </li> <li> <p> <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.</p> </li> <li> <p> <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> | <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> | <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> | <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> | <code>Red Hat Enterprise Linux with SQL Server Standard</code> | <code>Red Hat Enterprise Linux with SQL Server Web</code> | <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> | <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> | <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Web</code>).</p> </li> <li> <p> <code>private-dns-name</code> - The private IPv4 DNS name of the instance.</p> </li> <li> <p> <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p> </li> <li> <p> <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p> </li> <li> <p> <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> | <code>resource-name</code>).</p> </li> <li> <p> <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to filter by the primary IP address of the network interface attached to the instance. To filter by additional IP addresses assigned to the network interface, use the filter <code>network-interface.addresses.private-ip-address</code>.</p> </li> <li> <p> <code>product-code</code> - The product code associated with the AMI used to launch the instance.</p> </li> <li> <p> <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>reason</code> - The reason for the current state of the instance (for example, shows "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, Amazon Web Services Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>reservation-id</code> - The ID of the instance\'s reservation. A reservation ID is created any time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be associated with more than one instance if you launch multiple instances using the same launch request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same launch request, you also get one reservation ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>spot-instance-request-id</code> - The ID of the Spot Instance request.</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - A message that describes the state change.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (<code>v2.0</code>). </p> </li> <li> <p> <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> | <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> | <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> | <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> | <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> | <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> | <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).</p> </li> <li> <p> <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for example, <code>2022-09-15T17:15:20.000Z</code>.</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> | <code>hvm</code>).</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is running in.</p> </li> </ul>', 'DescribeInternetGatewaysRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>available</code>). Present only if a VPC is attached.</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>internet-gateway-id</code> - The ID of the Internet gateway.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the internet gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeIpamExternalResourceVerificationTokensRequest$Filters' => '<p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p> <p>Available filters:</p> <ul> <li> <p> <code>ipam-arn</code> </p> </li> <li> <p> <code>ipam-external-resource-verification-token-arn</code> </p> </li> <li> <p> <code>ipam-external-resource-verification-token-id</code> </p> </li> <li> <p> <code>ipam-id</code> </p> </li> <li> <p> <code>ipam-region</code> </p> </li> <li> <p> <code>state</code> </p> </li> <li> <p> <code>status</code> </p> </li> <li> <p> <code>token-name</code> </p> </li> <li> <p> <code>token-value</code> </p> </li> </ul>', 'DescribeIpamPoolsRequest$Filters' => '<p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>', 'DescribeIpamResourceDiscoveriesRequest$Filters' => '<p>The resource discovery filters.</p>', 'DescribeIpamResourceDiscoveryAssociationsRequest$Filters' => '<p>The resource discovery association filters.</p>', 'DescribeIpamScopesRequest$Filters' => '<p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>', 'DescribeIpamsRequest$Filters' => '<p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>', 'DescribeIpv6PoolsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeKeyPairsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>key-pair-id</code> - The ID of the key pair.</p> </li> <li> <p> <code>fingerprint</code> - The fingerprint of the key pair.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> </ul>', 'DescribeLaunchTemplateVersionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>create-time</code> - The time the launch template version was created.</p> </li> <li> <p> <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.</p> </li> <li> <p> <code>http-endpoint</code> - Indicates whether the HTTP metadata endpoint on your instances is enabled (<code>enabled</code> | <code>disabled</code>).</p> </li> <li> <p> <code>http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint for the instance metadata service is enabled (<code>enabled</code> | <code>disabled</code>).</p> </li> <li> <p> <code>host-resource-group-arn</code> - The ARN of the host resource group in which to launch the instances.</p> </li> <li> <p> <code>http-tokens</code> - The state of token usage for your instance metadata requests (<code>optional</code> | <code>required</code>).</p> </li> <li> <p> <code>iam-instance-profile</code> - The ARN of the IAM instance profile.</p> </li> <li> <p> <code>image-id</code> - The ID of the AMI.</p> </li> <li> <p> <code>instance-type</code> - The instance type.</p> </li> <li> <p> <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default version.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>license-configuration-arn</code> - The ARN of the license configuration.</p> </li> <li> <p> <code>network-card-index</code> - The index of the network card.</p> </li> <li> <p> <code>ram-disk-id</code> - The RAM disk ID.</p> </li> </ul>', 'DescribeLaunchTemplatesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>create-time</code> - The time the launch template was created.</p> </li> <li> <p> <code>launch-template-name</code> - The name of the launch template.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-arn</code> - The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-association-id</code> - The ID of the association.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> </ul>', 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-arn</code> - The Amazon Resource Name (ARN) of the local gateway route table for the association.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-vpc-association-id</code> - The ID of the association.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway route table for the association.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li> </ul>', 'DescribeLocalGatewayRouteTablesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-arn</code> - The Amazon Resource Name (ARN) of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of a local gateway route table.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway route table.</p> </li> <li> <p> <code>state</code> - The state of the local gateway route table.</p> </li> </ul>', 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li> <li> <p> <code>local-gateway-virtual-interface-id</code> - The ID of the virtual interface.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway virtual interface group.</p> </li> </ul>', 'DescribeLocalGatewayVirtualInterfacesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-address</code> - The local address.</p> </li> <li> <p> <code>local-bgp-asn</code> - The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.</p> </li> <li> <p> <code>local-gateway-id</code> - The ID of the local gateway.</p> </li> <li> <p> <code>local-gateway-virtual-interface-id</code> - The ID of the virtual interface.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway virtual interface.</p> </li> <li> <p> <code>peer-address</code> - The peer address.</p> </li> <li> <p> <code>peer-bgp-asn</code> - The peer BGP ASN.</p> </li> <li> <p> <code>vlan</code> - The ID of the VLAN.</p> </li> </ul>', 'DescribeLocalGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the local gateway.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> </ul>', 'DescribeLockedSnapshotsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>lock-state</code> - The state of the snapshot lock (<code>compliance-cooloff</code> | <code>governance</code> | <code>compliance</code> | <code>expired</code>).</p> </li> </ul>', 'DescribeMacHostsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone of the EC2 Mac Dedicated Host.</p> </li> <li> <p> <code>instance-type</code> - The instance type size that the EC2 Mac Dedicated Host is configured to support.</p> </li> </ul>', 'DescribeManagedPrefixListsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>owner-id</code> - The ID of the prefix list owner.</p> </li> <li> <p> <code>prefix-list-id</code> - The ID of the prefix list.</p> </li> <li> <p> <code>prefix-list-name</code> - The name of the prefix list.</p> </li> </ul>', 'DescribeMovingAddressesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> | <code>RestoringToClassic</code>).</p> </li> </ul>', 'DescribeNatGatewaysRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>nat-gateway-id</code> - The ID of the NAT gateway.</p> </li> <li> <p> <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.</p> </li> </ul>', 'DescribeNetworkAclsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>association.association-id</code> - The ID of an association ID for the ACL.</p> </li> <li> <p> <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.</p> </li> <li> <p> <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.</p> </li> <li> <p> <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.</p> </li> <li> <p> <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.</p> </li> <li> <p> <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.</p> </li> <li> <p> <code>entry.port-range.from</code> - The start of the port range specified in the entry. </p> </li> <li> <p> <code>entry.port-range.to</code> - The end of the port range specified in the entry. </p> </li> <li> <p> <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> | <code>deny</code>).</p> </li> <li> <p> <code>entry.egress</code> - A Boolean that indicates the type of rule. Specify <code>true</code> for egress rules, or <code>false</code> for ingress rules.</p> </li> <li> <p> <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the set of ACL entries.</p> </li> <li> <p> <code>network-acl-id</code> - The ID of the network ACL.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the network ACL.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network ACL.</p> </li> </ul>', 'DescribeNetworkInsightsAccessScopeAnalysesRequest$Filters' => '<p>There are no supported filters.</p>', 'DescribeNetworkInsightsAccessScopesRequest$Filters' => '<p>There are no supported filters.</p>', 'DescribeNetworkInsightsAnalysesRequest$Filters' => '<p>The filters. The following are the possible values:</p> <ul> <li> <p>path-found - A Boolean value that indicates whether a feasible path is found.</p> </li> <li> <p>status - The status of the analysis (running | succeeded | failed).</p> </li> </ul>', 'DescribeNetworkInsightsPathsRequest$Filters' => '<p>The filters. The following are the possible values:</p> <ul> <li> <p>destination - The ID of the resource.</p> </li> <li> <p>filter-at-source.source-address - The source IPv4 address at the source.</p> </li> <li> <p>filter-at-source.source-port-range - The source port range at the source.</p> </li> <li> <p>filter-at-source.destination-address - The destination IPv4 address at the source.</p> </li> <li> <p>filter-at-source.destination-port-range - The destination port range at the source.</p> </li> <li> <p>filter-at-destination.source-address - The source IPv4 address at the destination.</p> </li> <li> <p>filter-at-destination.source-port-range - The source port range at the destination.</p> </li> <li> <p>filter-at-destination.destination-address - The destination IPv4 address at the destination.</p> </li> <li> <p>filter-at-destination.destination-port-range - The destination port range at the destination.</p> </li> <li> <p>protocol - The protocol.</p> </li> <li> <p>source - The ID of the resource.</p> </li> </ul>', 'DescribeNetworkInterfacePermissionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.</p> </li> <li> <p> <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface-permission.aws-account-id</code> - The Amazon Web Services account ID.</p> </li> <li> <p> <code>network-interface-permission.aws-service</code> - The Amazon Web Services service.</p> </li> <li> <p> <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).</p> </li> </ul>', 'DescribeNetworkInterfacesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li> <li> <p> <code>association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li> <li> <p> <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network interface.</p> </li> <li> <p> <code>addresses.association.public-ip</code> - The association ID returned when the network interface was associated with the Elastic IP address (IPv4).</p> </li> <li> <p> <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the network interface. </p> </li> <li> <p> <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.</p> </li> <li> <p> <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li> <li> <p> <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li> <li> <p> <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).</p> </li> <li> <p> <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the network interface.</p> </li> <li> <p> <code>description</code> - The description of the network interface.</p> </li> <li> <p> <code>group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.</p> </li> <li> <p> <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> | <code>aws_codestar_connections_managed</code> | <code>branch</code> | <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efs</code> | <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> | <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> | <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> | <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> | <code>trunk</code> | <code>vpc_endpoint</code>).</p> </li> <li> <p> <code>mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.</p> </li> <li> <p> <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).</p> </li> <li> <p> <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.</p> </li> <li> <p> <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that created the network interface.</p> </li> <li> <p> <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the network interface performs source/destination checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>status</code> - The status of the network interface. If the network interface is not attached to an instance, the status is <code>available</code>; if a network interface is attached to an instance the status is <code>in-use</code>.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network interface.</p> </li> </ul>', 'DescribePlacementGroupsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>group-name</code> - The name of the placement group.</p> </li> <li> <p> <code>group-arn</code> - The Amazon Resource Name (ARN) of the placement group.</p> </li> <li> <p> <code>spread-level</code> - The spread level for the placement group (<code>host</code> | <code>rack</code>). </p> </li> <li> <p> <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code> | <code>partition</code>).</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribePrefixListsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>prefix-list-id</code>: The ID of a prefix list.</p> </li> <li> <p> <code>prefix-list-name</code>: The name of a prefix list.</p> </li> </ul>', 'DescribePublicIpv4PoolsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeRegionsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>endpoint</code> - The endpoint of the Region (for example, <code>ec2.us-east-1.amazonaws.com</code>).</p> </li> <li> <p> <code>opt-in-status</code> - The opt-in status of the Region (<code>opt-in-not-required</code> | <code>opted-in</code> | <code>not-opted-in</code>).</p> </li> <li> <p> <code>region-name</code> - The name of the Region (for example, <code>us-east-1</code>).</p> </li> </ul>', 'DescribeReplaceRootVolumeTasksRequest$Filters' => '<p>Filter to use:</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance for which the root volume replacement task was created.</p> </li> </ul>', 'DescribeReservedInstancesListingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances.</p> </li> <li> <p> <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> | <code>cancelled</code> | <code>closed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> </ul>', 'DescribeReservedInstancesModificationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>client-token</code> - The idempotency token for the modification request.</p> </li> <li> <p> <code>create-date</code> - The time when the modification request was created.</p> </li> <li> <p> <code>effective-date</code> - The time when the modification becomes effective.</p> </li> <li> <p> <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.</p> </li> <li> <p> <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved Instances.</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.</p> </li> <li> <p> <code>reserved-instances-modification-id</code> - The ID of the modification request.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> | <code>fulfilled</code> | <code>failed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> <li> <p> <code>update-date</code> - The time when the modification request was last updated.</p> </li> </ul>', 'DescribeReservedInstancesOfferingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When this filter is not used, which is the default behavior, all offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description (<code>Linux/UNIX</code> | <code>Linux with SQL Server Standard</code> | <code>Linux with SQL Server Web</code> | <code>Linux with SQL Server Enterprise</code> | <code>SUSE Linux</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> | <code>Windows</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Enterprise</code>).</p> </li> <li> <p> <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeReservedInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or <code>Availability Zone</code>).</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description (<code>Linux/UNIX</code> | <code>Linux with SQL Server Standard</code> | <code>Linux with SQL Server Web</code> | <code>Linux with SQL Server Enterprise</code> | <code>SUSE Linux</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> | <code>Windows</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Enterprise</code>).</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instance.</p> </li> <li> <p> <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example, 2014-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> | <code>payment-failed</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeRouteTablesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>association.gateway-id</code> - The ID of the gateway involved in the association.</p> </li> <li> <p> <code>association.route-table-association-id</code> - The ID of an association ID for the route table.</p> </li> <li> <p> <code>association.route-table-id</code> - The ID of the route table involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in the response.</p> </li> <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the route table.</p> </li> <li> <p> <code>route-table-id</code> - The ID of the route table.</p> </li> <li> <p> <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.</p> </li> <li> <p> <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.</p> </li> <li> <p> <code>route.destination-prefix-list-id</code> - The ID (prefix) of the Amazon Web Services service specified in a route in the table.</p> </li> <li> <p> <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a route in the route table.</p> </li> <li> <p> <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.</p> </li> <li> <p> <code>route.instance-id</code> - The ID of an instance specified in a route in the table.</p> </li> <li> <p> <code>route.nat-gateway-id</code> - The ID of a NAT gateway.</p> </li> <li> <p> <code>route.transit-gateway-id</code> - The ID of a transit gateway.</p> </li> <li> <p> <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.</p> </li> <li> <p> <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>). The blackhole state indicates that the route\'s target isn\'t available (for example, the specified gateway isn\'t attached to the VPC, the specified NAT instance has been terminated, and so on).</p> </li> <li> <p> <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the table.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the route table.</p> </li> </ul>', 'DescribeScheduledInstanceAvailabilityRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeScheduledInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeSecurityGroupRulesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>group-id</code> - The ID of the security group.</p> </li> <li> <p> <code>security-group-rule-id</code> - The ID of the security group rule.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> </ul>', 'DescribeSecurityGroupsRequest$Filters' => '<p>The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.</p> <ul> <li> <p> <code>description</code> - The description of the security group.</p> </li> <li> <p> <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li> <li> <p> <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.group-name</code> - The name of a security group that is referenced in an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule allows outbound access.</p> </li> <li> <p> <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code>, a protocol number, or -1 for all protocols).</p> </li> <li> <p> <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li> <li> <p> <code>egress.ip-permission.user-id</code> - The ID of an Amazon Web Services account that has been referenced in an outbound security group rule.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group. </p> </li> <li> <p> <code>group-name</code> - The name of the security group.</p> </li> <li> <p> <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li> <li> <p> <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.group-name</code> - The name of a security group that is referenced in an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows inbound access.</p> </li> <li> <p> <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code>, a protocol number, or -1 for all protocols).</p> </li> <li> <p> <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li> <li> <p> <code>ip-permission.user-id</code> - The ID of an Amazon Web Services account that has been referenced in an inbound security group rule.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner of the security group.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC specified when the security group was created.</p> </li> </ul>', 'DescribeSnapshotTierStatusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li> <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li> <li> <p> <code>last-tiering-operation</code> - The state of the last archive or restore action. (<code>archival-in-progress</code> | <code>archival-completed</code> | <code>archival-failed</code> | <code>permanent-restore-in-progress</code> | <code>permanent-restore-completed</code> | <code>permanent-restore-failed</code> | <code>temporary-restore-in-progress</code> | <code>temporary-restore-completed</code> | <code>temporary-restore-failed</code>)</p> </li> </ul>', 'DescribeSnapshotsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>description</code> - A description of the snapshot.</p> </li> <li> <p> <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).</p> </li> <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li> <li> <p> <code>start-time</code> - The time stamp when the snapshot was initiated.</p> </li> <li> <p> <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> | <code>error</code>).</p> </li> <li> <p> <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li> <li> <p> <code>volume-size</code> - The size of the volume, in GiB.</p> </li> </ul>', 'DescribeSpotInstanceRequestsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone-group</code> - The Availability Zone group.</p> </li> <li> <p> <code>create-time</code> - The time stamp when the Spot Instance request was created.</p> </li> <li> <p> <code>fault-code</code> - The fault code related to the request.</p> </li> <li> <p> <code>fault-message</code> - The fault message related to the request.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance that fulfilled the request.</p> </li> <li> <p> <code>launch-group</code> - The Spot Instance launch group.</p> </li> <li> <p> <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> or <code>gp3</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic.</p> </li> <li> <p> <code>launch.group-id</code> - The ID of the security group for the instance.</p> </li> <li> <p> <code>launch.group-name</code> - The name of the security group for the instance.</p> </li> <li> <p> <code>launch.image-id</code> - The ID of the AMI.</p> </li> <li> <p> <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li> <li> <p> <code>launch.kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>launch.key-name</code> - The name of the key pair the instance launched with.</p> </li> <li> <p> <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.</p> </li> <li> <p> <code>launch.ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP address.</p> </li> <li> <p> <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when the instance is terminated.</p> </li> <li> <p> <code>network-interface.description</code> - A description of the network interface.</p> </li> <li> <p> <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the instance.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code> | <code>Windows</code>).</p> </li> <li> <p> <code>spot-instance-request-id</code> - The Spot Instance request ID.</p> </li> <li> <p> <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.</p> </li> <li> <p> <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> | <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help you track your Amazon EC2 Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-request-status.html">Spot request status</a> in the <i>Amazon EC2 User Guide</i>.</p> </li> <li> <p> <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance request.</p> </li> <li> <p> <code>status-message</code> - The message explaining the status of the Spot Instance request.</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).</p> </li> <li> <p> <code>valid-from</code> - The start date of the request.</p> </li> <li> <p> <code>valid-until</code> - The end date of the request.</p> </li> </ul>', 'DescribeSpotPriceHistoryRequest$Filters' => '<p>The filter