<?php
// This file was auto-generated from sdk-root/src/data/kinesis-video-webrtc-storage/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>webrtc</fullname> <p> </p></p>', 'operations' => [ 'JoinStorageSession' => '<note> <p>Before using this API, you must call the <code>GetSignalingChannelEndpoint</code> API to request the WEBRTC endpoint. You then specify the endpoint and region in your <code>JoinStorageSession</code> API request.</p> </note> <p>Join the ongoing one way-video and/or multi-way audio WebRTC session as a video producing device for an input channel. If there’s no existing session for the channel, a new streaming session needs to be created, and the Amazon Resource Name (ARN) of the signaling channel must be provided. </p> <p>Currently for the <code>SINGLE_MASTER</code> type, a video producing device is able to ingest both audio and video media into a stream. Only video producing devices can join the session and record media.</p> <important> <p>Both audio and video tracks are currently required for WebRTC ingestion.</p> <p>Current requirements:</p> <ul> <li> <p>Video track: H.264</p> </li> <li> <p>Audio track: Opus</p> </li> </ul> </important> <p>The resulting ingested video in the Kinesis video stream will have the following parameters: H.264 video and AAC audio.</p> <p>Once a master participant has negotiated a connection through WebRTC, the ingested media session will be stored in the Kinesis video stream. Multiple viewers are then able to play back real-time media through our Playback APIs.</p> <p>You can also use existing Kinesis Video Streams features like <code>HLS</code> or <code>DASH</code> playback, image generation via <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/gs-getImages.html">GetImages</a>, and more with ingested WebRTC media.</p> <note> <p>S3 image delivery and notifications are not currently supported.</p> </note> <note> <p>Assume that only one video producing device client can be associated with a session for the channel. If more than one client joins the session of a specific channel as a video producing device, the most recent client request takes precedence. </p> </note> <p> <b>Additional information</b> </p> <ul> <li> <p> <b>Idempotent</b> - This API is not idempotent.</p> </li> <li> <p> <b>Retry behavior</b> - This is counted as a new API call.</p> </li> <li> <p> <b>Concurrent calls</b> - Concurrent calls are allowed. An offer is sent once per each call.</p> </li> </ul>', 'JoinStorageSessionAsViewer' => '<p> Join the ongoing one way-video and/or multi-way audio WebRTC session as a viewer for an input channel. If there’s no existing session for the channel, create a new streaming session and provide the Amazon Resource Name (ARN) of the signaling channel (<code>channelArn</code>) and client id (<code>clientId</code>). </p> <p>Currently for <code>SINGLE_MASTER</code> type, a video producing device is able to ingest both audio and video media into a stream, while viewers can only ingest audio. Both a video producing device and viewers can join a session first and wait for other participants. While participants are having peer to peer conversations through WebRTC, the ingested media session will be stored into the Kinesis Video Stream. Multiple viewers are able to playback real-time media. </p> <p>Customers can also use existing Kinesis Video Streams features like <code>HLS</code> or <code>DASH</code> playback, Image generation, and more with ingested WebRTC media. If there’s an existing session with the same <code>clientId</code> that\'s found in the join session request, the new request takes precedence.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have required permissions to perform this operation.</p>', 'refs' => [], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'JoinStorageSessionAsViewerInput$channelArn' => '<p> The Amazon Resource Name (ARN) of the signaling channel. </p>', 'JoinStorageSessionInput$channelArn' => '<p> The Amazon Resource Name (ARN) of the signaling channel. </p>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'JoinStorageSessionAsViewerInput$clientId' => '<p> The unique identifier for the sender client. </p>', ], ], 'ClientLimitExceededException' => [ 'base' => '<p> Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later. </p>', 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>The value for this input parameter is invalid.</p>', 'refs' => [], ], 'JoinStorageSessionAsViewerInput' => [ 'base' => NULL, 'refs' => [], ], 'JoinStorageSessionInput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource is not found.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ClientLimitExceededException$message' => NULL, 'InvalidArgumentException$message' => NULL, 'ResourceNotFoundException$message' => NULL, ], ], ],];
