<?php
// This file was auto-generated from sdk-root/src/data/license-manager/2018-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>License Manager makes it easier to manage licenses from software vendors across multiple Amazon Web Services accounts and on-premises servers.</p>', 'operations' => [ 'AcceptGrant' => '<p>Accepts the specified grant.</p>', 'CheckInLicense' => '<p>Checks in the specified license. Check in a license when it is no longer in use.</p>', 'CheckoutBorrowLicense' => '<p>Checks out the specified license for offline use.</p>', 'CheckoutLicense' => '<p>Checks out the specified license.</p> <note> <p>If the account that created the license is the same that is performing the check out, you must specify the account as the beneficiary.</p> </note>', 'CreateGrant' => '<p>Creates a grant for the specified license. A grant shares the use of license entitlements with a specific Amazon Web Services account, an organization, or an organizational unit (OU). For more information, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html">Granted licenses in License Manager</a> in the <i>License Manager User Guide</i>.</p>', 'CreateGrantVersion' => '<p>Creates a new version of the specified grant. For more information, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html">Granted licenses in License Manager</a> in the <i>License Manager User Guide</i>.</p>', 'CreateLicense' => '<p>Creates a license.</p>', 'CreateLicenseConfiguration' => '<p>Creates a license configuration.</p> <p>A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to host (how long a license must be associated with a host), and the number of licenses purchased and used.</p>', 'CreateLicenseConversionTaskForResource' => '<p>Creates a new license conversion task.</p>', 'CreateLicenseManagerReportGenerator' => '<p>Creates a report generator.</p>', 'CreateLicenseVersion' => '<p>Creates a new version of the specified license.</p>', 'CreateToken' => '<p>Creates a long-lived token.</p> <p>A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.</p>', 'DeleteGrant' => '<p>Deletes the specified grant.</p>', 'DeleteLicense' => '<p>Deletes the specified license.</p>', 'DeleteLicenseConfiguration' => '<p>Deletes the specified license configuration.</p> <p>You cannot delete a license configuration that is in use.</p>', 'DeleteLicenseManagerReportGenerator' => '<p>Deletes the specified report generator.</p> <p>This action deletes the report generator, which stops it from generating future reports. The action cannot be reversed. It has no effect on the previous reports from this generator.</p>', 'DeleteToken' => '<p>Deletes the specified token. Must be called in the license home Region.</p>', 'ExtendLicenseConsumption' => '<p>Extends the expiration date for license consumption.</p>', 'GetAccessToken' => '<p>Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.</p>', 'GetGrant' => '<p>Gets detailed information about the specified grant.</p>', 'GetLicense' => '<p>Gets detailed information about the specified license.</p>', 'GetLicenseConfiguration' => '<p>Gets detailed information about the specified license configuration.</p>', 'GetLicenseConversionTask' => '<p>Gets information about the specified license type conversion task.</p>', 'GetLicenseManagerReportGenerator' => '<p>Gets information about the specified report generator.</p>', 'GetLicenseUsage' => '<p>Gets detailed information about the usage of the specified license.</p>', 'GetServiceSettings' => '<p>Gets the License Manager settings for the current Region.</p>', 'ListAssociationsForLicenseConfiguration' => '<p>Lists the resource associations for the specified license configuration.</p> <p>Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).</p>', 'ListDistributedGrants' => '<p>Lists the grants distributed for the specified license.</p>', 'ListFailuresForLicenseConfigurationOperations' => '<p>Lists the license configuration operations that failed.</p>', 'ListLicenseConfigurations' => '<p>Lists the license configurations for your account.</p>', 'ListLicenseConversionTasks' => '<p>Lists the license type conversion tasks for your account.</p>', 'ListLicenseManagerReportGenerators' => '<p>Lists the report generators for your account.</p>', 'ListLicenseSpecificationsForResource' => '<p>Describes the license configurations for the specified resource.</p>', 'ListLicenseVersions' => '<p>Lists all versions of the specified license.</p>', 'ListLicenses' => '<p>Lists the licenses for your account.</p>', 'ListReceivedGrants' => '<p>Lists grants that are received. Received grants are grants created while specifying the recipient as this Amazon Web Services account, your organization, or an organizational unit (OU) to which this member account belongs.</p>', 'ListReceivedGrantsForOrganization' => '<p>Lists the grants received for all accounts in the organization.</p>', 'ListReceivedLicenses' => '<p>Lists received licenses.</p>', 'ListReceivedLicensesForOrganization' => '<p>Lists the licenses received for all accounts in the organization.</p>', 'ListResourceInventory' => '<p>Lists resources managed using Systems Manager inventory.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified license configuration.</p>', 'ListTokens' => '<p>Lists your tokens.</p>', 'ListUsageForLicenseConfiguration' => '<p>Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.</p>', 'RejectGrant' => '<p>Rejects the specified grant.</p>', 'TagResource' => '<p>Adds the specified tags to the specified license configuration.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified license configuration.</p>', 'UpdateLicenseConfiguration' => '<p>Modifies the attributes of an existing license configuration.</p>', 'UpdateLicenseManagerReportGenerator' => '<p>Updates a report generator.</p> <p>After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.</p>', 'UpdateLicenseSpecificationsForResource' => '<p>Adds or removes the specified license configurations for the specified Amazon Web Services resource.</p> <p>You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and CloudFormation templates, as they send license configurations to the operation that creates the resource.</p>', 'UpdateServiceSettings' => '<p>Updates License Manager settings for the current Region.</p>', ], 'shapes' => [ 'AcceptGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>Access to resource denied.</p>', 'refs' => [], ], 'ActivationOverrideBehavior' => [ 'base' => NULL, 'refs' => [ 'Options$ActivationOverrideBehavior' => '<p>An activation option for your grant that determines the behavior of activating a grant. Activation options can only be used with granted licenses sourced from the Amazon Web Services Marketplace. Additionally, the operation must specify the value of <code>ACTIVE</code> for the <code>Status</code> parameter.</p> <ul> <li> <p>As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when activating a grant.</p> </li> <li> <p>As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a grant for a grantee account in your organization.</p> </li> <li> <p>As a grantee, if the grantor creating the distributed grant doesn’t specify an <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the grant.</p> </li> </ul> <dl> <dt>DISTRIBUTED_GRANTS_ONLY</dt> <dd> <p>Use this value to activate a grant without replacing any member account’s active grants for the same product.</p> </dd> <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt> <dd> <p>Use this value to activate a grant and disable other active grants in any member accounts for the same product. This action will also replace their previously activated grants with this activated grant.</p> </dd> </dl>', ], ], 'AllowedOperation' => [ 'base' => NULL, 'refs' => [ 'AllowedOperationList$member' => NULL, ], ], 'AllowedOperationList' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$AllowedOperations' => '<p>Allowed operations for the grant.</p>', 'CreateGrantVersionRequest$AllowedOperations' => '<p>Allowed operations for the grant.</p>', 'Grant$GrantedOperations' => '<p>Granted operations.</p>', 'ReceivedMetadata$AllowedOperations' => '<p>Allowed operations.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AcceptGrantRequest$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'AcceptGrantResponse$GrantArn' => '<p>Grant ARN.</p>', 'ArnList$member' => NULL, 'CheckoutBorrowLicenseRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>', 'CheckoutBorrowLicenseResponse$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'CreateGrantRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'CreateGrantResponse$GrantArn' => '<p>Grant ARN.</p>', 'CreateGrantVersionRequest$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'CreateGrantVersionResponse$GrantArn' => '<p>Grant ARN.</p>', 'CreateLicenseConversionTaskForResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>', 'CreateLicenseResponse$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'CreateLicenseVersionRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'CreateLicenseVersionResponse$LicenseArn' => '<p>License ARN.</p>', 'CreateTokenRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>', 'DeleteGrantRequest$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'DeleteGrantResponse$GrantArn' => '<p>Grant ARN.</p>', 'DeleteLicenseRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'GetGrantRequest$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'GetLicenseRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'GetLicenseUsageRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'Grant$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'Grant$ParentArn' => '<p>Parent ARN.</p>', 'Grant$LicenseArn' => '<p>License ARN.</p>', 'Grant$GranteePrincipalArn' => '<p>The grantee principal ARN.</p>', 'GrantedLicense$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'License$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'ListLicenseVersionsRequest$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'ListReceivedGrantsForOrganizationRequest$LicenseArn' => '<p>The Amazon Resource Name (ARN) of the received license.</p>', 'PrincipalArnList$member' => NULL, 'RejectGrantRequest$GrantArn' => '<p>Amazon Resource Name (ARN) of the grant.</p>', 'RejectGrantResponse$GrantArn' => '<p>Grant ARN.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$RoleArns' => '<p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>', 'ListDistributedGrantsRequest$GrantArns' => '<p>Amazon Resource Names (ARNs) of the grants.</p>', 'ListLicensesRequest$LicenseArns' => '<p>Amazon Resource Names (ARNs) of the licenses.</p>', 'ListReceivedGrantsRequest$GrantArns' => '<p>Amazon Resource Names (ARNs) of the grants.</p>', 'ListReceivedLicensesRequest$LicenseArns' => '<p>Amazon Resource Names (ARNs) of the licenses.</p>', 'ReportContext$licenseConfigurationArns' => '<p>Amazon Resource Name (ARN) of the license configuration that this generator reports on.</p>', 'TokenData$RoleArns' => '<p>Amazon Resource Names (ARN) of the roles included in the token.</p>', ], ], 'AuthorizationException' => [ 'base' => '<p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy associated with this account.</p>', 'refs' => [], ], 'AutomatedDiscoveryInformation' => [ 'base' => '<p>Describes automated discovery.</p>', 'refs' => [ 'GetLicenseConfigurationResponse$AutomatedDiscoveryInformation' => '<p>Automated discovery information.</p>', 'LicenseConfiguration$AutomatedDiscoveryInformation' => '<p>Automated discovery information.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ExtendLicenseConsumptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>', 'OrganizationConfiguration$EnableIntegration' => '<p>Enables Organizations integration.</p>', ], ], 'BorrowConfiguration' => [ 'base' => '<p>Details about a borrow configuration.</p>', 'refs' => [ 'ConsumptionConfiguration$BorrowConfiguration' => '<p>Details about a borrow configuration.</p>', ], ], 'BoxBoolean' => [ 'base' => NULL, 'refs' => [ 'BorrowConfiguration$AllowEarlyCheckIn' => '<p>Indicates whether early check-ins are allowed.</p>', 'CreateLicenseConfigurationRequest$LicenseCountHardLimit' => '<p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>', 'CreateLicenseConfigurationRequest$DisassociateWhenNotFound' => '<p>When true, disassociates a resource when software is uninstalled.</p>', 'Entitlement$Overage' => '<p>Indicates whether overages are allowed.</p>', 'Entitlement$AllowCheckIn' => '<p>Indicates whether check-ins are allowed.</p>', 'GetLicenseConfigurationResponse$LicenseCountHardLimit' => '<p>Sets the number of available licenses as a hard limit.</p>', 'GetLicenseConfigurationResponse$DisassociateWhenNotFound' => '<p>When true, disassociates a resource when software is uninstalled.</p>', 'GetServiceSettingsResponse$EnableCrossAccountsDiscovery' => '<p>Indicates whether cross-account discovery is enabled.</p>', 'LicenseConfiguration$LicenseCountHardLimit' => '<p>Number of available licenses as a hard limit.</p>', 'LicenseConfiguration$DisassociateWhenNotFound' => '<p>When true, disassociates a resource when software is uninstalled.</p>', 'UpdateLicenseConfigurationRequest$LicenseCountHardLimit' => '<p>New hard limit of the number of available licenses.</p>', 'UpdateLicenseConfigurationRequest$DisassociateWhenNotFound' => '<p>When true, disassociates a resource when software is uninstalled.</p>', 'UpdateServiceSettingsRequest$EnableCrossAccountsDiscovery' => '<p>Activates cross-account discovery.</p>', ], ], 'BoxInteger' => [ 'base' => NULL, 'refs' => [ 'BorrowConfiguration$MaxTimeToLiveInMinutes' => '<p>Maximum time for the borrow configuration, in minutes.</p>', 'ListAssociationsForLicenseConfigurationRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListFailuresForLicenseConfigurationOperationsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicenseConfigurationsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicenseConversionTasksRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicenseSpecificationsForResourceRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListResourceInventoryRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListUsageForLicenseConfigurationRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ProvisionalConfiguration$MaxTimeToLiveInMinutes' => '<p>Maximum time for the provisional configuration, in minutes.</p>', ], ], 'BoxLong' => [ 'base' => NULL, 'refs' => [ 'ConsumedLicenseSummary$ConsumedLicenses' => '<p>Number of licenses consumed by the resource.</p>', 'CreateLicenseConfigurationRequest$LicenseCount' => '<p>Number of licenses managed by the license configuration.</p>', 'GetLicenseConfigurationResponse$LicenseCount' => '<p>Number of available licenses.</p>', 'GetLicenseConfigurationResponse$ConsumedLicenses' => '<p>Number of licenses assigned to resources.</p>', 'LicenseConfiguration$LicenseCount' => '<p>Number of licenses managed by the license configuration.</p>', 'LicenseConfiguration$ConsumedLicenses' => '<p>Number of licenses consumed. </p>', 'LicenseConfigurationUsage$ConsumedLicenses' => '<p>Number of licenses consumed by the resource.</p>', 'ManagedResourceSummary$AssociationCount' => '<p>Number of resources associated with licenses.</p>', 'UpdateLicenseConfigurationRequest$LicenseCount' => '<p>New number of licenses managed by the license configuration.</p>', ], ], 'CheckInLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CheckInLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CheckoutBorrowLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CheckoutBorrowLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CheckoutLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CheckoutLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CheckoutType' => [ 'base' => NULL, 'refs' => [ 'CheckoutLicenseRequest$CheckoutType' => '<p>Checkout type.</p>', 'CheckoutLicenseResponse$CheckoutType' => '<p>Checkout type.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseManagerReportGeneratorRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateLicenseManagerReportGeneratorRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CheckoutLicenseRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateGrantRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateGrantVersionRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateLicenseRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateLicenseVersionRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateTokenRequest$ClientToken' => '<p>Idempotency token, valid for 10 minutes.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict processing the request. Try your request again.</p>', 'refs' => [], ], 'ConsumedLicenseSummary' => [ 'base' => '<p>Details about license consumption.</p>', 'refs' => [ 'ConsumedLicenseSummaryList$member' => NULL, ], ], 'ConsumedLicenseSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetLicenseConfigurationResponse$ConsumedLicenseSummaryList' => '<p>Summaries of the licenses consumed by resources.</p>', 'LicenseConfiguration$ConsumedLicenseSummaryList' => '<p>Summaries for licenses consumed by various resources.</p>', ], ], 'ConsumptionConfiguration' => [ 'base' => '<p>Details about a consumption configuration.</p>', 'refs' => [ 'CreateLicenseRequest$ConsumptionConfiguration' => '<p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>', 'CreateLicenseVersionRequest$ConsumptionConfiguration' => '<p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>', 'GrantedLicense$ConsumptionConfiguration' => '<p>Configuration for consumption of the license.</p>', 'License$ConsumptionConfiguration' => '<p>Configuration for consumption of the license.</p>', ], ], 'CreateGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrantVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrantVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseConversionTaskForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseConversionTaskForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseManagerReportGeneratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseManagerReportGeneratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLicenseVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'AutomatedDiscoveryInformation$LastRunTime' => '<p>Time that automated discovery last ran.</p>', 'GetLicenseConversionTaskResponse$StartTime' => '<p>Time at which the license type conversion task was started .</p>', 'GetLicenseConversionTaskResponse$LicenseConversionTime' => '<p>Amount of time to complete the license type conversion.</p>', 'GetLicenseConversionTaskResponse$EndTime' => '<p>Time at which the license type conversion task was completed.</p>', 'LicenseConfigurationAssociation$AssociationTime' => '<p>Time when the license configuration was associated with the resource.</p>', 'LicenseConfigurationUsage$AssociationTime' => '<p>Time when the license configuration was initially associated with the resource.</p>', 'LicenseConversionTask$StartTime' => '<p>The time the conversion task was started at.</p>', 'LicenseConversionTask$LicenseConversionTime' => '<p>The time the usage operation value of the resource was changed.</p>', 'LicenseConversionTask$EndTime' => '<p>The time the conversion task was completed.</p>', 'LicenseOperationFailure$FailureTime' => '<p>Failure time.</p>', ], ], 'DatetimeRange' => [ 'base' => '<p>Describes a time range, in ISO8601-UTC format.</p>', 'refs' => [ 'CreateLicenseRequest$Validity' => '<p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>', 'CreateLicenseVersionRequest$Validity' => '<p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>', 'GrantedLicense$Validity' => '<p>Date and time range during which the granted license is valid, in ISO8601-UTC format.</p>', 'License$Validity' => '<p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>', ], ], 'DeleteGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseManagerReportGeneratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseManagerReportGeneratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'DigitalSignatureMethod' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseRequest$DigitalSignatureMethod' => '<p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>', ], ], 'Entitlement' => [ 'base' => '<p>Describes a resource entitled for use with a license.</p>', 'refs' => [ 'EntitlementList$member' => NULL, ], ], 'EntitlementData' => [ 'base' => '<p>Data associated with an entitlement resource.</p>', 'refs' => [ 'EntitlementDataList$member' => NULL, ], ], 'EntitlementDataList' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseRequest$Entitlements' => '<p>License entitlements. Partial checkouts are not supported.</p>', 'CheckoutBorrowLicenseResponse$EntitlementsAllowed' => '<p>Allowed license entitlements.</p>', 'CheckoutLicenseRequest$Entitlements' => '<p>License entitlements.</p>', 'CheckoutLicenseResponse$EntitlementsAllowed' => '<p>Allowed license entitlements.</p>', ], ], 'EntitlementDataUnit' => [ 'base' => NULL, 'refs' => [ 'EntitlementData$Unit' => '<p>Entitlement data unit.</p>', 'EntitlementUsage$Unit' => '<p>Entitlement usage unit.</p>', ], ], 'EntitlementList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseRequest$Entitlements' => '<p>License entitlements.</p>', 'CreateLicenseVersionRequest$Entitlements' => '<p>License entitlements.</p>', 'GrantedLicense$Entitlements' => '<p>License entitlements.</p>', 'License$Entitlements' => '<p>License entitlements.</p>', ], ], 'EntitlementNotAllowedException' => [ 'base' => '<p>The entitlement is not allowed.</p>', 'refs' => [], ], 'EntitlementUnit' => [ 'base' => NULL, 'refs' => [ 'Entitlement$Unit' => '<p>Entitlement unit.</p>', ], ], 'EntitlementUsage' => [ 'base' => '<p>Usage associated with an entitlement resource.</p>', 'refs' => [ 'EntitlementUsageList$member' => NULL, ], ], 'EntitlementUsageList' => [ 'base' => NULL, 'refs' => [ 'LicenseUsage$EntitlementUsages' => '<p>License entitlement usages.</p>', ], ], 'ExtendLicenseConsumptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExtendLicenseConsumptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'FailedDependencyException' => [ 'base' => '<p>A dependency required to run the API is missing.</p>', 'refs' => [], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return more specific results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p>', 'refs' => [ 'FilterList$member' => NULL, 'Filters$member' => NULL, ], ], 'FilterLimitExceededException' => [ 'base' => '<p>The request uses too many filters or too many filter values.</p>', 'refs' => [], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListDistributedGrantsRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>LicenseArn</code> </p> </li> <li> <p> <code>GrantStatus</code> </p> </li> <li> <p> <code>GranteePrincipalARN</code> </p> </li> <li> <p> <code>ProductSKU</code> </p> </li> <li> <p> <code>LicenseIssuerName</code> </p> </li> </ul>', 'ListLicenseManagerReportGeneratorsRequest$Filters' => '<p>Filters to scope the results. The following filters are supported: </p> <ul> <li> <p> <code>LicenseConfigurationArn</code> </p> </li> </ul>', 'ListLicensesRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>Beneficiary</code> </p> </li> <li> <p> <code>ProductSKU</code> </p> </li> <li> <p> <code>Fingerprint</code> </p> </li> <li> <p> <code>Status</code> </p> </li> </ul>', 'ListReceivedGrantsForOrganizationRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>ParentArn</code> </p> </li> <li> <p> <code>GranteePrincipalArn</code> </p> </li> </ul>', 'ListReceivedGrantsRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>ProductSKU</code> </p> </li> <li> <p> <code>LicenseIssuerName</code> </p> </li> <li> <p> <code>LicenseArn</code> </p> </li> <li> <p> <code>GrantStatus</code> </p> </li> <li> <p> <code>GranterAccountId</code> </p> </li> </ul>', 'ListReceivedLicensesForOrganizationRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>Beneficiary</code> </p> </li> <li> <p> <code>ProductSKU</code> </p> </li> </ul>', 'ListReceivedLicensesRequest$Filters' => '<p>Filters to scope the results. The following filters are supported:</p> <ul> <li> <p> <code>ProductSKU</code> </p> </li> <li> <p> <code>Status</code> </p> </li> <li> <p> <code>Fingerprint</code> </p> </li> <li> <p> <code>IssuerName</code> </p> </li> <li> <p> <code>Beneficiary</code> </p> </li> </ul>', 'ListTokensRequest$Filters' => '<p>Filters to scope the results. The following filter is supported:</p> <ul> <li> <p> <code>LicenseArns</code> </p> </li> </ul>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>Name of the filter. Filter names are case-sensitive.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The value of the filter, which is case-sensitive. You can only specify one value for the filter.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListLicenseConfigurationsRequest$Filters' => '<p>Filters to scope the results. The following filters and logical operators are supported:</p> <ul> <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> </ul>', 'ListLicenseConversionTasksRequest$Filters' => '<p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>', 'ListUsageForLicenseConfigurationRequest$Filters' => '<p>Filters to scope the results. The following filters and logical operators are supported:</p> <ul> <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> </ul>', ], ], 'GetAccessTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseConversionTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseConversionTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseManagerReportGeneratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseManagerReportGeneratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseUsageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseUsageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Grant' => [ 'base' => '<p>Describes a grant.</p>', 'refs' => [ 'GetGrantResponse$Grant' => '<p>Grant details.</p>', 'GrantList$member' => NULL, ], ], 'GrantList' => [ 'base' => NULL, 'refs' => [ 'ListDistributedGrantsResponse$Grants' => '<p>Distributed grant details.</p>', 'ListReceivedGrantsForOrganizationResponse$Grants' => '<p>Lists the grants the organization has received.</p>', 'ListReceivedGrantsResponse$Grants' => '<p>Received grant details.</p>', ], ], 'GrantStatus' => [ 'base' => NULL, 'refs' => [ 'AcceptGrantResponse$Status' => '<p>Grant status.</p>', 'CreateGrantResponse$Status' => '<p>Grant status.</p>', 'CreateGrantVersionRequest$Status' => '<p>Grant status.</p>', 'CreateGrantVersionResponse$Status' => '<p>Grant status.</p>', 'DeleteGrantResponse$Status' => '<p>Grant status.</p>', 'Grant$GrantStatus' => '<p>Grant status.</p>', 'RejectGrantResponse$Status' => '<p>Grant status.</p>', ], ], 'GrantedLicense' => [ 'base' => '<p>Describes a license that is granted to a grantee.</p>', 'refs' => [ 'GrantedLicenseList$member' => NULL, ], ], 'GrantedLicenseList' => [ 'base' => NULL, 'refs' => [ 'ListReceivedLicensesForOrganizationResponse$Licenses' => '<p>Lists the licenses the organization has received.</p>', 'ListReceivedLicensesResponse$Licenses' => '<p>Received license details.</p>', ], ], 'ISO8601DateTime' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseResponse$IssuedAt' => '<p>Date and time at which the license checkout is issued.</p>', 'CheckoutBorrowLicenseResponse$Expiration' => '<p>Date and time at which the license checkout expires.</p>', 'CheckoutLicenseResponse$IssuedAt' => '<p>Date and time at which the license checkout is issued.</p>', 'CheckoutLicenseResponse$Expiration' => '<p>Date and time at which the license checkout expires.</p>', 'DatetimeRange$Begin' => '<p>Start of the time range.</p>', 'DatetimeRange$End' => '<p>End of the time range.</p>', 'DeleteLicenseResponse$DeletionDate' => '<p>Date when the license is deleted.</p>', 'ExtendLicenseConsumptionResponse$Expiration' => '<p>Date and time at which the license consumption expires.</p>', 'GrantedLicense$CreateTime' => '<p>Creation time of the granted license.</p>', 'License$CreateTime' => '<p>License creation time.</p>', 'TokenData$ExpirationTime' => '<p>Token expiration time, in ISO8601-UTC format.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$ExpirationInDays' => '<p>Token expiration, in days, counted from token creation. The default is 365 days.</p>', 'ReportFrequency$value' => '<p>Number of times within the frequency period that a report is generated. The only supported value is <code>1</code>.</p>', ], ], 'InvalidParameterValueException' => [ 'base' => '<p>One or more parameter values are not valid.</p>', 'refs' => [], ], 'InvalidResourceStateException' => [ 'base' => '<p>License Manager cannot allocate a license to a resource because of its state. </p> <p>For example, you cannot allocate a license to an instance in the process of shutting down.</p>', 'refs' => [], ], 'InventoryFilter' => [ 'base' => '<p>An inventory filter.</p>', 'refs' => [ 'InventoryFilterList$member' => NULL, ], ], 'InventoryFilterCondition' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Condition' => '<p>Condition of the filter.</p>', ], ], 'InventoryFilterList' => [ 'base' => NULL, 'refs' => [ 'ListResourceInventoryRequest$Filters' => '<p>Filters to scope the results. The following filters and logical operators are supported:</p> <ul> <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li> <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li> <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li> <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li> </ul>', ], ], 'Issuer' => [ 'base' => '<p>Details about the issuer of a license.</p>', 'refs' => [ 'CreateLicenseRequest$Issuer' => '<p>License issuer.</p>', 'CreateLicenseVersionRequest$Issuer' => '<p>License issuer.</p>', ], ], 'IssuerDetails' => [ 'base' => '<p>Details associated with the issuer of a license.</p>', 'refs' => [ 'GrantedLicense$Issuer' => '<p>Granted license issuer.</p>', 'License$Issuer' => '<p>License issuer.</p>', ], ], 'License' => [ 'base' => '<p>Software license that is managed in License Manager.</p>', 'refs' => [ 'GetLicenseResponse$License' => '<p>License details.</p>', 'LicenseList$member' => NULL, ], ], 'LicenseConfiguration' => [ 'base' => '<p>A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), host affinity (how long a VM must be associated with a host), and the number of licenses purchased and used.</p>', 'refs' => [ 'LicenseConfigurations$member' => NULL, ], ], 'LicenseConfigurationAssociation' => [ 'base' => '<p>Describes an association with a license configuration.</p>', 'refs' => [ 'LicenseConfigurationAssociations$member' => NULL, ], ], 'LicenseConfigurationAssociations' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsForLicenseConfigurationResponse$LicenseConfigurationAssociations' => '<p>Information about the associations for the license configuration.</p>', ], ], 'LicenseConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateLicenseConfigurationRequest$LicenseConfigurationStatus' => '<p>New status of the license configuration.</p>', ], ], 'LicenseConfigurationUsage' => [ 'base' => '<p>Details about the usage of a resource associated with a license configuration.</p>', 'refs' => [ 'LicenseConfigurationUsageList$member' => NULL, ], ], 'LicenseConfigurationUsageList' => [ 'base' => NULL, 'refs' => [ 'ListUsageForLicenseConfigurationResponse$LicenseConfigurationUsageList' => '<p>Information about the license configurations.</p>', ], ], 'LicenseConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListLicenseConfigurationsResponse$LicenseConfigurations' => '<p>Information about the license configurations.</p>', ], ], 'LicenseConversionContext' => [ 'base' => '<p>Information about a license type conversion task.</p>', 'refs' => [ 'CreateLicenseConversionTaskForResourceRequest$SourceLicenseContext' => '<p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.</p>', 'CreateLicenseConversionTaskForResourceRequest$DestinationLicenseContext' => '<p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the CLI </a> in the <i>License Manager User Guide</i>.</p>', 'GetLicenseConversionTaskResponse$SourceLicenseContext' => '<p>Information about the license type converted from.</p>', 'GetLicenseConversionTaskResponse$DestinationLicenseContext' => '<p>Information about the license type converted to.</p>', 'LicenseConversionTask$SourceLicenseContext' => '<p>Information about the license type this conversion task converted from.</p>', 'LicenseConversionTask$DestinationLicenseContext' => '<p>Information about the license type this conversion task converted to.</p>', ], ], 'LicenseConversionTask' => [ 'base' => '<p>Information about a license type conversion task.</p>', 'refs' => [ 'LicenseConversionTasks$member' => NULL, ], ], 'LicenseConversionTaskId' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseConversionTaskForResourceResponse$LicenseConversionTaskId' => '<p>The ID of the created license type conversion task.</p>', 'GetLicenseConversionTaskRequest$LicenseConversionTaskId' => '<p>ID of the license type conversion task to retrieve information on.</p>', 'GetLicenseConversionTaskResponse$LicenseConversionTaskId' => '<p>ID of the license type conversion task.</p>', 'LicenseConversionTask$LicenseConversionTaskId' => '<p>The ID of the license type conversion task.</p>', ], ], 'LicenseConversionTaskStatus' => [ 'base' => NULL, 'refs' => [ 'GetLicenseConversionTaskResponse$Status' => '<p>Status of the license type conversion task.</p>', 'LicenseConversionTask$Status' => '<p>The status of the conversion task.</p>', ], ], 'LicenseConversionTasks' => [ 'base' => NULL, 'refs' => [ 'ListLicenseConversionTasksResponse$LicenseConversionTasks' => '<p>Information about the license configuration tasks for your account.</p>', ], ], 'LicenseCountingType' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseConfigurationRequest$LicenseCountingType' => '<p>Dimension used to track the license inventory.</p>', 'GetLicenseConfigurationResponse$LicenseCountingType' => '<p>Dimension for which the licenses are counted.</p>', 'LicenseConfiguration$LicenseCountingType' => '<p>Dimension to use to track the license inventory.</p>', ], ], 'LicenseDeletionStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteLicenseResponse$Status' => '<p>License status.</p>', ], ], 'LicenseList' => [ 'base' => NULL, 'refs' => [ 'ListLicenseVersionsResponse$Licenses' => '<p>License details.</p>', 'ListLicensesResponse$Licenses' => '<p>License details.</p>', ], ], 'LicenseOperationFailure' => [ 'base' => '<p>Describes the failure of a license operation.</p>', 'refs' => [ 'LicenseOperationFailureList$member' => NULL, ], ], 'LicenseOperationFailureList' => [ 'base' => NULL, 'refs' => [ 'ListFailuresForLicenseConfigurationOperationsResponse$LicenseOperationFailureList' => '<p>License configuration operations that failed.</p>', ], ], 'LicenseSpecification' => [ 'base' => '<p>Details for associating a license configuration with a resource.</p>', 'refs' => [ 'LicenseSpecifications$member' => NULL, ], ], 'LicenseSpecifications' => [ 'base' => NULL, 'refs' => [ 'ListLicenseSpecificationsForResourceResponse$LicenseSpecifications' => '<p>License configurations associated with a resource.</p>', 'UpdateLicenseSpecificationsForResourceRequest$AddLicenseSpecifications' => '<p>ARNs of the license configurations to add.</p>', 'UpdateLicenseSpecificationsForResourceRequest$RemoveLicenseSpecifications' => '<p>ARNs of the license configurations to remove.</p>', ], ], 'LicenseStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseResponse$Status' => '<p>License status.</p>', 'CreateLicenseVersionRequest$Status' => '<p>License status.</p>', 'CreateLicenseVersionResponse$Status' => '<p>License status.</p>', 'GrantedLicense$Status' => '<p>Granted license status.</p>', 'License$Status' => '<p>License status.</p>', ], ], 'LicenseUsage' => [ 'base' => '<p>Describes the entitlement usage associated with a license.</p>', 'refs' => [ 'GetLicenseUsageResponse$LicenseUsage' => '<p>License usage details.</p>', ], ], 'LicenseUsageException' => [ 'base' => '<p>You do not have enough licenses available to support a new resource launch.</p>', 'refs' => [], ], 'ListAssociationsForLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsForLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributedGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributedGrantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFailuresForLicenseConfigurationOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFailuresForLicenseConfigurationOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseConversionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseConversionTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseManagerReportGeneratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseManagerReportGeneratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseSpecificationsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseSpecificationsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicenseVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLicensesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLicensesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedGrantsForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedGrantsForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedGrantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedLicensesForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedLicensesForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedLicensesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReceivedLicensesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceInventoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTokensRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTokensResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageForLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageForLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'RedirectException$Location' => NULL, ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Entitlement$MaxCount' => '<p>Maximum entitlement count. Use if the unit is not None.</p>', ], ], 'ManagedResourceSummary' => [ 'base' => '<p>Summary information about a managed resource.</p>', 'refs' => [ 'ManagedResourceSummaryList$member' => NULL, ], ], 'ManagedResourceSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetLicenseConfigurationResponse$ManagedResourceSummaryList' => '<p>Summaries of the managed resources.</p>', 'LicenseConfiguration$ManagedResourceSummaryList' => '<p>Summaries for managed resources.</p>', ], ], 'MaxSize100' => [ 'base' => NULL, 'refs' => [ 'ListDistributedGrantsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicenseManagerReportGeneratorsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicenseVersionsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListLicensesRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListReceivedGrantsForOrganizationRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListReceivedGrantsRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListReceivedLicensesForOrganizationRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListReceivedLicensesRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', 'ListTokensRequest$MaxResults' => '<p>Maximum number of results to return in a single call.</p>', ], ], 'MaxSize3StringList' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$TokenProperties' => '<p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>', 'GetAccessTokenRequest$TokenProperties' => '<p>Token properties to validate against those present in the JWT token.</p>', 'TokenData$TokenProperties' => '<p>Data specified by the caller.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AuthorizationException$Message' => NULL, 'ConflictException$Message' => NULL, 'EntitlementNotAllowedException$Message' => NULL, 'FailedDependencyException$Message' => NULL, 'FilterLimitExceededException$Message' => NULL, 'InvalidParameterValueException$Message' => NULL, 'InvalidResourceStateException$Message' => NULL, 'LicenseUsageException$Message' => NULL, 'NoEntitlementsAllowedException$Message' => NULL, 'RateLimitExceededException$Message' => NULL, 'RedirectException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServerInternalException$Message' => NULL, 'UnsupportedDigitalSignatureMethodException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Metadata' => [ 'base' => '<p>Describes key/value pairs.</p>', 'refs' => [ 'MetadataList$member' => NULL, ], ], 'MetadataList' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseRequest$CheckoutMetadata' => '<p>Information about constraints.</p>', 'CheckoutBorrowLicenseResponse$CheckoutMetadata' => '<p>Information about constraints.</p>', 'CreateLicenseRequest$LicenseMetadata' => '<p>Information about the license.</p>', 'CreateLicenseVersionRequest$LicenseMetadata' => '<p>Information about the license.</p>', 'GrantedLicense$LicenseMetadata' => '<p>Granted license metadata.</p>', 'License$LicenseMetadata' => '<p>License metadata.</p>', 'LicenseOperationFailure$MetadataList' => '<p>Reserved.</p>', ], ], 'NoEntitlementsAllowedException' => [ 'base' => '<p>There are no entitlements found for this license, or the entitlement maximum count is reached.</p>', 'refs' => [], ], 'Options' => [ 'base' => '<p>The options you can specify when you create a new version of a grant, such as activation override behavior. For more information, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html">Granted licenses in License Manager</a> in the <i>License Manager User Guide</i>.</p>', 'refs' => [ 'CreateGrantVersionRequest$Options' => '<p>The options specified for the grant.</p>', 'Grant$Options' => '<p>The options specified for the grant.</p>', ], ], 'OrganizationConfiguration' => [ 'base' => '<p>Configuration information for Organizations.</p>', 'refs' => [ 'GetServiceSettingsResponse$OrganizationConfiguration' => '<p>Indicates whether Organizations is integrated with License Manager for cross-account discovery.</p>', 'UpdateServiceSettingsRequest$OrganizationConfiguration' => '<p>Enables integration with Organizations for cross-account discovery.</p>', ], ], 'PrincipalArnList' => [ 'base' => NULL, 'refs' => [ 'CreateGrantRequest$Principals' => '<p>The grant principals. You can specify one of the following as an Amazon Resource Name (ARN):</p> <ul> <li> <p>An Amazon Web Services account, which includes only the account specified.</p> </li> </ul> <ul> <li> <p>An organizational unit (OU), which includes all accounts in the OU.</p> </li> </ul> <ul> <li> <p>An organization, which will include all accounts across your organization.</p> </li> </ul>', ], ], 'ProductInformation' => [ 'base' => '<p>Describes product information for a license configuration.</p>', 'refs' => [ 'ProductInformationList$member' => NULL, ], ], 'ProductInformationFilter' => [ 'base' => '<p>Describes product information filters.</p>', 'refs' => [ 'ProductInformationFilterList$member' => NULL, ], ], 'ProductInformationFilterList' => [ 'base' => NULL, 'refs' => [ 'ProductInformation$ProductInformationFilterList' => '<p>A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p> <p>Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid options for <code>ProductInformationFilterComparator</code>. </p> <p>The following filters and are supported when the resource type is <code>SSM_MANAGED</code>:</p> <ul> <li> <p> <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.</p> </li> <li> <p> <code>Application Publisher</code> - The publisher of the application. Logical operator is <code>EQUALS</code>.</p> </li> <li> <p> <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.</p> </li> <li> <p> <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.</p> </li> <li> <p> <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.</p> </li> <li> <p> <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>. The key for your tag must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>. <code>ProductInformationFilterValue</code> is optional if you are not using values for the key. </p> </li> <li> <p> <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>.</p> </li> <li> <p> <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and <code>NOT_EQUALS</code>. Possible values are: <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li> </ul> <p>The following filters and logical operators are supported when the resource type is <code>RDS</code>:</p> <ul> <li> <p> <code>Engine Edition</code> - The edition of the database engine. Logical operator is <code>EQUALS</code>. Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> | <code>oracle-se2</code>.</p> </li> <li> <p> <code>License Pack</code> - The license pack. Logical operator is <code>EQUALS</code>. Possible values are: <code>data guard</code> | <code>diagnostic pack sqlt</code> | <code>tuning pack sqlt</code> | <code>ols</code> | <code>olap</code>.</p> </li> </ul>', ], ], 'ProductInformationList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseConfigurationRequest$ProductInformationList' => '<p>Product information.</p>', 'GetLicenseConfigurationResponse$ProductInformationList' => '<p>Product information.</p>', 'LicenseConfiguration$ProductInformationList' => '<p>Product information.</p>', 'UpdateLicenseConfigurationRequest$ProductInformationList' => '<p>New product information.</p>', ], ], 'ProvisionalConfiguration' => [ 'base' => '<p>Details about a provisional configuration.</p>', 'refs' => [ 'ConsumptionConfiguration$ProvisionalConfiguration' => '<p>Details about a provisional configuration.</p>', ], ], 'RateLimitExceededException' => [ 'base' => '<p>Too many requests have been submitted. Try again after a brief wait.</p>', 'refs' => [], ], 'ReceivedMetadata' => [ 'base' => '<p>Metadata associated with received licenses and grants.</p>', 'refs' => [ 'GrantedLicense$ReceivedMetadata' => '<p>Granted license received metadata.</p>', ], ], 'ReceivedStatus' => [ 'base' => NULL, 'refs' => [ 'ReceivedMetadata$ReceivedStatus' => '<p>Received status.</p>', ], ], 'RedirectException' => [ 'base' => '<p>This is not the correct Region for the resource. Try again.</p>', 'refs' => [], ], 'RejectGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenewType' => [ 'base' => NULL, 'refs' => [ 'ConsumptionConfiguration$RenewType' => '<p>Renewal frequency.</p>', ], ], 'ReportContext' => [ 'base' => '<p>Details of the license configuration that this generator reports on.</p>', 'refs' => [ 'CreateLicenseManagerReportGeneratorRequest$ReportContext' => '<p>Defines the type of license configuration the report generator tracks.</p>', 'ReportGenerator$ReportContext' => '<p>License configuration type for this generator.</p>', 'UpdateLicenseManagerReportGeneratorRequest$ReportContext' => '<p>The report context.</p>', ], ], 'ReportFrequency' => [ 'base' => '<p>Details about how frequently reports are generated.</p>', 'refs' => [ 'CreateLicenseManagerReportGeneratorRequest$ReportFrequency' => '<p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>', 'ReportGenerator$ReportFrequency' => '<p>Details about how frequently reports are generated.</p>', 'UpdateLicenseManagerReportGeneratorRequest$ReportFrequency' => '<p>Frequency by which reports are generated.</p>', ], ], 'ReportFrequencyType' => [ 'base' => NULL, 'refs' => [ 'ReportFrequency$period' => '<p>Time period between each report. The period can be daily, weekly, or monthly.</p>', ], ], 'ReportGenerator' => [ 'base' => '<p>Describe the details of a report generator.</p>', 'refs' => [ 'GetLicenseManagerReportGeneratorResponse$ReportGenerator' => '<p>A report generator that creates periodic reports about your license configurations.</p>', 'ReportGeneratorList$member' => NULL, ], ], 'ReportGeneratorList' => [ 'base' => NULL, 'refs' => [ 'ListLicenseManagerReportGeneratorsResponse$ReportGenerators' => '<p>A report generator that creates periodic reports about your license configurations.</p>', ], ], 'ReportGeneratorName' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseManagerReportGeneratorRequest$ReportGeneratorName' => '<p>Name of the report generator.</p>', 'UpdateLicenseManagerReportGeneratorRequest$ReportGeneratorName' => '<p>Name of the report generator.</p>', ], ], 'ReportType' => [ 'base' => NULL, 'refs' => [ 'ReportTypeList$member' => NULL, ], ], 'ReportTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseManagerReportGeneratorRequest$Type' => '<p>Type of reports to generate. The following report types an be generated:</p> <ul> <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li> <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li> </ul>', 'ReportGenerator$ReportType' => '<p>Type of reports that are generated.</p>', 'UpdateLicenseManagerReportGeneratorRequest$Type' => '<p>Type of reports to generate. The following report types are supported:</p> <ul> <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li> <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li> </ul>', ], ], 'ResourceInventory' => [ 'base' => '<p>Details about a resource.</p>', 'refs' => [ 'ResourceInventoryList$member' => NULL, ], ], 'ResourceInventoryList' => [ 'base' => NULL, 'refs' => [ 'ListResourceInventoryResponse$ResourceInventoryList' => '<p>Information about the resources.</p>', ], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Your resource limits have been exceeded.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource cannot be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConsumedLicenseSummary$ResourceType' => '<p>Resource type of the resource consuming a license.</p>', 'LicenseConfigurationAssociation$ResourceType' => '<p>Type of server resource.</p>', 'LicenseConfigurationUsage$ResourceType' => '<p>Type of resource.</p>', 'LicenseOperationFailure$ResourceType' => '<p>Resource type.</p>', 'ManagedResourceSummary$ResourceType' => '<p>Type of resource associated with a license.</p>', 'ResourceInventory$ResourceType' => '<p>Type of resource.</p>', ], ], 'S3Location' => [ 'base' => '<p>Details of the S3 bucket that report generator reports are published to.</p>', 'refs' => [ 'ReportGenerator$S3Location' => '<p>Details of the S3 bucket that report generator reports are published to.</p>', ], ], 'ServerInternalException' => [ 'base' => '<p>The server experienced an internal error. Try again.</p>', 'refs' => [], ], 'SignedToken' => [ 'base' => NULL, 'refs' => [ 'CheckoutBorrowLicenseResponse$SignedToken' => '<p>Signed token.</p>', 'CheckoutLicenseResponse$SignedToken' => '<p>Signed token.</p>', ], ], 'StatusReasonMessage' => [ 'base' => NULL, 'refs' => [ 'CreateGrantVersionRequest$StatusReason' => '<p>Grant status reason.</p>', 'DeleteGrantRequest$StatusReason' => '<p>The Status reason for the delete request.</p>', 'Grant$StatusReason' => '<p>Grant status reason.</p>', 'ReceivedMetadata$ReceivedStatusReason' => '<p>Received status reason.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptGrantResponse$Version' => '<p>Grant version.</p>', 'CheckInLicenseRequest$LicenseConsumptionToken' => '<p>License consumption token.</p>', 'CheckInLicenseRequest$Beneficiary' => '<p>License beneficiary.</p>', 'CheckoutBorrowLicenseRequest$NodeId' => '<p>Node ID.</p>', 'CheckoutBorrowLicenseResponse$LicenseConsumptionToken' => '<p>License consumption token.</p>', 'CheckoutBorrowLicenseResponse$NodeId' => '<p>Node ID.</p>', 'CheckoutLicenseRequest$ProductSKU' => '<p>Product SKU.</p>', 'CheckoutLicenseRequest$KeyFingerprint' => '<p>Key fingerprint identifying the license.</p>', 'CheckoutLicenseRequest$Beneficiary' => '<p>License beneficiary.</p>', 'CheckoutLicenseRequest$NodeId' => '<p>Node ID.</p>', 'CheckoutLicenseResponse$LicenseConsumptionToken' => '<p>License consumption token.</p>', 'CheckoutLicenseResponse$NodeId' => '<p>Node ID.</p>', 'CheckoutLicenseResponse$LicenseArn' => '<p>Amazon Resource Name (ARN) of the checkout license.</p>', 'CreateGrantRequest$GrantName' => '<p>Grant name.</p>', 'CreateGrantRequest$HomeRegion' => '<p>Home Region of the grant.</p>', 'CreateGrantResponse$Version' => '<p>Grant version.</p>', 'CreateGrantVersionRequest$GrantName' => '<p>Grant name.</p>', 'CreateGrantVersionRequest$SourceVersion' => '<p>Current version of the grant.</p>', 'CreateGrantVersionResponse$Version' => '<p>New version of the grant.</p>', 'CreateLicenseConfigurationRequest$Name' => '<p>Name of the license configuration.</p>', 'CreateLicenseConfigurationRequest$Description' => '<p>Description of the license configuration.</p>', 'CreateLicenseConfigurationResponse$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'CreateLicenseManagerReportGeneratorRequest$Description' => '<p>Description of the report generator.</p>', 'CreateLicenseManagerReportGeneratorResponse$LicenseManagerReportGeneratorArn' => '<p>The Amazon Resource Name (ARN) of the new report generator.</p>', 'CreateLicenseRequest$LicenseName' => '<p>License name.</p>', 'CreateLicenseRequest$ProductName' => '<p>Product name.</p>', 'CreateLicenseRequest$ProductSKU' => '<p>Product SKU.</p>', 'CreateLicenseRequest$HomeRegion' => '<p>Home Region for the license.</p>', 'CreateLicenseRequest$Beneficiary' => '<p>License beneficiary.</p>', 'CreateLicenseResponse$Version' => '<p>License version.</p>', 'CreateLicenseVersionRequest$LicenseName' => '<p>License name.</p>', 'CreateLicenseVersionRequest$ProductName' => '<p>Product name.</p>', 'CreateLicenseVersionRequest$HomeRegion' => '<p>Home Region of the license.</p>', 'CreateLicenseVersionRequest$SourceVersion' => '<p>Current version of the license.</p>', 'CreateLicenseVersionResponse$Version' => '<p>New version of the license.</p>', 'CreateTokenResponse$TokenId' => '<p>Token ID.</p>', 'DeleteGrantRequest$Version' => '<p>Current version of the grant.</p>', 'DeleteGrantResponse$Version' => '<p>Grant version.</p>', 'DeleteLicenseConfigurationRequest$LicenseConfigurationArn' => '<p>ID of the license configuration.</p>', 'DeleteLicenseManagerReportGeneratorRequest$LicenseManagerReportGeneratorArn' => '<p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>', 'DeleteLicenseRequest$SourceVersion' => '<p>Current version of the license.</p>', 'DeleteTokenRequest$TokenId' => '<p>Token ID.</p>', 'Entitlement$Name' => '<p>Entitlement name.</p>', 'Entitlement$Value' => '<p>Entitlement resource. Use only if the unit is None.</p>', 'EntitlementData$Name' => '<p>Entitlement data name.</p>', 'EntitlementData$Value' => '<p>Entitlement data value.</p>', 'EntitlementUsage$Name' => '<p>Entitlement usage name.</p>', 'EntitlementUsage$ConsumedValue' => '<p>Resource usage consumed.</p>', 'EntitlementUsage$MaxCount' => '<p>Maximum entitlement usage count.</p>', 'ExtendLicenseConsumptionRequest$LicenseConsumptionToken' => '<p>License consumption token.</p>', 'ExtendLicenseConsumptionResponse$LicenseConsumptionToken' => '<p>License consumption token.</p>', 'FailedDependencyException$ErrorCode' => NULL, 'GetGrantRequest$Version' => '<p>Grant version.</p>', 'GetLicenseConfigurationRequest$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'GetLicenseConfigurationResponse$LicenseConfigurationId' => '<p>Unique ID for the license configuration.</p>', 'GetLicenseConfigurationResponse$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'GetLicenseConfigurationResponse$Name' => '<p>Name of the license configuration.</p>', 'GetLicenseConfigurationResponse$Description' => '<p>Description of the license configuration.</p>', 'GetLicenseConfigurationResponse$Status' => '<p>License configuration status.</p>', 'GetLicenseConfigurationResponse$OwnerAccountId' => '<p>Account ID of the owner of the license configuration.</p>', 'GetLicenseConversionTaskResponse$ResourceArn' => '<p>Amazon Resource Names (ARN) of the resources the license conversion task is associated with.</p>', 'GetLicenseConversionTaskResponse$StatusMessage' => '<p>The status message for the conversion task.</p>', 'GetLicenseManagerReportGeneratorRequest$LicenseManagerReportGeneratorArn' => '<p>Amazon Resource Name (ARN) of the report generator.</p>', 'GetLicenseRequest$Version' => '<p>License version.</p>', 'GetServiceSettingsResponse$S3BucketArn' => '<p>Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.</p>', 'GetServiceSettingsResponse$SnsTopicArn' => '<p>SNS topic configured to receive notifications from License Manager.</p>', 'GetServiceSettingsResponse$LicenseManagerResourceShareArn' => '<p>Amazon Resource Name (ARN) of the resource share. The License Manager management account provides member accounts with access to this share.</p>', 'Grant$GrantName' => '<p>Grant name.</p>', 'Grant$HomeRegion' => '<p>Home Region of the grant.</p>', 'Grant$Version' => '<p>Grant version.</p>', 'GrantedLicense$LicenseName' => '<p>License name.</p>', 'GrantedLicense$ProductName' => '<p>Product name.</p>', 'GrantedLicense$ProductSKU' => '<p>Product SKU.</p>', 'GrantedLicense$HomeRegion' => '<p>Home Region of the granted license.</p>', 'GrantedLicense$Beneficiary' => '<p>Granted license beneficiary.</p>', 'GrantedLicense$Version' => '<p>Version of the granted license.</p>', 'InventoryFilter$Name' => '<p>Name of the filter.</p>', 'InventoryFilter$Value' => '<p>Value of the filter.</p>', 'Issuer$Name' => '<p>Issuer name.</p>', 'Issuer$SignKey' => '<p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.</p>', 'IssuerDetails$Name' => '<p>Issuer name.</p>', 'IssuerDetails$SignKey' => '<p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.</p>', 'IssuerDetails$KeyFingerprint' => '<p>Issuer key fingerprint.</p>', 'License$LicenseName' => '<p>License name.</p>', 'License$ProductName' => '<p>Product name.</p>', 'License$ProductSKU' => '<p>Product SKU.</p>', 'License$HomeRegion' => '<p>Home Region of the license.</p>', 'License$Beneficiary' => '<p>License beneficiary.</p>', 'License$Version' => '<p>License version.</p>', 'LicenseConfiguration$LicenseConfigurationId' => '<p>Unique ID of the license configuration.</p>', 'LicenseConfiguration$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'LicenseConfiguration$Name' => '<p>Name of the license configuration.</p>', 'LicenseConfiguration$Description' => '<p>Description of the license configuration.</p>', 'LicenseConfiguration$Status' => '<p>Status of the license configuration.</p>', 'LicenseConfiguration$OwnerAccountId' => '<p>Account ID of the license configuration\'s owner.</p>', 'LicenseConfigurationAssociation$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource.</p>', 'LicenseConfigurationAssociation$ResourceOwnerId' => '<p>ID of the Amazon Web Services account that owns the resource consuming licenses.</p>', 'LicenseConfigurationAssociation$AmiAssociationScope' => '<p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>', 'LicenseConfigurationUsage$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource.</p>', 'LicenseConfigurationUsage$ResourceStatus' => '<p>Status of the resource.</p>', 'LicenseConfigurationUsage$ResourceOwnerId' => '<p>ID of the account that owns the resource.</p>', 'LicenseConversionTask$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource associated with the license type conversion task.</p>', 'LicenseConversionTask$StatusMessage' => '<p>The status message for the conversion task.</p>', 'LicenseOperationFailure$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource.</p>', 'LicenseOperationFailure$ErrorMessage' => '<p>Error message.</p>', 'LicenseOperationFailure$OperationName' => '<p>Name of the operation.</p>', 'LicenseOperationFailure$ResourceOwnerId' => '<p>ID of the Amazon Web Services account that owns the resource.</p>', 'LicenseOperationFailure$OperationRequestedBy' => '<p>The requester is "License Manager Automated Discovery".</p>', 'LicenseSpecification$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'LicenseSpecification$AmiAssociationScope' => '<p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>', 'ListAssociationsForLicenseConfigurationRequest$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of a license configuration.</p>', 'ListAssociationsForLicenseConfigurationRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListAssociationsForLicenseConfigurationResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListDistributedGrantsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListDistributedGrantsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListFailuresForLicenseConfigurationOperationsRequest$LicenseConfigurationArn' => '<p>Amazon Resource Name of the license configuration.</p>', 'ListFailuresForLicenseConfigurationOperationsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListFailuresForLicenseConfigurationOperationsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseConfigurationsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseConfigurationsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseConversionTasksRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseConversionTasksResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseManagerReportGeneratorsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseManagerReportGeneratorsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseSpecificationsForResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>', 'ListLicenseSpecificationsForResourceRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseSpecificationsForResourceResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseVersionsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicenseVersionsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicensesRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListLicensesResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedGrantsForOrganizationRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedGrantsForOrganizationResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedGrantsRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedGrantsResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedLicensesForOrganizationRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedLicensesForOrganizationResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedLicensesRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListReceivedLicensesResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListResourceInventoryRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListResourceInventoryResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'ListTokensRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListTokensResponse$NextToken' => '<p>Token for the next set of results.</p>', 'ListUsageForLicenseConfigurationRequest$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'ListUsageForLicenseConfigurationRequest$NextToken' => '<p>Token for the next set of results.</p>', 'ListUsageForLicenseConfigurationResponse$NextToken' => '<p>Token for the next set of results.</p>', 'MaxSize3StringList$member' => NULL, 'Metadata$Name' => '<p>The key name.</p>', 'Metadata$Value' => '<p>The value.</p>', 'ProductInformation$ResourceType' => '<p>Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.</p>', 'ProductInformationFilter$ProductInformationFilterName' => '<p>Filter name.</p>', 'ProductInformationFilter$ProductInformationFilterComparator' => '<p>Logical operator.</p>', 'RejectGrantResponse$Version' => '<p>Grant version.</p>', 'ReportGenerator$ReportGeneratorName' => '<p>Name of the report generator.</p>', 'ReportGenerator$LicenseManagerReportGeneratorArn' => '<p>Amazon Resource Name (ARN) of the report generator.</p>', 'ReportGenerator$LastRunStatus' => '<p>Status of the last report generation attempt.</p>', 'ReportGenerator$LastRunFailureReason' => '<p>Failure message for the last report generation attempt.</p>', 'ReportGenerator$LastReportGenerationTime' => '<p>Time the last report was generated at.</p>', 'ReportGenerator$ReportCreatorAccount' => '<p>The Amazon Web Services account ID used to create the report generator.</p>', 'ReportGenerator$Description' => '<p>Description of the report generator.</p>', 'ReportGenerator$CreateTime' => '<p>Time the report was created.</p>', 'ResourceInventory$ResourceId' => '<p>ID of the resource.</p>', 'ResourceInventory$ResourceArn' => '<p>Amazon Resource Name (ARN) of the resource.</p>', 'ResourceInventory$Platform' => '<p>Platform of the resource.</p>', 'ResourceInventory$PlatformVersion' => '<p>Platform version of the resource in the inventory.</p>', 'ResourceInventory$ResourceOwningAccountId' => '<p>ID of the account that owns the resource.</p>', 'S3Location$bucket' => '<p>Name of the S3 bucket reports are published to.</p>', 'S3Location$keyPrefix' => '<p>Prefix of the S3 bucket reports are published to.</p>', 'StringList$member' => NULL, 'Tag$Key' => '<p>Tag key.</p>', 'Tag$Value' => '<p>Tag value.</p>', 'TagKeyList$member' => NULL, 'TagResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'TokenData$TokenId' => '<p>Token ID.</p>', 'TokenData$TokenType' => '<p>Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.</p>', 'TokenData$LicenseArn' => '<p>Amazon Resource Name (ARN) of the license.</p>', 'TokenData$Status' => '<p>Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'UpdateLicenseConfigurationRequest$LicenseConfigurationArn' => '<p>Amazon Resource Name (ARN) of the license configuration.</p>', 'UpdateLicenseConfigurationRequest$Name' => '<p>New name of the license configuration.</p>', 'UpdateLicenseConfigurationRequest$Description' => '<p>New description of the license configuration.</p>', 'UpdateLicenseManagerReportGeneratorRequest$LicenseManagerReportGeneratorArn' => '<p>Amazon Resource Name (ARN) of the report generator to update.</p>', 'UpdateLicenseManagerReportGeneratorRequest$Description' => '<p>Description of the report generator.</p>', 'UpdateLicenseSpecificationsForResourceRequest$ResourceArn' => '<p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>', 'UpdateServiceSettingsRequest$S3BucketArn' => '<p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>', 'UpdateServiceSettingsRequest$SnsTopicArn' => '<p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseConfigurationRequest$LicenseRules' => '<p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p> <ul> <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li> <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li> <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li> <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li> </ul> <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>', 'GetLicenseConfigurationResponse$LicenseRules' => '<p>License rules.</p>', 'LicenseConfiguration$LicenseRules' => '<p>License rules.</p>', 'ListLicenseConfigurationsRequest$LicenseConfigurationArns' => '<p>Amazon Resource Names (ARN) of the license configurations.</p>', 'ListTokensRequest$TokenIds' => '<p>Token IDs.</p>', 'ProductInformationFilter$ProductInformationFilterValue' => '<p>Filter value.</p>', 'UpdateLicenseConfigurationRequest$LicenseRules' => '<p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>', ], ], 'Tag' => [ 'base' => '<p>Details about a tag for a license configuration.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Keys identifying the tags to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateLicenseConfigurationRequest$Tags' => '<p>Tags to add to the license configuration.</p>', 'CreateLicenseManagerReportGeneratorRequest$Tags' => '<p>Tags to add to the report generator.</p>', 'GetLicenseConfigurationResponse$Tags' => '<p>Tags for the license configuration.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Information about the tags.</p>', 'ReportGenerator$Tags' => '<p>Tags associated with the report generator.</p>', 'TagResourceRequest$Tags' => '<p>One or more tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TokenData' => [ 'base' => '<p>Describes a token.</p>', 'refs' => [ 'TokenList$member' => NULL, ], ], 'TokenList' => [ 'base' => NULL, 'refs' => [ 'ListTokensResponse$Tokens' => '<p>Received token details.</p>', ], ], 'TokenString' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$Token' => '<p>Refresh token, encoded as a JWT token.</p>', 'GetAccessTokenRequest$Token' => '<p>Refresh token, encoded as a JWT token.</p>', 'GetAccessTokenResponse$AccessToken' => '<p>Temporary access token.</p>', ], ], 'TokenType' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$TokenType' => '<p>Token type.</p>', ], ], 'UnsupportedDigitalSignatureMethodException' => [ 'base' => '<p>The digital signature method is unsupported. Try your request again.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseManagerReportGeneratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseManagerReportGeneratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseSpecificationsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLicenseSpecificationsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UsageOperation' => [ 'base' => NULL, 'refs' => [ 'LicenseConversionContext$UsageOperation' => '<p>The Usage operation value that corresponds to the license type you are converting your resource from. For more information about which platforms correspond to which usage operation values see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data: usage operation by platform </a> </p>', ], ], 'ValidationException' => [ 'base' => '<p>The provided input is not valid. Try your request again.</p>', 'refs' => [], ], ],];
