<?php
// This file was auto-generated from sdk-root/src/data/lookoutequipment/2020-12-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Lookout for Equipment is a machine learning service that uses advanced analytics to identify anomalies in machines from sensor data for use in predictive maintenance. </p>', 'operations' => [ 'CreateDataset' => '<p>Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata describing where the data is and what the data actually looks like. For example, it contains the location of the data source, the data schema, and other information. A dataset also contains any tags associated with the ingested data. </p>', 'CreateInferenceScheduler' => '<p> Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an S3 bucket location for the output data. </p>', 'CreateLabel' => '<p> Creates a label for an event. </p>', 'CreateLabelGroup' => '<p> Creates a group of labels. </p>', 'CreateModel' => '<p>Creates a machine learning model for data inference. </p> <p>A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in machine behavior that have already occurred.</p> <p>Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to evaluate the model\'s accuracy. </p>', 'CreateRetrainingScheduler' => '<p>Creates a retraining scheduler on the specified model. </p>', 'DeleteDataset' => '<p> Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data ingestion job is currently using the dataset, and if there isn\'t, the dataset, its metadata, and any associated data stored in S3 will be deleted. This does not affect any models that used this dataset for training and evaluation, but does prevent it from being used in the future. </p>', 'DeleteInferenceScheduler' => '<p>Deletes an inference scheduler that has been set up. Prior inference results will not be deleted.</p>', 'DeleteLabel' => '<p> Deletes a label. </p>', 'DeleteLabelGroup' => '<p> Deletes a group of labels. </p>', 'DeleteModel' => '<p>Deletes a machine learning model currently available for Amazon Lookout for Equipment. This will prevent it from being used with an inference scheduler, even one that is already set up. </p>', 'DeleteResourcePolicy' => '<p>Deletes the resource policy attached to the resource.</p>', 'DeleteRetrainingScheduler' => '<p>Deletes a retraining scheduler from a model. The retraining scheduler must be in the <code>STOPPED</code> status. </p>', 'DescribeDataIngestionJob' => '<p>Provides information on a specific data ingestion job such as creation time, dataset ARN, and status.</p>', 'DescribeDataset' => '<p>Provides a JSON description of the data in each time series dataset, including names, column names, and data types.</p>', 'DescribeInferenceScheduler' => '<p> Specifies information about the inference scheduler being used, including name, model, status, and associated metadata </p>', 'DescribeLabel' => '<p> Returns the name of the label. </p>', 'DescribeLabelGroup' => '<p> Returns information about the label group. </p>', 'DescribeModel' => '<p>Provides a JSON containing the overall information about a specific machine learning model, including model name and ARN, dataset, training and evaluation information, status, and so on. </p>', 'DescribeModelVersion' => '<p>Retrieves information about a specific machine learning model version.</p>', 'DescribeResourcePolicy' => '<p>Provides the details of a resource policy attached to a resource.</p>', 'DescribeRetrainingScheduler' => '<p>Provides a description of the retraining scheduler, including information such as the model name and retraining parameters. </p>', 'ImportDataset' => '<p>Imports a dataset.</p>', 'ImportModelVersion' => '<p>Imports a model that has been trained successfully.</p>', 'ListDataIngestionJobs' => '<p>Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on. </p>', 'ListDatasets' => '<p>Lists all datasets currently available in your account, filtering on the dataset name. </p>', 'ListInferenceEvents' => '<p> Lists all inference events that have been found for the specified inference scheduler. </p>', 'ListInferenceExecutions' => '<p> Lists all inference executions that have been performed by the specified inference scheduler. </p>', 'ListInferenceSchedulers' => '<p>Retrieves a list of all inference schedulers currently available for your account. </p>', 'ListLabelGroups' => '<p> Returns a list of the label groups. </p>', 'ListLabels' => '<p> Provides a list of labels. </p>', 'ListModelVersions' => '<p>Generates a list of all model versions for a given model, including the model version, model version ARN, and status. To list a subset of versions, use the <code>MaxModelVersion</code> and <code>MinModelVersion</code> fields.</p>', 'ListModels' => '<p>Generates a list of all models in the account, including model name and ARN, dataset, and status. </p>', 'ListRetrainingSchedulers' => '<p>Lists all retraining schedulers in your account, filtering by model name prefix and status. </p>', 'ListSensorStatistics' => '<p> Lists statistics about the data collected for each of the sensors that have been successfully ingested in the particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job. </p>', 'ListTagsForResource' => '<p>Lists all the tags for a specified resource, including key and value. </p>', 'PutResourcePolicy' => '<p>Creates a resource control policy for a given resource.</p>', 'StartDataIngestionJob' => '<p>Starts a data ingestion job. Amazon Lookout for Equipment returns the job status. </p>', 'StartInferenceScheduler' => '<p>Starts an inference scheduler. </p>', 'StartRetrainingScheduler' => '<p>Starts a retraining scheduler. </p>', 'StopInferenceScheduler' => '<p>Stops an inference scheduler. </p>', 'StopRetrainingScheduler' => '<p>Stops a retraining scheduler. </p>', 'TagResource' => '<p>Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to 50 tags can be associated with each resource. </p>', 'UntagResource' => '<p>Removes a specific tag from a given resource. The tag is specified by its key. </p>', 'UpdateActiveModelVersion' => '<p>Sets the active model version for a given machine learning model.</p>', 'UpdateInferenceScheduler' => '<p>Updates an inference scheduler. </p>', 'UpdateLabelGroup' => '<p> Updates the label group. </p>', 'UpdateModel' => '<p>Updates a model in the account.</p>', 'UpdateRetrainingScheduler' => '<p>Updates a retraining scheduler. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request could not be completed because you do not have access to the resource. </p>', 'refs' => [], ], 'AmazonResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource (such as the dataset or model) that is the focus of the <code>ListTagsForResource</code> operation. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the specific resource to which the tag should be associated. </p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which the tag is currently associated. </p>', ], ], 'AutoPromotionResult' => [ 'base' => NULL, 'refs' => [ 'DescribeModelVersionResponse$AutoPromotionResult' => '<p>Indicates whether the model version was promoted to be the active version after retraining or if there was an error with or cancellation of the retraining. </p>', ], ], 'AutoPromotionResultReason' => [ 'base' => NULL, 'refs' => [ 'DescribeModelVersionResponse$AutoPromotionResultReason' => '<p>Indicates the reason for the <code>AutoPromotionResult</code>. For example, a model might not be promoted if its performance was worse than the active version, if there was an error during training, or if the retraining scheduler was using <code>MANUAL</code> promote mode. The model will be promoted in <code>MANAGED</code> promote mode if the performance is better than the previous model. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'SensorStatisticsSummary$DataExists' => '<p> Parameter that indicates whether data exists for the sensor that the statistics belong to. </p>', ], ], 'BoundedLengthString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'DescribeDataIngestionJobResponse$FailedReason' => '<p>Specifies the reason for failure when a data ingestion job has failed. </p>', 'DescribeDataIngestionJobResponse$StatusDetail' => '<p> Provides details about status of the ingestion job that is currently in progress. </p>', 'DescribeModelResponse$FailedReason' => '<p>If the training of the machine learning model failed, this indicates the reason for that failure. </p>', 'DescribeModelResponse$LatestScheduledRetrainingFailedReason' => '<p>If the model version was generated by retraining and the training failed, this indicates the reason for that failure. </p>', 'DescribeModelVersionResponse$FailedReason' => '<p>The failure message if the training of the model version failed.</p>', 'InferenceExecutionSummary$FailedReason' => '<p> Specifies the reason for failure when an inference execution has failed. </p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'CategoricalValues' => [ 'base' => '<p> Entity that comprises information on categorical values in data. </p>', 'refs' => [ 'SensorStatisticsSummary$CategoricalValues' => '<p> Parameter that describes potential risk about whether data associated with the sensor is categorical. </p>', ], ], 'Comments' => [ 'base' => NULL, 'refs' => [ 'CreateLabelRequest$Notes' => '<p> Metadata providing additional information about the label. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'DescribeLabelResponse$Notes' => '<p>Metadata providing additional information about the label.</p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', ], ], 'ComponentName' => [ 'base' => NULL, 'refs' => [ 'SensorStatisticsSummary$ComponentName' => '<p> Name of the component to which the particular sensor belongs for which the statistics belong to. </p>', ], ], 'ComponentTimestampDelimiter' => [ 'base' => NULL, 'refs' => [ 'InferenceInputNameConfiguration$ComponentTimestampDelimiter' => '<p>Indicates the delimiter character used between items in the data. </p>', ], ], 'ConflictException' => [ 'base' => '<p> The request could not be completed due to a conflict with the current state of the target resource. </p>', 'refs' => [], ], 'CountPercent' => [ 'base' => '<p> Entity that comprises information of count and percentage. </p>', 'refs' => [ 'SensorStatisticsSummary$MissingValues' => '<p> Parameter that describes the total number of, and percentage of, values that are missing for the sensor that the statistics belong to. </p>', 'SensorStatisticsSummary$InvalidValues' => '<p> Parameter that describes the total number of, and percentage of, values that are invalid for the sensor that the statistics belong to. </p>', 'SensorStatisticsSummary$InvalidDateEntries' => '<p> Parameter that describes the total number of invalid date entries associated with the sensor that the statistics belong to. </p>', 'SensorStatisticsSummary$DuplicateTimestamps' => '<p> Parameter that describes the total number of duplicate timestamp records associated with the sensor that the statistics belong to. </p>', ], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRetrainingSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataDelayOffsetInMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$DataDelayOffsetInMinutes' => '<p>The interval (in minutes) of planned delay at the start of each inference segment. For example, if inference is set to run every ten minutes, the delay is set to five minutes and the time is 09:08. The inference scheduler will wake up at the configured interval (which, without a delay configured, would be 09:10) plus the additional five minute delay time (so 09:15) to check your Amazon S3 bucket. The delay provides a buffer for you to upload data at the same frequency, so that you don\'t have to stop and restart the scheduler when uploading new data.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html">Understanding the inference process</a>.</p>', 'DescribeInferenceSchedulerResponse$DataDelayOffsetInMinutes' => '<p> A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if you select an offset delay time of five minutes, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data.</p>', 'InferenceSchedulerSummary$DataDelayOffsetInMinutes' => '<p>A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data. </p>', 'UpdateInferenceSchedulerRequest$DataDelayOffsetInMinutes' => '<p> A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if you select an offset delay time of five minutes, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data.</p>', ], ], 'DataIngestionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsResponse$DataIngestionJobSummaries' => '<p>Specifies information about the specific data ingestion job, including dataset name and status. </p>', ], ], 'DataIngestionJobSummary' => [ 'base' => '<p>Provides information about a specified data ingestion job, including dataset information, data ingestion configuration, and status. </p>', 'refs' => [ 'DataIngestionJobSummaries$member' => NULL, ], ], 'DataPreProcessingConfiguration' => [ 'base' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', 'refs' => [ 'CreateModelRequest$DataPreProcessingConfiguration' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', 'DescribeModelResponse$DataPreProcessingConfiguration' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', 'DescribeModelVersionResponse$DataPreProcessingConfiguration' => NULL, ], ], 'DataQualitySummary' => [ 'base' => '<p> DataQualitySummary gives aggregated statistics over all the sensors about a completed ingestion job. It primarily gives more information about statistics over different incorrect data like MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, DuplicateTimeStamps. </p>', 'refs' => [ 'DescribeDataIngestionJobResponse$DataQualitySummary' => '<p> Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps. </p>', 'DescribeDatasetResponse$DataQualitySummary' => '<p> Gives statistics associated with the given dataset for the latest successful associated ingestion job id. These statistics primarily relate to quantifying incorrect data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps. </p>', ], ], 'DataSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'DescribeDataIngestionJobResponse$IngestedDataSize' => '<p> Indicates the size of the ingested dataset. </p>', 'DescribeModelVersionResponse$ImportedDataSizeInBytes' => '<p>The size in bytes of the imported data. This field appears if the model version was imported.</p>', ], ], 'DataUploadFrequency' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$DataUploadFrequency' => '<p> How often data is uploaded to the source Amazon S3 bucket for the input data. The value chosen is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment runs inference on your data.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html">Understanding the inference process</a>.</p>', 'DescribeInferenceSchedulerResponse$DataUploadFrequency' => '<p>Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', 'InferenceSchedulerSummary$DataUploadFrequency' => '<p>How often data is uploaded to the source S3 bucket for the input data. This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', 'UpdateInferenceSchedulerRequest$DataUploadFrequency' => '<p>How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', ], ], 'DatasetArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$DatasetArn' => '<p> The Amazon Resource Name (ARN) of the dataset being created. </p>', 'DataIngestionJobSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset used in the data ingestion job. </p>', 'DatasetSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the specified dataset. </p>', 'DescribeDataIngestionJobResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job. </p>', 'DescribeDataIngestionJobResponse$SourceDatasetArn' => '<p>The Amazon Resource Name (ARN) of the source dataset from which the data used for the data ingestion job was imported from.</p>', 'DescribeDatasetResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset being described. </p>', 'DescribeDatasetResponse$SourceDatasetArn' => '<p>The Amazon Resource Name (ARN) of the source dataset from which the current data being described was imported from.</p>', 'DescribeModelResponse$DatasetArn' => '<p>The Amazon Resouce Name (ARN) of the dataset used to create the machine learning model being described. </p>', 'DescribeModelVersionResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset used to train the model version.</p>', 'ImportDatasetRequest$SourceDatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to import.</p>', 'ImportDatasetResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that was imported.</p>', 'ModelSummary$DatasetArn' => '<p> The Amazon Resource Name (ARN) of the dataset used to create the model. </p>', ], ], 'DatasetIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$DatasetName' => '<p>The name of the dataset for the machine learning model being created. </p>', 'DeleteDatasetRequest$DatasetName' => '<p>The name of the dataset to be deleted. </p>', 'DescribeDatasetRequest$DatasetName' => '<p>The name of the dataset to be described. </p>', 'ImportModelVersionRequest$DatasetName' => '<p>The name of the dataset for the machine learning model being imported. </p>', 'StartDataIngestionJobRequest$DatasetName' => '<p>The name of the dataset being used by the data ingestion job. </p>', ], ], 'DatasetName' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetName' => '<p>The name of the dataset being created. </p>', 'CreateDatasetResponse$DatasetName' => '<p>The name of the dataset being created. </p>', 'DataIngestionJobSummary$DatasetName' => '<p>The name of the dataset used for the data ingestion job. </p>', 'DatasetSummary$DatasetName' => '<p>The name of the dataset. </p>', 'DescribeDatasetResponse$DatasetName' => '<p>The name of the dataset being described. </p>', 'DescribeModelResponse$DatasetName' => '<p>The name of the dataset being used by the machine learning being described. </p>', 'DescribeModelVersionResponse$DatasetName' => '<p>The name of the dataset used to train the model version.</p>', 'ImportDatasetRequest$DatasetName' => '<p>The name of the machine learning dataset to be created. If the dataset already exists, Amazon Lookout for Equipment overwrites the existing dataset. If you don\'t specify this field, it is filled with the name of the source dataset.</p>', 'ImportDatasetResponse$DatasetName' => '<p>The name of the created machine learning dataset.</p>', 'ListDataIngestionJobsRequest$DatasetName' => '<p>The name of the dataset being used for the data ingestion job. </p>', 'ListDatasetsRequest$DatasetNameBeginsWith' => '<p>The beginning of the name of the datasets to be listed. </p>', 'ListModelsRequest$DatasetNameBeginsWith' => '<p>The beginning of the name of the dataset of the machine learning models to be listed. </p>', 'ListSensorStatisticsRequest$DatasetName' => '<p> The name of the dataset associated with the list of Sensor Statistics. </p>', 'ModelSummary$DatasetName' => '<p>The name of the dataset being used for the machine learning model. </p>', ], ], 'DatasetSchema' => [ 'base' => '<p>Provides information about the data schema used with the given dataset. </p>', 'refs' => [ 'CreateDatasetRequest$DatasetSchema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', 'CreateModelRequest$DatasetSchema' => '<p>The data schema for the machine learning model being created. </p>', ], ], 'DatasetStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$Status' => '<p>Indicates the status of the <code>CreateDataset</code> operation. </p>', 'DatasetSummary$Status' => '<p>Indicates the status of the dataset. </p>', 'DescribeDatasetResponse$Status' => '<p>Indicates the status of the dataset. </p>', 'ImportDatasetResponse$Status' => '<p>The status of the <code>ImportDataset</code> operation.</p>', ], ], 'DatasetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$DatasetSummaries' => '<p>Provides information about the specified dataset, including creation time, dataset ARN, and status. </p>', ], ], 'DatasetSummary' => [ 'base' => '<p>Contains information about the specific data set, including name, ARN, and status. </p>', 'refs' => [ 'DatasetSummaries$member' => NULL, ], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLabelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRetrainingSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DuplicateTimestamps' => [ 'base' => '<p> Entity that comprises information abount duplicate timestamps in the dataset. </p>', 'refs' => [ 'DataQualitySummary$DuplicateTimestamps' => '<p> Parameter that gives information about duplicate timestamps in the input data. </p>', ], ], 'Equipment' => [ 'base' => NULL, 'refs' => [ 'CreateLabelRequest$Equipment' => '<p> Indicates that a label pertains to a particular piece of equipment. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'DescribeLabelResponse$Equipment' => '<p> Indicates that a label pertains to a particular piece of equipment. </p>', 'LabelSummary$Equipment' => '<p> Indicates that a label pertains to a particular piece of equipment. </p>', 'ListLabelsRequest$Equipment' => '<p> Lists the labels that pertain to a particular piece of equipment. </p>', ], ], 'EventDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'InferenceEventSummary$EventDurationInSeconds' => '<p> Indicates the size of an inference event in seconds. </p>', ], ], 'FaultCode' => [ 'base' => NULL, 'refs' => [ 'CreateLabelRequest$FaultCode' => '<p> Provides additional information about the label. The fault code must be defined in the FaultCodes attribute of the label group.</p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'DescribeLabelResponse$FaultCode' => '<p> Indicates the type of anomaly associated with the label. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'FaultCodes$member' => NULL, 'LabelSummary$FaultCode' => '<p> Indicates the type of anomaly associated with the label. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'ListLabelsRequest$FaultCode' => '<p> Returns labels with a particular fault code. </p>', ], ], 'FaultCodes' => [ 'base' => NULL, 'refs' => [ 'CreateLabelGroupRequest$FaultCodes' => '<p> The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used with this label group.</p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'DescribeLabelGroupResponse$FaultCodes' => '<p> Codes indicating the type of anomaly associated with the labels in the lagbel group. </p>', 'UpdateLabelGroupRequest$FaultCodes' => '<p> Updates the code indicating the type of anomaly associated with the label. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', ], ], 'FileNameTimestampFormat' => [ 'base' => NULL, 'refs' => [ 'InferenceInputNameConfiguration$TimestampFormat' => '<p>The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-). </p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'CountPercent$Percentage' => '<p> Indicates the percentage of occurances of the given statistic. </p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference. </p>', 'CreateModelRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the machine learning model. </p>', 'DescribeDataIngestionJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being ingested. </p>', 'DescribeDatasetResponse$RoleArn' => '<p> The Amazon Resource Name (ARN) of the IAM role that you are using for this the data ingestion job. </p>', 'DescribeInferenceSchedulerResponse$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler being described. </p>', 'DescribeModelResponse$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the machine learning model being described. </p>', 'DescribeModelVersionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that was used to train the model version.</p>', 'ImportModelVersionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the machine learning model. </p>', 'StartDataIngestionJobRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion job. </p>', 'UpdateInferenceSchedulerRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler. </p>', 'UpdateModelRequest$RoleArn' => '<p>The ARN of the model to update.</p>', ], ], 'IdempotenceToken' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'CreateInferenceSchedulerRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'CreateLabelGroupRequest$ClientToken' => '<p> A unique identifier for the request to create a label group. If you do not set the client request token, Lookout for Equipment generates one. </p>', 'CreateLabelRequest$ClientToken' => '<p> A unique identifier for the request to create a label. If you do not set the client request token, Lookout for Equipment generates one. </p>', 'CreateModelRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'CreateRetrainingSchedulerRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'ImportDatasetRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'ImportModelVersionRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'PutResourcePolicyRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'StartDataIngestionJobRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', ], ], 'ImportDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportModelVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'InferenceDataImportStrategy' => [ 'base' => NULL, 'refs' => [ 'ImportModelVersionRequest$InferenceDataImportStrategy' => '<p>Indicates how to import the accumulated inference data when a model version is imported. The possible values are as follows:</p> <ul> <li> <p>NO_IMPORT – Don\'t import the data.</p> </li> <li> <p>ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target model.</p> </li> <li> <p>OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.</p> </li> </ul>', ], ], 'InferenceEventSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceEventsResponse$InferenceEventSummaries' => '<p>Provides an array of information about the individual inference events returned from the <code>ListInferenceEvents</code> operation, including scheduler used, event start time, event end time, diagnostics, and so on. </p>', ], ], 'InferenceEventSummary' => [ 'base' => '<p>Contains information about the specific inference event, including start and end time, diagnostics information, event duration and so on.</p>', 'refs' => [ 'InferenceEventSummaries$member' => NULL, ], ], 'InferenceExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'InferenceExecutionSummary$Status' => '<p>Indicates the status of the inference execution. </p>', 'ListInferenceExecutionsRequest$Status' => '<p>The status of the inference execution. </p>', ], ], 'InferenceExecutionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceExecutionsResponse$InferenceExecutionSummaries' => '<p>Provides an array of information about the individual inference executions returned from the <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data configuration, and so on. </p> <note> <p>If you don\'t supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name of an inference scheduler that doesn\'t exist, <code>ListInferenceExecutions</code> returns an empty array in <code>InferenceExecutionSummaries</code>.</p> </note>', ], ], 'InferenceExecutionSummary' => [ 'base' => '<p>Contains information about the specific inference execution, including input and output data configuration, inference scheduling information, status, and so on. </p>', 'refs' => [ 'InferenceExecutionSummaries$member' => NULL, ], ], 'InferenceInputConfiguration' => [ 'base' => '<p>Specifies configuration information for the input data for the inference, including Amazon S3 location of input data.. </p>', 'refs' => [ 'CreateInferenceSchedulerRequest$DataInputConfiguration' => '<p>Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'DescribeInferenceSchedulerResponse$DataInputConfiguration' => '<p> Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'InferenceExecutionSummary$DataInputConfiguration' => '<p> Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'UpdateInferenceSchedulerRequest$DataInputConfiguration' => '<p> Specifies information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', ], ], 'InferenceInputNameConfiguration' => [ 'base' => '<p>Specifies configuration information for the input data for the inference, including timestamp format and delimiter. </p>', 'refs' => [ 'InferenceInputConfiguration$InferenceInputNameConfiguration' => '<p>Specifies configuration information for the input data for the inference, including timestamp format and delimiter. </p>', ], ], 'InferenceOutputConfiguration' => [ 'base' => '<p> Specifies configuration information for the output results from for the inference, including KMS key ID and output S3 location. </p>', 'refs' => [ 'CreateInferenceSchedulerRequest$DataOutputConfiguration' => '<p>Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output. </p>', 'DescribeInferenceSchedulerResponse$DataOutputConfiguration' => '<p> Specifies information for the output results for the inference scheduler, including the output S3 location. </p>', 'InferenceExecutionSummary$DataOutputConfiguration' => '<p> Specifies configuration information for the output results from for the inference execution, including the output Amazon S3 location. </p>', 'UpdateInferenceSchedulerRequest$DataOutputConfiguration' => '<p> Specifies information for the output results from the inference scheduler, including the output S3 location. </p>', ], ], 'InferenceS3InputConfiguration' => [ 'base' => '<p> Specifies configuration information for the input data for the inference, including input data S3 location. </p>', 'refs' => [ 'InferenceInputConfiguration$S3InputConfiguration' => '<p> Specifies configuration information for the input data for the inference, including Amazon S3 location of input data.</p>', ], ], 'InferenceS3OutputConfiguration' => [ 'base' => '<p> Specifies configuration information for the output results from the inference, including output S3 location. </p>', 'refs' => [ 'InferenceOutputConfiguration$S3OutputConfiguration' => '<p> Specifies configuration information for the output results from for the inference, output S3 location. </p>', ], ], 'InferenceSchedulerArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being created. </p>', 'DescribeInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being described. </p>', 'InferenceEventSummary$InferenceSchedulerArn' => '<p> The Amazon Resource Name (ARN) of the inference scheduler being used for the inference event. </p>', 'InferenceExecutionSummary$InferenceSchedulerArn' => '<p> The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution. </p>', 'InferenceSchedulerSummary$InferenceSchedulerArn' => '<p> The Amazon Resource Name (ARN) of the inference scheduler. </p>', 'StartInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being started. </p>', 'StopInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference schedule being stopped. </p>', ], ], 'InferenceSchedulerIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be deleted. </p>', 'DescribeInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler being described. </p>', 'ListInferenceEventsRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler for the inference events listed. </p>', 'ListInferenceExecutionsRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler for the inference execution listed. </p>', 'ListInferenceSchedulersRequest$InferenceSchedulerNameBeginsWith' => '<p>The beginning of the name of the inference schedulers to be listed. </p>', 'StartInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be started. </p>', 'StopInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be stopped. </p>', 'UpdateInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be updated. </p>', ], ], 'InferenceSchedulerName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler being created. </p>', 'CreateInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of inference scheduler being created. </p>', 'DescribeInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being described. </p>', 'InferenceEventSummary$InferenceSchedulerName' => '<p>The name of the inference scheduler being used for the inference events. </p>', 'InferenceExecutionSummary$InferenceSchedulerName' => '<p>The name of the inference scheduler being used for the inference execution. </p>', 'InferenceSchedulerSummary$InferenceSchedulerName' => '<p>The name of the inference scheduler. </p>', 'StartInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being started. </p>', 'StopInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being stopped. </p>', ], ], 'InferenceSchedulerStatus' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerResponse$Status' => '<p>Indicates the status of the <code>CreateInferenceScheduler</code> operation. </p>', 'DescribeInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'InferenceSchedulerSummary$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'ListInferenceSchedulersRequest$Status' => '<p>Specifies the current status of the inference schedulers.</p>', 'StartInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'StopInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', ], ], 'InferenceSchedulerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceSchedulersResponse$InferenceSchedulerSummaries' => '<p>Provides information about the specified inference scheduler, including data upload frequency, model name and ARN, and status. </p>', ], ], 'InferenceSchedulerSummary' => [ 'base' => '<p>Contains information about the specific inference scheduler, including data delay offset, model name and ARN, status, and so on. </p>', 'refs' => [ 'InferenceSchedulerSummaries$member' => NULL, ], ], 'IngestedFilesSummary' => [ 'base' => '<p>Gives statistics about how many files have been ingested, and which files have not been ingested, for a particular ingestion job.</p>', 'refs' => [ 'DescribeDataIngestionJobResponse$IngestedFilesSummary' => NULL, 'DescribeDatasetResponse$IngestedFilesSummary' => '<p>IngestedFilesSummary associated with the given dataset for the latest successful associated ingestion job id. </p>', ], ], 'IngestionInputConfiguration' => [ 'base' => '<p> Specifies configuration information for the input data for the data ingestion job, including input data S3 location. </p>', 'refs' => [ 'DataIngestionJobSummary$IngestionInputConfiguration' => '<p> Specifies information for the input data for the data inference job, including data Amazon S3 location parameters. </p>', 'DescribeDataIngestionJobResponse$IngestionInputConfiguration' => '<p>Specifies the S3 location configuration for the data input for the data ingestion job. </p>', 'DescribeDatasetResponse$IngestionInputConfiguration' => '<p>Specifies the S3 location configuration for the data input for the data ingestion job. </p>', 'StartDataIngestionJobRequest$IngestionInputConfiguration' => '<p> Specifies information for the input data for the data ingestion job, including dataset S3 location. </p>', ], ], 'IngestionJobId' => [ 'base' => NULL, 'refs' => [ 'DataIngestionJobSummary$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', 'DescribeDataIngestionJobRequest$JobId' => '<p>The job ID of the data ingestion job. </p>', 'DescribeDataIngestionJobResponse$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', 'ImportDatasetResponse$JobId' => '<p>A unique identifier for the job of importing the dataset.</p>', 'ListSensorStatisticsRequest$IngestionJobId' => '<p> The ingestion job id associated with the list of Sensor Statistics. To get sensor statistics for a particular ingestion job id, both dataset name and ingestion job id must be submitted as inputs. </p>', 'StartDataIngestionJobResponse$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', ], ], 'IngestionJobStatus' => [ 'base' => NULL, 'refs' => [ 'DataIngestionJobSummary$Status' => '<p>Indicates the status of the data ingestion job. </p>', 'DescribeDataIngestionJobResponse$Status' => '<p>Indicates the status of the <code>DataIngestionJob</code> operation. </p>', 'ListDataIngestionJobsRequest$Status' => '<p>Indicates the status of the data ingestion job. </p>', 'StartDataIngestionJobResponse$Status' => '<p>Indicates the status of the <code>StartDataIngestionJob</code> operation. </p>', ], ], 'IngestionS3InputConfiguration' => [ 'base' => '<p> Specifies S3 configuration information for the input data for the data ingestion job. </p>', 'refs' => [ 'IngestionInputConfiguration$S3InputConfiguration' => '<p>The location information for the S3 bucket used for input data for the data ingestion. </p>', ], ], 'InlineDataSchema' => [ 'base' => NULL, 'refs' => [ 'DatasetSchema$InlineDataSchema' => '<p>The data schema used within the given dataset.</p>', 'DescribeDatasetResponse$Schema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', 'DescribeModelResponse$Schema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', 'DescribeModelVersionResponse$Schema' => '<p>The schema of the data used to train the model version.</p>', ], ], 'InsufficientSensorData' => [ 'base' => '<p> Entity that comprises aggregated information on sensors having insufficient data. </p>', 'refs' => [ 'DataQualitySummary$InsufficientSensorData' => '<p> Parameter that gives information about insufficient data for sensors in the dataset. This includes information about those sensors that have complete data missing and those with a short date range. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CategoricalValues$NumberOfCategory' => '<p> Indicates the number of categories in the data. </p>', 'CountPercent$Count' => '<p> Indicates the count of occurences of the given statistic. </p>', 'DescribeModelResponse$LatestScheduledRetrainingAvailableDataInDays' => '<p>Indicates the number of days of data used in the most recent scheduled retraining run. </p>', 'DescribeModelVersionResponse$RetrainingAvailableDataInDays' => '<p>Indicates the number of days of data used in the most recent scheduled retraining run. </p>', 'DuplicateTimestamps$TotalNumberOfDuplicateTimestamps' => '<p> Indicates the total number of duplicate timestamps. </p>', 'IngestedFilesSummary$TotalNumberOfFiles' => '<p>Indicates the total number of files that were submitted for ingestion.</p>', 'IngestedFilesSummary$IngestedNumberOfFiles' => '<p>Indicates the number of files that were successfully ingested.</p>', 'InvalidSensorData$AffectedSensorCount' => '<p> Indicates the number of sensors that have at least some invalid values. </p>', 'InvalidSensorData$TotalNumberOfInvalidValues' => '<p> Indicates the total number of invalid values across all the sensors. </p>', 'LargeTimestampGaps$NumberOfLargeTimestampGaps' => '<p> Indicates the number of large timestamp gaps, if there are any. </p>', 'LargeTimestampGaps$MaxTimestampGapInDays' => '<p> Indicates the size of the largest timestamp gap, in days. </p>', 'MissingCompleteSensorData$AffectedSensorCount' => '<p> Indicates the number of sensors that have data missing completely. </p>', 'MissingSensorData$AffectedSensorCount' => '<p> Indicates the number of sensors that have atleast some data missing. </p>', 'MissingSensorData$TotalNumberOfMissingValues' => '<p> Indicates the total number of missing values across all the sensors. </p>', 'SensorsWithShortDateRange$AffectedSensorCount' => '<p> Indicates the number of sensors that have less than 14 days of data. </p>', 'UnsupportedTimestamps$TotalNumberOfUnsupportedTimestamps' => '<p> Indicates the total number of unsupported timestamps across the ingested data. </p>', ], ], 'InternalServerException' => [ 'base' => '<p> Processing of the request has failed because of an unknown error, exception or failure. </p>', 'refs' => [], ], 'InvalidSensorData' => [ 'base' => '<p> Entity that comprises aggregated information on sensors having insufficient data. </p>', 'refs' => [ 'DataQualitySummary$InvalidSensorData' => '<p> Parameter that gives information about data that is invalid over all the sensors in the input data. </p>', ], ], 'KeyPattern' => [ 'base' => NULL, 'refs' => [ 'IngestionS3InputConfiguration$KeyPattern' => '<p> The pattern for matching the Amazon S3 files that will be used for ingestion. If the schema was created previously without any KeyPattern, then the default KeyPattern {prefix}/{component_name}/* is used to download files from Amazon S3 according to the schema. This field is required when ingestion is being done for the first time.</p> <p>Valid Values: {prefix}/{component_name}_* | {prefix}/{component_name}/* | {prefix}/{component_name}[DELIMITER]* (Allowed delimiters : space, dot, underscore, hyphen)</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDatasetResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment. </p>', 'DescribeInferenceSchedulerResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment. </p>', 'DescribeModelResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment. </p>', 'DescribeModelVersionResponse$ServerSideKmsKeyId' => '<p>The identifier of the KMS key key used to encrypt model version data by Amazon Lookout for Equipment.</p>', ], ], 'LabelGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateLabelGroupResponse$LabelGroupArn' => '<p> The Amazon Resource Name (ARN) of the label group that you have created. </p>', 'DescribeLabelGroupResponse$LabelGroupArn' => '<p> The Amazon Resource Name (ARN) of the label group. </p>', 'DescribeLabelResponse$LabelGroupArn' => '<p> The Amazon Resource Name (ARN) of the requested label group. </p>', 'LabelGroupSummary$LabelGroupArn' => '<p> The Amazon Resource Name (ARN) of the label group. </p>', 'LabelSummary$LabelGroupArn' => '<p> The Amazon Resource Name (ARN) of the label group. </p>', ], ], 'LabelGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelGroupRequest$LabelGroupName' => '<p> Names a group of labels.</p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'CreateLabelGroupResponse$LabelGroupName' => '<p> The name of the label group that you have created. Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'CreateLabelRequest$LabelGroupName' => '<p> The name of a group of labels. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'DeleteLabelGroupRequest$LabelGroupName' => '<p> The name of the label group that you want to delete. Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'DeleteLabelRequest$LabelGroupName' => '<p> The name of the label group that contains the label that you want to delete. Data in this field will be retained for service usage. Follow best practices for the security of your data. </p>', 'DescribeLabelGroupRequest$LabelGroupName' => '<p> Returns the name of the label group. </p>', 'DescribeLabelGroupResponse$LabelGroupName' => '<p> The name of the label group. </p>', 'DescribeLabelRequest$LabelGroupName' => '<p> Returns the name of the group containing the label. </p>', 'DescribeLabelResponse$LabelGroupName' => '<p> The name of the requested label group. </p>', 'LabelGroupSummary$LabelGroupName' => '<p> The name of the label group. </p>', 'LabelSummary$LabelGroupName' => '<p> The name of the label group. </p>', 'LabelsInputConfiguration$LabelGroupName' => '<p> The name of the label group to be used for label data. </p>', 'ListLabelGroupsRequest$LabelGroupNameBeginsWith' => '<p> The beginning of the name of the label groups to be listed. </p>', 'ListLabelsRequest$LabelGroupName' => '<p> Returns the name of the label group. </p>', 'UpdateLabelGroupRequest$LabelGroupName' => '<p> The name of the label group to be updated. </p>', ], ], 'LabelGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLabelGroupsResponse$LabelGroupSummaries' => '<p> A summary of the label groups. </p>', ], ], 'LabelGroupSummary' => [ 'base' => '<p> Contains information about the label group. </p>', 'refs' => [ 'LabelGroupSummaries$member' => NULL, ], ], 'LabelId' => [ 'base' => NULL, 'refs' => [ 'CreateLabelResponse$LabelId' => '<p> The ID of the label that you have created. </p>', 'DeleteLabelRequest$LabelId' => '<p> The ID of the label that you want to delete. </p>', 'DescribeLabelRequest$LabelId' => '<p> Returns the ID of the label. </p>', 'DescribeLabelResponse$LabelId' => '<p> The ID of the requested label. </p>', 'LabelSummary$LabelId' => '<p> The ID of the label. </p>', ], ], 'LabelRating' => [ 'base' => NULL, 'refs' => [ 'CreateLabelRequest$Rating' => '<p> Indicates whether a labeled event represents an anomaly. </p>', 'DescribeLabelResponse$Rating' => '<p> Indicates whether a labeled event represents an anomaly. </p>', 'LabelSummary$Rating' => '<p> Indicates whether a labeled event represents an anomaly. </p>', ], ], 'LabelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLabelsResponse$LabelSummaries' => '<p> A summary of the items in the label group. </p> <note> <p>If you don\'t supply the <code>LabelGroupName</code> request parameter, or if you supply the name of a label group that doesn\'t exist, <code>ListLabels</code> returns an empty array in <code>LabelSummaries</code>.</p> </note>', ], ], 'LabelSummary' => [ 'base' => '<p> Information about the label. </p>', 'refs' => [ 'LabelSummaries$member' => NULL, ], ], 'LabelsInputConfiguration' => [ 'base' => '<p>Contains the configuration information for the S3 location being used to hold label data. </p>', 'refs' => [ 'CreateModelRequest$LabelsInputConfiguration' => '<p>The input configuration for the labels being used for the machine learning model that\'s being created. </p>', 'DescribeModelResponse$LabelsInputConfiguration' => '<p>Specifies configuration information about the labels input, including its S3 location. </p>', 'DescribeModelVersionResponse$LabelsInputConfiguration' => NULL, 'ImportModelVersionRequest$LabelsInputConfiguration' => NULL, 'UpdateModelRequest$LabelsInputConfiguration' => NULL, ], ], 'LabelsS3InputConfiguration' => [ 'base' => '<p>The location information (prefix and bucket name) for the s3 location being used for label data. </p>', 'refs' => [ 'LabelsInputConfiguration$S3InputConfiguration' => '<p>Contains location information for the S3 location being used for label data. </p>', ], ], 'LargeTimestampGaps' => [ 'base' => '<p> Entity that comprises information on large gaps between consecutive timestamps in data. </p>', 'refs' => [ 'SensorStatisticsSummary$LargeTimestampGaps' => '<p> Parameter that describes potential risk about whether data associated with the sensor contains one or more large gaps between consecutive timestamps. </p>', ], ], 'LatestInferenceResult' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceSchedulerResponse$LatestInferenceResult' => '<p>Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or Normal (no anomalous events found).</p>', 'InferenceSchedulerSummary$LatestInferenceResult' => '<p>Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or Normal (no anomalous events found).</p>', ], ], 'ListDataIngestionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataIngestionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceSchedulersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceSchedulersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfDiscardedFiles' => [ 'base' => NULL, 'refs' => [ 'IngestedFilesSummary$DiscardedFiles' => '<p>Indicates the number of files that were discarded. A file could be discarded because its format is invalid (for example, a jpg or pdf) or not readable.</p>', ], ], 'ListRetrainingSchedulersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRetrainingSchedulersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSensorStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSensorStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LookbackWindow' => [ 'base' => NULL, 'refs' => [ 'CreateRetrainingSchedulerRequest$LookbackWindow' => '<p>The number of past days of data that will be used for retraining.</p>', 'DescribeRetrainingSchedulerResponse$LookbackWindow' => '<p>The number of past days of data used for retraining.</p>', 'RetrainingSchedulerSummary$LookbackWindow' => '<p>The number of past days of data used for retraining.</p>', 'UpdateRetrainingSchedulerRequest$LookbackWindow' => '<p>The number of past days of data that will be used for retraining.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsRequest$MaxResults' => '<p> Specifies the maximum number of data ingestion jobs to list. </p>', 'ListDatasetsRequest$MaxResults' => '<p> Specifies the maximum number of datasets to list. </p>', 'ListInferenceEventsRequest$MaxResults' => '<p>Specifies the maximum number of inference events to list. </p>', 'ListInferenceExecutionsRequest$MaxResults' => '<p>Specifies the maximum number of inference executions to list. </p>', 'ListInferenceSchedulersRequest$MaxResults' => '<p> Specifies the maximum number of inference schedulers to list. </p>', 'ListLabelGroupsRequest$MaxResults' => '<p> Specifies the maximum number of label groups to list. </p>', 'ListLabelsRequest$MaxResults' => '<p> Specifies the maximum number of labels to list. </p>', 'ListModelVersionsRequest$MaxResults' => '<p>Specifies the maximum number of machine learning model versions to list.</p>', 'ListModelsRequest$MaxResults' => '<p> Specifies the maximum number of machine learning models to list. </p>', 'ListRetrainingSchedulersRequest$MaxResults' => '<p>Specifies the maximum number of retraining schedulers to list. </p>', 'ListSensorStatisticsRequest$MaxResults' => '<p>Specifies the maximum number of sensors for which to retrieve statistics. </p>', ], ], 'MissingCompleteSensorData' => [ 'base' => '<p> Entity that comprises information on sensors that have sensor data completely missing. </p>', 'refs' => [ 'InsufficientSensorData$MissingCompleteSensorData' => '<p> Parameter that describes the total number of sensors that have data completely missing for it. </p>', ], ], 'MissingSensorData' => [ 'base' => '<p> Entity that comprises aggregated information on sensors having missing data. </p>', 'refs' => [ 'DataQualitySummary$MissingSensorData' => '<p> Parameter that gives information about data that is missing over all the sensors in the input data. </p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model being created. </p>', 'CreateRetrainingSchedulerResponse$ModelArn' => '<p>The ARN of the model that you added the retraining scheduler to. </p>', 'DescribeInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model of the inference scheduler being described. </p>', 'DescribeModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model being described. </p>', 'DescribeModelVersionResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the parent machine learning model that this version belong to.</p>', 'DescribeRetrainingSchedulerResponse$ModelArn' => '<p>The ARN of the model that the retraining scheduler is attached to. </p>', 'ImportModelVersionResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model being created. </p>', 'InferenceExecutionSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model used for the inference execution. </p>', 'InferenceSchedulerSummary$ModelArn' => '<p> The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler. </p>', 'ModelSummary$ModelArn' => '<p> The Amazon Resource Name (ARN) of the machine learning model. </p>', 'ModelVersionSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model that this model version is a version of.</p>', 'RetrainingSchedulerSummary$ModelArn' => '<p>The ARN of the model that the retraining scheduler is attached to. </p>', 'StartInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model being used by the inference scheduler. </p>', 'StartRetrainingSchedulerResponse$ModelArn' => '<p>The ARN of the model whose retraining scheduler is being started. </p>', 'StopInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler being stopped. </p>', 'StopRetrainingSchedulerResponse$ModelArn' => '<p>The ARN of the model whose retraining scheduler is being stopped. </p>', 'UpdateActiveModelVersionResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model for which the active model version was set.</p>', ], ], 'ModelDiagnosticsOutputConfiguration' => [ 'base' => '<p>Output configuration information for the pointwise model diagnostics for an Amazon Lookout for Equipment model.</p>', 'refs' => [ 'CreateModelRequest$ModelDiagnosticsOutputConfiguration' => '<p>The Amazon S3 location where you want Amazon Lookout for Equipment to save the pointwise model diagnostics. You must also specify the <code>RoleArn</code> request parameter.</p>', 'DescribeModelResponse$ModelDiagnosticsOutputConfiguration' => '<p>Configuration information for the model\'s pointwise model diagnostics.</p>', 'DescribeModelVersionResponse$ModelDiagnosticsOutputConfiguration' => '<p>The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for the model version.</p>', 'ModelSummary$ModelDiagnosticsOutputConfiguration' => NULL, 'UpdateModelRequest$ModelDiagnosticsOutputConfiguration' => '<p>The Amazon S3 location where you want Amazon Lookout for Equipment to save the pointwise model diagnostics for the model. You must also specify the <code>RoleArn</code> request parameter.</p>', ], ], 'ModelDiagnosticsS3OutputConfiguration' => [ 'base' => '<p>The Amazon S3 location for the pointwise model diagnostics for an Amazon Lookout for Equipment model. </p>', 'refs' => [ 'ModelDiagnosticsOutputConfiguration$S3OutputConfiguration' => '<p>The Amazon S3 location for the pointwise model diagnostics. </p>', ], ], 'ModelMetrics' => [ 'base' => NULL, 'refs' => [ 'DescribeModelResponse$ModelMetrics' => '<p>The Model Metrics show an aggregated summary of the model\'s performance within the evaluation time range. This is the JSON content of the metrics created when evaluating the model. </p>', 'DescribeModelResponse$PriorModelMetrics' => '<p>If the model version was retrained, this field shows a summary of the performance of the prior model on the new training range. You can use the information in this JSON-formatted object to compare the new model version and the prior model version.</p>', 'DescribeModelVersionResponse$ModelMetrics' => '<p>Shows an aggregated summary, in JSON format, of the model\'s performance within the evaluation time range. These metrics are created when evaluating the model.</p>', 'DescribeModelVersionResponse$PriorModelMetrics' => '<p>If the model version was retrained, this field shows a summary of the performance of the prior model on the new training range. You can use the information in this JSON-formatted object to compare the new model version and the prior model version.</p>', 'InferenceEventSummary$Diagnostics' => '<p> An array which specifies the names and values of all sensors contributing to an inference event.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$ModelName' => '<p>The name of the previously trained machine learning model being used to create the inference scheduler. </p>', 'CreateModelRequest$ModelName' => '<p>The name for the machine learning model to be created.</p>', 'CreateRetrainingSchedulerRequest$ModelName' => '<p>The name of the model to add the retraining scheduler to. </p>', 'CreateRetrainingSchedulerResponse$ModelName' => '<p>The name of the model that you added the retraining scheduler to. </p>', 'DeleteModelRequest$ModelName' => '<p>The name of the machine learning model to be deleted. </p>', 'DeleteRetrainingSchedulerRequest$ModelName' => '<p>The name of the model whose retraining scheduler you want to delete. </p>', 'DescribeInferenceSchedulerResponse$ModelName' => '<p>The name of the machine learning model of the inference scheduler being described. </p>', 'DescribeModelRequest$ModelName' => '<p>The name of the machine learning model to be described. </p>', 'DescribeModelResponse$ModelName' => '<p>The name of the machine learning model being described. </p>', 'DescribeModelVersionRequest$ModelName' => '<p>The name of the machine learning model that this version belongs to.</p>', 'DescribeModelVersionResponse$ModelName' => '<p>The name of the machine learning model that this version belongs to.</p>', 'DescribeRetrainingSchedulerRequest$ModelName' => '<p>The name of the model that the retraining scheduler is attached to. </p>', 'DescribeRetrainingSchedulerResponse$ModelName' => '<p>The name of the model that the retraining scheduler is attached to. </p>', 'ImportModelVersionRequest$ModelName' => '<p>The name for the machine learning model to be created. If the model already exists, Amazon Lookout for Equipment creates a new version. If you do not specify this field, it is filled with the name of the source model.</p>', 'ImportModelVersionResponse$ModelName' => '<p>The name for the machine learning model.</p>', 'InferenceExecutionSummary$ModelName' => '<p>The name of the machine learning model being used for the inference execution. </p>', 'InferenceSchedulerSummary$ModelName' => '<p>The name of the machine learning model used for the inference scheduler. </p>', 'ListInferenceSchedulersRequest$ModelName' => '<p>The name of the machine learning model used by the inference scheduler to be listed. </p>', 'ListModelVersionsRequest$ModelName' => '<p>Then name of the machine learning model for which the model versions are to be listed.</p>', 'ListModelsRequest$ModelNameBeginsWith' => '<p>The beginning of the name of the machine learning models being listed. </p>', 'ListRetrainingSchedulersRequest$ModelNameBeginsWith' => '<p>Specify this field to only list retraining schedulers whose machine learning models begin with the value you specify. </p>', 'ModelSummary$ModelName' => '<p>The name of the machine learning model. </p>', 'ModelVersionSummary$ModelName' => '<p>The name of the model that this model version is a version of.</p>', 'RetrainingSchedulerSummary$ModelName' => '<p>The name of the model that the retraining scheduler is attached to. </p>', 'StartInferenceSchedulerResponse$ModelName' => '<p>The name of the machine learning model being used by the inference scheduler. </p>', 'StartRetrainingSchedulerRequest$ModelName' => '<p>The name of the model whose retraining scheduler you want to start.</p>', 'StartRetrainingSchedulerResponse$ModelName' => '<p>The name of the model whose retraining scheduler is being started. </p>', 'StopInferenceSchedulerResponse$ModelName' => '<p>The name of the machine learning model used by the inference scheduler being stopped. </p>', 'StopRetrainingSchedulerRequest$ModelName' => '<p>The name of the model whose retraining scheduler you want to stop.</p>', 'StopRetrainingSchedulerResponse$ModelName' => '<p>The name of the model whose retraining scheduler is being stopped. </p>', 'UpdateActiveModelVersionRequest$ModelName' => '<p>The name of the machine learning model for which the active model version is being set.</p>', 'UpdateActiveModelVersionResponse$ModelName' => '<p>The name of the machine learning model for which the active model version was set.</p>', 'UpdateModelRequest$ModelName' => '<p>The name of the model to update.</p>', 'UpdateRetrainingSchedulerRequest$ModelName' => '<p>The name of the model whose retraining scheduler you want to update. </p>', ], ], 'ModelPromoteMode' => [ 'base' => NULL, 'refs' => [ 'CreateRetrainingSchedulerRequest$PromoteMode' => '<p>Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new models will not be used <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation">until they are manually activated</a>.</p>', 'DescribeRetrainingSchedulerResponse$PromoteMode' => '<p>Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new models are not used until they are <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation">manually activated</a>.</p>', 'UpdateRetrainingSchedulerRequest$PromoteMode' => '<p>Indicates how the service will use new models. In <code>MANAGED</code> mode, new models will automatically be used for inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new models will not be used <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation">until they are manually activated</a>.</p>', ], ], 'ModelQuality' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerResponse$ModelQuality' => '<p>Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p> <p>If the model is unlabeled, the model quality can\'t be assessed and the value of <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels to the input dataset and retraining the model.</p> <p>For information about using labels with your models, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding labeling</a>.</p> <p>For information about improving the quality of a model, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon Lookout for Equipment</a>.</p>', 'DescribeModelResponse$ModelQuality' => '<p>Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p> <p>If the model is unlabeled, the model quality can\'t be assessed and the value of <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels to the input dataset and retraining the model.</p> <p>For information about using labels with your models, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding labeling</a>.</p> <p>For information about improving the quality of a model, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon Lookout for Equipment</a>.</p>', 'DescribeModelVersionResponse$ModelQuality' => '<p>Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p> <p>If the model is unlabeled, the model quality can\'t be assessed and the value of <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels to the input dataset and retraining the model.</p> <p>For information about using labels with your models, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding labeling</a>.</p> <p>For information about improving the quality of a model, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon Lookout for Equipment</a>.</p>', 'ModelSummary$ModelQuality' => '<p>Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p> <p>If the model is unlabeled, the model quality can\'t be assessed and the value of <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels to the input dataset and retraining the model.</p> <p>For information about using labels with your models, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding labeling</a>.</p> <p>For information about improving the quality of a model, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon Lookout for Equipment</a>.</p>', 'ModelVersionSummary$ModelQuality' => '<p>Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p> <p>If the model is unlabeled, the model quality can\'t be assessed and the value of <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels to the input dataset and retraining the model.</p> <p>For information about improving the quality of a model, see <a href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon Lookout for Equipment</a>.</p>', ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'CreateModelResponse$Status' => '<p>Indicates the status of the <code>CreateModel</code> operation. </p>', 'DescribeModelResponse$Status' => '<p>Specifies the current status of the model being described. Status describes the status of the most recent action of the model. </p>', 'ListModelsRequest$Status' => '<p>The status of the machine learning model. </p>', 'ModelSummary$Status' => '<p>Indicates the status of the machine learning model. </p>', ], ], 'ModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelsResponse$ModelSummaries' => '<p>Provides information on the specified model, including created time, model and dataset ARNs, and status. </p>', ], ], 'ModelSummary' => [ 'base' => '<p>Provides information about the specified machine learning model, including dataset and model names and ARNs, as well as status. </p>', 'refs' => [ 'ModelSummaries$member' => NULL, ], ], 'ModelVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeModelResponse$ActiveModelVersion' => '<p>The name of the model version used by the inference schedular when running a scheduled inference execution.</p>', 'DescribeModelResponse$PreviousActiveModelVersion' => '<p>The model version that was set as the active model version prior to the current active model version.</p>', 'DescribeModelResponse$LatestScheduledRetrainingModelVersion' => '<p>Indicates the most recent model version that was generated by retraining. </p>', 'DescribeModelVersionRequest$ModelVersion' => '<p>The version of the machine learning model.</p>', 'DescribeModelVersionResponse$ModelVersion' => '<p>The version of the machine learning model.</p>', 'ImportModelVersionResponse$ModelVersion' => '<p>The version of the model being created.</p>', 'InferenceExecutionSummary$ModelVersion' => '<p>The model version used for the inference execution.</p>', 'ListModelVersionsRequest$MaxModelVersion' => '<p>Specifies the highest version of the model to return in the list.</p>', 'ListModelVersionsRequest$MinModelVersion' => '<p>Specifies the lowest version of the model to return in the list.</p>', 'ModelSummary$ActiveModelVersion' => '<p>The model version that the inference scheduler uses to run an inference execution.</p>', 'ModelSummary$LatestScheduledRetrainingModelVersion' => '<p>Indicates the most recent model version that was generated by retraining. </p>', 'ModelVersionSummary$ModelVersion' => '<p>The version of the model.</p>', 'UpdateActiveModelVersionRequest$ModelVersion' => '<p>The version of the machine learning model for which the active model version is being set.</p>', 'UpdateActiveModelVersionResponse$CurrentActiveVersion' => '<p>The version that is currently active of the machine learning model for which the active model version was set.</p>', 'UpdateActiveModelVersionResponse$PreviousActiveVersion' => '<p>The previous version that was active of the machine learning model for which the active model version was set.</p>', ], ], 'ModelVersionArn' => [ 'base' => NULL, 'refs' => [ 'DescribeModelResponse$SourceModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the source model version. This field appears if the active model version was imported.</p>', 'DescribeModelResponse$ActiveModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version used by the inference scheduler when running a scheduled inference execution.</p>', 'DescribeModelResponse$PreviousActiveModelVersionArn' => '<p>The ARN of the model version that was set as the active model version prior to the current active model version.</p>', 'DescribeModelVersionResponse$ModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version.</p>', 'DescribeModelVersionResponse$SourceModelVersionArn' => '<p>If model version was imported, then this field is the arn of the source model version.</p>', 'ImportModelVersionRequest$SourceModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version to import.</p>', 'ImportModelVersionResponse$ModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version being created. </p>', 'InferenceExecutionSummary$ModelVersionArn' => '<p>The Amazon Resource Number (ARN) of the model version used for the inference execution.</p>', 'ModelSummary$ActiveModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version that is set as active. The active model version is the model version that the inference scheduler uses to run an inference execution.</p>', 'ModelVersionSummary$ModelVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version.</p>', 'UpdateActiveModelVersionResponse$CurrentActiveVersionArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model version that is the current active model version.</p>', 'UpdateActiveModelVersionResponse$PreviousActiveVersionArn' => '<p>The Amazon Resource Name (ARN) of the machine learning model version that was the previous active model version.</p>', ], ], 'ModelVersionSourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeModelVersionResponse$SourceType' => '<p>Indicates whether this model version was created by training or by importing.</p>', 'ListModelVersionsRequest$SourceType' => '<p>Filter the results based on the way the model version was generated.</p>', 'ModelVersionSummary$SourceType' => '<p>Indicates how this model version was generated.</p>', ], ], 'ModelVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelResponse$LatestScheduledRetrainingStatus' => '<p>Indicates the status of the most recent scheduled retraining run. </p>', 'DescribeModelVersionResponse$Status' => '<p>The current status of the model version.</p>', 'ImportModelVersionResponse$Status' => '<p>The status of the <code>ImportModelVersion</code> operation. </p>', 'ListModelVersionsRequest$Status' => '<p>Filter the results based on the current status of the model version.</p>', 'ModelSummary$LatestScheduledRetrainingStatus' => '<p>Indicates the status of the most recent scheduled retraining run. </p>', 'ModelVersionSummary$Status' => '<p>The current status of the model version.</p>', ], ], 'ModelVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelVersionsResponse$ModelVersionSummaries' => '<p>Provides information on the specified model version, including the created time, model and dataset ARNs, and status.</p> <note> <p>If you don\'t supply the <code>ModelName</code> request parameter, or if you supply the name of a model that doesn\'t exist, <code>ListModelVersions</code> returns an empty array in <code>ModelVersionSummaries</code>. </p> </note>', ], ], 'ModelVersionSummary' => [ 'base' => '<p>Contains information about the specific model version.</p>', 'refs' => [ 'ModelVersionSummaries$member' => NULL, ], ], 'MonotonicValues' => [ 'base' => '<p> Entity that comprises information on monotonic values in the data. </p>', 'refs' => [ 'SensorStatisticsSummary$MonotonicValues' => '<p> Parameter that describes potential risk about whether data associated with the sensor is mostly monotonic. </p>', ], ], 'Monotonicity' => [ 'base' => NULL, 'refs' => [ 'MonotonicValues$Monotonicity' => '<p> Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC. </p>', ], ], 'MultipleOperatingModes' => [ 'base' => '<p> Entity that comprises information on operating modes in data. </p>', 'refs' => [ 'SensorStatisticsSummary$MultipleOperatingModes' => '<p> Parameter that describes potential risk about whether data associated with the sensor has more than one operating mode. </p>', ], ], 'NameOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment. </p>', 'CreateInferenceSchedulerRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment. </p>', 'CreateModelRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment. </p>', 'ImportDatasetRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment. </p>', 'ImportModelVersionRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment. </p>', 'InferenceOutputConfiguration$KmsKeyId' => '<p>The ID number for the KMS key key used to encrypt the inference output. </p>', 'ModelDiagnosticsOutputConfiguration$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (KMS) key identifier to encrypt the pointwise model diagnostics files.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsRequest$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of data ingestion jobs. </p>', 'ListDataIngestionJobsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of data ingestion jobs. </p>', 'ListDatasetsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of datasets. </p>', 'ListDatasetsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of datasets. </p>', 'ListInferenceEventsRequest$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of inference events.</p>', 'ListInferenceEventsResponse$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of inference executions. </p>', 'ListInferenceExecutionsRequest$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of inference executions.</p>', 'ListInferenceExecutionsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference executions. </p>', 'ListInferenceSchedulersRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference schedulers. </p>', 'ListInferenceSchedulersResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference schedulers. </p>', 'ListLabelGroupsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of label groups. </p>', 'ListLabelGroupsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of label groups. </p>', 'ListLabelsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of label groups. </p>', 'ListLabelsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of datasets. </p>', 'ListModelVersionsRequest$NextToken' => '<p>If the total number of results exceeds the limit that the response can display, the response returns an opaque pagination token indicating where to continue the listing of machine learning model versions. Use this token in the <code>NextToken</code> field in the request to list the next page of results.</p>', 'ListModelVersionsResponse$NextToken' => '<p>If the total number of results exceeds the limit that the response can display, the response returns an opaque pagination token indicating where to continue the listing of machine learning model versions. Use this token in the <code>NextToken</code> field in the request to list the next page of results.</p>', 'ListModelsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of machine learning models. </p>', 'ListModelsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of machine learning models. </p>', 'ListRetrainingSchedulersRequest$NextToken' => '<p>If the number of results exceeds the maximum, a pagination token is returned. Use the token in the request to show the next page of retraining schedulers.</p>', 'ListRetrainingSchedulersResponse$NextToken' => '<p>If the number of results exceeds the maximum, this pagination token is returned. Use this token in the request to show the next page of retraining schedulers.</p>', 'ListSensorStatisticsRequest$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of sensor statistics. </p>', 'ListSensorStatisticsResponse$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of sensor statistics. </p>', ], ], 'OffCondition' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$OffCondition' => '<p>Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.</p>', 'DescribeModelResponse$OffCondition' => '<p>Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.</p>', 'DescribeModelVersionResponse$OffCondition' => '<p>Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'DescribeResourcePolicyResponse$ResourcePolicy' => '<p>The resource policy in a JSON-formatted string.</p>', 'PutResourcePolicyRequest$ResourcePolicy' => '<p>The JSON-formatted resource policy to create.</p>', ], ], 'PolicyRevisionId' => [ 'base' => NULL, 'refs' => [ 'DescribeResourcePolicyResponse$PolicyRevisionId' => '<p>A unique identifier for a revision of the resource policy.</p>', 'PutResourcePolicyRequest$PolicyRevisionId' => '<p>A unique identifier for a revision of the resource policy.</p>', 'PutResourcePolicyResponse$PolicyRevisionId' => '<p>A unique identifier for a revision of the resource policy.</p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which the resource policy should be deleted.</p>', 'DescribeResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that is associated with the resource policy.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which the policy is being created.</p>', 'PutResourcePolicyResponse$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which the policy was created.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The resource requested could not be found. Verify the resource ID and retry your request. </p>', 'refs' => [], ], 'RetrainingFrequency' => [ 'base' => NULL, 'refs' => [ 'CreateRetrainingSchedulerRequest$RetrainingFrequency' => '<p>This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> standard to set the frequency at which you want retraining to occur in terms of Years, Months, and/or Days (note: other parameters like Time are not currently supported). The minimum value is 30 days (P30D) and the maximum value is 1 year (P1Y). For example, the following values are valid:</p> <ul> <li> <p>P3M15D – Every 3 months and 15 days</p> </li> <li> <p>P2M – Every 2 months</p> </li> <li> <p>P150D – Every 150 days</p> </li> </ul>', 'DescribeRetrainingSchedulerResponse$RetrainingFrequency' => '<p>The frequency at which the model retraining is set. This follows the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.</p>', 'RetrainingSchedulerSummary$RetrainingFrequency' => '<p>The frequency at which the model retraining is set. This follows the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.</p>', 'UpdateRetrainingSchedulerRequest$RetrainingFrequency' => '<p>This parameter uses the <a href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> standard to set the frequency at which you want retraining to occur in terms of Years, Months, and/or Days (note: other parameters like Time are not currently supported). The minimum value is 30 days (P30D) and the maximum value is 1 year (P1Y). For example, the following values are valid:</p> <ul> <li> <p>P3M15D – Every 3 months and 15 days</p> </li> <li> <p>P2M – Every 2 months</p> </li> <li> <p>P150D – Every 150 days</p> </li> </ul>', ], ], 'RetrainingSchedulerStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRetrainingSchedulerResponse$Status' => '<p>The status of the retraining scheduler. </p>', 'DescribeModelResponse$RetrainingSchedulerStatus' => '<p>Indicates the status of the retraining scheduler. </p>', 'DescribeRetrainingSchedulerResponse$Status' => '<p>The status of the retraining scheduler. </p>', 'ListRetrainingSchedulersRequest$Status' => '<p>Specify this field to only list retraining schedulers whose status matches the value you specify. </p>', 'ModelSummary$RetrainingSchedulerStatus' => '<p>Indicates the status of the retraining scheduler. </p>', 'RetrainingSchedulerSummary$Status' => '<p>The status of the retraining scheduler. </p>', 'StartRetrainingSchedulerResponse$Status' => '<p>The status of the retraining scheduler. </p>', 'StopRetrainingSchedulerResponse$Status' => '<p>The status of the retraining scheduler. </p>', ], ], 'RetrainingSchedulerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRetrainingSchedulersResponse$RetrainingSchedulerSummaries' => '<p>Provides information on the specified retraining scheduler, including the model name, model ARN, status, and start date. </p>', ], ], 'RetrainingSchedulerSummary' => [ 'base' => '<p>Provides information about the specified retraining scheduler, including model name, status, start date, frequency, and lookback window. </p>', 'refs' => [ 'RetrainingSchedulerSummaries$member' => NULL, ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'InferenceS3InputConfiguration$Bucket' => '<p>The bucket containing the input dataset for the inference. </p>', 'InferenceS3OutputConfiguration$Bucket' => '<p> The bucket containing the output results from the inference </p>', 'IngestionS3InputConfiguration$Bucket' => '<p>The name of the S3 bucket used for the input data for the data ingestion. </p>', 'LabelsS3InputConfiguration$Bucket' => '<p>The name of the S3 bucket holding the label data. </p>', 'ModelDiagnosticsS3OutputConfiguration$Bucket' => '<p>The name of the Amazon S3 bucket where the pointwise model diagnostics are located. You must be the owner of the Amazon S3 bucket. </p>', 'S3Object$Bucket' => '<p>The name of the specific S3 bucket. </p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Object$Key' => '<p>The Amazon Web Services Key Management Service (KMS key) key being used to encrypt the S3 object. Without this key, data in the bucket is not accessible. </p>', ], ], 'S3Object' => [ 'base' => '<p>Contains information about an S3 bucket. </p>', 'refs' => [ 'DescribeModelVersionResponse$ModelDiagnosticsResultsObject' => '<p>The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for the model version.</p>', 'InferenceExecutionSummary$CustomerResultObject' => '<p>The S3 object that the inference execution results were uploaded to.</p>', 'ListOfDiscardedFiles$member' => NULL, ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'InferenceS3InputConfiguration$Prefix' => '<p>The prefix for the S3 bucket used for the input data for the inference. </p>', 'InferenceS3OutputConfiguration$Prefix' => '<p> The prefix for the S3 bucket used for the output results from the inference. </p>', 'IngestionS3InputConfiguration$Prefix' => '<p>The prefix for the S3 location being used for the input data for the data ingestion. </p>', 'LabelsS3InputConfiguration$Prefix' => '<p> The prefix for the S3 bucket used for the label data. </p>', 'ModelDiagnosticsS3OutputConfiguration$Prefix' => '<p>The Amazon S3 prefix for the location of the pointwise model diagnostics. The prefix specifies the folder and evaluation result file name. (<code>bucket</code>).</p> <p>When you call <code>CreateModel</code> or <code>UpdateModel</code>, specify the path within the bucket that you want Lookout for Equipment to save the model to. During training, Lookout for Equipment creates the model evaluation model as a compressed JSON file with the name <code>model_diagnostics_results.json.gz</code>.</p> <p>When you call <code>DescribeModel</code> or <code>DescribeModelVersion</code>, <code>prefix</code> contains the file path and filename of the model evaluation file. </p>', ], ], 'SensorName' => [ 'base' => NULL, 'refs' => [ 'SensorStatisticsSummary$SensorName' => '<p> Name of the sensor that the statistics belong to. </p>', ], ], 'SensorStatisticsSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSensorStatisticsResponse$SensorStatisticsSummaries' => '<p>Provides ingestion-based statistics regarding the specified sensor with respect to various validation types, such as whether data exists, the number and percentage of missing values, and the number and percentage of duplicate timestamps. </p>', ], ], 'SensorStatisticsSummary' => [ 'base' => '<p> Summary of ingestion statistics like whether data exists, number of missing values, number of invalid values and so on related to the particular sensor. </p>', 'refs' => [ 'SensorStatisticsSummaries$member' => NULL, ], ], 'SensorsWithShortDateRange' => [ 'base' => '<p> Entity that comprises information on sensors that have shorter date range. </p>', 'refs' => [ 'InsufficientSensorData$SensorsWithShortDateRange' => '<p> Parameter that describes the total number of sensors that have a short date range of less than 14 days of data overall. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> Resource limitations have been exceeded. </p>', 'refs' => [], ], 'StartDataIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRetrainingSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatisticalIssueStatus' => [ 'base' => NULL, 'refs' => [ 'CategoricalValues$Status' => '<p> Indicates whether there is a potential data issue related to categorical values. </p>', 'LargeTimestampGaps$Status' => '<p> Indicates whether there is a potential data issue related to large gaps in timestamps. </p>', 'MonotonicValues$Status' => '<p> Indicates whether there is a potential data issue related to having monotonic values. </p>', 'MultipleOperatingModes$Status' => '<p> Indicates whether there is a potential data issue related to having multiple operating modes. </p>', ], ], 'StopInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopRetrainingSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that can be added to a resource as metadata. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the specified tag. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Specifies the key of the tag to be removed from a specified resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$Tags' => '<p>Any tags associated with the ingested data described in the dataset. </p>', 'CreateInferenceSchedulerRequest$Tags' => '<p>Any tags associated with the inference scheduler. </p>', 'CreateLabelGroupRequest$Tags' => '<p> Tags that provide metadata about the label group you are creating. </p> <p>Data in this field will be retained for service usage. Follow best practices for the security of your data.</p>', 'CreateModelRequest$Tags' => '<p> Any tags associated with the machine learning model being created. </p>', 'ImportDatasetRequest$Tags' => '<p>Any tags associated with the dataset to be created.</p>', 'ImportModelVersionRequest$Tags' => '<p>The tags associated with the machine learning model to be created. </p>', 'ListTagsForResourceResponse$Tags' => '<p> Any tags associated with the resource. </p>', 'TagResourceRequest$Tags' => '<p>The tag or tags to be associated with a specific resource. Both the tag key and value are specified. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag. </p>', ], ], 'TargetSamplingRate' => [ 'base' => NULL, 'refs' => [ 'DataPreProcessingConfiguration$TargetSamplingRate' => '<p>The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeZoneOffset' => [ 'base' => NULL, 'refs' => [ 'InferenceInputConfiguration$InputTimeZoneOffset' => '<p>Indicates the difference between your time zone and Coordinated Universal Time (UTC).</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateLabelRequest$StartTime' => '<p> The start time of the labeled event. </p>', 'CreateLabelRequest$EndTime' => '<p> The end time of the labeled event. </p>', 'CreateModelRequest$TrainingDataStartTime' => '<p>Indicates the time reference in the dataset that should be used to begin the subset of training data for the machine learning model. </p>', 'CreateModelRequest$TrainingDataEndTime' => '<p>Indicates the time reference in the dataset that should be used to end the subset of training data for the machine learning model. </p>', 'CreateModelRequest$EvaluationDataStartTime' => '<p>Indicates the time reference in the dataset that should be used to begin the subset of evaluation data for the machine learning model. </p>', 'CreateModelRequest$EvaluationDataEndTime' => '<p> Indicates the time reference in the dataset that should be used to end the subset of evaluation data for the machine learning model. </p>', 'CreateRetrainingSchedulerRequest$RetrainingStartDate' => '<p>The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest UTC day.</p>', 'DatasetSummary$CreatedAt' => '<p>The time at which the dataset was created in Amazon Lookout for Equipment. </p>', 'DescribeDataIngestionJobResponse$CreatedAt' => '<p>The time at which the data ingestion job was created. </p>', 'DescribeDataIngestionJobResponse$DataStartTime' => '<p> Indicates the earliest timestamp corresponding to data that was successfully ingested during this specific ingestion job. </p>', 'DescribeDataIngestionJobResponse$DataEndTime' => '<p> Indicates the latest timestamp corresponding to data that was successfully ingested during this specific ingestion job. </p>', 'DescribeDatasetResponse$CreatedAt' => '<p>Specifies the time the dataset was created in Lookout for Equipment. </p>', 'DescribeDatasetResponse$LastUpdatedAt' => '<p>Specifies the time the dataset was last updated, if it was. </p>', 'DescribeDatasetResponse$DataStartTime' => '<p> Indicates the earliest timestamp corresponding to data that was successfully ingested during the most recent ingestion of this particular dataset. </p>', 'DescribeDatasetResponse$DataEndTime' => '<p> Indicates the latest timestamp corresponding to data that was successfully ingested during the most recent ingestion of this particular dataset. </p>', 'DescribeInferenceSchedulerResponse$CreatedAt' => '<p>Specifies the time at which the inference scheduler was created. </p>', 'DescribeInferenceSchedulerResponse$UpdatedAt' => '<p>Specifies the time at which the inference scheduler was last updated, if it was. </p>', 'DescribeLabelGroupResponse$CreatedAt' => '<p> The time at which the label group was created. </p>', 'DescribeLabelGroupResponse$UpdatedAt' => '<p> The time at which the label group was updated. </p>', 'DescribeLabelResponse$StartTime' => '<p> The start time of the requested label. </p>', 'DescribeLabelResponse$EndTime' => '<p> The end time of the requested label. </p>', 'DescribeLabelResponse$CreatedAt' => '<p> The time at which the label was created. </p>', 'DescribeModelResponse$TrainingDataStartTime' => '<p> Indicates the time reference in the dataset that was used to begin the subset of training data for the machine learning model. </p>', 'DescribeModelResponse$TrainingDataEndTime' => '<p> Indicates the time reference in the dataset that was used to end the subset of training data for the machine learning model. </p>', 'DescribeModelResponse$EvaluationDataStartTime' => '<p> Indicates the time reference in the dataset that was used to begin the subset of evaluation data for the machine learning model. </p>', 'DescribeModelResponse$EvaluationDataEndTime' => '<p> Indicates the time reference in the dataset that was used to end the subset of evaluation data for the machine learning model. </p>', 'DescribeModelResponse$TrainingExecutionStartTime' => '<p>Indicates the time at which the training of the machine learning model began. </p>', 'DescribeModelResponse$TrainingExecutionEndTime' => '<p>Indicates the time at which the training of the machine learning model was completed. </p>', 'DescribeModelResponse$LastUpdatedTime' => '<p>Indicates the last time the machine learning model was updated. The type of update is not specified. </p>', 'DescribeModelResponse$CreatedAt' => '<p>Indicates the time and date at which the machine learning model was created. </p>', 'DescribeModelResponse$ImportJobStartTime' => '<p>The date and time when the import job was started. This field appears if the active model version was imported.</p>', 'DescribeModelResponse$ImportJobEndTime' => '<p>The date and time when the import job was completed. This field appears if the active model version was imported.</p>', 'DescribeModelResponse$ModelVersionActivatedAt' => '<p>The date the active model version was activated.</p>', 'DescribeModelResponse$PreviousModelVersionActivatedAt' => '<p>The date and time when the previous active model version was activated.</p>', 'DescribeModelResponse$LatestScheduledRetrainingStartTime' => '<p>Indicates the start time of the most recent scheduled retraining run. </p>', 'DescribeModelResponse$NextScheduledRetrainingStartDate' => '<p>Indicates the date and time that the next scheduled retraining run will start on. Lookout for Equipment truncates the time you provide to the nearest UTC day.</p>', 'DescribeModelResponse$AccumulatedInferenceDataStartTime' => '<p>Indicates the start time of the inference data that has been accumulated. </p>', 'DescribeModelResponse$AccumulatedInferenceDataEndTime' => '<p>Indicates the end time of the inference data that has been accumulated. </p>', 'DescribeModelVersionResponse$TrainingDataStartTime' => '<p>The date on which the training data began being gathered. If you imported the version, this is the date that the training data in the source version began being gathered.</p>', 'DescribeModelVersionResponse$TrainingDataEndTime' => '<p>The date on which the training data finished being gathered. If you imported the version, this is the date that the training data in the source version finished being gathered.</p>', 'DescribeModelVersionResponse$EvaluationDataStartTime' => '<p>The date on which the data in the evaluation set began being gathered. If you imported the version, this is the date that the evaluation set data in the source version began being gathered.</p>', 'DescribeModelVersionResponse$EvaluationDataEndTime' => '<p>The date on which the data in the evaluation set began being gathered. If you imported the version, this is the date that the evaluation set data in the source version finished being gathered.</p>', 'DescribeModelVersionResponse$TrainingExecutionStartTime' => '<p>The time when the training of the version began.</p>', 'DescribeModelVersionResponse$TrainingExecutionEndTime' => '<p>The time when the training of the version completed.</p>', 'DescribeModelVersionResponse$LastUpdatedTime' => '<p>Indicates the last time the machine learning model version was updated.</p>', 'DescribeModelVersionResponse$CreatedAt' => '<p>Indicates the time and date at which the machine learning model version was created.</p>', 'DescribeModelVersionResponse$ImportJobStartTime' => '<p>The date and time when the import job began. This field appears if the model version was imported.</p>', 'DescribeModelVersionResponse$ImportJobEndTime' => '<p>The date and time when the import job completed. This field appears if the model version was imported.</p>', 'DescribeResourcePolicyResponse$CreationTime' => '<p>The time when the resource policy was created.</p>', 'DescribeResourcePolicyResponse$LastModifiedTime' => '<p>The time when the resource policy was last modified.</p>', 'DescribeRetrainingSchedulerResponse$RetrainingStartDate' => '<p>The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest UTC day.</p>', 'DescribeRetrainingSchedulerResponse$CreatedAt' => '<p>Indicates the time and date at which the retraining scheduler was created. </p>', 'DescribeRetrainingSchedulerResponse$UpdatedAt' => '<p>Indicates the time and date at which the retraining scheduler was updated. </p>', 'InferenceEventSummary$EventStartTime' => '<p>Indicates the starting time of an inference event. </p>', 'InferenceEventSummary$EventEndTime' => '<p>Indicates the ending time of an inference event. </p>', 'InferenceExecutionSummary$ScheduledStartTime' => '<p>Indicates the start time at which the inference scheduler began the specific inference execution. </p>', 'InferenceExecutionSummary$DataStartTime' => '<p>Indicates the time reference in the dataset at which the inference execution began. </p>', 'InferenceExecutionSummary$DataEndTime' => '<p>Indicates the time reference in the dataset at which the inference execution stopped. </p>', 'LabelGroupSummary$CreatedAt' => '<p> The time at which the label group was created. </p>', 'LabelGroupSummary$UpdatedAt' => '<p> The time at which the label group was updated. </p>', 'LabelSummary$StartTime' => '<p> The timestamp indicating the start of the label. </p>', 'LabelSummary$EndTime' => '<p> The timestamp indicating the end of the label. </p>', 'LabelSummary$CreatedAt' => '<p> The time at which the label was created. </p>', 'ListInferenceEventsRequest$IntervalStartTime' => '<p> Lookout for Equipment will return all the inference events with an end time equal to or greater than the start time given.</p>', 'ListInferenceEventsRequest$IntervalEndTime' => '<p>Returns all the inference events with an end start time equal to or greater than less than the end time given.</p>', 'ListInferenceExecutionsRequest$DataStartTimeAfter' => '<p>The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the inference execution. </p>', 'ListInferenceExecutionsRequest$DataEndTimeBefore' => '<p>The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the inference execution. </p>', 'ListLabelsRequest$IntervalStartTime' => '<p> Returns all the labels with a end time equal to or later than the start time given. </p>', 'ListLabelsRequest$IntervalEndTime' => '<p> Returns all labels with a start time earlier than the end time given. </p>', 'ListModelVersionsRequest$CreatedAtEndTime' => '<p>Filter results to return all the model versions created before this time.</p>', 'ListModelVersionsRequest$CreatedAtStartTime' => '<p>Filter results to return all the model versions created after this time.</p>', 'ModelSummary$CreatedAt' => '<p>The time at which the specific model was created. </p>', 'ModelSummary$LatestScheduledRetrainingStartTime' => '<p>Indicates the start time of the most recent scheduled retraining run. </p>', 'ModelSummary$NextScheduledRetrainingStartDate' => '<p>Indicates the date that the next scheduled retraining run will start on. Lookout for Equipment truncates the time you provide to <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">the nearest UTC day</a>.</p>', 'ModelVersionSummary$CreatedAt' => '<p>The time when this model version was created.</p>', 'RetrainingSchedulerSummary$RetrainingStartDate' => '<p>The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest UTC day.</p>', 'SensorStatisticsSummary$DataStartTime' => '<p> Indicates the time reference to indicate the beginning of valid data associated with the sensor that the statistics belong to. </p>', 'SensorStatisticsSummary$DataEndTime' => '<p> Indicates the time reference to indicate the end of valid data associated with the sensor that the statistics belong to. </p>', 'UpdateRetrainingSchedulerRequest$RetrainingStartDate' => '<p>The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest UTC day.</p>', ], ], 'UnsupportedTimestamps' => [ 'base' => '<p> Entity that comprises information abount unsupported timestamps in the dataset. </p>', 'refs' => [ 'DataQualitySummary$UnsupportedTimestamps' => '<p> Parameter that gives information about unsupported timestamps in the input data. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActiveModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActiveModelVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLabelGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRetrainingSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p> The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related Amazon Web Services service that\'s being utilized. </p>', 'refs' => [], ], ],];
