<?php
// This file was auto-generated from sdk-root/src/data/macie2/2020-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to help you discover and protect your sensitive data in AWS. Macie automates the discovery of sensitive data, such as PII and intellectual property, to provide you with insight into the data that your organization stores in AWS. Macie also provides an inventory of your Amazon S3 buckets, which it continually monitors for you. If Macie detects sensitive data or potential data access issues, it generates detailed findings for you to review and act upon as necessary.</p>', 'operations' => [ 'AcceptInvitation' => '<p>Accepts an Amazon Macie membership invitation that was received from a specific account.</p>', 'BatchGetCustomDataIdentifiers' => '<p>Retrieves information about one or more custom data identifiers.</p>', 'BatchUpdateAutomatedDiscoveryAccounts' => '<p>Changes the status of automated sensitive data discovery for one or more accounts.</p>', 'CreateAllowList' => '<p>Creates and defines the settings for an allow list.</p>', 'CreateClassificationJob' => '<p>Creates and defines the settings for a classification job.</p>', 'CreateCustomDataIdentifier' => '<p>Creates and defines the criteria and other settings for a custom data identifier.</p>', 'CreateFindingsFilter' => '<p>Creates and defines the criteria and other settings for a findings filter.</p>', 'CreateInvitations' => '<p>Sends an Amazon Macie membership invitation to one or more accounts.</p>', 'CreateMember' => '<p>Associates an account with an Amazon Macie administrator account.</p>', 'CreateSampleFindings' => '<p>Creates sample findings.</p>', 'DeclineInvitations' => '<p>Declines Amazon Macie membership invitations that were received from specific accounts.</p>', 'DeleteAllowList' => '<p>Deletes an allow list.</p>', 'DeleteCustomDataIdentifier' => '<p>Soft deletes a custom data identifier.</p>', 'DeleteFindingsFilter' => '<p>Deletes a findings filter.</p>', 'DeleteInvitations' => '<p>Deletes Amazon Macie membership invitations that were received from specific accounts.</p>', 'DeleteMember' => '<p>Deletes the association between an Amazon Macie administrator account and an account.</p>', 'DescribeBuckets' => '<p>Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes for an account.</p>', 'DescribeClassificationJob' => '<p>Retrieves the status and settings for a classification job.</p>', 'DescribeOrganizationConfiguration' => '<p>Retrieves the Amazon Macie configuration settings for an organization in Organizations.</p>', 'DisableMacie' => '<p>Disables Amazon Macie and deletes all settings and resources for a Macie account.</p>', 'DisableOrganizationAdminAccount' => '<p>Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.</p>', 'DisassociateFromAdministratorAccount' => '<p>Disassociates a member account from its Amazon Macie administrator account.</p>', 'DisassociateFromMasterAccount' => '<p>(Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link> operation.</p>', 'DisassociateMember' => '<p>Disassociates an Amazon Macie administrator account from a member account.</p>', 'EnableMacie' => '<p>Enables Amazon Macie and specifies the configuration settings for a Macie account.</p>', 'EnableOrganizationAdminAccount' => '<p>Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.</p>', 'GetAdministratorAccount' => '<p>Retrieves information about the Amazon Macie administrator account for an account.</p>', 'GetAllowList' => '<p>Retrieves the settings and status of an allow list.</p>', 'GetAutomatedDiscoveryConfiguration' => '<p>Retrieves the configuration settings and status of automated sensitive data discovery for an organization or standalone account.</p>', 'GetBucketStatistics' => '<p>Retrieves (queries) aggregated statistical data about all the S3 buckets that Amazon Macie monitors and analyzes for an account.</p>', 'GetClassificationExportConfiguration' => '<p>Retrieves the configuration settings for storing data classification results.</p>', 'GetClassificationScope' => '<p>Retrieves the classification scope settings for an account.</p>', 'GetCustomDataIdentifier' => '<p>Retrieves the criteria and other settings for a custom data identifier.</p>', 'GetFindingStatistics' => '<p>Retrieves (queries) aggregated statistical data about findings.</p>', 'GetFindings' => '<p>Retrieves the details of one or more findings.</p>', 'GetFindingsFilter' => '<p>Retrieves the criteria and other settings for a findings filter.</p>', 'GetFindingsPublicationConfiguration' => '<p>Retrieves the configuration settings for publishing findings to Security Hub.</p>', 'GetInvitationsCount' => '<p>Retrieves the count of Amazon Macie membership invitations that were received by an account.</p>', 'GetMacieSession' => '<p>Retrieves the status and configuration settings for an Amazon Macie account.</p>', 'GetMasterAccount' => '<p>(Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.</p>', 'GetMember' => '<p>Retrieves information about an account that\'s associated with an Amazon Macie administrator account.</p>', 'GetResourceProfile' => '<p>Retrieves (queries) sensitive data discovery statistics and the sensitivity score for an S3 bucket.</p>', 'GetRevealConfiguration' => '<p>Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by findings.</p>', 'GetSensitiveDataOccurrences' => '<p>Retrieves occurrences of sensitive data reported by a finding.</p>', 'GetSensitiveDataOccurrencesAvailability' => '<p>Checks whether occurrences of sensitive data can be retrieved for a finding.</p>', 'GetSensitivityInspectionTemplate' => ' <p>Retrieves the settings for the sensitivity inspection template for an account.</p>', 'GetUsageStatistics' => '<p>Retrieves (queries) quotas and aggregated usage data for one or more accounts.</p>', 'GetUsageTotals' => '<p>Retrieves (queries) aggregated usage data for an account.</p>', 'ListAllowLists' => '<p>Retrieves a subset of information about all the allow lists for an account.</p>', 'ListAutomatedDiscoveryAccounts' => '<p>Retrieves the status of automated sensitive data discovery for one or more accounts.</p>', 'ListClassificationJobs' => '<p>Retrieves a subset of information about one or more classification jobs.</p>', 'ListClassificationScopes' => '<p>Retrieves a subset of information about the classification scope for an account.</p>', 'ListCustomDataIdentifiers' => '<p>Retrieves a subset of information about all the custom data identifiers for an account.</p>', 'ListFindings' => '<p>Retrieves a subset of information about one or more findings.</p>', 'ListFindingsFilters' => '<p>Retrieves a subset of information about all the findings filters for an account.</p>', 'ListInvitations' => '<p>Retrieves information about Amazon Macie membership invitations that were received by an account.</p>', 'ListManagedDataIdentifiers' => '<p>Retrieves information about all the managed data identifiers that Amazon Macie currently provides.</p>', 'ListMembers' => '<p>Retrieves information about the accounts that are associated with an Amazon Macie administrator account.</p>', 'ListOrganizationAdminAccounts' => '<p>Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.</p>', 'ListResourceProfileArtifacts' => '<p>Retrieves information about objects that Amazon Macie selected from an S3 bucket for automated sensitive data discovery.</p>', 'ListResourceProfileDetections' => '<p>Retrieves information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket.</p>', 'ListSensitivityInspectionTemplates' => ' <p>Retrieves a subset of information about the sensitivity inspection template for an account.</p>', 'ListTagsForResource' => '<p>Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.</p>', 'PutClassificationExportConfiguration' => '<p>Adds or updates the configuration settings for storing data classification results.</p>', 'PutFindingsPublicationConfiguration' => '<p>Updates the configuration settings for publishing findings to Security Hub.</p>', 'SearchResources' => '<p>Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>', 'TagResource' => '<p>Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.</p>', 'TestCustomDataIdentifier' => '<p>Tests criteria for a custom data identifier.</p>', 'UntagResource' => '<p>Removes one or more tags (keys and values) from an Amazon Macie resource.</p>', 'UpdateAllowList' => '<p>Updates the settings for an allow list.</p>', 'UpdateAutomatedDiscoveryConfiguration' => '<p>Changes the configuration settings and status of automated sensitive data discovery for an organization or standalone account.</p>', 'UpdateClassificationJob' => '<p>Changes the status of a classification job.</p>', 'UpdateClassificationScope' => '<p>Updates the classification scope settings for an account.</p>', 'UpdateFindingsFilter' => '<p>Updates the criteria and other settings for a findings filter.</p>', 'UpdateMacieSession' => '<p>Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.</p>', 'UpdateMemberSession' => '<p>Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.</p>', 'UpdateOrganizationConfiguration' => '<p>Updates the Amazon Macie configuration settings for an organization in Organizations.</p>', 'UpdateResourceProfile' => '<p>Updates the sensitivity score for an S3 bucket.</p>', 'UpdateResourceProfileDetections' => '<p>Updates the sensitivity scoring settings for an S3 bucket.</p>', 'UpdateRevealConfiguration' => '<p>Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.</p>', 'UpdateSensitivityInspectionTemplate' => ' <p>Updates the settings for the sensitivity inspection template for an account.</p>', ], 'shapes' => [ 'AcceptInvitationRequest' => [ 'base' => '<p>Specifies an Amazon Macie membership invitation to accept. In the request, you have to specify the ID for the Amazon Web Services account that sent the invitation. Otherwise, a validation error occurs. To specify this ID, we recommend that you use the administratorAccountId property instead of the masterAccount property. The masterAccount property has been deprecated and is retained only for backward compatibility.</p>', 'refs' => [], ], 'AccessControlList' => [ 'base' => '<p>Provides information about the permissions settings of the bucket-level access control list (ACL) for an S3 bucket.</p>', 'refs' => [ 'BucketLevelPermissions$AccessControlList' => '<p>The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn\'t been defined for the bucket.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>', 'refs' => [], ], 'AccountDetail' => [ 'base' => '<p>Specifies the details of an account to associate with an Amazon Macie administrator account.</p>', 'refs' => [ 'CreateMemberRequest$Account' => '<p>The details of the account to associate with the administrator account.</p>', ], ], 'AccountLevelPermissions' => [ 'base' => '<p>Provides information about the account-level permissions settings that apply to an S3 bucket.</p>', 'refs' => [ 'BucketPermissionConfiguration$AccountLevelPermissions' => '<p>The account-level permissions settings that apply to the bucket.</p>', ], ], 'AdminAccount' => [ 'base' => '<p>Provides information about the delegated Amazon Macie administrator account for an organization in Organizations.</p>', 'refs' => [ '__listOfAdminAccount$member' => NULL, ], ], 'AdminStatus' => [ 'base' => '<p>The current status of an account as the delegated Amazon Macie administrator account for an organization in Organizations. Possible values are:</p>', 'refs' => [ 'AdminAccount$Status' => '<p>The current status of the account as the delegated Amazon Macie administrator account for the organization.</p>', ], ], 'AllowListCriteria' => [ 'base' => '<p>Specifies the criteria for an allow list. The criteria must specify a regular expression (regex) or an S3 object (s3WordsList). It can\'t specify both.</p>', 'refs' => [ 'CreateAllowListRequest$Criteria' => '<p>The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a text pattern to ignore.</p>', 'GetAllowListResponse$Criteria' => '<p>The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a text pattern to ignore.</p>', 'UpdateAllowListRequest$Criteria' => '<p>The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression that defines a text pattern to ignore (regex).</p> <p>You can change a list\'s underlying criteria, such as the name of the S3 object or the regular expression to use. However, you can\'t change the type from s3WordsList to regex or the other way around.</p>', ], ], 'AllowListStatus' => [ 'base' => '<p>Provides information about the current status of an allow list, which indicates whether Amazon Macie can access and use the list\'s criteria.</p>', 'refs' => [ 'GetAllowListResponse$Status' => '<p>The current status of the allow list, which indicates whether Amazon Macie can access and use the list\'s criteria.</p>', ], ], 'AllowListStatusCode' => [ 'base' => '<p>Indicates the current status of an allow list. Depending on the type of criteria that the list specifies, possible values are:</p>', 'refs' => [ 'AllowListStatus$Code' => '<p>The current status of the allow list. If the list\'s criteria specify a regular expression (regex), this value is typically OK. Amazon Macie can compile the expression.</p> <p>If the list\'s criteria specify an S3 object, possible values are:</p> <ul><li><p>OK - Macie can retrieve and parse the contents of the object.</p></li> <li><p>S3_OBJECT_ACCESS_DENIED - Macie isn\'t allowed to access the object or the object is encrypted with a customer managed KMS key that Macie isn\'t allowed to use. Check the bucket policy and other permissions settings for the bucket and the object. If the object is encrypted, also ensure that it\'s encrypted with a key that Macie is allowed to use.</p></li> <li><p>S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn\'t contain any content. Ensure that the object contains the correct entries. Also ensure that the list\'s criteria specify the correct bucket and object names.</p></li> <li><p>S3_OBJECT_NOT_FOUND - The object doesn\'t exist in Amazon S3. Ensure that the list\'s criteria specify the correct bucket and object names.</p></li> <li><p>S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that each file doesn\'t exceed any quotas. Then configure list settings in Macie for each file.</p></li> <li><p>S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.</p></li> <li><p>S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object exists, you\'re not allowed to access it or it\'s encrypted with an KMS key that you\'re not allowed to use. Work with your Amazon Web Services administrator to ensure that the list\'s criteria specify the correct bucket and object names, and you have read access to the bucket and the object. If the object is encrypted, also ensure that it\'s encrypted with a key that you\'re allowed to use.</p></li> <li><p>UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the object. Wait a few minutes and then try again. A list can also have this status if it\'s encrypted with a key that Amazon S3 and Macie can\'t access or use.</p></li></ul>', ], ], 'AllowListSummary' => [ 'base' => '<p>Provides a subset of information about an allow list.</p>', 'refs' => [ '__listOfAllowListSummary$member' => NULL, ], ], 'AllowsUnencryptedObjectUploads' => [ 'base' => NULL, 'refs' => [ 'BucketMetadata$AllowsUnencryptedObjectUploads' => '<p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are added to the bucket. Possible values are:</p> <ul><li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include a valid server-side encryption header.</p></li> <li><p>TRUE - The bucket doesn\'t have a bucket policy or it has a bucket policy that doesn\'t require server-side encryption of new objects. If a bucket policy exists, it doesn\'t require PutObject requests to include a valid server-side encryption header.</p></li> <li><p>UNKNOWN - Amazon Macie can\'t determine whether the bucket policy requires server-side encryption of new objects.</p></li></ul> <p>Valid server-side encryption headers are: x-amz-server-side-encryption with a value of AES256 or aws:kms, and x-amz-server-side-encryption-customer-algorithm with a value of AES256.</p>', 'S3Bucket$AllowsUnencryptedObjectUploads' => '<p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are added to the bucket. Possible values are:</p> <ul><li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include a valid server-side encryption header.</p></li> <li><p>TRUE - The bucket doesn\'t have a bucket policy or it has a bucket policy that doesn\'t require server-side encryption of new objects. If a bucket policy exists, it doesn\'t require PutObject requests to include a valid server-side encryption header.</p></li> <li><p>UNKNOWN - Amazon Macie can\'t determine whether the bucket policy requires server-side encryption of new objects.</p></li></ul> <p>Valid server-side encryption headers are: x-amz-server-side-encryption with a value of AES256 or aws:kms, and x-amz-server-side-encryption-customer-algorithm with a value of AES256.</p>', ], ], 'ApiCallDetails' => [ 'base' => '<p>Provides information about an API operation that an entity invoked for an affected resource.</p>', 'refs' => [ 'FindingAction$ApiCallDetails' => '<p>The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.</p>', ], ], 'AssumedRole' => [ 'base' => '<p>Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the AssumeRole operation of the Security Token Service (STS) API.</p>', 'refs' => [ 'UserIdentity$AssumedRole' => '<p>If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>', ], ], 'AutoEnableMode' => [ 'base' => '<p>Specifies whether to automatically enable automated sensitive data discovery for accounts that are part of an organization in Amazon Macie. Valid values are:</p>', 'refs' => [ 'GetAutomatedDiscoveryConfigurationResponse$AutoEnableOrganizationMembers' => '<p>Specifies whether automated sensitive data discovery is enabled automatically for accounts in the organization. Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW, enable it only for new member accounts; and, NONE, don\'t enable it for any accounts.</p>', 'UpdateAutomatedDiscoveryConfigurationRequest$AutoEnableOrganizationMembers' => '<p>Specifies whether to automatically enable automated sensitive data discovery for accounts in the organization. Valid values are: ALL (default), enable it for all existing accounts and new member accounts; NEW, enable it only for new member accounts; and, NONE, don\'t enable it for any accounts.</p> <p>If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing accounts that it\'s currently enabled for. To enable or disable it for individual member accounts, specify NEW or NONE, and then enable or disable it for each account by using the BatchUpdateAutomatedDiscoveryAccounts operation.</p>', ], ], 'AutomatedDiscoveryAccount' => [ 'base' => '<p>Provides information about the status of automated sensitive data discovery for an Amazon Macie account.</p>', 'refs' => [ '__listOfAutomatedDiscoveryAccount$member' => NULL, ], ], 'AutomatedDiscoveryAccountStatus' => [ 'base' => '<p>The status of automated sensitive data discovery for an Amazon Macie account. Valid values are:</p>', 'refs' => [ 'AutomatedDiscoveryAccount$Status' => '<p>The current status of automated sensitive data discovery for the account. Possible values are: ENABLED, perform automated sensitive data discovery activities for the account; and, DISABLED, don\'t perform automated sensitive data discovery activities for the account.</p>', 'AutomatedDiscoveryAccountUpdate$Status' => '<p>The new status of automated sensitive data discovery for the account. Valid values are: ENABLED, perform automated sensitive data discovery activities for the account; and, DISABLED, don\'t perform automated sensitive data discovery activities for the account.</p>', ], ], 'AutomatedDiscoveryAccountUpdate' => [ 'base' => '<p>Changes the status of automated sensitive data discovery for an Amazon Macie account.</p>', 'refs' => [ '__listOfAutomatedDiscoveryAccountUpdate$member' => NULL, ], ], 'AutomatedDiscoveryAccountUpdateError' => [ 'base' => '<p>Provides information about a request that failed to change the status of automated sensitive data discovery for an Amazon Macie account.</p>', 'refs' => [ '__listOfAutomatedDiscoveryAccountUpdateError$member' => NULL, ], ], 'AutomatedDiscoveryAccountUpdateErrorCode' => [ 'base' => '<p>The error code that indicates why a request failed to change the status of automated sensitive data discovery for an Amazon Macie account. Possible values are:</p>', 'refs' => [ 'AutomatedDiscoveryAccountUpdateError$ErrorCode' => '<p>The error code for the error that caused the request to fail for the account (accountId). Possible values are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you\'re not the Amazon Macie administrator for the account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services Region.</p>', ], ], 'AutomatedDiscoveryMonitoringStatus' => [ 'base' => '<p>Specifies whether automated sensitive data discovery is currently configured to analyze objects in an S3 bucket. Possible values are:</p>', 'refs' => [ 'BucketMetadata$AutomatedDiscoveryMonitoringStatus' => '<p>Specifies whether automated sensitive data discovery is currently configured to analyze objects in the bucket. Possible values are: MONITORED, the bucket is included in analyses; and, NOT_MONITORED, the bucket is excluded from analyses. If automated sensitive data discovery is disabled for your account, this value is NOT_MONITORED.</p>', 'MatchingBucket$AutomatedDiscoveryMonitoringStatus' => '<p>Specifies whether automated sensitive data discovery is currently configured to analyze objects in the bucket. Possible values are: MONITORED, the bucket is included in analyses; and, NOT_MONITORED, the bucket is excluded from analyses. If automated sensitive data discovery is disabled for your account, this value is NOT_MONITORED.</p>', ], ], 'AutomatedDiscoveryStatus' => [ 'base' => '<p>The status of the automated sensitive data discovery configuration for an organization in Amazon Macie or a standalone Macie account. Valid values are:</p>', 'refs' => [ 'GetAutomatedDiscoveryConfigurationResponse$Status' => '<p>The current status of automated sensitive data discovery for the organization or account. Possible values are: ENABLED, use the specified settings to perform automated sensitive data discovery activities; and, DISABLED, don\'t perform automated sensitive data discovery activities.</p>', 'UpdateAutomatedDiscoveryConfigurationRequest$Status' => '<p>The new status of automated sensitive data discovery for the organization or account. Valid values are: ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop performing all automated sensitive data discovery activities.</p> <p>If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery for all member accounts in the organization.</p>', ], ], 'AvailabilityCode' => [ 'base' => '<p>Specifies whether occurrences of sensitive data can be retrieved for a finding. Possible values are:</p>', 'refs' => [ 'GetSensitiveDataOccurrencesAvailabilityResponse$Code' => '<p>Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are: AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can\'t be retrieved. If this value is UNAVAILABLE, the reasons array indicates why the data can\'t be retrieved.</p>', ], ], 'AwsAccount' => [ 'base' => '<p>Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for an Amazon Web Services account other than your own account.</p>', 'refs' => [ 'UserIdentity$AwsAccount' => '<p>If the action was performed using the credentials for another Amazon Web Services account, the details of that account.</p>', ], ], 'AwsService' => [ 'base' => '<p>Provides information about an Amazon Web Service that performed an action on an affected resource.</p>', 'refs' => [ 'UserIdentity$AwsService' => '<p>If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.</p>', ], ], 'BatchGetCustomDataIdentifierSummary' => [ 'base' => '<p>Provides information about a custom data identifier.</p>', 'refs' => [ '__listOfBatchGetCustomDataIdentifierSummary$member' => NULL, ], ], 'BatchGetCustomDataIdentifiersRequest' => [ 'base' => '<p>Specifies one or more custom data identifiers to retrieve information about.</p>', 'refs' => [], ], 'BatchGetCustomDataIdentifiersResponse' => [ 'base' => '<p>Provides information about one or more custom data identifiers.</p>', 'refs' => [], ], 'BatchUpdateAutomatedDiscoveryAccountsRequest' => [ 'base' => '<p>Changes the status of automated sensitive data discovery for one or more Amazon Macie accounts.</p>', 'refs' => [], ], 'BatchUpdateAutomatedDiscoveryAccountsResponse' => [ 'base' => '<p>Provides the results of a request to change the status of automated sensitive data discovery for one or more Amazon Macie accounts.</p>', 'refs' => [], ], 'BlockPublicAccess' => [ 'base' => '<p>Provides information about the block public access settings for an S3 bucket. These settings can apply to a bucket at the account or bucket level. For detailed information about each setting, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking public access to your Amazon S3 storage</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'refs' => [ 'AccountLevelPermissions$BlockPublicAccess' => '<p>The block public access settings for the Amazon Web Services account that owns the bucket.</p>', 'BucketLevelPermissions$BlockPublicAccess' => '<p>The block public access settings for the bucket.</p>', ], ], 'BucketCountByEffectivePermission' => [ 'base' => '<p>Provides information about the number of S3 buckets that are publicly accessible due to a combination of permissions settings for each bucket.</p>', 'refs' => [ 'GetBucketStatisticsResponse$BucketCountByEffectivePermission' => '<p>The total number of buckets that are publicly accessible due to a combination of permissions settings for each bucket.</p>', ], ], 'BucketCountByEncryptionType' => [ 'base' => '<p>Provides information about the number of S3 buckets whose settings do or don\'t specify default server-side encryption behavior for objects that are added to the buckets. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'refs' => [ 'GetBucketStatisticsResponse$BucketCountByEncryptionType' => '<p>The total number of buckets whose settings do or don\'t specify default server-side encryption behavior for objects that are added to the buckets.</p>', ], ], 'BucketCountBySharedAccessType' => [ 'base' => '<p>Provides information about the number of S3 buckets that are or aren\'t shared with other Amazon Web Services accounts, Amazon CloudFront origin access identities (OAIs), or CloudFront origin access controls (OACs). In this data, an <i>Amazon Macie organization</i> is defined as a set of Macie accounts that are centrally managed as a group of related accounts through Organizations or by Macie invitation.</p>', 'refs' => [ 'GetBucketStatisticsResponse$BucketCountBySharedAccessType' => '<p>The total number of buckets that are or aren\'t shared with other Amazon Web Services accounts, Amazon CloudFront origin access identities (OAIs), or CloudFront origin access controls (OACs).</p>', ], ], 'BucketCountPolicyAllowsUnencryptedObjectUploads' => [ 'base' => '<p>Provides information about the number of S3 buckets whose bucket policies do or don\'t require server-side encryption of objects when objects are added to the buckets.</p>', 'refs' => [ 'GetBucketStatisticsResponse$BucketCountByObjectEncryptionRequirement' => '<p>The total number of buckets whose bucket policies do or don\'t require server-side encryption of objects when objects are added to the buckets.</p>', ], ], 'BucketCriteria' => [ 'base' => '<p>Specifies, as a map, one or more property-based conditions that filter the results of a query for information about S3 buckets.</p>', 'refs' => [ 'DescribeBucketsRequest$Criteria' => '<p>The criteria to use to filter the query results.</p>', ], ], 'BucketCriteriaAdditionalProperties' => [ 'base' => '<p>Specifies the operator to use in a property-based condition that filters the results of a query for information about S3 buckets.</p>', 'refs' => [ 'BucketCriteria$member' => NULL, ], ], 'BucketLevelPermissions' => [ 'base' => '<p>Provides information about the bucket-level permissions settings for an S3 bucket.</p>', 'refs' => [ 'BucketPermissionConfiguration$BucketLevelPermissions' => '<p>The bucket-level permissions settings for the bucket.</p>', ], ], 'BucketMetadata' => [ 'base' => '<p>Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. By default, object count and storage size values include data for object parts that are the result of incomplete multipart uploads. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/monitoring-s3-how-it-works.html">How Macie monitors Amazon S3 data security</a> in the <i>Amazon Macie User Guide</i>.</p> <p>If an error occurs when Macie attempts to retrieve and process metadata from Amazon S3 for the bucket or the bucket\'s objects, the value for the versioning property is false and the value for most other properties is null. Key exceptions are accountId, bucketArn, bucketCreatedAt, bucketName, lastUpdated, and region. To identify the cause of the error, refer to the errorCode and errorMessage values.</p>', 'refs' => [ '__listOfBucketMetadata$member' => NULL, ], ], 'BucketMetadataErrorCode' => [ 'base' => '<p>The error code for an error that prevented Amazon Macie from retrieving and processing information about an S3 bucket and the bucket\'s objects.</p>', 'refs' => [ 'BucketMetadata$ErrorCode' => '<p>The error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket\'s objects. If this value is ACCESS_DENIED, Macie doesn\'t have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>', 'MatchingBucket$ErrorCode' => '<p>The error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket\'s objects. If this value is ACCESS_DENIED, Macie doesn\'t have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>', ], ], 'BucketPermissionConfiguration' => [ 'base' => '<p>Provides information about the account-level and bucket-level permissions settings for an S3 bucket.</p>', 'refs' => [ 'BucketPublicAccess$PermissionConfiguration' => '<p>The account-level and bucket-level permissions settings for the bucket.</p>', ], ], 'BucketPolicy' => [ 'base' => '<p>Provides information about the permissions settings of the bucket policy for an S3 bucket.</p>', 'refs' => [ 'BucketLevelPermissions$BucketPolicy' => '<p>The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn\'t been defined for the bucket.</p>', ], ], 'BucketPublicAccess' => [ 'base' => '<p>Provides information about the permissions settings that determine whether an S3 bucket is publicly accessible.</p>', 'refs' => [ 'BucketMetadata$PublicAccess' => '<p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.</p>', 'S3Bucket$PublicAccess' => '<p>The permissions settings that determine whether the bucket is publicly accessible.</p>', ], ], 'BucketServerSideEncryption' => [ 'base' => '<p>Provides information about the default server-side encryption settings for an S3 bucket. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'refs' => [ 'BucketMetadata$ServerSideEncryption' => '<p>The default server-side encryption settings for the bucket.</p>', ], ], 'BucketSortCriteria' => [ 'base' => '<p>Specifies criteria for sorting the results of a query for information about S3 buckets.</p>', 'refs' => [ 'DescribeBucketsRequest$SortCriteria' => '<p>The criteria to use to sort the query results.</p>', ], ], 'BucketStatisticsBySensitivity' => [ 'base' => '<p>Provides aggregated statistical data for sensitive data discovery metrics that apply to S3 buckets, grouped by bucket sensitivity score (sensitivityScore). If automated sensitive data discovery is currently disabled for your account, the value for each metric is 0.</p>', 'refs' => [ 'GetBucketStatisticsResponse$BucketStatisticsBySensitivity' => '<p>The aggregated sensitive data discovery statistics for the buckets. If automated sensitive data discovery is currently disabled for your account, the value for each statistic is 0.</p>', ], ], 'Cell' => [ 'base' => '<p>Specifies the location of an occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.</p>', 'refs' => [ 'Cells$member' => NULL, ], ], 'Cells' => [ 'base' => '<p>Specifies the location of occurrences of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.</p>', 'refs' => [ 'Occurrences$Cells' => '<p>An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.</p> <p>Each Cell object specifies a cell or field that contains the sensitive data.</p>', ], ], 'ClassificationDetails' => [ 'base' => '<p>Provides information about a sensitive data finding and the details of the finding.</p>', 'refs' => [ 'Finding$ClassificationDetails' => '<p>The details of a sensitive data finding. This value is null for a policy finding.</p>', ], ], 'ClassificationExportConfiguration' => [ 'base' => '<p>Specifies where to store data classification results, and the encryption settings to use when storing results in that location. The location must be an S3 general purpose bucket.</p>', 'refs' => [ 'GetClassificationExportConfigurationResponse$Configuration' => '<p>The location where data classification results are stored, and the encryption settings that are used when storing results in that location.</p>', 'PutClassificationExportConfigurationRequest$Configuration' => '<p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>', 'PutClassificationExportConfigurationResponse$Configuration' => '<p>The location where the data classification results are stored, and the encryption settings that are used when storing results in that location.</p>', ], ], 'ClassificationResult' => [ 'base' => '<p>Provides the details of a sensitive data finding, including the types, number of occurrences, and locations of the sensitive data that was detected.</p>', 'refs' => [ 'ClassificationDetails$Result' => '<p>The status and other details of the finding.</p>', ], ], 'ClassificationResultStatus' => [ 'base' => '<p>Provides information about the status of a sensitive data finding.</p>', 'refs' => [ 'ClassificationResult$Status' => '<p>The status of the finding.</p>', ], ], 'ClassificationScopeId' => [ 'base' => '<p>The unique identifier the classification scope.</p>', 'refs' => [ 'ClassificationScopeSummary$Id' => '<p>The unique identifier for the classification scope.</p>', 'GetAutomatedDiscoveryConfigurationResponse$ClassificationScopeId' => '<p>The unique identifier for the classification scope that\'s used when performing automated sensitive data discovery. The classification scope specifies S3 buckets to exclude from analyses.</p>', 'GetClassificationScopeResponse$Id' => '<p>The unique identifier for the classification scope.</p>', ], ], 'ClassificationScopeName' => [ 'base' => '<p>The name of the classification scope.</p>', 'refs' => [ 'ClassificationScopeSummary$Name' => '<p>The name of the classification scope: automated-sensitive-data-discovery.</p>', 'GetClassificationScopeResponse$Name' => '<p>The name of the classification scope: automated-sensitive-data-discovery.</p>', ], ], 'ClassificationScopeSummary' => [ 'base' => '<p>Provides information about the classification scope for an Amazon Macie account. Macie uses the scope\'s settings when it performs automated sensitive data discovery for the account.</p>', 'refs' => [ '__listOfClassificationScopeSummary$member' => NULL, ], ], 'ClassificationScopeUpdateOperation' => [ 'base' => '<p>Specifies how to apply changes to the S3 bucket exclusion list defined by the classification scope for an Amazon Macie account. Valid values are:</p>', 'refs' => [ 'S3ClassificationScopeExclusionUpdate$Operation' => '<p>Specifies how to apply the changes to the exclusion list. Valid values are:</p> <ul><li><p>ADD - Append the specified bucket names to the current list.</p></li> <li><p>REMOVE - Remove the specified bucket names from the current list.</p></li> <li><p>REPLACE - Overwrite the current list with the specified list of bucket names. If you specify this value, Amazon Macie removes all existing names from the list and adds all the specified names to the list.</p></li></ul>', ], ], 'ConflictException' => [ 'base' => '<p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>', 'refs' => [], ], 'CreateAllowListRequest' => [ 'base' => '<p>Specifies the settings for an allow list. When Amazon Macie processes the request, Macie tests the list\'s criteria. If the criteria specify a regular expression that Macie can\'t compile or an S3 object that Macie can\'t retrieve or parse, an error occurs.</p>', 'refs' => [], ], 'CreateAllowListResponse' => [ 'base' => '<p>Provides information about an allow list that was created in response to a request.</p>', 'refs' => [], ], 'CreateClassificationJobRequest' => [ 'base' => '<p>Specifies the scope, schedule, and other settings for a classification job. You can\'t change any settings for a classification job after you create it. This helps to ensure that you have an immutable history of sensitive data findings and discovery results for data privacy and protection audits or investigations.</p>', 'refs' => [], ], 'CreateClassificationJobResponse' => [ 'base' => '<p>Provides information about a classification job that was created in response to a request.</p>', 'refs' => [], ], 'CreateCustomDataIdentifierRequest' => [ 'base' => '<p>Specifies the detection criteria and other settings for a custom data identifier. You can\'t change a custom data identifier after you create it. This helps to ensure that you have an immutable history of sensitive data findings and discovery results for data privacy and protection audits or investigations.</p>', 'refs' => [], ], 'CreateCustomDataIdentifierResponse' => [ 'base' => '<p>Provides information about a custom data identifier that was created in response to a request.</p>', 'refs' => [], ], 'CreateFindingsFilterRequest' => [ 'base' => '<p>Specifies the criteria and other settings for a new findings filter.</p>', 'refs' => [], ], 'CreateFindingsFilterResponse' => [ 'base' => '<p>Provides information about a findings filter that was created in response to a request.</p>', 'refs' => [], ], 'CreateInvitationsRequest' => [ 'base' => '<p>Specifies the settings for an Amazon Macie membership invitation. When you send an invitation, Macie notifies the recipient by creating an Health event for the recipient\'s account and, if Macie is already enabled for the account, displaying an <b>Accounts</b> badge and notification on the recipient\'s console. You can optionally notify the recipient by also sending the invitation as an email message.</p>', 'refs' => [], ], 'CreateInvitationsResponse' => [ 'base' => '<p>Provides information about an unprocessed request to send an Amazon Macie membership invitation to a specific account.</p>', 'refs' => [], ], 'CreateMemberRequest' => [ 'base' => '<p>Specifies an Amazon Web Services account to associate with an Amazon Macie administrator account.</p>', 'refs' => [], ], 'CreateMemberResponse' => [ 'base' => '<p>Provides information about a request to associate an account with an Amazon Macie administrator account.</p>', 'refs' => [], ], 'CreateSampleFindingsRequest' => [ 'base' => '<p>Specifies the types of sample findings to create.</p>', 'refs' => [], ], 'CriteriaBlockForJob' => [ 'base' => '<p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 buckets from a classification job.</p>', 'refs' => [ 'S3BucketCriteriaForJob$Excludes' => '<p>The property- and tag-based conditions that determine which buckets to exclude from the job.</p>', 'S3BucketCriteriaForJob$Includes' => '<p>The property- and tag-based conditions that determine which buckets to include in the job.</p>', ], ], 'CriteriaForJob' => [ 'base' => '<p>Specifies a property- or tag-based condition that defines criteria for including or excluding S3 buckets from a classification job.</p>', 'refs' => [ '__listOfCriteriaForJob$member' => NULL, ], ], 'Criterion' => [ 'base' => '<p>Specifies a condition that defines a property, operator, and one or more values to filter the results of a query for findings. The number of values depends on the property and operator specified by the condition. For information about defining filter conditions, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html">Fundamentals of filtering findings</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'FindingCriteria$Criterion' => '<p>A condition that specifies the property, operator, and one or more values to use to filter the results.</p>', ], ], 'CriterionAdditionalProperties' => [ 'base' => '<p>Specifies the operator to use in a property-based condition that filters the results of a query for findings. For detailed information and examples of each operator, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html">Fundamentals of filtering findings</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'Criterion$member' => NULL, ], ], 'Currency' => [ 'base' => '<p>The type of currency that the data for an Amazon Macie usage metric is reported in. Possible values are:</p>', 'refs' => [ 'UsageByAccount$Currency' => '<p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>', 'UsageTotal$Currency' => '<p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>', ], ], 'CustomDataIdentifierSummary' => [ 'base' => '<p>Provides information about a custom data identifier.</p>', 'refs' => [ '__listOfCustomDataIdentifierSummary$member' => NULL, ], ], 'CustomDataIdentifiers' => [ 'base' => '<p>Provides information about custom data identifiers that produced a sensitive data finding, and the number of occurrences of the data that they detected for the finding.</p>', 'refs' => [ 'ClassificationResult$CustomDataIdentifiers' => '<p>The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.</p>', ], ], 'CustomDetection' => [ 'base' => '<p>Provides information about a custom data identifier that produced a sensitive data finding, and the sensitive data that it detected for the finding.</p>', 'refs' => [ 'CustomDetections$member' => NULL, ], ], 'CustomDetections' => [ 'base' => '<p>Provides information about custom data identifiers that produced a sensitive data finding, and the number of occurrences of the data that each identifier detected.</p>', 'refs' => [ 'CustomDataIdentifiers$Detections' => '<p>The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.</p>', ], ], 'DailySchedule' => [ 'base' => '<p>Specifies that a classification job runs once a day, every day. This is an empty object.</p>', 'refs' => [ 'JobScheduleFrequency$DailySchedule' => '<p>Specifies a daily recurrence pattern for running the job.</p>', ], ], 'DataIdentifierSeverity' => [ 'base' => '<p>The severity of a finding, ranging from LOW, for least severe, to HIGH, for most severe. Valid values are:</p>', 'refs' => [ 'SeverityLevel$Severity' => '<p>The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.</p>', ], ], 'DataIdentifierType' => [ 'base' => '<p>The type of data identifier that detected a specific type of sensitive data in an S3 bucket. Possible values are:</p>', 'refs' => [ 'Detection$Type' => '<p>The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data identifier; and, MANAGED, for a managed data identifier.</p>', 'SuppressDataIdentifier$Type' => '<p>The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data identifier; and, MANAGED, for a managed data identifier.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'WeeklySchedule$DayOfWeek' => '<p>The day of the week when Amazon Macie runs the job.</p>', ], ], 'DeclineInvitationsRequest' => [ 'base' => '<p>Specifies one or more accounts that sent Amazon Macie membership invitations to decline.</p>', 'refs' => [], ], 'DeclineInvitationsResponse' => [ 'base' => '<p>Provides information about unprocessed requests to decline Amazon Macie membership invitations that were received from specific accounts.</p>', 'refs' => [], ], 'DefaultDetection' => [ 'base' => '<p>Provides information about a type of sensitive data that was detected by a managed data identifier and produced a sensitive data finding.</p>', 'refs' => [ 'DefaultDetections$member' => NULL, ], ], 'DefaultDetections' => [ 'base' => '<p>Provides information about sensitive data that was detected by managed data identifiers and produced a sensitive data finding, and the number of occurrences of each type of sensitive data that was detected.</p>', 'refs' => [ 'SensitiveDataItem$Detections' => '<p>An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.</p>', ], ], 'DeleteInvitationsRequest' => [ 'base' => '<p>Specifies one or more accounts that sent Amazon Macie membership invitations to delete.</p>', 'refs' => [], ], 'DeleteInvitationsResponse' => [ 'base' => '<p>Provides information about unprocessed requests to delete Amazon Macie membership invitations that were received from specific accounts.</p>', 'refs' => [], ], 'DescribeBucketsRequest' => [ 'base' => '<p>Specifies criteria for filtering, sorting, and paginating the results of a query for statistical data and other information about S3 buckets.</p>', 'refs' => [], ], 'DescribeBucketsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes for your account.</p>', 'refs' => [], ], 'DescribeClassificationJobResponse' => [ 'base' => '<p>Provides information about a classification job, including the current configuration settings and status of the job.</p>', 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => '<p>Provides information about the Amazon Macie configuration for an organization in Organizations.</p>', 'refs' => [], ], 'DetectedDataDetails' => [ 'base' => '<p>Specifies 1-10 occurrences of a specific type of sensitive data reported by a finding.</p>', 'refs' => [ '__listOfDetectedDataDetails$member' => NULL, ], ], 'Detection' => [ 'base' => '<p>Provides information about a type of sensitive data that Amazon Macie found in an S3 bucket while performing automated sensitive data discovery for an account. The information also specifies the custom or managed data identifier that detected the data. This information is available only if automated sensitive data discovery has been enabled for the account.</p>', 'refs' => [ '__listOfDetection$member' => NULL, ], ], 'DomainDetails' => [ 'base' => '<p>Provides information about the domain name of the device that an entity used to perform an action on an affected resource.</p>', 'refs' => [ 'FindingActor$DomainDetails' => '<p>The domain name of the device that the entity used to perform the action on the affected resource.</p>', ], ], 'EffectivePermission' => [ 'base' => NULL, 'refs' => [ 'BucketPublicAccess$EffectivePermission' => ' <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:</p> <ul><li><p>NOT_PUBLIC - The bucket isn\'t publicly accessible.</p></li> <li><p>PUBLIC - The bucket is publicly accessible.</p></li> <li><p>UNKNOWN - Amazon Macie can\'t determine whether the bucket is publicly accessible.</p></li></ul>', ], ], 'Empty' => [ 'base' => '<p>The request succeeded and there isn\'t any content to include in the body of the response (No Content).</p>', 'refs' => [], ], 'EnableMacieRequest' => [ 'base' => '<p>Enables Amazon Macie and specifies the configuration settings for a Macie account.</p>', 'refs' => [], ], 'EnableOrganizationAdminAccountRequest' => [ 'base' => '<p>Specifies an account to designate as the delegated Amazon Macie administrator account for an organization in Organizations. To submit this request, you must be a user of the Organizations management account.</p>', 'refs' => [], ], 'EncryptionType' => [ 'base' => '<p>The server-side encryption algorithm that was used to encrypt an S3 object or is used by default to encrypt objects that are added to an S3 bucket. Possible values are:</p>', 'refs' => [ 'ServerSideEncryption$EncryptionType' => '<p>The server-side encryption algorithm that\'s used when storing data in the bucket or object. If default encryption settings aren\'t configured for the bucket or the object isn\'t encrypted using server-side encryption, this value is NONE.</p>', ], ], 'ErrorCode' => [ 'base' => '<p>The source of an issue or delay. Possible values are:</p>', 'refs' => [ 'UnprocessedAccount$ErrorCode' => '<p>The source of the issue or delay in processing the request.</p>', ], ], 'FederatedUser' => [ 'base' => '<p>Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the GetFederationToken operation of the Security Token Service (STS) API.</p>', 'refs' => [ 'UserIdentity$FederatedUser' => '<p>If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>', ], ], 'Finding' => [ 'base' => '<p>Provides the details of a finding.</p>', 'refs' => [ '__listOfFinding$member' => NULL, ], ], 'FindingAction' => [ 'base' => '<p>Provides information about an action that occurred for a resource and produced a policy finding.</p>', 'refs' => [ 'PolicyDetails$Action' => '<p>The action that produced the finding.</p>', ], ], 'FindingActionType' => [ 'base' => '<p>The type of action that occurred for the resource and produced the policy finding:</p>', 'refs' => [ 'FindingAction$ActionType' => '<p>The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.</p>', ], ], 'FindingActor' => [ 'base' => '<p>Provides information about an entity that performed an action that produced a policy finding for a resource.</p>', 'refs' => [ 'PolicyDetails$Actor' => '<p>The entity that performed the action that produced the finding.</p>', ], ], 'FindingCategory' => [ 'base' => '<p>The category of the finding. Possible values are:</p>', 'refs' => [ 'Finding$Category' => '<p>The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.</p>', ], ], 'FindingCriteria' => [ 'base' => '<p>Specifies, as a map, one or more property-based conditions that filter the results of a query for findings.</p>', 'refs' => [ 'CreateFindingsFilterRequest$FindingCriteria' => '<p>The criteria to use to filter findings.</p>', 'GetFindingStatisticsRequest$FindingCriteria' => '<p>The criteria to use to filter the query results.</p>', 'GetFindingsFilterResponse$FindingCriteria' => '<p>The criteria that\'s used to filter findings.</p>', 'ListFindingsRequest$FindingCriteria' => '<p>The criteria to use to filter the results.</p>', 'UpdateFindingsFilterRequest$FindingCriteria' => '<p>The criteria to use to filter findings.</p>', ], ], 'FindingPublishingFrequency' => [ 'base' => '<p>The frequency with which Amazon Macie publishes updates to policy findings for an account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly Amazon CloudWatch Events). For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-monitor.html">Monitoring and processing findings</a> in the <i>Amazon Macie User Guide</i>. Valid values are:</p>', 'refs' => [ 'EnableMacieRequest$FindingPublishingFrequency' => '<p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly Amazon CloudWatch Events).</p>', 'GetMacieSessionResponse$FindingPublishingFrequency' => '<p>The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly Amazon CloudWatch Events).</p>', 'UpdateMacieSessionRequest$FindingPublishingFrequency' => '<p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly Amazon CloudWatch Events).</p>', ], ], 'FindingStatisticsSortAttributeName' => [ 'base' => '<p>The grouping to sort the results by. Valid values are:</p>', 'refs' => [ 'FindingStatisticsSortCriteria$AttributeName' => '<p>The grouping to sort the results by. Valid values are: count, sort the results by the number of findings in each group of results; and, groupKey, sort the results by the name of each group of results.</p>', ], ], 'FindingStatisticsSortCriteria' => [ 'base' => '<p>Specifies criteria for sorting the results of a query that retrieves aggregated statistical data about findings.</p>', 'refs' => [ 'GetFindingStatisticsRequest$SortCriteria' => '<p>The criteria to use to sort the query results.</p>', ], ], 'FindingType' => [ 'base' => '<p>The type of finding. For details about each type, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-types.html">Types of Amazon Macie findings</a> in the <i>Amazon Macie User Guide</i>. Possible values are:</p>', 'refs' => [ 'Finding$Type' => '<p>The type of the finding.</p>', '__listOfFindingType$member' => NULL, ], ], 'FindingsFilterAction' => [ 'base' => '<p>The action to perform on findings that match the filter criteria. To suppress (automatically archive) findings that match the criteria, set this value to ARCHIVE. Valid values are:</p>', 'refs' => [ 'CreateFindingsFilterRequest$Action' => '<p>The action to perform on findings that match the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don\'t perform any action on the findings.</p>', 'FindingsFilterListItem$Action' => '<p>The action that\'s performed on findings that match the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don\'t perform any action on the findings.</p>', 'GetFindingsFilterResponse$Action' => '<p>The action that\'s performed on findings that match the filter criteria (findingCriteria). Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don\'t perform any action on the findings.</p>', 'UpdateFindingsFilterRequest$Action' => '<p>The action to perform on findings that match the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don\'t perform any action on the findings.</p>', ], ], 'FindingsFilterListItem' => [ 'base' => '<p>Provides information about a findings filter.</p>', 'refs' => [ '__listOfFindingsFilterListItem$member' => NULL, ], ], 'GetAdministratorAccountResponse' => [ 'base' => '<p>Provides information about the Amazon Macie administrator account for an account. If the accounts are associated by a Macie membership invitation, the response also provides information about that invitation.</p>', 'refs' => [], ], 'GetAllowListResponse' => [ 'base' => '<p>Provides information about the settings and status of an allow list.</p>', 'refs' => [], ], 'GetAutomatedDiscoveryConfigurationResponse' => [ 'base' => '<p>Provides information about the configuration settings and status of automated sensitive data discovery for an organization in Amazon Macie or a standalone Macie account.</p>', 'refs' => [], ], 'GetBucketStatisticsRequest' => [ 'base' => '<p>Specifies the account that owns the S3 buckets to retrieve aggregated statistical data for.</p>', 'refs' => [], ], 'GetBucketStatisticsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes for your account. By default, object count and storage size values include data for object parts that are the result of incomplete multipart uploads. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/monitoring-s3-how-it-works.html">How Macie monitors Amazon S3 data security</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [], ], 'GetClassificationExportConfigurationResponse' => [ 'base' => '<p>Provides information about the current configuration settings for storing data classification results.</p>', 'refs' => [], ], 'GetClassificationScopeResponse' => [ 'base' => '<p>Provides information about the classification scope settings for an Amazon Macie account. Macie uses these settings when it performs automated sensitive data discovery for the account.</p>', 'refs' => [], ], 'GetCustomDataIdentifierResponse' => [ 'base' => '<p>Provides information about the detection criteria and other settings for a custom data identifier.</p>', 'refs' => [], ], 'GetFindingStatisticsRequest' => [ 'base' => '<p>Specifies criteria for filtering, grouping, sorting, and paginating the results of a query that retrieves aggregated statistical data about findings.</p>', 'refs' => [], ], 'GetFindingStatisticsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved aggregated statistical data about findings.</p>', 'refs' => [], ], 'GetFindingsFilterResponse' => [ 'base' => '<p>Provides information about the criteria and other settings for a findings filter.</p>', 'refs' => [], ], 'GetFindingsPublicationConfigurationResponse' => [ 'base' => '<p>Provides information about the current configuration settings for publishing findings to Security Hub automatically.</p>', 'refs' => [], ], 'GetFindingsRequest' => [ 'base' => '<p>Specifies one or more findings to retrieve.</p>', 'refs' => [], ], 'GetFindingsResponse' => [ 'base' => '<p>Provides the results of a request for one or more findings.</p>', 'refs' => [], ], 'GetInvitationsCountResponse' => [ 'base' => '<p>Provides the count of all the Amazon Macie membership invitations that were received by an account, not including the currently accepted invitation.</p>', 'refs' => [], ], 'GetMacieSessionResponse' => [ 'base' => '<p>Provides information about the status and configuration settings for an Amazon Macie account.</p>', 'refs' => [], ], 'GetMasterAccountResponse' => [ 'base' => '<p>(Deprecated) Provides information about the Amazon Macie administrator account for an account. If the accounts are associated by a Macie membership invitation, the response also provides information about that invitation.</p>', 'refs' => [], ], 'GetMemberResponse' => [ 'base' => '<p>Provides information about an account that\'s associated with an Amazon Macie administrator account.</p>', 'refs' => [], ], 'GetResourceProfileResponse' => [ 'base' => '<p>Provides sensitive data discovery statistics and the sensitivity score for an S3 bucket that Amazon Macie monitors and analyzes for an account. This data is available only if automated sensitive data discovery has been enabled for the account.</p>', 'refs' => [], ], 'GetRevealConfigurationResponse' => [ 'base' => '<p>Provides information about the configuration settings for retrieving occurrences of sensitive data reported by findings, and the status of the configuration for an Amazon Macie account.</p>', 'refs' => [], ], 'GetSensitiveDataOccurrencesAvailabilityResponse' => [ 'base' => '<p>Provides information about whether occurrences of sensitive data can be retrieved for a finding and, if not, why the data can\'t be retrieved.</p>', 'refs' => [], ], 'GetSensitiveDataOccurrencesResponse' => [ 'base' => '<p>Provides the results of a request to retrieve occurrences of sensitive data reported by a finding.</p>', 'refs' => [], ], 'GetSensitivityInspectionTemplateResponse' => [ 'base' => '<p>Provides information about the settings for the sensitivity inspection template for an Amazon Macie account.</p>', 'refs' => [], ], 'GetUsageStatisticsRequest' => [ 'base' => '<p>Specifies criteria for filtering, sorting, and paginating the results of a query for quotas and aggregated usage data for one or more Amazon Macie accounts.</p>', 'refs' => [], ], 'GetUsageStatisticsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved quotas and aggregated usage data for one or more Amazon Macie accounts.</p>', 'refs' => [], ], 'GetUsageTotalsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved aggregated usage data for an Amazon Macie account.</p>', 'refs' => [], ], 'GroupBy' => [ 'base' => NULL, 'refs' => [ 'GetFindingStatisticsRequest$GroupBy' => '<p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>', ], ], 'GroupCount' => [ 'base' => '<p>Provides a group of results for a query that retrieved aggregated statistical data about findings.</p>', 'refs' => [ '__listOfGroupCount$member' => NULL, ], ], 'IamUser' => [ 'base' => '<p>Provides information about an Identity and Access Management (IAM) user who performed an action on an affected resource.</p>', 'refs' => [ 'UserIdentity$IamUser' => '<p>If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>', 'refs' => [], ], 'Invitation' => [ 'base' => '<p>Provides information about an Amazon Macie membership invitation.</p>', 'refs' => [ 'GetAdministratorAccountResponse$Administrator' => '<p>The Amazon Web Services account ID for the administrator account. If the accounts are associated by an Amazon Macie membership invitation, this object also provides details about the invitation that was sent to establish the relationship between the accounts.</p>', 'GetMasterAccountResponse$Master' => '<p>(Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are associated by a Macie membership invitation, this object also provides details about the invitation that was sent to establish the relationship between the accounts.</p>', '__listOfInvitation$member' => NULL, ], ], 'IpAddressDetails' => [ 'base' => '<p>Provides information about the IP address of the device that an entity used to perform an action on an affected resource.</p>', 'refs' => [ 'FindingActor$IpAddressDetails' => '<p>The IP address and related details about the device that the entity used to perform the action on the affected resource. The details can include information such as the owner and geographic location of the IP address.</p>', ], ], 'IpCity' => [ 'base' => '<p>Provides information about the city that an IP address originated from.</p>', 'refs' => [ 'IpAddressDetails$IpCity' => '<p>The city that the IP address originated from.</p>', ], ], 'IpCountry' => [ 'base' => '<p>Provides information about the country that an IP address originated from.</p>', 'refs' => [ 'IpAddressDetails$IpCountry' => '<p>The country that the IP address originated from.</p>', ], ], 'IpGeoLocation' => [ 'base' => '<p>Provides geographic coordinates that indicate where a specified IP address originated from.</p>', 'refs' => [ 'IpAddressDetails$IpGeoLocation' => '<p>The geographic coordinates of the location that the IP address originated from.</p>', ], ], 'IpOwner' => [ 'base' => '<p>Provides information about the registered owner of an IP address.</p>', 'refs' => [ 'IpAddressDetails$IpOwner' => '<p>The registered owner of the IP address.</p>', ], ], 'IsDefinedInJob' => [ 'base' => NULL, 'refs' => [ 'JobDetails$IsDefinedInJob' => '<p>Specifies whether any one-time or recurring jobs are configured to analyze objects in the bucket. Possible values are:</p> <ul><li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.</p></li> <li><p>FALSE - The bucket isn\'t explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn\'t match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.</p></li> <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li></ul>', ], ], 'IsMonitoredByJob' => [ 'base' => NULL, 'refs' => [ 'JobDetails$IsMonitoredByJob' => '<p>Specifies whether any recurring jobs are configured to analyze objects in the bucket. Possible values are:</p> <ul><li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.</p></li> <li><p>FALSE - The bucket isn\'t explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn\'t match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.</p></li> <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li></ul>', ], ], 'JobComparator' => [ 'base' => '<p>The operator to use in a condition. Depending on the type of condition, possible values are:</p>', 'refs' => [ 'ListJobsFilterTerm$Comparator' => '<p>The operator to use to filter the results.</p>', 'SimpleCriterionForJob$Comparator' => '<p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>', 'SimpleScopeTerm$Comparator' => '<p>The operator to use in the condition. Valid values for each supported property (key) are:</p> <ul><li><p>OBJECT_EXTENSION - EQ (equals) or NE (not equals)</p></li> <li><p>OBJECT_KEY - STARTS_WITH</p></li> <li><p>OBJECT_LAST_MODIFIED_DATE - EQ (equals), GT (greater than), GTE (greater than or equals), LT (less than), LTE (less than or equals), or NE (not equals)</p></li> <li><p>OBJECT_SIZE - EQ (equals), GT (greater than), GTE (greater than or equals), LT (less than), LTE (less than or equals), or NE (not equals)</p></li></ul>', 'TagCriterionForJob$Comparator' => '<p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>', 'TagScopeTerm$Comparator' => '<p>The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).</p>', ], ], 'JobDetails' => [ 'base' => '<p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in an S3 bucket, and, if so, the details of the job that ran most recently.</p>', 'refs' => [ 'BucketMetadata$JobDetails' => '<p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>', 'MatchingBucket$JobDetails' => '<p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>', ], ], 'JobScheduleFrequency' => [ 'base' => '<p>Specifies the recurrence pattern for running a classification job.</p>', 'refs' => [ 'CreateClassificationJobRequest$ScheduleFrequency' => '<p>The recurrence pattern for running the job. To run the job only once, don\'t specify a value for this property and set the value for the jobType property to ONE_TIME.</p>', 'DescribeClassificationJobResponse$ScheduleFrequency' => '<p>The recurrence pattern for running the job. This value is null if the job is configured to run only once.</p>', ], ], 'JobScopeTerm' => [ 'base' => '<p>Specifies a property- or tag-based condition that defines criteria for including or excluding S3 objects from a classification job. A JobScopeTerm object can contain only one simpleScopeTerm object or one tagScopeTerm object.</p>', 'refs' => [ '__listOfJobScopeTerm$member' => NULL, ], ], 'JobScopingBlock' => [ 'base' => '<p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects from a classification job.</p>', 'refs' => [ 'Scoping$Excludes' => '<p>The property- and tag-based conditions that determine which objects to exclude from the analysis.</p>', 'Scoping$Includes' => '<p>The property- and tag-based conditions that determine which objects to include in the analysis.</p>', ], ], 'JobStatus' => [ 'base' => '<p>The status of a classification job. Possible values are:</p>', 'refs' => [ 'DescribeClassificationJobResponse$JobStatus' => '<p>The current status of the job. Possible values are:</p> <ul><li><p>CANCELLED - You cancelled the job or, if it\'s a one-time job, you paused the job and didn\'t resume it within 30 days.</p></li> <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn\'t apply to recurring jobs.</p></li> <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn\'t apply to one-time jobs.</p></li> <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li> <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li> <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don\'t resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job\'s type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>', 'JobSummary$JobStatus' => '<p>The current status of the job. Possible values are:</p> <ul><li><p>CANCELLED - You cancelled the job or, if it\'s a one-time job, you paused the job and didn\'t resume it within 30 days.</p></li> <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn\'t apply to recurring jobs.</p></li> <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn\'t apply to one-time jobs.</p></li> <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li> <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li> <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don\'t resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job\'s type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>', 'UpdateClassificationJobRequest$JobStatus' => '<p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job\'s current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job\'s current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can\'t resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job\'s current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job\'s current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job\'s current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don\'t resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don\'t resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>', ], ], 'JobSummary' => [ 'base' => '<p>Provides information about a classification job, including the current status of the job.</p>', 'refs' => [ '__listOfJobSummary$member' => NULL, ], ], 'JobType' => [ 'base' => '<p>The schedule for running a classification job. Valid values are:</p>', 'refs' => [ 'CreateClassificationJobRequest$JobType' => '<p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don\'t specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to specify the recurrence pattern for the job.</p></li></ul>', 'DescribeClassificationJobResponse$JobType' => '<p>The schedule for running the job. Possible values are:</p> <ul><li><p>ONE_TIME - The job runs only once.</p></li> <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.</p></li></ul>', 'JobSummary$JobType' => '<p>The schedule for running the job. Possible values are:</p> <ul><li><p>ONE_TIME - The job runs only once.</p></li> <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis.</p></li></ul>', ], ], 'KeyValuePair' => [ 'base' => '<p>Provides information about the tags that are associated with an S3 bucket or object. Each tag consists of a required tag key and an associated tag value.</p>', 'refs' => [ 'KeyValuePairList$member' => NULL, '__listOfKeyValuePair$member' => NULL, ], ], 'KeyValuePairList' => [ 'base' => '<p>Provides information about the tags that are associated with an S3 bucket or object. Each tag consists of a required tag key and an associated tag value.</p>', 'refs' => [ 'S3Bucket$Tags' => '<p>The tags that are associated with the bucket.</p>', 'S3Object$Tags' => '<p>The tags that are associated with the object.</p>', ], ], 'LastRunErrorStatus' => [ 'base' => '<p>Specifies whether any account- or bucket-level access errors occurred when a classification job ran. For information about using logging data to investigate these errors, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-monitor-cw-logs.html">Monitoring sensitive data discovery jobs</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'DescribeClassificationJobResponse$LastRunErrorStatus' => '<p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job\'s most recent run.</p>', 'JobSummary$LastRunErrorStatus' => '<p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job\'s most recent run.</p>', ], ], 'LastRunErrorStatusCode' => [ 'base' => '<p>Specifies whether any account- or bucket-level access errors occurred during the run of a one-time classification job or the most recent run of a recurring classification job. Possible values are:</p>', 'refs' => [ 'LastRunErrorStatus$Code' => '<p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job\'s most recent run. Possible values are:</p> <ul><li><p>ERROR - One or more errors occurred. Amazon Macie didn\'t process all the data specified for the job.</p></li> <li><p>NONE - No errors occurred. Macie processed all the data specified for the job.</p></li></ul>', ], ], 'ListAllowListsResponse' => [ 'base' => '<p>Provides the results of a request for information about allow lists.</p>', 'refs' => [], ], 'ListAutomatedDiscoveryAccountsResponse' => [ 'base' => '<p>Provides information about the status of automated sensitive data discovery for one or more Amazon Macie accounts.</p>', 'refs' => [], ], 'ListClassificationJobsRequest' => [ 'base' => '<p>Specifies criteria for filtering, sorting, and paginating the results of a request for information about classification jobs.</p>', 'refs' => [], ], 'ListClassificationJobsResponse' => [ 'base' => '<p>Provides the results of a request for information about one or more classification jobs.</p>', 'refs' => [], ], 'ListClassificationScopesResponse' => [ 'base' => '<p>Provides the results of a request for information about the classification scope for an Amazon Macie account. Macie uses the scope\'s settings when it performs automated sensitive data discovery for the account.</p>', 'refs' => [], ], 'ListCustomDataIdentifiersRequest' => [ 'base' => '<p>Specifies criteria for paginating the results of a request for information about custom data identifiers.</p>', 'refs' => [], ], 'ListCustomDataIdentifiersResponse' => [ 'base' => '<p>Provides the results of a request for information about custom data identifiers.</p>', 'refs' => [], ], 'ListFindingsFiltersResponse' => [ 'base' => '<p>Provides information about all the findings filters for an account.</p>', 'refs' => [], ], 'ListFindingsRequest' => [ 'base' => '<p>Specifies criteria for filtering, sorting, and paginating the results of a request for information about findings.</p>', 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => '<p>Provides the results of a request for information about one or more findings.</p>', 'refs' => [], ], 'ListInvitationsResponse' => [ 'base' => '<p>Provides information about the Amazon Macie membership invitations that were received by an account.</p>', 'refs' => [], ], 'ListJobsFilterCriteria' => [ 'base' => '<p>Specifies criteria for filtering the results of a request for information about classification jobs.</p>', 'refs' => [ 'ListClassificationJobsRequest$FilterCriteria' => '<p>The criteria to use to filter the results.</p>', ], ], 'ListJobsFilterKey' => [ 'base' => '<p>The property to use to filter the results. Valid values are:</p>', 'refs' => [ 'ListJobsFilterTerm$Key' => '<p>The property to use to filter the results.</p>', ], ], 'ListJobsFilterTerm' => [ 'base' => '<p>Specifies a condition that filters the results of a request for information about classification jobs. Each condition consists of a property, an operator, and one or more values.</p>', 'refs' => [ '__listOfListJobsFilterTerm$member' => NULL, ], ], 'ListJobsSortAttributeName' => [ 'base' => '<p>The property to sort the results by. Valid values are:</p>', 'refs' => [ 'ListJobsSortCriteria$AttributeName' => '<p>The property to sort the results by.</p>', ], ], 'ListJobsSortCriteria' => [ 'base' => '<p>Specifies criteria for sorting the results of a request for information about classification jobs.</p>', 'refs' => [ 'ListClassificationJobsRequest$SortCriteria' => '<p>The criteria to use to sort the results.</p>', ], ], 'ListManagedDataIdentifiersRequest' => [ 'base' => '<p>Specifies criteria for paginating the results of a request for information about managed data identifiers.</p>', 'refs' => [], ], 'ListManagedDataIdentifiersResponse' => [ 'base' => '<p>Provides information about the managed data identifiers that Amazon Macie currently provides.</p>', 'refs' => [], ], 'ListMembersResponse' => [ 'base' => '<p>Provides information about the accounts that are associated with an Amazon Macie administrator account.</p>', 'refs' => [], ], 'ListOrganizationAdminAccountsResponse' => [ 'base' => '<p>Provides information about the delegated Amazon Macie administrator accounts for an organization in Organizations.</p>', 'refs' => [], ], 'ListResourceProfileArtifactsResponse' => [ 'base' => '<p>Provides information about objects that Amazon Macie selected from an S3 bucket while performing automated sensitive data discovery for an account. This information is available only if automated sensitive data discovery has been enabled for the account.</p>', 'refs' => [], ], 'ListResourceProfileDetectionsResponse' => [ 'base' => '<p>Provides information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket while performing automated sensitive data discovery for an account. This information is available only if automated sensitive data discovery has been enabled for the account.</p>', 'refs' => [], ], 'ListSensitivityInspectionTemplatesResponse' => [ 'base' => '<p>Provides the results of a request for information about the sensitivity inspection template for an Amazon Macie account.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>Provides information about the tags (keys and values) that are associated with an Amazon Macie resource.</p>', 'refs' => [], ], 'MacieStatus' => [ 'base' => '<p>The status of an Amazon Macie account. Valid values are:</p>', 'refs' => [ 'EnableMacieRequest$Status' => '<p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>', 'GetMacieSessionResponse$Status' => '<p>The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities are enabled for the account.</p>', 'UpdateMacieSessionRequest$Status' => '<p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>', 'UpdateMemberSessionRequest$Status' => '<p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>', ], ], 'ManagedDataIdentifierSelector' => [ 'base' => '<p>The selection type that determines which managed data identifiers a classification job uses to analyze data. Valid values are:</p>', 'refs' => [ 'CreateClassificationJobRequest$ManagedDataIdentifierSelector' => '<p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all managed data identifiers. If you specify this value, don\'t specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don\'t use any managed data identifiers. If you specify this value, specify at least one value for the customDataIdentifierIds property and don\'t specify any values for the managedDataIdentifierIds property.</p></li> <li><p>RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value, don\'t specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don\'t specify a value for this property, the job uses the recommended set of managed data identifiers.</p> <p>If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed data identifiers that are released. If you don\'t specify a value for this property or you specify RECOMMENDED for a recurring job, each job run automatically uses all the managed data identifiers that are in the recommended set when the run starts.</p> <p>To learn about individual managed data identifiers or determine which ones are in the recommended set, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> or <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', 'DescribeClassificationJobResponse$ManagedDataIdentifierSelector' => '<p>The selection type that determines which managed data identifiers the job uses when it analyzes data. Possible values are:</p> <ul><li><p>ALL - Use all managed data identifiers.</p></li> <li><p>EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don\'t use any managed data identifiers. Use only custom data identifiers (customDataIdentifierIds).</p></li> <li><p>RECOMMENDED (default) - Use the recommended set of managed data identifiers.</p></li></ul> <p>If this value is null, the job uses the recommended set of managed data identifiers.</p> <p>If the job is a recurring job and this value is ALL or EXCLUDE, each job run automatically uses new managed data identifiers that are released. If this value is null or RECOMMENDED for a recurring job, each job run uses all the managed data identifiers that are in the recommended set when the run starts.</p> <p>To learn about individual managed data identifiers or determine which ones are in the recommended set, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> or <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', ], ], 'ManagedDataIdentifierSummary' => [ 'base' => '<p>Provides information about a managed data identifier. For additional information, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ '__listOfManagedDataIdentifierSummary$member' => NULL, ], ], 'MatchingBucket' => [ 'base' => '<p>Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. By default, object count and storage size values include data for object parts that are the result of incomplete multipart uploads. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/monitoring-s3-how-it-works.html">How Macie monitors Amazon S3 data security</a> in the <i>Amazon Macie User Guide</i>.</p> <p>If an error occurs when Macie attempts to retrieve and process information about the bucket or the bucket\'s objects, the value for most of these properties is null. Key exceptions are accountId and bucketName. To identify the cause of the error, refer to the errorCode and errorMessage values.</p>', 'refs' => [ 'MatchingResource$MatchingBucket' => '<p>The details of an S3 bucket that Amazon Macie monitors and analyzes.</p>', ], ], 'MatchingResource' => [ 'base' => '<p>Provides statistical data and other information about an Amazon Web Services resource that Amazon Macie monitors and analyzes for your account.</p>', 'refs' => [ '__listOfMatchingResource$member' => NULL, ], ], 'Member' => [ 'base' => '<p>Provides information about an account that\'s associated with an Amazon Macie administrator account.</p>', 'refs' => [ '__listOfMember$member' => NULL, ], ], 'MonthlySchedule' => [ 'base' => '<p>Specifies a monthly recurrence pattern for running a classification job.</p>', 'refs' => [ 'JobScheduleFrequency$MonthlySchedule' => '<p>Specifies a monthly recurrence pattern for running the job.</p>', ], ], 'NextToken' => [ 'base' => '<p>Specifies which page of results to return in a paginated response.</p>', 'refs' => [ 'ListClassificationScopesResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', ], ], 'ObjectCountByEncryptionType' => [ 'base' => '<p>Provides information about the number of objects that are in an S3 bucket and use certain types of server-side encryption, use client-side encryption, or aren\'t encrypted.</p>', 'refs' => [ 'BucketMetadata$ObjectCountByEncryptionType' => '<p>The total number of objects in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren\'t encrypted or use client-side encryption.</p>', 'MatchingBucket$ObjectCountByEncryptionType' => '<p>The total number of objects in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren\'t encrypted or use client-side encryption.</p>', ], ], 'ObjectLevelStatistics' => [ 'base' => '<p>Provides information about the total storage size (in bytes) or number of objects that Amazon Macie can\'t analyze in one or more S3 buckets. In a BucketMetadata or MatchingBucket object, this data is for a specific bucket. In a GetBucketStatisticsResponse object, this data is aggregated for all the buckets in the query results. If versioning is enabled for a bucket, storage size values are based on the size of the latest version of each applicable object in the bucket.</p>', 'refs' => [ 'BucketMetadata$UnclassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can\'t analyze in the bucket. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'BucketMetadata$UnclassifiableObjectSizeInBytes' => '<p>The total storage size, in bytes, of the objects that Amazon Macie can\'t analyze in the bucket. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'GetBucketStatisticsResponse$UnclassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can\'t analyze in the buckets. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'GetBucketStatisticsResponse$UnclassifiableObjectSizeInBytes' => '<p>The total storage size, in bytes, of the objects that Amazon Macie can\'t analyze in the buckets. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'MatchingBucket$UnclassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can\'t analyze in the bucket. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'MatchingBucket$UnclassifiableObjectSizeInBytes' => '<p>The total storage size, in bytes, of the objects that Amazon Macie can\'t analyze in the bucket. These objects don\'t use a supported storage class or don\'t have a file name extension for a supported file or storage format.</p>', ], ], 'Occurrences' => [ 'base' => '<p>Specifies the location of 1-15 occurrences of sensitive data that was detected by a managed data identifier or a custom data identifier and produced a sensitive data finding.</p>', 'refs' => [ 'CustomDetection$Occurrences' => '<p>The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>', 'DefaultDetection$Occurrences' => '<p>The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>', ], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'BucketSortCriteria$OrderBy' => '<p>The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', 'FindingStatisticsSortCriteria$OrderBy' => '<p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', 'ListJobsSortCriteria$OrderBy' => '<p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', 'SearchResourcesSortCriteria$OrderBy' => '<p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', 'SortCriteria$OrderBy' => '<p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', 'UsageStatisticsSortBy$OrderBy' => '<p>The sort order to apply to the results, based on the value for the field specified by the key property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>', ], ], 'OriginType' => [ 'base' => '<p>Specifies how Amazon Macie found the sensitive data that produced a finding. Possible values are:</p>', 'refs' => [ 'ClassificationDetails$OriginType' => '<p>Specifies how Amazon Macie found the sensitive data that produced the finding. Possible values are: SENSITIVE_DATA_DISCOVERY_JOB, for a classification job; and, AUTOMATED_SENSITIVE_DATA_DISCOVERY, for automated sensitive data discovery.</p>', ], ], 'Page' => [ 'base' => '<p>Specifies the location of an occurrence of sensitive data in an Adobe Portable Document Format file.</p>', 'refs' => [ 'Pages$member' => NULL, ], ], 'Pages' => [ 'base' => '<p>Specifies the location of occurrences of sensitive data in an Adobe Portable Document Format file.</p>', 'refs' => [ 'Occurrences$Pages' => '<p>An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.</p> <p>Each Page object specifies a page that contains the sensitive data.</p>', ], ], 'PolicyDetails' => [ 'base' => '<p>Provides the details of a policy finding.</p>', 'refs' => [ 'Finding$PolicyDetails' => '<p>The details of a policy finding. This value is null for a sensitive data finding.</p>', ], ], 'PutClassificationExportConfigurationRequest' => [ 'base' => '<p>Specifies where to store data classification results, and the encryption settings to use when storing results in that location.</p>', 'refs' => [], ], 'PutClassificationExportConfigurationResponse' => [ 'base' => '<p>Provides information about updated settings for storing data classification results.</p>', 'refs' => [], ], 'PutFindingsPublicationConfigurationRequest' => [ 'base' => '<p>Specifies configuration settings for publishing findings to Security Hub automatically.</p>', 'refs' => [], ], 'Range' => [ 'base' => '<p>Specifies the location of an occurrence of sensitive data in an email message or a non-binary text file such as an HTML, TXT, or XML file.</p>', 'refs' => [ 'Page$LineRange' => ' <p>Reserved for future use.</p>', 'Page$OffsetRange' => ' <p>Reserved for future use.</p>', 'Ranges$member' => NULL, ], ], 'Ranges' => [ 'base' => '<p>Specifies the locations of occurrences of sensitive data in a non-binary text file.</p>', 'refs' => [ 'Occurrences$LineRanges' => '<p>An array of objects, one for each occurrence of sensitive data in an email message or a non-binary text file such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.</p> <p>This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.</p>', 'Occurrences$OffsetRanges' => ' <p>Reserved for future use.</p>', ], ], 'Record' => [ 'base' => '<p>Specifies the location of an occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file.</p>', 'refs' => [ 'Records$member' => NULL, ], ], 'Records' => [ 'base' => '<p>Specifies the locations of occurrences of sensitive data in an Apache Avro object container or a structured data file.</p>', 'refs' => [ 'Occurrences$Records' => '<p>An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p> <p>For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.</p>', ], ], 'RelationshipStatus' => [ 'base' => '<p>The current status of the relationship between an account and an associated Amazon Macie administrator account. Possible values are:</p>', 'refs' => [ 'GetMemberResponse$RelationshipStatus' => '<p>The current status of the relationship between the account and the administrator account.</p>', 'Invitation$RelationshipStatus' => '<p>The status of the relationship between the account that sent the invitation and the account that received the invitation.</p>', 'Member$RelationshipStatus' => '<p>The current status of the relationship between the account and the administrator account.</p>', ], ], 'ReplicationDetails' => [ 'base' => '<p>Provides information about settings that define whether one or more objects in an S3 bucket are replicated to S3 buckets for other Amazon Web Services accounts and, if so, which accounts.</p>', 'refs' => [ 'BucketMetadata$ReplicationDetails' => '<p>Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Provides information about an error that occurred because a specified resource wasn\'t found.</p>', 'refs' => [], ], 'ResourceProfileArtifact' => [ 'base' => '<p>Provides information about an S3 object that Amazon Macie selected for analysis while performing automated sensitive data discovery for an account, and the status and results of the analysis. This information is available only if automated sensitive data discovery has been enabled for the account.</p>', 'refs' => [ '__listOfResourceProfileArtifact$member' => NULL, ], ], 'ResourceStatistics' => [ 'base' => '<p>Provides statistical data for sensitive data discovery metrics that apply to an S3 bucket that Amazon Macie monitors and analyzes for an account, if automated sensitive data discovery has been enabled for the account. The data captures the results of automated sensitive data discovery activities that Macie has performed for the bucket.</p>', 'refs' => [ 'GetResourceProfileResponse$Statistics' => '<p>The sensitive data discovery statistics for the bucket. The statistics capture the results of automated sensitive data discovery activities that Amazon Macie has performed for the bucket.</p>', ], ], 'ResourcesAffected' => [ 'base' => '<p>Provides information about the resources that a finding applies to.</p>', 'refs' => [ 'Finding$ResourcesAffected' => '<p>The resources that the finding applies to.</p>', ], ], 'RetrievalConfiguration' => [ 'base' => '<p>Provides information about the access method and settings that are used to retrieve occurrences of sensitive data reported by findings.</p>', 'refs' => [ 'GetRevealConfigurationResponse$RetrievalConfiguration' => '<p>The access method and settings that are used to retrieve the sensitive data.</p>', 'UpdateRevealConfigurationResponse$RetrievalConfiguration' => '<p>The access method and settings to use when retrieving the sensitive data.</p>', ], ], 'RetrievalMode' => [ 'base' => '<p>The access method to use when retrieving occurrences of sensitive data reported by findings. Valid values are:</p>', 'refs' => [ 'RetrievalConfiguration$RetrievalMode' => '<p>The access method that\'s used to retrieve sensitive data from affected S3 objects. Valid values are: ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access to Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the sensitive data.</p>', 'UpdateRetrievalConfiguration$RetrievalMode' => '<p>The access method to use when retrieving sensitive data from affected S3 objects. Valid values are: ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access to Amazon Macie; and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the sensitive data. If you specify ASSUME_ROLE, also specify the name of an existing IAM role for Macie to assume (roleName).</p> <important><p>If you change this value from ASSUME_ROLE to CALLER_CREDENTIALS for an existing configuration, Macie permanently deletes the external ID and role name currently specified for the configuration. These settings can\'t be recovered after they\'re deleted.</p></important>', ], ], 'RevealConfiguration' => [ 'base' => '<p>Specifies the status of the Amazon Macie configuration for retrieving occurrences of sensitive data reported by findings, and the Key Management Service (KMS) key to use to encrypt sensitive data that\'s retrieved. When you enable the configuration for the first time, your request must specify an KMS key. Otherwise, an error occurs.</p>', 'refs' => [ 'GetRevealConfigurationResponse$Configuration' => '<p>The KMS key that\'s used to encrypt the sensitive data, and the status of the configuration for the Amazon Macie account.</p>', 'UpdateRevealConfigurationRequest$Configuration' => '<p>The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon Macie account.</p>', 'UpdateRevealConfigurationResponse$Configuration' => '<p>The KMS key to use to encrypt the sensitive data, and the status of the configuration for the Amazon Macie account.</p>', ], ], 'RevealRequestStatus' => [ 'base' => '<p>The status of a request to retrieve occurrences of sensitive data reported by a finding. Possible values are:</p>', 'refs' => [ 'GetSensitiveDataOccurrencesResponse$Status' => '<p>The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible values are:</p> <ul><li><p>ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data. The error value indicates the nature of the error that occurred.</p></li> <li><p>PROCESSING - Macie is processing the request.</p></li> <li><p>SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.</p></li></ul>', ], ], 'RevealStatus' => [ 'base' => '<p>The status of the configuration for retrieving occurrences of sensitive data reported by findings. Valid values are:</p>', 'refs' => [ 'RevealConfiguration$Status' => '<p>The status of the configuration for the Amazon Macie account. In a response, possible values are: ENABLED, the configuration is currently enabled for the account; and, DISABLED, the configuration is currently disabled for the account. In a request, valid values are: ENABLED, enable the configuration for the account; and, DISABLED, disable the configuration for the account.</p> <important><p>If you disable the configuration, you also permanently delete current settings that specify how to access affected S3 objects. If your current access method is ASSUME_ROLE, Macie also deletes the external ID and role name currently specified for the configuration. These settings can\'t be recovered after they\'re deleted.</p></important>', ], ], 'S3Bucket' => [ 'base' => '<p>Provides information about the S3 bucket that a finding applies to.</p>', 'refs' => [ 'ResourcesAffected$S3Bucket' => '<p>The details of the S3 bucket that the finding applies to.</p>', ], ], 'S3BucketCriteriaForJob' => [ 'base' => '<p>Specifies property- and tag-based conditions that define criteria for including or excluding S3 buckets from a classification job. Exclude conditions take precedence over include conditions.</p>', 'refs' => [ 'JobSummary$BucketCriteria' => '<p>The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job\'s analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job\'s definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>', 'S3JobDefinition$BucketCriteria' => '<p>The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job\'s definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>', ], ], 'S3BucketDefinitionForJob' => [ 'base' => '<p>Specifies an Amazon Web Services account that owns S3 buckets for a classification job to analyze, and one or more specific buckets to analyze for that account.</p>', 'refs' => [ '__listOfS3BucketDefinitionForJob$member' => NULL, ], ], 'S3BucketName' => [ 'base' => '<p>The name of an S3 bucket.</p>', 'refs' => [ '__listOfS3BucketName$member' => NULL, ], ], 'S3BucketOwner' => [ 'base' => '<p>Provides information about the Amazon Web Services account that owns an S3 bucket.</p>', 'refs' => [ 'S3Bucket$Owner' => '<p>The display name and canonical user ID for the Amazon Web Services account that owns the bucket.</p>', ], ], 'S3ClassificationScope' => [ 'base' => '<p>Specifies the S3 buckets that are excluded from automated sensitive data discovery for an Amazon Macie account.</p>', 'refs' => [ 'GetClassificationScopeResponse$S3' => '<p>The S3 buckets that are excluded from automated sensitive data discovery.</p>', ], ], 'S3ClassificationScopeExclusion' => [ 'base' => '<p>Specifies the names of the S3 buckets that are excluded from automated sensitive data discovery.</p>', 'refs' => [ 'S3ClassificationScope$Excludes' => '<p>The S3 buckets that are excluded.</p>', ], ], 'S3ClassificationScopeExclusionUpdate' => [ 'base' => '<p>Specifies S3 buckets to add or remove from the exclusion list defined by the classification scope for an Amazon Macie account.</p>', 'refs' => [ 'S3ClassificationScopeUpdate$Excludes' => '<p>The names of the S3 buckets to add or remove from the list.</p>', ], ], 'S3ClassificationScopeUpdate' => [ 'base' => '<p>Specifies changes to the list of S3 buckets that are excluded from automated sensitive data discovery for an Amazon Macie account.</p>', 'refs' => [ 'UpdateClassificationScopeRequest$S3' => '<p>The S3 buckets to add or remove from the exclusion list defined by the classification scope.</p>', ], ], 'S3Destination' => [ 'base' => '<p>Specifies an S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>', 'refs' => [ 'ClassificationExportConfiguration$S3Destination' => '<p>The S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>', ], ], 'S3JobDefinition' => [ 'base' => '<p>Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis. The bucket specification can be static (bucketDefinitions) or dynamic (bucketCriteria). If it\'s static, the job analyzes objects in the same predefined set of buckets each time the job runs. If it\'s dynamic, the job analyzes objects in any buckets that match the specified criteria each time the job starts to run.</p>', 'refs' => [ 'CreateClassificationJobRequest$S3JobDefinition' => '<p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>', 'DescribeClassificationJobResponse$S3JobDefinition' => '<p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>', ], ], 'S3Object' => [ 'base' => '<p>Provides information about the S3 object that a finding applies to.</p>', 'refs' => [ 'ResourcesAffected$S3Object' => '<p>The details of the S3 object that the finding applies to.</p>', ], ], 'S3WordsList' => [ 'base' => '<p>Provides information about an S3 object that lists specific text to ignore.</p>', 'refs' => [ 'AllowListCriteria$S3WordsList' => '<p>The location and name of the S3 object that lists specific text to ignore.</p>', ], ], 'ScopeFilterKey' => [ 'base' => '<p>The property to use in a condition that determines whether an S3 object is included or excluded from a classification job. Valid values are:</p>', 'refs' => [ 'SimpleScopeTerm$Key' => '<p>The object property to use in the condition.</p>', ], ], 'Scoping' => [ 'base' => '<p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects from a classification job. Exclude conditions take precedence over include conditions.</p>', 'refs' => [ 'S3JobDefinition$Scoping' => '<p>The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.</p>', ], ], 'SearchResourcesBucketCriteria' => [ 'base' => '<p>Specifies property- and tag-based conditions that define filter criteria for including or excluding S3 buckets from the query results. Exclude conditions take precedence over include conditions.</p>', 'refs' => [ 'SearchResourcesRequest$BucketCriteria' => '<p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>', ], ], 'SearchResourcesComparator' => [ 'base' => '<p>The operator to use in a condition that filters the results of a query. Valid values are:</p>', 'refs' => [ 'SearchResourcesSimpleCriterion$Comparator' => '<p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>', 'SearchResourcesTagCriterion$Comparator' => '<p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>', ], ], 'SearchResourcesCriteria' => [ 'base' => '<p>Specifies a property- or tag-based filter condition for including or excluding Amazon Web Services resources from the query results.</p>', 'refs' => [ '__listOfSearchResourcesCriteria$member' => NULL, ], ], 'SearchResourcesCriteriaBlock' => [ 'base' => '<p>Specifies property- and tag-based conditions that define filter criteria for including or excluding Amazon Web Services resources from the query results.</p>', 'refs' => [ 'SearchResourcesBucketCriteria$Excludes' => '<p>The property- and tag-based conditions that determine which buckets to exclude from the results.</p>', 'SearchResourcesBucketCriteria$Includes' => '<p>The property- and tag-based conditions that determine which buckets to include in the results.</p>', ], ], 'SearchResourcesRequest' => [ 'base' => '<p>Specifies criteria for filtering, sorting, and paginating the results of a query for statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>', 'refs' => [], ], 'SearchResourcesResponse' => [ 'base' => '<p>Provides the results of a query that retrieved statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes for your account.</p>', 'refs' => [], ], 'SearchResourcesSimpleCriterion' => [ 'base' => '<p>Specifies a property-based filter condition that determines which Amazon Web Services resources are included or excluded from the query results.</p>', 'refs' => [ 'SearchResourcesCriteria$SimpleCriterion' => '<p>A property-based condition that defines a property, operator, and one or more values for including or excluding resources from the results.</p>', ], ], 'SearchResourcesSimpleCriterionKey' => [ 'base' => '<p>The property to use in a condition that filters the query results. Valid values are:</p>', 'refs' => [ 'SearchResourcesSimpleCriterion$Key' => '<p>The property to use in the condition.</p>', ], ], 'SearchResourcesSortAttributeName' => [ 'base' => '<p>The property to sort the query results by. Valid values are:</p>', 'refs' => [ 'SearchResourcesSortCriteria$AttributeName' => '<p>The property to sort the results by.</p>', ], ], 'SearchResourcesSortCriteria' => [ 'base' => '<p>Specifies criteria for sorting the results of a query for information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>', 'refs' => [ 'SearchResourcesRequest$SortCriteria' => '<p>The criteria to use to sort the results.</p>', ], ], 'SearchResourcesTagCriterion' => [ 'base' => '<p>Specifies a tag-based filter condition that determines which Amazon Web Services resources are included or excluded from the query results.</p>', 'refs' => [ 'SearchResourcesCriteria$TagCriterion' => '<p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding resources from the results.</p>', ], ], 'SearchResourcesTagCriterionPair' => [ 'base' => '<p>Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a tag-based filter condition for a query. Tag keys and values are case sensitive. Also, Amazon Macie doesn\'t support use of partial values or wildcard characters in tag-based filter conditions.</p>', 'refs' => [ '__listOfSearchResourcesTagCriterionPair$member' => NULL, ], ], 'SecurityHubConfiguration' => [ 'base' => '<p>Specifies configuration settings that determine which findings are published to Security Hub automatically. For information about how Macie publishes findings to Security Hub, see <a href="https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html">Amazon Macie integration with Security Hub</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'GetFindingsPublicationConfigurationResponse$SecurityHubConfiguration' => '<p>The configuration settings that determine which findings are published to Security Hub.</p>', 'PutFindingsPublicationConfigurationRequest$SecurityHubConfiguration' => '<p>The configuration settings that determine which findings to publish to Security Hub.</p>', ], ], 'SensitiveData' => [ 'base' => '<p>Provides information about the category and number of occurrences of sensitive data that produced a finding.</p>', 'refs' => [ 'ClassificationResult$SensitiveData' => '<p>The category, types, and number of occurrences of the sensitive data that produced the finding.</p>', ], ], 'SensitiveDataItem' => [ 'base' => '<p>Provides information about the category, types, and occurrences of sensitive data that produced a sensitive data finding.</p>', 'refs' => [ 'SensitiveData$member' => NULL, ], ], 'SensitiveDataItemCategory' => [ 'base' => '<p>For a finding, the category of sensitive data that was detected and produced the finding. For a managed data identifier, the category of sensitive data that the managed data identifier detects. Possible values are:</p>', 'refs' => [ 'ManagedDataIdentifierSummary$Category' => '<p>The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>', 'SensitiveDataItem$Category' => '<p>The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>', ], ], 'SensitiveDataOccurrences' => [ 'base' => '<p>Specifies a type of sensitive data reported by a finding and provides occurrences of the specified type of sensitive data.</p>', 'refs' => [ 'GetSensitiveDataOccurrencesResponse$SensitiveDataOccurrences' => '<p>A map that specifies 1-100 types of sensitive data reported by the finding and, for each type, 1-10 occurrences of sensitive data.</p>', ], ], 'SensitivityAggregations' => [ 'base' => '<p>Provides aggregated statistical data for sensitive data discovery metrics that apply to S3 buckets. Each field contains aggregated data for all the buckets that have a sensitivity score (sensitivityScore) of a specified value or within a specified range (BucketStatisticsBySensitivity). If automated sensitive data discovery is currently disabled for your account, the value for each field is 0.</p>', 'refs' => [ 'BucketStatisticsBySensitivity$ClassificationError' => '<p>The aggregated statistical data for all buckets that have a sensitivity score of -1.</p>', 'BucketStatisticsBySensitivity$NotClassified' => '<p>The aggregated statistical data for all buckets that have a sensitivity score of 50.</p>', 'BucketStatisticsBySensitivity$NotSensitive' => '<p>The aggregated statistical data for all buckets that have a sensitivity score of 1-49.</p>', 'BucketStatisticsBySensitivity$Sensitive' => '<p>The aggregated statistical data for all buckets that have a sensitivity score of 51-100.</p>', ], ], 'SensitivityInspectionTemplateExcludes' => [ 'base' => '<p>Specifies managed data identifiers to exclude (not use) when performing automated sensitive data discovery. For information about the managed data identifiers that Amazon Macie currently provides, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'GetSensitivityInspectionTemplateResponse$Excludes' => ' <p>The managed data identifiers that are explicitly excluded (not used) when performing automated sensitive data discovery.</p>', 'UpdateSensitivityInspectionTemplateRequest$Excludes' => ' <p>The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data discovery.</p> <p>To exclude an allow list or custom data identifier that\'s currently included by the template, update the values for the SensitivityInspectionTemplateIncludes.allowListIds and SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.</p>', ], ], 'SensitivityInspectionTemplateId' => [ 'base' => '<p>The unique identifier for the sensitivity inspection template.</p>', 'refs' => [ 'GetAutomatedDiscoveryConfigurationResponse$SensitivityInspectionTemplateId' => '<p>The unique identifier for the sensitivity inspection template that\'s used when performing automated sensitive data discovery. The template specifies which allow lists, custom data identifiers, and managed data identifiers to use when analyzing data.</p>', 'GetSensitivityInspectionTemplateResponse$SensitivityInspectionTemplateId' => '<p>The unique identifier for the template.</p>', ], ], 'SensitivityInspectionTemplateIncludes' => [ 'base' => '<p>Specifies the allow lists, custom data identifiers, and managed data identifiers to include (use) when performing automated sensitive data discovery. The configuration must specify at least one custom data identifier or managed data identifier. For information about the managed data identifiers that Amazon Macie currently provides, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'GetSensitivityInspectionTemplateResponse$Includes' => '<p>The allow lists, custom data identifiers, and managed data identifiers that are explicitly included (used) when performing automated sensitive data discovery.</p>', 'UpdateSensitivityInspectionTemplateRequest$Includes' => '<p>The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use) when performing automated sensitive data discovery.</p>', ], ], 'SensitivityInspectionTemplatesEntry' => [ 'base' => '<p>Provides information about the sensitivity inspection template for an Amazon Macie account.</p>', 'refs' => [ '__listOfSensitivityInspectionTemplatesEntry$member' => NULL, ], ], 'ServerSideEncryption' => [ 'base' => '<p>Provides information about the default server-side encryption settings for an S3 bucket or the encryption settings for an S3 object.</p>', 'refs' => [ 'S3Bucket$DefaultServerSideEncryption' => '<p>The default server-side encryption settings for the bucket.</p>', 'S3Object$ServerSideEncryption' => '<p>The type of server-side encryption that was used to encrypt the object.</p>', ], ], 'ServiceLimit' => [ 'base' => '<p>Specifies a current quota for an Amazon Macie account.</p>', 'refs' => [ 'UsageByAccount$ServiceLimit' => '<p>The current value for the quota that corresponds to the metric specified by the type field.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Provides information about an error that occurred due to one or more service quotas for an account.</p>', 'refs' => [], ], 'SessionContext' => [ 'base' => '<p>Provides information about a session that was created for an entity that performed an action by using temporary security credentials.</p>', 'refs' => [ 'AssumedRole$SessionContext' => '<p>The details of the session that was created for the credentials, including the entity that issued the session.</p>', 'FederatedUser$SessionContext' => '<p>The details of the session that was created for the credentials, including the entity that issued the session.</p>', ], ], 'SessionContextAttributes' => [ 'base' => '<p>Provides information about the context in which temporary security credentials were issued to an entity.</p>', 'refs' => [ 'SessionContext$Attributes' => '<p>The date and time when the credentials were issued, and whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>', ], ], 'SessionIssuer' => [ 'base' => '<p>Provides information about the source and type of temporary security credentials that were issued to an entity.</p>', 'refs' => [ 'SessionContext$SessionIssuer' => '<p>The source and type of credentials that were issued to the entity.</p>', ], ], 'Severity' => [ 'base' => '<p>Provides the numerical and qualitative representations of a finding\'s severity.</p>', 'refs' => [ 'Finding$Severity' => '<p>The severity level and score for the finding.</p>', ], ], 'SeverityDescription' => [ 'base' => '<p>The qualitative representation of the finding\'s severity. Possible values are:</p>', 'refs' => [ 'Severity$Description' => '<p>The qualitative representation of the finding\'s severity, ranging from Low (least severe) to High (most severe).</p>', ], ], 'SeverityLevel' => [ 'base' => '<p>Specifies a severity level for findings that a custom data identifier produces. A severity level determines which severity is assigned to the findings, based on the number of occurrences of text that match the custom data identifier\'s detection criteria.</p>', 'refs' => [ 'SeverityLevelList$member' => NULL, ], ], 'SeverityLevelList' => [ 'base' => '<p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier\'s detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn\'t create a finding.</p> <p>If you don\'t specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie automatically assigns the MEDIUM severity to those findings.</p>', 'refs' => [ 'CreateCustomDataIdentifierRequest$SeverityLevels' => '<p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that match the custom data identifier\'s detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn\'t create a finding.</p> <p>If you don\'t specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>', 'GetCustomDataIdentifierResponse$SeverityLevels' => '<p>Specifies the severity that\'s assigned to findings that the custom data identifier produces, based on the number of occurrences of text that match the custom data identifier\'s detection criteria. By default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>', ], ], 'SharedAccess' => [ 'base' => NULL, 'refs' => [ 'BucketMetadata$SharedAccess' => '<p>Specifies whether the bucket is shared with another Amazon Web Services account, an Amazon CloudFront origin access identity (OAI), or a CloudFront origin access control (OAC). Possible values are:</p> <ul><li><p>EXTERNAL - The bucket is shared with one or more of the following or any combination of the following: a CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that isn\'t part of your Amazon Macie organization.</p></li> <li><p>INTERNAL - The bucket is shared with one or more Amazon Web Services accounts that are part of your Amazon Macie organization. It isn\'t shared with a CloudFront OAI or OAC.</p></li> <li><p>NOT_SHARED - The bucket isn\'t shared with another Amazon Web Services account, a CloudFront OAI, or a CloudFront OAC.</p></li> <li><p>UNKNOWN - Amazon Macie wasn\'t able to evaluate the shared access settings for the bucket.</p></li></ul> <p>An <i>Amazon Macie organization</i> is a set of Macie accounts that are centrally managed as a group of related accounts through Organizations or by Macie invitation.</p>', ], ], 'SimpleCriterionForJob' => [ 'base' => '<p>Specifies a property-based condition that determines whether an S3 bucket is included or excluded from a classification job.</p>', 'refs' => [ 'CriteriaForJob$SimpleCriterion' => '<p>A property-based condition that defines a property, operator, and one or more values for including or excluding buckets from the job.</p>', ], ], 'SimpleCriterionKeyForJob' => [ 'base' => '<p>The property to use in a condition that determines whether an S3 bucket is included or excluded from a classification job. Valid values are:</p>', 'refs' => [ 'SimpleCriterionForJob$Key' => '<p>The property to use in the condition.</p>', ], ], 'SimpleScopeTerm' => [ 'base' => '<p>Specifies a property-based condition that determines whether an S3 object is included or excluded from a classification job.</p>', 'refs' => [ 'JobScopeTerm$SimpleScopeTerm' => '<p>A property-based condition that defines a property, operator, and one or more values for including or excluding objects from the job.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>Specifies criteria for sorting the results of a request for findings.</p>', 'refs' => [ 'GetFindingsRequest$SortCriteria' => '<p>The criteria for sorting the results of the request.</p>', 'ListFindingsRequest$SortCriteria' => '<p>The criteria to use to sort the results.</p>', ], ], 'Statistics' => [ 'base' => '<p>Provides processing statistics for a classification job.</p>', 'refs' => [ 'DescribeClassificationJobResponse$Statistics' => '<p>The number of times that the job has run and processing statistics for the job\'s current run.</p>', ], ], 'StorageClass' => [ 'base' => '<p>The storage class of the S3 object. Possible values are:</p>', 'refs' => [ 'S3Object$StorageClass' => '<p>The storage class of the object.</p>', ], ], 'SuppressDataIdentifier' => [ 'base' => '<p>Specifies a custom data identifier or managed data identifier that detected a type of sensitive data to start excluding or including in an S3 bucket\'s sensitivity score.</p>', 'refs' => [ '__listOfSuppressDataIdentifier$member' => NULL, ], ], 'TagCriterionForJob' => [ 'base' => '<p>Specifies a tag-based condition that determines whether an S3 bucket is included or excluded from a classification job.</p>', 'refs' => [ 'CriteriaForJob$TagCriterion' => '<p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding buckets from the job.</p>', ], ], 'TagCriterionPairForJob' => [ 'base' => ' <p>Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a tag-based condition that determines whether an S3 bucket is included or excluded from a classification job. Tag keys and values are case sensitive. Also, Amazon Macie doesn\'t support use of partial values or wildcard characters in tag-based conditions.</p>', 'refs' => [ '__listOfTagCriterionPairForJob$member' => NULL, ], ], 'TagMap' => [ 'base' => '<p>A string-to-string map of key-value pairs that specifies the tags (keys and values) for an Amazon Macie resource.</p>', 'refs' => [ 'CreateAllowListRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the allow list.</p> <p>An allow list can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'CreateClassificationJobRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'CreateCustomDataIdentifierRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'CreateFindingsFilterRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'CreateMemberRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'DescribeClassificationJobResponse$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the job.</p>', 'FindingsFilterListItem$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.</p>', 'GetAllowListResponse$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the allow list.</p>', 'GetCustomDataIdentifierResponse$Tags' => '<p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.</p>', 'GetFindingsFilterResponse$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.</p>', 'GetMemberResponse$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the account in Amazon Macie.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the resource.</p>', 'Member$Tags' => '<p>A map of key-value pairs that specifies which tags (keys and values) are associated with the account in Amazon Macie.</p>', 'TagResourceRequest$Tags' => '<p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>Specifies the tags (keys and values) to associate with an Amazon Macie resource.</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => '<p>The request succeeded. The specified tags were added or updated for the resource.</p>', 'refs' => [], ], 'TagScopeTerm' => [ 'base' => '<p>Specifies a tag-based condition that determines whether an S3 object is included or excluded from a classification job.</p>', 'refs' => [ 'JobScopeTerm$TagScopeTerm' => '<p>A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding objects from the job.</p>', ], ], 'TagTarget' => [ 'base' => '<p>The type of object to apply a tag-based condition to. Valid values are:</p>', 'refs' => [ 'TagScopeTerm$Target' => '<p>The type of object to apply the condition to.</p>', ], ], 'TagValuePair' => [ 'base' => '<p>Specifies a tag key or tag key and value pair to use in a tag-based condition that determines whether an S3 object is included or excluded from a classification job. Tag keys and values are case sensitive. Also, Amazon Macie doesn\'t support use of partial values or wildcard characters in tag-based conditions.</p>', 'refs' => [ '__listOfTagValuePair$member' => NULL, ], ], 'TestCustomDataIdentifierRequest' => [ 'base' => '<p>Specifies the detection criteria of a custom data identifier to test.</p>', 'refs' => [], ], 'TestCustomDataIdentifierResponse' => [ 'base' => '<p>Provides test results for a custom data identifier.</p>', 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>', 'refs' => [], ], 'TimeRange' => [ 'base' => '<p>An inclusive time period that Amazon Macie usage data applies to. Possible values are:</p>', 'refs' => [ 'GetUsageStatisticsRequest$TimeRange' => '<p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don\'t specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>', 'GetUsageStatisticsResponse$TimeRange' => '<p>The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.</p>', 'GetUsageTotalsResponse$TimeRange' => '<p>The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.</p>', ], ], 'Timestamp' => [ 'base' => '<p>Specifies a date and time in UTC and extended ISO 8601 format.</p>', 'refs' => [ 'GetAutomatedDiscoveryConfigurationResponse$DisabledAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was most recently disabled. This value is null if automated sensitive data discovery is currently enabled.</p>', 'GetAutomatedDiscoveryConfigurationResponse$FirstEnabledAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was initially enabled. This value is null if automated sensitive data discovery has never been enabled.</p>', 'GetAutomatedDiscoveryConfigurationResponse$LastUpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was most recently enabled or disabled.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'BucketServerSideEncryption$Type' => '<p>The server-side encryption algorithm that\'s used by default to encrypt objects that are added to the bucket. Possible values are:</p> <ul><li><p>AES256 - New objects use SSE-S3 encryption. They\'re encrypted with an Amazon S3 managed key.</p></li> <li><p>aws:kms - New objects use SSE-KMS encryption. They\'re encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key.</p></li> <li><p>aws:kms:dsse - New objects use DSSE-KMS encryption. They\'re encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key.</p></li> <li><p>NONE - The bucket\'s default encryption settings don\'t specify server-side encryption behavior for new objects.</p></li></ul>', ], ], 'UnavailabilityReasonCode' => [ 'base' => '<p>Specifies why occurrences of sensitive data can\'t be retrieved for a finding. Possible values are:</p>', 'refs' => [ '__listOfUnavailabilityReasonCode$member' => NULL, ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'ServiceLimit$Unit' => '<p>The unit of measurement for the value specified by the value field.</p>', ], ], 'UnprocessableEntityException' => [ 'base' => '<p>Provides information about an error that occurred due to an unprocessable entity.</p>', 'refs' => [], ], 'UnprocessedAccount' => [ 'base' => ' <p>Provides information about an account-related request that hasn\'t been processed.</p>', 'refs' => [ '__listOfUnprocessedAccount$member' => NULL, ], ], 'UntagResourceResponse' => [ 'base' => '<p>The request succeeded. The specified tags were removed from the resource.</p>', 'refs' => [], ], 'UpdateAllowListRequest' => [ 'base' => '<p>Changes the settings for an allow list. If you change the list\'s criteria, Amazon Macie tests the new criteria when it processes your request. If the criteria specify a regular expression that Macie can\'t compile or an S3 object that Macie can\'t retrieve or parse, an error occurs.</p>', 'refs' => [], ], 'UpdateAllowListResponse' => [ 'base' => '<p>Provides information about an allow list whose settings were changed in response to a request.</p>', 'refs' => [], ], 'UpdateAutomatedDiscoveryConfigurationRequest' => [ 'base' => '<p>Changes the configuration settings and status of automated sensitive data discovery for an organization in Amazon Macie or a standalone Macie account. To change additional settings, such as the managed data identifiers to use when analyzing data, update the sensitivity inspection template and classification scope for the organization\'s Macie administrator account or the standalone account.</p>', 'refs' => [], ], 'UpdateClassificationJobRequest' => [ 'base' => '<p>Changes the status of a classification job. For more information about pausing, resuming, or cancelling jobs, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-manage.html">Managing sensitive data discovery jobs</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [], ], 'UpdateClassificationScopeRequest' => [ 'base' => '<p>Specifies new classification scope settings for an Amazon Macie account. Macie uses these settings when it performs automated sensitive data discovery for the account. To update the settings, automated sensitive data discovery must be enabled for the account.</p>', 'refs' => [], ], 'UpdateFindingsFilterRequest' => [ 'base' => '<p>Specifies the criteria and other settings for a findings filter.</p>', 'refs' => [], ], 'UpdateFindingsFilterResponse' => [ 'base' => '<p>Provides information about a findings filter that was updated in response to a request.</p>', 'refs' => [], ], 'UpdateMacieSessionRequest' => [ 'base' => '<p>Changes the status or configuration settings for an Amazon Macie account.</p>', 'refs' => [], ], 'UpdateMemberSessionRequest' => [ 'base' => '<p>Suspends (pauses) or re-enables Amazon Macie for a member account.</p>', 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => '<p>Specifies whether to enable Amazon Macie automatically for accounts that are added to an organization in Organizations, when the accounts are added to the organization.</p>', 'refs' => [], ], 'UpdateResourceProfileDetectionsRequest' => [ 'base' => '<p>Updates the sensitivity scoring settings for an S3 bucket that Amazon Macie monitors and analyzes for an account. The settings specify whether to exclude or include occurrences of specific types of sensitive data in the bucket\'s sensitivity score. To update the settings, automated sensitive data discovery must be enabled for the account.</p>', 'refs' => [], ], 'UpdateResourceProfileRequest' => [ 'base' => '<p>Specifies a new sensitivity score for an S3 bucket that Amazon Macie monitors and analyzes for an account. To update the score, automated sensitive data discovery must be enabled for the account.</p>', 'refs' => [], ], 'UpdateRetrievalConfiguration' => [ 'base' => '<p>Specifies the access method and settings to use when retrieving occurrences of sensitive data reported by findings. If your request specifies an Identity and Access Management (IAM) role to assume, Amazon Macie verifies that the role exists and the attached policies are configured correctly. If there\'s an issue, Macie returns an error. For information about addressing the issue, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-retrieve-sd-options.html">Configuration options and requirements for retrieving sensitive data samples</a> in the <i>Amazon Macie User Guide</i>.</p>', 'refs' => [ 'UpdateRevealConfigurationRequest$RetrievalConfiguration' => '<p>The access method and settings to use when retrieving the sensitive data.</p>', ], ], 'UpdateRevealConfigurationRequest' => [ 'base' => '<p>Specifies configuration settings for retrieving occurrences of sensitive data reported by findings, and the status of the configuration for an Amazon Macie account. If you don\'t specify retrievalConfiguration settings for an existing configuration, Macie sets the access method to CALLER_CREDENTIALS. If your current access method is ASSUME_ROLE, Macie also deletes the external ID and role name currently specified for the configuration. To keep these settings for an existing configuration, specify your current retrievalConfiguration settings in your request.</p>', 'refs' => [], ], 'UpdateRevealConfigurationResponse' => [ 'base' => '<p>Provides information about updated configuration settings for retrieving occurrences of sensitive data reported by findings, and the status of the configuration for an Amazon Macie account.</p>', 'refs' => [], ], 'UpdateSensitivityInspectionTemplateRequest' => [ 'base' => '<p>Specifies settings for the sensitivity inspection template for an Amazon Macie account. To update the settings, automated sensitive data discovery must be enabled for the account.</p>', 'refs' => [], ], 'UsageByAccount' => [ 'base' => '<p>Provides data for a specific usage metric and the corresponding quota for an Amazon Macie account.</p>', 'refs' => [ '__listOfUsageByAccount$member' => NULL, ], ], 'UsageRecord' => [ 'base' => '<p>Provides quota and aggregated usage data for an Amazon Macie account.</p>', 'refs' => [ '__listOfUsageRecord$member' => NULL, ], ], 'UsageStatisticsFilter' => [ 'base' => '<p>Specifies a condition for filtering the results of a query for quota and usage data for one or more Amazon Macie accounts.</p>', 'refs' => [ '__listOfUsageStatisticsFilter$member' => NULL, ], ], 'UsageStatisticsFilterComparator' => [ 'base' => '<p>The operator to use in a condition that filters the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>', 'refs' => [ 'UsageStatisticsFilter$Comparator' => '<p>The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.</p>', ], ], 'UsageStatisticsFilterKey' => [ 'base' => '<p>The field to use in a condition that filters the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>', 'refs' => [ 'UsageStatisticsFilter$Key' => '<p>The field to use in the condition.</p>', ], ], 'UsageStatisticsSortBy' => [ 'base' => '<p>Specifies criteria for sorting the results of a query for Amazon Macie account quotas and usage data.</p>', 'refs' => [ 'GetUsageStatisticsRequest$SortBy' => '<p>The criteria to use to sort the query results.</p>', ], ], 'UsageStatisticsSortKey' => [ 'base' => '<p>The field to use to sort the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>', 'refs' => [ 'UsageStatisticsSortBy$Key' => '<p>The field to sort the results by.</p>', ], ], 'UsageTotal' => [ 'base' => '<p>Provides aggregated data for an Amazon Macie usage metric. The value for the metric reports estimated usage data for an account for the preceding 30 days or the current calendar month to date, depending on the time period (timeRange) specified in the request.</p>', 'refs' => [ '__listOfUsageTotal$member' => NULL, ], ], 'UsageType' => [ 'base' => '<p>The name of an Amazon Macie usage metric for an account. Possible values are:</p>', 'refs' => [ 'UsageByAccount$Type' => '<p>The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run classification jobs.</p>', 'UsageTotal$Type' => '<p>The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run classification jobs.</p>', ], ], 'UserIdentity' => [ 'base' => '<p>Provides information about the type and other characteristics of an entity that performed an action on an affected resource.</p>', 'refs' => [ 'FindingActor$UserIdentity' => '<p>The type and other characteristics of the entity that performed the action on the affected resource. This value is null if the action was performed by an anonymous (unauthenticated) entity.</p>', ], ], 'UserIdentityRoot' => [ 'base' => '<p>Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for your Amazon Web Services account.</p>', 'refs' => [ 'UserIdentity$Root' => '<p>If the action was performed using the credentials for your Amazon Web Services account, the details of your account.</p>', ], ], 'UserIdentityType' => [ 'base' => '<p>The type of entity that performed the action on the affected resource. Possible values are:</p>', 'refs' => [ 'UserIdentity$Type' => '<p>The type of entity that performed the action.</p>', ], ], 'UserPausedDetails' => [ 'base' => '<p>Provides information about when a classification job was paused. For a one-time job, this object also specifies when the job will expire and be cancelled if it isn\'t resumed. For a recurring job, this object also specifies when the paused job run will expire and be cancelled if it isn\'t resumed. This object is present only if a job\'s current status (jobStatus) is USER_PAUSED. The information in this object applies only to a job that was paused while it had a status of RUNNING.</p>', 'refs' => [ 'DescribeClassificationJobResponse$UserPausedDetails' => '<p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn\'t resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>', 'JobSummary$UserPausedDetails' => '<p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn\'t resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Provides information about an error that occurred due to a syntax error in a request.</p>', 'refs' => [], ], 'WeeklySchedule' => [ 'base' => '<p>Specifies a weekly recurrence pattern for running a classification job.</p>', 'refs' => [ 'JobScheduleFrequency$WeeklySchedule' => '<p>Specifies a weekly recurrence pattern for running the job.</p>', ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'AccessControlList$AllowsPublicReadAccess' => '<p>Specifies whether the ACL grants the general public with read access permissions for the bucket.</p>', 'AccessControlList$AllowsPublicWriteAccess' => '<p>Specifies whether the ACL grants the general public with write access permissions for the bucket.</p>', 'BatchGetCustomDataIdentifierSummary$Deleted' => '<p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn\'t delete it permanently. Instead, it soft deletes the identifier.</p>', 'BlockPublicAccess$BlockPublicAcls' => '<p>Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.</p>', 'BlockPublicAccess$BlockPublicPolicy' => '<p>Specifies whether Amazon S3 blocks public bucket policies for the bucket.</p>', 'BlockPublicAccess$IgnorePublicAcls' => '<p>Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.</p>', 'BlockPublicAccess$RestrictPublicBuckets' => '<p>Specifies whether Amazon S3 restricts public bucket policies for the bucket.</p>', 'BucketMetadata$Versioning' => '<p>Specifies whether versioning is enabled for the bucket.</p>', 'BucketPolicy$AllowsPublicReadAccess' => '<p>Specifies whether the bucket policy allows the general public to have read access to the bucket.</p>', 'BucketPolicy$AllowsPublicWriteAccess' => '<p>Specifies whether the bucket policy allows the general public to have write access to the bucket.</p>', 'ClassificationResult$AdditionalOccurrences' => '<p>Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p> <p>This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (classificationDetails.detailedResultsLocation).</p>', 'CreateClassificationJobRequest$InitialRun' => '<p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job\'s first scheduled run, set this value to false.</p> <p>If you configure the job to run only once, don\'t specify a value for this property.</p>', 'CreateInvitationsRequest$DisableEmailNotification' => '<p>Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the invitation (as an email message) to the email address that you specified for the recipient\'s account when you associated the account with your account. The default value is false.</p>', 'DescribeClassificationJobResponse$InitialRun' => '<p>For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects immediately after the job was created (true). If you configured the job to analyze only those objects that were created or changed after the job was created and before the job\'s first scheduled run, this value is false. This value is also false for a one-time job.</p>', 'DescribeOrganizationConfigurationResponse$AutoEnable' => '<p>Specifies whether Amazon Macie is enabled automatically for accounts that are added to the organization.</p>', 'DescribeOrganizationConfigurationResponse$MaxAccountLimitReached' => '<p>Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.</p>', 'Detection$Suppressed' => '<p>Specifies whether occurrences of this type of sensitive data are excluded (true) or included (false) in the bucket\'s sensitivity score.</p>', 'Finding$Archived' => '<p>Specifies whether the finding is archived (suppressed).</p>', 'Finding$Sample' => '<p>Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to demonstrate what a finding might contain.</p>', 'GetCustomDataIdentifierResponse$Deleted' => '<p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn\'t delete it permanently. Instead, it soft deletes the identifier.</p>', 'GetResourceProfileResponse$SensitivityScoreOverridden' => '<p>Specifies whether the bucket\'s current sensitivity score was set manually. If this value is true, the score was manually changed to 100. If this value is false, the score was calculated automatically by Amazon Macie.</p>', 'ReplicationDetails$Replicated' => '<p>Specifies whether the bucket is configured to replicate one or more objects to any destination.</p>', 'ReplicationDetails$ReplicatedExternally' => '<p>Specifies whether the bucket is configured to replicate one or more objects to a bucket for an Amazon Web Services account that isn\'t part of your Amazon Macie organization. An <i>Amazon Macie organization</i> is a set of Macie accounts that are centrally managed as a group of related accounts through Organizations or by Macie invitation.</p>', 'ResourceProfileArtifact$Sensitive' => '<p>Specifies whether Amazon Macie found sensitive data in the object.</p>', 'S3Object$PublicAccess' => '<p>Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.</p>', 'SecurityHubConfiguration$PublishClassificationFindings' => '<p>Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren\'t suppressed by a findings filter. The default value is false.</p>', 'SecurityHubConfiguration$PublishPolicyFindings' => '<p>Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren\'t suppressed by a findings filter. The default value is true.</p>', 'ServiceLimit$IsServiceLimited' => '<p>Specifies whether the account has met the quota that corresponds to the metric specified by the UsageByAccount.type field in the response.</p>', 'SessionContextAttributes$MfaAuthenticated' => '<p>Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>', 'UpdateOrganizationConfigurationRequest$AutoEnable' => '<p>Specifies whether to enable Amazon Macie automatically for accounts that are added to the organization in Organizations.</p>', ], ], '__double' => [ 'base' => NULL, 'refs' => [ 'IpGeoLocation$Lat' => '<p>The latitude coordinate of the location, rounded to four decimal places.</p>', 'IpGeoLocation$Lon' => '<p>The longitude coordinate of the location, rounded to four decimal places.</p>', 'Statistics$ApproximateNumberOfObjectsToProcess' => '<p>The approximate number of objects that the job has yet to process during its current run.</p>', 'Statistics$NumberOfRuns' => '<p>The number of times that the job has run.</p>', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'BucketMetadata$SensitivityScore' => '<p>The sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive).</p><p>If automated sensitive data discovery has been disabled for your account for more than 30 days, possible values are: 1, the bucket is empty; or, 50, Amazon Macie reset the score because automated sensitive data discovery was disabled for your account. If automated sensitive data discovery has never been enabled for your account, this value is null.</p>', 'CreateClassificationJobRequest$SamplingPercentage' => '<p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>', 'CreateCustomDataIdentifierRequest$MaximumMatchDistance' => '<p>The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. The distance can be 1-300 characters. The default value is 50.</p>', 'CreateFindingsFilterRequest$Position' => '<p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>', 'DescribeBucketsRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response. The default value is 50.</p>', 'DescribeClassificationJobResponse$SamplingPercentage' => '<p>The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.</p>', 'GetCustomDataIdentifierResponse$MaximumMatchDistance' => '<p>The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. Otherwise, Macie excludes the result.</p>', 'GetFindingStatisticsRequest$Size' => '<p>The maximum number of items to include in each page of the response.</p>', 'GetFindingsFilterResponse$Position' => '<p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>', 'GetResourceProfileResponse$SensitivityScore' => '<p>The current sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive). By default, this score is calculated automatically based on the amount of data that Amazon Macie has analyzed in the bucket and the amount of sensitive data that Macie has found in the bucket.</p>', 'GetUsageStatisticsRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response.</p>', 'ListClassificationJobsRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response.</p>', 'ListCustomDataIdentifiersRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response.</p>', 'ListFindingsRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response.</p>', 'MatchingBucket$SensitivityScore' => '<p>The sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive).</p><p>If automated sensitive data discovery has been disabled for your account for more than 30 days, possible values are: 1, the bucket is empty; or, 50, Amazon Macie reset the score because automated sensitive data discovery was disabled for your account. If automated sensitive data discovery has never been enabled for your account, this value is null.</p>', 'MonthlySchedule$DayOfMonth' => '<p>The numeric day of the month when Amazon Macie runs the job. This value can be an integer from 1 through 31.</p> <p>If this value exceeds the number of days in a certain month, Macie doesn\'t run the job that month. Macie runs the job only during months that have the specified day. For example, if this value is 31 and a month has only 30 days, Macie doesn\'t run the job that month. To run the job every month, specify a value that\'s less than 29.</p>', 'SearchResourcesRequest$MaxResults' => '<p>The maximum number of items to include in each page of the response. The default value is 50.</p>', 'TestCustomDataIdentifierRequest$MaximumMatchDistance' => '<p>The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. The distance can be 1-300 characters. The default value is 50.</p>', 'TestCustomDataIdentifierResponse$MatchCount' => '<p>The number of occurrences of sample text that matched the criteria specified by the custom data identifier.</p>', 'UpdateFindingsFilterRequest$Position' => '<p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>', 'UpdateResourceProfileRequest$SensitivityScoreOverride' => '<p>The new sensitivity score for the bucket. Valid values are: 100, assign the maximum score and apply the <i>Sensitive</i> label to the bucket; and, null (empty), assign a score that Amazon Macie calculates automatically after you submit the request.</p>', ], ], '__listOfAdminAccount' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationAdminAccountsResponse$AdminAccounts' => '<p>An array of objects, one for each delegated Amazon Macie administrator account for the organization. Only one of these accounts can have a status of ENABLED.</p>', ], ], '__listOfAllowListSummary' => [ 'base' => NULL, 'refs' => [ 'ListAllowListsResponse$AllowLists' => '<p>An array of objects, one for each allow list.</p>', ], ], '__listOfAutomatedDiscoveryAccount' => [ 'base' => NULL, 'refs' => [ 'ListAutomatedDiscoveryAccountsResponse$Items' => '<p>An array of objects, one for each account specified in the request. Each object specifies the Amazon Web Services account ID for an account and the current status of automated sensitive data discovery for that account.</p>', ], ], '__listOfAutomatedDiscoveryAccountUpdate' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateAutomatedDiscoveryAccountsRequest$Accounts' => '<p>An array of objects, one for each account to change the status of automated sensitive data discovery for. Each object specifies the Amazon Web Services account ID for an account and a new status for that account.</p>', ], ], '__listOfAutomatedDiscoveryAccountUpdateError' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateAutomatedDiscoveryAccountsResponse$Errors' => '<p>An array of objects, one for each account whose status wasn’t changed. Each object identifies the account and explains why the status of automated sensitive data discovery wasn’t changed for the account. This value is null if the request succeeded for all specified accounts.</p>', ], ], '__listOfBatchGetCustomDataIdentifierSummary' => [ 'base' => NULL, 'refs' => [ 'BatchGetCustomDataIdentifiersResponse$CustomDataIdentifiers' => '<p>An array of objects, one for each custom data identifier that matches the criteria specified in the request.</p>', ], ], '__listOfBucketMetadata' => [ 'base' => NULL, 'refs' => [ 'DescribeBucketsResponse$Buckets' => '<p>An array of objects, one for each bucket that matches the filter criteria specified in the request.</p>', ], ], '__listOfClassificationScopeSummary' => [ 'base' => NULL, 'refs' => [ 'ListClassificationScopesResponse$ClassificationScopes' => '<p>An array that specifies the unique identifier and name of the classification scope for the account.</p>', ], ], '__listOfCriteriaForJob' => [ 'base' => NULL, 'refs' => [ 'CriteriaBlockForJob$And' => '<p>An array of conditions, one for each condition that determines which buckets to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>', ], ], '__listOfCustomDataIdentifierSummary' => [ 'base' => NULL, 'refs' => [ 'ListCustomDataIdentifiersResponse$Items' => '<p>An array of objects, one for each custom data identifier.</p>', ], ], '__listOfDetectedDataDetails' => [ 'base' => NULL, 'refs' => [ 'SensitiveDataOccurrences$member' => NULL, ], ], '__listOfDetection' => [ 'base' => NULL, 'refs' => [ 'ListResourceProfileDetectionsResponse$Detections' => '<p>An array of objects, one for each type of sensitive data that Amazon Macie found in the bucket. Each object reports the number of occurrences of the specified type and provides information about the custom data identifier or managed data identifier that detected the data.</p>', ], ], '__listOfFinding' => [ 'base' => NULL, 'refs' => [ 'GetFindingsResponse$Findings' => '<p>An array of objects, one for each finding that matches the criteria specified in the request.</p>', ], ], '__listOfFindingType' => [ 'base' => NULL, 'refs' => [ 'CreateSampleFindingsRequest$FindingTypes' => '<p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don\'t include this array in your request.</p>', ], ], '__listOfFindingsFilterListItem' => [ 'base' => NULL, 'refs' => [ 'ListFindingsFiltersResponse$FindingsFilterListItems' => '<p>An array of objects, one for each filter that\'s associated with the account.</p>', ], ], '__listOfGroupCount' => [ 'base' => NULL, 'refs' => [ 'GetFindingStatisticsResponse$CountsByGroup' => '<p>An array of objects, one for each group of findings that matches the filter criteria specified in the request.</p>', ], ], '__listOfInvitation' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsResponse$Invitations' => '<p>An array of objects, one for each invitation that was received by the account.</p>', ], ], '__listOfJobScopeTerm' => [ 'base' => NULL, 'refs' => [ 'JobScopingBlock$And' => '<p>An array of conditions, one for each property- or tag-based condition that determines which objects to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>', ], ], '__listOfJobSummary' => [ 'base' => NULL, 'refs' => [ 'ListClassificationJobsResponse$Items' => '<p>An array of objects, one for each job that matches the filter criteria specified in the request.</p>', ], ], '__listOfKeyValuePair' => [ 'base' => NULL, 'refs' => [ 'BucketMetadata$Tags' => '<p>An array that specifies the tags (keys and values) that are associated with the bucket.</p>', ], ], '__listOfListJobsFilterTerm' => [ 'base' => NULL, 'refs' => [ 'ListJobsFilterCriteria$Excludes' => '<p>An array of objects, one for each condition that determines which jobs to exclude from the results.</p>', 'ListJobsFilterCriteria$Includes' => '<p>An array of objects, one for each condition that determines which jobs to include in the results.</p>', ], ], '__listOfManagedDataIdentifierSummary' => [ 'base' => NULL, 'refs' => [ 'ListManagedDataIdentifiersResponse$Items' => '<p>An array of objects, one for each managed data identifier.</p>', ], ], '__listOfMatchingResource' => [ 'base' => NULL, 'refs' => [ 'SearchResourcesResponse$MatchingResources' => '<p>An array of objects, one for each resource that matches the filter criteria specified in the request.</p>', ], ], '__listOfMember' => [ 'base' => NULL, 'refs' => [ 'ListMembersResponse$Members' => '<p>An array of objects, one for each account that\'s associated with the administrator account and matches the criteria specified in the request.</p>', ], ], '__listOfResourceProfileArtifact' => [ 'base' => NULL, 'refs' => [ 'ListResourceProfileArtifactsResponse$Artifacts' => '<p>An array of objects, one for each of 1-100 S3 objects that Amazon Macie selected for analysis.</p> <p>If Macie has analyzed more than 100 objects in the bucket, Macie populates the array based on the value for the ResourceProfileArtifact.sensitive field for an object: true (sensitive), followed by false (not sensitive). Macie then populates any remaining items in the array with information about objects where the value for the ResourceProfileArtifact.classificationResultStatus field is SKIPPED.</p>', ], ], '__listOfS3BucketDefinitionForJob' => [ 'base' => NULL, 'refs' => [ 'JobSummary$BucketDefinitions' => '<p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job\'s definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>', 'S3JobDefinition$BucketDefinitions' => '<p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job\'s definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>', ], ], '__listOfS3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3ClassificationScopeExclusion$BucketNames' => '<p>An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an excluded bucket.</p>', 'S3ClassificationScopeExclusionUpdate$BucketNames' => '<p>Depending on the value specified for the update operation (ClassificationScopeUpdateOperation), an array of strings that: lists the names of buckets to add or remove from the list, or specifies a new set of bucket names that overwrites all existing names in the list. Each string must be the full name of an S3 bucket. Values are case sensitive.</p>', ], ], '__listOfSearchResourcesCriteria' => [ 'base' => NULL, 'refs' => [ 'SearchResourcesCriteriaBlock$And' => '<p>An array of objects, one for each property- or tag-based condition that includes or excludes resources from the query results. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>', ], ], '__listOfSearchResourcesTagCriterionPair' => [ 'base' => NULL, 'refs' => [ 'SearchResourcesTagCriterion$TagValues' => '<p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>', ], ], '__listOfSensitivityInspectionTemplatesEntry' => [ 'base' => NULL, 'refs' => [ 'ListSensitivityInspectionTemplatesResponse$SensitivityInspectionTemplates' => '<p>An array that specifies the unique identifier and name of the sensitivity inspection template for the account.</p>', ], ], '__listOfSuppressDataIdentifier' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceProfileDetectionsRequest$SuppressDataIdentifiers' => '<p>An array of objects, one for each custom data identifier or managed data identifier that detected the type of sensitive data to start excluding or including in the bucket\'s score. To start including all sensitive data types in the score, don\'t specify any values for this array.</p>', ], ], '__listOfTagCriterionPairForJob' => [ 'base' => NULL, 'refs' => [ 'TagCriterionForJob$TagValues' => '<p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>', ], ], '__listOfTagValuePair' => [ 'base' => NULL, 'refs' => [ 'TagScopeTerm$TagValues' => '<p>The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.</p>', ], ], '__listOfUnavailabilityReasonCode' => [ 'base' => NULL, 'refs' => [ 'GetSensitiveDataOccurrencesAvailabilityResponse$Reasons' => '<p>Specifies why occurrences of sensitive data can\'t be retrieved for the finding. Possible values are:</p> <ul><li><p>ACCOUNT_NOT_IN_ORGANIZATION - The affected account isn\'t currently part of your organization. Or the account is part of your organization but Macie isn\'t currently enabled for the account. You\'re not allowed to access the affected S3 object by using Macie.</p></li> <li><p>INVALID_CLASSIFICATION_RESULT - There isn\'t a corresponding sensitive data discovery result for the finding. Or the corresponding sensitive data discovery result isn\'t available in the current Amazon Web Services Region, is malformed or corrupted, or uses an unsupported storage format. Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>INVALID_RESULT_SIGNATURE - The corresponding sensitive data discovery result is stored in an S3 object that wasn\'t signed by Macie. Macie can\'t verify the integrity and authenticity of the sensitive data discovery result. Therefore, Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>MEMBER_ROLE_TOO_PERMISSIVE - The trust or permissions policy for the IAM role in the affected member account doesn\'t meet Macie requirements for restricting access to the role. Or the role\'s trust policy doesn\'t specify the correct external ID for your organization. Macie can\'t assume the role to retrieve the sensitive data.</p></li> <li><p>MISSING_GET_MEMBER_PERMISSION - You\'re not allowed to retrieve information about the association between your account and the affected account. Macie can\'t determine whether you’re allowed to access the affected S3 object as the delegated Macie administrator for the affected account.</p></li> <li><p>OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving occurrences of sensitive data from this type of file.</p></li> <li><p>OBJECT_UNAVAILABLE - The affected S3 object isn\'t available. The object was renamed, moved, deleted, or changed after Macie created the finding. Or the object is encrypted with an KMS key that\'s currently disabled.</p></li> <li><p>RESULT_NOT_SIGNED - The corresponding sensitive data discovery result is stored in an S3 object that hasn\'t been signed. Macie can\'t verify the integrity and authenticity of the sensitive data discovery result. Therefore, Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>ROLE_TOO_PERMISSIVE - Your account is configured to retrieve occurrences of sensitive data by using an IAM role whose trust or permissions policy doesn\'t meet Macie requirements for restricting access to the role. Macie can’t assume the role to retrieve the sensitive data.</p></li> <li><p>UNSUPPORTED_FINDING_TYPE - The specified finding isn\'t a sensitive data finding.</p></li> <li><p>UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn\'t support for retrieving occurrences of sensitive data.</p></li></ul> <p>This value is null if sensitive data can be retrieved for the finding.</p>', ], ], '__listOfUnprocessedAccount' => [ 'base' => NULL, 'refs' => [ 'CreateInvitationsResponse$UnprocessedAccounts' => '<p>An array of objects, one for each account whose invitation hasn\'t been processed. Each object identifies the account and explains why the invitation hasn\'t been processed for the account.</p>', 'DeclineInvitationsResponse$UnprocessedAccounts' => '<p>An array of objects, one for each account whose invitation hasn\'t been declined. Each object identifies the account and explains why the request hasn\'t been processed for that account.</p>', 'DeleteInvitationsResponse$UnprocessedAccounts' => '<p>An array of objects, one for each account whose invitation hasn\'t been deleted. Each object identifies the account and explains why the request hasn\'t been processed for that account.</p>', ], ], '__listOfUsageByAccount' => [ 'base' => NULL, 'refs' => [ 'UsageRecord$Usage' => '<p>An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.</p>', ], ], '__listOfUsageRecord' => [ 'base' => NULL, 'refs' => [ 'GetUsageStatisticsResponse$Records' => '<p>An array of objects that contains the results of the query. Each object contains the data for an account that matches the filter criteria specified in the request.</p>', ], ], '__listOfUsageStatisticsFilter' => [ 'base' => NULL, 'refs' => [ 'GetUsageStatisticsRequest$FilterBy' => '<p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>', ], ], '__listOfUsageTotal' => [ 'base' => NULL, 'refs' => [ 'GetUsageTotalsResponse$UsageTotals' => '<p>An array of objects that contains the results of the query. Each object contains the data for a specific usage metric.</p>', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'BatchGetCustomDataIdentifiersRequest$Ids' => '<p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>', 'BatchGetCustomDataIdentifiersResponse$NotFoundIdentifierIds' => '<p>An array of custom data identifier IDs, one for each custom data identifier that was specified in the request but doesn\'t correlate to an existing custom data identifier.</p>', 'BucketCriteriaAdditionalProperties$Eq' => '<p>The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>', 'BucketCriteriaAdditionalProperties$Neq' => '<p>The value for the property doesn\'t match (doesn\'t equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>', 'CreateClassificationJobRequest$AllowListIds' => '<p>An array of unique identifiers, one for each allow list for the job to use when it analyzes data.</p>', 'CreateClassificationJobRequest$CustomDataIdentifierIds' => '<p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don\'t specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>', 'CreateClassificationJobRequest$ManagedDataIdentifierIds' => '<p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p> <p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>', 'CreateCustomDataIdentifierRequest$IgnoreWords' => '<p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>', 'CreateCustomDataIdentifierRequest$Keywords' => '<p>An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren\'t case sensitive.</p>', 'CreateInvitationsRequest$AccountIds' => '<p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>', 'CriterionAdditionalProperties$Eq' => '<p>The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>', 'CriterionAdditionalProperties$EqExactMatch' => '<p>The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.</p> <p>You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.</p>', 'CriterionAdditionalProperties$Neq' => '<p>The value for the property doesn\'t match (doesn\'t equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>', 'DeclineInvitationsRequest$AccountIds' => '<p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>', 'DeleteInvitationsRequest$AccountIds' => '<p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>', 'DescribeClassificationJobResponse$AllowListIds' => '<p>An array of unique identifiers, one for each allow list that the job is configured to use when it analyzes data.</p>', 'DescribeClassificationJobResponse$CustomDataIdentifierIds' => '<p>An array of unique identifiers, one for each custom data identifier that the job is configured to use when it analyzes data. This value is null if the job is configured to use only managed data identifiers to analyze data.</p>', 'DescribeClassificationJobResponse$ManagedDataIdentifierIds' => '<p>An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type specified for the job (managedDataIdentifierSelector).</p><p>This value is null if the job\'s managed data identifier selection type is ALL, NONE, or RECOMMENDED.</p>', 'GetCustomDataIdentifierResponse$IgnoreWords' => '<p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.</p>', 'GetCustomDataIdentifierResponse$Keywords' => '<p>An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren\'t case sensitive.</p>', 'GetFindingsRequest$FindingIds' => '<p>An array of strings that lists the unique identifiers for the findings to retrieve. You can specify as many as 50 unique identifiers in this array.</p>', 'ListFindingsResponse$FindingIds' => '<p>An array of strings, where each string is the unique identifier for a finding that matches the filter criteria specified in the request.</p>', 'ListJobsFilterTerm$Values' => '<p>An array that lists one or more values to use to filter the results.</p>', 'ReplicationDetails$ReplicationAccounts' => '<p>An array of Amazon Web Services account IDs, one for each Amazon Web Services account that owns a bucket that the bucket is configured to replicate one or more objects to.</p>', 'S3BucketDefinitionForJob$Buckets' => '<p>An array that lists the names of the buckets.</p>', 'SearchResourcesSimpleCriterion$Values' => '<p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p> <ul><li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource.</p></li> <li><p>AUTOMATED_DISCOVERY_MONITORING_STATUS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-automateddiscoverymonitoringstatus">BucketMetadata.automatedDiscoveryMonitoringStatus</a> property of an S3 bucket.</p></li> <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of an S3 bucket.</p></li> <li><p>S3_BUCKET_NAME - A string that represents the name of an S3 bucket.</p></li> <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of an S3 bucket.</p></li></ul> <p>Values are case sensitive. Also, Macie doesn\'t support use of partial values or wildcard characters in values.</p>', 'SensitivityInspectionTemplateExcludes$ManagedDataIdentifierIds' => '<p>An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of valid values, use the ListManagedDataIdentifiers operation.</p>', 'SensitivityInspectionTemplateIncludes$AllowListIds' => '<p>An array of unique identifiers, one for each allow list to include.</p>', 'SensitivityInspectionTemplateIncludes$CustomDataIdentifierIds' => '<p>An array of unique identifiers, one for each custom data identifier to include.</p>', 'SensitivityInspectionTemplateIncludes$ManagedDataIdentifierIds' => '<p>An array of unique identifiers, one for each managed data identifier to include.</p> <p>Amazon Macie uses these managed data identifiers in addition to managed data identifiers that are subsequently released and recommended for automated sensitive data discovery. To retrieve a list of valid values for the managed data identifiers that are currently available, use the ListManagedDataIdentifiers operation.</p> <para/>', 'SimpleCriterionForJob$Values' => '<p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p> <ul><li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.</p></li> <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of a bucket.</p></li> <li><p>S3_BUCKET_NAME - A string that represents the name of a bucket.</p></li> <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of a bucket.</p></li></ul> <p>Values are case sensitive. Also, Macie doesn\'t support use of partial values or wildcard characters in these values.</p>', 'SimpleScopeTerm$Values' => '<p>An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.</p> <p>Valid values for each supported property (key) are:</p> <ul><li><p>OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf</p></li> <li><p>OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.</p></li> <li><p>OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2023-09-24T14:31:13Z</p></li> <li><p>OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.</p></li></ul> <p>Macie doesn\'t support use of wildcard characters in these values. Also, string values are case sensitive.</p>', 'TestCustomDataIdentifierRequest$IgnoreWords' => '<p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>', 'TestCustomDataIdentifierRequest$Keywords' => '<p>An array that lists specific character sequences (<i>keywords</i>), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren\'t case sensitive.</p>', 'UsageStatisticsFilter$Values' => '<p>An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.</p> <p>Valid values for each supported field are:</p> <ul><li><p>accountId - The unique identifier for an Amazon Web Services account.</p></li> <li><p>freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for an account.</p></li> <li><p>serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.</p></li> <li><p>total - A string that represents the current estimated cost for an account.</p></li></ul>', ], ], '__long' => [ 'base' => NULL, 'refs' => [ 'BucketCountByEffectivePermission$PubliclyAccessible' => '<p>The total number of buckets that allow the general public to have read or write access to the bucket.</p>', 'BucketCountByEffectivePermission$PubliclyReadable' => '<p>The total number of buckets that allow the general public to have read access to the bucket.</p>', 'BucketCountByEffectivePermission$PubliclyWritable' => '<p>The total number of buckets that allow the general public to have write access to the bucket.</p>', 'BucketCountByEffectivePermission$Unknown' => '<p>The total number of buckets that Amazon Macie wasn\'t able to evaluate permissions settings for. Macie can\'t determine whether these buckets are publicly accessible.</p>', 'BucketCountByEncryptionType$KmsManaged' => '<p>The total number of buckets whose default encryption settings are configured to encrypt new objects with an KMS key, either an Amazon Web Services managed key or a customer managed key. By default, these buckets encrypt new objects automatically using DSSE-KMS or SSE-KMS encryption.</p>', 'BucketCountByEncryptionType$S3Managed' => '<p>The total number of buckets whose default encryption settings are configured to encrypt new objects with an Amazon S3 managed key. By default, these buckets encrypt new objects automatically using SSE-S3 encryption.</p>', 'BucketCountByEncryptionType$Unencrypted' => '<p>The total number of buckets that don\'t specify default server-side encryption behavior for new objects. Default encryption settings aren\'t configured for these buckets.</p>', 'BucketCountByEncryptionType$Unknown' => '<p>The total number of buckets that Amazon Macie doesn\'t have current encryption metadata for. Macie can\'t provide current data about the default encryption settings for these buckets.</p>', 'BucketCountBySharedAccessType$External' => '<p>The total number of buckets that are shared with one or more of the following or any combination of the following: an Amazon CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that isn\'t in the same Amazon Macie organization.</p>', 'BucketCountBySharedAccessType$Internal' => '<p>The total number of buckets that are shared with one or more Amazon Web Services accounts in the same Amazon Macie organization. These buckets aren\'t shared with Amazon CloudFront OAIs or OACs.</p>', 'BucketCountBySharedAccessType$NotShared' => '<p>The total number of buckets that aren\'t shared with other Amazon Web Services accounts, Amazon CloudFront OAIs, or CloudFront OACs.</p>', 'BucketCountBySharedAccessType$Unknown' => '<p>The total number of buckets that Amazon Macie wasn\'t able to evaluate shared access settings for. Macie can\'t determine whether these buckets are shared with other Amazon Web Services accounts, Amazon CloudFront OAIs, or CloudFront OACs.</p>', 'BucketCountPolicyAllowsUnencryptedObjectUploads$AllowsUnencryptedObjectUploads' => '<p>The total number of buckets that don\'t have a bucket policy or have a bucket policy that doesn\'t require server-side encryption of new objects. If a bucket policy exists, the policy doesn\'t require PutObject requests to include a valid server-side encryption header: the x-amz-server-side-encryption header with a value of AES256 or aws:kms, or the x-amz-server-side-encryption-customer-algorithm header with a value of AES256.</p>', 'BucketCountPolicyAllowsUnencryptedObjectUploads$DeniesUnencryptedObjectUploads' => '<p>The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include a valid server-side encryption header: the x-amz-server-side-encryption header with a value of AES256 or aws:kms, or the x-amz-server-side-encryption-customer-algorithm header with a value of AES256.</p>', 'BucketCountPolicyAllowsUnencryptedObjectUploads$Unknown' => '<p>The total number of buckets that Amazon Macie wasn\'t able to evaluate server-side encryption requirements for. Macie can\'t determine whether the bucket policies for these buckets require server-side encryption of new objects.</p>', 'BucketCriteriaAdditionalProperties$Gt' => '<p>The value for the property is greater than the specified value.</p>', 'BucketCriteriaAdditionalProperties$Gte' => '<p>The value for the property is greater than or equal to the specified value.</p>', 'BucketCriteriaAdditionalProperties$Lt' => '<p>The value for the property is less than the specified value.</p>', 'BucketCriteriaAdditionalProperties$Lte' => '<p>The value for the property is less than or equal to the specified value.</p>', 'BucketMetadata$ClassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>', 'BucketMetadata$ClassifiableSizeInBytes' => '<p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p> <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn\'t reflect the storage size of all versions of each applicable object in the bucket.</p>', 'BucketMetadata$ObjectCount' => '<p>The total number of objects in the bucket.</p>', 'BucketMetadata$SizeInBytes' => '<p>The total storage size, in bytes, of the bucket.</p> <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn\'t reflect the storage size of all versions of each object in the bucket.</p>', 'BucketMetadata$SizeInBytesCompressed' => '<p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p> <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn\'t reflect the storage size of all versions of each applicable object in the bucket.</p>', 'Cell$Column' => '<p>The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.</p>', 'Cell$Row' => '<p>The row number of the row that contains the sensitive data.</p>', 'ClassificationResult$SizeClassified' => '<p>The total size, in bytes, of the data that the finding applies to.</p>', 'CriterionAdditionalProperties$Gt' => '<p>The value for the property is greater than the specified value.</p>', 'CriterionAdditionalProperties$Gte' => '<p>The value for the property is greater than or equal to the specified value.</p>', 'CriterionAdditionalProperties$Lt' => '<p>The value for the property is less than the specified value.</p>', 'CriterionAdditionalProperties$Lte' => '<p>The value for the property is less than or equal to the specified value.</p>', 'CustomDataIdentifiers$TotalCount' => '<p>The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.</p>', 'CustomDetection$Count' => '<p>The total number of occurrences of the sensitive data that the custom data identifier detected.</p>', 'DefaultDetection$Count' => '<p>The total number of occurrences of the type of sensitive data that was detected.</p>', 'Detection$Count' => '<p>The total number of occurrences of the sensitive data.</p>', 'Finding$Count' => '<p>The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered unique.</p>', 'GetBucketStatisticsResponse$BucketCount' => '<p>The total number of buckets.</p>', 'GetBucketStatisticsResponse$ClassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>', 'GetBucketStatisticsResponse$ClassifiableSizeInBytes' => '<p>The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p> <p>If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each applicable object in the buckets. This value doesn\'t reflect the storage size of all versions of all applicable objects in the buckets.</p>', 'GetBucketStatisticsResponse$ObjectCount' => '<p>The total number of objects in the buckets.</p>', 'GetBucketStatisticsResponse$SizeInBytes' => '<p>The total storage size, in bytes, of the buckets.</p> <p>If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each object in the buckets. This value doesn\'t reflect the storage size of all versions of the objects in the buckets.</p>', 'GetBucketStatisticsResponse$SizeInBytesCompressed' => '<p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.</p> <p>If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each applicable object in the buckets. This value doesn\'t reflect the storage size of all versions of the applicable objects in the buckets.</p>', 'GetInvitationsCountResponse$InvitationsCount' => '<p>The total number of invitations that were received by the account, not including the currently accepted invitation.</p>', 'GroupCount$Count' => '<p>The total number of findings in the group of query results.</p>', 'MatchingBucket$ClassifiableObjectCount' => '<p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>', 'MatchingBucket$ClassifiableSizeInBytes' => '<p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p> <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn\'t reflect the storage size of all versions of each applicable object in the bucket.</p>', 'MatchingBucket$ObjectCount' => '<p>The total number of objects in the bucket.</p>', 'MatchingBucket$SizeInBytes' => '<p>The total storage size, in bytes, of the bucket.</p> <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn\'t reflect the storage size of all versions of each object in the bucket.</p>', 'MatchingBucket$SizeInBytesCompressed' => '<p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p> <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn\'t reflect the storage size of all versions of each applicable object in the bucket.</p>', 'ObjectCountByEncryptionType$CustomerManaged' => '<p>The total number of objects that are encrypted with customer-provided keys. The objects use server-side encryption with customer-provided keys (SSE-C).</p>', 'ObjectCountByEncryptionType$KmsManaged' => '<p>The total number of objects that are encrypted with KMS keys, either Amazon Web Services managed keys or customer managed keys. The objects use dual-layer server-side encryption or server-side encryption with KMS keys (DSSE-KMS or SSE-KMS).</p>', 'ObjectCountByEncryptionType$S3Managed' => '<p>The total number of objects that are encrypted with Amazon S3 managed keys. The objects use server-side encryption with Amazon S3 managed keys (SSE-S3).</p>', 'ObjectCountByEncryptionType$Unencrypted' => '<p>The total number of objects that use client-side encryption or aren\'t encrypted.</p>', 'ObjectCountByEncryptionType$Unknown' => '<p>The total number of objects that Amazon Macie doesn\'t have current encryption metadata for. Macie can\'t provide current data about the encryption settings for these objects.</p>', 'ObjectLevelStatistics$FileType' => '<p>The total storage size (in bytes) or number of objects that Amazon Macie can\'t analyze because the objects don\'t have a file name extension for a supported file or storage format.</p>', 'ObjectLevelStatistics$StorageClass' => '<p>The total storage size (in bytes) or number of objects that Amazon Macie can\'t analyze because the objects use an unsupported storage class.</p>', 'ObjectLevelStatistics$Total' => '<p>The total storage size (in bytes) or number of objects that Amazon Macie can\'t analyze because the objects use an unsupported storage class or don\'t have a file name extension for a supported file or storage format.</p>', 'Page$PageNumber' => '<p>The page number of the page that contains the sensitive data.</p>', 'Range$End' => '<p>The number of lines from the beginning of the file to the end of the sensitive data.</p> ', 'Range$Start' => '<p>The number of lines from the beginning of the file to the beginning of the sensitive data.</p> ', 'Range$StartColumn' => '<p>The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the sensitive data (start) to the beginning of the sensitive data.</p>', 'Record$RecordIndex' => '<p>For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.</p>', 'ResourceStatistics$TotalBytesClassified' => '<p>The total amount of data, in bytes, that Amazon Macie has analyzed in the bucket.</p>', 'ResourceStatistics$TotalDetections' => '<p>The total number of occurrences of sensitive data that Amazon Macie has found in the bucket\'s objects. This includes occurrences that are currently suppressed by the sensitivity scoring settings for the bucket (totalDetectionsSuppressed).</p>', 'ResourceStatistics$TotalDetectionsSuppressed' => '<p>The total number of occurrences of sensitive data that are currently suppressed by the sensitivity scoring settings for the bucket. These represent occurrences of sensitive data that Amazon Macie found in the bucket\'s objects, but the occurrences were manually suppressed. By default, suppressed occurrences are excluded from the bucket\'s sensitivity score.</p>', 'ResourceStatistics$TotalItemsClassified' => '<p>The total number of objects that Amazon Macie has analyzed in the bucket.</p>', 'ResourceStatistics$TotalItemsSensitive' => '<p>The total number of the bucket\'s objects that Amazon Macie has found sensitive data in.</p>', 'ResourceStatistics$TotalItemsSkipped' => '<p>The total number of objects that Amazon Macie wasn\'t able to analyze in the bucket due to an object-level issue or error. For example, an object is a malformed file. This value includes objects that Macie wasn\'t able to analyze for reasons reported by other statistics in the ResourceStatistics object.</p>', 'ResourceStatistics$TotalItemsSkippedInvalidEncryption' => '<p>The total number of objects that Amazon Macie wasn\'t able to analyze in the bucket because the objects are encrypted with a key that Macie can\'t access. The objects use server-side encryption with customer-provided keys (SSE-C).</p>', 'ResourceStatistics$TotalItemsSkippedInvalidKms' => '<p>The total number of objects that Amazon Macie wasn\'t able to analyze in the bucket because the objects are encrypted with KMS keys that were disabled, are scheduled for deletion, or were deleted.</p>', 'ResourceStatistics$TotalItemsSkippedPermissionDenied' => '<p>The total number of objects that Amazon Macie wasn\'t able to analyze in the bucket due to the permissions settings for the objects or the permissions settings for the keys that were used to encrypt the objects.</p>', 'S3Object$Size' => '<p>The total storage size, in bytes, of the object.</p>', 'SensitiveDataItem$TotalCount' => '<p>The total number of occurrences of the sensitive data that was detected.</p>', 'SensitivityAggregations$ClassifiableSizeInBytes' => '<p>The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p> <p>If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each applicable object in the buckets. This value doesn\'t reflect the storage size of all versions of all applicable objects in the buckets.</p>', 'SensitivityAggregations$PubliclyAccessibleCount' => '<p>The total number of buckets that are publicly accessible due to a combination of permissions settings for each bucket.</p>', 'SensitivityAggregations$TotalCount' => '<p>The total number of buckets.</p>', 'SensitivityAggregations$TotalSizeInBytes' => '<p>The total storage size, in bytes, of the buckets.</p> <p>If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each object in the buckets. This value doesn\'t reflect the storage size of all versions of the objects in the buckets.</p>', 'ServiceLimit$Value' => '<p>The value for the metric specified by the UsageByAccount.type field in the response.</p>', 'Severity$Score' => '<p>The numerical representation of the finding\'s severity, ranging from 1 (least severe) to 3 (most severe).</p>', 'SeverityLevel$OccurrencesThreshold' => '<p>The minimum number of occurrences of text that must match the custom data identifier\'s detection criteria in order to produce a finding with the specified severity (severity).</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AcceptInvitationRequest$AdministratorAccountId' => '<p>The Amazon Web Services account ID for the account that sent the invitation.</p>', 'AcceptInvitationRequest$InvitationId' => '<p>The unique identifier for the invitation to accept.</p>', 'AcceptInvitationRequest$MasterAccount' => '<p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>', 'AccessDeniedException$Message' => '<p>The explanation of the error that occurred.</p>', 'AccountDetail$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'AccountDetail$Email' => '<p>The email address for the account.</p>', 'AdminAccount$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'ApiCallDetails$Api' => '<p>The name of the operation that was invoked most recently and produced the finding.</p>', 'ApiCallDetails$ApiServiceName' => '<p>The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.</p>', 'AssumedRole$AccessKeyId' => '<p>The Amazon Web Services access key ID that identifies the credentials.</p>', 'AssumedRole$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>', 'AssumedRole$Arn' => '<p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>', 'AssumedRole$PrincipalId' => '<p>The unique identifier for the entity that was used to get the credentials.</p>', 'AutomatedDiscoveryAccount$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'AutomatedDiscoveryAccountUpdate$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'AutomatedDiscoveryAccountUpdateError$AccountId' => '<p>The Amazon Web Services account ID for the account that the request applied to.</p>', 'AwsAccount$AccountId' => '<p>The unique identifier for the Amazon Web Services account.</p>', 'AwsAccount$PrincipalId' => '<p>The unique identifier for the entity that performed the action.</p>', 'AwsService$InvokedBy' => '<p>The name of the Amazon Web Service that performed the action.</p>', 'BatchGetCustomDataIdentifierSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the custom data identifier.</p>', 'BatchGetCustomDataIdentifierSummary$Description' => '<p>The custom description of the custom data identifier.</p>', 'BatchGetCustomDataIdentifierSummary$Id' => '<p>The unique identifier for the custom data identifier.</p>', 'BatchGetCustomDataIdentifierSummary$Name' => '<p>The custom name of the custom data identifier.</p>', 'BucketCriteriaAdditionalProperties$Prefix' => '<p>The name of the bucket begins with the specified value.</p>', 'BucketMetadata$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>', 'BucketMetadata$BucketArn' => '<p>The Amazon Resource Name (ARN) of the bucket.</p>', 'BucketMetadata$BucketName' => '<p>The name of the bucket.</p>', 'BucketMetadata$ErrorMessage' => '<p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket\'s objects. This value is null if Macie was able to retrieve and process the information.</p>', 'BucketMetadata$Region' => '<p>The Amazon Web Services Region that hosts the bucket.</p>', 'BucketServerSideEncryption$KmsMasterKeyId' => '<p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that\'s used by default to encrypt objects that are added to the bucket. This value is null if the bucket is configured to use an Amazon S3 managed key to encrypt new objects.</p>', 'BucketSortCriteria$AttributeName' => '<p>The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, sensitivityScore, or sizeInBytes.</p>', 'Cell$CellReference' => '<p>The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.</p>', 'Cell$ColumnName' => '<p>The name of the column that contains the sensitive data, if available.</p>', 'ClassificationDetails$DetailedResultsLocation' => '<p>The path to the folder or file in Amazon S3 that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.</p>', 'ClassificationDetails$JobArn' => '<p>The Amazon Resource Name (ARN) of the classification job that produced the finding. This value is null if the origin of the finding (originType) is AUTOMATED_SENSITIVE_DATA_DISCOVERY.</p>', 'ClassificationDetails$JobId' => '<p>The unique identifier for the classification job that produced the finding. This value is null if the origin of the finding (originType) is AUTOMATED_SENSITIVE_DATA_DISCOVERY.</p>', 'ClassificationResult$MimeType' => '<p>The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.</p>', 'ClassificationResultStatus$Code' => ' <p>The status of the finding. Possible values are:</p> <ul><li><p>COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.</p></li> <li><p>PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format.</p></li> <li><p>SKIPPED - Macie wasn\'t able to analyze the S3 object that the finding applies to. For example, the object is a file that uses an unsupported format.</p></li></ul>', 'ClassificationResultStatus$Reason' => '<p>A brief description of the status of the finding. This value is null if the status (code) of the finding is COMPLETE.</p> <p>Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding and the affected S3 object. Possible values are:</p> <ul><li><p>ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or none of the files in the archive. To determine which files Macie analyzed, if any, refer to the corresponding sensitive data discovery result for the finding (classificationDetails.detailedResultsLocation).</p></li> <li><p>ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for this type of archive.</p></li> <li><p>ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the maximum number of nested levels that Macie analyzes for this type of archive.</p></li> <li><p>ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum amount of data that Macie extracts and analyzes for this type of archive.</p></li> <li><p>ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum number of files that Macie extracts and analyzes for this type of archive.</p></li> <li><p>FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.</p></li> <li><p>INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn\'t allowed to use the key. Macie can\'t decrypt and analyze the object.</p></li> <li><p>INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can\'t decrypt and analyze the object.</p></li> <li><p>INVALID_OBJECT_STATE - The object doesn\'t use a supported Amazon S3 storage class.</p></li> <li><p>JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota for the number of nested levels that Macie analyzes for this type of file.</p></li> <li><p>MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect the file\'s type or extract data from the file.</p></li> <li><p>MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract data from the file.</p></li> <li><p>NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to analyze the object.</p></li> <li><p>OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.</p></li> <li><p>OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds the compression quota for this type of file.</p></li> <li><p>OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for this type of file.</p></li> <li><p>PERMISSION_DENIED - Macie isn\'t allowed to access the object. The object\'s permissions settings prevent Macie from analyzing the object.</p></li> <li><p>SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.</p></li> <li><p>TIME_CUT_OFF_REACHED - Macie started analyzing the object but additional analysis would exceed the time quota for analyzing an object.</p></li> <li><p>UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie attempted to parse the data.</p></li> <li><p>UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format.</p></li></ul> <p>For information about quotas, supported storage classes, and supported file and storage formats, see <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Quotas</a> and <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-storage.html">Supported storage classes and formats</a> in the <i>Amazon Macie User Guide</i>.</p>', 'ConflictException$Message' => '<p>The explanation of the error that occurred.</p>', 'CreateAllowListRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateClassificationJobRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateClassificationJobRequest$Description' => '<p>A custom description of the job. The description can contain as many as 200 characters.</p>', 'CreateClassificationJobRequest$Name' => '<p>A custom name for the job. The name can contain as many as 500 characters.</p>', 'CreateClassificationJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'CreateClassificationJobResponse$JobId' => '<p>The unique identifier for the job.</p>', 'CreateCustomDataIdentifierRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateCustomDataIdentifierRequest$Description' => '<p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'CreateCustomDataIdentifierRequest$Name' => '<p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'CreateCustomDataIdentifierRequest$Regex' => '<p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>', 'CreateCustomDataIdentifierResponse$CustomDataIdentifierId' => '<p>The unique identifier for the custom data identifier that was created.</p>', 'CreateFindingsFilterRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'CreateFindingsFilterRequest$Description' => '<p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'CreateFindingsFilterRequest$Name' => '<p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'CreateFindingsFilterResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the filter that was created.</p>', 'CreateFindingsFilterResponse$Id' => '<p>The unique identifier for the filter that was created.</p>', 'CreateInvitationsRequest$Message' => '<p>Custom text to include in the email message that contains the invitation. The text can contain as many as 80 alphanumeric characters.</p>', 'CreateMemberResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the account that was associated with the administrator account.</p>', 'CustomDataIdentifierSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the custom data identifier.</p>', 'CustomDataIdentifierSummary$Description' => '<p>The custom description of the custom data identifier.</p>', 'CustomDataIdentifierSummary$Id' => '<p>The unique identifier for the custom data identifier.</p>', 'CustomDataIdentifierSummary$Name' => '<p>The custom name of the custom data identifier.</p>', 'CustomDetection$Arn' => '<p>The unique identifier for the custom data identifier.</p>', 'CustomDetection$Name' => '<p>The name of the custom data identifier.</p>', 'DefaultDetection$Type' => '<p>The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.</p>', 'DescribeBucketsRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'DescribeBucketsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'DescribeClassificationJobResponse$ClientToken' => '<p>The token that was provided to ensure the idempotency of the request to create the job.</p>', 'DescribeClassificationJobResponse$Description' => '<p>The custom description of the job.</p>', 'DescribeClassificationJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'DescribeClassificationJobResponse$JobId' => '<p>The unique identifier for the job.</p>', 'DescribeClassificationJobResponse$Name' => '<p>The custom name of the job.</p>', 'Detection$Arn' => '<p>If the sensitive data was detected by a custom data identifier, the Amazon Resource Name (ARN) of the custom data identifier that detected the data. Otherwise, this value is null.</p>', 'Detection$Id' => '<p>The unique identifier for the custom data identifier or managed data identifier that detected the sensitive data. For additional details about a specified managed data identifier, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>', 'Detection$Name' => '<p>The name of the custom data identifier or managed data identifier that detected the sensitive data. For a managed data identifier, this value is the same as the unique identifier (id).</p>', 'DomainDetails$DomainName' => '<p>The name of the domain.</p>', 'EnableMacieRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'EnableOrganizationAdminAccountRequest$AdminAccountId' => '<p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>', 'EnableOrganizationAdminAccountRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'FederatedUser$AccessKeyId' => '<p>The Amazon Web Services access key ID that identifies the credentials.</p>', 'FederatedUser$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>', 'FederatedUser$Arn' => '<p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>', 'FederatedUser$PrincipalId' => '<p>The unique identifier for the entity that was used to get the credentials.</p>', 'Finding$AccountId' => '<p>The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.</p>', 'Finding$Description' => '<p>The description of the finding.</p>', 'Finding$Id' => '<p>The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.</p>', 'Finding$Partition' => '<p>The Amazon Web Services partition that Amazon Macie created the finding in.</p>', 'Finding$Region' => '<p>The Amazon Web Services Region that Amazon Macie created the finding in.</p>', 'Finding$SchemaVersion' => '<p>The version of the schema that was used to define the data structures in the finding.</p>', 'Finding$Title' => '<p>The brief description of the finding.</p>', 'FindingsFilterListItem$Arn' => '<p>The Amazon Resource Name (ARN) of the filter.</p>', 'FindingsFilterListItem$Id' => '<p>The unique identifier for the filter.</p>', 'FindingsFilterListItem$Name' => '<p>The custom name of the filter.</p>', 'GetBucketStatisticsRequest$AccountId' => '<p>The unique identifier for the Amazon Web Services account.</p>', 'GetCustomDataIdentifierResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the custom data identifier.</p>', 'GetCustomDataIdentifierResponse$Description' => '<p>The custom description of the custom data identifier.</p>', 'GetCustomDataIdentifierResponse$Id' => '<p>The unique identifier for the custom data identifier.</p>', 'GetCustomDataIdentifierResponse$Name' => '<p>The custom name of the custom data identifier.</p>', 'GetCustomDataIdentifierResponse$Regex' => '<p>The regular expression (<i>regex</i>) that defines the pattern to match.</p>', 'GetFindingsFilterResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the filter.</p>', 'GetFindingsFilterResponse$Description' => '<p>The custom description of the filter.</p>', 'GetFindingsFilterResponse$Id' => '<p>The unique identifier for the filter.</p>', 'GetFindingsFilterResponse$Name' => '<p>The custom name of the filter.</p>', 'GetMacieSessionResponse$ServiceRole' => '<p>The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and analyze data in Amazon Web Services resources for the account.</p>', 'GetMemberResponse$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'GetMemberResponse$AdministratorAccountId' => '<p>The Amazon Web Services account ID for the administrator account.</p>', 'GetMemberResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the account.</p>', 'GetMemberResponse$Email' => '<p>The email address for the account. This value is null if the account is associated with the administrator account through Organizations.</p>', 'GetMemberResponse$MasterAccountId' => '<p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>', 'GetSensitiveDataOccurrencesResponse$Error' => '<p>If an error occurred when Amazon Macie attempted to retrieve occurrences of sensitive data reported by the finding, a description of the error that occurred. This value is null if the status (status) of the request is PROCESSING or SUCCESS.</p>', 'GetSensitivityInspectionTemplateResponse$Description' => '<p>The custom description of the template.</p>', 'GetSensitivityInspectionTemplateResponse$Name' => '<p>The name of the template: automated-sensitive-data-discovery.</p>', 'GetUsageStatisticsRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'GetUsageStatisticsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'GroupCount$GroupKey' => '<p>The name of the property that defines the group in the query results, as specified by the groupBy property in the query request.</p>', 'IamUser$AccountId' => '<p>The unique identifier for the Amazon Web Services account that\'s associated with the IAM user who performed the action.</p>', 'IamUser$Arn' => '<p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.</p>', 'IamUser$PrincipalId' => '<p>The unique identifier for the IAM user who performed the action.</p>', 'IamUser$UserName' => '<p>The username of the IAM user who performed the action.</p>', 'InternalServerException$Message' => '<p>The explanation of the error that occurred.</p>', 'Invitation$AccountId' => '<p>The Amazon Web Services account ID for the account that sent the invitation.</p>', 'Invitation$InvitationId' => '<p>The unique identifier for the invitation.</p>', 'IpAddressDetails$IpAddressV4' => '<p>The Internet Protocol version 4 (IPv4) address of the device.</p>', 'IpCity$Name' => '<p>The name of the city.</p>', 'IpCountry$Code' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country that the IP address originated from. For example, US for the United States.</p>', 'IpCountry$Name' => '<p>The name of the country that the IP address originated from.</p>', 'IpOwner$Asn' => '<p>The autonomous system number (ASN) for the autonomous system that included the IP address.</p>', 'IpOwner$AsnOrg' => '<p>The organization identifier that\'s associated with the autonomous system number (ASN) for the autonomous system that included the IP address.</p>', 'IpOwner$Isp' => '<p>The name of the internet service provider (ISP) that owned the IP address.</p>', 'IpOwner$Org' => '<p>The name of the organization that owned the IP address.</p>', 'JobDetails$LastJobId' => '<p>The unique identifier for the job that ran most recently and is configured to analyze objects in the bucket, either the latest run of a recurring job or the only run of a one-time job.</p> <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>', 'JobSummary$JobId' => '<p>The unique identifier for the job.</p>', 'JobSummary$Name' => '<p>The custom name of the job.</p>', 'KeyValuePair$Key' => '<p>One part of a key-value pair that comprises a tag. A tag key is a general label that acts as a category for more specific tag values.</p>', 'KeyValuePair$Value' => '<p>One part of a key-value pair that comprises a tag. A tag value acts as a descriptor for a tag key. A tag value can be an empty string.</p>', 'ListAllowListsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListAutomatedDiscoveryAccountsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListClassificationJobsRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'ListClassificationJobsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListCustomDataIdentifiersRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'ListCustomDataIdentifiersResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListFindingsFiltersResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListFindingsRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'ListFindingsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListInvitationsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListManagedDataIdentifiersRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'ListManagedDataIdentifiersResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListMembersResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListOrganizationAdminAccountsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListResourceProfileArtifactsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListResourceProfileDetectionsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListSensitivityInspectionTemplatesResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ManagedDataIdentifierSummary$Id' => '<p>The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.</p>', 'MatchingBucket$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>', 'MatchingBucket$BucketName' => '<p>The name of the bucket.</p>', 'MatchingBucket$ErrorMessage' => '<p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket\'s objects. This value is null if Macie was able to retrieve and process the information.</p>', 'Member$AccountId' => '<p>The Amazon Web Services account ID for the account.</p>', 'Member$AdministratorAccountId' => '<p>The Amazon Web Services account ID for the administrator account.</p>', 'Member$Arn' => '<p>The Amazon Resource Name (ARN) of the account.</p>', 'Member$Email' => '<p>The email address for the account. This value is null if the account is associated with the administrator account through Organizations.</p>', 'Member$MasterAccountId' => '<p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>', 'PutFindingsPublicationConfigurationRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'Record$JsonPath' => '<p>The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data.</p> <p>If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 240 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.</p>', 'ResourceNotFoundException$Message' => '<p>The explanation of the error that occurred.</p>', 'ResourceProfileArtifact$Arn' => '<p>The Amazon Resource Name (ARN) of the object.</p>', 'ResourceProfileArtifact$ClassificationResultStatus' => '<p>The status of the analysis. Possible values are:</p> <ul><li><p>COMPLETE - Amazon Macie successfully completed its analysis of the object.</p></li> <li><p>PARTIAL - Macie analyzed only a subset of data in the object. For example, the object is an archive file that contains files in an unsupported format.</p></li> <li><p>SKIPPED - Macie wasn\'t able to analyze the object. For example, the object is a malformed file.</p></li></ul>', 'RetrievalConfiguration$ExternalId' => '<p>The external ID to specify in the trust policy for the IAM role to assume when retrieving sensitive data from affected S3 objects (roleName). This value is null if the value for retrievalMode is CALLER_CREDENTIALS.</p> <p>This ID is a unique alphanumeric string that Amazon Macie generates automatically after you configure it to assume an IAM role. For a Macie administrator to retrieve sensitive data from an affected S3 object for a member account, the trust policy for the role in the member account must include an sts:ExternalId condition that requires this ID.</p>', 'S3Bucket$Arn' => '<p>The Amazon Resource Name (ARN) of the bucket.</p>', 'S3Bucket$Name' => '<p>The name of the bucket.</p>', 'S3BucketDefinitionForJob$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the buckets.</p>', 'S3BucketOwner$DisplayName' => '<p>The display name of the account that owns the bucket.</p>', 'S3BucketOwner$Id' => '<p>The canonical user ID for the account that owns the bucket.</p>', 'S3Destination$BucketName' => '<p>The name of the bucket. This must be the name of an existing general purpose bucket.</p>', 'S3Destination$KeyPrefix' => '<p>The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.</p>', 'S3Destination$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric encryption KMS key that\'s enabled in the same Amazon Web Services Region as the bucket.</p>', 'S3Object$BucketArn' => '<p>The Amazon Resource Name (ARN) of the bucket that contains the object.</p>', 'S3Object$ETag' => '<p>The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.</p>', 'S3Object$Extension' => '<p>The file name extension of the object. If the object doesn\'t have a file name extension, this value is "".</p>', 'S3Object$Key' => '<p>The full name (<i>key</i>) of the object, including the object\'s prefix if applicable.</p>', 'S3Object$Path' => '<p>The full path to the affected object, including the name of the affected bucket and the object\'s name (key).</p>', 'S3Object$VersionId' => '<p>The identifier for the affected version of the object.</p>', 'SearchResourcesRequest$NextToken' => '<p>The nextToken string that specifies which page of results to return in a paginated response.</p>', 'SearchResourcesResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'SearchResourcesTagCriterionPair$Key' => '<p>The value for the tag key to use in the condition.</p>', 'SearchResourcesTagCriterionPair$Value' => '<p>The tag value to use in the condition.</p>', 'SensitivityInspectionTemplatesEntry$Id' => '<p>The unique identifier for the sensitivity inspection template.</p>', 'SensitivityInspectionTemplatesEntry$Name' => '<p>The name of the sensitivity inspection template: automated-sensitive-data-discovery.</p>', 'ServerSideEncryption$KmsMasterKeyId' => '<p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that\'s used to encrypt data in the bucket or the object. This value is null if an KMS key isn\'t used to encrypt the data.</p>', 'ServiceQuotaExceededException$Message' => '<p>The explanation of the error that occurred.</p>', 'SessionIssuer$AccountId' => '<p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>', 'SessionIssuer$Arn' => '<p>The Amazon Resource Name (ARN) of the source account, Identity and Access Management (IAM) user, or role that was used to get the credentials.</p>', 'SessionIssuer$PrincipalId' => '<p>The unique identifier for the entity that was used to get the credentials.</p>', 'SessionIssuer$Type' => '<p>The source of the temporary security credentials, such as Root, IAMUser, or Role.</p>', 'SessionIssuer$UserName' => '<p>The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn\'t have an alias.</p>', 'SortCriteria$AttributeName' => '<p>The name of the property to sort the results by. Valid values are: count, createdAt, policyDetails.action.apiCallDetails.firstSeen, policyDetails.action.apiCallDetails.lastSeen, resourcesAffected, severity.score, type, and updatedAt.</p>', 'SuppressDataIdentifier$Id' => '<p>The unique identifier for the custom data identifier or managed data identifier that detected the type of sensitive data to exclude or include in the score.</p>', 'TagCriterionPairForJob$Key' => '<p>The value for the tag key to use in the condition.</p>', 'TagCriterionPairForJob$Value' => '<p>The tag value to use in the condition.</p>', 'TagMap$member' => NULL, 'TagScopeTerm$Key' => '<p>The object property to use in the condition. The only valid value is TAG.</p>', 'TagValuePair$Key' => '<p>The value for the tag key to use in the condition.</p>', 'TagValuePair$Value' => '<p>The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.</p>', 'TestCustomDataIdentifierRequest$Regex' => '<p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>', 'TestCustomDataIdentifierRequest$SampleText' => '<p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>', 'ThrottlingException$Message' => '<p>The explanation of the error that occurred.</p>', 'UnprocessableEntityException$Message' => '<p>The type of error that occurred and prevented Amazon Macie from retrieving occurrences of sensitive data reported by the finding. Possible values are:</p> <ul><li><p>ACCOUNT_NOT_IN_ORGANIZATION - The affected account isn\'t currently part of your organization. Or the account is part of your organization but Macie isn\'t currently enabled for the account. You\'re not allowed to access the affected S3 object by using Macie.</p></li> <li><p>INVALID_CLASSIFICATION_RESULT - There isn\'t a corresponding sensitive data discovery result for the finding. Or the corresponding sensitive data discovery result isn\'t available in the current Amazon Web Services Region, is malformed or corrupted, or uses an unsupported storage format. Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>INVALID_RESULT_SIGNATURE - The corresponding sensitive data discovery result is stored in an S3 object that wasn\'t signed by Macie. Macie can\'t verify the integrity and authenticity of the sensitive data discovery result. Therefore, Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>MEMBER_ROLE_TOO_PERMISSIVE - The trust or permissions policy for the IAM role in the affected member account doesn\'t meet Macie requirements for restricting access to the role. Or the role\'s trust policy doesn\'t specify the correct external ID for your organization. Macie can\'t assume the role to retrieve the sensitive data.</p></li> <li><p>MISSING_GET_MEMBER_PERMISSION - You\'re not allowed to retrieve information about the association between your account and the affected account. Macie can\'t determine whether you’re allowed to access the affected S3 object as the delegated Macie administrator for the affected account.</p></li> <li><p>OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving occurrences of sensitive data from this type of file.</p></li> <li><p>OBJECT_UNAVAILABLE - The affected S3 object isn\'t available. The object was renamed, moved, deleted, or changed after Macie created the finding. Or the object is encrypted with an KMS key that\'s currently disabled.</p></li> <li><p>RESULT_NOT_SIGNED - The corresponding sensitive data discovery result is stored in an S3 object that hasn\'t been signed. Macie can\'t verify the integrity and authenticity of the sensitive data discovery result. Therefore, Macie can\'t verify the location of the sensitive data to retrieve.</p></li> <li><p>ROLE_TOO_PERMISSIVE - Your account is configured to retrieve occurrences of sensitive data by using an IAM role whose trust or permissions policy doesn\'t meet Macie requirements for restricting access to the role. Macie can’t assume the role to retrieve the sensitive data.</p></li> <li><p>UNSUPPORTED_FINDING_TYPE - The specified finding isn\'t a sensitive data finding.</p></li> <li><p>UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn\'t support for retrieving occurrences of sensitive data.</p></li></ul>', 'UnprocessedAccount$AccountId' => '<p>The Amazon Web Services account ID for the account that the request applies to.</p>', 'UnprocessedAccount$ErrorMessage' => '<p>The reason why the request hasn\'t been processed.</p>', 'UpdateFindingsFilterRequest$ClientToken' => '<p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>', 'UpdateFindingsFilterRequest$Description' => '<p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'UpdateFindingsFilterRequest$Name' => '<p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they\'re allowed to perform in Amazon Macie.</p>', 'UpdateFindingsFilterResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the filter that was updated.</p>', 'UpdateFindingsFilterResponse$Id' => '<p>The unique identifier for the filter that was updated.</p>', 'UpdateSensitivityInspectionTemplateRequest$Description' => '<p>A custom description of the template. The description can contain as many as 200 characters.</p>', 'UsageByAccount$EstimatedCost' => '<p>The estimated value for the metric.</p>', 'UsageRecord$AccountId' => '<p>The unique identifier for the Amazon Web Services account that the data applies to.</p>', 'UsageTotal$EstimatedCost' => '<p>The estimated value for the metric.</p>', 'UserIdentityRoot$AccountId' => '<p>The unique identifier for the Amazon Web Services account.</p>', 'UserIdentityRoot$Arn' => '<p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.</p>', 'UserIdentityRoot$PrincipalId' => '<p>The unique identifier for the entity that performed the action.</p>', 'UserPausedDetails$JobImminentExpirationHealthEventArn' => '<p>The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run\'s pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.</p>', 'ValidationException$Message' => '<p>The explanation of the error that occurred.</p>', '__listOf__string$member' => NULL, ], ], '__stringMin1Max1024PatternSS' => [ 'base' => NULL, 'refs' => [ 'AllowListStatus$Description' => '<p>A brief description of the status of the allow list. Amazon Macie uses this value to provide additional information about an error that occurred when Macie tried to access and use the list\'s criteria.</p>', 'S3WordsList$ObjectKey' => '<p>The full name (key) of the object.</p>', ], ], '__stringMin1Max128' => [ 'base' => NULL, 'refs' => [ 'DetectedDataDetails$Value' => '<p>An occurrence of the specified type of sensitive data. Each occurrence contains 1-128 characters.</p>', ], ], '__stringMin1Max128Pattern' => [ 'base' => NULL, 'refs' => [ 'AllowListSummary$Name' => '<p>The custom name of the allow list.</p>', 'CreateAllowListRequest$Name' => '<p>A custom name for the allow list. The name can contain as many as 128 characters.</p>', 'GetAllowListResponse$Name' => '<p>The custom name of the allow list.</p>', 'UpdateAllowListRequest$Name' => '<p>A custom name for the allow list. The name can contain as many as 128 characters.</p>', ], ], '__stringMin1Max2048' => [ 'base' => NULL, 'refs' => [ 'RevealConfiguration$KmsKeyId' => '<p>The Amazon Resource Name (ARN), ID, or alias of the KMS key to use to encrypt sensitive data that\'s retrieved. The key must be an existing, customer managed, symmetric encryption key that\'s enabled in the same Amazon Web Services Region as the Amazon Macie account.</p> <p>If this value specifies an alias, it must include the following prefix: alias/. If this value specifies a key that\'s owned by another Amazon Web Services account, it must specify the ARN of the key or the ARN of the key\'s alias.</p>', ], ], '__stringMin1Max512PatternSS' => [ 'base' => NULL, 'refs' => [ 'AllowListCriteria$Regex' => '<p>The regular expression (<i>regex</i>) that defines the text pattern to ignore. The expression can contain as many as 512 characters.</p>', 'AllowListSummary$Description' => '<p>The custom description of the allow list.</p>', 'CreateAllowListRequest$Description' => '<p>A custom description of the allow list. The description can contain as many as 512 characters.</p>', 'GetAllowListResponse$Description' => '<p>The custom description of the allow list.</p>', 'UpdateAllowListRequest$Description' => '<p>A custom description of the allow list. The description can contain as many as 512 characters.</p>', ], ], '__stringMin1Max64PatternW' => [ 'base' => NULL, 'refs' => [ 'RetrievalConfiguration$RoleName' => '<p>The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is allowed to assume when retrieving sensitive data from affected S3 objects for the account. This value is null if the value for retrievalMode is CALLER_CREDENTIALS.</p>', 'UpdateRetrievalConfiguration$RoleName' => '<p>The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is allowed to assume when retrieving sensitive data from affected S3 objects for the account. The trust and permissions policies for the role must meet all requirements for Macie to assume the role.</p>', ], ], '__stringMin22Max22PatternAZ0922' => [ 'base' => NULL, 'refs' => [ 'AllowListSummary$Id' => '<p>The unique identifier for the allow list.</p>', 'CreateAllowListResponse$Id' => '<p>The unique identifier for the allow list.</p>', 'GetAllowListResponse$Id' => '<p>The unique identifier for the allow list.</p>', 'UpdateAllowListResponse$Id' => '<p>The unique identifier for the allow list.</p>', ], ], '__stringMin3Max255PatternAZaZ093255' => [ 'base' => NULL, 'refs' => [ 'S3WordsList$BucketName' => '<p>The full name of the S3 bucket that contains the object.</p>', ], ], '__stringMin71Max89PatternArnAwsAwsCnAwsUsGovMacie2AZ19920D12AllowListAZ0922' => [ 'base' => NULL, 'refs' => [ 'AllowListSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the allow list.</p>', 'CreateAllowListResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the allow list.</p>', 'GetAllowListResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the allow list.</p>', 'UpdateAllowListResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the allow list.</p>', ], ], '__timestampIso8601' => [ 'base' => NULL, 'refs' => [ 'AllowListSummary$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon Macie.</p>', 'AllowListSummary$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the allow list\'s settings were most recently changed in Amazon Macie.</p>', 'ApiCallDetails$FirstSeen' => '<p>The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.</p>', 'ApiCallDetails$LastSeen' => '<p>The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.</p>', 'BatchGetCustomDataIdentifierSummary$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>', 'BucketMetadata$BucketCreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created. This value can also indicate when changes such as edits to the bucket\'s policy were most recently made to the bucket.</p>', 'BucketMetadata$LastAutomatedDiscoveryTime' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently analyzed objects in the bucket while performing automated sensitive data discovery. This value is null if automated sensitive data discovery is disabled for your account.</p>', 'BucketMetadata$LastUpdated' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved bucket or object metadata from Amazon S3 for the bucket.</p>', 'CustomDataIdentifierSummary$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>', 'DescribeClassificationJobResponse$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>', 'DescribeClassificationJobResponse$LastRunTime' => '<p>The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started or, if the job hasn\'t run yet, when the job was created.</p>', 'Finding$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie created the finding.</p>', 'Finding$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie last updated the finding. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new.</p>', 'GetAllowListResponse$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the allow list was created in Amazon Macie.</p>', 'GetAllowListResponse$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the allow list\'s settings were most recently changed in Amazon Macie.</p>', 'GetBucketStatisticsResponse$LastUpdated' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved bucket or object metadata from Amazon S3 for the buckets.</p>', 'GetCustomDataIdentifierResponse$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>', 'GetMacieSessionResponse$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.</p>', 'GetMacieSessionResponse$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status or configuration settings for the Amazon Macie account.</p>', 'GetMemberResponse$InvitedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie membership invitation hasn\'t been sent to the account.</p>', 'GetMemberResponse$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>', 'GetResourceProfileResponse$ProfileUpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently recalculated sensitive data discovery statistics and details for the bucket. If the bucket\'s sensitivity score is calculated automatically, this includes the score.</p>', 'Invitation$InvitedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.</p>', 'JobDetails$LastJobRunTime' => '<p>The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.</p> <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>', 'JobSummary$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>', 'MatchingBucket$LastAutomatedDiscoveryTime' => '<p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently analyzed objects in the bucket while performing automated sensitive data discovery. This value is null if automated sensitive data discovery is disabled for your account.</p>', 'Member$InvitedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie membership invitation hasn\'t been sent to the account.</p>', 'Member$UpdatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>', 'S3Bucket$CreatedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created. This value can also indicate when changes such as edits to the bucket\'s policy were most recently made to the bucket, relative to when the finding was created or last updated.</p>', 'S3Object$LastModified' => '<p>The date and time, in UTC and extended ISO 8601 format, when the object was last modified.</p>', 'SessionContextAttributes$CreationDate' => '<p>The date and time, in UTC and ISO 8601 format, when the credentials were issued.</p>', 'UsageRecord$AutomatedDiscoveryFreeTrialStartDate' => '<p>The date and time, in UTC and extended ISO 8601 format, when the free trial of automated sensitive data discovery started for the account. This value is null if automated sensitive data discovery hasn\'t been enabled for the account.</p>', 'UsageRecord$FreeTrialStartDate' => '<p>The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for the account.</p>', 'UserPausedDetails$JobExpiresAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don\'t resume it first.</p>', 'UserPausedDetails$JobPausedAt' => '<p>The date and time, in UTC and extended ISO 8601 format, when you paused the job.</p>', ], ], ],];
