<?php
// This file was auto-generated from sdk-root/src/data/marketplace-catalog/2018-09-17/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Catalog API actions allow you to manage your entities through list, describe, and update capabilities. An entity can be a product or an offer on AWS Marketplace. </p> <p>You can automate your entity update process by integrating the AWS Marketplace Catalog API with your AWS Marketplace product build or deployment pipelines. You can also create your own applications on top of the Catalog API to manage your products on AWS Marketplace.</p>', 'operations' => [ 'BatchDescribeEntities' => '<p>Returns metadata and content for multiple entities. This is the Batch version of the <code>DescribeEntity</code> API and uses the same IAM permission action as <code>DescribeEntity</code> API.</p>', 'CancelChangeSet' => '<p>Used to cancel an open change request. Must be sent before the status of the request changes to <code>APPLYING</code>, the final stage of completing your change request. You can describe a change during the 60-day request history retention period for API calls.</p>', 'DeleteResourcePolicy' => '<p>Deletes a resource-based policy on an entity that is identified by its resource ARN.</p>', 'DescribeChangeSet' => '<p>Provides information about a given change set.</p>', 'DescribeEntity' => '<p>Returns the metadata and content of the entity.</p>', 'GetResourcePolicy' => '<p>Gets a resource-based policy of an entity that is identified by its resource ARN.</p>', 'ListChangeSets' => '<p>Returns the list of change sets owned by the account being used to make the call. You can filter this list by providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more than one filter, the API operation applies a logical AND between the filters.</p> <p>You can describe a change during the 60-day request history retention period for API calls.</p>', 'ListEntities' => '<p>Provides the list of entities of a given type.</p>', 'ListTagsForResource' => '<p>Lists all tags that have been added to a resource (either an <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities">entity</a> or <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">change set</a>).</p>', 'PutResourcePolicy' => '<p>Attaches a resource-based policy to an entity. Examples of an entity include: <code>AmiProduct</code> and <code>ContainerProduct</code>.</p>', 'StartChangeSet' => '<p>Allows you to request changes for your entities. Within a single <code>ChangeSet</code>, you can\'t start the same change type against the same entity multiple times. Additionally, when a <code>ChangeSet</code> is running, all the entities targeted by the different changes are locked until the change set has completed (either succeeded, cancelled, or failed). If you try to start a change set containing a change against an entity that is already locked, you will receive a <code>ResourceInUseException</code> error.</p> <p>For example, you can\'t start the <code>ChangeSet</code> described in the <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples">example</a> later in this topic because it contains two changes to run the same change type (<code>AddRevisions</code>) against the same entity (<code>entity-id@1</code>).</p> <p>For more information about working with change sets, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"> Working with change sets</a>. For information about change types for single-AMI products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products">Working with single-AMI products</a>. Also, for more information about change types available for container-based products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products">Working with container products</a>.</p>', 'TagResource' => '<p>Tags a resource (either an <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities">entity</a> or <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">change set</a>).</p>', 'UntagResource' => '<p>Removes a tag or list of tags from a resource (either an <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities">entity</a> or <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">change set</a>).</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'CancelChangeSetResponse$ChangeSetArn' => '<p>The ARN associated with the change set referenced in this request.</p>', 'ChangeSetSummaryListItem$ChangeSetArn' => '<p>The ARN associated with the unique identifier for the change set referenced in this request.</p>', 'DescribeChangeSetResponse$ChangeSetArn' => '<p>The ARN associated with the unique identifier for the change set referenced in this request.</p>', 'DescribeEntityResponse$EntityArn' => '<p>The ARN associated to the unique identifier for the entity referenced in this request.</p>', 'EntityDetail$EntityArn' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'EntitySummary$EntityArn' => '<p>The ARN associated with the unique identifier for the entity.</p>', 'StartChangeSetResponse$ChangeSetArn' => '<p>The ARN associated to the unique identifier generated for the request.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Access is denied.</p> <p>HTTP status code: 403</p>', 'refs' => [], ], 'AmiProductEntityIdFilter' => [ 'base' => '<p>Object that allows filtering on entity id of an AMI product.</p>', 'refs' => [ 'AmiProductFilters$EntityId' => '<p>Unique identifier for the AMI product.</p>', ], ], 'AmiProductEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AmiProductEntityIdFilter$ValueList' => '<p>A string array of unique entity id values to be filtered on.</p>', ], ], 'AmiProductEntityIdString' => [ 'base' => NULL, 'refs' => [ 'AmiProductEntityIdFilterValueList$member' => NULL, ], ], 'AmiProductFilters' => [ 'base' => '<p>Object containing all the filter fields for AMI products. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$AmiProductFilters' => '<p>A filter for AMI products.</p>', ], ], 'AmiProductLastModifiedDateFilter' => [ 'base' => '<p>Object that allows filtering based on the last modified date of AMI products.</p>', 'refs' => [ 'AmiProductFilters$LastModifiedDate' => '<p>The last date on which the AMI product was modified.</p>', ], ], 'AmiProductLastModifiedDateFilterDateRange' => [ 'base' => '<p>Object that contains date range of the last modified date to be filtered on. You can optionally provide a <code>BeforeValue</code> and/or <code>AfterValue</code>. Both are inclusive.</p>', 'refs' => [ 'AmiProductLastModifiedDateFilter$DateRange' => '<p>Dates between which the AMI product was last modified.</p>', ], ], 'AmiProductSort' => [ 'base' => '<p>Objects that allows sorting on AMI products based on certain fields and sorting order.</p>', 'refs' => [ 'EntityTypeSort$AmiProductSort' => '<p>A sort for AMI products.</p>', ], ], 'AmiProductSortBy' => [ 'base' => NULL, 'refs' => [ 'AmiProductSort$SortBy' => '<p>Field to sort the AMI products by.</p>', ], ], 'AmiProductSummary' => [ 'base' => '<p>Object that contains summarized information about an AMI product.</p>', 'refs' => [ 'EntitySummary$AmiProductSummary' => '<p>An object that contains summary information about the AMI product.</p>', ], ], 'AmiProductTitleFilter' => [ 'base' => '<p>Object that allows filtering on product title.</p>', 'refs' => [ 'AmiProductFilters$ProductTitle' => '<p>The title of the AMI product.</p>', ], ], 'AmiProductTitleFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AmiProductTitleFilter$ValueList' => '<p>A string array of unique product title values to be filtered on.</p>', ], ], 'AmiProductTitleString' => [ 'base' => NULL, 'refs' => [ 'AmiProductSummary$ProductTitle' => '<p>The title of the AMI product.</p>', 'AmiProductTitleFilter$WildCardValue' => '<p>A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value as a substring in the actual value.</p>', 'AmiProductTitleFilterValueList$member' => NULL, ], ], 'AmiProductVisibilityFilter' => [ 'base' => '<p>Object that allows filtering on the visibility of the product in the AWS Marketplace.</p>', 'refs' => [ 'AmiProductFilters$Visibility' => '<p>The visibility of the AMI product.</p>', ], ], 'AmiProductVisibilityFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AmiProductVisibilityFilter$ValueList' => '<p>A string array of unique visibility values to be filtered on.</p>', ], ], 'AmiProductVisibilityString' => [ 'base' => NULL, 'refs' => [ 'AmiProductSummary$Visibility' => '<p>The lifecycle of the AMI product.</p>', 'AmiProductVisibilityFilterValueList$member' => NULL, ], ], 'BatchDescribeEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeErrorCodeString' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeErrorDetail$ErrorCode' => '<p>The error code returned.</p>', ], ], 'BatchDescribeErrorDetail' => [ 'base' => '<p>An object that contains an error code and error message.</p>', 'refs' => [ 'Errors$value' => NULL, ], ], 'BatchDescribeErrorMessageContent' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeErrorDetail$ErrorMessage' => '<p>The error message returned.</p>', ], ], 'CancelChangeSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelChangeSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'CancelChangeSetRequest$Catalog' => '<p>Required. The catalog related to the request. Fixed value: <code>AWSMarketplace</code>.</p>', 'DescribeChangeSetRequest$Catalog' => '<p>Required. The catalog related to the request. Fixed value: <code>AWSMarketplace</code> </p>', 'DescribeEntityRequest$Catalog' => '<p>Required. The catalog related to the request. Fixed value: <code>AWSMarketplace</code> </p>', 'EntityRequest$Catalog' => '<p>The name of the catalog the entity is present in. The only value at this time is <code>AWSMarketplace</code>.</p>', 'ListChangeSetsRequest$Catalog' => '<p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code> </p>', 'ListEntitiesRequest$Catalog' => '<p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code> </p>', 'StartChangeSetRequest$Catalog' => '<p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code> </p>', ], ], 'Change' => [ 'base' => '<p>An object that contains the <code>ChangeType</code>, <code>Details</code>, and <code>Entity</code>.</p>', 'refs' => [ 'RequestedChangeList$member' => NULL, ], ], 'ChangeName' => [ 'base' => NULL, 'refs' => [ 'Change$ChangeName' => '<p>Optional name for the change.</p>', 'ChangeSummary$ChangeName' => '<p>Optional name for the change.</p>', ], ], 'ChangeSetDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeChangeSetResponse$ChangeSet' => '<p>An array of <code>ChangeSummary</code> objects.</p>', ], ], 'ChangeSetName' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummaryListItem$ChangeSetName' => '<p>The non-unique name for the change set.</p>', 'DescribeChangeSetResponse$ChangeSetName' => '<p>The optional name provided in the <code>StartChangeSet</code> request. If you do not provide a name, one is set by default.</p>', 'StartChangeSetRequest$ChangeSetName' => '<p>Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to filter the list of change sets. </p>', ], ], 'ChangeSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsResponse$ChangeSetSummaryList' => '<p> Array of <code>ChangeSetSummaryListItem</code> objects.</p>', ], ], 'ChangeSetSummaryListItem' => [ 'base' => '<p>A summary of a change set returned in a list of change sets when the <code>ListChangeSets</code> action is called.</p>', 'refs' => [ 'ChangeSetSummaryList$member' => NULL, ], ], 'ChangeStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummaryListItem$Status' => '<p>The current status of the change set.</p>', 'DescribeChangeSetResponse$Status' => '<p>The status of the change request.</p>', ], ], 'ChangeSummary' => [ 'base' => '<p>This object is a container for common summary information about the change. The summary doesn\'t contain the whole change structure.</p>', 'refs' => [ 'ChangeSetDescription$member' => NULL, ], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'Change$ChangeType' => '<p>Change types are single string values that describe your intention for the change. Each change type is unique for each <code>EntityType</code> provided in the change\'s scope. For more information about change types available for single-AMI products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products">Working with single-AMI products</a>. Also, for more information about change types available for container-based products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products">Working with container products</a>.</p>', 'ChangeSummary$ChangeType' => '<p>The type of the change.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'StartChangeSetRequest$ClientRequestToken' => '<p>A unique token to identify the request to ensure idempotency.</p>', ], ], 'ContainerProductEntityIdFilter' => [ 'base' => '<p>Object that allows filtering on entity id of a container product.</p>', 'refs' => [ 'ContainerProductFilters$EntityId' => '<p>Unique identifier for the container product.</p>', ], ], 'ContainerProductEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ContainerProductEntityIdFilter$ValueList' => '<p>A string array of unique entity id values to be filtered on.</p>', ], ], 'ContainerProductEntityIdString' => [ 'base' => NULL, 'refs' => [ 'ContainerProductEntityIdFilterValueList$member' => NULL, ], ], 'ContainerProductFilters' => [ 'base' => '<p>Object containing all the filter fields for container products. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$ContainerProductFilters' => '<p>A filter for container products.</p>', ], ], 'ContainerProductLastModifiedDateFilter' => [ 'base' => '<p>Object that allows filtering based on the last modified date of container products.</p>', 'refs' => [ 'ContainerProductFilters$LastModifiedDate' => '<p>The last date on which the container product was modified.</p>', ], ], 'ContainerProductLastModifiedDateFilterDateRange' => [ 'base' => '<p>Object that contains date range of the last modified date to be filtered on. You can optionally provide a <code>BeforeValue</code> and/or <code>AfterValue</code>. Both are inclusive.</p>', 'refs' => [ 'ContainerProductLastModifiedDateFilter$DateRange' => '<p>Dates between which the container product was last modified.</p>', ], ], 'ContainerProductSort' => [ 'base' => '<p>Objects that allows sorting on container products based on certain fields and sorting order.</p>', 'refs' => [ 'EntityTypeSort$ContainerProductSort' => '<p>A sort for container products.</p>', ], ], 'ContainerProductSortBy' => [ 'base' => NULL, 'refs' => [ 'ContainerProductSort$SortBy' => '<p>Field to sort the container products by.</p>', ], ], 'ContainerProductSummary' => [ 'base' => '<p>Object that contains summarized information about a container product.</p>', 'refs' => [ 'EntitySummary$ContainerProductSummary' => '<p>An object that contains summary information about the container product.</p>', ], ], 'ContainerProductTitleFilter' => [ 'base' => '<p>Object that allows filtering on product title.</p>', 'refs' => [ 'ContainerProductFilters$ProductTitle' => '<p>The title of the container product.</p>', ], ], 'ContainerProductTitleFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ContainerProductTitleFilter$ValueList' => '<p>A string array of unique product title values to be filtered on.</p>', ], ], 'ContainerProductTitleString' => [ 'base' => NULL, 'refs' => [ 'ContainerProductSummary$ProductTitle' => '<p>The title of the container product.</p>', 'ContainerProductTitleFilter$WildCardValue' => '<p>A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value as a substring in the actual value.</p>', 'ContainerProductTitleFilterValueList$member' => NULL, ], ], 'ContainerProductVisibilityFilter' => [ 'base' => '<p>Object that allows filtering on the visibility of the product in the AWS Marketplace.</p>', 'refs' => [ 'ContainerProductFilters$Visibility' => '<p>The visibility of the container product.</p>', ], ], 'ContainerProductVisibilityFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ContainerProductVisibilityFilter$ValueList' => '<p>A string array of unique visibility values to be filtered on.</p>', ], ], 'ContainerProductVisibilityString' => [ 'base' => NULL, 'refs' => [ 'ContainerProductSummary$Visibility' => '<p>The lifecycle of the product.</p>', 'ContainerProductVisibilityFilterValueList$member' => NULL, ], ], 'DataProductEntityIdFilter' => [ 'base' => '<p>Object that allows filtering on entity id of a data product.</p>', 'refs' => [ 'DataProductFilters$EntityId' => '<p>Unique identifier for the data product.</p>', ], ], 'DataProductEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'DataProductEntityIdFilter$ValueList' => '<p>A string array of unique entity id values to be filtered on.</p>', ], ], 'DataProductEntityIdString' => [ 'base' => NULL, 'refs' => [ 'DataProductEntityIdFilterValueList$member' => NULL, ], ], 'DataProductFilters' => [ 'base' => '<p>Object containing all the filter fields for data products. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$DataProductFilters' => '<p>A filter for data products.</p>', ], ], 'DataProductLastModifiedDateFilter' => [ 'base' => '<p>Object that allows filtering based on the last modified date of data products.</p>', 'refs' => [ 'DataProductFilters$LastModifiedDate' => '<p>The last date on which the data product was modified.</p>', ], ], 'DataProductLastModifiedDateFilterDateRange' => [ 'base' => '<p>Object that contains date range of the last modified date to be filtered on. You can optionally provide a <code>BeforeValue</code> and/or <code>AfterValue</code>. Both are inclusive.</p>', 'refs' => [ 'DataProductLastModifiedDateFilter$DateRange' => '<p>Dates between which the data product was last modified.</p>', ], ], 'DataProductSort' => [ 'base' => '<p>Objects that allows sorting on data products based on certain fields and sorting order.</p>', 'refs' => [ 'EntityTypeSort$DataProductSort' => '<p>A sort for data products.</p>', ], ], 'DataProductSortBy' => [ 'base' => NULL, 'refs' => [ 'DataProductSort$SortBy' => '<p>Field to sort the data products by.</p>', ], ], 'DataProductSummary' => [ 'base' => '<p>Object that contains summarized information about a data product.</p>', 'refs' => [ 'EntitySummary$DataProductSummary' => '<p>An object that contains summary information about the data product.</p>', ], ], 'DataProductTitleFilter' => [ 'base' => '<p>Object that allows filtering on product title.</p>', 'refs' => [ 'DataProductFilters$ProductTitle' => '<p>The title of the data product.</p>', ], ], 'DataProductTitleFilterValueList' => [ 'base' => NULL, 'refs' => [ 'DataProductTitleFilter$ValueList' => '<p>A string array of unique product title values to be filtered on.</p>', ], ], 'DataProductTitleString' => [ 'base' => NULL, 'refs' => [ 'DataProductSummary$ProductTitle' => '<p>The title of the data product.</p>', 'DataProductTitleFilter$WildCardValue' => '<p>A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value as a substring in the actual value.</p>', 'DataProductTitleFilterValueList$member' => NULL, ], ], 'DataProductVisibilityFilter' => [ 'base' => '<p>Object that allows filtering on the visibility of the product in the AWS Marketplace.</p>', 'refs' => [ 'DataProductFilters$Visibility' => '<p>The visibility of the data product.</p>', ], ], 'DataProductVisibilityFilterValueList' => [ 'base' => NULL, 'refs' => [ 'DataProductVisibilityFilter$ValueList' => '<p>A string array of unique visibility values to be filtered on.</p>', ], ], 'DataProductVisibilityString' => [ 'base' => NULL, 'refs' => [ 'DataProductSummary$Visibility' => '<p>The lifecycle of the data product.</p>', 'DataProductVisibilityFilterValueList$member' => NULL, ], ], 'DateTimeISO8601' => [ 'base' => NULL, 'refs' => [ 'AmiProductLastModifiedDateFilterDateRange$AfterValue' => '<p>Date after which the AMI product was last modified.</p>', 'AmiProductLastModifiedDateFilterDateRange$BeforeValue' => '<p>Date before which the AMI product was last modified.</p>', 'ChangeSetSummaryListItem$StartTime' => '<p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was started.</p>', 'ChangeSetSummaryListItem$EndTime' => '<p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was finished.</p>', 'ContainerProductLastModifiedDateFilterDateRange$AfterValue' => '<p>Date after which the container product was last modified.</p>', 'ContainerProductLastModifiedDateFilterDateRange$BeforeValue' => '<p>Date before which the container product was last modified.</p>', 'DataProductLastModifiedDateFilterDateRange$AfterValue' => '<p>Date after which the data product was last modified.</p>', 'DataProductLastModifiedDateFilterDateRange$BeforeValue' => '<p>Date before which the data product was last modified.</p>', 'DescribeChangeSetResponse$StartTime' => '<p>The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request started. </p>', 'DescribeChangeSetResponse$EndTime' => '<p>The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request transitioned to a terminal state. The change cannot transition to a different state. Null if the request is not in a terminal state. </p>', 'DescribeEntityResponse$LastModifiedDate' => '<p>The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).</p>', 'EntityDetail$LastModifiedDate' => '<p>The last time the entity was modified.</p>', 'EntitySummary$LastModifiedDate' => '<p>The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).</p>', 'OfferAvailabilityEndDateFilterDateRange$AfterValue' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer after a date.</p>', 'OfferAvailabilityEndDateFilterDateRange$BeforeValue' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer before a date.</p>', 'OfferLastModifiedDateFilterDateRange$AfterValue' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer after a date.</p>', 'OfferLastModifiedDateFilterDateRange$BeforeValue' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer before a date.</p>', 'OfferReleaseDateFilterDateRange$AfterValue' => '<p>Allows filtering on the <code>ReleaseDate</code> of offers after a date.</p>', 'OfferReleaseDateFilterDateRange$BeforeValue' => '<p>Allows filtering on the <code>ReleaseDate</code> of offers before a date.</p>', 'OfferSummary$ReleaseDate' => '<p>The release date of the offer.</p>', 'OfferSummary$AvailabilityEndDate' => '<p>The availability end date of the offer.</p>', 'ResaleAuthorizationAvailabilityEndDateFilterDateRange$AfterValue' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization after a date.</p>', 'ResaleAuthorizationAvailabilityEndDateFilterDateRange$BeforeValue' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization before a date.</p>', 'ResaleAuthorizationAvailabilityEndDateFilterValueList$member' => NULL, 'ResaleAuthorizationCreatedDateFilterDateRange$AfterValue' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization after a date.</p>', 'ResaleAuthorizationCreatedDateFilterDateRange$BeforeValue' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization before a date.</p>', 'ResaleAuthorizationCreatedDateFilterValueList$member' => NULL, 'ResaleAuthorizationLastModifiedDateFilterDateRange$AfterValue' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization after a date.</p>', 'ResaleAuthorizationLastModifiedDateFilterDateRange$BeforeValue' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization before a date.</p>', 'ResaleAuthorizationSummary$CreatedDate' => '<p>The created date of the ResaleAuthorization.</p>', 'ResaleAuthorizationSummary$AvailabilityEndDate' => '<p>The availability end date of the ResaleAuthorization.</p>', 'SaaSProductLastModifiedDateFilterDateRange$AfterValue' => '<p>Date after which the SaaS product was last modified.</p>', 'SaaSProductLastModifiedDateFilterDateRange$BeforeValue' => '<p>Date before which the SaaS product was last modified.</p>', ], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChangeSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChangeSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'Entity' => [ 'base' => '<p>An entity contains data that describes your product, its supported features, and how it can be used or launched by your customer. </p>', 'refs' => [ 'Change$Entity' => '<p>The entity to be changed.</p>', 'ChangeSummary$Entity' => '<p>The entity to be changed.</p>', ], ], 'EntityDetail' => [ 'base' => '<p>An object that contains metadata and details about the entity.</p>', 'refs' => [ 'EntityDetails$value' => NULL, ], ], 'EntityDetails' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeEntitiesResponse$EntityDetails' => '<p>Details about each entity.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'EntityDetails$key' => NULL, 'EntityRequest$EntityId' => '<p>The ID of the entity.</p>', 'Errors$key' => NULL, ], ], 'EntityNameString' => [ 'base' => NULL, 'refs' => [ 'EntitySummary$Name' => '<p>The name for the entity. This value is not unique. It is defined by the seller.</p>', ], ], 'EntityRequest' => [ 'base' => '<p>An object that contains entity ID and the catalog in which the entity is present.</p>', 'refs' => [ 'EntityRequestList$member' => NULL, ], ], 'EntityRequestList' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeEntitiesRequest$EntityRequestList' => '<p>List of entity IDs and the catalogs the entities are present in.</p>', ], ], 'EntitySummary' => [ 'base' => '<p>This object is a container for common summary information about the entity. The summary doesn\'t contain the whole entity structure, but it does contain information common across all entities.</p>', 'refs' => [ 'EntitySummaryList$member' => NULL, ], ], 'EntitySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesResponse$EntitySummaryList' => '<p>Array of <code>EntitySummary</code> objects.</p>', ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'DescribeEntityResponse$EntityType' => '<p>The named type of the entity, in the format of <code>EntityType@Version</code>.</p>', 'Entity$Type' => '<p>The type of entity.</p>', 'EntityDetail$EntityType' => '<p>The entity type of the entity, in the format of <code>EntityType@Version</code>.</p>', 'EntitySummary$EntityType' => '<p>The type of the entity.</p>', 'ListEntitiesRequest$EntityType' => '<p>The type of entities to retrieve. Valid values are: <code>AmiProduct</code>, <code>ContainerProduct</code>, <code>DataProduct</code>, <code>SaaSProduct</code>, <code>ProcurementPolicy</code>, <code>Experience</code>, <code>Audience</code>, <code>BrandingSettings</code>, <code>Offer</code>, <code>Seller</code>, <code>ResaleAuthorization</code>.</p>', ], ], 'EntityTypeFilters' => [ 'base' => '<p>Object containing all the filter fields per entity type.</p>', 'refs' => [ 'ListEntitiesRequest$EntityTypeFilters' => '<p>A Union object containing filter shapes for all <code>EntityType</code>s. Each <code>EntityTypeFilter</code> shape will have filters applicable for that <code>EntityType</code> that can be used to search or filter entities.</p>', ], ], 'EntityTypeSort' => [ 'base' => '<p>Object containing all the sort fields per entity type.</p>', 'refs' => [ 'ListEntitiesRequest$EntityTypeSort' => '<p>A Union object containing <code>Sort</code> shapes for all <code>EntityType</code>s. Each <code>EntityTypeSort</code> shape will have <code>SortBy</code> and <code>SortOrder</code> applicable for fields on that <code>EntityType</code>. This can be used to sort the results of the filter query.</p>', ], ], 'ErrorCodeString' => [ 'base' => NULL, 'refs' => [ 'ErrorDetail$ErrorCode' => '<p>The error code that identifies the type of error.</p>', ], ], 'ErrorDetail' => [ 'base' => '<p>Details about the error.</p>', 'refs' => [ 'ErrorDetailList$member' => NULL, ], ], 'ErrorDetailList' => [ 'base' => NULL, 'refs' => [ 'ChangeSummary$ErrorDetailList' => '<p>An array of <code>ErrorDetail</code> objects associated with the change.</p>', ], ], 'Errors' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeEntitiesResponse$Errors' => '<p>A map of errors returned, with <code>EntityId</code> as the key and <code>errorDetail</code> as the value.</p>', ], ], 'ExceptionMessageContent' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'DescribeChangeSetResponse$FailureDescription' => '<p>Returned if there is a failure on the change set, but that failure is not related to any of the changes in the request.</p>', 'ErrorDetail$ErrorMessage' => '<p>The message for the error.</p>', 'InternalServiceException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotSupportedException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'FailureCode' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummaryListItem$FailureCode' => '<p>Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your request.</p>', 'DescribeChangeSetResponse$FailureCode' => '<p>Returned if the change set is in <code>FAILED</code> status. Can be either <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the <code>ErrorDetailList</code>), or <code>SERVER_FAULT</code>, which means that there is a problem in the system, and you should retry your request.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter object, used to optionally filter results from calls to the <code>ListEntities</code> and <code>ListChangeSets</code> actions.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsRequest$FilterList' => '<p>An array of filter objects.</p>', 'ListEntitiesRequest$FilterList' => '<p>An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and <code>filterValues</code>.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>For <code>ListEntities</code>, the supported value for this is an <code>EntityId</code>.</p> <p>For <code>ListChangeSets</code>, the supported values are as follows:</p>', ], ], 'FilterValueContent' => [ 'base' => NULL, 'refs' => [ 'ValueList$member' => NULL, ], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'DescribeEntityResponse$EntityIdentifier' => '<p>The identifier of the entity, in the format of <code>EntityId@RevisionId</code>.</p>', 'Entity$Identifier' => '<p>The identifier for the entity.</p>', 'EntityDetail$EntityIdentifier' => '<p>The ID of the entity, in the format of <code>EntityId@RevisionId</code>.</p>', ], ], 'Intent' => [ 'base' => NULL, 'refs' => [ 'DescribeChangeSetResponse$Intent' => '<p>The optional intent provided in the <code>StartChangeSet</code> request. If you do not provide an intent, <code>APPLY</code> is set by default.</p>', 'StartChangeSetRequest$Intent' => '<p>The intent related to the request. The default is <code>APPLY</code>. To test your request before applying changes to your entities, use <code>VALIDATE</code>. This feature is currently available for adding versions to single-AMI products. For more information, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#ami-add-version">Add a new version</a>.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>There was an internal service exception.</p> <p>HTTP status code: 500</p>', 'refs' => [], ], 'Json' => [ 'base' => NULL, 'refs' => [ 'Change$Details' => '<p>This object contains details specific to the change type of the requested change. For more information about change types available for single-AMI products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products">Working with single-AMI products</a>. Also, for more information about change types available for container-based products, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products">Working with container products</a>.</p>', 'ChangeSummary$Details' => '<p>This object contains details specific to the change type of the requested change.</p>', 'DescribeEntityResponse$Details' => '<p>This stringified JSON object includes the details of the entity.</p>', ], ], 'JsonDocumentType' => [ 'base' => NULL, 'refs' => [ 'Change$DetailsDocument' => '<p>Alternative field that accepts a JSON value instead of a string for <code>ChangeType</code> details. You can use either <code>Details</code> or <code>DetailsDocument</code>, but not both.</p>', 'ChangeSummary$DetailsDocument' => '<p>The JSON value of the details specific to the change type of the requested change.</p>', 'DescribeEntityResponse$DetailsDocument' => '<p>The JSON value of the details specific to the entity.</p>', 'EntityDetail$DetailsDocument' => '<p>An object that contains all the details of the entity.</p>', ], ], 'ListChangeSetsMaxResultInteger' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsRequest$MaxResults' => '<p>The maximum number of results returned by a single call. This value must be provided in the next call to retrieve the next set of results. By default, this value is 20.</p>', ], ], 'ListChangeSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChangeSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesMaxResultInteger' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesRequest$MaxResults' => '<p>Specifies the upper limit of the elements on a single page. If a value isn\'t provided, the default value is 20.</p>', ], ], 'ListEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsRequest$NextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListChangeSetsResponse$NextToken' => '<p>The value of the next token, if it exists. Null if there are no more results.</p>', 'ListEntitiesRequest$NextToken' => '<p>The value of the next token, if it exists. Null if there are no more results.</p>', 'ListEntitiesResponse$NextToken' => '<p>The value of the next token if it exists. Null if there is no more result.</p>', ], ], 'OfferAvailabilityEndDateFilter' => [ 'base' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer.</p>', 'refs' => [ 'OfferFilters$AvailabilityEndDate' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer.</p>', ], ], 'OfferAvailabilityEndDateFilterDateRange' => [ 'base' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.</p>', 'refs' => [ 'OfferAvailabilityEndDateFilter$DateRange' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.</p>', ], ], 'OfferBuyerAccountsFilter' => [ 'base' => '<p>Allows filtering on the <code>BuyerAccounts</code> of an offer.</p>', 'refs' => [ 'OfferFilters$BuyerAccounts' => '<p>Allows filtering on the <code>BuyerAccounts</code> of an offer.</p>', ], ], 'OfferBuyerAccountsFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'OfferBuyerAccountsFilter$WildCardValue' => '<p>Allows filtering on the <code>BuyerAccounts</code> of an offer with wild card input.</p>', ], ], 'OfferBuyerAccountsList' => [ 'base' => NULL, 'refs' => [ 'OfferSummary$BuyerAccounts' => '<p>The buyer accounts in the offer.</p>', ], ], 'OfferBuyerAccountsString' => [ 'base' => NULL, 'refs' => [ 'OfferBuyerAccountsList$member' => NULL, ], ], 'OfferEntityIdFilter' => [ 'base' => '<p>Allows filtering on the entity id of an offer.</p>', 'refs' => [ 'OfferFilters$EntityId' => '<p>Allows filtering on <code>EntityId</code> of an offer.</p>', ], ], 'OfferEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferEntityIdFilter$ValueList' => '<p>Allows filtering on entity id of an offer with list input.</p>', ], ], 'OfferEntityIdString' => [ 'base' => NULL, 'refs' => [ 'OfferEntityIdFilterValueList$member' => NULL, ], ], 'OfferFilters' => [ 'base' => '<p>Object containing all the filter fields for offers entity. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$OfferFilters' => '<p>A filter for offers.</p>', ], ], 'OfferLastModifiedDateFilter' => [ 'base' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer.</p>', 'refs' => [ 'OfferFilters$LastModifiedDate' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer.</p>', ], ], 'OfferLastModifiedDateFilterDateRange' => [ 'base' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.</p>', 'refs' => [ 'OfferLastModifiedDateFilter$DateRange' => '<p>Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.</p>', ], ], 'OfferNameFilter' => [ 'base' => '<p>Allows filtering on the <code>Name</code> of an offer.</p>', 'refs' => [ 'OfferFilters$Name' => '<p>Allows filtering on the <code>Name</code> of an offer.</p>', ], ], 'OfferNameFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferNameFilter$ValueList' => '<p>Allows filtering on the <code>Name</code> of an offer with list input.</p>', ], ], 'OfferNameString' => [ 'base' => NULL, 'refs' => [ 'OfferNameFilter$WildCardValue' => '<p>Allows filtering on the <code>Name</code> of an offer with wild card input.</p>', 'OfferNameFilterValueList$member' => NULL, 'OfferSummary$Name' => '<p>The name of the offer.</p>', ], ], 'OfferProductIdFilter' => [ 'base' => '<p>Allows filtering on the <code>ProductId</code> of an offer.</p>', 'refs' => [ 'OfferFilters$ProductId' => '<p>Allows filtering on the <code>ProductId</code> of an offer.</p>', ], ], 'OfferProductIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferProductIdFilter$ValueList' => '<p>Allows filtering on the <code>ProductId</code> of an offer with list input.</p>', ], ], 'OfferProductIdString' => [ 'base' => NULL, 'refs' => [ 'OfferProductIdFilterValueList$member' => NULL, 'OfferSummary$ProductId' => '<p>The product ID of the offer.</p>', ], ], 'OfferReleaseDateFilter' => [ 'base' => '<p>Allows filtering on the <code>ReleaseDate</code> of an offer.</p>', 'refs' => [ 'OfferFilters$ReleaseDate' => '<p>Allows filtering on the <code>ReleaseDate</code> of an offer.</p>', ], ], 'OfferReleaseDateFilterDateRange' => [ 'base' => '<p>Allows filtering on the <code>ReleaseDate</code> of an offer with date range as input.</p>', 'refs' => [ 'OfferReleaseDateFilter$DateRange' => '<p>Allows filtering on the <code>ReleaseDate</code> of an offer with date range as input.</p>', ], ], 'OfferResaleAuthorizationIdFilter' => [ 'base' => '<p>Allows filtering on the <code>ResaleAuthorizationId</code> of an offer.</p> <note> <p>Not all offers have a <code>ResaleAuthorizationId</code>. The response will only include offers for which you have permissions.</p> </note>', 'refs' => [ 'OfferFilters$ResaleAuthorizationId' => '<p>Allows filtering on the <code>ResaleAuthorizationId</code> of an offer.</p> <note> <p>Not all offers have a <code>ResaleAuthorizationId</code>. The response will only include offers for which you have permissions.</p> </note>', ], ], 'OfferResaleAuthorizationIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferResaleAuthorizationIdFilter$ValueList' => '<p>Allows filtering on the <code>ResaleAuthorizationId</code> of an offer with list input.</p>', ], ], 'OfferResaleAuthorizationIdString' => [ 'base' => NULL, 'refs' => [ 'OfferResaleAuthorizationIdFilterValueList$member' => NULL, 'OfferSummary$ResaleAuthorizationId' => '<p>The ResaleAuthorizationId of the offer.</p>', ], ], 'OfferSort' => [ 'base' => '<p>Allows to sort offers.</p>', 'refs' => [ 'EntityTypeSort$OfferSort' => '<p>A sort for offers.</p>', ], ], 'OfferSortBy' => [ 'base' => NULL, 'refs' => [ 'OfferSort$SortBy' => '<p>Allows to sort offers.</p>', ], ], 'OfferStateFilter' => [ 'base' => '<p>Allows filtering on the <code>State</code> of an offer.</p>', 'refs' => [ 'OfferFilters$State' => '<p>Allows filtering on the <code>State</code> of an offer.</p>', ], ], 'OfferStateFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferStateFilter$ValueList' => '<p>Allows filtering on the <code>State</code> of an offer with list input.</p>', ], ], 'OfferStateString' => [ 'base' => NULL, 'refs' => [ 'OfferStateFilterValueList$member' => NULL, 'OfferSummary$State' => '<p>The status of the offer.</p>', ], ], 'OfferSummary' => [ 'base' => '<p>Summarized information about an offer.</p>', 'refs' => [ 'EntitySummary$OfferSummary' => '<p>An object that contains summary information about the offer.</p>', ], ], 'OfferTargetingFilter' => [ 'base' => '<p>Allows filtering on the <code>Targeting</code> of an offer.</p>', 'refs' => [ 'OfferFilters$Targeting' => '<p>Allows filtering on the <code>Targeting</code> of an offer.</p>', ], ], 'OfferTargetingFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OfferTargetingFilter$ValueList' => '<p>Allows filtering on the <code>Targeting</code> of an offer with list input.</p>', ], ], 'OfferTargetingList' => [ 'base' => NULL, 'refs' => [ 'OfferSummary$Targeting' => '<p>The targeting in the offer.</p>', ], ], 'OfferTargetingString' => [ 'base' => NULL, 'refs' => [ 'OfferTargetingFilterValueList$member' => NULL, 'OfferTargetingList$member' => NULL, ], ], 'OwnershipType' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesRequest$OwnershipType' => '<p>Filters the returned set of entities based on their owner. The default is <code>SELF</code>. To list entities shared with you through AWS Resource Access Manager (AWS RAM), set to <code>SHARED</code>. Entities shared through the AWS Marketplace Catalog API <code>PutResourcePolicy</code> operation can\'t be discovered through the <code>SHARED</code> parameter.</p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestedChangeList' => [ 'base' => NULL, 'refs' => [ 'StartChangeSetRequest$ChangeSet' => '<p>Array of <code>change</code> object.</p>', ], ], 'ResaleAuthorizationAvailabilityEndDateFilter' => [ 'base' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$AvailabilityEndDate' => '<p>Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationAvailabilityEndDateFilterDateRange' => [ 'base' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization with date range as input.</p>', 'refs' => [ 'ResaleAuthorizationAvailabilityEndDateFilter$DateRange' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization with date range as input</p>', ], ], 'ResaleAuthorizationAvailabilityEndDateFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationAvailabilityEndDateFilter$ValueList' => '<p>Allows filtering on <code>AvailabilityEndDate</code> of a ResaleAuthorization with date value as input.</p>', ], ], 'ResaleAuthorizationCreatedDateFilter' => [ 'base' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$CreatedDate' => '<p>Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationCreatedDateFilterDateRange' => [ 'base' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization with date range as input.</p>', 'refs' => [ 'ResaleAuthorizationCreatedDateFilter$DateRange' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization with date range as input.</p>', ], ], 'ResaleAuthorizationCreatedDateFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationCreatedDateFilter$ValueList' => '<p>Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization with date value as input.</p>', ], ], 'ResaleAuthorizationEntityIdFilter' => [ 'base' => '<p>Allows filtering on <code>EntityId</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$EntityId' => '<p>Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationEntityIdFilter$ValueList' => '<p>Allows filtering on <code>EntityId</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationEntityIdString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationEntityIdFilterValueList$member' => NULL, ], ], 'ResaleAuthorizationFilters' => [ 'base' => '<p>Object containing all the filter fields for resale authorization entity. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$ResaleAuthorizationFilters' => '<p>A filter for Resale Authorizations.</p>', ], ], 'ResaleAuthorizationLastModifiedDateFilter' => [ 'base' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$LastModifiedDate' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationLastModifiedDateFilterDateRange' => [ 'base' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization with date range as input.</p>', 'refs' => [ 'ResaleAuthorizationLastModifiedDateFilter$DateRange' => '<p>Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization with date range as input.</p>', ], ], 'ResaleAuthorizationManufacturerAccountIdFilter' => [ 'base' => '<p>Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ManufacturerAccountId' => '<p>Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationManufacturerAccountIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerAccountIdFilter$ValueList' => '<p>Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationManufacturerAccountIdFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerAccountIdFilter$WildCardValue' => '<p>Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationManufacturerAccountIdString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerAccountIdFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ManufacturerAccountId' => '<p>The manufacturer account ID of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationManufacturerLegalNameFilter' => [ 'base' => '<p>Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ManufacturerLegalName' => '<p>Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationManufacturerLegalNameFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerLegalNameFilter$ValueList' => '<p>Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationManufacturerLegalNameFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerLegalNameFilter$WildCardValue' => '<p>Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationManufacturerLegalNameString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationManufacturerLegalNameFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ManufacturerLegalName' => '<p>The manufacturer legal name of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationNameFilter' => [ 'base' => '<p>Allows filtering on the <code>Name</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$Name' => '<p>Allows filtering on the <code>Name</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationNameFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationNameFilter$ValueList' => '<p>Allows filtering on the <code>Name</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationNameFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationNameFilter$WildCardValue' => '<p>Allows filtering on the <code>Name</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationNameString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationNameFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$Name' => '<p>The name of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationOfferExtendedStatusFilter' => [ 'base' => '<p>Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$OfferExtendedStatus' => '<p>Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationOfferExtendedStatusFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationOfferExtendedStatusFilter$ValueList' => '<p>Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationOfferExtendedStatusString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationOfferExtendedStatusFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$OfferExtendedStatus' => '<p>The offer extended status of the ResaleAuthorization</p>', ], ], 'ResaleAuthorizationProductIdFilter' => [ 'base' => '<p>Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ProductId' => '<p>Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationProductIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductIdFilter$ValueList' => '<p>Allows filtering on the <code>ProductId</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationProductIdFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductIdFilter$WildCardValue' => '<p>Allows filtering on the <code>ProductId</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationProductIdString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductIdFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ProductId' => '<p>The product ID of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationProductNameFilter' => [ 'base' => '<p>Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ProductName' => '<p>Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationProductNameFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductNameFilter$ValueList' => '<p>Allows filtering on the <code>ProductName</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationProductNameFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductNameFilter$WildCardValue' => '<p>Allows filtering on the <code>ProductName</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationProductNameString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationProductNameFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ProductName' => '<p>The product name of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationResellerAccountIDFilter' => [ 'base' => '<p>Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ResellerAccountID' => '<p>Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationResellerAccountIDFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerAccountIDFilter$ValueList' => '<p>Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationResellerAccountIDFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerAccountIDFilter$WildCardValue' => '<p>Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationResellerAccountIDString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerAccountIDFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ResellerAccountID' => '<p>The reseller account ID of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationResellerLegalNameFilter' => [ 'base' => '<p>Allows filtering on the ResellerLegalName of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$ResellerLegalName' => '<p>Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationResellerLegalNameFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerLegalNameFilter$ValueList' => '<p>Allows filtering on the ResellerLegalNameProductName of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationResellerLegalNameFilterWildcard' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerLegalNameFilter$WildCardValue' => '<p>Allows filtering on the ResellerLegalName of a ResaleAuthorization with wild card input.</p>', ], ], 'ResaleAuthorizationResellerLegalNameString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationResellerLegalNameFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$ResellerLegalName' => '<p>The reseller legal name of the ResaleAuthorization</p>', ], ], 'ResaleAuthorizationSort' => [ 'base' => '<p>Allows to sort ResaleAuthorization.</p>', 'refs' => [ 'EntityTypeSort$ResaleAuthorizationSort' => '<p>A sort for Resale Authorizations.</p>', ], ], 'ResaleAuthorizationSortBy' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationSort$SortBy' => '<p>Allows to sort ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationStatusFilter' => [ 'base' => '<p>Allows filtering on the <code>Status</code> of a ResaleAuthorization.</p>', 'refs' => [ 'ResaleAuthorizationFilters$Status' => '<p>Allows filtering on the <code>Status</code> of a ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationStatusFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationStatusFilter$ValueList' => '<p>Allows filtering on the <code>Status</code> of a ResaleAuthorization with list input.</p>', ], ], 'ResaleAuthorizationStatusString' => [ 'base' => NULL, 'refs' => [ 'ResaleAuthorizationStatusFilterValueList$member' => NULL, 'ResaleAuthorizationSummary$Status' => '<p>The status of the ResaleAuthorization.</p>', ], ], 'ResaleAuthorizationSummary' => [ 'base' => '<p>Summarized information about a Resale Authorization.</p>', 'refs' => [ 'EntitySummary$ResaleAuthorizationSummary' => '<p>An object that contains summary information about the Resale Authorization.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the entity resource that is associated with the resource policy.</p>', 'GetResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the entity resource that is associated with the resource policy.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>Required. The Amazon Resource Name (ARN) associated with the resource you want to list tags on.</p>', 'ListTagsForResourceResponse$ResourceArn' => '<p>Required. The ARN associated with the resource you want to list tags on.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the entity resource you want to associate with a resource policy.</p>', 'TagResourceRequest$ResourceArn' => '<p>Required. The Amazon Resource Name (ARN) associated with the resource you want to tag.</p>', 'UntagResourceRequest$ResourceArn' => '<p>Required. The Amazon Resource Name (ARN) associated with the resource you want to remove the tag from.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CancelChangeSetRequest$ChangeSetId' => '<p>Required. The unique identifier of the <code>StartChangeSet</code> request that you want to cancel.</p>', 'CancelChangeSetResponse$ChangeSetId' => '<p>The unique identifier for the change set referenced in this request.</p>', 'ChangeSetSummaryListItem$ChangeSetId' => '<p>The unique identifier for a change set.</p>', 'DescribeChangeSetRequest$ChangeSetId' => '<p>Required. The unique identifier for the <code>StartChangeSet</code> request that you want to describe the details for.</p>', 'DescribeChangeSetResponse$ChangeSetId' => '<p>Required. The unique identifier for the change set referenced in this request.</p>', 'DescribeEntityRequest$EntityId' => '<p>Required. The unique ID of the entity to describe.</p>', 'EntitySummary$EntityId' => '<p>The unique identifier for the entity.</p>', 'ResourceIdList$member' => NULL, 'StartChangeSetResponse$ChangeSetId' => '<p>Unique identifier generated for the request.</p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummaryListItem$EntityIdList' => '<p>This object is a list of entity IDs (string) that are a part of a change set. The entity ID list is a maximum of 20 entities. It must contain at least one entity.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource is currently in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource wasn\'t found.</p> <p>HTTP status code: 404</p>', 'refs' => [], ], 'ResourceNotSupportedException' => [ 'base' => '<p>Currently, the specified resource is not supported.</p>', 'refs' => [], ], 'ResourcePolicyJson' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$Policy' => '<p>The policy document to set; formatted in JSON.</p>', 'PutResourcePolicyRequest$Policy' => '<p>The policy document to set; formatted in JSON.</p>', ], ], 'SaaSProductEntityIdFilter' => [ 'base' => '<p>Object that allows filtering on entity id of a SaaS product.</p>', 'refs' => [ 'SaaSProductFilters$EntityId' => '<p>Unique identifier for the SaaS product.</p>', ], ], 'SaaSProductEntityIdFilterValueList' => [ 'base' => NULL, 'refs' => [ 'SaaSProductEntityIdFilter$ValueList' => '<p>A string array of unique entity id values to be filtered on.</p>', ], ], 'SaaSProductEntityIdString' => [ 'base' => NULL, 'refs' => [ 'SaaSProductEntityIdFilterValueList$member' => NULL, ], ], 'SaaSProductFilters' => [ 'base' => '<p>Object containing all the filter fields for SaaS products. Client can add only one wildcard filter and a maximum of 8 filters in a single <code>ListEntities</code> request.</p>', 'refs' => [ 'EntityTypeFilters$SaaSProductFilters' => '<p>A filter for SaaS products.</p>', ], ], 'SaaSProductLastModifiedDateFilter' => [ 'base' => '<p>Object that allows filtering based on the last modified date of SaaS products</p>', 'refs' => [ 'SaaSProductFilters$LastModifiedDate' => '<p>The last date on which the SaaS product was modified.</p>', ], ], 'SaaSProductLastModifiedDateFilterDateRange' => [ 'base' => '<p>Object that contains date range of the last modified date to be filtered on. You can optionally provide a <code>BeforeValue</code> and/or <code>AfterValue</code>. Both are inclusive.</p>', 'refs' => [ 'SaaSProductLastModifiedDateFilter$DateRange' => '<p>Dates between which the SaaS product was last modified.</p>', ], ], 'SaaSProductSort' => [ 'base' => '<p>Objects that allows sorting on SaaS products based on certain fields and sorting order.</p>', 'refs' => [ 'EntityTypeSort$SaaSProductSort' => '<p>A sort for SaaS products.</p>', ], ], 'SaaSProductSortBy' => [ 'base' => NULL, 'refs' => [ 'SaaSProductSort$SortBy' => '<p>Field to sort the SaaS products by.</p>', ], ], 'SaaSProductSummary' => [ 'base' => '<p>Object that contains summarized information about a SaaS product.</p>', 'refs' => [ 'EntitySummary$SaaSProductSummary' => '<p>An object that contains summary information about the SaaS product.</p>', ], ], 'SaaSProductTitleFilter' => [ 'base' => '<p>Object that allows filtering on product title.</p>', 'refs' => [ 'SaaSProductFilters$ProductTitle' => '<p>The title of the SaaS product.</p>', ], ], 'SaaSProductTitleFilterValueList' => [ 'base' => NULL, 'refs' => [ 'SaaSProductTitleFilter$ValueList' => '<p>A string array of unique product title values to be filtered on.</p>', ], ], 'SaaSProductTitleString' => [ 'base' => NULL, 'refs' => [ 'SaaSProductSummary$ProductTitle' => '<p>The title of the SaaS product.</p>', 'SaaSProductTitleFilter$WildCardValue' => '<p>A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value as a substring in the actual value.</p>', 'SaaSProductTitleFilterValueList$member' => NULL, ], ], 'SaaSProductVisibilityFilter' => [ 'base' => '<p>Object that allows filtering on the visibility of the product in the AWS Marketplace.</p>', 'refs' => [ 'SaaSProductFilters$Visibility' => '<p>The visibility of the SaaS product.</p>', ], ], 'SaaSProductVisibilityFilterValueList' => [ 'base' => NULL, 'refs' => [ 'SaaSProductVisibilityFilter$ValueList' => '<p>A string array of unique visibility values to be filtered on.</p>', ], ], 'SaaSProductVisibilityString' => [ 'base' => NULL, 'refs' => [ 'SaaSProductSummary$Visibility' => '<p>The lifecycle of the SaaS product.</p>', 'SaaSProductVisibilityFilterValueList$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The maximum number of open requests per account has been exceeded.</p>', 'refs' => [], ], 'Sort' => [ 'base' => '<p>An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.</p>', 'refs' => [ 'ListChangeSetsRequest$Sort' => '<p>An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.</p>', 'ListEntitiesRequest$Sort' => '<p>An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.</p>', ], ], 'SortBy' => [ 'base' => NULL, 'refs' => [ 'Sort$SortBy' => '<p>For <code>ListEntities</code>, supported attributes include <code>LastModifiedDate</code> (default) and <code>EntityId</code>. In addition to <code>LastModifiedDate</code> and <code>EntityId</code>, each <code>EntityType</code> might support additional fields.</p> <p>For <code>ListChangeSets</code>, supported attributes include <code>StartTime</code> and <code>EndTime</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'AmiProductSort$SortOrder' => '<p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', 'ContainerProductSort$SortOrder' => '<p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', 'DataProductSort$SortOrder' => '<p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', 'OfferSort$SortOrder' => '<p>Allows to sort offers.</p>', 'ResaleAuthorizationSort$SortOrder' => '<p>Allows to sort ResaleAuthorization.</p>', 'SaaSProductSort$SortOrder' => '<p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', 'Sort$SortOrder' => '<p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', ], ], 'StartChangeSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChangeSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A list of objects specifying each key name and value.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key associated with the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Required. A list of key names of tags to be removed. Number of strings allowed: 0-256.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Change$EntityTags' => '<p>The tags associated with the change.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Required. A list of objects specifying each key name and value. Number of objects allowed: 1-50.</p>', 'StartChangeSetRequest$ChangeSetTags' => '<p>A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.</p>', 'TagResourceRequest$Tags' => '<p>Required. A list of objects specifying each key name and value. Number of objects allowed: 1-50.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value associated with the tag.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Too many requests.</p> <p>HTTP status code: 429</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>An error occurred during validation.</p> <p>HTTP status code: 422</p>', 'refs' => [], ], 'ValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$ValueList' => '<p> <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p> <p> <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as follows:</p> <ul> <li> <p> <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.</p> </li> <li> <p> <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set requests.</p> </li> <li> <p> <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>s.</p> </li> <li> <p> <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started before the filter value.</p> </li> <li> <p> <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started after the filter value.</p> </li> <li> <p> <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended before the filter value.</p> </li> <li> <p> <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended after the filter value.</p> </li> </ul>', ], ], 'VisibilityValue' => [ 'base' => NULL, 'refs' => [ 'EntitySummary$Visibility' => '<p>The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view the entity), <code>Limited</code> (the entity is visible to limited accounts only), or <code>Restricted</code> (the entity was published and then unpublished and only existing buyers can view it). </p>', ], ], ],];
