<?php
// This file was auto-generated from sdk-root/src/data/mwaa/2020-07-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Amazon Managed Workflows for Apache Airflow</fullname> <p>This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html">What is Amazon MWAA?</a>.</p> <p> <b>Endpoints</b> </p> <ul> <li> <p> <code>api.airflow.{region}.amazonaws.com</code> - This endpoint is used for environment management.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_CreateEnvironment.html">CreateEnvironment</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_DeleteEnvironment.html">DeleteEnvironment</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_GetEnvironment.html">GetEnvironment</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_ListEnvironments.html">ListEnvironments</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_ListTagsForResource.html">ListTagsForResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_TagResource.html">TagResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_UntagResource.html">UntagResource</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_UpdateEnvironment.html">UpdateEnvironment</a> </p> </li> </ul> </li> <li> <p> <code>env.airflow.{region}.amazonaws.com</code> - This endpoint is used to operate the Airflow environment.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_CreateCliToken.html ">CreateCliToken</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/mwaa/latest/API/API_CreateWebLoginToken.html">CreateWebLoginToken</a> </p> </li> </ul> </li> </ul> <p> <b>Regions</b> </p> <p>For a list of supported regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/mwaa.html">Amazon MWAA endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p></p>', 'operations' => [ 'CreateCliToken' => '<p>Creates a CLI token for the Airflow CLI. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-cli.html">Creating an Apache Airflow CLI token</a>.</p>', 'CreateEnvironment' => '<p>Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'CreateWebLoginToken' => '<p>Creates a web login token for the Airflow Web UI. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/call-mwaa-apis-web.html">Creating an Apache Airflow web login token</a>.</p>', 'DeleteEnvironment' => '<p>Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'GetEnvironment' => '<p>Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'ListEnvironments' => '<p>Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.</p>', 'ListTagsForResource' => '<p>Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>. </p>', 'PublishMetrics' => '<p> <b>Internal only</b>. Publishes environment health metrics to Amazon CloudWatch.</p>', 'TagResource' => '<p>Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. </p>', 'UntagResource' => '<p>Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>.</p>', 'UpdateEnvironment' => '<p>Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to the Apache Airflow Web UI or CLI has been denied due to insufficient permissions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-policies.html">Accessing an Amazon MWAA environment</a>.</p>', 'refs' => [], ], 'AirflowConfigurationOptions' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', 'Environment$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', 'UpdateEnvironmentInput$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', ], ], 'AirflowIdentity' => [ 'base' => NULL, 'refs' => [ 'CreateWebLoginTokenResponse$AirflowIdentity' => '<p>The user name of the Apache Airflow identity creating the web login token.</p>', ], ], 'AirflowVersion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$AirflowVersion' => '<p>The Apache Airflow version for your environment. If no value is specified, it defaults to the latest version. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/airflow-versions.html">Apache Airflow versions on Amazon Managed Workflows for Apache Airflow (MWAA)</a>.</p> <p>Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>, <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code> <code>2.8.1</code> </p>', 'Environment$AirflowVersion' => '<p>The Apache Airflow version on your environment.</p> <p>Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>, <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.</p>', 'UpdateEnvironmentInput$AirflowVersion' => '<p>The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of Apache Airflow supported by Amazon MWAA.</p> <p>Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used in your workflows are compatible with the new Apache Airflow version. For more information about updating your resources, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html">Upgrading an Amazon MWAA environment</a>.</p> <p>Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>, <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.</p>', ], ], 'CeleryExecutorQueue' => [ 'base' => NULL, 'refs' => [ 'Environment$CeleryExecutorQueue' => '<p>The queue ARN for the environment\'s <a href="https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery Executor</a>. Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$CloudWatchLogGroupArn' => '<p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>', ], ], 'ConfigKey' => [ 'base' => NULL, 'refs' => [ 'AirflowConfigurationOptions$key' => NULL, ], ], 'ConfigValue' => [ 'base' => NULL, 'refs' => [ 'AirflowConfigurationOptions$value' => NULL, ], ], 'CreateCliTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCliTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentInput' => [ 'base' => '<p>This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation to create an environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/get-started.html">Get started with Amazon Managed Workflows for Apache Airflow</a>.</p>', 'refs' => [], ], 'CreateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebLoginTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebLoginTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'Environment$CreatedAt' => '<p>The day and time the environment was created.</p>', ], ], 'DeleteEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p> <b>Internal only</b>. Represents the dimensions of a metric. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Dimensions' => '<p> <b>Internal only</b>. The dimensions associated with the metric.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Value' => '<p> <b>Internal only</b>. The value for the metric.</p>', 'StatisticSet$Sum' => '<p> <b>Internal only</b>. The sum of values for the sample set.</p>', 'StatisticSet$Minimum' => '<p> <b>Internal only</b>. The minimum value of the sample set.</p>', 'StatisticSet$Maximum' => '<p> <b>Internal only</b>. The maximum value of the sample set.</p>', ], ], 'EndpointManagement' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$EndpointManagement' => '<p>Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints for your VPC. If you choose to create an environment in a shared VPC, you must set this value to <code>CUSTOMER</code>. In a shared VPC deployment, the environment will remain in <code>PENDING</code> status until you create the VPC endpoints. If you do not take action to create the endpoints within 72 hours, the status will change to <code>CREATE_FAILED</code>. You can delete the failed environment and create a new one.</p>', 'Environment$EndpointManagement' => '<p>Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints in your VPC.</p>', ], ], 'Environment' => [ 'base' => '<p>Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'refs' => [ 'GetEnvironmentOutput$Environment' => '<p>An object containing all available details about the environment.</p>', ], ], 'EnvironmentArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$Arn' => '<p>The Amazon Resource Name (ARN) returned in the response for the environment.</p>', 'Environment$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>', 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'UpdateEnvironmentOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', ], ], 'EnvironmentClass' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', 'Environment$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', 'UpdateEnvironmentInput$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', ], ], 'EnvironmentList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsOutput$Environments' => '<p>Returns a list of Amazon MWAA environments.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenRequest$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'CreateEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'CreateWebLoginTokenRequest$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'DeleteEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'Environment$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'EnvironmentList$member' => NULL, 'GetEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'PublishMetricsInput$EnvironmentName' => '<p> <b>Internal only</b>. The name of the environment.</p>', 'UpdateEnvironmentInput$Name' => '<p>The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', ], ], 'EnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'Environment$Status' => '<p>The status of the Amazon MWAA environment.</p> <p>Valid values:</p> <ul> <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li> <li> <p> <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS database cluster associated with the environment. A database snapshot is a backup created at a specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process to update or upgrade an environment fails.</p> </li> <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li> <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li> <li> <p> <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the process resumes.</p> </li> <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li> <li> <p> <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the environment version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.</p> </li> <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li> <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li> <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its previous state and is not stable.</p> </li> <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment was restored to its previous state successfully and is ready to use.</p> </li> <li> <p> <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the type of work Amazon MWAA is performing, your environment might become unavailable during this process. After all operations are done, your environment will return to its status prior to mainteneace operations. </p> </li> </ul> <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'UpdateError$ErrorCode' => '<p>The error code that corresponds to the error with the last update.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'UpdateError$ErrorMessage' => '<p>The error message that corresponds to the error code.</p>', ], ], 'GetEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'Hostname' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenResponse$WebServerHostname' => '<p>The Airflow web server hostname for the environment.</p>', 'CreateWebLoginTokenResponse$WebServerHostname' => '<p>The Airflow web server hostname for the environment.</p>', ], ], 'IamIdentity' => [ 'base' => NULL, 'refs' => [ 'CreateWebLoginTokenResponse$IamIdentity' => '<p>The name of the IAM identity creating the web login token. This might be an IAM user, or an assumed or federated identity. For example, <code>assumed-role/Admin/your-name</code>.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an Amazon Web Services Identity and Access Management (IAM) role that grants MWAA permission to access Amazon Web Services services and resources used by your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', 'Environment$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', 'Environment$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>', 'UpdateEnvironmentInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'StatisticSet$SampleCount' => '<p> <b>Internal only</b>. The number of samples used for the statistic set.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>InternalServerException: An internal error has occurred.</p>', 'refs' => [], ], 'KmsKey' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$KmsKey' => '<p>The Amazon Web Services Key Management Service (KMS) key to encrypt the data in your environment. You can use an Amazon Web Services owned CMK, or a Customer managed CMK (advanced). For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/create-environment.html">Create an Amazon MWAA environment</a>.</p>', 'Environment$KmsKey' => '<p>The KMS encryption key used to encrypt the data in your environment.</p>', ], ], 'LastUpdate' => [ 'base' => '<p>Describes the status of the last update on the environment, and any errors that were encountered.</p>', 'refs' => [ 'Environment$LastUpdate' => '<p>The status of the last update on the environment.</p>', ], ], 'ListEnvironmentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsInput$MaxResults' => '<p>The maximum number of results to retrieve per page. For example, <code>5</code> environments per page.</p>', ], ], 'ListEnvironmentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LoggingConfiguration' => [ 'base' => '<p>Describes the Apache Airflow log types that are published to CloudWatch Logs.</p>', 'refs' => [ 'Environment$LoggingConfiguration' => '<p>The Apache Airflow logs published to CloudWatch Logs.</p>', ], ], 'LoggingConfigurationInput' => [ 'base' => '<p>Defines the Apache Airflow log types to send to CloudWatch Logs.</p>', 'refs' => [ 'CreateEnvironmentInput$LoggingConfiguration' => '<p>Defines the Apache Airflow logs to send to CloudWatch Logs.</p>', 'UpdateEnvironmentInput$LoggingConfiguration' => '<p>The Apache Airflow log types to send to CloudWatch Logs.</p>', ], ], 'LoggingEnabled' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$Enabled' => '<p>Indicates whether the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is enabled.</p>', 'ModuleLoggingConfigurationInput$Enabled' => '<p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>).</p>', ], ], 'LoggingLevel' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$LogLevel' => '<p>The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>). </p>', 'ModuleLoggingConfigurationInput$LogLevel' => '<p>Defines the Apache Airflow log level (e.g. <code>INFO</code>) to send to CloudWatch Logs.</p>', ], ], 'MaxWebservers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MaxWebservers' => '<p> The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', 'Environment$MaxWebservers' => '<p> The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', 'UpdateEnvironmentInput$MaxWebservers' => '<p> The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', ], ], 'MaxWorkers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MaxWorkers' => '<p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>', 'Environment$MaxWorkers' => '<p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>', 'UpdateEnvironmentInput$MaxWorkers' => '<p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>', ], ], 'MetricData' => [ 'base' => NULL, 'refs' => [ 'PublishMetricsInput$MetricData' => '<p> <b>Internal only</b>. Publishes metrics to Amazon CloudWatch. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>', ], ], 'MetricDatum' => [ 'base' => '<p> <b>Internal only</b>. Collects Apache Airflow metrics. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>', 'refs' => [ 'MetricData$member' => NULL, ], ], 'MinWebservers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MinWebservers' => '<p> The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', 'Environment$MinWebservers' => '<p> The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', 'UpdateEnvironmentInput$MinWebservers' => '<p> The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p> <p>Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.</p>', ], ], 'MinWorkers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MinWorkers' => '<p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>', 'Environment$MinWorkers' => '<p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>', 'UpdateEnvironmentInput$MinWorkers' => '<p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>', ], ], 'ModuleLoggingConfiguration' => [ 'base' => '<p>Describes the Apache Airflow log details for the log type (e.g. <code>DagProcessingLogs</code>).</p>', 'refs' => [ 'LoggingConfiguration$DagProcessingLogs' => '<p>The Airflow DAG processing logs published to CloudWatch Logs and the log level.</p>', 'LoggingConfiguration$SchedulerLogs' => '<p>The Airflow scheduler logs published to CloudWatch Logs and the log level.</p>', 'LoggingConfiguration$WebserverLogs' => '<p>The Airflow web server logs published to CloudWatch Logs and the log level.</p>', 'LoggingConfiguration$WorkerLogs' => '<p>The Airflow worker logs published to CloudWatch Logs and the log level.</p>', 'LoggingConfiguration$TaskLogs' => '<p>The Airflow task logs published to CloudWatch Logs and the log level.</p>', ], ], 'ModuleLoggingConfigurationInput' => [ 'base' => '<p>Enables the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) and defines the log level to send to CloudWatch Logs (e.g. <code>INFO</code>).</p>', 'refs' => [ 'LoggingConfigurationInput$DagProcessingLogs' => '<p>Publishes Airflow DAG processing logs to CloudWatch Logs.</p>', 'LoggingConfigurationInput$SchedulerLogs' => '<p>Publishes Airflow scheduler logs to CloudWatch Logs.</p>', 'LoggingConfigurationInput$WebserverLogs' => '<p>Publishes Airflow web server logs to CloudWatch Logs.</p>', 'LoggingConfigurationInput$WorkerLogs' => '<p>Publishes Airflow worker logs to CloudWatch Logs.</p>', 'LoggingConfigurationInput$TaskLogs' => '<p>Publishes Airflow task logs to CloudWatch Logs.</p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'refs' => [ 'CreateEnvironmentInput$NetworkConfiguration' => '<p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'Environment$NetworkConfiguration' => '<p>Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsInput$NextToken' => '<p>Retrieves the next page of the results.</p>', 'ListEnvironmentsOutput$NextToken' => '<p>Retrieves the next page of the results.</p>', ], ], 'PublishMetricsInput' => [ 'base' => NULL, 'refs' => [], ], 'PublishMetricsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RelativePath' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$DagS3Path' => '<p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'CreateEnvironmentInput$PluginsS3Path' => '<p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the <code>plugins.zip</code> version is required. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'CreateEnvironmentInput$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a version is required. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'CreateEnvironmentInput$StartupScriptS3Path' => '<p>The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code>.</p> <p> Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', 'Environment$DagS3Path' => '<p>The relative path to the DAGs folder in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/dags</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'Environment$PluginsS3Path' => '<p>The relative path to the file in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/plugins.zip</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'Environment$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/requirements.txt</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'UpdateEnvironmentInput$DagS3Path' => '<p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'UpdateEnvironmentInput$PluginsS3Path' => '<p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'UpdateEnvironmentInput$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'UpdateEnvironmentInput$StartupScriptS3Path' => '<p>The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code>.</p> <p> Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>ResourceNotFoundException: The resource is not available.</p>', 'refs' => [], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', 'Environment$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', 'UpdateEnvironmentInput$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$PluginsS3ObjectVersion' => '<p>The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a plugins.zip file is updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'CreateEnvironmentInput$RequirementsS3ObjectVersion' => '<p>The version of the <code>requirements.txt</code> file on your Amazon S3 bucket. You must specify a version each time a requirements.txt file is updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'CreateEnvironmentInput$StartupScriptS3ObjectVersion' => '<p>The version of the startup shell script in your Amazon S3 bucket. You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file every time you update the script. </p> <p> Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example: </p> <p> <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code> </p> <p> For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', 'Environment$PluginsS3ObjectVersion' => '<p>The version of the <code>plugins.zip</code> file in your Amazon S3 bucket. You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file.</p> <p> Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example: </p> <p> <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'Environment$RequirementsS3ObjectVersion' => '<p>The version of the <code>requirements.txt </code> file on your Amazon S3 bucket. You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file.</p> <p> Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example: </p> <p> <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code> </p> <p> For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>. </p>', 'UpdateEnvironmentInput$PluginsS3ObjectVersion' => '<p>The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a <code>plugins.zip</code> file is updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'UpdateEnvironmentInput$RequirementsS3ObjectVersion' => '<p>The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a <code>requirements.txt</code> file is updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'UpdateEnvironmentInput$StartupScriptS3ObjectVersion' => '<p> The version of the startup shell script in your Amazon S3 bucket. You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file every time you update the script. </p> <p> Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example: </p> <p> <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code> </p> <p> For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', ], ], 'Schedulers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$Schedulers' => '<p>The number of Apache Airflow schedulers to run in your environment. Valid values:</p> <ul> <li> <p>v2 - Accepts between <code>2</code> to <code>5</code>. Defaults to <code>2</code>.</p> </li> <li> <p>v1 - Accepts <code>1</code>.</p> </li> </ul>', 'Environment$Schedulers' => '<p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>', 'UpdateEnvironmentInput$Schedulers' => '<p>The number of Apache Airflow schedulers to run in your Amazon MWAA environment.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupList$member' => NULL, ], ], 'SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'NetworkConfiguration$SecurityGroupIds' => '<p>A list of security group IDs. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>', 'UpdateNetworkConfigurationInput$SecurityGroupIds' => '<p>A list of security group IDs. A security group must be attached to the same VPC as the subnets. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>', ], ], 'StatisticSet' => [ 'base' => '<p> <b>Internal only</b>. Represents a set of statistics that describe a specific metric. To learn more about the metrics published to Amazon CloudWatch, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html">Amazon MWAA performance metrics in Amazon CloudWatch</a>.</p>', 'refs' => [ 'MetricDatum$StatisticValues' => '<p> <b>Internal only</b>. The statistical values for the metric.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'Dimension$Name' => '<p> <b>Internal only</b>. The name of the dimension.</p>', 'Dimension$Value' => '<p> <b>Internal only</b>. The value of the dimension.</p>', 'Environment$StartupScriptS3Path' => '<p>The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code>.</p> <p> Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', 'Environment$StartupScriptS3ObjectVersion' => '<p>The version of the startup shell script in your Amazon S3 bucket. You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file.</p> <p> Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example: </p> <p> <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code> </p> <p> For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>. </p>', 'InternalServerException$message' => NULL, 'MetricDatum$MetricName' => '<p> <b>Internal only</b>. The name of the metric.</p>', 'ResourceNotFoundException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'NetworkConfiguration$SubnetIds' => '<p>A list of subnet IDs. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The key-value tag pair you want to remove. For example, <code>"Environment": "Staging"</code>. </p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$Tags' => '<p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'Environment$Tags' => '<p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The key-value tag pairs associated to your environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'TagResourceInput$Tags' => '<p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Timestamp' => '<p> <b>Internal only</b>. The time the metric data was received.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenResponse$CliToken' => '<p>An Airflow CLI login token.</p>', 'CreateWebLoginTokenResponse$WebToken' => '<p>An Airflow web server login token.</p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Unit' => '<p> <b>Internal only</b>. The unit used to store the metric.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCreatedAt' => [ 'base' => NULL, 'refs' => [ 'LastUpdate$CreatedAt' => '<p>The day and time of the last update on the environment.</p>', ], ], 'UpdateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateError' => [ 'base' => '<p>Describes the error(s) encountered with the last update of the environment.</p>', 'refs' => [ 'LastUpdate$Error' => '<p>The error that was encountered during the last update of the environment.</p>', ], ], 'UpdateNetworkConfigurationInput' => [ 'base' => '<p>Defines the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'refs' => [ 'UpdateEnvironmentInput$NetworkConfiguration' => '<p>The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', ], ], 'UpdateSource' => [ 'base' => NULL, 'refs' => [ 'LastUpdate$Source' => '<p>The source of the last update to the environment. Includes internal processes by Amazon MWAA, such as an environment maintenance update.</p>', ], ], 'UpdateStatus' => [ 'base' => NULL, 'refs' => [ 'LastUpdate$Status' => '<p>The status of the last update on the environment.</p>', ], ], 'ValidationException' => [ 'base' => '<p>ValidationException: The provided input is not valid.</p>', 'refs' => [], ], 'VpcEndpointServiceName' => [ 'base' => NULL, 'refs' => [ 'Environment$WebserverVpcEndpointService' => '<p>The VPC endpoint for the environment\'s web server.</p>', 'Environment$DatabaseVpcEndpointService' => '<p>The VPC endpoint for the environment\'s Amazon RDS database.</p>', ], ], 'WebserverAccessMode' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$WebserverAccessMode' => '<p>Defines the access mode for the Apache Airflow <i>web server</i>. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', 'Environment$WebserverAccessMode' => '<p>The Apache Airflow <i>web server</i> access mode. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', 'UpdateEnvironmentInput$WebserverAccessMode' => '<p>The Apache Airflow <i>Web server</i> access mode. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', ], ], 'WebserverUrl' => [ 'base' => NULL, 'refs' => [ 'Environment$WebserverUrl' => '<p>The Apache Airflow <i>web server</i> host name for the Amazon MWAA environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>', ], ], 'WeeklyMaintenanceWindowStart' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>', 'Environment$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>', 'UpdateEnvironmentInput$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.</p>', ], ], ],];
