<?php
// This file was auto-generated from sdk-root/src/data/network-firewall/2020-11-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the Network Firewall API actions, data types, and errors. </p> <ul> <li> <p>The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and error handling. For general information about using the Amazon Web Services REST APIs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-apis.html">Amazon Web Services APIs</a>. </p> <p>To access Network Firewall using the REST API endpoint: <code>https://network-firewall.&lt;region&gt;.amazonaws.com </code> </p> </li> <li> <p>Alternatively, you can use one of the Amazon Web Services SDKs to access an API that\'s tailored to the programming language or platform that you\'re using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon Web Services SDKs</a>.</p> </li> <li> <p>For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the Network Firewall console, see the <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/">Network Firewall Developer Guide</a>.</p> </li> </ul> <p>Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect. Network Firewall uses rules that are compatible with Suricata, a free, open source network analysis and threat detection engine. Network Firewall supports Suricata version 6.0.9. For information about Suricata, see the <a href="https://suricata.io/">Suricata website</a>.</p> <p>You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a few examples: </p> <ul> <li> <p>Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other forms of traffic.</p> </li> <li> <p>Use custom lists of known bad domains to limit the types of domain names that your applications can access.</p> </li> <li> <p>Perform deep packet inspection on traffic entering or leaving your VPC.</p> </li> <li> <p>Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.</p> </li> </ul> <p>To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For information about using Amazon VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon VPC User Guide</a>.</p> <p>To start using Network Firewall, do the following: </p> <ol> <li> <p>(Optional) If you don\'t already have a VPC that you want to protect, create it in Amazon VPC. </p> </li> <li> <p>In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use of Network Firewall. </p> </li> <li> <p>In Network Firewall, create stateless and stateful rule groups, to define the components of the network traffic filtering behavior that you want your firewall to have. </p> </li> <li> <p>In Network Firewall, create a firewall policy that uses your rule groups and specifies additional default traffic filtering behavior. </p> </li> <li> <p>In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates a firewall endpoint in each subnet that you specify, with the behavior that\'s defined in the firewall policy.</p> </li> <li> <p>In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.</p> </li> </ol>', 'operations' => [ 'AssociateFirewallPolicy' => '<p>Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>. </p> <p>A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls. </p>', 'AssociateSubnets' => '<p>Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans. </p> <p>This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall\'s protections, you must also modify the VPC\'s route tables for each subnet\'s Availability Zone, to redirect the traffic that\'s coming into and going out of the zone through the firewall endpoint. </p>', 'CreateFirewall' => '<p>Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC. </p> <p>The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource. </p> <p>After you create a firewall, you can provide additional settings, like the logging configuration. </p> <p>To update the settings for a firewall, you use the operations that apply to the settings themselves, for example <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>. </p> <p>To manage a firewall\'s tags, use the standard Amazon Web Services resource tagging operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.</p> <p>To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.</p>', 'CreateFirewallPolicy' => '<p>Creates the firewall policy for the firewall according to the specifications. </p> <p>An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls. </p>', 'CreateRuleGroup' => '<p>Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags. </p> <p>You provide your rule group specification in your request using either <code>RuleGroup</code> or <code>Rules</code>.</p>', 'CreateTLSInspectionConfiguration' => '<p>Creates an Network Firewall TLS inspection configuration. Network Firewall uses TLS inspection configurations to decrypt your firewall\'s inbound and outbound SSL/TLS traffic. After decryption, Network Firewall inspects the traffic according to your firewall policy\'s stateful rules, and then re-encrypts it before sending it to its destination. You can enable inspection of your firewall\'s inbound traffic, outbound traffic, or both. To use TLS inspection with your firewall, you must first import or provision certificates using ACM, create a TLS inspection configuration, add that configuration to a new firewall policy, and then associate that policy with your firewall.</p> <p>To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.</p> <p>To manage a TLS inspection configuration\'s tags, use the standard Amazon Web Services resource tagging operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.</p> <p>To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and <a>DescribeTLSInspectionConfiguration</a>.</p> <p> For more information about TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>. </p>', 'DeleteFirewall' => '<p>Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall\'s <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can\'t revert this operation. </p> <p>You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.</p> <p>To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>, then delete the firewall by calling <a>DeleteFirewall</a>. </p>', 'DeleteFirewallPolicy' => '<p>Deletes the specified <a>FirewallPolicy</a>. </p>', 'DeleteResourcePolicy' => '<p>Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request. </p>', 'DeleteRuleGroup' => '<p>Deletes the specified <a>RuleGroup</a>. </p>', 'DeleteTLSInspectionConfiguration' => '<p>Deletes the specified <a>TLSInspectionConfiguration</a>.</p>', 'DescribeFirewall' => '<p>Returns the data objects for the specified firewall. </p>', 'DescribeFirewallPolicy' => '<p>Returns the data objects for the specified firewall policy. </p>', 'DescribeLoggingConfiguration' => '<p>Returns the logging configuration for the specified firewall. </p>', 'DescribeResourcePolicy' => '<p>Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request. </p>', 'DescribeRuleGroup' => '<p>Returns the data objects for the specified rule group. </p>', 'DescribeRuleGroupMetadata' => '<p>High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', 'DescribeTLSInspectionConfiguration' => '<p>Returns the data objects for the specified TLS inspection configuration.</p>', 'DisassociateSubnets' => '<p>Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing. </p>', 'ListFirewallPolicies' => '<p>Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list. </p>', 'ListFirewalls' => '<p>Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.</p> <p>Depending on your setting for max results and the number of firewalls, a single call might not return the full list. </p>', 'ListRuleGroups' => '<p>Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list. </p>', 'ListTLSInspectionConfigurations' => '<p>Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for max results and the number of TLS inspection configurations, a single call might not return the full list.</p>', 'ListTagsForResource' => '<p>Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups. </p>', 'PutResourcePolicy' => '<p>Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall. </p> <p>Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform. </p> <p>When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy. </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations. </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share. </p> </li> </ul> <p>For additional information about resource sharing using RAM, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups. </p>', 'UntagResource' => '<p>Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups. </p>', 'UpdateFirewallDeleteProtection' => '<p>Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall. If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that\'s in use. </p>', 'UpdateFirewallDescription' => '<p>Modifies the description for the specified firewall. Use the description to help you identify the firewall when you\'re working with it. </p>', 'UpdateFirewallEncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your firewall resources.</p>', 'UpdateFirewallPolicy' => '<p>Updates the properties of the specified firewall policy.</p>', 'UpdateFirewallPolicyChangeProtection' => '<p>Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall. If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that\'s in use.</p>', 'UpdateLoggingConfiguration' => '<p>Sets the logging configuration for the specified firewall. </p> <p>To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved <a>LoggingConfiguration</a> object. </p> <p>You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>: </p> <ul> <li> <p>Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to <code>LogDestinationConfigs</code>.</p> </li> <li> <p>Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from <code>LogDestinationConfigs</code>.</p> </li> <li> <p>Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.</p> </li> </ul> <p>You can\'t change the <code>LogDestinationType</code> or <code>LogType</code> in a <code>LogDestinationConfig</code>. To change these settings, delete the existing <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.</p>', 'UpdateRuleGroup' => '<p>Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group. </p> <p>To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object, update the object as needed, and then provide the updated object to this call. </p>', 'UpdateSubnetChangeProtection' => '<p/>', 'UpdateTLSInspectionConfiguration' => '<p>Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection configuration, you modify all firewall policies that use the TLS inspection configuration. </p> <p>To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated object to this call. </p>', ], 'shapes' => [ 'ActionDefinition' => [ 'base' => '<p>A custom action to use in stateless rule actions settings. This is used in <a>CustomAction</a>.</p>', 'refs' => [ 'CustomAction$ActionDefinition' => '<p>The custom action associated with the action name.</p>', ], ], 'ActionName' => [ 'base' => NULL, 'refs' => [ 'CustomAction$ActionName' => '<p>The descriptive name of the custom action. You can\'t change the name of a custom action after you create it.</p>', ], ], 'Address' => [ 'base' => '<p>A single IP address specification. This is used in the <a>MatchAttributes</a> source and destination specifications.</p>', 'refs' => [ 'Addresses$member' => NULL, ], ], 'AddressDefinition' => [ 'base' => NULL, 'refs' => [ 'Address$AddressDefinition' => '<p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6. </p> <p>Examples: </p> <ul> <li> <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', ], ], 'Addresses' => [ 'base' => NULL, 'refs' => [ 'MatchAttributes$Sources' => '<p>The source IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. </p>', 'MatchAttributes$Destinations' => '<p>The destination IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. </p>', 'ServerCertificateScope$Sources' => '<p>The source IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any source address.</p>', 'ServerCertificateScope$Destinations' => '<p>The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any destination address.</p>', ], ], 'AnalysisResult' => [ 'base' => '<p>The analysis result for Network Firewall\'s stateless rule group analyzer. Every time you call <a>CreateRuleGroup</a>, <a>UpdateRuleGroup</a>, or <a>DescribeRuleGroup</a> on a stateless rule group, Network Firewall analyzes the stateless rule groups in your account and identifies the rules that might adversely effect your firewall\'s functionality. For example, if Network Firewall detects a rule that\'s routing traffic asymmetrically, which impacts the service\'s ability to properly process traffic, the service includes the rule in a list of analysis results.</p>', 'refs' => [ 'AnalysisResultList$member' => NULL, ], ], 'AnalysisResultList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupResponse$AnalysisResults' => '<p>The list of analysis results for <code>AnalyzeRuleGroup</code>. If you set <code>AnalyzeRuleGroup</code> to <code>TRUE</code> in <a>CreateRuleGroup</a>, <a>UpdateRuleGroup</a>, or <a>DescribeRuleGroup</a>, Network Firewall analyzes the rule group and identifies the rules that might adversely effect your firewall\'s functionality. For example, if Network Firewall detects a rule that\'s routing traffic asymmetrically, which impacts the service\'s ability to properly process traffic, the service includes the rule in the list of analysis results.</p>', ], ], 'AssociateFirewallPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFirewallPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Attachment' => [ 'base' => '<p>The configuration and status for a single subnet that you\'ve specified for use by the Network Firewall firewall. This is part of the <a>FirewallStatus</a>.</p>', 'refs' => [ 'SyncState$Attachment' => '<p>The attachment status of the firewall\'s association with a single VPC subnet. For each configured subnet, Network Firewall creates the attachment by instantiating the firewall endpoint in the subnet so that it\'s ready to take traffic. This is part of the <a>FirewallStatus</a>.</p>', ], ], 'AttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'Attachment$Status' => '<p>The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings. When this value is <code>READY</code>, the endpoint is available and configured properly to handle network traffic. When the endpoint isn\'t available for traffic, this value will reflect its state, for example <code>CREATING</code> or <code>DELETING</code>.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'SyncStates$key' => NULL, ], ], 'AzSubnet' => [ 'base' => NULL, 'refs' => [ 'Attachment$SubnetId' => '<p>The unique identifier of the subnet that you\'ve specified to be used for a firewall endpoint. </p>', 'AzSubnets$member' => NULL, ], ], 'AzSubnets' => [ 'base' => NULL, 'refs' => [ 'DisassociateSubnetsRequest$SubnetIds' => '<p>The unique identifiers for the subnets that you want to disassociate. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallPolicyRequest$DryRun' => '<p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p> <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn\'t actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn\'t make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p> <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>', 'CreateFirewallRequest$DeleteProtection' => '<p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>', 'CreateFirewallRequest$SubnetChangeProtection' => '<p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'CreateFirewallRequest$FirewallPolicyChangeProtection' => '<p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'CreateRuleGroupRequest$DryRun' => '<p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p> <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn\'t actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn\'t make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p> <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>', 'CreateRuleGroupRequest$AnalyzeRuleGroup' => '<p>Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis and then creates the rule group for you. To run the stateless rule group analyzer without creating the rule group, set <code>DryRun</code> to <code>TRUE</code>.</p>', 'DescribeRuleGroupRequest$AnalyzeRuleGroup' => '<p>Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis.</p>', 'Firewall$DeleteProtection' => '<p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>', 'Firewall$SubnetChangeProtection' => '<p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'Firewall$FirewallPolicyChangeProtection' => '<p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'UpdateFirewallDeleteProtectionRequest$DeleteProtection' => '<p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>', 'UpdateFirewallDeleteProtectionResponse$DeleteProtection' => '<p>A flag indicating whether it is possible to delete the firewall. A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code>.</p>', 'UpdateFirewallPolicyChangeProtectionRequest$FirewallPolicyChangeProtection' => '<p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'UpdateFirewallPolicyChangeProtectionResponse$FirewallPolicyChangeProtection' => '<p>A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'UpdateFirewallPolicyRequest$DryRun' => '<p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p> <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn\'t actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn\'t make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p> <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>', 'UpdateRuleGroupRequest$DryRun' => '<p>Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request. </p> <p>If set to <code>TRUE</code>, Network Firewall checks whether the request can run successfully, but doesn\'t actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to <code>FALSE</code>, but doesn\'t make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid. </p> <p>If set to <code>FALSE</code>, Network Firewall makes the requested changes to your resources. </p>', 'UpdateRuleGroupRequest$AnalyzeRuleGroup' => '<p>Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior such as asymmetric routing. If set to <code>TRUE</code>, Network Firewall runs the analysis and then updates the rule group for you. To run the stateless rule group analyzer without updating the rule group, set <code>DryRun</code> to <code>TRUE</code>. </p>', 'UpdateSubnetChangeProtectionRequest$SubnetChangeProtection' => '<p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', 'UpdateSubnetChangeProtectionResponse$SubnetChangeProtection' => '<p>A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code>.</p>', ], ], 'CIDRCount' => [ 'base' => NULL, 'refs' => [ 'CIDRSummary$AvailableCIDRCount' => '<p>The number of CIDR blocks available for use by the IP set references in a firewall.</p>', 'CIDRSummary$UtilizedCIDRCount' => '<p>The number of CIDR blocks used by the IP set references in a firewall.</p>', 'IPSetMetadata$ResolvedCIDRCount' => '<p>Describes the total number of CIDR blocks currently in use by the IP set references in a firewall. To determine how many CIDR blocks are available for you to use in a firewall, you can call <code>AvailableCIDRCount</code>.</p>', ], ], 'CIDRSummary' => [ 'base' => '<p>Summarizes the CIDR blocks used by the IP set references in a firewall. Network Firewall calculates the number of CIDRs by taking an aggregated count of all CIDRs used by the IP sets you are referencing.</p>', 'refs' => [ 'CapacityUsageSummary$CIDRs' => '<p>Describes the capacity usage of the CIDR blocks used by the IP set references in a firewall.</p>', ], ], 'CapacityUsageSummary' => [ 'base' => '<p>The capacity usage summary of the resources used by the <a>ReferenceSets</a> in a firewall.</p>', 'refs' => [ 'FirewallStatus$CapacityUsageSummary' => '<p>Describes the capacity usage of the resources contained in a firewall\'s reference sets. Network Firewall calclulates the capacity usage by taking an aggregated count of all of the resources used by all of the reference sets in a firewall.</p>', ], ], 'Certificates' => [ 'base' => NULL, 'refs' => [ 'TLSInspectionConfigurationResponse$Certificates' => '<p>A list of the certificates associated with the TLS inspection configuration.</p>', ], ], 'CheckCertificateRevocationStatusActions' => [ 'base' => '<p>Defines the actions to take on the SSL/TLS connection if the certificate presented by the server in the connection has a revoked or unknown status.</p>', 'refs' => [ 'ServerCertificateConfiguration$CheckCertificateRevocationStatus' => '<p>When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a <code>CertificateAuthorityArn</code> in <a>ServerCertificateConfiguration</a>.</p>', ], ], 'CollectionMember_String' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$AnalysisDetail' => '<p>Provides analysis details for the identified rule.</p>', 'RuleIdList$member' => NULL, 'RuleTargets$member' => NULL, 'StatefulActions$member' => NULL, 'StatelessActions$member' => NULL, 'SubnetMapping$SubnetId' => '<p>The unique identifier for the subnet. </p>', 'TlsCertificateData$CertificateSerial' => '<p>The serial number of the certificate.</p>', 'TlsCertificateData$Status' => '<p>The status of the certificate.</p>', ], ], 'ConfigurationSyncState' => [ 'base' => NULL, 'refs' => [ 'FirewallStatus$ConfigurationSyncStateSummary' => '<p>The configuration sync state for the firewall. This summarizes the sync states reported in the <code>Config</code> settings for all of the Availability Zones where you have configured the firewall. </p> <p>When you create a firewall or update its configuration, for example by adding a rule group to its firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This summary indicates whether the configuration changes have been applied everywhere. </p> <p>This status must be <code>IN_SYNC</code> for the firewall to be ready for use, but it doesn\'t indicate that the firewall is ready. The <code>Status</code> setting indicates firewall readiness.</p>', ], ], 'CreateFirewallPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTLSInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTLSInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomAction' => [ 'base' => '<p>An optional, non-standard action to use for stateless packet handling. You can define this in addition to the standard action that you must specify. </p> <p>You define and name the custom actions that you want to be able to use, and then you reference them by name in your actions settings. </p> <p>You can use custom actions in the following places: </p> <ul> <li> <p>In a rule group\'s <a>StatelessRulesAndCustomActions</a> specification. The custom actions are available for use by name inside the <code>StatelessRulesAndCustomActions</code> where you define them. You can use them for your stateless rule actions to specify what to do with a packet that matches the rule\'s match attributes. </p> </li> <li> <p>In a <a>FirewallPolicy</a> specification, in <code>StatelessCustomActions</code>. The custom actions are available for use inside the policy where you define them. You can use them for the policy\'s default stateless actions settings to specify what to do with packets that don\'t match any of the policy\'s stateless rules. </p> </li> </ul>', 'refs' => [ 'CustomActions$member' => NULL, ], ], 'CustomActions' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicy$StatelessCustomActions' => '<p>The custom action definitions that are available for use in the firewall policy\'s <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can use it by name in your default actions specifications.</p>', 'StatelessRulesAndCustomActions$CustomActions' => '<p>Defines an array of individual custom action definitions that are available for use by the stateless rules in this <code>StatelessRulesAndCustomActions</code> specification. You name each custom action that you define, and then you can use it by name in your <a>StatelessRule</a> <a>RuleDefinition</a> <code>Actions</code> specification.</p>', ], ], 'DeleteFirewallPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTLSInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTLSInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFirewallPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFirewallPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFirewallRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFirewallResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleGroupMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleGroupMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTLSInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTLSInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallPolicyRequest$Description' => '<p>A description of the firewall policy.</p>', 'CreateFirewallRequest$Description' => '<p>A description of the firewall.</p>', 'CreateRuleGroupRequest$Description' => '<p>A description of the rule group. </p>', 'CreateTLSInspectionConfigurationRequest$Description' => '<p>A description of the TLS inspection configuration. </p>', 'DescribeRuleGroupMetadataResponse$Description' => '<p>Returns the metadata objects for the specified rule group. </p>', 'Firewall$Description' => '<p>A description of the firewall.</p>', 'FirewallPolicyResponse$Description' => '<p>A description of the firewall policy.</p>', 'RuleGroupResponse$Description' => '<p>A description of the rule group. </p>', 'TLSInspectionConfigurationResponse$Description' => '<p>A description of the TLS inspection configuration. </p>', 'UpdateFirewallDescriptionRequest$Description' => '<p>The new description for the firewall. If you omit this setting, Network Firewall removes the description for the firewall.</p>', 'UpdateFirewallDescriptionResponse$Description' => '<p>A description of the firewall.</p>', 'UpdateFirewallPolicyRequest$Description' => '<p>A description of the firewall policy.</p>', 'UpdateRuleGroupRequest$Description' => '<p>A description of the rule group. </p>', 'UpdateTLSInspectionConfigurationRequest$Description' => '<p>A description of the TLS inspection configuration. </p>', ], ], 'Destination' => [ 'base' => NULL, 'refs' => [ 'Header$Destination' => '<p>The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify <code>ANY</code>. </p> <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6. </p> <p>Examples: </p> <ul> <li> <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', ], ], 'Dimension' => [ 'base' => '<p>The value to use in an Amazon CloudWatch custom metric dimension. This is used in the <code>PublishMetrics</code> <a>CustomAction</a>. A CloudWatch custom metric dimension is a name/value pair that\'s part of the identity of a metric. </p> <p>Network Firewall sets the dimension name to <code>CustomAction</code> and you provide the dimension value. </p> <p>For more information about CloudWatch custom metric dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions">Publishing Custom Metrics</a> in the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value to use in the custom metric dimension.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'PublishMetricAction$Dimensions' => '<p/>', ], ], 'DisassociateSubnetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSubnetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionConfiguration' => [ 'base' => '<p>A complex type that contains optional Amazon Web Services Key Management Service (KMS) encryption settings for your Network Firewall resources. Your data is encrypted by default with an Amazon Web Services owned key that Amazon Web Services owns and manages for you. You can use either the Amazon Web Services owned key, or provide your own customer managed key. To learn more about KMS encryption of your Network Firewall resources, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-encryption-at-rest.html">Encryption at rest with Amazon Web Services Key Managment Service</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'refs' => [ 'CreateFirewallPolicyRequest$EncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your firewall policy resources.</p>', 'CreateFirewallRequest$EncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your firewall resources.</p>', 'CreateRuleGroupRequest$EncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your rule group resources.</p>', 'CreateTLSInspectionConfigurationRequest$EncryptionConfiguration' => NULL, 'Firewall$EncryptionConfiguration' => '<p>A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall.</p>', 'FirewallPolicyResponse$EncryptionConfiguration' => '<p>A complex type that contains the Amazon Web Services KMS encryption configuration settings for your firewall policy.</p>', 'RuleGroupResponse$EncryptionConfiguration' => '<p>A complex type that contains the Amazon Web Services KMS encryption configuration settings for your rule group.</p>', 'TLSInspectionConfigurationResponse$EncryptionConfiguration' => '<p>A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.</p>', 'UpdateFirewallEncryptionConfigurationRequest$EncryptionConfiguration' => NULL, 'UpdateFirewallEncryptionConfigurationResponse$EncryptionConfiguration' => NULL, 'UpdateFirewallPolicyRequest$EncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your firewall policy resources.</p>', 'UpdateRuleGroupRequest$EncryptionConfiguration' => '<p>A complex type that contains settings for encryption of your rule group resources.</p>', 'UpdateTLSInspectionConfigurationRequest$EncryptionConfiguration' => '<p>A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$Type' => '<p>The type of Amazon Web Services KMS key to use for encryption of your Network Firewall resources.</p>', ], ], 'EndpointId' => [ 'base' => NULL, 'refs' => [ 'Attachment$EndpointId' => '<p>The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InsufficientCapacityException$Message' => NULL, 'InternalServerError$Message' => NULL, 'InvalidOperationException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'InvalidResourcePolicyException$Message' => NULL, 'InvalidTokenException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'LogDestinationPermissionException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceOwnerCheckException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'UnsupportedOperationException$Message' => NULL, ], ], 'Firewall' => [ 'base' => '<p>The firewall defines the configuration settings for an Network Firewall firewall. These settings include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource. </p> <p>The status of the firewall, for example whether it\'s ready to filter network traffic, is provided in the corresponding <a>FirewallStatus</a>. You can retrieve both objects by calling <a>DescribeFirewall</a>.</p>', 'refs' => [ 'CreateFirewallResponse$Firewall' => '<p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>', 'DeleteFirewallResponse$Firewall' => NULL, 'DescribeFirewallResponse$Firewall' => '<p>The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints. </p>', ], ], 'FirewallMetadata' => [ 'base' => '<p>High-level information about a firewall, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a firewall.</p>', 'refs' => [ 'Firewalls$member' => NULL, ], ], 'FirewallPolicies' => [ 'base' => NULL, 'refs' => [ 'ListFirewallPoliciesResponse$FirewallPolicies' => '<p>The metadata for the firewall policies. Depending on your setting for max results and the number of firewall policies that you have, this might not be the full list. </p>', ], ], 'FirewallPolicy' => [ 'base' => '<p>The firewall policy defines the behavior of a firewall using a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls. </p> <p>This, along with <a>FirewallPolicyResponse</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>.</p>', 'refs' => [ 'CreateFirewallPolicyRequest$FirewallPolicy' => '<p>The rule groups and policy actions to use in the firewall policy.</p>', 'DescribeFirewallPolicyResponse$FirewallPolicy' => '<p>The policy for the specified firewall policy. </p>', 'UpdateFirewallPolicyRequest$FirewallPolicy' => '<p>The updated firewall policy to use for the firewall. You can\'t add or remove a <a>TLSInspectionConfiguration</a> after you create a firewall policy. However, you can replace an existing TLS inspection configuration with another <code>TLSInspectionConfiguration</code>.</p>', ], ], 'FirewallPolicyMetadata' => [ 'base' => '<p>High-level information about a firewall policy, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a firewall policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>', 'refs' => [ 'FirewallPolicies$member' => NULL, ], ], 'FirewallPolicyResponse' => [ 'base' => '<p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>', 'refs' => [ 'CreateFirewallPolicyResponse$FirewallPolicyResponse' => '<p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>', 'DeleteFirewallPolicyResponse$FirewallPolicyResponse' => '<p>The object containing the definition of the <a>FirewallPolicyResponse</a> that you asked to delete. </p>', 'DescribeFirewallPolicyResponse$FirewallPolicyResponse' => '<p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>', 'UpdateFirewallPolicyResponse$FirewallPolicyResponse' => '<p>The high-level properties of a firewall policy. This, along with the <a>FirewallPolicy</a>, define the policy. You can retrieve all objects for a firewall policy by calling <a>DescribeFirewallPolicy</a>. </p>', ], ], 'FirewallStatus' => [ 'base' => '<p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>', 'refs' => [ 'CreateFirewallResponse$FirewallStatus' => '<p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>', 'DeleteFirewallResponse$FirewallStatus' => NULL, 'DescribeFirewallResponse$FirewallStatus' => '<p>Detailed information about the current status of a <a>Firewall</a>. You can retrieve this for a firewall by calling <a>DescribeFirewall</a> and providing the firewall name and ARN.</p>', ], ], 'FirewallStatusValue' => [ 'base' => NULL, 'refs' => [ 'FirewallStatus$Status' => '<p>The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you\'ve configured it. This setting is <code>READY</code> only when the <code>ConfigurationSyncStateSummary</code> value is <code>IN_SYNC</code> and the <code>Attachment</code> <code>Status</code> values for all of the configured subnets are <code>READY</code>. </p>', ], ], 'Firewalls' => [ 'base' => NULL, 'refs' => [ 'ListFirewallsResponse$Firewalls' => '<p>The firewall metadata objects for the VPCs that you specified. Depending on your setting for max results and the number of firewalls you have, a single call might not be the full list. </p>', ], ], 'Flags' => [ 'base' => NULL, 'refs' => [ 'TCPFlagField$Flags' => '<p>Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the <code>Masks</code> setting.</p> <p>For the flags that are specified in the masks setting, the following must be true for the packet to match: </p> <ul> <li> <p>The ones that are set in this flags setting must be set in the packet. </p> </li> <li> <p>The ones that are not set in this flags setting must also not be set in the packet. </p> </li> </ul>', 'TCPFlagField$Masks' => '<p>The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.</p>', ], ], 'GeneratedRulesType' => [ 'base' => NULL, 'refs' => [ 'RulesSourceList$GeneratedRulesType' => '<p>Whether you want to allow or deny access to the domains in your target list.</p>', ], ], 'HashMapKey' => [ 'base' => NULL, 'refs' => [ 'LogDestinationMap$key' => NULL, ], ], 'HashMapValue' => [ 'base' => NULL, 'refs' => [ 'LogDestinationMap$value' => NULL, ], ], 'Header' => [ 'base' => '<p>The basic rule criteria for Network Firewall to use to inspect packet headers in stateful traffic flow inspection. Traffic flows that match the criteria are a match for the corresponding <a>StatefulRule</a>. </p>', 'refs' => [ 'StatefulRule$Header' => '<p>The stateful inspection criteria for this rule, used to inspect traffic flows. </p>', ], ], 'IPAddressType' => [ 'base' => NULL, 'refs' => [ 'SubnetMapping$IPAddressType' => '<p>The subnet\'s IP address type. You can\'t change the IP address type after you create the subnet.</p>', ], ], 'IPSet' => [ 'base' => '<p>A list of IP addresses and address ranges, in CIDR notation. This is part of a <a>RuleVariables</a>. </p>', 'refs' => [ 'IPSets$value' => NULL, ], ], 'IPSetArn' => [ 'base' => NULL, 'refs' => [ 'IPSetMetadataMap$key' => NULL, ], ], 'IPSetMetadata' => [ 'base' => '<p>General information about the IP set.</p>', 'refs' => [ 'IPSetMetadataMap$value' => NULL, ], ], 'IPSetMetadataMap' => [ 'base' => NULL, 'refs' => [ 'CIDRSummary$IPSetReferences' => '<p>The list of the IP set references used by a firewall.</p>', ], ], 'IPSetReference' => [ 'base' => '<p>Configures one or more IP set references for a Suricata-compatible rule group. This is used in <a>CreateRuleGroup</a> or <a>UpdateRuleGroup</a>. An IP set reference is a rule variable that references resources that you create and manage in another Amazon Web Services service, such as an Amazon VPC prefix list. Network Firewall IP set references enable you to dynamically update the contents of your rules. When you create, update, or delete the resource you are referencing in your rule, Network Firewall automatically updates the rule\'s content with the changes. For more information about IP set references in Network Firewall, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references">Using IP set references</a> in the <i>Network Firewall Developer Guide</i>.</p> <p> Network Firewall currently supports <a href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Amazon VPC prefix lists</a> and <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-referencing-resource-groups">resource groups</a> in IP set references. </p>', 'refs' => [ 'IPSetReferenceMap$value' => NULL, ], ], 'IPSetReferenceMap' => [ 'base' => NULL, 'refs' => [ 'ReferenceSets$IPSetReferences' => '<p>The list of IP set references.</p>', ], ], 'IPSetReferenceName' => [ 'base' => NULL, 'refs' => [ 'IPSetReferenceMap$key' => NULL, ], ], 'IPSets' => [ 'base' => NULL, 'refs' => [ 'PolicyVariables$RuleVariables' => '<p>The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata <code>HOME_NET</code> variable. If your firewall uses an inspection VPC, you might want to override the <code>HOME_NET</code> variable with the CIDRs of your home networks. If you don\'t override <code>HOME_NET</code> with your own CIDRs, Network Firewall by default uses the CIDR of your inspection VPC.</p>', 'RuleVariables$IPSets' => '<p>A list of IP addresses and address ranges, in CIDR notation. </p>', ], ], 'IdentifiedType' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$IdentifiedType' => '<p>The types of rule configurations that Network Firewall analyzes your rule groups for. Network Firewall analyzes stateless rule groups for the following types of rule configurations:</p> <ul> <li> <p> <code>STATELESS_RULE_FORWARDING_ASYMMETRICALLY</code> </p> <p>Cause: One or more stateless rules with the action <code>pass</code> or <code>forward</code> are forwarding traffic asymmetrically. Specifically, the rule\'s set of source IP addresses or their associated port numbers, don\'t match the set of destination IP addresses or their associated port numbers.</p> <p>To mitigate: Make sure that there\'s an existing return path. For example, if the rule allows traffic from source 10.1.0.0/24 to destination 20.1.0.0/24, you should allow return traffic from source 20.1.0.0/24 to destination 10.1.0.0/24.</p> </li> <li> <p> <code>STATELESS_RULE_CONTAINS_TCP_FLAGS</code> </p> <p>Cause: At least one stateless rule with the action <code>pass</code> or<code>forward</code> contains TCP flags that are inconsistent in the forward and return directions.</p> <p>To mitigate: Prevent asymmetric routing issues caused by TCP flags by following these actions:</p> <ul> <li> <p>Remove unnecessary TCP flag inspections from the rules.</p> </li> <li> <p>If you need to inspect TCP flags, check that the rules correctly account for changes in TCP flags throughout the TCP connection cycle, for example <code>SYN</code> and <code>ACK</code> flags used in a 3-way TCP handshake.</p> </li> </ul> </li> </ul>', ], ], 'InsufficientCapacityException' => [ 'base' => '<p>Amazon Web Services doesn\'t currently have enough available capacity to fulfill your request. Try your request later. </p>', 'refs' => [], ], 'InternalServerError' => [ 'base' => '<p>Your request is valid, but Network Firewall couldn\'t perform the operation because of a system problem. Retry your request. </p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>The operation failed because it\'s not valid. For example, you might have tried to delete a rule group or firewall policy that\'s in use.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The operation failed because of a problem with your request. Examples include: </p> <ul> <li> <p>You specified an unsupported parameter name or value.</p> </li> <li> <p>You tried to update a property with a value that isn\'t among the available types.</p> </li> <li> <p>Your request references an ARN that is malformed, or corresponds to a resource that isn\'t valid in the context of the request.</p> </li> </ul>', 'refs' => [], ], 'InvalidResourcePolicyException' => [ 'base' => '<p>The policy statement failed validation.</p>', 'refs' => [], ], 'InvalidTokenException' => [ 'base' => '<p>The token you provided is stale or isn\'t valid for the operation. </p>', 'refs' => [], ], 'KeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$KeyId' => '<p>The ID of the Amazon Web Services Key Management Service (KMS) customer managed key. You can use any of the key identifiers that KMS supports, unless you\'re using a key that\'s managed by another account. If you\'re using a key managed by another account, then specify the key ARN. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key ID</a> in the <i>Amazon Web Services KMS Developer Guide</i>.</p>', ], ], 'Keyword' => [ 'base' => NULL, 'refs' => [ 'RuleOption$Keyword' => '<p>The keyword for the Suricata compatible rule option. You must include a <code>sid</code> (signature ID), and can optionally include other keywords. For information about Suricata compatible keywords, see <a href="https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a> in the Suricata documentation.</p>', ], ], 'LastUpdateTime' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleGroupMetadataResponse$LastModifiedTime' => '<p>The last time that the rule group was changed.</p>', 'FirewallPolicyResponse$LastModifiedTime' => '<p>The last time that the firewall policy was changed.</p>', 'RuleGroupResponse$LastModifiedTime' => '<p>The last time that the rule group was changed.</p>', 'TLSInspectionConfigurationResponse$LastModifiedTime' => '<p>The last time that the TLS inspection configuration was changed.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Unable to perform the operation because doing so would violate a limit setting. </p>', 'refs' => [], ], 'ListFirewallPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTLSInspectionConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTLSInspectionConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogDestinationConfig' => [ 'base' => '<p>Defines where Network Firewall sends logs for the firewall for one log type. This is used in <a>LoggingConfiguration</a>. You can send each type of log to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.</p> <p>Network Firewall generates logs for stateful rule groups. You can save alert, flow, and TLS log types. </p>', 'refs' => [ 'LogDestinationConfigs$member' => NULL, ], ], 'LogDestinationConfigs' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$LogDestinationConfigs' => '<p>Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful rule groups. </p>', ], ], 'LogDestinationMap' => [ 'base' => NULL, 'refs' => [ 'LogDestinationConfig$LogDestination' => '<p>The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type. </p> <ul> <li> <p>For an Amazon S3 bucket, provide the name of the bucket, with key <code>bucketName</code>, and optionally provide a prefix, with key <code>prefix</code>. </p> <p>The following example specifies an Amazon S3 bucket named <code>DOC-EXAMPLE-BUCKET</code> and the prefix <code>alerts</code>: </p> <p> <code>"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }</code> </p> </li> <li> <p>For a CloudWatch log group, provide the name of the CloudWatch log group, with key <code>logGroup</code>. The following example specifies a log group named <code>alert-log-group</code>: </p> <p> <code>"LogDestination": { "logGroup": "alert-log-group" }</code> </p> </li> <li> <p>For a Firehose delivery stream, provide the name of the delivery stream, with key <code>deliveryStream</code>. The following example specifies a delivery stream named <code>alert-delivery-stream</code>: </p> <p> <code>"LogDestination": { "deliveryStream": "alert-delivery-stream" }</code> </p> </li> </ul>', ], ], 'LogDestinationPermissionException' => [ 'base' => '<p>Unable to send logs to a configured logging destination. </p>', 'refs' => [], ], 'LogDestinationType' => [ 'base' => NULL, 'refs' => [ 'LogDestinationConfig$LogDestinationType' => '<p>The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogDestinationConfig$LogType' => '<p>The type of log to record. You can record the following types of logs from your Network Firewall stateful engine.</p> <ul> <li> <p> <code>ALERT</code> - Logs for traffic that matches your stateful rules and that have an action that sends an alert. A stateful rule sends alerts for the rule actions DROP, ALERT, and REJECT. For more information, see <a>StatefulRule</a>.</p> </li> <li> <p> <code>FLOW</code> - Standard network traffic flow logs. The stateful rules engine records flow logs for all network traffic that it receives. Each flow log record captures the network flow for a specific standard stateless rule group.</p> </li> <li> <p> <code>TLS</code> - Logs for events that are related to TLS inspection. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p> </li> </ul>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>Defines how Network Firewall performs logging for a <a>Firewall</a>. </p>', 'refs' => [ 'DescribeLoggingConfigurationResponse$LoggingConfiguration' => NULL, 'UpdateLoggingConfigurationRequest$LoggingConfiguration' => '<p>Defines how Network Firewall performs logging for a firewall. If you omit this setting, Network Firewall disables logging for the firewall.</p>', 'UpdateLoggingConfigurationResponse$LoggingConfiguration' => NULL, ], ], 'MatchAttributes' => [ 'base' => '<p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>', 'refs' => [ 'RuleDefinition$MatchAttributes' => '<p>Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags. </p>', ], ], 'NumberOfAssociations' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicyResponse$NumberOfAssociations' => '<p>The number of firewalls that are associated with this firewall policy.</p>', 'RuleGroupResponse$NumberOfAssociations' => '<p>The number of firewall policies that use this rule group.</p>', 'TLSInspectionConfigurationResponse$NumberOfAssociations' => '<p>The number of firewall policies that use this TLS inspection configuration.</p>', ], ], 'OverrideAction' => [ 'base' => NULL, 'refs' => [ 'StatefulRuleGroupOverride$Action' => '<p>The action that changes the rule group from <code>DROP</code> to <code>ALERT</code>. This only applies to managed rule groups.</p>', ], ], 'PaginationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFirewallPoliciesRequest$MaxResults' => '<p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListFirewallsRequest$MaxResults' => '<p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListRuleGroupsRequest$MaxResults' => '<p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListTLSInspectionConfigurationsRequest$MaxResults' => '<p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListFirewallPoliciesRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListFirewallPoliciesResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListFirewallsRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListFirewallsResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListRuleGroupsRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListRuleGroupsResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListTLSInspectionConfigurationsRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListTLSInspectionConfigurationsResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.</p>', ], ], 'PerObjectStatus' => [ 'base' => '<p>Provides configuration status for a single policy or rule group that is used for a firewall endpoint. Network Firewall provides each endpoint with the rules that are configured in the firewall policy. Each time you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the rules in the endpoint, so it can properly filter network traffic. This is part of a <a>SyncState</a> for a firewall.</p>', 'refs' => [ 'SyncStateConfig$value' => NULL, ], ], 'PerObjectSyncStatus' => [ 'base' => NULL, 'refs' => [ 'PerObjectStatus$SyncStatus' => '<p>Indicates whether this object is in sync with the version indicated in the update token.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'DescribeResourcePolicyResponse$Policy' => '<p>The IAM policy for the resource. </p>', 'PutResourcePolicyRequest$Policy' => '<p>The IAM policy statement that lists the accounts that you want to share your rule group or firewall policy with and the operations that you want the accounts to be able to perform. </p> <p>For a rule group resource, you can specify the following operations in the Actions section of the statement:</p> <ul> <li> <p>network-firewall:CreateFirewallPolicy</p> </li> <li> <p>network-firewall:UpdateFirewallPolicy</p> </li> <li> <p>network-firewall:ListRuleGroups</p> </li> </ul> <p>For a firewall policy resource, you can specify the following operations in the Actions section of the statement:</p> <ul> <li> <p>network-firewall:AssociateFirewallPolicy</p> </li> <li> <p>network-firewall:ListFirewallPolicies</p> </li> </ul> <p>In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in <code>Arn</code>.</p>', ], ], 'PolicyVariables' => [ 'base' => '<p>Contains variables that you can use to override default Suricata settings in your firewall policy.</p>', 'refs' => [ 'FirewallPolicy$PolicyVariables' => '<p>Contains variables that you can use to override default Suricata settings in your firewall policy.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'Header$SourcePort' => '<p>The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>. </p>', 'Header$DestinationPort' => '<p>The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>. </p>', ], ], 'PortRange' => [ 'base' => '<p>A single port range specification. This is used for source and destination port ranges in the stateless rule <a>MatchAttributes</a>, <code>SourcePorts</code>, and <code>DestinationPorts</code> settings. </p>', 'refs' => [ 'PortRanges$member' => NULL, ], ], 'PortRangeBound' => [ 'base' => NULL, 'refs' => [ 'PortRange$FromPort' => '<p>The lower limit of the port range. This must be less than or equal to the <code>ToPort</code> specification. </p>', 'PortRange$ToPort' => '<p>The upper limit of the port range. This must be greater than or equal to the <code>FromPort</code> specification. </p>', ], ], 'PortRanges' => [ 'base' => NULL, 'refs' => [ 'MatchAttributes$SourcePorts' => '<p>The source ports to inspect for. If not specified, this matches with any source port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p> <p>You can specify individual ports, for example <code>1994</code> and you can specify port ranges, for example <code>1990:1994</code>. </p>', 'MatchAttributes$DestinationPorts' => '<p>The destination ports to inspect for. If not specified, this matches with any destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP). </p> <p>You can specify individual ports, for example <code>1994</code> and you can specify port ranges, for example <code>1990:1994</code>. </p>', 'ServerCertificateScope$SourcePorts' => '<p>The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any source port.</p> <p>You can specify individual ports, for example <code>1994</code>, and you can specify port ranges, such as <code>1990:1994</code>.</p>', 'ServerCertificateScope$DestinationPorts' => '<p>The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any destination port.</p> <p>You can specify individual ports, for example <code>1994</code>, and you can specify port ranges, such as <code>1990:1994</code>.</p>', ], ], 'PortSet' => [ 'base' => '<p>A set of port ranges for use in the rules in a rule group. </p>', 'refs' => [ 'PortSets$value' => NULL, ], ], 'PortSets' => [ 'base' => NULL, 'refs' => [ 'RuleVariables$PortSets' => '<p>A list of port ranges. </p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'StatefulRuleGroupReference$Priority' => '<p>An integer setting that indicates the order in which to run the stateful rule groups in a single <a>FirewallPolicy</a>. This setting only applies to firewall policies that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.</p> <p>Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.</p> <p>You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there\'s a wide range in between, for example use 100, 200, and so on. </p>', 'StatelessRule$Priority' => '<p>Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group. </p> <p>Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single <code>StatelessRules</code> object.</p> <p>You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there\'s a wide range in between, for example use 100, 200, and so on. </p>', 'StatelessRuleGroupReference$Priority' => '<p>An integer setting that indicates the order in which to run the stateless rule groups in a single <a>FirewallPolicy</a>. Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.</p>', ], ], 'ProtocolNumber' => [ 'base' => NULL, 'refs' => [ 'ProtocolNumbers$member' => NULL, ], ], 'ProtocolNumbers' => [ 'base' => NULL, 'refs' => [ 'MatchAttributes$Protocols' => '<p>The protocols to inspect for, specified using each protocol\'s assigned internet protocol number (IANA). If not specified, this matches with any protocol. </p>', 'ServerCertificateScope$Protocols' => '<p>The protocols to decrypt for inspection, specified using each protocol\'s assigned internet protocol number (IANA). Network Firewall currently supports only TCP.</p>', ], ], 'PublishMetricAction' => [ 'base' => '<p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.</p>', 'refs' => [ 'ActionDefinition$PublishMetricAction' => '<p>Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.</p> <p>You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it. </p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReferenceSets' => [ 'base' => '<p>Contains a set of IP set references.</p>', 'refs' => [ 'RuleGroup$ReferenceSets' => '<p>The list of a rule group\'s reference sets.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallPolicyRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'AssociateFirewallPolicyRequest$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p>', 'AssociateFirewallPolicyResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'AssociateFirewallPolicyResponse$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p>', 'AssociateSubnetsRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'AssociateSubnetsResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'CreateFirewallRequest$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the <a>FirewallPolicy</a> that you want to use for the firewall.</p>', 'DeleteFirewallPolicyRequest$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteFirewallRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. </p>', 'DeleteRuleGroupRequest$RuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the rule group.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteTLSInspectionConfigurationRequest$TLSInspectionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeFirewallPolicyRequest$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeFirewallRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeLoggingConfigurationRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeLoggingConfigurationResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'DescribeResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. </p>', 'DescribeRuleGroupMetadataRequest$RuleGroupArn' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeRuleGroupMetadataResponse$RuleGroupArn' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeRuleGroupRequest$RuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the rule group.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeTLSInspectionConfigurationRequest$TLSInspectionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DisassociateSubnetsRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DisassociateSubnetsResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'Firewall$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'Firewall$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p> <p>The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls. </p>', 'FirewallMetadata$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'FirewallPolicy$TLSInspectionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>', 'FirewallPolicyMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p>', 'FirewallPolicyResponse$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p> <note> <p>If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN is a placeholder that isn\'t attached to a valid resource.</p> </note>', 'IPSetReference$ReferenceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.</p>', 'RuleGroupMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the rule group.</p>', 'RuleGroupResponse$RuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the rule group.</p> <note> <p>If this response is for a create request that had <code>DryRun</code> set to <code>TRUE</code>, then this ARN is a placeholder that isn\'t attached to a valid resource.</p> </note>', 'RuleGroupResponse$SnsTopic' => '<p>The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that\'s used to record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer Guide.</a>.</p>', 'ServerCertificate$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Certificate Manager SSL/TLS server certificate that\'s used for inbound SSL/TLS inspection.</p>', 'ServerCertificateConfiguration$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection.</p> <p>The following limitations apply:</p> <ul> <li> <p>You can use CA certificates that you imported into ACM, but you can\'t generate CA certificates with ACM.</p> </li> <li> <p>You can\'t use certificates issued by Private Certificate Authority.</p> </li> </ul> <p>For more information about configuring certificates for outbound inspection, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html">Using SSL/TLS certificates with certificates with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>. </p> <p>For information about working with certificates in ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates</a> in the <i>Certificate Manager User Guide</i>.</p>', 'SourceMetadata$SourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.</p>', 'StatefulRuleGroupReference$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the stateful rule group.</p>', 'StatelessRuleGroupReference$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the stateless rule group.</p>', 'TLSInspectionConfigurationMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>', 'TLSInspectionConfigurationResponse$TLSInspectionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TlsCertificateData$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateFirewallDeleteProtectionRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallDeleteProtectionResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateFirewallDescriptionRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallDescriptionResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateFirewallEncryptionConfigurationRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateFirewallEncryptionConfigurationResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateFirewallPolicyChangeProtectionRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallPolicyChangeProtectionResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateFirewallPolicyRequest$FirewallPolicyArn' => '<p>The Amazon Resource Name (ARN) of the firewall policy.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateLoggingConfigurationRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateLoggingConfigurationResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateRuleGroupRequest$RuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the rule group.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateSubnetChangeProtectionRequest$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateSubnetChangeProtectionResponse$FirewallArn' => '<p>The Amazon Resource Name (ARN) of the firewall.</p>', 'UpdateTLSInspectionConfigurationRequest$TLSInspectionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the TLS inspection configuration.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'Firewall$FirewallId' => '<p>The unique identifier for the firewall. </p>', 'FirewallPolicyResponse$FirewallPolicyId' => '<p>The unique identifier for the firewall policy. </p>', 'RuleGroupResponse$RuleGroupId' => '<p>The unique identifier for the rule group. </p>', 'TLSInspectionConfigurationResponse$TLSInspectionConfigurationId' => '<p>A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and list commands. You provide it to operations such as update and delete.</p>', ], ], 'ResourceManagedStatus' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsRequest$Scope' => '<p>The scope of the request. The default setting of <code>ACCOUNT</code> or a setting of <code>NULL</code> returns all of the rule groups in your account. A setting of <code>MANAGED</code> returns all available managed rule groups.</p>', ], ], 'ResourceManagedType' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsRequest$ManagedType' => '<p>Indicates the general category of the Amazon Web Services managed rule group.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallPolicyRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'AssociateFirewallPolicyResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'AssociateSubnetsRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'AssociateSubnetsResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'CreateFirewallPolicyRequest$FirewallPolicyName' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p>', 'CreateFirewallRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'CreateRuleGroupRequest$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p>', 'CreateTLSInspectionConfigurationRequest$TLSInspectionConfigurationName' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p>', 'DeleteFirewallPolicyRequest$FirewallPolicyName' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteFirewallRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteRuleGroupRequest$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DeleteTLSInspectionConfigurationRequest$TLSInspectionConfigurationName' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeFirewallPolicyRequest$FirewallPolicyName' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeFirewallRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeLoggingConfigurationRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeRuleGroupMetadataRequest$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeRuleGroupMetadataResponse$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeRuleGroupRequest$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DescribeTLSInspectionConfigurationRequest$TLSInspectionConfigurationName' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DisassociateSubnetsRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'DisassociateSubnetsResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'Firewall$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'FirewallMetadata$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'FirewallPolicyMetadata$Name' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p>', 'FirewallPolicyResponse$FirewallPolicyName' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p>', 'RuleGroupMetadata$Name' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p>', 'RuleGroupResponse$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p>', 'SyncStateConfig$key' => NULL, 'TLSInspectionConfigurationMetadata$Name' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p>', 'TLSInspectionConfigurationResponse$TLSInspectionConfigurationName' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p>', 'UpdateFirewallDeleteProtectionRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallDeleteProtectionResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateFirewallDescriptionRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallDescriptionResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateFirewallEncryptionConfigurationRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateFirewallEncryptionConfigurationResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateFirewallPolicyChangeProtectionRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateFirewallPolicyChangeProtectionResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateFirewallPolicyRequest$FirewallPolicyName' => '<p>The descriptive name of the firewall policy. You can\'t change the name of a firewall policy after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateLoggingConfigurationRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateLoggingConfigurationResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateRuleGroupRequest$RuleGroupName' => '<p>The descriptive name of the rule group. You can\'t change the name of a rule group after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateSubnetChangeProtectionRequest$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p> <p>You must specify the ARN or the name, and you can specify both. </p>', 'UpdateSubnetChangeProtectionResponse$FirewallName' => '<p>The descriptive name of the firewall. You can\'t change the name of a firewall after you create it.</p>', 'UpdateTLSInspectionConfigurationRequest$TLSInspectionConfigurationName' => '<p>The descriptive name of the TLS inspection configuration. You can\'t change the name of a TLS inspection configuration after you create it.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Unable to locate a resource using the parameters that you provided.</p>', 'refs' => [], ], 'ResourceOwnerCheckException' => [ 'base' => '<p>Unable to change the resource because your account doesn\'t own it. </p>', 'refs' => [], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicyResponse$FirewallPolicyStatus' => '<p>The current status of the firewall policy. You can retrieve this for a firewall policy by calling <a>DescribeFirewallPolicy</a> and providing the firewall policy\'s name or ARN.</p>', 'RuleGroupResponse$RuleGroupStatus' => '<p>Detailed information about the current status of a rule group. </p>', 'TLSInspectionConfigurationResponse$TLSInspectionConfigurationStatus' => '<p>Detailed information about the current status of a <a>TLSInspectionConfiguration</a>. You can retrieve this for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a> and providing the TLS inspection configuration name and ARN.</p>', ], ], 'RevocationCheckAction' => [ 'base' => NULL, 'refs' => [ 'CheckCertificateRevocationStatusActions$RevokedStatusAction' => '<p>Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has a revoked status.</p> <ul> <li> <p> <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</p> </li> <li> <p> <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.</p> </li> <li> <p> <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</p> </li> </ul>', 'CheckCertificateRevocationStatusActions$UnknownStatusAction' => '<p>Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.</p> <ul> <li> <p> <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.</p> </li> <li> <p> <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.</p> </li> <li> <p> <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.</p> </li> </ul>', ], ], 'RuleCapacity' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$Capacity' => '<p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p> <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p> <note> <p>You can\'t change or exceed this capacity when you update the rule group, so leave room for your rule group to grow. </p> </note> <p> <b>Capacity for a stateless rule group</b> </p> <p>For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group. </p> <p>To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule\'s match settings:</p> <ul> <li> <p>A match setting with no criteria specified has a value of 1. </p> </li> <li> <p>A match setting with <code>Any</code> specified has a value of 1. </p> </li> <li> <p>All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3. </p> </li> </ul> <p>A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification for each of the other match settings has a capacity requirement of 6. </p> <p> <b>Capacity for a stateful rule group</b> </p> <p>For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group. </p>', 'DescribeRuleGroupMetadataResponse$Capacity' => '<p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p> <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>', 'FirewallPolicyResponse$ConsumedStatelessRuleCapacity' => '<p>The number of capacity units currently consumed by the policy\'s stateless rules.</p>', 'FirewallPolicyResponse$ConsumedStatefulRuleCapacity' => '<p>The number of capacity units currently consumed by the policy\'s stateful rules.</p>', 'RuleGroupResponse$Capacity' => '<p>The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group. </p> <p>You can retrieve the capacity that would be required for a rule group before you create the rule group by calling <a>CreateRuleGroup</a> with <code>DryRun</code> set to <code>TRUE</code>. </p>', 'RuleGroupResponse$ConsumedCapacity' => '<p>The number of capacity units currently consumed by the rule group rules. </p>', ], ], 'RuleDefinition' => [ 'base' => '<p>The inspection criteria and action for a single stateless rule. Network Firewall inspects each packet for the specified matching criteria. When a packet matches the criteria, Network Firewall performs the rule\'s actions on the packet.</p>', 'refs' => [ 'StatelessRule$RuleDefinition' => '<p>Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria. </p>', ], ], 'RuleGroup' => [ 'base' => '<p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p> <p>Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic flow. </p> <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>', 'refs' => [ 'CreateRuleGroupRequest$RuleGroup' => '<p>An object that defines the rule group rules. </p> <note> <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p> </note>', 'DescribeRuleGroupResponse$RuleGroup' => '<p>The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p> <p>Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic flow. </p> <p>To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in more than one firewall. </p>', 'UpdateRuleGroupRequest$RuleGroup' => '<p>An object that defines the rule group rules. </p> <note> <p>You must provide either this rule group setting or a <code>Rules</code> setting, but not both. </p> </note>', ], ], 'RuleGroupMetadata' => [ 'base' => '<p>High-level information about a rule group, returned by <a>ListRuleGroups</a>. You can use the information provided in the metadata to retrieve and manage a rule group.</p>', 'refs' => [ 'RuleGroups$member' => NULL, ], ], 'RuleGroupResponse' => [ 'base' => '<p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', 'refs' => [ 'CreateRuleGroupResponse$RuleGroupResponse' => '<p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', 'DeleteRuleGroupResponse$RuleGroupResponse' => '<p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', 'DescribeRuleGroupResponse$RuleGroupResponse' => '<p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', 'UpdateRuleGroupResponse$RuleGroupResponse' => '<p>The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>', ], ], 'RuleGroupType' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p>', 'DeleteRuleGroupRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note> <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p> </note>', 'DescribeRuleGroupMetadataRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note> <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p> </note>', 'DescribeRuleGroupMetadataResponse$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note> <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p> </note>', 'DescribeRuleGroupRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note> <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p> </note>', 'ListRuleGroupsRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.</p>', 'RuleGroupResponse$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p>', 'UpdateRuleGroupRequest$Type' => '<p>Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. </p> <note> <p>This setting is required for requests that do not include the <code>RuleGroupARN</code>.</p> </note>', ], ], 'RuleGroups' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsResponse$RuleGroups' => '<p>The rule group metadata objects that you\'ve defined. Depending on your setting for max results and the number of rule groups, this might not be the full list. </p>', ], ], 'RuleIdList' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$IdentifiedRuleIds' => '<p>The priority number of the stateless rules identified in the analysis.</p>', ], ], 'RuleOption' => [ 'base' => '<p>Additional settings for a stateful rule. This is part of the <a>StatefulRule</a> configuration.</p>', 'refs' => [ 'RuleOptions$member' => NULL, ], ], 'RuleOptions' => [ 'base' => NULL, 'refs' => [ 'StatefulRule$RuleOptions' => '<p>Additional options for the rule. These are the Suricata <code>RuleOptions</code> settings.</p>', ], ], 'RuleOrder' => [ 'base' => NULL, 'refs' => [ 'StatefulEngineOptions$RuleOrder' => '<p>Indicates how to manage the order of stateful rule evaluation for the policy. <code>STRICT_ORDER</code> is the default and recommended option. With <code>STRICT_ORDER</code>, provide your rules in the order that you want them to be evaluated. You can then choose one or more default actions for packets that don\'t match any rules. Choose <code>STRICT_ORDER</code> to have the stateful rules engine determine the evaluation order of your rules. The default action for this rule order is <code>PASS</code>, followed by <code>DROP</code>, <code>REJECT</code>, and <code>ALERT</code> actions. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on your settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>. </p>', 'StatefulRuleOptions$RuleOrder' => '<p>Indicates how to manage the order of the rule evaluation for the rule group. <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>. </p>', ], ], 'RuleTargets' => [ 'base' => NULL, 'refs' => [ 'RulesSourceList$Targets' => '<p>The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:</p> <ul> <li> <p>Explicit names. For example, <code>abc.example.com</code> matches only the domain <code>abc.example.com</code>.</p> </li> <li> <p>Names that use a domain wildcard, which you indicate with an initial \'<code>.</code>\'. For example,<code>.example.com</code> matches <code>example.com</code> and matches all subdomains of <code>example.com</code>, such as <code>abc.example.com</code> and <code>www.example.com</code>. </p> </li> </ul>', ], ], 'RuleVariableName' => [ 'base' => NULL, 'refs' => [ 'IPSets$key' => NULL, 'PortSets$key' => NULL, ], ], 'RuleVariables' => [ 'base' => '<p>Settings that are available for use in the rules in the <a>RuleGroup</a> where this is defined. </p>', 'refs' => [ 'RuleGroup$RuleVariables' => '<p>Settings that are available for use in the rules in the rule group. You can only use these for stateful rule groups. </p>', ], ], 'RulesSource' => [ 'base' => '<p>The stateless or stateful rules definitions for use in a single rule group. Each rule group requires a single <code>RulesSource</code>. You can use an instance of this for either stateless rules or stateful rules. </p>', 'refs' => [ 'RuleGroup$RulesSource' => '<p>The stateful rules or stateless rules for the rule group. </p>', ], ], 'RulesSourceList' => [ 'base' => '<p>Stateful inspection criteria for a domain list rule group. </p> <p>For HTTPS traffic, domain filtering is SNI-based. It uses the server name indicator extension of the TLS handshake.</p> <p>By default, Network Firewall domain list inspection only includes traffic coming from the VPC where you deploy the firewall. To inspect traffic from IP addresses outside of the deployment VPC, you set the <code>HOME_NET</code> rule variable to include the CIDR range of the deployment VPC plus the other CIDR ranges. For more information, see <a>RuleVariables</a> in this guide and <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html">Stateful domain list rule groups in Network Firewall</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'refs' => [ 'RulesSource$RulesSourceList' => '<p>Stateful inspection criteria for a domain list rule group. </p>', ], ], 'RulesString' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$Rules' => '<p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note> <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p> </note> <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>', 'RulesSource$RulesString' => '<p>Stateful inspection criteria, provided in Suricata compatible rules. Suricata is an open-source threat detection framework that includes a standard rule-based language for network traffic inspection.</p> <p>These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this type of rule group doesn\'t have a separate action setting.</p> <note> <p>You can\'t use the <code>priority</code> keyword if the <code>RuleOrder</code> option in <a>StatefulRuleOptions</a> is set to <code>STRICT_ORDER</code>.</p> </note>', 'UpdateRuleGroupRequest$Rules' => '<p>A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups. </p> <note> <p>You must provide either this rules setting or a populated <code>RuleGroup</code> setting, but not both. </p> </note> <p>You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a <a>RuleGroup</a> object that Network Firewall has populated from your string. </p>', ], ], 'ServerCertificate' => [ 'base' => '<p>Any Certificate Manager (ACM) Secure Sockets Layer/Transport Layer Security (SSL/TLS) server certificate that\'s associated with a <a>ServerCertificateConfiguration</a>. Used in a <a>TLSInspectionConfiguration</a> for inspection of inbound traffic to your firewall. You must request or import a SSL/TLS certificate into ACM for each domain Network Firewall needs to decrypt and inspect. Network Firewall uses the SSL/TLS certificates to decrypt specified inbound SSL/TLS traffic going to your firewall. For information about working with certificates in Certificate Manager, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate </a> or <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates</a> in the <i>Certificate Manager User Guide</i>.</p>', 'refs' => [ 'ServerCertificates$member' => NULL, ], ], 'ServerCertificateConfiguration' => [ 'base' => '<p>Configures the Certificate Manager certificates and scope that Network Firewall uses to decrypt and re-encrypt traffic using a <a>TLSInspectionConfiguration</a>. You can configure <code>ServerCertificates</code> for inbound SSL/TLS inspection, a <code>CertificateAuthorityArn</code> for outbound SSL/TLS inspection, or both. For information about working with certificates for TLS inspection, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html"> Using SSL/TLS server certficiates with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p> <note> <p>If a server certificate that\'s associated with your <a>TLSInspectionConfiguration</a> is revoked, deleted, or expired it can result in client-side TLS errors.</p> </note>', 'refs' => [ 'ServerCertificateConfigurations$member' => NULL, ], ], 'ServerCertificateConfigurations' => [ 'base' => NULL, 'refs' => [ 'TLSInspectionConfiguration$ServerCertificateConfigurations' => '<p>Lists the server certificate configurations that are associated with the TLS configuration.</p>', ], ], 'ServerCertificateScope' => [ 'base' => '<p>Settings that define the Secure Sockets Layer/Transport Layer Security (SSL/TLS) traffic that Network Firewall should decrypt for inspection by the stateful rule engine.</p>', 'refs' => [ 'ServerCertificateScopes$member' => NULL, ], ], 'ServerCertificateScopes' => [ 'base' => NULL, 'refs' => [ 'ServerCertificateConfiguration$Scopes' => '<p>A list of scopes.</p>', ], ], 'ServerCertificates' => [ 'base' => NULL, 'refs' => [ 'ServerCertificateConfiguration$ServerCertificates' => '<p>The list of server certificates to use for inbound SSL/TLS inspection.</p>', ], ], 'Setting' => [ 'base' => NULL, 'refs' => [ 'Settings$member' => NULL, ], ], 'Settings' => [ 'base' => NULL, 'refs' => [ 'RuleOption$Settings' => '<p>The settings of the Suricata compatible rule option. Rule options have zero or more setting values, and the number of possible and required settings depends on the <code>Keyword</code>. For more information about the settings for specific options, see <a href="https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options">Rule options</a>.</p>', ], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'Header$Source' => '<p>The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify <code>ANY</code>. </p> <p>Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6. </p> <p>Examples: </p> <ul> <li> <p>To configure Network Firewall to inspect for the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', ], ], 'SourceMetadata' => [ 'base' => '<p>High-level information about the managed rule group that your own rule group is copied from. You can use the the metadata to track version updates made to the originating rule group. You can retrieve all objects for a rule group by calling <a href="https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html">DescribeRuleGroup</a>.</p>', 'refs' => [ 'CreateRuleGroupRequest$SourceMetadata' => '<p>A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.</p>', 'RuleGroupResponse$SourceMetadata' => '<p>A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to track the version updates made to the originating rule group.</p>', 'UpdateRuleGroupRequest$SourceMetadata' => '<p>A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.</p>', ], ], 'StatefulAction' => [ 'base' => NULL, 'refs' => [ 'StatefulRule$Action' => '<p>Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow. </p> <p>The actions for a stateful rule are defined as follows: </p> <ul> <li> <p> <b>PASS</b> - Permits the packets to go to the intended destination.</p> </li> <li> <p> <b>DROP</b> - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the <a>Firewall</a> <a>LoggingConfiguration</a>. </p> </li> <li> <p> <b>ALERT</b> - Sends an alert log message, if alert logging is configured in the <a>Firewall</a> <a>LoggingConfiguration</a>. </p> <p>You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with <code>ALERT</code> action, verify in the logs that the rule is filtering as you want, then change the action to <code>DROP</code>.</p> </li> <li> <p> <b>REJECT</b> - Drops traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and an RST bit contained in the TCP header flags. REJECT is available only for TCP traffic. This option doesn\'t support FTP or IMAP protocols.</p> </li> </ul>', ], ], 'StatefulActions' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicy$StatefulDefaultActions' => '<p>The default actions to take on a packet that doesn\'t match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.</p> <p>Valid values of the stateful default action:</p> <ul> <li> <p>aws:drop_strict</p> </li> <li> <p>aws:drop_established</p> </li> <li> <p>aws:alert_strict</p> </li> <li> <p>aws:alert_established</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html">Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>. </p>', ], ], 'StatefulEngineOptions' => [ 'base' => '<p>Configuration settings for the handling of the stateful rule groups in a firewall policy. </p>', 'refs' => [ 'FirewallPolicy$StatefulEngineOptions' => '<p>Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.</p>', ], ], 'StatefulRule' => [ 'base' => '<p>A single Suricata rules specification, for use in a stateful rule group. Use this option to specify a simple Suricata rule with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html">Rules Format</a>. </p>', 'refs' => [ 'StatefulRules$member' => NULL, ], ], 'StatefulRuleDirection' => [ 'base' => NULL, 'refs' => [ 'Header$Direction' => '<p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination. </p>', ], ], 'StatefulRuleGroupOverride' => [ 'base' => '<p>The setting that allows the policy owner to change the behavior of the rule group within a policy. </p>', 'refs' => [ 'StatefulRuleGroupReference$Override' => '<p>The action that allows the policy owner to override the behavior of the rule group within a policy.</p>', ], ], 'StatefulRuleGroupReference' => [ 'base' => '<p>Identifier for a single stateful rule group, used in a firewall policy to refer to a rule group. </p>', 'refs' => [ 'StatefulRuleGroupReferences$member' => NULL, ], ], 'StatefulRuleGroupReferences' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicy$StatefulRuleGroupReferences' => '<p>References to the stateful rule groups that are used in the policy. These define the inspection criteria in stateful rules. </p>', ], ], 'StatefulRuleOptions' => [ 'base' => '<p>Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule groups.</p>', 'refs' => [ 'DescribeRuleGroupMetadataResponse$StatefulRuleOptions' => NULL, 'RuleGroup$StatefulRuleOptions' => '<p>Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html">Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.</p>', ], ], 'StatefulRuleProtocol' => [ 'base' => NULL, 'refs' => [ 'Header$Protocol' => '<p>The protocol to inspect for. To specify all, you can use <code>IP</code>, because all traffic on Amazon Web Services and on the internet is IP.</p>', ], ], 'StatefulRules' => [ 'base' => NULL, 'refs' => [ 'RulesSource$StatefulRules' => '<p>An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata <code>Rules</code> format, see <a href="https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html">Rules Format</a>. </p>', ], ], 'StatelessActions' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicy$StatelessDefaultActions' => '<p>The actions to take on a packet if it doesn\'t match any of the stateless rules in the policy. If you want non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>. </p> <p>You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your standard section choice.</p> <p>For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action descriptions under <a>CustomAction</a>.</p>', 'FirewallPolicy$StatelessFragmentDefaultActions' => '<p>The actions to take on a fragmented UDP packet if it doesn\'t match any of the stateless rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>. </p> <p>You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your standard section choice.</p> <p>For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action descriptions under <a>CustomAction</a>.</p>', 'RuleDefinition$Actions' => '<p>The actions to take on a packet that matches one of the stateless rule definition\'s match attributes. You must specify a standard action and you can add custom actions. </p> <note> <p>Network Firewall only forwards a packet for stateful rule inspection if you specify <code>aws:forward_to_sfe</code> for a rule that the packet matches, or if the packet doesn\'t match any stateless rule and you specify <code>aws:forward_to_sfe</code> for the <code>StatelessDefaultActions</code> setting for the <a>FirewallPolicy</a>.</p> </note> <p>For every rule, you must specify exactly one of the following standard actions. </p> <ul> <li> <p> <b>aws:pass</b> - Discontinues all inspection of the packet and permits it to go to its intended destination.</p> </li> <li> <p> <b>aws:drop</b> - Discontinues all inspection of the packet and blocks it from going to its intended destination.</p> </li> <li> <p> <b>aws:forward_to_sfe</b> - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection. </p> </li> </ul> <p>Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you\'ve assigned to the action in this <code>Actions</code> setting. For information about the options, see <a>CustomAction</a>. </p> <p>To provide more than one action in this setting, separate the settings with a comma. For example, if you have a custom <code>PublishMetrics</code> action that you\'ve named <code>MyMetricsAction</code>, then you could specify the standard action <code>aws:pass</code> and the custom action with <code>[“aws:pass”, “MyMetricsAction”]</code>. </p>', ], ], 'StatelessRule' => [ 'base' => '<p>A single stateless rule. This is used in <a>StatelessRulesAndCustomActions</a>.</p>', 'refs' => [ 'StatelessRules$member' => NULL, ], ], 'StatelessRuleGroupReference' => [ 'base' => '<p>Identifier for a single stateless rule group, used in a firewall policy to refer to the rule group. </p>', 'refs' => [ 'StatelessRuleGroupReferences$member' => NULL, ], ], 'StatelessRuleGroupReferences' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicy$StatelessRuleGroupReferences' => '<p>References to the stateless rule groups that are used in the policy. These define the matching criteria in stateless rules. </p>', ], ], 'StatelessRules' => [ 'base' => NULL, 'refs' => [ 'StatelessRulesAndCustomActions$StatelessRules' => '<p>Defines the set of stateless rules for use in a stateless rule group. </p>', ], ], 'StatelessRulesAndCustomActions' => [ 'base' => '<p>Stateless inspection criteria. Each stateless rule group uses exactly one of these data types to define its stateless rules. </p>', 'refs' => [ 'RulesSource$StatelessRulesAndCustomActions' => '<p>Stateless inspection criteria to be used in a stateless rule group. </p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'Attachment$StatusMessage' => '<p>If Network Firewall fails to create or delete the firewall endpoint in the subnet, it populates this with the reason for the error or failure and how to resolve it. A <code>FAILED</code> status indicates a non-recoverable state, and a <code>ERROR</code> status indicates an issue that you can fix. Depending on the error, it can take as many as 15 minutes to populate this field. For more information about the causes for failiure or errors and solutions available for this field, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html">Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.</p>', ], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'TlsCertificateData$StatusMessage' => '<p>Contains details about the certificate status, including information about certificate errors.</p>', ], ], 'StreamExceptionPolicy' => [ 'base' => NULL, 'refs' => [ 'StatefulEngineOptions$StreamExceptionPolicy' => '<p>Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections can break due to disruptions in external networks or within the firewall itself.</p> <ul> <li> <p> <code>DROP</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is the default behavior.</p> </li> <li> <p> <code>CONTINUE</code> - Network Firewall continues to apply rules to the subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you have a stateful rule to <code>drop http</code> traffic, Network Firewall won\'t match the traffic for this rule because the service won\'t have the context from session initialization defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a <code>flow:stateless</code> rule would still match, as would the <code>aws:drop_strict</code> default action.</p> </li> <li> <p> <code>REJECT</code> - Network Firewall fails closed and drops all subsequent traffic going to the firewall. Network Firewall also sends a TCP reject packet back to your client so that the client can immediately establish a new session. Network Firewall will have context about the new session and will apply rules to the subsequent traffic.</p> </li> </ul>', ], ], 'SubnetMapping' => [ 'base' => '<p>The ID for a subnet that you want to associate with the firewall. This is used with <a>CreateFirewall</a> and <a>AssociateSubnets</a>. Network Firewall creates an instance of the associated firewall in each subnet that you specify, to filter traffic in the subnet\'s Availability Zone.</p>', 'refs' => [ 'SubnetMappings$member' => NULL, ], ], 'SubnetMappings' => [ 'base' => NULL, 'refs' => [ 'AssociateSubnetsRequest$SubnetMappings' => '<p>The IDs of the subnets that you want to associate with the firewall. </p>', 'AssociateSubnetsResponse$SubnetMappings' => '<p>The IDs of the subnets that are associated with the firewall. </p>', 'CreateFirewallRequest$SubnetMappings' => '<p>The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet. </p>', 'DisassociateSubnetsResponse$SubnetMappings' => '<p>The IDs of the subnets that are associated with the firewall. </p>', 'Firewall$SubnetMappings' => '<p>The public subnets that Network Firewall is using for the firewall. Each subnet must belong to a different Availability Zone. </p>', ], ], 'SyncState' => [ 'base' => '<p>The status of the firewall endpoint and firewall policy configuration for a single VPC subnet. </p> <p>For each VPC subnet that you associate with a firewall, Network Firewall does the following: </p> <ul> <li> <p>Instantiates a firewall endpoint in the subnet, ready to take traffic.</p> </li> <li> <p>Configures the endpoint with the current firewall policy settings, to provide the filtering behavior for the endpoint.</p> </li> </ul> <p>When you update a firewall, for example to add a subnet association or change a rule group in the firewall policy, the affected sync states reflect out-of-sync or not ready status until the changes are complete. </p>', 'refs' => [ 'SyncStates$value' => NULL, ], ], 'SyncStateConfig' => [ 'base' => NULL, 'refs' => [ 'SyncState$Config' => '<p>The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall provides each endpoint with the rules that are configured in the firewall policy. Each time you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the rules in the endpoint, so it can properly filter network traffic. This is part of the <a>FirewallStatus</a>.</p>', ], ], 'SyncStates' => [ 'base' => NULL, 'refs' => [ 'FirewallStatus$SyncStates' => '<p>The subnets that you\'ve configured for use by the Network Firewall firewall. This contains one array element per Availability Zone where you\'ve configured a subnet. These objects provide details of the information that is summarized in the <code>ConfigurationSyncStateSummary</code> and <code>Status</code>, broken down by zone and configuration object. </p>', ], ], 'TCPFlag' => [ 'base' => NULL, 'refs' => [ 'Flags$member' => NULL, ], ], 'TCPFlagField' => [ 'base' => '<p>TCP flags and masks to inspect packets for, used in stateless rules <a>MatchAttributes</a> settings.</p>', 'refs' => [ 'TCPFlags$member' => NULL, ], ], 'TCPFlags' => [ 'base' => NULL, 'refs' => [ 'MatchAttributes$TCPFlags' => '<p>The TCP flags and masks to inspect for. If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).</p>', ], ], 'TLSInspectionConfiguration' => [ 'base' => '<p>The object that defines a TLS inspection configuration. This, along with <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p> <p>Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.</p> <p>To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'refs' => [ 'CreateTLSInspectionConfigurationRequest$TLSInspectionConfiguration' => '<p>The object that defines a TLS inspection configuration. This, along with <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p> <p>Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.</p> <p>To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'DescribeTLSInspectionConfigurationResponse$TLSInspectionConfiguration' => '<p>The object that defines a TLS inspection configuration. This, along with <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p> <p>Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.</p> <p>To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p>', 'UpdateTLSInspectionConfigurationRequest$TLSInspectionConfiguration' => '<p>The object that defines a TLS inspection configuration. This, along with <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p> <p>Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.</p> <p>To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.</p>', ], ], 'TLSInspectionConfigurationMetadata' => [ 'base' => '<p>High-level information about a TLS inspection configuration, returned by <code>ListTLSInspectionConfigurations</code>. You can use the information provided in the metadata to retrieve and manage a TLS configuration.</p>', 'refs' => [ 'TLSInspectionConfigurations$member' => NULL, ], ], 'TLSInspectionConfigurationResponse' => [ 'base' => '<p>The high-level properties of a TLS inspection configuration. This, along with the <code>TLSInspectionConfiguration</code>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <code>DescribeTLSInspectionConfiguration</code>.</p>', 'refs' => [ 'CreateTLSInspectionConfigurationResponse$TLSInspectionConfigurationResponse' => '<p>The high-level properties of a TLS inspection configuration. This, along with the <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>', 'DeleteTLSInspectionConfigurationResponse$TLSInspectionConfigurationResponse' => '<p>The high-level properties of a TLS inspection configuration. This, along with the <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>', 'DescribeTLSInspectionConfigurationResponse$TLSInspectionConfigurationResponse' => '<p>The high-level properties of a TLS inspection configuration. This, along with the <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>', 'UpdateTLSInspectionConfigurationResponse$TLSInspectionConfigurationResponse' => '<p>The high-level properties of a TLS inspection configuration. This, along with the <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>', ], ], 'TLSInspectionConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListTLSInspectionConfigurationsResponse$TLSInspectionConfigurations' => '<p>The TLS inspection configuration metadata objects that you\'ve defined. Depending on your setting for max results and the number of TLS inspection configurations, this might not be the full list.</p>', ], ], 'Tag' => [ 'base' => '<p>A key:value pair associated with an Amazon Web Services resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each Amazon Web Services resource. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p/>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallPolicyRequest$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'CreateFirewallRequest$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'CreateRuleGroupRequest$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'CreateTLSInspectionConfigurationRequest$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'Firewall$Tags' => '<p/>', 'FirewallPolicyResponse$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags that are associated with the resource. </p>', 'RuleGroupResponse$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'TLSInspectionConfigurationResponse$Tags' => '<p>The key:value pairs to associate with the resource.</p>', 'TagResourceRequest$Tags' => '<p/>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>', ], ], 'TagsPaginationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$MaxResults' => '<p>The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'TargetTypes$member' => NULL, ], ], 'TargetTypes' => [ 'base' => NULL, 'refs' => [ 'RulesSourceList$TargetTypes' => '<p>The protocols you want to inspect. Specify <code>TLS_SNI</code> for <code>HTTPS</code>. Specify <code>HTTP_HOST</code> for <code>HTTP</code>. You can specify either or both. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Unable to process the request due to throttling limitations.</p>', 'refs' => [], ], 'TlsCertificateData' => [ 'base' => '<p>Contains metadata about an Certificate Manager certificate.</p>', 'refs' => [ 'Certificates$member' => NULL, 'TLSInspectionConfigurationResponse$CertificateAuthority' => NULL, ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The operation you requested isn\'t supported by Network Firewall. </p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDeleteProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDeleteProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDescriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDescriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallEncryptionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallEncryptionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallPolicyChangeProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallPolicyChangeProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubnetChangeProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubnetChangeProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTLSInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTLSInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateToken' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallPolicyRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'AssociateFirewallPolicyResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'AssociateSubnetsRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'AssociateSubnetsResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'CreateFirewallPolicyResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p> <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'CreateRuleGroupResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p> <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'CreateTLSInspectionConfigurationResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request. </p> <p>To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DescribeFirewallPolicyResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p> <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DescribeFirewallResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DescribeRuleGroupResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p> <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DescribeTLSInspectionConfigurationResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request. </p> <p>To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DisassociateSubnetsRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'DisassociateSubnetsResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'PerObjectStatus$UpdateToken' => '<p>The current version of the object that is either in sync or pending synchronization. </p>', 'SourceMetadata$SourceUpdateToken' => '<p>The update token of the Amazon Web Services managed rule group that your own rule group is copied from. To determine the update token for the managed rule group, call <a href="https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken">DescribeRuleGroup</a>.</p>', 'UpdateFirewallDeleteProtectionRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallDeleteProtectionResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallDescriptionRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallDescriptionResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallEncryptionConfigurationRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallEncryptionConfigurationResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallPolicyChangeProtectionRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallPolicyChangeProtectionResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallPolicyRequest$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p> <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateFirewallPolicyResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request. </p> <p>To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateRuleGroupRequest$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p> <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateRuleGroupResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request. </p> <p>To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateSubnetChangeProtectionRequest$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateSubnetChangeProtectionResponse$UpdateToken' => '<p>An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request. </p> <p>To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.</p> <p>To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateTLSInspectionConfigurationRequest$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request. </p> <p>To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', 'UpdateTLSInspectionConfigurationResponse$UpdateToken' => '<p>A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request. </p> <p>To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn\'t changed since you last retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. </p>', ], ], 'VariableDefinition' => [ 'base' => NULL, 'refs' => [ 'VariableDefinitionList$member' => NULL, ], ], 'VariableDefinitionList' => [ 'base' => NULL, 'refs' => [ 'IPSet$Definition' => '<p>The list of IP addresses and address ranges, in CIDR notation. </p>', 'PortSet$Definition' => '<p>The set of port ranges. </p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRequest$VpcId' => '<p>The unique identifier of the VPC where Network Firewall should create the firewall. </p> <p>You can\'t change this setting after you create the firewall. </p>', 'Firewall$VpcId' => '<p>The unique identifier of the VPC where the firewall is in use. </p>', 'VpcIds$member' => NULL, ], ], 'VpcIds' => [ 'base' => NULL, 'refs' => [ 'ListFirewallsRequest$VpcIds' => '<p>The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.</p>', ], ], ],];
