<?php
// This file was auto-generated from sdk-root/src/data/opsworks/2013-02-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>OpsWorks</fullname> <p>Welcome to the <i>OpsWorks Stacks API Reference</i>. This guide provides descriptions, syntax, and usage examples for OpsWorks Stacks actions and data types, including common parameters and error codes. </p> <p>OpsWorks Stacks is an application management service that provides an integrated experience for managing the complete application lifecycle. For information about OpsWorks, see the <a href="http://aws.amazon.com/opsworks/">OpsWorks</a> information page.</p> <p> <b>SDKs and CLI</b> </p> <p>Use the OpsWorks Stacks API by using the Command Line Interface (CLI) or by using one of the Amazon Web Services SDKs to implement applications in your preferred language. For more information, see:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html">CLI</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/opsworks/AWSOpsWorksClient.html">SDK for Java</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/OpsWorks/NOpsWorks.html">SDK for .NET</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/aws-sdk-php/v3/api/class-Aws.OpsWorks.OpsWorksClient.html">SDK for PHP</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/sdkforruby/api/">SDK for Ruby</a> </p> </li> <li> <p> <a href="http://aws.amazon.com/documentation/sdkforjavascript/">Amazon Web Services SDK for Node.js</a> </p> </li> <li> <p> <a href="http://docs.pythonboto.org/en/latest/ref/opsworks.html">SDK for Python (Boto)</a> </p> </li> </ul> <p> <b>Endpoints</b> </p> <p>OpsWorks Stacks supports the following endpoints, all HTTPS. You must connect to one of the following endpoints. Stacks can only be accessed or managed within the endpoint in which they are created.</p> <ul> <li> <p>opsworks.us-east-1.amazonaws.com</p> </li> <li> <p>opsworks.us-east-2.amazonaws.com</p> </li> <li> <p>opsworks.us-west-1.amazonaws.com</p> </li> <li> <p>opsworks.us-west-2.amazonaws.com</p> </li> <li> <p>opsworks.ca-central-1.amazonaws.com (API only; not available in the Amazon Web Services Management Console)</p> </li> <li> <p>opsworks.eu-west-1.amazonaws.com</p> </li> <li> <p>opsworks.eu-west-2.amazonaws.com</p> </li> <li> <p>opsworks.eu-west-3.amazonaws.com</p> </li> <li> <p>opsworks.eu-central-1.amazonaws.com</p> </li> <li> <p>opsworks.ap-northeast-1.amazonaws.com</p> </li> <li> <p>opsworks.ap-northeast-2.amazonaws.com</p> </li> <li> <p>opsworks.ap-south-1.amazonaws.com</p> </li> <li> <p>opsworks.ap-southeast-1.amazonaws.com</p> </li> <li> <p>opsworks.ap-southeast-2.amazonaws.com</p> </li> <li> <p>opsworks.sa-east-1.amazonaws.com</p> </li> </ul> <p> <b>Chef Versions</b> </p> <p>When you call <a>CreateStack</a>, <a>CloneStack</a>, or <a>UpdateStack</a> we recommend you use the <code>ConfigurationManager</code> parameter to specify the Chef version. The recommended and default value for Linux stacks is currently 12. Windows stacks use Chef 12.2. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-chef11.html">Chef Versions</a>.</p> <note> <p>You can specify Chef 12, 11.10, or 11.4 for your Linux stack. We recommend migrating your existing Linux stacks to Chef 12 as soon as possible.</p> </note>', 'operations' => [ 'AssignInstance' => '<p>Assign a registered instance to a layer.</p> <ul> <li> <p>You can assign registered on-premises instances to any layer type.</p> </li> <li> <p>You can assign registered Amazon EC2 instances only to custom layers.</p> </li> <li> <p>You cannot use this action with instances that were created with OpsWorks Stacks.</p> </li> </ul> <p> <b>Required Permissions</b>: To use this action, an Identity and Access Management (IAM) user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'AssignVolume' => '<p>Assigns one of the stack\'s registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling <a>RegisterVolume</a>. After you register the volume, you must call <a>UpdateVolume</a> to specify a mount point before calling <code>AssignVolume</code>. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'AssociateElasticIp' => '<p>Associates one of the stack\'s registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling <a>RegisterElasticIp</a>. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'AttachElasticLoadBalancer' => '<p>Attaches an Elastic Load Balancing load balancer to a specified layer. OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with OpsWorks Stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html">Elastic Load Balancing</a>.</p> <note> <p>You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI. For more information, see the <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html">Elastic Load Balancing Developer Guide</a>.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CloneStack' => '<p>Creates a clone of a specified stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html">Clone a Stack</a>. By default, all parameters are set to the values used by the parent stack.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateApp' => '<p>Creates an app for a specified stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Creating Apps</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateDeployment' => '<p>Runs deployment or stack commands. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html">Deploying Apps</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html">Run Stack Commands</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateInstance' => '<p>Creates an instance in a specified stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html">Adding an Instance to a Layer</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateLayer' => '<p>Creates a layer. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html">How to Create a Layer</a>.</p> <note> <p>You should use <b>CreateLayer</b> for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, <b>CreateLayer</b> fails. A stack can have an arbitrary number of custom layers, so you can call <b>CreateLayer</b> as many times as you like for that layer type.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateStack' => '<p>Creates a new stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html">Create a New Stack</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'CreateUserProfile' => '<p>Creates a new user profile.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeleteApp' => '<p>Deletes a specified app.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeleteInstance' => '<p>Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html">Deleting Instances</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeleteLayer' => '<p>Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html">How to Delete a Layer</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeleteStack' => '<p>Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html">Shut Down a Stack</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeleteUserProfile' => '<p>Deletes a user profile.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeregisterEcsCluster' => '<p>Deregisters a specified Amazon ECS cluster from a stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete"> Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html</a>.</p>', 'DeregisterElasticIp' => '<p>Deregisters a specified Elastic IP address. The address can be registered by another stack after it is deregistered. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeregisterInstance' => '<p>Deregister an instance from OpsWorks Stacks. The instance can be a registered instance (Amazon EC2 or on-premises) or an instance created with OpsWorks. This action removes the instance from the stack and returns it to your control.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeregisterRdsDbInstance' => '<p>Deregisters an Amazon RDS instance.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DeregisterVolume' => '<p>Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeAgentVersions' => '<p>Describes the available OpsWorks Stacks agent versions. You must specify a stack ID or a configuration manager. <code>DescribeAgentVersions</code> returns a list of available agent versions for the specified stack or configuration manager.</p>', 'DescribeApps' => '<p>Requests a description of a specified set of apps.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeCommands' => '<p>Describes the results of specified commands.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeDeployments' => '<p>Requests a description of a specified set of deployments.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeEcsClusters' => '<p>Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the <code>MaxResults</code> and <code>NextToken</code> parameters to paginate the response. However, OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permission. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p> <p>This call accepts only one resource-identifying parameter.</p>', 'DescribeElasticIps' => '<p>Describes <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP addresses</a>.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeElasticLoadBalancers' => '<p>Describes a stack\'s Elastic Load Balancing instances.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeInstances' => '<p>Requests a description of a set of instances.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeLayers' => '<p>Requests a description of one or more layers in a specified stack.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeLoadBasedAutoScaling' => '<p>Describes load-based auto scaling configurations for specified layers.</p> <note> <p>You must specify at least one of the parameters.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeMyUserProfile' => '<p>Describes a user\'s SSH information.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeOperatingSystems' => '<p>Describes the operating systems that are supported by OpsWorks Stacks.</p>', 'DescribePermissions' => '<p>Describes the permissions for a specified stack.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeRaidArrays' => '<p>Describe an instance\'s RAID arrays.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeRdsDbInstances' => '<p>Describes Amazon RDS instances.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p> <p>This call accepts only one resource-identifying parameter.</p>', 'DescribeServiceErrors' => '<p>Describes OpsWorks Stacks service errors.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p> <p>This call accepts only one resource-identifying parameter.</p>', 'DescribeStackProvisioningParameters' => '<p>Requests a description of a stack\'s provisioning parameters.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeStackSummary' => '<p>Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as <code>running_setup</code> or <code>online</code>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeStacks' => '<p>Requests a description of one or more stacks.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeTimeBasedAutoScaling' => '<p>Describes time-based auto scaling configurations for specified instances.</p> <note> <p>You must specify at least one of the parameters.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeUserProfiles' => '<p>Describe specified users.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DescribeVolumes' => '<p>Describes an instance\'s Amazon EBS volumes.</p> <note> <p>This call accepts only one resource-identifying parameter.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DetachElasticLoadBalancer' => '<p>Detaches a specified Elastic Load Balancing instance from its layer.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'DisassociateElasticIp' => '<p>Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'GetHostnameSuggestion' => '<p>Gets a generated host name for the specified layer, based on the current host name theme.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'GrantAccess' => '<note> <p>This action can be used only with Windows stacks.</p> </note> <p>Grants RDP access to a Windows instance for a specified time period.</p>', 'ListTags' => '<p>Returns a list of tags that are applied to the specified stack or layer.</p>', 'RebootInstance' => '<p>Reboots a specified instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting, Stopping, and Rebooting Instances</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'RegisterEcsCluster' => '<p>Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html"> Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html"> Managing User Permissions</a>.</p>', 'RegisterElasticIp' => '<p>Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling <a>DeregisterElasticIp</a>. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'RegisterInstance' => '<p>Registers instances that were created outside of OpsWorks Stacks with a specified stack.</p> <note> <p>We do not recommend using this action to register instances. The complete registration operation includes two tasks: installing the OpsWorks Stacks agent on the instance, and registering the instance with the stack. <code>RegisterInstance</code> handles only the second step. You should instead use the CLI <code>register</code> command, which performs the entire registration operation. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html"> Registering an Instance with an OpsWorks Stacks Stack</a>.</p> </note> <p>Registered instances have the same requirements as instances that are created by using the <a>CreateInstance</a> API. For example, registered instances must be running a supported Linux-based operating system, and they must have a supported instance type. For more information about requirements for instances that you want to register, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html"> Preparing the Instance</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'RegisterRdsDbInstance' => '<p>Registers an Amazon RDS instance with a stack.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'RegisterVolume' => '<p>Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling <a>DeregisterVolume</a>. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'SetLoadBasedAutoScaling' => '<p>Specify the load-based auto scaling configuration for a specified layer. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html">Managing Load with Time-based and Load-based Instances</a>.</p> <note> <p>To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto scaling operates only on the instances from that set, so you must ensure that you have created enough instances to handle the maximum anticipated load.</p> </note> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'SetPermission' => '<p>Specifies a user\'s permissions. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html">Security and Permissions</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'SetTimeBasedAutoScaling' => '<p>Specify the time-based auto scaling configuration for a specified instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html">Managing Load with Time-based and Load-based Instances</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'StartInstance' => '<p>Starts a specified instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting, Stopping, and Rebooting Instances</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'StartStack' => '<p>Starts a stack\'s instances.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'StopInstance' => '<p>Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting, Stopping, and Rebooting Instances</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'StopStack' => '<p>Stops a specified stack.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'TagResource' => '<p>Apply cost-allocation tags to a specified stack or layer in OpsWorks Stacks. For more information about how tagging works, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html">Tags</a> in the OpsWorks User Guide.</p>', 'UnassignInstance' => '<p>Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with OpsWorks Stacks.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UnassignVolume' => '<p>Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UntagResource' => '<p>Removes tags from a specified stack or layer.</p>', 'UpdateApp' => '<p>Updates a specified app.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateElasticIp' => '<p>Updates a registered Elastic IP address\'s name. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateInstance' => '<p>Updates a specified instance.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateLayer' => '<p>Updates a specified layer.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateMyUserProfile' => '<p>Updates a user\'s SSH public key.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateRdsDbInstance' => '<p>Updates an Amazon RDS instance.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateStack' => '<p>Updates a specified stack.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateUserProfile' => '<p>Updates a specified user profile.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'UpdateVolume' => '<p>Updates an Amazon EBS volume\'s name or mount point. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.</p> <p> <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', ], 'shapes' => [ 'AgentVersion' => [ 'base' => '<p>Describes an agent version.</p>', 'refs' => [ 'AgentVersions$member' => NULL, ], ], 'AgentVersions' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentVersionsResult$AgentVersions' => '<p>The agent versions for the specified stack or configuration manager. Note that this value is the complete version number, not the abbreviated number used by the console.</p>', ], ], 'App' => [ 'base' => '<p>A description of the app.</p>', 'refs' => [ 'Apps$member' => NULL, ], ], 'AppAttributes' => [ 'base' => NULL, 'refs' => [ 'App$Attributes' => '<p>The stack attributes.</p>', 'CreateAppRequest$Attributes' => '<p>One or more user-defined key/value pairs to be added to the stack attributes.</p>', 'UpdateAppRequest$Attributes' => '<p>One or more user-defined key/value pairs to be added to the stack attributes.</p>', ], ], 'AppAttributesKeys' => [ 'base' => NULL, 'refs' => [ 'AppAttributes$key' => NULL, ], ], 'AppType' => [ 'base' => NULL, 'refs' => [ 'App$Type' => '<p>The app type.</p>', 'CreateAppRequest$Type' => '<p>The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn\'t one of the standard types, or you prefer to implement your own Deploy recipes, specify <code>other</code>.</p>', 'UpdateAppRequest$Type' => '<p>The app type.</p>', ], ], 'Apps' => [ 'base' => NULL, 'refs' => [ 'DescribeAppsResult$Apps' => '<p>An array of <code>App</code> objects that describe the specified apps. </p>', ], ], 'Architecture' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$Architecture' => '<p>The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>', 'Instance$Architecture' => '<p>The instance architecture: "i386" or "x86_64".</p>', 'UpdateInstanceRequest$Architecture' => '<p>The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.</p>', ], ], 'AssignInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssignVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateElasticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachElasticLoadBalancerRequest' => [ 'base' => NULL, 'refs' => [], ], 'AutoScalingThresholds' => [ 'base' => '<p>Describes a load-based auto scaling upscaling or downscaling threshold configuration, which specifies when OpsWorks Stacks starts or stops load-based instances.</p>', 'refs' => [ 'LoadBasedAutoScalingConfiguration$UpScaling' => '<p>An <code>AutoScalingThresholds</code> object that describes the upscaling configuration, which defines how and when OpsWorks Stacks increases the number of instances.</p>', 'LoadBasedAutoScalingConfiguration$DownScaling' => '<p>An <code>AutoScalingThresholds</code> object that describes the downscaling configuration, which defines how and when OpsWorks Stacks reduces the number of instances.</p>', 'SetLoadBasedAutoScalingRequest$UpScaling' => '<p>An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, OpsWorks Stacks starts a specified number of instances.</p>', 'SetLoadBasedAutoScalingRequest$DownScaling' => '<p>An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, OpsWorks Stacks stops a specified number of instances.</p>', ], ], 'AutoScalingType' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$AutoScalingType' => '<p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>', 'Instance$AutoScalingType' => '<p>For load-based or time-based instances, the type.</p>', 'UpdateInstanceRequest$AutoScalingType' => '<p>For load-based or time-based instances, the type. Windows stacks can use only time-based instances.</p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping. This data type maps directly to the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a> data type. </p>', 'refs' => [ 'BlockDeviceMappings$member' => NULL, ], ], 'BlockDeviceMappings' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$BlockDeviceMappings' => '<p>An array of <code>BlockDeviceMapping</code> objects that specify the instance\'s block devices. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.</p>', 'Instance$BlockDeviceMappings' => '<p>An array of <code>BlockDeviceMapping</code> objects that specify the instance\'s block device mappings.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'App$EnableSsl' => '<p>Whether to enable SSL for the app.</p>', 'ChefConfiguration$ManageBerkshelf' => '<p>Whether to enable Berkshelf.</p>', 'CloneStackRequest$UseCustomCookbooks' => '<p>Whether to use custom cookbooks.</p>', 'CloneStackRequest$UseOpsworksSecurityGroups' => '<p>Whether to associate the OpsWorks Stacks built-in security groups with the stack\'s layers.</p> <p>OpsWorks Stacks provides a standard set of security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p> <ul> <li> <p>True - OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.</p> </li> <li> <p>False - OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'CloneStackRequest$ClonePermissions' => '<p>Whether to clone the source stack\'s permissions.</p>', 'CloudWatchLogsConfiguration$Enabled' => '<p>Whether CloudWatch Logs is enabled for a layer.</p>', 'CreateAppRequest$EnableSsl' => '<p>Whether to enable SSL for the app.</p>', 'CreateInstanceRequest$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p> </note>', 'CreateInstanceRequest$EbsOptimized' => '<p>Whether to create an Amazon EBS-optimized instance.</p>', 'CreateLayerRequest$EnableAutoHealing' => '<p>Whether to disable auto healing for the layer.</p>', 'CreateLayerRequest$AutoAssignElasticIps' => '<p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'CreateLayerRequest$AutoAssignPublicIps' => '<p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'CreateLayerRequest$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>To ensure that your instances have the latest security updates, we strongly recommend using the default value of <code>true</code>.</p> </note>', 'CreateLayerRequest$UseEbsOptimizedInstances' => '<p>Whether to use Amazon EBS-optimized instances.</p>', 'CreateStackRequest$UseCustomCookbooks' => '<p>Whether the stack uses custom cookbooks.</p>', 'CreateStackRequest$UseOpsworksSecurityGroups' => '<p>Whether to associate the OpsWorks Stacks built-in security groups with the stack\'s layers.</p> <p>OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p> <ul> <li> <p>True - OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li> <li> <p>False - OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'CreateUserProfileRequest$AllowSelfManagement' => '<p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Setting an IAM User\'s Public SSH Key</a>.</p>', 'DeleteInstanceRequest$DeleteElasticIp' => '<p>Whether to delete the instance Elastic IP address.</p>', 'DeleteInstanceRequest$DeleteVolumes' => '<p>Whether to delete the instance\'s Amazon EBS volumes.</p>', 'EbsBlockDevice$DeleteOnTermination' => '<p>Whether the volume is deleted on instance termination.</p>', 'EnvironmentVariable$Secure' => '<p>(Optional) Whether the variable\'s value is returned by the <a>DescribeApps</a> action. To hide an environment variable\'s value, set <code>Secure</code> to <code>true</code>. <code>DescribeApps</code> returns <code>*****FILTERED*****</code> instead of the actual value. The default value for <code>Secure</code> is <code>false</code>. </p>', 'Instance$EbsOptimized' => '<p>Whether this is an Amazon EBS-optimized instance.</p>', 'Instance$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. If this value is set to <code>false</code>, you must update instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.</p> </note>', 'Layer$EnableAutoHealing' => '<p>Whether auto healing is disabled for the layer.</p>', 'Layer$AutoAssignElasticIps' => '<p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'Layer$AutoAssignPublicIps' => '<p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'Layer$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p> </note>', 'Layer$UseEbsOptimizedInstances' => '<p>Whether the layer uses Amazon EBS-optimized instances.</p>', 'LoadBasedAutoScalingConfiguration$Enable' => '<p>Whether load-based auto scaling is enabled for the layer.</p>', 'OperatingSystem$Supported' => '<p>Indicates that an operating system is not supported for new instances.</p>', 'Permission$AllowSsh' => '<p>Whether the user can use SSH.</p>', 'Permission$AllowSudo' => '<p>Whether the user can use <b>sudo</b>.</p>', 'RdsDbInstance$MissingOnRds' => '<p>Set to <code>true</code> if OpsWorks Stacks is unable to discover the Amazon RDS instance. OpsWorks Stacks attempts to discover the instance only once. If this value is set to <code>true</code>, you must deregister the instance, and then register it again.</p>', 'SetLoadBasedAutoScalingRequest$Enable' => '<p>Enables load-based auto scaling for the layer.</p>', 'SetPermissionRequest$AllowSsh' => '<p>The user is allowed to use SSH to communicate with the instance.</p>', 'SetPermissionRequest$AllowSudo' => '<p>The user is allowed to use <b>sudo</b> to elevate privileges.</p>', 'ShutdownEventConfiguration$DelayUntilElbConnectionsDrained' => '<p>Whether to enable Elastic Load Balancing connection draining. For more information, see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a> </p>', 'Stack$UseCustomCookbooks' => '<p>Whether the stack uses custom cookbooks.</p>', 'Stack$UseOpsworksSecurityGroups' => '<p>Whether the stack automatically associates the OpsWorks Stacks built-in security groups with the stack\'s layers.</p>', 'StopInstanceRequest$Force' => '<p>Specifies whether to force an instance to stop. If the instance\'s root device type is <code>ebs</code>, or EBS-backed, adding the <code>Force</code> parameter to the <code>StopInstances</code> API call disassociates the OpsWorks Stacks instance from EC2, and forces deletion of <i>only</i> the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the OpsWorks Stacks instance with a new one.</p>', 'UpdateAppRequest$EnableSsl' => '<p>Whether SSL is enabled for the app.</p>', 'UpdateInstanceRequest$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p> </note>', 'UpdateInstanceRequest$EbsOptimized' => '<p>This property cannot be updated.</p>', 'UpdateLayerRequest$EnableAutoHealing' => '<p>Whether to disable auto healing for the layer.</p>', 'UpdateLayerRequest$AutoAssignElasticIps' => '<p>Whether to automatically assign an <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'UpdateLayerRequest$AutoAssignPublicIps' => '<p>For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a Layer</a>.</p>', 'UpdateLayerRequest$InstallUpdatesOnBoot' => '<p>Whether to install operating system and package updates when the instance boots. The default value is <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p> <note> <p>We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest security updates.</p> </note>', 'UpdateLayerRequest$UseEbsOptimizedInstances' => '<p>Whether to use Amazon EBS-optimized instances.</p>', 'UpdateStackRequest$UseCustomCookbooks' => '<p>Whether the stack uses custom cookbooks.</p>', 'UpdateStackRequest$UseOpsworksSecurityGroups' => '<p>Whether to associate the OpsWorks Stacks built-in security groups with the stack\'s layers.</p> <p>OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. <code>UseOpsworksSecurityGroups</code> allows you to provide your own custom security groups instead of using the built-in groups. <code>UseOpsworksSecurityGroups</code> has the following settings: </p> <ul> <li> <p>True - OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</p> </li> <li> <p>False - OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'UpdateUserProfileRequest$AllowSelfManagement' => '<p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>', 'UserProfile$AllowSelfManagement' => '<p>Whether users can specify their own SSH public key through the My Settings page. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a>.</p>', 'Volume$Encrypted' => '<p>Specifies whether an Amazon EBS volume is encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>', 'VolumeConfiguration$Encrypted' => '<p>Specifies whether an Amazon EBS volume is encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.</p>', ], ], 'ChefConfiguration' => [ 'base' => '<p>Describes the Chef configuration.</p>', 'refs' => [ 'CloneStackRequest$ChefConfiguration' => '<p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'CreateStackRequest$ChefConfiguration' => '<p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'Stack$ChefConfiguration' => '<p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', 'UpdateStackRequest$ChefConfiguration' => '<p>A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.</p>', ], ], 'CloneStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'CloneStackResult' => [ 'base' => '<p>Contains the response to a <code>CloneStack</code> request.</p>', 'refs' => [], ], 'CloudWatchLogsConfiguration' => [ 'base' => '<p>Describes the Amazon CloudWatch Logs configuration for a layer.</p>', 'refs' => [ 'CreateLayerRequest$CloudWatchLogsConfiguration' => '<p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <a>CloudWatchLogsLogStream</a>.</p>', 'Layer$CloudWatchLogsConfiguration' => '<p>The Amazon CloudWatch Logs configuration settings for the layer.</p>', 'UpdateLayerRequest$CloudWatchLogsConfiguration' => '<p>Specifies CloudWatch Logs configuration options for the layer. For more information, see <a>CloudWatchLogsLogStream</a>.</p>', ], ], 'CloudWatchLogsEncoding' => [ 'base' => '<p>Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>', 'refs' => [ 'CloudWatchLogsLogStream$Encoding' => '<p>Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.</p>', ], ], 'CloudWatchLogsInitialPosition' => [ 'base' => '<p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. It\'s only used if there is no state persisted for that log stream.</p>', 'refs' => [ 'CloudWatchLogsLogStream$InitialPosition' => '<p>Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting is only used if there is no state persisted for that log stream.</p>', ], ], 'CloudWatchLogsLogStream' => [ 'base' => '<p>Describes the CloudWatch Logs configuration for a layer. For detailed information about members of this data type, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>', 'refs' => [ 'CloudWatchLogsLogStreams$member' => NULL, ], ], 'CloudWatchLogsLogStreams' => [ 'base' => '<p>Describes the Amazon CloudWatch Logs configuration for a layer.</p>', 'refs' => [ 'CloudWatchLogsConfiguration$LogStreams' => '<p>A list of configuration options for CloudWatch Logs.</p>', ], ], 'CloudWatchLogsTimeZone' => [ 'base' => '<p>The preferred time zone for logs streamed to CloudWatch Logs. Valid values are <code>LOCAL</code> and <code>UTC</code>, for Coordinated Universal Time.</p>', 'refs' => [ 'CloudWatchLogsLogStream$TimeZone' => '<p>Specifies the time zone of log event time stamps.</p>', ], ], 'Command' => [ 'base' => '<p>Describes a command.</p>', 'refs' => [ 'Commands$member' => NULL, ], ], 'Commands' => [ 'base' => NULL, 'refs' => [ 'DescribeCommandsResult$Commands' => '<p>An array of <code>Command</code> objects that describe each of the specified commands.</p>', ], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResult' => [ 'base' => '<p>Contains the response to a <code>CreateApp</code> request.</p>', 'refs' => [], ], 'CreateDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentResult' => [ 'base' => '<p>Contains the response to a <code>CreateDeployment</code> request.</p>', 'refs' => [], ], 'CreateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceResult' => [ 'base' => '<p>Contains the response to a <code>CreateInstance</code> request.</p>', 'refs' => [], ], 'CreateLayerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLayerResult' => [ 'base' => '<p>Contains the response to a <code>CreateLayer</code> request.</p>', 'refs' => [], ], 'CreateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackResult' => [ 'base' => '<p>Contains the response to a <code>CreateStack</code> request.</p>', 'refs' => [], ], 'CreateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileResult' => [ 'base' => '<p>Contains the response to a <code>CreateUserProfile</code> request.</p>', 'refs' => [], ], 'DailyAutoScalingSchedule' => [ 'base' => NULL, 'refs' => [ 'WeeklyAutoScalingSchedule$Monday' => '<p>The schedule for Monday.</p>', 'WeeklyAutoScalingSchedule$Tuesday' => '<p>The schedule for Tuesday.</p>', 'WeeklyAutoScalingSchedule$Wednesday' => '<p>The schedule for Wednesday.</p>', 'WeeklyAutoScalingSchedule$Thursday' => '<p>The schedule for Thursday.</p>', 'WeeklyAutoScalingSchedule$Friday' => '<p>The schedule for Friday.</p>', 'WeeklyAutoScalingSchedule$Saturday' => '<p>The schedule for Saturday.</p>', 'WeeklyAutoScalingSchedule$Sunday' => '<p>The schedule for Sunday.</p>', ], ], 'DataSource' => [ 'base' => '<p>Describes an app\'s data source.</p>', 'refs' => [ 'DataSources$member' => NULL, ], ], 'DataSources' => [ 'base' => NULL, 'refs' => [ 'App$DataSources' => '<p>The app\'s data sources.</p>', 'CreateAppRequest$DataSources' => '<p>The app\'s data source.</p>', 'UpdateAppRequest$DataSources' => '<p>The app\'s data sources.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Command$CreatedAt' => '<p>Date and time when the command was run.</p>', 'Command$AcknowledgedAt' => '<p>Date and time when the command was acknowledged.</p>', 'Command$CompletedAt' => '<p>Date when the command completed.</p>', 'Deployment$CreatedAt' => '<p>Date when the deployment was created.</p>', 'Deployment$CompletedAt' => '<p>Date when the deployment completed.</p>', 'EcsCluster$RegisteredAt' => '<p>The time and date that the cluster was registered with the stack.</p>', 'Instance$CreatedAt' => '<p>The time that the instance was created.</p>', 'Layer$CreatedAt' => '<p>Date when the layer was created.</p>', 'RaidArray$CreatedAt' => '<p>When the RAID array was created.</p>', 'ServiceError$CreatedAt' => '<p>When the error occurred.</p>', 'Stack$CreatedAt' => '<p>The date when the stack was created.</p>', ], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLayerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'Deployment' => [ 'base' => '<p>Describes a deployment of a stack or app.</p>', 'refs' => [ 'Deployments$member' => NULL, ], ], 'DeploymentCommand' => [ 'base' => '<p>Used to specify a stack or deployment command.</p>', 'refs' => [ 'CreateDeploymentRequest$Command' => '<p>A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.</p>', 'Deployment$Command' => '<p>Used to specify a stack or deployment command.</p>', ], ], 'DeploymentCommandArgs' => [ 'base' => NULL, 'refs' => [ 'DeploymentCommand$Args' => '<p>The arguments of those commands that take arguments. It should be set to a JSON object with the following format:</p> <p> <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code> </p> <p>The <code>update_dependencies</code> command takes two arguments:</p> <ul> <li> <p> <code>upgrade_os_to</code> - Specifies the Amazon Linux version that you want instances to run, such as <code>Amazon Linux 2</code>. You must also set the <code>allow_reboot</code> argument to true.</p> </li> <li> <p> <code>allow_reboot</code> - Specifies whether to allow OpsWorks Stacks to reboot the instances if necessary, after installing the updates. This argument can be set to either <code>true</code> or <code>false</code>. The default value is <code>false</code>.</p> </li> </ul> <p>For example, to upgrade an instance to Amazon Linux 2018.03, set <code>Args</code> to the following.</p> <p> <code> { "upgrade_os_to":["Amazon Linux 2018.03"], "allow_reboot":["true"] } </code> </p>', ], ], 'DeploymentCommandName' => [ 'base' => NULL, 'refs' => [ 'DeploymentCommand$Name' => '<p>Specifies the operation. You can specify only one command.</p> <p>For stacks, the following commands are available:</p> <ul> <li> <p> <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.</p> </li> <li> <p> <code>install_dependencies</code>: Install the stack\'s dependencies.</p> </li> <li> <p> <code>update_custom_cookbooks</code>: Update the stack\'s custom cookbooks.</p> </li> <li> <p> <code>update_dependencies</code>: Update the stack\'s dependencies.</p> </li> </ul> <note> <p>The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.</p> </note> <p>For apps, the following commands are available:</p> <ul> <li> <p> <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default setting is {"migrate":["false"]}.</p> </li> <li> <p> <code>rollback</code> Roll the app back to the previous version. When you update an app, OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as many as four versions.</p> </li> <li> <p> <code>start</code>: Start the app\'s web or application server.</p> </li> <li> <p> <code>stop</code>: Stop the app\'s web or application server.</p> </li> <li> <p> <code>restart</code>: Restart the app\'s web or application server.</p> </li> <li> <p> <code>undeploy</code>: Undeploy the app.</p> </li> </ul>', ], ], 'Deployments' => [ 'base' => NULL, 'refs' => [ 'DescribeDeploymentsResult$Deployments' => '<p>An array of <code>Deployment</code> objects that describe the deployments.</p>', ], ], 'DeregisterEcsClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterElasticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterRdsDbInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentVersionsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeAgentVersions</code> request.</p>', 'refs' => [], ], 'DescribeAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeApps</code> request.</p>', 'refs' => [], ], 'DescribeCommandsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCommandsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeCommands</code> request.</p>', 'refs' => [], ], 'DescribeDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeploymentsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeDeployments</code> request.</p>', 'refs' => [], ], 'DescribeEcsClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEcsClustersResult' => [ 'base' => '<p>Contains the response to a <code>DescribeEcsClusters</code> request.</p>', 'refs' => [], ], 'DescribeElasticIpsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticIpsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeElasticIps</code> request.</p>', 'refs' => [], ], 'DescribeElasticLoadBalancersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticLoadBalancersResult' => [ 'base' => '<p>Contains the response to a <code>DescribeElasticLoadBalancers</code> request.</p>', 'refs' => [], ], 'DescribeInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancesResult' => [ 'base' => '<p>Contains the response to a <code>DescribeInstances</code> request.</p>', 'refs' => [], ], 'DescribeLayersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLayersResult' => [ 'base' => '<p>Contains the response to a <code>DescribeLayers</code> request.</p>', 'refs' => [], ], 'DescribeLoadBasedAutoScalingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBasedAutoScalingResult' => [ 'base' => '<p>Contains the response to a <code>DescribeLoadBasedAutoScaling</code> request.</p>', 'refs' => [], ], 'DescribeMyUserProfileResult' => [ 'base' => '<p>Contains the response to a <code>DescribeMyUserProfile</code> request.</p>', 'refs' => [], ], 'DescribeOperatingSystemsResponse' => [ 'base' => '<p>The response to a <code>DescribeOperatingSystems</code> request.</p>', 'refs' => [], ], 'DescribePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionsResult' => [ 'base' => '<p>Contains the response to a <code>DescribePermissions</code> request.</p>', 'refs' => [], ], 'DescribeRaidArraysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRaidArraysResult' => [ 'base' => '<p>Contains the response to a <code>DescribeRaidArrays</code> request.</p>', 'refs' => [], ], 'DescribeRdsDbInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRdsDbInstancesResult' => [ 'base' => '<p>Contains the response to a <code>DescribeRdsDbInstances</code> request.</p>', 'refs' => [], ], 'DescribeServiceErrorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceErrorsResult' => [ 'base' => '<p>Contains the response to a <code>DescribeServiceErrors</code> request.</p>', 'refs' => [], ], 'DescribeStackProvisioningParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackProvisioningParametersResult' => [ 'base' => '<p>Contains the response to a <code>DescribeStackProvisioningParameters</code> request.</p>', 'refs' => [], ], 'DescribeStackSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSummaryResult' => [ 'base' => '<p>Contains the response to a <code>DescribeStackSummary</code> request.</p>', 'refs' => [], ], 'DescribeStacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksResult' => [ 'base' => '<p>Contains the response to a <code>DescribeStacks</code> request.</p>', 'refs' => [], ], 'DescribeTimeBasedAutoScalingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTimeBasedAutoScalingResult' => [ 'base' => '<p>Contains the response to a <code>DescribeTimeBasedAutoScaling</code> request.</p>', 'refs' => [], ], 'DescribeUserProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfilesResult' => [ 'base' => '<p>Contains the response to a <code>DescribeUserProfiles</code> request.</p>', 'refs' => [], ], 'DescribeVolumesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesResult' => [ 'base' => '<p>Contains the response to a <code>DescribeVolumes</code> request.</p>', 'refs' => [], ], 'DetachElasticLoadBalancerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateElasticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AutoScalingThresholds$CpuThreshold' => '<p>The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.</p>', 'AutoScalingThresholds$MemoryThreshold' => '<p>The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.</p>', 'AutoScalingThresholds$LoadThreshold' => '<p>The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see <a href="http://en.wikipedia.org/wiki/Load_%28computing%29">Load (computing)</a>.</p>', ], ], 'EbsBlockDevice' => [ 'base' => '<p>Describes an Amazon EBS volume. This data type maps directly to the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a> data type.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is launched.</p>', ], ], 'EcsCluster' => [ 'base' => '<p>Describes a registered Amazon ECS cluster.</p>', 'refs' => [ 'EcsClusters$member' => NULL, ], ], 'EcsClusters' => [ 'base' => NULL, 'refs' => [ 'DescribeEcsClustersResult$EcsClusters' => '<p>A list of <code>EcsCluster</code> objects containing the cluster descriptions.</p>', ], ], 'ElasticIp' => [ 'base' => '<p>Describes an Elastic IP address.</p>', 'refs' => [ 'ElasticIps$member' => NULL, ], ], 'ElasticIps' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticIpsResult$ElasticIps' => '<p>An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.</p>', ], ], 'ElasticLoadBalancer' => [ 'base' => '<p>Describes an Elastic Load Balancing instance.</p>', 'refs' => [ 'ElasticLoadBalancers$member' => NULL, ], ], 'ElasticLoadBalancers' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticLoadBalancersResult$ElasticLoadBalancers' => '<p>A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing instances.</p>', ], ], 'EnvironmentVariable' => [ 'base' => '<p>Represents an app\'s environment variable.</p>', 'refs' => [ 'EnvironmentVariables$member' => NULL, ], ], 'EnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'App$Environment' => '<p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>. </p> <note> <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variable names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an exception (API) with an "Environment: is too large (maximum is 20 KB)" message.</p> </note>', 'CreateAppRequest$Environment' => '<p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p> <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables\' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."</p> <note> <p>If you have specified one or more environment variables, you cannot modify the stack\'s Chef version.</p> </note>', 'UpdateAppRequest$Environment' => '<p>An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"> Environment Variables</a>.</p> <p>There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables\' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."</p> <note> <p>If you have specified one or more environment variables, you cannot modify the stack\'s Chef version.</p> </note>', ], ], 'GetHostnameSuggestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetHostnameSuggestionResult' => [ 'base' => '<p>Contains the response to a <code>GetHostnameSuggestion</code> request.</p>', 'refs' => [], ], 'GrantAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'GrantAccessResult' => [ 'base' => '<p>Contains the response to a <code>GrantAccess</code> request.</p>', 'refs' => [], ], 'Hour' => [ 'base' => NULL, 'refs' => [ 'DailyAutoScalingSchedule$key' => NULL, ], ], 'Instance' => [ 'base' => '<p>Describes an instance.</p>', 'refs' => [ 'Instances$member' => NULL, ], ], 'InstanceIdentity' => [ 'base' => '<p>Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata service. For more information, see <a href="https://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html">Instance Metadata and User Data</a>.</p>', 'refs' => [ 'RegisterInstanceRequest$InstanceIdentity' => '<p>An InstanceIdentity object that contains the instance\'s identity.</p>', ], ], 'Instances' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesResult$Instances' => '<p>An array of <code>Instance</code> objects that describe the instances.</p>', ], ], 'InstancesCount' => [ 'base' => '<p>Describes how many instances a stack has for each status.</p>', 'refs' => [ 'StackSummary$InstancesCount' => '<p>An <code>InstancesCount</code> object with the number of instances in each status.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AutoScalingThresholds$InstanceCount' => '<p>The number of instances to add or remove when the load exceeds a threshold.</p>', 'CloudWatchLogsLogStream$BufferDuration' => '<p>Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.</p>', 'CloudWatchLogsLogStream$BatchCount' => '<p>Specifies the max number of log events in a batch, up to 10000. The default value is 1000.</p>', 'CloudWatchLogsLogStream$BatchSize' => '<p>Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.</p>', 'Command$ExitCode' => '<p>The command exit code.</p>', 'Deployment$Duration' => '<p>The deployment duration.</p>', 'DescribeEcsClustersRequest$MaxResults' => '<p>To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'EbsBlockDevice$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>', 'EbsBlockDevice$VolumeSize' => '<p>The volume size, in GiB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.</p>', 'InstancesCount$Assigning' => '<p>The number of instances in the Assigning state.</p>', 'InstancesCount$Booting' => '<p>The number of instances with <code>booting</code> status.</p>', 'InstancesCount$ConnectionLost' => '<p>The number of instances with <code>connection_lost</code> status.</p>', 'InstancesCount$Deregistering' => '<p>The number of instances in the Deregistering state.</p>', 'InstancesCount$Online' => '<p>The number of instances with <code>online</code> status.</p>', 'InstancesCount$Pending' => '<p>The number of instances with <code>pending</code> status.</p>', 'InstancesCount$Rebooting' => '<p>The number of instances with <code>rebooting</code> status.</p>', 'InstancesCount$Registered' => '<p>The number of instances in the Registered state.</p>', 'InstancesCount$Registering' => '<p>The number of instances in the Registering state.</p>', 'InstancesCount$Requested' => '<p>The number of instances with <code>requested</code> status.</p>', 'InstancesCount$RunningSetup' => '<p>The number of instances with <code>running_setup</code> status.</p>', 'InstancesCount$SetupFailed' => '<p>The number of instances with <code>setup_failed</code> status.</p>', 'InstancesCount$ShuttingDown' => '<p>The number of instances with <code>shutting_down</code> status.</p>', 'InstancesCount$StartFailed' => '<p>The number of instances with <code>start_failed</code> status.</p>', 'InstancesCount$StopFailed' => '<p>The number of instances with <code>stop_failed</code> status.</p>', 'InstancesCount$Stopped' => '<p>The number of instances with <code>stopped</code> status.</p>', 'InstancesCount$Stopping' => '<p>The number of instances with <code>stopping</code> status.</p>', 'InstancesCount$Terminated' => '<p>The number of instances with <code>terminated</code> status.</p>', 'InstancesCount$Terminating' => '<p>The number of instances with <code>terminating</code> status.</p>', 'InstancesCount$Unassigning' => '<p>The number of instances in the Unassigning state.</p>', 'RaidArray$RaidLevel' => '<p>The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>', 'RaidArray$NumberOfDisks' => '<p>The number of disks in the array.</p>', 'RaidArray$Size' => '<p>The array\'s size.</p>', 'RaidArray$Iops' => '<p>For PIOPS volumes, the IOPS per disk.</p>', 'ShutdownEventConfiguration$ExecutionTimeout' => '<p>The time, in seconds, that OpsWorks Stacks waits after triggering a Shutdown event before shutting down an instance.</p>', 'StackSummary$LayersCount' => '<p>The number of layers.</p>', 'StackSummary$AppsCount' => '<p>The number of apps.</p>', 'TemporaryCredential$ValidForInMinutes' => '<p>The length of time (in minutes) that the grant is valid. When the grant expires, at the end of this period, the user will no longer be able to use the credentials to log in. If they are logged in at the time, they are automatically logged out.</p>', 'Volume$Size' => '<p>The volume size.</p>', 'Volume$Iops' => '<p>For PIOPS volumes, the IOPS per disk.</p>', 'VolumeConfiguration$RaidLevel' => '<p>The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.</p>', 'VolumeConfiguration$NumberOfDisks' => '<p>The number of disks in the volume.</p>', 'VolumeConfiguration$Size' => '<p>The volume size.</p>', 'VolumeConfiguration$Iops' => '<p>For PIOPS volumes, the IOPS per disk.</p>', ], ], 'Layer' => [ 'base' => '<p>Describes a layer.</p>', 'refs' => [ 'Layers$member' => NULL, ], ], 'LayerAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateLayerRequest$Attributes' => '<p>One or more user-defined key-value pairs to be added to the stack attributes.</p> <p>To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster\'s ARN.</p>', 'Layer$Attributes' => '<p>The layer attributes.</p> <p>For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code> attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value</p> <p>For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster\'s ARN.</p>', 'UpdateLayerRequest$Attributes' => '<p>One or more user-defined key/value pairs to be added to the stack attributes.</p>', ], ], 'LayerAttributesKeys' => [ 'base' => NULL, 'refs' => [ 'LayerAttributes$key' => NULL, ], ], 'LayerType' => [ 'base' => NULL, 'refs' => [ 'CreateLayerRequest$Type' => '<p>The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.</p>', 'Layer$Type' => '<p>The layer type.</p>', ], ], 'Layers' => [ 'base' => NULL, 'refs' => [ 'DescribeLayersResult$Layers' => '<p>An array of <code>Layer</code> objects that describe the layers.</p>', ], ], 'LifecycleEventConfiguration' => [ 'base' => '<p>Specifies the lifecycle event configuration</p>', 'refs' => [ 'CreateLayerRequest$LifecycleEventConfiguration' => '<p>A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.</p>', 'Layer$LifecycleEventConfiguration' => '<p>A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.</p>', 'UpdateLayerRequest$LifecycleEventConfiguration' => '<p/>', ], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResult' => [ 'base' => '<p>Contains the response to a <code>ListTags</code> request.</p>', 'refs' => [], ], 'LoadBasedAutoScalingConfiguration' => [ 'base' => '<p>Describes a layer\'s load-based auto scaling configuration.</p>', 'refs' => [ 'LoadBasedAutoScalingConfigurations$member' => NULL, ], ], 'LoadBasedAutoScalingConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBasedAutoScalingResult$LoadBasedAutoScalingConfigurations' => '<p>An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer\'s configuration.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$MaxResults' => '<p>Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a <code>ListTagsRequest</code> call. </p>', ], ], 'Minute' => [ 'base' => NULL, 'refs' => [ 'AutoScalingThresholds$ThresholdsWaitTime' => '<p>The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.</p>', 'AutoScalingThresholds$IgnoreMetricsTime' => '<p>The amount of time (in minutes) after a scaling event occurs that OpsWorks Stacks should ignore metrics and suppress additional scaling events. For example, OpsWorks Stacks adds new instances following an upscaling event but the instances won\'t start reducing the load until they have been booted and configured. There is no point in raising additional scaling events during that operation, which typically takes several minutes. <code>IgnoreMetricsTime</code> allows you to direct OpsWorks Stacks to suppress scaling events long enough to get the new instances online.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$NextToken' => '<p>Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a <code>ListTagsRequest</code> call. </p>', 'ListTagsResult$NextToken' => '<p>If a paginated request does not return all of the remaining results, this parameter is set to a token that you can assign to the request object\'s <code>NextToken</code> parameter to get the next set of results. If the previous paginated request returned all of the remaining results, this parameter is set to <code>null</code>. </p>', ], ], 'OperatingSystem' => [ 'base' => '<p>Describes supported operating systems in OpsWorks Stacks.</p>', 'refs' => [ 'OperatingSystems$member' => NULL, ], ], 'OperatingSystemConfigurationManager' => [ 'base' => '<p>A block that contains information about the configuration manager (Chef) and the versions of the configuration manager that are supported for an operating system.</p>', 'refs' => [ 'OperatingSystemConfigurationManagers$member' => NULL, ], ], 'OperatingSystemConfigurationManagers' => [ 'base' => NULL, 'refs' => [ 'OperatingSystem$ConfigurationManagers' => '<p>Supported configuration manager name and versions for an OpsWorks Stacks operating system.</p>', ], ], 'OperatingSystems' => [ 'base' => NULL, 'refs' => [ 'DescribeOperatingSystemsResponse$OperatingSystems' => '<p>Contains information in response to a <code>DescribeOperatingSystems</code> request.</p>', ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'DescribeStackProvisioningParametersResult$Parameters' => '<p>An embedded object that contains the provisioning parameters.</p>', ], ], 'Permission' => [ 'base' => '<p>Describes stack or user permissions.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'DescribePermissionsResult$Permissions' => '<p>An array of <code>Permission</code> objects that describe the stack permissions.</p> <ul> <li> <p>If the request object contains only a stack ID, the array contains a <code>Permission</code> object with permissions for each of the stack IAM ARNs.</p> </li> <li> <p>If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with permissions for each of the user\'s stack IDs.</p> </li> <li> <p>If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object with permissions for the specified stack and IAM ARN.</p> </li> </ul>', ], ], 'RaidArray' => [ 'base' => '<p>Describes an instance\'s RAID array.</p>', 'refs' => [ 'RaidArrays$member' => NULL, ], ], 'RaidArrays' => [ 'base' => NULL, 'refs' => [ 'DescribeRaidArraysResult$RaidArrays' => '<p>A <code>RaidArrays</code> object that describes the specified RAID arrays.</p>', ], ], 'RdsDbInstance' => [ 'base' => '<p>Describes an Amazon RDS instance.</p>', 'refs' => [ 'RdsDbInstances$member' => NULL, ], ], 'RdsDbInstances' => [ 'base' => NULL, 'refs' => [ 'DescribeRdsDbInstancesResult$RdsDbInstances' => '<p>An a array of <code>RdsDbInstance</code> objects that describe the instances.</p>', ], ], 'RebootInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Recipes' => [ 'base' => '<p>OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for each event. In addition, you can provide custom recipes for any or all layers and events. OpsWorks Stacks runs custom event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of the five events. </p> <p>To specify a recipe, use the cookbook\'s directory name in the repository followed by two colons and the recipe name, which is the recipe\'s file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb recipe in the repository\'s phpapp2 folder.</p>', 'refs' => [ 'CreateLayerRequest$CustomRecipes' => '<p>A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.</p>', 'Layer$DefaultRecipes' => '<p>OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>, <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for each event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks runs custom event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular layer to be run in response to each of the five events.</p> <p>To specify a recipe, use the cookbook\'s directory name in the repository followed by two colons and the recipe name, which is the recipe\'s file name without the <code>.rb</code> extension. For example: <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository\'s <code>phpapp2</code> folder.</p>', 'Layer$CustomRecipes' => '<p>A <code>LayerCustomRecipes</code> object that specifies the layer\'s custom recipes.</p>', 'UpdateLayerRequest$CustomRecipes' => '<p>A <code>LayerCustomRecipes</code> object that specifies the layer\'s custom recipes.</p>', ], ], 'RegisterEcsClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterEcsClusterResult' => [ 'base' => '<p>Contains the response to a <code>RegisterEcsCluster</code> request.</p>', 'refs' => [], ], 'RegisterElasticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterElasticIpResult' => [ 'base' => '<p>Contains the response to a <code>RegisterElasticIp</code> request.</p>', 'refs' => [], ], 'RegisterInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterInstanceResult' => [ 'base' => '<p>Contains the response to a <code>RegisterInstanceResult</code> request.</p>', 'refs' => [], ], 'RegisterRdsDbInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterVolumeResult' => [ 'base' => '<p>Contains the response to a <code>RegisterVolume</code> request.</p>', 'refs' => [], ], 'ReportedOs' => [ 'base' => '<p>A registered instance\'s reported operating system.</p>', 'refs' => [ 'Instance$ReportedOs' => '<p>For registered instances, the reported operating system.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$ResourceArn' => '<p>The stack or layer\'s Amazon Resource Number (ARN).</p>', 'TagResourceRequest$ResourceArn' => '<p>The stack or layer\'s Amazon Resource Number (ARN).</p>', 'UntagResourceRequest$ResourceArn' => '<p>The stack or layer\'s Amazon Resource Number (ARN).</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Indicates that a resource was not found.</p>', 'refs' => [], ], 'RootDeviceType' => [ 'base' => NULL, 'refs' => [ 'CloneStackRequest$DefaultRootDeviceType' => '<p>The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>', 'CreateInstanceRequest$RootDeviceType' => '<p>The instance root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>', 'CreateStackRequest$DefaultRootDeviceType' => '<p>The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>', 'Instance$RootDeviceType' => '<p>The instance\'s root device type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>', 'Stack$DefaultRootDeviceType' => '<p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>. </p>', 'UpdateStackRequest$DefaultRootDeviceType' => '<p>The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a>.</p>', ], ], 'SelfUserProfile' => [ 'base' => '<p>Describes a user\'s SSH information.</p>', 'refs' => [ 'DescribeMyUserProfileResult$UserProfile' => '<p>A <code>UserProfile</code> object that describes the user\'s SSH information.</p>', ], ], 'ServiceError' => [ 'base' => '<p>Describes an OpsWorks Stacks service error.</p>', 'refs' => [ 'ServiceErrors$member' => NULL, ], ], 'ServiceErrors' => [ 'base' => NULL, 'refs' => [ 'DescribeServiceErrorsResult$ServiceErrors' => '<p>An array of <code>ServiceError</code> objects that describe the specified service errors.</p>', ], ], 'SetLoadBasedAutoScalingRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetTimeBasedAutoScalingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ShutdownEventConfiguration' => [ 'base' => '<p>The Shutdown event configuration.</p>', 'refs' => [ 'LifecycleEventConfiguration$Shutdown' => '<p>A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.</p>', ], ], 'Source' => [ 'base' => '<p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Creating Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Custom Recipes and Cookbooks</a>.</p>', 'refs' => [ 'App$AppSource' => '<p>A <code>Source</code> object that describes the app repository.</p>', 'CloneStackRequest$CustomCookbooksSource' => '<p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>', 'CreateAppRequest$AppSource' => '<p>A <code>Source</code> object that specifies the app repository.</p>', 'CreateStackRequest$CustomCookbooksSource' => '<p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>', 'Stack$CustomCookbooksSource' => '<p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>', 'UpdateAppRequest$AppSource' => '<p>A <code>Source</code> object that specifies the app repository.</p>', 'UpdateStackRequest$CustomCookbooksSource' => '<p>Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a>.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'Source$Type' => '<p>The repository type.</p>', ], ], 'SslConfiguration' => [ 'base' => '<p>Describes an app\'s SSL configuration.</p>', 'refs' => [ 'App$SslConfiguration' => '<p>An <code>SslConfiguration</code> object with the SSL configuration.</p>', 'CreateAppRequest$SslConfiguration' => '<p>An <code>SslConfiguration</code> object with the SSL configuration.</p>', 'UpdateAppRequest$SslConfiguration' => '<p>An <code>SslConfiguration</code> object with the SSL configuration.</p>', ], ], 'Stack' => [ 'base' => '<p>Describes a stack.</p>', 'refs' => [ 'Stacks$member' => NULL, ], ], 'StackAttributes' => [ 'base' => NULL, 'refs' => [ 'CloneStackRequest$Attributes' => '<p>A list of stack attributes and values as key/value pairs to be added to the cloned stack.</p>', 'CreateStackRequest$Attributes' => '<p>One or more user-defined key-value pairs to be added to the stack attributes.</p>', 'Stack$Attributes' => '<p>The stack\'s attributes.</p>', 'UpdateStackRequest$Attributes' => '<p>One or more user-defined key-value pairs to be added to the stack attributes.</p>', ], ], 'StackAttributesKeys' => [ 'base' => NULL, 'refs' => [ 'StackAttributes$key' => NULL, ], ], 'StackConfigurationManager' => [ 'base' => '<p>Describes the configuration manager.</p>', 'refs' => [ 'AgentVersion$ConfigurationManager' => '<p>The configuration manager.</p>', 'CloneStackRequest$ConfigurationManager' => '<p>The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>', 'CreateStackRequest$ConfigurationManager' => '<p>The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>', 'DescribeAgentVersionsRequest$ConfigurationManager' => '<p>The configuration manager.</p>', 'Stack$ConfigurationManager' => '<p>The configuration manager.</p>', 'UpdateStackRequest$ConfigurationManager' => '<p>The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.</p>', ], ], 'StackSummary' => [ 'base' => '<p>Summarizes the number of layers, instances, and apps in a stack.</p>', 'refs' => [ 'DescribeStackSummaryResult$StackSummary' => '<p>A <code>StackSummary</code> object that contains the results.</p>', ], ], 'Stacks' => [ 'base' => NULL, 'refs' => [ 'DescribeStacksResult$Stacks' => '<p>An array of <code>Stack</code> objects that describe the stacks.</p>', ], ], 'StartInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$Version' => '<p>The agent version.</p>', 'App$AppId' => '<p>The app ID.</p>', 'App$StackId' => '<p>The app stack ID.</p>', 'App$Shortname' => '<p>The app\'s short name.</p>', 'App$Name' => '<p>The app name.</p>', 'App$Description' => '<p>A description of the app.</p>', 'App$CreatedAt' => '<p>When the app was created.</p>', 'AppAttributes$value' => NULL, 'AssignInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'AssignVolumeRequest$VolumeId' => '<p>The volume ID.</p>', 'AssignVolumeRequest$InstanceId' => '<p>The instance ID.</p>', 'AssociateElasticIpRequest$ElasticIp' => '<p>The Elastic IP address.</p>', 'AssociateElasticIpRequest$InstanceId' => '<p>The instance ID.</p>', 'AttachElasticLoadBalancerRequest$ElasticLoadBalancerName' => '<p>The Elastic Load Balancing instance\'s name.</p>', 'AttachElasticLoadBalancerRequest$LayerId' => '<p>The ID of the layer to which the Elastic Load Balancing instance is to be attached.</p>', 'BlockDeviceMapping$DeviceName' => '<p>The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you can use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and OpsWorks Stacks will provide the correct device name.</p>', 'BlockDeviceMapping$NoDevice' => '<p>Suppresses the specified device included in the AMI\'s block device mapping.</p>', 'BlockDeviceMapping$VirtualName' => '<p>The virtual device name. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.</p>', 'ChefConfiguration$BerkshelfVersion' => '<p>The Berkshelf version.</p>', 'CloneStackRequest$SourceStackId' => '<p>The source stack ID.</p>', 'CloneStackRequest$Name' => '<p>The cloned stack name. Stack names can be a maximum of 64 characters.</p>', 'CloneStackRequest$Region' => '<p>The cloned stack Amazon Web Services Region, such as <code>ap-northeast-2</code>. For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'CloneStackRequest$VpcId' => '<p>The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.</p> <ul> <li> <p>If your account supports EC2 Classic, the default value is no VPC.</p> </li> <li> <p>If your account does not support EC2 Classic, the default value is the default VPC for the specified region.</p> </li> </ul> <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. </p> <p>If you specify a nondefault VPC ID, note the following:</p> <ul> <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li> <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li> </ul> <p>For more information about how to use OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2 Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>', 'CloneStackRequest$ServiceRoleArn' => '<p>The stack Identity and Access Management (IAM) role, which allows OpsWorks Stacks to work with Amazon Web Services resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the OpsWorkss Stacks console, it creates the role for you. You can obtain an existing stack\'s IAM ARN programmatically by calling <a>DescribePermissions</a>. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p> <note> <p>You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack\'s service role ARN, if you prefer, but you must do so explicitly.</p> </note>', 'CloneStackRequest$DefaultInstanceProfileArn' => '<p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'CloneStackRequest$DefaultOs' => '<p>The stack\'s operating system, which must be set to one of the following.</p> <ul> <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>, <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li> <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li> <li> <p> <code>CentOS Linux 7</code> </p> </li> <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li> <li> <p> <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li> <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li> </ul> <p>The default option is the parent stack\'s operating system. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating Systems</a>.</p> <note> <p>You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.</p> </note>', 'CloneStackRequest$HostnameTheme' => '<p>The stack\'s host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack\'s instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer\'s short name. The other themes are:</p> <ul> <li> <p> <code>Baked_Goods</code> </p> </li> <li> <p> <code>Clouds</code> </p> </li> <li> <p> <code>Europe_Cities</code> </p> </li> <li> <p> <code>Fruits</code> </p> </li> <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li> <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li> <li> <p> <code>Planets_and_Moons</code> </p> </li> <li> <p> <code>Roman_Deities</code> </p> </li> <li> <p> <code>Scottish_Islands</code> </p> </li> <li> <p> <code>US_Cities</code> </p> </li> <li> <p> <code>Wild_Cats</code> </p> </li> </ul> <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>', 'CloneStackRequest$DefaultAvailabilityZone' => '<p>The cloned stack\'s default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>', 'CloneStackRequest$DefaultSubnetId' => '<p>The stack\'s default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>', 'CloneStackRequest$CustomJson' => '<p>A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> </p>', 'CloneStackRequest$DefaultSshKeyName' => '<p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>', 'CloneStackRequest$AgentVersion' => '<p>The default OpsWorks Stacks agent version. You have the following options:</p> <ul> <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. OpsWorks Stacks automatically installs new agent versions on the stack\'s instances as soon as they are available.</p> </li> <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. OpsWorks Stacks automatically installs that version on the stack\'s instances.</p> </li> </ul> <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.</p> <note> <p>You can also specify an agent version when you create or update an instance, which overrides the stack\'s default setting.</p> </note>', 'CloneStackResult$StackId' => '<p>The cloned stack ID.</p>', 'CloudWatchLogsLogStream$LogGroupName' => '<p>Specifies the destination log group. A log group is created automatically if it doesn\'t already exist. Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, \'_\' (underscore), \'-\' (hyphen), \'/\' (forward slash), and \'.\' (period).</p>', 'CloudWatchLogsLogStream$DatetimeFormat' => '<p>Specifies how the time stamp is extracted from logs. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent Reference</a>.</p>', 'CloudWatchLogsLogStream$File' => '<p>Specifies log files that you want to push to CloudWatch Logs.</p> <p> <code>File</code> can point to a specific file or multiple files (by using wild card characters such as <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series of files of the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on by using a pattern like <code>access_log.*</code>. Don\'t use a wildcard to match multiple file types, such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add another log stream entry to the configuration file, so that each log file type is stored in a different log group.</p> <p>Zipped files are not supported.</p>', 'CloudWatchLogsLogStream$FileFingerprintLines' => '<p>Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as \'1\', \'2-5\'. The default value is \'1\', meaning the first line is used to calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.</p>', 'CloudWatchLogsLogStream$MultiLineStartPattern' => '<p>Specifies the pattern for identifying the start of a log message.</p>', 'Command$CommandId' => '<p>The command ID.</p>', 'Command$InstanceId' => '<p>The ID of the instance where the command was executed.</p>', 'Command$DeploymentId' => '<p>The command deployment ID.</p>', 'Command$Status' => '<p>The command status:</p> <ul> <li> <p>failed</p> </li> <li> <p>successful</p> </li> <li> <p>skipped</p> </li> <li> <p>pending</p> </li> </ul>', 'Command$LogUrl' => '<p>The URL of the command log.</p>', 'Command$Type' => '<p>The command type:</p> <ul> <li> <p> <code>configure</code> </p> </li> <li> <p> <code>deploy</code> </p> </li> <li> <p> <code>execute_recipes</code> </p> </li> <li> <p> <code>install_dependencies</code> </p> </li> <li> <p> <code>restart</code> </p> </li> <li> <p> <code>rollback</code> </p> </li> <li> <p> <code>setup</code> </p> </li> <li> <p> <code>start</code> </p> </li> <li> <p> <code>stop</code> </p> </li> <li> <p> <code>undeploy</code> </p> </li> <li> <p> <code>update_custom_cookbooks</code> </p> </li> <li> <p> <code>update_dependencies</code> </p> </li> </ul>', 'CreateAppRequest$StackId' => '<p>The stack ID.</p>', 'CreateAppRequest$Shortname' => '<p>The app\'s short name.</p>', 'CreateAppRequest$Name' => '<p>The app name.</p>', 'CreateAppRequest$Description' => '<p>A description of the app.</p>', 'CreateAppResult$AppId' => '<p>The app ID.</p>', 'CreateDeploymentRequest$StackId' => '<p>The stack ID.</p>', 'CreateDeploymentRequest$AppId' => '<p>The app ID. This parameter is required for app deployments, but not for other deployment commands.</p>', 'CreateDeploymentRequest$Comment' => '<p>A user-defined comment.</p>', 'CreateDeploymentRequest$CustomJson' => '<p>A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html">Overriding Attributes With Custom JSON</a>.</p>', 'CreateDeploymentResult$DeploymentId' => '<p>The deployment ID, which can be used with other requests to identify the deployment.</p>', 'CreateInstanceRequest$StackId' => '<p>The stack ID.</p>', 'CreateInstanceRequest$InstanceType' => '<p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>', 'CreateInstanceRequest$Hostname' => '<p>The instance host name. The following are character limits for instance host names.</p> <ul> <li> <p>Linux-based instances: 63 characters</p> </li> <li> <p>Windows-based instances: 15 characters</p> </li> </ul>', 'CreateInstanceRequest$Os' => '<p>The instance\'s operating system, which must be set to one of the following.</p> <ul> <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>, <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li> <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li> <li> <p> <code>CentOS Linux 7</code> </p> </li> <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li> <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li> <li> <p>A custom AMI: <code>Custom</code>.</p> </li> </ul> <p>Not all operating systems are supported with all versions of Chef. For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating Systems</a>.</p> <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the <a>CreateInstance</a> action\'s AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information about how to use custom AMIs with OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p>', 'CreateInstanceRequest$AmiId' => '<p>A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note> <p>If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.</p> </note>', 'CreateInstanceRequest$SshKeyName' => '<p>The instance\'s Amazon EC2 key-pair name.</p>', 'CreateInstanceRequest$AvailabilityZone' => '<p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'CreateInstanceRequest$VirtualizationType' => '<p>The instance\'s virtualization type, <code>paravirtual</code> or <code>hvm</code>.</p>', 'CreateInstanceRequest$SubnetId' => '<p>The ID of the instance\'s subnet. If the stack is running in a VPC, you can use this parameter to override the stack\'s default subnet ID value and direct OpsWorks Stacks to launch the instance in a different subnet.</p>', 'CreateInstanceRequest$AgentVersion' => '<p>The default OpsWorks Stacks agent version. You have the following options:</p> <ul> <li> <p> <code>INHERIT</code> - Use the stack\'s default agent version setting.</p> </li> <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack\'s default setting. To update the agent version, edit the instance configuration and specify a new version. OpsWorks Stacks installs that version on the instance.</p> </li> </ul> <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.</p>', 'CreateInstanceRequest$Tenancy' => '<p>The instance\'s tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.</p>', 'CreateInstanceResult$InstanceId' => '<p>The instance ID.</p>', 'CreateLayerRequest$StackId' => '<p>The layer stack ID.</p>', 'CreateLayerRequest$Name' => '<p>The layer name, which is used by the console. Layer names can be a maximum of 32 characters.</p>', 'CreateLayerRequest$Shortname' => '<p>For custom layers only, use this parameter to specify the layer\'s short name, which is used internally by OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters, which are limited to the alphanumeric characters, \'-\', \'_\', and \'.\'.</p> <p>Built-in layer short names are defined by OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.</p>', 'CreateLayerRequest$CustomInstanceProfileArn' => '<p>The ARN of an IAM profile to be used for the layer\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'CreateLayerRequest$CustomJson' => '<p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. This feature is supported as of version 1.7.42 of the CLI. </p>', 'CreateLayerResult$LayerId' => '<p>The layer ID.</p>', 'CreateStackRequest$Name' => '<p>The stack name. Stack names can be a maximum of 64 characters.</p>', 'CreateStackRequest$Region' => '<p>The stack\'s Amazon Web Services Region, such as <code>ap-south-1</code>. For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <note> <p>In the CLI, this API maps to the <code>--stack-region</code> parameter. If the <code>--stack-region</code> parameter and the CLI common parameter <code>--region</code> are set to the same value, the stack uses a <i>regional</i> endpoint. If the <code>--stack-region</code> parameter is not set, but the CLI <code>--region</code> parameter is, this also results in a stack with a <i>regional</i> endpoint. However, if the <code>--region</code> parameter is set to <code>us-east-1</code>, and the <code>--stack-region</code> parameter is set to one of the following, then the stack uses a legacy or <i>classic</i> region: <code>us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2</code>. In this case, the actual API endpoint of the stack is in <code>us-east-1</code>. Only the preceding regions are supported as classic regions in the <code>us-east-1</code> API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage Amazon Web Services, we recommend that you use regional endpoints for new stacks. The CLI common <code>--region</code> parameter always specifies a regional API endpoint; it cannot be used to specify a classic OpsWorks Stacks region.</p> </note>', 'CreateStackRequest$VpcId' => '<p>The ID of the VPC that the stack is to be launched into. The VPC must be in the stack\'s region. All instances are launched into this VPC. You cannot change the ID later.</p> <ul> <li> <p>If your account supports EC2-Classic, the default value is <code>no VPC</code>.</p> </li> <li> <p>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</p> </li> </ul> <p>If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.</p> <p>If you specify a nondefault VPC ID, note the following:</p> <ul> <li> <p>It must belong to a VPC in your account that is in the specified region.</p> </li> <li> <p>You must specify a value for <code>DefaultSubnetId</code>.</p> </li> </ul> <p>For more information about how to use OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>. For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>. </p>', 'CreateStackRequest$ServiceRoleArn' => '<p>The stack\'s IAM role, which allows OpsWorks Stacks to work with Amazon Web Services resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'CreateStackRequest$DefaultInstanceProfileArn' => '<p>The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'CreateStackRequest$DefaultOs' => '<p>The stack\'s default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.</p> <ul> <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>, <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li> <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li> <li> <p> <code>CentOS Linux 7</code> </p> </li> <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li> <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li> <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom AMIs</a>.</p> </li> </ul> <p>The default option is the current Amazon Linux version. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating Systems</a>.</p>', 'CreateStackRequest$HostnameTheme' => '<p>The stack\'s host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack\'s instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer\'s short name. The other themes are:</p> <ul> <li> <p> <code>Baked_Goods</code> </p> </li> <li> <p> <code>Clouds</code> </p> </li> <li> <p> <code>Europe_Cities</code> </p> </li> <li> <p> <code>Fruits</code> </p> </li> <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li> <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li> <li> <p> <code>Planets_and_Moons</code> </p> </li> <li> <p> <code>Roman_Deities</code> </p> </li> <li> <p> <code>Scottish_Islands</code> </p> </li> <li> <p> <code>US_Cities</code> </p> </li> <li> <p> <code>Wild_Cats</code> </p> </li> </ul> <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>', 'CreateStackRequest$DefaultAvailabilityZone' => '<p>The stack\'s default Availability Zone, which must be in the specified region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description. </p>', 'CreateStackRequest$DefaultSubnetId' => '<p>The stack\'s default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>', 'CreateStackRequest$CustomJson' => '<p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>', 'CreateStackRequest$DefaultSshKeyName' => '<p>A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>', 'CreateStackRequest$AgentVersion' => '<p>The default OpsWorks Stacks agent version. You have the following options:</p> <ul> <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. OpsWorks Stacks automatically installs new agent versions on the stack\'s instances as soon as they are available.</p> </li> <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. OpsWorks Stacks installs that version on the stack\'s instances.</p> </li> </ul> <p>The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.</p> <note> <p>You can also specify an agent version when you create or update an instance, which overrides the stack\'s default setting.</p> </note>', 'CreateStackResult$StackId' => '<p>The stack ID, which is an opaque string that you use to identify the stack when performing actions such as <code>DescribeStacks</code>.</p>', 'CreateUserProfileRequest$IamUserArn' => '<p>The user\'s IAM ARN; this can also be a federated user\'s ARN.</p>', 'CreateUserProfileRequest$SshUsername' => '<p>The user\'s SSH user name. The allowable characters are [a-z], [A-Z], [0-9], \'-\', and \'_\'. If the specified name includes other punctuation marks, OpsWorks Stacks removes them. For example, <code>my.name</code> is changed to <code>myname</code>. If you do not specify an SSH user name, OpsWorks Stacks generates one from the IAM user name. </p>', 'CreateUserProfileRequest$SshPublicKey' => '<p>The user\'s public SSH key.</p>', 'CreateUserProfileResult$IamUserArn' => '<p>The user\'s IAM ARN.</p>', 'DataSource$Type' => '<p>The data source\'s type, <code>AutoSelectOpsworksMysqlInstance</code>, <code>OpsworksMysqlInstance</code>, <code>RdsDbInstance</code>, or <code>None</code>.</p>', 'DataSource$Arn' => '<p>The data source\'s ARN.</p>', 'DataSource$DatabaseName' => '<p>The database name.</p>', 'DeleteAppRequest$AppId' => '<p>The app ID.</p>', 'DeleteInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'DeleteLayerRequest$LayerId' => '<p>The layer ID.</p>', 'DeleteStackRequest$StackId' => '<p>The stack ID.</p>', 'DeleteUserProfileRequest$IamUserArn' => '<p>The user\'s IAM ARN. This can also be a federated user\'s ARN.</p>', 'Deployment$DeploymentId' => '<p>The deployment ID.</p>', 'Deployment$StackId' => '<p>The stack ID.</p>', 'Deployment$AppId' => '<p>The app ID.</p>', 'Deployment$IamUserArn' => '<p>The user\'s IAM ARN.</p>', 'Deployment$Comment' => '<p>A user-defined comment.</p>', 'Deployment$Status' => '<p>The deployment status:</p> <ul> <li> <p>running</p> </li> <li> <p>successful</p> </li> <li> <p>failed</p> </li> </ul>', 'Deployment$CustomJson' => '<p>A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>', 'DeploymentCommandArgs$key' => NULL, 'DeregisterEcsClusterRequest$EcsClusterArn' => '<p>The cluster\'s Amazon Resource Number (ARN).</p>', 'DeregisterElasticIpRequest$ElasticIp' => '<p>The Elastic IP address.</p>', 'DeregisterInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'DeregisterRdsDbInstanceRequest$RdsDbInstanceArn' => '<p>The Amazon RDS instance\'s ARN.</p>', 'DeregisterVolumeRequest$VolumeId' => '<p>The OpsWorks Stacks volume ID, which is the GUID that OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.</p>', 'DescribeAgentVersionsRequest$StackId' => '<p>The stack ID.</p>', 'DescribeAppsRequest$StackId' => '<p>The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the specified stack.</p>', 'DescribeCommandsRequest$DeploymentId' => '<p>The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified deployment.</p>', 'DescribeCommandsRequest$InstanceId' => '<p>The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the commands associated with the specified instance.</p>', 'DescribeDeploymentsRequest$StackId' => '<p>The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack.</p>', 'DescribeDeploymentsRequest$AppId' => '<p>The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app.</p>', 'DescribeEcsClustersRequest$StackId' => '<p>A stack ID. <code>DescribeEcsClusters</code> returns a description of the cluster that is registered with the stack.</p>', 'DescribeEcsClustersRequest$NextToken' => '<p>If the previous paginated request did not return all of the remaining results, the response object\'s<code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>DescribeEcsClusters</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'DescribeEcsClustersResult$NextToken' => '<p>If a paginated request does not return all of the remaining results, this parameter is set to a token that you can assign to the request object\'s <code>NextToken</code> parameter to retrieve the next set of results. If the previous paginated request returned all of the remaining results, this parameter is set to <code>null</code>.</p>', 'DescribeElasticIpsRequest$InstanceId' => '<p>The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses associated with the specified instance.</p>', 'DescribeElasticIpsRequest$StackId' => '<p>A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic IP addresses that are registered with the specified stack.</p>', 'DescribeElasticLoadBalancersRequest$StackId' => '<p>A stack ID. The action describes the stack\'s Elastic Load Balancing instances.</p>', 'DescribeInstancesRequest$StackId' => '<p>A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified stack.</p>', 'DescribeInstancesRequest$LayerId' => '<p>A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances associated with the specified layer.</p>', 'DescribeLayersRequest$StackId' => '<p>The stack ID.</p>', 'DescribePermissionsRequest$IamUserArn' => '<p>The user\'s IAM ARN. This can also be a federated user\'s ARN. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'DescribePermissionsRequest$StackId' => '<p>The stack ID.</p>', 'DescribeRaidArraysRequest$InstanceId' => '<p>The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID arrays associated with the specified instance. </p>', 'DescribeRaidArraysRequest$StackId' => '<p>The stack ID.</p>', 'DescribeRdsDbInstancesRequest$StackId' => '<p>The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.</p>', 'DescribeServiceErrorsRequest$StackId' => '<p>The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified stack.</p>', 'DescribeServiceErrorsRequest$InstanceId' => '<p>The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors associated with the specified instance.</p>', 'DescribeStackProvisioningParametersRequest$StackId' => '<p>The stack ID.</p>', 'DescribeStackProvisioningParametersResult$AgentInstallerUrl' => '<p>The OpsWorks Stacks agent installer\'s URL.</p>', 'DescribeStackSummaryRequest$StackId' => '<p>The stack ID.</p>', 'DescribeVolumesRequest$InstanceId' => '<p>The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified instance.</p>', 'DescribeVolumesRequest$StackId' => '<p>A stack ID. The action describes the stack\'s registered Amazon EBS volumes.</p>', 'DescribeVolumesRequest$RaidArrayId' => '<p>The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes associated with the specified RAID array.</p>', 'DetachElasticLoadBalancerRequest$ElasticLoadBalancerName' => '<p>The Elastic Load Balancing instance\'s name.</p>', 'DetachElasticLoadBalancerRequest$LayerId' => '<p>The ID of the layer that the Elastic Load Balancing instance is attached to.</p>', 'DisassociateElasticIpRequest$ElasticIp' => '<p>The Elastic IP address.</p>', 'EbsBlockDevice$SnapshotId' => '<p>The snapshot ID.</p>', 'EcsCluster$EcsClusterArn' => '<p>The cluster\'s ARN.</p>', 'EcsCluster$EcsClusterName' => '<p>The cluster name.</p>', 'EcsCluster$StackId' => '<p>The stack ID.</p>', 'ElasticIp$Ip' => '<p>The IP address.</p>', 'ElasticIp$Name' => '<p>The name, which can be a maximum of 32 characters.</p>', 'ElasticIp$Domain' => '<p>The domain.</p>', 'ElasticIp$Region' => '<p>The Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'ElasticIp$InstanceId' => '<p>The ID of the instance that the address is attached to.</p>', 'ElasticLoadBalancer$ElasticLoadBalancerName' => '<p>The Elastic Load Balancing instance name.</p>', 'ElasticLoadBalancer$Region' => '<p>The instance\'s Amazon Web Services Region.</p>', 'ElasticLoadBalancer$DnsName' => '<p>The instance\'s public DNS name.</p>', 'ElasticLoadBalancer$StackId' => '<p>The ID of the stack with which the instance is associated.</p>', 'ElasticLoadBalancer$LayerId' => '<p>The ID of the layer to which the instance is attached.</p>', 'ElasticLoadBalancer$VpcId' => '<p>The VPC ID.</p>', 'EnvironmentVariable$Key' => '<p>(Required) The environment variable\'s name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.</p>', 'EnvironmentVariable$Value' => '<p>(Optional) The environment variable\'s value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.</p>', 'GetHostnameSuggestionRequest$LayerId' => '<p>The layer ID.</p>', 'GetHostnameSuggestionResult$LayerId' => '<p>The layer ID.</p>', 'GetHostnameSuggestionResult$Hostname' => '<p>The generated host name.</p>', 'GrantAccessRequest$InstanceId' => '<p>The instance\'s OpsWorks Stacks ID.</p>', 'Instance$AgentVersion' => '<p>The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default stack setting or to a a version number for a fixed agent version.</p>', 'Instance$AmiId' => '<p>A custom AMI ID to be used to create the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a> </p>', 'Instance$Arn' => '<p>The instance\'s Amazon Resource Number (ARN).</p>', 'Instance$AvailabilityZone' => '<p>The instance Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'Instance$Ec2InstanceId' => '<p>The ID of the associated Amazon EC2 instance.</p>', 'Instance$EcsClusterArn' => '<p>For container instances, the Amazon ECS cluster\'s ARN.</p>', 'Instance$EcsContainerInstanceArn' => '<p>For container instances, the instance\'s ARN.</p>', 'Instance$ElasticIp' => '<p>The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a>.</p>', 'Instance$Hostname' => '<p>The instance host name. The following are character limits for instance host names.</p> <ul> <li> <p>Linux-based instances: 63 characters</p> </li> <li> <p>Windows-based instances: 15 characters</p> </li> </ul>', 'Instance$InfrastructureClass' => '<p>For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.</p>', 'Instance$InstanceId' => '<p>The instance ID.</p>', 'Instance$InstanceProfileArn' => '<p>The ARN of the instance\'s IAM profile. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'Instance$InstanceType' => '<p>The instance type, such as <code>t2.micro</code>.</p>', 'Instance$LastServiceErrorId' => '<p>The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.</p>', 'Instance$Os' => '<p>The instance\'s operating system.</p>', 'Instance$Platform' => '<p>The instance\'s platform.</p>', 'Instance$PrivateDns' => '<p>The instance\'s private DNS name.</p>', 'Instance$PrivateIp' => '<p>The instance\'s private IP address.</p>', 'Instance$PublicDns' => '<p>The instance public DNS name.</p>', 'Instance$PublicIp' => '<p>The instance public IP address.</p>', 'Instance$RegisteredBy' => '<p>For registered instances, who performed the registration.</p>', 'Instance$ReportedAgentVersion' => '<p>The instance\'s reported OpsWorks Stacks agent version.</p>', 'Instance$RootDeviceVolumeId' => '<p>The root device volume ID.</p>', 'Instance$SshHostDsaKeyFingerprint' => '<p>The SSH key\'s Deep Security Agent (DSA) fingerprint.</p>', 'Instance$SshHostRsaKeyFingerprint' => '<p>The SSH key\'s RSA fingerprint.</p>', 'Instance$SshKeyName' => '<p>The instance\'s Amazon EC2 key-pair name.</p>', 'Instance$StackId' => '<p>The stack ID.</p>', 'Instance$Status' => '<p>The instance status:</p> <ul> <li> <p> <code>booting</code> </p> </li> <li> <p> <code>connection_lost</code> </p> </li> <li> <p> <code>online</code> </p> </li> <li> <p> <code>pending</code> </p> </li> <li> <p> <code>rebooting</code> </p> </li> <li> <p> <code>requested</code> </p> </li> <li> <p> <code>running_setup</code> </p> </li> <li> <p> <code>setup_failed</code> </p> </li> <li> <p> <code>shutting_down</code> </p> </li> <li> <p> <code>start_failed</code> </p> </li> <li> <p> <code>stop_failed</code> </p> </li> <li> <p> <code>stopped</code> </p> </li> <li> <p> <code>stopping</code> </p> </li> <li> <p> <code>terminated</code> </p> </li> <li> <p> <code>terminating</code> </p> </li> </ul>', 'Instance$SubnetId' => '<p>The instance\'s subnet ID; applicable only if the stack is running in a VPC.</p>', 'Instance$Tenancy' => '<p>The instance\'s tenancy option, such as <code>dedicated</code> or <code>host</code>.</p>', 'InstanceIdentity$Document' => '<p>A JSON document that contains the metadata.</p>', 'InstanceIdentity$Signature' => '<p>A signature that can be used to verify the document\'s accuracy and authenticity.</p>', 'Layer$Arn' => '<p>The Amazon Resource Number (ARN) of a layer.</p>', 'Layer$StackId' => '<p>The layer stack ID.</p>', 'Layer$LayerId' => '<p>The layer ID.</p>', 'Layer$Name' => '<p>The layer name. Layer names can be a maximum of 32 characters.</p>', 'Layer$Shortname' => '<p>The layer short name.</p>', 'Layer$CustomInstanceProfileArn' => '<p>The ARN of the default IAM profile to be used for the layer\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'Layer$CustomJson' => '<p>A JSON formatted string containing the layer\'s custom stack configuration and deployment attributes.</p>', 'LayerAttributes$value' => NULL, 'LoadBasedAutoScalingConfiguration$LayerId' => '<p>The layer ID.</p>', 'OperatingSystem$Name' => '<p>The name of the operating system, such as <code>Amazon Linux 2</code>.</p>', 'OperatingSystem$Id' => '<p>The ID of a supported operating system, such as <code>Amazon Linux 2</code>.</p>', 'OperatingSystem$Type' => '<p>The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.</p>', 'OperatingSystem$ReportedName' => '<p>A short name for the operating system manufacturer.</p>', 'OperatingSystem$ReportedVersion' => '<p>The version of the operating system, including the release and edition, if applicable.</p>', 'OperatingSystemConfigurationManager$Name' => '<p>The name of the configuration manager, which is Chef.</p>', 'OperatingSystemConfigurationManager$Version' => '<p>The versions of the configuration manager that are supported by an operating system.</p>', 'Parameters$key' => NULL, 'Parameters$value' => NULL, 'Permission$StackId' => '<p>A stack ID.</p>', 'Permission$IamUserArn' => '<p>The Amazon Resource Name (ARN) for an Identity and Access Management (IAM) role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'Permission$Level' => '<p>The user\'s permission level, which must be the following:</p> <ul> <li> <p> <code>deny</code> </p> </li> <li> <p> <code>show</code> </p> </li> <li> <p> <code>deploy</code> </p> </li> <li> <p> <code>manage</code> </p> </li> <li> <p> <code>iam_only</code> </p> </li> </ul> <p>For more information on the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a> </p>', 'RaidArray$RaidArrayId' => '<p>The array ID.</p>', 'RaidArray$InstanceId' => '<p>The instance ID.</p>', 'RaidArray$Name' => '<p>The array name.</p>', 'RaidArray$Device' => '<p>The array\'s Linux device. For example /dev/mdadm0.</p>', 'RaidArray$MountPoint' => '<p>The array\'s mount point.</p>', 'RaidArray$AvailabilityZone' => '<p>The array\'s Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'RaidArray$StackId' => '<p>The stack ID.</p>', 'RaidArray$VolumeType' => '<p>The volume type, standard or PIOPS.</p>', 'RdsDbInstance$RdsDbInstanceArn' => '<p>The instance\'s ARN.</p>', 'RdsDbInstance$DbInstanceIdentifier' => '<p>The database instance identifier.</p>', 'RdsDbInstance$DbUser' => '<p>The master user name.</p>', 'RdsDbInstance$DbPassword' => '<p>OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>', 'RdsDbInstance$Region' => '<p>The instance\'s Amazon Web Services Region.</p>', 'RdsDbInstance$Address' => '<p>The instance\'s address.</p>', 'RdsDbInstance$Engine' => '<p>The instance\'s database engine.</p>', 'RdsDbInstance$StackId' => '<p>The ID of the stack with which the instance is registered.</p>', 'RebootInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'RegisterEcsClusterRequest$EcsClusterArn' => '<p>The cluster\'s ARN.</p>', 'RegisterEcsClusterRequest$StackId' => '<p>The stack ID.</p>', 'RegisterEcsClusterResult$EcsClusterArn' => '<p>The cluster\'s ARN.</p>', 'RegisterElasticIpRequest$ElasticIp' => '<p>The Elastic IP address.</p>', 'RegisterElasticIpRequest$StackId' => '<p>The stack ID.</p>', 'RegisterElasticIpResult$ElasticIp' => '<p>The Elastic IP address.</p>', 'RegisterInstanceRequest$StackId' => '<p>The ID of the stack that the instance is to be registered with.</p>', 'RegisterInstanceRequest$Hostname' => '<p>The instance\'s host name. The following are character limits for instance host names.</p> <ul> <li> <p>Linux-based instances: 63 characters</p> </li> <li> <p>Windows-based instances: 15 characters</p> </li> </ul>', 'RegisterInstanceRequest$PublicIp' => '<p>The instance\'s public IP address.</p>', 'RegisterInstanceRequest$PrivateIp' => '<p>The instance\'s private IP address.</p>', 'RegisterInstanceRequest$RsaPublicKey' => '<p>The instances public RSA key. This key is used to encrypt communication between the instance and the service.</p>', 'RegisterInstanceRequest$RsaPublicKeyFingerprint' => '<p>The instances public RSA key fingerprint.</p>', 'RegisterInstanceResult$InstanceId' => '<p>The registered instance\'s OpsWorks Stacks ID.</p>', 'RegisterRdsDbInstanceRequest$StackId' => '<p>The stack ID.</p>', 'RegisterRdsDbInstanceRequest$RdsDbInstanceArn' => '<p>The Amazon RDS instance\'s ARN.</p>', 'RegisterRdsDbInstanceRequest$DbUser' => '<p>The database\'s master user name.</p>', 'RegisterRdsDbInstanceRequest$DbPassword' => '<p>The database password.</p>', 'RegisterVolumeRequest$Ec2VolumeId' => '<p>The Amazon EBS volume ID.</p>', 'RegisterVolumeRequest$StackId' => '<p>The stack ID.</p>', 'RegisterVolumeResult$VolumeId' => '<p>The volume ID.</p>', 'ReportedOs$Family' => '<p>The operating system family.</p>', 'ReportedOs$Name' => '<p>The operating system name.</p>', 'ReportedOs$Version' => '<p>The operating system version.</p>', 'ResourceNotFoundException$message' => '<p>The exception message.</p>', 'SelfUserProfile$IamUserArn' => '<p>The user\'s IAM ARN.</p>', 'SelfUserProfile$Name' => '<p>The user\'s name.</p>', 'SelfUserProfile$SshUsername' => '<p>The user\'s SSH user name.</p>', 'SelfUserProfile$SshPublicKey' => '<p>The user\'s SSH public key.</p>', 'ServiceError$ServiceErrorId' => '<p>The error ID.</p>', 'ServiceError$StackId' => '<p>The stack ID.</p>', 'ServiceError$InstanceId' => '<p>The instance ID.</p>', 'ServiceError$Type' => '<p>The error type.</p>', 'ServiceError$Message' => '<p>A message that describes the error.</p>', 'SetLoadBasedAutoScalingRequest$LayerId' => '<p>The layer ID.</p>', 'SetPermissionRequest$StackId' => '<p>The stack ID.</p>', 'SetPermissionRequest$IamUserArn' => '<p>The user\'s IAM ARN. This can also be a federated user\'s ARN.</p>', 'SetPermissionRequest$Level' => '<p>The user\'s permission level, which must be set to one of the following strings. You cannot set your own permissions level.</p> <ul> <li> <p> <code>deny</code> </p> </li> <li> <p> <code>show</code> </p> </li> <li> <p> <code>deploy</code> </p> </li> <li> <p> <code>manage</code> </p> </li> <li> <p> <code>iam_only</code> </p> </li> </ul> <p>For more information about the permissions associated with these levels, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User Permissions</a>.</p>', 'SetTimeBasedAutoScalingRequest$InstanceId' => '<p>The instance ID.</p>', 'Source$Url' => '<p>The source URL. The following is an example of an Amazon S3 source URL: <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.</p>', 'Source$Username' => '<p>This parameter depends on the repository type.</p> <ul> <li> <p>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.</p> </li> <li> <p>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user name.</p> </li> </ul>', 'Source$Password' => '<p>When included in a request, the parameter depends on the repository type.</p> <ul> <li> <p>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.</p> </li> <li> <p>For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.</p> </li> </ul> <p>For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.</p> <p>In responses, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>', 'Source$SshKey' => '<p>In requests, the repository\'s SSH key.</p> <p>In responses, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.</p>', 'Source$Revision' => '<p>The application\'s version. OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.</p>', 'SslConfiguration$Certificate' => '<p>The contents of the certificate\'s domain.crt file.</p>', 'SslConfiguration$PrivateKey' => '<p>The private key; the contents of the certificate\'s domain.kex file.</p>', 'SslConfiguration$Chain' => '<p>Optional. Can be used to specify an intermediate certificate authority key or client authentication.</p>', 'Stack$StackId' => '<p>The stack ID.</p>', 'Stack$Name' => '<p>The stack name. Stack names can be a maximum of 64 characters.</p>', 'Stack$Arn' => '<p>The stack\'s ARN.</p>', 'Stack$Region' => '<p>The stack Amazon Web Services Region, such as <code>ap-northeast-2</code>. For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'Stack$VpcId' => '<p>The VPC ID; applicable only if the stack is running in a VPC.</p>', 'Stack$ServiceRoleArn' => '<p>The stack Identity and Access Management (IAM) role.</p>', 'Stack$DefaultInstanceProfileArn' => '<p>The ARN of an IAM profile that is the default profile for all of the stack\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'Stack$DefaultOs' => '<p>The stack\'s default operating system.</p>', 'Stack$HostnameTheme' => '<p>The stack host name theme, with spaces replaced by underscores.</p>', 'Stack$DefaultAvailabilityZone' => '<p>The stack\'s default Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'Stack$DefaultSubnetId' => '<p>The default subnet ID; applicable only if the stack is running in a VPC.</p>', 'Stack$CustomJson' => '<p>A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information on custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>', 'Stack$DefaultSshKeyName' => '<p>A default Amazon EC2 key pair for the stack\'s instances. You can override this value when you create or update an instance.</p>', 'Stack$AgentVersion' => '<p>The agent version. This parameter is set to <code>LATEST</code> for auto-update. or a version number for a fixed agent version.</p>', 'StackAttributes$value' => NULL, 'StackConfigurationManager$Name' => '<p>The name. This parameter must be set to <code>Chef</code>.</p>', 'StackConfigurationManager$Version' => '<p>The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 12.</p>', 'StackSummary$StackId' => '<p>The stack ID.</p>', 'StackSummary$Name' => '<p>The stack name.</p>', 'StackSummary$Arn' => '<p>The stack\'s ARN.</p>', 'StartInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'StartStackRequest$StackId' => '<p>The stack ID.</p>', 'StopInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'StopStackRequest$StackId' => '<p>The stack ID.</p>', 'Strings$member' => NULL, 'TemporaryCredential$Username' => '<p>The user name.</p>', 'TemporaryCredential$Password' => '<p>The password.</p>', 'TemporaryCredential$InstanceId' => '<p>The instance\'s OpsWorks Stacks ID.</p>', 'TimeBasedAutoScalingConfiguration$InstanceId' => '<p>The instance ID.</p>', 'UnassignInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'UnassignVolumeRequest$VolumeId' => '<p>The volume ID.</p>', 'UpdateAppRequest$AppId' => '<p>The app ID.</p>', 'UpdateAppRequest$Name' => '<p>The app name.</p>', 'UpdateAppRequest$Description' => '<p>A description of the app.</p>', 'UpdateElasticIpRequest$ElasticIp' => '<p>The IP address for which you want to update the name.</p>', 'UpdateElasticIpRequest$Name' => '<p>The new name, which can be a maximum of 32 characters.</p>', 'UpdateInstanceRequest$InstanceId' => '<p>The instance ID.</p>', 'UpdateInstanceRequest$InstanceType' => '<p>The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently supported types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column of the <b>Available Instance Types</b> table.</p>', 'UpdateInstanceRequest$Hostname' => '<p>The instance host name. The following are character limits for instance host names.</p> <ul> <li> <p>Linux-based instances: 63 characters</p> </li> <li> <p>Windows-based instances: 15 characters</p> </li> </ul>', 'UpdateInstanceRequest$Os' => '<p>The instance\'s operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.</p> <ul> <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>, <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li> <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li> <li> <p> <code>CentOS Linux 7</code> </p> </li> <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li> <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li> </ul> <p>Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating Systems</a>.</p> <p>The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> <note> <p>You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.</p> </note>', 'UpdateInstanceRequest$AmiId' => '<p>The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. </p>', 'UpdateInstanceRequest$SshKeyName' => '<p>The instance\'s Amazon EC2 key name.</p>', 'UpdateInstanceRequest$AgentVersion' => '<p>The default OpsWorks Stacks agent version. You have the following options:</p> <ul> <li> <p> <code>INHERIT</code> - Use the stack\'s default agent version setting.</p> </li> <li> <p> <i>version_number</i> - Use the specified agent version. This value overrides the stack\'s default setting. To update the agent version, you must edit the instance configuration and specify a new version. OpsWorks Stacks installs that version on the instance.</p> </li> </ul> <p>The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a>DescribeAgentVersions</a>.</p> <p>AgentVersion cannot be set to Chef 12.2.</p>', 'UpdateLayerRequest$LayerId' => '<p>The layer ID.</p>', 'UpdateLayerRequest$Name' => '<p>The layer name, which is used by the console. Layer names can be a maximum of 32 characters.</p>', 'UpdateLayerRequest$Shortname' => '<p>For custom layers only, use this parameter to specify the layer\'s short name, which is used internally by OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 32 characters and must be in the following format: /\\A[a-z0-9\\-\\_\\.]+\\Z/.</p> <p>Built-in layer short names are defined by OpsWorks Stacks. For more information, see the <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer reference</a> in the OpsWorks User Guide. </p>', 'UpdateLayerRequest$CustomInstanceProfileArn' => '<p>The ARN of an IAM profile to be used for all of the layer\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'UpdateLayerRequest$CustomJson' => '<p>A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer\'s instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom JSON</a>. </p>', 'UpdateMyUserProfileRequest$SshPublicKey' => '<p>The user\'s SSH public key.</p>', 'UpdateRdsDbInstanceRequest$RdsDbInstanceArn' => '<p>The Amazon RDS instance\'s ARN.</p>', 'UpdateRdsDbInstanceRequest$DbUser' => '<p>The master user name.</p>', 'UpdateRdsDbInstanceRequest$DbPassword' => '<p>The database password.</p>', 'UpdateStackRequest$StackId' => '<p>The stack ID.</p>', 'UpdateStackRequest$Name' => '<p>The stack\'s new name. Stack names can be a maximum of 64 characters.</p>', 'UpdateStackRequest$ServiceRoleArn' => '<p>Do not use this parameter. You cannot update a stack\'s service role.</p>', 'UpdateStackRequest$DefaultInstanceProfileArn' => '<p>The ARN of an IAM profile that is the default profile for all of the stack\'s EC2 instances. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>', 'UpdateStackRequest$DefaultOs' => '<p>The stack\'s operating system, which must be set to one of the following:</p> <ul> <li> <p>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>, <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.</p> </li> <li> <p>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.</p> </li> <li> <p> <code>CentOS Linux 7</code> </p> </li> <li> <p> <code>Red Hat Enterprise Linux 7</code> </p> </li> <li> <p>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>, <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.</p> </li> <li> <p>A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a>.</p> </li> </ul> <p>The default option is the stack\'s current operating system. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating Systems</a>.</p>', 'UpdateStackRequest$HostnameTheme' => '<p>The stack\'s new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack\'s instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which creates host names by appending integers to the layer\'s short name. The other themes are:</p> <ul> <li> <p> <code>Baked_Goods</code> </p> </li> <li> <p> <code>Clouds</code> </p> </li> <li> <p> <code>Europe_Cities</code> </p> </li> <li> <p> <code>Fruits</code> </p> </li> <li> <p> <code>Greek_Deities_and_Titans</code> </p> </li> <li> <p> <code>Legendary_creatures_from_Japan</code> </p> </li> <li> <p> <code>Planets_and_Moons</code> </p> </li> <li> <p> <code>Roman_Deities</code> </p> </li> <li> <p> <code>Scottish_Islands</code> </p> </li> <li> <p> <code>US_Cities</code> </p> </li> <li> <p> <code>Wild_Cats</code> </p> </li> </ul> <p>To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the current theme.</p>', 'UpdateStackRequest$DefaultAvailabilityZone' => '<p>The stack\'s default Availability Zone, which must be in the stack\'s region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see <a>CreateStack</a>. </p>', 'UpdateStackRequest$DefaultSubnetId' => '<p>The stack\'s default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For information on default values and when this parameter is required, see the <code>VpcId</code> parameter description. </p>', 'UpdateStackRequest$CustomJson' => '<p>A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:</p> <p> <code>"{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...}"</code> </p> <p>For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a>.</p>', 'UpdateStackRequest$DefaultSshKeyName' => '<p>A default Amazon EC2 key-pair name. The default value is <code>none</code>. If you specify a key-pair name, OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an instance</a>. </p>', 'UpdateStackRequest$AgentVersion' => '<p>The default OpsWorks Stacks agent version. You have the following options:</p> <ul> <li> <p>Auto-update - Set this parameter to <code>LATEST</code>. OpsWorks Stacks automatically installs new agent versions on the stack\'s instances as soon as they are available.</p> </li> <li> <p>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. OpsWorks Stacks installs that version on the stack\'s instances.</p> </li> </ul> <p>The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.</p> <note> <p>You can also specify an agent version when you create or update an instance, which overrides the stack\'s default setting.</p> </note>', 'UpdateUserProfileRequest$IamUserArn' => '<p>The user IAM ARN. This can also be a federated user\'s ARN.</p>', 'UpdateUserProfileRequest$SshUsername' => '<p>The user\'s SSH user name. The allowable characters are [a-z], [A-Z], [0-9], \'-\', and \'_\'. If the specified name includes other punctuation marks, OpsWorks Stacks removes them. For example, <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, OpsWorks Stacks generates one from the IAM user name. </p>', 'UpdateUserProfileRequest$SshPublicKey' => '<p>The user\'s new SSH public key.</p>', 'UpdateVolumeRequest$VolumeId' => '<p>The volume ID.</p>', 'UpdateVolumeRequest$Name' => '<p>The new name. Volume names can be a maximum of 128 characters.</p>', 'UpdateVolumeRequest$MountPoint' => '<p>The new mount point.</p>', 'UserProfile$IamUserArn' => '<p>The user\'s IAM ARN.</p>', 'UserProfile$Name' => '<p>The user\'s name.</p>', 'UserProfile$SshUsername' => '<p>The user\'s SSH user name.</p>', 'UserProfile$SshPublicKey' => '<p>The user\'s SSH public key.</p>', 'ValidationException$message' => '<p>The exception message.</p>', 'Volume$VolumeId' => '<p>The volume ID.</p>', 'Volume$Ec2VolumeId' => '<p>The Amazon EC2 volume ID.</p>', 'Volume$Name' => '<p>The volume name. Volume names are a maximum of 128 characters.</p>', 'Volume$RaidArrayId' => '<p>The RAID array ID.</p>', 'Volume$InstanceId' => '<p>The instance ID.</p>', 'Volume$Status' => '<p>The value returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html">DescribeVolumes</a>.</p>', 'Volume$Device' => '<p>The device name.</p>', 'Volume$MountPoint' => '<p>The volume mount point. For example, "/mnt/disk1".</p>', 'Volume$Region' => '<p>The Amazon Web Services Region. For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'Volume$AvailabilityZone' => '<p>The volume Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p>', 'Volume$VolumeType' => '<p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.</p> <ul> <li> <p> <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p> </li> <li> <p> <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 125 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 125 GiB and a maximum size of 16384 GiB.</p> </li> </ul>', 'VolumeConfiguration$MountPoint' => '<p>The volume mount point. For example "/dev/sdh".</p>', 'VolumeConfiguration$VolumeType' => '<p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.</p> <ul> <li> <p> <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.</p> </li> <li> <p> <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 125 GiB and a maximum size of 16384 GiB.</p> </li> <li> <p> <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 125 GiB and a maximum size of 16384 GiB.</p> </li> </ul>', ], ], 'Strings' => [ 'base' => NULL, 'refs' => [ 'App$Domains' => '<p>The app vhost settings with multiple domains separated by commas. For example: <code>\'www.example.com, example.com\'</code> </p>', 'AssignInstanceRequest$LayerIds' => '<p>The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.</p>', 'AutoScalingThresholds$Alarms' => '<p>Custom CloudWatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.</p> <note> <p>To use custom alarms, you must update your service role to allow <code>cloudwatch:DescribeAlarms</code>. You can either have OpsWorks Stacks update the role for you when you first use this feature or you can edit the role manually. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html">Allowing OpsWorks Stacks to Act on Your Behalf</a>.</p> </note>', 'CloneStackRequest$CloneAppIds' => '<p>A list of source stack app IDs to be included in the cloned stack.</p>', 'CreateAppRequest$Domains' => '<p>The app virtual host settings, with multiple domains separated by commas. For example: <code>\'www.example.com, example.com\'</code> </p>', 'CreateDeploymentRequest$InstanceIds' => '<p>The instance IDs for the deployment targets.</p>', 'CreateDeploymentRequest$LayerIds' => '<p>The layer IDs for the deployment targets.</p>', 'CreateInstanceRequest$LayerIds' => '<p>An array that contains the instance\'s layer IDs.</p>', 'CreateLayerRequest$CustomSecurityGroupIds' => '<p>An array containing the layer custom security group IDs.</p>', 'CreateLayerRequest$Packages' => '<p>An array of <code>Package</code> objects that describes the layer packages.</p>', 'Deployment$InstanceIds' => '<p>The IDs of the target instances.</p>', 'DeploymentCommandArgs$value' => NULL, 'DescribeAppsRequest$AppIds' => '<p>An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a description of the specified apps. Otherwise, it returns a description of every app.</p>', 'DescribeCommandsRequest$CommandIds' => '<p>An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of the specified commands. Otherwise, it returns a description of every command.</p>', 'DescribeDeploymentsRequest$DeploymentIds' => '<p>An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment.</p>', 'DescribeEcsClustersRequest$EcsClusterArns' => '<p>A list of ARNs, one for each cluster to be described.</p>', 'DescribeElasticIpsRequest$Ips' => '<p>An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address.</p>', 'DescribeElasticLoadBalancersRequest$LayerIds' => '<p>A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers.</p>', 'DescribeInstancesRequest$InstanceIds' => '<p>An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a description of the specified instances. Otherwise, it returns a description of every instance.</p>', 'DescribeLayersRequest$LayerIds' => '<p>An array of layer IDs that specify the layers to be described. If you omit this parameter, <code>DescribeLayers</code> returns a description of every layer in the specified stack.</p>', 'DescribeLoadBasedAutoScalingRequest$LayerIds' => '<p>An array of layer IDs.</p>', 'DescribeRaidArraysRequest$RaidArrayIds' => '<p>An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the specified arrays. Otherwise, it returns a description of every array.</p>', 'DescribeRdsDbInstancesRequest$RdsDbInstanceArns' => '<p>An array containing the ARNs of the instances to be described.</p>', 'DescribeServiceErrorsRequest$ServiceErrorIds' => '<p>An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the specified errors. Otherwise, it returns a description of every error.</p>', 'DescribeStacksRequest$StackIds' => '<p>An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of every stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code> action to specific stack ARNs, this parameter is required, and the user must specify a stack ARN that is allowed by the policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code> error.</p>', 'DescribeTimeBasedAutoScalingRequest$InstanceIds' => '<p>An array of instance IDs.</p>', 'DescribeUserProfilesRequest$IamUserArns' => '<p>An array of IAM or federated user ARNs that identify the users to be described.</p>', 'DescribeVolumesRequest$VolumeIds' => '<p>Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the specified volumes. Otherwise, it returns a description of every volume.</p>', 'ElasticLoadBalancer$AvailabilityZones' => '<p>A list of Availability Zones.</p>', 'ElasticLoadBalancer$SubnetIds' => '<p>A list of subnet IDs, if the stack is running in a VPC.</p>', 'ElasticLoadBalancer$Ec2InstanceIds' => '<p>A list of the EC2 instances for which the Elastic Load Balancing instance is managing traffic.</p>', 'Instance$LayerIds' => '<p>An array containing the instance layer IDs.</p>', 'Instance$SecurityGroupIds' => '<p>An array containing the instance security group IDs.</p>', 'Layer$CustomSecurityGroupIds' => '<p>An array containing the layer\'s custom security group IDs.</p>', 'Layer$DefaultSecurityGroupNames' => '<p>An array containing the layer\'s security group names.</p>', 'Layer$Packages' => '<p>An array of <code>Package</code> objects that describe the layer\'s packages.</p>', 'Recipes$Setup' => '<p>An array of custom recipe names to be run following a <code>setup</code> event.</p>', 'Recipes$Configure' => '<p>An array of custom recipe names to be run following a <code>configure</code> event.</p>', 'Recipes$Deploy' => '<p>An array of custom recipe names to be run following a <code>deploy</code> event.</p>', 'Recipes$Undeploy' => '<p>An array of custom recipe names to be run following a <code>undeploy</code> event.</p>', 'Recipes$Shutdown' => '<p>An array of custom recipe names to be run following a <code>shutdown</code> event.</p>', 'UpdateAppRequest$Domains' => '<p>The app\'s virtual host settings, with multiple domains separated by commas. For example: <code>\'www.example.com, example.com\'</code> </p>', 'UpdateInstanceRequest$LayerIds' => '<p>The instance\'s layer IDs.</p>', 'UpdateLayerRequest$CustomSecurityGroupIds' => '<p>An array containing the layer\'s custom security group IDs.</p>', 'UpdateLayerRequest$Packages' => '<p>An array of <code>Package</code> objects that describe the layer\'s packages.</p>', ], ], 'Switch' => [ 'base' => NULL, 'refs' => [ 'DailyAutoScalingSchedule$value' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of the keys of tags to be removed from a stack or layer.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'ListTagsResult$Tags' => '<p>A set of key-value pairs that contain tag keys and tag values that are attached to a stack or layer.</p>', 'TagResourceRequest$Tags' => '<p>A map that contains tag keys and tag values that are attached to a stack or layer.</p> <ul> <li> <p>The key cannot be empty.</p> </li> <li> <p>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li> <li> <p>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code> </p> </li> <li> <p>Leading and trailing white spaces are trimmed from both the key and value.</p> </li> <li> <p>A maximum of 40 tags is allowed for any resource.</p> </li> </ul>', ], ], 'TemporaryCredential' => [ 'base' => '<p>Contains the data needed by RDP clients such as the Microsoft Remote Desktop Connection to log in to the instance.</p>', 'refs' => [ 'GrantAccessResult$TemporaryCredential' => '<p>A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP clients, such as the Microsoft Remote Desktop Connection.</p>', ], ], 'TimeBasedAutoScalingConfiguration' => [ 'base' => '<p>Describes an instance\'s time-based auto scaling configuration.</p>', 'refs' => [ 'TimeBasedAutoScalingConfigurations$member' => NULL, ], ], 'TimeBasedAutoScalingConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeTimeBasedAutoScalingResult$TimeBasedAutoScalingConfigurations' => '<p>An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the specified instances.</p>', ], ], 'UnassignInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnassignVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateElasticIpRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLayerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMyUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRdsDbInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UserProfile' => [ 'base' => '<p>Describes a user\'s SSH information.</p>', 'refs' => [ 'UserProfiles$member' => NULL, ], ], 'UserProfiles' => [ 'base' => NULL, 'refs' => [ 'DescribeUserProfilesResult$UserProfiles' => '<p>A <code>Users</code> object that describes the specified users.</p>', ], ], 'ValidForInMinutes' => [ 'base' => NULL, 'refs' => [ 'GrantAccessRequest$ValidForInMinutes' => '<p>The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, they are logged out.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Indicates that a request was not valid.</p>', 'refs' => [], ], 'VirtualizationType' => [ 'base' => NULL, 'refs' => [ 'Instance$VirtualizationType' => '<p>The instance\'s virtualization type: <code>paravirtual</code> or <code>hvm</code>.</p>', ], ], 'Volume' => [ 'base' => '<p>Describes an instance\'s Amazon EBS volume.</p>', 'refs' => [ 'Volumes$member' => NULL, ], ], 'VolumeConfiguration' => [ 'base' => '<p>Describes an Amazon EBS volume configuration.</p>', 'refs' => [ 'VolumeConfigurations$member' => NULL, ], ], 'VolumeConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateLayerRequest$VolumeConfigurations' => '<p>A <code>VolumeConfigurations</code> object that describes the layer\'s Amazon EBS volumes.</p>', 'Layer$VolumeConfigurations' => '<p>A <code>VolumeConfigurations</code> object that describes the layer\'s Amazon EBS volumes.</p>', 'UpdateLayerRequest$VolumeConfigurations' => '<p>A <code>VolumeConfigurations</code> object that describes the layer\'s Amazon EBS volumes.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'EbsBlockDevice$VolumeType' => '<p>The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and <code>standard</code> for Magnetic volumes.</p> <p>If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code> attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. Amazon Web Services uses the default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).</p>', ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumesResult$Volumes' => '<p>An array of volume IDs.</p>', ], ], 'WeeklyAutoScalingSchedule' => [ 'base' => '<p>Describes a time-based instance\'s auto scaling schedule. The schedule consists of a set of key-value pairs.</p> <ul> <li> <p>The key is the time period (a UTC hour) and must be an integer from 0 - 23.</p> </li> <li> <p>The value indicates whether the instance should be online or offline for the specified period, and must be set to "on" or "off"</p> </li> </ul> <p>The default setting for all time periods is off, so you use the following parameters primarily to specify the online periods. You don\'t have to explicitly specify offline periods unless you want to change an online period to an offline period.</p> <p>The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be off for the remainder of the day.</p> <p> <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code> </p>', 'refs' => [ 'SetTimeBasedAutoScalingRequest$AutoScalingSchedule' => '<p>An <code>AutoScalingSchedule</code> with the instance schedule.</p>', 'TimeBasedAutoScalingConfiguration$AutoScalingSchedule' => '<p>A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.</p>', ], ], ],];
