<?php
// This file was auto-generated from sdk-root/src/data/pcs/2023-02-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Parallel Computing Service (Amazon Web Services PCS) is a managed service that makes it easier for you to run and scale your high performance computing (HPC) workloads, and build scientific and engineering models on Amazon Web Services using Slurm. For more information, see the <a href="https://docs.aws.amazon.com/pcs/latest/userguide">Amazon Web Services Parallel Computing Service User Guide</a>.</p> <p>This reference describes the actions and data types of the service management API. You can use the Amazon Web Services SDKs to call the API actions in software, or use the Command Line Interface (CLI) to call the API actions manually. These API actions manage the service through an Amazon Web Services account.</p> <p>The API actions operate on Amazon Web Services PCS resources. A <i>resource</i> is an entity in Amazon Web Services that you can work with. Amazon Web Services services create resources when you use the features of the service. Examples of Amazon Web Services PCS resources include clusters, compute node groups, and queues. For more information about resources in Amazon Web Services, see <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/getting-started-terms-and-concepts.html#term-resource">Resource</a> in the <i>Resource Explorer User Guide</i>. </p> <p>An Amazon Web Services PCS <i>compute node</i> is an Amazon EC2 instance. You don\'t launch compute nodes directly. Amazon Web Services PCS uses configuration information that you provide to launch compute nodes in your Amazon Web Services account. You receive billing charges for your running compute nodes. Amazon Web Services PCS automatically terminates your compute nodes when you delete the Amazon Web Services PCS resources related to those compute nodes.</p>', 'operations' => [ 'CreateCluster' => '<p>Creates a cluster in your account. Amazon Web Services PCS creates the cluster controller in a service-owned account. The cluster controller communicates with the cluster resources in your account. The subnets and security groups for the cluster must already exist before you use this API action.</p> <note> <p>It takes time for Amazon Web Services PCS to create the cluster. The cluster is in a <code>Creating</code> state until it is ready to use. There can only be 1 cluster in a <code>Creating</code> state per Amazon Web Services Region per Amazon Web Services account. <code>CreateCluster</code> fails with a <code>ServiceQuotaExceededException</code> if there is already a cluster in a <code>Creating</code> state.</p> </note>', 'CreateComputeNodeGroup' => '<p>Creates a managed set of compute nodes. You associate a compute node group with a cluster through 1 or more Amazon Web Services PCS queues or as part of the login fleet. A compute node group includes the definition of the compute properties and lifecycle management. Amazon Web Services PCS uses the information you provide to this API action to launch compute nodes in your account. You can only specify subnets in the same Amazon VPC as your cluster. You receive billing charges for the compute nodes that Amazon Web Services PCS launches in your account. You must already have a launch template before you call this API. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>', 'CreateQueue' => '<p>Creates a job queue. You must associate 1 or more compute node groups with the queue. You can associate 1 compute node group with multiple queues.</p>', 'DeleteCluster' => '<p>Deletes a cluster and all its linked resources. You must delete all queues and compute node groups associated with the cluster before you can delete the cluster.</p>', 'DeleteComputeNodeGroup' => '<p>Deletes a compute node group. You must delete all queues associated with the compute node group first.</p>', 'DeleteQueue' => '<p>Deletes a job queue. If the compute node group associated with this queue isn\'t associated with any other queues, Amazon Web Services PCS terminates all the compute nodes for this queue.</p>', 'GetCluster' => '<p>Returns detailed information about a running cluster in your account. This API action provides networking information, endpoint information for communication with the scheduler, and provisioning status.</p>', 'GetComputeNodeGroup' => '<p>Returns detailed information about a compute node group. This API action provides networking information, EC2 instance type, compute node group status, and scheduler (such as Slurm) configuration.</p>', 'GetQueue' => '<p>Returns detailed information about a queue. The information includes the compute node groups that the queue uses to schedule jobs.</p>', 'ListClusters' => '<p>Returns a list of running clusters in your account.</p>', 'ListComputeNodeGroups' => '<p>Returns a list of all compute node groups associated with a cluster.</p>', 'ListQueues' => '<p>Returns a list of all queues associated with a cluster.</p>', 'ListTagsForResource' => '<p>Returns a list of all tags on an Amazon Web Services PCS resource.</p>', 'RegisterComputeNodeGroupInstance' => '<important> <p>This API action isn\'t intended for you to use.</p> </important> <p>Amazon Web Services PCS uses this API action to register the compute nodes it launches in your account.</p>', 'TagResource' => '<p>Adds or edits tags on an Amazon Web Services PCS resource. Each tag consists of a tag key and a tag value. The tag key and tag value are case-sensitive strings. The tag value can be an empty (null) string. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.</p>', 'UntagResource' => '<p>Deletes tags from an Amazon Web Services PCS resource. To delete a tag, specify the tag key and the Amazon Resource Name (ARN) of the Amazon Web Services PCS resource.</p>', 'UpdateComputeNodeGroup' => '<p>Updates a compute node group. You can update many of the fields related to your compute node group including the configurations for networking, compute nodes, and settings specific to your scheduler (such as Slurm).</p>', 'UpdateQueue' => '<p>Updates the compute node group configuration of a queue. Use this API to change the compute node groups that the queue can send jobs to.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permission to perform the action.</p> <p> <u>Examples</u> </p> <ul> <li> <p>The launch template instance profile doesn\'t pass <code>iam:PassRole</code> verification.</p> </li> <li> <p>There is a mismatch between the account ID and cluster ID.</p> </li> <li> <p>The cluster ID doesn\'t exist.</p> </li> <li> <p>The EC2 instance isn\'t present.</p> </li> </ul>', 'refs' => [], ], 'AmiId' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$amiId' => '<p>The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not provided, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.</p>', 'CreateComputeNodeGroupRequest$amiId' => '<p> The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch compute nodes (Amazon EC2 instances). If you don\'t provide this value, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.</p>', 'UpdateComputeNodeGroupRequest$amiId' => '<p>The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to launch instances. If not provided, Amazon Web Services PCS uses the AMI ID specified in the custom launch template.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to list tags.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'BootstrapId' => [ 'base' => NULL, 'refs' => [ 'RegisterComputeNodeGroupInstanceRequest$bootstrapId' => '<p>The client-generated token to allow for retries.</p>', ], ], 'Cluster' => [ 'base' => '<p>The cluster resource and configuration.</p>', 'refs' => [ 'CreateClusterResponse$cluster' => '<p>The cluster resource.</p>', 'GetClusterResponse$cluster' => '<p>The cluster resource.</p>', ], ], 'ClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateComputeNodeGroupRequest$clusterIdentifier' => '<p>The name or ID of the cluster to create a compute node group in.</p>', 'CreateQueueRequest$clusterIdentifier' => '<p>The name or ID of the cluster for which to create a queue.</p>', 'DeleteClusterRequest$clusterIdentifier' => '<p>The name or ID of the cluster to delete.</p>', 'DeleteComputeNodeGroupRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the compute node group.</p>', 'DeleteQueueRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the queue.</p>', 'GetClusterRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the queue.</p>', 'GetComputeNodeGroupRequest$clusterIdentifier' => '<p>The name or ID of the cluster.</p>', 'GetQueueRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the queue.</p>', 'ListComputeNodeGroupsRequest$clusterIdentifier' => '<p>The name or ID of the cluster to list compute node groups for.</p>', 'ListQueuesRequest$clusterIdentifier' => '<p>The name or ID of the cluster to list queues for.</p>', 'RegisterComputeNodeGroupInstanceRequest$clusterIdentifier' => '<p>The name or ID of the cluster to register the compute node group instance in.</p>', 'UpdateComputeNodeGroupRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the compute node group.</p>', 'UpdateQueueRequest$clusterIdentifier' => '<p>The name or ID of the cluster of the queue.</p>', ], ], 'ClusterList' => [ 'base' => NULL, 'refs' => [ 'ListClustersResponse$clusters' => '<p>The list of clusters.</p>', ], ], 'ClusterName' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$clusterName' => '<p>A name to identify the cluster. Example: <code>MyCluster</code> </p>', ], ], 'ClusterSlurmConfiguration' => [ 'base' => '<p>Additional options related to the Slurm scheduler.</p>', 'refs' => [ 'Cluster$slurmConfiguration' => '<p>Additional options related to the Slurm scheduler.</p>', ], ], 'ClusterSlurmConfigurationRequest' => [ 'base' => '<p>Additional options related to the Slurm scheduler.</p>', 'refs' => [ 'CreateClusterRequest$slurmConfiguration' => '<p>Additional options related to the Slurm scheduler.</p>', ], ], 'ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'ClusterSlurmConfigurationRequest$scaleDownIdleTimeInSeconds' => '<p>The time before an idle node is scaled down.</p>', ], ], 'ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'ClusterSlurmConfiguration$scaleDownIdleTimeInSeconds' => '<p>The time before an idle node is scaled down.</p>', ], ], 'ClusterStatus' => [ 'base' => NULL, 'refs' => [ 'Cluster$status' => '<p>The provisioning status of the cluster.</p> <note> <p>The provisioning status doesn\'t indicate the overall health of the cluster.</p> </note>', 'ClusterSummary$status' => '<p>The provisioning status of the cluster.</p> <note> <p>The provisioning status doesn\'t indicate the overall health of the cluster.</p> </note>', ], ], 'ClusterSummary' => [ 'base' => '<p>The object returned by the <code>ListClusters</code> API action.</p>', 'refs' => [ 'ClusterList$member' => NULL, ], ], 'ComputeNodeGroup' => [ 'base' => '<p>A compute node group associated with a cluster.</p>', 'refs' => [ 'CreateComputeNodeGroupResponse$computeNodeGroup' => NULL, 'GetComputeNodeGroupResponse$computeNodeGroup' => NULL, 'UpdateComputeNodeGroupResponse$computeNodeGroup' => NULL, ], ], 'ComputeNodeGroupConfiguration' => [ 'base' => '<p>The compute node group configuration for a queue.</p>', 'refs' => [ 'ComputeNodeGroupConfigurationList$member' => NULL, ], ], 'ComputeNodeGroupConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$computeNodeGroupConfigurations' => '<p>The list of compute node group configurations to associate with the queue. Queues assign jobs to associated compute node groups.</p>', 'Queue$computeNodeGroupConfigurations' => '<p>The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.</p>', 'UpdateQueueRequest$computeNodeGroupConfigurations' => '<p>The list of compute node group configurations to associate with the queue. Queues assign jobs to associated compute node groups.</p>', ], ], 'ComputeNodeGroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteComputeNodeGroupRequest$computeNodeGroupIdentifier' => '<p>The name or ID of the compute node group to delete.</p>', 'GetComputeNodeGroupRequest$computeNodeGroupIdentifier' => '<p>The name or ID of the compute node group.</p>', 'UpdateComputeNodeGroupRequest$computeNodeGroupIdentifier' => '<p>The name or ID of the compute node group.</p>', ], ], 'ComputeNodeGroupList' => [ 'base' => NULL, 'refs' => [ 'ListComputeNodeGroupsResponse$computeNodeGroups' => '<p>The list of compute node groups for the cluster.</p>', ], ], 'ComputeNodeGroupName' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$name' => '<p>The name that identifies the compute node group.</p>', 'ComputeNodeGroupSummary$name' => '<p>The name that identifies the compute node group.</p>', 'CreateComputeNodeGroupRequest$computeNodeGroupName' => '<p>A name to identify the cluster. Example: <code>MyCluster</code> </p>', ], ], 'ComputeNodeGroupSlurmConfiguration' => [ 'base' => '<p>Additional options related to the Slurm scheduler.</p>', 'refs' => [ 'ComputeNodeGroup$slurmConfiguration' => NULL, ], ], 'ComputeNodeGroupSlurmConfigurationRequest' => [ 'base' => '<p>Additional options related to the Slurm scheduler.</p>', 'refs' => [ 'CreateComputeNodeGroupRequest$slurmConfiguration' => '<p>Additional options related to the Slurm scheduler.</p>', ], ], 'ComputeNodeGroupStatus' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$status' => '<p>The provisioning status of the compute node group.</p> <note> <p>The provisioning status doesn\'t indicate the overall health of the compute node group.</p> </note>', 'ComputeNodeGroupSummary$status' => '<p>The provisioning status of the compute node group.</p> <note> <p>The provisioning status doesn\'t indicate the overall health of the compute node group.</p> </note>', ], ], 'ComputeNodeGroupSummary' => [ 'base' => '<p>The object returned by the <code>ListComputeNodeGroups</code> API action.</p>', 'refs' => [ 'ComputeNodeGroupList$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than 1 operation on the same resource at the same time.</p> <p> <u>Examples</u> </p> <ul> <li> <p>A cluster with the same name already exists.</p> </li> <li> <p>A cluster isn\'t in <code>ACTIVE</code> status.</p> </li> <li> <p>A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node groups or queues.</p> </li> <li> <p>A queue already exists in a cluster.</p> </li> </ul>', 'refs' => [], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateComputeNodeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComputeNodeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomLaunchTemplate' => [ 'base' => '<p>An Amazon EC2 launch template Amazon Web Services PCS uses to launch compute nodes.</p>', 'refs' => [ 'ComputeNodeGroup$customLaunchTemplate' => NULL, 'CreateComputeNodeGroupRequest$customLaunchTemplate' => NULL, 'UpdateComputeNodeGroupRequest$customLaunchTemplate' => NULL, ], ], 'DeleteClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComputeNodeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComputeNodeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>An endpoint available for interaction with the scheduler.</p>', 'refs' => [ 'Endpoints$member' => NULL, ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'Endpoint$type' => '<p>Indicates the type of endpoint running at the specific IP address.</p>', ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'Cluster$endpoints' => '<p>The list of endpoints available for interaction with the scheduler.</p>', 'RegisterComputeNodeGroupInstanceResponse$endpoints' => '<p>The list of endpoints available for interaction with the scheduler.</p>', ], ], 'ErrorInfo' => [ 'base' => '<p>An error that occurred during resource creation.</p>', 'refs' => [ 'ErrorInfoList$member' => NULL, ], ], 'ErrorInfoList' => [ 'base' => NULL, 'refs' => [ 'Cluster$errorInfo' => '<p>The list of errors that occurred during cluster provisioning.</p>', 'ComputeNodeGroup$errorInfo' => '<p>The list of errors that occurred during compute node group provisioning.</p>', 'Queue$errorInfo' => '<p>The list of errors that occurred during queue provisioning.</p>', ], ], 'GetClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComputeNodeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComputeNodeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'InstanceConfig' => [ 'base' => '<p>An EC2 instance configuration Amazon Web Services PCS uses to launch compute nodes.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$instanceConfigs' => '<p>A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.</p>', 'CreateComputeNodeGroupRequest$instanceConfigs' => '<p>A list of EC2 instance configurations that Amazon Web Services PCS can provision in the compute node group.</p>', ], ], 'InstanceProfileArn' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$iamInstanceProfileArn' => '<p>The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have <code>pcs:RegisterComputeNodeGroupInstance</code> permissions attached to provision instances correctly.</p>', 'CreateComputeNodeGroupRequest$iamInstanceProfileArn' => '<p>The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have <code>pcs:RegisterComputeNodeGroupInstance</code> permissions attached in order to provision instances correctly. The resource identifier of the ARN must start with <code>AWSPCS</code>. For example, <code>arn:aws:iam:123456789012:instance-profile/AWSPCSMyComputeNodeInstanceProfile</code>. </p>', 'UpdateComputeNodeGroupRequest$iamInstanceProfileArn' => '<p>The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have <code>pcs:RegisterComputeNodeGroupInstance</code> permissions attached to provision instances correctly.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p> The number of seconds to wait before retrying the request. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>Amazon Web Services PCS can\'t process your request right now. Try again later.</p>', 'refs' => [], ], 'ListClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComputeNodeGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComputeNodeGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListClustersRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 10 results, and the maximum allowed page size is 100 results. A value of 0 uses the default.</p>', 'ListComputeNodeGroupsRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 10 results, and the maximum allowed page size is 100 results. A value of 0 uses the default.</p>', 'ListQueuesRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 10 results, and the maximum allowed page size is 100 results. A value of 0 uses the default.</p>', ], ], 'Networking' => [ 'base' => '<p>The networking configuration for the cluster\'s control plane.</p>', 'refs' => [ 'Cluster$networking' => NULL, ], ], 'NetworkingRequest' => [ 'base' => '<p>The networking configuration for the cluster\'s control plane.</p>', 'refs' => [ 'CreateClusterRequest$networking' => '<p>The networking configuration used to set up the cluster\'s control plane.</p>', ], ], 'PurchaseOption' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$purchaseOption' => '<p>Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don\'t provide this option, it defaults to On-Demand.</p>', 'CreateComputeNodeGroupRequest$purchaseOption' => '<p>Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don\'t provide this option, it defaults to On-Demand.</p>', 'UpdateComputeNodeGroupRequest$purchaseOption' => '<p>Specifies how EC2 instances are purchased on your behalf. Amazon Web Services PCS supports On-Demand and Spot instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html">Instance purchasing options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don\'t provide this option, it defaults to On-Demand.</p>', ], ], 'Queue' => [ 'base' => '<p>A queue resource.</p>', 'refs' => [ 'CreateQueueResponse$queue' => NULL, 'GetQueueResponse$queue' => NULL, 'UpdateQueueResponse$queue' => NULL, ], ], 'QueueIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteQueueRequest$queueIdentifier' => '<p>The name or ID of the queue to delete.</p>', 'GetQueueRequest$queueIdentifier' => '<p>The name or ID of the queue.</p>', 'UpdateQueueRequest$queueIdentifier' => '<p>The name or ID of the queue.</p>', ], ], 'QueueList' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$queues' => '<p>The list of queues associated with the cluster.</p>', ], ], 'QueueName' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$queueName' => '<p>A name to identify the queue.</p>', 'Queue$name' => '<p>The name that identifies the queue.</p>', 'QueueSummary$name' => '<p>The name that identifies the queue.</p>', ], ], 'QueueStatus' => [ 'base' => NULL, 'refs' => [ 'Queue$status' => '<p>The provisioning status of the queue.</p> <note> <p>The provisioning status doesn\'t indicate the overall health of the queue.</p> </note>', 'QueueSummary$status' => '<p>The provisioning status of the queue.</p> <note> <p> The provisioning status doesn\'t indicate the overall health of the queue.</p> </note>', ], ], 'QueueSummary' => [ 'base' => '<p>The object returned by the <code>ListQueues</code> API action.</p>', 'refs' => [ 'QueueList$member' => NULL, ], ], 'RegisterComputeNodeGroupInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterComputeNodeGroupInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestTagMap' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$tags' => '<p>1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.</p>', 'CreateComputeNodeGroupRequest$tags' => '<p>1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.</p>', 'CreateQueueRequest$tags' => '<p>1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.</p>', 'TagResourceRequest$tags' => '<p>1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource can\'t be found. The cluster, node group, or queue you\'re attempting to get, update, list, or delete doesn\'t exist.</p> <p> <u>Examples</u> </p>', 'refs' => [], ], 'ResponseTagMap' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$tags' => '<p>1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.</p>', ], ], 'SBClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'CreateComputeNodeGroupRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'CreateQueueRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'DeleteClusterRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'DeleteComputeNodeGroupRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'DeleteQueueRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'UpdateComputeNodeGroupRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', 'UpdateQueueRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you don\'t specify a client token, the CLI and SDK automatically generate 1 for you.</p>', ], ], 'ScalingConfiguration' => [ 'base' => '<p>Specifies the boundaries of the compute node group auto scaling.</p>', 'refs' => [ 'ComputeNodeGroup$scalingConfiguration' => NULL, ], ], 'ScalingConfigurationMaxInstanceCountInteger' => [ 'base' => NULL, 'refs' => [ 'ScalingConfiguration$maxInstanceCount' => '<p>The upper bound of the number of instances allowed in the compute fleet.</p>', ], ], 'ScalingConfigurationMinInstanceCountInteger' => [ 'base' => NULL, 'refs' => [ 'ScalingConfiguration$minInstanceCount' => '<p>The lower bound of the number of instances allowed in the compute fleet.</p>', ], ], 'ScalingConfigurationRequest' => [ 'base' => '<p>Specifies the boundaries of the compute node group auto scaling.</p>', 'refs' => [ 'CreateComputeNodeGroupRequest$scalingConfiguration' => '<p>Specifies the boundaries of the compute node group auto scaling.</p>', 'UpdateComputeNodeGroupRequest$scalingConfiguration' => '<p>Specifies the boundaries of the compute node group auto scaling.</p>', ], ], 'ScalingConfigurationRequestMaxInstanceCountInteger' => [ 'base' => NULL, 'refs' => [ 'ScalingConfigurationRequest$maxInstanceCount' => '<p>The upper bound of the number of instances allowed in the compute fleet.</p>', ], ], 'ScalingConfigurationRequestMinInstanceCountInteger' => [ 'base' => NULL, 'refs' => [ 'ScalingConfigurationRequest$minInstanceCount' => '<p>The lower bound of the number of instances allowed in the compute fleet.</p>', ], ], 'Scheduler' => [ 'base' => '<p>The cluster management and job scheduling software associated with the cluster.</p>', 'refs' => [ 'Cluster$scheduler' => NULL, ], ], 'SchedulerRequest' => [ 'base' => '<p>The cluster management and job scheduling software associated with the cluster.</p>', 'refs' => [ 'CreateClusterRequest$scheduler' => '<p>The cluster management and job scheduling software associated with the cluster.</p>', ], ], 'SchedulerType' => [ 'base' => NULL, 'refs' => [ 'Scheduler$type' => '<p>The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.</p>', 'SchedulerRequest$type' => '<p>The software Amazon Web Services PCS uses to manage cluster scaling and job scheduling.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'Networking$securityGroupIds' => '<p>The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.</p> <p>The following rules are required:</p> <ul> <li> <p>Inbound rule 1</p> <ul> <li> <p>Protocol: All</p> </li> <li> <p>Ports: All</p> </li> <li> <p>Source: Self</p> </li> </ul> </li> <li> <p>Outbound rule 1</p> <ul> <li> <p>Protocol: All</p> </li> <li> <p>Ports: All</p> </li> <li> <p>Destination: 0.0.0.0/0 (IPv4)</p> </li> </ul> </li> <li> <p>Outbound rule 2</p> <ul> <li> <p>Protocol: All</p> </li> <li> <p>Ports: All</p> </li> <li> <p>Destination: Self</p> </li> </ul> </li> </ul>', 'NetworkingRequest$securityGroupIds' => '<p>A list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of service resources or operations for your Amazon Web Services account. To learn how to increase your service quota, see <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting a quota increase</a> in the <i>Service Quotas User Guide</i> </p> <p> <u>Examples</u> </p> <ul> <li> <p>The max number of clusters or queues has been reached for the account.</p> </li> <li> <p>The max number of compute node groups has been reached for the associated cluster.</p> </li> <li> <p>The total of <code>maxInstances</code> across all compute node groups has been reached for associated cluster.</p> </li> </ul>', 'refs' => [], ], 'SharedSecret' => [ 'base' => NULL, 'refs' => [ 'RegisterComputeNodeGroupInstanceResponse$sharedSecret' => '<p>For the Slurm scheduler, this is the shared Munge key the scheduler uses to authenticate compute node group instances.</p>', ], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'Cluster$size' => '<p>The size of the cluster.</p> <ul> <li> <p> <code>SMALL</code>: 32 compute nodes and 256 jobs</p> </li> <li> <p> <code>MEDIUM</code>: 512 compute nodes and 8192 jobs</p> </li> <li> <p> <code>LARGE</code>: 2048 compute nodes and 16,384 jobs</p> </li> </ul>', 'CreateClusterRequest$size' => '<p>A value that determines the maximum number of compute nodes in the cluster and the maximum number of jobs (active and queued).</p> <ul> <li> <p> <code>SMALL</code>: 32 compute nodes and 256 jobs</p> </li> <li> <p> <code>MEDIUM</code>: 512 compute nodes and 8192 jobs</p> </li> <li> <p> <code>LARGE</code>: 2048 compute nodes and 16,384 jobs</p> </li> </ul>', ], ], 'SlurmAuthKey' => [ 'base' => '<p>The shared Slurm key for authentication, also known as the <b>cluster secret</b>.</p>', 'refs' => [ 'ClusterSlurmConfiguration$authKey' => '<p>The shared Slurm key for authentication, also known as the <b>cluster secret</b>.</p>', ], ], 'SlurmCustomSetting' => [ 'base' => '<p>Additional settings that directly map to Slurm settings.</p>', 'refs' => [ 'SlurmCustomSettings$member' => NULL, ], ], 'SlurmCustomSettings' => [ 'base' => NULL, 'refs' => [ 'ClusterSlurmConfiguration$slurmCustomSettings' => '<p>Additional Slurm-specific configuration that directly maps to Slurm settings.</p>', 'ClusterSlurmConfigurationRequest$slurmCustomSettings' => '<p>Additional Slurm-specific configuration that directly maps to Slurm settings.</p>', 'ComputeNodeGroupSlurmConfiguration$slurmCustomSettings' => '<p>Additional Slurm-specific configuration that directly maps to Slurm settings.</p>', 'ComputeNodeGroupSlurmConfigurationRequest$slurmCustomSettings' => '<p>Additional Slurm-specific configuration that directly maps to Slurm settings.</p>', 'UpdateComputeNodeGroupSlurmConfigurationRequest$slurmCustomSettings' => '<p>Additional Slurm-specific configuration that directly maps to Slurm settings.</p>', ], ], 'SpotAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotOptions$allocationStrategy' => '<p>The Amazon EC2 allocation strategy Amazon Web Services PCS uses to provision EC2 instances. Amazon Web Services PCS supports <b>lowest price</b>, <b>capacity optimized</b>, and <b>price capacity optimized</b>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-allocation-strategy.html">Use allocation strategies to determine how EC2 Fleet or Spot Fleet fulfills Spot and On-Demand capacity</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. If you don\'t provide this option, it defaults to <b>price capacity optimized</b>.</p>', ], ], 'SpotOptions' => [ 'base' => '<p>Additional configuration when you specify <code>SPOT</code> as the <code>purchaseOption</code> for the <code>CreateComputeNodeGroup</code> API action.</p>', 'refs' => [ 'ComputeNodeGroup$spotOptions' => NULL, 'CreateComputeNodeGroupRequest$spotOptions' => NULL, 'UpdateComputeNodeGroupRequest$spotOptions' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'Cluster$name' => '<p>The name that identifies the cluster.</p>', 'Cluster$id' => '<p>The generated unique ID of the cluster.</p>', 'Cluster$arn' => '<p>The unique Amazon Resource Name (ARN) of the cluster.</p>', 'ClusterSummary$name' => '<p>The name that identifies the cluster.</p>', 'ClusterSummary$id' => '<p>The generated unique ID of the cluster.</p>', 'ClusterSummary$arn' => '<p>The unique Amazon Resource Name (ARN) of the cluster.</p>', 'ComputeNodeGroup$id' => '<p>The generated unique ID of the compute node group.</p>', 'ComputeNodeGroup$arn' => '<p>The unique Amazon Resource Name (ARN) of the compute node group.</p>', 'ComputeNodeGroup$clusterId' => '<p>The ID of the cluster of the compute node group.</p>', 'ComputeNodeGroupConfiguration$computeNodeGroupId' => '<p>The compute node group ID for the compute node group configuration.</p>', 'ComputeNodeGroupSummary$id' => '<p>The generated unique ID of the compute node group.</p>', 'ComputeNodeGroupSummary$arn' => '<p>The unique Amazon Resource Name (ARN) of the compute node group.</p>', 'ComputeNodeGroupSummary$clusterId' => '<p>The ID of the cluster of the compute node group.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p> The unique identifier of the resource that caused the conflict exception. </p>', 'ConflictException$resourceType' => '<p> The type or category of the resource that caused the conflict exception." </p>', 'CustomLaunchTemplate$id' => '<p>The ID of the EC2 launch template to use to provision instances.</p> <p> Example: <code>lt-xxxx</code> </p>', 'CustomLaunchTemplate$version' => '<p>The version of the EC2 launch template to use to provision instances.</p>', 'Endpoint$privateIpAddress' => '<p>The endpoint\'s private IP address.</p> <p>Example: <code>2.2.2.2</code> </p>', 'Endpoint$publicIpAddress' => '<p>The endpoint\'s public IP address.</p> <p>Example: <code>1.1.1.1</code> </p>', 'Endpoint$port' => '<p>The endpoint\'s connection port number.</p> <p> Example: <code>1234</code> </p>', 'ErrorInfo$code' => '<p>The short-form error code.</p>', 'ErrorInfo$message' => '<p>The detailed error information.</p>', 'InstanceConfig$instanceType' => '<p>The EC2 instance type that Amazon Web Services PCS can provision in the compute node group.</p> <p> Example: <code>t2.xlarge</code> </p>', 'InternalServerException$message' => NULL, 'ListClustersRequest$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'ListClustersResponse$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'ListComputeNodeGroupsRequest$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'ListComputeNodeGroupsResponse$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'ListQueuesRequest$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'ListQueuesResponse$nextToken' => '<p>The value of <code>nextToken</code> is a unique pagination token for each page of results returned. If <code>nextToken</code> is returned, there are more results available. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token returns an <code>HTTP 400 InvalidToken</code> error.</p>', 'Queue$id' => '<p>The generated unique ID of the queue.</p>', 'Queue$arn' => '<p>The unique Amazon Resource Name (ARN) of the queue.</p>', 'Queue$clusterId' => '<p>The ID of the cluster of the queue.</p>', 'QueueSummary$id' => '<p>The generated unique ID of the queue.</p>', 'QueueSummary$arn' => '<p>The unique Amazon Resource Name (ARN) of the queue.</p>', 'QueueSummary$clusterId' => '<p>The ID of the cluster of the queue.</p>', 'RegisterComputeNodeGroupInstanceResponse$nodeID' => '<p>The scheduler node ID for this instance.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p> The unique identifier of the resource that was not found. </p>', 'ResourceNotFoundException$resourceType' => '<p> The type or category of the resource that was not found. </p>', 'Scheduler$version' => '<p>The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster scaling and job scheduling.</p>', 'SchedulerRequest$version' => '<p>The version of the specified scheduling software that Amazon Web Services PCS uses to manage cluster scaling and job scheduling.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$serviceCode' => '<p> The service code associated with the quota that was exceeded. </p>', 'ServiceQuotaExceededException$resourceId' => '<p> The unique identifier of the resource that caused the quota to be exceeded. </p>', 'ServiceQuotaExceededException$resourceType' => '<p> The type or category of the resource that caused the quota to be exceeded. </p>', 'ServiceQuotaExceededException$quotaCode' => '<p> The <b>quota code</b> of the service quota that was exceeded. </p>', 'SlurmAuthKey$secretArn' => '<p>The Amazon Resource Name (ARN) of the the shared Slurm key.</p>', 'SlurmAuthKey$secretVersion' => '<p>The version of the shared Slurm key.</p>', 'SlurmCustomSetting$parameterName' => '<p>Amazon Web Services PCS supports configuration of the following Slurm parameters: <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Prolog_1"> <code>Prolog</code> </a>, <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_Epilog_1"> <code>Epilog</code> </a>, and <a href="https://slurm.schedmd.com/slurm.conf.html#OPT_SelectTypeParameters"> <code>SelectTypeParameters</code> </a>.</p>', 'SlurmCustomSetting$parameterValue' => '<p>The values for the configured Slurm settings.</p>', 'StringList$member' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The name of the exception.</p>', 'ValidationExceptionField$message' => '<p>The message body of the exception.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateComputeNodeGroupRequest$subnetIds' => '<p>The list of subnet IDs where the compute node group launches instances. Subnets must be in the same VPC as the cluster.</p>', 'UpdateComputeNodeGroupRequest$subnetIds' => '<p>The list of subnet IDs where the compute node group provisions instances. The subnets must be in the same VPC as the cluster.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'ComputeNodeGroup$subnetIds' => '<p>The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same VPC as the cluster.</p>', 'Networking$subnetIds' => '<p>The ID of the subnet where Amazon Web Services PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and Amazon Web Services PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone.</p> <p> Example: <code>subnet-abcd1234</code> </p>', 'NetworkingRequest$subnetIds' => '<p>The list of subnet IDs where Amazon Web Services PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and Amazon Web Services PCS resources. Subnet IDs have the form <code>subnet-0123456789abcdef0</code>.</p> <p>Subnets can\'t be in Outposts, Wavelength or an Amazon Web Services Local Zone.</p> <note> <p>Amazon Web Services PCS currently supports only 1 subnet in this list.</p> </note>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'Cluster$createdAt' => '<p>The date and time the resource was created.</p>', 'Cluster$modifiedAt' => '<p>The date and time the resource was modified.</p>', 'ClusterSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'ClusterSummary$modifiedAt' => '<p>The date and time the resource was modified.</p>', 'ComputeNodeGroup$createdAt' => '<p>The date and time the resource was created.</p>', 'ComputeNodeGroup$modifiedAt' => '<p>The date and time the resource was modified.</p>', 'ComputeNodeGroupSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'ComputeNodeGroupSummary$modifiedAt' => '<p>The date and time the resource was modified.</p>', 'Queue$createdAt' => '<p>The date and time the resource was created.</p>', 'Queue$modifiedAt' => '<p>The date and time the resource was modified.</p>', 'QueueSummary$createdAt' => '<p>The date and time the resource was created.</p>', 'QueueSummary$modifiedAt' => '<p>The date and time the resource was modified.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'RequestTagMap$key' => NULL, 'ResponseTagMap$key' => NULL, 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>1 or more tag keys to remove from the resource. Specify only tag keys and not tag values.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'RequestTagMap$value' => NULL, 'ResponseTagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>Your request exceeded a request rate quota. Check the resource\'s request rate quota and try again.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComputeNodeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComputeNodeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComputeNodeGroupSlurmConfigurationRequest' => [ 'base' => '<p>Additional options related to the Slurm scheduler.</p>', 'refs' => [ 'UpdateComputeNodeGroupRequest$slurmConfiguration' => '<p>Additional options related to the Slurm scheduler.</p>', ], ], 'UpdateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request isn\'t valid.</p> <p> <u>Examples</u> </p> <ul> <li> <p>Your request contains malformed JSON or unsupported characters.</p> </li> <li> <p>The scheduler version isn\'t supported.</p> </li> <li> <p>There are networking related errors, such as network validation failure.</p> </li> <li> <p>AMI type is <code>CUSTOM</code> and the launch template doesn\'t define the AMI ID, or the AMI type is AL2 and the launch template defines the AMI.</p> </li> </ul>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Stores information about a field in a request that caused an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p> A list of fields or properties that failed validation. </p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p> The specific reason or cause of the validation error. </p>', ], ], ],];
