<?php
// This file was auto-generated from sdk-root/src/data/personalize-events/2018-03-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Personalize can consume real-time user event data, such as <i>stream</i> or <i>click</i> data, and use it for model training either alone or combined with historical data. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item interaction events</a>.</p>', 'operations' => [ 'PutActionInteractions' => '<p>Records action interaction event data. An <i>action interaction</i> event is an interaction between a user and an <i>action</i>. For example, a user taking an action, such a enrolling in a membership program or downloading your app.</p> <p> For more information about recording action interactions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-action-interaction-events.html">Recording action interaction events</a>. For more information about actions in an Actions dataset, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/actions-datasets.html">Actions dataset</a>.</p>', 'PutActions' => '<p>Adds one or more actions to an Actions dataset. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions individually</a>. </p>', 'PutEvents' => '<p>Records item interaction event data. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item interaction events</a>.</p>', 'PutItems' => '<p>Adds one or more items to an Items dataset. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>. </p>', 'PutUsers' => '<p>Adds one or more users to a Users dataset. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.</p>', ], 'shapes' => [ 'Action' => [ 'base' => '<p>Represents action metadata added to an Action dataset using the <code>PutActions</code> API. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions individually</a>. </p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionId' => [ 'base' => NULL, 'refs' => [ 'ActionImpression$member' => NULL, 'ActionInteraction$actionId' => '<p>The ID of the action the user interacted with. This corresponds to the <code>ACTION_ID</code> field of the Action interaction schema.</p>', ], ], 'ActionImpression' => [ 'base' => NULL, 'refs' => [ 'ActionInteraction$impression' => '<p>A list of action IDs that represents the sequence of actions you have shown the user. For example, <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn\'t use impressions data from action interaction events. Instead, record multiple events for each action and use the <code>Viewed</code> event type. </p>', ], ], 'ActionInteraction' => [ 'base' => '<p>Represents an action interaction event sent using the <code>PutActionInteractions</code> API.</p>', 'refs' => [ 'ActionInteractionsList$member' => NULL, ], ], 'ActionInteractionProperties' => [ 'base' => NULL, 'refs' => [ 'ActionInteraction$properties' => '<p>A string map of event-specific data that you might choose to record. For example, if a user takes an action, other than the action ID, you might also send the number of actions taken by the user.</p> <p>Each item in the map consists of a key-value pair. For example,</p> <p> <code>{"numberOfActions": "12"}</code> </p> <p>The keys use camel case names that match the fields in the Action interactions schema. In the above example, the <code>numberOfActions</code> would match the \'NUMBER_OF_ACTIONS\' field defined in the Action interactions schema.</p> <p> The following can\'t be included as a keyword for properties (case insensitive). </p> <ul> <li> <p> userId </p> </li> <li> <p> sessionId </p> </li> <li> <p>eventType</p> </li> <li> <p>timestamp</p> </li> <li> <p>recommendationId</p> </li> <li> <p>impression</p> </li> </ul>', ], ], 'ActionInteractionsList' => [ 'base' => NULL, 'refs' => [ 'PutActionInteractionsRequest$actionInteractions' => '<p>A list of action interaction events from the session.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'PutActionsRequest$actions' => '<p>A list of action data.</p>', ], ], 'ActionProperties' => [ 'base' => NULL, 'refs' => [ 'Action$properties' => '<p>A string map of action-specific metadata. Each element in the map consists of a key-value pair. For example, <code>{"value": "100"}</code>.</p> <p>The keys use camel case names that match the fields in the schema for the Actions dataset. In the previous example, the <code>value</code> matches the \'VALUE\' field defined in the Actions schema. For categorical string data, to include multiple categories for a single action, separate each category with a pipe separator (<code>|</code>). For example, <code>\\"Deluxe|Premium\\"</code>.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'PutActionsRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the Actions dataset you are adding the action or actions to.</p>', 'PutItemsRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the Items dataset you are adding the item or items to.</p>', 'PutUsersRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'ActionInteraction$timestamp' => '<p>The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time format, in seconds.</p>', 'Event$sentAt' => '<p>The timestamp (in Unix time) on the client side when the event occurred.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, ], ], 'Event' => [ 'base' => '<p>Represents item interaction event information sent using the <code>PutEvents</code> API.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventAttributionSource' => [ 'base' => NULL, 'refs' => [ 'MetricAttribution$eventAttributionSource' => '<p>The source of the event, such as a third party.</p>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequest$eventList' => '<p>A list of event data from the session.</p>', ], ], 'EventPropertiesJSON' => [ 'base' => NULL, 'refs' => [ 'Event$properties' => '<p>A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) , you might also send the number of movie ratings made by the user.</p> <p>Each item in the map consists of a key-value pair. For example,</p> <p> <code>{"numberOfRatings": "12"}</code> </p> <p>The keys use camel case names that match the fields in the Item interactions dataset\'s schema. In the above example, the <code>numberOfRatings</code> would match the \'NUMBER_OF_RATINGS\' field defined in the Item interactions dataset\'s schema.</p> <p> The following can\'t be included as a keyword for properties (case insensitive). </p> <ul> <li> <p> userId </p> </li> <li> <p> sessionId </p> </li> <li> <p>eventType</p> </li> <li> <p>timestamp</p> </li> <li> <p>recommendationId</p> </li> <li> <p>impression</p> </li> </ul>', ], ], 'FloatType' => [ 'base' => NULL, 'refs' => [ 'Event$eventValue' => '<p>The event value that corresponds to the <code>EVENT_VALUE</code> field of the Item interactions schema.</p>', ], ], 'Impression' => [ 'base' => NULL, 'refs' => [ 'Event$impression' => '<p>A list of item IDs that represents the sequence of items you have shown the user. For example, <code>["itemId1", "itemId2", "itemId3"]</code>. Provide a list of items to manually record impressions data for an event. For more information on recording impressions data, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data">Recording impressions data</a>. </p>', ], ], 'InvalidInputException' => [ 'base' => '<p>Provide a valid value for the field or parameter.</p>', 'refs' => [], ], 'Item' => [ 'base' => '<p>Represents item metadata added to an Items dataset using the <code>PutItems</code> API. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>. </p>', 'refs' => [ 'ItemList$member' => NULL, ], ], 'ItemId' => [ 'base' => NULL, 'refs' => [ 'Event$itemId' => '<p>The item ID key that corresponds to the <code>ITEM_ID</code> field of the Item interactions dataset\'s schema.</p>', 'Impression$member' => NULL, ], ], 'ItemList' => [ 'base' => NULL, 'refs' => [ 'PutItemsRequest$items' => '<p>A list of item data.</p>', ], ], 'ItemProperties' => [ 'base' => NULL, 'refs' => [ 'Item$properties' => '<p>A string map of item-specific metadata. Each element in the map consists of a key-value pair. For example, <code>{"numberOfRatings": "12"}</code>.</p> <p>The keys use camel case names that match the fields in the schema for the Items dataset. In the previous example, the <code>numberOfRatings</code> matches the \'NUMBER_OF_RATINGS\' field defined in the Items schema. For categorical string data, to include multiple categories for a single item, separate each category with a pipe separator (<code>|</code>). For example, <code>\\"Horror|Action\\"</code>.</p>', ], ], 'MetricAttribution' => [ 'base' => '<p>Contains information about a metric attribution associated with an event. For more information about metric attributions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', 'refs' => [ 'Event$metricAttribution' => '<p>Contains information about the metric attribution associated with an event. For more information about metric attributions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', ], ], 'PutActionInteractionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationId' => [ 'base' => NULL, 'refs' => [ 'ActionInteraction$recommendationId' => '<p>The ID of the list of recommendations that contains the action the user interacted with.</p>', 'Event$recommendationId' => '<p>The ID of the list of recommendations that contains the item the user interacted with. Provide a <code>recommendationId</code> to have Amazon Personalize implicitly record the recommendations you show your user as impressions data. Or provide a <code>recommendationId</code> if you use a metric attribution to measure the impact of recommendations. </p> <p> For more information on recording impressions data, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data">Recording impressions data</a>. For more information on creating a metric attribution see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>. </p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Could not find the specified resource.</p>', 'refs' => [], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'Action$actionId' => '<p>The ID associated with the action.</p>', 'ActionInteraction$sessionId' => '<p>The ID associated with the user\'s visit. Your application generates a unique <code>sessionId</code> when a user first visits your website or uses your application. </p>', 'ActionInteraction$eventType' => '<p>The type of action interaction event. You can specify <code>Viewed</code>, <code>Taken</code>, and <code>Not Taken</code> event types. For more information about action interaction event type data, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html">Event type data</a>. </p>', 'ActionInteraction$eventId' => '<p>An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.</p>', 'Event$eventId' => '<p>An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish unique events. Any subsequent events after the first with the same event ID are not used in model training.</p>', 'Event$eventType' => '<p>The type of event, such as click or download. This property corresponds to the <code>EVENT_TYPE</code> field of your Item interactions dataset\'s schema and depends on the types of events you are tracking.</p>', 'Item$itemId' => '<p>The ID associated with the item.</p>', 'PutActionInteractionsRequest$trackingId' => '<p>The ID of your action interaction event tracker. When you create an Action interactions dataset, Amazon Personalize creates an action interaction event tracker for you. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-tracker-id.html">Action interaction event tracker ID</a>.</p>', 'PutEventsRequest$trackingId' => '<p>The tracking ID for the event. The ID is generated by a call to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.</p>', 'PutEventsRequest$sessionId' => '<p>The session ID associated with the user\'s visit. Your application generates the sessionId when a user first visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the user before they log in. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item interaction events</a>.</p>', 'User$userId' => '<p>The ID associated with the user.</p>', ], ], 'User' => [ 'base' => '<p>Represents user metadata added to a Users dataset using the <code>PutUsers</code> API. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.</p>', 'refs' => [ 'UserList$member' => NULL, ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'ActionInteraction$userId' => '<p>The ID of the user who interacted with the action. This corresponds to the <code>USER_ID</code> field of the Action interaction schema.</p>', 'PutEventsRequest$userId' => '<p>The user associated with the event.</p>', ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'PutUsersRequest$users' => '<p>A list of user data.</p>', ], ], 'UserProperties' => [ 'base' => NULL, 'refs' => [ 'User$properties' => '<p>A string map of user-specific metadata. Each element in the map consists of a key-value pair. For example, <code>{"numberOfVideosWatched": "45"}</code>.</p> <p>The keys use camel case names that match the fields in the schema for the Users dataset. In the previous example, the <code>numberOfVideosWatched</code> matches the \'NUMBER_OF_VIDEOS_WATCHED\' field defined in the Users schema. For categorical string data, to include multiple categories for a single user, separate each category with a pipe separator (<code>|</code>). For example, <code>\\"Member|Frequent shopper\\"</code>.</p>', ], ], ],];
