<?php
// This file was auto-generated from sdk-root/src/data/quicksight/2018-04-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon QuickSight API Reference</fullname> <p>Amazon QuickSight is a fully managed, serverless business intelligence service for the Amazon Web Services Cloud that makes it easy to extend data and insights to every user in your organization. This API reference contains documentation for a programming interface that you can use to manage Amazon QuickSight. </p>', 'operations' => [ 'BatchCreateTopicReviewedAnswer' => '<p>Creates new reviewed answers for a Q Topic.</p>', 'BatchDeleteTopicReviewedAnswer' => '<p>Deletes reviewed answers for Q Topic.</p>', 'CancelIngestion' => '<p>Cancels an ongoing ingestion of data into SPICE.</p>', 'CreateAccountCustomization' => '<p>Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p> <p>You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.</p> <p>Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don\'t share it with the namespace, the theme isn\'t visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code> API operation. To share the theme, grant permissions by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code> API operation. </p>', 'CreateAccountSubscription' => '<p>Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.</p> <p>The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK.</p> <p>Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don\'t have an Amazon Web Services account, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html">Sign up for Amazon Web Services</a> in the <i>Amazon QuickSight User Guide</i>. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html">IAM Policy Examples for Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>If your IAM policy includes both the <code>Subscribe</code> and <code>CreateAccountSubscription</code> actions, make sure that both actions are set to <code>Allow</code>. If either action is set to <code>Deny</code>, the <code>Deny</code> action prevails and your API call fails.</p> <p>You can\'t pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role">Passing IAM roles to Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>You can\'t set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html">Setting default resource access to Amazon Web Services services</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'CreateAnalysis' => '<p>Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an <code>AnalysisDefinition</code>.</p>', 'CreateDashboard' => '<p>Creates a dashboard from either a template or directly with a <code>DashboardDefinition</code>. To first create a template, see the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation.</p> <p>A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.</p>', 'CreateDataSet' => '<p>Creates a dataset. This operation doesn\'t support datasets that include uploaded files as a source.</p>', 'CreateDataSource' => '<p>Creates a data source.</p>', 'CreateFolder' => '<p>Creates an empty shared folder.</p>', 'CreateFolderMembership' => '<p>Adds an asset, such as a dashboard, analysis, or dataset into a folder.</p>', 'CreateGroup' => '<p>Use the <code>CreateGroup</code> operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact Amazon Web Services Support.</p> <p>The permissions resource is <code>arn:aws:quicksight:&lt;your-region&gt;:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.</p> <p>The response is a group object.</p>', 'CreateGroupMembership' => '<p>Adds an Amazon QuickSight user to an Amazon QuickSight group. </p>', 'CreateIAMPolicyAssignment' => '<p>Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.</p>', 'CreateIngestion' => '<p>Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.</p> <p>Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.</p>', 'CreateNamespace' => '<p>(Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.</p> <p>A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can\'t see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support. </p>', 'CreateRefreshSchedule' => '<p>Creates a refresh schedule for a dataset. You can create up to 5 different schedules for a single dataset.</p>', 'CreateRoleMembership' => '<p>Use <code>CreateRoleMembership</code> to add an existing Amazon QuickSight group to an existing role.</p>', 'CreateTemplate' => '<p>Creates a template either from a <code>TemplateDefinition</code> or from an existing Amazon QuickSight analysis or template. You can use the resulting template to create additional dashboards, templates, or analyses.</p> <p>A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p>', 'CreateTemplateAlias' => '<p>Creates a template alias for a template.</p>', 'CreateTheme' => '<p>Creates a theme.</p> <p>A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'CreateThemeAlias' => '<p>Creates a theme alias for a theme.</p>', 'CreateTopic' => '<p>Creates a new Q topic.</p>', 'CreateTopicRefreshSchedule' => '<p>Creates a topic refresh schedule.</p>', 'CreateVPCConnection' => '<p>Creates a new VPC connection.</p>', 'DeleteAccountCustomization' => '<p>Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.</p>', 'DeleteAccountSubscription' => '<p>Use the <code>DeleteAccountSubscription</code> operation to delete an Amazon QuickSight account. This operation will result in an error message if you have configured your account termination protection settings to <code>True</code>. To change this setting and delete your account, call the <code>UpdateAccountSettings</code> API and set the value of the <code>TerminationProtectionEnabled</code> parameter to <code>False</code>, then make another call to the <code>DeleteAccountSubscription</code> API.</p>', 'DeleteAnalysis' => '<p>Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don\'t specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.</p> <p>At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it\'s deleted, so you can describe it but you can\'t make a template from it.</p> <p>An analysis that\'s scheduled for deletion isn\'t accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn\'t delete the dashboards that you publish from it.</p>', 'DeleteDashboard' => '<p>Deletes a dashboard.</p>', 'DeleteDataSet' => '<p>Deletes a dataset.</p>', 'DeleteDataSetRefreshProperties' => '<p>Deletes the dataset refresh properties of the dataset.</p>', 'DeleteDataSource' => '<p>Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.</p>', 'DeleteFolder' => '<p>Deletes an empty folder.</p>', 'DeleteFolderMembership' => '<p>Removes an asset, such as a dashboard, analysis, or dataset, from a folder.</p>', 'DeleteGroup' => '<p>Removes a user group from Amazon QuickSight. </p>', 'DeleteGroupMembership' => '<p>Removes a user from a group so that the user is no longer a member of the group.</p>', 'DeleteIAMPolicyAssignment' => '<p>Deletes an existing IAM policy assignment.</p>', 'DeleteIdentityPropagationConfig' => '<p>Deletes all access scopes and authorized targets that are associated with a service from the Amazon QuickSight IAM Identity Center application.</p> <p>This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.</p>', 'DeleteNamespace' => '<p>Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset. </p>', 'DeleteRefreshSchedule' => '<p>Deletes a refresh schedule from a dataset.</p>', 'DeleteRoleCustomPermission' => '<p>Removes custom permissions from the role.</p>', 'DeleteRoleMembership' => '<p>Removes a group from a role.</p>', 'DeleteTemplate' => '<p>Deletes a template.</p>', 'DeleteTemplateAlias' => '<p>Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.</p>', 'DeleteTheme' => '<p>Deletes a theme.</p>', 'DeleteThemeAlias' => '<p>Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.</p>', 'DeleteTopic' => '<p>Deletes a topic.</p>', 'DeleteTopicRefreshSchedule' => '<p>Deletes a topic refresh schedule.</p>', 'DeleteUser' => '<p>Deletes the Amazon QuickSight user that is associated with the identity of the IAM user or role that\'s making the call. The IAM user isn\'t deleted as a result of this call. </p>', 'DeleteUserByPrincipalId' => '<p>Deletes a user identified by its principal ID. </p>', 'DeleteVPCConnection' => '<p>Deletes a VPC connection.</p>', 'DescribeAccountCustomization' => '<p>Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the <code>Resolved</code> flag included. </p> <p>To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved. </p> <ul> <li> <p> <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That\'s where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region. </p> </li> <li> <p> <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. </p> <p>To run the command in a different Amazon Web Services Region, you change your Region settings. If you\'re using the CLI, you can use one of the following options:</p> <ul> <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line options</a>. </p> </li> <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>. </p> </li> <li> <p>Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.</p> </li> </ul> </li> <li> <p> <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.</p> </li> <li> <p> <code>Applied customizations</code> - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the <code>CreateAccountCustomization</code> command in each Amazon Web Services Region where you want to apply the same customizations. </p> </li> </ul>', 'DescribeAccountSettings' => '<p>Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.</p>', 'DescribeAccountSubscription' => '<p>Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account\'s subscription. A successful API call returns an <code>AccountInfo</code> object that includes an account\'s name, subscription status, authentication type, edition, and notification email address.</p>', 'DescribeAnalysis' => '<p>Provides a summary of the metadata for an analysis.</p>', 'DescribeAnalysisDefinition' => '<p>Provides a detailed description of the definition of an analysis.</p> <note> <p>If you do not need to know details about the content of an Analysis, for instance if you are trying to check the status of a recently created or updated Analysis, use the <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html"> <code>DescribeAnalysis</code> </a> instead. </p> </note>', 'DescribeAnalysisPermissions' => '<p>Provides the read and write permissions for an analysis.</p>', 'DescribeAssetBundleExportJob' => '<p>Describes an existing export job.</p> <p>Poll job descriptions after a job starts to know the status of the job. When a job succeeds, a URL is provided to download the exported assets\' data from. Download URLs are valid for five minutes after they are generated. You can call the <code>DescribeAssetBundleExportJob</code> API for a new download URL as needed.</p> <p>Job descriptions are available for 14 days after the job starts.</p>', 'DescribeAssetBundleImportJob' => '<p>Describes an existing import job.</p> <p>Poll job descriptions after starting a job to know when it has succeeded or failed. Job descriptions are available for 14 days after job starts.</p>', 'DescribeDashboard' => '<p>Provides a summary for a dashboard.</p>', 'DescribeDashboardDefinition' => '<p>Provides a detailed description of the definition of a dashboard.</p> <note> <p>If you do not need to know details about the content of a dashboard, for instance if you are trying to check the status of a recently created or updated dashboard, use the <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html"> <code>DescribeDashboard</code> </a> instead. </p> </note>', 'DescribeDashboardPermissions' => '<p>Describes read and write permissions for a dashboard.</p>', 'DescribeDashboardSnapshotJob' => '<p>Describes an existing snapshot job.</p> <p>Poll job descriptions after a job starts to know the status of the job. For information on available status codes, see <code>JobStatus</code>.</p>', 'DescribeDashboardSnapshotJobResult' => '<p>Describes the result of an existing snapshot job that has finished running.</p> <p>A finished snapshot job will return a <code>COMPLETED</code> or <code>FAILED</code> status when you poll the job with a <code>DescribeDashboardSnapshotJob</code> API call.</p> <p>If the job has not finished running, this operation returns a message that says <code>Dashboard Snapshot Job with id &lt;SnapshotjobId&gt; has not reached a terminal state.</code>.</p>', 'DescribeDataSet' => '<p>Describes a dataset. This operation doesn\'t support datasets that include uploaded files as a source.</p>', 'DescribeDataSetPermissions' => '<p>Describes the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'DescribeDataSetRefreshProperties' => '<p>Describes the refresh properties of a dataset.</p>', 'DescribeDataSource' => '<p>Describes a data source.</p>', 'DescribeDataSourcePermissions' => '<p>Describes the resource permissions for a data source.</p>', 'DescribeFolder' => '<p>Describes a folder.</p>', 'DescribeFolderPermissions' => '<p>Describes permissions for a folder.</p>', 'DescribeFolderResolvedPermissions' => '<p>Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.</p>', 'DescribeGroup' => '<p>Returns an Amazon QuickSight group\'s description and Amazon Resource Name (ARN). </p>', 'DescribeGroupMembership' => '<p>Use the <code>DescribeGroupMembership</code> operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated <code>GroupMember</code> object is returned.</p>', 'DescribeIAMPolicyAssignment' => '<p>Describes an existing IAM policy assignment, as specified by the assignment name.</p>', 'DescribeIngestion' => '<p>Describes a SPICE ingestion.</p>', 'DescribeIpRestriction' => '<p>Provides a summary and status of IP rules.</p>', 'DescribeKeyRegistration' => '<p>Describes all customer managed key registrations in a Amazon QuickSight account.</p>', 'DescribeNamespace' => '<p>Describes the current namespace.</p>', 'DescribeRefreshSchedule' => '<p>Provides a summary of a refresh schedule.</p>', 'DescribeRoleCustomPermission' => '<p>Describes all custom permissions that are mapped to a role.</p>', 'DescribeTemplate' => '<p>Describes a template\'s metadata.</p>', 'DescribeTemplateAlias' => '<p>Describes the template alias for a template.</p>', 'DescribeTemplateDefinition' => '<p>Provides a detailed description of the definition of a template.</p> <note> <p>If you do not need to know details about the content of a template, for instance if you are trying to check the status of a recently created or updated template, use the <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html"> <code>DescribeTemplate</code> </a> instead. </p> </note>', 'DescribeTemplatePermissions' => '<p>Describes read and write permissions on a template.</p>', 'DescribeTheme' => '<p>Describes a theme.</p>', 'DescribeThemeAlias' => '<p>Describes the alias for a theme.</p>', 'DescribeThemePermissions' => '<p>Describes the read and write permissions for a theme.</p>', 'DescribeTopic' => '<p>Describes a topic.</p>', 'DescribeTopicPermissions' => '<p>Describes the permissions of a topic.</p>', 'DescribeTopicRefresh' => '<p>Describes the status of a topic refresh.</p>', 'DescribeTopicRefreshSchedule' => '<p>Deletes a topic refresh schedule.</p>', 'DescribeUser' => '<p>Returns information about a user, given the user name. </p>', 'DescribeVPCConnection' => '<p>Describes a VPC connection.</p>', 'GenerateEmbedUrlForAnonymousUser' => '<p>Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.</p> <p>The following rules apply to the generated URL:</p> <ul> <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li> <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.</p> </li> <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GenerateEmbedUrlForRegisteredUser' => '<p>Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.</p> <p>The following rules apply to the generated URL:</p> <ul> <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li> <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter.</p> <p>The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.</p> </li> <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GetDashboardEmbedUrl' => '<p>Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions. </p> <p>Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user\'s browser. The following rules apply to the generated URL:</p> <ul> <li> <p>They must be used together.</p> </li> <li> <p>They can be used one time only.</p> </li> <li> <p>They are valid for 5 minutes after you run this command.</p> </li> <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li> <li> <p>The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional <code>SessionLifetimeInMinutes</code> parameter to customize session duration.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GetSessionEmbedUrl' => '<p>Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> API operation. Use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> </p> </li> </ul>', 'ListAnalyses' => '<p>Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.</p>', 'ListAssetBundleExportJobs' => '<p>Lists all asset bundle export jobs that have been taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, <code>ListAssetBundleExportJobs</code> only returns the most recent job that uses the repeated job ID.</p>', 'ListAssetBundleImportJobs' => '<p>Lists all asset bundle import jobs that have taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, <code>ListAssetBundleImportJobs</code> only returns the most recent job that uses the repeated job ID.</p>', 'ListDashboardVersions' => '<p>Lists all the versions of the dashboards in the Amazon QuickSight subscription.</p>', 'ListDashboards' => '<p>Lists dashboards in an Amazon Web Services account.</p>', 'ListDataSets' => '<p>Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.</p>', 'ListDataSources' => '<p>Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.</p>', 'ListFolderMembers' => '<p>List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder. </p>', 'ListFolders' => '<p>Lists all folders in an account.</p>', 'ListGroupMemberships' => '<p>Lists member users in a group.</p>', 'ListGroups' => '<p>Lists all user groups in Amazon QuickSight. </p>', 'ListIAMPolicyAssignments' => '<p>Lists the IAM policy assignments in the current Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUser' => '<p>Lists all of the IAM policy assignments, including the Amazon Resource Names (ARNs), for the IAM policies assigned to the specified user and group, or groups that the user belongs to.</p>', 'ListIdentityPropagationConfigs' => '<p>Lists all services and authorized targets that the Amazon QuickSight IAM Identity Center application can access.</p> <p>This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.</p>', 'ListIngestions' => '<p>Lists the history of SPICE ingestions for a dataset.</p>', 'ListNamespaces' => '<p>Lists the namespaces for the specified Amazon Web Services account. This operation doesn\'t list deleted namespaces.</p>', 'ListRefreshSchedules' => '<p>Lists the refresh schedules of a dataset. Each dataset can have up to 5 schedules. </p>', 'ListRoleMemberships' => '<p>Lists all groups that are associated with a role.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'ListTemplateAliases' => '<p>Lists all the aliases of a template.</p>', 'ListTemplateVersions' => '<p>Lists all the versions of the templates in the current Amazon QuickSight account.</p>', 'ListTemplates' => '<p>Lists all the templates in the current Amazon QuickSight account.</p>', 'ListThemeAliases' => '<p>Lists all the aliases of a theme.</p>', 'ListThemeVersions' => '<p>Lists all the versions of the themes in the current Amazon Web Services account.</p>', 'ListThemes' => '<p>Lists all the themes in the current Amazon Web Services account.</p>', 'ListTopicRefreshSchedules' => '<p>Lists all of the refresh schedules for a topic.</p>', 'ListTopicReviewedAnswers' => '<p>Lists all reviewed answers for a Q Topic.</p>', 'ListTopics' => '<p>Lists all of the topics within an account.</p>', 'ListUserGroups' => '<p>Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.</p>', 'ListUsers' => '<p>Returns a list of all of the Amazon QuickSight users belonging to this account. </p>', 'ListVPCConnections' => '<p>Lists all of the VPC connections in the current set Amazon Web Services Region of an Amazon Web Services account.</p>', 'PutDataSetRefreshProperties' => '<p>Creates or updates the dataset refresh properties for the dataset.</p>', 'RegisterUser' => '<p>Creates an Amazon QuickSight user whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request. When you register a new user from the Amazon QuickSight API, Amazon QuickSight generates a registration URL. The user accesses this registration URL to create their account. Amazon QuickSight doesn\'t send a registration email to users who are registered from the Amazon QuickSight API. If you want new users to receive a registration email, then add those users in the Amazon QuickSight console. For more information on registering a new user in the Amazon QuickSight console, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users"> Inviting users to access Amazon QuickSight</a>.</p>', 'RestoreAnalysis' => '<p>Restores an analysis.</p>', 'SearchAnalyses' => '<p>Searches for analyses that belong to the user specified in the filter.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'SearchDashboards' => '<p>Searches for dashboards that belong to a user. </p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'SearchDataSets' => '<p>Use the <code>SearchDataSets</code> operation to search for datasets that belong to an account.</p>', 'SearchDataSources' => '<p>Use the <code>SearchDataSources</code> operation to search for data sources that belong to an account.</p>', 'SearchFolders' => '<p>Searches the subfolders in a folder.</p>', 'SearchGroups' => '<p>Use the <code>SearchGroups</code> operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.</p>', 'StartAssetBundleExportJob' => '<p>Starts an Asset Bundle export job.</p> <p>An Asset Bundle export job exports specified Amazon QuickSight assets. You can also choose to export any asset dependencies in the same job. Export jobs run asynchronously and can be polled with a <code>DescribeAssetBundleExportJob</code> API call. When a job is successfully completed, a download URL that contains the exported assets is returned. The URL is valid for 5 minutes and can be refreshed with a <code>DescribeAssetBundleExportJob</code> API call. Each Amazon QuickSight account can run up to 5 export jobs concurrently.</p> <p>The API caller must have the necessary permissions in their IAM role to access each resource before the resources can be exported.</p>', 'StartAssetBundleImportJob' => '<p>Starts an Asset Bundle import job.</p> <p>An Asset Bundle import job imports specified Amazon QuickSight assets into an Amazon QuickSight account. You can also choose to import a naming prefix and specified configuration overrides. The assets that are contained in the bundle file that you provide are used to create or update a new or existing asset in your Amazon QuickSight account. Each Amazon QuickSight account can run up to 5 import jobs concurrently.</p> <p>The API caller must have the necessary <code>"create"</code>, <code>"describe"</code>, and <code>"update"</code> permissions in their IAM role to access each resource type that is contained in the bundle file before the resources can be imported.</p>', 'StartDashboardSnapshotJob' => '<p>Starts an asynchronous job that generates a snapshot of a dashboard\'s output. You can request one or several of the following format configurations in each API call.</p> <ul> <li> <p>1 Paginated PDF</p> </li> <li> <p>1 Excel workbook that includes up to 5 table or pivot table visuals</p> </li> <li> <p>5 CSVs from table or pivot table visuals</p> </li> </ul> <p>The status of a submitted job can be polled with the <code>DescribeDashboardSnapshotJob</code> API. When you call the <code>DescribeDashboardSnapshotJob</code> API, check the <code>JobStatus</code> field in the response. Once the job reaches a <code>COMPLETED</code> or <code>FAILED</code> status, use the <code>DescribeDashboardSnapshotJobResult</code> API to obtain the URLs for the generated files. If the job fails, the <code>DescribeDashboardSnapshotJobResult</code> API returns detailed information about the error that occurred.</p> <p> <b>StartDashboardSnapshotJob API throttling</b> </p> <p>Amazon QuickSight utilizes API throttling to create a more consistent user experience within a time span for customers when they call the <code>StartDashboardSnapshotJob</code>. By default, 12 jobs can run simlutaneously in one Amazon Web Services account and users can submit up 10 API requests per second before an account is throttled. If an overwhelming number of API requests are made by the same user in a short period of time, Amazon QuickSight throttles the API calls to maintin an optimal experience and reliability for all Amazon QuickSight users.</p> <p> <b>Common throttling scenarios</b> </p> <p>The following list provides information about the most commin throttling scenarios that can occur.</p> <ul> <li> <p> <b>A large number of <code>SnapshotExport</code> API jobs are running simultaneously on an Amazon Web Services account.</b> When a new <code>StartDashboardSnapshotJob</code> is created and there are already 12 jobs with the <code>RUNNING</code> status, the new job request fails and returns a <code>LimitExceededException</code> error. Wait for a current job to comlpete before you resubmit the new job.</p> </li> <li> <p> <b>A large number of API requests are submitted on an Amazon Web Services account.</b> When a user makes more than 10 API calls to the Amazon QuickSight API in one second, a <code>ThrottlingException</code> is returned.</p> </li> </ul> <p>If your use case requires a higher throttling limit, contact your account admin or <a href="http://aws.amazon.com/contact-us/">Amazon Web ServicesSupport</a> to explore options to tailor a more optimal expereince for your account.</p> <p> <b>Best practices to handle throttling</b> </p> <p>If your use case projects high levels of API traffic, try to reduce the degree of frequency and parallelism of API calls as much as you can to avoid throttling. You can also perform a timing test to calculate an estimate for the total processing time of your projected load that stays within the throttling limits of the Amazon QuickSight APIs. For example, if your projected traffic is 100 snapshot jobs before 12:00 PM per day, start 12 jobs in parallel and measure the amount of time it takes to proccess all 12 jobs. Once you obtain the result, multiply the duration by 9, for example <code>(12 minutes * 9 = 108 minutes)</code>. Use the new result to determine the latest time at which the jobs need to be started to meet your target deadline.</p> <p>The time that it takes to process a job can be impacted by the following factors:</p> <ul> <li> <p>The dataset type (Direct Query or SPICE).</p> </li> <li> <p>The size of the dataset.</p> </li> <li> <p>The complexity of the calculated fields that are used in the dashboard.</p> </li> <li> <p>The number of visuals that are on a sheet.</p> </li> <li> <p>The types of visuals that are on the sheet.</p> </li> <li> <p>The number of formats and snapshots that are requested in the job configuration.</p> </li> <li> <p>The size of the generated snapshots.</p> </li> </ul>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource. </p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, template, topic, and user. </p> <p>Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:</p> <ul> <li> <p>Tags are used to track costs for users in Amazon QuickSight. You can\'t tag other resources that Amazon QuickSight costs are based on, such as storage capacoty (SPICE), session usage, alert consumption, or reporting units.</p> </li> <li> <p>Amazon QuickSight doesn\'t currently support the tag editor for Resource Groups.</p> </li> </ul>', 'UntagResource' => '<p>Removes a tag or tags from a resource.</p>', 'UpdateAccountCustomization' => '<p>Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.</p> <p>You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation. </p>', 'UpdateAccountSettings' => '<p>Updates the Amazon QuickSight settings in your Amazon Web Services account.</p>', 'UpdateAnalysis' => '<p>Updates an analysis in Amazon QuickSight</p>', 'UpdateAnalysisPermissions' => '<p>Updates the read and write permissions for an analysis.</p>', 'UpdateDashboard' => '<p>Updates a dashboard in an Amazon Web Services account.</p> <note> <p>Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> </code> API operation.</p> </note>', 'UpdateDashboardLinks' => '<p>Updates the linked analyses on a dashboard.</p>', 'UpdateDashboardPermissions' => '<p>Updates read and write permissions on a dashboard.</p>', 'UpdateDashboardPublishedVersion' => '<p>Updates the published version of a dashboard.</p>', 'UpdateDataSet' => '<p>Updates a dataset. This operation doesn\'t support datasets that include uploaded files as a source. Partial updates are not supported by this operation.</p>', 'UpdateDataSetPermissions' => '<p>Updates the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'UpdateDataSource' => '<p>Updates a data source.</p>', 'UpdateDataSourcePermissions' => '<p>Updates the permissions to a data source.</p>', 'UpdateFolder' => '<p>Updates the name of a folder.</p>', 'UpdateFolderPermissions' => '<p>Updates permissions of a folder.</p>', 'UpdateGroup' => '<p>Changes a group description. </p>', 'UpdateIAMPolicyAssignment' => '<p>Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in <code>Identities</code>. </p>', 'UpdateIdentityPropagationConfig' => '<p>Adds or updates services and authorized targets to configure what the Amazon QuickSight IAM Identity Center application can access.</p> <p>This operation is only supported for Amazon QuickSight accounts using IAM Identity Center</p>', 'UpdateIpRestriction' => '<p>Updates the content and status of IP rules. Traffic from a source is allowed when the source satisfies either the <code>IpRestrictionRule</code>, <code>VpcIdRestrictionRule</code>, or <code>VpcEndpointIdRestrictionRule</code>. To use this operation, you must provide the entire map of rules. You can use the <code>DescribeIpRestriction</code> operation to get the current rule map.</p>', 'UpdateKeyRegistration' => '<p>Updates a customer managed key in a Amazon QuickSight account.</p>', 'UpdatePublicSharingSettings' => '<p>Use the <code>UpdatePublicSharingSettings</code> operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.</p> <p>To use this operation, turn on session capacity pricing for your Amazon QuickSight account.</p> <p>Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html">Using Amazon QuickSight with IAM</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'UpdateRefreshSchedule' => '<p>Updates a refresh schedule for a dataset.</p>', 'UpdateRoleCustomPermission' => '<p>Updates the custom permissions that are associated with a role.</p>', 'UpdateSPICECapacityConfiguration' => '<p>Updates the SPICE capacity configuration for a Amazon QuickSight account.</p>', 'UpdateTemplate' => '<p>Updates a template from an existing Amazon QuickSight analysis or another template.</p>', 'UpdateTemplateAlias' => '<p>Updates the template alias of a template.</p>', 'UpdateTemplatePermissions' => '<p>Updates the resource permissions for a template.</p>', 'UpdateTheme' => '<p>Updates a theme.</p>', 'UpdateThemeAlias' => '<p>Updates an alias of a theme.</p>', 'UpdateThemePermissions' => '<p>Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example <code>"quicksight:DescribeTheme"</code>.</p> <p>Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions: </p> <ul> <li> <p>User</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> </ul> </li> <li> <p>Owner</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> <li> <p> <code>"quicksight:DeleteTheme"</code> </p> </li> <li> <p> <code>"quicksight:UpdateTheme"</code> </p> </li> <li> <p> <code>"quicksight:CreateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:DeleteThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemePermissions"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemePermissions"</code> </p> </li> </ul> </li> <li> <p>To specify no permissions, omit the permissions list.</p> </li> </ul>', 'UpdateTopic' => '<p>Updates a topic.</p>', 'UpdateTopicPermissions' => '<p>Updates the permissions of a topic.</p>', 'UpdateTopicRefreshSchedule' => '<p>Updates a topic refresh schedule.</p>', 'UpdateUser' => '<p>Updates an Amazon QuickSight user.</p>', 'UpdateVPCConnection' => '<p>Updates a VPC connection.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have access to this item. The provided credentials couldn\'t be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct credentials.</p>', 'refs' => [], ], 'AccountCustomization' => [ 'base' => '<p>The Amazon QuickSight customizations associated with your Amazon Web Services account or a QuickSight namespace in a specific Amazon Web Services Region.</p>', 'refs' => [ 'CreateAccountCustomizationRequest$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p> <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>', 'CreateAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re adding in the current Amazon Web Services Region. </p>', 'DescribeAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>', 'UpdateAccountCustomizationRequest$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re updating in the current Amazon Web Services Region. </p>', 'UpdateAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re updating in the current Amazon Web Services Region. </p>', ], ], 'AccountInfo' => [ 'base' => '<p>A structure that contains the following account information elements:</p> <ul> <li> <p>Your Amazon QuickSight account name.</p> </li> <li> <p>The edition of Amazon QuickSight that your account is using.</p> </li> <li> <p>The notification email address that is associated with the Amazon QuickSight account. </p> </li> <li> <p>The authentication type of the Amazon QuickSight account.</p> </li> <li> <p>The status of the Amazon QuickSight account\'s subscription.</p> </li> </ul>', 'refs' => [ 'DescribeAccountSubscriptionResponse$AccountInfo' => '<p>A structure that contains the following elements:</p> <ul> <li> <p>Your Amazon QuickSight account name.</p> </li> <li> <p>The edition of Amazon QuickSight that your account is using.</p> </li> <li> <p>The notification email address that is associated with the Amazon QuickSight account. </p> </li> <li> <p>The authentication type of the Amazon QuickSight account.</p> </li> <li> <p>The status of the Amazon QuickSight account\'s subscription.</p> </li> </ul>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'CreateAccountSubscriptionRequest$AccountName' => '<p>The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears only when users sign in. You can\'t change <code>AccountName</code> value after the Amazon QuickSight account is created.</p>', ], ], 'AccountSettings' => [ 'base' => '<p>The Amazon QuickSight settings associated with your Amazon Web Services account.</p>', 'refs' => [ 'DescribeAccountSettingsResponse$AccountSettings' => '<p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. </p> <p>In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it\'s technically not an account by itself. Instead, it\'s a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleResourcePermissions$Actions' => '<p>A list of IAM actions to grant permissions on.</p>', 'ResourcePermission$Actions' => '<p>The IAM action to grant or revoke permissions on.</p>', ], ], 'ActiveIAMPolicyAssignment' => [ 'base' => '<p>The active Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'ActiveIAMPolicyAssignmentList$member' => NULL, ], ], 'ActiveIAMPolicyAssignmentList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsForUserResponse$ActiveAssignments' => '<p>The active assignments for this user.</p>', ], ], 'AdHocFilteringOption' => [ 'base' => '<p>An ad hoc (one-time) filtering option.</p>', 'refs' => [ 'DashboardPublishOptions$AdHocFilteringOption' => '<p>Ad hoc (one-time) filtering option.</p>', ], ], 'AdditionalDashboardIdList' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$AdditionalDashboardIds' => '<p>A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently, the <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards.</p>', ], ], 'AggFunction' => [ 'base' => '<p>The definition of an Agg function.</p>', 'refs' => [ 'TopicIRMetric$Function' => '<p>The function for the <code>TopicIRMetric</code>.</p>', ], ], 'AggFunctionParamKey' => [ 'base' => NULL, 'refs' => [ 'AggFunctionParamMap$key' => NULL, ], ], 'AggFunctionParamMap' => [ 'base' => NULL, 'refs' => [ 'AggFunction$AggregationFunctionParameters' => '<p>The aggregation parameters for an Agg function.</p>', 'TopicIRFilterOption$AggregationFunctionParameters' => '<p>The aggregation function parameters for the <code>TopicIRFilterOption</code>.</p>', ], ], 'AggFunctionParamValue' => [ 'base' => NULL, 'refs' => [ 'AggFunctionParamMap$value' => NULL, ], ], 'AggType' => [ 'base' => NULL, 'refs' => [ 'AggFunction$Aggregation' => '<p>The aggregation of an Agg function.</p>', 'FilterAggMetrics$Function' => '<p>The function for the <code>FilterAggMetrics</code>.</p>', 'TopicIRFilterOption$Aggregation' => '<p>The aggregation for the <code>TopicIRFilterOption</code>.</p>', ], ], 'AggregationFunction' => [ 'base' => '<p>An aggregation function aggregates values from a dimension or measure.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'AggregationSortConfiguration$AggregationFunction' => '<p>The function that aggregates the values in <code>Column</code>.</p>', 'ColumnSort$AggregationFunction' => '<p>The aggregation function that is defined in the column sort.</p>', 'ColumnTooltipItem$Aggregation' => '<p>The aggregation function of the column tooltip item.</p>', 'NumericEqualityFilter$AggregationFunction' => '<p>The aggregation function of the filter.</p>', 'NumericRangeFilter$AggregationFunction' => '<p>The aggregation function of the filter.</p>', 'ReferenceLineDynamicDataConfiguration$MeasureAggregationFunction' => '<p>The aggregation function that is used in the dynamic data.</p>', ], ], 'AggregationFunctionParameters' => [ 'base' => NULL, 'refs' => [ 'NamedEntityDefinitionMetric$AggregationFunctionParameters' => '<p>The additional parameters for an aggregation function.</p>', ], ], 'AggregationPartitionBy' => [ 'base' => '<p>The definition of an <code>AggregationPartitionBy</code>.</p>', 'refs' => [ 'AggregationPartitionByList$member' => NULL, ], ], 'AggregationPartitionByList' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterOption$AggregationPartitionBy' => '<p>The <code>AggregationPartitionBy</code> for the <code>TopicIRFilterOption</code>.</p>', ], ], 'AggregationSortConfiguration' => [ 'base' => '<p>The configuration options to sort aggregated values.</p>', 'refs' => [ 'AggregationSortConfigurationList$member' => NULL, ], ], 'AggregationSortConfigurationList' => [ 'base' => NULL, 'refs' => [ 'TopBottomFilter$AggregationSortConfigurations' => '<p>The aggregation and sort configuration of the top bottom filter.</p>', ], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$AliasName' => '<p>The name that you want to give to the template alias that you\'re creating. Don\'t start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>', 'CreateThemeAliasRequest$AliasName' => '<p>The name that you want to give to the theme alias that you are creating. The alias name can\'t begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>', 'DeleteTemplateAliasRequest$AliasName' => '<p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>', 'DeleteTemplateAliasResponse$AliasName' => '<p>The name for the template alias.</p>', 'DeleteThemeAliasRequest$AliasName' => '<p>The unique name for the theme alias to delete.</p>', 'DeleteThemeAliasResponse$AliasName' => '<p>The name for the theme alias.</p>', 'DescribeDashboardDefinitionRequest$AliasName' => '<p>The alias name.</p>', 'DescribeDashboardRequest$AliasName' => '<p>The alias name.</p>', 'DescribeTemplateAliasRequest$AliasName' => '<p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeTemplateDefinitionRequest$AliasName' => '<p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeTemplateRequest$AliasName' => '<p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to describe.</p>', 'DescribeThemeRequest$AliasName' => '<p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to themes.</p>', 'TemplateAlias$AliasName' => '<p>The display name of the template alias.</p>', 'ThemeAlias$AliasName' => '<p>The display name of the theme alias.</p>', 'UpdateTemplateAliasRequest$AliasName' => '<p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'UpdateThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to update.</p>', ], ], 'AllSheetsFilterScopeConfiguration' => [ 'base' => '<p>An empty object that represents that the <code>AllSheets</code> option is the chosen value for the <code>FilterScopeConfiguration</code> parameter. This structure applies the filter to all visuals on all sheets of an Analysis, Dashboard, or Template.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterScopeConfiguration$AllSheets' => '<p>The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.</p>', ], ], 'AmazonElasticsearchParameters' => [ 'base' => '<p>The parameters for OpenSearch.</p>', 'refs' => [ 'DataSourceParameters$AmazonElasticsearchParameters' => '<p>The parameters for OpenSearch.</p>', ], ], 'AmazonOpenSearchParameters' => [ 'base' => '<p>The parameters for OpenSearch.</p>', 'refs' => [ 'DataSourceParameters$AmazonOpenSearchParameters' => '<p>The parameters for OpenSearch.</p>', ], ], 'Analysis' => [ 'base' => '<p>Metadata structure for an analysis in Amazon QuickSight</p>', 'refs' => [ 'DescribeAnalysisResponse$Analysis' => '<p>A metadata structure that contains summary information for the analysis that you\'re describing.</p>', ], ], 'AnalysisDefaults' => [ 'base' => '<p>The configuration for default analysis settings.</p>', 'refs' => [ 'AnalysisDefinition$AnalysisDefaults' => NULL, 'DashboardVersionDefinition$AnalysisDefaults' => NULL, 'TemplateVersionDefinition$AnalysisDefaults' => NULL, ], ], 'AnalysisDefinition' => [ 'base' => '<p>The definition of an analysis.</p>', 'refs' => [ 'CreateAnalysisRequest$Definition' => '<p>The definition of an analysis.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'DescribeAnalysisDefinitionResponse$Definition' => '<p>The definition of an analysis.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', 'UpdateAnalysisRequest$Definition' => '<p>The definition of an analysis.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', ], ], 'AnalysisError' => [ 'base' => '<p>Analysis error.</p>', 'refs' => [ 'AnalysisErrorList$member' => NULL, ], ], 'AnalysisErrorList' => [ 'base' => NULL, 'refs' => [ 'Analysis$Errors' => '<p>Errors associated with the analysis.</p>', 'DescribeAnalysisDefinitionResponse$Errors' => '<p>Errors associated with the analysis.</p>', ], ], 'AnalysisErrorType' => [ 'base' => NULL, 'refs' => [ 'AnalysisError$Type' => '<p>The type of the analysis error.</p>', ], ], 'AnalysisFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'AnalysisSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_OWNER"</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of the analysis\' owners or viewers are returned. Implicit permissions from folders or groups are considered. </p> </li> <li> <p> <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as the only owner of the analysis are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of the owners or viewers of the analyses are returned. Implicit permissions from folders or groups are not considered. </p> </li> <li> <p> <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be returned.</p> </li> </ul>', ], ], 'AnalysisName' => [ 'base' => NULL, 'refs' => [ 'Analysis$Name' => '<p>The descriptive name of the analysis.</p>', 'AnalysisSummary$Name' => '<p>The name of the analysis. This name is displayed in the Amazon QuickSight console. </p>', 'CreateAnalysisRequest$Name' => '<p>A descriptive name for the analysis that you\'re creating. This name displays for the analysis in the Amazon QuickSight console. </p>', 'DescribeAnalysisDefinitionResponse$Name' => '<p>The descriptive name of the analysis.</p>', 'UpdateAnalysisRequest$Name' => '<p>A descriptive name for the analysis that you\'re updating. This name displays for the analysis in the Amazon QuickSight console.</p>', ], ], 'AnalysisSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for one or more analyses.</p>', 'refs' => [ 'AnalysisSearchFilterList$member' => NULL, ], ], 'AnalysisSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchAnalysesRequest$Filters' => '<p>The structure for the search filters that you want to apply to your search. </p>', ], ], 'AnalysisSourceEntity' => [ 'base' => '<p>The source entity of an analysis.</p>', 'refs' => [ 'CreateAnalysisRequest$SourceEntity' => '<p>A source entity to use for the analysis that you\'re creating. This metadata structure contains details that describe a source template and one or more datasets.</p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'UpdateAnalysisRequest$SourceEntity' => '<p>A source entity to use for the analysis that you\'re updating. This metadata structure contains details that describe a source template and one or more datasets.</p>', ], ], 'AnalysisSourceTemplate' => [ 'base' => '<p>The source template of an analysis.</p>', 'refs' => [ 'AnalysisSourceEntity$SourceTemplate' => '<p>The source template for the source entity of the analysis.</p>', ], ], 'AnalysisSummary' => [ 'base' => '<p>The summary metadata that describes an analysis.</p>', 'refs' => [ 'AnalysisSummaryList$member' => NULL, ], ], 'AnalysisSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnalysesResponse$AnalysisSummaryList' => '<p>Metadata describing each of the analyses that are listed.</p>', 'SearchAnalysesResponse$AnalysisSummaryList' => '<p>Metadata describing the analyses that you searched for.</p>', ], ], 'Anchor' => [ 'base' => '<p>The definition of the Anchor.</p>', 'refs' => [ 'TopicIRFilterOption$Anchor' => '<p>The anchor for the <code>TopicIRFilterOption</code>.</p>', ], ], 'AnchorDateConfiguration' => [ 'base' => '<p>The date configuration of the filter.</p>', 'refs' => [ 'RelativeDatesFilter$AnchorDateConfiguration' => '<p>The date configuration of the filter.</p>', ], ], 'AnchorOption' => [ 'base' => NULL, 'refs' => [ 'AnchorDateConfiguration$AnchorOption' => '<p>The options for the date configuration. Choose one of the options below:</p> <ul> <li> <p> <code>NOW</code> </p> </li> </ul>', ], ], 'AnchorType' => [ 'base' => NULL, 'refs' => [ 'Anchor$AnchorType' => '<p>The <code>AnchorType</code> for the Anchor.</p>', ], ], 'AnonymousUserDashboardEmbeddingConfiguration' => [ 'base' => '<p>Information about the dashboard that you want to embed.</p>', 'refs' => [ 'AnonymousUserEmbeddingExperienceConfiguration$Dashboard' => '<p>The type of embedding experience. In this case, Amazon QuickSight dashboards.</p>', ], ], 'AnonymousUserDashboardEmbeddingConfigurationDisabledFeature' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserDashboardEmbeddingConfigurationDisabledFeatures$member' => NULL, ], ], 'AnonymousUserDashboardEmbeddingConfigurationDisabledFeatures' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserDashboardEmbeddingConfiguration$DisabledFeatures' => '<p>A list of all disabled features of a specified anonymous dashboard.</p>', ], ], 'AnonymousUserDashboardEmbeddingConfigurationEnabledFeature' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserDashboardEmbeddingConfigurationEnabledFeatures$member' => NULL, ], ], 'AnonymousUserDashboardEmbeddingConfigurationEnabledFeatures' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserDashboardEmbeddingConfiguration$EnabledFeatures' => '<p>A list of all enabled features of a specified anonymous dashboard.</p>', ], ], 'AnonymousUserDashboardFeatureConfigurations' => [ 'base' => '<p>The feature configuration for an embedded dashboard.</p>', 'refs' => [ 'AnonymousUserDashboardEmbeddingConfiguration$FeatureConfigurations' => '<p>The feature configuration for an embedded dashboard.</p>', ], ], 'AnonymousUserDashboardVisualEmbeddingConfiguration' => [ 'base' => '<p>The experience that you are embedding. You can use this object to generate a url that embeds a visual into your application.</p>', 'refs' => [ 'AnonymousUserEmbeddingExperienceConfiguration$DashboardVisual' => '<p>The type of embedding experience. In this case, Amazon QuickSight visuals.</p>', ], ], 'AnonymousUserEmbeddingExperienceConfiguration' => [ 'base' => '<p>The type of experience you want to embed. For anonymous users, you can embed Amazon QuickSight dashboards.</p>', 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$ExperienceConfiguration' => '<p>The configuration of the experience that you are embedding.</p>', ], ], 'AnonymousUserGenerativeQnAEmbeddingConfiguration' => [ 'base' => '<p>The settings that you want to use for the Generative Q&amp;A experience.</p>', 'refs' => [ 'AnonymousUserEmbeddingExperienceConfiguration$GenerativeQnA' => '<p>The Generative Q&amp;A experience that you want to use for anonymous user embedding.</p>', ], ], 'AnonymousUserQSearchBarEmbeddingConfiguration' => [ 'base' => '<p>The settings that you want to use with the Q search bar.</p>', 'refs' => [ 'AnonymousUserEmbeddingExperienceConfiguration$QSearchBar' => '<p>The Q search bar that you want to use for anonymous user embedding.</p>', ], ], 'AnonymousUserSnapshotJobResult' => [ 'base' => '<p>A structure that contains the file groups that are requested for the artifact generation in a <code>StartDashboardSnapshotJob</code> API call. </p>', 'refs' => [ 'AnonymousUserSnapshotJobResultList$member' => NULL, ], ], 'AnonymousUserSnapshotJobResultList' => [ 'base' => NULL, 'refs' => [ 'SnapshotJobResult$AnonymousUsers' => '<p> A list of <code>AnonymousUserSnapshotJobResult</code> objects that contain information on anonymous users and their user configurations. This data provided by you when you make a <code>StartDashboardSnapshotJob</code> API call.</p>', ], ], 'AnswerId' => [ 'base' => NULL, 'refs' => [ 'AnswerIds$member' => NULL, 'CreateTopicReviewedAnswer$AnswerId' => '<p>The answer ID for the <code>CreateTopicReviewedAnswer</code>.</p>', 'InvalidTopicReviewedAnswer$AnswerId' => '<p>The answer ID for the <code>InvalidTopicReviewedAnswer</code>.</p>', 'SucceededTopicReviewedAnswer$AnswerId' => '<p>The answer ID for the <code>SucceededTopicReviewedAnswer</code>.</p>', 'TopicReviewedAnswer$AnswerId' => '<p>The answer ID of the reviewed answer.</p>', ], ], 'AnswerIds' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTopicReviewedAnswerRequest$AnswerIds' => '<p>The Answer IDs of the Answers to be deleted.</p>', ], ], 'ArcAxisConfiguration' => [ 'base' => '<p>The arc axis configuration of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartOptions$ArcAxis' => '<p>The arc axis configuration of a <code>GaugeChartVisual</code>.</p>', ], ], 'ArcAxisDisplayRange' => [ 'base' => '<p>The arc axis range of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'ArcAxisConfiguration$Range' => '<p>The arc axis range of a <code>GaugeChartVisual</code>.</p>', ], ], 'ArcConfiguration' => [ 'base' => '<p>The arc configuration of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartOptions$Arc' => '<p>The arc configuration of a <code>GaugeChartVisual</code>.</p>', ], ], 'ArcOptions' => [ 'base' => '<p>The options that determine the arc thickness of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'DonutOptions$ArcOptions' => '<p>The option for define the arc of the chart shape. Valid values are as follows:</p> <ul> <li> <p> <code>WHOLE</code> - A pie chart</p> </li> <li> <p> <code>SMALL</code>- A small-sized donut chart</p> </li> <li> <p> <code>MEDIUM</code>- A medium-sized donut chart</p> </li> <li> <p> <code>LARGE</code>- A large-sized donut chart</p> </li> </ul>', ], ], 'ArcThickness' => [ 'base' => NULL, 'refs' => [ 'ArcOptions$ArcThickness' => '<p>The arc thickness of a <code>GaugeChartVisual</code>.</p>', ], ], 'ArcThicknessOptions' => [ 'base' => NULL, 'refs' => [ 'ArcConfiguration$ArcThickness' => '<p>The options that determine the arc thickness of a <code>GaugeChartVisual</code>.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AccountCustomization$DefaultTheme' => '<p>The default theme for this Amazon QuickSight subscription.</p>', 'AccountCustomization$DefaultEmailCustomizationTemplate' => '<p>The default email customization template.</p>', 'ActiveIAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'Analysis$Arn' => '<p>The Amazon Resource Name (ARN) of the analysis.</p>', 'Analysis$ThemeArn' => '<p>The ARN of the theme of the analysis.</p>', 'AnalysisSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>', 'AnalysisSummary$Arn' => '<p>The Amazon Resource Name (ARN) for the analysis.</p>', 'ArnList$member' => NULL, 'AssetBundleExportJobAnalysisOverrideProperties$Arn' => '<p>The ARN of the specific <code>Analysis</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobDashboardOverrideProperties$Arn' => '<p>The ARN of the specific <code>Dashboard</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobDataSetOverrideProperties$Arn' => '<p>The ARN of the specific <code>DataSet</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobDataSourceOverrideProperties$Arn' => '<p>The ARN of the specific <code>DataSource</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobError$Arn' => '<p>The ARN of the resource whose processing caused an error.</p>', 'AssetBundleExportJobRefreshScheduleOverrideProperties$Arn' => '<p>The ARN of the specific <code>RefreshSchedule</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobSummary$Arn' => '<p>The ARN of the export job.</p>', 'AssetBundleExportJobThemeOverrideProperties$Arn' => '<p>The ARN of the specific <code>Theme</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobVPCConnectionOverrideProperties$Arn' => '<p>The ARN of the specific <code>VPCConnection</code> resource whose override properties are configured in this structure.</p>', 'AssetBundleExportJobWarning$Arn' => '<p>The ARN of the resource whose processing caused a warning.</p>', 'AssetBundleImportJobError$Arn' => '<p>The ARN of the resource whose processing caused an error.</p>', 'AssetBundleImportJobSummary$Arn' => '<p>The ARN of the import job.</p>', 'AssetBundleImportJobWarning$Arn' => '<p>The ARN of the resource that the warning occurred for.</p>', 'AssetBundleResourceArns$member' => NULL, 'BatchCreateTopicReviewedAnswerResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'BatchDeleteTopicReviewedAnswerResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'CancelIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>', 'CreateAnalysisRequest$ThemeArn' => '<p>The ARN for the theme to apply to the analysis that you\'re creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>', 'CreateAnalysisResponse$Arn' => '<p>The ARN for the analysis.</p>', 'CreateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>', 'CreateDashboardResponse$Arn' => '<p>The ARN of the dashboard.</p>', 'CreateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number of the first version that is created.</p>', 'CreateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'CreateFolderRequest$ParentFolderArn' => '<p>The Amazon Resource Name (ARN) for the parent folder.</p> <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>', 'CreateFolderResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the newly created folder.</p>', 'CreateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>', 'CreateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>', 'CreateIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateNamespaceResponse$Arn' => '<p>The ARN of the Amazon QuickSight namespace you created. </p>', 'CreateRefreshScheduleResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the refresh schedule.</p>', 'CreateTemplateResponse$Arn' => '<p>The ARN for the template.</p>', 'CreateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'CreateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'CreateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new theme.</p>', 'CreateTopicRefreshScheduleRequest$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateTopicRefreshScheduleResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'CreateTopicRefreshScheduleResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateTopicResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'CreateTopicResponse$RefreshArn' => '<p>The Amazon Resource Name (ARN) of the topic refresh.</p>', 'CreateTopicReviewedAnswer$DatasetArn' => '<p>The Dataset arn for the <code>CreateTopicReviewedAnswer</code>.</p>', 'CreateVPCConnectionResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'CustomSql$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'Dashboard$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DashboardVersion$ThemeArn' => '<p>The ARN of the theme associated with a version of the dashboard.</p>', 'DashboardVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersionSummary$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DataSetArnsList$member' => NULL, 'DataSetIdentifierDeclaration$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the data set.</p>', 'DataSetReference$DataSetArn' => '<p>Dataset Amazon Resource Name (ARN).</p>', 'DataSetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DataSource$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DataSourceSummary$Arn' => '<p>The arn of the datasource.</p>', 'DatasetMetadata$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteAnalysisResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the deleted analysis.</p>', 'DeleteDashboardResponse$Arn' => '<p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>', 'DeleteDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>', 'DeleteFolderResponse$Arn' => '<p>The Amazon Resource Name of the deleted folder.</p>', 'DeleteRefreshScheduleResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the refresh schedule.</p>', 'DeleteTemplateAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the template you want to delete.</p>', 'DeleteTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DeleteThemeAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>', 'DeleteThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DeleteTopicRefreshScheduleResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'DeleteTopicRefreshScheduleResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteTopicResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'DeleteVPCConnectionResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the deleted VPC connection.</p>', 'DescribeAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the customization that\'s associated with this Amazon Web Services account.</p>', 'DescribeAnalysisDefinitionResponse$ThemeArn' => '<p>The ARN of the theme of the analysis.</p>', 'DescribeAnalysisPermissionsResponse$AnalysisArn' => '<p>The Amazon Resource Name (ARN) of the analysis whose permissions you\'re describing.</p>', 'DescribeAssetBundleExportJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the export job.</p>', 'DescribeAssetBundleImportJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the import job.</p>', 'DescribeDashboardDefinitionResponse$ThemeArn' => '<p>The ARN of the theme of the dashboard.</p>', 'DescribeDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'DescribeDashboardSnapshotJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'DescribeDashboardSnapshotJobResultResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'DescribeDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DescribeFolderPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the folder.</p>', 'DescribeFolderResolvedPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the folder.</p>', 'DescribeRefreshScheduleResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the refresh schedule.</p>', 'DescribeTemplateDefinitionResponse$ThemeArn' => '<p>The ARN of the theme of the template.</p>', 'DescribeTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'DescribeThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'DescribeTopicPermissionsResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'DescribeTopicRefreshScheduleResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'DescribeTopicRefreshScheduleResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeTopicResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'Folder$Arn' => '<p>The Amazon Resource Name (ARN) for the folder.</p>', 'FolderArnList$member' => NULL, 'FolderSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the folder.</p>', 'GenerateEmbedUrlForAnonymousUserResponse$AnonymousUserArn' => '<p>The Amazon Resource Name (ARN) to use for the anonymous Amazon QuickSight user.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$UserArn' => '<p>The Amazon Resource Name for the registered user.</p>', 'GetDashboardEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p> <ul> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li> </ul> <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>', 'GetSessionEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p> <ol> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li> </ol> <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>', 'Group$Arn' => '<p>The Amazon Resource Name (ARN) for the group.</p>', 'GroupMember$Arn' => '<p>The Amazon Resource Name (ARN) for the group member (user).</p>', 'IAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) for the IAM policy.</p>', 'Ingestion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>', 'ListTopicRefreshSchedulesResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'ListTopicReviewedAnswersResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'LogicalTableSource$DataSetArn' => '<p>The Amazon Resource Number (ARN) of the parent dataset.</p>', 'MemberIdArnPair$MemberArn' => '<p>The Amazon Resource Name (ARN) of the member.</p>', 'NamespaceInfoV2$Arn' => '<p>The namespace ARN.</p>', 'Path$member' => NULL, 'RefreshSchedule$Arn' => '<p>The Amazon Resource Name (ARN) for the refresh schedule.</p>', 'RelationalTable$DataSourceArn' => '<p>The Amazon Resource Name (ARN) for the data source.</p>', 'RestoreAnalysisResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the analysis that you\'re restoring.</p>', 'RowLevelPermissionDataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>', 'S3Source$DataSourceArn' => '<p>The Amazon Resource Name (ARN) for the data source.</p>', 'StartAssetBundleExportJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the export job.</p>', 'StartAssetBundleImportJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the import job.</p>', 'StartDashboardSnapshotJobResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the dashboard snapshot job.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'Template$Arn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'TemplateAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the template alias.</p>', 'TemplateSourceAnalysis$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSummary$Arn' => '<p>A summary of a template.</p>', 'TemplateVersion$SourceEntityArn' => '<p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this template.</p>', 'TemplateVersion$ThemeArn' => '<p>The ARN of the theme associated with this version of the template.</p>', 'TemplateVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the template version.</p>', 'Theme$Arn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'ThemeAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the theme alias.</p>', 'ThemeSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the theme version.</p>', 'TopicRefreshDetails$RefreshArn' => '<p>The Amazon Resource Name (ARN) of the topic refresh.</p>', 'TopicRefreshScheduleSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'TopicReviewedAnswer$Arn' => '<p>The Amazon Resource Name (ARN) of the reviewed answer.</p>', 'TopicReviewedAnswer$DatasetArn' => '<p>The Dataset ARN for the <code>TopicReviewedAnswer</code>.</p>', 'TopicSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>', 'UpdateAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>', 'UpdateAnalysisPermissionsResponse$AnalysisArn' => '<p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>', 'UpdateAnalysisRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you\'re creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>', 'UpdateAnalysisResponse$Arn' => '<p>The ARN of the analysis that you\'re updating.</p>', 'UpdateDashboardLinksResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>', 'UpdateDashboardResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number.</p>', 'UpdateDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateFolderPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the folder.</p>', 'UpdateFolderResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the folder.</p>', 'UpdateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>', 'UpdateRefreshScheduleResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the refresh schedule.</p>', 'UpdateTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'UpdateTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the template.</p>', 'UpdateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'UpdateThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'UpdateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'UpdateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new version of the theme.</p>', 'UpdateTopicPermissionsResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'UpdateTopicRefreshScheduleResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'UpdateTopicRefreshScheduleResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateTopicResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the topic.</p>', 'UpdateTopicResponse$RefreshArn' => '<p>The Amazon Resource Name (ARN) of the topic refresh.</p>', 'UpdateVPCConnectionResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) for the user.</p>', 'VPCConnection$Arn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'VPCConnectionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the VPC connection.</p>', 'VpcConnectionProperties$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) for the VPC connection.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$AuthorizedResourceArns' => '<p>The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session.</p> <p>If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p> <p>If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the anonymous users need access to.</p> <p>Currently, you can pass up to 25 theme ARNs in each API call.</p>', ], ], 'AssetBundleCloudFormationOverridePropertyConfiguration' => [ 'base' => '<p>An optional collection of CloudFormation property configurations that control how the export job is generated.</p>', 'refs' => [ 'DescribeAssetBundleExportJobResponse$CloudFormationOverridePropertyConfiguration' => '<p>The CloudFormation override property configuration for the export job.</p>', 'StartAssetBundleExportJobRequest$CloudFormationOverridePropertyConfiguration' => '<p>An optional collection of structures that generate CloudFormation parameters to override the existing resource property values when the resource is exported to a new CloudFormation template.</p> <p>Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API call is set to <code>CLOUDFORMATION_JSON</code>.</p>', ], ], 'AssetBundleExportFormat' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobSummary$ExportFormat' => '<p>The format for the export job.</p>', 'DescribeAssetBundleExportJobResponse$ExportFormat' => '<p>The format of the exported asset bundle. A <code>QUICKSIGHT_JSON</code> formatted file can be used to make a <code>StartAssetBundleImportJob</code> API call. A <code>CLOUDFORMATION_JSON</code> formatted file can be used in the CloudFormation console and with the CloudFormation APIs.</p>', 'StartAssetBundleExportJobRequest$ExportFormat' => '<p>The export data format.</p>', ], ], 'AssetBundleExportJobAnalysisOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>Analysis</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobAnalysisOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobAnalysisOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$Analyses' => '<p>An optional list of structures that control how <code>Analysis</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobAnalysisPropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobAnalysisPropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobAnalysisPropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobAnalysisOverrideProperties$Properties' => '<p>A list of <code>Analysis</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDashboardOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>Dashboard</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobDashboardOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobDashboardOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$Dashboards' => '<p>An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDashboardPropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDashboardPropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobDashboardPropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDashboardOverrideProperties$Properties' => '<p>A list of <code>Dashboard</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDataSetOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>DataSet</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobDataSetOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobDataSetOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$DataSets' => '<p>An optional list of structures that control how <code>DataSet</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDataSetPropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDataSetPropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobDataSetPropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDataSetOverrideProperties$Properties' => '<p>A list of <code>DataSet</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDataSourceOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>DataSource</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobDataSourceOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobDataSourceOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$DataSources' => '<p>An optional list of structures that control how <code>DataSource</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobDataSourcePropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDataSourcePropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobDataSourcePropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobDataSourceOverrideProperties$Properties' => '<p>A list of <code>DataSource</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobError' => [ 'base' => '<p>Describes an error that occurred during an Asset Bundle export job.</p>', 'refs' => [ 'AssetBundleExportJobErrorList$member' => NULL, ], ], 'AssetBundleExportJobErrorList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetBundleExportJobResponse$Errors' => '<p>An array of error records that describes any failures that occurred during the export job processing.</p> <p>Error records accumulate while the job runs. The complete set of error records is available after the job has completed and failed.</p>', ], ], 'AssetBundleExportJobRefreshScheduleOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>RefreshSchedule</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobRefreshScheduleOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobRefreshScheduleOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$RefreshSchedules' => '<p>An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobRefreshSchedulePropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobRefreshSchedulePropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobRefreshSchedulePropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobRefreshScheduleOverrideProperties$Properties' => '<p>A list of <code>RefreshSchedule</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobResourceIdOverrideConfiguration' => [ 'base' => '<p>An optional structure that configures resource ID overrides for the export job.</p>', 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$ResourceIdOverrideConfiguration' => '<p>An optional list of structures that control how resource IDs are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobStatus' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobSummary$JobStatus' => '<p>The current status of the export job.</p>', 'DescribeAssetBundleExportJobResponse$JobStatus' => '<p>Indicates the status of a job through its queuing and execution.</p> <p>Poll this <code>DescribeAssetBundleExportApi</code> until <code>JobStatus</code> is either <code>SUCCESSFUL</code> or <code>FAILED</code>.</p>', ], ], 'AssetBundleExportJobSummary' => [ 'base' => '<p>A summary of the export job that includes details of the job\'s configuration and its current status.</p>', 'refs' => [ 'AssetBundleExportJobSummaryList$member' => NULL, ], ], 'AssetBundleExportJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAssetBundleExportJobsResponse$AssetBundleExportJobSummaryList' => '<p>A list of export job summaries.</p>', ], ], 'AssetBundleExportJobThemeOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>Theme</code> resource is parameterized in the returned CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobThemeOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobThemeOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$Themes' => '<p>An optional list of structures that control how <code>Theme</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobThemePropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobThemePropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobThemePropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobThemeOverrideProperties$Properties' => '<p>A list of <code>Theme</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobVPCConnectionOverrideProperties' => [ 'base' => '<p>Controls how a specific <code>VPCConnection</code> resource is parameterized in the outputted CloudFormation template.</p>', 'refs' => [ 'AssetBundleExportJobVPCConnectionOverridePropertiesList$member' => NULL, ], ], 'AssetBundleExportJobVPCConnectionOverridePropertiesList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleCloudFormationOverridePropertyConfiguration$VPCConnections' => '<p>An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobVPCConnectionPropertyToOverride' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobVPCConnectionPropertyToOverrideList$member' => NULL, ], ], 'AssetBundleExportJobVPCConnectionPropertyToOverrideList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleExportJobVPCConnectionOverrideProperties$Properties' => '<p>A list of <code>VPCConnection</code> resource properties to generate variables for in the returned CloudFormation template.</p>', ], ], 'AssetBundleExportJobValidationStrategy' => [ 'base' => '<p>The option to relax the validation that is required to export each asset. When <code>StrictModeForAllResource</code> is set to <code>false</code>, validation is skipped for specific UI errors.</p>', 'refs' => [ 'DescribeAssetBundleExportJobResponse$ValidationStrategy' => '<p>The validation strategy that is used to export the analysis or dashboard.</p>', 'StartAssetBundleExportJobRequest$ValidationStrategy' => '<p>An optional parameter that determines which validation strategy to use for the export job. If <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error is enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are shown as warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.</p>', ], ], 'AssetBundleExportJobWarning' => [ 'base' => '<p>Describes a warning that occurred during an Asset Bundle export job.</p>', 'refs' => [ 'AssetBundleExportJobWarningList$member' => NULL, ], ], 'AssetBundleExportJobWarningList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetBundleExportJobResponse$Warnings' => '<p>An array of warning records that describe the analysis or dashboard that is exported. This array includes UI errors that can be skipped during the validation process.</p> <p>This property only appears if <code>StrictModeForAllResources</code> in <code>ValidationStrategy</code> is set to <code>FALSE</code>.</p>', ], ], 'AssetBundleImportBodyBlob' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportSource$Body' => '<p>The bytes of the base64 encoded asset bundle import zip file. This file can\'t exceed 20 MB.</p> <p>If you are calling the API operations from the Amazon Web Services SDK for Java, JavaScript, Python, or PHP, the SDK encodes base64 automatically to allow the direct setting of the zip file\'s bytes. If you are using an SDK for a different language or receiving related errors, try to base64 encode your data.</p>', ], ], 'AssetBundleImportFailureAction' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobSummary$FailureAction' => '<p>The failure action for the import job.</p>', 'DescribeAssetBundleImportJobResponse$FailureAction' => '<p>The failure action for the import job.</p>', 'StartAssetBundleImportJobRequest$FailureAction' => '<p>The failure action for the import job.</p> <p>If you choose <code>ROLLBACK</code>, failed import jobs will attempt to undo any asset changes caused by the failed job.</p> <p>If you choose <code>DO_NOTHING</code>, failed import jobs will not attempt to roll back any asset changes caused by the failed job, possibly keeping the Amazon QuickSight account in an inconsistent state.</p>', ], ], 'AssetBundleImportJobAnalysisOverrideParameters' => [ 'base' => '<p>The override parameters for a single analysis that is being imported.</p>', 'refs' => [ 'AssetBundleImportJobAnalysisOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobAnalysisOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$Analyses' => '<p>A list of overrides for any <code>Analysis</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobAnalysisOverridePermissions' => [ 'base' => '<p>An object that contains a list of permissions to be applied to a list of analysis IDs.</p>', 'refs' => [ 'AssetBundleImportJobAnalysisOverridePermissionsList$member' => NULL, ], ], 'AssetBundleImportJobAnalysisOverridePermissionsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverridePermissions$Analyses' => '<p>A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobAnalysisOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of analysis IDs.</p>', 'refs' => [ 'AssetBundleImportJobAnalysisOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobAnalysisOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$Analyses' => '<p>A list of tag overrides for any <code>Analysis</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDashboardOverrideParameters' => [ 'base' => '<p>The override parameters for a single dashboard that is being imported.</p>', 'refs' => [ 'AssetBundleImportJobDashboardOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobDashboardOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$Dashboards' => '<p>A list of overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDashboardOverridePermissions' => [ 'base' => '<p>An object that contains a list of permissions to be applied to a list of dashboard IDs.</p>', 'refs' => [ 'AssetBundleImportJobDashboardOverridePermissionsList$member' => NULL, ], ], 'AssetBundleImportJobDashboardOverridePermissionsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverridePermissions$Dashboards' => '<p>A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDashboardOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of dashboard IDs.</p>', 'refs' => [ 'AssetBundleImportJobDashboardOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobDashboardOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$Dashboards' => '<p>A list of tag overrides for any <code>Dashboard</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSetOverrideParameters' => [ 'base' => '<p>The override parameters for a single dataset that is being imported.</p>', 'refs' => [ 'AssetBundleImportJobDataSetOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobDataSetOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$DataSets' => '<p>A list of overrides for any <code>DataSet</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSetOverridePermissions' => [ 'base' => '<p>An object that contains a list of permissions to be applied to a list of dataset IDs.</p>', 'refs' => [ 'AssetBundleImportJobDataSetOverridePermissionsList$member' => NULL, ], ], 'AssetBundleImportJobDataSetOverridePermissionsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverridePermissions$DataSets' => '<p>A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSetOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of dataset IDs.</p>', 'refs' => [ 'AssetBundleImportJobDataSetOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobDataSetOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$DataSets' => '<p>A list of tag overrides for any <code>DataSet</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSourceCredentialPair' => [ 'base' => '<p>A username and password credential pair to use to import a data source resource.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceCredentials$CredentialPair' => '<p>A username and password credential pair to be used to create the imported data source. Keep this field blank if you are using a Secrets Manager secret to provide credentials.</p>', ], ], 'AssetBundleImportJobDataSourceCredentials' => [ 'base' => '<p>The login credentials to use to import a data source resource.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideParameters$Credentials' => '<p>An optional structure that provides the credentials to be used to create the imported data source.</p>', ], ], 'AssetBundleImportJobDataSourceOverrideParameters' => [ 'base' => '<p>The override parameters for a single data source that is being imported.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobDataSourceOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$DataSources' => '<p> A list of overrides for any <code>DataSource</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSourceOverridePermissions' => [ 'base' => '<p>An object that contains a list of permissions to be applied to a list of data source IDs.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverridePermissionsList$member' => NULL, ], ], 'AssetBundleImportJobDataSourceOverridePermissionsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverridePermissions$DataSources' => '<p>A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobDataSourceOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of data source IDs.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobDataSourceOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$DataSources' => '<p>A list of tag overrides for any <code>DataSource</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobError' => [ 'base' => '<p>Describes an error that occurred within an Asset Bundle import execution.</p>', 'refs' => [ 'AssetBundleImportJobErrorList$member' => NULL, ], ], 'AssetBundleImportJobErrorList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetBundleImportJobResponse$Errors' => '<p>An array of error records that describes any failures that occurred during the export job processing.</p> <p>Error records accumulate while the job is still running. The complete set of error records is available after the job has completed and failed.</p>', 'DescribeAssetBundleImportJobResponse$RollbackErrors' => '<p>An array of error records that describes any failures that occurred while an import job was attempting a rollback.</p> <p>Error records accumulate while the job is still running. The complete set of error records is available after the job has completed and failed.</p>', ], ], 'AssetBundleImportJobOverrideParameters' => [ 'base' => '<p>A list of overrides that modify the asset bundle resource configuration before the resource is imported.</p>', 'refs' => [ 'DescribeAssetBundleImportJobResponse$OverrideParameters' => '<p>Optional overrides that are applied to the resource configuration before import.</p>', 'StartAssetBundleImportJobRequest$OverrideParameters' => '<p>Optional overrides that are applied to the resource configuration before import.</p>', ], ], 'AssetBundleImportJobOverridePermissions' => [ 'base' => '<p>A structure that contains the override permission configurations that modify the permissions for specified resources before the resource is imported.</p>', 'refs' => [ 'DescribeAssetBundleImportJobResponse$OverridePermissions' => '<p>Optional permission overrides that are applied to the resource configuration before import.</p>', 'StartAssetBundleImportJobRequest$OverridePermissions' => '<p>Optional permission overrides that are applied to the resource configuration before import.</p>', ], ], 'AssetBundleImportJobOverrideTags' => [ 'base' => '<p>A structure that contains the override tag configuration that modify the tags that are assigned to specified resources before the resource is imported.</p>', 'refs' => [ 'DescribeAssetBundleImportJobResponse$OverrideTags' => '<p>Optional tag overrides that are applied to the resource configuration before import.</p>', 'StartAssetBundleImportJobRequest$OverrideTags' => '<p>Optional tag overrides that are applied to the resource configuration before import.</p>', ], ], 'AssetBundleImportJobOverrideValidationStrategy' => [ 'base' => '<p>An optional parameter that overrides the validation strategy for all analyses and dashboards before the resource is imported.</p>', 'refs' => [ 'DescribeAssetBundleImportJobResponse$OverrideValidationStrategy' => '<p>An optional validation strategy override for all analyses and dashboards to be applied to the resource configuration before import.</p>', 'StartAssetBundleImportJobRequest$OverrideValidationStrategy' => '<p>An optional validation strategy override for all analyses and dashboards that is applied to the resource configuration before import. </p>', ], ], 'AssetBundleImportJobRefreshScheduleOverrideParameters' => [ 'base' => '<p>A list of overrides for a specific <code>RefreshsSchedule</code> resource that is present in the asset bundle that is imported.</p>', 'refs' => [ 'AssetBundleImportJobRefreshScheduleOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobRefreshScheduleOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$RefreshSchedules' => '<p>A list of overrides for any <code>RefreshSchedule</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobResourceIdOverrideConfiguration' => [ 'base' => '<p>An optional structure that configures resource ID overrides for the import job.</p>', 'refs' => [ 'AssetBundleImportJobOverrideParameters$ResourceIdOverrideConfiguration' => '<p>An optional structure that configures resource ID overrides to be applied within the import job.</p>', ], ], 'AssetBundleImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobSummary$JobStatus' => '<p>The current status of the import job.</p>', 'DescribeAssetBundleImportJobResponse$JobStatus' => '<p>Indicates the status of a job through its queuing and execution.</p> <p>Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the following values:</p> <ul> <li> <p> <code>SUCCESSFUL</code> </p> </li> <li> <p> <code>FAILED</code> </p> </li> <li> <p> <code>FAILED_ROLLBACK_COMPLETED</code> </p> </li> <li> <p> <code>FAILED_ROLLBACK_ERROR</code> </p> </li> </ul>', ], ], 'AssetBundleImportJobSummary' => [ 'base' => '<p>A summary of the import job that includes details of the requested job\'s configuration and its current status.</p>', 'refs' => [ 'AssetBundleImportJobSummaryList$member' => NULL, ], ], 'AssetBundleImportJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAssetBundleImportJobsResponse$AssetBundleImportJobSummaryList' => '<p>A list of import job summaries.</p>', ], ], 'AssetBundleImportJobThemeOverrideParameters' => [ 'base' => '<p>The override parameters for a single theme that is imported.</p>', 'refs' => [ 'AssetBundleImportJobThemeOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobThemeOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$Themes' => '<p>A list of overrides for any <code>Theme</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobThemeOverridePermissions' => [ 'base' => '<p>An object that contains a list of permissions to be applied to a list of theme IDs.</p>', 'refs' => [ 'AssetBundleImportJobThemeOverridePermissionsList$member' => NULL, ], ], 'AssetBundleImportJobThemeOverridePermissionsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverridePermissions$Themes' => '<p>A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobThemeOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of theme IDs.</p>', 'refs' => [ 'AssetBundleImportJobThemeOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobThemeOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$Themes' => '<p>A list of tag overrides for any <code>Theme</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobVPCConnectionOverrideParameters' => [ 'base' => '<p>The override parameters for a single VPC connection that is imported.</p>', 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParametersList$member' => NULL, ], ], 'AssetBundleImportJobVPCConnectionOverrideParametersList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideParameters$VPCConnections' => '<p>A list of overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobVPCConnectionOverrideTags' => [ 'base' => '<p>An object that contains a list of tags to be assigned to a list of VPC connection IDs.</p>', 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideTagsList$member' => NULL, ], ], 'AssetBundleImportJobVPCConnectionOverrideTagsList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobOverrideTags$VPCConnections' => '<p>A list of tag overrides for any <code>VPCConnection</code> resources that are present in the asset bundle that is imported.</p>', ], ], 'AssetBundleImportJobWarning' => [ 'base' => '<p>Describes a warning that occurred during an Asset Bundle import job.</p>', 'refs' => [ 'AssetBundleImportJobWarningList$member' => NULL, ], ], 'AssetBundleImportJobWarningList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetBundleImportJobResponse$Warnings' => '<p>An array of warning records that describe all permitted errors that are encountered during the import job.</p>', ], ], 'AssetBundleImportSource' => [ 'base' => '<p>The source of the asset bundle zip file that contains the data that you want to import. The file must be in <code>QUICKSIGHT_JSON</code> format.</p>', 'refs' => [ 'StartAssetBundleImportJobRequest$AssetBundleImportSource' => '<p>The source of the asset bundle zip file that contains the data that you want to import. The file must be in <code>QUICKSIGHT_JSON</code> format. </p>', ], ], 'AssetBundleImportSourceDescription' => [ 'base' => '<p>A description of the import source that you provide at the start of an import job. This value is set to either <code>Body</code> or <code>S3Uri</code>, depending on how the <code>StartAssetBundleImportJobRequest</code> is configured.</p>', 'refs' => [ 'DescribeAssetBundleImportJobResponse$AssetBundleImportSource' => '<p>The source of the asset bundle zip file that contains the data that is imported by the job.</p>', ], ], 'AssetBundlePrincipalList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleResourcePermissions$Principals' => '<p>A list of principals to grant permissions on.</p>', ], ], 'AssetBundleResourceArns' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetBundleExportJobResponse$ResourceArns' => '<p>A list of resource ARNs that exported with the job.</p>', 'StartAssetBundleExportJobRequest$ResourceArns' => '<p>An array of resource ARNs to export. The following resources are supported.</p> <ul> <li> <p> <code>Analysis</code> </p> </li> <li> <p> <code>Dashboard</code> </p> </li> <li> <p> <code>DataSet</code> </p> </li> <li> <p> <code>DataSource</code> </p> </li> <li> <p> <code>RefreshSchedule</code> </p> </li> <li> <p> <code>Theme</code> </p> </li> <li> <p> <code>VPCConnection</code> </p> </li> </ul> <p>The API caller must have the necessary permissions in their IAM role to access each resource before the resources can be exported.</p>', ], ], 'AssetBundleResourceLinkSharingConfiguration' => [ 'base' => '<p>A structure that contains the configuration of a shared link to an Amazon QuickSight dashboard.</p>', 'refs' => [ 'AssetBundleImportJobDashboardOverridePermissions$LinkSharingConfiguration' => '<p>A structure that contains the link sharing configurations that you want to apply overrides to.</p>', ], ], 'AssetBundleResourcePermissions' => [ 'base' => '<p>A structure that contains the permissions for the resource that you want to override in an asset bundle import job.</p>', 'refs' => [ 'AssetBundleImportJobAnalysisOverridePermissions$Permissions' => '<p>A list of permissions for the analyses that you want to apply overrides to.</p>', 'AssetBundleImportJobDashboardOverridePermissions$Permissions' => '<p>A list of permissions for the dashboards that you want to apply overrides to.</p>', 'AssetBundleImportJobDataSetOverridePermissions$Permissions' => '<p>A list of permissions for the datasets that you want to apply overrides to.</p>', 'AssetBundleImportJobDataSourceOverridePermissions$Permissions' => '<p>A list of permissions for the data source that you want to apply overrides to.</p>', 'AssetBundleImportJobThemeOverridePermissions$Permissions' => '<p>A list of permissions for the themes that you want to apply overrides to.</p>', 'AssetBundleResourceLinkSharingConfiguration$Permissions' => '<p>A list of link sharing permissions for the dashboards that you want to apply overrides to.</p>', ], ], 'AssetBundleRestrictiveResourceId' => [ 'base' => NULL, 'refs' => [ 'AssetBundleRestrictiveResourceIdList$member' => NULL, ], ], 'AssetBundleRestrictiveResourceIdList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobAnalysisOverridePermissions$AnalysisIds' => '<p>A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all analyses in this asset bundle.</p>', 'AssetBundleImportJobAnalysisOverrideTags$AnalysisIds' => '<p>A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all analyses in this asset bundle.</p>', 'AssetBundleImportJobDashboardOverridePermissions$DashboardIds' => '<p>A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all dashboards in this asset bundle.</p>', 'AssetBundleImportJobDashboardOverrideTags$DashboardIds' => '<p>A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all dashboards in this asset bundle.</p>', 'AssetBundleImportJobDataSetOverridePermissions$DataSetIds' => '<p>A list of dataset IDs that you want to apply overrides to. You can use <code>*</code> to override all datasets in this asset bundle.</p>', 'AssetBundleImportJobDataSetOverrideTags$DataSetIds' => '<p>A list of dataset IDs that you want to apply overrides to. You can use <code>*</code> to override all datasets in this asset bundle.</p>', 'AssetBundleImportJobDataSourceOverridePermissions$DataSourceIds' => '<p>A list of data source IDs that you want to apply overrides to. You can use <code>*</code> to override all data sources in this asset bundle.</p>', 'AssetBundleImportJobDataSourceOverrideTags$DataSourceIds' => '<p>A list of data source IDs that you want to apply overrides to. You can use <code>*</code> to override all data sources in this asset bundle.</p>', 'AssetBundleImportJobThemeOverridePermissions$ThemeIds' => '<p>A list of theme IDs that you want to apply overrides to. You can use <code>*</code> to override all themes in this asset bundle.</p>', 'AssetBundleImportJobThemeOverrideTags$ThemeIds' => '<p>A list of theme IDs that you want to apply overrides to. You can use <code>*</code> to override all themes in this asset bundle.</p>', 'AssetBundleImportJobVPCConnectionOverrideTags$VPCConnectionIds' => '<p>A list of VPC connection IDs that you want to apply overrides to. You can use <code>*</code> to override all VPC connections in this asset bundle.</p>', ], ], 'AssetOptions' => [ 'base' => '<p>An array of analysis level configurations.</p>', 'refs' => [ 'AnalysisDefinition$Options' => '<p>An array of option definitions for an analysis.</p>', 'DashboardVersionDefinition$Options' => '<p>An array of option definitions for a dashboard.</p>', 'TemplateVersionDefinition$Options' => '<p>An array of option definitions for a template.</p>', ], ], 'AssignmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'CreateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'IAMPolicyAssignment$AssignmentStatus' => '<p>Assignment status.</p>', 'IAMPolicyAssignmentSummary$AssignmentStatus' => '<p>Assignment status.</p>', 'ListIAMPolicyAssignmentsRequest$AssignmentStatus' => '<p>The status of the assignments.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'UpdateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', ], ], 'AthenaParameters' => [ 'base' => '<p>Parameters for Amazon Athena.</p>', 'refs' => [ 'DataSourceParameters$AthenaParameters' => '<p>The parameters for Amazon Athena.</p>', ], ], 'AttributeAggregationFunction' => [ 'base' => '<p>Aggregation for attributes.</p>', 'refs' => [ 'AggregationFunction$AttributeAggregationFunction' => '<p>Aggregation for attributes.</p>', ], ], 'AuroraParameters' => [ 'base' => '<p>Parameters for Amazon Aurora.</p>', 'refs' => [ 'DataSourceParameters$AuroraParameters' => '<p>The parameters for Amazon Aurora MySQL.</p>', ], ], 'AuroraPostgreSqlParameters' => [ 'base' => '<p>Parameters for Amazon Aurora PostgreSQL-Compatible Edition.</p>', 'refs' => [ 'DataSourceParameters$AuroraPostgreSqlParameters' => '<p>The parameters for Amazon Aurora.</p>', ], ], 'AuthenticationMethodOption' => [ 'base' => NULL, 'refs' => [ 'CreateAccountSubscriptionRequest$AuthenticationMethod' => '<p>The method that you want to use to authenticate your Amazon QuickSight account.</p> <p>If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an <code>AdminGroup</code> associated with your Active Directory.</p> <p>If you choose <code>IAM_IDENTITY_CENTER</code>, provide an <code>AdminGroup</code> associated with your IAM Identity Center account.</p>', ], ], 'AuthorSpecifiedAggregation' => [ 'base' => NULL, 'refs' => [ 'AuthorSpecifiedAggregations$member' => NULL, ], ], 'AuthorSpecifiedAggregations' => [ 'base' => NULL, 'refs' => [ 'TopicCalculatedField$AllowedAggregations' => '<p>The list of aggregation types that are allowed for the calculated field. Valid values for this structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.</p>', 'TopicCalculatedField$NotAllowedAggregations' => '<p>The list of aggregation types that are not allowed for the calculated field. Valid values for this structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.</p>', 'TopicColumn$AllowedAggregations' => '<p>The list of aggregation types that are allowed for the column. Valid values for this structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.</p>', 'TopicColumn$NotAllowedAggregations' => '<p>The list of aggregation types that are not allowed for the column. Valid values for this structure are <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, and <code>PERCENTILE</code>.</p>', ], ], 'AuthorizedTargetsByService' => [ 'base' => '<p>The authorized targets that are associated with a service.</p>', 'refs' => [ 'AuthorizedTargetsByServices$member' => NULL, ], ], 'AuthorizedTargetsByServices' => [ 'base' => NULL, 'refs' => [ 'ListIdentityPropagationConfigsResponse$Services' => '<p>A list of services and their authorized targets that the Amazon QuickSight IAM Identity Center application can access.</p>', ], ], 'AuthorizedTargetsList' => [ 'base' => NULL, 'refs' => [ 'AuthorizedTargetsByService$AuthorizedTargets' => '<p>Aist of authorized targets that are represented by IAM Identity Center application ARNs.</p>', 'UpdateIdentityPropagationConfigRequest$AuthorizedTargets' => '<p>Specifies a list of application ARNs that represent the authorized targets for a service.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that you want to create a reviewed answer in.</p>', 'BatchDeleteTopicReviewedAnswerRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that you want to delete a reviewed answers in.</p>', 'CancelIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>', 'CreateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>', 'CreateAccountSubscriptionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account that you\'re using to create your Amazon QuickSight account.</p>', 'CreateAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you are creating an analysis.</p>', 'CreateDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>', 'CreateDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateFolderMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'CreateFolderRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account where you want to create the folder.</p>', 'CreateGroupMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>', 'CreateIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>', 'CreateRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateRoleMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID that you provide must be the same Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>', 'CreateTemplateRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>', 'CreateThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to store the new theme. </p>', 'CreateTopicRefreshScheduleRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic you\'re creating a refresh schedule for.</p>', 'CreateTopicRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that you want to create a topic in.</p>', 'CreateVPCConnectionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account where you want to create a new VPC connection.</p>', 'DeleteAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>', 'DeleteAccountSubscriptionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account that you want to delete.</p>', 'DeleteAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>', 'DeleteDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re deleting.</p>', 'DeleteDataSetRefreshPropertiesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteFolderMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'DeleteFolderRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'DeleteGroupMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>', 'DeleteIdentityPropagationConfigRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that you want to delete an identity propagation configuration from.</p>', 'DeleteNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>', 'DeleteRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteRoleCustomPermissionRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteRoleMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID that you provide must be the same Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the item to delete.</p>', 'DeleteTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re deleting.</p>', 'DeleteThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>', 'DeleteThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re deleting.</p>', 'DeleteTopicRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteTopicRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic that you want to delete.</p>', 'DeleteUserByPrincipalIdRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteVPCConnectionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account where you want to delete a VPC connection.</p>', 'DescribeAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>', 'DescribeAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you\'re describing.</p>', 'DescribeAccountSettingsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>', 'DescribeAccountSubscriptionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID associated with your Amazon QuickSight account.</p>', 'DescribeAnalysisDefinitionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>', 'DescribeAnalysisPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis whose permissions you\'re describing. You must be using the Amazon Web Services account that the analysis is in.</p>', 'DescribeAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>', 'DescribeAssetBundleExportJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account the export job is executed in. </p>', 'DescribeAssetBundleExportJobResponse$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the export job was executed in. </p>', 'DescribeAssetBundleImportJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account the import job was executed in. </p>', 'DescribeAssetBundleImportJobResponse$AwsAccountId' => '<p>The ID of the Amazon Web Services account the import job was executed in. </p>', 'DescribeDashboardDefinitionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re describing.</p>', 'DescribeDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re describing permissions for.</p>', 'DescribeDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re describing.</p>', 'DescribeDashboardSnapshotJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.</p>', 'DescribeDashboardSnapshotJobResponse$AwsAccountId' => '<p> The ID of the Amazon Web Services account that the dashboard snapshot job is executed in. </p>', 'DescribeDashboardSnapshotJobResultRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.</p>', 'DescribeDataSetPermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSetRefreshPropertiesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSourcePermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeFolderPermissionsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'DescribeFolderRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'DescribeFolderResolvedPermissionsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'DescribeGroupMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>', 'DescribeIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeIpRestrictionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IP rules.</p>', 'DescribeIpRestrictionResponse$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IP rules.</p>', 'DescribeKeyRegistrationRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the customer managed key registration that you want to describe.</p>', 'DescribeKeyRegistrationResponse$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the customer managed key registration specified in the request.</p>', 'DescribeNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>', 'DescribeRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeRoleCustomPermissionRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID that you provide must be the same Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template alias that you\'re describing.</p>', 'DescribeTemplateDefinitionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template. You must be using the Amazon Web Services account that the template is in.</p>', 'DescribeTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re describing.</p>', 'DescribeTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re describing.</p>', 'DescribeThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias that you\'re describing.</p>', 'DescribeThemePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re describing.</p>', 'DescribeTopicPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic that you want described.</p>', 'DescribeTopicRefreshRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic whose refresh you want to describe.</p>', 'DescribeTopicRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeTopicRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeVPCConnectionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account that contains the VPC connection that you want described.</p>', 'GenerateEmbedUrlForAnonymousUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GetDashboardEmbedUrlRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GetSessionEmbedUrlRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>', 'IAMPolicyAssignment$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListAnalysesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analyses.</p>', 'ListAssetBundleExportJobsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the export jobs were executed in. </p>', 'ListAssetBundleImportJobsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the import jobs were executed in.</p>', 'ListDashboardVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re listing versions for.</p>', 'ListDashboardsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboards that you\'re listing.</p>', 'ListDataSetsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListDataSourcesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListFolderMembersRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'ListFoldersRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'ListGroupMembershipsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListGroupsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUserRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the assignments.</p>', 'ListIAMPolicyAssignmentsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>', 'ListIdentityPropagationConfigsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contain the identity propagation configurations of.</p>', 'ListIngestionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListNamespacesRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>', 'ListRefreshSchedulesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListRoleMembershipsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID that you provide must be the same Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListTemplateAliasesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template aliases that you\'re listing.</p>', 'ListTemplateVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the templates that you\'re listing.</p>', 'ListTemplatesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the templates that you\'re listing.</p>', 'ListThemeAliasesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme aliases that you\'re listing.</p>', 'ListThemeVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the themes that you\'re listing.</p>', 'ListThemesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the themes that you\'re listing.</p>', 'ListTopicRefreshSchedulesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want described.</p>', 'ListTopicReviewedAnswersRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that containd the reviewed answers that you want listed.</p>', 'ListTopicsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topics that you want to list.</p>', 'ListUserGroupsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListUsersRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListVPCConnectionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account that contains the VPC connections that you want to list.</p>', 'PutDataSetRefreshPropertiesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'RegisterUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'RestoreAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis.</p>', 'SearchAnalysesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analyses that you\'re searching for.</p>', 'SearchDashboardsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the user whose dashboards you\'re searching for. </p>', 'SearchDataSetsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'SearchDataSourcesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'SearchFoldersRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder.</p>', 'SearchGroupsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'StartAssetBundleExportJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account to export assets from.</p>', 'StartAssetBundleImportJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account to import assets into. </p>', 'StartDashboardSnapshotJobRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.</p>', 'UpdateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountSettingsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>', 'UpdateAnalysisPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis whose permissions you\'re updating. You must be using the Amazon Web Services account that the analysis is in.</p>', 'UpdateAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis that you\'re updating.</p>', 'UpdateDashboardLinksRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard whose links you want to update.</p>', 'UpdateDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you\'re updating.</p>', 'UpdateDashboardPublishedVersionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re updating.</p>', 'UpdateDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re updating.</p>', 'UpdateDataSetPermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSourcePermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateFolderPermissionsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder to update.</p>', 'UpdateFolderRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the folder to update.</p>', 'UpdateGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'UpdateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IAM policy assignment. </p>', 'UpdateIdentityPropagationConfigRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the identity propagation configuration that you want to update.</p>', 'UpdateIpRestrictionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IP rules.</p>', 'UpdateIpRestrictionResponse$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IP rules.</p>', 'UpdateKeyRegistrationRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the customer managed key registration that you want to update.</p>', 'UpdatePublicSharingSettingsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID associated with your Amazon QuickSight subscription.</p>', 'UpdateRefreshScheduleRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateRoleCustomPermissionRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID that you provide must be the same Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'UpdateSPICECapacityConfigurationRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the SPICE configuration that you want to update.</p>', 'UpdateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template alias that you\'re updating.</p>', 'UpdateTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template.</p>', 'UpdateTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re updating.</p>', 'UpdateThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias that you\'re updating.</p>', 'UpdateThemePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme.</p>', 'UpdateThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re updating.</p>', 'UpdateTopicPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic that you want to update the permissions for.</p>', 'UpdateTopicRefreshScheduleRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want to update.</p>', 'UpdateTopicRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the topic that you want to update.</p>', 'UpdateUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'UpdateVPCConnectionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID of the account that contains the VPC connection that you want to update.</p>', ], ], 'AwsAndAccountId' => [ 'base' => NULL, 'refs' => [ 'DescribeThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re describing.</p>', ], ], 'AwsIotAnalyticsParameters' => [ 'base' => '<p>The parameters for IoT Analytics.</p>', 'refs' => [ 'DataSourceParameters$AwsIotAnalyticsParameters' => '<p>The parameters for IoT Analytics.</p>', ], ], 'AxisBinding' => [ 'base' => NULL, 'refs' => [ 'DataFieldSeriesItem$AxisBinding' => '<p>The axis that you are binding the field to.</p>', 'FieldSeriesItem$AxisBinding' => '<p>The axis that you are binding the field to.</p>', 'LineChartDefaultSeriesSettings$AxisBinding' => '<p>The axis to which you are binding all line series to.</p>', 'ReferenceLineDataConfiguration$AxisBinding' => '<p>The axis binding type of the reference line. Choose one of the following options:</p> <ul> <li> <p> <code>PrimaryY</code> </p> </li> <li> <p> <code>SecondaryY</code> </p> </li> </ul>', ], ], 'AxisDataOptions' => [ 'base' => '<p>The data options for an axis.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'AxisDisplayOptions$DataOptions' => '<p>The data options for an axis.</p>', ], ], 'AxisDisplayDataDrivenRange' => [ 'base' => '<p>The options that are saved for future extension.</p>', 'refs' => [ 'AxisDisplayRange$DataDriven' => '<p>The data-driven setup of an axis display range.</p>', ], ], 'AxisDisplayMinMaxRange' => [ 'base' => '<p>The minimum and maximum setup for an axis display range.</p>', 'refs' => [ 'AxisDisplayRange$MinMax' => '<p>The minimum and maximum setup of an axis display range.</p>', ], ], 'AxisDisplayOptions' => [ 'base' => '<p>The display options for the axis label.</p>', 'refs' => [ 'BarChartConfiguration$CategoryAxis' => '<p>The label display options (grid line, range, scale, axis step) for bar chart category.</p>', 'BarChartConfiguration$ValueAxis' => '<p>The label display options (grid line, range, scale, axis step) for a bar chart value.</p>', 'BoxPlotChartConfiguration$CategoryAxis' => '<p>The label display options (grid line, range, scale, axis step) of a box plot category.</p>', 'BoxPlotChartConfiguration$PrimaryYAxisDisplayOptions' => '<p>The label display options (grid line, range, scale, axis step) of a box plot category.</p>', 'ComboChartConfiguration$CategoryAxis' => '<p>The category axis of a combo chart.</p>', 'ComboChartConfiguration$PrimaryYAxisDisplayOptions' => '<p>The label display options (grid line, range, scale, and axis step) of a combo chart\'s primary y-axis (bar) field well.</p>', 'ComboChartConfiguration$SecondaryYAxisDisplayOptions' => '<p>The label display options (grid line, range, scale, axis step) of a combo chart\'s secondary y-axis (line) field well.</p>', 'HistogramConfiguration$XAxisDisplayOptions' => '<p>The options that determine the presentation of the x-axis.</p>', 'HistogramConfiguration$YAxisDisplayOptions' => '<p>The options that determine the presentation of the y-axis.</p>', 'LineChartConfiguration$XAxisDisplayOptions' => '<p>The options that determine the presentation of the x-axis.</p>', 'LineSeriesAxisDisplayOptions$AxisOptions' => '<p>The options that determine the presentation of the line series axis.</p>', 'RadarChartConfiguration$CategoryAxis' => '<p>The category axis of a radar chart.</p>', 'RadarChartConfiguration$ColorAxis' => '<p>The color axis of a radar chart.</p>', 'ScatterPlotConfiguration$XAxisDisplayOptions' => '<p>The label display options (grid line, range, scale, and axis step) of the scatter plot\'s x-axis.</p>', 'ScatterPlotConfiguration$YAxisDisplayOptions' => '<p>The label display options (grid line, range, scale, and axis step) of the scatter plot\'s y-axis.</p>', 'WaterfallChartConfiguration$CategoryAxisDisplayOptions' => '<p>The options that determine the presentation of the category axis.</p>', 'WaterfallChartConfiguration$PrimaryYAxisDisplayOptions' => '<p>The options that determine the presentation of the y-axis.</p>', ], ], 'AxisDisplayRange' => [ 'base' => '<p>The range setup of a numeric axis display range.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'NumericAxisOptions$Range' => '<p>The range setup of a numeric axis.</p>', ], ], 'AxisLabelOptions' => [ 'base' => '<p>The label options for a chart axis. You must specify the field that the label is targeted to.</p>', 'refs' => [ 'AxisLabelOptionsList$member' => NULL, ], ], 'AxisLabelOptionsList' => [ 'base' => NULL, 'refs' => [ 'ChartAxisLabelOptions$AxisLabelOptions' => '<p>The label options for a chart axis.</p>', ], ], 'AxisLabelReferenceOptions' => [ 'base' => '<p>The reference that specifies where the axis label is applied to.</p>', 'refs' => [ 'AxisLabelOptions$ApplyTo' => '<p>The options that indicate which field the label belongs to.</p>', ], ], 'AxisLinearScale' => [ 'base' => '<p>The liner axis scale setup.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'AxisScale$Linear' => '<p>The linear axis scale setup.</p>', ], ], 'AxisLogarithmicScale' => [ 'base' => '<p>The logarithmic axis scale setup.</p>', 'refs' => [ 'AxisScale$Logarithmic' => '<p>The logarithmic axis scale setup.</p>', ], ], 'AxisScale' => [ 'base' => '<p>The scale setup options for a numeric axis display.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'NumericAxisOptions$Scale' => '<p>The scale setup of a numeric axis.</p>', ], ], 'AxisTickLabelOptions' => [ 'base' => '<p>The tick label options of an axis.</p>', 'refs' => [ 'AxisDisplayOptions$TickLabelOptions' => '<p>The tick label options of an axis.</p>', ], ], 'BarChartAggregatedFieldWells' => [ 'base' => '<p>The aggregated field wells of a bar chart.</p>', 'refs' => [ 'BarChartFieldWells$BarChartAggregatedFieldWells' => '<p>The aggregated field wells of a bar chart.</p>', ], ], 'BarChartConfiguration' => [ 'base' => '<p>The configuration of a <code>BarChartVisual</code>.</p>', 'refs' => [ 'BarChartVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'BarChartFieldWells' => [ 'base' => '<p>The field wells of a <code>BarChartVisual</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'BarChartConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'BarChartOrientation' => [ 'base' => NULL, 'refs' => [ 'BarChartConfiguration$Orientation' => '<p>The orientation of the bars in a bar chart visual. There are two valid values in this structure:</p> <ul> <li> <p> <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.</p> </li> <li> <p> <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.</p> </li> </ul>', ], ], 'BarChartSortConfiguration' => [ 'base' => '<p>sort-configuration-description</p>', 'refs' => [ 'BarChartConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>BarChartVisual</code>.</p>', ], ], 'BarChartVisual' => [ 'base' => '<p>A bar chart.</p> <p>The <code>BarChartVisual</code> structure describes a visual that is a member of the bar chart family. The following charts can be described using this structure:</p> <ul> <li> <p>Horizontal bar chart</p> </li> <li> <p>Vertical bar chart</p> </li> <li> <p>Horizontal stacked bar chart</p> </li> <li> <p>Vertical stacked bar chart</p> </li> <li> <p>Horizontal stacked 100% bar chart</p> </li> <li> <p>Vertical stacked 100% bar chart</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$BarChartVisual' => '<p>A bar chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'BarsArrangement' => [ 'base' => NULL, 'refs' => [ 'BarChartConfiguration$BarsArrangement' => '<p>Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar that is used in the visual.</p>', 'ComboChartConfiguration$BarsArrangement' => '<p>Determines the bar arrangement in a combo chart. The following are valid values in this structure:</p> <ul> <li> <p> <code>CLUSTERED</code>: For clustered bar combo charts.</p> </li> <li> <p> <code>STACKED</code>: For stacked bar combo charts.</p> </li> <li> <p> <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation error.</p> </li> </ul>', ], ], 'BaseMapStyleType' => [ 'base' => NULL, 'refs' => [ 'GeospatialMapStyleOptions$BaseMapStyle' => '<p>The base map style of the geospatial map.</p>', ], ], 'BatchCreateTopicReviewedAnswerRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateTopicReviewedAnswerResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTopicReviewedAnswerRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTopicReviewedAnswerResponse' => [ 'base' => NULL, 'refs' => [], ], 'BigQueryParameters' => [ 'base' => '<p>The parameters that are required to connect to a Google BigQuery data source.</p>', 'refs' => [ 'DataSourceParameters$BigQueryParameters' => '<p>The parameters that are required to connect to a Google BigQuery data source.</p>', ], ], 'BinCountLimit' => [ 'base' => NULL, 'refs' => [ 'BinWidthOptions$BinCountLimit' => '<p>The options that determine the bin count limit.</p>', ], ], 'BinCountOptions' => [ 'base' => '<p>The options that determine the bin count of a histogram.</p>', 'refs' => [ 'HistogramBinOptions$BinCount' => '<p>The options that determine the bin count of a histogram.</p>', ], ], 'BinCountValue' => [ 'base' => NULL, 'refs' => [ 'BinCountOptions$Value' => '<p>The options that determine the bin count value.</p>', ], ], 'BinWidthOptions' => [ 'base' => '<p>The options that determine the bin width of a histogram.</p>', 'refs' => [ 'HistogramBinOptions$BinWidth' => '<p>The options that determine the bin width of a histogram.</p>', ], ], 'BinWidthValue' => [ 'base' => NULL, 'refs' => [ 'BinWidthOptions$Value' => '<p>The options that determine the bin width value.</p>', ], ], 'BodySectionConfiguration' => [ 'base' => '<p>The configuration of a body section.</p>', 'refs' => [ 'BodySectionConfigurationList$member' => NULL, ], ], 'BodySectionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SectionBasedLayoutConfiguration$BodySections' => '<p>A list of body section configurations.</p>', ], ], 'BodySectionContent' => [ 'base' => '<p>The configuration of content in a body section.</p>', 'refs' => [ 'BodySectionConfiguration$Content' => '<p>The configuration of content in a body section.</p>', ], ], 'BodySectionDynamicCategoryDimensionConfiguration' => [ 'base' => '<p>Describes the <b>Category</b> dataset column and constraints for the dynamic values used to repeat the contents of a section.</p>', 'refs' => [ 'BodySectionRepeatDimensionConfiguration$DynamicCategoryDimensionConfiguration' => '<p>Describes the <b>Category</b> dataset column and constraints around the dynamic values that will be used in repeating the section contents.</p>', ], ], 'BodySectionDynamicDimensionLimit' => [ 'base' => NULL, 'refs' => [ 'BodySectionDynamicCategoryDimensionConfiguration$Limit' => '<p>Number of values to use from the column for repetition.</p>', 'BodySectionDynamicNumericDimensionConfiguration$Limit' => '<p>Number of values to use from the column for repetition.</p>', ], ], 'BodySectionDynamicDimensionSortConfigurationList' => [ 'base' => NULL, 'refs' => [ 'BodySectionDynamicCategoryDimensionConfiguration$SortByMetrics' => '<p>Sort criteria on the column values that you use for repetition. </p>', 'BodySectionDynamicNumericDimensionConfiguration$SortByMetrics' => '<p>Sort criteria on the column values that you use for repetition. </p>', ], ], 'BodySectionDynamicNumericDimensionConfiguration' => [ 'base' => '<p>Describes the <b>Numeric</b> dataset column and constraints for the dynamic values used to repeat the contents of a section.</p>', 'refs' => [ 'BodySectionRepeatDimensionConfiguration$DynamicNumericDimensionConfiguration' => '<p>Describes the <b>Numeric</b> dataset column and constraints around the dynamic values used to repeat the contents of a section.</p>', ], ], 'BodySectionRepeatConfiguration' => [ 'base' => '<p>Describes the configurations that are required to declare a section as repeating.</p>', 'refs' => [ 'BodySectionConfiguration$RepeatConfiguration' => '<p>Describes the configurations that are required to declare a section as repeating.</p>', ], ], 'BodySectionRepeatDimensionConfiguration' => [ 'base' => '<p>Describes the dataset column and constraints for the dynamic values used to repeat the contents of a section. The dataset column is either <b>Category</b> or <b>Numeric</b> column configuration</p>', 'refs' => [ 'BodySectionRepeatDimensionConfigurationList$member' => NULL, ], ], 'BodySectionRepeatDimensionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'BodySectionRepeatConfiguration$DimensionConfigurations' => '<p>List of <code>BodySectionRepeatDimensionConfiguration</code> values that describe the dataset column and constraints for the column used to repeat the contents of a section.</p>', ], ], 'BodySectionRepeatPageBreakConfiguration' => [ 'base' => '<p>The page break configuration to apply for each repeating instance.</p>', 'refs' => [ 'BodySectionRepeatConfiguration$PageBreakConfiguration' => '<p>Page break configuration to apply for each repeating instance.</p>', ], ], 'BookmarksConfigurations' => [ 'base' => '<p>The bookmarks configuration of an embedded dashboard.</p>', 'refs' => [ 'RegisteredUserDashboardFeatureConfigurations$Bookmarks' => '<p>The bookmarks configuration for an embedded dashboard in Amazon QuickSight.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$PublicSharingEnabled' => '<p>A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For more information about turning on public sharing, see <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html">UpdatePublicSharingSettings</a>.</p>', 'AccountSettings$TerminationProtectionEnabled' => '<p>A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A <code>True</code> value doesn\'t allow the account to be deleted and results in an error message if a user tries to make a <code>DeleteAccountSubsctiption</code> request. A <code>False</code> value will allow the ccount to be deleted. </p>', 'AssetBundleExportJobResourceIdOverrideConfiguration$PrefixForAllResources' => '<p>An option to request a CloudFormation variable for a prefix to be prepended to each resource\'s ID before import. The prefix is only added to the asset IDs and does not change the name of the asset.</p>', 'AssetBundleExportJobSummary$IncludeAllDependencies' => '<p>The flag that determines the inclusion of resource dependencies in the returned asset bundle.</p>', 'AssetBundleExportJobSummary$IncludePermissions' => '<p>The flag that determines the inclusion of permissions associated with each resource ARN.</p>', 'AssetBundleExportJobSummary$IncludeTags' => '<p>The flag that determines the inclusion of tags associated with each resource ARN.</p>', 'AssetBundleExportJobValidationStrategy$StrictModeForAllResources' => '<p>A Boolean value that indicates whether to export resources under strict or lenient mode.</p>', 'AssetBundleImportJobOverrideValidationStrategy$StrictModeForAllResources' => '<p>A Boolean value that indicates whether to import all analyses and dashboards under strict or lenient mode.</p>', 'BookmarksConfigurations$Enabled' => '<p>A Boolean value that determines whether a user can bookmark an embedded dashboard.</p>', 'BorderStyle$Show' => '<p>The option to enable display of borders for visuals.</p>', 'DataSetSummary$RowLevelPermissionTagConfigurationApplied' => '<p>Whether or not the row level permission tags are applied.</p>', 'DataSetSummary$ColumnLevelPermissionRulesApplied' => '<p>A value that indicates if the dataset has column level permission configured.</p>', 'DataSetUsageConfiguration$DisableUseAsDirectQuerySource' => '<p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>', 'DataSetUsageConfiguration$DisableUseAsImportedSource' => '<p>An option that controls whether a child dataset that\'s stored in QuickSight can use this dataset as a source.</p>', 'DeleteAnalysisRequest$ForceDeleteWithoutRecovery' => '<p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can\'t restore an analysis after it\'s deleted. </p>', 'DescribeAssetBundleExportJobResponse$IncludeAllDependencies' => '<p>The include dependencies flag.</p>', 'DescribeAssetBundleExportJobResponse$IncludePermissions' => '<p>The include permissions flag.</p>', 'DescribeAssetBundleExportJobResponse$IncludeTags' => '<p>The include tags flag.</p>', 'DescribeKeyRegistrationRequest$DefaultKeyOnly' => '<p>Determines whether the request returns the default key only.</p>', 'DisplayFormatOptions$UseBlankCellFormat' => '<p>A Boolean value that indicates whether to use blank cell format.</p>', 'DisplayFormatOptions$UseGrouping' => '<p>A Boolean value that indicates whether to use grouping.</p>', 'FailedKeyRegistrationEntry$SenderFault' => '<p>A boolean that indicates whether a <code>FailedKeyRegistrationEntry</code> resulted from user error. If the value of this property is <code>True</code>, the error was caused by user error. If the value of this property is <code>False</code>, the error occurred on the backend. If your job continues fail and with a <code>False</code> <code>SenderFault</code> value, contact Amazon Web Services Support.</p>', 'GetDashboardEmbedUrlRequest$UndoRedoDisabled' => '<p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>', 'GetDashboardEmbedUrlRequest$ResetDisabled' => '<p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>', 'GetDashboardEmbedUrlRequest$StatePersistenceEnabled' => '<p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>', 'GutterStyle$Show' => '<p>This Boolean value controls whether to display a gutter space between sheet tiles. </p>', 'IdentityCenterConfiguration$EnableIdentityPropagation' => '<p>A Boolean option that controls whether Trusted Identity Propagation should be used.</p>', 'JoinKeyProperties$UniqueKey' => '<p>A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.</p>', 'MarginStyle$Show' => '<p>This Boolean value controls whether to display sheet margins.</p>', 'NestedFilter$IncludeInnerSet' => '<p>A boolean condition to include or exclude the subset that is defined by the values of the nested inner filter.</p>', 'NumericRangeFilter$IncludeMinimum' => '<p>Determines whether the minimum value in the filter value range should be included in the filtered results.</p>', 'NumericRangeFilter$IncludeMaximum' => '<p>Determines whether the maximum value in the filter value range should be included in the filtered results.</p>', 'RedshiftIAMParameters$AutoCreateDatabaseUser' => '<p>Automatically creates a database user. If your database doesn\'t have a <code>DatabaseUser</code>, set this parameter to <code>True</code>. If there is no <code>DatabaseUser</code>, Amazon QuickSight can\'t connect to your cluster. The <code>RoleArn</code> that you use for this operation must grant access to <code>redshift:CreateClusterUser</code> to successfully create the user.</p>', 'RegisteredCustomerManagedKey$DefaultKey' => '<p>Indicates whether a <code>RegisteredCustomerManagedKey</code> is set as the default key for encryption and decryption use.</p>', 'SharedViewConfigurations$Enabled' => '<p>The shared view settings of an embedded dashboard.</p>', 'SignupResponse$IAMUser' => '<p>A Boolean that is <code>TRUE</code> if the Amazon QuickSight uses IAM as an authentication method.</p>', 'SslProperties$DisableSsl' => '<p>A Boolean option to control whether SSL should be disabled.</p>', 'StartAssetBundleExportJobRequest$IncludeAllDependencies' => '<p>A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and data source resource that is a dependency of the dashboard is also exported.</p>', 'StartAssetBundleExportJobRequest$IncludePermissions' => '<p>A Boolean that determines whether all permissions for each resource ARN are exported with the job. If you set <code>IncludePermissions</code> to <code>TRUE</code>, any permissions associated with each resource are exported. </p>', 'StartAssetBundleExportJobRequest$IncludeTags' => '<p> A Boolean that determines whether all tags for each resource ARN are exported with the job. If you set <code>IncludeTags</code> to <code>TRUE</code>, any tags associated with each resource are exported.</p>', 'StatePersistenceConfigurations$Enabled' => '<p>Determines if a Amazon QuickSight dashboard\'s state persistence settings are turned on or off.</p>', 'TimeRangeFilter$IncludeMinimum' => '<p>Determines whether the minimum value in the filter value range should be included in the filtered results.</p>', 'TimeRangeFilter$IncludeMaximum' => '<p>Determines whether the maximum value in the filter value range should be included in the filtered results.</p>', 'TopicCalculatedField$IsIncludedInTopic' => '<p>A boolean value that indicates if a calculated field is included in the topic.</p>', 'TopicCalculatedField$NeverAggregateInFilter' => '<p>A Boolean value that indicates whether to never aggregate calculated field in filters.</p>', 'TopicCategoryFilter$Inverse' => '<p>A Boolean value that indicates if the filter is inverse.</p>', 'TopicColumn$IsIncludedInTopic' => '<p>A Boolean value that indicates whether the column is included in the query results.</p>', 'TopicColumn$NeverAggregateInFilter' => '<p>A Boolean value that indicates whether to aggregate the column data when it\'s used in a filter context.</p>', 'TopicDateRangeFilter$Inclusive' => '<p>A Boolean value that indicates whether the date range filter should include the boundary values. If set to true, the filter includes the start and end dates. If set to false, the filter excludes them.</p>', 'TopicIRFilterOption$Inverse' => '<p>The inverse for the <code>TopicIRFilterOption</code>.</p>', 'TopicIRFilterOption$Inclusive' => '<p>The inclusive for the <code>TopicIRFilterOption</code>.</p>', 'TopicNumericRangeFilter$Inclusive' => '<p>A Boolean value that indicates whether the endpoints of the numeric range are included in the filter. If set to true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If set to false, topics whose numeric field value is equal to the endpoint values will be excluded from the filter.</p>', 'TopicRefreshSchedule$BasedOnSpiceSchedule' => '<p>A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE dataset.</p>', 'UpdateAccountSettingsRequest$TerminationProtectionEnabled' => '<p>A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A <code>True</code> value doesn\'t allow the account to be deleted and results in an error message if a user tries to make a <code>DeleteAccountSubscription</code> request. A <code>False</code> value will allow the account to be deleted.</p>', 'UpdatePublicSharingSettingsRequest$PublicSharingEnabled' => '<p>A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account.</p>', 'UpdateUserRequest$UnapplyCustomPermissions' => '<p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn\'t accept any other value.</p>', 'UploadSettings$ContainsHeader' => '<p>Whether the file has a header row, or the files each have a header row.</p>', 'User$Active' => '<p>The active status of user. When you create an Amazon QuickSight user that\'s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'CustomValuesConfiguration$IncludeNullValue' => '<p>Includes the null value in custom action parameter values.</p>', ], ], 'BorderStyle' => [ 'base' => '<p>The display options for tile borders for visuals.</p>', 'refs' => [ 'TileStyle$Border' => '<p>The border around a tile.</p>', ], ], 'BoxPlotAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well for a box plot.</p>', 'refs' => [ 'BoxPlotFieldWells$BoxPlotAggregatedFieldWells' => '<p>The aggregated field wells of a box plot.</p>', ], ], 'BoxPlotChartConfiguration' => [ 'base' => '<p>The configuration of a <code>BoxPlotVisual</code>.</p>', 'refs' => [ 'BoxPlotVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'BoxPlotDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'BoxPlotAggregatedFieldWells$GroupBy' => '<p>The group by field well of a box plot chart. Values are grouped based on group by fields.</p>', ], ], 'BoxPlotFieldWells' => [ 'base' => '<p>The field wells of a <code>BoxPlotVisual</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'BoxPlotChartConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'BoxPlotFillStyle' => [ 'base' => NULL, 'refs' => [ 'BoxPlotStyleOptions$FillStyle' => '<p>The fill styles (solid, transparent) of the box plot.</p>', ], ], 'BoxPlotMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'BoxPlotAggregatedFieldWells$Values' => '<p>The value field well of a box plot chart. Values are aggregated based on group by fields.</p>', ], ], 'BoxPlotOptions' => [ 'base' => '<p>The options of a box plot visual.</p>', 'refs' => [ 'BoxPlotChartConfiguration$BoxPlotOptions' => '<p>The box plot chart options for a box plot visual</p>', ], ], 'BoxPlotSortConfiguration' => [ 'base' => '<p>The sort configuration of a <code>BoxPlotVisual</code>.</p>', 'refs' => [ 'BoxPlotChartConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>BoxPlotVisual</code>.</p>', ], ], 'BoxPlotStyleOptions' => [ 'base' => '<p>The style options of the box plot.</p>', 'refs' => [ 'BoxPlotOptions$StyleOptions' => '<p>The style options of the box plot.</p>', ], ], 'BoxPlotVisual' => [ 'base' => '<p>A box plot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box plots</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$BoxPlotVisual' => '<p>A box plot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box plots</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'CIDR' => [ 'base' => NULL, 'refs' => [ 'IpRestrictionRuleMap$key' => NULL, ], ], 'CalculatedColumn' => [ 'base' => '<p>A calculated column for a dataset.</p>', 'refs' => [ 'CalculatedColumnList$member' => NULL, ], ], 'CalculatedColumnList' => [ 'base' => NULL, 'refs' => [ 'CreateColumnsOperation$Columns' => '<p>Calculated columns to create.</p>', ], ], 'CalculatedField' => [ 'base' => '<p>The calculated field of an analysis.</p>', 'refs' => [ 'CalculatedFields$member' => NULL, ], ], 'CalculatedFieldExpression' => [ 'base' => NULL, 'refs' => [ 'CalculatedField$Expression' => '<p>The expression of the calculated field.</p>', ], ], 'CalculatedFieldReferenceList' => [ 'base' => NULL, 'refs' => [ 'TopicIRMetric$CalculatedFieldReferences' => '<p>The calculated field references for the <code>TopicIRMetric</code>.</p>', ], ], 'CalculatedFields' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$CalculatedFields' => '<p>An array of calculated field definitions for the analysis.</p>', 'DashboardVersionDefinition$CalculatedFields' => '<p>An array of calculated field definitions for the dashboard.</p>', 'TemplateVersionDefinition$CalculatedFields' => '<p>An array of calculated field definitions for the template.</p>', ], ], 'CalculatedMeasureField' => [ 'base' => '<p>The table calculation measure field for pivot tables.</p>', 'refs' => [ 'MeasureField$CalculatedMeasureField' => '<p>The calculated measure field only used in pivot tables.</p>', ], ], 'CancelIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CascadingControlConfiguration' => [ 'base' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', 'refs' => [ 'FilterCrossSheetControl$CascadingControlConfiguration' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', 'FilterDropDownControl$CascadingControlConfiguration' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', 'FilterListControl$CascadingControlConfiguration' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', 'ParameterDropDownControl$CascadingControlConfiguration' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', 'ParameterListControl$CascadingControlConfiguration' => '<p>The values that are displayed in a control can be configured to only show values that are valid based on what\'s selected in other controls.</p>', ], ], 'CascadingControlSource' => [ 'base' => '<p>The source controls that are used in a <code>CascadingControlConfiguration</code>.</p>', 'refs' => [ 'CascadingControlSourceList$member' => NULL, ], ], 'CascadingControlSourceList' => [ 'base' => NULL, 'refs' => [ 'CascadingControlConfiguration$SourceControls' => '<p>A list of source controls that determine the values that are used in the current control.</p>', ], ], 'CastColumnTypeOperation' => [ 'base' => '<p>A transform operation that casts a column to a different type.</p>', 'refs' => [ 'TransformOperation$CastColumnTypeOperation' => '<p>A transform operation that casts a column to a different type.</p>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'PrestoParameters$Catalog' => '<p>Catalog.</p>', 'StarburstParameters$Catalog' => '<p>The catalog name for the Starburst data source.</p>', 'TrinoParameters$Catalog' => '<p>The catalog name for the Trino data source.</p>', ], ], 'CategoricalAggregationFunction' => [ 'base' => NULL, 'refs' => [ 'AggregationFunction$CategoricalAggregationFunction' => '<p>Aggregation for categorical values.</p> <ul> <li> <p> <code>COUNT</code>: Aggregate by the total number of values, including duplicates.</p> </li> <li> <p> <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.</p> </li> </ul>', 'CategoricalMeasureField$AggregationFunction' => '<p>The aggregation function of the measure field.</p>', ], ], 'CategoricalDimensionField' => [ 'base' => '<p>The dimension type field with categorical type columns..</p>', 'refs' => [ 'DimensionField$CategoricalDimensionField' => '<p>The dimension type field with categorical type columns.</p>', ], ], 'CategoricalMeasureField' => [ 'base' => '<p>The measure type field with categorical type columns.</p>', 'refs' => [ 'MeasureField$CategoricalMeasureField' => '<p>The measure type field with categorical type columns.</p>', ], ], 'CategoryDrillDownFilter' => [ 'base' => '<p>The category drill down filter.</p>', 'refs' => [ 'DrillDownFilter$CategoryFilter' => '<p>The category type drill down filter. This filter is used for string type columns.</p>', ], ], 'CategoryFilter' => [ 'base' => '<p>A <code>CategoryFilter</code> filters text values.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text filters</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Filter$CategoryFilter' => '<p>A <code>CategoryFilter</code> filters text values.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text filters</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'CategoryFilterConfiguration' => [ 'base' => '<p>The configuration for a <code>CategoryFilter</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'CategoryFilter$Configuration' => '<p>The configuration for a <code>CategoryFilter</code>.</p>', 'CategoryInnerFilter$Configuration' => NULL, ], ], 'CategoryFilterFunction' => [ 'base' => NULL, 'refs' => [ 'TopicCategoryFilter$CategoryFilterFunction' => '<p>The category filter function. Valid values for this structure are <code>EXACT</code> and <code>CONTAINS</code>.</p>', ], ], 'CategoryFilterMatchOperator' => [ 'base' => NULL, 'refs' => [ 'CustomFilterConfiguration$MatchOperator' => '<p>The match operator that is used to determine if a filter should be applied.</p>', 'CustomFilterListConfiguration$MatchOperator' => '<p>The match operator that is used to determine if a filter should be applied.</p>', 'FilterListConfiguration$MatchOperator' => '<p>The match operator that is used to determine if a filter should be applied.</p>', ], ], 'CategoryFilterSelectAllOptions' => [ 'base' => NULL, 'refs' => [ 'CustomFilterConfiguration$SelectAllOptions' => '<p>Select all of the values. Null is not the assigned value of select all.</p> <ul> <li> <p> <code>FILTER_ALL_VALUES</code> </p> </li> </ul>', 'CustomFilterListConfiguration$SelectAllOptions' => '<p>Select all of the values. Null is not the assigned value of select all.</p> <ul> <li> <p> <code>FILTER_ALL_VALUES</code> </p> </li> </ul>', 'FilterListConfiguration$SelectAllOptions' => '<p>Select all of the values. Null is not the assigned value of select all.</p> <ul> <li> <p> <code>FILTER_ALL_VALUES</code> </p> </li> </ul>', ], ], 'CategoryFilterType' => [ 'base' => NULL, 'refs' => [ 'TopicCategoryFilter$CategoryFilterType' => '<p>The category filter type. This element is used to specify whether a filter is a simple category filter or an inverse category filter.</p>', ], ], 'CategoryInnerFilter' => [ 'base' => '<p>A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.</p>', 'refs' => [ 'InnerFilter$CategoryInnerFilter' => '<p>A <code>CategoryInnerFilter</code> filters text values for the <code>NestedFilter</code>.</p>', ], ], 'CategoryValue' => [ 'base' => NULL, 'refs' => [ 'CategoryValueList$member' => NULL, 'CustomFilterConfiguration$CategoryValue' => '<p>The category value for the filter.</p> <p>This field is mutually exclusive to <code>ParameterName</code>.</p>', ], ], 'CategoryValueList' => [ 'base' => NULL, 'refs' => [ 'CategoryDrillDownFilter$CategoryValues' => '<p>A list of the string inputs that are the values of the category drill down filter.</p>', 'CustomFilterListConfiguration$CategoryValues' => '<p>The list of category values for the filter.</p>', 'FilterListConfiguration$CategoryValues' => '<p>The list of category values for the filter.</p>', ], ], 'CellValueSynonym' => [ 'base' => '<p>A structure that represents the cell value synonym.</p>', 'refs' => [ 'CellValueSynonyms$member' => NULL, ], ], 'CellValueSynonyms' => [ 'base' => NULL, 'refs' => [ 'TopicCalculatedField$CellValueSynonyms' => '<p>The other names or aliases for the calculated field cell value.</p>', 'TopicColumn$CellValueSynonyms' => '<p>The other names or aliases for the column cell value.</p>', ], ], 'ChartAxisLabelOptions' => [ 'base' => '<p>The label options for an axis on a chart.</p>', 'refs' => [ 'BarChartConfiguration$CategoryLabelOptions' => '<p>The label options (label text, label visibility and sort icon visibility) for a bar chart.</p>', 'BarChartConfiguration$ValueLabelOptions' => '<p>The label options (label text, label visibility and sort icon visibility) for a bar chart value.</p>', 'BarChartConfiguration$ColorLabelOptions' => '<p>The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.</p>', 'BoxPlotChartConfiguration$CategoryLabelOptions' => '<p>The label options (label text, label visibility and sort Icon visibility) of a box plot category.</p>', 'BoxPlotChartConfiguration$PrimaryYAxisLabelOptions' => '<p>The label options (label text, label visibility and sort icon visibility) of a box plot value.</p>', 'ComboChartConfiguration$CategoryLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.</p>', 'ComboChartConfiguration$PrimaryYAxisLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of a combo chart\'s primary y-axis (bar) field well.</p>', 'ComboChartConfiguration$SecondaryYAxisLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of a combo chart\'s secondary y-axis(line) field well.</p>', 'ComboChartConfiguration$ColorLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of a combo chart\'s color field well.</p>', 'FunnelChartConfiguration$CategoryLabelOptions' => '<p>The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.</p>', 'FunnelChartConfiguration$ValueLabelOptions' => '<p>The label options for the values that are displayed in a <code>FunnelChartVisual</code>.</p>', 'HeatMapConfiguration$RowLabelOptions' => '<p>The label options of the row that is displayed in a <code>heat map</code>.</p>', 'HeatMapConfiguration$ColumnLabelOptions' => '<p>The label options of the column that is displayed in a heat map.</p>', 'HistogramConfiguration$XAxisLabelOptions' => '<p>The options that determine the presentation of the x-axis label.</p>', 'LineChartConfiguration$XAxisLabelOptions' => '<p>The options that determine the presentation of the x-axis label.</p>', 'LineChartConfiguration$PrimaryYAxisLabelOptions' => '<p>The options that determine the presentation of the y-axis label.</p>', 'LineChartConfiguration$SecondaryYAxisLabelOptions' => '<p>The options that determine the presentation of the secondary y-axis label.</p>', 'PieChartConfiguration$CategoryLabelOptions' => '<p>The label options of the group/color that is displayed in a pie chart.</p>', 'PieChartConfiguration$ValueLabelOptions' => '<p>The label options for the value that is displayed in a pie chart.</p>', 'RadarChartConfiguration$CategoryLabelOptions' => '<p>The category label options of a radar chart.</p>', 'RadarChartConfiguration$ColorLabelOptions' => '<p>The color label options of a radar chart.</p>', 'ScatterPlotConfiguration$XAxisLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of the scatter plot\'s x-axis.</p>', 'ScatterPlotConfiguration$YAxisLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) of the scatter plot\'s y-axis.</p>', 'TreeMapConfiguration$GroupLabelOptions' => '<p>The label options (label text, label visibility) of the groups that are displayed in a tree map.</p>', 'TreeMapConfiguration$SizeLabelOptions' => '<p>The label options (label text, label visibility) of the sizes that are displayed in a tree map.</p>', 'TreeMapConfiguration$ColorLabelOptions' => '<p>The label options (label text, label visibility) for the colors displayed in a tree map.</p>', 'WaterfallChartConfiguration$CategoryAxisLabelOptions' => '<p>The options that determine the presentation of the category axis label.</p>', 'WaterfallChartConfiguration$PrimaryYAxisLabelOptions' => '<p>The options that determine the presentation of the y-axis label.</p>', 'WordCloudChartConfiguration$CategoryLabelOptions' => '<p>The label options (label text, label visibility, and sort icon visibility) for the word cloud category.</p>', ], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$ClusterId' => '<p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.</p>', ], ], 'ClusterMarker' => [ 'base' => '<p>The cluster marker that is a part of the cluster marker configuration.</p>', 'refs' => [ 'ClusterMarkerConfiguration$ClusterMarker' => '<p>The cluster marker that is a part of the cluster marker configuration.</p>', ], ], 'ClusterMarkerConfiguration' => [ 'base' => '<p>The cluster marker configuration of the geospatial map selected point style.</p>', 'refs' => [ 'GeospatialPointStyleOptions$ClusterMarkerConfiguration' => '<p>The cluster marker configuration of the geospatial point style.</p>', ], ], 'CollectiveConstant' => [ 'base' => '<p>A structure that represents a collective constant.</p>', 'refs' => [ 'TopicCategoryFilterConstant$CollectiveConstant' => '<p>A collective constant used in a category filter. This element is used to specify a list of values for the constant.</p>', ], ], 'CollectiveConstantEntry' => [ 'base' => '<p>The definition for a <code>CollectiveConstantEntry</code>.</p>', 'refs' => [ 'CollectiveConstantEntryList$member' => NULL, ], ], 'CollectiveConstantEntryList' => [ 'base' => NULL, 'refs' => [ 'TopicConstantValue$ValueList' => '<p>The value list of the <code>TopicConstantValue</code>.</p>', ], ], 'ColorFillType' => [ 'base' => NULL, 'refs' => [ 'ColorScale$ColorFillType' => '<p>Determines the color fill type.</p>', ], ], 'ColorList' => [ 'base' => NULL, 'refs' => [ 'DataColorPalette$Colors' => '<p>The hexadecimal codes for the colors.</p>', 'DataColorPalette$MinMaxGradient' => '<p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>', ], ], 'ColorScale' => [ 'base' => '<p>Determines the color scale that is applied to the visual.</p>', 'refs' => [ 'HeatMapConfiguration$ColorScale' => '<p>The color options (gradient color, point of divergence) in a heat map.</p>', 'TreeMapConfiguration$ColorScale' => '<p>The color options (gradient color, point of divergence) of a tree map.</p>', ], ], 'ColorScaleColorList' => [ 'base' => NULL, 'refs' => [ 'ColorScale$Colors' => '<p>Determines the list of colors that are applied to the visual.</p>', ], ], 'ColorsConfiguration' => [ 'base' => '<p>The color configurations for a column.</p>', 'refs' => [ 'ColumnConfiguration$ColorsConfiguration' => '<p>The color configurations of the column.</p>', ], ], 'ColumnConfiguration' => [ 'base' => '<p>The general configuration of a column.</p>', 'refs' => [ 'ColumnConfigurationList$member' => NULL, ], ], 'ColumnConfigurationList' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$ColumnConfigurations' => '<p> An array of analysis-level column configurations. Column configurations can be used to set default formatting for a column to be used throughout an analysis. </p>', 'DashboardVersionDefinition$ColumnConfigurations' => '<p>An array of dashboard-level column configurations. Column configurations are used to set the default formatting for a column that is used throughout a dashboard. </p>', 'TemplateVersionDefinition$ColumnConfigurations' => '<p> An array of template-level column configurations. Column configurations are used to set default formatting for a column that\'s used throughout a template. </p>', ], ], 'ColumnDataRole' => [ 'base' => NULL, 'refs' => [ 'TopicCalculatedField$ColumnDataRole' => '<p>The column data role for a calculated field. Valid values for this structure are <code>DIMENSION</code> and <code>MEASURE</code>.</p>', 'TopicColumn$ColumnDataRole' => '<p>The role of the column in the data. Valid values are <code>DIMENSION</code> and <code>MEASURE</code>.</p>', ], ], 'ColumnDataSubType' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$SubType' => '<p>The sub data type of the new column. Sub types are only available for decimal columns that are part of a SPICE dataset.</p>', 'InputColumn$SubType' => '<p>The sub data type of the column. Sub types are only available for decimal columns that are part of a SPICE dataset.</p>', 'OutputColumn$SubType' => '<p>The sub data type of the column.</p>', ], ], 'ColumnDataType' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$NewColumnType' => '<p>New column data type.</p>', 'OutputColumn$Type' => '<p>The data type of the column.</p>', ], ], 'ColumnDescription' => [ 'base' => '<p>Metadata that contains a description for a column.</p>', 'refs' => [ 'ColumnTag$ColumnDescription' => '<p>A description for a column.</p>', ], ], 'ColumnDescriptiveText' => [ 'base' => NULL, 'refs' => [ 'ColumnDescription$Text' => '<p>The text of a description for a column.</p>', 'OutputColumn$Description' => '<p>A description for a column.</p>', ], ], 'ColumnGroup' => [ 'base' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnGroupList$member' => NULL, ], ], 'ColumnGroupColumnSchema' => [ 'base' => '<p>A structure describing the name, data type, and geographic role of the columns.</p>', 'refs' => [ 'ColumnGroupColumnSchemaList$member' => NULL, ], ], 'ColumnGroupColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'ColumnGroupSchema$ColumnGroupColumnSchemaList' => '<p>A structure containing the list of schemas for column group columns.</p>', ], ], 'ColumnGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'DataSet$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'UpdateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', ], ], 'ColumnGroupName' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Name' => '<p>A display name for the hierarchy.</p>', ], ], 'ColumnGroupSchema' => [ 'base' => '<p>The column group schema.</p>', 'refs' => [ 'ColumnGroupSchemaList$member' => NULL, ], ], 'ColumnGroupSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetConfiguration$ColumnGroupSchemaList' => '<p>A structure containing the list of column group schemas.</p>', ], ], 'ColumnHierarchy' => [ 'base' => '<p>The option that determines the hierarchy of the fields for a visual element.</p>', 'refs' => [ 'ColumnHierarchyList$member' => NULL, ], ], 'ColumnHierarchyList' => [ 'base' => NULL, 'refs' => [ 'BarChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'BoxPlotVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'ComboChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'FilledMapVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'FunnelChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'GeospatialMapVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'HeatMapVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'KPIVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'LineChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'PieChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'RadarChartVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'ScatterPlotVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'TreeMapVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'WaterfallVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', 'WordCloudVisual$ColumnHierarchies' => '<p>The column hierarchy that is used during drill-downs and drill-ups.</p>', ], ], 'ColumnId' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnId' => '<p>A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.</p>', ], ], 'ColumnIdentifier' => [ 'base' => '<p>A column of a data set.</p>', 'refs' => [ 'AggregationSortConfiguration$Column' => '<p>The column that determines the sort order of aggregated values.</p>', 'AxisLabelReferenceOptions$Column' => '<p>The column that the axis label is targeted to.</p>', 'BodySectionDynamicCategoryDimensionConfiguration$Column' => NULL, 'BodySectionDynamicNumericDimensionConfiguration$Column' => NULL, 'CascadingControlSource$ColumnToMatch' => '<p>The column identifier that determines which column to look up for the source sheet control.</p>', 'CategoricalDimensionField$Column' => '<p>The column that is used in the <code>CategoricalDimensionField</code>.</p>', 'CategoricalMeasureField$Column' => '<p>The column that is used in the <code>CategoricalMeasureField</code>.</p>', 'CategoryDrillDownFilter$Column' => '<p>The column that the filter is applied to.</p>', 'CategoryFilter$Column' => '<p>The column that the filter is applied to.</p>', 'CategoryInnerFilter$Column' => NULL, 'ColumnConfiguration$Column' => '<p>The column.</p>', 'ColumnSort$SortBy' => NULL, 'ColumnTooltipItem$Column' => '<p>The target column of the tooltip item.</p>', 'ContributorDimensionList$member' => NULL, 'CustomActionColumnList$member' => NULL, 'DateDimensionField$Column' => '<p>The column that is used in the <code>DateDimensionField</code>.</p>', 'DateMeasureField$Column' => '<p>The column that is used in the <code>DateMeasureField</code>.</p>', 'DestinationParameterValueConfiguration$SourceColumn' => NULL, 'DynamicDefaultValue$UserNameColumn' => '<p>The column that contains the username.</p>', 'DynamicDefaultValue$GroupNameColumn' => '<p>The column that contains the group name.</p>', 'DynamicDefaultValue$DefaultValueColumn' => '<p>The column that contains the default value of each user or group.</p>', 'ExplicitHierarchyColumnList$member' => NULL, 'NestedFilter$Column' => '<p>The column that the filter is applied to.</p>', 'NumericEqualityDrillDownFilter$Column' => '<p>The column that the filter is applied to.</p>', 'NumericEqualityFilter$Column' => '<p>The column that the filter is applied to.</p>', 'NumericRangeFilter$Column' => '<p>The column that the filter is applied to.</p>', 'NumericalDimensionField$Column' => '<p>The column that is used in the <code>NumericalDimensionField</code>.</p>', 'NumericalMeasureField$Column' => '<p>The column that is used in the <code>NumericalMeasureField</code>.</p>', 'ParameterSelectableValues$LinkToDataSetColumn' => '<p>The column identifier that fetches values from the data set.</p>', 'PredefinedHierarchyColumnList$member' => NULL, 'ReferenceLineDynamicDataConfiguration$Column' => '<p>The column that the dynamic data targets.</p>', 'RelativeDatesFilter$Column' => '<p>The column that the filter is applied to.</p>', 'TimeEqualityFilter$Column' => '<p>The column that the filter is applied to.</p>', 'TimeRangeDrillDownFilter$Column' => '<p>The column that the filter is applied to.</p>', 'TimeRangeFilter$Column' => '<p>The column that the filter is applied to.</p>', 'TopBottomFilter$Column' => '<p>The column that the filter is applied to.</p>', 'UnaggregatedField$Column' => '<p>The column that is used in the <code>UnaggregatedField</code>.</p>', ], ], 'ColumnLevelPermissionRule' => [ 'base' => '<p>A rule defined to grant access on one or more restricted columns. Each dataset can have multiple rules. To create a restricted column, you add it to one or more rules. Each rule must contain at least one column and at least one user or group. To be able to see a restricted column, a user or group needs to be added to a rule for that column.</p>', 'refs' => [ 'ColumnLevelPermissionRuleList$member' => NULL, ], ], 'ColumnLevelPermissionRuleList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>', 'DataSet$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>', 'UpdateDataSetRequest$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Columns' => '<p>Columns in this hierarchy.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnName' => '<p>Column name.</p>', 'CalculatedField$Name' => '<p>The name of the calculated field.</p>', 'CastColumnTypeOperation$ColumnName' => '<p>Column name.</p>', 'ColumnIdentifier$ColumnName' => '<p>The name of the column.</p>', 'ColumnList$member' => NULL, 'InputColumn$Name' => '<p>The name of this column in the underlying data source.</p>', 'OutputColumn$Name' => '<p>The display name of the column..</p>', 'RenameColumnOperation$ColumnName' => '<p>The name of the column to be renamed.</p>', 'RenameColumnOperation$NewColumnName' => '<p>The new name for the column.</p>', 'TagColumnOperation$ColumnName' => '<p>The column that this operation acts on.</p>', 'UntagColumnOperation$ColumnName' => '<p>The column that this operation acts on.</p>', ], ], 'ColumnNameList' => [ 'base' => NULL, 'refs' => [ 'ColumnLevelPermissionRule$ColumnNames' => '<p>An array of column names.</p>', ], ], 'ColumnOrderingType' => [ 'base' => NULL, 'refs' => [ 'ComparativeOrder$UseOrdering' => '<p>The ordering type for a column. Valid values for this structure are <code>GREATER_IS_BETTER</code>, <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code>.</p>', ], ], 'ColumnRole' => [ 'base' => NULL, 'refs' => [ 'ColumnConfiguration$Role' => '<p>The role of the column.</p>', ], ], 'ColumnSchema' => [ 'base' => '<p>The column schema.</p>', 'refs' => [ 'ColumnSchemaList$member' => NULL, ], ], 'ColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetSchema$ColumnSchemaList' => '<p>A structure containing the list of column schemas.</p>', ], ], 'ColumnSort' => [ 'base' => '<p>The sort configuration for a column that is not used in a field well.</p>', 'refs' => [ 'BodySectionDynamicDimensionSortConfigurationList$member' => NULL, 'FieldSortOptions$ColumnSort' => '<p>The sort configuration for a column that is not used in a field well.</p>', 'PivotTableSortBy$Column' => '<p>The column sort (field id, direction) for the pivot table sort by options.</p>', ], ], 'ColumnTag' => [ 'base' => '<p>A tag for a column in a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html">TagColumnOperation</a> </code> structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnTagList$member' => NULL, ], ], 'ColumnTagList' => [ 'base' => NULL, 'refs' => [ 'TagColumnOperation$Tags' => '<p>The dataset column tag, currently only used for geospatial type tagging.</p> <note> <p>This is not tags for the Amazon Web Services tagging feature.</p> </note>', ], ], 'ColumnTagName' => [ 'base' => NULL, 'refs' => [ 'ColumnTagNames$member' => NULL, ], ], 'ColumnTagNames' => [ 'base' => NULL, 'refs' => [ 'UntagColumnOperation$TagNames' => '<p>The column tags to remove from this column.</p>', ], ], 'ColumnTooltipItem' => [ 'base' => '<p>The tooltip item for the columns that are not part of a field well.</p>', 'refs' => [ 'TooltipItem$ColumnTooltipItem' => '<p>The tooltip item for the columns that are not part of a field well.</p>', ], ], 'ComboChartAggregatedFieldWells' => [ 'base' => '<p>The aggregated field wells of a combo chart.</p>', 'refs' => [ 'ComboChartFieldWells$ComboChartAggregatedFieldWells' => '<p>The aggregated field wells of a combo chart. Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.</p>', ], ], 'ComboChartConfiguration' => [ 'base' => '<p>The configuration of a <code>ComboChartVisual</code>.</p>', 'refs' => [ 'ComboChartVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'ComboChartFieldWells' => [ 'base' => '<p>The field wells of the visual.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ComboChartConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'ComboChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a <code>ComboChartVisual</code>.</p>', 'refs' => [ 'ComboChartConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>ComboChartVisual</code>.</p>', ], ], 'ComboChartVisual' => [ 'base' => '<p>A combo chart.</p> <p>The <code>ComboChartVisual</code> includes stacked bar combo charts and clustered bar combo charts</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$ComboChartVisual' => '<p>A combo chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'ComparativeOrder' => [ 'base' => '<p>A structure that represents a comparative order.</p>', 'refs' => [ 'TopicCalculatedField$ComparativeOrder' => '<p>The order in which data is displayed for the calculated field when it\'s used in a comparative context.</p>', 'TopicColumn$ComparativeOrder' => '<p>The order in which data is displayed for the column when it\'s used in a comparative context.</p>', ], ], 'ComparisonConfiguration' => [ 'base' => '<p>The comparison display configuration of a KPI or gauge chart.</p>', 'refs' => [ 'GaugeChartOptions$Comparison' => '<p>The comparison configuration of a <code>GaugeChartVisual</code>.</p>', 'KPIOptions$Comparison' => '<p>The comparison configuration of a KPI visual.</p>', ], ], 'ComparisonFormatConfiguration' => [ 'base' => '<p>The format of the comparison.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ComparisonConfiguration$ComparisonFormat' => '<p>The format of the comparison.</p>', ], ], 'ComparisonMethod' => [ 'base' => NULL, 'refs' => [ 'ComparisonConfiguration$ComparisonMethod' => '<p>The method of the comparison. Choose from the following options:</p> <ul> <li> <p> <code>DIFFERENCE</code> </p> </li> <li> <p> <code>PERCENT_DIFFERENCE</code> </p> </li> <li> <p> <code>PERCENT</code> </p> </li> </ul>', ], ], 'ComparisonMethodType' => [ 'base' => NULL, 'refs' => [ 'TopicIRComparisonMethod$Type' => '<p>The type for the <code>TopicIRComparisonMethod</code>.</p>', ], ], 'Computation' => [ 'base' => '<p>The computation union that is used in an insight visual.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ComputationList$member' => NULL, ], ], 'ComputationList' => [ 'base' => NULL, 'refs' => [ 'InsightConfiguration$Computations' => '<p>The computations configurations of the insight visual</p>', ], ], 'ConcurrentUpdatingException' => [ 'base' => '<p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>', 'refs' => [], ], 'ConditionalFormattingColor' => [ 'base' => '<p>The formatting configuration for the color.</p>', 'refs' => [ 'GaugeChartArcConditionalFormatting$ForegroundColor' => '<p>The conditional formatting of the arc foreground color.</p>', 'GaugeChartPrimaryValueConditionalFormatting$TextColor' => '<p>The conditional formatting of the primary value text color.</p>', 'KPIActualValueConditionalFormatting$TextColor' => '<p>The conditional formatting of the actual value\'s text color.</p>', 'KPIComparisonValueConditionalFormatting$TextColor' => '<p>The conditional formatting of the comparison value\'s text color.</p>', 'KPIPrimaryValueConditionalFormatting$TextColor' => '<p>The conditional formatting of the primary value\'s text color.</p>', 'KPIProgressBarConditionalFormatting$ForegroundColor' => '<p>The conditional formatting of the progress bar\'s foreground color.</p>', 'ShapeConditionalFormat$BackgroundColor' => '<p>The conditional formatting for the shape background color of a filled map visual.</p>', 'TableRowConditionalFormatting$BackgroundColor' => '<p>The conditional formatting color (solid, gradient) of the background for a table row.</p>', 'TableRowConditionalFormatting$TextColor' => '<p>The conditional formatting color (solid, gradient) of the text for a table row.</p>', 'TextConditionalFormat$BackgroundColor' => '<p>The conditional formatting for the text background color.</p>', 'TextConditionalFormat$TextColor' => '<p>The conditional formatting for the text color.</p>', ], ], 'ConditionalFormattingCustomIconCondition' => [ 'base' => '<p>Determines the custom condition for an icon set.</p>', 'refs' => [ 'ConditionalFormattingIcon$CustomCondition' => '<p>Determines the custom condition for an icon set.</p>', ], ], 'ConditionalFormattingCustomIconOptions' => [ 'base' => '<p>Custom icon options for an icon set.</p>', 'refs' => [ 'ConditionalFormattingCustomIconCondition$IconOptions' => '<p>Custom icon options for an icon set.</p>', ], ], 'ConditionalFormattingGradientColor' => [ 'base' => '<p>Formatting configuration for gradient color.</p>', 'refs' => [ 'ConditionalFormattingColor$Gradient' => '<p>Formatting configuration for gradient color.</p>', ], ], 'ConditionalFormattingIcon' => [ 'base' => '<p>The formatting configuration for the icon.</p>', 'refs' => [ 'GaugeChartPrimaryValueConditionalFormatting$Icon' => '<p>The conditional formatting of the primary value icon.</p>', 'KPIActualValueConditionalFormatting$Icon' => '<p>The conditional formatting of the actual value\'s icon.</p>', 'KPIComparisonValueConditionalFormatting$Icon' => '<p>The conditional formatting of the comparison value\'s icon.</p>', 'KPIPrimaryValueConditionalFormatting$Icon' => '<p>The conditional formatting of the primary value\'s icon.</p>', 'TextConditionalFormat$Icon' => '<p>The conditional formatting for the icon.</p>', ], ], 'ConditionalFormattingIconDisplayConfiguration' => [ 'base' => '<p>Determines the icon display configuration.</p>', 'refs' => [ 'ConditionalFormattingCustomIconCondition$DisplayConfiguration' => '<p>Determines the icon display configuration.</p>', ], ], 'ConditionalFormattingIconDisplayOption' => [ 'base' => NULL, 'refs' => [ 'ConditionalFormattingIconDisplayConfiguration$IconDisplayOption' => '<p>Determines the icon display configuration.</p>', ], ], 'ConditionalFormattingIconSet' => [ 'base' => '<p>Formatting configuration for icon set.</p>', 'refs' => [ 'ConditionalFormattingIcon$IconSet' => '<p>Formatting configuration for icon set.</p>', ], ], 'ConditionalFormattingIconSetType' => [ 'base' => NULL, 'refs' => [ 'ConditionalFormattingIconSet$IconSetType' => '<p>Determines the icon set type.</p>', ], ], 'ConditionalFormattingSolidColor' => [ 'base' => '<p>Formatting configuration for solid color.</p>', 'refs' => [ 'ConditionalFormattingColor$Solid' => '<p>Formatting configuration for solid color.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'ConstantType' => [ 'base' => NULL, 'refs' => [ 'CollectiveConstantEntry$ConstantType' => '<p>The <code>ConstantType</code> of a <code>CollectiveConstantEntry</code>.</p>', 'TopicCategoryFilterConstant$ConstantType' => '<p>The type of category filter constant. This element is used to specify whether a constant is a singular or collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.</p>', 'TopicConstantValue$ConstantType' => '<p>The constant type of a <code>TopicConstantValue</code>.</p>', 'TopicRangeFilterConstant$ConstantType' => '<p>The data type of the constant value that is used in a range filter. Valid values for this structure are <code>RANGE</code>.</p>', 'TopicSingularFilterConstant$ConstantType' => '<p>The type of the singular filter constant. Valid values for this structure are <code>SINGULAR</code>.</p>', ], ], 'ConstantValueString' => [ 'base' => NULL, 'refs' => [ 'CollectiveConstantEntry$Value' => '<p>The value of a <code>CollectiveConstantEntry</code>.</p>', 'TopicConstantValue$Value' => '<p>The value of the <code>TopicConstantValue</code>.</p>', 'TopicConstantValue$Minimum' => '<p>The minimum for the <code>TopicConstantValue</code>.</p>', 'TopicConstantValue$Maximum' => '<p>The maximum for the <code>TopicConstantValue</code>.</p>', ], ], 'ContextMenuOption' => [ 'base' => '<p>The context menu options for a visual\'s interactions.</p>', 'refs' => [ 'VisualInteractionOptions$ContextMenuOption' => '<p>The context menu options for a visual.</p>', ], ], 'ContributionAnalysisDefault' => [ 'base' => '<p>The contribution analysis visual display for a line, pie, or bar chart.</p>', 'refs' => [ 'ContributionAnalysisDefaultList$member' => NULL, ], ], 'ContributionAnalysisDefaultList' => [ 'base' => NULL, 'refs' => [ 'BarChartConfiguration$ContributionAnalysisDefaults' => '<p>The contribution analysis (anomaly configuration) setup of the visual.</p>', 'LineChartConfiguration$ContributionAnalysisDefaults' => '<p>The default configuration of a line chart\'s contribution analysis.</p>', 'PieChartConfiguration$ContributionAnalysisDefaults' => '<p>The contribution analysis (anomaly configuration) setup of the visual.</p>', ], ], 'ContributionAnalysisDirection' => [ 'base' => NULL, 'refs' => [ 'TopicIRContributionAnalysis$Direction' => '<p>The direction for the <code>TopicIRContributionAnalysis</code>.</p>', ], ], 'ContributionAnalysisFactor' => [ 'base' => '<p>The definition for the <code>ContributionAnalysisFactor</code>.</p>', 'refs' => [ 'ContributionAnalysisFactorsList$member' => NULL, ], ], 'ContributionAnalysisFactorsList' => [ 'base' => NULL, 'refs' => [ 'TopicIRContributionAnalysis$Factors' => '<p>The factors for a <code>TopicIRContributionAnalysis</code>.</p>', ], ], 'ContributionAnalysisSortType' => [ 'base' => NULL, 'refs' => [ 'TopicIRContributionAnalysis$SortType' => '<p>The sort type for the <code>TopicIRContributionAnalysis</code>.</p>', ], ], 'ContributionAnalysisTimeRanges' => [ 'base' => '<p>The definition for the <code>ContributionAnalysisTimeRanges</code>.</p>', 'refs' => [ 'TopicIRContributionAnalysis$TimeRanges' => '<p>The time ranges for the <code>TopicIRContributionAnalysis</code>.</p>', ], ], 'ContributorDimensionList' => [ 'base' => NULL, 'refs' => [ 'ContributionAnalysisDefault$ContributorDimensions' => '<p>The dimensions columns that are used in the contribution analysis, usually a list of <code>ColumnIdentifiers</code>.</p>', ], ], 'CopySourceArn' => [ 'base' => NULL, 'refs' => [ 'DataSourceCredentials$CopySourceArn' => '<p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the credentials for the <code>DataSourceCredentials</code> structure.</p>', ], ], 'CreateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateColumnsOperation' => [ 'base' => '<p>A transform operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', 'refs' => [ 'TransformOperation$CreateColumnsOperation' => '<p>An operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', ], ], 'CreateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => '<p>The request object for this operation. </p>', 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => '<p>The response object for this operation.</p>', 'refs' => [], ], 'CreateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoleMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoleMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicReviewedAnswer' => [ 'base' => '<p>The definition for a <code>CreateTopicReviewedAnswer</code>.</p>', 'refs' => [ 'CreateTopicReviewedAnswers$member' => NULL, ], ], 'CreateTopicReviewedAnswers' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerRequest$Answers' => '<p>The definition of the Answers to be created.</p>', ], ], 'CreateVPCConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVPCConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CredentialPair' => [ 'base' => '<p>The combination of user name and password that are used as credentials.</p>', 'refs' => [ 'DataSourceCredentials$CredentialPair' => '<p>Credential pair. For more information, see <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> </code>.</p>', ], ], 'CrossDatasetTypes' => [ 'base' => NULL, 'refs' => [ 'FilterGroup$CrossDataset' => '<p>The filter new feature which can apply filter group to all data sets. Choose one of the following options:</p> <ul> <li> <p> <code>ALL_DATASETS</code> </p> </li> <li> <p> <code>SINGLE_DATASET</code> </p> </li> </ul>', ], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'CurrencyDisplayFormatConfiguration$Symbol' => '<p>Determines the symbol for the currency format.</p>', ], ], 'CurrencyDisplayFormatConfiguration' => [ 'base' => '<p>The options that determine the currency display format configuration.</p>', 'refs' => [ 'NumericFormatConfiguration$CurrencyDisplayFormatConfiguration' => '<p>The options that determine the currency display format configuration.</p>', ], ], 'CustomActionColumnList' => [ 'base' => NULL, 'refs' => [ 'FilterOperationSelectedFieldsConfiguration$SelectedColumns' => '<p>The selected columns of a dataset.</p>', ], ], 'CustomActionFilterOperation' => [ 'base' => '<p>The filter operation that filters data included in a visual or in an entire sheet.</p>', 'refs' => [ 'VisualCustomActionOperation$FilterOperation' => '<p>The filter operation that filters data included in a visual or in an entire sheet.</p>', ], ], 'CustomActionNavigationOperation' => [ 'base' => '<p>The navigation operation that navigates between different sheets in the same analysis.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'VisualCustomActionOperation$NavigationOperation' => '<p>The navigation operation that navigates between different sheets in the same analysis.</p>', ], ], 'CustomActionSetParametersOperation' => [ 'base' => '<p>The set parameter operation that sets parameters in custom action.</p>', 'refs' => [ 'VisualCustomActionOperation$SetParametersOperation' => '<p>The set parameter operation that sets parameters in custom action.</p>', ], ], 'CustomActionURLOperation' => [ 'base' => '<p>The URL operation that opens a link to another webpage.</p>', 'refs' => [ 'VisualCustomActionOperation$URLOperation' => '<p>The URL operation that opens a link to another webpage.</p>', ], ], 'CustomColor' => [ 'base' => '<p>Determines the color that\'s applied to a particular data value in a column.</p>', 'refs' => [ 'CustomColorsList$member' => NULL, ], ], 'CustomColorsList' => [ 'base' => NULL, 'refs' => [ 'ColorsConfiguration$CustomColors' => '<p>A list of up to 50 custom colors.</p>', ], ], 'CustomContentConfiguration' => [ 'base' => '<p>The configuration of a <code>CustomContentVisual</code>.</p>', 'refs' => [ 'CustomContentVisual$ChartConfiguration' => '<p>The configuration of a <code>CustomContentVisual</code>.</p>', ], ], 'CustomContentImageScalingConfiguration' => [ 'base' => NULL, 'refs' => [ 'CustomContentConfiguration$ImageScaling' => '<p>The sizing options for the size of the custom content visual. This structure is required when the <code>ContentType</code> of the visual is <code>\'IMAGE\'</code>.</p>', ], ], 'CustomContentType' => [ 'base' => NULL, 'refs' => [ 'CustomContentConfiguration$ContentType' => '<p>The content type of the custom content visual. You can use this to have the visual render as an image.</p>', ], ], 'CustomContentVisual' => [ 'base' => '<p>A visual that contains custom content.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual content</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$CustomContentVisual' => '<p>A visual that contains custom content.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual content</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'CustomFilterConfiguration' => [ 'base' => '<p>A custom filter that filters based on a single value. This filter can be partially matched.</p>', 'refs' => [ 'CategoryFilterConfiguration$CustomFilterConfiguration' => '<p>A custom filter that filters based on a single value. This filter can be partially matched.</p>', ], ], 'CustomFilterListConfiguration' => [ 'base' => '<p>A list of custom filter values.</p>', 'refs' => [ 'CategoryFilterConfiguration$CustomFilterListConfiguration' => '<p>A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom filter list.</p>', ], ], 'CustomLabel' => [ 'base' => NULL, 'refs' => [ 'PivotTableFieldOption$CustomLabel' => '<p>The custom label of the pivot table field.</p>', 'TableFieldOption$CustomLabel' => '<p>The custom label for a table field.</p>', ], ], 'CustomNarrativeOptions' => [ 'base' => '<p>The custom narrative options.</p>', 'refs' => [ 'InsightConfiguration$CustomNarrative' => '<p>The custom narrative of the insight visual.</p>', ], ], 'CustomParameterValues' => [ 'base' => '<p>The customized parameter values.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'CustomValuesConfiguration$CustomValues' => NULL, ], ], 'CustomSql' => [ 'base' => '<p>A physical table type built from the results of the custom SQL query.</p>', 'refs' => [ 'PhysicalTable$CustomSql' => '<p>A physical table type built from the results of the custom SQL query.</p>', ], ], 'CustomSqlName' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Name' => '<p>A display name for the SQL query result.</p>', ], ], 'CustomValuesConfiguration' => [ 'base' => '<p>The configuration of custom values for the destination parameter in <code>DestinationParameterValueConfiguration</code>.</p>', 'refs' => [ 'DestinationParameterValueConfiguration$CustomValuesConfiguration' => '<p>The configuration of custom values for destination parameter in <code>DestinationParameterValueConfiguration</code>.</p>', ], ], 'CustomerManagedKeyUnavailableException' => [ 'base' => '<p>The customer managed key that is registered to your Amazon QuickSight account is unavailable.</p>', 'refs' => [], ], 'Dashboard' => [ 'base' => '<p>Dashboard.</p>', 'refs' => [ 'DescribeDashboardResponse$Dashboard' => '<p>Information about the dashboard.</p>', ], ], 'DashboardBehavior' => [ 'base' => NULL, 'refs' => [ 'AdHocFilteringOption$AvailabilityStatus' => '<p>Availability status.</p>', 'ContextMenuOption$AvailabilityStatus' => '<p>The availability status of the context menu options. If the value of this property is set to <code>ENABLED</code>, dashboard readers can interact with the context menu.</p>', 'DataPointDrillUpDownOption$AvailabilityStatus' => '<p>The status of the drill down options of data points.</p>', 'DataPointMenuLabelOption$AvailabilityStatus' => '<p>The status of the data point menu options.</p>', 'DataPointTooltipOption$AvailabilityStatus' => '<p>The status of the data point tool tip options.</p>', 'ExportHiddenFieldsOption$AvailabilityStatus' => '<p>The status of the export hidden fields options of a dashbaord.</p>', 'ExportToCSVOption$AvailabilityStatus' => '<p>Availability status.</p>', 'ExportWithHiddenFieldsOption$AvailabilityStatus' => '<p>The status of the export with hidden fields options.</p>', 'SheetLayoutElementMaximizationOption$AvailabilityStatus' => '<p>The status of the sheet layout maximization options of a dashbaord.</p>', 'VisualAxisSortOption$AvailabilityStatus' => '<p>The availaiblity status of a visual\'s axis sort options.</p>', 'VisualMenuOption$AvailabilityStatus' => '<p>The availaiblity status of a visual\'s menu options.</p>', ], ], 'DashboardError' => [ 'base' => '<p>Dashboard error.</p>', 'refs' => [ 'DashboardErrorList$member' => NULL, ], ], 'DashboardErrorList' => [ 'base' => NULL, 'refs' => [ 'DashboardVersion$Errors' => '<p>Errors associated with this dashboard version.</p>', 'DescribeDashboardDefinitionResponse$Errors' => '<p>Errors associated with this dashboard version.</p>', ], ], 'DashboardErrorType' => [ 'base' => NULL, 'refs' => [ 'DashboardError$Type' => '<p>Type.</p>', ], ], 'DashboardFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'DashboardSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example, <code>"Name": "QUICKSIGHT_OWNER"</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any dashboards with that ARN listed as one of the dashboards\'s owners or viewers are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any dashboards with that ARN listed as one of the owners of the dashboards are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any dashboards with that ARN listed as the only owner of the dashboard are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any dashboards with that ARN listed as one of the owners of the dashboards are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any dashboards with that ARN listed as one of the owners or viewers of the dashboards are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DASHBOARD_NAME</code>: Any dashboards whose names have a substring match to this value will be returned.</p> </li> </ul>', ], ], 'DashboardName' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', 'Dashboard$Name' => '<p>A display name for the dashboard.</p>', 'DashboardSummary$Name' => '<p>A display name for the dashboard.</p>', 'DescribeDashboardDefinitionResponse$Name' => '<p>The display name of the dashboard.</p>', 'UpdateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', ], ], 'DashboardPublishOptions' => [ 'base' => '<p>Dashboard publish options.</p>', 'refs' => [ 'CreateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', 'DescribeDashboardDefinitionResponse$DashboardPublishOptions' => '<p>Options for publishing the dashboard:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', 'UpdateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', ], ], 'DashboardSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for dashboards. </p>', 'refs' => [ 'DashboardSearchFilterList$member' => NULL, ], ], 'DashboardSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchDashboardsRequest$Filters' => '<p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>', ], ], 'DashboardSourceEntity' => [ 'base' => '<p>Dashboard source entity.</p>', 'refs' => [ 'CreateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'UpdateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'DashboardSourceTemplate' => [ 'base' => '<p>Dashboard source template.</p>', 'refs' => [ 'DashboardSourceEntity$SourceTemplate' => '<p>Source template.</p>', ], ], 'DashboardSummary' => [ 'base' => '<p>Dashboard summary.</p>', 'refs' => [ 'DashboardSummaryList$member' => NULL, ], ], 'DashboardSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsResponse$DashboardSummaryList' => '<p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>', 'SearchDashboardsResponse$DashboardSummaryList' => '<p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>', ], ], 'DashboardUIState' => [ 'base' => NULL, 'refs' => [ 'SheetControlsOption$VisibilityState' => '<p>Visibility state.</p>', ], ], 'DashboardVersion' => [ 'base' => '<p>Dashboard version.</p>', 'refs' => [ 'Dashboard$Version' => '<p>Version.</p>', ], ], 'DashboardVersionDefinition' => [ 'base' => '<p>The contents of a dashboard.</p>', 'refs' => [ 'CreateDashboardRequest$Definition' => '<p>The definition of a dashboard.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'DescribeDashboardDefinitionResponse$Definition' => '<p>The definition of a dashboard.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', 'UpdateDashboardRequest$Definition' => '<p>The definition of a dashboard.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', ], ], 'DashboardVersionSummary' => [ 'base' => '<p>Dashboard version summary.</p>', 'refs' => [ 'DashboardVersionSummaryList$member' => NULL, ], ], 'DashboardVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardVersionsResponse$DashboardVersionSummaryList' => '<p>A structure that contains information about each version of the dashboard.</p>', ], ], 'DashboardVisualId' => [ 'base' => '<p>A structure that contains the following elements:</p> <ul> <li> <p>The <code>DashboardId</code> of the dashboard that has the visual that you want to embed.</p> </li> <li> <p>The <code>SheetId</code> of the sheet that has the visual that you want to embed.</p> </li> <li> <p>The <code>VisualId</code> of the visual that you want to embed.</p> </li> </ul> <p>The <code>DashboardId</code>, <code>SheetId</code>, and <code>VisualId</code> can be found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual\'s on-visual menu of the Amazon QuickSight console. You can also get the <code>DashboardId</code> with a <code>ListDashboards</code> API operation.</p>', 'refs' => [ 'AnonymousUserDashboardVisualEmbeddingConfiguration$InitialDashboardVisualId' => '<p>The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this visual.</p> <p>The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>', 'RegisteredUserDashboardVisualEmbeddingConfiguration$InitialDashboardVisualId' => '<p>The visual ID for the visual that you want the user to embed. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this visual.</p> <p>The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>', ], ], 'DashboardVisualPublishOptions' => [ 'base' => '<p>The visual publish options of a visual in a dashboard</p>', 'refs' => [ 'DashboardPublishOptions$VisualPublishOptions' => '<p>The visual publish options of a visual in a dashboard.</p>', ], ], 'DataAggregation' => [ 'base' => '<p>A structure that represents a data aggregation.</p>', 'refs' => [ 'DatasetMetadata$DataAggregation' => '<p>The definition of a data aggregation.</p>', ], ], 'DataBarsOptions' => [ 'base' => '<p>The options for data bars.</p>', 'refs' => [ 'TableInlineVisualization$DataBars' => '<p>The configuration of the inline visualization of the data bars within a chart.</p>', ], ], 'DataColor' => [ 'base' => '<p>Determines the color that is applied to a particular data value.</p>', 'refs' => [ 'ColorScale$NullValueColor' => '<p>Determines the color that is applied to null values.</p>', 'ColorScaleColorList$member' => NULL, ], ], 'DataColorPalette' => [ 'base' => '<p>The theme colors that are used for data colors in charts. The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. </p>', 'refs' => [ 'ThemeConfiguration$DataColorPalette' => '<p>Color properties that apply to chart data colors.</p>', ], ], 'DataFieldSeriesItem' => [ 'base' => '<p>The data field series item configuration of a line chart.</p>', 'refs' => [ 'SeriesItem$DataFieldSeriesItem' => '<p>The data field series item configuration of a line chart.</p>', ], ], 'DataLabelContent' => [ 'base' => NULL, 'refs' => [ 'DataLabelOptions$LabelContent' => '<p>Determines the content of the data labels.</p>', ], ], 'DataLabelOptions' => [ 'base' => '<p>The options that determine the presentation of the data labels.</p>', 'refs' => [ 'BarChartConfiguration$DataLabels' => '<p>The options that determine if visual data labels are displayed.</p>', 'ComboChartConfiguration$BarDataLabels' => '<p>The options that determine if visual data labels are displayed.</p> <p>The data label options for a bar in a combo chart.</p>', 'ComboChartConfiguration$LineDataLabels' => '<p>The options that determine if visual data labels are displayed.</p> <p>The data label options for a line in a combo chart.</p>', 'GaugeChartConfiguration$DataLabels' => '<p>The data label configuration of a <code>GaugeChartVisual</code>.</p>', 'HeatMapConfiguration$DataLabels' => '<p>The options that determine if visual data labels are displayed.</p>', 'HistogramConfiguration$DataLabels' => '<p>The data label configuration of a histogram.</p>', 'LineChartConfiguration$DataLabels' => '<p>The data label configuration of a line chart.</p>', 'PieChartConfiguration$DataLabels' => '<p>The options that determine if visual data labels are displayed.</p>', 'SankeyDiagramChartConfiguration$DataLabels' => '<p>The data label configuration of a sankey diagram.</p>', 'ScatterPlotConfiguration$DataLabels' => '<p>The options that determine if visual data labels are displayed.</p>', 'TreeMapConfiguration$DataLabels' => '<p>The options that determine if visual data labels are displayed.</p>', 'WaterfallChartConfiguration$DataLabels' => '<p>The data label configuration of a waterfall visual.</p>', ], ], 'DataLabelOverlap' => [ 'base' => NULL, 'refs' => [ 'DataLabelOptions$Overlap' => '<p>Determines whether overlap is enabled or disabled for the data labels.</p>', ], ], 'DataLabelPosition' => [ 'base' => NULL, 'refs' => [ 'DataLabelOptions$Position' => '<p>Determines the position of the data labels.</p>', 'FunnelChartDataLabelOptions$Position' => '<p>Determines the positioning of the data label relative to a section of the funnel.</p>', ], ], 'DataLabelType' => [ 'base' => '<p>The option that determines the data label type.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'DataLabelTypes$member' => NULL, ], ], 'DataLabelTypes' => [ 'base' => NULL, 'refs' => [ 'DataLabelOptions$DataLabelTypes' => '<p>The option that determines the data label type.</p>', ], ], 'DataPathColor' => [ 'base' => '<p>The color map that determines the color options for a particular element.</p>', 'refs' => [ 'DataPathColorList$member' => NULL, ], ], 'DataPathColorList' => [ 'base' => NULL, 'refs' => [ 'VisualPalette$ColorMap' => '<p>The color map options for the visual palette.</p>', ], ], 'DataPathLabelType' => [ 'base' => '<p>The option that specifies individual data values for labels.</p>', 'refs' => [ 'DataLabelType$DataPathLabelType' => '<p>The option that specifies individual data values for labels.</p>', ], ], 'DataPathSort' => [ 'base' => '<p>Allows data paths to be sorted by a specific data value.</p>', 'refs' => [ 'PivotTableSortBy$DataPath' => '<p>The data path sort (data path value, direction) for the pivot table sort by options.</p>', ], ], 'DataPathType' => [ 'base' => '<p>The type of the data path value.</p>', 'refs' => [ 'DataPathValue$DataPathType' => '<p>The type configuration of the field.</p>', ], ], 'DataPathValue' => [ 'base' => '<p>The data path that needs to be sorted.</p>', 'refs' => [ 'DataPathColor$Element' => '<p>The element that the color needs to be applied to.</p>', 'DataPathValueList$member' => NULL, ], ], 'DataPathValueList' => [ 'base' => NULL, 'refs' => [ 'DataPathSort$SortPaths' => '<p>The list of data paths that need to be sorted.</p>', 'PivotTableDataPathOption$DataPathList' => '<p>The list of data path values for the data path options.</p>', 'PivotTableFieldCollapseStateTarget$FieldDataPathValues' => '<p>The data path of the pivot table\'s header. Used to set the collapse state.</p>', ], ], 'DataPointDrillUpDownOption' => [ 'base' => '<p>The drill down options for data points in a dashbaord.</p>', 'refs' => [ 'DashboardPublishOptions$DataPointDrillUpDownOption' => '<p>The drill-down options of data points in a dashboard.</p>', ], ], 'DataPointMenuLabelOption' => [ 'base' => '<p>The data point menu options of a dashboard.</p>', 'refs' => [ 'DashboardPublishOptions$DataPointMenuLabelOption' => '<p>The data point menu label options of a dashboard.</p>', ], ], 'DataPointTooltipOption' => [ 'base' => '<p>The data point tooltip options.</p>', 'refs' => [ 'DashboardPublishOptions$DataPointTooltipOption' => '<p>The data point tool tip options of a dashboard.</p>', ], ], 'DataSet' => [ 'base' => '<p>Dataset.</p>', 'refs' => [ 'DescribeDataSetResponse$DataSet' => '<p>Information on the dataset.</p>', ], ], 'DataSetArnsList' => [ 'base' => NULL, 'refs' => [ 'Analysis$DataSetArns' => '<p>The ARNs of the datasets of the analysis.</p>', 'DashboardVersion$DataSetArns' => '<p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.</p>', ], ], 'DataSetCalculatedFieldExpression' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$Expression' => '<p>An expression that defines the calculated column.</p>', ], ], 'DataSetConfiguration' => [ 'base' => '<p>Dataset configuration.</p>', 'refs' => [ 'DataSetConfigurationList$member' => NULL, ], ], 'DataSetConfigurationList' => [ 'base' => NULL, 'refs' => [ 'TemplateVersion$DataSetConfigurations' => '<p>Schema of the dataset identified by the placeholder. Any dashboard created from this template should be bound to new datasets matching the same schema described through this API operation.</p>', 'TemplateVersionDefinition$DataSetConfigurations' => '<p>An array of dataset configurations. These configurations define the required columns for each dataset used within a template.</p>', ], ], 'DataSetFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'DataSetSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example, <code>"Name": "QUICKSIGHT_OWNER"</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the dataset owners or viewers are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners of the dataset are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any datasets with that ARN listed as the only owner of the dataset are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners if the dataset are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any datasets with that ARN listed as one of the owners or viewers of the dataset are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DATASET_NAME</code>: Any datasets whose names have a substring match to this value will be returned.</p> </li> </ul>', ], ], 'DataSetIdentifier' => [ 'base' => NULL, 'refs' => [ 'CalculatedField$DataSetIdentifier' => '<p>The data set that is used in this calculated field.</p>', 'ColumnIdentifier$DataSetIdentifier' => '<p>The data set that the column belongs to.</p>', 'CustomContentVisual$DataSetIdentifier' => '<p>The dataset that is used to create the custom content visual. You can\'t create a visual without a dataset.</p>', 'DataSetIdentifierDeclaration$Identifier' => '<p>The identifier of the data set, typically the data set\'s name.</p>', 'EmptyVisual$DataSetIdentifier' => '<p>The data set that is used in the empty visual. Every visual requires a dataset to render.</p>', 'InsightVisual$DataSetIdentifier' => '<p>The dataset that is used in the insight visual.</p>', 'MappedDataSetParameter$DataSetIdentifier' => '<p>A unique name that identifies a dataset within the analysis or dashboard.</p>', 'RollingDateConfiguration$DataSetIdentifier' => '<p>The data set that is used in the rolling date configuration.</p>', ], ], 'DataSetIdentifierDeclaration' => [ 'base' => '<p>A data set.</p>', 'refs' => [ 'DataSetIdentifierDeclarationList$member' => NULL, ], ], 'DataSetIdentifierDeclarationList' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$DataSetIdentifierDeclarations' => '<p>An array of dataset identifier declarations. This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.</p>', 'DashboardVersionDefinition$DataSetIdentifierDeclarations' => '<p>An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of dataset Amazon Resource Names (ARNs) throughout the dashboard\'s sub-structures.</p>', ], ], 'DataSetImportMode' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', 'DataSet$ImportMode' => '<p>A value that indicates whether you want to import the data into SPICE.</p>', 'DataSetSummary$ImportMode' => '<p>A value that indicates whether you want to import the data into SPICE.</p>', 'UpdateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', ], ], 'DataSetName' => [ 'base' => NULL, 'refs' => [ 'AwsIotAnalyticsParameters$DataSetName' => '<p>Dataset name.</p>', ], ], 'DataSetReference' => [ 'base' => '<p>Dataset reference.</p>', 'refs' => [ 'DataSetReferenceList$member' => NULL, ], ], 'DataSetReferenceList' => [ 'base' => NULL, 'refs' => [ 'AnalysisSourceTemplate$DataSetReferences' => '<p>The dataset references of the source template of an analysis.</p>', 'DashboardSourceTemplate$DataSetReferences' => '<p>Dataset references.</p>', 'TemplateSourceAnalysis$DataSetReferences' => '<p>A structure containing information about the dataset references used as placeholders in the template.</p>', ], ], 'DataSetRefreshProperties' => [ 'base' => '<p>The refresh properties of a dataset.</p>', 'refs' => [ 'DescribeDataSetRefreshPropertiesResponse$DataSetRefreshProperties' => '<p>The dataset refresh properties.</p>', 'PutDataSetRefreshPropertiesRequest$DataSetRefreshProperties' => '<p>The dataset refresh properties.</p>', ], ], 'DataSetRegion' => [ 'base' => NULL, 'refs' => [ 'BigQueryParameters$DataSetRegion' => '<p>The storage location where you create a Google BigQuery data source.</p>', ], ], 'DataSetSchema' => [ 'base' => '<p>Dataset schema.</p>', 'refs' => [ 'DataSetConfiguration$DataSetSchema' => '<p>Dataset schema.</p>', ], ], 'DataSetSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for datasets.</p>', 'refs' => [ 'DataSetSearchFilterList$member' => NULL, ], ], 'DataSetSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchDataSetsRequest$Filters' => '<p>The filters to apply to the search.</p>', ], ], 'DataSetSummary' => [ 'base' => '<p>Dataset summary.</p>', 'refs' => [ 'DataSetSummaryList$member' => NULL, ], ], 'DataSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSetsResponse$DataSetSummaries' => '<p>The list of dataset summaries.</p>', 'SearchDataSetsResponse$DataSetSummaries' => '<p>A <code>DataSetSummaries</code> object that returns a summary of a dataset.</p>', ], ], 'DataSetUsageConfiguration' => [ 'base' => '<p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>', 'refs' => [ 'CreateDataSetRequest$DataSetUsageConfiguration' => NULL, 'DataSet$DataSetUsageConfiguration' => '<p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>', 'UpdateDataSetRequest$DataSetUsageConfiguration' => NULL, ], ], 'DataSource' => [ 'base' => '<p>The structure of a data source.</p>', 'refs' => [ 'DataSourceList$member' => NULL, 'DescribeDataSourceResponse$DataSource' => '<p>The information on the data source.</p>', ], ], 'DataSourceCredentials' => [ 'base' => '<p>Data source credentials. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'CreateDataSourceRequest$Credentials' => '<p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', 'UpdateDataSourceRequest$Credentials' => '<p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', ], ], 'DataSourceErrorInfo' => [ 'base' => '<p>Error information for the data source creation or update.</p>', 'refs' => [ 'DataSource$ErrorInfo' => '<p>Error information from the last update or the creation of the data source.</p>', ], ], 'DataSourceErrorInfoType' => [ 'base' => NULL, 'refs' => [ 'DataSourceErrorInfo$Type' => '<p>Error type.</p>', ], ], 'DataSourceFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'DataSourceSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example, <code>"Name": "DIRECT_QUICKSIGHT_OWNER"</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners or viewers of the data sources are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any data sources with that ARN listed as one of the owners if the data source are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any data sources with that ARN listed as the only owner of the data source are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DATASOURCE_NAME</code>: Any data sources whose names have a substring match to the provided value are returned.</p> </li> </ul>', ], ], 'DataSourceList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$DataSources' => '<p>A list of data sources.</p>', ], ], 'DataSourceParameters' => [ 'base' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideParameters$DataSourceParameters' => NULL, 'CreateDataSourceRequest$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>', 'DataSource$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'DataSourceParametersList$member' => NULL, 'UpdateDataSourceRequest$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>', ], ], 'DataSourceParametersList' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for these credentials. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.</p>', 'DataSource$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for the credentials stored with this data source. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.</p>', ], ], 'DataSourceSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for data sources.</p>', 'refs' => [ 'DataSourceSearchFilterList$member' => NULL, ], ], 'DataSourceSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchDataSourcesRequest$Filters' => '<p>The filters to apply to the search.</p>', ], ], 'DataSourceSummary' => [ 'base' => '<p>A <code>DataSourceSummary</code> object that returns a summary of a data source.</p>', 'refs' => [ 'DataSourceSummaryList$member' => NULL, ], ], 'DataSourceSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchDataSourcesResponse$DataSourceSummaries' => '<p>A <code>DataSourceSummaries</code> object that returns a summary of a data source.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Type' => '<p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p> <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>', 'DataSource$Type' => '<p>The type of the data source. This type indicates which database engine the data source connects to.</p>', 'DataSourceSummary$Type' => '<p>The type of the data source.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Database' => '<p>Database.</p>', 'AuroraPostgreSqlParameters$Database' => '<p>The Amazon Aurora PostgreSQL database to connect to.</p>', 'MariaDbParameters$Database' => '<p>Database.</p>', 'MySqlParameters$Database' => '<p>Database.</p>', 'OracleParameters$Database' => '<p>The database.</p>', 'PostgreSqlParameters$Database' => '<p>Database.</p>', 'RdsParameters$Database' => '<p>Database.</p>', 'RedshiftParameters$Database' => '<p>Database.</p>', 'SnowflakeParameters$Database' => '<p>Database.</p>', 'SqlServerParameters$Database' => '<p>Database.</p>', 'TeradataParameters$Database' => '<p>Database.</p>', ], ], 'DatabaseGroup' => [ 'base' => NULL, 'refs' => [ 'DatabaseGroupList$member' => NULL, ], ], 'DatabaseGroupList' => [ 'base' => NULL, 'refs' => [ 'RedshiftIAMParameters$DatabaseGroups' => '<p>A list of groups whose permissions will be granted to Amazon QuickSight to access the cluster. These permissions are combined with the permissions granted to Amazon QuickSight by the <code>DatabaseUser</code>. If you choose to include this parameter, the <code>RoleArn</code> must grant access to <code>redshift:JoinGroup</code>.</p>', ], ], 'DatabaseUser' => [ 'base' => NULL, 'refs' => [ 'RedshiftIAMParameters$DatabaseUser' => '<p>The user whose permissions and group memberships will be used by Amazon QuickSight to access the cluster. If this user already exists in your database, Amazon QuickSight is granted the same permissions that the user has. If the user doesn\'t exist, set the value of <code>AutoCreateDatabaseUser</code> to <code>True</code> to create a new user with PUBLIC permissions.</p>', ], ], 'DatabricksParameters' => [ 'base' => '<p>The parameters that are required to connect to a Databricks data source.</p>', 'refs' => [ 'DataSourceParameters$DatabricksParameters' => '<p>The parameters that are required to connect to a Databricks data source.</p>', ], ], 'DatasetMetadata' => [ 'base' => '<p>A structure that represents a dataset.</p>', 'refs' => [ 'Datasets$member' => NULL, ], ], 'DatasetParameter' => [ 'base' => '<p>A parameter that is created in a dataset. The parameter can be a string, integer, decimal, or datetime data type.</p>', 'refs' => [ 'DatasetParameterList$member' => NULL, ], ], 'DatasetParameterId' => [ 'base' => NULL, 'refs' => [ 'DateTimeDatasetParameter$Id' => '<p>An identifier for the parameter that is created in the dataset.</p>', 'DecimalDatasetParameter$Id' => '<p>An identifier for the decimal parameter created in the dataset.</p>', 'IntegerDatasetParameter$Id' => '<p>An identifier for the integer parameter created in the dataset.</p>', 'StringDatasetParameter$Id' => '<p>An identifier for the string parameter that is created in the dataset.</p>', ], ], 'DatasetParameterList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$DatasetParameters' => '<p>The parameter declarations of the dataset.</p>', 'DataSet$DatasetParameters' => '<p>The parameters that are declared in a dataset.</p>', 'UpdateDataSetRequest$DatasetParameters' => '<p>The parameter declarations of the dataset.</p>', ], ], 'DatasetParameterName' => [ 'base' => NULL, 'refs' => [ 'DateTimeDatasetParameter$Name' => '<p>The name of the date time parameter that is created in the dataset.</p>', 'DecimalDatasetParameter$Name' => '<p>The name of the decimal parameter that is created in the dataset.</p>', 'IntegerDatasetParameter$Name' => '<p>The name of the integer parameter that is created in the dataset.</p>', 'OverrideDatasetParameterOperation$ParameterName' => '<p>The name of the parameter to be overridden with different values.</p>', 'OverrideDatasetParameterOperation$NewParameterName' => '<p>The new name for the parameter.</p>', 'StringDatasetParameter$Name' => '<p>The name of the string parameter that is created in the dataset.</p>', ], ], 'DatasetParameterValueType' => [ 'base' => '<p>The value type of the parameter. The value type is used to validate the parameter before it is evaluated.</p>', 'refs' => [ 'DateTimeDatasetParameter$ValueType' => '<p>The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.</p>', 'DecimalDatasetParameter$ValueType' => '<p>The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.</p>', 'IntegerDatasetParameter$ValueType' => '<p>The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.</p>', 'StringDatasetParameter$ValueType' => '<p>The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.</p>', ], ], 'Datasets' => [ 'base' => NULL, 'refs' => [ 'TopicDetails$DataSets' => '<p>The data sets that the topic is associated with.</p>', ], ], 'DateAggregationFunction' => [ 'base' => NULL, 'refs' => [ 'AggregationFunction$DateAggregationFunction' => '<p>Aggregation for date values.</p> <ul> <li> <p> <code>COUNT</code>: Aggregate by the total number of values, including duplicates.</p> </li> <li> <p> <code>DISTINCT_COUNT</code>: Aggregate by the total number of distinct values.</p> </li> <li> <p> <code>MIN</code>: Select the smallest date value.</p> </li> <li> <p> <code>MAX</code>: Select the largest date value.</p> </li> </ul>', 'DateMeasureField$AggregationFunction' => '<p>The aggregation function of the measure field.</p>', ], ], 'DateAxisOptions' => [ 'base' => '<p>The options that determine how a date axis is displayed.</p>', 'refs' => [ 'AxisDataOptions$DateAxisOptions' => '<p>The options for an axis with a date field.</p>', ], ], 'DateDimensionField' => [ 'base' => '<p>The dimension type field with date type columns.</p>', 'refs' => [ 'DimensionField$DateDimensionField' => '<p>The dimension type field with date type columns.</p>', ], ], 'DateMeasureField' => [ 'base' => '<p>The measure type field with date type columns.</p>', 'refs' => [ 'MeasureField$DateMeasureField' => '<p>The measure type field with date type columns.</p>', ], ], 'DateTimeDatasetParameter' => [ 'base' => '<p>A date time parameter for a dataset.</p>', 'refs' => [ 'DatasetParameter$DateTimeDatasetParameter' => '<p>A date time parameter that is created in the dataset.</p>', ], ], 'DateTimeDatasetParameterDefaultValue' => [ 'base' => '<p>The default value for the date time parameter.</p>', 'refs' => [ 'DateTimeDatasetParameterValueList$member' => NULL, ], ], 'DateTimeDatasetParameterDefaultValues' => [ 'base' => '<p>The default values of a date time parameter.</p>', 'refs' => [ 'DateTimeDatasetParameter$DefaultValues' => '<p>A list of default values for a given date time parameter. This structure only accepts static values.</p>', ], ], 'DateTimeDatasetParameterValueList' => [ 'base' => NULL, 'refs' => [ 'DateTimeDatasetParameterDefaultValues$StaticValues' => '<p>A list of static default values for a given date time parameter.</p>', 'NewDefaultValues$DateTimeStaticValues' => '<p>A list of static default values for a given date time parameter.</p>', ], ], 'DateTimeDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'CustomParameterValues$DateTimeValues' => '<p>A list of datetime-type parameter values.</p>', 'DateTimeDefaultValues$StaticValues' => '<p>The static values of the <code>DataTimeDefaultValues</code>.</p>', ], ], 'DateTimeDefaultValues' => [ 'base' => '<p>The default values of the <code>DateTimeParameterDeclaration</code>.</p>', 'refs' => [ 'DateTimeParameterDeclaration$DefaultValues' => '<p>The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.</p>', ], ], 'DateTimeFormat' => [ 'base' => NULL, 'refs' => [ 'DateTimeFormatConfiguration$DateTimeFormat' => '<p>Determines the <code>DateTime</code> format.</p>', 'DateTimePickerControlDisplayOptions$DateTimeFormat' => '<p>Customize how dates are formatted in controls.</p>', 'RelativeDateTimeControlDisplayOptions$DateTimeFormat' => '<p>Customize how dates are formatted in controls.</p>', ], ], 'DateTimeFormatConfiguration' => [ 'base' => '<p>Formatting configuration for <code>DateTime</code> fields.</p>', 'refs' => [ 'DateDimensionField$FormatConfiguration' => '<p>The format configuration of the field.</p>', 'DateMeasureField$FormatConfiguration' => '<p>The format configuration of the field.</p>', 'FormatConfiguration$DateTimeFormatConfiguration' => '<p>Formatting configuration for <code>DateTime</code> fields.</p>', ], ], 'DateTimeHierarchy' => [ 'base' => '<p>The option that determines the hierarchy of any <code>DateTime</code> fields.</p>', 'refs' => [ 'ColumnHierarchy$DateTimeHierarchy' => '<p>The option that determines the hierarchy of any <code>DateTime</code> fields.</p>', ], ], 'DateTimeParameter' => [ 'base' => '<p>A date-time parameter.</p>', 'refs' => [ 'DateTimeParameterList$member' => NULL, ], ], 'DateTimeParameterDeclaration' => [ 'base' => '<p>A parameter declaration for the <code>DateTime</code> data type.</p>', 'refs' => [ 'ParameterDeclaration$DateTimeParameterDeclaration' => '<p>A parameter declaration for the <code>DateTime</code> data type.</p>', ], ], 'DateTimeParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DateTimeParameters' => '<p>The parameters that have a data type of date-time.</p>', ], ], 'DateTimePickerControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultDateTimePickerControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterDateTimePickerControl$DisplayOptions' => '<p>The display options of a control.</p>', 'ParameterDateTimePickerControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'DateTimeValueWhenUnsetConfiguration' => [ 'base' => '<p>The configuration that defines the default value of a <code>DateTime</code> parameter when a value has not been set.</p>', 'refs' => [ 'DateTimeParameterDeclaration$ValueWhenUnset' => '<p>The configuration that defines the default value of a <code>DateTime</code> parameter when a value has not been set.</p>', ], ], 'DayOfMonth' => [ 'base' => NULL, 'refs' => [ 'ScheduleRefreshOnEntity$DayOfMonth' => '<p>The day of the month that you want to schedule refresh on.</p>', ], ], 'DayOfTheWeek' => [ 'base' => NULL, 'refs' => [ 'AssetOptions$WeekStart' => '<p>Determines the week start day for an analysis.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'ScheduleRefreshOnEntity$DayOfWeek' => '<p>The day of the week that you want to schedule a refresh on.</p>', ], ], 'DbUsername' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobDataSourceCredentialPair$Username' => '<p>The username for the data source connection.</p>', 'CredentialPair$Username' => '<p>User name.</p>', ], ], 'DecimalDatasetParameter' => [ 'base' => '<p>A decimal parameter for a dataset.</p>', 'refs' => [ 'DatasetParameter$DecimalDatasetParameter' => '<p>A decimal parameter that is created in the dataset.</p>', ], ], 'DecimalDatasetParameterDefaultValue' => [ 'base' => '<p>The default value for the decimal parameter.</p>', 'refs' => [ 'DecimalDatasetParameterValueList$member' => NULL, ], ], 'DecimalDatasetParameterDefaultValues' => [ 'base' => '<p>The default values of a decimal parameter.</p>', 'refs' => [ 'DecimalDatasetParameter$DefaultValues' => '<p>A list of default values for a given decimal parameter. This structure only accepts static values.</p>', ], ], 'DecimalDatasetParameterValueList' => [ 'base' => NULL, 'refs' => [ 'DecimalDatasetParameterDefaultValues$StaticValues' => '<p>A list of static default values for a given decimal parameter.</p>', 'NewDefaultValues$DecimalStaticValues' => '<p>A list of static default values for a given decimal parameter.</p>', ], ], 'DecimalDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'CustomParameterValues$DecimalValues' => '<p>A list of decimal-type parameter values.</p>', 'DecimalDefaultValues$StaticValues' => '<p>The static values of the <code>DecimalDefaultValues</code>.</p>', ], ], 'DecimalDefaultValues' => [ 'base' => '<p>The default values of the <code>DecimalParameterDeclaration</code>.</p>', 'refs' => [ 'DecimalParameterDeclaration$DefaultValues' => '<p>The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.</p>', ], ], 'DecimalParameter' => [ 'base' => '<p>A decimal parameter.</p>', 'refs' => [ 'DecimalParameterList$member' => NULL, ], ], 'DecimalParameterDeclaration' => [ 'base' => '<p>A parameter declaration for the <code>Decimal</code> data type.</p>', 'refs' => [ 'ParameterDeclaration$DecimalParameterDeclaration' => '<p>A parameter declaration for the <code>Decimal</code> data type.</p>', ], ], 'DecimalParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DecimalParameters' => '<p>The parameters that have a data type of decimal.</p>', ], ], 'DecimalPlaces' => [ 'base' => NULL, 'refs' => [ 'DecimalPlacesConfiguration$DecimalPlaces' => '<p>The values of the decimal places.</p>', ], ], 'DecimalPlacesConfiguration' => [ 'base' => '<p>The option that determines the decimal places configuration.</p>', 'refs' => [ 'CurrencyDisplayFormatConfiguration$DecimalPlacesConfiguration' => '<p>The option that determines the decimal places configuration.</p>', 'NumberDisplayFormatConfiguration$DecimalPlacesConfiguration' => '<p>The option that determines the decimal places configuration.</p>', 'PercentageDisplayFormatConfiguration$DecimalPlacesConfiguration' => '<p>The option that determines the decimal places configuration.</p>', ], ], 'DecimalValueWhenUnsetConfiguration' => [ 'base' => '<p>The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not been set.</p>', 'refs' => [ 'DecimalParameterDeclaration$ValueWhenUnset' => '<p>The configuration that defines the default value of a <code>Decimal</code> parameter when a value has not been set.</p>', ], ], 'DefaultAggregation' => [ 'base' => NULL, 'refs' => [ 'TopicCalculatedField$Aggregation' => '<p>The default aggregation. Valid values for this structure are <code>SUM</code>, <code>MAX</code>, <code>MIN</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, and <code>AVERAGE</code>.</p>', 'TopicColumn$Aggregation' => '<p>The type of aggregation that is performed on the column data when it\'s queried.</p>', ], ], 'DefaultDateTimePickerControlOptions' => [ 'base' => '<p>The default options that correspond to the filter control type of a <code>DateTimePicker</code>.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultDateTimePickerOptions' => '<p>The default options that correspond to the filter control type of a <code>DateTimePicker</code>.</p>', ], ], 'DefaultFilterControlConfiguration' => [ 'base' => '<p>The default configuration for all dependent controls of the filter.</p>', 'refs' => [ 'CategoryFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'CategoryInnerFilter$DefaultFilterControlConfiguration' => NULL, 'NumericEqualityFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'NumericRangeFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'RelativeDatesFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'TimeEqualityFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'TimeRangeFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', 'TopBottomFilter$DefaultFilterControlConfiguration' => '<p>The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.</p>', ], ], 'DefaultFilterControlOptions' => [ 'base' => '<p>The option that corresponds to the control type of the filter.</p>', 'refs' => [ 'DefaultFilterControlConfiguration$ControlOptions' => '<p>The control option for the <code>DefaultFilterControlConfiguration</code>.</p>', ], ], 'DefaultFilterDropDownControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>Dropdown</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultDropdownOptions' => '<p>The default options that correspond to the <code>Dropdown</code> filter control type.</p>', ], ], 'DefaultFilterListControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>List</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultListOptions' => '<p>The default options that correspond to the <code>List</code> filter control type.</p>', ], ], 'DefaultFormatting' => [ 'base' => '<p>A structure that represents a default formatting definition.</p>', 'refs' => [ 'TopicCalculatedField$DefaultFormatting' => '<p>The default formatting definition.</p>', 'TopicColumn$DefaultFormatting' => '<p>The default formatting used for values in the column.</p>', ], ], 'DefaultFreeFormLayoutConfiguration' => [ 'base' => '<p>The options that determine the default settings of a free-form layout configuration.</p>', 'refs' => [ 'DefaultInteractiveLayoutConfiguration$FreeForm' => '<p>The options that determine the default settings of a free-form layout configuration.</p>', ], ], 'DefaultGridLayoutConfiguration' => [ 'base' => '<p>The options that determine the default settings for a grid layout configuration.</p>', 'refs' => [ 'DefaultInteractiveLayoutConfiguration$Grid' => '<p>The options that determine the default settings for a grid layout configuration.</p>', ], ], 'DefaultInteractiveLayoutConfiguration' => [ 'base' => '<p>The options that determine the default settings for interactive layout configuration.</p>', 'refs' => [ 'DefaultNewSheetConfiguration$InteractiveLayoutConfiguration' => '<p>The options that determine the default settings for interactive layout configuration.</p>', ], ], 'DefaultNewSheetConfiguration' => [ 'base' => '<p>The configuration for default new sheet settings.</p>', 'refs' => [ 'AnalysisDefaults$DefaultNewSheetConfiguration' => '<p>The configuration for default new sheet settings.</p>', ], ], 'DefaultPaginatedLayoutConfiguration' => [ 'base' => '<p>The options that determine the default settings for a paginated layout configuration.</p>', 'refs' => [ 'DefaultNewSheetConfiguration$PaginatedLayoutConfiguration' => '<p>The options that determine the default settings for a paginated layout configuration.</p>', ], ], 'DefaultRelativeDateTimeControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>RelativeDateTime</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultRelativeDateTimeOptions' => '<p>The default options that correspond to the <code>RelativeDateTime</code> filter control type.</p>', ], ], 'DefaultSectionBasedLayoutConfiguration' => [ 'base' => '<p>The options that determine the default settings for a section-based layout configuration.</p>', 'refs' => [ 'DefaultPaginatedLayoutConfiguration$SectionBased' => '<p>The options that determine the default settings for a section-based layout configuration.</p>', ], ], 'DefaultSliderControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>Slider</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultSliderOptions' => '<p>The default options that correspond to the <code>Slider</code> filter control type.</p>', ], ], 'DefaultTextAreaControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>TextArea</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultTextAreaOptions' => '<p>The default options that correspond to the <code>TextArea</code> filter control type.</p>', ], ], 'DefaultTextFieldControlOptions' => [ 'base' => '<p>The default options that correspond to the <code>TextField</code> filter control type.</p>', 'refs' => [ 'DefaultFilterControlOptions$DefaultTextFieldOptions' => '<p>The default options that correspond to the <code>TextField</code> filter control type.</p>', ], ], 'DeleteAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRefreshPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRefreshPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityPropagationConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityPropagationConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleCustomPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleCustomPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserByPrincipalIdRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteUserByPrincipalIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVPCConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVPCConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delimiter' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Delimiter' => '<p>The delimiter between values in the file.</p>', ], ], 'DescribeAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetBundleExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetBundleExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetBundleImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetBundleImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardSnapshotJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardSnapshotJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardSnapshotJobResultRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardSnapshotJobResultResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetRefreshPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetRefreshPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResolvedPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResolvedPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpRestrictionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpRestrictionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoleCustomPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoleCustomPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicRefreshRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicRefreshResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVPCConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVPCConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationParameterValueConfiguration' => [ 'base' => '<p>The configuration of destination parameter values.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'SetParameterValueConfiguration$Value' => NULL, ], ], 'DimensionField' => [ 'base' => '<p>The dimension type field.</p>', 'refs' => [ 'BoxPlotDimensionFieldList$member' => NULL, 'DimensionFieldList$member' => NULL, 'FilledMapDimensionFieldList$member' => NULL, 'ForecastComputation$Time' => '<p>The time field that is used in a computation.</p>', 'FunnelChartDimensionFieldList$member' => NULL, 'GrowthRateComputation$Time' => '<p>The time field that is used in a computation.</p>', 'HeatMapDimensionFieldList$member' => NULL, 'MaximumMinimumComputation$Time' => '<p>The time field that is used in a computation.</p>', 'MetricComparisonComputation$Time' => '<p>The time field that is used in a computation.</p>', 'PeriodOverPeriodComputation$Time' => '<p>The time field that is used in a computation.</p>', 'PeriodToDateComputation$Time' => '<p>The time field that is used in a computation.</p>', 'PivotTableDimensionList$member' => NULL, 'RadarChartCategoryFieldList$member' => NULL, 'RadarChartColorFieldList$member' => NULL, 'SmallMultiplesDimensionFieldList$member' => NULL, 'TopBottomMoversComputation$Time' => '<p>The time field that is used in a computation.</p>', 'TopBottomMoversComputation$Category' => '<p>The category field that is used in a computation.</p>', 'TopBottomRankedComputation$Category' => '<p>The category field that is used in a computation.</p>', 'TreeMapDimensionFieldList$member' => NULL, 'UniqueValuesComputation$Category' => '<p>The category field that is used in a computation.</p>', 'WordCloudDimensionFieldList$member' => NULL, ], ], 'DimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'BarChartAggregatedFieldWells$Category' => '<p>The category (y-axis) field well of a bar chart.</p>', 'BarChartAggregatedFieldWells$Colors' => '<p>The color (group/color) field well of a bar chart.</p>', 'ComboChartAggregatedFieldWells$Category' => '<p>The aggregated category field wells of a combo chart.</p>', 'ComboChartAggregatedFieldWells$Colors' => '<p>The aggregated colors field well of a combo chart.</p>', 'GeospatialMapAggregatedFieldWells$Geospatial' => '<p>The geospatial field wells of a geospatial map. Values are grouped by geospatial fields.</p>', 'GeospatialMapAggregatedFieldWells$Colors' => '<p>The color field wells of a geospatial map.</p>', 'KPIFieldWells$TrendGroups' => '<p>The trend group field wells of a KPI visual.</p>', 'LineChartAggregatedFieldWells$Category' => '<p>The category field wells of a line chart. Values are grouped by category fields.</p>', 'LineChartAggregatedFieldWells$Colors' => '<p>The color field wells of a line chart. Values are grouped by category fields.</p>', 'PieChartAggregatedFieldWells$Category' => '<p>The category (group/color) field wells of a pie chart.</p>', 'SankeyDiagramAggregatedFieldWells$Source' => '<p>The source field wells of a sankey diagram.</p>', 'SankeyDiagramAggregatedFieldWells$Destination' => '<p>The destination field wells of a sankey diagram.</p>', 'ScatterPlotCategoricallyAggregatedFieldWells$Category' => '<p>The category field well of a scatter plot.</p>', 'ScatterPlotCategoricallyAggregatedFieldWells$Label' => '<p>The label field well of a scatter plot.</p>', 'ScatterPlotUnaggregatedFieldWells$XAxis' => '<p>The x-axis field well of a scatter plot.</p> <p>The x-axis is a dimension field and cannot be aggregated.</p>', 'ScatterPlotUnaggregatedFieldWells$YAxis' => '<p>The y-axis field well of a scatter plot.</p> <p>The y-axis is a dimension field and cannot be aggregated.</p>', 'ScatterPlotUnaggregatedFieldWells$Category' => '<p>The category field well of a scatter plot.</p>', 'ScatterPlotUnaggregatedFieldWells$Label' => '<p>The label field well of a scatter plot.</p>', 'TableAggregatedFieldWells$GroupBy' => '<p>The group by field well for a pivot table. Values are grouped by group by fields.</p>', 'WaterfallChartAggregatedFieldWells$Categories' => '<p>The category field wells of a waterfall visual.</p>', 'WaterfallChartAggregatedFieldWells$Breakdowns' => '<p>The breakdown field wells of a waterfall visual.</p>', ], ], 'DisplayFormat' => [ 'base' => NULL, 'refs' => [ 'DefaultFormatting$DisplayFormat' => '<p>The display format. Valid values for this structure are <code>AUTO</code>, <code>PERCENT</code>, <code>CURRENCY</code>, <code>NUMBER</code>, <code>DATE</code>, and <code>STRING</code>.</p>', 'TopicIRGroupBy$DisplayFormat' => '<p>The display format for the <code>TopicIRGroupBy</code>.</p>', 'TopicIRMetric$DisplayFormat' => '<p>The display format for the <code>TopicIRMetric</code>.</p>', ], ], 'DisplayFormatOptions' => [ 'base' => '<p>A structure that represents additional options for display formatting.</p>', 'refs' => [ 'DefaultFormatting$DisplayFormatOptions' => '<p>The additional options for display formatting.</p>', 'TopicIRGroupBy$DisplayFormatOptions' => NULL, 'TopicIRMetric$DisplayFormatOptions' => NULL, ], ], 'DnsResolverList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParameters$DnsResolvers' => '<p>An optional override of DNS resolvers to be used by the VPC connection.</p>', 'CreateVPCConnectionRequest$DnsResolvers' => '<p>A list of IP addresses of DNS resolver endpoints for the VPC connection.</p>', 'UpdateVPCConnectionRequest$DnsResolvers' => '<p>A list of IP addresses of DNS resolver endpoints for the VPC connection.</p>', ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'AmazonElasticsearchParameters$Domain' => '<p>The OpenSearch domain.</p>', 'AmazonOpenSearchParameters$Domain' => '<p>The OpenSearch domain.</p>', ], ], 'DomainNotWhitelistedException' => [ 'base' => '<p>The domain specified isn\'t on the allow list. All domains for embedded dashboards must be added to the approved list by an Amazon QuickSight admin.</p>', 'refs' => [], ], 'DonutCenterOptions' => [ 'base' => '<p>The label options of the label that is displayed in the center of a donut chart. This option isn\'t available for pie charts.</p>', 'refs' => [ 'DonutOptions$DonutCenterOptions' => '<p>The label options of the label that is displayed in the center of a donut chart. This option isn\'t available for pie charts.</p>', ], ], 'DonutOptions' => [ 'base' => '<p>The options for configuring a donut chart or pie chart.</p>', 'refs' => [ 'PieChartConfiguration$DonutOptions' => '<p>The options that determine the shape of the chart. This option determines whether the chart is a pie chart or a donut chart.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ArcAxisDisplayRange$Min' => '<p>The minimum value of the arc axis range.</p>', 'ArcAxisDisplayRange$Max' => '<p>The maximum value of the arc axis range.</p>', 'ArcConfiguration$ArcAngle' => '<p>The option that determines the arc angle of a <code>GaugeChartVisual</code>.</p>', 'AxisDisplayMinMaxRange$Minimum' => '<p>The minimum setup for an axis display range.</p>', 'AxisDisplayMinMaxRange$Maximum' => '<p>The maximum setup for an axis display range.</p>', 'AxisLinearScale$StepSize' => '<p>The step size setup of a linear axis.</p>', 'AxisLogarithmicScale$Base' => '<p>The base setup of a logarithmic axis scale.</p>', 'AxisTickLabelOptions$RotationAngle' => '<p>The rotation angle of the axis tick labels.</p>', 'DataColor$DataValue' => '<p>The data value that the color is applied to.</p>', 'DefaultSliderControlOptions$MaximumValue' => '<p>The larger value that is displayed at the right of the slider.</p>', 'DefaultSliderControlOptions$MinimumValue' => '<p>The smaller value that is displayed at the left of the slider.</p>', 'DefaultSliderControlOptions$StepSize' => '<p>The number of increments that the slider bar is divided into.</p>', 'FilterSliderControl$MaximumValue' => '<p>The larger value that is displayed at the right of the slider.</p>', 'FilterSliderControl$MinimumValue' => '<p>The smaller value that is displayed at the left of the slider.</p>', 'FilterSliderControl$StepSize' => '<p>The number of increments that the slider bar is divided into.</p>', 'ForecastComputation$UpperBoundary' => '<p>The upper boundary setup of a forecast computation.</p>', 'ForecastComputation$LowerBoundary' => '<p>The lower boundary setup of a forecast computation.</p>', 'GradientStop$GradientOffset' => '<p>Determines gradient offset value.</p>', 'GradientStop$DataValue' => '<p>Determines the data value.</p>', 'HistogramBinOptions$StartValue' => '<p>The options that determine the bin start value.</p>', 'NumericEqualityDrillDownFilter$Value' => '<p>The value of the double input numeric drill down filter.</p>', 'NumericEqualityFilter$Value' => '<p>The input value.</p>', 'NumericRangeFilterValue$StaticValue' => '<p>The static value of the numeric range filter.</p>', 'ParameterSliderControl$MaximumValue' => '<p>The larger value that is displayed at the right of the slider.</p>', 'ParameterSliderControl$MinimumValue' => '<p>The smaller value that is displayed at the left of the slider.</p>', 'ParameterSliderControl$StepSize' => '<p>The number of increments that the slider bar is divided into.</p>', 'TimeBasedForecastProperties$UpperBoundary' => '<p>The upper boundary setup of a forecast computation.</p>', 'TimeBasedForecastProperties$LowerBoundary' => '<p>The lower boundary setup of a forecast computation.</p>', 'WhatIfPointScenario$Value' => '<p>The target value that you want to meet for the provided date.</p>', 'WhatIfRangeScenario$Value' => '<p>The target value that you want to meet for the provided date range.</p>', ], ], 'DrillDownFilter' => [ 'base' => '<p>The drill down filter for the column hierarchies.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'DrillDownFilterList$member' => NULL, ], ], 'DrillDownFilterList' => [ 'base' => NULL, 'refs' => [ 'DateTimeHierarchy$DrillDownFilters' => '<p>The option that determines the drill down filters for the <code>DateTime</code> hierarchy.</p>', 'ExplicitHierarchy$DrillDownFilters' => '<p>The option that determines the drill down filters for the explicit hierarchy.</p>', 'PredefinedHierarchy$DrillDownFilters' => '<p>The option that determines the drill down filters for the predefined hierarchy.</p>', ], ], 'DropDownControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultFilterDropDownControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterDropDownControl$DisplayOptions' => '<p>The display options of the <code>FilterDropDownControl</code>.</p>', 'ParameterDropDownControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'DynamicDefaultValue' => [ 'base' => '<p>Defines different defaults to the users or groups based on mapping.</p>', 'refs' => [ 'DateTimeDefaultValues$DynamicValue' => '<p>The dynamic value of the <code>DataTimeDefaultValues</code>. Different defaults are displayed according to users, groups, and values mapping.</p>', 'DecimalDefaultValues$DynamicValue' => '<p>The dynamic value of the <code>DecimalDefaultValues</code>. Different defaults are displayed according to users, groups, and values mapping.</p>', 'IntegerDefaultValues$DynamicValue' => '<p>The dynamic value of the <code>IntegerDefaultValues</code>. Different defaults are displayed according to users, groups, and values mapping.</p>', 'StringDefaultValues$DynamicValue' => '<p>The dynamic value of the <code>StringDefaultValues</code>. Different defaults displayed according to users, groups, and values mapping.</p>', ], ], 'Edition' => [ 'base' => NULL, 'refs' => [ 'AccountInfo$Edition' => '<p>The edition of your Amazon QuickSight account.</p>', 'AccountSettings$Edition' => '<p>The edition of Amazon QuickSight that you\'re currently subscribed to: Enterprise edition or Standard edition.</p>', 'CreateAccountSubscriptionRequest$Edition' => '<p>The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.</p> <p>If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:</p> <ul> <li> <p> <code>FirstName</code> </p> </li> <li> <p> <code>LastName</code> </p> </li> <li> <p> <code>EmailAddress</code> </p> </li> <li> <p> <code>ContactNumber</code> </p> </li> </ul>', ], ], 'EmbeddingIdentityType' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$IdentityType' => '<p>The authentication method that the user uses to sign in.</p>', ], ], 'EmbeddingUrl' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserResponse$EmbedUrl' => '<p>The embed URL for the dashboard.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$EmbedUrl' => '<p>The embed URL for the Amazon QuickSight dashboard, visual, Q search bar, Generative Q&amp;A experience, or console.</p>', 'GetDashboardEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', 'GetSessionEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', ], ], 'EmptyVisual' => [ 'base' => '<p>An empty visual.</p> <p>Empty visuals are used in layouts but have not been configured to show any data. A new visual created in the Amazon QuickSight console is considered an <code>EmptyVisual</code> until a visual type is selected.</p>', 'refs' => [ 'Visual$EmptyVisual' => '<p>An empty visual.</p>', ], ], 'Entity' => [ 'base' => '<p>An object, structure, or sub-structure of an analysis, template, or dashboard.</p>', 'refs' => [ 'EntityList$member' => NULL, ], ], 'EntityList' => [ 'base' => NULL, 'refs' => [ 'AnalysisError$ViolatedEntities' => '<p>Lists the violated entities that caused the analysis error</p>', 'DashboardError$ViolatedEntities' => '<p>Lists the violated entities that caused the dashboard error.</p>', 'TemplateError$ViolatedEntities' => '<p>An error path that shows which entities caused the template error.</p>', ], ], 'EntryPath' => [ 'base' => NULL, 'refs' => [ 'RegisteredUserQuickSightConsoleEmbeddingConfiguration$InitialPath' => '<p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p> <p>The entry point URL is constrained to the following paths:</p> <ul> <li> <p> <code>/start</code> </p> </li> <li> <p> <code>/start/analyses</code> </p> </li> <li> <p> <code>/start/dashboards</code> </p> </li> <li> <p> <code>/start/favorites</code> </p> </li> <li> <p> <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p> </li> <li> <p> <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p> </li> </ul>', ], ], 'EntryPoint' => [ 'base' => NULL, 'refs' => [ 'GetSessionEmbedUrlRequest$EntryPoint' => '<p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p> <ul> <li> <p> <code>/start</code> </p> </li> <li> <p> <code>/start/analyses</code> </p> </li> <li> <p> <code>/start/dashboards</code> </p> </li> <li> <p> <code>/start/favorites</code> </p> </li> <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li> <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li> </ul>', ], ], 'ErrorInfo' => [ 'base' => '<p>Error information for the SPICE ingestion of a dataset.</p>', 'refs' => [ 'Ingestion$ErrorInfo' => '<p>Error information for this ingestion.</p>', ], ], 'ExasolParameters' => [ 'base' => '<p>The required parameters for connecting to an Exasol data source.</p>', 'refs' => [ 'DataSourceParameters$ExasolParameters' => '<p>The parameters for Exasol.</p>', ], ], 'ExceptionResourceType' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$ResourceType' => '<p>Limit exceeded.</p>', 'ResourceExistsException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceUnavailableException$ResourceType' => '<p>The resource type for this request.</p>', ], ], 'ExcludePeriodConfiguration' => [ 'base' => '<p>The exclude period of <code>TimeRangeFilter</code> or <code>RelativeDatesFilter</code>.</p>', 'refs' => [ 'RelativeDatesFilter$ExcludePeriodConfiguration' => '<p>The configuration for the exclude period of the filter.</p>', 'TimeRangeFilter$ExcludePeriodConfiguration' => '<p>The exclude period of the time range filter.</p>', ], ], 'ExplicitHierarchy' => [ 'base' => '<p>The option that determines the hierarchy of the fields that are built within a visual\'s field wells. These fields can\'t be duplicated to other visuals.</p>', 'refs' => [ 'ColumnHierarchy$ExplicitHierarchy' => '<p>The option that determines the hierarchy of the fields that are built within a visual\'s field wells. These fields can\'t be duplicated to other visuals.</p>', ], ], 'ExplicitHierarchyColumnList' => [ 'base' => NULL, 'refs' => [ 'ExplicitHierarchy$Columns' => '<p>The list of columns that define the explicit hierarchy.</p>', ], ], 'ExportHiddenFieldsOption' => [ 'base' => '<p>Determines if hidden fields are included in an exported dashboard.</p>', 'refs' => [ 'DashboardVisualPublishOptions$ExportHiddenFieldsOption' => '<p>Determines if hidden fields are included in an exported dashboard.</p>', ], ], 'ExportToCSVOption' => [ 'base' => '<p>Export to .csv option.</p>', 'refs' => [ 'DashboardPublishOptions$ExportToCSVOption' => '<p>Export to .csv option.</p>', ], ], 'ExportWithHiddenFieldsOption' => [ 'base' => '<p>Determines whether or not hidden fields are visible on exported dashbaords.</p>', 'refs' => [ 'DashboardPublishOptions$ExportWithHiddenFieldsOption' => '<p>Determines if hidden fields are exported with a dashboard.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'CalculatedMeasureField$Expression' => '<p>The expression in the table calculation.</p>', 'ConditionalFormattingCustomIconCondition$Expression' => '<p>The expression that determines the condition of the icon set.</p>', 'ConditionalFormattingGradientColor$Expression' => '<p>The expression that determines the formatting configuration for gradient color.</p>', 'ConditionalFormattingIconSet$Expression' => '<p>The expression that determines the formatting configuration for the icon set.</p>', 'ConditionalFormattingSolidColor$Expression' => '<p>The expression that determines the formatting configuration for solid color.</p>', 'FilterOperation$ConditionExpression' => '<p>An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.</p>', 'RollingDateConfiguration$Expression' => '<p>The expression of the rolling date configuration.</p>', 'SheetElementRenderingRule$Expression' => '<p>The expression of the rendering rules of a sheet.</p>', 'TopicCalculatedField$Expression' => '<p>The calculated field expression.</p>', 'TopicIRMetric$Expression' => '<p>The expression for the <code>TopicIRMetric</code>.</p>', ], ], 'FailedKeyRegistrationEntries' => [ 'base' => NULL, 'refs' => [ 'UpdateKeyRegistrationResponse$FailedKeyRegistration' => '<p>A list of all customer managed key registrations that failed to update.</p>', ], ], 'FailedKeyRegistrationEntry' => [ 'base' => '<p>An entry that appears when a <code>KeyRegistration</code> update to Amazon QuickSight fails.</p>', 'refs' => [ 'FailedKeyRegistrationEntries$member' => NULL, ], ], 'FieldBasedTooltip' => [ 'base' => '<p>The setup for the detailed tooltip.</p>', 'refs' => [ 'TooltipOptions$FieldBasedTooltip' => '<p>The setup for the detailed tooltip. The tooltip setup is always saved. The display type is decided based on the tooltip type.</p>', ], ], 'FieldFolder' => [ 'base' => '<p>A FieldFolder element is a folder that contains fields and nested subfolders.</p>', 'refs' => [ 'FieldFolderMap$value' => NULL, ], ], 'FieldFolderDescription' => [ 'base' => NULL, 'refs' => [ 'FieldFolder$description' => '<p>The description for a field folder.</p>', ], ], 'FieldFolderMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', 'DataSet$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', 'UpdateDataSetRequest$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', ], ], 'FieldFolderPath' => [ 'base' => NULL, 'refs' => [ 'FieldFolderMap$key' => NULL, ], ], 'FieldId' => [ 'base' => NULL, 'refs' => [ 'AxisLabelReferenceOptions$FieldId' => '<p>The field that the axis label is targeted to.</p>', 'CalculatedMeasureField$FieldId' => '<p>The custom field ID.</p>', 'CategoricalDimensionField$FieldId' => '<p>The custom field ID.</p>', 'CategoricalMeasureField$FieldId' => '<p>The custom field ID.</p>', 'ContributionAnalysisDefault$MeasureFieldId' => '<p>The measure field that is used in the contribution analysis.</p>', 'DataBarsOptions$FieldId' => '<p>The field ID for the data bars options.</p>', 'DataFieldSeriesItem$FieldId' => '<p>The field ID of the field that you are setting the axis binding to.</p>', 'DataPathLabelType$FieldId' => '<p>The field ID of the field that the data label needs to be applied to.</p>', 'DataPathValue$FieldId' => '<p>The field ID of the field that needs to be sorted.</p>', 'DateDimensionField$FieldId' => '<p>The custom field ID.</p>', 'DateMeasureField$FieldId' => '<p>The custom field ID.</p>', 'DestinationParameterValueConfiguration$SourceField' => '<p>The source field ID of the destination parameter.</p>', 'FieldLabelType$FieldId' => '<p>Indicates the field that is targeted by the field label.</p>', 'FieldOrderList$member' => NULL, 'FieldSeriesItem$FieldId' => '<p>The field ID of the field for which you are setting the axis binding.</p>', 'FieldSort$FieldId' => '<p>The sort configuration target field.</p>', 'FieldTooltipItem$FieldId' => '<p>The unique ID of the field that is targeted by the tooltip.</p>', 'FilledMapShapeConditionalFormatting$FieldId' => '<p>The field ID of the filled map shape.</p>', 'NumericalDimensionField$FieldId' => '<p>The custom field ID.</p>', 'NumericalMeasureField$FieldId' => '<p>The custom field ID.</p>', 'PivotFieldSortOptions$FieldId' => '<p>The field ID for the field sort options.</p>', 'PivotTableCellConditionalFormatting$FieldId' => '<p>The field ID of the cell for conditional formatting.</p>', 'PivotTableFieldOption$FieldId' => '<p>The field ID of the pivot table field.</p>', 'PivotTableFieldSubtotalOptions$FieldId' => '<p>The field ID of the subtotal options.</p>', 'SelectedFieldList$member' => NULL, 'TableCellConditionalFormatting$FieldId' => '<p>The field ID of the cell for conditional formatting.</p>', 'TableFieldOption$FieldId' => '<p>The field ID for a table field.</p>', 'TableFieldOrderList$member' => NULL, 'TotalAggregationOption$FieldId' => '<p>The field id that\'s associated with the total aggregation option.</p>', 'UnaggregatedField$FieldId' => '<p>The custom field ID.</p>', ], ], 'FieldLabelType' => [ 'base' => '<p>The field label type.</p>', 'refs' => [ 'DataLabelType$FieldLabelType' => '<p>Determines the label configuration for the entire field.</p>', ], ], 'FieldOrderList' => [ 'base' => NULL, 'refs' => [ 'TableFieldOptions$Order' => '<p>The order of the field IDs that are configured as field options for a table visual.</p>', ], ], 'FieldSeriesItem' => [ 'base' => '<p>The field series item configuration of a line chart.</p>', 'refs' => [ 'SeriesItem$FieldSeriesItem' => '<p>The field series item configuration of a line chart.</p>', ], ], 'FieldSort' => [ 'base' => '<p>The sort configuration for a field in a field well.</p>', 'refs' => [ 'FieldSortOptions$FieldSort' => '<p>The sort configuration for a field in a field well.</p>', 'PivotTableSortBy$Field' => '<p>The field sort (field id, direction) for the pivot table sort by options.</p>', ], ], 'FieldSortOptions' => [ 'base' => '<p>The field sort options in a chart configuration.</p>', 'refs' => [ 'FieldSortOptionsList$member' => NULL, 'RowSortList$member' => NULL, ], ], 'FieldSortOptionsList' => [ 'base' => NULL, 'refs' => [ 'BarChartSortConfiguration$CategorySort' => '<p>The sort configuration of category fields.</p>', 'BarChartSortConfiguration$ColorSort' => '<p>The sort configuration of color fields in a bar chart.</p>', 'BarChartSortConfiguration$SmallMultiplesSort' => '<p>The sort configuration of the small multiples field.</p>', 'BoxPlotSortConfiguration$CategorySort' => '<p>The sort configuration of a group by fields.</p>', 'ComboChartSortConfiguration$CategorySort' => '<p>The sort configuration of the category field well in a combo chart.</p>', 'ComboChartSortConfiguration$ColorSort' => '<p>The sort configuration of the color field well in a combo chart.</p>', 'FilledMapSortConfiguration$CategorySort' => '<p>The sort configuration of the location fields.</p>', 'FunnelChartSortConfiguration$CategorySort' => '<p>The sort configuration of the category fields.</p>', 'HeatMapSortConfiguration$HeatMapRowSort' => '<p>The field sort configuration of the rows fields.</p>', 'HeatMapSortConfiguration$HeatMapColumnSort' => '<p>The column sort configuration for heat map for columns that aren\'t a part of a field well.</p>', 'KPISortConfiguration$TrendGroupSort' => '<p>The sort configuration of the trend group fields.</p>', 'LineChartSortConfiguration$CategorySort' => '<p>The sort configuration of the category fields.</p>', 'LineChartSortConfiguration$SmallMultiplesSort' => '<p>The sort configuration of the small multiples field.</p>', 'PieChartSortConfiguration$CategorySort' => '<p>The sort configuration of the category fields.</p>', 'PieChartSortConfiguration$SmallMultiplesSort' => '<p>The sort configuration of the small multiples field.</p>', 'RadarChartSortConfiguration$CategorySort' => '<p>The category sort options of a radar chart.</p>', 'RadarChartSortConfiguration$ColorSort' => '<p>The color sort configuration of a radar chart.</p>', 'SankeyDiagramSortConfiguration$WeightSort' => '<p>The sort configuration of the weight fields.</p>', 'TreeMapSortConfiguration$TreeMapSort' => '<p>The sort configuration of group by fields.</p>', 'WaterfallChartSortConfiguration$CategorySort' => '<p>The sort configuration of the category fields.</p>', 'WordCloudSortConfiguration$CategorySort' => '<p>The sort configuration of group by fields.</p>', ], ], 'FieldTooltipItem' => [ 'base' => '<p>The tooltip item for the fields.</p>', 'refs' => [ 'TooltipItem$FieldTooltipItem' => '<p>The tooltip item for the fields.</p>', ], ], 'FieldValue' => [ 'base' => NULL, 'refs' => [ 'CustomColor$FieldValue' => '<p>The data value that the color is applied to.</p>', 'DataPathLabelType$FieldValue' => '<p>The actual value of the field that is labeled.</p>', 'DataPathValue$FieldValue' => '<p>The actual value of the field that needs to be sorted.</p>', ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Format' => '<p>File format.</p>', ], ], 'FilledMapAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well of the filled map.</p>', 'refs' => [ 'FilledMapFieldWells$FilledMapAggregatedFieldWells' => '<p>The aggregated field well of the filled map.</p>', ], ], 'FilledMapConditionalFormatting' => [ 'base' => '<p>The conditional formatting of a <code>FilledMapVisual</code>.</p>', 'refs' => [ 'FilledMapVisual$ConditionalFormatting' => '<p>The conditional formatting of a <code>FilledMapVisual</code>.</p>', ], ], 'FilledMapConditionalFormattingOption' => [ 'base' => '<p>Conditional formatting options of a <code>FilledMapVisual</code>.</p>', 'refs' => [ 'FilledMapConditionalFormattingOptionList$member' => NULL, ], ], 'FilledMapConditionalFormattingOptionList' => [ 'base' => NULL, 'refs' => [ 'FilledMapConditionalFormatting$ConditionalFormattingOptions' => '<p>Conditional formatting options of a <code>FilledMapVisual</code>.</p>', ], ], 'FilledMapConfiguration' => [ 'base' => '<p>The configuration for a <code>FilledMapVisual</code>.</p>', 'refs' => [ 'FilledMapVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'FilledMapDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'FilledMapAggregatedFieldWells$Geospatial' => '<p>The aggregated location field well of the filled map. Values are grouped by location fields.</p>', ], ], 'FilledMapFieldWells' => [ 'base' => '<p>The field wells of a <code>FilledMapVisual</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilledMapConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'FilledMapMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'FilledMapAggregatedFieldWells$Values' => '<p>The aggregated color field well of a filled map. Values are aggregated based on location fields.</p>', ], ], 'FilledMapShapeConditionalFormatting' => [ 'base' => '<p>The conditional formatting that determines the shape of the filled map.</p>', 'refs' => [ 'FilledMapConditionalFormattingOption$Shape' => '<p>The conditional formatting that determines the shape of the filled map.</p>', ], ], 'FilledMapSortConfiguration' => [ 'base' => '<p>The sort configuration of a <code>FilledMapVisual</code>.</p>', 'refs' => [ 'FilledMapConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>FilledMapVisual</code>.</p>', ], ], 'FilledMapVisual' => [ 'base' => '<p>A filled map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$FilledMapVisual' => '<p>A filled map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'Filter' => [ 'base' => '<p>With a <code>Filter</code>, you can remove portions of data from a particular visual or view.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterAggMetrics' => [ 'base' => '<p>The definition for the <code>FilterAggMetrics</code>.</p>', 'refs' => [ 'FilterAggMetricsList$member' => NULL, ], ], 'FilterAggMetricsList' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterOption$AggMetrics' => '<p>The agg metrics for the <code>TopicIRFilterOption</code>.</p>', ], ], 'FilterClass' => [ 'base' => NULL, 'refs' => [ 'TopicFilter$FilterClass' => '<p>The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>, <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.</p>', 'TopicIRFilterOption$FilterClass' => '<p>The filter class for the <code>TopicIRFilterOption</code>.</p>', ], ], 'FilterControl' => [ 'base' => '<p>The control of a filter that is used to interact with a dashboard or an analysis.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterControlList$member' => NULL, ], ], 'FilterControlList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$FilterControls' => '<p>The list of filter controls that are on a sheet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'FilterCrossSheetControl' => [ 'base' => '<p>A control from a filter that is scoped across more than one sheet. This represents your filter control on a sheet</p>', 'refs' => [ 'FilterControl$CrossSheet' => '<p>A control from a filter that is scoped across more than one sheet. This represents your filter control on a sheet</p>', ], ], 'FilterDateTimePickerControl' => [ 'base' => '<p>A control from a date filter that is used to specify date and time.</p>', 'refs' => [ 'FilterControl$DateTimePicker' => '<p>A control from a date filter that is used to specify date and time.</p>', ], ], 'FilterDropDownControl' => [ 'base' => '<p>A control to display a dropdown list with buttons that are used to select a single value.</p>', 'refs' => [ 'FilterControl$Dropdown' => '<p>A control to display a dropdown list with buttons that are used to select a single value.</p>', ], ], 'FilterGroup' => [ 'base' => '<p>A grouping of individual filters. Filter groups are applied to the same group of visuals.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html">Adding filter conditions (group filters) with AND and OR operators</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'FilterGroupList$member' => NULL, ], ], 'FilterGroupList' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$FilterGroups' => '<p>Filter definitions for an analysis.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'DashboardVersionDefinition$FilterGroups' => '<p>The filter definitions for a dashboard.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'TemplateVersionDefinition$FilterGroups' => '<p>Filter definitions for a template.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/filtering-visual-data.html">Filtering Data</a> in the <i>Amazon QuickSight User Guide</i>. </p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'FilterGroup$Filters' => '<p>The list of filters that are present in a <code>FilterGroup</code>.</p>', ], ], 'FilterListConfiguration' => [ 'base' => '<p>A list of filter configurations.</p>', 'refs' => [ 'CategoryFilterConfiguration$FilterListConfiguration' => '<p>A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter list.</p>', ], ], 'FilterListControl' => [ 'base' => '<p>A control to display a list of buttons or boxes. This is used to select either a single value or multiple values.</p>', 'refs' => [ 'FilterControl$List' => '<p>A control to display a list of buttons or boxes. This is used to select either a single value or multiple values.</p>', ], ], 'FilterNullOption' => [ 'base' => NULL, 'refs' => [ 'CustomFilterConfiguration$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'CustomFilterListConfiguration$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'FilterListConfiguration$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'NumericEqualityFilter$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'NumericRangeFilter$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'RelativeDatesFilter$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', 'TimeRangeFilter$NullOption' => '<p>This option determines how null values should be treated when filtering data.</p> <ul> <li> <p> <code>ALL_VALUES</code>: Include null values in filtered results.</p> </li> <li> <p> <code>NULLS_ONLY</code>: Only include null values in filtered results.</p> </li> <li> <p> <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.</p> </li> </ul>', ], ], 'FilterOperation' => [ 'base' => '<p>A transform operation that filters rows based on a condition.</p>', 'refs' => [ 'TransformOperation$FilterOperation' => '<p>An operation that filters rows based on some condition.</p>', ], ], 'FilterOperationSelectedFieldsConfiguration' => [ 'base' => '<p>The configuration of selected fields in the<code>CustomActionFilterOperation</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'CustomActionFilterOperation$SelectedFieldsConfiguration' => '<p>The configuration that chooses the fields to be filtered.</p>', ], ], 'FilterOperationTargetVisualsConfiguration' => [ 'base' => '<p>The configuration of target visuals that you want to be filtered.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'CustomActionFilterOperation$TargetVisualsConfiguration' => '<p>The configuration that chooses the target visuals to be filtered.</p>', ], ], 'FilterOperator' => [ 'base' => NULL, 'refs' => [ 'AnalysisSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.</p> <p>If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the <code>"Value"</code> field. For example, <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p> <p>If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are searching for. For example, <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.</p>', 'DashboardSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.</p> <p>If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the <code>"Value"</code> field. For example, <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p> <p>If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are searching for. For example, <code>"Name":"DASHBOARD_NAME", "Operator": "StringLike", "Value": "Test"</code>. The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>DASHBOARD_NAME</code>.</p>', 'DataSetSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.</p> <p>If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in the <code>"NAME"</code> field and the arn of the user or group whose datasets you want to search in the <code>"Value"</code> field. For example, <code>"Name":"QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east- 1:1:user/default/UserName1"</code>.</p> <p>If you set the value to <code>"StringLike"</code>, you need to provide the name of the datasets you are searching for. For example, <code>"Name":"DATASET_NAME", "Operator": "StringLike", "Value": "Test"</code>. The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>DATASET_NAME</code>.</p>', 'DataSourceSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.</p> <p>If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in the <code>"NAME"</code> field and the arn of the user or group whose data sources you want to search in the <code>"Value"</code> field. For example, <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p> <p>If you set the value to <code>"StringLike"</code>, you need to provide the name of the data sources you are searching for. For example, <code>"Name":"DATASOURCE_NAME", "Operator": "StringLike", "Value": "Test"</code>. The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>DATASOURCE_NAME</code>.</p>', 'FolderSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.</p> <p>If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the <code>"Value"</code> field. For example, <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p> <p>If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are searching for. For example, <code>"Name":"FOLDER_NAME", "Operator": "StringLike", "Value": "Test"</code>. The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>FOLDER_NAME</code>.</p>', ], ], 'FilterRelativeDateTimeControl' => [ 'base' => '<p>A control from a date filter that is used to specify the relative date.</p>', 'refs' => [ 'FilterControl$RelativeDateTime' => '<p>A control from a date filter that is used to specify the relative date.</p>', ], ], 'FilterScopeConfiguration' => [ 'base' => '<p>The scope configuration for a <code>FilterGroup</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterGroup$ScopeConfiguration' => '<p>The configuration that specifies what scope to apply to a <code>FilterGroup</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', ], ], 'FilterSelectableValues' => [ 'base' => '<p>A list of selectable values that are used in a control.</p>', 'refs' => [ 'DefaultFilterDropDownControlOptions$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', 'DefaultFilterListControlOptions$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', 'FilterDropDownControl$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', 'FilterListControl$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', ], ], 'FilterSliderControl' => [ 'base' => '<p>A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.</p>', 'refs' => [ 'FilterControl$Slider' => '<p>A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.</p>', ], ], 'FilterTextAreaControl' => [ 'base' => '<p>A control to display a text box that is used to enter multiple entries.</p>', 'refs' => [ 'FilterControl$TextArea' => '<p>A control to display a text box that is used to enter multiple entries.</p>', ], ], 'FilterTextFieldControl' => [ 'base' => '<p>A control to display a text box that is used to enter a single entry.</p>', 'refs' => [ 'FilterControl$TextField' => '<p>A control to display a text box that is used to enter a single entry.</p>', ], ], 'FilterVisualScope' => [ 'base' => NULL, 'refs' => [ 'SheetVisualScopingConfiguration$Scope' => '<p>The scope of the applied entities. Choose one of the following options:</p> <ul> <li> <p> <code>ALL_VISUALS</code> </p> </li> <li> <p> <code>SELECTED_VISUALS</code> </p> </li> </ul>', ], ], 'FilteredVisualsList' => [ 'base' => NULL, 'refs' => [ 'SheetVisualScopingConfiguration$VisualIds' => '<p>The selected visuals that the filter is applied to.</p>', ], ], 'Folder' => [ 'base' => '<p>A folder in Amazon QuickSight.</p>', 'refs' => [ 'DescribeFolderResponse$Folder' => '<p>Information about the folder.</p>', ], ], 'FolderArnList' => [ 'base' => NULL, 'refs' => [ 'CreateAnalysisRequest$FolderArns' => '<p>When you create the analysis, Amazon QuickSight adds the analysis to these folders.</p>', 'CreateDashboardRequest$FolderArns' => '<p>When you create the dashboard, Amazon QuickSight adds the dashboard to these folders.</p>', 'CreateDataSetRequest$FolderArns' => '<p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>', 'CreateDataSourceRequest$FolderArns' => '<p>When you create the data source, Amazon QuickSight adds the data source to these folders.</p>', ], ], 'FolderColumnList' => [ 'base' => NULL, 'refs' => [ 'FieldFolder$columns' => '<p>A folder has a list of columns. A column can only be in one folder.</p>', ], ], 'FolderFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'FolderSearchFilter$Name' => '<p>The name of a value that you want to use in the filter. For example, <code>"Name": "QUICKSIGHT_OWNER"</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any folders with that ARN listed as one of the folder\'s owners or viewers are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any folders with that ARN listed as the only owner of the folder are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners of the folders are returned. Implicit permissions from folders or groups are not considered.</p> </li> <li> <p> <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any folders with that ARN listed as one of the owners or viewers of the folders are returned. Implicit permissions from folders or groups are not considered. </p> </li> <li> <p> <code>FOLDER_NAME</code>: Any folders whose names have a substring match to this value will be returned.</p> </li> <li> <p> <code>PARENT_FOLDER_ARN</code>: Provide an ARN of a folder, and any folders that are directly under that parent folder are returned. If you choose to use this option and leave the value blank, all root-level folders in the account are returned. </p> </li> </ul>', ], ], 'FolderMember' => [ 'base' => '<p>An asset in a Amazon QuickSight folder, such as a dashboard, analysis, or dataset.</p>', 'refs' => [ 'CreateFolderMembershipResponse$FolderMember' => '<p>Information about the member in the folder.</p>', ], ], 'FolderMemberList' => [ 'base' => NULL, 'refs' => [ 'ListFolderMembersResponse$FolderMemberList' => '<p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>', ], ], 'FolderName' => [ 'base' => NULL, 'refs' => [ 'CreateFolderRequest$Name' => '<p>The name of the folder.</p>', 'Folder$Name' => '<p>A display name for the folder.</p>', 'FolderSummary$Name' => '<p>The display name of the folder.</p>', 'UpdateFolderRequest$Name' => '<p>The name of the folder.</p>', ], ], 'FolderSearchFilter' => [ 'base' => '<p>A filter to use to search an Amazon QuickSight folder.</p>', 'refs' => [ 'FolderSearchFilterList$member' => NULL, ], ], 'FolderSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchFoldersRequest$Filters' => '<p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>', ], ], 'FolderSummary' => [ 'base' => '<p>A summary of information about an existing Amazon QuickSight folder. </p>', 'refs' => [ 'FolderSummaryList$member' => NULL, ], ], 'FolderSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFoldersResponse$FolderSummaryList' => '<p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>', 'SearchFoldersResponse$FolderSummaryList' => '<p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>', ], ], 'FolderType' => [ 'base' => NULL, 'refs' => [ 'CreateFolderRequest$FolderType' => '<p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>', 'Folder$FolderType' => '<p>The type of folder it is.</p>', 'FolderSummary$FolderType' => '<p>The type of folder.</p>', ], ], 'Font' => [ 'base' => '<p>Determines the font settings.</p>', 'refs' => [ 'FontList$member' => NULL, ], ], 'FontConfiguration' => [ 'base' => '<p>Configures the display properties of the given text.</p>', 'refs' => [ 'AxisLabelOptions$FontConfiguration' => '<p>The font configuration of the axis label.</p>', 'DataLabelOptions$LabelFontConfiguration' => '<p>Determines the font configuration of the data labels.</p>', 'FunnelChartDataLabelOptions$LabelFontConfiguration' => '<p>The font configuration for the data labels.</p> <p>Only the <code>FontSize</code> attribute of the font configuration is used for data labels.</p>', 'GaugeChartOptions$PrimaryValueFontConfiguration' => '<p>The options that determine the primary value font configuration.</p>', 'KPIOptions$PrimaryValueFontConfiguration' => '<p>The options that determine the primary value font configuration.</p>', 'KPIOptions$SecondaryValueFontConfiguration' => '<p>The options that determine the secondary value font configuration.</p>', 'LabelOptions$FontConfiguration' => '<p>The font configuration of the label.</p>', 'PanelTitleOptions$FontConfiguration' => NULL, 'ReferenceLineLabelConfiguration$FontConfiguration' => '<p>The font configuration of the label in a reference line.</p>', 'TableCellStyle$FontConfiguration' => '<p>The font configuration of the table cells.</p>', 'TableFieldCustomTextContent$FontConfiguration' => '<p>The font configuration of the custom text content for the table URL link content.</p>', ], ], 'FontDecoration' => [ 'base' => NULL, 'refs' => [ 'FontConfiguration$FontDecoration' => '<p>Determines the appearance of decorative lines on the text.</p>', ], ], 'FontList' => [ 'base' => NULL, 'refs' => [ 'Typography$FontFamilies' => '<p>Determines the list of font families.</p>', ], ], 'FontSize' => [ 'base' => '<p>The option that determines the text display size.</p>', 'refs' => [ 'FontConfiguration$FontSize' => '<p>The option that determines the text display size.</p>', ], ], 'FontStyle' => [ 'base' => NULL, 'refs' => [ 'FontConfiguration$FontStyle' => '<p>Determines the text display face that is inherited by the given font family.</p>', ], ], 'FontWeight' => [ 'base' => '<p>The option that determines the text display weight, or boldness.</p>', 'refs' => [ 'FontConfiguration$FontWeight' => '<p>The option that determines the text display weight, or boldness.</p>', ], ], 'FontWeightName' => [ 'base' => NULL, 'refs' => [ 'FontWeight$Name' => '<p>The lexical name for the level of boldness of the text display.</p>', ], ], 'ForecastComputation' => [ 'base' => '<p>The forecast computation configuration.</p>', 'refs' => [ 'Computation$Forecast' => '<p>The forecast computation configuration.</p>', ], ], 'ForecastComputationCustomSeasonalityValue' => [ 'base' => NULL, 'refs' => [ 'ForecastComputation$CustomSeasonalityValue' => '<p>The custom seasonality value setup of a forecast computation.</p>', ], ], 'ForecastComputationSeasonality' => [ 'base' => NULL, 'refs' => [ 'ForecastComputation$Seasonality' => '<p>The seasonality setup of a forecast computation. Choose one of the following options:</p> <ul> <li> <p> <code>AUTOMATIC</code> </p> </li> <li> <p> <code>CUSTOM</code>: Checks the custom seasonality value.</p> </li> </ul>', ], ], 'ForecastConfiguration' => [ 'base' => '<p>The forecast configuration that is used in a line chart\'s display properties.</p>', 'refs' => [ 'ForecastConfigurationList$member' => NULL, ], ], 'ForecastConfigurationList' => [ 'base' => NULL, 'refs' => [ 'LineChartConfiguration$ForecastConfigurations' => '<p>The forecast configuration of a line chart.</p>', ], ], 'ForecastScenario' => [ 'base' => '<p>The forecast scenario of a forecast in the line chart.</p>', 'refs' => [ 'ForecastConfiguration$Scenario' => '<p>The forecast scenario of a forecast in the line chart.</p>', ], ], 'FormatConfiguration' => [ 'base' => '<p>The formatting configuration for all types of field.</p>', 'refs' => [ 'ColumnConfiguration$FormatConfiguration' => '<p>The format configuration of a column.</p>', 'UnaggregatedField$FormatConfiguration' => '<p>The format configuration of the field.</p>', ], ], 'FreeFormLayoutCanvasSizeOptions' => [ 'base' => '<p>Configuration options for the canvas of a free-form layout.</p>', 'refs' => [ 'DefaultFreeFormLayoutConfiguration$CanvasSizeOptions' => '<p>Determines the screen canvas size options for a free-form layout.</p>', 'FreeFormLayoutConfiguration$CanvasSizeOptions' => NULL, ], ], 'FreeFormLayoutConfiguration' => [ 'base' => '<p>The configuration of a free-form layout.</p>', 'refs' => [ 'LayoutConfiguration$FreeFormLayout' => '<p>A free-form is optimized for a fixed width and has more control over the exact placement of layout elements.</p>', ], ], 'FreeFormLayoutElement' => [ 'base' => '<p>An element within a free-form layout.</p>', 'refs' => [ 'FreeFromLayoutElementList$member' => NULL, ], ], 'FreeFormLayoutElementBackgroundStyle' => [ 'base' => '<p>The background style configuration of a free-form layout element.</p>', 'refs' => [ 'FreeFormLayoutElement$BackgroundStyle' => '<p>The background style configuration of a free-form layout element.</p>', ], ], 'FreeFormLayoutElementBorderStyle' => [ 'base' => '<p>The background style configuration of a free-form layout element.</p>', 'refs' => [ 'FreeFormLayoutElement$BorderStyle' => '<p>The border style configuration of a free-form layout element.</p>', 'FreeFormLayoutElement$SelectedBorderStyle' => '<p>The border style configuration of a free-form layout element. This border style is used when the element is selected.</p>', ], ], 'FreeFormLayoutScreenCanvasSizeOptions' => [ 'base' => '<p>The options that determine the sizing of the canvas used in a free-form layout.</p>', 'refs' => [ 'FreeFormLayoutCanvasSizeOptions$ScreenCanvasSizeOptions' => '<p>The options that determine the sizing of the canvas used in a free-form layout.</p>', ], ], 'FreeFormSectionLayoutConfiguration' => [ 'base' => '<p>The free-form layout configuration of a section.</p>', 'refs' => [ 'SectionLayoutConfiguration$FreeFormLayout' => '<p>The free-form layout configuration of a section.</p>', ], ], 'FreeFromLayoutElementList' => [ 'base' => NULL, 'refs' => [ 'FreeFormLayoutConfiguration$Elements' => '<p>The elements that are included in a free-form layout.</p>', 'FreeFormSectionLayoutConfiguration$Elements' => '<p>The elements that are included in the free-form layout.</p>', ], ], 'FunnelChartAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a <code>FunnelChartVisual</code>.</p>', 'refs' => [ 'FunnelChartFieldWells$FunnelChartAggregatedFieldWells' => '<p>The field well configuration of a <code>FunnelChartVisual</code>.</p>', ], ], 'FunnelChartConfiguration' => [ 'base' => '<p>The configuration of a <code>FunnelChartVisual</code>.</p>', 'refs' => [ 'FunnelChartVisual$ChartConfiguration' => '<p>The configuration of a <code>FunnelChartVisual</code>.</p>', ], ], 'FunnelChartDataLabelOptions' => [ 'base' => '<p>The options that determine the presentation of the data labels.</p>', 'refs' => [ 'FunnelChartConfiguration$DataLabelOptions' => '<p>The options that determine the presentation of the data labels.</p>', ], ], 'FunnelChartDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'FunnelChartAggregatedFieldWells$Category' => '<p>The category field wells of a funnel chart. Values are grouped by category fields.</p>', ], ], 'FunnelChartFieldWells' => [ 'base' => '<p>The field well configuration of a <code>FunnelChartVisual</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FunnelChartConfiguration$FieldWells' => '<p>The field well configuration of a <code>FunnelChartVisual</code>.</p>', ], ], 'FunnelChartMeasureDataLabelStyle' => [ 'base' => NULL, 'refs' => [ 'FunnelChartDataLabelOptions$MeasureDataLabelStyle' => '<p>Determines the style of the metric labels.</p>', ], ], 'FunnelChartMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'FunnelChartAggregatedFieldWells$Values' => '<p>The value field wells of a funnel chart. Values are aggregated based on categories.</p>', ], ], 'FunnelChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a <code>FunnelChartVisual</code>.</p>', 'refs' => [ 'FunnelChartConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>FunnelChartVisual</code>.</p>', ], ], 'FunnelChartVisual' => [ 'base' => '<p>A funnel chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$FunnelChartVisual' => '<p>A funnel chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'GaugeChartArcConditionalFormatting' => [ 'base' => '<p>The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConditionalFormattingOption$Arc' => '<p>The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartColorConfiguration' => [ 'base' => '<p>The color configuration of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConfiguration$ColorConfiguration' => '<p>The color configuration of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartConditionalFormatting' => [ 'base' => '<p>The conditional formatting of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartVisual$ConditionalFormatting' => '<p>The conditional formatting of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartConditionalFormattingOption' => [ 'base' => '<p>Conditional formatting options of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConditionalFormattingOptionList$member' => NULL, ], ], 'GaugeChartConditionalFormattingOptionList' => [ 'base' => NULL, 'refs' => [ 'GaugeChartConditionalFormatting$ConditionalFormattingOptions' => '<p>Conditional formatting options of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartConfiguration' => [ 'base' => '<p>The configuration of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartVisual$ChartConfiguration' => '<p>The configuration of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartFieldWells' => [ 'base' => '<p>The field well configuration of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConfiguration$FieldWells' => '<p>The field well configuration of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartOptions' => [ 'base' => '<p>The options that determine the presentation of the <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConfiguration$GaugeChartOptions' => '<p>The options that determine the presentation of the <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartPrimaryValueConditionalFormatting' => [ 'base' => '<p>The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.</p>', 'refs' => [ 'GaugeChartConditionalFormattingOption$PrimaryValue' => '<p>The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.</p>', ], ], 'GaugeChartVisual' => [ 'base' => '<p>A gauge chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using gauge charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$GaugeChartVisual' => '<p>A gauge chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using gauge charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'GenerateEmbedUrlForAnonymousUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForAnonymousUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForRegisteredUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForRegisteredUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GeoSpatialColumnGroup' => [ 'base' => '<p>Geospatial column group that denotes a hierarchy.</p>', 'refs' => [ 'ColumnGroup$GeoSpatialColumnGroup' => '<p>Geospatial column group that denotes a hierarchy.</p>', ], ], 'GeoSpatialCountryCode' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$CountryCode' => '<p>Country code.</p>', ], ], 'GeoSpatialDataRole' => [ 'base' => NULL, 'refs' => [ 'ColumnTag$ColumnGeographicRole' => '<p>A geospatial role for a column.</p>', ], ], 'GeospatialCoordinateBounds' => [ 'base' => '<p>The bound options (north, south, west, east) of the geospatial window options.</p>', 'refs' => [ 'GeospatialWindowOptions$Bounds' => '<p>The bounds options (north, south, west, east) of the geospatial window options.</p>', ], ], 'GeospatialHeatmapColorScale' => [ 'base' => '<p>The color scale specification for the heatmap point style.</p>', 'refs' => [ 'GeospatialHeatmapConfiguration$HeatmapColor' => '<p>The color scale specification for the heatmap point style.</p>', ], ], 'GeospatialHeatmapConfiguration' => [ 'base' => '<p>The heatmap configuration of the geospatial point style.</p>', 'refs' => [ 'GeospatialPointStyleOptions$HeatmapConfiguration' => '<p>The heatmap configuration of the geospatial point style.</p>', ], ], 'GeospatialHeatmapDataColor' => [ 'base' => '<p>The color to be used in the heatmap point style.</p>', 'refs' => [ 'GeospatialHeatmapDataColorList$member' => NULL, ], ], 'GeospatialHeatmapDataColorList' => [ 'base' => NULL, 'refs' => [ 'GeospatialHeatmapColorScale$Colors' => '<p>The list of colors to be used in heatmap point style.</p>', ], ], 'GeospatialMapAggregatedFieldWells' => [ 'base' => '<p>The aggregated field wells for a geospatial map.</p>', 'refs' => [ 'GeospatialMapFieldWells$GeospatialMapAggregatedFieldWells' => '<p>The aggregated field well for a geospatial map.</p>', ], ], 'GeospatialMapConfiguration' => [ 'base' => '<p>The configuration of a <code>GeospatialMapVisual</code>.</p>', 'refs' => [ 'GeospatialMapVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'GeospatialMapFieldWells' => [ 'base' => '<p>The field wells of a <code>GeospatialMapVisual</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'GeospatialMapConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'GeospatialMapStyleOptions' => [ 'base' => '<p>The map style options of the geospatial map.</p>', 'refs' => [ 'FilledMapConfiguration$MapStyleOptions' => '<p>The map style options of the filled map visual.</p>', 'GeospatialMapConfiguration$MapStyleOptions' => '<p>The map style options of the geospatial map.</p>', ], ], 'GeospatialMapVisual' => [ 'base' => '<p>A geospatial map or a points on map visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$GeospatialMapVisual' => '<p>A geospatial map or a points on map visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'GeospatialPointStyleOptions' => [ 'base' => '<p>The point style of the geospatial map.</p>', 'refs' => [ 'GeospatialMapConfiguration$PointStyleOptions' => '<p>The point style options of the geospatial map.</p>', ], ], 'GeospatialSelectedPointStyle' => [ 'base' => NULL, 'refs' => [ 'GeospatialPointStyleOptions$SelectedPointStyle' => '<p>The selected point styles (point, cluster) of the geospatial map.</p>', ], ], 'GeospatialWindowOptions' => [ 'base' => '<p>The window options of the geospatial map visual.</p>', 'refs' => [ 'FilledMapConfiguration$WindowOptions' => '<p>The window options of the filled map visual.</p>', 'GeospatialMapConfiguration$WindowOptions' => '<p>The window options of the geospatial map.</p>', ], ], 'GetDashboardEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDashboardEmbedUrlResponse' => [ 'base' => '<p>Output returned from the <code>GetDashboardEmbedUrl</code> operation.</p>', 'refs' => [], ], 'GetSessionEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionEmbedUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlobalTableBorderOptions' => [ 'base' => '<p>Determines the border options for a table visual.</p>', 'refs' => [ 'TableCellStyle$Border' => '<p>The borders for the table cells.</p>', ], ], 'GradientColor' => [ 'base' => '<p>Determines the gradient color settings.</p>', 'refs' => [ 'ConditionalFormattingGradientColor$Color' => '<p>Determines the color.</p>', ], ], 'GradientStop' => [ 'base' => '<p>Determines the gradient stop configuration.</p>', 'refs' => [ 'GradientStopList$member' => NULL, ], ], 'GradientStopList' => [ 'base' => NULL, 'refs' => [ 'GradientColor$Stops' => '<p>The list of gradient color stops.</p>', ], ], 'GridLayoutCanvasSizeOptions' => [ 'base' => '<p>Configuration options for the canvas of a grid layout.</p>', 'refs' => [ 'DefaultGridLayoutConfiguration$CanvasSizeOptions' => '<p>Determines the screen canvas size options for a grid layout.</p>', 'GridLayoutConfiguration$CanvasSizeOptions' => NULL, ], ], 'GridLayoutConfiguration' => [ 'base' => '<p>The configuration for a grid layout. Also called a tiled layout.</p> <p>Visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size.</p>', 'refs' => [ 'LayoutConfiguration$GridLayout' => '<p>A type of layout that can be used on a sheet. In a grid layout, visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size. A grid layout can be configured to behave in one of two ways when the viewport is resized: <code>FIXED</code> or <code>RESPONSIVE</code>.</p>', 'SheetControlLayoutConfiguration$GridLayout' => '<p>The configuration that determines the elements and canvas size options of sheet control.</p>', ], ], 'GridLayoutElement' => [ 'base' => '<p>An element within a grid layout.</p>', 'refs' => [ 'GridLayoutElementList$member' => NULL, ], ], 'GridLayoutElementColumnIndex' => [ 'base' => NULL, 'refs' => [ 'GridLayoutElement$ColumnIndex' => '<p>The column index for the upper left corner of an element.</p>', ], ], 'GridLayoutElementColumnSpan' => [ 'base' => NULL, 'refs' => [ 'GridLayoutElement$ColumnSpan' => '<p>The width of a grid element expressed as a number of grid columns.</p>', ], ], 'GridLayoutElementList' => [ 'base' => NULL, 'refs' => [ 'GridLayoutConfiguration$Elements' => '<p>The elements that are included in a grid layout.</p>', ], ], 'GridLayoutElementRowIndex' => [ 'base' => NULL, 'refs' => [ 'GridLayoutElement$RowIndex' => '<p>The row index for the upper left corner of an element.</p>', ], ], 'GridLayoutElementRowSpan' => [ 'base' => NULL, 'refs' => [ 'GridLayoutElement$RowSpan' => '<p>The height of a grid element expressed as a number of grid rows.</p>', ], ], 'GridLayoutScreenCanvasSizeOptions' => [ 'base' => '<p>The options that determine the sizing of the canvas used in a grid layout.</p>', 'refs' => [ 'GridLayoutCanvasSizeOptions$ScreenCanvasSizeOptions' => '<p>The options that determine the sizing of the canvas used in a grid layout.</p>', ], ], 'Group' => [ 'base' => '<p>A <i>group</i> in Amazon QuickSight consists of a set of users. You can use groups to make it easier to manage access and security. </p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The name of the group.</p>', 'DescribeGroupResponse$Group' => '<p>The name of the group.</p>', 'GroupList$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The name of the group.</p>', ], ], 'GroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A description for the group that you want to create.</p>', 'Group$Description' => '<p>The group description.</p>', 'UpdateGroupRequest$Description' => '<p>The description for the group that you want to update.</p>', ], ], 'GroupFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'GroupSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>. Currently, the only supported name is <code>GROUP_NAME</code>.</p>', ], ], 'GroupFilterOperator' => [ 'base' => NULL, 'refs' => [ 'GroupSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StartsWith"</code>. Currently, the only supported operator is <code>StartsWith</code>.</p>', ], ], 'GroupList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$GroupList' => '<p>The list of the groups.</p>', 'ListUserGroupsResponse$GroupList' => '<p>The list of groups the user is a member of.</p>', 'SearchGroupsResponse$GroupList' => '<p>A list of groups in a specified namespace that match the filters you set in your <code>SearchGroups</code> request.</p>', ], ], 'GroupMember' => [ 'base' => '<p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can\'t be members of another group. .</p>', 'refs' => [ 'CreateGroupMembershipResponse$GroupMember' => '<p>The group member.</p>', 'DescribeGroupMembershipResponse$GroupMember' => NULL, 'GroupMemberList$member' => NULL, ], ], 'GroupMemberList' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsResponse$GroupMemberList' => '<p>The list of the members of the group.</p>', ], ], 'GroupMemberName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to add to the group membership.</p>', 'DeleteGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to delete from the group membership.</p>', 'DescribeGroupMembershipRequest$MemberName' => '<p>The user name of the user that you want to search for.</p>', 'GroupMember$MemberName' => '<p>The name of the group member (user).</p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to add the user to.</p>', 'CreateGroupRequest$GroupName' => '<p>A name for the group that you want to create.</p>', 'CreateRoleMembershipRequest$MemberName' => '<p>The name of the group that you want to add to the role.</p>', 'DeleteGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to delete the user from.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group that you want to delete.</p>', 'DeleteRoleMembershipRequest$MemberName' => '<p>The name of the group.</p>', 'DescribeGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to search.</p>', 'DescribeGroupRequest$GroupName' => '<p>The name of the group that you want to describe.</p>', 'Group$GroupName' => '<p>The name of the group.</p>', 'ListGroupMembershipsRequest$GroupName' => '<p>The name of the group that you want to see a membership list of.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group that you want to update.</p>', ], ], 'GroupSearchFilter' => [ 'base' => '<p>A <code>GroupSearchFilter</code> object that you want to apply to your search.</p>', 'refs' => [ 'GroupSearchFilterList$member' => NULL, ], ], 'GroupSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchGroupsRequest$Filters' => '<p>The structure for the search filters that you want to apply to your search.</p>', ], ], 'GroupsList' => [ 'base' => NULL, 'refs' => [ 'CreateAccountSubscriptionRequest$AdminGroup' => '<p>The admin group associated with your Active Directory or IAM Identity Center account. Either this field or the <code>AdminProGroup</code> field is required if <code>ACTIVE_DIRECTORY</code> or <code>IAM_IDENTITY_CENTER</code> is the selected authentication method of the new Amazon QuickSight account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'CreateAccountSubscriptionRequest$AuthorGroup' => '<p>The author group associated with your Active Directory or IAM Identity Center account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'CreateAccountSubscriptionRequest$ReaderGroup' => '<p>The reader group associated with your Active Directory or IAM Identity Center account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'CreateAccountSubscriptionRequest$AdminProGroup' => '<p>The admin pro group associated with your Active Directory or IAM Identity Center account. Either this field or the <code>AdminGroup</code> field is required if <code>ACTIVE_DIRECTORY</code> or <code>IAM_IDENTITY_CENTER</code> is the selected authentication method of the new Amazon QuickSight account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'CreateAccountSubscriptionRequest$AuthorProGroup' => '<p>The author pro group associated with your Active Directory or IAM Identity Center account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'CreateAccountSubscriptionRequest$ReaderProGroup' => '<p>The reader pro group associated with your Active Directory or IAM Identity Center account.</p> <p>For more information about using IAM Identity Center in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sec-identity-management-identity-center.html">Using IAM Identity Center with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide. For more information about using Active Directory in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.</p>', 'ListRoleMembershipsResponse$MembersList' => '<p>The list of groups associated with a role</p>', ], ], 'GrowthRateComputation' => [ 'base' => '<p>The growth rate computation configuration.</p>', 'refs' => [ 'Computation$GrowthRate' => '<p>The growth rate computation configuration.</p>', ], ], 'GrowthRatePeriodSize' => [ 'base' => NULL, 'refs' => [ 'GrowthRateComputation$PeriodSize' => '<p>The period size setup of a growth rate computation.</p>', ], ], 'GutterStyle' => [ 'base' => '<p>The display options for gutter spacing between tiles on a sheet.</p>', 'refs' => [ 'TileLayoutStyle$Gutter' => '<p>The gutter settings that apply between tiles. </p>', ], ], 'HeaderFooterSectionConfiguration' => [ 'base' => '<p>The configuration of a header or footer section.</p>', 'refs' => [ 'HeaderFooterSectionConfigurationList$member' => NULL, ], ], 'HeaderFooterSectionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SectionBasedLayoutConfiguration$HeaderSections' => '<p>A list of header section configurations.</p>', 'SectionBasedLayoutConfiguration$FooterSections' => '<p>A list of footer section configurations.</p>', ], ], 'HeatMapAggregatedFieldWells' => [ 'base' => '<p>The aggregated field wells of a heat map.</p>', 'refs' => [ 'HeatMapFieldWells$HeatMapAggregatedFieldWells' => '<p>The aggregated field wells of a heat map.</p>', ], ], 'HeatMapConfiguration' => [ 'base' => '<p>The configuration of a heat map.</p>', 'refs' => [ 'HeatMapVisual$ChartConfiguration' => '<p>The configuration of a heat map.</p>', ], ], 'HeatMapDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'HeatMapAggregatedFieldWells$Rows' => '<p>The rows field well of a heat map.</p>', 'HeatMapAggregatedFieldWells$Columns' => '<p>The columns field well of a heat map.</p>', ], ], 'HeatMapFieldWells' => [ 'base' => '<p>The field well configuration of a heat map.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'HeatMapConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'HeatMapMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'HeatMapAggregatedFieldWells$Values' => '<p>The values field well of a heat map.</p>', ], ], 'HeatMapSortConfiguration' => [ 'base' => '<p>The sort configuration of a heat map.</p>', 'refs' => [ 'HeatMapConfiguration$SortConfiguration' => '<p>The sort configuration of a heat map.</p>', ], ], 'HeatMapVisual' => [ 'base' => '<p>A heat map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using heat maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$HeatMapVisual' => '<p>A heat map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using heat maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'HexColor' => [ 'base' => NULL, 'refs' => [ 'ColorList$member' => NULL, 'ConditionalFormattingCustomIconCondition$Color' => '<p>Determines the color of the icon.</p>', 'ConditionalFormattingSolidColor$Color' => '<p>Determines the color.</p>', 'CustomColor$Color' => '<p>The color that is applied to the data value.</p>', 'DataBarsOptions$PositiveColor' => '<p>The color of the positive data bar.</p>', 'DataBarsOptions$NegativeColor' => '<p>The color of the negative data bar.</p>', 'DataColor$Color' => '<p>The color that is applied to the data value.</p>', 'DataColorPalette$EmptyFillColor' => '<p>The hexadecimal code of a color that applies to charts where a lack of data is highlighted.</p>', 'DataLabelOptions$LabelColor' => '<p>Determines the color of the data labels.</p>', 'DataPathColor$Color' => '<p>The color that needs to be applied to the element.</p>', 'FontConfiguration$FontColor' => '<p>Determines the color of the text.</p>', 'FunnelChartDataLabelOptions$LabelColor' => '<p>The color of the data label text.</p>', 'GaugeChartColorConfiguration$ForegroundColor' => '<p>The foreground color configuration of a <code>GaugeChartVisual</code>.</p>', 'GaugeChartColorConfiguration$BackgroundColor' => '<p>The background color configuration of a <code>GaugeChartVisual</code>.</p>', 'GeospatialHeatmapDataColor$Color' => '<p>The hex color to be used in the heatmap point style.</p>', 'GradientStop$Color' => '<p>Determines the color.</p>', 'KPISparklineOptions$Color' => '<p>The color of the sparkline.</p>', 'LineChartMarkerStyleSettings$MarkerColor' => '<p>Color of marker in the series.</p>', 'RadarChartConfiguration$AlternateBandEvenColor' => '<p>The color of the even-numbered alternate bands of a radar chart.</p>', 'RadarChartConfiguration$AlternateBandOddColor' => '<p>The color of the odd-numbered alternate bands of a radar chart.</p>', 'ReferenceLineLabelConfiguration$FontColor' => '<p>The font color configuration of the label in a reference line.</p>', 'ReferenceLineStyleConfiguration$Color' => '<p>The hex color of the reference line.</p>', 'RowAlternateColorList$member' => NULL, 'SimpleClusterMarker$Color' => '<p>The color of the simple cluster marker.</p>', 'TableBorderOptions$Color' => '<p>The color of a table border.</p>', 'TableCellStyle$BackgroundColor' => '<p>The background color for the table cells.</p>', 'UIColorPalette$PrimaryForeground' => '<p>The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.</p>', 'UIColorPalette$PrimaryBackground' => '<p>The background color that applies to visuals and other high emphasis UI.</p>', 'UIColorPalette$SecondaryForeground' => '<p>The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.</p>', 'UIColorPalette$SecondaryBackground' => '<p>The background color that applies to the sheet background and sheet controls.</p>', 'UIColorPalette$Accent' => '<p>This color is that applies to selected states and buttons.</p>', 'UIColorPalette$AccentForeground' => '<p>The foreground color that applies to any text or other elements that appear over the accent color.</p>', 'UIColorPalette$Danger' => '<p>The color that applies to error messages.</p>', 'UIColorPalette$DangerForeground' => '<p>The foreground color that applies to any text or other elements that appear over the error color.</p>', 'UIColorPalette$Warning' => '<p>This color that applies to warning and informational messages.</p>', 'UIColorPalette$WarningForeground' => '<p>The foreground color that applies to any text or other elements that appear over the warning color.</p>', 'UIColorPalette$Success' => '<p>The color that applies to success messages, for example the check mark for a successful download.</p>', 'UIColorPalette$SuccessForeground' => '<p>The foreground color that applies to any text or other elements that appear over the success color.</p>', 'UIColorPalette$Dimension' => '<p>The color that applies to the names of fields that are identified as dimensions.</p>', 'UIColorPalette$DimensionForeground' => '<p>The foreground color that applies to any text or other elements that appear over the dimension color.</p>', 'UIColorPalette$Measure' => '<p>The color that applies to the names of fields that are identified as measures.</p>', 'UIColorPalette$MeasureForeground' => '<p>The foreground color that applies to any text or other elements that appear over the measure color.</p>', 'VisualPalette$ChartColor' => '<p>The chart color options for the visual palette.</p>', 'WaterfallChartGroupColorConfiguration$PositiveBarColor' => '<p>Defines the color for the positive bars of a waterfall chart.</p>', 'WaterfallChartGroupColorConfiguration$NegativeBarColor' => '<p>Defines the color for the negative bars of a waterfall chart.</p>', 'WaterfallChartGroupColorConfiguration$TotalBarColor' => '<p>Defines the color for the total bars of a waterfall chart.</p>', ], ], 'HexColorWithTransparency' => [ 'base' => NULL, 'refs' => [ 'FreeFormLayoutElementBackgroundStyle$Color' => '<p>The background color of a free-form layout element.</p>', 'FreeFormLayoutElementBorderStyle$Color' => '<p>The border color of a free-form layout element.</p>', 'PanelConfiguration$BorderColor' => '<p>Sets the line color of panel borders.</p>', 'PanelConfiguration$BackgroundColor' => '<p>Sets the background color for each panel.</p>', ], ], 'HierarchyId' => [ 'base' => NULL, 'refs' => [ 'CategoricalDimensionField$HierarchyId' => '<p>The custom hierarchy ID.</p>', 'DateDimensionField$HierarchyId' => '<p>The custom hierarchy ID.</p>', 'DateTimeHierarchy$HierarchyId' => '<p>The hierarchy ID of the <code>DateTime</code> hierarchy.</p>', 'ExplicitHierarchy$HierarchyId' => '<p>The hierarchy ID of the explicit hierarchy.</p>', 'NumericalDimensionField$HierarchyId' => '<p>The custom hierarchy ID.</p>', 'PredefinedHierarchy$HierarchyId' => '<p>The hierarchy ID of the predefined hierarchy.</p>', ], ], 'HistogramAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a histogram.</p>', 'refs' => [ 'HistogramFieldWells$HistogramAggregatedFieldWells' => '<p>The field well configuration of a histogram.</p>', ], ], 'HistogramBinOptions' => [ 'base' => '<p>The options that determine the presentation of histogram bins.</p>', 'refs' => [ 'HistogramConfiguration$BinOptions' => '<p>The options that determine the presentation of histogram bins.</p>', ], ], 'HistogramBinType' => [ 'base' => NULL, 'refs' => [ 'HistogramBinOptions$SelectedBinType' => '<p>The options that determine the selected bin type.</p>', ], ], 'HistogramConfiguration' => [ 'base' => '<p>The configuration for a <code>HistogramVisual</code>.</p>', 'refs' => [ 'HistogramVisual$ChartConfiguration' => '<p>The configuration for a <code>HistogramVisual</code>.</p>', ], ], 'HistogramFieldWells' => [ 'base' => '<p>The field well configuration of a histogram.</p>', 'refs' => [ 'HistogramConfiguration$FieldWells' => '<p>The field well configuration of a histogram.</p>', ], ], 'HistogramMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'HistogramAggregatedFieldWells$Values' => '<p>The value field wells of a histogram. Values are aggregated by <code>COUNT</code> or <code>DISTINCT_COUNT</code>.</p>', ], ], 'HistogramVisual' => [ 'base' => '<p>A histogram.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$HistogramVisual' => '<p>A histogram.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'HorizontalTextAlignment' => [ 'base' => NULL, 'refs' => [ 'PanelTitleOptions$HorizontalTextAlignment' => '<p>Sets the horizontal text alignment of the title within each panel.</p>', 'TableCellStyle$HorizontalTextAlignment' => '<p>The horizontal text alignment (left, center, right, auto) for the table cells.</p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Host' => '<p>Host.</p>', 'AuroraPostgreSqlParameters$Host' => '<p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>', 'DatabricksParameters$Host' => '<p>The host name of the Databricks data source.</p>', 'ExasolParameters$Host' => '<p>The hostname or IP address of the Exasol data source.</p>', 'MariaDbParameters$Host' => '<p>Host.</p>', 'MySqlParameters$Host' => '<p>Host.</p>', 'OracleParameters$Host' => '<p>An Oracle host.</p>', 'PostgreSqlParameters$Host' => '<p>Host.</p>', 'PrestoParameters$Host' => '<p>Host.</p>', 'RedshiftParameters$Host' => '<p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>', 'SnowflakeParameters$Host' => '<p>Host.</p>', 'SparkParameters$Host' => '<p>Host.</p>', 'SqlServerParameters$Host' => '<p>Host.</p>', 'StarburstParameters$Host' => '<p>The host name of the Starburst data source.</p>', 'TeradataParameters$Host' => '<p>Host.</p>', 'TrinoParameters$Host' => '<p>The host name of the Trino data source.</p>', ], ], 'IAMPolicyAssignment' => [ 'base' => '<p>An Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'DescribeIAMPolicyAssignmentResponse$IAMPolicyAssignment' => '<p>Information describing the IAM policy assignment.</p>', ], ], 'IAMPolicyAssignmentName' => [ 'base' => NULL, 'refs' => [ 'ActiveIAMPolicyAssignment$AssignmentName' => '<p>A name for the IAM policy assignment.</p>', 'CreateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule. The name must be unique within the Amazon Web Services account.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. The name must be unique within the Amazon Web Services account.</p>', 'DeleteIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. </p>', 'DeleteIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. </p>', 'DescribeIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule.</p>', 'IAMPolicyAssignment$AssignmentName' => '<p>Assignment name.</p>', 'IAMPolicyAssignmentSummary$AssignmentName' => '<p>Assignment name.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule. The name must be unique within the Amazon Web Services account.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment or rule.</p>', ], ], 'IAMPolicyAssignmentSummary' => [ 'base' => '<p>IAM policy assignment summary.</p>', 'refs' => [ 'IAMPolicyAssignmentSummaryList$member' => NULL, ], ], 'IAMPolicyAssignmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsResponse$IAMPolicyAssignments' => '<p>Information describing the IAM policy assignments.</p>', ], ], 'IPv4Address' => [ 'base' => NULL, 'refs' => [ 'DnsResolverList$member' => NULL, ], ], 'Icon' => [ 'base' => NULL, 'refs' => [ 'ConditionalFormattingCustomIconOptions$Icon' => '<p>Determines the type of icon.</p>', ], ], 'Identifier' => [ 'base' => '<p>The definition for the identifier.</p>', 'refs' => [ 'CalculatedFieldReferenceList$member' => NULL, 'FilterAggMetrics$MetricOperand' => '<p>The metric operand of the <code>FilterAggMetrics</code>.</p>', 'OperandList$member' => NULL, 'TopicIRFilterOption$OperandField' => '<p>The operand field for the <code>TopicIRFilterOption</code>.</p>', 'TopicIRGroupBy$FieldName' => '<p>The field name for the <code>TopicIRGroupBy</code>.</p>', 'TopicIRMetric$MetricId' => '<p>The metric ID for the <code>TopicIRMetric</code>.</p>', 'TopicSortClause$Operand' => '<p>The operand for a <code>TopicSortClause</code>.</p>', ], ], 'IdentityCenterConfiguration' => [ 'base' => '<p>The parameters for an IAM Identity Center configuration.</p>', 'refs' => [ 'RedshiftParameters$IdentityCenterConfiguration' => '<p>An optional parameter that configures IAM Identity Center authentication to grant Amazon QuickSight access to your cluster.</p> <p>This parameter can only be specified if your Amazon QuickSight account is configured with IAM Identity Center.</p>', ], ], 'IdentityMap' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$Identities' => '<p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>', 'CreateIAMPolicyAssignmentResponse$Identities' => '<p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>', 'IAMPolicyAssignment$Identities' => '<p>Identities.</p>', 'UpdateIAMPolicyAssignmentRequest$Identities' => '<p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>', 'UpdateIAMPolicyAssignmentResponse$Identities' => '<p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>', ], ], 'IdentityName' => [ 'base' => NULL, 'refs' => [ 'IdentityNameList$member' => NULL, ], ], 'IdentityNameList' => [ 'base' => NULL, 'refs' => [ 'IdentityMap$value' => NULL, ], ], 'IdentityStore' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'CreateNamespaceResponse$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'NamespaceInfoV2$IdentityStore' => '<p>The identity store used for the namespace.</p>', ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$IdentityType' => '<p>The identity type that your Amazon QuickSight account uses to manage the identity of users.</p>', 'User$IdentityType' => '<p>The type of identity authentication used by the user.</p>', ], ], 'IdentityTypeNotSupportedException' => [ 'base' => '<p>The identity type specified isn\'t supported. Supported identity types include <code>IAM</code> and <code>QUICKSIGHT</code>.</p>', 'refs' => [], ], 'IncrementalRefresh' => [ 'base' => '<p>The incremental refresh configuration for a dataset.</p>', 'refs' => [ 'RefreshConfiguration$IncrementalRefresh' => '<p>The incremental refresh for the dataset.</p>', ], ], 'Ingestion' => [ 'base' => '<p>Information about the SPICE ingestion for a dataset.</p>', 'refs' => [ 'DescribeIngestionResponse$Ingestion' => '<p>Information about the ingestion.</p>', 'Ingestions$member' => NULL, ], ], 'IngestionErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$Type' => '<p>Error type.</p>', ], ], 'IngestionId' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CancelIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'DescribeIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'Ingestion$IngestionId' => '<p>Ingestion ID.</p>', ], ], 'IngestionMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'IngestionRequestSource' => [ 'base' => NULL, 'refs' => [ 'Ingestion$RequestSource' => '<p>Event source for this ingestion.</p>', ], ], 'IngestionRequestType' => [ 'base' => 'This defines the type of ingestion request. This is returned as part of create ingestion response.', 'refs' => [ 'Ingestion$RequestType' => '<p>Type of this ingestion.</p>', ], ], 'IngestionStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIngestionResponse$IngestionStatus' => '<p>The ingestion status.</p>', 'Ingestion$IngestionStatus' => '<p>Ingestion status.</p>', ], ], 'IngestionType' => [ 'base' => 'This defines the type of ingestion user wants to trigger. This is part of create ingestion request.', 'refs' => [ 'CreateIngestionRequest$IngestionType' => '<p>The type of ingestion that you want to create.</p>', 'RefreshSchedule$RefreshType' => '<p>The type of refresh that a datset undergoes. Valid values are as follows:</p> <ul> <li> <p> <code>FULL_REFRESH</code>: A complete refresh of a dataset.</p> </li> <li> <p> <code>INCREMENTAL_REFRESH</code>: A partial refresh of some rows of a dataset, based on the time window specified.</p> </li> </ul> <p>For more information on full and incremental refreshes, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/refreshing-imported-data.html">Refreshing SPICE data</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'Ingestions' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsResponse$Ingestions' => '<p>A list of the ingestions.</p>', ], ], 'InnerFilter' => [ 'base' => '<p>The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.</p>', 'refs' => [ 'NestedFilter$InnerFilter' => '<p>The <code>InnerFilter</code> defines the subset of data to be used with the <code>NestedFilter</code>.</p>', ], ], 'InputColumn' => [ 'base' => '<p>Metadata for a column that is used as the input of a transform operation.</p>', 'refs' => [ 'InputColumnList$member' => NULL, ], ], 'InputColumnDataType' => [ 'base' => NULL, 'refs' => [ 'InputColumn$Type' => '<p>The data type of the column.</p>', ], ], 'InputColumnList' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Columns' => '<p>The column schema from the SQL query result set.</p>', 'RelationalTable$InputColumns' => '<p>The column schema of the table.</p>', 'S3Source$InputColumns' => '<p>A physical table type for an S3 data source.</p> <note> <p>For files that aren\'t JSON, only <code>STRING</code> data types are supported in input columns.</p> </note>', ], ], 'InsightConfiguration' => [ 'base' => '<p>The configuration of an insight visual.</p>', 'refs' => [ 'InsightVisual$InsightConfiguration' => '<p>The configuration of an insight visual.</p>', ], ], 'InsightVisual' => [ 'base' => '<p>An insight visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with insights</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$InsightVisual' => '<p>An insight visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with insights</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'RdsParameters$InstanceId' => '<p>Instance ID.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Anchor$Offset' => '<p>The offset of the Anchor.</p>', 'ArcAxisConfiguration$ReserveRange' => '<p>The reserved range of the arc axis.</p>', 'AxisLinearScale$StepCount' => '<p>The step count setup of a linear axis.</p>', 'DisplayFormatOptions$FractionDigits' => '<p>Determines the number of fraction digits.</p>', 'ExcludePeriodConfiguration$Amount' => '<p>The amount or number of the exclude period.</p>', 'RelativeDatesFilter$RelativeDateValue' => '<p>The date value of the filter.</p>', 'TopBottomFilter$Limit' => '<p>The number of items to include in the top bottom filter results.</p>', 'TopicIRComparisonMethod$WindowSize' => '<p>The window size for the <code>TopicIRComparisonMethod</code>.</p>', ], ], 'IntegerDatasetParameter' => [ 'base' => '<p>An integer parameter for a dataset.</p>', 'refs' => [ 'DatasetParameter$IntegerDatasetParameter' => '<p>An integer parameter that is created in the dataset.</p>', ], ], 'IntegerDatasetParameterDefaultValue' => [ 'base' => '<p>The default value for the integer parameter.</p>', 'refs' => [ 'IntegerDatasetParameterValueList$member' => NULL, ], ], 'IntegerDatasetParameterDefaultValues' => [ 'base' => '<p>The default values of an integer parameter.</p>', 'refs' => [ 'IntegerDatasetParameter$DefaultValues' => '<p>A list of default values for a given integer parameter. This structure only accepts static values.</p>', ], ], 'IntegerDatasetParameterValueList' => [ 'base' => NULL, 'refs' => [ 'IntegerDatasetParameterDefaultValues$StaticValues' => '<p>A list of static default values for a given integer parameter.</p>', 'NewDefaultValues$IntegerStaticValues' => '<p>A list of static default values for a given integer parameter.</p>', ], ], 'IntegerDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'CustomParameterValues$IntegerValues' => '<p>A list of integer-type parameter values.</p>', 'IntegerDefaultValues$StaticValues' => '<p>The static values of the <code>IntegerDefaultValues</code>.</p>', ], ], 'IntegerDefaultValues' => [ 'base' => '<p>The default values of the <code>IntegerParameterDeclaration</code>.</p>', 'refs' => [ 'IntegerParameterDeclaration$DefaultValues' => '<p>The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.</p>', ], ], 'IntegerParameter' => [ 'base' => '<p>An integer parameter.</p>', 'refs' => [ 'IntegerParameterList$member' => NULL, ], ], 'IntegerParameterDeclaration' => [ 'base' => '<p>A parameter declaration for the <code>Integer</code> data type.</p>', 'refs' => [ 'ParameterDeclaration$IntegerParameterDeclaration' => '<p>A parameter declaration for the <code>Integer</code> data type.</p>', ], ], 'IntegerParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$IntegerParameters' => '<p>The parameters that have a data type of integer.</p>', ], ], 'IntegerValueWhenUnsetConfiguration' => [ 'base' => '<p>A parameter declaration for the <code>Integer</code> data type.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'IntegerParameterDeclaration$ValueWhenUnset' => '<p>A parameter declaration for the <code>Integer</code> data type.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal failure occurred.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <code>NextToken</code> value isn\'t valid.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>One or more parameters has a value that isn\'t valid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>You don\'t have this feature activated for your account. To fix this issue, contact Amazon Web Services support.</p>', 'refs' => [], ], 'InvalidTopicReviewedAnswer' => [ 'base' => '<p>The definition for a <code>InvalidTopicReviewedAnswer</code>.</p>', 'refs' => [ 'InvalidTopicReviewedAnswers$member' => NULL, ], ], 'InvalidTopicReviewedAnswers' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerResponse$InvalidAnswers' => '<p>The definition of Answers that are invalid and not created.</p>', 'BatchDeleteTopicReviewedAnswerResponse$InvalidAnswers' => '<p>The definition of Answers that are invalid and not deleted.</p>', ], ], 'IpRestrictionRuleDescription' => [ 'base' => NULL, 'refs' => [ 'IpRestrictionRuleMap$value' => NULL, ], ], 'IpRestrictionRuleMap' => [ 'base' => NULL, 'refs' => [ 'DescribeIpRestrictionResponse$IpRestrictionRuleMap' => '<p>A map that describes the IP rules with CIDR range and description.</p>', 'UpdateIpRestrictionRequest$IpRestrictionRuleMap' => '<p>A map that describes the updated IP rules with CIDR ranges and descriptions.</p>', ], ], 'ItemsLimitConfiguration' => [ 'base' => '<p>The limit configuration of the visual display for an axis.</p>', 'refs' => [ 'BarChartSortConfiguration$CategoryItemsLimit' => '<p>The limit on the number of categories displayed in a bar chart.</p>', 'BarChartSortConfiguration$ColorItemsLimit' => '<p>The limit on the number of values displayed in a bar chart.</p>', 'BarChartSortConfiguration$SmallMultiplesLimitConfiguration' => '<p>The limit on the number of small multiples panels that are displayed.</p>', 'ComboChartSortConfiguration$CategoryItemsLimit' => '<p>The item limit configuration for the category field well of a combo chart.</p>', 'ComboChartSortConfiguration$ColorItemsLimit' => '<p>The item limit configuration of the color field well in a combo chart.</p>', 'FunnelChartSortConfiguration$CategoryItemsLimit' => '<p>The limit on the number of categories displayed.</p>', 'HeatMapSortConfiguration$HeatMapRowItemsLimitConfiguration' => '<p>The limit on the number of rows that are displayed in a heat map.</p>', 'HeatMapSortConfiguration$HeatMapColumnItemsLimitConfiguration' => '<p>The limit on the number of columns that are displayed in a heat map.</p>', 'LineChartSortConfiguration$CategoryItemsLimitConfiguration' => '<p>The limit on the number of categories that are displayed in a line chart.</p>', 'LineChartSortConfiguration$ColorItemsLimitConfiguration' => '<p>The limit on the number of lines that are displayed in a line chart.</p>', 'LineChartSortConfiguration$SmallMultiplesLimitConfiguration' => '<p>The limit on the number of small multiples panels that are displayed.</p>', 'PieChartSortConfiguration$CategoryItemsLimit' => '<p>The limit on the number of categories that are displayed in a pie chart.</p>', 'PieChartSortConfiguration$SmallMultiplesLimitConfiguration' => '<p>The limit on the number of small multiples panels that are displayed.</p>', 'RadarChartSortConfiguration$CategoryItemsLimit' => '<p>The category items limit for a radar chart.</p>', 'RadarChartSortConfiguration$ColorItemsLimit' => '<p>The color items limit of a radar chart.</p>', 'SankeyDiagramSortConfiguration$SourceItemsLimit' => '<p>The limit on the number of source nodes that are displayed in a sankey diagram.</p>', 'SankeyDiagramSortConfiguration$DestinationItemsLimit' => '<p>The limit on the number of destination nodes that are displayed in a sankey diagram.</p>', 'ScatterPlotSortConfiguration$ScatterPlotLimitConfiguration' => NULL, 'TreeMapSortConfiguration$TreeMapGroupItemsLimitConfiguration' => '<p>The limit on the number of groups that are displayed.</p>', 'WaterfallChartSortConfiguration$BreakdownItemsLimit' => '<p>The limit on the number of bar groups that are displayed.</p>', 'WordCloudSortConfiguration$CategoryItemsLimit' => '<p>The limit on the number of groups that are displayed in a word cloud.</p>', ], ], 'JiraParameters' => [ 'base' => '<p>The parameters for Jira.</p>', 'refs' => [ 'DataSourceParameters$JiraParameters' => '<p>The parameters for Jira.</p>', ], ], 'JoinInstruction' => [ 'base' => '<p>The instructions associated with a join. </p>', 'refs' => [ 'LogicalTableSource$JoinInstruction' => '<p>Specifies the result of a join of two logical tables.</p>', ], ], 'JoinKeyProperties' => [ 'base' => '<p>Properties associated with the columns participating in a join.</p>', 'refs' => [ 'JoinInstruction$LeftJoinKeyProperties' => '<p>Join key properties of the left operand.</p>', 'JoinInstruction$RightJoinKeyProperties' => '<p>Join key properties of the right operand.</p>', ], ], 'JoinType' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$Type' => '<p>The type of join that it is.</p>', ], ], 'KPIActualValueConditionalFormatting' => [ 'base' => '<p>The conditional formatting for the actual value of a KPI visual.</p>', 'refs' => [ 'KPIConditionalFormattingOption$ActualValue' => '<p>The conditional formatting for the actual value of a KPI visual.</p>', ], ], 'KPIComparisonValueConditionalFormatting' => [ 'base' => '<p>The conditional formatting for the comparison value of a KPI visual.</p>', 'refs' => [ 'KPIConditionalFormattingOption$ComparisonValue' => '<p>The conditional formatting for the comparison value of a KPI visual.</p>', ], ], 'KPIConditionalFormatting' => [ 'base' => '<p>The conditional formatting of a KPI visual.</p>', 'refs' => [ 'KPIVisual$ConditionalFormatting' => '<p>The conditional formatting of a KPI visual.</p>', ], ], 'KPIConditionalFormattingOption' => [ 'base' => '<p>The conditional formatting options of a KPI visual.</p>', 'refs' => [ 'KPIConditionalFormattingOptionList$member' => NULL, ], ], 'KPIConditionalFormattingOptionList' => [ 'base' => NULL, 'refs' => [ 'KPIConditionalFormatting$ConditionalFormattingOptions' => '<p>The conditional formatting options of a KPI visual.</p>', ], ], 'KPIConfiguration' => [ 'base' => '<p>The configuration of a KPI visual.</p>', 'refs' => [ 'KPIVisual$ChartConfiguration' => '<p>The configuration of a KPI visual.</p>', ], ], 'KPIFieldWells' => [ 'base' => '<p>The field well configuration of a KPI visual.</p>', 'refs' => [ 'KPIConfiguration$FieldWells' => '<p>The field well configuration of a KPI visual.</p>', ], ], 'KPIOptions' => [ 'base' => '<p>The options that determine the presentation of a KPI visual.</p>', 'refs' => [ 'KPIConfiguration$KPIOptions' => '<p>The options that determine the presentation of a KPI visual.</p>', ], ], 'KPIPrimaryValueConditionalFormatting' => [ 'base' => '<p>The conditional formatting for the primary value of a KPI visual.</p>', 'refs' => [ 'KPIConditionalFormattingOption$PrimaryValue' => '<p>The conditional formatting for the primary value of a KPI visual.</p>', ], ], 'KPIProgressBarConditionalFormatting' => [ 'base' => '<p>The conditional formatting for the progress bar of a KPI visual.</p>', 'refs' => [ 'KPIConditionalFormattingOption$ProgressBar' => '<p>The conditional formatting for the progress bar of a KPI visual.</p>', ], ], 'KPISortConfiguration' => [ 'base' => '<p>The sort configuration of a KPI visual.</p>', 'refs' => [ 'KPIConfiguration$SortConfiguration' => '<p>The sort configuration of a KPI visual.</p>', ], ], 'KPISparklineOptions' => [ 'base' => '<p>The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.</p>', 'refs' => [ 'KPIOptions$Sparkline' => '<p>The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.</p>', ], ], 'KPISparklineType' => [ 'base' => NULL, 'refs' => [ 'KPISparklineOptions$Type' => '<p>The type of the sparkline.</p>', ], ], 'KPIVisual' => [ 'base' => '<p>A key performance indicator (KPI).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using KPIs</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$KPIVisual' => '<p>A key performance indicator (KPI).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using KPIs</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'KPIVisualLayoutOptions' => [ 'base' => '<p>The options that determine the layout a KPI visual.</p>', 'refs' => [ 'KPIOptions$VisualLayoutOptions' => '<p>The options that determine the layout a KPI visual.</p>', ], ], 'KPIVisualStandardLayout' => [ 'base' => '<p>The standard layout of the KPI visual.</p>', 'refs' => [ 'KPIVisualLayoutOptions$StandardLayout' => '<p>The standard layout of the KPI visual.</p>', ], ], 'KPIVisualStandardLayoutType' => [ 'base' => NULL, 'refs' => [ 'KPIVisualStandardLayout$Type' => '<p>The standard layout type.</p>', ], ], 'KeyRegistration' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyRegistrationResponse$KeyRegistration' => '<p>A list of <code>RegisteredCustomerManagedKey</code> objects in a Amazon QuickSight account.</p>', 'UpdateKeyRegistrationRequest$KeyRegistration' => '<p>A list of <code>RegisteredCustomerManagedKey</code> objects to be updated to the Amazon QuickSight account.</p>', ], ], 'LabelOptions' => [ 'base' => '<p>The share label options for the labels.</p>', 'refs' => [ 'AxisTickLabelOptions$LabelOptions' => '<p>Determines whether or not the axis ticks are visible.</p>', 'DateTimePickerControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'DropDownControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'LegendOptions$Title' => '<p>The custom title for the legend.</p>', 'ListControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'RelativeDateTimeControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'SliderControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'TextAreaControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', 'TextFieldControlDisplayOptions$TitleOptions' => '<p>The options to configure the title visibility, name, and font size.</p>', ], ], 'Latitude' => [ 'base' => NULL, 'refs' => [ 'GeospatialCoordinateBounds$North' => '<p>The latitude of the north bound of the geospatial coordinate bounds.</p>', 'GeospatialCoordinateBounds$South' => '<p>The latitude of the south bound of the geospatial coordinate bounds.</p>', ], ], 'Layout' => [ 'base' => '<p>A <code>Layout</code> defines the placement of elements within a sheet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'LayoutList$member' => NULL, ], ], 'LayoutConfiguration' => [ 'base' => '<p>The configuration that determines what the type of layout will be used on a sheet.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'Layout$Configuration' => '<p>The configuration that determines what the type of layout for a sheet.</p>', ], ], 'LayoutElementType' => [ 'base' => NULL, 'refs' => [ 'FreeFormLayoutElement$ElementType' => '<p>The type of element.</p>', 'GridLayoutElement$ElementType' => '<p>The type of element.</p>', ], ], 'LayoutList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$Layouts' => '<p>Layouts define how the components of a sheet are arranged.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'LegendOptions' => [ 'base' => '<p>The options for the legend setup of a visual.</p>', 'refs' => [ 'BarChartConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'BoxPlotChartConfiguration$Legend' => NULL, 'ComboChartConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'FilledMapConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'GeospatialMapConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'HeatMapConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'LineChartConfiguration$Legend' => '<p>The legend configuration of a line chart.</p>', 'PieChartConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'RadarChartConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'ScatterPlotConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'TreeMapConfiguration$Legend' => '<p>The legend display setup of the visual.</p>', 'WaterfallChartConfiguration$Legend' => '<p>The legend configuration of a waterfall visual.</p>', ], ], 'LegendPosition' => [ 'base' => NULL, 'refs' => [ 'LegendOptions$Position' => '<p>The positions for the legend. Choose one of the following options:</p> <ul> <li> <p> <code>AUTO</code> </p> </li> <li> <p> <code>RIGHT</code> </p> </li> <li> <p> <code>BOTTOM</code> </p> </li> <li> <p> <code>LEFT</code> </p> </li> </ul>', ], ], 'Length' => [ 'base' => 'String based length that is composed of value and unit', 'refs' => [ 'Spacing$Top' => '<p>Define the top spacing.</p>', 'Spacing$Bottom' => '<p>Define the bottom spacing.</p>', 'Spacing$Left' => '<p>Define the left spacing.</p>', 'Spacing$Right' => '<p>Define the right spacing.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit is exceeded.</p>', 'refs' => [], ], 'LimitedString' => [ 'base' => NULL, 'refs' => [ 'AggFunction$PeriodField' => '<p>The period field for an Agg function.</p>', 'AggregationFunctionParameters$key' => NULL, 'AggregationFunctionParameters$value' => NULL, 'AggregationPartitionBy$FieldName' => '<p>The field Name for an <code>AggregationPartitionBy</code>.</p>', 'CellValueSynonym$CellValue' => '<p>The cell value.</p>', 'ContributionAnalysisFactor$FieldName' => '<p>The field name of the <code>ContributionAnalysisFactor</code>.</p>', 'CreateTopicReviewedAnswer$Question' => '<p>The Question to be created.</p>', 'DataAggregation$DefaultDateColumnName' => '<p>The column name for the default date.</p>', 'DatasetMetadata$DatasetName' => '<p>The name of the dataset.</p>', 'DatasetMetadata$DatasetDescription' => '<p>The description of the dataset.</p>', 'DisplayFormatOptions$BlankCellFormat' => '<p>Determines the blank cell format.</p>', 'DisplayFormatOptions$DateFormat' => '<p>Determines the <code>DateTime</code> format.</p>', 'DisplayFormatOptions$GroupingSeparator' => '<p>Determines the grouping separator.</p>', 'DisplayFormatOptions$Prefix' => '<p>The prefix value for a display format.</p>', 'DisplayFormatOptions$Suffix' => '<p>The suffix value for a display format.</p>', 'DisplayFormatOptions$CurrencySymbol' => '<p>The currency symbol, such as <code>USD</code>.</p>', 'Identifier$Identity' => '<p>The identity of the identifier.</p>', 'NamedEntityDefinition$FieldName' => '<p>The name of the entity.</p>', 'NamedEntityDefinition$PropertyName' => '<p>The property name to be used for the named entity.</p>', 'NamedEntityRef$NamedEntityName' => '<p>The <code>NamedEntityName</code> for the <code>NamedEntityRef</code>.</p>', 'NegativeFormat$Prefix' => '<p>The prefix for a negative format.</p>', 'NegativeFormat$Suffix' => '<p>The suffix for a negative format.</p>', 'RangeConstant$Minimum' => '<p>The minimum value for a range constant.</p>', 'RangeConstant$Maximum' => '<p>The maximum value for a range constant.</p>', 'SemanticEntityType$TypeName' => '<p>The semantic entity type name.</p>', 'SemanticEntityType$SubTypeName' => '<p>The semantic entity sub type name.</p>', 'SemanticType$TypeName' => '<p>The semantic type name.</p>', 'SemanticType$SubTypeName' => '<p>The semantic type sub type name.</p>', 'Slot$SlotId' => '<p>The slot ID of the slot.</p>', 'Slot$VisualId' => '<p>The visual ID for the slot.</p>', 'Synonyms$member' => NULL, 'TopicCalculatedField$CalculatedFieldName' => '<p>The calculated field name.</p>', 'TopicCalculatedField$CalculatedFieldDescription' => '<p>The calculated field description.</p>', 'TopicCategoryFilterConstant$SingularConstant' => '<p>A singular constant used in a category filter. This element is used to specify a single value for the constant.</p>', 'TopicColumn$ColumnName' => '<p>The name of the column.</p>', 'TopicColumn$ColumnFriendlyName' => '<p>A user-friendly name for the column.</p>', 'TopicColumn$ColumnDescription' => '<p>A description of the column and its contents.</p>', 'TopicDetails$Description' => '<p>The description of the topic.</p>', 'TopicFilter$FilterDescription' => '<p>A description of the filter used to select items for a topic.</p>', 'TopicFilter$FilterName' => '<p>The name of the filter.</p>', 'TopicFilter$OperandFieldName' => '<p>The name of the field that the filter operates on.</p>', 'TopicNamedEntity$EntityName' => '<p>The name of the named entity.</p>', 'TopicNamedEntity$EntityDescription' => '<p>The description of the named entity.</p>', 'TopicRefreshSchedule$Timezone' => '<p>The timezone that you want the refresh schedule to use.</p>', 'TopicRefreshSchedule$RepeatAt' => '<p>The time of day when the refresh should run, for example, Monday-Sunday.</p>', 'TopicRefreshScheduleSummary$DatasetId' => '<p>The ID of the dataset.</p>', 'TopicRefreshScheduleSummary$DatasetName' => '<p>The name of the dataset.</p>', 'TopicReviewedAnswer$Question' => '<p>The question for the <code>TopicReviewedAnswer</code>.</p>', 'TopicSingularFilterConstant$SingularConstant' => '<p>The value of the singular filter constant.</p>', 'TopicTemplate$TemplateType' => '<p>The template type for the <code>TopicTemplate</code>.</p>', 'TopicVisual$VisualId' => '<p>The visual ID for the <code>TopicVisual</code>.</p>', 'TypeParameters$key' => NULL, 'TypeParameters$value' => NULL, 'VisualOptions$type' => '<p>The type for a <code>VisualOptions</code>.</p>', ], ], 'LineChartAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a line chart.</p>', 'refs' => [ 'LineChartFieldWells$LineChartAggregatedFieldWells' => '<p>The field well configuration of a line chart.</p>', ], ], 'LineChartConfiguration' => [ 'base' => '<p>The configuration of a line chart.</p>', 'refs' => [ 'LineChartVisual$ChartConfiguration' => '<p>The configuration of a line chart.</p>', ], ], 'LineChartDefaultSeriesSettings' => [ 'base' => '<p>The options that determine the default presentation of all line series in <code>LineChartVisual</code>.</p>', 'refs' => [ 'LineChartConfiguration$DefaultSeriesSettings' => '<p>The options that determine the default presentation of all line series in <code>LineChartVisual</code>.</p>', ], ], 'LineChartFieldWells' => [ 'base' => '<p>The field well configuration of a line chart.</p>', 'refs' => [ 'LineChartConfiguration$FieldWells' => '<p>The field well configuration of a line chart.</p>', ], ], 'LineChartLineStyle' => [ 'base' => NULL, 'refs' => [ 'LineChartLineStyleSettings$LineStyle' => '<p>Line style for line series.</p> <ul> <li> <p> <code>SOLID</code>: Show as a solid line.</p> </li> <li> <p> <code>DOTTED</code>: Show as a dotted line.</p> </li> <li> <p> <code>DASHED</code>: Show as a dashed line.</p> </li> </ul>', ], ], 'LineChartLineStyleSettings' => [ 'base' => '<p>Line styles options for a line series in <code>LineChartVisual</code>.</p>', 'refs' => [ 'LineChartDefaultSeriesSettings$LineStyleSettings' => '<p>Line styles options for all line series in the visual.</p>', 'LineChartSeriesSettings$LineStyleSettings' => '<p>Line styles options for a line series in <code>LineChartVisual</code>.</p>', ], ], 'LineChartMarkerShape' => [ 'base' => NULL, 'refs' => [ 'LineChartMarkerStyleSettings$MarkerShape' => '<p>Shape option for markers in the series.</p> <ul> <li> <p> <code>CIRCLE</code>: Show marker as a circle.</p> </li> <li> <p> <code>TRIANGLE</code>: Show marker as a triangle.</p> </li> <li> <p> <code>SQUARE</code>: Show marker as a square.</p> </li> <li> <p> <code>DIAMOND</code>: Show marker as a diamond.</p> </li> <li> <p> <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.</p> </li> </ul>', ], ], 'LineChartMarkerStyleSettings' => [ 'base' => '<p>Marker styles options for a line series in <code>LineChartVisual</code>.</p>', 'refs' => [ 'LineChartDefaultSeriesSettings$MarkerStyleSettings' => '<p>Marker styles options for all line series in the visual.</p>', 'LineChartSeriesSettings$MarkerStyleSettings' => '<p>Marker styles options for a line series in <code>LineChartVisual</code>.</p>', ], ], 'LineChartSeriesSettings' => [ 'base' => '<p>The options that determine the presentation of a line series in the visual</p>', 'refs' => [ 'DataFieldSeriesItem$Settings' => '<p>The options that determine the presentation of line series associated to the field.</p>', 'FieldSeriesItem$Settings' => '<p>The options that determine the presentation of line series associated to the field.</p>', ], ], 'LineChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a line chart.</p>', 'refs' => [ 'LineChartConfiguration$SortConfiguration' => '<p>The sort configuration of a line chart.</p>', ], ], 'LineChartType' => [ 'base' => NULL, 'refs' => [ 'LineChartConfiguration$Type' => '<p>Determines the type of the line chart.</p>', ], ], 'LineChartVisual' => [ 'base' => '<p>A line chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using line charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$LineChartVisual' => '<p>A line chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using line charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'LineInterpolation' => [ 'base' => NULL, 'refs' => [ 'LineChartLineStyleSettings$LineInterpolation' => '<p>Interpolation style for line series.</p> <ul> <li> <p> <code>LINEAR</code>: Show as default, linear style.</p> </li> <li> <p> <code>SMOOTH</code>: Show as a smooth curve.</p> </li> <li> <p> <code>STEPPED</code>: Show steps in line.</p> </li> </ul>', ], ], 'LineSeriesAxisDisplayOptions' => [ 'base' => '<p>The series axis configuration of a line chart.</p>', 'refs' => [ 'LineChartConfiguration$PrimaryYAxisDisplayOptions' => '<p>The series axis configuration of a line chart.</p>', 'LineChartConfiguration$SecondaryYAxisDisplayOptions' => '<p>The series axis configuration of a line chart.</p>', ], ], 'LinkEntityArn' => [ 'base' => NULL, 'refs' => [ 'LinkEntityArnList$member' => NULL, ], ], 'LinkEntityArnList' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$LinkEntities' => '<p>A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.</p>', 'Dashboard$LinkEntities' => '<p>A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.</p>', 'UpdateDashboardLinksRequest$LinkEntities' => '<p> list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.</p>', 'UpdateDashboardLinksResponse$LinkEntities' => '<p>A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.</p>', ], ], 'LinkSharingConfiguration' => [ 'base' => '<p>A structure that contains the configuration of a shareable link to the dashboard.</p>', 'refs' => [ 'CreateDashboardRequest$LinkSharingConfiguration' => '<p>A structure that contains the permissions of a shareable link to the dashboard.</p>', 'DescribeDashboardPermissionsResponse$LinkSharingConfiguration' => '<p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>', 'UpdateDashboardPermissionsResponse$LinkSharingConfiguration' => '<p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>', ], ], 'ListAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalysesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetBundleExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetBundleExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetBundleImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetBundleImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultFilterListControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterListControl$DisplayOptions' => '<p>The display options of a control.</p>', 'ParameterListControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'ListControlSearchOptions' => [ 'base' => '<p>The configuration of the search options in a list control.</p>', 'refs' => [ 'ListControlDisplayOptions$SearchOptions' => '<p>The configuration of the search options in a list control.</p>', ], ], 'ListControlSelectAllOptions' => [ 'base' => '<p>The configuration of the <code>Select all</code> options in a list control.</p>', 'refs' => [ 'DropDownControlDisplayOptions$SelectAllOptions' => '<p>The configuration of the <code>Select all</code> options in a dropdown control.</p>', 'ListControlDisplayOptions$SelectAllOptions' => '<p>The configuration of the <code>Select all</code> options in a list control.</p>', ], ], 'ListDashboardVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFolderMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFolderMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFoldersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFoldersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityPropagationConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityPropagationConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityPropagationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIdentityPropagationConfigsRequest$MaxResults' => '<p>The maximum number of results to be returned.</p>', ], ], 'ListIngestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRefreshSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRefreshSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoleMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoleMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicRefreshSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicRefreshSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicReviewedAnswersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicReviewedAnswersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVPCConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVPCConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoadingAnimation' => [ 'base' => '<p>The configuration of loading animation in free-form layout. </p>', 'refs' => [ 'FreeFormLayoutElement$LoadingAnimation' => '<p>The loading animation configuration of a free-form layout element.</p>', ], ], 'LocalNavigationConfiguration' => [ 'base' => '<p>The navigation configuration for <code>CustomActionNavigationOperation</code>.</p>', 'refs' => [ 'CustomActionNavigationOperation$LocalNavigationConfiguration' => '<p>The configuration that chooses the navigation target.</p>', ], ], 'LogicalTable' => [ 'base' => '<p>A <i>logical table</i> is a unit that joins and that data transformations operate on. A logical table has a source, which can be either a physical table or result of a join. When a logical table points to a physical table, the logical table acts as a mutable copy of that physical table through transform operations.</p>', 'refs' => [ 'LogicalTableMap$value' => NULL, ], ], 'LogicalTableAlias' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$Alias' => '<p>A display name for the logical table.</p>', ], ], 'LogicalTableId' => [ 'base' => '<p>An identifier for the logical table that is defined in the dataset</p>', 'refs' => [ 'JoinInstruction$LeftOperand' => '<p>The operand on the left side of a join.</p>', 'JoinInstruction$RightOperand' => '<p>The operand on the right side of a join.</p>', 'LogicalTableMap$key' => NULL, ], ], 'LogicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'DataSet$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'UpdateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', ], ], 'LogicalTableSource' => [ 'base' => '<p>Information about the source of a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'LogicalTable$Source' => '<p>Source of this logical table.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataSet$ConsumedSpiceCapacityInBytes' => '<p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn\'t imported into SPICE.</p>', 'Ingestion$IngestionTimeInSeconds' => '<p>The time that this ingestion took, measured in seconds.</p>', 'Ingestion$IngestionSizeInBytes' => '<p>The size of the data ingested, in bytes.</p>', 'ItemsLimitConfiguration$ItemsLimit' => '<p>The limit on how many items of a field are showed in the chart. For example, the number of slices that are displayed in a pie chart.</p>', 'PaginationConfiguration$PageSize' => '<p>Indicates how many items render in one page.</p>', 'RowInfo$RowsIngested' => '<p>The number of rows that were ingested.</p>', 'RowInfo$RowsDropped' => '<p>The number of rows that were not ingested.</p>', 'RowInfo$TotalRowsInDataset' => '<p>The total number of rows in the dataset.</p>', ], ], 'LongFormatText' => [ 'base' => '<p>The text format for a subtitle.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'VisualSubtitleLabelOptions$FormatText' => '<p>The long text format of the subtitle label, such as plain text or rich text.</p>', ], ], 'LongPlainText' => [ 'base' => NULL, 'refs' => [ 'LongFormatText$PlainText' => '<p>Plain text format.</p>', ], ], 'LongRichText' => [ 'base' => NULL, 'refs' => [ 'LongFormatText$RichText' => '<p>Rich text. Examples of rich text include bold, underline, and italics.</p>', ], ], 'Longitude' => [ 'base' => NULL, 'refs' => [ 'GeospatialCoordinateBounds$West' => '<p>The longitude of the west bound of the geospatial coordinate bounds.</p>', 'GeospatialCoordinateBounds$East' => '<p>The longitude of the east bound of the geospatial coordinate bounds.</p>', ], ], 'LookbackWindow' => [ 'base' => '<p>The lookback window setup of an incremental refresh configuration.</p>', 'refs' => [ 'IncrementalRefresh$LookbackWindow' => '<p>The lookback window setup for an incremental refresh configuration.</p>', ], ], 'LookbackWindowSizeUnit' => [ 'base' => NULL, 'refs' => [ 'LookbackWindow$SizeUnit' => '<p>The size unit that is used for the lookback window column. Valid values for this structure are <code>HOUR</code>, <code>DAY</code>, and <code>WEEK</code>.</p>', ], ], 'ManifestFileLocation' => [ 'base' => '<p>Amazon S3 manifest file location.</p>', 'refs' => [ 'S3Parameters$ManifestFileLocation' => '<p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Amazon QuickSight.</p>', ], ], 'MapZoomMode' => [ 'base' => NULL, 'refs' => [ 'GeospatialWindowOptions$MapZoomMode' => '<p>The map zoom modes (manual, auto) of the geospatial window options.</p>', ], ], 'MappedDataSetParameter' => [ 'base' => '<p>A dataset parameter that is mapped to an analysis parameter.</p>', 'refs' => [ 'MappedDataSetParameters$member' => NULL, ], ], 'MappedDataSetParameters' => [ 'base' => '<p>A list of dataset parameters that are mapped to an analysis parameter.</p>', 'refs' => [ 'DateTimeParameterDeclaration$MappedDataSetParameters' => NULL, 'DecimalParameterDeclaration$MappedDataSetParameters' => NULL, 'IntegerParameterDeclaration$MappedDataSetParameters' => NULL, 'StringParameterDeclaration$MappedDataSetParameters' => NULL, ], ], 'MarginStyle' => [ 'base' => '<p>The display options for margins around the outside edge of sheets.</p>', 'refs' => [ 'TileLayoutStyle$Margin' => '<p>The margin settings that apply around the outside edge of sheets.</p>', ], ], 'MariaDbParameters' => [ 'base' => '<p>The parameters for MariaDB.</p>', 'refs' => [ 'DataSourceParameters$MariaDbParameters' => '<p>The parameters for MariaDB.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFolderPermissionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'DescribeFolderResolvedPermissionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListAnalysesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListAssetBundleExportJobsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListAssetBundleImportJobsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDashboardVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSetsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSourcesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListFolderMembersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListFoldersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListGroupMembershipsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListIAMPolicyAssignmentsForUserRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListIAMPolicyAssignmentsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListNamespacesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListRoleMembershipsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListTemplateAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplateVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplatesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTopicsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListUserGroupsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListVPCConnectionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchAnalysesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'SearchDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchDataSetsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchDataSourcesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchFoldersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchGroupsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', ], ], 'MaximumLabelType' => [ 'base' => '<p>The maximum label of a data path label.</p>', 'refs' => [ 'DataLabelType$MaximumLabelType' => '<p>Determines the label configuration for the maximum value in a visual.</p>', ], ], 'MaximumMinimumComputation' => [ 'base' => '<p>The maximum and minimum computation configuration.</p>', 'refs' => [ 'Computation$MaximumMinimum' => '<p>The maximum and minimum computation configuration.</p>', ], ], 'MaximumMinimumComputationType' => [ 'base' => NULL, 'refs' => [ 'MaximumMinimumComputation$Type' => '<p>The type of computation. Choose one of the following options:</p> <ul> <li> <p>MAXIMUM: A maximum computation.</p> </li> <li> <p>MINIMUM: A minimum computation.</p> </li> </ul>', ], ], 'MeasureField' => [ 'base' => '<p>The measure (metric) type field.</p>', 'refs' => [ 'BoxPlotMeasureFieldList$member' => NULL, 'FilledMapMeasureFieldList$member' => NULL, 'ForecastComputation$Value' => '<p>The value field that is used in a computation.</p>', 'FunnelChartMeasureFieldList$member' => NULL, 'GrowthRateComputation$Value' => '<p>The value field that is used in a computation.</p>', 'HeatMapMeasureFieldList$member' => NULL, 'HistogramMeasureFieldList$member' => NULL, 'MaximumMinimumComputation$Value' => '<p>The value field that is used in a computation.</p>', 'MeasureFieldList$member' => NULL, 'MetricComparisonComputation$FromValue' => '<p>The field that is used in a metric comparison from value setup.</p>', 'MetricComparisonComputation$TargetValue' => '<p>The field that is used in a metric comparison to value setup.</p>', 'PeriodOverPeriodComputation$Value' => '<p>The value field that is used in a computation.</p>', 'PeriodToDateComputation$Value' => '<p>The value field that is used in a computation.</p>', 'PivotMeasureFieldList$member' => NULL, 'RadarChartValuesFieldList$member' => NULL, 'TopBottomMoversComputation$Value' => '<p>The value field that is used in a computation.</p>', 'TopBottomRankedComputation$Value' => '<p>The value field that is used in a computation.</p>', 'TotalAggregationComputation$Value' => '<p>The value field that is used in a computation.</p>', 'TreeMapMeasureFieldList$member' => NULL, 'WordCloudMeasureFieldList$member' => NULL, ], ], 'MeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'BarChartAggregatedFieldWells$Values' => '<p>The value field wells of a bar chart. Values are aggregated by category.</p>', 'ComboChartAggregatedFieldWells$BarValues' => '<p>The aggregated <code>BarValues</code> field well of a combo chart.</p>', 'ComboChartAggregatedFieldWells$LineValues' => '<p>The aggregated <code>LineValues</code> field well of a combo chart.</p>', 'GaugeChartFieldWells$Values' => '<p>The value field wells of a <code>GaugeChartVisual</code>.</p>', 'GaugeChartFieldWells$TargetValues' => '<p>The target value field wells of a <code>GaugeChartVisual</code>.</p>', 'GeospatialMapAggregatedFieldWells$Values' => '<p>The size field wells of a geospatial map. Values are aggregated based on geospatial fields.</p>', 'KPIFieldWells$Values' => '<p>The value field wells of a KPI visual.</p>', 'KPIFieldWells$TargetValues' => '<p>The target value field wells of a KPI visual.</p>', 'LineChartAggregatedFieldWells$Values' => '<p>The value field wells of a line chart. Values are aggregated based on categories.</p>', 'PieChartAggregatedFieldWells$Values' => '<p>The value field wells of a pie chart. Values are aggregated based on categories.</p>', 'SankeyDiagramAggregatedFieldWells$Weight' => '<p>The weight field wells of a sankey diagram.</p>', 'ScatterPlotCategoricallyAggregatedFieldWells$XAxis' => '<p>The x-axis field well of a scatter plot.</p> <p>The x-axis is aggregated by category.</p>', 'ScatterPlotCategoricallyAggregatedFieldWells$YAxis' => '<p>The y-axis field well of a scatter plot.</p> <p>The y-axis is aggregated by category.</p>', 'ScatterPlotCategoricallyAggregatedFieldWells$Size' => '<p>The size field well of a scatter plot.</p>', 'ScatterPlotUnaggregatedFieldWells$Size' => '<p>The size field well of a scatter plot.</p>', 'TableAggregatedFieldWells$Values' => '<p>The values field well for a pivot table. Values are aggregated based on group by fields.</p>', 'WaterfallChartAggregatedFieldWells$Values' => '<p>The value field wells of a waterfall visual.</p>', ], ], 'MemberIdArnPair' => [ 'base' => '<p>An object that consists of a member Amazon Resource Name (ARN) and a member ID.</p>', 'refs' => [ 'FolderMemberList$member' => NULL, ], ], 'MemberType' => [ 'base' => NULL, 'refs' => [ 'CreateFolderMembershipRequest$MemberType' => '<p>The member type of the asset that you want to add to a folder.</p>', 'DeleteFolderMembershipRequest$MemberType' => '<p>The member type of the asset that you want to delete from a folder.</p>', 'FolderMember$MemberType' => '<p>The type of asset that it is.</p>', ], ], 'MetricComparisonComputation' => [ 'base' => '<p>The metric comparison computation configuration.</p>', 'refs' => [ 'Computation$MetricComparison' => '<p>The metric comparison computation configuration.</p>', ], ], 'MinimumLabelType' => [ 'base' => '<p>The minimum label of a data path label.</p>', 'refs' => [ 'DataLabelType$MinimumLabelType' => '<p>Determines the label configuration for the minimum value in a visual.</p>', ], ], 'MissingDataConfiguration' => [ 'base' => '<p>The configuration options that determine how missing data is treated during the rendering of a line chart.</p>', 'refs' => [ 'MissingDataConfigurationList$member' => NULL, ], ], 'MissingDataConfigurationList' => [ 'base' => NULL, 'refs' => [ 'LineSeriesAxisDisplayOptions$MissingDataConfigurations' => '<p>The configuration options that determine how missing data is treated during the rendering of a line chart.</p>', ], ], 'MissingDataTreatmentOption' => [ 'base' => NULL, 'refs' => [ 'MissingDataConfiguration$TreatmentOption' => '<p>The treatment option that determines how missing data should be rendered. Choose from the following options:</p> <ul> <li> <p> <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.</p> </li> <li> <p> <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.</p> </li> <li> <p> <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.</p> </li> </ul>', ], ], 'MySqlParameters' => [ 'base' => '<p>The parameters for MySQL.</p>', 'refs' => [ 'DataSourceParameters$MySqlParameters' => '<p>The parameters for MySQL.</p>', ], ], 'NamedEntityAggType' => [ 'base' => NULL, 'refs' => [ 'NamedEntityDefinitionMetric$Aggregation' => '<p>The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>, <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and <code>CUSTOM</code>.</p>', ], ], 'NamedEntityDefinition' => [ 'base' => '<p>A structure that represents a named entity.</p>', 'refs' => [ 'NamedEntityDefinitions$member' => NULL, ], ], 'NamedEntityDefinitionMetric' => [ 'base' => '<p>A structure that represents a metric.</p>', 'refs' => [ 'NamedEntityDefinition$Metric' => '<p>The definition of a metric.</p>', ], ], 'NamedEntityDefinitions' => [ 'base' => NULL, 'refs' => [ 'TopicNamedEntity$Definition' => '<p>The definition of a named entity.</p>', ], ], 'NamedEntityRef' => [ 'base' => '<p>The definition for a <code>NamedEntityRef</code>.</p>', 'refs' => [ 'TopicIRGroupBy$NamedEntity' => '<p>The named entity for the <code>TopicIRGroupBy</code>.</p>', 'TopicIRMetric$NamedEntity' => '<p>The named entity for the <code>TopicIRMetric</code>.</p>', ], ], 'NamedFilterAggType' => [ 'base' => NULL, 'refs' => [ 'TopicNumericEqualityFilter$Aggregation' => '<p>An aggregation function that specifies how to calculate the value of a numeric field for a topic. Valid values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.</p>', 'TopicNumericRangeFilter$Aggregation' => '<p>An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid values for this structure are <code>NO_AGGREGATION</code>, <code>SUM</code>, <code>AVERAGE</code>, <code>COUNT</code>, <code>DISTINCT_COUNT</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>MIN</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, and <code>VARP</code>.</p>', ], ], 'NamedFilterType' => [ 'base' => NULL, 'refs' => [ 'TopicFilter$FilterType' => '<p>The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>, <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>, and <code>RELATIVE_DATE_FILTER</code>.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$DefaultNamespace' => '<p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>', 'CreateAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you want to add customizations to.</p>', 'CreateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization you\'re creating. </p>', 'CreateGroupMembershipRequest$Namespace' => '<p>The namespace that you want the user to be a part of.</p>', 'CreateGroupRequest$Namespace' => '<p>The namespace that you want the group to be a part of.</p>', 'CreateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'CreateNamespaceRequest$Namespace' => '<p>The name that you want to use to describe the new namespace.</p>', 'CreateNamespaceResponse$Name' => '<p>The name of the new namespace that you created.</p>', 'CreateRoleMembershipRequest$Namespace' => '<p>The namespace that the role belongs to.</p>', 'DeleteAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you\'re deleting the customizations from.</p>', 'DeleteGroupMembershipRequest$Namespace' => '<p>The namespace of the group that you want to remove a user from.</p>', 'DeleteGroupRequest$Namespace' => '<p>The namespace of the group that you want to delete.</p>', 'DeleteIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DeleteNamespaceRequest$Namespace' => '<p>The namespace that you want to delete.</p>', 'DeleteRoleCustomPermissionRequest$Namespace' => '<p>The namespace that includes the role.</p>', 'DeleteRoleMembershipRequest$Namespace' => '<p>The namespace that contains the role.</p>', 'DeleteUserByPrincipalIdRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DescribeAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>', 'DescribeAccountCustomizationResponse$Namespace' => '<p>The Amazon QuickSight namespace that you\'re describing. </p>', 'DescribeFolderPermissionsRequest$Namespace' => '<p>The namespace of the folder whose permissions you want described.</p>', 'DescribeFolderResolvedPermissionsRequest$Namespace' => '<p>The namespace of the folder whose permissions you want described.</p>', 'DescribeGroupMembershipRequest$Namespace' => '<p>The namespace that includes the group you are searching within.</p>', 'DescribeGroupRequest$Namespace' => '<p>The namespace of the group that you want described.</p>', 'DescribeIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DescribeNamespaceRequest$Namespace' => '<p>The namespace that you want to describe.</p>', 'DescribeRoleCustomPermissionRequest$Namespace' => '<p>The namespace that contains the role.</p>', 'DescribeUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'GenerateEmbedUrlForAnonymousUserRequest$Namespace' => '<p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>', 'GetDashboardEmbedUrlRequest$Namespace' => '<p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you\'re not using a custom namespace, set <code>Namespace = default</code>.</p>', 'ListGroupMembershipsRequest$Namespace' => '<p>The namespace of the group that you want a list of users from.</p>', 'ListGroupsRequest$Namespace' => '<p>The namespace that you want a list of groups from.</p>', 'ListIAMPolicyAssignmentsForUserRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'ListIAMPolicyAssignmentsRequest$Namespace' => '<p>The namespace for the assignments.</p>', 'ListRoleMembershipsRequest$Namespace' => '<p>The namespace that includes the role.</p>', 'ListUserGroupsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListUsersRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'NamespaceInfoV2$Name' => '<p>The name of the error.</p>', 'RegisterUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'RowLevelPermissionDataSet$Namespace' => '<p>The namespace associated with the dataset that contains permissions for RLS.</p>', 'SearchGroupsRequest$Namespace' => '<p>The namespace that you want to search.</p>', 'UpdateAccountCustomizationRequest$Namespace' => '<p>The namespace that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization that you\'re updating.</p>', 'UpdateAccountSettingsRequest$DefaultNamespace' => '<p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. IAM users that register for the first time with Amazon QuickSight provide an email address that becomes associated with the default namespace. </p>', 'UpdateGroupRequest$Namespace' => '<p>The namespace of the group that you want to update.</p>', 'UpdateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'UpdateRoleCustomPermissionRequest$Namespace' => '<p>The namespace that contains the role that you want to update.</p>', 'UpdateUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', ], ], 'NamespaceError' => [ 'base' => '<p>Errors that occur during namespace creation.</p>', 'refs' => [ 'NamespaceInfoV2$NamespaceError' => '<p>An error that occurred when the namespace was created.</p>', ], ], 'NamespaceErrorType' => [ 'base' => NULL, 'refs' => [ 'NamespaceError$Type' => '<p>The error type.</p>', ], ], 'NamespaceInfoV2' => [ 'base' => '<p>The error type.</p>', 'refs' => [ 'DescribeNamespaceResponse$Namespace' => '<p>The information about the namespace that you\'re describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>', 'Namespaces$member' => NULL, ], ], 'NamespaceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceResponse$CreationStatus' => '<p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>', 'NamespaceInfoV2$CreationStatus' => '<p>The creation status of a namespace that is not yet completely created.</p>', ], ], 'Namespaces' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesResponse$Namespaces' => '<p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>', ], ], 'NarrativeString' => [ 'base' => NULL, 'refs' => [ 'CustomNarrativeOptions$Narrative' => '<p>The string input of custom narrative.</p>', ], ], 'NegativeFormat' => [ 'base' => '<p>A structure that represents a negative format.</p>', 'refs' => [ 'DisplayFormatOptions$NegativeFormat' => '<p>The negative format.</p>', ], ], 'NegativeValueConfiguration' => [ 'base' => '<p>The options that determine the negative value configuration.</p>', 'refs' => [ 'CurrencyDisplayFormatConfiguration$NegativeValueConfiguration' => '<p>The options that determine the negative value configuration.</p>', 'NumberDisplayFormatConfiguration$NegativeValueConfiguration' => '<p>The options that determine the negative value configuration.</p>', 'PercentageDisplayFormatConfiguration$NegativeValueConfiguration' => '<p>The options that determine the negative value configuration.</p>', ], ], 'NegativeValueDisplayMode' => [ 'base' => NULL, 'refs' => [ 'NegativeValueConfiguration$DisplayMode' => '<p>Determines the display mode of the negative value configuration.</p>', ], ], 'NestedFilter' => [ 'base' => '<p>A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.</p>', 'refs' => [ 'Filter$NestedFilter' => '<p>A <code>NestedFilter</code> filters data with a subset of data that is defined by the nested inner filter.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>The structure that contains information about a network interface.</p>', 'refs' => [ 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$NetworkInterfaceId' => '<p>The network interface ID.</p>', ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'VPCConnection$NetworkInterfaces' => '<p>A list of network interfaces.</p>', 'VPCConnectionSummary$NetworkInterfaces' => '<p>A list of network interfaces.</p>', ], ], 'NetworkInterfaceStatus' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$Status' => '<p>The status of the network interface.</p>', ], ], 'NewDefaultValues' => [ 'base' => '<p>The configuration that overrides the existing default values for a dataset parameter that is inherited from another dataset.</p>', 'refs' => [ 'OverrideDatasetParameterOperation$NewDefaultValues' => '<p>The new default values for the parameter.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AnalysisError$Message' => '<p>The message associated with the analysis error.</p>', 'AssetBundleExportJobError$Type' => '<p>The specific error type of the error that occurred.</p>', 'AssetBundleExportJobError$Message' => '<p>A description of the error.</p>', 'AssetBundleExportJobWarning$Message' => '<p>A description of the warning.</p>', 'AssetBundleImportJobError$Type' => '<p>The specific error type or the error that occurred.</p>', 'AssetBundleImportJobError$Message' => '<p>A description of the error.</p>', 'AssetBundleImportJobWarning$Message' => '<p>A description of the warning that occurred during an Asset Bundle import job.</p>', 'DashboardError$Message' => '<p>Message.</p>', 'DataSetReference$DataSetPlaceholder' => '<p>Dataset placeholder.</p>', 'DateTimeParameter$Name' => '<p>A display name for the date-time parameter.</p>', 'DecimalParameter$Name' => '<p>A display name for the decimal parameter.</p>', 'DescribeAssetBundleExportJobResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAssetBundleImportJobResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardSnapshotJobResponse$RequestId' => '<p> The Amazon Web Services request ID for this operation. </p>', 'DescribeDashboardSnapshotJobResultResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeKeyRegistrationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'Entity$Path' => '<p>The hierarchical path of the entity within the analysis, template, or dashboard definition tree.</p>', 'FailedKeyRegistrationEntry$Message' => '<p>A message that provides information about why a <code>FailedKeyRegistrationEntry</code> error occurred.</p>', 'IntegerParameter$Name' => '<p>The name of the integer parameter.</p>', 'ListAssetBundleExportJobsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListAssetBundleImportJobsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ReferenceLineCustomLabelConfiguration$CustomLabel' => '<p>The string text of the custom label.</p>', 'S3BucketConfiguration$BucketName' => '<p>The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.</p>', 'S3BucketConfiguration$BucketPrefix' => '<p>The prefix of the Amazon S3 bucket that the generated snapshots are stored in.</p>', 'S3BucketConfiguration$BucketRegion' => '<p>The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that the <code>StartDashboardSnapshotJob</code> API call is made.</p>', 'StartAssetBundleExportJobResponse$RequestId' => '<p>The Amazon Web Services response ID for this operation.</p>', 'StartAssetBundleImportJobResponse$RequestId' => '<p>The Amazon Web Services response ID for this operation.</p>', 'StartDashboardSnapshotJobResponse$RequestId' => '<p> The Amazon Web Services request ID for this operation. </p>', 'StringParameter$Name' => '<p>A display name for a string parameter.</p>', 'TemplateError$Message' => '<p>Description of the error type.</p>', 'ThemeError$Message' => '<p>The error message.</p>', 'UpdateKeyRegistrationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', ], ], 'NonRepeatingVisualsList' => [ 'base' => NULL, 'refs' => [ 'BodySectionRepeatConfiguration$NonRepeatingVisuals' => '<p>List of visuals to exclude from repetition in repeating sections. The visuals will render identically, and ignore the repeating configurations in all repeating instances.</p>', ], ], 'NullFilterOption' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterOption$NullFilter' => '<p>The null filter for the <code>TopicIRFilterOption</code>.</p>', ], ], 'NullString' => [ 'base' => NULL, 'refs' => [ 'NullValueFormatConfiguration$NullString' => '<p>Determines the null string of null values.</p>', ], ], 'NullValueFormatConfiguration' => [ 'base' => '<p>The options that determine the null value format configuration.</p>', 'refs' => [ 'CurrencyDisplayFormatConfiguration$NullValueFormatConfiguration' => '<p>The options that determine the null value format configuration.</p>', 'DateTimeFormatConfiguration$NullValueFormatConfiguration' => '<p>The options that determine the null value format configuration.</p>', 'NumberDisplayFormatConfiguration$NullValueFormatConfiguration' => '<p>The options that determine the null value format configuration.</p>', 'PercentageDisplayFormatConfiguration$NullValueFormatConfiguration' => '<p>The options that determine the null value format configuration.</p>', 'StringFormatConfiguration$NullValueFormatConfiguration' => '<p>The options that determine the null value format configuration.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'DescribeIpRestrictionResponse$Enabled' => '<p>A value that specifies whether IP rules are turned on.</p>', 'TopicCalculatedField$DisableIndexing' => '<p>A Boolean value that indicates if a calculated field is visible in the autocomplete.</p>', 'TopicCalculatedField$NonAdditive' => '<p>The non additive for the table style target.</p>', 'TopicColumn$DisableIndexing' => '<p>A Boolean value that indicates whether the column shows in the autocomplete functionality.</p>', 'TopicColumn$NonAdditive' => '<p>The non additive value for the column.</p>', 'TopicRefreshSchedule$IsEnabled' => '<p>A Boolean value that controls whether to schedule is enabled.</p>', 'UpdateIpRestrictionRequest$Enabled' => '<p>A value that specifies whether IP rules are turned on.</p>', ], ], 'NumberDisplayFormatConfiguration' => [ 'base' => '<p>The options that determine the number display format configuration.</p>', 'refs' => [ 'ComparisonFormatConfiguration$NumberDisplayFormatConfiguration' => '<p>The number display format.</p>', 'NumericFormatConfiguration$NumberDisplayFormatConfiguration' => '<p>The options that determine the number display format configuration.</p>', ], ], 'NumberFormatConfiguration' => [ 'base' => '<p>Formatting configuration for number fields.</p>', 'refs' => [ 'FormatConfiguration$NumberFormatConfiguration' => '<p>Formatting configuration for number fields.</p>', 'NumericalDimensionField$FormatConfiguration' => '<p>The format configuration of the field.</p>', 'NumericalMeasureField$FormatConfiguration' => '<p>The format configuration of the field.</p>', ], ], 'NumberScale' => [ 'base' => NULL, 'refs' => [ 'CurrencyDisplayFormatConfiguration$NumberScale' => '<p>Determines the number scale value for the currency format.</p>', 'DisplayFormatOptions$UnitScaler' => '<p>The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>, <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.</p>', 'NumberDisplayFormatConfiguration$NumberScale' => '<p>Determines the number scale value of the number format.</p>', ], ], 'NumericAxisOptions' => [ 'base' => '<p>The options for an axis with a numeric field.</p>', 'refs' => [ 'AxisDataOptions$NumericAxisOptions' => '<p>The options for an axis with a numeric field.</p>', ], ], 'NumericEqualityDrillDownFilter' => [ 'base' => '<p>The numeric equality type drill down filter.</p>', 'refs' => [ 'DrillDownFilter$NumericEqualityFilter' => '<p>The numeric equality type drill down filter. This filter is used for number type columns.</p>', ], ], 'NumericEqualityFilter' => [ 'base' => '<p>A <code>NumericEqualityFilter</code> filters values that are equal to the specified value.</p>', 'refs' => [ 'Filter$NumericEqualityFilter' => '<p>A <code>NumericEqualityFilter</code> filters numeric values that equal or do not equal a given numeric value.</p>', ], ], 'NumericEqualityMatchOperator' => [ 'base' => NULL, 'refs' => [ 'NumericEqualityFilter$MatchOperator' => '<p>The match operator that is used to determine if a filter should be applied.</p>', ], ], 'NumericFilterSelectAllOptions' => [ 'base' => NULL, 'refs' => [ 'NumericEqualityFilter$SelectAllOptions' => '<p>Select all of the values. Null is not the assigned value of select all.</p> <ul> <li> <p> <code>FILTER_ALL_VALUES</code> </p> </li> </ul>', 'NumericRangeFilter$SelectAllOptions' => '<p>Select all of the values. Null is not the assigned value of select all.</p> <ul> <li> <p> <code>FILTER_ALL_VALUES</code> </p> </li> </ul>', ], ], 'NumericFormatConfiguration' => [ 'base' => '<p>The options that determine the numeric format configuration.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'DateTimeFormatConfiguration$NumericFormatConfiguration' => '<p>The formatting configuration for numeric <code>DateTime</code> fields.</p>', 'NumberFormatConfiguration$FormatConfiguration' => '<p>The options that determine the numeric format configuration.</p>', 'ReferenceLineValueLabelConfiguration$FormatConfiguration' => '<p>The format configuration of the value label.</p>', 'StringFormatConfiguration$NumericFormatConfiguration' => '<p>The formatting configuration for numeric strings.</p>', ], ], 'NumericRangeFilter' => [ 'base' => '<p>A <code>NumericRangeFilter</code> filters values that are within the value range.</p>', 'refs' => [ 'Filter$NumericRangeFilter' => '<p>A <code>NumericRangeFilter</code> filters numeric values that are either inside or outside a given numeric range.</p>', ], ], 'NumericRangeFilterValue' => [ 'base' => '<p>The value input pf the numeric range filter.</p>', 'refs' => [ 'NumericRangeFilter$RangeMinimum' => '<p>The minimum value for the filter value range.</p>', 'NumericRangeFilter$RangeMaximum' => '<p>The maximum value for the filter value range.</p>', ], ], 'NumericSeparatorConfiguration' => [ 'base' => '<p>The options that determine the numeric separator configuration.</p>', 'refs' => [ 'CurrencyDisplayFormatConfiguration$SeparatorConfiguration' => '<p>The options that determine the numeric separator configuration.</p>', 'NumberDisplayFormatConfiguration$SeparatorConfiguration' => '<p>The options that determine the numeric separator configuration.</p>', 'PercentageDisplayFormatConfiguration$SeparatorConfiguration' => '<p>The options that determine the numeric separator configuration.</p>', ], ], 'NumericSeparatorSymbol' => [ 'base' => NULL, 'refs' => [ 'NumericSeparatorConfiguration$DecimalSeparator' => '<p>Determines the decimal separator.</p>', 'ThousandSeparatorOptions$Symbol' => '<p>Determines the thousands separator symbol.</p>', ], ], 'NumericalAggregationFunction' => [ 'base' => '<p>Aggregation for numerical values.</p>', 'refs' => [ 'AggregationFunction$NumericalAggregationFunction' => '<p>Aggregation for numerical values.</p>', 'NumericalMeasureField$AggregationFunction' => '<p>The aggregation function of the measure field.</p>', 'ReferenceLineDynamicDataConfiguration$Calculation' => '<p>The calculation that is used in the dynamic data.</p>', ], ], 'NumericalDimensionField' => [ 'base' => '<p>The dimension type field with numerical type columns.</p>', 'refs' => [ 'DimensionField$NumericalDimensionField' => '<p>The dimension type field with numerical type columns.</p>', ], ], 'NumericalMeasureField' => [ 'base' => '<p>The measure type field with numerical type columns.</p>', 'refs' => [ 'MeasureField$NumericalMeasureField' => '<p>The measure type field with numerical type columns.</p>', ], ], 'OnClause' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$OnClause' => '<p>The join instructions provided in the <code>ON</code> clause of a join.</p>', ], ], 'OperandList' => [ 'base' => NULL, 'refs' => [ 'TopicIRMetric$Operands' => '<p>The operands for the <code>TopicIRMetric</code>.</p>', ], ], 'OptionalPort' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$Port' => '<p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>', ], ], 'OracleParameters' => [ 'base' => '<p>The parameters for Oracle.</p>', 'refs' => [ 'DataSourceParameters$OracleParameters' => '<p>The parameters for Oracle.</p>', ], ], 'OtherCategories' => [ 'base' => NULL, 'refs' => [ 'ItemsLimitConfiguration$OtherCategories' => '<p>The <code>Show other</code> of an axis in the chart. Choose one of the following options:</p> <ul> <li> <p> <code>INCLUDE</code> </p> </li> <li> <p> <code>EXCLUDE</code> </p> </li> </ul>', ], ], 'OutputColumn' => [ 'base' => '<p>Output column.</p>', 'refs' => [ 'OutputColumnList$member' => NULL, ], ], 'OutputColumnList' => [ 'base' => NULL, 'refs' => [ 'DataSet$OutputColumns' => '<p>The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.</p>', ], ], 'OverrideDatasetParameterOperation' => [ 'base' => '<p>A transform operation that overrides the dataset parameter values that are defined in another dataset.</p>', 'refs' => [ 'TransformOperation$OverrideDatasetParameterOperation' => NULL, ], ], 'PageNumber' => [ 'base' => NULL, 'refs' => [ 'PaginationConfiguration$PageNumber' => '<p>Indicates the page number.</p>', ], ], 'PaginationConfiguration' => [ 'base' => '<p>The pagination configuration for a table visual or boxplot.</p>', 'refs' => [ 'BoxPlotSortConfiguration$PaginationConfiguration' => '<p>The pagination configuration of a table visual or box plot.</p>', 'TableSortConfiguration$PaginationConfiguration' => '<p>The pagination configuration (page size, page number) for the table.</p>', ], ], 'PanelBorderStyle' => [ 'base' => NULL, 'refs' => [ 'PanelConfiguration$BorderStyle' => '<p>Sets the line style of panel borders.</p>', ], ], 'PanelConfiguration' => [ 'base' => '<p>A collection of options that configure how each panel displays in a small multiples chart.</p>', 'refs' => [ 'SmallMultiplesOptions$PanelConfiguration' => '<p>Configures the display options for each small multiples panel.</p>', ], ], 'PanelTitleOptions' => [ 'base' => '<p>The options that determine the title styles for each small multiples panel.</p>', 'refs' => [ 'PanelConfiguration$Title' => '<p>Configures the title display within each small multiples panel.</p>', ], ], 'PaperOrientation' => [ 'base' => NULL, 'refs' => [ 'SectionBasedLayoutPaperCanvasSizeOptions$PaperOrientation' => '<p>The paper orientation that is used to define canvas dimensions. Choose one of the following options:</p> <ul> <li> <p>PORTRAIT</p> </li> <li> <p>LANDSCAPE</p> </li> </ul>', ], ], 'PaperSize' => [ 'base' => NULL, 'refs' => [ 'SectionBasedLayoutPaperCanvasSizeOptions$PaperSize' => '<p>The paper size that is used to define canvas dimensions.</p>', ], ], 'ParameterControl' => [ 'base' => '<p>The control of a parameter that users can interact with in a dashboard or an analysis.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ParameterControlList$member' => NULL, ], ], 'ParameterControlList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$ParameterControls' => '<p>The list of parameter controls that are on a sheet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'ParameterDateTimePickerControl' => [ 'base' => '<p>A control from a date parameter that specifies date and time.</p>', 'refs' => [ 'ParameterControl$DateTimePicker' => '<p>A control from a date parameter that specifies date and time.</p>', ], ], 'ParameterDeclaration' => [ 'base' => '<p>The declaration definition of a parameter.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ParameterDeclarationList$member' => NULL, ], ], 'ParameterDeclarationList' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$ParameterDeclarations' => '<p>An array of parameter declarations for an analysis.</p> <p>Parameters are named variables that can transfer a value for use by an action or an object.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'DashboardVersionDefinition$ParameterDeclarations' => '<p>The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for use by an action or an object.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'TemplateVersionDefinition$ParameterDeclarations' => '<p>An array of parameter declarations for a template.</p> <p> <i>Parameters</i> are named variables that can transfer a value for use by an action or an object.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>. </p>', ], ], 'ParameterDropDownControl' => [ 'base' => '<p>A control to display a dropdown list with buttons that are used to select a single value.</p>', 'refs' => [ 'ParameterControl$Dropdown' => '<p>A control to display a dropdown list with buttons that are used to select a single value.</p>', ], ], 'ParameterListControl' => [ 'base' => '<p>A control to display a list with buttons or boxes that are used to select either a single value or multiple values.</p>', 'refs' => [ 'ParameterControl$List' => '<p>A control to display a list with buttons or boxes that are used to select either a single value or multiple values.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'AnchorDateConfiguration$ParameterName' => '<p>The name of the parameter that is used for the anchor date configuration.</p>', 'CustomFilterConfiguration$ParameterName' => '<p>The parameter whose value should be used for the filter value.</p> <p>This field is mutually exclusive to <code>CategoryValue</code>.</p>', 'DateTimeParameterDeclaration$Name' => '<p>The name of the parameter that is being declared.</p>', 'DecimalParameterDeclaration$Name' => '<p>The name of the parameter that is being declared.</p>', 'IntegerParameterDeclaration$Name' => '<p>The name of the parameter that is being declared.</p>', 'MappedDataSetParameter$DataSetParameterName' => '<p>The name of the dataset parameter.</p>', 'NumericEqualityFilter$ParameterName' => '<p>The parameter whose value should be used for the filter value.</p>', 'NumericRangeFilterValue$Parameter' => '<p>The parameter that is used in the numeric range.</p>', 'ParameterDateTimePickerControl$SourceParameterName' => '<p>The name of the <code>ParameterDateTimePickerControl</code>.</p>', 'ParameterDropDownControl$SourceParameterName' => '<p>The source parameter name of the <code>ParameterDropDownControl</code>.</p>', 'ParameterListControl$SourceParameterName' => '<p>The source parameter name of the <code>ParameterListControl</code>.</p>', 'ParameterSliderControl$SourceParameterName' => '<p>The source parameter name of the <code>ParameterSliderControl</code>.</p>', 'ParameterTextAreaControl$SourceParameterName' => '<p>The source parameter name of the <code>ParameterTextAreaControl</code>.</p>', 'ParameterTextFieldControl$SourceParameterName' => '<p>The source parameter name of the <code>ParameterTextFieldControl</code>.</p>', 'RelativeDatesFilter$ParameterName' => '<p>The parameter whose value should be used for the filter value.</p>', 'SetParameterValueConfiguration$DestinationParameterName' => '<p>The destination parameter name of the <code>SetParameterValueConfiguration</code>.</p>', 'StringParameterDeclaration$Name' => '<p>The name of the parameter that is being declared.</p>', 'TimeEqualityFilter$ParameterName' => '<p>The parameter whose value should be used for the filter value.</p> <p>This field is mutually exclusive to <code>Value</code> and <code>RollingDate</code>.</p>', 'TimeRangeFilterValue$Parameter' => '<p>The parameter type input value.</p>', 'TopBottomFilter$ParameterName' => '<p>The parameter whose value should be used for the filter value.</p>', ], ], 'ParameterSelectableValueList' => [ 'base' => NULL, 'refs' => [ 'FilterSelectableValues$Values' => '<p>The values that are used in the <code>FilterSelectableValues</code>.</p>', 'ParameterSelectableValues$Values' => '<p>The values that are used in <code>ParameterSelectableValues</code>.</p>', ], ], 'ParameterSelectableValues' => [ 'base' => '<p>A list of selectable values that are used in a control.</p>', 'refs' => [ 'ParameterDropDownControl$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', 'ParameterListControl$SelectableValues' => '<p>A list of selectable values that are used in a control.</p>', ], ], 'ParameterSliderControl' => [ 'base' => '<p>A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.</p>', 'refs' => [ 'ParameterControl$Slider' => '<p>A control to display a horizontal toggle bar. This is used to change a value by sliding the toggle.</p>', ], ], 'ParameterTextAreaControl' => [ 'base' => '<p>A control to display a text box that is used to enter multiple entries.</p>', 'refs' => [ 'ParameterControl$TextArea' => '<p>A control to display a text box that is used to enter multiple entries.</p>', ], ], 'ParameterTextFieldControl' => [ 'base' => '<p>A control to display a text box that is used to enter a single entry.</p>', 'refs' => [ 'ParameterControl$TextField' => '<p>A control to display a text box that is used to enter a single entry.</p>', ], ], 'ParameterValueType' => [ 'base' => NULL, 'refs' => [ 'DecimalParameterDeclaration$ParameterValueType' => '<p>The value type determines whether the parameter is a single-value or multi-value parameter.</p>', 'IntegerParameterDeclaration$ParameterValueType' => '<p>The value type determines whether the parameter is a single-value or multi-value parameter.</p>', 'StringParameterDeclaration$ParameterValueType' => '<p>The value type determines whether the parameter is a single-value or multi-value parameter.</p>', ], ], 'Parameters' => [ 'base' => '<p>A list of Amazon QuickSight parameters and the list\'s override values.</p>', 'refs' => [ 'CreateAnalysisRequest$Parameters' => '<p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>', 'CreateDashboardRequest$Parameters' => '<p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>', 'SnapshotConfiguration$Parameters' => NULL, 'UpdateAnalysisRequest$Parameters' => '<p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>', 'UpdateDashboardRequest$Parameters' => '<p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobDataSourceCredentialPair$Password' => '<p>The password for the data source connection.</p>', 'CredentialPair$Password' => '<p>Password.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'Folder$FolderPath' => '<p>An array of ancestor ARN strings for the folder.</p>', ], ], 'PercentNumber' => [ 'base' => NULL, 'refs' => [ 'PercentVisibleRange$From' => '<p>The lower bound of the range.</p>', 'PercentVisibleRange$To' => '<p>The top bound of the range.</p>', ], ], 'PercentVisibleRange' => [ 'base' => '<p>The percent range in the visible range.</p>', 'refs' => [ 'VisibleRangeOptions$PercentRange' => '<p>The percent range in the visible range.</p>', ], ], 'PercentageDisplayFormatConfiguration' => [ 'base' => '<p>The options that determine the percentage display format configuration.</p>', 'refs' => [ 'ComparisonFormatConfiguration$PercentageDisplayFormatConfiguration' => '<p>The percentage display format.</p>', 'NumericFormatConfiguration$PercentageDisplayFormatConfiguration' => '<p>The options that determine the percentage display format configuration.</p>', ], ], 'PercentileAggregation' => [ 'base' => '<p>An aggregation based on the percentile of values in a dimension or measure.</p>', 'refs' => [ 'NumericalAggregationFunction$PercentileAggregation' => '<p>An aggregation based on the percentile of values in a dimension or measure.</p>', ], ], 'PercentileValue' => [ 'base' => NULL, 'refs' => [ 'PercentileAggregation$PercentileValue' => '<p>The percentile value. This value can be any numeric constant 0–100. A percentile value of 50 computes the median value of the measure.</p>', ], ], 'PeriodOverPeriodComputation' => [ 'base' => '<p>The period over period computation configuration.</p>', 'refs' => [ 'Computation$PeriodOverPeriod' => '<p>The period over period computation configuration.</p>', ], ], 'PeriodToDateComputation' => [ 'base' => '<p>The period to date computation configuration.</p>', 'refs' => [ 'Computation$PeriodToDate' => '<p>The period to <code>DataSetIdentifier</code> computation configuration.</p>', ], ], 'PeriodsBackward' => [ 'base' => NULL, 'refs' => [ 'ForecastComputation$PeriodsBackward' => '<p>The periods backward setup of a forecast computation.</p>', 'TimeBasedForecastProperties$PeriodsBackward' => '<p>The periods backward setup of a forecast computation.</p>', ], ], 'PeriodsForward' => [ 'base' => NULL, 'refs' => [ 'ForecastComputation$PeriodsForward' => '<p>The periods forward setup of a forecast computation.</p>', 'TimeBasedForecastProperties$PeriodsForward' => '<p>The periods forward setup of a forecast computation.</p>', ], ], 'PhysicalTable' => [ 'base' => '<p>A view of a data source that contains information about the shape of the data in the underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'PhysicalTableMap$value' => NULL, ], ], 'PhysicalTableId' => [ 'base' => NULL, 'refs' => [ 'LogicalTableSource$PhysicalTableId' => '<p>Physical table ID.</p>', 'PhysicalTableMap$key' => NULL, ], ], 'PhysicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'DataSet$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'UpdateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', ], ], 'PieChartAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a pie chart.</p>', 'refs' => [ 'PieChartFieldWells$PieChartAggregatedFieldWells' => '<p>The field well configuration of a pie chart.</p>', ], ], 'PieChartConfiguration' => [ 'base' => '<p>The configuration of a pie chart.</p>', 'refs' => [ 'PieChartVisual$ChartConfiguration' => '<p>The configuration of a pie chart.</p>', ], ], 'PieChartFieldWells' => [ 'base' => '<p>The field well configuration of a pie chart.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'PieChartConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'PieChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a pie chart.</p>', 'refs' => [ 'PieChartConfiguration$SortConfiguration' => '<p>The sort configuration of a pie chart.</p>', ], ], 'PieChartVisual' => [ 'base' => '<p>A pie or donut chart.</p> <p>The <code>PieChartVisual</code> structure describes a visual that is a member of the pie chart family.</p> <p>The following charts can be described by using this structure:</p> <ul> <li> <p>Pie charts</p> </li> <li> <p>Donut charts</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using pie charts</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/donut-chart.html">Using donut charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$PieChartVisual' => '<p>A pie or donut chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using pie charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'PivotFieldSortOptions' => [ 'base' => '<p>The field sort options for a pivot table sort configuration.</p>', 'refs' => [ 'PivotFieldSortOptionsList$member' => NULL, ], ], 'PivotFieldSortOptionsList' => [ 'base' => NULL, 'refs' => [ 'PivotTableSortConfiguration$FieldSortOptions' => '<p>The field sort options for a pivot table sort configuration.</p>', ], ], 'PivotMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'PivotTableAggregatedFieldWells$Values' => '<p>The values field well for a pivot table. Values are aggregated based on rows and columns fields.</p>', ], ], 'PivotTableAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well for the pivot table.</p>', 'refs' => [ 'PivotTableFieldWells$PivotTableAggregatedFieldWells' => '<p>The aggregated field well for the pivot table.</p>', ], ], 'PivotTableCellConditionalFormatting' => [ 'base' => '<p>The cell conditional formatting option for a pivot table.</p>', 'refs' => [ 'PivotTableConditionalFormattingOption$Cell' => '<p>The cell conditional formatting option for a pivot table.</p>', ], ], 'PivotTableConditionalFormatting' => [ 'base' => '<p>The conditional formatting for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'PivotTableVisual$ConditionalFormatting' => '<p>The conditional formatting for a <code>PivotTableVisual</code>.</p>', ], ], 'PivotTableConditionalFormattingOption' => [ 'base' => '<p>Conditional formatting options for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'PivotTableConditionalFormattingOptionList$member' => NULL, ], ], 'PivotTableConditionalFormattingOptionList' => [ 'base' => NULL, 'refs' => [ 'PivotTableConditionalFormatting$ConditionalFormattingOptions' => '<p>Conditional formatting options for a <code>PivotTableVisual</code>.</p>', ], ], 'PivotTableConditionalFormattingScope' => [ 'base' => '<p>The scope of the cell for conditional formatting.</p>', 'refs' => [ 'PivotTableCellConditionalFormatting$Scope' => '<p>The scope of the cell for conditional formatting.</p>', 'PivotTableConditionalFormattingScopeList$member' => NULL, ], ], 'PivotTableConditionalFormattingScopeList' => [ 'base' => NULL, 'refs' => [ 'PivotTableCellConditionalFormatting$Scopes' => '<p>A list of cell scopes for conditional formatting.</p>', ], ], 'PivotTableConditionalFormattingScopeRole' => [ 'base' => NULL, 'refs' => [ 'PivotTableConditionalFormattingScope$Role' => '<p>The role (field, field total, grand total) of the cell for conditional formatting.</p>', ], ], 'PivotTableConfiguration' => [ 'base' => '<p>The configuration for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'PivotTableVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'PivotTableDataPathOption' => [ 'base' => '<p>The data path options for the pivot table field options.</p>', 'refs' => [ 'PivotTableDataPathOptionList$member' => NULL, ], ], 'PivotTableDataPathOptionList' => [ 'base' => NULL, 'refs' => [ 'PivotTableFieldOptions$DataPathOptions' => '<p>The data path options for the pivot table field options.</p>', ], ], 'PivotTableDataPathType' => [ 'base' => NULL, 'refs' => [ 'DataPathType$PivotTableDataPathType' => '<p>The type of data path value utilized in a pivot table. Choose one of the following options:</p> <ul> <li> <p> <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when <code>RowsLayout</code> is set to <code>HIERARCHY</code>.</p> </li> <li> <p> <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is set to Metric Placement.</p> </li> <li> <p> <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when there is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.</p> </li> <li> <p> <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the metric, when there is no field in the <code>ValuesFieldWell</code>.</p> </li> </ul>', ], ], 'PivotTableDimensionList' => [ 'base' => NULL, 'refs' => [ 'PivotTableAggregatedFieldWells$Rows' => '<p>The rows field well for a pivot table. Values are grouped by rows fields.</p>', 'PivotTableAggregatedFieldWells$Columns' => '<p>The columns field well for a pivot table. Values are grouped by columns fields.</p>', ], ], 'PivotTableFieldCollapseState' => [ 'base' => NULL, 'refs' => [ 'PivotTableFieldCollapseStateOption$State' => '<p>The state of the field target of a pivot table. Choose one of the following options:</p> <ul> <li> <p> <code>COLLAPSED</code> </p> </li> <li> <p> <code>EXPANDED</code> </p> </li> </ul>', ], ], 'PivotTableFieldCollapseStateOption' => [ 'base' => '<p>The collapse state options for the pivot table field options.</p>', 'refs' => [ 'PivotTableFieldCollapseStateOptionList$member' => NULL, ], ], 'PivotTableFieldCollapseStateOptionList' => [ 'base' => NULL, 'refs' => [ 'PivotTableFieldOptions$CollapseStateOptions' => '<p>The collapse state options for the pivot table field options.</p>', ], ], 'PivotTableFieldCollapseStateTarget' => [ 'base' => '<p>The target of a pivot table field collapse state.</p>', 'refs' => [ 'PivotTableFieldCollapseStateOption$Target' => '<p>A tagged-union object that sets the collapse state.</p>', ], ], 'PivotTableFieldOption' => [ 'base' => '<p>The selected field options for the pivot table field options.</p>', 'refs' => [ 'PivotTableFieldOptionList$member' => NULL, ], ], 'PivotTableFieldOptionList' => [ 'base' => NULL, 'refs' => [ 'PivotTableFieldOptions$SelectedFieldOptions' => '<p>The selected field options for the pivot table field options.</p>', ], ], 'PivotTableFieldOptions' => [ 'base' => '<p>The field options for a pivot table visual.</p>', 'refs' => [ 'PivotTableConfiguration$FieldOptions' => '<p>The field options for a pivot table visual.</p>', ], ], 'PivotTableFieldSubtotalOptions' => [ 'base' => '<p>The optional configuration of subtotals cells.</p>', 'refs' => [ 'PivotTableFieldSubtotalOptionsList$member' => NULL, ], ], 'PivotTableFieldSubtotalOptionsList' => [ 'base' => NULL, 'refs' => [ 'SubtotalOptions$FieldLevelOptions' => '<p>The optional configuration of subtotal cells.</p>', ], ], 'PivotTableFieldWells' => [ 'base' => '<p>The field wells for a pivot table visual.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'PivotTableConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'PivotTableMetricPlacement' => [ 'base' => NULL, 'refs' => [ 'PivotTableOptions$MetricPlacement' => '<p>The metric placement (row, column) options.</p>', ], ], 'PivotTableOptions' => [ 'base' => '<p>The table options for a pivot table visual.</p>', 'refs' => [ 'PivotTableConfiguration$TableOptions' => '<p>The table options for a pivot table visual.</p>', ], ], 'PivotTablePaginatedReportOptions' => [ 'base' => '<p>The paginated report options for a pivot table visual.</p>', 'refs' => [ 'PivotTableConfiguration$PaginatedReportOptions' => '<p>The paginated report options for a pivot table visual.</p>', ], ], 'PivotTableRowsLabelOptions' => [ 'base' => '<p>The options for the label thta is located above the row headers. This option is only applicable when <code>RowsLayout</code> is set to <code>HIERARCHY</code>.</p>', 'refs' => [ 'PivotTableOptions$RowsLabelOptions' => '<p>The options for the label that is located above the row headers. This option is only applicable when <code>RowsLayout</code> is set to <code>HIERARCHY</code>.</p>', ], ], 'PivotTableRowsLabelText' => [ 'base' => NULL, 'refs' => [ 'PivotTableRowsLabelOptions$CustomLabel' => '<p>The custom label string for the rows label.</p>', ], ], 'PivotTableRowsLayout' => [ 'base' => NULL, 'refs' => [ 'PivotTableOptions$RowsLayout' => '<p>The layout for the row dimension headers of a pivot table. Choose one of the following options.</p> <ul> <li> <p> <code>TABULAR</code>: (Default) Each row field is displayed in a separate column.</p> </li> <li> <p> <code>HIERARCHY</code>: All row fields are displayed in a single column. Indentation is used to differentiate row headers of different fields.</p> </li> </ul>', ], ], 'PivotTableSortBy' => [ 'base' => '<p>The sort by field for the field sort options.</p>', 'refs' => [ 'PivotFieldSortOptions$SortBy' => '<p>The sort by field for the field sort options.</p>', ], ], 'PivotTableSortConfiguration' => [ 'base' => '<p>The sort configuration for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'PivotTableConfiguration$SortConfiguration' => '<p>The sort configuration for a <code>PivotTableVisual</code>.</p>', ], ], 'PivotTableSubtotalLevel' => [ 'base' => NULL, 'refs' => [ 'SubtotalOptions$FieldLevel' => '<p>The field level (all, custom, last) for the subtotal cells.</p>', ], ], 'PivotTableTotalOptions' => [ 'base' => '<p>The total options for a pivot table visual.</p>', 'refs' => [ 'PivotTableConfiguration$TotalOptions' => '<p>The total options for a pivot table visual.</p>', ], ], 'PivotTableVisual' => [ 'base' => '<p>A pivot table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using pivot tables</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$PivotTableVisual' => '<p>A pivot table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using pivot tables</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'PivotTotalOptions' => [ 'base' => '<p>The optional configuration of totals cells in a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'PivotTableTotalOptions$RowTotalOptions' => '<p>The row total options.</p>', 'PivotTableTotalOptions$ColumnTotalOptions' => '<p>The column total options.</p>', ], ], 'PixelLength' => [ 'base' => 'String based length that is composed of value and unit in px', 'refs' => [ 'AxisDisplayOptions$AxisOffset' => '<p>The offset value that determines the starting placement of the axis within a visual\'s bounds.</p>', 'FreeFormLayoutElement$XAxisLocation' => '<p>The x-axis coordinate of the element.</p>', 'FreeFormLayoutElement$Width' => '<p>The width of an element within a free-form layout.</p>', 'FreeFormLayoutElement$Height' => '<p>The height of an element within a free-form layout.</p>', 'FreeFormLayoutScreenCanvasSizeOptions$OptimizedViewPortWidth' => '<p>The width that the view port will be optimized for when the layout renders.</p>', 'GridLayoutScreenCanvasSizeOptions$OptimizedViewPortWidth' => '<p>The width that the view port will be optimized for when the layout renders.</p>', 'LegendOptions$Width' => '<p>The width of the legend. If this value is omitted, a default width is used when rendering.</p>', 'LegendOptions$Height' => '<p>The height of the legend. If this value is omitted, a default height is used when rendering.</p>', 'LineChartLineStyleSettings$LineWidth' => '<p>Width that determines the line thickness.</p>', 'LineChartMarkerStyleSettings$MarkerSize' => '<p>Size of marker in the series.</p>', 'PanelConfiguration$BorderThickness' => '<p>Sets the line thickness of panel borders.</p>', 'PanelConfiguration$GutterSpacing' => '<p>Sets the total amount of negative space to display between sibling panels.</p>', 'PivotTableDataPathOption$Width' => '<p>The width of the data path option.</p>', 'PivotTableOptions$DefaultCellWidth' => '<p>The default cell width of the pivot table.</p>', 'SectionStyle$Height' => '<p>The height of a section.</p> <p>Heights can only be defined for header and footer sections. The default height margin is 0.5 inches. </p>', 'TableFieldOption$Width' => '<p>The width for a table field.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Port' => '<p>Port.</p>', 'AuroraPostgreSqlParameters$Port' => '<p>The port that Amazon Aurora PostgreSQL is listening on.</p>', 'DatabricksParameters$Port' => '<p>The port for the Databricks data source.</p>', 'ExasolParameters$Port' => '<p>The port for the Exasol data source.</p>', 'MariaDbParameters$Port' => '<p>Port.</p>', 'MySqlParameters$Port' => '<p>Port.</p>', 'OracleParameters$Port' => '<p>The port.</p>', 'PostgreSqlParameters$Port' => '<p>Port.</p>', 'PrestoParameters$Port' => '<p>Port.</p>', 'SparkParameters$Port' => '<p>Port.</p>', 'SqlServerParameters$Port' => '<p>Port.</p>', 'StarburstParameters$Port' => '<p>The port for the Starburst data source.</p>', 'TeradataParameters$Port' => '<p>Port.</p>', 'TrinoParameters$Port' => '<p>The port for the Trino data source.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$MaxRows' => '<p>Maximum number of rows to query Twitter.</p>', 'UploadSettings$StartFromRow' => '<p>A row number to start reading data from.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'LookbackWindow$Size' => '<p>The lookback window column size.</p>', ], ], 'PostgreSqlParameters' => [ 'base' => '<p>The parameters for PostgreSQL.</p>', 'refs' => [ 'DataSourceParameters$PostgreSqlParameters' => '<p>The parameters for PostgreSQL.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>One or more preconditions aren\'t met.</p>', 'refs' => [], ], 'PredefinedHierarchy' => [ 'base' => '<p>The option that determines the hierarchy of the fields that are defined during data preparation. These fields are available to use in any analysis that uses the data source.</p>', 'refs' => [ 'ColumnHierarchy$PredefinedHierarchy' => '<p>The option that determines the hierarchy of the fields that are defined during data preparation. These fields are available to use in any analysis that uses the data source.</p>', ], ], 'PredefinedHierarchyColumnList' => [ 'base' => NULL, 'refs' => [ 'PredefinedHierarchy$Columns' => '<p>The list of columns that define the predefined hierarchy.</p>', ], ], 'PredictionInterval' => [ 'base' => NULL, 'refs' => [ 'ForecastComputation$PredictionInterval' => '<p>The prediction interval setup of a forecast computation.</p>', 'TimeBasedForecastProperties$PredictionInterval' => '<p>The prediction interval setup of a forecast computation.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'CurrencyDisplayFormatConfiguration$Prefix' => '<p>Determines the prefix value of the currency format.</p>', 'NumberDisplayFormatConfiguration$Prefix' => '<p>Determines the prefix value of the number format.</p>', 'PercentageDisplayFormatConfiguration$Prefix' => '<p>Determines the prefix value of the percentage format.</p>', ], ], 'PrestoParameters' => [ 'base' => '<p>The parameters for Presto.</p>', 'refs' => [ 'DataSourceParameters$PrestoParameters' => '<p>The parameters for Presto.</p>', ], ], 'PrimaryValueDisplayType' => [ 'base' => NULL, 'refs' => [ 'GaugeChartOptions$PrimaryValueDisplayType' => '<p>The options that determine the primary value display type.</p>', 'KPIOptions$PrimaryValueDisplayType' => '<p>The options that determine the primary value display type.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'AssetBundlePrincipalList$member' => NULL, 'ResourcePermission$Principal' => '<p>The Amazon Resource Name (ARN) of the principal. This can be one of the following:</p> <ul> <li> <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p> </li> <li> <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p> </li> <li> <p>The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across Amazon Web Services accounts. (This is less common.) </p> </li> </ul>', ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'ColumnLevelPermissionRule$Principals' => '<p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>', ], ], 'ProgressBarOptions' => [ 'base' => '<p>The options that determine the presentation of the progress bar of a KPI visual.</p>', 'refs' => [ 'KPIOptions$ProgressBar' => '<p>The options that determine the presentation of the progress bar of a KPI visual.</p>', ], ], 'ProjectId' => [ 'base' => NULL, 'refs' => [ 'BigQueryParameters$ProjectId' => '<p>The Google Cloud Platform project ID where your datasource was created.</p>', ], ], 'ProjectOperation' => [ 'base' => '<p>A transform operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', 'refs' => [ 'TransformOperation$ProjectOperation' => '<p>An operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', ], ], 'ProjectedColumnList' => [ 'base' => NULL, 'refs' => [ 'ProjectOperation$ProjectedColumns' => '<p>Projected columns.</p>', ], ], 'PropertyRole' => [ 'base' => NULL, 'refs' => [ 'NamedEntityDefinition$PropertyRole' => '<p>The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.</p>', ], ], 'PropertyUsage' => [ 'base' => NULL, 'refs' => [ 'NamedEntityDefinition$PropertyUsage' => '<p>The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and <code>MEASURE</code>.</p>', ], ], 'PurchaseMode' => [ 'base' => NULL, 'refs' => [ 'UpdateSPICECapacityConfigurationRequest$PurchaseMode' => '<p>Determines how SPICE capacity can be purchased. The following options are available. </p> <ul> <li> <p> <code>MANUAL</code>: SPICE capacity can only be purchased manually.</p> </li> <li> <p> <code>AUTO_PURCHASE</code>: Extra SPICE capacity is automatically purchased on your behalf as needed. SPICE capacity can also be purchased manually with this option.</p> </li> </ul>', ], ], 'PutDataSetRefreshPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDataSetRefreshPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Query' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$Query' => '<p>Twitter query string.</p>', ], ], 'QueryExecutionMode' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionOptions$QueryExecutionMode' => '<p>A structure that describes the query execution mode.</p>', ], ], 'QueryExecutionOptions' => [ 'base' => '<p>A structure that describes the query execution options.</p>', 'refs' => [ 'AnalysisDefinition$QueryExecutionOptions' => NULL, 'TemplateVersionDefinition$QueryExecutionOptions' => NULL, ], ], 'QueueInfo' => [ 'base' => '<p>Information about a queued dataset SPICE ingestion.</p>', 'refs' => [ 'Ingestion$QueueInfo' => NULL, ], ], 'QuickSightUserNotFoundException' => [ 'base' => '<p>The user with the provided name isn\'t found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>', 'refs' => [], ], 'RadarChartAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well configuration of a <code>RadarChartVisual</code>.</p>', 'refs' => [ 'RadarChartFieldWells$RadarChartAggregatedFieldWells' => '<p>The aggregated field wells of a radar chart visual.</p>', ], ], 'RadarChartAreaStyleSettings' => [ 'base' => '<p>The configured style settings of a radar chart.</p>', 'refs' => [ 'RadarChartSeriesSettings$AreaStyleSettings' => '<p>The area style settings of a radar chart.</p>', ], ], 'RadarChartAxesRangeScale' => [ 'base' => NULL, 'refs' => [ 'RadarChartConfiguration$AxesRangeScale' => '<p>The axis behavior options of a radar chart.</p>', ], ], 'RadarChartCategoryFieldList' => [ 'base' => NULL, 'refs' => [ 'RadarChartAggregatedFieldWells$Category' => '<p>The aggregated field well categories of a radar chart.</p>', ], ], 'RadarChartColorFieldList' => [ 'base' => NULL, 'refs' => [ 'RadarChartAggregatedFieldWells$Color' => '<p>The color that are assigned to the aggregated field wells of a radar chart.</p>', ], ], 'RadarChartConfiguration' => [ 'base' => '<p>The configuration of a <code>RadarChartVisual</code>.</p>', 'refs' => [ 'RadarChartVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'RadarChartFieldWells' => [ 'base' => '<p>The field wells of a radar chart visual.</p>', 'refs' => [ 'RadarChartConfiguration$FieldWells' => '<p>The field well configuration of a <code>RadarChartVisual</code>.</p>', ], ], 'RadarChartSeriesSettings' => [ 'base' => '<p>The series settings of a radar chart.</p>', 'refs' => [ 'RadarChartConfiguration$BaseSeriesSettings' => '<p>The base sreies settings of a radar chart.</p>', ], ], 'RadarChartShape' => [ 'base' => NULL, 'refs' => [ 'RadarChartConfiguration$Shape' => '<p>The shape of the radar chart.</p>', ], ], 'RadarChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a <code>RadarChartVisual</code>.</p>', 'refs' => [ 'RadarChartConfiguration$SortConfiguration' => '<p>The sort configuration of a <code>RadarChartVisual</code>.</p>', ], ], 'RadarChartStartAngle' => [ 'base' => NULL, 'refs' => [ 'RadarChartConfiguration$StartAngle' => '<p>The start angle of a radar chart\'s axis.</p>', ], ], 'RadarChartValuesFieldList' => [ 'base' => NULL, 'refs' => [ 'RadarChartAggregatedFieldWells$Values' => '<p>The values that are assigned to the aggregated field wells of a radar chart.</p>', ], ], 'RadarChartVisual' => [ 'base' => '<p>A radar chart visual.</p>', 'refs' => [ 'Visual$RadarChartVisual' => '<p>A radar chart visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using radar charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'RangeConstant' => [ 'base' => '<p>A structure that represents a range constant.</p>', 'refs' => [ 'TopicRangeFilterConstant$RangeConstant' => '<p>The value of the constant that is used to specify the endpoints of a range filter.</p>', ], ], 'RangeEndsLabelType' => [ 'base' => '<p>The range ends label type of a data path label.</p>', 'refs' => [ 'DataLabelType$RangeEndsLabelType' => '<p>Determines the label configuration for range end value in a visual.</p>', ], ], 'RdsParameters' => [ 'base' => '<p>The parameters for Amazon RDS.</p>', 'refs' => [ 'DataSourceParameters$RdsParameters' => '<p>The parameters for Amazon RDS.</p>', ], ], 'RecoveryWindowInDays' => [ 'base' => NULL, 'refs' => [ 'DeleteAnalysisRequest$RecoveryWindowInDays' => '<p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can\'t use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>', ], ], 'RedshiftIAMParameters' => [ 'base' => '<p>A structure that grants Amazon QuickSight access to your cluster and make a call to the <code>redshift:GetClusterCredentials</code> API. For more information on the <code>redshift:GetClusterCredentials</code> API, see <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_GetClusterCredentials.html"> <code>GetClusterCredentials</code> </a>.</p>', 'refs' => [ 'RedshiftParameters$IAMParameters' => '<p>An optional parameter that uses IAM authentication to grant Amazon QuickSight access to your cluster. This parameter can be used instead of <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSourceCredentials.html">DataSourceCredentials</a>.</p>', ], ], 'RedshiftParameters' => [ 'base' => '<p>The parameters for Amazon Redshift. The <code>ClusterId</code> field can be blank if <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>', 'refs' => [ 'DataSourceParameters$RedshiftParameters' => '<p>The parameters for Amazon Redshift.</p>', ], ], 'ReferenceLine' => [ 'base' => '<p>The reference line visual display options.</p>', 'refs' => [ 'ReferenceLineList$member' => NULL, ], ], 'ReferenceLineCustomLabelConfiguration' => [ 'base' => '<p>The configuration for a custom label on a <code>ReferenceLine</code>.</p>', 'refs' => [ 'ReferenceLineLabelConfiguration$CustomLabelConfiguration' => '<p>The custom label configuration of the label in a reference line.</p>', ], ], 'ReferenceLineDataConfiguration' => [ 'base' => '<p>The data configuration of the reference line.</p>', 'refs' => [ 'ReferenceLine$DataConfiguration' => '<p>The data configuration of the reference line.</p>', ], ], 'ReferenceLineDynamicDataConfiguration' => [ 'base' => '<p>The dynamic configuration of the reference line data configuration.</p>', 'refs' => [ 'ReferenceLineDataConfiguration$DynamicConfiguration' => '<p>The dynamic configuration of the reference line data configuration.</p>', ], ], 'ReferenceLineLabelConfiguration' => [ 'base' => '<p>The label configuration of a reference line.</p>', 'refs' => [ 'ReferenceLine$LabelConfiguration' => '<p>The label configuration of the reference line.</p>', ], ], 'ReferenceLineLabelHorizontalPosition' => [ 'base' => NULL, 'refs' => [ 'ReferenceLineLabelConfiguration$HorizontalPosition' => '<p>The horizontal position configuration of the label in a reference line. Choose one of the following options:</p> <ul> <li> <p> <code>LEFT</code> </p> </li> <li> <p> <code>CENTER</code> </p> </li> <li> <p> <code>RIGHT</code> </p> </li> </ul>', ], ], 'ReferenceLineLabelVerticalPosition' => [ 'base' => NULL, 'refs' => [ 'ReferenceLineLabelConfiguration$VerticalPosition' => '<p>The vertical position configuration of the label in a reference line. Choose one of the following options:</p> <ul> <li> <p> <code>ABOVE</code> </p> </li> <li> <p> <code>BELOW</code> </p> </li> </ul>', ], ], 'ReferenceLineList' => [ 'base' => NULL, 'refs' => [ 'BarChartConfiguration$ReferenceLines' => '<p>The reference line setup of the visual.</p>', 'BoxPlotChartConfiguration$ReferenceLines' => '<p>The reference line setup of the visual.</p>', 'ComboChartConfiguration$ReferenceLines' => '<p>The reference line setup of the visual.</p>', 'LineChartConfiguration$ReferenceLines' => '<p>The reference lines configuration of a line chart.</p>', ], ], 'ReferenceLinePatternType' => [ 'base' => NULL, 'refs' => [ 'ReferenceLineStyleConfiguration$Pattern' => '<p>The pattern type of the line style. Choose one of the following options:</p> <ul> <li> <p> <code>SOLID</code> </p> </li> <li> <p> <code>DASHED</code> </p> </li> <li> <p> <code>DOTTED</code> </p> </li> </ul>', ], ], 'ReferenceLineSeriesType' => [ 'base' => NULL, 'refs' => [ 'ReferenceLineDataConfiguration$SeriesType' => '<p>The series type of the reference line data configuration. Choose one of the following options:</p> <ul> <li> <p> <code>BAR</code> </p> </li> <li> <p> <code>LINE</code> </p> </li> </ul>', ], ], 'ReferenceLineStaticDataConfiguration' => [ 'base' => '<p>The static data configuration of the reference line data configuration.</p>', 'refs' => [ 'ReferenceLineDataConfiguration$StaticConfiguration' => '<p>The static data configuration of the reference line data configuration.</p>', ], ], 'ReferenceLineStyleConfiguration' => [ 'base' => '<p>The style configuration of the reference line.</p>', 'refs' => [ 'ReferenceLine$StyleConfiguration' => '<p>The style configuration of the reference line.</p>', ], ], 'ReferenceLineValueLabelConfiguration' => [ 'base' => '<p>The value label configuration of the label in a reference line.</p>', 'refs' => [ 'ReferenceLineLabelConfiguration$ValueLabelConfiguration' => '<p>The value label configuration of the label in a reference line.</p>', ], ], 'ReferenceLineValueLabelRelativePosition' => [ 'base' => NULL, 'refs' => [ 'ReferenceLineValueLabelConfiguration$RelativePosition' => '<p>The relative position of the value label. Choose one of the following options:</p> <ul> <li> <p> <code>BEFORE_CUSTOM_LABEL</code> </p> </li> <li> <p> <code>AFTER_CUSTOM_LABEL</code> </p> </li> </ul>', ], ], 'RefreshConfiguration' => [ 'base' => '<p>The refresh configuration of a dataset.</p>', 'refs' => [ 'DataSetRefreshProperties$RefreshConfiguration' => '<p>The refresh configuration for a dataset.</p>', ], ], 'RefreshFrequency' => [ 'base' => '<p>Specifies the interval between each scheduled refresh of a dataset.</p>', 'refs' => [ 'RefreshSchedule$ScheduleFrequency' => '<p>The frequency for the refresh schedule.</p>', ], ], 'RefreshInterval' => [ 'base' => NULL, 'refs' => [ 'RefreshFrequency$Interval' => '<p>The interval between scheduled refreshes. Valid values are as follows:</p> <ul> <li> <p> <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</p> </li> <li> <p> <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for incremental refreshes. This interval can only be used for one schedule per dataset.</p> </li> <li> <p> <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule per dataset.</p> </li> <li> <p> <code>DAILY</code>: The dataset refreshes every day.</p> </li> <li> <p> <code>WEEKLY</code>: The dataset refreshes every week.</p> </li> <li> <p> <code>MONTHLY</code>: The dataset refreshes every month.</p> </li> </ul>', ], ], 'RefreshSchedule' => [ 'base' => '<p>The refresh schedule of a dataset.</p>', 'refs' => [ 'CreateRefreshScheduleRequest$Schedule' => '<p>The refresh schedule.</p>', 'DescribeRefreshScheduleResponse$RefreshSchedule' => '<p>The refresh schedule.</p>', 'RefreshSchedules$member' => '<p>A list of <code>RefreshSchedule</code> objects.</p>', 'UpdateRefreshScheduleRequest$Schedule' => '<p>The refresh schedule.</p>', ], ], 'RefreshSchedules' => [ 'base' => NULL, 'refs' => [ 'ListRefreshSchedulesResponse$RefreshSchedules' => '<p>The list of refresh schedules for the dataset.</p>', ], ], 'RegisterUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisteredCustomerManagedKey' => [ 'base' => '<p>A customer managed key structure that contains the information listed below: </p> <ul> <li> <p> <code>KeyArn</code> - The ARN of a KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.</p> </li> <li> <p> <code>DefaultKey</code> - Indicates whether the current key is set as the default key for encryption and decryption use.</p> </li> </ul>', 'refs' => [ 'KeyRegistration$member' => NULL, ], ], 'RegisteredUserConsoleFeatureConfigurations' => [ 'base' => '<p>The feature configurations of an embedded Amazon QuickSight console.</p>', 'refs' => [ 'RegisteredUserQuickSightConsoleEmbeddingConfiguration$FeatureConfigurations' => '<p>The embedding configuration of an embedded Amazon QuickSight console.</p>', ], ], 'RegisteredUserDashboardEmbeddingConfiguration' => [ 'base' => '<p>Information about the dashboard you want to embed.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$Dashboard' => '<p>The configuration details for providing a dashboard embedding experience.</p>', ], ], 'RegisteredUserDashboardFeatureConfigurations' => [ 'base' => '<p>The feature configuration for an embedded dashboard.</p>', 'refs' => [ 'RegisteredUserDashboardEmbeddingConfiguration$FeatureConfigurations' => '<p>The feature configurations of an embbedded Amazon QuickSight dashboard.</p>', ], ], 'RegisteredUserDashboardVisualEmbeddingConfiguration' => [ 'base' => '<p>The experience that you are embedding. You can use this object to generate a url that embeds a visual into your application.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$DashboardVisual' => '<p>The type of embedding experience. In this case, Amazon QuickSight visuals.</p>', ], ], 'RegisteredUserEmbeddingExperienceConfiguration' => [ 'base' => '<p>The type of experience you want to embed. For registered users, you can embed Amazon QuickSight dashboards or the Amazon QuickSight console.</p> <note> <p>Exactly one of the experience configurations is required. You can choose <code>Dashboard</code> or <code>QuickSightConsole</code>. You cannot choose more than one experience configuration.</p> </note>', 'refs' => [ 'GenerateEmbedUrlForRegisteredUserRequest$ExperienceConfiguration' => '<p>The experience that you want to embed. For registered users, you can embed Amazon QuickSight dashboards, Amazon QuickSight visuals, the Amazon QuickSight Q search bar, the Amazon QuickSight Generative Q&amp;A experience, or the entire Amazon QuickSight console.</p>', ], ], 'RegisteredUserGenerativeQnAEmbeddingConfiguration' => [ 'base' => '<p>An object that provides information about the configuration of a Generative Q&amp;A experience.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$GenerativeQnA' => '<p>The configuration details for embedding the Generative Q&amp;A experience.</p> <p>For more information about embedding the Generative Q&amp;A experience, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'RegisteredUserQSearchBarEmbeddingConfiguration' => [ 'base' => '<p>Information about the Q search bar embedding experience.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$QSearchBar' => '<p>The configuration details for embedding the Q search bar.</p> <p>For more information about embedding the Q search bar, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'RegisteredUserQuickSightConsoleEmbeddingConfiguration' => [ 'base' => '<p>Information about the Amazon QuickSight console that you want to embed.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$QuickSightConsole' => '<p>The configuration details for providing each Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>Use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code> where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> API operation. Use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> </p> </li> </ul> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', ], ], 'RelationalTable' => [ 'base' => '<p>A physical table type for relational data sources.</p>', 'refs' => [ 'PhysicalTable$RelationalTable' => '<p>A physical table type for relational data sources.</p>', ], ], 'RelationalTableCatalog' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Catalog' => '<p>The catalog associated with a table.</p>', ], ], 'RelationalTableName' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Name' => '<p>The name of the relational table.</p>', ], ], 'RelationalTableSchema' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Schema' => '<p>The schema name. This name applies to certain relational database engines.</p>', ], ], 'RelativeDateTimeControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultRelativeDateTimeControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterRelativeDateTimeControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'RelativeDateType' => [ 'base' => NULL, 'refs' => [ 'RelativeDatesFilter$RelativeDateType' => '<p>The range date type of the filter. Choose one of the options below:</p> <ul> <li> <p> <code>PREVIOUS</code> </p> </li> <li> <p> <code>THIS</code> </p> </li> <li> <p> <code>LAST</code> </p> </li> <li> <p> <code>NOW</code> </p> </li> <li> <p> <code>NEXT</code> </p> </li> </ul>', ], ], 'RelativeDatesFilter' => [ 'base' => '<p>A <code>RelativeDatesFilter</code> filters relative dates values.</p>', 'refs' => [ 'Filter$RelativeDatesFilter' => '<p>A <code>RelativeDatesFilter</code> filters date values that are relative to a given date.</p>', ], ], 'RelativeFontSize' => [ 'base' => NULL, 'refs' => [ 'FontSize$Relative' => '<p>The lexical name for the text size, proportional to its surrounding context.</p>', ], ], 'RenameColumnOperation' => [ 'base' => '<p>A transform operation that renames a column.</p>', 'refs' => [ 'TransformOperation$RenameColumnOperation' => '<p>An operation that renames a column.</p>', ], ], 'ResizeOption' => [ 'base' => NULL, 'refs' => [ 'GridLayoutScreenCanvasSizeOptions$ResizeOption' => '<p>This value determines the layout behavior when the viewport is resized.</p> <ul> <li> <p> <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this option is called <code>Classic</code>.</p> </li> <li> <p> <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In the Amazon QuickSight console, this option is called <code>Tiled</code>.</p> </li> </ul>', ], ], 'ResourceExistsException' => [ 'base' => '<p>The resource specified already exists. </p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobAnalysisOverrideParameters$AnalysisId' => '<p>The ID of the analysis that you ant to apply overrides to.</p>', 'AssetBundleImportJobDashboardOverrideParameters$DashboardId' => '<p>The ID of the dashboard that you want to apply overrides to.</p>', 'AssetBundleImportJobDataSetOverrideParameters$DataSetId' => '<p>The ID of the dataset to apply overrides to.</p>', 'AssetBundleImportJobDataSourceOverrideParameters$DataSourceId' => '<p>The ID of the data source to apply overrides to.</p>', 'AssetBundleImportJobRefreshScheduleOverrideParameters$DataSetId' => '<p>A partial identifier for the specific <code>RefreshSchedule</code> resource that is being overridden. This structure is used together with the <code>ScheduleID</code> structure.</p>', 'AssetBundleImportJobThemeOverrideParameters$ThemeId' => '<p>The ID of the theme to apply overrides to.</p>', 'CreateDataSetRequest$DataSetId' => '<p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceRequest$DataSourceId' => '<p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>', 'CreateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateRefreshScheduleRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSet$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSetSummary$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSource$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DataSourceSummary$DataSourceId' => '<p>The unique ID of the data source.</p>', 'DeleteDataSetRefreshPropertiesRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'DeleteDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteRefreshScheduleRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'DescribeDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeDataSetRefreshPropertiesRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'DescribeDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeRefreshScheduleRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'DescribeTopicRefreshRequest$RefreshId' => '<p>The ID of the refresh, which is performed when the topic is created or updated.</p>', 'ListRefreshSchedulesRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'PutDataSetRefreshPropertiesRequest$DataSetId' => '<p>The ID of the dataset.</p>', 'TopicRefreshDetails$RefreshId' => '<p>The ID of the refresh, which occurs as a result of topic creation or topic update.</p>', 'UpdateDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>', 'UpdateDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>', 'UpdateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateRefreshScheduleRequest$DataSetId' => '<p>The ID of the dataset.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobAnalysisOverrideParameters$Name' => '<p>A new name for the analysis.</p>', 'AssetBundleImportJobDashboardOverrideParameters$Name' => '<p>A new name for the dashboard.</p>', 'AssetBundleImportJobDataSetOverrideParameters$Name' => '<p>A new name for the dataset.</p>', 'AssetBundleImportJobDataSourceOverrideParameters$Name' => '<p>A new name for the data source.</p>', 'AssetBundleImportJobThemeOverrideParameters$Name' => '<p>A new name for the theme.</p>', 'AssetBundleImportJobVPCConnectionOverrideParameters$Name' => '<p>A new name for the VPC connection.</p>', 'CreateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'CreateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', 'CreateVPCConnectionRequest$Name' => '<p>The display name for the VPC connection.</p>', 'DataSet$Name' => '<p>A display name for the dataset.</p>', 'DataSetSummary$Name' => '<p>A display name for the dataset.</p>', 'DataSource$Name' => '<p>A display name for the data source.</p>', 'DataSourceSummary$Name' => '<p>The name of the data source.</p>', 'TopicDetails$Name' => '<p>The name of the topic.</p>', 'TopicSummary$Name' => '<p>The name of the topic.</p>', 'UpdateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'UpdateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', 'UpdateVPCConnectionRequest$Name' => '<p>The display name for the VPC connection.</p>', 'VPCConnection$Name' => '<p>The display name for the VPC connection.</p>', 'VPCConnectionSummary$Name' => '<p>The display name for the VPC connection.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResourcePermission' => [ 'base' => '<p>Permission for the resource.</p>', 'refs' => [ 'ResourcePermissionList$member' => NULL, 'UpdateLinkPermissionList$member' => NULL, 'UpdateResourcePermissionList$member' => NULL, ], ], 'ResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateAnalysisRequest$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p> <p>To specify no permissions, omit <code>Permissions</code>.</p>', 'CreateDashboardRequest$Permissions' => '<p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p> <p>To specify no permissions, omit the permissions list.</p>', 'CreateDataSetRequest$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'CreateDataSourceRequest$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'CreateFolderRequest$Permissions' => '<p>A structure that describes the principals and the resource-level permissions of a folder.</p> <p>To specify no permissions, omit <code>Permissions</code>.</p>', 'CreateTemplateRequest$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'CreateThemeRequest$Permissions' => '<p>A valid grouping of resource permissions to apply to the new theme. </p>', 'DescribeAnalysisPermissionsResponse$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis.</p>', 'DescribeDashboardPermissionsResponse$Permissions' => '<p>A structure that contains the permissions for the dashboard.</p>', 'DescribeDataSetPermissionsResponse$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'DescribeDataSourcePermissionsResponse$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'DescribeFolderPermissionsResponse$Permissions' => '<p>Information about the permissions on the folder.</p>', 'DescribeFolderResolvedPermissionsResponse$Permissions' => '<p>Information about the permissions for the folder.</p>', 'DescribeTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'DescribeThemePermissionsResponse$Permissions' => '<p>A list of resource permissions set on the theme. </p>', 'DescribeTopicPermissionsResponse$Permissions' => '<p>A list of resource permissions that are configured to the topic.</p>', 'LinkSharingConfiguration$Permissions' => '<p>A structure that contains the permissions of a shareable link.</p>', 'UpdateAnalysisPermissionsResponse$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis.</p>', 'UpdateDashboardPermissionsResponse$Permissions' => '<p>Information about the permissions on the dashboard.</p>', 'UpdateDataSetPermissionsRequest$GrantPermissions' => '<p>The resource permissions that you want to grant to the dataset.</p>', 'UpdateDataSetPermissionsRequest$RevokePermissions' => '<p>The resource permissions that you want to revoke from the dataset.</p>', 'UpdateDataSourcePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions that you want to grant on the data source.</p>', 'UpdateDataSourcePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions that you want to revoke on the data source.</p>', 'UpdateFolderPermissionsRequest$GrantPermissions' => '<p>The permissions that you want to grant on a resource. Namespace ARNs are not supported <code>Principal</code> values for folder permissions.</p>', 'UpdateFolderPermissionsRequest$RevokePermissions' => '<p>The permissions that you want to revoke from a resource. Namespace ARNs are not supported <code>Principal</code> values for folder permissions.</p>', 'UpdateFolderPermissionsResponse$Permissions' => '<p>Information about the permissions for the folder.</p>', 'UpdateTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template.</p>', 'UpdateThemePermissionsResponse$Permissions' => '<p>The resulting list of resource permissions for the theme.</p>', 'UpdateTopicPermissionsResponse$Permissions' => '<p>A list of resource permissions on the topic.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'Analysis$Status' => '<p>Status associated with the analysis.</p>', 'AnalysisSummary$Status' => '<p>The last known status for the analysis.</p>', 'CreateAnalysisResponse$CreationStatus' => '<p>The status of the creation of the analysis. </p>', 'CreateDashboardResponse$CreationStatus' => '<p>The status of the dashboard creation request.</p>', 'CreateDataSourceResponse$CreationStatus' => '<p>The status of creating the data source.</p>', 'CreateTemplateResponse$CreationStatus' => '<p>The template creation status.</p>', 'CreateThemeResponse$CreationStatus' => '<p>The theme creation status.</p>', 'DashboardVersion$Status' => '<p>The HTTP status of the request.</p>', 'DashboardVersionSummary$Status' => '<p>The HTTP status of the request.</p>', 'DataSource$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisDefinitionResponse$ResourceStatus' => '<p>Status associated with the analysis.</p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> </p> </li> <li> <p> <code>CREATION_SUCCESSFUL</code> </p> </li> <li> <p> <code>CREATION_FAILED</code> </p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> </p> </li> <li> <p> <code>UPDATE_FAILED</code> </p> </li> <li> <p> <code>DELETED</code> </p> </li> </ul>', 'DescribeDashboardDefinitionResponse$ResourceStatus' => '<p>Status associated with the dashboard version.</p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> </p> </li> <li> <p> <code>CREATION_SUCCESSFUL</code> </p> </li> <li> <p> <code>CREATION_FAILED</code> </p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> </p> </li> <li> <p> <code>UPDATE_FAILED</code> </p> </li> <li> <p> <code>DELETED</code> </p> </li> </ul>', 'DescribeTemplateDefinitionResponse$ResourceStatus' => '<p>Status associated with the template.</p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> </p> </li> <li> <p> <code>CREATION_SUCCESSFUL</code> </p> </li> <li> <p> <code>CREATION_FAILED</code> </p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> </p> </li> <li> <p> <code>UPDATE_FAILED</code> </p> </li> <li> <p> <code>DELETED</code> </p> </li> </ul>', 'TemplateVersion$Status' => '<p>The status that is associated with the template.</p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> </p> </li> <li> <p> <code>CREATION_SUCCESSFUL</code> </p> </li> <li> <p> <code>CREATION_FAILED</code> </p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> </p> </li> <li> <p> <code>UPDATE_FAILED</code> </p> </li> <li> <p> <code>DELETED</code> </p> </li> </ul>', 'TemplateVersionSummary$Status' => '<p>The status of the template version.</p>', 'ThemeVersion$Status' => '<p>The status of the theme version.</p>', 'ThemeVersionSummary$Status' => '<p>The status of the theme version.</p>', 'UpdateAnalysisResponse$UpdateStatus' => '<p>The update status of the last update that was made to the analysis.</p>', 'UpdateDashboardResponse$CreationStatus' => '<p>The creation status of the request.</p>', 'UpdateDataSourceResponse$UpdateStatus' => '<p>The update status of the data source\'s last update.</p>', 'UpdateTemplateResponse$CreationStatus' => '<p>The creation status of the template.</p>', 'UpdateThemeResponse$CreationStatus' => '<p>The creation status of the theme.</p>', ], ], 'ResourceUnavailableException' => [ 'base' => '<p>This resource is currently unavailable.</p>', 'refs' => [], ], 'RestoreAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestrictiveResourceId' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserGenerativeQnAEmbeddingConfiguration$InitialTopicId' => '<p>The Amazon QuickSight Q topic ID of the new reader experience topic that you want the anonymous user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders the Generative Q&amp;A experience with this new reader experience topic pre selected.</p> <p>The Amazon Resource Name (ARN) of this Q new reader experience topic must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an <code>InvalidParameterValueException</code> error.</p>', 'AnonymousUserQSearchBarEmbeddingConfiguration$InitialTopicId' => '<p>The Amazon QuickSight Q topic ID of the legacy topic that you want the anonymous user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders the Q search bar with this legacy topic pre-selected.</p> <p>The Amazon Resource Name (ARN) of this Q legacy topic must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an <code>InvalidParameterValueException</code> error.</p>', 'CreateFolderMembershipRequest$FolderId' => '<p>The ID of the folder.</p>', 'CreateFolderMembershipRequest$MemberId' => '<p>The ID of the asset that you want to add to the folder.</p>', 'CreateFolderRequest$FolderId' => '<p>The ID of the folder.</p>', 'CreateFolderResponse$FolderId' => '<p>The folder ID for the newly created folder.</p>', 'DeleteFolderMembershipRequest$FolderId' => '<p>The Folder ID.</p>', 'DeleteFolderMembershipRequest$MemberId' => '<p>The ID of the asset that you want to delete.</p>', 'DeleteFolderRequest$FolderId' => '<p>The ID of the folder.</p>', 'DeleteFolderResponse$FolderId' => '<p>The ID of the folder.</p>', 'DescribeFolderPermissionsRequest$FolderId' => '<p>The ID of the folder.</p>', 'DescribeFolderPermissionsResponse$FolderId' => '<p>The ID of the folder.</p>', 'DescribeFolderRequest$FolderId' => '<p>The ID of the folder.</p>', 'DescribeFolderResolvedPermissionsRequest$FolderId' => '<p>The ID of the folder.</p>', 'DescribeFolderResolvedPermissionsResponse$FolderId' => '<p>The ID of the folder.</p>', 'Folder$FolderId' => '<p>The ID of the folder.</p>', 'FolderMember$MemberId' => '<p>The ID of an asset in the folder.</p>', 'FolderSummary$FolderId' => '<p>The ID of the folder.</p>', 'ListFolderMembersRequest$FolderId' => '<p>The ID of the folder.</p>', 'MemberIdArnPair$MemberId' => '<p>The ID of the member.</p>', 'RegisteredUserGenerativeQnAEmbeddingConfiguration$InitialTopicId' => '<p>The ID of the new Q reader experience topic that you want to make the starting topic in the Generative Q&amp;A experience. You can find a topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for the topic that you open.</p> <p>If you don\'t specify an initial topic or you specify a legacy topic, a list of all shared new reader experience topics is shown in the Generative Q&amp;A experience for your readers. When you select an initial new reader experience topic, you can specify whether or not readers are allowed to select other new reader experience topics from the available ones in the list.</p>', 'RegisteredUserQSearchBarEmbeddingConfiguration$InitialTopicId' => '<p>The ID of the legacy Q topic that you want to use as the starting topic in the Q search bar. To locate the topic ID of the topic that you want to use, open the <a href="https://quicksight.aws.amazon.com/">Amazon QuickSight console</a>, navigate to the <b>Topics</b> pane, and choose thre topic that you want to use. The <code>TopicID</code> is located in the URL of the topic that opens. When you select an initial topic, you can specify whether or not readers are allowed to select other topics from the list of available topics.</p> <p>If you don\'t specify an initial topic or if you specify a new reader experience topic, a list of all shared legacy topics is shown in the Q bar. </p>', 'UpdateFolderPermissionsRequest$FolderId' => '<p>The ID of the folder.</p>', 'UpdateFolderPermissionsResponse$FolderId' => '<p>The ID of the folder.</p>', 'UpdateFolderRequest$FolderId' => '<p>The ID of the folder.</p>', 'UpdateFolderResponse$FolderId' => '<p>The ID of the folder.</p>', ], ], 'ReviewedAnswerErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidTopicReviewedAnswer$Error' => '<p>The error that is returned for the <code>InvalidTopicReviewedAnswer</code>.</p>', ], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'CreateRoleMembershipRequest$Role' => '<p>The role that you want to add a group to.</p>', 'DeleteRoleCustomPermissionRequest$Role' => '<p>The role that you want to remove permissions from.</p>', 'DeleteRoleMembershipRequest$Role' => '<p>The role that you want to remove permissions from.</p>', 'DescribeRoleCustomPermissionRequest$Role' => '<p>The name of the role whose permissions you want described.</p>', 'ListRoleMembershipsRequest$Role' => '<p>The name of the role.</p>', 'UpdateRoleCustomPermissionRequest$Role' => '<p>The name of role tht you want to update.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParameters$RoleArn' => '<p>An optional override of the role ARN to be used by the VPC connection.</p>', 'AthenaParameters$RoleArn' => '<p>Use the <code>RoleArn</code> structure to override an account-wide role for a specific Athena data source. For example, say an account administrator has turned off all Athena access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow Athena access for the single Athena data source that is specified in the structure, even if the account-wide role forbidding Athena access is still active.</p>', 'CreateVPCConnectionRequest$RoleArn' => '<p>The IAM role to associate with the VPC connection.</p>', 'RedshiftIAMParameters$RoleArn' => '<p>Use the <code>RoleArn</code> structure to allow Amazon QuickSight to call <code>redshift:GetClusterCredentials</code> on your cluster. The calling principal must have <code>iam:PassRole</code> access to pass the role to Amazon QuickSight. The role\'s trust policy must allow the Amazon QuickSight service principal to assume the role.</p>', 'S3Parameters$RoleArn' => '<p>Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source. For example, say an account administrator has turned off all S3 access with an account-wide role. The administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for the single S3 data source that is specified in the structure, even if the account-wide role forbidding S3 access is still active.</p>', 'UpdateVPCConnectionRequest$RoleArn' => '<p>An IAM role associated with the VPC connection.</p>', ], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'DescribeRoleCustomPermissionResponse$CustomPermissionsName' => '<p>The name of the custom permission that is described.</p>', 'RegisterUserRequest$CustomPermissionsName' => '<p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user\'s access by restricting access the following operations:</p> <ul> <li> <p>Create and update data sources</p> </li> <li> <p>Create and update datasets</p> </li> <li> <p>Create and update email reports</p> </li> <li> <p>Subscribe to email reports</p> </li> </ul> <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p> <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user. </p> <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader, admin pro, author pro, reader pro).</p> <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>', 'UpdateRoleCustomPermissionRequest$CustomPermissionsName' => '<p>The name of the custom permission that you want to update the role with.</p>', 'UpdateUserRequest$CustomPermissionsName' => '<p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user\'s access by restricting access the following operations:</p> <ul> <li> <p>Create and update data sources</p> </li> <li> <p>Create and update datasets</p> </li> <li> <p>Create and update email reports</p> </li> <li> <p>Subscribe to email reports</p> </li> </ul> <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user. </p> <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p> <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>', 'User$CustomPermissionsName' => '<p>The custom permissions profile associated with this user.</p>', ], ], 'RoleSessionName' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$SessionName' => '<p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don\'t need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>', ], ], 'RollingDateConfiguration' => [ 'base' => '<p>The rolling date configuration of a date time filter.</p>', 'refs' => [ 'DateTimeDefaultValues$RollingDate' => '<p>The rolling date of the <code>DataTimeDefaultValues</code>. The date is determined from the dataset based on input expression.</p>', 'TimeEqualityFilter$RollingDate' => '<p>The rolling date input for the <code>TimeEquality</code> filter.</p> <p>This field is mutually exclusive to <code>Value</code> and <code>ParameterName</code>.</p>', 'TimeRangeFilterValue$RollingDate' => '<p>The rolling date input value.</p>', ], ], 'RowAlternateColorList' => [ 'base' => NULL, 'refs' => [ 'RowAlternateColorOptions$RowAlternateColors' => '<p>Determines the list of row alternate colors.</p>', ], ], 'RowAlternateColorOptions' => [ 'base' => '<p>Determines the row alternate color options.</p>', 'refs' => [ 'PivotTableOptions$RowAlternateColorOptions' => '<p>The row alternate color options (widget status, row alternate colors).</p>', 'TableOptions$RowAlternateColorOptions' => '<p>The row alternate color options (widget status, row alternate colors) for a table.</p>', ], ], 'RowInfo' => [ 'base' => '<p>Information about rows for a data set SPICE ingestion.</p>', 'refs' => [ 'Ingestion$RowInfo' => NULL, ], ], 'RowLevelPermissionDataSet' => [ 'base' => '<p>Information about a dataset that contains permissions for row-level security (RLS). The permissions dataset maps fields to users or groups. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported for new RLS datasets.</p>', 'refs' => [ 'CreateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data that you want to create.</p>', 'DataSet$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'DataSetSummary$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'UpdateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data you want to create.</p>', ], ], 'RowLevelPermissionFormatVersion' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$FormatVersion' => '<p>The user or group rules associated with the dataset that contains permissions for RLS.</p> <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>', ], ], 'RowLevelPermissionPolicy' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$PermissionPolicy' => '<p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is included for backward compatibility only.</p>', ], ], 'RowLevelPermissionTagConfiguration' => [ 'base' => '<p>The configuration of tags on a dataset to set row-level security. </p>', 'refs' => [ 'CreateDataSetRequest$RowLevelPermissionTagConfiguration' => '<p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>', 'DataSet$RowLevelPermissionTagConfiguration' => '<p>The element you can use to define tags for row-level security.</p>', 'UpdateDataSetRequest$RowLevelPermissionTagConfiguration' => '<p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>', ], ], 'RowLevelPermissionTagDelimiter' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$TagMultiValueDelimiter' => '<p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>', ], ], 'RowLevelPermissionTagRule' => [ 'base' => '<p>A set of rules associated with a tag.</p>', 'refs' => [ 'RowLevelPermissionTagRuleList$member' => NULL, ], ], 'RowLevelPermissionTagRuleConfiguration' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRuleConfigurationList$member' => NULL, ], ], 'RowLevelPermissionTagRuleConfigurationList' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagConfiguration$TagRuleConfigurations' => '<p>A list of tag configuration rules to apply to a dataset. All tag configurations have the OR condition. Tags within each tile will be joined (AND). At least one rule in this structure must have all tag values assigned to it to apply Row-level security (RLS) to the dataset.</p>', ], ], 'RowLevelPermissionTagRuleList' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagConfiguration$TagRules' => '<p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>', ], ], 'RowSortList' => [ 'base' => NULL, 'refs' => [ 'TableSortConfiguration$RowSort' => '<p>The field sort options for rows in the table.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Bucket' => '<p>Amazon S3 bucket.</p>', ], ], 'S3BucketConfiguration' => [ 'base' => '<p>An optional structure that contains the Amazon S3 bucket configuration that the generated snapshots are stored in. If you don\'t provide this information, generated snapshots are stored in the default Amazon QuickSight bucket.</p>', 'refs' => [ 'SnapshotS3DestinationConfiguration$BucketConfiguration' => '<p>A structure that contains details about the Amazon S3 bucket that the generated dashboard snapshot is saved in.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Key' => '<p>Amazon S3 key that identifies an object.</p>', ], ], 'S3Parameters' => [ 'base' => '<p>The parameters for S3.</p>', 'refs' => [ 'DataSourceParameters$S3Parameters' => '<p>The parameters for S3.</p>', ], ], 'S3Source' => [ 'base' => '<p>A physical table type for an S3 data source.</p>', 'refs' => [ 'PhysicalTable$S3Source' => '<p>A physical table type for as S3 data source.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportSource$S3Uri' => '<p>The Amazon S3 URI for an asset bundle import file that exists in an Amazon S3 bucket that the caller has read access to. The file must be a zip format file and can\'t exceed 20 MB.</p>', 'AssetBundleImportSourceDescription$S3Uri' => '<p>The Amazon S3 URI that you provided at the start of the import job.</p>', ], ], 'SameSheetTargetVisualConfiguration' => [ 'base' => '<p>The configuration of the same-sheet target visuals that you want to be filtered.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterOperationTargetVisualsConfiguration$SameSheetTargetVisualConfiguration' => '<p>The configuration of the same-sheet target visuals that you want to be filtered.</p>', ], ], 'SankeyDiagramAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a sankey diagram.</p>', 'refs' => [ 'SankeyDiagramFieldWells$SankeyDiagramAggregatedFieldWells' => '<p>The field well configuration of a sankey diagram.</p>', ], ], 'SankeyDiagramChartConfiguration' => [ 'base' => '<p>The configuration of a sankey diagram.</p>', 'refs' => [ 'SankeyDiagramVisual$ChartConfiguration' => '<p>The configuration of a sankey diagram.</p>', ], ], 'SankeyDiagramFieldWells' => [ 'base' => '<p>The field well configuration of a sankey diagram.</p>', 'refs' => [ 'SankeyDiagramChartConfiguration$FieldWells' => '<p>The field well configuration of a sankey diagram.</p>', ], ], 'SankeyDiagramSortConfiguration' => [ 'base' => '<p>The sort configuration of a sankey diagram.</p>', 'refs' => [ 'SankeyDiagramChartConfiguration$SortConfiguration' => '<p>The sort configuration of a sankey diagram.</p>', ], ], 'SankeyDiagramVisual' => [ 'base' => '<p>A sankey diagram.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey diagrams</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$SankeyDiagramVisual' => '<p>A sankey diagram.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey diagrams</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'ScatterPlotCategoricallyAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well of a scatter plot.</p>', 'refs' => [ 'ScatterPlotFieldWells$ScatterPlotCategoricallyAggregatedFieldWells' => '<p>The aggregated field wells of a scatter plot. The x and y-axes of scatter plots with aggregated field wells are aggregated by category, label, or both.</p>', ], ], 'ScatterPlotConfiguration' => [ 'base' => '<p>The configuration of a scatter plot.</p>', 'refs' => [ 'ScatterPlotVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'ScatterPlotFieldWells' => [ 'base' => '<p>The field well configuration of a scatter plot.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'ScatterPlotConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'ScatterPlotSortConfiguration' => [ 'base' => '<p>The sort configuration of a scatter plot.</p>', 'refs' => [ 'ScatterPlotConfiguration$SortConfiguration' => '<p>The sort configuration of a scatter plot.</p>', ], ], 'ScatterPlotUnaggregatedFieldWells' => [ 'base' => '<p>The unaggregated field wells of a scatter plot.</p>', 'refs' => [ 'ScatterPlotFieldWells$ScatterPlotUnaggregatedFieldWells' => '<p>The unaggregated field wells of a scatter plot. The x and y-axes of these scatter plots are unaggregated.</p>', ], ], 'ScatterPlotVisual' => [ 'base' => '<p>A scatter plot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$ScatterPlotVisual' => '<p>A scatter plot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'ScheduleRefreshOnEntity' => [ 'base' => '<p>The refresh on entity for weekly or monthly schedules.</p>', 'refs' => [ 'RefreshFrequency$RefreshOnDay' => '<p>The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly refresh intervals.</p>', ], ], 'ScrollBarOptions' => [ 'base' => '<p>The visual display options for a data zoom scroll bar.</p>', 'refs' => [ 'AxisDisplayOptions$ScrollbarOptions' => '<p>The scroll bar options for an axis.</p>', ], ], 'SearchAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAnalysesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchFoldersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFoldersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Seasonality' => [ 'base' => NULL, 'refs' => [ 'TimeBasedForecastProperties$Seasonality' => '<p>The seasonality setup of a forecast computation. Choose one of the following options:</p> <ul> <li> <p> <code>NULL</code>: The input is set to <code>NULL</code>.</p> </li> <li> <p> <code>NON_NULL</code>: The input is set to a custom value.</p> </li> </ul>', ], ], 'SecondaryValueOptions' => [ 'base' => '<p>The options that determine the presentation of the secondary value of a KPI visual.</p>', 'refs' => [ 'KPIOptions$SecondaryValue' => '<p>The options that determine the presentation of the secondary value of a KPI visual.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobDataSourceCredentials$SecretArn' => '<p>The ARN of the Secrets Manager secret that\'s used to create the imported data source. Keep this field blank, unless you are using a secret in place of a credential pair.</p>', 'DataSource$SecretArn' => '<p>The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.</p>', 'DataSourceCredentials$SecretArn' => '<p>The Amazon Resource Name (ARN) of the secret associated with the data source in Amazon Secrets Manager.</p>', ], ], 'SectionAfterPageBreak' => [ 'base' => '<p>The configuration of a page break after a section.</p>', 'refs' => [ 'BodySectionRepeatPageBreakConfiguration$After' => NULL, 'SectionPageBreakConfiguration$After' => '<p>The configuration of a page break after a section.</p>', ], ], 'SectionBasedLayoutCanvasSizeOptions' => [ 'base' => '<p>The options for the canvas of a section-based layout.</p>', 'refs' => [ 'DefaultSectionBasedLayoutConfiguration$CanvasSizeOptions' => '<p>Determines the screen canvas size options for a section-based layout.</p>', 'SectionBasedLayoutConfiguration$CanvasSizeOptions' => '<p>The options for the canvas of a section-based layout.</p>', ], ], 'SectionBasedLayoutConfiguration' => [ 'base' => '<p>The configuration for a section-based layout.</p>', 'refs' => [ 'LayoutConfiguration$SectionBasedLayout' => '<p>A section based layout organizes visuals into multiple sections and has customized header, footer and page break.</p>', ], ], 'SectionBasedLayoutPaperCanvasSizeOptions' => [ 'base' => '<p>The options for a paper canvas of a section-based layout.</p>', 'refs' => [ 'SectionBasedLayoutCanvasSizeOptions$PaperCanvasSizeOptions' => '<p>The options for a paper canvas of a section-based layout.</p>', ], ], 'SectionLayoutConfiguration' => [ 'base' => '<p>The layout configuration of a section.</p>', 'refs' => [ 'BodySectionContent$Layout' => '<p>The layout configuration of a body section.</p>', 'HeaderFooterSectionConfiguration$Layout' => '<p>The layout configuration of the header or footer section.</p>', ], ], 'SectionPageBreakConfiguration' => [ 'base' => '<p>The configuration of a page break for a section.</p>', 'refs' => [ 'BodySectionConfiguration$PageBreakConfiguration' => '<p>The configuration of a page break for a section.</p>', ], ], 'SectionPageBreakStatus' => [ 'base' => NULL, 'refs' => [ 'SectionAfterPageBreak$Status' => '<p>The option that enables or disables a page break at the end of a section.</p>', ], ], 'SectionStyle' => [ 'base' => '<p>The options that style a section.</p>', 'refs' => [ 'BodySectionConfiguration$Style' => '<p>The style options of a body section.</p>', 'HeaderFooterSectionConfiguration$Style' => '<p>The style options of a header or footer section.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParameters$SecurityGroupIds' => '<p>A new security group ID for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.</p>', 'CreateVPCConnectionRequest$SecurityGroupIds' => '<p>A list of security group IDs for the VPC connection.</p>', 'UpdateVPCConnectionRequest$SecurityGroupIds' => '<p>A list of security group IDs for the VPC connection.</p>', 'VPCConnection$SecurityGroupIds' => '<p>The Amazon EC2 security group IDs associated with the VPC connection.</p>', 'VPCConnectionSummary$SecurityGroupIds' => '<p>The Amazon EC2 security group IDs associated with the VPC connection.</p>', ], ], 'SelectAllValueOptions' => [ 'base' => NULL, 'refs' => [ 'DestinationParameterValueConfiguration$SelectAllValueOptions' => '<p>The configuration that selects all options.</p>', ], ], 'SelectedFieldList' => [ 'base' => NULL, 'refs' => [ 'FilterOperationSelectedFieldsConfiguration$SelectedFields' => '<p>Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.</p>', ], ], 'SelectedFieldOptions' => [ 'base' => NULL, 'refs' => [ 'FilterOperationSelectedFieldsConfiguration$SelectedFieldOptions' => '<p>A structure that contains the options that choose which fields are filtered in the <code>CustomActionFilterOperation</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>ALL_FIELDS</code>: Applies the filter operation to all fields.</p> </li> </ul>', ], ], 'SelectedSheetsFilterScopeConfiguration' => [ 'base' => '<p>The configuration for applying a filter to specific sheets or visuals. You can apply this filter to multiple visuals that are on one sheet or to all visuals on a sheet.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'FilterScopeConfiguration$SelectedSheets' => '<p>The configuration for applying a filter to specific sheets.</p>', ], ], 'SelectedTooltipType' => [ 'base' => NULL, 'refs' => [ 'TooltipOptions$SelectedTooltipType' => '<p>The selected type for the tooltip. Choose one of the following options:</p> <ul> <li> <p> <code>BASIC</code>: A basic tooltip.</p> </li> <li> <p> <code>DETAILED</code>: A detailed tooltip.</p> </li> </ul>', ], ], 'SemanticEntityType' => [ 'base' => '<p>A structure that represents a semantic entity type.</p>', 'refs' => [ 'TopicNamedEntity$SemanticEntityType' => '<p>The type of named entity that a topic represents.</p>', ], ], 'SemanticType' => [ 'base' => '<p>A structure that represents a semantic type.</p>', 'refs' => [ 'TopicCalculatedField$SemanticType' => '<p>The semantic type.</p>', 'TopicColumn$SemanticType' => '<p>The semantic type of data contained in the column.</p>', ], ], 'SensitiveDouble' => [ 'base' => NULL, 'refs' => [ 'DecimalValueWhenUnsetConfiguration$CustomValue' => '<p>A custom value that\'s used when the value of a parameter isn\'t set.</p>', 'ReferenceLineStaticDataConfiguration$Value' => '<p>The double input of the static data.</p>', 'SensitiveDoubleList$member' => NULL, ], ], 'SensitiveDoubleList' => [ 'base' => NULL, 'refs' => [ 'DecimalParameter$Values' => '<p>The values for the decimal parameter.</p>', ], ], 'SensitiveDoubleObject' => [ 'base' => NULL, 'refs' => [ 'DecimalDefaultValueList$member' => NULL, ], ], 'SensitiveLong' => [ 'base' => NULL, 'refs' => [ 'IntegerValueWhenUnsetConfiguration$CustomValue' => '<p>A custom value that\'s used when the value of a parameter isn\'t set.</p>', 'SensitiveLongList$member' => NULL, ], ], 'SensitiveLongList' => [ 'base' => NULL, 'refs' => [ 'IntegerParameter$Values' => '<p>The values for the integer parameter.</p>', ], ], 'SensitiveLongObject' => [ 'base' => NULL, 'refs' => [ 'IntegerDefaultValueList$member' => NULL, ], ], 'SensitiveS3Uri' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportSourceDescription$Body' => '<p>An HTTPS download URL for the provided asset bundle that you optionally provided at the start of the import job. This URL is valid for five minutes after issuance. Call <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed. The downloaded asset bundle is a <code>.qs</code> zip file.</p>', 'DescribeAssetBundleExportJobResponse$DownloadUrl' => '<p>The URL to download the exported asset bundle data from.</p> <p>This URL is available only after the job has succeeded. This URL is valid for 5 minutes after issuance. Call <code>DescribeAssetBundleExportJob</code> again for a fresh URL if needed.</p> <p>The downloaded asset bundle is a zip file named <code>assetbundle-{jobId}.qs</code>. The file has a <code>.qs</code> extension.</p> <p>This URL can\'t be used in a <code>StartAssetBundleImportJob</code> API call and should only be used for download purposes.</p>', 'SnapshotJobS3Result$S3Uri' => '<p>The Amazon S3 Uri.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'DataFieldSeriesItem$FieldValue' => '<p>The field value of the field that you are setting the axis binding to.</p>', 'SemanticType$TruthyCellValue' => '<p>The semantic type truthy cell value.</p>', 'SemanticType$FalseyCellValue' => '<p>The semantic type falsey cell value.</p>', 'SensitiveStringList$member' => NULL, 'StringValueWhenUnsetConfiguration$CustomValue' => '<p>A custom value that\'s used when the value of a parameter isn\'t set.</p>', ], ], 'SensitiveStringList' => [ 'base' => NULL, 'refs' => [ 'SemanticType$TruthyCellValueSynonyms' => '<p>The other names or aliases for the true cell value.</p>', 'SemanticType$FalseyCellValueSynonyms' => '<p>The other names or aliases for the false cell value.</p>', 'StringParameter$Values' => '<p>The values of a string parameter.</p>', ], ], 'SensitiveStringObject' => [ 'base' => NULL, 'refs' => [ 'StringDefaultValueList$member' => NULL, ], ], 'SensitiveTimestamp' => [ 'base' => NULL, 'refs' => [ 'DateTimeDefaultValueList$member' => NULL, 'DateTimeValueWhenUnsetConfiguration$CustomValue' => '<p>A custom value that\'s used when the value of a parameter isn\'t set.</p>', 'SensitiveTimestampList$member' => NULL, ], ], 'SensitiveTimestampList' => [ 'base' => NULL, 'refs' => [ 'DateTimeParameter$Values' => '<p>The values for the date-time parameter.</p>', ], ], 'SeriesItem' => [ 'base' => '<p>The series item configuration of a line chart.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'SeriesItemList$member' => NULL, ], ], 'SeriesItemList' => [ 'base' => NULL, 'refs' => [ 'LineChartConfiguration$Series' => '<p>The series item configuration of a line chart.</p>', ], ], 'ServiceNowParameters' => [ 'base' => '<p>The parameters for ServiceNow.</p>', 'refs' => [ 'DataSourceParameters$ServiceNowParameters' => '<p>The parameters for ServiceNow.</p>', ], ], 'ServiceType' => [ 'base' => NULL, 'refs' => [ 'AuthorizedTargetsByService$Service' => '<p>The name of the Amazon Web Services service.</p>', 'DeleteIdentityPropagationConfigRequest$Service' => '<p>The name of the Amazon Web Services service that you want to delete the associated access scopes and authorized targets from.</p>', 'UpdateIdentityPropagationConfigRequest$Service' => '<p>The name of the Amazon Web Services service that contains the authorized targets that you want to add or update.</p>', ], ], 'SessionLifetimeInMinutes' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>', 'GetDashboardEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', 'GetSessionEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', ], ], 'SessionLifetimeInMinutesInvalidException' => [ 'base' => '<p>The number of minutes specified for the lifetime of a session isn\'t valid. The session lifetime must be 15-600 minutes.</p>', 'refs' => [], ], 'SessionTag' => [ 'base' => '<p>The key-value pair used for the row-level security tags feature.</p>', 'refs' => [ 'SessionTagList$member' => NULL, ], ], 'SessionTagKey' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$TagKey' => '<p>The unique key for a tag.</p>', 'RowLevelPermissionTagRuleConfiguration$member' => NULL, 'SessionTag$Key' => '<p>The key for the tag.</p>', 'SessionTagKeyList$member' => NULL, ], ], 'SessionTagKeyList' => [ 'base' => NULL, 'refs' => [ 'SnapshotAnonymousUserRedacted$RowLevelPermissionTagKeys' => '<p>The tag keys for the <code>RowLevelPermissionTags</code>.</p>', ], ], 'SessionTagList' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$SessionTags' => '<p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p> <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.</p>', 'SnapshotAnonymousUser$RowLevelPermissionTags' => '<p>The tags to be used for row-level security (RLS). Make sure that the relevant datasets have RLS tags configured before you start a snapshot export job. You can configure the RLS tags of a dataset with a <code>DataSet$RowLevelPermissionTagConfiguration</code> API call.</p> <p>These are not the tags that are used for Amazon Web Services resource tagging. For more information on row level security in Amazon QuickSight, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'SessionTagValue' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$MatchAllValue' => '<p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>', 'SessionTag$Value' => '<p>The value that you want to assign the tag.</p>', ], ], 'SetParameterValueConfiguration' => [ 'base' => '<p>The configuration of adding parameters in action.</p>', 'refs' => [ 'SetParameterValueConfigurationList$member' => NULL, ], ], 'SetParameterValueConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CustomActionSetParametersOperation$ParameterValueConfigurations' => '<p>The parameter that determines the value configuration.</p>', ], ], 'ShapeConditionalFormat' => [ 'base' => '<p>The shape conditional formatting of a filled map visual.</p>', 'refs' => [ 'FilledMapShapeConditionalFormatting$Format' => '<p>The conditional formatting that determines the background color of a filled map\'s shape.</p>', ], ], 'SharedViewConfigurations' => [ 'base' => '<p>The shared view settings of an embedded dashboard.</p>', 'refs' => [ 'AnonymousUserDashboardFeatureConfigurations$SharedView' => '<p>The shared view settings of an embedded dashboard.</p>', 'RegisteredUserConsoleFeatureConfigurations$SharedView' => '<p>The shared view settings of an embedded dashboard.</p>', 'RegisteredUserDashboardFeatureConfigurations$SharedView' => '<p>The shared view settings of an embedded dashboard.</p>', ], ], 'SharingModel' => [ 'base' => NULL, 'refs' => [ 'CreateFolderRequest$SharingModel' => '<p>An optional parameter that determines the sharing scope of the folder. The default value for this parameter is <code>ACCOUNT</code>.</p>', 'Folder$SharingModel' => '<p>The sharing scope of the folder.</p>', 'FolderSummary$SharingModel' => '<p>The sharing scope of the folder.</p>', ], ], 'Sheet' => [ 'base' => '<p>A <i>sheet</i>, which is an object that contains a set of visuals that are viewed together on one page in Amazon QuickSight. Every analysis and dashboard contains at least one sheet. Each sheet contains at least one visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other components, such as controls, filters, and so on.</p>', 'refs' => [ 'SheetList$member' => NULL, ], ], 'SheetContentType' => [ 'base' => NULL, 'refs' => [ 'DefaultNewSheetConfiguration$SheetContentType' => '<p>The option that determines the sheet content type.</p>', 'SheetDefinition$ContentType' => '<p>The layout content type of the sheet. Choose one of the following options:</p> <ul> <li> <p> <code>PAGINATED</code>: Creates a sheet for a paginated report.</p> </li> <li> <p> <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.</p> </li> </ul>', ], ], 'SheetControlDateTimePickerType' => [ 'base' => NULL, 'refs' => [ 'DefaultDateTimePickerControlOptions$Type' => '<p>The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the following options:</p> <ul> <li> <p> <code>SINGLE_VALUED</code>: The filter condition is a fixed date.</p> </li> <li> <p> <code>DATE_RANGE</code>: The filter condition is a date time range.</p> </li> </ul>', 'FilterDateTimePickerControl$Type' => '<p>The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p> <ul> <li> <p> <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.</p> </li> <li> <p> <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.</p> </li> </ul>', ], ], 'SheetControlInfoIconLabelOptions' => [ 'base' => '<p>A control to display info icons for filters and parameters.</p>', 'refs' => [ 'DateTimePickerControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'DropDownControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'ListControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'RelativeDateTimeControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'SliderControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'TextAreaControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', 'TextFieldControlDisplayOptions$InfoIconLabelOptions' => '<p>The configuration of info icon label options.</p>', ], ], 'SheetControlInfoIconText' => [ 'base' => NULL, 'refs' => [ 'SheetControlInfoIconLabelOptions$InfoIconText' => '<p> The text content of info icon.</p>', ], ], 'SheetControlLayout' => [ 'base' => '<p>A grid layout to define the placement of sheet control.</p>', 'refs' => [ 'SheetControlLayoutList$member' => NULL, ], ], 'SheetControlLayoutConfiguration' => [ 'base' => '<p>The configuration that determines the elements and canvas size options of sheet control.</p>', 'refs' => [ 'SheetControlLayout$Configuration' => '<p>The configuration that determines the elements and canvas size options of sheet control.</p>', ], ], 'SheetControlLayoutList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$SheetControlLayouts' => '<p>The control layouts of the sheet.</p>', ], ], 'SheetControlListType' => [ 'base' => NULL, 'refs' => [ 'DefaultFilterDropDownControlOptions$Type' => '<p>The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p> <ul> <li> <p> <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.</p> </li> <li> <p> <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.</p> </li> </ul>', 'DefaultFilterListControlOptions$Type' => '<p>The type of the <code>DefaultFilterListControlOptions</code>. Choose one of the following options:</p> <ul> <li> <p> <code>MULTI_SELECT</code>: The user can select multiple entries from the list.</p> </li> <li> <p> <code>SINGLE_SELECT</code>: The user can select a single entry from the list.</p> </li> </ul>', 'FilterDropDownControl$Type' => '<p>The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p> <ul> <li> <p> <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.</p> </li> <li> <p> <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.</p> </li> </ul>', 'FilterListControl$Type' => '<p>The type of the <code>FilterListControl</code>. Choose one of the following options:</p> <ul> <li> <p> <code>MULTI_SELECT</code>: The user can select multiple entries from the list.</p> </li> <li> <p> <code>SINGLE_SELECT</code>: The user can select a single entry from the list.</p> </li> </ul>', 'ParameterDropDownControl$Type' => '<p>The type parameter name of the <code>ParameterDropDownControl</code>.</p>', 'ParameterListControl$Type' => '<p>The type of <code>ParameterListControl</code>.</p>', ], ], 'SheetControlSliderType' => [ 'base' => NULL, 'refs' => [ 'DefaultSliderControlOptions$Type' => '<p>The type of the <code>DefaultSliderControlOptions</code>. Choose one of the following options:</p> <ul> <li> <p> <code>SINGLE_POINT</code>: Filter against(equals) a single data point.</p> </li> <li> <p> <code>RANGE</code>: Filter data that is in a specified range.</p> </li> </ul>', 'FilterSliderControl$Type' => '<p>The type of the <code>FilterSliderControl</code>. Choose one of the following options:</p> <ul> <li> <p> <code>SINGLE_POINT</code>: Filter against(equals) a single data point.</p> </li> <li> <p> <code>RANGE</code>: Filter data that is in a specified range.</p> </li> </ul>', ], ], 'SheetControlTitle' => [ 'base' => NULL, 'refs' => [ 'DefaultFilterControlConfiguration$Title' => '<p>The title of the <code>DefaultFilterControlConfiguration</code>. This title is shared by all controls that are tied to this filter.</p>', 'FilterDateTimePickerControl$Title' => '<p>The title of the <code>FilterDateTimePickerControl</code>.</p>', 'FilterDropDownControl$Title' => '<p>The title of the <code>FilterDropDownControl</code>.</p>', 'FilterListControl$Title' => '<p>The title of the <code>FilterListControl</code>.</p>', 'FilterRelativeDateTimeControl$Title' => '<p>The title of the <code>FilterTextAreaControl</code>.</p>', 'FilterSliderControl$Title' => '<p>The title of the <code>FilterSliderControl</code>.</p>', 'FilterTextAreaControl$Title' => '<p>The title of the <code>FilterTextAreaControl</code>.</p>', 'FilterTextFieldControl$Title' => '<p>The title of the <code>FilterTextFieldControl</code>.</p>', 'ParameterDateTimePickerControl$Title' => '<p>The title of the <code>ParameterDateTimePickerControl</code>.</p>', 'ParameterDropDownControl$Title' => '<p>The title of the <code>ParameterDropDownControl</code>.</p>', 'ParameterListControl$Title' => '<p>The title of the <code>ParameterListControl</code>.</p>', 'ParameterSliderControl$Title' => '<p>The title of the <code>ParameterSliderControl</code>.</p>', 'ParameterTextAreaControl$Title' => '<p>The title of the <code>ParameterTextAreaControl</code>.</p>', 'ParameterTextFieldControl$Title' => '<p>The title of the <code>ParameterTextFieldControl</code>.</p>', ], ], 'SheetControlsOption' => [ 'base' => '<p>Sheet controls option.</p>', 'refs' => [ 'DashboardPublishOptions$SheetControlsOption' => '<p>Sheet controls option.</p>', ], ], 'SheetDefinition' => [ 'base' => '<p>A sheet is an object that contains a set of visuals that are viewed together on one page in a paginated report. Every analysis and dashboard must contain at least one sheet.</p>', 'refs' => [ 'SheetDefinitionList$member' => NULL, ], ], 'SheetDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AnalysisDefinition$Sheets' => '<p>An array of sheet definitions for an analysis. Each <code>SheetDefinition</code> provides detailed information about a sheet within this analysis.</p>', 'DashboardVersionDefinition$Sheets' => '<p>An array of sheet definitions for a dashboard.</p>', 'TemplateVersionDefinition$Sheets' => '<p>An array of sheet definitions for a template.</p>', ], ], 'SheetDescription' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$Description' => '<p>A description of the sheet.</p>', ], ], 'SheetElementConfigurationOverrides' => [ 'base' => '<p>The override configuration of the rendering rules of a sheet.</p>', 'refs' => [ 'SheetElementRenderingRule$ConfigurationOverrides' => '<p>The override configuration of the rendering rules of a sheet.</p>', ], ], 'SheetElementRenderingRule' => [ 'base' => '<p>The rendering rules of a sheet that uses a free-form layout.</p>', 'refs' => [ 'SheetElementRenderingRuleList$member' => NULL, ], ], 'SheetElementRenderingRuleList' => [ 'base' => NULL, 'refs' => [ 'FreeFormLayoutElement$RenderingRules' => '<p>The rendering rules that determine when an element should be displayed within a free-form layout.</p>', ], ], 'SheetLayoutElementMaximizationOption' => [ 'base' => '<p>The sheet layout maximization options of a dashbaord.</p>', 'refs' => [ 'DashboardPublishOptions$SheetLayoutElementMaximizationOption' => '<p>The sheet layout maximization options of a dashbaord.</p>', ], ], 'SheetList' => [ 'base' => NULL, 'refs' => [ 'Analysis$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', 'DashboardVersion$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', 'TemplateVersion$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', ], ], 'SheetName' => [ 'base' => NULL, 'refs' => [ 'Sheet$Name' => '<p>The name of a sheet. This name is displayed on the sheet\'s tab in the Amazon QuickSight console.</p>', 'SheetDefinition$Name' => '<p>The name of the sheet. This name is displayed on the sheet\'s tab in the Amazon QuickSight console.</p>', ], ], 'SheetStyle' => [ 'base' => '<p>The theme display options for sheets. </p>', 'refs' => [ 'ThemeConfiguration$Sheet' => '<p>Display options related to sheets.</p>', ], ], 'SheetTextBox' => [ 'base' => '<p>A text box.</p>', 'refs' => [ 'SheetTextBoxList$member' => NULL, ], ], 'SheetTextBoxContent' => [ 'base' => NULL, 'refs' => [ 'SheetTextBox$Content' => '<p>The content that is displayed in the text box.</p>', ], ], 'SheetTextBoxList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$TextBoxes' => '<p>The text boxes that are on a sheet.</p>', ], ], 'SheetTitle' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$Title' => '<p>The title of the sheet.</p>', ], ], 'SheetVisualScopingConfiguration' => [ 'base' => '<p>The filter that is applied to the options.</p>', 'refs' => [ 'SheetVisualScopingConfigurations$member' => NULL, ], ], 'SheetVisualScopingConfigurations' => [ 'base' => NULL, 'refs' => [ 'SelectedSheetsFilterScopeConfiguration$SheetVisualScopingConfigurations' => '<p>The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.</p>', ], ], 'ShortFormatText' => [ 'base' => '<p>The text format for the title.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'VisualTitleLabelOptions$FormatText' => '<p>The short text format of the title label, such as plain text or rich text.</p>', ], ], 'ShortPlainText' => [ 'base' => NULL, 'refs' => [ 'ShortFormatText$PlainText' => '<p>Plain text format.</p>', ], ], 'ShortRestrictiveResourceId' => [ 'base' => NULL, 'refs' => [ 'AdditionalDashboardIdList$member' => NULL, 'Analysis$AnalysisId' => '<p>The ID of the analysis.</p>', 'AnalysisSummary$AnalysisId' => '<p>The ID of the analysis. This ID displays in the URL.</p>', 'AnonymousUserDashboardEmbeddingConfiguration$InitialDashboardId' => '<p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p> <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>', 'AssetBundleExportJobSummary$AssetBundleExportJobId' => '<p>The ID of the export job.</p>', 'AssetBundleImportJobSummary$AssetBundleImportJobId' => '<p>The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID for another job.</p>', 'BarChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'BodySectionConfiguration$SectionId' => '<p>The unique identifier of a body section.</p>', 'BoxPlotVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'CategoryFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'ComboChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'CreateAnalysisRequest$AnalysisId' => '<p>The ID for the analysis that you\'re creating. This ID displays in the URL of the analysis.</p>', 'CreateAnalysisResponse$AnalysisId' => '<p>The ID of the analysis.</p>', 'CreateDashboardRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAM policy.</p>', 'CreateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'CreateTemplateAliasRequest$TemplateId' => '<p>An ID for the template.</p>', 'CreateTemplateRequest$TemplateId' => '<p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>', 'CreateTemplateResponse$TemplateId' => '<p>The ID of the template.</p>', 'CreateThemeAliasRequest$ThemeId' => '<p>An ID for the theme alias.</p>', 'CreateThemeRequest$ThemeId' => '<p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>', 'CreateThemeRequest$BaseThemeId' => '<p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>', 'CreateThemeResponse$ThemeId' => '<p>The ID of the theme.</p>', 'CustomContentVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'Dashboard$DashboardId' => '<p>Dashboard ID.</p>', 'DashboardSummary$DashboardId' => '<p>Dashboard ID.</p>', 'DashboardVisualId$DashboardId' => '<p>The ID of the dashboard that has the visual that you want to embed. The <code>DashboardId</code> can be found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual\'s on-visual menu of the Amazon QuickSight console. You can also get the <code>DashboardId</code> with a <code>ListDashboards</code> API operation.</p>', 'DashboardVisualId$SheetId' => '<p>The ID of the sheet that the has visual that you want to embed. The <code>SheetId</code> can be found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual\'s on-visual menu of the Amazon QuickSight console.</p>', 'DashboardVisualId$VisualId' => '<p>The ID of the visual that you want to embed. The <code>VisualID</code> can be found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual\'s on-visual menu of the Amazon QuickSight console.</p>', 'DeleteAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re deleting.</p>', 'DeleteAnalysisResponse$AnalysisId' => '<p>The ID of the deleted analysis.</p>', 'DeleteDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DeleteDashboardResponse$DashboardId' => '<p>The ID of the dashboard.</p>', 'DeleteTemplateAliasRequest$TemplateId' => '<p>The ID for the template that the specified alias is for.</p>', 'DeleteTemplateAliasResponse$TemplateId' => '<p>An ID for the template associated with the deletion.</p>', 'DeleteTemplateRequest$TemplateId' => '<p>An ID for the template you want to delete.</p>', 'DeleteTemplateResponse$TemplateId' => '<p>An ID for the template.</p>', 'DeleteThemeAliasRequest$ThemeId' => '<p>The ID for the theme that the specified alias is for.</p>', 'DeleteThemeAliasResponse$ThemeId' => '<p>An ID for the theme associated with the deletion.</p>', 'DeleteThemeRequest$ThemeId' => '<p>An ID for the theme that you want to delete.</p>', 'DeleteThemeResponse$ThemeId' => '<p>An ID for the theme.</p>', 'DescribeAnalysisDefinitionRequest$AnalysisId' => '<p>The ID of the analysis that you\'re describing. The ID is part of the URL of the analysis.</p>', 'DescribeAnalysisDefinitionResponse$AnalysisId' => '<p>The ID of the analysis described.</p>', 'DescribeAnalysisPermissionsRequest$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re describing. The ID is part of the analysis URL.</p>', 'DescribeAnalysisPermissionsResponse$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re describing.</p>', 'DescribeAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re describing. The ID is part of the URL of the analysis.</p>', 'DescribeAssetBundleExportJobRequest$AssetBundleExportJobId' => '<p>The ID of the job that you want described. The job ID is set when you start a new job with a <code>StartAssetBundleExportJob</code> API call.</p>', 'DescribeAssetBundleExportJobResponse$AssetBundleExportJobId' => '<p>The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleExportJob</code> API call.</p>', 'DescribeAssetBundleImportJobRequest$AssetBundleImportJobId' => '<p>The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleImportJob</code> API call.</p>', 'DescribeAssetBundleImportJobResponse$AssetBundleImportJobId' => '<p>The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleImportJob</code> API call.</p>', 'DescribeDashboardDefinitionRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeDashboardDefinitionResponse$DashboardId' => '<p>The ID of the dashboard described.</p>', 'DescribeDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAM policy.</p>', 'DescribeDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeDashboardSnapshotJobRequest$DashboardId' => '<p>The ID of the dashboard that you have started a snapshot job for.</p>', 'DescribeDashboardSnapshotJobRequest$SnapshotJobId' => '<p>The ID of the job to be described. The job ID is set when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'DescribeDashboardSnapshotJobResponse$DashboardId' => '<p>The ID of the dashboard that you have started a snapshot job for.</p>', 'DescribeDashboardSnapshotJobResponse$SnapshotJobId' => '<p>The ID of the job to be described. The job ID is set when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'DescribeDashboardSnapshotJobResultRequest$DashboardId' => '<p>The ID of the dashboard that you have started a snapshot job for.</p>', 'DescribeDashboardSnapshotJobResultRequest$SnapshotJobId' => '<p>The ID of the job to be described. The job ID is set when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'DescribeTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplateDefinitionRequest$TemplateId' => '<p>The ID of the template that you\'re describing.</p>', 'DescribeTemplateDefinitionResponse$TemplateId' => '<p>The ID of the template described.</p>', 'DescribeTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemePermissionsRequest$ThemeId' => '<p>The ID for the theme that you want to describe permissions for.</p>', 'DescribeThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'EmptyVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'FilledMapVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'FilterCrossSheetControl$FilterControlId' => '<p>The ID of the <code>FilterCrossSheetControl</code>.</p>', 'FilterCrossSheetControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterCrossSheetControl</code>.</p>', 'FilterDateTimePickerControl$FilterControlId' => '<p>The ID of the <code>FilterDateTimePickerControl</code>.</p>', 'FilterDateTimePickerControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterDateTimePickerControl</code>.</p>', 'FilterDropDownControl$FilterControlId' => '<p>The ID of the <code>FilterDropDownControl</code>.</p>', 'FilterDropDownControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterDropDownControl</code>.</p>', 'FilterGroup$FilterGroupId' => '<p>The value that uniquely identifies a <code>FilterGroup</code> within a dashboard, template, or analysis.</p>', 'FilterListControl$FilterControlId' => '<p>The ID of the <code>FilterListControl</code>.</p>', 'FilterListControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterListControl</code>.</p>', 'FilterRelativeDateTimeControl$FilterControlId' => '<p>The ID of the <code>FilterTextAreaControl</code>.</p>', 'FilterRelativeDateTimeControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterTextAreaControl</code>.</p>', 'FilterSliderControl$FilterControlId' => '<p>The ID of the <code>FilterSliderControl</code>.</p>', 'FilterSliderControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterSliderControl</code>.</p>', 'FilterTextAreaControl$FilterControlId' => '<p>The ID of the <code>FilterTextAreaControl</code>.</p>', 'FilterTextAreaControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterTextAreaControl</code>.</p>', 'FilterTextFieldControl$FilterControlId' => '<p>The ID of the <code>FilterTextFieldControl</code>.</p>', 'FilterTextFieldControl$SourceFilterId' => '<p>The source filter ID of the <code>FilterTextFieldControl</code>.</p>', 'FilteredVisualsList$member' => NULL, 'ForecastComputation$ComputationId' => '<p>The ID for a computation.</p>', 'FreeFormLayoutElement$ElementId' => '<p>A unique identifier for an element within a free-form layout.</p>', 'FunnelChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'GaugeChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'GeospatialMapVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'GetDashboardEmbedUrlRequest$DashboardId' => '<p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>', 'GridLayoutElement$ElementId' => '<p>A unique identifier for an element within a grid layout.</p>', 'GrowthRateComputation$ComputationId' => '<p>The ID for a computation.</p>', 'HeaderFooterSectionConfiguration$SectionId' => '<p>The unique identifier of the header or footer section.</p>', 'HeatMapVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'HistogramVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'InsightVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'KPIVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'LineChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'ListDashboardVersionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'ListTemplateAliasesRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListTemplateVersionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListThemeAliasesRequest$ThemeId' => '<p>The ID for the theme.</p>', 'ListThemeVersionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'LocalNavigationConfiguration$TargetSheetId' => '<p>The sheet that is targeted for navigation in the same analysis.</p>', 'MaximumMinimumComputation$ComputationId' => '<p>The ID for a computation.</p>', 'MetricComparisonComputation$ComputationId' => '<p>The ID for a computation.</p>', 'NestedFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'NonRepeatingVisualsList$member' => NULL, 'NumericEqualityFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'NumericRangeFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'ParameterDateTimePickerControl$ParameterControlId' => '<p>The ID of the <code>ParameterDateTimePickerControl</code>.</p>', 'ParameterDropDownControl$ParameterControlId' => '<p>The ID of the <code>ParameterDropDownControl</code>.</p>', 'ParameterListControl$ParameterControlId' => '<p>The ID of the <code>ParameterListControl</code>.</p>', 'ParameterSliderControl$ParameterControlId' => '<p>The ID of the <code>ParameterSliderControl</code>.</p>', 'ParameterTextAreaControl$ParameterControlId' => '<p>The ID of the <code>ParameterTextAreaControl</code>.</p>', 'ParameterTextFieldControl$ParameterControlId' => '<p>The ID of the <code>ParameterTextFieldControl</code>.</p>', 'PeriodOverPeriodComputation$ComputationId' => '<p>The ID for a computation.</p>', 'PeriodToDateComputation$ComputationId' => '<p>The ID for a computation.</p>', 'PieChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'PivotTableVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'RadarChartVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'RegisteredUserDashboardEmbeddingConfiguration$InitialDashboardId' => '<p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p> <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>', 'RelativeDatesFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'RestoreAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re restoring.</p>', 'RestoreAnalysisResponse$AnalysisId' => '<p>The ID of the analysis that you\'re restoring. </p>', 'SankeyDiagramVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'ScatterPlotVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'Sheet$SheetId' => '<p>The unique identifier associated with a sheet.</p>', 'SheetDefinition$SheetId' => '<p>The unique identifier of a sheet.</p>', 'SheetTextBox$SheetTextBoxId' => '<p>The unique identifier for a text box. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have text boxes that share identifiers.</p>', 'SheetVisualScopingConfiguration$SheetId' => '<p>The selected sheet that the filter is applied to.</p>', 'SnapshotFileSheetSelection$SheetId' => '<p>The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV, Excel, and PDF format types.</p>', 'SnapshotFileSheetSelectionVisualIdList$member' => NULL, 'StartAssetBundleExportJobRequest$AssetBundleExportJobId' => '<p>The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID for another job.</p>', 'StartAssetBundleExportJobResponse$AssetBundleExportJobId' => '<p>The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID for another job.</p>', 'StartAssetBundleImportJobRequest$AssetBundleImportJobId' => '<p>The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID for another job.</p>', 'StartAssetBundleImportJobResponse$AssetBundleImportJobId' => '<p>The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID for another job.</p>', 'StartDashboardSnapshotJobRequest$DashboardId' => '<p>The ID of the dashboard that you want to start a snapshot job for. </p>', 'StartDashboardSnapshotJobRequest$SnapshotJobId' => '<p>An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This ID can be used to poll the status of a job with a <code>DescribeDashboardSnapshotJob</code> while the job runs. You can reuse this ID for another job 24 hours after the current job is completed.</p>', 'StartDashboardSnapshotJobResponse$SnapshotJobId' => '<p>The ID of the job. The job ID is set when you start a new job with a <code>StartDashboardSnapshotJob</code> API call.</p>', 'TableVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'TargetVisualList$member' => NULL, 'Template$TemplateId' => '<p>The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'TemplateSummary$TemplateId' => '<p>The ID of the template. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'Theme$ThemeId' => '<p>The identifier that the user gives to the theme.</p>', 'ThemeSummary$ThemeId' => '<p>The ID of the theme. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'ThemeVersion$BaseThemeId' => '<p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>', 'TimeEqualityFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'TimeRangeFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'TopBottomFilter$FilterId' => '<p>An identifier that uniquely identifies a filter within a dashboard, analysis, or template.</p>', 'TopBottomMoversComputation$ComputationId' => '<p>The ID for a computation.</p>', 'TopBottomRankedComputation$ComputationId' => '<p>The ID for a computation.</p>', 'TotalAggregationComputation$ComputationId' => '<p>The ID for a computation.</p>', 'TreeMapVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', 'UniqueValuesComputation$ComputationId' => '<p>The ID for a computation.</p>', 'UpdateAnalysisPermissionsRequest$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re updating. The ID is part of the analysis URL.</p>', 'UpdateAnalysisPermissionsResponse$AnalysisId' => '<p>The ID of the analysis that you updated permissions for.</p>', 'UpdateAnalysisRequest$AnalysisId' => '<p>The ID for the analysis that you\'re updating. This ID displays in the URL of the analysis.</p>', 'UpdateAnalysisResponse$AnalysisId' => '<p>The ID of the analysis.</p>', 'UpdateDashboardLinksRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$BaseThemeId' => '<p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>', 'UpdateThemeResponse$ThemeId' => '<p>The ID for the theme.</p>', 'VisualCustomAction$CustomActionId' => '<p>The ID of the <code>VisualCustomAction</code>.</p>', 'WaterfallVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.</p>', 'WordCloudVisual$VisualId' => '<p>The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..</p>', ], ], 'ShortRichText' => [ 'base' => NULL, 'refs' => [ 'ShortFormatText$RichText' => '<p>Rich text. Examples of rich text include bold, underline, and italics.</p>', ], ], 'SignupResponse' => [ 'base' => '<p>A <code>SignupResponse</code> object that contains a summary of a newly created account.</p>', 'refs' => [ 'CreateAccountSubscriptionResponse$SignupResponse' => '<p>A <code>SignupResponse</code> object that returns information about a newly created Amazon QuickSight account.</p>', ], ], 'SimpleAttributeAggregationFunction' => [ 'base' => NULL, 'refs' => [ 'AttributeAggregationFunction$SimpleAttributeAggregation' => '<p>The built-in aggregation functions for attributes.</p> <ul> <li> <p> <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.</p> </li> </ul>', ], ], 'SimpleClusterMarker' => [ 'base' => '<p>The simple cluster marker of the cluster marker.</p>', 'refs' => [ 'ClusterMarker$SimpleClusterMarker' => '<p>The simple cluster marker of the cluster marker.</p>', ], ], 'SimpleNumericalAggregationFunction' => [ 'base' => NULL, 'refs' => [ 'NumericalAggregationFunction$SimpleNumericalAggregation' => '<p>Built-in aggregation functions for numerical values.</p> <ul> <li> <p> <code>SUM</code>: The sum of a dimension or measure. </p> </li> <li> <p> <code>AVERAGE</code>: The average of a dimension or measure.</p> </li> <li> <p> <code>MIN</code>: The minimum value of a dimension or measure.</p> </li> <li> <p> <code>MAX</code>: The maximum value of a dimension or measure.</p> </li> <li> <p> <code>COUNT</code>: The count of a dimension or measure.</p> </li> <li> <p> <code>DISTINCT_COUNT</code>: The count of distinct values in a dimension or measure.</p> </li> <li> <p> <code>VAR</code>: The variance of a dimension or measure.</p> </li> <li> <p> <code>VARP</code>: The partitioned variance of a dimension or measure.</p> </li> <li> <p> <code>STDEV</code>: The standard deviation of a dimension or measure.</p> </li> <li> <p> <code>STDEVP</code>: The partitioned standard deviation of a dimension or measure.</p> </li> <li> <p> <code>MEDIAN</code>: The median value of a dimension or measure.</p> </li> </ul>', ], ], 'SimpleTotalAggregationFunction' => [ 'base' => NULL, 'refs' => [ 'TotalAggregationFunction$SimpleTotalAggregationFunction' => '<p>A built in aggregation function for total values.</p>', ], ], 'SingleAxisOptions' => [ 'base' => '<p>The settings of a chart\'s single axis configuration.</p>', 'refs' => [ 'ComboChartConfiguration$SingleAxisOptions' => NULL, 'LineChartConfiguration$SingleAxisOptions' => NULL, ], ], 'SingleYAxisOption' => [ 'base' => NULL, 'refs' => [ 'YAxisOptions$YAxis' => '<p>The Y axis type to be used in the chart.</p> <p>If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of the chart.</p>', ], ], 'SiteBaseUrl' => [ 'base' => NULL, 'refs' => [ 'JiraParameters$SiteBaseUrl' => '<p>The base URL of the Jira site.</p>', 'ServiceNowParameters$SiteBaseUrl' => '<p>URL of the base site.</p>', ], ], 'SliderControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultSliderControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterSliderControl$DisplayOptions' => '<p>The display options of a control.</p>', 'ParameterSliderControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'Slot' => [ 'base' => '<p>The definition for the slot.</p>', 'refs' => [ 'Slots$member' => NULL, ], ], 'Slots' => [ 'base' => NULL, 'refs' => [ 'TopicTemplate$Slots' => '<p>The slots for the <code>TopicTemplate</code>.</p>', ], ], 'SmallMultiplesAxisPlacement' => [ 'base' => NULL, 'refs' => [ 'SmallMultiplesAxisProperties$Placement' => '<p>Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.</p>', ], ], 'SmallMultiplesAxisProperties' => [ 'base' => '<p>Configures the properties of a chart\'s axes that are used by small multiples panels.</p>', 'refs' => [ 'SmallMultiplesOptions$XAxis' => '<p>The properties of a small multiples X axis.</p>', 'SmallMultiplesOptions$YAxis' => '<p>The properties of a small multiples Y axis.</p>', ], ], 'SmallMultiplesAxisScale' => [ 'base' => NULL, 'refs' => [ 'SmallMultiplesAxisProperties$Scale' => '<p>Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.</p>', ], ], 'SmallMultiplesDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'BarChartAggregatedFieldWells$SmallMultiples' => '<p>The small multiples field well of a bar chart.</p>', 'LineChartAggregatedFieldWells$SmallMultiples' => '<p>The small multiples field well of a line chart.</p>', 'PieChartAggregatedFieldWells$SmallMultiples' => '<p>The small multiples field well of a pie chart.</p>', ], ], 'SmallMultiplesOptions' => [ 'base' => '<p>Options that determine the layout and display options of a chart\'s small multiples.</p>', 'refs' => [ 'BarChartConfiguration$SmallMultiplesOptions' => '<p>The small multiples setup for the visual.</p>', 'LineChartConfiguration$SmallMultiplesOptions' => '<p>The small multiples setup for the visual.</p>', 'PieChartConfiguration$SmallMultiplesOptions' => '<p>The small multiples setup for the visual.</p>', ], ], 'SnapshotAnonymousUser' => [ 'base' => '<p>A structure that contains information on the anonymous user configuration.</p>', 'refs' => [ 'SnapshotAnonymousUserList$member' => NULL, ], ], 'SnapshotAnonymousUserList' => [ 'base' => NULL, 'refs' => [ 'SnapshotUserConfiguration$AnonymousUsers' => '<p>An array of records that describe the anonymous users that the dashboard snapshot is generated for.</p>', ], ], 'SnapshotAnonymousUserRedacted' => [ 'base' => '<p>Use this structure to redact sensitive information that you provide about an anonymous user from the snapshot.</p>', 'refs' => [ 'SnapshotAnonymousUserRedactedList$member' => NULL, ], ], 'SnapshotAnonymousUserRedactedList' => [ 'base' => NULL, 'refs' => [ 'SnapshotUserConfigurationRedacted$AnonymousUsers' => '<p> An array of records that describe anonymous users that the dashboard snapshot is generated for. Sensitive user information is excluded. </p>', ], ], 'SnapshotConfiguration' => [ 'base' => '<p>Describes the configuration of the dashboard snapshot.</p>', 'refs' => [ 'DescribeDashboardSnapshotJobResponse$SnapshotConfiguration' => '<p>The snapshot configuration of the job. This information is provided when you make a <code>StartDashboardSnapshotJob</code> API call.</p>', 'StartDashboardSnapshotJobRequest$SnapshotConfiguration' => '<p>A structure that describes the configuration of the dashboard snapshot.</p>', ], ], 'SnapshotDestinationConfiguration' => [ 'base' => '<p>A structure that contains information on the Amazon S3 destinations of the generated snapshot.</p>', 'refs' => [ 'SnapshotConfiguration$DestinationConfiguration' => '<p>A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.</p>', ], ], 'SnapshotFile' => [ 'base' => '<p>A structure that contains the information for the snapshot that you want to generate. This information is provided by you when you start a new snapshot job.</p>', 'refs' => [ 'SnapshotFileList$member' => NULL, ], ], 'SnapshotFileFormatType' => [ 'base' => NULL, 'refs' => [ 'SnapshotFile$FormatType' => '<p>The format of the snapshot file to be generated. You can choose between <code>CSV</code>, <code>Excel</code>, or <code>PDF</code>.</p>', ], ], 'SnapshotFileGroup' => [ 'base' => '<p>A structure that contains the information on the snapshot files.</p>', 'refs' => [ 'SnapshotFileGroupList$member' => NULL, ], ], 'SnapshotFileGroupList' => [ 'base' => NULL, 'refs' => [ 'SnapshotConfiguration$FileGroups' => '<p>A list of <code>SnapshotJobResultFileGroup</code> objects that contain information about the snapshot that is generated. This list can hold a maximum of 6 <code>FileGroup</code> configurations.</p>', ], ], 'SnapshotFileList' => [ 'base' => NULL, 'refs' => [ 'SnapshotFileGroup$Files' => '<p>A list of <code>SnapshotFile</code> objects that contain the information on the snapshot files that need to be generated. This structure can hold 1 configuration at a time.</p>', 'SnapshotJobResultFileGroup$Files' => '<p> A list of <code>SnapshotFile</code> objects.</p>', ], ], 'SnapshotFileSheetSelection' => [ 'base' => '<p>A structure that contains information that identifies the snapshot that needs to be generated.</p>', 'refs' => [ 'SnapshotFileSheetSelectionList$member' => NULL, ], ], 'SnapshotFileSheetSelectionList' => [ 'base' => NULL, 'refs' => [ 'SnapshotFile$SheetSelections' => '<p>A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet that is exported. These objects provide information about the snapshot artifacts that are generated during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1 configuration for PDF.</p>', ], ], 'SnapshotFileSheetSelectionScope' => [ 'base' => NULL, 'refs' => [ 'SnapshotFileSheetSelection$SelectionScope' => '<p>The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can choose one of the following options.</p> <ul> <li> <p> <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the snapshot is a PDF.</p> </li> <li> <p> <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is required if the snapshot is a CSV or Excel workbook.</p> </li> </ul>', ], ], 'SnapshotFileSheetSelectionVisualIdList' => [ 'base' => NULL, 'refs' => [ 'SnapshotFileSheetSelection$VisualIds' => '<p> A structure that lists the IDs of the visuals in the selected sheet. Supported visual types are table, pivot table visuals. This value is required if you are generating a CSV or Excel workbook. This value supports a maximum of 1 visual ID for CSV and 5 visual IDs across up to 5 sheet selections for Excel. If you are generating an Excel workbook, the order of the visual IDs provided in this structure determines the order of the worksheets in the Excel file. </p>', ], ], 'SnapshotJobErrorInfo' => [ 'base' => '<p>An object that contains information on the error that caused the snapshot job to fail.</p>', 'refs' => [ 'DescribeDashboardSnapshotJobResultResponse$ErrorInfo' => '<p>Displays information for the error that caused a job to fail.</p>', ], ], 'SnapshotJobResult' => [ 'base' => '<p>An object that provides information on the result of a snapshot job. This object provides information about the job, the job status, and the location of the generated file.</p>', 'refs' => [ 'DescribeDashboardSnapshotJobResultResponse$Result' => '<p>The result of the snapshot job. Jobs that have successfully completed will return the S3Uri where they are located. Jobs that have failedwill return information on the error that caused the job to fail.</p>', ], ], 'SnapshotJobResultErrorInfo' => [ 'base' => '<p>Information on the error that caused the snapshot job to fail.</p>', 'refs' => [ 'SnapshotJobResultErrorInfoList$member' => NULL, ], ], 'SnapshotJobResultErrorInfoList' => [ 'base' => NULL, 'refs' => [ 'SnapshotJobS3Result$ErrorInfo' => '<p>An array of error records that describe any failures that occur while the dashboard snapshot job runs.</p>', ], ], 'SnapshotJobResultFileGroup' => [ 'base' => '<p>A structure that contains information on the generated snapshot file groups.</p>', 'refs' => [ 'SnapshotJobResultFileGroupList$member' => NULL, ], ], 'SnapshotJobResultFileGroupList' => [ 'base' => NULL, 'refs' => [ 'AnonymousUserSnapshotJobResult$FileGroups' => '<p>A list of <code>SnapshotJobResultFileGroup</code> objects that contain information on the files that are requested during a <code>StartDashboardSnapshotJob</code> API call. If the job succeeds, these objects contain the location where the snapshot artifacts are stored. If the job fails, the objects contain information about the error that caused the job to fail.</p>', ], ], 'SnapshotJobS3Result' => [ 'base' => '<p>The Amazon S3 result from the snapshot job. The result includes the <code>DestinationConfiguration</code> and the Amazon S3 Uri. If an error occured during the job, the result returns information on the error.</p>', 'refs' => [ 'SnapshotJobS3ResultList$member' => NULL, ], ], 'SnapshotJobS3ResultList' => [ 'base' => NULL, 'refs' => [ 'SnapshotJobResultFileGroup$S3Results' => '<p> A list of <code>SnapshotJobS3Result</code> objects.</p>', ], ], 'SnapshotJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDashboardSnapshotJobResponse$JobStatus' => '<p>Indicates the status of a job. The status updates as the job executes. This shows one of the following values.</p> <ul> <li> <p> <code>COMPLETED</code> - The job was completed successfully.</p> </li> <li> <p> <code>FAILED</code> - The job failed to execute.</p> </li> <li> <p> <code>QUEUED</code> - The job is queued and hasn\'t started yet.</p> </li> <li> <p> <code>RUNNING</code> - The job is still running.</p> </li> </ul>', 'DescribeDashboardSnapshotJobResultResponse$JobStatus' => '<p>Indicates the status of a job after it has reached a terminal state. A finished snapshot job will retuen a <code>COMPLETED</code> or <code>FAILED</code> status.</p>', ], ], 'SnapshotS3DestinationConfiguration' => [ 'base' => '<p>A structure that describes the Amazon S3 settings to use to save the generated dashboard snapshot.</p>', 'refs' => [ 'SnapshotJobS3Result$S3DestinationConfiguration' => '<p>A list of Amazon S3 bucket configurations that are provided when you make a <code>StartDashboardSnapshotJob</code> API call. </p>', 'SnapshotS3DestinationConfigurationList$member' => NULL, ], ], 'SnapshotS3DestinationConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SnapshotDestinationConfiguration$S3Destinations' => '<p> A list of <code>SnapshotS3DestinationConfiguration</code> objects that contain Amazon S3 destination configurations. This structure can hold a maximum of 1 <code>S3DestinationConfiguration</code>. </p>', ], ], 'SnapshotUserConfiguration' => [ 'base' => '<p>A structure that contains information about the users that the dashboard snapshot is generated for.</p>', 'refs' => [ 'StartDashboardSnapshotJobRequest$UserConfiguration' => '<p> A structure that contains information about the anonymous users that the generated snapshot is for. This API will not return information about registered Amazon QuickSight.</p>', ], ], 'SnapshotUserConfigurationRedacted' => [ 'base' => '<p>A structure that contains information about the users that the dashboard snapshot is generated for. Sensitive user information is excluded. </p>', 'refs' => [ 'DescribeDashboardSnapshotJobResponse$UserConfiguration' => '<p>The user configuration for the snapshot job. This information is provided when you make a <code>StartDashboardSnapshotJob</code> API call.</p>', ], ], 'SnowflakeParameters' => [ 'base' => '<p>The parameters for Snowflake.</p>', 'refs' => [ 'DataSourceParameters$SnowflakeParameters' => '<p>The parameters for Snowflake.</p>', ], ], 'SortDirection' => [ 'base' => NULL, 'refs' => [ 'AggregationSortConfiguration$SortDirection' => '<p>The sort direction of values.</p> <ul> <li> <p> <code>ASC</code>: Sort in ascending order.</p> </li> <li> <p> <code>DESC</code>: Sort in descending order.</p> </li> </ul>', 'ColumnSort$Direction' => '<p>The sort direction.</p>', 'DataPathSort$Direction' => '<p>Determines the sort direction.</p>', 'FieldSort$Direction' => '<p>The sort direction. Choose one of the following options:</p> <ul> <li> <p> <code>ASC</code>: Ascending</p> </li> <li> <p> <code>DESC</code>: Descending</p> </li> </ul>', ], ], 'Spacing' => [ 'base' => '<p>The configuration of spacing (often a margin or padding).</p>', 'refs' => [ 'SectionBasedLayoutPaperCanvasSizeOptions$PaperMargin' => '<p>Defines the spacing between the canvas content and the top, bottom, left, and right edges.</p>', 'SectionStyle$Padding' => '<p>The spacing between section content and its top, bottom, left, and right edges.</p> <p>There is no padding by default.</p>', ], ], 'SparkParameters' => [ 'base' => '<p>The parameters for Spark.</p>', 'refs' => [ 'DataSourceParameters$SparkParameters' => '<p>The parameters for Spark.</p>', ], ], 'SpecialValue' => [ 'base' => NULL, 'refs' => [ 'CustomColor$SpecialValue' => '<p>The value of a special data value.</p>', ], ], 'SqlEndpointPath' => [ 'base' => NULL, 'refs' => [ 'DatabricksParameters$SqlEndpointPath' => '<p>The HTTP path of the Databricks data source.</p>', ], ], 'SqlQuery' => [ 'base' => NULL, 'refs' => [ 'CustomSql$SqlQuery' => '<p>The SQL query.</p>', ], ], 'SqlServerParameters' => [ 'base' => '<p>The parameters for SQL Server.</p>', 'refs' => [ 'DataSourceParameters$SqlServerParameters' => '<p>The parameters for SQL Server.</p>', ], ], 'SslProperties' => [ 'base' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideParameters$SslProperties' => NULL, 'CreateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', 'DataSource$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', 'UpdateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', ], ], 'StarburstParameters' => [ 'base' => '<p>The parameters that are required to connect to a Starburst data source.</p>', 'refs' => [ 'DataSourceParameters$StarburstParameters' => '<p>The parameters that are required to connect to a Starburst data source.</p>', ], ], 'StarburstProductType' => [ 'base' => NULL, 'refs' => [ 'StarburstParameters$ProductType' => '<p>The product type for the Starburst data source.</p>', ], ], 'StartAssetBundleExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssetBundleExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartAssetBundleImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssetBundleImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDashboardSnapshotJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDashboardSnapshotJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatePersistenceConfigurations' => [ 'base' => '<p>The state perssitence configuration of an embedded dashboard.</p>', 'refs' => [ 'RegisteredUserConsoleFeatureConfigurations$StatePersistence' => '<p>The state persistence configurations of an embedded Amazon QuickSight console.</p>', 'RegisteredUserDashboardFeatureConfigurations$StatePersistence' => '<p>The state persistence settings of an embedded dashboard.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$Status' => '<p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>', 'RowLevelPermissionTagConfiguration$Status' => '<p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerResponse$Status' => '<p>The HTTP status of the request.</p>', 'BatchDeleteTopicReviewedAnswerResponse$Status' => '<p>The HTTP status of the request.</p>', 'CancelIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAccountSubscriptionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateFolderMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateFolderResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateRoleMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTopicRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTopicResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateVPCConnectionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAccountSubscriptionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSetRefreshPropertiesResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteFolderMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteFolderResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteIdentityPropagationConfigResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteRoleCustomPermissionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteRoleMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTopicRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTopicResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserByPrincipalIdResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteVPCConnectionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountSubscriptionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisDefinitionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAssetBundleExportJobResponse$Status' => '<p>The HTTP status of the response.</p>', 'DescribeAssetBundleImportJobResponse$Status' => '<p>The HTTP status of the response.</p>', 'DescribeDashboardDefinitionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardResponse$Status' => '<p>The HTTP status of this request.</p>', 'DescribeDashboardSnapshotJobResponse$Status' => '<p>The HTTP status of the request</p>', 'DescribeDashboardSnapshotJobResultResponse$Status' => '<p>The HTTP status of the request</p>', 'DescribeDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSetRefreshPropertiesResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeFolderPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeFolderResolvedPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeFolderResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIpRestrictionResponse$Status' => '<p>The HTTP status of the request. </p>', 'DescribeKeyRegistrationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeRoleCustomPermissionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateDefinitionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTopicPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTopicRefreshResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTopicRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTopicResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeVPCConnectionResponse$Status' => '<p>The HTTP status of the request.</p>', 'FailedKeyRegistrationEntry$StatusCode' => '<p>The HTTP status of a <code>FailedKeyRegistrationEntry</code> error.</p>', 'GenerateEmbedUrlForAnonymousUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetDashboardEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetSessionEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListAnalysesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListAssetBundleExportJobsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListAssetBundleImportJobsResponse$Status' => '<p>The HTTP status of the response.</p>', 'ListDashboardVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSetsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSourcesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListFolderMembersResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListFoldersResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListGroupMembershipsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsForUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIdentityPropagationConfigsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIngestionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListNamespacesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListRefreshSchedulesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListRoleMembershipsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTagsForResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplatesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTopicRefreshSchedulesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTopicReviewedAnswersResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTopicsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUserGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUsersResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListVPCConnectionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'PutDataSetRefreshPropertiesResponse$Status' => '<p>The HTTP status of the request.</p>', 'RegisterUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'RestoreAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchAnalysesResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchDataSetsResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchDataSourcesResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchFoldersResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'StartAssetBundleExportJobResponse$Status' => '<p>The HTTP status of the response.</p>', 'StartAssetBundleImportJobResponse$Status' => '<p>The HTTP status of the response.</p>', 'StartDashboardSnapshotJobResponse$Status' => '<p>The HTTP status of the request</p>', 'SuccessfulKeyRegistrationEntry$StatusCode' => '<p>The HTTP status of a <code>SuccessfulKeyRegistrationEntry</code> entry.</p>', 'TagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UntagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAnalysisPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardLinksResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPublishedVersionResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateFolderPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateFolderResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateIdentityPropagationConfigResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateIpRestrictionResponse$Status' => '<p>The HTTP status of the request. </p>', 'UpdatePublicSharingSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateRoleCustomPermissionResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateSPICECapacityConfigurationResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTopicPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTopicRefreshScheduleResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTopicResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateVPCConnectionResponse$Status' => '<p>The HTTP status of the request.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccessDeniedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'AccountInfo$AccountName' => '<p>The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It\'s unique over all of Amazon Web Services, and it appears only when users sign in.</p>', 'AccountInfo$NotificationEmail' => '<p>The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>', 'AccountInfo$AuthenticationType' => '<p>The way that your Amazon QuickSight account is authenticated.</p>', 'AccountInfo$AccountSubscriptionStatus' => '<p>The status of your account subscription.</p>', 'AccountInfo$IAMIdentityCenterInstanceArn' => '<p>The Amazon Resource Name (ARN) for the IAM Identity Center instance.</p>', 'AccountSettings$AccountName' => '<p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and it appears only when users sign in.</p>', 'AccountSettings$NotificationEmail' => '<p>The main notification email for your Amazon QuickSight subscription.</p>', 'ActionList$member' => NULL, 'AnalysisSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for example <code>"Value"</code>. An example is <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>', 'AssetBundleImportJobRefreshScheduleOverrideParameters$ScheduleId' => '<p>A partial identifier for the specific <code>RefreshSchedule</code> resource being overridden. This structure is used together with the <code>DataSetId</code> structure.</p>', 'AssetBundleImportJobResourceIdOverrideConfiguration$PrefixForAllResources' => '<p>An option to request a CloudFormation variable for a prefix to be prepended to each resource\'s ID before import. The prefix is only added to the asset IDs and does not change the name of the asset.</p>', 'AssetOptions$Timezone' => '<p>Determines the timezone for the analysis.</p>', 'AttributeAggregationFunction$ValueForMultipleValues' => '<p>Used by the <code>UNIQUE_VALUE</code> aggregation function. If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to \'*\'.</p>', 'AuthorizedTargetsList$member' => NULL, 'AxisLabelOptions$CustomLabel' => '<p>The text for the axis label.</p>', 'BatchCreateTopicReviewedAnswerResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'BatchDeleteTopicReviewedAnswerResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CancelIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CancelIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CascadingControlSource$SourceSheetControlId' => '<p>The source sheet control ID of a <code>CascadingControlSource</code>.</p>', 'ColumnGroupColumnSchema$Name' => '<p>The name of the column group\'s column schema.</p>', 'ColumnGroupSchema$Name' => '<p>The name of the column group schema.</p>', 'ColumnNameList$member' => NULL, 'ColumnSchema$Name' => '<p>The name of the column schema.</p>', 'ColumnSchema$DataType' => '<p>The data type of the column schema.</p>', 'ColumnSchema$GeographicRole' => '<p>The geographic role of the column schema.</p>', 'ColumnTooltipItem$Label' => '<p>The label of the tooltip item.</p>', 'ConcurrentUpdatingException$Message' => NULL, 'ConcurrentUpdatingException$RequestId' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'CreateAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateAccountSubscriptionRequest$NotificationEmail' => '<p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.</p>', 'CreateAccountSubscriptionRequest$ActiveDirectoryName' => '<p>The name of your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$Realm' => '<p>The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$DirectoryId' => '<p>The ID of the Active Directory that is associated with your Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$FirstName' => '<p>The first name of the author of the Amazon QuickSight account to use for future communications. This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$LastName' => '<p>The last name of the author of the Amazon QuickSight account to use for future communications. This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$EmailAddress' => '<p>The email address of the author of the Amazon QuickSight account to use for future communications. This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$ContactNumber' => '<p>A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.</p>', 'CreateAccountSubscriptionRequest$IAMIdentityCenterInstanceArn' => '<p>The Amazon Resource Name (ARN) for the IAM Identity Center instance.</p>', 'CreateAccountSubscriptionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateFolderMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateFolderResponse$RequestId' => '<p>The request ID for the newly created folder.</p>', 'CreateGroupMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID for the assignment.</p>', 'CreateIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CreateIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateNamespaceResponse$CapacityRegion' => '<p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>', 'CreateNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateRefreshScheduleResponse$ScheduleId' => '<p>The ID of the refresh schedule.</p>', 'CreateRoleMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTopicRefreshScheduleRequest$DatasetName' => '<p>The name of the dataset.</p>', 'CreateTopicRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTopicResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateVPCConnectionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CustomerManagedKeyUnavailableException$Message' => NULL, 'CustomerManagedKeyUnavailableException$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DashboardSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for example, <code>"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>', 'DataSetConfiguration$Placeholder' => '<p>Placeholder.</p>', 'DataSetSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_OWNER</code>, that you want to use as a filter, for example, <code>"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>', 'DataSourceErrorInfo$Message' => '<p>Error message.</p>', 'DataSourceSearchFilter$Value' => '<p>The value of the named item, for example <code>DIRECT_QUICKSIGHT_OWNER</code>, that you want to use as a filter, for example, <code>"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>', 'DeleteAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteAccountSubscriptionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDataSetRefreshPropertiesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteFolderMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteFolderResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteGroupMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteIdentityPropagationConfigResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteRefreshScheduleRequest$ScheduleId' => '<p>The ID of the refresh schedule.</p>', 'DeleteRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteRefreshScheduleResponse$ScheduleId' => '<p>The ID of the refresh schedule.</p>', 'DeleteRoleCustomPermissionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteRoleMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTopicRefreshScheduleRequest$DatasetId' => '<p>The ID of the dataset.</p>', 'DeleteTopicRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTopicResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteUserByPrincipalIdRequest$PrincipalId' => '<p>The principal ID of the user.</p>', 'DeleteUserByPrincipalIdResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteVPCConnectionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAccountSettingsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAccountSubscriptionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAnalysisDefinitionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAnalysisPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardDefinitionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSetPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSetRefreshPropertiesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSourcePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeFolderPermissionsRequest$NextToken' => '<p>A pagination token for the next set of results.</p>', 'DescribeFolderPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeFolderPermissionsResponse$NextToken' => '<p>The pagination token for the next set of results, or null if there are no more results.</p>', 'DescribeFolderResolvedPermissionsRequest$NextToken' => '<p>A pagination token for the next set of results.</p>', 'DescribeFolderResolvedPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeFolderResolvedPermissionsResponse$NextToken' => '<p>A pagination token for the next set of results, or null if there are no more results.</p>', 'DescribeFolderResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeGroupMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'DescribeIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeIpRestrictionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeRefreshScheduleRequest$ScheduleId' => '<p>The ID of the refresh schedule.</p>', 'DescribeRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeRoleCustomPermissionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplateDefinitionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplatePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTopicPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTopicRefreshResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTopicRefreshScheduleRequest$DatasetId' => '<p>The ID of the dataset.</p>', 'DescribeTopicRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTopicResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeVPCConnectionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DestinationParameterValueConfiguration$SourceParameterName' => '<p>The source parameter name of the destination parameter.</p>', 'DomainNotWhitelistedException$Message' => NULL, 'DomainNotWhitelistedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ErrorInfo$Message' => '<p>Error message.</p>', 'FailedKeyRegistrationEntry$KeyArn' => '<p>The ARN of the KMS key that failed to update.</p>', 'FieldTooltipItem$Label' => '<p>The label of the tooltip item.</p>', 'FolderColumnList$member' => NULL, 'FolderSearchFilter$Value' => '<p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>', 'Font$FontFamily' => '<p>Determines the font family settings.</p>', 'ForecastComputation$Name' => '<p>The name of a computation.</p>', 'GenerateEmbedUrlForAnonymousUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GetDashboardEmbedUrlResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GetSessionEmbedUrlResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'Group$PrincipalId' => '<p>The principal ID of the group.</p>', 'GroupSearchFilter$Value' => '<p>The value of the named item, in this case <code>GROUP_NAME</code>, that you want to use as a filter.</p>', 'GroupsList$member' => NULL, 'GrowthRateComputation$Name' => '<p>The name of a computation.</p>', 'IAMPolicyAssignment$AssignmentId' => '<p>Assignment ID.</p>', 'IdentityMap$key' => NULL, 'IdentityTypeNotSupportedException$Message' => NULL, 'IdentityTypeNotSupportedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InternalFailureException$Message' => NULL, 'InternalFailureException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InvalidNextTokenException$Message' => NULL, 'InvalidNextTokenException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InvalidParameterValueException$Message' => NULL, 'InvalidParameterValueException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InvalidRequestException$Message' => NULL, 'InvalidRequestException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'LabelOptions$CustomLabel' => '<p>The text for the label.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ListAnalysesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListAnalysesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListAnalysesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListAssetBundleExportJobsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAssetBundleExportJobsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAssetBundleImportJobsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAssetBundleImportJobsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDataSetsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDataSourcesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListFolderMembersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFolderMembersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFolderMembersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListFoldersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFoldersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFoldersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListGroupMembershipsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsForUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIdentityPropagationConfigsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIdentityPropagationConfigsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIdentityPropagationConfigsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIngestionsRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'ListIngestionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListNamespacesRequest$NextToken' => '<p>A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the response body of a previous <code>ListNameSpaces</code> API call if there is more data that can be returned. To receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.</p>', 'ListNamespacesResponse$NextToken' => '<p>A unique pagination token that can be used in a subsequent request. Receiving <code>NextToken</code> in your response inticates that there is more data that can be returned. To receive the data, make another <code>ListNamespaces</code> API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.</p>', 'ListNamespacesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListRefreshSchedulesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListRoleMembershipsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListRoleMembershipsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListRoleMembershipsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTagsForResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplateAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateAliasesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplateAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplatesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemeAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeAliasesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemeAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTopicRefreshSchedulesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTopicReviewedAnswersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTopicsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTopicsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTopicsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListUserGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListUsersRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListVPCConnectionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListVPCConnectionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListVPCConnectionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'LookbackWindow$ColumnName' => '<p>The name of the lookback window column.</p>', 'MaximumMinimumComputation$Name' => '<p>The name of a computation.</p>', 'MetricComparisonComputation$Name' => '<p>The name of a computation.</p>', 'NamespaceError$Message' => '<p>The message for the error.</p>', 'NamespaceInfoV2$CapacityRegion' => '<p>The namespace Amazon Web Services Region.</p>', 'NetworkInterface$AvailabilityZone' => '<p>The availability zone that the network interface resides in.</p>', 'NetworkInterface$ErrorMessage' => '<p>An error message.</p>', 'ParameterSelectableValueList$member' => NULL, 'PeriodOverPeriodComputation$Name' => '<p>The name of a computation.</p>', 'PeriodToDateComputation$Name' => '<p>The name of a computation.</p>', 'PivotTableFieldCollapseStateTarget$FieldId' => '<p>The field ID of the pivot table that the collapse state needs to be set to.</p>', 'PivotTotalOptions$CustomLabel' => '<p>The custom label string for the total cells.</p>', 'PreconditionNotMetException$Message' => NULL, 'PreconditionNotMetException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'PrincipalList$member' => NULL, 'ProjectedColumnList$member' => NULL, 'PutDataSetRefreshPropertiesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'QueueInfo$WaitingOnIngestion' => '<p>The ID of the queued ingestion.</p>', 'QueueInfo$QueuedIngestion' => '<p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.</p>', 'QuickSightUserNotFoundException$Message' => NULL, 'QuickSightUserNotFoundException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'RefreshFrequency$Timezone' => '<p>The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID found on <code>java.util.time.getAvailableIDs()</code>.</p>', 'RefreshFrequency$TimeOfTheDay' => '<p>The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field is not required for schedules that refresh hourly.</p>', 'RefreshSchedule$ScheduleId' => '<p>An identifier for the refresh schedule.</p>', 'RegisterUserRequest$Email' => '<p>The email address of the user that you want to register.</p>', 'RegisterUserRequest$IamArn' => '<p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>', 'RegisterUserRequest$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li> </ul>', 'RegisterUserRequest$CustomFederationProviderUrl' => '<p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>', 'RegisterUserRequest$ExternalLoginId' => '<p>The identity ID for a user in the external login provider.</p>', 'RegisterUserResponse$UserInvitationUrl' => '<p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>', 'RegisterUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'RegisteredCustomerManagedKey$KeyArn' => '<p>The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.</p>', 'ResourceExistsException$Message' => NULL, 'ResourceExistsException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ResourceUnavailableException$Message' => NULL, 'ResourceUnavailableException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'RestoreAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'RowLevelPermissionTagRule$ColumnName' => '<p>The column name that a tag key is assigned to.</p>', 'SearchAnalysesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchAnalysesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request. </p>', 'SearchAnalysesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchDataSetsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchDataSetsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchDataSetsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchDataSourcesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchDataSourcesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchDataSourcesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchFoldersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchFoldersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchFoldersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchGroupsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SessionLifetimeInMinutesInvalidException$Message' => NULL, 'SessionLifetimeInMinutesInvalidException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'SignupResponse$userLoginName' => '<p>The user login name for your Amazon QuickSight account.</p>', 'SignupResponse$accountName' => '<p>The name of your Amazon QuickSight account.</p>', 'SignupResponse$directoryType' => '<p>The type of Active Directory that is being used to authenticate the Amazon QuickSight account. Valid values are <code>SIMPLE_AD</code>, <code>AD_CONNECTOR</code>, and <code>MICROSOFT_AD</code>.</p>', 'SnapshotJobErrorInfo$ErrorMessage' => '<p>The error message.</p>', 'SnapshotJobErrorInfo$ErrorType' => '<p>The error type.</p>', 'SnapshotJobResultErrorInfo$ErrorMessage' => '<p>The error message.</p>', 'SnapshotJobResultErrorInfo$ErrorType' => '<p>The error type.</p>', 'StringList$member' => NULL, 'SubtotalOptions$CustomLabel' => '<p>The custom label string for the subtotal cells.</p>', 'SuccessfulKeyRegistrationEntry$KeyArn' => '<p>The ARN of the KMS key that is associated with the <code>SuccessfulKeyRegistrationEntry</code> entry.</p>', 'TableFieldCustomTextContent$Value' => '<p>The string value of the custom text content for the table URL link content.</p>', 'TagResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ThrottlingException$Message' => NULL, 'ThrottlingException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'TopBottomMoversComputation$Name' => '<p>The name of a computation.</p>', 'TopBottomRankedComputation$Name' => '<p>The name of a computation.</p>', 'TotalAggregationComputation$Name' => '<p>The name of a computation.</p>', 'TotalOptions$CustomLabel' => '<p>The custom label string for the total cells.</p>', 'UniqueValuesComputation$Name' => '<p>The name of a computation.</p>', 'UnsupportedPricingPlanException$Message' => NULL, 'UnsupportedPricingPlanException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'UnsupportedUserEditionException$Message' => NULL, 'UnsupportedUserEditionException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'UntagResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAccountSettingsRequest$NotificationEmail' => '<p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>', 'UpdateAccountSettingsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAnalysisPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardLinksResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardPublishedVersionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSetPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSourcePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateFolderPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateFolderResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID of the assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateIdentityPropagationConfigResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateIpRestrictionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdatePublicSharingSettingsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateRefreshScheduleResponse$ScheduleId' => '<p>The ID of the refresh schedule.</p>', 'UpdateRoleCustomPermissionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateSPICECapacityConfigurationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplatePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTopicPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTopicRefreshScheduleRequest$DatasetId' => '<p>The ID of the dataset.</p>', 'UpdateTopicRefreshScheduleResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTopicResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateUserRequest$Email' => '<p>The email address of the user that you want to update.</p>', 'UpdateUserRequest$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li> <li> <p> <code>NONE</code>: This clears all the previously saved external login information for a user. Use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code> API operation to check the external login information.</p> </li> </ul>', 'UpdateUserRequest$CustomFederationProviderUrl' => '<p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>', 'UpdateUserRequest$ExternalLoginId' => '<p>The identity ID for a user in the external login provider.</p>', 'UpdateUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateVPCConnectionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'User$Email' => '<p>The user\'s email address.</p>', 'User$PrincipalId' => '<p>The principal ID of the user.</p>', 'User$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let the user federate into Amazon QuickSight with an associated IAM role. The type can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p> </li> </ul>', 'User$ExternalLoginFederationProviderUrl' => '<p>The URL of the external login provider.</p>', 'User$ExternalLoginId' => '<p>The identity ID for the user in the external login provider.</p>', 'VPCConnection$VPCId' => '<p>The Amazon EC2 VPC ID associated with the VPC connection.</p>', 'VPCConnection$RoleArn' => '<p>The ARN of the IAM role associated with the VPC connection.</p>', 'VPCConnectionSummary$VPCId' => '<p>The Amazon EC2 VPC ID associated with the VPC connection.</p>', 'VPCConnectionSummary$RoleArn' => '<p>The ARN of the IAM role associated with the VPC connection.</p>', 'WaterfallChartOptions$TotalBarLabel' => '<p>This option determines the total bar label of a waterfall visual.</p>', ], ], 'StringDatasetParameter' => [ 'base' => '<p>A string parameter for a dataset.</p>', 'refs' => [ 'DatasetParameter$StringDatasetParameter' => '<p>A string parameter that is created in the dataset.</p>', ], ], 'StringDatasetParameterDefaultValue' => [ 'base' => '<p>The default value for the string parameter.</p>', 'refs' => [ 'StringDatasetParameterValueList$member' => NULL, ], ], 'StringDatasetParameterDefaultValues' => [ 'base' => '<p>The default values of a string parameter.</p>', 'refs' => [ 'StringDatasetParameter$DefaultValues' => '<p>A list of default values for a given string dataset parameter type. This structure only accepts static values.</p>', ], ], 'StringDatasetParameterValueList' => [ 'base' => NULL, 'refs' => [ 'NewDefaultValues$StringStaticValues' => '<p>A list of static default values for a given string parameter.</p>', 'StringDatasetParameterDefaultValues$StaticValues' => '<p>A list of static default values for a given string parameter.</p>', ], ], 'StringDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'CustomParameterValues$StringValues' => '<p>A list of string-type parameter values.</p>', 'StringDefaultValues$StaticValues' => '<p>The static values of the <code>DecimalDefaultValues</code>.</p>', ], ], 'StringDefaultValues' => [ 'base' => '<p>The default values of the <code>StringParameterDeclaration</code>.</p>', 'refs' => [ 'StringParameterDeclaration$DefaultValues' => '<p>The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.</p>', ], ], 'StringFormatConfiguration' => [ 'base' => '<p>Formatting configuration for string fields.</p>', 'refs' => [ 'CategoricalDimensionField$FormatConfiguration' => '<p>The format configuration of the field.</p>', 'CategoricalMeasureField$FormatConfiguration' => '<p>The format configuration of the field.</p>', 'FormatConfiguration$StringFormatConfiguration' => '<p>Formatting configuration for string fields.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CellValueSynonym$Synonyms' => '<p>Other names or aliases for the cell value.</p>', 'CollectiveConstant$ValueList' => '<p>A list of values for the collective constant.</p>', 'ComparativeOrder$SpecifedOrder' => '<p>The list of columns to be used in the ordering.</p>', 'GenerateEmbedUrlForAnonymousUserRequest$AllowedDomains' => '<p>The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.</p> <p>To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example, <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$AllowedDomains' => '<p>The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.</p> <p>To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example, <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.</p>', 'VPCConnection$DnsResolvers' => '<p>A list of IP addresses of DNS resolver endpoints for the VPC connection.</p>', 'VPCConnectionSummary$DnsResolvers' => '<p>A list of IP addresses of DNS resolver endpoints for the VPC connection.</p>', ], ], 'StringParameter' => [ 'base' => '<p>A string parameter.</p>', 'refs' => [ 'StringParameterList$member' => NULL, ], ], 'StringParameterDeclaration' => [ 'base' => '<p>A parameter declaration for the <code>String</code> data type.</p>', 'refs' => [ 'ParameterDeclaration$StringParameterDeclaration' => '<p>A parameter declaration for the <code>String</code> data type.</p>', ], ], 'StringParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$StringParameters' => '<p>The parameters that have a data type of string.</p>', ], ], 'StringValueWhenUnsetConfiguration' => [ 'base' => '<p>The configuration that defines the default value of a <code>String</code> parameter when a value has not been set.</p>', 'refs' => [ 'StringParameterDeclaration$ValueWhenUnset' => '<p>The configuration that defines the default value of a <code>String</code> parameter when a value has not been set.</p>', ], ], 'StyledCellType' => [ 'base' => NULL, 'refs' => [ 'TableStyleTarget$CellType' => '<p>The cell type of the table style target.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$SubnetId' => '<p>The subnet ID associated with the network interface.</p>', 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParameters$SubnetIds' => '<p>A list of new subnet IDs for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.</p>', 'CreateVPCConnectionRequest$SubnetIds' => '<p>A list of subnet IDs for the VPC connection.</p>', 'UpdateVPCConnectionRequest$SubnetIds' => '<p>A list of subnet IDs for the VPC connection.</p>', ], ], 'SubtotalOptions' => [ 'base' => '<p>The subtotal options.</p>', 'refs' => [ 'PivotTableTotalOptions$RowSubtotalOptions' => '<p>The row subtotal options.</p>', 'PivotTableTotalOptions$ColumnSubtotalOptions' => '<p>The column subtotal options.</p>', ], ], 'SucceededTopicReviewedAnswer' => [ 'base' => '<p>The definition for a <code>SucceededTopicReviewedAnswer</code>.</p>', 'refs' => [ 'SucceededTopicReviewedAnswers$member' => NULL, ], ], 'SucceededTopicReviewedAnswers' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerResponse$SucceededAnswers' => '<p>The definition of Answers that are successfully created.</p>', 'BatchDeleteTopicReviewedAnswerResponse$SucceededAnswers' => '<p>The definition of Answers that are successfully deleted.</p>', ], ], 'SuccessfulKeyRegistrationEntries' => [ 'base' => NULL, 'refs' => [ 'UpdateKeyRegistrationResponse$SuccessfulKeyRegistration' => '<p>A list of all customer managed key registrations that were successfully updated.</p>', ], ], 'SuccessfulKeyRegistrationEntry' => [ 'base' => '<p>A success entry that occurs when a <code>KeyRegistration</code> job is successfully applied to the Amazon QuickSight account.</p>', 'refs' => [ 'SuccessfulKeyRegistrationEntries$member' => NULL, ], ], 'Suffix' => [ 'base' => NULL, 'refs' => [ 'CurrencyDisplayFormatConfiguration$Suffix' => '<p>Determines the suffix value of the currency format.</p>', 'NumberDisplayFormatConfiguration$Suffix' => '<p>Determines the suffix value of the number format.</p>', 'PercentageDisplayFormatConfiguration$Suffix' => '<p>Determines the suffix value of the percentage format.</p>', ], ], 'Synonyms' => [ 'base' => NULL, 'refs' => [ 'TopicCalculatedField$CalculatedFieldSynonyms' => '<p>The other names or aliases for the calculated field.</p>', 'TopicColumn$ColumnSynonyms' => '<p>The other names or aliases for the column.</p>', 'TopicFilter$FilterSynonyms' => '<p>The other names or aliases for the filter.</p>', 'TopicNamedEntity$EntitySynonyms' => '<p>The other names or aliases for the named entity.</p>', ], ], 'TableAggregatedFieldWells' => [ 'base' => '<p>The aggregated field well for the table.</p>', 'refs' => [ 'TableFieldWells$TableAggregatedFieldWells' => '<p>The aggregated field well for the table.</p>', ], ], 'TableBorderOptions' => [ 'base' => '<p>The border options for a table border.</p>', 'refs' => [ 'GlobalTableBorderOptions$UniformBorder' => '<p>Determines the options for uniform border.</p>', 'TableSideBorderOptions$InnerVertical' => '<p>The table border options of the inner vertical border.</p>', 'TableSideBorderOptions$InnerHorizontal' => '<p>The table border options of the inner horizontal border.</p>', 'TableSideBorderOptions$Left' => '<p>The table border options of the left border.</p>', 'TableSideBorderOptions$Right' => '<p>The table border options of the right border.</p>', 'TableSideBorderOptions$Top' => '<p>The table border options of the top border.</p>', 'TableSideBorderOptions$Bottom' => '<p>The table border options of the bottom border.</p>', ], ], 'TableBorderStyle' => [ 'base' => NULL, 'refs' => [ 'TableBorderOptions$Style' => '<p>The style (none, solid) of a table border.</p>', ], ], 'TableBorderThickness' => [ 'base' => NULL, 'refs' => [ 'TableBorderOptions$Thickness' => '<p>The thickness of a table border.</p>', ], ], 'TableCellConditionalFormatting' => [ 'base' => '<p>The cell conditional formatting option for a table.</p>', 'refs' => [ 'TableConditionalFormattingOption$Cell' => '<p>The cell conditional formatting option for a table.</p>', ], ], 'TableCellImageScalingConfiguration' => [ 'base' => NULL, 'refs' => [ 'TableCellImageSizingConfiguration$TableCellImageScalingConfiguration' => '<p>The cell scaling configuration of the sizing options for the table image configuration.</p>', ], ], 'TableCellImageSizingConfiguration' => [ 'base' => '<p>The sizing options for the table image configuration.</p>', 'refs' => [ 'TableFieldImageConfiguration$SizingOptions' => '<p>The sizing options for the table image configuration.</p>', ], ], 'TableCellStyle' => [ 'base' => '<p>The table cell style for a cell in pivot table or table visual.</p>', 'refs' => [ 'PivotTableOptions$ColumnHeaderStyle' => '<p>The table cell style of the column header.</p>', 'PivotTableOptions$RowHeaderStyle' => '<p>The table cell style of the row headers.</p>', 'PivotTableOptions$CellStyle' => '<p>The table cell style of cells.</p>', 'PivotTableOptions$RowFieldNamesStyle' => '<p>The table cell style of row field names.</p>', 'PivotTotalOptions$TotalCellStyle' => '<p>The cell styling options for the total cells.</p>', 'PivotTotalOptions$ValueCellStyle' => '<p>The cell styling options for the totals of value cells.</p>', 'PivotTotalOptions$MetricHeaderCellStyle' => '<p>The cell styling options for the total of header cells.</p>', 'SubtotalOptions$TotalCellStyle' => '<p>The cell styling options for the subtotal cells.</p>', 'SubtotalOptions$ValueCellStyle' => '<p>The cell styling options for the subtotals of value cells.</p>', 'SubtotalOptions$MetricHeaderCellStyle' => '<p>The cell styling options for the subtotals of header cells.</p>', 'TableOptions$HeaderStyle' => '<p>The table cell style of a table header.</p>', 'TableOptions$CellStyle' => '<p>The table cell style of table cells.</p>', 'TotalOptions$TotalCellStyle' => '<p>Cell styling options for the total cells.</p>', ], ], 'TableConditionalFormatting' => [ 'base' => '<p>The conditional formatting for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'TableVisual$ConditionalFormatting' => '<p>The conditional formatting for a <code>PivotTableVisual</code>.</p>', ], ], 'TableConditionalFormattingOption' => [ 'base' => '<p>Conditional formatting options for a <code>PivotTableVisual</code>.</p>', 'refs' => [ 'TableConditionalFormattingOptionList$member' => NULL, ], ], 'TableConditionalFormattingOptionList' => [ 'base' => NULL, 'refs' => [ 'TableConditionalFormatting$ConditionalFormattingOptions' => '<p>Conditional formatting options for a <code>PivotTableVisual</code>.</p>', ], ], 'TableConfiguration' => [ 'base' => '<p>The configuration for a <code>TableVisual</code>.</p>', 'refs' => [ 'TableVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'TableFieldCustomIconContent' => [ 'base' => '<p>The custom icon content for the table link content configuration.</p>', 'refs' => [ 'TableFieldLinkContentConfiguration$CustomIconContent' => '<p>The custom icon content for the table link content configuration.</p>', ], ], 'TableFieldCustomTextContent' => [ 'base' => '<p>The custom text content (value, font configuration) for the table link content configuration.</p>', 'refs' => [ 'TableFieldLinkContentConfiguration$CustomTextContent' => '<p>The custom text content (value, font configuration) for the table link content configuration.</p>', ], ], 'TableFieldHeight' => [ 'base' => NULL, 'refs' => [ 'TableCellStyle$Height' => '<p>The height color for the table cells.</p>', ], ], 'TableFieldIconSetType' => [ 'base' => NULL, 'refs' => [ 'TableFieldCustomIconContent$Icon' => '<p>The icon set type (link) of the custom icon content for table URL link content.</p>', ], ], 'TableFieldImageConfiguration' => [ 'base' => '<p>The image configuration of a table field URL.</p>', 'refs' => [ 'TableFieldURLConfiguration$ImageConfiguration' => '<p>The image configuration of a table field URL.</p>', ], ], 'TableFieldLinkConfiguration' => [ 'base' => '<p>The link configuration of a table field URL.</p>', 'refs' => [ 'TableFieldURLConfiguration$LinkConfiguration' => '<p>The link configuration of a table field URL.</p>', ], ], 'TableFieldLinkContentConfiguration' => [ 'base' => '<p>The URL content (text, icon) for the table link configuration.</p>', 'refs' => [ 'TableFieldLinkConfiguration$Content' => '<p>The URL content (text, icon) for the table link configuration.</p>', ], ], 'TableFieldOption' => [ 'base' => '<p>The options for a table field.</p>', 'refs' => [ 'TableFieldOptionList$member' => NULL, ], ], 'TableFieldOptionList' => [ 'base' => NULL, 'refs' => [ 'TableFieldOptions$SelectedFieldOptions' => '<p>The field options to be configured to a table.</p>', ], ], 'TableFieldOptions' => [ 'base' => '<p>The field options of a table visual.</p>', 'refs' => [ 'TableConfiguration$FieldOptions' => '<p>The field options for a table visual.</p>', ], ], 'TableFieldOrderList' => [ 'base' => '<p>A list of table field IDs.</p>', 'refs' => [ 'TablePinnedFieldOptions$PinnedLeftFields' => '<p>A list of columns to be pinned to the left of a table visual.</p>', ], ], 'TableFieldURLConfiguration' => [ 'base' => '<p>The URL configuration for a table field.</p>', 'refs' => [ 'TableFieldOption$URLStyling' => '<p>The URL configuration for a table field.</p>', ], ], 'TableFieldWells' => [ 'base' => '<p>The field wells for a table visual.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'TableConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'TableInlineVisualization' => [ 'base' => '<p>The inline visualization of a specific type to display within a chart.</p>', 'refs' => [ 'TableInlineVisualizationList$member' => NULL, ], ], 'TableInlineVisualizationList' => [ 'base' => NULL, 'refs' => [ 'TableConfiguration$TableInlineVisualizations' => '<p>A collection of inline visualizations to display within a chart.</p>', ], ], 'TableOptions' => [ 'base' => '<p>The table options for a table visual.</p>', 'refs' => [ 'TableConfiguration$TableOptions' => '<p>The table options for a table visual.</p>', ], ], 'TableOrientation' => [ 'base' => NULL, 'refs' => [ 'TableOptions$Orientation' => '<p>The orientation (vertical, horizontal) for a table.</p>', ], ], 'TablePaginatedReportOptions' => [ 'base' => '<p>The paginated report options for a table visual.</p>', 'refs' => [ 'TableConfiguration$PaginatedReportOptions' => '<p>The paginated report options for a table visual.</p>', ], ], 'TablePinnedFieldOptions' => [ 'base' => '<p>The settings for the pinned columns of a table visual.</p>', 'refs' => [ 'TableFieldOptions$PinnedFieldOptions' => '<p>The settings for the pinned columns of a table visual.</p>', ], ], 'TableRowConditionalFormatting' => [ 'base' => '<p>The conditional formatting of a table row.</p>', 'refs' => [ 'TableConditionalFormattingOption$Row' => '<p>The row conditional formatting option for a table.</p>', ], ], 'TableSideBorderOptions' => [ 'base' => '<p>The side border options for a table.</p>', 'refs' => [ 'GlobalTableBorderOptions$SideSpecificBorder' => '<p>Determines the options for side specific border.</p>', ], ], 'TableSortConfiguration' => [ 'base' => '<p>The sort configuration for a <code>TableVisual</code>.</p>', 'refs' => [ 'TableConfiguration$SortConfiguration' => '<p>The sort configuration for a <code>TableVisual</code>.</p>', ], ], 'TableStyleTarget' => [ 'base' => '<p>The table style target.</p>', 'refs' => [ 'TableStyleTargetList$member' => NULL, ], ], 'TableStyleTargetList' => [ 'base' => NULL, 'refs' => [ 'SubtotalOptions$StyleTargets' => '<p>The style targets options for subtotals.</p>', ], ], 'TableTotalsPlacement' => [ 'base' => NULL, 'refs' => [ 'PivotTotalOptions$Placement' => '<p>The placement (start, end) for the total cells.</p>', 'TotalOptions$Placement' => '<p>The placement (start, end) for the total cells.</p>', ], ], 'TableTotalsScrollStatus' => [ 'base' => NULL, 'refs' => [ 'PivotTotalOptions$ScrollStatus' => '<p>The scroll status (pinned, scrolled) for the total cells.</p>', 'TotalOptions$ScrollStatus' => '<p>The scroll status (pinned, scrolled) for the total cells.</p>', ], ], 'TableUnaggregatedFieldWells' => [ 'base' => '<p>The unaggregated field well for the table.</p>', 'refs' => [ 'TableFieldWells$TableUnaggregatedFieldWells' => '<p>The unaggregated field well for the table.</p>', ], ], 'TableVisual' => [ 'base' => '<p>A table visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using tables as visuals</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$TableVisual' => '<p>A table visual.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using tables as visuals</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'Tag' => [ 'base' => '<p>The key or keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagColumnOperation' => [ 'base' => '<p>A transform operation that tags a column with additional information.</p>', 'refs' => [ 'TransformOperation$TagColumnOperation' => '<p>An operation that tags a column with additional information.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobAnalysisOverrideTags$Tags' => '<p>A list of tags for the analyses that you want to apply overrides to.</p>', 'AssetBundleImportJobDashboardOverrideTags$Tags' => '<p>A list of tags for the dashboards that you want to apply overrides to.</p>', 'AssetBundleImportJobDataSetOverrideTags$Tags' => '<p>A list of tags for the datasets that you want to apply overrides to.</p>', 'AssetBundleImportJobDataSourceOverrideTags$Tags' => '<p>A list of tags for the data source that you want to apply overrides to.</p>', 'AssetBundleImportJobThemeOverrideTags$Tags' => '<p>A list of tags for the themes that you want to apply overrides to.</p>', 'AssetBundleImportJobVPCConnectionOverrideTags$Tags' => '<p>A list of tags for the VPC connections that you want to apply overrides to.</p>', 'CreateAccountCustomizationRequest$Tags' => '<p>A list of the tags that you want to attach to this resource.</p>', 'CreateAnalysisRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>', 'CreateDashboardRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>', 'CreateDataSetRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>', 'CreateDataSourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>', 'CreateFolderRequest$Tags' => '<p>Tags for the folder.</p>', 'CreateNamespaceRequest$Tags' => '<p>The tags that you want to associate with the namespace that you\'re creating.</p>', 'CreateTemplateRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'CreateThemeRequest$Tags' => '<p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>', 'CreateTopicRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags that are assigned to the dataset.</p>', 'CreateVPCConnectionRequest$Tags' => '<p>A map of the key-value pairs for the resource tag or tags assigned to the VPC connection.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'RegisterUserRequest$Tags' => '<p>The tags to associate with the user.</p>', 'TagResourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Tag value.</p>', ], ], 'TargetVisualList' => [ 'base' => NULL, 'refs' => [ 'SameSheetTargetVisualConfiguration$TargetVisuals' => '<p>A list of the target visual IDs that are located in the same sheet of the analysis.</p>', ], ], 'TargetVisualOptions' => [ 'base' => NULL, 'refs' => [ 'SameSheetTargetVisualConfiguration$TargetVisualOptions' => '<p>The options that choose the target visual in the same sheet.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>ALL_VISUALS</code>: Applies the filter operation to all visuals in the same sheet.</p> </li> </ul>', ], ], 'Template' => [ 'base' => '<p>A template object. A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create a dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with an analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p> <p>You can share templates across Amazon Web Services accounts by allowing users in other Amazon Web Services accounts to create a template or a dashboard from an existing template.</p>', 'refs' => [ 'DescribeTemplateResponse$Template' => '<p>The template structure for the object you want to describe.</p>', ], ], 'TemplateAlias' => [ 'base' => '<p>The template alias.</p>', 'refs' => [ 'CreateTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'DescribeTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'TemplateAliasList$member' => NULL, 'UpdateTemplateAliasResponse$TemplateAlias' => '<p>The template alias.</p>', ], ], 'TemplateAliasList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateAliasesResponse$TemplateAliasList' => '<p>A structure containing the list of the template\'s aliases.</p>', ], ], 'TemplateError' => [ 'base' => '<p>List of errors that occurred when the template version creation failed.</p>', 'refs' => [ 'TemplateErrorList$member' => NULL, ], ], 'TemplateErrorList' => [ 'base' => NULL, 'refs' => [ 'DescribeTemplateDefinitionResponse$Errors' => '<p>Errors associated with the template version.</p>', 'TemplateVersion$Errors' => '<p>Errors associated with this template version.</p>', ], ], 'TemplateErrorType' => [ 'base' => NULL, 'refs' => [ 'TemplateError$Type' => '<p>Type of error.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$Name' => '<p>A display name for the template.</p>', 'DescribeTemplateDefinitionResponse$Name' => '<p>The descriptive name of the template.</p>', 'Template$Name' => '<p>The display name of the template.</p>', 'TemplateSummary$Name' => '<p>A display name for the template.</p>', 'UpdateTemplateRequest$Name' => '<p>The name for the template.</p>', ], ], 'TemplateSourceAnalysis' => [ 'base' => '<p>The source analysis of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceAnalysis' => '<p>The source analysis, if it is based on an analysis.</p>', ], ], 'TemplateSourceEntity' => [ 'base' => '<p>The source entity of the template.</p>', 'refs' => [ 'CreateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'UpdateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'TemplateSourceTemplate' => [ 'base' => '<p>The source template of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceTemplate' => '<p>The source template, if it is based on an template.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>The template summary.</p>', 'refs' => [ 'TemplateSummaryList$member' => NULL, ], ], 'TemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesResponse$TemplateSummaryList' => '<p>A structure containing information about the templates in the list.</p>', ], ], 'TemplateVersion' => [ 'base' => '<p>A version of a template.</p>', 'refs' => [ 'Template$Version' => '<p>A structure describing the versions of the template.</p>', ], ], 'TemplateVersionDefinition' => [ 'base' => '<p>The detailed definition of a template.</p>', 'refs' => [ 'CreateTemplateRequest$Definition' => '<p>The definition of a template.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p> <p>Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be valid.</p>', 'DescribeTemplateDefinitionResponse$Definition' => '<p>The definition of the template.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', 'UpdateTemplateRequest$Definition' => '<p>The definition of a template.</p> <p>A definition is the data model of all features in a Dashboard, Template, or Analysis.</p>', ], ], 'TemplateVersionSummary' => [ 'base' => '<p>The template version.</p>', 'refs' => [ 'TemplateVersionSummaryList$member' => NULL, ], ], 'TemplateVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateVersionsResponse$TemplateVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified template.</p>', ], ], 'TeradataParameters' => [ 'base' => '<p>The parameters for Teradata.</p>', 'refs' => [ 'DataSourceParameters$TeradataParameters' => '<p>The parameters for Teradata.</p>', ], ], 'TextAreaControlDelimiter' => [ 'base' => NULL, 'refs' => [ 'DefaultTextAreaControlOptions$Delimiter' => '<p>The delimiter that is used to separate the lines in text.</p>', 'FilterTextAreaControl$Delimiter' => '<p>The delimiter that is used to separate the lines in text.</p>', 'ParameterTextAreaControl$Delimiter' => '<p>The delimiter that is used to separate the lines in text.</p>', ], ], 'TextAreaControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultTextAreaControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterTextAreaControl$DisplayOptions' => '<p>The display options of a control.</p>', 'ParameterTextAreaControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'TextConditionalFormat' => [ 'base' => '<p>The conditional formatting for the text.</p>', 'refs' => [ 'PivotTableCellConditionalFormatting$TextFormat' => '<p>The text format of the cell for conditional formatting.</p>', 'TableCellConditionalFormatting$TextFormat' => '<p>The text format of the cell for conditional formatting.</p>', ], ], 'TextControlPlaceholderOptions' => [ 'base' => '<p>The configuration of the placeholder options in a text control.</p>', 'refs' => [ 'TextAreaControlDisplayOptions$PlaceholderOptions' => '<p>The configuration of the placeholder options in a text area control.</p>', 'TextFieldControlDisplayOptions$PlaceholderOptions' => '<p>The configuration of the placeholder options in a text field control.</p>', ], ], 'TextFieldControlDisplayOptions' => [ 'base' => '<p>The display options of a control.</p>', 'refs' => [ 'DefaultTextFieldControlOptions$DisplayOptions' => '<p>The display options of a control.</p>', 'FilterTextFieldControl$DisplayOptions' => '<p>The display options of a control.</p>', 'ParameterTextFieldControl$DisplayOptions' => '<p>The display options of a control.</p>', ], ], 'TextQualifier' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$TextQualifier' => '<p>Text qualifier.</p>', ], ], 'TextWrap' => [ 'base' => NULL, 'refs' => [ 'TableCellStyle$TextWrap' => '<p>The text wrap (none, wrap) for the table cells.</p>', ], ], 'Theme' => [ 'base' => '<p>Summary information about a theme.</p>', 'refs' => [ 'DescribeThemeResponse$Theme' => '<p>The information about the theme that you are describing.</p>', ], ], 'ThemeAlias' => [ 'base' => '<p>An alias for a theme.</p>', 'refs' => [ 'CreateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'DescribeThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'ThemeAliasList$member' => NULL, 'UpdateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', ], ], 'ThemeAliasList' => [ 'base' => NULL, 'refs' => [ 'ListThemeAliasesResponse$ThemeAliasList' => '<p>A structure containing the list of the theme\'s aliases.</p>', ], ], 'ThemeConfiguration' => [ 'base' => '<p>The theme configuration. This configuration contains all of the display properties for a theme.</p>', 'refs' => [ 'CreateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', 'ThemeVersion$Configuration' => '<p>The theme configuration, which contains all the theme display properties.</p>', 'UpdateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', ], ], 'ThemeError' => [ 'base' => '<p>Theme error.</p>', 'refs' => [ 'ThemeErrorList$member' => NULL, ], ], 'ThemeErrorList' => [ 'base' => NULL, 'refs' => [ 'ThemeVersion$Errors' => '<p>Errors associated with the theme.</p>', ], ], 'ThemeErrorType' => [ 'base' => NULL, 'refs' => [ 'ThemeError$Type' => '<p>The type of error.</p>', ], ], 'ThemeName' => [ 'base' => NULL, 'refs' => [ 'CreateThemeRequest$Name' => '<p>A display name for the theme.</p>', 'Theme$Name' => '<p>The name that the user gives to the theme.</p>', 'ThemeSummary$Name' => '<p>the display name for the theme.</p>', 'UpdateThemeRequest$Name' => '<p>The name for the theme.</p>', ], ], 'ThemeSummary' => [ 'base' => '<p>The theme summary.</p>', 'refs' => [ 'ThemeSummaryList$member' => NULL, ], ], 'ThemeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemesResponse$ThemeSummaryList' => '<p>Information about the themes in the list.</p>', ], ], 'ThemeType' => [ 'base' => NULL, 'refs' => [ 'ListThemesRequest$Type' => '<p>The type of themes that you want to list. Valid options include the following:</p> <ul> <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li> <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li> <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li> </ul>', 'Theme$Type' => '<p>The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>', ], ], 'ThemeVersion' => [ 'base' => '<p>A version of a theme.</p>', 'refs' => [ 'Theme$Version' => NULL, ], ], 'ThemeVersionSummary' => [ 'base' => '<p>The theme version.</p>', 'refs' => [ 'ThemeVersionSummaryList$member' => NULL, ], ], 'ThemeVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemeVersionsResponse$ThemeVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified theme.</p>', ], ], 'ThousandSeparatorOptions' => [ 'base' => '<p>The options that determine the thousands separator configuration.</p>', 'refs' => [ 'NumericSeparatorConfiguration$ThousandsSeparator' => '<p>The options that determine the thousands separator configuration.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Access is throttled.</p>', 'refs' => [], ], 'TileLayoutStyle' => [ 'base' => '<p>The display options for the layout of tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$TileLayout' => '<p>The layout options for tiles.</p>', ], ], 'TileStyle' => [ 'base' => '<p>Display options related to tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$Tile' => '<p>The display options for tiles.</p>', ], ], 'TimeBasedForecastProperties' => [ 'base' => '<p>The forecast properties setup of a forecast in the line chart.</p>', 'refs' => [ 'ForecastConfiguration$ForecastProperties' => '<p>The forecast properties setup of a forecast in the line chart.</p>', ], ], 'TimeEqualityFilter' => [ 'base' => '<p>A <code>TimeEqualityFilter</code> filters values that are equal to a given value.</p>', 'refs' => [ 'Filter$TimeEqualityFilter' => '<p>A <code>TimeEqualityFilter</code> filters date-time values that equal or do not equal a given date/time value.</p>', ], ], 'TimeGranularity' => [ 'base' => NULL, 'refs' => [ 'AggregationPartitionBy$TimeGranularity' => '<p>The <code>TimeGranularity</code> for an <code>AggregationPartitionBy</code>.</p>', 'Anchor$TimeGranularity' => '<p>The <code>TimeGranularity</code> of the Anchor.</p>', 'DataPathColor$TimeGranularity' => '<p>The time granularity of the field that the color needs to be applied to.</p>', 'DateDimensionField$DateGranularity' => '<p>The date granularity of the <code>DateDimensionField</code>. Choose one of the following options:</p> <ul> <li> <p> <code>YEAR</code> </p> </li> <li> <p> <code>QUARTER</code> </p> </li> <li> <p> <code>MONTH</code> </p> </li> <li> <p> <code>WEEK</code> </p> </li> <li> <p> <code>DAY</code> </p> </li> <li> <p> <code>HOUR</code> </p> </li> <li> <p> <code>MINUTE</code> </p> </li> <li> <p> <code>SECOND</code> </p> </li> <li> <p> <code>MILLISECOND</code> </p> </li> </ul>', 'DateTimeDatasetParameter$TimeGranularity' => '<p>The time granularity of the date time parameter.</p>', 'DateTimeParameterDeclaration$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'ExcludePeriodConfiguration$Granularity' => '<p>The granularity or unit (day, month, year) of the exclude period.</p>', 'PeriodToDateComputation$PeriodTimeGranularity' => '<p>The time granularity setup of period to date computation. Choose from the following options:</p> <ul> <li> <p>YEAR: Year to date.</p> </li> <li> <p>MONTH: Month to date.</p> </li> </ul>', 'RelativeDatesFilter$MinimumGranularity' => '<p>The minimum granularity (period granularity) of the relative dates filter.</p>', 'RelativeDatesFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TimeEqualityFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TimeRangeDrillDownFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TimeRangeFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TopBottomFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TopicIRFilterOption$TimeGranularity' => '<p>The time granularity for the <code>TopicIRFilterOption</code>.</p>', ], ], 'TimeRangeDrillDownFilter' => [ 'base' => '<p>The time range drill down filter.</p>', 'refs' => [ 'DrillDownFilter$TimeRangeFilter' => '<p>The time range drill down filter. This filter is used for date time columns.</p>', ], ], 'TimeRangeFilter' => [ 'base' => '<p>A <code>TimeRangeFilter</code> filters values that are between two specified values.</p>', 'refs' => [ 'Filter$TimeRangeFilter' => '<p>A <code>TimeRangeFilter</code> filters date-time values that are either inside or outside a given date/time range.</p>', ], ], 'TimeRangeFilterValue' => [ 'base' => '<p>The value of a time range filter.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'TimeRangeFilter$RangeMinimumValue' => '<p>The minimum value for the filter value range.</p>', 'TimeRangeFilter$RangeMaximumValue' => '<p>The maximum value for the filter value range.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Analysis$CreatedTime' => '<p>The time that the analysis was created.</p>', 'Analysis$LastUpdatedTime' => '<p>The time that the analysis was last updated.</p>', 'AnalysisSummary$CreatedTime' => '<p>The time that the analysis was created.</p>', 'AnalysisSummary$LastUpdatedTime' => '<p>The time that the analysis was last updated.</p>', 'AssetBundleExportJobSummary$CreatedTime' => '<p>The time that the export job was created.</p>', 'AssetBundleImportJobRefreshScheduleOverrideParameters$StartAfterDateTime' => '<p>An override for the <code>StartAfterDateTime</code> of a <code>RefreshSchedule</code>. Make sure that the <code>StartAfterDateTime</code> is set to a time that takes place in the future.</p>', 'AssetBundleImportJobSummary$CreatedTime' => '<p>The time that the import job was created.</p>', 'Dashboard$CreatedTime' => '<p>The time that this dashboard was created.</p>', 'Dashboard$LastPublishedTime' => '<p>The last time that this dashboard was published.</p>', 'Dashboard$LastUpdatedTime' => '<p>The last time that this dashboard was updated.</p>', 'DashboardSummary$CreatedTime' => '<p>The time that this dashboard was created.</p>', 'DashboardSummary$LastUpdatedTime' => '<p>The last time that this dashboard was updated.</p>', 'DashboardSummary$LastPublishedTime' => '<p>The last time that this dashboard was published.</p>', 'DashboardVersion$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DashboardVersionSummary$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DataSet$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSet$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSetSummary$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSetSummary$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSource$CreatedTime' => '<p>The time that this data source was created.</p>', 'DataSource$LastUpdatedTime' => '<p>The last time that this data source was updated.</p>', 'DataSourceSummary$CreatedTime' => '<p>The date and time that the data source was created. This value is expressed in MM-DD-YYYY HH:MM:SS format.</p>', 'DataSourceSummary$LastUpdatedTime' => '<p>The date and time the data source was last updated. This value is expressed in MM-DD-YYYY HH:MM:SS format.</p>', 'DeleteAnalysisResponse$DeletionTime' => '<p>The date and time that the analysis is scheduled to be deleted.</p>', 'DescribeAssetBundleExportJobResponse$CreatedTime' => '<p>The time that the export job was created.</p>', 'DescribeAssetBundleImportJobResponse$CreatedTime' => '<p>The time that the import job was created.</p>', 'DescribeDashboardSnapshotJobResponse$CreatedTime' => '<p> The time that the snapshot job was created. </p>', 'DescribeDashboardSnapshotJobResponse$LastUpdatedTime' => '<p> The time that the snapshot job status was last updated. </p>', 'DescribeDashboardSnapshotJobResultResponse$CreatedTime' => '<p>The time that a snapshot job was created.</p>', 'DescribeDashboardSnapshotJobResultResponse$LastUpdatedTime' => '<p>The time that a snapshot job status was last updated.</p>', 'Folder$CreatedTime' => '<p>The time that the folder was created.</p>', 'Folder$LastUpdatedTime' => '<p>The time that the folder was last updated.</p>', 'FolderSummary$CreatedTime' => '<p>The time that the folder was created.</p>', 'FolderSummary$LastUpdatedTime' => '<p>The time that the folder was last updated.</p>', 'Ingestion$CreatedTime' => '<p>The time that this ingestion started.</p>', 'RefreshSchedule$StartAfterDateTime' => '<p>Time after which the refresh schedule can be started, expressed in <code>YYYY-MM-DDTHH:MM:SS</code> format.</p>', 'Template$LastUpdatedTime' => '<p>Time when this was last updated.</p>', 'Template$CreatedTime' => '<p>Time when this was created.</p>', 'TemplateSummary$CreatedTime' => '<p>The last time that this template was created.</p>', 'TemplateSummary$LastUpdatedTime' => '<p>The last time that this template was updated.</p>', 'TemplateVersion$CreatedTime' => '<p>The time that this template version was created.</p>', 'TemplateVersionSummary$CreatedTime' => '<p>The time that this template version was created.</p>', 'Theme$CreatedTime' => '<p>The date and time that the theme was created.</p>', 'Theme$LastUpdatedTime' => '<p>The date and time that the theme was last updated.</p>', 'ThemeSummary$CreatedTime' => '<p>The date and time that this theme was created.</p>', 'ThemeSummary$LastUpdatedTime' => '<p>The last date and time that this theme was updated.</p>', 'ThemeVersion$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'ThemeVersionSummary$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'TimeEqualityFilter$Value' => '<p>The value of a <code>TimeEquality</code> filter.</p> <p>This field is mutually exclusive to <code>RollingDate</code> and <code>ParameterName</code>.</p>', 'TimeRangeDrillDownFilter$RangeMinimum' => '<p>The minimum value for the filter value range.</p>', 'TimeRangeDrillDownFilter$RangeMaximum' => '<p>The maximum value for the filter value range.</p>', 'TimeRangeFilterValue$StaticValue' => '<p>The static input value.</p>', 'TopicRefreshSchedule$StartingAt' => '<p>The starting date and time for the refresh schedule.</p>', 'VPCConnection$CreatedTime' => '<p>The time that the VPC connection was created.</p>', 'VPCConnection$LastUpdatedTime' => '<p>The time that the VPC connection was last updated.</p>', 'VPCConnectionSummary$CreatedTime' => '<p>The time that the VPC connection was created.</p>', 'VPCConnectionSummary$LastUpdatedTime' => '<p>The time that the VPC connection was last updated.</p>', 'WhatIfPointScenario$Date' => '<p>The date that you need the forecast results for.</p>', 'WhatIfRangeScenario$StartDate' => '<p>The start date in the date range that you need the forecast results for.</p>', 'WhatIfRangeScenario$EndDate' => '<p>The end date in the date range that you need the forecast results for.</p>', ], ], 'TooltipItem' => [ 'base' => '<p>The tooltip.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'TooltipItemList$member' => NULL, ], ], 'TooltipItemList' => [ 'base' => NULL, 'refs' => [ 'FieldBasedTooltip$TooltipFields' => '<p>The fields configuration in the tooltip.</p>', ], ], 'TooltipOptions' => [ 'base' => '<p>The display options for the visual tooltip.</p>', 'refs' => [ 'BarChartConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'BoxPlotChartConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'ComboChartConfiguration$Tooltip' => '<p>The legend display setup of the visual.</p>', 'FilledMapConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'FunnelChartConfiguration$Tooltip' => '<p>The tooltip configuration of a <code>FunnelChartVisual</code>.</p>', 'GaugeChartConfiguration$TooltipOptions' => '<p>The tooltip configuration of a <code>GaugeChartVisual</code>.</p>', 'GeospatialMapConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'HeatMapConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'HistogramConfiguration$Tooltip' => '<p>The tooltip configuration of a histogram.</p>', 'LineChartConfiguration$Tooltip' => '<p>The tooltip configuration of a line chart.</p>', 'PieChartConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', 'ScatterPlotConfiguration$Tooltip' => '<p>The legend display setup of the visual.</p>', 'TreeMapConfiguration$Tooltip' => '<p>The tooltip display setup of the visual.</p>', ], ], 'TooltipTarget' => [ 'base' => NULL, 'refs' => [ 'ColumnTooltipItem$TooltipTarget' => '<p>Determines the target of the column tooltip item in a combo chart visual.</p>', 'FieldTooltipItem$TooltipTarget' => '<p>Determines the target of the field tooltip item in a combo chart visual.</p>', ], ], 'TooltipTitleType' => [ 'base' => NULL, 'refs' => [ 'FieldBasedTooltip$TooltipTitleType' => '<p>The type for the &gt;tooltip title. Choose one of the following options:</p> <ul> <li> <p> <code>NONE</code>: Doesn\'t use the primary value as the title.</p> </li> <li> <p> <code>PRIMARY_VALUE</code>: Uses primary value as the title.</p> </li> </ul>', ], ], 'TopBottomComputationType' => [ 'base' => NULL, 'refs' => [ 'TopBottomMoversComputation$Type' => '<p>The computation type. Choose from the following options:</p> <ul> <li> <p>TOP: Top movers computation.</p> </li> <li> <p>BOTTOM: Bottom movers computation.</p> </li> </ul>', 'TopBottomRankedComputation$Type' => '<p>The computation type. Choose one of the following options:</p> <ul> <li> <p>TOP: A top ranked computation.</p> </li> <li> <p>BOTTOM: A bottom ranked computation.</p> </li> </ul>', ], ], 'TopBottomFilter' => [ 'base' => '<p>A <code>TopBottomFilter</code> filters values that are at the top or the bottom.</p>', 'refs' => [ 'Filter$TopBottomFilter' => '<p>A <code>TopBottomFilter</code> filters data to the top or bottom values for a given column.</p>', ], ], 'TopBottomMoversComputation' => [ 'base' => '<p>The top movers and bottom movers computation setup.</p>', 'refs' => [ 'Computation$TopBottomMovers' => '<p>The top movers and bottom movers computation configuration.</p>', ], ], 'TopBottomMoversComputationMoverSize' => [ 'base' => NULL, 'refs' => [ 'TopBottomMoversComputation$MoverSize' => '<p>The mover size setup of the top and bottom movers computation.</p>', ], ], 'TopBottomRankedComputation' => [ 'base' => '<p>The top ranked and bottom ranked computation configuration.</p>', 'refs' => [ 'Computation$TopBottomRanked' => '<p>The top ranked and bottom ranked computation configuration.</p>', ], ], 'TopBottomRankedComputationResultSize' => [ 'base' => NULL, 'refs' => [ 'TopBottomRankedComputation$ResultSize' => '<p>The result size of a top and bottom ranked computation.</p>', ], ], 'TopBottomSortOrder' => [ 'base' => NULL, 'refs' => [ 'TopBottomMoversComputation$SortOrder' => '<p>The sort order setup of the top and bottom movers computation.</p>', ], ], 'TopicCalculatedField' => [ 'base' => '<p>A structure that represents a calculated field.</p>', 'refs' => [ 'TopicCalculatedFields$member' => NULL, ], ], 'TopicCalculatedFields' => [ 'base' => NULL, 'refs' => [ 'DatasetMetadata$CalculatedFields' => '<p>The list of calculated field definitions.</p>', ], ], 'TopicCategoryFilter' => [ 'base' => '<p>A structure that represents a category filter.</p>', 'refs' => [ 'TopicFilter$CategoryFilter' => '<p>The category filter that is associated with this filter.</p>', ], ], 'TopicCategoryFilterConstant' => [ 'base' => '<p>A constant used in a category filter.</p>', 'refs' => [ 'TopicCategoryFilter$Constant' => '<p>The constant used in a category filter.</p>', ], ], 'TopicColumn' => [ 'base' => '<p>Represents a column in a dataset.</p>', 'refs' => [ 'TopicColumns$member' => NULL, ], ], 'TopicColumns' => [ 'base' => NULL, 'refs' => [ 'DatasetMetadata$Columns' => '<p>The list of column definitions.</p>', ], ], 'TopicConstantValue' => [ 'base' => '<p>The definition for a <code>TopicConstantValue</code>.</p>', 'refs' => [ 'TopicIRFilterOption$Constant' => '<p>The constant for the <code>TopicIRFilterOption</code>.</p>', 'TopicIRFilterOption$Range' => '<p>The range for the <code>TopicIRFilterOption</code>.</p>', 'TopicIRFilterOption$LastNextOffset' => '<p>The last next offset for the <code>TopicIRFilterOption</code>.</p>', 'TopicIRFilterOption$TopBottomLimit' => '<p>The <code>TopBottomLimit</code> for the <code>TopicIRFilterOption</code>.</p>', ], ], 'TopicDateRangeFilter' => [ 'base' => '<p>A filter used to restrict data based on a range of dates or times.</p>', 'refs' => [ 'TopicFilter$DateRangeFilter' => '<p>The date range filter.</p>', ], ], 'TopicDetails' => [ 'base' => '<p>A structure that describes the details of a topic, such as its name, description, and associated data sets.</p>', 'refs' => [ 'CreateTopicRequest$Topic' => '<p>The definition of a topic to create.</p>', 'DescribeTopicResponse$Topic' => '<p>The definition of a topic.</p>', 'UpdateTopicRequest$Topic' => '<p>The definition of the topic that you want to update.</p>', ], ], 'TopicFilter' => [ 'base' => '<p>A structure that represents a filter used to select items for a topic.</p>', 'refs' => [ 'TopicFilters$member' => NULL, ], ], 'TopicFilters' => [ 'base' => NULL, 'refs' => [ 'DatasetMetadata$Filters' => '<p>The list of filter definitions.</p>', ], ], 'TopicIR' => [ 'base' => '<p>The definition for a <code>TopicIR</code>.</p>', 'refs' => [ 'CreateTopicReviewedAnswer$Mir' => '<p>The Mir for the <code>CreateTopicReviewedAnswer</code>.</p>', 'TopicReviewedAnswer$Mir' => '<p>The mir for the <code>TopicReviewedAnswer</code>.</p>', 'TopicVisual$Ir' => '<p>The ir for the <code>TopicVisual</code>.</p>', ], ], 'TopicIRComparisonMethod' => [ 'base' => '<p>The definition of a <code>TopicIRComparisonMethod</code>.</p>', 'refs' => [ 'TopicIRMetric$ComparisonMethod' => '<p>The comparison method for the <code>TopicIRMetric</code>.</p>', ], ], 'TopicIRContributionAnalysis' => [ 'base' => '<p>The definition for a <code>TopicIRContributionAnalysis</code>.</p>', 'refs' => [ 'TopicIR$ContributionAnalysis' => '<p>The contribution analysis for the <code>TopicIR</code>.</p>', ], ], 'TopicIRFilterEntry' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterList$member' => NULL, ], ], 'TopicIRFilterFunction' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterOption$Function' => '<p>The function for the <code>TopicIRFilterOption</code>.</p>', ], ], 'TopicIRFilterList' => [ 'base' => NULL, 'refs' => [ 'TopicIR$Filters' => '<p>The filters for the <code>TopicIR</code>.</p>', ], ], 'TopicIRFilterOption' => [ 'base' => '<p>The definition for a <code>TopicIRFilterOption</code>.</p>', 'refs' => [ 'ContributionAnalysisTimeRanges$StartRange' => '<p>The start range for the <code>ContributionAnalysisTimeRanges</code>.</p>', 'ContributionAnalysisTimeRanges$EndRange' => '<p>The end range for the <code>ContributionAnalysisTimeRanges</code>.</p>', 'TopicIRFilterEntry$member' => NULL, ], ], 'TopicIRFilterType' => [ 'base' => NULL, 'refs' => [ 'TopicIRFilterOption$FilterType' => '<p>The filter type for the <code>TopicIRFilterOption</code>.</p>', ], ], 'TopicIRGroupBy' => [ 'base' => '<p>The definition for a <code>TopicIRGroupBy</code>.</p>', 'refs' => [ 'TopicIRGroupByList$member' => NULL, ], ], 'TopicIRGroupByList' => [ 'base' => NULL, 'refs' => [ 'TopicIR$GroupByList' => '<p>The GroupBy list for the <code>TopicIR</code>.</p>', ], ], 'TopicIRMetric' => [ 'base' => '<p>The definition for a <code>TopicIRMetric</code>.</p>', 'refs' => [ 'TopicIRMetricList$member' => NULL, ], ], 'TopicIRMetricList' => [ 'base' => NULL, 'refs' => [ 'TopicIR$Metrics' => '<p>The metrics for the <code>TopicIR</code>.</p>', ], ], 'TopicId' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTopicReviewedAnswerRequest$TopicId' => '<p>The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'BatchCreateTopicReviewedAnswerResponse$TopicId' => '<p>The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'BatchDeleteTopicReviewedAnswerRequest$TopicId' => '<p>The ID for the topic reviewed answer that you want to delete. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'BatchDeleteTopicReviewedAnswerResponse$TopicId' => '<p>The ID of the topic reviewed answer that you want to delete. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateTopicRefreshScheduleRequest$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateTopicRefreshScheduleResponse$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateTopicRequest$TopicId' => '<p>The ID for the topic that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'CreateTopicResponse$TopicId' => '<p>The ID for the topic that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteTopicRefreshScheduleRequest$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteTopicRefreshScheduleResponse$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteTopicRequest$TopicId' => '<p>The ID of the topic that you want to delete. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DeleteTopicResponse$TopicId' => '<p>The ID of the topic that you want to delete. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicPermissionsRequest$TopicId' => '<p>The ID of the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicPermissionsResponse$TopicId' => '<p>The ID of the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicRefreshRequest$TopicId' => '<p>The ID of the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicRefreshScheduleRequest$TopicId' => '<p>The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicRefreshScheduleResponse$TopicId' => '<p>The ID of the topic that contains the refresh schedule that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicRequest$TopicId' => '<p>The ID of the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'DescribeTopicResponse$TopicId' => '<p>The ID of the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'ListTopicRefreshSchedulesRequest$TopicId' => '<p>The ID for the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'ListTopicRefreshSchedulesResponse$TopicId' => '<p>The ID for the topic that you want to describe. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'ListTopicReviewedAnswersRequest$TopicId' => '<p>The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'ListTopicReviewedAnswersResponse$TopicId' => '<p>The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'TopicSummary$TopicId' => '<p>The ID for the topic. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicPermissionsRequest$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicPermissionsResponse$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicRefreshScheduleRequest$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicRefreshScheduleResponse$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicRequest$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', 'UpdateTopicResponse$TopicId' => '<p>The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', ], ], 'TopicNamedEntities' => [ 'base' => NULL, 'refs' => [ 'DatasetMetadata$NamedEntities' => '<p>The list of named entities definitions.</p>', ], ], 'TopicNamedEntity' => [ 'base' => '<p>A structure that represents a named entity.</p>', 'refs' => [ 'TopicNamedEntities$member' => NULL, ], ], 'TopicNumericEqualityFilter' => [ 'base' => '<p>A filter that filters topics based on the value of a numeric field. The filter includes only topics whose numeric field value matches the specified value.</p>', 'refs' => [ 'TopicFilter$NumericEqualityFilter' => '<p>The numeric equality filter.</p>', ], ], 'TopicNumericRangeFilter' => [ 'base' => '<p>A filter that filters topics based on the value of a numeric field. The filter includes only topics whose numeric field value falls within the specified range.</p>', 'refs' => [ 'TopicFilter$NumericRangeFilter' => '<p>The numeric range filter.</p>', ], ], 'TopicNumericSeparatorSymbol' => [ 'base' => NULL, 'refs' => [ 'DisplayFormatOptions$DecimalSeparator' => '<p>Determines the decimal separator.</p>', ], ], 'TopicRangeFilterConstant' => [ 'base' => '<p>A constant value that is used in a range filter to specify the endpoints of the range.</p>', 'refs' => [ 'TopicDateRangeFilter$Constant' => '<p>The constant used in a date range filter.</p>', 'TopicNumericRangeFilter$Constant' => '<p>The constant used in a numeric range filter.</p>', ], ], 'TopicRefreshDetails' => [ 'base' => '<p>The details about the refresh of a topic.</p>', 'refs' => [ 'DescribeTopicRefreshResponse$RefreshDetails' => '<p>Details of the refresh, which is performed when the topic is created or updated.</p>', ], ], 'TopicRefreshSchedule' => [ 'base' => '<p>A structure that represents a topic refresh schedule.</p>', 'refs' => [ 'CreateTopicRefreshScheduleRequest$RefreshSchedule' => '<p>The definition of a refresh schedule.</p>', 'DescribeTopicRefreshScheduleResponse$RefreshSchedule' => '<p>The definition of a refresh schedule.</p>', 'TopicRefreshScheduleSummary$RefreshSchedule' => '<p>The definition of a refresh schedule.</p>', 'UpdateTopicRefreshScheduleRequest$RefreshSchedule' => '<p>The definition of a refresh schedule.</p>', ], ], 'TopicRefreshScheduleSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTopicRefreshSchedulesResponse$RefreshSchedules' => '<p>The list of topic refresh schedules.</p>', ], ], 'TopicRefreshScheduleSummary' => [ 'base' => '<p>A summary of the refresh schedule details for a dataset.</p>', 'refs' => [ 'TopicRefreshScheduleSummaries$member' => NULL, ], ], 'TopicRefreshStatus' => [ 'base' => NULL, 'refs' => [ 'TopicRefreshDetails$RefreshStatus' => '<p>The status of the refresh job that indicates whether the job is still running, completed successfully, or failed.</p>', ], ], 'TopicRelativeDateFilter' => [ 'base' => '<p>A structure that represents a relative date filter.</p>', 'refs' => [ 'TopicFilter$RelativeDateFilter' => '<p>The relative date filter.</p>', ], ], 'TopicRelativeDateFilterFunction' => [ 'base' => NULL, 'refs' => [ 'TopicRelativeDateFilter$RelativeDateFilterFunction' => '<p>The function to be used in a relative date filter to determine the range of dates to include in the results. Valid values for this structure are <code>BEFORE</code>, <code>AFTER</code>, and <code>BETWEEN</code>.</p>', ], ], 'TopicReviewedAnswer' => [ 'base' => '<p>The deinition for a <code>TopicReviewedAnswer</code>.</p>', 'refs' => [ 'TopicReviewedAnswers$member' => NULL, ], ], 'TopicReviewedAnswers' => [ 'base' => NULL, 'refs' => [ 'ListTopicReviewedAnswersResponse$Answers' => '<p>The definition of all Answers in the topic.</p>', ], ], 'TopicScheduleType' => [ 'base' => NULL, 'refs' => [ 'TopicRefreshSchedule$TopicScheduleType' => '<p>The type of refresh schedule. Valid values for this structure are <code>HOURLY</code>, <code>DAILY</code>, <code>WEEKLY</code>, and <code>MONTHLY</code>.</p>', ], ], 'TopicSingularFilterConstant' => [ 'base' => '<p>A structure that represents a singular filter constant, used in filters to specify a single value to match against.</p>', 'refs' => [ 'TopicNumericEqualityFilter$Constant' => '<p>The constant used in a numeric equality filter.</p>', 'TopicRelativeDateFilter$Constant' => '<p>The constant used in a relative date filter.</p>', ], ], 'TopicSortClause' => [ 'base' => '<p>The definition for a <code>TopicSortClause</code>.</p>', 'refs' => [ 'TopicIR$Sort' => '<p>The sort for the <code>TopicIR</code>.</p>', 'TopicIRGroupBy$Sort' => '<p>The sort for the <code>TopicIRGroupBy</code>.</p>', ], ], 'TopicSortDirection' => [ 'base' => NULL, 'refs' => [ 'FilterAggMetrics$SortDirection' => '<p>The sort direction for <code>FilterAggMetrics</code>.</p>', 'TopicIRFilterOption$SortDirection' => '<p>The sort direction for the <code>TopicIRFilterOption</code>.</p>', 'TopicSortClause$SortDirection' => '<p>The sort direction for the <code>TopicSortClause</code>.</p>', ], ], 'TopicSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTopicsResponse$TopicsSummaries' => '<p>A list of topic summaries.</p>', ], ], 'TopicSummary' => [ 'base' => '<p>A topic summary.</p>', 'refs' => [ 'TopicSummaries$member' => NULL, ], ], 'TopicTemplate' => [ 'base' => '<p>The definition for a <code>TopicTemplate</code>.</p>', 'refs' => [ 'CreateTopicReviewedAnswer$Template' => '<p>The template for the <code>CreateTopicReviewedAnswer</code>.</p>', 'TopicReviewedAnswer$Template' => '<p>The template for the <code>TopicReviewedAnswer</code>.</p>', ], ], 'TopicTimeGranularity' => [ 'base' => NULL, 'refs' => [ 'AggFunction$Period' => '<p>The period of an Agg function.</p>', 'DataAggregation$DatasetRowDateGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TopicCalculatedField$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TopicColumn$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', 'TopicIRComparisonMethod$Period' => '<p>The period for the <code>TopicIRComparisonMethod</code>.</p>', 'TopicIRGroupBy$TimeGranularity' => '<p>The time granularity for the <code>TopicIRGroupBy</code>.</p>', 'TopicRelativeDateFilter$TimeGranularity' => '<p>The level of time precision that is used to aggregate <code>DateTime</code> values.</p>', ], ], 'TopicUserExperienceVersion' => [ 'base' => NULL, 'refs' => [ 'TopicDetails$UserExperienceVersion' => '<p>The user experience version of a topic.</p>', 'TopicSummary$UserExperienceVersion' => '<p>The user experience version of the topic.</p>', ], ], 'TopicVisual' => [ 'base' => '<p>The definition for a <code>TopicVisual</code>.</p>', 'refs' => [ 'CreateTopicReviewedAnswer$PrimaryVisual' => '<p>The <code>PrimaryVisual</code> for the <code>CreateTopicReviewedAnswer</code>.</p>', 'TopicReviewedAnswer$PrimaryVisual' => '<p>The primary visual for the <code>TopicReviewedAnswer</code>.</p>', 'TopicVisuals$member' => NULL, ], ], 'TopicVisuals' => [ 'base' => NULL, 'refs' => [ 'TopicVisual$SupportingVisuals' => '<p>The supporting visuals for the <code>TopicVisual</code>.</p>', ], ], 'TotalAggregationComputation' => [ 'base' => '<p>The total aggregation computation configuration.</p>', 'refs' => [ 'Computation$TotalAggregation' => '<p>The total aggregation computation configuration.</p>', ], ], 'TotalAggregationFunction' => [ 'base' => '<p>An aggregation function that aggregates the total values of a measure.</p>', 'refs' => [ 'TotalAggregationOption$TotalAggregationFunction' => '<p>The total aggregation function that you want to set for a specified field id.</p>', ], ], 'TotalAggregationOption' => [ 'base' => '<p>The total aggregation settings map of a field id.</p>', 'refs' => [ 'TotalAggregationOptionList$member' => NULL, ], ], 'TotalAggregationOptionList' => [ 'base' => NULL, 'refs' => [ 'PivotTotalOptions$TotalAggregationOptions' => '<p>The total aggregation options for each value field.</p>', 'TotalOptions$TotalAggregationOptions' => '<p>The total aggregation settings for each value field.</p>', ], ], 'TotalOptions' => [ 'base' => '<p>The total options for a table visual.</p>', 'refs' => [ 'TableConfiguration$TotalOptions' => '<p>The total options for a table visual.</p>', ], ], 'TransformOperation' => [ 'base' => '<p>A data transformation on a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'TransformOperationList$member' => NULL, ], ], 'TransformOperationList' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$DataTransforms' => '<p>Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. </p>', ], ], 'TreeMapAggregatedFieldWells' => [ 'base' => '<p>Aggregated field wells of a tree map.</p>', 'refs' => [ 'TreeMapFieldWells$TreeMapAggregatedFieldWells' => '<p>The aggregated field wells of a tree map.</p>', ], ], 'TreeMapConfiguration' => [ 'base' => '<p>The configuration of a tree map.</p>', 'refs' => [ 'TreeMapVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'TreeMapDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'TreeMapAggregatedFieldWells$Groups' => '<p>The group by field well of a tree map. Values are grouped based on group by fields.</p>', ], ], 'TreeMapFieldWells' => [ 'base' => '<p>The field wells of a tree map.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'TreeMapConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'TreeMapMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'TreeMapAggregatedFieldWells$Sizes' => '<p>The size field well of a tree map. Values are aggregated based on group by fields.</p>', 'TreeMapAggregatedFieldWells$Colors' => '<p>The color field well of a tree map. Values are grouped by aggregations based on group by fields.</p>', ], ], 'TreeMapSortConfiguration' => [ 'base' => '<p>The sort configuration of a tree map.</p>', 'refs' => [ 'TreeMapConfiguration$SortConfiguration' => '<p>The sort configuration of a tree map.</p>', ], ], 'TreeMapVisual' => [ 'base' => '<p>A tree map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using tree maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$TreeMapVisual' => '<p>A tree map.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using tree maps</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'TrendArrowOptions' => [ 'base' => '<p>The options that determine the presentation of trend arrows in a KPI visual.</p>', 'refs' => [ 'KPIOptions$TrendArrows' => '<p>The options that determine the presentation of trend arrows in a KPI visual.</p>', ], ], 'TrinoParameters' => [ 'base' => '<p>The parameters that are required to connect to a Trino data source.</p>', 'refs' => [ 'DataSourceParameters$TrinoParameters' => '<p>The parameters that are required to connect to a Trino data source.</p>', ], ], 'TwitterParameters' => [ 'base' => '<p>The parameters for Twitter.</p>', 'refs' => [ 'DataSourceParameters$TwitterParameters' => '<p>The parameters for Twitter.</p>', ], ], 'TypeCastFormat' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$Format' => '<p>When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.</p>', ], ], 'TypeParameters' => [ 'base' => NULL, 'refs' => [ 'SemanticEntityType$TypeParameters' => '<p>The semantic entity type parameters.</p>', 'SemanticType$TypeParameters' => '<p>The semantic type parameters.</p>', ], ], 'Typography' => [ 'base' => '<p>Determines the typography options.</p>', 'refs' => [ 'ThemeConfiguration$Typography' => NULL, ], ], 'UIColorPalette' => [ 'base' => '<p>The theme colors that apply to UI and to charts, excluding data colors. The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p>', 'refs' => [ 'ThemeConfiguration$UIColorPalette' => '<p>Color properties that apply to the UI and to charts, excluding the colors that apply to data. </p>', ], ], 'URLOperationTemplate' => [ 'base' => NULL, 'refs' => [ 'CustomActionURLOperation$URLTemplate' => '<p>THe URL link of the <code>CustomActionURLOperation</code>.</p>', 'CustomContentConfiguration$ContentUrl' => '<p>The input URL that links to the custom content that you want in the custom visual.</p>', ], ], 'URLTargetConfiguration' => [ 'base' => NULL, 'refs' => [ 'CustomActionURLOperation$URLTarget' => '<p>The target of the <code>CustomActionURLOperation</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>NEW_TAB</code>: Opens the target URL in a new browser tab.</p> </li> <li> <p> <code>NEW_WINDOW</code>: Opens the target URL in a new browser window.</p> </li> <li> <p> <code>SAME_TAB</code>: Opens the target URL in the same browser tab.</p> </li> </ul>', 'TableFieldLinkConfiguration$Target' => '<p>The URL target (new tab, new window, same tab) for the table link configuration.</p>', ], ], 'UnaggregatedField' => [ 'base' => '<p>The unaggregated field for a table.</p>', 'refs' => [ 'UnaggregatedFieldList$member' => NULL, ], ], 'UnaggregatedFieldList' => [ 'base' => NULL, 'refs' => [ 'TableUnaggregatedFieldWells$Values' => '<p>The values field well for a pivot table. Values are unaggregated for an unaggregated table.</p>', ], ], 'UndefinedSpecifiedValueType' => [ 'base' => NULL, 'refs' => [ 'ComparativeOrder$TreatUndefinedSpecifiedValues' => '<p>The treat of undefined specified values. Valid values for this structure are <code>LEAST</code> and <code>MOST</code>.</p>', ], ], 'UnicodeIcon' => [ 'base' => NULL, 'refs' => [ 'ConditionalFormattingCustomIconOptions$UnicodeIcon' => '<p>Determines the Unicode icon type.</p>', ], ], 'UniqueValuesComputation' => [ 'base' => '<p>The unique values computation configuration.</p>', 'refs' => [ 'Computation$UniqueValues' => '<p>The unique values computation configuration.</p>', ], ], 'UnlimitedPixelLength' => [ 'base' => 'String based length that is composed of value and unit in px with Integer.MAX_VALUE as maximum value', 'refs' => [ 'FreeFormLayoutElement$YAxisLocation' => '<p>The y-axis coordinate of the element.</p>', ], ], 'UnsupportedPricingPlanException' => [ 'base' => '<p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p> <p>After capacity pricing is added, you can use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>', 'refs' => [], ], 'UnsupportedUserEditionException' => [ 'base' => '<p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn\'t include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>', 'refs' => [], ], 'UntagColumnOperation' => [ 'base' => '<p>A transform operation that removes tags associated with a column.</p>', 'refs' => [ 'TransformOperation$UntagColumnOperation' => NULL, ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardLinksRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardLinksResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityPropagationConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityPropagationConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIpRestrictionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIpRestrictionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKeyRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKeyRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLinkPermissionList' => [ 'base' => NULL, 'refs' => [ 'UpdateDashboardPermissionsRequest$GrantLinkPermissions' => '<p>Grants link permissions to all users in a defined namespace.</p>', 'UpdateDashboardPermissionsRequest$RevokeLinkPermissions' => '<p>Revokes link permissions from all users in a defined namespace.</p>', ], ], 'UpdatePublicSharingSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePublicSharingSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'UpdateAnalysisPermissionsRequest$GrantPermissions' => '<p>A structure that describes the permissions to add and the principal to add them to.</p>', 'UpdateAnalysisPermissionsRequest$RevokePermissions' => '<p>A structure that describes the permissions to remove and the principal to remove them from.</p>', 'UpdateDashboardPermissionsRequest$GrantPermissions' => '<p>The permissions that you want to grant on this resource.</p>', 'UpdateDashboardPermissionsRequest$RevokePermissions' => '<p>The permissions that you want to revoke from this resource.</p>', 'UpdateTemplatePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted on the template. </p>', 'UpdateTemplatePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the template. </p>', 'UpdateThemePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted for the theme.</p>', 'UpdateThemePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the theme.</p>', 'UpdateTopicPermissionsRequest$GrantPermissions' => '<p>The resource permissions that you want to grant to the topic.</p>', 'UpdateTopicPermissionsRequest$RevokePermissions' => '<p>The resource permissions that you want to revoke from the topic.</p>', ], ], 'UpdateRoleCustomPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoleCustomPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSPICECapacityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSPICECapacityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicRefreshScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicRefreshScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVPCConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVPCConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadSettings' => [ 'base' => '<p>Information about the format for a source file or files.</p>', 'refs' => [ 'S3Source$UploadSettings' => '<p>Information about the format for the S3 source file or files.</p>', ], ], 'User' => [ 'base' => '<p>A registered user of Amazon QuickSight. </p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>The user name.</p>', 'RegisterUserResponse$User' => '<p>The user\'s user name.</p>', 'UpdateUserResponse$User' => '<p>The Amazon QuickSight user.</p>', 'UserList$member' => NULL, ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserList' => '<p>The list of users.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'DeleteUserRequest$UserName' => '<p>The name of the user that you want to delete.</p>', 'DescribeUserRequest$UserName' => '<p>The name of the user that you want to describe.</p>', 'ListIAMPolicyAssignmentsForUserRequest$UserName' => '<p>The name of the user.</p>', 'ListUserGroupsRequest$UserName' => '<p>The Amazon QuickSight user name that you want to list group memberships for.</p>', 'RegisterUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>', 'UpdateUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to update.</p>', 'User$UserName' => '<p>The user\'s user name. This value is required if you are registering a user that will be managed in Amazon QuickSight. In the output, the value for <code>UserName</code> is <code>N/A</code> when the value for <code>IdentityType</code> is <code>IAM</code> and the corresponding IAM user is deleted.</p>', ], ], 'UserRole' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$UserRole' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> <li> <p> <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive summaries from dashboards.</p> </li> <li> <p> <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and generate executive summaries from dashboards.</p> </li> <li> <p> <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings. Admin Pro users are billed at Author Pro pricing.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', 'UpdateUserRequest$Role' => '<p>The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> <li> <p> <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive summaries from dashboards.</p> </li> <li> <p> <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and generate executive summaries from dashboards.</p> </li> <li> <p> <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings. Admin Pro users are billed at Author Pro pricing.</p> </li> </ul> <p>The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.</p>', 'User$Role' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:.</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon Amazon QuickSight settings.</p> </li> <li> <p> <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access to Amazon Q in Amazon QuickSight, can build stories with Amazon Q, and can generate executive summaries from dashboards.</p> </li> <li> <p> <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and generate executive summaries from dashboards.</p> </li> <li> <p> <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings. Admin Pro users are billed at Author Pro pricing.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', ], ], 'VPCConnection' => [ 'base' => '<p>The structure of a VPC connection.</p>', 'refs' => [ 'DescribeVPCConnectionResponse$VPCConnection' => '<p>A response object that provides information for the specified VPC connection.</p>', ], ], 'VPCConnectionAvailabilityStatus' => [ 'base' => NULL, 'refs' => [ 'CreateVPCConnectionResponse$AvailabilityStatus' => '<p>The availability status of the VPC connection.</p>', 'DeleteVPCConnectionResponse$AvailabilityStatus' => '<p>The availability status of the VPC connection.</p>', 'UpdateVPCConnectionResponse$AvailabilityStatus' => '<p>The availability status of the VPC connection.</p>', 'VPCConnection$AvailabilityStatus' => '<p>The availability status of the VPC connection.</p>', 'VPCConnectionSummary$AvailabilityStatus' => '<p>The availability status of the VPC connection.</p>', ], ], 'VPCConnectionResourceIdRestricted' => [ 'base' => NULL, 'refs' => [ 'CreateVPCConnectionRequest$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'CreateVPCConnectionResponse$VPCConnectionId' => '<p>The ID for the VPC connection that you\'re creating. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>', ], ], 'VPCConnectionResourceIdUnrestricted' => [ 'base' => NULL, 'refs' => [ 'AssetBundleImportJobVPCConnectionOverrideParameters$VPCConnectionId' => '<p>The ID of the VPC Connection to apply overrides to.</p>', 'DeleteVPCConnectionRequest$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'DeleteVPCConnectionResponse$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'DescribeVPCConnectionRequest$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'UpdateVPCConnectionRequest$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re updating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'UpdateVPCConnectionResponse$VPCConnectionId' => '<p>The ID of the VPC connection that you are updating. This ID is a unique identifier for each Amazon Web Services Region in anAmazon Web Services account.</p>', 'VPCConnection$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', 'VPCConnectionSummary$VPCConnectionId' => '<p>The ID of the VPC connection that you\'re creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.</p>', ], ], 'VPCConnectionResourceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateVPCConnectionResponse$CreationStatus' => '<p>The status of the creation of the VPC connection.</p>', 'DeleteVPCConnectionResponse$DeletionStatus' => '<p>The deletion status of the VPC connection.</p>', 'UpdateVPCConnectionResponse$UpdateStatus' => '<p>The update status of the VPC connection\'s last update.</p>', 'VPCConnection$Status' => '<p>The status of the VPC connection.</p>', 'VPCConnectionSummary$Status' => '<p>The status of the VPC connection.</p>', ], ], 'VPCConnectionSummary' => [ 'base' => '<p>The summary metadata that describes a VPC connection.</p>', 'refs' => [ 'VPCConnectionSummaryList$member' => NULL, ], ], 'VPCConnectionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListVPCConnectionsResponse$VPCConnectionSummaries' => '<p>A <code>VPCConnectionSummaries</code> object that returns a summary of VPC connection objects.</p>', ], ], 'ValidationStrategy' => [ 'base' => '<p>The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects. When you set this value to <code>LENIENT</code>, validation is skipped for specific errors.</p>', 'refs' => [ 'CreateAnalysisRequest$ValidationStrategy' => '<p>The option to relax the validation needed to create an analysis with definition objects. This skips the validation step for specific errors.</p>', 'CreateDashboardRequest$ValidationStrategy' => '<p>The option to relax the validation needed to create a dashboard with definition objects. This option skips the validation step for specific errors.</p>', 'CreateTemplateRequest$ValidationStrategy' => '<p>TThe option to relax the validation needed to create a template with definition objects. This skips the validation step for specific errors.</p>', 'UpdateAnalysisRequest$ValidationStrategy' => '<p>The option to relax the validation needed to update an analysis with definition objects. This skips the validation step for specific errors.</p>', 'UpdateDashboardRequest$ValidationStrategy' => '<p>The option to relax the validation needed to update a dashboard with definition objects. This skips the validation step for specific errors.</p>', 'UpdateTemplateRequest$ValidationStrategy' => '<p>The option to relax the validation needed to update a template with definition objects. This skips the validation step for specific errors.</p>', ], ], 'ValidationStrategyMode' => [ 'base' => NULL, 'refs' => [ 'ValidationStrategy$Mode' => '<p>The mode of validation for the asset to be created or updated. When you set this value to <code>STRICT</code>, strict validation for every error is enforced. When you set this value to <code>LENIENT</code>, validation is skipped for specific UI errors.</p>', ], ], 'ValueWhenUnsetOption' => [ 'base' => NULL, 'refs' => [ 'DateTimeValueWhenUnsetConfiguration$ValueWhenUnsetOption' => '<p>The built-in options for default values. The value can be one of the following:</p> <ul> <li> <p> <code>RECOMMENDED</code>: The recommended value.</p> </li> <li> <p> <code>NULL</code>: The <code>NULL</code> value.</p> </li> </ul>', 'DecimalValueWhenUnsetConfiguration$ValueWhenUnsetOption' => '<p>The built-in options for default values. The value can be one of the following:</p> <ul> <li> <p> <code>RECOMMENDED</code>: The recommended value.</p> </li> <li> <p> <code>NULL</code>: The <code>NULL</code> value.</p> </li> </ul>', 'IntegerValueWhenUnsetConfiguration$ValueWhenUnsetOption' => '<p>The built-in options for default values. The value can be one of the following:</p> <ul> <li> <p> <code>RECOMMENDED</code>: The recommended value.</p> </li> <li> <p> <code>NULL</code>: The <code>NULL</code> value.</p> </li> </ul>', 'StringValueWhenUnsetConfiguration$ValueWhenUnsetOption' => '<p>The built-in options for default values. The value can be one of the following:</p> <ul> <li> <p> <code>RECOMMENDED</code>: The recommended value.</p> </li> <li> <p> <code>NULL</code>: The <code>NULL</code> value.</p> </li> </ul>', ], ], 'VersionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'CreateTemplateRequest$VersionDescription' => '<p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'CreateThemeRequest$VersionDescription' => '<p>A description of the first version of the theme that you\'re creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>', 'DashboardVersion$Description' => '<p>Description.</p>', 'DashboardVersionSummary$Description' => '<p>Description.</p>', 'TemplateVersion$Description' => '<p>The description of the template.</p>', 'TemplateVersionSummary$Description' => '<p>The description of the template version.</p>', 'ThemeVersion$Description' => '<p>The description of the theme.</p>', 'ThemeVersionSummary$Description' => '<p>The description of the theme version.</p>', 'UpdateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'UpdateTemplateRequest$VersionDescription' => '<p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'UpdateThemeRequest$VersionDescription' => '<p>A description of the theme version that you\'re updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>', ], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'CreateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme.</p>', 'DashboardSummary$PublishedVersionNumber' => '<p>Published version number.</p>', 'DashboardVersion$VersionNumber' => '<p>Version number for this version of the dashboard.</p>', 'DashboardVersionSummary$VersionNumber' => '<p>Version number.</p>', 'DeleteDashboardRequest$VersionNumber' => '<p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>', 'DeleteTemplateRequest$VersionNumber' => '<p>Specifies the version of the template that you want to delete. If you don\'t provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>', 'DeleteThemeRequest$VersionNumber' => '<p>The version of the theme that you want to delete. </p> <p> <b>Note:</b> If you don\'t provide a version number, you\'re using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>', 'DescribeDashboardDefinitionRequest$VersionNumber' => '<p>The version number for the dashboard. If a version number isn\'t passed, the latest published dashboard version is described. </p>', 'DescribeDashboardRequest$VersionNumber' => '<p>The version number for the dashboard. If a version number isn\'t passed, the latest published dashboard version is described. </p>', 'DescribeTemplateDefinitionRequest$VersionNumber' => '<p>The version number of the template.</p>', 'DescribeTemplateRequest$VersionNumber' => '<p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the template is described.</p>', 'DescribeThemeRequest$VersionNumber' => '<p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the theme is described.</p>', 'TemplateAlias$TemplateVersionNumber' => '<p>The version number of the template alias.</p>', 'TemplateSummary$LatestVersionNumber' => '<p>A structure containing a list of version numbers for the template summary.</p>', 'TemplateVersion$VersionNumber' => '<p>The version number of the template version.</p>', 'TemplateVersionSummary$VersionNumber' => '<p>The version number of the template version.</p>', 'ThemeAlias$ThemeVersionNumber' => '<p>The version number of the theme alias.</p>', 'ThemeSummary$LatestVersionNumber' => '<p>The latest version number for the theme. </p>', 'ThemeVersion$VersionNumber' => '<p>The version number of the theme.</p>', 'ThemeVersionSummary$VersionNumber' => '<p>The version number of the theme version.</p>', 'UpdateDashboardPublishedVersionRequest$VersionNumber' => '<p>The version number of the dashboard.</p>', 'UpdateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'UpdateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme that the alias should reference.</p>', ], ], 'VerticalTextAlignment' => [ 'base' => NULL, 'refs' => [ 'TableCellStyle$VerticalTextAlignment' => '<p>The vertical text alignment (top, middle, bottom) for the table cells.</p>', ], ], 'Visibility' => [ 'base' => NULL, 'refs' => [ 'AxisDisplayOptions$AxisLineVisibility' => '<p>Determines whether or not the axis line is visible.</p>', 'AxisDisplayOptions$GridLineVisibility' => '<p>Determines whether or not the grid line is visible.</p>', 'BoxPlotOptions$OutlierVisibility' => '<p>Determines the visibility of the outlier in a box plot.</p>', 'BoxPlotOptions$AllDataPointsVisibility' => '<p>Determines the visibility of all data points of the box plot.</p>', 'ChartAxisLabelOptions$Visibility' => '<p>The visibility of an axis label on a chart. Choose one of the following options:</p> <ul> <li> <p> <code>VISIBLE</code>: Shows the axis.</p> </li> <li> <p> <code>HIDDEN</code>: Hides the axis.</p> </li> </ul>', 'ChartAxisLabelOptions$SortIconVisibility' => '<p>The visibility configuration of the sort icon on a chart\'s axis label.</p>', 'ColumnTooltipItem$Visibility' => '<p>The visibility of the tooltip item.</p>', 'DataLabelOptions$Visibility' => '<p>Determines the visibility of the data labels.</p>', 'DataLabelOptions$CategoryLabelVisibility' => '<p>Determines the visibility of the category field labels.</p>', 'DataLabelOptions$MeasureLabelVisibility' => '<p>Determines the visibility of the measure field labels.</p>', 'DataLabelOptions$TotalsVisibility' => '<p>Determines the visibility of the total.</p>', 'DataPathLabelType$Visibility' => '<p>The visibility of the data label.</p>', 'DateAxisOptions$MissingDateVisibility' => '<p>Determines whether or not missing dates are displayed.</p>', 'DateTimePickerControlDisplayOptions$HelperTextVisibility' => '<p>The helper text visibility of the <code>DateTimePickerControlDisplayOptions</code>.</p>', 'DateTimePickerControlDisplayOptions$DateIconVisibility' => '<p>The date icon visibility of the <code>DateTimePickerControlDisplayOptions</code>.</p>', 'DonutCenterOptions$LabelVisibility' => '<p>Determines the visibility of the label in a donut chart. In the Amazon QuickSight console, this option is called <code>\'Show total\'</code>.</p>', 'FieldBasedTooltip$AggregationVisibility' => '<p>The visibility of <code>Show aggregations</code>.</p>', 'FieldLabelType$Visibility' => '<p>The visibility of the field label.</p>', 'FieldTooltipItem$Visibility' => '<p>The visibility of the tooltip item.</p>', 'FreeFormLayoutElement$Visibility' => '<p>The visibility of an element within a free-form layout.</p>', 'FreeFormLayoutElementBackgroundStyle$Visibility' => '<p>The background visibility of a free-form layout element.</p>', 'FreeFormLayoutElementBorderStyle$Visibility' => '<p>The border visibility of a free-form layout element.</p>', 'FunnelChartDataLabelOptions$Visibility' => '<p>The visibility option that determines if data labels are displayed.</p>', 'FunnelChartDataLabelOptions$CategoryLabelVisibility' => '<p>The visibility of the category labels within the data labels.</p>', 'FunnelChartDataLabelOptions$MeasureLabelVisibility' => '<p>The visibility of the measure labels within the data labels.</p>', 'KPISparklineOptions$Visibility' => '<p>The visibility of the sparkline.</p>', 'KPISparklineOptions$TooltipVisibility' => '<p>The tooltip visibility of the sparkline.</p>', 'LabelOptions$Visibility' => '<p>Determines whether or not the label is visible.</p>', 'LegendOptions$Visibility' => '<p>Determines whether or not the legend is visible.</p>', 'LineChartLineStyleSettings$LineVisibility' => '<p>Configuration option that determines whether to show the line for the series.</p>', 'LineChartMarkerStyleSettings$MarkerVisibility' => '<p>Configuration option that determines whether to show the markers in the series.</p>', 'ListControlSearchOptions$Visibility' => '<p>The visibility configuration of the search options in a list control.</p>', 'ListControlSelectAllOptions$Visibility' => '<p>The visibility configuration of the <code>Select all</code> options in a list control.</p>', 'LoadingAnimation$Visibility' => '<p>The visibility configuration of <code>LoadingAnimation</code>.</p>', 'MaximumLabelType$Visibility' => '<p>The visibility of the maximum label.</p>', 'MinimumLabelType$Visibility' => '<p>The visibility of the minimum label.</p>', 'PanelConfiguration$BorderVisibility' => '<p>Determines whether or not each panel displays a border.</p>', 'PanelConfiguration$GutterVisibility' => '<p>Determines whether or not negative space between sibling panels is rendered.</p>', 'PanelConfiguration$BackgroundVisibility' => '<p>Determines whether or not a background for each small multiples panel is rendered.</p>', 'PanelTitleOptions$Visibility' => '<p>Determines whether or not panel titles are displayed.</p>', 'PivotTableFieldOption$Visibility' => '<p>The visibility of the pivot table field.</p>', 'PivotTableOptions$SingleMetricVisibility' => '<p>The visibility of the single metric options.</p>', 'PivotTableOptions$ColumnNamesVisibility' => '<p>The visibility of the column names.</p>', 'PivotTableOptions$ToggleButtonsVisibility' => '<p>Determines the visibility of the pivot table.</p>', 'PivotTableOptions$CollapsedRowDimensionsVisibility' => '<p>The visibility setting of a pivot table\'s collapsed row dimension fields. If the value of this structure is <code>HIDDEN</code>, all collapsed columns in a pivot table are automatically hidden. The default value is <code>VISIBLE</code>.</p>', 'PivotTablePaginatedReportOptions$VerticalOverflowVisibility' => '<p>The visibility of the printing table overflow across pages.</p>', 'PivotTablePaginatedReportOptions$OverflowColumnHeaderVisibility' => '<p>The visibility of the repeating header rows on each page.</p>', 'PivotTableRowsLabelOptions$Visibility' => '<p>The visibility of the rows label.</p>', 'PivotTotalOptions$TotalsVisibility' => '<p>The visibility configuration for the total cells.</p>', 'ProgressBarOptions$Visibility' => '<p>The visibility of the progress bar.</p>', 'RadarChartAreaStyleSettings$Visibility' => '<p>The visibility settings of a radar chart.</p>', 'RadarChartConfiguration$AlternateBandColorsVisibility' => '<p>Determines the visibility of the colors of alternatign bands in a radar chart.</p>', 'RangeEndsLabelType$Visibility' => '<p>The visibility of the range ends label.</p>', 'ScrollBarOptions$Visibility' => '<p>The visibility of the data zoom scroll bar.</p>', 'SecondaryValueOptions$Visibility' => '<p>Determines the visibility of the secondary value.</p>', 'SheetControlInfoIconLabelOptions$Visibility' => '<p>The visibility configuration of info icon label options.</p>', 'SheetElementConfigurationOverrides$Visibility' => '<p>Determines whether or not the overrides are visible. Choose one of the following options:</p> <ul> <li> <p> <code>VISIBLE</code> </p> </li> <li> <p> <code>HIDDEN</code> </p> </li> </ul>', 'SubtotalOptions$TotalsVisibility' => '<p>The visibility configuration for the subtotal cells.</p>', 'TableCellStyle$Visibility' => '<p>The visibility of the table cells.</p>', 'TableFieldOption$Visibility' => '<p>The visibility of a table field.</p>', 'TablePaginatedReportOptions$VerticalOverflowVisibility' => '<p>The visibility of printing table overflow across pages.</p>', 'TablePaginatedReportOptions$OverflowColumnHeaderVisibility' => '<p>The visibility of repeating header rows on each page.</p>', 'TextControlPlaceholderOptions$Visibility' => '<p>The visibility configuration of the placeholder options in a text control.</p>', 'ThousandSeparatorOptions$Visibility' => '<p>Determines the visibility of the thousands separator.</p>', 'TooltipOptions$TooltipVisibility' => '<p>Determines whether or not the tooltip is visible.</p>', 'TotalOptions$TotalsVisibility' => '<p>The visibility configuration for the total cells.</p>', 'TrendArrowOptions$Visibility' => '<p>The visibility of the trend arrows.</p>', 'VisualSubtitleLabelOptions$Visibility' => '<p>The visibility of the subtitle label.</p>', 'VisualTitleLabelOptions$Visibility' => '<p>The visibility of the title label.</p>', ], ], 'VisiblePanelColumns' => [ 'base' => NULL, 'refs' => [ 'SmallMultiplesOptions$MaxVisibleColumns' => '<p>Sets the maximum number of visible columns to display in the grid of small multiples panels.</p> <p>The default is <code>Auto</code>, which automatically adjusts the columns in the grid to fit the overall layout and size of the given chart.</p>', ], ], 'VisiblePanelRows' => [ 'base' => NULL, 'refs' => [ 'SmallMultiplesOptions$MaxVisibleRows' => '<p>Sets the maximum number of visible rows to display in the grid of small multiples panels.</p> <p>The default value is <code>Auto</code>, which automatically adjusts the rows in the grid to fit the overall layout and size of the given chart.</p>', ], ], 'VisibleRangeOptions' => [ 'base' => '<p>The range options for the data zoom scroll bar.</p>', 'refs' => [ 'ScrollBarOptions$VisibleRange' => '<p>The visibility range for the data zoom scroll bar.</p>', ], ], 'Visual' => [ 'base' => '<p>A visual displayed on a sheet in an analysis, dashboard, or template.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'VisualList$member' => NULL, ], ], 'VisualAxisSortOption' => [ 'base' => '<p>The axis sort options for a visual.</p>', 'refs' => [ 'DashboardPublishOptions$VisualAxisSortOption' => '<p>The axis sort options of a dashboard.</p>', ], ], 'VisualCustomAction' => [ 'base' => '<p>A custom action defined on a visual.</p>', 'refs' => [ 'VisualCustomActionList$member' => NULL, ], ], 'VisualCustomActionList' => [ 'base' => NULL, 'refs' => [ 'BarChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'BoxPlotVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'ComboChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'CustomContentVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'EmptyVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'FilledMapVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'FunnelChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'GaugeChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'GeospatialMapVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'HeatMapVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'HistogramVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'InsightVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'KPIVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'LineChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'PieChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'PivotTableVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'RadarChartVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'SankeyDiagramVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'ScatterPlotVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'TableVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'TreeMapVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'WaterfallVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', 'WordCloudVisual$Actions' => '<p>The list of custom actions that are configured for a visual.</p>', ], ], 'VisualCustomActionName' => [ 'base' => NULL, 'refs' => [ 'VisualCustomAction$Name' => '<p>The name of the <code>VisualCustomAction</code>.</p>', ], ], 'VisualCustomActionOperation' => [ 'base' => '<p>The operation that is defined by the custom action.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'VisualCustomActionOperationList$member' => NULL, ], ], 'VisualCustomActionOperationList' => [ 'base' => NULL, 'refs' => [ 'VisualCustomAction$ActionOperations' => '<p>A list of <code>VisualCustomActionOperations</code>.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', ], ], 'VisualCustomActionTrigger' => [ 'base' => NULL, 'refs' => [ 'VisualCustomAction$Trigger' => '<p>The trigger of the <code>VisualCustomAction</code>.</p> <p>Valid values are defined as follows:</p> <ul> <li> <p> <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.</p> </li> <li> <p> <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.</p> </li> </ul>', ], ], 'VisualInteractionOptions' => [ 'base' => '<p>The general visual interactions setup for visual publish options</p>', 'refs' => [ 'BarChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'BoxPlotChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'ComboChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'CustomContentConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'FilledMapConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'FunnelChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'GaugeChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'GeospatialMapConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'HeatMapConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'HistogramConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'InsightConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'KPIConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'LineChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'PieChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'PivotTableConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'RadarChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'SankeyDiagramChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'ScatterPlotConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'TableConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'TreeMapConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'WaterfallChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', 'WordCloudChartConfiguration$Interactions' => '<p>The general visual interactions setup for a visual.</p>', ], ], 'VisualList' => [ 'base' => NULL, 'refs' => [ 'SheetDefinition$Visuals' => '<p>A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.</p>', ], ], 'VisualMenuOption' => [ 'base' => '<p>The menu options for a visual.</p>', 'refs' => [ 'DashboardPublishOptions$VisualMenuOption' => '<p>The menu options of a visual in a dashboard.</p>', 'VisualInteractionOptions$VisualMenuOption' => '<p>The on-visual menu options for a visual.</p>', ], ], 'VisualOptions' => [ 'base' => '<p>The definition for a <code>VisualOptions</code>.</p>', 'refs' => [ 'TopicIR$Visual' => '<p>The visual for the <code>TopicIR</code>.</p>', ], ], 'VisualPalette' => [ 'base' => '<p>The visual display options for the visual palette.</p>', 'refs' => [ 'BarChartConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'BoxPlotChartConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'ComboChartConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'FunnelChartConfiguration$VisualPalette' => '<p>The visual palette configuration of a <code>FunnelChartVisual</code>.</p>', 'GaugeChartConfiguration$VisualPalette' => '<p>The visual palette configuration of a <code>GaugeChartVisual</code>.</p>', 'GeospatialMapConfiguration$VisualPalette' => NULL, 'HistogramConfiguration$VisualPalette' => '<p>The visual palette configuration of a histogram.</p>', 'LineChartConfiguration$VisualPalette' => '<p>The visual palette configuration of a line chart.</p>', 'PieChartConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'RadarChartConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'ScatterPlotConfiguration$VisualPalette' => '<p>The palette (chart color) display setup of the visual.</p>', 'WaterfallChartConfiguration$VisualPalette' => '<p>The visual palette configuration of a waterfall visual.</p>', ], ], 'VisualRole' => [ 'base' => NULL, 'refs' => [ 'TopicVisual$Role' => '<p>The role for the <code>TopicVisual</code>.</p>', ], ], 'VisualSubtitleLabelOptions' => [ 'base' => '<p>The subtitle label options for a visual.</p>', 'refs' => [ 'BarChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'BoxPlotVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'ComboChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'CustomContentVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'FilledMapVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'FunnelChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'GaugeChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'GeospatialMapVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'HeatMapVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'HistogramVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'InsightVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'KPIVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'LineChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'PieChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'PivotTableVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'RadarChartVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'SankeyDiagramVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'ScatterPlotVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'TableVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'TreeMapVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'WaterfallVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', 'WordCloudVisual$Subtitle' => '<p>The subtitle that is displayed on the visual.</p>', ], ], 'VisualTitleLabelOptions' => [ 'base' => '<p>The title label options for a visual.</p>', 'refs' => [ 'BarChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'BoxPlotVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'ComboChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'CustomContentVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'FilledMapVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'FunnelChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'GaugeChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'GeospatialMapVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'HeatMapVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'HistogramVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'InsightVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'KPIVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'LineChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'PieChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'PivotTableVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'RadarChartVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'SankeyDiagramVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'ScatterPlotVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'TableVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'TreeMapVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'WaterfallVisual$Title' => '<p>The title that is displayed on the visual.</p>', 'WordCloudVisual$Title' => '<p>The title that is displayed on the visual.</p>', ], ], 'VpcConnectionProperties' => [ 'base' => '<p>VPC connection properties.</p>', 'refs' => [ 'AssetBundleImportJobDataSourceOverrideParameters$VpcConnectionProperties' => NULL, 'CreateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'DataSource$VpcConnectionProperties' => '<p>The VPC connection information. You need to use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'UpdateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', ], ], 'VpcEndpointId' => [ 'base' => NULL, 'refs' => [ 'VpcEndpointIdRestrictionRuleMap$key' => NULL, ], ], 'VpcEndpointIdRestrictionRuleDescription' => [ 'base' => NULL, 'refs' => [ 'VpcEndpointIdRestrictionRuleMap$value' => NULL, ], ], 'VpcEndpointIdRestrictionRuleMap' => [ 'base' => NULL, 'refs' => [ 'DescribeIpRestrictionResponse$VpcEndpointIdRestrictionRuleMap' => '<p>A map of allowed VPC endpoint IDs and their rule descriptions.</p>', 'UpdateIpRestrictionRequest$VpcEndpointIdRestrictionRuleMap' => '<p>A map of allowed VPC endpoint IDs and their corresponding rule descriptions.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcIdRestrictionRuleMap$key' => NULL, ], ], 'VpcIdRestrictionRuleDescription' => [ 'base' => NULL, 'refs' => [ 'VpcIdRestrictionRuleMap$value' => NULL, ], ], 'VpcIdRestrictionRuleMap' => [ 'base' => NULL, 'refs' => [ 'DescribeIpRestrictionResponse$VpcIdRestrictionRuleMap' => '<p>A map of allowed VPC IDs and their rule descriptions.</p>', 'UpdateIpRestrictionRequest$VpcIdRestrictionRuleMap' => '<p>A map of VPC IDs and their corresponding rules. When you configure this parameter, traffic from all VPC endpoints that are present in the specified VPC is allowed.</p>', ], ], 'Warehouse' => [ 'base' => NULL, 'refs' => [ 'SnowflakeParameters$Warehouse' => '<p>Warehouse.</p>', ], ], 'WaterfallChartAggregatedFieldWells' => [ 'base' => '<p>The field well configuration of a waterfall visual.</p>', 'refs' => [ 'WaterfallChartFieldWells$WaterfallChartAggregatedFieldWells' => '<p>The field well configuration of a waterfall visual.</p>', ], ], 'WaterfallChartColorConfiguration' => [ 'base' => '<p>The color configuration of a waterfall visual.</p>', 'refs' => [ 'WaterfallChartConfiguration$ColorConfiguration' => '<p>The color configuration of a waterfall visual.</p>', ], ], 'WaterfallChartConfiguration' => [ 'base' => '<p>The configuration for a waterfall visual.</p>', 'refs' => [ 'WaterfallVisual$ChartConfiguration' => '<p>The configuration for a waterfall visual.</p>', ], ], 'WaterfallChartFieldWells' => [ 'base' => '<p>The field well configuration of a waterfall visual.</p>', 'refs' => [ 'WaterfallChartConfiguration$FieldWells' => '<p>The field well configuration of a waterfall visual.</p>', ], ], 'WaterfallChartGroupColorConfiguration' => [ 'base' => '<p>The color configuration for individual groups within a waterfall visual.</p>', 'refs' => [ 'WaterfallChartColorConfiguration$GroupColorConfiguration' => '<p>The color configuration for individual groups within a waterfall visual.</p>', ], ], 'WaterfallChartOptions' => [ 'base' => '<p>The options that determine the presentation of a waterfall visual.</p>', 'refs' => [ 'WaterfallChartConfiguration$WaterfallChartOptions' => '<p>The options that determine the presentation of a waterfall visual.</p>', ], ], 'WaterfallChartSortConfiguration' => [ 'base' => '<p>The sort configuration of a waterfall visual.</p>', 'refs' => [ 'WaterfallChartConfiguration$SortConfiguration' => '<p>The sort configuration of a waterfall visual.</p>', ], ], 'WaterfallVisual' => [ 'base' => '<p>A waterfall chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$WaterfallVisual' => '<p>A waterfall chart.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall charts</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'WhatIfPointScenario' => [ 'base' => '<p>Provides the forecast to meet the target for a particular date.</p>', 'refs' => [ 'ForecastScenario$WhatIfPointScenario' => '<p>The what-if analysis forecast setup with the target date.</p>', ], ], 'WhatIfRangeScenario' => [ 'base' => '<p>Provides the forecast to meet the target for a particular date range.</p>', 'refs' => [ 'ForecastScenario$WhatIfRangeScenario' => '<p>The what-if analysis forecast setup with the date range.</p>', ], ], 'WidgetStatus' => [ 'base' => NULL, 'refs' => [ 'ExcludePeriodConfiguration$Status' => '<p>The status of the exclude period. Choose from the following options:</p> <ul> <li> <p> <code>ENABLED</code> </p> </li> <li> <p> <code>DISABLED</code> </p> </li> </ul>', 'FilterGroup$Status' => '<p>The status of the <code>FilterGroup</code>.</p>', 'ReferenceLine$Status' => '<p>The status of the reference line. Choose one of the following options:</p> <ul> <li> <p> <code>ENABLE</code> </p> </li> <li> <p> <code>DISABLE</code> </p> </li> </ul>', 'RowAlternateColorOptions$Status' => '<p>Determines the widget status.</p>', 'RowAlternateColorOptions$UsePrimaryBackgroundColor' => '<p>The primary background color options for alternate rows.</p>', 'VisualCustomAction$Status' => '<p>The status of the <code>VisualCustomAction</code>.</p>', ], ], 'WordCloudAggregatedFieldWells' => [ 'base' => '<p>The aggregated field wells of a word cloud.</p>', 'refs' => [ 'WordCloudFieldWells$WordCloudAggregatedFieldWells' => '<p>The aggregated field wells of a word cloud.</p>', ], ], 'WordCloudChartConfiguration' => [ 'base' => '<p>The configuration of a word cloud visual.</p>', 'refs' => [ 'WordCloudVisual$ChartConfiguration' => '<p>The configuration settings of the visual.</p>', ], ], 'WordCloudCloudLayout' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$CloudLayout' => '<p>The cloud layout options (fluid, normal) of a word cloud.</p>', ], ], 'WordCloudDimensionFieldList' => [ 'base' => NULL, 'refs' => [ 'WordCloudAggregatedFieldWells$GroupBy' => '<p>The group by field well of a word cloud. Values are grouped by group by fields.</p>', ], ], 'WordCloudFieldWells' => [ 'base' => '<p>The field wells of a word cloud visual.</p> <p>This is a union type structure. For this structure to be valid, only one of the attributes can be defined.</p>', 'refs' => [ 'WordCloudChartConfiguration$FieldWells' => '<p>The field wells of the visual.</p>', ], ], 'WordCloudMaximumStringLength' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$MaximumStringLength' => '<p>The length limit of each word from 1-100.</p>', ], ], 'WordCloudMeasureFieldList' => [ 'base' => NULL, 'refs' => [ 'WordCloudAggregatedFieldWells$Size' => '<p>The size field well of a word cloud. Values are aggregated based on group by fields.</p>', ], ], 'WordCloudOptions' => [ 'base' => '<p>The word cloud options for a word cloud visual.</p>', 'refs' => [ 'WordCloudChartConfiguration$WordCloudOptions' => '<p>The options for a word cloud visual.</p>', ], ], 'WordCloudSortConfiguration' => [ 'base' => '<p>The sort configuration of a word cloud visual.</p>', 'refs' => [ 'WordCloudChartConfiguration$SortConfiguration' => '<p>The sort configuration of a word cloud visual.</p>', ], ], 'WordCloudVisual' => [ 'base' => '<p>A word cloud.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using word clouds</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'refs' => [ 'Visual$WordCloudVisual' => '<p>A word cloud.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using word clouds</a> in the <i>Amazon QuickSight User Guide</i>.</p>', ], ], 'WordCloudWordCasing' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$WordCasing' => '<p>The word casing options (lower_case, existing_case) for the words in a word cloud.</p>', ], ], 'WordCloudWordOrientation' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$WordOrientation' => '<p>The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.</p>', ], ], 'WordCloudWordPadding' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$WordPadding' => '<p>The word padding options (none, small, medium, large) for the words in a word cloud.</p>', ], ], 'WordCloudWordScaling' => [ 'base' => NULL, 'refs' => [ 'WordCloudOptions$WordScaling' => '<p>The word scaling options (emphasize, normal) for the words in a word cloud.</p>', ], ], 'WorkGroup' => [ 'base' => NULL, 'refs' => [ 'AthenaParameters$WorkGroup' => '<p>The workgroup that Amazon Athena uses.</p>', ], ], 'YAxisOptions' => [ 'base' => '<p>The options that are available for a single Y axis in a chart.</p>', 'refs' => [ 'SingleAxisOptions$YAxisOptions' => '<p>The Y axis options of a single axis configuration.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountCustomizationRequest$Resolved' => '<p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>', ], ], ],];
