<?php
// This file was auto-generated from sdk-root/src/data/resiliencehub/2020-04-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Resilience Hub helps you proactively prepare and protect your Amazon Web Services applications from disruptions. It offers continual resiliency assessment and validation that integrates into your software development lifecycle. This enables you to uncover resiliency weaknesses, ensure recovery time objective (RTO) and recovery point objective (RPO) targets for your applications are met, and resolve issues before they are released into production. </p>', 'operations' => [ 'AcceptResourceGroupingRecommendations' => '<p>Accepts the resource grouping recommendations suggested by Resilience Hub for your application.</p>', 'AddDraftAppVersionResourceMappings' => '<p>Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will use these resource-maps to resolve the latest physical ID for each resource in the application template. For more information about different types of resources supported by Resilience Hub and how to add them in your application, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html">Step 2: How is your application managed?</a> in the Resilience Hub User Guide.</p>', 'BatchUpdateRecommendationStatus' => '<p>Enables you to include or exclude one or more operational recommendations.</p>', 'CreateApp' => '<p>Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional resources. For more information about the number of resources supported per application, see <a href="https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub">Service quotas</a>.</p> <p>After you create an Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).</p>', 'CreateAppVersionAppComponent' => '<p>Creates a new Application Component in the Resilience Hub application.</p> <note> <p>This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </note>', 'CreateAppVersionResource' => '<p>Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you specify a new Application Component, Resilience Hub will automatically create the Application Component.</p> <note> <ul> <li> <p>This action has no effect outside Resilience Hub.</p> </li> <li> <p>This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </li> <li> <p>To update application version with new <code>physicalResourceID</code>, you must call <code>ResolveAppVersionResources</code> API.</p> </li> </ul> </note>', 'CreateRecommendationTemplate' => '<p>Creates a new recommendation template for the Resilience Hub application.</p>', 'CreateResiliencyPolicy' => '<p>Creates a resiliency policy for an application.</p> <note> <p>Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your application will be set to <b>Policy breached</b>.</p> </note>', 'DeleteApp' => '<p>Deletes an Resilience Hub application. This is a destructive action that can\'t be undone.</p>', 'DeleteAppAssessment' => '<p>Deletes an Resilience Hub application assessment. This is a destructive action that can\'t be undone.</p>', 'DeleteAppInputSource' => '<p>Deletes the input source and all of its imported resources from the Resilience Hub application.</p>', 'DeleteAppVersionAppComponent' => '<p>Deletes an Application Component from the Resilience Hub application.</p> <note> <ul> <li> <p>This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </li> <li> <p>You will not be able to delete an Application Component if it has resources associated with it.</p> </li> </ul> </note>', 'DeleteAppVersionResource' => '<p>Deletes a resource from the Resilience Hub application.</p> <note> <ul> <li> <p>You can only delete a manually added resource. To exclude non-manually added resources, use the <code>UpdateAppVersionResource</code> API.</p> </li> <li> <p>This action has no effect outside Resilience Hub.</p> </li> <li> <p>This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </li> </ul> </note>', 'DeleteRecommendationTemplate' => '<p>Deletes a recommendation template. This is a destructive action that can\'t be undone.</p>', 'DeleteResiliencyPolicy' => '<p>Deletes a resiliency policy. This is a destructive action that can\'t be undone.</p>', 'DescribeApp' => '<p>Describes an Resilience Hub application.</p>', 'DescribeAppAssessment' => '<p>Describes an assessment for an Resilience Hub application.</p>', 'DescribeAppVersion' => '<p>Describes the Resilience Hub application version.</p>', 'DescribeAppVersionAppComponent' => '<p>Describes an Application Component in the Resilience Hub application.</p>', 'DescribeAppVersionResource' => '<p>Describes a resource of the Resilience Hub application.</p> <note> <p>This API accepts only one of the following parameters to describe the resource:</p> <ul> <li> <p> <code>resourceName</code> </p> </li> <li> <p> <code>logicalResourceId</code> </p> </li> <li> <p> <code>physicalResourceId</code> (Along with <code>physicalResourceId</code>, you can also provide <code>awsAccountId</code>, and <code>awsRegion</code>)</p> </li> </ul> </note>', 'DescribeAppVersionResourcesResolutionStatus' => '<p>Returns the resolution status for the specified resolution identifier for an application version. If <code>resolutionId</code> is not specified, the current resolution status is returned.</p>', 'DescribeAppVersionTemplate' => '<p>Describes details about an Resilience Hub application.</p>', 'DescribeDraftAppVersionResourcesImportStatus' => '<p>Describes the status of importing resources to an application version.</p> <note> <p>If you get a 404 error with <code>ResourceImportStatusNotFoundAppMetadataException</code>, you must call <code>importResourcesToDraftAppVersion</code> after creating the application and before calling <code>describeDraftAppVersionResourcesImportStatus</code> to obtain the status.</p> </note>', 'DescribeResiliencyPolicy' => '<p>Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.</p>', 'DescribeResourceGroupingRecommendationTask' => '<p>Describes the resource grouping recommendation tasks run by Resilience Hub for your application.</p>', 'ImportResourcesToDraftAppVersion' => '<p>Imports resources to Resilience Hub application draft version from different input sources. For more information about the input sources supported by Resilience Hub, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure and describe your Resilience Hub application</a>.</p>', 'ListAlarmRecommendations' => '<p>Lists the alarm recommendations for an Resilience Hub application.</p>', 'ListAppAssessmentComplianceDrifts' => '<p>List of compliance drifts that were detected while running an assessment.</p>', 'ListAppAssessmentResourceDrifts' => '<p>Indicates the list of resource drifts that were detected while running an assessment.</p>', 'ListAppAssessments' => '<p>Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for the response object.</p>', 'ListAppComponentCompliances' => '<p>Lists the compliances for an Resilience Hub Application Component.</p>', 'ListAppComponentRecommendations' => '<p>Lists the recommendations for an Resilience Hub Application Component.</p>', 'ListAppInputSources' => '<p>Lists all the input sources of the Resilience Hub application. For more information about the input sources supported by Resilience Hub, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html">Discover the structure and describe your Resilience Hub application</a>.</p>', 'ListAppVersionAppComponents' => '<p>Lists all the Application Components in the Resilience Hub application.</p>', 'ListAppVersionResourceMappings' => '<p>Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.</p>', 'ListAppVersionResources' => '<p>Lists all the resources in an Resilience Hub application.</p>', 'ListAppVersions' => '<p>Lists the different versions for the Resilience Hub applications.</p>', 'ListApps' => '<p>Lists your Resilience Hub applications.</p> <note> <p>You can filter applications using only one filter at a time or without using any filter. If you try to filter applications using multiple filters, you will get the following error:</p> <p> <code>An error occurred (ValidationException) when calling the ListApps operation: Only one filter is supported for this operation.</code> </p> </note>', 'ListRecommendationTemplates' => '<p>Lists the recommendation templates for the Resilience Hub applications.</p>', 'ListResiliencyPolicies' => '<p>Lists the resiliency policies for the Resilience Hub applications.</p>', 'ListResourceGroupingRecommendations' => '<p>Lists the resource grouping recommendations suggested by Resilience Hub for your application.</p>', 'ListSopRecommendations' => '<p>Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>', 'ListSuggestedResiliencyPolicies' => '<p>Lists the suggested resiliency policies for the Resilience Hub applications.</p>', 'ListTagsForResource' => '<p>Lists the tags for your resources in your Resilience Hub applications.</p>', 'ListTestRecommendations' => '<p>Lists the test recommendations for the Resilience Hub application.</p>', 'ListUnsupportedAppVersionResources' => '<p>Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.</p>', 'PublishAppVersion' => '<p>Publishes a new version of a specific Resilience Hub application.</p>', 'PutDraftAppVersionTemplate' => '<p>Adds or updates the app template for an Resilience Hub application draft version.</p>', 'RejectResourceGroupingRecommendations' => '<p>Rejects resource grouping recommendations.</p>', 'RemoveDraftAppVersionResourceMappings' => '<p>Removes resource mappings from a draft application version.</p>', 'ResolveAppVersionResources' => '<p>Resolves the resources for an application version.</p>', 'StartAppAssessment' => '<p>Creates a new application assessment for an application.</p>', 'StartResourceGroupingRecommendationTask' => '<p>Starts grouping recommendation task.</p>', 'TagResource' => '<p>Applies one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes one or more tags from a resource.</p>', 'UpdateApp' => '<p>Updates an application.</p>', 'UpdateAppVersion' => '<p>Updates the Resilience Hub application version.</p> <note> <p>This API updates the Resilience Hub application draft version. To use this information for running resiliency assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </note>', 'UpdateAppVersionAppComponent' => '<p>Updates an existing Application Component in the Resilience Hub application.</p> <note> <p>This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </note>', 'UpdateAppVersionResource' => '<p>Updates the resource details in the Resilience Hub application.</p> <note> <ul> <li> <p>This action has no effect outside Resilience Hub.</p> </li> <li> <p>This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the <code>PublishAppVersion</code> API.</p> </li> <li> <p>To update application version with new <code>physicalResourceID</code>, you must call <code>ResolveAppVersionResources</code> API.</p> </li> </ul> </note>', 'UpdateResiliencyPolicy' => '<p>Updates a resiliency policy.</p> <note> <p>Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your application will be set to <b>Policy breached</b>.</p> </note>', ], 'shapes' => [ 'AcceptGroupingRecommendationEntries' => [ 'base' => NULL, 'refs' => [ 'AcceptResourceGroupingRecommendationsRequest$entries' => '<p>Indicates the list of resource grouping recommendations you want to include in your application.</p>', ], ], 'AcceptGroupingRecommendationEntry' => [ 'base' => '<p>Indicates the grouping recommendation you have accepted to include in your application.</p>', 'refs' => [ 'AcceptGroupingRecommendationEntries$member' => NULL, ], ], 'AcceptResourceGroupingRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptResourceGroupingRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions.</p>', 'refs' => [], ], 'AddDraftAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddDraftAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdditionalInfoMap' => [ 'base' => NULL, 'refs' => [ 'AppComponent$additionalInfo' => '<p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note>', 'CreateAppVersionAppComponentRequest$additionalInfo' => '<p>Currently, there is no supported additional information for Application Components.</p>', 'CreateAppVersionResourceRequest$additionalInfo' => '<p>Currently, there is no supported additional information for resources.</p>', 'DescribeAppVersionResponse$additionalInfo' => '<p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter supports only failover region and account.</p> </note>', 'PhysicalResource$additionalInfo' => '<p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note>', 'UpdateAppVersionAppComponentRequest$additionalInfo' => '<p>Currently, there is no supported additional information for Application Components.</p>', 'UpdateAppVersionRequest$additionalInfo' => '<p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note>', 'UpdateAppVersionResourceRequest$additionalInfo' => '<p>Currently, there is no supported additional information for resources.</p>', 'UpdateAppVersionResponse$additionalInfo' => '<p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter supports only failover region and account.</p> </note>', ], ], 'AdditionalInfoValueList' => [ 'base' => NULL, 'refs' => [ 'AdditionalInfoMap$value' => NULL, ], ], 'AlarmRecommendation' => [ 'base' => '<p>Defines a recommendation for a CloudWatch alarm.</p>', 'refs' => [ 'AlarmRecommendationList$member' => NULL, ], ], 'AlarmRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsResponse$alarmRecommendations' => '<p>The alarm recommendations for an Resilience Hub application, returned as an object. This object includes Application Component names, descriptions, information about whether a recommendation has already been implemented or not, prerequisites, and more.</p>', ], ], 'AlarmReferenceIdList' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$dependsOnAlarms' => '<p> A list of recommended alarms that are used in the test and must be exported before or with the test. </p>', ], ], 'AlarmType' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$type' => '<p>Type of alarm recommendation.</p>', ], ], 'App' => [ 'base' => '<p>Defines an Resilience Hub application.</p>', 'refs' => [ 'CreateAppResponse$app' => '<p>The created application returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', 'DescribeAppResponse$app' => '<p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', 'UpdateAppResponse$app' => '<p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', ], ], 'AppAssessment' => [ 'base' => '<p>Defines an application assessment.</p>', 'refs' => [ 'DescribeAppAssessmentResponse$assessment' => '<p>The assessment for an Resilience Hub application, returned as an object. This object includes Amazon Resource Names (ARNs), compliance information, compliance status, cost, messages, resiliency scores, and more.</p>', 'StartAppAssessmentResponse$assessment' => '<p>The assessment created.</p>', ], ], 'AppAssessmentScheduleType' => [ 'base' => NULL, 'refs' => [ 'App$assessmentSchedule' => '<p>Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'AppSummary$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'CreateAppRequest$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'UpdateAppRequest$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', ], ], 'AppAssessmentSummary' => [ 'base' => '<p>Defines an application assessment summary.</p>', 'refs' => [ 'AppAssessmentSummaryList$member' => NULL, ], ], 'AppAssessmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentsResponse$assessmentSummaries' => '<p>The summaries for the specified assessments, returned as an object. This object includes application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency scores, and more.</p>', ], ], 'AppComplianceStatusType' => [ 'base' => NULL, 'refs' => [ 'App$complianceStatus' => '<p>Current status of compliance for the resiliency policy.</p>', 'AppSummary$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', ], ], 'AppComponent' => [ 'base' => '<p>Defines an Application Component.</p>', 'refs' => [ 'AppComponentList$member' => NULL, 'CreateAppVersionAppComponentResponse$appComponent' => '<p>List of Application Components that belong to this resource.</p>', 'DeleteAppVersionAppComponentResponse$appComponent' => '<p>List of Application Components that belong to this resource.</p>', 'DescribeAppVersionAppComponentResponse$appComponent' => '<p>List of Application Components that belong to this resource.</p>', 'UpdateAppVersionAppComponentResponse$appComponent' => '<p>List of Application Components that belong to this resource.</p>', ], ], 'AppComponentCompliance' => [ 'base' => '<p>Defines the compliance of an Application Component against the resiliency policy.</p>', 'refs' => [ 'ComponentCompliancesList$member' => NULL, ], ], 'AppComponentList' => [ 'base' => NULL, 'refs' => [ 'ListAppVersionAppComponentsResponse$appComponents' => '<p>Defines an Application Component.</p>', 'PhysicalResource$appComponents' => '<p>The application components that belong to this resource.</p>', ], ], 'AppComponentNameList' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$appComponentNames' => '<p>List of Application Component names for the CloudWatch alarm recommendation.</p>', 'AssessmentRiskRecommendation$appComponents' => '<p>Indicates the Application Components (AppComponents) that were assessed as part of the assessnent and are associated with the identified risk and recommendation.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'CreateAppVersionResourceRequest$appComponents' => '<p>List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.</p>', 'UpdateAppVersionResourceRequest$appComponents' => '<p>List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.</p>', ], ], 'AppDriftStatusType' => [ 'base' => NULL, 'refs' => [ 'App$driftStatus' => '<p>Indicates if compliance drifts (deviations) were detected while running an assessment for your application.</p>', 'AppSummary$driftStatus' => '<p>Indicates if compliance drifts (deviations) were detected while running an assessment for your application.</p>', ], ], 'AppInputSource' => [ 'base' => '<p>The list of Resilience Hub application input sources.</p>', 'refs' => [ 'AppInputSourceList$member' => NULL, 'DeleteAppInputSourceResponse$appInputSource' => '<p>Name of the input source from where the application resource is imported from.</p>', ], ], 'AppInputSourceList' => [ 'base' => NULL, 'refs' => [ 'ListAppInputSourcesResponse$appInputSources' => '<p>The list of Resilience Hub application input sources.</p>', ], ], 'AppStatusType' => [ 'base' => NULL, 'refs' => [ 'App$status' => '<p>Status of the application.</p>', 'AppSummary$status' => '<p>Status of the application.</p>', ], ], 'AppSummary' => [ 'base' => '<p>Defines an application summary.</p>', 'refs' => [ 'AppSummaryList$member' => NULL, ], ], 'AppSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$appSummaries' => '<p>Summaries for the Resilience Hub application.</p>', ], ], 'AppTemplateBody' => [ 'base' => NULL, 'refs' => [ 'DescribeAppVersionTemplateResponse$appTemplateBody' => '<p>A JSON string that provides information about your application structure. To learn more about the <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i> section.</p> <p>The <code>appTemplateBody</code> JSON string has the following structure:</p> <ul> <li> <p> <b> <code>resources</code> </b> </p> <p>The list of logical resources that must be included in the Resilience Hub application.</p> <p>Type: Array</p> <note> <p>Don\'t add the resources that you want to exclude.</p> </note> <p>Each <code>resources</code> array item includes the following fields:</p> <ul> <li> <p> <i> <code>logicalResourceId</code> </i> </p> <p>Logical identifier of the resource.</p> <p>Type: Object</p> <p>Each <code>logicalResourceId</code> object includes the following fields:</p> <ul> <li> <p> <code>identifier</code> </p> <p>Identifier of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>logicalStackName</code> </p> <p>The name of the CloudFormation stack this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>resourceGroupName</code> </p> <p>The name of the resource group this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>terraformSourceName</code> </p> <p>The name of the Terraform S3 state file this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>eksSourceName</code> </p> <p>Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note> <p>Type: String</p> </li> </ul> </li> <li> <p> <i> <code>type</code> </i> </p> <p>The type of resource.</p> <p>Type: string</p> </li> <li> <p> <i> <code>name</code> </i> </p> <p>The name of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul> </li> <li> <p> <b> <code>appComponents</code> </b> </p> <p>List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.</p> <p>Type: Array</p> <p>Each <code>appComponents</code> array item includes the following fields:</p> <ul> <li> <p> <code>name</code> </p> <p>Name of the Application Component.</p> <p>Type: String</p> </li> <li> <p> <code>type</code> </p> <p>Type of Application Component. For more information about the types of Application Component, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a>.</p> <p>Type: String</p> </li> <li> <p> <code>resourceNames</code> </p> <p>The list of included resources that are assigned to the Application Component.</p> <p>Type: Array of strings</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul> </li> <li> <p> <b> <code>excludedResources</code> </b> </p> <p>The list of logical resource identifiers to be excluded from the application.</p> <p>Type: Array</p> <note> <p>Don\'t add the resources that you want to include.</p> </note> <p>Each <code>excludedResources</code> array item includes the following fields:</p> <ul> <li> <p> <i> <code>logicalResourceIds</code> </i> </p> <p>Logical identifier of the resource.</p> <p>Type: Object</p> <note> <p>You can configure only one of the following fields:</p> <ul> <li> <p> <code>logicalStackName</code> </p> </li> <li> <p> <code>resourceGroupName</code> </p> </li> <li> <p> <code>terraformSourceName</code> </p> </li> <li> <p> <code>eksSourceName</code> </p> </li> </ul> </note> <p>Each <code>logicalResourceIds</code> object includes the following fields:</p> <ul> <li> <p> <code>identifier</code> </p> <p>Identifier of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>logicalStackName</code> </p> <p>The name of the CloudFormation stack this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>resourceGroupName</code> </p> <p>The name of the resource group this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>terraformSourceName</code> </p> <p>The name of the Terraform S3 state file this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>eksSourceName</code> </p> <p>Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note> <p>Type: String</p> </li> </ul> </li> </ul> </li> <li> <p> <b> <code>version</code> </b> </p> <p>Resilience Hub application version.</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul>', 'PutDraftAppVersionTemplateRequest$appTemplateBody' => '<p>A JSON string that provides information about your application structure. To learn more about the <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i> section.</p> <p>The <code>appTemplateBody</code> JSON string has the following structure:</p> <ul> <li> <p> <b> <code>resources</code> </b> </p> <p>The list of logical resources that must be included in the Resilience Hub application.</p> <p>Type: Array</p> <note> <p>Don\'t add the resources that you want to exclude.</p> </note> <p>Each <code>resources</code> array item includes the following fields:</p> <ul> <li> <p> <i> <code>logicalResourceId</code> </i> </p> <p>Logical identifier of the resource.</p> <p>Type: Object</p> <p>Each <code>logicalResourceId</code> object includes the following fields:</p> <ul> <li> <p> <code>identifier</code> </p> <p>Identifier of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>logicalStackName</code> </p> <p>The name of the CloudFormation stack this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>resourceGroupName</code> </p> <p>The name of the resource group this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>terraformSourceName</code> </p> <p>The name of the Terraform S3 state file this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>eksSourceName</code> </p> <p>Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note> <p>Type: String</p> </li> </ul> </li> <li> <p> <i> <code>type</code> </i> </p> <p>The type of resource.</p> <p>Type: string</p> </li> <li> <p> <i> <code>name</code> </i> </p> <p>The name of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul> </li> <li> <p> <b> <code>appComponents</code> </b> </p> <p>List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.</p> <p>Type: Array</p> <p>Each <code>appComponents</code> array item includes the following fields:</p> <ul> <li> <p> <code>name</code> </p> <p>Name of the Application Component.</p> <p>Type: String</p> </li> <li> <p> <code>type</code> </p> <p>Type of Application Component. For more information about the types of Application Component, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a>.</p> <p>Type: String</p> </li> <li> <p> <code>resourceNames</code> </p> <p>The list of included resources that are assigned to the Application Component.</p> <p>Type: Array of strings</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul> </li> <li> <p> <b> <code>excludedResources</code> </b> </p> <p>The list of logical resource identifiers to be excluded from the application.</p> <p>Type: Array</p> <note> <p>Don\'t add the resources that you want to include.</p> </note> <p>Each <code>excludedResources</code> array item includes the following fields:</p> <ul> <li> <p> <i> <code>logicalResourceIds</code> </i> </p> <p>Logical identifier of the resource.</p> <p>Type: Object</p> <note> <p>You can configure only one of the following fields:</p> <ul> <li> <p> <code>logicalStackName</code> </p> </li> <li> <p> <code>resourceGroupName</code> </p> </li> <li> <p> <code>terraformSourceName</code> </p> </li> <li> <p> <code>eksSourceName</code> </p> </li> </ul> </note> <p>Each <code>logicalResourceIds</code> object includes the following fields:</p> <ul> <li> <p> <code>identifier</code> </p> <p>Identifier of the resource.</p> <p>Type: String</p> </li> <li> <p> <code>logicalStackName</code> </p> <p>The name of the CloudFormation stack this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>resourceGroupName</code> </p> <p>The name of the resource group this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>terraformSourceName</code> </p> <p>The name of the Terraform S3 state file this resource belongs to.</p> <p>Type: String</p> </li> <li> <p> <code>eksSourceName</code> </p> <p>Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note> <p>Type: String</p> </li> </ul> </li> </ul> </li> <li> <p> <b> <code>version</code> </b> </p> <p>Resilience Hub application version.</p> </li> <li> <p> <code>additionalInfo</code> </p> <p>Additional configuration parameters for an Resilience Hub application. If you want to implement <code>additionalInfo</code> through the Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a>.</p> <note> <p>Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.</p> <p>Key: <code>"failover-regions"</code> </p> <p>Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code> </p> </note> </li> </ul>', ], ], 'AppVersionList' => [ 'base' => NULL, 'refs' => [ 'ListAppVersionsResponse$appVersions' => '<p>The version of the application.</p>', ], ], 'AppVersionSummary' => [ 'base' => '<p>Version of an application.</p>', 'refs' => [ 'AppVersionList$member' => NULL, ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AcceptResourceGroupingRecommendationsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AcceptResourceGroupingRecommendationsResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AddDraftAppVersionResourceMappingsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AddDraftAppVersionResourceMappingsResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'App$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'App$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppAssessment$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppAssessment$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppAssessmentSummary$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppAssessmentSummary$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppInputSource$sourceArn' => '<p>The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'AppSummary$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ArnList$member' => NULL, 'BatchUpdateRecommendationStatusRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'BatchUpdateRecommendationStatusResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateAppRequest$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateAppVersionAppComponentRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateAppVersionAppComponentResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateAppVersionResourceRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateAppVersionResourceResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'CreateRecommendationTemplateRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppAssessmentRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppAssessmentResponse$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppInputSourceRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppInputSourceRequest$sourceArn' => '<p>The Amazon Resource Name (ARN) of the imported resource you want to remove from the Resilience Hub application. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppInputSourceResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppVersionAppComponentRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppVersionAppComponentResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppVersionResourceRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteAppVersionResourceResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteRecommendationTemplateRequest$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'DeleteRecommendationTemplateResponse$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'DeleteResiliencyPolicyRequest$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DeleteResiliencyPolicyResponse$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppAssessmentRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionAppComponentRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionAppComponentResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionResourceRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionResourceResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionTemplateRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeAppVersionTemplateResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeDraftAppVersionResourcesImportStatusRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeResiliencyPolicyRequest$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'DescribeResourceGroupingRecommendationTaskRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'EksSource$eksClusterArn' => '<p>Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:<code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/<code>cluster-name</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'EksSourceClusterNamespace$eksClusterArn' => '<p>Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:<code>aws</code>:eks:<code>region</code>:<code>account-id</code>:cluster/<code>cluster-name</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'EventSubscription$snsTopicArn' => '<p>Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is: <code>arn:partition:sns:region:account:topic-name</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ImportResourcesToDraftAppVersionRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ImportResourcesToDraftAppVersionResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAlarmRecommendationsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppAssessmentComplianceDriftsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppAssessmentResourceDriftsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppAssessmentsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppComponentCompliancesRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppComponentRecommendationsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppInputSourcesRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppVersionAppComponentsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppVersionAppComponentsResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppVersionResourceMappingsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppVersionResourcesRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppVersionsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListAppsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListRecommendationTemplatesRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListRecommendationTemplatesRequest$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'ListResourceGroupingRecommendationsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListSopRecommendationsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>', 'ListTestRecommendationsRequest$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ListUnsupportedAppVersionResourcesRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'PublishAppVersionRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'PublishAppVersionResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'PutDraftAppVersionTemplateRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'PutDraftAppVersionTemplateResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RecommendationTemplate$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RecommendationTemplate$assessmentArn' => '<p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RecommendationTemplate$recommendationTemplateArn' => '<p>Amazon Resource Name (ARN) for the recommendation template.</p>', 'RejectResourceGroupingRecommendationsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RejectResourceGroupingRecommendationsResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'RemoveDraftAppVersionResourceMappingsResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ResiliencyPolicy$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ResolveAppVersionResourcesRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ResolveAppVersionResourcesResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'ResourceDrift$appArn' => '<p>Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'StartAppAssessmentRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'StartResourceGroupingRecommendationTaskRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'StartResourceGroupingRecommendationTaskResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'TagResourceRequest$resourceArn' => '<p>Amazon Resource Name (ARN) of the resource. </p>', 'UntagResourceRequest$resourceArn' => '<p>Amazon Resource Name (ARN) of the resource. </p>', 'UpdateAppRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppRequest$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionAppComponentRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionAppComponentResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionResourceRequest$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionResourceResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateAppVersionResponse$appArn' => '<p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', 'UpdateResiliencyPolicyRequest$policyArn' => '<p>Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$sourceArns' => '<p>The Amazon Resource Names (ARNs) for the resources.</p>', 'ImportResourcesToDraftAppVersionResponse$sourceArns' => '<p>The Amazon Resource Names (ARNs) for the resources you have imported.</p>', ], ], 'AssessmentCompliance' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$compliance' => '<p>Application compliance against the resiliency policy.</p>', 'AppComponentCompliance$compliance' => '<p>The compliance of the Application Component against the resiliency policy.</p>', 'ComplianceDrift$actualValue' => '<p>Actual compliance value of the entity.</p>', 'ComplianceDrift$expectedValue' => '<p>The expected compliance value of an entity.</p>', 'ConfigRecommendation$compliance' => '<p>The current compliance against the resiliency policy before applying the configuration change.</p>', ], ], 'AssessmentInvoker' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$invoker' => '<p>The entity that invoked the assessment.</p>', 'AppAssessmentSummary$invoker' => '<p>Entity that invoked the assessment.</p>', 'ListAppAssessmentsRequest$invoker' => '<p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>', ], ], 'AssessmentRiskRecommendation' => [ 'base' => '<p>Indicates a specific risk identified in the Resilience Hub assessment and the corresponding recommendation provided to address that risk.</p> <note> <p>The assessment summary generated by large language models (LLMs) on Amazon Bedrock are only suggestions. The current level of generative AI technology is not perfect and LLMs are not infallible. Bias and incorrect answers, although rare, should be expected. Review each recommendation in the assessment summary before you use the output from an LLM. </p> </note> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'refs' => [ 'AssessmentRiskRecommendationList$member' => NULL, ], ], 'AssessmentRiskRecommendationList' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$riskRecommendations' => '<p>Indicates the top risks and recommendations identified by the Resilience Hub assessment, each representing a specific risk and the corresponding recommendation to address it.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', ], ], 'AssessmentStatus' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$assessmentStatus' => '<p>Current status of the assessment for the resiliency policy.</p>', 'AppAssessmentSummary$assessmentStatus' => '<p>Current status of the assessment for the resiliency policy.</p>', 'AssessmentStatusList$member' => NULL, 'DeleteAppAssessmentResponse$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', ], ], 'AssessmentStatusList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentsRequest$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', ], ], 'AssessmentSummary' => [ 'base' => '<p>Indicates the AI-generated summary for the Resilience Hub assessment, providing a concise overview that highlights the top risks and recommendations.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'refs' => [ 'AppAssessment$summary' => '<p>Indicates a concise summary that provides an overview of the Resilience Hub assessment.</p>', ], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'CreateAppVersionResourceRequest$awsRegion' => '<p>Amazon Web Services region that owns the physical resource.</p>', 'DeleteAppVersionResourceRequest$awsRegion' => '<p>Amazon Web Services region that owns the physical resource.</p>', 'DescribeAppVersionResourceRequest$awsRegion' => '<p>Amazon Web Services region that owns the physical resource.</p>', 'PhysicalResourceId$awsRegion' => '<p>The Amazon Web Services Region that the physical resource is located in.</p>', 'RecommendationItem$targetRegion' => '<p>The target region.</p>', 'UpdateAppVersionResourceRequest$awsRegion' => '<p>Amazon Web Services region that owns the physical resource.</p>', 'UpdateRecommendationStatusItem$targetRegion' => '<p>Identifier of the target Amazon Web Services Region.</p>', ], ], 'BatchUpdateRecommendationStatusFailedEntries' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusResponse$failedEntries' => '<p>A list of items with error details about each item, which could not be included or excluded.</p>', ], ], 'BatchUpdateRecommendationStatusFailedEntry' => [ 'base' => '<p>List of operational recommendations that did not get included or excluded.</p>', 'refs' => [ 'BatchUpdateRecommendationStatusFailedEntries$member' => NULL, ], ], 'BatchUpdateRecommendationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateRecommendationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateRecommendationStatusSuccessfulEntries' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusResponse$successfulEntries' => '<p>A list of items that were included or excluded.</p>', ], ], 'BatchUpdateRecommendationStatusSuccessfulEntry' => [ 'base' => '<p>List of operational recommendations that were successfully included or excluded.</p>', 'refs' => [ 'BatchUpdateRecommendationStatusSuccessfulEntries$member' => NULL, ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusSuccessfulEntry$excluded' => '<p>Indicates if the operational recommendation was successfully excluded.</p>', 'DeleteAppRequest$forceDelete' => '<p>A boolean option to force the deletion of an Resilience Hub application. </p>', 'ListAppAssessmentsRequest$reverseOrder' => '<p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>', 'ListAppsRequest$reverseOrder' => '<p>The application list is sorted based on the values of <code>lastAppComplianceEvaluationTime</code> field. By default, application list is sorted in ascending order. To sort the application list in descending order, set this field to <code>True</code>.</p>', 'ListRecommendationTemplatesRequest$reverseOrder' => '<p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>', 'PhysicalResource$excluded' => '<p>Indicates if a resource is included or excluded from the assessment.</p>', 'RecommendationItem$alreadyImplemented' => '<p>Specifies if the recommendation has already been implemented.</p>', 'RecommendationItem$excluded' => '<p>Indicates if an operational recommendation item is excluded.</p>', 'RecommendationTemplate$needsReplacements' => '<p>Indicates if replacements are needed.</p>', 'ResourceErrorsDetails$hasMoreErrors' => '<p> This indicates if there are more errors not listed in the <code>resourceErrors</code> list. </p>', 'UpdateAppRequest$clearResiliencyPolicyArn' => '<p>Specifies if the resiliency policy ARN should be cleared.</p>', 'UpdateAppVersionResourceRequest$excluded' => '<p>Indicates if a resource is excluded from an Resilience Hub application.</p> <note> <p>You can exclude only imported resources from an Resilience Hub application.</p> </note>', 'UpdateRecommendationStatusRequestEntry$excluded' => '<p>Indicates if the operational recommendation needs to be excluded. If set to True, the operational recommendation will be excluded.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateAppVersionAppComponentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateAppVersionResourceRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateRecommendationTemplateRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateResiliencyPolicyRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppAssessmentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppInputSourceRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppVersionAppComponentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppVersionResourceRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteRecommendationTemplateRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteResiliencyPolicyRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'StartAppAssessmentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', ], ], 'ComplianceDrift' => [ 'base' => '<p>Indicates the compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) that were detected for an assessed entity.</p>', 'refs' => [ 'ComplianceDriftList$member' => NULL, ], ], 'ComplianceDriftList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentComplianceDriftsResponse$complianceDrifts' => '<p>Indicates compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) detected for an assessed entity.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$complianceStatus' => '<p>Current status of the compliance for the resiliency policy.</p>', 'AppAssessmentSummary$complianceStatus' => '<p>Current status of compliance for the resiliency policy.</p>', 'AppComponentCompliance$status' => '<p>Status of the action.</p>', 'DisruptionCompliance$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'ListAppAssessmentsRequest$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'RecommendationDisruptionCompliance$expectedComplianceStatus' => '<p>The expected compliance status after applying the recommended configuration change.</p>', ], ], 'ComponentCompliancesList' => [ 'base' => NULL, 'refs' => [ 'ListAppComponentCompliancesResponse$componentCompliances' => '<p>The compliances for an Resilience Hub Application Component, returned as an object. This object contains the names of the Application Components, compliances, costs, resiliency scores, outage scores, and more.</p>', ], ], 'ComponentRecommendation' => [ 'base' => '<p>Defines recommendations for an Resilience Hub Application Component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.</p>', 'refs' => [ 'ComponentRecommendationList$member' => NULL, ], ], 'ComponentRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListAppComponentRecommendationsResponse$componentRecommendations' => '<p>The recommendations for an Resilience Hub Application Component, returned as an object. This object contains the names of the Application Components, configuration recommendations, and recommendation statuses.</p>', ], ], 'ConfigRecommendation' => [ 'base' => '<p>Defines a recommendation configuration.</p>', 'refs' => [ 'ConfigRecommendationList$member' => NULL, ], ], 'ConfigRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ComponentRecommendation$configRecommendations' => '<p>List of recommendations.</p>', ], ], 'ConfigRecommendationOptimizationType' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$optimizationType' => '<p>The type of optimization.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This exception occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>', 'refs' => [], ], 'Cost' => [ 'base' => '<p>Defines a cost object.</p>', 'refs' => [ 'AppAssessment$cost' => '<p>Cost for the application.</p>', 'AppAssessmentSummary$cost' => '<p>Cost for an application.</p>', 'AppComponentCompliance$cost' => '<p>The cost for the application.</p>', 'ConfigRecommendation$cost' => '<p>The cost for the application.</p>', ], ], 'CostFrequency' => [ 'base' => NULL, 'refs' => [ 'Cost$frequency' => '<p>The cost frequency.</p>', ], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppVersionAppComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppVersionAppComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppVersionResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppVersionResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommendationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommendationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'Cost$currency' => '<p>The cost currency, for example <code>USD</code>.</p>', ], ], 'CustomerId' => [ 'base' => NULL, 'refs' => [ 'CreateAppVersionResourceRequest$awsAccountId' => '<p>Amazon Web Services account that owns the physical resource.</p>', 'DeleteAppVersionResourceRequest$awsAccountId' => '<p>Amazon Web Services account that owns the physical resource.</p>', 'DescribeAppVersionResourceRequest$awsAccountId' => '<p>Amazon Web Services account that owns the physical resource.</p>', 'PhysicalResourceId$awsAccountId' => '<p>The Amazon Web Services account that owns the physical resource.</p>', 'RecommendationItem$targetAccountId' => '<p>Identifier of the target account.</p>', 'UpdateAppVersionResourceRequest$awsAccountId' => '<p>Amazon Web Services account that owns the physical resource.</p>', 'UpdateRecommendationStatusItem$targetAccountId' => '<p>Identifier of the target Amazon Web Services account.</p>', ], ], 'DataLocationConstraint' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', 'ResiliencyPolicy$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', 'UpdateResiliencyPolicyRequest$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', ], ], 'DeleteAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInputSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInputSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppVersionAppComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppVersionAppComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppVersionResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppVersionResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommendationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommendationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionAppComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionAppComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourcesResolutionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourcesResolutionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDraftAppVersionResourcesImportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDraftAppVersionResourcesImportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceGroupingRecommendationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceGroupingRecommendationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DifferenceType' => [ 'base' => NULL, 'refs' => [ 'ComplianceDrift$diffType' => '<p>Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO) values. Currently, Resilience Hub supports only <code>NotEqual</code> difference type.</p>', 'ResourceDrift$diffType' => '<p>Indicates if the resource was added or removed.</p>', ], ], 'DisruptionCompliance' => [ 'base' => '<p>Defines the compliance against the resiliency policy for a disruption.</p>', 'refs' => [ 'AssessmentCompliance$value' => NULL, ], ], 'DisruptionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$policy' => '<p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', 'ResiliencyPolicy$policy' => '<p>The resiliency policy.</p>', 'UpdateResiliencyPolicyRequest$policy' => '<p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', ], ], 'DisruptionResiliencyScore' => [ 'base' => NULL, 'refs' => [ 'ResiliencyScore$disruptionScore' => '<p>The disruption score for a valid key.</p>', ], ], 'DisruptionType' => [ 'base' => NULL, 'refs' => [ 'AssessmentCompliance$key' => NULL, 'DisruptionPolicy$key' => NULL, 'DisruptionResiliencyScore$key' => NULL, 'RecommendationCompliance$key' => NULL, ], ], 'DocumentName' => [ 'base' => NULL, 'refs' => [ 'SopRecommendation$name' => '<p>Name of the SOP recommendation.</p>', 'TestRecommendation$name' => '<p>Name of the test recommendation.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'App$resiliencyScore' => '<p>Current resiliency score for the application.</p>', 'AppAssessmentSummary$resiliencyScore' => '<p>Current resiliency score for the application.</p>', 'AppSummary$resiliencyScore' => '<p>The current resiliency score for the application.</p>', 'Cost$amount' => '<p>The cost amount.</p>', 'DisruptionResiliencyScore$value' => NULL, 'GroupingRecommendation$score' => '<p>Indicates the confidence level of the grouping recommendation.</p>', 'ResiliencyScore$score' => '<p>The outage score for a valid key.</p>', 'ScoringComponentResiliencyScore$possibleScore' => '<p>Maximum possible score that can be obtained for the scoring component. </p> <p>For example, if the <code>possibleScore</code> is 20 points, it indicates the maximum possible score you can achieve for the scoring component when you run a new assessment after implementing all the Resilience Hub recommendations.</p>', 'ScoringComponentResiliencyScore$score' => '<p>Resiliency score points given for the scoring component. The score is always less than or equal to the <code>possibleScore</code>.</p>', ], ], 'DriftStatus' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$driftStatus' => '<p>Indicates if compliance drifts (deviations) were detected while running an assessment for your application.</p>', 'AppAssessmentSummary$driftStatus' => '<p>Indicates if compliance drifts (deviations) were detected while running an assessment for your application.</p>', ], ], 'DriftType' => [ 'base' => NULL, 'refs' => [ 'ComplianceDrift$driftType' => '<p>The type of drift detected. Currently, Resilience Hub supports only <b>ApplicationCompliance</b> drift type.</p>', ], ], 'EksNamespace' => [ 'base' => NULL, 'refs' => [ 'EksNamespaceList$member' => NULL, 'EksSourceClusterNamespace$namespace' => '<p>Name of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.</p>', ], ], 'EksNamespaceList' => [ 'base' => NULL, 'refs' => [ 'EksSource$namespaces' => '<p>The list of namespaces located on your Amazon Elastic Kubernetes Service cluster.</p>', ], ], 'EksSource' => [ 'base' => '<p>The input source of the Amazon Elastic Kubernetes Service cluster.</p>', 'refs' => [ 'EksSourceList$member' => NULL, ], ], 'EksSourceClusterNamespace' => [ 'base' => '<p>The input source of the namespace that is located on your Amazon Elastic Kubernetes Service cluster.</p>', 'refs' => [ 'AppInputSource$eksSourceClusterNamespace' => '<p>The namespace on your Amazon Elastic Kubernetes Service cluster.</p>', 'DeleteAppInputSourceRequest$eksSourceClusterNamespace' => '<p>The namespace on your Amazon Elastic Kubernetes Service cluster that you want to delete from the Resilience Hub application.</p>', ], ], 'EksSourceList' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$eksSources' => '<p>The input sources of the Amazon Elastic Kubernetes Service resources you need to import.</p>', 'ImportResourcesToDraftAppVersionResponse$eksSources' => '<p>The input sources of the Amazon Elastic Kubernetes Service resources you have imported.</p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$description' => '<p>Description of the alarm recommendation.</p>', 'App$description' => '<p>Optional description for an application.</p>', 'AppSummary$description' => '<p>The optional description for an app.</p>', 'ConfigRecommendation$description' => '<p>The optional description for an app.</p>', 'CreateAppRequest$description' => '<p>The optional description for an app.</p>', 'CreateResiliencyPolicyRequest$policyDescription' => '<p>The description for the policy.</p>', 'ResiliencyPolicy$policyDescription' => '<p>The description for the policy.</p>', 'SuggestedChangesList$member' => NULL, 'TestRecommendation$intent' => '<p>Intent of the test recommendation.</p>', 'UpdateAppRequest$description' => '<p>The optional description for an app.</p>', 'UpdateResiliencyPolicyRequest$policyDescription' => '<p>The description for the policy.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$appComponentName' => '<p>Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item in the <code>appComponentNames</code> list.</p>', 'AppComponentCompliance$appComponentName' => '<p>Name of the Application Component.</p>', 'ComponentRecommendation$appComponentName' => '<p>Name of the Application Component.</p>', 'ConfigRecommendation$appComponentName' => '<p>Name of the Application Component.</p>', 'ResourceDrift$referenceId' => '<p>Reference identifier of the resource drift.</p>', 'SopRecommendation$appComponentName' => '<p>Name of the Application Component.</p>', 'TestRecommendation$appComponentName' => '<p>Name of the Application Component.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'App$name' => '<p>Name for the application.</p>', 'AppAssessment$assessmentName' => '<p>Name of the assessment.</p>', 'AppAssessmentSummary$assessmentName' => '<p>Name of the assessment.</p>', 'AppSummary$name' => '<p>The name of the application.</p>', 'ConfigRecommendation$name' => '<p>The name of the recommendation configuration.</p>', 'CreateAppRequest$name' => '<p>Name of the application.</p>', 'CreateAppVersionResourceRequest$resourceName' => '<p>Name of the resource.</p>', 'CreateRecommendationTemplateRequest$bucketName' => '<p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>', 'CreateRecommendationTemplateRequest$name' => '<p>The name for the recommendation template.</p>', 'CreateResiliencyPolicyRequest$policyName' => '<p>The name of the policy</p>', 'DeleteAppVersionResourceRequest$resourceName' => '<p>Name of the resource.</p>', 'DescribeAppVersionResourceRequest$resourceName' => '<p>Name of the resource.</p>', 'EntityNameList$member' => NULL, 'ListAppAssessmentsRequest$assessmentName' => '<p>The name for the assessment.</p>', 'ListAppsRequest$name' => '<p>The name for the one of the listed applications.</p>', 'ListRecommendationTemplatesRequest$name' => '<p>The name for one of the listed recommendation templates.</p>', 'ListResiliencyPoliciesRequest$policyName' => '<p>The name of the policy</p>', 'LogicalResourceId$resourceGroupName' => '<p>The name of the resource group that this resource belongs to.</p>', 'PhysicalResource$parentResourceName' => '<p>Name of the parent resource.</p>', 'PhysicalResource$resourceName' => '<p>The name of the resource.</p>', 'RecommendationTemplate$name' => '<p>Name for the recommendation template.</p>', 'ResiliencyPolicy$policyName' => '<p>The name of the policy</p>', 'ResourceMapping$appRegistryAppName' => '<p>Name of the application this resource is mapped to when the <code>mappingType</code> is <code>AppRegistryApp</code>.</p>', 'ResourceMapping$resourceGroupName' => '<p>Name of the Resource Groups that this resource is mapped to when the <code>mappingType</code> is <code>ResourceGroup</code>.</p>', 'ResourceMapping$resourceName' => '<p>Name of the resource that this resource is mapped to when the <code>mappingType</code> is <code>Resource</code>.</p>', 'StartAppAssessmentRequest$assessmentName' => '<p>The name for the assessment.</p>', 'UpdateAppVersionResourceRequest$resourceName' => '<p>Name of the resource.</p>', 'UpdateResiliencyPolicyRequest$policyName' => '<p>The name of the policy</p>', ], ], 'EntityName255' => [ 'base' => NULL, 'refs' => [ 'AppComponent$id' => '<p>Identifier of the Application Component.</p>', 'AppComponent$name' => '<p>Name of the Application Component.</p>', 'GroupingAppComponent$appComponentId' => '<p>Indicates the identifier of an AppComponent.</p>', 'GroupingAppComponent$appComponentName' => '<p>Indicates the name of an AppComponent.</p>', ], ], 'EntityNameList' => [ 'base' => NULL, 'refs' => [ 'RemoveDraftAppVersionResourceMappingsRequest$appRegistryAppNames' => '<p>The names of the registered applications you want to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$resourceGroupNames' => '<p>The names of the resource groups you want to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$resourceNames' => '<p>The names of the resources you want to remove from the resource mappings.</p>', ], ], 'EntityVersion' => [ 'base' => NULL, 'refs' => [ 'AddDraftAppVersionResourceMappingsResponse$appVersion' => '<p>The version of the application.</p>', 'AppAssessment$appVersion' => '<p>Version of an application.</p>', 'AppAssessment$versionName' => '<p>Version name of the published application.</p>', 'AppAssessmentSummary$appVersion' => '<p>Version of an application.</p>', 'AppAssessmentSummary$versionName' => '<p>Name of an application version.</p>', 'AppVersionSummary$appVersion' => '<p>Version of an application.</p>', 'AppVersionSummary$versionName' => '<p>Name of the application version.</p>', 'CreateAppVersionAppComponentResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'CreateAppVersionResourceResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DeleteAppVersionAppComponentResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DeleteAppVersionResourceResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionAppComponentRequest$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionAppComponentResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionRequest$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionResourceRequest$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionResourceResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'DescribeAppVersionTemplateRequest$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionTemplateResponse$appVersion' => '<p>The version of the application.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$appVersion' => '<p>The version of the application.</p>', 'ImportResourcesToDraftAppVersionResponse$appVersion' => '<p>The version of the application.</p>', 'ListAppInputSourcesRequest$appVersion' => '<p>Resilience Hub application version.</p>', 'ListAppVersionAppComponentsRequest$appVersion' => '<p>Version of the Application Component.</p>', 'ListAppVersionAppComponentsResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'ListAppVersionResourceMappingsRequest$appVersion' => '<p>The version of the application.</p>', 'ListAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'ListUnsupportedAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'PublishAppVersionRequest$versionName' => '<p>Name of the application version.</p>', 'PublishAppVersionResponse$appVersion' => '<p>The version of the application.</p>', 'PublishAppVersionResponse$versionName' => '<p>Name of the application version.</p>', 'PutDraftAppVersionTemplateResponse$appVersion' => '<p>The version of the application.</p>', 'RemoveDraftAppVersionResourceMappingsResponse$appVersion' => '<p>The version of the application.</p>', 'ResolveAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'ResolveAppVersionResourcesResponse$appVersion' => '<p>The version of the application.</p>', 'ResourceDrift$appVersion' => '<p>Version of the application whose resources have drifted.</p>', 'StartAppAssessmentRequest$appVersion' => '<p>The version of the application.</p>', 'UpdateAppVersionAppComponentResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'UpdateAppVersionResourceResponse$appVersion' => '<p>Resilience Hub application version.</p>', 'UpdateAppVersionResponse$appVersion' => '<p>Resilience Hub application version.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusFailedEntry$errorMessage' => '<p>Indicates the error that occurred while excluding an operational recommendation.</p>', 'FailedGroupingRecommendationEntry$errorMessage' => '<p>Indicates the error that occurred while implementing a grouping recommendation.</p>', 'ResourceError$reason' => '<p> This is the error message. </p>', ], ], 'EstimatedCostTier' => [ 'base' => NULL, 'refs' => [ 'ResiliencyPolicy$estimatedCostTier' => '<p>Specifies the estimated cost tier of the resiliency policy.</p>', ], ], 'EventSubscription' => [ 'base' => '<p>Indicates an event you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.</p>', 'refs' => [ 'EventSubscriptionList$member' => NULL, ], ], 'EventSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'App$eventSubscriptions' => '<p>The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.</p>', 'CreateAppRequest$eventSubscriptions' => '<p>The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.</p>', 'UpdateAppRequest$eventSubscriptions' => '<p>The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for <b>Drift detected</b> and <b>Scheduled assessment failure</b> events.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventSubscription$eventType' => '<p>The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for <b>Drift detected</b> (<code>DriftDetected</code>) and <b>Scheduled assessment failure</b> (<code>ScheduledAssessmentFailure</code>) events.</p>', ], ], 'ExcludeRecommendationReason' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusSuccessfulEntry$excludeReason' => '<p>Indicates the reason for excluding an operational recommendation.</p>', 'RecommendationItem$excludeReason' => '<p>Indicates the reason for excluding an operational recommendation.</p>', 'UpdateRecommendationStatusRequestEntry$excludeReason' => '<p>Indicates the reason for excluding an operational recommendation.</p>', ], ], 'FailedGroupingRecommendationEntries' => [ 'base' => NULL, 'refs' => [ 'AcceptResourceGroupingRecommendationsResponse$failedEntries' => '<p>Indicates the list of resource grouping recommendations that could not be included in your application.</p>', 'RejectResourceGroupingRecommendationsResponse$failedEntries' => '<p>Indicates the list of resource grouping recommendations that failed to get excluded in your application.</p>', ], ], 'FailedGroupingRecommendationEntry' => [ 'base' => '<p>Indicates the accepted grouping recommendation whose implementation failed.</p>', 'refs' => [ 'FailedGroupingRecommendationEntries$member' => NULL, ], ], 'FailurePolicy' => [ 'base' => '<p>Defines a failure policy.</p>', 'refs' => [ 'DisruptionPolicy$value' => NULL, ], ], 'GroupingAppComponent' => [ 'base' => '<p>Creates a new recommended Application Component (AppComponent).</p>', 'refs' => [ 'GroupingRecommendation$groupingAppComponent' => '<p>Indicates the name of the recommended Application Component (AppComponent).</p>', ], ], 'GroupingRecommendation' => [ 'base' => '<p>Creates a new grouping recommendation.</p>', 'refs' => [ 'GroupingRecommendationList$member' => NULL, ], ], 'GroupingRecommendationConfidenceLevel' => [ 'base' => NULL, 'refs' => [ 'GroupingRecommendation$confidenceLevel' => '<p>Indicates the confidence level of Resilience Hub on the grouping recommendation.</p>', ], ], 'GroupingRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListResourceGroupingRecommendationsResponse$groupingRecommendations' => '<p>List of resource grouping recommendations generated by Resilience Hub.</p>', ], ], 'GroupingRecommendationRejectionReason' => [ 'base' => NULL, 'refs' => [ 'GroupingRecommendation$rejectionReason' => '<p>Indicates the reason you had selected while rejecting a grouping recommendation.</p>', 'RejectGroupingRecommendationEntry$rejectionReason' => '<p>Indicates the reason you had selected while rejecting a grouping recommendation.</p>', ], ], 'GroupingRecommendationStatusType' => [ 'base' => NULL, 'refs' => [ 'GroupingRecommendation$status' => '<p>Indicates the status of grouping resources into AppComponents.</p>', ], ], 'GroupingResource' => [ 'base' => '<p>Indicates the resource that will be grouped in the recommended Application Component (AppComponent).</p>', 'refs' => [ 'GroupingResourceList$member' => NULL, ], ], 'GroupingResourceList' => [ 'base' => NULL, 'refs' => [ 'GroupingRecommendation$resources' => '<p>Indicates the resources that are grouped in a recommended AppComponent.</p>', ], ], 'HaArchitecture' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$haArchitecture' => '<p>The architecture type.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'IamRoleArnList$member' => NULL, ], ], 'IamRoleArnList' => [ 'base' => NULL, 'refs' => [ 'PermissionModel$crossAccountRoleArns' => '<p>Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for querying purposes while importing resources and assessing your application.</p> <note> <ul> <li> <p>These ARNs are required only when your resources are in other accounts and you have different role name in these accounts. Else, the invoker role name will be used in the other accounts.</p> </li> <li> <p>These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the primary account.</p> </li> </ul> </note>', ], ], 'IamRoleName' => [ 'base' => NULL, 'refs' => [ 'PermissionModel$invokerRoleName' => '<p>Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be assumed by Resilience Hub Service Principle to obtain a read-only access to your application resources while running an assessment.</p> <note> <ul> <li> <p>You must have <code>iam:passRole</code> permission for this role while creating or updating the application.</p> </li> <li> <p>Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.@-]</code> characters.</p> </li> </ul> </note>', ], ], 'ImportResourcesToDraftAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportResourcesToDraftAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AppInputSource$resourceCount' => '<p>The number of resources.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'App$rpoInSecs' => '<p>Recovery Point Objective (RPO) in seconds.</p>', 'App$rtoInSecs' => '<p>Recovery Time Objective (RTO) in seconds.</p>', 'AppSummary$rpoInSecs' => '<p>Recovery Point Objective (RPO) in seconds.</p>', 'AppSummary$rtoInSecs' => '<p>Recovery Time Objective (RTO) in seconds.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>This exception occurs when there is an internal failure in the Resilience Hub service.</p>', 'refs' => [], ], 'ListAlarmRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlarmRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentComplianceDriftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentComplianceDriftsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentResourceDriftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentResourceDriftsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentCompliancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentCompliancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInputSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInputSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionAppComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionAppComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResiliencyPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResiliencyPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceGroupingRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceGroupingRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSopRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSopRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSuggestedResiliencyPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSuggestedResiliencyPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUnsupportedAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUnsupportedAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogicalResourceId' => [ 'base' => '<p>Defines a logical resource identifier.</p>', 'refs' => [ 'CreateAppVersionResourceRequest$logicalResourceId' => '<p>Logical identifier of the resource.</p>', 'DeleteAppVersionResourceRequest$logicalResourceId' => '<p>Logical identifier of the resource.</p>', 'DescribeAppVersionResourceRequest$logicalResourceId' => '<p>Logical identifier of the resource.</p>', 'GroupingResource$logicalResourceId' => '<p>Indicates the logical identifier of the resource.</p>', 'PhysicalResource$logicalResourceId' => '<p>Logical identifier of the resource.</p>', 'ResourceIdentifier$logicalResourceId' => '<p>Logical identifier of the drifted resource.</p>', 'UnsupportedResource$logicalResourceId' => '<p>Logical resource identifier for the unsupported resource.</p>', 'UpdateAppVersionResourceRequest$logicalResourceId' => '<p>Logical identifier of the resource.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ScoringComponentResiliencyScore$excludedCount' => '<p>Number of recommendations that were excluded from the assessment.</p> <p>For example, if the <code>excludedCount</code> for Alarms coverage scoring component is 7, it indicates that 7 Amazon CloudWatch alarms are excluded from the assessment.</p>', 'ScoringComponentResiliencyScore$outstandingCount' => '<p>Number of recommendations that must be implemented to obtain the maximum possible score for the scoring component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented. For compliance, these are the number of Application Components that have breached the resiliency policy.</p> <p>For example, if the <code>outstandingCount</code> for Alarms coverage scoring component is 5, it indicates that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.</p>', ], ], 'LongOptional' => [ 'base' => NULL, 'refs' => [ 'AppVersionSummary$identifier' => '<p>Identifier of the application version.</p>', 'PublishAppVersionResponse$identifier' => '<p>Identifier of the application version.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppAssessmentComplianceDriftsRequest$maxResults' => '<p>Indicates the maximum number of compliance drifts requested.</p>', 'ListAppAssessmentResourceDriftsRequest$maxResults' => '<p>Indicates the maximum number of drift results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppAssessmentsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppComponentCompliancesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppComponentRecommendationsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppInputSourcesRequest$maxResults' => '<p>Maximum number of input sources to be displayed per Resilience Hub application.</p>', 'ListAppVersionAppComponentsRequest$maxResults' => '<p>Maximum number of Application Components to be displayed per Resilience Hub application version.</p>', 'ListAppVersionResourceMappingsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppVersionResourcesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppVersionsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListRecommendationTemplatesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListResiliencyPoliciesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListResourceGroupingRecommendationsRequest$maxResults' => '<p>Maximum number of grouping recommendations to be displayed per Resilience Hub application.</p>', 'ListSopRecommendationsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListSuggestedResiliencyPoliciesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListTestRecommendationsRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListUnsupportedAppVersionResourcesRequest$maxResults' => '<p>Maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAlarmRecommendationsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppAssessmentComplianceDriftsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentComplianceDriftsResponse$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentResourceDriftsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentResourceDriftsResponse$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppComponentCompliancesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppComponentCompliancesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppComponentRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppComponentRecommendationsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppInputSourcesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppInputSourcesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionAppComponentsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionAppComponentsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionResourceMappingsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionResourceMappingsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionResourcesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionResourcesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListAppsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListRecommendationTemplatesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListRecommendationTemplatesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListResiliencyPoliciesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListResiliencyPoliciesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListResourceGroupingRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListResourceGroupingRecommendationsResponse$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListSopRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListSopRecommendationsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListSuggestedResiliencyPoliciesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListSuggestedResiliencyPoliciesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListTestRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListTestRecommendationsResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', 'ListUnsupportedAppVersionResourcesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListUnsupportedAppVersionResourcesResponse$nextToken' => '<p>Token for the next set of results, or null if there are no more results.</p>', ], ], 'PermissionModel' => [ 'base' => '<p>Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.</p>', 'refs' => [ 'App$permissionModel' => '<p>Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.</p>', 'CreateAppRequest$permissionModel' => '<p>Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.</p>', 'UpdateAppRequest$permissionModel' => '<p>Defines the roles and credentials that Resilience Hub would use while creating an application, importing its resources, and running an assessment.</p>', ], ], 'PermissionModelType' => [ 'base' => NULL, 'refs' => [ 'PermissionModel$type' => '<p>Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role in your Amazon Web Services account, or by using the credentials of the current IAM user.</p>', ], ], 'PhysicalIdentifierType' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceId$type' => '<p>Specifies the type of physical resource identifier.</p> <dl> <dt>Arn</dt> <dd> <p>The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:</p> <ul> <li> <p> <code>AWS::ECS::Service</code> </p> </li> <li> <p> <code>AWS::EFS::FileSystem</code> </p> </li> <li> <p> <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::SNS::Topic</code> </p> </li> </ul> </dd> <dt>Native</dt> <dd> <p>The resource identifier is an Resilience Hub-native identifier and it can identify the following list of resources:</p> <ul> <li> <p> <code>AWS::ApiGateway::RestApi</code> </p> </li> <li> <p> <code>AWS::ApiGatewayV2::Api</code> </p> </li> <li> <p> <code>AWS::AutoScaling::AutoScalingGroup</code> </p> </li> <li> <p> <code>AWS::DocDB::DBCluster</code> </p> </li> <li> <p> <code>AWS::DocDB::DBGlobalCluster</code> </p> </li> <li> <p> <code>AWS::DocDB::DBInstance</code> </p> </li> <li> <p> <code>AWS::DynamoDB::GlobalTable</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> <li> <p> <code>AWS::EC2::EC2Fleet</code> </p> </li> <li> <p> <code>AWS::EC2::Instance</code> </p> </li> <li> <p> <code>AWS::EC2::NatGateway</code> </p> </li> <li> <p> <code>AWS::EC2::Volume</code> </p> </li> <li> <p> <code>AWS::ElasticLoadBalancing::LoadBalancer</code> </p> </li> <li> <p> <code>AWS::RDS::DBCluster</code> </p> </li> <li> <p> <code>AWS::RDS::DBInstance</code> </p> </li> <li> <p> <code>AWS::RDS::GlobalCluster</code> </p> </li> <li> <p> <code>AWS::Route53::RecordSet</code> </p> </li> <li> <p> <code>AWS::S3::Bucket</code> </p> </li> <li> <p> <code>AWS::SQS::Queue</code> </p> </li> </ul> </dd> </dl>', ], ], 'PhysicalResource' => [ 'base' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or an Resilience Hub-native identifier. </p>', 'refs' => [ 'CreateAppVersionResourceResponse$physicalResource' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.</p>', 'DeleteAppVersionResourceResponse$physicalResource' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.</p>', 'DescribeAppVersionResourceResponse$physicalResource' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.</p>', 'PhysicalResourceList$member' => NULL, 'UpdateAppVersionResourceResponse$physicalResource' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.</p>', ], ], 'PhysicalResourceId' => [ 'base' => '<p>Defines a physical resource identifier.</p>', 'refs' => [ 'GroupingResource$physicalResourceId' => '<p>Indicates the physical identifier of the resource.</p>', 'PhysicalResource$physicalResourceId' => '<p>Identifier of the physical resource.</p>', 'ResourceMapping$physicalResourceId' => '<p>Identifier of the physical resource.</p>', 'UnsupportedResource$physicalResourceId' => '<p>Physical resource identifier for the unsupported resource.</p>', ], ], 'PhysicalResourceList' => [ 'base' => NULL, 'refs' => [ 'ListAppVersionResourcesResponse$physicalResources' => '<p>The physical resources in the application version.</p>', ], ], 'PublishAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PublishAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutDraftAppVersionTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDraftAppVersionTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationCompliance' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$recommendationCompliance' => '<p>The expected compliance against the resiliency policy after applying the configuration change.</p>', ], ], 'RecommendationComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'ComponentRecommendation$recommendationStatus' => '<p>Status of the recommendation.</p>', ], ], 'RecommendationDisruptionCompliance' => [ 'base' => '<p>Defines a disruption compliance recommendation.</p>', 'refs' => [ 'RecommendationCompliance$value' => NULL, ], ], 'RecommendationIdList' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$recommendationIds' => '<p>Identifiers for the recommendations used to create a recommendation template.</p>', 'RecommendationTemplate$recommendationIds' => '<p>Identifiers for the recommendations used in the recommendation template.</p>', ], ], 'RecommendationItem' => [ 'base' => '<p>Defines a recommendation.</p>', 'refs' => [ 'RecommendationItemList$member' => NULL, ], ], 'RecommendationItemList' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$items' => '<p>List of CloudWatch alarm recommendations.</p>', 'SopRecommendation$items' => '<p>The recommendation items.</p>', 'TestRecommendation$items' => '<p>The test recommendation items.</p>', ], ], 'RecommendationStatus' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$recommendationStatus' => '<p>Status of the recommended Amazon CloudWatch alarm.</p>', 'SopRecommendation$recommendationStatus' => '<p>Status of the recommended standard operating procedure.</p>', 'TestRecommendation$recommendationStatus' => '<p>Status of the recommended test.</p>', ], ], 'RecommendationTemplate' => [ 'base' => '<p>Defines a recommendation template created with the <a>CreateRecommendationTemplate</a> action.</p>', 'refs' => [ 'CreateRecommendationTemplateResponse$recommendationTemplate' => '<p>The newly created recommendation template, returned as an object. This object includes the template\'s name, format, status, tags, Amazon S3 bucket location, and more.</p>', 'RecommendationTemplateList$member' => NULL, ], ], 'RecommendationTemplateList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationTemplatesResponse$recommendationTemplates' => '<p>The recommendation templates for the Resilience Hub applications.</p>', ], ], 'RecommendationTemplateStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteRecommendationTemplateResponse$status' => '<p>Status of the action.</p>', 'RecommendationTemplate$status' => '<p>Status of the action.</p>', 'RecommendationTemplateStatusList$member' => NULL, ], ], 'RecommendationTemplateStatusList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationTemplatesRequest$status' => '<p>Status of the action.</p>', ], ], 'RejectGroupingRecommendationEntries' => [ 'base' => NULL, 'refs' => [ 'RejectResourceGroupingRecommendationsRequest$entries' => '<p>Indicates the list of resource grouping recommendations you have selected to exclude from your application.</p>', ], ], 'RejectGroupingRecommendationEntry' => [ 'base' => '<p>Indicates the rejected grouping recommendation.</p>', 'refs' => [ 'RejectGroupingRecommendationEntries$member' => NULL, ], ], 'RejectResourceGroupingRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectResourceGroupingRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveDraftAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveDraftAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderRecommendationType' => [ 'base' => NULL, 'refs' => [ 'RenderRecommendationTypeList$member' => NULL, ], ], 'RenderRecommendationTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$recommendationTypes' => '<p>An array of strings that specify the recommendation template type or types.</p> <dl> <dt>Alarm</dt> <dd> <p>The template is an <a>AlarmRecommendation</a> template.</p> </dd> <dt>Sop</dt> <dd> <p>The template is a <a>SopRecommendation</a> template.</p> </dd> <dt>Test</dt> <dd> <p>The template is a <a>TestRecommendation</a> template.</p> </dd> </dl>', 'RecommendationTemplate$recommendationTypes' => '<p>An array of strings that specify the recommendation template type or types.</p> <dl> <dt>Alarm</dt> <dd> <p>The template is an <a>AlarmRecommendation</a> template.</p> </dd> <dt>Sop</dt> <dd> <p>The template is a <a>SopRecommendation</a> template.</p> </dd> <dt>Test</dt> <dd> <p>The template is a <a>TestRecommendation</a> template.</p> </dd> </dl>', ], ], 'ResiliencyPolicies' => [ 'base' => NULL, 'refs' => [ 'ListResiliencyPoliciesResponse$resiliencyPolicies' => '<p>The resiliency policies for the Resilience Hub applications.</p>', 'ListSuggestedResiliencyPoliciesResponse$resiliencyPolicies' => '<p>The suggested resiliency policies for the Resilience Hub applications.</p>', ], ], 'ResiliencyPolicy' => [ 'base' => '<p>Defines a resiliency policy.</p> <note> <p>Resilience Hub allows you to provide a value of zero for <code>rtoInSecs</code> and <code>rpoInSecs</code> of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for <code>rtoInSecs</code> and <code>rpoInSecs</code>, the estimated workload RTO and estimated workload RPO result will be near zero and the <b>Compliance status</b> for your application will be set to <b>Policy breached</b>.</p> </note>', 'refs' => [ 'AppAssessment$policy' => '<p>Resiliency policy of an application.</p>', 'CreateResiliencyPolicyResponse$policy' => '<p>The type of resiliency policy that was created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', 'DescribeResiliencyPolicyResponse$policy' => '<p>Information about the specific resiliency policy, returned as an object. This object includes creation time, data location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>', 'ResiliencyPolicies$member' => NULL, 'UpdateResiliencyPolicyResponse$policy' => '<p>The type of resiliency policy that was updated, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', ], ], 'ResiliencyPolicyTier' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', 'ResiliencyPolicy$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', 'UpdateResiliencyPolicyRequest$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', ], ], 'ResiliencyScore' => [ 'base' => '<p>The overall resiliency score, returned as an object that includes the disruption score and outage score.</p>', 'refs' => [ 'AppAssessment$resiliencyScore' => '<p>Current resiliency score for an application.</p>', 'AppComponentCompliance$resiliencyScore' => '<p>The current resiliency score for the application.</p>', ], ], 'ResiliencyScoreType' => [ 'base' => NULL, 'refs' => [ 'ScoringComponentResiliencyScores$key' => NULL, ], ], 'ResolveAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResolveAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceDrift' => [ 'base' => '<p>Indicates the resources that have drifted in the current application version.</p>', 'refs' => [ 'ResourceDriftList$member' => NULL, ], ], 'ResourceDriftList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentResourceDriftsResponse$resourceDrifts' => '<p>Indicates all the resource drifts detected for an assessed entity.</p>', ], ], 'ResourceError' => [ 'base' => '<p> Defines application resource errors. </p>', 'refs' => [ 'ResourceErrorList$member' => NULL, ], ], 'ResourceErrorList' => [ 'base' => NULL, 'refs' => [ 'ResourceErrorsDetails$resourceErrors' => '<p> A list of errors retrieving an application\'s resources. </p>', ], ], 'ResourceErrorsDetails' => [ 'base' => '<p> A list of errors retrieving an application\'s resources. </p>', 'refs' => [ 'AppAssessment$resourceErrorsDetails' => '<p> A resource error object containing a list of errors retrieving an application\'s resources. </p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceId' => '<p>The identifier of the resource that the exception applies to.</p>', 'ResourceNotFoundException$resourceId' => '<p>The identifier of the resource that the exception applies to.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>Defines a resource identifier for the drifted resource.</p>', 'refs' => [ 'ResourceDrift$resourceIdentifier' => '<p>Identifier of the drifted resource.</p>', ], ], 'ResourceImportStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeDraftAppVersionResourcesImportStatusResponse$status' => '<p>Status of the action.</p>', 'ImportResourcesToDraftAppVersionResponse$status' => '<p>Status of the action.</p>', ], ], 'ResourceImportStrategyType' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$importStrategy' => '<p>The import strategy you would like to set to import resources into Resilience Hub application.</p>', ], ], 'ResourceMapping' => [ 'base' => '<p>Defines a resource mapping.</p>', 'refs' => [ 'ResourceMappingList$member' => NULL, ], ], 'ResourceMappingList' => [ 'base' => NULL, 'refs' => [ 'AddDraftAppVersionResourceMappingsRequest$resourceMappings' => '<p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>', 'AddDraftAppVersionResourceMappingsResponse$resourceMappings' => '<p>List of sources that are used to map a logical resource from the template to a physical resource. You can use sources such as CloudFormation, Terraform state files, AppRegistry applications, or Amazon EKS.</p>', 'ListAppVersionResourceMappingsResponse$resourceMappings' => '<p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>', ], ], 'ResourceMappingType' => [ 'base' => NULL, 'refs' => [ 'AppInputSource$importType' => '<p>The resource type of the input source.</p>', 'ResourceMapping$mappingType' => '<p>Specifies the type of resource mapping.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception occurs when the specified resource could not be found.</p>', 'refs' => [], ], 'ResourceResolutionStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeAppVersionResourcesResolutionStatusResponse$status' => '<p>Status of the action.</p>', 'ResolveAppVersionResourcesResponse$status' => '<p>Status of the action.</p>', ], ], 'ResourceSourceType' => [ 'base' => NULL, 'refs' => [ 'PhysicalResource$sourceType' => '<p>Type of input source.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p>The type of the resource that the exception applies to.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that the exception applies to.</p>', ], ], 'ResourcesGroupingRecGenStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceGroupingRecommendationTaskResponse$status' => '<p>Status of the action.</p>', 'StartResourceGroupingRecommendationTaskResponse$status' => '<p>Status of the action.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the operation.</p>', ], ], 'S3Location' => [ 'base' => '<p>The location of the Amazon S3 bucket.</p>', 'refs' => [ 'RecommendationTemplate$templatesLocation' => '<p>The file location of the template.</p>', ], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'TerraformSource$s3StateFileUrl' => '<p> The URL of the Terraform s3 state file you need to import. </p>', ], ], 'ScoringComponentResiliencyScore' => [ 'base' => '<p>Resiliency score of each scoring component. For more information about scoring component, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/calculate-score.html">Calculating resiliency score</a>.</p>', 'refs' => [ 'ScoringComponentResiliencyScores$value' => NULL, ], ], 'ScoringComponentResiliencyScores' => [ 'base' => NULL, 'refs' => [ 'ResiliencyScore$componentScore' => '<p>The score generated by Resilience Hub for the scoring component after running an assessment.</p> <p>For example, if the <code>score</code> is 25 points, it indicates the overall score of your application generated by Resilience Hub after running an assessment.</p>', ], ], 'Seconds' => [ 'base' => NULL, 'refs' => [ 'DisruptionCompliance$achievableRpoInSecs' => '<p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>', 'DisruptionCompliance$achievableRtoInSecs' => '<p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>', 'DisruptionCompliance$currentRpoInSecs' => '<p>The current RPO, in seconds.</p>', 'DisruptionCompliance$currentRtoInSecs' => '<p>The current RTO, in seconds.</p>', 'FailurePolicy$rpoInSecs' => '<p>Recovery Point Objective (RPO) in seconds.</p>', 'FailurePolicy$rtoInSecs' => '<p>Recovery Time Objective (RTO) in seconds.</p>', 'RecommendationDisruptionCompliance$expectedRpoInSecs' => '<p>The expected RPO after applying the recommended configuration change.</p>', 'RecommendationDisruptionCompliance$expectedRtoInSecs' => '<p>The expected RTO after applying the recommended configuration change.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This exception occurs when you have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'SopRecommendation' => [ 'base' => '<p>Defines a standard operating procedure (SOP) recommendation.</p>', 'refs' => [ 'SopRecommendationList$member' => NULL, ], ], 'SopRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListSopRecommendationsResponse$sopRecommendations' => '<p>The standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>', ], ], 'SopServiceType' => [ 'base' => NULL, 'refs' => [ 'SopRecommendation$serviceType' => '<p>The service type.</p>', ], ], 'SpecReferenceId' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$referenceId' => '<p>Reference identifier of the alarm recommendation.</p>', 'BatchUpdateRecommendationStatusSuccessfulEntry$referenceId' => '<p>Reference identifier of the operational recommendation.</p>', 'ConfigRecommendation$referenceId' => '<p>Reference identifier for the recommendation configuration.</p>', 'SopRecommendation$referenceId' => '<p>Reference identifier for the SOP recommendation.</p>', 'TestRecommendation$referenceId' => '<p>Reference identifier for the test recommendation.</p>', 'UpdateRecommendationStatusRequestEntry$referenceId' => '<p>Reference identifier of the operational recommendation item.</p>', ], ], 'StartAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartResourceGroupingRecommendationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartResourceGroupingRecommendationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'String1024' => [ 'base' => NULL, 'refs' => [ 'AdditionalInfoValueList$member' => NULL, ], ], 'String128WithoutWhitespace' => [ 'base' => NULL, 'refs' => [ 'AdditionalInfoMap$key' => NULL, ], ], 'String2048' => [ 'base' => NULL, 'refs' => [ 'CreateAppVersionResourceRequest$physicalResourceId' => '<p>Physical identifier of the resource.</p>', 'DeleteAppVersionResourceRequest$physicalResourceId' => '<p>Physical identifier of the resource.</p>', 'DescribeAppVersionResourceRequest$physicalResourceId' => '<p>Physical identifier of the resource.</p>', 'UpdateAppVersionResourceRequest$physicalResourceId' => '<p>Physical identifier of the resource.</p>', ], ], 'String255' => [ 'base' => NULL, 'refs' => [ 'AcceptGroupingRecommendationEntry$groupingRecommendationId' => '<p>Indicates the identifier of the grouping recommendation.</p>', 'AppComponent$type' => '<p>The type of Application Component.</p>', 'AppComponentNameList$member' => NULL, 'AppInputSource$sourceName' => '<p>The name of the input source.</p>', 'AssessmentRiskRecommendation$recommendation' => '<p>Indicates the recommendation provided by the Resilience Hub to address the identified risks in the application.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'AssessmentRiskRecommendation$risk' => '<p>Indicates the description of the potential risk identified in the application as part of the Resilience Hub assessment.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'BatchUpdateRecommendationStatusFailedEntry$entryId' => '<p>An identifier of an entry in this batch that is used to communicate the result.</p> <note> <p>The <code>entryId</code>s of a batch request need to be unique within a request.</p> </note>', 'BatchUpdateRecommendationStatusSuccessfulEntry$entryId' => '<p>An identifier for an entry in this batch that is used to communicate the result.</p> <note> <p>The <code>entryId</code>s of a batch request need to be unique within a request.</p> </note>', 'ComplianceDrift$actualReferenceId' => '<p>Assessment identifier that is associated with this drift item.</p>', 'ComplianceDrift$appId' => '<p>Identifier of your application.</p>', 'ComplianceDrift$appVersion' => '<p>Published version of your application on which drift was detected.</p>', 'ComplianceDrift$entityId' => '<p>Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either application ID or the AppComponent ID.</p>', 'ComplianceDrift$entityType' => '<p>The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports <code>AWS::ResilienceHub::AppComponent</code> and <code>AWS::ResilienceHub::Application</code>.</p>', 'ComplianceDrift$expectedReferenceId' => '<p>Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the previous assessment (associated with the reference identifier) to compare the compliance with the current assessment to identify drifts.</p>', 'CreateAppVersionAppComponentRequest$id' => '<p>Identifier of the Application Component.</p>', 'CreateAppVersionAppComponentRequest$name' => '<p>Name of the Application Component.</p>', 'CreateAppVersionAppComponentRequest$type' => '<p>Type of Application Component. For more information about the types of Application Component, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a>.</p>', 'CreateAppVersionResourceRequest$resourceType' => '<p>Type of resource.</p>', 'DeleteAppVersionAppComponentRequest$id' => '<p>Identifier of the Application Component.</p>', 'DescribeAppVersionAppComponentRequest$id' => '<p>Identifier of the Application Component.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'DescribeResourceGroupingRecommendationTaskRequest$groupingId' => '<p>Indicates the identifier of the grouping recommendation task.</p>', 'DescribeResourceGroupingRecommendationTaskResponse$groupingId' => '<p>Indicates the identifier of the grouping recommendation task.</p>', 'EventSubscription$name' => '<p>Unique name to identify an event subscription.</p>', 'FailedGroupingRecommendationEntry$groupingRecommendationId' => '<p>Indicates the identifier of the grouping recommendation.</p>', 'GroupingAppComponent$appComponentType' => '<p>Indicates the type of an AppComponent.</p>', 'GroupingRecommendation$groupingRecommendationId' => '<p>Indicates all the reasons available for rejecting a grouping recommendation.</p>', 'GroupingResource$resourceName' => '<p>Indicates the resource name.</p>', 'GroupingResource$resourceType' => '<p>Indicates the resource type.</p>', 'ListAppVersionResourcesRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListAppVersionResourcesResponse$resolutionId' => '<p>The ID for a specific resolution.</p>', 'ListUnsupportedAppVersionResourcesRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListUnsupportedAppVersionResourcesResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'LogicalResourceId$eksSourceName' => '<p>Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note>', 'LogicalResourceId$identifier' => '<p>Identifier of the resource.</p>', 'LogicalResourceId$logicalStackName' => '<p>The name of the CloudFormation stack this resource belongs to.</p>', 'LogicalResourceId$terraformSourceName' => '<p> The name of the Terraform S3 state file this resource belongs to. </p>', 'PhysicalResource$resourceType' => '<p>Type of resource.</p>', 'PhysicalResourceId$identifier' => '<p>Identifier of the physical resource.</p>', 'RejectGroupingRecommendationEntry$groupingRecommendationId' => '<p>Indicates the identifier of the grouping recommendation.</p>', 'ResolveAppVersionResourcesResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ResourceError$logicalResourceId' => '<p>Identifier of the logical resource. </p>', 'ResourceError$physicalResourceId' => '<p>Identifier of the physical resource. </p>', 'ResourceIdentifier$resourceType' => '<p>Type of the drifted resource.</p>', 'ResourceMapping$eksSourceName' => '<p>Name of the Amazon Elastic Kubernetes Service cluster and namespace that this resource is mapped to when the <code>mappingType</code> is <code>EKS</code>.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note>', 'ResourceMapping$logicalStackName' => '<p>Name of the CloudFormation stack this resource is mapped to when the <code>mappingType</code> is <code>CfnStack</code>.</p>', 'ResourceMapping$terraformSourceName' => '<p>Name of the Terraform source that this resource is mapped to when the <code>mappingType</code> is <code>Terraform</code>.</p>', 'StartResourceGroupingRecommendationTaskResponse$groupingId' => '<p>Indicates the identifier of the grouping recommendation task.</p>', 'String255List$member' => NULL, 'UnsupportedResource$resourceType' => '<p>The type of resource.</p>', 'UnsupportedResource$unsupportedResourceStatus' => '<p>The status of the unsupported resource.</p>', 'UpdateAppVersionAppComponentRequest$id' => '<p>Identifier of the Application Component.</p>', 'UpdateAppVersionAppComponentRequest$name' => '<p>Name of the Application Component.</p>', 'UpdateAppVersionAppComponentRequest$type' => '<p>Type of Application Component. For more information about the types of Application Component, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a>.</p>', 'UpdateAppVersionResourceRequest$resourceType' => '<p>Type of resource.</p>', 'UpdateRecommendationStatusRequestEntry$entryId' => '<p>An identifier for an entry in this batch that is used to communicate the result.</p> <note> <p>The <code>entryId</code>s of a batch request need to be unique within a request.</p> </note>', ], ], 'String255List' => [ 'base' => NULL, 'refs' => [ 'GroupingRecommendation$recommendationReasons' => '<p>Indicates all the reasons available for rejecting a grouping recommendation.</p>', 'GroupingResource$sourceAppComponentIds' => '<p>Indicates the identifier of the source AppComponents in which the resources were previously grouped into.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$eksSourceNames' => '<p>The names of the Amazon Elastic Kubernetes Service clusters and namespaces you want to remove from the resource mappings.</p> <note> <p>This parameter accepts values in "eks-cluster/namespace" format.</p> </note>', 'RemoveDraftAppVersionResourceMappingsRequest$logicalStackNames' => '<p>The names of the CloudFormation stacks you want to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$terraformSourceNames' => '<p>The names of the Terraform sources you want to remove from the resource mappings.</p>', ], ], 'String500' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AlarmRecommendation$name' => '<p>Name of the alarm recommendation.</p>', 'AlarmRecommendation$prerequisite' => '<p>The prerequisite for the alarm recommendation.</p>', 'AlarmReferenceIdList$member' => NULL, 'AppAssessment$message' => '<p>Error or warning message from the assessment execution</p>', 'AppAssessmentSummary$message' => '<p>Message from the assessment run.</p>', 'AppComponentCompliance$message' => '<p>The compliance message.</p>', 'AssessmentSummary$summary' => '<p>Indicates a concise summary that provides an overview of the Resilience Hub assessment.</p> <note> <p>This property is available only in the US East (N. Virginia) Region.</p> </note>', 'ConflictException$message' => NULL, 'DescribeAppVersionResourcesResolutionStatusResponse$errorMessage' => '<p>The returned error message for the request.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$errorMessage' => '<p>The returned error message for the request.</p>', 'DescribeResourceGroupingRecommendationTaskResponse$errorMessage' => '<p>Indicates the error that occurred while generating a grouping recommendation.</p>', 'DisruptionCompliance$message' => '<p>The disruption compliance message.</p>', 'DisruptionCompliance$rpoDescription' => '<p>The RPO description.</p>', 'DisruptionCompliance$rpoReferenceId' => '<p>Reference identifier of the RPO .</p>', 'DisruptionCompliance$rtoDescription' => '<p>The RTO description.</p>', 'DisruptionCompliance$rtoReferenceId' => '<p>Reference identifier of the RTO.</p>', 'InternalServerException$message' => NULL, 'RecommendationDisruptionCompliance$expectedRpoDescription' => '<p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>', 'RecommendationDisruptionCompliance$expectedRtoDescription' => '<p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>', 'RecommendationItem$resourceId' => '<p>Identifier of the resource.</p>', 'RecommendationTemplate$message' => '<p>Message for the recommendation template.</p>', 'ResourceNotFoundException$message' => NULL, 'S3Location$bucket' => '<p>The name of the Amazon S3 bucket.</p>', 'S3Location$prefix' => '<p>The prefix for the Amazon S3 bucket.</p>', 'ServiceQuotaExceededException$message' => NULL, 'SopRecommendation$description' => '<p>Description of the SOP recommendation.</p>', 'SopRecommendation$prerequisite' => '<p>Prerequisite for the SOP recommendation.</p>', 'StartResourceGroupingRecommendationTaskResponse$errorMessage' => '<p>Indicates the error that occurred while executing a grouping recommendation task.</p>', 'TestRecommendation$description' => '<p>Description for the test recommendation.</p>', 'TestRecommendation$prerequisite' => '<p>Prerequisite of the test recommendation.</p>', 'ThrottlingException$message' => NULL, 'UpdateRecommendationStatusItem$resourceId' => '<p>Resource identifier of the operational recommendation item.</p>', 'ValidationException$message' => NULL, ], ], 'SuggestedChangesList' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$suggestedChanges' => '<p>List of the suggested configuration changes.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags you want to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'App$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'AppAssessment$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateAppRequest$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateRecommendationTemplateRequest$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateResiliencyPolicyRequest$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'ListTagsForResourceResponse$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'RecommendationTemplate$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'ResiliencyPolicy$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'StartAppAssessmentRequest$tags' => '<p>Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'TagResourceRequest$tags' => '<p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TemplateFormat' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$format' => '<p>The format for the recommendation template.</p> <dl> <dt>CfnJson</dt> <dd> <p>The template is CloudFormation JSON.</p> </dd> <dt>CfnYaml</dt> <dd> <p>The template is CloudFormation YAML.</p> </dd> </dl>', 'RecommendationTemplate$format' => '<p>Format of the recommendation template.</p> <dl> <dt>CfnJson</dt> <dd> <p>The template is CloudFormation JSON.</p> </dd> <dt>CfnYaml</dt> <dd> <p>The template is CloudFormation YAML.</p> </dd> </dl>', ], ], 'TerraformSource' => [ 'base' => '<p> The Terraform s3 state file you need to import. </p>', 'refs' => [ 'AppInputSource$terraformSource' => '<p>The name of the Terraform s3 state ﬁle.</p>', 'DeleteAppInputSourceRequest$terraformSource' => '<p>The imported Terraform s3 state ﬁle you want to remove from the Resilience Hub application.</p>', 'TerraformSourceList$member' => NULL, ], ], 'TerraformSourceList' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$terraformSources' => '<p> A list of terraform file s3 URLs you need to import. </p>', 'ImportResourcesToDraftAppVersionResponse$terraformSources' => '<p> A list of terraform file s3 URLs you have imported. </p>', ], ], 'TestRecommendation' => [ 'base' => '<p>Defines a test recommendation.</p>', 'refs' => [ 'TestRecommendationList$member' => NULL, ], ], 'TestRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListTestRecommendationsResponse$testRecommendations' => '<p>The test recommendations for the Resilience Hub application.</p>', ], ], 'TestRisk' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$risk' => '<p>Level of risk for this test recommendation.</p>', ], ], 'TestType' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$type' => '<p>Type of test recommendation.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>This exception occurs when you have exceeded the limit on the number of requests per second.</p>', 'refs' => [], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'App$creationTime' => '<p>Date and time when the app was created.</p>', 'App$lastAppComplianceEvaluationTime' => '<p>Date and time the most recent compliance evaluation.</p>', 'App$lastDriftEvaluationTime' => '<p>Indicates the last time that a drift was evaluated.</p>', 'App$lastResiliencyScoreEvaluationTime' => '<p>Date and time the most recent resiliency score evaluation.</p>', 'AppAssessment$endTime' => '<p>End time for the action.</p>', 'AppAssessment$startTime' => '<p>Starting time for the action.</p>', 'AppAssessmentSummary$endTime' => '<p>End time for the action.</p>', 'AppAssessmentSummary$startTime' => '<p>Starting time for the action.</p>', 'AppSummary$creationTime' => '<p>Date and time when the app was created.</p>', 'AppSummary$lastAppComplianceEvaluationTime' => '<p>Date and time of the most recent compliance evaluation.</p>', 'AppVersionSummary$creationTime' => '<p>Creation time of the application version.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$statusChangeTime' => '<p>The time when the status last changed.</p>', 'GroupingRecommendation$creationTime' => '<p>Indicates the creation time of the grouping recommendation.</p>', 'ListAppVersionsRequest$endTime' => '<p>Upper limit of the time range to filter the application versions.</p>', 'ListAppVersionsRequest$startTime' => '<p>Lower limit of the time range to filter the application versions.</p>', 'ListAppsRequest$fromLastAssessmentTime' => '<p>Indicates the lower limit of the range that is used to filter applications based on their last assessment times.</p>', 'ListAppsRequest$toLastAssessmentTime' => '<p>Indicates the upper limit of the range that is used to filter the applications based on their last assessment times.</p>', 'RecommendationTemplate$endTime' => '<p>The end time for the action.</p>', 'RecommendationTemplate$startTime' => '<p>The start time for the action.</p>', 'ResiliencyPolicy$creationTime' => '<p>Date and time when the resiliency policy was created.</p>', ], ], 'UnsupportedResource' => [ 'base' => '<p>Defines a resource that is not supported by Resilience Hub.</p>', 'refs' => [ 'UnsupportedResourceList$member' => NULL, ], ], 'UnsupportedResourceList' => [ 'base' => NULL, 'refs' => [ 'ListUnsupportedAppVersionResourcesResponse$unsupportedResources' => '<p>The unsupported resources for the application.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionAppComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionAppComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecommendationStatusItem' => [ 'base' => '<p>Defines the operational recommendation item that needs a status update.</p>', 'refs' => [ 'BatchUpdateRecommendationStatusSuccessfulEntry$item' => '<p>The operational recommendation item.</p>', 'UpdateRecommendationStatusRequestEntry$item' => '<p>The operational recommendation item.</p>', ], ], 'UpdateRecommendationStatusRequestEntries' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRecommendationStatusRequest$requestEntries' => '<p>Defines the list of operational recommendations that need to be included or excluded.</p>', ], ], 'UpdateRecommendationStatusRequestEntry' => [ 'base' => '<p>Defines the operational recommendation item that is to be included or excluded.</p>', 'refs' => [ 'UpdateRecommendationStatusRequestEntries$member' => NULL, ], ], 'UpdateResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$recommendationId' => '<p>Identifier of the alarm recommendation.</p>', 'RecommendationIdList$member' => NULL, 'SopRecommendation$recommendationId' => '<p>Identifier for the SOP recommendation.</p>', 'TestRecommendation$recommendationId' => '<p>Identifier for the test recommendation.</p>', ], ], 'ValidationException' => [ 'base' => '<p>This exception occurs when a request is not valid.</p>', 'refs' => [], ], ],];
