<?php
// This file was auto-generated from sdk-root/src/data/s3control/2018-08-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon Web Services S3 Control provides access to Amazon S3 control plane actions. </p>', 'operations' => [ 'AssociateAccessGrantsIdentityCenter' => '<p>Associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance. Use this action if you want to create access grants for users or groups from your corporate identity directory. First, you must add your corporate identity directory to Amazon Web Services IAM Identity Center. Then, you can associate this IAM Identity Center instance with your S3 Access Grants instance.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:AssociateAccessGrantsIdentityCenter</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>You must also have the following permissions: <code>sso:CreateApplication</code>, <code>sso:PutApplicationGrant</code>, and <code>sso:PutApplicationAuthenticationMethod</code>. </p> </dd> </dl>', 'CreateAccessGrant' => '<p>Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html">CreateAccessGrantsInstance</a>. You must also have registered at least one S3 data location in your S3 Access Grants instance using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html">CreateAccessGrantsLocation</a>. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:CreateAccessGrant</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>For any directory identity - <code>sso:DescribeInstance</code> and <code>sso:DescribeApplication</code> </p> <p>For directory users - <code>identitystore:DescribeUser</code> </p> <p>For directory groups - <code>identitystore:DescribeGroup</code> </p> </dd> </dl>', 'CreateAccessGrantsInstance' => '<p>Creates an S3 Access Grants instance, which serves as a logical grouping for access grants. You can create one S3 Access Grants instance per Region per account. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:CreateAccessGrantsInstance</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>To associate an IAM Identity Center instance with your S3 Access Grants instance, you must also have the <code>sso:DescribeInstance</code>, <code>sso:CreateApplication</code>, <code>sso:PutApplicationGrant</code>, and <code>sso:PutApplicationAuthenticationMethod</code> permissions. </p> </dd> </dl>', 'CreateAccessGrantsLocation' => '<p>The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in the same Region as your S3 Access Grants instance. The location can be one of the following: </p> <ul> <li> <p>The default S3 location <code>s3://</code> </p> </li> <li> <p>A bucket - <code>S3://&lt;bucket-name&gt;</code> </p> </li> <li> <p>A bucket and prefix - <code>S3://&lt;bucket-name&gt;/&lt;prefix&gt;</code> </p> </li> </ul> <p>When you register a location, you must include the IAM role that has permission to manage the S3 location that you are registering. Give S3 Access Grants permission to assume this role <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-location.html">using a policy</a>. S3 Access Grants assumes this role to manage access to the location and to vend temporary credentials to grantees or client applications. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:CreateAccessGrantsLocation</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>You must also have the following permission for the specified IAM role: <code>iam:PassRole</code> </p> </dd> </dl>', 'CreateAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Creates an access point and associates it with the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <note> <p>S3 on Outposts only supports VPC-style access points. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points</a> in the <i>Amazon S3 User Guide</i>.</p> </note> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples">Examples</a> section.</p> <p/> <p>The following actions are related to <code>CreateAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'CreateAccessPointForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Creates an Object Lambda Access Point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>CreateAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'CreateBucket' => '<note> <p>This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">Create Bucket</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Working with Amazon S3 Buckets</a>.</p> <p>S3 on Outposts buckets support:</p> <ul> <li> <p>Tags</p> </li> <li> <p>LifecycleConfigurations for deleting expired objects</p> </li> </ul> <p>For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html"> Amazon S3 on Outposts Restrictions and Limitations</a>.</p> <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your API request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples">Examples</a> section.</p> <p>The following actions are related to <code>CreateBucket</code> for Amazon S3 on Outposts:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> </ul>', 'CreateJob' => '<p>This operation creates an S3 Batch Operations job.</p> <p>You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <dl> <dt>Permissions</dt> <dd> <p>For information about permissions required to use the Batch Operations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-iam-role-policies.html">Granting permissions for S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> </dd> </dl> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html">JobOperation</a> </p> </li> </ul>', 'CreateMultiRegionAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html">Creating Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p> <p>The following actions are related to <code>CreateMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'CreateStorageLensGroup' => '<p> Creates a new S3 Storage Lens group and associates it with the specified Amazon Web Services account ID. An S3 Storage Lens group is a custom grouping of objects based on prefix, suffix, object tags, object size, object age, or a combination of these filters. For each Storage Lens group that you’ve created, you can also optionally add Amazon Web Services resource tags. For more information about S3 Storage Lens groups, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html">Working with S3 Storage Lens groups</a>.</p> <p>To use this operation, you must have the permission to perform the <code>s3:CreateStorageLensGroup</code> action. If you’re trying to create a Storage Lens group with Amazon Web Services resource tags, you must also have permission to perform the <code>s3:TagResource</code> action. For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about Storage Lens groups errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3 Storage Lens error codes</a>.</p>', 'DeleteAccessGrant' => '<p>Deletes the access grant from the S3 Access Grants instance. You cannot undo an access grant deletion and the grantee will no longer have access to the S3 data.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:DeleteAccessGrant</code> permission to use this operation. </p> </dd> </dl>', 'DeleteAccessGrantsInstance' => '<p>Deletes your S3 Access Grants instance. You must first delete the access grants and locations before S3 Access Grants can delete the instance. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html">DeleteAccessGrant</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrantsLocation.html">DeleteAccessGrantsLocation</a>. If you have associated an IAM Identity Center instance with your S3 Access Grants instance, you must first dissassociate the Identity Center instance from the S3 Access Grants instance before you can delete the S3 Access Grants instance. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AssociateAccessGrantsIdentityCenter.html">AssociateAccessGrantsIdentityCenter</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DissociateAccessGrantsIdentityCenter.html">DissociateAccessGrantsIdentityCenter</a>.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:DeleteAccessGrantsInstance</code> permission to use this operation. </p> </dd> </dl>', 'DeleteAccessGrantsInstanceResourcePolicy' => '<p>Deletes the resource policy of the S3 Access Grants instance. The resource policy is used to manage cross-account access to your S3 Access Grants instance. By deleting the resource policy, you delete any cross-account permissions to your S3 Access Grants instance. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:DeleteAccessGrantsInstanceResourcePolicy</code> permission to use this operation. </p> </dd> </dl>', 'DeleteAccessGrantsLocation' => '<p>Deregisters a location from your S3 Access Grants instance. You can only delete a location registration from an S3 Access Grants instance if there are no grants associated with this location. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html">Delete a grant</a> for information on how to delete grants. You need to have at least one registered location in your S3 Access Grants instance in order to create access grants. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:DeleteAccessGrantsLocation</code> permission to use this operation. </p> </dd> </dl>', 'DeleteAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes the specified access point.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'DeleteAccessPointForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes the specified Object Lambda Access Point.</p> <p>The following actions are related to <code>DeleteAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'DeleteAccessPointPolicy' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes the access point policy for the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li> </ul>', 'DeleteAccessPointPolicyForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Removes the resource policy for an Object Lambda Access Point.</p> <p>The following actions are related to <code>DeleteAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'DeleteBucket' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples">Examples</a> section.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li> </ul>', 'DeleteBucketLifecycleConfiguration' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket\'s lifecycle configuration. To delete an S3 bucket\'s lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this operation, you must have permission to perform the <code>s3-outposts:PutLifecycleConfiguration</code> action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission to others.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p>For more information about object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> </ul>', 'DeleteBucketPolicy' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html">DeleteBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>s3-outposts:DeleteBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner\'s account to use this action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>If you don\'t have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error. </p> <important> <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>. </p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li> </ul>', 'DeleteBucketReplication' => '<note> <p>This operation deletes an Amazon S3 on Outposts bucket\'s replication configuration. To delete an S3 bucket\'s replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the replication configuration from the specified S3 on Outposts bucket.</p> <p>To use this operation, you must have permissions to perform the <code>s3-outposts:PutReplicationConfiguration</code> action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up IAM with S3 on Outposts</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on Outposts buckets</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that\'s returned by a <code>GET</code> request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than what\'s on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.</p> </note> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html#API_control_DeleteBucketReplication_Examples">Examples</a> section.</p> <p>For information about S3 replication on Outposts configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following operations are related to <code>DeleteBucketReplication</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html">PutBucketReplication</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html">GetBucketReplication</a> </p> </li> </ul>', 'DeleteBucketTagging' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket\'s tags. To delete an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the tags from the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>PutBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others. </p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li> </ul>', 'DeleteJobTagging' => '<p>Removes the entire tag set from the specified S3 Batch Operations job.</p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>DeleteJobTagging</code> operation, you must have permission to perform the <code>s3:DeleteJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li> </ul>', 'DeleteMultiRegionAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p> <p>The following actions are related to <code>DeleteMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'DeletePublicAccessBlock' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li> </ul>', 'DeleteStorageLensConfiguration' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'DeleteStorageLensConfigurationTagging' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'DeleteStorageLensGroup' => '<p> Deletes an existing S3 Storage Lens group.</p> <p>To use this operation, you must have the permission to perform the <code>s3:DeleteStorageLensGroup</code> action. For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about Storage Lens groups errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3 Storage Lens error codes</a>.</p>', 'DescribeJob' => '<p>Retrieves the configuration parameters and status for a Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>DescribeJob</code> operation, you must have permission to perform the <code>s3:DescribeJob</code> action.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'DescribeMultiRegionAccessPointOperation' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MrapOperations.html">Using Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'DissociateAccessGrantsIdentityCenter' => '<p>Dissociates the Amazon Web Services IAM Identity Center instance from the S3 Access Grants instance. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:DissociateAccessGrantsIdentityCenter</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>You must have the <code>sso:DeleteApplication</code> permission to use this operation. </p> </dd> </dl>', 'GetAccessGrant' => '<p>Get the details of an access grant from your S3 Access Grants instance.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetAccessGrant</code> permission to use this operation. </p> </dd> </dl>', 'GetAccessGrantsInstance' => '<p>Retrieves the S3 Access Grants instance for a Region in your account. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetAccessGrantsInstance</code> permission to use this operation. </p> </dd> </dl>', 'GetAccessGrantsInstanceForPrefix' => '<p>Retrieve the S3 Access Grants instance that contains a particular prefix. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetAccessGrantsInstanceForPrefix</code> permission for the caller account to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>The prefix owner account must grant you the following permissions to their S3 Access Grants instance: <code>s3:GetAccessGrantsInstanceForPrefix</code>. </p> </dd> </dl>', 'GetAccessGrantsInstanceResourcePolicy' => '<p>Returns the resource policy of the S3 Access Grants instance. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetAccessGrantsInstanceResourcePolicy</code> permission to use this operation. </p> </dd> </dl>', 'GetAccessGrantsLocation' => '<p>Retrieves the details of a particular location registered in your S3 Access Grants instance. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetAccessGrantsLocation</code> permission to use this operation. </p> </dd> </dl>', 'GetAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns configuration information about the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'GetAccessPointConfigurationForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns configuration for an Object Lambda Access Point.</p> <p>The following actions are related to <code>GetAccessPointConfigurationForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html">PutAccessPointConfigurationForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns configuration information about the specified Object Lambda Access Point</p> <p>The following actions are related to <code>GetAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointPolicy' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns the access point policy associated with the specified access point.</p> <p>The following actions are related to <code>GetAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li> </ul>', 'GetAccessPointPolicyForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns the resource policy for an Object Lambda Access Point.</p> <p>The following actions are related to <code>GetAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointPolicyStatus' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetAccessPointPolicyStatusForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns the status of the resource policy associated with an Object Lambda Access Point.</p>', 'GetBucket' => '<p>Gets an Amazon S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>s3-outposts:GetBucket</code> permissions on the specified Outposts bucket and belong to the Outposts bucket owner\'s account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. </p> <p>If you don\'t have <code>s3-outposts:GetBucket</code> permissions or you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>403 Access Denied</code> error.</p> <p>The following actions are related to <code>GetBucket</code> for Amazon S3 on Outposts:</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples">Examples</a> section.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li> </ul>', 'GetBucketLifecycleConfiguration' => '<note> <p>This action gets an Amazon S3 on Outposts bucket\'s lifecycle configuration. To get an S3 bucket\'s lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the lifecycle configuration information set on the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> and for information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html"> Object Lifecycle Management</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>s3-outposts:GetLifecycleConfiguration</code> action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p> <code>GetBucketLifecycleConfiguration</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p> <ul> <li> <p>Description: The lifecycle configuration does not exist.</p> </li> <li> <p>HTTP Status Code: 404 Not Found</p> </li> <li> <p>SOAP Fault Code Prefix: Client</p> </li> </ul> </li> </ul> <p>The following actions are related to <code>GetBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li> </ul>', 'GetBucketPolicy' => '<note> <p>This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html">GetBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the policy of a specified Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner\'s account in order to use this action.</p> <p>Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. If you don\'t have <code>s3-outposts:GetBucketPolicy</code> permissions or you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>403 Access Denied</code> error.</p> <important> <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li> </ul>', 'GetBucketReplication' => '<note> <p>This operation gets an Amazon S3 on Outposts bucket\'s replication configuration. To get an S3 bucket\'s replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the replication configuration of an S3 on Outposts bucket. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>. For information about S3 replication on Outposts configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that\'s returned by a <code>GET</code> request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than what\'s on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.</p> </note> <p>This action requires permissions for the <code>s3-outposts:GetReplicationConfiguration</code> action. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up IAM with S3 on Outposts</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on Outposts bucket</a> in the <i>Amazon S3 User Guide</i>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html#API_control_GetBucketReplication_Examples">Examples</a> section.</p> <p>If you include the <code>Filter</code> element in a replication configuration, you must also include the <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code> elements. The response also returns those elements.</p> <p>For information about S3 on Outposts replication failure reasons, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes">Replication failure reasons</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following operations are related to <code>GetBucketReplication</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html">PutBucketReplication</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html">DeleteBucketReplication</a> </p> </li> </ul>', 'GetBucketTagging' => '<note> <p>This action gets an Amazon S3 on Outposts bucket\'s tags. To get an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the tag set associated with the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>GetBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p> <p> <code>GetBucketTagging</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchTagSetError</code> </p> <ul> <li> <p>Description: There is no tag set associated with the bucket.</p> </li> </ul> </li> </ul> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li> </ul>', 'GetBucketVersioning' => '<note> <p>This operation returns the versioning state for S3 on Outposts buckets only. To return the versioning state for an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.</p> <p>If you\'ve never set versioning on your bucket, it has no versioning state. In that case, the <code>GetBucketVersioning</code> request does not return a versioning state value.</p> <p>For more information about versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html">Versioning</a> in the <i>Amazon S3 User Guide</i>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html#API_control_GetBucketVersioning_Examples">Examples</a> section.</p> <p>The following operations are related to <code>GetBucketVersioning</code> for S3 on Outposts.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html">PutBucketVersioning</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> </ul>', 'GetDataAccess' => '<p>Returns a temporary access credential from S3 Access Grants to the grantee or client application. The <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html">temporary credential</a> is an Amazon Web Services STS token that grants them access to the S3 data. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:GetDataAccess</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>The IAM role that S3 Access Grants assumes must have the following permissions specified in the trust policy when registering the location: <code>sts:AssumeRole</code>, for directory users or groups <code>sts:SetContext</code>, and for IAM users or roles <code>sts:SetSourceIdentity</code>. </p> </dd> </dl>', 'GetJobTagging' => '<p>Returns the tags on an S3 Batch Operations job. </p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>GetJobTagging</code> operation, you must have permission to perform the <code>s3:GetJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li> </ul>', 'GetMultiRegionAccessPoint' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns configuration information about the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'GetMultiRegionAccessPointPolicy' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns the access control policy of the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li> </ul>', 'GetMultiRegionAccessPointPolicyStatus' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPointPolicyStatus</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li> </ul>', 'GetMultiRegionAccessPointRoutes' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns the routing configuration for a Multi-Region Access Point, indicating which Regions are active or passive.</p> <p>To obtain routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:</p> <ul> <li> <p> <code>us-east-1</code> </p> </li> <li> <p> <code>us-west-2</code> </p> </li> <li> <p> <code>ap-southeast-2</code> </p> </li> <li> <p> <code>ap-northeast-1</code> </p> </li> <li> <p> <code>eu-west-1</code> </p> </li> </ul>', 'GetPublicAccessBlock' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li> </ul>', 'GetStorageLensConfiguration' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Gets the Amazon S3 Storage Lens configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'GetStorageLensConfigurationTagging' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'GetStorageLensGroup' => '<p> Retrieves the Storage Lens group configuration details.</p> <p>To use this operation, you must have the permission to perform the <code>s3:GetStorageLensGroup</code> action. For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about Storage Lens groups errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3 Storage Lens error codes</a>.</p>', 'ListAccessGrants' => '<p>Returns the list of access grants in your S3 Access Grants instance.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:ListAccessGrants</code> permission to use this operation. </p> </dd> </dl>', 'ListAccessGrantsInstances' => '<p>Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your individual access grants. You can only have one S3 Access Grants instance per Region per account.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:ListAccessGrantsInstances</code> permission to use this operation. </p> </dd> </dl>', 'ListAccessGrantsLocations' => '<p>Returns a list of the locations registered in your S3 Access Grants instance.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:ListAccessGrantsLocations</code> permission to use this operation. </p> </dd> </dl>', 'ListAccessPoints' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns a list of the access points that are owned by the current account that\'s associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in <code>maxResults</code>, whichever is less), the response will include a continuation token that you can use to list the additional access points.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>ListAccessPoints</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> </ul>', 'ListAccessPointsForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there are more access points than what can be returned in one call, the response will include a continuation token that you can use to list the additional access points.</p> <p>The following actions are related to <code>ListAccessPointsForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> </ul>', 'ListJobs' => '<p>Lists current S3 Batch Operations jobs as well as the jobs that have ended within the last 90 days for the Amazon Web Services account making the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>ListJobs</code> operation, you must have permission to perform the <code>s3:ListJobs</code> action.</p> </dd> </dl> <p>Related actions include:</p> <p/> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'ListMultiRegionAccessPoints' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>ListMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> </ul>', 'ListRegionalBuckets' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples">Examples</a> section.</p>', 'ListStorageLensConfigurations' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:ListStorageLensConfigurations</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'ListStorageLensGroups' => '<p> Lists all the Storage Lens groups in the specified home Region. </p> <p>To use this operation, you must have the permission to perform the <code>s3:ListStorageLensGroups</code> action. For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about Storage Lens groups errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3 Storage Lens error codes</a>.</p>', 'ListTagsForResource' => '<p>This operation allows you to list all the Amazon Web Services resource tags for a specified resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:ListTagsForResource</code> permission to use this operation. </p> </dd> </dl> <note> <p>This operation is only supported for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a> and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant. </p> </note> <p>For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about S3 Tagging errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon S3 Tagging error codes</a>.</p>', 'PutAccessGrantsInstanceResourcePolicy' => '<p>Updates the resource policy of the S3 Access Grants instance. </p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:PutAccessGrantsInstanceResourcePolicy</code> permission to use this operation. </p> </dd> </dl>', 'PutAccessPointConfigurationForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Replaces configuration for an Object Lambda Access Point.</p> <p>The following actions are related to <code>PutAccessPointConfigurationForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html">GetAccessPointConfigurationForObjectLambda</a> </p> </li> </ul>', 'PutAccessPointPolicy' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li> </ul>', 'PutAccessPointPolicyForObjectLambda' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli">Creating Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>PutAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'PutBucketLifecycleConfiguration' => '<note> <p>This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li> </ul>', 'PutBucketPolicy' => '<note> <p>This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html">PutBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner\'s account in order to use this action.</p> <p>If you don\'t have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important> <p> As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action. </p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li> </ul>', 'PutBucketReplication' => '<note> <p>This action creates an Amazon S3 on Outposts bucket\'s replication configuration. To create an S3 bucket\'s replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Creates a replication configuration or replaces an existing one. For information about S3 replication on Outposts configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration to all S3 on Outposts systems. Therefore, the replication configuration that\'s returned by a <code>GET</code> request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than what\'s on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that Outpost can be significant.</p> </note> <p>Specify the replication configuration in the request body. In the replication configuration, you provide the following information:</p> <ul> <li> <p>The name of the destination bucket or buckets where you want S3 on Outposts to replicate objects</p> </li> <li> <p>The Identity and Access Management (IAM) role that S3 on Outposts can assume to replicate objects on your behalf</p> </li> <li> <p>Other relevant information, such as replication rules</p> </li> </ul> <p>A replication configuration must include at least one rule and can contain a maximum of 100. Each rule identifies a subset of objects to replicate by filtering the objects in the source Outposts bucket. To choose additional subsets of objects to replicate, add a rule for each subset.</p> <p>To specify a subset of the objects in the source Outposts bucket to apply a replication rule to, add the <code>Filter</code> element as a child of the <code>Rule</code> element. You can filter objects based on an object key prefix, one or more object tags, or both. When you add the <code>Filter</code> element in the configuration, you must also add the following elements: <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code>.</p> <p>Using <code>PutBucketReplication</code> on Outposts requires that both the source and destination buckets must have versioning enabled. For information about enabling versioning on a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsManagingVersioning.html">Managing S3 Versioning for your S3 on Outposts bucket</a>.</p> <p>For information about S3 on Outposts replication failure reasons, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes">Replication failure reasons</a> in the <i>Amazon S3 User Guide</i>.</p> <p> <b>Handling Replication of Encrypted Objects</b> </p> <p>Outposts buckets are encrypted at all times. All the objects in the source Outposts bucket are encrypted and can be replicated. Also, all the replicas in the destination Outposts bucket are encrypted with the same encryption key as the objects in the source Outposts bucket.</p> <p> <b>Permissions</b> </p> <p>To create a <code>PutBucketReplication</code> request, you must have <code>s3-outposts:PutReplicationConfiguration</code> permissions for the bucket. The Outposts bucket owner has this permission by default and can grant it to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up IAM with S3 on Outposts</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on Outposts buckets</a>. </p> <note> <p>To perform this operation, the user or role must also have the <code>iam:CreateRole</code> and <code>iam:PassRole</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a user permissions to pass a role to an Amazon Web Services service</a>.</p> </note> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html#API_control_PutBucketReplication_Examples">Examples</a> section.</p> <p>The following operations are related to <code>PutBucketReplication</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html">GetBucketReplication</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html">DeleteBucketReplication</a> </p> </li> </ul>', 'PutBucketTagging' => '<note> <p>This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Sets the tags for an S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and tagging</a>.</p> <note> <p>Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html"> Using cost allocation in Amazon S3 bucket tags</a>.</p> </note> <p>To use this action, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> action. The Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3 resources</a>.</p> <p> <code>PutBucketTagging</code> has the following special errors:</p> <ul> <li> <p>Error code: <code>InvalidTagError</code> </p> <ul> <li> <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html"> User-Defined Tag Restrictions</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html"> Amazon Web Services-Generated Cost Allocation Tag Restrictions</a>.</p> </li> </ul> </li> <li> <p>Error code: <code>MalformedXMLError</code> </p> <ul> <li> <p>Description: The XML provided does not match the schema.</p> </li> </ul> </li> <li> <p>Error code: <code>OperationAbortedError </code> </p> <ul> <li> <p>Description: A conflicting conditional action is currently in progress against this resource. Try again.</p> </li> </ul> </li> <li> <p>Error code: <code>InternalError</code> </p> <ul> <li> <p>Description: The service was unable to apply the provided tag to the bucket.</p> </li> </ul> </li> </ul> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li> </ul>', 'PutBucketVersioning' => '<note> <p>This operation sets the versioning state for S3 on Outposts buckets only. To set the versioning state for an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html">PutBucketVersioning</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Sets the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies of your objects and recover from unintended user actions and application failures.</p> <p>You can set the versioning state to one of the following:</p> <ul> <li> <p> <b>Enabled</b> - Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique version ID.</p> </li> <li> <p> <b>Suspended</b> - Suspends versioning for the objects in the bucket. All objects added to the bucket receive the version ID <code>null</code>.</p> </li> </ul> <p>If you\'ve never set versioning on your bucket, it has no versioning state. In that case, a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html"> GetBucketVersioning</a> request does not return a versioning state value.</p> <p>When you enable S3 Versioning, for each object in your bucket, you have a current version and zero or more noncurrent versions. You can configure your bucket S3 Lifecycle rules to expire noncurrent versions after a specified time period. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsLifecycleManaging.html"> Creating and managing a lifecycle configuration for your S3 on Outposts bucket</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the version-enabled bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html">Versioning</a> in the <i>Amazon S3 User Guide</i>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html#API_control_PutBucketVersioning_Examples">Examples</a> section.</p> <p>The following operations are related to <code>PutBucketVersioning</code> for S3 on Outposts.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html">GetBucketVersioning</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> </ul>', 'PutJobTagging' => '<p>Sets the supplied tag-set on an S3 Batch Operations job.</p> <p>A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>, modify that tag set, and use this operation to replace the tag set with the one you modified. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>. </p> <note> <ul> <li> <p>If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.</p> </li> <li> <p>For deleting existing tags for your Batch Operations job, a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> request is preferred because it achieves the same result without incurring charges.</p> </li> <li> <p>A few things to consider about using tags:</p> <ul> <li> <p>Amazon S3 limits the maximum number of tags to 50 tags per job.</p> </li> <li> <p>You can associate up to 50 tags with a job as long as they have unique tag keys.</p> </li> <li> <p>A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.</p> </li> <li> <p>The key and values are case sensitive.</p> </li> <li> <p>For tagging-related restrictions related to characters and encodings, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p> </li> </ul> </li> </ul> </note> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>PutJobTagging</code> operation, you must have permission to perform the <code>s3:PutJobTagging</code> action.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li> </ul>', 'PutMultiRegionAccessPointPolicy' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around working with Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>PutMultiRegionAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li> </ul>', 'PutPublicAccessBlock' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For this operation, users must have the <code>s3:PutAccountPublicAccessBlock</code> permission. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li> </ul>', 'PutStorageLensConfiguration' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Working with Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'PutStorageLensConfigurationTagging' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'SubmitMultiRegionAccessPointRoutes' => '<note> <p>This operation is not supported by directory buckets.</p> </note> <p>Submits an updated route configuration for a Multi-Region Access Point. This API operation updates the routing status for the specified Regions from active to passive, or from passive to active. A value of <code>0</code> indicates a passive status, which means that traffic won\'t be routed to the specified Region. A value of <code>100</code> indicates an active status, which means that traffic will be routed to the specified Region. At least one Region must be active at all times.</p> <p>When the routing configuration is changed, any in-progress operations (uploads, copies, deletes, and so on) to formerly active Regions will continue to run to their final completion state (success or failure). The routing configurations of any Regions that aren’t specified remain unchanged.</p> <note> <p>Updated routing configurations might not be immediately applied. It can take up to 2 minutes for your changes to take effect.</p> </note> <p>To submit routing control changes and failover requests, use the Amazon S3 failover control infrastructure endpoints in these five Amazon Web Services Regions:</p> <ul> <li> <p> <code>us-east-1</code> </p> </li> <li> <p> <code>us-west-2</code> </p> </li> <li> <p> <code>ap-southeast-2</code> </p> </li> <li> <p> <code>ap-northeast-1</code> </p> </li> <li> <p> <code>eu-west-1</code> </p> </li> </ul>', 'TagResource' => '<p> Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource. </p> <note> <p>This operation is only supported for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a> and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant. </p> </note> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:TagResource</code> permission to use this operation. </p> </dd> </dl> <p>For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about S3 Tagging errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon S3 Tagging error codes</a>.</p>', 'UntagResource' => '<p> This operation removes the specified Amazon Web Services resource tags from an S3 resource. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. </p> <note> <p>This operation is only supported for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a> and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant. </p> </note> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:UntagResource</code> permission to use this operation. </p> </dd> </dl> <p>For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about S3 Tagging errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon S3 Tagging error codes</a>.</p>', 'UpdateAccessGrantsLocation' => '<p>Updates the IAM role of a registered location in your S3 Access Grants instance.</p> <dl> <dt>Permissions</dt> <dd> <p>You must have the <code>s3:UpdateAccessGrantsLocation</code> permission to use this operation. </p> </dd> <dt>Additional Permissions</dt> <dd> <p>You must also have the following permission: <code>iam:PassRole</code> </p> </dd> </dl>', 'UpdateJobPriority' => '<p>Updates an existing S3 Batch Operations job\'s priority. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>UpdateJobPriority</code> operation, you must have permission to perform the <code>s3:UpdateJobPriority</code> action.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'UpdateJobStatus' => '<p>Updates the status for the specified job. Use this operation to confirm that you want to run a job or to cancel an existing job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <dl> <dt>Permissions</dt> <dd> <p>To use the <code>UpdateJobStatus</code> operation, you must have permission to perform the <code>s3:UpdateJobStatus</code> action.</p> </dd> </dl> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'UpdateStorageLensGroup' => '<p> Updates the existing Storage Lens group.</p> <p>To use this operation, you must have the permission to perform the <code>s3:UpdateStorageLensGroup</code> action. For more information about the required Storage Lens Groups permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions">Setting account permissions to use S3 Storage Lens groups</a>.</p> <p>For information about Storage Lens groups errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3 Storage Lens error codes</a>.</p>', ], 'shapes' => [ 'AbortIncompleteMultipartUpload' => [ 'base' => '<p>The container for abort incomplete multipart upload</p>', 'refs' => [ 'LifecycleRule$AbortIncompleteMultipartUpload' => '<p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'AccessControlTranslation' => [ 'base' => '<p>A container for information about access control for replicas.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'Destination$AccessControlTranslation' => '<p>Specify this property only in a cross-account scenario (where the source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this property is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'AccessGrantArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantResult$AccessGrantArn' => '<p>The Amazon Resource Name (ARN) of the access grant. </p>', 'GetAccessGrantResult$AccessGrantArn' => '<p>The Amazon Resource Name (ARN) of the access grant. </p>', 'ListAccessGrantEntry$AccessGrantArn' => '<p>The Amazon Resource Name (ARN) of the access grant. </p>', ], ], 'AccessGrantId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantResult$AccessGrantId' => '<p>The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.</p>', 'DeleteAccessGrantRequest$AccessGrantId' => '<p>The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.</p>', 'GetAccessGrantRequest$AccessGrantId' => '<p>The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.</p>', 'GetAccessGrantResult$AccessGrantId' => '<p>The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.</p>', 'ListAccessGrantEntry$AccessGrantId' => '<p>The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.</p>', ], ], 'AccessGrantsInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantsInstanceResult$AccessGrantsInstanceArn' => '<p>The Amazon Resource Name (ARN) of the S3 Access Grants instance. </p>', 'GetAccessGrantsInstanceForPrefixResult$AccessGrantsInstanceArn' => '<p>The Amazon Resource Name (ARN) of the S3 Access Grants instance. </p>', 'GetAccessGrantsInstanceResult$AccessGrantsInstanceArn' => '<p>The Amazon Resource Name (ARN) of the S3 Access Grants instance. </p>', 'ListAccessGrantsInstanceEntry$AccessGrantsInstanceArn' => '<p>The Amazon Resource Name (ARN) of the S3 Access Grants instance. </p>', ], ], 'AccessGrantsInstanceId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantsInstanceResult$AccessGrantsInstanceId' => '<p>The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants instance per Region per account. </p>', 'GetAccessGrantsInstanceForPrefixResult$AccessGrantsInstanceId' => '<p>The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants instance per Region per account. </p>', 'GetAccessGrantsInstanceResult$AccessGrantsInstanceId' => '<p>The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants instance per Region per account. </p>', 'ListAccessGrantsInstanceEntry$AccessGrantsInstanceId' => '<p>The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants instance per Region per account. </p>', ], ], 'AccessGrantsInstancesList' => [ 'base' => NULL, 'refs' => [ 'ListAccessGrantsInstancesResult$AccessGrantsInstancesList' => '<p>A container for a list of S3 Access Grants instances.</p>', ], ], 'AccessGrantsList' => [ 'base' => NULL, 'refs' => [ 'ListAccessGrantsResult$AccessGrantsList' => '<p>A container for a list of grants in an S3 Access Grants instance.</p>', ], ], 'AccessGrantsLocationArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantsLocationResult$AccessGrantsLocationArn' => '<p>The Amazon Resource Name (ARN) of the location you are registering.</p>', 'GetAccessGrantsLocationResult$AccessGrantsLocationArn' => '<p>The Amazon Resource Name (ARN) of the registered location. </p>', 'ListAccessGrantsLocationsEntry$AccessGrantsLocationArn' => '<p>The Amazon Resource Name (ARN) of the registered location. </p>', 'UpdateAccessGrantsLocationResult$AccessGrantsLocationArn' => '<p>The Amazon Resource Name (ARN) of the registered location that you are updating. </p>', ], ], 'AccessGrantsLocationConfiguration' => [ 'base' => '<p>The configuration options of the S3 Access Grants location. It contains the <code>S3SubPrefix</code> field. The grant scope, the data to which you are granting access, is the result of appending the <code>Subprefix</code> field to the scope of the registered location.</p>', 'refs' => [ 'CreateAccessGrantRequest$AccessGrantsLocationConfiguration' => '<p>The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.</p>', 'CreateAccessGrantResult$AccessGrantsLocationConfiguration' => '<p>The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. </p>', 'GetAccessGrantResult$AccessGrantsLocationConfiguration' => '<p>The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. </p>', 'ListAccessGrantEntry$AccessGrantsLocationConfiguration' => '<p>The configuration options of the grant location. The grant location is the S3 path to the data to which you are granting access. </p>', ], ], 'AccessGrantsLocationId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantRequest$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p> <p>If you are passing the <code>default</code> location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code> field. </p>', 'CreateAccessGrantResult$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'CreateAccessGrantsLocationResult$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'DeleteAccessGrantsLocationRequest$AccessGrantsLocationId' => '<p>The ID of the registered location that you are deregistering from your S3 Access Grants instance. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'GetAccessGrantResult$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'GetAccessGrantsLocationRequest$AccessGrantsLocationId' => '<p>The ID of the registered location that you are retrieving. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'GetAccessGrantsLocationResult$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'ListAccessGrantEntry$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'ListAccessGrantsLocationsEntry$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', 'UpdateAccessGrantsLocationRequest$AccessGrantsLocationId' => '<p>The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p> <p>The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p> <p>If you are passing the <code>default</code> location, you cannot create an access grant for the entire default location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code> field. </p>', 'UpdateAccessGrantsLocationResult$AccessGrantsLocationId' => '<p>The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>', ], ], 'AccessGrantsLocationsList' => [ 'base' => NULL, 'refs' => [ 'ListAccessGrantsLocationsResult$AccessGrantsLocationsList' => '<p>A container for a list of registered locations in an S3 Access Grants instance.</p>', ], ], 'AccessKeyId' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessKeyId' => '<p>The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications. </p>', ], ], 'AccessPoint' => [ 'base' => '<p>An access point used to access a bucket.</p>', 'refs' => [ 'AccessPointList$member' => NULL, ], ], 'AccessPointList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPointsResult$AccessPointList' => '<p>Contains identification and configuration information for one or more access points associated with the specified bucket.</p>', ], ], 'AccessPointName' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Name' => '<p>The name of this access point.</p>', 'CreateAccessPointRequest$Name' => '<p>The name you want to assign to this access point.</p>', 'DeleteAccessPointPolicyRequest$Name' => '<p>The name of the access point whose policy you want to delete.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'DeleteAccessPointRequest$Name' => '<p>The name of the access point you want to delete.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointPolicyRequest$Name' => '<p>The name of the access point whose policy you want to retrieve.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointPolicyStatusRequest$Name' => '<p>The name of the access point whose policy status you want to retrieve.</p>', 'GetAccessPointRequest$Name' => '<p>The name of the access point whose configuration information you want to retrieve.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointResult$Name' => '<p>The name of the specified access point.</p>', 'PutAccessPointPolicyRequest$Name' => '<p>The name of the access point that you want to associate with the specified policy.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$BucketAccountId' => '<p>The Amazon Web Services account ID associated with the S3 bucket associated with this access point.</p>', 'AssociateAccessGrantsIdentityCenterRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'CreateAccessGrantRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'CreateAccessGrantsInstanceRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'CreateAccessGrantsLocationRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'CreateAccessPointForObjectLambdaRequest$AccountId' => '<p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>', 'CreateAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the account that owns the specified access point.</p>', 'CreateAccessPointRequest$BucketAccountId' => '<p>The Amazon Web Services account ID associated with the S3 bucket associated with this access point.</p> <p>For same account access point when your bucket and access point belong to the same account owner, the <code>BucketAccountId</code> is not required. For cross-account access point when your bucket and access point are not in the same account, the <code>BucketAccountId</code> is required. </p>', 'CreateJobRequest$AccountId' => '<p>The Amazon Web Services account ID that creates the job.</p>', 'CreateMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>', 'CreateStorageLensGroupRequest$AccountId' => '<p> The Amazon Web Services account ID that the Storage Lens group is created from and associated with. </p>', 'DeleteAccessGrantRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'DeleteAccessGrantsInstanceRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'DeleteAccessGrantsInstanceResourcePolicyRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'DeleteAccessGrantsLocationRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'DeleteAccessPointForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'DeleteAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'DeleteAccessPointPolicyRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'DeleteAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the account that owns the specified access point.</p>', 'DeleteBucketLifecycleConfigurationRequest$AccountId' => '<p>The account ID of the lifecycle configuration to delete.</p>', 'DeleteBucketPolicyRequest$AccountId' => '<p>The account ID of the Outposts bucket.</p>', 'DeleteBucketReplicationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket to delete the replication configuration for.</p>', 'DeleteBucketRequest$AccountId' => '<p>The account ID that owns the Outposts bucket.</p>', 'DeleteBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>', 'DeleteJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'DeleteMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'DeletePublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>', 'DeleteStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'DeleteStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'DeleteStorageLensGroupRequest$AccountId' => '<p> The Amazon Web Services account ID used to create the Storage Lens group that you\'re trying to delete. </p>', 'DescribeJobRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'DescribeMultiRegionAccessPointOperationRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'Destination$Account' => '<p>The destination bucket owner\'s account ID. </p>', 'DissociateAccessGrantsIdentityCenterRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessGrantRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessGrantsInstanceForPrefixRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessGrantsInstanceRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessGrantsInstanceResourcePolicyRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessGrantsLocationRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetAccessPointConfigurationForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'GetAccessPointPolicyStatusForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyStatusRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'GetAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the account that owns the specified access point.</p>', 'GetAccessPointResult$BucketAccountId' => '<p>The Amazon Web Services account ID associated with the S3 bucket associated with this access point.</p>', 'GetBucketLifecycleConfigurationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketReplicationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketVersioningRequest$AccountId' => '<p>The Amazon Web Services account ID of the S3 on Outposts bucket.</p>', 'GetDataAccessRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'GetJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'GetMultiRegionAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetMultiRegionAccessPointPolicyStatusRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetMultiRegionAccessPointRoutesRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetPublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>', 'GetStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'GetStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'GetStorageLensGroupRequest$AccountId' => '<p> The Amazon Web Services account ID associated with the Storage Lens group that you\'re trying to retrieve the details for. </p>', 'ListAccessGrantsInstancesRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'ListAccessGrantsLocationsRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'ListAccessGrantsRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'ListAccessPointsForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'ListAccessPointsRequest$AccountId' => '<p>The Amazon Web Services account ID for the account that owns the specified access points.</p>', 'ListJobsRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'ListMultiRegionAccessPointsRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'ListRegionalBucketsRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'ListStorageLensConfigurationsRequest$AccountId' => '<p>The account ID of the requester.</p>', 'ListStorageLensGroupsRequest$AccountId' => '<p> The Amazon Web Services account ID that owns the Storage Lens groups. </p>', 'ListTagsForResourceRequest$AccountId' => '<p> The Amazon Web Services account ID of the resource owner. </p>', 'PutAccessGrantsInstanceResourcePolicyRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'PutAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>', 'PutBucketLifecycleConfigurationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketReplicationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketVersioningRequest$AccountId' => '<p>The Amazon Web Services account ID of the S3 on Outposts bucket.</p>', 'PutJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'PutMultiRegionAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'PutPublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>', 'PutStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'PutStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'Region$BucketAccountId' => '<p>The Amazon Web Services account ID that owns the Amazon S3 bucket that\'s associated with this Multi-Region Access Point.</p>', 'RegionReport$BucketAccountId' => '<p>The Amazon Web Services account ID that owns the Amazon S3 bucket that\'s associated with this Multi-Region Access Point.</p>', 'S3BucketDestination$AccountId' => '<p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>', 'S3JobManifestGenerator$ExpectedBucketOwner' => '<p>The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket\'s owner Amazon Web Services account ID must match this value, else the job fails.</p>', 'S3ManifestOutputLocation$ExpectedManifestBucketOwner' => '<p>The Account ID that owns the bucket the generated manifest is written to.</p>', 'SubmitMultiRegionAccessPointRoutesRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'TagResourceRequest$AccountId' => '<p> The Amazon Web Services account ID that created the S3 resource that you\'re trying to add tags to or the requester\'s account ID. </p>', 'UntagResourceRequest$AccountId' => '<p> The Amazon Web Services account ID that owns the resource that you\'re trying to remove the tags from. </p>', 'UpdateAccessGrantsLocationRequest$AccountId' => '<p>The ID of the Amazon Web Services account that is making this request.</p>', 'UpdateJobPriorityRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'UpdateJobStatusRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'UpdateStorageLensGroupRequest$AccountId' => '<p> The Amazon Web Services account ID of the Storage Lens group owner. </p>', ], ], 'AccountLevel' => [ 'base' => '<p>A container element for the account-level Amazon S3 Storage Lens configuration.</p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'StorageLensConfiguration$AccountLevel' => '<p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>', ], ], 'ActivityMetrics' => [ 'base' => '<p>The container element for Amazon S3 Storage Lens activity metrics. Activity metrics show details about how your storage is requested, such as requests (for example, All requests, Get requests, Put requests), bytes uploaded or downloaded, and errors.</p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'AccountLevel$ActivityMetrics' => '<p>A container element for S3 Storage Lens activity metrics.</p>', 'BucketLevel$ActivityMetrics' => '<p>A container for the bucket-level activity metrics for S3 Storage Lens.</p>', ], ], 'AdvancedCostOptimizationMetrics' => [ 'base' => '<p>The container element for Amazon S3 Storage Lens advanced cost-optimization metrics. Advanced cost-optimization metrics provide insights that you can use to manage and optimize your storage costs, for example, lifecycle rule counts for transitions, expirations, and incomplete multipart uploads.</p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'AccountLevel$AdvancedCostOptimizationMetrics' => '<p>A container element for S3 Storage Lens advanced cost-optimization metrics.</p>', 'BucketLevel$AdvancedCostOptimizationMetrics' => '<p>A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.</p>', ], ], 'AdvancedDataProtectionMetrics' => [ 'base' => '<p>The container element for Amazon S3 Storage Lens advanced data-protection metrics. Advanced data-protection metrics provide insights that you can use to perform audits and protect your data, for example replication rule counts within and across Regions.</p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'AccountLevel$AdvancedDataProtectionMetrics' => '<p>A container element for S3 Storage Lens advanced data-protection metrics.</p>', 'BucketLevel$AdvancedDataProtectionMetrics' => '<p>A container for bucket-level advanced data-protection metrics for S3 Storage Lens.</p>', ], ], 'Alias' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Alias' => '<p>The name or alias of the access point.</p>', 'CreateAccessPointResult$Alias' => '<p>The name or alias of the access point.</p>', 'GetAccessPointResult$Alias' => '<p>The name or alias of the access point.</p>', ], ], 'AssociateAccessGrantsIdentityCenterRequest' => [ 'base' => NULL, 'refs' => [], ], 'AsyncCreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$CreationTime' => '<p>The time that the request was sent to the service.</p>', ], ], 'AsyncErrorDetails' => [ 'base' => '<p>Error details for the failed asynchronous operation.</p>', 'refs' => [ 'AsyncResponseDetails$ErrorDetails' => '<p>Error details for an asynchronous request.</p>', ], ], 'AsyncOperation' => [ 'base' => '<p>A container for the information about an asynchronous operation.</p>', 'refs' => [ 'DescribeMultiRegionAccessPointOperationResult$AsyncOperation' => '<p>A container element containing the details of the asynchronous operation.</p>', ], ], 'AsyncOperationName' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$Operation' => '<p>The specific operation for the asynchronous request.</p>', ], ], 'AsyncRequestParameters' => [ 'base' => '<p>A container for the request parameters associated with an asynchronous request.</p>', 'refs' => [ 'AsyncOperation$RequestParameters' => '<p>The parameters associated with the request.</p>', ], ], 'AsyncRequestStatus' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$RequestStatus' => '<p>The current status of the request.</p>', 'MultiRegionAccessPointRegionalResponse$RequestStatus' => '<p>The current status of the Multi-Region Access Point in this Region.</p>', ], ], 'AsyncRequestTokenARN' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$RequestTokenARN' => '<p>The request token associated with the request.</p>', 'CreateMultiRegionAccessPointResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', 'DeleteMultiRegionAccessPointResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', 'DescribeMultiRegionAccessPointOperationRequest$RequestTokenARN' => '<p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>', 'PutMultiRegionAccessPointPolicyResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', ], ], 'AsyncResponseDetails' => [ 'base' => '<p>A container for the response details that are returned when querying about an asynchronous request.</p>', 'refs' => [ 'AsyncOperation$ResponseDetails' => '<p>The details of the response.</p>', ], ], 'AwsLambdaTransformation' => [ 'base' => '<p>Lambda function used to transform objects through an Object Lambda Access Point.</p>', 'refs' => [ 'ObjectLambdaContentTransformation$AwsLambda' => '<p>A container for an Lambda function.</p>', ], ], 'AwsLambdaTransformationPayload' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaTransformation$FunctionPayload' => '<p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>', ], ], 'AwsOrgArn' => [ 'base' => NULL, 'refs' => [ 'StorageLensAwsOrg$Arn' => '<p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>', ], ], 'BadRequestException' => [ 'base' => '<p/>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$EligibleForReplication' => '<p>Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.</p>', 'JobReport$Enabled' => '<p>Indicates whether the specified job will generate a job-completion report.</p>', 'ObjectLambdaConfiguration$CloudWatchMetricsEnabled' => '<p>A container for whether the CloudWatch metrics configuration is enabled.</p>', 'S3CopyObjectOperation$RequesterPays' => '<p/> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'S3CopyObjectOperation$BucketKeyEnabled' => '<p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p> <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'S3JobManifestGenerator$EnableManifestOutput' => '<p>Determines whether or not to write the job\'s generated manifest to a bucket.</p>', 'S3ObjectMetadata$RequesterCharged' => '<p> <i>This member has been deprecated.</i> </p> <p/>', 'S3SetObjectRetentionOperation$BypassGovernanceRetention' => '<p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>', ], ], 'BucketAlreadyExists' => [ 'base' => '<p>The requested Outposts bucket name is not available. The bucket namespace is shared by all users of the Outposts in this Region. Select a different name and try again.</p>', 'refs' => [], ], 'BucketAlreadyOwnedByYou' => [ 'base' => '<p>The Outposts bucket you tried to create already exists, and you own it. </p>', 'refs' => [], ], 'BucketCannedACL' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ACL' => '<p>The canned ACL to apply to the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'BucketIdentifierString' => [ 'base' => NULL, 'refs' => [ 'Destination$Bucket' => '<p>The Amazon Resource Name (ARN) of the access point for the destination bucket where you want S3 on Outposts to store the replication results.</p>', 'ReplicationRule$Bucket' => '<p>The Amazon Resource Name (ARN) of the access point for the source Outposts bucket that you want S3 on Outposts to replicate the objects from.</p>', ], ], 'BucketLevel' => [ 'base' => '<p>A container for the bucket-level configuration for Amazon S3 Storage Lens.</p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'AccountLevel$BucketLevel' => '<p>A container element for the S3 Storage Lens bucket-level configuration.</p>', ], ], 'BucketLocationConstraint' => [ 'base' => NULL, 'refs' => [ 'CreateBucketConfiguration$LocationConstraint' => '<p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Bucket' => '<p>The name of the bucket associated with this access point.</p>', 'CreateAccessPointRequest$Bucket' => '<p>The name of the bucket that you want to associate this access point with.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'CreateBucketRequest$Bucket' => '<p>The name of the bucket.</p>', 'DeleteBucketLifecycleConfigurationRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketReplicationRequest$Bucket' => '<p>Specifies the S3 on Outposts bucket to delete the replication configuration for.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketRequest$Bucket' => '<p>Specifies the bucket being deleted.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketTaggingRequest$Bucket' => '<p>The bucket ARN that has the tag set to be removed.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetAccessPointResult$Bucket' => '<p>The name of the bucket associated with the specified access point.</p>', 'GetBucketLifecycleConfigurationRequest$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketReplicationRequest$Bucket' => '<p>Specifies the bucket to get the replication information for.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketResult$Bucket' => '<p>The Outposts bucket requested.</p>', 'GetBucketTaggingRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketVersioningRequest$Bucket' => '<p>The S3 on Outposts bucket to return the versioning state for.</p>', 'ListAccessPointsRequest$Bucket' => '<p>The name of the bucket whose associated access points you want to list.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'MultiRegionAccessPointRoute$Bucket' => '<p>The name of the Amazon S3 bucket for which you\'ll submit a routing configuration change. Either the <code>Bucket</code> or the <code>Region</code> value must be provided. If both are provided, the bucket must be in the specified Region.</p>', 'PutBucketLifecycleConfigurationRequest$Bucket' => '<p>The name of the bucket for which to set the configuration.</p>', 'PutBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'PutBucketReplicationRequest$Bucket' => '<p>Specifies the S3 on Outposts bucket to set the configuration for.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'PutBucketTaggingRequest$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'PutBucketVersioningRequest$Bucket' => '<p>The S3 on Outposts bucket to set the versioning state for.</p>', 'Region$Bucket' => '<p>The name of the associated bucket for the Region.</p>', 'RegionReport$Bucket' => '<p>The name of the bucket.</p>', 'RegionalBucket$Bucket' => '<p/>', ], ], 'BucketVersioningStatus' => [ 'base' => NULL, 'refs' => [ 'GetBucketVersioningResult$Status' => '<p>The versioning state of the S3 on Outposts bucket.</p>', 'VersioningConfiguration$Status' => '<p>Sets the versioning state of the S3 on Outposts bucket.</p>', ], ], 'Buckets' => [ 'base' => NULL, 'refs' => [ 'Exclude$Buckets' => '<p>A container for the S3 Storage Lens bucket excludes.</p>', 'Include$Buckets' => '<p>A container for the S3 Storage Lens bucket includes.</p>', ], ], 'CloudWatchMetrics' => [ 'base' => '<p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p> <p>For more information about publishing S3 Storage Lens metrics to CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html">Monitor S3 Storage Lens metrics in CloudWatch</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'StorageLensDataExport$CloudWatchMetrics' => '<p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>', ], ], 'ConfigId' => [ 'base' => NULL, 'refs' => [ 'DeleteStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'DeleteStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'GetStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the Amazon S3 Storage Lens configuration.</p>', 'GetStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the Amazon S3 Storage Lens configuration.</p>', 'ListStorageLensConfigurationEntry$Id' => '<p>A container for the S3 Storage Lens configuration ID.</p>', 'PutStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'PutStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'StorageLensConfiguration$Id' => '<p>A container for the Amazon S3 Storage Lens configuration ID.</p>', ], ], 'ConfirmRemoveSelfBucketAccess' => [ 'base' => NULL, 'refs' => [ 'PutBucketPolicyRequest$ConfirmRemoveSelfBucketAccess' => '<p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'ConfirmationRequired' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$ConfirmationRequired' => '<p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>', 'JobDescriptor$ConfirmationRequired' => '<p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>', ], ], 'ContinuationToken' => [ 'base' => NULL, 'refs' => [ 'ListAccessGrantsInstancesRequest$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants Instances</code> request in order to retrieve the next page of results.</p>', 'ListAccessGrantsInstancesResult$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants Instances</code> request in order to retrieve the next page of results.</p>', 'ListAccessGrantsLocationsRequest$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants Locations</code> request in order to retrieve the next page of results.</p>', 'ListAccessGrantsLocationsResult$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants Locations</code> request in order to retrieve the next page of results.</p>', 'ListAccessGrantsRequest$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants</code> request in order to retrieve the next page of results.</p>', 'ListAccessGrantsResult$NextToken' => '<p>A pagination token to request the next page of results. Pass this value into a subsequent <code>List Access Grants</code> request in order to retrieve the next page of results.</p>', 'ListStorageLensConfigurationsRequest$NextToken' => '<p>A pagination token to request the next page of results.</p>', 'ListStorageLensConfigurationsResult$NextToken' => '<p>If the request produced more than the maximum number of S3 Storage Lens configuration results, you can pass this value into a subsequent request to retrieve the next page of results.</p>', 'ListStorageLensGroupsRequest$NextToken' => '<p>The token for the next set of results, or <code>null</code> if there are no more results. </p>', 'ListStorageLensGroupsResult$NextToken' => '<p> If <code>NextToken</code> is returned, there are more Storage Lens groups results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', ], ], 'CreateAccessGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessGrantResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessGrantsInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessGrantsInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessGrantsLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessGrantsLocationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateBucketConfiguration' => [ 'base' => '<p>The container for the bucket configuration.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'CreateBucketRequest$CreateBucketConfiguration' => '<p>The configuration information for the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'CreateBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBucketResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiRegionAccessPointInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request. </p>', 'refs' => [ 'AsyncRequestParameters$CreateMultiRegionAccessPointRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>', 'CreateMultiRegionAccessPointRequest$Details' => '<p>A container element containing details about the Multi-Region Access Point.</p>', ], ], 'CreateMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageLensGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointForObjectLambdaResult$CreationDate' => '<p>The date and time when the specified Object Lambda Access Point was created.</p>', 'GetAccessPointResult$CreationDate' => '<p>The date and time when the specified access point was created.</p>', 'GetBucketResult$CreationDate' => '<p>The creation date of the Outposts bucket.</p>', 'RegionalBucket$CreationDate' => '<p>The creation date of the regional bucket</p>', ], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantResult$CreatedAt' => '<p>The date and time when you created the access grant. </p>', 'CreateAccessGrantsInstanceResult$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance. </p>', 'CreateAccessGrantsLocationResult$CreatedAt' => '<p>The date and time when you registered the location. </p>', 'GetAccessGrantResult$CreatedAt' => '<p>The date and time when you created the access grant. </p>', 'GetAccessGrantsInstanceResourcePolicyResult$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance resource policy. </p>', 'GetAccessGrantsInstanceResult$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance. </p>', 'GetAccessGrantsLocationResult$CreatedAt' => '<p>The date and time when you registered the location. </p>', 'ListAccessGrantEntry$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance. </p>', 'ListAccessGrantsInstanceEntry$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance. </p>', 'ListAccessGrantsLocationsEntry$CreatedAt' => '<p>The date and time when you registered the location. </p>', 'MultiRegionAccessPointReport$CreatedAt' => '<p>When the Multi-Region Access Point create request was received.</p>', 'PutAccessGrantsInstanceResourcePolicyResult$CreatedAt' => '<p>The date and time when you created the S3 Access Grants instance resource policy. </p>', 'UpdateAccessGrantsLocationResult$CreatedAt' => '<p>The date and time when you registered the location. </p>', ], ], 'Credentials' => [ 'base' => '<p>The Amazon Web Services Security Token Service temporary credential that S3 Access Grants vends to grantees and client applications. </p>', 'refs' => [ 'GetDataAccessResult$Credentials' => '<p>The temporary credential token that S3 Access Grants vends.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$Date' => '<p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>', 'Transition$Date' => '<p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>', ], ], 'Days' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$Days' => '<p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>', 'NoncurrentVersionExpiration$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>', 'NoncurrentVersionTransition$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>', 'Transition$Days' => '<p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>', ], ], 'DaysAfterInitiation' => [ 'base' => NULL, 'refs' => [ 'AbortIncompleteMultipartUpload$DaysAfterInitiation' => '<p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>', ], ], 'DeleteAccessGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessGrantsInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessGrantsInstanceResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessGrantsLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMarkerReplication' => [ 'base' => '<p>Specifies whether S3 on Outposts replicates delete markers. If you specify a <code>Filter</code> element in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> element\'s <code>Status</code> child element must be set to <code>Disabled</code>, because S3 on Outposts does not support replicating delete markers for tag-based rules.</p> <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated">How delete operations affect replication</a> in the <i>Amazon S3 User Guide</i>. </p>', 'refs' => [ 'ReplicationRule$DeleteMarkerReplication' => '<p>Specifies whether S3 on Outposts replicates delete markers. If you specify a <code>Filter</code> element in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> element\'s <code>Status</code> child element must be set to <code>Disabled</code>, because S3 on Outposts doesn\'t support replicating delete markers for tag-based rules.</p> <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated">How delete operations affect replication</a> in the <i>Amazon S3 User Guide</i>. </p>', ], ], 'DeleteMarkerReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteMarkerReplication$Status' => '<p>Indicates whether to replicate delete markers.</p>', ], ], 'DeleteMultiRegionAccessPointInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>', 'refs' => [ 'AsyncRequestParameters$DeleteMultiRegionAccessPointRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>', 'DeleteMultiRegionAccessPointRequest$Details' => '<p>A container element containing details about the Multi-Region Access Point.</p>', ], ], 'DeleteMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMultiRegionAccessPointOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMultiRegionAccessPointOperationResult' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Specifies information about the replication destination bucket and its settings for an S3 on Outposts replication configuration.</p>', 'refs' => [ 'ReplicationRule$Destination' => '<p>A container for information about the replication destination and its configurations.</p>', ], ], 'DetailedStatusCodesMetrics' => [ 'base' => '<p>The container element for Amazon S3 Storage Lens detailed status code metrics. Detailed status code metrics generate metrics for HTTP status codes, such as <code>200 OK</code>, <code>403 Forbidden</code>, <code>503 Service Unavailable</code> and others. </p> <p>For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'AccountLevel$DetailedStatusCodesMetrics' => '<p>A container element for detailed status code metrics. </p>', 'BucketLevel$DetailedStatusCodesMetrics' => '<p>A container for bucket-level detailed status code metrics for S3 Storage Lens.</p>', ], ], 'DissociateAccessGrantsIdentityCenterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DurationSeconds' => [ 'base' => NULL, 'refs' => [ 'GetDataAccessRequest$DurationSeconds' => '<p>The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the grantee or client application. The default value is 1 hour, but the grantee can specify a range from 900 seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this maximum, the operation fails. </p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'Destination$EncryptionConfiguration' => '<p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointResult$Endpoints' => '<p>The VPC endpoint for the access point.</p>', ], ], 'EstablishedMultiRegionAccessPointPolicy' => [ 'base' => '<p>The last established access control policy for a Multi-Region Access Point.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'MultiRegionAccessPointPolicyDocument$Established' => '<p>The last established policy for the Multi-Region Access Point.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'IdempotencyException$Message' => NULL, 'InternalServiceException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'JobStatusException$Message' => NULL, 'NotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'TooManyTagsException$Message' => NULL, ], ], 'Exclude' => [ 'base' => '<p>A container for what Amazon S3 Storage Lens will exclude.</p>', 'refs' => [ 'StorageLensConfiguration$Exclude' => '<p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it\'s not empty. </p>', ], ], 'ExistingObjectReplication' => [ 'base' => '<p>An optional configuration to replicate existing source bucket objects. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'ReplicationRule$ExistingObjectReplication' => '<p>An optional configuration to replicate existing source bucket objects. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'ExistingObjectReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ExistingObjectReplication$Status' => '<p>Specifies whether Amazon S3 replicates existing source bucket objects. </p>', ], ], 'Expiration' => [ 'base' => NULL, 'refs' => [ 'Credentials$Expiration' => '<p>The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client applications. </p>', ], ], 'ExpirationStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Status' => '<p>If \'Enabled\', the rule is currently being applied. If \'Disabled\', the rule is not currently being applied.</p>', ], ], 'ExpiredObjectDeleteMarker' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$ExpiredObjectDeleteMarker' => '<p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'S3BucketDestination$Format' => '<p/>', ], ], 'FunctionArnString' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaTransformation$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', 'LambdaInvokeOperation$FunctionArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>', ], ], 'GeneratedManifestEncryption' => [ 'base' => '<p>The encryption configuration to use when storing the generated manifest.</p>', 'refs' => [ 'S3ManifestOutputLocation$ManifestEncryption' => '<p>Specifies what encryption should be used when the generated manifest objects are written.</p>', ], ], 'GeneratedManifestFormat' => [ 'base' => NULL, 'refs' => [ 'S3GeneratedManifestDescriptor$Format' => '<p>The format of the generated manifest.</p>', 'S3ManifestOutputLocation$ManifestFormat' => '<p>The format of the generated manifest.</p>', ], ], 'GetAccessGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceForPrefixRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceForPrefixResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceResourcePolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessGrantsLocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointConfigurationForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointConfigurationForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketReplicationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketVersioningRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketVersioningResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDataAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'GetJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GrantFullControl' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantFullControl' => '<p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantRead' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantRead' => '<p>Allows grantee to list the objects in the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantReadACP' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantReadACP' => '<p>Allows grantee to read the bucket ACL.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantWrite' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantWrite' => '<p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantWriteACP' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'Grantee' => [ 'base' => '<p>The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.</p>', 'refs' => [ 'CreateAccessGrantRequest$Grantee' => '<p>The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.</p>', 'CreateAccessGrantResult$Grantee' => '<p>The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.</p>', 'GetAccessGrantResult$Grantee' => '<p>The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added a corporate directory to Amazon Web Services IAM Identity Center and associated this Identity Center instance with the S3 Access Grants instance, the grantee can also be a corporate directory user or group.</p>', 'ListAccessGrantEntry$Grantee' => '<p>The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.</p>', ], ], 'GranteeIdentifier' => [ 'base' => NULL, 'refs' => [ 'Grantee$GranteeIdentifier' => '<p>The unique identifier of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.</p>', 'ListAccessGrantsRequest$GranteeIdentifier' => '<p>The unique identifer of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web Services IAM Identity Center instance.</p>', ], ], 'GranteeType' => [ 'base' => NULL, 'refs' => [ 'Grantee$GranteeType' => '<p>The type of the grantee to which access has been granted. It can be one of the following values:</p> <ul> <li> <p> <code>IAM</code> - An IAM user or role.</p> </li> <li> <p> <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</p> </li> <li> <p> <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</p> </li> </ul>', 'ListAccessGrantsRequest$GranteeType' => '<p>The type of the grantee to which access has been granted. It can be one of the following values:</p> <ul> <li> <p> <code>IAM</code> - An IAM user or role.</p> </li> <li> <p> <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</p> </li> <li> <p> <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</p> </li> </ul>', ], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantsLocationRequest$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', 'CreateAccessGrantsLocationResult$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', 'CreateJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job\'s action on every object in the manifest.</p>', 'GetAccessGrantsLocationResult$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', 'JobDescriptor$RoleArn' => '<p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>', 'ListAccessGrantsLocationsEntry$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', 'UpdateAccessGrantsLocationRequest$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', 'UpdateAccessGrantsLocationResult$IAMRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role of the registered location. S3 Access Grants assumes this role to manage access to the registered location. </p>', ], ], 'ID' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$ID' => '<p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>', 'ReplicationRule$ID' => '<p>A unique identifier for the rule. The maximum value is 255 characters.</p>', ], ], 'IdempotencyException' => [ 'base' => '<p/>', 'refs' => [], ], 'IdentityCenterApplicationArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantRequest$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If an application ARN is included in the request to create an access grant, the grantee can only access the S3 data through this application. </p>', 'CreateAccessGrantResult$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application. </p>', 'GetAccessGrantResult$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application. </p>', 'ListAccessGrantEntry$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application. </p>', 'ListAccessGrantsRequest$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data through this application. </p>', ], ], 'IdentityCenterArn' => [ 'base' => NULL, 'refs' => [ 'AssociateAccessGrantsIdentityCenterRequest$IdentityCenterArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity directory that you added to the IAM Identity Center. You can use the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.</p>', 'CreateAccessGrantsInstanceRequest$IdentityCenterArn' => '<p>If you would like to associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, use this field to pass the Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity directory that you added to the IAM Identity Center. You can use the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs. </p>', 'CreateAccessGrantsInstanceResult$IdentityCenterArn' => '<p>If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a subresource of the original Identity Center instance passed in the request. S3 Access Grants creates this Identity Center application for this specific S3 Access Grants instance. </p>', 'GetAccessGrantsInstanceResult$IdentityCenterArn' => '<p>If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this field returns the Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance application; a subresource of the original Identity Center instance. S3 Access Grants creates this Identity Center application for the specific S3 Access Grants instance. </p>', 'ListAccessGrantsInstanceEntry$IdentityCenterArn' => '<p>If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a subresource of the original Identity Center instance. S3 Access Grants creates this Identity Center application for the specific S3 Access Grants instance. </p>', ], ], 'Include' => [ 'base' => '<p>A container for what Amazon S3 Storage Lens configuration includes.</p>', 'refs' => [ 'StorageLensConfiguration$Include' => '<p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it\'s not empty. </p>', ], ], 'InternalServiceException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p/>', 'refs' => [], ], 'IsEnabled' => [ 'base' => NULL, 'refs' => [ 'ActivityMetrics$IsEnabled' => '<p>A container that indicates whether activity metrics are enabled.</p>', 'AdvancedCostOptimizationMetrics$IsEnabled' => '<p>A container that indicates whether advanced cost-optimization metrics are enabled.</p>', 'AdvancedDataProtectionMetrics$IsEnabled' => '<p>A container that indicates whether advanced data-protection metrics are enabled.</p>', 'CloudWatchMetrics$IsEnabled' => '<p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>', 'DetailedStatusCodesMetrics$IsEnabled' => '<p>A container that indicates whether detailed status code metrics are enabled.</p>', 'ListStorageLensConfigurationEntry$IsEnabled' => '<p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>', 'PrefixLevelStorageMetrics$IsEnabled' => '<p>A container for whether prefix-level storage metrics are enabled.</p>', 'StorageLensConfiguration$IsEnabled' => '<p>A container for whether the S3 Storage Lens configuration is enabled.</p>', ], ], 'IsPublic' => [ 'base' => NULL, 'refs' => [ 'PolicyStatus$IsPublic' => '<p/>', ], ], 'JobArn' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$JobArn' => '<p>The Amazon Resource Name (ARN) for this job.</p>', ], ], 'JobCreationTime' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$CreationTime' => '<p>A timestamp indicating when this job was created.</p>', 'JobListDescriptor$CreationTime' => '<p>A timestamp indicating when the specified job was created.</p>', ], ], 'JobDescriptor' => [ 'base' => '<p>A container element for the job configuration and status information returned by a <code>Describe Job</code> request.</p>', 'refs' => [ 'DescribeJobResult$Job' => '<p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>', ], ], 'JobFailure' => [ 'base' => '<p>If this job failed, this element indicates why the job failed.</p>', 'refs' => [ 'JobFailureList$member' => NULL, ], ], 'JobFailureCode' => [ 'base' => NULL, 'refs' => [ 'JobFailure$FailureCode' => '<p>The failure code, if any, for the specified job.</p>', ], ], 'JobFailureList' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$FailureReasons' => '<p>If the specified job failed, this field contains information describing the failure.</p>', ], ], 'JobFailureReason' => [ 'base' => NULL, 'refs' => [ 'JobFailure$FailureReason' => '<p>The failure reason, if any, for the specified job.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'CreateJobResult$JobId' => '<p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful <code>Create Job</code> request.</p>', 'DeleteJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>', 'DescribeJobRequest$JobId' => '<p>The ID for the job whose information you want to retrieve.</p>', 'GetJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>', 'JobDescriptor$JobId' => '<p>The ID for the specified job.</p>', 'JobListDescriptor$JobId' => '<p>The ID for the specified job.</p>', 'PutJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>', 'UpdateJobPriorityRequest$JobId' => '<p>The ID for the job whose priority you want to update.</p>', 'UpdateJobPriorityResult$JobId' => '<p>The ID for the job whose priority Amazon S3 updated.</p>', 'UpdateJobStatusRequest$JobId' => '<p>The ID of the job whose status you want to update.</p>', 'UpdateJobStatusResult$JobId' => '<p>The ID for the job whose status was updated.</p>', ], ], 'JobListDescriptor' => [ 'base' => '<p>Contains the configuration and status information for a single job retrieved as part of a job list.</p>', 'refs' => [ 'JobListDescriptorList$member' => NULL, ], ], 'JobListDescriptorList' => [ 'base' => NULL, 'refs' => [ 'ListJobsResult$Jobs' => '<p>The list of current jobs and jobs that have ended within the last 30 days.</p>', ], ], 'JobManifest' => [ 'base' => '<p>Contains the configuration information for a job\'s manifest.</p>', 'refs' => [ 'CreateJobRequest$Manifest' => '<p>Configuration parameters for the manifest.</p>', 'JobDescriptor$Manifest' => '<p>The configuration information for the specified job\'s manifest object.</p>', ], ], 'JobManifestFieldList' => [ 'base' => NULL, 'refs' => [ 'JobManifestSpec$Fields' => '<p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>', ], ], 'JobManifestFieldName' => [ 'base' => NULL, 'refs' => [ 'JobManifestFieldList$member' => NULL, ], ], 'JobManifestFormat' => [ 'base' => NULL, 'refs' => [ 'JobManifestSpec$Format' => '<p>Indicates which of the available formats the specified manifest uses.</p>', ], ], 'JobManifestGenerator' => [ 'base' => '<p>Configures the type of the job\'s ManifestGenerator.</p>', 'refs' => [ 'CreateJobRequest$ManifestGenerator' => '<p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>', 'JobDescriptor$ManifestGenerator' => '<p>The manifest generator that was used to generate a job manifest for this job.</p>', ], ], 'JobManifestGeneratorFilter' => [ 'base' => '<p>The filter used to describe a set of objects for the job\'s manifest.</p>', 'refs' => [ 'S3JobManifestGenerator$Filter' => '<p>Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket should or should not be included in the generated job manifest.</p>', ], ], 'JobManifestLocation' => [ 'base' => '<p>Contains the information required to locate a manifest object. Manifests can\'t be imported from directory buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory buckets</a>.</p>', 'refs' => [ 'JobManifest$Location' => '<p>Contains the information required to locate the specified job\'s manifest. Manifests can\'t be imported from directory buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory buckets</a>.</p>', 'S3GeneratedManifestDescriptor$Location' => NULL, ], ], 'JobManifestSpec' => [ 'base' => '<p>Describes the format of a manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>', 'refs' => [ 'JobManifest$Spec' => '<p>Describes the format of the specified job\'s manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>', ], ], 'JobNumberOfTasksFailed' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$NumberOfTasksFailed' => '<p/>', ], ], 'JobNumberOfTasksSucceeded' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$NumberOfTasksSucceeded' => '<p/>', ], ], 'JobOperation' => [ 'base' => '<p>The operation that you want this job to perform on every object listed in the manifest. For more information about the available operations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'CreateJobRequest$Operation' => '<p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'JobDescriptor$Operation' => '<p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>', ], ], 'JobPriority' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Priority' => '<p>The numerical priority for this job. Higher numbers indicate higher priority.</p>', 'JobDescriptor$Priority' => '<p>The priority of the specified job.</p>', 'JobListDescriptor$Priority' => '<p>The current priority for the specified job.</p>', 'UpdateJobPriorityRequest$Priority' => '<p>The priority you want to assign to this job.</p>', 'UpdateJobPriorityResult$Priority' => '<p>The new priority assigned to the specified job.</p>', ], ], 'JobProgressSummary' => [ 'base' => '<p>Describes the total number of tasks that the specified job has started, the number of tasks that succeeded, and the number of tasks that failed.</p>', 'refs' => [ 'JobDescriptor$ProgressSummary' => '<p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>', 'JobListDescriptor$ProgressSummary' => '<p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>', ], ], 'JobReport' => [ 'base' => '<p>Contains the configuration parameters for a job-completion report.</p>', 'refs' => [ 'CreateJobRequest$Report' => '<p>Configuration parameters for the optional job-completion report.</p>', 'JobDescriptor$Report' => '<p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>', ], ], 'JobReportFormat' => [ 'base' => NULL, 'refs' => [ 'JobReport$Format' => '<p>The format of the specified job-completion report.</p>', ], ], 'JobReportScope' => [ 'base' => NULL, 'refs' => [ 'JobReport$ReportScope' => '<p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$Status' => '<p>The current status of the specified job.</p>', 'JobListDescriptor$Status' => '<p>The specified job\'s current status.</p>', 'JobStatusList$member' => NULL, 'UpdateJobStatusResult$Status' => '<p>The current status for the specified job.</p>', ], ], 'JobStatusException' => [ 'base' => '<p/>', 'refs' => [], ], 'JobStatusList' => [ 'base' => NULL, 'refs' => [ 'ListJobsRequest$JobStatuses' => '<p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>', ], ], 'JobStatusUpdateReason' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$StatusUpdateReason' => '<p>The reason for updating the job.</p>', 'UpdateJobStatusRequest$StatusUpdateReason' => '<p>A description of the reason why you want to change the specified job\'s status. This field can be any string up to the maximum length.</p>', 'UpdateJobStatusResult$StatusUpdateReason' => '<p>The reason that the specified job\'s status was updated.</p>', ], ], 'JobTerminationDate' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$TerminationDate' => '<p>A timestamp indicating when this job terminated. A job\'s termination date is the date and time when it succeeded, failed, or was canceled.</p>', 'JobListDescriptor$TerminationDate' => '<p>A timestamp indicating when the specified job terminated. A job\'s termination date is the date and time when it succeeded, failed, or was canceled.</p>', ], ], 'JobTimeInStateSeconds' => [ 'base' => NULL, 'refs' => [ 'JobTimers$ElapsedTimeInActiveSeconds' => '<p>Indicates the elapsed time in seconds the job has been in the Active job state.</p>', ], ], 'JobTimers' => [ 'base' => '<p>Provides timing details for the job.</p>', 'refs' => [ 'JobProgressSummary$Timers' => '<p>The JobTimers attribute of a job\'s progress summary.</p>', ], ], 'JobTotalNumberOfTasks' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$TotalNumberOfTasks' => '<p/>', ], ], 'KeyNameConstraint' => [ 'base' => '<p>If provided, the generated manifest includes only source bucket objects whose object keys match the string constraints specified for <code>MatchAnyPrefix</code>, <code>MatchAnySuffix</code>, and <code>MatchAnySubstring</code>.</p>', 'refs' => [ 'JobManifestGeneratorFilter$KeyNameConstraint' => '<p>If provided, the generated manifest includes only source bucket objects whose object keys match the string constraints specified for <code>MatchAnyPrefix</code>, <code>MatchAnySuffix</code>, and <code>MatchAnySubstring</code>.</p>', ], ], 'KmsKeyArnString' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$SSEAwsKmsKeyId' => '<p/> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'SSEKMSEncryption$KeyId' => '<p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key to use for encrypting generated manifest objects.</p>', ], ], 'LambdaInvokeOperation' => [ 'base' => '<p>Contains the configuration parameters for a <code>Lambda Invoke</code> operation.</p>', 'refs' => [ 'JobOperation$LambdaInvoke' => '<p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>', ], ], 'LifecycleConfiguration' => [ 'base' => '<p>The container for the Outposts bucket lifecycle configuration.</p>', 'refs' => [ 'PutBucketLifecycleConfigurationRequest$LifecycleConfiguration' => '<p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>', ], ], 'LifecycleExpiration' => [ 'base' => '<p>The container of the Outposts bucket lifecycle expiration.</p>', 'refs' => [ 'LifecycleRule$Expiration' => '<p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>', ], ], 'LifecycleRule' => [ 'base' => '<p>The container for the Outposts bucket lifecycle rule.</p>', 'refs' => [ 'LifecycleRules$member' => NULL, ], ], 'LifecycleRuleAndOperator' => [ 'base' => '<p>The container for the Outposts bucket lifecycle rule and operator.</p>', 'refs' => [ 'LifecycleRuleFilter$And' => '<p>The container for the <code>AND</code> condition for the lifecycle rule.</p>', ], ], 'LifecycleRuleFilter' => [ 'base' => '<p>The container for the filter of the lifecycle rule.</p>', 'refs' => [ 'LifecycleRule$Filter' => '<p>The container for the filter of lifecycle rule.</p>', ], ], 'LifecycleRules' => [ 'base' => NULL, 'refs' => [ 'GetBucketLifecycleConfigurationResult$Rules' => '<p>Container for the lifecycle rule of the Outposts bucket.</p>', 'LifecycleConfiguration$Rules' => '<p>A lifecycle rule for individual objects in an Outposts bucket. </p>', ], ], 'ListAccessGrantEntry' => [ 'base' => '<p>Information about the access grant.</p>', 'refs' => [ 'AccessGrantsList$member' => NULL, ], ], 'ListAccessGrantsInstanceEntry' => [ 'base' => '<p>Information about the S3 Access Grants instance.</p>', 'refs' => [ 'AccessGrantsInstancesList$member' => NULL, ], ], 'ListAccessGrantsInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessGrantsInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessGrantsLocationsEntry' => [ 'base' => '<p>A container for information about the registered location.</p>', 'refs' => [ 'AccessGrantsLocationsList$member' => NULL, ], ], 'ListAccessGrantsLocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessGrantsLocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessGrantsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiRegionAccessPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiRegionAccessPointsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRegionalBucketsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegionalBucketsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensConfigurationEntry' => [ 'base' => '<p>Part of <code>ListStorageLensConfigurationResult</code>. Each entry includes the description of the S3 Storage Lens configuration, its home Region, whether it is enabled, its Amazon Resource Name (ARN), and config ID.</p>', 'refs' => [ 'StorageLensConfigurationList$member' => NULL, ], ], 'ListStorageLensConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensGroupEntry' => [ 'base' => '<p> Each entry contains a Storage Lens group that exists in the specified home Region. </p>', 'refs' => [ 'StorageLensGroupList$member' => NULL, ], ], 'ListStorageLensGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'CreateBucketResult$Location' => '<p>The location of the bucket.</p>', ], ], 'MFA' => [ 'base' => NULL, 'refs' => [ 'PutBucketVersioningRequest$MFA' => '<p>The concatenation of the authentication device\'s serial number, a space, and the value that is displayed on your authentication device.</p>', ], ], 'MFADelete' => [ 'base' => NULL, 'refs' => [ 'VersioningConfiguration$MFADelete' => '<p>Specifies whether MFA delete is enabled or disabled in the bucket versioning configuration for the S3 on Outposts bucket.</p>', ], ], 'MFADeleteStatus' => [ 'base' => NULL, 'refs' => [ 'GetBucketVersioningResult$MFADelete' => '<p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is returned only if the bucket has been configured with MFA delete. If MFA delete has never been configured for the bucket, this element is not returned.</p>', ], ], 'ManifestPrefixString' => [ 'base' => NULL, 'refs' => [ 'S3ManifestOutputLocation$ManifestPrefix' => '<p>Prefix identifying one or more objects to which the manifest applies.</p>', ], ], 'MatchAnyPrefix' => [ 'base' => NULL, 'refs' => [ 'StorageLensGroupAndOperator$MatchAnyPrefix' => '<p> Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed. </p>', 'StorageLensGroupFilter$MatchAnyPrefix' => '<p> Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed. </p>', 'StorageLensGroupOrOperator$MatchAnyPrefix' => '<p> Filters objects that match any of the specified prefixes. </p>', ], ], 'MatchAnySuffix' => [ 'base' => NULL, 'refs' => [ 'StorageLensGroupAndOperator$MatchAnySuffix' => '<p> Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed. </p>', 'StorageLensGroupFilter$MatchAnySuffix' => '<p> Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed. </p>', 'StorageLensGroupOrOperator$MatchAnySuffix' => '<p> Filters objects that match any of the specified suffixes. </p>', ], ], 'MatchAnyTag' => [ 'base' => NULL, 'refs' => [ 'StorageLensGroupAndOperator$MatchAnyTag' => '<p> Contains the list of object tags. At least one object tag must be specified. Up to 10 object tags are allowed. </p>', 'StorageLensGroupFilter$MatchAnyTag' => '<p> Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed. </p>', 'StorageLensGroupOrOperator$MatchAnyTag' => '<p> Filters objects that match any of the specified S3 object tags. </p>', ], ], 'MatchObjectAge' => [ 'base' => '<p> A filter condition that specifies the object age range of included objects in days. Only integers are supported. </p>', 'refs' => [ 'StorageLensGroupAndOperator$MatchObjectAge' => '<p> Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days). </p>', 'StorageLensGroupFilter$MatchObjectAge' => '<p> Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days). </p>', 'StorageLensGroupOrOperator$MatchObjectAge' => '<p> Filters objects that match the specified object age range. </p>', ], ], 'MatchObjectSize' => [ 'base' => '<p> A filter condition that specifies the object size range of included objects in bytes. Only integers are supported. </p>', 'refs' => [ 'StorageLensGroupAndOperator$MatchObjectSize' => '<p> Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes). </p>', 'StorageLensGroupFilter$MatchObjectSize' => '<p> Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes). </p>', 'StorageLensGroupOrOperator$MatchObjectSize' => '<p> Filters objects that match the specified object size range. </p>', ], ], 'MaxLength1024String' => [ 'base' => NULL, 'refs' => [ 'AsyncErrorDetails$Code' => '<p>A string that uniquely identifies the error condition.</p>', 'AsyncErrorDetails$Message' => '<p>A generic description of the error condition in English.</p>', 'AsyncErrorDetails$Resource' => '<p>The identifier of the resource associated with the error.</p>', 'AsyncErrorDetails$RequestId' => '<p>The ID of the request associated with the error.</p>', 'S3UserMetadata$value' => NULL, 'UserArguments$value' => NULL, ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessGrantsInstancesRequest$MaxResults' => '<p>The maximum number of access grants that you would like returned in the <code>List Access Grants</code> response. If the results include the pagination token <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are more results.</p>', 'ListAccessGrantsLocationsRequest$MaxResults' => '<p>The maximum number of access grants that you would like returned in the <code>List Access Grants</code> response. If the results include the pagination token <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are more results.</p>', 'ListAccessGrantsRequest$MaxResults' => '<p>The maximum number of access grants that you would like returned in the <code>List Access Grants</code> response. If the results include the pagination token <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are more results.</p>', 'ListAccessPointsForObjectLambdaRequest$MaxResults' => '<p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>', 'ListAccessPointsRequest$MaxResults' => '<p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>', 'ListJobsRequest$MaxResults' => '<p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>', 'ListMultiRegionAccessPointsRequest$MaxResults' => '<p>Not currently used. Do not use this parameter.</p>', 'ListRegionalBucketsRequest$MaxResults' => '<p/>', ], ], 'Metrics' => [ 'base' => '<p>A container that specifies replication metrics-related settings.</p>', 'refs' => [ 'Destination$Metrics' => '<p> A container that specifies replication metrics-related settings. </p>', ], ], 'MetricsStatus' => [ 'base' => NULL, 'refs' => [ 'Metrics$Status' => '<p>Specifies whether replication metrics are enabled. </p>', ], ], 'MinStorageBytesPercentage' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$MinStorageBytesPercentage' => '<p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note> <p>You must choose a value greater than or equal to <code>1.0</code>.</p> </note>', ], ], 'Minutes' => [ 'base' => NULL, 'refs' => [ 'ReplicationTimeValue$Minutes' => '<p>Contains an integer that specifies the time period in minutes. </p> <p>Valid value: 15</p>', ], ], 'MultiRegionAccessPointAlias' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Alias' => '<p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Rules for naming Amazon S3 Multi-Region Access Points</a>.</p>', ], ], 'MultiRegionAccessPointClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', 'DeleteMultiRegionAccessPointRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', 'PutMultiRegionAccessPointPolicyRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', ], ], 'MultiRegionAccessPointId' => [ 'base' => NULL, 'refs' => [ 'GetMultiRegionAccessPointRoutesRequest$Mrap' => '<p>The Multi-Region Access Point ARN.</p>', 'GetMultiRegionAccessPointRoutesResult$Mrap' => '<p>The Multi-Region Access Point ARN.</p>', 'SubmitMultiRegionAccessPointRoutesRequest$Mrap' => '<p>The Multi-Region Access Point ARN.</p>', ], ], 'MultiRegionAccessPointName' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointInput$Name' => '<p>The name of the Multi-Region Access Point associated with this request.</p>', 'DeleteMultiRegionAccessPointInput$Name' => '<p>The name of the Multi-Region Access Point associated with this request.</p>', 'GetMultiRegionAccessPointPolicyRequest$Name' => '<p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Rules for naming Amazon S3 Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetMultiRegionAccessPointPolicyStatusRequest$Name' => '<p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Rules for naming Amazon S3 Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetMultiRegionAccessPointRequest$Name' => '<p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Rules for naming Amazon S3 Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'MultiRegionAccessPointReport$Name' => '<p>The name of the Multi-Region Access Point.</p>', 'PutMultiRegionAccessPointPolicyInput$Name' => '<p>The name of the Multi-Region Access Point associated with the request.</p>', ], ], 'MultiRegionAccessPointPolicyDocument' => [ 'base' => '<p>The Multi-Region Access Point access control policy.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'GetMultiRegionAccessPointPolicyResult$Policy' => '<p>The policy associated with the specified Multi-Region Access Point.</p>', ], ], 'MultiRegionAccessPointRegionalResponse' => [ 'base' => '<p>Status information for a single Multi-Region Access Point Region.</p>', 'refs' => [ 'MultiRegionAccessPointRegionalResponseList$member' => NULL, ], ], 'MultiRegionAccessPointRegionalResponseList' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointsAsyncResponse$Regions' => '<p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>', ], ], 'MultiRegionAccessPointReport' => [ 'base' => '<p>A collection of statuses for a Multi-Region Access Point in the various Regions it supports.</p>', 'refs' => [ 'GetMultiRegionAccessPointResult$AccessPoint' => '<p>A container element containing the details of the requested Multi-Region Access Point.</p>', 'MultiRegionAccessPointReportList$member' => NULL, ], ], 'MultiRegionAccessPointReportList' => [ 'base' => NULL, 'refs' => [ 'ListMultiRegionAccessPointsResult$AccessPoints' => '<p>The list of Multi-Region Access Points associated with the user.</p>', ], ], 'MultiRegionAccessPointRoute' => [ 'base' => '<p>A structure for a Multi-Region Access Point that indicates where Amazon S3 traffic can be routed. Routes can be either active or passive. Active routes can process Amazon S3 requests through the Multi-Region Access Point, but passive routes are not eligible to process Amazon S3 requests. </p> <p>Each route contains the Amazon S3 bucket name and the Amazon Web Services Region that the bucket is located in. The route also includes the <code>TrafficDialPercentage</code> value, which shows whether the bucket and Region are active (indicated by a value of <code>100</code>) or passive (indicated by a value of <code>0</code>).</p>', 'refs' => [ 'RouteList$member' => NULL, ], ], 'MultiRegionAccessPointStatus' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Status' => '<p>The current status of the Multi-Region Access Point.</p> <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propagating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>', ], ], 'MultiRegionAccessPointsAsyncResponse' => [ 'base' => '<p>The Multi-Region Access Point details that are returned when querying about an asynchronous request.</p>', 'refs' => [ 'AsyncResponseDetails$MultiRegionAccessPointDetails' => '<p>The details for the Multi-Region Access Point.</p>', ], ], 'NetworkOrigin' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$NetworkOrigin' => '<p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn\'t allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>', 'GetAccessPointResult$NetworkOrigin' => '<p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn\'t allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p> <p>This will always be true for an Amazon S3 on Outposts access point</p>', ], ], 'NoSuchPublicAccessBlockConfiguration' => [ 'base' => '<p>Amazon S3 throws this exception if you make a <code>GetPublicAccessBlock</code> request against an account that doesn\'t have a <code>PublicAccessBlockConfiguration</code> set.</p>', 'refs' => [], ], 'NoSuchPublicAccessBlockConfigurationMessage' => [ 'base' => NULL, 'refs' => [ 'NoSuchPublicAccessBlockConfiguration$Message' => NULL, ], ], 'NonEmptyMaxLength1024String' => [ 'base' => NULL, 'refs' => [ 'Endpoints$value' => NULL, 'JobManifestLocation$ETag' => '<p>The ETag for the specified manifest object.</p>', 'ListAccessPointsForObjectLambdaRequest$NextToken' => '<p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListAccessPointsForObjectLambdaResult$NextToken' => '<p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListAccessPointsRequest$NextToken' => '<p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>', 'ListAccessPointsResult$NextToken' => '<p>If the specified bucket has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListMultiRegionAccessPointsRequest$NextToken' => '<p>Not currently used. Do not use this parameter.</p>', 'ListMultiRegionAccessPointsResult$NextToken' => '<p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this action, this field contains a continuation token. You can use this token tin subsequent calls to this action to retrieve additional Multi-Region Access Points.</p>', 'ListRegionalBucketsRequest$NextToken' => '<p/>', 'ListRegionalBucketsResult$NextToken' => '<p> <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>. <code>NextToken</code> is obfuscated and is not a real key.</p>', 'NonEmptyMaxLength1024StringList$member' => NULL, 'S3CopyObjectOperation$TargetKeyPrefix' => '<p>Specifies the folder prefix that you want the objects to be copied into. For example, to copy objects into a folder named <code>Folder1</code> in the destination bucket, set the <code>TargetKeyPrefix</code> property to <code>Folder1</code>.</p>', 'S3Grantee$Identifier' => '<p/>', 'S3Grantee$DisplayName' => '<p/>', 'S3ObjectMetadata$CacheControl' => '<p/>', 'S3ObjectMetadata$ContentDisposition' => '<p/>', 'S3ObjectMetadata$ContentEncoding' => '<p/>', 'S3ObjectMetadata$ContentLanguage' => '<p/>', 'S3ObjectMetadata$ContentMD5' => '<p> <i>This member has been deprecated.</i> </p> <p/>', 'S3ObjectMetadata$ContentType' => '<p/>', 'S3ObjectOwner$ID' => '<p/>', 'S3ObjectOwner$DisplayName' => '<p/>', 'S3UserMetadata$key' => NULL, ], ], 'NonEmptyMaxLength1024StringList' => [ 'base' => NULL, 'refs' => [ 'KeyNameConstraint$MatchAnyPrefix' => '<p>If provided, the generated manifest includes objects where the specified string appears at the start of the object key string.</p>', 'KeyNameConstraint$MatchAnySuffix' => '<p>If provided, the generated manifest includes objects where the specified string appears at the end of the object key string.</p>', 'KeyNameConstraint$MatchAnySubstring' => '<p>If provided, the generated manifest includes objects where the specified string appears anywhere within the object key string.</p>', ], ], 'NonEmptyMaxLength2048String' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$RedirectLocation' => '<p>If the destination bucket is configured as a website, specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object copy is accessed through a website endpoint.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'NonEmptyMaxLength256String' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Description' => '<p>A description for this job. You can use any string within the permitted length. Descriptions don\'t need to be unique and can be used for multiple jobs.</p>', 'JobDescriptor$Description' => '<p>The description for this job, if one was provided in this job\'s <code>Create Job</code> request.</p>', 'JobListDescriptor$Description' => '<p>The user-specified description that was included in the specified job\'s <code>Create Job</code> request.</p>', ], ], 'NonEmptyMaxLength64String' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$OutpostId' => '<p>The ID of the Outposts where the bucket is being created.</p> <note> <p>This ID is required by Amazon S3 on Outposts buckets.</p> </note>', 'CreateJobRequest$ClientRequestToken' => '<p>An idempotency token to ensure that you don\'t accidentally submit the same request twice. You can use any string up to the maximum length.</p>', 'Endpoints$key' => NULL, 'LambdaInvokeOperation$InvocationSchemaVersion' => '<p>Specifies the schema version for the payload that Batch Operations sends when invoking an Lambda function. Version <code>1.0</code> is the default. Version <code>2.0</code> is required when you use Batch Operations to invoke Lambda functions that act on directory buckets, or if you need to specify <code>UserArguments</code>. For more information, see <a href="https://aws.amazon.com/blogs/storage/automate-object-processing-in-amazon-s3-directory-buckets-with-s3-batch-operations-and-aws-lambda/">Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda</a> in the <i>Amazon Web Services Storage Blog</i>.</p> <important> <p>Ensure that your Lambda function code expects <code>InvocationSchemaVersion</code> <b>2.0</b> and uses bucket name rather than bucket ARN. If the <code>InvocationSchemaVersion</code> does not match what your Lambda function expects, your function might not work as expected.</p> </important> <note> <p> <b>Directory buckets</b> - To initiate Amazon Web Services Lambda function to perform custom actions on objects in directory buckets, you must specify <code>2.0</code>.</p> </note>', 'ListRegionalBucketsRequest$OutpostId' => '<p>The ID of the Outposts resource.</p> <note> <p>This ID is required by Amazon S3 on Outposts buckets.</p> </note>', 'RegionalBucket$OutpostId' => '<p>The Outposts ID of the regional bucket.</p>', 'UserArguments$key' => NULL, ], ], 'NoncurrentVersionCount' => [ 'base' => NULL, 'refs' => [ 'NoncurrentVersionExpiration$NewerNoncurrentVersions' => '<p>Specifies how many noncurrent versions S3 on Outposts will retain. If there are this many more recent noncurrent versions, S3 on Outposts will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'NoncurrentVersionExpiration' => [ 'base' => '<p>The container of the noncurrent version expiration.</p>', 'refs' => [ 'LifecycleRule$NoncurrentVersionExpiration' => '<p>The noncurrent version expiration of the lifecycle rule.</p>', ], ], 'NoncurrentVersionTransition' => [ 'base' => '<p>The container for the noncurrent version transition.</p>', 'refs' => [ 'NoncurrentVersionTransitionList$member' => NULL, ], ], 'NoncurrentVersionTransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$NoncurrentVersionTransitions' => '<p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object\'s lifetime. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'NotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'ObjectAgeValue' => [ 'base' => NULL, 'refs' => [ 'MatchObjectAge$DaysGreaterThan' => '<p> Specifies the maximum object age in days. Must be a positive whole number, greater than the minimum object age and less than or equal to 2,147,483,647. </p>', 'MatchObjectAge$DaysLessThan' => '<p> Specifies the minimum object age in days. The value must be a positive whole number, greater than 0 and less than or equal to 2,147,483,647. </p>', ], ], 'ObjectCreationTime' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$CreatedAfter' => '<p>If provided, the generated manifest includes only source bucket objects that were created after this time.</p>', 'JobManifestGeneratorFilter$CreatedBefore' => '<p>If provided, the generated manifest includes only source bucket objects that were created before this time.</p>', ], ], 'ObjectLambdaAccessPoint' => [ 'base' => '<p>An access point with an attached Lambda function used to access transformed data from an Amazon S3 bucket.</p>', 'refs' => [ 'ObjectLambdaAccessPointList$member' => NULL, ], ], 'ObjectLambdaAccessPointAlias' => [ 'base' => '<p>The alias of an Object Lambda Access Point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-use.html#ol-access-points-alias">How to use a bucket-style alias for your S3 bucket Object Lambda Access Point</a>.</p>', 'refs' => [ 'CreateAccessPointForObjectLambdaResult$Alias' => '<p>The alias of the Object Lambda Access Point.</p>', 'GetAccessPointForObjectLambdaResult$Alias' => '<p>The alias of the Object Lambda Access Point.</p>', 'ObjectLambdaAccessPoint$Alias' => '<p>The alias of the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAccessPointAliasStatus' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaAccessPointAlias$Status' => '<p>The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the status is <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready for use.</p>', ], ], 'ObjectLambdaAccessPointAliasValue' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaAccessPointAlias$Value' => '<p>The alias value of the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAccessPointArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointForObjectLambdaResult$ObjectLambdaAccessPointArn' => '<p>Specifies the ARN for the Object Lambda Access Point.</p>', 'ObjectLambdaAccessPoint$ObjectLambdaAccessPointArn' => '<p>Specifies the ARN for the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAccessPointList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPointsForObjectLambdaResult$ObjectLambdaAccessPointList' => '<p>Returns list of Object Lambda Access Points.</p>', ], ], 'ObjectLambdaAccessPointName' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointForObjectLambdaRequest$Name' => '<p>The name you want to assign to this Object Lambda Access Point.</p>', 'DeleteAccessPointForObjectLambdaRequest$Name' => '<p>The name of the access point you want to delete.</p>', 'DeleteAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point you want to delete the policy for.</p>', 'GetAccessPointConfigurationForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point you want to return the configuration for.</p>', 'GetAccessPointForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointForObjectLambdaResult$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointPolicyStatusForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'ObjectLambdaAccessPoint$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAllowedFeature' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaAllowedFeaturesList$member' => NULL, ], ], 'ObjectLambdaAllowedFeaturesList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$AllowedFeatures' => '<p>A container for allowed features. Valid inputs are <code>GetObject-Range</code>, <code>GetObject-PartNumber</code>, <code>HeadObject-Range</code>, and <code>HeadObject-PartNumber</code>.</p>', ], ], 'ObjectLambdaConfiguration' => [ 'base' => '<p>A configuration used when creating an Object Lambda Access Point.</p>', 'refs' => [ 'CreateAccessPointForObjectLambdaRequest$Configuration' => '<p>Object Lambda Access Point configuration as a JSON document.</p>', 'GetAccessPointConfigurationForObjectLambdaResult$Configuration' => '<p>Object Lambda Access Point configuration document.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$Configuration' => '<p>Object Lambda Access Point configuration document.</p>', ], ], 'ObjectLambdaContentTransformation' => [ 'base' => '<p>A container for AwsLambdaTransformation.</p>', 'refs' => [ 'ObjectLambdaTransformationConfiguration$ContentTransformation' => '<p>A container for the content transformation of an Object Lambda Access Point configuration.</p>', ], ], 'ObjectLambdaPolicy' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointPolicyForObjectLambdaResult$Policy' => '<p>Object Lambda Access Point resource policy document.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$Policy' => '<p>Object Lambda Access Point resource policy document.</p>', ], ], 'ObjectLambdaSupportingAccessPointArn' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$SupportingAccessPoint' => '<p>Standard access point associated with the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaTransformationConfiguration' => [ 'base' => '<p>A configuration used when creating an Object Lambda Access Point transformation.</p>', 'refs' => [ 'ObjectLambdaTransformationConfigurationsList$member' => NULL, ], ], 'ObjectLambdaTransformationConfigurationAction' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaTransformationConfigurationActionsList$member' => NULL, ], ], 'ObjectLambdaTransformationConfigurationActionsList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaTransformationConfiguration$Actions' => '<p>A container for the action of an Object Lambda Access Point configuration. Valid inputs are <code>GetObject</code>, <code>ListObjects</code>, <code>HeadObject</code>, and <code>ListObjectsV2</code>.</p>', ], ], 'ObjectLambdaTransformationConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$TransformationConfigurations' => '<p>A container for transformation configurations for an Object Lambda Access Point.</p>', ], ], 'ObjectLockEnabledForBucket' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ObjectLockEnabledForBucket' => '<p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'ObjectSizeGreaterThanBytes' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$ObjectSizeGreaterThanBytes' => '<p>If provided, the generated manifest includes only source bucket objects whose file size is greater than the specified number of bytes.</p>', 'LifecycleRuleAndOperator$ObjectSizeGreaterThan' => '<p>The non-inclusive minimum object size for the lifecycle rule. Setting this property to 7 means the rule applies to objects with a size that is greater than 7. </p>', 'LifecycleRuleFilter$ObjectSizeGreaterThan' => '<p>Minimum object size to which the rule applies.</p>', ], ], 'ObjectSizeLessThanBytes' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$ObjectSizeLessThanBytes' => '<p>If provided, the generated manifest includes only source bucket objects whose file size is less than the specified number of bytes.</p>', 'LifecycleRuleAndOperator$ObjectSizeLessThan' => '<p>The non-inclusive maximum object size for the lifecycle rule. Setting this property to 77 means the rule applies to objects with a size that is less than 77. </p>', 'LifecycleRuleFilter$ObjectSizeLessThan' => '<p>Maximum object size to which the rule applies.</p>', ], ], 'ObjectSizeValue' => [ 'base' => NULL, 'refs' => [ 'MatchObjectSize$BytesGreaterThan' => '<p> Specifies the minimum object size in Bytes. The value must be a positive number, greater than 0 and less than 5 TB. </p>', 'MatchObjectSize$BytesLessThan' => '<p> Specifies the maximum object size in Bytes. The value must be a positive number, greater than the minimum object size and less than 5 TB. </p>', ], ], 'OperationName' => [ 'base' => NULL, 'refs' => [ 'JobListDescriptor$Operation' => '<p>The operation that the specified job is configured to run on every object listed in the manifest.</p>', ], ], 'Organization' => [ 'base' => NULL, 'refs' => [ 'GetAccessGrantsInstanceResourcePolicyResult$Organization' => '<p>The Organization of the resource policy of the S3 Access Grants instance.</p>', 'PutAccessGrantsInstanceResourcePolicyRequest$Organization' => '<p>The Organization of the resource policy of the S3 Access Grants instance.</p>', 'PutAccessGrantsInstanceResourcePolicyResult$Organization' => '<p>The Organization of the resource policy of the S3 Access Grants instance.</p>', ], ], 'OutputSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'S3BucketDestination$OutputSchemaVersion' => '<p>The schema version of the export file.</p>', ], ], 'OwnerOverride' => [ 'base' => NULL, 'refs' => [ 'AccessControlTranslation$Owner' => '<p>Specifies the replica ownership.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantRequest$Permission' => '<p>The type of access that you are granting to your S3 data, which can be set to one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', 'CreateAccessGrantResult$Permission' => '<p>The type of access that you are granting to your S3 data, which can be set to one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', 'GetAccessGrantResult$Permission' => '<p>The type of permission that was granted in the access grant. Can be one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', 'GetDataAccessRequest$Permission' => '<p>The type of permission granted to your S3 data, which can be set to one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', 'ListAccessGrantEntry$Permission' => '<p>The type of access granted to your S3 data, which can be set to one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', 'ListAccessGrantsRequest$Permission' => '<p>The type of permission granted to your S3 data, which can be set to one of the following values:</p> <ul> <li> <p> <code>READ</code> – Grant read-only access to the S3 data.</p> </li> <li> <p> <code>WRITE</code> – Grant write-only access to the S3 data.</p> </li> <li> <p> <code>READWRITE</code> – Grant both read and write access to the S3 data.</p> </li> </ul>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'EstablishedMultiRegionAccessPointPolicy$Policy' => '<p>The details of the last established policy.</p>', 'GetAccessPointPolicyResult$Policy' => '<p>The access point policy associated with the specified access point.</p>', 'GetBucketPolicyResult$Policy' => '<p>The policy of the Outposts bucket.</p>', 'ProposedMultiRegionAccessPointPolicy$Policy' => '<p>The details of the proposed policy.</p>', 'PutAccessPointPolicyRequest$Policy' => '<p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'PutBucketPolicyRequest$Policy' => '<p>The bucket policy as a JSON document.</p>', 'PutMultiRegionAccessPointPolicyInput$Policy' => '<p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'GetAccessGrantsInstanceResourcePolicyResult$Policy' => '<p>The resource policy of the S3 Access Grants instance.</p>', 'PutAccessGrantsInstanceResourcePolicyRequest$Policy' => '<p>The resource policy of the S3 Access Grants instance that you are updating.</p>', 'PutAccessGrantsInstanceResourcePolicyResult$Policy' => '<p>The updated resource policy of the S3 Access Grants instance.</p>', ], ], 'PolicyStatus' => [ 'base' => '<p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>', 'refs' => [ 'GetAccessPointPolicyStatusForObjectLambdaResult$PolicyStatus' => NULL, 'GetAccessPointPolicyStatusResult$PolicyStatus' => '<p>Indicates the current policy status of the specified access point.</p>', 'GetMultiRegionAccessPointPolicyStatusResult$Established' => NULL, ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'LifecycleRuleAndOperator$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p>', 'LifecycleRuleFilter$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p> <important> <p>When you\'re using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.</p> </important>', 'MatchAnyPrefix$member' => NULL, 'ReplicationRule$Prefix' => '<p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in an Outposts bucket, specify an empty string.</p> <important> <p>When you\'re using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.</p> </important>', 'ReplicationRuleAndOperator$Prefix' => '<p>An object key name prefix that identifies the subset of objects that the rule applies to.</p>', 'ReplicationRuleFilter$Prefix' => '<p>An object key name prefix that identifies the subset of objects that the rule applies to.</p> <important> <p>When you\'re using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.</p> </important>', 'S3BucketDestination$Prefix' => '<p>The prefix of the destination bucket where the metrics export will be delivered.</p>', ], ], 'PrefixLevel' => [ 'base' => '<p>A container for the prefix-level configuration.</p>', 'refs' => [ 'BucketLevel$PrefixLevel' => '<p>A container for the prefix-level metrics for S3 Storage Lens. </p>', ], ], 'PrefixLevelStorageMetrics' => [ 'base' => '<p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>', 'refs' => [ 'PrefixLevel$StorageMetrics' => '<p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$Priority' => '<p>The priority indicates which rule has precedence whenever two or more replication rules conflict. S3 on Outposts attempts to replicate objects according to all replication rules. However, if there are two or more rules with the same destination Outposts bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication-between-outposts.html">Creating replication rules on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'Privilege' => [ 'base' => NULL, 'refs' => [ 'GetDataAccessRequest$Privilege' => '<p>The scope of the temporary access credential that S3 Access Grants vends to the grantee or client application. </p> <ul> <li> <p> <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is closest to the target scope.</p> </li> <li> <p> <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested target scope as long as the requested scope is the same as or a subset of the grant scope. </p> </li> </ul>', ], ], 'ProposedMultiRegionAccessPointPolicy' => [ 'base' => '<p>The proposed access control policy for the Multi-Region Access Point.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'MultiRegionAccessPointPolicyDocument$Proposed' => '<p>The proposed policy for the Multi-Region Access Point.</p>', ], ], 'PublicAccessBlockConfiguration' => [ 'base' => '<p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This data type is not supported for Amazon S3 on Outposts.</p>', 'refs' => [ 'CreateAccessPointRequest$PublicAccessBlockConfiguration' => '<p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>', 'CreateMultiRegionAccessPointInput$PublicAccessBlock' => NULL, 'GetAccessPointForObjectLambdaResult$PublicAccessBlockConfiguration' => '<p>Configuration to block all public access. This setting is turned on and can not be edited. </p>', 'GetAccessPointResult$PublicAccessBlockConfiguration' => NULL, 'GetPublicAccessBlockOutput$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>', 'MultiRegionAccessPointReport$PublicAccessBlock' => NULL, 'PutPublicAccessBlockRequest$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>', ], ], 'PublicAccessBlockEnabled' => [ 'base' => NULL, 'refs' => [ 'GetBucketResult$PublicAccessBlockEnabled' => '<p/>', 'RegionalBucket$PublicAccessBlockEnabled' => '<p/>', ], ], 'PutAccessGrantsInstanceResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessGrantsInstanceResourcePolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessPointConfigurationForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketVersioningRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'PutMultiRegionAccessPointPolicyInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>', 'refs' => [ 'AsyncRequestParameters$PutMultiRegionAccessPointPolicyRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>', 'PutMultiRegionAccessPointPolicyRequest$Details' => '<p>A container element containing the details of the policy for the Multi-Region Access Point.</p>', ], ], 'PutMultiRegionAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMultiRegionAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'PutPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => '<p>A Region that supports a Multi-Region Access Point as well as the associated bucket for the Region.</p>', 'refs' => [ 'RegionCreationList$member' => NULL, ], ], 'RegionCreationList' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointInput$Regions' => '<p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>', ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointRegionalResponse$Name' => '<p>The name of the Region in the Multi-Region Access Point.</p>', 'MultiRegionAccessPointRoute$Region' => '<p>The Amazon Web Services Region to which you\'ll be submitting a routing configuration change. Either the <code>Bucket</code> or the <code>Region</code> value must be provided. If both are provided, the bucket must be in the specified Region.</p>', 'RegionReport$Region' => '<p>The name of the Region.</p>', ], ], 'RegionReport' => [ 'base' => '<p>A combination of a bucket and Region that\'s part of a Multi-Region Access Point.</p>', 'refs' => [ 'RegionReportList$member' => NULL, ], ], 'RegionReportList' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Regions' => '<p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>', ], ], 'RegionalBucket' => [ 'base' => '<p>The container for the regional bucket.</p>', 'refs' => [ 'RegionalBucketList$member' => NULL, ], ], 'RegionalBucketList' => [ 'base' => NULL, 'refs' => [ 'ListRegionalBucketsResult$RegionalBucketList' => '<p/>', ], ], 'Regions' => [ 'base' => NULL, 'refs' => [ 'Exclude$Regions' => '<p>A container for the S3 Storage Lens Region excludes.</p>', 'Include$Regions' => '<p>A container for the S3 Storage Lens Region includes.</p>', ], ], 'ReplicaKmsKeyID' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$ReplicaKmsKeyID' => '<p>Specifies the ID of the customer managed KMS key that\'s stored in Key Management Service (KMS) for the destination bucket. This ID is either the Amazon Resource Name (ARN) for the KMS key or the alias ARN for the KMS key. Amazon S3 uses this KMS key to encrypt replica objects. Amazon S3 supports only symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks">Symmetric encryption KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', ], ], 'ReplicaModifications' => [ 'base' => '<p>A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3 on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the replication bidirectional.</p> <p>To replicate object metadata modifications on replicas, you can specify this element and set the <code>Status</code> of this element to <code>Enabled</code>.</p> <note> <p>You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes between the source and the replicas.</p> </note>', 'refs' => [ 'SourceSelectionCriteria$ReplicaModifications' => '<p>A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3 on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the replication bidirectional.</p> <p>To replicate object metadata modifications on replicas, you can specify this element and set the <code>Status</code> of this element to <code>Enabled</code>.</p> <note> <p>You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes between the source and the replicas.</p> </note>', ], ], 'ReplicaModificationsStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicaModifications$Status' => '<p>Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.</p>', ], ], 'ReplicationConfiguration' => [ 'base' => '<p>A container for one or more replication rules. A replication configuration must have at least one rule and you can add up to 100 rules. The maximum size of a replication configuration is 128 KB.</p>', 'refs' => [ 'GetBucketReplicationResult$ReplicationConfiguration' => '<p>A container for one or more replication rules. A replication configuration must have at least one rule and you can add up to 100 rules. The maximum size of a replication configuration is 128 KB.</p>', 'PutBucketReplicationRequest$ReplicationConfiguration' => '<p/>', ], ], 'ReplicationRule' => [ 'base' => '<p>Specifies which S3 on Outposts objects to replicate and where to store the replicas.</p>', 'refs' => [ 'ReplicationRules$member' => NULL, ], ], 'ReplicationRuleAndOperator' => [ 'base' => '<p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. </p> <p>For example:</p> <ul> <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> element. </p> </li> <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> element.</p> </li> </ul>', 'refs' => [ 'ReplicationRuleFilter$And' => '<p>A container for specifying rule filters. The filters determine the subset of objects that the rule applies to. This element is required only if you specify more than one filter. For example: </p> <ul> <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> element.</p> </li> <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> element.</p> </li> </ul>', ], ], 'ReplicationRuleFilter' => [ 'base' => '<p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> element must specify exactly one <code>Prefix</code>, <code>Tag</code>, or <code>And</code> child element.</p>', 'refs' => [ 'ReplicationRule$Filter' => '<p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> element must specify exactly one <code>Prefix</code>, <code>Tag</code>, or <code>And</code> child element.</p>', ], ], 'ReplicationRuleStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$Status' => '<p>Specifies whether the rule is enabled.</p>', ], ], 'ReplicationRules' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$Rules' => '<p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain an array of 100 rules at the most. </p>', ], ], 'ReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationStatusFilterList$member' => NULL, ], ], 'ReplicationStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$ObjectReplicationStatuses' => '<p>If provided, the generated manifest includes only source bucket objects that have one of the specified Replication statuses.</p>', ], ], 'ReplicationStorageClass' => [ 'base' => NULL, 'refs' => [ 'Destination$StorageClass' => '<p> The storage class to use when replicating objects. All objects stored on S3 on Outposts are stored in the <code>OUTPOSTS</code> storage class. S3 on Outposts uses the <code>OUTPOSTS</code> storage class to create the object replicas. </p> <note> <p>Values other than <code>OUTPOSTS</code> aren\'t supported by Amazon S3 on Outposts. </p> </note>', ], ], 'ReplicationTime' => [ 'base' => '<p>A container that specifies S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'Destination$ReplicationTime' => '<p>A container that specifies S3 Replication Time Control (S3 RTC) settings, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'ReplicationTimeStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationTime$Status' => '<p>Specifies whether S3 Replication Time Control (S3 RTC) is enabled. </p>', ], ], 'ReplicationTimeValue' => [ 'base' => '<p>A container that specifies the time value for S3 Replication Time Control (S3 RTC). This value is also used for the replication metrics <code>EventThreshold</code> element. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'Metrics$EventThreshold' => '<p>A container that specifies the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'ReplicationTime$Time' => '<p>A container that specifies the time by which replication should be complete for all objects and operations on objects. </p>', ], ], 'ReportPrefixString' => [ 'base' => NULL, 'refs' => [ 'JobReport$Prefix' => '<p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>&lt;prefix&gt;/job-&lt;job-id&gt;/report.json</code>.</p>', ], ], 'RequestedJobStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateJobStatusRequest$RequestedJobStatus' => '<p>The status that you want to move the specified job to.</p>', ], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$Role' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that S3 on Outposts assumes when replicating objects. For information about S3 replication on Outposts configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-how-setup.html">Setting up replication</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'RouteList' => [ 'base' => NULL, 'refs' => [ 'GetMultiRegionAccessPointRoutesResult$Routes' => '<p>The different routes that make up the route configuration. Active routes return a value of <code>100</code>, and passive routes return a value of <code>0</code>.</p>', 'SubmitMultiRegionAccessPointRoutesRequest$RouteUpdates' => '<p>The different routes that make up the new route configuration. Active routes return a value of <code>100</code>, and passive routes return a value of <code>0</code>.</p>', ], ], 'S3AWSRegion' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationEntry$HomeRegion' => '<p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>', 'ListStorageLensGroupEntry$HomeRegion' => '<p> Contains the Amazon Web Services Region where the Storage Lens group was created. </p>', 'Regions$member' => NULL, ], ], 'S3AccessControlList' => [ 'base' => '<p/>', 'refs' => [ 'S3AccessControlPolicy$AccessControlList' => '<p/>', ], ], 'S3AccessControlPolicy' => [ 'base' => '<p/>', 'refs' => [ 'S3SetObjectAclOperation$AccessControlPolicy' => '<p/>', ], ], 'S3AccessPointArn' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$AccessPointArn' => '<p>The ARN for the access point.</p>', 'CreateAccessPointResult$AccessPointArn' => '<p>The ARN of the access point.</p> <note> <p>This is only supported by Amazon S3 on Outposts.</p> </note>', 'GetAccessPointResult$AccessPointArn' => '<p>The ARN of the access point.</p>', ], ], 'S3BucketArnString' => [ 'base' => NULL, 'refs' => [ 'Buckets$member' => NULL, 'JobReport$Bucket' => '<p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p> <note> <p> <b>Directory buckets</b> - Directory buckets aren\'t supported as a location for Batch Operations to store job completion reports.</p> </note>', 'S3BucketDestination$Arn' => '<p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>', 'S3JobManifestGenerator$SourceBucket' => '<p>The source bucket used by the ManifestGenerator.</p> <note> <p> <b>Directory buckets</b> - Directory buckets aren\'t supported as the source buckets used by <code>S3JobManifestGenerator</code> to generate the job manifest.</p> </note>', 'S3ManifestOutputLocation$Bucket' => '<p>The bucket ARN the generated manifest should be written to.</p> <note> <p> <b>Directory buckets</b> - Directory buckets aren\'t supported as the buckets to store the generated manifest.</p> </note>', ], ], 'S3BucketDestination' => [ 'base' => '<p>A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.</p>', 'refs' => [ 'StorageLensDataExport$S3BucketDestination' => '<p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note> <p>This bucket must be located in the same Region as the storage lens configuration. </p> </note>', ], ], 'S3CannedAccessControlList' => [ 'base' => NULL, 'refs' => [ 'S3AccessControlPolicy$CannedAccessControlList' => '<p/>', 'S3CopyObjectOperation$CannedAccessControlList' => '<p/> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3ChecksumAlgorithm' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ChecksumAlgorithm' => '<p>Indicates the algorithm that you want Amazon S3 to use to create the checksum. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'S3ContentLength' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$ContentLength' => '<p> <i>This member has been deprecated.</i> </p> <p/>', ], ], 'S3CopyObjectOperation' => [ 'base' => '<p>Contains the configuration parameters for a PUT Copy object operation. S3 Batch Operations passes every object to the underlying <code>CopyObject</code> API operation. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html">CopyObject</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectCopy' => '<p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>', ], ], 'S3DeleteObjectTaggingOperation' => [ 'base' => '<p>Contains no configuration parameters because the DELETE Object tagging (<code>DeleteObjectTagging</code>) API operation accepts only the bucket name and key name as parameters, which are defined in the job\'s manifest.</p>', 'refs' => [ 'JobOperation$S3DeleteObjectTagging' => '<p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3ExpirationInDays' => [ 'base' => NULL, 'refs' => [ 'S3InitiateRestoreObjectOperation$ExpirationInDays' => '<p>This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p> <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p> <p>S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>', ], ], 'S3GeneratedManifestDescriptor' => [ 'base' => '<p>Describes the specified job\'s generated manifest. Batch Operations jobs created with a ManifestGenerator populate details of this descriptor after execution of the ManifestGenerator.</p>', 'refs' => [ 'JobDescriptor$GeneratedManifestDescriptor' => '<p>The attribute of the JobDescriptor containing details about the job\'s generated manifest.</p>', ], ], 'S3GlacierJobTier' => [ 'base' => NULL, 'refs' => [ 'S3InitiateRestoreObjectOperation$GlacierJobTier' => '<p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>', ], ], 'S3Grant' => [ 'base' => '<p/>', 'refs' => [ 'S3GrantList$member' => NULL, ], ], 'S3GrantList' => [ 'base' => NULL, 'refs' => [ 'S3AccessControlList$Grants' => '<p/>', 'S3CopyObjectOperation$AccessControlGrants' => '<p/> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3Grantee' => [ 'base' => '<p/>', 'refs' => [ 'S3Grant$Grantee' => '<p/>', ], ], 'S3GranteeTypeIdentifier' => [ 'base' => NULL, 'refs' => [ 'S3Grantee$TypeIdentifier' => '<p/>', ], ], 'S3InitiateRestoreObjectOperation' => [ 'base' => '<p>Contains the configuration parameters for a POST Object restore job. S3 Batch Operations passes every object to the underlying <code>RestoreObject</code> API operation. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request">RestoreObject</a>.</p>', 'refs' => [ 'JobOperation$S3InitiateRestoreObject' => '<p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3JobManifestGenerator' => [ 'base' => '<p>The container for the service that will create the S3 manifest.</p>', 'refs' => [ 'JobManifestGenerator$S3JobManifestGenerator' => '<p>The S3 job ManifestGenerator\'s configuration details.</p>', ], ], 'S3KeyArnString' => [ 'base' => NULL, 'refs' => [ 'JobManifestLocation$ObjectArn' => '<p>The Amazon Resource Name (ARN) for a manifest object.</p> <important> <p>When you\'re using XML requests, you must replace special characters (such as carriage returns) in object keys with their equivalent XML entity codes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.</p> </important>', ], ], 'S3ManifestOutputLocation' => [ 'base' => '<p>Location details for where the generated manifest should be written.</p>', 'refs' => [ 'S3JobManifestGenerator$ManifestOutputLocation' => '<p>Specifies the location the generated manifest will be written to. Manifests can\'t be written to directory buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory buckets</a>.</p>', ], ], 'S3MetadataDirective' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$MetadataDirective' => '<p/>', ], ], 'S3ObjectLockLegalHold' => [ 'base' => '<p>Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch Operations job.</p>', 'refs' => [ 'S3SetObjectLegalHoldOperation$LegalHold' => '<p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectLockLegalHoldStatus' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ObjectLockLegalHoldStatus' => '<p>The legal hold status to be applied to all objects in the Batch Operations job.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'S3ObjectLockLegalHold$Status' => '<p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectLockMode' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ObjectLockMode' => '<p>The retention mode to be applied to all objects in the Batch Operations job.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3ObjectLockRetentionMode' => [ 'base' => NULL, 'refs' => [ 'S3Retention$Mode' => '<p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectMetadata' => [ 'base' => '<p/>', 'refs' => [ 'S3CopyObjectOperation$NewObjectMetadata' => '<p>If you don\'t provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.</p>', ], ], 'S3ObjectOwner' => [ 'base' => '<p/>', 'refs' => [ 'S3AccessControlList$Owner' => '<p/>', ], ], 'S3ObjectVersionId' => [ 'base' => NULL, 'refs' => [ 'JobManifestLocation$ObjectVersionId' => '<p>The optional version ID to identify a specific version of the manifest object.</p>', ], ], 'S3Permission' => [ 'base' => NULL, 'refs' => [ 'S3Grant$Permission' => '<p/>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'AccessGrantsLocationConfiguration$S3SubPrefix' => '<p>The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. Use this field to narrow the scope of the grant to a subset of the location scope. This field is required if the location scope is the default location <code>s3://</code> because you cannot create a grant for all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the default location <code>s3://</code>, the <code>S3SubPrefx</code> can be a &lt;bucket-name&gt;/*, so the full grant scope path would be <code>s3://&lt;bucket-name&gt;/*</code>. Or the <code>S3SubPrefx</code> can be <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>, so the full grant scope path would be or <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code>.</p> <p>If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the prefix to indicate that you want to include all object key names in the bucket that start with that prefix. </p>', 'CreateAccessGrantResult$GrantScope' => '<p>The S3 path of the data to which you are granting access. It is the result of appending the <code>Subprefix</code> to the location scope. </p>', 'CreateAccessGrantsLocationRequest$LocationScope' => '<p>The S3 path to the location that you are registering. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or object key names that start with the <code>marketing/campaigns/</code> prefix.</p>', 'CreateAccessGrantsLocationResult$LocationScope' => '<p>The S3 URI path to the location that you are registering. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket, or the S3 path to a bucket and prefix. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or object key names that start with the <code>marketing/campaigns/</code> prefix.</p>', 'GetAccessGrantResult$GrantScope' => '<p>The S3 path of the data to which you are granting access. It is the result of appending the <code>Subprefix</code> to the location scope.</p>', 'GetAccessGrantsInstanceForPrefixRequest$S3Prefix' => '<p>The S3 prefix of the access grants that you would like to retrieve.</p>', 'GetAccessGrantsLocationResult$LocationScope' => '<p>The S3 URI path to the registered location. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket, or the S3 path to a bucket and prefix. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or object key names that start with the <code>marketing/campaigns/</code> prefix.</p>', 'GetDataAccessRequest$Target' => '<p>The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting account has an access grant for this data, S3 Access Grants vends temporary access credentials in the response.</p>', 'GetDataAccessResult$MatchedGrantTarget' => '<p>The S3 URI path of the data to which you are being granted temporary access credentials. </p>', 'ListAccessGrantEntry$GrantScope' => '<p>The S3 path of the data to which you are granting access. It is the result of appending the <code>Subprefix</code> to the location scope.</p>', 'ListAccessGrantsLocationsEntry$LocationScope' => '<p>The S3 path to the location that you are registering. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or object key names that start with the <code>marketing/campaigns/</code> prefix.</p>', 'ListAccessGrantsLocationsRequest$LocationScope' => '<p>The S3 path to the location that you are registering. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the beginning of an object key name used to organize the objects that you store in your S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or object key names that start with the <code>marketing/campaigns/</code> prefix.</p>', 'ListAccessGrantsRequest$GrantScope' => '<p>The S3 path of the data to which you are granting access. It is the result of appending the <code>Subprefix</code> to the location scope.</p>', 'UpdateAccessGrantsLocationResult$LocationScope' => '<p>The S3 URI path of the location that you are updating. You cannot update the scope of the registered location. The location scope can be the default S3 location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. </p>', ], ], 'S3PrefixType' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantRequest$S3PrefixType' => '<p>The type of <code>S3SubPrefix</code>. The only possible value is <code>Object</code>. Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix. </p>', 'GetDataAccessRequest$TargetType' => '<p>The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the target data that you would like to access is a path to an object. Do not pass this value if the target data is a bucket or a bucket and a prefix. </p>', ], ], 'S3RegionalBucketArn' => [ 'base' => NULL, 'refs' => [ 'CreateBucketResult$BucketArn' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through Outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'RegionalBucket$BucketArn' => '<p>The Amazon Resource Name (ARN) for the regional bucket.</p>', ], ], 'S3RegionalOrS3ExpressBucketArnString' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$TargetResource' => '<p>Specifies the destination bucket Amazon Resource Name (ARN) for the batch copy operation.</p> <ul> <li> <p> <b>General purpose buckets</b> - For example, to copy objects to a general purpose bucket named <code>destinationBucket</code>, set the <code>TargetResource</code> property to <code>arn:aws:s3:::destinationBucket</code>.</p> </li> <li> <p> <b>Directory buckets</b> - For example, to copy objects to a directory bucket named <code>destinationBucket</code> in the Availability Zone; identified by the AZ ID <code>usw2-az1</code>, set the <code>TargetResource</code> property to <code>arn:aws:s3express:<i>region</i>:<i>account_id</i>:/bucket/<i>destination_bucket_base_name</i>--<i>usw2-az1</i>--x-s3</code>.</p> </li> </ul>', ], ], 'S3ReplicateObjectOperation' => [ 'base' => '<p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job\'s manifest.</p>', 'refs' => [ 'JobOperation$S3ReplicateObject' => '<p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job\'s manifest.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the S3 resource that you want to list the tags for. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the S3 resource that you\'re trying to add tags to. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant.</p>', 'UntagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the S3 resource that you\'re trying to remove the tags from. </p>', ], ], 'S3Retention' => [ 'base' => '<p>Contains the S3 Object Lock retention mode to be applied to all objects in the S3 Batch Operations job. If you don\'t provide <code>Mode</code> and <code>RetainUntilDate</code> data types in your operation, you will remove the retention from your objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'S3SetObjectRetentionOperation$Retention' => '<p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'S3SSEAlgorithm' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$SSEAlgorithm' => '<p/> <note> <p>For directory buckets, only the server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note>', ], ], 'S3SetObjectAclOperation' => [ 'base' => '<p>Contains the configuration parameters for a PUT Object ACL operation. S3 Batch Operations passes every object to the underlying <code>PutObjectAcl</code> API operation. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html">PutObjectAcl</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectAcl' => '<p>Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3SetObjectLegalHoldOperation' => [ 'base' => '<p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes to every object to the underlying <code>PutObjectLegalHold</code> API operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'refs' => [ 'JobOperation$S3PutObjectLegalHold' => NULL, ], ], 'S3SetObjectRetentionOperation' => [ 'base' => '<p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'refs' => [ 'JobOperation$S3PutObjectRetention' => NULL, ], ], 'S3SetObjectTaggingOperation' => [ 'base' => '<p>Contains the configuration parameters for a PUT Object Tagging operation. S3 Batch Operations passes every object to the underlying <code>PutObjectTagging</code> API operation. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html">PutObjectTagging</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectTagging' => '<p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', ], ], 'S3StorageClass' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$StorageClass' => '<p>Specify the storage class for the destination objects in a <code>Copy</code> operation.</p> <note> <p> <b>Directory buckets </b> - This functionality is not supported by directory buckets. </p> </note>', 'StorageClassList$member' => NULL, ], ], 'S3Tag' => [ 'base' => '<p>A container for a key-value name pair.</p>', 'refs' => [ 'LifecycleRuleFilter$Tag' => NULL, 'MatchAnyTag$member' => NULL, 'ReplicationRuleFilter$Tag' => NULL, 'S3TagSet$member' => NULL, ], ], 'S3TagSet' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Tags' => '<p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>', 'GetBucketTaggingResult$TagSet' => '<p>The tags set of the Outposts bucket.</p>', 'GetJobTaggingResult$Tags' => '<p>The set of tags associated with the S3 Batch Operations job.</p>', 'LifecycleRuleAndOperator$Tags' => '<p>All of these tags must exist in the object\'s tag set in order for the rule to apply.</p>', 'PutJobTaggingRequest$Tags' => '<p>The set of tags to associate with the S3 Batch Operations job.</p>', 'ReplicationRuleAndOperator$Tags' => '<p>An array of tags that contain key and value pairs.</p>', 'S3CopyObjectOperation$NewObjectTagging' => '<p>Specifies a list of tags to add to the destination objects after they are copied. If <code>NewObjectTagging</code> is not specified, the tags of the source objects are copied to destination objects by default.</p> <note> <p> <b>Directory buckets</b> - Tags aren\'t supported by directory buckets. If your source objects have tags and your destination bucket is a directory bucket, specify an empty tag set in the <code>NewObjectTagging</code> field to prevent copying the source object tags to the directory bucket.</p> </note>', 'S3SetObjectTaggingOperation$TagSet' => '<p/>', 'Tagging$TagSet' => '<p>A collection for a set of tags.</p>', ], ], 'S3UserMetadata' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$UserMetadata' => '<p/>', ], ], 'SSEKMS' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensDataExportEncryption$SSEKMS' => '<p/>', ], ], 'SSEKMSEncryption' => [ 'base' => '<p>Configuration for the use of SSE-KMS to encrypt generated manifest objects.</p>', 'refs' => [ 'GeneratedManifestEncryption$SSEKMS' => '<p>Configuration details on how SSE-KMS is used to encrypt generated manifest objects.</p>', ], ], 'SSEKMSKeyId' => [ 'base' => NULL, 'refs' => [ 'SSEKMS$KeyId' => '<p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>', ], ], 'SSES3' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensDataExportEncryption$SSES3' => '<p/>', ], ], 'SSES3Encryption' => [ 'base' => '<p>Configuration for the use of SSE-S3 to encrypt generated manifest objects.</p>', 'refs' => [ 'GeneratedManifestEncryption$SSES3' => '<p>Specifies the use of SSE-S3 to encrypt generated manifest objects.</p>', ], ], 'SecretAccessKey' => [ 'base' => NULL, 'refs' => [ 'Credentials$SecretAccessKey' => '<p>The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications. </p>', ], ], 'SelectionCriteria' => [ 'base' => '<p/>', 'refs' => [ 'PrefixLevelStorageMetrics$SelectionCriteria' => NULL, ], ], 'SessionToken' => [ 'base' => NULL, 'refs' => [ 'Credentials$SessionToken' => '<p>The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications. </p>', ], ], 'Setting' => [ 'base' => NULL, 'refs' => [ 'PublicAccessBlockConfiguration$BlockPublicAcls' => '<p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p> <ul> <li> <p> <code>PutBucketAcl</code> and <code>PutObjectAcl</code> calls fail if the specified ACL is public.</p> </li> <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li> <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li> </ul> <p>Enabling this setting doesn\'t affect existing policies or ACLs.</p> <p>This property is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$IgnorePublicAcls' => '<p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p> <p>Enabling this setting doesn\'t affect the persistence of any existing ACLs and doesn\'t prevent new public ACLs from being set.</p> <p>This property is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$BlockPublicPolicy' => '<p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p> <p>Enabling this setting doesn\'t affect existing bucket policies.</p> <p>This property is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$RestrictPublicBuckets' => '<p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p> <p>Enabling this setting doesn\'t affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p> <p>This property is not supported for Amazon S3 on Outposts.</p>', ], ], 'SourceSelectionCriteria' => [ 'base' => '<p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects.</p>', 'refs' => [ 'ReplicationRule$SourceSelectionCriteria' => '<p>A container that describes additional filters for identifying the source Outposts objects that you want to replicate. You can choose to enable or disable the replication of these objects.</p>', ], ], 'SseKmsEncryptedObjects' => [ 'base' => '<p>A container for filter information that you can use to select S3 objects that are encrypted with Key Management Service (KMS).</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'SourceSelectionCriteria$SseKmsEncryptedObjects' => '<p>A filter that you can use to select Amazon S3 objects that are encrypted with server-side encryption by using Key Management Service (KMS) keys. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'SseKmsEncryptedObjectsStatus' => [ 'base' => NULL, 'refs' => [ 'SseKmsEncryptedObjects$Status' => '<p>Specifies whether Amazon S3 replicates objects that are created with server-side encryption by using an KMS key stored in Key Management Service.</p>', ], ], 'StorageClassList' => [ 'base' => NULL, 'refs' => [ 'JobManifestGeneratorFilter$MatchAnyStorageClass' => '<p>If provided, the generated manifest includes only source bucket objects that are stored with the specified storage class.</p>', ], ], 'StorageLensArn' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationEntry$StorageLensArn' => '<p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>', 'StorageLensConfiguration$StorageLensArn' => '<p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>', ], ], 'StorageLensAwsOrg' => [ 'base' => '<p>The Amazon Web Services organization for your S3 Storage Lens.</p>', 'refs' => [ 'StorageLensConfiguration$AwsOrg' => '<p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>', ], ], 'StorageLensConfiguration' => [ 'base' => '<p>A container for the Amazon S3 Storage Lens configuration.</p>', 'refs' => [ 'GetStorageLensConfigurationResult$StorageLensConfiguration' => '<p>The S3 Storage Lens configuration requested.</p>', 'PutStorageLensConfigurationRequest$StorageLensConfiguration' => '<p>The S3 Storage Lens configuration.</p>', ], ], 'StorageLensConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationsResult$StorageLensConfigurationList' => '<p>A list of S3 Storage Lens configurations.</p>', ], ], 'StorageLensDataExport' => [ 'base' => '<p>A container to specify the properties of your S3 Storage Lens metrics export, including the destination, schema, and format.</p>', 'refs' => [ 'StorageLensConfiguration$DataExport' => '<p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>', ], ], 'StorageLensDataExportEncryption' => [ 'base' => '<p>A container for the encryption of the S3 Storage Lens metrics exports.</p>', 'refs' => [ 'S3BucketDestination$Encryption' => '<p>The container for the type encryption of the metrics exports in this bucket.</p>', ], ], 'StorageLensGroup' => [ 'base' => '<p>A custom grouping of objects that include filters for prefixes, suffixes, object tags, object size, or object age. You can create an S3 Storage Lens group that includes a single filter or multiple filter conditions. To specify multiple filter conditions, you use <code>AND</code> or <code>OR</code> logical operators. </p>', 'refs' => [ 'CreateStorageLensGroupRequest$StorageLensGroup' => '<p> The Storage Lens group configuration. </p>', 'GetStorageLensGroupResult$StorageLensGroup' => '<p> The name of the Storage Lens group that you\'re trying to retrieve the configuration details for. </p>', 'UpdateStorageLensGroupRequest$StorageLensGroup' => '<p> The JSON file that contains the Storage Lens group configuration. </p>', ], ], 'StorageLensGroupAndOperator' => [ 'base' => '<p> A logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. </p>', 'refs' => [ 'StorageLensGroupFilter$And' => '<p>A logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the <code>And</code> logical operator. Only one of each filter condition is allowed.</p>', ], ], 'StorageLensGroupArn' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensGroupEntry$StorageLensGroupArn' => '<p> Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only. </p>', 'StorageLensGroup$StorageLensGroupArn' => '<p> Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only. </p>', 'StorageLensGroupLevelExclude$member' => NULL, 'StorageLensGroupLevelInclude$member' => NULL, ], ], 'StorageLensGroupFilter' => [ 'base' => '<p>The filter element sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the <code>AND</code> or <code>OR</code> logical operator is used.</p>', 'refs' => [ 'StorageLensGroup$Filter' => '<p>Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the <code>AND</code> or <code>OR</code> logical operator is used.</p>', ], ], 'StorageLensGroupLevel' => [ 'base' => '<p> Specifies the Storage Lens groups to include in the Storage Lens group aggregation. </p>', 'refs' => [ 'AccountLevel$StorageLensGroupLevel' => '<p> A container element for S3 Storage Lens groups metrics. </p>', ], ], 'StorageLensGroupLevelExclude' => [ 'base' => NULL, 'refs' => [ 'StorageLensGroupLevelSelectionCriteria$Exclude' => '<p> Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation. </p>', ], ], 'StorageLensGroupLevelInclude' => [ 'base' => NULL, 'refs' => [ 'StorageLensGroupLevelSelectionCriteria$Include' => '<p> Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation. </p>', ], ], 'StorageLensGroupLevelSelectionCriteria' => [ 'base' => '<p> Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. You can only attach Storage Lens groups to your Storage Lens dashboard if they\'re included in your Storage Lens group aggregation. If this value is left null, then all Storage Lens groups are selected. </p>', 'refs' => [ 'StorageLensGroupLevel$SelectionCriteria' => '<p> Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this value is left null, then all Storage Lens groups are selected. </p>', ], ], 'StorageLensGroupList' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensGroupsResult$StorageLensGroupList' => '<p> The list of Storage Lens groups that exist in the specified home Region. </p>', ], ], 'StorageLensGroupName' => [ 'base' => NULL, 'refs' => [ 'DeleteStorageLensGroupRequest$Name' => '<p> The name of the Storage Lens group that you\'re trying to delete. </p>', 'GetStorageLensGroupRequest$Name' => '<p> The name of the Storage Lens group that you\'re trying to retrieve the configuration details for. </p>', 'ListStorageLensGroupEntry$Name' => '<p> Contains the name of the Storage Lens group that exists in the specified home Region. </p>', 'StorageLensGroup$Name' => '<p> Contains the name of the Storage Lens group. </p>', 'UpdateStorageLensGroupRequest$Name' => '<p> The name of the Storage Lens group that you want to update. </p>', ], ], 'StorageLensGroupOrOperator' => [ 'base' => '<p>A container element for specifying <code>Or</code> rule conditions. The rule conditions determine the subset of objects to which the <code>Or</code> rule applies. Objects can match any of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed.</p>', 'refs' => [ 'StorageLensGroupFilter$Or' => '<p>A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed. </p>', ], ], 'StorageLensPrefixLevelDelimiter' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$Delimiter' => '<p>A container for the delimiter of the selection criteria being used.</p>', ], ], 'StorageLensPrefixLevelMaxDepth' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$MaxDepth' => '<p>The max depth of the selection criteria</p>', ], ], 'StorageLensTag' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensTags$member' => NULL, ], ], 'StorageLensTags' => [ 'base' => NULL, 'refs' => [ 'GetStorageLensConfigurationTaggingResult$Tags' => '<p>The tags of S3 Storage Lens configuration requested.</p>', 'PutStorageLensConfigurationRequest$Tags' => '<p>The tag set of the S3 Storage Lens configuration.</p> <note> <p>You can set up to a maximum of 50 tags.</p> </note>', 'PutStorageLensConfigurationTaggingRequest$Tags' => '<p>The tag set of the S3 Storage Lens configuration.</p> <note> <p>You can set up to a maximum of 50 tags.</p> </note>', ], ], 'StringForNextToken' => [ 'base' => NULL, 'refs' => [ 'ListJobsRequest$NextToken' => '<p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>', 'ListJobsResult$NextToken' => '<p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.</p>', ], ], 'SubmitMultiRegionAccessPointRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubmitMultiRegionAccessPointRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'Suffix' => [ 'base' => NULL, 'refs' => [ 'MatchAnySuffix$member' => NULL, ], ], 'SuspendedCause' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$SuspendedCause' => '<p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>', ], ], 'SuspendedDate' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$SuspendedDate' => '<p>The timestamp when this job was suspended, if it has been suspended.</p>', ], ], 'Tag' => [ 'base' => '<p> An Amazon Web Services resource tag that\'s associated with your S3 resource. You can add tags to new objects when you upload them, or you can add object tags to existing objects. </p> <note> <p>This operation is only supported for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a> and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered location, or grant. </p> </note>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> The array of tag key-value pairs that you\'re trying to remove from of the S3 resource. </p>', ], ], 'TagKeyString' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Key' => '<p>Key of the tag</p>', 'StorageLensTag$Key' => '<p/>', 'Tag$Key' => '<p>The key of the key-value pair of a tag added to your Amazon Web Services resource. A tag key can be up to 128 Unicode characters in length and is case-sensitive. System created tags that begin with <code>aws:</code> aren’t supported. </p>', 'TagKeyList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAccessGrantRequest$Tags' => '<p>The Amazon Web Services resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. </p>', 'CreateAccessGrantsInstanceRequest$Tags' => '<p>The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. </p>', 'CreateAccessGrantsLocationRequest$Tags' => '<p>The Amazon Web Services resource tags that you are adding to the S3 Access Grants location. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.</p>', 'CreateStorageLensGroupRequest$Tags' => '<p> The Amazon Web Services resource tags that you\'re adding to your Storage Lens group. This parameter is optional. </p>', 'ListTagsForResourceResult$Tags' => '<p> The Amazon Web Services resource tags that are associated with the resource. </p>', 'TagResourceRequest$Tags' => '<p> The Amazon Web Services resource tags that you want to add to the specified S3 resource. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValueString' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Value' => '<p>Value of the tag</p>', 'StorageLensTag$Value' => '<p/>', 'Tag$Value' => '<p> The value of the key-value pair of a tag added to your Amazon Web Services resource. A tag value can be up to 256 Unicode characters in length and is case-sensitive. </p>', ], ], 'Tagging' => [ 'base' => '<p/>', 'refs' => [ 'PutBucketTaggingRequest$Tagging' => '<p/>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ModifiedSinceConstraint' => '<p/>', 'S3CopyObjectOperation$UnModifiedSinceConstraint' => '<p/>', 'S3CopyObjectOperation$ObjectLockRetainUntilDate' => '<p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p> <note> <p>This functionality is not supported by directory buckets.</p> </note>', 'S3ObjectMetadata$HttpExpiresDate' => '<p/>', 'S3Retention$RetainUntilDate' => '<p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p/>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>Amazon S3 throws this exception if you have too many tags in your tag set.</p>', 'refs' => [], ], 'TrafficDialPercentage' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointRoute$TrafficDialPercentage' => '<p>The traffic state for the specified bucket or Amazon Web Services Region. </p> <p>A value of <code>0</code> indicates a passive state, which means that no new traffic will be routed to the Region. </p> <p>A value of <code>100</code> indicates an active state, which means that traffic will be routed to the specified Region. </p> <p>When the routing configuration for a Region is changed from active to passive, any in-progress operations (uploads, copies, deletes, and so on) to the formerly active Region will continue to run to until a final success or failure status is reached.</p> <p>If all Regions in the routing configuration are designated as passive, you\'ll receive an <code>InvalidRequest</code> error.</p>', ], ], 'Transition' => [ 'base' => '<p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 Lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html"> Transitioning objects using Amazon S3 Lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'TransitionList$member' => NULL, ], ], 'TransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Transitions' => '<p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'TransitionStorageClass' => [ 'base' => NULL, 'refs' => [ 'NoncurrentVersionTransition$StorageClass' => '<p>The class of storage used to store the object.</p>', 'Transition$StorageClass' => '<p>The storage class to which you want the object to transition.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessGrantsLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessGrantsLocationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobPriorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobPriorityResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageLensGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UserArguments' => [ 'base' => NULL, 'refs' => [ 'LambdaInvokeOperation$UserArguments' => '<p>Key-value pairs that are passed in the payload that Batch Operations sends when invoking an Lambda function. You must specify <code>InvocationSchemaVersion</code> <b>2.0</b> for <code>LambdaInvoke</code> operations that include <code>UserArguments</code>. For more information, see <a href="https://aws.amazon.com/blogs/storage/automate-object-processing-in-amazon-s3-directory-buckets-with-s3-batch-operations-and-aws-lambda/">Automate object processing in Amazon S3 directory buckets with S3 Batch Operations and Lambda</a> in the <i>Amazon Web Services Storage Blog</i>.</p>', ], ], 'VersioningConfiguration' => [ 'base' => '<p>Describes the versioning state of an Amazon S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html">PutBucketVersioning</a>.</p>', 'refs' => [ 'PutBucketVersioningRequest$VersioningConfiguration' => '<p>The root-level tag for the <code>VersioningConfiguration</code> parameters.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The virtual private cloud (VPC) configuration for an access point.</p>', 'refs' => [ 'AccessPoint$VpcConfiguration' => '<p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note> <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p> </note>', 'CreateAccessPointRequest$VpcConfiguration' => '<p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note> <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p> </note>', 'GetAccessPointResult$VpcConfiguration' => '<p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p> <note> <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p> </note>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$VpcId' => '<p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>', ], ], ],];
