<?php
// This file was auto-generated from sdk-root/src/data/sagemaker-geospatial/2020-05-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing SageMaker geospatial resources.</p>', 'operations' => [ 'DeleteEarthObservationJob' => '<p>Use this operation to delete an Earth Observation job.</p>', 'DeleteVectorEnrichmentJob' => '<p>Use this operation to delete a Vector Enrichment job.</p>', 'ExportEarthObservationJob' => '<p>Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an Amazon S3 location.</p>', 'ExportVectorEnrichmentJob' => '<p>Use this operation to copy results of a Vector Enrichment job to an Amazon S3 location.</p>', 'GetEarthObservationJob' => '<p>Get the details for a previously initiated Earth Observation job.</p>', 'GetRasterDataCollection' => '<p>Use this operation to get details of a specific raster data collection.</p>', 'GetTile' => '<p>Gets a web mercator tile for the given Earth Observation job.</p>', 'GetVectorEnrichmentJob' => '<p>Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).</p>', 'ListEarthObservationJobs' => '<p>Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.</p>', 'ListRasterDataCollections' => '<p>Use this operation to get raster data collections.</p>', 'ListTagsForResource' => '<p>Lists the tags attached to the resource.</p>', 'ListVectorEnrichmentJobs' => '<p>Retrieves a list of vector enrichment jobs.</p>', 'SearchRasterDataCollection' => '<p>Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.</p>', 'StartEarthObservationJob' => '<p>Use this operation to create an Earth observation job.</p>', 'StartVectorEnrichmentJob' => '<p>Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.</p>', 'StopEarthObservationJob' => '<p>Use this operation to stop an existing earth observation job.</p>', 'StopVectorEnrichmentJob' => '<p>Stops the Vector Enrichment job for a given job ARN.</p>', 'TagResource' => '<p>The resource you want to tag.</p>', 'UntagResource' => '<p>The resource you want to untag.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AlgorithmNameCloudRemoval' => [ 'base' => NULL, 'refs' => [ 'CloudRemovalConfigInput$AlgorithmName' => '<p>The name of the algorithm used for cloud removal.</p>', ], ], 'AlgorithmNameGeoMosaic' => [ 'base' => NULL, 'refs' => [ 'GeoMosaicConfigInput$AlgorithmName' => '<p>The name of the algorithm being used for geomosaic.</p>', ], ], 'AlgorithmNameResampling' => [ 'base' => NULL, 'refs' => [ 'ResamplingConfigInput$AlgorithmName' => '<p>The name of the algorithm used for resampling.</p>', ], ], 'AreaOfInterest' => [ 'base' => '<p>The geographic extent of the Earth Observation job.</p>', 'refs' => [ 'RasterDataCollectionQueryInput$AreaOfInterest' => '<p>The area of interest being queried for the raster data collection.</p>', 'RasterDataCollectionQueryOutput$AreaOfInterest' => '<p>The Area of Interest used in the search.</p>', 'RasterDataCollectionQueryWithBandFilterInput$AreaOfInterest' => '<p>The Area of interest to be used in the search query.</p>', ], ], 'AreaOfInterestGeometry' => [ 'base' => '<p>A GeoJSON object representing the geographic extent in the coordinate space.</p>', 'refs' => [ 'AreaOfInterest$AreaOfInterestGeometry' => '<p>A GeoJSON object representing the geographic extent in the coordinate space.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to tag.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to tag.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to untag.</p>', ], ], 'AssetValue' => [ 'base' => '<p>The structure containing the asset properties.</p>', 'refs' => [ 'AssetsMap$value' => NULL, ], ], 'AssetsMap' => [ 'base' => NULL, 'refs' => [ 'ItemSource$Assets' => '<p>This is a dictionary of Asset Objects data associated with the Item that can be downloaded or streamed, each with a unique key.</p>', ], ], 'BandMathConfigInput' => [ 'base' => '<p>Input structure for the BandMath operation type. Defines Predefined and CustomIndices to be computed using BandMath.</p>', 'refs' => [ 'JobConfigInput$BandMathConfig' => '<p>An object containing information about the job configuration for BandMath.</p>', ], ], 'BinaryFile' => [ 'base' => NULL, 'refs' => [ 'GetTileOutput$BinaryFile' => '<p>The output binary file.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ExportEarthObservationJobInput$ExportSourceImages' => '<p>The source images provided to the Earth Observation job being exported.</p>', 'ExportEarthObservationJobOutput$ExportSourceImages' => '<p>The source images provided to the Earth Observation job being exported.</p>', 'GetTileInput$ImageMask' => '<p>Determines whether or not to return a valid data mask.</p>', ], ], 'CloudMaskingConfigInput' => [ 'base' => '<p>Input structure for CloudMasking operation type.</p>', 'refs' => [ 'JobConfigInput$CloudMaskingConfig' => '<p>An object containing information about the job configuration for cloud masking.</p>', ], ], 'CloudRemovalConfigInput' => [ 'base' => '<p>Input structure for Cloud Removal Operation type</p>', 'refs' => [ 'JobConfigInput$CloudRemovalConfig' => '<p>An object containing information about the job configuration for cloud removal.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'PlatformInput$ComparisonOperator' => '<p>The ComparisonOperator to use with PlatformInput.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CustomIndicesInput' => [ 'base' => '<p>Input object defining the custom BandMath indices to compute.</p>', 'refs' => [ 'BandMathConfigInput$CustomIndices' => '<p>CustomIndices that are computed.</p>', ], ], 'DataCollectionArn' => [ 'base' => NULL, 'refs' => [ 'GetRasterDataCollectionInput$Arn' => '<p>The Amazon Resource Name (ARN) of the raster data collection.</p>', 'GetRasterDataCollectionOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the raster data collection.</p>', 'RasterDataCollectionMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the raster data collection.</p>', 'RasterDataCollectionQueryInput$RasterDataCollectionArn' => '<p>The Amazon Resource Name (ARN) of the raster data collection.</p>', 'RasterDataCollectionQueryOutput$RasterDataCollectionArn' => '<p>The ARN of the Raster Data Collection against which the search is done.</p>', 'SearchRasterDataCollectionInput$Arn' => '<p>The Amazon Resource Name (ARN) of the raster data collection.</p>', ], ], 'DataCollectionType' => [ 'base' => NULL, 'refs' => [ 'GetRasterDataCollectionOutput$Type' => '<p>The raster data collection type.</p>', 'RasterDataCollectionMetadata$Type' => '<p>The type of raster data collection.</p>', ], ], 'DataCollectionsList' => [ 'base' => NULL, 'refs' => [ 'ListRasterDataCollectionsOutput$RasterDataCollectionSummaries' => '<p>Contains summary information about the raster data collection.</p>', ], ], 'DeleteEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'Position$member' => NULL, ], ], 'EarthObservationJobArn' => [ 'base' => NULL, 'refs' => [ 'DeleteEarthObservationJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Earth Observation job being deleted.</p>', 'ExportEarthObservationJobInput$Arn' => '<p>The input Amazon Resource Name (ARN) of the Earth Observation job being exported.</p>', 'ExportEarthObservationJobOutput$Arn' => '<p>The output Amazon Resource Name (ARN) of the Earth Observation job being exported.</p>', 'GetEarthObservationJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Earth Observation job.</p>', 'GetTileInput$Arn' => '<p>The Amazon Resource Name (ARN) of the tile operation.</p>', 'InputConfigInput$PreviousEarthObservationJobArn' => '<p>The Amazon Resource Name (ARN) of the previous Earth Observation job.</p>', 'InputConfigOutput$PreviousEarthObservationJobArn' => '<p>The Amazon Resource Name (ARN) of the previous Earth Observation job.</p>', 'StopEarthObservationJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Earth Observation job being stopped.</p>', ], ], 'EarthObservationJobErrorDetails' => [ 'base' => '<p>The structure representing the errors in an EarthObservationJob.</p>', 'refs' => [ 'GetEarthObservationJobOutput$ErrorDetails' => '<p>Details about the errors generated during the Earth Observation job.</p>', ], ], 'EarthObservationJobErrorType' => [ 'base' => NULL, 'refs' => [ 'EarthObservationJobErrorDetails$Type' => '<p>The type of error in an Earth Observation job.</p>', ], ], 'EarthObservationJobExportStatus' => [ 'base' => NULL, 'refs' => [ 'ExportEarthObservationJobOutput$ExportStatus' => '<p>The status of the results of the Earth Observation job being exported.</p>', 'GetEarthObservationJobOutput$ExportStatus' => '<p>The status of the Earth Observation job.</p>', ], ], 'EarthObservationJobList' => [ 'base' => NULL, 'refs' => [ 'ListEarthObservationJobOutput$EarthObservationJobSummaries' => '<p>Contains summary information about the Earth Observation jobs.</p>', ], ], 'EarthObservationJobOutputBands' => [ 'base' => NULL, 'refs' => [ 'GetEarthObservationJobOutput$OutputBands' => '<p>Bands available in the output of an operation.</p>', ], ], 'EarthObservationJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetEarthObservationJobOutput$Status' => '<p>The status of a previously initiated Earth Observation job.</p>', 'ListEarthObservationJobInput$StatusEquals' => '<p>A filter that retrieves only jobs with a specific status.</p>', 'ListEarthObservationJobOutputConfig$Status' => '<p>The status of the list of the Earth Observation jobs.</p>', 'StartEarthObservationJobOutput$Status' => '<p>The status of the Earth Observation job.</p>', ], ], 'EoCloudCoverInput' => [ 'base' => '<p>The structure representing the EoCloudCover filter.</p>', 'refs' => [ 'Property$EoCloudCover' => '<p>The structure representing EoCloudCover property filter containing a lower bound and upper bound.</p>', ], ], 'ExecutionRoleArn' => [ 'base' => NULL, 'refs' => [ 'ExportEarthObservationJobInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'ExportEarthObservationJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'ExportVectorEnrichmentJobInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM rolewith permission to upload to the location in OutputConfig.</p>', 'ExportVectorEnrichmentJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permission to upload to the location in OutputConfig.</p>', 'GetEarthObservationJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'GetTileInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specify.</p>', 'GetVectorEnrichmentJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'StartEarthObservationJobInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'StartEarthObservationJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'StartVectorEnrichmentJobInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', 'StartVectorEnrichmentJobOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the job.</p>', ], ], 'ExportEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportEarthObservationJobInputClientTokenString' => [ 'base' => NULL, 'refs' => [ 'ExportEarthObservationJobInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'ExportEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExportErrorDetails' => [ 'base' => '<p>The structure for returning the export error details in a GetEarthObservationJob.</p>', 'refs' => [ 'GetEarthObservationJobOutput$ExportErrorDetails' => '<p>Details about the errors generated during ExportEarthObservationJob.</p>', ], ], 'ExportErrorDetailsOutput' => [ 'base' => '<p>The structure representing the errors in an export EarthObservationJob operation.</p>', 'refs' => [ 'ExportErrorDetails$ExportResults' => '<p>The structure for returning the export error details while exporting results of an Earth Observation job.</p>', 'ExportErrorDetails$ExportSourceImages' => '<p>The structure for returning the export error details while exporting the source images of an Earth Observation job.</p>', ], ], 'ExportErrorType' => [ 'base' => NULL, 'refs' => [ 'ExportErrorDetailsOutput$Type' => '<p>The type of error in an export EarthObservationJob operation.</p>', ], ], 'ExportS3DataInput' => [ 'base' => '<p>The structure containing the Amazon S3 path to export the Earth Observation job output.</p>', 'refs' => [ 'OutputConfigInput$S3Data' => '<p>Path to Amazon S3 storage location for the output configuration file.</p>', ], ], 'ExportVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportVectorEnrichmentJobInputClientTokenString' => [ 'base' => NULL, 'refs' => [ 'ExportVectorEnrichmentJobInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'ExportVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExportVectorEnrichmentJobOutputConfig' => [ 'base' => '<p>An object containing information about the output file.</p>', 'refs' => [ 'ExportVectorEnrichmentJobInput$OutputConfig' => '<p>Output location information for exporting Vector Enrichment Job results. </p>', 'ExportVectorEnrichmentJobOutput$OutputConfig' => '<p>Output location information for exporting Vector Enrichment Job results. </p>', ], ], 'Filter' => [ 'base' => '<p>The structure representing the filters supported by a RasterDataCollection.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'GetRasterDataCollectionOutput$SupportedFilters' => '<p>The filters supported by the raster data collection.</p>', 'RasterDataCollectionMetadata$SupportedFilters' => '<p>The list of filters supported by the raster data collection.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'EoCloudCoverInput$LowerBound' => '<p>Lower bound for EoCloudCover.</p>', 'EoCloudCoverInput$UpperBound' => '<p>Upper bound for EoCloudCover.</p>', 'Filter$Maximum' => '<p>The maximum value of the filter.</p>', 'Filter$Minimum' => '<p>The minimum value of the filter.</p>', 'LandsatCloudCoverLandInput$LowerBound' => '<p>The minimum value for Land Cloud Cover property filter. This will filter items having Land Cloud Cover greater than or equal to this value.</p>', 'LandsatCloudCoverLandInput$UpperBound' => '<p>The maximum value for Land Cloud Cover property filter. This will filter items having Land Cloud Cover less than or equal to this value.</p>', 'Properties$EoCloudCover' => '<p>Estimate of cloud cover.</p>', 'Properties$LandsatCloudCoverLand' => '<p>Land cloud cover for Landsat Data Collection.</p>', 'Properties$ViewOffNadir' => '<p>The angle from the sensor between nadir (straight down) and the scene center. Measured in degrees (0-90).</p>', 'Properties$ViewSunAzimuth' => '<p>The sun azimuth angle. From the scene center point on the ground, this is the angle between truth north and the sun. Measured clockwise in degrees (0-360).</p>', 'Properties$ViewSunElevation' => '<p>The sun elevation angle. The angle from the tangent of the scene center point to the sun. Measured from the horizon in degrees (-90-90). Negative values indicate the sun is below the horizon, e.g. sun elevation of -10° means the data was captured during <a href="https://www.timeanddate.com/astronomy/different-types-twilight.html">nautical twilight</a>.</p>', 'UserDefined$Value' => '<p>The value for output resolution of the result.</p>', 'ViewOffNadirInput$LowerBound' => '<p>The minimum value for ViewOffNadir property filter. This filters items having ViewOffNadir greater than or equal to this value. </p>', 'ViewOffNadirInput$UpperBound' => '<p>The maximum value for ViewOffNadir property filter. This filters items having ViewOffNadir lesser than or equal to this value.</p>', 'ViewSunAzimuthInput$LowerBound' => '<p>The minimum value for ViewSunAzimuth property filter. This filters items having ViewSunAzimuth greater than or equal to this value.</p>', 'ViewSunAzimuthInput$UpperBound' => '<p>The maximum value for ViewSunAzimuth property filter. This filters items having ViewSunAzimuth lesser than or equal to this value.</p>', 'ViewSunElevationInput$LowerBound' => '<p>The lower bound to view the sun elevation.</p>', 'ViewSunElevationInput$UpperBound' => '<p>The upper bound to view the sun elevation.</p>', ], ], 'GeoMosaicConfigInput' => [ 'base' => '<p>Input configuration information for the geomosaic.</p>', 'refs' => [ 'JobConfigInput$GeoMosaicConfig' => '<p>An object containing information about the job configuration for geomosaic.</p>', ], ], 'Geometry' => [ 'base' => '<p>The structure representing a Geometry in terms of Type and Coordinates as per GeoJson spec.</p>', 'refs' => [ 'ItemSource$Geometry' => '<p>The item Geometry in GeoJson format.</p>', ], ], 'GetEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRasterDataCollectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRasterDataCollectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GroupBy' => [ 'base' => NULL, 'refs' => [ 'TemporalStatisticsConfigInput$GroupBy' => '<p>The input for the temporal statistics grouping by time frequency option.</p>', ], ], 'ImageSourceBandList' => [ 'base' => NULL, 'refs' => [ 'GetRasterDataCollectionOutput$ImageSourceBands' => '<p>The list of image source bands in the raster data collection.</p>', ], ], 'InputConfigInput' => [ 'base' => '<p>Input configuration information.</p>', 'refs' => [ 'StartEarthObservationJobInput$InputConfig' => '<p>Input configuration information for the Earth Observation job.</p>', ], ], 'InputConfigOutput' => [ 'base' => '<p>The InputConfig for an EarthObservationJob response.</p>', 'refs' => [ 'GetEarthObservationJobOutput$InputConfig' => '<p>Input data for the Earth Observation job.</p>', 'StartEarthObservationJobOutput$InputConfig' => '<p>Input configuration information for the Earth Observation job.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetEarthObservationJobOutput$DurationInSeconds' => '<p>The duration of Earth Observation job, in seconds.</p>', 'GetTileInput$x' => '<p>The x coordinate of the tile input.</p>', 'GetTileInput$y' => '<p>The y coordinate of the tile input.</p>', 'GetTileInput$z' => '<p>The z coordinate of the tile input.</p>', 'GetVectorEnrichmentJobOutput$DurationInSeconds' => '<p>The duration of the Vector Enrichment job, in seconds.</p>', 'ListEarthObservationJobOutputConfig$DurationInSeconds' => '<p>The duration of the session, in seconds.</p>', 'ListVectorEnrichmentJobOutputConfig$DurationInSeconds' => '<p>The duration of the session, in seconds.</p>', 'SearchRasterDataCollectionOutput$ApproximateResultCount' => '<p>Approximate number of results in the response.</p>', 'StartEarthObservationJobOutput$DurationInSeconds' => '<p>The duration of the session, in seconds.</p>', 'StartVectorEnrichmentJobOutput$DurationInSeconds' => '<p>The duration of the Vector Enrichment job, in seconds.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure.</p>', 'refs' => [], ], 'ItemSource' => [ 'base' => '<p>The structure representing the items in the response for SearchRasterDataCollection.</p>', 'refs' => [ 'ItemSourceList$member' => NULL, ], ], 'ItemSourceList' => [ 'base' => NULL, 'refs' => [ 'SearchRasterDataCollectionOutput$Items' => '<p>List of items matching the Raster DataCollectionQuery.</p>', ], ], 'JobConfigInput' => [ 'base' => '<p>The input structure for the JobConfig in an EarthObservationJob.</p>', 'refs' => [ 'GetEarthObservationJobOutput$JobConfig' => '<p>An object containing information about the job configuration.</p>', 'StartEarthObservationJobInput$JobConfig' => '<p>An object containing information about the job configuration.</p>', 'StartEarthObservationJobOutput$JobConfig' => '<p>An object containing information about the job configuration.</p>', ], ], 'KmsKey' => [ 'base' => NULL, 'refs' => [ 'ExportS3DataInput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'GetEarthObservationJobOutput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'GetVectorEnrichmentJobOutput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'StartEarthObservationJobInput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'StartEarthObservationJobOutput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'StartVectorEnrichmentJobInput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'StartVectorEnrichmentJobOutput$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'VectorEnrichmentJobS3Data$KmsKeyId' => '<p>The Key Management Service key ID for server-side encryption.</p>', 'ZonalStatisticsConfigInput$ZoneS3PathKmsKeyId' => '<p>The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to decrypt your output artifacts with Amazon S3 server-side encryption. The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.</p> <p>The <code>KmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code> </p> </li> </ul> <p>For more information about key identifiers, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.</p>', ], ], 'LandCoverSegmentationConfigInput' => [ 'base' => '<p>The input structure for Land Cover Operation type.</p>', 'refs' => [ 'JobConfigInput$LandCoverSegmentationConfig' => '<p>An object containing information about the job configuration for land cover segmentation.</p>', ], ], 'LandsatCloudCoverLandInput' => [ 'base' => '<p>The structure representing Land Cloud Cover property for Landsat data collection.</p>', 'refs' => [ 'Property$LandsatCloudCoverLand' => '<p>The structure representing Land Cloud Cover property filter for Landsat collection containing a lower bound and upper bound.</p>', ], ], 'LinearRing' => [ 'base' => NULL, 'refs' => [ 'LinearRings$member' => NULL, ], ], 'LinearRings' => [ 'base' => NULL, 'refs' => [ 'Geometry$Coordinates' => '<p>The coordinates of the GeoJson Geometry.</p>', 'LinearRingsList$member' => NULL, 'PolygonGeometryInput$Coordinates' => '<p>Coordinates representing a Polygon based on the <a href="https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6">GeoJson spec</a>.</p>', ], ], 'LinearRingsList' => [ 'base' => NULL, 'refs' => [ 'MultiPolygonGeometryInput$Coordinates' => '<p>The coordinates of the multipolygon geometry.</p>', ], ], 'ListEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEarthObservationJobInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEarthObservationJobInput$MaxResults' => '<p>The total number of items to return.</p>', ], ], 'ListEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEarthObservationJobOutputConfig' => [ 'base' => '<p>An object containing information about the output file.</p>', 'refs' => [ 'EarthObservationJobList$member' => NULL, ], ], 'ListRasterDataCollectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRasterDataCollectionsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRasterDataCollectionsInput$MaxResults' => '<p>The total number of items to return.</p>', ], ], 'ListRasterDataCollectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'ListVectorEnrichmentJobInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListVectorEnrichmentJobInput$MaxResults' => '<p>The maximum number of items to return.</p>', ], ], 'ListVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListVectorEnrichmentJobOutputConfig' => [ 'base' => '<p>An object containing information about the output file.</p>', 'refs' => [ 'VectorEnrichmentJobList$member' => NULL, ], ], 'LogicalOperator' => [ 'base' => NULL, 'refs' => [ 'PropertyFilters$LogicalOperator' => '<p>The Logical Operator used to combine the Property Filters.</p>', ], ], 'MapMatchingConfig' => [ 'base' => '<p>The input structure for Map Matching operation type.</p>', 'refs' => [ 'VectorEnrichmentJobConfig$MapMatchingConfig' => '<p>The input structure for Map Matching operation type.</p>', ], ], 'MultiPolygonGeometryInput' => [ 'base' => '<p>The structure representing Polygon Geometry based on the <a href="https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6">GeoJson spec</a>.</p>', 'refs' => [ 'AreaOfInterestGeometry$MultiPolygonGeometry' => '<p>The structure representing the MultiPolygon Geometry.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListEarthObservationJobInput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListEarthObservationJobOutput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListRasterDataCollectionsInput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListRasterDataCollectionsOutput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListVectorEnrichmentJobInput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListVectorEnrichmentJobOutput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'SearchRasterDataCollectionInput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'SearchRasterDataCollectionOutput$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', ], ], 'Operation' => [ 'base' => '<p>Represents an arithmetic operation to compute spectral index.</p>', 'refs' => [ 'OperationsListInput$member' => NULL, ], ], 'OperationsListInput' => [ 'base' => NULL, 'refs' => [ 'CustomIndicesInput$Operations' => '<p>A list of BandMath indices to compute.</p>', ], ], 'OutputBand' => [ 'base' => '<p>A single EarthObservationJob output band.</p>', 'refs' => [ 'EarthObservationJobOutputBands$member' => NULL, ], ], 'OutputConfigInput' => [ 'base' => '<p>The response structure for an OutputConfig returned by an ExportEarthObservationJob.</p>', 'refs' => [ 'ExportEarthObservationJobInput$OutputConfig' => '<p>An object containing information about the output file.</p>', 'ExportEarthObservationJobOutput$OutputConfig' => '<p>An object containing information about the output file.</p>', ], ], 'OutputResolutionResamplingInput' => [ 'base' => '<p>OutputResolution Configuration indicating the target resolution for the output of Resampling operation.</p>', 'refs' => [ 'ResamplingConfigInput$OutputResolution' => '<p>The structure representing output resolution (in target georeferenced units) of the result of resampling operation.</p>', ], ], 'OutputResolutionStackInput' => [ 'base' => '<p>The input structure representing Output Resolution for Stacking Operation.</p>', 'refs' => [ 'StackConfigInput$OutputResolution' => '<p>The structure representing output resolution (in target georeferenced units) of the result of stacking operation.</p>', ], ], 'OutputType' => [ 'base' => NULL, 'refs' => [ 'GetTileInput$OutputDataType' => '<p>The output data type of the tile operation.</p>', 'Operation$OutputType' => '<p>The type of the operation.</p>', 'OutputBand$OutputDataType' => '<p>The datatype of the output band.</p>', ], ], 'PlatformInput' => [ 'base' => '<p>The input structure for specifying Platform. Platform refers to the unique name of the specific platform the instrument is attached to. For satellites it is the name of the satellite, eg. landsat-8 (Landsat-8), sentinel-2a.</p>', 'refs' => [ 'Property$Platform' => '<p>The structure representing Platform property filter consisting of value and comparison operator.</p>', ], ], 'PolygonGeometryInput' => [ 'base' => '<p>The structure representing Polygon Geometry based on the <a href="https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6">GeoJson spec</a>.</p>', 'refs' => [ 'AreaOfInterestGeometry$PolygonGeometry' => '<p>The structure representing Polygon Geometry.</p>', ], ], 'Position' => [ 'base' => NULL, 'refs' => [ 'LinearRing$member' => NULL, ], ], 'PredefinedResolution' => [ 'base' => NULL, 'refs' => [ 'OutputResolutionStackInput$Predefined' => '<p>A string value representing Predefined Output Resolution for a stacking operation. Allowed values are <code>HIGHEST</code>, <code>LOWEST</code>, and <code>AVERAGE</code>.</p>', ], ], 'Properties' => [ 'base' => '<p>Properties associated with the Item.</p>', 'refs' => [ 'ItemSource$Properties' => '<p>This field contains additional properties of the item.</p>', ], ], 'Property' => [ 'base' => '<p>Represents a single searchable property to search on.</p>', 'refs' => [ 'PropertyFilter$Property' => '<p>Represents a single property to match with when searching a raster data collection.</p>', ], ], 'PropertyFilter' => [ 'base' => '<p>The structure representing a single PropertyFilter.</p>', 'refs' => [ 'PropertyFiltersList$member' => NULL, ], ], 'PropertyFilters' => [ 'base' => '<p>A list of PropertyFilter objects.</p>', 'refs' => [ 'RasterDataCollectionQueryInput$PropertyFilters' => '<p>The list of Property filters used in the Raster Data Collection Query.</p>', 'RasterDataCollectionQueryOutput$PropertyFilters' => '<p>Property filters used in the search.</p>', 'RasterDataCollectionQueryWithBandFilterInput$PropertyFilters' => '<p>The Property Filters used in the search query.</p>', ], ], 'PropertyFiltersList' => [ 'base' => NULL, 'refs' => [ 'PropertyFilters$Properties' => '<p>A list of Property Filters.</p>', ], ], 'RasterDataCollectionMetadata' => [ 'base' => '<p>Response object containing details for a specific RasterDataCollection.</p>', 'refs' => [ 'DataCollectionsList$member' => NULL, ], ], 'RasterDataCollectionQueryInput' => [ 'base' => '<p>The input structure for Raster Data Collection Query containing the Area of Interest, TimeRange Filters, and Property Filters.</p>', 'refs' => [ 'InputConfigInput$RasterDataCollectionQuery' => '<p>The structure representing the RasterDataCollection Query consisting of the Area of Interest, RasterDataCollectionArn,TimeRange and Property Filters.</p>', ], ], 'RasterDataCollectionQueryOutput' => [ 'base' => '<p>The output structure contains the Raster Data Collection Query input along with some additional metadata.</p>', 'refs' => [ 'InputConfigOutput$RasterDataCollectionQuery' => '<p>The structure representing the RasterDataCollection Query consisting of the Area of Interest, RasterDataCollectionArn, RasterDataCollectionName, TimeRange, and Property Filters.</p>', ], ], 'RasterDataCollectionQueryWithBandFilterInput' => [ 'base' => '<p>This is a RasterDataCollectionQueryInput containing AreaOfInterest, Time Range filter and Property filters.</p>', 'refs' => [ 'SearchRasterDataCollectionInput$RasterDataCollectionQuery' => '<p>RasterDataCollectionQuery consisting of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html">AreaOfInterest(AOI)</a>, <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html">PropertyFilters</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html">TimeRangeFilterInput</a> used in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html">SearchRasterDataCollection</a>.</p>', ], ], 'ResamplingConfigInput' => [ 'base' => '<p>The structure representing input for resampling operation.</p>', 'refs' => [ 'JobConfigInput$ResamplingConfig' => '<p>An object containing information about the job configuration for resampling.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource which does not exist.</p>', 'refs' => [], ], 'ReverseGeocodingConfig' => [ 'base' => '<p>The input structure for Reverse Geocoding operation type.</p>', 'refs' => [ 'VectorEnrichmentJobConfig$ReverseGeocodingConfig' => '<p>The input structure for Reverse Geocoding operation type.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'ExportS3DataInput$S3Uri' => '<p>The URL to the Amazon S3 data input.</p>', 'VectorEnrichmentJobS3Data$S3Uri' => '<p>The URL to the Amazon S3 data for the Vector Enrichment job.</p>', 'ZonalStatisticsConfigInput$ZoneS3Path' => '<p>The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.</p>', ], ], 'SearchRasterDataCollectionInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchRasterDataCollectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded the service quota.</p>', 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListEarthObservationJobInput$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', 'ListVectorEnrichmentJobInput$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', ], ], 'StackConfigInput' => [ 'base' => '<p>The input structure for Stacking Operation.</p>', 'refs' => [ 'JobConfigInput$StackConfig' => '<p>An object containing information about the job configuration for a Stacking Earth Observation job.</p>', ], ], 'StartEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartEarthObservationJobInputClientTokenString' => [ 'base' => NULL, 'refs' => [ 'StartEarthObservationJobInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'StartEarthObservationJobInputNameString' => [ 'base' => NULL, 'refs' => [ 'StartEarthObservationJobInput$Name' => '<p>The name of the Earth Observation job.</p>', ], ], 'StartEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartVectorEnrichmentJobInputClientTokenString' => [ 'base' => NULL, 'refs' => [ 'StartVectorEnrichmentJobInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'StartVectorEnrichmentJobInputNameString' => [ 'base' => NULL, 'refs' => [ 'StartVectorEnrichmentJobInput$Name' => '<p>The name of the Vector Enrichment job.</p>', ], ], 'StartVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopEarthObservationJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StopEarthObservationJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopVectorEnrichmentJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StopVectorEnrichmentJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AssetValue$Href' => '<p>Link to the asset object.</p>', 'AssetsMap$key' => NULL, 'CloudRemovalConfigInput$InterpolationValue' => '<p>The interpolation value you provide for cloud removal.</p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>Identifier of the resource affected.</p>', 'EarthObservationJobErrorDetails$Message' => '<p>A detailed message describing the error in an Earth Observation job.</p>', 'ExportErrorDetailsOutput$Message' => '<p>A detailed message describing the error in an export EarthObservationJob operation.</p>', 'Filter$Name' => '<p>The name of the filter.</p>', 'Filter$Type' => '<p>The type of the filter being used.</p>', 'Geometry$Type' => '<p>GeoJson Geometry types like Polygon and MultiPolygon.</p>', 'GetEarthObservationJobOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Earth Observation job.</p>', 'GetEarthObservationJobOutput$Name' => '<p>The name of the Earth Observation job.</p>', 'GetRasterDataCollectionOutput$Description' => '<p>A description of the raster data collection.</p>', 'GetRasterDataCollectionOutput$DescriptionPageUrl' => '<p>The URL of the description page.</p>', 'GetRasterDataCollectionOutput$Name' => '<p>The name of the raster data collection.</p>', 'GetTileInput$OutputFormat' => '<p>The data format of the output tile. The formats include .npy, .png and .jpg.</p>', 'GetTileInput$PropertyFilters' => '<p>Property filters for the imagery to tile.</p>', 'GetTileInput$TimeRangeFilter' => '<p>Time range filter applied to imagery to find the images to tile.</p>', 'GetVectorEnrichmentJobOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job.</p>', 'GetVectorEnrichmentJobOutput$Name' => '<p>The name of the Vector Enrichment job.</p>', 'ImageSourceBandList$member' => NULL, 'InternalServerException$Message' => NULL, 'InternalServerException$ResourceId' => '<p/>', 'ItemSource$Id' => '<p>A unique Id for the source item.</p>', 'ListEarthObservationJobInput$SortBy' => '<p>The parameter by which to sort the results.</p>', 'ListEarthObservationJobOutputConfig$Arn' => '<p>The Amazon Resource Name (ARN) of the list of the Earth Observation jobs.</p>', 'ListEarthObservationJobOutputConfig$Name' => '<p>The names of the Earth Observation jobs in the list.</p>', 'ListEarthObservationJobOutputConfig$OperationType' => '<p>The operation type for an Earth Observation job.</p>', 'ListVectorEnrichmentJobInput$SortBy' => '<p>The parameter by which to sort the results.</p>', 'ListVectorEnrichmentJobInput$StatusEquals' => '<p>A filter that retrieves only jobs with a specific status.</p>', 'ListVectorEnrichmentJobOutputConfig$Name' => '<p>The names of the Vector Enrichment jobs in the list.</p>', 'MapMatchingConfig$IdAttributeName' => '<p>The field name for the data that describes the identifier representing a collection of GPS points belonging to an individual trace.</p>', 'MapMatchingConfig$TimestampAttributeName' => '<p>The name of the timestamp attribute.</p>', 'MapMatchingConfig$XAttributeName' => '<p>The name of the X-attribute</p>', 'MapMatchingConfig$YAttributeName' => '<p>The name of the Y-attribute</p>', 'Operation$Equation' => '<p>Textual representation of the math operation; Equation used to compute the spectral index.</p>', 'Operation$Name' => '<p>The name of the operation.</p>', 'OutputBand$BandName' => '<p>The name of the band.</p>', 'PlatformInput$Value' => '<p>The value of the platform.</p>', 'Properties$Platform' => '<p>Platform property. Platform refers to the unique name of the specific platform the instrument is attached to. For satellites it is the name of the satellite, eg. landsat-8 (Landsat-8), sentinel-2a.</p>', 'RasterDataCollectionMetadata$Description' => '<p>A description of the raster data collection.</p>', 'RasterDataCollectionMetadata$DescriptionPageUrl' => '<p>The description URL of the raster data collection.</p>', 'RasterDataCollectionMetadata$Name' => '<p>The name of the raster data collection.</p>', 'RasterDataCollectionQueryOutput$RasterDataCollectionName' => '<p>The name of the raster data collection.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>Identifier of the resource that was not found.</p>', 'ReverseGeocodingConfig$XAttributeName' => '<p>The field name for the data that describes x-axis coordinate, eg. longitude of a point.</p>', 'ReverseGeocodingConfig$YAttributeName' => '<p>The field name for the data that describes y-axis coordinate, eg. latitude of a point.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$ResourceId' => '<p>Identifier of the resource affected.</p>', 'StartEarthObservationJobOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Earth Observation job.</p>', 'StartEarthObservationJobOutput$Name' => '<p>The name of the Earth Observation job.</p>', 'StartVectorEnrichmentJobOutput$Name' => '<p>The name of the Vector Enrichment job.</p>', 'StringListInput$member' => NULL, 'TagKeyList$member' => NULL, 'Tags$key' => NULL, 'Tags$value' => NULL, 'ThrottlingException$Message' => NULL, 'ThrottlingException$ResourceId' => '<p/>', 'ValidationException$Message' => NULL, 'ValidationException$ResourceId' => '<p/>', 'VectorEnrichmentJobErrorDetails$ErrorMessage' => '<p>A message that you define and then is processed and rendered by the Vector Enrichment job when the error occurs.</p>', 'VectorEnrichmentJobExportErrorDetails$Message' => '<p>The message providing details about the errors generated during the Vector Enrichment job.</p>', ], ], 'StringListInput' => [ 'base' => NULL, 'refs' => [ 'BandMathConfigInput$PredefinedIndices' => '<p>One or many of the supported predefined indices to compute. Allowed values: <code>NDVI</code>, <code>EVI2</code>, <code>MSAVI</code>, <code>NDWI</code>, <code>NDMI</code>, <code>NDSI</code>, and <code>WDRVI</code>.</p>', 'CloudRemovalConfigInput$TargetBands' => '<p>TargetBands to be returned in the output of CloudRemoval operation.</p>', 'GeoMosaicConfigInput$TargetBands' => '<p>The target bands for geomosaic.</p>', 'GetTileInput$ImageAssets' => '<p>The particular assets or bands to tile.</p>', 'RasterDataCollectionQueryWithBandFilterInput$BandFilter' => '<p>The list of Bands to be displayed in the result for each item.</p>', 'ResamplingConfigInput$TargetBands' => '<p>Bands used in the operation. If no target bands are specified, it uses all bands available in the input.</p>', 'StackConfigInput$TargetBands' => '<p>A list of bands to be stacked in the specified order. When the parameter is not provided, all the available bands in the data collection are stacked in the alphabetical order of their asset names.</p>', 'TemporalStatisticsConfigInput$TargetBands' => '<p>The list of target band names for the temporal statistic to calculate.</p>', 'ZonalStatisticsConfigInput$TargetBands' => '<p>Bands used in the operation. If no target bands are specified, it uses all bands available input.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'ExportEarthObservationJobOutput$CreationTime' => '<p>The creation time.</p>', 'ExportVectorEnrichmentJobOutput$CreationTime' => '<p>The creation time.</p>', 'GetEarthObservationJobOutput$CreationTime' => '<p>The creation time of the initiated Earth Observation job.</p>', 'GetVectorEnrichmentJobOutput$CreationTime' => '<p>The creation time.</p>', 'ListEarthObservationJobOutputConfig$CreationTime' => '<p>The creation time.</p>', 'ListVectorEnrichmentJobOutputConfig$CreationTime' => '<p>The creation time.</p>', 'StartEarthObservationJobOutput$CreationTime' => '<p>The creation time.</p>', 'StartVectorEnrichmentJobOutput$CreationTime' => '<p>The creation time.</p>', 'TimeRangeFilterOutput$EndTime' => '<p>The ending time for the time range filter.</p>', 'TimeRangeFilterOutput$StartTime' => '<p>The starting time for the time range filter.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Keys of the tags you want to remove.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'GetEarthObservationJobOutput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'GetRasterDataCollectionOutput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'GetVectorEnrichmentJobOutput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'ListEarthObservationJobOutputConfig$Tags' => '<p>Each tag consists of a key and a value.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Each tag consists of a key and a value.</p>', 'ListVectorEnrichmentJobOutputConfig$Tags' => '<p>Each tag consists of a key and a value.</p>', 'RasterDataCollectionMetadata$Tags' => '<p>Each tag consists of a key and a value.</p>', 'StartEarthObservationJobInput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'StartEarthObservationJobOutput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'StartVectorEnrichmentJobInput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'StartVectorEnrichmentJobOutput$Tags' => '<p>Each tag consists of a key and a value.</p>', 'TagResourceRequest$Tags' => '<p>Each tag consists of a key and a value.</p>', ], ], 'TargetOptions' => [ 'base' => NULL, 'refs' => [ 'GetTileInput$Target' => '<p>Determines what part of the Earth Observation job to tile. \'INPUT\' or \'OUTPUT\' are the valid options.</p>', ], ], 'TemporalStatistics' => [ 'base' => NULL, 'refs' => [ 'TemporalStatisticsListInput$member' => NULL, ], ], 'TemporalStatisticsConfigInput' => [ 'base' => '<p>The structure representing the configuration for Temporal Statistics operation.</p>', 'refs' => [ 'JobConfigInput$TemporalStatisticsConfig' => '<p>An object containing information about the job configuration for temporal statistics.</p>', ], ], 'TemporalStatisticsListInput' => [ 'base' => NULL, 'refs' => [ 'TemporalStatisticsConfigInput$Statistics' => '<p>The list of the statistics method options.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeRangeFilterInput' => [ 'base' => '<p>The input for the time-range filter.</p>', 'refs' => [ 'RasterDataCollectionQueryInput$TimeRangeFilter' => '<p>The TimeRange Filter used in the RasterDataCollection Query.</p>', 'RasterDataCollectionQueryWithBandFilterInput$TimeRangeFilter' => '<p>The TimeRange Filter used in the search query.</p>', ], ], 'TimeRangeFilterOutput' => [ 'base' => '<p>The output structure of the time range filter.</p>', 'refs' => [ 'RasterDataCollectionQueryOutput$TimeRangeFilter' => '<p>The TimeRange filter used in the search.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ItemSource$DateTime' => '<p>The searchable date and time of the item, in UTC.</p>', 'TimeRangeFilterInput$EndTime' => '<p>The end time for the time-range filter.</p>', 'TimeRangeFilterInput$StartTime' => '<p>The start time for the time-range filter.</p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'UserDefined$Unit' => '<p>The units for output resolution of the result.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserDefined' => [ 'base' => '<p>The output resolution (in target georeferenced units) of the result of the operation</p>', 'refs' => [ 'OutputResolutionResamplingInput$UserDefined' => '<p>User Defined Resolution for the output of Resampling operation defined by value and unit.</p>', 'OutputResolutionStackInput$UserDefined' => '<p>The structure representing User Output Resolution for a Stacking operation defined as a value and unit.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'VectorEnrichmentJobArn' => [ 'base' => NULL, 'refs' => [ 'DeleteVectorEnrichmentJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job being deleted.</p>', 'ExportVectorEnrichmentJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job.</p>', 'ExportVectorEnrichmentJobOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.</p>', 'GetVectorEnrichmentJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job.</p>', 'ListVectorEnrichmentJobOutputConfig$Arn' => '<p>The Amazon Resource Name (ARN) of the list of the Vector Enrichment jobs.</p>', 'StartVectorEnrichmentJobOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job.</p>', 'StopVectorEnrichmentJobInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Vector Enrichment job.</p>', ], ], 'VectorEnrichmentJobConfig' => [ 'base' => '<p>It contains configs such as ReverseGeocodingConfig and MapMatchingConfig.</p>', 'refs' => [ 'GetVectorEnrichmentJobOutput$JobConfig' => '<p>An object containing information about the job configuration.</p>', 'StartVectorEnrichmentJobInput$JobConfig' => '<p>An object containing information about the job configuration.</p>', 'StartVectorEnrichmentJobOutput$JobConfig' => '<p>An object containing information about the job configuration.</p>', ], ], 'VectorEnrichmentJobDataSourceConfigInput' => [ 'base' => '<p>The input structure for the data source that represents the storage type of the input data objects.</p>', 'refs' => [ 'VectorEnrichmentJobInputConfig$DataSourceConfig' => '<p>The input structure for the data source that represents the storage type of the input data objects.</p>', ], ], 'VectorEnrichmentJobDocumentType' => [ 'base' => NULL, 'refs' => [ 'VectorEnrichmentJobInputConfig$DocumentType' => '<p>The input structure that defines the data source file type.</p>', ], ], 'VectorEnrichmentJobErrorDetails' => [ 'base' => '<p>VectorEnrichmentJob error details in response from GetVectorEnrichmentJob.</p>', 'refs' => [ 'GetVectorEnrichmentJobOutput$ErrorDetails' => '<p>Details about the errors generated during the Vector Enrichment job.</p>', ], ], 'VectorEnrichmentJobErrorType' => [ 'base' => NULL, 'refs' => [ 'VectorEnrichmentJobErrorDetails$ErrorType' => '<p>The type of error generated during the Vector Enrichment job.</p>', ], ], 'VectorEnrichmentJobExportErrorDetails' => [ 'base' => '<p>VectorEnrichmentJob export error details in response from GetVectorEnrichmentJob.</p>', 'refs' => [ 'GetVectorEnrichmentJobOutput$ExportErrorDetails' => '<p>Details about the errors generated during the ExportVectorEnrichmentJob.</p>', ], ], 'VectorEnrichmentJobExportErrorType' => [ 'base' => NULL, 'refs' => [ 'VectorEnrichmentJobExportErrorDetails$Type' => '<p>The output error details for an Export operation on a Vector Enrichment job.</p>', ], ], 'VectorEnrichmentJobExportStatus' => [ 'base' => NULL, 'refs' => [ 'ExportVectorEnrichmentJobOutput$ExportStatus' => '<p>The status of the results the Vector Enrichment job being exported.</p>', 'GetVectorEnrichmentJobOutput$ExportStatus' => '<p>The export status of the Vector Enrichment job being initiated.</p>', ], ], 'VectorEnrichmentJobInputConfig' => [ 'base' => '<p>The input structure for the InputConfig in a VectorEnrichmentJob.</p>', 'refs' => [ 'GetVectorEnrichmentJobOutput$InputConfig' => '<p>Input configuration information for the Vector Enrichment job.</p>', 'StartVectorEnrichmentJobInput$InputConfig' => '<p>Input configuration information for the Vector Enrichment job.</p>', 'StartVectorEnrichmentJobOutput$InputConfig' => '<p>Input configuration information for starting the Vector Enrichment job.</p>', ], ], 'VectorEnrichmentJobList' => [ 'base' => NULL, 'refs' => [ 'ListVectorEnrichmentJobOutput$VectorEnrichmentJobSummaries' => '<p>Contains summary information about the Vector Enrichment jobs.</p>', ], ], 'VectorEnrichmentJobS3Data' => [ 'base' => '<p>The Amazon S3 data for the Vector Enrichment job.</p>', 'refs' => [ 'ExportVectorEnrichmentJobOutputConfig$S3Data' => '<p>The input structure for Amazon S3 data; representing the Amazon S3 location of the input data objects.</p>', 'VectorEnrichmentJobDataSourceConfigInput$S3Data' => '<p>The input structure for the Amazon S3 data that represents the Amazon S3 location of the input data objects.</p>', ], ], 'VectorEnrichmentJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetVectorEnrichmentJobOutput$Status' => '<p>The status of the initiated Vector Enrichment job.</p>', 'ListVectorEnrichmentJobOutputConfig$Status' => '<p>The status of the Vector Enrichment jobs list. </p>', 'StartVectorEnrichmentJobOutput$Status' => '<p>The status of the Vector Enrichment job being started.</p>', ], ], 'VectorEnrichmentJobType' => [ 'base' => NULL, 'refs' => [ 'GetVectorEnrichmentJobOutput$Type' => '<p>The type of the Vector Enrichment job being initiated.</p>', 'ListVectorEnrichmentJobOutputConfig$Type' => '<p>The type of the list of Vector Enrichment jobs.</p>', 'StartVectorEnrichmentJobOutput$Type' => '<p>The type of the Vector Enrichment job.</p>', ], ], 'ViewOffNadirInput' => [ 'base' => '<p>The input structure for specifying ViewOffNadir property filter. ViewOffNadir refers to the angle from the sensor between nadir (straight down) and the scene center. Measured in degrees (0-90).</p>', 'refs' => [ 'Property$ViewOffNadir' => '<p>The structure representing ViewOffNadir property filter containing a lower bound and upper bound.</p>', ], ], 'ViewSunAzimuthInput' => [ 'base' => '<p>The input structure for specifying ViewSunAzimuth property filter. ViewSunAzimuth refers to the Sun azimuth angle. From the scene center point on the ground, this is the angle between truth north and the sun. Measured clockwise in degrees (0-360).</p>', 'refs' => [ 'Property$ViewSunAzimuth' => '<p>The structure representing ViewSunAzimuth property filter containing a lower bound and upper bound.</p>', ], ], 'ViewSunElevationInput' => [ 'base' => '<p>The input structure for specifying ViewSunElevation angle property filter. </p>', 'refs' => [ 'Property$ViewSunElevation' => '<p>The structure representing ViewSunElevation property filter containing a lower bound and upper bound.</p>', ], ], 'ZonalStatistics' => [ 'base' => NULL, 'refs' => [ 'ZonalStatisticsListInput$member' => NULL, ], ], 'ZonalStatisticsConfigInput' => [ 'base' => '<p>The structure representing input configuration of ZonalStatistics operation.</p>', 'refs' => [ 'JobConfigInput$ZonalStatisticsConfig' => '<p>An object containing information about the job configuration for zonal statistics.</p>', ], ], 'ZonalStatisticsListInput' => [ 'base' => NULL, 'refs' => [ 'ZonalStatisticsConfigInput$Statistics' => '<p>List of zonal statistics to compute.</p>', ], ], ],];
