<?php
// This file was auto-generated from sdk-root/src/data/scheduler/2021-06-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon EventBridge Scheduler is a serverless scheduler that allows you to create, run, and manage tasks from one central, managed service. EventBridge Scheduler delivers your tasks reliably, with built-in mechanisms that adjust your schedules based on the availability of downstream targets. The following reference lists the available API actions, and data types for EventBridge Scheduler. </p>', 'operations' => [ 'CreateSchedule' => '<p>Creates the specified schedule.</p>', 'CreateScheduleGroup' => '<p>Creates the specified schedule group.</p>', 'DeleteSchedule' => '<p>Deletes the specified schedule.</p>', 'DeleteScheduleGroup' => '<p>Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group. When you delete a group, it remains in a <code>DELETING</code> state until all of its associated schedules are deleted. Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets until the schedule group and its associated schedules are deleted.</p> <note> <p> This operation is eventually consistent. </p> </note>', 'GetSchedule' => '<p>Retrieves the specified schedule.</p>', 'GetScheduleGroup' => '<p>Retrieves the specified schedule group.</p>', 'ListScheduleGroups' => '<p>Returns a paginated list of your schedule groups.</p>', 'ListSchedules' => '<p>Returns a paginated list of your EventBridge Scheduler schedules.</p>', 'ListTagsForResource' => '<p>Lists the tags associated with the Scheduler resource.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign tags to schedule groups.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified EventBridge Scheduler schedule group.</p>', 'UpdateSchedule' => '<p> Updates the specified schedule. When you call <code>UpdateSchedule</code>, EventBridge Scheduler uses all values, including empty values, specified in the request and overrides the existing schedule. This is by design. This means that if you do not set an optional field in your request, that field will be set to its system-default value after the update. </p> <p> Before calling this operation, we recommend that you call the <code>GetSchedule</code> API operation and make a note of all optional parameters for your <code>UpdateSchedule</code> call. </p>', ], 'shapes' => [ 'ActionAfterCompletion' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$ActionAfterCompletion' => '<p>Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.</p>', 'GetScheduleOutput$ActionAfterCompletion' => '<p>Indicates the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.</p>', 'UpdateScheduleInput$ActionAfterCompletion' => '<p>Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.</p>', ], ], 'AssignPublicIp' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$AssignPublicIp' => '<p>Specifies whether the task\'s elastic network interface receives a public IP address. You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>', ], ], 'AwsVpcConfiguration' => [ 'base' => '<p>This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.</p>', 'refs' => [ 'NetworkConfiguration$awsvpcConfiguration' => '<p>Specifies the Amazon VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode.</p>', ], ], 'CapacityProvider' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$capacityProvider' => '<p>The short name of the capacity provider.</p>', ], ], 'CapacityProviderStrategy' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$CapacityProviderStrategy' => '<p>The capacity provider strategy to use for the task.</p>', ], ], 'CapacityProviderStrategyItem' => [ 'base' => '<p>The details of a capacity provider strategy.</p>', 'refs' => [ 'CapacityProviderStrategy$member' => NULL, ], ], 'CapacityProviderStrategyItemBase' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$base' => '<p>The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of <code>0</code> is used.</p>', ], ], 'CapacityProviderStrategyItemWeight' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$weight' => '<p>The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleGroupInput$ClientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency. </p>', 'CreateScheduleInput$ClientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency. </p>', 'DeleteScheduleGroupInput$ClientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency. </p>', 'DeleteScheduleInput$ClientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency. </p>', 'UpdateScheduleInput$ClientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency. </p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting the resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CreateScheduleGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduleGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'GetScheduleGroupOutput$CreationDate' => '<p>The time at which the schedule group was created.</p>', 'GetScheduleOutput$CreationDate' => '<p>The time at which the schedule was created.</p>', 'ScheduleGroupSummary$CreationDate' => '<p>The time at which the schedule group was created.</p>', 'ScheduleSummary$CreationDate' => '<p>The time at which the schedule was created.</p>', ], ], 'DeadLetterConfig' => [ 'base' => '<p>An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.</p>', 'refs' => [ 'Target$DeadLetterConfig' => '<p>An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue.</p>', ], ], 'DeadLetterConfigArnString' => [ 'base' => NULL, 'refs' => [ 'DeadLetterConfig$Arn' => '<p>The Amazon Resource Name (ARN) of the SQS queue specified as the destination for the dead-letter queue.</p>', ], ], 'DeleteScheduleGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduleGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$Description' => '<p>The description you specify for the schedule.</p>', 'GetScheduleOutput$Description' => '<p>The description of the schedule.</p>', 'UpdateScheduleInput$Description' => '<p>The description you specify for the schedule.</p>', ], ], 'DetailType' => [ 'base' => NULL, 'refs' => [ 'EventBridgeParameters$DetailType' => '<p>A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.</p>', ], ], 'EcsParameters' => [ 'base' => '<p>The templated target type for the Amazon ECS <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a> API operation.</p>', 'refs' => [ 'Target$EcsParameters' => '<p>The templated target type for the Amazon ECS <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a> API operation.</p>', ], ], 'EnableECSManagedTags' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$EnableECSManagedTags' => '<p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon ECS Developer Guide</i>.</p>', ], ], 'EnableExecuteCommand' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$EnableExecuteCommand' => '<p>Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.</p>', ], ], 'EndDate' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$EndDate' => '<p>The date, in UTC, before which the schedule can invoke its target. Depending on the schedule\'s recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.</p>', 'GetScheduleOutput$EndDate' => '<p>The date, in UTC, before which the schedule can invoke its target. Depending on the schedule\'s recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.</p>', 'UpdateScheduleInput$EndDate' => '<p>The date, in UTC, before which the schedule can invoke its target. Depending on the schedule\'s recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.</p>', ], ], 'EventBridgeParameters' => [ 'base' => '<p>The templated target type for the EventBridge <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code> </a> API operation.</p>', 'refs' => [ 'Target$EventBridgeParameters' => '<p>The templated target type for the EventBridge <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code> </a> API operation.</p>', ], ], 'FlexibleTimeWindow' => [ 'base' => '<p>Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.</p>', 'refs' => [ 'CreateScheduleInput$FlexibleTimeWindow' => '<p>Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.</p>', 'GetScheduleOutput$FlexibleTimeWindow' => '<p>Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.</p>', 'UpdateScheduleInput$FlexibleTimeWindow' => '<p>Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.</p>', ], ], 'FlexibleTimeWindowMode' => [ 'base' => NULL, 'refs' => [ 'FlexibleTimeWindow$Mode' => '<p>Determines whether the schedule is invoked within a flexible time window.</p>', ], ], 'GetScheduleGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetScheduleGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'GetScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$Group' => '<p>Specifies an ECS task group for the task. The maximum length is 255 characters.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error encountered while processing the request.</p>', 'refs' => [], ], 'KinesisParameters' => [ 'base' => '<p>The templated target type for the Amazon Kinesis <a href="kinesis/latest/APIReference/API_PutRecord.html"> <code>PutRecord</code> </a> API operation.</p>', 'refs' => [ 'Target$KinesisParameters' => '<p>The templated target type for the Amazon Kinesis <a href="kinesis/latest/APIReference/API_PutRecord.html"> <code>PutRecord</code> </a> API operation.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.</p>', 'GetScheduleOutput$KmsKeyArn' => '<p>The ARN for a customer managed KMS Key that is be used to encrypt and decrypt your data.</p>', 'UpdateScheduleInput$KmsKeyArn' => '<p>The ARN for the customer managed KMS key that that you want EventBridge Scheduler to use to encrypt and decrypt your data.</p>', ], ], 'LastModificationDate' => [ 'base' => NULL, 'refs' => [ 'GetScheduleGroupOutput$LastModificationDate' => '<p>The time at which the schedule group was last modified.</p>', 'GetScheduleOutput$LastModificationDate' => '<p>The time at which the schedule was last modified.</p>', 'ScheduleGroupSummary$LastModificationDate' => '<p>The time at which the schedule group was last modified.</p>', 'ScheduleSummary$LastModificationDate' => '<p>The time at which the schedule was last modified.</p>', ], ], 'LaunchType' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$LaunchType' => '<p>Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html">AWS Fargate on Amazon ECS</a> in the <i>Amazon ECS Developer Guide</i>.</p>', ], ], 'ListScheduleGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduleGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchedulesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchedulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListScheduleGroupsInput$MaxResults' => '<p>If specified, limits the number of results returned by this operation. The operation also returns a <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListSchedulesInput$MaxResults' => '<p>If specified, limits the number of results returned by this operation. The operation also returns a <code>NextToken</code> which you can use in a subsequent operation to retrieve the next set of results.</p>', ], ], 'MaximumEventAgeInSeconds' => [ 'base' => NULL, 'refs' => [ 'RetryPolicy$MaximumEventAgeInSeconds' => '<p>The maximum amount of time, in seconds, to continue to make retry attempts.</p>', ], ], 'MaximumRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'RetryPolicy$MaximumRetryAttempts' => '<p>The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff continue until either the maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is reached.</p>', ], ], 'MaximumWindowInMinutes' => [ 'base' => NULL, 'refs' => [ 'FlexibleTimeWindow$MaximumWindowInMinutes' => '<p>The maximum time window during which a schedule can be invoked.</p>', ], ], 'MessageGroupId' => [ 'base' => NULL, 'refs' => [ 'SqsParameters$MessageGroupId' => '<p>The FIFO message group ID to use as the target.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$Name' => '<p>The name of the schedule that you are creating.</p>', 'DeleteScheduleInput$Name' => '<p>The name of the schedule to delete.</p>', 'GetScheduleInput$Name' => '<p>The name of the schedule to retrieve.</p>', 'GetScheduleOutput$Name' => '<p>The name of the schedule.</p>', 'ScheduleSummary$Name' => '<p>The name of the schedule.</p>', 'UpdateScheduleInput$Name' => '<p>The name of the schedule that you are updating.</p>', ], ], 'NamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListSchedulesInput$NamePrefix' => '<p>Schedule name prefix to return the filtered list of resources.</p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>Specifies the network configuration for an ECS task.</p>', 'refs' => [ 'EcsParameters$NetworkConfiguration' => '<p>This structure specifies the network configuration for an ECS task.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListScheduleGroupsInput$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListScheduleGroupsOutput$NextToken' => '<p>Indicates whether there are additional results to retrieve. If the value is null, there are no more results.</p>', 'ListSchedulesInput$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListSchedulesOutput$NextToken' => '<p>Indicates whether there are additional results to retrieve. If the value is null, there are no more results.</p>', ], ], 'PlacementConstraint' => [ 'base' => '<p>An object representing a constraint on task placement.</p>', 'refs' => [ 'PlacementConstraints$member' => NULL, ], ], 'PlacementConstraintExpression' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$expression' => '<p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <i>Amazon ECS Developer Guide</i>.</p>', ], ], 'PlacementConstraintType' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$type' => '<p>The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.</p>', ], ], 'PlacementConstraints' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PlacementConstraints' => '<p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).</p>', ], ], 'PlacementStrategies' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PlacementStrategy' => '<p>The task placement strategy for a task or service.</p>', ], ], 'PlacementStrategy' => [ 'base' => '<p>The task placement strategy for a task or service.</p>', 'refs' => [ 'PlacementStrategies$member' => NULL, ], ], 'PlacementStrategyField' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$field' => '<p>The field to apply the placement strategy against. For the spread placement strategy, valid values are <code>instanceId</code> (or <code>instanceId</code>, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as <code>attribute:ecs.availability-zone</code>. For the binpack placement strategy, valid values are <code>cpu</code> and <code>memory</code>. For the random placement strategy, this field is not used.</p>', ], ], 'PlacementStrategyType' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$type' => '<p>The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).</p>', ], ], 'PlatformVersion' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PlatformVersion' => '<p>Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as <code>1.1.0</code>.</p>', ], ], 'PropagateTags' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PropagateTags' => '<p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use Amazon ECS\'s <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html"> <code>TagResource</code> </a> API action. </p>', ], ], 'ReferenceId' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$ReferenceId' => '<p>The reference ID to use for the task.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource which does not exist.</p>', 'refs' => [], ], 'RetryPolicy' => [ 'base' => '<p>A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.</p>', 'refs' => [ 'Target$RetryPolicy' => '<p>A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'Target$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked.</p>', ], ], 'SageMakerPipelineParameter' => [ 'base' => '<p>The name and value pair of a parameter to use to start execution of a SageMaker Model Building Pipeline.</p>', 'refs' => [ 'SageMakerPipelineParameterList$member' => NULL, ], ], 'SageMakerPipelineParameterList' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameters$PipelineParameterList' => '<p>List of parameter names and values to use when executing the SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameterName' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Name' => '<p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameterValue' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Value' => '<p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameters' => [ 'base' => '<p>The templated target type for the Amazon SageMaker <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html"> <code>StartPipelineExecution</code> </a> API operation.</p>', 'refs' => [ 'Target$SageMakerPipelineParameters' => '<p>The templated target type for the Amazon SageMaker <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html"> <code>StartPipelineExecution</code> </a> API operation.</p>', ], ], 'ScheduleArn' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleOutput$ScheduleArn' => '<p>The Amazon Resource Name (ARN) of the schedule.</p>', 'GetScheduleOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the schedule.</p>', 'ScheduleSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the schedule.</p>', 'UpdateScheduleOutput$ScheduleArn' => '<p>The Amazon Resource Name (ARN) of the schedule that you updated.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$ScheduleExpression' => '<p> The expression that defines when the schedule runs. The following formats are supported. </p> <ul> <li> <p> <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code> </p> </li> <li> <p> <code>rate</code> expression - <code>rate(value unit)</code> </p> </li> <li> <p> <code>cron</code> expression - <code>cron(fields)</code> </p> </li> </ul> <p> You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month. </p> <p> A <code>cron</code> expression consists of six fields separated by white spaces: <code>(minutes hours day_of_month month day_of_week year)</code>. </p> <p> A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code> </p> <p> For more information and examples, see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>. </p>', 'GetScheduleOutput$ScheduleExpression' => '<p> The expression that defines when the schedule runs. The following formats are supported. </p> <ul> <li> <p> <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code> </p> </li> <li> <p> <code>rate</code> expression - <code>rate(value unit)</code> </p> </li> <li> <p> <code>cron</code> expression - <code>cron(fields)</code> </p> </li> </ul> <p> You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month. </p> <p> A <code>cron</code> expression consists of six fields separated by white spaces: <code>(minutes hours day_of_month month day_of_week year)</code>. </p> <p> A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code> </p> <p> For more information and examples, see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>. </p>', 'UpdateScheduleInput$ScheduleExpression' => '<p> The expression that defines when the schedule runs. The following formats are supported. </p> <ul> <li> <p> <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code> </p> </li> <li> <p> <code>rate</code> expression - <code>rate(value unit)</code> </p> </li> <li> <p> <code>cron</code> expression - <code>cron(fields)</code> </p> </li> </ul> <p> You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month. </p> <p> A <code>cron</code> expression consists of six fields separated by white spaces: <code>(minutes hours day_of_month month day_of_week year)</code>. </p> <p> A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code> </p> <p> For more information and examples, see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>. </p>', ], ], 'ScheduleExpressionTimezone' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$ScheduleExpressionTimezone' => '<p>The timezone in which the scheduling expression is evaluated.</p>', 'GetScheduleOutput$ScheduleExpressionTimezone' => '<p>The timezone in which the scheduling expression is evaluated.</p>', 'UpdateScheduleInput$ScheduleExpressionTimezone' => '<p>The timezone in which the scheduling expression is evaluated.</p>', ], ], 'ScheduleGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleGroupOutput$ScheduleGroupArn' => '<p>The Amazon Resource Name (ARN) of the schedule group.</p>', 'GetScheduleGroupOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the schedule group.</p>', 'ScheduleGroupSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the schedule group.</p>', ], ], 'ScheduleGroupList' => [ 'base' => NULL, 'refs' => [ 'ListScheduleGroupsOutput$ScheduleGroups' => '<p>The schedule groups that match the specified criteria.</p>', ], ], 'ScheduleGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleGroupInput$Name' => '<p>The name of the schedule group that you are creating.</p>', 'CreateScheduleInput$GroupName' => '<p>The name of the schedule group to associate with this schedule. If you omit this, the default schedule group is used.</p>', 'DeleteScheduleGroupInput$Name' => '<p>The name of the schedule group to delete.</p>', 'DeleteScheduleInput$GroupName' => '<p>The name of the schedule group associated with this schedule. If you omit this, the default schedule group is used.</p>', 'GetScheduleGroupInput$Name' => '<p>The name of the schedule group to retrieve.</p>', 'GetScheduleGroupOutput$Name' => '<p>The name of the schedule group.</p>', 'GetScheduleInput$GroupName' => '<p>The name of the schedule group associated with this schedule. If you omit this, EventBridge Scheduler assumes that the schedule is associated with the default group.</p>', 'GetScheduleOutput$GroupName' => '<p>The name of the schedule group associated with this schedule.</p>', 'ListSchedulesInput$GroupName' => '<p>If specified, only lists the schedules whose associated schedule group matches the given filter.</p>', 'ScheduleGroupSummary$Name' => '<p>The name of the schedule group.</p>', 'ScheduleSummary$GroupName' => '<p>The name of the schedule group associated with this schedule.</p>', 'UpdateScheduleInput$GroupName' => '<p>The name of the schedule group with which the schedule is associated. You must provide this value in order for EventBridge Scheduler to find the schedule you want to update. If you omit this value, EventBridge Scheduler assumes the group is associated to the default group.</p>', ], ], 'ScheduleGroupNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListScheduleGroupsInput$NamePrefix' => '<p>The name prefix that you can use to return a filtered list of your schedule groups.</p>', ], ], 'ScheduleGroupState' => [ 'base' => NULL, 'refs' => [ 'GetScheduleGroupOutput$State' => '<p>Specifies the state of the schedule group.</p>', 'ScheduleGroupSummary$State' => '<p>Specifies the state of the schedule group.</p>', ], ], 'ScheduleGroupSummary' => [ 'base' => '<p>The details of a schedule group.</p>', 'refs' => [ 'ScheduleGroupList$member' => NULL, ], ], 'ScheduleList' => [ 'base' => NULL, 'refs' => [ 'ListSchedulesOutput$Schedules' => '<p>The schedules that match the specified criteria.</p>', ], ], 'ScheduleState' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$State' => '<p>Specifies whether the schedule is enabled or disabled.</p>', 'GetScheduleOutput$State' => '<p>Specifies whether the schedule is enabled or disabled.</p>', 'ListSchedulesInput$State' => '<p>If specified, only lists the schedules whose current state matches the given filter.</p>', 'ScheduleSummary$State' => '<p>Specifies whether the schedule is enabled or disabled.</p>', 'UpdateScheduleInput$State' => '<p>Specifies whether the schedule is enabled or disabled.</p>', ], ], 'ScheduleSummary' => [ 'base' => '<p>The details of a schedule.</p>', 'refs' => [ 'ScheduleList$member' => NULL, ], ], 'SecurityGroup' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$SecurityGroups' => '<p>Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeds a service quota.</p>', 'refs' => [], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'EventBridgeParameters$Source' => '<p>The source of the event.</p>', ], ], 'SqsParameters' => [ 'base' => '<p>The templated target type for the Amazon SQS <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html"> <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>. </p>', 'refs' => [ 'Target$SqsParameters' => '<p>The templated target type for the Amazon SQS <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html"> <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.</p>', ], ], 'StartDate' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleInput$StartDate' => '<p>The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule\'s recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify. EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.</p>', 'GetScheduleOutput$StartDate' => '<p>The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule\'s recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify. EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.</p>', 'UpdateScheduleInput$StartDate' => '<p>The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule\'s recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify. EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Subnet' => [ 'base' => NULL, 'refs' => [ 'Subnets$member' => NULL, ], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$Subnets' => '<p>Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.</p>', ], ], 'Tag' => [ 'base' => '<p>Tag to associate with a schedule group.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the tag.</p>', 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateScheduleGroupInput$Tags' => '<p>The list of tags to associate with the schedule group.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The list of tags associated with the specified resource.</p>', 'TagResourceInput$Tags' => '<p>The list of tags to associate with the schedule group.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'Tags$member' => NULL, ], ], 'TagResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceArn' => '<p>The ARN of the EventBridge Scheduler resource for which you want to view tags.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the schedule group that you are adding tags to.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the schedule group from which you are removing tags.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the tag.</p>', 'TagMap$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$Tags' => '<p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a> in the <i>Amazon ECS API Reference</i>.</p>', ], ], 'Target' => [ 'base' => '<p>The schedule\'s target. EventBridge Scheduler supports templated target that invoke common API operations, as well as universal targets that you can customize to invoke over 6,000 API operations across more than 270 services. You can only specify one templated or universal target for a schedule.</p>', 'refs' => [ 'CreateScheduleInput$Target' => '<p>The schedule\'s target.</p>', 'GetScheduleOutput$Target' => '<p>The schedule target.</p>', 'UpdateScheduleInput$Target' => '<p>The schedule target. You can use this operation to change the target that your schedule invokes.</p>', ], ], 'TargetArn' => [ 'base' => NULL, 'refs' => [ 'Target$Arn' => '<p>The Amazon Resource Name (ARN) of the target.</p>', 'TargetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the target.</p>', ], ], 'TargetInput' => [ 'base' => NULL, 'refs' => [ 'Target$Input' => '<p>The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default notification to the target.</p>', ], ], 'TargetPartitionKey' => [ 'base' => NULL, 'refs' => [ 'KinesisParameters$PartitionKey' => '<p>Specifies the shard to which EventBridge Scheduler sends the event. For more information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html">Amazon Kinesis Data Streams terminology and concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.</p>', ], ], 'TargetSummary' => [ 'base' => '<p>The details of a target.</p>', 'refs' => [ 'ScheduleSummary$Target' => '<p>The schedule\'s target details.</p>', ], ], 'TaskCount' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$TaskCount' => '<p>The number of tasks to create based on <code>TaskDefinition</code>. The default is <code>1</code>.</p>', ], ], 'TaskDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$TaskDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the task definition to use if the event target is an Amazon ECS task.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], ],];
