<?php
// This file was auto-generated from sdk-root/src/data/securityhub/2018-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Security Hub provides you with a comprehensive view of your security state in Amazon Web Services and helps you assess your Amazon Web Services environment against security industry standards and best practices.</p> <p>Security Hub collects security data across Amazon Web Services accounts, Amazon Web Servicesservices, and supported third-party products and helps you analyze your security trends and identify the highest priority security issues.</p> <p>To help you manage the security state of your organization, Security Hub supports multiple security standards. These include the Amazon Web Services Foundational Security Best Practices (FSBP) standard developed by Amazon Web Services, and external compliance frameworks such as the Center for Internet Security (CIS), the Payment Card Industry Data Security Standard (PCI DSS), and the National Institute of Standards and Technology (NIST). Each standard includes several security controls, each of which represents a security best practice. Security Hub runs checks against security controls and generates control findings to help you assess your compliance against security best practices.</p> <p>In addition to generating control findings, Security Hub also receives findings from other Amazon Web Servicesservices, such as Amazon GuardDuty and Amazon Inspector, and supported third-party products. This gives you a single pane of glass into a variety of security-related issues. You can also send Security Hub findings to other Amazon Web Servicesservices and supported third-party products.</p> <p>Security Hub offers automation features that help you triage and remediate security issues. For example, you can use automation rules to automatically update critical findings when a security check fails. You can also leverage the integration with Amazon EventBridge to trigger automatic responses to specific findings.</p> <p>This guide, the <i>Security Hub API Reference</i>, provides information about the Security Hub API. This includes supported resources, HTTP methods, parameters, and schemas. If you\'re new to Security Hub, you might find it helpful to also review the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html"> <i>Security Hub User Guide</i> </a>. The user guide explains key concepts and provides procedures that demonstrate how to use Security Hub features. It also provides information about topics such as integrating Security Hub with other Amazon Web Servicesservices.</p> <p>In addition to interacting with Security Hub by making calls to the Security Hub API, you can use a current version of an Amazon Web Services command line tool or SDK. Amazon Web Services provides tools and SDKs that consist of libraries and sample code for various languages and platforms, such as PowerShell, Java, Go, Python, C++, and .NET. These tools and SDKs provide convenient, programmatic access to Security Hub and other Amazon Web Servicesservices . They also handle tasks such as signing requests, managing errors, and retrying requests automatically. For information about installing and using the Amazon Web Services tools and SDKs, see <a href="http://aws.amazon.com/developer/tools/">Tools to Build on Amazon Web Services</a>.</p> <p>With the exception of operations that are related to central configuration, Security Hub API requests are executed only in the Amazon Web Services Region that is currently active or in the specific Amazon Web Services Region that you specify in your request. Any configuration or settings change that results from the operation is applied only to that Region. To make the same change in other Regions, call the same API operation in each Region in which you want to apply the change. When you use central configuration, API requests for enabling Security Hub, standards, and controls are executed in the home Region and all linked Regions. For a list of central configuration operations, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html#central-configuration-concepts">Central configuration terms and concepts</a> section of the <i>Security Hub User Guide</i>.</p> <p>The following throttling limits apply to Security Hub API operations.</p> <ul> <li> <p> <code>BatchEnableStandards</code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 1 request per second.</p> </li> <li> <p> <code>GetFindings</code> - <code>RateLimit</code> of 3 requests per second. <code>BurstLimit</code> of 6 requests per second.</p> </li> <li> <p> <code>BatchImportFindings</code> - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per second.</p> </li> <li> <p> <code>BatchUpdateFindings</code> - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per second.</p> </li> <li> <p> <code>UpdateStandardsControl</code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 5 requests per second.</p> </li> <li> <p>All other operations - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per second.</p> </li> </ul>', 'operations' => [ 'AcceptAdministratorInvitation' => '<p>Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.</p> <p>This operation is only used by member accounts that are not added through Organizations.</p> <p>When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.</p>', 'AcceptInvitation' => '<p>This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.</p> <p>The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function must continue to use <code>AcceptInvitation</code>. You should also add <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>AcceptAdministratorInvitation</code>.</p> <p>Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.</p> <p>This operation is only used by member accounts that are not added through Organizations.</p> <p>When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.</p>', 'BatchDeleteAutomationRules' => '<p> Deletes one or more automation rules. </p>', 'BatchDisableStandards' => '<p>Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>Security Hub User Guide</i>.</p>', 'BatchEnableStandards' => '<p>Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use the <code>DescribeStandards</code> operation.</p> <p>For more information, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>Security Hub User Guide</i>.</p>', 'BatchGetAutomationRules' => '<p> Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs). </p>', 'BatchGetConfigurationPolicyAssociations' => '<p> Returns associations between an Security Hub configuration and a batch of target accounts, organizational units, or the root. Only the Security Hub delegated administrator can invoke this operation from the home Region. A configuration can refer to a configuration policy or to a self-managed configuration. </p>', 'BatchGetSecurityControls' => '<p> Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web Services Region. </p>', 'BatchGetStandardsControlAssociations' => '<p> For a batch of security controls and standards, identifies whether each control is currently enabled or disabled in a standard. </p>', 'BatchImportFindings' => '<p>Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.</p> <p> <code>BatchImportFindings</code> must be called by one of the following:</p> <ul> <li> <p>The Amazon Web Services account that is associated with a finding if you are using the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs">default product ARN</a> or are a partner sending findings from within a customer\'s Amazon Web Services account. In these cases, the identifier of the account that you are calling <code>BatchImportFindings</code> from needs to be the same as the <code>AwsAccountId</code> attribute for the finding.</p> </li> <li> <p>An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call <code>BatchImportFindings</code> from the allow-listed account and send findings from different customer accounts in the same batch.</p> </li> </ul> <p>The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.</p> <p>After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.</p> <ul> <li> <p> <code>Note</code> </p> </li> <li> <p> <code>UserDefinedFields</code> </p> </li> <li> <p> <code>VerificationState</code> </p> </li> <li> <p> <code>Workflow</code> </p> </li> </ul> <p>Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.</p> <ul> <li> <p> <code>Confidence</code> </p> </li> <li> <p> <code>Criticality</code> </p> </li> <li> <p> <code>RelatedFindings</code> </p> </li> <li> <p> <code>Severity</code> </p> </li> <li> <p> <code>Types</code> </p> </li> </ul> <p>Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.</p>', 'BatchUpdateAutomationRules' => '<p> Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters. </p>', 'BatchUpdateFindings' => '<p>Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.</p> <p>Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.</p> <p>Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields and objects.</p> <ul> <li> <p> <code>Confidence</code> </p> </li> <li> <p> <code>Criticality</code> </p> </li> <li> <p> <code>Note</code> </p> </li> <li> <p> <code>RelatedFindings</code> </p> </li> <li> <p> <code>Severity</code> </p> </li> <li> <p> <code>Types</code> </p> </li> <li> <p> <code>UserDefinedFields</code> </p> </li> <li> <p> <code>VerificationState</code> </p> </li> <li> <p> <code>Workflow</code> </p> </li> </ul> <p>You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access">Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.</p>', 'BatchUpdateStandardsControlAssociations' => '<p> For a batch of security controls and standards, this operation updates the enablement status of a control in a standard. </p>', 'CreateActionTarget' => '<p>Creates a custom action target in Security Hub.</p> <p>You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.</p>', 'CreateAutomationRule' => '<p> Creates an automation rule based on input parameters. </p>', 'CreateConfigurationPolicy' => '<p> Creates a configuration policy with the defined configuration. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'CreateFindingAggregator' => '<p>Used to enable finding aggregation. Must be called from the aggregation Region.</p> <p>For more details about cross-Region replication, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html">Configuring finding aggregation</a> in the <i>Security Hub User Guide</i>. </p>', 'CreateInsight' => '<p>Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.</p> <p>To group the related findings in the insight, use the <code>GroupByAttribute</code>.</p>', 'CreateMembers' => '<p>Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.</p> <p> <code>CreateMembers</code> is always used to add accounts that are not organization members.</p> <p>For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following cases:</p> <ul> <li> <p>Security Hub is not configured to automatically add new organization accounts.</p> </li> <li> <p>The account was disassociated or deleted in Security Hub.</p> </li> </ul> <p>This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the <code>EnableSecurityHub</code> operation.</p> <p>For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.</p> <p>Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.</p> <ul> <li> <p>If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.</p> </li> <li> <p>For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.</p> </li> </ul> <p>A permissions policy is added that permits the administrator account to view the findings generated in the member account.</p> <p>To remove the association between the administrator and member accounts, use the <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.</p>', 'DeclineInvitations' => '<p>Declines invitations to become a member account.</p> <p>A prospective member account uses this operation to decline an invitation to become a member.</p> <p>This operation is only called by member accounts that aren\'t part of an organization. Organization accounts don\'t receive invitations.</p>', 'DeleteActionTarget' => '<p>Deletes a custom action target from Security Hub.</p> <p>Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.</p>', 'DeleteConfigurationPolicy' => '<p> Deletes a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the home Region. For the deletion to succeed, you must first disassociate a configuration policy from target accounts, organizational units, or the root by invoking the <code>StartConfigurationPolicyDisassociation</code> operation. </p>', 'DeleteFindingAggregator' => '<p>Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.</p> <p>When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated. </p>', 'DeleteInsight' => '<p>Deletes the insight specified by the <code>InsightArn</code>.</p>', 'DeleteInvitations' => '<p>Deletes invitations received by the Amazon Web Services account to become a member account.</p> <p>A Security Hub administrator account can use this operation to delete invitations sent to one or more member accounts.</p> <p>This operation is only used to delete invitations that are sent to member accounts that aren\'t part of an organization. Organization accounts don\'t receive invitations.</p>', 'DeleteMembers' => '<p>Deletes the specified member accounts from Security Hub.</p> <p>You can invoke this API only to delete accounts that became members through invitation. You can\'t invoke this API to delete accounts that belong to an Organizations organization.</p>', 'DescribeActionTargets' => '<p>Returns a list of the custom action targets in Security Hub in your account.</p>', 'DescribeHub' => '<p>Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you enabled Security Hub.</p>', 'DescribeOrganizationConfiguration' => '<p>Returns information about the way your organization is configured in Security Hub. Only the Security Hub administrator account can invoke this operation.</p>', 'DescribeProducts' => '<p>Returns information about product integrations in Security Hub.</p> <p>You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.</p> <p>If you do not provide an integration ARN, then the results include all of the available product integrations. </p>', 'DescribeStandards' => '<p>Returns a list of the available standards in Security Hub.</p> <p>For each standard, the results include the standard ARN, the name, and a description. </p>', 'DescribeStandardsControls' => '<p>Returns a list of security standards controls.</p> <p>For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.</p>', 'DisableImportFindingsForProduct' => '<p>Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.</p>', 'DisableOrganizationAdminAccount' => '<p>Disables a Security Hub administrator account. Can only be called by the organization management account.</p>', 'DisableSecurityHub' => '<p>Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.</p> <p>You can\'t disable Security Hub in an account that is currently the Security Hub administrator.</p> <p>When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.</p> <p>If you want to save your existing findings, you must export them before you disable Security Hub.</p>', 'DisassociateFromAdministratorAccount' => '<p>Disassociates the current Security Hub member account from the associated administrator account.</p> <p>This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.</p>', 'DisassociateFromMasterAccount' => '<p>This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.</p> <p>The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.</p> <p>Disassociates the current Security Hub member account from the associated administrator account.</p> <p>This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.</p>', 'DisassociateMembers' => '<p>Disassociates the specified member accounts from the associated administrator account.</p> <p>Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.</p>', 'EnableImportFindingsForProduct' => '<p>Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.</p> <p>When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.</p>', 'EnableOrganizationAdminAccount' => '<p>Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.</p>', 'EnableSecurityHub' => '<p>Enables Security Hub for your account in the current Region or the Region you specify in the request.</p> <p>When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.</p> <p>When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable the following standards:</p> <ul> <li> <p>Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0</p> </li> <li> <p>Amazon Web Services Foundational Security Best Practices</p> </li> </ul> <p>Other standards are not automatically enabled. </p> <p>To opt out of automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p> <p>After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To disable a standard, use the <code>BatchDisableStandards</code> operation.</p> <p>To learn more, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a> in the <i>Security Hub User Guide</i>.</p>', 'GetAdministratorAccount' => '<p>Provides the details for the Security Hub administrator account for the current member account.</p> <p>Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.</p>', 'GetConfigurationPolicy' => '<p> Provides information about a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'GetConfigurationPolicyAssociation' => '<p> Returns the association between a configuration and a target account, organizational unit, or the root. The configuration can be a configuration policy or self-managed behavior. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'GetEnabledStandards' => '<p>Returns a list of the standards that are currently enabled.</p>', 'GetFindingAggregator' => '<p>Returns the current finding aggregation configuration.</p>', 'GetFindingHistory' => '<p> Returns history for a Security Hub finding in the last 90 days. The history includes changes made to any fields in the Amazon Web Services Security Finding Format (ASFF). </p>', 'GetFindings' => '<p>Returns a list of findings that match the specified criteria.</p> <p>If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.</p>', 'GetInsightResults' => '<p>Lists the results of the Security Hub insight specified by the insight ARN.</p>', 'GetInsights' => '<p>Lists and describes insights for the specified insight ARNs.</p>', 'GetInvitationsCount' => '<p>Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation. </p>', 'GetMasterAccount' => '<p>This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.</p> <p>The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your policies to ensure that the correct permissions are in place after the console begins to use <code>GetAdministratorAccount</code>.</p> <p>Provides the details for the Security Hub administrator account for the current member account.</p> <p>Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.</p>', 'GetMembers' => '<p>Returns the details for the Security Hub member accounts for the specified account IDs.</p> <p>An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.</p> <p>The results include both member accounts that are managed using Organizations and accounts that were invited manually.</p>', 'GetSecurityControlDefinition' => '<p> Retrieves the definition of a security control. The definition includes the control title, description, Region availability, parameter definitions, and other details. </p>', 'InviteMembers' => '<p>Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.</p> <p>This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.</p> <p>Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to create the member account in Security Hub.</p> <p>When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.</p>', 'ListAutomationRules' => '<p> A list of automation rules and their metadata for the calling account. </p>', 'ListConfigurationPolicies' => '<p> Lists the configuration policies that the Security Hub delegated administrator has created for your organization. Only the delegated administrator can invoke this operation from the home Region. </p>', 'ListConfigurationPolicyAssociations' => '<p> Provides information about the associations for your configuration policies and self-managed behavior. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'ListEnabledProductsForImport' => '<p>Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.</p>', 'ListFindingAggregators' => '<p>If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding aggregator. You can run this operation from any Region.</p>', 'ListInvitations' => '<p>Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.</p> <p>This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.</p>', 'ListMembers' => '<p>Lists details about all member accounts for the current Security Hub administrator account.</p> <p>The results include both member accounts that belong to an organization and member accounts that were invited manually.</p>', 'ListOrganizationAdminAccounts' => '<p>Lists the Security Hub administrator accounts. Can only be called by the organization management account.</p>', 'ListSecurityControlDefinitions' => '<p> Lists all of the security controls that apply to a specified standard. </p>', 'ListStandardsControlAssociations' => '<p> Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account. </p>', 'ListTagsForResource' => '<p>Returns a list of tags associated with a resource.</p>', 'StartConfigurationPolicyAssociation' => '<p> Associates a target account, organizational unit, or the root with a specified configuration. The target can be associated with a configuration policy or self-managed behavior. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'StartConfigurationPolicyDisassociation' => '<p> Disassociates a target account, organizational unit, or the root from a specified configuration. When you disassociate a configuration from its target, the target inherits the configuration of the closest parent. If there’s no configuration to inherit, the target retains its settings but becomes a self-managed account. A target can be disassociated from a configuration policy or self-managed behavior. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'TagResource' => '<p>Adds one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes one or more tags from a resource.</p>', 'UpdateActionTarget' => '<p>Updates the name and description of a custom action target in Security Hub.</p>', 'UpdateConfigurationPolicy' => '<p> Updates a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the home Region. </p>', 'UpdateFindingAggregator' => '<p>Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use <code>UpdateFindingAggregator</code> to change the aggregation Region.</p> <p>You must run <code>UpdateFindingAggregator</code> from the current aggregation Region. </p>', 'UpdateFindings' => '<p> <code>UpdateFindings</code> is a deprecated operation. Instead of <code>UpdateFindings</code>, use the <code>BatchUpdateFindings</code> operation.</p> <p>The <code>UpdateFindings</code> operation updates the <code>Note</code> and <code>RecordState</code> of the Security Hub aggregated findings that the filter attributes specify. Any member account that can view the finding can also see the update to the finding.</p> <p>Finding updates made with <code>UpdateFindings</code> aren\'t persisted if the same finding is later updated by the finding provider through the <code>BatchImportFindings</code> operation. In addition, Security Hub doesn\'t record updates made with <code>UpdateFindings</code> in the finding history.</p>', 'UpdateInsight' => '<p>Updates the Security Hub insight identified by the specified insight ARN.</p>', 'UpdateOrganizationConfiguration' => '<p>Updates the configuration of your organization in Security Hub. Only the Security Hub administrator account can invoke this operation.</p>', 'UpdateSecurityControl' => '<p> Updates the properties of a security control. </p>', 'UpdateSecurityHubConfiguration' => '<p>Updates configuration options for Security Hub.</p>', 'UpdateStandardsControl' => '<p>Used to control whether an individual security standard control is enabled or disabled.</p>', ], 'shapes' => [ 'AcceptAdministratorInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptAdministratorInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AcceptInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permission to perform the action specified in the request.</p>', 'refs' => [], ], 'AccountDetails' => [ 'base' => '<p>The details of an Amazon Web Services account.</p>', 'refs' => [ 'AccountDetailsList$member' => NULL, ], ], 'AccountDetailsList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$AccountDetails' => '<p>The list of accounts to associate with the Security Hub administrator account. For each account, the list includes the account ID and optionally the email address.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$AccountId' => '<p>The ID of an Amazon Web Services account.</p>', 'Invitation$AccountId' => '<p>The account ID of the Security Hub administrator account that the invitation was sent from.</p>', 'Member$AccountId' => '<p>The Amazon Web Services account ID of the member account.</p>', 'Result$AccountId' => '<p>An Amazon Web Services account ID of the account that was not processed.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DeclineInvitationsRequest$AccountIds' => '<p>The list of prospective member account IDs for which to decline an invitation.</p>', 'DeleteInvitationsRequest$AccountIds' => '<p>The list of member account IDs that received the invitations you want to delete.</p>', 'DeleteMembersRequest$AccountIds' => '<p>The list of account IDs for the member accounts to delete.</p>', 'DisassociateMembersRequest$AccountIds' => '<p>The account IDs of the member accounts to disassociate from the administrator account.</p>', 'GetMembersRequest$AccountIds' => '<p>The list of account IDs for the Security Hub member accounts to return the details for. </p>', 'InviteMembersRequest$AccountIds' => '<p>The list of account IDs of the Amazon Web Services accounts to invite to Security Hub as members. </p>', ], ], 'Action' => [ 'base' => '<p>Provides details about one of the following actions that affects or that was taken on a resource:</p> <ul> <li> <p>A remote IP address issued an Amazon Web Services API call</p> </li> <li> <p>A DNS request was received</p> </li> <li> <p>A remote IP address attempted to connect to an EC2 instance</p> </li> <li> <p>A remote IP address attempted a port probe on an EC2 instance</p> </li> </ul>', 'refs' => [ 'AwsSecurityFinding$Action' => '<p>Provides details about an action that affects or that was taken on a resource.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesConfig$Actions' => '<p> One or more actions to update finding fields if a finding matches the defined criteria of the rule. </p>', 'CreateAutomationRuleRequest$Actions' => '<p> One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code>. </p>', 'UpdateAutomationRulesRequestItem$Actions' => '<p> One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code>. </p>', ], ], 'ActionLocalIpDetails' => [ 'base' => '<p>Provides information about the IP address where the scanned port is located.</p>', 'refs' => [ 'PortProbeDetail$LocalIpDetails' => '<p>Provides information about the IP address where the scanned port is located.</p>', ], ], 'ActionLocalPortDetails' => [ 'base' => '<p>For <code>NetworkConnectionAction</code> and <code>PortProbeDetails</code>, <code>LocalPortDetails</code> provides information about the local port that was involved in the action.</p>', 'refs' => [ 'NetworkConnectionAction$LocalPortDetails' => '<p>Information about the port on the EC2 instance.</p>', 'PortProbeDetail$LocalPortDetails' => '<p>Provides information about the port that was scanned.</p>', ], ], 'ActionRemoteIpDetails' => [ 'base' => '<p>For <code>AwsApiAction</code>, <code>NetworkConnectionAction</code>, and <code>PortProbeAction</code>, <code>RemoteIpDetails</code> provides information about the remote IP address that was involved in the action.</p>', 'refs' => [ 'AwsApiCallAction$RemoteIpDetails' => '<p>Provided if <code>CallerType</code> is <code>remoteIp</code>. Provides information about the remote IP address that the API call originated from.</p>', 'NetworkConnectionAction$RemoteIpDetails' => '<p>Information about the remote IP address that issued the network connection request.</p>', 'PortProbeDetail$RemoteIpDetails' => '<p>Provides information about the remote IP address that performed the scan.</p>', ], ], 'ActionRemotePortDetails' => [ 'base' => '<p>Provides information about the remote port that was involved in an attempted network connection.</p>', 'refs' => [ 'NetworkConnectionAction$RemotePortDetails' => '<p>Information about the port on the remote IP address.</p>', ], ], 'ActionTarget' => [ 'base' => '<p>An <code>ActionTarget</code> object.</p>', 'refs' => [ 'ActionTargetList$member' => NULL, ], ], 'ActionTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsResponse$ActionTargets' => '<p>A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>, <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.</p>', ], ], 'Adjustment' => [ 'base' => '<p>An adjustment to the CVSS metric.</p>', 'refs' => [ 'AdjustmentList$member' => NULL, ], ], 'AdjustmentList' => [ 'base' => NULL, 'refs' => [ 'Cvss$Adjustments' => '<p>Adjustments to the CVSS metrics.</p>', ], ], 'AdminAccount' => [ 'base' => '<p>Represents a Security Hub administrator account designated by an organization management account.</p>', 'refs' => [ 'AdminAccounts$member' => NULL, ], ], 'AdminAccounts' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationAdminAccountsResponse$AdminAccounts' => '<p>The list of Security Hub administrator accounts.</p>', ], ], 'AdminStatus' => [ 'base' => NULL, 'refs' => [ 'AdminAccount$Status' => '<p>The current status of the Security Hub administrator account. Indicates whether the account is currently enabled as a Security Hub administrator.</p>', ], ], 'AdminsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationAdminAccountsRequest$MaxResults' => '<p>The maximum number of items to return in the response.</p>', ], ], 'AlphaNumericNonEmptyString' => [ 'base' => NULL, 'refs' => [ 'SecurityControl$LastUpdateReason' => '<p> The most recent reason for updating the customizable properties of a security control. This differs from the <code>UpdateReason</code> field of the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"> <code>BatchUpdateStandardsControlAssociations</code> </a> API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores. </p>', 'UpdateSecurityControlRequest$LastUpdateReason' => '<p> The most recent reason for updating the properties of the security control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores. </p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$ActionTargetArns' => '<p>A list of custom action target ARNs for the custom action targets to retrieve.</p>', 'GetInsightsRequest$InsightArns' => '<p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.</p>', ], ], 'AssociatedStandard' => [ 'base' => '<p> Information about an enabled security standard in which a security control is enabled. </p>', 'refs' => [ 'AssociatedStandardsList$member' => NULL, ], ], 'AssociatedStandardsList' => [ 'base' => NULL, 'refs' => [ 'Compliance$AssociatedStandards' => '<p>The enabled security standards in which a security control is currently enabled. </p>', ], ], 'AssociationFilters' => [ 'base' => '<p> Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration policy, <code>AssociationType</code>, or <code>AssociationStatus</code>. </p>', 'refs' => [ 'ListConfigurationPolicyAssociationsRequest$Filters' => '<p> Options for filtering the <code>ListConfigurationPolicyAssociations</code> response. You can filter by the Amazon Resource Name (ARN) or universally unique identifier (UUID) of a configuration, <code>AssociationType</code>, or <code>AssociationStatus</code>. </p>', ], ], 'AssociationSetDetails' => [ 'base' => '<p> The associations between a route table and one or more subnets or a gateway. </p>', 'refs' => [ 'AssociationSetList$member' => NULL, ], ], 'AssociationSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2RouteTableDetails$AssociationSet' => '<p> The associations between a route table and one or more subnets or a gateway. </p>', ], ], 'AssociationStateDetails' => [ 'base' => '<p> Describes the state of an association between a route table and a subnet or gateway. </p>', 'refs' => [ 'AssociationSetDetails$AssociationState' => '<p> The state of the association between a route table and a subnet or gateway. </p>', ], ], 'AssociationStatus' => [ 'base' => NULL, 'refs' => [ 'StandardsControlAssociationDetail$AssociationStatus' => '<p> Specifies whether a control is enabled or disabled in a specified standard. </p>', 'StandardsControlAssociationSummary$AssociationStatus' => '<p> The enablement status of a control in a specific standard. </p>', 'StandardsControlAssociationUpdate$AssociationStatus' => '<p>The desired enablement status of the control in the standard.</p>', ], ], 'AssociationType' => [ 'base' => NULL, 'refs' => [ 'AssociationFilters$AssociationType' => '<p> Indicates whether the association between a target and a configuration was directly applied by the Security Hub delegated administrator or inherited from a parent. </p>', 'ConfigurationPolicyAssociationSummary$AssociationType' => '<p> Indicates whether the association between the specified target and the configuration was directly applied by the Security Hub delegated administrator or inherited from a parent. </p>', 'GetConfigurationPolicyAssociationResponse$AssociationType' => '<p> Indicates whether the association between the specified target and the configuration was directly applied by the Security Hub delegated administrator or inherited from a parent. </p>', 'StartConfigurationPolicyAssociationResponse$AssociationType' => '<p> Indicates whether the association between the specified target and the configuration was directly applied by the Security Hub delegated administrator or inherited from a parent. </p>', ], ], 'AutoEnableStandards' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigurationResponse$AutoEnableStandards' => '<p>Whether to automatically enable Security Hub <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default standards</a> in new member accounts when they join the organization.</p> <p>If equal to <code>DEFAULT</code>, then Security Hub default standards are automatically enabled for new member accounts. If equal to <code>NONE</code>, then default standards are not automatically enabled for new member accounts. The default value of this parameter is equal to <code>DEFAULT</code>.</p> <p>If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code>, then this field is set to <code>NONE</code> and can\'t be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which specific security standards are enabled and associate the policy with new organization accounts.</p>', 'UpdateOrganizationConfigurationRequest$AutoEnableStandards' => '<p>Whether to automatically enable Security Hub <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default standards</a> in new member accounts when they join the organization.</p> <p>The default value of this parameter is equal to <code>DEFAULT</code>.</p> <p>If equal to <code>DEFAULT</code>, then Security Hub default standards are automatically enabled for new member accounts. If equal to <code>NONE</code>, then default standards are not automatically enabled for new member accounts.</p> <p>If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code>, then this field is set to <code>NONE</code> and can\'t be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which specific security standards are enabled and associate the policy with new organization accounts.</p>', ], ], 'AutomationRulesAction' => [ 'base' => '<p> One or more actions to update finding fields if a finding matches the defined criteria of the rule. </p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'AutomationRulesActionType' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesAction$Type' => '<p> Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code> finding field classifies findings in the format of namespace/category/classifier. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html">Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>. </p>', ], ], 'AutomationRulesArnsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteAutomationRulesRequest$AutomationRulesArns' => '<p> A list of Amazon Resource Names (ARNs) for the rules that are to be deleted. </p>', 'BatchDeleteAutomationRulesResponse$ProcessedAutomationRules' => '<p> A list of properly processed rule ARNs. </p>', 'BatchGetAutomationRulesRequest$AutomationRulesArns' => '<p> A list of rule ARNs to get details for. </p>', 'BatchUpdateAutomationRulesResponse$ProcessedAutomationRules' => '<p> A list of properly processed rule ARNs. </p>', ], ], 'AutomationRulesConfig' => [ 'base' => '<p> Defines the configuration of an automation rule. </p>', 'refs' => [ 'AutomationRulesConfigList$member' => NULL, ], ], 'AutomationRulesConfigList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAutomationRulesResponse$Rules' => '<p> A list of rule details for the provided rule ARNs. </p>', ], ], 'AutomationRulesFindingFieldsUpdate' => [ 'base' => '<p> Identifies the finding fields that the automation rule action updates when a finding matches the defined criteria. </p>', 'refs' => [ 'AutomationRulesAction$FindingFieldsUpdate' => '<p> Specifies that the automation rule action is an update to a finding field. </p>', ], ], 'AutomationRulesFindingFilters' => [ 'base' => '<p> The criteria that determine which findings a rule applies to. </p>', 'refs' => [ 'AutomationRulesConfig$Criteria' => '<p> A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding. </p>', 'CreateAutomationRuleRequest$Criteria' => '<p> A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding. </p>', 'UpdateAutomationRulesRequestItem$Criteria' => '<p> A set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding. </p>', ], ], 'AutomationRulesMetadata' => [ 'base' => '<p> Metadata for automation rules in the calling account. The response includes rules with a <code>RuleStatus</code> of <code>ENABLED</code> and <code>DISABLED</code>. </p>', 'refs' => [ 'AutomationRulesMetadataList$member' => NULL, ], ], 'AutomationRulesMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListAutomationRulesResponse$AutomationRulesMetadata' => '<p> Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of <code>ENABLED</code> and <code>DISABLED</code>. </p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Information about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'AwsElbv2LoadBalancerDetails$AvailabilityZones' => '<p>The Availability Zones for the load balancer.</p>', ], ], 'AwsAmazonMqBrokerDetails' => [ 'base' => '<p> Provides details about an Amazon MQ message broker. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols. </p>', 'refs' => [ 'ResourceDetails$AwsAmazonMqBroker' => '<p> Provides details about AppSync message broker. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols. </p>', ], ], 'AwsAmazonMqBrokerEncryptionOptionsDetails' => [ 'base' => '<p> Provides details about broker encryption options. </p>', 'refs' => [ 'AwsAmazonMqBrokerDetails$EncryptionOptions' => '<p> Encryption options for the broker. Doesn’t apply to RabbitMQ brokers. </p>', ], ], 'AwsAmazonMqBrokerLdapServerMetadataDetails' => [ 'base' => '<p> The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize connections to the broker. This is an optional failover server. </p>', 'refs' => [ 'AwsAmazonMqBrokerDetails$LdapServerMetadata' => '<p> The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize connections to the broker. This is an optional failover server. </p>', ], ], 'AwsAmazonMqBrokerLogsDetails' => [ 'base' => '<p> Provides information about logs to be activated for the specified broker. </p>', 'refs' => [ 'AwsAmazonMqBrokerDetails$Logs' => '<p> Turns on Amazon CloudWatch logging for brokers. </p>', ], ], 'AwsAmazonMqBrokerLogsPendingDetails' => [ 'base' => '<p> Provides information about logs to be activated for the specified broker. </p>', 'refs' => [ 'AwsAmazonMqBrokerLogsDetails$Pending' => '<p> The list of information about logs that are to be turned on for the specified broker. </p>', ], ], 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails' => [ 'base' => '<p> The scheduled time period (UTC) during which Amazon MQ begins to apply pending updates or patches to the broker. </p>', 'refs' => [ 'AwsAmazonMqBrokerDetails$MaintenanceWindowStartTime' => '<p> The scheduled time period (UTC) during which Amazon MQ begins to apply pending updates or patches to the broker. </p>', ], ], 'AwsAmazonMqBrokerUsersDetails' => [ 'base' => '<p> Provides details about the broker usernames for the specified broker. Doesn\'t apply to RabbitMQ brokers. </p>', 'refs' => [ 'AwsAmazonMqBrokerUsersList$member' => NULL, ], ], 'AwsAmazonMqBrokerUsersList' => [ 'base' => NULL, 'refs' => [ 'AwsAmazonMqBrokerDetails$Users' => '<p> The list of all broker usernames for the specified broker. Doesn\'t apply to RabbitMQ brokers. </p>', ], ], 'AwsApiCallAction' => [ 'base' => '<p>Provided if <code>ActionType</code> is <code>AWS_API_CALL</code>. It provides details about the API call that was detected.</p>', 'refs' => [ 'Action$AwsApiCallAction' => '<p>Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call that was detected. </p>', ], ], 'AwsApiCallActionDomainDetails' => [ 'base' => '<p>Provided if <code>CallerType</code> is <code>domain</code>. It provides information about the DNS domain that issued the API call.</p>', 'refs' => [ 'AwsApiCallAction$DomainDetails' => '<p>Provided if <code>CallerType</code> is <code>domain</code>. Provides information about the DNS domain that the API call originated from.</p>', ], ], 'AwsApiGatewayAccessLogSettings' => [ 'base' => '<p>Contains information about settings for logging access for the stage.</p>', 'refs' => [ 'AwsApiGatewayStageDetails$AccessLogSettings' => '<p>Settings for logging access for the stage.</p>', 'AwsApiGatewayV2StageDetails$AccessLogSettings' => '<p>Information about settings for logging access for the stage.</p>', ], ], 'AwsApiGatewayCanarySettings' => [ 'base' => '<p>Contains information about settings for canary deployment in the stage.</p>', 'refs' => [ 'AwsApiGatewayStageDetails$CanarySettings' => '<p>Information about settings for canary deployment in the stage.</p>', ], ], 'AwsApiGatewayEndpointConfiguration' => [ 'base' => '<p>Contains information about the endpoints for the API.</p>', 'refs' => [ 'AwsApiGatewayRestApiDetails$EndpointConfiguration' => '<p>The endpoint configuration of the REST API.</p>', ], ], 'AwsApiGatewayMethodSettings' => [ 'base' => '<p>Defines settings for a method for the stage.</p>', 'refs' => [ 'AwsApiGatewayMethodSettingsList$member' => NULL, ], ], 'AwsApiGatewayMethodSettingsList' => [ 'base' => NULL, 'refs' => [ 'AwsApiGatewayStageDetails$MethodSettings' => '<p>Defines the method settings for the stage.</p>', ], ], 'AwsApiGatewayRestApiDetails' => [ 'base' => '<p>Contains information about a REST API in version 1 of Amazon API Gateway.</p>', 'refs' => [ 'ResourceDetails$AwsApiGatewayRestApi' => '<p>Provides information about a REST API in version 1 of Amazon API Gateway.</p>', ], ], 'AwsApiGatewayStageDetails' => [ 'base' => '<p>Provides information about a version 1 Amazon API Gateway stage.</p>', 'refs' => [ 'ResourceDetails$AwsApiGatewayStage' => '<p>Provides information about a version 1 Amazon API Gateway stage.</p>', ], ], 'AwsApiGatewayV2ApiDetails' => [ 'base' => '<p>Contains information about a version 2 API in Amazon API Gateway.</p>', 'refs' => [ 'ResourceDetails$AwsApiGatewayV2Api' => '<p>Provides information about a version 2 API in Amazon API Gateway.</p>', ], ], 'AwsApiGatewayV2RouteSettings' => [ 'base' => '<p>Contains route settings for a stage.</p>', 'refs' => [ 'AwsApiGatewayV2StageDetails$DefaultRouteSettings' => '<p>Default route settings for the stage.</p>', 'AwsApiGatewayV2StageDetails$RouteSettings' => '<p>The route settings for the stage.</p>', ], ], 'AwsApiGatewayV2StageDetails' => [ 'base' => '<p>Contains information about a version 2 stage for Amazon API Gateway.</p>', 'refs' => [ 'ResourceDetails$AwsApiGatewayV2Stage' => '<p>Provides information about a version 2 stage for Amazon API Gateway.</p>', ], ], 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails' => [ 'base' => '<p> A list of additional authentication providers for the GraphqlApi API. </p>', 'refs' => [ 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList$member' => NULL, ], ], 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList' => [ 'base' => NULL, 'refs' => [ 'AwsAppSyncGraphQlApiDetails$AdditionalAuthenticationProviders' => '<p> A list of additional authentication providers for the GraphQL API. </p>', ], ], 'AwsAppSyncGraphQlApiDetails' => [ 'base' => '<p> Provides details about an AppSync Graph QL API, which lets you query multiple databases, microservices, and APIs from a single GraphQL endpoint. </p>', 'refs' => [ 'ResourceDetails$AwsAppSyncGraphQlApi' => '<p> Provides details about an AppSync Graph QL API, which lets you query multiple databases, microservices, and APIs from a single GraphQL endpoint. </p>', ], ], 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails' => [ 'base' => '<p> Specifies the authorization configuration for using an Lambda function with your AppSync GraphQL API endpoint. </p>', 'refs' => [ 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails$LambdaAuthorizerConfig' => '<p> The configuration for Lambda function authorization. </p>', 'AwsAppSyncGraphQlApiDetails$LambdaAuthorizerConfig' => '<p> Specifies the configuration for Lambda function authorization. </p>', ], ], 'AwsAppSyncGraphQlApiLogConfigDetails' => [ 'base' => '<p> Specifies the logging configuration when writing GraphQL operations and tracing to Amazon CloudWatch for an AppSync GraphQL API. </p>', 'refs' => [ 'AwsAppSyncGraphQlApiDetails$LogConfig' => '<p> The Amazon CloudWatch Logs configuration. </p>', ], ], 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails' => [ 'base' => '<p> Specifies the authorization configuration for using an OpenID Connect compliant service with your AppSync GraphQL API endpoint. </p>', 'refs' => [ 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails$OpenIdConnectConfig' => '<p> The OpenID Connect configuration. </p>', 'AwsAppSyncGraphQlApiDetails$OpenIdConnectConfig' => '<p> Specifies the authorization configuration for using an OpenID Connect compliant service with an AppSync GraphQL API endpoint. </p>', ], ], 'AwsAppSyncGraphQlApiUserPoolConfigDetails' => [ 'base' => '<p> Specifies the authorization configuration for using Amazon Cognito user pools with your AppSync GraphQL API endpoint. </p>', 'refs' => [ 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails$UserPoolConfig' => '<p> The Amazon Cognito user pools configuration. </p>', 'AwsAppSyncGraphQlApiDetails$UserPoolConfig' => '<p> The Amazon Cognito user pools configuration. </p>', ], ], 'AwsAthenaWorkGroupConfigurationDetails' => [ 'base' => '<p> The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3) where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. </p>', 'refs' => [ 'AwsAthenaWorkGroupDetails$Configuration' => '<p> The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3) where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. </p>', ], ], 'AwsAthenaWorkGroupConfigurationResultConfigurationDetails' => [ 'base' => '<p> The location in Amazon Simple Storage Service (Amazon S3) where query and calculation results are stored and the encryption option, if any, used for query and calculation results. These are known as client-side settings. If workgroup settings override client-side settings, then the query uses the workgroup settings. </p>', 'refs' => [ 'AwsAthenaWorkGroupConfigurationDetails$ResultConfiguration' => '<p> The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results. These are known as client-side settings. If workgroup settings override client-side settings, then the query uses the workgroup settings.</p>', ], ], 'AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails' => [ 'base' => '<p> Specifies the method used to encrypt the user’s data stores in the Athena workgroup. </p>', 'refs' => [ 'AwsAthenaWorkGroupConfigurationResultConfigurationDetails$EncryptionConfiguration' => '<p> Specifies the method used to encrypt the user’s data stores in the Athena workgroup. </p>', ], ], 'AwsAthenaWorkGroupDetails' => [ 'base' => '<p> Provides information about an Amazon Athena workgroup. </p>', 'refs' => [ 'ResourceDetails$AwsAthenaWorkGroup' => '<p> Provides information about an Amazon Athena workgroup. A workgroup helps you separate users, teams, applications, or workloads. It also helps you set limits on data processing and track costs. </p>', ], ], 'AwsAutoScalingAutoScalingGroupAvailabilityZonesList' => [ 'base' => NULL, 'refs' => [ 'AwsAutoScalingAutoScalingGroupDetails$AvailabilityZones' => '<p>The list of Availability Zones for the automatic scaling group.</p>', ], ], 'AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails' => [ 'base' => '<p>An Availability Zone for the automatic scaling group.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupAvailabilityZonesList$member' => NULL, ], ], 'AwsAutoScalingAutoScalingGroupDetails' => [ 'base' => '<p>Provides details about an auto scaling group.</p>', 'refs' => [ 'ResourceDetails$AwsAutoScalingAutoScalingGroup' => '<p>Details for an autoscaling group.</p>', ], ], 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification' => [ 'base' => '<p>Details about the launch template to use.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupDetails$LaunchTemplate' => '<p>The launch template to use.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails' => [ 'base' => '<p>The mixed instances policy for the automatic scaling group.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupDetails$MixedInstancesPolicy' => '<p>The mixed instances policy for the automatic scaling group.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails' => [ 'base' => '<p>Information about the instances distribution.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails$InstancesDistribution' => '<p>The instances distribution. The instances distribution specifies the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacity.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails' => [ 'base' => '<p>Describes a launch template and overrides for a mixed instances policy.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails$LaunchTemplate' => '<p>The launch template to use and the instance types (overrides) to use to provision EC2 instances to fulfill On-Demand and Spot capacities.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification' => [ 'base' => '<p>Details about the launch template to use for a mixed instances policy.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails$LaunchTemplateSpecification' => '<p>The launch template to use for a mixed instances policy.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList' => [ 'base' => NULL, 'refs' => [ 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails$Overrides' => '<p>Property values to use to override the values in the launch template.</p>', ], ], 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails' => [ 'base' => '<p>Property values to use to override the values in the launch template.</p>', 'refs' => [ 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList$member' => NULL, ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails' => [ 'base' => '<p>A block device for the instance.</p>', 'refs' => [ 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsList$member' => NULL, ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails' => [ 'base' => '<p>Parameters that are used to automatically set up EBS volumes when an instance is launched.</p>', 'refs' => [ 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails$Ebs' => '<p>Parameters that are used to automatically set up Amazon EBS volumes when an instance is launched.</p>', ], ], 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsList' => [ 'base' => NULL, 'refs' => [ 'AwsAutoScalingLaunchConfigurationDetails$BlockDeviceMappings' => '<p>Specifies the block devices for the instance.</p>', ], ], 'AwsAutoScalingLaunchConfigurationDetails' => [ 'base' => '<p>Details about a launch configuration.</p>', 'refs' => [ 'ResourceDetails$AwsAutoScalingLaunchConfiguration' => '<p>Provides details about a launch configuration.</p>', ], ], 'AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails' => [ 'base' => '<p>Information about the type of monitoring for instances in the group.</p>', 'refs' => [ 'AwsAutoScalingLaunchConfigurationDetails$InstanceMonitoring' => '<p>Indicates the type of monitoring for instances in the group.</p>', ], ], 'AwsAutoScalingLaunchConfigurationMetadataOptions' => [ 'base' => '<p>The metadata options for the instances.</p>', 'refs' => [ 'AwsAutoScalingLaunchConfigurationDetails$MetadataOptions' => '<p>The metadata options for the instances.</p>', ], ], 'AwsBackupBackupPlanAdvancedBackupSettingsDetails' => [ 'base' => '<p>Provides a list of backup options for each resource type. </p>', 'refs' => [ 'AwsBackupBackupPlanAdvancedBackupSettingsList$member' => NULL, ], ], 'AwsBackupBackupPlanAdvancedBackupSettingsList' => [ 'base' => NULL, 'refs' => [ 'AwsBackupBackupPlanBackupPlanDetails$AdvancedBackupSettings' => '<p>A list of backup options for each resource type. </p>', ], ], 'AwsBackupBackupPlanBackupPlanDetails' => [ 'base' => '<p>Provides details about an Backup backup plan and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. </p>', 'refs' => [ 'AwsBackupBackupPlanDetails$BackupPlan' => '<p>Uniquely identifies the backup plan to be associated with the selection of resources. </p>', ], ], 'AwsBackupBackupPlanDetails' => [ 'base' => '<p>Provides details about an Backup backup plan and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. </p>', 'refs' => [ 'ResourceDetails$AwsBackupBackupPlan' => '<p>Provides details about an Backup backup plan. </p>', ], ], 'AwsBackupBackupPlanLifecycleDetails' => [ 'base' => '<p>Provides lifecycle details for the backup plan. A lifecycle defines when a backup is transitioned to cold storage and when it expires. </p>', 'refs' => [ 'AwsBackupBackupPlanRuleCopyActionsDetails$Lifecycle' => '<p>Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.</p>', 'AwsBackupBackupPlanRuleDetails$Lifecycle' => '<p>Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.</p>', ], ], 'AwsBackupBackupPlanRuleCopyActionsDetails' => [ 'base' => '<p>An array of <code>CopyAction</code> objects, each of which contains details of the copy operation. </p>', 'refs' => [ 'AwsBackupBackupPlanRuleCopyActionsList$member' => NULL, ], ], 'AwsBackupBackupPlanRuleCopyActionsList' => [ 'base' => NULL, 'refs' => [ 'AwsBackupBackupPlanRuleDetails$CopyActions' => '<p>An array of <code>CopyAction</code> objects, each of which contains details of the copy operation. </p>', ], ], 'AwsBackupBackupPlanRuleDetails' => [ 'base' => '<p>Provides details about an array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources. </p>', 'refs' => [ 'AwsBackupBackupPlanRuleList$member' => NULL, ], ], 'AwsBackupBackupPlanRuleList' => [ 'base' => NULL, 'refs' => [ 'AwsBackupBackupPlanBackupPlanDetails$BackupPlanRule' => '<p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources. </p>', ], ], 'AwsBackupBackupVaultDetails' => [ 'base' => '<p>Provides details about an Backup backup vault. In Backup, a backup vault is a container that stores and organizes your backups. </p>', 'refs' => [ 'ResourceDetails$AwsBackupBackupVault' => '<p>Provides details about an Backup backup vault. </p>', ], ], 'AwsBackupBackupVaultNotificationsDetails' => [ 'base' => '<p>Provides details about the Amazon SNS event notifications for the specified backup vault. </p>', 'refs' => [ 'AwsBackupBackupVaultDetails$Notifications' => '<p>The Amazon SNS event notifications for the specified backup vault. </p>', ], ], 'AwsBackupRecoveryPointCalculatedLifecycleDetails' => [ 'base' => '<p>Specifies how long in days before a recovery point transitions to cold storage or is deleted. </p>', 'refs' => [ 'AwsBackupRecoveryPointDetails$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps. </p>', ], ], 'AwsBackupRecoveryPointCreatedByDetails' => [ 'base' => '<p>Contains information about the backup plan and rule that Backup used to initiate the recovery point backup. </p>', 'refs' => [ 'AwsBackupRecoveryPointDetails$CreatedBy' => '<p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it. </p>', ], ], 'AwsBackupRecoveryPointDetails' => [ 'base' => '<p>Contains detailed information about the recovery points stored in an Backup backup vault. A backup, or recovery point, represents the content of a resource at a specified time. </p>', 'refs' => [ 'ResourceDetails$AwsBackupRecoveryPoint' => '<p>Provides details about an Backup backup, or recovery point. </p>', ], ], 'AwsBackupRecoveryPointLifecycleDetails' => [ 'base' => '<p>Contains an array of Transition objects specifying how long in days before a recovery point transitions to cold storage or is deleted. </p>', 'refs' => [ 'AwsBackupRecoveryPointDetails$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define </p>', ], ], 'AwsCertificateManagerCertificateDetails' => [ 'base' => '<p>Provides details about an Certificate Manager certificate.</p>', 'refs' => [ 'ResourceDetails$AwsCertificateManagerCertificate' => '<p>Provides details about an Certificate Manager certificate.</p>', ], ], 'AwsCertificateManagerCertificateDomainValidationOption' => [ 'base' => '<p>Contains information about one of the following:</p> <ul> <li> <p>The initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request</p> </li> <li> <p>The validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal</p> </li> </ul>', 'refs' => [ 'AwsCertificateManagerCertificateDomainValidationOptions$member' => NULL, ], ], 'AwsCertificateManagerCertificateDomainValidationOptions' => [ 'base' => NULL, 'refs' => [ 'AwsCertificateManagerCertificateDetails$DomainValidationOptions' => '<p>Contains information about the initial validation of each domain name that occurs as a result of the <code>RequestCertificate</code> request.</p> <p>Only provided if the certificate type is <code>AMAZON_ISSUED</code>.</p>', 'AwsCertificateManagerCertificateRenewalSummary$DomainValidationOptions' => '<p>Information about the validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.</p>', ], ], 'AwsCertificateManagerCertificateExtendedKeyUsage' => [ 'base' => '<p>Contains information about an extended key usage X.509 v3 extension object.</p>', 'refs' => [ 'AwsCertificateManagerCertificateExtendedKeyUsages$member' => NULL, ], ], 'AwsCertificateManagerCertificateExtendedKeyUsages' => [ 'base' => NULL, 'refs' => [ 'AwsCertificateManagerCertificateDetails$ExtendedKeyUsages' => '<p>Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).</p>', ], ], 'AwsCertificateManagerCertificateKeyUsage' => [ 'base' => '<p>Contains information about a key usage X.509 v3 extension object.</p>', 'refs' => [ 'AwsCertificateManagerCertificateKeyUsages$member' => NULL, ], ], 'AwsCertificateManagerCertificateKeyUsages' => [ 'base' => NULL, 'refs' => [ 'AwsCertificateManagerCertificateDetails$KeyUsages' => '<p>A list of key usage X.509 v3 extension objects.</p>', ], ], 'AwsCertificateManagerCertificateOptions' => [ 'base' => '<p>Contains other options for the certificate.</p>', 'refs' => [ 'AwsCertificateManagerCertificateDetails$Options' => '<p>Provides a value that specifies whether to add the certificate to a transparency log.</p>', ], ], 'AwsCertificateManagerCertificateRenewalSummary' => [ 'base' => '<p>Contains information about the Certificate Manager managed renewal for an <code>AMAZON_ISSUED</code> certificate.</p>', 'refs' => [ 'AwsCertificateManagerCertificateDetails$RenewalSummary' => '<p>Information about the status of the Certificate Manager managed renewal for the certificate. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.</p>', ], ], 'AwsCertificateManagerCertificateResourceRecord' => [ 'base' => '<p>Provides details about the CNAME record that is added to the DNS database for domain validation.</p>', 'refs' => [ 'AwsCertificateManagerCertificateDomainValidationOption$ResourceRecord' => '<p>The CNAME record that is added to the DNS database for domain validation.</p>', ], ], 'AwsCloudFormationStackDetails' => [ 'base' => '<p>Nests a stack as a resource in a top-level template. Nested stacks are stacks created as resources for another stack.</p>', 'refs' => [ 'ResourceDetails$AwsCloudFormationStack' => '<p>Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can manage as a single unit.</p>', ], ], 'AwsCloudFormationStackDriftInformationDetails' => [ 'base' => '<p>Provides information about the stack\'s conformity to its expected template configuration. </p>', 'refs' => [ 'AwsCloudFormationStackDetails$DriftInformation' => '<p>Information about whether a stack\'s actual configuration differs, or has drifted, from its expected configuration, as defined in the stack template and any values specified as template parameters. </p>', ], ], 'AwsCloudFormationStackOutputsDetails' => [ 'base' => '<p>Provides information about the CloudFormation stack output. </p>', 'refs' => [ 'AwsCloudFormationStackOutputsList$member' => NULL, ], ], 'AwsCloudFormationStackOutputsList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFormationStackDetails$Outputs' => '<p>A list of output structures. </p>', ], ], 'AwsCloudFrontDistributionCacheBehavior' => [ 'base' => '<p>Information about a cache behavior for the distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionCacheBehaviorsItemList$member' => NULL, ], ], 'AwsCloudFrontDistributionCacheBehaviors' => [ 'base' => '<p>Provides information about caching for the CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$CacheBehaviors' => '<p>Provides information about the cache configuration for the distribution.</p>', ], ], 'AwsCloudFrontDistributionCacheBehaviorsItemList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionCacheBehaviors$Items' => '<p>The cache behaviors for the distribution.</p>', ], ], 'AwsCloudFrontDistributionDefaultCacheBehavior' => [ 'base' => '<p>Contains information about the default cache configuration for the CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$DefaultCacheBehavior' => '<p>The default cache behavior for the configuration.</p>', ], ], 'AwsCloudFrontDistributionDetails' => [ 'base' => '<p>A CloudFront distribution configuration.</p>', 'refs' => [ 'ResourceDetails$AwsCloudFrontDistribution' => '<p>Details about a CloudFront distribution.</p>', ], ], 'AwsCloudFrontDistributionLogging' => [ 'base' => '<p>A complex type that controls whether access logs are written for the CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$Logging' => '<p>A complex type that controls whether access logs are written for the distribution.</p>', ], ], 'AwsCloudFrontDistributionOriginCustomOriginConfig' => [ 'base' => '<p>A custom origin. A custom origin is any origin that is not an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with static website hosting</a> is a custom origin. </p>', 'refs' => [ 'AwsCloudFrontDistributionOriginItem$CustomOriginConfig' => '<p>An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website hosting, use the <code>S3OriginConfig</code> type instead. </p>', ], ], 'AwsCloudFrontDistributionOriginGroup' => [ 'base' => '<p>Information about an origin group for the CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginGroupsItemList$member' => NULL, ], ], 'AwsCloudFrontDistributionOriginGroupFailover' => [ 'base' => '<p>Provides information about when an origin group fails over.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginGroup$FailoverCriteria' => '<p>Provides the criteria for an origin group to fail over.</p>', ], ], 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodes' => [ 'base' => '<p>The status codes that cause an origin group to fail over.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginGroupFailover$StatusCodes' => '<p>Information about the status codes that cause an origin group to fail over.</p>', ], ], 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodes$Items' => '<p>The list of status code values that can cause a failover to the next origin.</p>', ], ], 'AwsCloudFrontDistributionOriginGroups' => [ 'base' => '<p>Provides information about origin groups that are associated with the CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$OriginGroups' => '<p>Provides information about the origin groups in the distribution.</p>', ], ], 'AwsCloudFrontDistributionOriginGroupsItemList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionOriginGroups$Items' => '<p>The list of origin groups.</p>', ], ], 'AwsCloudFrontDistributionOriginItem' => [ 'base' => '<p>A complex type that describes the Amazon S3 bucket, HTTP server (for example, a web server), Elemental MediaStore, or other server from which CloudFront gets your files.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginItemList$member' => NULL, ], ], 'AwsCloudFrontDistributionOriginItemList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionOrigins$Items' => '<p>A complex type that contains origins or origin groups for this distribution.</p>', ], ], 'AwsCloudFrontDistributionOriginS3OriginConfig' => [ 'base' => '<p>Information about an origin that is an Amazon S3 bucket that is not configured with static website hosting.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginItem$S3OriginConfig' => '<p>An origin that is an S3 bucket that is not configured with static website hosting.</p>', ], ], 'AwsCloudFrontDistributionOriginSslProtocols' => [ 'base' => '<p>A complex type that contains information about the SSL/TLS protocols that CloudFront can use when establishing an HTTPS connection with your origin. </p>', 'refs' => [ 'AwsCloudFrontDistributionOriginCustomOriginConfig$OriginSslProtocols' => '<p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. </p>', ], ], 'AwsCloudFrontDistributionOrigins' => [ 'base' => '<p>A complex type that contains information about origins and origin groups for this CloudFront distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$Origins' => '<p>A complex type that contains information about origins for this distribution.</p>', ], ], 'AwsCloudFrontDistributionViewerCertificate' => [ 'base' => '<p>Provides information about the TLS/SSL configuration that the CloudFront distribution uses to communicate with viewers.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$ViewerCertificate' => '<p>Provides information about the TLS/SSL configuration that the distribution uses to communicate with viewers.</p>', ], ], 'AwsCloudTrailTrailDetails' => [ 'base' => '<p>Provides details about a CloudTrail trail.</p>', 'refs' => [ 'ResourceDetails$AwsCloudTrailTrail' => '<p>Provides details about a CloudTrail trail.</p>', ], ], 'AwsCloudWatchAlarmDetails' => [ 'base' => '<p>Specifies an alarm and associates it with the specified metric or metric math expression. </p>', 'refs' => [ 'ResourceDetails$AwsCloudWatchAlarm' => '<p>Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon Web Services resources and applications across multiple Regions.</p>', ], ], 'AwsCloudWatchAlarmDimensionsDetails' => [ 'base' => '<p>Details about the dimensions for the metric associated with the alarm. </p>', 'refs' => [ 'AwsCloudWatchAlarmDimensionsList$member' => NULL, ], ], 'AwsCloudWatchAlarmDimensionsList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudWatchAlarmDetails$Dimensions' => '<p>The dimensions for the metric associated with the alarm. </p>', ], ], 'AwsCodeBuildProjectArtifactsDetails' => [ 'base' => '<p>Information about the build artifacts for the CodeBuild project.</p>', 'refs' => [ 'AwsCodeBuildProjectArtifactsList$member' => NULL, ], ], 'AwsCodeBuildProjectArtifactsList' => [ 'base' => NULL, 'refs' => [ 'AwsCodeBuildProjectDetails$Artifacts' => '<p>Information about the build artifacts for the CodeBuild project.</p>', 'AwsCodeBuildProjectDetails$SecondaryArtifacts' => '<p>Information about the secondary artifacts for the CodeBuild project.</p>', ], ], 'AwsCodeBuildProjectDetails' => [ 'base' => '<p>Information about an CodeBuild project.</p>', 'refs' => [ 'ResourceDetails$AwsCodeBuildProject' => '<p>Details for an CodeBuild project.</p>', ], ], 'AwsCodeBuildProjectEnvironment' => [ 'base' => '<p>Information about the build environment for this build project.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$Environment' => '<p>Information about the build environment for this build project.</p>', ], ], 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails' => [ 'base' => '<p>Information about an environment variable that is available to builds for the build project.</p>', 'refs' => [ 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesList$member' => NULL, ], ], 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesList' => [ 'base' => NULL, 'refs' => [ 'AwsCodeBuildProjectEnvironment$EnvironmentVariables' => '<p>A set of environment variables to make available to builds for the build project.</p>', ], ], 'AwsCodeBuildProjectEnvironmentRegistryCredential' => [ 'base' => '<p>The credentials for access to a private registry.</p>', 'refs' => [ 'AwsCodeBuildProjectEnvironment$RegistryCredential' => '<p>The credentials for access to a private registry.</p>', ], ], 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails' => [ 'base' => '<p>Information about CloudWatch Logs for the build project.</p>', 'refs' => [ 'AwsCodeBuildProjectLogsConfigDetails$CloudWatchLogs' => '<p>Information about CloudWatch Logs for the build project.</p>', ], ], 'AwsCodeBuildProjectLogsConfigDetails' => [ 'base' => '<p>Information about logs for the build project.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$LogsConfig' => '<p>Information about logs for the build project.</p>', ], ], 'AwsCodeBuildProjectLogsConfigS3LogsDetails' => [ 'base' => '<p>Information about logs built to an S3 bucket for a build project.</p>', 'refs' => [ 'AwsCodeBuildProjectLogsConfigDetails$S3Logs' => '<p>Information about logs built to an S3 bucket for a build project.</p>', ], ], 'AwsCodeBuildProjectSource' => [ 'base' => '<p>Information about the build input source code for this build project.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$Source' => '<p>Information about the build input source code for this build project.</p>', ], ], 'AwsCodeBuildProjectVpcConfig' => [ 'base' => '<p>Information about the VPC configuration that CodeBuild accesses.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$VpcConfig' => '<p>Information about the VPC configuration that CodeBuild accesses.</p>', ], ], 'AwsCorsConfiguration' => [ 'base' => '<p>Contains the cross-origin resource sharing (CORS) configuration for the API. CORS is only supported for HTTP APIs.</p>', 'refs' => [ 'AwsApiGatewayV2ApiDetails$CorsConfiguration' => '<p>A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.</p>', ], ], 'AwsDmsEndpointDetails' => [ 'base' => '<p> Provides details about an Database Migration Service (DMS) endpoint. An endpoint provides connection, data store type, and location information about your data store. </p>', 'refs' => [ 'ResourceDetails$AwsDmsEndpoint' => '<p> Provides details about an Database Migration Service (DMS) endpoint. An endpoint provides connection, data store type, and location information about your data store.</p>', ], ], 'AwsDmsReplicationInstanceDetails' => [ 'base' => '<p> Provides details about an Database Migration Service (DMS) replication instance. DMS uses a replication instance to connect to your source data store, read the source data, and format the data for consumption by the target data store. </p>', 'refs' => [ 'ResourceDetails$AwsDmsReplicationInstance' => '<p> Provides details about an DMS replication instance. DMS uses a replication instance to connect to your source data store, read the source data, and format the data for consumption by the target data store.</p>', ], ], 'AwsDmsReplicationInstanceReplicationSubnetGroupDetails' => [ 'base' => '<p> Provides details about the replication subnet group.</p>', 'refs' => [ 'AwsDmsReplicationInstanceDetails$ReplicationSubnetGroup' => '<p> The subnet group for the replication instance.</p>', ], ], 'AwsDmsReplicationInstanceVpcSecurityGroupsDetails' => [ 'base' => '<p> Provides details about the virtual private cloud (VPC) security group that’s associated with the replication instance.</p>', 'refs' => [ 'AwsDmsReplicationInstanceVpcSecurityGroupsList$member' => NULL, ], ], 'AwsDmsReplicationInstanceVpcSecurityGroupsList' => [ 'base' => NULL, 'refs' => [ 'AwsDmsReplicationInstanceDetails$VpcSecurityGroups' => '<p> The virtual private cloud (VPC) security group for the replication instance.</p>', ], ], 'AwsDmsReplicationTaskDetails' => [ 'base' => '<p> Provides details about an Database Migration Service (DMS) replication task. A replication task moves a set of data from the source endpoint to the target endpoint.</p>', 'refs' => [ 'ResourceDetails$AwsDmsReplicationTask' => '<p> Provides details about an DMS replication task. A replication task moves a set of data from the source endpoint to the target endpoint.</p>', ], ], 'AwsDynamoDbTableAttributeDefinition' => [ 'base' => '<p>Contains a definition of an attribute for the table.</p>', 'refs' => [ 'AwsDynamoDbTableAttributeDefinitionList$member' => NULL, ], ], 'AwsDynamoDbTableAttributeDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$AttributeDefinitions' => '<p>A list of attribute definitions for the table.</p>', ], ], 'AwsDynamoDbTableBillingModeSummary' => [ 'base' => '<p>Provides information about the billing for read/write capacity on the table.</p>', 'refs' => [ 'AwsDynamoDbTableDetails$BillingModeSummary' => '<p>Information about the billing for read/write capacity on the table.</p>', ], ], 'AwsDynamoDbTableDetails' => [ 'base' => '<p>Provides details about a DynamoDB table.</p>', 'refs' => [ 'ResourceDetails$AwsDynamoDbTable' => '<p>Details about a DynamoDB table.</p>', ], ], 'AwsDynamoDbTableGlobalSecondaryIndex' => [ 'base' => '<p>Information abut a global secondary index for the table.</p>', 'refs' => [ 'AwsDynamoDbTableGlobalSecondaryIndexList$member' => NULL, ], ], 'AwsDynamoDbTableGlobalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$GlobalSecondaryIndexes' => '<p>List of global secondary indexes for the table.</p>', ], ], 'AwsDynamoDbTableKeySchema' => [ 'base' => '<p>A component of the key schema for the DynamoDB table, a global secondary index, or a local secondary index.</p>', 'refs' => [ 'AwsDynamoDbTableKeySchemaList$member' => NULL, ], ], 'AwsDynamoDbTableKeySchemaList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$KeySchema' => '<p>The primary key structure for the table.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$KeySchema' => '<p>The key schema for the index.</p>', 'AwsDynamoDbTableLocalSecondaryIndex$KeySchema' => '<p>The complete key schema for the index.</p>', ], ], 'AwsDynamoDbTableLocalSecondaryIndex' => [ 'base' => '<p>Information about a local secondary index for a DynamoDB table.</p>', 'refs' => [ 'AwsDynamoDbTableLocalSecondaryIndexList$member' => NULL, ], ], 'AwsDynamoDbTableLocalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$LocalSecondaryIndexes' => '<p>The list of local secondary indexes for the table.</p>', ], ], 'AwsDynamoDbTableProjection' => [ 'base' => '<p>For global and local secondary indexes, identifies the attributes that are copied from the table into the index.</p>', 'refs' => [ 'AwsDynamoDbTableGlobalSecondaryIndex$Projection' => '<p>Attributes that are copied from the table into an index.</p>', 'AwsDynamoDbTableLocalSecondaryIndex$Projection' => '<p>Attributes that are copied from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>', ], ], 'AwsDynamoDbTableProvisionedThroughput' => [ 'base' => '<p>Information about the provisioned throughput for the table or for a global secondary index.</p>', 'refs' => [ 'AwsDynamoDbTableDetails$ProvisionedThroughput' => '<p>Information about the provisioned throughput for the table.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$ProvisionedThroughput' => '<p>Information about the provisioned throughput settings for the indexes.</p>', ], ], 'AwsDynamoDbTableProvisionedThroughputOverride' => [ 'base' => '<p>Replica-specific configuration for the provisioned throughput.</p>', 'refs' => [ 'AwsDynamoDbTableReplica$ProvisionedThroughputOverride' => '<p>Replica-specific configuration for the provisioned throughput.</p>', 'AwsDynamoDbTableReplicaGlobalSecondaryIndex$ProvisionedThroughputOverride' => '<p>Replica-specific configuration for the provisioned throughput for the index.</p>', ], ], 'AwsDynamoDbTableReplica' => [ 'base' => '<p>Information about a replica of a DynamoDB table.</p>', 'refs' => [ 'AwsDynamoDbTableReplicaList$member' => NULL, ], ], 'AwsDynamoDbTableReplicaGlobalSecondaryIndex' => [ 'base' => '<p>Information about a global secondary index for a DynamoDB table replica.</p>', 'refs' => [ 'AwsDynamoDbTableReplicaGlobalSecondaryIndexList$member' => NULL, ], ], 'AwsDynamoDbTableReplicaGlobalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableReplica$GlobalSecondaryIndexes' => '<p>List of global secondary indexes for the replica.</p>', ], ], 'AwsDynamoDbTableReplicaList' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$Replicas' => '<p>The list of replicas of this table.</p>', ], ], 'AwsDynamoDbTableRestoreSummary' => [ 'base' => '<p>Information about the restore for the table.</p>', 'refs' => [ 'AwsDynamoDbTableDetails$RestoreSummary' => '<p>Information about the restore for the table.</p>', ], ], 'AwsDynamoDbTableSseDescription' => [ 'base' => '<p>Information about the server-side encryption for the table.</p>', 'refs' => [ 'AwsDynamoDbTableDetails$SseDescription' => '<p>Information about the server-side encryption for the table.</p>', ], ], 'AwsDynamoDbTableStreamSpecification' => [ 'base' => '<p>The current DynamoDB Streams configuration for the table.</p>', 'refs' => [ 'AwsDynamoDbTableDetails$StreamSpecification' => '<p>The current DynamoDB Streams configuration for the table.</p>', ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails' => [ 'base' => '<p> Provides details about an Active Directory that’s used to authenticate an Client VPN endpoint. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails$ActiveDirectory' => '<p> Information about the Active Directory, if applicable. With Active Directory authentication, clients are authenticated against existing Active Directory groups. </p>', ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails' => [ 'base' => '<p> Information about the authentication method used by the Client VPN endpoint. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointAuthenticationOptionsList$member' => NULL, ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails' => [ 'base' => '<p> Describes the IAM SAML identity providers used for federated authentication. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails$FederatedAuthentication' => '<p> Information about the IAM SAML identity provider, if applicable.</p>', ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2ClientVpnEndpointDetails$AuthenticationOptions' => '<p> Information about the authentication method used by the Client VPN endpoint. </p>', ], ], 'AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails' => [ 'base' => '<p> Information about the client certificate used for authentication. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails$MutualAuthentication' => '<p> Information about the authentication certificates, if applicable.</p>', ], ], 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails' => [ 'base' => '<p> The options for managing connection authorization for new client connections. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointDetails$ClientConnectOptions' => '<p> The options for managing connection authorization for new client connections. </p>', ], ], 'AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails' => [ 'base' => '<p> Describes the status of the Client VPN endpoint attribute. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails$Status' => '<p> The status of any updates to the client connect options. </p>', ], ], 'AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails' => [ 'base' => '<p> Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointDetails$ClientLoginBannerOptions' => '<p> Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established. </p>', ], ], 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails' => [ 'base' => '<p> Information about the client connection logging options for the Client VPN endpoint. </p>', 'refs' => [ 'AwsEc2ClientVpnEndpointDetails$ConnectionLogOptions' => '<p> Information about the client connection logging options for the Client VPN endpoint. </p>', ], ], 'AwsEc2ClientVpnEndpointDetails' => [ 'base' => '<p> Describes an Client VPN endpoint. A Client VPN endpoint is the resource that you create and configure to enable and manage client VPN sessions. It\'s the termination point for all client VPN sessions. </p>', 'refs' => [ 'ResourceDetails$AwsEc2ClientVpnEndpoint' => '<p> Provides details about an Client VPN endpoint. A Client VPN endpoint is the resource that you create and configure to enable and manage client VPN sessions. It\'s the termination point for all client VPN sessions. </p>', ], ], 'AwsEc2EipDetails' => [ 'base' => '<p>Information about an Elastic IP address.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Eip' => '<p>Details about an Elastic IP address.</p>', ], ], 'AwsEc2InstanceDetails' => [ 'base' => '<p>The details of an Amazon EC2 instance.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Instance' => '<p>Details about an EC2 instance related to a finding.</p>', ], ], 'AwsEc2InstanceMetadataOptions' => [ 'base' => '<p>Metadata options that allow you to configure and secure the Amazon EC2 instance.</p>', 'refs' => [ 'AwsEc2InstanceDetails$MetadataOptions' => '<p>Details about the metadata options for the Amazon EC2 instance. </p>', ], ], 'AwsEc2InstanceMonitoringDetails' => [ 'base' => '<p> The type of monitoring that’s turned on for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2InstanceDetails$Monitoring' => '<p> Describes the type of monitoring that’s turned on for an instance. </p>', ], ], 'AwsEc2InstanceNetworkInterfacesDetails' => [ 'base' => '<p>Identifies a network interface for the Amazon EC2 instance.</p>', 'refs' => [ 'AwsEc2InstanceNetworkInterfacesList$member' => NULL, ], ], 'AwsEc2InstanceNetworkInterfacesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$NetworkInterfaces' => '<p>The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.</p>', ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails' => [ 'base' => '<p> Information about a block device mapping for an Amazon Elastic Compute Cloud (Amazon EC2) launch template. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails' => [ 'base' => '<p> Parameters for a block device for an Amazon Elastic Block Store (Amazon EBS) volume in an Amazon EC2 launch template. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails$Ebs' => '<p> Parameters used to automatically set up Amazon EBS volumes when the instance is launched. </p>', ], ], 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$BlockDeviceMappingSet' => '<p> Information about a block device mapping for an Amazon EC2 launch template. </p>', ], ], 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails' => [ 'base' => '<p> Information about the target Capacity Reservation or Capacity Reservation group in which to run an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails$CapacityReservationTarget' => '<p> Specifies a target Capacity Reservation. </p>', ], ], 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails' => [ 'base' => '<p> Specifies the Capacity Reservation targeting option of an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$CapacityReservationSpecification' => '<p> Specifies an instance\'s Capacity Reservation targeting option. You can specify only one option at a time. </p>', ], ], 'AwsEc2LaunchTemplateDataCpuOptionsDetails' => [ 'base' => '<p> Specifies the CPU options for an Amazon EC2 instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$CpuOptions' => '<p> Specifies the CPU options for an instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', ], ], 'AwsEc2LaunchTemplateDataCreditSpecificationDetails' => [ 'base' => '<p> Specifies the credit option for CPU usage of a T2, T3, or T3a Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$CreditSpecification' => '<p> Specifies the credit option for CPU usage of a T2, T3, or T3a instance. </p>', ], ], 'AwsEc2LaunchTemplateDataDetails' => [ 'base' => '<p> The information to include in an Amazon Elastic Compute Cloud (Amazon EC2) launch template. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDetails$LaunchTemplateData' => '<p> The information to include in the launch template. </p>', ], ], 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails' => [ 'base' => '<p> Provides details about an Elastic Graphics specification for an Amazon EC2 launch template. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$ElasticGpuSpecificationSet' => '<p> Provides details about Elastic Graphics accelerators to associate with the instance. </p>', ], ], 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails' => [ 'base' => '<p> Provides details for an Amazon Elastic Inference accelerator. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$ElasticInferenceAcceleratorSet' => '<p> The Amazon Elastic Inference accelerator for the instance. </p>', ], ], 'AwsEc2LaunchTemplateDataEnclaveOptionsDetails' => [ 'base' => '<p> Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$EnclaveOptions' => '<p> Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves. </p>', ], ], 'AwsEc2LaunchTemplateDataHibernationOptionsDetails' => [ 'base' => '<p> Specifies whether your Amazon EC2 instance is configured for hibernation. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$HibernationOptions' => '<p> Specifies whether your Amazon EC2 instance is configured for hibernation. </p>', ], ], 'AwsEc2LaunchTemplateDataIamInstanceProfileDetails' => [ 'base' => '<p> Provides details for an Identity and Access Management (IAM) instance profile, which is a container for an IAM role for your instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$IamInstanceProfile' => '<p> The name or Amazon Resource Name (ARN) of an IAM instance profile. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails' => [ 'base' => '<p> Provides details about the market (purchasing) option for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$InstanceMarketOptions' => '<p> Specifies the market (purchasing) option for an instance. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails' => [ 'base' => '<p> Provides details about the market (purchasing) options for Spot Instances. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails$SpotOptions' => '<p> The options for Spot Instances. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails' => [ 'base' => '<p> The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$AcceleratorCount' => '<p> The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails' => [ 'base' => '<p> The minimum and maximum amount of memory, in MiB, for the accelerators on an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$AcceleratorTotalMemoryMiB' => '<p> The minimum and maximum amount of total accelerator memory, in MiB. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails' => [ 'base' => '<p> The minimum and maximum baseline bandwidth to Amazon Elastic Block Store (Amazon EBS), in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances </a> in the <i>Amazon EC2 User Guide</i>. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$BaselineEbsBandwidthMbps' => '<p> The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized instances</a> in the <i>Amazon EC2 User Guide</i>. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails' => [ 'base' => '<p> The attributes for the Amazon EC2 instance types. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$InstanceRequirements' => '<p> The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with these attributes. If you specify <code>InstanceRequirements</code>, you can\'t specify <code>InstanceType</code>. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails' => [ 'base' => '<p> The minimum and maximum amount of memory per vCPU, in GiB. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$MemoryGiBPerVCpu' => '<p> The minimum and maximum amount of memory per vCPU, in GiB. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails' => [ 'base' => '<p> The minimum and maximum amount of memory, in MiB, for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$MemoryMiB' => '<p> The minimum and maximum amount of memory, in MiB. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails' => [ 'base' => '<p> The minimum and maximum number of network interfaces to be attached to an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$NetworkInterfaceCount' => '<p> The minimum and maximum number of network interfaces. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails' => [ 'base' => '<p> The minimum and maximum amount of total local storage, in GB, that an Amazon EC2 instance uses. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$TotalLocalStorageGB' => '<p> The minimum and maximum amount of total local storage, in GB. </p>', ], ], 'AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails' => [ 'base' => '<p> The minimum and maximum number of vCPUs for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$VCpuCount' => '<p> The minimum and maximum number of vCPUs. </p>', ], ], 'AwsEc2LaunchTemplateDataLicenseSetDetails' => [ 'base' => '<p> Provides details about the license configuration for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataLicenseSetList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataLicenseSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$LicenseSet' => '<p> Specifies a license configuration for an instance. </p>', ], ], 'AwsEc2LaunchTemplateDataMaintenanceOptionsDetails' => [ 'base' => '<p> The maintenance options of an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$MaintenanceOptions' => '<p> The maintenance options of your instance. </p>', ], ], 'AwsEc2LaunchTemplateDataMetadataOptionsDetails' => [ 'base' => '<p> Specifies the metadata options for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$MetadataOptions' => '<p> The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <i>Amazon EC2 User Guide</i>. </p>', ], ], 'AwsEc2LaunchTemplateDataMonitoringDetails' => [ 'base' => '<p> The monitoring for an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$Monitoring' => '<p> The monitoring for the instance. </p>', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails' => [ 'base' => '<p> One or more network interfaces to attach to an Amazon EC2 instance. If you specify a network interface, you must specify security groups and subnets as part of the network interface. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails' => [ 'base' => '<p> Provides details on one or more IPv4 prefixes for a network interface. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv4Prefixes' => '<p> One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option. </p>', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails' => [ 'base' => '<p> Specifies an IPv6 address in an Amazon EC2 launch template. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv6Addresses' => '<p> One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can\'t use this option if you use <code>Ipv6AddressCount</code>. </p>', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails' => [ 'base' => '<p> Provides details on one or more IPv6 prefixes to be assigned to the network interface. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv6Prefixes' => '<p> One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option. </p>', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$NetworkInterfaceSet' => '<p> Specifies the parameters for a network interface that is attached to the instance. </p>', ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails' => [ 'base' => '<p> One or more private IPv4 addresses. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList$member' => NULL, ], ], 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$PrivateIpAddresses' => '<p> One or more private IPv4 addresses. </p>', ], ], 'AwsEc2LaunchTemplateDataPlacementDetails' => [ 'base' => '<p> Provides details about the placement of an Amazon EC2 instance. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$Placement' => '<p> Specifies the placement of an instance. </p>', ], ], 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails' => [ 'base' => '<p> Describes the options for Amazon EC2 instance hostnames. </p>', 'refs' => [ 'AwsEc2LaunchTemplateDataDetails$PrivateDnsNameOptions' => '<p> The options for the instance hostname. </p>', ], ], 'AwsEc2LaunchTemplateDetails' => [ 'base' => '<p> Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon EC2) launch template. </p>', 'refs' => [ 'ResourceDetails$AwsEc2LaunchTemplate' => NULL, ], ], 'AwsEc2NetworkAclAssociation' => [ 'base' => '<p>An association between the network ACL and a subnet.</p>', 'refs' => [ 'AwsEc2NetworkAclAssociationList$member' => NULL, ], ], 'AwsEc2NetworkAclAssociationList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkAclDetails$Associations' => '<p>Associations between the network ACL and subnets.</p>', ], ], 'AwsEc2NetworkAclDetails' => [ 'base' => '<p>Contains details about an Amazon EC2 network access control list (ACL).</p>', 'refs' => [ 'ResourceDetails$AwsEc2NetworkAcl' => '<p>Details about an EC2 network access control list (ACL).</p>', ], ], 'AwsEc2NetworkAclEntry' => [ 'base' => '<p>A rule for the network ACL. Each rule allows or denies access based on the IP address, traffic direction, port, and protocol.</p>', 'refs' => [ 'AwsEc2NetworkAclEntryList$member' => NULL, ], ], 'AwsEc2NetworkAclEntryList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkAclDetails$Entries' => '<p>The set of rules in the network ACL.</p>', ], ], 'AwsEc2NetworkInterfaceAttachment' => [ 'base' => '<p>Information about the network interface attachment.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceDetails$Attachment' => '<p>The network interface attachment.</p>', ], ], 'AwsEc2NetworkInterfaceDetails' => [ 'base' => '<p>Details about the network interface</p>', 'refs' => [ 'ResourceDetails$AwsEc2NetworkInterface' => '<p>Details for an EC2 network interface.</p>', ], ], 'AwsEc2NetworkInterfaceIpV6AddressDetail' => [ 'base' => '<p>Provides information about an IPV6 address that is associated with the network interface.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceIpV6AddressList$member' => NULL, ], ], 'AwsEc2NetworkInterfaceIpV6AddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkInterfaceDetails$IpV6Addresses' => '<p>The IPv6 addresses associated with the network interface.</p>', ], ], 'AwsEc2NetworkInterfacePrivateIpAddressDetail' => [ 'base' => '<p>Provides information about a private IPv4 address that is with the network interface.</p>', 'refs' => [ 'AwsEc2NetworkInterfacePrivateIpAddressList$member' => NULL, ], ], 'AwsEc2NetworkInterfacePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkInterfaceDetails$PrivateIpAddresses' => '<p>The private IPv4 addresses associated with the network interface.</p>', ], ], 'AwsEc2NetworkInterfaceSecurityGroup' => [ 'base' => '<p>A security group associated with the network interface.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceSecurityGroupList$member' => NULL, ], ], 'AwsEc2NetworkInterfaceSecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkInterfaceDetails$SecurityGroups' => '<p>Security groups for the network interface.</p>', ], ], 'AwsEc2RouteTableDetails' => [ 'base' => '<p> Provides details about a route table for the specified VPC. </p>', 'refs' => [ 'ResourceDetails$AwsEc2RouteTable' => '<p> Provides details about a route table. A route table contains a set of rules, called routes, that determine where to direct network traffic from your subnet or gateway. </p>', ], ], 'AwsEc2SecurityGroupDetails' => [ 'base' => '<p>Details about an Amazon EC2 security group.</p>', 'refs' => [ 'ResourceDetails$AwsEc2SecurityGroup' => '<p>Details for an EC2 security group.</p>', ], ], 'AwsEc2SecurityGroupIpPermission' => [ 'base' => '<p>An IP permission for an EC2 security group.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpPermissionList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpPermissionList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupDetails$IpPermissions' => '<p>The inbound rules associated with the security group.</p>', 'AwsEc2SecurityGroupDetails$IpPermissionsEgress' => '<p>[VPC only] The outbound rules associated with the security group.</p>', ], ], 'AwsEc2SecurityGroupIpRange' => [ 'base' => '<p>A range of IPv4 addresses.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpRangeList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpRangeList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$IpRanges' => '<p>The IPv4 ranges.</p>', ], ], 'AwsEc2SecurityGroupIpv6Range' => [ 'base' => '<p>A range of IPv6 addresses.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpv6RangeList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpv6RangeList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$Ipv6Ranges' => '<p>The IPv6 ranges.</p>', ], ], 'AwsEc2SecurityGroupPrefixListId' => [ 'base' => '<p>A prefix list ID.</p>', 'refs' => [ 'AwsEc2SecurityGroupPrefixListIdList$member' => NULL, ], ], 'AwsEc2SecurityGroupPrefixListIdList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$PrefixListIds' => '<p>[VPC only] The prefix list IDs for an Amazon Web Services service. With outbound rules, this is the Amazon Web Services service to access through a VPC endpoint from instances associated with the security group.</p>', ], ], 'AwsEc2SecurityGroupUserIdGroupPair' => [ 'base' => '<p>A relationship between a security group and a user.</p>', 'refs' => [ 'AwsEc2SecurityGroupUserIdGroupPairList$member' => NULL, ], ], 'AwsEc2SecurityGroupUserIdGroupPairList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$UserIdGroupPairs' => '<p>The security group and Amazon Web Services account ID pairs.</p>', ], ], 'AwsEc2SubnetDetails' => [ 'base' => '<p>Contains information about a subnet in Amazon EC2.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Subnet' => '<p>Details about a subnet in Amazon EC2.</p>', ], ], 'AwsEc2TransitGatewayDetails' => [ 'base' => '<p>Information about an Amazon Web Services Amazon EC2 Transit Gateway that interconnects virtual private clouds (VPCs) and on-premises networks. </p>', 'refs' => [ 'ResourceDetails$AwsEc2TransitGateway' => '<p>Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and on-premises networks.</p>', ], ], 'AwsEc2VolumeAttachment' => [ 'base' => '<p>An attachment to an Amazon EC2 volume.</p>', 'refs' => [ 'AwsEc2VolumeAttachmentList$member' => NULL, ], ], 'AwsEc2VolumeAttachmentList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VolumeDetails$Attachments' => '<p>The volume attachments.</p>', ], ], 'AwsEc2VolumeDetails' => [ 'base' => '<p>Details about an EC2 volume.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Volume' => '<p>Details for an Amazon EC2 volume.</p>', ], ], 'AwsEc2VpcDetails' => [ 'base' => '<p>Details about an EC2 VPC.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Vpc' => '<p>Details for an Amazon EC2 VPC.</p>', ], ], 'AwsEc2VpcEndpointServiceDetails' => [ 'base' => '<p>Contains details about the service configuration for a VPC endpoint service.</p>', 'refs' => [ 'ResourceDetails$AwsEc2VpcEndpointService' => '<p>Details about the service configuration for a VPC endpoint service.</p>', ], ], 'AwsEc2VpcEndpointServiceServiceTypeDetails' => [ 'base' => '<p>The service type information for a VPC endpoint service.</p>', 'refs' => [ 'AwsEc2VpcEndpointServiceServiceTypeList$member' => NULL, ], ], 'AwsEc2VpcEndpointServiceServiceTypeList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcEndpointServiceDetails$ServiceType' => '<p>The types for the service.</p>', ], ], 'AwsEc2VpcPeeringConnectionDetails' => [ 'base' => '<p>Provides information about a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. </p>', 'refs' => [ 'ResourceDetails$AwsEc2VpcPeeringConnection' => '<p>Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection between two VPCs that enables you to route traffic between them privately. </p>', ], ], 'AwsEc2VpcPeeringConnectionStatusDetails' => [ 'base' => '<p>Details about the status of the VPC peering connection. </p>', 'refs' => [ 'AwsEc2VpcPeeringConnectionDetails$Status' => '<p>The status of the VPC peering connection. </p>', ], ], 'AwsEc2VpcPeeringConnectionVpcInfoDetails' => [ 'base' => '<p>Describes a VPC in a VPC peering connection. </p>', 'refs' => [ 'AwsEc2VpcPeeringConnectionDetails$AccepterVpcInfo' => '<p>Information about the accepter VPC. </p>', 'AwsEc2VpcPeeringConnectionDetails$RequesterVpcInfo' => '<p>Information about the requester VPC. </p>', ], ], 'AwsEc2VpnConnectionDetails' => [ 'base' => '<p>Details about an Amazon EC2 VPN connection.</p>', 'refs' => [ 'ResourceDetails$AwsEc2VpnConnection' => '<p>Details about an Amazon EC2 VPN connection.</p>', ], ], 'AwsEc2VpnConnectionOptionsDetails' => [ 'base' => '<p>VPN connection options.</p>', 'refs' => [ 'AwsEc2VpnConnectionDetails$Options' => '<p>The VPN connection options.</p>', ], ], 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails' => [ 'base' => '<p>The VPN tunnel options.</p>', 'refs' => [ 'AwsEc2VpnConnectionOptionsTunnelOptionsList$member' => NULL, ], ], 'AwsEc2VpnConnectionOptionsTunnelOptionsList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpnConnectionOptionsDetails$TunnelOptions' => '<p>The VPN tunnel options.</p>', ], ], 'AwsEc2VpnConnectionRoutesDetails' => [ 'base' => '<p>A static routes associated with the VPN connection.</p>', 'refs' => [ 'AwsEc2VpnConnectionRoutesList$member' => NULL, ], ], 'AwsEc2VpnConnectionRoutesList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpnConnectionDetails$Routes' => '<p>The static routes that are associated with the VPN connection.</p>', ], ], 'AwsEc2VpnConnectionVgwTelemetryDetails' => [ 'base' => '<p>Information about the VPN tunnel.</p>', 'refs' => [ 'AwsEc2VpnConnectionVgwTelemetryList$member' => NULL, ], ], 'AwsEc2VpnConnectionVgwTelemetryList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpnConnectionDetails$VgwTelemetry' => '<p>Information about the VPN tunnel.</p>', ], ], 'AwsEcrContainerImageDetails' => [ 'base' => '<p>Information about an Amazon ECR image.</p>', 'refs' => [ 'ResourceDetails$AwsEcrContainerImage' => '<p>Information about an Amazon ECR image.</p>', ], ], 'AwsEcrRepositoryDetails' => [ 'base' => '<p>Provides information about an Amazon Elastic Container Registry repository.</p>', 'refs' => [ 'ResourceDetails$AwsEcrRepository' => '<p>Information about an Amazon Elastic Container Registry repository.</p>', ], ], 'AwsEcrRepositoryImageScanningConfigurationDetails' => [ 'base' => '<p>The image scanning configuration for a repository.</p>', 'refs' => [ 'AwsEcrRepositoryDetails$ImageScanningConfiguration' => '<p>The image scanning configuration for a repository.</p>', ], ], 'AwsEcrRepositoryLifecyclePolicyDetails' => [ 'base' => '<p>Information about the lifecycle policy for the repository.</p>', 'refs' => [ 'AwsEcrRepositoryDetails$LifecyclePolicy' => '<p>Information about the lifecycle policy for the repository.</p>', ], ], 'AwsEcsClusterClusterSettingsDetails' => [ 'base' => '<p>Indicates whether to enable CloudWatch Container Insights for the ECS cluster.</p>', 'refs' => [ 'AwsEcsClusterClusterSettingsList$member' => NULL, ], ], 'AwsEcsClusterClusterSettingsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsClusterDetails$ClusterSettings' => '<p>The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch Container Insights for the cluster.</p>', ], ], 'AwsEcsClusterConfigurationDetails' => [ 'base' => '<p>The run command configuration for the cluster.</p>', 'refs' => [ 'AwsEcsClusterDetails$Configuration' => '<p>The run command configuration for the cluster.</p>', ], ], 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails' => [ 'base' => '<p>Contains the run command configuration for the cluster.</p>', 'refs' => [ 'AwsEcsClusterConfigurationDetails$ExecuteCommandConfiguration' => '<p>Contains the run command configuration for the cluster.</p>', ], ], 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails' => [ 'base' => '<p>The log configuration for the results of the run command actions.</p>', 'refs' => [ 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails$LogConfiguration' => '<p>The log configuration for the results of the run command actions. Required if <code>Logging</code> is <code>NONE</code>.</p>', ], ], 'AwsEcsClusterDefaultCapacityProviderStrategyDetails' => [ 'base' => '<p>The default capacity provider strategy for the cluster. The default capacity provider strategy is used when services or tasks are run without a specified launch type or capacity provider strategy.</p>', 'refs' => [ 'AwsEcsClusterDefaultCapacityProviderStrategyList$member' => NULL, ], ], 'AwsEcsClusterDefaultCapacityProviderStrategyList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsClusterDetails$DefaultCapacityProviderStrategy' => '<p>The default capacity provider strategy for the cluster. The default capacity provider strategy is used when services or tasks are run without a specified launch type or capacity provider strategy.</p>', ], ], 'AwsEcsClusterDetails' => [ 'base' => '<p>Provides details about an Amazon ECS cluster.</p>', 'refs' => [ 'ResourceDetails$AwsEcsCluster' => '<p>Details about an Amazon ECS cluster.</p>', ], ], 'AwsEcsContainerDetails' => [ 'base' => '<p>Provides information about an Amazon ECS container. </p>', 'refs' => [ 'AwsEcsContainerDetailsList$member' => NULL, 'ResourceDetails$AwsEcsContainer' => '<p>Provides information about a Docker container that\'s part of a task. </p>', ], ], 'AwsEcsContainerDetailsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDetails$Containers' => '<p>The containers that are associated with the task. </p>', ], ], 'AwsEcsServiceCapacityProviderStrategyDetails' => [ 'base' => '<p>Strategy item for the capacity provider strategy that the service uses.</p>', 'refs' => [ 'AwsEcsServiceCapacityProviderStrategyList$member' => NULL, ], ], 'AwsEcsServiceCapacityProviderStrategyList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsServiceDetails$CapacityProviderStrategy' => '<p>The capacity provider strategy that the service uses.</p>', ], ], 'AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails' => [ 'base' => '<p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>', 'refs' => [ 'AwsEcsServiceDeploymentConfigurationDetails$DeploymentCircuitBreaker' => '<p>Determines whether a service deployment fails if a service cannot reach a steady state.</p>', ], ], 'AwsEcsServiceDeploymentConfigurationDetails' => [ 'base' => '<p>Optional deployment parameters for the service.</p>', 'refs' => [ 'AwsEcsServiceDetails$DeploymentConfiguration' => '<p>Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.</p>', ], ], 'AwsEcsServiceDeploymentControllerDetails' => [ 'base' => '<p>Information about the deployment controller type that the service uses.</p>', 'refs' => [ 'AwsEcsServiceDetails$DeploymentController' => '<p>Contains the deployment controller type that the service uses.</p>', ], ], 'AwsEcsServiceDetails' => [ 'base' => '<p>Provides details about a service within an ECS cluster.</p>', 'refs' => [ 'ResourceDetails$AwsEcsService' => '<p>Details about a service within an ECS cluster.</p>', ], ], 'AwsEcsServiceLoadBalancersDetails' => [ 'base' => '<p>Information about a load balancer that the service uses.</p>', 'refs' => [ 'AwsEcsServiceLoadBalancersList$member' => NULL, ], ], 'AwsEcsServiceLoadBalancersList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsServiceDetails$LoadBalancers' => '<p>Information about the load balancers that the service uses.</p>', ], ], 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails' => [ 'base' => '<p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>', 'refs' => [ 'AwsEcsServiceNetworkConfigurationDetails$AwsVpcConfiguration' => '<p>The VPC subnet and security group configuration.</p>', ], ], 'AwsEcsServiceNetworkConfigurationDetails' => [ 'base' => '<p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>', 'refs' => [ 'AwsEcsServiceDetails$NetworkConfiguration' => '<p>For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.</p>', ], ], 'AwsEcsServicePlacementConstraintsDetails' => [ 'base' => '<p>A placement constraint for the tasks in the service.</p>', 'refs' => [ 'AwsEcsServicePlacementConstraintsList$member' => NULL, ], ], 'AwsEcsServicePlacementConstraintsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsServiceDetails$PlacementConstraints' => '<p>The placement constraints for the tasks in the service.</p>', ], ], 'AwsEcsServicePlacementStrategiesDetails' => [ 'base' => '<p>A placement strategy that determines how to place the tasks for the service.</p>', 'refs' => [ 'AwsEcsServicePlacementStrategiesList$member' => NULL, ], ], 'AwsEcsServicePlacementStrategiesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsServiceDetails$PlacementStrategies' => '<p>Information about how tasks for the service are placed.</p>', ], ], 'AwsEcsServiceServiceRegistriesDetails' => [ 'base' => '<p>Information about a service discovery registry to assign to the service.</p>', 'refs' => [ 'AwsEcsServiceServiceRegistriesList$member' => NULL, ], ], 'AwsEcsServiceServiceRegistriesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsServiceDetails$ServiceRegistries' => '<p>Information about the service discovery registries to assign to the service.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails' => [ 'base' => '<p>A dependency that is defined for container startup and shutdown.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DependsOn' => '<p>The dependencies that are defined for container startup and shutdown.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsDetails' => [ 'base' => '<p>A container definition that describes a container in the task.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails' => [ 'base' => '<p>An environment variable to pass to the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails' => [ 'base' => '<p>A file that contain environment variables to pass to a container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$EnvironmentFiles' => '<p>A list of files containing the environment variables to pass to a container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Environment' => '<p>The environment variables to pass to a container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails' => [ 'base' => '<p>A hostname and IP address mapping to append to the <b>/etc/hosts</b> file on the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$ExtraHosts' => '<p>A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails' => [ 'base' => '<p>The FireLens configuration for the container. The configuration specifies and configures a log router for container logs.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$FirelensConfiguration' => '<p>The FireLens configuration for the container. Specifies and configures a log router for container logs.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails' => [ 'base' => '<p>The container health check command and associated configuration parameters for the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$HealthCheck' => '<p>The container health check command and associated configuration parameters for the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails' => [ 'base' => '<p>The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$Capabilities' => '<p>The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails' => [ 'base' => '<p>&gt;Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$LinuxParameters' => '<p>Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails' => [ 'base' => '<p>A host device to expose to the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$Devices' => '<p>The host devices to expose to the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails' => [ 'base' => '<p>The container path, mount options, and size (in MiB) of a tmpfs mount.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$Tmpfs' => '<p>The container path, mount options, and size (in MiB) of the tmpfs mount.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionDetails$ContainerDefinitions' => '<p>The container definitions that describe the containers that make up the task.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails' => [ 'base' => '<p>The log configuration specification for the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$LogConfiguration' => '<p>The log configuration specification for the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails' => [ 'base' => '<p>A secret to pass to the log configuration.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails$SecretOptions' => '<p>The secrets to pass to the log configuration.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails' => [ 'base' => '<p>A mount point for the data volumes in the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$MountPoints' => '<p>The mount points for the data volumes in the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails' => [ 'base' => '<p>A port mapping for the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$PortMappings' => '<p>The list of port mappings for the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails' => [ 'base' => '<p>The private repository authentication credentials to use.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$RepositoryCredentials' => '<p>The private repository authentication credentials to use.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails' => [ 'base' => '<p>A resource to assign to a container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$ResourceRequirements' => '<p>The type and amount of a resource to assign to a container. The only supported resource is a GPU.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails' => [ 'base' => '<p>A secret to pass to the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsSecretsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSecretsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Secrets' => '<p>The secrets to pass to the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails' => [ 'base' => '<p>A namespaced kernel parameter to set in the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$SystemControls' => '<p>A list of namespaced kernel parameters to set in the container.</p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails' => [ 'base' => '<p>A ulimit to set in the container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Ulimits' => '<p>A list of ulimits to set in the container. </p>', ], ], 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails' => [ 'base' => '<p>A data volume to mount from another container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromList$member' => NULL, ], ], 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionContainerDefinitionsDetails$VolumesFrom' => '<p>Data volumes to mount from another container.</p>', ], ], 'AwsEcsTaskDefinitionDetails' => [ 'base' => '<p>Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>', 'refs' => [ 'ResourceDetails$AwsEcsTaskDefinition' => '<p>Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.</p>', ], ], 'AwsEcsTaskDefinitionInferenceAcceleratorsDetails' => [ 'base' => '<p>An Elastic Inference accelerator to use for the containers in the task.</p>', 'refs' => [ 'AwsEcsTaskDefinitionInferenceAcceleratorsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionInferenceAcceleratorsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionDetails$InferenceAccelerators' => '<p>The Elastic Inference accelerators to use for the containers in the task.</p>', ], ], 'AwsEcsTaskDefinitionPlacementConstraintsDetails' => [ 'base' => '<p>A placement constraint object to use for tasks.</p>', 'refs' => [ 'AwsEcsTaskDefinitionPlacementConstraintsList$member' => NULL, ], ], 'AwsEcsTaskDefinitionPlacementConstraintsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionDetails$PlacementConstraints' => '<p>The placement constraint objects to use for tasks.</p>', ], ], 'AwsEcsTaskDefinitionProxyConfigurationDetails' => [ 'base' => '<p>The configuration details for the App Mesh proxy.</p>', 'refs' => [ 'AwsEcsTaskDefinitionDetails$ProxyConfiguration' => '<p>The configuration details for the App Mesh proxy.</p>', ], ], 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails' => [ 'base' => '<p>A network configuration parameter to provide to the Container Network Interface (CNI) plugin.</p>', 'refs' => [ 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList$member' => NULL, ], ], 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionProxyConfigurationDetails$ProxyConfigurationProperties' => '<p>The set of network configuration parameters to provide to the Container Network Interface (CNI) plugin, specified as key-value pairs.</p>', ], ], 'AwsEcsTaskDefinitionVolumesDetails' => [ 'base' => '<p>A data volume to mount from another container.</p>', 'refs' => [ 'AwsEcsTaskDefinitionVolumesList$member' => NULL, ], ], 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails' => [ 'base' => '<p>Information about a Docker volume.</p>', 'refs' => [ 'AwsEcsTaskDefinitionVolumesDetails$DockerVolumeConfiguration' => '<p>Information about a Docker volume.</p>', ], ], 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails' => [ 'base' => '<p/>', 'refs' => [ 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails$AuthorizationConfig' => '<p>The authorization configuration details for the Amazon EFS file system.</p>', ], ], 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails' => [ 'base' => '<p>Information about the Amazon Elastic File System file system that is used for task storage.</p>', 'refs' => [ 'AwsEcsTaskDefinitionVolumesDetails$EfsVolumeConfiguration' => '<p>Information about the Amazon Elastic File System file system that is used for task storage.</p>', ], ], 'AwsEcsTaskDefinitionVolumesHostDetails' => [ 'base' => '<p>Information about a bind mount host volume.</p>', 'refs' => [ 'AwsEcsTaskDefinitionVolumesDetails$Host' => '<p>Information about a bind mount host volume.</p>', ], ], 'AwsEcsTaskDefinitionVolumesList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDefinitionDetails$Volumes' => '<p>The data volume definitions for the task.</p>', ], ], 'AwsEcsTaskDetails' => [ 'base' => '<p>Provides details about a task in a cluster. </p>', 'refs' => [ 'ResourceDetails$AwsEcsTask' => '<p>Details about a task in a cluster. </p>', ], ], 'AwsEcsTaskVolumeDetails' => [ 'base' => '<p>Provides information about a data volume that\'s used in a task definition. </p>', 'refs' => [ 'AwsEcsTaskVolumeDetailsList$member' => NULL, ], ], 'AwsEcsTaskVolumeDetailsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsTaskDetails$Volumes' => '<p>Details about the data volume that is used in a task definition. </p>', ], ], 'AwsEcsTaskVolumeHostDetails' => [ 'base' => '<p>Provides details on a container instance bind mount host volume. </p>', 'refs' => [ 'AwsEcsTaskVolumeDetails$Host' => '<p>This parameter is specified when you use bind mount host volumes. The contents of the <code>host</code> parameter determine whether your bind mount host volume persists on the host container instance and where it\'s stored. </p>', ], ], 'AwsEfsAccessPointDetails' => [ 'base' => '<p>Provides information about an Amazon EFS access point. </p>', 'refs' => [ 'ResourceDetails$AwsEfsAccessPoint' => '<p>Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. </p>', ], ], 'AwsEfsAccessPointPosixUserDetails' => [ 'base' => '<p>Provides details for all file system operations using this Amazon EFS access point. </p>', 'refs' => [ 'AwsEfsAccessPointDetails$PosixUser' => '<p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that is used for all file operations by NFS clients using the access point. </p>', ], ], 'AwsEfsAccessPointRootDirectoryCreationInfoDetails' => [ 'base' => '<p>Provides information about the settings that Amazon EFS uses to create the root directory when a client connects to an access point. </p>', 'refs' => [ 'AwsEfsAccessPointRootDirectoryDetails$CreationInfo' => '<p>Specifies the POSIX IDs and permissions to apply to the access point\'s root directory. </p>', ], ], 'AwsEfsAccessPointRootDirectoryDetails' => [ 'base' => '<p>Provides information about the directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point. </p>', 'refs' => [ 'AwsEfsAccessPointDetails$RootDirectory' => '<p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point. </p>', ], ], 'AwsEksClusterDetails' => [ 'base' => '<p>Provides details about an Amazon EKS cluster.</p>', 'refs' => [ 'ResourceDetails$AwsEksCluster' => '<p>Details about an Amazon EKS cluster.</p>', ], ], 'AwsEksClusterLoggingClusterLoggingDetails' => [ 'base' => '<p>Details for a cluster logging configuration.</p>', 'refs' => [ 'AwsEksClusterLoggingClusterLoggingList$member' => NULL, ], ], 'AwsEksClusterLoggingClusterLoggingList' => [ 'base' => NULL, 'refs' => [ 'AwsEksClusterLoggingDetails$ClusterLogging' => '<p>Cluster logging configurations.</p>', ], ], 'AwsEksClusterLoggingDetails' => [ 'base' => '<p>The logging configuration for an Amazon EKS cluster.</p>', 'refs' => [ 'AwsEksClusterDetails$Logging' => '<p>The logging configuration for the cluster.</p>', ], ], 'AwsEksClusterResourcesVpcConfigDetails' => [ 'base' => '<p>Information about the VPC configuration used by the cluster control plane.</p>', 'refs' => [ 'AwsEksClusterDetails$ResourcesVpcConfig' => '<p>The VPC configuration used by the cluster control plane.</p>', ], ], 'AwsElasticBeanstalkEnvironmentDetails' => [ 'base' => '<p>Contains details about an Elastic Beanstalk environment.</p>', 'refs' => [ 'ResourceDetails$AwsElasticBeanstalkEnvironment' => '<p>Details about an Elastic Beanstalk environment.</p>', ], ], 'AwsElasticBeanstalkEnvironmentEnvironmentLink' => [ 'base' => '<p>Contains information about a link to another environment that is in the same group.</p>', 'refs' => [ 'AwsElasticBeanstalkEnvironmentEnvironmentLinks$member' => NULL, ], ], 'AwsElasticBeanstalkEnvironmentEnvironmentLinks' => [ 'base' => NULL, 'refs' => [ 'AwsElasticBeanstalkEnvironmentDetails$EnvironmentLinks' => '<p>Links to other environments in the same group.</p>', ], ], 'AwsElasticBeanstalkEnvironmentOptionSetting' => [ 'base' => '<p>A configuration option setting for the environment.</p>', 'refs' => [ 'AwsElasticBeanstalkEnvironmentOptionSettings$member' => NULL, ], ], 'AwsElasticBeanstalkEnvironmentOptionSettings' => [ 'base' => NULL, 'refs' => [ 'AwsElasticBeanstalkEnvironmentDetails$OptionSettings' => '<p>The configuration setting for the environment.</p>', ], ], 'AwsElasticBeanstalkEnvironmentTier' => [ 'base' => '<p>Contains information about the tier of the environment.</p>', 'refs' => [ 'AwsElasticBeanstalkEnvironmentDetails$Tier' => '<p>The tier of the environment.</p>', ], ], 'AwsElasticsearchDomainDetails' => [ 'base' => '<p>Information about an Elasticsearch domain.</p>', 'refs' => [ 'ResourceDetails$AwsElasticsearchDomain' => '<p>Details for an Elasticsearch domain.</p>', ], ], 'AwsElasticsearchDomainDomainEndpointOptions' => [ 'base' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$DomainEndpointOptions' => '<p>Additional options for the domain endpoint.</p>', ], ], 'AwsElasticsearchDomainElasticsearchClusterConfigDetails' => [ 'base' => '<p>details about the configuration of an OpenSearch cluster.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$ElasticsearchClusterConfig' => '<p>Information about an OpenSearch cluster configuration.</p>', ], ], 'AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails' => [ 'base' => '<p>Configuration options for zone awareness.</p>', 'refs' => [ 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$ZoneAwarenessConfig' => '<p>Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>', ], ], 'AwsElasticsearchDomainEncryptionAtRestOptions' => [ 'base' => '<p>Details about the configuration for encryption at rest.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$EncryptionAtRestOptions' => '<p>Details about the configuration for encryption at rest.</p>', ], ], 'AwsElasticsearchDomainLogPublishingOptions' => [ 'base' => '<p>configures the CloudWatch Logs to publish for the Elasticsearch domain.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$LogPublishingOptions' => '<p>Configures the CloudWatch Logs to publish for the Elasticsearch domain.</p>', ], ], 'AwsElasticsearchDomainLogPublishingOptionsLogConfig' => [ 'base' => '<p>The log configuration.</p>', 'refs' => [ 'AwsElasticsearchDomainLogPublishingOptions$IndexSlowLogs' => '<p>Configures the OpenSearch index logs publishing.</p>', 'AwsElasticsearchDomainLogPublishingOptions$SearchSlowLogs' => '<p>Configures the OpenSearch search slow log publishing.</p>', 'AwsElasticsearchDomainLogPublishingOptions$AuditLogs' => NULL, ], ], 'AwsElasticsearchDomainNodeToNodeEncryptionOptions' => [ 'base' => '<p>Details about the configuration for node-to-node encryption.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$NodeToNodeEncryptionOptions' => '<p>Details about the configuration for node-to-node encryption.</p>', ], ], 'AwsElasticsearchDomainServiceSoftwareOptions' => [ 'base' => '<p>Information about the state of the domain relative to the latest service software.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$ServiceSoftwareOptions' => '<p>Information about the status of a domain relative to the latest service software.</p>', ], ], 'AwsElasticsearchDomainVPCOptions' => [ 'base' => '<p>Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$VPCOptions' => '<p>Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.</p>', ], ], 'AwsElbAppCookieStickinessPolicies' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerPolicies$AppCookieStickinessPolicies' => '<p>The stickiness policies that are created using <code>CreateAppCookieStickinessPolicy</code>.</p>', ], ], 'AwsElbAppCookieStickinessPolicy' => [ 'base' => '<p>Contains information about a stickiness policy that was created using <code>CreateAppCookieStickinessPolicy</code>.</p>', 'refs' => [ 'AwsElbAppCookieStickinessPolicies$member' => NULL, ], ], 'AwsElbLbCookieStickinessPolicies' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerPolicies$LbCookieStickinessPolicies' => '<p>The stickiness policies that are created using <code>CreateLBCookieStickinessPolicy</code>.</p>', ], ], 'AwsElbLbCookieStickinessPolicy' => [ 'base' => '<p>Contains information about a stickiness policy that was created using <code>CreateLBCookieStickinessPolicy</code>.</p>', 'refs' => [ 'AwsElbLbCookieStickinessPolicies$member' => NULL, ], ], 'AwsElbLoadBalancerAccessLog' => [ 'base' => '<p>Contains information about the access log configuration for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerAttributes$AccessLog' => '<p>Information about the access log configuration for the load balancer.</p> <p>If the access log is enabled, the load balancer captures detailed information about all requests. It delivers the information to a specified S3 bucket.</p>', ], ], 'AwsElbLoadBalancerAdditionalAttribute' => [ 'base' => '<p>Provides information about additional attributes for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerAdditionalAttributeList$member' => NULL, ], ], 'AwsElbLoadBalancerAdditionalAttributeList' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerAttributes$AdditionalAttributes' => '<p>Any additional attributes for a load balancer.</p>', ], ], 'AwsElbLoadBalancerAttributes' => [ 'base' => '<p>Contains attributes for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerDetails$LoadBalancerAttributes' => '<p>The attributes for a load balancer.</p>', ], ], 'AwsElbLoadBalancerBackendServerDescription' => [ 'base' => '<p>Provides information about the configuration of an EC2 instance for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerBackendServerDescriptions$member' => NULL, ], ], 'AwsElbLoadBalancerBackendServerDescriptions' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerDetails$BackendServerDescriptions' => '<p>Information about the configuration of the EC2 instances.</p>', ], ], 'AwsElbLoadBalancerConnectionDraining' => [ 'base' => '<p>Contains information about the connection draining configuration for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerAttributes$ConnectionDraining' => '<p>Information about the connection draining configuration for the load balancer.</p> <p>If connection draining is enabled, the load balancer allows existing requests to complete before it shifts traffic away from a deregistered or unhealthy instance.</p>', ], ], 'AwsElbLoadBalancerConnectionSettings' => [ 'base' => '<p>Contains connection settings for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerAttributes$ConnectionSettings' => '<p>Connection settings for the load balancer.</p> <p>If an idle timeout is configured, the load balancer allows connections to remain idle for the specified duration. When a connection is idle, no data is sent over the connection.</p>', ], ], 'AwsElbLoadBalancerCrossZoneLoadBalancing' => [ 'base' => '<p>Contains cross-zone load balancing settings for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerAttributes$CrossZoneLoadBalancing' => '<p>Cross-zone load balancing settings for the load balancer.</p> <p>If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.</p>', ], ], 'AwsElbLoadBalancerDetails' => [ 'base' => '<p>Contains details about a Classic Load Balancer.</p>', 'refs' => [ 'ResourceDetails$AwsElbLoadBalancer' => '<p>Contains details about a Classic Load Balancer.</p>', ], ], 'AwsElbLoadBalancerHealthCheck' => [ 'base' => '<p>Contains information about the health checks that are conducted on the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerDetails$HealthCheck' => '<p>Information about the health checks that are conducted on the load balancer.</p>', ], ], 'AwsElbLoadBalancerInstance' => [ 'base' => '<p>Provides information about an EC2 instance for a load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerInstances$member' => NULL, ], ], 'AwsElbLoadBalancerInstances' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerDetails$Instances' => '<p>List of EC2 instances for the load balancer.</p>', ], ], 'AwsElbLoadBalancerListener' => [ 'base' => '<p>Information about a load balancer listener.</p>', 'refs' => [ 'AwsElbLoadBalancerListenerDescription$Listener' => '<p>Information about the listener.</p>', ], ], 'AwsElbLoadBalancerListenerDescription' => [ 'base' => '<p>Lists the policies that are enabled for a load balancer listener.</p>', 'refs' => [ 'AwsElbLoadBalancerListenerDescriptions$member' => NULL, ], ], 'AwsElbLoadBalancerListenerDescriptions' => [ 'base' => NULL, 'refs' => [ 'AwsElbLoadBalancerDetails$ListenerDescriptions' => '<p>The policies that are enabled for the load balancer listeners.</p>', ], ], 'AwsElbLoadBalancerPolicies' => [ 'base' => '<p>Contains information about the policies for a load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerDetails$Policies' => '<p>The policies for a load balancer.</p>', ], ], 'AwsElbLoadBalancerSourceSecurityGroup' => [ 'base' => '<p>Contains information about the security group for the load balancer.</p>', 'refs' => [ 'AwsElbLoadBalancerDetails$SourceSecurityGroup' => '<p>Information about the security group for the load balancer. This is the security group that is used for inbound rules.</p>', ], ], 'AwsElbv2LoadBalancerAttribute' => [ 'base' => '<p>A load balancer attribute.</p>', 'refs' => [ 'AwsElbv2LoadBalancerAttributes$member' => NULL, ], ], 'AwsElbv2LoadBalancerAttributes' => [ 'base' => NULL, 'refs' => [ 'AwsElbv2LoadBalancerDetails$LoadBalancerAttributes' => '<p>Attributes of the load balancer.</p>', ], ], 'AwsElbv2LoadBalancerDetails' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [ 'ResourceDetails$AwsElbv2LoadBalancer' => '<p>Details about a load balancer.</p>', ], ], 'AwsEventSchemasRegistryDetails' => [ 'base' => '<p> A schema defines the structure of events that are sent to Amazon EventBridge. Schema registries are containers for schemas. They collect and organize schemas so that your schemas are in logical groups. </p>', 'refs' => [ 'ResourceDetails$AwsEventSchemasRegistry' => '<p> A schema defines the structure of events that are sent to Amazon EventBridge. Schema registries are containers for schemas. They collect and organize schemas so that your schemas are in logical groups. </p>', ], ], 'AwsEventsEndpointDetails' => [ 'base' => '<p> Provides details about an Amazon EventBridge global endpoint. The endpoint can improve your application’s availability by making it Regional-fault tolerant. </p>', 'refs' => [ 'ResourceDetails$AwsEventsEndpoint' => '<p> Provides details about an Amazon EventBridge global endpoint. The endpoint can improve your application’s availability by making it Regional-fault tolerant.</p>', ], ], 'AwsEventsEndpointEventBusesDetails' => [ 'base' => '<p> Provides details about the Amazon EventBridge event buses that the endpoint is associated with.</p>', 'refs' => [ 'AwsEventsEndpointEventBusesList$member' => NULL, ], ], 'AwsEventsEndpointEventBusesList' => [ 'base' => NULL, 'refs' => [ 'AwsEventsEndpointDetails$EventBuses' => '<p> The event buses being used by the endpoint.</p>', ], ], 'AwsEventsEndpointReplicationConfigDetails' => [ 'base' => '<p> Indicates whether replication is enabled or disabled for the endpoint. If enabled, the endpoint can replicate all events to a secondary Amazon Web Services Region.</p>', 'refs' => [ 'AwsEventsEndpointDetails$ReplicationConfig' => '<p> Whether event replication was enabled or disabled for this endpoint. The default state is <code>ENABLED</code>, which means you must supply a <code>RoleArn</code>. If you don\'t have a <code>RoleArn</code> or you don\'t want event replication enabled, set the state to <code>DISABLED</code>.</p>', ], ], 'AwsEventsEndpointRoutingConfigDetails' => [ 'base' => '<p> Provides details about the routing configuration of the endpoint.</p>', 'refs' => [ 'AwsEventsEndpointDetails$RoutingConfig' => '<p> The routing configuration of the endpoint.</p>', ], ], 'AwsEventsEndpointRoutingConfigFailoverConfigDetails' => [ 'base' => '<p> The failover configuration for an endpoint. This includes what triggers failover and what happens when it\'s triggered.</p>', 'refs' => [ 'AwsEventsEndpointRoutingConfigDetails$FailoverConfig' => '<p> The failover configuration for an endpoint. This includes what triggers failover and what happens when it\'s triggered.</p>', ], ], 'AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails' => [ 'base' => '<p> Provides details about the primary Amazon Web Services Region of the endpoint.</p>', 'refs' => [ 'AwsEventsEndpointRoutingConfigFailoverConfigDetails$Primary' => '<p> The main Region of the endpoint.</p>', ], ], 'AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails' => [ 'base' => '<p> The Amazon Web Services Region that events are routed to when failover is triggered or event replication is enabled.</p>', 'refs' => [ 'AwsEventsEndpointRoutingConfigFailoverConfigDetails$Secondary' => '<p> The Region that events are routed to when failover is triggered or event replication is enabled.</p>', ], ], 'AwsEventsEventbusDetails' => [ 'base' => '<p> Provides details about Amazon EventBridge event bus. An event bus is a router that receives events and delivers them to zero or more destinations, or targets. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.</p>', 'refs' => [ 'ResourceDetails$AwsEventsEventbus' => '<p> Provides details about Amazon EventBridge event bus for an endpoint. An event bus is a router that receives events and delivers them to zero or more destinations, or targets.</p>', ], ], 'AwsGuardDutyDetectorDataSourcesCloudTrailDetails' => [ 'base' => '<p> An object that contains information on the status of CloudTrail as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$CloudTrail' => '<p> An object that contains information on the status of CloudTrail as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesDetails' => [ 'base' => '<p> Describes which data sources are activated for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDetails$DataSources' => '<p> Describes which data sources are activated for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesDnsLogsDetails' => [ 'base' => '<p> An object that contains information on the status of DNS logs as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$DnsLogs' => '<p> An object that contains information on the status of DNS logs as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesFlowLogsDetails' => [ 'base' => '<p> An object that contains information on the status of VPC Flow Logs as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$FlowLogs' => '<p> An object that contains information on the status of VPC Flow Logs as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails' => [ 'base' => '<p> An object that contains information on the status of Kubernetes audit logs as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesKubernetesDetails$AuditLogs' => '<p> Describes whether Kubernetes audit logs are activated as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesKubernetesDetails' => [ 'base' => '<p> An object that contains information on the status of Kubernetes data sources for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$Kubernetes' => '<p> An object that contains information on the status of Kubernetes data sources for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails' => [ 'base' => '<p> An object that contains information on the status of Malware Protection as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$MalwareProtection' => '<p> An object that contains information on the status of Malware Protection as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails' => [ 'base' => '<p> Describes the configuration of Malware Protection for EC2 instances with findings. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails$ScanEc2InstanceWithFindings' => '<p> Describes the configuration of Malware Protection for EC2 instances with findings. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails' => [ 'base' => '<p> Describes the configuration of scanning EBS volumes (Malware Protection) as a data source. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails$EbsVolumes' => '<p> Describes the configuration of scanning EBS volumes (Malware Protection) as a data source. </p>', ], ], 'AwsGuardDutyDetectorDataSourcesS3LogsDetails' => [ 'base' => '<p> An object that contains information on the status of S3 data event logs as a data source for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorDataSourcesDetails$S3Logs' => '<p> An object that contains information on the status of S3 Data event logs as a data source for the detector. </p>', ], ], 'AwsGuardDutyDetectorDetails' => [ 'base' => '<p> Provides details about an Amazon GuardDuty detector. A detector is an object that represents the GuardDuty service. A detector is required for GuardDuty to become operational. </p>', 'refs' => [ 'ResourceDetails$AwsGuardDutyDetector' => '<p> Provides details about an Amazon GuardDuty detector. A detector is an object that represents the GuardDuty service. A detector is required for GuardDuty to become operational. </p>', ], ], 'AwsGuardDutyDetectorFeaturesDetails' => [ 'base' => '<p> Describes which features are activated for the detector. </p>', 'refs' => [ 'AwsGuardDutyDetectorFeaturesList$member' => NULL, ], ], 'AwsGuardDutyDetectorFeaturesList' => [ 'base' => NULL, 'refs' => [ 'AwsGuardDutyDetectorDetails$Features' => '<p> Describes which features are activated for the detector. </p>', ], ], 'AwsIamAccessKeyDetails' => [ 'base' => '<p>IAM access key details related to a finding.</p>', 'refs' => [ 'ResourceDetails$AwsIamAccessKey' => '<p>Details about an IAM access key related to a finding.</p>', ], ], 'AwsIamAccessKeySessionContext' => [ 'base' => '<p>Provides information about the session that the key was used for.</p>', 'refs' => [ 'AwsIamAccessKeyDetails$SessionContext' => '<p>Information about the session that the key was used for.</p>', ], ], 'AwsIamAccessKeySessionContextAttributes' => [ 'base' => '<p>Attributes of the session that the key was used for.</p>', 'refs' => [ 'AwsIamAccessKeySessionContext$Attributes' => '<p>Attributes of the session that the key was used for.</p>', ], ], 'AwsIamAccessKeySessionContextSessionIssuer' => [ 'base' => '<p>Information about the entity that created the session.</p>', 'refs' => [ 'AwsIamAccessKeySessionContext$SessionIssuer' => '<p>Information about the entity that created the session.</p>', ], ], 'AwsIamAccessKeyStatus' => [ 'base' => NULL, 'refs' => [ 'AwsIamAccessKeyDetails$Status' => '<p>The status of the IAM access key related to a finding.</p>', ], ], 'AwsIamAttachedManagedPolicy' => [ 'base' => '<p>A managed policy that is attached to an IAM principal.</p>', 'refs' => [ 'AwsIamAttachedManagedPolicyList$member' => NULL, ], ], 'AwsIamAttachedManagedPolicyList' => [ 'base' => NULL, 'refs' => [ 'AwsIamGroupDetails$AttachedManagedPolicies' => '<p>A list of the managed policies that are attached to the IAM group.</p>', 'AwsIamRoleDetails$AttachedManagedPolicies' => '<p>The list of the managed policies that are attached to the role.</p>', 'AwsIamUserDetails$AttachedManagedPolicies' => '<p>A list of the managed policies that are attached to the user.</p>', ], ], 'AwsIamGroupDetails' => [ 'base' => '<p>Contains details about an IAM group.</p>', 'refs' => [ 'ResourceDetails$AwsIamGroup' => '<p>Contains details about an IAM group.</p>', ], ], 'AwsIamGroupPolicy' => [ 'base' => '<p>A managed policy that is attached to the IAM group.</p>', 'refs' => [ 'AwsIamGroupPolicyList$member' => NULL, ], ], 'AwsIamGroupPolicyList' => [ 'base' => NULL, 'refs' => [ 'AwsIamGroupDetails$GroupPolicyList' => '<p>The list of inline policies that are embedded in the group.</p>', ], ], 'AwsIamInstanceProfile' => [ 'base' => '<p>Information about an instance profile.</p>', 'refs' => [ 'AwsIamInstanceProfileList$member' => NULL, ], ], 'AwsIamInstanceProfileList' => [ 'base' => NULL, 'refs' => [ 'AwsIamRoleDetails$InstanceProfileList' => '<p>The list of instance profiles that contain this role.</p>', ], ], 'AwsIamInstanceProfileRole' => [ 'base' => '<p>Information about a role associated with an instance profile.</p>', 'refs' => [ 'AwsIamInstanceProfileRoles$member' => NULL, ], ], 'AwsIamInstanceProfileRoles' => [ 'base' => NULL, 'refs' => [ 'AwsIamInstanceProfile$Roles' => '<p>The roles associated with the instance profile.</p>', ], ], 'AwsIamPermissionsBoundary' => [ 'base' => '<p>Information about the policy used to set the permissions boundary for an IAM principal.</p>', 'refs' => [ 'AwsIamRoleDetails$PermissionsBoundary' => NULL, 'AwsIamUserDetails$PermissionsBoundary' => '<p>The permissions boundary for the user.</p>', ], ], 'AwsIamPolicyDetails' => [ 'base' => '<p>Represents an IAM permissions policy.</p>', 'refs' => [ 'ResourceDetails$AwsIamPolicy' => '<p>Details about an IAM permissions policy.</p>', ], ], 'AwsIamPolicyVersion' => [ 'base' => '<p>A version of an IAM policy.</p>', 'refs' => [ 'AwsIamPolicyVersionList$member' => NULL, ], ], 'AwsIamPolicyVersionList' => [ 'base' => NULL, 'refs' => [ 'AwsIamPolicyDetails$PolicyVersionList' => '<p>List of versions of the policy.</p>', ], ], 'AwsIamRoleAssumeRolePolicyDocument' => [ 'base' => NULL, 'refs' => [ 'AwsIamInstanceProfileRole$AssumeRolePolicyDocument' => '<p>The policy that grants an entity permission to assume the role.</p>', 'AwsIamRoleDetails$AssumeRolePolicyDocument' => '<p>The trust policy that grants permission to assume the role.</p>', ], ], 'AwsIamRoleDetails' => [ 'base' => '<p>Contains information about an IAM role, including all of the role\'s policies.</p>', 'refs' => [ 'ResourceDetails$AwsIamRole' => '<p>Details about an IAM role.</p>', ], ], 'AwsIamRolePolicy' => [ 'base' => '<p>An inline policy that is embedded in the role.</p>', 'refs' => [ 'AwsIamRolePolicyList$member' => NULL, ], ], 'AwsIamRolePolicyList' => [ 'base' => NULL, 'refs' => [ 'AwsIamRoleDetails$RolePolicyList' => '<p>The list of inline policies that are embedded in the role.</p>', ], ], 'AwsIamUserDetails' => [ 'base' => '<p>Information about an IAM user.</p>', 'refs' => [ 'ResourceDetails$AwsIamUser' => '<p>Details about an IAM user.</p>', ], ], 'AwsIamUserPolicy' => [ 'base' => '<p>Information about an inline policy that is embedded in the user.</p>', 'refs' => [ 'AwsIamUserPolicyList$member' => NULL, ], ], 'AwsIamUserPolicyList' => [ 'base' => NULL, 'refs' => [ 'AwsIamUserDetails$UserPolicyList' => '<p>The list of inline policies that are embedded in the user.</p>', ], ], 'AwsKinesisStreamDetails' => [ 'base' => '<p>Provides information about an Amazon Kinesis data stream. </p>', 'refs' => [ 'ResourceDetails$AwsKinesisStream' => '<p>Details about an Amazon Kinesis data stream.</p>', ], ], 'AwsKinesisStreamStreamEncryptionDetails' => [ 'base' => '<p>Provides information about stream encryption. </p>', 'refs' => [ 'AwsKinesisStreamDetails$StreamEncryption' => '<p>When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing this property from your stack template and updating your stack disables encryption. </p>', ], ], 'AwsKmsKeyDetails' => [ 'base' => '<p>Contains metadata about an KMS key.</p>', 'refs' => [ 'ResourceDetails$AwsKmsKey' => '<p>Details about an KMS key.</p>', ], ], 'AwsLambdaFunctionCode' => [ 'base' => '<p>The code for the Lambda function. You can specify either an object in Amazon S3, or upload a deployment package directly.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$Code' => '<p>An <code>AwsLambdaFunctionCode</code> object.</p>', ], ], 'AwsLambdaFunctionDeadLetterConfig' => [ 'base' => '<p>The dead-letter queue for failed asynchronous invocations.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$DeadLetterConfig' => '<p>The function\'s dead letter queue.</p>', ], ], 'AwsLambdaFunctionDetails' => [ 'base' => '<p>Details about an Lambda function\'s configuration.</p>', 'refs' => [ 'ResourceDetails$AwsLambdaFunction' => '<p>Details about a Lambda function.</p>', ], ], 'AwsLambdaFunctionEnvironment' => [ 'base' => '<p>A function\'s environment variable settings.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$Environment' => '<p>The function\'s environment variables.</p>', ], ], 'AwsLambdaFunctionEnvironmentError' => [ 'base' => '<p>Error messages for environment variables that could not be applied.</p>', 'refs' => [ 'AwsLambdaFunctionEnvironment$Error' => '<p>An <code>AwsLambdaFunctionEnvironmentError</code> object.</p>', ], ], 'AwsLambdaFunctionLayer' => [ 'base' => '<p>An Lambda layer.</p>', 'refs' => [ 'AwsLambdaFunctionLayerList$member' => NULL, ], ], 'AwsLambdaFunctionLayerList' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$Layers' => '<p>The function\'s layers.</p>', ], ], 'AwsLambdaFunctionTracingConfig' => [ 'base' => '<p>The function\'s X-Ray tracing configuration.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$TracingConfig' => '<p>The function\'s X-Ray tracing configuration.</p>', ], ], 'AwsLambdaFunctionVpcConfig' => [ 'base' => '<p>The VPC security groups and subnets that are attached to a Lambda function.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$VpcConfig' => '<p>The function\'s networking configuration.</p>', ], ], 'AwsLambdaLayerVersionDetails' => [ 'base' => '<p>Details about a Lambda layer version.</p>', 'refs' => [ 'ResourceDetails$AwsLambdaLayerVersion' => '<p>Details for a Lambda layer version.</p>', ], ], 'AwsLambdaLayerVersionNumber' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaLayerVersionDetails$Version' => '<p>The version number.</p>', ], ], 'AwsMountPoint' => [ 'base' => '<p>Details for a volume mount point that\'s used in a container definition. </p>', 'refs' => [ 'AwsMountPointList$member' => NULL, ], ], 'AwsMountPointList' => [ 'base' => NULL, 'refs' => [ 'AwsEcsContainerDetails$MountPoints' => '<p>The mount points for data volumes in your container. </p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationDetails' => [ 'base' => '<p> Provides details about different modes of client authentication.</p>', 'refs' => [ 'AwsMskClusterClusterInfoDetails$ClientAuthentication' => '<p> Provides information for different modes of client authentication.</p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationSaslDetails' => [ 'base' => '<p> Provides details for client authentication using SASL.</p>', 'refs' => [ 'AwsMskClusterClusterInfoClientAuthenticationDetails$Sasl' => '<p> Provides details for client authentication using SASL.</p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails' => [ 'base' => '<p> Details for SASL/IAM client authentication.</p>', 'refs' => [ 'AwsMskClusterClusterInfoClientAuthenticationSaslDetails$Iam' => '<p> Provides details for SASL client authentication using IAM. </p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails' => [ 'base' => '<p> Details for SASL/SCRAM client authentication.</p>', 'refs' => [ 'AwsMskClusterClusterInfoClientAuthenticationSaslDetails$Scram' => '<p> Details for SASL client authentication using SCRAM.</p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationTlsDetails' => [ 'base' => '<p> Provides details for client authentication using TLS.</p>', 'refs' => [ 'AwsMskClusterClusterInfoClientAuthenticationDetails$Tls' => '<p> Provides details for client authentication using TLS.</p>', ], ], 'AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails' => [ 'base' => '<p> Provides details for allowing no client authentication. </p>', 'refs' => [ 'AwsMskClusterClusterInfoClientAuthenticationDetails$Unauthenticated' => '<p> Provides details for allowing no client authentication.</p>', ], ], 'AwsMskClusterClusterInfoDetails' => [ 'base' => '<p> Provide details about an Amazon Managed Streaming for Apache Kafka (Amazon MSK) cluster.</p>', 'refs' => [ 'AwsMskClusterDetails$ClusterInfo' => '<p> Provides information about a cluster.</p>', ], ], 'AwsMskClusterClusterInfoEncryptionInfoDetails' => [ 'base' => '<p> Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you want MSK to encrypt your data in transit.</p>', 'refs' => [ 'AwsMskClusterClusterInfoDetails$EncryptionInfo' => '<p> Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you want Amazon MSK to encrypt your data in transit.</p>', ], ], 'AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails' => [ 'base' => '<p> The data-volume encryption details. You can\'t update encryption at rest settings for existing clusters.</p>', 'refs' => [ 'AwsMskClusterClusterInfoEncryptionInfoDetails$EncryptionAtRest' => '<p> The data-volume encryption details. You can\'t update encryption at rest settings for existing clusters.</p>', ], ], 'AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails' => [ 'base' => '<p> The settings for encrypting data in transit.</p>', 'refs' => [ 'AwsMskClusterClusterInfoEncryptionInfoDetails$EncryptionInTransit' => '<p> The settings for encrypting data in transit.</p>', ], ], 'AwsMskClusterDetails' => [ 'base' => '<p> Provides details about an Amazon Managed Streaming for Apache Kafka (Amazon MSK) cluster. </p>', 'refs' => [ 'ResourceDetails$AwsMskCluster' => '<p> Provides details about an Amazon Managed Streaming for Apache Kafka (Amazon MSK) cluster.</p>', ], ], 'AwsNetworkFirewallFirewallDetails' => [ 'base' => '<p>Details about an Network Firewall firewall.</p>', 'refs' => [ 'ResourceDetails$AwsNetworkFirewallFirewall' => '<p>Details about an Network Firewall firewall.</p>', ], ], 'AwsNetworkFirewallFirewallPolicyDetails' => [ 'base' => '<p>Details about a firewall policy. A firewall policy defines the behavior of a network firewall.</p>', 'refs' => [ 'ResourceDetails$AwsNetworkFirewallFirewallPolicy' => '<p>Details about an Network Firewall firewall policy.</p>', ], ], 'AwsNetworkFirewallFirewallSubnetMappingsDetails' => [ 'base' => '<p>A public subnet that Network Firewall uses for the firewall.</p>', 'refs' => [ 'AwsNetworkFirewallFirewallSubnetMappingsList$member' => NULL, ], ], 'AwsNetworkFirewallFirewallSubnetMappingsList' => [ 'base' => NULL, 'refs' => [ 'AwsNetworkFirewallFirewallDetails$SubnetMappings' => '<p>The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different Availability Zone.</p>', ], ], 'AwsNetworkFirewallRuleGroupDetails' => [ 'base' => '<p>Details about an Network Firewall rule group. Rule groups are used to inspect and control network traffic. Stateless rule groups apply to individual packets. Stateful rule groups apply to packets in the context of their traffic flow.</p> <p>Rule groups are referenced in firewall policies. </p>', 'refs' => [ 'ResourceDetails$AwsNetworkFirewallRuleGroup' => '<p>Details about an Network Firewall rule group.</p>', ], ], 'AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails' => [ 'base' => '<p>Provides information about domain access control options. </p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$AdvancedSecurityOptions' => '<p>Specifies options for fine-grained access control. </p>', ], ], 'AwsOpenSearchServiceDomainClusterConfigDetails' => [ 'base' => '<p>Details about the configuration of an OpenSearch cluster.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$ClusterConfig' => '<p>Details about the configuration of an OpenSearch cluster.</p>', ], ], 'AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails' => [ 'base' => '<p>Configuration options for zone awareness.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainClusterConfigDetails$ZoneAwarenessConfig' => '<p>Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>', ], ], 'AwsOpenSearchServiceDomainDetails' => [ 'base' => '<p>Information about an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'ResourceDetails$AwsOpenSearchServiceDomain' => '<p>Details about an Amazon OpenSearch Service domain.</p>', ], ], 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails' => [ 'base' => '<p>Information about additional options for the domain endpoint.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$DomainEndpointOptions' => '<p>Additional options for the domain endpoint.</p>', ], ], 'AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails' => [ 'base' => '<p>Details about the configuration for encryption at rest for the OpenSearch domain.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$EncryptionAtRestOptions' => '<p>Details about the configuration for encryption at rest.</p>', ], ], 'AwsOpenSearchServiceDomainLogPublishingOption' => [ 'base' => '<p>Configuration details for a log publishing option.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainLogPublishingOptionsDetails$IndexSlowLogs' => '<p>Configures the OpenSearch index logs publishing.</p>', 'AwsOpenSearchServiceDomainLogPublishingOptionsDetails$SearchSlowLogs' => '<p>Configures the OpenSearch search slow log publishing.</p>', 'AwsOpenSearchServiceDomainLogPublishingOptionsDetails$AuditLogs' => '<p>Configures the OpenSearch audit logs publishing.</p>', ], ], 'AwsOpenSearchServiceDomainLogPublishingOptionsDetails' => [ 'base' => '<p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$LogPublishingOptions' => '<p>Configures the CloudWatch Logs to publish for the OpenSearch domain.</p>', ], ], 'AwsOpenSearchServiceDomainMasterUserOptionsDetails' => [ 'base' => '<p>Specifies information about the master user of the domain. </p>', 'refs' => [ 'AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails$MasterUserOptions' => '<p>Specifies information about the master user of the domain. </p>', ], ], 'AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails' => [ 'base' => '<p>Provides details about the configuration for node-to-node encryption.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$NodeToNodeEncryptionOptions' => '<p>Details about the configuration for node-to-node encryption.</p>', ], ], 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails' => [ 'base' => '<p>Provides information about the state of the domain relative to the latest service software.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$ServiceSoftwareOptions' => '<p>Information about the status of a domain relative to the latest service software.</p>', ], ], 'AwsOpenSearchServiceDomainVpcOptionsDetails' => [ 'base' => '<p>Contains information that OpenSearch Service derives based on the <code>VPCOptions</code> for the domain.</p>', 'refs' => [ 'AwsOpenSearchServiceDomainDetails$VpcOptions' => '<p>Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.</p>', ], ], 'AwsRdsDbClusterAssociatedRole' => [ 'base' => '<p>An IAM role that is associated with the Amazon RDS DB cluster.</p>', 'refs' => [ 'AwsRdsDbClusterAssociatedRoles$member' => NULL, ], ], 'AwsRdsDbClusterAssociatedRoles' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterDetails$AssociatedRoles' => '<p>A list of the IAM roles that are associated with the DB cluster.</p>', ], ], 'AwsRdsDbClusterDetails' => [ 'base' => '<p>Information about an Amazon RDS DB cluster.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbCluster' => '<p>Details about an Amazon RDS database cluster.</p>', ], ], 'AwsRdsDbClusterMember' => [ 'base' => '<p>Information about an instance in the DB cluster.</p>', 'refs' => [ 'AwsRdsDbClusterMembers$member' => NULL, ], ], 'AwsRdsDbClusterMembers' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterDetails$DbClusterMembers' => '<p>The list of instances that make up the DB cluster.</p>', ], ], 'AwsRdsDbClusterOptionGroupMembership' => [ 'base' => '<p>Information about an option group membership for a DB cluster.</p>', 'refs' => [ 'AwsRdsDbClusterOptionGroupMemberships$member' => NULL, ], ], 'AwsRdsDbClusterOptionGroupMemberships' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterDetails$DbClusterOptionGroupMemberships' => '<p>The list of option group memberships for this DB cluster.</p>', ], ], 'AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute' => [ 'base' => '<p> Contains the name and values of a manual Amazon Relational Database Service (RDS) DB cluster snapshot attribute. </p>', 'refs' => [ 'AwsRdsDbClusterSnapshotDbClusterSnapshotAttributes$member' => NULL, ], ], 'AwsRdsDbClusterSnapshotDbClusterSnapshotAttributes' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterSnapshotDetails$DbClusterSnapshotAttributes' => '<p> Contains the name and values of a manual DB cluster snapshot attribute. </p>', ], ], 'AwsRdsDbClusterSnapshotDetails' => [ 'base' => '<p>Information about an Amazon RDS DB cluster snapshot.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbClusterSnapshot' => '<p>Details about an Amazon RDS database cluster snapshot.</p>', ], ], 'AwsRdsDbDomainMembership' => [ 'base' => '<p>Information about an Active Directory domain membership record associated with the DB instance.</p>', 'refs' => [ 'AwsRdsDbDomainMemberships$member' => NULL, ], ], 'AwsRdsDbDomainMemberships' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterDetails$DomainMemberships' => '<p>The Active Directory domain membership records that are associated with the DB cluster.</p>', 'AwsRdsDbInstanceDetails$DomainMemberships' => '<p>The Active Directory domain membership records associated with the DB instance.</p>', ], ], 'AwsRdsDbInstanceAssociatedRole' => [ 'base' => '<p>An IAM role associated with the DB instance.</p>', 'refs' => [ 'AwsRdsDbInstanceAssociatedRoles$member' => NULL, ], ], 'AwsRdsDbInstanceAssociatedRoles' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$AssociatedRoles' => '<p>The IAM roles associated with the DB instance.</p>', ], ], 'AwsRdsDbInstanceDetails' => [ 'base' => '<p>Contains the details of an Amazon RDS DB instance.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbInstance' => '<p>Details about an Amazon RDS database instance.</p>', ], ], 'AwsRdsDbInstanceEndpoint' => [ 'base' => '<p>Specifies the connection endpoint.</p>', 'refs' => [ 'AwsRdsDbInstanceDetails$Endpoint' => '<p>Specifies the connection endpoint.</p>', 'AwsRdsDbInstanceDetails$ListenerEndpoint' => NULL, ], ], 'AwsRdsDbInstanceVpcSecurityGroup' => [ 'base' => '<p>A VPC security groups that the DB instance belongs to.</p>', 'refs' => [ 'AwsRdsDbInstanceVpcSecurityGroups$member' => NULL, ], ], 'AwsRdsDbInstanceVpcSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbClusterDetails$VpcSecurityGroups' => '<p>A list of VPC security groups that the DB cluster belongs to.</p>', 'AwsRdsDbInstanceDetails$VpcSecurityGroups' => '<p>A list of VPC security groups that the DB instance belongs to.</p>', ], ], 'AwsRdsDbOptionGroupMembership' => [ 'base' => '<p>An option group membership.</p>', 'refs' => [ 'AwsRdsDbOptionGroupMemberships$member' => NULL, ], ], 'AwsRdsDbOptionGroupMemberships' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$OptionGroupMemberships' => '<p>The list of option group memberships for this DB instance.</p>', ], ], 'AwsRdsDbParameterGroup' => [ 'base' => '<p>Provides information about a parameter group for a DB instance.</p>', 'refs' => [ 'AwsRdsDbParameterGroups$member' => NULL, ], ], 'AwsRdsDbParameterGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$DbParameterGroups' => '<p>A list of the DB parameter groups to assign to the DB instance.</p>', ], ], 'AwsRdsDbPendingModifiedValues' => [ 'base' => '<p>Changes to a DB instance that are currently pending.</p>', 'refs' => [ 'AwsRdsDbInstanceDetails$PendingModifiedValues' => '<p>Changes to the DB instance that are currently pending.</p>', ], ], 'AwsRdsDbProcessorFeature' => [ 'base' => '<p>A processor feature.</p>', 'refs' => [ 'AwsRdsDbProcessorFeatures$member' => NULL, ], ], 'AwsRdsDbProcessorFeatures' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$ProcessorFeatures' => '<p>Processor features that are being updated.</p>', 'AwsRdsDbSnapshotDetails$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>', ], ], 'AwsRdsDbSecurityGroupDetails' => [ 'base' => '<p>Provides information about an Amazon RDS DB security group.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbSecurityGroup' => '<p>Details about an Amazon RDS DB security group.</p>', ], ], 'AwsRdsDbSecurityGroupEc2SecurityGroup' => [ 'base' => '<p>EC2 security group information for an RDS DB security group.</p>', 'refs' => [ 'AwsRdsDbSecurityGroupEc2SecurityGroups$member' => NULL, ], ], 'AwsRdsDbSecurityGroupEc2SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbSecurityGroupDetails$Ec2SecurityGroups' => '<p>Contains a list of EC2 security groups.</p>', ], ], 'AwsRdsDbSecurityGroupIpRange' => [ 'base' => '<p>IP range information for an RDS DB security group.</p>', 'refs' => [ 'AwsRdsDbSecurityGroupIpRanges$member' => NULL, ], ], 'AwsRdsDbSecurityGroupIpRanges' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbSecurityGroupDetails$IpRanges' => '<p>Contains a list of IP ranges.</p>', ], ], 'AwsRdsDbSnapshotDetails' => [ 'base' => '<p>Provides details about an Amazon RDS DB cluster snapshot.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbSnapshot' => '<p>Details about an Amazon RDS database snapshot.</p>', ], ], 'AwsRdsDbStatusInfo' => [ 'base' => '<p>Information about the status of a read replica.</p>', 'refs' => [ 'AwsRdsDbStatusInfos$member' => NULL, ], ], 'AwsRdsDbStatusInfos' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$StatusInfos' => '<p>The status of a read replica. If the instance isn\'t a read replica, this is empty.</p>', ], ], 'AwsRdsDbSubnetGroup' => [ 'base' => '<p>Information about the subnet group for the database instance.</p>', 'refs' => [ 'AwsRdsDbInstanceDetails$DbSubnetGroup' => '<p>Information about the subnet group that is associated with the DB instance.</p>', ], ], 'AwsRdsDbSubnetGroupSubnet' => [ 'base' => '<p>Information about a subnet in a subnet group.</p>', 'refs' => [ 'AwsRdsDbSubnetGroupSubnets$member' => NULL, ], ], 'AwsRdsDbSubnetGroupSubnetAvailabilityZone' => [ 'base' => '<p>An Availability Zone for a subnet in a subnet group.</p>', 'refs' => [ 'AwsRdsDbSubnetGroupSubnet$SubnetAvailabilityZone' => '<p>Information about the Availability Zone for a subnet in the subnet group.</p>', ], ], 'AwsRdsDbSubnetGroupSubnets' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbSubnetGroup$Subnets' => '<p>A list of subnets in the subnet group.</p>', ], ], 'AwsRdsEventSubscriptionDetails' => [ 'base' => '<p>Details about an Amazon RDS event notification subscription. The subscription allows Amazon RDS to post events to an SNS topic.</p>', 'refs' => [ 'ResourceDetails$AwsRdsEventSubscription' => '<p>Details about an RDS event notification subscription.</p>', ], ], 'AwsRdsPendingCloudWatchLogsExports' => [ 'base' => '<p>Identifies the log types to enable and disable.</p>', 'refs' => [ 'AwsRdsDbPendingModifiedValues$PendingCloudWatchLogsExports' => '<p>A list of log types that are being enabled or disabled.</p>', ], ], 'AwsRedshiftClusterClusterNode' => [ 'base' => '<p>A node in an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterClusterNodes$member' => NULL, ], ], 'AwsRedshiftClusterClusterNodes' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$ClusterNodes' => '<p>The nodes in the cluster.</p>', ], ], 'AwsRedshiftClusterClusterParameterGroup' => [ 'base' => '<p>A cluster parameter group that is associated with an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterClusterParameterGroups$member' => NULL, ], ], 'AwsRedshiftClusterClusterParameterGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$ClusterParameterGroups' => '<p>The list of cluster parameter groups that are associated with this cluster.</p>', ], ], 'AwsRedshiftClusterClusterParameterStatus' => [ 'base' => '<p>The status of a parameter in a cluster parameter group for an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterClusterParameterStatusList$member' => NULL, ], ], 'AwsRedshiftClusterClusterParameterStatusList' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterClusterParameterGroup$ClusterParameterStatusList' => '<p>The list of parameter statuses.</p>', ], ], 'AwsRedshiftClusterClusterSecurityGroup' => [ 'base' => '<p>A security group that is associated with the cluster.</p>', 'refs' => [ 'AwsRedshiftClusterClusterSecurityGroups$member' => NULL, ], ], 'AwsRedshiftClusterClusterSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$ClusterSecurityGroups' => '<p>A list of cluster security groups that are associated with the cluster.</p>', ], ], 'AwsRedshiftClusterClusterSnapshotCopyStatus' => [ 'base' => '<p>You can configure Amazon Redshift to copy snapshots for a cluster to another Amazon Web Services Region. This parameter provides information about a cross-Region snapshot copy.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$ClusterSnapshotCopyStatus' => '<p>Information about the destination Region and retention period for the cross-Region snapshot copy.</p>', ], ], 'AwsRedshiftClusterDeferredMaintenanceWindow' => [ 'base' => '<p>A time windows during which maintenance was deferred for an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterDeferredMaintenanceWindows$member' => NULL, ], ], 'AwsRedshiftClusterDeferredMaintenanceWindows' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$DeferredMaintenanceWindows' => '<p>List of time windows during which maintenance was deferred.</p>', ], ], 'AwsRedshiftClusterDetails' => [ 'base' => '<p>Details about an Amazon Redshift cluster.</p>', 'refs' => [ 'ResourceDetails$AwsRedshiftCluster' => '<p>Contains details about an Amazon Redshift cluster.</p>', ], ], 'AwsRedshiftClusterElasticIpStatus' => [ 'base' => '<p>The status of the elastic IP (EIP) address for an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$ElasticIpStatus' => '<p>Information about the status of the Elastic IP (EIP) address.</p>', ], ], 'AwsRedshiftClusterEndpoint' => [ 'base' => '<p>The connection endpoint for an Amazon Redshift cluster.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$Endpoint' => '<p>The connection endpoint.</p>', ], ], 'AwsRedshiftClusterHsmStatus' => [ 'base' => '<p>Information about whether an Amazon Redshift cluster finished applying any hardware changes to security module (HSM) settings that were specified in a modify cluster command.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$HsmStatus' => '<p>Information about whether the Amazon Redshift cluster finished applying any changes to hardware security module (HSM) settings that were specified in a modify cluster command.</p>', ], ], 'AwsRedshiftClusterIamRole' => [ 'base' => '<p>An IAM role that the cluster can use to access other Amazon Web Services services.</p>', 'refs' => [ 'AwsRedshiftClusterIamRoles$member' => NULL, ], ], 'AwsRedshiftClusterIamRoles' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$IamRoles' => '<p>A list of IAM roles that the cluster can use to access other Amazon Web Services services.</p>', ], ], 'AwsRedshiftClusterLoggingStatus' => [ 'base' => '<p>Provides information about the logging status of the cluster.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$LoggingStatus' => '<p>Information about the logging status of the cluster.</p>', ], ], 'AwsRedshiftClusterPendingModifiedValues' => [ 'base' => '<p>Changes to the Amazon Redshift cluster that are currently pending.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$PendingModifiedValues' => '<p>A list of changes to the cluster that are currently pending.</p>', ], ], 'AwsRedshiftClusterResizeInfo' => [ 'base' => '<p>Information about the resize operation for the cluster.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$ResizeInfo' => '<p>Information about the resize operation for the cluster.</p>', ], ], 'AwsRedshiftClusterRestoreStatus' => [ 'base' => '<p>Information about the status of a cluster restore action. It only applies if the cluster was created by restoring a snapshot.</p>', 'refs' => [ 'AwsRedshiftClusterDetails$RestoreStatus' => '<p>Information about the status of a cluster restore action. Only applies to a cluster that was created by restoring a snapshot.</p>', ], ], 'AwsRedshiftClusterVpcSecurityGroup' => [ 'base' => '<p>A VPC security group that the cluster belongs to, if the cluster is in a VPC.</p>', 'refs' => [ 'AwsRedshiftClusterVpcSecurityGroups$member' => NULL, ], ], 'AwsRedshiftClusterVpcSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRedshiftClusterDetails$VpcSecurityGroups' => '<p>The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.</p>', ], ], 'AwsRoute53HostedZoneConfigDetails' => [ 'base' => '<p> An object that contains an optional comment about your Amazon Route 53 hosted zone.</p>', 'refs' => [ 'AwsRoute53HostedZoneObjectDetails$Config' => '<p> An object that includes the <code>Comment</code> element.</p>', ], ], 'AwsRoute53HostedZoneDetails' => [ 'base' => '<p> Provides details about a specified Amazon Route 53 hosted zone, including the four name servers assigned to the hosted zone. A hosted zone represents a collection of records that can be managed together, belonging to a single parent domain name.</p>', 'refs' => [ 'ResourceDetails$AwsRoute53HostedZone' => '<p> Provides details about an Amazon Route 53 hosted zone, including the four name servers assigned to the hosted zone. A hosted zone represents a collection of records that can be managed together, belonging to a single parent domain name.</p>', ], ], 'AwsRoute53HostedZoneNameServersList' => [ 'base' => NULL, 'refs' => [ 'AwsRoute53HostedZoneDetails$NameServers' => '<p> An object that contains a list of the authoritative name servers for a hosted zone or for a reusable delegation set.</p>', ], ], 'AwsRoute53HostedZoneObjectDetails' => [ 'base' => '<p> An object that contains information about an Amazon Route 53 hosted zone. </p>', 'refs' => [ 'AwsRoute53HostedZoneDetails$HostedZone' => '<p> An object that contains information about the specified hosted zone.</p>', ], ], 'AwsRoute53HostedZoneVpcDetails' => [ 'base' => '<p> For private hosted zones, this is a complex type that contains information about an Amazon VPC.</p>', 'refs' => [ 'AwsRoute53HostedZoneVpcsList$member' => NULL, ], ], 'AwsRoute53HostedZoneVpcsList' => [ 'base' => NULL, 'refs' => [ 'AwsRoute53HostedZoneDetails$Vpcs' => '<p> An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated with the specified hosted zone.</p>', ], ], 'AwsRoute53QueryLoggingConfigDetails' => [ 'base' => '<p> Provides details about a specified Amazon Route 53 configuration for DNS query logging.</p>', 'refs' => [ 'AwsRoute53HostedZoneDetails$QueryLoggingConfig' => '<p> An array that contains one <code>QueryLoggingConfig</code> element for each DNS query logging configuration that is associated with the current Amazon Web Services account.</p>', ], ], 'AwsS3AccessPointDetails' => [ 'base' => '<p> Returns configuration information about the specified Amazon S3 access point. S3 access points are named network endpoints that are attached to buckets that you can use to perform S3 object operations. </p>', 'refs' => [ 'ResourceDetails$AwsS3AccessPoint' => '<p> Provides details about an Amazon Simple Storage Service (Amazon S3) access point. S3 access points are named network endpoints that are attached to S3 buckets that you can use to perform S3 object operations. </p>', ], ], 'AwsS3AccessPointVpcConfigurationDetails' => [ 'base' => '<p> The virtual private cloud (VPC) configuration for an Amazon S3 access point. </p>', 'refs' => [ 'AwsS3AccessPointDetails$VpcConfiguration' => '<p> Contains the virtual private cloud (VPC) configuration for the specified access point. </p>', ], ], 'AwsS3AccountPublicAccessBlockDetails' => [ 'base' => '<p>provides information about the Amazon S3 Public Access Block configuration for accounts.</p>', 'refs' => [ 'AwsS3AccessPointDetails$PublicAccessBlockConfiguration' => NULL, 'AwsS3BucketDetails$PublicAccessBlockConfiguration' => '<p>Provides information about the Amazon S3 Public Access Block configuration for the S3 bucket.</p>', 'ResourceDetails$AwsS3AccountPublicAccessBlock' => '<p>Details about the Amazon S3 Public Access Block configuration for an account.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationDetails' => [ 'base' => '<p>The lifecycle configuration for the objects in the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$BucketLifecycleConfiguration' => '<p>The lifecycle configuration for objects in the specified bucket.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails' => [ 'base' => '<p>Information about what Amazon S3 does when a multipart upload is incomplete.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$AbortIncompleteMultipartUpload' => '<p>How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before Amazon S3 cancels the entire upload.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesDetails' => [ 'base' => '<p>Configuration for a lifecycle rule.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesList$member' => NULL, ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails' => [ 'base' => '<p>Identifies the objects that a rule applies to.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$Filter' => '<p>Identifies the objects that a rule applies to.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails' => [ 'base' => '<p>The configuration for the filter.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails$Predicate' => '<p>The configuration for the filter.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails' => [ 'base' => '<p>A value to use for the filter.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList$member' => NULL, ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails$Operands' => '<p>The values to use for the filter.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails' => [ 'base' => '<p>A tag that is assigned to matching objects.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails$Tag' => '<p>A tag that is assigned to matching objects.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails' => [ 'base' => '<p>A tag filter.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails$Tag' => '<p>A tag filter.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesList' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationDetails$Rules' => '<p>The lifecycle rules.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails' => [ 'base' => '<p>A transition rule that describes when noncurrent objects transition to a specified storage class.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList$member' => NULL, ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$NoncurrentVersionTransitions' => '<p>Transition rules that describe when noncurrent objects transition to a specified storage class.</p>', ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails' => [ 'base' => '<p>A rule for when objects transition to specific storage classes.</p>', 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsList$member' => NULL, ], ], 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsList' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$Transitions' => '<p>Transition rules that indicate when objects transition to a specified storage class.</p>', ], ], 'AwsS3BucketBucketVersioningConfiguration' => [ 'base' => '<p>Describes the versioning state of an S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$BucketVersioningConfiguration' => '<p>The versioning state of an S3 bucket.</p>', ], ], 'AwsS3BucketDetails' => [ 'base' => '<p>The details of an Amazon Simple Storage Service (Amazon S3) bucket.</p>', 'refs' => [ 'ResourceDetails$AwsS3Bucket' => '<p>Details about an S3 bucket related to a finding.</p>', ], ], 'AwsS3BucketLoggingConfiguration' => [ 'base' => '<p>Information about logging for the S3 bucket</p>', 'refs' => [ 'AwsS3BucketDetails$BucketLoggingConfiguration' => '<p>The logging configuration for the S3 bucket.</p>', ], ], 'AwsS3BucketNotificationConfiguration' => [ 'base' => '<p>The notification configuration for the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$BucketNotificationConfiguration' => '<p>The notification configuration for the S3 bucket.</p>', ], ], 'AwsS3BucketNotificationConfigurationDetail' => [ 'base' => '<p>Details for an S3 bucket notification configuration.</p>', 'refs' => [ 'AwsS3BucketNotificationConfigurationDetails$member' => NULL, ], ], 'AwsS3BucketNotificationConfigurationDetails' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketNotificationConfiguration$Configurations' => '<p>Configurations for S3 bucket notifications.</p>', ], ], 'AwsS3BucketNotificationConfigurationEvents' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketNotificationConfigurationDetail$Events' => '<p>The list of events that trigger a notification.</p>', ], ], 'AwsS3BucketNotificationConfigurationFilter' => [ 'base' => '<p>Filtering information for the notifications. The filtering is based on Amazon S3 key names.</p>', 'refs' => [ 'AwsS3BucketNotificationConfigurationDetail$Filter' => '<p>The filters that determine which S3 buckets generate notifications.</p>', ], ], 'AwsS3BucketNotificationConfigurationS3KeyFilter' => [ 'base' => '<p>Details for an Amazon S3 filter.</p>', 'refs' => [ 'AwsS3BucketNotificationConfigurationFilter$S3KeyFilter' => '<p>Details for an Amazon S3 filter.</p>', ], ], 'AwsS3BucketNotificationConfigurationS3KeyFilterRule' => [ 'base' => '<p>Details for a filter rule.</p>', 'refs' => [ 'AwsS3BucketNotificationConfigurationS3KeyFilterRules$member' => NULL, ], ], 'AwsS3BucketNotificationConfigurationS3KeyFilterRuleName' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketNotificationConfigurationS3KeyFilterRule$Name' => '<p>Indicates whether the filter is based on the prefix or suffix of the Amazon S3 key.</p>', ], ], 'AwsS3BucketNotificationConfigurationS3KeyFilterRules' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketNotificationConfigurationS3KeyFilter$FilterRules' => '<p>The filter rules for the filter.</p>', ], ], 'AwsS3BucketObjectLockConfiguration' => [ 'base' => '<p> The container element for S3 Object Lock configuration parameters. In Amazon S3, Object Lock can help prevent objects from being deleted or overwritten for a fixed amount of time or indefinitely. </p>', 'refs' => [ 'AwsS3BucketDetails$ObjectLockConfiguration' => '<p> Specifies which rule Amazon S3 applies by default to every new object placed in the bucket. </p>', ], ], 'AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails' => [ 'base' => '<p> The default S3 Object Lock retention mode and period that you want to apply to new objects placed in the specified Amazon S3 bucket. </p>', 'refs' => [ 'AwsS3BucketObjectLockConfigurationRuleDetails$DefaultRetention' => '<p> The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. </p>', ], ], 'AwsS3BucketObjectLockConfigurationRuleDetails' => [ 'base' => '<p> Specifies the S3 Object Lock rule for the specified object. In Amazon S3, Object Lock can help prevent objects from being deleted or overwritten for a fixed amount of time or indefinitely. </p>', 'refs' => [ 'AwsS3BucketObjectLockConfiguration$Rule' => '<p> Specifies the Object Lock rule for the specified object. </p>', ], ], 'AwsS3BucketServerSideEncryptionByDefault' => [ 'base' => '<p>Specifies the default server-side encryption to apply to new objects in the bucket.</p>', 'refs' => [ 'AwsS3BucketServerSideEncryptionRule$ApplyServerSideEncryptionByDefault' => '<p>Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code> object request doesn\'t specify any server-side encryption, this default encryption is applied.</p>', ], ], 'AwsS3BucketServerSideEncryptionConfiguration' => [ 'base' => '<p>The encryption configuration for the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$ServerSideEncryptionConfiguration' => '<p>The encryption rules that are applied to the S3 bucket.</p>', ], ], 'AwsS3BucketServerSideEncryptionRule' => [ 'base' => '<p>An encryption rule to apply to the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketServerSideEncryptionRules$member' => NULL, ], ], 'AwsS3BucketServerSideEncryptionRules' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketServerSideEncryptionConfiguration$Rules' => '<p>The encryption rules that are applied to the S3 bucket.</p>', ], ], 'AwsS3BucketWebsiteConfiguration' => [ 'base' => '<p>Website parameters for the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$BucketWebsiteConfiguration' => '<p>The website configuration parameters for the S3 bucket.</p>', ], ], 'AwsS3BucketWebsiteConfigurationRedirectTo' => [ 'base' => '<p>The redirect behavior for requests to the website.</p>', 'refs' => [ 'AwsS3BucketWebsiteConfiguration$RedirectAllRequestsTo' => '<p>The redirect behavior for requests to the website.</p>', ], ], 'AwsS3BucketWebsiteConfigurationRoutingRule' => [ 'base' => '<p>A rule for redirecting requests to the website.</p>', 'refs' => [ 'AwsS3BucketWebsiteConfigurationRoutingRules$member' => NULL, ], ], 'AwsS3BucketWebsiteConfigurationRoutingRuleCondition' => [ 'base' => '<p>The condition that must be met in order to apply the routing rule.</p>', 'refs' => [ 'AwsS3BucketWebsiteConfigurationRoutingRule$Condition' => '<p>Provides the condition that must be met in order to apply the routing rule.</p>', ], ], 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect' => [ 'base' => '<p>The rules to redirect the request if the condition in <code>Condition</code> is met.</p>', 'refs' => [ 'AwsS3BucketWebsiteConfigurationRoutingRule$Redirect' => '<p>Provides the rules to redirect the request if the condition in <code>Condition</code> is met.</p>', ], ], 'AwsS3BucketWebsiteConfigurationRoutingRules' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketWebsiteConfiguration$RoutingRules' => '<p>The rules for applying redirects for requests to the website.</p>', ], ], 'AwsS3ObjectDetails' => [ 'base' => '<p>Details about an Amazon S3 object.</p>', 'refs' => [ 'ResourceDetails$AwsS3Object' => '<p>Details about an S3 object related to a finding.</p>', ], ], 'AwsSageMakerNotebookInstanceDetails' => [ 'base' => '<p> Provides details about an Amazon SageMaker notebook instance. </p>', 'refs' => [ 'ResourceDetails$AwsSageMakerNotebookInstance' => NULL, ], ], 'AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails' => [ 'base' => '<p> Information on the instance metadata service (IMDS) configuration of the notebook instance. </p>', 'refs' => [ 'AwsSageMakerNotebookInstanceDetails$InstanceMetadataServiceConfiguration' => '<p> Information on the IMDS configuration of the notebook instance. </p>', ], ], 'AwsSecretsManagerSecretDetails' => [ 'base' => '<p>Details about an Secrets Manager secret.</p>', 'refs' => [ 'ResourceDetails$AwsSecretsManagerSecret' => '<p>Details about a Secrets Manager secret.</p>', ], ], 'AwsSecretsManagerSecretRotationRules' => [ 'base' => '<p>Defines the rotation schedule for the secret.</p>', 'refs' => [ 'AwsSecretsManagerSecretDetails$RotationRules' => '<p>Defines the rotation schedule for the secret.</p>', ], ], 'AwsSecurityFinding' => [ 'base' => '<p>Provides a consistent format for Security Hub findings. <code>AwsSecurityFinding</code> format allows you to share findings between Amazon Web Services security services and third-party solutions.</p> <note> <p>A finding is a potential security issue generated either by Amazon Web Services services or by the integrated third-party solutions and standards checks.</p> </note>', 'refs' => [ 'AwsSecurityFindingList$member' => NULL, 'BatchImportFindingsRequestFindingList$member' => NULL, ], ], 'AwsSecurityFindingFilters' => [ 'base' => '<p>A collection of filters that are applied to all active findings aggregated by Security Hub.</p> <p>You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.</p>', 'refs' => [ 'CreateInsightRequest$Filters' => '<p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>', 'GetFindingsRequest$Filters' => '<p>The finding attributes used to define a condition to filter the returned findings.</p> <p>You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.</p> <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>', 'Insight$Filters' => '<p>One or more attributes used to filter the findings included in the insight. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values. The insight only includes findings that match the criteria defined in the filters.</p>', 'UpdateFindingsRequest$Filters' => '<p>A collection of attributes that specify which findings you want to update.</p>', 'UpdateInsightRequest$Filters' => '<p>The updated filters that define this insight.</p>', ], ], 'AwsSecurityFindingIdentifier' => [ 'base' => '<p>Identifies which finding to get the finding history for.</p>', 'refs' => [ 'AwsSecurityFindingIdentifierList$member' => NULL, 'BatchUpdateFindingsUnprocessedFinding$FindingIdentifier' => '<p>The identifier of the finding that was not updated.</p>', 'FindingHistoryRecord$FindingIdentifier' => NULL, 'GetFindingHistoryRequest$FindingIdentifier' => NULL, ], ], 'AwsSecurityFindingIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateFindingsRequest$FindingIdentifiers' => '<p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a time.</p> <p>For each finding, the list provides the finding identifier and the ARN of the finding provider.</p>', 'BatchUpdateFindingsResponse$ProcessedFindings' => '<p>The list of findings that were updated successfully.</p>', ], ], 'AwsSecurityFindingList' => [ 'base' => NULL, 'refs' => [ 'GetFindingsResponse$Findings' => '<p>The findings that matched the filters specified in the request.</p>', ], ], 'AwsSnsTopicDetails' => [ 'base' => '<p>Provides information about an Amazon SNS topic to which notifications can be published.</p>', 'refs' => [ 'ResourceDetails$AwsSnsTopic' => '<p>Details about an SNS topic.</p>', ], ], 'AwsSnsTopicSubscription' => [ 'base' => '<p>A wrapper type for the attributes of an Amazon SNS subscription.</p>', 'refs' => [ 'AwsSnsTopicSubscriptionList$member' => NULL, ], ], 'AwsSnsTopicSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'AwsSnsTopicDetails$Subscription' => '<p>Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.</p>', ], ], 'AwsSqsQueueDetails' => [ 'base' => '<p>Data about a queue.</p>', 'refs' => [ 'ResourceDetails$AwsSqsQueue' => '<p>Details about an SQS queue.</p>', ], ], 'AwsSsmComplianceSummary' => [ 'base' => '<p>Provides the details about the compliance status for a patch.</p>', 'refs' => [ 'AwsSsmPatch$ComplianceSummary' => '<p>The compliance status details for the patch.</p>', ], ], 'AwsSsmPatch' => [ 'base' => '<p>Provides details about the compliance for a patch.</p>', 'refs' => [ 'AwsSsmPatchComplianceDetails$Patch' => '<p>Information about the status of a patch.</p>', ], ], 'AwsSsmPatchComplianceDetails' => [ 'base' => '<p>Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.</p>', 'refs' => [ 'ResourceDetails$AwsSsmPatchCompliance' => '<p>Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.</p>', ], ], 'AwsStepFunctionStateMachineDetails' => [ 'base' => '<p> Provides details about an Step Functions state machine, which is a workflow consisting of a series of event- driven steps. </p>', 'refs' => [ 'ResourceDetails$AwsStepFunctionStateMachine' => '<p> Provides details about an Step Functions state machine, which is a workflow consisting of a series of event-driven steps. </p>', ], ], 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails' => [ 'base' => '<p> An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"> Amazon Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>. </p>', 'refs' => [ 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails$CloudWatchLogsLogGroup' => '<p> An object describing a CloudWatch Logs log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"> Amazon Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>. </p>', ], ], 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails' => [ 'base' => '<p> An array of objects that describes where your execution history events will be logged. </p>', 'refs' => [ 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsList$member' => NULL, ], ], 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsList' => [ 'base' => NULL, 'refs' => [ 'AwsStepFunctionStateMachineLoggingConfigurationDetails$Destinations' => '<p> An array of objects that describes where your execution history events will be logged. </p>', ], ], 'AwsStepFunctionStateMachineLoggingConfigurationDetails' => [ 'base' => '<p> The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options. </p>', 'refs' => [ 'AwsStepFunctionStateMachineDetails$LoggingConfiguration' => '<p> Used to set CloudWatch Logs options. </p>', ], ], 'AwsStepFunctionStateMachineTracingConfigurationDetails' => [ 'base' => '<p> Specifies whether X-Ray tracing is enabled. </p>', 'refs' => [ 'AwsStepFunctionStateMachineDetails$TracingConfiguration' => '<p> Specifies whether X-Ray tracing is enabled. </p>', ], ], 'AwsWafRateBasedRuleDetails' => [ 'base' => '<p>Details about a rate-based rule for global resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.</p>', 'refs' => [ 'ResourceDetails$AwsWafRateBasedRule' => '<p>Details about a rate-based rule for global resources.</p>', ], ], 'AwsWafRateBasedRuleMatchPredicate' => [ 'base' => '<p>A match predicate. A predicate might look for characteristics such as specific IP addresses, geographic locations, or sizes.</p>', 'refs' => [ 'AwsWafRateBasedRuleMatchPredicateList$member' => NULL, ], ], 'AwsWafRateBasedRuleMatchPredicateList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRateBasedRuleDetails$MatchPredicates' => '<p>The predicates to include in the rate-based rule.</p>', ], ], 'AwsWafRegionalRateBasedRuleDetails' => [ 'base' => '<p>contains details about a rate-based rule for Regional resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.</p>', 'refs' => [ 'ResourceDetails$AwsWafRegionalRateBasedRule' => '<p>Details about a rate-based rule for Regional resources.</p>', ], ], 'AwsWafRegionalRateBasedRuleMatchPredicate' => [ 'base' => '<p>Details for a match predicate. A predicate might look for characteristics such as specific IP addresses, geographic locations, or sizes.</p>', 'refs' => [ 'AwsWafRegionalRateBasedRuleMatchPredicateList$member' => NULL, ], ], 'AwsWafRegionalRateBasedRuleMatchPredicateList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRegionalRateBasedRuleDetails$MatchPredicates' => '<p>The predicates to include in the rate-based rule.</p>', ], ], 'AwsWafRegionalRuleDetails' => [ 'base' => '<p>Provides information about an WAF Regional rule. This rule identifies the web requests that you want to allow, block, or count. </p>', 'refs' => [ 'ResourceDetails$AwsWafRegionalRule' => '<p>Details about an WAF rule for Regional resources. </p>', ], ], 'AwsWafRegionalRuleGroupDetails' => [ 'base' => '<p>Provides information about an WAF Regional rule group. The rule group is a collection of rules for inspecting and controlling web requests. </p>', 'refs' => [ 'ResourceDetails$AwsWafRegionalRuleGroup' => '<p>Details about an WAF rule group for Regional resources. </p>', ], ], 'AwsWafRegionalRuleGroupRulesActionDetails' => [ 'base' => '<p>Describes the action that WAF should take on a web request when it matches the criteria defined in the rule. </p>', 'refs' => [ 'AwsWafRegionalRuleGroupRulesDetails$Action' => '<p>The action that WAF should take on a web request when it matches the criteria defined in the rule. </p>', ], ], 'AwsWafRegionalRuleGroupRulesDetails' => [ 'base' => '<p>Provides information about the rules attached to a rule group </p>', 'refs' => [ 'AwsWafRegionalRuleGroupRulesList$member' => NULL, ], ], 'AwsWafRegionalRuleGroupRulesList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRegionalRuleGroupDetails$Rules' => '<p>Provides information about the rule statements used to identify the web requests that you want to allow, block, or count. </p>', ], ], 'AwsWafRegionalRulePredicateList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRegionalRuleDetails$PredicateList' => '<p>Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you want to negate the settings. </p>', ], ], 'AwsWafRegionalRulePredicateListDetails' => [ 'base' => '<p>Provides details about the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you want to negate the settings. </p>', 'refs' => [ 'AwsWafRegionalRulePredicateList$member' => NULL, ], ], 'AwsWafRegionalWebAclDetails' => [ 'base' => '<p>Provides information about the web access control list (web ACL). The web ACL contains the rules that identify the requests that you want to allow, block, or count. </p>', 'refs' => [ 'ResourceDetails$AwsWafRegionalWebAcl' => '<p>Details about an WAF web access control list (web ACL) for Regional resources. </p>', ], ], 'AwsWafRegionalWebAclRulesList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRegionalWebAclDetails$RulesList' => '<p>An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the rule. </p>', ], ], 'AwsWafRegionalWebAclRulesListActionDetails' => [ 'base' => '<p>The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or count the request. </p>', 'refs' => [ 'AwsWafRegionalWebAclRulesListDetails$Action' => '<p>The action that WAF takes when a web request matches all conditions in the rule, such as allow, block, or count the request. </p>', ], ], 'AwsWafRegionalWebAclRulesListDetails' => [ 'base' => '<p>A combination of <code>ByteMatchSet</code>, <code>IPSet</code>, and/or <code>SqlInjectionMatchSet</code> objects that identify the web requests that you want to allow, block, or count. </p>', 'refs' => [ 'AwsWafRegionalWebAclRulesList$member' => NULL, ], ], 'AwsWafRegionalWebAclRulesListOverrideActionDetails' => [ 'base' => '<p>Provides details about the action to use in the place of the action that results from the rule group evaluation. </p>', 'refs' => [ 'AwsWafRegionalWebAclRulesListDetails$OverrideAction' => '<p>Overrides the rule evaluation result in the rule group. </p>', ], ], 'AwsWafRuleDetails' => [ 'base' => '<p>Provides information about a WAF rule. This rule specifies the web requests that you want to allow, block, or count. </p>', 'refs' => [ 'ResourceDetails$AwsWafRule' => '<p>Details about an WAF rule for global resources. </p>', ], ], 'AwsWafRuleGroupDetails' => [ 'base' => '<p>Provides information about an WAF rule group. A rule group is a collection of rules for inspecting and controlling web requests. </p>', 'refs' => [ 'ResourceDetails$AwsWafRuleGroup' => '<p>Details about an WAF rule group for global resources. </p>', ], ], 'AwsWafRuleGroupRulesActionDetails' => [ 'base' => '<p>Provides information about what action WAF should take on a web request when it matches the criteria defined in the rule. </p>', 'refs' => [ 'AwsWafRuleGroupRulesDetails$Action' => '<p>Provides information about what action WAF should take on a web request when it matches the criteria defined in the rule. </p>', ], ], 'AwsWafRuleGroupRulesDetails' => [ 'base' => '<p>Provides information about the rules attached to the rule group. These rules identify the web requests that you want to allow, block, or count. </p>', 'refs' => [ 'AwsWafRuleGroupRulesList$member' => NULL, ], ], 'AwsWafRuleGroupRulesList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRuleGroupDetails$Rules' => '<p>Provides information about the rules attached to the rule group. These rules identify the web requests that you want to allow, block, or count. </p>', ], ], 'AwsWafRulePredicateList' => [ 'base' => NULL, 'refs' => [ 'AwsWafRuleDetails$PredicateList' => '<p>Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you want to negate the settings. </p>', ], ], 'AwsWafRulePredicateListDetails' => [ 'base' => '<p>Provides details about the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you want to negate the settings. </p>', 'refs' => [ 'AwsWafRulePredicateList$member' => NULL, ], ], 'AwsWafWebAclDetails' => [ 'base' => '<p>Provides information about an WAF web access control list (web ACL).</p>', 'refs' => [ 'ResourceDetails$AwsWafWebAcl' => '<p>Details for an WAF web ACL.</p>', ], ], 'AwsWafWebAclRule' => [ 'base' => '<p>Details for a rule in an WAF web ACL.</p>', 'refs' => [ 'AwsWafWebAclRuleList$member' => NULL, ], ], 'AwsWafWebAclRuleList' => [ 'base' => NULL, 'refs' => [ 'AwsWafWebAclDetails$Rules' => '<p>An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the rule.</p>', ], ], 'AwsWafv2ActionAllowDetails' => [ 'base' => '<p> Specifies that WAF should allow the request and optionally defines additional custom handling for the request. </p>', 'refs' => [ 'AwsWafv2RulesActionDetails$Allow' => '<p> Instructs WAF to allow the web request. </p>', 'AwsWafv2WebAclActionDetails$Allow' => '<p> Specifies that WAF should allow requests by default. </p>', ], ], 'AwsWafv2ActionBlockDetails' => [ 'base' => '<p> Specifies that WAF should block the request and optionally defines additional custom handling for the response to the web request. </p>', 'refs' => [ 'AwsWafv2RulesActionDetails$Block' => '<p> Instructs WAF to block the web request. </p>', 'AwsWafv2WebAclActionDetails$Block' => '<p> Specifies that WAF should block requests by default. </p>', ], ], 'AwsWafv2CustomHttpHeader' => [ 'base' => '<p> A custom header for custom request and response handling. </p>', 'refs' => [ 'AwsWafv2InsertHeadersList$member' => NULL, ], ], 'AwsWafv2CustomRequestHandlingDetails' => [ 'base' => '<p> Custom request handling behavior that inserts custom headers into a web request. WAF uses custom request handling when the rule action doesn\'t block the request. </p>', 'refs' => [ 'AwsWafv2ActionAllowDetails$CustomRequestHandling' => '<p> Defines custom handling for the web request. For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>. </p>', 'AwsWafv2RulesActionCaptchaDetails$CustomRequestHandling' => '<p> Defines custom handling for the web request, used when the CAPTCHA inspection determines that the request\'s token is valid and unexpired. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>. </p>', 'AwsWafv2RulesActionCountDetails$CustomRequestHandling' => '<p> Defines custom handling for the web request. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>. </p>', ], ], 'AwsWafv2CustomResponseDetails' => [ 'base' => '<p> A custom response to send to the client. You can define a custom response for rule actions and default web ACL actions that are set to block. </p>', 'refs' => [ 'AwsWafv2ActionBlockDetails$CustomResponse' => '<p> Defines a custom response for the web request. For information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide.</i>. </p>', ], ], 'AwsWafv2InsertHeadersList' => [ 'base' => NULL, 'refs' => [ 'AwsWafv2CustomRequestHandlingDetails$InsertHeaders' => '<p> The HTTP headers to insert into the request. </p>', 'AwsWafv2CustomResponseDetails$ResponseHeaders' => '<p> The HTTP headers to use in the response. </p>', ], ], 'AwsWafv2RuleGroupDetails' => [ 'base' => '<p> Details about an WAFv2 rule group. </p>', 'refs' => [ 'ResourceDetails$AwsWafv2RuleGroup' => NULL, ], ], 'AwsWafv2RulesActionCaptchaDetails' => [ 'base' => '<p> Specifies that WAF should run a CAPTCHA check against the request. </p>', 'refs' => [ 'AwsWafv2RulesActionDetails$Captcha' => '<p> Instructs WAF to run a CAPTCHA check against the web request. </p>', ], ], 'AwsWafv2RulesActionCountDetails' => [ 'base' => '<p> Specifies that WAF should count the request. </p>', 'refs' => [ 'AwsWafv2RulesActionDetails$Count' => '<p> Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL. </p>', ], ], 'AwsWafv2RulesActionDetails' => [ 'base' => '<p> The action that WAF should take on a web request when it matches a rule\'s statement. Settings at the web ACL level can override the rule action setting. </p>', 'refs' => [ 'AwsWafv2RulesDetails$Action' => '<p> The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting. </p>', ], ], 'AwsWafv2RulesDetails' => [ 'base' => '<p> Provides details about rules in a rule group. A rule identifies web requests that you want to allow, block, or count. Each rule includes one top-level Statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'refs' => [ 'AwsWafv2RulesList$member' => NULL, ], ], 'AwsWafv2RulesList' => [ 'base' => NULL, 'refs' => [ 'AwsWafv2RuleGroupDetails$Rules' => '<p> The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'AwsWafv2WebAclDetails$Rules' => '<p> The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', ], ], 'AwsWafv2VisibilityConfigDetails' => [ 'base' => '<p> Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'refs' => [ 'AwsWafv2RuleGroupDetails$VisibilityConfig' => '<p> Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'AwsWafv2RulesDetails$VisibilityConfig' => '<p> Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'AwsWafv2WebAclDetails$VisibilityConfig' => '<p> Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', ], ], 'AwsWafv2WebAclActionDetails' => [ 'base' => '<p> Specifies the action that Amazon CloudFront or WAF takes when a web request matches the conditions in the rule. </p>', 'refs' => [ 'AwsWafv2WebAclDetails$DefaultAction' => '<p> The action to perform if none of the Rules contained in the web ACL match. </p>', ], ], 'AwsWafv2WebAclCaptchaConfigDetails' => [ 'base' => '<p> Specifies how WAF should handle CAPTCHA evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. </p>', 'refs' => [ 'AwsWafv2WebAclDetails$CaptchaConfig' => '<p> Specifies how WAF should handle CAPTCHA evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. </p>', ], ], 'AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails' => [ 'base' => '<p> Used for CAPTCHA and challenge token settings. Determines how long a CAPTCHA or challenge timestamp remains valid after WAF updates it for a successful CAPTCHA or challenge response. </p>', 'refs' => [ 'AwsWafv2WebAclCaptchaConfigDetails$ImmunityTimeProperty' => '<p> Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully solves a CAPTCHA puzzle. </p>', ], ], 'AwsWafv2WebAclDetails' => [ 'base' => '<p> Details about an WAFv2 web Access Control List (ACL). </p>', 'refs' => [ 'ResourceDetails$AwsWafv2WebAcl' => NULL, ], ], 'AwsXrayEncryptionConfigDetails' => [ 'base' => '<p>Information about the encryption configuration for X-Ray.</p>', 'refs' => [ 'ResourceDetails$AwsXrayEncryptionConfig' => '<p>Information about the encryption configuration for X-Ray.</p>', ], ], 'BatchDeleteAutomationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteAutomationRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisableStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisableStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchEnableStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchEnableStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAutomationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAutomationRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetConfigurationPolicyAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetConfigurationPolicyAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSecurityControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSecurityControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStandardsControlAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStandardsControlAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchImportFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchImportFindingsRequestFindingList' => [ 'base' => NULL, 'refs' => [ 'BatchImportFindingsRequest$Findings' => '<p>A list of findings to import. To successfully import a finding, it must follow the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a>. Maximum of 100 findings per request.</p>', ], ], 'BatchImportFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateAutomationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateAutomationRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsUnprocessedFinding' => [ 'base' => '<p>A finding from a <code>BatchUpdateFindings</code> request that Security Hub was unable to update.</p>', 'refs' => [ 'BatchUpdateFindingsUnprocessedFindingsList$member' => NULL, ], ], 'BatchUpdateFindingsUnprocessedFindingsList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateFindingsResponse$UnprocessedFindings' => '<p>The list of findings that were not updated.</p>', ], ], 'BatchUpdateStandardsControlAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateStandardsControlAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AssociationSetDetails$Main' => '<p> Indicates whether this is the main route table. </p>', 'AutomationRulesConfig$IsTerminal' => '<p>Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn\'t evaluate other rules for the finding. By default, a rule isn\'t terminal. </p>', 'AutomationRulesMetadata$IsTerminal' => '<p>Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn\'t evaluate other rules for the finding. By default, a rule isn\'t terminal. </p>', 'AwsAmazonMqBrokerDetails$AutoMinorVersionUpgrade' => '<p> Whether automatically upgrade new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot. </p>', 'AwsAmazonMqBrokerDetails$PubliclyAccessible' => '<p> Permits connections from applications outside of the VPC that hosts the broker\'s subnets. </p>', 'AwsAmazonMqBrokerEncryptionOptionsDetails$UseAwsOwnedKey' => '<p> Specifies that an KMS key should be used for at-rest encryption. Set to <code>true</code> by default if no value is provided (for example, for RabbitMQ brokers). </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$RoleSearchSubtree' => '<p> The directory search scope for the role. If set to <code>true</code>, the scope is to search the entire subtree. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$UserSearchSubtree' => '<p> The directory search scope for the user. If set to true, the scope is to search the entire subtree. </p>', 'AwsAmazonMqBrokerLogsDetails$Audit' => '<p> Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Doesn\'t apply to RabbitMQ brokers. </p>', 'AwsAmazonMqBrokerLogsDetails$General' => '<p> Activates general logging. </p>', 'AwsAmazonMqBrokerLogsPendingDetails$Audit' => '<p> Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Doesn\'t apply to RabbitMQ brokers. </p>', 'AwsAmazonMqBrokerLogsPendingDetails$General' => '<p> Activates general logging. </p>', 'AwsApiGatewayCanarySettings$UseStageCache' => '<p>Indicates whether the canary deployment uses the stage cache.</p>', 'AwsApiGatewayMethodSettings$MetricsEnabled' => '<p>Indicates whether CloudWatch metrics are enabled for the method. </p>', 'AwsApiGatewayMethodSettings$DataTraceEnabled' => '<p>Indicates whether data trace logging is enabled for the method. Data trace logging affects the log entries that are pushed to CloudWatch Logs.</p>', 'AwsApiGatewayMethodSettings$CachingEnabled' => '<p>Indicates whether responses are cached and returned for requests. For responses to be cached, a cache cluster must be enabled on the stage.</p>', 'AwsApiGatewayMethodSettings$CacheDataEncrypted' => '<p>Indicates whether the cached responses are encrypted. </p>', 'AwsApiGatewayMethodSettings$RequireAuthorizationForCacheControl' => '<p>Indicates whether authorization is required for a cache invalidation request.</p>', 'AwsApiGatewayStageDetails$CacheClusterEnabled' => '<p>Indicates whether a cache cluster is enabled for the stage.</p>', 'AwsApiGatewayStageDetails$TracingEnabled' => '<p>Indicates whether active tracing with X-Ray is enabled for the stage.</p>', 'AwsApiGatewayV2RouteSettings$DetailedMetricsEnabled' => '<p>Indicates whether detailed metrics are enabled.</p>', 'AwsApiGatewayV2RouteSettings$DataTraceEnabled' => '<p>Indicates whether data trace logging is enabled. Data trace logging affects the log entries that are pushed to CloudWatch Logs. Supported only for WebSocket APIs.</p>', 'AwsApiGatewayV2StageDetails$AutoDeploy' => '<p>Indicates whether updates to an API automatically trigger a new deployment.</p>', 'AwsApiGatewayV2StageDetails$ApiGatewayManaged' => '<p>Indicates whether the stage is managed by API Gateway.</p>', 'AwsAppSyncGraphQlApiDetails$XrayEnabled' => '<p> Indicates whether to use X-Ray tracing for the GraphQL API. </p>', 'AwsAppSyncGraphQlApiLogConfigDetails$ExcludeVerboseContent' => '<p> Set to <code>TRUE</code> to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level. </p>', 'AwsAutoScalingAutoScalingGroupDetails$CapacityRebalance' => '<p>Indicates whether capacity rebalancing is enabled. </p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails$NoDevice' => '<p>Whether to suppress the device that is included in the block device mapping of the Amazon Machine Image (AMI).</p> <p>If <code>NoDevice</code> is <code>true</code>, then you cannot specify <code>Ebs</code>.&gt;</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$DeleteOnTermination' => '<p>Whether to delete the volume when the instance is terminated.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$Encrypted' => '<p>Whether to encrypt the volume.</p>', 'AwsAutoScalingLaunchConfigurationDetails$AssociatePublicIpAddress' => '<p>For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group\'s instances.</p>', 'AwsAutoScalingLaunchConfigurationDetails$EbsOptimized' => '<p>Whether the launch configuration is optimized for Amazon EBS I/O.</p>', 'AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails$Enabled' => '<p>If set to <code>true</code>, then instances in the group launch with detailed monitoring.</p> <p>If set to <code>false</code>, then instances in the group launch with basic monitoring.</p>', 'AwsBackupBackupPlanRuleDetails$EnableContinuousBackup' => '<p>Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR). </p>', 'AwsBackupRecoveryPointDetails$IsEncrypted' => '<p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted. </p>', 'AwsCloudFormationStackDetails$DisableRollback' => '<p>Boolean to enable or disable rollback on stack creation failures. </p>', 'AwsCloudFormationStackDetails$EnableTerminationProtection' => '<p>Whether termination protection is enabled for the stack. </p>', 'AwsCloudFrontDistributionLogging$Enabled' => '<p>With this field, you can enable or disable the selected distribution.</p>', 'AwsCloudFrontDistributionLogging$IncludeCookies' => '<p>Specifies whether you want CloudFront to include cookies in access logs.</p>', 'AwsCloudFrontDistributionViewerCertificate$CloudFrontDefaultCertificate' => '<p>Whether the distribution uses the CloudFront domain name. If set to <code>false</code>, then you provide either <code>AcmCertificateArn</code> or <code>IamCertificateId</code>.</p>', 'AwsCloudTrailTrailDetails$HasCustomEventSelectors' => '<p>Indicates whether the trail has custom event selectors.</p>', 'AwsCloudTrailTrailDetails$IncludeGlobalServiceEvents' => '<p>Indicates whether the trail publishes events from global services such as IAM to the log files.</p>', 'AwsCloudTrailTrailDetails$IsMultiRegionTrail' => '<p>Indicates whether the trail applies only to the current Region or to all Regions.</p>', 'AwsCloudTrailTrailDetails$IsOrganizationTrail' => '<p>Whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.</p>', 'AwsCloudTrailTrailDetails$LogFileValidationEnabled' => '<p>Indicates whether CloudTrail log file validation is enabled.</p>', 'AwsCloudWatchAlarmDetails$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state. </p>', 'AwsCodeBuildProjectArtifactsDetails$EncryptionDisabled' => '<p>Indicates whether to disable encryption on the artifact. Only valid when <code>Type</code> is <code>S3</code>.</p>', 'AwsCodeBuildProjectArtifactsDetails$OverrideArtifactName' => '<p>Whether the name specified in the buildspec file overrides the artifact name.</p>', 'AwsCodeBuildProjectEnvironment$PrivilegedMode' => '<p>Whether to allow the Docker daemon to run inside a Docker container. Set to <code>true</code> if the build project is used to build Docker images.</p>', 'AwsCodeBuildProjectLogsConfigS3LogsDetails$EncryptionDisabled' => '<p>Whether to disable encryption of the S3 build log output.</p>', 'AwsCodeBuildProjectSource$InsecureSsl' => '<p>Whether to ignore SSL warnings while connecting to the project source code.</p>', 'AwsCorsConfiguration$AllowCredentials' => '<p>Indicates whether the CORS request includes credentials.</p>', 'AwsDmsReplicationInstanceDetails$AutoMinorVersionUpgrade' => '<p> Indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. </p>', 'AwsDmsReplicationInstanceDetails$MultiAZ' => '<p> Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You can\'t set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code>.</p>', 'AwsDmsReplicationInstanceDetails$PubliclyAccessible' => '<p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>.</p>', 'AwsDynamoDbTableDetails$DeletionProtectionEnabled' => '<p> Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table. </p>', 'AwsDynamoDbTableGlobalSecondaryIndex$Backfilling' => '<p>Whether the index is currently backfilling.</p>', 'AwsDynamoDbTableRestoreSummary$RestoreInProgress' => '<p>Whether a restore is currently in progress.</p>', 'AwsDynamoDbTableStreamSpecification$StreamEnabled' => '<p>Indicates whether DynamoDB Streams is enabled on the table.</p>', 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails$Enabled' => '<p> Indicates whether client connect options are enabled. </p>', 'AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails$Enabled' => '<p> Current state of text banner feature. </p>', 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails$Enabled' => '<p> Indicates whether client connection logging is enabled for the Client VPN endpoint. </p>', 'AwsEc2ClientVpnEndpointDetails$SplitTunnel' => '<p> Indicates whether split-tunnel is enabled in the Client VPN endpoint. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$DeleteOnTermination' => '<p> Indicates whether the EBS volume is deleted on instance termination. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$Encrypted' => '<p> Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you\'re creating a volume from a snapshot, you can\'t specify an encryption value. </p>', 'AwsEc2LaunchTemplateDataDetails$DisableApiStop' => '<p> Indicates whether to enable the instance for stop protection. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Enable stop protection</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataDetails$DisableApiTermination' => '<p> If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API. If set to <code>true</code>, you can. </p>', 'AwsEc2LaunchTemplateDataDetails$EbsOptimized' => '<p> Indicates whether the instance is optimized for Amazon EBS I/O. </p>', 'AwsEc2LaunchTemplateDataEnclaveOptionsDetails$Enabled' => '<p> If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves. </p>', 'AwsEc2LaunchTemplateDataHibernationOptionsDetails$Configured' => '<p> If you set this parameter to <code>true</code>, the instance is enabled for hibernation. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$RequireHibernateSupport' => '<p> Indicates whether instance types must support hibernation for On-Demand Instances. </p>', 'AwsEc2LaunchTemplateDataMonitoringDetails$Enabled' => '<p> Enables detailed monitoring when <code>true</code> is specified. Otherwise, basic monitoring is enabled. For more information about detailed monitoring, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html">Enable or turn off detailed monitoring for your instances</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$AssociateCarrierIpAddress' => '<p> Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP address</a> in the <i>Wavelength Developer Guide</i>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$AssociatePublicIpAddress' => '<p> Associates a public IPv4 address with eth0 for a new network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$DeleteOnTermination' => '<p> Indicates whether the network interface is deleted when the instance is terminated. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails$Primary' => '<p> Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary. </p>', 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails$EnableResourceNameDnsAAAARecord' => '<p> Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. </p>', 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails$EnableResourceNameDnsARecord' => '<p> Indicates whether to respond to DNS queries for instance hostnames with DNS A records. </p>', 'AwsEc2NetworkAclDetails$IsDefault' => '<p>Whether this is the default network ACL for the VPC.</p>', 'AwsEc2NetworkAclEntry$Egress' => '<p>Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the subnet.</p>', 'AwsEc2NetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'AwsEc2NetworkInterfaceDetails$SourceDestCheck' => '<p>Indicates whether traffic to or from the instance is validated.</p>', 'AwsEc2SubnetDetails$AssignIpv6AddressOnCreation' => '<p>Whether to assign an IPV6 address to a network interface that is created in this subnet.</p>', 'AwsEc2SubnetDetails$DefaultForAz' => '<p>Whether this subnet is the default subnet for the Availability Zone.</p>', 'AwsEc2SubnetDetails$MapPublicIpOnLaunch' => '<p>Whether instances in this subnet receive a public IP address.</p>', 'AwsEc2VolumeAttachment$DeleteOnTermination' => '<p>Whether the EBS volume is deleted when the EC2 instance is terminated.</p>', 'AwsEc2VolumeDetails$Encrypted' => '<p>Specifies whether the volume is encrypted.</p>', 'AwsEc2VpcEndpointServiceDetails$AcceptanceRequired' => '<p>Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>', 'AwsEc2VpcEndpointServiceDetails$ManagesVpcEndpoints' => '<p>Whether the service manages its VPC endpoints.</p>', 'AwsEc2VpnConnectionOptionsDetails$StaticRoutesOnly' => '<p>Whether the VPN connection uses static routes only.</p>', 'AwsEcrRepositoryImageScanningConfigurationDetails$ScanOnPush' => '<p>Whether to scan images after they are pushed to a repository.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails$CloudWatchEncryptionEnabled' => '<p>Whether to enable encryption on the CloudWatch logs.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails$S3EncryptionEnabled' => '<p>Whether to encrypt the logs that are sent to the S3 bucket.</p>', 'AwsEcsContainerDetails$Privileged' => '<p>When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user). </p>', 'AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails$Enable' => '<p>Whether to enable the deployment circuit breaker logic for the service.</p>', 'AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails$Rollback' => '<p>Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.</p>', 'AwsEcsServiceDetails$EnableEcsManagedTags' => '<p>Whether to enable Amazon ECS managed tags for the tasks in the service.</p>', 'AwsEcsServiceDetails$EnableExecuteCommand' => '<p>Whether the execute command functionality is enabled for the service.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DisableNetworking' => '<p>Whether to disable networking within the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Essential' => '<p>Whether the container is essential. All tasks must have at least one essential container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Interactive' => '<p>If set to true, then containerized applications can be deployed that require <code>stdin</code> or a <code>tty</code> to be allocated.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Privileged' => '<p>Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$PseudoTerminal' => '<p>Whether to allocate a TTY to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$ReadonlyRootFilesystem' => '<p>Whether the container is given read-only access to its root file system.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$InitProcessEnabled' => '<p>Whether to run an <code>init</code> process inside the container that forwards signals and reaps processes. </p>', 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails$ReadOnly' => '<p>Whether the container has read-only access to the volume.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails$ReadOnly' => '<p>Whether the container has read-only access to the volume.</p>', 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails$Autoprovision' => '<p>Whether to create the Docker volume automatically if it does not already exist.</p>', 'AwsEksClusterLoggingClusterLoggingDetails$Enabled' => '<p>Whether the logging types that are listed in <code>Types</code> are enabled.</p>', 'AwsEksClusterResourcesVpcConfigDetails$EndpointPublicAccess' => '<p> Indicates whether the Amazon EKS public API server endpoint is turned on. If the Amazon EKS public API server endpoint is turned off, your cluster\'s Kubernetes API server can only receive requests that originate from within the cluster VPC. </p>', 'AwsElasticsearchDomainDomainEndpointOptions$EnforceHTTPS' => '<p>Whether to require that all traffic to the domain arrive over HTTPS.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$DedicatedMasterEnabled' => '<p>Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs cluster management tasks, but doesn\'t hold data or respond to data upload requests.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$ZoneAwarenessEnabled' => '<p>Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch allocates the cluster\'s nodes and replica index shards across Availability Zones in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.</p>', 'AwsElasticsearchDomainEncryptionAtRestOptions$Enabled' => '<p>Whether encryption at rest is enabled.</p>', 'AwsElasticsearchDomainLogPublishingOptionsLogConfig$Enabled' => '<p>Whether the log publishing is enabled.</p>', 'AwsElasticsearchDomainNodeToNodeEncryptionOptions$Enabled' => '<p>Whether node-to-node encryption is enabled.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$Cancellable' => '<p>Whether a request to update the domain can be canceled.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$UpdateAvailable' => '<p>Whether a service software update is available for the domain.</p>', 'AwsElbLoadBalancerAccessLog$Enabled' => '<p>Indicates whether access logs are enabled for the load balancer.</p>', 'AwsElbLoadBalancerConnectionDraining$Enabled' => '<p>Indicates whether connection draining is enabled for the load balancer.</p>', 'AwsElbLoadBalancerCrossZoneLoadBalancing$Enabled' => '<p>Indicates whether cross-zone load balancing is enabled for the load balancer.</p>', 'AwsIamAccessKeySessionContextAttributes$MfaAuthenticated' => '<p>Indicates whether the session used multi-factor authentication (MFA).</p>', 'AwsIamPolicyDetails$IsAttachable' => '<p>Whether the policy can be attached to a user, group, or role.</p>', 'AwsIamPolicyVersion$IsDefaultVersion' => '<p>Whether the version is the default version.</p>', 'AwsKmsKeyDetails$KeyRotationStatus' => '<p>Whether the key has key rotation enabled.</p>', 'AwsMskClusterClusterInfoClientAuthenticationSaslIamDetails$Enabled' => '<p> Indicates whether SASL/IAM authentication is enabled or not.</p>', 'AwsMskClusterClusterInfoClientAuthenticationSaslScramDetails$Enabled' => '<p> Indicates whether SASL/SCRAM authentication is enabled or not.</p>', 'AwsMskClusterClusterInfoClientAuthenticationTlsDetails$Enabled' => '<p> Indicates whether TLS authentication is enabled or not.</p>', 'AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails$Enabled' => '<p> Indicates whether unauthenticated is allowed or not.</p>', 'AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails$InCluster' => '<p> When set to <code>true</code>, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to <code>false</code>, the communication happens in plain text. The default value is <code>true</code>.</p>', 'AwsNetworkFirewallFirewallDetails$DeleteProtection' => '<p>Whether the firewall is protected from deletion. If set to <code>true</code>, then the firewall cannot be deleted.</p>', 'AwsNetworkFirewallFirewallDetails$FirewallPolicyChangeProtection' => '<p>Whether the firewall is protected from a change to the firewall policy. If set to <code>true</code>, you cannot associate a different policy with the firewall.</p>', 'AwsNetworkFirewallFirewallDetails$SubnetChangeProtection' => '<p>Whether the firewall is protected from a change to the subnet associations. If set to <code>true</code>, you cannot map different subnets to the firewall.</p>', 'AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails$Enabled' => '<p>Enables fine-grained access control. </p>', 'AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails$InternalUserDatabaseEnabled' => '<p>Enables the internal user database. </p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$WarmEnabled' => '<p>Whether UltraWarm is enabled.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$DedicatedMasterEnabled' => '<p>Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$ZoneAwarenessEnabled' => '<p>Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster\'s nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.</p>', 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails$CustomEndpointEnabled' => '<p>Whether to enable a custom endpoint for the domain.</p>', 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails$EnforceHTTPS' => '<p>Whether to require that all traffic to the domain arrive over HTTPS.</p>', 'AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails$Enabled' => '<p>Whether encryption at rest is enabled.</p>', 'AwsOpenSearchServiceDomainLogPublishingOption$Enabled' => '<p>Whether the log publishing is enabled.</p>', 'AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails$Enabled' => '<p>Whether node-to-node encryption is enabled.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$Cancellable' => '<p>Whether a request to update the domain can be canceled.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$UpdateAvailable' => '<p>Whether a service software update is available for the domain.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$OptionalDeployment' => '<p>Whether the service software update is optional.</p>', 'AwsRdsDbClusterDetails$MultiAz' => '<p>Whether the DB cluster has instances in multiple Availability Zones.</p>', 'AwsRdsDbClusterDetails$StorageEncrypted' => '<p>Whether the DB cluster is encrypted.</p>', 'AwsRdsDbClusterDetails$DeletionProtection' => '<p>Whether the DB cluster has deletion protection enabled.</p>', 'AwsRdsDbClusterDetails$HttpEndpointEnabled' => '<p>Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p>', 'AwsRdsDbClusterDetails$CopyTagsToSnapshot' => '<p>Whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>', 'AwsRdsDbClusterDetails$CrossAccountClone' => '<p>Whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>', 'AwsRdsDbClusterDetails$IamDatabaseAuthenticationEnabled' => '<p>Whether the mapping of IAM accounts to database accounts is enabled.</p>', 'AwsRdsDbClusterDetails$AutoMinorVersionUpgrade' => '<p> Indicates if minor version upgrades are automatically applied to the cluster.</p>', 'AwsRdsDbClusterMember$IsClusterWriter' => '<p>Whether the cluster member is the primary instance for the DB cluster.</p>', 'AwsRdsDbClusterSnapshotDetails$StorageEncrypted' => '<p>Whether the DB cluster is encrypted.</p>', 'AwsRdsDbClusterSnapshotDetails$IamDatabaseAuthenticationEnabled' => '<p>Whether mapping of IAM accounts to database accounts is enabled.</p>', 'AwsRdsDbInstanceDetails$DeletionProtection' => '<p>Indicates whether the DB instance has deletion protection enabled.</p> <p>When deletion protection is enabled, the database cannot be deleted.</p>', 'AwsRdsDbInstanceDetails$IAMDatabaseAuthenticationEnabled' => '<p>True if mapping of IAM accounts to database accounts is enabled, and otherwise false.</p> <p>IAM database authentication can be enabled for the following database engines.</p> <ul> <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li> <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li> <li> <p>Aurora 5.6 or higher</p> </li> </ul>', 'AwsRdsDbInstanceDetails$PubliclyAccessible' => '<p>Specifies the accessibility options for the DB instance.</p> <p>A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address.</p> <p>A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p>', 'AwsRdsDbInstanceDetails$StorageEncrypted' => '<p>Specifies whether the DB instance is encrypted.</p>', 'AwsRdsDbInstanceDetails$MultiAz' => '<p>Whether the DB instance is a multiple Availability Zone deployment.</p>', 'AwsRdsDbInstanceDetails$AutoMinorVersionUpgrade' => '<p>Indicates whether minor version patches are applied automatically.</p>', 'AwsRdsDbInstanceDetails$CopyTagsToSnapshot' => '<p>Whether to copy resource tags to snapshots of the DB instance.</p>', 'AwsRdsDbInstanceDetails$PerformanceInsightsEnabled' => '<p>Indicates whether Performance Insights is enabled for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$MultiAZ' => '<p>Indicates that a single Availability Zone DB instance is changing to a multiple Availability Zone deployment.</p>', 'AwsRdsDbSnapshotDetails$Encrypted' => '<p>Whether the DB snapshot is encrypted.</p>', 'AwsRdsDbSnapshotDetails$IamDatabaseAuthenticationEnabled' => '<p>Whether mapping of IAM accounts to database accounts is enabled.</p>', 'AwsRdsDbStatusInfo$Normal' => '<p>Whether the read replica instance is operating normally.</p>', 'AwsRdsEventSubscriptionDetails$Enabled' => '<p>Whether the event notification subscription is enabled.</p>', 'AwsRedshiftClusterDetails$AllowVersionUpgrade' => '<p>Indicates whether major version upgrades are applied automatically to the cluster during the maintenance window.</p>', 'AwsRedshiftClusterDetails$Encrypted' => '<p>Indicates whether the data in the cluster is encrypted at rest.</p>', 'AwsRedshiftClusterDetails$EnhancedVpcRouting' => '<p>Indicates whether to create the cluster with enhanced VPC routing enabled.</p>', 'AwsRedshiftClusterDetails$PubliclyAccessible' => '<p>Whether the cluster can be accessed from a public network.</p>', 'AwsRedshiftClusterLoggingStatus$LoggingEnabled' => '<p>Indicates whether logging is enabled.</p>', 'AwsRedshiftClusterPendingModifiedValues$EnhancedVpcRouting' => '<p>Indicates whether to create the cluster with enhanced VPC routing enabled.</p>', 'AwsRedshiftClusterPendingModifiedValues$PubliclyAccessible' => '<p>The pending or in-progress change to whether the cluster can be connected to from the public network.</p>', 'AwsRedshiftClusterResizeInfo$AllowCancelResize' => '<p>Indicates whether the resize operation can be canceled.</p>', 'AwsS3AccountPublicAccessBlockDetails$BlockPublicAcls' => '<p>Indicates whether to reject calls to update an S3 bucket if the calls include a public access control list (ACL).</p>', 'AwsS3AccountPublicAccessBlockDetails$BlockPublicPolicy' => '<p>Indicates whether to reject calls to update the access policy for an S3 bucket or access point if the policy allows public access.</p>', 'AwsS3AccountPublicAccessBlockDetails$IgnorePublicAcls' => '<p>Indicates whether Amazon S3 ignores public ACLs that are associated with an S3 bucket.</p>', 'AwsS3AccountPublicAccessBlockDetails$RestrictPublicBuckets' => '<p>Indicates whether to restrict access to an access point or S3 bucket that has a public policy to only Amazon Web Services service principals and authorized users within the S3 bucket owner\'s account.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$ExpiredObjectDeleteMarker' => '<p>Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to <code>true</code>, the delete marker is expired. If set to <code>false</code>, the policy takes no action.</p> <p>If you provide <code>ExpiredObjectDeleteMarker</code>, you cannot provide <code>ExpirationInDays</code> or <code>ExpirationDate</code>.</p>', 'AwsS3BucketBucketVersioningConfiguration$IsMfaDeleteEnabled' => '<p>Specifies whether MFA delete is currently enabled in the S3 bucket versioning configuration. If the S3 bucket was never configured with MFA delete, then this attribute is not included.</p>', 'AwsSecretsManagerSecretDetails$RotationOccurredWithinFrequency' => '<p>Whether the rotation occurred within the specified rotation frequency.</p>', 'AwsSecretsManagerSecretDetails$RotationEnabled' => '<p>Whether rotation is enabled.</p>', 'AwsSecretsManagerSecretDetails$Deleted' => '<p>Whether the secret is deleted.</p>', 'AwsSecurityFinding$Sample' => '<p>Indicates whether the finding is a sample finding.</p>', 'AwsStepFunctionStateMachineLoggingConfigurationDetails$IncludeExecutionData' => '<p> Determines whether execution data is included in your log. When set to false, data is excluded. </p>', 'AwsStepFunctionStateMachineTracingConfigurationDetails$Enabled' => '<p> When set to true, X-Ray tracing is enabled. </p>', 'AwsWafRateBasedRuleMatchPredicate$Negated' => '<p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p> <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings. </p>', 'AwsWafRegionalRateBasedRuleMatchPredicate$Negated' => '<p>If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.</p> <p>If set to <code>false</code>, then the rule actions are performed on all requests except those that match the predicate settings.</p>', 'AwsWafRegionalRulePredicateListDetails$Negated' => '<p>Specifies if you want WAF to allow, block, or count requests based on the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. </p>', 'AwsWafRulePredicateListDetails$Negated' => '<p>Specifies if you want WAF to allow, block, or count requests based on the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. </p>', 'AwsWafv2VisibilityConfigDetails$CloudWatchMetricsEnabled' => '<p> A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF metrics and dimensions</a> in the <i>WAF Developer Guide</i>. </p>', 'AwsWafv2VisibilityConfigDetails$SampledRequestsEnabled' => '<p> A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the WAF console. </p>', 'AwsWafv2WebAclDetails$ManagedbyFirewallManager' => '<p> Indicates whether this web ACL is managed by Firewall Manager. </p>', 'BooleanConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a boolean parameter. </p>', 'BooleanFilter$Value' => '<p>The value of the boolean.</p>', 'ClassificationResult$AdditionalOccurrences' => '<p>Indicates whether there are additional occurrences of sensitive data that are not included in the finding. This occurs when the number of occurrences exceeds the maximum that can be included.</p>', 'ConfigurationPolicySummary$ServiceEnabled' => '<p> Indicates whether the service that the configuration policy applies to is enabled in the policy. </p>', 'ContainerDetails$Privileged' => '<p>When this parameter is <code>true</code>, the container is given elevated privileges on the host container instance (similar to the root user). </p>', 'CreateAutomationRuleRequest$IsTerminal' => '<p>Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn\'t evaluate other rules for the finding. By default, a rule isn\'t terminal. </p>', 'DescribeHubResponse$AutoEnableControls' => '<p>Whether to automatically enable new controls when they are added to standards that are enabled.</p> <p>If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to <code>false</code>, then new controls are not enabled.</p>', 'DescribeOrganizationConfigurationResponse$AutoEnable' => '<p>Whether to automatically enable Security Hub in new member accounts when they join the organization.</p> <p>If set to <code>true</code>, then Security Hub is automatically enabled in new accounts. If set to <code>false</code>, then Security Hub isn\'t enabled in new accounts automatically. The default value is <code>false</code>.</p> <p>If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code>, then this field is set to <code>false</code> and can\'t be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which Security Hub is enabled and associate the policy with new organization accounts.</p>', 'DescribeOrganizationConfigurationResponse$MemberAccountLimitReached' => '<p>Whether the maximum number of allowed member accounts are already associated with the Security Hub administrator account.</p>', 'DnsRequestAction$Blocked' => '<p>Indicates whether the DNS request was blocked.</p>', 'EnableSecurityHubRequest$EnableDefaultStandards' => '<p>Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>', 'FindingHistoryRecord$FindingCreated' => '<p> Identifies whether the event marks the creation of a new finding. A value of <code>True</code> means that the finding is newly created. A value of <code>False</code> means that the finding isn’t newly created. </p>', 'ListMembersRequest$OnlyAssociated' => '<p>Specifies which member accounts to include in the response based on their relationship status with the administrator account. The default value is <code>TRUE</code>.</p> <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose relationship status with the administrator account is set to <code>ENABLED</code>.</p> <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts. </p>', 'NetworkConnectionAction$Blocked' => '<p>Indicates whether the network connection attempt was blocked.</p>', 'ParameterValue$Boolean' => '<p> A control parameter that is a boolean. </p>', 'PortProbeAction$Blocked' => '<p>Indicates whether the port probe was blocked.</p>', 'SecurityHubPolicy$ServiceEnabled' => '<p> Indicates whether Security Hub is enabled in the policy. </p>', 'Standard$EnabledByDefault' => '<p>Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is enabled by default, the check box for that standard is selected by default.</p> <p>When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is enabled by default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.</p>', 'UpdateAutomationRulesRequestItem$IsTerminal' => '<p>Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn\'t evaluate other rules for the finding. By default, a rule isn\'t terminal. </p>', 'UpdateOrganizationConfigurationRequest$AutoEnable' => '<p>Whether to automatically enable Security Hub in new member accounts when they join the organization.</p> <p>If set to <code>true</code>, then Security Hub is automatically enabled in new accounts. If set to <code>false</code>, then Security Hub isn\'t enabled in new accounts automatically. The default value is <code>false</code>.</p> <p>If the <code>ConfigurationType</code> of your organization is set to <code>CENTRAL</code>, then this field is set to <code>false</code> and can\'t be changed in the home Region and linked Regions. However, in that case, the delegated administrator can create a configuration policy in which Security Hub is enabled and associate the policy with new organization accounts.</p>', 'UpdateSecurityHubConfigurationRequest$AutoEnableControls' => '<p>Whether to automatically enable new controls when they are added to standards that are enabled.</p> <p>By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code>. </p>', 'VpcInfoPeeringOptionsDetails$AllowDnsResolutionFromRemoteVpc' => '<p>Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC. </p>', 'VpcInfoPeeringOptionsDetails$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection. </p>', 'VpcInfoPeeringOptionsDetails$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection. </p>', ], ], 'BooleanConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter with a boolean. For a boolean parameter, the options are <code>true</code> and <code>false</code>. </p>', 'refs' => [ 'ConfigurationOptions$Boolean' => '<p> The options for customizing a security control parameter that is a boolean. For a boolean parameter, the options are <code>true</code> and <code>false</code>. </p>', ], ], 'BooleanFilter' => [ 'base' => '<p>Boolean filter for querying findings.</p>', 'refs' => [ 'BooleanFilterList$member' => NULL, ], ], 'BooleanFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$Sample' => '<p>Indicates whether or not sample findings are included in the filter results.</p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'Product$Categories' => '<p>The categories assigned to the product.</p>', ], ], 'Cell' => [ 'base' => '<p>An occurrence of sensitive data detected in a Microsoft Excel workbook, comma-separated value (CSV) file, or tab-separated value (TSV) file.</p>', 'refs' => [ 'Cells$member' => NULL, ], ], 'Cells' => [ 'base' => NULL, 'refs' => [ 'Occurrences$Cells' => '<p>Occurrences of sensitive data detected in Microsoft Excel workbooks, comma-separated value (CSV) files, or tab-separated value (TSV) files.</p>', ], ], 'CidrBlockAssociation' => [ 'base' => '<p>An IPv4 CIDR block association.</p>', 'refs' => [ 'CidrBlockAssociationList$member' => NULL, ], ], 'CidrBlockAssociationList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcDetails$CidrBlockAssociationSet' => '<p>Information about the IPv4 CIDR blocks associated with the VPC.</p>', ], ], 'City' => [ 'base' => '<p>Information about a city.</p>', 'refs' => [ 'ActionRemoteIpDetails$City' => '<p>The city where the remote IP address is located.</p>', ], ], 'ClassificationResult' => [ 'base' => '<p>Details about the sensitive data that was detected on the resource.</p>', 'refs' => [ 'DataClassificationDetails$Result' => '<p>The details about the sensitive data that was detected on the resource.</p>', ], ], 'ClassificationStatus' => [ 'base' => '<p>Provides details about the current status of the sensitive data detection.</p>', 'refs' => [ 'ClassificationResult$Status' => '<p>The current status of the sensitive data detection.</p>', ], ], 'CloudWatchLogsLogGroupArnConfigDetails' => [ 'base' => '<p> The Amazon Resource Name (ARN) and other details of the Amazon CloudWatch Logs log group that Amazon Route 53 is publishing logs to.</p>', 'refs' => [ 'AwsRoute53QueryLoggingConfigDetails$CloudWatchLogsLogGroupArn' => '<p> The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log group that Route 53 is publishing logs to.</p>', ], ], 'CodeVulnerabilitiesFilePath' => [ 'base' => '<p> Provides details about where a code vulnerability is located in your Lambda function. </p>', 'refs' => [ 'VulnerabilityCodeVulnerabilities$FilePath' => '<p> Provides details about where a code vulnerability is located in your Lambda function. </p>', ], ], 'Compliance' => [ 'base' => '<p>Contains finding details that are specific to control-based findings. Only returned for findings generated from controls.</p>', 'refs' => [ 'AwsSecurityFinding$Compliance' => '<p>This data type is exclusive to findings that are generated as the result of a check run against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'Compliance$Status' => '<p>The result of a standards check.</p> <p>The valid values for <code>Status</code> are as follows.</p> <ul> <li> <ul> <li> <p> <code>PASSED</code> - Standards check passed for all evaluated resources.</p> </li> <li> <p> <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.</p> </li> <li> <p> <code>FAILED</code> - Standards check failed for at least one evaluated resource.</p> </li> <li> <p> <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the result of the Config evaluation was <code>NOT_APPLICABLE</code>. If the Config evaluation result was <code>NOT_APPLICABLE</code> for a Security Hub control, Security Hub automatically archives the finding after 3 days.</p> </li> </ul> </li> </ul>', ], ], 'ConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter. </p>', 'refs' => [ 'ParameterDefinition$ConfigurationOptions' => '<p> The options for customizing a control parameter. Customization options vary based on the data type of the parameter. </p>', ], ], 'ConfigurationPolicyAssociation' => [ 'base' => '<p> Provides details about the association between an Security Hub configuration and a target account, organizational unit, or the root. An association can exist between a target and a configuration policy, or between a target and self-managed behavior. </p>', 'refs' => [ 'ConfigurationPolicyAssociationsList$member' => NULL, 'UnprocessedConfigurationPolicyAssociation$ConfigurationPolicyAssociationIdentifiers' => '<p> Configuration policy association identifiers that were specified in a <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error. </p>', ], ], 'ConfigurationPolicyAssociationList' => [ 'base' => NULL, 'refs' => [ 'BatchGetConfigurationPolicyAssociationsResponse$ConfigurationPolicyAssociations' => '<p> Describes associations for the target accounts, OUs, or the root. </p>', ], ], 'ConfigurationPolicyAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'AssociationFilters$AssociationStatus' => '<p> The current status of the association between a target and a configuration policy. </p>', 'ConfigurationPolicyAssociationSummary$AssociationStatus' => '<p> The current status of the association between the specified target and the configuration. </p>', 'GetConfigurationPolicyAssociationResponse$AssociationStatus' => '<p> The current status of the association between the specified target and the configuration. </p>', 'StartConfigurationPolicyAssociationResponse$AssociationStatus' => '<p> The current status of the association between the specified target and the configuration. </p>', ], ], 'ConfigurationPolicyAssociationSummary' => [ 'base' => '<p> An object that contains the details of a configuration policy association that’s returned in a <code>ListConfigurationPolicyAssociations</code> request. </p>', 'refs' => [ 'ConfigurationPolicyAssociationList$member' => NULL, 'ConfigurationPolicyAssociationSummaryList$member' => NULL, ], ], 'ConfigurationPolicyAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationPolicyAssociationsResponse$ConfigurationPolicyAssociationSummaries' => '<p> An object that contains the details of each configuration policy association that’s returned in a <code>ListConfigurationPolicyAssociations</code> request. </p>', ], ], 'ConfigurationPolicyAssociationsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetConfigurationPolicyAssociationsRequest$ConfigurationPolicyAssociationIdentifiers' => '<p> Specifies one or more target account IDs, organizational unit (OU) IDs, or the root ID to retrieve associations for. </p>', ], ], 'ConfigurationPolicySummary' => [ 'base' => '<p> An object that contains the details of an Security Hub configuration policy that’s returned in a <code>ListConfigurationPolicies</code> request. </p>', 'refs' => [ 'ConfigurationPolicySummaryList$member' => NULL, ], ], 'ConfigurationPolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationPoliciesResponse$ConfigurationPolicySummaries' => '<p> Provides metadata for each of your configuration policies. </p>', ], ], 'ContainerDetails' => [ 'base' => '<p>Container details related to a finding.</p>', 'refs' => [ 'ResourceDetails$Container' => '<p>Details about a container resource related to a finding.</p>', ], ], 'ControlFindingGenerator' => [ 'base' => NULL, 'refs' => [ 'DescribeHubResponse$ControlFindingGenerator' => '<p>Specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.</p> <p>If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.</p> <p>The value for this field in a member account matches the value in the administrator account. For accounts that aren\'t part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.</p>', 'EnableSecurityHubRequest$ControlFindingGenerator' => '<p>This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.</p> <p>If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.</p> <p>The value for this field in a member account matches the value in the administrator account. For accounts that aren\'t part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.</p>', 'UpdateSecurityHubConfigurationRequest$ControlFindingGenerator' => '<p>Updates whether the calling account has consolidated control findings turned on. If the value for this field is set to <code>SECURITY_CONTROL</code>, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.</p> <p>If the value for this field is set to <code>STANDARD_CONTROL</code>, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.</p> <p>For accounts that are part of an organization, this value can only be updated in the administrator account.</p>', ], ], 'ControlStatus' => [ 'base' => NULL, 'refs' => [ 'SecurityControl$SecurityControlStatus' => '<p> The enablement status of a security control in a specific standard. </p>', 'StandardsControl$ControlStatus' => '<p>The current status of the security standard control. Indicates whether the control is enabled or disabled. Security Hub does not check against disabled controls.</p>', 'UpdateStandardsControlRequest$ControlStatus' => '<p>The updated status of the security standard control.</p>', ], ], 'Country' => [ 'base' => '<p>Information about a country.</p>', 'refs' => [ 'ActionRemoteIpDetails$Country' => '<p>The country where the remote IP address is located.</p>', ], ], 'CreateActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutomationRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutomationRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfigurationPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfigurationPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingAggregatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'CrossAccountMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsRequest$MaxResults' => '<p>The maximum number of items to return in the response. </p>', 'ListMembersRequest$MaxResults' => '<p>The maximum number of items to return in the response. </p>', ], ], 'CustomDataIdentifiersDetections' => [ 'base' => '<p>The list of detected instances of sensitive data.</p>', 'refs' => [ 'CustomDataIdentifiersDetectionsList$member' => NULL, ], ], 'CustomDataIdentifiersDetectionsList' => [ 'base' => NULL, 'refs' => [ 'CustomDataIdentifiersResult$Detections' => '<p>The list of detected instances of sensitive data.</p>', ], ], 'CustomDataIdentifiersResult' => [ 'base' => '<p>Contains an instance of sensitive data that was detected by a customer-defined identifier.</p>', 'refs' => [ 'ClassificationResult$CustomDataIdentifiers' => '<p>Provides details about sensitive data that was identified based on customer-defined configuration.</p>', ], ], 'CustomizableProperties' => [ 'base' => NULL, 'refs' => [ 'SecurityControlDefinition$CustomizableProperties' => '<p> Security control properties that you can customize. Currently, only parameter customization is supported for select controls. An empty array is returned for controls that don’t support custom properties. </p>', ], ], 'Cvss' => [ 'base' => '<p>CVSS scores from the advisory related to the vulnerability.</p>', 'refs' => [ 'CvssList$member' => NULL, ], ], 'CvssList' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$Cvss' => '<p>CVSS scores from the advisory related to the vulnerability.</p>', ], ], 'DataClassificationDetails' => [ 'base' => '<p>Provides details about sensitive data that was detected on a resource.</p>', 'refs' => [ 'Resource$DataClassification' => '<p>Contains information about sensitive data that was detected on the resource.</p>', ], ], 'DateFilter' => [ 'base' => '<p>A date filter for querying findings.</p>', 'refs' => [ 'DateFilterList$member' => NULL, ], ], 'DateFilterList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFilters$FirstObservedAt' => '<p> A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$LastObservedAt' => '<p> A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$CreatedAt' => '<p> A timestamp that indicates when this finding record was created. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$UpdatedAt' => '<p> A timestamp that indicates when the finding record was most recently updated. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$NoteUpdatedAt' => '<p> The timestamp of when the note was updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AwsSecurityFindingFilters$FirstObservedAt' => '<p>A timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$LastObservedAt' => '<p>A timestamp that indicates when the security findings provider most recently observed the potential security issue that a finding captured.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$CreatedAt' => '<p>A timestamp that indicates when the security findings provider created the potential security issue that a finding reflects.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$UpdatedAt' => '<p>A timestamp that indicates when the security findings provider last updated the finding record.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$ProcessLaunchedAt' => '<p>A timestamp that identifies when the process was launched.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$ProcessTerminatedAt' => '<p>A timestamp that identifies when the process was terminated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorLastObservedAt' => '<p>A timestamp that identifies the last observation of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceLaunchedAt' => '<p>The date and time the instance was launched.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyCreatedAt' => '<p>The creation date/time of the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerLaunchedAt' => '<p>A timestamp that identifies when the container was started.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFindingFilters$NoteUpdatedAt' => '<p>The timestamp of when the note was updated.</p>', ], ], 'DateRange' => [ 'base' => '<p>A date range for the date filter.</p>', 'refs' => [ 'DateFilter$DateRange' => '<p>A date range for the date filter.</p>', ], ], 'DateRangeUnit' => [ 'base' => NULL, 'refs' => [ 'DateRange$Unit' => '<p>A date range unit for the date filter.</p>', ], ], 'DeclineInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeclineInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFindingAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFindingAggregatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProductsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProductsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableImportFindingsForProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImportFindingsForProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableOrganizationAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableSecurityHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableSecurityHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisabledSecurityControlIdentifierList' => [ 'base' => NULL, 'refs' => [ 'SecurityControlsConfiguration$DisabledSecurityControlIdentifiers' => '<p> A list of security controls that are disabled in the configuration policy. Security Hub enables all other controls (including newly released controls) other than the listed controls. </p>', ], ], 'DisassociateFromAdministratorAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromAdministratorAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DnsRequestAction' => [ 'base' => '<p>Provided if <code>ActionType</code> is <code>DNS_REQUEST</code>. It provides details about the DNS request that was detected.</p>', 'refs' => [ 'Action$DnsRequestAction' => '<p>Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS request that was detected. </p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AwsApiGatewayCanarySettings$PercentTraffic' => '<p>The percentage of traffic that is diverted to a canary deployment.</p>', 'AwsApiGatewayMethodSettings$ThrottlingRateLimit' => '<p>The throttling rate limit for the method.</p>', 'AwsApiGatewayV2RouteSettings$ThrottlingRateLimit' => '<p>The throttling rate limit.</p>', 'AwsCloudWatchAlarmDetails$Threshold' => '<p>The value to compare with the specified statistic. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails$Max' => '<p> The maximum amount of memory per vCPU, in GiB. If this parameter is omitted, there\'s no maximum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails$Min' => '<p> The minimum amount of memory per vCPU, in GiB. If this parameter is omitted, there\'s no maximum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails$Max' => '<p> The maximum amount of total local storage, in GB. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails$Min' => '<p> The minimum amount of total local storage, in GB. </p>', 'AwsKmsKeyDetails$CreationDate' => '<p>Indicates when the KMS key was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterRestoreStatus$CurrentRestoreRateInMegaBytesPerSecond' => '<p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup.</p> <p>This field is only updated when you restore to DC2 and DS2 node types.</p>', 'Cvss$BaseScore' => '<p>The base CVSS score.</p>', 'DoubleConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is a double. </p>', 'DoubleConfigurationOptions$Min' => '<p> The minimum valid value for a control parameter that is a double. </p>', 'DoubleConfigurationOptions$Max' => '<p> The maximum valid value for a control parameter that is a double. </p>', 'GeoLocation$Lon' => '<p>The longitude of the location.</p>', 'GeoLocation$Lat' => '<p>The latitude of the location.</p>', 'NumberFilter$Gte' => '<p>The greater-than-equal condition to be applied to a single field when querying for findings. </p>', 'NumberFilter$Lte' => '<p>The less-than-equal condition to be applied to a single field when querying for findings. </p>', 'NumberFilter$Eq' => '<p>The equal-to condition to be applied to a single field when querying for findings.</p>', 'NumberFilter$Gt' => '<p> The greater-than condition to be applied to a single field when querying for findings. </p>', 'NumberFilter$Lt' => '<p> The less-than condition to be applied to a single field when querying for findings. </p>', 'ParameterValue$Double' => '<p> A control parameter that is a double. </p>', 'Severity$Product' => '<p>Deprecated. This attribute isn\'t included in findings. Instead of providing <code>Product</code>, provide <code>Original</code>.</p> <p>The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.</p>', 'SeverityUpdate$Product' => '<p>The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.</p>', 'Vulnerability$EpssScore' => '<p>The Exploit Prediction Scoring System (EPSS) score for a finding. </p>', ], ], 'DoubleConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is a double. </p>', 'refs' => [ 'ConfigurationOptions$Double' => '<p> The options for customizing a security control parameter that is a double. </p>', ], ], 'EnableImportFindingsForProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImportFindingsForProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableOrganizationAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableOrganizationAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableSecurityHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableSecurityHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnabledSecurityControlIdentifierList' => [ 'base' => NULL, 'refs' => [ 'SecurityControlsConfiguration$EnabledSecurityControlIdentifiers' => '<p> A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. </p>', ], ], 'EnabledStandardIdentifierList' => [ 'base' => NULL, 'refs' => [ 'SecurityHubPolicy$EnabledStandardIdentifiers' => '<p> A list that defines which security standards are enabled in the configuration policy. </p>', ], ], 'EnumConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is an enum. </p>', 'refs' => [ 'ConfigurationOptions$Enum' => '<p> The options for customizing a security control parameter that is an enum. </p>', ], ], 'EnumListConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is a list of enums. </p>', 'refs' => [ 'ConfigurationOptions$EnumList' => '<p> The options for customizing a security control parameter that is a list of enums. </p>', ], ], 'FieldMap' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFieldsUpdate$UserDefinedFields' => '<p> The rule action updates the <code>UserDefinedFields</code> field of a finding. </p>', 'AwsApiCallAction$AffectedResources' => '<p>Identifies the resources that were affected by the API call.</p>', 'AwsApiGatewayCanarySettings$StageVariableOverrides' => '<p>Stage variables that are overridden in the canary release deployment. The variables include new stage variables that are introduced in the canary.</p> <p>Each variable is represented as a string-to-string map between the stage variable name and the variable value.</p>', 'AwsApiGatewayStageDetails$Variables' => '<p>A map that defines the stage variables for the stage.</p> <p>Variable names can have alphanumeric and underscore characters.</p> <p>Variable values can contain the following characters:</p> <ul> <li> <p>Uppercase and lowercase letters</p> </li> <li> <p>Numbers</p> </li> <li> <p>Special characters -._~:/?#&amp;=,</p> </li> </ul>', 'AwsApiGatewayV2StageDetails$StageVariables' => '<p>A map that defines the stage variables for the stage.</p> <p>Variable names can have alphanumeric and underscore characters.</p> <p>Variable values can contain the following characters:</p> <ul> <li> <p>Uppercase and lowercase letters</p> </li> <li> <p>Numbers</p> </li> <li> <p>Special characters -._~:/?#&amp;=,</p> </li> </ul>', 'AwsBackupBackupPlanAdvancedBackupSettingsDetails$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs. Valid values are as follows:</p> <ul> <li> <p>Set to <code>WindowsVSS: enabled</code> to enable the WindowsVSS backup option and create a Windows VSS backup.</p> </li> <li> <p>Set to <code>WindowsVSS: disabled</code> to create a regular backup. The <code>WindowsVSS</code> option is not enabled by default.</p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DockerLabels' => '<p>A key-value map of labels to add to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails$Options' => '<p>The options to use to configure the log router.</p> <p>The valid option keys are as follows:</p> <ul> <li> <p> <code>enable-ecs-log-metadata</code>. The value can be <code>true</code> or <code>false</code>.</p> </li> <li> <p> <code>config-file-type</code>. The value can be <code>s3</code> or <code>file</code>.</p> </li> <li> <p> <code>config-file-value</code>. The value is either an S3 ARN or a file path.</p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails$Options' => '<p>The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.</p>', 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails$DriverOpts' => '<p>A map of Docker driver-specific options that are passed through.</p>', 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails$Labels' => '<p>Custom metadata to add to the Docker volume.</p>', 'AwsElasticsearchDomainDetails$Endpoints' => '<p>The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.</p>', 'AwsLambdaFunctionEnvironment$Variables' => '<p>Environment variable key-value pairs.</p>', 'AwsOpenSearchServiceDomainDetails$DomainEndpoints' => '<p>The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p> <p>This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.</p>', 'AwsSecurityFinding$ProductFields' => '<p>A data type where security findings providers can include additional solution-specific details that aren\'t part of the defined <code>AwsSecurityFinding</code> format.</p> <p>Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.</p>', 'AwsSecurityFinding$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p> <p>Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 1024 characters.</p>', 'BatchUpdateFindingsRequest$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p>', 'Resource$Tags' => '<p>A list of Amazon Web Services tags associated with a resource at the time the finding was processed. Tags must follow <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Amazon Web Services tag naming limits and requirements</a>.</p>', 'ResourceDetails$Other' => '<p>Details about a resource that are not available in a type-specific details object. Use the <code>Other</code> object in the following cases.</p> <ul> <li> <p>The type-specific object does not contain all of the fields that you want to populate. In this case, first use the type-specific object to populate those fields. Use the <code>Other</code> object to populate the fields that are missing from the type-specific object.</p> </li> <li> <p>The resource type does not have a corresponding object. This includes resources for which the type is <code>Other</code>. </p> </li> </ul>', ], ], 'FilePathList' => [ 'base' => NULL, 'refs' => [ 'Threat$FilePaths' => '<p>Provides information about the file paths that were affected by the threat. </p> <p>Array Members: Minimum number of 1 item. Maximum number of 5 items.</p>', ], ], 'FilePaths' => [ 'base' => '<p>Provides information about the file paths that were affected by the threat. </p>', 'refs' => [ 'FilePathList$member' => NULL, ], ], 'FindingAggregator' => [ 'base' => '<p>A finding aggregator. A finding aggregator contains the configuration for finding aggregation.</p>', 'refs' => [ 'FindingAggregatorList$member' => NULL, ], ], 'FindingAggregatorList' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregatorsResponse$FindingAggregators' => '<p>The list of finding aggregators. This operation currently only returns a single result.</p>', ], ], 'FindingHistoryRecord' => [ 'base' => '<p> A list of events that changed the specified finding during the specified time period. Each record represents a single finding change event. </p>', 'refs' => [ 'FindingHistoryRecordList$member' => NULL, ], ], 'FindingHistoryRecordList' => [ 'base' => NULL, 'refs' => [ 'GetFindingHistoryResponse$Records' => '<p> A list of events that altered the specified finding during the specified time period. </p>', ], ], 'FindingHistoryUpdate' => [ 'base' => '<p> An array of objects that provides details about a change to a finding, including the Amazon Web Services Security Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after the change. </p>', 'refs' => [ 'FindingHistoryUpdatesList$member' => NULL, ], ], 'FindingHistoryUpdateSource' => [ 'base' => '<p> Identifies the source of the finding change event. </p>', 'refs' => [ 'FindingHistoryRecord$UpdateSource' => '<p> Identifies the source of the event that changed the finding. For example, an integrated Amazon Web Servicesservice or third-party partner integration may call <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html"> <code>BatchImportFindings</code> </a>, or an Security Hub customer may call <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html"> <code>BatchUpdateFindings</code> </a>. </p>', ], ], 'FindingHistoryUpdateSourceType' => [ 'base' => NULL, 'refs' => [ 'FindingHistoryUpdateSource$Type' => '<p> Describes the type of finding change event, such as a call to <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html"> <code>BatchImportFindings</code> </a> (by an integrated Amazon Web Servicesservice or third party partner integration) or <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html"> <code>BatchUpdateFindings</code> </a> (by a Security Hub customer). </p>', ], ], 'FindingHistoryUpdatesList' => [ 'base' => NULL, 'refs' => [ 'FindingHistoryRecord$Updates' => '<p> An array of objects that provides details about the finding change event, including the Amazon Web Services Security Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after the change. </p>', ], ], 'FindingProviderFields' => [ 'base' => '<p>In a <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html"> <code>BatchImportFindings</code> </a> request, finding providers use <code>FindingProviderFields</code> to provide and update values for the following fields:</p> <ul> <li> <p> <code>Confidence</code> </p> </li> <li> <p> <code>Criticality</code> </p> </li> <li> <p> <code>RelatedFindings</code> </p> </li> <li> <p> <code>Severity</code> </p> </li> <li> <p> <code>Types</code> </p> </li> </ul> <p>The preceding fields are nested under the <code>FindingProviderFields</code> object, but also have analogues of the same name as top-level ASFF fields. When a new finding is sent to Security Hub by a finding provider, Security Hub populates the <code>FindingProviderFields</code> object automatically, if it is empty, based on the corresponding top-level fields.</p> <p>Finding providers can update <code>FindingProviderFields</code> only by using the <code>BatchImportFindings</code> operation. Finding providers can\'t update this object with the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html"> <code>BatchUpdateFindings</code> </a> operation. Customers can update the top-level fields by using the <code>BatchUpdateFindings</code> operation. Customers can\'t update <code>FindingProviderFields</code>.</p> <p>For information about how Security Hub handles updates from <code>BatchImportFindings</code> to <code>FindingProviderFields</code> and to the corresponding top-level attributes, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchimportfindings.html#batchimportfindings-findingproviderfields">Using <code>FindingProviderFields</code> </a> in the <i>Security Hub User Guide</i>.</p> <p/>', 'refs' => [ 'AwsSecurityFinding$FindingProviderFields' => '<p>In a <code>BatchImportFindings</code> request, finding providers use <code>FindingProviderFields</code> to provide and update their own values for confidence, criticality, related findings, severity, and types.</p>', ], ], 'FindingProviderSeverity' => [ 'base' => '<p>The severity assigned to a finding by the finding provider. This object may include one or more of the following attributes:</p> <ul> <li> <p> <code>Label</code> </p> </li> <li> <p> <code>Normalized</code> </p> </li> <li> <p> <code>Original</code> </p> </li> <li> <p> <code>Product</code> </p> </li> </ul> <p>If a <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html"> <code>BatchImportFindings</code> </a> request for a new finding only provides <code>Label</code> or only provides <code>Normalized</code>, Security Hub automatically populates the value of the other field.</p> <p>The <code>Normalized</code> and <code>Product</code> attributes are included in the <code>FindingProviderSeverity</code> structure to preserve the historical information associated with the finding, even if the top-level <code>Severity</code> object is later modified using the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html"> <code>BatchUpdateFindings</code> </a> operation.</p> <p>If the top-level <code>Finding.Severity</code> object is present, but <code>Finding.FindingProviderFields</code> isn\'t present, Security Hub creates the <code>FindingProviderFields.Severity</code> object and copies the entire <code>Finding.Severity</code> object into it. This ensures that the original, provider-supplied details are retained within the <code>FindingProviderFields.Severity</code> object, even if the top-level <code>Severity</code> object is overwritten. </p>', 'refs' => [ 'FindingProviderFields$Severity' => '<p>The severity of a finding.</p>', ], ], 'FirewallPolicyDetails' => [ 'base' => '<p>Defines the behavior of the firewall.</p>', 'refs' => [ 'AwsNetworkFirewallFirewallPolicyDetails$FirewallPolicy' => '<p>The firewall policy configuration.</p>', ], ], 'FirewallPolicyStatefulRuleGroupReferencesDetails' => [ 'base' => '<p>A stateful rule group that is used by the firewall policy.</p>', 'refs' => [ 'FirewallPolicyStatefulRuleGroupReferencesList$member' => NULL, ], ], 'FirewallPolicyStatefulRuleGroupReferencesList' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicyDetails$StatefulRuleGroupReferences' => '<p>The stateful rule groups that are used in the firewall policy.</p>', ], ], 'FirewallPolicyStatelessCustomActionsDetails' => [ 'base' => '<p>A custom action that can be used for stateless packet handling.</p>', 'refs' => [ 'FirewallPolicyStatelessCustomActionsList$member' => NULL, ], ], 'FirewallPolicyStatelessCustomActionsList' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicyDetails$StatelessCustomActions' => '<p>The custom action definitions that are available to use in the firewall policy\'s <code>StatelessDefaultActions</code> setting.</p>', ], ], 'FirewallPolicyStatelessRuleGroupReferencesDetails' => [ 'base' => '<p>A stateless rule group that is used by the firewall policy.</p>', 'refs' => [ 'FirewallPolicyStatelessRuleGroupReferencesList$member' => NULL, ], ], 'FirewallPolicyStatelessRuleGroupReferencesList' => [ 'base' => NULL, 'refs' => [ 'FirewallPolicyDetails$StatelessRuleGroupReferences' => '<p>The stateless rule groups that are used in the firewall policy.</p>', ], ], 'GeneratorDetails' => [ 'base' => '<p> Provides metadata for the Amazon CodeGuru detector associated with a finding. This field pertains to findings that relate to Lambda functions. Amazon Inspector identifies policy violations and vulnerabilities in Lambda function code based on internal detectors developed in collaboration with Amazon CodeGuru. Security Hub receives those findings. </p>', 'refs' => [ 'AwsSecurityFinding$GeneratorDetails' => '<p>Provides metadata for the Amazon CodeGuru detector associated with a finding. This field pertains to findings that relate to Lambda functions. Amazon Inspector identifies policy violations and vulnerabilities in Lambda function code based on internal detectors developed in collaboration with Amazon CodeGuru. Security Hub receives those findings. </p>', ], ], 'GeoLocation' => [ 'base' => '<p>Provides the latitude and longitude coordinates of a location.</p>', 'refs' => [ 'ActionRemoteIpDetails$GeoLocation' => '<p>The coordinates of the location of the remote IP address.</p>', ], ], 'GetAdministratorAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAdministratorAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationPolicyAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationPolicyAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnabledStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnabledStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingAggregatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityControlDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityControlDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'IcmpTypeCode' => [ 'base' => '<p>An Internet Control Message Protocol (ICMP) type and code.</p>', 'refs' => [ 'AwsEc2NetworkAclEntry$IcmpTypeCode' => '<p>The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.</p>', ], ], 'ImportFindingsError' => [ 'base' => '<p>The list of the findings that cannot be imported. For each finding, the list provides the error.</p>', 'refs' => [ 'ImportFindingsErrorList$member' => NULL, ], ], 'ImportFindingsErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchImportFindingsResponse$FailedFindings' => '<p>The list of findings that failed to import.</p>', ], ], 'Insight' => [ 'base' => '<p>Contains information about a Security Hub insight.</p>', 'refs' => [ 'InsightList$member' => NULL, ], ], 'InsightList' => [ 'base' => NULL, 'refs' => [ 'GetInsightsResponse$Insights' => '<p>The insights returned by the operation.</p>', ], ], 'InsightResultValue' => [ 'base' => '<p>The insight result values returned by the <code>GetInsightResults</code> operation.</p>', 'refs' => [ 'InsightResultValueList$member' => NULL, ], ], 'InsightResultValueList' => [ 'base' => NULL, 'refs' => [ 'InsightResults$ResultValues' => '<p>The list of insight result values returned by the <code>GetInsightResults</code> operation.</p>', ], ], 'InsightResults' => [ 'base' => '<p>The insight results returned by the <code>GetInsightResults</code> operation.</p>', 'refs' => [ 'GetInsightResultsResponse$InsightResults' => '<p>The insight results returned by the operation.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ActionLocalPortDetails$Port' => '<p>The number of the port.</p>', 'ActionRemotePortDetails$Port' => '<p>The number of the port.</p>', 'AwsApiGatewayMethodSettings$ThrottlingBurstLimit' => '<p>The throttling burst limit for the method.</p>', 'AwsApiGatewayMethodSettings$CacheTtlInSeconds' => '<p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response is cached.</p>', 'AwsApiGatewayRestApiDetails$MinimumCompressionSize' => '<p>The minimum size in bytes of a payload before compression is enabled.</p> <p>If <code>null</code>, then compression is disabled.</p> <p>If 0, then all payloads are compressed.</p>', 'AwsApiGatewayV2RouteSettings$ThrottlingBurstLimit' => '<p>The throttling burst limit.</p>', 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails$AuthorizerResultTtlInSeconds' => '<p> The number of seconds a response should be cached for. The default is 5 minutes (300 seconds). </p>', 'AwsAutoScalingAutoScalingGroupDetails$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$OnDemandBaseCapacity' => '<p>The minimum amount of the Auto Scaling group\'s capacity that must be fulfilled by On-Demand Instances.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$OnDemandPercentageAboveBaseCapacity' => '<p>The percentage of On-Demand Instances and Spot Instances for additional capacity beyond <code>OnDemandBaseCapacity</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$SpotInstancePools' => '<p>The number of Spot Instance pools across which to allocate your Spot Instances.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$Iops' => '<p>The number of input/output (I/O) operations per second (IOPS) to provision for the volume.</p> <p>Only supported for <code>gp3</code> or <code>io1</code> volumes. Required for <code>io1</code> volumes. Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$VolumeSize' => '<p>The volume size, in GiBs. The following are the supported volumes sizes for each volume type:</p> <ul> <li> <p>gp2 and gp3: 1-16,384</p> </li> <li> <p>io1: 4-16,384</p> </li> <li> <p>st1 and sc1: 125-16,384</p> </li> <li> <p>standard: 1-1,024</p> </li> </ul> <p>You must specify either <code>SnapshotId</code> or <code>VolumeSize</code>. If you specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of the snapshot.</p>', 'AwsAutoScalingLaunchConfigurationMetadataOptions$HttpPutResponseHopLimit' => '<p>The HTTP <code>PUT</code> response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>', 'AwsCloudFormationStackDetails$TimeoutInMinutes' => '<p>The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state. </p>', 'AwsCloudFrontDistributionOriginCustomOriginConfig$HttpPort' => '<p>The HTTP port that CloudFront uses to connect to the origin. </p>', 'AwsCloudFrontDistributionOriginCustomOriginConfig$HttpsPort' => '<p>The HTTPS port that CloudFront uses to connect to the origin. </p>', 'AwsCloudFrontDistributionOriginCustomOriginConfig$OriginKeepaliveTimeout' => '<p>Specifies how long, in seconds, CloudFront persists its connection to the origin. </p>', 'AwsCloudFrontDistributionOriginCustomOriginConfig$OriginReadTimeout' => '<p>Specifies how long, in seconds, CloudFront waits for a response from the origin. </p>', 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodes$Quantity' => '<p>The number of status codes that can cause a failover.</p>', 'AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList$member' => NULL, 'AwsCloudFrontDistributionOriginSslProtocols$Quantity' => '<p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS connection with this origin. </p>', 'AwsCloudWatchAlarmDetails$DatapointsToAlarm' => '<p>The number of datapoints that must be breaching to trigger the alarm. </p>', 'AwsCloudWatchAlarmDetails$EvaluationPeriods' => '<p>The number of periods over which data is compared to the specified threshold. </p>', 'AwsCloudWatchAlarmDetails$Period' => '<p>The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric. </p>', 'AwsCodeBuildProjectSource$GitCloneDepth' => '<p>Information about the Git clone depth for the build project.</p>', 'AwsCorsConfiguration$MaxAge' => '<p>The number of seconds for which the browser caches preflight request results.</p>', 'AwsDmsEndpointDetails$Port' => '<p> The port used to access the endpoint. </p>', 'AwsDmsReplicationInstanceDetails$AllocatedStorage' => '<p> The amount of storage (in gigabytes) that is allocated for the replication instance. </p>', 'AwsDynamoDbTableDetails$ItemCount' => '<p>The number of items in the table.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$ItemCount' => '<p>The number of items in the index.</p>', 'AwsDynamoDbTableProvisionedThroughput$NumberOfDecreasesToday' => '<p>The number of times during the current UTC calendar day that the provisioned throughput was decreased.</p>', 'AwsDynamoDbTableProvisionedThroughput$ReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'AwsDynamoDbTableProvisionedThroughput$WriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'AwsDynamoDbTableProvisionedThroughputOverride$ReadCapacityUnits' => '<p>The read capacity units for the replica.</p>', 'AwsEc2ClientVpnEndpointDetails$VpnPort' => '<p> The port number for the Client VPN endpoint. </p>', 'AwsEc2ClientVpnEndpointDetails$SessionTimeoutHours' => '<p> The maximum VPN session duration time in hours. </p>', 'AwsEc2InstanceMetadataOptions$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$Iops' => '<p> The number of I/O operations per second (IOPS). </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$Throughput' => '<p> The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$VolumeSize' => '<p> The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. </p>', 'AwsEc2LaunchTemplateDataCpuOptionsDetails$CoreCount' => '<p> The number of CPU cores for the instance. </p>', 'AwsEc2LaunchTemplateDataCpuOptionsDetails$ThreadsPerCore' => '<p> The number of threads per CPU core. A value of <code>1</code> disables multithreading for the instance, The default value is <code>2</code>. </p>', 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails$Count' => '<p> The number of Elastic Inference accelerators to attach to the instance. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails$BlockDurationMinutes' => '<p> Deprecated. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails$Max' => '<p> The maximum number of accelerators. If this parameter isn\'t specified, there\'s no maximum limit. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails$Min' => '<p> The minimum number of accelerators. If this parameter isn\'t specified, there\'s no minimum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails$Max' => '<p> The maximum amount of memory, in MiB. If this parameter isn\'t specified, there\'s no maximum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails$Min' => '<p> The minimum amount of memory, in MiB. If <code>0</code> is specified, there\'s no maximum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails$Max' => '<p> The maximum baseline bandwidth, in Mbps. If this parameter is omitted, there\'s no maximum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails$Min' => '<p> The minimum baseline bandwidth, in Mbps. If this parameter is omitted, there\'s no minimum limit. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$OnDemandMaxPricePercentageOverLowestPrice' => '<p> The price protection threshold for On-Demand Instances. This is the maximum you\'ll pay for an On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.</p> <p>The parameter accepts an integer, which Amazon EC2 interprets as a percentage.</p> <p>A high value, such as <code>999999</code>, turns off price protection.</p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$SpotMaxPricePercentageOverLowestPrice' => '<p> The price protection threshold for Spot Instances. This is the maximum you\'ll pay for a Spot Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold. </p> <p>The parameter accepts an integer, which Amazon EC2 interprets as a percentage.</p> <p>A high value, such as <code>999999</code>, turns off price protection.</p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails$Max' => '<p> The maximum amount of memory, in MiB. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails$Min' => '<p> The minimum amount of memory, in MiB. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails$Max' => '<p> The maximum number of network interfaces. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails$Min' => '<p> The minimum number of network interfaces. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails$Max' => '<p> The maximum number of vCPUs. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails$Min' => '<p> The minimum number of vCPUs. </p>', 'AwsEc2LaunchTemplateDataMetadataOptionsDetails$HttpPutResponseHopLimit' => '<p> The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$DeviceIndex' => '<p> The device index for the network interface attachment. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv4PrefixCount' => '<p> The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv4Prefixes</code> option. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv6AddressCount' => '<p> The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can\'t use this option if you use <code>Ipv6Addresses</code>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Ipv6PrefixCount' => '<p> The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv6Prefix</code> option. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$NetworkCardIndex' => '<p> The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index <code>0</code>. The default is network card index <code>0</code>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$SecondaryPrivateIpAddressCount' => '<p> The number of secondary private IPv4 addresses to assign to a network interface. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$PartitionNumber' => '<p> The number of the partition the instance should launch in. </p>', 'AwsEc2NetworkAclEntry$RuleNumber' => '<p>The rule number. The rules are processed in order by their number.</p>', 'AwsEc2NetworkInterfaceAttachment$DeviceIndex' => '<p>The device index of the network interface attachment on the instance.</p>', 'AwsEc2SecurityGroupIpPermission$FromPort' => '<p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.</p> <p>A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes. </p>', 'AwsEc2SecurityGroupIpPermission$ToPort' => '<p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.</p> <p>A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>', 'AwsEc2SubnetDetails$AvailableIpAddressCount' => '<p>The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.</p>', 'AwsEc2TransitGatewayDetails$AmazonSideAsn' => '<p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. </p>', 'AwsEc2VolumeDetails$Size' => '<p>The size of the volume, in GiBs.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$DpdTimeoutSeconds' => '<p>The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase1LifetimeSeconds' => '<p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase2LifetimeSeconds' => '<p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$RekeyFuzzPercentage' => '<p>The percentage of the rekey window, which is determined by <code>RekeyMarginTimeSeconds</code> during which the rekey time is randomly selected.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$RekeyMarginTimeSeconds' => '<p>The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side of the VPN connection performs an IKE rekey.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$ReplayWindowSize' => '<p>The number of packets in an IKE replay window.</p>', 'AwsEc2VpnConnectionVgwTelemetryDetails$AcceptedRouteCount' => '<p>The number of accepted routes.</p>', 'AwsEcsClusterDefaultCapacityProviderStrategyDetails$Base' => '<p>The minimum number of tasks to run on the specified capacity provider.</p>', 'AwsEcsClusterDefaultCapacityProviderStrategyDetails$Weight' => '<p>The relative percentage of the total number of tasks launched that should use the capacity provider.</p>', 'AwsEcsClusterDetails$ActiveServicesCount' => '<p>The number of services that are running on the cluster in an <code>ACTIVE</code> state. You can view these services with the Amazon ECS <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html"> <code>ListServices</code> </a> API operation. </p>', 'AwsEcsClusterDetails$RegisteredContainerInstancesCount' => '<p>The number of container instances registered into the cluster. This includes container instances in both <code>ACTIVE</code> and <code>DRAINING</code> status. </p>', 'AwsEcsClusterDetails$RunningTasksCount' => '<p>The number of tasks in the cluster that are in the <code>RUNNING</code> state. </p>', 'AwsEcsServiceCapacityProviderStrategyDetails$Base' => '<p>The minimum number of tasks to run on the capacity provider. Only one strategy item can specify a value for <code>Base</code>.</p> <p>The value must be between 0 and 100000.</p>', 'AwsEcsServiceCapacityProviderStrategyDetails$Weight' => '<p>The relative percentage of the total number of tasks that should use the capacity provider.</p> <p>If no weight is specified, the default value is 0. At least one capacity provider must have a weight greater than 0.</p> <p>The value can be between 0 and 1000.</p>', 'AwsEcsServiceDeploymentConfigurationDetails$MaximumPercent' => '<p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and for tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default value is 200%.</p> <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p> <p>For the Fargate launch type, the maximum percent value is not used.</p>', 'AwsEcsServiceDeploymentConfigurationDetails$MinimumHealthyPercent' => '<p>For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while any container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.</p> <p>For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.</p> <p>For the Fargate launch type, the minimum healthy percent value is not used.</p>', 'AwsEcsServiceDetails$DesiredCount' => '<p>The number of instantiations of the task definition to run on the service.</p>', 'AwsEcsServiceDetails$HealthCheckGracePeriodSeconds' => '<p>After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.</p>', 'AwsEcsServiceLoadBalancersDetails$ContainerPort' => '<p>The port on the container to associate with the load balancer. This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.</p>', 'AwsEcsServiceServiceRegistriesDetails$ContainerPort' => '<p>The port value to use for the service discovery service.</p> <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p> <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>', 'AwsEcsServiceServiceRegistriesDetails$Port' => '<p>The port value to use for a service discovery service that specifies an SRV record. This field can be used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Cpu' => '<p>The number of CPU units reserved for the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Memory' => '<p>The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$MemoryReservation' => '<p>The soft limit (in MiB) of memory to reserve for the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$StartTimeout' => '<p>The number of seconds to wait before giving up on resolving dependencies for a container. </p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$StopTimeout' => '<p>The number of seconds to wait before the container is stopped if it doesn\'t shut down normally on its own.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails$Interval' => '<p>The time period in seconds between each health check execution. The default value is 30 seconds.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails$Retries' => '<p>The number of times to retry a failed health check before the container is considered unhealthy. The default value is 3.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails$StartPeriod' => '<p>The optional grace period in seconds that allows containers time to bootstrap before failed health checks count towards the maximum number of retries.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails$Timeout' => '<p>The time period in seconds to wait for a health check to succeed before it is considered a failure. The default value is 5.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$MaxSwap' => '<p>The total amount of swap memory (in MiB) that a container can use.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$SharedMemorySize' => '<p>The value for the size (in MiB) of the <b>/dev/shm</b> volume.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails$Swappiness' => '<p>Configures the container\'s memory swappiness behavior. Determines how aggressively pages are swapped. The higher the value, the more aggressive the swappiness. The default is 60.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails$Size' => '<p>The maximum size (in MiB) of the tmpfs volume.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails$ContainerPort' => '<p>The port number on the container that is bound to the user-specified or automatically assigned host port.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails$HostPort' => '<p>The port number on the container instance to reserve for the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails$HardLimit' => '<p>The hard limit for the ulimit type.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails$SoftLimit' => '<p>The soft limit for the ulimit type.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails$TransitEncryptionPort' => '<p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$DedicatedMasterCount' => '<p>The number of instances to use for the master node. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$InstanceCount' => '<p>The number of data nodes to use in the Elasticsearch domain.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails$AvailabilityZoneCount' => '<p>he number of Availability Zones that the domain uses. Valid values are 2 and 3. The default is 2.</p>', 'AwsElbLoadBalancerAccessLog$EmitInterval' => '<p>The interval in minutes for publishing the access logs.</p> <p>You can publish access logs either every 5 minutes or every 60 minutes.</p>', 'AwsElbLoadBalancerBackendServerDescription$InstancePort' => '<p>The port on which the EC2 instance is listening.</p>', 'AwsElbLoadBalancerConnectionDraining$Timeout' => '<p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>', 'AwsElbLoadBalancerConnectionSettings$IdleTimeout' => '<p>The time, in seconds, that the connection can be idle (no data is sent over the connection) before it is closed by the load balancer.</p>', 'AwsElbLoadBalancerHealthCheck$HealthyThreshold' => '<p>The number of consecutive health check successes required before the instance is moved to the Healthy state.</p>', 'AwsElbLoadBalancerHealthCheck$Interval' => '<p>The approximate interval, in seconds, between health checks of an individual instance.</p>', 'AwsElbLoadBalancerHealthCheck$Timeout' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p>', 'AwsElbLoadBalancerHealthCheck$UnhealthyThreshold' => '<p>The number of consecutive health check failures that must occur before the instance is moved to the Unhealthy state.</p>', 'AwsElbLoadBalancerListener$InstancePort' => '<p>The port on which the instance is listening.</p>', 'AwsElbLoadBalancerListener$LoadBalancerPort' => '<p>The port on which the load balancer is listening.</p> <p>On EC2-VPC, you can specify any port from the range 1-65535.</p> <p>On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>', 'AwsIamPolicyDetails$AttachmentCount' => '<p>The number of users, groups, and roles that the policy is attached to.</p>', 'AwsIamPolicyDetails$PermissionsBoundaryUsageCount' => '<p>The number of users and roles that use the policy to set the permissions boundary.</p>', 'AwsIamRoleDetails$MaxSessionDuration' => '<p>The maximum session duration (in seconds) that you want to set for the specified role.</p>', 'AwsKinesisStreamDetails$ShardCount' => '<p>The number of shards that the stream uses. </p>', 'AwsKinesisStreamDetails$RetentionPeriodHours' => '<p>The number of hours for the data records that are stored in shards to remain accessible. </p>', 'AwsLambdaFunctionDetails$MemorySize' => '<p>The memory that is allocated to the function.</p>', 'AwsLambdaFunctionDetails$Timeout' => '<p>The amount of time that Lambda allows a function to run before stopping it.</p>', 'AwsLambdaFunctionLayer$CodeSize' => '<p>The size of the layer archive in bytes.</p>', 'AwsMskClusterClusterInfoDetails$NumberOfBrokerNodes' => '<p> The number of broker nodes in the cluster.</p>', 'AwsNetworkFirewallRuleGroupDetails$Capacity' => '<p>The maximum number of operating resources that this rule group can use.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$InstanceCount' => '<p>The number of data nodes to use in the OpenSearch domain.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$WarmCount' => '<p>The number of UltraWarm instances.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$DedicatedMasterCount' => '<p>The number of instances to use for the master node. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>', 'AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails$AvailabilityZoneCount' => '<p>The number of Availability Zones that the domain uses. Valid values are <code>2</code> or <code>3</code>. The default is <code>2</code>.</p>', 'AwsRdsDbClusterDetails$AllocatedStorage' => '<p>For all database engines except Aurora, specifies the allocated storage size in gibibytes (GiB).</p>', 'AwsRdsDbClusterDetails$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained.</p>', 'AwsRdsDbClusterDetails$Port' => '<p>The port number on which the DB instances in the DB cluster accept connections.</p>', 'AwsRdsDbClusterMember$PromotionTier' => '<p>Specifies the order in which an Aurora replica is promoted to the primary instance when the existing primary instance fails.</p>', 'AwsRdsDbClusterSnapshotDetails$AllocatedStorage' => '<p>Specifies the allocated storage size in gibibytes (GiB).</p>', 'AwsRdsDbClusterSnapshotDetails$Port' => '<p>The port number on which the DB instances in the DB cluster accept connections.</p>', 'AwsRdsDbClusterSnapshotDetails$PercentProgress' => '<p>Specifies the percentage of the estimated data that has been transferred.</p>', 'AwsRdsDbInstanceDetails$DbInstancePort' => '<p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>', 'AwsRdsDbInstanceDetails$AllocatedStorage' => '<p>The amount of storage (in gigabytes) to initially allocate for the DB instance.</p>', 'AwsRdsDbInstanceDetails$BackupRetentionPeriod' => '<p>The number of days for which to retain automated backups.</p>', 'AwsRdsDbInstanceDetails$Iops' => '<p>Specifies the provisioned IOPS (I/O operations per second) for this DB instance.</p>', 'AwsRdsDbInstanceDetails$MonitoringInterval' => '<p>The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB instance.</p>', 'AwsRdsDbInstanceDetails$PromotionTier' => '<p>The order in which to promote an Aurora replica to the primary instance after a failure of the existing primary instance.</p>', 'AwsRdsDbInstanceDetails$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p>', 'AwsRdsDbInstanceDetails$MaxAllocatedStorage' => '<p>The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.</p>', 'AwsRdsDbInstanceEndpoint$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'AwsRdsDbPendingModifiedValues$AllocatedStorage' => '<p>The new value of the allocated storage for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$Port' => '<p>The new port for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$BackupRetentionPeriod' => '<p>The new backup retention period for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$Iops' => '<p>The new provisioned IOPS value for the DB instance.</p>', 'AwsRdsDbSnapshotDetails$AllocatedStorage' => '<p>The amount of storage (in gigabytes) to be initially allocated for the database instance.</p>', 'AwsRdsDbSnapshotDetails$Port' => '<p>The port that the database engine was listening on at the time of the snapshot.</p>', 'AwsRdsDbSnapshotDetails$Iops' => '<p>The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>', 'AwsRdsDbSnapshotDetails$PercentProgress' => '<p>The percentage of the estimated data that has been transferred.</p>', 'AwsRedshiftClusterClusterSnapshotCopyStatus$ManualSnapshotRetentionPeriod' => '<p>The number of days that manual snapshots are retained in the destination Region after they are copied from a source Region.</p> <p>If the value is <code>-1</code>, then the manual snapshot is retained indefinitely.</p> <p>Valid values: Either <code>-1</code> or an integer between 1 and 3,653</p>', 'AwsRedshiftClusterClusterSnapshotCopyStatus$RetentionPeriod' => '<p>The number of days to retain automated snapshots in the destination Region after they are copied from a source Region.</p>', 'AwsRedshiftClusterDetails$AutomatedSnapshotRetentionPeriod' => '<p>The number of days that automatic cluster snapshots are retained.</p>', 'AwsRedshiftClusterDetails$ManualSnapshotRetentionPeriod' => '<p>The default number of days to retain a manual snapshot.</p> <p>If the value is <code>-1</code>, the snapshot is retained indefinitely.</p> <p>This setting doesn\'t change the retention period of existing snapshots.</p> <p>Valid values: Either <code>-1</code> or an integer between 1 and 3,653</p>', 'AwsRedshiftClusterDetails$NumberOfNodes' => '<p>The number of compute nodes in the cluster.</p>', 'AwsRedshiftClusterEndpoint$Port' => '<p>The port that the database engine listens on.</p>', 'AwsRedshiftClusterPendingModifiedValues$AutomatedSnapshotRetentionPeriod' => '<p>The pending or in-progress change to the automated snapshot retention period.</p>', 'AwsRedshiftClusterPendingModifiedValues$NumberOfNodes' => '<p>The pending or in-progress change to the number of nodes in the cluster.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails$DaysAfterInitiation' => '<p>The number of days after which Amazon S3 cancels an incomplete multipart upload.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$ExpirationInDays' => '<p>The length in days of the lifetime for objects that are subject to the rule.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$NoncurrentVersionExpirationInDays' => '<p>The number of days that an object is noncurrent before Amazon S3 can perform the associated action.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails$Days' => '<p>The number of days that an object is noncurrent before Amazon S3 can perform the associated action.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails$Days' => '<p>The number of days after which to transition the object to the specified storage class. If you provide <code>Days</code>, you cannot provide <code>Date</code>.</p>', 'AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails$Days' => '<p> The number of days that you want to specify for the default retention period. </p>', 'AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails$Years' => '<p> The number of years that you want to specify for the default retention period. </p>', 'AwsSageMakerNotebookInstanceDetails$VolumeSizeInGB' => '<p> The size, in GB, of the ML storage volume to attach to the notebook instance. </p>', 'AwsSecretsManagerSecretRotationRules$AutomaticallyAfterDays' => '<p>The number of days after the previous rotation to rotate the secret.</p>', 'AwsSecurityFinding$Confidence' => '<p>A finding\'s confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'AwsSecurityFinding$Criticality' => '<p>The level of importance assigned to the resources associated with the finding.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.</p>', 'AwsSqsQueueDetails$KmsDataKeyReusePeriodSeconds' => '<p>The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling KMS again.</p>', 'AwsSsmComplianceSummary$CompliantCriticalCount' => '<p>For the patches that are compliant, the number that have a severity of <code>CRITICAL</code>.</p>', 'AwsSsmComplianceSummary$CompliantHighCount' => '<p>For the patches that are compliant, the number that have a severity of <code>HIGH</code>.</p>', 'AwsSsmComplianceSummary$CompliantMediumCount' => '<p>For the patches that are compliant, the number that have a severity of <code>MEDIUM</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantCriticalCount' => '<p>For the patch items that are noncompliant, the number of items that have a severity of <code>CRITICAL</code>.</p>', 'AwsSsmComplianceSummary$CompliantInformationalCount' => '<p>For the patches that are compliant, the number that have a severity of <code>INFORMATIONAL</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantInformationalCount' => '<p>For the patches that are noncompliant, the number that have a severity of <code>INFORMATIONAL</code>.</p>', 'AwsSsmComplianceSummary$CompliantUnspecifiedCount' => '<p>For the patches that are compliant, the number that have a severity of <code>UNSPECIFIED</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantLowCount' => '<p>For the patches that are noncompliant, the number that have a severity of <code>LOW</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantHighCount' => '<p>For the patches that are noncompliant, the number that have a severity of <code>HIGH</code>.</p>', 'AwsSsmComplianceSummary$CompliantLowCount' => '<p>For the patches that are compliant, the number that have a severity of <code>LOW</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantMediumCount' => '<p>For the patches that are noncompliant, the number that have a severity of <code>MEDIUM</code>.</p>', 'AwsSsmComplianceSummary$NonCompliantUnspecifiedCount' => '<p>For the patches that are noncompliant, the number that have a severity of <code>UNSPECIFIED</code>.</p>', 'AwsWafRegionalRuleGroupRulesDetails$Priority' => '<p>If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order based on the value of <code>Priority</code>. </p>', 'AwsWafRegionalWebAclRulesListDetails$Priority' => '<p>The order in which WAF evaluates the rules in a web ACL. </p>', 'AwsWafRuleGroupRulesDetails$Priority' => '<p>If you define more than one rule in a web ACL, WAF evaluates each request against the rules in order based on the value of <code>Priority</code>.</p>', 'AwsWafWebAclRule$Priority' => '<p>Specifies the order in which the rules in a web ACL are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique integer. If you add multiple rules to a web ACL, the values do not need to be consecutive.</p>', 'AwsWafv2CustomResponseDetails$ResponseCode' => '<p> The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported status codes for custom response</a> in the <i>WAF Developer Guide.</i> </p>', 'AwsWafv2RulesDetails$Priority' => '<p> If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based on the value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities don\'t need to be consecutive, but they must all be different. </p>', 'BatchImportFindingsResponse$FailedCount' => '<p>The number of findings that failed to import.</p>', 'BatchImportFindingsResponse$SuccessCount' => '<p>The number of findings that were successfully imported.</p>', 'CodeVulnerabilitiesFilePath$EndLine' => '<p> The line number of the last line of code in which the vulnerability is located. </p>', 'CodeVulnerabilitiesFilePath$StartLine' => '<p> The line number of the first line of code in which the vulnerability is located. </p>', 'DateRange$Value' => '<p>A date range value for the date filter.</p>', 'EnumListConfigurationOptions$MaxItems' => '<p> The maximum number of list items that an enum list control parameter can accept. </p>', 'FirewallPolicyStatelessRuleGroupReferencesDetails$Priority' => '<p>The order in which to run the stateless rule group.</p>', 'GetInvitationsCountResponse$InvitationsCount' => '<p>The number of all membership invitations sent to this Security Hub member account, not including the currently accepted invitation.</p>', 'IcmpTypeCode$Code' => '<p>The ICMP code for which to deny or allow access. To deny or allow all codes, use the value <code>-1</code>.</p>', 'IcmpTypeCode$Type' => '<p>The ICMP type for which to deny or allow access. To deny or allow all types, use the value <code>-1</code>.</p>', 'InsightResultValue$Count' => '<p>The number of findings returned for each <code>GroupByAttributeValue</code>.</p>', 'IntegerConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is an integer. </p>', 'IntegerConfigurationOptions$Min' => '<p> The minimum valid value for a control parameter that is an integer. </p>', 'IntegerConfigurationOptions$Max' => '<p> The maximum valid value for a control parameter that is an integer. </p>', 'IntegerList$member' => NULL, 'IntegerListConfigurationOptions$Min' => '<p> The minimum valid value for a control parameter that is a list of integers. </p>', 'IntegerListConfigurationOptions$Max' => '<p> The maximum valid value for a control parameter that is a list of integers. </p>', 'IntegerListConfigurationOptions$MaxItems' => '<p> The maximum number of list items that an interger list control parameter can accept. </p>', 'IpOrganizationDetails$Asn' => '<p>The Autonomous System Number (ASN) of the internet provider</p>', 'Network$SourcePort' => '<p>The source port of network-related information about a finding.</p>', 'Network$DestinationPort' => '<p>The destination port of network-related information about a finding.</p>', 'ParameterValue$Integer' => '<p> A control parameter that is an integer. </p>', 'PatchSummary$InstalledCount' => '<p>The number of patches from the compliance standard that were installed successfully.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PatchSummary$MissingCount' => '<p>The number of patches that are part of the compliance standard but are not installed. The count includes patches that failed to install.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PatchSummary$FailedCount' => '<p>The number of patches from the compliance standard that failed to install.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PatchSummary$InstalledOtherCount' => '<p>The number of installed patches that are not part of the compliance standard.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PatchSummary$InstalledRejectedCount' => '<p>The number of patches that are installed but are also on a list of patches that the customer rejected.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PatchSummary$InstalledPendingReboot' => '<p>The number of patches that were applied, but that require the instance to be rebooted in order to be marked as installed.</p> <p>The value can be an integer from <code>0</code> to <code>100000</code>.</p>', 'PortRange$Begin' => '<p>The first port in the port range.</p>', 'PortRange$End' => '<p>The last port in the port range.</p>', 'PortRangeFromTo$From' => '<p>The first port in the port range.</p>', 'PortRangeFromTo$To' => '<p>The last port in the port range.</p>', 'ProcessDetails$Pid' => '<p>The process ID.</p>', 'ProcessDetails$ParentPid' => '<p>The parent process ID. This field accepts positive integers between <code>O</code> and <code>2147483647</code>.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts$FromPort' => '<p>The starting port value for the port range.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts$ToPort' => '<p>The ending port value for the port range.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesProtocolsList$member' => NULL, 'RuleGroupSourceStatelessRuleMatchAttributesSourcePorts$FromPort' => '<p>The starting port value for the port range.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesSourcePorts$ToPort' => '<p>The ending port value for the port range.</p>', 'RuleGroupSourceStatelessRulesDetails$Priority' => '<p>Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.</p>', 'Severity$Normalized' => '<p>Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code>, provide <code>Label</code>.</p> <p>The value of <code>Normalized</code> can be an integer between <code>0</code> and <code>100</code>.</p> <p>If you provide <code>Label</code> and do not provide <code>Normalized</code>, then <code>Normalized</code> is set automatically as follows.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - 0</p> </li> <li> <p> <code>LOW</code> - 1</p> </li> <li> <p> <code>MEDIUM</code> - 40</p> </li> <li> <p> <code>HIGH</code> - 70</p> </li> <li> <p> <code>CRITICAL</code> - 90</p> </li> </ul>', 'StringListConfigurationOptions$MaxItems' => '<p> The maximum number of list items that a string list control parameter can accept. </p>', 'Threat$ItemCount' => '<p>This total number of items in which the threat has been detected. </p>', 'UnprocessedAutomationRule$ErrorCode' => '<p> The error code associated with the unprocessed automation rule. </p>', ], ], 'IntegerConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is an integer. </p>', 'refs' => [ 'ConfigurationOptions$Integer' => '<p> The options for customizing a security control parameter that is an integer. </p>', ], ], 'IntegerList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase1DhGroupNumbers' => '<p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase2DhGroupNumbers' => '<p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.</p>', 'IntegerListConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is a list of integers. </p>', 'ParameterValue$IntegerList' => '<p> A control parameter that is a list of integers. </p>', ], ], 'IntegerListConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is a list of integers. </p>', 'refs' => [ 'ConfigurationOptions$IntegerList' => '<p> The options for customizing a security control parameter that is a list of integers. </p>', ], ], 'IntegrationType' => [ 'base' => NULL, 'refs' => [ 'IntegrationTypeList$member' => NULL, ], ], 'IntegrationTypeList' => [ 'base' => NULL, 'refs' => [ 'Product$IntegrationTypes' => '<p>The types of integration that the product supports. Available values are the following.</p> <ul> <li> <p> <code>SEND_FINDINGS_TO_SECURITY_HUB</code> - The integration sends findings to Security Hub.</p> </li> <li> <p> <code>RECEIVE_FINDINGS_FROM_SECURITY_HUB</code> - The integration receives findings from Security Hub.</p> </li> <li> <p> <code>UPDATE_FINDINGS_IN_SECURITY_HUB</code> - The integration does not send new findings to Security Hub, but does make updates to the findings that it receives from Security Hub.</p> </li> </ul>', ], ], 'InternalException' => [ 'base' => '<p>Internal server error.</p>', 'refs' => [], ], 'InvalidAccessException' => [ 'base' => '<p>The account doesn\'t have permission to perform this action.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The request was rejected because you supplied an invalid or out-of-range value for an input parameter.</p>', 'refs' => [], ], 'Invitation' => [ 'base' => '<p>Details about an invitation.</p>', 'refs' => [ 'GetAdministratorAccountResponse$Administrator' => NULL, 'GetMasterAccountResponse$Master' => '<p>A list of details about the Security Hub administrator account for the current member account. </p>', 'InvitationList$member' => NULL, ], ], 'InvitationList' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsResponse$Invitations' => '<p>The details of the invitations returned by the operation.</p>', ], ], 'InviteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'IpFilter' => [ 'base' => '<p>The IP filter for querying findings.</p>', 'refs' => [ 'IpFilterList$member' => NULL, ], ], 'IpFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$NetworkSourceIpV4' => '<p>The source IPv4 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceIpV6' => '<p>The source IPv6 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationIpV4' => '<p>The destination IPv4 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationIpV6' => '<p>The destination IPv6 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIpV4Addresses' => '<p>The IPv4 addresses associated with the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIpV6Addresses' => '<p>The IPv6 addresses associated with the instance.</p>', ], ], 'IpOrganizationDetails' => [ 'base' => '<p>Provides information about an internet provider.</p>', 'refs' => [ 'ActionRemoteIpDetails$Organization' => '<p>The internet service provider (ISP) organization associated with the remote IP address.</p>', ], ], 'Ipv6CidrBlockAssociation' => [ 'base' => '<p>An IPV6 CIDR block association.</p>', 'refs' => [ 'Ipv6CidrBlockAssociationList$member' => NULL, ], ], 'Ipv6CidrBlockAssociationList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SubnetDetails$Ipv6CidrBlockAssociationSet' => '<p>The IPV6 CIDR blocks that are associated with the subnet.</p>', 'AwsEc2VpcDetails$Ipv6CidrBlockAssociationSet' => '<p>Information about the IPv6 CIDR blocks associated with the VPC.</p>', ], ], 'KeywordFilter' => [ 'base' => '<p>A keyword filter for querying findings.</p>', 'refs' => [ 'KeywordFilterList$member' => NULL, ], ], 'KeywordFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$Keyword' => '<p>A keyword for a finding.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services account or throttling limits. The error code describes the limit exceeded.</p>', 'refs' => [], ], 'ListAutomationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutomationRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationPolicyAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationPolicyAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEnabledProductsForImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnabledProductsForImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregatorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregatorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationAdminAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityControlDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityControlDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStandardsControlAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStandardsControlAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoadBalancerState' => [ 'base' => '<p>Information about the state of the load balancer.</p>', 'refs' => [ 'AwsElbv2LoadBalancerDetails$State' => '<p>The state of the load balancer.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails$AuthTtL' => '<p> The number of milliseconds that a token is valid after being authenticated. </p>', 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails$IatTtL' => '<p> The number of milliseconds that a token is valid after it\'s issued to a user. </p>', 'AwsBackupBackupPlanLifecycleDetails$DeleteAfterDays' => '<p>Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus <code>MoveToColdStorageAfterDays</code>. </p>', 'AwsBackupBackupPlanLifecycleDetails$MoveToColdStorageAfterDays' => '<p>Specifies the number of days after creation that a recovery point is moved to cold storage. </p>', 'AwsBackupBackupPlanRuleDetails$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. </p>', 'AwsBackupBackupPlanRuleDetails$CompletionWindowMinutes' => '<p>A value in minutes after a backup job is successfully started before it must be completed, or it is canceled by Backup. </p>', 'AwsBackupRecoveryPointDetails$BackupSizeInBytes' => '<p>The size, in bytes, of a backup. </p>', 'AwsBackupRecoveryPointLifecycleDetails$DeleteAfterDays' => '<p>Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus <code>MoveToColdStorageAfterDays</code>. </p>', 'AwsBackupRecoveryPointLifecycleDetails$MoveToColdStorageAfterDays' => '<p>Specifies the number of days after creation that a recovery point is moved to cold storage. </p>', 'AwsEc2LaunchTemplateDetails$DefaultVersionNumber' => '<p> The default version of the launch template. </p>', 'AwsEc2LaunchTemplateDetails$LatestVersionNumber' => '<p> The latest version of the launch template. </p>', 'AwsElbLbCookieStickinessPolicy$CookieExpirationPeriod' => '<p>The amount of time, in seconds, after which the cookie is considered stale. If an expiration period is not specified, the stickiness session lasts for the duration of the browser session.</p>', 'AwsRedshiftClusterRestoreStatus$ElapsedTimeInSeconds' => '<p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish.</p> <p>This field is only updated when you restore to DC2 and DS2 node types.</p>', 'AwsRedshiftClusterRestoreStatus$EstimatedTimeToCompletionInSeconds' => '<p>The estimate of the time remaining before the restore is complete. Returns 0 for a completed restore.</p> <p>This field is only updated when you restore to DC2 and DS2 node types.</p>', 'AwsRedshiftClusterRestoreStatus$ProgressInMegaBytes' => '<p>The number of megabytes that were transferred from snapshot storage.</p> <p>This field is only updated when you restore to DC2 and DS2 node types.</p>', 'AwsRedshiftClusterRestoreStatus$SnapshotSizeInMegaBytes' => '<p>The size of the set of snapshot data that was used to restore the cluster.</p> <p>This field is only updated when you restore to DC2 and DS2 node types.</p>', 'AwsWafRateBasedRuleDetails$RateLimit' => '<p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>', 'AwsWafRegionalRateBasedRuleDetails$RateLimit' => '<p>The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action for the rule.</p>', 'AwsWafv2RuleGroupDetails$Capacity' => '<p> The web ACL capacity units (WCUs) required for this rule group. </p>', 'AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails$ImmunityTime' => '<p> The amount of time, in seconds, that a CAPTCHA or challenge timestamp is considered valid by WAF. </p>', 'AwsWafv2WebAclDetails$Capacity' => '<p> The web ACL capacity units (WCUs) currently being used by this web ACL. </p>', 'Cell$Column' => '<p>The column number of the column that contains the data. For a Microsoft Excel workbook, the column number corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to the A column in the workbook.</p>', 'Cell$Row' => '<p>The row number of the row that contains the data.</p>', 'ClassificationResult$SizeClassified' => '<p>The total size in bytes of the affected data.</p>', 'CustomDataIdentifiersDetections$Count' => '<p>The total number of occurrences of sensitive data that were detected.</p>', 'CustomDataIdentifiersResult$TotalCount' => '<p>The total number of occurrences of sensitive data.</p>', 'Page$PageNumber' => '<p>The page number of the page that contains the sensitive data.</p>', 'Range$Start' => '<p>The number of lines (for a line range) or characters (for an offset range) from the beginning of the file to the end of the sensitive data.</p>', 'Range$End' => '<p>The number of lines (for a line range) or characters (for an offset range) from the beginning of the file to the end of the sensitive data.</p>', 'Range$StartColumn' => '<p>In the line where the sensitive data starts, the column within the line where the sensitive data starts.</p>', 'Record$RecordIndex' => '<p>The record index, starting from 0, for the record that contains the data.</p>', 'SensitiveDataDetections$Count' => '<p>The total number of occurrences of sensitive data that were detected.</p>', 'SensitiveDataResult$TotalCount' => '<p>The total number of occurrences of sensitive data.</p>', ], ], 'Malware' => [ 'base' => '<p>A list of malware related to a finding.</p>', 'refs' => [ 'MalwareList$member' => NULL, ], ], 'MalwareList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Malware' => '<p>A list of malware related to a finding.</p> <p>Array Members: Maximum number of 5 items.</p>', ], ], 'MalwareState' => [ 'base' => NULL, 'refs' => [ 'Malware$State' => '<p>The state of the malware that was observed.</p>', ], ], 'MalwareType' => [ 'base' => NULL, 'refs' => [ 'Malware$Type' => '<p>The type of the malware that was observed.</p>', ], ], 'MapFilter' => [ 'base' => '<p>A map filter for filtering Security Hub findings. Each map filter provides the field to check for, the value to check for, and the comparison operator.</p>', 'refs' => [ 'MapFilterList$member' => NULL, ], ], 'MapFilterComparison' => [ 'base' => NULL, 'refs' => [ 'MapFilter$Comparison' => '<p>The condition to apply to the key value when filtering Security Hub findings with a map filter.</p> <p>To search for values that have the filter value, use one of the following comparison operators:</p> <ul> <li> <p>To search for values that include the filter value, use <code>CONTAINS</code>. For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</p> </li> <li> <p>To search for values that exactly match the filter value, use <code>EQUALS</code>. For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</p> </li> </ul> <p> <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code>. A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code>, <code>Finance</code>, or both values.</p> <p>To search for values that don\'t have the filter value, use one of the following comparison operators:</p> <ul> <li> <p>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code>. For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</p> </li> <li> <p>To search for values other than the filter value, use <code>NOT_EQUALS</code>. For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</p> </li> </ul> <p> <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code>. A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.</p> <p> <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.</p> <p>You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. </p> <p> <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <i>Security Hub User Guide</i>.</p>', ], ], 'MapFilterList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFilters$ResourceTags' => '<p> A list of Amazon Web Services tags associated with a resource at the time the finding was processed. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceDetailsOther' => '<p> Custom fields and values about the resource that a finding pertains to. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$UserDefinedFields' => '<p> A list of user-defined name and value string pairs added to a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AwsSecurityFindingFilters$ProductFields' => '<p>A data type where security findings providers can include additional solution-specific details that aren\'t part of the defined <code>AwsSecurityFinding</code> format.</p>', 'AwsSecurityFindingFilters$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. </p>', 'AwsSecurityFindingFilters$ResourceTags' => '<p>A list of Amazon Web Services tags associated with a resource at the time the finding was processed.</p>', 'AwsSecurityFindingFilters$ResourceDetailsOther' => '<p>The details of a resource that doesn\'t have a specific subfield for the resource type defined.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'DescribeProductsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'DescribeStandardsControlsRequest$MaxResults' => '<p>The maximum number of security standard controls to return.</p>', 'DescribeStandardsRequest$MaxResults' => '<p>The maximum number of standards to return.</p>', 'GetEnabledStandardsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'GetFindingHistoryRequest$MaxResults' => '<p> The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100 results of finding history. </p>', 'GetFindingsRequest$MaxResults' => '<p>The maximum number of findings to return.</p>', 'GetInsightsRequest$MaxResults' => '<p>The maximum number of items to return in the response.</p>', 'ListAutomationRulesRequest$MaxResults' => '<p> The maximum number of rules to return in the response. This currently ranges from 1 to 100. </p>', 'ListConfigurationPoliciesRequest$MaxResults' => '<p> The maximum number of results that\'s returned by <code>ListConfigurationPolicies</code> in each page of the response. When this parameter is used, <code>ListConfigurationPolicies</code> returns the specified number of results in a single page and a <code>NextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListConfigurationPolicies</code> request with the returned <code>NextToken</code> value. A valid range for <code>MaxResults</code> is between 1 and 100. </p>', 'ListConfigurationPolicyAssociationsRequest$MaxResults' => '<p> The maximum number of results that\'s returned by <code>ListConfigurationPolicies</code> in each page of the response. When this parameter is used, <code>ListConfigurationPolicyAssociations</code> returns the specified number of results in a single page and a <code>NextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListConfigurationPolicyAssociations</code> request with the returned <code>NextToken</code> value. A valid range for <code>MaxResults</code> is between 1 and 100. </p>', 'ListEnabledProductsForImportRequest$MaxResults' => '<p>The maximum number of items to return in the response.</p>', 'ListFindingAggregatorsRequest$MaxResults' => '<p>The maximum number of results to return. This operation currently only returns a single result.</p>', 'ListSecurityControlDefinitionsRequest$MaxResults' => '<p> An optional parameter that limits the total results of the API response to the specified number. If this parameter isn\'t provided in the request, the results include the first 25 security controls that apply to the specified standard. The results also include a <code>NextToken</code> parameter that you can use in a subsequent API call to get the next 25 controls. This repeats until all controls for the standard are returned. </p>', 'ListStandardsControlAssociationsRequest$MaxResults' => '<p> An optional parameter that limits the total results of the API response to the specified number. If this parameter isn\'t provided in the request, the results include the first 25 standard and control associations. The results also include a <code>NextToken</code> parameter that you can use in a subsequent API call to get the next 25 associations. This repeats until all associations for the specified control are returned. The number of results is limited by the number of supported Security Hub standards that you\'ve enabled in the calling account. </p>', ], ], 'Member' => [ 'base' => '<p>The details about a member account.</p>', 'refs' => [ 'MemberList$member' => NULL, ], ], 'MemberList' => [ 'base' => NULL, 'refs' => [ 'GetMembersResponse$Members' => '<p>The list of details about the Security Hub member accounts.</p>', 'ListMembersResponse$Members' => '<p>Member details returned by the operation.</p>', ], ], 'Network' => [ 'base' => '<p>The details of network-related information about a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Network' => '<p>The details of network-related information about a finding.</p>', ], ], 'NetworkConnectionAction' => [ 'base' => '<p>Provided if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. It provides details about the attempted network connection that was detected.</p>', 'refs' => [ 'Action$NetworkConnectionAction' => '<p>Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the network connection that was detected.</p>', ], ], 'NetworkDirection' => [ 'base' => NULL, 'refs' => [ 'Network$Direction' => '<p>The direction of network traffic associated with a finding.</p>', ], ], 'NetworkHeader' => [ 'base' => '<p>Details about a network path component that occurs before or after the current component.</p>', 'refs' => [ 'NetworkPathComponent$Egress' => '<p>Information about the component that comes after the current component in the network path.</p>', 'NetworkPathComponent$Ingress' => '<p>Information about the component that comes before the current node in the network path.</p>', ], ], 'NetworkPathComponent' => [ 'base' => '<p>Information about a network path component.</p>', 'refs' => [ 'NetworkPathList$member' => NULL, ], ], 'NetworkPathComponentDetails' => [ 'base' => '<p>Information about the destination of the next component in the network path.</p>', 'refs' => [ 'NetworkHeader$Destination' => '<p>Information about the destination of the component.</p>', 'NetworkHeader$Source' => '<p>Information about the origin of the component.</p>', ], ], 'NetworkPathList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$NetworkPath' => '<p>Provides information about a network path that is relevant to a finding. Each entry under <code>NetworkPath</code> represents a component of that path.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeActionTargets</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeActionTargetsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeProductsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeProducts</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeProductsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeStandardsControlsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeStandardsControls</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeStandardsControlsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeStandardsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeStandardsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'FindingHistoryRecord$NextToken' => '<p> A token for pagination purposes. Provide this token in the subsequent request to <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindingsHistory.html"> <code>GetFindingsHistory</code> </a> to get up to an additional 100 results of history for the same finding that you specified in your initial request. </p>', 'GetEnabledStandardsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetEnabledStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetEnabledStandardsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'GetFindingHistoryRequest$NextToken' => '<p> A token for pagination purposes. Provide <code>NULL</code> as the initial value. In subsequent requests, provide the token included in the response to get up to an additional 100 results of finding history. If you don’t provide <code>NextToken</code>, Security Hub returns up to 100 results of finding history for each request. </p>', 'GetFindingHistoryResponse$NextToken' => '<p> A token for pagination purposes. Provide this token in the subsequent request to <code>GetFindingsHistory</code> to get up to an additional 100 results of history for the same finding that you specified in your initial request. </p>', 'GetFindingsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetFindingsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'GetInsightsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetInsightsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListAutomationRulesRequest$NextToken' => '<p> A token to specify where to start paginating the response. This is the <code>NextToken</code> from a previously truncated response. On your first call to the <code>ListAutomationRules</code> API, set the value of this parameter to <code>NULL</code>. </p>', 'ListAutomationRulesResponse$NextToken' => '<p> A pagination token for the response. </p>', 'ListConfigurationPoliciesRequest$NextToken' => '<p> The NextToken value that\'s returned from a previous paginated <code>ListConfigurationPolicies</code> request where <code>MaxResults</code> was used but the results exceeded the value of that parameter. Pagination continues from the <code>MaxResults</code> was used but the results exceeded the value of that parameter. Pagination continues from the end of the previous response that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return. </p>', 'ListConfigurationPoliciesResponse$NextToken' => '<p> The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicies</code> request. When the results of a <code>ListConfigurationPolicies</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListConfigurationPolicyAssociationsRequest$NextToken' => '<p> The <code>NextToken</code> value that\'s returned from a previous paginated <code>ListConfigurationPolicyAssociations</code> request where <code>MaxResults</code> was used but the results exceeded the value of that parameter. Pagination continues from the end of the previous response that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return. </p>', 'ListConfigurationPolicyAssociationsResponse$NextToken' => '<p> The <code>NextToken</code> value to include in the next <code>ListConfigurationPolicyAssociations</code> request. When the results of a <code>ListConfigurationPolicyAssociations</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListEnabledProductsForImportRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'ListEnabledProductsForImportResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListFindingAggregatorsRequest$NextToken' => '<p>The token returned with the previous set of results. Identifies the next set of results to return.</p>', 'ListFindingAggregatorsResponse$NextToken' => '<p>If there are more results, this is the token to provide in the next call to <code>ListFindingAggregators</code>.</p> <p>This operation currently only returns a single result. </p>', 'ListInvitationsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListInvitations</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'ListMembersRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'ListOrganizationAdminAccountsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListOrganizationAdminAccounts</code> operation, set the value of this parameter to <code>NULL</code>. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. </p>', 'ListOrganizationAdminAccountsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListSecurityControlDefinitionsRequest$NextToken' => '<p> Optional pagination parameter. </p>', 'ListSecurityControlDefinitionsResponse$NextToken' => '<p> A pagination parameter that\'s included in the response only if it was included in the request. </p>', 'ListStandardsControlAssociationsRequest$NextToken' => '<p> Optional pagination parameter. </p>', 'ListStandardsControlAssociationsResponse$NextToken' => '<p> A pagination parameter that\'s included in the response only if it was included in the request. </p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AcceptAdministratorInvitationRequest$AdministratorId' => '<p>The account ID of the Security Hub administrator account that sent the invitation.</p>', 'AcceptAdministratorInvitationRequest$InvitationId' => '<p>The identifier of the invitation sent from the Security Hub administrator account.</p>', 'AcceptInvitationRequest$MasterId' => '<p>The account ID of the Security Hub administrator account that sent the invitation.</p>', 'AcceptInvitationRequest$InvitationId' => '<p>The identifier of the invitation sent from the Security Hub administrator account.</p>', 'AccessDeniedException$Message' => NULL, 'AccessDeniedException$Code' => NULL, 'AccountDetails$Email' => '<p>The email of an Amazon Web Services account.</p>', 'AccountIdList$member' => NULL, 'Action$ActionType' => '<p>The type of action that was detected. The possible action types are:</p> <ul> <li> <p> <code>NETWORK_CONNECTION</code> </p> </li> <li> <p> <code>AWS_API_CALL</code> </p> </li> <li> <p> <code>DNS_REQUEST</code> </p> </li> <li> <p> <code>PORT_PROBE</code> </p> </li> </ul>', 'ActionLocalIpDetails$IpAddressV4' => '<p>The IP address.</p>', 'ActionLocalPortDetails$PortName' => '<p>The port name of the local connection.</p> <p>Length Constraints: 128.</p>', 'ActionRemoteIpDetails$IpAddressV4' => '<p>The IP address.</p>', 'ActionRemotePortDetails$PortName' => '<p>The port name of the remote connection.</p> <p>Length Constraints: 128.</p>', 'ActionTarget$ActionTargetArn' => '<p>The ARN for the target action.</p>', 'ActionTarget$Name' => '<p>The name of the action target.</p>', 'ActionTarget$Description' => '<p>The description of the target action.</p>', 'Adjustment$Metric' => '<p>The metric to adjust.</p>', 'Adjustment$Reason' => '<p>The reason for the adjustment.</p>', 'AdminAccount$AccountId' => '<p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>', 'ArnList$member' => NULL, 'AssociatedStandard$StandardsId' => '<p>The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response. </p>', 'AssociationFilters$ConfigurationPolicyId' => '<p> The ARN or UUID of the configuration policy. </p>', 'AssociationSetDetails$GatewayId' => '<p> The ID of the internet gateway or virtual private gateway. </p>', 'AssociationSetDetails$RouteTableAssociationId' => '<p> The ID of the association. </p>', 'AssociationSetDetails$RouteTableId' => '<p> The ID of the route table. </p>', 'AssociationSetDetails$SubnetId' => '<p> The ID of the subnet. A subnet ID is not returned for an implicit association. </p>', 'AssociationStateDetails$State' => '<p> The state of the association. </p>', 'AssociationStateDetails$StatusMessage' => '<p> The status message, if applicable. </p>', 'AutomationRulesArnsList$member' => NULL, 'AutomationRulesConfig$RuleArn' => '<p> The Amazon Resource Name (ARN) of a rule. </p>', 'AutomationRulesConfig$RuleName' => '<p> The name of the rule. </p>', 'AutomationRulesConfig$Description' => '<p> A description of the rule. </p>', 'AutomationRulesConfig$CreatedBy' => '<p> The principal that created a rule. </p>', 'AutomationRulesMetadata$RuleArn' => '<p> The Amazon Resource Name (ARN) for the rule. </p>', 'AutomationRulesMetadata$RuleName' => '<p> The name of the rule. </p>', 'AutomationRulesMetadata$Description' => '<p> A description of the rule. </p>', 'AutomationRulesMetadata$CreatedBy' => '<p> The principal that created a rule. </p>', 'AvailabilityZone$ZoneName' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZone$SubnetId' => '<p>The ID of the subnet. You can specify one subnet per Availability Zone.</p>', 'AwsAmazonMqBrokerDetails$AuthenticationStrategy' => '<p> The authentication strategy used to secure the broker. The default is <code>SIMPLE</code>. </p>', 'AwsAmazonMqBrokerDetails$BrokerArn' => '<p> The Amazon Resource Name (ARN) of the broker. </p>', 'AwsAmazonMqBrokerDetails$BrokerName' => '<p>The broker\'s name. </p>', 'AwsAmazonMqBrokerDetails$DeploymentMode' => '<p> The broker\'s deployment mode. </p>', 'AwsAmazonMqBrokerDetails$EngineType' => '<p> The type of broker engine. </p>', 'AwsAmazonMqBrokerDetails$EngineVersion' => '<p> The version of the broker engine. </p>', 'AwsAmazonMqBrokerDetails$HostInstanceType' => '<p> The broker\'s instance type. </p>', 'AwsAmazonMqBrokerDetails$BrokerId' => '<p> The unique ID that Amazon MQ generates for the broker. </p>', 'AwsAmazonMqBrokerDetails$StorageType' => '<p> The broker\'s storage type. </p>', 'AwsAmazonMqBrokerEncryptionOptionsDetails$KmsKeyId' => '<p> The KMS key that’s used to encrypt your data at rest. If not provided, Amazon MQ will use a default KMS key to encrypt your data. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$RoleBase' => '<p> The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$RoleName' => '<p> The group name attribute in a role entry whose value is the name of that role. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$RoleSearchMatching' => '<p> The LDAP search filter used to find roles within the <code>roleBase</code>. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$ServiceAccountUsername' => '<p> A username for the service account, which is an account in your LDAP server that has access to initiate a connection. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$UserBase' => '<p> Selects a particular subtree of the directory information tree (DIT) to search for user entries. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$UserRoleName' => '<p> The name of the LDAP attribute in the user\'s directory entry for the user\'s group membership. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$UserSearchMatching' => '<p> The LDAP search filter used to find users within the <code>userBase</code>. </p>', 'AwsAmazonMqBrokerLogsDetails$AuditLogGroup' => '<p> The location of the CloudWatch Logs log group where audit logs are sent. </p>', 'AwsAmazonMqBrokerLogsDetails$GeneralLogGroup' => '<p> The location of the CloudWatch Logs log group where general logs are sent. </p>', 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails$DayOfWeek' => '<p> The day of the week on which the maintenance window falls. </p>', 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails$TimeOfDay' => '<p> The time, in 24-hour format, on which the maintenance window falls. </p>', 'AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails$TimeZone' => '<p> The time zone in either the Country/City format or the UTC offset format. UTC is the default format. </p>', 'AwsAmazonMqBrokerUsersDetails$PendingChange' => '<p> The type of change pending for the broker user. </p>', 'AwsAmazonMqBrokerUsersDetails$Username' => '<p> The username of the broker user. </p>', 'AwsApiCallAction$Api' => '<p>The name of the API method that was issued.</p> <p>Length Constraints: 128.</p>', 'AwsApiCallAction$ServiceName' => '<p>The name of the Amazon Web Services service that the API method belongs to.</p> <p>Length Constraints: 128.</p>', 'AwsApiCallAction$CallerType' => '<p>Indicates whether the API call originated from a remote IP address (<code>remoteip</code>) or from a DNS domain (<code>domain</code>).</p>', 'AwsApiCallAction$FirstSeen' => '<p>A timestamp that indicates when the API call was first observed.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiCallAction$LastSeen' => '<p>A timestamp that indicates when the API call was most recently observed.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiCallActionDomainDetails$Domain' => '<p>The name of the DNS domain that issued the API call.</p> <p>Length Constraints: 128.</p>', 'AwsApiGatewayAccessLogSettings$Format' => '<p>A single-line format of the access logs of data, as specified by selected <code>$context</code> variables. The format must include at least <code>$context.requestId</code>.</p>', 'AwsApiGatewayAccessLogSettings$DestinationArn' => '<p>The ARN of the CloudWatch Logs log group that receives the access logs.</p>', 'AwsApiGatewayCanarySettings$DeploymentId' => '<p>The deployment identifier for the canary deployment.</p>', 'AwsApiGatewayMethodSettings$LoggingLevel' => '<p>The logging level for this method. The logging level affects the log entries that are pushed to CloudWatch Logs.</p> <p>If the logging level is <code>ERROR</code>, then the logs only include error-level entries.</p> <p>If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra informational events.</p> <p>Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code> </p>', 'AwsApiGatewayMethodSettings$UnauthorizedCacheControlHeaderStrategy' => '<p>Indicates how to handle unauthorized requests for cache invalidation.</p> <p>Valid values: <code>FAIL_WITH_403</code> | <code>SUCCEED_WITH_RESPONSE_HEADER</code> | <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code> </p>', 'AwsApiGatewayMethodSettings$HttpMethod' => '<p>The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.</p>', 'AwsApiGatewayMethodSettings$ResourcePath' => '<p>The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include a forward slash.</p> <p>For example, the path value <code>/resource/subresource</code> must be encoded as <code>/~1resource~1subresource</code>.</p> <p>To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.</p>', 'AwsApiGatewayRestApiDetails$Id' => '<p>The identifier of the REST API.</p>', 'AwsApiGatewayRestApiDetails$Name' => '<p>The name of the REST API.</p>', 'AwsApiGatewayRestApiDetails$Description' => '<p>A description of the REST API.</p>', 'AwsApiGatewayRestApiDetails$CreatedDate' => '<p>Indicates when the API was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayRestApiDetails$Version' => '<p>The version identifier for the REST API.</p>', 'AwsApiGatewayRestApiDetails$ApiKeySource' => '<p>The source of the API key for metering requests according to a usage plan.</p> <p> <code>HEADER</code> indicates whether to read the API key from the X-API-Key header of a request.</p> <p> <code>AUTHORIZER</code> indicates whether to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</p>', 'AwsApiGatewayStageDetails$DeploymentId' => '<p>The identifier of the deployment that the stage points to.</p>', 'AwsApiGatewayStageDetails$ClientCertificateId' => '<p>The identifier of the client certificate for the stage.</p>', 'AwsApiGatewayStageDetails$StageName' => '<p>The name of the stage.</p>', 'AwsApiGatewayStageDetails$Description' => '<p>A description of the stage.</p>', 'AwsApiGatewayStageDetails$CacheClusterSize' => '<p>If a cache cluster is enabled, the size of the cache cluster.</p>', 'AwsApiGatewayStageDetails$CacheClusterStatus' => '<p>If a cache cluster is enabled, the status of the cache cluster.</p>', 'AwsApiGatewayStageDetails$DocumentationVersion' => '<p>The version of the API documentation that is associated with the stage.</p>', 'AwsApiGatewayStageDetails$CreatedDate' => '<p>Indicates when the stage was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayStageDetails$LastUpdatedDate' => '<p>Indicates when the stage was most recently updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayStageDetails$WebAclArn' => '<p>The ARN of the web ACL associated with the stage.</p>', 'AwsApiGatewayV2ApiDetails$ApiEndpoint' => '<p>The URI of the API. </p> <p>Uses the format <code> <i>&lt;api-id&gt;</i>.execute-api.<i>&lt;region&gt;</i>.amazonaws.com</code> </p> <p>The stage name is typically appended to the URI to form a complete path to a deployed API stage.</p>', 'AwsApiGatewayV2ApiDetails$ApiId' => '<p>The identifier of the API.</p>', 'AwsApiGatewayV2ApiDetails$ApiKeySelectionExpression' => '<p>An API key selection expression. Supported only for WebSocket APIs. </p>', 'AwsApiGatewayV2ApiDetails$CreatedDate' => '<p>Indicates when the API was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayV2ApiDetails$Description' => '<p>A description of the API.</p>', 'AwsApiGatewayV2ApiDetails$Version' => '<p>The version identifier for the API.</p>', 'AwsApiGatewayV2ApiDetails$Name' => '<p>The name of the API.</p>', 'AwsApiGatewayV2ApiDetails$ProtocolType' => '<p>The API protocol for the API.</p> <p>Valid values: <code>WEBSOCKET</code> | <code>HTTP</code> </p>', 'AwsApiGatewayV2ApiDetails$RouteSelectionExpression' => '<p>The route selection expression for the API.</p> <p>For HTTP APIs, must be <code>${request.method} ${request.path}</code>. This is the default value for HTTP APIs.</p> <p>For WebSocket APIs, there is no default value.</p>', 'AwsApiGatewayV2RouteSettings$LoggingLevel' => '<p>The logging level. The logging level affects the log entries that are pushed to CloudWatch Logs. Supported only for WebSocket APIs.</p> <p>If the logging level is <code>ERROR</code>, then the logs only include error-level entries.</p> <p>If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra informational events.</p> <p>Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code> </p>', 'AwsApiGatewayV2StageDetails$ClientCertificateId' => '<p>The identifier of a client certificate for a stage. Supported only for WebSocket API calls.</p>', 'AwsApiGatewayV2StageDetails$CreatedDate' => '<p>Indicates when the stage was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayV2StageDetails$Description' => '<p>The description of the stage.</p>', 'AwsApiGatewayV2StageDetails$DeploymentId' => '<p>The identifier of the deployment that the stage is associated with. </p>', 'AwsApiGatewayV2StageDetails$LastUpdatedDate' => '<p>Indicates when the stage was most recently updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsApiGatewayV2StageDetails$StageName' => '<p>The name of the stage.</p>', 'AwsApiGatewayV2StageDetails$LastDeploymentStatusMessage' => '<p>The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.</p>', 'AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails$AuthenticationType' => '<p> The type of security configuration for your GraphQL API: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda. </p>', 'AwsAppSyncGraphQlApiDetails$ApiId' => '<p> The unique identifier for the API. </p>', 'AwsAppSyncGraphQlApiDetails$Id' => '<p>The unique identifier for the API.</p>', 'AwsAppSyncGraphQlApiDetails$Name' => '<p> The API name. </p>', 'AwsAppSyncGraphQlApiDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the API. </p>', 'AwsAppSyncGraphQlApiDetails$AuthenticationType' => '<p> The type of security configuration for your GraphQL API: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda. </p>', 'AwsAppSyncGraphQlApiDetails$WafWebAclArn' => '<p> The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this GraphQL API, if one exists. </p>', 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails$AuthorizerUri' => '<p> The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard Lambda ARN, a version ARN (.../v3), or an alias ARN. </p>', 'AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails$IdentityValidationExpression' => '<p> A regular expression for validation of tokens before the Lambda function is called. </p>', 'AwsAppSyncGraphQlApiLogConfigDetails$CloudWatchLogsRoleArn' => '<p> The Amazon Resource Name (ARN) of the service role that AppSync assumes to publish to CloudWatch Logs in your account. </p>', 'AwsAppSyncGraphQlApiLogConfigDetails$FieldLogLevel' => '<p> The field logging level. </p>', 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails$ClientId' => '<p> The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AppSync can validate against multiple client identifiers at a time. </p>', 'AwsAppSyncGraphQlApiOpenIdConnectConfigDetails$Issuer' => '<p> The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token. </p>', 'AwsAppSyncGraphQlApiUserPoolConfigDetails$AppIdClientRegex' => '<p> A regular expression for validating the incoming Amazon Cognito user pools app client ID. If this value isn\'t set, no filtering is applied. </p>', 'AwsAppSyncGraphQlApiUserPoolConfigDetails$AwsRegion' => '<p> The Amazon Web Services Region in which the user pool was created. </p>', 'AwsAppSyncGraphQlApiUserPoolConfigDetails$DefaultAction' => '<p> The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pools authentication doesn\'t match the Amazon Cognito user pools configuration. </p>', 'AwsAppSyncGraphQlApiUserPoolConfigDetails$UserPoolId' => '<p> The user pool ID. </p>', 'AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails$EncryptionOption' => '<p> Indicates whether Amazon Simple Storage Service (Amazon S3) server-side encryption with Amazon S3 managed keys (SSE_S3), server-side encryption with KMS keys (SSE_KMS), or client-side encryption with KMS customer managed keys (CSE_KMS) is used. </p>', 'AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails$KmsKey' => '<p> For <code>SSE_KMS</code> and <code>CSE_KMS</code>, this is the KMS key Amazon Resource Name (ARN) or ID. </p>', 'AwsAthenaWorkGroupDetails$Name' => '<p> The workgroup name. </p>', 'AwsAthenaWorkGroupDetails$Description' => '<p> The workgroup description. </p>', 'AwsAthenaWorkGroupDetails$State' => '<p> Whether the workgroup is enabled or disabled. </p>', 'AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails$Value' => '<p>The name of the Availability Zone.</p>', 'AwsAutoScalingAutoScalingGroupDetails$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'AwsAutoScalingAutoScalingGroupDetails$HealthCheckType' => '<p>The service to use for the health checks. Valid values are <code>EC2</code> or <code>ELB</code>.</p>', 'AwsAutoScalingAutoScalingGroupDetails$CreatedTime' => '<p>Indicates when the auto scaling group was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification$LaunchTemplateId' => '<p>The identifier of the launch template. You must specify either <code>LaunchTemplateId</code> or <code>LaunchTemplateName</code>.</p>', 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification$LaunchTemplateName' => '<p>The name of the launch template. You must specify either <code>LaunchTemplateId</code> or <code>LaunchTemplateName</code>.</p>', 'AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification$Version' => '<p>Identifies the version of the launch template. You can specify a version identifier, or use the values <code>$Latest</code> or <code>$Default</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$OnDemandAllocationStrategy' => '<p>How to allocate instance types to fulfill On-Demand capacity. The valid value is <code>prioritized</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$SpotAllocationStrategy' => '<p>How to allocate instances across Spot Instance pools. Valid values are as follows:</p> <ul> <li> <p> <code>lowest-price</code> </p> </li> <li> <p> <code>capacity-optimized</code> </p> </li> <li> <p> <code>capacity-optimized-prioritized</code> </p> </li> </ul>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails$SpotMaxPrice' => '<p>The maximum price per unit hour that you are willing to pay for a Spot Instance.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification$LaunchTemplateId' => '<p>The identifier of the launch template. You must specify either <code>LaunchTemplateId</code> or <code>LaunchTemplateName</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification$LaunchTemplateName' => '<p>The name of the launch template. You must specify either <code>LaunchTemplateId</code> or <code>LaunchTemplateName</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification$Version' => '<p>Identifies the version of the launch template. You can specify a version identifier, or use the values <code>$Latest</code> or <code>$Default</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails$InstanceType' => '<p>The instance type. For example, <code>m3.xlarge</code>.</p>', 'AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails$WeightedCapacity' => '<p>The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails$DeviceName' => '<p>The device name that is exposed to the EC2 instance. For example, <code>/dev/sdh</code> or <code>xvdh</code>.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails$VirtualName' => '<p>The name of the virtual device (for example, <code>ephemeral0</code>).</p> <p>You can provide either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$SnapshotId' => '<p>The snapshot ID of the volume to use.</p> <p>You must specify either <code>VolumeSize</code> or <code>SnapshotId</code>.</p>', 'AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails$VolumeType' => '<p>The volume type. Valid values are as follows:</p> <ul> <li> <p> <code>gp2</code> </p> </li> <li> <p> <code>gp3</code> </p> </li> <li> <p> <code>io1</code> </p> </li> <li> <p> <code>sc1</code> </p> </li> <li> <p> <code>st1</code> </p> </li> <li> <p> <code>standard</code> </p> </li> </ul>', 'AwsAutoScalingLaunchConfigurationDetails$ClassicLinkVpcId' => '<p>The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.</p>', 'AwsAutoScalingLaunchConfigurationDetails$CreatedTime' => '<p>The creation date and time for the launch configuration.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsAutoScalingLaunchConfigurationDetails$IamInstanceProfile' => '<p>The name or the ARN of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p>', 'AwsAutoScalingLaunchConfigurationDetails$ImageId' => '<p>The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.</p>', 'AwsAutoScalingLaunchConfigurationDetails$InstanceType' => '<p>The instance type for the instances.</p>', 'AwsAutoScalingLaunchConfigurationDetails$KernelId' => '<p>The identifier of the kernel associated with the AMI.</p>', 'AwsAutoScalingLaunchConfigurationDetails$KeyName' => '<p>The name of the key pair.</p>', 'AwsAutoScalingLaunchConfigurationDetails$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'AwsAutoScalingLaunchConfigurationDetails$PlacementTenancy' => '<p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p>', 'AwsAutoScalingLaunchConfigurationDetails$RamdiskId' => '<p>The identifier of the RAM disk associated with the AMI.</p>', 'AwsAutoScalingLaunchConfigurationDetails$SpotPrice' => '<p>The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.</p>', 'AwsAutoScalingLaunchConfigurationDetails$UserData' => '<p>The user data to make available to the launched EC2 instances. Must be base64-encoded text.</p>', 'AwsAutoScalingLaunchConfigurationMetadataOptions$HttpEndpoint' => '<p>Enables or disables the HTTP metadata endpoint on your instances. By default, the metadata endpoint is enabled.</p>', 'AwsAutoScalingLaunchConfigurationMetadataOptions$HttpTokens' => '<p>Indicates whether token usage is <code>required</code> or <code>optional</code> for metadata requests. By default, token usage is <code>optional</code>.</p>', 'AwsBackupBackupPlanAdvancedBackupSettingsDetails$ResourceType' => '<p>The name of a resource type. The only supported resource type is Amazon EC2 instances with Windows VSS.</p> <p>The only valid value is <code>EC2</code>.</p>', 'AwsBackupBackupPlanBackupPlanDetails$BackupPlanName' => '<p>The display name of a backup plan. </p>', 'AwsBackupBackupPlanDetails$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the backup plan. </p>', 'AwsBackupBackupPlanDetails$BackupPlanId' => '<p>A unique ID for the backup plan. </p>', 'AwsBackupBackupPlanDetails$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot be edited. </p>', 'AwsBackupBackupPlanRuleCopyActionsDetails$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. </p>', 'AwsBackupBackupPlanRuleDetails$TargetBackupVault' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens. </p>', 'AwsBackupBackupPlanRuleDetails$ScheduleExpression' => '<p>A cron expression in UTC specifying when Backup initiates a backup job. </p>', 'AwsBackupBackupPlanRuleDetails$RuleName' => '<p>A display name for a backup rule. Must contain 1 to 50 alphanumeric or \'-_.\' characters. </p>', 'AwsBackupBackupPlanRuleDetails$RuleId' => '<p>Uniquely identifies a rule that is used to schedule the backup of a selection of resources. </p>', 'AwsBackupBackupVaultDetails$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault. </p>', 'AwsBackupBackupVaultDetails$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens. </p>', 'AwsBackupBackupVaultDetails$EncryptionKeyArn' => '<p>The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your backups from services that support full Backup management. If you do not specify a key, Backup creates an KMS key for you by default. </p>', 'AwsBackupBackupVaultDetails$AccessPolicy' => '<p>A resource-based policy that is used to manage access permissions on the target backup vault. </p>', 'AwsBackupBackupVaultNotificationsDetails$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the Amazon SNS topic for a backup vault\'s events. </p>', 'AwsBackupRecoveryPointCalculatedLifecycleDetails$DeleteAt' => '<p>Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus <code>MoveToColdStorageAfterDays</code>. </p>', 'AwsBackupRecoveryPointCalculatedLifecycleDetails$MoveToColdStorageAt' => '<p>Specifies the number of days after creation that a recovery point is moved to cold storage. </p>', 'AwsBackupRecoveryPointCreatedByDetails$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan. </p>', 'AwsBackupRecoveryPointCreatedByDetails$BackupPlanId' => '<p>Uniquely identifies a backup plan. </p>', 'AwsBackupRecoveryPointCreatedByDetails$BackupPlanVersion' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited. </p>', 'AwsBackupRecoveryPointCreatedByDetails$BackupRuleId' => '<p>Uniquely identifies a rule used to schedule the backup of a selection of resources. </p>', 'AwsBackupRecoveryPointDetails$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault. </p>', 'AwsBackupRecoveryPointDetails$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens. </p>', 'AwsBackupRecoveryPointDetails$CompletionDate' => '<p>The date and time that a job to create a recovery point is completed, in Unix format and UTC. The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM. </p>', 'AwsBackupRecoveryPointDetails$CreationDate' => '<p>The date and time a recovery point is created, in Unix format and UTC. The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM. </p>', 'AwsBackupRecoveryPointDetails$EncryptionKeyArn' => '<p>The ARN for the server-side encryption key that is used to protect your backups. </p>', 'AwsBackupRecoveryPointDetails$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point </p>', 'AwsBackupRecoveryPointDetails$LastRestoreTime' => '<p>The date and time that a recovery point was last restored, in Unix format and UTC. The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM. </p>', 'AwsBackupRecoveryPointDetails$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point. </p>', 'AwsBackupRecoveryPointDetails$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type. </p>', 'AwsBackupRecoveryPointDetails$ResourceType' => '<p>The type of Amazon Web Services resource saved as a recovery point, such as an Amazon EBS volume or an Amazon RDS database. </p>', 'AwsBackupRecoveryPointDetails$SourceBackupVaultArn' => '<p>The ARN for the backup vault where the recovery point was originally copied from. If the recovery point is restored to the same account, this value will be null. </p>', 'AwsBackupRecoveryPointDetails$Status' => '<p>A status code specifying the state of the recovery point. Valid values are as follows:</p> <ul> <li> <p> <code>COMPLETED</code> </p> </li> <li> <p> <code>DELETING</code> </p> </li> <li> <p> <code>EXPIRED</code> </p> </li> <li> <p> <code>PARTIAL</code> </p> </li> </ul>', 'AwsBackupRecoveryPointDetails$StatusMessage' => '<p>A message explaining the reason of the recovery point deletion failure. </p>', 'AwsBackupRecoveryPointDetails$StorageClass' => '<p>Specifies the storage class of the recovery point. Valid values are as follows:</p> <ul> <li> <p> <code>COLD</code> </p> </li> <li> <p> <code>DELETED</code> </p> </li> <li> <p> <code>WARM</code> </p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$CertificateAuthorityArn' => '<p>The ARN of the private certificate authority (CA) that will be used to issue the certificate.</p>', 'AwsCertificateManagerCertificateDetails$CreatedAt' => '<p>Indicates when the certificate was requested.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$DomainName' => '<p>The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.</p>', 'AwsCertificateManagerCertificateDetails$FailureReason' => '<p>For a failed certificate request, the reason for the failure.</p> <p>Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> | <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> | <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> | <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> | <code>SLR_NOT_FOUND</code> | <code>OTHER</code> </p>', 'AwsCertificateManagerCertificateDetails$ImportedAt' => '<p>Indicates when the certificate was imported. Provided if the certificate type is <code>IMPORTED</code>.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$IssuedAt' => '<p>Indicates when the certificate was issued. Provided if the certificate type is <code>AMAZON_ISSUED</code>.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$Issuer' => '<p>The name of the certificate authority that issued and signed the certificate.</p>', 'AwsCertificateManagerCertificateDetails$KeyAlgorithm' => '<p>The algorithm that was used to generate the public-private key pair.</p> <p>Valid values: <code>RSA_2048</code> | <code>RSA_1024</code> |<code> RSA_4096</code> | <code>EC_prime256v1</code> | <code>EC_secp384r1</code> | <code>EC_secp521r1</code> </p>', 'AwsCertificateManagerCertificateDetails$NotAfter' => '<p>The time after which the certificate becomes invalid.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$NotBefore' => '<p>The time before which the certificate is not valid.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateDetails$RenewalEligibility' => '<p>Whether the certificate is eligible for renewal.</p> <p>Valid values: <code>ELIGIBLE</code> | <code>INELIGIBLE</code> </p>', 'AwsCertificateManagerCertificateDetails$Serial' => '<p>The serial number of the certificate.</p>', 'AwsCertificateManagerCertificateDetails$SignatureAlgorithm' => '<p>The algorithm that was used to sign the certificate.</p>', 'AwsCertificateManagerCertificateDetails$Status' => '<p>The status of the certificate.</p> <p>Valid values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> | <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code> </p>', 'AwsCertificateManagerCertificateDetails$Subject' => '<p>The name of the entity that is associated with the public key contained in the certificate.</p>', 'AwsCertificateManagerCertificateDetails$Type' => '<p>The source of the certificate. For certificates that Certificate Manager provides, <code>Type</code> is <code>AMAZON_ISSUED</code>. For certificates that are imported with <code>ImportCertificate</code>, <code>Type</code> is <code>IMPORTED</code>.</p> <p>Valid values: <code>IMPORTED</code> | <code>AMAZON_ISSUED</code> | <code>PRIVATE</code> </p>', 'AwsCertificateManagerCertificateDomainValidationOption$DomainName' => '<p>A fully qualified domain name (FQDN) in the certificate.</p>', 'AwsCertificateManagerCertificateDomainValidationOption$ValidationDomain' => '<p>The domain name that Certificate Manager uses to send domain validation emails.</p>', 'AwsCertificateManagerCertificateDomainValidationOption$ValidationMethod' => '<p>The method used to validate the domain name.</p>', 'AwsCertificateManagerCertificateDomainValidationOption$ValidationStatus' => '<p>The validation status of the domain name.</p>', 'AwsCertificateManagerCertificateExtendedKeyUsage$Name' => '<p>The name of an extension value. Indicates the purpose for which the certificate public key can be used.</p>', 'AwsCertificateManagerCertificateExtendedKeyUsage$OId' => '<p>An object identifier (OID) for the extension value.</p> <p>The format is numbers separated by periods.</p>', 'AwsCertificateManagerCertificateKeyUsage$Name' => '<p>The key usage extension name.</p>', 'AwsCertificateManagerCertificateOptions$CertificateTransparencyLoggingPreference' => '<p>Whether to add the certificate to a transparency log.</p> <p>Valid values: <code>DISABLED</code> | <code>ENABLED</code> </p>', 'AwsCertificateManagerCertificateRenewalSummary$RenewalStatus' => '<p>The status of the Certificate Manager managed renewal of the certificate.</p> <p>Valid values: <code>PENDING_AUTO_RENEWAL</code> | <code>PENDING_VALIDATION</code> | <code>SUCCESS</code> | <code>FAILED</code> </p>', 'AwsCertificateManagerCertificateRenewalSummary$RenewalStatusReason' => '<p>The reason that a renewal request was unsuccessful. This attribute is used only when <code>RenewalStatus</code> is <code>FAILED</code>.</p> <p>Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> | <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> | <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> | <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> | <code>SLR_NOT_FOUND</code> | <code>OTHER</code> </p>', 'AwsCertificateManagerCertificateRenewalSummary$UpdatedAt' => '<p>Indicates when the renewal summary was last updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCertificateManagerCertificateResourceRecord$Name' => '<p>The name of the resource.</p>', 'AwsCertificateManagerCertificateResourceRecord$Type' => '<p>The type of resource.</p>', 'AwsCertificateManagerCertificateResourceRecord$Value' => '<p>The value of the resource.</p>', 'AwsCloudFormationStackDetails$CreationTime' => '<p>The time at which the stack was created. </p>', 'AwsCloudFormationStackDetails$Description' => '<p>A user-defined description associated with the stack. </p>', 'AwsCloudFormationStackDetails$LastUpdatedTime' => '<p>The time the nested stack was last updated. This field will only be returned if the stack has been updated at least once.</p>', 'AwsCloudFormationStackDetails$RoleArn' => '<p>The ARN of an IAM role that\'s associated with the stack. </p>', 'AwsCloudFormationStackDetails$StackId' => '<p>Unique identifier of the stack. </p>', 'AwsCloudFormationStackDetails$StackName' => '<p>The name associated with the stack. </p>', 'AwsCloudFormationStackDetails$StackStatus' => '<p>Current status of the stack. </p>', 'AwsCloudFormationStackDetails$StackStatusReason' => '<p>Success or failure message associated with the stack status. </p>', 'AwsCloudFormationStackDriftInformationDetails$StackDriftStatus' => '<p>Status of the stack\'s actual configuration compared to its expected template configuration. </p>', 'AwsCloudFormationStackOutputsDetails$Description' => '<p>A user-defined description associated with the output. </p>', 'AwsCloudFormationStackOutputsDetails$OutputKey' => '<p>The key associated with the output. </p>', 'AwsCloudFormationStackOutputsDetails$OutputValue' => '<p>The value associated with the output. </p>', 'AwsCloudFrontDistributionCacheBehavior$ViewerProtocolPolicy' => '<p>The protocol that viewers can use to access the files in an origin. You can specify the following options:</p> <ul> <li> <p> <code>allow-all</code> - Viewers can use HTTP or HTTPS.</p> </li> <li> <p> <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.</p> </li> <li> <p> <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403 (Forbidden).</p> </li> </ul>', 'AwsCloudFrontDistributionDefaultCacheBehavior$ViewerProtocolPolicy' => '<p>The protocol that viewers can use to access the files in an origin. You can specify the following options:</p> <ul> <li> <p> <code>allow-all</code> - Viewers can use HTTP or HTTPS.</p> </li> <li> <p> <code>redirect-to-https</code> - CloudFront responds to HTTP requests with an HTTP status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then uses the new URL to resubmit.</p> </li> <li> <p> <code>https-only</code> - CloudFront responds to HTTP request with an HTTP status code of 403 (Forbidden).</p> </li> </ul>', 'AwsCloudFrontDistributionDetails$DefaultRootObject' => '<p>The object that CloudFront sends in response to requests from the origin (for example, index.html) when a viewer requests the root URL for the distribution (http://www.example.com) instead of an object in your distribution (http://www.example.com/product-description.html). </p>', 'AwsCloudFrontDistributionDetails$DomainName' => '<p>The domain name corresponding to the distribution.</p>', 'AwsCloudFrontDistributionDetails$ETag' => '<p>The entity tag is a hash of the object.</p>', 'AwsCloudFrontDistributionDetails$LastModifiedTime' => '<p>Indicates when that the distribution was last modified.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsCloudFrontDistributionDetails$Status' => '<p>Indicates the current status of the distribution.</p>', 'AwsCloudFrontDistributionDetails$WebAclId' => '<p>A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution.</p>', 'AwsCloudFrontDistributionLogging$Bucket' => '<p>The S3 bucket to store the access logs in.</p>', 'AwsCloudFrontDistributionLogging$Prefix' => '<p>An optional string that you want CloudFront to use as a prefix to the access log filenames for this distribution.</p>', 'AwsCloudFrontDistributionOriginCustomOriginConfig$OriginProtocolPolicy' => '<p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. </p>', 'AwsCloudFrontDistributionOriginItem$DomainName' => '<p>Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this origin.</p>', 'AwsCloudFrontDistributionOriginItem$Id' => '<p>A unique identifier for the origin or origin group.</p>', 'AwsCloudFrontDistributionOriginItem$OriginPath' => '<p>An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.</p>', 'AwsCloudFrontDistributionOriginS3OriginConfig$OriginAccessIdentity' => '<p>The CloudFront origin access identity to associate with the origin.</p>', 'AwsCloudFrontDistributionViewerCertificate$AcmCertificateArn' => '<p>The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM certificate ARN, you must also provide <code>MinimumCertificateVersion</code> and <code>SslSupportMethod</code>.</p>', 'AwsCloudFrontDistributionViewerCertificate$Certificate' => '<p>The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.</p>', 'AwsCloudFrontDistributionViewerCertificate$CertificateSource' => '<p>The source of the certificate identified by <code>Certificate</code>. Note that in CloudFront, this attribute is deprecated.</p>', 'AwsCloudFrontDistributionViewerCertificate$IamCertificateId' => '<p>The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide <code>IamCertificateId</code>, then you also must provide <code>MinimumProtocolVersion</code> and <code>SslSupportMethod</code>.</p>', 'AwsCloudFrontDistributionViewerCertificate$MinimumProtocolVersion' => '<p>The security policy that CloudFront uses for HTTPS connections with viewers. If <code>SslSupportMethod</code> is <code>sni-only</code>, then <code>MinimumProtocolVersion</code> must be <code>TLSv1</code> or higher.</p>', 'AwsCloudFrontDistributionViewerCertificate$SslSupportMethod' => '<p>The viewers that the distribution accepts HTTPS connections from.</p>', 'AwsCloudTrailTrailDetails$CloudWatchLogsLogGroupArn' => '<p>The ARN of the log group that CloudTrail logs are delivered to.</p>', 'AwsCloudTrailTrailDetails$CloudWatchLogsRoleArn' => '<p>The ARN of the role that the CloudWatch Events endpoint assumes when it writes to the log group.</p>', 'AwsCloudTrailTrailDetails$HomeRegion' => '<p>The Region where the trail was created.</p>', 'AwsCloudTrailTrailDetails$KmsKeyId' => '<p>The KMS key ID to use to encrypt the logs.</p>', 'AwsCloudTrailTrailDetails$Name' => '<p>The name of the trail.</p>', 'AwsCloudTrailTrailDetails$S3BucketName' => '<p>The name of the S3 bucket where the log files are published.</p>', 'AwsCloudTrailTrailDetails$S3KeyPrefix' => '<p>The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are published.</p>', 'AwsCloudTrailTrailDetails$SnsTopicArn' => '<p>The ARN of the SNS topic that is used for notifications of log file delivery.</p>', 'AwsCloudTrailTrailDetails$SnsTopicName' => '<p>The name of the SNS topic that is used for notifications of log file delivery.</p>', 'AwsCloudTrailTrailDetails$TrailArn' => '<p>The ARN of the trail.</p>', 'AwsCloudWatchAlarmDetails$AlarmArn' => '<p>The ARN of the alarm. </p>', 'AwsCloudWatchAlarmDetails$AlarmConfigurationUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm configuration. </p>', 'AwsCloudWatchAlarmDetails$AlarmDescription' => '<p>The description of the alarm. </p>', 'AwsCloudWatchAlarmDetails$AlarmName' => '<p>The name of the alarm. If you don\'t specify a name, CloudFront generates a unique physical ID and uses that ID for the alarm name. </p>', 'AwsCloudWatchAlarmDetails$ComparisonOperator' => '<p>The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand. </p>', 'AwsCloudWatchAlarmDetails$EvaluateLowSampleCountPercentile' => '<p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available. </p>', 'AwsCloudWatchAlarmDetails$ExtendedStatistic' => '<p>The percentile statistic for the metric associated with the alarm. </p>', 'AwsCloudWatchAlarmDetails$MetricName' => '<p>The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you use <code>Metrics</code> instead and you can\'t specify <code>MetricName</code>. </p>', 'AwsCloudWatchAlarmDetails$Namespace' => '<p>The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you can\'t specify <code>Namespace</code> and you use <code>Metrics</code> instead. </p>', 'AwsCloudWatchAlarmDetails$Statistic' => '<p>The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.</p> <p>For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code> but not both.</p> <p>For an alarm based on a math expression, you can\'t specify <code>Statistic</code>. Instead, you use <code>Metrics</code>.</p>', 'AwsCloudWatchAlarmDetails$ThresholdMetricId' => '<p>n an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm. </p>', 'AwsCloudWatchAlarmDetails$TreatMissingData' => '<p>Sets how this alarm is to handle missing data points. </p>', 'AwsCloudWatchAlarmDetails$Unit' => '<p>The unit of the metric associated with the alarm. </p>', 'AwsCloudWatchAlarmDimensionsDetails$Name' => '<p>The name of a dimension. </p>', 'AwsCloudWatchAlarmDimensionsDetails$Value' => '<p>The value of a dimension. </p>', 'AwsCodeBuildProjectArtifactsDetails$ArtifactIdentifier' => '<p>An identifier for the artifact definition.</p>', 'AwsCodeBuildProjectArtifactsDetails$Location' => '<p>Only used when <code>Type</code> is <code>S3</code>. The name of the S3 bucket where the artifact is located.</p>', 'AwsCodeBuildProjectArtifactsDetails$Name' => '<p>Only used when Type is S3. The name of the artifact. Used with <code>NamepaceType</code> and <code>Path</code> to determine the pattern for storing the artifact.</p>', 'AwsCodeBuildProjectArtifactsDetails$NamespaceType' => '<p>Only used when <code>Type</code> is <code>S3</code>. The value to use for the namespace. Used with <code>Name</code> and <code>Path</code> to determine the pattern for storing the artifact.</p>', 'AwsCodeBuildProjectArtifactsDetails$Packaging' => '<p>Only used when <code>Type</code> is <code>S3</code>. The type of output artifact to create.</p>', 'AwsCodeBuildProjectArtifactsDetails$Path' => '<p>Only used when <code>Type</code> is <code>S3</code>. The path to the artifact. Used with <code>Name</code> and <code>NamespaceType</code> to determine the pattern for storing the artifact.</p>', 'AwsCodeBuildProjectArtifactsDetails$Type' => '<p>The type of build artifact.</p>', 'AwsCodeBuildProjectDetails$EncryptionKey' => '<p>The KMS key used to encrypt the build output artifacts.</p> <p>You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format alias/alias-name). </p>', 'AwsCodeBuildProjectDetails$Name' => '<p>The name of the build project.</p>', 'AwsCodeBuildProjectDetails$ServiceRole' => '<p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>', 'AwsCodeBuildProjectEnvironment$Certificate' => '<p>The certificate to use with this build project.</p>', 'AwsCodeBuildProjectEnvironment$ImagePullCredentialsType' => '<p>The type of credentials CodeBuild uses to pull images in your build.</p> <p>Valid values:</p> <ul> <li> <p> <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust the CodeBuild service principal.</p> </li> <li> <p> <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project\'s service role.</p> </li> </ul> <p>When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When you use an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.</p>', 'AwsCodeBuildProjectEnvironment$Type' => '<p>The type of build environment to use for related builds.</p> <p>The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).</p> <p>The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</p> <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</p> <p>Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> | <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code> </p>', 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails$Name' => '<p>The name of the environment variable.</p>', 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails$Type' => '<p>The type of environment variable.</p>', 'AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails$Value' => '<p>The value of the environment variable.</p>', 'AwsCodeBuildProjectEnvironmentRegistryCredential$Credential' => '<p>The ARN or name of credentials created using Secrets Manager.</p> <note> <p>The credential can use the name of the credentials only if they exist in your current Amazon Web Services Region. </p> </note>', 'AwsCodeBuildProjectEnvironmentRegistryCredential$CredentialProvider' => '<p>The service that created the credentials to access a private Docker registry.</p> <p>The valid value,<code> SECRETS_MANAGER</code>, is for Secrets Manager.</p>', 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails$GroupName' => '<p>The group name of the logs in CloudWatch Logs.</p>', 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails$Status' => '<p>The current status of the logs in CloudWatch Logs for a build project.</p>', 'AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails$StreamName' => '<p>The prefix of the stream name of the CloudWatch Logs.</p>', 'AwsCodeBuildProjectLogsConfigS3LogsDetails$Location' => '<p>The ARN of the S3 bucket and the path prefix for S3 logs.</p>', 'AwsCodeBuildProjectLogsConfigS3LogsDetails$Status' => '<p>The current status of the S3 build logs.</p>', 'AwsCodeBuildProjectSource$Type' => '<p>The type of repository that contains the source code to be built. Valid values are:</p> <ul> <li> <p> <code>BITBUCKET</code> - The source code is in a Bitbucket repository.</p> </li> <li> <p> <code>CODECOMMIT</code> - The source code is in an CodeCommit repository.</p> </li> <li> <p> <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline in CodePipeline.</p> </li> <li> <p> <code>GITHUB</code> - The source code is in a GitHub repository.</p> </li> <li> <p> <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.</p> </li> <li> <p> <code>NO_SOURCE</code> - The project does not have input source code.</p> </li> <li> <p> <code>S3</code> - The source code is in an S3 input bucket. </p> </li> </ul>', 'AwsCodeBuildProjectSource$Location' => '<p>Information about the location of the source code to be built.</p> <p>Valid values include:</p> <ul> <li> <p>For source code settings that are specified in the source action of a pipeline in CodePipeline, location should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline\'s source action instead of this value.</p> </li> <li> <p>For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the build spec file (for example, <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).</p> </li> <li> <p>For source code in an S3 input bucket, one of the following.</p> <ul> <li> <p>The path to the ZIP file that contains the source code (for example, <code>bucket-name/path/to/object-name.zip</code>).</p> </li> <li> <p> The path to the folder that contains the source code (for example, <code>bucket-name/path/to/source-code/folder/</code>).</p> </li> </ul> </li> <li> <p>For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the build spec file.</p> </li> <li> <p>For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the build spec file. </p> </li> </ul>', 'AwsCodeBuildProjectVpcConfig$VpcId' => '<p>The ID of the VPC.</p>', 'AwsDmsEndpointDetails$CertificateArn' => '<p> The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint and the replication instance. </p>', 'AwsDmsEndpointDetails$DatabaseName' => '<p> The name of the endpoint database.</p>', 'AwsDmsEndpointDetails$EndpointArn' => '<p> The Amazon Resource Name (ARN) of the endpoint. </p>', 'AwsDmsEndpointDetails$EndpointIdentifier' => '<p> The database endpoint identifier. </p>', 'AwsDmsEndpointDetails$EndpointType' => '<p> The type of endpoint. Valid values are source and target. </p>', 'AwsDmsEndpointDetails$EngineName' => '<p> The type of engine for the endpoint, depending on the <code>EndpointType</code> value. </p>', 'AwsDmsEndpointDetails$ExternalId' => '<p> A value that can be used for cross-account validation. </p>', 'AwsDmsEndpointDetails$ExtraConnectionAttributes' => '<p> Additional attributes associated with the connection. </p>', 'AwsDmsEndpointDetails$KmsKeyId' => '<p> An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'AwsDmsEndpointDetails$ServerName' => '<p> The name of the server where the endpoint database resides.</p>', 'AwsDmsEndpointDetails$SslMode' => '<p> The SSL mode used to connect to the endpoint. The default is none.</p>', 'AwsDmsEndpointDetails$Username' => '<p> The user name to be used to log in to the endpoint database. </p>', 'AwsDmsReplicationInstanceDetails$AvailabilityZone' => '<p> The Availability Zone that the replication instance is created in. The default value is a random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region, such as <code>us-east-1d</code>.</p>', 'AwsDmsReplicationInstanceDetails$EngineVersion' => '<p> The engine version number of the replication instance. If an engine version number is not specified when a replication instance is created, the default is the latest engine version available. </p>', 'AwsDmsReplicationInstanceDetails$KmsKeyId' => '<p> An KMS key identifier that is used to encrypt the data on the replication instance. If you don\'t specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'AwsDmsReplicationInstanceDetails$PreferredMaintenanceWindow' => '<p> The maintenance window times for the replication instance. Upgrades to the replication instance are performed during this time.</p>', 'AwsDmsReplicationInstanceDetails$ReplicationInstanceClass' => '<p> The compute and memory capacity of the replication instance as defined for the specified replication instance class. </p>', 'AwsDmsReplicationInstanceDetails$ReplicationInstanceIdentifier' => '<p> The replication instance identifier.</p>', 'AwsDmsReplicationInstanceReplicationSubnetGroupDetails$ReplicationSubnetGroupIdentifier' => '<p> The identifier of the replication subnet group. </p>', 'AwsDmsReplicationInstanceVpcSecurityGroupsDetails$VpcSecurityGroupId' => '<p> The identifier of the VPC security group that’s associated with the replication instance. </p>', 'AwsDmsReplicationTaskDetails$CdcStartPosition' => '<p> Indicates when you want a change data capture (CDC) operation to start. <code>CCdcStartPosition</code> or <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of these fields is included.</p>', 'AwsDmsReplicationTaskDetails$CdcStartTime' => '<p> Indicates the start time for a CDC operation. <code>CdcStartPosition</code> or <code>CCdcStartTime</code> specifies when you want a CDC operation to start. Only a value for one of these fields is included.</p>', 'AwsDmsReplicationTaskDetails$CdcStopPosition' => '<p> Indicates when you want a CDC operation to stop. The value can be either server time or commit time.</p>', 'AwsDmsReplicationTaskDetails$MigrationType' => '<p> The migration type. </p>', 'AwsDmsReplicationTaskDetails$Id' => '<p> The identifier of the replication task.</p>', 'AwsDmsReplicationTaskDetails$ResourceIdentifier' => '<p> A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter. If you don\'t specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>', 'AwsDmsReplicationTaskDetails$ReplicationInstanceArn' => '<p> The Amazon Resource Name (ARN) of a replication instance. </p>', 'AwsDmsReplicationTaskDetails$ReplicationTaskIdentifier' => '<p> The user-defined replication task identifier or name.</p>', 'AwsDmsReplicationTaskDetails$ReplicationTaskSettings' => '<p> The settings for the replication task.</p>', 'AwsDmsReplicationTaskDetails$SourceEndpointArn' => '<p> The ARN of the source endpoint.</p>', 'AwsDmsReplicationTaskDetails$TableMappings' => '<p> The table mappings for the replication task, in JSON format.</p>', 'AwsDmsReplicationTaskDetails$TargetEndpointArn' => '<p> The ARN of the target endpoint.</p>', 'AwsDmsReplicationTaskDetails$TaskData' => '<p> Supplemental information that the task requires to migrate the data for certain source and target endpoints.</p>', 'AwsDynamoDbTableAttributeDefinition$AttributeName' => '<p>The name of the attribute.</p>', 'AwsDynamoDbTableAttributeDefinition$AttributeType' => '<p>The type of the attribute.</p>', 'AwsDynamoDbTableBillingModeSummary$BillingMode' => '<p>The method used to charge for read and write throughput and to manage capacity.</p>', 'AwsDynamoDbTableBillingModeSummary$LastUpdateToPayPerRequestDateTime' => '<p>If the billing mode is <code>PAY_PER_REQUEST</code>, indicates when the billing mode was set to that value.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableDetails$CreationDateTime' => '<p>Indicates when the table was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableDetails$GlobalTableVersion' => '<p>The version of global tables being used.</p>', 'AwsDynamoDbTableDetails$LatestStreamArn' => '<p>The ARN of the latest stream for the table.</p>', 'AwsDynamoDbTableDetails$LatestStreamLabel' => '<p>The label of the latest stream. The label is not a unique identifier.</p>', 'AwsDynamoDbTableDetails$TableId' => '<p>The identifier of the table.</p>', 'AwsDynamoDbTableDetails$TableName' => '<p>The name of the table.</p>', 'AwsDynamoDbTableDetails$TableStatus' => '<p>The current status of the table. Valid values are as follows:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>ARCHIVED</code> </p> </li> <li> <p> <code>ARCHIVING</code> </p> </li> <li> <p> <code>CREATING</code> </p> </li> <li> <p> <code>DELETING</code> </p> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> </p> </li> <li> <p> <code>UPDATING</code> </p> </li> </ul>', 'AwsDynamoDbTableGlobalSecondaryIndex$IndexArn' => '<p>The ARN of the index.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$IndexName' => '<p>The name of the index.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$IndexStatus' => '<p>The current status of the index.</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATING</code> </p> </li> <li> <p> <code>DELETING</code> </p> </li> <li> <p> <code>UPDATING</code> </p> </li> </ul>', 'AwsDynamoDbTableKeySchema$AttributeName' => '<p>The name of the key schema attribute.</p>', 'AwsDynamoDbTableKeySchema$KeyType' => '<p>The type of key used for the key schema attribute. Valid values are <code>HASH</code> or <code>RANGE</code>.</p>', 'AwsDynamoDbTableLocalSecondaryIndex$IndexArn' => '<p>The ARN of the index.</p>', 'AwsDynamoDbTableLocalSecondaryIndex$IndexName' => '<p>The name of the index.</p>', 'AwsDynamoDbTableProjection$ProjectionType' => '<p>The types of attributes that are projected into the index. Valid values are as follows:</p> <ul> <li> <p> <code>ALL</code> </p> </li> <li> <p> <code>INCLUDE</code> </p> </li> <li> <p> <code>KEYS_ONLY</code> </p> </li> </ul>', 'AwsDynamoDbTableProvisionedThroughput$LastDecreaseDateTime' => '<p>Indicates when the provisioned throughput was last decreased.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableProvisionedThroughput$LastIncreaseDateTime' => '<p>Indicates when the provisioned throughput was last increased.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableReplica$KmsMasterKeyId' => '<p>The identifier of the KMS key that will be used for KMS encryption for the replica.</p>', 'AwsDynamoDbTableReplica$RegionName' => '<p>The name of the Region where the replica is located.</p>', 'AwsDynamoDbTableReplica$ReplicaStatus' => '<p>The current status of the replica. Valid values are as follows:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATING</code> </p> </li> <li> <p> <code>CREATION_FAILED</code> </p> </li> <li> <p> <code>DELETING</code> </p> </li> <li> <p> <code>UPDATING</code> </p> </li> </ul>', 'AwsDynamoDbTableReplica$ReplicaStatusDescription' => '<p>Detailed information about the replica status.</p>', 'AwsDynamoDbTableReplicaGlobalSecondaryIndex$IndexName' => '<p>The name of the index.</p>', 'AwsDynamoDbTableRestoreSummary$SourceBackupArn' => '<p>The ARN of the source backup from which the table was restored.</p>', 'AwsDynamoDbTableRestoreSummary$SourceTableArn' => '<p>The ARN of the source table for the backup.</p>', 'AwsDynamoDbTableRestoreSummary$RestoreDateTime' => '<p>Indicates the point in time that the table was restored to.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableSseDescription$InaccessibleEncryptionDateTime' => '<p>If the key is inaccessible, the date and time when DynamoDB detected that the key was inaccessible.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsDynamoDbTableSseDescription$Status' => '<p>The status of the server-side encryption.</p>', 'AwsDynamoDbTableSseDescription$SseType' => '<p>The type of server-side encryption.</p>', 'AwsDynamoDbTableSseDescription$KmsMasterKeyArn' => '<p>The ARN of the KMS key that is used for the KMS encryption.</p>', 'AwsDynamoDbTableStreamSpecification$StreamViewType' => '<p>Determines the information that is written to the table.</p>', 'AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails$DirectoryId' => '<p> The ID of the Active Directory used for authentication. </p>', 'AwsEc2ClientVpnEndpointAuthenticationOptionsDetails$Type' => '<p> The authentication type used. </p>', 'AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails$SamlProviderArn' => '<p> The Amazon Resource Name (ARN) of the IAM SAML identity provider. </p>', 'AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails$SelfServiceSamlProviderArn' => '<p> The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal. </p>', 'AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails$ClientRootCertificateChain' => '<p> The Amazon Resource Name (ARN) of the client certificate. </p>', 'AwsEc2ClientVpnEndpointClientConnectOptionsDetails$LambdaFunctionArn' => '<p> The Amazon Resource Name (ARN) of the Lambda function used for connection authorization. </p>', 'AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails$Code' => '<p> The status code. </p>', 'AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails$Message' => '<p> The status message. </p>', 'AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails$BannerText' => '<p> Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN session is established. </p>', 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails$CloudwatchLogGroup' => '<p> The name of the Amazon CloudWatch Logs log group to which connection logging data is published. </p>', 'AwsEc2ClientVpnEndpointConnectionLogOptionsDetails$CloudwatchLogStream' => '<p> The name of the Amazon CloudWatch Logs log stream to which connection logging data is published. </p>', 'AwsEc2ClientVpnEndpointDetails$ClientVpnEndpointId' => '<p> The ID of the Client VPN endpoint. </p>', 'AwsEc2ClientVpnEndpointDetails$Description' => '<p> A brief description of the endpoint. </p>', 'AwsEc2ClientVpnEndpointDetails$ClientCidrBlock' => '<p> The IPv4 address range, in CIDR notation, from which client IP addresses are assigned. </p>', 'AwsEc2ClientVpnEndpointDetails$TransportProtocol' => '<p> The transport protocol used by the Client VPN endpoint. </p>', 'AwsEc2ClientVpnEndpointDetails$ServerCertificateArn' => '<p> The Amazon Resource Name (ARN) of the server certificate. </p>', 'AwsEc2ClientVpnEndpointDetails$VpcId' => '<p> The ID of the VPC. </p>', 'AwsEc2ClientVpnEndpointDetails$SelfServicePortalUrl' => '<p> The URL of the self-service portal. </p>', 'AwsEc2EipDetails$InstanceId' => '<p>The identifier of the EC2 instance.</p>', 'AwsEc2EipDetails$PublicIp' => '<p>A public IP address that is associated with the EC2 instance.</p>', 'AwsEc2EipDetails$AllocationId' => '<p>The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with Amazon VPC.</p>', 'AwsEc2EipDetails$AssociationId' => '<p>The identifier that represents the association of the Elastic IP address with an EC2 instance.</p>', 'AwsEc2EipDetails$Domain' => '<p>The domain in which to allocate the address.</p> <p>If the address is for use with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>. Otherwise, <code>Domain</code> is <code>standard</code>. </p>', 'AwsEc2EipDetails$PublicIpv4Pool' => '<p>The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the address pool.</p>', 'AwsEc2EipDetails$NetworkBorderGroup' => '<p>The name of the location from which the Elastic IP address is advertised.</p>', 'AwsEc2EipDetails$NetworkInterfaceId' => '<p>The identifier of the network interface.</p>', 'AwsEc2EipDetails$NetworkInterfaceOwnerId' => '<p>The Amazon Web Services account ID of the owner of the network interface.</p>', 'AwsEc2EipDetails$PrivateIpAddress' => '<p>The private IP address that is associated with the Elastic IP address.</p>', 'AwsEc2InstanceDetails$Type' => '<p>The instance type of the instance. </p>', 'AwsEc2InstanceDetails$ImageId' => '<p>The Amazon Machine Image (AMI) ID of the instance.</p>', 'AwsEc2InstanceDetails$KeyName' => '<p>The key name associated with the instance.</p>', 'AwsEc2InstanceDetails$IamInstanceProfileArn' => '<p>The IAM profile ARN of the instance.</p>', 'AwsEc2InstanceDetails$VpcId' => '<p>The identifier of the VPC that the instance was launched in.</p>', 'AwsEc2InstanceDetails$SubnetId' => '<p>The identifier of the subnet that the instance was launched in.</p>', 'AwsEc2InstanceDetails$LaunchedAt' => '<p>Indicates when the instance was launched.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsEc2InstanceDetails$VirtualizationType' => '<p>The virtualization type of the Amazon Machine Image (AMI) required to launch the instance. </p>', 'AwsEc2InstanceMetadataOptions$HttpEndpoint' => '<p>Enables or disables the HTTP metadata endpoint on the instance. </p>', 'AwsEc2InstanceMetadataOptions$HttpProtocolIpv6' => '<p>Enables or disables the IPv6 endpoint for the instance metadata service. </p>', 'AwsEc2InstanceMetadataOptions$HttpTokens' => '<p>The state of token usage for your instance metadata requests. </p>', 'AwsEc2InstanceMetadataOptions$InstanceMetadataTags' => '<p>Specifies whether to allow access to instance tags from the instance metadata. </p>', 'AwsEc2InstanceMonitoringDetails$State' => '<p> Indicates whether detailed monitoring is turned on. Otherwise, basic monitoring is turned on. </p>', 'AwsEc2InstanceNetworkInterfacesDetails$NetworkInterfaceId' => '<p>The identifier of the network interface. The details are in a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.</p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails$DeviceName' => '<p> The device name. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails$NoDevice' => '<p> Omits the device from the block device mapping when an empty string is specified. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails$VirtualName' => '<p> The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$KmsKeyId' => '<p> The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used for encryption. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$SnapshotId' => '<p> The ID of the EBS snapshot. </p>', 'AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails$VolumeType' => '<p> The volume type. </p>', 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails$CapacityReservationId' => '<p> The ID of the Capacity Reservation in which to run the instance. </p>', 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails$CapacityReservationResourceGroupArn' => '<p> The Amazon Resource Name (ARN) of the Capacity Reservation resource group in which to run the instance. </p>', 'AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails$CapacityReservationPreference' => '<p> Indicates the instance\'s Capacity Reservation preferences. If equal to <code>open</code>, the instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). If equal to <code>none</code>, the instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity. </p>', 'AwsEc2LaunchTemplateDataCreditSpecificationDetails$CpuCredits' => '<p> The credit option for CPU usage of a T instance. </p>', 'AwsEc2LaunchTemplateDataDetails$ImageId' => '<p> The ID of the Amazon Machine Image (AMI). </p>', 'AwsEc2LaunchTemplateDataDetails$InstanceInitiatedShutdownBehavior' => '<p> Provides the options for specifying the instance initiated shutdown behavior. </p>', 'AwsEc2LaunchTemplateDataDetails$InstanceType' => '<p> The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>. If you specify <code>InstanceType</code>, you can\'t specify <code>InstanceRequirements</code>. </p>', 'AwsEc2LaunchTemplateDataDetails$KernelId' => '<p> The ID of the kernel. </p>', 'AwsEc2LaunchTemplateDataDetails$KeyName' => '<p> The name of the key pair that allows users to connect to the instance. </p>', 'AwsEc2LaunchTemplateDataDetails$RamDiskId' => '<p> The ID of the RAM disk. </p>', 'AwsEc2LaunchTemplateDataDetails$UserData' => '<p> The user data to make available to the instance. </p>', 'AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails$Type' => '<p> The type of Elastic Graphics accelerator. </p>', 'AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails$Type' => '<p> The type of Elastic Inference accelerator. </p>', 'AwsEc2LaunchTemplateDataIamInstanceProfileDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the instance profile. </p>', 'AwsEc2LaunchTemplateDataIamInstanceProfileDetails$Name' => '<p> The name of the instance profile. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails$MarketType' => '<p> The market type. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails$InstanceInterruptionBehavior' => '<p> The behavior when a Spot Instance is interrupted. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails$MaxPrice' => '<p> The maximum hourly price you\'re willing to pay for the Spot Instances. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails$SpotInstanceType' => '<p> The Spot Instance request type. </p>', 'AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails$ValidUntil' => '<p> The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ), for persistent requests. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$BareMetal' => '<p>Indicates whether bare metal instance types must be included, excluded, or required. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$BurstablePerformance' => '<p> Indicates whether burstable performance T instance types are included, excluded, or required. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$LocalStorage' => '<p> Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataLicenseSetDetails$LicenseConfigurationArn' => '<p> The Amazon Resource Name (ARN) of the license configuration. </p>', 'AwsEc2LaunchTemplateDataMaintenanceOptionsDetails$AutoRecovery' => '<p> Disables the automatic recovery behavior of your instance or sets it to default. </p>', 'AwsEc2LaunchTemplateDataMetadataOptionsDetails$HttpEndpoint' => '<p> Enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is enabled, and you won\'t be able to access your instance metadata. </p>', 'AwsEc2LaunchTemplateDataMetadataOptionsDetails$HttpProtocolIpv6' => '<p> Enables or disables the IPv6 endpoint for the instance metadata service. </p>', 'AwsEc2LaunchTemplateDataMetadataOptionsDetails$HttpTokens' => '<p> The state of token usage for your instance metadata requests. </p>', 'AwsEc2LaunchTemplateDataMetadataOptionsDetails$InstanceMetadataTags' => '<p> When set to <code>enabled</code>, this parameter allows access to instance tags from the instance metadata. When set to <code>disabled</code>, it turns off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags in instance metadata</a> in the <i>Amazon EC2 User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Description' => '<p> A description for the network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$InterfaceType' => '<p> The type of network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$NetworkInterfaceId' => '<p> The ID of the network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$PrivateIpAddress' => '<p> The primary private IPv4 address of the network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$SubnetId' => '<p> The ID of the subnet for the network interface. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails$Ipv4Prefix' => '<p> The IPv4 prefix. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails$Ipv6Address' => '<p> One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails$Ipv6Prefix' => '<p> The IPv6 prefix. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails$PrivateIpAddress' => '<p> The private IPv4 address. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$Affinity' => '<p> The affinity setting for an instance on an EC2 Dedicated Host. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$AvailabilityZone' => '<p> The Availability Zone for the instance. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$GroupName' => '<p> The name of the placement group for the instance. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$HostId' => '<p> The ID of the Dedicated Host for the instance. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$HostResourceGroupArn' => '<p> The Amazon Resource Name (ARN) of the host resource group in which to launch the instances. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$SpreadDomain' => '<p> Reserved for future use. </p>', 'AwsEc2LaunchTemplateDataPlacementDetails$Tenancy' => '<p> The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware. </p>', 'AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails$HostnameType' => '<p> The type of hostname for EC2 instances. </p>', 'AwsEc2LaunchTemplateDetails$LaunchTemplateName' => '<p> A name for the launch template. </p>', 'AwsEc2LaunchTemplateDetails$Id' => '<p> An ID for the launch template. </p>', 'AwsEc2NetworkAclAssociation$NetworkAclAssociationId' => '<p>The identifier of the association between the network ACL and the subnet.</p>', 'AwsEc2NetworkAclAssociation$NetworkAclId' => '<p>The identifier of the network ACL.</p>', 'AwsEc2NetworkAclAssociation$SubnetId' => '<p>The identifier of the subnet that is associated with the network ACL.</p>', 'AwsEc2NetworkAclDetails$NetworkAclId' => '<p>The identifier of the network ACL.</p>', 'AwsEc2NetworkAclDetails$OwnerId' => '<p>The identifier of the Amazon Web Services account that owns the network ACL.</p>', 'AwsEc2NetworkAclDetails$VpcId' => '<p>The identifier of the VPC for the network ACL.</p>', 'AwsEc2NetworkAclEntry$CidrBlock' => '<p>The IPV4 network range for which to deny or allow access.</p>', 'AwsEc2NetworkAclEntry$Ipv6CidrBlock' => '<p>The IPV6 network range for which to deny or allow access.</p>', 'AwsEc2NetworkAclEntry$Protocol' => '<p>The protocol that the rule applies to. To deny or allow access to all protocols, use the value <code>-1</code>.</p>', 'AwsEc2NetworkAclEntry$RuleAction' => '<p>Whether the rule is used to allow access or deny access.</p>', 'AwsEc2NetworkInterfaceAttachment$AttachTime' => '<p>Indicates when the attachment initiated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsEc2NetworkInterfaceAttachment$AttachmentId' => '<p>The identifier of the network interface attachment</p>', 'AwsEc2NetworkInterfaceAttachment$InstanceId' => '<p>The ID of the instance.</p>', 'AwsEc2NetworkInterfaceAttachment$InstanceOwnerId' => '<p>The Amazon Web Services account ID of the owner of the instance.</p>', 'AwsEc2NetworkInterfaceAttachment$Status' => '<p>The attachment state.</p> <p>Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code> </p>', 'AwsEc2NetworkInterfaceDetails$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AwsEc2NetworkInterfaceDetails$PublicDnsName' => '<p>The public DNS name of the network interface.</p>', 'AwsEc2NetworkInterfaceDetails$PublicIp' => '<p>The address of the Elastic IP address bound to the network interface.</p>', 'AwsEc2NetworkInterfaceIpV6AddressDetail$IpV6Address' => '<p>The IPV6 address.</p>', 'AwsEc2NetworkInterfacePrivateIpAddressDetail$PrivateIpAddress' => '<p>The IP address.</p>', 'AwsEc2NetworkInterfacePrivateIpAddressDetail$PrivateDnsName' => '<p>The private DNS name for the IP address.</p>', 'AwsEc2NetworkInterfaceSecurityGroup$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2NetworkInterfaceSecurityGroup$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2RouteTableDetails$OwnerId' => '<p> The ID of the Amazon Web Services account that owns the route table. </p>', 'AwsEc2RouteTableDetails$RouteTableId' => '<p> The ID of the route table. </p>', 'AwsEc2RouteTableDetails$VpcId' => '<p> The ID of the virtual private cloud (VPC). </p>', 'AwsEc2SecurityGroupDetails$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2SecurityGroupDetails$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2SecurityGroupDetails$OwnerId' => '<p>The Amazon Web Services account ID of the owner of the security group.</p>', 'AwsEc2SecurityGroupDetails$VpcId' => '<p>[VPC only] The ID of the VPC for the security group.</p>', 'AwsEc2SecurityGroupIpPermission$IpProtocol' => '<p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p> <p>[VPC only] Use <code>-1</code> to specify all protocols.</p> <p>When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify.</p> <p>For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.</p> <p>For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types and codes is allowed. </p>', 'AwsEc2SecurityGroupIpRange$CidrIp' => '<p>The IPv4 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify a single IPv4 address, use the /32 prefix length.</p>', 'AwsEc2SecurityGroupIpv6Range$CidrIpv6' => '<p>The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify a single IPv6 address, use the /128 prefix length.</p>', 'AwsEc2SecurityGroupPrefixListId$PrefixListId' => '<p>The ID of the prefix.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$PeeringStatus' => '<p>The status of a VPC peering connection, if applicable.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$UserId' => '<p>The ID of an Amazon Web Services account.</p> <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p> <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another VPC. </p>', 'AwsEc2SecurityGroupUserIdGroupPair$VpcId' => '<p>The ID of the VPC for the referenced security group, if applicable.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection, if applicable.</p>', 'AwsEc2SubnetDetails$AvailabilityZone' => '<p>The Availability Zone for the subnet.</p>', 'AwsEc2SubnetDetails$AvailabilityZoneId' => '<p>The identifier of the Availability Zone for the subnet.</p>', 'AwsEc2SubnetDetails$CidrBlock' => '<p>The IPV4 CIDR block that is assigned to the subnet.</p>', 'AwsEc2SubnetDetails$OwnerId' => '<p>The identifier of the Amazon Web Services account that owns the subnet.</p>', 'AwsEc2SubnetDetails$State' => '<p>The current state of the subnet. Valid values are <code>available</code> or <code>pending</code>.</p>', 'AwsEc2SubnetDetails$SubnetArn' => '<p>The ARN of the subnet.</p>', 'AwsEc2SubnetDetails$SubnetId' => '<p>The identifier of the subnet.</p>', 'AwsEc2SubnetDetails$VpcId' => '<p>The identifier of the VPC that contains the subnet.</p>', 'AwsEc2TransitGatewayDetails$Id' => '<p>The ID of the transit gateway. </p>', 'AwsEc2TransitGatewayDetails$Description' => '<p>The description of the transit gateway. </p>', 'AwsEc2TransitGatewayDetails$DefaultRouteTablePropagation' => '<p>Turn on or turn off automatic propagation of routes to the default propagation route table. </p>', 'AwsEc2TransitGatewayDetails$AutoAcceptSharedAttachments' => '<p>Turn on or turn off automatic acceptance of attachment requests. </p>', 'AwsEc2TransitGatewayDetails$DefaultRouteTableAssociation' => '<p>Turn on or turn off automatic association with the default association route table. </p>', 'AwsEc2TransitGatewayDetails$AssociationDefaultRouteTableId' => '<p>The ID of the default association route table. </p>', 'AwsEc2TransitGatewayDetails$PropagationDefaultRouteTableId' => '<p>The ID of the default propagation route table. </p>', 'AwsEc2TransitGatewayDetails$VpnEcmpSupport' => '<p>Turn on or turn off Equal Cost Multipath Protocol (ECMP) support. </p>', 'AwsEc2TransitGatewayDetails$DnsSupport' => '<p>Turn on or turn off DNS support. </p>', 'AwsEc2TransitGatewayDetails$MulticastSupport' => '<p>Indicates whether multicast is supported on the transit gateway. </p>', 'AwsEc2VolumeAttachment$AttachTime' => '<p>The datetime when the attachment initiated.</p>', 'AwsEc2VolumeAttachment$InstanceId' => '<p>The identifier of the EC2 instance.</p>', 'AwsEc2VolumeAttachment$Status' => '<p>The attachment state of the volume. Valid values are as follows:</p> <ul> <li> <p> <code>attaching</code> </p> </li> <li> <p> <code>attached</code> </p> </li> <li> <p> <code>busy</code> </p> </li> <li> <p> <code>detaching</code> </p> </li> <li> <p> <code>detached</code> </p> </li> </ul>', 'AwsEc2VolumeDetails$CreateTime' => '<p>Indicates when the volume was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsEc2VolumeDetails$DeviceName' => '<p>The device name for the volume that is attached to the instance. </p>', 'AwsEc2VolumeDetails$SnapshotId' => '<p>The snapshot from which the volume was created.</p>', 'AwsEc2VolumeDetails$Status' => '<p>The volume state. Valid values are as follows:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>creating</code> </p> </li> <li> <p> <code>deleted</code> </p> </li> <li> <p> <code>deleting</code> </p> </li> <li> <p> <code>error</code> </p> </li> <li> <p> <code>in-use</code> </p> </li> </ul>', 'AwsEc2VolumeDetails$KmsKeyId' => '<p>The ARN of the KMS key that was used to protect the volume encryption key for the volume.</p>', 'AwsEc2VolumeDetails$VolumeId' => '<p>The ID of the volume. </p>', 'AwsEc2VolumeDetails$VolumeType' => '<p>The volume type. </p>', 'AwsEc2VolumeDetails$VolumeScanStatus' => '<p>Indicates whether the volume was scanned or skipped. </p>', 'AwsEc2VpcDetails$DhcpOptionsId' => '<p>The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated with the VPC. If the default options are associated with the VPC, then this is default.</p>', 'AwsEc2VpcDetails$State' => '<p>The current state of the VPC. Valid values are <code>available</code> or <code>pending</code>.</p>', 'AwsEc2VpcEndpointServiceDetails$PrivateDnsName' => '<p>The private DNS name for the service.</p>', 'AwsEc2VpcEndpointServiceDetails$ServiceId' => '<p>The identifier of the service.</p>', 'AwsEc2VpcEndpointServiceDetails$ServiceName' => '<p>The name of the service.</p>', 'AwsEc2VpcEndpointServiceDetails$ServiceState' => '<p>The current state of the service. Valid values are as follows:</p> <ul> <li> <p> <code>Available</code> </p> </li> <li> <p> <code>Deleted</code> </p> </li> <li> <p> <code>Deleting</code> </p> </li> <li> <p> <code>Failed</code> </p> </li> <li> <p> <code>Pending</code> </p> </li> </ul>', 'AwsEc2VpcEndpointServiceServiceTypeDetails$ServiceType' => '<p>The type of service.</p>', 'AwsEc2VpcPeeringConnectionDetails$ExpirationTime' => '<p>The time at which an unaccepted VPC peering connection will expire. </p>', 'AwsEc2VpcPeeringConnectionDetails$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection. </p>', 'AwsEc2VpcPeeringConnectionStatusDetails$Code' => '<p>The status of the VPC peering connection. </p>', 'AwsEc2VpcPeeringConnectionStatusDetails$Message' => '<p>A message that provides more information about the status, if applicable. </p>', 'AwsEc2VpcPeeringConnectionVpcInfoDetails$CidrBlock' => '<p>The IPv4 CIDR block for the VPC. </p>', 'AwsEc2VpcPeeringConnectionVpcInfoDetails$OwnerId' => '<p>The ID of the Amazon Web Services account that owns the VPC. </p>', 'AwsEc2VpcPeeringConnectionVpcInfoDetails$Region' => '<p>The Amazon Web Services Region in which the VPC is located. </p>', 'AwsEc2VpcPeeringConnectionVpcInfoDetails$VpcId' => '<p>The ID of the VPC. </p>', 'AwsEc2VpnConnectionDetails$VpnConnectionId' => '<p>The identifier of the VPN connection.</p>', 'AwsEc2VpnConnectionDetails$State' => '<p>The current state of the VPN connection. Valid values are as follows:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>deleted</code> </p> </li> <li> <p> <code>deleting</code> </p> </li> <li> <p> <code>pending</code> </p> </li> </ul>', 'AwsEc2VpnConnectionDetails$CustomerGatewayId' => '<p>The identifier of the customer gateway that is at your end of the VPN connection.</p>', 'AwsEc2VpnConnectionDetails$CustomerGatewayConfiguration' => '<p>The configuration information for the VPN connection\'s customer gateway, in the native XML format.</p>', 'AwsEc2VpnConnectionDetails$Type' => '<p>The type of VPN connection.</p>', 'AwsEc2VpnConnectionDetails$VpnGatewayId' => '<p>The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN connection.</p>', 'AwsEc2VpnConnectionDetails$Category' => '<p>The category of the VPN connection. <code>VPN</code> indicates an Amazon Web Services VPN connection. <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.</p>', 'AwsEc2VpnConnectionDetails$TransitGatewayId' => '<p>The identifier of the transit gateway that is associated with the VPN connection.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$OutsideIpAddress' => '<p>The external IP address of the VPN tunnel.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$PreSharedKey' => '<p>The preshared key to establish initial authentication between the virtual private gateway and the customer gateway.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$TunnelInsideCidr' => '<p>The range of inside IPv4 addresses for the tunnel.</p>', 'AwsEc2VpnConnectionRoutesDetails$DestinationCidrBlock' => '<p>The CIDR block associated with the local subnet of the customer data center.</p>', 'AwsEc2VpnConnectionRoutesDetails$State' => '<p>The current state of the static route.</p>', 'AwsEc2VpnConnectionVgwTelemetryDetails$CertificateArn' => '<p>The ARN of the VPN tunnel endpoint certificate.</p>', 'AwsEc2VpnConnectionVgwTelemetryDetails$LastStatusChange' => '<p>The date and time of the last change in status.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsEc2VpnConnectionVgwTelemetryDetails$OutsideIpAddress' => '<p>The Internet-routable IP address of the virtual private gateway\'s outside interface.</p>', 'AwsEc2VpnConnectionVgwTelemetryDetails$Status' => '<p>The status of the VPN tunnel. Valid values are <code>DOWN</code> or <code>UP</code>.</p>', 'AwsEc2VpnConnectionVgwTelemetryDetails$StatusMessage' => '<p>If an error occurs, a description of the error.</p>', 'AwsEcrContainerImageDetails$RegistryId' => '<p>The Amazon Web Services account identifier that is associated with the registry that the image belongs to.</p>', 'AwsEcrContainerImageDetails$RepositoryName' => '<p>The name of the repository that the image belongs to.</p>', 'AwsEcrContainerImageDetails$Architecture' => '<p>The architecture of the image. Valid values are as follows:</p> <ul> <li> <p> <code>arm64</code> </p> </li> <li> <p> <code>i386</code> </p> </li> <li> <p> <code>x86_64</code> </p> </li> </ul>', 'AwsEcrContainerImageDetails$ImageDigest' => '<p>The sha256 digest of the image manifest.</p>', 'AwsEcrContainerImageDetails$ImagePublishedAt' => '<p>The date and time when the image was pushed to the repository.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsEcrRepositoryDetails$Arn' => '<p>The ARN of the repository.</p>', 'AwsEcrRepositoryDetails$ImageTagMutability' => '<p>The tag mutability setting for the repository. Valid values are <code>IMMUTABLE</code> or <code>MUTABLE</code>.</p>', 'AwsEcrRepositoryDetails$RepositoryName' => '<p>The name of the repository.</p>', 'AwsEcrRepositoryDetails$RepositoryPolicyText' => '<p>The text of the repository policy.</p>', 'AwsEcrRepositoryLifecyclePolicyDetails$LifecyclePolicyText' => '<p>The text of the lifecycle policy.</p>', 'AwsEcrRepositoryLifecyclePolicyDetails$RegistryId' => '<p>The Amazon Web Services account identifier that is associated with the registry that contains the repository.</p>', 'AwsEcsClusterClusterSettingsDetails$Name' => '<p>The name of the setting. The valid value is <code>containerInsights</code>.</p>', 'AwsEcsClusterClusterSettingsDetails$Value' => '<p>The value of the setting. Valid values are <code>disabled</code> or <code>enabled</code>.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails$KmsKeyId' => '<p>The identifier of the KMS key that is used to encrypt the data between the local client and the container.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationDetails$Logging' => '<p>The log setting to use for redirecting logs for run command results.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails$CloudWatchLogGroupName' => '<p>The name of the CloudWatch log group to send the logs to.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails$S3BucketName' => '<p>The name of the S3 bucket to send logs to.</p>', 'AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails$S3KeyPrefix' => '<p>Identifies the folder in the S3 bucket to send the logs to.</p>', 'AwsEcsClusterDefaultCapacityProviderStrategyDetails$CapacityProvider' => '<p>The name of the capacity provider.</p>', 'AwsEcsClusterDetails$ClusterArn' => '<p>The Amazon Resource Name (ARN) that identifies the cluster. </p>', 'AwsEcsClusterDetails$ClusterName' => '<p>A name that you use to identify your cluster. </p>', 'AwsEcsClusterDetails$Status' => '<p>The status of the cluster. </p>', 'AwsEcsContainerDetails$Name' => '<p>The name of the container. </p>', 'AwsEcsContainerDetails$Image' => '<p>The image used for the container. </p>', 'AwsEcsServiceCapacityProviderStrategyDetails$CapacityProvider' => '<p>The short name of the capacity provider.</p>', 'AwsEcsServiceDeploymentControllerDetails$Type' => '<p>The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container with the latest version.</p> <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is powered by CodeDeploy. This deployment model a new deployment of a service can be verified before production traffic is sent to it.</p> <p>The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</p> <p>Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code> </p>', 'AwsEcsServiceDetails$Cluster' => '<p>The ARN of the cluster that hosts the service.</p>', 'AwsEcsServiceDetails$LaunchType' => '<p>The launch type that the service uses.</p> <p>Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code> </p>', 'AwsEcsServiceDetails$Name' => '<p>The name of the service.</p>', 'AwsEcsServiceDetails$PlatformVersion' => '<p>The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the <code>LATEST</code> platform version is used by default.</p>', 'AwsEcsServiceDetails$PropagateTags' => '<p>Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.</p> <p>Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code> </p>', 'AwsEcsServiceDetails$Role' => '<p>The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.</p>', 'AwsEcsServiceDetails$SchedulingStrategy' => '<p>The scheduling strategy to use for the service.</p> <p>The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.</p> <p>The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.</p> <p>Valid values: <code>REPLICA</code> | <code>DAEMON</code> </p>', 'AwsEcsServiceDetails$ServiceArn' => '<p>The ARN of the service.</p>', 'AwsEcsServiceDetails$ServiceName' => '<p>The name of the service.</p> <p>The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.</p>', 'AwsEcsServiceDetails$TaskDefinition' => '<p>The task definition to use for tasks in the service.</p>', 'AwsEcsServiceLoadBalancersDetails$ContainerName' => '<p>The name of the container to associate with the load balancer.</p>', 'AwsEcsServiceLoadBalancersDetails$LoadBalancerName' => '<p>The name of the load balancer to associate with the Amazon ECS service or task set.</p> <p>Only specified when using a Classic Load Balancer. For an Application Load Balancer or a Network Load Balancer, the load balancer name is omitted.</p>', 'AwsEcsServiceLoadBalancersDetails$TargetGroupArn' => '<p>The ARN of the Elastic Load Balancing target group or groups associated with a service or task set.</p> <p>Only specified when using an Application Load Balancer or a Network Load Balancer. For a Classic Load Balancer, the target group ARN is omitted.</p>', 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails$AssignPublicIp' => '<p>Whether the task\'s elastic network interface receives a public IP address. The default value is <code>DISABLED</code>.</p> <p>Valid values: <code>ENABLED</code> | <code>DISABLED</code> </p>', 'AwsEcsServicePlacementConstraintsDetails$Expression' => '<p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>.</p>', 'AwsEcsServicePlacementConstraintsDetails$Type' => '<p>The type of constraint. Use <code>distinctInstance</code> to run each task in a particular group on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.</p> <p>Valid values: <code>distinctInstance</code> | <code>memberOf</code> </p>', 'AwsEcsServicePlacementStrategiesDetails$Field' => '<p>The field to apply the placement strategy against.</p> <p>For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as <code>attribute:ecs.availability-zone</code>.</p> <p>For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.</p> <p>For the <code>random</code> placement strategy, this attribute is not used.</p>', 'AwsEcsServicePlacementStrategiesDetails$Type' => '<p>The type of placement strategy.</p> <p>The <code>random</code> placement strategy randomly places tasks on available candidates.</p> <p>The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the value of <code>Field</code>.</p> <p>The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that is specified in <code>Field</code>.</p> <p>Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code> </p>', 'AwsEcsServiceServiceRegistriesDetails$ContainerName' => '<p>The container name value to use for the service discovery service.</p> <p>If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify <code>ContainerName</code> and <code>ContainerPort</code>.</p> <p>If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.</p>', 'AwsEcsServiceServiceRegistriesDetails$RegistryArn' => '<p>The ARN of the service registry.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails$Condition' => '<p>The dependency condition of the dependent container. Indicates the required status of the dependent container before the current container can start. Valid values are as follows:</p> <ul> <li> <p> <code>COMPLETE</code> </p> </li> <li> <p> <code>HEALTHY</code> </p> </li> <li> <p> <code>SUCCESS</code> </p> </li> <li> <p> <code>START</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails$ContainerName' => '<p>The name of the dependent container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Hostname' => '<p>The hostname to use for the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Image' => '<p>The image used to start the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Name' => '<p>The name of the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$User' => '<p>The user to use inside the container.</p> <p>The value can use one of the following formats.</p> <ul> <li> <p> <code> <i>user</i> </code> </p> </li> <li> <p> <code> <i>user</i> </code>:<code> <i>group</i> </code> </p> </li> <li> <p> <code> <i>uid</i> </code> </p> </li> <li> <p> <code> <i>uid</i> </code>:<code> <i>gid</i> </code> </p> </li> <li> <p> <code> <i>user</i> </code>:<code> <i>gid</i> </code> </p> </li> <li> <p> <code> <i>uid</i> </code>:<code> <i>group</i> </code> </p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$WorkingDirectory' => '<p>The working directory in which to run commands inside the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails$Name' => '<p>The name of the environment variable.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails$Value' => '<p>The value of the environment variable.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails$Type' => '<p>The type of environment file. The valid value is <code>s3</code>.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails$Value' => '<p>The ARN of the S3 object that contains the environment variable file.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails$Hostname' => '<p>The hostname to use in the <b>/etc/hosts</b> entry.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails$IpAddress' => '<p>The IP address to use in the <b>/etc/hosts</b> entry.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails$Type' => '<p>The log router to use. Valid values are <code>fluentbit</code> or <code>fluentd</code>.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails$ContainerPath' => '<p>The path inside the container at which to expose the host device.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails$HostPath' => '<p>The path for the device on the host container instance.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails$ContainerPath' => '<p>The absolute file path where the tmpfs volume is to be mounted.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails$LogDriver' => '<p>The log driver to use for the container.</p> <p>Valid values on Fargate are as follows:</p> <ul> <li> <p> <code>awsfirelens</code> </p> </li> <li> <p> <code>awslogs</code> </p> </li> <li> <p> <code>splunk</code> </p> </li> </ul> <p>Valid values on Amazon EC2 are as follows:</p> <ul> <li> <p> <code>awsfirelens</code> </p> </li> <li> <p> <code>awslogs</code> </p> </li> <li> <p> <code>fluentd</code> </p> </li> <li> <p> <code>gelf</code> </p> </li> <li> <p> <code>journald</code> </p> </li> <li> <p> <code>json-file</code> </p> </li> <li> <p> <code>logentries</code> </p> </li> <li> <p> <code>splunk</code> </p> </li> <li> <p> <code>syslog</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails$Name' => '<p>The name of the secret.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails$ValueFrom' => '<p>The secret to expose to the container.</p> <p>The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the Systems Manager Parameter Store.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails$ContainerPath' => '<p>The path on the container to mount the host volume at.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails$SourceVolume' => '<p>The name of the volume to mount. Must match the name of a volume listed in <code>VolumeDetails</code> for the task definition.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails$Protocol' => '<p>The protocol used for the port mapping. The default is <code>tcp</code>.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails$CredentialsParameter' => '<p>The ARN of the secret that contains the private repository credentials.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails$Type' => '<p>The type of resource to assign to a container. Valid values are <code>GPU</code> or <code>InferenceAccelerator</code>.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails$Value' => '<p>The value for the specified resource type.</p> <p>For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container.</p> <p>For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry in <code>InferenceAccelerators</code>.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails$Name' => '<p>The name of the secret.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails$ValueFrom' => '<p>The secret to expose to the container. The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the Systems Manager Parameter Store.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails$Namespace' => '<p>The namespaced kernel parameter for which to set a value.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails$Value' => '<p>The value of the parameter.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails$Name' => '<p>The type of the ulimit. Valid values are as follows:</p> <ul> <li> <p> <code>core</code> </p> </li> <li> <p> <code>cpu</code> </p> </li> <li> <p> <code>data</code> </p> </li> <li> <p> <code>fsize</code> </p> </li> <li> <p> <code>locks</code> </p> </li> <li> <p> <code>memlock</code> </p> </li> <li> <p> <code>msgqueue</code> </p> </li> <li> <p> <code>nice</code> </p> </li> <li> <p> <code>nofile</code> </p> </li> <li> <p> <code>nproc</code> </p> </li> <li> <p> <code>rss</code> </p> </li> <li> <p> <code>rtprio</code> </p> </li> <li> <p> <code>rttime</code> </p> </li> <li> <p> <code>sigpending</code> </p> </li> <li> <p> <code>stack</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails$SourceContainer' => '<p>The name of another container within the same task definition from which to mount volumes.</p>', 'AwsEcsTaskDefinitionDetails$Cpu' => '<p>The number of CPU units used by the task.Valid values are as follows:</p> <ul> <li> <p> <code>256 (.25 vCPU)</code> </p> </li> <li> <p> <code>512 (.5 vCPU)</code> </p> </li> <li> <p> <code>1024 (1 vCPU)</code> </p> </li> <li> <p> <code>2048 (2 vCPU)</code> </p> </li> <li> <p> <code>4096 (4 vCPU)</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionDetails$ExecutionRoleArn' => '<p>The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.</p>', 'AwsEcsTaskDefinitionDetails$Family' => '<p>The name of a family that this task definition is registered to.</p>', 'AwsEcsTaskDefinitionDetails$IpcMode' => '<p>The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid values are as follows:</p> <ul> <li> <p> <code>host</code> </p> </li> <li> <p> <code>none</code> </p> </li> <li> <p> <code>task</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionDetails$Memory' => '<p>The amount (in MiB) of memory used by the task. </p> <p>For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level memory value. For tasks that are hosted on Fargate, you must use one of the <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size">specified values</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>, which determines your range of supported values for the <code>Cpu</code> and <code>Memory</code> parameters.</p>', 'AwsEcsTaskDefinitionDetails$NetworkMode' => '<p>The Docker networking mode to use for the containers in the task. Valid values are as follows:</p> <ul> <li> <p> <code>awsvpc</code> </p> </li> <li> <p> <code>bridge</code> </p> </li> <li> <p> <code>host</code> </p> </li> <li> <p> <code>none</code> </p> </li> </ul>', 'AwsEcsTaskDefinitionDetails$PidMode' => '<p>The process namespace to use for the containers in the task. Valid values are <code>host</code> or <code>task</code>.</p>', 'AwsEcsTaskDefinitionDetails$TaskRoleArn' => '<p>The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.</p>', 'AwsEcsTaskDefinitionDetails$Status' => '<p> The status of the task definition. </p>', 'AwsEcsTaskDefinitionInferenceAcceleratorsDetails$DeviceName' => '<p>The Elastic Inference accelerator device name.</p>', 'AwsEcsTaskDefinitionInferenceAcceleratorsDetails$DeviceType' => '<p>The Elastic Inference accelerator type to use.</p>', 'AwsEcsTaskDefinitionPlacementConstraintsDetails$Expression' => '<p>A cluster query language expression to apply to the constraint.</p>', 'AwsEcsTaskDefinitionPlacementConstraintsDetails$Type' => '<p>The type of constraint.</p>', 'AwsEcsTaskDefinitionProxyConfigurationDetails$ContainerName' => '<p>The name of the container that will serve as the App Mesh proxy.</p>', 'AwsEcsTaskDefinitionProxyConfigurationDetails$Type' => '<p>The proxy type.</p>', 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails$Name' => '<p>The name of the property.</p>', 'AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails$Value' => '<p>The value of the property.</p>', 'AwsEcsTaskDefinitionVolumesDetails$Name' => '<p>The name of the data volume.</p>', 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails$Driver' => '<p>The Docker volume driver to use.</p>', 'AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails$Scope' => '<p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are shared persist after the task stops. Valid values are <code>shared</code> or <code>task</code>.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails$AccessPointId' => '<p>The Amazon EFS access point identifier to use.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails$Iam' => '<p>Whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails$FilesystemId' => '<p>The Amazon EFS file system identifier to use.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails$RootDirectory' => '<p>The directory within the Amazon EFS file system to mount as the root directory inside the host.</p>', 'AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails$TransitEncryption' => '<p>Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. </p>', 'AwsEcsTaskDefinitionVolumesHostDetails$SourcePath' => '<p>The path on the host container instance that is presented to the container.</p>', 'AwsEcsTaskDetails$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster that hosts the task. </p>', 'AwsEcsTaskDetails$TaskDefinitionArn' => '<p>The ARN of the task definition that creates the task. </p>', 'AwsEcsTaskDetails$Version' => '<p>The version counter for the task. </p>', 'AwsEcsTaskDetails$CreatedAt' => '<p>The Unix timestamp for the time when the task was created. More specifically, it\'s for the time when the task entered the <code>PENDING</code> state. </p>', 'AwsEcsTaskDetails$StartedAt' => '<p>The Unix timestamp for the time when the task started. More specifically, it\'s for the time when the task transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state. </p>', 'AwsEcsTaskDetails$StartedBy' => '<p>The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code> parameter contains the deployment ID of that service. </p>', 'AwsEcsTaskDetails$Group' => '<p>The name of the task group that\'s associated with the task. </p>', 'AwsEcsTaskVolumeDetails$Name' => '<p>The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition <code>mountPoints</code>. </p>', 'AwsEcsTaskVolumeHostDetails$SourcePath' => '<p>When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on the host container instance that\'s presented to the container. </p>', 'AwsEfsAccessPointDetails$AccessPointId' => '<p>The ID of the Amazon EFS access point. </p>', 'AwsEfsAccessPointDetails$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon EFS access point. </p>', 'AwsEfsAccessPointDetails$ClientToken' => '<p>The opaque string specified in the request to ensure idempotent creation. </p>', 'AwsEfsAccessPointDetails$FileSystemId' => '<p>The ID of the Amazon EFS file system that the access point applies to. </p>', 'AwsEfsAccessPointPosixUserDetails$Gid' => '<p>The POSIX group ID used for all file system operations using this access point. </p>', 'AwsEfsAccessPointPosixUserDetails$Uid' => '<p>The POSIX user ID used for all file system operations using this access point. </p>', 'AwsEfsAccessPointRootDirectoryCreationInfoDetails$OwnerGid' => '<p>Specifies the POSIX group ID to apply to the root directory. </p>', 'AwsEfsAccessPointRootDirectoryCreationInfoDetails$OwnerUid' => '<p>Specifies the POSIX user ID to apply to the root directory. </p>', 'AwsEfsAccessPointRootDirectoryCreationInfoDetails$Permissions' => '<p>Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the file\'s mode bits. </p>', 'AwsEfsAccessPointRootDirectoryDetails$Path' => '<p>Specifies the path on the Amazon EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide <code>CreationInfo</code>. </p>', 'AwsEksClusterDetails$Arn' => '<p>The ARN of the cluster.</p>', 'AwsEksClusterDetails$CertificateAuthorityData' => '<p>The certificate authority data for the cluster.</p>', 'AwsEksClusterDetails$ClusterStatus' => '<p>The status of the cluster. Valid values are as follows:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATING</code> </p> </li> <li> <p> <code>DELETING</code> </p> </li> <li> <p> <code>FAILED</code> </p> </li> <li> <p> <code>PENDING</code> </p> </li> <li> <p> <code>UPDATING</code> </p> </li> </ul>', 'AwsEksClusterDetails$Endpoint' => '<p>The endpoint for the Amazon EKS API server.</p>', 'AwsEksClusterDetails$Name' => '<p>The name of the cluster.</p>', 'AwsEksClusterDetails$RoleArn' => '<p>The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon Web Services API operations on your behalf.</p>', 'AwsEksClusterDetails$Version' => '<p>The Amazon EKS server version for the cluster.</p>', 'AwsElasticBeanstalkEnvironmentDetails$ApplicationName' => '<p>The name of the application that is associated with the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$Cname' => '<p>The URL to the CNAME for this environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$DateCreated' => '<p>The creation date for this environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$DateUpdated' => '<p>The date when this environment was last modified.</p>', 'AwsElasticBeanstalkEnvironmentDetails$Description' => '<p>A description of the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$EndpointUrl' => '<p>For load-balanced, autoscaling environments, the URL to the load balancer. For single-instance environments, the IP address of the instance.</p>', 'AwsElasticBeanstalkEnvironmentDetails$EnvironmentArn' => '<p>The ARN of the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$EnvironmentId' => '<p>The identifier of the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$EnvironmentName' => '<p>The name of the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$PlatformArn' => '<p>The ARN of the platform version for the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$SolutionStackName' => '<p>The name of the solution stack that is deployed with the environment.</p>', 'AwsElasticBeanstalkEnvironmentDetails$Status' => '<p>The current operational status of the environment. Valid values are as follows:</p> <ul> <li> <p> <code>Aborting</code> </p> </li> <li> <p> <code>Launching</code> </p> </li> <li> <p> <code>LinkingFrom</code> </p> </li> <li> <p> <code>LinkingTo</code> </p> </li> <li> <p> <code>Ready</code> </p> </li> <li> <p> <code>Terminated</code> </p> </li> <li> <p> <code>Terminating</code> </p> </li> <li> <p> <code>Updating</code> </p> </li> </ul>', 'AwsElasticBeanstalkEnvironmentDetails$VersionLabel' => '<p>The application version of the environment.</p>', 'AwsElasticBeanstalkEnvironmentEnvironmentLink$EnvironmentName' => '<p>The name of the linked environment.</p>', 'AwsElasticBeanstalkEnvironmentEnvironmentLink$LinkName' => '<p>The name of the environment link.</p>', 'AwsElasticBeanstalkEnvironmentOptionSetting$Namespace' => '<p>The type of resource that the configuration option is associated with.</p>', 'AwsElasticBeanstalkEnvironmentOptionSetting$OptionName' => '<p>The name of the option.</p>', 'AwsElasticBeanstalkEnvironmentOptionSetting$ResourceName' => '<p>The name of the resource.</p>', 'AwsElasticBeanstalkEnvironmentOptionSetting$Value' => '<p>The value of the configuration setting.</p>', 'AwsElasticBeanstalkEnvironmentTier$Name' => '<p>The name of the environment tier. Valid values are <code>WebServer</code> or <code>Worker</code>.</p>', 'AwsElasticBeanstalkEnvironmentTier$Type' => '<p>The type of environment tier. Valid values are <code>Standard</code> or <code>SQS/HTTP</code>.</p>', 'AwsElasticBeanstalkEnvironmentTier$Version' => '<p>The version of the environment tier.</p>', 'AwsElasticsearchDomainDetails$AccessPolicies' => '<p>IAM policy document specifying the access policies for the new Elasticsearch domain.</p>', 'AwsElasticsearchDomainDetails$DomainId' => '<p>Unique identifier for an Elasticsearch domain.</p>', 'AwsElasticsearchDomainDetails$DomainName' => '<p>Name of an Elasticsearch domain.</p> <p>Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.</p> <p>Domain names must start with a lowercase letter and must be between 3 and 28 characters.</p> <p>Valid characters are a-z (lowercase only), 0-9, and – (hyphen). </p>', 'AwsElasticsearchDomainDetails$Endpoint' => '<p>Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch domain.</p> <p>The endpoint is a service URL. </p>', 'AwsElasticsearchDomainDetails$ElasticsearchVersion' => '<p>OpenSearch version.</p>', 'AwsElasticsearchDomainDomainEndpointOptions$TLSSecurityPolicy' => '<p>The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.</p> <p>Valid values:</p> <ul> <li> <p> <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher</p> </li> <li> <p> <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2</p> </li> </ul>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$DedicatedMasterType' => '<p>The hardware configuration of the computer that hosts the dedicated master node. A sample value is <code>m3.medium.elasticsearch</code>. If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p> <p>For a list of valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer Guide</i>.</p>', 'AwsElasticsearchDomainElasticsearchClusterConfigDetails$InstanceType' => '<p>The instance type for your data nodes. For example, <code>m3.medium.elasticsearch</code>.</p> <p>For a list of valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer Guide</i>.</p>', 'AwsElasticsearchDomainEncryptionAtRestOptions$KmsKeyId' => '<p>The KMS key ID. Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code>.</p>', 'AwsElasticsearchDomainLogPublishingOptionsLogConfig$CloudWatchLogsLogGroupArn' => '<p>The ARN of the CloudWatch Logs group to publish the logs to.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$AutomatedUpdateDate' => '<p>The epoch time when the deployment window closes for required updates. After this time, Amazon OpenSearch Service schedules the software upgrade automatically.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$CurrentVersion' => '<p>The version of the service software that is currently installed on the domain.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$Description' => '<p>A more detailed description of the service software status.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$NewVersion' => '<p>The most recent version of the service software.</p>', 'AwsElasticsearchDomainServiceSoftwareOptions$UpdateStatus' => '<p>The status of the service software update. Valid values are as follows:</p> <ul> <li> <p> <code>COMPLETED</code> </p> </li> <li> <p> <code>ELIGIBLE</code> </p> </li> <li> <p> <code>IN_PROGRESS</code> </p> </li> <li> <p> <code>NOT_ELIGIBLE</code> </p> </li> <li> <p> <code>PENDING_UPDATE</code> </p> </li> </ul>', 'AwsElasticsearchDomainVPCOptions$VPCId' => '<p>ID for the VPC.</p>', 'AwsElbAppCookieStickinessPolicy$CookieName' => '<p>The name of the application cookie used for stickiness.</p>', 'AwsElbAppCookieStickinessPolicy$PolicyName' => '<p>The mnemonic name for the policy being created. The name must be unique within the set of policies for the load balancer.</p>', 'AwsElbLbCookieStickinessPolicy$PolicyName' => '<p>The name of the policy. The name must be unique within the set of policies for the load balancer.</p>', 'AwsElbLoadBalancerAccessLog$S3BucketName' => '<p>The name of the S3 bucket where the access logs are stored.</p>', 'AwsElbLoadBalancerAccessLog$S3BucketPrefix' => '<p>The logical hierarchy that was created for the S3 bucket.</p> <p>If a prefix is not provided, the log is placed at the root level of the bucket.</p>', 'AwsElbLoadBalancerAdditionalAttribute$Key' => '<p>The name of the attribute.</p>', 'AwsElbLoadBalancerAdditionalAttribute$Value' => '<p>The value of the attribute.</p>', 'AwsElbLoadBalancerDetails$CanonicalHostedZoneName' => '<p>The name of the Amazon Route 53 hosted zone for the load balancer.</p>', 'AwsElbLoadBalancerDetails$CanonicalHostedZoneNameID' => '<p>The ID of the Amazon Route 53 hosted zone for the load balancer.</p>', 'AwsElbLoadBalancerDetails$CreatedTime' => '<p>Indicates when the load balancer was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsElbLoadBalancerDetails$DnsName' => '<p>The DNS name of the load balancer.</p>', 'AwsElbLoadBalancerDetails$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'AwsElbLoadBalancerDetails$Scheme' => '<p>The type of load balancer. Only provided if the load balancer is in a VPC.</p> <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves to a public IP address.</p> <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a private IP address.</p>', 'AwsElbLoadBalancerDetails$VpcId' => '<p>The identifier of the VPC for the load balancer.</p>', 'AwsElbLoadBalancerHealthCheck$Target' => '<p>The instance that is being checked. The target specifies the protocol and port. The available protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.</p> <p>For the HTTP and HTTPS protocols, the target also specifies the ping path.</p> <p>For the TCP protocol, the target is specified as <code>TCP: <i>&lt;port&gt;</i> </code>.</p> <p>For the SSL protocol, the target is specified as <code>SSL.<i>&lt;port&gt;</i> </code>.</p> <p>For the HTTP and HTTPS protocols, the target is specified as <code> <i>&lt;protocol&gt;</i>:<i>&lt;port&gt;</i>/<i>&lt;path to ping&gt;</i> </code>.</p>', 'AwsElbLoadBalancerInstance$InstanceId' => '<p>The instance identifier.</p>', 'AwsElbLoadBalancerListener$InstanceProtocol' => '<p>The protocol to use to route traffic to instances.</p> <p>Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code> </p>', 'AwsElbLoadBalancerListener$Protocol' => '<p>The load balancer transport protocol to use for routing.</p> <p>Valid values: <code>HTTP</code> | <code>HTTPS</code> | <code>TCP</code> | <code>SSL</code> </p>', 'AwsElbLoadBalancerListener$SslCertificateId' => '<p>The ARN of the server certificate.</p>', 'AwsElbLoadBalancerSourceSecurityGroup$GroupName' => '<p>The name of the security group.</p>', 'AwsElbLoadBalancerSourceSecurityGroup$OwnerAlias' => '<p>The owner of the security group.</p>', 'AwsElbv2LoadBalancerAttribute$Key' => '<p>The name of the load balancer attribute.</p>', 'AwsElbv2LoadBalancerAttribute$Value' => '<p>The value of the load balancer attribute.</p>', 'AwsElbv2LoadBalancerDetails$CanonicalHostedZoneId' => '<p>The ID of the Amazon Route 53 hosted zone associated with the load balancer.</p>', 'AwsElbv2LoadBalancerDetails$CreatedTime' => '<p>Indicates when the load balancer was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsElbv2LoadBalancerDetails$DNSName' => '<p>The public DNS name of the load balancer.</p>', 'AwsElbv2LoadBalancerDetails$IpAddressType' => '<p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'AwsElbv2LoadBalancerDetails$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses.</p>', 'AwsElbv2LoadBalancerDetails$Type' => '<p>The type of load balancer.</p>', 'AwsElbv2LoadBalancerDetails$VpcId' => '<p>The ID of the VPC for the load balancer.</p>', 'AwsEventSchemasRegistryDetails$Description' => '<p> A description of the registry to be created. </p>', 'AwsEventSchemasRegistryDetails$RegistryArn' => '<p> The Amazon Resource Name (ARN) of the registry. </p>', 'AwsEventSchemasRegistryDetails$RegistryName' => '<p> The name of the schema registry. </p>', 'AwsEventsEndpointDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the endpoint. </p>', 'AwsEventsEndpointDetails$Description' => '<p> A description of the endpoint. </p>', 'AwsEventsEndpointDetails$EndpointId' => '<p> The URL subdomain of the endpoint. For example, if <code>EndpointUrl</code> is <code>https://abcde.veo.endpoints.event.amazonaws.com</code>, then the <code>EndpointId</code> is <code>abcde.veo</code>.</p>', 'AwsEventsEndpointDetails$EndpointUrl' => '<p> The URL of the endpoint.</p>', 'AwsEventsEndpointDetails$Name' => '<p> The name of the endpoint.</p>', 'AwsEventsEndpointDetails$RoleArn' => '<p> The ARN of the role used by event replication for the endpoint.</p>', 'AwsEventsEndpointDetails$State' => '<p> The current state of the endpoint.</p>', 'AwsEventsEndpointDetails$StateReason' => '<p> The reason the endpoint is in its current state.</p>', 'AwsEventsEndpointEventBusesDetails$EventBusArn' => '<p> The Amazon Resource Name (ARN) of the event bus that the endpoint is associated with.</p>', 'AwsEventsEndpointReplicationConfigDetails$State' => '<p> The state of event replication.</p>', 'AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails$HealthCheck' => '<p> The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is triggered.</p>', 'AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails$Route' => '<p> Defines the secondary Region.</p>', 'AwsEventsEventbusDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the account permitted to write events to the current account.</p>', 'AwsEventsEventbusDetails$Name' => '<p> The name of the event bus.</p>', 'AwsEventsEventbusDetails$Policy' => '<p> The policy that enables the external account to send events to your account.</p>', 'AwsGuardDutyDetectorDataSourcesCloudTrailDetails$Status' => '<p> Specifies whether CloudTrail is activated as a data source for the detector. </p>', 'AwsGuardDutyDetectorDataSourcesDnsLogsDetails$Status' => '<p> Describes whether DNS logs is enabled as a data source for the detector. </p>', 'AwsGuardDutyDetectorDataSourcesFlowLogsDetails$Status' => '<p> Describes whether VPC Flow Logs are activated as a data source for the detector. </p>', 'AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails$Status' => '<p> Describes whether Kubernetes audit logs are activated as a data source for the detector. </p>', 'AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails$ServiceRole' => '<p> The GuardDuty Malware Protection service role. </p>', 'AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails$Reason' => '<p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source. </p>', 'AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails$Status' => '<p> Describes whether scanning EBS volumes is activated as a data source for the detector. </p>', 'AwsGuardDutyDetectorDataSourcesS3LogsDetails$Status' => '<p> A value that describes whether S3 data event logs are automatically enabled for new members of an organization. </p>', 'AwsGuardDutyDetectorDetails$FindingPublishingFrequency' => '<p> The publishing frequency of the finding. </p>', 'AwsGuardDutyDetectorDetails$ServiceRole' => '<p> The GuardDuty service role. </p>', 'AwsGuardDutyDetectorDetails$Status' => '<p> The activation status of the detector. </p>', 'AwsGuardDutyDetectorFeaturesDetails$Name' => '<p> Indicates the name of the feature that is activated for the detector. </p>', 'AwsGuardDutyDetectorFeaturesDetails$Status' => '<p> Indicates the status of the feature that is activated for the detector. </p>', 'AwsIamAccessKeyDetails$UserName' => '<p>The user associated with the IAM access key related to a finding.</p> <p>The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because access keys can also be assigned to principals that are not IAM users.</p>', 'AwsIamAccessKeyDetails$CreatedAt' => '<p>Indicates when the IAM access key was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamAccessKeyDetails$PrincipalId' => '<p>The ID of the principal associated with an access key.</p>', 'AwsIamAccessKeyDetails$PrincipalType' => '<p>The type of principal associated with an access key.</p>', 'AwsIamAccessKeyDetails$PrincipalName' => '<p>The name of the principal.</p>', 'AwsIamAccessKeyDetails$AccountId' => '<p>The Amazon Web Services account ID of the account for the key.</p>', 'AwsIamAccessKeyDetails$AccessKeyId' => '<p>The identifier of the access key.</p>', 'AwsIamAccessKeySessionContextAttributes$CreationDate' => '<p>Indicates when the session was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamAccessKeySessionContextSessionIssuer$Type' => '<p>The type of principal (user, role, or group) that created the session.</p>', 'AwsIamAccessKeySessionContextSessionIssuer$PrincipalId' => '<p>The principal ID of the principal (user, role, or group) that created the session.</p>', 'AwsIamAccessKeySessionContextSessionIssuer$Arn' => '<p>The ARN of the session.</p>', 'AwsIamAccessKeySessionContextSessionIssuer$AccountId' => '<p>The identifier of the Amazon Web Services account that created the session.</p>', 'AwsIamAccessKeySessionContextSessionIssuer$UserName' => '<p>The name of the principal that created the session.</p>', 'AwsIamAttachedManagedPolicy$PolicyName' => '<p>The name of the policy.</p>', 'AwsIamAttachedManagedPolicy$PolicyArn' => '<p>The ARN of the policy.</p>', 'AwsIamGroupDetails$CreateDate' => '<p>Indicates when the IAM group was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamGroupDetails$GroupId' => '<p>The identifier of the IAM group.</p>', 'AwsIamGroupDetails$GroupName' => '<p>The name of the IAM group.</p>', 'AwsIamGroupDetails$Path' => '<p>The path to the group.</p>', 'AwsIamGroupPolicy$PolicyName' => '<p>The name of the policy.</p>', 'AwsIamInstanceProfile$Arn' => '<p>The ARN of the instance profile.</p>', 'AwsIamInstanceProfile$CreateDate' => '<p>Indicates when the instance profile was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamInstanceProfile$InstanceProfileId' => '<p>The identifier of the instance profile.</p>', 'AwsIamInstanceProfile$InstanceProfileName' => '<p>The name of the instance profile.</p>', 'AwsIamInstanceProfile$Path' => '<p>The path to the instance profile.</p>', 'AwsIamInstanceProfileRole$Arn' => '<p>The ARN of the role.</p>', 'AwsIamInstanceProfileRole$CreateDate' => '<p>Indicates when the role was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamInstanceProfileRole$Path' => '<p>The path to the role.</p>', 'AwsIamInstanceProfileRole$RoleId' => '<p>The identifier of the role.</p>', 'AwsIamInstanceProfileRole$RoleName' => '<p>The name of the role.</p>', 'AwsIamPermissionsBoundary$PermissionsBoundaryArn' => '<p>The ARN of the policy used to set the permissions boundary.</p>', 'AwsIamPermissionsBoundary$PermissionsBoundaryType' => '<p>The usage type for the permissions boundary.</p>', 'AwsIamPolicyDetails$CreateDate' => '<p>When the policy was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamPolicyDetails$DefaultVersionId' => '<p>The identifier of the default version of the policy.</p>', 'AwsIamPolicyDetails$Description' => '<p>A description of the policy.</p>', 'AwsIamPolicyDetails$Path' => '<p>The path to the policy.</p>', 'AwsIamPolicyDetails$PolicyId' => '<p>The unique identifier of the policy.</p>', 'AwsIamPolicyDetails$PolicyName' => '<p>The name of the policy.</p>', 'AwsIamPolicyDetails$UpdateDate' => '<p>When the policy was most recently updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamPolicyVersion$VersionId' => '<p>The identifier of the policy version.</p>', 'AwsIamPolicyVersion$CreateDate' => '<p>Indicates when the version was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamRoleDetails$CreateDate' => '<p>Indicates when the role was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamRoleDetails$RoleId' => '<p>The stable and unique string identifying the role.</p>', 'AwsIamRoleDetails$RoleName' => '<p>The friendly name that identifies the role.</p>', 'AwsIamRoleDetails$Path' => '<p>The path to the role.</p>', 'AwsIamRolePolicy$PolicyName' => '<p>The name of the policy.</p>', 'AwsIamUserDetails$CreateDate' => '<p>Indicates when the user was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsIamUserDetails$Path' => '<p>The path to the user.</p>', 'AwsIamUserDetails$UserId' => '<p>The unique identifier for the user.</p>', 'AwsIamUserDetails$UserName' => '<p>The name of the user.</p>', 'AwsIamUserPolicy$PolicyName' => '<p>The name of the policy.</p>', 'AwsKinesisStreamDetails$Name' => '<p>The name of the Kinesis stream. If you don\'t specify a name, CloudFront generates a unique physical ID and uses that ID for the stream name. </p>', 'AwsKinesisStreamDetails$Arn' => '<p>The Amazon Resource Name (ARN) of the Kinesis data stream. </p>', 'AwsKinesisStreamStreamEncryptionDetails$EncryptionType' => '<p>The encryption type to use. </p>', 'AwsKinesisStreamStreamEncryptionDetails$KeyId' => '<p>The globally unique identifier for the customer-managed KMS key to use for encryption. </p>', 'AwsKmsKeyDetails$AWSAccountId' => '<p>The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.</p>', 'AwsKmsKeyDetails$KeyId' => '<p>The globally unique identifier for the KMS key.</p>', 'AwsKmsKeyDetails$KeyManager' => '<p>The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed.</p>', 'AwsKmsKeyDetails$KeyState' => '<p>The state of the KMS key. Valid values are as follows:</p> <ul> <li> <p> <code>Disabled</code> </p> </li> <li> <p> <code>Enabled</code> </p> </li> <li> <p> <code>PendingDeletion</code> </p> </li> <li> <p> <code>PendingImport</code> </p> </li> <li> <p> <code>Unavailable</code> </p> </li> </ul>', 'AwsKmsKeyDetails$Origin' => '<p>The source of the KMS key material.</p> <p>When this value is <code>AWS_KMS</code>, KMS created the key material.</p> <p>When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management infrastructure or the KMS key lacks key material.</p> <p>When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated with a custom key store.</p>', 'AwsKmsKeyDetails$Description' => '<p>A description of the KMS key.</p>', 'AwsLambdaFunctionCode$S3Bucket' => '<p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>', 'AwsLambdaFunctionCode$S3Key' => '<p>The Amazon S3 key of the deployment package.</p>', 'AwsLambdaFunctionCode$S3ObjectVersion' => '<p>For versioned objects, the version of the deployment package object to use.</p>', 'AwsLambdaFunctionCode$ZipFile' => '<p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.</p>', 'AwsLambdaFunctionDeadLetterConfig$TargetArn' => '<p>The ARN of an SQS queue or SNS topic.</p>', 'AwsLambdaFunctionDetails$CodeSha256' => '<p>The SHA256 hash of the function\'s deployment package.</p>', 'AwsLambdaFunctionDetails$FunctionName' => '<p>The name of the function.</p>', 'AwsLambdaFunctionDetails$Handler' => '<p>The function that Lambda calls to begin executing your function.</p>', 'AwsLambdaFunctionDetails$KmsKeyArn' => '<p>The KMS key that is used to encrypt the function\'s environment variables. This key is only returned if you\'ve configured a customer managed customer managed key.</p>', 'AwsLambdaFunctionDetails$LastModified' => '<p>Indicates when the function was last updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsLambdaFunctionDetails$MasterArn' => '<p>For Lambda@Edge functions, the ARN of the master function.</p>', 'AwsLambdaFunctionDetails$RevisionId' => '<p>The latest updated revision of the function or alias.</p>', 'AwsLambdaFunctionDetails$Role' => '<p>The function\'s execution role.</p>', 'AwsLambdaFunctionDetails$Runtime' => '<p>The runtime environment for the Lambda function.</p>', 'AwsLambdaFunctionDetails$Version' => '<p>The version of the Lambda function.</p>', 'AwsLambdaFunctionDetails$PackageType' => '<p>The type of deployment package that\'s used to deploy the function code to Lambda. Set to <code>Image</code> for a container image and <code>Zip</code> for a .zip file archive. </p>', 'AwsLambdaFunctionEnvironmentError$ErrorCode' => '<p>The error code.</p>', 'AwsLambdaFunctionEnvironmentError$Message' => '<p>The error message.</p>', 'AwsLambdaFunctionLayer$Arn' => '<p>The ARN of the function layer.</p>', 'AwsLambdaFunctionTracingConfig$Mode' => '<p>The tracing mode.</p>', 'AwsLambdaFunctionVpcConfig$VpcId' => '<p>The ID of the VPC.</p>', 'AwsLambdaLayerVersionDetails$CreatedDate' => '<p>Indicates when the version was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsMountPoint$SourceVolume' => '<p>The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of task definition <code>volume</code>. </p>', 'AwsMountPoint$ContainerPath' => '<p>The path on the container to mount the host volume at. </p>', 'AwsMskClusterClusterInfoDetails$CurrentVersion' => '<p> The current version of the cluster.</p>', 'AwsMskClusterClusterInfoDetails$ClusterName' => '<p> The name of the cluster.</p>', 'AwsMskClusterClusterInfoDetails$EnhancedMonitoring' => '<p> Specifies the level of monitoring for the cluster. </p>', 'AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails$DataVolumeKMSKeyId' => '<p> The Amazon Resource Name (ARN) of the KMS key for encrypting data at rest. If you don\'t specify a KMS key, MSK creates one for you and uses it.</p>', 'AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails$ClientBroker' => '<p> Indicates the encryption setting for data in transit between clients and brokers.</p>', 'AwsNetworkFirewallFirewallDetails$Description' => '<p>A description of the firewall.</p>', 'AwsNetworkFirewallFirewallDetails$FirewallArn' => '<p>The ARN of the firewall.</p>', 'AwsNetworkFirewallFirewallDetails$FirewallId' => '<p>The identifier of the firewall.</p>', 'AwsNetworkFirewallFirewallDetails$FirewallName' => '<p>A descriptive name of the firewall.</p>', 'AwsNetworkFirewallFirewallDetails$FirewallPolicyArn' => '<p>The ARN of the firewall policy.</p>', 'AwsNetworkFirewallFirewallDetails$VpcId' => '<p>The identifier of the VPC where the firewall is used.</p>', 'AwsNetworkFirewallFirewallPolicyDetails$FirewallPolicyArn' => '<p>The ARN of the firewall policy.</p>', 'AwsNetworkFirewallFirewallPolicyDetails$FirewallPolicyId' => '<p>The identifier of the firewall policy.</p>', 'AwsNetworkFirewallFirewallPolicyDetails$FirewallPolicyName' => '<p>The name of the firewall policy.</p>', 'AwsNetworkFirewallFirewallPolicyDetails$Description' => '<p>A description of the firewall policy.</p>', 'AwsNetworkFirewallFirewallSubnetMappingsDetails$SubnetId' => '<p>The identifier of the subnet</p>', 'AwsNetworkFirewallRuleGroupDetails$Description' => '<p>A description of the rule group.</p>', 'AwsNetworkFirewallRuleGroupDetails$RuleGroupArn' => '<p>The ARN of the rule group.</p>', 'AwsNetworkFirewallRuleGroupDetails$RuleGroupId' => '<p>The identifier of the rule group.</p>', 'AwsNetworkFirewallRuleGroupDetails$RuleGroupName' => '<p>The descriptive name of the rule group.</p>', 'AwsNetworkFirewallRuleGroupDetails$Type' => '<p>The type of rule group. A rule group can be stateful or stateless.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$InstanceType' => '<p>The instance type for your data nodes.</p> <p>For a list of valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer Guide</i>.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$WarmType' => '<p>The type of UltraWarm instance.</p>', 'AwsOpenSearchServiceDomainClusterConfigDetails$DedicatedMasterType' => '<p>The hardware configuration of the computer that hosts the dedicated master node.</p> <p>If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>. </p>', 'AwsOpenSearchServiceDomainDetails$Arn' => '<p>The ARN of the OpenSearch Service domain.</p>', 'AwsOpenSearchServiceDomainDetails$AccessPolicies' => '<p>IAM policy document that specifies the access policies for the OpenSearch Service domain.</p>', 'AwsOpenSearchServiceDomainDetails$DomainName' => '<p>The name of the endpoint.</p>', 'AwsOpenSearchServiceDomainDetails$Id' => '<p>The identifier of the domain.</p>', 'AwsOpenSearchServiceDomainDetails$DomainEndpoint' => '<p>The domain endpoint.</p>', 'AwsOpenSearchServiceDomainDetails$EngineVersion' => '<p>The version of the domain engine.</p>', 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails$CustomEndpointCertificateArn' => '<p>The ARN for the security certificate. The certificate is managed in ACM.</p>', 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails$CustomEndpoint' => '<p>The fully qualified URL for the custom endpoint.</p>', 'AwsOpenSearchServiceDomainDomainEndpointOptionsDetails$TLSSecurityPolicy' => '<p>The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.</p>', 'AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails$KmsKeyId' => '<p>The KMS key ID.</p>', 'AwsOpenSearchServiceDomainLogPublishingOption$CloudWatchLogsLogGroupArn' => '<p>The ARN of the CloudWatch Logs group to publish the logs to.</p>', 'AwsOpenSearchServiceDomainMasterUserOptionsDetails$MasterUserArn' => '<p>The Amazon Resource Name (ARN) for the master user. </p>', 'AwsOpenSearchServiceDomainMasterUserOptionsDetails$MasterUserName' => '<p>The username for the master user. </p>', 'AwsOpenSearchServiceDomainMasterUserOptionsDetails$MasterUserPassword' => '<p>The password for the master user. </p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$AutomatedUpdateDate' => '<p>The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service schedules the software upgrade automatically.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$CurrentVersion' => '<p>The version of the service software that is currently installed on the domain.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$Description' => '<p>A more detailed description of the service software status.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$NewVersion' => '<p>The most recent version of the service software.</p>', 'AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails$UpdateStatus' => '<p>The status of the service software update. Valid values are as follows:</p> <ul> <li> <p> <code>COMPLETED</code> </p> </li> <li> <p> <code>ELIGIBLE</code> </p> </li> <li> <p> <code>IN_PROGRESS</code> </p> </li> <li> <p> <code>NOT_ELIGIBLE</code> </p> </li> <li> <p> <code>PENDING_UPDATE</code> </p> </li> </ul>', 'AwsRdsDbClusterAssociatedRole$RoleArn' => '<p>The ARN of the IAM role.</p>', 'AwsRdsDbClusterAssociatedRole$Status' => '<p>The status of the association between the IAM role and the DB cluster. Valid values are as follows:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>INVALID</code> </p> </li> <li> <p> <code>PENDING</code> </p> </li> </ul>', 'AwsRdsDbClusterDetails$DatabaseName' => '<p>The name of the database.</p>', 'AwsRdsDbClusterDetails$Status' => '<p>The current status of this DB cluster.</p>', 'AwsRdsDbClusterDetails$Endpoint' => '<p>The connection endpoint for the primary instance of the DB cluster.</p>', 'AwsRdsDbClusterDetails$ReaderEndpoint' => '<p>The reader endpoint for the DB cluster.</p>', 'AwsRdsDbClusterDetails$Engine' => '<p>The name of the database engine to use for this DB cluster. Valid values are as follows:</p> <ul> <li> <p> <code>aurora</code> </p> </li> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> </ul>', 'AwsRdsDbClusterDetails$EngineVersion' => '<p>The version number of the database engine to use.</p>', 'AwsRdsDbClusterDetails$MasterUsername' => '<p>The name of the master user for the DB cluster.</p>', 'AwsRdsDbClusterDetails$PreferredBackupWindow' => '<p>The range of time each day when automated backups are created, if automated backups are enabled.</p> <p>Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.</p>', 'AwsRdsDbClusterDetails$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.</p> <p>For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|<code>sat</code>|<code>sun</code>.</p> <p>For example, <code>sun:09:32-sun:10:02</code>.</p>', 'AwsRdsDbClusterDetails$HostedZoneId' => '<p>Specifies the identifier that Amazon Route 53 assigns when you create a hosted zone.</p>', 'AwsRdsDbClusterDetails$KmsKeyId' => '<p>The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.</p>', 'AwsRdsDbClusterDetails$DbClusterResourceId' => '<p>The identifier of the DB cluster. The identifier must be unique within each Amazon Web Services Region and is immutable.</p>', 'AwsRdsDbClusterDetails$ClusterCreateTime' => '<p>Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRdsDbClusterDetails$EngineMode' => '<p>The database engine mode of the DB cluster.Valid values are as follows:</p> <ul> <li> <p> <code>global</code> </p> </li> <li> <p> <code>multimaster</code> </p> </li> <li> <p> <code>parallelquery</code> </p> </li> <li> <p> <code>provisioned</code> </p> </li> <li> <p> <code>serverless</code> </p> </li> </ul>', 'AwsRdsDbClusterDetails$ActivityStreamStatus' => '<p>The status of the database activity stream. Valid values are as follows:</p> <ul> <li> <p> <code>started</code> </p> </li> <li> <p> <code>starting</code> </p> </li> <li> <p> <code>stopped</code> </p> </li> <li> <p> <code>stopping</code> </p> </li> </ul>', 'AwsRdsDbClusterDetails$DbClusterParameterGroup' => '<p>The name of the DB cluster parameter group for the DB cluster.</p>', 'AwsRdsDbClusterDetails$DbSubnetGroup' => '<p>The subnet group that is associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>', 'AwsRdsDbClusterDetails$DbClusterIdentifier' => '<p>The DB cluster identifier that the user assigned to the cluster. This identifier is the unique key that identifies a DB cluster.</p>', 'AwsRdsDbClusterMember$DbInstanceIdentifier' => '<p>The instance identifier for this member of the DB cluster.</p>', 'AwsRdsDbClusterMember$DbClusterParameterGroupStatus' => '<p>The status of the DB cluster parameter group for this member of the DB cluster.</p>', 'AwsRdsDbClusterOptionGroupMembership$DbClusterOptionGroupName' => '<p>The name of the DB cluster option group.</p>', 'AwsRdsDbClusterOptionGroupMembership$Status' => '<p>The status of the DB cluster option group.</p>', 'AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute$AttributeName' => '<p> The name of the manual DB cluster snapshot attribute. The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. </p>', 'AwsRdsDbClusterSnapshotDetails$SnapshotCreateTime' => '<p>Indicates when the snapshot was taken.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRdsDbClusterSnapshotDetails$Engine' => '<p>The name of the database engine that you want to use for this DB instance.</p>', 'AwsRdsDbClusterSnapshotDetails$Status' => '<p>The status of this DB cluster snapshot.</p>', 'AwsRdsDbClusterSnapshotDetails$VpcId' => '<p>The VPC ID that is associated with the DB cluster snapshot.</p>', 'AwsRdsDbClusterSnapshotDetails$ClusterCreateTime' => '<p>Indicates when the DB cluster was created, in Universal Coordinated Time (UTC).</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRdsDbClusterSnapshotDetails$MasterUsername' => '<p>The name of the master user for the DB cluster.</p>', 'AwsRdsDbClusterSnapshotDetails$EngineVersion' => '<p>The version of the database engine to use.</p>', 'AwsRdsDbClusterSnapshotDetails$LicenseModel' => '<p>The license model information for this DB cluster snapshot.</p>', 'AwsRdsDbClusterSnapshotDetails$SnapshotType' => '<p>The type of DB cluster snapshot.</p>', 'AwsRdsDbClusterSnapshotDetails$KmsKeyId' => '<p>The ARN of the KMS master key that is used to encrypt the database instances in the DB cluster.</p>', 'AwsRdsDbClusterSnapshotDetails$DbClusterIdentifier' => '<p>The DB cluster identifier.</p>', 'AwsRdsDbClusterSnapshotDetails$DbClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot.</p>', 'AwsRdsDbDomainMembership$Domain' => '<p>The identifier of the Active Directory domain.</p>', 'AwsRdsDbDomainMembership$Status' => '<p>The status of the Active Directory Domain membership for the DB instance.</p>', 'AwsRdsDbDomainMembership$Fqdn' => '<p>The fully qualified domain name of the Active Directory domain.</p>', 'AwsRdsDbDomainMembership$IamRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p>', 'AwsRdsDbInstanceAssociatedRole$RoleArn' => '<p>The ARN of the IAM role that is associated with the DB instance.</p>', 'AwsRdsDbInstanceAssociatedRole$FeatureName' => '<p>The name of the feature associated with the IAM role.</p>', 'AwsRdsDbInstanceAssociatedRole$Status' => '<p>Describes the state of the association between the IAM role and the DB instance. The <code>Status</code> property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - The IAM role ARN is being associated with the DB instance.</p> </li> <li> <p> <code>INVALID</code> - The IAM role ARN is associated with the DB instance. But the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf. </p> </li> </ul>', 'AwsRdsDbInstanceDetails$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p>', 'AwsRdsDbInstanceDetails$DBClusterIdentifier' => '<p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>', 'AwsRdsDbInstanceDetails$DBInstanceIdentifier' => '<p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>', 'AwsRdsDbInstanceDetails$DBInstanceClass' => '<p>Contains the name of the compute and memory capacity class of the DB instance.</p>', 'AwsRdsDbInstanceDetails$DbiResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in CloudTrail log entries whenever the KMS key for the DB instance is accessed. </p>', 'AwsRdsDbInstanceDetails$DBName' => '<p>The meaning of this parameter differs according to the database engine you use.</p> <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p> <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p> <p> <b>Oracle</b> </p> <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance. </p>', 'AwsRdsDbInstanceDetails$Engine' => '<p>Provides the name of the database engine to use for this DB instance.</p>', 'AwsRdsDbInstanceDetails$EngineVersion' => '<p>Indicates the database engine version.</p>', 'AwsRdsDbInstanceDetails$InstanceCreateTime' => '<p>Indicates when the DB instance was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRdsDbInstanceDetails$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.</p>', 'AwsRdsDbInstanceDetails$TdeCredentialArn' => '<p>The ARN from the key store with which the instance is associated for TDE encryption.</p>', 'AwsRdsDbInstanceDetails$EnhancedMonitoringResourceArn' => '<p>The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB instance.</p>', 'AwsRdsDbInstanceDetails$DbInstanceStatus' => '<p>The current status of the DB instance.</p>', 'AwsRdsDbInstanceDetails$MasterUsername' => '<p>The master user name of the DB instance.</p>', 'AwsRdsDbInstanceDetails$PreferredBackupWindow' => '<p>The range of time each day when automated backups are created, if automated backups are enabled.</p> <p>Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.</p>', 'AwsRdsDbInstanceDetails$AvailabilityZone' => '<p>The Availability Zone where the DB instance will be created.</p>', 'AwsRdsDbInstanceDetails$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.</p> <p>For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|<code>sat</code>|<code>sun</code>.</p> <p>For example, <code>sun:09:32-sun:10:02</code>.</p>', 'AwsRdsDbInstanceDetails$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRdsDbInstanceDetails$ReadReplicaSourceDBInstanceIdentifier' => '<p>If this DB instance is a read replica, contains the identifier of the source DB instance.</p>', 'AwsRdsDbInstanceDetails$LicenseModel' => '<p>License model information for this DB instance.</p>', 'AwsRdsDbInstanceDetails$CharacterSetName' => '<p>The name of the character set that this DB instance is associated with.</p>', 'AwsRdsDbInstanceDetails$SecondaryAvailabilityZone' => '<p>For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.</p>', 'AwsRdsDbInstanceDetails$StorageType' => '<p>The storage type for the DB instance.</p>', 'AwsRdsDbInstanceDetails$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.</p>', 'AwsRdsDbInstanceDetails$Timezone' => '<p>The time zone of the DB instance.</p>', 'AwsRdsDbInstanceDetails$PerformanceInsightsKmsKeyId' => '<p>The identifier of the KMS key used to encrypt the Performance Insights data.</p>', 'AwsRdsDbInstanceEndpoint$Address' => '<p>Specifies the DNS address of the DB instance.</p>', 'AwsRdsDbInstanceEndpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'AwsRdsDbInstanceVpcSecurityGroup$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'AwsRdsDbInstanceVpcSecurityGroup$Status' => '<p>The status of the VPC security group.</p>', 'AwsRdsDbOptionGroupMembership$OptionGroupName' => '<p>The name of the option group.</p>', 'AwsRdsDbOptionGroupMembership$Status' => '<p>The status of the option group membership.</p>', 'AwsRdsDbParameterGroup$DbParameterGroupName' => '<p>The name of the parameter group.</p>', 'AwsRdsDbParameterGroup$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'AwsRdsDbPendingModifiedValues$DbInstanceClass' => '<p>The new DB instance class for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$MasterUserPassword' => '<p>The new master user password for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$EngineVersion' => '<p>The new engine version for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$LicenseModel' => '<p>The new license model value for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$DbInstanceIdentifier' => '<p>The new DB instance identifier for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$StorageType' => '<p>The new storage type for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$CaCertificateIdentifier' => '<p>The new CA certificate identifier for the DB instance.</p>', 'AwsRdsDbPendingModifiedValues$DbSubnetGroupName' => '<p>The name of the new subnet group for the DB instance.</p>', 'AwsRdsDbProcessorFeature$Name' => '<p>The name of the processor feature. Valid values are <code>coreCount</code> or <code>threadsPerCore</code>.</p>', 'AwsRdsDbProcessorFeature$Value' => '<p>The value of the processor feature.</p>', 'AwsRdsDbSecurityGroupDetails$DbSecurityGroupArn' => '<p>The ARN for the DB security group.</p>', 'AwsRdsDbSecurityGroupDetails$DbSecurityGroupDescription' => '<p>Provides the description of the DB security group.</p>', 'AwsRdsDbSecurityGroupDetails$DbSecurityGroupName' => '<p>Specifies the name of the DB security group.</p>', 'AwsRdsDbSecurityGroupDetails$OwnerId' => '<p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>', 'AwsRdsDbSecurityGroupDetails$VpcId' => '<p>Provides VPC ID associated with the DB security group. </p>', 'AwsRdsDbSecurityGroupEc2SecurityGroup$Ec2SecurityGroupId' => '<p>Specifies the ID for the EC2 security group.</p>', 'AwsRdsDbSecurityGroupEc2SecurityGroup$Ec2SecurityGroupName' => '<p>Specifies the name of the EC2 security group.</p>', 'AwsRdsDbSecurityGroupEc2SecurityGroup$Ec2SecurityGroupOwnerId' => '<p>Provides the Amazon Web Services ID of the owner of the EC2 security group.</p>', 'AwsRdsDbSecurityGroupEc2SecurityGroup$Status' => '<p>Provides the status of the EC2 security group.</p>', 'AwsRdsDbSecurityGroupIpRange$CidrIp' => '<p>Specifies the IP range.</p>', 'AwsRdsDbSecurityGroupIpRange$Status' => '<p>Specifies the status of the IP range.</p>', 'AwsRdsDbSnapshotDetails$DbSnapshotIdentifier' => '<p>The name or ARN of the DB snapshot that is used to restore the DB instance.</p>', 'AwsRdsDbSnapshotDetails$DbInstanceIdentifier' => '<p>A name for the DB instance.</p>', 'AwsRdsDbSnapshotDetails$SnapshotCreateTime' => '<p>When the snapshot was taken in Coordinated Universal Time (UTC).</p>', 'AwsRdsDbSnapshotDetails$Engine' => '<p>The name of the database engine to use for this DB instance. Valid values are as follows:</p> <ul> <li> <p> <code>aurora</code> </p> </li> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>c</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-se</code> </p> </li> <li> <p> <code>oracle-se1</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'AwsRdsDbSnapshotDetails$Status' => '<p>The status of this DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$AvailabilityZone' => '<p>Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$VpcId' => '<p>The VPC ID associated with the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$InstanceCreateTime' => '<p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>', 'AwsRdsDbSnapshotDetails$MasterUsername' => '<p>The master user name for the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$EngineVersion' => '<p>The version of the database engine.</p>', 'AwsRdsDbSnapshotDetails$LicenseModel' => '<p>License model information for the restored DB instance.</p>', 'AwsRdsDbSnapshotDetails$SnapshotType' => '<p>The type of the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$OptionGroupName' => '<p>The option group name for the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$SourceRegion' => '<p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>', 'AwsRdsDbSnapshotDetails$SourceDbSnapshotIdentifier' => '<p>The DB snapshot ARN that the DB snapshot was copied from.</p>', 'AwsRdsDbSnapshotDetails$StorageType' => '<p>The storage type associated with the DB snapshot. Valid values are as follows:</p> <ul> <li> <p> <code>gp2</code> </p> </li> <li> <p> <code>io1</code> </p> </li> <li> <p> <code>standard</code> </p> </li> </ul>', 'AwsRdsDbSnapshotDetails$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p>', 'AwsRdsDbSnapshotDetails$KmsKeyId' => '<p>If <code>Encrypted</code> is <code>true</code>, the KMS key identifier for the encrypted DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$Timezone' => '<p>The time zone of the DB snapshot.</p>', 'AwsRdsDbSnapshotDetails$DbiResourceId' => '<p>The identifier for the source DB instance.</p>', 'AwsRdsDbStatusInfo$StatusType' => '<p>The type of status. For a read replica, the status type is read replication.</p>', 'AwsRdsDbStatusInfo$Status' => '<p>The status of the read replica instance.</p>', 'AwsRdsDbStatusInfo$Message' => '<p>If the read replica is currently in an error state, provides the error details.</p>', 'AwsRdsDbSubnetGroup$DbSubnetGroupName' => '<p>The name of the subnet group.</p>', 'AwsRdsDbSubnetGroup$DbSubnetGroupDescription' => '<p>The description of the subnet group.</p>', 'AwsRdsDbSubnetGroup$VpcId' => '<p>The VPC ID of the subnet group.</p>', 'AwsRdsDbSubnetGroup$SubnetGroupStatus' => '<p>The status of the subnet group.</p>', 'AwsRdsDbSubnetGroup$DbSubnetGroupArn' => '<p>The ARN of the subnet group.</p>', 'AwsRdsDbSubnetGroupSubnet$SubnetIdentifier' => '<p>The identifier of a subnet in the subnet group.</p>', 'AwsRdsDbSubnetGroupSubnet$SubnetStatus' => '<p>The status of a subnet in the subnet group.</p>', 'AwsRdsDbSubnetGroupSubnetAvailabilityZone$Name' => '<p>The name of the Availability Zone for a subnet in the subnet group.</p>', 'AwsRdsEventSubscriptionDetails$CustSubscriptionId' => '<p>The identifier of the account that is associated with the event notification subscription.</p>', 'AwsRdsEventSubscriptionDetails$CustomerAwsId' => '<p>The identifier of the event notification subscription.</p>', 'AwsRdsEventSubscriptionDetails$EventSubscriptionArn' => '<p>The ARN of the event notification subscription.</p>', 'AwsRdsEventSubscriptionDetails$SnsTopicArn' => '<p>The ARN of the SNS topic to post the event notifications to.</p>', 'AwsRdsEventSubscriptionDetails$SourceType' => '<p>The source type for the event notification subscription.</p>', 'AwsRdsEventSubscriptionDetails$Status' => '<p>The status of the event notification subscription.</p> <p>Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code> </p>', 'AwsRdsEventSubscriptionDetails$SubscriptionCreationTime' => '<p>The datetime when the event notification subscription was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterClusterNode$NodeRole' => '<p>The role of the node. A node might be a leader node or a compute node.</p>', 'AwsRedshiftClusterClusterNode$PrivateIpAddress' => '<p>The private IP address of the node.</p>', 'AwsRedshiftClusterClusterNode$PublicIpAddress' => '<p>The public IP address of the node.</p>', 'AwsRedshiftClusterClusterParameterGroup$ParameterApplyStatus' => '<p>The status of updates to the parameters.</p>', 'AwsRedshiftClusterClusterParameterGroup$ParameterGroupName' => '<p>The name of the parameter group.</p>', 'AwsRedshiftClusterClusterParameterStatus$ParameterName' => '<p>The name of the parameter.</p>', 'AwsRedshiftClusterClusterParameterStatus$ParameterApplyStatus' => '<p>The status of the parameter. Indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when it was applied.</p> <p>Valid values: <code>in-sync</code> | <code>pending-reboot</code> | <code>applying</code> | <code>invalid-parameter</code> | <code>apply-deferred</code> | <code>apply-error</code> | <code>unknown-error</code> </p>', 'AwsRedshiftClusterClusterParameterStatus$ParameterApplyErrorDescription' => '<p>The error that prevented the parameter from being applied to the database.</p>', 'AwsRedshiftClusterClusterSecurityGroup$ClusterSecurityGroupName' => '<p>The name of the cluster security group.</p>', 'AwsRedshiftClusterClusterSecurityGroup$Status' => '<p>The status of the cluster security group.</p>', 'AwsRedshiftClusterClusterSnapshotCopyStatus$DestinationRegion' => '<p>The destination Region that snapshots are automatically copied to when cross-Region snapshot copy is enabled.</p>', 'AwsRedshiftClusterClusterSnapshotCopyStatus$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant.</p>', 'AwsRedshiftClusterDeferredMaintenanceWindow$DeferMaintenanceEndTime' => '<p>The end of the time window for which maintenance was deferred.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterDeferredMaintenanceWindow$DeferMaintenanceIdentifier' => '<p>The identifier of the maintenance window.</p>', 'AwsRedshiftClusterDeferredMaintenanceWindow$DeferMaintenanceStartTime' => '<p>The start of the time window for which maintenance was deferred.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterDetails$AvailabilityZone' => '<p>The name of the Availability Zone in which the cluster is located.</p>', 'AwsRedshiftClusterDetails$ClusterAvailabilityStatus' => '<p>The availability status of the cluster for queries. Possible values are the following:</p> <ul> <li> <p> <code>Available</code> - The cluster is available for queries.</p> </li> <li> <p> <code>Unavailable</code> - The cluster is not available for queries.</p> </li> <li> <p> <code>Maintenance</code> - The cluster is intermittently available for queries due to maintenance activities.</p> </li> <li> <p> <code>Modifying</code> -The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li> <li> <p> <code>Failed</code> - The cluster failed and is not available for queries.</p> </li> </ul>', 'AwsRedshiftClusterDetails$ClusterCreateTime' => '<p>Indicates when the cluster was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterDetails$ClusterIdentifier' => '<p>The unique identifier of the cluster.</p>', 'AwsRedshiftClusterDetails$ClusterPublicKey' => '<p>The public key for the cluster.</p>', 'AwsRedshiftClusterDetails$ClusterRevisionNumber' => '<p>The specific revision number of the database in the cluster.</p>', 'AwsRedshiftClusterDetails$ClusterStatus' => '<p>The current status of the cluster.</p> <p>Valid values: <code>available</code> | <code>available, prep-for-resize</code> | <code>available, resize-cleanup</code> |<code> cancelling-resize</code> | <code>creating</code> | <code>deleting</code> | <code>final-snapshot</code> | <code>hardware-failure</code> | <code>incompatible-hsm</code> |<code> incompatible-network</code> | <code>incompatible-parameters</code> | <code>incompatible-restore</code> | <code>modifying</code> | <code>paused</code> | <code>rebooting</code> | <code>renaming</code> | <code>resizing</code> | <code>rotating-keys</code> | <code>storage-full</code> | <code>updating-hsm</code> </p>', 'AwsRedshiftClusterDetails$ClusterSubnetGroupName' => '<p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>', 'AwsRedshiftClusterDetails$ClusterVersion' => '<p>The version ID of the Amazon Redshift engine that runs on the cluster.</p>', 'AwsRedshiftClusterDetails$DBName' => '<p>The name of the initial database that was created when the cluster was created.</p> <p>The same name is returned for the life of the cluster.</p> <p>If an initial database is not specified, a database named <code>devdev</code> is created by default.</p>', 'AwsRedshiftClusterDetails$ElasticResizeNumberOfNodeOptions' => '<p>The number of nodes that you can use the elastic resize method to resize the cluster to.</p>', 'AwsRedshiftClusterDetails$ExpectedNextSnapshotScheduleTime' => '<p>Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule and have backups enabled.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterDetails$ExpectedNextSnapshotScheduleTimeStatus' => '<p>The status of the next expected snapshot.</p> <p>Valid values: <code>OnTrack</code> | <code>Pending</code> </p>', 'AwsRedshiftClusterDetails$KmsKeyId' => '<p>The identifier of the KMS encryption key that is used to encrypt data in the cluster.</p>', 'AwsRedshiftClusterDetails$MaintenanceTrackName' => '<p>The name of the maintenance track for the cluster.</p>', 'AwsRedshiftClusterDetails$MasterUsername' => '<p>The master user name for the cluster. This name is used to connect to the database that is specified in as the value of <code>DBName</code>.</p>', 'AwsRedshiftClusterDetails$NextMaintenanceWindowStartTime' => '<p>Indicates the start of the next maintenance window.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterDetails$NodeType' => '<p>The node type for the nodes in the cluster.</p>', 'AwsRedshiftClusterDetails$PreferredMaintenanceWindow' => '<p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p> <p>Format: <code> <i>&lt;day&gt;</i>:HH:MM-<i>&lt;day&gt;</i>:HH:MM</code> </p> <p>For the day values, use <code>mon</code> | <code>tue</code> | <code>wed</code> | <code>thu</code> | <code>fri</code> | <code>sat</code> | <code>sun</code> </p> <p>For example, <code>sun:09:32-sun:10:02</code> </p>', 'AwsRedshiftClusterDetails$SnapshotScheduleIdentifier' => '<p>A unique identifier for the cluster snapshot schedule.</p>', 'AwsRedshiftClusterDetails$SnapshotScheduleState' => '<p>The current state of the cluster snapshot schedule.</p> <p>Valid values: <code>MODIFYING</code> | <code>ACTIVE</code> | <code>FAILED</code> </p>', 'AwsRedshiftClusterDetails$VpcId' => '<p>The identifier of the VPC that the cluster is in, if the cluster is in a VPC.</p>', 'AwsRedshiftClusterElasticIpStatus$ElasticIp' => '<p>The elastic IP address for the cluster.</p>', 'AwsRedshiftClusterElasticIpStatus$Status' => '<p>The status of the elastic IP address.</p>', 'AwsRedshiftClusterEndpoint$Address' => '<p>The DNS address of the cluster.</p>', 'AwsRedshiftClusterHsmStatus$HsmClientCertificateIdentifier' => '<p>The name of the HSM client certificate that the Amazon Redshift cluster uses to retrieve the data encryption keys that are stored in an HSM.</p>', 'AwsRedshiftClusterHsmStatus$HsmConfigurationIdentifier' => '<p>The name of the HSM configuration that contains the information that the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>', 'AwsRedshiftClusterHsmStatus$Status' => '<p>Indicates whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p> <p>Type: String</p> <p>Valid values: <code>active</code> | <code>applying</code> </p>', 'AwsRedshiftClusterIamRole$ApplyStatus' => '<p>The status of the IAM role\'s association with the cluster.</p> <p>Valid values: <code>in-sync</code> | <code>adding</code> | <code>removing</code> </p>', 'AwsRedshiftClusterIamRole$IamRoleArn' => '<p>The ARN of the IAM role.</p>', 'AwsRedshiftClusterLoggingStatus$BucketName' => '<p>The name of the S3 bucket where the log files are stored.</p>', 'AwsRedshiftClusterLoggingStatus$LastFailureMessage' => '<p>The message indicating that the logs failed to be delivered.</p>', 'AwsRedshiftClusterLoggingStatus$LastFailureTime' => '<p>The last time when logs failed to be delivered.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterLoggingStatus$LastSuccessfulDeliveryTime' => '<p>The last time that logs were delivered successfully.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsRedshiftClusterLoggingStatus$S3KeyPrefix' => '<p>Provides the prefix applied to the log file names.</p>', 'AwsRedshiftClusterPendingModifiedValues$ClusterIdentifier' => '<p>The pending or in-progress change to the identifier for the cluster.</p>', 'AwsRedshiftClusterPendingModifiedValues$ClusterType' => '<p>The pending or in-progress change to the cluster type.</p>', 'AwsRedshiftClusterPendingModifiedValues$ClusterVersion' => '<p>The pending or in-progress change to the service version.</p>', 'AwsRedshiftClusterPendingModifiedValues$EncryptionType' => '<p>The encryption type for a cluster.</p>', 'AwsRedshiftClusterPendingModifiedValues$MaintenanceTrackName' => '<p>The name of the maintenance track that the cluster changes to during the next maintenance window.</p>', 'AwsRedshiftClusterPendingModifiedValues$MasterUserPassword' => '<p>The pending or in-progress change to the master user password for the cluster.</p>', 'AwsRedshiftClusterPendingModifiedValues$NodeType' => '<p>The pending or in-progress change to the cluster\'s node type.</p>', 'AwsRedshiftClusterResizeInfo$ResizeType' => '<p>The type of resize operation.</p> <p>Valid values: <code>ClassicResize</code> </p>', 'AwsRedshiftClusterRestoreStatus$Status' => '<p>The status of the restore action.</p> <p>Valid values: <code>starting</code> | <code>restoring</code> | <code>completed</code> | <code>failed</code> </p>', 'AwsRedshiftClusterVpcSecurityGroup$Status' => '<p>The status of the VPC security group.</p>', 'AwsRedshiftClusterVpcSecurityGroup$VpcSecurityGroupId' => '<p>The identifier of the VPC security group.</p>', 'AwsRoute53HostedZoneConfigDetails$Comment' => '<p> Any comments that you include about the hosted zone. </p>', 'AwsRoute53HostedZoneNameServersList$member' => NULL, 'AwsRoute53HostedZoneObjectDetails$Id' => '<p> The ID that Route 53 assigns to the hosted zone when you create it. </p>', 'AwsRoute53HostedZoneObjectDetails$Name' => '<p> The name of the domain. For public hosted zones, this is the name that you have registered with your DNS registrar.</p>', 'AwsRoute53HostedZoneVpcDetails$Id' => '<p> The identifier of an Amazon VPC. </p>', 'AwsRoute53HostedZoneVpcDetails$Region' => '<p> The Amazon Web Services Region that an Amazon VPC was created in.</p>', 'AwsS3AccessPointDetails$AccessPointArn' => '<p> The Amazon Resource Name (ARN) of the access point. </p>', 'AwsS3AccessPointDetails$Alias' => '<p> The name or alias of the access point. </p>', 'AwsS3AccessPointDetails$Bucket' => '<p> The name of the S3 bucket associated with the specified access point. </p>', 'AwsS3AccessPointDetails$BucketAccountId' => '<p> The Amazon Web Services account ID associated with the S3 bucket associated with this access point. </p>', 'AwsS3AccessPointDetails$Name' => '<p> The name of the specified access point. </p>', 'AwsS3AccessPointDetails$NetworkOrigin' => '<p> Indicates whether this access point allows access from the public internet. </p>', 'AwsS3AccessPointVpcConfigurationDetails$VpcId' => '<p> If this field is specified, this access point will only allow connections from the specified VPC ID. </p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$ExpirationDate' => '<p>The date when objects are moved or deleted.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$ID' => '<p>The unique identifier of the rule.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$Prefix' => '<p>A prefix that identifies one or more objects that the rule applies to.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesDetails$Status' => '<p>The current status of the rule. Indicates whether the rule is currently being applied.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails$Prefix' => '<p>A prefix filter.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails$Type' => '<p>Whether to use <code>AND</code> or <code>OR</code> to join the operands. Valid values are <code>LifecycleAndOperator</code> or <code>LifecycleOrOperator</code>.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails$Prefix' => '<p>Prefix text for matching objects.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails$Type' => '<p>The type of filter value. Valid values are <code>LifecyclePrefixPredicate</code> or <code>LifecycleTagPredicate</code>.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails$Key' => '<p>The tag key.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails$Value' => '<p>The tag value.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails$Key' => '<p>The tag key.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails$Value' => '<p>The tag value</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails$StorageClass' => '<p>The class of storage to change the object to after the object is noncurrent for the specified number of days.</p>', 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails$Date' => '<p>A date on which to transition objects to the specified storage class. If you provide <code>Date</code>, you cannot provide <code>Days</code>.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails$StorageClass' => '<p>The storage class to transition the object to. Valid values are as follows:</p> <ul> <li> <p> <code>DEEP_ARCHIVE</code> </p> </li> <li> <p> <code>GLACIER</code> </p> </li> <li> <p> <code>INTELLIGENT_TIERING</code> </p> </li> <li> <p> <code>ONEZONE_IA</code> </p> </li> <li> <p> <code>STANDARD_IA</code> </p> </li> </ul>', 'AwsS3BucketBucketVersioningConfiguration$Status' => '<p>The versioning status of the S3 bucket. Valid values are <code>Enabled</code> or <code>Suspended</code>.</p>', 'AwsS3BucketDetails$OwnerId' => '<p>The canonical user ID of the owner of the S3 bucket.</p>', 'AwsS3BucketDetails$OwnerName' => '<p>The display name of the owner of the S3 bucket.</p>', 'AwsS3BucketDetails$OwnerAccountId' => '<p>The Amazon Web Services account identifier of the account that owns the S3 bucket.</p>', 'AwsS3BucketDetails$CreatedAt' => '<p>Indicates when the S3 bucket was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsS3BucketDetails$AccessControlList' => '<p>The access control list for the S3 bucket.</p>', 'AwsS3BucketDetails$Name' => '<p> The name of the bucket. </p>', 'AwsS3BucketLoggingConfiguration$DestinationBucketName' => '<p>The name of the S3 bucket where log files for the S3 bucket are stored.</p>', 'AwsS3BucketLoggingConfiguration$LogFilePrefix' => '<p>The prefix added to log files for the S3 bucket.</p>', 'AwsS3BucketNotificationConfigurationDetail$Destination' => '<p>The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that generates the notification.</p>', 'AwsS3BucketNotificationConfigurationDetail$Type' => '<p>Indicates the type of notification. Notifications can be generated using Lambda functions, Amazon SQS queues, or Amazon SNS topics, with corresponding valid values as follows:</p> <ul> <li> <p> <code>LambdaConfiguration</code> </p> </li> <li> <p> <code>QueueConfiguration</code> </p> </li> <li> <p> <code>TopicConfiguration</code> </p> </li> </ul>', 'AwsS3BucketNotificationConfigurationEvents$member' => NULL, 'AwsS3BucketNotificationConfigurationS3KeyFilterRule$Value' => '<p>The filter value.</p>', 'AwsS3BucketObjectLockConfiguration$ObjectLockEnabled' => '<p> Indicates whether the bucket has an Object Lock configuration enabled. </p>', 'AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails$Mode' => '<p> The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. </p>', 'AwsS3BucketServerSideEncryptionByDefault$SSEAlgorithm' => '<p>Server-side encryption algorithm to use for the default encryption. Valid values are <code>aws: kms</code> or <code>AES256</code>.</p>', 'AwsS3BucketServerSideEncryptionByDefault$KMSMasterKeyID' => '<p>KMS key ID to use for the default encryption.</p>', 'AwsS3BucketWebsiteConfiguration$ErrorDocument' => '<p>The name of the error document for the website.</p>', 'AwsS3BucketWebsiteConfiguration$IndexDocumentSuffix' => '<p>The name of the index document for the website.</p>', 'AwsS3BucketWebsiteConfigurationRedirectTo$Hostname' => '<p>The name of the host to redirect requests to.</p>', 'AwsS3BucketWebsiteConfigurationRedirectTo$Protocol' => '<p>The protocol to use when redirecting requests. By default, this field uses the same protocol as the original request. Valid values are <code>http</code> or <code>https</code>.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleCondition$HttpErrorCodeReturnedEquals' => '<p>Indicates to redirect the request if the HTTP error code matches this value.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleCondition$KeyPrefixEquals' => '<p>Indicates to redirect the request if the key prefix matches this value.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect$Hostname' => '<p>The host name to use in the redirect request.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect$HttpRedirectCode' => '<p>The HTTP redirect code to use in the response.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect$Protocol' => '<p>The protocol to use to redirect the request. By default, uses the protocol from the original request.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect$ReplaceKeyPrefixWith' => '<p>The object key prefix to use in the redirect request.</p> <p>Cannot be provided if <code>ReplaceKeyWith</code> is present.</p>', 'AwsS3BucketWebsiteConfigurationRoutingRuleRedirect$ReplaceKeyWith' => '<p>The specific object key to use in the redirect request.</p> <p>Cannot be provided if <code>ReplaceKeyPrefixWith</code> is present.</p>', 'AwsS3ObjectDetails$LastModified' => '<p>Indicates when the object was last modified.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsS3ObjectDetails$ETag' => '<p>The opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>', 'AwsS3ObjectDetails$VersionId' => '<p>The version of the object.</p>', 'AwsS3ObjectDetails$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'AwsS3ObjectDetails$ServerSideEncryption' => '<p>If the object is stored using server-side encryption, the value of the server-side encryption algorithm used when storing this object in Amazon S3.</p>', 'AwsS3ObjectDetails$SSEKMSKeyId' => '<p>The identifier of the KMS symmetric customer managed key that was used for the object.</p>', 'AwsSageMakerNotebookInstanceDetails$DefaultCodeRepository' => '<p> The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories with SageMaker notebook instances</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'AwsSageMakerNotebookInstanceDetails$DirectInternetAccess' => '<p> Sets whether SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code>, this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker training and endpoint services unless you configure a Network Address Translation (NAT) Gateway in your VPC. </p>', 'AwsSageMakerNotebookInstanceDetails$FailureReason' => '<p> If status of the instance is <code>Failed</code>, the reason it failed. </p>', 'AwsSageMakerNotebookInstanceDetails$InstanceType' => '<p> The type of machine learning (ML) compute instance to launch for the notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$KmsKeyId' => '<p> The Amazon Resource Name (ARN) of an Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and disabling keys</a> in the <i>Key Management Service Developer Guide</i>. </p>', 'AwsSageMakerNotebookInstanceDetails$NetworkInterfaceId' => '<p> The network interface ID that SageMaker created when the instance was created. </p>', 'AwsSageMakerNotebookInstanceDetails$NotebookInstanceArn' => '<p> The Amazon Resource Name (ARN) of the notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$NotebookInstanceLifecycleConfigName' => '<p> The name of a notebook instance lifecycle configuration. </p>', 'AwsSageMakerNotebookInstanceDetails$NotebookInstanceName' => '<p> The name of the new notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$NotebookInstanceStatus' => '<p> The status of the notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$PlatformIdentifier' => '<p> The platform identifier of the notebook instance runtime environment. </p>', 'AwsSageMakerNotebookInstanceDetails$RoleArn' => '<p> The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>', 'AwsSageMakerNotebookInstanceDetails$RootAccess' => '<p> Whether root access is enabled or disabled for users of the notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$SubnetId' => '<p> The ID of the VPC subnet to which you have a connectivity from your ML compute instance. </p>', 'AwsSageMakerNotebookInstanceDetails$Url' => '<p> The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>', 'AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails$MinimumInstanceMetadataServiceVersion' => '<p> Indicates the minimum IMDS version that the notebook instance supports. </p>', 'AwsSecretsManagerSecretDetails$KmsKeyId' => '<p>The ARN, Key ID, or alias of the KMS key used to encrypt the <code>SecretString</code> or <code>SecretBinary</code> values for versions of this secret.</p>', 'AwsSecretsManagerSecretDetails$RotationLambdaArn' => '<p>The ARN of the Lambda function that rotates the secret.</p>', 'AwsSecretsManagerSecretDetails$Name' => '<p>The name of the secret.</p>', 'AwsSecretsManagerSecretDetails$Description' => '<p>The user-provided description of the secret.</p>', 'AwsSecurityFinding$SchemaVersion' => '<p>The schema version that a finding is formatted for. The value is <code>2018-10-08</code>.</p>', 'AwsSecurityFinding$Id' => '<p>The security findings provider-specific identifier for a finding.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 512.</p>', 'AwsSecurityFinding$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.</p> <p>Length Constraints: Minimum length of 12. Maximum length of 2048.</p>', 'AwsSecurityFinding$ProductName' => '<p>The name of the product that generated the finding.</p> <p>Security Hub populates this attribute automatically for each finding. You cannot update this attribute with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom integration.</p> <p>When you use the Security Hub console or API to filter findings by product name, you use this attribute.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 128.</p>', 'AwsSecurityFinding$CompanyName' => '<p>The name of the company for the product that generated the finding.</p> <p>Security Hub populates this attribute automatically for each finding. You cannot update this attribute with <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>. The exception to this is a custom integration.</p> <p>When you use the Security Hub console or API to filter findings by company name, you use this attribute.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 128. </p>', 'AwsSecurityFinding$Region' => '<p>The Region from which the finding was generated.</p> <p>Security Hub populates this attribute automatically for each finding. You cannot update it using <code>BatchImportFindings</code> or <code>BatchUpdateFindings</code>.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 16. </p>', 'AwsSecurityFinding$GeneratorId' => '<p>The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security findings providers\' solutions, this generator can be called a rule, a check, a detector, a plugin, or something else.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 512.</p>', 'AwsSecurityFinding$AwsAccountId' => '<p>The Amazon Web Services account ID that a finding is generated in.</p> <p>Length Constraints: 12.</p>', 'AwsSecurityFinding$FirstObservedAt' => '<p>Indicates when the security findings provider first observed the potential security issue that a finding captured.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFinding$LastObservedAt' => '<p>Indicates when the security findings provider most recently observed the potential security issue that a finding captured.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFinding$CreatedAt' => '<p>Indicates when the security findings provider created the potential security issue that a finding captured.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFinding$UpdatedAt' => '<p>Indicates when the security findings provider last updated the finding record.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFinding$Title' => '<p>A finding\'s title. <code>Title</code> is a required property.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 256.</p>', 'AwsSecurityFinding$Description' => '<p>A finding\'s description. <code>Description</code> is a required property.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 1024.</p>', 'AwsSecurityFinding$SourceUrl' => '<p>A URL that links to a page about the current finding in the security findings provider\'s solution.</p>', 'AwsSecurityFinding$ProcessedAt' => '<p>A timestamp that indicates when Security Hub received a finding and begins to process it.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AwsSecurityFinding$AwsAccountName' => '<p>The name of the Amazon Web Services account from which a finding was generated. </p> <p>Length Constraints: Minimum length of 1. Maximum length of 50. </p>', 'AwsSecurityFindingIdentifier$Id' => '<p>The identifier of the finding that was specified by the finding provider.</p>', 'AwsSecurityFindingIdentifier$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.</p>', 'AwsSnsTopicDetails$KmsMasterKeyId' => '<p>The ID of an Amazon Web Services managed key for Amazon SNS or a customer managed key.</p>', 'AwsSnsTopicDetails$TopicName' => '<p>The name of the Amazon SNS topic.</p>', 'AwsSnsTopicDetails$Owner' => '<p>The subscription\'s owner.</p>', 'AwsSnsTopicDetails$SqsSuccessFeedbackRoleArn' => '<p>Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint. </p>', 'AwsSnsTopicDetails$SqsFailureFeedbackRoleArn' => '<p>Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint. </p>', 'AwsSnsTopicDetails$ApplicationSuccessFeedbackRoleArn' => '<p>Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint. </p>', 'AwsSnsTopicDetails$FirehoseSuccessFeedbackRoleArn' => '<p>Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint. </p>', 'AwsSnsTopicDetails$FirehoseFailureFeedbackRoleArn' => '<p>Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint. </p>', 'AwsSnsTopicDetails$HttpSuccessFeedbackRoleArn' => '<p>Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint. </p>', 'AwsSnsTopicDetails$HttpFailureFeedbackRoleArn' => '<p>Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint. </p>', 'AwsSnsTopicSubscription$Endpoint' => '<p>The subscription\'s endpoint (format depends on the protocol).</p>', 'AwsSnsTopicSubscription$Protocol' => '<p>The subscription\'s protocol.</p>', 'AwsSqsQueueDetails$KmsMasterKeyId' => '<p>The ID of an Amazon Web Services managed key for Amazon SQS or a custom KMS key.</p>', 'AwsSqsQueueDetails$QueueName' => '<p>The name of the new queue.</p>', 'AwsSqsQueueDetails$DeadLetterTargetArn' => '<p>The ARN of the dead-letter queue to which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded. </p>', 'AwsSsmComplianceSummary$Status' => '<p>The current patch compliance status. Valid values are as follows:</p> <ul> <li> <p> <code>COMPLIANT</code> </p> </li> <li> <p> <code>NON_COMPLIANT</code> </p> </li> <li> <p> <code>UNSPECIFIED_DATA</code> </p> </li> </ul>', 'AwsSsmComplianceSummary$ExecutionType' => '<p>The type of execution that was used determine compliance.</p>', 'AwsSsmComplianceSummary$ComplianceType' => '<p>The type of resource for which the compliance was determined. For <code>AwsSsmPatchCompliance</code>, <code>ComplianceType</code> is <code>Patch</code>. </p>', 'AwsSsmComplianceSummary$PatchBaselineId' => '<p>The identifier of the patch baseline. The patch baseline lists the patches that are approved for installation.</p>', 'AwsSsmComplianceSummary$OverallSeverity' => '<p>The highest severity for the patches. Valid values are as follows:</p> <ul> <li> <p> <code>CRITICAL</code> </p> </li> <li> <p> <code>HIGH</code> </p> </li> <li> <p> <code>MEDIUM</code> </p> </li> <li> <p> <code>LOW</code> </p> </li> <li> <p> <code>INFORMATIONAL</code> </p> </li> <li> <p> <code>UNSPECIFIED</code> </p> </li> </ul>', 'AwsSsmComplianceSummary$PatchGroup' => '<p>The identifier of the patch group for which compliance was determined. A patch group uses tags to group EC2 instances that should have the same patch compliance.</p>', 'AwsStepFunctionStateMachineDetails$Label' => '<p> A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is present only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN. </p>', 'AwsStepFunctionStateMachineDetails$Name' => '<p> The name of the state machine. </p>', 'AwsStepFunctionStateMachineDetails$RoleArn' => '<p> The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. </p>', 'AwsStepFunctionStateMachineDetails$StateMachineArn' => '<p> The ARN that identifies the state machine. </p>', 'AwsStepFunctionStateMachineDetails$Status' => '<p> The current status of the state machine. </p>', 'AwsStepFunctionStateMachineDetails$Type' => '<p> The type of the state machine (STANDARD or EXPRESS). </p>', 'AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails$LogGroupArn' => '<p>The ARN (ends with <code>:*</code>) of the CloudWatch Logs log group to which you want your logs emitted.</p>', 'AwsStepFunctionStateMachineLoggingConfigurationDetails$Level' => '<p> Defines which category of execution history events are logged. </p>', 'AwsWafRateBasedRuleDetails$MetricName' => '<p>The name of the metrics for the rate-based rule.</p>', 'AwsWafRateBasedRuleDetails$Name' => '<p>The name of the rate-based rule.</p>', 'AwsWafRateBasedRuleDetails$RateKey' => '<p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>', 'AwsWafRateBasedRuleDetails$RuleId' => '<p>The unique identifier for the rate-based rule.</p>', 'AwsWafRateBasedRuleMatchPredicate$DataId' => '<p>The unique identifier for the predicate.</p>', 'AwsWafRateBasedRuleMatchPredicate$Type' => '<p>The type of predicate. Valid values are as follows:</p> <ul> <li> <p> <code>ByteMatch</code> </p> </li> <li> <p> <code>GeoMatch</code> </p> </li> <li> <p> <code>IPMatch</code> </p> </li> <li> <p> <code>RegexMatch</code> </p> </li> <li> <p> <code>SizeConstraint</code> </p> </li> <li> <p> <code>SqlInjectionMatch</code> </p> </li> <li> <p> <code>XssMatch</code> </p> </li> </ul>', 'AwsWafRegionalRateBasedRuleDetails$MetricName' => '<p>The name of the metrics for the rate-based rule.</p>', 'AwsWafRegionalRateBasedRuleDetails$Name' => '<p>The name of the rate-based rule.</p>', 'AwsWafRegionalRateBasedRuleDetails$RateKey' => '<p>The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.</p>', 'AwsWafRegionalRateBasedRuleDetails$RuleId' => '<p>The unique identifier for the rate-based rule.</p>', 'AwsWafRegionalRateBasedRuleMatchPredicate$DataId' => '<p>The unique identifier for the predicate.</p>', 'AwsWafRegionalRateBasedRuleMatchPredicate$Type' => '<p>The type of predicate. Valid values are as follows:</p> <ul> <li> <p> <code>ByteMatch</code> </p> </li> <li> <p> <code>GeoMatch</code> </p> </li> <li> <p> <code>IPMatch</code> </p> </li> <li> <p> <code>RegexMatch</code> </p> </li> <li> <p> <code>SizeConstraint</code> </p> </li> <li> <p> <code>SqlInjectionMatch</code> </p> </li> <li> <p> <code>XssMatch</code> </p> </li> </ul>', 'AwsWafRegionalRuleDetails$MetricName' => '<p>A name for the metrics for the rule. </p>', 'AwsWafRegionalRuleDetails$Name' => '<p>A descriptive name for the rule. </p>', 'AwsWafRegionalRuleDetails$RuleId' => '<p>The ID of the rule. </p>', 'AwsWafRegionalRuleGroupDetails$MetricName' => '<p>A name for the metrics for this rule group. </p>', 'AwsWafRegionalRuleGroupDetails$Name' => '<p>The descriptive name of the rule group. </p>', 'AwsWafRegionalRuleGroupDetails$RuleGroupId' => '<p>The ID of the rule group. </p>', 'AwsWafRegionalRuleGroupRulesActionDetails$Type' => '<p>Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you want to negate the settings.</p>', 'AwsWafRegionalRuleGroupRulesDetails$RuleId' => '<p>The ID for a rule. </p>', 'AwsWafRegionalRuleGroupRulesDetails$Type' => '<p>The type of rule in the rule group. </p>', 'AwsWafRegionalRulePredicateListDetails$DataId' => '<p>A unique identifier for a predicate in a rule, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. </p>', 'AwsWafRegionalRulePredicateListDetails$Type' => '<p>The type of predicate in a rule, such as <code>ByteMatch</code> or <code>IPSet</code>. </p>', 'AwsWafRegionalWebAclDetails$DefaultAction' => '<p>The action to perform if none of the rules contained in the web ACL match. </p>', 'AwsWafRegionalWebAclDetails$MetricName' => '<p>A name for the metrics for this web ACL. </p>', 'AwsWafRegionalWebAclDetails$Name' => '<p>A descriptive name for the web ACL. </p>', 'AwsWafRegionalWebAclDetails$WebAclId' => '<p>The ID of the web ACL. </p>', 'AwsWafRegionalWebAclRulesListActionDetails$Type' => '<p>For actions that are associated with a rule, the action that WAF takes when a web request matches all conditions in a rule. </p>', 'AwsWafRegionalWebAclRulesListDetails$RuleId' => '<p>The ID of an WAF Regional rule to associate with a web ACL. </p>', 'AwsWafRegionalWebAclRulesListDetails$Type' => '<p>For actions that are associated with a rule, the action that WAF takes when a web request matches all conditions in a rule. </p>', 'AwsWafRegionalWebAclRulesListOverrideActionDetails$Type' => '<p>Overrides the rule evaluation result in the rule group. </p>', 'AwsWafRuleDetails$MetricName' => '<p>The name of the metrics for this rule. </p>', 'AwsWafRuleDetails$Name' => '<p>A descriptive name for the rule. </p>', 'AwsWafRuleDetails$RuleId' => '<p>The ID of the WAF rule. </p>', 'AwsWafRuleGroupDetails$MetricName' => '<p>The name of the metrics for this rule group. </p>', 'AwsWafRuleGroupDetails$Name' => '<p>The name of the rule group. </p>', 'AwsWafRuleGroupDetails$RuleGroupId' => '<p>The ID of the rule group. </p>', 'AwsWafRuleGroupRulesActionDetails$Type' => '<p>The action that WAF should take on a web request when it matches the rule\'s statement.</p>', 'AwsWafRuleGroupRulesDetails$RuleId' => '<p>The rule ID for a rule. </p>', 'AwsWafRuleGroupRulesDetails$Type' => '<p>The type of rule. </p>', 'AwsWafRulePredicateListDetails$DataId' => '<p>A unique identifier for a predicate in a rule, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. </p>', 'AwsWafRulePredicateListDetails$Type' => '<p>The type of predicate in a rule, such as <code>ByteMatch</code> or <code>IPSet</code>. </p>', 'AwsWafWebAclDetails$Name' => '<p>A friendly name or description of the web ACL. You can\'t change the name of a web ACL after you create it.</p>', 'AwsWafWebAclDetails$DefaultAction' => '<p>The action to perform if none of the rules contained in the web ACL match.</p>', 'AwsWafWebAclDetails$WebAclId' => '<p>A unique identifier for a web ACL.</p>', 'AwsWafWebAclRule$RuleId' => '<p>The identifier for a rule.</p>', 'AwsWafWebAclRule$Type' => '<p>The rule type.</p> <p>Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code> </p> <p>The default is <code>REGULAR</code>.</p>', 'AwsWafv2CustomHttpHeader$Name' => '<p> The name of the custom header. </p>', 'AwsWafv2CustomHttpHeader$Value' => '<p> The value of the custom header. </p>', 'AwsWafv2CustomResponseDetails$CustomResponseBodyKey' => '<p> References the response body that you want WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. </p>', 'AwsWafv2RuleGroupDetails$Description' => '<p> A description of the rule group that helps with identification. </p>', 'AwsWafv2RuleGroupDetails$Id' => '<p> A unique identifier for the rule group. </p>', 'AwsWafv2RuleGroupDetails$Name' => '<p> The name of the rule group. You cannot change the name of a rule group after you create it. </p>', 'AwsWafv2RuleGroupDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the entity. </p>', 'AwsWafv2RuleGroupDetails$Scope' => '<p> Specifies whether the rule group is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool. </p>', 'AwsWafv2RulesDetails$Name' => '<p> The name of the rule. </p>', 'AwsWafv2RulesDetails$OverrideAction' => '<p> The action to use in the place of the action that results from the rule group evaluation. </p>', 'AwsWafv2VisibilityConfigDetails$MetricName' => '<p> A name of the Amazon CloudWatch metric. </p>', 'AwsWafv2WebAclDetails$Name' => '<p> The name of the web ACL. </p>', 'AwsWafv2WebAclDetails$Arn' => '<p> The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource. </p>', 'AwsWafv2WebAclDetails$Id' => '<p> A unique identifier for the web ACL. </p>', 'AwsWafv2WebAclDetails$Description' => '<p> A description of the web ACL that helps with identification. </p>', 'AwsXrayEncryptionConfigDetails$KeyId' => '<p>The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.</p>', 'AwsXrayEncryptionConfigDetails$Status' => '<p>The current status of the encryption configuration. Valid values are <code>ACTIVE</code> or <code>UPDATING</code>.</p> <p>When <code>Status</code> is equal to <code>UPDATING</code>, X-Ray might use both the old and new encryption.</p>', 'AwsXrayEncryptionConfigDetails$Type' => '<p>The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code> indicates the default encryption.</p>', 'BatchUpdateFindingsUnprocessedFinding$ErrorCode' => '<p>The code associated with the error. Possible values are:</p> <ul> <li> <p> <code>ConcurrentUpdateError</code> - Another request attempted to update the finding while this request was being processed. This error may also occur if you call <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html"> <code>BatchUpdateFindings</code> </a> and <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html"> <code>BatchImportFindings</code> </a> at the same time.</p> </li> <li> <p> <code>DuplicatedFindingIdentifier</code> - The request included two or more findings with the same <code>FindingIdentifier</code>.</p> </li> <li> <p> <code>FindingNotFound</code> - The <code>FindingIdentifier</code> included in the request did not match an existing finding.</p> </li> <li> <p> <code>FindingSizeExceeded</code> - The finding size was greater than the permissible value of 240 KB.</p> </li> <li> <p> <code>InternalFailure</code> - An internal service failure occurred when updating the finding.</p> </li> <li> <p> <code>InvalidInput</code> - The finding update contained an invalid value that did not satisfy the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">Amazon Web Services Security Finding Format</a> syntax.</p> </li> </ul>', 'BatchUpdateFindingsUnprocessedFinding$ErrorMessage' => '<p>The message associated with the error. Possible values are:</p> <ul> <li> <p> <code>Concurrent finding updates detected</code> </p> </li> <li> <p> <code>Finding Identifier is duplicated</code> </p> </li> <li> <p> <code>Finding Not Found</code> </p> </li> <li> <p> <code>Finding size exceeded 240 KB</code> </p> </li> <li> <p> <code>Internal service failure</code> </p> </li> <li> <p> <code>Invalid Input</code> </p> </li> </ul>', 'CategoryList$member' => NULL, 'Cell$ColumnName' => '<p>The name of the column that contains the data.</p>', 'Cell$CellReference' => '<p>For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.</p>', 'CidrBlockAssociation$AssociationId' => '<p>The association ID for the IPv4 CIDR block.</p>', 'CidrBlockAssociation$CidrBlock' => '<p>The IPv4 CIDR block.</p>', 'CidrBlockAssociation$CidrBlockState' => '<p>Information about the state of the IPv4 CIDR block.</p>', 'City$CityName' => '<p>The name of the city.</p>', 'ClassificationResult$MimeType' => '<p>The type of content that the finding applies to.</p>', 'ClassificationStatus$Code' => '<p>The code that represents the status of the sensitive data detection.</p>', 'ClassificationStatus$Reason' => '<p>A longer description of the current status of the sensitive data detection.</p>', 'CloudWatchLogsLogGroupArnConfigDetails$CloudWatchLogsLogGroupArn' => '<p> The ARN of the CloudWatch Logs log group that Route 53 is publishing logs to.</p>', 'CloudWatchLogsLogGroupArnConfigDetails$HostedZoneId' => '<p> The ID of the hosted zone that CloudWatch Logs is logging queries for. </p>', 'CloudWatchLogsLogGroupArnConfigDetails$Id' => '<p> The ID for a DNS query logging configuration. </p>', 'CodeVulnerabilitiesFilePath$FileName' => '<p> The name of the file in which the code vulnerability is located. </p>', 'CodeVulnerabilitiesFilePath$FilePath' => '<p> The file path to the code in which the vulnerability is located. </p>', 'Compliance$SecurityControlId' => '<p> The unique identifier of a control across standards. Values for this field typically consist of an Amazon Web Servicesservice and a number, such as APIGateway.5. </p>', 'ConfigurationPolicyAssociationSummary$ConfigurationPolicyId' => '<p> The universally unique identifier (UUID) of the configuration policy. </p>', 'ConfigurationPolicyAssociationSummary$TargetId' => '<p> The identifier of the target account, organizational unit, or the root. </p>', 'ConfigurationPolicyAssociationSummary$AssociationStatusMessage' => '<p> The explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>. </p>', 'ConfigurationPolicySummary$Arn' => '<p> The Amazon Resource Name (ARN) of the configuration policy. </p>', 'ConfigurationPolicySummary$Id' => '<p> The universally unique identifier (UUID) of the configuration policy. </p>', 'ConfigurationPolicySummary$Name' => '<p> The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted: <code>-, ., !, *, /</code>. </p>', 'ConfigurationPolicySummary$Description' => '<p> The description of the configuration policy. </p>', 'ContainerDetails$ContainerRuntime' => '<p>The runtime of the container. </p>', 'ContainerDetails$Name' => '<p>The name of the container related to a finding.</p>', 'ContainerDetails$ImageId' => '<p>The identifier of the container image related to a finding.</p>', 'ContainerDetails$ImageName' => '<p>The name of the container image related to a finding.</p>', 'ContainerDetails$LaunchedAt' => '<p>Indicates when the container started.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'Country$CountryCode' => '<p>The 2-letter ISO 3166 country code for the country.</p>', 'Country$CountryName' => '<p>The name of the country.</p>', 'CreateActionTargetRequest$Name' => '<p>The name of the custom action target. Can contain up to 20 characters.</p>', 'CreateActionTargetRequest$Description' => '<p>The description for the custom action target.</p>', 'CreateActionTargetRequest$Id' => '<p>The ID for the custom action target. Can contain up to 20 alphanumeric characters.</p>', 'CreateActionTargetResponse$ActionTargetArn' => '<p>The Amazon Resource Name (ARN) for the custom action target.</p>', 'CreateAutomationRuleRequest$RuleName' => '<p> The name of the rule. </p>', 'CreateAutomationRuleRequest$Description' => '<p> A description of the rule. </p>', 'CreateAutomationRuleResponse$RuleArn' => '<p> The Amazon Resource Name (ARN) of the automation rule that you created. </p>', 'CreateConfigurationPolicyRequest$Name' => '<p> The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted: <code>-, ., !, *, /</code>. </p>', 'CreateConfigurationPolicyRequest$Description' => '<p> The description of the configuration policy. </p>', 'CreateConfigurationPolicyResponse$Arn' => '<p> The Amazon Resource Name (ARN) of the configuration policy. </p>', 'CreateConfigurationPolicyResponse$Id' => '<p> The universally unique identifier (UUID) of the configuration policy. </p>', 'CreateConfigurationPolicyResponse$Name' => '<p> The name of the configuration policy. </p>', 'CreateConfigurationPolicyResponse$Description' => '<p> The description of the configuration policy. </p>', 'CreateFindingAggregatorRequest$RegionLinkingMode' => '<p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p> <p>The selected option also determines how to use the Regions provided in the Regions list.</p> <p>The options are as follows:</p> <ul> <li> <p> <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li> <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li> <li> <p> <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li> <li> <p> <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions. </p> </li> </ul>', 'CreateFindingAggregatorResponse$FindingAggregatorArn' => '<p>The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and stop finding aggregation.</p>', 'CreateFindingAggregatorResponse$FindingAggregationRegion' => '<p>The aggregation Region.</p>', 'CreateFindingAggregatorResponse$RegionLinkingMode' => '<p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>', 'CreateInsightRequest$Name' => '<p>The name of the custom insight to create.</p>', 'CreateInsightRequest$GroupByAttribute' => '<p>The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>', 'CreateInsightResponse$InsightArn' => '<p>The ARN of the insight created.</p>', 'CustomDataIdentifiersDetections$Arn' => '<p>The ARN of the custom identifier that was used to detect the sensitive data.</p>', 'CustomDataIdentifiersDetections$Name' => '<p>he name of the custom identifier that detected the sensitive data.</p>', 'Cvss$Version' => '<p>The version of CVSS for the CVSS score.</p>', 'Cvss$BaseVector' => '<p>The base scoring vector for the CVSS score.</p>', 'Cvss$Source' => '<p>The origin of the original CVSS score and vector.</p>', 'DataClassificationDetails$DetailedResultsLocation' => '<p>The path to the folder or file that contains the sensitive data.</p>', 'DateFilter$Start' => '<p>A timestamp that provides the start date for the date filter.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'DateFilter$End' => '<p>A timestamp that provides the end date for the date filter.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'DeleteActionTargetRequest$ActionTargetArn' => '<p>The Amazon Resource Name (ARN) of the custom action target to delete.</p>', 'DeleteActionTargetResponse$ActionTargetArn' => '<p>The ARN of the custom action target that was deleted.</p>', 'DeleteConfigurationPolicyRequest$Identifier' => '<p> The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy. </p>', 'DeleteFindingAggregatorRequest$FindingAggregatorArn' => '<p>The ARN of the finding aggregator to delete. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>', 'DeleteInsightRequest$InsightArn' => '<p>The ARN of the insight to delete.</p>', 'DeleteInsightResponse$InsightArn' => '<p>The ARN of the insight that was deleted.</p>', 'DescribeHubRequest$HubArn' => '<p>The ARN of the Hub resource to retrieve.</p>', 'DescribeHubResponse$HubArn' => '<p>The ARN of the Hub resource that was retrieved.</p>', 'DescribeHubResponse$SubscribedAt' => '<p>The date and time when Security Hub was enabled in the account.</p>', 'DescribeProductsRequest$ProductArn' => '<p>The ARN of the integration to return.</p>', 'DescribeStandardsControlsRequest$StandardsSubscriptionArn' => '<p>The ARN of a resource that represents your subscription to a supported standard. To get the subscription ARNs of the standards you have enabled, use the <code>GetEnabledStandards</code> operation.</p>', 'DisableImportFindingsForProductRequest$ProductSubscriptionArn' => '<p>The ARN of the integrated product to disable the integration for.</p>', 'DisableOrganizationAdminAccountRequest$AdminAccountId' => '<p>The Amazon Web Services account identifier of the Security Hub administrator account.</p>', 'DisabledSecurityControlIdentifierList$member' => NULL, 'DnsRequestAction$Domain' => '<p>The DNS domain that is associated with the DNS request.</p> <p>Length Constraints: 128.</p>', 'DnsRequestAction$Protocol' => '<p>The protocol that was used for the DNS request.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 64.</p>', 'EnableImportFindingsForProductRequest$ProductArn' => '<p>The ARN of the product to enable the integration for.</p>', 'EnableImportFindingsForProductResponse$ProductSubscriptionArn' => '<p>The ARN of your subscription to the product to enable integrations for.</p>', 'EnableOrganizationAdminAccountRequest$AdminAccountId' => '<p>The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.</p>', 'EnabledSecurityControlIdentifierList$member' => NULL, 'EnabledStandardIdentifierList$member' => NULL, 'EnumConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is an enum. </p>', 'FieldMap$key' => NULL, 'FieldMap$value' => NULL, 'FilePaths$FilePath' => '<p>Path to the infected or suspicious file on the resource it was detected on. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'FilePaths$FileName' => '<p>The name of the infected or suspicious file corresponding to the hash. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'FilePaths$ResourceId' => '<p>The Amazon Resource Name (ARN) of the resource on which the threat was detected. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'FilePaths$Hash' => '<p>The hash value for the infected or suspicious file. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'FindingAggregator$FindingAggregatorArn' => '<p>The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and delete the finding aggregator.</p>', 'FindingHistoryUpdate$UpdatedField' => '<p> The ASFF field that changed during the finding change event. </p>', 'FindingHistoryUpdate$OldValue' => '<p> The value of the ASFF field before the finding change event. </p>', 'FindingHistoryUpdate$NewValue' => '<p> The value of the ASFF field after the finding change event. To preserve storage and readability, Security Hub omits this value if <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html"> <code>FindingHistoryRecord</code> </a> exceeds database limits. </p>', 'FindingHistoryUpdateSource$Identity' => '<p> The identity of the source that initiated the finding change event. For example, the Amazon Resource Name (ARN) of a partner that calls BatchImportFindings or of a customer that calls BatchUpdateFindings. </p>', 'FindingProviderSeverity$Original' => '<p>The finding provider\'s original value for the severity.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 64.</p>', 'FirewallPolicyStatefulRuleGroupReferencesDetails$ResourceArn' => '<p>The ARN of the stateful rule group.</p>', 'FirewallPolicyStatelessCustomActionsDetails$ActionName' => '<p>The name of the custom action.</p>', 'FirewallPolicyStatelessRuleGroupReferencesDetails$ResourceArn' => '<p>The ARN of the stateless rule group.</p>', 'GeneratorDetails$Name' => '<p> The name of the detector used to identify the code vulnerability. </p>', 'GeneratorDetails$Description' => '<p> The description of the detector used to identify the code vulnerability. </p>', 'GetConfigurationPolicyAssociationResponse$ConfigurationPolicyId' => '<p> The universally unique identifier (UUID) of a configuration policy. For self-managed behavior, the value is <code>SELF_MANAGED_SECURITY_HUB</code>. </p>', 'GetConfigurationPolicyAssociationResponse$TargetId' => '<p> The target account ID, organizational unit ID, or the root ID for which the association is retrieved. </p>', 'GetConfigurationPolicyAssociationResponse$AssociationStatusMessage' => '<p> The explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>. </p>', 'GetConfigurationPolicyRequest$Identifier' => '<p> The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy. </p>', 'GetConfigurationPolicyResponse$Arn' => '<p> The ARN of the configuration policy. </p>', 'GetConfigurationPolicyResponse$Id' => '<p> The UUID of the configuration policy. </p>', 'GetConfigurationPolicyResponse$Name' => '<p> The name of the configuration policy. </p>', 'GetConfigurationPolicyResponse$Description' => '<p> The description of the configuration policy. </p>', 'GetFindingAggregatorRequest$FindingAggregatorArn' => '<p>The ARN of the finding aggregator to return details for. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>', 'GetFindingAggregatorResponse$FindingAggregatorArn' => '<p>The ARN of the finding aggregator.</p>', 'GetFindingAggregatorResponse$FindingAggregationRegion' => '<p>The aggregation Region.</p>', 'GetFindingAggregatorResponse$RegionLinkingMode' => '<p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>', 'GetInsightResultsRequest$InsightArn' => '<p>The ARN of the insight for which to return results.</p>', 'GetSecurityControlDefinitionRequest$SecurityControlId' => '<p> The ID of the security control to retrieve the definition for. This field doesn’t accept an Amazon Resource Name (ARN). </p>', 'ImportFindingsError$Id' => '<p>The identifier of the finding that could not be updated.</p>', 'ImportFindingsError$ErrorCode' => '<p>The code of the error returned by the <code>BatchImportFindings</code> operation.</p>', 'ImportFindingsError$ErrorMessage' => '<p>The message of the error returned by the <code>BatchImportFindings</code> operation.</p>', 'Insight$InsightArn' => '<p>The ARN of a Security Hub insight.</p>', 'Insight$Name' => '<p>The name of a Security Hub insight.</p>', 'Insight$GroupByAttribute' => '<p>The grouping attribute for the insight\'s findings. Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>', 'InsightResultValue$GroupByAttributeValue' => '<p>The value of the attribute that the findings are grouped by for the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InsightResults$InsightArn' => '<p>The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InsightResults$GroupByAttribute' => '<p>The attribute that the findings are grouped by for the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InternalException$Message' => NULL, 'InternalException$Code' => NULL, 'InvalidAccessException$Message' => NULL, 'InvalidAccessException$Code' => NULL, 'InvalidInputException$Message' => NULL, 'InvalidInputException$Code' => NULL, 'Invitation$InvitationId' => '<p>The ID of the invitation sent to the member account.</p>', 'Invitation$MemberStatus' => '<p>The current status of the association between the member and administrator accounts.</p>', 'IpFilter$Cidr' => '<p>A finding\'s CIDR value.</p>', 'IpOrganizationDetails$AsnOrg' => '<p>The name of the organization that registered the ASN.</p>', 'IpOrganizationDetails$Isp' => '<p>The ISP information for the internet provider.</p>', 'IpOrganizationDetails$Org' => '<p>The name of the internet provider.</p>', 'Ipv6CidrBlockAssociation$AssociationId' => '<p>The association ID for the IPv6 CIDR block.</p>', 'Ipv6CidrBlockAssociation$Ipv6CidrBlock' => '<p>The IPv6 CIDR block.</p>', 'Ipv6CidrBlockAssociation$CidrBlockState' => '<p>Information about the state of the CIDR block. Valid values are as follows:</p> <ul> <li> <p> <code>associating</code> </p> </li> <li> <p> <code>associated</code> </p> </li> <li> <p> <code>disassociating</code> </p> </li> <li> <p> <code>disassociated</code> </p> </li> <li> <p> <code>failed</code> </p> </li> <li> <p> <code>failing</code> </p> </li> </ul>', 'KeywordFilter$Value' => '<p>A value for the keyword.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$Code' => NULL, 'ListInvitationsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListMembersResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListSecurityControlDefinitionsRequest$StandardsArn' => '<p> The Amazon Resource Name (ARN) of the standard that you want to view controls for. </p>', 'ListStandardsControlAssociationsRequest$SecurityControlId' => '<p> The identifier of the control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) that you want to determine the enablement status of in each enabled standard. </p>', 'LoadBalancerState$Code' => '<p>The state code. The initial state of the load balancer is provisioning.</p> <p>After the load balancer is fully set up and ready to route traffic, its state is active.</p> <p>If the load balancer could not be set up, its state is failed. </p>', 'LoadBalancerState$Reason' => '<p>A description of the state.</p>', 'Malware$Name' => '<p>The name of the malware that was observed.</p> <p>Length Constraints: Minimum of 1. Maximum of 64.</p>', 'Malware$Path' => '<p>The file system path of the malware that was observed.</p> <p>Length Constraints: Minimum of 1. Maximum of 512.</p>', 'MapFilter$Key' => '<p>The key of the map filter. For example, for <code>ResourceTags</code>, <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code>, <code>Key</code> is the name of the field.</p>', 'MapFilter$Value' => '<p>The value for the key in the map filter. Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code>. If you provide <code>security</code> as the filter value, then there\'s no match.</p>', 'Member$Email' => '<p>The email address of the member account.</p>', 'Member$MasterId' => '<p>This is replaced by <code>AdministratorID</code>.</p> <p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>', 'Member$AdministratorId' => '<p>The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.</p>', 'Member$MemberStatus' => '<p>The status of the relationship between the member account and its administrator account. </p> <p>The status can have one of the following values:</p> <ul> <li> <p> <code>Created</code> - Indicates that the administrator account added the member account, but has not yet invited the member account.</p> </li> <li> <p> <code>Invited</code> - Indicates that the administrator account invited the member account. The member account has not yet responded to the invitation.</p> </li> <li> <p> <code>Enabled</code> - Indicates that the member account is currently active. For manually invited member accounts, indicates that the member account accepted the invitation.</p> </li> <li> <p> <code>Removed</code> - Indicates that the administrator account disassociated the member account.</p> </li> <li> <p> <code>Resigned</code> - Indicates that the member account disassociated themselves from the administrator account.</p> </li> <li> <p> <code>Deleted</code> - Indicates that the administrator account deleted the member account.</p> </li> <li> <p> <code>AccountSuspended</code> - Indicates that an organization account was suspended from Amazon Web Services at the same time that the administrator account tried to enable the organization account as a member account.</p> </li> </ul>', 'Network$Protocol' => '<p>The protocol of network-related information about a finding.</p> <p>Length Constraints: Minimum of 1. Maximum of 16.</p>', 'Network$SourceIpV4' => '<p>The source IPv4 address of network-related information about a finding.</p>', 'Network$SourceIpV6' => '<p>The source IPv6 address of network-related information about a finding.</p>', 'Network$SourceDomain' => '<p>The source domain of network-related information about a finding.</p> <p>Length Constraints: Minimum of 1. Maximum of 128.</p>', 'Network$SourceMac' => '<p>The source media access control (MAC) address of network-related information about a finding.</p>', 'Network$DestinationIpV4' => '<p>The destination IPv4 address of network-related information about a finding.</p>', 'Network$DestinationIpV6' => '<p>The destination IPv6 address of network-related information about a finding.</p>', 'Network$DestinationDomain' => '<p>The destination domain of network-related information about a finding.</p> <p>Length Constraints: Minimum of 1. Maximum of 128.</p>', 'NetworkConnectionAction$ConnectionDirection' => '<p>The direction of the network connection request (<code>IN</code> or <code>OUT</code>).</p>', 'NetworkConnectionAction$Protocol' => '<p>The protocol used to make the network connection request.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 64.</p>', 'NetworkHeader$Protocol' => '<p>The protocol used for the component.</p> <p>Length Constraints: Minimum of 1. Maximum of 16.</p>', 'NetworkPathComponent$ComponentId' => '<p>The identifier of a component in the network path.</p> <p>Length Constraints: Minimum of 1. Maximum of 32.</p>', 'NetworkPathComponent$ComponentType' => '<p>The type of component.</p> <p>Length Constraints: Minimum of 1. Maximum of 32.</p>', 'NonEmptyStringList$member' => NULL, 'Note$Text' => '<p>The text of a note.</p> <p>Length Constraints: Minimum of 1. Maximum of 512.</p>', 'Note$UpdatedBy' => '<p>The principal that created a note.</p>', 'Note$UpdatedAt' => '<p>A timestamp that indicates when the note was updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'NoteUpdate$Text' => '<p>The updated note text.</p>', 'NoteUpdate$UpdatedBy' => '<p>The principal that updated the note.</p>', 'OrganizationConfiguration$StatusMessage' => '<p> Provides an explanation if the value of <code>Status</code> is equal to <code>FAILED</code> when <code>ConfigurationType</code> is equal to <code>CENTRAL</code>. </p>', 'ParameterDefinition$Description' => '<p> Description of a control parameter. </p>', 'ParameterDefinitions$key' => NULL, 'ParameterValue$String' => '<p> A control parameter that is a string. </p>', 'ParameterValue$Enum' => '<p> A control parameter that is an enum. </p>', 'Parameters$key' => NULL, 'PatchSummary$Id' => '<p>The identifier of the compliance standard that was used to determine the patch compliance status.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 256.</p>', 'PatchSummary$OperationStartTime' => '<p>Indicates when the operation started.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'PatchSummary$OperationEndTime' => '<p>Indicates when the operation completed.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'PatchSummary$RebootOption' => '<p>The reboot option specified for the instance.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 256.</p>', 'PatchSummary$Operation' => '<p>The type of patch operation performed. For Patch Manager, the values are <code>SCAN</code> and <code>INSTALL</code>.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 256.</p>', 'ProcessDetails$Name' => '<p>The name of the process.</p> <p>Length Constraints: Minimum of 1. Maximum of 64.</p>', 'ProcessDetails$Path' => '<p>The path to the process executable.</p> <p>Length Constraints: Minimum of 1. Maximum of 512.</p>', 'ProcessDetails$LaunchedAt' => '<p>Indicates when the process was launched.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'ProcessDetails$TerminatedAt' => '<p>Indicates when the process was terminated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'Product$ProductArn' => '<p>The ARN assigned to the product.</p>', 'Product$ProductName' => '<p>The name of the product.</p>', 'Product$CompanyName' => '<p>The name of the company that provides the product.</p>', 'Product$Description' => '<p>A description of the product.</p>', 'Product$MarketplaceUrl' => '<p>For integrations with Amazon Web Services services, the Amazon Web Services Console URL from which to activate the service.</p> <p>For integrations with third-party products, the Amazon Web Services Marketplace URL from which to subscribe to or purchase the product.</p>', 'Product$ActivationUrl' => '<p>The URL to the service or product documentation about the integration with Security Hub, including how to activate the integration.</p>', 'Product$ProductSubscriptionResourcePolicy' => '<p>The resource policy associated with the product.</p>', 'ProductSubscriptionArnList$member' => NULL, 'PropagatingVgwSetDetails$GatewayId' => '<p> The ID of the virtual private gateway. </p>', 'Recommendation$Text' => '<p>Describes the recommended steps to take to remediate an issue identified in a finding.</p> <p>Length Constraints: Minimum of 1 length. Maximum of 512 length.</p>', 'Recommendation$Url' => '<p>A URL to a page or site that contains information about how to remediate a finding.</p>', 'Record$JsonPath' => '<p>The path, as a JSONPath expression, to the field in the record that contains the data. If the field name is longer than 20 characters, it is truncated. If the path is longer than 250 characters, it is truncated.</p>', 'RelatedFinding$ProductArn' => '<p>The ARN of the product that generated a related finding.</p>', 'RelatedFinding$Id' => '<p>The product-generated identifier for a related finding.</p>', 'RelatedRequirementsList$member' => NULL, 'Resource$Type' => '<p>The type of the resource that details are provided for. If possible, set <code>Type</code> to one of the supported resource types. For example, if the resource is an EC2 instance, then set <code>Type</code> to <code>AwsEc2Instance</code>.</p> <p>If the resource does not match any of the provided types, then set <code>Type</code> to <code>Other</code>. </p> <p>Length Constraints: Minimum length of 1. Maximum length of 256.</p>', 'Resource$Id' => '<p>The canonical identifier for the given resource type.</p>', 'Resource$Region' => '<p>The canonical Amazon Web Services external Region name where this resource is located.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 16.</p>', 'Resource$ResourceRole' => '<p>Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,</p>', 'Resource$ApplicationName' => '<p> The name of the application that is related to a finding. </p>', 'Resource$ApplicationArn' => '<p> The Amazon Resource Name (ARN) of the application that is related to a finding. </p>', 'ResourceConflictException$Message' => NULL, 'ResourceConflictException$Code' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceInUseException$Code' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$Code' => NULL, 'Result$ProcessingResult' => '<p>The reason that the account was not processed.</p>', 'RouteSetDetails$CarrierGatewayId' => '<p> The ID of the carrier gateway. </p>', 'RouteSetDetails$CoreNetworkArn' => '<p> The Amazon Resource Name (ARN) of the core network. </p>', 'RouteSetDetails$DestinationCidrBlock' => '<p> The IPv4 CIDR block used for the destination match. </p>', 'RouteSetDetails$DestinationIpv6CidrBlock' => '<p> The IPv6 CIDR block used for the destination match. </p>', 'RouteSetDetails$DestinationPrefixListId' => '<p> The prefix of the destination Amazon Web Servicesservice. </p>', 'RouteSetDetails$EgressOnlyInternetGatewayId' => '<p> The ID of the egress-only internet gateway. </p>', 'RouteSetDetails$GatewayId' => '<p> The ID of a gateway attached to your VPC. </p>', 'RouteSetDetails$InstanceId' => '<p> The ID of a NAT instance in your VPC. </p>', 'RouteSetDetails$InstanceOwnerId' => '<p> The ID of the Amazon Web Services account that owns the instance. </p>', 'RouteSetDetails$LocalGatewayId' => '<p> The ID of the local gateway. </p>', 'RouteSetDetails$NatGatewayId' => '<p> The ID of a NAT gateway. </p>', 'RouteSetDetails$NetworkInterfaceId' => '<p> The ID of the network interface. </p>', 'RouteSetDetails$Origin' => '<p> Describes how the route was created. </p>', 'RouteSetDetails$State' => '<p> The state of the route. </p>', 'RouteSetDetails$TransitGatewayId' => '<p> The ID of a transit gateway. </p>', 'RouteSetDetails$VpcPeeringConnectionId' => '<p> The ID of a VPC peering connection. </p>', 'RuleGroupSource$RulesString' => '<p>Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.</p>', 'RuleGroupSourceCustomActionsDetails$ActionName' => '<p>A descriptive name of the custom action.</p>', 'RuleGroupSourceListDetails$GeneratedRulesType' => '<p>Indicates whether to allow or deny access to the domains listed in <code>Targets</code>.</p>', 'RuleGroupSourceStatefulRulesDetails$Action' => '<p>Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$Destination' => '<p>The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify <code>ANY</code>.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$DestinationPort' => '<p>The destination port to inspect for. You can specify an individual port, such as <code>1994</code>. You also can specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$Direction' => '<p>The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$Protocol' => '<p>The protocol to inspect for. To inspector for all protocols, use <code>IP</code>.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$Source' => '<p>The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify <code>ANY</code>.</p>', 'RuleGroupSourceStatefulRulesHeaderDetails$SourcePort' => '<p>The source port to inspect for. You can specify an individual port, such as <code>1994</code>. You also can specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.</p>', 'RuleGroupSourceStatefulRulesOptionsDetails$Keyword' => '<p>A keyword to look for.</p>', 'RuleGroupSourceStatefulRulesRuleOptionsSettingsList$member' => NULL, 'RuleGroupSourceStatelessRuleMatchAttributesDestinations$AddressDefinition' => '<p>An IP address or a block of IP addresses.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesSources$AddressDefinition' => '<p>An IP address or a block of IP addresses.</p>', 'SecurityControl$SecurityControlId' => '<p> The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Servicesservice name and a number, such as APIGateway.3. </p>', 'SecurityControl$SecurityControlArn' => '<p> The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code>. This parameter doesn\'t mention a specific standard. </p>', 'SecurityControl$Title' => '<p>The title of a security control. </p>', 'SecurityControl$Description' => '<p> The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn\'t reference a specific standard. </p>', 'SecurityControl$RemediationUrl' => '<p> A link to Security Hub documentation that explains how to remediate a failed finding for a security control. </p>', 'SecurityControlCustomParameter$SecurityControlId' => '<p> The ID of the security control. </p>', 'SecurityControlDefinition$SecurityControlId' => '<p> The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Servicesservice name and a number (for example, APIGateway.3). This parameter differs from <code>SecurityControlArn</code>, which is a unique Amazon Resource Name (ARN) assigned to a control. The ARN references the security control ID (for example, arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3). </p>', 'SecurityControlDefinition$Title' => '<p> The title of a security control. </p>', 'SecurityControlDefinition$Description' => '<p> The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn\'t reference a specific standard. </p>', 'SecurityControlDefinition$RemediationUrl' => '<p> A link to Security Hub documentation that explains how to remediate a failed finding for a security control. </p>', 'SecurityControlParameter$Name' => '<p> The name of a </p>', 'SecurityGroups$member' => NULL, 'SensitiveDataDetections$Type' => '<p>The type of sensitive data that was detected. For example, the type might indicate that the data is an email address.</p>', 'SensitiveDataResult$Category' => '<p>The category of sensitive data that was detected. For example, the category can indicate that the sensitive data involved credentials, financial information, or personal information.</p>', 'Severity$Original' => '<p>The native severity from the finding product that generated the finding.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 64.</p>', 'SoftwarePackage$Name' => '<p>The name of the software package.</p>', 'SoftwarePackage$Version' => '<p>The version of the software package.</p>', 'SoftwarePackage$Epoch' => '<p>The epoch of the software package.</p>', 'SoftwarePackage$Release' => '<p>The release of the software package.</p>', 'SoftwarePackage$Architecture' => '<p>The architecture used for the software package.</p>', 'SoftwarePackage$PackageManager' => '<p>The source of the package.</p>', 'SoftwarePackage$FilePath' => '<p>The file system path to the package manager inventory file.</p>', 'SoftwarePackage$FixedInVersion' => '<p>The version of the software package in which the vulnerability has been resolved. </p>', 'SoftwarePackage$Remediation' => '<p>Describes the actions a customer can take to resolve the vulnerability in the software package. </p>', 'SoftwarePackage$SourceLayerHash' => '<p>The source layer hash of the vulnerable package. </p>', 'SoftwarePackage$SourceLayerArn' => '<p>The Amazon Resource Name (ARN) of the source layer. </p>', 'SortCriterion$Field' => '<p>The finding attribute used to sort findings.</p>', 'Standard$StandardsArn' => '<p>The ARN of a standard.</p>', 'Standard$Name' => '<p>The name of the standard.</p>', 'Standard$Description' => '<p>A description of the standard.</p>', 'StandardsControl$StandardsControlArn' => '<p>The ARN of the security standard control.</p>', 'StandardsControl$DisabledReason' => '<p>The reason provided for the most recent change in status for the control.</p>', 'StandardsControl$ControlId' => '<p>The identifier of the security standard control.</p>', 'StandardsControl$Title' => '<p>The title of the security standard control.</p>', 'StandardsControl$Description' => '<p>The longer description of the security standard control. Provides information about what the control is checking for.</p>', 'StandardsControl$RemediationUrl' => '<p>A link to remediation information for the control in the Security Hub user documentation.</p>', 'StandardsControlArnList$member' => NULL, 'StandardsControlAssociationDetail$StandardsArn' => '<p> The Amazon Resource Name (ARN) of a security standard. </p>', 'StandardsControlAssociationDetail$SecurityControlId' => '<p> The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Servicesservice name and a number, such as APIGateway.3. </p>', 'StandardsControlAssociationDetail$SecurityControlArn' => '<p> The ARN of a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code>. This parameter doesn\'t mention a specific standard. </p>', 'StandardsControlAssociationDetail$UpdatedReason' => '<p> The reason for updating the enablement status of a control in a specified standard. </p>', 'StandardsControlAssociationDetail$StandardsControlTitle' => '<p> The title of a control. This field may reference a specific standard. </p>', 'StandardsControlAssociationDetail$StandardsControlDescription' => '<p> The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter may reference a specific standard. </p>', 'StandardsControlAssociationId$SecurityControlId' => '<p> The unique identifier (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) of a security control across standards. </p>', 'StandardsControlAssociationId$StandardsArn' => '<p> The ARN of a standard. </p>', 'StandardsControlAssociationSummary$StandardsArn' => '<p> The Amazon Resource Name (ARN) of a standard. </p>', 'StandardsControlAssociationSummary$SecurityControlId' => '<p> A unique standard-agnostic identifier for a control. Values for this field typically consist of an Amazon Web Servicesservice and a number, such as APIGateway.5. This field doesn\'t reference a specific standard. </p>', 'StandardsControlAssociationSummary$SecurityControlArn' => '<p> The ARN of a control, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code>. This parameter doesn\'t mention a specific standard. </p>', 'StandardsControlAssociationSummary$UpdatedReason' => '<p>The reason for updating a control\'s enablement status in a specified standard.</p>', 'StandardsControlAssociationSummary$StandardsControlTitle' => '<p> The title of a control. </p>', 'StandardsControlAssociationSummary$StandardsControlDescription' => '<p> The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. The parameter may reference a specific standard. </p>', 'StandardsControlAssociationUpdate$StandardsArn' => '<p>The Amazon Resource Name (ARN) of the standard in which you want to update the control\'s enablement status.</p>', 'StandardsControlAssociationUpdate$SecurityControlId' => '<p>The unique identifier for the security control whose enablement status you want to update.</p>', 'StandardsControlAssociationUpdate$UpdatedReason' => '<p>The reason for updating the control\'s enablement status in the standard.</p>', 'StandardsInputParameterMap$key' => NULL, 'StandardsInputParameterMap$value' => NULL, 'StandardsManagedBy$Company' => '<p>An identifier for the company that manages a specific security standard. For existing standards, the value is equal to <code>Amazon Web Services</code>.</p>', 'StandardsManagedBy$Product' => '<p>An identifier for the product that manages a specific security standard. For existing standards, the value is equal to the Amazon Web Services service that manages the standard.</p>', 'StandardsSubscription$StandardsSubscriptionArn' => '<p>The ARN of a resource that represents your subscription to a supported standard.</p>', 'StandardsSubscription$StandardsArn' => '<p>The ARN of a standard.</p>', 'StandardsSubscriptionArns$member' => NULL, 'StandardsSubscriptionRequest$StandardsArn' => '<p>The ARN of the standard that you want to enable. To view the list of available standards and their ARNs, use the <code>DescribeStandards</code> operation.</p>', 'StartConfigurationPolicyAssociationRequest$ConfigurationPolicyIdentifier' => '<p> The Amazon Resource Name (ARN) of a configuration policy, the universally unique identifier (UUID) of a configuration policy, or a value of <code>SELF_MANAGED_SECURITY_HUB</code> for a self-managed configuration. </p>', 'StartConfigurationPolicyAssociationResponse$ConfigurationPolicyId' => '<p> The UUID of the configuration policy. </p>', 'StartConfigurationPolicyAssociationResponse$TargetId' => '<p> The identifier of the target account, organizational unit, or the organization root with which the configuration is associated. </p>', 'StartConfigurationPolicyAssociationResponse$AssociationStatusMessage' => '<p> An explanation for a <code>FAILED</code> value for <code>AssociationStatus</code>. </p>', 'StartConfigurationPolicyDisassociationRequest$ConfigurationPolicyIdentifier' => '<p> The Amazon Resource Name (ARN) of a configuration policy, the universally unique identifier (UUID) of a configuration policy, or a value of <code>SELF_MANAGED_SECURITY_HUB</code> for a self-managed configuration. </p>', 'StatelessCustomPublishMetricActionDimension$Value' => '<p>The value to use for the custom metric dimension.</p>', 'StatusReason$ReasonCode' => '<p>A code that represents a reason for the control status. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the <i>Security Hub User Guide</i>. </p>', 'StatusReason$Description' => '<p>The corresponding description for the status reason code.</p>', 'StringConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is a string. </p>', 'StringConfigurationOptions$Re2Expression' => '<p> An RE2 regular expression that Security Hub uses to validate a user-provided control parameter string. </p>', 'StringConfigurationOptions$ExpressionDescription' => '<p> The description of the RE2 regular expression. </p>', 'StringFilter$Value' => '<p>The string filter value. Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code>. If you provide <code>security hub</code> as the filter value, there\'s no match.</p>', 'StringList$member' => NULL, 'StringListConfigurationOptions$Re2Expression' => '<p> An RE2 regular expression that Security Hub uses to validate a user-provided list of strings for a control parameter. </p>', 'StringListConfigurationOptions$ExpressionDescription' => '<p> The description of the RE2 regular expression. </p>', 'Target$AccountId' => '<p> The Amazon Web Services account ID of the target account. </p>', 'Target$OrganizationalUnitId' => '<p> The organizational unit ID of the target organizational unit. </p>', 'Target$RootId' => '<p> The ID of the organization root. </p>', 'Threat$Name' => '<p>The name of the threat. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'Threat$Severity' => '<p>The severity of the threat. </p> <p>Length Constraints: Minimum of 1 length. Maximum of 128 length.</p>', 'ThreatIntelIndicator$Value' => '<p>The value of a threat intelligence indicator.</p> <p>Length Constraints: Minimum of 1 length. Maximum of 512 length.</p>', 'ThreatIntelIndicator$LastObservedAt' => '<p>Indicates when the most recent instance of a threat intelligence indicator was observed.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'ThreatIntelIndicator$Source' => '<p>The source of the threat intelligence indicator.</p> <p>Length Constraints: Minimum of 1 length. Maximum of 64 length.</p>', 'ThreatIntelIndicator$SourceUrl' => '<p>The URL to the page or site where you can get more information about the threat intelligence indicator.</p>', 'TypeList$member' => NULL, 'UnprocessedAutomationRule$RuleArn' => '<p> The Amazon Resource Name (ARN) for the unprocessed automation rule. </p>', 'UnprocessedAutomationRule$ErrorMessage' => '<p> An error message describing why a request didn\'t process a specific rule. </p>', 'UnprocessedConfigurationPolicyAssociation$ErrorCode' => '<p> An HTTP status code that identifies why the configuration policy association failed. </p>', 'UnprocessedConfigurationPolicyAssociation$ErrorReason' => '<p> A string that identifies why the configuration policy association failed. </p>', 'UnprocessedSecurityControl$SecurityControlId' => '<p> The control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) for which a response couldn\'t be returned. </p>', 'UnprocessedSecurityControl$ErrorReason' => '<p> The reason why the security control was unprocessed. </p>', 'UnprocessedStandardsControlAssociation$ErrorReason' => '<p>The reason why the standard and control association was unprocessed. </p>', 'UnprocessedStandardsControlAssociationUpdate$ErrorReason' => '<p>The reason why a control\'s enablement status in the specified standard couldn\'t be updated. </p>', 'UpdateActionTargetRequest$ActionTargetArn' => '<p>The ARN of the custom action target to update.</p>', 'UpdateActionTargetRequest$Name' => '<p>The updated name of the custom action target.</p>', 'UpdateActionTargetRequest$Description' => '<p>The updated description for the custom action target.</p>', 'UpdateAutomationRulesRequestItem$RuleArn' => '<p> The Amazon Resource Name (ARN) for the rule. </p>', 'UpdateAutomationRulesRequestItem$Description' => '<p> A description of the rule. </p>', 'UpdateAutomationRulesRequestItem$RuleName' => '<p> The name of the rule. </p>', 'UpdateConfigurationPolicyRequest$Identifier' => '<p> The Amazon Resource Name (ARN) or universally unique identifier (UUID) of the configuration policy. </p>', 'UpdateConfigurationPolicyRequest$Name' => '<p> The name of the configuration policy. Alphanumeric characters and the following ASCII characters are permitted: <code>-, ., !, *, /</code>. </p>', 'UpdateConfigurationPolicyRequest$Description' => '<p> The description of the configuration policy. </p>', 'UpdateConfigurationPolicyRequest$UpdatedReason' => '<p> The reason for updating the configuration policy. </p>', 'UpdateConfigurationPolicyResponse$Arn' => '<p> The ARN of the configuration policy. </p>', 'UpdateConfigurationPolicyResponse$Id' => '<p> The UUID of the configuration policy. </p>', 'UpdateConfigurationPolicyResponse$Name' => '<p> The name of the configuration policy. </p>', 'UpdateConfigurationPolicyResponse$Description' => '<p> The description of the configuration policy. </p>', 'UpdateFindingAggregatorRequest$FindingAggregatorArn' => '<p>The ARN of the finding aggregator. To obtain the ARN, use <code>ListFindingAggregators</code>.</p>', 'UpdateFindingAggregatorRequest$RegionLinkingMode' => '<p>Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.</p> <p>The selected option also determines how to use the Regions provided in the Regions list.</p> <p>The options are as follows:</p> <ul> <li> <p> <code>ALL_REGIONS</code> - Aggregates findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li> <li> <p> <code>ALL_REGIONS_EXCEPT_SPECIFIED</code> - Aggregates findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the <code>Regions</code> parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them. </p> </li> <li> <p> <code>SPECIFIED_REGIONS</code> - Aggregates findings only from the Regions listed in the <code>Regions</code> parameter. Security Hub does not automatically aggregate findings from new Regions. </p> </li> <li> <p> <code>NO_REGIONS</code> - Aggregates no data because no Regions are selected as linked Regions. </p> </li> </ul>', 'UpdateFindingAggregatorResponse$FindingAggregatorArn' => '<p>The ARN of the finding aggregator.</p>', 'UpdateFindingAggregatorResponse$FindingAggregationRegion' => '<p>The aggregation Region.</p>', 'UpdateFindingAggregatorResponse$RegionLinkingMode' => '<p>Indicates whether to link all Regions, all Regions except for a list of excluded Regions, or a list of included Regions.</p>', 'UpdateInsightRequest$InsightArn' => '<p>The ARN of the insight that you want to update.</p>', 'UpdateInsightRequest$Name' => '<p>The updated name for the insight.</p>', 'UpdateInsightRequest$GroupByAttribute' => '<p>The updated <code>GroupBy</code> attribute that defines this insight.</p>', 'UpdateSecurityControlRequest$SecurityControlId' => '<p> The Amazon Resource Name (ARN) or ID of the control to update. </p>', 'UpdateStandardsControlRequest$StandardsControlArn' => '<p>The ARN of the security standard control to enable or disable.</p>', 'UpdateStandardsControlRequest$DisabledReason' => '<p>A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required.</p>', 'VolumeMount$Name' => '<p>The name of the volume. </p>', 'VolumeMount$MountPath' => '<p>The path in the container at which the volume should be mounted. </p>', 'VpcInfoCidrBlockSetDetails$CidrBlock' => '<p>The IPv4 CIDR block for the VPC. </p>', 'VpcInfoIpv6CidrBlockSetDetails$Ipv6CidrBlock' => '<p>The IPv6 CIDR block for the VPC. </p>', 'Vulnerability$Id' => '<p>The identifier of the vulnerability.</p>', 'Vulnerability$LastKnownExploitAt' => '<p> The date and time of the last exploit associated with a finding discovered in your environment. </p>', 'VulnerabilityCodeVulnerabilities$SourceArn' => '<p> The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located. </p>', 'VulnerabilityVendor$Name' => '<p>The name of the vendor.</p>', 'VulnerabilityVendor$Url' => '<p>The URL of the vulnerability advisory.</p>', 'VulnerabilityVendor$VendorSeverity' => '<p>The severity that the vendor assigned to the vulnerability.</p>', 'VulnerabilityVendor$VendorCreatedAt' => '<p>Indicates when the vulnerability advisory was created.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'VulnerabilityVendor$VendorUpdatedAt' => '<p>Indicates when the vulnerability advisory was last updated.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'WafAction$Type' => '<p>Specifies how you want WAF to respond to requests that match the settings in a rule.</p> <p>Valid settings include the following:</p> <ul> <li> <p> <code>ALLOW</code> - WAF allows requests</p> </li> <li> <p> <code>BLOCK</code> - WAF blocks requests</p> </li> <li> <p> <code>COUNT</code> - WAF increments a counter of the requests that match all of the conditions in the rule. WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can\'t specify <code>COUNT</code> for the default action for a web ACL.</p> </li> </ul>', 'WafExcludedRule$RuleId' => '<p>The unique identifier for the rule to exclude from the rule group.</p>', 'WafOverrideAction$Type' => '<p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> .</p> <p>If set to <code>NONE</code>, the rule\'s action takes place.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'AwsApiGatewayEndpointConfiguration$Types' => '<p>A list of endpoint types for the REST API.</p> <p>For an edge-optimized API, the endpoint type is <code>EDGE</code>. For a Regional API, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>', 'AwsApiGatewayRestApiDetails$BinaryMediaTypes' => '<p>The list of binary media types supported by the REST API.</p>', 'AwsAutoScalingLaunchConfigurationDetails$ClassicLinkVpcSecurityGroups' => '<p>The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>.</p>', 'AwsAutoScalingLaunchConfigurationDetails$SecurityGroups' => '<p>The security groups to assign to the instances in the Auto Scaling group.</p>', 'AwsBackupBackupVaultNotificationsDetails$BackupVaultEvents' => '<p>An array of events that indicate the status of jobs to back up resources to the backup vault. The following events are supported:</p> <ul> <li> <p> <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code> </p> </li> <li> <p> <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code> </p> </li> <li> <p> <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code> </p> </li> <li> <p> <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code> </p> </li> </ul>', 'AwsCloudFormationStackDetails$Capabilities' => '<p>The capabilities allowed in the stack. </p>', 'AwsCloudFormationStackDetails$NotificationArns' => '<p>The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published. </p>', 'AwsCloudFrontDistributionOriginSslProtocols$Items' => '<p>A list that contains allowed SSL/TLS protocols for this distribution. </p>', 'AwsCloudWatchAlarmDetails$AlarmActions' => '<p>The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an <code>ALARM</code> state from any other state. </p>', 'AwsCloudWatchAlarmDetails$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an ARN. </p>', 'AwsCloudWatchAlarmDetails$OkActions' => '<p>The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each action is specified as an ARN. </p>', 'AwsCodeBuildProjectVpcConfig$Subnets' => '<p>A list of one or more subnet IDs in your VPC.</p>', 'AwsCodeBuildProjectVpcConfig$SecurityGroupIds' => '<p>A list of one or more security group IDs in your VPC.</p>', 'AwsCorsConfiguration$AllowOrigins' => '<p>The allowed origins for CORS requests.</p>', 'AwsCorsConfiguration$ExposeHeaders' => '<p>The exposed headers for CORS requests.</p>', 'AwsCorsConfiguration$AllowMethods' => '<p>The allowed methods for CORS requests.</p>', 'AwsCorsConfiguration$AllowHeaders' => '<p>The allowed headers for CORS requests.</p>', 'AwsEc2LaunchTemplateDataDetails$SecurityGroupIdSet' => '<p> One or more security group IDs. </p>', 'AwsEc2LaunchTemplateDataDetails$SecurityGroupSet' => '<p> One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$AcceleratorManufacturers' => '<p>Indicates whether instance types must have accelerators by specific manufacturers. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$AcceleratorNames' => '<p> The accelerators that must be on the instance type. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$AcceleratorTypes' => '<p>The accelerator types that must be on the instance type. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$CpuManufacturers' => '<p> The CPU manufacturers to include. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$ExcludedInstanceTypes' => '<p> The instance types to exclude. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$InstanceGenerations' => '<p> Indicates whether current or previous generation instance types are included. </p>', 'AwsEc2LaunchTemplateDataInstanceRequirementsDetails$LocalStorageTypes' => '<p> The type of local storage that is required. </p>', 'AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails$Groups' => '<p> The IDs of one or more security groups. </p>', 'AwsEc2TransitGatewayDetails$TransitGatewayCidrBlocks' => '<p>The transit gateway Classless Inter-Domain Routing (CIDR) blocks. </p>', 'AwsEc2VpcEndpointServiceDetails$AvailabilityZones' => '<p>The Availability Zones where the service is available.</p>', 'AwsEc2VpcEndpointServiceDetails$BaseEndpointDnsNames' => '<p>The DNS names for the service.</p>', 'AwsEc2VpcEndpointServiceDetails$GatewayLoadBalancerArns' => '<p>The ARNs of the Gateway Load Balancers for the service.</p>', 'AwsEc2VpcEndpointServiceDetails$NetworkLoadBalancerArns' => '<p>The ARNs of the Network Load Balancers for the service.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$IkeVersions' => '<p>The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase1EncryptionAlgorithms' => '<p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase1IntegrityAlgorithms' => '<p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase2EncryptionAlgorithms' => '<p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.</p>', 'AwsEc2VpnConnectionOptionsTunnelOptionsDetails$Phase2IntegrityAlgorithms' => '<p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.</p>', 'AwsEcrContainerImageDetails$ImageTags' => '<p>The list of tags that are associated with the image.</p>', 'AwsEcsClusterDetails$CapacityProviders' => '<p>The short name of one or more capacity providers to associate with the cluster.</p>', 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails$SecurityGroups' => '<p>The IDs of the security groups associated with the task or service.</p> <p>You can provide up to five security groups.</p>', 'AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails$Subnets' => '<p>The IDs of the subnets associated with the task or service.</p> <p>You can provide up to 16 subnets.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Command' => '<p>The command that is passed to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DnsSearchDomains' => '<p>A list of DNS search domains that are presented to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DnsServers' => '<p>A list of DNS servers that are presented to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$DockerSecurityOptions' => '<p>A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$EntryPoint' => '<p>The entry point that is passed to the container.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsDetails$Links' => '<p>A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>. Allows containers to communicate with each other without the need for port mappings.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails$Command' => '<p>The command that the container runs to determine whether it is healthy.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails$Add' => '<p>The Linux capabilities for the container that are added to the default configuration provided by Docker. Valid values are as follows:</p> <p>Valid values: <code>"ALL"</code> | <code>"AUDIT_CONTROL"</code> |<code> "AUDIT_WRITE"</code> | <code>"BLOCK_SUSPEND"</code> | <code>"CHOWN"</code> | <code>"DAC_OVERRIDE"</code> | <code>"DAC_READ_SEARCH"</code> | <code>"FOWNER"</code> | <code>"FSETID"</code> | <code>"IPC_LOCK"</code> | <code>"IPC_OWNER"</code> | <code>"KILL"</code> | <code>"LEASE"</code> | <code>"LINUX_IMMUTABLE"</code> | <code>"MAC_ADMIN"</code> |<code> "MAC_OVERRIDE"</code> | <code>"MKNOD"</code> | <code>"NET_ADMIN"</code> | <code>"NET_BIND_SERVICE"</code> | <code>"NET_BROADCAST"</code> | <code>"NET_RAW"</code> | <code>"SETFCAP"</code> | <code>"SETGID"</code> | <code>"SETPCAP"</code> | <code>"SETUID"</code> | <code>"SYS_ADMIN"</code> | <code>"SYS_BOOT"</code> | <code>"SYS_CHROOT"</code> | <code>"SYS_MODULE"</code> | <code>"SYS_NICE"</code> | <code>"SYS_PACCT"</code> | <code>"SYS_PTRACE"</code> | <code>"SYS_RAWIO"</code> | <code>"SYS_RESOURCE"</code> | <code>"SYS_TIME"</code> | <code>"SYS_TTY_CONFIG"</code> | <code>"SYSLOG"</code> | <code>"WAKE_ALARM"</code> </p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails$Drop' => '<p>The Linux capabilities for the container that are dropped from the default configuration provided by Docker.</p> <p>Valid values: <code>"ALL"</code> | <code>"AUDIT_CONTROL"</code> |<code> "AUDIT_WRITE"</code> | <code>"BLOCK_SUSPEND"</code> | <code>"CHOWN"</code> | <code>"DAC_OVERRIDE"</code> | <code>"DAC_READ_SEARCH"</code> | <code>"FOWNER"</code> | <code>"FSETID"</code> | <code>"IPC_LOCK"</code> | <code>"IPC_OWNER"</code> | <code>"KILL"</code> | <code>"LEASE"</code> | <code>"LINUX_IMMUTABLE"</code> | <code>"MAC_ADMIN"</code> |<code> "MAC_OVERRIDE"</code> | <code>"MKNOD"</code> | <code>"NET_ADMIN"</code> | <code>"NET_BIND_SERVICE"</code> | <code>"NET_BROADCAST"</code> | <code>"NET_RAW"</code> | <code>"SETFCAP"</code> | <code>"SETGID"</code> | <code>"SETPCAP"</code> | <code>"SETUID"</code> | <code>"SYS_ADMIN"</code> | <code>"SYS_BOOT"</code> | <code>"SYS_CHROOT"</code> | <code>"SYS_MODULE"</code> | <code>"SYS_NICE"</code> | <code>"SYS_PACCT"</code> | <code>"SYS_PTRACE"</code> | <code>"SYS_RAWIO"</code> | <code>"SYS_RESOURCE"</code> | <code>"SYS_TIME"</code> | <code>"SYS_TTY_CONFIG"</code> | <code>"SYSLOG"</code> | <code>"WAKE_ALARM"</code> </p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails$Permissions' => '<p>The explicit permissions to provide to the container for the device. By default, the container has permissions for read, write, and <code>mknod</code> for the device.</p>', 'AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails$MountOptions' => '<p>The list of tmpfs volume mount options.</p> <p>Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> | <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> | <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> | <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> | <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> | <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code> | <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> | <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> | <code>"strictatime"</code> | <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> | <code>"gid"</code> | <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code> </p>', 'AwsEcsTaskDefinitionDetails$RequiresCompatibilities' => '<p>The task launch types that the task definition was validated against.</p>', 'AwsEfsAccessPointPosixUserDetails$SecondaryGids' => '<p>Secondary POSIX group IDs used for all file system operations using this access point. </p>', 'AwsEksClusterLoggingClusterLoggingDetails$Types' => '<p>A list of logging types. Valid values are as follows:</p> <ul> <li> <p> <code>api</code> </p> </li> <li> <p> <code>audit</code> </p> </li> <li> <p> <code>authenticator</code> </p> </li> <li> <p> <code>controllerManager</code> </p> </li> <li> <p> <code>scheduler</code> </p> </li> </ul>', 'AwsEksClusterResourcesVpcConfigDetails$SecurityGroupIds' => '<p>The security groups that are associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Amazon EKS control plane.</p>', 'AwsEksClusterResourcesVpcConfigDetails$SubnetIds' => '<p>The subnets that are associated with the cluster.</p>', 'AwsElasticsearchDomainVPCOptions$AvailabilityZones' => '<p>The list of Availability Zones associated with the VPC subnets.</p>', 'AwsElasticsearchDomainVPCOptions$SecurityGroupIds' => '<p>The list of security group IDs associated with the VPC endpoints for the domain.</p>', 'AwsElasticsearchDomainVPCOptions$SubnetIds' => '<p>A list of subnet IDs associated with the VPC endpoints for the domain.</p>', 'AwsLambdaFunctionDetails$Architectures' => '<p>The instruction set architecture that the function uses. Valid values are <code>x86_64</code> or <code>arm64</code>.</p>', 'AwsLambdaFunctionVpcConfig$SecurityGroupIds' => '<p>A list of VPC security groups IDs.</p>', 'AwsLambdaFunctionVpcConfig$SubnetIds' => '<p>A list of VPC subnet IDs.</p>', 'AwsLambdaLayerVersionDetails$CompatibleRuntimes' => '<p>The layer\'s compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>.</p> <p>The following list includes deprecated runtimes. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime deprecation policy</a> in the <i>Lambda Developer Guide</i>.</p> <p>Array Members: Maximum number of 5 items.</p> <p>Valid Values: <code>nodejs | nodejs4.3 | nodejs6.10 | nodejs8.10 | nodejs10.x | nodejs12.x | nodejs14.x | nodejs16.x | java8 | java8.al2 | java11 | python2.7 | python3.6 | python3.7 | python3.8 | python3.9 | dotnetcore1.0 | dotnetcore2.0 | dotnetcore2.1 | dotnetcore3.1 | dotnet6 | nodejs4.3-edge | go1.x | ruby2.5 | ruby2.7 | provided | provided.al2 | nodejs18.x | python3.10 | java17 | ruby3.2 | python3.11 | nodejs20.x | provided.al2023 | python3.12 | java21</code> </p>', 'AwsOpenSearchServiceDomainVpcOptionsDetails$SecurityGroupIds' => '<p>The list of security group IDs that are associated with the VPC endpoints for the domain.</p>', 'AwsOpenSearchServiceDomainVpcOptionsDetails$SubnetIds' => '<p>A list of subnet IDs that are associated with the VPC endpoints for the domain.</p>', 'AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute$AttributeValues' => '<p> The value(s) for the manual DB cluster snapshot attribute. If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore. </p>', 'AwsRdsEventSubscriptionDetails$EventCategoriesList' => '<p>The list of event categories for the event notification subscription.</p>', 'AwsRdsEventSubscriptionDetails$SourceIdsList' => '<p>A list of source identifiers for the event notification subscription.</p>', 'AwsSageMakerNotebookInstanceDetails$AcceleratorTypes' => '<p> A list of Amazon Elastic Inference instance types to associate with the notebook instance. Currently, only one instance type can be associated with a notebook instance. </p>', 'AwsSageMakerNotebookInstanceDetails$AdditionalCodeRepositories' => '<p> An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git repositories with SageMaker notebook instances</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'AwsSageMakerNotebookInstanceDetails$SecurityGroups' => '<p> The VPC security group IDs. </p>', 'FirewallPolicyDetails$StatelessDefaultActions' => '<p>The actions to take on a packet if it doesn\'t match any of the stateless rules in the policy.</p> <p>You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, <code>aws:forward_to_sfe</code>), and can optionally include a custom action from <code>StatelessCustomActions</code>. </p>', 'FirewallPolicyDetails$StatelessFragmentDefaultActions' => '<p>The actions to take on a fragmented UDP packet if it doesn\'t match any of the stateless rules in the policy.</p> <p>You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, <code>aws:forward_to_sfe</code>), and can optionally include a custom action from <code>StatelessCustomActions</code>. </p>', 'RuleGroupSourceListDetails$TargetTypes' => '<p>The protocols that you want to inspect. Specify <code>LS_SNI</code> for HTTPS. Specify <code>HTTP_HOST</code> for HTTP. You can specify either or both.</p>', 'RuleGroupSourceListDetails$Targets' => '<p>The domains that you want to inspect for in your traffic flows. You can provide full domain names, or use the \'.\' prefix as a wildcard. For example, <code>.example.com</code> matches all domains that end with <code>example.com</code>.</p>', 'RuleGroupSourceStatelessRuleDefinition$Actions' => '<p>The actions to take on a packet that matches one of the stateless rule definition\'s match attributes. You must specify a standard action (<code>aws:pass</code>, <code>aws:drop</code>, or <code>aws:forward_to_sfe</code>). You can then add custom actions.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesTcpFlags$Flags' => '<p>Defines the flags from the <code>Masks</code> setting that must be set in order for the packet to match. Flags that are listed must be set. Flags that are not listed must not be set.</p>', 'RuleGroupSourceStatelessRuleMatchAttributesTcpFlags$Masks' => '<p>The set of flags to consider in the inspection. If not specified, then all flags are inspected.</p>', 'RuleGroupVariablesIpSetsDetails$Definition' => '<p>The list of IP addresses and ranges.</p>', 'RuleGroupVariablesPortSetsDetails$Definition' => '<p>The list of port ranges.</p>', ], ], 'Note' => [ 'base' => '<p>A user-defined note added to a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Note' => '<p>A user-defined note added to a finding.</p>', ], ], 'NoteUpdate' => [ 'base' => '<p>The updated note.</p>', 'refs' => [ 'AutomationRulesFindingFieldsUpdate$Note' => NULL, 'BatchUpdateFindingsRequest$Note' => NULL, 'UpdateFindingsRequest$Note' => '<p>The updated note for the finding.</p>', ], ], 'NumberFilter' => [ 'base' => '<p>A number filter for querying findings.</p>', 'refs' => [ 'NumberFilterList$member' => NULL, ], ], 'NumberFilterList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFilters$Confidence' => '<p>The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn\'t been verified. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence">Confidence</a> in the <i>Security Hub User Guide</i>.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$Criticality' => '<p> The level of importance that is assigned to the resources that are associated with a finding. <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of <code>0</code> means that the underlying resources have no criticality, and a score of <code>100</code> is reserved for the most critical resources. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality">Criticality</a> in the <i>Security Hub User Guide</i>.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AwsSecurityFindingFilters$SeverityProduct' => '<p>The native severity as defined by the security findings provider\'s solution that generated the finding.</p>', 'AwsSecurityFindingFilters$SeverityNormalized' => '<p>The normalized severity of a finding.</p>', 'AwsSecurityFindingFilters$Confidence' => '<p>A finding\'s confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'AwsSecurityFindingFilters$Criticality' => '<p>The level of importance assigned to the resources associated with the finding.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.</p>', 'AwsSecurityFindingFilters$NetworkSourcePort' => '<p>The source port of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationPort' => '<p>The destination port of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ProcessPid' => '<p>The process ID.</p>', 'AwsSecurityFindingFilters$ProcessParentPid' => '<p>The parent process ID. This field accepts positive integers between <code>O</code> and <code>2147483647</code>.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsConfidence' => '<p>The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsCriticality' => '<p>The finding provider value for the level of importance assigned to the resources associated with the findings.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>', ], ], 'Occurrences' => [ 'base' => '<p>The detected occurrences of sensitive data.</p>', 'refs' => [ 'CustomDataIdentifiersDetections$Occurrences' => '<p>Details about the sensitive data that was detected.</p>', 'SensitiveDataDetections$Occurrences' => '<p>Details about the sensitive data that was detected.</p>', ], ], 'OrganizationConfiguration' => [ 'base' => '<p> Provides information about the way an organization is configured in Security Hub. </p>', 'refs' => [ 'DescribeOrganizationConfigurationResponse$OrganizationConfiguration' => NULL, 'UpdateOrganizationConfigurationRequest$OrganizationConfiguration' => NULL, ], ], 'OrganizationConfigurationConfigurationType' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfiguration$ConfigurationType' => '<p> Indicates whether the organization uses local or central configuration. </p> <p>If you use local configuration, the Security Hub delegated administrator can set <code>AutoEnable</code> to <code>true</code> and <code>AutoEnableStandards</code> to <code>DEFAULT</code>. This automatically enables Security Hub and default security standards in new organization accounts. These new account settings must be set separately in each Amazon Web Services Region, and settings may be different in each Region. </p> <p> If you use central configuration, the delegated administrator can create configuration policies. Configuration policies can be used to configure Security Hub, security standards, and security controls in multiple accounts and Regions. If you want new organization accounts to use a specific configuration, you can create a configuration policy and associate it with the root or specific organizational units (OUs). New accounts will inherit the policy from the root or their assigned OU. </p>', ], ], 'OrganizationConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfiguration$Status' => '<p> Describes whether central configuration could be enabled as the <code>ConfigurationType</code> for the organization. If your <code>ConfigurationType</code> is local configuration, then the value of <code>Status</code> is always <code>ENABLED</code>. </p>', ], ], 'Page' => [ 'base' => '<p>An occurrence of sensitive data in an Adobe Portable Document Format (PDF) file.</p>', 'refs' => [ 'Pages$member' => NULL, ], ], 'Pages' => [ 'base' => NULL, 'refs' => [ 'Occurrences$Pages' => '<p>Occurrences of sensitive data in an Adobe Portable Document Format (PDF) file.</p>', ], ], 'ParameterConfiguration' => [ 'base' => '<p> An object that provides the current value of a security control parameter and identifies whether it has been customized. </p>', 'refs' => [ 'Parameters$value' => NULL, ], ], 'ParameterDefinition' => [ 'base' => '<p> An object that describes a security control parameter and the options for customizing it. </p>', 'refs' => [ 'ParameterDefinitions$value' => NULL, ], ], 'ParameterDefinitions' => [ 'base' => NULL, 'refs' => [ 'SecurityControlDefinition$ParameterDefinitions' => '<p> An object that provides a security control parameter name, description, and the options for customizing it. This object is excluded for a control that doesn\'t support custom parameters. </p>', ], ], 'ParameterValue' => [ 'base' => '<p> An object that includes the data type of a security control parameter and its current value. </p>', 'refs' => [ 'ParameterConfiguration$Value' => '<p> The current value of a control parameter. </p>', ], ], 'ParameterValueType' => [ 'base' => NULL, 'refs' => [ 'ParameterConfiguration$ValueType' => '<p> Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub behavior.</p> <p>When <code>ValueType</code> is set equal to <code>DEFAULT</code>, the default behavior can be a specific Security Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is set equal to <code>DEFAULT</code>, Security Hub ignores user-provided input for the <code>Value</code> field.</p> <p>When <code>ValueType</code> is set equal to <code>CUSTOM</code>, the <code>Value</code> field can\'t be empty.</p>', ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'SecurityControl$Parameters' => '<p> An object that identifies the name of a control parameter, its current value, and whether it has been customized. </p>', 'SecurityControlCustomParameter$Parameters' => '<p> An object that specifies parameter values for a control in a configuration policy. </p>', 'UpdateSecurityControlRequest$Parameters' => '<p> An object that specifies which security control parameters to update. </p>', ], ], 'Partition' => [ 'base' => NULL, 'refs' => [ 'Resource$Partition' => '<p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>', ], ], 'PatchSummary' => [ 'base' => '<p>Provides an overview of the patch compliance status for an instance against a selected compliance standard.</p>', 'refs' => [ 'AwsSecurityFinding$PatchSummary' => '<p>Provides an overview of the patch compliance status for an instance against a selected compliance standard.</p>', ], ], 'Policy' => [ 'base' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p>', 'refs' => [ 'CreateConfigurationPolicyRequest$ConfigurationPolicy' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p>', 'CreateConfigurationPolicyResponse$ConfigurationPolicy' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If the request included a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If the request included a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p>', 'GetConfigurationPolicyResponse$ConfigurationPolicy' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If the policy includes a list of security controls that are enabled, Security Hub disables all other controls (including newly released controls). If the policy includes a list of security controls that are disabled, Security Hub enables all other controls (including newly released controls). </p>', 'UpdateConfigurationPolicyRequest$ConfigurationPolicy' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p> <p>When updating a configuration policy, provide a complete list of standards that you want to enable and a complete list of controls that you want to enable or disable. The updated configuration replaces the current configuration.</p>', 'UpdateConfigurationPolicyResponse$ConfigurationPolicy' => '<p> An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If the request included a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If the request included a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p>', ], ], 'PortProbeAction' => [ 'base' => '<p>Provided if <code>ActionType</code> is <code>PORT_PROBE</code>. It provides details about the attempted port probe that was detected.</p>', 'refs' => [ 'Action$PortProbeAction' => '<p>Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe that was detected. </p>', ], ], 'PortProbeDetail' => [ 'base' => '<p>A port scan that was part of the port probe. For each scan, PortProbeDetails provides information about the local IP address and port that were scanned, and the remote IP address that the scan originated from.</p>', 'refs' => [ 'PortProbeDetailList$member' => NULL, ], ], 'PortProbeDetailList' => [ 'base' => NULL, 'refs' => [ 'PortProbeAction$PortProbeDetails' => '<p>Information about the ports affected by the port probe.</p>', ], ], 'PortRange' => [ 'base' => '<p>A range of ports.</p>', 'refs' => [ 'Network$OpenPortRange' => '<p>The range of open ports that is present on the network.</p>', 'PortRangeList$member' => NULL, ], ], 'PortRangeFromTo' => [ 'base' => '<p>A range of ports.</p>', 'refs' => [ 'AwsEc2NetworkAclEntry$PortRange' => '<p>For TCP or UDP protocols, the range of ports that the rule applies to.</p>', ], ], 'PortRangeList' => [ 'base' => NULL, 'refs' => [ 'NetworkPathComponentDetails$PortRanges' => '<p>A list of port ranges for the destination.</p>', ], ], 'ProcessDetails' => [ 'base' => '<p>The details of process-related information about a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Process' => '<p>The details of process-related information about a finding.</p>', ], ], 'Product' => [ 'base' => '<p>Contains details about a product.</p>', 'refs' => [ 'ProductsList$member' => NULL, ], ], 'ProductSubscriptionArnList' => [ 'base' => NULL, 'refs' => [ 'ListEnabledProductsForImportResponse$ProductSubscriptions' => '<p>The list of ARNs for the resources that represent your subscriptions to products. </p>', ], ], 'ProductsList' => [ 'base' => NULL, 'refs' => [ 'DescribeProductsResponse$Products' => '<p>A list of products, including details for each product.</p>', ], ], 'PropagatingVgwSetDetails' => [ 'base' => '<p> Describes a virtual private gateway propagating route. </p>', 'refs' => [ 'PropagatingVgwSetList$member' => NULL, ], ], 'PropagatingVgwSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2RouteTableDetails$PropagatingVgwSet' => '<p> Describes a virtual private gateway propagating route. </p>', ], ], 'Range' => [ 'base' => '<p>Identifies where the sensitive data begins and ends.</p>', 'refs' => [ 'Page$LineRange' => '<p>An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary text files include files such as HTML, XML, JSON, and TXT files.</p>', 'Page$OffsetRange' => '<p>An occurrence of sensitive data detected in a binary text file.</p>', 'Ranges$member' => NULL, ], ], 'Ranges' => [ 'base' => NULL, 'refs' => [ 'Occurrences$LineRanges' => '<p>Occurrences of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary text files include files such as HTML, XML, JSON, and TXT files.</p>', 'Occurrences$OffsetRanges' => '<p>Occurrences of sensitive data detected in a binary text file.</p>', ], ], 'RatioScale' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFieldsUpdate$Confidence' => '<p> The rule action updates the <code>Confidence</code> field of a finding. </p>', 'AutomationRulesFindingFieldsUpdate$Criticality' => '<p> The rule action updates the <code>Criticality</code> field of a finding. </p>', 'BatchUpdateFindingsRequest$Confidence' => '<p>The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'BatchUpdateFindingsRequest$Criticality' => '<p>The updated value for the level of importance assigned to the resources associated with the findings.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>', 'FindingProviderFields$Confidence' => '<p>A finding\'s confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'FindingProviderFields$Criticality' => '<p>The level of importance assigned to the resources associated with the finding.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.</p>', 'SeverityUpdate$Normalized' => '<p>The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code>.</p> <p>If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is set automatically as follows.</p> <ul> <li> <p>0 - <code>INFORMATIONAL</code> </p> </li> <li> <p>1–39 - <code>LOW</code> </p> </li> <li> <p>40–69 - <code>MEDIUM</code> </p> </li> <li> <p>70–89 - <code>HIGH</code> </p> </li> <li> <p>90–100 - <code>CRITICAL</code> </p> </li> </ul>', ], ], 'Recommendation' => [ 'base' => '<p>A recommendation on how to remediate the issue identified in a finding.</p>', 'refs' => [ 'Remediation$Recommendation' => '<p>A recommendation on the steps to take to remediate the issue identified by a finding.</p>', ], ], 'Record' => [ 'base' => '<p>An occurrence of sensitive data in an Apache Avro object container or an Apache Parquet file.</p>', 'refs' => [ 'Records$member' => NULL, ], ], 'RecordState' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$RecordState' => '<p>The record state of a finding.</p>', 'UpdateFindingsRequest$RecordState' => '<p>The updated record state for the finding.</p>', ], ], 'Records' => [ 'base' => NULL, 'refs' => [ 'Occurrences$Records' => '<p>Occurrences of sensitive data in an Apache Avro object container or an Apache Parquet file.</p>', ], ], 'RegionAvailabilityStatus' => [ 'base' => NULL, 'refs' => [ 'SecurityControlDefinition$CurrentRegionAvailability' => '<p> Specifies whether a security control is available in the current Amazon Web Services Region. </p>', ], ], 'RelatedFinding' => [ 'base' => '<p>Details about a related finding.</p>', 'refs' => [ 'RelatedFindingList$member' => NULL, ], ], 'RelatedFindingList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFieldsUpdate$RelatedFindings' => '<p> The rule action updates the <code>RelatedFindings</code> field of a finding. </p>', 'AwsSecurityFinding$RelatedFindings' => '<p>A list of related findings.</p> <p>Array Members: Minimum number of 1 item. Maximum number of 10 items.</p>', 'BatchUpdateFindingsRequest$RelatedFindings' => '<p>A list of findings that are related to the updated findings.</p>', 'FindingProviderFields$RelatedFindings' => '<p>A list of findings that are related to the current finding.</p>', ], ], 'RelatedRequirementsList' => [ 'base' => NULL, 'refs' => [ 'Compliance$RelatedRequirements' => '<p>For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.</p> <p>Array Members: Maximum number of 32 items.</p>', 'StandardsControl$RelatedRequirements' => '<p>The list of requirements that are related to this control.</p>', 'StandardsControlAssociationDetail$RelatedRequirements' => '<p> The requirement that underlies a control in the compliance framework related to the standard. </p>', 'StandardsControlAssociationSummary$RelatedRequirements' => '<p> The requirement that underlies this control in the compliance framework related to the standard. </p>', ], ], 'Remediation' => [ 'base' => '<p>Details about the remediation steps for a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Remediation' => '<p>A data type that describes the remediation options for a finding.</p>', ], ], 'Resource' => [ 'base' => '<p>A resource related to a finding.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource to retrieve tags for.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource to apply the tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource to remove the tags from.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>The resource specified in the request conflicts with an existing resource.</p>', 'refs' => [], ], 'ResourceDetails' => [ 'base' => '<p>Additional details about a resource related to a finding.</p> <p>To provide the details, use the object that corresponds to the resource type. For example, if the resource type is <code>AwsEc2Instance</code>, then you use the <code>AwsEc2Instance</code> object to provide the details.</p> <p>If the type-specific object does not contain all of the fields you want to populate, then you use the <code>Other</code> object to populate those additional fields.</p> <p>You also use the <code>Other</code> object to populate the details when the selected type does not have a corresponding object.</p>', 'refs' => [ 'Resource$Details' => '<p>Additional details about the resource related to a finding.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p> The request was rejected because it conflicts with the resource\'s availability. For example, you tried to update a security control that\'s currently in the <code>UPDATING</code> state. </p>', 'refs' => [], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Resources' => '<p>A set of resource data types that describe the resources that the finding refers to.</p> <p>Array Members: Minimum number of 1 item. Maximum number of 32 items.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request was rejected because we can\'t find the specified resource.</p>', 'refs' => [], ], 'Result' => [ 'base' => '<p>Details about the account that was not processed.</p>', 'refs' => [ 'ResultList$member' => NULL, ], ], 'ResultList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts that were not processed. For each account, the list includes the account ID and the email address.</p>', 'DeclineInvitationsResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts that were not processed. For each account, the list includes the account ID and the email address.</p>', 'DeleteInvitationsResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts for which the invitations were not deleted. For each account, the list includes the account ID and the email address.</p>', 'DeleteMembersResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts that were not deleted. For each account, the list includes the account ID and the email address.</p>', 'GetMembersResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>', 'InviteMembersResponse$UnprocessedAccounts' => '<p>The list of Amazon Web Services accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>', ], ], 'RouteSetDetails' => [ 'base' => '<p> Provides details about the routes in the route table. </p>', 'refs' => [ 'RouteSetList$member' => NULL, ], ], 'RouteSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2RouteTableDetails$RouteSet' => '<p> The routes in the route table. </p>', ], ], 'RuleGroupDetails' => [ 'base' => '<p>Details about the rule group.</p>', 'refs' => [ 'AwsNetworkFirewallRuleGroupDetails$RuleGroup' => '<p>Details about the rule group.</p>', ], ], 'RuleGroupSource' => [ 'base' => '<p>The rules and actions for the rule group.</p>', 'refs' => [ 'RuleGroupDetails$RulesSource' => '<p>The rules and actions for the rule group.</p> <p>For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or <code>StatefulRules</code>.</p> <p>For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.</p>', ], ], 'RuleGroupSourceCustomActionsDetails' => [ 'base' => '<p>A custom action definition. A custom action is an optional, non-standard action to use for stateless packet handling.</p>', 'refs' => [ 'RuleGroupSourceCustomActionsList$member' => NULL, ], ], 'RuleGroupSourceCustomActionsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRulesAndCustomActionsDetails$CustomActions' => '<p>Custom actions for the rule group.</p>', ], ], 'RuleGroupSourceListDetails' => [ 'base' => '<p>Stateful inspection criteria for a domain list rule group.</p>', 'refs' => [ 'RuleGroupSource$RulesSourceList' => '<p>Stateful inspection criteria for a domain list rule group. A domain list rule group determines access by specific protocols to specific domains.</p>', ], ], 'RuleGroupSourceStatefulRulesDetails' => [ 'base' => '<p>A Suricata rule specification.</p>', 'refs' => [ 'RuleGroupSourceStatefulRulesList$member' => NULL, ], ], 'RuleGroupSourceStatefulRulesHeaderDetails' => [ 'base' => '<p>The inspection criteria for a stateful rule.</p>', 'refs' => [ 'RuleGroupSourceStatefulRulesDetails$Header' => '<p>The stateful inspection criteria for the rule.</p>', ], ], 'RuleGroupSourceStatefulRulesList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSource$StatefulRules' => '<p>Suricata rule specifications.</p>', ], ], 'RuleGroupSourceStatefulRulesOptionsDetails' => [ 'base' => '<p>A rule option for a stateful rule.</p>', 'refs' => [ 'RuleGroupSourceStatefulRulesOptionsList$member' => NULL, ], ], 'RuleGroupSourceStatefulRulesOptionsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatefulRulesDetails$RuleOptions' => '<p>Additional options for the rule.</p>', ], ], 'RuleGroupSourceStatefulRulesRuleOptionsSettingsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatefulRulesOptionsDetails$Settings' => '<p>A list of settings.</p>', ], ], 'RuleGroupSourceStatelessRuleDefinition' => [ 'base' => '<p>The definition of the stateless rule.</p>', 'refs' => [ 'RuleGroupSourceStatelessRulesDetails$RuleDefinition' => '<p>Provides the definition of the stateless rule.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributes' => [ 'base' => '<p>Criteria for the stateless rule.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleDefinition$MatchAttributes' => '<p>The criteria for Network Firewall to use to inspect an individual packet in a stateless rule inspection.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts' => [ 'base' => '<p>A port range to specify the destination ports to inspect for.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsList$member' => NULL, ], ], 'RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$DestinationPorts' => '<p>A list of port ranges to specify the destination ports to inspect for.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesDestinations' => [ 'base' => '<p>A destination IP address or range.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributesDestinationsList$member' => NULL, ], ], 'RuleGroupSourceStatelessRuleMatchAttributesDestinationsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$Destinations' => '<p>The destination IP addresses and address ranges to inspect for, in CIDR notation.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesProtocolsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$Protocols' => '<p>The protocols to inspect for.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesSourcePorts' => [ 'base' => '<p>A port range to specify the source ports to inspect for.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributesSourcePortsList$member' => NULL, ], ], 'RuleGroupSourceStatelessRuleMatchAttributesSourcePortsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$SourcePorts' => '<p>A list of port ranges to specify the source ports to inspect for.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesSources' => [ 'base' => '<p>A source IP addresses and address range to inspect for.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributesSourcesList$member' => NULL, ], ], 'RuleGroupSourceStatelessRuleMatchAttributesSourcesList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$Sources' => '<p>The source IP addresses and address ranges to inspect for, in CIDR notation.</p>', ], ], 'RuleGroupSourceStatelessRuleMatchAttributesTcpFlags' => [ 'base' => '<p>A set of TCP flags and masks to inspect for.</p>', 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsList$member' => NULL, ], ], 'RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRuleMatchAttributes$TcpFlags' => '<p>The TCP flags and masks to inspect for.</p>', ], ], 'RuleGroupSourceStatelessRulesAndCustomActionsDetails' => [ 'base' => '<p>Stateless rules and custom actions for a stateless rule group.</p>', 'refs' => [ 'RuleGroupSource$StatelessRulesAndCustomActions' => '<p>The stateless rules and custom actions used by a stateless rule group.</p>', ], ], 'RuleGroupSourceStatelessRulesDetails' => [ 'base' => '<p>A stateless rule in the rule group.</p>', 'refs' => [ 'RuleGroupSourceStatelessRulesList$member' => NULL, ], ], 'RuleGroupSourceStatelessRulesList' => [ 'base' => NULL, 'refs' => [ 'RuleGroupSourceStatelessRulesAndCustomActionsDetails$StatelessRules' => '<p>Stateless rules for the rule group.</p>', ], ], 'RuleGroupVariables' => [ 'base' => '<p>Additional settings to use in the specified rules.</p>', 'refs' => [ 'RuleGroupDetails$RuleVariables' => '<p>Additional settings to use in the specified rules.</p>', ], ], 'RuleGroupVariablesIpSetsDetails' => [ 'base' => '<p>A list of IP addresses and address ranges, in CIDR notation.</p>', 'refs' => [ 'RuleGroupVariables$IpSets' => '<p>A list of IP addresses and address ranges, in CIDR notation.</p>', ], ], 'RuleGroupVariablesPortSetsDetails' => [ 'base' => '<p>A list of port ranges.</p>', 'refs' => [ 'RuleGroupVariables$PortSets' => '<p>A list of port ranges.</p>', ], ], 'RuleOrderValue' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesConfig$RuleOrder' => '<p> An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first. </p>', 'AutomationRulesMetadata$RuleOrder' => '<p>An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first. </p>', 'CreateAutomationRuleRequest$RuleOrder' => '<p>An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first. </p>', 'UpdateAutomationRulesRequestItem$RuleOrder' => '<p> An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first. </p>', ], ], 'RuleStatus' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesConfig$RuleStatus' => '<p> Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub starts applying the rule to findings and finding updates after the rule is created. </p>', 'AutomationRulesMetadata$RuleStatus' => '<p> Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub starts applying the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html"> <code>BatchUpdateAutomationRules</code> </a>. </p>', 'CreateAutomationRuleRequest$RuleStatus' => '<p> Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub starts applying the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html"> <code>BatchUpdateAutomationRules</code> </a>. </p>', 'UpdateAutomationRulesRequestItem$RuleStatus' => '<p> Whether the rule is active after it is created. If this parameter is equal to <code>ENABLED</code>, Security Hub starts applying the rule to findings and finding updates after the rule is created. To change the value of this parameter after creating a rule, use <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateAutomationRules.html"> <code>BatchUpdateAutomationRules</code> </a>. </p>', ], ], 'SecurityControl' => [ 'base' => '<p> A security control in Security Hub describes a security best practice related to a specific resource. </p>', 'refs' => [ 'SecurityControls$member' => NULL, ], ], 'SecurityControlCustomParameter' => [ 'base' => '<p> A list of security controls and control parameter values that are included in a configuration policy. </p>', 'refs' => [ 'SecurityControlCustomParametersList$member' => NULL, ], ], 'SecurityControlCustomParametersList' => [ 'base' => NULL, 'refs' => [ 'SecurityControlsConfiguration$SecurityControlCustomParameters' => '<p> A list of security controls and control parameter values that are included in a configuration policy. </p>', ], ], 'SecurityControlDefinition' => [ 'base' => '<p> Provides metadata for a security control, including its unique standard-agnostic identifier, title, description, severity, availability in Amazon Web Services Regions, and a link to remediation steps. </p>', 'refs' => [ 'GetSecurityControlDefinitionResponse$SecurityControlDefinition' => NULL, 'SecurityControlDefinitions$member' => NULL, ], ], 'SecurityControlDefinitions' => [ 'base' => NULL, 'refs' => [ 'ListSecurityControlDefinitionsResponse$SecurityControlDefinitions' => '<p> An array of controls that apply to the specified standard. </p>', ], ], 'SecurityControlParameter' => [ 'base' => '<p> A parameter that a security control accepts. </p>', 'refs' => [ 'SecurityControlParametersList$member' => NULL, ], ], 'SecurityControlParametersList' => [ 'base' => NULL, 'refs' => [ 'Compliance$SecurityControlParameters' => '<p> An object that includes security control parameter names and values. </p>', ], ], 'SecurityControlProperty' => [ 'base' => NULL, 'refs' => [ 'CustomizableProperties$member' => NULL, ], ], 'SecurityControls' => [ 'base' => NULL, 'refs' => [ 'BatchGetSecurityControlsResponse$SecurityControls' => '<p> An array that returns the identifier, Amazon Resource Name (ARN), and other details about a security control. The same information is returned whether the request includes <code>SecurityControlId</code> or <code>SecurityControlArn</code>. </p>', ], ], 'SecurityControlsConfiguration' => [ 'base' => '<p> An object that defines which security controls are enabled in an Security Hub configuration policy. The enablement status of a control is aligned across all of the enabled standards in an account. </p>', 'refs' => [ 'SecurityHubPolicy$SecurityControlsConfiguration' => '<p> An object that defines which security controls are enabled in the configuration policy. The enablement status of a control is aligned across all of the enabled standards in an account. </p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsElbv2LoadBalancerDetails$SecurityGroups' => '<p>The IDs of the security groups for the load balancer.</p>', ], ], 'SecurityHubPolicy' => [ 'base' => '<p> An object that defines how Security Hub is configured. The configuration policy includes whether Security Hub is enabled or disabled, a list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter values for specified controls. If you provide a list of security controls that are enabled in the configuration policy, Security Hub disables all other controls (including newly released controls). If you provide a list of security controls that are disabled in the configuration policy, Security Hub enables all other controls (including newly released controls). </p>', 'refs' => [ 'Policy$SecurityHub' => '<p> The Amazon Web Servicesservice that the configuration policy applies to. </p>', ], ], 'SensitiveDataDetections' => [ 'base' => '<p>The list of detected instances of sensitive data.</p>', 'refs' => [ 'SensitiveDataDetectionsList$member' => NULL, ], ], 'SensitiveDataDetectionsList' => [ 'base' => NULL, 'refs' => [ 'SensitiveDataResult$Detections' => '<p>The list of detected instances of sensitive data.</p>', ], ], 'SensitiveDataResult' => [ 'base' => '<p>Contains a detected instance of sensitive data that are based on built-in identifiers.</p>', 'refs' => [ 'SensitiveDataResultList$member' => NULL, ], ], 'SensitiveDataResultList' => [ 'base' => NULL, 'refs' => [ 'ClassificationResult$SensitiveData' => '<p>Provides details about sensitive data that was identified based on built-in configuration.</p>', ], ], 'Severity' => [ 'base' => '<p>The severity of the finding.</p> <p>The finding provider can provide the initial severity. The finding provider can only update the severity if it hasn\'t been updated using <code>BatchUpdateFindings</code>.</p> <p>The finding must have either <code>Label</code> or <code>Normalized</code> populated. If only one of these attributes is populated, then Security Hub automatically populates the other one. If neither attribute is populated, then the finding is invalid. <code>Label</code> is the preferred attribute.</p>', 'refs' => [ 'AwsSecurityFinding$Severity' => '<p>A finding\'s severity.</p>', ], ], 'SeverityLabel' => [ 'base' => NULL, 'refs' => [ 'FindingProviderSeverity$Label' => '<p>The severity label assigned to the finding by the finding provider.</p>', 'Severity$Label' => '<p>The severity value of the finding. The allowed values are the following.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - No issue was found.</p> </li> <li> <p> <code>LOW</code> - The issue does not require action on its own.</p> </li> <li> <p> <code>MEDIUM</code> - The issue must be addressed but not urgently.</p> </li> <li> <p> <code>HIGH</code> - The issue must be addressed as a priority.</p> </li> <li> <p> <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</p> </li> </ul> <p>If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set automatically as follows. </p> <ul> <li> <p>0 - <code>INFORMATIONAL</code> </p> </li> <li> <p>1–39 - <code>LOW</code> </p> </li> <li> <p>40–69 - <code>MEDIUM</code> </p> </li> <li> <p>70–89 - <code>HIGH</code> </p> </li> <li> <p>90–100 - <code>CRITICAL</code> </p> </li> </ul>', 'SeverityUpdate$Label' => '<p>The severity value of the finding. The allowed values are the following.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - No issue was found.</p> </li> <li> <p> <code>LOW</code> - The issue does not require action on its own.</p> </li> <li> <p> <code>MEDIUM</code> - The issue must be addressed but not urgently.</p> </li> <li> <p> <code>HIGH</code> - The issue must be addressed as a priority.</p> </li> <li> <p> <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</p> </li> </ul>', ], ], 'SeverityRating' => [ 'base' => NULL, 'refs' => [ 'SecurityControl$SeverityRating' => '<p> The severity of a security control. For more information about how Security Hub determines control severity, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity">Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>. </p>', 'SecurityControlDefinition$SeverityRating' => '<p> The severity of a security control. For more information about how Security Hub determines control severity, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity">Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>. </p>', 'StandardsControl$SeverityRating' => '<p>The severity of findings generated from this security standard control.</p> <p>The finding severity is based on an assessment of how easy it would be to compromise Amazon Web Services resources if the issue is detected.</p>', ], ], 'SeverityUpdate' => [ 'base' => '<p>Updates to the severity information for a finding.</p>', 'refs' => [ 'AutomationRulesFindingFieldsUpdate$Severity' => NULL, 'BatchUpdateFindingsRequest$Severity' => '<p>Used to update the finding severity.</p>', ], ], 'SizeBytes' => [ 'base' => NULL, 'refs' => [ 'AwsDynamoDbTableDetails$TableSizeBytes' => '<p>The total size of the table in bytes.</p>', 'AwsDynamoDbTableGlobalSecondaryIndex$IndexSizeBytes' => '<p>The total size in bytes of the index.</p>', ], ], 'SoftwarePackage' => [ 'base' => '<p>Information about a software package.</p>', 'refs' => [ 'SoftwarePackageList$member' => NULL, ], ], 'SoftwarePackageList' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$VulnerablePackages' => '<p>List of software packages that have the vulnerability.</p>', ], ], 'SortCriteria' => [ 'base' => NULL, 'refs' => [ 'GetFindingsRequest$SortCriteria' => '<p>The finding attributes used to sort the list of returned findings.</p>', ], ], 'SortCriterion' => [ 'base' => '<p>A collection of finding attributes used to sort findings.</p>', 'refs' => [ 'SortCriteria$member' => NULL, ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'SortCriterion$SortOrder' => '<p>The order used to sort findings.</p>', ], ], 'Standard' => [ 'base' => '<p>Provides information about a specific security standard.</p>', 'refs' => [ 'Standards$member' => NULL, ], ], 'Standards' => [ 'base' => NULL, 'refs' => [ 'DescribeStandardsResponse$Standards' => '<p>A list of available standards.</p>', ], ], 'StandardsControl' => [ 'base' => '<p>Details for an individual security standard control.</p>', 'refs' => [ 'StandardsControls$member' => NULL, ], ], 'StandardsControlArnList' => [ 'base' => NULL, 'refs' => [ 'StandardsControlAssociationDetail$StandardsControlArns' => '<p> Provides the input parameter that Security Hub uses to call the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html">UpdateStandardsControl</a> API. This API can be used to enable or disable a control in a specified standard. </p>', ], ], 'StandardsControlAssociationDetail' => [ 'base' => '<p> Provides details about a control\'s enablement status in a specified standard. </p>', 'refs' => [ 'StandardsControlAssociationDetails$member' => NULL, ], ], 'StandardsControlAssociationDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetStandardsControlAssociationsResponse$StandardsControlAssociationDetails' => '<p>Provides the enablement status of a security control in a specified standard and other details for the control in relation to the specified standard. </p>', ], ], 'StandardsControlAssociationId' => [ 'base' => '<p> An array with one or more objects that includes a security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon Resource Name (ARN) of a standard. The security control ID or ARN is the same across standards. </p>', 'refs' => [ 'StandardsControlAssociationIds$member' => NULL, 'UnprocessedStandardsControlAssociation$StandardsControlAssociationId' => '<p> An array with one or more objects that includes a security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon Resource Name (ARN) of a standard. This parameter shows the specific controls for which the enablement status couldn\'t be retrieved in specified standards when calling <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html">BatchUpdateStandardsControlAssociations</a>. </p>', ], ], 'StandardsControlAssociationIds' => [ 'base' => NULL, 'refs' => [ 'BatchGetStandardsControlAssociationsRequest$StandardsControlAssociationIds' => '<p> An array with one or more objects that includes a security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon Resource Name (ARN) of a standard. This field is used to query the enablement status of a control in a specified standard. The security control ID or ARN is the same across standards. </p>', ], ], 'StandardsControlAssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStandardsControlAssociationsResponse$StandardsControlAssociationSummaries' => '<p> An array that provides the enablement status and other details for each security control that applies to each enabled standard. </p>', ], ], 'StandardsControlAssociationSummary' => [ 'base' => '<p> An array that provides the enablement status and other details for each control that applies to each enabled standard. </p>', 'refs' => [ 'StandardsControlAssociationSummaries$member' => NULL, ], ], 'StandardsControlAssociationUpdate' => [ 'base' => '<p>An array of requested updates to the enablement status of controls in specified standards. The objects in the array include a security control ID, the Amazon Resource Name (ARN) of the standard, the requested enablement status, and the reason for updating the enablement status.</p>', 'refs' => [ 'StandardsControlAssociationUpdates$member' => NULL, 'UnprocessedStandardsControlAssociationUpdate$StandardsControlAssociationUpdate' => '<p>An array of control and standard associations for which an update failed when calling <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html">BatchUpdateStandardsControlAssociations</a>. </p>', ], ], 'StandardsControlAssociationUpdates' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateStandardsControlAssociationsRequest$StandardsControlAssociationUpdates' => '<p> Updates the enablement status of a security control in a specified standard. </p>', ], ], 'StandardsControls' => [ 'base' => NULL, 'refs' => [ 'DescribeStandardsControlsResponse$Controls' => '<p>A list of security standards controls.</p>', ], ], 'StandardsInputParameterMap' => [ 'base' => NULL, 'refs' => [ 'StandardsSubscription$StandardsInput' => '<p>A key-value pair of input for the standard.</p>', 'StandardsSubscriptionRequest$StandardsInput' => '<p>A key-value pair of input for the standard.</p>', ], ], 'StandardsManagedBy' => [ 'base' => '<p>Provides details about the management of a security standard.</p>', 'refs' => [ 'Standard$StandardsManagedBy' => '<p>Provides details about the management of a standard. </p>', ], ], 'StandardsStatus' => [ 'base' => NULL, 'refs' => [ 'StandardsSubscription$StandardsStatus' => '<p>The status of the standard subscription.</p> <p>The status values are as follows:</p> <ul> <li> <p> <code>PENDING</code> - Standard is in the process of being enabled.</p> </li> <li> <p> <code>READY</code> - Standard is enabled.</p> </li> <li> <p> <code>INCOMPLETE</code> - Standard could not be enabled completely. Some controls may not be available.</p> </li> <li> <p> <code>DELETING</code> - Standard is in the process of being disabled.</p> </li> <li> <p> <code>FAILED</code> - Standard could not be disabled.</p> </li> </ul>', ], ], 'StandardsStatusReason' => [ 'base' => '<p>The reason for the current status of a standard subscription.</p>', 'refs' => [ 'StandardsSubscription$StandardsStatusReason' => '<p>The reason for the current status.</p>', ], ], 'StandardsSubscription' => [ 'base' => '<p>A resource that represents your subscription to a supported standard.</p>', 'refs' => [ 'StandardsSubscriptions$member' => NULL, ], ], 'StandardsSubscriptionArns' => [ 'base' => NULL, 'refs' => [ 'BatchDisableStandardsRequest$StandardsSubscriptionArns' => '<p>The ARNs of the standards subscriptions to disable.</p>', 'GetEnabledStandardsRequest$StandardsSubscriptionArns' => '<p>The list of the standards subscription ARNs for the standards to retrieve.</p>', ], ], 'StandardsSubscriptionRequest' => [ 'base' => '<p>The standard that you want to enable.</p>', 'refs' => [ 'StandardsSubscriptionRequests$member' => NULL, ], ], 'StandardsSubscriptionRequests' => [ 'base' => NULL, 'refs' => [ 'BatchEnableStandardsRequest$StandardsSubscriptionRequests' => '<p>The list of standards checks to enable.</p>', ], ], 'StandardsSubscriptions' => [ 'base' => NULL, 'refs' => [ 'BatchDisableStandardsResponse$StandardsSubscriptions' => '<p>The details of the standards subscriptions that were disabled.</p>', 'BatchEnableStandardsResponse$StandardsSubscriptions' => '<p>The details of the standards subscriptions that were enabled.</p>', 'GetEnabledStandardsResponse$StandardsSubscriptions' => '<p>The list of <code>StandardsSubscriptions</code> objects that include information about the enabled standards.</p>', ], ], 'StartConfigurationPolicyAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartConfigurationPolicyAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartConfigurationPolicyDisassociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartConfigurationPolicyDisassociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatelessCustomActionDefinition' => [ 'base' => '<p>The definition of a custom action that can be used for stateless packet handling.</p>', 'refs' => [ 'FirewallPolicyStatelessCustomActionsDetails$ActionDefinition' => '<p>The definition of the custom action.</p>', 'RuleGroupSourceCustomActionsDetails$ActionDefinition' => '<p>The definition of a custom action.</p>', ], ], 'StatelessCustomPublishMetricAction' => [ 'base' => '<p>Information about metrics to publish to CloudWatch.</p>', 'refs' => [ 'StatelessCustomActionDefinition$PublishMetricAction' => '<p>Information about metrics to publish to CloudWatch.</p>', ], ], 'StatelessCustomPublishMetricActionDimension' => [ 'base' => '<p>Defines a CloudWatch dimension value to publish.</p>', 'refs' => [ 'StatelessCustomPublishMetricActionDimensionsList$member' => NULL, ], ], 'StatelessCustomPublishMetricActionDimensionsList' => [ 'base' => NULL, 'refs' => [ 'StatelessCustomPublishMetricAction$Dimensions' => '<p>Defines CloudWatch dimension values to publish.</p>', ], ], 'StatusReason' => [ 'base' => '<p>Provides additional context for the value of <code>Compliance.Status</code>.</p>', 'refs' => [ 'StatusReasonsList$member' => NULL, ], ], 'StatusReasonCode' => [ 'base' => NULL, 'refs' => [ 'StandardsStatusReason$StatusReasonCode' => '<p>The reason code that represents the reason for the current status of a standard subscription.</p>', ], ], 'StatusReasonsList' => [ 'base' => NULL, 'refs' => [ 'Compliance$StatusReasons' => '<p>For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the <i>Security Hub User Guide</i>. </p>', ], ], 'StringConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is a string. </p>', 'refs' => [ 'ConfigurationOptions$String' => '<p> The options for customizing a security control parameter that is a string data type. </p>', ], ], 'StringFilter' => [ 'base' => '<p>A string filter for filtering Security Hub findings.</p>', 'refs' => [ 'StringFilterList$member' => NULL, ], ], 'StringFilterComparison' => [ 'base' => NULL, 'refs' => [ 'StringFilter$Comparison' => '<p>The condition to apply to a string value when filtering Security Hub findings.</p> <p>To search for values that have the filter value, use one of the following comparison operators:</p> <ul> <li> <p>To search for values that include the filter value, use <code>CONTAINS</code>. For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</p> </li> <li> <p>To search for values that exactly match the filter value, use <code>EQUALS</code>. For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code>.</p> </li> <li> <p>To search for values that start with the filter value, use <code>PREFIX</code>. For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code>. A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code>, <code>ap</code>, or <code>ca</code>, doesn\'t match.</p> </li> </ul> <p> <code>CONTAINS</code>, <code>EQUALS</code>, and <code>PREFIX</code> filters on the same field are joined by <code>OR</code>. A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code>, <code>CloudWatch</code>, or both strings in the title.</p> <p>To search for values that don’t have the filter value, use one of the following comparison operators:</p> <ul> <li> <p>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code>. For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</p> </li> <li> <p>To search for values other than the filter value, use <code>NOT_EQUALS</code>. For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code>.</p> </li> <li> <p>To search for values that don\'t start with the filter value, use <code>PREFIX_NOT_EQUALS</code>. For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code>.</p> </li> </ul> <p> <code>NOT_CONTAINS</code>, <code>NOT_EQUALS</code>, and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code>. A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.</p> <p>You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can\'t provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters. </p> <p>You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.</p> <p>For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code>. It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code>.</p> <ul> <li> <p> <code>ResourceType PREFIX AwsIam</code> </p> </li> <li> <p> <code>ResourceType PREFIX AwsEc2</code> </p> </li> <li> <p> <code>ResourceType NOT_EQUALS AwsIamPolicy</code> </p> </li> <li> <p> <code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code> </p> </li> </ul> <p> <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <i>Security Hub User Guide</i>.</p>', ], ], 'StringFilterList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFilters$ProductArn' => '<p> The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$AwsAccountId' => '<p>The Amazon Web Services account ID in which a finding was generated.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 100 items. </p>', 'AutomationRulesFindingFilters$Id' => '<p> The product-specific identifier for a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$GeneratorId' => '<p> The identifier for the solution-specific component that generated a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 100 items. </p>', 'AutomationRulesFindingFilters$Type' => '<p> One or more finding types in the format of namespace/category/classifier that classify a finding. For a list of namespaces, classifiers, and categories, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html">Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$Title' => '<p> A finding\'s title. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 100 items. </p>', 'AutomationRulesFindingFilters$Description' => '<p> A finding\'s description. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$SourceUrl' => '<p> Provides a URL that links to a page about the current finding in the finding product. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ProductName' => '<p> Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$CompanyName' => '<p> The name of the company for the product that generated the finding. For control-based findings, the company is Amazon Web Services. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$SeverityLabel' => '<p> The severity value of the finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceType' => '<p> The type of resource that the finding pertains to. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceId' => '<p> The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the identifier as defined by the Amazon Web Servicesservice that created the resource. For non-Amazon Web Services resources, this is a unique identifier that is associated with the resource. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 100 items. </p>', 'AutomationRulesFindingFilters$ResourcePartition' => '<p> The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceRegion' => '<p> The Amazon Web Services Region where the resource that a finding pertains to is located. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ComplianceStatus' => '<p> The result of a security check. This field is only used for findings generated from controls. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ComplianceSecurityControlId' => '<p> The security control ID for which a finding was generated. Security control IDs are the same across standards.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ComplianceAssociatedStandardsId' => '<p>The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.</p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$VerificationState' => '<p> Provides the veracity of a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$WorkflowStatus' => '<p> Provides information about the status of the investigation into a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$RecordState' => '<p> Provides the current state of a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$RelatedFindingsProductArn' => '<p> The ARN for the product that generated a related finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$RelatedFindingsId' => '<p> The product-generated identifier for a related finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$NoteText' => '<p> The text of a user-defined note that\'s added to a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$NoteUpdatedBy' => '<p> The principal that created a note. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceApplicationArn' => '<p> The Amazon Resource Name (ARN) of the application that is related to a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$ResourceApplicationName' => '<p> The name of the application that is related to a finding. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AutomationRulesFindingFilters$AwsAccountName' => '<p>The name of the Amazon Web Services account in which a finding was generated. </p> <p> Array Members: Minimum number of 1 item. Maximum number of 20 items. </p>', 'AwsSecurityFindingFilters$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider\'s product (solution that generates findings) is registered with Security Hub.</p>', 'AwsSecurityFindingFilters$AwsAccountId' => '<p>The Amazon Web Services account ID in which a finding is generated.</p>', 'AwsSecurityFindingFilters$Id' => '<p>The security findings provider-specific identifier for a finding.</p>', 'AwsSecurityFindingFilters$GeneratorId' => '<p>The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security findings providers\' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.</p>', 'AwsSecurityFindingFilters$Region' => '<p>The Region from which the finding was generated.</p>', 'AwsSecurityFindingFilters$Type' => '<p>A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.</p>', 'AwsSecurityFindingFilters$SeverityLabel' => '<p>The label of a finding\'s severity.</p>', 'AwsSecurityFindingFilters$Title' => '<p>A finding\'s title.</p>', 'AwsSecurityFindingFilters$Description' => '<p>A finding\'s description.</p>', 'AwsSecurityFindingFilters$RecommendationText' => '<p>The recommendation of what to do about the issue described in a finding.</p>', 'AwsSecurityFindingFilters$SourceUrl' => '<p>A URL that links to a page about the current finding in the security findings provider\'s solution.</p>', 'AwsSecurityFindingFilters$ProductName' => '<p>The name of the solution (product) that generates findings.</p>', 'AwsSecurityFindingFilters$CompanyName' => '<p>The name of the findings provider (company) that owns the solution (product) that generates findings.</p>', 'AwsSecurityFindingFilters$MalwareName' => '<p>The name of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwareType' => '<p>The type of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwarePath' => '<p>The filesystem path of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwareState' => '<p>The state of the malware that was observed.</p>', 'AwsSecurityFindingFilters$NetworkDirection' => '<p>Indicates the direction of network traffic associated with a finding.</p>', 'AwsSecurityFindingFilters$NetworkProtocol' => '<p>The protocol of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceDomain' => '<p>The source domain of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceMac' => '<p>The source media access control (MAC) address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationDomain' => '<p>The destination domain of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ProcessName' => '<p>The name of the process.</p>', 'AwsSecurityFindingFilters$ProcessPath' => '<p>The path to the process executable.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorType' => '<p>The type of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorValue' => '<p>The value of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorCategory' => '<p>The category of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorSource' => '<p>The source of the threat intelligence.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorSourceUrl' => '<p>The URL for more details from the source of the threat intelligence.</p>', 'AwsSecurityFindingFilters$ResourceType' => '<p>Specifies the type of the resource that details are provided for.</p>', 'AwsSecurityFindingFilters$ResourceId' => '<p>The canonical identifier for the given resource type.</p>', 'AwsSecurityFindingFilters$ResourcePartition' => '<p>The canonical Amazon Web Services partition name that the Region is assigned to.</p>', 'AwsSecurityFindingFilters$ResourceRegion' => '<p>The canonical Amazon Web Services external Region name where this resource is located.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceType' => '<p>The instance type of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceImageId' => '<p>The Amazon Machine Image (AMI) ID of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceKeyName' => '<p>The key name associated with the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIamInstanceProfileArn' => '<p>The IAM profile ARN of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceVpcId' => '<p>The identifier of the VPC that the instance was launched in.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceSubnetId' => '<p>The identifier of the subnet that the instance was launched in.</p>', 'AwsSecurityFindingFilters$ResourceAwsS3BucketOwnerId' => '<p>The canonical user ID of the owner of the S3 bucket.</p>', 'AwsSecurityFindingFilters$ResourceAwsS3BucketOwnerName' => '<p>The display name of the owner of the S3 bucket.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyUserName' => '<p>The user associated with the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyPrincipalName' => '<p>The name of the principal that is associated with an IAM access key.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyStatus' => '<p>The status of the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamUserUserName' => '<p>The name of an IAM user.</p>', 'AwsSecurityFindingFilters$ResourceContainerName' => '<p>The name of the container related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerImageId' => '<p>The identifier of the image related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerImageName' => '<p>The name of the image related to a finding.</p>', 'AwsSecurityFindingFilters$ComplianceStatus' => '<p>Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.</p>', 'AwsSecurityFindingFilters$VerificationState' => '<p>The veracity of a finding.</p>', 'AwsSecurityFindingFilters$WorkflowState' => '<p>The workflow state of a finding.</p> <p>Note that this field is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>', 'AwsSecurityFindingFilters$WorkflowStatus' => '<p>The status of the investigation into a finding. Allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p> <ul> <li> <p> <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p> <code>Compliance.Status</code> changes from <code>PASSED</code> to either <code>WARNING</code>, <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li> <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> <p>If one of the following occurs, the workflow status is changed automatically from <code>NOTIFIED</code> to <code>NEW</code>:</p> <ul> <li> <p> <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p> <code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code>, <code>WARNING</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li> <p> <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed.</p> <p>The workflow status of a <code>SUPPRESSED</code> finding does not change if <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved. </p> <p>The finding remains <code>RESOLVED</code> unless one of the following occurs:</p> <ul> <li> <p> <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p> <code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code>, <code>WARNING</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> <p>In those cases, the workflow status is automatically reset to <code>NEW</code>.</p> <p>For findings from controls, if <code>Compliance.Status</code> is <code>PASSED</code>, then Security Hub automatically sets the workflow status to <code>RESOLVED</code>.</p> </li> </ul>', 'AwsSecurityFindingFilters$RecordState' => '<p>The updated record state for the finding.</p>', 'AwsSecurityFindingFilters$RelatedFindingsProductArn' => '<p>The ARN of the solution that generated a related finding.</p>', 'AwsSecurityFindingFilters$RelatedFindingsId' => '<p>The solution-generated identifier for a related finding.</p>', 'AwsSecurityFindingFilters$NoteText' => '<p>The text of a note.</p>', 'AwsSecurityFindingFilters$NoteUpdatedBy' => '<p>The principal that created a note.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsRelatedFindingsId' => '<p>The finding identifier of a related finding that is identified by the finding provider.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsRelatedFindingsProductArn' => '<p>The ARN of the solution that generated a related finding that is identified by the finding provider.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsSeverityLabel' => '<p>The finding provider value for the severity label.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsSeverityOriginal' => '<p>The finding provider\'s original value for the severity.</p>', 'AwsSecurityFindingFilters$FindingProviderFieldsTypes' => '<p>One or more finding types that the finding provider assigned to the finding. Uses the format of <code>namespace/category/classifier</code> that classify a finding.</p> <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>', 'AwsSecurityFindingFilters$ComplianceSecurityControlId' => '<p> The unique identifier of a control across standards. Values for this field typically consist of an Amazon Web Servicesservice and a number, such as APIGateway.5. </p>', 'AwsSecurityFindingFilters$ComplianceAssociatedStandardsId' => '<p> The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response. </p>', 'AwsSecurityFindingFilters$VulnerabilitiesExploitAvailable' => '<p> Indicates whether a software vulnerability in your environment has a known exploit. You can filter findings by this field only if you use Security Hub and Amazon Inspector. </p>', 'AwsSecurityFindingFilters$VulnerabilitiesFixAvailable' => '<p> Indicates whether a vulnerability is fixed in a newer version of the affected software packages. You can filter findings by this field only if you use Security Hub and Amazon Inspector. </p>', 'AwsSecurityFindingFilters$ComplianceSecurityControlParametersName' => '<p> The name of a security control parameter. </p>', 'AwsSecurityFindingFilters$ComplianceSecurityControlParametersValue' => '<p> The current value of a security control parameter. </p>', 'AwsSecurityFindingFilters$AwsAccountName' => '<p>The name of the Amazon Web Services account in which a finding is generated.</p>', 'AwsSecurityFindingFilters$ResourceApplicationName' => '<p> The name of the application that is related to a finding. </p>', 'AwsSecurityFindingFilters$ResourceApplicationArn' => '<p> The ARN of the application that is related to a finding. </p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AwsAmazonMqBrokerDetails$SecurityGroups' => '<p> The list of rules (one minimum, 125 maximum) that authorize connections to brokers. </p>', 'AwsAmazonMqBrokerDetails$SubnetIds' => '<p> The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. </p>', 'AwsAmazonMqBrokerLdapServerMetadataDetails$Hosts' => '<p> Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active Directory. </p>', 'AwsAutoScalingAutoScalingGroupDetails$LoadBalancerNames' => '<p>The list of load balancers associated with the group.</p>', 'AwsCertificateManagerCertificateDetails$InUseBy' => '<p>The list of ARNs for the Amazon Web Services resources that use the certificate.</p>', 'AwsCertificateManagerCertificateDetails$SubjectAlternativeNames' => '<p>One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate.</p> <p>The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.</p>', 'AwsCertificateManagerCertificateDomainValidationOption$ValidationEmails' => '<p>A list of email addresses that Certificate Manager uses to send domain validation emails.</p>', 'AwsDynamoDbTableProjection$NonKeyAttributes' => '<p>The nonkey attributes that are projected into the index. For each attribute, provide the attribute name.</p>', 'AwsEc2ClientVpnEndpointDetails$DnsServer' => '<p> Information about the DNS servers to be used for DNS resolution. </p>', 'AwsEc2ClientVpnEndpointDetails$SecurityGroupIdSet' => '<p> The IDs of the security groups for the target network. </p>', 'AwsEc2InstanceDetails$IpV4Addresses' => '<p>The IPv4 addresses associated with the instance.</p>', 'AwsEc2InstanceDetails$IpV6Addresses' => '<p>The IPv6 addresses associated with the instance.</p>', 'AwsElbLoadBalancerBackendServerDescription$PolicyNames' => '<p>The names of the policies that are enabled for the EC2 instance.</p>', 'AwsElbLoadBalancerDetails$AvailabilityZones' => '<p>The list of Availability Zones for the load balancer.</p>', 'AwsElbLoadBalancerDetails$SecurityGroups' => '<p>The security groups for the load balancer. Only provided if the load balancer is in a VPC.</p>', 'AwsElbLoadBalancerDetails$Subnets' => '<p>The list of subnet identifiers for the load balancer.</p>', 'AwsElbLoadBalancerListenerDescription$PolicyNames' => '<p>The policies enabled for the listener.</p>', 'AwsElbLoadBalancerPolicies$OtherPolicies' => '<p>The policies other than the stickiness policies.</p>', 'AwsIamUserDetails$GroupList' => '<p>A list of IAM groups that the user belongs to.</p>', 'AwsMskClusterClusterInfoClientAuthenticationTlsDetails$CertificateAuthorityArnList' => '<p> List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA enables creation of private certificate authority (CA) hierarchies, including root and subordinate CAs, without the investment and maintenance costs of operating an on-premises CA.</p>', 'AwsRdsDbClusterDetails$AvailabilityZones' => '<p>A list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>', 'AwsRdsDbClusterDetails$CustomEndpoints' => '<p>A list of custom endpoints for the DB cluster.</p>', 'AwsRdsDbClusterDetails$ReadReplicaIdentifiers' => '<p>The identifiers of the read replicas that are associated with this DB cluster.</p>', 'AwsRdsDbClusterDetails$EnabledCloudWatchLogsExports' => '<p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>', 'AwsRdsDbClusterSnapshotDetails$AvailabilityZones' => '<p>A list of Availability Zones where instances in the DB cluster can be created.</p>', 'AwsRdsDbInstanceDetails$DbSecurityGroups' => '<p>A list of the DB security groups to assign to the DB instance.</p>', 'AwsRdsDbInstanceDetails$ReadReplicaDBInstanceIdentifiers' => '<p>List of identifiers of the read replicas associated with this DB instance.</p>', 'AwsRdsDbInstanceDetails$ReadReplicaDBClusterIdentifiers' => '<p>List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.</p>', 'AwsRdsDbInstanceDetails$EnabledCloudWatchLogsExports' => '<p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>', 'AwsRdsPendingCloudWatchLogsExports$LogTypesToEnable' => '<p>A list of log types that are being enabled.</p>', 'AwsRdsPendingCloudWatchLogsExports$LogTypesToDisable' => '<p>A list of log types that are being disabled.</p>', 'AwsRedshiftClusterDetails$PendingActions' => '<p>A list of cluster operations that are waiting to start.</p>', 'BatchGetSecurityControlsRequest$SecurityControlIds' => '<p> A list of security controls (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters). The security control ID or Amazon Resource Name (ARN) is the same across standards. </p>', 'CreateFindingAggregatorRequest$Regions' => '<p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.</p> <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list of Regions that do aggregate findings to the aggregation Region. </p> <p>An <code>InvalidInputException</code> error results if you populate this field while <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.</p>', 'CreateFindingAggregatorResponse$Regions' => '<p>The list of excluded Regions or included Regions.</p>', 'EnumConfigurationOptions$AllowedValues' => '<p> The valid values for a control parameter that is an enum. </p>', 'EnumListConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is a list of enums. </p>', 'EnumListConfigurationOptions$AllowedValues' => '<p> The valid values for a control parameter that is a list of enums. </p>', 'GetFindingAggregatorResponse$Regions' => '<p>The list of excluded Regions or included Regions.</p>', 'NetworkPathComponentDetails$Address' => '<p>The IP addresses of the destination.</p>', 'ParameterValue$StringList' => '<p> A control parameter that is a list of strings. </p>', 'ParameterValue$EnumList' => '<p> A control parameter that is a list of enums. </p>', 'StringListConfigurationOptions$DefaultValue' => '<p> The Security Hub default value for a control parameter that is a list of strings. </p>', 'UpdateFindingAggregatorRequest$Regions' => '<p>If <code>RegionLinkingMode</code> is <code>ALL_REGIONS_EXCEPT_SPECIFIED</code>, then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.</p> <p>If <code>RegionLinkingMode</code> is <code>SPECIFIED_REGIONS</code>, then this is a space-separated list of Regions that do aggregate findings to the aggregation Region.</p> <p>An <code>InvalidInputException</code> error results if you populate this field while <code>RegionLinkingMode</code> is <code>NO_REGIONS</code>.</p>', 'UpdateFindingAggregatorResponse$Regions' => '<p>The list of excluded Regions or included Regions.</p>', 'Vulnerability$RelatedVulnerabilities' => '<p>List of vulnerabilities that are related to this vulnerability.</p>', 'Vulnerability$ReferenceUrls' => '<p>A list of URLs that provide additional information about the vulnerability.</p>', ], ], 'StringListConfigurationOptions' => [ 'base' => '<p> The options for customizing a security control parameter that is a list of strings. </p>', 'refs' => [ 'ConfigurationOptions$StringList' => '<p> The options for customizing a security control parameter that is a list of strings. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys associated with the tags to remove from the resource. You can remove up to 50 tags at a time.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAutomationRuleRequest$Tags' => '<p> User-defined tags associated with an automation rule. </p>', 'CreateConfigurationPolicyRequest$Tags' => '<p> User-defined tags associated with a configuration policy. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html">Tagging Security Hub resources</a> in the <i>Security Hub user guide</i>. </p>', 'EnableSecurityHubRequest$Tags' => '<p>The tags to add to the hub resource when you enable Security Hub.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags associated with a resource.</p>', 'TagResourceRequest$Tags' => '<p>The tags to add to the resource. You can add up to 50 tags at a time. The tag keys can be no longer than 128 characters. The tag values can be no longer than 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Target' => [ 'base' => '<p> The target account, organizational unit, or the root that is associated with an Security Hub configuration. The configuration can be a configuration policy or self-managed behavior. </p>', 'refs' => [ 'ConfigurationPolicyAssociation$Target' => '<p> The target account, organizational unit, or the root. </p>', 'GetConfigurationPolicyAssociationRequest$Target' => '<p> The target account ID, organizational unit ID, or the root ID to retrieve the association for. </p>', 'StartConfigurationPolicyAssociationRequest$Target' => '<p> The identifier of the target account, organizational unit, or the root to associate with the specified configuration. </p>', 'StartConfigurationPolicyDisassociationRequest$Target' => '<p> The identifier of the target account, organizational unit, or the root to disassociate from the specified configuration. </p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationPolicyAssociationSummary$TargetType' => '<p> Specifies whether the target is an Amazon Web Services account, organizational unit, or the root. </p>', 'GetConfigurationPolicyAssociationResponse$TargetType' => '<p> Specifies whether the target is an Amazon Web Services account, organizational unit, or the organization root. </p>', 'StartConfigurationPolicyAssociationResponse$TargetType' => '<p> Indicates whether the target is an Amazon Web Services account, organizational unit, or the organization root. </p>', ], ], 'Threat' => [ 'base' => '<p>Provides information about the threat detected in a security finding and the file paths that were affected by the threat. </p>', 'refs' => [ 'ThreatList$member' => NULL, ], ], 'ThreatIntelIndicator' => [ 'base' => '<p>Details about the threat intelligence related to a finding.</p>', 'refs' => [ 'ThreatIntelIndicatorList$member' => NULL, ], ], 'ThreatIntelIndicatorCategory' => [ 'base' => NULL, 'refs' => [ 'ThreatIntelIndicator$Category' => '<p>The category of a threat intelligence indicator.</p>', ], ], 'ThreatIntelIndicatorList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$ThreatIntelIndicators' => '<p>Threat intelligence details related to a finding.</p> <p>Array Members: Minimum number of 1 item. Maximum number of 5 items.</p>', ], ], 'ThreatIntelIndicatorType' => [ 'base' => NULL, 'refs' => [ 'ThreatIntelIndicator$Type' => '<p>The type of threat intelligence indicator.</p>', ], ], 'ThreatList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Threats' => '<p>Details about the threat detected in a security finding and the file paths that were affected by the threat. </p> <p>Array Members: Minimum number of 1 item. Maximum number of 32 items.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesConfig$CreatedAt' => '<p> A timestamp that indicates when the rule was created. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AutomationRulesConfig$UpdatedAt' => '<p> A timestamp that indicates when the rule was most recently updated. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AutomationRulesMetadata$CreatedAt' => '<p> A timestamp that indicates when the rule was created. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'AutomationRulesMetadata$UpdatedAt' => '<p> A timestamp that indicates when the rule was most recently updated. </p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'ConfigurationPolicyAssociationSummary$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated. </p>', 'ConfigurationPolicySummary$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated. </p>', 'CreateConfigurationPolicyResponse$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated. </p>', 'CreateConfigurationPolicyResponse$CreatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was created. </p>', 'FindingHistoryRecord$UpdateTime' => '<p> A timestamp that indicates when Security Hub processed the updated finding record.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'GetConfigurationPolicyAssociationResponse$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated. </p>', 'GetConfigurationPolicyResponse$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated. </p>', 'GetConfigurationPolicyResponse$CreatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was created. </p>', 'GetFindingHistoryRequest$StartTime' => '<p>A timestamp that indicates the start time of the requested finding history.</p> <p>If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding history for the specified time period. If you provide a value for <code>StartTime</code> but not for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at which the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>, Security Hub returns finding history from the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt">CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'GetFindingHistoryRequest$EndTime' => '<p> An ISO 8601-formatted timestamp that indicates the end time of the requested finding history.</p> <p>If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding history for the specified time period. If you provide a value for <code>StartTime</code> but not for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at which the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>, Security Hub returns finding history from the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt">CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is limited to 100 results, and the maximum time period is limited to 90 days.</p> <p>This field accepts only the specified formats. Timestamps can end with <code>Z</code> or <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:</p> <ul> <li> <p> <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)</p> </li> <li> <p> <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)</p> </li> </ul>', 'Invitation$InvitedAt' => '<p>The timestamp of when the invitation was sent.</p>', 'Member$InvitedAt' => '<p>A timestamp for the date and time when the invitation was sent to the member account.</p>', 'Member$UpdatedAt' => '<p>The timestamp for the date and time when the member account was updated.</p>', 'StandardsControl$ControlStatusUpdatedAt' => '<p>The date and time that the status of the security standard control was most recently updated.</p>', 'StandardsControlAssociationDetail$UpdatedAt' => '<p> The time at which the enablement status of the control in the specified standard was last updated. </p>', 'StandardsControlAssociationSummary$UpdatedAt' => '<p>The last time that a control\'s enablement status in a specified standard was updated.</p>', 'StartConfigurationPolicyAssociationResponse$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy association was last updated. </p>', 'UpdateConfigurationPolicyResponse$UpdatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was last updated. </p>', 'UpdateConfigurationPolicyResponse$CreatedAt' => '<p> The date and time, in UTC and ISO 8601 format, that the configuration policy was created. </p>', ], ], 'TypeList' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFieldsUpdate$Types' => '<p> The rule action updates the <code>Types</code> field of a finding. </p>', 'AwsSecurityFinding$Types' => '<p>One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.</p> <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p> <p>Array Members: Maximum number of 50 items.</p>', 'BatchUpdateFindingsRequest$Types' => '<p>One or more finding types in the format of namespace/category/classifier that classify a finding.</p> <p>Valid namespace values are as follows.</p> <ul> <li> <p>Software and Configuration Checks</p> </li> <li> <p>TTPs</p> </li> <li> <p>Effects</p> </li> <li> <p>Unusual Behaviors</p> </li> <li> <p>Sensitive Data Identifications </p> </li> </ul>', 'FindingProviderFields$Types' => '<p>One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.</p> <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>', 'GeneratorDetails$Labels' => '<p> An array of tags used to identify the detector associated with the finding. </p> <p>Array Members: Minimum number of 0 items. Maximum number of 10 items.</p>', 'SecurityControlParameter$Value' => '<p> The current value of a control parameter. </p>', 'VulnerabilityCodeVulnerabilities$Cwes' => '<p> The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability. </p>', ], ], 'UnprocessedAutomationRule' => [ 'base' => '<p> A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn\'t process and why. </p>', 'refs' => [ 'UnprocessedAutomationRulesList$member' => NULL, ], ], 'UnprocessedAutomationRulesList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteAutomationRulesResponse$UnprocessedAutomationRules' => '<p> A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn\'t delete and why. </p>', 'BatchGetAutomationRulesResponse$UnprocessedAutomationRules' => '<p> A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn\'t retrieve and why. </p>', 'BatchUpdateAutomationRulesResponse$UnprocessedAutomationRules' => '<p> A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn\'t update and why. </p>', ], ], 'UnprocessedConfigurationPolicyAssociation' => [ 'base' => '<p> An array of configuration policy associations, one for each configuration policy association identifier, that was specified in a <code>BatchGetConfigurationPolicyAssociations</code> request but couldn’t be processed due to an error. </p>', 'refs' => [ 'UnprocessedConfigurationPolicyAssociationList$member' => NULL, ], ], 'UnprocessedConfigurationPolicyAssociationList' => [ 'base' => NULL, 'refs' => [ 'BatchGetConfigurationPolicyAssociationsResponse$UnprocessedConfigurationPolicyAssociations' => '<p> An array of configuration policy associations, one for each configuration policy association identifier, that was specified in the request but couldn’t be processed due to an error. </p>', ], ], 'UnprocessedErrorCode' => [ 'base' => NULL, 'refs' => [ 'UnprocessedSecurityControl$ErrorCode' => '<p> The error code for the unprocessed security control. </p>', 'UnprocessedStandardsControlAssociation$ErrorCode' => '<p>The error code for the unprocessed standard and control association. </p>', 'UnprocessedStandardsControlAssociationUpdate$ErrorCode' => '<p>The error code for the unprocessed update of the control\'s enablement status in the specified standard.</p>', ], ], 'UnprocessedSecurityControl' => [ 'base' => '<p> Provides details about a security control for which a response couldn\'t be returned. </p>', 'refs' => [ 'UnprocessedSecurityControls$member' => NULL, ], ], 'UnprocessedSecurityControls' => [ 'base' => NULL, 'refs' => [ 'BatchGetSecurityControlsResponse$UnprocessedIds' => '<p> A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) for which details cannot be returned. </p>', ], ], 'UnprocessedStandardsControlAssociation' => [ 'base' => '<p> Provides details about which control\'s enablement status couldn\'t be retrieved in a specified standard when calling <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html">BatchUpdateStandardsControlAssociations</a>. This parameter also provides details about why the request was unprocessed. </p>', 'refs' => [ 'UnprocessedStandardsControlAssociations$member' => NULL, ], ], 'UnprocessedStandardsControlAssociationUpdate' => [ 'base' => '<p>Provides details about which control\'s enablement status could not be updated in a specified standard when calling the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html">BatchUpdateStandardsControlAssociations</a> API. This parameter also provides details about why the request was unprocessed. </p>', 'refs' => [ 'UnprocessedStandardsControlAssociationUpdates$member' => NULL, ], ], 'UnprocessedStandardsControlAssociationUpdates' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateStandardsControlAssociationsResponse$UnprocessedAssociationUpdates' => '<p> A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) whose enablement status in a specified standard couldn\'t be updated. </p>', ], ], 'UnprocessedStandardsControlAssociations' => [ 'base' => NULL, 'refs' => [ 'BatchGetStandardsControlAssociationsResponse$UnprocessedAssociations' => '<p> A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) whose enablement status in a specified standard cannot be returned. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAutomationRulesRequestItem' => [ 'base' => '<p> Specifies the parameters to update in an existing automation rule. </p>', 'refs' => [ 'UpdateAutomationRulesRequestItemsList$member' => NULL, ], ], 'UpdateAutomationRulesRequestItemsList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateAutomationRulesRequest$UpdateAutomationRulesRequestItems' => '<p> An array of ARNs for the rules that are to be updated. Optionally, you can also include <code>RuleStatus</code> and <code>RuleOrder</code>. </p>', ], ], 'UpdateConfigurationPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfigurationPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingAggregatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityControlRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityControlResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityHubConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityHubConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStandardsControlRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStandardsControlResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStatus' => [ 'base' => NULL, 'refs' => [ 'SecurityControl$UpdateStatus' => '<p> Identifies whether customizable properties of a security control are reflected in Security Hub findings. A status of <code>READY</code> indicates that Security Hub uses the current control parameter values when running security checks of the control. A status of <code>UPDATING</code> indicates that all security checks might not use the current parameter values. </p>', ], ], 'VerificationState' => [ 'base' => NULL, 'refs' => [ 'AutomationRulesFindingFieldsUpdate$VerificationState' => '<p> The rule action updates the <code>VerificationState</code> field of a finding. </p>', 'AwsSecurityFinding$VerificationState' => '<p>Indicates the veracity of a finding. </p>', 'BatchUpdateFindingsRequest$VerificationState' => '<p>Indicates the veracity of a finding.</p> <p>The available values for <code>VerificationState</code> are as follows.</p> <ul> <li> <p> <code>UNKNOWN</code> – The default disposition of a security finding</p> </li> <li> <p> <code>TRUE_POSITIVE</code> – The security finding is confirmed</p> </li> <li> <p> <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm</p> </li> <li> <p> <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn\'t pose any threat, is expected, or both</p> </li> </ul>', ], ], 'VolumeMount' => [ 'base' => '<p>Describes the mounting of a volume in a container. </p>', 'refs' => [ 'VolumeMountList$member' => NULL, ], ], 'VolumeMountList' => [ 'base' => NULL, 'refs' => [ 'ContainerDetails$VolumeMounts' => '<p>Provides information about the mounting of a volume in a container. </p>', ], ], 'VpcInfoCidrBlockSetDetails' => [ 'base' => '<p>Provides details about the IPv4 CIDR blocks for the VPC. </p>', 'refs' => [ 'VpcInfoCidrBlockSetList$member' => NULL, ], ], 'VpcInfoCidrBlockSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcPeeringConnectionVpcInfoDetails$CidrBlockSet' => '<p>Information about the IPv4 CIDR blocks for the VPC. </p>', ], ], 'VpcInfoIpv6CidrBlockSetDetails' => [ 'base' => '<p>Provides details about the IPv6 CIDR blocks for the VPC. </p>', 'refs' => [ 'VpcInfoIpv6CidrBlockSetList$member' => NULL, ], ], 'VpcInfoIpv6CidrBlockSetList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcPeeringConnectionVpcInfoDetails$Ipv6CidrBlockSet' => '<p>The IPv6 CIDR block for the VPC. </p>', ], ], 'VpcInfoPeeringOptionsDetails' => [ 'base' => '<p>Provides information about the VPC peering connection options for the accepter or requester VPC. </p>', 'refs' => [ 'AwsEc2VpcPeeringConnectionVpcInfoDetails$PeeringOptions' => '<p>Information about the VPC peering connection options for the accepter or requester VPC. </p>', ], ], 'Vulnerability' => [ 'base' => '<p>A vulnerability associated with a finding.</p>', 'refs' => [ 'VulnerabilityList$member' => NULL, ], ], 'VulnerabilityCodeVulnerabilities' => [ 'base' => '<p>Provides details about the vulnerabilities found in your Lambda function code. This field pertains to findings that Security Hub receives from Amazon Inspector. </p>', 'refs' => [ 'VulnerabilityCodeVulnerabilitiesList$member' => NULL, ], ], 'VulnerabilityCodeVulnerabilitiesList' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$CodeVulnerabilities' => '<p>The vulnerabilities found in your Lambda function code. This field pertains to findings that Security Hub receives from Amazon Inspector. </p>', ], ], 'VulnerabilityExploitAvailable' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$ExploitAvailable' => '<p>Whether an exploit is available for a finding. </p>', ], ], 'VulnerabilityFixAvailable' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$FixAvailable' => '<p>Specifies if all vulnerable packages in a finding have a value for <code>FixedInVersion</code> and <code>Remediation</code>. This field is evaluated for each vulnerability <code>Id</code> based on the number of vulnerable packages that have a value for both <code>FixedInVersion</code> and <code>Remediation</code>. Valid values are as follows:</p> <ul> <li> <p> <code>YES</code> if all vulnerable packages have a value for both <code>FixedInVersion</code> and <code>Remediation</code> </p> </li> <li> <p> <code>NO</code> if no vulnerable packages have a value for <code>FixedInVersion</code> and <code>Remediation</code> </p> </li> <li> <p> <code>PARTIAL</code> otherwise</p> </li> </ul>', ], ], 'VulnerabilityList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Vulnerabilities' => '<p>Provides a list of vulnerabilities associated with the findings.</p>', ], ], 'VulnerabilityVendor' => [ 'base' => '<p>A vendor that generates a vulnerability report.</p>', 'refs' => [ 'Vulnerability$Vendor' => '<p>Information about the vendor that generates the vulnerability report.</p>', ], ], 'WafAction' => [ 'base' => '<p>Details about the action that CloudFront or WAF takes when a web request matches the conditions in the rule. </p>', 'refs' => [ 'AwsWafWebAclRule$Action' => '<p>Specifies the action that CloudFront or WAF takes when a web request matches the conditions in the rule. </p>', ], ], 'WafExcludedRule' => [ 'base' => '<p>Details about a rule to exclude from a rule group.</p>', 'refs' => [ 'WafExcludedRuleList$member' => NULL, ], ], 'WafExcludedRuleList' => [ 'base' => NULL, 'refs' => [ 'AwsWafWebAclRule$ExcludedRules' => '<p>Rules to exclude from a rule group.</p>', ], ], 'WafOverrideAction' => [ 'base' => '<p>Details about an override action for a rule.</p>', 'refs' => [ 'AwsWafWebAclRule$OverrideAction' => '<p>Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p> <p>Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> blocks a request if any individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request.</p> <p>However, if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to <code>Count</code>. The <code>RuleGroup</code> then overrides any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests are counted.</p> <p> <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a web ACL. In this case you do not use <code>ActivatedRule</code> <code>Action</code>. For all other update requests, <code>ActivatedRule</code> <code>Action</code> is used instead of <code>ActivatedRule</code> <code>OverrideAction</code>.</p>', ], ], 'Workflow' => [ 'base' => '<p>Provides details about the status of the investigation into a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Workflow' => '<p>Provides information about the status of the investigation into a finding.</p>', ], ], 'WorkflowState' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$WorkflowState' => '<p>The workflow state of a finding. </p>', ], ], 'WorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'Workflow$Status' => '<p>The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p> <p>The allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> <p>Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p> <ul> <li> <p> <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p> <code>ComplianceStatus</code> changes from <code>PASSED</code> to either <code>WARNING</code>, <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li> <p> <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> </li> <li> <p> <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved. </p> </li> </ul>', 'WorkflowUpdate$Status' => '<p>The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.</p> <p>The allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> <p>Security Hub also resets <code>WorkFlowStatus</code> from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:</p> <ul> <li> <p>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code>.</p> </li> <li> <p>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code>, <code>FAILED</code>, or <code>NOT_AVAILABLE</code>.</p> </li> </ul> </li> <li> <p> <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</p> </li> <li> <p> <code>SUPPRESSED</code> - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.</p> </li> </ul>', ], ], 'WorkflowUpdate' => [ 'base' => '<p>Used to update information about the investigation into the finding.</p>', 'refs' => [ 'AutomationRulesFindingFieldsUpdate$Workflow' => NULL, 'BatchUpdateFindingsRequest$Workflow' => '<p>Used to update the workflow status of a finding.</p> <p>The workflow status indicates the progress of the investigation into the finding. </p>', ], ], ],];
