<?php
// This file was auto-generated from sdk-root/src/data/securitylake/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Security Lake is a fully managed security data lake service. You can use Security Lake to automatically centralize security data from cloud, on-premises, and custom sources into a data lake that\'s stored in your Amazon Web Services account. Amazon Web Services Organizations is an account management service that lets you consolidate multiple Amazon Web Services accounts into an organization that you create and centrally manage. With Organizations, you can create member accounts and invite existing accounts to join your organization. Security Lake helps you analyze security data for a more complete understanding of your security posture across the entire organization. It can also help you improve the protection of your workloads, applications, and data.</p> <p>The data lake is backed by Amazon Simple Storage Service (Amazon S3) buckets, and you retain ownership over your data.</p> <p>Amazon Security Lake integrates with CloudTrail, a service that provides a record of actions taken by a user, role, or an Amazon Web Services service. In Security Lake, CloudTrail captures API calls for Security Lake as events. The calls captured include calls from the Security Lake console and code calls to the Security Lake API operations. If you create a trail, you can enable continuous delivery of CloudTrail events to an Amazon S3 bucket, including events for Security Lake. If you don\'t configure a trail, you can still view the most recent events in the CloudTrail console in Event history. Using the information collected by CloudTrail you can determine the request that was made to Security Lake, the IP address from which the request was made, who made the request, when it was made, and additional details. To learn more about Security Lake information in CloudTrail, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/securitylake-cloudtrail.html">Amazon Security Lake User Guide</a>.</p> <p>Security Lake automates the collection of security-related log and event data from integrated Amazon Web Services and third-party services. It also helps you manage the lifecycle of data with customizable retention and replication settings. Security Lake converts ingested data into Apache Parquet format and a standard open-source schema called the Open Cybersecurity Schema Framework (OCSF).</p> <p>Other Amazon Web Services and third-party services can subscribe to the data that\'s stored in Security Lake for incident response and security data analytics.</p>', 'operations' => [ 'CreateAwsLogSource' => '<p>Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source type in any Region for either accounts that are part of a trusted organization or standalone accounts. Once you add an Amazon Web Service as a source, Security Lake starts collecting logs and events from it.</p> <p>You can use this API only to enable natively supported Amazon Web Services as a source. Use <code>CreateCustomLogSource</code> to enable data collection from a custom source.</p>', 'CreateCustomLogSource' => '<p>Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from the custom source. In addition, this operation also creates an associated Glue table and an Glue crawler.</p>', 'CreateDataLake' => '<p>Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions. To specify particular Regions, configure these Regions using the <code>configurations</code> parameter. If you have already enabled Security Lake in a Region when you call this command, the command will update the Region if you provide new configuration parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up the data lake in the Region with the specified configurations.</p> <p>When you enable Security Lake, it starts ingesting security data after the <code>CreateAwsLogSource</code> call. This includes ingesting security data from sources, storing data, and making data accessible to subscribers. Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon Web Services account in the current Region, including security log and event data. For more information, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html">Amazon Security Lake User Guide</a>.</p>', 'CreateDataLakeExceptionSubscription' => '<p>Creates the specified notification subscription in Amazon Security Lake for the organization you specify.</p>', 'CreateDataLakeOrganizationConfiguration' => '<p>Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not automatically enabled for any existing member accounts in your organization.</p>', 'CreateSubscriber' => '<p>Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a subscriber with access to data in the current Amazon Web Services Region.</p>', 'CreateSubscriberNotification' => '<p>Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake. You can create only one subscriber notification per subscriber.</p>', 'DeleteAwsLogSource' => '<p>Removes a natively supported Amazon Web Service as an Amazon Security Lake source. You can remove a source for one or more Regions. When you remove the source, Security Lake stops collecting data from that source in the specified Regions and accounts, and subscribers can no longer consume new data from the source. However, subscribers can still consume data that Security Lake collected from the source before removal.</p> <p>You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted organization or standalone accounts. </p>', 'DeleteCustomLogSource' => '<p>Removes a custom log source from Amazon Security Lake, to stop sending data from the custom source to Security Lake.</p>', 'DeleteDataLake' => '<p>When you disable Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services Regions and it stops collecting data from your sources. Also, this API automatically takes steps to remove the account from Security Lake. However, Security Lake retains all of your existing settings and the resources that it created in your Amazon Web Services account in the current Amazon Web Services Region.</p> <p>The <code>DeleteDataLake</code> operation does not delete the data that is stored in your Amazon S3 bucket, which is owned by your Amazon Web Services account. For more information, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html">Amazon Security Lake User Guide</a>.</p>', 'DeleteDataLakeExceptionSubscription' => '<p>Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.</p>', 'DeleteDataLakeOrganizationConfiguration' => '<p>Turns off automatic enablement of Amazon Security Lake for member accounts that are added to an organization in Organizations. Only the delegated Security Lake administrator for an organization can perform this operation. If the delegated Security Lake administrator performs this operation, new member accounts won\'t automatically contribute data to the data lake.</p>', 'DeleteSubscriber' => '<p>Deletes the subscription permission and all notification settings for accounts that are already enabled in Amazon Security Lake. When you run <code>DeleteSubscriber</code>, the subscriber will no longer consume data from Security Lake and the subscriber is removed. This operation deletes the subscriber and removes access to data in the current Amazon Web Services Region.</p>', 'DeleteSubscriberNotification' => '<p>Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.</p>', 'DeregisterDataLakeDelegatedAdministrator' => '<p>Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.</p>', 'GetDataLakeExceptionSubscription' => '<p>Retrieves the details of exception notifications for the account in Amazon Security Lake.</p>', 'GetDataLakeOrganizationConfiguration' => '<p>Retrieves the configuration that will be automatically set up for accounts added to the organization after the organization has onboarded to Amazon Security Lake. This API does not take input parameters.</p>', 'GetDataLakeSources' => '<p>Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from.</p>', 'GetSubscriber' => '<p>Retrieves the subscription information for the specified subscription ID. You can get information about a specific subscriber.</p>', 'ListDataLakeExceptions' => '<p>Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.</p>', 'ListDataLakes' => '<p>Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services Regions. You can use this operation to determine whether Security Lake is enabled for a Region.</p>', 'ListLogSources' => '<p>Retrieves the log sources in the current Amazon Web Services Region.</p>', 'ListSubscribers' => '<p>List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions associated with a specific organization or Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Retrieves the tags (keys and values) that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.</p>', 'RegisterDataLakeDelegatedAdministrator' => '<p>Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.</p>', 'TagResource' => '<p>Adds or updates one or more tags that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region. A <i>tag</i> is a label that you can define and associate with Amazon Web Services resources. Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>. A <i>tag key</i> is a general label that acts as a category for a more specific tag value. A <i>tag value</i> acts as a descriptor for a tag key. Tags can help you identify, categorize, and manage resources in different ways, such as by owner, environment, or other criteria. For more information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html">Tagging Amazon Security Lake resources</a> in the <i>Amazon Security Lake User Guide</i>.</p>', 'UntagResource' => '<p>Removes one or more tags (keys and values) from an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.</p>', 'UpdateDataLake' => '<p>Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data from multiple Amazon Web Services Regions.</p>', 'UpdateDataLakeExceptionSubscription' => '<p>Updates the specified notification subscription in Amazon Security Lake for the organization you specify.</p>', 'UpdateSubscriber' => '<p>Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by changing the sources that the subscriber consumes data from.</p>', 'UpdateSubscriberNotification' => '<p>Updates an existing notification method for the subscription (SQS or HTTPs endpoint) or switches the notification subscription endpoint for a subscriber.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action. Access denied errors appear when Amazon Security Lake explicitly or implicitly denies an authorization request. An explicit denial occurs when a policy contains a Deny statement for the specific Amazon Web Services action. An implicit denial occurs when there is no applicable Deny statement and also no applicable Allow statement.</p>', 'refs' => [], ], 'AccessType' => [ 'base' => NULL, 'refs' => [ 'AccessTypeList$member' => NULL, ], ], 'AccessTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriberRequest$accessTypes' => '<p>The Amazon S3 or Lake Formation access type.</p>', 'SubscriberResource$accessTypes' => '<p>You can choose to notify subscribers of new objects with an Amazon Simple Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint provided by the subscriber.</p> <p> Subscribers can consume data by directly querying Lake Formation tables in your Amazon S3 bucket through services like Amazon Athena. This subscription type is defined as <code>LAKEFORMATION</code>.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'AwsLogSourceConfiguration$accounts' => '<p>Specify the Amazon Web Services account information where you want to enable Security Lake.</p>', 'CreateAwsLogSourceResponse$failed' => '<p>Lists all accounts in which enabling a natively supported Amazon Web Service as a Security Lake source failed. The failure occurred as these accounts are not part of an organization.</p>', 'DeleteAwsLogSourceResponse$failed' => '<p>Deletion of the Amazon Web Services sources failed as the account is not a part of the organization.</p>', 'GetDataLakeSourcesRequest$accounts' => '<p>The Amazon Web Services account ID for which a static snapshot of the current Amazon Web Services Region, including enabled accounts and log sources, is retrieved.</p>', 'ListLogSourcesRequest$accounts' => '<p>The list of Amazon Web Services accounts for which log sources are displayed.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'CustomLogSourceAttributes$crawlerArn' => '<p>The ARN of the Glue crawler.</p>', 'CustomLogSourceAttributes$databaseArn' => '<p>The ARN of the Glue database where results are written, such as: <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>', 'CustomLogSourceAttributes$tableArn' => '<p>The ARN of the Glue table.</p>', 'DataLakeResource$dataLakeArn' => '<p>The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and how to use them in policies, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security Lake User Guide</a>.</p>', 'GetDataLakeSourcesResponse$dataLakeArn' => '<p>The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and how to use them in policies, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security Lake User Guide</a>.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Security Lake resource for which you want to retrieve the tags.</p>', 'SubscriberResource$subscriberArn' => '<p>The subscriber ARN of the Amazon Security Lake subscriber account.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Security Lake resource to add or update the tags for.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Security Lake resource to remove one or more tags from.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'AccountList$member' => NULL, 'LogSource$account' => '<p>Specify the account from which you want to collect logs.</p>', ], ], 'AwsIdentity' => [ 'base' => '<p>The AWS identity.</p>', 'refs' => [ 'CreateSubscriberRequest$subscriberIdentity' => '<p>The Amazon Web Services identity used to access your data.</p>', 'CustomLogSourceConfiguration$providerIdentity' => '<p>The identity of the log provider for the third-party custom source.</p>', 'SubscriberResource$subscriberIdentity' => '<p>The Amazon Web Services identity used to access your data.</p>', 'UpdateSubscriberRequest$subscriberIdentity' => '<p>The AWS identity used to access your data.</p>', ], ], 'AwsLogSourceConfiguration' => [ 'base' => '<p>The Security Lake logs source configuration file describes the information needed to generate Security Lake logs. </p>', 'refs' => [ 'AwsLogSourceConfigurationList$member' => NULL, ], ], 'AwsLogSourceConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateAwsLogSourceRequest$sources' => '<p>Specify the natively-supported Amazon Web Services service to add as a source in Security Lake.</p>', 'DeleteAwsLogSourceRequest$sources' => '<p>Specify the natively-supported Amazon Web Services service to remove as a source in Security Lake.</p>', ], ], 'AwsLogSourceName' => [ 'base' => NULL, 'refs' => [ 'AwsLogSourceConfiguration$sourceName' => '<p>The name for a Amazon Web Services source. This must be a Regionally unique value.</p>', 'AwsLogSourceResource$sourceName' => '<p>The name for a Amazon Web Services source. This must be a Regionally unique value.</p>', ], ], 'AwsLogSourceResource' => [ 'base' => '<p>Amazon Security Lake can collect logs and events from natively-supported Amazon Web Services services.</p>', 'refs' => [ 'AwsLogSourceResourceList$member' => NULL, 'LogSourceResource$awsLogSource' => '<p>Amazon Security Lake supports log and event collection for natively supported Amazon Web Services. For more information, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User Guide</a>.</p>', ], ], 'AwsLogSourceResourceList' => [ 'base' => NULL, 'refs' => [ 'DataLakeAutoEnableNewAccountConfiguration$sources' => '<p>The Amazon Web Services sources that are automatically enabled in Security Lake.</p>', ], ], 'AwsLogSourceVersion' => [ 'base' => NULL, 'refs' => [ 'AwsLogSourceConfiguration$sourceVersion' => '<p>The version for a Amazon Web Services source. This must be a Regionally unique value.</p>', 'AwsLogSourceResource$sourceVersion' => '<p>The version for a Amazon Web Services source. This must be a Regionally unique value.</p>', ], ], 'AwsPrincipal' => [ 'base' => NULL, 'refs' => [ 'AwsIdentity$principal' => '<p>The AWS identity principal.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>Occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>', 'refs' => [], ], 'CreateAwsLogSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAwsLogSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomLogSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomLogSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeExceptionSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeExceptionSubscriptionRequest$exceptionTimeToLive' => '<p>The expiration period and time-to-live (TTL).</p>', ], ], 'CreateDataLakeExceptionSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataLakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriberNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriberNotificationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriberRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriberRequestSubscriberNameString' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriberRequest$subscriberName' => '<p>The name of your Security Lake subscriber account.</p>', ], ], 'CreateSubscriberResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomLogSourceAttributes' => [ 'base' => '<p>The attributes of a third-party custom source.</p>', 'refs' => [ 'CustomLogSourceResource$attributes' => '<p>The attributes of a third-party custom source.</p>', ], ], 'CustomLogSourceConfiguration' => [ 'base' => '<p>The configuration for the third-party custom source.</p>', 'refs' => [ 'CreateCustomLogSourceRequest$configuration' => '<p>The configuration for the third-party custom source.</p>', ], ], 'CustomLogSourceCrawlerConfiguration' => [ 'base' => '<p>The configuration for the Glue Crawler for the third-party custom source.</p>', 'refs' => [ 'CustomLogSourceConfiguration$crawlerConfiguration' => '<p>The configuration for the Glue Crawler for the third-party custom source.</p>', ], ], 'CustomLogSourceName' => [ 'base' => NULL, 'refs' => [ 'CreateCustomLogSourceRequest$sourceName' => '<p>Specify the name for a third-party custom source. This must be a Regionally unique value.</p>', 'CustomLogSourceResource$sourceName' => '<p>The name for a third-party custom source. This must be a Regionally unique value.</p>', 'DeleteCustomLogSourceRequest$sourceName' => '<p>The source name of custom log source that you want to delete.</p>', ], ], 'CustomLogSourceProvider' => [ 'base' => '<p>The details of the log provider for a third-party custom source.</p>', 'refs' => [ 'CustomLogSourceResource$provider' => '<p>The details of the log provider for a third-party custom source.</p>', ], ], 'CustomLogSourceResource' => [ 'base' => '<p>Amazon Security Lake can collect logs and events from third-party custom sources.</p>', 'refs' => [ 'CreateCustomLogSourceResponse$source' => '<p>The created third-party custom source.</p>', 'LogSourceResource$customLogSource' => '<p>Amazon Security Lake supports custom source types. For more information, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/custom-sources.html">Amazon Security Lake User Guide</a>.</p>', ], ], 'CustomLogSourceVersion' => [ 'base' => NULL, 'refs' => [ 'CreateCustomLogSourceRequest$sourceVersion' => '<p>Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.</p>', 'CustomLogSourceResource$sourceVersion' => '<p>The version for a third-party custom source. This must be a Regionally unique value.</p>', 'DeleteCustomLogSourceRequest$sourceVersion' => '<p>The source version for the third-party custom source. You can limit the custom source removal to the specified source version.</p>', ], ], 'DataLakeAutoEnableNewAccountConfiguration' => [ 'base' => '<p>Automatically enable new organization accounts as member accounts from an Amazon Security Lake administrator account.</p>', 'refs' => [ 'DataLakeAutoEnableNewAccountConfigurationList$member' => NULL, ], ], 'DataLakeAutoEnableNewAccountConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeOrganizationConfigurationRequest$autoEnableNewAccount' => '<p>Enable Security Lake with the specified configuration settings, to begin collecting security data for new accounts in your organization.</p>', 'DeleteDataLakeOrganizationConfigurationRequest$autoEnableNewAccount' => '<p>Turns off automatic enablement of Security Lake for member accounts that are added to an organization.</p>', 'GetDataLakeOrganizationConfigurationResponse$autoEnableNewAccount' => '<p>The configuration for new accounts.</p>', ], ], 'DataLakeConfiguration' => [ 'base' => '<p>Provides details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeConfigurationList$member' => NULL, ], ], 'DataLakeConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeRequest$configurations' => '<p>Specify the Region or Regions that will contribute data to the rollup region.</p>', 'UpdateDataLakeRequest$configurations' => '<p>Specify the Region or Regions that will contribute data to the rollup region.</p>', ], ], 'DataLakeEncryptionConfiguration' => [ 'base' => '<p>Provides encryption details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeConfiguration$encryptionConfiguration' => '<p>Provides encryption details of Amazon Security Lake object.</p>', 'DataLakeResource$encryptionConfiguration' => '<p>Provides encryption details of Amazon Security Lake object.</p>', ], ], 'DataLakeException' => [ 'base' => '<p>The details for an Amazon Security Lake exception.</p>', 'refs' => [ 'DataLakeExceptionList$member' => NULL, ], ], 'DataLakeExceptionList' => [ 'base' => NULL, 'refs' => [ 'ListDataLakeExceptionsResponse$exceptions' => '<p>Lists the failures that cannot be retried in the current Region.</p>', ], ], 'DataLakeLifecycleConfiguration' => [ 'base' => '<p>Provides lifecycle details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeConfiguration$lifecycleConfiguration' => '<p>Provides lifecycle details of Amazon Security Lake object.</p>', 'DataLakeResource$lifecycleConfiguration' => '<p>Provides lifecycle details of Amazon Security Lake object.</p>', ], ], 'DataLakeLifecycleExpiration' => [ 'base' => '<p>Provide expiration lifecycle details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeLifecycleConfiguration$expiration' => '<p>Provides data expiration details of Amazon Security Lake object.</p>', ], ], 'DataLakeLifecycleExpirationDaysInteger' => [ 'base' => NULL, 'refs' => [ 'DataLakeLifecycleExpiration$days' => '<p>Number of days before data expires in the Amazon Security Lake object.</p>', ], ], 'DataLakeLifecycleTransition' => [ 'base' => '<p>Provide transition lifecycle details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeLifecycleTransitionList$member' => NULL, ], ], 'DataLakeLifecycleTransitionDaysInteger' => [ 'base' => NULL, 'refs' => [ 'DataLakeLifecycleTransition$days' => '<p>Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.</p>', ], ], 'DataLakeLifecycleTransitionList' => [ 'base' => NULL, 'refs' => [ 'DataLakeLifecycleConfiguration$transitions' => '<p>Provides data storage transition details of Amazon Security Lake object.</p>', ], ], 'DataLakeReplicationConfiguration' => [ 'base' => '<p>Provides replication details for objects stored in the Amazon Security Lake data lake.</p>', 'refs' => [ 'DataLakeConfiguration$replicationConfiguration' => '<p>Provides replication details of Amazon Security Lake object.</p>', 'DataLakeResource$replicationConfiguration' => '<p>Provides replication details of Amazon Security Lake object.</p>', ], ], 'DataLakeResource' => [ 'base' => '<p>Provides details of Amazon Security Lake object.</p>', 'refs' => [ 'DataLakeResourceList$member' => NULL, ], ], 'DataLakeResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeResponse$dataLakes' => '<p>The created Security Lake configuration object.</p>', 'ListDataLakesResponse$dataLakes' => '<p>Retrieves the Security Lake configuration object.</p>', 'UpdateDataLakeResponse$dataLakes' => '<p>The created Security Lake configuration object.</p>', ], ], 'DataLakeSource' => [ 'base' => '<p>Amazon Security Lake collects logs and events from supported Amazon Web Services and custom sources. For the list of supported Amazon Web Services, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User Guide</a>.</p>', 'refs' => [ 'DataLakeSourceList$member' => NULL, ], ], 'DataLakeSourceList' => [ 'base' => NULL, 'refs' => [ 'GetDataLakeSourcesResponse$dataLakeSources' => '<p>The list of enabled accounts and enabled sources.</p>', ], ], 'DataLakeSourceStatus' => [ 'base' => '<p>Retrieves the Logs status for the Amazon Security Lake account.</p>', 'refs' => [ 'DataLakeSourceStatusList$member' => NULL, ], ], 'DataLakeSourceStatusList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSource$sourceStatuses' => '<p>The log status for the Security Lake account.</p>', ], ], 'DataLakeStatus' => [ 'base' => NULL, 'refs' => [ 'DataLakeResource$createStatus' => '<p>Retrieves the status of the configuration operation for an account in Amazon Security Lake.</p>', 'DataLakeUpdateStatus$status' => '<p>The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request that was requested.</p>', ], ], 'DataLakeStorageClass' => [ 'base' => NULL, 'refs' => [ 'DataLakeLifecycleTransition$storageClass' => '<p>The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.</p>', ], ], 'DataLakeUpdateException' => [ 'base' => '<p>The details of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request which failed.</p>', 'refs' => [ 'DataLakeUpdateStatus$exception' => '<p>The details of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request which failed.</p>', ], ], 'DataLakeUpdateStatus' => [ 'base' => '<p>The status of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request. This is set to Completed after the configuration is updated, or removed if deletion of the data lake is successful.</p>', 'refs' => [ 'DataLakeResource$updateStatus' => '<p>The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.</p>', ], ], 'DeleteAwsLogSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAwsLogSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomLogSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomLogSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeExceptionSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeExceptionSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataLakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriberNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriberNotificationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriberResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterDataLakeDelegatedAdministratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterDataLakeDelegatedAdministratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriberRequest$subscriberDescription' => '<p>The description for your subscriber account in Security Lake.</p>', 'UpdateSubscriberRequest$subscriberDescription' => '<p>The description of the Security Lake account subscriber.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'AwsIdentity$externalId' => '<p>The external ID used to estalish trust relationship with the AWS identity.</p>', ], ], 'GetDataLakeExceptionSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeExceptionSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriberResponse' => [ 'base' => NULL, 'refs' => [], ], 'HttpMethod' => [ 'base' => NULL, 'refs' => [ 'HttpsNotificationConfiguration$httpMethod' => '<p>The HTTPS method used for the notification subscription.</p>', ], ], 'HttpsNotificationConfiguration' => [ 'base' => '<p>The configurations for HTTPS subscriber notification.</p>', 'refs' => [ 'NotificationConfiguration$httpsNotificationConfiguration' => '<p>The configurations for HTTPS subscriber notification.</p>', ], ], 'HttpsNotificationConfigurationEndpointString' => [ 'base' => NULL, 'refs' => [ 'HttpsNotificationConfiguration$endpoint' => '<p>The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this field.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p>Retry the request after the specified time.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Internal service exceptions are sometimes caused by transient issues. Before you start troubleshooting, perform the operation again.</p>', 'refs' => [], ], 'ListDataLakeExceptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataLakeExceptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataLakesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataLakesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLogSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLogSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogSource' => [ 'base' => '<p>Amazon Security Lake can collect logs and events from natively-supported Amazon Web Services services and custom sources. </p>', 'refs' => [ 'LogSourceList$member' => NULL, ], ], 'LogSourceList' => [ 'base' => NULL, 'refs' => [ 'ListLogSourcesResponse$sources' => '<p>The list of log sources in your organization that send data to the data lake.</p>', ], ], 'LogSourceResource' => [ 'base' => '<p>The supported source types from which logs and events are collected in Amazon Security Lake. For a list of supported Amazon Web Services, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User Guide</a>.</p>', 'refs' => [ 'LogSourceResourceList$member' => NULL, ], ], 'LogSourceResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriberRequest$sources' => '<p>The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and event collection for natively supported Amazon Web Services.</p>', 'ListLogSourcesRequest$sources' => '<p>The list of sources for which log sources are displayed.</p>', 'LogSource$sources' => '<p>Specify the sources from which you want to collect logs.</p>', 'SubscriberResource$sources' => '<p>Amazon Security Lake supports log and event collection for natively supported Amazon Web Services. For more information, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/source-management.html">Amazon Security Lake User Guide</a>.</p>', 'UpdateSubscriberRequest$sources' => '<p>The supported Amazon Web Services from which logs and events are collected. For the list of supported Amazon Web Services, see the <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User Guide</a>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetDataLakeExceptionSubscriptionResponse$exceptionTimeToLive' => '<p>The expiration period and time-to-live (TTL).</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetDataLakeSourcesRequest$maxResults' => '<p>The maximum limit of accounts for which the static snapshot of the current Region, including enabled accounts and log sources, is retrieved.</p>', 'ListDataLakeExceptionsRequest$maxResults' => '<p>List the maximum number of failures in Security Lake.</p>', 'ListLogSourcesRequest$maxResults' => '<p>The maximum number of accounts for which the log sources are displayed.</p>', 'ListSubscribersRequest$maxResults' => '<p>The maximum number of accounts for which the configuration is displayed.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetDataLakeSourcesRequest$nextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', 'GetDataLakeSourcesResponse$nextToken' => '<p>Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', 'ListDataLakeExceptionsRequest$nextToken' => '<p>List if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', 'ListDataLakeExceptionsResponse$nextToken' => '<p>List if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.</p> <p>Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', 'ListLogSourcesRequest$nextToken' => '<p>If nextToken is returned, there are more results available. You can repeat the call using the returned token to retrieve the next page.</p>', 'ListLogSourcesResponse$nextToken' => '<p>If nextToken is returned, there are more results available. You can repeat the call using the returned token to retrieve the next page.</p>', 'ListSubscribersRequest$nextToken' => '<p>If nextToken is returned, there are more results available. You can repeat the call using the returned token to retrieve the next page.</p>', 'ListSubscribersResponse$nextToken' => '<p>If nextToken is returned, there are more results available. You can repeat the call using the returned token to retrieve the next page.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Specify the configurations you want to use for subscriber notification to notify the subscriber when new data is written to the data lake for sources that the subscriber consumes in Security Lake. </p>', 'refs' => [ 'CreateSubscriberNotificationRequest$configuration' => '<p>Specify the configuration using which you want to create the subscriber notification.</p>', 'UpdateSubscriberNotificationRequest$configuration' => '<p>The configuration for subscriber notification.</p>', ], ], 'OcsfEventClass' => [ 'base' => NULL, 'refs' => [ 'OcsfEventClassList$member' => NULL, ], ], 'OcsfEventClassList' => [ 'base' => NULL, 'refs' => [ 'CreateCustomLogSourceRequest$eventClasses' => '<p>The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:</p> <ul> <li> <p> <code>ACCESS_ACTIVITY</code> </p> </li> <li> <p> <code>FILE_ACTIVITY</code> </p> </li> <li> <p> <code>KERNEL_ACTIVITY</code> </p> </li> <li> <p> <code>KERNEL_EXTENSION</code> </p> </li> <li> <p> <code>MEMORY_ACTIVITY</code> </p> </li> <li> <p> <code>MODULE_ACTIVITY</code> </p> </li> <li> <p> <code>PROCESS_ACTIVITY</code> </p> </li> <li> <p> <code>REGISTRY_KEY_ACTIVITY</code> </p> </li> <li> <p> <code>REGISTRY_VALUE_ACTIVITY</code> </p> </li> <li> <p> <code>RESOURCE_ACTIVITY</code> </p> </li> <li> <p> <code>SCHEDULED_JOB_ACTIVITY</code> </p> </li> <li> <p> <code>SECURITY_FINDING</code> </p> </li> <li> <p> <code>ACCOUNT_CHANGE</code> </p> </li> <li> <p> <code>AUTHENTICATION</code> </p> </li> <li> <p> <code>AUTHORIZATION</code> </p> </li> <li> <p> <code>ENTITY_MANAGEMENT_AUDIT</code> </p> </li> <li> <p> <code>DHCP_ACTIVITY</code> </p> </li> <li> <p> <code>NETWORK_ACTIVITY</code> </p> </li> <li> <p> <code>DNS_ACTIVITY</code> </p> </li> <li> <p> <code>FTP_ACTIVITY</code> </p> </li> <li> <p> <code>HTTP_ACTIVITY</code> </p> </li> <li> <p> <code>RDP_ACTIVITY</code> </p> </li> <li> <p> <code>SMB_ACTIVITY</code> </p> </li> <li> <p> <code>SSH_ACTIVITY</code> </p> </li> <li> <p> <code>CONFIG_STATE</code> </p> </li> <li> <p> <code>INVENTORY_INFO</code> </p> </li> <li> <p> <code>EMAIL_ACTIVITY</code> </p> </li> <li> <p> <code>API_ACTIVITY</code> </p> </li> <li> <p> <code>CLOUD_API</code> </p> </li> </ul>', 'DataLakeSource$eventClasses' => '<p>The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:</p> <ul> <li> <p> <code>ACCESS_ACTIVITY</code> </p> </li> <li> <p> <code>FILE_ACTIVITY</code> </p> </li> <li> <p> <code>KERNEL_ACTIVITY</code> </p> </li> <li> <p> <code>KERNEL_EXTENSION</code> </p> </li> <li> <p> <code>MEMORY_ACTIVITY</code> </p> </li> <li> <p> <code>MODULE_ACTIVITY</code> </p> </li> <li> <p> <code>PROCESS_ACTIVITY</code> </p> </li> <li> <p> <code>REGISTRY_KEY_ACTIVITY</code> </p> </li> <li> <p> <code>REGISTRY_VALUE_ACTIVITY</code> </p> </li> <li> <p> <code>RESOURCE_ACTIVITY</code> </p> </li> <li> <p> <code>SCHEDULED_JOB_ACTIVITY</code> </p> </li> <li> <p> <code>SECURITY_FINDING</code> </p> </li> <li> <p> <code>ACCOUNT_CHANGE</code> </p> </li> <li> <p> <code>AUTHENTICATION</code> </p> </li> <li> <p> <code>AUTHORIZATION</code> </p> </li> <li> <p> <code>ENTITY_MANAGEMENT_AUDIT</code> </p> </li> <li> <p> <code>DHCP_ACTIVITY</code> </p> </li> <li> <p> <code>NETWORK_ACTIVITY</code> </p> </li> <li> <p> <code>DNS_ACTIVITY</code> </p> </li> <li> <p> <code>FTP_ACTIVITY</code> </p> </li> <li> <p> <code>HTTP_ACTIVITY</code> </p> </li> <li> <p> <code>RDP_ACTIVITY</code> </p> </li> <li> <p> <code>SMB_ACTIVITY</code> </p> </li> <li> <p> <code>SSH_ACTIVITY</code> </p> </li> <li> <p> <code>CONFIG_STATE</code> </p> </li> <li> <p> <code>INVENTORY_INFO</code> </p> </li> <li> <p> <code>EMAIL_ACTIVITY</code> </p> </li> <li> <p> <code>API_ACTIVITY</code> </p> </li> <li> <p> <code>CLOUD_API</code> </p> </li> </ul>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'DataLakeAutoEnableNewAccountConfiguration$region' => '<p>The Amazon Web Services Regions where Security Lake is automatically enabled.</p>', 'DataLakeConfiguration$region' => '<p>The Amazon Web Services Regions where Security Lake is automatically enabled.</p>', 'DataLakeException$region' => '<p>The Amazon Web Services Regions where the exception occurred.</p>', 'DataLakeResource$region' => '<p>The Amazon Web Services Regions where Security Lake is enabled.</p>', 'LogSource$region' => '<p>Specify the Regions from which you want to collect logs.</p>', 'RegionList$member' => NULL, ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'AwsLogSourceConfiguration$regions' => '<p>Specify the Regions where you want to enable Security Lake.</p>', 'DataLakeReplicationConfiguration$regions' => '<p>Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the <code>region</code> parameter of the <a href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html"> <code>CreateDataLake</code> </a> or <a href="https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html"> <code>UpdateDataLake</code> </a> operations contributes data to the rollup Region or Regions specified in this parameter.</p> <p>Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are configured for object replication can be owned by the same Amazon Web Services account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different Regions or within the same Region as the source bucket.</p>', 'DeleteDataLakeRequest$regions' => '<p>The list of Regions where Security Lake is enabled.</p>', 'ListDataLakeExceptionsRequest$regions' => '<p>The Amazon Web Services Regions from which exceptions are retrieved.</p>', 'ListDataLakesRequest$regions' => '<p>The list of Regions where Security Lake is enabled.</p>', 'ListLogSourcesRequest$regions' => '<p>The list of Regions for which log sources are displayed.</p>', ], ], 'RegisterDataLakeDelegatedAdministratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDataLakeDelegatedAdministratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourceShareArn' => [ 'base' => NULL, 'refs' => [ 'SubscriberResource$resourceShareArn' => '<p>The Amazon Resource Name (ARN) which uniquely defines the Amazon Web Services RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.</p> <p>This field is available only for Lake Formation subscribers created after March 8, 2023.</p>', ], ], 'ResourceShareName' => [ 'base' => NULL, 'refs' => [ 'SubscriberResource$resourceShareName' => '<p>The name of the resource share.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeRequest$metaStoreManagerRoleArn' => '<p>The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.</p>', 'CustomLogSourceCrawlerConfiguration$roleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be used by the Glue crawler. The recommended IAM policies are:</p> <ul> <li> <p>The managed policy <code>AWSGlueServiceRole</code> </p> </li> <li> <p>A custom policy granting access to your Amazon S3 Data Lake</p> </li> </ul>', 'CustomLogSourceProvider$roleArn' => '<p>The ARN of the IAM role to be used by the entity putting logs into your custom source partition. Security Lake will apply the correct access policies to this role, but you must first manually create the trust policy for this role. The IAM role name must start with the text \'Security Lake\'. The IAM role must trust the <code>logProviderAccountId</code> to assume the role.</p>', 'DataLakeReplicationConfiguration$roleArn' => '<p>Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.</p>', 'HttpsNotificationConfiguration$targetRoleArn' => '<p>The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html">Managing data access</a> and <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html">Amazon Web Services Managed Policies</a> in the <i>Amazon Security Lake User Guide</i>.</p>', 'SubscriberResource$roleArn' => '<p>The Amazon Resource Name (ARN) specifying the role of the subscriber.</p>', 'UpdateDataLakeRequest$metaStoreManagerRoleArn' => '<p>The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.</p>', ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'DataLakeResource$s3BucketArn' => '<p>The ARN for the Amazon Security Lake Amazon S3 bucket.</p>', 'SubscriberResource$s3BucketArn' => '<p>The ARN for the Amazon S3 bucket.</p>', ], ], 'S3URI' => [ 'base' => '<p>A complete S3 URI pointing to a valid S3 object.</p>', 'refs' => [ 'CustomLogSourceProvider$location' => '<p>The location of the partition in the Amazon S3 bucket for Security Lake.</p>', ], ], 'SafeString' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeExceptionSubscriptionRequest$notificationEndpoint' => '<p>The Amazon Web Services account where you want to receive exception notifications.</p>', 'CreateSubscriberNotificationResponse$subscriberEndpoint' => '<p>The subscriber endpoint to which exception messages are posted.</p>', 'DataLakeException$exception' => '<p>The underlying exception of a Security Lake exception.</p>', 'DataLakeException$remediation' => '<p>List of all remediation steps for a Security Lake exception.</p>', 'GetDataLakeExceptionSubscriptionResponse$notificationEndpoint' => '<p>The Amazon Web Services account where you receive exception notifications.</p>', 'RegisterDataLakeDelegatedAdministratorRequest$accountId' => '<p>The Amazon Web Services account ID of the Security Lake delegated administrator.</p>', 'SubscriberResource$subscriberDescription' => '<p>The subscriber descriptions for a subscriber account. The description for a subscriber includes <code>subscriberName</code>, <code>accountID</code>, <code>externalID</code>, and <code>subscriberId</code>.</p>', 'SubscriberResource$subscriberEndpoint' => '<p>The subscriber endpoint to which exception messages are posted.</p>', 'SubscriberResource$subscriberName' => '<p>The name of your Amazon Security Lake subscriber account.</p>', 'UpdateDataLakeExceptionSubscriptionRequest$notificationEndpoint' => '<p>The account that is subscribed to receive exception notifications.</p>', 'UpdateSubscriberNotificationResponse$subscriberEndpoint' => '<p>The subscriber endpoint to which exception messages are posted.</p>', ], ], 'SourceCollectionStatus' => [ 'base' => NULL, 'refs' => [ 'DataLakeSourceStatus$status' => '<p>The health status of services, including error codes and patterns.</p>', ], ], 'SqsNotificationConfiguration' => [ 'base' => '<p>The configurations for SQS subscriber notification.</p>', 'refs' => [ 'NotificationConfiguration$sqsNotificationConfiguration' => '<p>The configurations for SQS subscriber notification.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$errorCode' => '<p>A coded string to provide more information about the access denied exception. You can use the error code to check the exception type.</p>', 'AccessDeniedException$message' => NULL, 'BadRequestException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceName' => '<p>The resource name.</p>', 'ConflictException$resourceType' => '<p>The resource type.</p>', 'DataLakeEncryptionConfiguration$kmsKeyId' => '<p>The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.</p>', 'DataLakeSource$account' => '<p>The ID of the Security Lake account for which logs are collected.</p>', 'DataLakeSource$sourceName' => '<p>The supported Amazon Web Services from which logs and events are collected. Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.</p>', 'DataLakeSourceStatus$resource' => '<p>Defines path the stored logs are available which has information on your systems, applications, and services.</p>', 'DataLakeUpdateException$code' => '<p>The reason code for the exception of the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.</p>', 'DataLakeUpdateException$reason' => '<p>The reason for the exception of the last <code>UpdateDataLake</code>or <code>DeleteDataLake</code> API request.</p>', 'DataLakeUpdateStatus$requestId' => '<p>The unique ID for the last <code>UpdateDataLake</code> or <code>DeleteDataLake</code> API request.</p>', 'HttpsNotificationConfiguration$authorizationApiKeyName' => '<p>The key name for the notification subscription.</p>', 'HttpsNotificationConfiguration$authorizationApiKeyValue' => '<p>The key value for the notification subscription.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceName' => '<p>The name of the resource that could not be found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that could not be found.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>That the rate of requests to Security Lake is exceeding the request quotas for your Amazon Web Services account.</p>', 'ThrottlingException$serviceCode' => '<p>The code for the service in Service Quotas.</p>', ], ], 'SubscriberResource' => [ 'base' => '<p>Provides details about the Amazon Security Lake account subscription. Subscribers are notified of new objects for a source as the data is written to your Amazon S3 bucket for Security Lake.</p>', 'refs' => [ 'CreateSubscriberResponse$subscriber' => '<p>Retrieve information about the subscriber created using the <code>CreateSubscriber</code> API.</p>', 'GetSubscriberResponse$subscriber' => '<p>The subscriber information for the specified subscriber ID.</p>', 'SubscriberResourceList$member' => NULL, 'UpdateSubscriberResponse$subscriber' => '<p>The updated subscriber information.</p>', ], ], 'SubscriberResourceList' => [ 'base' => NULL, 'refs' => [ 'ListSubscribersResponse$subscribers' => '<p>The subscribers available for the specified Security Lake account ID.</p>', ], ], 'SubscriberStatus' => [ 'base' => NULL, 'refs' => [ 'SubscriberResource$subscriberStatus' => '<p>The subscriber status of the Amazon Security Lake subscriber account.</p>', ], ], 'SubscriptionProtocol' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeExceptionSubscriptionRequest$subscriptionProtocol' => '<p>The subscription protocol to which exception notifications are posted.</p>', 'GetDataLakeExceptionSubscriptionResponse$subscriptionProtocol' => '<p>The subscription protocol to which exception notifications are posted.</p>', 'UpdateDataLakeExceptionSubscriptionRequest$subscriptionProtocol' => '<p>The subscription protocol to which exception messages are posted.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'DataLakeException$timestamp' => '<p>This error can occur if you configure the wrong timestamp format, or if the subset of entries used for validation had errors or missing values.</p>', 'SubscriberResource$createdAt' => '<p>The date and time when the subscriber was created.</p>', 'SubscriberResource$updatedAt' => '<p>The date and time when the subscriber was last updated.</p>', ], ], 'Tag' => [ 'base' => '<p>A <i>tag</i> is a label that you can define and associate with Amazon Web Services resources, including certain types of Amazon Security Lake resources. Tags can help you identify, categorize, and manage resources in different ways, such as by owner, environment, or other criteria. You can associate tags with the following types of Security Lake resources: subscribers, and the data lake configuration for your Amazon Web Services account in individual Amazon Web Services Regions.</p> <p>A resource can have up to 50 tags. Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>. A <i>tag key</i> is a general label that acts as a category for a more specific tag value. Each tag key must be unique and it can have only one tag value. A <i>tag value</i> acts as a descriptor for a tag key. Tag keys and values are case sensitive. They can contain letters, numbers, spaces, or the following symbols: _ . : / = + @ -</p> <p>For more information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html">Tagging Amazon Security Lake resources</a> in the <i>Amazon Security Lake User Guide</i>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The name of the tag. This is a general label that acts as a category for a more specific tag value (<code>value</code>).</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of one or more tag keys. For each value in the list, specify the tag key for a tag to remove from the Amazon Security Lake resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDataLakeRequest$tags' => '<p>An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.</p>', 'CreateSubscriberRequest$tags' => '<p>An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.</p>', 'ListTagsForResourceResponse$tags' => '<p>An array of objects, one for each tag (key and value) that’s associated with the Amazon Security Lake resource.</p>', 'TagResourceRequest$tags' => '<p>An array of objects, one for each tag (key and value) to associate with the Amazon Security Lake resource. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value that’s associated with the specified tag key (<code>key</code>). This value acts as a descriptor for the tag key. A tag value cannot be null, but it can be an empty string.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriberNotificationRequest$subscriberId' => '<p>The subscriber ID for the notification subscription.</p>', 'DeleteSubscriberNotificationRequest$subscriberId' => '<p>The ID of the Security Lake subscriber account.</p>', 'DeleteSubscriberRequest$subscriberId' => '<p>A value created by Security Lake that uniquely identifies your <code>DeleteSubscriber</code> API request.</p>', 'GetSubscriberRequest$subscriberId' => '<p>A value created by Amazon Security Lake that uniquely identifies your <code>GetSubscriber</code> API request.</p>', 'SubscriberResource$subscriberId' => '<p>The subscriber ID of the Amazon Security Lake subscriber account.</p>', 'UpdateSubscriberNotificationRequest$subscriberId' => '<p>The subscription ID for which the subscription notification is specified.</p>', 'UpdateSubscriberRequest$subscriberId' => '<p>A value created by Security Lake that uniquely identifies your subscription.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataLakeExceptionSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong' => [ 'base' => NULL, 'refs' => [ 'UpdateDataLakeExceptionSubscriptionRequest$exceptionTimeToLive' => '<p>The time-to-live (TTL) for the exception message to remain.</p>', ], ], 'UpdateDataLakeExceptionSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataLakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataLakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriberNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriberNotificationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriberRequestSubscriberNameString' => [ 'base' => NULL, 'refs' => [ 'UpdateSubscriberRequest$subscriberName' => '<p>The name of the Security Lake account subscriber.</p>', ], ], 'UpdateSubscriberResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
