<?php
// This file was auto-generated from sdk-root/src/data/simspaceweaver/2022-10-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>SimSpace Weaver (SimSpace Weaver) is a service that you can use to build and run large-scale spatial simulations in the Amazon Web Services Cloud. For example, you can create crowd simulations, large real-world environments, and immersive and interactive experiences. For more information about SimSpace Weaver, see the <i> <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/">SimSpace Weaver User Guide</a> </i>.</p> <p>This API reference describes the API operations and data types that you can use to communicate directly with SimSpace Weaver.</p> <p>SimSpace Weaver also provides the SimSpace Weaver app SDK, which you use for app development. The SimSpace Weaver app SDK API reference is included in the SimSpace Weaver app SDK documentation. This documentation is part of the SimSpace Weaver app SDK distributable package.</p>', 'operations' => [ 'CreateSnapshot' => '<p>Creates a snapshot of the specified simulation. A snapshot is a file that contains simulation state data at a specific time. The state data saved in a snapshot includes entity data from the State Fabric, the simulation configuration specified in the schema, and the clock tick number. You can use the snapshot to initialize a new simulation. For more information about snapshots, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in the <i>SimSpace Weaver User Guide</i>. </p> <p>You specify a <code>Destination</code> when you create a snapshot. The <code>Destination</code> is the name of an Amazon S3 bucket and an optional <code>ObjectKeyPrefix</code>. The <code>ObjectKeyPrefix</code> is usually the name of a folder in the bucket. SimSpace Weaver creates a <code>snapshot</code> folder inside the <code>Destination</code> and places the snapshot file there.</p> <p>The snapshot file is an Amazon S3 object. It has an object key with the form: <code> <i>object-key-prefix</i>/snapshot/<i>simulation-name</i>-<i>YYMMdd</i>-<i>HHmm</i>-<i>ss</i>.zip</code>, where: </p> <ul> <li> <p> <code> <i>YY</i> </code> is the 2-digit year</p> </li> <li> <p> <code> <i>MM</i> </code> is the 2-digit month</p> </li> <li> <p> <code> <i>dd</i> </code> is the 2-digit day of the month</p> </li> <li> <p> <code> <i>HH</i> </code> is the 2-digit hour (24-hour clock)</p> </li> <li> <p> <code> <i>mm</i> </code> is the 2-digit minutes</p> </li> <li> <p> <code> <i>ss</i> </code> is the 2-digit seconds</p> </li> </ul>', 'DeleteApp' => '<p>Deletes the instance of the given custom app.</p>', 'DeleteSimulation' => '<p>Deletes all SimSpace Weaver resources assigned to the given simulation.</p> <note> <p>Your simulation uses resources in other Amazon Web Services. This API operation doesn\'t delete resources in other Amazon Web Services.</p> </note>', 'DescribeApp' => '<p>Returns the state of the given custom app.</p>', 'DescribeSimulation' => '<p>Returns the current state of the given simulation.</p>', 'ListApps' => '<p>Lists all custom apps or service apps for the given simulation and domain.</p>', 'ListSimulations' => '<p>Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.</p>', 'ListTagsForResource' => '<p>Lists all tags on a SimSpace Weaver resource.</p>', 'StartApp' => '<p>Starts a custom app with the configuration specified in the simulation schema.</p>', 'StartClock' => '<p>Starts the simulation clock.</p>', 'StartSimulation' => '<p>Starts a simulation with the given name. You must choose to start your simulation from a schema or from a snapshot. For more information about the schema, see the <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html">schema reference</a> in the <i>SimSpace Weaver User Guide</i>. For more information about snapshots, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in the <i>SimSpace Weaver User Guide</i>.</p>', 'StopApp' => '<p>Stops the given custom app and shuts down all of its allocated compute resources.</p>', 'StopClock' => '<p>Stops the simulation clock.</p>', 'StopSimulation' => '<p>Stops the given simulation.</p> <important> <p>You can\'t restart a simulation after you stop it. If you want to restart a simulation, then you must stop it, delete it, and start a new instance of it.</p> </important>', 'TagResource' => '<p>Adds tags to a SimSpace Weaver resource. For more information about tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResource' => '<p>Removes tags from a SimSpace Weaver resource. For more information about tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'AppPortMappings' => [ 'base' => NULL, 'refs' => [ 'SimulationAppEndpointInfo$IngressPortMappings' => '<p>The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a network endpoint.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Destination$BucketName' => '<p>The name of an Amazon S3 bucket. For more information about buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'S3Location$BucketName' => '<p>The name of an Amazon S3 bucket. For more information about buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'StartAppInput$ClientToken' => '<p>A value that you provide to ensure that repeated calls to this API operation using the same parameters complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A <code>ClientToken</code> expires after 24 hours.</p>', 'StartSimulationInput$ClientToken' => '<p>A value that you provide to ensure that repeated calls to this API operation using the same parameters complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A <code>ClientToken</code> expires after 24 hours.</p>', ], ], 'ClockStatus' => [ 'base' => NULL, 'refs' => [ 'SimulationClock$Status' => '<p>The current status of the simulation clock.</p>', ], ], 'ClockTargetStatus' => [ 'base' => NULL, 'refs' => [ 'SimulationClock$TargetStatus' => '<p>The desired status of the simulation clock.</p>', ], ], 'CloudWatchLogsLogGroup' => [ 'base' => '<p>The Amazon CloudWatch Logs log group for the simulation. For more information about log groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with log groups and log streams</a> in the <i>Amazon CloudWatch Logs User Guide</i>.</p>', 'refs' => [ 'LogDestination$CloudWatchLogsLogGroup' => '<p>An Amazon CloudWatch Logs log group that stores simulation log data. For more information about log groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with log groups and log streams</a> in the <i>Amazon CloudWatch Logs User Guide</i>.</p>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateSnapshotInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSimulationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSimulationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'DescribeAppOutput$Description' => '<p>The description of the app.</p>', 'DescribeSimulationOutput$Description' => '<p>The description of the simulation.</p>', 'StartAppInput$Description' => '<p>The description of the app.</p>', 'StartSimulationInput$Description' => '<p>The description of the simulation.</p>', ], ], 'Domain' => [ 'base' => '<p>A collection of app instances that run the same executable app code and have the same launch options and commands.</p> <p>For more information about domains, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains">Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.</p>', 'refs' => [ 'DomainList$member' => NULL, ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'LiveSimulationState$Domains' => '<p>A list of domains for the simulation. For more information about domains, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains">Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.</p>', ], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'LaunchCommandList' => [ 'base' => NULL, 'refs' => [ 'LaunchOverrides$LaunchCommands' => '<p>App launch commands and command line parameters that override the launch command configured in the simulation schema.</p>', ], ], 'LaunchOverrides' => [ 'base' => '<p>Options that apply when the app starts. These options override default behavior.</p>', 'refs' => [ 'DescribeAppOutput$LaunchOverrides' => NULL, 'StartAppInput$LaunchOverrides' => NULL, ], ], 'LifecycleManagementStrategy' => [ 'base' => NULL, 'refs' => [ 'Domain$Lifecycle' => '<p>The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are <i>managed</i> (SimSpace Weaver starts and stops the apps) or <i>unmanaged</i> (you must start and stop the apps).</p> <p class="title"> <b>Lifecycle types</b> </p> <ul> <li> <p> <code>PerWorker</code> – Managed: SimSpace Weaver starts one app on each worker.</p> </li> <li> <p> <code>BySpatialSubdivision</code> – Managed: SimSpace Weaver starts one app for each spatial partition.</p> </li> <li> <p> <code>ByRequest</code> – Unmanaged: You use the <code>StartApp</code> API to start the apps and use the <code>StopApp</code> API to stop the apps.</p> </li> </ul>', ], ], 'ListAppsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LiveSimulationState' => [ 'base' => '<p>A collection of additional state information, such as domain and clock configuration.</p>', 'refs' => [ 'DescribeSimulationOutput$LiveSimulationState' => '<p>A collection of additional state information, such as domain and clock configuration.</p>', ], ], 'LogDestination' => [ 'base' => '<p>The location where SimSpace Weaver sends simulation log data.</p>', 'refs' => [ 'LogDestinations$member' => NULL, ], ], 'LogDestinations' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$Destinations' => '<p>A list of the locations where SimSpace Weaver sends simulation log data.</p>', ], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsLogGroup$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log group for the simulation. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about log groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with log groups and log streams</a> in the <i>Amazon CloudWatch Logs User Guide</i>.</p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>The logging configuration for a simulation.</p>', 'refs' => [ 'DescribeSimulationOutput$LoggingConfiguration' => '<p>Settings that control how SimSpace Weaver handles your simulation log data.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'LaunchCommandList$member' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'SimulationAppEndpointInfo$Address' => '<p>The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.</p>', 'TooManyTagsException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ObjectKey' => [ 'base' => NULL, 'refs' => [ 'S3Location$ObjectKey' => '<p>The key name of an object in Amazon S3. For more information about Amazon S3 objects and object keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html">Uploading, downloading, and working with objects in Amazon S3</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', ], ], 'ObjectKeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Destination$ObjectKeyPrefix' => '<p>A string prefix for an Amazon S3 object key. It\'s usually a folder name. For more information about folders in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">Organizing objects in the Amazon S3 console using folders</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', ], ], 'OptionalString' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$SchemaError' => '<p>An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.</p>', 'DescribeSimulationOutput$StartError' => '<p>An error message that SimSpace Weaver returns only if a problem occurs when the simulation is in the <code>STARTING</code> state.</p>', 'ListAppsInput$NextToken' => '<p>If SimSpace Weaver returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an <i>HTTP 400 ValidationException</i> error.</p>', 'ListAppsOutput$NextToken' => '<p>If SimSpace Weaver returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an <i>HTTP 400 ValidationException</i> error.</p>', 'ListSimulationsInput$NextToken' => '<p>If SimSpace Weaver returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an <i>HTTP 400 ValidationException</i> error.</p>', 'ListSimulationsOutput$NextToken' => '<p>If SimSpace Weaver returns <code>nextToken</code>, then there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn\'t valid, then you receive an <i>HTTP 400 ValidationException</i> error.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'SimulationAppPortMapping$Actual' => '<p>The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns this port number when the app starts. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port. Clients connect to the app using the app\'s IP address and the <code>Actual</code> port number.</p>', 'SimulationAppPortMapping$Declared' => '<p>The TCP/UDP port number of the app, declared in the simulation schema. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port. The source code for the app should bind to the <code>Declared</code> port.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'ListAppsInput$MaxResults' => '<p>The maximum number of apps to list.</p>', 'ListSimulationsInput$MaxResults' => '<p>The maximum number of simulations to list.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and Access Management User Guide</i>.</p>', 'StartSimulationInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and Access Management User Guide</i>.</p>', ], ], 'S3Destination' => [ 'base' => '<p>An Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates a file.</p>', 'refs' => [ 'CreateSnapshotInput$Destination' => '<p>The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the snapshot file.</p> <p>The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.</p>', ], ], 'S3Location' => [ 'base' => '<p>A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver stores simulation data, such as your app .zip files and schema file. For more information about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage Service User Guide</i> </a>.</p>', 'refs' => [ 'DescribeSimulationOutput$SchemaS3Location' => '<p>The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage Service User Guide</i> </a>.</p>', 'DescribeSimulationOutput$SnapshotS3Location' => NULL, 'StartSimulationInput$SchemaS3Location' => '<p>The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage Service User Guide</i> </a>.</p> <p>Provide a <code>SchemaS3Location</code> to start your simulation from a schema.</p> <p>If you provide a <code>SchemaS3Location</code> then you can\'t provide a <code>SnapshotS3Location</code>.</p>', 'StartSimulationInput$SnapshotS3Location' => '<p>The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage Service User Guide</i> </a>.</p> <p>Provide a <code>SnapshotS3Location</code> to start your simulation from a snapshot.</p> <p>The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.</p> <p>If you provide a <code>SnapshotS3Location</code> then you can\'t provide a <code>SchemaS3Location</code>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'SimSpaceWeaverArn' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'SimulationMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'StartSimulationOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add tags to. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'SimSpaceWeaverLongResourceName' => [ 'base' => NULL, 'refs' => [ 'DescribeAppInput$App' => '<p>The name of the app.</p>', 'DescribeAppOutput$Name' => '<p>The name of the app.</p>', 'SimulationAppMetadata$Name' => '<p>The name of the app.</p>', ], ], 'SimSpaceWeaverResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotInput$Simulation' => '<p>The name of the simulation.</p>', 'DeleteAppInput$App' => '<p>The name of the app.</p>', 'DeleteAppInput$Domain' => '<p>The name of the domain of the app.</p>', 'DeleteAppInput$Simulation' => '<p>The name of the simulation of the app.</p>', 'DeleteSimulationInput$Simulation' => '<p>The name of the simulation.</p>', 'DescribeAppInput$Domain' => '<p>The name of the domain of the app.</p>', 'DescribeAppInput$Simulation' => '<p>The name of the simulation of the app.</p>', 'DescribeAppOutput$Domain' => '<p>The name of the domain of the app.</p>', 'DescribeAppOutput$Simulation' => '<p>The name of the simulation of the app.</p>', 'DescribeSimulationInput$Simulation' => '<p>The name of the simulation.</p>', 'DescribeSimulationOutput$Name' => '<p>The name of the simulation.</p>', 'Domain$Name' => '<p>The name of the domain.</p>', 'ListAppsInput$Domain' => '<p>The name of the domain that you want to list apps for.</p>', 'ListAppsInput$Simulation' => '<p>The name of the simulation that you want to list apps for.</p>', 'SimulationAppMetadata$Domain' => '<p>The domain of the app. For more information about domains, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains">Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.</p>', 'SimulationAppMetadata$Simulation' => '<p>The name of the simulation of the app.</p>', 'SimulationMetadata$Name' => '<p>The name of the simulation.</p>', 'StartAppInput$Domain' => '<p>The name of the domain of the app.</p>', 'StartAppInput$Name' => '<p>The name of the app.</p>', 'StartAppInput$Simulation' => '<p>The name of the simulation of the app.</p>', 'StartAppOutput$Domain' => '<p>The name of the domain of the app.</p>', 'StartAppOutput$Name' => '<p>The name of the app.</p>', 'StartAppOutput$Simulation' => '<p>The name of the simulation of the app.</p>', 'StartClockInput$Simulation' => '<p>The name of the simulation.</p>', 'StartSimulationInput$Name' => '<p>The name of the simulation.</p>', 'StopAppInput$App' => '<p>The name of the app.</p>', 'StopAppInput$Domain' => '<p>The name of the domain of the app.</p>', 'StopAppInput$Simulation' => '<p>The name of the simulation of the app.</p>', 'StopClockInput$Simulation' => '<p>The name of the simulation.</p>', 'StopSimulationInput$Simulation' => '<p>The name of the simulation.</p>', ], ], 'SimulationAppEndpointInfo' => [ 'base' => '<p>Information about the network endpoint that you can use to connect to your custom or service app. For more information about SimSpace Weaver apps, see <a href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_apps">Key concepts: Apps</a> in the <i>SimSpace Weaver User Guide</i>..</p>', 'refs' => [ 'DescribeAppOutput$EndpointInfo' => '<p>Information about the network endpoint for the custom app. You can use the endpoint to connect to the custom app.</p>', ], ], 'SimulationAppList' => [ 'base' => NULL, 'refs' => [ 'ListAppsOutput$Apps' => '<p>The list of apps for the given simulation and domain.</p>', ], ], 'SimulationAppMetadata' => [ 'base' => '<p>A collection of metadata about the app.</p>', 'refs' => [ 'SimulationAppList$member' => NULL, ], ], 'SimulationAppPortMapping' => [ 'base' => '<p>A collection of TCP/UDP ports for a custom or service app.</p>', 'refs' => [ 'AppPortMappings$member' => NULL, ], ], 'SimulationAppStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeAppOutput$Status' => '<p>The current lifecycle state of the custom app.</p>', 'SimulationAppMetadata$Status' => '<p>The current status of the app.</p>', ], ], 'SimulationAppTargetStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeAppOutput$TargetStatus' => '<p>The desired lifecycle state of the custom app.</p>', 'SimulationAppMetadata$TargetStatus' => '<p>The desired status of the app.</p>', ], ], 'SimulationClock' => [ 'base' => '<p>Status information about the simulation clock.</p>', 'refs' => [ 'SimulationClockList$member' => NULL, ], ], 'SimulationClockList' => [ 'base' => NULL, 'refs' => [ 'LiveSimulationState$Clocks' => '<p>A list of simulation clocks.</p> <note> <p>At this time, a simulation has only one clock.</p> </note>', ], ], 'SimulationList' => [ 'base' => NULL, 'refs' => [ 'ListSimulationsOutput$Simulations' => '<p>The list of simulations.</p>', ], ], 'SimulationMetadata' => [ 'base' => '<p>A collection of data about the simulation.</p>', 'refs' => [ 'SimulationList$member' => NULL, ], ], 'SimulationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$Status' => '<p>The current lifecycle state of the simulation.</p>', 'SimulationMetadata$Status' => '<p>The current status of the simulation.</p>', ], ], 'SimulationTargetStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$TargetStatus' => '<p>The desired lifecycle state of the simulation.</p>', 'SimulationMetadata$TargetStatus' => '<p>The desired status of the simulation.</p>', ], ], 'StartAppInput' => [ 'base' => NULL, 'refs' => [], ], 'StartAppOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartClockInput' => [ 'base' => NULL, 'refs' => [], ], 'StartClockOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartSimulationInput' => [ 'base' => NULL, 'refs' => [], ], 'StartSimulationOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopAppInput' => [ 'base' => NULL, 'refs' => [], ], 'StopAppOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopClockInput' => [ 'base' => NULL, 'refs' => [], ], 'StopClockOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopSimulationInput' => [ 'base' => NULL, 'refs' => [], ], 'StopSimulationOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A list of tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceOutput$Tags' => '<p>The list of tags for the resource.</p>', 'StartSimulationInput$Tags' => '<p>A list of tags for the simulation. For more information about tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'TagResourceInput$Tags' => '<p>A list of tags to apply to the resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TimeToLiveString' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$MaximumDuration' => '<p>The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is <code>14D</code>, or its equivalent in the other units. The default value is <code>14D</code>. A value equivalent to <code>0</code> makes the simulation immediately transition to <code>Stopping</code> as soon as it reaches <code>Started</code>.</p>', 'StartSimulationInput$MaximumDuration' => '<p>The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is <code>14D</code>, or its equivalent in the other units. The default value is <code>14D</code>. A value equivalent to <code>0</code> makes the simulation immediately transition to <code>Stopping</code> as soon as it reaches <code>Started</code>.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$CreationTime' => '<p>The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).</p>', 'SimulationMetadata$CreationTime' => '<p>The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).</p>', 'StartSimulationOutput$CreationTime' => '<p>The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p/>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationOutput$ExecutionId' => '<p>A universally unique identifier (UUID) for this simulation.</p>', 'StartSimulationOutput$ExecutionId' => '<p>A universally unique identifier (UUID) for this simulation.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], ],];
