<?php
// This file was auto-generated from sdk-root/src/data/ssm-contacts/2021-05-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or reduction in quality of services.</p> <p>Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables responder team escalation.</p>', 'operations' => [ 'AcceptPage' => '<p>Used to acknowledge an engagement to a contact channel during an incident.</p>', 'ActivateContactChannel' => '<p>Activates a contact\'s contact channel. Incident Manager can\'t engage a contact until the contact channel has been activated.</p>', 'CreateContact' => '<p>Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.</p>', 'CreateContactChannel' => '<p>A contact channel is the method that Incident Manager uses to engage your contact.</p>', 'CreateRotation' => '<p>Creates a rotation in an on-call schedule.</p>', 'CreateRotationOverride' => '<p>Creates an override for a rotation in an on-call schedule.</p>', 'DeactivateContactChannel' => '<p>To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.</p>', 'DeleteContact' => '<p>To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.</p>', 'DeleteContactChannel' => '<p>To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact\'s engagement plan. If you delete the only contact channel for a contact, you won\'t be able to engage that contact during an incident.</p>', 'DeleteRotation' => '<p>Deletes a rotation from the system. If a rotation belongs to more than one on-call schedule, this operation deletes it from all of them.</p>', 'DeleteRotationOverride' => '<p>Deletes an existing override for an on-call rotation.</p>', 'DescribeEngagement' => '<p>Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.</p>', 'DescribePage' => '<p>Lists details of the engagement to a contact channel.</p>', 'GetContact' => '<p>Retrieves information about the specified contact or escalation plan.</p>', 'GetContactChannel' => '<p>List details about a specific contact channel.</p>', 'GetContactPolicy' => '<p>Retrieves the resource policies attached to the specified contact or escalation plan.</p>', 'GetRotation' => '<p>Retrieves information about an on-call rotation.</p>', 'GetRotationOverride' => '<p>Retrieves information about an override to an on-call rotation.</p>', 'ListContactChannels' => '<p>Lists all contact channels for the specified contact.</p>', 'ListContacts' => '<p>Lists all contacts and escalation plans in Incident Manager.</p>', 'ListEngagements' => '<p>Lists all engagements that have happened in an incident.</p>', 'ListPageReceipts' => '<p>Lists all of the engagements to contact channels that have been acknowledged.</p>', 'ListPageResolutions' => '<p>Returns the resolution path of an engagement. For example, the escalation plan engaged in an incident might target an on-call schedule that includes several contacts in a rotation, but just one contact on-call when the incident starts. The resolution path indicates the hierarchy of <i>escalation plan &gt; on-call schedule &gt; contact</i>.</p>', 'ListPagesByContact' => '<p>Lists the engagements to a contact\'s contact channels.</p>', 'ListPagesByEngagement' => '<p>Lists the engagements to contact channels that occurred by engaging a contact.</p>', 'ListPreviewRotationShifts' => '<p>Returns a list of shifts based on rotation configuration parameters.</p> <note> <p>The Incident Manager primarily uses this operation to populate the <b>Preview</b> calendar. It is not typically run by end users.</p> </note>', 'ListRotationOverrides' => '<p>Retrieves a list of overrides currently specified for an on-call rotation.</p>', 'ListRotationShifts' => '<p>Returns a list of shifts generated by an existing rotation in the system.</p>', 'ListRotations' => '<p>Retrieves a list of on-call rotations.</p>', 'ListTagsForResource' => '<p>Lists the tags of an escalation plan or contact.</p>', 'PutContactPolicy' => '<p>Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html">Setting up cross-account functionality</a>.</p>', 'SendActivationCode' => '<p>Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the <code>ActivateChannel</code> operation. Incident Manager can\'t engage a contact channel until it has been activated.</p>', 'StartEngagement' => '<p>Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.</p>', 'StopEngagement' => '<p>Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren\'t engaged.</p>', 'TagResource' => '<p>Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.</p>', 'UntagResource' => '<p>Removes tags from the specified resource.</p>', 'UpdateContact' => '<p>Updates the contact or escalation plan specified.</p>', 'UpdateContactChannel' => '<p>Updates a contact\'s contact channel.</p>', 'UpdateRotation' => '<p>Updates the information specified for an on-call rotation.</p>', ], 'shapes' => [ 'AcceptCode' => [ 'base' => NULL, 'refs' => [ 'AcceptPageRequest$AcceptCode' => '<p>A 6-digit code used to acknowledge the page.</p>', ], ], 'AcceptCodeValidation' => [ 'base' => NULL, 'refs' => [ 'AcceptPageRequest$AcceptCodeValidation' => '<p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p> <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>', ], ], 'AcceptPageRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptPageResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptType' => [ 'base' => NULL, 'refs' => [ 'AcceptPageRequest$AcceptType' => '<p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient access to perform this operation.</p>', 'refs' => [], ], 'ActivateContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'ActivateContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'ActivationCode' => [ 'base' => NULL, 'refs' => [ 'ActivateContactChannelRequest$ActivationCode' => '<p>The code sent to the contact channel when it was created in the contact.</p>', ], ], 'ActivationStatus' => [ 'base' => NULL, 'refs' => [ 'ContactChannel$ActivationStatus' => '<p>A Boolean value describing if the contact channel has been activated or not. If the contact channel isn\'t activated, Incident Manager can\'t engage the contact through it.</p>', 'GetContactChannelResult$ActivationStatus' => '<p>A Boolean value indicating if the contact channel has been activated or not.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'ContactChannel$Name' => '<p>The name of the contact channel.</p>', 'CreateContactChannelRequest$Name' => '<p>The name of the contact channel.</p>', 'GetContactChannelResult$Name' => '<p>The name of the contact channel</p>', 'UpdateContactChannelRequest$Name' => '<p>The name of the contact channel.</p>', ], ], 'ChannelTargetInfo' => [ 'base' => '<p>Information about the contact channel that Incident Manager uses to engage the contact.</p>', 'refs' => [ 'Target$ChannelTargetInfo' => '<p>Information about the contact channel Incident Manager is engaging.</p>', ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'ContactChannel$Type' => '<p>The type of the contact channel. Incident Manager supports three contact methods:</p> <ul> <li> <p>SMS</p> </li> <li> <p>VOICE</p> </li> <li> <p>EMAIL</p> </li> </ul>', 'CreateContactChannelRequest$Type' => '<p>Incident Manager supports three types of contact channels:</p> <ul> <li> <p> <code>SMS</code> </p> </li> <li> <p> <code>VOICE</code> </p> </li> <li> <p> <code>EMAIL</code> </p> </li> </ul>', 'GetContactChannelResult$Type' => '<p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource causes an inconsistent state.</p>', 'refs' => [], ], 'Contact' => [ 'base' => '<p>A personal contact or escalation plan that Incident Manager engages during an incident.</p>', 'refs' => [ 'ContactsList$member' => NULL, ], ], 'ContactAlias' => [ 'base' => NULL, 'refs' => [ 'Contact$Alias' => '<p>The unique and identifiable alias of the contact or escalation plan.</p>', 'CreateContactRequest$Alias' => '<p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable.</p>', 'GetContactResult$Alias' => '<p>The alias of the contact or escalation plan. The alias is unique and identifiable.</p>', 'ListContactsRequest$AliasPrefix' => '<p>Used to list only contacts who\'s aliases start with the specified prefix.</p>', ], ], 'ContactChannel' => [ 'base' => '<p>The method that Incident Manager uses to engage a contact.</p>', 'refs' => [ 'ContactChannelList$member' => NULL, ], ], 'ContactChannelAddress' => [ 'base' => '<p>The details that Incident Manager uses when trying to engage the contact channel.</p>', 'refs' => [ 'ContactChannel$DeliveryAddress' => '<p>The details that Incident Manager uses when trying to engage the contact channel.</p>', 'CreateContactChannelRequest$DeliveryAddress' => '<p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p> <ul> <li> <p>SMS - \'+\' followed by the country code and phone number</p> </li> <li> <p>VOICE - \'+\' followed by the country code and phone number</p> </li> <li> <p>EMAIL - any standard email format</p> </li> </ul>', 'GetContactChannelResult$DeliveryAddress' => '<p>The details that Incident Manager uses when trying to engage the contact channel.</p>', 'UpdateContactChannelRequest$DeliveryAddress' => '<p>The details that Incident Manager uses when trying to engage the contact channel.</p>', ], ], 'ContactChannelList' => [ 'base' => NULL, 'refs' => [ 'ListContactChannelsResult$ContactChannels' => '<p>A list of contact channels related to the specified contact.</p>', ], ], 'ContactName' => [ 'base' => NULL, 'refs' => [ 'Contact$DisplayName' => '<p>The full name of the contact or escalation plan.</p>', 'CreateContactRequest$DisplayName' => '<p>The full name of the contact or escalation plan.</p>', 'GetContactResult$DisplayName' => '<p>The full name of the contact or escalation plan.</p>', 'UpdateContactRequest$DisplayName' => '<p>The full name of the contact or escalation plan.</p>', ], ], 'ContactTargetInfo' => [ 'base' => '<p>The contact that Incident Manager is engaging during an incident.</p>', 'refs' => [ 'Target$ContactTargetInfo' => '<p>Information about the contact that Incident Manager is engaging.</p>', ], ], 'ContactType' => [ 'base' => NULL, 'refs' => [ 'Contact$Type' => '<p>Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>', 'CreateContactRequest$Type' => '<p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>', 'GetContactResult$Type' => '<p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>.</p>', 'ListContactsRequest$Type' => '<p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>', 'ResolutionContact$Type' => '<p>The type of contact for a resolution step.</p>', ], ], 'ContactsList' => [ 'base' => NULL, 'refs' => [ 'ListContactsResult$Contacts' => '<p>A list of the contacts and escalation plans in your Incident Manager account.</p>', ], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$Content' => '<p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>', 'DescribePageResult$Content' => '<p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>', 'StartEngagementRequest$Content' => '<p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>', ], ], 'CoverageTime' => [ 'base' => '<p>Information about when an on-call shift begins and ends.</p>', 'refs' => [ 'CoverageTimes$member' => NULL, ], ], 'CoverageTimes' => [ 'base' => NULL, 'refs' => [ 'ShiftCoveragesMap$value' => NULL, ], ], 'CreateContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRotationOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRotationOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRotationResult' => [ 'base' => NULL, 'refs' => [], ], 'DailySettings' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$DailySettings' => '<p>Information about on-call rotations that recur daily.</p>', ], ], 'DataEncryptionException' => [ 'base' => '<p>The operation failed to due an encryption key error.</p>', 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'CreateRotationOverrideRequest$StartTime' => '<p>The date and time when the override goes into effect.</p>', 'CreateRotationOverrideRequest$EndTime' => '<p>The date and time when the override ends.</p>', 'CreateRotationRequest$StartTime' => '<p>The date and time that the rotation goes into effect.</p>', 'DescribeEngagementResult$StartTime' => '<p>The time that the engagement started.</p>', 'DescribeEngagementResult$StopTime' => '<p>The time that the engagement ended.</p>', 'DescribePageResult$SentTime' => '<p>The time the engagement was sent to the contact channel.</p>', 'DescribePageResult$ReadTime' => '<p>The time that the contact channel acknowledged the engagement.</p>', 'DescribePageResult$DeliveryTime' => '<p>The time that the contact channel received the engagement.</p>', 'Engagement$StartTime' => '<p>The time that the engagement began.</p>', 'Engagement$StopTime' => '<p>The time that the engagement ended.</p>', 'GetRotationOverrideResult$StartTime' => '<p>The date and time when the override goes into effect.</p>', 'GetRotationOverrideResult$EndTime' => '<p>The date and time when the override ends.</p>', 'GetRotationOverrideResult$CreateTime' => '<p>The date and time when the override was created.</p>', 'GetRotationResult$StartTime' => '<p>The specified start time for the on-call rotation.</p>', 'ListPreviewRotationShiftsRequest$RotationStartTime' => '<p>The date and time a rotation would begin. The first shift is calculated from this date and time.</p>', 'ListPreviewRotationShiftsRequest$StartTime' => '<p>Used to filter the range of calculated shifts before sending the response back to the user. </p>', 'ListPreviewRotationShiftsRequest$EndTime' => '<p>The date and time a rotation shift would end.</p>', 'ListRotationOverridesRequest$StartTime' => '<p>The date and time for the beginning of a time range for listing overrides.</p>', 'ListRotationOverridesRequest$EndTime' => '<p>The date and time for the end of a time range for listing overrides.</p>', 'ListRotationShiftsRequest$StartTime' => '<p>The date and time for the beginning of the time range to list shifts for.</p>', 'ListRotationShiftsRequest$EndTime' => '<p>The date and time for the end of the time range to list shifts for.</p>', 'Page$SentTime' => '<p>The time that Incident Manager engaged the contact channel.</p>', 'Page$DeliveryTime' => '<p>The time the message was delivered to the contact channel.</p>', 'Page$ReadTime' => '<p>The time that the contact channel acknowledged engagement.</p>', 'PreviewOverride$StartTime' => '<p>Information about the time a rotation override would begin.</p>', 'PreviewOverride$EndTime' => '<p>Information about the time a rotation override would end.</p>', 'Receipt$ReceiptTime' => '<p>The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or <code>READ</code>.</p>', 'Rotation$StartTime' => '<p>The date and time the rotation becomes active.</p>', 'RotationOverride$StartTime' => '<p>The time a rotation override begins.</p>', 'RotationOverride$EndTime' => '<p>The time a rotation override ends.</p>', 'RotationOverride$CreateTime' => '<p>The time a rotation override was created.</p>', 'RotationShift$StartTime' => '<p>The time a shift rotation begins.</p>', 'RotationShift$EndTime' => '<p>The time a shift rotation ends.</p>', 'TimeRange$StartTime' => '<p>The start of the time range.</p>', 'TimeRange$EndTime' => '<p>The end of the time range.</p>', 'UpdateRotationRequest$StartTime' => '<p>The date and time the rotation goes into effect.</p>', ], ], 'DayOfMonth' => [ 'base' => NULL, 'refs' => [ 'MonthlySetting$DayOfMonth' => '<p>The day of the month when monthly recurring on-call rotations begin.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'ShiftCoveragesMap$key' => NULL, 'WeeklySetting$DayOfWeek' => '<p>The day of the week when weekly recurring on-call shift rotations begins.</p>', ], ], 'DeactivateContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeactivateContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'DeferActivation' => [ 'base' => NULL, 'refs' => [ 'CreateContactChannelRequest$DeferActivation' => '<p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can\'t engage your contact channel until it has been activated.</p>', ], ], 'DeleteContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRotationOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRotationOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRotationResult' => [ 'base' => NULL, 'refs' => [], ], 'DependentEntity' => [ 'base' => '<p>Information about a resource that another resource is related to or depends on.</p> <p>For example, if a contact is a member of a rotation, the rotation is a dependent entity of the contact.</p>', 'refs' => [ 'DependentEntityList$member' => NULL, ], ], 'DependentEntityList' => [ 'base' => NULL, 'refs' => [ 'ConflictException$DependentEntities' => 'List of dependent entities containing information on relation type and resourceArns linked to the resource in use', ], ], 'DescribeEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngagementResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePageResult' => [ 'base' => NULL, 'refs' => [], ], 'Engagement' => [ 'base' => '<p>Incident Manager reaching out to a contact or escalation plan to engage contact during an incident.</p>', 'refs' => [ 'EngagementsList$member' => NULL, ], ], 'EngagementsList' => [ 'base' => NULL, 'refs' => [ 'ListEngagementsResult$Engagements' => '<p>A list of each engagement that occurred during the specified time range of an incident.</p>', ], ], 'GetContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'GetContactPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRotationOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRotationOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRotationResult' => [ 'base' => NULL, 'refs' => [], ], 'HandOffTime' => [ 'base' => '<p>Details about when an on-call rotation shift begins or ends.</p>', 'refs' => [ 'CoverageTime$Start' => '<p>Information about when the on-call rotation shift begins.</p>', 'CoverageTime$End' => '<p>Information about when the on-call rotation shift ends.</p>', 'DailySettings$member' => NULL, 'MonthlySetting$HandOffTime' => '<p>The time of day when a monthly recurring on-call shift rotation begins.</p>', 'WeeklySetting$HandOffTime' => '<p>The time of day when a weekly recurring on-call shift rotation begins.</p>', ], ], 'HourOfDay' => [ 'base' => NULL, 'refs' => [ 'HandOffTime$HourOfDay' => '<p>The hour when an on-call rotation shift begins or ends.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateContactChannelRequest$IdempotencyToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'CreateContactRequest$IdempotencyToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'CreateRotationOverrideRequest$IdempotencyToken' => '<p>A token that ensures that the operation is called only once with the specified details.</p>', 'CreateRotationRequest$IdempotencyToken' => '<p>A token that ensures that the operation is called only once with the specified details.</p>', 'StartEngagementRequest$IdempotencyToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', ], ], 'IncidentId' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$IncidentId' => '<p>The ARN of the incident in which the engagement occurred.</p>', 'DescribePageResult$IncidentId' => '<p>The ARN of the incident that engaged the contact channel.</p>', 'Engagement$IncidentId' => '<p>The ARN of the incident that\'s engaging the contact.</p>', 'ListEngagementsRequest$IncidentId' => '<p>The Amazon Resource Name (ARN) of the incident you\'re listing engagements for.</p>', 'Page$IncidentId' => '<p>The ARN of the incident that\'s engaging the contact channel.</p>', 'StartEngagementRequest$IncidentId' => '<p>The ARN of the incident that the engagement is part of.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error occurred while processing the request.</p>', 'refs' => [], ], 'IsEssential' => [ 'base' => NULL, 'refs' => [ 'ContactTargetInfo$IsEssential' => '<p>A Boolean value determining if the contact\'s acknowledgement stops the progress of stages in the plan.</p>', ], ], 'ListContactChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactChannelsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListContactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListEngagementsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEngagementsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPageReceiptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPageReceiptsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPageResolutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPageResolutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPagesByContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPagesByContactResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPagesByEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPagesByEngagementResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPreviewRotationShiftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPreviewRotationShiftsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationOverridesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationOverridesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationShiftsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationShiftsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRotationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListContactChannelsRequest$MaxResults' => '<p>The maximum number of contact channels per page.</p>', 'ListContactsRequest$MaxResults' => '<p>The maximum number of contacts and escalation plans per page of results.</p>', 'ListEngagementsRequest$MaxResults' => '<p>The maximum number of engagements per page of results.</p>', 'ListPageReceiptsRequest$MaxResults' => '<p>The maximum number of acknowledgements per page of results.</p>', 'ListPagesByContactRequest$MaxResults' => '<p>The maximum number of engagements to contact channels to list per page of results. </p>', 'ListPagesByEngagementRequest$MaxResults' => '<p>The maximum number of engagements to contact channels to list per page of results.</p>', 'ListPreviewRotationShiftsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that can be specified in a subsequent call to get the next set of results.</p>', 'ListRotationOverridesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListRotationShiftsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListRotationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'Member' => [ 'base' => NULL, 'refs' => [ 'RotationOverridePreviewMemberList$member' => NULL, 'RotationPreviewMemberList$member' => NULL, ], ], 'MinuteOfHour' => [ 'base' => NULL, 'refs' => [ 'HandOffTime$MinuteOfHour' => '<p>The minute when an on-call rotation shift begins or ends.</p>', ], ], 'MonthlySetting' => [ 'base' => '<p>Information about on-call rotations that recur monthly.</p>', 'refs' => [ 'MonthlySettings$member' => NULL, ], ], 'MonthlySettings' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$MonthlySettings' => '<p>Information about on-call rotations that recur monthly.</p>', ], ], 'NumberOfOnCalls' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$NumberOfOnCalls' => '<p>The number of contacts, or shift team members designated to be on call concurrently during a shift. For example, in an on-call schedule containing ten contacts, a value of <code>2</code> designates that two of them are on call at any given time.</p>', ], ], 'OverrideList' => [ 'base' => NULL, 'refs' => [ 'ListPreviewRotationShiftsRequest$Overrides' => '<p>Information about changes that would be made in a rotation override.</p>', ], ], 'Page' => [ 'base' => '<p>Incident Manager engaging a contact\'s contact channel.</p>', 'refs' => [ 'PagesList$member' => NULL, ], ], 'PagesList' => [ 'base' => NULL, 'refs' => [ 'ListPagesByContactResult$Pages' => '<p>The list of engagements to a contact\'s contact channel.</p>', 'ListPagesByEngagementResult$Pages' => '<p>The list of engagements to contact channels.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListContactChannelsRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListContactChannelsResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListContactsRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListContactsResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListEngagementsRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListEngagementsResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPageReceiptsRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPageReceiptsResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPageResolutionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListPageResolutionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListPagesByContactRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPagesByContactResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPagesByEngagementRequest$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPagesByEngagementResult$NextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListPreviewRotationShiftsRequest$NextToken' => '<p>A token to start the list. This token is used to get the next set of results.</p>', 'ListPreviewRotationShiftsResult$NextToken' => '<p>The token for the next set of items to return. This token is used to get the next set of results.</p>', 'ListRotationOverridesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListRotationOverridesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListRotationShiftsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListRotationShiftsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListRotationsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListRotationsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', ], ], 'Plan' => [ 'base' => '<p>Information about the stages and on-call rotation teams associated with an escalation plan or engagement plan. </p>', 'refs' => [ 'CreateContactRequest$Plan' => '<p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.</p>', 'GetContactResult$Plan' => '<p>Details about the specific timing or stages and targets of the escalation plan or engagement plan.</p>', 'UpdateContactRequest$Plan' => '<p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'GetContactPolicyResult$Policy' => '<p>Details about the resource policy attached to the contact or escalation plan.</p>', 'PutContactPolicyRequest$Policy' => '<p>Details of the resource policy.</p>', ], ], 'PreviewOverride' => [ 'base' => '<p>Information about contacts and times that an on-call override replaces.</p>', 'refs' => [ 'OverrideList$member' => NULL, ], ], 'PublicContent' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$PublicContent' => '<p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', 'DescribePageResult$PublicContent' => '<p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', 'StartEngagementRequest$PublicContent' => '<p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', ], ], 'PublicSubject' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$PublicSubject' => '<p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', 'DescribePageResult$PublicSubject' => '<p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', 'StartEngagementRequest$PublicSubject' => '<p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>', ], ], 'PutContactPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutContactPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'Receipt' => [ 'base' => '<p>Records events during an engagement.</p>', 'refs' => [ 'ReceiptsList$member' => NULL, ], ], 'ReceiptInfo' => [ 'base' => NULL, 'refs' => [ 'AcceptPageRequest$Note' => '<p>Information provided by the user when the user acknowledges the page.</p>', 'Receipt$ReceiptInfo' => '<p>Information provided during the page acknowledgement.</p>', ], ], 'ReceiptType' => [ 'base' => NULL, 'refs' => [ 'Receipt$ReceiptType' => '<p>The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.</p>', ], ], 'ReceiptsList' => [ 'base' => NULL, 'refs' => [ 'ListPageReceiptsResult$Receipts' => '<p>A list of each acknowledgement.</p>', ], ], 'RecurrenceMultiplier' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$RecurrenceMultiplier' => '<p>The number of days, weeks, or months a single rotation lasts.</p>', ], ], 'RecurrenceSettings' => [ 'base' => '<p>Information about when an on-call rotation is in effect and how long the rotation period lasts.</p>', 'refs' => [ 'CreateRotationRequest$Recurrence' => '<p>Information about the rule that specifies when a shift\'s team members rotate.</p>', 'GetRotationResult$Recurrence' => '<p>Specifies how long a rotation lasts before restarting at the beginning of the shift order.</p>', 'ListPreviewRotationShiftsRequest$Recurrence' => '<p>Information about how long a rotation would last before restarting at the beginning of the shift order.</p>', 'Rotation$Recurrence' => '<p>Information about when an on-call rotation is in effect and how long the rotation period lasts.</p>', 'UpdateRotationRequest$Recurrence' => '<p>Information about how long the updated rotation lasts before restarting at the beginning of the shift order.</p>', ], ], 'ResolutionContact' => [ 'base' => '<p>Information about the engagement resolution steps. The resolution starts from the first contact, which can be an escalation plan, then resolves to an on-call rotation, and finally to a personal contact.</p> <p>The <code>ResolutionContact</code> structure describes the information for each node or step in that process. It contains information about different contact types, such as the escalation, rotation, and personal contacts.</p>', 'refs' => [ 'ResolutionList$member' => NULL, ], ], 'ResolutionList' => [ 'base' => NULL, 'refs' => [ 'ListPageResolutionsResult$PageResolutions' => '<p>Information about the resolution for an engagement.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Request references a resource that doesn\'t exist.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => 'Advice to clients on when the call can be safely retried', 'ThrottlingException$RetryAfterSeconds' => 'Advice to clients on when the call can be safely retried', ], ], 'RetryIntervalInMinutes' => [ 'base' => NULL, 'refs' => [ 'ChannelTargetInfo$RetryIntervalInMinutes' => '<p>The number of minutes to wait to retry sending engagement in the case the engagement initially fails.</p>', ], ], 'Rotation' => [ 'base' => '<p>Information about a rotation in an on-call schedule.</p>', 'refs' => [ 'Rotations$member' => NULL, ], ], 'RotationContactsArnList' => [ 'base' => NULL, 'refs' => [ 'CreateRotationRequest$ContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts to add to the rotation.</p> <p>The order that you list the contacts in is their shift order in the rotation schedule. To change the order of the contact\'s shifts, use the <a>UpdateRotation</a> operation.</p>', 'GetRotationResult$ContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts assigned to the on-call rotation team.</p>', 'UpdateRotationRequest$ContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation. </p> <p>The order in which you list the contacts is their shift order in the rotation schedule.</p>', ], ], 'RotationName' => [ 'base' => NULL, 'refs' => [ 'CreateRotationRequest$Name' => '<p>The name of the rotation.</p>', 'GetRotationResult$Name' => '<p>The name of the on-call rotation.</p>', 'ListRotationsRequest$RotationNamePrefix' => '<p>A filter to include rotations in list results based on their common prefix. For example, entering prod returns a list of all rotation names that begin with <code>prod</code>, such as <code>production</code> and <code>prod-1</code>.</p>', 'Rotation$Name' => '<p>The name of the rotation.</p>', ], ], 'RotationOverride' => [ 'base' => '<p>Information about an override specified for an on-call rotation.</p>', 'refs' => [ 'RotationOverrides$member' => NULL, ], ], 'RotationOverrideContactsArnList' => [ 'base' => NULL, 'refs' => [ 'CreateRotationOverrideRequest$NewContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation with.</p> <p>If you want to include any current team members in the override shift, you must include their ARNs in the new contact ID list.</p>', ], ], 'RotationOverridePreviewMemberList' => [ 'base' => NULL, 'refs' => [ 'PreviewOverride$NewMembers' => '<p>Information about contacts to add to an on-call rotation override.</p>', ], ], 'RotationOverrides' => [ 'base' => NULL, 'refs' => [ 'ListRotationOverridesResult$RotationOverrides' => '<p>A list of rotation overrides in the specified time range.</p>', ], ], 'RotationPreviewMemberList' => [ 'base' => NULL, 'refs' => [ 'ListPreviewRotationShiftsRequest$Members' => '<p>The contacts that would be assigned to a rotation.</p>', ], ], 'RotationShift' => [ 'base' => '<p>Information about a shift that belongs to an on-call rotation.</p>', 'refs' => [ 'RotationShifts$member' => NULL, ], ], 'RotationShifts' => [ 'base' => NULL, 'refs' => [ 'ListPreviewRotationShiftsResult$RotationShifts' => '<p>Details about a rotation shift, including times, types, and contacts.</p>', 'ListRotationShiftsResult$RotationShifts' => '<p>Information about shifts that meet the filter criteria.</p>', ], ], 'Rotations' => [ 'base' => NULL, 'refs' => [ 'ListRotationsResult$Rotations' => '<p>Information about rotations that meet the filter criteria.</p>', ], ], 'SendActivationCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendActivationCodeResult' => [ 'base' => NULL, 'refs' => [], ], 'Sender' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$Sender' => '<p>The user that started the engagement.</p>', 'DescribePageResult$Sender' => '<p>The user that started the engagement.</p>', 'Engagement$Sender' => '<p>The user that started the engagement.</p>', 'Page$Sender' => '<p>The user that started the engagement.</p>', 'StartEngagementRequest$Sender' => '<p>The user that started the engagement.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ShiftCoveragesMap' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$ShiftCoverages' => '<p>Information about the days of the week included in on-call rotation coverage.</p>', ], ], 'ShiftDetails' => [ 'base' => '<p>Information about overrides to an on-call rotation shift.</p>', 'refs' => [ 'RotationShift$ShiftDetails' => '<p>Additional information about an on-call rotation shift.</p>', ], ], 'ShiftType' => [ 'base' => NULL, 'refs' => [ 'RotationShift$Type' => '<p>The type of shift rotation.</p>', ], ], 'SimpleAddress' => [ 'base' => NULL, 'refs' => [ 'ContactChannelAddress$SimpleAddress' => '<p>The format is dependent on the type of the contact channel. The following are the expected formats:</p> <ul> <li> <p>SMS - \'+\' followed by the country code and phone number</p> </li> <li> <p>VOICE - \'+\' followed by the country code and phone number</p> </li> <li> <p>EMAIL - any standard email format</p> </li> </ul>', ], ], 'SsmContactsArn' => [ 'base' => NULL, 'refs' => [ 'AcceptPageRequest$PageId' => '<p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>', 'AcceptPageRequest$ContactChannelId' => '<p>The ARN of the contact channel.</p>', 'ActivateContactChannelRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'ChannelTargetInfo$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'Contact$ContactArn' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'ContactChannel$ContactChannelArn' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'ContactChannel$ContactArn' => '<p>The ARN of the contact that contains the contact channel.</p>', 'ContactTargetInfo$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact.</p>', 'CreateContactChannelRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>', 'CreateContactChannelResult$ContactChannelArn' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'CreateContactResult$ContactArn' => '<p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>', 'CreateRotationOverrideRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the rotation to create an override for.</p>', 'CreateRotationResult$RotationArn' => '<p>The Amazon Resource Name (ARN) of the created rotation.</p>', 'DeactivateContactChannelRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel you\'re deactivating.</p>', 'DeleteContactChannelRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'DeleteContactRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact that you\'re deleting.</p>', 'DeleteRotationOverrideRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the rotation that was overridden.</p>', 'DeleteRotationRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the on-call rotation to delete.</p>', 'DescribeEngagementRequest$EngagementId' => '<p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>', 'DescribeEngagementResult$ContactArn' => '<p>The ARN of the escalation plan or contacts involved in the engagement.</p>', 'DescribeEngagementResult$EngagementArn' => '<p>The ARN of the engagement.</p>', 'DescribePageRequest$PageId' => '<p>The ID of the engagement to a contact channel.</p>', 'DescribePageResult$PageArn' => '<p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>', 'DescribePageResult$EngagementArn' => '<p>The ARN of the engagement that engaged the contact channel.</p>', 'DescribePageResult$ContactArn' => '<p>The ARN of the contact that was engaged.</p>', 'Engagement$EngagementArn' => '<p>The Amazon Resource Name (ARN) of the engagement.</p>', 'Engagement$ContactArn' => '<p>The ARN of the escalation plan or contact that Incident Manager is engaging.</p>', 'GetContactChannelRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>', 'GetContactChannelResult$ContactArn' => '<p>The ARN of the contact that the channel belongs to.</p>', 'GetContactChannelResult$ContactChannelArn' => '<p>The ARN of the contact channel.</p>', 'GetContactPolicyRequest$ContactArn' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'GetContactPolicyResult$ContactArn' => '<p>The ARN of the contact or escalation plan.</p>', 'GetContactRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'GetContactResult$ContactArn' => '<p>The ARN of the contact or escalation plan.</p>', 'GetRotationOverrideRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the overridden rotation to retrieve information about.</p>', 'GetRotationOverrideResult$RotationArn' => '<p>The Amazon Resource Name (ARN) of the on-call rotation that was overridden.</p>', 'GetRotationRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the on-call rotation to retrieve information about.</p>', 'GetRotationResult$RotationArn' => '<p>The Amazon Resource Name (ARN) of the on-call rotation.</p>', 'ListContactChannelsRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact.</p>', 'ListPageReceiptsRequest$PageId' => '<p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>', 'ListPageResolutionsRequest$PageId' => '<p>The Amazon Resource Name (ARN) of the contact engaged for the incident.</p>', 'ListPagesByContactRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>', 'ListPagesByEngagementRequest$EngagementId' => '<p>The Amazon Resource Name (ARN) of the engagement.</p>', 'ListRotationOverridesRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the rotation to retrieve information about.</p>', 'ListRotationShiftsRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the rotation to retrieve shift information about. </p>', 'Page$PageArn' => '<p>The Amazon Resource Name (ARN) of the page to the contact channel.</p>', 'Page$EngagementArn' => '<p>The ARN of the engagement that this page is part of.</p>', 'Page$ContactArn' => '<p>The ARN of the contact that Incident Manager is engaging.</p>', 'PutContactPolicyRequest$ContactArn' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>', 'Receipt$ContactChannelArn' => '<p>The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.</p>', 'ResolutionContact$ContactArn' => '<p>The Amazon Resource Name (ARN) of a contact in the engagement resolution process. </p>', 'Rotation$RotationArn' => '<p>The Amazon Resource Name (ARN) of the rotation.</p>', 'RotationContactsArnList$member' => NULL, 'RotationOverrideContactsArnList$member' => NULL, 'SendActivationCodeRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel.</p>', 'SsmContactsArnList$member' => NULL, 'StartEngagementRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact being engaged.</p>', 'StartEngagementResult$EngagementArn' => '<p>The ARN of the engagement.</p>', 'StopEngagementRequest$EngagementId' => '<p>The Amazon Resource Name (ARN) of the engagement.</p>', 'UpdateContactChannelRequest$ContactChannelId' => '<p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>', 'UpdateContactRequest$ContactId' => '<p>The Amazon Resource Name (ARN) of the contact or escalation plan you\'re updating.</p>', 'UpdateRotationRequest$RotationId' => '<p>The Amazon Resource Name (ARN) of the rotation to update.</p>', ], ], 'SsmContactsArnList' => [ 'base' => NULL, 'refs' => [ 'DependentEntity$DependentResourceIds' => '<p>The Amazon Resource Names (ARNs) of the dependent resources.</p>', 'GetRotationOverrideResult$NewContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.</p>', 'Plan$RotationIds' => '<p>The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan. </p>', 'Rotation$ContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.</p>', 'RotationOverride$NewContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.</p>', 'RotationShift$ContactIds' => '<p>The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation. </p>', 'ShiftDetails$OverriddenContactIds' => '<p>The Amazon Resources Names (ARNs) of the contacts who were replaced in a shift when an override was created. If the override is deleted, these contacts are restored to the shift.</p>', ], ], 'Stage' => [ 'base' => '<p>A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.</p>', 'refs' => [ 'StagesList$member' => NULL, ], ], 'StageDurationInMins' => [ 'base' => NULL, 'refs' => [ 'Stage$DurationInMinutes' => '<p>The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.</p>', ], ], 'StageIndex' => [ 'base' => NULL, 'refs' => [ 'ResolutionContact$StageIndex' => '<p>The stage in the escalation plan that resolves to this contact.</p>', ], ], 'StagesList' => [ 'base' => NULL, 'refs' => [ 'Plan$Stages' => '<p>A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.</p>', ], ], 'StartEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartEngagementResult' => [ 'base' => NULL, 'refs' => [], ], 'StopEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEngagementResult' => [ 'base' => NULL, 'refs' => [], ], 'StopReason' => [ 'base' => NULL, 'refs' => [ 'StopEngagementRequest$Reason' => '<p>The reason that you\'re stopping the engagement.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => 'Identifier of the resource in use', 'ConflictException$ResourceType' => 'Type of the resource in use', 'DataEncryptionException$Message' => NULL, 'DependentEntity$RelationType' => '<p>The type of relationship between one resource and the other resource that it is related to or depends on.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => 'Hypothetical resource identifier that was not found', 'ResourceNotFoundException$ResourceType' => 'Hypothetical resource type that was not found', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$ResourceId' => 'Identifier of the resource affected', 'ServiceQuotaExceededException$ResourceType' => 'Type of the resource affected', 'ServiceQuotaExceededException$QuotaCode' => 'Service Quotas requirement to identify originating service', 'ServiceQuotaExceededException$ServiceCode' => 'Service Quotas requirement to identify originating quota', 'ThrottlingException$Message' => NULL, 'ThrottlingException$QuotaCode' => 'Service Quotas requirement to identify originating service', 'ThrottlingException$ServiceCode' => 'Service Quotas requirement to identify originating quota', 'ValidationException$Message' => NULL, 'ValidationExceptionField$Name' => '<p>The name of the field that caused the exception.</p>', 'ValidationExceptionField$Message' => '<p>Information about what caused the field to cause an exception.</p>', ], ], 'Subject' => [ 'base' => NULL, 'refs' => [ 'DescribeEngagementResult$Subject' => '<p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>', 'DescribePageResult$Subject' => '<p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>', 'StartEngagementRequest$Subject' => '<p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>', ], ], 'Tag' => [ 'base' => '<p>A container of a key-value name pair.</p>', 'refs' => [ 'TagsList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Name of the object key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The key of the tag that you want to remove.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Value of the tag.</p>', ], ], 'TagsList' => [ 'base' => NULL, 'refs' => [ 'CreateContactRequest$Tags' => '<p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set.</p>', 'CreateRotationRequest$Tags' => '<p>Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager resources</a> in the <i>Incident Manager User Guide</i>.</p>', 'ListTagsForResourceResult$Tags' => '<p>The tags related to the contact or escalation plan.</p>', 'TagResourceRequest$Tags' => '<p>A list of tags that you are adding to the contact or escalation plan.</p>', ], ], 'Target' => [ 'base' => '<p>The contact or contact channel that\'s being engaged.</p>', 'refs' => [ 'TargetsList$member' => NULL, ], ], 'TargetsList' => [ 'base' => NULL, 'refs' => [ 'Stage$Targets' => '<p>The contacts or contact methods that the escalation plan or engagement plan is engaging.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeRange' => [ 'base' => '<p>A range of between two set times</p>', 'refs' => [ 'ListEngagementsRequest$TimeRangeValue' => '<p>The time range to lists engagements for an incident.</p>', ], ], 'TimeZoneId' => [ 'base' => NULL, 'refs' => [ 'CreateRotationRequest$TimeZoneId' => '<p>The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note> <p>Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), are not supported.</p> </note>', 'GetRotationResult$TimeZoneId' => '<p>The time zone that the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA) format.</p>', 'ListPreviewRotationShiftsRequest$TimeZoneId' => '<p>The time zone the rotation’s activity would be based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". </p>', 'Rotation$TimeZoneId' => '<p>The time zone the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". </p>', 'UpdateRotationRequest$TimeZoneId' => '<p>The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note> <p>Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), aren\'t supported.</p> </note>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactChannelResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRotationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRotationResult' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CreateRotationOverrideResult$RotationOverrideId' => '<p>The Amazon Resource Name (ARN) of the created rotation override.</p>', 'DeleteRotationOverrideRequest$RotationOverrideId' => '<p>The Amazon Resource Name (ARN) of the on-call rotation override to delete.</p>', 'GetRotationOverrideRequest$RotationOverrideId' => '<p>The Amazon Resource Name (ARN) of the on-call rotation override to retrieve information about.</p>', 'GetRotationOverrideResult$RotationOverrideId' => '<p>The Amazon Resource Name (ARN) of the override to an on-call rotation.</p>', 'RotationOverride$RotationOverrideId' => '<p>The Amazon Resource Name (ARN) of the override to an on-call rotation.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Provides information about which field caused the exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => 'The fields that caused the error', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => 'Reason the request failed validation', ], ], 'WeeklySetting' => [ 'base' => '<p>Information about rotations that recur weekly.</p>', 'refs' => [ 'WeeklySettings$member' => NULL, ], ], 'WeeklySettings' => [ 'base' => NULL, 'refs' => [ 'RecurrenceSettings$WeeklySettings' => '<p>Information about on-call rotations that recur weekly.</p>', ], ], ],];
