<?php
// This file was auto-generated from sdk-root/src/data/sso-oidc/2019-06-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>IAM Identity Center OpenID Connect (OIDC) is a web service that enables a client (such as CLI or a native application) to register with IAM Identity Center. The service also enables the client to fetch the user’s access token upon successful authentication and authorization with IAM Identity Center.</p> <note> <p>IAM Identity Center uses the <code>sso</code> and <code>identitystore</code> API namespaces.</p> </note> <p> <b>Considerations for Using This Guide</b> </p> <p>Before you begin using this guide, we recommend that you first review the following important information about how the IAM Identity Center OIDC service works.</p> <ul> <li> <p>The IAM Identity Center OIDC service currently implements only the portions of the OAuth 2.0 Device Authorization Grant standard (<a href="https://tools.ietf.org/html/rfc8628">https://tools.ietf.org/html/rfc8628</a>) that are necessary to enable single sign-on authentication with the CLI. </p> </li> <li> <p>With older versions of the CLI, the service only emits OIDC access tokens, so to obtain a new token, users must explicitly re-authenticate. To access the OIDC flow that supports token refresh and doesn’t require re-authentication, update to the latest CLI version (1.27.10 for CLI V1 and 2.9.0 for CLI V2) with support for OIDC token refresh and configurable IAM Identity Center session durations. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/configure-user-session.html">Configure Amazon Web Services access portal session duration </a>. </p> </li> <li> <p>The access tokens provided by this service grant access to all Amazon Web Services account entitlements assigned to an IAM Identity Center user, not just a particular application.</p> </li> <li> <p>The documentation in this guide does not describe the mechanism to convert the access token into Amazon Web Services Auth (“sigv4”) credentials for use with IAM-protected Amazon Web Services service endpoints. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/PortalAPIReference/API_GetRoleCredentials.html">GetRoleCredentials</a> in the <i>IAM Identity Center Portal API Reference Guide</i>.</p> </li> </ul> <p>For general information about IAM Identity Center, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">What is IAM Identity Center?</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'operations' => [ 'CreateToken' => '<p>Creates and returns access and refresh tokens for clients that are authenticated using client secrets. The access token can be used to fetch short-term credentials for the assigned AWS accounts or to access application APIs using <code>bearer</code> authentication.</p>', 'CreateTokenWithIAM' => '<p>Creates and returns access and refresh tokens for clients and applications that are authenticated using IAM entities. The access token can be used to fetch short-term credentials for the assigned Amazon Web Services accounts or to access application APIs using <code>bearer</code> authentication.</p>', 'RegisterClient' => '<p>Registers a client with IAM Identity Center. This allows clients to initiate device authorization. The output should be persisted for reuse through many authentication requests.</p>', 'StartDeviceAuthorization' => '<p>Initiates device authorization by requesting a pair of verification codes from the authorization service.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessToken' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$accessToken' => '<p>A bearer token to access Amazon Web Services accounts and applications assigned to a user.</p>', 'CreateTokenWithIAMResponse$accessToken' => '<p>A bearer token to access Amazon Web Services accounts and applications assigned to a user.</p>', ], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'RegisterClientRequest$entitledApplicationArn' => '<p>This IAM Identity Center application ARN is used to define administrator-managed configuration for public client access to resources. At authorization, the scopes, grants, and redirect URI available to this client will be restricted by this application resource.</p>', ], ], 'Assertion' => [ 'base' => NULL, 'refs' => [ 'CreateTokenWithIAMRequest$assertion' => '<p>Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.</p>', ], ], 'AuthCode' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$code' => '<p>Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify this authorization request. This grant type is currently unsupported for the <a>CreateToken</a> API.</p>', 'CreateTokenWithIAMRequest$code' => '<p>Used only when calling this API for the Authorization Code grant type. This short-term code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.</p>', ], ], 'AuthorizationPendingException' => [ 'base' => '<p>Indicates that a request to authorize a client with an access user session token is pending.</p>', 'refs' => [], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$clientId' => '<p>The unique identifier string for the client or application. This value comes from the result of the <a>RegisterClient</a> API.</p>', 'CreateTokenWithIAMRequest$clientId' => '<p>The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.</p>', 'RegisterClientResponse$clientId' => '<p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>', 'StartDeviceAuthorizationRequest$clientId' => '<p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <a>RegisterClient</a> API operation.</p>', ], ], 'ClientName' => [ 'base' => NULL, 'refs' => [ 'RegisterClientRequest$clientName' => '<p>The friendly name of the client.</p>', ], ], 'ClientSecret' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$clientSecret' => '<p>A secret string generated for the client. This value should come from the persisted result of the <a>RegisterClient</a> API.</p>', 'RegisterClientResponse$clientSecret' => '<p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>', 'StartDeviceAuthorizationRequest$clientSecret' => '<p>A secret string that is generated for the client. This value should come from the persisted result of the <a>RegisterClient</a> API operation.</p>', ], ], 'ClientType' => [ 'base' => NULL, 'refs' => [ 'RegisterClientRequest$clientType' => '<p>The type of client. The service supports only <code>public</code> as a client type. Anything other than public will be rejected by the service.</p>', ], ], 'CodeVerifier' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$codeVerifier' => '<p>Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.</p>', 'CreateTokenWithIAMRequest$codeVerifier' => '<p>Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.</p>', ], ], 'CreateTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTokenWithIAMRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTokenWithIAMResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeviceCode' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$deviceCode' => '<p>Used only when calling this API for the Device Code grant type. This short-term code is used to identify this authorization request. This comes from the result of the <a>StartDeviceAuthorization</a> API.</p>', 'StartDeviceAuthorizationResponse$deviceCode' => '<p>The short-lived code that is used by the device when polling for a session token.</p>', ], ], 'Error' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$error' => '<p>Single error code. For this exception the value will be <code>access_denied</code>.</p>', 'AuthorizationPendingException$error' => '<p>Single error code. For this exception the value will be <code>authorization_pending</code>.</p>', 'ExpiredTokenException$error' => '<p>Single error code. For this exception the value will be <code>expired_token</code>.</p>', 'InternalServerException$error' => '<p>Single error code. For this exception the value will be <code>server_error</code>.</p>', 'InvalidClientException$error' => '<p>Single error code. For this exception the value will be <code>invalid_client</code>.</p>', 'InvalidClientMetadataException$error' => '<p>Single error code. For this exception the value will be <code>invalid_client_metadata</code>.</p>', 'InvalidGrantException$error' => '<p>Single error code. For this exception the value will be <code>invalid_grant</code>.</p>', 'InvalidRedirectUriException$error' => '<p>Single error code. For this exception the value will be <code>invalid_redirect_uri</code>.</p>', 'InvalidRequestException$error' => '<p>Single error code. For this exception the value will be <code>invalid_request</code>.</p>', 'InvalidRequestRegionException$error' => '<p>Single error code. For this exception the value will be <code>invalid_request</code>.</p>', 'InvalidScopeException$error' => '<p>Single error code. For this exception the value will be <code>invalid_scope</code>.</p>', 'SlowDownException$error' => '<p>Single error code. For this exception the value will be <code>slow_down</code>.</p>', 'UnauthorizedClientException$error' => '<p>Single error code. For this exception the value will be <code>unauthorized_client</code>.</p>', 'UnsupportedGrantTypeException$error' => '<p>Single error code. For this exception the value will be <code>unsupported_grant_type</code>.</p>', ], ], 'ErrorDescription' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'AuthorizationPendingException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'ExpiredTokenException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InternalServerException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidClientException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidClientMetadataException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidGrantException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidRedirectUriException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidRequestException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidRequestRegionException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'InvalidScopeException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'SlowDownException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'UnauthorizedClientException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', 'UnsupportedGrantTypeException$error_description' => '<p>Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.</p>', ], ], 'ExpirationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$expiresIn' => '<p>Indicates the time in seconds when an access token will expire.</p>', 'CreateTokenWithIAMResponse$expiresIn' => '<p>Indicates the time in seconds when an access token will expire.</p>', 'StartDeviceAuthorizationResponse$expiresIn' => '<p>Indicates the number of seconds in which the verification code will become invalid.</p>', ], ], 'ExpiredTokenException' => [ 'base' => '<p>Indicates that the token issued by the service is expired and is no longer valid.</p>', 'refs' => [], ], 'GrantType' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$grantType' => '<p>Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values, depending on the grant type that you want:</p> <p>* Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code> </p> <p>* Refresh Token - <code>refresh_token</code> </p> <p>For information about how to obtain the device code, see the <a>StartDeviceAuthorization</a> topic.</p>', 'CreateTokenWithIAMRequest$grantType' => '<p>Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:</p> <p>* Authorization Code - <code>authorization_code</code> </p> <p>* Refresh Token - <code>refresh_token</code> </p> <p>* JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> </p> <p>* Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code> </p>', 'GrantTypes$member' => NULL, ], ], 'GrantTypes' => [ 'base' => NULL, 'refs' => [ 'RegisterClientRequest$grantTypes' => '<p>The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token granting flows available to the client.</p>', ], ], 'IdToken' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$idToken' => '<p>The <code>idToken</code> is not implemented or supported. For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p> <p>A JSON Web Token (JWT) that identifies who is associated with the issued access token. </p>', 'CreateTokenWithIAMResponse$idToken' => '<p>A JSON Web Token (JWT) that identifies the user associated with the issued access token. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>Indicates that an error from the service occurred while trying to process a request.</p>', 'refs' => [], ], 'IntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'StartDeviceAuthorizationResponse$interval' => '<p>Indicates the number of seconds the client must wait between attempts when polling for a session.</p>', ], ], 'InvalidClientException' => [ 'base' => '<p>Indicates that the <code>clientId</code> or <code>clientSecret</code> in the request is invalid. For example, this can occur when a client sends an incorrect <code>clientId</code> or an expired <code>clientSecret</code>.</p>', 'refs' => [], ], 'InvalidClientMetadataException' => [ 'base' => '<p>Indicates that the client information sent in the request during registration is invalid.</p>', 'refs' => [], ], 'InvalidGrantException' => [ 'base' => '<p>Indicates that a request contains an invalid grant. This can occur if a client makes a <a>CreateToken</a> request with an invalid grant type.</p>', 'refs' => [], ], 'InvalidRedirectUriException' => [ 'base' => '<p>Indicates that one or more redirect URI in the request is not supported for this operation.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a required parameter might be missing or out of range.</p>', 'refs' => [], ], 'InvalidRequestRegionException' => [ 'base' => '<p>Indicates that a token provided as input to the request was issued by and is only usable by calling IAM Identity Center endpoints in another region.</p>', 'refs' => [], ], 'InvalidScopeException' => [ 'base' => '<p>Indicates that the scope provided in the request is invalid.</p>', 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestRegionException$endpoint' => '<p>Indicates the IAM Identity Center endpoint which the requester may call with this token.</p>', ], ], 'LongTimeStampType' => [ 'base' => NULL, 'refs' => [ 'RegisterClientResponse$clientIdIssuedAt' => '<p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>', 'RegisterClientResponse$clientSecretExpiresAt' => '<p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>', ], ], 'RedirectUris' => [ 'base' => NULL, 'refs' => [ 'RegisterClientRequest$redirectUris' => '<p>The list of redirect URI that are defined by the client. At completion of authorization, this list is used to restrict what locations the user agent can be redirected back to.</p>', ], ], 'RefreshToken' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$refreshToken' => '<p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>', 'CreateTokenResponse$refreshToken' => '<p>A token that, if present, can be used to refresh a previously issued access token that might have expired.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>', 'CreateTokenWithIAMRequest$refreshToken' => '<p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>', 'CreateTokenWithIAMResponse$refreshToken' => '<p>A token that, if present, can be used to refresh a previously issued access token that might have expired.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestRegionException$region' => '<p>Indicates the region which the requester may call with this token.</p>', ], ], 'RegisterClientRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterClientResponse' => [ 'base' => NULL, 'refs' => [], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'Scopes$member' => NULL, ], ], 'Scopes' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$scope' => '<p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured for the client during the call to <a>RegisterClient</a>.</p>', 'CreateTokenWithIAMRequest$scope' => '<p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: <code>openid</code>, <code>aws</code>, <code>sts:identity_context</code>.</p>', 'CreateTokenWithIAMResponse$scope' => '<p>The list of scopes for which authorization is granted. The access token that is issued is limited to the scopes that are granted.</p>', 'RegisterClientRequest$scopes' => '<p>The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token.</p>', ], ], 'SlowDownException' => [ 'base' => '<p>Indicates that the client is making the request too frequently and is more than the service can handle. </p>', 'refs' => [], ], 'StartDeviceAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDeviceAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SubjectToken' => [ 'base' => NULL, 'refs' => [ 'CreateTokenWithIAMRequest$subjectToken' => '<p>Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.</p>', ], ], 'TokenType' => [ 'base' => NULL, 'refs' => [ 'CreateTokenResponse$tokenType' => '<p>Used to notify the client that the returned token is an access token. The supported token type is <code>Bearer</code>.</p>', 'CreateTokenWithIAMResponse$tokenType' => '<p>Used to notify the requester that the returned token is an access token. The supported token type is <code>Bearer</code>.</p>', ], ], 'TokenTypeURI' => [ 'base' => NULL, 'refs' => [ 'CreateTokenWithIAMRequest$subjectTokenType' => '<p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:</p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code> </p>', 'CreateTokenWithIAMRequest$requestedTokenType' => '<p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:</p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code> </p> <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code> </p>', 'CreateTokenWithIAMResponse$issuedTokenType' => '<p>Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported: </p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code> </p> <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code> </p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'CreateTokenRequest$redirectUri' => '<p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p>', 'CreateTokenWithIAMRequest$redirectUri' => '<p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code. </p>', 'RedirectUris$member' => NULL, 'RegisterClientRequest$issuerUrl' => '<p>The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed for user access to resources through the client.</p>', 'RegisterClientResponse$authorizationEndpoint' => '<p>An endpoint that the client can use to request authorization.</p>', 'RegisterClientResponse$tokenEndpoint' => '<p>An endpoint that the client can use to create tokens.</p>', 'StartDeviceAuthorizationRequest$startUrl' => '<p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'StartDeviceAuthorizationResponse$verificationUri' => '<p>The URI of the verification page that takes the <code>userCode</code> to authorize the device.</p>', 'StartDeviceAuthorizationResponse$verificationUriComplete' => '<p>An alternate URL that the client can use to automatically launch a browser. This process skips the manual step in which the user visits the verification page and enters their code.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>Indicates that the client is not currently authorized to make the request. This can happen when a <code>clientId</code> is not issued for a public client.</p>', 'refs' => [], ], 'UnsupportedGrantTypeException' => [ 'base' => '<p>Indicates that the grant type in the request is not supported by the service.</p>', 'refs' => [], ], 'UserCode' => [ 'base' => NULL, 'refs' => [ 'StartDeviceAuthorizationResponse$userCode' => '<p>A one-time user verification code. This is needed to authorize an in-use device.</p>', ], ], ],];
