<?php
// This file was auto-generated from sdk-root/src/data/taxsettings/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You can use the tax setting API to programmatically set, modify, and delete the tax registration number (TRN), associated business legal name, and address (Collectively referred to as "TRN information"). You can also programmatically view TRN information and tax addresses ("Tax profiles"). </p> <p>You can use this API to automate your TRN information settings instead of manually using the console.</p> <p>Service Endpoint</p> <ul> <li> <p>https://tax.us-east-1.amazonaws.com</p> </li> </ul>', 'operations' => [ 'BatchDeleteTaxRegistration' => '<p>Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to five accounts in one batch. </p> <note> <p>This API operation can\'t be used to delete your tax registration in Brazil. Use the <a href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a> page in the Billing and Cost Management console instead.</p> </note>', 'BatchPutTaxRegistration' => '<p>Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax registrations for up to five accounts in one batch. You can\'t set a TRN if there\'s a pending TRN. You\'ll need to delete the pending TRN first.</p> <p>To call this API operation for specific countries, see the following country-specific requirements.</p> <p> <b>Bangladesh</b> </p> <ul> <li> <p>You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Brazil</b> </p> <ul> <li> <p>You must complete the tax registration process in the <a href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a> page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.</p> </li> <li> <p>For Amazon Web Services accounts created through Organizations, you can call this API operation when you don\'t have a billing address.</p> </li> </ul> <p> <b>Georgia</b> </p> <ul> <li> <p>The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.</p> </li> </ul> <p> <b>Kenya</b> </p> <ul> <li> <p>You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object.</p> </li> <li> <p>If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Malaysia</b> </p> <ul> <li> <p>If you use this operation to set a tax registration number (TRN) in Malaysia, only resellers with a valid sales and service tax (SST) number are required to provide tax registration information.</p> </li> <li> <p>By using this API operation to set a TRN in Malaysia, Amazon Web Services will regard you as self-declaring that you\'re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD) and have a valid SST number.</p> </li> <li> <p>Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.</p> </li> <li> <p>If you\'re not a reseller of Amazon Web Services, we don\'t recommend that you use this operation to set the TRN in Malaysia.</p> </li> <li> <p>Only use this API operation to upload the TRNs for accounts through which you\'re reselling Amazon Web Services.</p> </li> <li> <p>Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.</p> <p>Taxable service and service tax codes:</p> <p>Consultancy - 9907061674</p> <p>Training or coaching service - 9907071685</p> <p>IT service - 9907101676</p> <p>Digital services and electronic medium - 9907121690</p> </li> </ul> <p> <b>Nepal</b> </p> <ul> <li> <p>The sector valid values are <code>Business</code> and <code>Individual</code>.</p> </li> </ul> <p> <b>Saudi Arabia</b> </p> <ul> <li> <p>For <code>address</code>, you must specify <code>addressLine3</code>.</p> </li> </ul> <p> <b>South Korea</b> </p> <ul> <li> <p>You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.</p> </li> <li> <p>You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object. Use Korean characters for these fields.</p> </li> <li> <p>You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> <li> <p>For the <code>address</code> object, use Korean characters for <code>addressLine1</code>, <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.</p> </li> </ul> <p> <b>Spain</b> </p> <ul> <li> <p>You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object.</p> </li> <li> <p>If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Turkey</b> </p> <ul> <li> <p>You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.</p> </li> <li> <p>If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:</p> <ul> <li> <p>Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don\'t enter this value.</p> </li> <li> <p>(Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don\'t enter this value.</p> </li> <li> <p> <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public institutions</b> </p> </li> </ul> </li> <li> <p>If your <code>sector</code> is <code>Business</code> and you\'re subject to KDV tax, you must specify your industry in the <code>industries</code> field.</p> </li> <li> <p>For <code>address</code>, you must specify <code>districtOrCounty</code>.</p> </li> </ul> <p> <b>Ukraine</b> </p> <ul> <li> <p>The sector valid values are <code>Business</code> and <code>Individual</code>.</p> </li> </ul>', 'DeleteTaxRegistration' => '<p>Deletes tax registration for a single account. </p> <note> <p>This API operation can\'t be used to delete your tax registration in Brazil. Use the <a href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a> page in the Billing and Cost Management console instead.</p> </note>', 'GetTaxRegistration' => '<p>Retrieves tax registration for a single account.</p>', 'GetTaxRegistrationDocument' => '<p>Downloads your tax documents to the Amazon S3 bucket that you specify in your request.</p>', 'ListTaxRegistrations' => '<p>Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve up to 100 accounts\' tax registrations in one call (default 50). </p>', 'PutTaxRegistration' => '<p>Adds or updates tax registration for a single account. You can\'t set a TRN if there\'s a pending TRN. You\'ll need to delete the pending TRN first.</p> <p>To call this API operation for specific countries, see the following country-specific requirements.</p> <p> <b>Bangladesh</b> </p> <ul> <li> <p>You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Brazil</b> </p> <ul> <li> <p>You must complete the tax registration process in the <a href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a> page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call this API operation.</p> </li> <li> <p>For Amazon Web Services accounts created through Organizations, you can call this API operation when you don\'t have a billing address.</p> </li> </ul> <p> <b>Georgia</b> </p> <ul> <li> <p>The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.</p> </li> </ul> <p> <b>Kenya</b> </p> <ul> <li> <p>You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object.</p> </li> <li> <p>If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Malaysia</b> </p> <ul> <li> <p>If you use this operation to set a tax registration number (TRN) in Malaysia, only resellers with a valid sales and service tax (SST) number are required to provide tax registration information.</p> </li> <li> <p>By using this API operation to set a TRN in Malaysia, Amazon Web Services will regard you as self-declaring that you\'re an authorized business reseller registered with the Royal Malaysia Customs Department (RMCD) and have a valid SST number.</p> </li> <li> <p>Amazon Web Services reserves the right to seek additional information and/or take other actions to support your self-declaration as appropriate.</p> </li> <li> <p>If you\'re not a reseller of Amazon Web Services, we don\'t recommend that you use this operation to set the TRN in Malaysia.</p> </li> <li> <p>Only use this API operation to upload the TRNs for accounts through which you\'re reselling Amazon Web Services.</p> </li> <li> <p>Amazon Web Services is currently registered under the following service tax codes. You must include at least one of the service tax codes in the service tax code strings to declare yourself as an authorized registered business reseller.</p> <p>Taxable service and service tax codes:</p> <p>Consultancy - 9907061674</p> <p>Training or coaching service - 9907071685</p> <p>IT service - 9907101676</p> <p>Digital services and electronic medium - 9907121690</p> </li> </ul> <p> <b>Nepal</b> </p> <ul> <li> <p>The sector valid values are <code>Business</code> and <code>Individual</code>.</p> </li> </ul> <p> <b>Saudi Arabia</b> </p> <ul> <li> <p>For <code>address</code>, you must specify <code>addressLine3</code>.</p> </li> </ul> <p> <b>South Korea</b> </p> <ul> <li> <p>You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.</p> </li> <li> <p>You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object. Use Korean characters for these fields.</p> </li> <li> <p>You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> <li> <p>For the <code>address</code> object, use Korean characters for <code>addressLine1</code>, <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.</p> </li> </ul> <p> <b>Spain</b> </p> <ul> <li> <p>You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the <code>additionalTaxInformation</code> object.</p> </li> <li> <p>If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.</p> </li> </ul> <p> <b>Turkey</b> </p> <ul> <li> <p>You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.</p> </li> <li> <p>If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:</p> <ul> <li> <p>Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don\'t enter this value.</p> </li> <li> <p>(Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don\'t enter this value.</p> </li> <li> <p> <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public institutions</b> </p> </li> </ul> </li> <li> <p>If your <code>sector</code> is <code>Business</code> and you\'re subject to KDV tax, you must specify your industry in the <code>industries</code> field.</p> </li> <li> <p>For <code>address</code>, you must specify <code>districtOrCounty</code>.</p> </li> </ul> <p> <b>Ukraine</b> </p> <ul> <li> <p>The sector valid values are <code>Business</code> and <code>Individual</code>.</p> </li> </ul>', ], 'shapes' => [ 'AccountDetails' => [ 'base' => '<p> An object with your <code>accountId</code> and TRN information. </p>', 'refs' => [ 'AccountDetailsList$member' => NULL, ], ], 'AccountDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListTaxRegistrationsResponse$accountDetails' => '<p>The list of account details. This contains account Ids and TRN Information for each of the linked accounts. </p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$accountId' => '<p>List of unique account identifiers. </p>', 'AccountIds$member' => NULL, 'BatchDeleteTaxRegistrationError$accountId' => '<p> The unique account identifier for the account whose tax registration couldn\'t be deleted during the <code>BatchDeleteTaxRegistration</code> operation. </p>', 'BatchPutTaxRegistrationError$accountId' => '<p> The unique account identifier for the account that the tax registration couldn\'t be added, or updated during the <code>BatchPutTaxRegistration</code> operation. </p>', 'DeleteTaxRegistrationRequest$accountId' => '<p>Unique account identifier for the TRN information that needs to be deleted. If this isn\'t passed, the account ID corresponding to the credentials of the API caller will be used for this parameter.</p>', 'GetTaxRegistrationRequest$accountId' => '<p>Your unique account identifier.</p>', 'PutTaxRegistrationRequest$accountId' => '<p>Your unique account identifier. </p>', 'TaxInheritanceDetails$parentEntityId' => '<p> Tax inheritance parent account information associated with the account. </p>', ], ], 'AccountIds' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTaxRegistrationRequest$accountIds' => '<p>List of unique account identifiers. </p>', 'BatchPutTaxRegistrationRequest$accountIds' => '<p> List of unique account identifiers.</p>', ], ], 'AccountMetaData' => [ 'base' => '<p> The meta data information associated with the account. </p>', 'refs' => [ 'AccountDetails$accountMetaData' => '<p> The meta data information associated with the account. </p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'AccountMetaData$accountName' => '<p> The Amazon Web Services accounts name. </p>', ], ], 'AdditionalInfoRequest' => [ 'base' => '<p>Additional tax information associated with your tax registration number (TRN). Depending on the TRN for a specific country, you might need to specify this information when you set your TRN. </p> <p>You can only specify one of the following parameters and the value can\'t be empty. </p> <note> <p>The parameter that you specify must match the country for the TRN, if available. For example, if you set a TRN in Canada for specific provinces, you must also specify the <code>canadaAdditionalInfo</code> parameter.</p> </note>', 'refs' => [ 'TaxRegistrationEntry$additionalTaxInformation' => '<p> Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.</p>', ], ], 'AdditionalInfoResponse' => [ 'base' => '<p> Additional tax information associated with your TRN. The Tax Settings API returns country-specific information in the response when any additional information is present with your TRN for the following countries.</p>', 'refs' => [ 'TaxRegistration$additionalTaxInformation' => '<p> Additional tax information associated with your TRN. </p>', 'TaxRegistrationWithJurisdiction$additionalTaxInformation' => '<p>Additional tax information associated with your TRN. </p>', ], ], 'Address' => [ 'base' => '<p> The details of the address associated with the TRN information. </p>', 'refs' => [ 'AccountMetaData$address' => NULL, 'TaxRegistration$legalAddress' => '<p> The legal address associated with your TRN registration. </p>', 'TaxRegistrationEntry$legalAddress' => '<p>The legal address associated with your TRN.</p> <note> <p>If you\'re setting a TRN in Brazil for the CNPJ tax type, you don\'t need to specify the legal address. </p> <p>For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.</p> </note>', ], ], 'AddressLine1' => [ 'base' => NULL, 'refs' => [ 'Address$addressLine1' => '<p>The first line of the address. </p>', ], ], 'AddressLine2' => [ 'base' => NULL, 'refs' => [ 'Address$addressLine2' => '<p>The second line of the address, if applicable. </p>', ], ], 'AddressLine3' => [ 'base' => NULL, 'refs' => [ 'Address$addressLine3' => '<p> The third line of the address, if applicable. Currently, the Tax Settings API accepts the <code>addressLine3</code> parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you must enter the <code>addressLine3</code> and specify the building number for the address. For example, you might enter <code>1234</code>.</p>', ], ], 'AddressRoleMap' => [ 'base' => NULL, 'refs' => [ 'AccountMetaData$addressRoleMap' => '<p> Address roles associated with the account containing country code information. </p>', ], ], 'AddressRoleType' => [ 'base' => NULL, 'refs' => [ 'AccountMetaData$addressType' => '<p> The type of address associated with the legal profile. </p>', 'AddressRoleMap$key' => NULL, ], ], 'BatchDeleteTaxRegistrationError' => [ 'base' => '<p> The error object for representing failures in the <code>BatchDeleteTaxRegistration</code> operation. </p>', 'refs' => [ 'BatchDeleteTaxRegistrationErrors$member' => NULL, ], ], 'BatchDeleteTaxRegistrationErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTaxRegistrationResponse$errors' => '<p>The list of errors for the accounts the TRN information could not be deleted for. </p>', ], ], 'BatchDeleteTaxRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTaxRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutTaxRegistrationError' => [ 'base' => '<p> The error object for representing failures in the <code>BatchPutTaxRegistration</code> operation. </p>', 'refs' => [ 'BatchPutTaxRegistrationErrors$member' => NULL, ], ], 'BatchPutTaxRegistrationErrors' => [ 'base' => NULL, 'refs' => [ 'BatchPutTaxRegistrationResponse$errors' => '<p>List of errors for the accounts the TRN information could not be added or updated to. </p>', ], ], 'BatchPutTaxRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutTaxRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CanadaAdditionalInfo$isResellerAccount' => '<p> The value for this parameter must be <code>true</code> if the <code>provincialSalesTaxId</code> value is provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces. </p> <p>To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm that purchases from this account were made for resale. Otherwise, remove the PST or RST number from the <code>provincialSalesTaxId</code> parameter from your request.</p>', 'PolandAdditionalInfo$isGroupVatEnabled' => '<p> True if your business is a member of a VAT group with a NIP active for VAT purposes. Otherwise, this is false. </p>', ], ], 'BrazilAdditionalInfo' => [ 'base' => '<p>Additional tax information associated with your TRN in Brazil.</p>', 'refs' => [ 'AdditionalInfoResponse$brazilAdditionalInfo' => '<p>Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this information in your response when any additional information is present with your TRN in Brazil.</p>', ], ], 'BusinessRepresentativeName' => [ 'base' => NULL, 'refs' => [ 'SouthKoreaAdditionalInfo$businessRepresentativeName' => '<p>The business legal name based on the most recently uploaded tax registration certificate.</p>', ], ], 'CanadaAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Canada .</p>', 'refs' => [ 'AdditionalInfoRequest$canadaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Canada.</p>', 'AdditionalInfoResponse$canadaAdditionalInfo' => '<p>Additional tax information associated with your TRN in Canada. </p>', ], ], 'CanadaProvincialSalesTaxIdString' => [ 'base' => NULL, 'refs' => [ 'CanadaAdditionalInfo$provincialSalesTaxId' => '<p> The provincial sales tax ID for your TRN in Canada. This parameter can represent the following: </p> <ul> <li> <p>Provincial sales tax ID number for British Columbia and Saskatchewan provinces</p> </li> <li> <p>Manitoba retail sales tax ID number for Manitoba province</p> </li> <li> <p>Quebec sales tax ID number for Quebec province</p> </li> </ul> <p>The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For other provinces, the Tax Settings API doesn\'t accept this parameter. </p>', ], ], 'CanadaQuebecSalesTaxNumberString' => [ 'base' => NULL, 'refs' => [ 'CanadaAdditionalInfo$canadaQuebecSalesTaxNumber' => '<p> The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number. </p>', ], ], 'CanadaRetailSalesTaxNumberString' => [ 'base' => NULL, 'refs' => [ 'CanadaAdditionalInfo$canadaRetailSalesTaxNumber' => '<p> Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services for resale in Manitoba must provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number in Manitoba or are not purchasing Amazon Web Services for resale. </p>', ], ], 'CcmCode' => [ 'base' => NULL, 'refs' => [ 'BrazilAdditionalInfo$ccmCode' => '<p>The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil. This only applies for a CNPJ tax type for the São Paulo municipality.</p>', ], ], 'CertifiedEmailId' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$certifiedEmailId' => '<p>The email address to receive VAT invoices.</p>', 'TaxRegistrationEntry$certifiedEmailId' => '<p>The email address to receive VAT invoices.</p>', 'TaxRegistrationWithJurisdiction$certifiedEmailId' => '<p>The email address to receive VAT invoices.</p>', ], ], 'CigNumber' => [ 'base' => NULL, 'refs' => [ 'ItalyAdditionalInfo$cigNumber' => '<p> The tender procedure identification code. </p>', ], ], 'City' => [ 'base' => NULL, 'refs' => [ 'Address$city' => '<p>The city that the address is in. </p>', ], ], 'ConflictException' => [ 'base' => '<p>The exception when the input is creating conflict with the given state.</p>', 'refs' => [], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'Address$countryCode' => '<p>The country code for the country that the address is in. </p>', 'Jurisdiction$countryCode' => '<p> The country code of the jurisdiction. </p>', ], ], 'CupNumber' => [ 'base' => NULL, 'refs' => [ 'ItalyAdditionalInfo$cupNumber' => '<p> Additional tax information to specify for a TRN in Italy. This is managed by the Interministerial Committee for Economic Planning (CIPE) which characterizes every public investment project (Individual Project Code). </p>', ], ], 'DateOfBirth' => [ 'base' => NULL, 'refs' => [ 'VerificationDetails$dateOfBirth' => '<p>Date of birth to verify your submitted TRN. Use the <code>YYYY-MM-DD</code> format.</p>', ], ], 'DeleteTaxRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTaxRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationFilePath' => [ 'base' => NULL, 'refs' => [ 'GetTaxRegistrationDocumentResponse$destinationFilePath' => '<p>The file path of the Amazon S3 bucket where you want to download your tax document to.</p>', ], ], 'DestinationS3Location' => [ 'base' => '<p>The location of the Amazon S3 bucket that you specify to download your tax documents to.</p>', 'refs' => [ 'GetTaxRegistrationDocumentRequest$destinationS3Location' => '<p>The Amazon S3 bucket that you specify to download your tax documents to.</p>', ], ], 'District' => [ 'base' => NULL, 'refs' => [ 'Address$districtOrCounty' => '<p>The district or county the address is located. </p> <note> <p>For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil, use <code>districtOrCounty</code> for the neighborhood name.</p> </note>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTaxRegistrationError$code' => '<p> The error code for an individual failure in BatchDeleteTaxRegistration operation. </p>', 'BatchPutTaxRegistrationError$code' => '<p> The error code for an individual failure in the <code>BatchPutTaxRegistration</code> operation. </p>', 'ConflictException$errorCode' => '<p>409</p>', 'InternalServerException$errorCode' => '<p>500</p>', 'ResourceNotFoundException$errorCode' => '<p>404</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTaxRegistrationError$message' => '<p> The error message for an individual failure in the <code>BatchDeleteTaxRegistration</code> operation. </p>', 'BatchPutTaxRegistrationError$message' => '<p> The error message for an individual failure in the <code>BatchPutTaxRegistration</code> operation. </p>', 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'EstoniaAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Estonia.</p>', 'refs' => [ 'AdditionalInfoRequest$estoniaAdditionalInfo' => '<p> Additional tax information to specify for a TRN in Estonia.</p>', 'AdditionalInfoResponse$estoniaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Estonia. </p>', ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$name' => '<p>The name of the parameter that caused a <code>ValidationException</code> error.</p>', ], ], 'GeorgiaAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Georgia. </p>', 'refs' => [ 'AdditionalInfoRequest$georgiaAdditionalInfo' => '<p> Additional tax information to specify for a TRN in Georgia. </p>', 'AdditionalInfoResponse$georgiaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Georgia. </p>', ], ], 'GetTaxRegistrationDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTaxRegistrationDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTaxRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTaxRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'IndiaAdditionalInfo' => [ 'base' => '<p> Additional tax information in India. </p>', 'refs' => [ 'AdditionalInfoResponse$indiaAdditionalInfo' => '<p> Additional tax information in India. </p>', ], ], 'IndividualRegistrationNumber' => [ 'base' => NULL, 'refs' => [ 'PolandAdditionalInfo$individualRegistrationNumber' => '<p> The individual tax registration number (NIP). Individual NIP is valid for other taxes excluding VAT purposes. </p>', ], ], 'Industries' => [ 'base' => NULL, 'refs' => [ 'TurkeyAdditionalInfo$industries' => '<p>The industry information that tells the Tax Settings API if you\'re subject to additional withholding taxes. This information required for business-to-business (B2B) customers. This information is conditionally mandatory for B2B customers who are subject to KDV tax.</p>', ], ], 'InheritanceObtainedReason' => [ 'base' => NULL, 'refs' => [ 'TaxInheritanceDetails$inheritanceObtainedReason' => '<p> Tax inheritance reason information associated with the account. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>The exception thrown when an unexpected error occurs when processing a request.</p>', 'refs' => [], ], 'IsraelAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Israel.</p>', 'refs' => [ 'AdditionalInfoRequest$israelAdditionalInfo' => '<p> Additional tax information to specify for a TRN in Israel.</p>', 'AdditionalInfoResponse$israelAdditionalInfo' => '<p> Additional tax information associated with your TRN in Israel.</p>', ], ], 'IsraelCustomerType' => [ 'base' => NULL, 'refs' => [ 'IsraelAdditionalInfo$customerType' => '<p> Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>. Use <code>Business</code>for entities such as not-for-profit and financial institutions.</p>', ], ], 'IsraelDealerType' => [ 'base' => NULL, 'refs' => [ 'IsraelAdditionalInfo$dealerType' => '<p> Dealer type for your TRN in Israel. If you\'re not a local authorized dealer with an Israeli VAT ID, specify your tax identification number so that Amazon Web Services can send you a compliant tax invoice.</p>', ], ], 'ItalyAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Italy. </p>', 'refs' => [ 'AdditionalInfoRequest$italyAdditionalInfo' => '<p> Additional tax information to specify for a TRN in Italy. </p>', 'AdditionalInfoResponse$italyAdditionalInfo' => '<p> Additional tax information associated with your TRN in Italy. </p>', ], ], 'ItemOfBusiness' => [ 'base' => NULL, 'refs' => [ 'SouthKoreaAdditionalInfo$itemOfBusiness' => '<p>Item of business based on the most recently uploaded tax registration certificate.</p>', ], ], 'Jurisdiction' => [ 'base' => '<p>The jurisdiction details of the TRN information of the customers. This doesn\'t contain full legal address, and contains only country code and state/region/province. </p>', 'refs' => [ 'AddressRoleMap$value' => NULL, 'TaxRegistrationWithJurisdiction$jurisdiction' => '<p> The jurisdiction associated with your TRN information. </p>', ], ], 'KenyaAdditionalInfo' => [ 'base' => '<p>Additional tax information associated with your TRN in Kenya.</p>', 'refs' => [ 'AdditionalInfoRequest$kenyaAdditionalInfo' => '<p>Additional tax information to specify for a TRN in Kenya.</p>', 'AdditionalInfoResponse$kenyaAdditionalInfo' => '<p>Additional tax information associated with your TRN in Kenya.</p>', ], ], 'KepEmailId' => [ 'base' => NULL, 'refs' => [ 'TurkeyAdditionalInfo$kepEmailId' => '<p>The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is optional for business-to-business (B2B) and business-to-government (B2G) customers. It\'s not required for business-to-consumer (B2C) customers.</p>', ], ], 'LegalName' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$legalName' => '<p> The legal name associated with your TRN registration. </p>', 'TaxRegistrationEntry$legalName' => '<p>The legal name associated with your TRN. </p> <note> <p>If you\'re setting a TRN in Brazil, you don\'t need to specify the legal name. For TRNs in other countries, you must specify the legal name.</p> </note>', 'TaxRegistrationWithJurisdiction$legalName' => '<p>The legal name associated with your TRN information. </p>', ], ], 'LegalNatureCode' => [ 'base' => NULL, 'refs' => [ 'BrazilAdditionalInfo$legalNatureCode' => '<p>Legal nature of business, based on your TRN in Brazil. This only applies for a CNPJ tax type.</p>', ], ], 'LineOfBusiness' => [ 'base' => NULL, 'refs' => [ 'SouthKoreaAdditionalInfo$lineOfBusiness' => '<p>Line of business based on the most recently uploaded tax registration certificate.</p>', ], ], 'ListTaxRegistrationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTaxRegistrationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalaysiaAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Malaysia.</p>', 'refs' => [ 'AdditionalInfoRequest$malaysiaAdditionalInfo' => '<p> Additional tax information to specify for a TRN in Malaysia.</p>', 'AdditionalInfoResponse$malaysiaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Malaysia. </p>', ], ], 'MalaysiaServiceTaxCode' => [ 'base' => NULL, 'refs' => [ 'MalaysiaServiceTaxCodesList$member' => NULL, ], ], 'MalaysiaServiceTaxCodesList' => [ 'base' => NULL, 'refs' => [ 'MalaysiaAdditionalInfo$serviceTaxCodes' => '<p>List of service tax codes for your TRN in Malaysia.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTaxRegistrationsRequest$maxResults' => '<p>Number of <code>accountDetails</code> results you want in one response. </p>', ], ], 'PaginationTokenString' => [ 'base' => NULL, 'refs' => [ 'ListTaxRegistrationsRequest$nextToken' => '<p>The token to retrieve the next set of results. </p>', 'ListTaxRegistrationsResponse$nextToken' => '<p> The token to retrieve the next set of results. </p>', ], ], 'Pan' => [ 'base' => NULL, 'refs' => [ 'IndiaAdditionalInfo$pan' => '<p> India pan information associated with the account. </p>', ], ], 'PersonType' => [ 'base' => NULL, 'refs' => [ 'GeorgiaAdditionalInfo$personType' => '<p> The legal person or physical person assigned to this TRN in Georgia. </p>', 'KenyaAdditionalInfo$personType' => '<p>The legal person or physical person assigned to this TRN in Kenya.</p>', ], ], 'PolandAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Poland. </p>', 'refs' => [ 'AdditionalInfoRequest$polandAdditionalInfo' => '<p> Additional tax information associated with your TRN in Poland. </p>', 'AdditionalInfoResponse$polandAdditionalInfo' => '<p> Additional tax information associated with your TRN in Poland. </p>', ], ], 'PostalCode' => [ 'base' => NULL, 'refs' => [ 'Address$postalCode' => '<p> The postal code associated with the address. </p>', ], ], 'PutTaxRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutTaxRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationId' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$registrationId' => '<p> Your tax registration unique identifier. </p>', 'TaxRegistrationEntry$registrationId' => '<p>Your tax registration unique identifier. </p>', 'TaxRegistrationWithJurisdiction$registrationId' => '<p>Your tax registration unique identifier. </p>', ], ], 'RegistrationType' => [ 'base' => NULL, 'refs' => [ 'SpainAdditionalInfo$registrationType' => '<p>The registration type in Spain.</p>', ], ], 'RegistryCommercialCode' => [ 'base' => NULL, 'refs' => [ 'EstoniaAdditionalInfo$registryCommercialCode' => '<p> Registry commercial code (RCC) for your TRN in Estonia. This value is an eight-numeric string, such as <code>12345678</code>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The exception thrown when the input doesn\'t have a resource associated to it.</p>', 'refs' => [], ], 'RomaniaAdditionalInfo' => [ 'base' => '<p>Additional tax information to specify for a TRN in Romania. </p>', 'refs' => [ 'AdditionalInfoRequest$romaniaAdditionalInfo' => '<p>Additional tax information to specify for a TRN in Romania.</p>', 'AdditionalInfoResponse$romaniaAdditionalInfo' => '<p>Additional tax information to specify for a TRN in Romania.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'DestinationS3Location$bucket' => '<p>The name of your Amazon S3 bucket that you specify to download your tax documents to.</p>', 'SourceS3Location$bucket' => '<p>The name of your Amazon S3 bucket that your tax document is located.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'SourceS3Location$key' => '<p>The object key of your tax document object in Amazon S3.</p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'DestinationS3Location$prefix' => '<p>The Amazon S3 object prefix that you specify for your tax document file.</p>', ], ], 'SaudiArabiaAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Saudi Arabia. </p>', 'refs' => [ 'AdditionalInfoRequest$saudiArabiaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Saudi Arabia. </p>', 'AdditionalInfoResponse$saudiArabiaAdditionalInfo' => '<p> Additional tax information associated with your TRN in Saudi Arabia. </p>', ], ], 'SaudiArabiaTaxRegistrationNumberType' => [ 'base' => NULL, 'refs' => [ 'SaudiArabiaAdditionalInfo$taxRegistrationNumberType' => '<p> The tax registration number type. </p>', ], ], 'SdiAccountId' => [ 'base' => NULL, 'refs' => [ 'ItalyAdditionalInfo$sdiAccountId' => '<p> Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario to receive your invoices via web service (API) or FTP. </p>', ], ], 'SecondaryTaxId' => [ 'base' => NULL, 'refs' => [ 'TurkeyAdditionalInfo$secondaryTaxId' => '<p> Secondary tax ID (“harcama birimi VKN”si”). If one isn\'t provided, we will use your VKN as the secondary ID. </p>', ], ], 'Sector' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$sector' => '<p>The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government. Note that certain values may not applicable for the request country. Please refer to country specific information in API document. </p>', 'TaxRegistrationEntry$sector' => '<p>The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document. </p>', 'TaxRegistrationWithJurisdiction$sector' => '<p>The industry that describes your business. For business-to-business (B2B) customers, specify Business. For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.Note that certain values may not applicable for the request country. Please refer to country specific information in API document. </p>', ], ], 'Seller' => [ 'base' => NULL, 'refs' => [ 'AccountMetaData$seller' => '<p> Seller information associated with the account. </p>', ], ], 'SourceS3Location' => [ 'base' => '<p>The Amazon S3 bucket in your account where your tax document is located.</p>', 'refs' => [ 'TaxRegistrationDocument$s3Location' => '<p>The Amazon S3 location where your tax registration document is stored.</p>', ], ], 'SouthKoreaAdditionalInfo' => [ 'base' => '<p>Additional tax information associated with your TRN in South Korea.</p>', 'refs' => [ 'AdditionalInfoRequest$southKoreaAdditionalInfo' => '<p>Additional tax information to specify for a TRN in South Korea.</p>', 'AdditionalInfoResponse$southKoreaAdditionalInfo' => '<p>Additional tax information associated with your TRN in South Korea.</p>', ], ], 'SpainAdditionalInfo' => [ 'base' => '<p>Additional tax information associated with your TRN in Spain.</p>', 'refs' => [ 'AdditionalInfoRequest$spainAdditionalInfo' => '<p>Additional tax information to specify for a TRN in Spain.</p>', 'AdditionalInfoResponse$spainAdditionalInfo' => '<p>Additional tax information associated with your TRN in Spain.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'Address$stateOrRegion' => '<p>The state, region, or province that the address is located.</p> <p>If this is required for tax settings, use the same name as shown on the <b>Tax Settings</b> page.</p>', 'Jurisdiction$stateOrRegion' => '<p> The state, region, or province associated with the country of the jurisdiction, if applicable. </p>', ], ], 'TaxCode' => [ 'base' => NULL, 'refs' => [ 'ItalyAdditionalInfo$taxCode' => '<p>List of service tax codes for your TRN in Italy. You can use your customer tax code as part of a VAT Group. </p>', ], ], 'TaxDocumentAccessToken' => [ 'base' => NULL, 'refs' => [ 'TaxDocumentMetadata$taxDocumentAccessToken' => '<p>The tax document access token, which contains information that the Tax Settings API uses to locate the tax document.</p> <note> <p>If you update your tax registration, the existing <code>taxDocumentAccessToken</code> won\'t be valid. To get the latest token, call the <code>GetTaxRegistration</code> or <code>ListTaxRegistrations</code> API operation. This token is valid for 24 hours.</p> </note>', ], ], 'TaxDocumentMetadata' => [ 'base' => '<p>The metadata for your tax document.</p>', 'refs' => [ 'GetTaxRegistrationDocumentRequest$taxDocumentMetadata' => '<p>The metadata for your tax document.</p>', 'TaxDocumentMetadatas$member' => NULL, ], ], 'TaxDocumentMetadatas' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$taxDocumentMetadatas' => '<p>The metadata for your tax document.</p>', 'TaxRegistrationWithJurisdiction$taxDocumentMetadatas' => '<p>The metadata for your tax document.</p>', ], ], 'TaxDocumentName' => [ 'base' => NULL, 'refs' => [ 'TaxDocumentMetadata$taxDocumentName' => '<p>The name of your tax document.</p>', ], ], 'TaxInheritanceDetails' => [ 'base' => '<p> Tax inheritance information associated with the account. </p>', 'refs' => [ 'AccountDetails$taxInheritanceDetails' => '<p> Tax inheritance information associated with the account. </p>', ], ], 'TaxOffice' => [ 'base' => NULL, 'refs' => [ 'TurkeyAdditionalInfo$taxOffice' => '<p>The tax office where you\'re registered. You can enter this information as a string. The Tax Settings API will add this information to your invoice. This parameter is required for business-to-business (B2B) and business-to-government customers. It\'s not required for business-to-consumer (B2C) customers.</p>', ], ], 'TaxRegistration' => [ 'base' => '<p>Your TRN information. </p>', 'refs' => [ 'GetTaxRegistrationResponse$taxRegistration' => '<p>TRN information of the account mentioned in the request. </p>', ], ], 'TaxRegistrationDocument' => [ 'base' => '<p>Tax registration document information.</p>', 'refs' => [ 'TaxRegistrationDocuments$member' => NULL, ], ], 'TaxRegistrationDocuments' => [ 'base' => NULL, 'refs' => [ 'VerificationDetails$taxRegistrationDocuments' => '<p>The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South Korea and Spain.</p>', ], ], 'TaxRegistrationEntry' => [ 'base' => '<p>The TRN information you provide when you add a new TRN, or update. </p>', 'refs' => [ 'BatchPutTaxRegistrationRequest$taxRegistrationEntry' => '<p>Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>. </p>', 'PutTaxRegistrationRequest$taxRegistrationEntry' => '<p> Your TRN information that will be stored to the account mentioned in <code>accountId</code>. </p>', ], ], 'TaxRegistrationNumberType' => [ 'base' => NULL, 'refs' => [ 'RomaniaAdditionalInfo$taxRegistrationNumberType' => '<p> The tax registration number type. The value can be <code>TaxRegistrationNumber</code> or <code>LocalRegistrationNumber</code>. </p>', ], ], 'TaxRegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'BatchPutTaxRegistrationResponse$status' => '<p>The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>. </p>', 'PutTaxRegistrationResponse$status' => '<p>The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>. </p>', 'TaxRegistration$status' => '<p> The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>, or <code>Rejected</code>. </p>', 'TaxRegistrationWithJurisdiction$status' => '<p>The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>, or <code>Rejected</code>. </p>', ], ], 'TaxRegistrationType' => [ 'base' => NULL, 'refs' => [ 'TaxRegistration$registrationType' => '<p>Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>. </p>', 'TaxRegistrationEntry$registrationType' => '<p> Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>. </p>', 'TaxRegistrationWithJurisdiction$registrationType' => '<p> The type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>. </p>', ], ], 'TaxRegistrationWithJurisdiction' => [ 'base' => '<p>Your TRN information with jurisdiction details. This doesn\'t contain the full legal address associated with the TRN information.</p>', 'refs' => [ 'AccountDetails$taxRegistration' => '<p>Your TRN information. Instead of having full legal address, here TRN information will have jurisdiction details (for example, country code and state/region/province if applicable). </p>', ], ], 'TurkeyAdditionalInfo' => [ 'base' => '<p>Additional tax information associated with your TRN in Turkey.</p>', 'refs' => [ 'AdditionalInfoRequest$turkeyAdditionalInfo' => '<p>Additional tax information to specify for a TRN in Turkey.</p>', 'AdditionalInfoResponse$turkeyAdditionalInfo' => '<p>Additional tax information associated with your TRN in Turkey.</p>', ], ], 'UkraineAdditionalInfo' => [ 'base' => '<p> Additional tax information associated with your TRN in Ukraine. </p>', 'refs' => [ 'AdditionalInfoRequest$ukraineAdditionalInfo' => '<p> Additional tax information associated with your TRN in Ukraine. </p>', 'AdditionalInfoResponse$ukraineAdditionalInfo' => '<p> Additional tax information associated with your TRN in Ukraine. </p>', ], ], 'UkraineTrnType' => [ 'base' => NULL, 'refs' => [ 'UkraineAdditionalInfo$ukraineTrnType' => '<p> The tax registration type. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The exception when the input doesn\'t pass validation for at least one of the input parameters. </p>', 'refs' => [], ], 'ValidationExceptionErrorCode' => [ 'base' => NULL, 'refs' => [ 'ValidationException$errorCode' => '<p>400</p>', ], ], 'ValidationExceptionField' => [ 'base' => '<p>The information about the specified parameter in the request that caused an error.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>400</p>', ], ], 'VerificationDetails' => [ 'base' => '<p>Required information to verify your TRN.</p>', 'refs' => [ 'TaxRegistrationEntry$verificationDetails' => '<p>Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter when you set a TRN in Brazil that is the CPF tax type.</p> <note> <p>Don\'t specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country. </p> </note>', ], ], ],];
