<?php
// This file was auto-generated from sdk-root/src/data/timestream-influxdb/2023-01-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Timestream for InfluxDB is a managed time-series database engine that makes it easy for application developers and DevOps teams to run InfluxDB databases on AWS for near real-time time-series applications using open-source APIs. With Amazon Timestream for InfluxDB, it is easy to set up, operate, and scale time-series workloads that can answer queries with single-digit millisecond query response time.</p>', 'operations' => [ 'CreateDbInstance' => '<p>Creates a new Timestream for InfluxDB DB instance.</p>', 'CreateDbParameterGroup' => '<p>Creates a new Timestream for InfluxDB DB parameter group to associate with DB instances.</p>', 'DeleteDbInstance' => '<p>Deletes a Timestream for InfluxDB DB instance.</p>', 'GetDbInstance' => '<p>Returns a Timestream for InfluxDB DB instance.</p>', 'GetDbParameterGroup' => '<p>Returns a Timestream for InfluxDB DB parameter group.</p>', 'ListDbInstances' => '<p>Returns a list of Timestream for InfluxDB DB instances.</p>', 'ListDbParameterGroups' => '<p>Returns a list of Timestream for InfluxDB DB parameter groups.</p>', 'ListTagsForResource' => '<p>A list of tags applied to the resource.</p>', 'TagResource' => '<p>Tags are composed of a Key/Value pairs. You can use tags to categorize and track your Timestream for InfluxDB resources.</p>', 'UntagResource' => '<p>Removes the tag from the specified resource.</p>', 'UpdateDbInstance' => '<p>Updates a Timestream for InfluxDB DB instance.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AllocatedStorage' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$allocatedStorage' => '<p>The amount of storage to allocate for your DB storage type in GiB (gibibytes).</p>', 'CreateDbInstanceOutput$allocatedStorage' => '<p>The amount of storage allocated for your DB storage type (in gibibytes).</p>', 'DbInstanceSummary$allocatedStorage' => '<p>The amount of storage to allocate for your DbStorageType in GiB (gibibytes).</p>', 'DeleteDbInstanceOutput$allocatedStorage' => '<p>The amount of storage allocated for your DB storage type (in gibibytes).</p>', 'GetDbInstanceOutput$allocatedStorage' => '<p>The amount of storage allocated for your DB storage type (in gibibytes).</p>', 'UpdateDbInstanceOutput$allocatedStorage' => '<p>The amount of storage allocated for your DB storage type (in gibibytes).</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceOutput$arn' => '<p>The Amazon Resource Name (ARN) of the DB instance.</p>', 'CreateDbParameterGroupOutput$arn' => '<p>The Amazon Resource Name (ARM) of the DB parameter group.</p>', 'DbInstanceSummary$arn' => '<p>The Amazon Resource Name (ARN) of the DB instance.</p>', 'DbParameterGroupSummary$arn' => '<p>The Amazon Resource Name (ARN) of the DB parameter group.</p>', 'DeleteDbInstanceOutput$arn' => '<p>The Amazon Resource Name (ARN) of the DB instance.</p>', 'GetDbInstanceOutput$arn' => '<p>The Amazon Resource Name (ARN) of the DB instance.</p>', 'GetDbParameterGroupOutput$arn' => '<p>The Amazon Resource Name (ARN) of the DB parameter group.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the tagged resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the tagged resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the tagged resource.</p>', 'UpdateDbInstanceOutput$arn' => '<p>The Amazon Resource Name (ARN) of the DB instance.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$publiclyAccessible' => '<p>Configures the DB instance with a public IP to facilitate access.</p>', 'CreateDbInstanceOutput$publiclyAccessible' => '<p>Indicates if the DB instance has a public IP to facilitate access.</p>', 'DeleteDbInstanceOutput$publiclyAccessible' => '<p>Indicates if the DB instance has a public IP to facilitate access.</p>', 'GetDbInstanceOutput$publiclyAccessible' => '<p>Indicates if the DB instance has a public IP to facilitate access.</p>', 'InfluxDBv2Parameters$fluxLogEnabled' => '<p>Include option to show detailed logs for Flux queries.</p> <p>Default: false</p>', 'InfluxDBv2Parameters$noTasks' => '<p>Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start InfluxDB without scheduling or executing tasks.</p> <p>Default: false</p>', 'InfluxDBv2Parameters$metricsDisabled' => '<p>Disable the HTTP /metrics endpoint which exposes <a href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB metrics</a>.</p> <p>Default: false</p>', 'S3Configuration$enabled' => '<p>Indicates whether log delivery to the S3 bucket is enabled.</p>', 'UpdateDbInstanceOutput$publiclyAccessible' => '<p>Indicates if the DB instance has a public IP to facilitate access.</p>', ], ], 'Bucket' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$bucket' => '<p>The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request conflicts with an existing resource in Timestream for InfluxDB.</p>', 'refs' => [], ], 'CreateDbInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDbInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDbParameterGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDbParameterGroupInputDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateDbParameterGroupInput$description' => '<p>A description of the DB parameter group.</p>', ], ], 'CreateDbParameterGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DbInstanceId' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceOutput$id' => '<p>A service-generated unique identifier.</p>', 'DbInstanceSummary$id' => '<p>The service-generated unique identifier of the DB instance.</p>', 'DeleteDbInstanceOutput$id' => '<p>A service-generated unique identifier.</p>', 'GetDbInstanceOutput$id' => '<p>A service-generated unique identifier.</p>', 'UpdateDbInstanceOutput$id' => '<p>A service-generated unique identifier.</p>', ], ], 'DbInstanceIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteDbInstanceInput$identifier' => '<p>The id of the DB instance.</p>', 'GetDbInstanceInput$identifier' => '<p>The id of the DB instance.</p>', 'UpdateDbInstanceInput$identifier' => '<p>The id of the DB instance.</p>', ], ], 'DbInstanceName' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$name' => '<p>The name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region.</p>', 'CreateDbInstanceOutput$name' => '<p>The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands.</p>', 'DbInstanceSummary$name' => '<p>This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and AWS CLI commands.</p>', 'DeleteDbInstanceOutput$name' => '<p>The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands.</p>', 'GetDbInstanceOutput$name' => '<p>The customer-supplied name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands.</p>', 'UpdateDbInstanceOutput$name' => '<p>This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and AWS CLI commands.</p>', ], ], 'DbInstanceSummary' => [ 'base' => '<p>Contains a summary of a DB instance.</p>', 'refs' => [ 'DbInstanceSummaryList$member' => NULL, ], ], 'DbInstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDbInstancesOutput$items' => '<p>A list of Timestream for InfluxDB DB instance summaries.</p>', ], ], 'DbInstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$dbInstanceType' => '<p>The Timestream for InfluxDB DB instance type to run InfluxDB on.</p>', 'CreateDbInstanceOutput$dbInstanceType' => '<p>The Timestream for InfluxDB instance type that InfluxDB runs on.</p>', 'DbInstanceSummary$dbInstanceType' => '<p>The Timestream for InfluxDB instance type to run InfluxDB on.</p>', 'DeleteDbInstanceOutput$dbInstanceType' => '<p>The Timestream for InfluxDB instance type that InfluxDB runs on.</p>', 'GetDbInstanceOutput$dbInstanceType' => '<p>The Timestream for InfluxDB instance type that InfluxDB runs on.</p>', 'UpdateDbInstanceOutput$dbInstanceType' => '<p>The Timestream for InfluxDB instance type that InfluxDB runs on.</p>', ], ], 'DbParameterGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateDbParameterGroupOutput$id' => '<p>A service-generated unique identifier.</p>', 'DbParameterGroupSummary$id' => '<p>A service-generated unique identifier.</p>', 'GetDbParameterGroupOutput$id' => '<p>A service-generated unique identifier.</p>', ], ], 'DbParameterGroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.</p>', 'CreateDbInstanceOutput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group assigned to your DB instance.</p>', 'DeleteDbInstanceOutput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group assigned to your DB instance.</p>', 'GetDbInstanceOutput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group assigned to your DB instance.</p>', 'GetDbParameterGroupInput$identifier' => '<p>The id of the DB parameter group.</p>', 'UpdateDbInstanceInput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group to assign to your DB instance. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.</p>', 'UpdateDbInstanceOutput$dbParameterGroupIdentifier' => '<p>The id of the DB parameter group assigned to your DB instance.</p>', ], ], 'DbParameterGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateDbParameterGroupInput$name' => '<p>The name of the DB parameter group. The name must be unique per customer and per region.</p>', 'CreateDbParameterGroupOutput$name' => '<p>The customer-supplied name that uniquely identifies the DB parameter group when interacting with the Amazon Timestream for InfluxDB API and CLI commands.</p>', 'DbParameterGroupSummary$name' => '<p>This customer-supplied name uniquely identifies the parameter group.</p>', 'GetDbParameterGroupOutput$name' => '<p>The customer-supplied name that uniquely identifies the DB parameter group when interacting with the Amazon Timestream for InfluxDB API and CLI commands.</p>', ], ], 'DbParameterGroupSummary' => [ 'base' => '<p>Contains a summary of a DB parameter group.</p>', 'refs' => [ 'DbParameterGroupSummaryList$member' => NULL, ], ], 'DbParameterGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDbParameterGroupsOutput$items' => '<p>A list of Timestream for InfluxDB DB parameter group summaries.</p>', ], ], 'DbStorageType' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$dbStorageType' => '<p>The Timestream for InfluxDB DB storage type to read and write InfluxDB data.</p> <p>You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements:</p> <ul> <li> <p>Influx IO Included 3000 IOPS</p> </li> <li> <p>Influx IO Included 12000 IOPS</p> </li> <li> <p>Influx IO Included 16000 IOPS</p> </li> </ul>', 'CreateDbInstanceOutput$dbStorageType' => '<p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>', 'DbInstanceSummary$dbStorageType' => '<p>The storage type for your DB instance.</p>', 'DeleteDbInstanceOutput$dbStorageType' => '<p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>', 'GetDbInstanceOutput$dbStorageType' => '<p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>', 'UpdateDbInstanceOutput$dbStorageType' => '<p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>', ], ], 'DeleteDbInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDbInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$deploymentType' => '<p>Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability.</p>', 'CreateDbInstanceOutput$deploymentType' => '<p>Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.</p>', 'DbInstanceSummary$deploymentType' => '<p>Single-Instance or with a MultiAZ Standby for High availability.</p>', 'DeleteDbInstanceOutput$deploymentType' => '<p>Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.</p>', 'GetDbInstanceOutput$deploymentType' => '<p>Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.</p>', 'UpdateDbInstanceOutput$deploymentType' => '<p>Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.</p>', ], ], 'GetDbInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDbInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDbParameterGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDbParameterGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'InfluxDBv2Parameters' => [ 'base' => '<p>All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.</p>', 'refs' => [ 'Parameters$InfluxDBv2' => '<p>All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.</p>', ], ], 'InfluxDBv2ParametersQueryConcurrencyInteger' => [ 'base' => NULL, 'refs' => [ 'InfluxDBv2Parameters$queryConcurrency' => '<p>Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.</p> <p>Default: 0</p>', ], ], 'InfluxDBv2ParametersQueryQueueSizeInteger' => [ 'base' => NULL, 'refs' => [ 'InfluxDBv2Parameters$queryQueueSize' => '<p>Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.</p> <p>Default: 0</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds the caller should wait before retrying.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'ListDbInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDbInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDbParameterGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDbParameterGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogDeliveryConfiguration' => [ 'base' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', 'refs' => [ 'CreateDbInstanceInput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to a specified S3 bucket.</p>', 'CreateDbInstanceOutput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', 'DeleteDbInstanceOutput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', 'GetDbInstanceOutput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', 'UpdateDbInstanceInput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', 'UpdateDbInstanceOutput$logDeliveryConfiguration' => '<p>Configuration for sending InfluxDB engine logs to send to specified S3 bucket.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'InfluxDBv2Parameters$logLevel' => '<p>Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.</p> <p>Default: info</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDbInstancesInput$maxResults' => '<p>The maximum number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListDbParameterGroupsInput$maxResults' => '<p>The maximum number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDbInstancesInput$nextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListDbInstancesOutput$nextToken' => '<p>Token from a previous call of the operation. When this value is provided, the service returns results from where the previous response left off.</p>', 'ListDbParameterGroupsInput$nextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListDbParameterGroupsOutput$nextToken' => '<p>Token from a previous call of the operation. When this value is provided, the service returns results from where the previous response left off.</p>', ], ], 'Organization' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$organization' => '<p>The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users.</p>', ], ], 'Parameters' => [ 'base' => '<p>The parameters that comprise the parameter group.</p>', 'refs' => [ 'CreateDbParameterGroupInput$parameters' => '<p>A list of the parameters that comprise the DB parameter group.</p>', 'CreateDbParameterGroupOutput$parameters' => '<p>A list of the parameters that comprise the DB parameter group.</p>', 'GetDbParameterGroupOutput$parameters' => '<p>The parameters that comprise the DB parameter group.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$password' => '<p>The password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a Secret created in AWS SecretManager in your account.</p>', ], ], 'RequestTagMap' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$tags' => '<p>A list of key-value pairs to associate with the DB instance.</p>', 'CreateDbParameterGroupInput$tags' => '<p>A list of key-value pairs to associate with the DB parameter group.</p>', 'TagResourceRequest$tags' => '<p>A list of tags used to categorize and track resources.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource was not found or does not exist.</p>', 'refs' => [], ], 'ResponseTagMap' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$tags' => '<p>A list of tags used to categorize and track resources.</p>', ], ], 'S3Configuration' => [ 'base' => '<p>Configuration for S3 bucket log delivery.</p>', 'refs' => [ 'LogDeliveryConfiguration$s3Configuration' => '<p>Configuration for S3 bucket log delivery.</p>', ], ], 'S3ConfigurationBucketNameString' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$bucketName' => '<p>The name of the S3 bucket to deliver logs to.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeds the service quota.</p>', 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceOutput$status' => '<p>The status of the DB instance.</p>', 'DbInstanceSummary$status' => '<p>The status of the DB instance.</p>', 'DeleteDbInstanceOutput$status' => '<p>The status of the DB instance.</p>', 'GetDbInstanceOutput$status' => '<p>The status of the DB instance.</p>', 'UpdateDbInstanceOutput$status' => '<p>The status of the DB instance.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The identifier for the Timestream for InfluxDB resource associated with the request.</p>', 'ConflictException$resourceType' => '<p>The type of Timestream for InfluxDB resource associated with the request.</p>', 'CreateDbInstanceOutput$endpoint' => '<p>The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.</p>', 'CreateDbInstanceOutput$availabilityZone' => '<p>The Availability Zone in which the DB instance resides.</p>', 'CreateDbInstanceOutput$secondaryAvailabilityZone' => '<p>The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.</p>', 'CreateDbInstanceOutput$influxAuthParametersSecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.</p>', 'CreateDbParameterGroupOutput$description' => '<p>The description of the DB parameter group.</p>', 'DbInstanceSummary$endpoint' => '<p>The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.</p>', 'DbParameterGroupSummary$description' => '<p>A description of the DB parameter group.</p>', 'DeleteDbInstanceOutput$endpoint' => '<p>The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.</p>', 'DeleteDbInstanceOutput$availabilityZone' => '<p>The Availability Zone in which the DB instance resides.</p>', 'DeleteDbInstanceOutput$secondaryAvailabilityZone' => '<p>The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.</p>', 'DeleteDbInstanceOutput$influxAuthParametersSecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.</p>', 'GetDbInstanceOutput$endpoint' => '<p>The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.</p>', 'GetDbInstanceOutput$availabilityZone' => '<p>The Availability Zone in which the DB instance resides.</p>', 'GetDbInstanceOutput$secondaryAvailabilityZone' => '<p>The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.</p>', 'GetDbInstanceOutput$influxAuthParametersSecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.</p>', 'GetDbParameterGroupOutput$description' => '<p>A description of the DB parameter group.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The identifier for the Timestream for InfluxDB resource associated with the request.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of Timestream for InfluxDB resource associated with the request.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'UpdateDbInstanceOutput$endpoint' => '<p>The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.</p>', 'UpdateDbInstanceOutput$availabilityZone' => '<p>The Availability Zone in which the DB instance resides.</p>', 'UpdateDbInstanceOutput$secondaryAvailabilityZone' => '<p>The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.</p>', 'UpdateDbInstanceOutput$influxAuthParametersSecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.</p>', 'ValidationException$message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'RequestTagMap$key' => NULL, 'ResponseTagMap$key' => NULL, 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys used to identify the tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'RequestTagMap$value' => NULL, 'ResponseTagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TracingType' => [ 'base' => NULL, 'refs' => [ 'InfluxDBv2Parameters$tracingType' => '<p>Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDbInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDbInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$username' => '<p>The username of the initial admin user created in InfluxDB. Must start with a letter and can\'t end with a hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a Secret created in Amazon Secrets Manager in your account.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by Timestream for InfluxDB.</p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason that validation failed.</p>', ], ], 'VpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'VpcSecurityGroupIdList$member' => NULL, ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$vpcSecurityGroupIds' => '<p>A list of VPC security group IDs to associate with the DB instance.</p>', 'CreateDbInstanceOutput$vpcSecurityGroupIds' => '<p>A list of VPC security group IDs associated with the DB instance.</p>', 'DeleteDbInstanceOutput$vpcSecurityGroupIds' => '<p>A list of VPC security group IDs associated with the DB instance.</p>', 'GetDbInstanceOutput$vpcSecurityGroupIds' => '<p>A list of VPC security group IDs associated with the DB instance.</p>', 'UpdateDbInstanceOutput$vpcSecurityGroupIds' => '<p>A list of VPC security group IDs associated with the DB instance.</p>', ], ], 'VpcSubnetId' => [ 'base' => NULL, 'refs' => [ 'VpcSubnetIdList$member' => NULL, ], ], 'VpcSubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDbInstanceInput$vpcSubnetIds' => '<p>A list of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.</p>', 'CreateDbInstanceOutput$vpcSubnetIds' => '<p>A list of VPC subnet IDs associated with the DB instance.</p>', 'DeleteDbInstanceOutput$vpcSubnetIds' => '<p>A list of VPC subnet IDs associated with the DB instance.</p>', 'GetDbInstanceOutput$vpcSubnetIds' => '<p>A list of VPC subnet IDs associated with the DB instance.</p>', 'UpdateDbInstanceOutput$vpcSubnetIds' => '<p>A list of VPC subnet IDs associated with the DB instance.</p>', ], ], ],];
