<?php
// This file was auto-generated from sdk-root/src/data/timestream-write/2018-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Timestream Write</fullname> <p>Amazon Timestream is a fast, scalable, fully managed time-series database service that makes it easy to store and analyze trillions of time-series data points per day. With Timestream, you can easily store and analyze IoT sensor data to derive insights from your IoT applications. You can analyze industrial telemetry to streamline equipment management and maintenance. You can also store and analyze log data and metrics to improve the performance and availability of your applications. </p> <p>Timestream is built from the ground up to effectively ingest, process, and store time-series data. It organizes data to optimize query processing. It automatically scales based on the volume of data ingested and on the query volume to ensure you receive optimal performance while inserting and querying data. As your data grows over time, Timestream’s adaptive query processing engine spans across storage tiers to provide fast analysis while reducing costs.</p>', 'operations' => [ 'CreateBatchLoadTask' => '<p>Creates a new Timestream batch load task. A batch load task processes data from a CSV source in an S3 location and writes to a Timestream table. A mapping from source to target is defined in a batch load task. Errors and events are written to a report at an S3 location. For the report, if the KMS key is not specified, the report will be encrypted with an S3 managed key when <code>SSE_S3</code> is the option. Otherwise an error is thrown. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. For details, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html">code sample</a>.</p>', 'CreateDatabase' => '<p>Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. For details, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html">code sample</a>. </p>', 'CreateTable' => '<p>Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be at least unique within each Region if they are in the same database. You might have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code sample</a> for details. </p>', 'DeleteDatabase' => '<p>Deletes a given Timestream database. <i>This is an irreversible operation. After a database is deleted, the time-series data from its tables cannot be recovered.</i> </p> <note> <p>All tables in the database must be deleted first, or a ValidationException error will be thrown. </p> <p>Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.</p> </note> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html">code sample</a> for details.</p>', 'DeleteTable' => '<p>Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is deleted, the time-series data stored in the table cannot be recovered. </p> <note> <p>Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.</p> </note> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html">code sample</a> for details.</p>', 'DescribeBatchLoadTask' => '<p>Returns information about the batch load task, including configurations, mappings, progress, and other details. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html">code sample</a> for details.</p>', 'DescribeDatabase' => '<p>Returns information about the database, including the database name, time that the database was created, and the total number of tables found within the database. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html">code sample</a> for details.</p>', 'DescribeEndpoints' => '<p>Returns a list of available endpoints to make Timestream API calls against. This API operation is available through both the Write and Query APIs.</p> <p>Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, <i>we don\'t recommend that you use this API operation unless</i>:</p> <ul> <li> <p>You are using <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints">VPC endpoints (Amazon Web Services PrivateLink) with Timestream</a> </p> </li> <li> <p>Your application uses a programming language that does not yet have SDK support</p> </li> <li> <p>You require better control over the client-side implementation</p> </li> </ul> <p>For detailed information on how and when to use and implement DescribeEndpoints, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery">The Endpoint Discovery Pattern</a>.</p>', 'DescribeTable' => '<p>Returns information about the table, including the table name, database name, retention duration of the memory store and the magnetic store. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html">code sample</a> for details. </p>', 'ListBatchLoadTasks' => '<p>Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other details. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html">code sample</a> for details.</p>', 'ListDatabases' => '<p>Returns a list of your Timestream databases. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a> for details. </p>', 'ListTables' => '<p>Provides a list of tables, along with the name, status, and retention properties of each table. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a> for details. </p>', 'ListTagsForResource' => '<p> Lists all tags on a Timestream resource. </p>', 'ResumeBatchLoadTask' => '<p> </p>', 'TagResource' => '<p> Associates a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. </p>', 'UntagResource' => '<p> Removes the association of tags from a Timestream resource. </p>', 'UpdateDatabase' => '<p> Modifies the KMS key for an existing database. While updating the database, you must specify the database name and the identifier of the new KMS key to be used (<code>KmsKeyId</code>). If there are any concurrent <code>UpdateDatabase</code> requests, first writer wins. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html">code sample</a> for details.</p>', 'UpdateTable' => '<p>Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html">code sample</a> for details.</p>', 'WriteRecords' => '<p>Enables you to write your time-series data into Timestream. You can specify a single data point or a batch of data points to be inserted into the system. Timestream offers you a flexible schema that auto detects the column names and data types for your Timestream tables based on the dimension names and data types of the data points you specify when invoking writes into the database. </p> <p>Timestream supports eventual consistency read semantics. This means that when you query data immediately after writing a batch of data into Timestream, the query results might not reflect the results of a recently completed write operation. The results may also include some stale data. If you repeat the query request after a short time, the results should return the latest data. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html">code sample</a> for details.</p> <p> <b>Upserts</b> </p> <p>You can use the <code>Version</code> parameter in a <code>WriteRecords</code> request to update data points. Timestream tracks a version number with each record. <code>Version</code> defaults to <code>1</code> when it\'s not specified for the record in the request. Timestream updates an existing record’s measure value along with its <code>Version</code> when it receives a write request with a higher <code>Version</code> number for that record. When it receives an update request where the measure value is the same as that of the existing record, Timestream still updates <code>Version</code>, if it is greater than the existing value of <code>Version</code>. You can update a data point as many times as desired, as long as the value of <code>Version</code> continuously increases. </p> <p> For example, suppose you write a new record without indicating <code>Version</code> in the request. Timestream stores this record, and set <code>Version</code> to <code>1</code>. Now, suppose you try to update this record with a <code>WriteRecords</code> request of the same record with a different measure value but, like before, do not provide <code>Version</code>. In this case, Timestream will reject this update with a <code>RejectedRecordsException</code> since the updated record’s version is not greater than the existing value of Version. </p> <p>However, if you were to resend the update request with <code>Version</code> set to <code>2</code>, Timestream would then succeed in updating the record’s value, and the <code>Version</code> would be set to <code>2</code>. Next, suppose you sent a <code>WriteRecords</code> request with this same record and an identical measure value, but with <code>Version</code> set to <code>3</code>. In this case, Timestream would only update <code>Version</code> to <code>3</code>. Any further updates would need to send a version number greater than <code>3</code>, or the update requests would receive a <code>RejectedRecordsException</code>. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform this action.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p> The Timestream resource with tags to be listed. This value is an Amazon Resource Name (ARN). </p>', 'TagResourceRequest$ResourceARN' => '<p> Identifies the Timestream resource to which tags should be added. This value is an Amazon Resource Name (ARN). </p>', 'UntagResourceRequest$ResourceARN' => '<p> The Timestream resource that the tags will be removed from. This value is an Amazon Resource Name (ARN). </p>', ], ], 'BatchLoadDataFormat' => [ 'base' => NULL, 'refs' => [ 'DataSourceConfiguration$DataFormat' => '<p>This is currently CSV.</p>', ], ], 'BatchLoadProgressReport' => [ 'base' => '<p>Details about the progress of a batch load task.</p>', 'refs' => [ 'BatchLoadTaskDescription$ProgressReport' => '<p/>', ], ], 'BatchLoadStatus' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTask$TaskStatus' => '<p>Status of the batch load task.</p>', 'BatchLoadTaskDescription$TaskStatus' => '<p>Status of the batch load task.</p>', 'ListBatchLoadTasksRequest$TaskStatus' => '<p>Status of the batch load task.</p>', ], ], 'BatchLoadTask' => [ 'base' => '<p>Details about a batch load task.</p>', 'refs' => [ 'BatchLoadTaskList$member' => NULL, ], ], 'BatchLoadTaskDescription' => [ 'base' => '<p>Details about a batch load task.</p>', 'refs' => [ 'DescribeBatchLoadTaskResponse$BatchLoadTaskDescription' => '<p>Description of the batch load task.</p>', ], ], 'BatchLoadTaskId' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTask$TaskId' => '<p>The ID of the batch load task.</p>', 'BatchLoadTaskDescription$TaskId' => '<p>The ID of the batch load task.</p>', 'CreateBatchLoadTaskResponse$TaskId' => '<p>The ID of the batch load task.</p>', 'DescribeBatchLoadTaskRequest$TaskId' => '<p>The ID of the batch load task.</p>', 'ResumeBatchLoadTaskRequest$TaskId' => '<p>The ID of the batch load task to resume.</p>', ], ], 'BatchLoadTaskList' => [ 'base' => NULL, 'refs' => [ 'ListBatchLoadTasksResponse$BatchLoadTasks' => '<p>A list of batch load task details.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CsvConfiguration$TrimWhiteSpace' => '<p>Specifies to trim leading and trailing white space.</p>', 'MagneticStoreWriteProperties$EnableMagneticStoreWrites' => '<p>A flag to enable magnetic store writes.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateBatchLoadTaskRequest$ClientToken' => '<p/>', ], ], 'ConflictException' => [ 'base' => '<p>Timestream was unable to process this request because it contains resource that already exists.</p>', 'refs' => [], ], 'CreateBatchLoadTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchLoadTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'CsvConfiguration' => [ 'base' => '<p>A delimited data format where the column separator can be a comma and the record separator is a newline character.</p>', 'refs' => [ 'DataSourceConfiguration$CsvConfiguration' => NULL, ], ], 'DataModel' => [ 'base' => '<p>Data model for a batch load task.</p>', 'refs' => [ 'DataModelConfiguration$DataModel' => '<p/>', ], ], 'DataModelConfiguration' => [ 'base' => '<p/>', 'refs' => [ 'BatchLoadTaskDescription$DataModelConfiguration' => '<p>Data model configuration for a batch load task. This contains details about where a data model for a batch load task is stored.</p>', 'CreateBatchLoadTaskRequest$DataModelConfiguration' => NULL, ], ], 'DataModelS3Configuration' => [ 'base' => '<p/>', 'refs' => [ 'DataModelConfiguration$DataModelS3Configuration' => '<p/>', ], ], 'DataSourceConfiguration' => [ 'base' => '<p>Defines configuration details about the data source.</p>', 'refs' => [ 'BatchLoadTaskDescription$DataSourceConfiguration' => '<p>Configuration details about the data source for a batch load task.</p>', 'CreateBatchLoadTaskRequest$DataSourceConfiguration' => '<p>Defines configuration details about the data source for a batch load task.</p>', ], ], 'DataSourceS3Configuration' => [ 'base' => '<p> </p>', 'refs' => [ 'DataSourceConfiguration$DataSourceS3Configuration' => '<p>Configuration of an S3 location for a file which contains data to load.</p>', ], ], 'Database' => [ 'base' => '<p>A top-level container for a table. Databases and tables are the fundamental management concepts in Amazon Timestream. All tables in a database are encrypted with the same KMS key.</p>', 'refs' => [ 'CreateDatabaseResponse$Database' => '<p>The newly created Timestream database.</p>', 'DatabaseList$member' => NULL, 'DescribeDatabaseResponse$Database' => '<p>The name of the Timestream table.</p>', 'UpdateDatabaseResponse$Database' => NULL, ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesResponse$Databases' => '<p>A list of database names.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTask$CreationTime' => '<p>The time when the Timestream batch load task was created.</p>', 'BatchLoadTask$LastUpdatedTime' => '<p>The time when the Timestream batch load task was last updated.</p>', 'BatchLoadTask$ResumableUntil' => '<p> </p>', 'BatchLoadTaskDescription$CreationTime' => '<p>The time when the Timestream batch load task was created.</p>', 'BatchLoadTaskDescription$LastUpdatedTime' => '<p>The time when the Timestream batch load task was last updated.</p>', 'BatchLoadTaskDescription$ResumableUntil' => '<p> </p>', 'Database$CreationTime' => '<p>The time when the database was created, calculated from the Unix epoch time.</p>', 'Database$LastUpdatedTime' => '<p> The last time that this database was updated. </p>', 'Table$CreationTime' => '<p>The time when the Timestream table was created. </p>', 'Table$LastUpdatedTime' => '<p>The time when the Timestream table was last updated.</p>', ], ], 'DeleteDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchLoadTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchLoadTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>Represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions. </p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionMapping' => [ 'base' => '<p/>', 'refs' => [ 'DimensionMappings$member' => NULL, ], ], 'DimensionMappings' => [ 'base' => NULL, 'refs' => [ 'DataModel$DimensionMappings' => '<p>Source to target mappings for dimensions.</p>', ], ], 'DimensionValueType' => [ 'base' => NULL, 'refs' => [ 'Dimension$DimensionValueType' => '<p>The data type of the dimension for the time-series data point.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'Record$Dimensions' => '<p>Contains the list of dimensions for time-series data points.</p>', ], ], 'Endpoint' => [ 'base' => '<p>Represents an available endpoint against which to make API calls against, as well as the TTL for that endpoint.</p>', 'refs' => [ 'Endpoints$member' => NULL, ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsResponse$Endpoints' => '<p>An <code>Endpoints</code> object is returned when a <code>DescribeEndpoints</code> request is made.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'InvalidEndpointException$Message' => NULL, 'RejectedRecord$Reason' => '<p> The reason why a record was not successfully inserted into Timestream. Possible causes of failure include: </p> <ul> <li> <p>Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but: </p> <ul> <li> <p>Measure values are different</p> </li> <li> <p>Version is not present in the request, <i>or</i> the value of version in the new record is equal to or lower than the existing value</p> </li> </ul> <p>If Timestream rejects data for this case, the <code>ExistingVersion</code> field in the <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the <code>ExistingVersion</code>.</p> </li> <li> <p> Records with timestamps that lie outside the retention duration of the memory store. </p> <note> <p>When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code> exception, wait until the duration of the new window to ingest new data. For further information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration"> Best Practices for Configuring Timestream</a> and <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of how storage works in Timestream</a>.</p> </note> </li> <li> <p> Records with dimensions or measures that exceed the Timestream defined limits. </p> </li> </ul> <p> For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a> in the Timestream Developer Guide. </p>', 'RejectedRecordsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'RecordsIngested$Total' => '<p>Total count of successfully ingested records.</p>', 'RecordsIngested$MemoryStore' => '<p>Count of records ingested into the memory store.</p>', 'RecordsIngested$MagneticStore' => '<p>Count of records ingested into the magnetic store.</p>', ], ], 'InternalServerException' => [ 'base' => '<p> Timestream was unable to fully process this request because of an internal server error.</p>', 'refs' => [], ], 'InvalidEndpointException' => [ 'base' => '<p>The requested endpoint was not valid.</p>', 'refs' => [], ], 'ListBatchLoadTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchLoadTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'BatchLoadProgressReport$RecordsProcessed' => '<p/>', 'BatchLoadProgressReport$RecordsIngested' => '<p/>', 'BatchLoadProgressReport$ParseFailures' => '<p/>', 'BatchLoadProgressReport$RecordIngestionFailures' => '<p/>', 'BatchLoadProgressReport$FileFailures' => '<p/>', 'BatchLoadProgressReport$BytesMetered' => '<p/>', 'Database$TableCount' => '<p>The total number of tables found within a Timestream database. </p>', 'Endpoint$CachePeriodInMinutes' => '<p>The TTL for the endpoint, in minutes.</p>', ], ], 'MagneticStoreRejectedDataLocation' => [ 'base' => '<p>The location to write error reports for records rejected, asynchronously, during magnetic store writes.</p>', 'refs' => [ 'MagneticStoreWriteProperties$MagneticStoreRejectedDataLocation' => '<p>The location to write error reports for records rejected asynchronously during magnetic store writes.</p>', ], ], 'MagneticStoreRetentionPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'RetentionProperties$MagneticStoreRetentionPeriodInDays' => '<p>The duration for which data must be stored in the magnetic store. </p>', ], ], 'MagneticStoreWriteProperties' => [ 'base' => '<p>The set of properties on a table for configuring magnetic store writes.</p>', 'refs' => [ 'CreateTableRequest$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', 'Table$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', 'UpdateTableRequest$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', ], ], 'MeasureValue' => [ 'base' => '<p> Represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures. MeasureValue has both name and value. </p> <p> MeasureValue is only allowed for type <code>MULTI</code>. Using <code>MULTI</code> type, you can pass multiple data attributes associated with the same time series in a single record </p>', 'refs' => [ 'MeasureValues$member' => NULL, ], ], 'MeasureValueType' => [ 'base' => NULL, 'refs' => [ 'MeasureValue$Type' => '<p>Contains the data type of the MeasureValue for the time-series data point.</p>', 'MixedMeasureMapping$MeasureValueType' => '<p/>', 'Record$MeasureValueType' => '<p> Contains the data type of the measure value for the time-series data point. Default type is <code>DOUBLE</code>. For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types">Data types</a>.</p>', ], ], 'MeasureValues' => [ 'base' => NULL, 'refs' => [ 'Record$MeasureValues' => '<p> Contains the list of MeasureValue for time-series data points. </p> <p> This is only allowed for type <code>MULTI</code>. For scalar values, use <code>MeasureValue</code> attribute of the record directly. </p>', ], ], 'MemoryStoreRetentionPeriodInHours' => [ 'base' => NULL, 'refs' => [ 'RetentionProperties$MemoryStoreRetentionPeriodInHours' => '<p>The duration for which data must be stored in the memory store. </p>', ], ], 'MixedMeasureMapping' => [ 'base' => '<p/>', 'refs' => [ 'MixedMeasureMappingList$member' => NULL, ], ], 'MixedMeasureMappingList' => [ 'base' => NULL, 'refs' => [ 'DataModel$MixedMeasureMappings' => '<p>Source to target mappings for measures.</p>', ], ], 'MultiMeasureAttributeMapping' => [ 'base' => '<p/>', 'refs' => [ 'MultiMeasureAttributeMappingList$member' => NULL, ], ], 'MultiMeasureAttributeMappingList' => [ 'base' => NULL, 'refs' => [ 'MixedMeasureMapping$MultiMeasureAttributeMappings' => '<p/>', 'MultiMeasureMappings$MultiMeasureAttributeMappings' => '<p/>', ], ], 'MultiMeasureMappings' => [ 'base' => '<p/>', 'refs' => [ 'DataModel$MultiMeasureMappings' => '<p>Source to target mappings for multi-measure records.</p>', ], ], 'PageLimit' => [ 'base' => NULL, 'refs' => [ 'ListBatchLoadTasksRequest$MaxResults' => '<p>The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', ], ], 'PaginationLimit' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesRequest$MaxResults' => '<p>The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListTablesRequest$MaxResults' => '<p>The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', ], ], 'PartitionKey' => [ 'base' => '<p> An attribute used in partitioning data in a table. A dimension key partitions data using the values of the dimension specified by the dimension-name as partition key, while a measure key partitions data using measure names (values of the \'measure_name\' column). </p>', 'refs' => [ 'PartitionKeyList$member' => NULL, ], ], 'PartitionKeyEnforcementLevel' => [ 'base' => NULL, 'refs' => [ 'PartitionKey$EnforcementInRecord' => '<p> The level of enforcement for the specification of a dimension key in ingested records. Options are REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified). </p>', ], ], 'PartitionKeyList' => [ 'base' => NULL, 'refs' => [ 'Schema$CompositePartitionKey' => '<p>A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. </p>', ], ], 'PartitionKeyType' => [ 'base' => NULL, 'refs' => [ 'PartitionKey$Type' => '<p> The type of the partition key. Options are DIMENSION (dimension key) and MEASURE (measure key). </p>', ], ], 'Record' => [ 'base' => '<p>Represents a time-series data point being written into Timestream. Each record contains an array of dimensions. Dimensions represent the metadata attributes of a time-series data point, such as the instance name or Availability Zone of an EC2 instance. A record also contains the measure name, which is the name of the measure being collected (for example, the CPU utilization of an EC2 instance). Additionally, a record contains the measure value and the value type, which is the data type of the measure value. Also, the record contains the timestamp of when the measure was collected and the timestamp unit, which represents the granularity of the timestamp. </p> <p> Records have a <code>Version</code> field, which is a 64-bit <code>long</code> that you can use for updating data points. Writes of a duplicate record with the same dimension, timestamp, and measure name but different measure value will only succeed if the <code>Version</code> attribute of the record in the write request is higher than that of the existing record. Timestream defaults to a <code>Version</code> of <code>1</code> for records without the <code>Version</code> field. </p>', 'refs' => [ 'Records$member' => NULL, 'WriteRecordsRequest$CommonAttributes' => '<p>A record that contains the common measure, dimension, time, and version attributes shared across all the records in the request. The measure and dimension attributes specified will be merged with the measure and dimension attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a <code>ValidationException</code> will be thrown. In other words, a record must contain dimensions with unique names. </p>', ], ], 'RecordIndex' => [ 'base' => NULL, 'refs' => [ 'RejectedRecord$RecordIndex' => '<p> The index of the record in the input request for WriteRecords. Indexes begin with 0. </p>', ], ], 'RecordVersion' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTaskDescription$RecordVersion' => '<p/>', 'CreateBatchLoadTaskRequest$RecordVersion' => '<p/>', 'Record$Version' => '<p>64-bit attribute used for record updates. Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, <code>Version</code> will still be updated. Default value is <code>1</code>.</p> <note> <p> <code>Version</code> must be <code>1</code> or greater, or you will receive a <code>ValidationException</code> error.</p> </note>', 'RejectedRecord$ExistingVersion' => '<p>The existing version of the record. This value is populated in scenarios where an identical record exists with a higher version than the version in the write request.</p>', ], ], 'Records' => [ 'base' => NULL, 'refs' => [ 'WriteRecordsRequest$Records' => '<p>An array of records that contain the unique measure, dimension, time, and version attributes for each time-series data point. </p>', ], ], 'RecordsIngested' => [ 'base' => '<p>Information on the records ingested by this request.</p>', 'refs' => [ 'WriteRecordsResponse$RecordsIngested' => '<p>Information on the records ingested by this request.</p>', ], ], 'RejectedRecord' => [ 'base' => '<p> Represents records that were not successfully inserted into Timestream due to data validation issues that must be resolved before reinserting time-series data into the system. </p>', 'refs' => [ 'RejectedRecords$member' => NULL, ], ], 'RejectedRecords' => [ 'base' => NULL, 'refs' => [ 'RejectedRecordsException$RejectedRecords' => '<p> </p>', ], ], 'RejectedRecordsException' => [ 'base' => '<p> WriteRecords would throw this exception in the following cases: </p> <ul> <li> <p>Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but: </p> <ul> <li> <p>Measure values are different</p> </li> <li> <p>Version is not present in the request <i>or</i> the value of version in the new record is equal to or lower than the existing value</p> </li> </ul> <p> In this case, if Timestream rejects data, the <code>ExistingVersion</code> field in the <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the <code>ExistingVersion</code>.</p> </li> <li> <p> Records with timestamps that lie outside the retention duration of the memory store. </p> </li> <li> <p> Records with dimensions or measures that exceed the Timestream defined limits. </p> </li> </ul> <p> For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Quotas</a> in the Amazon Timestream Developer Guide. </p>', 'refs' => [], ], 'ReportConfiguration' => [ 'base' => '<p>Report configuration for a batch load task. This contains details about where error reports are stored.</p>', 'refs' => [ 'BatchLoadTaskDescription$ReportConfiguration' => '<p>Report configuration for a batch load task. This contains details about where error reports are stored.</p>', 'CreateBatchLoadTaskRequest$ReportConfiguration' => NULL, ], ], 'ReportS3Configuration' => [ 'base' => '<p/>', 'refs' => [ 'ReportConfiguration$ReportS3Configuration' => '<p>Configuration of an S3 location to write error reports and events for a batch load.</p>', ], ], 'ResourceCreateAPIName' => [ 'base' => NULL, 'refs' => [ 'CreateBatchLoadTaskRequest$TargetDatabaseName' => '<p>Target Timestream database for a batch load task.</p>', 'CreateBatchLoadTaskRequest$TargetTableName' => '<p>Target Timestream table for a batch load task.</p>', 'CreateDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'CreateTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'CreateTableRequest$TableName' => '<p>The name of the Timestream table.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTask$DatabaseName' => '<p>Database name for the database into which a batch load task loads data.</p>', 'BatchLoadTask$TableName' => '<p>Table name for the table into which a batch load task loads data.</p>', 'BatchLoadTaskDescription$TargetDatabaseName' => '<p/>', 'BatchLoadTaskDescription$TargetTableName' => '<p/>', 'Database$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DeleteDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database to be deleted.</p>', 'DeleteTableRequest$DatabaseName' => '<p>The name of the database where the Timestream database is to be deleted.</p>', 'DeleteTableRequest$TableName' => '<p>The name of the Timestream table to be deleted.</p>', 'DescribeDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DescribeTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DescribeTableRequest$TableName' => '<p>The name of the Timestream table.</p>', 'ListTablesRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'Table$TableName' => '<p>The name of the Timestream table.</p>', 'Table$DatabaseName' => '<p>The name of the Timestream database that contains this table.</p>', 'UpdateDatabaseRequest$DatabaseName' => '<p> The name of the database. </p>', 'UpdateTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'UpdateTableRequest$TableName' => '<p>The name of the Timestream table.</p>', 'WriteRecordsRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'WriteRecordsRequest$TableName' => '<p>The name of the Timestream table.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access a nonexistent resource. The resource might not be specified correctly, or its status might not be ACTIVE.</p>', 'refs' => [], ], 'ResumeBatchLoadTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeBatchLoadTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetentionProperties' => [ 'base' => '<p>Retention properties contain the duration for which your time-series data must be stored in the magnetic store and the memory store. </p>', 'refs' => [ 'CreateTableRequest$RetentionProperties' => '<p>The duration for which your time-series data must be stored in the memory store and the magnetic store.</p>', 'Table$RetentionProperties' => '<p>The retention duration for the memory store and magnetic store.</p>', 'UpdateTableRequest$RetentionProperties' => '<p>The retention duration of the memory store and the magnetic store.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'DataModelS3Configuration$BucketName' => '<p/>', 'DataSourceS3Configuration$BucketName' => '<p>The bucket name of the customer S3 bucket.</p>', 'ReportS3Configuration$BucketName' => '<p/>', 'S3Configuration$BucketName' => '<p>The bucket name of the customer S3 bucket.</p>', ], ], 'S3Configuration' => [ 'base' => '<p>The configuration that specifies an S3 location.</p>', 'refs' => [ 'MagneticStoreRejectedDataLocation$S3Configuration' => '<p>Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.</p>', ], ], 'S3EncryptionOption' => [ 'base' => NULL, 'refs' => [ 'ReportS3Configuration$EncryptionOption' => '<p/>', 'S3Configuration$EncryptionOption' => '<p>The encryption option for the customer S3 location. Options are S3 server-side encryption with an S3 managed key or Amazon Web Services managed key.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'DataModelS3Configuration$ObjectKey' => '<p/>', 'DataSourceS3Configuration$ObjectKeyPrefix' => '<p> </p>', ], ], 'S3ObjectKeyPrefix' => [ 'base' => NULL, 'refs' => [ 'ReportS3Configuration$ObjectKeyPrefix' => '<p/>', 'S3Configuration$ObjectKeyPrefix' => '<p>The object key preview for the customer S3 location.</p>', ], ], 'ScalarMeasureValueType' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureAttributeMapping$MeasureValueType' => '<p/>', ], ], 'Schema' => [ 'base' => '<p> A Schema specifies the expected data model of the table. </p>', 'refs' => [ 'CreateTableRequest$Schema' => '<p> The schema of the table. </p>', 'Table$Schema' => '<p> The schema of the table. </p>', 'UpdateTableRequest$Schema' => '<p> The schema of the table. </p>', ], ], 'SchemaName' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p> Dimension represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions. </p> <p>For constraints on dimension names, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming">Naming Constraints</a>.</p>', 'DimensionMapping$SourceColumn' => '<p/>', 'DimensionMapping$DestinationColumn' => '<p> </p>', 'MeasureValue$Name' => '<p> The name of the MeasureValue. </p> <p> For constraints on MeasureValue names, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming"> Naming Constraints</a> in the Amazon Timestream Developer Guide.</p>', 'MixedMeasureMapping$MeasureName' => '<p/>', 'MixedMeasureMapping$SourceColumn' => '<p/>', 'MixedMeasureMapping$TargetMeasureName' => '<p/>', 'MultiMeasureAttributeMapping$SourceColumn' => '<p/>', 'MultiMeasureAttributeMapping$TargetMultiMeasureAttributeName' => '<p/>', 'MultiMeasureMappings$TargetMultiMeasureName' => '<p/>', 'PartitionKey$Name' => '<p> The name of the attribute used for a dimension key. </p>', 'Record$MeasureName' => '<p>Measure represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures. </p>', ], ], 'SchemaValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value of the dimension.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> The instance quota of resource exceeded for this account.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Database$Arn' => '<p>The Amazon Resource Name that uniquely identifies this database.</p>', 'Endpoint$Address' => '<p>An endpoint address.</p>', 'ListBatchLoadTasksRequest$NextToken' => '<p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>', 'ListBatchLoadTasksResponse$NextToken' => '<p>A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.</p>', 'ListDatabasesRequest$NextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListDatabasesResponse$NextToken' => '<p>The pagination token. This parameter is returned when the response is truncated.</p>', 'ListTablesRequest$NextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListTablesResponse$NextToken' => '<p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>', 'Table$Arn' => '<p>The Amazon Resource Name that uniquely identifies this table.</p>', ], ], 'StringValue1' => [ 'base' => NULL, 'refs' => [ 'CsvConfiguration$ColumnSeparator' => '<p>Column separator can be one of comma (\',\'), pipe (\'|), semicolon (\';\'), tab(\'/t\'), or blank space (\' \'). </p>', 'CsvConfiguration$EscapeChar' => '<p>Escape character can be one of </p>', 'CsvConfiguration$QuoteChar' => '<p>Can be single quote (\') or double quote (").</p>', ], ], 'StringValue2048' => [ 'base' => NULL, 'refs' => [ 'BatchLoadTaskDescription$ErrorMessage' => '<p/>', 'CreateDatabaseRequest$KmsKeyId' => '<p>The KMS key for the database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>.</p>', 'Database$KmsKeyId' => '<p>The identifier of the KMS key used to encrypt the data stored in the database.</p>', 'MeasureValue$Value' => '<p> The value for the MeasureValue. For information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types">Data types</a>.</p>', 'Record$MeasureValue' => '<p> Contains the measure value for the time-series data point. </p>', 'ReportS3Configuration$KmsKeyId' => '<p/>', 'S3Configuration$KmsKeyId' => '<p>The KMS key ID for the customer S3 location when encrypting with an Amazon Web Services managed key.</p>', 'UpdateDatabaseRequest$KmsKeyId' => '<p> The identifier of the new KMS key (<code>KmsKeyId</code>) to be used to encrypt the data stored in the database. If the <code>KmsKeyId</code> currently registered with the database is the same as the <code>KmsKeyId</code> in the request, there will not be any update. </p> <p>You can specify the <code>KmsKeyId</code> using any of the following:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias ARN: <code>arn:aws:kms:us-east-1:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', ], ], 'StringValue256' => [ 'base' => NULL, 'refs' => [ 'CsvConfiguration$NullValue' => '<p>Can be blank space (\' \').</p>', 'DataModel$TimeColumn' => '<p>Source column to be mapped to time.</p>', 'DataModel$MeasureNameColumn' => '<p/>', 'Record$Time' => '<p> Contains the time at which the measure value for the data point was collected. The time value plus the unit provides the time elapsed since the epoch. For example, if the time value is <code>12345</code> and the unit is <code>ms</code>, then <code>12345 ms</code> have elapsed since the epoch. </p>', ], ], 'Table' => [ 'base' => '<p>Represents a database table in Timestream. Tables contain one or more related time series. You can modify the retention duration of the memory store and the magnetic store for a table. </p>', 'refs' => [ 'CreateTableResponse$Table' => '<p>The newly created Timestream table.</p>', 'DescribeTableResponse$Table' => '<p>The Timestream table.</p>', 'TableList$member' => NULL, 'UpdateTableResponse$Table' => '<p>The updated Timestream table.</p>', ], ], 'TableList' => [ 'base' => NULL, 'refs' => [ 'ListTablesResponse$Tables' => '<p>A list of tables.</p>', ], ], 'TableStatus' => [ 'base' => NULL, 'refs' => [ 'Table$TableStatus' => '<p>The current state of the table:</p> <ul> <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p> A tag is a label that you assign to a Timestream database and/or table. Each tag consists of a key and an optional value, both of which you define. With tags, you can categorize databases and/or tables, for example, by purpose, owner, or environment. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> The key of the tag. Tag keys are case sensitive. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> A list of tags keys. Existing tags of the resource whose keys are members of this list will be removed from the Timestream resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDatabaseRequest$Tags' => '<p> A list of key-value pairs to label the table. </p>', 'CreateTableRequest$Tags' => '<p> A list of key-value pairs to label the table. </p>', 'ListTagsForResourceResponse$Tags' => '<p> The tags currently associated with the Timestream resource. </p>', 'TagResourceRequest$Tags' => '<p> The tags to be assigned to the Timestream resource. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The value of the tag. Tag values are case-sensitive and can be null. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p> Too many requests were made by a user and they exceeded the service quotas. The request was throttled.</p>', 'refs' => [], ], 'TimeUnit' => [ 'base' => NULL, 'refs' => [ 'DataModel$TimeUnit' => '<p> The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>. </p>', 'Record$TimeUnit' => '<p> The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds, or other supported values. Default is <code>MILLISECONDS</code>. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p> An invalid or malformed request.</p>', 'refs' => [], ], 'WriteRecordsRequest' => [ 'base' => NULL, 'refs' => [], ], 'WriteRecordsResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
