<?php
// This file was auto-generated from sdk-root/src/data/tnb/2008-10-21/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon Web Services Telco Network Builder (TNB) is a network automation service that helps you deploy and manage telecom networks. AWS TNB helps you with the lifecycle management of your telecommunication network functions throughout planning, deployment, and post-deployment activities.</p>', 'operations' => [ 'CancelSolNetworkOperation' => '<p>Cancels a network operation.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'CreateSolFunctionPackage' => '<p>Creates a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network. For more information, see <a href="https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html">Function packages</a> in the <i>Amazon Web Services Telco Network Builder User Guide</i>. </p> <p>Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload function package content, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">PutSolFunctionPackageContent</a>.</p>', 'CreateSolNetworkInstance' => '<p>Creates a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the third step after creating a network package. For more information about network instances, <a href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon Web Services Telco Network Builder User Guide</i>.</p> <p>Once you create a network instance, you can instantiate it. To instantiate a network, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html">InstantiateSolNetworkInstance</a>.</p>', 'CreateSolNetworkPackage' => '<p>Creates a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see <a href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon Web Services Telco Network Builder User Guide</i>. </p> <p>A network package consists of a network service descriptor (NSD) file (required) and any additional files (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or EKS clusters.</p> <p>This request creates an empty network package container with an ID. Once you create a network package, you can upload the network package content using <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">PutSolNetworkPackageContent</a>.</p>', 'DeleteSolFunctionPackage' => '<p>Deletes a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p> <p>To delete a function package, the package must be in a disabled state. To disable a function package, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html">UpdateSolFunctionPackage</a>. </p>', 'DeleteSolNetworkInstance' => '<p>Deletes a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p> <p>To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network instance, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html">TerminateSolNetworkInstance</a>.</p>', 'DeleteSolNetworkPackage' => '<p>Deletes network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p> <p>To delete a network package, the package must be in a disable state. To disable a network package, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html">UpdateSolNetworkPackage</a>.</p>', 'GetSolFunctionInstance' => '<p>Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package.</p> <p>A network function instance is a function in a function package .</p>', 'GetSolFunctionPackage' => '<p>Gets the details of an individual function package, such as the operational state and whether the package is in use.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network..</p>', 'GetSolFunctionPackageContent' => '<p>Gets the contents of a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'GetSolFunctionPackageDescriptor' => '<p>Gets a function package descriptor in a function package.</p> <p>A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how the network function in the function package should run on your network.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'GetSolNetworkInstance' => '<p>Gets the details of the network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'GetSolNetworkOperation' => '<p>Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'GetSolNetworkPackage' => '<p>Gets the details of a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'GetSolNetworkPackageContent' => '<p>Gets the contents of a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'GetSolNetworkPackageDescriptor' => '<p>Gets the content of the network service descriptor.</p> <p>A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.</p>', 'InstantiateSolNetworkInstance' => '<p>Instantiates a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p> <p>Before you can instantiate a network instance, you have to create a network instance. For more information, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html">CreateSolNetworkInstance</a>.</p>', 'ListSolFunctionInstances' => '<p>Lists network function instances.</p> <p>A network function instance is a function in a function package .</p>', 'ListSolFunctionPackages' => '<p>Lists information about function packages.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'ListSolNetworkInstances' => '<p>Lists your network instances.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'ListSolNetworkOperations' => '<p>Lists details for a network operation, including when the operation started and the status of the operation.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'ListSolNetworkPackages' => '<p>Lists network packages.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'ListTagsForResource' => '<p>Lists tags for AWS TNB resources.</p>', 'PutSolFunctionPackageContent' => '<p>Uploads the contents of a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'PutSolNetworkPackageContent' => '<p>Uploads the contents of a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'TagResource' => '<p>Tags an AWS TNB resource.</p> <p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'TerminateSolNetworkInstance' => '<p>Terminates a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p> <p>You must terminate a network instance before you can delete it.</p>', 'UntagResource' => '<p>Untags an AWS TNB resource.</p> <p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'UpdateSolFunctionPackage' => '<p>Updates the operational state of function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'UpdateSolNetworkInstance' => '<p>Update a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p> <p>Choose the <i>updateType</i> parameter to target the necessary update of the network instance.</p>', 'UpdateSolNetworkPackage' => '<p>Updates the operational state of a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p> <p>A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.</p>', 'ValidateSolFunctionPackageContent' => '<p>Validates function package content. This can be used as a dry run before uploading function package content with <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">PutSolFunctionPackageContent</a>.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'ValidateSolNetworkPackageContent' => '<p>Validates network package content. This can be used as a dry run before uploading network package content with <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">PutSolNetworkPackageContent</a>.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Insufficient permissions to make request.</p>', 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionPackageContentOutput$packageContent' => '<p>Contents of the function package.</p>', 'GetSolFunctionPackageDescriptorOutput$vnfd' => '<p>Contents of the function package descriptor.</p>', 'GetSolNetworkPackageContentOutput$nsdContent' => '<p>Content of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageDescriptorOutput$nsd' => '<p>Contents of the network service descriptor in the network package.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'InstantiateSolNetworkInstanceInput$dryRun' => '<p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', ], ], 'CancelSolNetworkOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolFunctionPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolFunctionPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolNetworkInstanceInputNsDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkInstanceInput$nsDescription' => '<p>Network instance description.</p>', ], ], 'CreateSolNetworkInstanceInputNsNameString' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkInstanceInput$nsName' => '<p>Network instance name.</p>', ], ], 'CreateSolNetworkInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolNetworkPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolNetworkPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSolFunctionPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSolNetworkPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DescriptorContentType' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionPackageDescriptorInput$accept' => '<p>Indicates which content types, expressed as MIME types, the client is able to understand.</p>', 'GetSolFunctionPackageDescriptorOutput$contentType' => '<p>Indicates the media type of the resource.</p>', 'GetSolNetworkPackageDescriptorOutput$contentType' => '<p>Indicates the media type of the resource.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'InstantiateMetadata$additionalParamsForNs' => '<p>The configurable properties used during instantiation.</p>', 'InstantiateSolNetworkInstanceInput$additionalParamsForNs' => '<p>Provides values for the configurable properties.</p>', 'ModifyVnfInfoMetadata$vnfConfigurableProperties' => '<p>The configurable properties used during update of the network function instance.</p>', 'UpdateNsMetadata$additionalParamsForNs' => '<p>The configurable properties used during update.</p>', 'UpdateSolNetworkModify$vnfConfigurableProperties' => '<p>Provides values for the configurable properties declared in the function package descriptor.</p>', 'UpdateSolNetworkServiceData$additionalParamsForNs' => '<p>Values for the configurable properties declared in the network service descriptor.</p>', ], ], 'ErrorCause' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$cause' => '<p>Error cause.</p>', ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$details' => '<p>Error details.</p>', ], ], 'ErrorInfo' => [ 'base' => '<p>Provides error information.</p>', 'refs' => [ 'GetSolNetworkOperationTaskDetails$taskErrorDetails' => '<p>Task error details.</p>', ], ], 'FunctionArtifactMeta' => [ 'base' => '<p>Metadata for function package artifacts.</p> <p>Artifacts are the contents of the package descriptor file and the state of the package.</p>', 'refs' => [ 'GetSolFunctionPackageMetadata$vnfd' => '<p>Metadata related to the function package descriptor of the function package.</p>', 'PutSolFunctionPackageContentMetadata$vnfd' => NULL, 'ValidateSolFunctionPackageContentMetadata$vnfd' => NULL, ], ], 'GetSolFunctionInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionInstanceMetadata' => [ 'base' => '<p>The metadata of a network function instance.</p> <p>A network function instance is a function in a function package .</p>', 'refs' => [ 'GetSolFunctionInstanceOutput$metadata' => NULL, ], ], 'GetSolFunctionInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageDescriptorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageDescriptorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolFunctionPackageMetadata' => [ 'base' => '<p>Metadata related to the function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'refs' => [ 'GetSolFunctionPackageOutput$metadata' => NULL, ], ], 'GetSolFunctionPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolInstantiatedVnfInfo' => [ 'base' => '<p>Information about a network function.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'ListSolFunctionInstanceInfo$instantiatedVnfInfo' => NULL, ], ], 'GetSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkInstanceMetadata' => [ 'base' => '<p>The metadata of a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'GetSolNetworkInstanceOutput$metadata' => NULL, ], ], 'GetSolNetworkInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkOperationMetadata' => [ 'base' => '<p>Metadata related to a network operation occurrence.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'refs' => [ 'GetSolNetworkOperationOutput$metadata' => '<p>Metadata of this network operation occurrence.</p>', ], ], 'GetSolNetworkOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkOperationTaskDetails' => [ 'base' => '<p>Gets the details of a network operation.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'refs' => [ 'GetSolNetworkOperationTasksList$member' => NULL, ], ], 'GetSolNetworkOperationTasksList' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationOutput$tasks' => '<p>All tasks associated with this operation occurrence.</p>', ], ], 'GetSolNetworkPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkPackageDescriptorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkPackageDescriptorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolNetworkPackageMetadata' => [ 'base' => '<p>Metadata associated with a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'refs' => [ 'GetSolNetworkPackageOutput$metadata' => NULL, ], ], 'GetSolNetworkPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSolVnfInfo' => [ 'base' => '<p>Information about the network function.</p> <p>A network function instance is a function in a function package .</p>', 'refs' => [ 'GetSolFunctionInstanceOutput$instantiatedVnfInfo' => NULL, ], ], 'GetSolVnfcResourceInfo' => [ 'base' => '<p>Details of resource associated with a network function.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'GetSolVnfcResourceInfoList$member' => NULL, ], ], 'GetSolVnfcResourceInfoList' => [ 'base' => NULL, 'refs' => [ 'GetSolVnfInfo$vnfcResourceInfo' => '<p>Compute info used by the network function instance.</p>', ], ], 'GetSolVnfcResourceInfoMetadata' => [ 'base' => '<p>The metadata of a network function.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'GetSolVnfcResourceInfo$metadata' => '<p>The metadata of the network function compute.</p>', ], ], 'InstantiateMetadata' => [ 'base' => '<p>Metadata related to the configuration properties used during instantiation of the network instance.</p>', 'refs' => [ 'GetSolNetworkOperationMetadata$instantiateMetadata' => '<p>Metadata related to the network operation occurrence for network instantiation. This is populated only if the lcmOperationType is <code>INSTANTIATE</code>.</p>', ], ], 'InstantiateSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'InstantiateSolNetworkInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error occurred. Problem on the server.</p>', 'refs' => [], ], 'LcmOperationInfo' => [ 'base' => '<p>Lifecycle management operation details on the network instance.</p> <p>Lifecycle management operations are deploy, update, or delete operations.</p>', 'refs' => [ 'GetSolNetworkInstanceOutput$lcmOpInfo' => NULL, ], ], 'LcmOperationType' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationOutput$lcmOperationType' => '<p>Type of the operation represented by this occurrence.</p>', 'ListSolNetworkOperationsInfo$lcmOperationType' => '<p>Type of lifecycle management network operation.</p>', ], ], 'ListSolFunctionInstanceInfo' => [ 'base' => '<p>Lists information about a network function instance.</p> <p>A network function instance is a function in a function package .</p>', 'refs' => [ 'ListSolFunctionInstanceResources$member' => NULL, ], ], 'ListSolFunctionInstanceMetadata' => [ 'base' => '<p>Lists network function instance metadata.</p> <p>A network function instance is a function in a function package .</p>', 'refs' => [ 'ListSolFunctionInstanceInfo$metadata' => '<p>Network function instance metadata.</p>', ], ], 'ListSolFunctionInstanceResources' => [ 'base' => NULL, 'refs' => [ 'ListSolFunctionInstancesOutput$functionInstances' => '<p>Network function instances.</p>', ], ], 'ListSolFunctionInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolFunctionInstancesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSolFunctionInstancesInput$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListSolFunctionInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolFunctionPackageInfo' => [ 'base' => '<p>Information about a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'refs' => [ 'ListSolFunctionPackageResources$member' => NULL, ], ], 'ListSolFunctionPackageMetadata' => [ 'base' => '<p>Details for the function package metadata.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'refs' => [ 'ListSolFunctionPackageInfo$metadata' => '<p>The metadata of the function package.</p>', ], ], 'ListSolFunctionPackageResources' => [ 'base' => NULL, 'refs' => [ 'ListSolFunctionPackagesOutput$functionPackages' => '<p>Function packages. A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', ], ], 'ListSolFunctionPackagesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolFunctionPackagesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSolFunctionPackagesInput$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListSolFunctionPackagesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkInstanceInfo' => [ 'base' => '<p>Info about the specific network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'ListSolNetworkInstanceResources$member' => NULL, ], ], 'ListSolNetworkInstanceMetadata' => [ 'base' => '<p>Metadata details for a network instance.</p> <p>A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.</p>', 'refs' => [ 'ListSolNetworkInstanceInfo$metadata' => '<p>The metadata of the network instance.</p>', ], ], 'ListSolNetworkInstanceResources' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkInstancesOutput$networkInstances' => '<p>Lists network instances.</p>', ], ], 'ListSolNetworkInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkInstancesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkInstancesInput$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListSolNetworkInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkOperationsInfo' => [ 'base' => '<p>Information parameters for a network operation.</p>', 'refs' => [ 'ListSolNetworkOperationsResources$member' => NULL, ], ], 'ListSolNetworkOperationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkOperationsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkOperationsInput$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListSolNetworkOperationsMetadata' => [ 'base' => '<p>Metadata related to a network operation.</p> <p>A network operation is any operation that is done to your network, such as network instance instantiation or termination.</p>', 'refs' => [ 'ListSolNetworkOperationsInfo$metadata' => '<p>Metadata related to this network operation.</p>', ], ], 'ListSolNetworkOperationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkOperationsResources' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkOperationsOutput$networkOperations' => '<p>Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete operations.</p>', ], ], 'ListSolNetworkPackageInfo' => [ 'base' => '<p>Details of a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'refs' => [ 'ListSolNetworkPackageResources$member' => NULL, ], ], 'ListSolNetworkPackageMetadata' => [ 'base' => '<p>Metadata related to a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'refs' => [ 'ListSolNetworkPackageInfo$metadata' => '<p>The metadata of the network package.</p>', ], ], 'ListSolNetworkPackageResources' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkPackagesOutput$networkPackages' => '<p>Network packages. A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', ], ], 'ListSolNetworkPackagesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSolNetworkPackagesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSolNetworkPackagesInput$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'ListSolNetworkPackagesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVnfInfoMetadata' => [ 'base' => '<p>Metadata related to the configuration properties used during update of a specific network function in a network instance.</p>', 'refs' => [ 'GetSolNetworkOperationMetadata$modifyVnfInfoMetadata' => '<p>Metadata related to the network operation occurrence for network function updates in a network instance. This is populated only if the lcmOperationType is <code>UPDATE</code> and the updateType is <code>MODIFY_VNF_INFORMATION</code>.</p>', ], ], 'NetworkArtifactMeta' => [ 'base' => '<p>Metadata for network package artifacts.</p> <p>Artifacts are the contents of the package descriptor file and the state of the package.</p>', 'refs' => [ 'GetSolNetworkPackageMetadata$nsd' => '<p>Metadata related to the onboarded network service descriptor in the network package.</p>', 'PutSolNetworkPackageContentMetadata$nsd' => NULL, 'ValidateSolNetworkPackageContentMetadata$nsd' => NULL, ], ], 'NsInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkInstanceOutput$arn' => '<p>Network instance ARN.</p>', 'GetSolNetworkInstanceOutput$arn' => '<p>Network instance ARN.</p>', 'ListSolNetworkInstanceInfo$arn' => '<p>Network instance ARN.</p>', ], ], 'NsInstanceId' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkInstanceOutput$id' => '<p>Network instance ID.</p>', 'DeleteSolNetworkInstanceInput$nsInstanceId' => '<p>Network instance ID.</p>', 'GetSolFunctionInstanceOutput$nsInstanceId' => '<p>Network instance ID.</p>', 'GetSolNetworkInstanceInput$nsInstanceId' => '<p>ID of the network instance.</p>', 'GetSolNetworkInstanceOutput$id' => '<p>Network instance ID.</p>', 'GetSolNetworkOperationOutput$nsInstanceId' => '<p>ID of the network operation instance.</p>', 'InstantiateSolNetworkInstanceInput$nsInstanceId' => '<p>ID of the network instance.</p>', 'ListSolFunctionInstanceInfo$nsInstanceId' => '<p>Network instance ID.</p>', 'ListSolNetworkInstanceInfo$id' => '<p>ID of the network instance.</p>', 'ListSolNetworkOperationsInfo$nsInstanceId' => '<p>ID of the network instance related to this operation.</p>', 'ListSolNetworkOperationsInput$nsInstanceId' => '<p>Network instance id filter, to retrieve network operations associated to a network instance.</p>', 'TerminateSolNetworkInstanceInput$nsInstanceId' => '<p>ID of the network instance.</p>', 'UpdateSolNetworkInstanceInput$nsInstanceId' => '<p>ID of the network instance.</p>', ], ], 'NsLcmOpOccArn' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationOutput$arn' => '<p>Network operation ARN.</p>', 'ListSolNetworkOperationsInfo$arn' => '<p>Network operation ARN.</p>', ], ], 'NsLcmOpOccId' => [ 'base' => NULL, 'refs' => [ 'CancelSolNetworkOperationInput$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', 'GetSolNetworkOperationInput$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', 'GetSolNetworkOperationOutput$id' => '<p>ID of this network operation occurrence.</p>', 'InstantiateSolNetworkInstanceOutput$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', 'LcmOperationInfo$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', 'ListSolNetworkOperationsInfo$id' => '<p>ID of this network operation.</p>', 'TerminateSolNetworkInstanceOutput$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', 'UpdateSolNetworkInstanceOutput$nsLcmOpOccId' => '<p>The identifier of the network operation.</p>', ], ], 'NsLcmOperationState' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationOutput$operationState' => '<p>The state of the network operation.</p>', 'ListSolNetworkOperationsInfo$operationState' => '<p>The state of the network operation.</p>', ], ], 'NsState' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkInstanceOutput$nsState' => '<p>Network instance state.</p>', 'ListSolNetworkInstanceInfo$nsState' => '<p>The state of the network instance.</p>', ], ], 'NsdId' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkInstanceOutput$nsdId' => '<p>Network service descriptor ID.</p>', 'GetSolNetworkPackageOutput$nsdId' => '<p>Network service descriptor ID.</p>', 'ListSolNetworkInstanceInfo$nsdId' => '<p>ID of the network service descriptor in the network package.</p>', 'PutSolNetworkPackageContentOutput$nsdId' => '<p>Network service descriptor ID.</p>', 'ValidateSolNetworkPackageContentOutput$nsdId' => '<p>Network service descriptor ID.</p>', ], ], 'NsdInfoArn' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkPackageOutput$arn' => '<p>Network package ARN.</p>', 'GetSolNetworkPackageOutput$arn' => '<p>Network package ARN.</p>', 'ListSolNetworkPackageInfo$arn' => '<p>Network package ARN.</p>', 'PutSolNetworkPackageContentOutput$arn' => '<p>Network package ARN.</p>', 'ValidateSolNetworkPackageContentOutput$arn' => '<p>Network package ARN.</p>', ], ], 'NsdInfoId' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkInstanceInput$nsdInfoId' => '<p>ID for network service descriptor.</p>', 'CreateSolNetworkInstanceOutput$nsdInfoId' => '<p>Network service descriptor ID.</p>', 'CreateSolNetworkPackageOutput$id' => '<p>ID of the network package.</p>', 'DeleteSolNetworkPackageInput$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'GetSolNetworkInstanceOutput$nsdInfoId' => '<p>Network service descriptor info ID.</p>', 'GetSolNetworkPackageContentInput$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageDescriptorInput$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageInput$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageOutput$id' => '<p>Network package ID.</p>', 'InstantiateMetadata$nsdInfoId' => '<p>The network service descriptor used for instantiating the network instance.</p>', 'ListSolNetworkInstanceInfo$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'ListSolNetworkOperationsMetadata$nsdInfoId' => '<p>The network service descriptor id used for the operation.</p> <p>Only present if the updateType is <code>UPDATE_NS</code>.</p>', 'ListSolNetworkPackageInfo$id' => '<p>ID of the individual network package.</p>', 'PutSolNetworkPackageContentInput$nsdInfoId' => '<p>Network service descriptor info ID.</p>', 'PutSolNetworkPackageContentOutput$id' => '<p>Network package ID.</p>', 'UpdateNsMetadata$nsdInfoId' => '<p>The network service descriptor used for updating the network instance.</p>', 'UpdateSolNetworkPackageInput$nsdInfoId' => '<p>ID of the network service descriptor in the network package.</p>', 'UpdateSolNetworkServiceData$nsdInfoId' => '<p>ID of the network service descriptor.</p>', 'ValidateSolNetworkPackageContentInput$nsdInfoId' => '<p>Network service descriptor file.</p>', 'ValidateSolNetworkPackageContentOutput$id' => '<p>Network package ID.</p>', ], ], 'NsdOnboardingState' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkPackageOutput$nsdOnboardingState' => '<p>Onboarding state of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageOutput$nsdOnboardingState' => '<p>Network service descriptor onboarding state.</p>', 'ListSolNetworkPackageInfo$nsdOnboardingState' => '<p>Onboarding state of the network service descriptor in the network package.</p>', ], ], 'NsdOperationalState' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkPackageOutput$nsdOperationalState' => '<p>Operational state of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageOutput$nsdOperationalState' => '<p>Network service descriptor operational state.</p>', 'ListSolNetworkPackageInfo$nsdOperationalState' => '<p>Operational state of the network service descriptor in the network package.</p>', 'UpdateSolNetworkPackageInput$nsdOperationalState' => '<p>Operational state of the network service descriptor in the network package.</p>', 'UpdateSolNetworkPackageOutput$nsdOperationalState' => '<p>Operational state of the network service descriptor in the network package.</p>', ], ], 'NsdUsageState' => [ 'base' => NULL, 'refs' => [ 'CreateSolNetworkPackageOutput$nsdUsageState' => '<p>Usage state of the network service descriptor in the network package.</p>', 'GetSolNetworkPackageOutput$nsdUsageState' => '<p>Network service descriptor usage state.</p>', 'ListSolNetworkPackageInfo$nsdUsageState' => '<p>Usage state of the network service descriptor in the network package.</p>', ], ], 'OnboardingState' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageOutput$onboardingState' => '<p>Onboarding state of the function package.</p>', 'GetSolFunctionPackageOutput$onboardingState' => '<p>Function package onboarding state.</p>', 'ListSolFunctionPackageInfo$onboardingState' => '<p>Onboarding state of the function package.</p>', ], ], 'OperationalState' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageOutput$operationalState' => '<p>Operational state of the function package.</p>', 'GetSolFunctionPackageOutput$operationalState' => '<p>Function package operational state.</p>', 'ListSolFunctionPackageInfo$operationalState' => '<p>Operational state of the function package.</p>', 'UpdateSolFunctionPackageInput$operationalState' => '<p>Operational state of the function package.</p>', 'UpdateSolFunctionPackageOutput$operationalState' => '<p>Operational state of the function package.</p>', ], ], 'OverrideList' => [ 'base' => NULL, 'refs' => [ 'FunctionArtifactMeta$overrides' => '<p>Lists of function package overrides.</p>', 'NetworkArtifactMeta$overrides' => '<p>Lists network package overrides.</p>', ], ], 'PackageContentType' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionPackageContentInput$accept' => '<p>The format of the package that you want to download from the function packages.</p>', 'GetSolFunctionPackageContentOutput$contentType' => '<p>Indicates the media type of the resource.</p>', 'GetSolNetworkPackageContentInput$accept' => '<p>The format of the package you want to download from the network package.</p>', 'GetSolNetworkPackageContentOutput$contentType' => '<p>Indicates the media type of the resource.</p>', 'PutSolFunctionPackageContentInput$contentType' => '<p>Function package content type.</p>', 'PutSolNetworkPackageContentInput$contentType' => '<p>Network package content type.</p>', 'ValidateSolFunctionPackageContentInput$contentType' => '<p>Function package content type.</p>', 'ValidateSolNetworkPackageContentInput$contentType' => '<p>Network package content type.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListSolFunctionInstancesInput$nextToken' => '<p>The token for the next page of results.</p>', 'ListSolFunctionInstancesOutput$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListSolFunctionPackagesInput$nextToken' => '<p>The token for the next page of results.</p>', 'ListSolFunctionPackagesOutput$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListSolNetworkInstancesInput$nextToken' => '<p>The token for the next page of results.</p>', 'ListSolNetworkInstancesOutput$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListSolNetworkOperationsInput$nextToken' => '<p>The token for the next page of results.</p>', 'ListSolNetworkOperationsOutput$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListSolNetworkPackagesInput$nextToken' => '<p>The token for the next page of results.</p>', 'ListSolNetworkPackagesOutput$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ProblemDetails' => [ 'base' => '<p>Details related to problems with AWS TNB resources.</p>', 'refs' => [ 'GetSolNetworkOperationOutput$error' => '<p>Error related to this specific network operation occurrence.</p>', 'ListSolNetworkOperationsInfo$error' => '<p>Error related to this specific network operation.</p>', ], ], 'PutSolFunctionPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'PutSolFunctionPackageContentMetadata' => [ 'base' => '<p>Update metadata in a function package.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'refs' => [ 'PutSolFunctionPackageContentOutput$metadata' => '<p>Function package metadata.</p>', ], ], 'PutSolFunctionPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutSolNetworkPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'PutSolNetworkPackageContentMetadata' => [ 'base' => '<p>Update metadata in a network package.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'refs' => [ 'PutSolNetworkPackageContentOutput$metadata' => '<p>Network package metadata.</p>', ], ], 'PutSolNetworkPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Request references a resource that doesn\'t exist.</p>', 'refs' => [], ], 'SensitiveBlob' => [ 'base' => NULL, 'refs' => [ 'PutSolFunctionPackageContentInput$file' => '<p>Function package file.</p>', 'PutSolNetworkPackageContentInput$file' => '<p>Network package file.</p>', 'ValidateSolFunctionPackageContentInput$file' => '<p>Function package file.</p>', 'ValidateSolNetworkPackageContentInput$file' => '<p>Network package file.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Service quotas have been exceeded.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'CreateSolNetworkInstanceOutput$nsInstanceName' => '<p>Network instance name.</p>', 'GetSolFunctionInstanceOutput$vnfProductName' => '<p>Network function product name.</p>', 'GetSolFunctionInstanceOutput$vnfProvider' => '<p>Network function provider.</p>', 'GetSolFunctionInstanceOutput$vnfdVersion' => '<p>Function package descriptor version.</p>', 'GetSolFunctionPackageOutput$vnfProductName' => '<p>Network function product name.</p>', 'GetSolFunctionPackageOutput$vnfProvider' => '<p>Network function provider.</p>', 'GetSolFunctionPackageOutput$vnfdId' => '<p>Function package descriptor ID.</p>', 'GetSolFunctionPackageOutput$vnfdVersion' => '<p>Function package descriptor version.</p>', 'GetSolNetworkInstanceOutput$nsInstanceDescription' => '<p>Network instance description.</p>', 'GetSolNetworkInstanceOutput$nsInstanceName' => '<p>Network instance name.</p>', 'GetSolNetworkOperationTaskDetails$taskName' => '<p>Task name.</p>', 'GetSolNetworkPackageOutput$nsdName' => '<p>Network service descriptor name.</p>', 'GetSolNetworkPackageOutput$nsdVersion' => '<p>Network service descriptor version.</p>', 'GetSolVnfcResourceInfoMetadata$cluster' => '<p>Information about the cluster.</p>', 'GetSolVnfcResourceInfoMetadata$helmChart' => '<p>Information about the helm chart.</p>', 'GetSolVnfcResourceInfoMetadata$nodeGroup' => '<p>Information about the node group.</p>', 'InternalServerException$message' => NULL, 'ListSolFunctionInstanceInfo$vnfPkgName' => '<p>Function package name.</p>', 'ListSolFunctionPackageInfo$vnfProductName' => '<p>The product name for the network function.</p>', 'ListSolFunctionPackageInfo$vnfProvider' => '<p>Provider of the function package and the function package descriptor.</p>', 'ListSolFunctionPackageInfo$vnfdId' => '<p>Identifies the function package and the function package descriptor.</p>', 'ListSolFunctionPackageInfo$vnfdVersion' => '<p>Identifies the version of the function package descriptor.</p>', 'ListSolNetworkInstanceInfo$nsInstanceDescription' => '<p>Human-readable description of the network instance.</p>', 'ListSolNetworkInstanceInfo$nsInstanceName' => '<p>Human-readable name of the network instance.</p>', 'ListSolNetworkPackageInfo$nsdDesigner' => '<p>Designer of the onboarded network service descriptor in the network package.</p>', 'ListSolNetworkPackageInfo$nsdId' => '<p>ID of the network service descriptor on which the network package is based.</p>', 'ListSolNetworkPackageInfo$nsdInvariantId' => '<p>Identifies a network service descriptor in a version independent manner.</p>', 'ListSolNetworkPackageInfo$nsdName' => '<p>Name of the onboarded network service descriptor in the network package.</p>', 'ListSolNetworkPackageInfo$nsdVersion' => '<p>Version of the onboarded network service descriptor in the network package.</p>', 'ProblemDetails$detail' => '<p>A human-readable explanation specific to this occurrence of the problem.</p>', 'ProblemDetails$title' => '<p>A human-readable title of the problem type.</p>', 'PutSolFunctionPackageContentOutput$vnfProductName' => '<p>Function product name.</p>', 'PutSolFunctionPackageContentOutput$vnfProvider' => '<p>Function provider.</p>', 'PutSolFunctionPackageContentOutput$vnfdVersion' => '<p>Function package descriptor version.</p>', 'PutSolNetworkPackageContentOutput$nsdName' => '<p>Network service descriptor name.</p>', 'PutSolNetworkPackageContentOutput$nsdVersion' => '<p>Network service descriptor version.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'StringMap$key' => NULL, 'StringMap$value' => NULL, 'ThrottlingException$message' => NULL, 'ToscaOverride$defaultValue' => '<p>Default value for the override.</p>', 'ToscaOverride$name' => '<p>Name of the TOSCA override.</p>', 'ValidateSolFunctionPackageContentOutput$vnfProductName' => '<p>Network function product name.</p>', 'ValidateSolFunctionPackageContentOutput$vnfProvider' => '<p>Network function provider.</p>', 'ValidateSolFunctionPackageContentOutput$vnfdVersion' => '<p>Function package descriptor version.</p>', 'ValidateSolNetworkPackageContentOutput$nsdName' => '<p>Network service descriptor name.</p>', 'ValidateSolNetworkPackageContentOutput$nsdVersion' => '<p>Network service descriptor version.</p>', 'ValidationException$message' => NULL, ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationTaskDetails$taskContext' => '<p>Context for the network operation task.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionInstanceMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'GetSolFunctionInstanceMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'GetSolFunctionPackageMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'GetSolFunctionPackageMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'GetSolNetworkInstanceMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'GetSolNetworkInstanceMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'GetSolNetworkOperationMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'GetSolNetworkOperationMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'GetSolNetworkOperationTaskDetails$taskEndTime' => '<p>Task end time.</p>', 'GetSolNetworkOperationTaskDetails$taskStartTime' => '<p>Task start time.</p>', 'GetSolNetworkPackageMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'GetSolNetworkPackageMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'ListSolFunctionInstanceMetadata$createdAt' => '<p>When the network function instance was created.</p>', 'ListSolFunctionInstanceMetadata$lastModified' => '<p>When the network function instance was last modified.</p>', 'ListSolFunctionPackageMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'ListSolFunctionPackageMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'ListSolNetworkInstanceMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'ListSolNetworkInstanceMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'ListSolNetworkOperationsMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'ListSolNetworkOperationsMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', 'ListSolNetworkPackageMetadata$createdAt' => '<p>The date that the resource was created.</p>', 'ListSolNetworkPackageMetadata$lastModified' => '<p>The date that the resource was last modified.</p>', ], ], 'TNBResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$resourceArn' => '<p>Resource ARN.</p>', 'TagResourceInput$resourceArn' => '<p>Resource ARN.</p>', 'UntagResourceInput$resourceArn' => '<p>Resource ARN.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>Tag keys.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'CreateSolFunctionPackageOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'CreateSolNetworkInstanceInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'CreateSolNetworkInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'CreateSolNetworkPackageInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'CreateSolNetworkPackageOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'GetSolFunctionInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'GetSolFunctionPackageOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'GetSolNetworkInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'GetSolNetworkOperationOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'GetSolNetworkPackageOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'InstantiateSolNetworkInstanceInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'InstantiateSolNetworkInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'ListTagsForResourceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'TagResourceInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'TerminateSolNetworkInstanceInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'TerminateSolNetworkInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'UpdateSolNetworkInstanceInput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', 'UpdateSolNetworkInstanceOutput$tags' => '<p>A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. When you use this API, the tags are only applied to the network operation that is created. These tags are not applied to the network instance. Use tags to search and filter your resources or track your Amazon Web Services costs.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TaskStatus' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationTaskDetails$taskStatus' => '<p>Task status.</p>', ], ], 'TerminateSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'TerminateSolNetworkInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Exception caused by throttling.</p>', 'refs' => [], ], 'ToscaOverride' => [ 'base' => '<p>Overrides of the TOSCA node.</p>', 'refs' => [ 'OverrideList$member' => NULL, ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNsMetadata' => [ 'base' => '<p>Metadata related to the configuration properties used during update of a network instance.</p>', 'refs' => [ 'GetSolNetworkOperationMetadata$updateNsMetadata' => '<p>Metadata related to the network operation occurrence for network instance updates. This is populated only if the lcmOperationType is <code>UPDATE</code> and the updateType is <code>UPDATE_NS</code>.</p>', ], ], 'UpdateSolFunctionPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolFunctionPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolNetworkInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolNetworkInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolNetworkModify' => [ 'base' => '<p>Information parameters and/or the configurable properties for a network function.</p> <p>A network function instance is a function in a function package .</p>', 'refs' => [ 'UpdateSolNetworkInstanceInput$modifyVnfInfoData' => '<p>Identifies the network function information parameters and/or the configurable properties of the network function to be modified.</p> <p>Include this property only if the update type is <code>MODIFY_VNF_INFORMATION</code>.</p>', ], ], 'UpdateSolNetworkPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolNetworkPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolNetworkServiceData' => [ 'base' => '<p>Information parameters and/or the configurable properties for a network descriptor used for update.</p>', 'refs' => [ 'UpdateSolNetworkInstanceInput$updateNs' => '<p>Identifies the network service descriptor and the configurable properties of the descriptor, to be used for the update.</p> <p>Include this property only if the update type is <code>UPDATE_NS</code>.</p>', ], ], 'UpdateSolNetworkType' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkOperationOutput$updateType' => '<p>Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.</p>', 'ListSolNetworkOperationsInfo$updateType' => '<p>Type of the update. Only present if the network operation lcmOperationType is <code>UPDATE</code>.</p>', 'UpdateSolNetworkInstanceInput$updateType' => '<p>The type of update.</p> <ul> <li> <p>Use the <code>MODIFY_VNF_INFORMATION</code> update type, to update a specific network function configuration, in the network instance.</p> </li> <li> <p>Use the <code>UPDATE_NS</code> update type, to update the network instance to a new network service descriptor.</p> </li> </ul>', ], ], 'UsageState' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageOutput$usageState' => '<p>Usage state of the function package.</p>', 'GetSolFunctionPackageOutput$usageState' => '<p>Function package usage state.</p>', 'ListSolFunctionPackageInfo$usageState' => '<p>Usage state of the function package.</p>', ], ], 'ValidateSolFunctionPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateSolFunctionPackageContentMetadata' => [ 'base' => '<p>Validates function package content metadata.</p> <p>A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.</p>', 'refs' => [ 'ValidateSolFunctionPackageContentOutput$metadata' => '<p>Function package metadata.</p>', ], ], 'ValidateSolFunctionPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateSolNetworkPackageContentInput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateSolNetworkPackageContentMetadata' => [ 'base' => '<p>Validates network package content metadata.</p> <p>A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.</p>', 'refs' => [ 'ValidateSolNetworkPackageContentOutput$metadata' => '<p>Network package metadata.</p>', ], ], 'ValidateSolNetworkPackageContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Unable to process the request because the client provided input failed to satisfy request constraints.</p>', 'refs' => [], ], 'VnfInstanceArn' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionInstanceOutput$arn' => '<p>Network function instance ARN.</p>', 'ListSolFunctionInstanceInfo$arn' => '<p>Network function instance ARN.</p>', ], ], 'VnfInstanceId' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionInstanceInput$vnfInstanceId' => '<p>ID of the network function.</p>', 'GetSolFunctionInstanceOutput$id' => '<p>Network function instance ID.</p>', 'ListSolFunctionInstanceInfo$id' => '<p>Network function instance ID.</p>', 'ListSolNetworkOperationsMetadata$vnfInstanceId' => '<p>The network function id used for the operation.</p> <p>Only present if the updateType is <code>MODIFY_VNF_INFO</code>.</p>', 'ModifyVnfInfoMetadata$vnfInstanceId' => '<p>The network function instance that was updated in the network instance.</p>', 'UpdateSolNetworkModify$vnfInstanceId' => '<p>ID of the network function instance.</p> <p>A network function instance is a function in a function package .</p>', ], ], 'VnfInstantiationState' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionInstanceOutput$instantiationState' => '<p>Network function instantiation state.</p>', 'ListSolFunctionInstanceInfo$instantiationState' => '<p>Network function instance instantiation state.</p>', ], ], 'VnfOperationalState' => [ 'base' => NULL, 'refs' => [ 'GetSolInstantiatedVnfInfo$vnfState' => '<p>State of the network function.</p>', 'GetSolVnfInfo$vnfState' => '<p>State of the network function instance.</p>', ], ], 'VnfPkgArn' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageOutput$arn' => '<p>Function package ARN.</p>', 'GetSolFunctionPackageOutput$arn' => '<p>Function package ARN.</p>', 'ListSolFunctionPackageInfo$arn' => '<p>Function package ARN.</p>', ], ], 'VnfPkgId' => [ 'base' => NULL, 'refs' => [ 'CreateSolFunctionPackageOutput$id' => '<p>ID of the function package.</p>', 'DeleteSolFunctionPackageInput$vnfPkgId' => '<p>ID of the function package.</p>', 'GetSolFunctionInstanceOutput$vnfPkgId' => '<p>Function package ID.</p>', 'GetSolFunctionPackageContentInput$vnfPkgId' => '<p>ID of the function package.</p>', 'GetSolFunctionPackageDescriptorInput$vnfPkgId' => '<p>ID of the function package.</p>', 'GetSolFunctionPackageInput$vnfPkgId' => '<p>ID of the function package.</p>', 'GetSolFunctionPackageOutput$id' => '<p>Function package ID.</p>', 'ListSolFunctionInstanceInfo$vnfPkgId' => '<p>Function package ID.</p>', 'ListSolFunctionPackageInfo$id' => '<p>ID of the function package.</p>', 'PutSolFunctionPackageContentInput$vnfPkgId' => '<p>Function package ID.</p>', 'PutSolFunctionPackageContentOutput$id' => '<p>Function package ID.</p>', 'UpdateSolFunctionPackageInput$vnfPkgId' => '<p>ID of the function package.</p>', 'ValidateSolFunctionPackageContentInput$vnfPkgId' => '<p>Function package ID.</p>', 'ValidateSolFunctionPackageContentOutput$id' => '<p>Function package ID.</p>', 'VnfPkgIdList$member' => NULL, ], ], 'VnfPkgIdList' => [ 'base' => NULL, 'refs' => [ 'GetSolNetworkPackageOutput$vnfPkgIds' => '<p>Identifies the function package for the function package descriptor referenced by the onboarded network package.</p>', 'ListSolNetworkPackageInfo$vnfPkgIds' => '<p>Identifies the function package for the function package descriptor referenced by the onboarded network package.</p>', 'PutSolNetworkPackageContentOutput$vnfPkgIds' => '<p>Function package IDs.</p>', 'ValidateSolNetworkPackageContentOutput$vnfPkgIds' => '<p>Function package IDs.</p>', ], ], 'VnfdId' => [ 'base' => NULL, 'refs' => [ 'GetSolFunctionInstanceOutput$vnfdId' => '<p>Function package descriptor ID.</p>', 'PutSolFunctionPackageContentOutput$vnfdId' => '<p>Function package descriptor ID.</p>', 'ValidateSolFunctionPackageContentOutput$vnfdId' => '<p>Function package descriptor ID.</p>', ], ], ],];
