<?php
// This file was auto-generated from sdk-root/src/data/voice-id/2021-09-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Connect Voice ID provides real-time caller authentication and fraud risk detection, which make voice interactions in contact centers more secure and efficient.</p>', 'operations' => [ 'AssociateFraudster' => '<p>Associates the fraudsters with the watchlist specified in the same domain. </p>', 'CreateDomain' => '<p>Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.</p>', 'CreateWatchlist' => '<p>Creates a watchlist that fraudsters can be a part of.</p>', 'DeleteDomain' => '<p>Deletes the specified domain from Voice ID.</p>', 'DeleteFraudster' => '<p>Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is a part of.</p>', 'DeleteSpeaker' => '<p>Deletes the specified speaker from Voice ID.</p>', 'DeleteWatchlist' => '<p>Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every domain has a default watchlist which cannot be deleted. </p>', 'DescribeDomain' => '<p>Describes the specified domain.</p>', 'DescribeFraudster' => '<p>Describes the specified fraudster.</p>', 'DescribeFraudsterRegistrationJob' => '<p>Describes the specified fraudster registration job.</p>', 'DescribeSpeaker' => '<p>Describes the specified speaker.</p>', 'DescribeSpeakerEnrollmentJob' => '<p>Describes the specified speaker enrollment job.</p>', 'DescribeWatchlist' => '<p>Describes the specified watchlist.</p>', 'DisassociateFraudster' => '<p>Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at least one watchlist. If you try to disassociate a fraudster from its only watchlist, a <code>ValidationException</code> is thrown. </p>', 'EvaluateSession' => '<p>Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.</p>', 'ListDomains' => '<p>Lists all the domains in the Amazon Web Services account. </p>', 'ListFraudsterRegistrationJobs' => '<p>Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain. </p>', 'ListFraudsters' => '<p>Lists all fraudsters in a specified watchlist or domain.</p>', 'ListSpeakerEnrollmentJobs' => '<p>Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.</p>', 'ListSpeakers' => '<p>Lists all speakers in a specified domain.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a specified Voice ID resource.</p>', 'ListWatchlists' => '<p>Lists all watchlists in a specified domain.</p>', 'OptOutSpeaker' => '<p>Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don\'t yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.</p>', 'StartFraudsterRegistrationJob' => '<p>Starts a new batch fraudster registration job using provided details.</p>', 'StartSpeakerEnrollmentJob' => '<p>Starts a new batch speaker enrollment job using specified details.</p>', 'TagResource' => '<p>Tags a Voice ID resource with the provided list of tags.</p>', 'UntagResource' => '<p>Removes specified tags from a specified Amazon Connect Voice ID resource.</p>', 'UpdateDomain' => '<p>Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as \'Description\' is not provided, it is removed from the domain.</p>', 'UpdateWatchlist' => '<p>Updates the specified watchlist. Every domain has a default watchlist which cannot be updated. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action. Check the error message and try again.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Domain$Arn' => '<p>The Amazon Resource Name (ARN) for the domain.</p>', 'DomainSummary$Arn' => '<p>The Amazon Resource Name (ARN) for the domain.</p>', ], ], 'AssociateFraudsterRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFraudsterResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationConfiguration' => [ 'base' => '<p>The configuration used to authenticate a speaker during a session.</p>', 'refs' => [ 'AuthenticationResult$Configuration' => '<p>The <code>AuthenticationConfiguration</code> used to generate this authentication result.</p>', ], ], 'AuthenticationDecision' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResult$Decision' => '<p>The authentication decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.</p>', ], ], 'AuthenticationResult' => [ 'base' => '<p>The authentication result produced by Voice ID, processed against the current session state and streamed audio of the speaker.</p>', 'refs' => [ 'EvaluateSessionResponse$AuthenticationResult' => '<p>Details resulting from the authentication process, such as authentication decision and authentication score.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Watchlist$DefaultWatchlist' => '<p>Whether the specified watchlist is the default watchlist of a domain.</p>', 'WatchlistSummary$DefaultWatchlist' => '<p>Whether the specified watchlist is the default watchlist of a domain.</p>', ], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateWatchlistRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartFraudsterRegistrationJobRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartSpeakerEnrollmentJobRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more details.</p>', 'refs' => [], ], 'ConflictType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ConflictType' => '<p>The type of conflict which caused a ConflictException. Possible types and the corresponding error messages are as follows:</p> <ul> <li> <p> <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.</p> </li> <li> <p> <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has been requested.</p> </li> <li> <p> <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.</p> </li> <li> <p> <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.</p> </li> <li> <p> <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.</p> </li> <li> <p> <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another request during execution.</p> </li> </ul>', ], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWatchlistRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWatchlistResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerSpeakerId' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResult$CustomerSpeakerId' => '<p>The client-provided identifier for the speaker whose authentication result is produced. Only present if a <code>SpeakerId</code> is provided for the session.</p>', 'Speaker$CustomerSpeakerId' => '<p>The client-provided identifier for the speaker.</p>', 'SpeakerSummary$CustomerSpeakerId' => '<p>The client-provided identifier for the speaker.</p>', ], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFraudsterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpeakerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWatchlistRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFraudsterRegistrationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFraudsterRegistrationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFraudsterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFraudsterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpeakerEnrollmentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpeakerEnrollmentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpeakerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpeakerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWatchlistRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWatchlistResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$Description' => '<p>A brief description of this domain.</p>', 'Domain$Description' => '<p>The description of the domain.</p>', 'DomainSummary$Description' => '<p>The description of the domain.</p>', 'UpdateDomainRequest$Description' => '<p>A brief description about this domain.</p>', ], ], 'DisassociateFraudsterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFraudsterResponse' => [ 'base' => NULL, 'refs' => [], ], 'Domain' => [ 'base' => '<p>Contains all the information about a domain.</p>', 'refs' => [ 'CreateDomainResponse$Domain' => '<p>Information about the newly created domain.</p>', 'DescribeDomainResponse$Domain' => '<p>Information about the specified domain.</p>', 'UpdateDomainResponse$Domain' => '<p>Details about the updated domain</p>', ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'AssociateFraudsterRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster.</p>', 'CreateWatchlistRequest$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', 'DeleteDomainRequest$DomainId' => '<p>The identifier of the domain you want to delete.</p>', 'DeleteFraudsterRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster.</p>', 'DeleteSpeakerRequest$DomainId' => '<p>The identifier of the domain that contains the speaker.</p>', 'DeleteWatchlistRequest$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', 'DescribeDomainRequest$DomainId' => '<p>The identifier of the domain that you are describing.</p>', 'DescribeFraudsterRegistrationJobRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster registration job.</p>', 'DescribeFraudsterRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster.</p>', 'DescribeSpeakerEnrollmentJobRequest$DomainId' => '<p>The identifier of the domain that contains the speaker enrollment job.</p>', 'DescribeSpeakerRequest$DomainId' => '<p>The identifier of the domain that contains the speaker.</p>', 'DescribeWatchlistRequest$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', 'DisassociateFraudsterRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster.</p>', 'Domain$DomainId' => '<p>The identifier of the domain.</p>', 'DomainSummary$DomainId' => '<p>The identifier of the domain.</p>', 'EvaluateSessionRequest$DomainId' => '<p>The identifier of the domain where the session started.</p>', 'EvaluateSessionResponse$DomainId' => '<p>The identifier of the domain that contains the session.</p>', 'Fraudster$DomainId' => '<p>The identifier of the domain that contains the fraudster.</p>', 'FraudsterRegistrationJob$DomainId' => '<p>The identifier of the domain that contains the fraudster registration job.</p>', 'FraudsterRegistrationJobSummary$DomainId' => '<p>The identifier of the domain that contains the fraudster registration job.</p>', 'FraudsterSummary$DomainId' => '<p>The identifier of the domain that contains the fraudster summary.</p>', 'ListFraudsterRegistrationJobsRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster registration Jobs.</p>', 'ListFraudstersRequest$DomainId' => '<p>The identifier of the domain. </p>', 'ListSpeakerEnrollmentJobsRequest$DomainId' => '<p>The identifier of the domain that contains the speaker enrollment jobs.</p>', 'ListSpeakersRequest$DomainId' => '<p>The identifier of the domain.</p>', 'ListWatchlistsRequest$DomainId' => '<p>The identifier of the domain.</p>', 'OptOutSpeakerRequest$DomainId' => '<p>The identifier of the domain that contains the speaker.</p>', 'Speaker$DomainId' => '<p>The identifier of the domain that contains the speaker.</p>', 'SpeakerEnrollmentJob$DomainId' => '<p>The identifier of the domain that contains the speaker enrollment job.</p>', 'SpeakerEnrollmentJobSummary$DomainId' => '<p>The identifier of the domain that contains the speaker enrollment job.</p>', 'SpeakerSummary$DomainId' => '<p>The identifier of the domain that contains the speaker.</p>', 'StartFraudsterRegistrationJobRequest$DomainId' => '<p>The identifier of the domain that contains the fraudster registration job and in which the fraudsters are registered.</p>', 'StartSpeakerEnrollmentJobRequest$DomainId' => '<p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled. </p>', 'UpdateDomainRequest$DomainId' => '<p>The identifier of the domain to be updated.</p>', 'UpdateWatchlistRequest$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', 'Watchlist$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', 'WatchlistSummary$DomainId' => '<p>The identifier of the domain that contains the watchlist.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$Name' => '<p>The name of the domain.</p>', 'Domain$Name' => '<p>The name for the domain.</p>', 'DomainSummary$Name' => '<p>The client-provided name for the domain.</p>', 'UpdateDomainRequest$Name' => '<p>The name of the domain.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'Domain$DomainStatus' => '<p>The current status of the domain.</p>', 'DomainSummary$DomainStatus' => '<p>The current status of the domain.</p>', ], ], 'DomainSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$DomainSummaries' => '<p>A list containing details about each domain in the Amazon Web Services account.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>Contains a summary of information about a domain.</p>', 'refs' => [ 'DomainSummaries$member' => NULL, ], ], 'DuplicateRegistrationAction' => [ 'base' => NULL, 'refs' => [ 'RegistrationConfig$DuplicateRegistrationAction' => '<p>The action to take when a fraudster is identified as a duplicate. The default action is <code>SKIP</code>, which skips registering the duplicate fraudster. Setting the value to <code>REGISTER_AS_NEW</code> always registers a new fraudster into the specified domain.</p>', ], ], 'EnrollmentConfig' => [ 'base' => '<p>Contains configurations defining enrollment behavior for the batch job.</p>', 'refs' => [ 'SpeakerEnrollmentJob$EnrollmentConfig' => '<p>The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the <code>FraudDetectionConfig</code> to use.</p>', 'StartSpeakerEnrollmentJobRequest$EnrollmentConfig' => '<p>The enrollment config that contains details such as the action to take when a speaker is already enrolled in Voice ID or when a speaker is identified as a fraudster.</p>', ], ], 'EnrollmentJobFraudDetectionConfig' => [ 'base' => '<p>The fraud detection configuration to be used during the batch speaker enrollment job.</p>', 'refs' => [ 'EnrollmentConfig$FraudDetectionConfig' => '<p>The fraud detection configuration to use for the speaker enrollment job.</p>', ], ], 'EnrollmentJobFraudDetectionConfigWatchlistIds' => [ 'base' => NULL, 'refs' => [ 'EnrollmentJobFraudDetectionConfig$WatchlistIds' => '<p>The identifier of watchlists against which fraud detection is performed. </p>', ], ], 'EvaluateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'EvaluateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExistingEnrollmentAction' => [ 'base' => NULL, 'refs' => [ 'EnrollmentConfig$ExistingEnrollmentAction' => '<p> The action to take when the specified speaker is already enrolled in the specified domain. The default value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker with new data generated from the latest audio.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Contains error details for a failed batch job.</p>', 'refs' => [ 'FraudsterRegistrationJob$FailureDetails' => '<p>Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn\'t fail; it is completed with a <code>JobStatus</code> of <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration requests that failed.</p>', 'FraudsterRegistrationJobSummary$FailureDetails' => '<p>Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn\'t fail; it is completed with a <code>JobStatus</code> of <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration requests that failed.</p>', 'SpeakerEnrollmentJob$FailureDetails' => '<p>Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn\'t fail; it is completed with a <code>JobStatus</code> of <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration requests that failed.</p>', 'SpeakerEnrollmentJobSummary$FailureDetails' => '<p>Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn\'t fail; it is completed with a <code>JobStatus</code> of <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual registration requests that failed.</p>', ], ], 'FraudDetectionAction' => [ 'base' => NULL, 'refs' => [ 'EnrollmentJobFraudDetectionConfig$FraudDetectionAction' => '<p>The action to take when the given speaker is flagged by the fraud detection system. The default value is <code>FAIL</code>, which fails the speaker enrollment. Changing this value to <code>IGNORE</code> results in the speaker being enrolled even if they are flagged by the fraud detection system.</p>', ], ], 'FraudDetectionConfiguration' => [ 'base' => '<p>The configuration used for performing fraud detection over a speaker during a session.</p>', 'refs' => [ 'FraudDetectionResult$Configuration' => '<p>The <code>FraudDetectionConfiguration</code> used to generate this fraud detection result.</p>', ], ], 'FraudDetectionDecision' => [ 'base' => NULL, 'refs' => [ 'FraudDetectionResult$Decision' => '<p>The fraud detection decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.</p>', ], ], 'FraudDetectionReason' => [ 'base' => NULL, 'refs' => [ 'FraudDetectionReasons$member' => NULL, ], ], 'FraudDetectionReasons' => [ 'base' => NULL, 'refs' => [ 'FraudDetectionResult$Reasons' => '<p>The reason speaker was flagged by the fraud detection system. This is only be populated if fraud detection Decision is <code>HIGH_RISK</code>, and the following possible values: <code>KNOWN_FRAUDSTER</code> and <code>VOICE_SPOOFING</code>.</p>', ], ], 'FraudDetectionResult' => [ 'base' => '<p>The fraud detection result produced by Voice ID, processed against the current session state and streamed audio of the speaker.</p>', 'refs' => [ 'EvaluateSessionResponse$FraudDetectionResult' => '<p>Details resulting from the fraud detection process, such as fraud detection decision and risk score.</p>', ], ], 'FraudRiskDetails' => [ 'base' => '<p>Details regarding various fraud risk analyses performed against the current session state and streamed audio of the speaker.</p>', 'refs' => [ 'FraudDetectionResult$RiskDetails' => '<p>Details about each risk analyzed for this speaker. Currently, this contains KnownFraudsterRisk and VoiceSpoofingRisk details.</p>', ], ], 'Fraudster' => [ 'base' => '<p>Contains all the information about a fraudster.</p>', 'refs' => [ 'AssociateFraudsterResponse$Fraudster' => NULL, 'DescribeFraudsterResponse$Fraudster' => '<p>Information about the specified fraudster.</p>', 'DisassociateFraudsterResponse$Fraudster' => NULL, ], ], 'FraudsterId' => [ 'base' => NULL, 'refs' => [ 'AssociateFraudsterRequest$FraudsterId' => '<p>The identifier of the fraudster to be associated with the watchlist.</p>', 'DeleteFraudsterRequest$FraudsterId' => '<p>The identifier of the fraudster you want to delete.</p>', 'DescribeFraudsterRequest$FraudsterId' => '<p>The identifier of the fraudster you are describing.</p>', 'DisassociateFraudsterRequest$FraudsterId' => '<p>The identifier of the fraudster to be disassociated from the watchlist.</p>', ], ], 'FraudsterRegistrationJob' => [ 'base' => '<p>Contains all the information about a fraudster registration job.</p>', 'refs' => [ 'DescribeFraudsterRegistrationJobResponse$Job' => '<p>Contains details about the specified fraudster registration job.</p>', 'StartFraudsterRegistrationJobResponse$Job' => '<p>Details about the started fraudster registration job.</p>', ], ], 'FraudsterRegistrationJobStatus' => [ 'base' => NULL, 'refs' => [ 'FraudsterRegistrationJob$JobStatus' => '<p>The current status of the fraudster registration job.</p>', 'FraudsterRegistrationJobSummary$JobStatus' => '<p>The current status of the fraudster registration job.</p>', 'ListFraudsterRegistrationJobsRequest$JobStatus' => '<p>Provides the status of your fraudster registration job.</p>', ], ], 'FraudsterRegistrationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFraudsterRegistrationJobsResponse$JobSummaries' => '<p>A list containing details about each specified fraudster registration job.</p>', ], ], 'FraudsterRegistrationJobSummary' => [ 'base' => '<p>Contains a summary of information about a fraudster registration job.</p>', 'refs' => [ 'FraudsterRegistrationJobSummaries$member' => NULL, ], ], 'FraudsterSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFraudstersResponse$FraudsterSummaries' => '<p>A list that contains details about each fraudster in the Amazon Web Services account. </p>', ], ], 'FraudsterSummary' => [ 'base' => '<p>Contains a summary of information about a fraudster. </p>', 'refs' => [ 'FraudsterSummaries$member' => NULL, ], ], 'GeneratedFraudsterId' => [ 'base' => NULL, 'refs' => [ 'Fraudster$GeneratedFraudsterId' => '<p>The service-generated identifier for the fraudster.</p>', 'FraudsterSummary$GeneratedFraudsterId' => '<p>The service-generated identifier for the fraudster.</p>', 'KnownFraudsterRisk$GeneratedFraudsterId' => '<p>The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is <code>null</code>.</p>', ], ], 'GeneratedSpeakerId' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResult$GeneratedSpeakerId' => '<p>The service-generated identifier for the speaker whose authentication result is produced.</p>', 'Speaker$GeneratedSpeakerId' => '<p>The service-generated identifier for the speaker.</p>', 'SpeakerSummary$GeneratedSpeakerId' => '<p>The service-generated identifier for the speaker. </p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'FraudsterRegistrationJob$DataAccessRoleArn' => '<p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer\'s buckets to read the input manifest file and write the job output file.</p>', 'SpeakerEnrollmentJob$DataAccessRoleArn' => '<p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer\'s buckets to read the input manifest file and write the job output file.</p>', 'StartFraudsterRegistrationJobRequest$DataAccessRoleArn' => '<p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer\'s buckets to read the input manifest file and write the Job output file. Refer to the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>', 'StartSpeakerEnrollmentJobRequest$DataAccessRoleArn' => '<p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer\'s buckets to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior calls</a> for the permissions needed in this role.</p>', ], ], 'InputDataConfig' => [ 'base' => '<p>The configuration containing input file information for a batch job.</p>', 'refs' => [ 'FraudsterRegistrationJob$InputDataConfig' => '<p>The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration job requests.</p>', 'SpeakerEnrollmentJob$InputDataConfig' => '<p>The input data config containing an S3 URI for the input manifest file that contains the list of speaker enrollment job requests.</p>', 'StartFraudsterRegistrationJobRequest$InputDataConfig' => '<p>The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.</p>', 'StartSpeakerEnrollmentJobRequest$InputDataConfig' => '<p>The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'FailureDetails$StatusCode' => '<p>An HTTP status code representing the nature of the error.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request failed due to an unknown error on the server side.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeFraudsterRegistrationJobRequest$JobId' => '<p>The identifier of the fraudster registration job you are describing.</p>', 'DescribeSpeakerEnrollmentJobRequest$JobId' => '<p>The identifier of the speaker enrollment job you are describing.</p>', 'FraudsterRegistrationJob$JobId' => '<p>The service-generated identifier for the fraudster registration job.</p>', 'FraudsterRegistrationJobSummary$JobId' => '<p>The service-generated identifier for the fraudster registration job.</p>', 'SpeakerEnrollmentJob$JobId' => '<p>The service-generated identifier for the speaker enrollment job.</p>', 'SpeakerEnrollmentJobSummary$JobId' => '<p>The service-generated identifier for the speaker enrollment job.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'FraudsterRegistrationJob$JobName' => '<p>The client-provided name for the fraudster registration job.</p>', 'FraudsterRegistrationJobSummary$JobName' => '<p>The client-provided name for the fraudster registration job.</p>', 'SpeakerEnrollmentJob$JobName' => '<p>The client-provided name for the speaker enrollment job.</p>', 'SpeakerEnrollmentJobSummary$JobName' => '<p>The client-provided name for the speaker enrollment job.</p>', 'StartFraudsterRegistrationJobRequest$JobName' => '<p>The name of the new fraudster registration job.</p>', 'StartSpeakerEnrollmentJobRequest$JobName' => '<p>A name for your speaker enrollment job.</p>', ], ], 'JobProgress' => [ 'base' => '<p>Indicates the completion progress for a batch job.</p>', 'refs' => [ 'FraudsterRegistrationJob$JobProgress' => '<p>Shows the completed percentage of registration requests listed in the input file.</p>', 'FraudsterRegistrationJobSummary$JobProgress' => '<p>Shows the completed percentage of registration requests listed in the input file.</p>', 'SpeakerEnrollmentJob$JobProgress' => '<p>Provides details on job progress. This field shows the completed percentage of registration requests listed in the input file.</p>', 'SpeakerEnrollmentJobSummary$JobProgress' => '<p>Provides details regarding job progress. This field shows the completed percentage of enrollment requests listed in the input file.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'OutputDataConfig$KmsKeyId' => '<p>The identifier of the KMS key you want Voice ID to use to encrypt the output file of a speaker enrollment job/fraudster registration job. </p>', 'ServerSideEncryptionConfiguration$KmsKeyId' => '<p>The identifier of the KMS key to use to encrypt data stored by Voice ID. Voice ID doesn\'t support asymmetric customer managed keys. </p>', 'ServerSideEncryptionUpdateDetails$OldKmsKeyId' => '<p>The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was updated to a new KMS key ID.</p>', ], ], 'KnownFraudsterRisk' => [ 'base' => '<p>Contains details produced as a result of performing known fraudster risk analysis on a speaker.</p>', 'refs' => [ 'FraudRiskDetails$KnownFraudsterRisk' => '<p>The details resulting from \'Known Fraudster Risk\' analysis of the speaker.</p>', ], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFraudsterRegistrationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFraudsterRegistrationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFraudstersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFraudstersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSpeakerEnrollmentJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSpeakerEnrollmentJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSpeakersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSpeakersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWatchlistsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWatchlistsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResultsForList' => [ 'base' => NULL, 'refs' => [ 'ListFraudsterRegistrationJobsRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100. </p>', 'ListFraudstersRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100. </p>', 'ListSpeakerEnrollmentJobsRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100.</p>', 'ListSpeakersRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100. </p>', 'ListWatchlistsRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100. </p>', ], ], 'MaxResultsForListDomainFe' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$MaxResults' => '<p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain more pages of results. The default is 100; the maximum allowed page size is also 100.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListFraudsterRegistrationJobsRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListFraudstersRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListSpeakerEnrollmentJobsRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListSpeakersRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListWatchlistsRequest$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', ], ], 'OptOutSpeakerRequest' => [ 'base' => NULL, 'refs' => [], ], 'OptOutSpeakerResponse' => [ 'base' => NULL, 'refs' => [], ], 'OutputDataConfig' => [ 'base' => '<p>The configuration containing output file information for a batch job.</p>', 'refs' => [ 'FraudsterRegistrationJob$OutputDataConfig' => '<p>The output data config containing the S3 location where you want Voice ID to write your job output file; you must also include a KMS key ID in order to encrypt the file.</p>', 'SpeakerEnrollmentJob$OutputDataConfig' => '<p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.</p>', 'StartFraudsterRegistrationJobRequest$OutputDataConfig' => '<p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.</p>', 'StartSpeakerEnrollmentJobRequest$OutputDataConfig' => '<p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.</p>', ], ], 'RegistrationConfig' => [ 'base' => '<p>The registration configuration to be used during the batch fraudster registration job.</p>', 'refs' => [ 'FraudsterRegistrationJob$RegistrationConfig' => '<p>The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>', 'StartFraudsterRegistrationJobRequest$RegistrationConfig' => '<p>The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster. </p>', ], ], 'RegistrationConfigWatchlistIds' => [ 'base' => NULL, 'refs' => [ 'RegistrationConfig$WatchlistIds' => '<p>The identifiers of watchlists that a fraudster is registered to. If a watchlist isn\'t provided, the fraudsters are registered to the default watchlist. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for more details.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceType' => '<p>The type of resource which cannot not be found. Possible types are <code>BATCH_JOB</code>, <code>COMPLIANCE_CONSENT</code>, <code>DOMAIN</code>, <code>FRAUDSTER</code>, <code>SESSION</code> and <code>SPEAKER</code>.</p>', ], ], 'ResponseWatchlistIds' => [ 'base' => NULL, 'refs' => [ 'Fraudster$WatchlistIds' => '<p>The identifier of the watchlists the fraudster is a part of.</p>', 'FraudsterSummary$WatchlistIds' => '<p>The identifier of the watchlists the fraudster is a part of.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$S3Uri' => '<p>The S3 location for the input manifest file that contains the list of individual enrollment or registration job requests.</p>', 'OutputDataConfig$S3Uri' => '<p>The S3 path of the folder where Voice ID writes the job output file. It has a <code>*.out</code> extension. For example, if the input file name is <code>input-file.json</code> and the output folder path is <code>s3://output-bucket/output-folder</code>, the full output file path is <code>s3://output-bucket/output-folder/job-Id/input-file.json.out</code>.</p>', ], ], 'Score' => [ 'base' => NULL, 'refs' => [ 'AuthenticationConfiguration$AcceptanceThreshold' => '<p>The minimum threshold needed to successfully authenticate a speaker.</p>', 'AuthenticationResult$Score' => '<p>The authentication score for the speaker whose authentication result is produced. This value is only present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.</p>', 'EnrollmentJobFraudDetectionConfig$RiskThreshold' => '<p>Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.</p>', 'FraudDetectionConfiguration$RiskThreshold' => '<p>Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.</p>', 'JobProgress$PercentComplete' => '<p>Shows the completed percentage of enrollment or registration requests listed in the input file.</p>', 'KnownFraudsterRisk$RiskScore' => '<p>The score indicating the likelihood the speaker is a known fraudster.</p>', 'RegistrationConfig$FraudsterSimilarityThreshold' => '<p>The minimum similarity score between the new and old fraudsters in order to consider the new fraudster a duplicate.</p>', 'VoiceSpoofingRisk$RiskScore' => '<p>The score indicating the likelihood of speaker’s voice being spoofed.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>The configuration containing information about the customer managed key used for encrypting customer data.</p>', 'refs' => [ 'CreateDomainRequest$ServerSideEncryptionConfiguration' => '<p>The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid"> Amazon Connect Voice ID encryption at rest</a> for more details on how the KMS key is used. </p>', 'Domain$ServerSideEncryptionConfiguration' => '<p>The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt your data.</p>', 'DomainSummary$ServerSideEncryptionConfiguration' => '<p>The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt your data.</p>', 'UpdateDomainRequest$ServerSideEncryptionConfiguration' => '<p>The configuration, containing the KMS key identifier, to be used by Voice ID for the server-side encryption of your data. Changing the domain\'s associated KMS key immediately triggers an asynchronous process to remove dependency on the old KMS key, such that the domain\'s data can only be accessed using the new KMS key. The domain\'s <code>ServerSideEncryptionUpdateDetails</code> contains the details for this process.</p>', ], ], 'ServerSideEncryptionUpdateDetails' => [ 'base' => '<p>Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain’s data can only be accessed using the new KMS key.</p>', 'refs' => [ 'Domain$ServerSideEncryptionUpdateDetails' => '<p>Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain\'s data can only be accessed using the new KMS key.</p>', 'DomainSummary$ServerSideEncryptionUpdateDetails' => '<p>Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain\'s data can only be accessed using the new KMS key.</p>', ], ], 'ServerSideEncryptionUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'ServerSideEncryptionUpdateDetails$UpdateStatus' => '<p>Status of the server-side encryption update. During an update, if there is an issue with the domain\'s current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the existing server-side encryption configuration will re-attempt this update process.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeded the service quota. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas">Voice ID Service Quotas</a> and try your request again.</p>', 'refs' => [], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'EvaluateSessionResponse$SessionId' => '<p>The service-generated identifier of the session.</p>', ], ], 'SessionName' => [ 'base' => NULL, 'refs' => [ 'EvaluateSessionResponse$SessionName' => '<p>The client-provided name of the session.</p>', ], ], 'SessionNameOrId' => [ 'base' => NULL, 'refs' => [ 'EvaluateSessionRequest$SessionNameOrId' => '<p>The session identifier, or name of the session, that you want to evaluate. In Voice ID integration, this is the Contact-Id.</p>', ], ], 'Speaker' => [ 'base' => '<p>Contains all the information about a speaker.</p>', 'refs' => [ 'DescribeSpeakerResponse$Speaker' => '<p>Information about the specified speaker.</p>', 'OptOutSpeakerResponse$Speaker' => '<p>Details about the opted-out speaker.</p>', ], ], 'SpeakerEnrollmentJob' => [ 'base' => '<p>Contains all the information about a speaker enrollment job.</p>', 'refs' => [ 'DescribeSpeakerEnrollmentJobResponse$Job' => '<p>Contains details about the specified speaker enrollment job.</p>', 'StartSpeakerEnrollmentJobResponse$Job' => '<p>Details about the started speaker enrollment job.</p>', ], ], 'SpeakerEnrollmentJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListSpeakerEnrollmentJobsRequest$JobStatus' => '<p>Provides the status of your speaker enrollment Job.</p>', 'SpeakerEnrollmentJob$JobStatus' => '<p>The current status of the speaker enrollment job.</p>', 'SpeakerEnrollmentJobSummary$JobStatus' => '<p>The current status of the speaker enrollment job.</p>', ], ], 'SpeakerEnrollmentJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSpeakerEnrollmentJobsResponse$JobSummaries' => '<p>A list containing details about each specified speaker enrollment job.</p>', ], ], 'SpeakerEnrollmentJobSummary' => [ 'base' => '<p>Contains a summary of information about a speaker enrollment job.</p>', 'refs' => [ 'SpeakerEnrollmentJobSummaries$member' => NULL, ], ], 'SpeakerId' => [ 'base' => NULL, 'refs' => [ 'DeleteSpeakerRequest$SpeakerId' => '<p>The identifier of the speaker you want to delete.</p>', 'DescribeSpeakerRequest$SpeakerId' => '<p>The identifier of the speaker you are describing.</p>', 'OptOutSpeakerRequest$SpeakerId' => '<p>The identifier of the speaker you want opted-out.</p>', ], ], 'SpeakerStatus' => [ 'base' => NULL, 'refs' => [ 'Speaker$Status' => '<p>The current status of the speaker.</p>', 'SpeakerSummary$Status' => '<p>The current status of the speaker.</p>', ], ], 'SpeakerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSpeakersResponse$SpeakerSummaries' => '<p>A list containing details about each speaker in the Amazon Web Services account. </p>', ], ], 'SpeakerSummary' => [ 'base' => '<p>Contains a summary of information about a speaker.</p>', 'refs' => [ 'SpeakerSummaries$member' => NULL, ], ], 'StartFraudsterRegistrationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFraudsterRegistrationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSpeakerEnrollmentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSpeakerEnrollmentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StreamingStatus' => [ 'base' => NULL, 'refs' => [ 'EvaluateSessionResponse$StreamingStatus' => '<p>The current status of audio streaming for this session. This field is useful to infer next steps when the Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that the client should call the API again later, after Voice ID has enough audio to produce a result. If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform evaluation, and a new streaming session is needed to try again.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'FailureDetails$Message' => '<p>A description of the error that caused the batch job failure.</p>', 'InternalServerException$Message' => NULL, 'ListDomainsResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListFraudsterRegistrationJobsResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.</p>', 'ListFraudstersResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListSpeakerEnrollmentJobsResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListSpeakersResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListWatchlistsResponse$NextToken' => '<p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ResourceNotFoundException$Message' => NULL, 'ServerSideEncryptionUpdateDetails$Message' => '<p>Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the cause of the failure.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The first part of a key:value pair that forms a tag associated with a given resource. For example, in the tag \'Department\':\'Sales\', the key is \'Department\'. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys you want to remove from the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$Tags' => '<p>A list of tags you want added to the domain.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tags associated with the specified resource.</p>', 'TagResourceRequest$Tags' => '<p>The list of tags to assign to the specified resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The second part of a key:value pair that forms a tag associated with a given resource. For example, in the tag \'Department\':\'Sales\', the value is \'Sales\'. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling. Please slow down your request rate. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas"> Amazon Connect Voice ID Service API throttling quotas </a> and try your request again.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResult$AudioAggregationEndedAt' => '<p>A timestamp of when audio aggregation ended for this authentication result.</p>', 'AuthenticationResult$AudioAggregationStartedAt' => '<p>A timestamp of when audio aggregation started for this authentication result.</p>', 'Domain$CreatedAt' => '<p>The timestamp of when the domain was created.</p>', 'Domain$UpdatedAt' => '<p>The timestamp of when the domain was last update.</p>', 'DomainSummary$CreatedAt' => '<p>The timestamp of when the domain was created.</p>', 'DomainSummary$UpdatedAt' => '<p>The timestamp of when the domain was last updated.</p>', 'FraudDetectionResult$AudioAggregationEndedAt' => '<p>A timestamp of when audio aggregation ended for this fraud detection result.</p>', 'FraudDetectionResult$AudioAggregationStartedAt' => '<p>A timestamp of when audio aggregation started for this fraud detection result.</p>', 'Fraudster$CreatedAt' => '<p>The timestamp of when Voice ID identified the fraudster.</p>', 'FraudsterRegistrationJob$CreatedAt' => '<p>A timestamp of when the fraudster registration job was created.</p>', 'FraudsterRegistrationJob$EndedAt' => '<p>A timestamp of when the fraudster registration job ended.</p>', 'FraudsterRegistrationJobSummary$CreatedAt' => '<p>A timestamp of when the fraudster registration job was created. </p>', 'FraudsterRegistrationJobSummary$EndedAt' => '<p>A timestamp of when the fraudster registration job ended.</p>', 'FraudsterSummary$CreatedAt' => '<p>The timestamp of when the fraudster summary was created.</p>', 'Speaker$CreatedAt' => '<p>A timestamp of when the speaker was created. </p>', 'Speaker$LastAccessedAt' => '<p>The timestamp of when the speaker was last accessed for enrollment, re-enrollment or a successful authentication. This timestamp is accurate to one hour.</p>', 'Speaker$UpdatedAt' => '<p>A timestamp of the speaker\'s last update.</p>', 'SpeakerEnrollmentJob$CreatedAt' => '<p>A timestamp of when the speaker enrollment job was created.</p>', 'SpeakerEnrollmentJob$EndedAt' => '<p>A timestamp of when the speaker enrollment job ended. </p>', 'SpeakerEnrollmentJobSummary$CreatedAt' => '<p>A timestamp of when of the speaker enrollment job was created.</p>', 'SpeakerEnrollmentJobSummary$EndedAt' => '<p>A timestamp of when the speaker enrollment job ended.</p>', 'SpeakerSummary$CreatedAt' => '<p>A timestamp showing the speaker\'s creation time. </p>', 'SpeakerSummary$LastAccessedAt' => '<p>The timestamp when the speaker was last accessed for enrollment, re-enrollment or a successful authentication. This timestamp is accurate to one hour.</p>', 'SpeakerSummary$UpdatedAt' => '<p>A timestamp showing the speaker\'s last update.</p>', 'Watchlist$CreatedAt' => '<p>The timestamp of when the watchlist was created.</p>', 'Watchlist$UpdatedAt' => '<p>The timestamp of when the watchlist was updated.</p>', 'WatchlistSummary$CreatedAt' => '<p>The timestamp of when the watchlist was created.</p>', 'WatchlistSummary$UpdatedAt' => '<p>The timestamp of when the watchlist was last updated.</p>', ], ], 'UniqueIdLarge' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResult$AuthenticationResultId' => '<p>The unique identifier for this authentication result. Because there can be multiple authentications for a given session, this field helps to identify if the returned result is from a previous streaming activity or a new result. Note that in absence of any new streaming activity, <code>AcceptanceThreshold</code> changes, or <code>SpeakerId</code> changes, Voice ID always returns cached Authentication Result for this API.</p>', 'FraudDetectionResult$FraudDetectionResultId' => '<p>The unique identifier for this fraud detection result. Given there can be multiple fraud detections for a given session, this field helps in identifying if the returned result is from previous streaming activity or a new result. Note that in the absence of any new streaming activity or risk threshold changes, Voice ID always returns cached Fraud Detection result for this API.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWatchlistRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWatchlistResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request failed one or more validations; check the error message for more details.</p>', 'refs' => [], ], 'VoiceSpoofingRisk' => [ 'base' => '<p>The details resulting from \'Voice Spoofing Risk\' analysis of the speaker.</p>', 'refs' => [ 'FraudRiskDetails$VoiceSpoofingRisk' => '<p>The details resulting from \'Voice Spoofing Risk\' analysis of the speaker.</p>', ], ], 'Watchlist' => [ 'base' => '<p>Contains all the information about a watchlist.</p>', 'refs' => [ 'CreateWatchlistResponse$Watchlist' => '<p>Information about the newly created watchlist.</p>', 'DescribeWatchlistResponse$Watchlist' => '<p>Information about the specified watchlist.</p>', 'UpdateWatchlistResponse$Watchlist' => '<p>Details about the updated watchlist.</p>', ], ], 'WatchlistDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWatchlistRequest$Description' => '<p>A brief description of this watchlist.</p>', 'UpdateWatchlistRequest$Description' => '<p>A brief description about this watchlist.</p>', 'Watchlist$Description' => '<p>The description of the watchlist.</p>', 'WatchlistSummary$Description' => '<p>The description of the watchlist.</p>', ], ], 'WatchlistDetails' => [ 'base' => '<p>Details of the watchlists in a domain.</p>', 'refs' => [ 'Domain$WatchlistDetails' => '<p>The watchlist details of a domain. Contains the default watchlist ID of the domain.</p>', 'DomainSummary$WatchlistDetails' => '<p>Provides information about <code>watchlistDetails</code> and <code>DefaultWatchlistID</code>. </p>', ], ], 'WatchlistId' => [ 'base' => NULL, 'refs' => [ 'AssociateFraudsterRequest$WatchlistId' => '<p>The identifier of the watchlist you want to associate with the fraudster.</p>', 'DeleteWatchlistRequest$WatchlistId' => '<p>The identifier of the watchlist to be deleted.</p>', 'DescribeWatchlistRequest$WatchlistId' => '<p>The identifier of the watchlist that you are describing.</p>', 'DisassociateFraudsterRequest$WatchlistId' => '<p>The identifier of the watchlist that you want to disassociate from the fraudster.</p>', 'EnrollmentJobFraudDetectionConfigWatchlistIds$member' => NULL, 'FraudDetectionConfiguration$WatchlistId' => '<p>The identifier of the watchlist against which fraud detection is performed. </p>', 'ListFraudstersRequest$WatchlistId' => '<p>The identifier of the watchlist. If provided, all fraudsters in the watchlist are listed. If not provided, all fraudsters in the domain are listed.</p>', 'RegistrationConfigWatchlistIds$member' => NULL, 'ResponseWatchlistIds$member' => NULL, 'UpdateWatchlistRequest$WatchlistId' => '<p>The identifier of the watchlist to be updated.</p>', 'Watchlist$WatchlistId' => '<p>The identifier of the watchlist.</p>', 'WatchlistDetails$DefaultWatchlistId' => '<p>The identifier of the default watchlist.</p>', 'WatchlistSummary$WatchlistId' => '<p>The identifier of the watchlist.</p>', ], ], 'WatchlistName' => [ 'base' => NULL, 'refs' => [ 'CreateWatchlistRequest$Name' => '<p>The name of the watchlist.</p>', 'UpdateWatchlistRequest$Name' => '<p>The name of the watchlist.</p>', 'Watchlist$Name' => '<p>The name for the watchlist.</p>', 'WatchlistSummary$Name' => '<p>The name for the watchlist.</p>', ], ], 'WatchlistSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWatchlistsResponse$WatchlistSummaries' => '<p>A list that contains details about each watchlist in the Amazon Web Services account. </p>', ], ], 'WatchlistSummary' => [ 'base' => '<p>Contains a summary of information about a watchlist.</p>', 'refs' => [ 'WatchlistSummaries$member' => NULL, ], ], ],];
