<?php
// This file was auto-generated from sdk-root/src/data/wafv2/2019-07-29/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>WAF</fullname> <note> <p>This is the latest version of the <b>WAF</b> API, released in November, 2019. The names of the entities that you use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2", to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number of significant improvements.</p> <p>If you used WAF prior to this release, you can\'t use this WAFV2 API to access any WAF resources that you created before. You can access your old rules, web ACLs, and other WAF resources only through the WAF Classic APIs. The WAF Classic APIs have retained the prior names, endpoints, and namespaces. </p> <p>For information, including how to migrate your WAF resources to this version, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> </note> <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to an Amazon CloudFront distribution, Amazon API Gateway REST API, Application Load Balancer, AppSync GraphQL API, Amazon Cognito user pool, App Runner service, or Amazon Web Services Verified Access instance. WAF also lets you control access to your content, to protect the Amazon Web Services resource that WAF is monitoring. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, the protected resource responds to requests with either the requested content, an HTTP 403 status code (Forbidden), or with a custom response. </p> <p>This API guide is for developers who need detailed information about WAF API actions, data types, and errors. For detailed information about WAF features and guidance for configuring and using WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>.</p> <p>You can make calls using the endpoints listed in <a href="https://docs.aws.amazon.com/general/latest/gr/waf.html">WAF endpoints and quotas</a>. </p> <ul> <li> <p>For regional applications, you can use any of the endpoints in the list. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> </li> <li> <p>For Amazon CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.</p> </li> </ul> <p>Alternatively, you can use one of the Amazon Web Services SDKs to access an API that\'s tailored to the programming language or platform that you\'re using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon Web Services SDKs</a>.</p> <p>We currently provide two versions of the WAF API: this API and the prior versions, the classic WAF APIs. This new API provides the same functionality as the older versions, with the following major improvements:</p> <ul> <li> <p>You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a <code>Scope</code> parameter and set it to <code>CLOUDFRONT</code> or <code>REGIONAL</code>. </p> </li> <li> <p>You can define a web ACL or rule group with a single call, and update it with a single call. You define all rule specifications in JSON format, and pass them to your rule group or web ACL calls.</p> </li> <li> <p>The limits WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule groups include capacity settings, so you know the maximum cost of a rule group when you use it.</p> </li> </ul>', 'operations' => [ 'AssociateWebACL' => '<p>Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a> in the <i>Amazon CloudFront Developer Guide</i>. </p> <p> <b>Required permissions for customer-managed IAM policies</b> </p> <p>This call requires permissions that are specific to the protected resource type. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/security_iam_service-with-iam.html#security_iam_action-AssociateWebACL">Permissions for AssociateWebACL</a> in the <i>WAF Developer Guide</i>. </p> <p> <b>Temporary inconsistencies during updates</b> </p> <p>When you create or change a web ACL or other WAF resources, the changes take a small amount of time to propagate to all areas where the resources are stored. The propagation time can be from a few seconds to a number of minutes. </p> <p>The following are examples of the temporary inconsistencies that you might notice during change propagation: </p> <ul> <li> <p>After you create a web ACL, if you try to associate it with a resource, you might get an exception indicating that the web ACL is unavailable. </p> </li> <li> <p>After you add a rule group to a web ACL, the new rule group rules might be in effect in one area where the web ACL is used and not in another.</p> </li> <li> <p>After you change a rule action setting, you might see the old action in some places and the new action in others. </p> </li> <li> <p>After you add an IP address to an IP set that is in use in a blocking rule, the new address might be blocked in one area while still allowed in another.</p> </li> </ul>', 'CheckCapacity' => '<p>Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>. </p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', 'CreateAPIKey' => '<p>Creates an API key that contains a set of token domains.</p> <p>API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information about the CAPTCHA JavaScript integration, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p> <p>You can use a single key for up to 5 domains. After you generate a key, you can copy it for use in your JavaScript integration. </p>', 'CreateIPSet' => '<p>Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you\'re receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses. </p>', 'CreateRegexPatternSet' => '<p>Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have WAF inspect a web request component for the specified patterns.</p>', 'CreateRuleGroup' => '<p>Creates a <a>RuleGroup</a> per the specifications provided. </p> <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>', 'CreateWebACL' => '<p>Creates a <a>WebACL</a> per the specifications provided.</p> <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement that defines what to look for in web requests and an action that WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p>', 'DeleteAPIKey' => '<p>Deletes the specified API key. </p> <p>After you delete a key, it can take up to 24 hours for WAF to disallow use of the key in all regions. </p>', 'DeleteFirewallManagerRuleGroups' => '<p>Deletes all rule groups that are managed by Firewall Manager for the specified web ACL. </p> <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>. </p>', 'DeleteIPSet' => '<p>Deletes the specified <a>IPSet</a>. </p>', 'DeleteLoggingConfiguration' => '<p>Deletes the <a>LoggingConfiguration</a> from the specified web ACL.</p>', 'DeletePermissionPolicy' => '<p>Permanently deletes an IAM policy from the specified rule group.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'DeleteRegexPatternSet' => '<p>Deletes the specified <a>RegexPatternSet</a>.</p>', 'DeleteRuleGroup' => '<p>Deletes the specified <a>RuleGroup</a>.</p>', 'DeleteWebACL' => '<p>Deletes the specified <a>WebACL</a>. </p> <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>. </p> <note> <p>Before deleting any web ACL, first disassociate it from all resources.</p> <ul> <li> <p>To retrieve a list of the resources that are associated with a web ACL, use the following calls:</p> <ul> <li> <p>For regional resources, call <a>ListResourcesForWebACL</a>.</p> </li> <li> <p>For Amazon CloudFront distributions, use the CloudFront call <code>ListDistributionsByWebACLId</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html">ListDistributionsByWebACLId</a> in the <i>Amazon CloudFront API Reference</i>. </p> </li> </ul> </li> <li> <p>To disassociate a resource from a web ACL, use the following calls:</p> <ul> <li> <p>For regional resources, call <a>DisassociateWebACL</a>.</p> </li> <li> <p>For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>. </p> </li> </ul> </li> </ul> </note>', 'DescribeAllManagedProducts' => '<p>Provides high-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace managed rule groups. </p>', 'DescribeManagedProductsByVendor' => '<p>Provides high-level information for the managed rule groups owned by a specific vendor. </p>', 'DescribeManagedRuleGroup' => '<p>Provides high-level information for a managed rule group, including descriptions of the rules. </p>', 'DisassociateWebACL' => '<p>Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a> in the <i>Amazon CloudFront API Reference</i>. </p> <p> <b>Required permissions for customer-managed IAM policies</b> </p> <p>This call requires permissions that are specific to the protected resource type. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/security_iam_service-with-iam.html#security_iam_action-DisassociateWebACL">Permissions for DisassociateWebACL</a> in the <i>WAF Developer Guide</i>.</p>', 'GenerateMobileSdkReleaseUrl' => '<p>Generates a presigned download URL for the specified release of the mobile SDK.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'GetDecryptedAPIKey' => '<p>Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key. </p> <p>API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information about the CAPTCHA JavaScript integration, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'GetIPSet' => '<p>Retrieves the specified <a>IPSet</a>.</p>', 'GetLoggingConfiguration' => '<p>Returns the <a>LoggingConfiguration</a> for the specified web ACL.</p>', 'GetManagedRuleSet' => '<p>Retrieves the specified managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'GetMobileSdkRelease' => '<p>Retrieves information for the specified mobile SDK release, including release notes and tags.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'GetPermissionPolicy' => '<p>Returns the IAM policy that is attached to the specified rule group.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'GetRateBasedStatementManagedKeys' => '<p>Retrieves the IP addresses that are currently blocked by a rate-based rule instance. This is only available for rate-based rules that aggregate solely on the IP address or on the forwarded IP address. </p> <p>The maximum number of addresses that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.</p> <p>For a rate-based rule that you\'ve defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name. </p> <p>WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first. </p>', 'GetRegexPatternSet' => '<p>Retrieves the specified <a>RegexPatternSet</a>.</p>', 'GetRuleGroup' => '<p>Retrieves the specified <a>RuleGroup</a>.</p>', 'GetSampledRequests' => '<p>Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p> <p> <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.</p>', 'GetWebACL' => '<p>Retrieves the specified <a>WebACL</a>.</p>', 'GetWebACLForResource' => '<p>Retrieves the <a>WebACL</a> for the specified resource. </p> <p>This call uses <code>GetWebACL</code>, to verify that your account has permission to access the retrieved web ACL. If you get an error that indicates that your account isn\'t authorized to perform <code>wafv2:GetWebACL</code> on the resource, that error won\'t be included in your CloudTrail event history. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, call the CloudFront action <code>GetDistributionConfig</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig</a> in the <i>Amazon CloudFront API Reference</i>. </p> <p> <b>Required permissions for customer-managed IAM policies</b> </p> <p>This call requires permissions that are specific to the protected resource type. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/security_iam_service-with-iam.html#security_iam_action-GetWebACLForResource">Permissions for GetWebACLForResource</a> in the <i>WAF Developer Guide</i>.</p>', 'ListAPIKeys' => '<p>Retrieves a list of the API keys that you\'ve defined for the specified scope. </p> <p>API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information about the CAPTCHA JavaScript integration, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'ListAvailableManagedRuleGroupVersions' => '<p>Returns a list of the available versions for the specified managed rule group. </p>', 'ListAvailableManagedRuleGroups' => '<p>Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you\'re subscribed to.</p>', 'ListIPSets' => '<p>Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.</p>', 'ListLoggingConfigurations' => '<p>Retrieves an array of your <a>LoggingConfiguration</a> objects.</p>', 'ListManagedRuleSets' => '<p>Retrieves the managed rule sets that you own. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'ListMobileSdkReleases' => '<p>Retrieves a list of the available releases for the mobile SDK and the specified device platform. </p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'ListRegexPatternSets' => '<p>Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.</p>', 'ListResourcesForWebACL' => '<p>Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, use the CloudFront call <code>ListDistributionsByWebACLId</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html">ListDistributionsByWebACLId</a> in the <i>Amazon CloudFront API Reference</i>. </p> <p> <b>Required permissions for customer-managed IAM policies</b> </p> <p>This call requires permissions that are specific to the protected resource type. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/security_iam_service-with-iam.html#security_iam_action-ListResourcesForWebACL">Permissions for ListResourcesForWebACL</a> in the <i>WAF Developer Guide</i>.</p>', 'ListRuleGroups' => '<p>Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage. </p>', 'ListTagsForResource' => '<p>Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'ListWebACLs' => '<p>Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.</p>', 'PutLoggingConfiguration' => '<p>Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the configuration provided. </p> <note> <p>This operation completely replaces any mutable specifications that you already have for a logging configuration with the ones that you provide to this call. </p> <p>To modify an existing logging configuration, do the following: </p> <ol> <li> <p>Retrieve it by calling <a>GetLoggingConfiguration</a> </p> </li> <li> <p>Update its settings as needed</p> </li> <li> <p>Provide the complete logging configuration specification to this call</p> </li> </ol> </note> <note> <p>You can define one logging destination per web ACL.</p> </note> <p>You can access information about the traffic that WAF inspects using the following steps:</p> <ol> <li> <p>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. </p> <p>The name that you give the destination must start with <code>aws-waf-logs-</code>. Depending on the type of destination, you might need to configure additional settings or permissions. </p> <p>For configuration requirements and pricing information for each destination type, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the <i>WAF Developer Guide</i>.</p> </li> <li> <p>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li> </ol> <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.</p> <p>For additional information about web ACL logging, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>', 'PutManagedRuleSetVersions' => '<p>Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.</p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note> <p>Customers retrieve their managed rule group list by calling <a>ListAvailableManagedRuleGroups</a>. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling <a>ListAvailableManagedRuleGroupVersions</a>. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using. </p> <p>To initiate the expiration of a managed rule group version, use <a>UpdateManagedRuleSetVersionExpiryDate</a>.</p>', 'PutPermissionPolicy' => '<p>Use this to share a rule group with other accounts.</p> <p>This action attaches an IAM policy to the specified resource. You must be the owner of the rule group to perform this operation.</p> <p>This action is subject to the following restrictions:</p> <ul> <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li> <li> <p>The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same Region.</p> </li> <li> <p>The user making the request must be the owner of the rule group.</p> </li> </ul> <p>If a rule group has been shared with your account, you can access it through the call <code>GetRuleGroup</code>, and you can reference it in <code>CreateWebACL</code> and <code>UpdateWebACL</code>. Rule groups that are shared with you don\'t appear in your WAF console rule groups listing. </p>', 'TagResource' => '<p>Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'UntagResource' => '<p>Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.</p>', 'UpdateIPSet' => '<p>Updates the specified <a>IPSet</a>. </p> <note> <p>This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. </p> <p>To modify an IP set, do the following: </p> <ol> <li> <p>Retrieve it by calling <a>GetIPSet</a> </p> </li> <li> <p>Update its settings as needed</p> </li> <li> <p>Provide the complete IP set specification to this call</p> </li> </ol> </note> <p> <b>Temporary inconsistencies during updates</b> </p> <p>When you create or change a web ACL or other WAF resources, the changes take a small amount of time to propagate to all areas where the resources are stored. The propagation time can be from a few seconds to a number of minutes. </p> <p>The following are examples of the temporary inconsistencies that you might notice during change propagation: </p> <ul> <li> <p>After you create a web ACL, if you try to associate it with a resource, you might get an exception indicating that the web ACL is unavailable. </p> </li> <li> <p>After you add a rule group to a web ACL, the new rule group rules might be in effect in one area where the web ACL is used and not in another.</p> </li> <li> <p>After you change a rule action setting, you might see the old action in some places and the new action in others. </p> </li> <li> <p>After you add an IP address to an IP set that is in use in a blocking rule, the new address might be blocked in one area while still allowed in another.</p> </li> </ul>', 'UpdateManagedRuleSetVersionExpiryDate' => '<p>Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the response to <a>ListAvailableManagedRuleGroupVersions</a> for the managed rule group. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'UpdateRegexPatternSet' => '<p>Updates the specified <a>RegexPatternSet</a>.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. </p> <p>To modify a regex pattern set, do the following: </p> <ol> <li> <p>Retrieve it by calling <a>GetRegexPatternSet</a> </p> </li> <li> <p>Update its settings as needed</p> </li> <li> <p>Provide the complete regex pattern set specification to this call</p> </li> </ol> </note> <p> <b>Temporary inconsistencies during updates</b> </p> <p>When you create or change a web ACL or other WAF resources, the changes take a small amount of time to propagate to all areas where the resources are stored. The propagation time can be from a few seconds to a number of minutes. </p> <p>The following are examples of the temporary inconsistencies that you might notice during change propagation: </p> <ul> <li> <p>After you create a web ACL, if you try to associate it with a resource, you might get an exception indicating that the web ACL is unavailable. </p> </li> <li> <p>After you add a rule group to a web ACL, the new rule group rules might be in effect in one area where the web ACL is used and not in another.</p> </li> <li> <p>After you change a rule action setting, you might see the old action in some places and the new action in others. </p> </li> <li> <p>After you add an IP address to an IP set that is in use in a blocking rule, the new address might be blocked in one area while still allowed in another.</p> </li> </ul>', 'UpdateRuleGroup' => '<p>Updates the specified <a>RuleGroup</a>.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. </p> <p>To modify a rule group, do the following: </p> <ol> <li> <p>Retrieve it by calling <a>GetRuleGroup</a> </p> </li> <li> <p>Update its settings as needed</p> </li> <li> <p>Provide the complete rule group specification to this call</p> </li> </ol> </note> <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p> <p> <b>Temporary inconsistencies during updates</b> </p> <p>When you create or change a web ACL or other WAF resources, the changes take a small amount of time to propagate to all areas where the resources are stored. The propagation time can be from a few seconds to a number of minutes. </p> <p>The following are examples of the temporary inconsistencies that you might notice during change propagation: </p> <ul> <li> <p>After you create a web ACL, if you try to associate it with a resource, you might get an exception indicating that the web ACL is unavailable. </p> </li> <li> <p>After you add a rule group to a web ACL, the new rule group rules might be in effect in one area where the web ACL is used and not in another.</p> </li> <li> <p>After you change a rule action setting, you might see the old action in some places and the new action in others. </p> </li> <li> <p>After you add an IP address to an IP set that is in use in a blocking rule, the new address might be blocked in one area while still allowed in another.</p> </li> </ul>', 'UpdateWebACL' => '<p>Updates the specified <a>WebACL</a>. While updating a web ACL, WAF provides continuous coverage to the resources that you have associated with the web ACL. </p> <note> <p>This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. </p> <p>To modify a web ACL, do the following: </p> <ol> <li> <p>Retrieve it by calling <a>GetWebACL</a> </p> </li> <li> <p>Update its settings as needed</p> </li> <li> <p>Provide the complete web ACL specification to this call</p> </li> </ol> </note> <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement that defines what to look for in web requests and an action that WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p> <b>Temporary inconsistencies during updates</b> </p> <p>When you create or change a web ACL or other WAF resources, the changes take a small amount of time to propagate to all areas where the resources are stored. The propagation time can be from a few seconds to a number of minutes. </p> <p>The following are examples of the temporary inconsistencies that you might notice during change propagation: </p> <ul> <li> <p>After you create a web ACL, if you try to associate it with a resource, you might get an exception indicating that the web ACL is unavailable. </p> </li> <li> <p>After you add a rule group to a web ACL, the new rule group rules might be in effect in one area where the web ACL is used and not in another.</p> </li> <li> <p>After you change a rule action setting, you might see the old action in some places and the new action in others. </p> </li> <li> <p>After you add an IP address to an IP set that is in use in a blocking rule, the new address might be blocked in one area while still allowed in another.</p> </li> </ul>', ], 'shapes' => [ 'APIKey' => [ 'base' => NULL, 'refs' => [ 'APIKeySummary$APIKey' => '<p>The generated, encrypted API key. You can copy this for use in your JavaScript CAPTCHA integration. </p>', 'CreateAPIKeyResponse$APIKey' => '<p>The generated, encrypted API key. You can copy this for use in your JavaScript CAPTCHA integration. </p>', 'DeleteAPIKeyRequest$APIKey' => '<p>The encrypted API key that you want to delete. </p>', 'GetDecryptedAPIKeyRequest$APIKey' => '<p>The encrypted API key. </p>', ], ], 'APIKeySummaries' => [ 'base' => NULL, 'refs' => [ 'ListAPIKeysResponse$APIKeySummaries' => '<p>The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'APIKeySummary' => [ 'base' => '<p>Information for a single API key. </p> <p>API keys are required for the integration of the CAPTCHA API in your JavaScript client applications. The API lets you customize the placement and characteristics of the CAPTCHA puzzle for your end users. For more information about the CAPTCHA JavaScript integration, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'APIKeySummaries$member' => NULL, ], ], 'APIKeyTokenDomains' => [ 'base' => NULL, 'refs' => [ 'CreateAPIKeyRequest$TokenDomains' => '<p>The client application domains that you want to use this API key for. </p> <p>Example JSON: <code>"TokenDomains": ["abc.com", "store.abc.com"]</code> </p> <p>Public suffixes aren\'t allowed. For example, you can\'t use <code>gov.au</code> or <code>co.uk</code> as token domains.</p>', ], ], 'APIKeyVersion' => [ 'base' => NULL, 'refs' => [ 'APIKeySummary$Version' => '<p>Internal value used by WAF to manage the key. </p>', ], ], 'AWSManagedRulesACFPRuleSet' => [ 'base' => '<p>Details for your use of the account creation fraud prevention managed rule group, <code>AWSManagedRulesACFPRuleSet</code>. This configuration is used in <code>ManagedRuleGroupConfig</code>. </p>', 'refs' => [ 'ManagedRuleGroupConfig$AWSManagedRulesACFPRuleSet' => '<p>Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, <code>AWSManagedRulesACFPRuleSet</code>. Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests. </p> <p>For information about using the ACFP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html">WAF Fraud Control account creation fraud prevention (ACFP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html">WAF Fraud Control account creation fraud prevention (ACFP)</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'AWSManagedRulesATPRuleSet' => [ 'base' => '<p>Details for your use of the account takeover prevention managed rule group, <code>AWSManagedRulesATPRuleSet</code>. This configuration is used in <code>ManagedRuleGroupConfig</code>. </p>', 'refs' => [ 'ManagedRuleGroupConfig$AWSManagedRulesATPRuleSet' => '<p>Additional configuration for using the account takeover prevention (ATP) managed rule group, <code>AWSManagedRulesATPRuleSet</code>. Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests. </p> <p>This configuration replaces the individual configuration fields in <code>ManagedRuleGroupConfig</code> and provides additional feature configuration. </p> <p>For information about using the ATP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html">WAF Fraud Control account takeover prevention (ATP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html">WAF Fraud Control account takeover prevention (ATP)</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'AWSManagedRulesBotControlRuleSet' => [ 'base' => '<p>Details for your use of the Bot Control managed rule group, <code>AWSManagedRulesBotControlRuleSet</code>. This configuration is used in <code>ManagedRuleGroupConfig</code>. </p>', 'refs' => [ 'ManagedRuleGroupConfig$AWSManagedRulesBotControlRuleSet' => '<p>Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF Bot Control</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'SampledHTTPRequest$Action' => '<p>The action that WAF applied to the request.</p>', 'SampledHTTPRequest$OverriddenAction' => '<p>Used only for rule group rules that have a rule action override in place in the web ACL. This is the action that the rule group rule is configured for, and not the action that was applied to the request. The action that WAF applied is the <code>Action</code> value. </p>', ], ], 'ActionCondition' => [ 'base' => '<p>A single action condition for a <a>Condition</a> in a logging filter.</p>', 'refs' => [ 'Condition$ActionCondition' => '<p>A single action condition. This is the action setting that a log record must contain in order to meet the condition.</p>', ], ], 'ActionValue' => [ 'base' => NULL, 'refs' => [ 'ActionCondition$Action' => '<p>The action setting that a log record must contain in order to meet the condition. This is the action that WAF applied to the web request. </p> <p>For rule groups, this is either the configured rule action setting, or if you\'ve applied a rule action override to the rule, it\'s the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded rules and also on rules that have a rule action override of Count. </p>', ], ], 'AddressField' => [ 'base' => '<p>The name of a field in the request payload that contains part or all of your customer\'s primary physical address. </p> <p>This data type is used in the <code>RequestInspectionACFP</code> data type. </p>', 'refs' => [ 'AddressFields$member' => NULL, ], ], 'AddressFields' => [ 'base' => NULL, 'refs' => [ 'RequestInspectionACFP$AddressFields' => '<p>The names of the fields in the request payload that contain your customer\'s primary physical address. </p> <p>Order the address fields in the array exactly as they are ordered in the request payload. </p> <p>How you specify the address fields depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>, the address field idenfiers are <code>/form/primaryaddressline1</code>, <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with input elements named <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>. </p> </li> </ul>', ], ], 'All' => [ 'base' => '<p>Inspect all of the elements that WAF has parsed and extracted from the web request component that you\'ve identified in your <a>FieldToMatch</a> specifications. </p> <p>This is used in the <a>FieldToMatch</a> specification for some web request component types. </p> <p>JSON specification: <code>"All": {}</code> </p>', 'refs' => [ 'CookieMatchPattern$All' => '<p>Inspect all cookies. </p>', 'HeaderMatchPattern$All' => '<p>Inspect all headers. </p>', 'JsonMatchPattern$All' => '<p>Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>. </p> <p>You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.</p>', ], ], 'AllQueryArguments' => [ 'base' => '<p>Inspect all query arguments of the web request. </p> <p>This is used in the <a>FieldToMatch</a> specification for some web request component types. </p> <p>JSON specification: <code>"AllQueryArguments": {}</code> </p>', 'refs' => [ 'FieldToMatch$AllQueryArguments' => '<p>Inspect all query arguments. </p>', ], ], 'AllowAction' => [ 'base' => '<p>Specifies that WAF should allow the request and optionally defines additional custom handling for the request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'DefaultAction$Allow' => '<p>Specifies that WAF should allow requests by default.</p>', 'RuleAction$Allow' => '<p>Instructs WAF to allow the web request.</p>', ], ], 'AndStatement' => [ 'base' => '<p>A logical rule statement used to combine other rule statements with AND logic. You provide more than one <a>Statement</a> within the <code>AndStatement</code>. </p>', 'refs' => [ 'Statement$AndStatement' => '<p>A logical rule statement used to combine other rule statements with AND logic. You provide more than one <a>Statement</a> within the <code>AndStatement</code>. </p>', ], ], 'AssociateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedResourceType' => [ 'base' => NULL, 'refs' => [ 'RequestBody$key' => NULL, ], ], 'AssociationConfig' => [ 'base' => '<p>Specifies custom configurations for the associations between the web ACL and protected resources. </p> <p>Use this to customize the maximum size of the request body that your protected resources forward to WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes). </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p>', 'refs' => [ 'CreateWebACLRequest$AssociationConfig' => '<p>Specifies custom configurations for the associations between the web ACL and protected resources. </p> <p>Use this to customize the maximum size of the request body that your protected resources forward to WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes). </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p>', 'UpdateWebACLRequest$AssociationConfig' => '<p>Specifies custom configurations for the associations between the web ACL and protected resources. </p> <p>Use this to customize the maximum size of the request body that your protected resources forward to WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes). </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p>', 'WebACL$AssociationConfig' => '<p>Specifies custom configurations for the associations between the web ACL and protected resources. </p> <p>Use this to customize the maximum size of the request body that your protected resources forward to WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes). </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p>', ], ], 'BlockAction' => [ 'base' => '<p>Specifies that WAF should block the request and optionally defines additional custom handling for the response to the web request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'DefaultAction$Block' => '<p>Specifies that WAF should block requests by default. </p>', 'RuleAction$Block' => '<p>Instructs WAF to block the web request.</p>', ], ], 'Body' => [ 'base' => '<p>Inspect the body of the web request. The body immediately follows the request headers.</p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p>', 'refs' => [ 'FieldToMatch$Body' => '<p>Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. </p> <p>WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to WAF for inspection. </p> <ul> <li> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p> </li> <li> <p>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for additional processing fees. </p> </li> </ul> <p>For information about how to handle oversized request bodies, see the <code>Body</code> object configuration. </p>', ], ], 'BodyParsingFallbackBehavior' => [ 'base' => NULL, 'refs' => [ 'JsonBody$InvalidFallbackBehavior' => '<p>What WAF should do if it fails to completely parse the JSON body. The options are the following:</p> <ul> <li> <p> <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul> <p>If you don\'t provide this setting, WAF parses and evaluates the content only up to the first parsing failure that it encounters. </p> <note> <p>WAF parsing doesn\'t fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, WAF doesn\'t apply the fallback behavior. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body">JSON body</a> in the <i>WAF Developer Guide</i>.</p> </note>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesACFPRuleSet$EnableRegexInPath' => '<p>Allow the use of regular expressions in the registration page path and the account creation path. </p>', 'AWSManagedRulesATPRuleSet$EnableRegexInPath' => '<p>Allow the use of regular expressions in the login page path. </p>', 'LoggingConfiguration$ManagedByFirewallManager' => '<p>Indicates whether the logging configuration was created by Firewall Manager, as part of an WAF policy configuration. If true, only Firewall Manager can modify or delete the configuration. </p>', 'ManagedProductDescriptor$IsVersioningSupported' => '<p>Indicates whether the rule group is versioned. </p>', 'ManagedProductDescriptor$IsAdvancedManagedRuleSet' => '<p>Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web Services Managed Rules rule groups that are used for WAF intelligent threat mitigation. </p>', 'ManagedRuleGroupSummary$VersioningSupported' => '<p>Indicates whether the managed rule group is versioned. If it is, you can retrieve the versions list by calling <a>ListAvailableManagedRuleGroupVersions</a>. </p>', 'VisibilityConfig$SampledRequestsEnabled' => '<p>Indicates whether WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the WAF console. </p> <note> <p>Request sampling doesn\'t provide a field redaction option, and any field redaction that you specify in your logging configuration doesn\'t affect sampling. The only way to exclude fields from request sampling is by disabling sampling in the web ACL visibility configuration. </p> </note>', 'VisibilityConfig$CloudWatchMetricsEnabled' => '<p>Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF Metrics</a> in the <i>WAF Developer Guide</i>.</p> <p>For web ACLs, the metrics are for web requests that have the web ACL default action applied. WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html">The web ACL default action</a> in the <i>WAF Developer Guide</i>.</p>', 'WebACL$ManagedByFirewallManager' => '<p>Indicates whether this web ACL is managed by Firewall Manager. If true, then only Firewall Manager can delete the web ACL or any Firewall Manager rule groups in the web ACL. </p>', ], ], 'ByteMatchStatement' => [ 'base' => '<p>A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is called a string match statement.</p>', 'refs' => [ 'Statement$ByteMatchStatement' => '<p>A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is called a string match statement.</p>', ], ], 'CapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <a>CheckCapacity</a>.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', 'DescribeManagedRuleGroupResponse$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', 'ManagedRuleSetVersion$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', 'RuleGroup$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <a>CheckCapacity</a>.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CaptchaAction' => [ 'base' => '<p>Specifies that WAF should run a <code>CAPTCHA</code> check against the request: </p> <ul> <li> <p>If the request includes a valid, unexpired <code>CAPTCHA</code> token, WAF applies any custom request handling and labels that you\'ve configured and then allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code>. </p> </li> <li> <p>If the request doesn\'t include a valid, unexpired token, WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</p> <p>WAF generates a response that it sends back to the client, which includes the following: </p> <ul> <li> <p>The header <code>x-amzn-waf-action</code> with a value of <code>captcha</code>. </p> </li> <li> <p>The HTTP status code <code>405 Method Not Allowed</code>. </p> </li> <li> <p>If the request contains an <code>Accept</code> header with a value of <code>text/html</code>, the response includes a <code>CAPTCHA</code> JavaScript page interstitial. </p> </li> </ul> </li> </ul> <p>You can configure the expiration time in the <code>CaptchaConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting. </p> <p>This action option is available for rules. It isn\'t available for web ACL default actions. </p>', 'refs' => [ 'RuleAction$Captcha' => '<p>Instructs WAF to run a <code>CAPTCHA</code> check against the web request.</p>', ], ], 'CaptchaConfig' => [ 'base' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations. This is available at the web ACL level and in each rule. </p>', 'refs' => [ 'CreateWebACLRequest$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', 'Rule$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations. If you don\'t specify this, WAF uses the <code>CAPTCHA</code> configuration that\'s defined for the web ACL. </p>', 'UpdateWebACLRequest$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', 'WebACL$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', ], ], 'CaptchaResponse' => [ 'base' => '<p>The result from the inspection of the web request for a valid <code>CAPTCHA</code> token. </p>', 'refs' => [ 'SampledHTTPRequest$CaptchaResponse' => '<p>The <code>CAPTCHA</code> response for the request.</p>', ], ], 'ChallengeAction' => [ 'base' => '<p>Specifies that WAF should run a <code>Challenge</code> check against the request to verify that the request is coming from a legitimate client session: </p> <ul> <li> <p>If the request includes a valid, unexpired challenge token, WAF applies any custom request handling and labels that you\'ve configured and then allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code>. </p> </li> <li> <p>If the request doesn\'t include a valid, unexpired challenge token, WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</p> <p>WAF then generates a challenge response that it sends back to the client, which includes the following: </p> <ul> <li> <p>The header <code>x-amzn-waf-action</code> with a value of <code>challenge</code>. </p> </li> <li> <p>The HTTP status code <code>202 Request Accepted</code>. </p> </li> <li> <p>If the request contains an <code>Accept</code> header with a value of <code>text/html</code>, the response includes a JavaScript page interstitial with a challenge script. </p> </li> </ul> <p>Challenges run silent browser interrogations in the background, and don\'t generally affect the end user experience. </p> <p>A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots. </p> <p>After the client session successfully responds to the challenge, it receives a new token from WAF, which the challenge script uses to resubmit the original request. </p> </li> </ul> <p>You can configure the expiration time in the <code>ChallengeConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting. </p> <p>This action option is available for rules. It isn\'t available for web ACL default actions. </p>', 'refs' => [ 'RuleAction$Challenge' => '<p>Instructs WAF to run a <code>Challenge</code> check against the web request.</p>', ], ], 'ChallengeConfig' => [ 'base' => '<p>Specifies how WAF should handle <code>Challenge</code> evaluations. This is available at the web ACL level and in each rule. </p>', 'refs' => [ 'CreateWebACLRequest$ChallengeConfig' => '<p>Specifies how WAF should handle challenge evaluations for rules that don\'t have their own <code>ChallengeConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>ChallengeConfig</code>. </p>', 'Rule$ChallengeConfig' => '<p>Specifies how WAF should handle <code>Challenge</code> evaluations. If you don\'t specify this, WAF uses the challenge configuration that\'s defined for the web ACL. </p>', 'UpdateWebACLRequest$ChallengeConfig' => '<p>Specifies how WAF should handle challenge evaluations for rules that don\'t have their own <code>ChallengeConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>ChallengeConfig</code>. </p>', 'WebACL$ChallengeConfig' => '<p>Specifies how WAF should handle challenge evaluations for rules that don\'t have their own <code>ChallengeConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>ChallengeConfig</code>. </p>', ], ], 'ChallengeResponse' => [ 'base' => '<p>The result from the inspection of the web request for a valid challenge token. </p>', 'refs' => [ 'SampledHTTPRequest$ChallengeResponse' => '<p>The <code>Challenge</code> response for the request.</p>', ], ], 'CheckCapacityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CheckCapacityResponse' => [ 'base' => NULL, 'refs' => [], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'SizeConstraintStatement$ComparisonOperator' => '<p>The operator to use to compare the request part to the size setting. </p>', ], ], 'Condition' => [ 'base' => '<p>A single match condition for a <a>Filter</a>.</p>', 'refs' => [ 'Conditions$member' => NULL, ], ], 'Conditions' => [ 'base' => NULL, 'refs' => [ 'Filter$Conditions' => '<p>Match conditions for the filter.</p>', ], ], 'ConsumedCapacity' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityResponse$Capacity' => '<p>The capacity required by the rules and scope.</p>', 'WebACL$Capacity' => '<p>The web ACL capacity units (WCUs) currently being used by this web ACL. </p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity units (WCU)</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CookieMatchPattern' => [ 'base' => '<p>The filter to use to identify the subset of cookies to inspect in a web request. </p> <p>You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or <code>ExcludedCookies</code>.</p> <p>Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code> </p>', 'refs' => [ 'Cookies$MatchPattern' => '<p>The filter to use to identify the subset of cookies to inspect in a web request. </p> <p>You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or <code>ExcludedCookies</code>.</p> <p>Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code> </p>', ], ], 'CookieNames' => [ 'base' => NULL, 'refs' => [ 'CookieMatchPattern$IncludedCookies' => '<p>Inspect only the cookies that have a key that matches one of the strings specified here. </p>', 'CookieMatchPattern$ExcludedCookies' => '<p>Inspect only the cookies whose keys don\'t match any of the strings specified here. </p>', ], ], 'Cookies' => [ 'base' => '<p>Inspect the cookies in the web request. You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.</p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Example JSON: <code>"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code> </p>', 'refs' => [ 'FieldToMatch$Cookies' => '<p>Inspect the request cookies. You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that WAF inspects. </p> <p>Only the first 8 KB (8192 bytes) of a request\'s cookies and only the first 200 cookies are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. WAF applies the pattern matching filters to the cookies that it receives from the underlying host service. </p>', ], ], 'CountAction' => [ 'base' => '<p>Specifies that WAF should count the request. Optionally defines additional custom handling for the request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'OverrideAction$Count' => '<p>Override the rule group evaluation result to count only. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings. </p> </note>', 'RuleAction$Count' => '<p>Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.</p>', ], ], 'Country' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Country' => '<p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'CountryCodes$member' => NULL, ], ], 'CountryCodes' => [ 'base' => NULL, 'refs' => [ 'GeoMatchStatement$CountryCodes' => '<p>An array of two-character country codes that you want to match against, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO codes of the ISO 3166 international standard. </p> <p>When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that\'s unlikely to be a source of traffic to your site.</p>', ], ], 'CreateAPIKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAPIKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationPathString' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesACFPRuleSet$CreationPath' => '<p>The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept <code>POST</code> requests.</p> <p>For example, for the URL <code>https://example.com/web/newaccount</code>, you would provide the path <code>/web/newaccount</code>. Account creation page paths that start with the path that you provide are considered a match. For example <code>/web/newaccount</code> matches the account creation paths <code>/web/newaccount</code>, <code>/web/newaccount/</code>, <code>/web/newaccountPage</code>, and <code>/web/newaccount/thisPage</code>, but doesn\'t match the path <code>/home/web/newaccount</code> or <code>/website/newaccount</code>. </p>', ], ], 'CustomHTTPHeader' => [ 'base' => '<p>A custom header for custom request and response handling. This is used in <a>CustomResponse</a> and <a>CustomRequestHandling</a>.</p>', 'refs' => [ 'CustomHTTPHeaders$member' => NULL, ], ], 'CustomHTTPHeaderName' => [ 'base' => NULL, 'refs' => [ 'CustomHTTPHeader$Name' => '<p>The name of the custom header. </p> <p>For custom request header insertion, when WAF inserts the header into the request, it prefixes this name <code>x-amzn-waf-</code>, to avoid confusion with the headers that are already in the request. For example, for the header name <code>sample</code>, WAF inserts the header <code>x-amzn-waf-sample</code>.</p>', ], ], 'CustomHTTPHeaderValue' => [ 'base' => NULL, 'refs' => [ 'CustomHTTPHeader$Value' => '<p>The value of the custom header.</p>', ], ], 'CustomHTTPHeaders' => [ 'base' => NULL, 'refs' => [ 'CustomRequestHandling$InsertHeaders' => '<p>The HTTP headers to insert into the request. Duplicate header names are not allowed. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'CustomResponse$ResponseHeaders' => '<p>The HTTP headers to use in the response. You can specify any header name except for <code>content-type</code>. Duplicate header names are not allowed.</p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CustomRequestHandling' => [ 'base' => '<p>Custom request handling behavior that inserts custom headers into a web request. You can add custom request handling for WAF to use when the rule action doesn\'t block the request. For example, <code>CaptchaAction</code> for requests with valid t okens, and <code>AllowAction</code>. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', 'refs' => [ 'AllowAction$CustomRequestHandling' => '<p>Defines custom handling for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', 'CaptchaAction$CustomRequestHandling' => '<p>Defines custom handling for the web request, used when the <code>CAPTCHA</code> inspection determines that the request\'s token is valid and unexpired.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', 'ChallengeAction$CustomRequestHandling' => '<p>Defines custom handling for the web request, used when the challenge inspection determines that the request\'s token is valid and unexpired.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', 'CountAction$CustomRequestHandling' => '<p>Defines custom handling for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CustomResponse' => [ 'base' => '<p>A custom response to send to the client. You can define a custom response for rule actions and default web ACL actions that are set to <a>BlockAction</a>. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', 'refs' => [ 'BlockAction$CustomResponse' => '<p>Defines a custom response for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CustomResponseBodies' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'CreateWebACLRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'RuleGroup$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'UpdateRuleGroupRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'UpdateWebACLRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', 'WebACL$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <i>WAF Developer Guide</i>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'CustomResponseBody' => [ 'base' => '<p>The response body to use in a custom response to a web request. This is referenced by key from <a>CustomResponse</a> <code>CustomResponseBodyKey</code>.</p>', 'refs' => [ 'CustomResponseBodies$value' => NULL, ], ], 'DefaultAction' => [ 'base' => '<p>In a <a>WebACL</a>, this is the action that you want WAF to perform when a web request doesn\'t match any of the rules in the <code>WebACL</code>. The default action must be a terminating action.</p>', 'refs' => [ 'CreateWebACLRequest$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', 'UpdateWebACLRequest$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', 'WebACL$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', ], ], 'DeleteAPIKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAPIKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallManagerRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallManagerRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAllManagedProductsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAllManagedProductsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedProductsByVendorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedProductsByVendorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'DownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GenerateMobileSdkReleaseUrlResponse$Url' => '<p>The presigned download URL for the specified SDK release.</p>', ], ], 'EmailField' => [ 'base' => '<p>The name of the field in the request payload that contains your customer\'s email. </p> <p>This data type is used in the <code>RequestInspectionACFP</code> data type. </p>', 'refs' => [ 'RequestInspectionACFP$EmailField' => '<p>The name of the field in the request payload that contains your customer\'s email. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field specification is <code>/form/email</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>email1</code>, the email field specification is <code>email1</code>.</p> </li> </ul>', ], ], 'EnableMachineLearning' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesBotControlRuleSet$EnableMachineLearning' => '<p>Applies only to the targeted inspection level. </p> <p>Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and <code>TGT_ML_CoordinatedActivityMedium</code>, which inspect for anomalous behavior that might indicate distributed, coordinated bot activity.</p> <p>For more information about this choice, see the listing for these rules in the table at <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules">Bot Control rules listing</a> in the <i>WAF Developer Guide</i>.</p> <p>Default: <code>TRUE</code> </p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Description' => '<p>A description of the IP set that helps with identification. </p>', 'CreateRegexPatternSetRequest$Description' => '<p>A description of the set that helps with identification. </p>', 'CreateRuleGroupRequest$Description' => '<p>A description of the rule group that helps with identification. </p>', 'CreateWebACLRequest$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'IPSet$Description' => '<p>A description of the IP set that helps with identification. </p>', 'IPSetSummary$Description' => '<p>A description of the IP set that helps with identification. </p>', 'ManagedRuleGroupSummary$Description' => '<p>The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web Services Marketplace seller who manages it.</p>', 'ManagedRuleSet$Description' => '<p>A description of the set that helps with identification. </p>', 'ManagedRuleSetSummary$Description' => '<p>A description of the set that helps with identification. </p>', 'RegexPatternSet$Description' => '<p>A description of the set that helps with identification. </p>', 'RegexPatternSetSummary$Description' => '<p>A description of the set that helps with identification. </p>', 'RuleGroup$Description' => '<p>A description of the rule group that helps with identification. </p>', 'RuleGroupSummary$Description' => '<p>A description of the rule group that helps with identification. </p>', 'UpdateIPSetRequest$Description' => '<p>A description of the IP set that helps with identification. </p>', 'UpdateRegexPatternSetRequest$Description' => '<p>A description of the set that helps with identification. </p>', 'UpdateRuleGroupRequest$Description' => '<p>A description of the rule group that helps with identification. </p>', 'UpdateWebACLRequest$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'WebACL$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'WebACLSummary$Description' => '<p>A description of the web ACL that helps with identification. </p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'DeleteIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetManagedRuleSetRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'GetRateBasedStatementManagedKeysRequest$WebACLId' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'IPSet$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'IPSetSummary$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'ManagedRuleSet$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'ManagedRuleSetSummary$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'PutManagedRuleSetVersionsRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'RegexPatternSet$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RegexPatternSetSummary$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RuleGroup$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RuleGroupSummary$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'UpdateRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'WebACL$Id' => '<p>A unique identifier for the <code>WebACL</code>. This ID is returned in the responses to create and list commands. You use this ID to do things like get, update, and delete a <code>WebACL</code>.</p>', 'WebACLSummary$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'CreateRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'CreateRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'CreateWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'CustomResponse$CustomResponseBodyKey' => '<p>References the response body that you want WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the <code>CustomResponseBodies</code> setting for the <a>WebACL</a> or <a>RuleGroup</a> where you want to use it. Then, in the rule action or web ACL default action <code>BlockAction</code> setting, you reference the response body using this key. </p>', 'CustomResponseBodies$key' => NULL, 'DeleteIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'DeleteRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'DeleteRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'DeleteWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'DescribeManagedRuleGroupRequest$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ExcludedRule$Name' => '<p>The name of the rule whose action you want to override to <code>Count</code>.</p>', 'FirewallManagerRuleGroup$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'GetIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'GetManagedRuleSetRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'GetRateBasedStatementManagedKeysRequest$WebACLName' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'GetRateBasedStatementManagedKeysRequest$RuleGroupRuleName' => '<p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>', 'GetRateBasedStatementManagedKeysRequest$RuleName' => '<p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you\'re using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>', 'GetRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'GetRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'GetWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'IPSet$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'IPSetSummary$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedProductDescriptor$ManagedRuleSetName' => '<p>The name of the managed rule group. For example, <code>AWSManagedRulesAnonymousIpList</code> or <code>AWSManagedRulesATPRuleSet</code>.</p>', 'ManagedRuleGroupStatement$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedRuleGroupSummary$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedRuleSet$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'ManagedRuleSetSummary$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'PutManagedRuleSetVersionsRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'RegexPatternSet$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'RegexPatternSetSummary$Name' => '<p>The name of the data type instance. You cannot change the name after you create the instance.</p>', 'Rule$Name' => '<p>The name of the rule. </p> <p>If you change the name of a <code>Rule</code> after you create it and you want the rule\'s metric name to reflect the change, update the metric name in the rule\'s <code>VisibilityConfig</code> settings. WAF doesn\'t automatically update the metric name when you update the rule name. </p>', 'RuleActionOverride$Name' => '<p>The name of the rule to override.</p>', 'RuleGroup$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'RuleGroupSummary$Name' => '<p>The name of the data type instance. You cannot change the name after you create the instance.</p>', 'RuleSummary$Name' => '<p>The name of the rule. </p>', 'SampledHTTPRequest$RuleNameWithinRuleGroup' => '<p>The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule group, this field is absent. </p>', 'UpdateIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'UpdateRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'UpdateRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'UpdateWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'WebACL$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'WebACLSummary$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'WAFAssociatedItemException$Message' => NULL, 'WAFConfigurationWarningException$Message' => NULL, 'WAFDuplicateItemException$Message' => NULL, 'WAFExpiredManagedRuleGroupVersionException$Message' => NULL, 'WAFInternalErrorException$Message' => NULL, 'WAFInvalidOperationException$Message' => NULL, 'WAFInvalidParameterException$message' => NULL, 'WAFInvalidPermissionPolicyException$Message' => NULL, 'WAFInvalidResourceException$Message' => NULL, 'WAFLimitsExceededException$Message' => NULL, 'WAFLogDestinationPermissionIssueException$Message' => NULL, 'WAFNonexistentItemException$Message' => NULL, 'WAFOptimisticLockException$Message' => NULL, 'WAFServiceLinkedRoleErrorException$message' => NULL, 'WAFSubscriptionNotFoundException$Message' => NULL, 'WAFTagOperationException$Message' => NULL, 'WAFTagOperationInternalErrorException$Message' => NULL, 'WAFUnavailableEntityException$Message' => NULL, 'WAFUnsupportedAggregateKeyTypeException$Message' => NULL, ], ], 'ErrorReason' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Reason' => '<p>Additional information about the exception.</p>', ], ], 'EvaluationWindowSec' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$EvaluationWindowSec' => '<p>The amount of time, in seconds, that WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600. </p> <p>This setting doesn\'t determine how often WAF checks the rate, but how far back it looks each time it checks. WAF checks the rate about every 10 seconds.</p> <p>Default: <code>300</code> (5 minutes)</p>', ], ], 'ExcludedRule' => [ 'base' => '<p>Specifies a single rule in a rule group whose action you want to override to <code>Count</code>. </p> <note> <p>Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including <code>Count</code>.</p> </note>', 'refs' => [ 'ExcludedRules$member' => NULL, ], ], 'ExcludedRules' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupStatement$ExcludedRules' => '<p>Rules in the referenced rule group whose actions are set to <code>Count</code>. </p> <note> <p>Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including <code>Count</code>.</p> </note>', 'RuleGroupReferenceStatement$ExcludedRules' => '<p>Rules in the referenced rule group whose actions are set to <code>Count</code>. </p> <note> <p>Instead of this option, use <code>RuleActionOverrides</code>. It accepts any valid action setting, including <code>Count</code>.</p> </note>', ], ], 'FailureCode' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionStatusCodeFailureCodes$member' => NULL, ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$FailureReason' => '<p>The reason for failure, populated when the evaluation of the token fails.</p>', 'ChallengeResponse$FailureReason' => '<p>The reason for failure, populated when the evaluation of the token fails.</p>', ], ], 'FailureValue' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionBodyContainsFailureStrings$member' => NULL, 'ResponseInspectionHeaderFailureValues$member' => NULL, 'ResponseInspectionJsonFailureValues$member' => NULL, ], ], 'FallbackBehavior' => [ 'base' => NULL, 'refs' => [ 'ForwardedIPConfig$FallbackBehavior' => '<p>The match status to assign to the web request if the request doesn\'t have a valid IP address in the specified position.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>You can specify the following fallback behaviors:</p> <ul> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'IPSetForwardedIPConfig$FallbackBehavior' => '<p>The match status to assign to the web request if the request doesn\'t have a valid IP address in the specified position.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>You can specify the following fallback behaviors:</p> <ul> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'JA3Fingerprint$FallbackBehavior' => '<p>The match status to assign to the web request if the request doesn\'t have a JA3 fingerprint. </p> <p>You can specify the following fallback behaviors:</p> <ul> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', ], ], 'FieldIdentifier' => [ 'base' => NULL, 'refs' => [ 'AddressField$Identifier' => '<p>The name of a single primary address field. </p> <p>How you specify the address fields depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code>, the address field idenfiers are <code>/form/primaryaddressline1</code>, <code>/form/primaryaddressline2</code>, and <code>/form/primaryaddressline3</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with input elements named <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>, the address fields identifiers are <code>primaryaddressline1</code>, <code>primaryaddressline2</code>, and <code>primaryaddressline3</code>. </p> </li> </ul>', 'EmailField$Identifier' => '<p>The name of the email field. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code>, the email field specification is <code>/form/email</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>email1</code>, the email field specification is <code>email1</code>.</p> </li> </ul>', 'PasswordField$Identifier' => '<p>The name of the password field. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field specification is <code>/form/password</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>password1</code>, the password field specification is <code>password1</code>.</p> </li> </ul>', 'PhoneNumberField$Identifier' => '<p>The name of a single primary phone number field. </p> <p>How you specify the phone number fields depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>, the phone number field identifiers are <code>/form/primaryphoneline1</code>, <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with input elements named <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>. </p> </li> </ul>', 'ResponseInspectionJson$Identifier' => '<p>The identifier for the value to match against in the JSON. The identifier must be an exact match, including case.</p> <p>JSON examples: <code>"Identifier": [ "/login/success" ]</code> and <code>"Identifier": [ "/sign-up/success" ]</code> </p>', 'UsernameField$Identifier' => '<p>The name of the username field. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field specification is <code>/form/username</code>. </p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>username1</code>, the username field specification is <code>username1</code> </p> </li> </ul>', ], ], 'FieldToMatch' => [ 'base' => '<p>Specifies a web request component to be used in a rule match statement or in a logging configuration. </p> <ul> <li> <p>In a rule statement, this is the part of the web request that you want WAF to inspect. Include the single <code>FieldToMatch</code> type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in <code>FieldToMatch</code> for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.</p> <p>Example JSON for a <code>QueryString</code> field to match: </p> <p> <code> "FieldToMatch": { "QueryString": {} }</code> </p> <p>Example JSON for a <code>Method</code> field to match specification:</p> <p> <code> "FieldToMatch": { "Method": { "Name": "DELETE" } }</code> </p> </li> <li> <p>In a logging configuration, this is used in the <code>RedactedFields</code> property to specify a field to redact from the logging records. For this use case, note the following: </p> <ul> <li> <p>Even though all <code>FieldToMatch</code> settings are available, the only valid settings for field redaction are <code>UriPath</code>, <code>QueryString</code>, <code>SingleHeader</code>, and <code>Method</code>.</p> </li> <li> <p>In this documentation, the descriptions of the individual fields talk about specifying the web request component to inspect, but for field redaction, you are specifying the component type to redact from the logs. </p> </li> <li> <p>If you have request sampling enabled, the redacted fields configuration for logging has no impact on sampling. The only way to exclude fields from request sampling is by disabling sampling in the web ACL visibility configuration. </p> </li> </ul> </li> </ul>', 'refs' => [ 'ByteMatchStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', 'RedactedFields$member' => NULL, 'RegexMatchStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', 'RegexPatternSetReferenceStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', 'SizeConstraintStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', 'SqliMatchStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', 'XssMatchStatement$FieldToMatch' => '<p>The part of the web request that you want WAF to inspect. </p>', ], ], 'FieldToMatchData' => [ 'base' => NULL, 'refs' => [ 'HeaderNames$member' => NULL, 'RateLimitCookie$Name' => '<p>The name of the cookie to use. </p>', 'RateLimitHeader$Name' => '<p>The name of the header to use. </p>', 'RateLimitQueryArgument$Name' => '<p>The name of the query argument to use. </p>', 'SingleHeader$Name' => '<p>The name of the query header to inspect.</p>', 'SingleQueryArgument$Name' => '<p>The name of the query argument to inspect.</p>', ], ], 'Filter' => [ 'base' => '<p>A single logging filter, used in <a>LoggingFilter</a>. </p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterBehavior' => [ 'base' => NULL, 'refs' => [ 'Filter$Behavior' => '<p>How to handle logs that satisfy the filter\'s conditions and requirement. </p>', 'LoggingFilter$DefaultBehavior' => '<p>Default handling for logs that don\'t match any of the specified filtering conditions. </p>', ], ], 'FilterRequirement' => [ 'base' => NULL, 'refs' => [ 'Filter$Requirement' => '<p>Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'LoggingFilter$Filters' => '<p>The filters that you want to apply to the logs. </p>', ], ], 'FirewallManagerRuleGroup' => [ 'base' => '<p>A rule group that\'s defined for an Firewall Manager WAF policy.</p>', 'refs' => [ 'FirewallManagerRuleGroups$member' => NULL, ], ], 'FirewallManagerRuleGroups' => [ 'base' => NULL, 'refs' => [ 'WebACL$PreProcessFirewallManagerRuleGroups' => '<p>The first set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can\'t alter these. Any rules and rule groups that you define for the web ACL are prioritized after these. </p> <p>In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.</p>', 'WebACL$PostProcessFirewallManagerRuleGroups' => '<p>The last set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can\'t alter these. Any rules and rule groups that you define for the web ACL are prioritized before these. </p> <p>In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.</p>', ], ], 'FirewallManagerStatement' => [ 'base' => '<p>The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only contain a single rule group reference.</p>', 'refs' => [ 'FirewallManagerRuleGroup$FirewallManagerStatement' => '<p>The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only contain a rule group reference.</p>', ], ], 'ForwardedIPConfig' => [ 'base' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This configuration is used for <a>GeoMatchStatement</a> and <a>RateBasedStatement</a>. For <a>IPSetReferenceStatement</a>, use <a>IPSetForwardedIPConfig</a> instead. </p> <p>WAF only evaluates the first IP address found in the specified HTTP header. </p>', 'refs' => [ 'GeoMatchStatement$ForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', 'RateBasedStatement$ForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This is required if you specify a forwarded IP in the rule\'s aggregate key settings. </p>', ], ], 'ForwardedIPHeaderName' => [ 'base' => NULL, 'refs' => [ 'ForwardedIPConfig$HeaderName' => '<p>The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code>.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', 'IPSetForwardedIPConfig$HeaderName' => '<p>The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code>.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', ], ], 'ForwardedIPPosition' => [ 'base' => NULL, 'refs' => [ 'IPSetForwardedIPConfig$Position' => '<p>The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through. </p> <p>The options for this setting are the following: </p> <ul> <li> <p>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client\'s original IP.</p> </li> <li> <p>LAST - Inspect the last IP address in the list of IP addresses in the header.</p> </li> <li> <p>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, WAF inspects the last 10.</p> </li> </ul>', ], ], 'GenerateMobileSdkReleaseUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateMobileSdkReleaseUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'GeoMatchStatement' => [ 'base' => '<p>A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.</p> <ul> <li> <p>To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the <code>CountryCodes</code> array. </p> </li> <li> <p>Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed. </p> </li> </ul> <p>WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match <code>ForwardedIPConfig</code>. </p> <p>If you use the web request origin, the label formats are <code>awswaf:clientip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:clientip:geo:country:&lt;ISO country code&gt;</code>.</p> <p>If you use a forwarded IP address, the label formats are <code>awswaf:forwardedip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:forwardedip:geo:country:&lt;ISO country code&gt;</code>.</p> <p>For additional details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html">Geographic match rule statement</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'refs' => [ 'Statement$GeoMatchStatement' => '<p>A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.</p> <ul> <li> <p>To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the <code>CountryCodes</code> array. </p> </li> <li> <p>Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed. </p> </li> </ul> <p>WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match <code>ForwardedIPConfig</code>. </p> <p>If you use the web request origin, the label formats are <code>awswaf:clientip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:clientip:geo:country:&lt;ISO country code&gt;</code>.</p> <p>If you use a forwarded IP address, the label formats are <code>awswaf:forwardedip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:forwardedip:geo:country:&lt;ISO country code&gt;</code>.</p> <p>For additional details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html">Geographic match rule statement</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'GetDecryptedAPIKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDecryptedAPIKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileSdkReleaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileSdkReleaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRateBasedStatementManagedKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRateBasedStatementManagedKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSampledRequestsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSampledRequestsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'HTTPHeader' => [ 'base' => '<p>Part of the response from <a>GetSampledRequests</a>. This is a complex type that appears as <code>Headers</code> in the response syntax. <code>HTTPHeader</code> contains the names and values of all of the headers that appear in one of the web requests. </p>', 'refs' => [ 'HTTPHeaders$member' => NULL, ], ], 'HTTPHeaders' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Headers' => '<p>A complex type that contains the name and value for each header in the sampled web request.</p>', 'SampledHTTPRequest$RequestHeadersInserted' => '<p>Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.</p>', ], ], 'HTTPMethod' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Method' => '<p>The HTTP method specified in the sampled web request. </p>', ], ], 'HTTPRequest' => [ 'base' => '<p>Part of the response from <a>GetSampledRequests</a>. This is a complex type that appears as <code>Request</code> in the response syntax. <code>HTTPRequest</code> contains information about one of the web requests. </p>', 'refs' => [ 'SampledHTTPRequest$Request' => '<p>A complex type that contains detailed information about the request.</p>', ], ], 'HTTPVersion' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$HTTPVersion' => '<p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>', ], ], 'HeaderMatchPattern' => [ 'base' => '<p>The filter to use to identify the subset of headers to inspect in a web request. </p> <p>You must specify exactly one setting: either <code>All</code>, <code>IncludedHeaders</code>, or <code>ExcludedHeaders</code>.</p> <p>Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code> </p>', 'refs' => [ 'Headers$MatchPattern' => '<p>The filter to use to identify the subset of headers to inspect in a web request. </p> <p>You must specify exactly one setting: either <code>All</code>, <code>IncludedHeaders</code>, or <code>ExcludedHeaders</code>.</p> <p>Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code> </p>', ], ], 'HeaderName' => [ 'base' => NULL, 'refs' => [ 'HTTPHeader$Name' => '<p>The name of the HTTP header.</p>', ], ], 'HeaderNames' => [ 'base' => NULL, 'refs' => [ 'HeaderMatchPattern$IncludedHeaders' => '<p>Inspect only the headers that have a key that matches one of the strings specified here. </p>', 'HeaderMatchPattern$ExcludedHeaders' => '<p>Inspect only the headers whose keys don\'t match any of the strings specified here. </p>', ], ], 'HeaderOrder' => [ 'base' => '<p>Inspect a string containing the list of the request\'s header names, ordered as they appear in the web request that WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its inspection. WAF separates the header names in the string using colons and no added spaces, for example <code>host:user-agent:accept:authorization:referer</code>.</p>', 'refs' => [ 'FieldToMatch$HeaderOrder' => '<p>Inspect a string containing the list of the request\'s header names, ordered as they appear in the web request that WAF receives for inspection. WAF generates the string and then uses that as the field to match component in its inspection. WAF separates the header names in the string using colons and no added spaces, for example <code>host:user-agent:accept:authorization:referer</code>.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'HTTPHeader$Value' => '<p>The value of the HTTP header.</p>', ], ], 'Headers' => [ 'base' => '<p>Inspect all headers in the web request. You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.</p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p> <p>If you want to inspect just the value of a single header, use the <code>SingleHeader</code> <code>FieldToMatch</code> setting instead.</p> <p>Example JSON: <code>"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code> </p>', 'refs' => [ 'FieldToMatch$Headers' => '<p>Inspect the request headers. You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that WAF inspects. </p> <p>Only the first 8 KB (8192 bytes) of a request\'s headers and only the first 200 headers are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. WAF applies the pattern matching filters to the headers that it receives from the underlying host service. </p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'IPAddresses$member' => NULL, ], ], 'IPAddressVersion' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', 'IPSet$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', 'RateBasedStatementManagedKeysIPSet$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', ], ], 'IPAddresses' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Addresses' => '<p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p> <p>Example address strings: </p> <ul> <li> <p>For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p> <p>Example JSON <code>Addresses</code> specifications: </p> <ul> <li> <p>Empty array: <code>"Addresses": []</code> </p> </li> <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li> <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li> <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li> </ul>', 'IPSet$Addresses' => '<p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p> <p>Example address strings: </p> <ul> <li> <p>For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p> <p>Example JSON <code>Addresses</code> specifications: </p> <ul> <li> <p>Empty array: <code>"Addresses": []</code> </p> </li> <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li> <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li> <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li> </ul>', 'RateBasedStatementManagedKeysIPSet$Addresses' => '<p>The IP addresses that are currently blocked.</p>', 'UpdateIPSetRequest$Addresses' => '<p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses that you want WAF to inspect for in incoming requests. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for <code>/0</code>. </p> <p>Example address strings: </p> <ul> <li> <p>For requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>For requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>For requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>For requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p> <p>Example JSON <code>Addresses</code> specifications: </p> <ul> <li> <p>Empty array: <code>"Addresses": []</code> </p> </li> <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li> <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li> <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li> </ul>', ], ], 'IPSet' => [ 'base' => '<p>Contains zero or more IP addresses or blocks of IP addresses specified in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. For information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p> <p>WAF assigns an ARN to each <code>IPSet</code> that you create. To use an IP set in a rule, you provide the ARN to the <a>Rule</a> statement <a>IPSetReferenceStatement</a>. </p>', 'refs' => [ 'GetIPSetResponse$IPSet' => '<p/>', ], ], 'IPSetForwardedIPConfig' => [ 'base' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This configuration is used only for <a>IPSetReferenceStatement</a>. For <a>GeoMatchStatement</a> and <a>RateBasedStatement</a>, use <a>ForwardedIPConfig</a> instead. </p>', 'refs' => [ 'IPSetReferenceStatement$IPSetForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', ], ], 'IPSetReferenceStatement' => [ 'base' => '<p>A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p> <p>Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', 'refs' => [ 'Statement$IPSetReferenceStatement' => '<p>A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p> <p>Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', ], ], 'IPSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListIPSetsResponse$IPSets' => '<p>Array of IPSets. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'IPSetSummary' => [ 'base' => '<p>High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.</p>', 'refs' => [ 'CreateIPSetResponse$Summary' => '<p>High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.</p>', 'IPSetSummaries$member' => NULL, ], ], 'IPString' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$ClientIP' => '<p>The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p> <ul> <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li> <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li> </ul>', ], ], 'ImmunityTimeProperty' => [ 'base' => '<p>Used for CAPTCHA and challenge token settings. Determines how long a <code>CAPTCHA</code> or challenge timestamp remains valid after WAF updates it for a successful <code>CAPTCHA</code> or challenge response. </p>', 'refs' => [ 'CaptchaConfig$ImmunityTimeProperty' => '<p>Determines how long a <code>CAPTCHA</code> timestamp in the token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle. </p>', 'ChallengeConfig$ImmunityTimeProperty' => '<p>Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge. </p>', ], ], 'InspectionLevel' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesBotControlRuleSet$InspectionLevel' => '<p>The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control rule group</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'JA3Fingerprint' => [ 'base' => '<p>Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request\'s JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client\'s TLS configuration. WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.</p> <note> <p>You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code>. </p> </note> <p>You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <i>WAF Developer Guide</i>. </p> <p>Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.</p>', 'refs' => [ 'FieldToMatch$JA3Fingerprint' => '<p>Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request\'s JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client\'s TLS configuration. WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.</p> <note> <p>You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code>. </p> </note> <p>You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <i>WAF Developer Guide</i>. </p> <p>Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.</p>', ], ], 'JsonBody' => [ 'base' => '<p>Inspect the body of the web request as JSON. The body immediately follows the request headers. </p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule\'s inspection criteria. WAF inspects only the parts of the JSON that result from the matches that you indicate. </p> <p>Example JSON: <code>"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }</code> </p> <p>For additional information about this request component option, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body">JSON body</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'FieldToMatch$JsonBody' => '<p>Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. </p> <p>WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to WAF for inspection. </p> <ul> <li> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p> </li> <li> <p>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for additional processing fees. </p> </li> </ul> <p>For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration. </p>', ], ], 'JsonMatchPattern' => [ 'base' => '<p>The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the <a>FieldToMatch</a> option <code>JsonBody</code>. </p>', 'refs' => [ 'JsonBody$MatchPattern' => '<p>The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria. </p>', ], ], 'JsonMatchScope' => [ 'base' => NULL, 'refs' => [ 'JsonBody$MatchScope' => '<p>The parts of the JSON to match against using the <code>MatchPattern</code>. If you specify <code>ALL</code>, WAF matches against keys and values. </p> <p> <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values. </p>', ], ], 'JsonPointerPath' => [ 'base' => NULL, 'refs' => [ 'JsonPointerPaths$member' => NULL, ], ], 'JsonPointerPaths' => [ 'base' => NULL, 'refs' => [ 'JsonMatchPattern$IncludedPaths' => '<p>Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>. </p> <p>Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>You must specify either this setting or the <code>All</code> setting, but not both.</p> <note> <p>Don\'t use this option to include all paths. Instead, use the <code>All</code> setting. </p> </note>', ], ], 'Label' => [ 'base' => '<p>A single label container. This is used as an element of a label array in multiple contexts, for example, in <code>RuleLabels</code> inside a <a>Rule</a> and in <code>Labels</code> inside a <a>SampledHTTPRequest</a>. </p>', 'refs' => [ 'Labels$member' => NULL, ], ], 'LabelMatchKey' => [ 'base' => NULL, 'refs' => [ 'LabelMatchStatement$Key' => '<p>The string to match against. The setting you provide for this depends on the match statement\'s <code>Scope</code> setting: </p> <ul> <li> <p>If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. </p> </li> <li> <p>If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</p> </li> </ul> <p>Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code>.</p>', ], ], 'LabelMatchScope' => [ 'base' => NULL, 'refs' => [ 'LabelMatchStatement$Scope' => '<p>Specify whether you want to match using the label name or just the namespace. </p>', ], ], 'LabelMatchStatement' => [ 'base' => '<p>A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL. </p> <p>The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement. </p>', 'refs' => [ 'Statement$LabelMatchStatement' => '<p>A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL. </p> <p>The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement. </p>', ], ], 'LabelName' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$LabelNamespace' => '<p>The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'Label$Name' => '<p>The label string. </p>', 'LabelNameCondition$LabelName' => '<p>The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. </p>', 'LabelSummary$Name' => '<p>An individual label specification.</p>', 'ManagedRuleSet$LabelNamespace' => '<p>The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'ManagedRuleSetSummary$LabelNamespace' => '<p>The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'RuleGroup$LabelNamespace' => '<p>The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for your rule groups is the following: </p> <p> <code>awswaf:&lt;account ID&gt;:rulegroup:&lt;rule group name&gt;:</code> </p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'WebACL$LabelNamespace' => '<p>The label namespace prefix for this web ACL. All labels added by rules in this web ACL have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a web ACL is the following: </p> <p> <code>awswaf:&lt;account ID&gt;:webacl:&lt;web ACL name&gt;:</code> </p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', ], ], 'LabelNameCondition' => [ 'base' => '<p>A single label name condition for a <a>Condition</a> in a logging filter.</p>', 'refs' => [ 'Condition$LabelNameCondition' => '<p>A single label name condition. This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. </p>', ], ], 'LabelNamespace' => [ 'base' => NULL, 'refs' => [ 'RateLimitLabelNamespace$Namespace' => '<p>The namespace to use for aggregation. </p>', ], ], 'LabelSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$AvailableLabels' => '<p>The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>.</p>', 'DescribeManagedRuleGroupResponse$ConsumedLabels' => '<p>The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p>', 'RuleGroup$AvailableLabels' => '<p>The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>.</p>', 'RuleGroup$ConsumedLabels' => '<p>The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p>', ], ], 'LabelSummary' => [ 'base' => '<p>List of labels used by one or more of the rules of a <a>RuleGroup</a>. This summary object is used for the following rule group lists: </p> <ul> <li> <p> <code>AvailableLabels</code> - Labels that rules add to matching requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>. </p> </li> <li> <p> <code>ConsumedLabels</code> - Labels that rules match against. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p> </li> </ul>', 'refs' => [ 'LabelSummaries$member' => NULL, ], ], 'Labels' => [ 'base' => NULL, 'refs' => [ 'Rule$RuleLabels' => '<p>Labels to apply to web requests that match the rule match statement. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule\'s rule group or web ACL defines the label namespace. </p> <p>Rules that run after this rule in the web ACL can match against these labels using a <code>LabelMatchStatement</code>.</p> <p>For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:</p> <ul> <li> <p>Separate each component of the label with a colon. </p> </li> <li> <p>Each namespace or name can have up to 128 characters.</p> </li> <li> <p>You can specify up to 5 namespaces in a label.</p> </li> <li> <p>Don\'t use the following reserved words in your label specification: <code>aws</code>, <code>waf</code>, <code>managed</code>, <code>rulegroup</code>, <code>webacl</code>, <code>regexpatternset</code>, or <code>ipset</code>.</p> </li> </ul> <p>For example, <code>myLabelName</code> or <code>nameSpace1:nameSpace2:myLabelName</code>. </p>', 'SampledHTTPRequest$Labels' => '<p>Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule\'s rule group or web ACL defines the label namespace. </p> <p>For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>. </p>', ], ], 'ListAPIKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAPIKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLoggingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLoggingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedRuleSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedRuleSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMaxItems' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsRequest$MaxItems' => '<p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>', ], ], 'ListMobileSdkReleasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileSdkReleasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRegexPatternSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegexPatternSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesForWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesForWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWebACLsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWebACLsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LockToken' => [ 'base' => NULL, 'refs' => [ 'DeleteFirewallManagerRuleGroupsRequest$WebACLLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteFirewallManagerRuleGroupsResponse$NextWebACLLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteIPSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteRegexPatternSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteRuleGroupRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteWebACLRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetIPSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetManagedRuleSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetRegexPatternSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetRuleGroupResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetWebACLResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'IPSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'ManagedRuleSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'PutManagedRuleSetVersionsRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'PutManagedRuleSetVersionsResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'RegexPatternSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'RuleGroupSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateIPSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateIPSetResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRegexPatternSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRegexPatternSetResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateRuleGroupRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRuleGroupResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateWebACLRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateWebACLResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'WebACLSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', ], ], 'LogDestinationConfigs' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$LogDestinationConfigs' => '<p>The logging destination configuration that you want to associate with the web ACL.</p> <note> <p>You can associate one logging destination to a web ACL.</p> </note>', ], ], 'LogScope' => [ 'base' => NULL, 'refs' => [ 'DeleteLoggingConfigurationRequest$LogScope' => '<p>The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that you manage. </p> <p>The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>. </p> <p>Default: <code>CUSTOMER</code> </p>', 'GetLoggingConfigurationRequest$LogScope' => '<p>The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that you manage. </p> <p>The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>. </p> <p>Default: <code>CUSTOMER</code> </p>', 'ListLoggingConfigurationsRequest$LogScope' => '<p>The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that you manage. </p> <p>The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>. </p> <p>Default: <code>CUSTOMER</code> </p>', 'LoggingConfiguration$LogScope' => '<p>The owner of the logging configuration, which must be set to <code>CUSTOMER</code> for the configurations that you manage. </p> <p>The log scope <code>SECURITY_LAKE</code> indicates a configuration that is managed through Amazon Security Lake. You can use Security Lake to collect log and event data from various sources for normalization, analysis, and management. For information, see <a href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Collecting data from Amazon Web Services services</a> in the <i>Amazon Security Lake user guide</i>. </p> <p>Default: <code>CUSTOMER</code> </p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'DeleteLoggingConfigurationRequest$LogType' => '<p>Used to distinguish between various logging options. Currently, there is one option.</p> <p>Default: <code>WAF_LOGS</code> </p>', 'GetLoggingConfigurationRequest$LogType' => '<p>Used to distinguish between various logging options. Currently, there is one option.</p> <p>Default: <code>WAF_LOGS</code> </p>', 'LoggingConfiguration$LogType' => '<p>Used to distinguish between various logging options. Currently, there is one option.</p> <p>Default: <code>WAF_LOGS</code> </p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>Defines an association between logging destinations and a web ACL resource, for logging from WAF. As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records. </p> <note> <p>You can define one logging destination per web ACL.</p> </note> <p>You can access information about the traffic that WAF inspects using the following steps:</p> <ol> <li> <p>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. </p> <p>The name that you give the destination must start with <code>aws-waf-logs-</code>. Depending on the type of destination, you might need to configure additional settings or permissions. </p> <p>For configuration requirements and pricing information for each destination type, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic</a> in the <i>WAF Developer Guide</i>.</p> </li> <li> <p>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li> </ol> <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.</p> <p>For additional information about web ACL logging, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'GetLoggingConfigurationResponse$LoggingConfiguration' => '<p>The <a>LoggingConfiguration</a> for the specified web ACL.</p>', 'LoggingConfigurations$member' => NULL, 'PutLoggingConfigurationRequest$LoggingConfiguration' => '<p/>', 'PutLoggingConfigurationResponse$LoggingConfiguration' => '<p/>', ], ], 'LoggingConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListLoggingConfigurationsResponse$LoggingConfigurations' => '<p>Array of logging configurations. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'LoggingFilter' => [ 'base' => '<p>Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL\'s <a>LoggingConfiguration</a>. </p> <p>You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation. </p>', 'refs' => [ 'LoggingConfiguration$LoggingFilter' => '<p>Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation. </p>', ], ], 'LoginPathString' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupConfig$LoginPath' => '<note> <p>Instead of this setting, provide your configuration under <code>AWSManagedRulesATPRuleSet</code>. </p> </note>', ], ], 'ManagedProductDescriptor' => [ 'base' => '<p>The properties of a managed product, such as an Amazon Web Services Managed Rules rule group or an Amazon Web Services Marketplace managed rule group. </p>', 'refs' => [ 'ManagedProductDescriptors$member' => NULL, ], ], 'ManagedProductDescriptors' => [ 'base' => NULL, 'refs' => [ 'DescribeAllManagedProductsResponse$ManagedProducts' => '<p>High-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace managed rule groups. </p>', 'DescribeManagedProductsByVendorResponse$ManagedProducts' => '<p>High-level information for the managed rule groups owned by the specified vendor. </p>', ], ], 'ManagedRuleGroupConfig' => [ 'base' => '<p>Additional information that\'s used by a managed rule group. Many managed rule groups don\'t require this.</p> <p>The rule groups used for intelligent threat mitigation require additional configuration: </p> <ul> <li> <p>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields. </p> </li> <li> <p>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password. </p> </li> <li> <p>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use. </p> </li> </ul> <p>For example specifications, see the examples section of <a>CreateWebACL</a>.</p>', 'refs' => [ 'ManagedRuleGroupConfigs$member' => NULL, ], ], 'ManagedRuleGroupConfigs' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupStatement$ManagedRuleGroupConfigs' => '<p>Additional information that\'s used by a managed rule group. Many managed rule groups don\'t require this.</p> <p>The rule groups used for intelligent threat mitigation require additional configuration: </p> <ul> <li> <p>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields. </p> </li> <li> <p>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password. </p> </li> <li> <p>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use. </p> </li> </ul>', ], ], 'ManagedRuleGroupStatement' => [ 'base' => '<p>A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling <a>ListAvailableManagedRuleGroups</a>.</p> <p>You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You cannot use a managed rule group inside another rule group. You can only reference a managed rule group as a top-level statement within a rule that you define in a web ACL.</p> <note> <p>You are charged additional fees when you use the WAF Bot Control managed rule group <code>AWSManagedRulesBotControlRuleSet</code>, the WAF Fraud Control account takeover prevention (ATP) managed rule group <code>AWSManagedRulesATPRuleSet</code>, or the WAF Fraud Control account creation fraud prevention (ACFP) managed rule group <code>AWSManagedRulesACFPRuleSet</code>. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note>', 'refs' => [ 'FirewallManagerStatement$ManagedRuleGroupStatement' => '<p>A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This is managed by Firewall Manager for an Firewall Manager WAF policy.</p>', 'Statement$ManagedRuleGroupStatement' => '<p>A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling <a>ListAvailableManagedRuleGroups</a>.</p> <p>You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You cannot use a managed rule group inside another rule group. You can only reference a managed rule group as a top-level statement within a rule that you define in a web ACL.</p> <note> <p>You are charged additional fees when you use the WAF Bot Control managed rule group <code>AWSManagedRulesBotControlRuleSet</code>, the WAF Fraud Control account takeover prevention (ATP) managed rule group <code>AWSManagedRulesATPRuleSet</code>, or the WAF Fraud Control account creation fraud prevention (ACFP) managed rule group <code>AWSManagedRulesACFPRuleSet</code>. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note>', ], ], 'ManagedRuleGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupsResponse$ManagedRuleGroups' => '<p>Array of managed rule groups that you can use. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'ManagedRuleGroupSummary' => [ 'base' => '<p>High-level information about a managed rule group, returned by <a>ListAvailableManagedRuleGroups</a>. This provides information like the name and vendor name, that you provide when you add a <a>ManagedRuleGroupStatement</a> to a web ACL. Managed rule groups include Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace managed rule groups. To use any Amazon Web Services Marketplace managed rule group, first subscribe to the rule group through Amazon Web Services Marketplace. </p>', 'refs' => [ 'ManagedRuleGroupSummaries$member' => NULL, ], ], 'ManagedRuleGroupVersion' => [ 'base' => '<p>Describes a single version of a managed rule group. </p>', 'refs' => [ 'ManagedRuleGroupVersions$member' => NULL, ], ], 'ManagedRuleGroupVersions' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupVersionsResponse$Versions' => '<p>The versions that are currently available for the specified managed rule group. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'ManagedRuleSet' => [ 'base' => '<p>A set of rules that is managed by Amazon Web Services and Amazon Web Services Marketplace sellers to provide versioned managed rule groups for customers of WAF.</p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'GetManagedRuleSetResponse$ManagedRuleSet' => '<p>The managed rule set that you requested. </p>', ], ], 'ManagedRuleSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListManagedRuleSetsResponse$ManagedRuleSets' => '<p>Your managed rule sets. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'ManagedRuleSetSummary' => [ 'base' => '<p>High-level information for a managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'ManagedRuleSetSummaries$member' => NULL, ], ], 'ManagedRuleSetVersion' => [ 'base' => '<p>Information for a single version of a managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'PublishedVersions$value' => NULL, ], ], 'MapMatchScope' => [ 'base' => NULL, 'refs' => [ 'Cookies$MatchScope' => '<p>The parts of the cookies to inspect with the rule inspection criteria. If you specify <code>ALL</code>, WAF inspects both keys and values. </p> <p> <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values. </p>', 'Headers$MatchScope' => '<p>The parts of the headers to match with the rule inspection criteria. If you specify <code>ALL</code>, WAF inspects both keys and values. </p> <p> <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values. </p>', ], ], 'Method' => [ 'base' => '<p>Inspect the HTTP method of the web request. The method indicates the type of operation that the request is asking the origin to perform. </p> <p>This is used in the <a>FieldToMatch</a> specification for some web request component types. </p> <p>JSON specification: <code>"Method": {}</code> </p>', 'refs' => [ 'FieldToMatch$Method' => '<p>Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform. </p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsRequest$RuleMetricName' => '<p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> dimension for which you want a sample of requests.</p>', 'VisibilityConfig$MetricName' => '<p>A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can\'t contain whitespace or metric names that are reserved for WAF, for example <code>All</code> and <code>Default_Action</code>. </p>', ], ], 'MobileSdkRelease' => [ 'base' => '<p>Information for a release of the mobile SDK, including release notes and tags.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'GetMobileSdkReleaseResponse$MobileSdkRelease' => '<p>Information for a specified SDK release, including release notes and tags.</p>', ], ], 'NextMarker' => [ 'base' => NULL, 'refs' => [ 'ListAPIKeysRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAPIKeysResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupVersionsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListIPSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListIPSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListLoggingConfigurationsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListLoggingConfigurationsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListManagedRuleSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListManagedRuleSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListMobileSdkReleasesRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListMobileSdkReleasesResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRegexPatternSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRegexPatternSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRuleGroupsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRuleGroupsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListTagsForResourceRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListTagsForResourceResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListWebACLsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListWebACLsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', ], ], 'NoneAction' => [ 'base' => '<p>Specifies that WAF should do nothing. This is used for the <code>OverrideAction</code> setting on a <a>Rule</a> when the rule uses a rule group reference statement. </p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p> <p>JSON specification: <code>"None": {}</code> </p>', 'refs' => [ 'OverrideAction$None' => '<p>Don\'t override the rule group evaluation result. This is the most common setting.</p>', ], ], 'NotStatement' => [ 'base' => '<p>A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a> within the <code>NotStatement</code>.</p>', 'refs' => [ 'Statement$NotStatement' => '<p>A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a> within the <code>NotStatement</code>.</p>', ], ], 'OrStatement' => [ 'base' => '<p>A logical rule statement used to combine other rule statements with OR logic. You provide more than one <a>Statement</a> within the <code>OrStatement</code>. </p>', 'refs' => [ 'Statement$OrStatement' => '<p>A logical rule statement used to combine other rule statements with OR logic. You provide more than one <a>Statement</a> within the <code>OrStatement</code>. </p>', ], ], 'OutputUrl' => [ 'base' => NULL, 'refs' => [ 'GetWebACLResponse$ApplicationIntegrationURL' => '<p>The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use the integration SDKs with the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code> and the account creation fraud prevention managed rule group <code>AWSManagedRulesACFPRuleSet</code>. This is only populated if you are using a rule group in your web ACL that integrates with your applications in this way. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>', 'ListAPIKeysResponse$ApplicationIntegrationURL' => '<p>The CAPTCHA application integration URL, for use in your JavaScript implementation. </p>', ], ], 'OverrideAction' => [ 'base' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings. </p> </note>', 'refs' => [ 'FirewallManagerRuleGroup$OverrideAction' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings. </p> </note>', 'Rule$OverrideAction' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings. </p> </note>', ], ], 'OversizeHandling' => [ 'base' => NULL, 'refs' => [ 'Body$OversizeHandling' => '<p>What WAF should do if the body is larger than WAF can inspect. </p> <p>WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to WAF for inspection. </p> <ul> <li> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p> </li> <li> <p>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for additional processing fees. </p> </li> </ul> <p>The options for oversize handling are the following:</p> <ul> <li> <p> <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria. </p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul> <p>You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. </p> <p>Default: <code>CONTINUE</code> </p>', 'Cookies$OversizeHandling' => '<p>What WAF should do if the cookies of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to WAF. </p> <p>The options for oversize handling are the following:</p> <ul> <li> <p> <code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria. </p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'HeaderOrder$OversizeHandling' => '<p>What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF. </p> <p>The options for oversize handling are the following:</p> <ul> <li> <p> <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria. </p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'Headers$OversizeHandling' => '<p>What WAF should do if the headers of the request are more numerous or larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF. </p> <p>The options for oversize handling are the following:</p> <ul> <li> <p> <code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria. </p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'JsonBody$OversizeHandling' => '<p>What WAF should do if the body is larger than WAF can inspect. </p> <p>WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to WAF for inspection. </p> <ul> <li> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p> </li> <li> <p>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for additional processing fees. </p> </li> </ul> <p>The options for oversize handling are the following:</p> <ul> <li> <p> <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria. </p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul> <p>You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit. </p> <p>Default: <code>CONTINUE</code> </p>', ], ], 'PaginationLimit' => [ 'base' => NULL, 'refs' => [ 'ListAPIKeysRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListAvailableManagedRuleGroupsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListIPSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListLoggingConfigurationsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListManagedRuleSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListMobileSdkReleasesRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListRegexPatternSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListRuleGroupsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListTagsForResourceRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListWebACLsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', ], ], 'ParameterExceptionField' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Field' => '<p>The settings where the invalid parameter was found. </p>', ], ], 'ParameterExceptionParameter' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Parameter' => '<p>The invalid parameter that resulted in the exception. </p>', ], ], 'PasswordField' => [ 'base' => '<p>The name of the field in the request payload that contains your customer\'s password. </p> <p>This data type is used in the <code>RequestInspection</code> and <code>RequestInspectionACFP</code> data types. </p>', 'refs' => [ 'ManagedRuleGroupConfig$PasswordField' => '<note> <p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code>. </p> </note>', 'RequestInspection$PasswordField' => '<p>The name of the field in the request payload that contains your customer\'s password. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field specification is <code>/form/password</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>password1</code>, the password field specification is <code>password1</code>.</p> </li> </ul>', 'RequestInspectionACFP$PasswordField' => '<p>The name of the field in the request payload that contains your customer\'s password. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code>, the password field specification is <code>/form/password</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>password1</code>, the password field specification is <code>password1</code>.</p> </li> </ul>', ], ], 'PayloadType' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupConfig$PayloadType' => '<note> <p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code>. </p> </note>', 'RequestInspection$PayloadType' => '<p>The payload type for your login endpoint, either JSON or form encoded.</p>', 'RequestInspectionACFP$PayloadType' => '<p>The payload type for your account creation endpoint, either JSON or form encoded.</p>', ], ], 'PhoneNumberField' => [ 'base' => '<p>The name of a field in the request payload that contains part or all of your customer\'s primary phone number. </p> <p>This data type is used in the <code>RequestInspectionACFP</code> data type. </p>', 'refs' => [ 'PhoneNumberFields$member' => NULL, ], ], 'PhoneNumberFields' => [ 'base' => NULL, 'refs' => [ 'RequestInspectionACFP$PhoneNumberFields' => '<p>The names of the fields in the request payload that contain your customer\'s primary phone number. </p> <p>Order the phone number fields in the array exactly as they are ordered in the request payload. </p> <p>How you specify the phone number fields depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code>, the phone number field identifiers are <code>/form/primaryphoneline1</code>, <code>/form/primaryphoneline2</code>, and <code>/form/primaryphoneline3</code>.</p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with input elements named <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>, the phone number field identifiers are <code>primaryphoneline1</code>, <code>primaryphoneline2</code>, and <code>primaryphoneline3</code>. </p> </li> </ul>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'GenerateMobileSdkReleaseUrlRequest$Platform' => '<p>The device platform.</p>', 'GetMobileSdkReleaseRequest$Platform' => '<p>The device platform.</p>', 'ListMobileSdkReleasesRequest$Platform' => '<p>The device platform to retrieve the list for.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetPermissionPolicyResponse$Policy' => '<p>The IAM policy that is attached to the specified rule group.</p>', 'PutPermissionPolicyRequest$Policy' => '<p>The policy to attach to the specified rule group. </p> <p>The policy specifications must conform to the following:</p> <ul> <li> <p>The policy must be composed using IAM Policy version 2012-10-17.</p> </li> <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li> <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li> <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li> <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>', ], ], 'PopulationSize' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsResponse$PopulationSize' => '<p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your Amazon Web Services resource received during the specified time range.</p>', ], ], 'PositionalConstraint' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$PositionalConstraint' => '<p>The area within the portion of the web request that you want WAF to search for <code>SearchString</code>. Valid values include the following:</p> <p> <b>CONTAINS</b> </p> <p>The specified part of the web request must include the value of <code>SearchString</code>, but the location doesn\'t matter.</p> <p> <b>CONTAINS_WORD</b> </p> <p>The specified part of the web request must include the value of <code>SearchString</code>, and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:</p> <ul> <li> <p> <code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code>.</p> </li> <li> <p> <code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code>.</p> </li> </ul> <p> <b>EXACTLY</b> </p> <p>The value of the specified part of the web request must exactly match the value of <code>SearchString</code>.</p> <p> <b>STARTS_WITH</b> </p> <p>The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.</p> <p> <b>ENDS_WITH</b> </p> <p>The value of <code>SearchString</code> must appear at the end of the specified part of the web request.</p>', ], ], 'ProductDescription' => [ 'base' => NULL, 'refs' => [ 'ManagedProductDescriptor$ProductDescription' => '<p>A short description of the managed rule group.</p>', ], ], 'ProductId' => [ 'base' => NULL, 'refs' => [ 'ManagedProductDescriptor$ProductId' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', ], ], 'ProductLink' => [ 'base' => NULL, 'refs' => [ 'ManagedProductDescriptor$ProductLink' => '<p>For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page. </p>', ], ], 'ProductTitle' => [ 'base' => NULL, 'refs' => [ 'ManagedProductDescriptor$ProductTitle' => '<p>The display name for the managed rule group. For example, <code>Anonymous IP list</code> or <code>Account takeover prevention</code>.</p>', ], ], 'PublishedVersions' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleSet$PublishedVersions' => '<p>The versions of this managed rule set that are available for use by customers. </p>', ], ], 'PutLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedRuleSetVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedRuleSetVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryString' => [ 'base' => '<p>Inspect the query string of the web request. This is the part of a URL that appears after a <code>?</code> character, if any.</p> <p>This is used in the <a>FieldToMatch</a> specification for some web request component types. </p> <p>JSON specification: <code>"QueryString": {}</code> </p>', 'refs' => [ 'FieldToMatch$QueryString' => '<p>Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.</p>', ], ], 'RateBasedStatement' => [ 'base' => '<p>A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance. </p> <note> <p>If you change any of these settings in a rule that\'s currently in use, the change resets the rule\'s rate limiting counts. This can pause the rule\'s rate limiting activities for up to a minute. </p> </note> <p>You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie. </p> <p>Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition. </p> <p>For example, assume the rule evaluates web requests with the following IP address and HTTP method values: </p> <ul> <li> <p>IP address 10.1.1.1, HTTP method POST</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET</p> </li> <li> <p>IP address 127.0.0.0, HTTP method POST</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET</p> </li> </ul> <p>The rule would create different aggregation instances according to your aggregation criteria, for example: </p> <ul> <li> <p>If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>IP address 10.1.1.1: count 3</p> </li> <li> <p>IP address 127.0.0.0: count 1</p> </li> </ul> </li> <li> <p>If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>HTTP method POST: count 2</p> </li> <li> <p>HTTP method GET: count 2</p> </li> </ul> </li> <li> <p>If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>IP address 10.1.1.1, HTTP method POST: count 1</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET: count 2</p> </li> <li> <p>IP address 127.0.0.0, HTTP method POST: count 1</p> </li> </ul> </li> </ul> <p>For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which WAF counts and rate-limits individually. </p> <p>You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule. </p> <p>You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group. </p> <p>For additional information about the options, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html">Rate limiting web requests using rate-based rules</a> in the <i>WAF Developer Guide</i>. </p> <p>If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that WAF is currently rate limiting for a rule through the API call <code>GetRateBasedStatementManagedKeys</code>. This option is not available for other aggregation configurations.</p> <p>WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF. </p>', 'refs' => [ 'Statement$RateBasedStatement' => '<p>A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance. </p> <note> <p>If you change any of these settings in a rule that\'s currently in use, the change resets the rule\'s rate limiting counts. This can pause the rule\'s rate limiting activities for up to a minute. </p> </note> <p>You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie. </p> <p>Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition. </p> <p>For example, assume the rule evaluates web requests with the following IP address and HTTP method values: </p> <ul> <li> <p>IP address 10.1.1.1, HTTP method POST</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET</p> </li> <li> <p>IP address 127.0.0.0, HTTP method POST</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET</p> </li> </ul> <p>The rule would create different aggregation instances according to your aggregation criteria, for example: </p> <ul> <li> <p>If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>IP address 10.1.1.1: count 3</p> </li> <li> <p>IP address 127.0.0.0: count 1</p> </li> </ul> </li> <li> <p>If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>HTTP method POST: count 2</p> </li> <li> <p>HTTP method GET: count 2</p> </li> </ul> </li> <li> <p>If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following: </p> <ul> <li> <p>IP address 10.1.1.1, HTTP method POST: count 1</p> </li> <li> <p>IP address 10.1.1.1, HTTP method GET: count 2</p> </li> <li> <p>IP address 127.0.0.0, HTTP method POST: count 1</p> </li> </ul> </li> </ul> <p>For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which WAF counts and rate-limits individually. </p> <p>You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule. </p> <p>You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group. </p> <p>For additional information about the options, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html">Rate limiting web requests using rate-based rules</a> in the <i>WAF Developer Guide</i>. </p> <p>If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that WAF is currently rate limiting for a rule through the API call <code>GetRateBasedStatementManagedKeys</code>. This option is not available for other aggregation configurations.</p> <p>WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF. </p>', ], ], 'RateBasedStatementAggregateKeyType' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$AggregateKeyType' => '<p>Setting that indicates how to aggregate the request counts. </p> <note> <p>Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. </p> </note> <ul> <li> <p> <code>CONSTANT</code> - Count and limit the requests that match the rate-based rule\'s scope-down statement. With this option, the counted requests aren\'t further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, WAF applies the rule action to all requests that satisfy the scope-down statement. </p> <p>With this option, you must configure the <code>ScopeDownStatement</code> property. </p> </li> <li> <p> <code>CUSTOM_KEYS</code> - Aggregate the request counts using one or more web request components as the aggregate keys.</p> <p>With this option, you must specify the aggregate keys in the <code>CustomKeys</code> property. </p> <p>To aggregate on only the IP address or only the forwarded IP address, don\'t use custom keys. Instead, set the aggregate key type to <code>IP</code> or <code>FORWARDED_IP</code>.</p> </li> <li> <p> <code>FORWARDED_IP</code> - Aggregate the request counts on the first IP address in an HTTP header. </p> <p>With this option, you must specify the header to use in the <code>ForwardedIPConfig</code> property. </p> <p>To aggregate on a combination of the forwarded IP address with other aggregate keys, use <code>CUSTOM_KEYS</code>. </p> </li> <li> <p> <code>IP</code> - Aggregate the request counts on the IP address from the web request origin.</p> <p>To aggregate on a combination of the IP address with other aggregate keys, use <code>CUSTOM_KEYS</code>. </p> </li> </ul>', ], ], 'RateBasedStatementCustomKey' => [ 'base' => '<p>Specifies a single custom aggregate key for a rate-base rule. </p> <note> <p>Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. </p> </note>', 'refs' => [ 'RateBasedStatementCustomKeys$member' => NULL, ], ], 'RateBasedStatementCustomKeys' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$CustomKeys' => '<p>Specifies the aggregate keys to use in a rate-base rule. </p>', ], ], 'RateBasedStatementManagedKeysIPSet' => [ 'base' => '<p>The set of IP addresses that are currently blocked for a <a>RateBasedStatement</a>. This is only available for rate-based rules that aggregate on just the IP address, with the <code>AggregateKeyType</code> set to <code>IP</code> or <code>FORWARDED_IP</code>.</p> <p>A rate-based rule applies its rule action to requests from IP addresses that are in the rule\'s managed keys list and that match the rule\'s scope-down statement. When a rule has no scope-down statement, it applies the action to all requests from the IP addresses that are in the list. The rule applies its rule action to rate limit the matching requests. The action is usually Block but it can be any valid rule action except for Allow. </p> <p>The maximum number of IP addresses that can be rate limited by a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, WAF limits those with the highest rates. </p>', 'refs' => [ 'GetRateBasedStatementManagedKeysResponse$ManagedKeysIPV4' => '<p>The keys that are of Internet Protocol version 4 (IPv4). </p>', 'GetRateBasedStatementManagedKeysResponse$ManagedKeysIPV6' => '<p>The keys that are of Internet Protocol version 6 (IPv6). </p>', ], ], 'RateLimit' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$Limit' => '<p>The limit on requests per 5-minute period for a single aggregation instance for the rate-based rule. If the rate-based statement includes a <code>ScopeDownStatement</code>, this limit is applied only to the requests that match the statement.</p> <p>Examples: </p> <ul> <li> <p>If you aggregate on just the IP address, this is the limit on requests from any single IP address. </p> </li> <li> <p>If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair. </p> </li> </ul>', ], ], 'RateLimitCookie' => [ 'base' => '<p>Specifies a cookie as an aggregate key for a rate-based rule. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance. </p>', 'refs' => [ 'RateBasedStatementCustomKey$Cookie' => '<p>Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance. </p>', ], ], 'RateLimitForwardedIP' => [ 'base' => '<p>Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule. Each distinct forwarded IP address contributes to the aggregation instance.</p> <p>This setting is used only in the <code>RateBasedStatementCustomKey</code> specification of a rate-based rule statement. When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your rate-based statement\'s <code>AggregateKeyType</code>. </p> <p>This data type supports using the forwarded IP address in the web request aggregation for a rate-based rule, in <code>RateBasedStatementCustomKey</code>. The JSON specification for using the forwarded IP address doesn\'t explicitly use this data type. </p> <p>JSON specification: <code>"ForwardedIP": {}</code> </p> <p>When you use this specification, you must also configure the forwarded IP address in the rate-based statement\'s <code>ForwardedIPConfig</code>. </p>', 'refs' => [ 'RateBasedStatementCustomKey$ForwardedIP' => '<p>Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.</p> <p>When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your rate-based statement\'s <code>AggregateKeyType</code>. </p> <p>With this option, you must specify the header to use in the rate-based rule\'s <code>ForwardedIPConfig</code> property. </p>', ], ], 'RateLimitHTTPMethod' => [ 'base' => '<p>Specifies the request\'s HTTP method as an aggregate key for a rate-based rule. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance. </p> <p>JSON specification: <code>"RateLimitHTTPMethod": {}</code> </p>', 'refs' => [ 'RateBasedStatementCustomKey$HTTPMethod' => '<p>Use the request\'s HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance. </p>', ], ], 'RateLimitHeader' => [ 'base' => '<p>Specifies a header as an aggregate key for a rate-based rule. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance. </p>', 'refs' => [ 'RateBasedStatementCustomKey$Header' => '<p>Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance. </p>', ], ], 'RateLimitIP' => [ 'base' => '<p>Specifies the IP address in the web request as an aggregate key for a rate-based rule. Each distinct IP address contributes to the aggregation instance. </p> <p>This setting is used only in the <code>RateBasedStatementCustomKey</code> specification of a rate-based rule statement. To use this in the custom key settings, you must specify at least one other key to use, along with the IP address. To aggregate on only the IP address, in your rate-based statement\'s <code>AggregateKeyType</code>, specify <code>IP</code>.</p> <p>JSON specification: <code>"RateLimitIP": {}</code> </p>', 'refs' => [ 'RateBasedStatementCustomKey$IP' => '<p>Use the request\'s originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.</p> <p>When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based statement\'s <code>AggregateKeyType</code>. </p>', ], ], 'RateLimitLabelNamespace' => [ 'base' => '<p>Specifies a label namespace to use as an aggregate key for a rate-based rule. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance. </p> <p>This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL. </p> <p>For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'RateBasedStatementCustomKey$LabelNamespace' => '<p>Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance. </p> <p>This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL. </p> <p>For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'RateLimitQueryArgument' => [ 'base' => '<p>Specifies a query argument in the request as an aggregate key for a rate-based rule. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance. </p>', 'refs' => [ 'RateBasedStatementCustomKey$QueryArgument' => '<p>Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance. </p>', ], ], 'RateLimitQueryString' => [ 'base' => '<p>Specifies the request\'s query string as an aggregate key for a rate-based rule. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance. </p>', 'refs' => [ 'RateBasedStatementCustomKey$QueryString' => '<p>Use the request\'s query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance. </p>', ], ], 'RateLimitUriPath' => [ 'base' => '<p>Specifies the request\'s URI path as an aggregate key for a rate-based rule. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance. </p>', 'refs' => [ 'RateBasedStatementCustomKey$UriPath' => '<p>Use the request\'s URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance. </p>', ], ], 'RedactedFields' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$RedactedFields' => '<p>The parts of the request that you want to keep out of the logs.</p> <p>For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting. </p> <p>Redaction applies only to the component that\'s specified in the rule\'s <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn\'t apply to rules that use the <code>Headers</code> <code>FieldToMatch</code>.</p> <note> <p>You can specify only the following fields for redaction: <code>UriPath</code>, <code>QueryString</code>, <code>SingleHeader</code>, and <code>Method</code>.</p> </note> <note> <p>This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration. </p> </note>', ], ], 'Regex' => [ 'base' => '<p>A single regular expression. This is used in a <a>RegexPatternSet</a>.</p>', 'refs' => [ 'RegularExpressionList$member' => NULL, ], ], 'RegexMatchStatement' => [ 'base' => '<p>A rule statement used to search web request components for a match against a single regular expression. </p>', 'refs' => [ 'Statement$RegexMatchStatement' => '<p>A rule statement used to search web request components for a match against a single regular expression. </p>', ], ], 'RegexPatternSet' => [ 'base' => '<p>Contains one or more regular expressions. </p> <p>WAF assigns an ARN to each <code>RegexPatternSet</code> that you create. To use a set in a rule, you provide the ARN to the <a>Rule</a> statement <a>RegexPatternSetReferenceStatement</a>. </p>', 'refs' => [ 'GetRegexPatternSetResponse$RegexPatternSet' => '<p/>', ], ], 'RegexPatternSetReferenceStatement' => [ 'base' => '<p>A rule statement used to search web request components for matches with regular expressions. To use this, create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.</p> <p>Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', 'refs' => [ 'Statement$RegexPatternSetReferenceStatement' => '<p>A rule statement used to search web request components for matches with regular expressions. To use this, create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.</p> <p>Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', ], ], 'RegexPatternSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRegexPatternSetsResponse$RegexPatternSets' => '<p>Array of regex pattern sets. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'RegexPatternSetSummary' => [ 'base' => '<p>High-level information about a <a>RegexPatternSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RegexPatternSet</code>, and the ARN, that you provide to the <a>RegexPatternSetReferenceStatement</a> to use the pattern set in a <a>Rule</a>.</p>', 'refs' => [ 'CreateRegexPatternSetResponse$Summary' => '<p>High-level information about a <a>RegexPatternSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RegexPatternSet</code>, and the ARN, that you provide to the <a>RegexPatternSetReferenceStatement</a> to use the pattern set in a <a>Rule</a>.</p>', 'RegexPatternSetSummaries$member' => NULL, ], ], 'RegexPatternString' => [ 'base' => NULL, 'refs' => [ 'Regex$RegexString' => '<p>The string representing the regular expression.</p>', 'RegexMatchStatement$RegexString' => '<p>The string representing the regular expression.</p>', ], ], 'RegistrationPagePathString' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesACFPRuleSet$RegistrationPagePath' => '<p>The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. </p> <note> <p>This page must accept <code>GET</code> text/html requests.</p> </note> <p>For example, for the URL <code>https://example.com/web/registration</code>, you would provide the path <code>/web/registration</code>. Registration page paths that start with the path that you provide are considered a match. For example <code>/web/registration</code> matches the registration paths <code>/web/registration</code>, <code>/web/registration/</code>, <code>/web/registrationPage</code>, and <code>/web/registration/thisPage</code>, but doesn\'t match the path <code>/home/web/registration</code> or <code>/website/registration</code>. </p>', ], ], 'RegularExpressionList' => [ 'base' => NULL, 'refs' => [ 'CreateRegexPatternSetRequest$RegularExpressionList' => '<p>Array of regular expression strings. </p>', 'RegexPatternSet$RegularExpressionList' => '<p>The regular expression patterns in the set.</p>', 'UpdateRegexPatternSetRequest$RegularExpressionList' => '<p/>', ], ], 'ReleaseNotes' => [ 'base' => NULL, 'refs' => [ 'MobileSdkRelease$ReleaseNotes' => '<p>Notes describing the release.</p>', ], ], 'ReleaseSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMobileSdkReleasesResponse$ReleaseSummaries' => '<p>The high level information for the available SDK releases. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'ReleaseSummary' => [ 'base' => '<p>High level information for an SDK release. </p>', 'refs' => [ 'ReleaseSummaries$member' => NULL, ], ], 'RequestBody' => [ 'base' => NULL, 'refs' => [ 'AssociationConfig$RequestBody' => '<p>Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types. </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>Example JSON: <code> { "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code> </p> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p>', ], ], 'RequestBodyAssociatedResourceTypeConfig' => [ 'base' => '<p>Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types. </p> <note> <p>You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.</p> </note> <p>Example JSON: <code> { "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code> </p> <p>For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).</p> <p>This is used in the <code>AssociationConfig</code> of the web ACL. </p>', 'refs' => [ 'RequestBody$value' => NULL, ], ], 'RequestInspection' => [ 'base' => '<p>The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. </p> <p>This is part of the <code>AWSManagedRulesATPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code>.</p> <p>In these settings, you specify how your application accepts login attempts by providing the request payload type and the names of the fields within the request body where the username and password are provided. </p>', 'refs' => [ 'AWSManagedRulesATPRuleSet$RequestInspection' => '<p>The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. </p>', ], ], 'RequestInspectionACFP' => [ 'base' => '<p>The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts. </p> <p>This is part of the <code>AWSManagedRulesACFPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code>.</p> <p>In these settings, you specify how your application accepts account creation attempts by providing the request payload type and the names of the fields within the request body where the username, password, email, and primary address and phone number fields are provided. </p>', 'refs' => [ 'AWSManagedRulesACFPRuleSet$RequestInspection' => '<p>The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts. </p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AssociateWebACLRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>', 'AssociateWebACLRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p> <p>The ARN must be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:<i>partition</i>:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Amazon API Gateway REST API: <code>arn:<i>partition</i>:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li> <li> <p>For an AppSync GraphQL API: <code>arn:<i>partition</i>:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li> <li> <p>For an Amazon Cognito user pool: <code>arn:<i>partition</i>:cognito-idp:<i>region</i>:<i>account-id</i>:userpool/<i>user-pool-id</i> </code> </p> </li> <li> <p>For an App Runner service: <code>arn:<i>partition</i>:apprunner:<i>region</i>:<i>account-id</i>:service/<i>apprunner-service-name</i>/<i>apprunner-service-id</i> </code> </p> </li> <li> <p>For an Amazon Web Services Verified Access instance: <code>arn:<i>partition</i>:ec2:<i>region</i>:<i>account-id</i>:verified-access-instance/<i>instance-id</i> </code> </p> </li> </ul>', 'DeleteFirewallManagerRuleGroupsRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL.</p>', 'DeleteLoggingConfigurationRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <a>LoggingConfiguration</a>.</p>', 'DeletePermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'DescribeManagedRuleGroupResponse$SnsTopicArn' => '<p>The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that\'s used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer Guide</a>.</p>', 'DisassociateWebACLRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p> <p>The ARN must be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:<i>partition</i>:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Amazon API Gateway REST API: <code>arn:<i>partition</i>:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li> <li> <p>For an AppSync GraphQL API: <code>arn:<i>partition</i>:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li> <li> <p>For an Amazon Cognito user pool: <code>arn:<i>partition</i>:cognito-idp:<i>region</i>:<i>account-id</i>:userpool/<i>user-pool-id</i> </code> </p> </li> <li> <p>For an App Runner service: <code>arn:<i>partition</i>:apprunner:<i>region</i>:<i>account-id</i>:service/<i>apprunner-service-name</i>/<i>apprunner-service-id</i> </code> </p> </li> <li> <p>For an Amazon Web Services Verified Access instance: <code>arn:<i>partition</i>:ec2:<i>region</i>:<i>account-id</i>:verified-access-instance/<i>instance-id</i> </code> </p> </li> </ul>', 'GetLoggingConfigurationRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.</p>', 'GetPermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>', 'GetRuleGroupRequest$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'GetSampledRequestsRequest$WebAclArn' => '<p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>', 'GetWebACLForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose web ACL you want to retrieve. </p> <p>The ARN must be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:<i>partition</i>:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Amazon API Gateway REST API: <code>arn:<i>partition</i>:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li> <li> <p>For an AppSync GraphQL API: <code>arn:<i>partition</i>:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li> <li> <p>For an Amazon Cognito user pool: <code>arn:<i>partition</i>:cognito-idp:<i>region</i>:<i>account-id</i>:userpool/<i>user-pool-id</i> </code> </p> </li> <li> <p>For an App Runner service: <code>arn:<i>partition</i>:apprunner:<i>region</i>:<i>account-id</i>:service/<i>apprunner-service-name</i>/<i>apprunner-service-id</i> </code> </p> </li> <li> <p>For an Amazon Web Services Verified Access instance: <code>arn:<i>partition</i>:ec2:<i>region</i>:<i>account-id</i>:verified-access-instance/<i>instance-id</i> </code> </p> </li> </ul>', 'IPSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'IPSetReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.</p>', 'IPSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ListResourcesForWebACLRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'LogDestinationConfigs$member' => NULL, 'LoggingConfiguration$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>', 'ManagedProductDescriptor$SnsTopicArn' => '<p>The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that\'s used to provide notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer Guide</a>.</p>', 'ManagedRuleSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ManagedRuleSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ManagedRuleSetVersion$AssociatedRuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the vendor rule group that\'s used to define the published version of your managed rule group. </p>', 'PutPermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the <a>RuleGroup</a> to which you want to attach the policy.</p>', 'RegexPatternSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RegexPatternSetReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.</p>', 'RegexPatternSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ResourceArns$member' => NULL, 'RuleGroup$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RuleGroupReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RuleGroupSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'TagInfoForResource$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'VersionToPublish$AssociatedRuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the vendor\'s rule group that\'s used in the published managed rule group version. </p>', 'WebACL$ARN' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>', 'WebACLSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'ListResourcesForWebACLResponse$ResourceArns' => '<p>The array of Amazon Resource Names (ARNs) of the associated resources.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ListResourcesForWebACLRequest$ResourceType' => '<p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <note> <p>If you don\'t provide a resource type, the call uses the resource type <code>APPLICATION_LOAD_BALANCER</code>. </p> </note> <p>Default: <code>APPLICATION_LOAD_BALANCER</code> </p>', ], ], 'ResponseCode' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$ResponseCode' => '<p>The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If the token is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.</p>', 'ChallengeResponse$ResponseCode' => '<p>The HTTP response code indicating the status of the challenge token in the web request. If the token is missing, invalid, or expired, this code is <code>202 Request Accepted</code>.</p>', ], ], 'ResponseContent' => [ 'base' => NULL, 'refs' => [ 'CustomResponseBody$Content' => '<p>The payload of the custom response. </p> <p>You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'ResponseContentType' => [ 'base' => NULL, 'refs' => [ 'CustomResponseBody$ContentType' => '<p>The type of content in the payload that you are defining in the <code>Content</code> string.</p>', ], ], 'ResponseInspection' => [ 'base' => '<p>The criteria for inspecting responses to login requests and account creation requests, used by the ATP and ACFP rule groups to track login and account creation success and failure rates. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note> <p>The rule groups evaluates the responses that your protected resources send back to client login and account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses with too much suspicious activity in a short amount of time. </p> <p>This is part of the <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code> configurations in <code>ManagedRuleGroupConfig</code>.</p> <p>Enable response inspection by configuring exactly one component of the response to inspect, for example, <code>Header</code> or <code>StatusCode</code>. You can\'t configure more than one component for inspection. If you don\'t configure any of the response inspection options, response inspection is disabled. </p>', 'refs' => [ 'AWSManagedRulesACFPRuleSet$ResponseInspection' => '<p>The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note> <p>The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time. </p>', 'AWSManagedRulesATPRuleSet$ResponseInspection' => '<p>The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note> <p>The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time. </p>', ], ], 'ResponseInspectionBodyContains' => [ 'base' => '<p>Configures inspection of the response body. WAF can inspect the first 65,536 bytes (64 KB) of the response body. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code>. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note>', 'refs' => [ 'ResponseInspection$BodyContains' => '<p>Configures inspection of the response body for success and failure indicators. WAF can inspect the first 65,536 bytes (64 KB) of the response body. </p>', ], ], 'ResponseInspectionBodyContainsFailureStrings' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionBodyContains$FailureStrings' => '<p>Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings. </p> <p>JSON example: <code>"FailureStrings": [ "Request failed" ]</code> </p>', ], ], 'ResponseInspectionBodyContainsSuccessStrings' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionBodyContains$SuccessStrings' => '<p>Strings in the body of the response that indicate a successful login or account creation attempt. To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings. </p> <p>JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code> </p>', ], ], 'ResponseInspectionHeader' => [ 'base' => '<p>Configures inspection of the response header. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code>. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note>', 'refs' => [ 'ResponseInspection$Header' => '<p>Configures inspection of the response header for success and failure indicators. </p>', ], ], 'ResponseInspectionHeaderFailureValues' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionHeader$FailureValues' => '<p>Values in the response header with the specified name that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values. </p> <p>JSON examples: <code>"FailureValues": [ "LoginFailed", "Failed login" ]</code> and <code>"FailureValues": [ "AccountCreationFailed" ]</code> </p>', ], ], 'ResponseInspectionHeaderName' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionHeader$Name' => '<p>The name of the header to match against. The name must be an exact match, including case.</p> <p>JSON example: <code>"Name": [ "RequestResult" ]</code> </p>', ], ], 'ResponseInspectionHeaderSuccessValues' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionHeader$SuccessValues' => '<p>Values in the response header with the specified name that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values. </p> <p>JSON examples: <code>"SuccessValues": [ "LoginPassed", "Successful login" ]</code> and <code>"SuccessValues": [ "AccountCreated", "Successful account creation" ]</code> </p>', ], ], 'ResponseInspectionJson' => [ 'base' => '<p>Configures inspection of the response JSON. WAF can inspect the first 65,536 bytes (64 KB) of the response JSON. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code>. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note>', 'refs' => [ 'ResponseInspection$Json' => '<p>Configures inspection of the response JSON for success and failure indicators. WAF can inspect the first 65,536 bytes (64 KB) of the response JSON. </p>', ], ], 'ResponseInspectionJsonFailureValues' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionJson$FailureValues' => '<p>Values for the specified identifier in the response JSON that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values. </p> <p>JSON example: <code>"FailureValues": [ "False", "Failed" ]</code> </p>', ], ], 'ResponseInspectionJsonSuccessValues' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionJson$SuccessValues' => '<p>Values for the specified identifier in the response JSON that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values. </p> <p>JSON example: <code>"SuccessValues": [ "True", "Succeeded" ]</code> </p>', ], ], 'ResponseInspectionStatusCode' => [ 'base' => '<p>Configures inspection of the response status code. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code>. </p> <note> <p>Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.</p> </note>', 'refs' => [ 'ResponseInspection$StatusCode' => '<p>Configures inspection of the response status code for success and failure indicators. </p>', ], ], 'ResponseInspectionStatusCodeFailureCodes' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionStatusCode$FailureCodes' => '<p>Status codes in the response that indicate a failed login or account creation attempt. To be counted as a failure, the response status code must match one of these. Each code must be unique among the success and failure status codes. </p> <p>JSON example: <code>"FailureCodes": [ 400, 404 ]</code> </p>', ], ], 'ResponseInspectionStatusCodeSuccessCodes' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionStatusCode$SuccessCodes' => '<p>Status codes in the response that indicate a successful login or account creation attempt. To be counted as a success, the response status code must match one of these. Each code must be unique among the success and failure status codes. </p> <p>JSON example: <code>"SuccessCodes": [ 200, 201 ]</code> </p>', ], ], 'ResponseStatusCode' => [ 'base' => NULL, 'refs' => [ 'CustomResponse$ResponseCode' => '<p>The HTTP status code to return to the client. </p> <p>For a list of status codes that you can use in your custom responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported status codes for custom response</a> in the <i>WAF Developer Guide</i>. </p>', 'SampledHTTPRequest$ResponseCodeSent' => '<p>The response code that was sent for the request.</p>', ], ], 'Rule' => [ 'base' => '<p>A single rule, which you can use in a <a>WebACL</a> or <a>RuleGroup</a> to identify web requests that you want to manage in some way. Each rule includes one top-level <a>Statement</a> that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleAction' => [ 'base' => '<p>The action that WAF should take on a web request when it matches a rule\'s statement. Settings at the web ACL level can override the rule action setting. </p>', 'refs' => [ 'Rule$Action' => '<p>The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting. </p> <p>This is used only for rules whose statements do not reference a rule group. Rule statements that reference a rule group include <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <p>You must specify either this <code>Action</code> setting or the rule <code>OverrideAction</code> setting, but not both:</p> <ul> <li> <p>If the rule statement does not reference a rule group, use this rule action setting and not the rule override action setting. </p> </li> <li> <p>If the rule statement references a rule group, use the override action setting and not this action setting. </p> </li> </ul>', 'RuleActionOverride$ActionToUse' => '<p>The override action to use, in place of the configured action of the rule in the rule group. </p>', 'RuleSummary$Action' => '<p>The action that WAF should take on a web request when it matches a rule\'s statement. Settings at the web ACL level can override the rule action setting. </p>', ], ], 'RuleActionOverride' => [ 'base' => '<p>Action setting to use in the place of a rule action that is configured inside the rule group. You specify one override for each rule whose action you want to change. </p> <p>You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.</p>', 'refs' => [ 'RuleActionOverrides$member' => NULL, ], ], 'RuleActionOverrides' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupStatement$RuleActionOverrides' => '<p>Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. </p> <p>You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.</p>', 'RuleGroupReferenceStatement$RuleActionOverrides' => '<p>Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. </p> <p>You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.</p>', ], ], 'RuleGroup' => [ 'base' => '<p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>', 'refs' => [ 'GetRuleGroupResponse$RuleGroup' => '<p/>', ], ], 'RuleGroupReferenceStatement' => [ 'base' => '<p>A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.</p> <p>You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.</p>', 'refs' => [ 'FirewallManagerStatement$RuleGroupReferenceStatement' => '<p>A statement used by Firewall Manager to run the rules that are defined in a rule group. This is managed by Firewall Manager for an Firewall Manager WAF policy.</p>', 'Statement$RuleGroupReferenceStatement' => '<p>A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.</p> <p>You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.</p>', ], ], 'RuleGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsResponse$RuleGroups' => '<p>Array of rule groups. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'RuleGroupSummary' => [ 'base' => '<p>High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'refs' => [ 'CreateRuleGroupResponse$Summary' => '<p>High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'RuleGroupSummaries$member' => NULL, ], ], 'RulePriority' => [ 'base' => NULL, 'refs' => [ 'FirewallManagerRuleGroup$Priority' => '<p>If you define more than one rule group in the first or last Firewall Manager rule groups, WAF evaluates each request against the rule groups in order, starting from the lowest priority setting. The priorities don\'t need to be consecutive, but they must all be different.</p>', 'Rule$Priority' => '<p>If you define more than one <code>Rule</code> in a <code>WebACL</code>, WAF evaluates each request against the <code>Rules</code> in order based on the value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities don\'t need to be consecutive, but they must all be different.</p>', ], ], 'RuleSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$Rules' => '<p/>', ], ], 'RuleSummary' => [ 'base' => '<p>High-level information about a <a>Rule</a>, returned by operations like <a>DescribeManagedRuleGroup</a>. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'refs' => [ 'RuleSummaries$member' => NULL, ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityRequest$Rules' => '<p>An array of <a>Rule</a> that you\'re configuring to use in a rule group or web ACL. </p>', 'CreateRuleGroupRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'CreateWebACLRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'RuleGroup$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'UpdateRuleGroupRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'UpdateWebACLRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'WebACL$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to manage. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', ], ], 'SampleWeight' => [ 'base' => NULL, 'refs' => [ 'SampledHTTPRequest$Weight' => '<p>A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web requests as a result that has a weight of <code>1</code>.</p>', ], ], 'SampledHTTPRequest' => [ 'base' => '<p>Represents a single sampled web request. The response from <a>GetSampledRequests</a> includes a <code>SampledHTTPRequests</code> complex type that appears as <code>SampledRequests</code> in the response syntax. <code>SampledHTTPRequests</code> contains an array of <code>SampledHTTPRequest</code> objects.</p>', 'refs' => [ 'SampledHTTPRequests$member' => NULL, ], ], 'SampledHTTPRequests' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsResponse$SampledRequests' => '<p>A complex type that contains detailed information about each of the requests in the sample.</p>', ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateAPIKeyRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteAPIKeyRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DescribeAllManagedProductsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DescribeManagedProductsByVendorRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DescribeManagedRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetDecryptedAPIKeyRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetManagedRuleSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRateBasedStatementManagedKeysRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetSampledRequestsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListAPIKeysRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListAvailableManagedRuleGroupVersionsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListAvailableManagedRuleGroupsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListIPSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListLoggingConfigurationsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListManagedRuleSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListRegexPatternSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListRuleGroupsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListWebACLsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'PutManagedRuleSetVersionsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', ], ], 'SearchString' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$SearchString' => '<p>A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in <a>FieldToMatch</a>. The maximum length of the value is 200 bytes.</p> <p>Valid values depend on the component that you specify for inspection in <code>FieldToMatch</code>:</p> <ul> <li> <p> <code>Method</code>: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request. </p> </li> <li> <p> <code>UriPath</code>: The value that you want WAF to search for in the URI path, for example, <code>/images/daily-ad.jpg</code>. </p> </li> <li> <p> <code>JA3Fingerprint</code>: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request\'s JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client\'s TLS configuration. You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code>. </p> <p>You can obtain the JA3 fingerprint for client requests from the web ACL logs. If WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <i>WAF Developer Guide</i>. </p> </li> <li> <p> <code>HeaderOrder</code>: The list of header names to match for. WAF creates a string that contains the ordered list of header names, from the headers in the web request, and then matches against that string. </p> </li> </ul> <p>If <code>SearchString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p> <p> <b>If you\'re using the WAF API</b> </p> <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 200 bytes.</p> <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>SearchString</code>.</p> <p> <b>If you\'re using the CLI or one of the Amazon Web Services SDKs</b> </p> <p>The value that you want WAF to search for. The SDK automatically base64 encodes the value.</p>', ], ], 'SensitivityLevel' => [ 'base' => NULL, 'refs' => [ 'SqliMatchStatement$SensitivityLevel' => '<p>The sensitivity that you want WAF to use to inspect for SQL injection attacks. </p> <p> <code>HIGH</code> detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html">Testing and tuning</a> in the <i>WAF Developer Guide</i>.</p> <p> <code>LOW</code> is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives. </p> <p>Default: <code>LOW</code> </p>', ], ], 'SingleCookieName' => [ 'base' => NULL, 'refs' => [ 'CookieNames$member' => NULL, ], ], 'SingleHeader' => [ 'base' => '<p>Inspect one of the headers in the web request, identified by name, for example, <code>User-Agent</code> or <code>Referer</code>. The name isn\'t case sensitive.</p> <p>You can filter and inspect all headers with the <code>FieldToMatch</code> setting <code>Headers</code>.</p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code> </p>', 'refs' => [ 'FieldToMatch$SingleHeader' => '<p>Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code>. This setting isn\'t case sensitive.</p> <p>Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code> </p> <p>Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code> setting. </p>', ], ], 'SingleQueryArgument' => [ 'base' => '<p>Inspect one query argument in the web request, identified by name, for example <i>UserName</i> or <i>SalesRegion</i>. The name isn\'t case sensitive. </p> <p>This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code> </p>', 'refs' => [ 'FieldToMatch$SingleQueryArgument' => '<p>Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn\'t case sensitive. </p> <p>Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code> </p>', ], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'SizeConstraintStatement$Size' => '<p>The size, in byte, to compare to the request part, after any transformations.</p>', ], ], 'SizeConstraintStatement' => [ 'base' => '<p>A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. </p> <p>If you configure WAF to inspect the request body, WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see <code>Body</code> and <code>JsonBody</code> settings for the <code>FieldToMatch</code> data type. </p> <p>If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>', 'refs' => [ 'Statement$SizeConstraintStatement' => '<p>A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. </p> <p>If you configure WAF to inspect the request body, WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see <code>Body</code> and <code>JsonBody</code> settings for the <code>FieldToMatch</code> data type. </p> <p>If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>', ], ], 'SizeInspectionLimit' => [ 'base' => NULL, 'refs' => [ 'RequestBodyAssociatedResourceTypeConfig$DefaultSizeInspectionLimit' => '<p>Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. </p> <p>Default: <code>16 KB (16,384 bytes)</code> </p>', ], ], 'SolveTimestamp' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$SolveTimestamp' => '<p>The time that the <code>CAPTCHA</code> was last solved for the supplied token. </p>', 'ChallengeResponse$SolveTimestamp' => '<p>The time that the challenge was last solved for the supplied token. </p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'WAFLimitsExceededException$SourceType' => '<p>Source type for the exception. </p>', ], ], 'SqliMatchStatement' => [ 'base' => '<p>A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it. </p>', 'refs' => [ 'Statement$SqliMatchStatement' => '<p>A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it. </p>', ], ], 'Statement' => [ 'base' => '<p>The processing guidance for a <a>Rule</a>, used by WAF to determine whether a web request matches the rule. </p> <p>For example specifications, see the examples section of <a>CreateWebACL</a>.</p>', 'refs' => [ 'ManagedRuleGroupStatement$ScopeDownStatement' => '<p>An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable <a>Statement</a> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement. </p>', 'NotStatement$Statement' => '<p>The statement to negate. You can use any statement that can be nested.</p>', 'RateBasedStatement$ScopeDownStatement' => '<p>An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable <a>Statement</a> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement. </p>', 'Rule$Statement' => '<p>The WAF processing statement for the rule, for example <a>ByteMatchStatement</a> or <a>SizeConstraintStatement</a>. </p>', 'Statements$member' => NULL, ], ], 'Statements' => [ 'base' => NULL, 'refs' => [ 'AndStatement$Statements' => '<p>The statements to combine with AND logic. You can use any statements that can be nested. </p>', 'OrStatement$Statements' => '<p>The statements to combine with OR logic. You can use any statements that can be nested.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AWSManagedRulesATPRuleSet$LoginPath' => '<p>The path of the login endpoint for your application. For example, for the URL <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>. Login paths that start with the path that you provide are considered a match. For example <code>/web/login</code> matches the login paths <code>/web/login</code>, <code>/web/login/</code>, <code>/web/loginPage</code>, and <code>/web/login/thisPage</code>, but doesn\'t match the login path <code>/home/web/login</code> or <code>/website/login</code>.</p> <p>The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.</p>', ], ], 'SuccessCode' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionStatusCodeSuccessCodes$member' => NULL, ], ], 'SuccessValue' => [ 'base' => NULL, 'refs' => [ 'ResponseInspectionBodyContainsSuccessStrings$member' => NULL, 'ResponseInspectionHeaderSuccessValues$member' => NULL, 'ResponseInspectionJsonSuccessValues$member' => NULL, ], ], 'Tag' => [ 'base' => '<p>A tag associated with an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagInfoForResource' => [ 'base' => '<p>The collection of tagging definitions for an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'refs' => [ 'ListTagsForResourceResponse$TagInfoForResource' => '<p>The collection of tagging definitions for the resource. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>An array of keys identifying the tags to disassociate from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateRegexPatternSetRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateRuleGroupRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateWebACLRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'MobileSdkRelease$Tags' => '<p>Tags that are associated with the release. </p>', 'TagInfoForResource$TagList' => '<p>The array of <a>Tag</a> objects defined for the resource. </p>', 'TagResourceRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>', ], ], 'TextTransformation' => [ 'base' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. </p>', 'refs' => [ 'TextTransformations$member' => NULL, ], ], 'TextTransformationPriority' => [ 'base' => NULL, 'refs' => [ 'TextTransformation$Priority' => '<p>Sets the relative processing order for multiple transformations. WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don\'t need to be consecutive, but they must all be different. </p>', ], ], 'TextTransformationType' => [ 'base' => NULL, 'refs' => [ 'TextTransformation$Type' => '<p>For detailed descriptions of each of the transformation types, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text transformations</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'TextTransformations' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RateLimitCookie$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RateLimitHeader$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RateLimitQueryArgument$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RateLimitQueryString$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RateLimitUriPath$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RegexMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'RegexPatternSetReferenceStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'SizeConstraintStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'SqliMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', 'XssMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they\'re used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents. </p>', ], ], 'TimeWindow' => [ 'base' => '<p>In a <a>GetSampledRequests</a> request, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which you want WAF to return a sample of web requests.</p> <p>You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p> <p>In a <a>GetSampledRequests</a> response, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which WAF actually returned a sample of web requests. WAF gets the specified number of requests from among the first 5,000 requests that your Amazon Web Services resource receives during the specified time period. If your resource receives more than 5,000 requests during that period, WAF stops sampling after the 5,000th request. In that case, <code>EndTime</code> is the time that WAF received the 5,000th request.</p>', 'refs' => [ 'GetSampledRequestsRequest$TimeWindow' => '<p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that\'s earlier than three hours ago, WAF sets it to three hours ago.</p>', 'GetSampledRequestsResponse$TimeWindow' => '<p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your Amazon Web Services resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>', ], ], 'TimeWindowDay' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleSetVersion$ForecastedLifetime' => '<p>The amount of time you expect this version of your managed rule group to last, in days. </p>', 'VersionToPublish$ForecastedLifetime' => '<p>The amount of time the vendor expects this version of the managed rule group to last, in days. </p>', ], ], 'TimeWindowSecond' => [ 'base' => NULL, 'refs' => [ 'ImmunityTimeProperty$ImmunityTime' => '<p>The amount of time, in seconds, that a <code>CAPTCHA</code> or challenge timestamp is considered valid by WAF. The default setting is 300. </p> <p>For the Challenge action, the minimum setting is 300. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'APIKeySummary$CreationTimestamp' => '<p>The date and time that the key was created. </p>', 'GetDecryptedAPIKeyResponse$CreationTimestamp' => '<p>The date and time that the key was created. </p>', 'ManagedRuleGroupVersion$LastUpdateTimestamp' => '<p>The date and time that the managed rule group owner updated the rule group version information. </p>', 'ManagedRuleSetVersion$PublishTimestamp' => '<p>The time that you first published this version. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'ManagedRuleSetVersion$LastUpdateTimestamp' => '<p>The last time that you updated this version. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'ManagedRuleSetVersion$ExpiryTimestamp' => '<p>The time that this version is set to expire.</p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'MobileSdkRelease$Timestamp' => '<p>The timestamp of the release. </p>', 'ReleaseSummary$Timestamp' => '<p>The timestamp of the release. </p>', 'SampledHTTPRequest$Timestamp' => '<p>The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).</p>', 'TimeWindow$StartTime' => '<p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your Amazon Web Services resource received. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>', 'TimeWindow$EndTime' => '<p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your Amazon Web Services resource received. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$ExpiryTimestamp' => '<p>The time that you want the version to expire.</p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$ExpiryTimestamp' => '<p>The time that the version will expire. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', ], ], 'TokenDomain' => [ 'base' => NULL, 'refs' => [ 'APIKeyTokenDomains$member' => NULL, 'TokenDomains$member' => NULL, ], ], 'TokenDomains' => [ 'base' => NULL, 'refs' => [ 'APIKeySummary$TokenDomains' => '<p>The token domains that are defined in this API key. </p>', 'CreateWebACLRequest$TokenDomains' => '<p>Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don\'t specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource\'s host domain plus all domains in the token domain list, including their prefixed subdomains.</p> <p>Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code> </p> <p>Public suffixes aren\'t allowed. For example, you can\'t use <code>gov.au</code> or <code>co.uk</code> as token domains.</p>', 'GetDecryptedAPIKeyResponse$TokenDomains' => '<p>The token domains that are defined in this API key. </p>', 'UpdateWebACLRequest$TokenDomains' => '<p>Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don\'t specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource\'s host domain plus all domains in the token domain list, including their prefixed subdomains.</p> <p>Example JSON: <code>"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }</code> </p> <p>Public suffixes aren\'t allowed. For example, you can\'t use <code>gov.au</code> or <code>co.uk</code> as token domains.</p>', 'WebACL$TokenDomains' => '<p>Specifies the domains that WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When WAF provides a token, it uses the domain of the Amazon Web Services resource that the web ACL is protecting. If you don\'t specify a list of token domains, WAF accepts tokens only for the domain of the protected resource. With a token domain list, WAF accepts the resource\'s host domain plus all domains in the token domain list, including their prefixed subdomains.</p>', ], ], 'URIString' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$URI' => '<p>The URI path of the request, which identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedRuleSetVersionExpiryDateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedRuleSetVersionExpiryDateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'UriPath' => [ 'base' => '<p>Inspect the path component of the URI of the web request. This is the part of the web request that identifies a resource. For example, <code>/images/daily-ad.jpg</code>.</p> <p>This is used in the <a>FieldToMatch</a> specification for some web request component types. </p> <p>JSON specification: <code>"UriPath": {}</code> </p>', 'refs' => [ 'FieldToMatch$UriPath' => '<p>Inspect the request URI path. This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p>', ], ], 'UsernameField' => [ 'base' => '<p>The name of the field in the request payload that contains your customer\'s username. </p> <p>This data type is used in the <code>RequestInspection</code> and <code>RequestInspectionACFP</code> data types. </p>', 'refs' => [ 'ManagedRuleGroupConfig$UsernameField' => '<note> <p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code>. </p> </note>', 'RequestInspection$UsernameField' => '<p>The name of the field in the request payload that contains your customer\'s username. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field specification is <code>/form/username</code>. </p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>username1</code>, the username field specification is <code>username1</code> </p> </li> </ul>', 'RequestInspectionACFP$UsernameField' => '<p>The name of the field in the request payload that contains your customer\'s username. </p> <p>How you specify this depends on the request inspection payload type.</p> <ul> <li> <p>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code>, the username field specification is <code>/form/username</code>. </p> </li> <li> <p>For form encoded payload types, use the HTML form names.</p> <p>For example, for an HTML form with the input element named <code>username1</code>, the username field specification is <code>username1</code> </p> </li> </ul>', ], ], 'VendorName' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedProductsByVendorRequest$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', 'DescribeManagedRuleGroupRequest$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', 'ManagedProductDescriptor$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', 'ManagedRuleGroupStatement$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', 'ManagedRuleGroupSummary$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.</p>', ], ], 'VersionKeyString' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupRequest$VersionName' => '<p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don\'t provide this, WAF uses the vendor\'s default version. </p>', 'DescribeManagedRuleGroupResponse$VersionName' => '<p>The managed rule group\'s version. </p>', 'GenerateMobileSdkReleaseUrlRequest$ReleaseVersion' => '<p>The release version. For the latest available version, specify <code>LATEST</code>.</p>', 'GetMobileSdkReleaseRequest$ReleaseVersion' => '<p>The release version. For the latest available version, specify <code>LATEST</code>.</p>', 'ListAvailableManagedRuleGroupVersionsResponse$CurrentDefaultVersion' => '<p>The name of the version that\'s currently set as the default. </p>', 'ManagedRuleGroupStatement$Version' => '<p>The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don\'t specify this, WAF uses the vendor\'s default version, and then keeps the version at the vendor\'s default when the vendor updates the managed rule group settings. </p>', 'ManagedRuleGroupVersion$Name' => '<p>The version name. </p>', 'ManagedRuleSet$RecommendedVersion' => '<p>The version that you would like your customers to use.</p>', 'MobileSdkRelease$ReleaseVersion' => '<p>The release version. </p>', 'PublishedVersions$key' => NULL, 'PutManagedRuleSetVersionsRequest$RecommendedVersion' => '<p>The version of the named managed rule group that you\'d like your customers to choose, from among your version offerings. </p>', 'ReleaseSummary$ReleaseVersion' => '<p>The release version. </p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$VersionToExpire' => '<p>The version that you want to remove from your list of offerings for the named managed rule group. </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$ExpiringVersion' => '<p>The version that is set to expire. </p>', 'VersionsToPublish$key' => NULL, ], ], 'VersionToPublish' => [ 'base' => '<p>A version of the named managed rule group, that the rule group\'s vendor publishes for use by customers. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'VersionsToPublish$value' => NULL, ], ], 'VersionsToPublish' => [ 'base' => NULL, 'refs' => [ 'PutManagedRuleSetVersionsRequest$VersionsToPublish' => '<p>The versions of the named managed rule group that you want to offer to your customers. </p>', ], ], 'VisibilityConfig' => [ 'base' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'refs' => [ 'CreateRuleGroupRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'CreateWebACLRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'FirewallManagerRuleGroup$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'Rule$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p> <p>If you change the name of a <code>Rule</code> after you create it and you want the rule\'s metric name to reflect the change, update the metric name as well. WAF doesn\'t automatically update the metric name. </p>', 'RuleGroup$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'UpdateRuleGroupRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'UpdateWebACLRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'WebACL$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', ], ], 'WAFAssociatedItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>', 'refs' => [], ], 'WAFConfigurationWarningException' => [ 'base' => '<p>The operation failed because you are inspecting the web request body, headers, or cookies without specifying how to handle oversize components. Rules that inspect the body must either provide an <code>OversizeHandling</code> configuration or they must be preceded by a <code>SizeConstraintStatement</code> that blocks the body content from being too large. Rules that inspect the headers or cookies must provide an <code>OversizeHandling</code> configuration. </p> <p>Provide the handling configuration and retry your operation.</p> <p>Alternately, you can suppress this warning by adding the following tag to the resource that you provide to this operation: <code>Tag</code> (key:<code>WAF:OversizeFieldsHandlingConstraintOptOut</code>, value:<code>true</code>).</p>', 'refs' => [], ], 'WAFDuplicateItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>', 'refs' => [], ], 'WAFExpiredManagedRuleGroupVersionException' => [ 'base' => '<p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <a>ListAvailableManagedRuleGroupVersions</a>.</p>', 'refs' => [], ], 'WAFInternalErrorException' => [ 'base' => '<p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>', 'refs' => [], ], 'WAFInvalidOperationException' => [ 'base' => '<p>The operation isn\'t valid. </p>', 'refs' => [], ], 'WAFInvalidParameterException' => [ 'base' => '<p>The operation failed because WAF didn\'t recognize a parameter in the request. For example: </p> <ul> <li> <p>You specified a parameter name or value that isn\'t valid.</p> </li> <li> <p>Your nested statement isn\'t valid. You might have tried to nest a statement that can’t be nested. </p> </li> <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn\'t among the types available at <a>DefaultAction</a>.</p> </li> <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can\'t be associated.</p> </li> </ul>', 'refs' => [], ], 'WAFInvalidPermissionPolicyException' => [ 'base' => '<p>The operation failed because the specified policy isn\'t in the proper format. </p> <p>The policy specifications must conform to the following:</p> <ul> <li> <p>The policy must be composed using IAM Policy version 2012-10-17.</p> </li> <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li> <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li> <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li> <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>', 'refs' => [], ], 'WAFInvalidResourceException' => [ 'base' => '<p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>', 'refs' => [], ], 'WAFLimitsExceededException' => [ 'base' => '<p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [], ], 'WAFLogDestinationPermissionIssueException' => [ 'base' => '<p>The operation failed because you don\'t have the permissions that your logging configuration requires. For information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [], ], 'WAFNonexistentItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because your resource doesn\'t exist. If you\'ve just created a resource that you\'re using in this operation, you might just need to wait a few minutes. It can take from a few seconds to a number of minutes for changes to propagate. </p>', 'refs' => [], ], 'WAFOptimisticLockException' => [ 'base' => '<p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>', 'refs' => [], ], 'WAFServiceLinkedRoleErrorException' => [ 'base' => '<p>WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>', 'refs' => [], ], 'WAFSubscriptionNotFoundException' => [ 'base' => '<p>You tried to use a managed rule group that\'s available by subscription, but you aren\'t subscribed to it yet. </p>', 'refs' => [], ], 'WAFTagOperationException' => [ 'base' => '<p>An error occurred during the tagging operation. Retry your request.</p>', 'refs' => [], ], 'WAFTagOperationInternalErrorException' => [ 'base' => '<p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>', 'refs' => [], ], 'WAFUnavailableEntityException' => [ 'base' => '<p>WAF couldn’t retrieve a resource that you specified for this operation. If you\'ve just created a resource that you\'re using in this operation, you might just need to wait a few minutes. It can take from a few seconds to a number of minutes for changes to propagate. Verify the resources that you are specifying in your request parameters and then retry the operation.</p>', 'refs' => [], ], 'WAFUnsupportedAggregateKeyTypeException' => [ 'base' => '<p>The rule that you\'ve named doesn\'t aggregate solely on the IP address or solely on the forwarded IP address. This call is only available for rate-based rules with an <code>AggregateKeyType</code> setting of <code>IP</code> or <code>FORWARDED_IP</code>.</p>', 'refs' => [], ], 'WebACL' => [ 'base' => '<p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has a statement that defines what to look for in web requests and an action that WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance. </p>', 'refs' => [ 'GetWebACLForResourceResponse$WebACL' => '<p>The web ACL that is associated with the resource. If there is no associated resource, WAF returns a null web ACL.</p>', 'GetWebACLResponse$WebACL' => '<p>The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or create a new one.</p>', ], ], 'WebACLSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWebACLsResponse$WebACLs' => '<p>Array of web ACLs. If you specified a <code>Limit</code> in your request, this might not be the full list. </p>', ], ], 'WebACLSummary' => [ 'base' => '<p>High-level information about a <a>WebACL</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>WebACL</code>, and the ARN, that you provide to operations like <a>AssociateWebACL</a>.</p>', 'refs' => [ 'CreateWebACLResponse$Summary' => '<p>High-level information about a <a>WebACL</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>WebACL</code>, and the ARN, that you provide to operations like <a>AssociateWebACL</a>.</p>', 'WebACLSummaries$member' => NULL, ], ], 'XssMatchStatement' => [ 'base' => '<p>A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. </p>', 'refs' => [ 'Statement$XssMatchStatement' => '<p>A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. </p>', ], ], ],];
